import type {float, integer} from "../../bs-utils"

code`
#include <time.h>
`

code`
float get_time_ms() {
    static struct timespec start_time = {0};
    
    if (start_time.tv_sec == 0 && start_time.tv_nsec == 0) {
        timespec_get(&start_time, TIME_UTC);
    }

    struct timespec current_time;
    timespec_get(&current_time, TIME_UTC);

    double elapsed_s = current_time.tv_sec - start_time.tv_sec;
    double elapsed_ns = current_time.tv_nsec - start_time.tv_nsec;

    return (float)(elapsed_s * 1000.0 + elapsed_ns / 1000000.0);
}
`

export const getTimeMs = ():float => {
    const t: float = 0.0;
    code`_t = get_time_ms();`
    return t;
}