const BLOCK_SIZE = 32;
const DATA_LEN = 1024;

const DATA: integer[] = [ 137, 28, 196, 170, 4, 227, 217, 225, 112, 148, 41, 53, 42, 226, 232, 36, 215, 195, 169, 17, 42, 206, 218, 253, 75, 231, 134, 10, 196, 61, 35, 3, 52, 5, 55, 209, 8, 227, 1, 177, 253, 182, 69, 163, 164, 3, 100, 133, 235, 21, 79, 241, 211, 64, 12, 166, 137, 43, 64, 175, 124, 150, 65, 145, 49, 36, 172, 210, 93, 230, 70, 145, 152, 207, 170, 103, 227, 78, 177, 166, 3, 24, 150, 179, 123, 160, 103, 76, 9, 13, 117, 200, 204, 160, 237, 189, 183, 77, 8, 218, 147, 20, 239, 209, 128, 97, 160, 141, 225, 199, 8, 53, 191, 25, 44, 129, 200, 9, 171, 231, 225, 119, 71, 119, 73, 236, 65, 106, 15, 94, 137, 230, 226, 185, 0, 200, 184, 49, 196, 10, 147, 100, 91, 243, 93, 227, 23, 175, 195, 151, 129, 157, 28, 217, 29, 248, 59, 196, 128, 82, 120, 149, 238, 233, 79, 26, 109, 57, 245, 123, 147, 55, 161, 183, 59, 112, 232, 149, 71, 48, 71, 205, 186, 238, 192, 177, 23, 104, 220, 143, 36, 74, 26, 54, 200, 162, 56, 231, 50, 176, 66, 103, 83, 147, 106, 139, 4, 136, 119, 54, 113, 123, 58, 142, 103, 100, 36, 72, 214, 135, 18, 6, 101, 47, 246, 44, 65, 37, 81, 46, 187, 205, 126, 49, 0, 52, 75, 78, 0, 151, 88, 157, 174, 22, 214, 221, 244, 13, 11, 15, 54, 78, 65, 121, 58, 244, 124, 233, 4, 240, 154, 30, 27, 132, 239, 89, 7, 228, 128, 108, 209, 53, 245, 238, 140, 203, 36, 237, 8, 198, 166, 208, 240, 152, 5, 65, 97, 176, 49, 62, 192, 153, 103, 120, 27, 215, 253, 115, 63, 101, 106, 120, 61, 67, 128, 80, 191, 208, 113, 152, 6, 41, 160, 36, 101, 245, 175, 231, 70, 92, 57, 124, 19, 83, 114, 100, 214, 20, 36, 144, 23, 9, 96, 139, 1, 232, 114, 48, 157, 49, 225, 155, 53, 130, 78, 164, 66, 56, 237, 166, 106, 73, 114, 11, 83, 131, 180, 152, 16, 177, 129, 238, 175, 224, 165, 176, 251, 64, 146, 244, 151, 39, 141, 206, 183, 165, 61, 54, 106, 81, 26, 13, 96, 68, 249, 177, 124, 171, 70, 226, 51, 19, 138, 14, 69, 207, 12, 117, 235, 189, 47, 15, 155, 159, 244, 176, 253, 96, 223, 104, 92, 57, 123, 27, 149, 183, 114, 102, 185, 227, 250, 134, 124, 113, 153, 37, 151, 152, 6, 30, 103, 148, 187, 92, 186, 26, 239, 78, 243, 229, 195, 91, 96, 33, 105, 1, 150, 222, 187, 107, 170, 249, 220, 187, 62, 25, 209, 159, 66, 44, 186, 248, 252, 251, 11, 126, 49, 113, 104, 112, 171, 86, 17, 157, 149, 182, 46, 12, 182, 2, 26, 78, 176, 68, 182, 179, 23, 132, 120, 49, 157, 87, 71, 237, 29, 131, 226, 32, 124, 86, 29, 183, 240, 245, 59, 13, 194, 154, 80, 94, 78, 173, 44, 215, 89, 39, 42, 244, 161, 115, 89, 169, 114, 82, 34, 158, 94, 197, 153, 35, 21, 150, 15, 24, 238, 141, 87, 12, 159, 123, 207, 170, 209, 4, 100, 116, 118, 82, 98, 26, 156, 51, 4, 237, 17, 154, 46, 185, 233, 172, 134, 164, 31, 218, 232, 211, 37, 214, 123, 86, 23, 142, 234, 31, 194, 222, 208, 4, 12, 143, 253, 57, 7, 198, 225, 84, 115, 90, 177, 210, 131, 54, 40, 72, 146, 151, 55, 149, 246, 182, 125, 114, 62, 148, 162, 241, 3, 167, 134, 105, 88, 181, 57, 107, 81, 159, 186, 79, 225, 52, 193, 94, 167, 177, 152, 170, 166, 62, 120, 96, 3, 6, 38, 122, 53, 56, 49, 22, 30, 102, 239, 30, 249, 38, 235, 178, 18, 138, 222, 84, 56, 86, 18, 120, 216, 39, 145, 149, 7, 242, 147, 134, 213, 221, 24, 99, 219, 180, 119, 222, 167, 212, 113, 71, 85, 197, 13, 152, 142, 130, 100, 48, 179, 243, 156, 135, 0, 134, 107, 121, 130, 226, 180, 41, 60, 125, 111, 40, 5, 159, 244, 135, 218, 240, 21, 105, 51, 246, 253, 233, 34, 148, 146, 117, 145, 182, 56, 226, 85, 154, 162, 23, 230, 53, 102, 103, 192, 224, 68, 243, 71, 13, 1, 253, 206, 196, 108, 72, 196, 136, 148, 102, 98, 163, 208, 93, 150, 84, 129, 234, 229, 141, 230, 56, 61, 192, 212, 41, 6, 9, 31, 244, 199, 218, 52, 141, 132, 33, 252, 101, 162, 21, 151, 137, 28, 59, 130, 24, 152, 119, 127, 1, 104, 105, 110, 243, 226, 211, 194, 34, 173, 252, 175, 60, 16, 88, 71, 232, 214, 157, 176, 99, 21, 99, 235, 103, 182, 241, 221, 15, 92, 215, 160, 141, 225, 89, 34, 177, 16, 128, 120, 135, 137, 109, 208, 19, 170, 84, 61, 73, 87, 63, 8, 137, 158, 39, 1, 41, 126, 128, 11, 202, 29, 214, 33, 63, 193, 2, 13, 124, 236, 98, 204, 6, 108, 125, 29, 63, 20, 171, 53, 62, 19, 222, 219, 172, 129, 142, 45, 97, 233, 172, 32, 82, 91, 149, 27, 123, 247, 146, 132, 128, 23, 66, 173, 246, 122, 237, 66, 201, 210, 82, 72, 63, 100, 86, 234, 207, 96, 196, 170, 219, 205, 28, 72, 174, 13, 253, 19, 106, 170, 218, 216, 56, 39, 33, 232, 208, 240, 54, 208, 204, 188, 95, 95, 89, 170, 140, 236, 6, 221, 101, 229, 55, 159, 6, 143, 206, 70, 189, 19, 124, 106, 130, 81, 157, 173, 163, 3, 131, 125, 150, 11, 21, 80, 189, 78, 127, 82, 115, 212, 210, 29, 213, 153, 187, 63, 51, 3, 126, 111, 64, 127, 172, 68, 74, 193, 206, 157, 17, 124, 73, 106, 93, 120, 42, 187, 211, 195, 178, 183, 65, 241, 31, 72, 164, 66, 85, 223, 188, 119, 82, 118, 7, 1, 249, 170, 65, 248, 122, 73, 244, 53, 117, 123, 50, 234, 100, 216, 187, 230, 183, 237, 109];
const ANSWER = [126, 44, 189, 35, 138, 120, 99, 233, 229, 125, 114, 83, 92, 183, 16, 28, 206, 116, 2, 105, 14, 202, 214, 249, 14, 253, 51, 17, 97, 176, 202, 215]

const K = [
    0x428a2f98,0x71374491,0xb5c0fbcf,0xe9b5dba5,0x3956c25b,0x59f111f1,0x923f82a4,0xab1c5ed5,
    0xd807aa98,0x12835b01,0x243185be,0x550c7dc3,0x72be5d74,0x80deb1fe,0x9bdc06a7,0xc19bf174,
    0xe49b69c1,0xefbe4786,0x0fc19dc6,0x240ca1cc,0x2de92c6f,0x4a7484aa,0x5cb0a9dc,0x76f988da,
    0x983e5152,0xa831c66d,0xb00327c8,0xbf597fc7,0xc6e00bf3,0xd5a79147,0x06ca6351,0x14292967,
    0x27b70a85,0x2e1b2138,0x4d2c6dfc,0x53380d13,0x650a7354,0x766a0abb,0x81c2c92e,0x92722c85,
    0xa2bfe8a1,0xa81a664b,0xc24b8b70,0xc76c51a3,0xd192e819,0xd6990624,0xf40e3585,0x106aa070,
    0x19a4c116,0x1e376c08,0x2748774c,0x34b0bcb5,0x391c0cb3,0x4ed8aa4a,0x5b9cca4f,0x682e6ff3,
    0x748f82ee,0x78a5636f,0x84c87814,0x8cc70208,0x90befffa,0xa4506ceb,0xbef9a3f7,0xc67178f2
]

class CTX {
    data: integer[];
    datalen: integer;
    bitlen: integer;
    state: integer[];

    constructor() {
        this.data = new Array<integer>(64, 0);
        this.datalen = 0;
        this.bitlen = 0;
        this.state = new Array<integer>(8, 0);
    }
}

const ROTRIGHT =  (x:integer, y:integer) =>  (((x & 0xffffffff) >> (y & 31)) | (x << (32 - (y & 31)))) & 0xffffffff
const CH = (x:integer, y:integer, z:integer) => (z ^ (x & (y ^ z)))
const MAJ = (x:integer, y:integer, z:integer) => (((x | y) & z) | (x & y))
const S = (x:integer, n:integer) => ROTRIGHT(x, n)
const R = (x:integer, n:integer) => (x & 0xffffffff) >> n
const EP0 = (x:integer) => (S(x, 2) ^ S(x, 13) ^ S(x, 22))
const EP1 = (x:integer) => (S(x, 6) ^ S(x, 11) ^ S(x, 25))
const SIG0 = (x:integer) => (S(x, 7) ^ S(x, 18) ^ R(x, 3))
const SIG1 = (x:integer) => (S(x, 17) ^ S(x, 19) ^ R(x, 10))

function transform(ctx:CTX) {
    let m:integer[] = new Array<integer>(64, 0);
    let j = 0;
    for (let i = 0; i < 16; i++) {
        m[i] = (ctx.data[j] << 24) | (ctx.data[j + 1] << 16) | (ctx.data[j + 2] << 8) | (ctx.data[j + 3]);
        j += 4;
    }
    for (let i = 16; i < 64; i++) {
        m[i] = SIG1(m[i - 2]) + m[i - 7] + SIG0(m[i - 15]) + m[i - 16];
    }
    let a = ctx.state[0];
    let b = ctx.state[1];
    let c = ctx.state[2];
    let d = ctx.state[3];
    let e = ctx.state[4];
    let f = ctx.state[5];
    let g = ctx.state[6];
    let h = ctx.state[7];

    for (let i = 0; i < 64; i++) {
        let t1 = h + EP1(e) + CH(e,f,g) + K[i] + m[i];
        let t2 = EP0(a) + MAJ(a,b,c);
        h = g;
        g = f;
        f = e;
        e = d + t1;
        d = c;
        c = b;
        b = a;
        a = t1 + t2;
    }
    ctx.state[0] += a;
    ctx.state[1] += b;
    ctx.state[2] += c;
    ctx.state[3] += d;
    ctx.state[4] += e;
    ctx.state[5] += f;
    ctx.state[6] += g;
    ctx.state[7] += h;
}

function update(ctx: CTX, data: integer[]) {
    for (let i = 0; i < DATA_LEN; i++) {
        ctx.data[ctx.datalen] = data[i];
        ctx.datalen = ctx.datalen + 1;
        if (ctx.datalen == 64) {
            transform(ctx);
            ctx.bitlen = ctx.bitlen + 512;
            ctx.datalen = 0;
        }
    }
}

function initialize(ctx: CTX) {
    ctx.datalen = 0;
    ctx.bitlen = 0;
    ctx.state[0] = 0x6a09e667;
    ctx.state[1] = 0xbb67ae85;
    ctx.state[2] = 0x3c6ef372;
    ctx.state[3] = 0xa54ff53a;
    ctx.state[4] = 0x510e527f;
    ctx.state[5] = 0x9b05688c;
    ctx.state[6] = 0x1f83d9ab;
    ctx.state[7] = 0x5be0cd19;
}

function final(ctx:CTX, hash:integer[]) {
    let i = ctx.datalen;
    if (ctx.datalen < 56) {
        ctx.data[i] = 0x80;
        i += 1;
        while (i < 56) {
            ctx.data[i] = 0x00;
            i += 1;
        }
    } else {
        ctx.data[i] = 0x80;
        i += 1;
        while (i < 64) {
            ctx.data[i] = 0x00;
            i += 1;
        }
        transform(ctx);
        for (let j = 0; j < 56; j++) {
            ctx.data[j] = 0;
        }
    }

    ctx.bitlen = ctx.bitlen + ctx.datalen * 8;
    ctx.data[63] = ctx.bitlen;
    ctx.data[62] = ctx.bitlen >> 8;
    ctx.data[61] = ctx.bitlen >> 16;
    ctx.data[60] = ctx.bitlen >> 24;
    ctx.data[59] = ctx.bitlen >> 31;
    ctx.data[58] = ctx.bitlen >> 31;
    ctx.data[57] = ctx.bitlen >> 31;
    ctx.data[56] = ctx.bitlen >> 31;
    transform(ctx);

    for (let i = 0; i < 4; i++) {
        hash[i]      = (ctx.state[0] >> (24 - i * 8)) & 0x000000ff;
        hash[i + 4]  = (ctx.state[1] >> (24 - i * 8)) & 0x000000ff;
        hash[i + 8]  = (ctx.state[2] >> (24 - i * 8)) & 0x000000ff;
        hash[i + 12] = (ctx.state[3] >> (24 - i * 8)) & 0x000000ff;
        hash[i + 16] = (ctx.state[4] >> (24 - i * 8)) & 0x000000ff;
        hash[i + 20] = (ctx.state[5] >> (24 - i * 8)) & 0x000000ff;
        hash[i + 24] = (ctx.state[6] >> (24 - i * 8)) & 0x000000ff;
        hash[i + 28] = (ctx.state[7] >> (24 - i * 8)) & 0x000000ff;
    }
}


function benchmark(cycle: integer) {
    for (let i = 0; i < cycle; i++) {
        let ctx = new CTX();
        let data = new Array<integer>(DATA_LEN, 0);
        for (let i = 0; i < DATA_LEN; i++) {
            data[i] = DATA[i];
        }
        let rez = new Array<integer>(BLOCK_SIZE, 0);
        initialize(ctx);
        update(ctx, data);
        final(ctx, rez);
        for (let i = 0; i < BLOCK_SIZE; i++) {
            assert(rez[i] == ANSWER[i]);
        }
    }
}

