const DATA_LEN = 1024;
const COEFFS_LEN = 256;

const DATA: integer[] = [ 137, 28, 196, 170, 4, 227, 217, 225, 112, 148, 41, 53, 42, 226, 232, 36, 215, 195, 169, 17, 42, 206, 218, 253, 75, 231, 134, 10, 196, 61, 35, 3, 52, 5, 55, 209, 8, 227, 1, 177, 253, 182, 69, 163, 164, 3, 100, 133, 235, 21, 79, 241, 211, 64, 12, 166, 137, 43, 64, 175, 124, 150, 65, 145, 49, 36, 172, 210, 93, 230, 70, 145, 152, 207, 170, 103, 227, 78, 177, 166, 3, 24, 150, 179, 123, 160, 103, 76, 9, 13, 117, 200, 204, 160, 237, 189, 183, 77, 8, 218, 147, 20, 239, 209, 128, 97, 160, 141, 225, 199, 8, 53, 191, 25, 44, 129, 200, 9, 171, 231, 225, 119, 71, 119, 73, 236, 65, 106, 15, 94, 137, 230, 226, 185, 0, 200, 184, 49, 196, 10, 147, 100, 91, 243, 93, 227, 23, 175, 195, 151, 129, 157, 28, 217, 29, 248, 59, 196, 128, 82, 120, 149, 238, 233, 79, 26, 109, 57, 245, 123, 147, 55, 161, 183, 59, 112, 232, 149, 71, 48, 71, 205, 186, 238, 192, 177, 23, 104, 220, 143, 36, 74, 26, 54, 200, 162, 56, 231, 50, 176, 66, 103, 83, 147, 106, 139, 4, 136, 119, 54, 113, 123, 58, 142, 103, 100, 36, 72, 214, 135, 18, 6, 101, 47, 246, 44, 65, 37, 81, 46, 187, 205, 126, 49, 0, 52, 75, 78, 0, 151, 88, 157, 174, 22, 214, 221, 244, 13, 11, 15, 54, 78, 65, 121, 58, 244, 124, 233, 4, 240, 154, 30, 27, 132, 239, 89, 7, 228, 128, 108, 209, 53, 245, 238, 140, 203, 36, 237, 8, 198, 166, 208, 240, 152, 5, 65, 97, 176, 49, 62, 192, 153, 103, 120, 27, 215, 253, 115, 63, 101, 106, 120, 61, 67, 128, 80, 191, 208, 113, 152, 6, 41, 160, 36, 101, 245, 175, 231, 70, 92, 57, 124, 19, 83, 114, 100, 214, 20, 36, 144, 23, 9, 96, 139, 1, 232, 114, 48, 157, 49, 225, 155, 53, 130, 78, 164, 66, 56, 237, 166, 106, 73, 114, 11, 83, 131, 180, 152, 16, 177, 129, 238, 175, 224, 165, 176, 251, 64, 146, 244, 151, 39, 141, 206, 183, 165, 61, 54, 106, 81, 26, 13, 96, 68, 249, 177, 124, 171, 70, 226, 51, 19, 138, 14, 69, 207, 12, 117, 235, 189, 47, 15, 155, 159, 244, 176, 253, 96, 223, 104, 92, 57, 123, 27, 149, 183, 114, 102, 185, 227, 250, 134, 124, 113, 153, 37, 151, 152, 6, 30, 103, 148, 187, 92, 186, 26, 239, 78, 243, 229, 195, 91, 96, 33, 105, 1, 150, 222, 187, 107, 170, 249, 220, 187, 62, 25, 209, 159, 66, 44, 186, 248, 252, 251, 11, 126, 49, 113, 104, 112, 171, 86, 17, 157, 149, 182, 46, 12, 182, 2, 26, 78, 176, 68, 182, 179, 23, 132, 120, 49, 157, 87, 71, 237, 29, 131, 226, 32, 124, 86, 29, 183, 240, 245, 59, 13, 194, 154, 80, 94, 78, 173, 44, 215, 89, 39, 42, 244, 161, 115, 89, 169, 114, 82, 34, 158, 94, 197, 153, 35, 21, 150, 15, 24, 238, 141, 87, 12, 159, 123, 207, 170, 209, 4, 100, 116, 118, 82, 98, 26, 156, 51, 4, 237, 17, 154, 46, 185, 233, 172, 134, 164, 31, 218, 232, 211, 37, 214, 123, 86, 23, 142, 234, 31, 194, 222, 208, 4, 12, 143, 253, 57, 7, 198, 225, 84, 115, 90, 177, 210, 131, 54, 40, 72, 146, 151, 55, 149, 246, 182, 125, 114, 62, 148, 162, 241, 3, 167, 134, 105, 88, 181, 57, 107, 81, 159, 186, 79, 225, 52, 193, 94, 167, 177, 152, 170, 166, 62, 120, 96, 3, 6, 38, 122, 53, 56, 49, 22, 30, 102, 239, 30, 249, 38, 235, 178, 18, 138, 222, 84, 56, 86, 18, 120, 216, 39, 145, 149, 7, 242, 147, 134, 213, 221, 24, 99, 219, 180, 119, 222, 167, 212, 113, 71, 85, 197, 13, 152, 142, 130, 100, 48, 179, 243, 156, 135, 0, 134, 107, 121, 130, 226, 180, 41, 60, 125, 111, 40, 5, 159, 244, 135, 218, 240, 21, 105, 51, 246, 253, 233, 34, 148, 146, 117, 145, 182, 56, 226, 85, 154, 162, 23, 230, 53, 102, 103, 192, 224, 68, 243, 71, 13, 1, 253, 206, 196, 108, 72, 196, 136, 148, 102, 98, 163, 208, 93, 150, 84, 129, 234, 229, 141, 230, 56, 61, 192, 212, 41, 6, 9, 31, 244, 199, 218, 52, 141, 132, 33, 252, 101, 162, 21, 151, 137, 28, 59, 130, 24, 152, 119, 127, 1, 104, 105, 110, 243, 226, 211, 194, 34, 173, 252, 175, 60, 16, 88, 71, 232, 214, 157, 176, 99, 21, 99, 235, 103, 182, 241, 221, 15, 92, 215, 160, 141, 225, 89, 34, 177, 16, 128, 120, 135, 137, 109, 208, 19, 170, 84, 61, 73, 87, 63, 8, 137, 158, 39, 1, 41, 126, 128, 11, 202, 29, 214, 33, 63, 193, 2, 13, 124, 236, 98, 204, 6, 108, 125, 29, 63, 20, 171, 53, 62, 19, 222, 219, 172, 129, 142, 45, 97, 233, 172, 32, 82, 91, 149, 27, 123, 247, 146, 132, 128, 23, 66, 173, 246, 122, 237, 66, 201, 210, 82, 72, 63, 100, 86, 234, 207, 96, 196, 170, 219, 205, 28, 72, 174, 13, 253, 19, 106, 170, 218, 216, 56, 39, 33, 232, 208, 240, 54, 208, 204, 188, 95, 95, 89, 170, 140, 236, 6, 221, 101, 229, 55, 159, 6, 143, 206, 70, 189, 19, 124, 106, 130, 81, 157, 173, 163, 3, 131, 125, 150, 11, 21, 80, 189, 78, 127, 82, 115, 212, 210, 29, 213, 153, 187, 63, 51, 3, 126, 111, 64, 127, 172, 68, 74, 193, 206, 157, 17, 124, 73, 106, 93, 120, 42, 187, 211, 195, 178, 183, 65, 241, 31, 72, 164, 66, 85, 223, 188, 119, 82, 118, 7, 1, 249, 170, 65, 248, 122, 73, 244, 53, 117, 123, 50, 234, 100, 216, 187, 230, 183, 237, 109];

const ANSWER: float[] = [-0.031816, -0.013089, -0.091304, 0.015751, 0.030345, -0.068017, 0.07746, -0.134404, -0.190606, 0.166092, 0.173552, -0.112322, 0.031802, -0.115698, -0.303539, 0.13825, 0.261763, -0.018156, -0.147952, -0.167444, -0.150717, 0.265473, 0.290563, -0.325419, -0.254717, -0.014431, -0.004016, 0.284354, 0.304434, -0.317063, -0.510334, 0.119385, 0.26619, 0.249336, 0.232215, -0.49592, -0.65792, 0.177759, 0.64079, 0.184864, 0.01259, -0.628798, -0.869153, 0.545393, 1.091731, -0.023735, -0.421245, -0.578046, -0.870901, 0.712635, 1.515264, -0.181852, -1.035683, -0.743469, -0.475739, 1.175482, 1.824211, -0.738342, -1.820517, -0.435867, 0.141038, 1.284512, 1.952289, -1.187824, -2.679861, -0.060442, 1.161084, 1.391969, 1.537753, -1.793498, -3.340401, 0.521529, 2.518452, 1.290571, 0.614799, -2.320444, -3.807722, 1.432608, 4.018883, 0.873184, -0.779529, -2.773978, -3.652099, 2.440952, 5.449322, 0.023143, -2.715509, -2.913707, -2.875651, 3.669669, 6.80673, -1.343895, -5.406719, -2.668084, -1.157931, 4.909384, 7.610985, -3.191565, -8.279028, -1.686469, 1.543872, 5.80571, 7.693359, -5.517928, -11.663702, 0.165695, 5.545147, 6.439735, 6.793711, -8.786213, -15.284332, 3.675345, 10.993311, 6.129039, 4.993545, -13.169464, -20.407021, 10.294495, 19.480736, 3.403856, 2.735309, -20.67953, -33.428926, 29.517187, 46.372276, -21.085744, -19.83803, -4.658486, -44.880793, 37.736579, 118.206133, -65.392169, -156.495966, 79.890253, 128.863696, -84.549169, -40.136234, 90.325674, -68.047478, -108.192054, 140.133594, 140.099363, -141.384305, -175.970508, 79.107658, 198.842505, 1.638093, -195.621229, -47.841351, 163.635669, 33.510159, -112.908208, 24.288155, 59.129353, -79.660584, -15.723779, 91.82565, -13.071245, -54.239476, 30.262236, -1.021265, -42.770693, 27.839118, 55.73986, -1.610635, -71.551633, -61.825031, 90.910258, 116.237898, -115.226434, -119.005171, 146.282711, 62.00998, -183.376564, 20.314272, 220.460168, -75.507363, -247.016404, 69.968832, 252.13339, -13.56548, -231.111255, -47.733565, 188.429928, 64.35357, -136.490633, -18.959871, 88.063974, -61.485039, -50.776152, 124.342688, 24.475258, -127.754973, -4.927541, 68.265488, -11.078402, 18.003319, 22.117017, -80.66957, -24.388662, 86.657968, 15.426096, -37.335121, 0.966946, -37.685608, -16.278791, 102.713623, 21.471509, -136.515271, -13.589055, 138.231675, -2.420407, -119.113438, 15.618177, 90.349935, -15.252635, -58.742326, -4.438907, 30.482937, 41.308818, -16.187562, -86.770294, 27.619913, 128.444177, -67.565976, -153.570999, 119.977138, 152.773476, -153.748112, -124.074657, 138.702825, 76.827969, -67.408715, -31.828811, -35.897614, 14.154926, 125.49636, -40.697602, -160.245548, 107.436177, 128.160446, -186.452889, -53.237728, 235.993012, -20.34917, -223.190831, 54.884459, 144.581661, -41.0048, -32.269963, -1.73063, -60.811306, 40.946894, 90.002583, -53.597892, -44.952267, 38.189519, -45.09251, -11.231341, 127.580119, -6.59371, -159.729721, 4.651871, 131.545121, 12.343041, -69.362184, -31.491346, 15.33858, 40.433782, -0.101789, -36.255371, 24.0208, 25.149473, -61.418451, -17.686928, 79.255341, 19.86215, -60.768739, -29.423634, 13.31963, 36.012821, 37.926208, -27.191461, -69.187866, -4.665896, 70.360317, 54.32896, -48.629779, -102.658349, 18.470332, 123.399567, 8.040139, -96.899697, -26.635555, 22.320204, 37.984629, 76.161479, -42.077112, -160.17697, 35.458704, 195.706883, -16.343411, -173.452709, -10.66752, 114.193074, 32.193262, -56.86232, -33.692112, 34.368033, 8.530711, -54.613861, 34.165045, 95.819833, -73.141287, -122.412304, 85.544819, 107.827386, -60.882366, -52.287429, 7.269705, -19.474498, 50.737936, 73.830017, -85.09076, -88.545412, 77.470973, 62.973718, -29.009407, -15.957292, -40.233196, -28.667677, 99.852382, 52.842089, -123.20085, -49.662574, 98.190277, 21.077868, -34.986462, 25.204851, -39.223764, -77.78403, 91.598134, 120.846094, -99.982824, -138.731276, 63.695911, 121.795613, -4.423126, -74.722409, -47.22573, 17.749133, 69.064861, 21.171507, -61.338973, -23.542354, 44.124112, -8.189867, -42.349813, 49.259107, 65.658685, -67.95067, -100.186965, 45.269515, 114.616414, 11.868129, -83.428412, -75.112286, 5.016947, 111.04909, 92.345193, -102.477393, -166.442293, 56.689445, 184.921816, 0.170317, -144.461847, -40.102611, 68.571584, 47.87507, 9.148843, -27.061324, -67.795898, -7.004218, 108.499266, 36.97949, -145.89937, -53.581622, 189.11353, 55.491051, -228.930761, -47.536235, 240.589856, 35.831947, -203.541238, -26.918311, 119.742351, 26.47011, -19.268402, -37.873709, -56.851515, 58.540611, 80.791458, -78.609101, -56.084869, 81.439779, 14.289434, -53.450069, 6.765621, -8.251241, 10.122521, 88.342471, -49.895589, -159.705063, 76.77677, 193.267006, -59.407075, -174.095727, -6.539097, 107.776293, 93.286363, -19.248629, -158.897042, -59.875412, 171.903997, 103.722352, -130.727983, -102.850494, 61.805067, 65.932996, -3.007236, -15.040469, -19.334646, -25.098434, 1.847112, 36.576579, 38.071776, -16.527303, -77.036261, -23.817466, 99.151856, 63.093987, -100.783332, -82.73972, 85.468832, 75.034097, -57.130275, -48.602045, 16.737032, 22.10738, 33.546801, -13.944227, -85.241642, 29.203357, 121.377965, -57.158091, -124.106843, 76.999804, 85.588313, -73.74515, -16.234275, 48.040708, -57.648446, -18.017251, 105.721535, 6.124857, -110.245707, -25.075031, 74.509792, 68.420544, -21.394152, -114.625386, -20.60293, 140.298014, 31.729666, -135.561357, -10.172452, 108.059945, -31.09274, -76.044307, 72.519235, 54.518108, -98.910866, -46.243115, 103.390179, 42.60556, -86.691255, -34.337149, 51.777032, 20.655125, -2.298961, -11.408149, -57.090213, 17.949342, 116.73662, -42.439742, -162.124859, 71.32097, 178.02187, -81.990875, -157.15885, 56.77165, 105.429271, 2.187052, -42.035159, -70.332829, -10.742452, 111.053984, 36.635721, -96.530531, -33.627529, 24.843669, 13.071052, 74.500534, 7.916333, -153.969491, -16.897468, 170.000783, 11.274432, -106.798536, 1.811802, -15.040846, -13.077306, 146.526932, 16.397216, -233.788087, -12.543404, 242.840472, 6.192357, -175.725658, -2.883992, 67.829035, 3.915926, 30.321214, -7.769041, -79.194189, 12.540458, 66.478332, -18.680109, -11.347689, 28.8372, -50.803824, -45.467523, 87.183428, 66.716496, -85.930266, -86.075183, 58.084997, 95.301936, -29.148973, -89.687331, 21.65197, 71.072486, -42.896639, -47.685056, 80.074441, 29.276671, -108.913594, -22.912391, 107.620112, 27.651329, -70.537161, -37.235953, 12.584771, 43.705516, 36.335312, -44.326444, -47.291905, 42.476459, 8.447598, -46.756219, 64.384092, 63.381634, -132.169094, -91.2799, 150.935703, 119.540841, -98.102382, -132.309414, -13.609517, 116.971337, 137.499155, -72.255768, -217.17337, 10.422311, 216.755977, 46.795792, -141.98569, -79.982509, 35.331488, 81.622595, 49.412572, -60.349354, -80.970175, 35.659151, 66.431451, -26.861976, -42.501933, 41.231449, 45.729191, -71.698485, -85.308353, 100.905528, 135.340282, -113.070124, -155.83438, 102.533625, 122.928083, -76.774423, -48.181784, 48.056277, -29.335994, -26.04534, 71.329363, 11.161288, -67.839951, 1.799498, 41.815509, -17.021528, -29.046404, 31.052761, 45.437895, -34.380951, -73.03184, 19.126903, 70.581557, 11.321264, -8.291646, -42.07634, -104.881952, 53.880321, 218.948471, -37.592731, -273.160312, 2.656031, 235.204628, 25.186628, -124.218596, -19.632097, -1.484901, -29.440632, 81.840545, 106.64924, -92.177509, -178.443244, 52.806965, 210.616389, -10.162758, -186.742856, -1.916468, 115.867894, -15.311604, -26.734785, 29.6815, -48.890384, -7.094836, 90.843705, -60.221575, -96.745105, 144.143346, 76.356488, -199.889056, -43.353512, 195.91019, 6.873614, -134.571638, 26.867569, 48.533621, -54.161365, 21.040723, 70.477837, -49.750739, -74.320194, 39.608633, 69.161834, -11.252363, -65.032062, -14.080019, 71.687225, 26.603019, -91.654124, -28.599938, 113.247506, 24.987052, -116.378387, -16.223709, 83.59981, -2.31148, -14.179888, 32.103454, -72.70377, -65.442941, 145.723949, 87.046506, -181.156657, -83.524131, 175.913925, 53.048536, -151.421467, -8.266587, 139.175979, -31.126838, -161.755574, 48.25884, 216.398729, -36.997326, -276.62589, 1.570209, 306.341059, 46.917154, -281.983574, -94.969028, 203.694519, 127.037725, -95.891532, -128.027023, -8.089804, 88.250917, 81.124261, -12.298272, -113.318536, -76.752906, 109.519916, 142.098801, -82.618886, -152.239181, 45.027174, 98.690263, -5.1055, -5.886806, -32.200041, -81.111486, 61.85008, 121.122986, -79.655893, -100.955975, 83.155434, 40.967681, -75.357369, 20.407303, 61.954354, -52.77812, -48.769375, 50.630745, 37.473695, -31.800013, -26.148488, 17.280758, 11.570461, -13.768374, 6.239246, 9.262551, -23.694406, 11.425546, 35.623856, -50.202952, -39.8915, 88.564646, 37.506076, -101.11415, -30.659363, 76.041269, 18.716002, -28.602103, 1.561542, -7.896725, -33.536154, 4.966071, 72.884965, 39.033782, -106.341465, -97.816438, 116.973168, 134.091006, -94.81784, -127.701126, 46.011929, 87.11707, 7.774446, -41.341002, -41.209932, 14.773055, 40.228466, -9.753421, -11.092932, 5.604597, -23.659807, 20.671087, 39.41087, -74.120448, -26.199714, 133.892217, -6.686892, -168.581547, 37.69084, 159.430767, -49.085777, -115.895363, 36.977529, 69.496849, -12.744883, -51.612398, -8.945718, 70.658767, 19.583907, -107.64654, -22.262066, 130.588934, 26.001853, -118.758963, -38.330326, 75.576902, 59.595395, -25.660638, -84.455294, -5.713886, 107.408113, 8.770709, -127.058597, 5.549944, 143.577281, -18.425335, -155.193757, 18.672033, 155.921303, -11.808032, -141.154842, 11.461617, 114.115072, -26.242546, -87.867296, 47.880984, 77.663734, -55.558206, -89.408614, 31.499023, 110.62673, 21.992252, -117.496713, -79.386989, 91.153337, 105.126561, -34.944995, -77.237042, -24.981372, 3.449809, 55.061548, 80.65834, -41.643303, -131.993484, 3.754659, 125.217049, 16.327563, -69.178019, 16.538664, -0.018625, -101.645966, 40.360754, 196.472286, -30.799091, -241.878067, -18.00642, 201.026783, 71.920416, -87.740006, -97.168013, -39.801992, 80.330356, 114.203054, -35.528905, -103.035116, -9.150912, 28.519558, 31.315413, 48.035983, -29.38303, -68.771285, 19.967384, 15.832639, -22.087497, 77.063999, 40.377034, -150.367451, -61.497831, 156.953221, 64.293899, -91.452448, -39.120689, -11.310356, -1.97041, 99.740784, 30.224515, -137.449905, -20.209498, 118.705449, -31.035005, -64.44018, 98.302953, 4.051337, -143.019672, 40.013725, 137.269968, -60.158835, -81.960238, 57.674977, 5.246503, -38.850256, 55.484224, 12.405825, -78.194842, 8.331552, 67.848018, -9.138812, -49.111329, -18.867354, 45.681401, 68.375918, -62.955599, -114.799029, 83.213634, 127.980033, -81.266312, -93.005708, 42.572944, 24.332682, 22.327697, 37.00805, -83.648294, -46.849188, 108.796918, -13.511764, -83.894018, 120.585698, 20.161357, -218.471545, 50.769795, 250.743556, -96.778853, -194.190657, 100.125985, 73.840248, -65.48023, 49.903472, 13.661912, -117.101293, 30.271278, 101.049788, -49.847519, -22.599486, 41.708826, -65.037504, -14.499426, 106.9398, -18.335949, -78.122568, 44.933614, -6.149968, -59.551937, 101.558873, 62.983271, -162.301135, -61.003035, 164.602545, 59.748123, -118.156899, -63.831304, 56.709211, 72.924389, -18.26989, -83.089032, 22.954578, 88.552043, -64.199538, -86.356839, 113.484783, 77.966114, -137.8048, -70.023845, 117.144805, 68.567548, -55.080946, -74.582213, -26.344888, 81.220062, 98.668149, -77.915865, -141.717508, 56.946488, 150.298677, -23.00872, -131.662948, -7.543889, 96.403859, 12.360984, -51.969242, 21.936366, 2.027817, -90.00064, 47.618675, 164.988825, -85.90798, -210.527232, 98.304905, 198.596463, -77.90051, -126.907109, 33.615193, 22.142804, 9.304176, 71.396182, -23.694251, -115.070594, -2.846938, 95.021465, 55.731104, -30.241569, -101.158163, -38.284262, 106.378568, 69.003077, -63.467891, -43.116855, -2.470545, -27.964597, 47.482744];

const COEFFS: float[] = [-0.0001080158, -0.0000223598, -0.0001508761, 0.0002503345, 0.0002986092, -0.000283246, -0.0002044307, 0.0000756681, -0.0000781315, 0.0002250069, 0.0003321089, -0.0003726025, -0.0003319606, 0.0002122557, 0.0000333043, 0.0001699509, 0.0003536868, -0.000474113, -0.0004973665, 0.0004082621, 0.0002157633, 0.0000464696, 0.0003251578, -0.000557587, -0.0006851106, 0.0006671995, 0.0004928094, -0.0001860992, 0.000195469, -0.0005710325, -0.0008527662, 0.0009656799, 0.0008664618, -0.0005568257, -0.000087652, -0.0004479917, -0.0009324194, 0.0012483975, 0.0013065514, -0.001068885, -0.0005625123, -0.0001205478, -0.0008387699, 0.001429501, 0.0017448584, -0.0016874181, -0.0012373279, 0.0004637551, -0.000483376, 0.0014011282, 0.0020759818, -0.0023323157, -0.0020761732, 0.0013237519, 0.0002067508, 0.0010485509, 0.0021657568, -0.0028779508, -0.0029898507, 0.0024283613, 0.001268955, 0.0002700741, 0.0018666282, -0.0031606542, -0.0038337166, 0.0036850457, 0.0026863436, -0.0010012004, 0.0010379463, -0.0029931566, -0.0044131008, 0.0049349856, 0.0043737342, -0.0027771559, -0.0004320789, -0.0021834711, -0.0044950315, 0.0059552171, 0.0061699879, -0.0049992131, -0.0026069032, -0.0005538511, -0.0038224749, 0.0064653359, 0.007836412, -0.0075298275, -0.0054892983, 0.0020467497, -0.0021236851, 0.0061320813, 0.0090570478, -0.0101509008, -0.0090213184, 0.0057471508, 0.0008976353, 0.0045565332, 0.0094287251, -0.0125647387, -0.0131038832, 0.0106961082, 0.0056238471, 0.0012058492, 0.0084077159, -0.0143826721, -0.0176525699, 0.017198754, 0.012731777, -0.0048284243, 0.0051049129, -0.0150503741, -0.0227490176, 0.0261604757, 0.0239256885, -0.0157392008, -0.0025485083, -0.013473898, -0.0291994631, 0.0410213392, 0.0454666661, -0.0398388516, -0.0227735814, -0.0053980079, -0.0425554054, 0.0849948531, 0.127913363, -0.1660979024, -0.194708354, 0.210023539, 0.210023539, -0.194708354, -0.1660979024, 0.127913363, 0.0849948531, -0.0425554054, -0.0053980079, -0.0227735814, -0.0398388516, 0.0454666661, 0.0410213392, -0.0291994631, -0.013473898, -0.0025485083, -0.0157392008, 0.0239256885, 0.0261604757, -0.0227490176, -0.0150503741, 0.0051049129, -0.0048284243, 0.012731777, 0.017198754, -0.0176525699, -0.0143826721, 0.0084077159, 0.0012058492, 0.0056238471, 0.0106961082, -0.0131038832, -0.0125647387, 0.0094287251, 0.0045565332, 0.0008976353, 0.0057471508, -0.0090213184, -0.0101509008, 0.0090570478, 0.0061320813, -0.0021236851, 0.0020467497, -0.0054892983, -0.0075298275, 0.007836412, 0.0064653359, -0.0038224749, -0.0005538511, -0.0026069032, -0.0049992131, 0.0061699879, 0.0059552171, -0.0044950315, -0.0021834711, -0.0004320789, -0.0027771559, 0.0043737342, 0.0049349856, -0.0044131008, -0.0029931566, 0.0010379463, -0.0010012004, 0.0026863436, 0.0036850457, -0.0038337166, -0.0031606542, 0.0018666282, 0.0002700741, 0.001268955, 0.0024283613, -0.0029898507, -0.0028779508, 0.0021657568, 0.0010485509, 0.0002067508, 0.0013237519, -0.0020761732, -0.0023323157, 0.0020759818, 0.0014011282, -0.000483376, 0.0004637551, -0.0012373279, -0.0016874181, 0.0017448584, 0.001429501, -0.0008387699, -0.0001205478, -0.0005625123, -0.001068885, 0.0013065514, 0.0012483975, -0.0009324194, -0.0004479917, -0.000087652, -0.0005568257, 0.0008664618, 0.0009656799, -0.0008527662, -0.0005710325, 0.000195469, -0.0001860992, 0.0004928094, 0.0006671995, -0.0006851106, -0.000557587, 0.0003251578, 0.0000464696, 0.0002157633, 0.0004082621, -0.0004973665, -0.000474113, 0.0003536868, 0.0001699509, 0.0000333043, 0.0002122557, -0.0003319606, -0.0003726025, 0.0003321089, 0.0002250069, -0.0000781315, 0.0000756681, -0.0002044307, -0.000283246, 0.0002986092, 0.0002503345, -0.0001508761, -0.0000223598, -0.000108]


function fir(input: float[], output: float[]) {
    const delay: float[] = new Array<float>(COEFFS_LEN, 0.0);
    let pos = 0;
    for (let i = 0; i < DATA_LEN; i++) {
        let acc: float = 0.0;
        let coeffsPos = COEFFS_LEN - 1;
        delay[pos] = input[i];
        pos += 1;
        if (pos >= COEFFS_LEN)
            pos = 0;
        for (let n = pos; n < COEFFS_LEN; n++) {
            acc += COEFFS[coeffsPos] * delay[n];
            coeffsPos -= 1;
        }
        for (let n = 0; n < pos; n++) {
            acc += COEFFS[coeffsPos] * delay[n];
            coeffsPos -= 1;
        }
        output[i] = acc;
    }
}



function benchmark(cycle: integer) {
    for (let i = 0; i < cycle; i++) {
        const inData: float[] = new Array<float>(DATA_LEN, 0.0);
        const rez: float[] = new Array<float>(DATA_LEN, 0.0);
        for (let i = 0; i < DATA_LEN; i++) {
            inData[i] = (DATA[i] * 2.15);
        }
        fir(inData, rez);

        for (let i = 0; i < DATA_LEN; i++) {
            assert(fabs(rez[i] - ANSWER[i]) < 0.0005);
        }
    }
}

