const DATA_LEN = 1024;

// const DATA: integer[] = [ 137, 28, 196, 170, 4, 227, 217, 225, 112, 148, 41, 53, 42, 226, 232, 36, 215, 195, 169, 17, 42, 206, 218, 253, 75, 231, 134, 10, 196, 61, 35, 3, 52, 5, 55, 209, 8, 227, 1, 177, 253, 182, 69, 163, 164, 3, 100, 133, 235, 21, 79, 241, 211, 64, 12, 166, 137, 43, 64, 175, 124, 150, 65, 145, 49, 36, 172, 210, 93, 230, 70, 145, 152, 207, 170, 103, 227, 78, 177, 166, 3, 24, 150, 179, 123, 160, 103, 76, 9, 13, 117, 200, 204, 160, 237, 189, 183, 77, 8, 218, 147, 20, 239, 209, 128, 97, 160, 141, 225, 199, 8, 53, 191, 25, 44, 129, 200, 9, 171, 231, 225, 119, 71, 119, 73, 236, 65, 106, 15, 94, 137, 230, 226, 185, 0, 200, 184, 49, 196, 10, 147, 100, 91, 243, 93, 227, 23, 175, 195, 151, 129, 157, 28, 217, 29, 248, 59, 196, 128, 82, 120, 149, 238, 233, 79, 26, 109, 57, 245, 123, 147, 55, 161, 183, 59, 112, 232, 149, 71, 48, 71, 205, 186, 238, 192, 177, 23, 104, 220, 143, 36, 74, 26, 54, 200, 162, 56, 231, 50, 176, 66, 103, 83, 147, 106, 139, 4, 136, 119, 54, 113, 123, 58, 142, 103, 100, 36, 72, 214, 135, 18, 6, 101, 47, 246, 44, 65, 37, 81, 46, 187, 205, 126, 49, 0, 52, 75, 78, 0, 151, 88, 157, 174, 22, 214, 221, 244, 13, 11, 15, 54, 78, 65, 121, 58, 244, 124, 233, 4, 240, 154, 30, 27, 132, 239, 89, 7, 228, 128, 108, 209, 53, 245, 238, 140, 203, 36, 237, 8, 198, 166, 208, 240, 152, 5, 65, 97, 176, 49, 62, 192, 153, 103, 120, 27, 215, 253, 115, 63, 101, 106, 120, 61, 67, 128, 80, 191, 208, 113, 152, 6, 41, 160, 36, 101, 245, 175, 231, 70, 92, 57, 124, 19, 83, 114, 100, 214, 20, 36, 144, 23, 9, 96, 139, 1, 232, 114, 48, 157, 49, 225, 155, 53, 130, 78, 164, 66, 56, 237, 166, 106, 73, 114, 11, 83, 131, 180, 152, 16, 177, 129, 238, 175, 224, 165, 176, 251, 64, 146, 244, 151, 39, 141, 206, 183, 165, 61, 54, 106, 81, 26, 13, 96, 68, 249, 177, 124, 171, 70, 226, 51, 19, 138, 14, 69, 207, 12, 117, 235, 189, 47, 15, 155, 159, 244, 176, 253, 96, 223, 104, 92, 57, 123, 27, 149, 183, 114, 102, 185, 227, 250, 134, 124, 113, 153, 37, 151, 152, 6, 30, 103, 148, 187, 92, 186, 26, 239, 78, 243, 229, 195, 91, 96, 33, 105, 1, 150, 222, 187, 107, 170, 249, 220, 187, 62, 25, 209, 159, 66, 44, 186, 248, 252, 251, 11, 126, 49, 113, 104, 112, 171, 86, 17, 157, 149, 182, 46, 12, 182, 2, 26, 78, 176, 68, 182, 179, 23, 132, 120, 49, 157, 87, 71, 237, 29, 131, 226, 32, 124, 86, 29, 183, 240, 245, 59, 13, 194, 154, 80, 94, 78, 173, 44, 215, 89, 39, 42, 244, 161, 115, 89, 169, 114, 82, 34, 158, 94, 197, 153, 35, 21, 150, 15, 24, 238, 141, 87, 12, 159, 123, 207, 170, 209, 4, 100, 116, 118, 82, 98, 26, 156, 51, 4, 237, 17, 154, 46, 185, 233, 172, 134, 164, 31, 218, 232, 211, 37, 214, 123, 86, 23, 142, 234, 31, 194, 222, 208, 4, 12, 143, 253, 57, 7, 198, 225, 84, 115, 90, 177, 210, 131, 54, 40, 72, 146, 151, 55, 149, 246, 182, 125, 114, 62, 148, 162, 241, 3, 167, 134, 105, 88, 181, 57, 107, 81, 159, 186, 79, 225, 52, 193, 94, 167, 177, 152, 170, 166, 62, 120, 96, 3, 6, 38, 122, 53, 56, 49, 22, 30, 102, 239, 30, 249, 38, 235, 178, 18, 138, 222, 84, 56, 86, 18, 120, 216, 39, 145, 149, 7, 242, 147, 134, 213, 221, 24, 99, 219, 180, 119, 222, 167, 212, 113, 71, 85, 197, 13, 152, 142, 130, 100, 48, 179, 243, 156, 135, 0, 134, 107, 121, 130, 226, 180, 41, 60, 125, 111, 40, 5, 159, 244, 135, 218, 240, 21, 105, 51, 246, 253, 233, 34, 148, 146, 117, 145, 182, 56, 226, 85, 154, 162, 23, 230, 53, 102, 103, 192, 224, 68, 243, 71, 13, 1, 253, 206, 196, 108, 72, 196, 136, 148, 102, 98, 163, 208, 93, 150, 84, 129, 234, 229, 141, 230, 56, 61, 192, 212, 41, 6, 9, 31, 244, 199, 218, 52, 141, 132, 33, 252, 101, 162, 21, 151, 137, 28, 59, 130, 24, 152, 119, 127, 1, 104, 105, 110, 243, 226, 211, 194, 34, 173, 252, 175, 60, 16, 88, 71, 232, 214, 157, 176, 99, 21, 99, 235, 103, 182, 241, 221, 15, 92, 215, 160, 141, 225, 89, 34, 177, 16, 128, 120, 135, 137, 109, 208, 19, 170, 84, 61, 73, 87, 63, 8, 137, 158, 39, 1, 41, 126, 128, 11, 202, 29, 214, 33, 63, 193, 2, 13, 124, 236, 98, 204, 6, 108, 125, 29, 63, 20, 171, 53, 62, 19, 222, 219, 172, 129, 142, 45, 97, 233, 172, 32, 82, 91, 149, 27, 123, 247, 146, 132, 128, 23, 66, 173, 246, 122, 237, 66, 201, 210, 82, 72, 63, 100, 86, 234, 207, 96, 196, 170, 219, 205, 28, 72, 174, 13, 253, 19, 106, 170, 218, 216, 56, 39, 33, 232, 208, 240, 54, 208, 204, 188, 95, 95, 89, 170, 140, 236, 6, 221, 101, 229, 55, 159, 6, 143, 206, 70, 189, 19, 124, 106, 130, 81, 157, 173, 163, 3, 131, 125, 150, 11, 21, 80, 189, 78, 127, 82, 115, 212, 210, 29, 213, 153, 187, 63, 51, 3, 126, 111, 64, 127, 172, 68, 74, 193, 206, 157, 17, 124, 73, 106, 93, 120, 42, 187, 211, 195, 178, 183, 65, 241, 31, 72, 164, 66, 85, 223, 188, 119, 82, 118, 7, 1, 249, 170, 65, 248, 122, 73, 244, 53, 117, 123, 50, 234, 100, 216, 187, 230, 183, 237, 109];
const FFT_TABLE: integer[] = [ 32767, 0, 0, 32767, 23169, 23169, -23169, 23169, 30272, 12539, -12539, 30272, 12539, 30272, -30272, 12539, 32137, 6392, -6392, 32137, 18204, 27244, -27244, 18204, 27244, 18204, -18204, 27244, 6392, 32137, -32137, 6392, 32609, 3211, -3211, 32609, 20787, 25329, -25329, 20787, 28897, 15446, -15446, 28897, 9511, 31356, -31356, 9511, 31356, 9511, -9511, 31356, 15446, 28897, -28897, 15446, 25329, 20787, -20787, 25329, 3211, 32609, -32609, 3211, 32727, 1607, -1607, 32727, 22004, 24278, -24278, 22004, 29621, 14009, -14009, 29621, 11038, 30851, -30851, 11038, 31785, 7961, -7961, 31785, 16845, 28105, -28105, 16845, 26318, 19519, -19519, 26318, 4807, 32412, -32412, 4807, 32412, 4807, -4807, 32412, 19519, 26318, -26318, 19519, 28105, 16845, -16845, 28105, 7961, 31785, -31785, 7961, 30851, 11038, -11038, 30851, 14009, 29621, -29621, 14009, 24278, 22004, -22004, 24278, 1607, 32727, -32727, 1607, 32757, 804, -804, 32757, 22594, 23731, -23731, 22594, 29955, 13278, -13278, 29955, 11792, 30571, -30571, 11792, 31970, 7179, -7179, 31970, 17530, 27683, -27683, 17530, 26789, 18867, -18867, 26789, 5601, 32284, -32284, 5601, 32520, 4011, -4011, 32520, 20159, 25831, -25831, 20159, 28510, 16150, -16150, 28510, 8739, 31580, -31580, 8739, 31113, 10278, -10278, 31113, 14732, 29268, -29268, 14732, 24811, 21402, -21402, 24811, 2410, 32678, -32678, 2410, 32678, 2410, -2410, 32678, 21402, 24811, -24811, 21402, 29268, 14732, -14732, 29268, 10278, 31113, -31113, 10278, 31580, 8739, -8739, 31580, 16150, 28510, -28510, 16150, 25831, 20159, -20159, 25831, 4011, 32520, -32520, 4011, 32284, 5601, -5601, 32284, 18867, 26789, -26789, 18867, 27683, 17530, -17530, 27683, 7179, 31970, -31970, 7179, 30571, 11792, -11792, 30571, 13278, 29955, -29955, 13278, 23731, 22594, -22594, 23731, 804, 32757, -32757, 804, 32764, 402, -402, 32764, 22883, 23452, -23452, 22883, 30116, 12909, -12909, 30116, 12166, 30424, -30424, 12166, 32056, 6786, -6786, 32056, 17868, 27466, -27466, 17868, 27019, 18537, -18537, 27019, 5997, 32213, -32213, 5997, 32567, 3611, -3611, 32567, 20474, 25582, -25582, 20474, 28706, 15799, -15799, 28706, 9126, 31470, -31470, 9126, 31236, 9895, -9895, 31236, 15090, 29085, -29085, 15090, 25072, 21096, -21096, 25072, 2811, 32646, -32646, 2811, 32705, 2009, -2009, 32705, 21705, 24546, -24546, 21705, 29446, 14372, -14372, 29446, 10659, 30984, -30984, 10659, 31684, 8351, -8351, 31684, 16499, 28309, -28309, 16499, 26077, 19840, -19840, 26077, 4409, 32468, -32468, 4409, 32350, 5205, -5205, 32350, 19194, 26556, -26556, 19194, 27896, 17189, -17189, 27896, 7571, 31880, -31880, 7571, 30713, 11416, -11416, 30713, 13645, 29790, -29790, 13645, 24006, 22301, -22301, 24006, 1206, 32744, -32744, 1206, 32744, 1206, -1206, 32744, 22301, 24006, -24006, 22301, 29790, 13645, -13645, 29790, 11416, 30713, -30713, 11416, 31880, 7571, -7571, 31880, 17189, 27896, -27896, 17189, 26556, 19194, -19194, 26556, 5205, 32350, -32350, 5205, 32468, 4409, -4409, 32468, 19840, 26077, -26077, 19840, 28309, 16499, -16499, 28309, 8351, 31684, -31684, 8351, 30984, 10659, -10659, 30984, 14372, 29446, -29446, 14372, 24546, 21705, -21705, 24546, 2009, 32705, -32705, 2009, 32646, 2811, -2811, 32646, 21096, 25072, -25072, 21096, 29085, 15090, -15090, 29085, 9895, 31236, -31236, 9895, 31470, 9126, -9126, 31470, 15799, 28706, -28706, 15799, 25582, 20474, -20474, 25582, 3611, 32567, -32567, 3611, 32213, 5997, -5997, 32213, 18537, 27019, -27019, 18537, 27466, 17868, -17868, 27466, 6786, 32056, -32056, 6786, 30424, 12166, -12166, 30424, 12909, 30116, -30116, 12909, 23452, 22883, -22883, 23452, 402, 32764, -32764, 402, 32766, 201, -201, 32766, 23027, 23311, -23311, 23027, 30195, 12724, -12724, 30195, 12353, 30349, -30349, 12353, 32097, 6589, -6589, 32097, 18036, 27355, -27355, 18036, 27132, 18371, -18371, 27132, 6195, 32176, -32176, 6195, 32588, 3411, -3411, 32588, 20631, 25456, -25456, 20631, 28802, 15623, -15623, 28802, 9319, 31413, -31413, 9319, 31297, 9703, -9703, 31297, 15268, 28992, -28992, 15268, 25201, 20942, -20942, 25201, 3011, 32628, -32628, 3011, 32717, 1808, -1808, 32717, 21855, 24413, -24413, 21855, 29534, 14191, -14191, 29534, 10849, 30918, -30918, 10849, 31735, 8156, -8156, 31735, 16672, 28208, -28208, 16672, 26198, 19680, -19680, 26198, 4608, 32441, -32441, 4608, 32382, 5006, -5006, 32382, 19357, 26437, -26437, 19357, 28001, 17017, -17017, 28001, 7766, 31833, -31833, 7766, 30783, 11227, -11227, 30783, 13827, 29706, -29706, 13827, 24143, 22153, -22153, 24143, 1406, 32736, -32736, 1406, 32751, 1005, -1005, 32751, 22448, 23869, -23869, 22448, 29873, 13462, -13462, 29873, 11604, 30643, -30643, 11604, 31926, 7375, -7375, 31926, 17360, 27790, -27790, 17360, 26673, 19031, -19031, 26673, 5403, 32318, -32318, 5403, 32495, 4210, -4210, 32495, 20000, 25954, -25954, 20000, 28410, 16325, -16325, 28410, 8545, 31633, -31633, 8545, 31049, 10469, -10469, 31049, 14552, 29358, -29358, 14552, 24679, 21554, -21554, 24679, 2209, 32692, -32692, 2209, 32662, 2610, -2610, 32662, 21249, 24942, -24942, 21249, 29177, 14911, -14911, 29177, 10087, 31175, -31175, 10087, 31525, 8932, -8932, 31525, 15975, 28608, -28608, 15975, 25707, 20317, -20317, 25707, 3811, 32544, -32544, 3811, 32249, 5799, -5799, 32249, 18702, 26905, -26905, 18702, 27575, 17699, -17699, 27575, 6982, 32014, -32014, 6982, 30498, 11980, -11980, 30498, 13094, 30036, -30036, 13094, 23592, 22739, -22739, 23592, 603, 32761, -32761, 603, 32761, 603, -603, 32761, 22739, 23592, -23592, 22739, 30036, 13094, -13094, 30036, 11980, 30498, -30498, 11980, 32014, 6982, -6982, 32014, 17699, 27575, -27575, 17699, 26905, 18702, -18702, 26905, 5799, 32249, -32249, 5799, 32544, 3811, -3811, 32544, 20317, 25707, -25707, 20317, 28608, 15975, -15975, 28608, 8932, 31525, -31525, 8932, 31175, 10087, -10087, 31175, 14911, 29177, -29177, 14911, 24942, 21249, -21249, 24942, 2610, 32662, -32662, 2610, 32692, 2209, -2209, 32692, 21554, 24679, -24679, 21554, 29358, 14552, -14552, 29358, 10469, 31049, -31049, 10469, 31633, 8545, -8545, 31633, 16325, 28410, -28410, 16325, 25954, 20000, -20000, 25954, 4210, 32495, -32495, 4210, 32318, 5403, -5403, 32318, 19031, 26673, -26673, 19031, 27790, 17360, -17360, 27790, 7375, 31926, -31926, 7375, 30643, 11604, -11604, 30643, 13462, 29873, -29873, 13462, 23869, 22448, -22448, 23869, 1005, 32751, -32751, 1005, 32736, 1406, -1406, 32736, 22153, 24143, -24143, 22153, 29706, 13827, -13827, 29706, 11227, 30783, -30783, 11227, 31833, 7766, -7766, 31833, 17017, 28001, -28001, 17017, 26437, 19357, -19357, 26437, 5006, 32382, -32382, 5006, 32441, 4608, -4608, 32441, 19680, 26198, -26198, 19680, 28208, 16672, -16672, 28208, 8156, 31735, -31735, 8156, 30918, 10849, -10849, 30918, 14191, 29534, -29534, 14191, 24413, 21855, -21855, 24413, 1808, 32717, -32717, 1808, 32628, 3011, -3011, 32628, 20942, 25201, -25201, 20942, 28992, 15268, -15268, 28992, 9703, 31297, -31297, 9703, 31413, 9319, -9319, 31413, 15623, 28802, -28802, 15623, 25456, 20631, -20631, 25456, 3411, 32588, -32588, 3411, 32176, 6195, -6195, 32176, 18371, 27132, -27132, 18371, 27355, 18036, -18036, 27355, 6589, 32097, -32097, 6589, 30349, 12353, -12353, 30349, 12724, 30195, -30195, 12724, 23311, 23027, -23027, 23311, 201, 32766, -32766, 201];
const ANSWER: integer[] = [121, 126, 3, -7, 2, -4, 1, -10, 5, -4, -2, -4, 2, 2, 0, 3, -1, 0, 3, -7, -1, -7, -2, -2, 3, 1, -3, 3, -2, 0, -3, -3, -3, 2, 6, 6, 0, 0, -3, 2, 1, 1, 0, 0, -8, 3, -1, 3, 3, 3, 3, -1, -4, -1, -2, 4, -2, -5, -2, -1, 2, -2, -5, -1, 5, -2, -5, 1, 6, -3, 5, -1, 2, -1, 3, 1, 3, 8, 1, 5, -2, 0, -2, 1, -7, -1, 1, 1, 0, -1, 0, 6, 3, 3, -4, -3, -2, -3, -6, -3, 4, -5, -4, 1, 1, -5, 4, 1, 0, 0, 4, 1, 2, 0, 4, -3, 2, 0, -3, -3, 0, 5, 4, -1, -1, 5, 0, 2, -3, 1, -4, -1, 3, 0, 2, 1, 1, 1, -1, 5, 2, 1, -5, -2, -2, 2, 2, -4, -2, -1, -5, -8, -6, 5, 1, -3, -5, 1, -1, -1, -3, 3, 3, 3, 1, -1, 0, -5, -5, 4, 5, -3, 0, -1, -1, -3, -6, 3, -4, 2, 1, -3, 3, 0, -2, -2, -4, 2, -4, -1, -2, 0, 4, 0, -2, -3, 0, 2, 0, -1, -2, -2, 5, 4, 0, -6, -1, 2, -2, 3, 0, -3, -3, 2, 4, -1, -1, 2, -9, 1, -1, -5, 4, 5, 1, -2, -4, -2, -2, 7, -2, -1, -4, -8, -1, 3, -2, 3, -1, -6, -1, 1, -4, -1, 1, -1, 5, -5, 0, -3, 3, -3, -1, 3, -1, -4, 5, 1, -6, -4, -4, 2, 0, -4, 4, 3, 2, 4, -2, -7, -6, -2, 1, 4, 3, 3, -1, 3, -9, -2, -1, -3, -4, 4, -3, 1, 4, -4, -1, -3, 4, -6, -3, 5, 1, 0, -2, 0, -3, 1, -2, 1, 1, 3, -3, -4, -5, 2, 2, 5, -2, -1, -4, -1, 8, -3, -9, -6, 1, 4, -4, 0, -2, 0, 2, -1, 6, -5, -9, -3, -2, 1, -3, -6, -1, -3, 3, 2, -1, 2, -5, 2, -3, 2, -5, 1, 0, -2, 1, 0, -1, 0, -2, 3, -4, 3, 1, -1, -8, -3, -7, -1, -3, 0, -5, -1, 2, -6, 2, 3, 1, 8, 5, -3, 0, -4, -3, -2, 2, -1, -5, 2, -6, 1, -4, 2, -5, 4, 1, -1, -2, -3, -4, -4, -3, 0, -1, 0, -4, -5, 2, -1, 2, 5, -5, -2, -1, -1, 3, -1, -2, 2, -5, -5, -4, 0, 2, 4, -4, 1, -2, 6, -1, 0, -3, 0, -2, -3, -1, -1, 0, -2, -1, -3, 0, 2, 1, -2, -7, 1, -2, -7, 0, -2, -7, -2, 7, -6, 1, 5, 0, 2, 1, -4, 2, -1, 7, 3, 2, -4, -1, -1, -4, -1, 1, -3, 1, -5, -1, -8, 3, 0, 0, -5, 5, -2, 1, 1, 3, 3, 5, -2, 6, -2, -1, -5, 2, 3, 2, 0, -5, -1, -5, -4, -5, -1, -2, 0, 1, -6, 5, 0, 2, -6, 4, -2, 0, -5, 1, 4, 0, -2, 0, 3, 0, -3, 0, 1, 0, 0, 1, -2, 1, 2, -1, 0, -1, 2, 0, 3, -7, 3, 6, -3, -2, -1, -2, -3, 2, 3, -1, -3, -1, 2, 2, -1, -2, 3, -1, 1, -2, -1, -1, -5, 0, 2, 1, 0, 1, -2, 1, 10, -1, 1, -5, -4, 1, -2, 0, -3, -11, -2, -6, 0, -1, 3, 6, 2, 4, -2, -4, 5, -2, -6, -3, 0, 1, 1, 3, 3, -1, 1, 1, 2, -8, -1, -1, 4, 2, -4, 1, -2, -2, -1, 2, -6, 4, -1, 1, -2, -3, -3, 0, -1, -4, -2, 5, 4, -3, 0, -3, -6, 1, 2, 3, 1, -4, -3, 3, -5, 3, -1, 3, 1, -1, 2, -4, 2, 4, 4, 1, -2, -5, 2, 1, 1, 3, -1, 2, -2, -2, 1, -2, 4, -2, 4, 1, -2, -2, -1, -3, -4, 4, 0, 3, -1, 5, -3, 5, -4, 0, 1, 1, -7, -1, -2, -3, -5, 1, 5, -3, -2, 2, 8, -3, -4, 1, -2, 3, 1, -7, -2, -4, 1, 5, -7, 6, 3, -2, -2, -2, 1, 3, -4, 0, -3, -1, -2, 1, 5, -8, -3, -1, -1, 1, -1, -2, -3, 6, 6, 1, -2, 0, 1, 3, 5, 5, -2, 7, 0, -1, 4, 0, -5, 3, -1, -1, 0, -3, -3, 0, -5, -1, -5, -3, 6, 3, -3, -1, -4, -5, -3, 3, 1, 0, -7, -2, -4, 1, -5, 3, -8, -1, -3, 5, 0, 2, 5, 2, -3, -1, 1, 1, -2, -2, 1, 2, 2, -6, 2, 0, -1, 0, -1, 0, 2, 3, 0, -3, 1, -3, -6, -3, -6, -1, -2, 4, 0, 1, 3, 1, -6, 7, 0, 3, 2, -2, -7, -5, -1, 2, -1, 2, 2, 2, 2, 3, 3, -2, 0, -5, 1, 3, 4, -3, -3, 2, 1, -6, 2, -4, -2, 1, 4, -7, 4, 0, 0, 0, 1, 1, -3, -1, -4, -1, -2, 1, -4, 3, -3, -1, -7, 0, -1, -1, 4, -3, -4, 2, -1, 0, -2, -1, -5, -3, 0, 3, -3, 2, -4, -1, -1, 0, -5, 0, 4, 3, -5, -4, -6, 4, 2, -2, 6, -1, -3, -5, -3, 1, 1, 2, 1, 3, -3, 1, -7, 2, 3, 6, -2, -4, 1, 5, -2, -3, -3, -8, -6, -5, 0, -4, 1, -9, 3, -3, 0, -5, -1, -5, 4, -2, -4, 2, 3, 4, -4, 2, 0, 6, -2, 5, -1, 2, -1, -3, -1, -3, 3, 2, -7, -1, 1, 2, -10, -2, -2, -2, -5, 1, -3, -2, -3, -5, 1, -3, -6, 1, -1, 1, -2, -6, 3, -2, 0, -1, -1, 2, 2, -2, -1, -2, -7, 2, 3, -4, -5, -2, -5, -7, 5, 1, -1, -6, 2, 0, -5, 0, 1, -4, 0, -3, 1, -1, 0, 0, -2, 1, 1, -1, -5, -3, -2, -2, -6, -1, -5, 1, 0, 0, -1, -2, 2, 6, -4, -2, -7, 6, 0, -2, 0, -1, 3, 0, -1];

const ADD_ROUNT_MULT = 0x7fff;
const MULT_SHIFT = 0x7fff;

// index of CS16 element
const re = 0;
const im = 1;

class SC16 {
    re: integer;
    im: integer;

    constructor() {
        this.re = 0;
        this.im = 0;
    }
}


function fft(data: integer[]) {
    const cs = new SC16();
    const mData = new SC16();
    const aData = new SC16();

    let ie = 1;
    let n2: integer = DATA_LEN / 4;

    while (n2 > 0) {
        let ia = 0;
        let j = 0;
        while (j < ie) {
            cs.re= FFT_TABLE[2 * j];
            cs.im = FFT_TABLE[2 * j + 1];

            for (let i = 0; i < n2; i++) {
                let m = ia + n2;

                mData.re = data[2 * m];
                mData.im = data[2 * m + 1];

                aData.re = data[2 * ia];
                aData.im = data[2 * ia + 1];

                let m1 = new SC16();
                let result = aData.re * MULT_SHIFT;
                result -= cs.re * mData.re + cs.im * mData.im;
                result += ADD_ROUNT_MULT;
                result = result >> 16;
                m1.re = result;
                result = aData.im * MULT_SHIFT;
                result -= (cs.re * mData.im - cs.im * mData.re);
                result += ADD_ROUNT_MULT;
                result = result >> 16;
                m1.im = result;

                data[m * 2] = m1.re;
                data[m * 2 + 1] = m1.im;

                let m2 = new SC16();
                result = aData.re * MULT_SHIFT;
                result += cs.re * mData.re + cs.im * mData.im;
                result += ADD_ROUNT_MULT;
                result = result >> 16;
                m2.re = result;

                result = aData.im * MULT_SHIFT;
                result += cs.re * mData.im - cs.im * mData.re;
                result += ADD_ROUNT_MULT;
                result = result >> 16;
                m2.im = result;

                data[ia * 2] = m2.re;
                data[ia * 2 + 1] = m2.im;
                ia += 1;
            }
            ia += n2;
            j += 1;
        }
        ie <<= 1;
        n2 >>= 1;
    }
}




function benchmark(cycle: integer) {
    for (let i = 0; i < cycle; i++) {
        const inoutData: integer[] = [ 137, 28, 196, 170, 4, 227, 217, 225, 112, 148, 41, 53, 42, 226, 232, 36, 215, 195, 169, 17, 42, 206, 218, 253, 75, 231, 134, 10, 196, 61, 35, 3, 52, 5, 55, 209, 8, 227, 1, 177, 253, 182, 69, 163, 164, 3, 100, 133, 235, 21, 79, 241, 211, 64, 12, 166, 137, 43, 64, 175, 124, 150, 65, 145, 49, 36, 172, 210, 93, 230, 70, 145, 152, 207, 170, 103, 227, 78, 177, 166, 3, 24, 150, 179, 123, 160, 103, 76, 9, 13, 117, 200, 204, 160, 237, 189, 183, 77, 8, 218, 147, 20, 239, 209, 128, 97, 160, 141, 225, 199, 8, 53, 191, 25, 44, 129, 200, 9, 171, 231, 225, 119, 71, 119, 73, 236, 65, 106, 15, 94, 137, 230, 226, 185, 0, 200, 184, 49, 196, 10, 147, 100, 91, 243, 93, 227, 23, 175, 195, 151, 129, 157, 28, 217, 29, 248, 59, 196, 128, 82, 120, 149, 238, 233, 79, 26, 109, 57, 245, 123, 147, 55, 161, 183, 59, 112, 232, 149, 71, 48, 71, 205, 186, 238, 192, 177, 23, 104, 220, 143, 36, 74, 26, 54, 200, 162, 56, 231, 50, 176, 66, 103, 83, 147, 106, 139, 4, 136, 119, 54, 113, 123, 58, 142, 103, 100, 36, 72, 214, 135, 18, 6, 101, 47, 246, 44, 65, 37, 81, 46, 187, 205, 126, 49, 0, 52, 75, 78, 0, 151, 88, 157, 174, 22, 214, 221, 244, 13, 11, 15, 54, 78, 65, 121, 58, 244, 124, 233, 4, 240, 154, 30, 27, 132, 239, 89, 7, 228, 128, 108, 209, 53, 245, 238, 140, 203, 36, 237, 8, 198, 166, 208, 240, 152, 5, 65, 97, 176, 49, 62, 192, 153, 103, 120, 27, 215, 253, 115, 63, 101, 106, 120, 61, 67, 128, 80, 191, 208, 113, 152, 6, 41, 160, 36, 101, 245, 175, 231, 70, 92, 57, 124, 19, 83, 114, 100, 214, 20, 36, 144, 23, 9, 96, 139, 1, 232, 114, 48, 157, 49, 225, 155, 53, 130, 78, 164, 66, 56, 237, 166, 106, 73, 114, 11, 83, 131, 180, 152, 16, 177, 129, 238, 175, 224, 165, 176, 251, 64, 146, 244, 151, 39, 141, 206, 183, 165, 61, 54, 106, 81, 26, 13, 96, 68, 249, 177, 124, 171, 70, 226, 51, 19, 138, 14, 69, 207, 12, 117, 235, 189, 47, 15, 155, 159, 244, 176, 253, 96, 223, 104, 92, 57, 123, 27, 149, 183, 114, 102, 185, 227, 250, 134, 124, 113, 153, 37, 151, 152, 6, 30, 103, 148, 187, 92, 186, 26, 239, 78, 243, 229, 195, 91, 96, 33, 105, 1, 150, 222, 187, 107, 170, 249, 220, 187, 62, 25, 209, 159, 66, 44, 186, 248, 252, 251, 11, 126, 49, 113, 104, 112, 171, 86, 17, 157, 149, 182, 46, 12, 182, 2, 26, 78, 176, 68, 182, 179, 23, 132, 120, 49, 157, 87, 71, 237, 29, 131, 226, 32, 124, 86, 29, 183, 240, 245, 59, 13, 194, 154, 80, 94, 78, 173, 44, 215, 89, 39, 42, 244, 161, 115, 89, 169, 114, 82, 34, 158, 94, 197, 153, 35, 21, 150, 15, 24, 238, 141, 87, 12, 159, 123, 207, 170, 209, 4, 100, 116, 118, 82, 98, 26, 156, 51, 4, 237, 17, 154, 46, 185, 233, 172, 134, 164, 31, 218, 232, 211, 37, 214, 123, 86, 23, 142, 234, 31, 194, 222, 208, 4, 12, 143, 253, 57, 7, 198, 225, 84, 115, 90, 177, 210, 131, 54, 40, 72, 146, 151, 55, 149, 246, 182, 125, 114, 62, 148, 162, 241, 3, 167, 134, 105, 88, 181, 57, 107, 81, 159, 186, 79, 225, 52, 193, 94, 167, 177, 152, 170, 166, 62, 120, 96, 3, 6, 38, 122, 53, 56, 49, 22, 30, 102, 239, 30, 249, 38, 235, 178, 18, 138, 222, 84, 56, 86, 18, 120, 216, 39, 145, 149, 7, 242, 147, 134, 213, 221, 24, 99, 219, 180, 119, 222, 167, 212, 113, 71, 85, 197, 13, 152, 142, 130, 100, 48, 179, 243, 156, 135, 0, 134, 107, 121, 130, 226, 180, 41, 60, 125, 111, 40, 5, 159, 244, 135, 218, 240, 21, 105, 51, 246, 253, 233, 34, 148, 146, 117, 145, 182, 56, 226, 85, 154, 162, 23, 230, 53, 102, 103, 192, 224, 68, 243, 71, 13, 1, 253, 206, 196, 108, 72, 196, 136, 148, 102, 98, 163, 208, 93, 150, 84, 129, 234, 229, 141, 230, 56, 61, 192, 212, 41, 6, 9, 31, 244, 199, 218, 52, 141, 132, 33, 252, 101, 162, 21, 151, 137, 28, 59, 130, 24, 152, 119, 127, 1, 104, 105, 110, 243, 226, 211, 194, 34, 173, 252, 175, 60, 16, 88, 71, 232, 214, 157, 176, 99, 21, 99, 235, 103, 182, 241, 221, 15, 92, 215, 160, 141, 225, 89, 34, 177, 16, 128, 120, 135, 137, 109, 208, 19, 170, 84, 61, 73, 87, 63, 8, 137, 158, 39, 1, 41, 126, 128, 11, 202, 29, 214, 33, 63, 193, 2, 13, 124, 236, 98, 204, 6, 108, 125, 29, 63, 20, 171, 53, 62, 19, 222, 219, 172, 129, 142, 45, 97, 233, 172, 32, 82, 91, 149, 27, 123, 247, 146, 132, 128, 23, 66, 173, 246, 122, 237, 66, 201, 210, 82, 72, 63, 100, 86, 234, 207, 96, 196, 170, 219, 205, 28, 72, 174, 13, 253, 19, 106, 170, 218, 216, 56, 39, 33, 232, 208, 240, 54, 208, 204, 188, 95, 95, 89, 170, 140, 236, 6, 221, 101, 229, 55, 159, 6, 143, 206, 70, 189, 19, 124, 106, 130, 81, 157, 173, 163, 3, 131, 125, 150, 11, 21, 80, 189, 78, 127, 82, 115, 212, 210, 29, 213, 153, 187, 63, 51, 3, 126, 111, 64, 127, 172, 68, 74, 193, 206, 157, 17, 124, 73, 106, 93, 120, 42, 187, 211, 195, 178, 183, 65, 241, 31, 72, 164, 66, 85, 223, 188, 119, 82, 118, 7, 1, 249, 170, 65, 248, 122, 73, 244, 53, 117, 123, 50, 234, 100, 216, 187, 230, 183, 237, 109];
        fft(inoutData);
        for (let i = 0; i < DATA_LEN; i++) {
            assert(abs(inoutData[i] - ANSWER[i]) < 3);
        }
    }
}

