const DATA_LEN = 1024;
const ANSWER = 1837082096;

const DATA: integer[] = [
    137, 28, 196, 170, 4, 227, 217, 225, 112, 148, 41, 53, 42, 226, 232, 36, 215,
    195, 169, 17, 42, 206, 218, 253, 75, 231, 134, 10, 196, 61, 35, 3, 52, 5, 55,
    209, 8, 227, 1, 177, 253, 182, 69, 163, 164, 3, 100, 133, 235, 21, 79, 241,
    211, 64, 12, 166, 137, 43, 64, 175, 124, 150, 65, 145, 49, 36, 172, 210, 93,
    230, 70, 145, 152, 207, 170, 103, 227, 78, 177, 166, 3, 24, 150, 179, 123,
    160, 103, 76, 9, 13, 117, 200, 204, 160, 237, 189, 183, 77, 8, 218, 147, 20,
    239, 209, 128, 97, 160, 141, 225, 199, 8, 53, 191, 25, 44, 129, 200, 9, 171,
    231, 225, 119, 71, 119, 73, 236, 65, 106, 15, 94, 137, 230, 226, 185, 0, 200,
    184, 49, 196, 10, 147, 100, 91, 243, 93, 227, 23, 175, 195, 151, 129, 157, 28,
    217, 29, 248, 59, 196, 128, 82, 120, 149, 238, 233, 79, 26, 109, 57, 245, 123,
    147, 55, 161, 183, 59, 112, 232, 149, 71, 48, 71, 205, 186, 238, 192, 177, 23,
    104, 220, 143, 36, 74, 26, 54, 200, 162, 56, 231, 50, 176, 66, 103, 83, 147,
    106, 139, 4, 136, 119, 54, 113, 123, 58, 142, 103, 100, 36, 72, 214, 135, 18,
    6, 101, 47, 246, 44, 65, 37, 81, 46, 187, 205, 126, 49, 0, 52, 75, 78, 0, 151,
    88, 157, 174, 22, 214, 221, 244, 13, 11, 15, 54, 78, 65, 121, 58, 244, 124,
    233, 4, 240, 154, 30, 27, 132, 239, 89, 7, 228, 128, 108, 209, 53, 245, 238,
    140, 203, 36, 237, 8, 198, 166, 208, 240, 152, 5, 65, 97, 176, 49, 62, 192,
    153, 103, 120, 27, 215, 253, 115, 63, 101, 106, 120, 61, 67, 128, 80, 191,
    208, 113, 152, 6, 41, 160, 36, 101, 245, 175, 231, 70, 92, 57, 124, 19, 83,
    114, 100, 214, 20, 36, 144, 23, 9, 96, 139, 1, 232, 114, 48, 157, 49, 225,
    155, 53, 130, 78, 164, 66, 56, 237, 166, 106, 73, 114, 11, 83, 131, 180, 152,
    16, 177, 129, 238, 175, 224, 165, 176, 251, 64, 146, 244, 151, 39, 141, 206,
    183, 165, 61, 54, 106, 81, 26, 13, 96, 68, 249, 177, 124, 171, 70, 226, 51,
    19, 138, 14, 69, 207, 12, 117, 235, 189, 47, 15, 155, 159, 244, 176, 253, 96,
    223, 104, 92, 57, 123, 27, 149, 183, 114, 102, 185, 227, 250, 134, 124, 113,
    153, 37, 151, 152, 6, 30, 103, 148, 187, 92, 186, 26, 239, 78, 243, 229, 195,
    91, 96, 33, 105, 1, 150, 222, 187, 107, 170, 249, 220, 187, 62, 25, 209, 159,
    66, 44, 186, 248, 252, 251, 11, 126, 49, 113, 104, 112, 171, 86, 17, 157, 149,
    182, 46, 12, 182, 2, 26, 78, 176, 68, 182, 179, 23, 132, 120, 49, 157, 87, 71,
    237, 29, 131, 226, 32, 124, 86, 29, 183, 240, 245, 59, 13, 194, 154, 80, 94,
    78, 173, 44, 215, 89, 39, 42, 244, 161, 115, 89, 169, 114, 82, 34, 158, 94,
    197, 153, 35, 21, 150, 15, 24, 238, 141, 87, 12, 159, 123, 207, 170, 209, 4,
    100, 116, 118, 82, 98, 26, 156, 51, 4, 237, 17, 154, 46, 185, 233, 172, 134,
    164, 31, 218, 232, 211, 37, 214, 123, 86, 23, 142, 234, 31, 194, 222, 208, 4,
    12, 143, 253, 57, 7, 198, 225, 84, 115, 90, 177, 210, 131, 54, 40, 72, 146,
    151, 55, 149, 246, 182, 125, 114, 62, 148, 162, 241, 3, 167, 134, 105, 88,
    181, 57, 107, 81, 159, 186, 79, 225, 52, 193, 94, 167, 177, 152, 170, 166, 62,
    120, 96, 3, 6, 38, 122, 53, 56, 49, 22, 30, 102, 239, 30, 249, 38, 235, 178,
    18, 138, 222, 84, 56, 86, 18, 120, 216, 39, 145, 149, 7, 242, 147, 134, 213,
    221, 24, 99, 219, 180, 119, 222, 167, 212, 113, 71, 85, 197, 13, 152, 142,
    130, 100, 48, 179, 243, 156, 135, 0, 134, 107, 121, 130, 226, 180, 41, 60,
    125, 111, 40, 5, 159, 244, 135, 218, 240, 21, 105, 51, 246, 253, 233, 34, 148,
    146, 117, 145, 182, 56, 226, 85, 154, 162, 23, 230, 53, 102, 103, 192, 224,
    68, 243, 71, 13, 1, 253, 206, 196, 108, 72, 196, 136, 148, 102, 98, 163, 208,
    93, 150, 84, 129, 234, 229, 141, 230, 56, 61, 192, 212, 41, 6, 9, 31, 244,
    199, 218, 52, 141, 132, 33, 252, 101, 162, 21, 151, 137, 28, 59, 130, 24, 152,
    119, 127, 1, 104, 105, 110, 243, 226, 211, 194, 34, 173, 252, 175, 60, 16, 88,
    71, 232, 214, 157, 176, 99, 21, 99, 235, 103, 182, 241, 221, 15, 92, 215, 160,
    141, 225, 89, 34, 177, 16, 128, 120, 135, 137, 109, 208, 19, 170, 84, 61, 73,
    87, 63, 8, 137, 158, 39, 1, 41, 126, 128, 11, 202, 29, 214, 33, 63, 193, 2,
    13, 124, 236, 98, 204, 6, 108, 125, 29, 63, 20, 171, 53, 62, 19, 222, 219,
    172, 129, 142, 45, 97, 233, 172, 32, 82, 91, 149, 27, 123, 247, 146, 132, 128,
    23, 66, 173, 246, 122, 237, 66, 201, 210, 82, 72, 63, 100, 86, 234, 207, 96,
    196, 170, 219, 205, 28, 72, 174, 13, 253, 19, 106, 170, 218, 216, 56, 39, 33,
    232, 208, 240, 54, 208, 204, 188, 95, 95, 89, 170, 140, 236, 6, 221, 101, 229,
    55, 159, 6, 143, 206, 70, 189, 19, 124, 106, 130, 81, 157, 173, 163, 3, 131,
    125, 150, 11, 21, 80, 189, 78, 127, 82, 115, 212, 210, 29, 213, 153, 187, 63,
    51, 3, 126, 111, 64, 127, 172, 68, 74, 193, 206, 157, 17, 124, 73, 106, 93,
    120, 42, 187, 211, 195, 178, 183, 65, 241, 31, 72, 164, 66, 85, 223, 188, 119,
    82, 118, 7, 1, 249, 170, 65, 248, 122, 73, 244, 53, 117, 123, 50, 234, 100,
    216, 187, 230, 183, 237, 109
]

function make_table(poly: integer) {
    let table = new Array<integer>(256, 0);
    for (let i = 0; i < 256; i++) {
        let byte = i;
        let crc = 0;
        for (let bit = 0; bit < 8; bit++) {
            if ((byte ^ crc) & 1) {
                crc = (crc >>> 1) ^ poly;
            } else {
                crc = crc >>> 1;
            }
            byte = byte >>> 1;
        }
        table[i] = crc;
    }
    return table;
}

function calc(bytes: integer[], table: integer[]) {
    let value = 0xffffffff;
    for (let i = 0; i < DATA_LEN; i++) {
        value = table[(bytes[i] ^ value) & 0xff] ^ (value >>> 8);
    }
    return (-1 - value) & 0xffffffff;
}

function verify_result(result: integer) {
    return ANSWER === result;
}



function benchmark(cycle: integer) {
    for (let i = 0; i < cycle; i++) {
        let table = make_table(0xedb88320);
        let result = calc(DATA, table);
        assert(verify_result(result));
    }
}


