// This code is derived from microbit example project (https://github.com/microsoft/pxt-microbit/blob/master/docs/projects/flashing-heart.md).
// 
// Copyright (c) Microsoft Corporation
// Copyright (c) 2024 Fumika Mochizuki. 
// 
//
// All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

// Cell1
import { Display } from 'display';
import { setInterval } from 'timer';

let dspl = new Display();
let colorWhite = dspl.color(255, 255, 255);
let colorRed = dspl.color(255, 0, 0);
dspl.showIcon(dspl.ICON_HEART, colorRed, colorWhite);
print("$$");

// Cell2
dspl.showIcon(dspl.ICON_HEART, colorRed, colorWhite);
dspl.fill(colorWhite);
print("$$");

// Cell3
let isSmall = false;
setInterval(() => {
    if (isSmall) {
        dspl.showIcon(dspl.ICON_SMALL_HEART, colorRed, colorWhite);
    } else {
        dspl.showIcon(dspl.ICON_HEART, colorRed, colorWhite);
    }
    isSmall = !isSmall;
}, 500);
print("$$");