// This code is derived from microbit example project (https://github.com/microsoft/pxt-microbit/blob/master/docs/projects/dice.md).
// 
// Copyright (c) Microsoft Corporation
// Copyright (c) 2024 Fumika Mochizuki. 
// 
//
// All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

// Cell1
import { Display } from 'display';
import { buttonOnPressed } from 'button'

const BUTTON_PIN_B = 38;
buttonOnPressed(BUTTON_PIN_B, () => {})
print("$$");


// Cell2
let dspl = new Display();
const colorWhite = dspl.color(255, 255, 255);
const colorBlack = dspl.color(0, 0, 0);
dspl.fill(colorWhite);
buttonOnPressed(BUTTON_PIN_B, () => {
    dspl.showInt(0, colorBlack, colorWhite);
})
print("$$");


// Cell3
dspl.fill(colorWhite);
buttonOnPressed(BUTTON_PIN_B, () => {
    dspl.showInt(randInt(0, 10), colorBlack, colorWhite);
})
print("$$");


// Cell4
dspl.fill(colorWhite);
buttonOnPressed(BUTTON_PIN_B, () => {
    dspl.showInt(randInt(0, 6), colorBlack, colorWhite);
})
print("$$");
