// This code is derived from "Are We Fast Yet?" benchmarks (https://github.com/smarr/are-we-fast-yet/).
//
// Copyright (c) 2015-2016 Stefan Marr <git@stefan-marr.de>
// Copyright (c) 2024 Fumika Mochizuki. 
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the 'Software'), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.


const DEPTH = 5;
const RESULT = 341;


class Random {
    seed: integer;

    constructor () {
        this.seed = 74755;
    }

    next() {
        this.seed = ((this.seed * 1309) + 13849) & 65535;
        return this.seed;
    }
}


let count = 0;

function buildTreeDepth(depth: integer, random: Random): any[] {
    count += 1;
    if (depth == 1) {
        return new Array<any>(random.next() % 10 + 1, 0);
    }

    let arr = new Array<any>(4, 0);
    for (let i = 0; i < 4; i++) {
        arr[i] = buildTreeDepth(depth - 1, random);
    }
    return arr;
}

function storage() {
    let random = new Random();
    count = 0;
    buildTreeDepth(DEPTH, random);
   return count;
}

function verifyResult(result: integer) {
    return result === RESULT;
}


function benchmark(cycle: integer) {
    for (let i = 0; i < cycle; i++) {
        let result = storage();
        assert(verifyResult(result));
    }
}


