// This code is derived from "Are We Fast Yet?" benchmarks (https://github.com/smarr/are-we-fast-yet/).
//
// Copyright (c) 2015-2016 Stefan Marr <git@stefan-marr.de>
// Copyright (c) 2024 Fumika Mochizuki. 
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the 'Software'), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.


let freeRows: boolean[] = new Array<boolean>(8, true);
let freeMaxs: boolean[] = new Array<boolean>(16, true);
let freeMins: boolean[] = new Array<boolean>(16, true);
let queenRows: integer[] = new Array<integer>(8, -1);

function setRowColumn(r: integer, c: integer, v: boolean) {
    freeRows[r] = v;
    freeMaxs[c + r] = v;
    freeMins[c - r + 7] = v;
}

function getRowColumn(r: integer, c: integer) {
    return freeRows[r] && freeMaxs[c + r] && freeMins[c - r + 7];
}

function placeQueen(c: integer):boolean {
    for (let r = 0; r < 8; r++) {
        if (getRowColumn(r, c)) {
            queenRows[r] = c as any;
            setRowColumn(r, c, false);
            if (c == 7) {
                return true;
            }
            if (placeQueen(c + 1)) {
                return true;
            }
            setRowColumn(r, c, true);
        }
    }
    return false;
}

function queens(): boolean {
    freeRows = new Array<boolean>(8, true);
    freeMaxs = new Array<boolean>(16, true);
    freeMins = new Array<boolean>(16, true);
    queenRows = new Array<integer>(8, -1);
    return placeQueen(0);
}

function verifyResult(result: boolean) {
    return result;
}


function benchmark(cycle: integer) {
    for (let i = 0; i < cycle; i++) {
        let result: boolean = true;
        for (let i = 0; i < 10; i++) {
            result = result && queens();
        }
        assert(verifyResult(result));
    }
}


