// This code is derived from "Are We Fast Yet?" benchmarks (https://github.com/smarr/are-we-fast-yet/).
//
// Copyright (c) 2015-2016 Stefan Marr <git@stefan-marr.de>
// Copyright (c) 2024 Fumika Mochizuki. 
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the 'Software'), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.


const RESULT = 10;

class Element {
    val: integer
    next: Element
    isSentinel: boolean

    constructor(val: integer) {
        this.val = val;
        this.next = this;
        this.isSentinel = false;
    }

    length():integer {
        if (this.isSentinel) {
            return 0;
        } else {
            return 1 + this.next.length();
        }
    }
}

function makeList(length: integer): Element {
    if (length === 0) {
        const sentinel = new Element(0);
        sentinel.isSentinel = true;
        return sentinel;
    } else {
        const e = new Element(length);
        e.next = makeList(length - 1);
        return e;
    }
}

function isShorterThan(x: Element, y:Element) {
    let xTail = x;
    let yTail = y;

    while (!yTail.isSentinel) {
        if (xTail.isSentinel) {
            return true;
        }
        xTail = xTail.next;
        yTail = yTail.next;
    }
    return false;
}

function tail(x: Element, y: Element, z: Element) {
    if (isShorterThan(y, x)) {
        return tail(
            tail(x.next, y, z),
            tail(y.next, z, x),
            tail(z.next, x, y)
        )
    }
    return z;
}


function verifyResult(result: integer) {
    return result === RESULT;
}



function benchmark(cycle: integer) {
    for (let i = 0; i < cycle; i++) {
        const result:Element = tail(makeList(15), makeList(10), makeList(6))
        verifyResult(result.length())
        assert(verifyResult(result.length()));
    }
}


