// This code is derived from "Are We Fast Yet?" benchmarks (https://github.com/smarr/are-we-fast-yet/).
//
// Copyright (c) 2015-2016 Stefan Marr <git@stefan-marr.de>
// Copyright (c) 2024 Fumika Mochizuki. 
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the 'Software'), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.


const RESULT = 1331;

class Random {
    seed: integer;

    constructor () {
        this.seed = 74755;
    }

    next() {
        this.seed = ((this.seed * 1309) + 13849) & 65535;
        return this.seed;
    }
}

class Ball {
    x: integer;
    y: integer;
    xVel: integer;
    yVel: integer;

    constructor(random: Random) {
        this.x = random.next() % 500;
        this.y = random.next() % 500;
        this.xVel = (random.next() % 300) - 150;
        this.yVel = (random.next() % 300) - 150;
    }

    bounce() {
        const xLimit = 500;
        const yLimit = 500;
        let bounced = false;

        this.x += this.xVel;
        this.y += this.yVel;

        if (this.x > xLimit) {
        this.x = xLimit; this.xVel = 0 - abs(this.xVel); bounced = true;
        }

        if (this.x < 0) {
        this.x = 0; this.xVel = abs(this.xVel); bounced = true;
        }

        if (this.y > yLimit) {
        this.y = yLimit; this.yVel = 0 - abs(this.yVel); bounced = true;
        }

        if (this.y < 0) {
        this.y = 0; this.yVel = abs(this.yVel); bounced = true;
        }

        return bounced;
  }
}


function verify_result(result: integer) {
    return result === RESULT;
}


function benchmark(cycle: integer) {
    for (let i = 0; i < cycle; i++) {
        const random = new Random();
        const ballCount = 100;
        let bounces = 0;
        const ball0 = new Ball(random);
        const balls = new Array<Ball>(ballCount, ball0);
        let i = 0;

        for (i = 1; i < ballCount; i += 1) {
            balls[i] = new Ball(random);
        }

        for (i = 0; i < 50; i += 1) {
            for (let j = 0; j < ballCount; j++) {
                const ball = balls[j];
                if (ball.bounce()) {
                    bounces += 1;
                }
            }
        }
        assert(verify_result(bounces));
    }
}


