// This code is derived from "Are We Fast Yet?" benchmarks (https://github.com/smarr/are-we-fast-yet/).
//
// Copyright (c) 2015-2016 Stefan Marr <git@stefan-marr.de>
// Copyright (c) 2024 Fumika Mochizuki. 
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the 'Software'), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.


const RESULT = 8191;

class TowersDisk {
    size: integer;
    next: TowersDisk;

    constructor(size) {
        this.size = size;
        this.next = this;
    }
}

let sentinelPile = new TowersDisk(-1);
let piles = new Array<TowersDisk>(3, sentinelPile);
let movesDone = 0;



function pushDisk(disk, pile) {
    const top = piles[pile];
    if (top.size != -1 && disk.size >= top.size) {
        assert(false);
    }
    disk.next = top;
    piles[pile] = disk;
}

function popDiskFrom(pile) {
    const top = piles[pile];
    if (top.size === -1) {
        assert(false);
    }
    piles[pile] = top.next;
    top.next = sentinelPile;
    return top;
}

function moveTopDisk(fromPile, toPile) {
    pushDisk(popDiskFrom(fromPile), toPile);
    movesDone += 1;
}

function buildTowerAt(pile, disks) {
    for (let i = disks; i >= 0; i--) {
        pushDisk(new TowersDisk(i), pile);
    }
}

function moveDisks(disks, fromPile, toPile) {
    if (disks === 1) {
        moveTopDisk(fromPile, toPile);
    } else {
        const otherPile = (3 - fromPile) - toPile;
        moveDisks(disks - 1, fromPile, otherPile);
        moveTopDisk(fromPile, toPile);
        moveDisks(disks - 1, otherPile, toPile);
    }
}


function verifyResult(result) {
    return result === RESULT;
}


function benchmark(cycle) {
    for (let i = 0; i < cycle; i++) {
        sentinelPile = new TowersDisk(-1);
        piles = new Array<TowersDisk>(3, sentinelPile);
        movesDone = 0;
        buildTowerAt(0, 13);
        moveDisks(13, 0, 1);
        assert(verifyResult(movesDone));
    }
}


