// This code is derived from "Are We Fast Yet?" benchmarks (https://github.com/smarr/are-we-fast-yet/).
//
// Copyright (c) 2015-2016 Stefan Marr <git@stefan-marr.de>
// Copyright (c) 2024 Fumika Mochizuki. 
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the 'Software'), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.


const SIZE = 5000;
const RESULT = 669;

function sieve(flags, size) {
    let primeCount = 0;

    for (let i = 2; i < size + 1; i++) {
        if (flags[i - 1]) {
            primeCount += 1;
            let k = i * 2;
            while (k <= size) {
                flags[k - 1] = false;
                k += i;
            }
        }
    }
    
    return primeCount;
}

function verify_result(result) {
    return result === RESULT;
}

function benchmark(cycle) {
    for (let i = 0; i < cycle; i++) {
        let flags = new Array<boolean>(SIZE, true);
        const result = sieve(flags, SIZE);
        assert(verify_result(result));
    }
}

