// This code is derived from "Are We Fast Yet?" benchmarks (https://github.com/smarr/are-we-fast-yet/).
//
// Copyright (c) 2015-2016 Stefan Marr <git@stefan-marr.de>
// Copyright (c) 2024 Fumika Mochizuki. 
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the 'Software'), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.


const RESULT = 8660;

let count = 0;

function swap(v, i, j) {
    const tmp = v[i];
    v[i] = v[j];
    v[j] = tmp;
}

function permute(v, n) {
    count += 1;
    if (n != 0) {
        let n1 = n - 1;
        permute(v, n1);
        for (let i = n1; i > -1; i--) {
            swap(v, n1, i);
            permute(v, n1);
            swap(v, n1, i);
        }
    }
}

function verify_result(result) {
    return result === RESULT;
}


function benchmark(cycle) {
    for (let i = 0; i < cycle; i++) {
        count = 0;
        let arr = new Array<integer>(6, 0);
        permute(arr, 6);
        assert(verify_result(count));
    }
}
