# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -806.23859810    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +4.96062211E+00  +2.01851066E+00  -5.45283397E-01
   006   +2.33328166E+00  +1.30797874E+00  -1.32234734E+00
   006   +1.96424546E+00  -1.46581753E+00  -1.75209129E+00
   006   +3.73997211E+00  -3.16570805E+00  -1.23321206E+00
   006   +6.23415399E+00  -2.42392182E+00  -2.18900519E-01
   006   +6.74323426E+00  +3.17605810E-01  -5.68223382E-02
   006   +3.16746060E-01  +2.01977997E+00  +1.43430827E+00
   006   +1.62685739E+00  +8.51090831E-01  +3.70074001E+00
   008   +1.34679549E+00  +2.77254098E+00  -3.03588578E+00
   008   +7.79756924E+00  -3.98063809E+00  +4.06623176E-01
   006   -2.22470518E+00  +9.01698178E-01  +8.46188229E-01
   006   -3.82195061E+00  +2.00593365E+00  -9.36425781E-01
   006   -6.16316946E+00  +9.92633306E-01  -1.48998533E+00
   006   -6.97912487E+00  -1.18442466E+00  -2.66178145E-01
   006   -5.41653067E+00  -2.32989128E+00  +1.50114754E+00
   006   -3.07786021E+00  -1.29567231E+00  +2.03062816E+00
   008   -9.25206566E+00  -2.26226513E+00  -7.28702291E-01
   006   +2.80938293E-01  +4.88149192E+00  +1.67980250E+00
   001   -1.01453435E+01  -1.30650453E+00  -1.97787791E+00
   001   -7.35452431E+00  +1.89014484E+00  -2.89353934E+00
   001   -3.21188255E+00  +3.65720769E+00  -1.96832302E+00
   001   -1.90685014E+00  -2.24476686E+00  +3.40684862E+00
   001   -6.05190793E+00  -4.02702123E+00  +2.44410427E+00
   001   +2.16961452E+00  +5.62187266E+00  +2.02315114E+00
   001   -4.84722954E-01  +5.82162643E+00  +2.67444334E-02
   001   -8.90224854E-01  +5.36535267E+00  +3.30876492E+00
   001   +2.07730487E+00  -1.13830096E+00  +3.43918554E+00
   001   +3.36602274E+00  +1.84922177E+00  +4.14013476E+00
   001   +3.73330532E-01  +1.01832080E+00  +5.33115129E+00
   001   +1.60844919E-01  -2.00278704E+00  -2.55132656E+00
   001   +3.45580976E+00  -5.16405654E+00  -1.56329662E+00
   001   +8.64669658E+00  +8.55386294E-01  +4.63503763E-01
   001   +5.35274240E+00  +4.02570400E+00  -4.80589222E-01
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +4.10000000E-07  -1.03000000E-06  +4.40000000E-07
   +4.00000000E-08  -7.90000000E-07  +2.20000000E-07
   -7.00000000E-08  -4.40000000E-07  -5.00000000E-08
   -7.50000000E-07  -9.00000000E-07  +6.00000000E-08
   -7.20000000E-07  -1.48000000E-06  +2.10000000E-07
   -8.00000000E-08  -1.69000000E-06  +3.50000000E-07
   +5.60000000E-07  -1.00000000E-08  +4.00000000E-08
   -7.00000000E-08  -6.10000000E-07  +1.40000000E-07
   +9.10000000E-07  +0.00000000E+00  +2.10000000E-07
   -1.01000000E-06  -1.90000000E-06  +2.20000000E-07
   -3.00000000E-08  +3.80000000E-07  -7.00000000E-08
   +4.40000000E-07  +8.60000000E-07  -1.50000000E-07
   +2.40000000E-07  +1.54000000E-06  -3.50000000E-07
   -3.40000000E-07  +1.66000000E-06  -4.50000000E-07
   -7.70000000E-07  +1.22000000E-06  -4.70000000E-07
   -5.00000000E-07  +7.30000000E-07  -2.60000000E-07
   -6.20000000E-07  +2.26000000E-06  -7.00000000E-07
   +9.70000000E-07  -2.20000000E-07  +2.60000000E-07
   -2.40000000E-07  +2.52000000E-06  -6.20000000E-07
   +5.50000000E-07  +1.90000000E-06  -3.30000000E-07
   +8.10000000E-07  +9.10000000E-07  -8.00000000E-08
   -7.90000000E-07  +2.40000000E-07  -2.20000000E-07
   -1.18000000E-06  +1.32000000E-06  -5.70000000E-07
   +1.16000000E-06  -6.30000000E-07  +3.90000000E-07
   +1.44000000E-06  +1.90000000E-07  +2.60000000E-07
   +9.80000000E-07  +1.00000000E-08  +2.50000000E-07
   -5.40000000E-07  -6.60000000E-07  +1.00000000E-07
   +1.40000000E-07  -1.00000000E-06  +2.30000000E-07
   -2.10000000E-07  -3.90000000E-07  +4.00000000E-08
   -4.50000000E-07  +7.00000000E-08  -9.00000000E-08
   -1.20000000E-06  -7.50000000E-07  -8.00000000E-08
   +9.00000000E-08  -2.09000000E-06  +5.20000000E-07
   +8.60000000E-07  -1.23000000E-06  +5.20000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.23834560E-01  -1.26555810E-01  +7.87562200E-01  +1.31370840E-01  -4.49876700E-02
   +1.93569650E-01  -1.65091400E-01  -3.87269600E-02  -1.46018900E-02  +4.33625100E-01
   -4.99455100E-02  -1.13038840E-01  -1.71702800E-02  -2.97099000E-03  +5.25478760E-01
   -3.70465200E-02  -7.67306000E-03  -4.66697800E-02  +1.86486930E-01  -4.39944000E-02
   +1.70212270E-01  -4.81435000E-03  -3.64002100E-02  -7.74972000E-03  -9.51823200E-02
   -1.91846600E-02  -2.66589000E-02  +7.28040970E-01  -1.07417200E-02  -1.11450400E-02
   -7.65075000E-03  -4.12964600E-02  -1.72821590E-01  -2.94052900E-02  -1.31443310E-01
   +6.34627830E-01  -3.84720000E-04  -1.01714200E-02  +9.45570000E-04  -2.14035400E-02
   -4.26898000E-02  -5.60541200E-02  +2.19200440E-01  +6.41070000E-04  +2.46968700E-01
   -5.28032000E-03  -1.52590000E-04  -2.12718000E-03  +3.11852000E-03  +4.63870000E-03
   +1.63920000E-03  -3.25177260E-01  +1.95178500E-01  -8.60328900E-02  +6.10074220E-01
   +2.45992000E-03  +2.20865000E-03  +1.24576000E-03  +2.39738000E-02  -2.50105900E-02
   +4.27657000E-03  +2.11795500E-01  -3.19109480E-01  +5.22423800E-02  -1.38399420E-01
   +7.97480200E-01  -2.21168000E-03  +5.78520000E-04  -7.25770000E-04  +2.16134000E-03
   +2.73434000E-03  +9.07841000E-03  -8.31415600E-02  +4.64740500E-02  -8.12894800E-02
   +1.76296720E-01  +1.34672900E-02  +1.88979060E-01  +1.29452500E-02  +2.78894100E-02
   +3.27510000E-03  +4.38288000E-03  +4.11435000E-03  +3.79792000E-03  -2.65180900E-02
   +1.75023900E-02  -9.64164000E-03  -1.62635320E-01  -5.84540600E-02  -3.69698900E-02
   +6.85923840E-01  +2.20880500E-02  -2.51730000E-02  +6.79896000E-03  +2.38439000E-03
   +7.45953000E-03  +3.06460000E-03  +2.26827200E-02  +1.71908600E-02  +1.02144000E-02
   -5.01818200E-02  -1.32931740E-01  -2.36809800E-02  -1.89529870E-01  +7.26643020E-01
   +1.84597000E-03  +7.11596000E-03  +3.29790000E-03  +9.20892000E-03  -4.25640000E-04
   -1.04728400E-02  -8.99292000E-03  +9.01912000E-03  -6.48570000E-04  -3.24175900E-02
   -2.70393200E-02  -9.54830700E-02  +1.87759280E-01  -7.42511600E-02  +2.78607130E-01
   -3.35766860E-01  +2.10257040E-01  -7.47006000E-02  -2.38792800E-02  +2.10940000E-02
   -7.00504000E-03  +1.60683000E-03  +3.18124000E-03  +4.90300000E-04  +4.13740000E-04
   -3.33282000E-02  -6.87172000E-03  -1.20710550E-01  -5.79026500E-02  -1.14205300E-02
   +7.71268360E-01  +1.91946090E-01  -3.17529000E-01  +5.22186400E-02  +4.87106000E-03
   +7.77873000E-03  -1.04155000E-03  +7.60710000E-04  -5.75941000E-03  +3.95280000E-04
   -1.38597300E-02  -6.84735000E-03  -4.30912000E-03  -4.84407500E-02  -1.85764440E-01
   -1.76184600E-02  -1.09749880E-01  +6.54900780E-01  -7.56625800E-02  +5.63919600E-02
   -7.25283300E-02  -1.32247900E-02  +4.15991000E-03  +3.35575000E-03  +2.06150000E-04
   +1.09579000E-03  +2.48420000E-04  -7.36255000E-03  -1.22419100E-02  +1.26258900E-02
   -1.19227600E-02  -1.71569500E-02  -8.44592900E-02  +1.83068820E-01  -2.88211000E-02
   +1.72588480E-01  -2.25534700E-02  +2.34097000E-03  +1.80534600E-02  -1.09699000E-02
   +1.66392100E-02  -9.81188000E-02  -3.19346000E-03  +7.83197000E-03  +8.86266000E-03
   +1.08742000E-03  -1.86044000E-03  +5.41480000E-04  -2.30084000E-03  +1.65254000E-03
   +9.82500000E-05  +1.39023000E-03  -1.96060000E-03  +9.00800000E-05  +3.81209430E-01
   -4.88130000E-04  +3.30580000E-04  +9.92740000E-04  -3.34487000E-03  -3.15681200E-02
   +1.93200700E-02  +9.01456000E-03  -7.25233000E-03  -1.57862200E-02  +7.49400000E-04
   -6.57800000E-05  +1.28141000E-03  -4.81270000E-04  -9.83090000E-04  -7.50250000E-04
   -4.87280000E-04  -1.83100000E-04  -4.79900000E-05  +3.33276500E-02  +4.80558010E-01
   +1.41004900E-02  -3.18848000E-03  -4.62304000E-03  -2.48132700E-02  -2.01505100E-02
   +9.29636200E-02  +1.05486200E-02  -1.43590000E-02  -1.33721000E-02  -3.36881000E-03
   +2.41207000E-03  -3.23294000E-03  +2.48464000E-03  -2.20669000E-03  +7.09240000E-04
   -1.83909000E-03  +4.06931000E-03  -2.75540000E-03  +1.50968270E-01  -5.03494800E-02
   +3.06472400E-01  -5.93800000E-04  +8.15970000E-04  +2.54795000E-03  +3.05063000E-03
   -5.50784000E-03  +1.49806300E-02  -3.08090000E-04  -1.00486000E-03  -9.05100000E-04
   -3.12840000E-04  +4.45660000E-04  +2.76180000E-04  +5.96190000E-04  -2.85850000E-04
   +4.67090000E-04  -5.84120000E-04  -3.65450000E-04  +1.14031000E-03  -1.00572380E-01
   +1.90056500E-02  -4.59318400E-02  +5.74497650E-01  -1.22560000E-04  -4.96600000E-04
   +3.72880000E-04  -1.94141000E-03  +3.11668000E-03  -4.09583000E-03  +2.15400000E-04
   -5.73920000E-04  -2.21400000E-04  +1.61140000E-04  -4.72360000E-04  -4.70210000E-04
   +2.54200000E-04  +1.26160000E-03  -6.09150000E-04  +6.32770000E-04  -2.52600000E-05
   -1.26510000E-03  +1.71463400E-02  -1.01034400E-01  +3.37337900E-02  +2.25427600E-02
   +5.86040620E-01  +1.68025000E-03  -4.08820000E-04  -3.59486000E-03  -8.34700000E-05
   +4.53407000E-03  -2.11648500E-02  +2.16700000E-04  +4.70860000E-04  -1.71150000E-03
   -4.81490000E-04  +5.68800000E-05  -5.70980000E-04  -2.71980000E-04  +9.81480000E-04
   -2.30360000E-04  +2.44120000E-04  +3.75310000E-04  -1.86560000E-03  -5.05155900E-02
   +4.06366700E-02  -1.37732110E-01  -2.62678300E-02  +3.43567300E-02  +4.89648100E-01
   -2.59034500E-02  +2.55649600E-02  -4.74693900E-02  -1.18332220E-01  +5.90146000E-02
   -6.67084500E-02  +8.98837000E-03  +1.54219100E-02  -5.40188000E-03  +3.74915000E-03
   -1.20507000E-03  +1.31319000E-03  -2.46740000E-03  -4.03368000E-03  -4.03137000E-03
   -4.01874000E-03  -2.38980000E-03  +2.75740000E-04  +1.81295900E-02  -6.16166000E-03
   -1.82817900E-02  -1.47223000E-03  +8.03110000E-04  +1.73185000E-03  +1.31106680E-01
   +1.34280000E-02  +8.85286000E-03  +1.57053300E-02  +7.72470700E-02  -1.71175640E-01
   +7.81619300E-02  +1.56801500E-02  -4.60860700E-02  +4.74322800E-02  -1.56542000E-03
   -4.87954000E-03  -2.81027000E-03  -4.71289000E-03  -4.89973000E-03  +1.43758000E-03
   -1.33521000E-03  +4.87418000E-03  -6.81690000E-04  -2.82928700E-02  +1.57243000E-03
   +3.81827700E-02  +2.05773000E-03  -9.39000000E-04  -6.38440000E-04  -9.11966100E-02
   +2.05987430E-01  -2.33192100E-02  +1.49414800E-02  -3.09426900E-02  -1.19522070E-01
   +1.22677000E-01  -1.32237180E-01  +2.00319000E-03  +2.14039300E-02  -1.01546800E-02
   +2.93661000E-03  +1.04613000E-03  +2.02821000E-03  -1.05283000E-03  -7.77690000E-04
   -2.74286000E-03  -3.33020000E-03  -3.30033000E-03  +5.34800000E-04  +3.31662200E-02
   +3.39010000E-04  -6.73834000E-02  -1.32205000E-03  +1.15701000E-03  -1.53695000E-03
   +1.17723800E-01  -1.60016800E-01  +2.35189890E-01  +5.53311000E-03  -2.97307000E-03
   +8.62620000E-04  -2.87243000E-03  -1.11183000E-03  -6.45170000E-04  -3.69254000E-03
   -1.27000700E-02  -3.43164000E-03  -5.37564900E-02  +4.42248400E-02  -2.91427900E-02
   -3.84322840E-01  +2.80249860E-01  -1.27078130E-01  +9.43376000E-03  +2.59403700E-02
   -4.66513000E-03  +1.36214000E-03  +4.80620000E-04  -2.33765000E-03  -3.79320000E-04
   +1.69840000E-04  +2.31590000E-04  +1.08211000E-03  +9.65440000E-04  +1.02522000E-03
   +4.26616830E-01  -1.22070400E-02  -6.55172000E-03  -3.62907000E-03  -6.28070000E-04
   -3.18386000E-03  -1.15993000E-03  -3.47568000E-03  +4.62776000E-03  -1.00527000E-03
   +2.07608700E-02  +1.34251600E-02  +7.60112000E-03  +2.80144230E-01  -3.87365640E-01
   +1.12832410E-01  +4.96251400E-02  -5.97951200E-02  +1.89801500E-02  -1.36943000E-03
   -8.43100000E-05  +2.24724000E-03  +3.10980000E-04  -6.53400000E-04  -4.61330000E-04
   +1.27187000E-03  +1.81202000E-03  -1.71340000E-04  -3.41220010E-01  +4.33133220E-01
   +1.56159000E-03  -5.69470000E-04  +2.28199000E-03  -1.90227000E-03  -3.44130000E-04
   +1.42921000E-03  -2.72552000E-03  -5.01695000E-03  +5.34080000E-04  -3.02330700E-02
   +1.74242400E-02  +1.05638700E-02  -1.26180410E-01  +1.11863820E-01  -1.17506280E-01
   -5.28941000E-03  +1.06536800E-02  +2.02855000E-02  +6.02150000E-04  +1.03800000E-04
   -1.03181000E-03  -3.18280000E-04  +3.71620000E-04  +3.16280000E-04  +6.72460000E-04
   +1.83770000E-04  +4.46030000E-04  +1.60236440E-01  -1.37166820E-01  +9.01740700E-02
   +1.17383000E-03  +1.26621000E-03  -5.22730000E-04  -1.97809200E-02  -1.08913000E-02
   +2.82719300E-02  -1.67060000E-03  +2.36582000E-03  +3.13790000E-04  +3.09260000E-04
   -5.98080000E-04  +4.88690000E-04  -5.72700000E-04  -1.13047000E-03  -4.32130000E-04
   -1.01660000E-03  +3.68880000E-04  -3.77970000E-04  -1.52558020E-01  -4.16662700E-02
   -4.67895400E-02  -1.51109900E-02  -3.88675000E-03  -8.85598000E-03  -6.91637000E-03
   +7.11389000E-03  -8.16760000E-03  +1.00050000E-04  +3.57110000E-04  +1.27800000E-05
   +5.45505200E-01  +8.54070000E-04  +9.76000000E-06  -1.22423000E-03  -6.39070000E-04
   -1.46545000E-03  +8.30039000E-03  +2.83613000E-03  -9.66120000E-04  -2.07646000E-03
   -1.69460000E-04  -5.38300000E-05  +2.09200000E-05  -2.36520000E-04  -4.38740000E-04
   +5.46400000E-05  -1.93570000E-04  +4.66230000E-04  +9.22200000E-05  -3.23120900E-02
   -1.05423360E-01  +9.62600000E-05  +1.09182600E-02  +9.11847000E-03  -8.94000000E-06
   -3.10066000E-03  +2.63718000E-03  -1.53423000E-03  +1.58100000E-05  +2.35910000E-04
   -9.01500000E-05  +9.39439400E-02  +5.16827650E-01  +6.36100000E-05  -6.96430000E-04
   -2.41422000E-03  +1.32210000E-02  +5.62206000E-03  -3.16154000E-03  +1.31078000E-03
   -5.56020000E-04  -3.41530000E-04  +5.67560000E-04  -1.62450000E-04  +2.31490000E-04
   -3.38590000E-04  +5.01990000E-04  -3.04180000E-04  +5.19700000E-04  -3.44090000E-04
   +6.52960000E-04  -2.24565200E-02  +7.44859000E-03  -8.11780500E-02  -2.57096600E-02
   -1.01426600E-02  -6.86213000E-03  +2.55877000E-03  +6.50000000E-06  +1.80282000E-03
   +4.21350000E-04  -4.79080000E-04  +2.56040000E-04  +1.36724280E-01  -2.03591090E-01
   +4.11334440E-01  +9.37700000E-05  -7.37100000E-05  +1.93390000E-04  -2.04830000E-04
   +1.01256000E-03  -5.58496000E-03  +6.02400000E-04  +3.62800000E-05  +9.56100000E-05
   -1.39990000E-04  -9.34000000E-05  -4.48400000E-05  -3.43820000E-04  -3.91900000E-05
   +7.82600000E-05  +2.55660000E-04  +5.70900000E-05  +2.43400000E-05  -3.09301400E-02
   +7.89534000E-03  -2.00745600E-02  -3.37065000E-03  -3.94659000E-03  +1.03539000E-03
   -2.11130000E-03  -5.57040000E-04  +2.25640000E-03  +1.62600000E-04  -2.00000000E-05
   +1.08300000E-05  -1.77222550E-01  +1.38906800E-02  -7.01914300E-02  +6.09333030E-01
   +2.10820000E-04  +3.73460000E-04  +2.03680000E-04  -2.42228000E-03  -1.08777000E-03
   +4.65551000E-03  +9.92760000E-04  -1.84390000E-04  -3.84960000E-04  -1.84330000E-04
   -2.08750000E-04  -1.48830000E-04  +1.65500000E-05  -1.80680000E-04  -1.00320000E-04
   -1.36650000E-04  +8.67000000E-06  -3.92500000E-05  -8.75120000E-04  +1.10926500E-02
   -1.29578200E-02  -4.21232000E-03  -1.30951000E-03  +4.34000000E-06  +1.98750000E-04
   +8.37890000E-04  -2.44891000E-03  -3.97600000E-05  +1.02560000E-04  +1.51400000E-05
   +5.66541000E-02  -1.46740190E-01  +9.14565500E-02  +1.53976450E-01  +5.54464480E-01
   -4.24340000E-04  -3.48700000E-04  +3.86780000E-04  +1.65905000E-03  +1.94349000E-03
   -5.70021000E-03  -5.29800000E-05  -7.88850000E-04  -3.56910000E-04  +2.50050000E-04
   +4.34050000E-04  +7.20000000E-06  -3.19190000E-04  +7.82900000E-05  +3.17900000E-05
   +3.32290000E-04  +4.90600000E-05  +9.12800000E-05  -1.45165500E-02  -3.92011000E-03
   +2.96650000E-04  -5.73580000E-04  +3.28390000E-04  +1.36925000E-03  +2.23396000E-03
   -1.29091000E-03  +1.98827000E-03  +2.20410000E-04  -1.17200000E-04  +6.99800000E-05
   -1.07865570E-01  +6.74189700E-02  -1.83638350E-01  +1.39691050E-01  -2.39452840E-01
   +4.21576550E-01  +3.42000000E-05  -5.07200000E-05  -2.02740000E-04  +5.04820000E-04
   -1.82830000E-04  +2.14224000E-03  -5.84810000E-04  -3.09210000E-04  -7.72400000E-05
   +1.92930000E-04  +1.26720000E-04  +1.08340000E-04  +2.95720000E-04  -1.37970000E-04
   +1.03600000E-05  -4.94500000E-05  +9.88000000E-06  +5.97300000E-05  +6.17577000E-03
   +2.67595000E-03  -4.83786000E-03  -7.05340000E-04  -3.31610000E-04  -3.84250000E-04
   -2.01880000E-04  +4.18530000E-04  -2.01670000E-04  -1.57860000E-04  +1.03830000E-04
   -1.56700000E-05  -3.90535000E-02  +3.25248400E-02  -5.21604600E-02  -3.02998740E-01
   -1.20998950E-01  -4.29348200E-02  +6.29481230E-01  +1.63950000E-04  -5.30400000E-05
   -1.03100000E-04  +5.39910000E-04  -9.85740000E-04  +2.67104000E-03  -9.66800000E-04
   -4.13010000E-04  -1.09100000E-04  +1.45300000E-04  +3.15600000E-04  +1.07030000E-04
   +3.30970000E-04  -4.60230000E-04  +4.27900000E-05  -1.57750000E-04  +2.32200000E-04
   -1.23800000E-05  +5.46083000E-03  +1.84516000E-03  +3.10115000E-03  +1.42791000E-03
   +6.42040000E-04  -5.44570000E-04  -7.36920000E-04  +9.36570000E-04  +1.25740000E-04
   -2.94860000E-04  +3.37050000E-04  -8.86600000E-05  -7.93561000E-03  +4.63731900E-02
   -3.44108300E-02  -6.96733700E-02  -1.42629250E-01  +2.54887400E-02  +1.19327670E-01
   +5.14550890E-01  -1.01480000E-04  +3.26800000E-05  +1.74300000E-05  -5.34370000E-04
   +1.62430000E-04  +1.09960000E-04  -9.06400000E-05  +1.48650000E-04  -3.08200000E-05
   +1.31440000E-04  -5.89100000E-05  +1.05990000E-04  -1.57360000E-04  +1.75430000E-04
   -1.21760000E-04  +6.99000000E-05  -1.02400000E-04  -3.24000000E-06  -4.26322000E-03
   +4.02501000E-03  -4.45520000E-04  -8.25560000E-04  -4.96240000E-04  +1.53160000E-04
   +9.59020000E-04  -1.97040000E-04  -2.96330000E-04  +1.72900000E-04  -1.69470000E-04
   +9.20800000E-05  -2.16704700E-02  -1.08277200E-02  +5.52377000E-03  -8.43063600E-02
   -5.30577000E-03  -1.05733860E-01  +1.97322550E-01  -2.36051400E-01  +4.25725250E-01
   -7.02420000E-04  -2.34460000E-04  -1.43680000E-04  +9.69900000E-05  +1.96069000E-03
   -4.01355000E-03  -1.37560000E-04  +4.12690000E-04  +2.06170000E-04  +7.04640000E-04
   +3.70600000E-05  +1.65000000E-04  -1.14779000E-03  +8.12920000E-04  -3.54870000E-04
   +3.13150000E-04  -4.75660000E-04  +9.61500000E-05  -6.98138000E-03  -1.47662000E-03
   +1.27632000E-03  +1.11920000E-04  +1.28210000E-04  +2.64200000E-04  +2.02021000E-03
   -1.02189000E-03  +8.94120000E-04  +9.95160000E-04  -8.58290000E-04  +3.19460000E-04
   +4.68419000E-03  +1.65119100E-02  -5.15483000E-03  -3.79976000E-03  -3.05370500E-02
   +2.10701800E-02  -1.32919570E-01  -7.94739500E-02  +2.53575100E-02  +6.29429840E-01
   +9.70000000E-06  +6.92100000E-05  +2.32800000E-05  -7.44740000E-04  -4.91000000E-06
   -9.03660000E-04  +4.47860000E-04  +2.65900000E-04  -5.65900000E-05  +6.10200000E-05
   -1.05760000E-04  -1.81500000E-05  -4.92350000E-04  +2.45750000E-04  -1.21570000E-04
   +7.34700000E-05  -5.24700000E-05  -3.75800000E-05  -2.57291000E-03  -2.19771000E-03
   +1.63362000E-03  -1.03790000E-04  +1.23750000E-04  +4.74600000E-04  +9.33000000E-06
   -1.36050000E-04  -1.17090000E-04  +3.48430000E-04  -2.70390000E-04  +9.69100000E-05
   +1.66395100E-02  -4.55293800E-02  +3.92439000E-02  -7.42858800E-02  -1.46884300E-02
   -3.05749700E-02  -1.88423600E-02  -2.40954720E-01  +1.22494120E-01  +1.17456790E-01
   +5.41321020E-01  -3.84150000E-04  -2.82840000E-04  -2.66400000E-04  +1.21037000E-03
   +1.27850000E-03  -1.88774000E-03  -6.50360000E-04  +2.15290000E-04  +4.55620000E-04
   +2.47570000E-04  +4.66600000E-05  +6.95000000E-05  -1.12460000E-04  +3.50240000E-04
   -4.52600000E-05  +1.33340000E-04  -2.35160000E-04  +8.74600000E-05  -1.97378000E-03
   +6.21100000E-04  -6.54120000E-04  +9.68400000E-05  +8.73000000E-05  -3.01700000E-04
   +9.41840000E-04  -6.17380000E-04  +9.58750000E-04  +1.95690000E-04  -2.67120000E-04
   +5.89100000E-05  -6.60586000E-03  +3.93971000E-02  -3.96450400E-02  +5.41971000E-02
   -4.34778000E-03  +3.78051700E-02  -2.17861000E-02  +8.70281300E-02  -1.50414350E-01
   +1.72739710E-01  -2.22669460E-01  +4.36575280E-01  +7.38030000E-04  +3.32870000E-04
   +9.98800000E-05  -8.11460000E-04  -2.43904000E-03  +4.36014000E-03  +4.25580000E-04
   -3.45110000E-04  -9.09480000E-04  -1.53040000E-04  +1.38330000E-04  -7.75500000E-05
   +1.08910000E-04  -6.76840000E-04  +6.30200000E-05  -2.30850000E-04  +4.78350000E-04
   -1.27540000E-04  +8.81737000E-03  -3.06690000E-04  -1.73451000E-03  -8.03100000E-05
   +4.69700000E-05  +3.12110000E-04  -2.08106000E-03  +1.41272000E-03  -1.37427000E-03
   -2.82570000E-04  +4.68350000E-04  -1.12240000E-04  -6.99801000E-03  -6.75728100E-02
   +4.12772100E-02  -5.31525900E-02  +3.71954000E-03  -3.26116600E-02  +5.31476500E-02
   +4.32766600E-02  -8.12985000E-03  -1.71651030E-01  +1.08196800E-02  -6.44858800E-02
   +6.20176610E-01  +1.35580000E-04  +4.26400000E-05  +1.21690000E-04  -1.00030000E-04
   -3.19520000E-04  -1.50040000E-04  -1.22680000E-04  -1.51350000E-04  -1.58020000E-04
   +1.52130000E-04  +1.96550000E-04  -2.15800000E-05  -3.61670000E-04  -1.75450000E-04
   -4.87000000E-05  -2.90500000E-05  +1.55570000E-04  -3.55400000E-05  -1.96837000E-03
   -1.87781000E-03  +4.64946000E-03  +8.07440000E-04  -5.54600000E-05  +2.20660000E-04
   -3.13530000E-04  -1.06300000E-05  +6.31700000E-05  +1.60900000E-04  +2.40200000E-05
   +2.68200000E-05  -2.85761700E-02  -1.19180800E-02  +6.53720000E-04  +1.34037000E-03
   -2.26387000E-03  -2.86070000E-04  +1.06170800E-02  -1.48431900E-02  +2.41233200E-02
   +6.79130900E-02  -1.62995720E-01  +1.08753050E-01  +1.57883360E-01  +5.66460550E-01
   +4.97760000E-04  +3.76030000E-04  +1.36710000E-04  -1.23051000E-03  -2.25810000E-03
   +3.90865000E-03  +4.17000000E-05  -1.88360000E-04  -7.12620000E-04  -4.78100000E-05
   +6.81700000E-05  +4.06500000E-05  -1.66000000E-05  -6.40330000E-04  +1.95400000E-05
   -2.13960000E-04  +3.76880000E-04  -8.26300000E-05  +3.17862000E-03  +6.50157000E-03
   +4.69510000E-04  -6.22760000E-04  -3.25820000E-04  -5.39970000E-04  -1.35307000E-03
   +1.23952000E-03  -1.27072000E-03  -1.84410000E-04  +4.00590000E-04  -6.98600000E-05
   +1.33595300E-02  -2.38994100E-02  +3.19634000E-02  -2.94943100E-02  +1.33452000E-03
   -2.12256100E-02  +1.71236800E-02  +4.28744000E-02  -1.45745100E-02  -1.09135230E-01
   +7.60731000E-02  -1.91878300E-01  +1.56755330E-01  -2.46409440E-01  +4.07403690E-01
   -4.05770000E-04  -9.36400000E-05  +2.02220000E-04  -1.26920000E-04  +1.42226000E-03
   -2.81935000E-03  -7.65470000E-04  -3.44230000E-04  +1.38355000E-03  -1.66400000E-05
   +4.39000000E-06  -1.31600000E-05  +1.35230000E-04  +6.64800000E-05  -1.28100000E-05
   +7.93600000E-05  -1.52480000E-04  +6.37300000E-05  -1.43381100E-02  -2.87485900E-02
   +1.18908400E-02  -2.13454000E-03  -1.30056000E-03  +2.04270000E-04  +1.49623000E-03
   -8.98870000E-04  +7.51500000E-04  -4.06000000E-06  -4.79200000E-05  -1.20000000E-07
   -1.34681220E-01  -3.49036800E-02  -7.37531000E-03  +5.28873100E-02  +1.08762400E-02
   +1.74565500E-02  -3.59601200E-02  -3.19909800E-02  +6.43652000E-03  -4.10893000E-02
   +4.01232700E-02  -5.56426900E-02  -3.02634780E-01  -1.23359420E-01  -4.14245100E-02
   +6.29625750E-01  -9.52690000E-04  -3.43050000E-04  +3.60120000E-04  +1.35502000E-03
   +3.20667000E-03  -9.02411000E-03  -8.98600000E-05  -7.99400000E-05  -2.11340000E-04
   +5.28020000E-04  -6.53000000E-06  +2.03990000E-04  -4.13200000E-04  +5.39580000E-04
   -9.66800000E-05  +5.17660000E-04  -3.61360000E-04  +2.82120000E-04  -2.16482500E-02
   -1.12326200E-02  +4.03924000E-03  -9.73260000E-04  -1.13939000E-03  +7.07910000E-04
   +3.63388000E-03  -2.35938000E-03  +2.31245000E-03  +4.39360000E-04  -4.80290000E-04
   +2.05560000E-04  -7.87670000E-02  -2.35411090E-01  +8.61004300E-02  +4.63377900E-02
   -2.09046200E-02  +4.96145000E-02  -3.58426600E-02  -3.72145700E-02  +5.86502000E-03
   -3.78620000E-03  +5.52358600E-02  -4.37296700E-02  -7.00070100E-02  -1.46985670E-01
   +2.66335700E-02  +1.03447830E-01  +5.21071800E-01  +9.75200000E-05  -6.45900000E-05
   +2.05230000E-04  -4.66550000E-04  -4.23210000E-04  +6.54030000E-04  +9.98650000E-04
   -3.13610000E-04  -6.29440000E-04  -1.71510000E-04  +2.69060000E-04  -3.42970000E-04
   +2.38000000E-06  -2.32810000E-04  +5.53700000E-05  -8.11200000E-05  +1.86640000E-04
   +2.06100000E-05  +1.57161000E-03  -7.09246000E-03  +5.97652000E-03  -2.03990000E-04
   -1.46742000E-03  -6.69400000E-04  -2.88940000E-04  +2.28010000E-04  -4.14030000E-04
   -8.72000000E-05  +1.79130000E-04  -8.16300000E-05  +2.60659100E-02  +1.10638280E-01
   -1.35315660E-01  -1.07302200E-02  +2.85600100E-02  -1.97779000E-02  +8.63623000E-03
   +7.72416000E-03  -4.64817000E-03  -2.25910900E-02  -1.73981700E-02  +2.73662000E-03
   -8.02480700E-02  -4.25832000E-03  -1.03772090E-01  +1.90860820E-01  -2.28189520E-01
   +4.28953260E-01  +7.13250000E-04  +3.60270000E-04  +3.27080000E-04  -1.18120000E-04
   -2.14898000E-03  +3.84718000E-03  -9.13800000E-05  -6.55760000E-04  -2.83720000E-04
   -5.88230000E-04  +7.49500000E-05  -1.09210000E-04  +1.13410000E-03  -1.08720000E-03
   +3.44840000E-04  -3.68260000E-04  +5.50930000E-04  -9.52300000E-05  +7.04677000E-03
   +2.01652000E-03  -1.12198000E-03  -2.84880000E-04  -3.02650000E-04  -3.14320000E-04
   -1.86153000E-03  +1.19562000E-03  -7.71680000E-04  -1.04026000E-03  +1.00427000E-03
   -3.34730000E-04  -7.77473000E-03  -4.84827000E-03  -1.60745000E-03  +4.90939000E-03
   -1.58933000E-03  -1.74740000E-04  -2.75037300E-02  -2.05621200E-02  -6.04854000E-03
   -2.64332270E-01  -1.14753670E-01  -3.62232100E-02  -4.55544300E-02  -1.25010900E-02
   -2.04116000E-02  +6.49131000E-03  +4.75579000E-03  -1.93139000E-03  +4.77080940E-01
   +2.80620000E-04  +1.27640000E-04  +1.50800000E-04  +8.34700000E-05  -7.53720000E-04
   +1.23160000E-03  -9.33600000E-05  -3.04660000E-04  -6.44700000E-05  -2.08360000E-04
   +4.61200000E-05  -4.22400000E-05  +4.21590000E-04  -4.83710000E-04  +1.28810000E-04
   -1.43110000E-04  +2.38770000E-04  -2.83700000E-05  +2.86745000E-03  +7.80530000E-04
   -9.31790000E-04  -1.12740000E-04  -1.27750000E-04  -9.97000000E-05  -7.97240000E-04
   +4.86440000E-04  -1.72770000E-04  -4.03750000E-04  +4.31590000E-04  -1.30080000E-04
   -3.82588000E-03  +1.84389000E-03  -5.09830000E-03  +5.70082000E-03  -8.58200000E-04
   +9.93978000E-03  -4.87019100E-02  -1.71763500E-02  -6.34580000E-03  -7.69001400E-02
   -1.30996450E-01  +2.24048400E-02  +1.53274300E-02  +1.71314200E-02  +1.48582000E-03
   -1.88692000E-03  -3.87310000E-03  +6.01410000E-03  +9.51753000E-03  +3.12900400E-01
   +2.03050000E-04  +1.36270000E-04  +1.17210000E-04  -2.91330000E-04  -6.30210000E-04
   +1.15793000E-03  +4.97500000E-05  -1.75140000E-04  -1.15120000E-04  -1.34250000E-04
   -1.10800000E-05  -3.89000000E-06  +2.30580000E-04  -2.89940000E-04  +4.72000000E-05
   -9.58600000E-05  +1.43110000E-04  -2.15100000E-05  +2.27808000E-03  -1.04200000E-05
   -5.73070000E-04  -1.56910000E-04  -3.05900000E-05  +1.75800000E-05  -5.45390000E-04
   +3.93430000E-04  -3.46820000E-04  -2.29350000E-04  +2.48410000E-04  -5.61400000E-05
   -6.93460000E-04  -4.94419000E-03  +1.73585000E-03  -5.78324000E-03  +5.35000000E-03
   -2.25860000E-04  +1.57573500E-02  +9.93805000E-03  +1.20243800E-02  -6.55614200E-02
   +8.03570000E-04  -8.32603300E-02  -4.20013400E-02  -1.44145000E-02  -5.09985000E-03
   +2.24042000E-03  +9.54248000E-03  -6.13920000E-04  +2.48438420E-01  -2.14542690E-01
   +3.35985210E-01  +9.10970000E-04  +1.71811000E-03  -1.92570000E-04  -2.78338000E-03
   +9.53278000E-03  +1.28013400E-02  -9.83480000E-04  -1.63963000E-03  +7.56560000E-04
   -9.43510000E-04  +5.61280000E-04  -6.00670000E-04  +1.32234000E-03  +3.07510000E-04
   +6.58840000E-04  -3.19980000E-04  -1.64400000E-04  -6.54700000E-05  -7.26629300E-02
   -1.12364000E-03  -1.18124800E-02  -2.01440000E-04  +1.66803400E-02  -1.32639000E-03
   -2.29508000E-03  +5.35280000E-03  -1.37699000E-03  -7.66340000E-04  +2.58720000E-04
   -3.17900000E-04  -1.89052000E-03  -3.27318500E-02  -2.18245000E-03  -6.31520000E-04
   -1.45556000E-03  -3.56020000E-04  +2.53040000E-04  -3.66400000E-04  +4.91370000E-04
   +1.13529000E-03  -1.93300000E-04  +7.07710000E-04  -1.90253000E-03  -1.09850000E-04
   +7.42930000E-04  -2.79900000E-03  -1.97210000E-04  -3.22700000E-03  -1.38109000E-03
   -4.61100000E-04  -3.96560000E-04  +5.86869320E-01  +1.03794000E-03  +1.07146000E-03
   -3.46200000E-05  +3.58736000E-03  -6.15111000E-03  -8.34537000E-03  +3.26310000E-04
   -3.30420000E-04  +2.45590000E-04  -8.02500000E-05  -1.35000000E-05  -3.15960000E-04
   -5.87800000E-05  -1.72960000E-04  +7.54500000E-05  -5.47770000E-04  -2.38100000E-04
   -3.36770000E-04  -4.56460000E-04  -1.90444170E-01  -5.02330000E-04  +4.13825000E-03
   -2.22852400E-02  +4.10593000E-03  +2.02584000E-03  -2.70990000E-03  +5.71340000E-04
   -4.85700000E-05  +6.75500000E-05  +2.66000000E-06  -8.12368000E-03  -1.64897000E-02
   -3.58762000E-03  +9.22920000E-04  -1.87200000E-04  +1.58760000E-04  +1.89540000E-04
   -3.46580000E-04  +5.58920000E-04  -1.84000000E-06  -5.07300000E-05  +2.29170000E-04
   -4.48940000E-04  +6.89900000E-05  +1.06670000E-04  +6.54290000E-04  +6.26170000E-04
   -1.28409000E-03  -6.61000000E-06  -2.27600000E-05  -1.84900000E-05  +6.46346000E-03
   +4.81145100E-01  -9.86620000E-04  +2.45340000E-04  +5.80240000E-04  +5.70709000E-03
   -1.43037000E-02  -1.91430200E-02  +1.25287000E-03  +1.96309000E-03  -1.30274000E-03
   +1.03606000E-03  -1.01151000E-03  +9.04380000E-04  -1.24638000E-03  +2.79560000E-04
   -7.80980000E-04  -2.47500000E-05  -9.54480000E-04  +7.47000000E-06  -1.30986900E-02
   -7.29341000E-03  -6.77621700E-02  -4.79605000E-03  +3.10943500E-02  +2.66921000E-03
   +3.49853000E-03  -7.36304000E-03  +2.52353000E-03  +9.81460000E-04  -7.42890000E-04
   +5.07830000E-04  +1.76315000E-03  -7.03470000E-03  +1.45699000E-03  -6.93180000E-04
   -1.27110000E-04  -1.62080000E-04  +5.50090000E-04  +4.72370000E-04  -4.03600000E-05
   -2.42730000E-04  -3.67930000E-04  -6.23200000E-05  +3.04870000E-04  -1.72790000E-04
   +4.66700000E-04  -1.05189000E-03  +4.46500000E-05  -2.86670000E-04  +3.64550000E-04
   +2.14370000E-04  +1.01770000E-04  +1.80521600E-02  -3.49668100E-02  +5.84338680E-01
   -7.74500000E-05  -1.61300000E-05  -2.93400000E-05  -1.04820000E-04  +1.41850000E-04
   -2.29580000E-04  -2.29600000E-05  +6.42200000E-05  -1.87500000E-05  +1.26410000E-04
   +8.85000000E-06  +3.60400000E-05  -2.26910000E-04  +1.06480000E-04  -7.68400000E-05
   +3.95600000E-05  -5.27500000E-05  +8.38000000E-06  -5.81730000E-04  -2.66090000E-04
   +2.02170000E-04  +4.61100000E-05  +4.49500000E-05  +3.71000000E-05  +2.39180000E-04
   -5.61100000E-05  +2.05000000E-06  +1.80750000E-04  -1.31100000E-04  +6.05000000E-05
   +8.38530000E-04  -2.56370000E-04  +6.90970000E-04  -1.02212000E-03  +3.17620000E-04
   -4.66780000E-04  +3.54017000E-03  +2.38416000E-03  +8.45340000E-04  -2.82048100E-02
   +2.33603700E-02  -3.25830300E-02  -4.38120000E-03  -5.08894000E-03  -4.81500000E-05
   +3.09710000E-04  +1.08440000E-03  -1.67325000E-03  -1.47211610E-01  +9.83143400E-02
   -1.57424870E-01  +1.24930000E-04  +1.68300000E-05  -5.10600000E-05  +1.76627960E-01
   -2.99000000E-06  +1.37600000E-05  -7.46000000E-06  -7.10700000E-05  -7.42000000E-05
   +2.03570000E-04  +2.06800000E-05  +3.23000000E-06  -3.24500000E-05  +6.55000000E-06
   +6.14000000E-06  -3.86000000E-06  -1.04100000E-05  +2.20700000E-05  +1.23000000E-06
   -9.55000000E-06  -1.63400000E-05  -8.75000000E-06  +3.54410000E-04  +1.00000000E-07
   +5.20500000E-05  +4.55200000E-05  +1.28100000E-05  -9.21000000E-06  +1.08500000E-05
   +3.08900000E-05  -7.99500000E-05  +1.21700000E-05  -2.19800000E-05  -1.31000000E-06
   -3.26970000E-04  -3.37030000E-04  +1.63100000E-05  +2.67250000E-04  -6.58380000E-04
   +1.48800000E-04  -2.84252000E-03  +9.71390000E-04  -3.30692000E-03  -1.22581500E-02
   +8.59200000E-03  -1.57262200E-02  -4.06332000E-03  -2.37140000E-04  -1.49780000E-04
   +2.68800000E-05  +1.31023000E-03  +3.98480000E-04  +1.36894850E-01  -1.79592630E-01
   +2.13468020E-01  -6.36100000E-05  +3.13000000E-06  -1.68300000E-05  -1.18325080E-01
   +1.71030420E-01  -6.63900000E-05  -3.01300000E-05  -2.85300000E-05  +2.88300000E-05
   +2.06280000E-04  -3.92560000E-04  +3.31100000E-05  +6.42700000E-05  +3.11900000E-05
   +2.58500000E-05  -1.50400000E-05  -6.56000000E-06  -5.34400000E-05  +1.01600000E-04
   -6.04000000E-06  +2.90300000E-05  -5.62800000E-05  +3.26000000E-06  -6.38110000E-04
   -1.70780000E-04  +1.22780000E-04  +2.34900000E-05  +2.38400000E-05  +4.40300000E-05
   +1.80630000E-04  -1.41650000E-04  +6.61200000E-05  +6.28000000E-05  -7.93600000E-05
   +1.18600000E-05  +6.15290000E-04  +1.45500000E-04  +4.54780000E-04  -4.22670000E-04
   +2.24770000E-04  -1.07386000E-03  +4.90889000E-03  -3.30500000E-04  +1.95727000E-03
   -5.02290000E-03  +4.61733000E-03  -9.13427000E-03  -8.51910000E-04  -7.59220000E-04
   +2.57900000E-03  -7.31420000E-04  +9.92290000E-04  +4.71810000E-04  -1.87292650E-01
   +1.91447240E-01  -2.59461740E-01  +7.82000000E-05  -5.48000000E-06  -3.40300000E-05
   +1.89367080E-01  -1.95894380E-01  +2.64583630E-01  +7.02200000E-05  +1.22000000E-05
   +2.40900000E-05  +5.38400000E-05  -9.19000000E-05  +2.15500000E-04  -5.09100000E-05
   -6.65100000E-05  +2.65000000E-06  -2.02500000E-05  +1.52500000E-05  +6.92000000E-06
   +5.98300000E-05  -7.62600000E-05  -3.72000000E-06  -1.06400000E-05  +4.07200000E-05
   +5.63000000E-06  +1.71370000E-04  +8.75980000E-04  -1.29443000E-03  -4.81490000E-04
   -2.24970000E-04  +4.97000000E-05  -8.61000000E-05  +8.20100000E-05  +3.25700000E-05
   -5.68700000E-05  +6.23900000E-05  -7.74000000E-06  -2.68664000E-03  -4.67224000E-03
   -2.14363000E-03  -1.20210800E-02  +1.45131400E-02  -2.00509600E-02  -1.46541370E-01
   +6.41210800E-02  -1.16379320E-01  +6.02174000E-03  -6.21487000E-03  +6.06639000E-03
   +1.34648000E-03  -3.07184000E-03  -2.33100000E-05  -7.50530000E-04  -6.92690000E-04
   +6.37830000E-04  +2.40362000E-03  +1.36239000E-03  +2.53104000E-03  -2.25800000E-05
   +1.11240000E-04  +4.48500000E-05  -1.71260000E-04  +5.27250000E-04  -8.13980000E-04
   +1.52627570E-01  -1.01600000E-05  +1.91000000E-06  +4.85000000E-06  -1.59800000E-05
   +5.31900000E-05  +1.27600000E-05  +4.68700000E-05  +7.18000000E-06  -3.44000000E-06
   -1.49700000E-05  -1.56700000E-05  -1.79900000E-05  +1.61000000E-05  +2.25200000E-05
   +1.39200000E-05  -2.25000000E-06  -1.67300000E-05  -4.52000000E-06  -4.30560000E-04
   +5.25800000E-04  -3.52580000E-04  -8.01500000E-05  -1.55630000E-04  -4.64000000E-06
   +6.73600000E-05  -6.59100000E-05  -6.00700000E-05  -4.23000000E-06  -1.02200000E-05
   -6.23000000E-06  -4.04089000E-03  +2.11296000E-03  +2.02527000E-03  -8.15650000E-03
   +9.12224000E-03  -9.71752000E-03  +6.47322700E-02  -1.06730200E-01  +9.52868400E-02
   +1.75011500E-02  -5.97714000E-03  +1.81325200E-02  -3.54152000E-03  -2.45064000E-03
   +4.06944000E-03  -9.57330000E-04  -9.31930000E-04  -5.52130000E-04  +1.97022000E-03
   +6.78830000E-04  -2.40411000E-03  +1.47000000E-05  -1.75600000E-05  +3.57200000E-05
   -1.65721000E-03  -8.10860000E-04  +1.43600000E-04  -6.79651600E-02  +1.06285520E-01
   +2.16400000E-05  +1.89000000E-05  +2.64000000E-05  -1.43800000E-05  -2.66300000E-05
   +8.61000000E-05  +4.44600000E-05  -2.59900000E-05  -1.49500000E-05  -4.58000000E-05
   -1.24500000E-05  -1.69300000E-05  +7.07100000E-05  -3.04300000E-05  +2.81800000E-05
   -1.72100000E-05  +1.20800000E-05  -7.55000000E-06  -8.35900000E-05  +4.48450000E-04
   -1.00590000E-04  -1.13100000E-05  -1.44990000E-04  +2.57400000E-05  -3.26200000E-05
   -1.59300000E-05  -6.99100000E-05  -5.57300000E-05  +3.76900000E-05  -1.96500000E-05
   -2.30571000E-03  +1.47040000E-03  +4.99875000E-03  -2.72129000E-03  +3.42112000E-03
   -1.52545000E-03  -1.16583240E-01  +9.56752600E-02  -1.77231640E-01  -1.26971500E-02
   +3.76694000E-03  -6.31044000E-03  +2.79730000E-04  +4.33780000E-03  +2.14646000E-03
   +9.25120000E-04  -1.73130000E-04  -1.99440000E-04  +2.16928000E-03  -2.66004000E-03
   -4.25230000E-04  -7.76000000E-05  -6.80300000E-05  +6.81000000E-05  +8.99150000E-04
   +1.41215000E-03  -5.24000000E-05  +1.29060390E-01  -1.04969210E-01  +1.81439170E-01
   +1.45000000E-06  -3.19380000E-04  -2.11400000E-04  -3.11670000E-04  +3.67110000E-04
   +1.19490000E-03  -1.79410000E-04  +9.81800000E-05  -5.49500000E-05  +1.00420000E-04
   +1.80500000E-05  +3.92400000E-05  -5.57100000E-05  +1.87600000E-04  -3.50100000E-05
   +1.13950000E-04  -1.37700000E-05  +1.89000000E-05  +7.45900000E-04  +5.51330000E-04
   +3.30600000E-05  -3.00300000E-05  +9.43000000E-05  +9.50700000E-05  -1.15530000E-03
   +8.68800000E-05  -1.23100000E-05  +9.37500000E-05  -1.44660000E-04  +3.63300000E-05
   +1.01905400E-02  +1.47892000E-02  -8.66197000E-03  -8.03448400E-02  -7.38802000E-02
   +3.67547500E-02  -4.34855000E-03  -2.40977100E-02  +1.42427800E-02  -2.79914000E-03
   -2.91572000E-03  -3.91498000E-03  -1.14089000E-03  +3.26030000E-04  -2.29100000E-04
   -1.27801000E-03  +1.11650000E-03  -4.52958000E-03  -8.88290000E-04  -1.33414000E-03
   +6.96220000E-04  -9.01770000E-04  -1.05000000E-04  -8.20410000E-04  +2.13240000E-04
   -5.34600000E-05  +1.53410000E-04  -9.57000000E-06  +1.41840000E-03  +1.47582000E-03
   +8.25603900E-02  +1.17630000E-04  -1.66680000E-04  -1.07250000E-04  +8.78980000E-04
   +3.32610000E-04  -1.41557000E-03  -1.53320000E-04  -4.80700000E-05  +2.80700000E-04
   -3.49900000E-05  +4.79700000E-05  -2.96600000E-05  +7.49400000E-05  -2.65000000E-05
   +6.73800000E-05  +1.31700000E-05  +7.24700000E-05  +3.10700000E-05  -8.88350000E-04
   -1.69113000E-03  -6.80120000E-04  +1.27240000E-04  -1.32090000E-04  -9.05900000E-05
   -9.36730000E-04  -8.00400000E-05  +8.39520000E-04  -7.37300000E-05  +4.77000000E-05
   -4.12800000E-05  -4.47058000E-03  -6.30238000E-03  +6.04608000E-03  -7.27997500E-02
   -2.41313430E-01  +1.25391350E-01  -2.44510000E-03  -5.55112000E-03  +7.30381000E-03
   -3.55340000E-03  +3.72935000E-03  +1.83053000E-03  +7.04260000E-04  +1.61110000E-04
   -7.02470000E-04  +6.57360000E-04  +1.73212000E-03  +4.11304000E-03  -2.16420000E-04
   -6.90600000E-04  +1.55900000E-04  -8.31990000E-04  -1.47970000E-04  -6.72140000E-04
   +1.07680000E-04  -1.66800000E-05  +7.39000000E-05  +1.25591000E-03  -9.61270000E-04
   -2.40957000E-03  +8.44018600E-02  +2.52113370E-01  -6.17200000E-05  +3.18750000E-04
   +4.19300000E-05  -8.77300000E-04  -2.08010000E-04  +1.85470000E-04  +4.98200000E-04
   +1.81230000E-04  -4.31000000E-05  -1.12130000E-04  -1.85140000E-04  -3.88800000E-05
   +4.82000000E-06  +1.02910000E-04  +2.01000000E-06  -9.32800000E-05  -1.55490000E-04
   -3.39000000E-05  +2.00120000E-03  -6.53130000E-04  -7.35440000E-04  -1.15810000E-04
   -2.41760000E-04  -1.74000000E-05  +9.87110000E-04  +3.10200000E-05  -9.60990000E-04
   +2.23200000E-05  -6.08300000E-05  +4.22000000E-06  +8.37860000E-03  +1.72425900E-02
   -5.18480000E-03  +3.63249400E-02  +1.27242760E-01  -1.24411250E-01  -4.06462000E-03
   -6.30348000E-03  +7.88121000E-03  -4.09875000E-03  +2.06340000E-03  +3.99255000E-03
   -4.97700000E-05  -7.80110000E-04  -6.47570000E-04  -4.91976000E-03  +3.37318000E-03
   +5.42030000E-04  -4.95000000E-06  -5.98350000E-04  +2.42800000E-05  -1.69940000E-04
   +1.26970000E-04  -5.46210000E-04  +2.84000000E-05  +1.49600000E-05  +4.18300000E-05
   +1.67498000E-03  -2.07354000E-03  -1.83809000E-03  -3.47602200E-02  -1.38361380E-01
   +1.21858660E-01  +6.00000000E-06  -1.49000000E-05  +1.19000000E-06  -1.01530000E-04
   -8.82100000E-05  -5.60300000E-05  +8.45700000E-05  -5.87500000E-05  -1.98900000E-05
   +2.68100000E-05  +7.05100000E-05  -1.12230000E-04  -1.52550000E-04  -2.04000000E-05
   -4.16000000E-06  -1.55500000E-05  +4.96000000E-05  -1.02700000E-05  -8.94340000E-04
   +1.20013000E-03  +8.45340000E-04  -2.22223000E-03  -2.45695000E-03  -5.08640000E-04
   -1.35400000E-05  +1.36700000E-05  -1.59700000E-05  +7.19900000E-05  -2.75700000E-05
   +2.77000000E-06  +1.01308600E-02  -3.84989000E-03  +6.29763000E-03  +1.11350000E-03
   -3.51377000E-03  -1.35870000E-04  -6.44240000E-04  -5.69590000E-04  +6.98920000E-04
   -2.14841000E-03  -4.54718000E-03  -2.41821000E-03  -1.22568200E-02  +1.40263400E-02
   -2.02377500E-02  -1.49154140E-01  +7.16227300E-02  -1.15887080E-01  -9.09490000E-04
   +7.72250000E-04  -1.10997000E-03  +2.87860000E-04  +1.03670000E-04  -1.99610000E-04
   -3.85420000E-04  -8.26700000E-05  -2.10900000E-05  -1.28650000E-04  +2.03120000E-04
   +1.66120000E-04  +4.40500000E-04  -3.04500000E-04  +4.08170000E-04  +1.60415170E-01
   -5.58800000E-05  -6.19100000E-05  -2.54700000E-05  +3.01690000E-04  +2.11050000E-04
   -3.81570000E-04  +5.80400000E-05  +2.81600000E-05  +1.59650000E-04  -2.92400000E-05
   +4.45200000E-05  -3.64600000E-05  -1.30600000E-05  +1.81580000E-04  +3.48800000E-05
   -4.17200000E-05  -8.54600000E-05  -7.38100000E-05  +2.39275000E-03  -5.15920000E-04
   -3.83960000E-04  -4.83860000E-04  -3.01890000E-04  +2.58000000E-04  -6.73900000E-05
   -1.03210000E-04  +1.37850000E-04  +2.78400000E-05  -1.15030000E-04  +7.88000000E-06
   +1.57586300E-02  -6.38118000E-03  +1.65469000E-02  -3.72411000E-03  -2.35985000E-03
   +4.46802000E-03  -6.46090000E-04  -7.35100000E-04  -7.05630000E-04  -4.50323000E-03
   +2.13814000E-03  +2.21753000E-03  -8.91036000E-03  +9.45377000E-03  -8.46324000E-03
   +7.16092300E-02  -1.16167980E-01  +9.76226600E-02  -1.78550000E-04  +3.91130000E-04
   -4.55210000E-04  -3.08520000E-04  +5.90000000E-06  -2.13710000E-04  -1.49350000E-04
   -1.39590000E-04  -1.94660000E-04  +2.36570000E-04  -1.73970000E-04  -2.44380000E-04
   +8.64680000E-04  -3.87440000E-04  +1.00962000E-03  -7.20749200E-02  +1.16267980E-01
   -1.14660000E-04  -5.06500000E-05  -1.10880000E-04  +1.59100000E-04  +5.15140000E-04
   -3.74510000E-04  -2.76700000E-05  +1.79280000E-04  +1.19680000E-04  -1.20220000E-04
   -2.06450000E-04  +1.04280000E-04  +3.54230000E-04  +2.04310000E-04  +9.20300000E-05
   +4.07300000E-05  -1.43390000E-04  +5.75000000E-06  +2.48910000E-04  -1.47239000E-03
   -2.00562000E-03  -1.68146000E-03  -5.09660000E-04  +5.07690000E-04  +2.35340000E-04
   -1.99100000E-04  +1.29470000E-04  -1.36990000E-04  -4.76700000E-05  -3.39900000E-05
   -9.45110000E-03  +5.18416000E-03  -5.47279000E-03  -6.05000000E-05  +4.74085000E-03
   +2.50847000E-03  +7.06100000E-04  -6.19870000E-04  -2.59730000E-04  -2.53226000E-03
   +2.28384000E-03  +5.26386000E-03  -2.88604000E-03  +4.22736000E-03  -9.97000000E-06
   -1.15429860E-01  +9.84537100E-02  -1.79255000E-01  -2.65930000E-04  +1.16760000E-04
   -2.97580000E-04  -2.72300000E-04  -1.75150000E-04  -2.21000000E-05  +5.39100000E-05
   -1.37270000E-04  -1.32510000E-04  +1.47010000E-04  -2.76320000E-04  -3.87910000E-04
   -5.80650000E-04  +2.54630000E-04  -2.47260000E-04  +1.30539840E-01  -1.07995200E-01
   +1.81861500E-01  +4.52100000E-05  +1.96700000E-05  +3.78200000E-05  +2.01400000E-05
   -7.38900000E-05  +1.94600000E-05  +1.14800000E-05  -4.75300000E-05  -1.21400000E-05
   -1.14200000E-05  +1.15500000E-05  -2.81800000E-05  +1.83000000E-06  -9.32700000E-05
   +5.53000000E-06  -1.00100000E-05  +5.23000000E-05  -1.15000000E-06  +2.48900000E-04
   -1.15794000E-03  +4.32210000E-04  +3.10600000E-05  +1.23800000E-05  +8.03600000E-05
   -1.50200000E-05  +4.26700000E-05  -1.17000000E-05  -2.17500000E-05  +7.21600000E-05
   -1.90500000E-05  -3.00945000E-03  -2.71549000E-03  -3.48705000E-03  -1.28422000E-03
   +3.72280000E-04  -4.14960000E-04  -1.25241000E-03  +5.37810000E-04  -4.29444000E-03
   +1.00138100E-02  +1.57924900E-02  -9.35172000E-03  -8.15920600E-02  -7.74563800E-02
   +3.31902400E-02  -3.80398000E-03  -2.35324800E-02  +1.45011700E-02  +7.36680000E-04
   +4.94250000E-04  +2.02731000E-03  -4.22350000E-04  -2.60200000E-05  -4.50400000E-05
   +6.03600000E-05  -2.01600000E-05  +3.54280000E-04  +3.67630000E-04  +9.25110000E-04
   -4.78000000E-04  -6.57400000E-05  +1.23240000E-04  +2.58230000E-04  +3.21000000E-06
   +1.42288000E-03  +1.56083000E-03  +7.99976600E-02  +4.39700000E-05  +2.02400000E-05
   +1.95500000E-05  -5.37300000E-05  -1.32280000E-04  +2.50760000E-04  +1.50200000E-05
   -4.59500000E-05  -2.34200000E-05  -3.65500000E-05  +1.25000000E-05  -1.41200000E-05
   +6.32400000E-05  -4.58500000E-05  +2.04500000E-05  -2.09200000E-05  +2.39600000E-05
   -9.12000000E-06  +3.46910000E-04  -1.35410000E-04  +2.88440000E-04  -1.41600000E-05
   -2.71400000E-05  +4.16000000E-06  -1.03990000E-04  +6.92100000E-05  -6.95700000E-05
   -5.28500000E-05  +4.41600000E-05  -2.05800000E-05  -3.36234000E-03  +3.32627000E-03
   +1.26934000E-03  +8.49020000E-04  +2.10480000E-04  -4.41870000E-04  +9.41780000E-04
   +1.51304000E-03  +3.58953000E-03  -7.86648000E-03  -7.88517000E-03  +5.55219000E-03
   -7.62957100E-02  -2.49929680E-01  +1.21308170E-01  -1.43626000E-03  -5.53667000E-03
   +5.40207000E-03  +6.50350000E-04  -2.18480000E-04  -2.11055000E-03  -5.89700000E-05
   +5.35800000E-05  +6.47000000E-06  +6.24100000E-05  -5.46700000E-05  -3.41800000E-04
   -1.85110000E-04  -4.51560000E-04  +1.94550000E-04  +1.08940000E-04  -2.67120000E-04
   -2.31740000E-04  +1.06391000E-03  -8.67190000E-04  -2.34043000E-03  +8.53579600E-02
   +2.60356750E-01  +2.57800000E-05  +9.90000000E-07  +4.60000000E-07  -1.14910000E-04
   -8.45600000E-05  +2.52030000E-04  +5.42900000E-05  -2.28900000E-05  -1.84600000E-05
   -3.69100000E-05  +9.03000000E-06  -1.56700000E-05  +5.27400000E-05  +1.24900000E-05
   +2.34000000E-05  -1.52100000E-05  -4.93000000E-06  -1.47900000E-05  +9.85000000E-06
   -1.28250000E-04  +3.54680000E-04  +3.30700000E-05  -5.50000000E-06  -6.09000000E-06
   -8.27200000E-05  +3.84900000E-05  -8.92000000E-05  -2.86000000E-05  -1.53000000E-06
   -1.75500000E-05  -3.74024000E-03  +1.71948000E-03  +4.05901000E-03  -4.81180000E-04
   -7.60150000E-04  -7.40930000E-04  -4.55727000E-03  +3.25304000E-03  +4.18960000E-04
   +8.89879000E-03  +1.90329900E-02  -4.45812000E-03  +3.24295700E-02  +1.20651910E-01
   -1.09690930E-01  -2.75776000E-03  -7.20178000E-03  +6.50311000E-03  +1.75425000E-03
   -2.26701000E-03  -6.94740000E-04  +6.96600000E-05  +4.05300000E-05  -4.25600000E-05
   +3.01610000E-04  -3.91810000E-04  -6.64100000E-05  +3.76440000E-04  +7.82900000E-04
   -4.82840000E-04  +2.11630000E-04  -2.73320000E-04  -3.11830000E-04  +1.85800000E-03
   -2.11730000E-03  -2.06040000E-03  -3.42521300E-02  -1.32304560E-01  +1.07075950E-01
   -1.18457000E-03  +2.98840000E-04  +8.08970000E-04  -2.00000000E-08  -3.71200000E-04
   -1.94860000E-04  -3.55100000E-05  +1.30710000E-04  -1.26050000E-04  +1.70760000E-04
   +2.28000000E-05  +6.28700000E-05  -1.83010000E-04  -5.68100000E-05  -1.72230000E-04
   +1.91370000E-04  +1.50520000E-04  +5.58300000E-05  +1.07242000E-03  +1.83037000E-03
   +5.92600000E-04  +3.54840000E-04  +8.06760000E-04  +6.75700000E-05  +1.68510000E-04
   +1.12470000E-04  -7.48200000E-05  +1.00720000E-04  +9.67000000E-06  +5.48200000E-05
   +2.17730000E-04  -2.26250000E-04  -2.84270000E-04  +1.58780000E-04  -1.63670000E-04
   +3.44500000E-05  +1.77080000E-04  -6.45400000E-05  +3.88200000E-05  +3.09370000E-04
   -6.62100000E-05  +2.14430000E-04  -3.19370000E-04  -3.56100000E-05  -1.42650000E-04
   +5.71490000E-04  +4.65090000E-04  -3.88840000E-04  -3.07820000E-04  -1.11670000E-04
   -6.40300000E-05  -2.78553060E-01  -8.85543400E-02  -4.25603800E-02  +4.65300000E-05
   +4.50000000E-06  +2.35200000E-05  -2.28000000E-05  +6.17000000E-06  -1.18500000E-05
   -2.42600000E-05  +1.70200000E-05  +2.85130000E-04  +1.95600000E-05  -5.37200000E-05
   +7.85100000E-05  -2.44600000E-05  +1.56900000E-05  +2.28800000E-05  +3.02758540E-01
   +3.06000000E-05  -5.02710000E-04  -3.58520000E-04  -7.58670000E-04  +8.92000000E-06
   +2.66860000E-04  +6.61000000E-05  +1.80770000E-04  +1.45100000E-04  +1.78920000E-04
   +3.01900000E-05  +3.54000000E-05  -2.83250000E-04  -5.15450000E-04  -1.84580000E-04
   +2.55070000E-04  +3.33470000E-04  +2.04990000E-04  -3.11088900E-02  -1.21281200E-02
   -5.32148000E-03  -1.34201000E-03  +9.77080000E-04  -1.03753000E-03  +2.68170000E-04
   +2.52030000E-04  -1.61030000E-04  +3.00100000E-05  +2.53020000E-04  +3.34700000E-05
   +1.51783000E-03  -6.03024000E-03  +3.68100000E-04  +2.92450000E-04  -1.47300000E-04
   +7.90560000E-04  -1.98640000E-04  +5.85400000E-05  +3.45600000E-05  +4.23400000E-04
   +2.60500000E-05  +1.31480000E-04  -4.52640000E-04  -6.16700000E-05  +3.00990000E-04
   -1.09278000E-03  -1.82120000E-04  -1.01449000E-03  -4.44180000E-04  -1.58930000E-04
   -1.55840000E-04  -8.46084000E-02  -8.00146700E-02  -1.45355600E-02  +3.52000000E-05
   -2.39800000E-05  +2.44000000E-05  -5.50000000E-05  -2.53000000E-06  -1.35800000E-05
   +8.61200000E-05  +1.34660000E-04  -3.01900000E-04  +7.09300000E-05  -1.14080000E-04
   -7.94500000E-05  -1.51160000E-04  -2.36000000E-05  +1.50200000E-05  +9.39691900E-02
   +8.97720100E-02  +1.37870000E-04  -1.02373000E-03  -2.42040000E-04  -6.36060000E-04
   -3.95370000E-04  +2.62680000E-04  +1.64300000E-04  +4.25000000E-06  -2.88000000E-06
   +3.67600000E-05  +6.84900000E-05  -2.16500000E-05  -1.31840000E-04  -3.55420000E-04
   -4.80000000E-05  +1.58160000E-04  +4.61590000E-04  +2.41100000E-05  -3.90097000E-03
   -2.21771000E-03  -2.55346000E-03  +8.99390000E-04  +8.05990000E-04  -2.31420000E-04
   +3.42650000E-04  +6.33680000E-04  -7.41000000E-06  -5.06500000E-05  +2.37700000E-04
   -3.71700000E-05  -6.04900000E-05  -3.41820000E-04  +1.05718000E-03  -2.78860000E-04
   +1.17500000E-05  -2.88410000E-04  +1.48620000E-04  -1.28870000E-04  -3.87000000E-06
   -7.04500000E-05  -5.18400000E-05  -2.16400000E-05  +7.69900000E-05  -1.99190000E-04
   +1.13810000E-04  -3.40060000E-04  -1.93130000E-04  -1.32440000E-04  +1.94600000E-05
   +9.17000000E-06  +5.24000000E-05  -4.19147100E-02  -1.47598000E-02  -5.48388600E-02
   +1.47100000E-05  +1.75700000E-05  -5.74000000E-06  -9.07000000E-06  -4.80000000E-06
   -2.05100000E-05  +1.47540000E-04  +1.64900000E-05  +4.60790000E-04  +1.67900000E-05
   +1.18200000E-05  +6.18500000E-05  -3.81100000E-05  +5.00000000E-06  +1.25200000E-05
   +4.46378200E-02  +1.74378100E-02  +5.48802200E-02  -1.37810000E-04  -1.42830000E-04
   -1.70550000E-04  -5.66500000E-05  +5.03980000E-04  +3.14310000E-04  -6.40800000E-05
   +1.46640000E-04  +6.90300000E-05  +9.02300000E-05  -8.18700000E-05  +3.69800000E-05
   -7.08500000E-05  +3.02000000E-05  -1.44460000E-04  +1.28800000E-04  -1.75800000E-05
   +5.07600000E-05  -1.49889000E-03  +1.42063000E-03  +1.57120000E-04  +1.85780000E-04
   +2.50260000E-04  -1.48200000E-05  +1.00440000E-04  -5.61260000E-04  -3.80290000E-04
   +6.60300000E-05  -7.10200000E-05  +6.59300000E-05  -2.65280000E-04  +3.14870000E-04
   +4.17500000E-04  -8.96550000E-04  -1.38498000E-03  -2.58110000E-04  -1.54670000E-04
   -1.01040000E-04  +3.46700000E-05  -6.02100000E-05  +9.10100000E-05  -4.09200000E-05
   +8.58100000E-05  +4.35300000E-05  -5.84000000E-05  -4.46500000E-05  +1.04230000E-04
   -4.37900000E-05  +1.09300000E-05  +1.56000000E-05  -2.49000000E-06  -8.72026800E-02
   +4.58323500E-02  -8.64937300E-02  -1.59100000E-05  -1.99500000E-05  -2.23000000E-06
   +1.85300000E-05  -2.57800000E-05  -2.58600000E-05  -1.20507000E-03  -1.75367000E-03
   -1.44658000E-03  +1.07000000E-06  +3.61500000E-05  -1.08300000E-05  +5.48000000E-06
   +6.69000000E-06  -2.06000000E-06  -9.81944000E-03  +1.38602200E-02  -2.42045000E-02
   +9.22400000E-02  +1.13160000E-04  +1.00000000E-06  +2.25990000E-04  +2.28710000E-04
   +7.02940000E-04  -9.76830000E-04  -2.78200000E-05  -2.43720000E-04  +2.50780000E-04
   -1.74790000E-04  +9.69800000E-05  -8.94800000E-05  +7.53200000E-05  -8.30000000E-05
   +1.44140000E-04  -8.88600000E-05  +1.17830000E-04  -8.27200000E-05  +1.24383300E-02
   -1.23402100E-02  +2.82577200E-02  -4.47200000E-05  -6.58927000E-03  -2.19919000E-03
   -1.52340000E-04  +2.57000000E-05  +5.99040000E-04  -1.07040000E-04  +1.08440000E-04
   -7.67300000E-05  +8.85640000E-04  +1.22498000E-03  -2.71700000E-04  -3.11890000E-04
   -7.45870000E-04  +3.15750000E-04  -2.88210000E-04  +2.83280000E-04  -2.40610000E-04
   -9.22300000E-05  +1.46050000E-04  -1.30530000E-04  +2.55480000E-04  +1.53870000E-04
   +4.62900000E-05  -1.88330000E-04  -1.75180000E-04  +1.95870000E-04  +1.73590000E-04
   +8.54200000E-05  -1.37300000E-05  +4.51065200E-02  -1.04346850E-01  +1.00360900E-01
   -4.56900000E-05  -1.19000000E-05  -9.76000000E-06  +1.77000000E-06  -1.92000000E-05
   +1.36900000E-05  -1.48797000E-03  -5.66390000E-04  -1.45573000E-03  +1.02200000E-04
   +1.28300000E-04  -6.56700000E-05  +2.07100000E-05  -9.57000000E-06  -1.37300000E-05
   -3.74457000E-03  +5.29460000E-03  -1.02927500E-02  -4.93230600E-02  +1.14083830E-01
   +1.10880000E-04  +1.32600000E-05  -1.80930000E-04  +1.88890000E-04  +5.27560000E-04
   -1.97690000E-04  -3.23120000E-04  +3.62700000E-05  +1.02890000E-04  +4.13600000E-05
   +9.42100000E-05  -1.42600000E-05  +3.79100000E-05  -5.38500000E-05  +1.19900000E-05
   -6.39000000E-06  +3.26100000E-05  +2.46800000E-05  +3.02220000E-03  -3.17204000E-03
   +4.77548000E-03  -4.77410000E-04  -4.02540000E-04  +4.76120000E-04  +1.20585000E-03
   -1.96525000E-03  -1.62310000E-03  -4.43900000E-05  +4.50100000E-05  -1.04600000E-05
   -2.43070000E-04  +5.64950000E-04  -1.34330000E-04  -9.62330000E-04  -9.64330000E-04
   -1.01848000E-03  +2.67310000E-04  -8.65200000E-05  +5.14800000E-05  -1.39240000E-04
   -4.26000000E-05  +1.02400000E-04  -3.11400000E-05  -6.81500000E-05  +2.73000000E-05
   +9.17800000E-05  +3.37500000E-05  +2.73900000E-05  +7.53000000E-05  +5.25000000E-06
   +4.06900000E-05  -8.78004700E-02  +1.05225200E-01  -2.32267940E-01  +3.82000000E-06
   +2.06500000E-05  -3.22000000E-06  +9.36000000E-06  -9.64000000E-06  -1.95200000E-05
   -1.74071000E-03  -1.62298000E-03  -1.02730000E-04  -7.65000000E-06  -3.54400000E-05
   -3.28000000E-06  +1.13700000E-05  +5.04000000E-06  +4.07000000E-06  -3.30010000E-04
   +1.20915000E-03  -3.23178000E-03  +9.70022700E-02  -1.09324010E-01  +2.50833210E-01
   -2.29620000E-04  -3.43860000E-04  +4.85500000E-05  +5.82410000E-04  -2.94450000E-04
   -7.01460000E-04  -6.83500000E-05  +1.79660000E-04  +5.62000000E-05  +2.23800000E-04
   +5.31000000E-05  +2.29500000E-05  -1.60590000E-04  -1.98600000E-04  -9.32000000E-06
   +1.55940000E-04  +1.67860000E-04  +7.48900000E-05  -1.43192000E-03  +5.17090000E-04
   +5.50480000E-04  +2.98940000E-04  -3.00450000E-04  -1.26290000E-04  +3.38470000E-04
   -2.49540000E-04  -2.21840000E-04  +1.84400000E-05  +1.11780000E-04  -2.26400000E-05
   +9.06000000E-06  -7.57060000E-04  -8.10820000E-04  +1.65990000E-04  -5.99200000E-05
   +1.48930000E-04  -1.25920000E-04  +3.80900000E-05  +9.74300000E-05  -6.26000000E-06
   -3.89500000E-05  +3.61600000E-05  -8.79600000E-05  +3.35600000E-05  -6.81800000E-05
   +1.89400000E-04  +2.64240000E-04  +4.22000000E-05  +2.71800000E-05  +7.02000000E-06
   -1.97500000E-05  -1.32387730E-01  +3.42648900E-02  +1.19773960E-01  -1.15200000E-05
   -7.77000000E-06  -5.40000000E-07  +4.45000000E-06  -2.31000000E-06  -5.02000000E-06
   +1.61880000E-04  +6.74000000E-05  -9.23500000E-05  +2.06200000E-05  +2.65700000E-05
   -6.13000000E-06  +9.10000000E-06  +2.18000000E-06  -3.86000000E-06  -1.55962000E-02
   +7.28503000E-03  +2.37462300E-02  +7.46758000E-03  -3.86436000E-03  -1.00963500E-02
   +1.40181740E-01  -1.12652000E-03  -2.63820000E-04  +3.45190000E-04  +2.06200000E-04
   -3.04802000E-03  -3.90803000E-03  +6.60260000E-04  +7.36560000E-04  -4.95650000E-04
   +4.24820000E-04  -3.58750000E-04  +3.10320000E-04  -6.68680000E-04  -2.86600000E-05
   -4.08150000E-04  +2.26770000E-04  -8.17400000E-05  +1.27070000E-04  +1.71116300E-02
   -1.05926700E-02  -2.39215600E-02  -2.50460000E-04  +1.10695000E-03  -2.65430000E-04
   +4.72630000E-04  -6.89590000E-04  +1.88758000E-03  +4.35600000E-04  -2.09210000E-04
   +2.08720000E-04  +7.11480000E-04  +7.86780000E-04  +2.32900000E-05  -5.76700000E-05
   +2.09390000E-04  -1.65390000E-04  +1.34500000E-05  +1.73800000E-05  -7.23400000E-05
   -2.22070000E-04  -4.07800000E-05  -1.42020000E-04  +2.08440000E-04  -1.12350000E-04
   +1.12770000E-04  -3.27690000E-04  +3.73100000E-05  +4.24390000E-04  +2.86860000E-04
   +1.28950000E-04  +1.12870000E-04  +3.49787700E-02  -5.94037000E-02  -4.77047700E-02
   -2.72600000E-05  +7.00000000E-07  -3.12300000E-05  +2.47000000E-05  -6.65000000E-06
   +8.08000000E-06  -1.61700000E-05  -7.73300000E-05  +1.86600000E-05  -6.47000000E-06
   -6.22300000E-05  -1.76500000E-05  +2.91200000E-05  -1.65400000E-05  -3.94600000E-05
   -5.89047000E-03  +2.24950000E-03  +9.82844000E-03  -9.56233000E-03  +3.25639000E-03
   +1.05556200E-02  -3.76561000E-02  +6.67067000E-02  -3.53920000E-04  +7.65800000E-05
   -1.85630000E-04  -7.86140000E-04  -2.17860000E-04  +1.00093000E-03  +1.46450000E-04
   +3.48550000E-04  -5.91800000E-05  +1.47600000E-05  -6.05300000E-05  +9.06100000E-05
   -9.88600000E-05  +1.63140000E-04  -9.21200000E-05  +7.10800000E-05  -1.15160000E-04
   +7.85200000E-05  +2.05240000E-03  -2.10470000E-03  -4.65555000E-03  -1.56510000E-04
   +7.17320000E-04  -3.27000000E-06  +4.86860000E-04  -9.30480000E-04  -5.74710000E-04
   +1.36110000E-04  -1.41500000E-04  +5.25900000E-05  +4.54720000E-04  +4.86530000E-04
   +7.44620000E-04  -2.19120000E-04  +2.92110000E-04  -1.08100000E-04  -2.55600000E-04
   -1.38000000E-04  +9.64800000E-05  -1.18980000E-04  +1.05770000E-04  -2.04780000E-04
   +2.36220000E-04  -2.22400000E-05  +1.07710000E-04  -4.40320000E-04  -3.80550000E-04
   +5.81000000E-05  +5.13300000E-05  +1.15500000E-05  +3.49500000E-05  +1.19215030E-01
   -4.60534600E-02  -2.12196410E-01  -4.50000000E-06  -9.79000000E-06  -1.29000000E-05
   +3.57000000E-06  -1.48100000E-05  -2.01100000E-05  +3.14930000E-04  +1.05100000E-05
   -4.91800000E-05  +6.12000000E-06  +3.11700000E-05  +1.85000000E-06  -5.19000000E-06
   -7.92000000E-06  -5.17000000E-06  -4.09843000E-03  +2.11173000E-03  +5.10752000E-03
   +1.55735400E-02  -6.63753000E-03  -1.82580900E-02  -1.32002710E-01  +5.25954700E-02
   +2.28519480E-01  +3.61930000E-04  -4.94580000E-04  -1.82480000E-04  +6.56200000E-05
   +1.25680000E-04  +3.01440000E-04  +8.63800000E-05  -1.34870000E-04  +4.15400000E-04
   -1.59180000E-04  +1.18550000E-04  +5.27860000E-04  -2.06000000E-05  +5.34000000E-05
   +9.10450000E-04  -1.80350000E-04  +2.27260000E-04  -3.02280000E-04  -2.77933000E-03
   +1.30923200E-02  +5.03820000E-03  -6.04871400E-02  +5.63008400E-02  +5.26301000E-03
   -8.88000000E-05  -1.17430000E-04  +7.51200000E-05  -1.98390000E-04  +1.32470000E-04
   -2.77610000E-04  +9.90000000E-05  -1.11210000E-04  -1.04720000E-04  +2.12700000E-04
   -2.03270000E-04  +1.77600000E-05  +4.51000000E-06  -1.41570000E-04  +1.31250000E-04
   +6.22500000E-05  +9.90800000E-05  -6.70900000E-05  +1.70100000E-05  -2.91310000E-04
   +2.28280000E-04  -8.79540000E-04  +7.48950000E-04  -6.44570000E-04  +1.31200000E-05
   -5.39700000E-05  +4.85200000E-05  -1.20023000E-03  +1.15730000E-04  -2.11036000E-03
   +4.28000000E-06  -6.11000000E-06  +1.83000000E-06  -3.37000000E-06  +7.82000000E-06
   +2.15600000E-05  +6.06500000E-05  -1.17500000E-05  +9.77800000E-05  -2.81735000E-03
   -1.01996000E-03  +1.05760000E-04  -3.34500000E-05  +8.16000000E-06  -1.97000000E-06
   +3.43000000E-04  +2.86880000E-04  -2.92300000E-05  +5.93400000E-04  +7.85790000E-04
   +1.34600000E-05  +1.91100000E-05  -3.56030000E-04  -9.71700000E-05  +6.40196600E-02
   +1.15070000E-04  -3.33820000E-04  -2.64000000E-05  +6.91130000E-04  -1.10219000E-03
   -3.05300000E-05  +2.58800000E-04  +3.39350000E-04  -1.24802000E-03  -7.20900000E-05
   +4.07000000E-05  -8.88770000E-04  +7.20300000E-05  +6.06300000E-05  +1.17840000E-04
   -2.39080000E-04  +2.24410000E-04  -1.04000000E-04  +1.67228000E-03  -1.21574300E-02
   -5.35660000E-04  +5.66536600E-02  -3.02237950E-01  -3.54593600E-02  -2.79940000E-04
   +3.40560000E-04  -1.97040000E-04  -1.10630000E-04  +6.46800000E-05  -6.05000000E-05
   -7.19860000E-04  -2.04320000E-04  +1.05850000E-04  +2.19600000E-04  +4.84400000E-05
   +1.64110000E-04  -9.28600000E-05  -2.65200000E-05  -4.04600000E-05  -4.73500000E-05
   -3.59700000E-05  -3.58500000E-05  -6.94700000E-05  +4.40690000E-04  -2.59650000E-04
   -7.97140000E-04  -5.57880000E-04  +4.93350000E-04  -4.35400000E-05  +2.64600000E-05
   -5.55400000E-05  +1.65441000E-03  -1.39150000E-04  +2.99487000E-03  -3.36000000E-06
   -1.19400000E-05  -8.21000000E-06  +1.39700000E-05  -1.06000000E-06  -6.24000000E-06
   -7.11900000E-05  +1.32500000E-05  -7.66300000E-05  -1.26534000E-03  +4.57420000E-04
   -6.49870000E-04  +1.05900000E-05  +5.53000000E-06  +2.33800000E-05  +1.16620000E-04
   +3.99740000E-04  -8.95900000E-05  +2.07470000E-04  -7.65760000E-04  -2.37160000E-04
   -5.53600000E-05  +2.60460000E-04  -2.13850000E-04  -6.14244400E-02  +3.29018370E-01
   -3.69700000E-05  +2.13800000E-05  -2.94360000E-04  -2.76800000E-05  +3.83450000E-04
   +8.08430000E-04  -2.66100000E-04  +6.17170000E-04  -1.79090000E-03  +1.12400000E-04
   -8.91930000E-04  -6.78800000E-04  +1.54552000E-03  +1.52320000E-04  +6.91400000E-05
   +1.19950000E-04  -2.06100000E-04  -4.24800000E-05  -3.49441000E-03  +2.69797600E-02
   +4.86285000E-03  +6.87698000E-03  -3.78684400E-02  -5.14782100E-02  -1.51960000E-04
   -1.59750000E-04  -1.07740000E-04  -5.30640000E-04  +1.60850000E-04  -3.00740000E-04
   +7.06490000E-04  -2.97870000E-04  +3.28410000E-04  +4.94600000E-05  -4.06800000E-05
   -3.01610000E-04  +1.02200000E-04  +1.25090000E-04  +2.79000000E-06  -3.80100000E-05
   -1.68860000E-04  +1.49400000E-04  -1.86070000E-04  +7.25300000E-05  -1.89820000E-04
   -1.42130000E-04  -7.00460000E-04  +4.33010000E-04  +1.89900000E-05  +3.16800000E-05
   -3.28500000E-05  -2.42603000E-03  +1.42551000E-03  -4.88564000E-03  -1.30000000E-05
   +5.55000000E-06  -2.06000000E-06  -1.46300000E-05  +2.31200000E-05  +1.30500000E-05
   +3.10300000E-05  +4.21400000E-05  +4.14200000E-05  -3.78970000E-04  +3.93600000E-05
   +1.83350000E-04  +1.66000000E-06  +3.00000000E-08  +1.24500000E-05  +6.30500000E-05
   -1.61950000E-04  -7.87500000E-05  -2.80350000E-04  +1.80884000E-03  +3.48580000E-04
   -2.24690000E-04  -3.29000000E-05  +1.36500000E-04  -7.40408000E-03  +3.87148400E-02
   +5.71271000E-02  -7.19160000E-04  +3.05630000E-04  +1.71744000E-03  -3.15290000E-04
   +5.17000000E-06  -4.36400000E-04  -1.18710000E-04  +3.07750000E-04  +1.29190000E-04
   +2.44020000E-04  +1.78800000E-05  +1.66880000E-04  -2.03210000E-04  -3.91910000E-04
   -1.06500000E-04  -4.75560000E-04  +1.49970000E-04  +1.61878000E-03  -1.28942900E-02
   -6.51276000E-03  -1.73814000E-03  -2.44759430E-01  -1.15734720E-01  -5.07629500E-02
   +1.06090000E-04  -3.42700000E-05  +1.79860000E-04  +3.62900000E-05  +7.06000000E-05
   -9.14000000E-06  -1.37370000E-04  +1.61386000E-03  -2.31403000E-03  -2.54450000E-04
   -7.39990000E-04  +7.95900000E-05  -2.85770000E-04  +8.11600000E-05  -9.86000000E-05
   +2.20850000E-04  +1.94210000E-04  -3.50100000E-05  +5.73000000E-05  -2.20000000E-07
   -6.94000000E-05  +3.25060000E-04  +2.31590000E-04  -1.14930000E-04  -2.74220000E-04
   -1.17190000E-04  -6.01200000E-05  +3.11510000E-04  -1.14467000E-03  +7.05260000E-04
   +4.06200000E-05  +6.16000000E-06  +2.28900000E-05  -1.01090000E-04  -1.04000000E-05
   +4.84000000E-06  +1.95500000E-05  +2.31300000E-05  -7.51100000E-05  -1.18620000E-04
   +2.29890000E-04  +4.81200000E-05  -1.75500000E-05  -1.99600000E-05  -3.40000000E-06
   +4.96620000E-04  +8.01570000E-04  -1.94520000E-04  +4.84860000E-04  +4.81000000E-06
   +1.63700000E-04  -2.00510000E-04  +3.81700000E-05  -6.15100000E-05  +7.34627000E-03
   +4.13010000E-03  +1.90267000E-03  +2.66041340E-01  -5.97900000E-04  +8.91800000E-04
   +4.21900000E-04  -4.82820000E-04  -4.31800000E-05  -3.81160000E-04  +2.13140000E-04
   -1.40840000E-04  -1.34640000E-04  +1.44150000E-04  +1.53190000E-04  -2.91140000E-04
   -5.58550000E-04  -6.90340000E-04  -4.00090000E-04  +1.19440000E-04  -1.60320000E-04
   +8.52740000E-04  +1.26156300E-02  +5.72245000E-03  +2.36839000E-03  -1.17217940E-01
   -1.16980270E-01  -2.89151000E-02  +2.69560000E-04  -4.83100000E-05  +2.70700000E-05
   +2.04910000E-04  +1.21320000E-04  +1.58490000E-04  +7.75140000E-04  -1.35687000E-03
   +2.73651000E-03  +5.70710000E-04  +5.98620000E-04  +1.70290000E-04  +1.72060000E-04
   -5.34100000E-05  -6.42000000E-06  -6.66000000E-05  -1.68750000E-04  +8.29900000E-05
   -9.72000000E-05  +3.40800000E-04  -2.64040000E-04  -1.58760000E-04  -8.16130000E-04
   +5.94230000E-04  +2.10000000E-06  +6.58900000E-05  -4.41200000E-05  +1.55705000E-03
   +7.31100000E-04  +5.20560000E-04  -1.10500000E-05  -2.96000000E-06  -5.41000000E-06
   +7.39200000E-05  +3.75000000E-06  -1.65900000E-05  -3.79300000E-05  +7.28000000E-05
   +1.29800000E-05  -8.62400000E-05  +3.77200000E-04  -5.63130000E-04  +1.27400000E-05
   +9.30000000E-06  +1.74600000E-05  +7.53300000E-05  -4.22750000E-04  +6.30230000E-04
   +7.38000000E-06  +1.05330000E-04  -1.05500000E-04  +2.35100000E-05  -2.90400000E-05
   -1.17310000E-04  -2.69313500E-02  -1.32842300E-02  -5.19037000E-03  +1.25662130E-01
   +1.23820160E-01  +2.20100000E-04  +8.37000000E-05  -1.36351000E-03  -8.81380000E-04
   -3.42730000E-04  +4.11780000E-04  +2.39640000E-04  +3.90700000E-05  -1.99180000E-04
   +1.88540000E-04  +5.54700000E-05  -7.90800000E-05  -4.37600000E-04  -1.08542000E-03
   -1.69820000E-04  +7.67510000E-04  +2.19140000E-04  -9.14800000E-05  -2.39634200E-02
   -1.36354600E-02  -6.93476000E-03  -4.72735800E-02  -2.66036900E-02  -5.68828000E-02
   +2.88960000E-04  +9.81600000E-05  +1.00160000E-04  +1.95300000E-05  +4.57340000E-04
   -2.86500000E-05  -6.69360000E-04  +3.30980000E-03  -3.31654000E-03  -1.51024000E-03
   -8.45520000E-04  +4.81300000E-05  -7.38700000E-05  +3.30690000E-04  -2.76990000E-04
   +1.47090000E-04  -5.77000000E-06  +4.91800000E-05  -1.58510000E-04  -1.58690000E-04
   +1.92620000E-04  +3.15270000E-04  +9.22210000E-04  -1.32200000E-04  -9.25700000E-05
   -7.79400000E-05  -1.35300000E-05  +1.53680000E-04  -1.45541000E-03  +5.43210000E-04
   +2.68500000E-05  +6.48000000E-06  +4.80000000E-06  -1.22130000E-04  -6.38800000E-05
   -4.77500000E-05  +1.34500000E-05  +6.71000000E-06  +3.60000000E-06  +4.28720000E-04
   -2.86910000E-04  +9.32900000E-05  -4.51900000E-05  -4.77000000E-06  +4.93000000E-06
   +2.06090000E-04  +7.87170000E-04  +1.65180000E-04  +3.45530000E-04  -2.26070000E-04
   -7.14700000E-05  +2.03500000E-04  +2.16500000E-05  +2.58200000E-05  -3.58964000E-03
   -2.17602000E-03  -1.58847000E-03  +5.39266800E-02  +2.67717000E-02  +6.34146700E-02
   -7.37820000E-04  +4.13160000E-04  +5.67380000E-04  -6.83910000E-04  +5.14840000E-04
   -2.73621000E-03  -7.03600000E-05  +4.28880000E-04  -2.32800000E-05  +1.42990000E-04
   -1.32600000E-04  +9.14400000E-05  -1.41820000E-04  -6.27810000E-04  -2.13370000E-04
   +2.94620000E-04  -2.14610000E-04  +7.58900000E-04  +8.00438000E-03  -6.72930000E-04
   -1.11776700E-02  -1.44677210E-01  +1.43031000E-02  +1.28186700E-01  +3.53530000E-04
   -3.40250000E-04  +3.75590000E-04  +2.94200000E-05  +1.99190000E-04  +1.55400000E-05
   -7.93720000E-04  -5.47140000E-04  -7.70140000E-04  +5.04230000E-04  +1.77670000E-04
   +4.41280000E-04  -2.03820000E-04  -3.86810000E-04  +7.03000000E-05  +1.94800000E-05
   +2.18950000E-04  -1.98990000E-04  +7.65500000E-05  -8.00000000E-08  -1.71070000E-04
   -6.68460000E-04  -5.70510000E-04  -8.09160000E-04  -8.39700000E-05  -2.19400000E-05
   +3.08600000E-05  -6.04300000E-05  -1.67670000E-04  +2.21590000E-04  -1.28000000E-06
   -2.93000000E-06  +1.56300000E-05  +2.49600000E-05  +7.38000000E-06  +1.31100000E-05
   +2.52000000E-05  -2.04600000E-05  +3.49700000E-05  -7.11560000E-04  -6.45270000E-04
   -5.65370000E-04  +2.24500000E-05  -2.13700000E-05  -1.42000000E-05  -2.66200000E-05
   +7.31400000E-05  +7.72000000E-05  +2.90200000E-05  -2.86890000E-04  -4.24000000E-06
   +1.29450000E-04  +1.10510000E-04  -6.84300000E-05  -4.43059000E-03  -6.48230000E-04
   +4.22638000E-03  -1.49259000E-02  +3.67494000E-03  +2.10847400E-02  +1.58354860E-01
   +1.87740000E-04  +2.75280000E-04  +3.28940000E-04  +3.19490000E-04  -1.37738000E-03
   +1.23116000E-03  +2.52750000E-04  -5.52500000E-05  -4.83970000E-04  -1.29370000E-04
   +4.14280000E-04  -2.20670000E-04  -3.38470000E-04  -2.64520000E-04  +1.75090000E-04
   -1.53650000E-04  +3.13300000E-05  +1.09270000E-04  -7.43081000E-03  -4.47080000E-04
   +1.08834100E-02  +1.26144400E-02  -4.66612700E-02  -1.69300000E-02  -1.94930000E-04
   +2.32220000E-04  +4.61000000E-06  +2.54800000E-05  +1.35060000E-04  -3.51800000E-05
   -4.63500000E-05  +2.22420000E-04  -3.37000000E-04  +1.44000000E-05  -3.14340000E-04
   -4.11200000E-05  -2.18200000E-05  -9.99000000E-06  +3.97800000E-05  -2.31800000E-05
   +8.77800000E-05  -1.06140000E-04  +1.31270000E-04  -1.93340000E-04  +2.75780000E-04
   -5.22730000E-04  +5.91900000E-04  -7.26950000E-04  +6.72700000E-05  -2.81400000E-05
   +3.98300000E-05  -1.69860000E-04  +1.77590000E-04  -1.88090000E-04  -2.07000000E-06
   +2.26000000E-06  +1.86000000E-06  -1.62500000E-05  +2.63000000E-06  +2.09100000E-05
   +4.86000000E-06  -5.60000000E-07  +3.32200000E-05  -3.43280000E-04  -1.04409000E-03
   -5.76920000E-04  -2.93300000E-05  +1.47000000E-06  -6.23000000E-06  -2.43600000E-05
   +4.81900000E-05  +1.56070000E-04  +1.64910000E-04  +1.04810000E-04  -3.45120000E-04
   +4.31510000E-04  -6.03100000E-04  +2.35870000E-04  +1.92113800E-02  -9.21370000E-04
   -2.47527000E-02  -9.18191000E-03  +1.16638000E-03  +1.35769100E-02  -1.48550700E-02
   +4.83402900E-02  -9.49820000E-04  -1.63070000E-04  +3.30300000E-05  -1.42911000E-03
   +1.22878000E-03  -1.76577000E-03  +2.14830000E-04  +8.13370000E-04  +2.36090000E-04
   +4.51000000E-06  -1.64690000E-04  +1.16310000E-04  -3.09560000E-04  +9.55100000E-05
   -1.27890000E-04  +4.00700000E-05  -2.14400000E-05  +3.67580000E-04  +1.48901000E-02
   -1.53454000E-03  -2.35414900E-02  +1.29688150E-01  -1.82971800E-02  -2.09531140E-01
   +5.40900000E-05  +1.69470000E-04  -8.27980000E-04  +2.06490000E-04  -1.58870000E-04
   +8.84200000E-05  +3.75010000E-04  +1.98280000E-04  +9.64770000E-04  -4.75570000E-04
   +3.78800000E-04  +5.15100000E-05  +2.99380000E-04  -4.06300000E-05  +4.17600000E-05
   +4.52000000E-05  -2.00910000E-04  +8.11900000E-05  -3.25870000E-04  -1.82080000E-04
   +1.27730000E-04  -1.36300000E-05  +4.92590000E-04  -1.51900000E-05  +8.68600000E-05
   +3.03300000E-05  +5.88400000E-05  +2.40640000E-04  -8.25110000E-04  +4.83490000E-04
   -9.42000000E-06  -1.83800000E-05  -1.56400000E-05  +4.52400000E-05  -2.65300000E-05
   -3.10900000E-05  +6.93900000E-05  -6.43400000E-05  +7.06200000E-05  -1.34040000E-04
   -9.05410000E-04  -1.10860000E-04  -5.85000000E-06  +4.50000000E-06  -1.32600000E-05
   -8.81100000E-05  -8.43500000E-05  -2.03400000E-05  -3.74530000E-04  -5.28100000E-05
   +3.20240000E-04  -2.73060000E-04  +6.45890000E-04  +3.50590000E-04  +1.72241000E-03
   +1.74300000E-05  -2.83215000E-03  -4.51392000E-03  +9.87450000E-04  +6.21173000E-03
   -1.39305350E-01  +1.77772800E-02  +2.29378300E-01  +5.28960000E-04  -5.33470000E-04
   -2.71370000E-04  -1.50710000E-03  +1.76682000E-03  -1.17873000E-03  -2.77727850E-01
   -6.92985100E-02  -1.05505630E-01  -1.32663500E-02  -7.69321000E-03  -1.02964800E-02
   +3.02596000E-03  +3.48998000E-03  -4.25811000E-03  +3.70900000E-05  +1.36310000E-04
   +8.28590000E-04  -1.24410000E-04  -7.43140000E-04  -5.99740000E-04  -4.27600000E-05
   -3.52500000E-05  +1.71460000E-04  +4.90760000E-04  +5.90250000E-04  +5.62270000E-04
   -2.33139000E-03  +1.14950000E-04  +2.11570000E-04  -1.11146000E-03  +1.45718000E-03
   +1.62812000E-03  +2.19710000E-04  +3.65450000E-04  +6.65810000E-04  -8.23500000E-05
   -2.51410000E-04  -2.30210000E-04  -2.11680000E-04  -2.71900000E-05  -2.74700000E-04
   +3.14660000E-04  -4.37000000E-05  +1.08680000E-04  -6.59240000E-04  +6.88030000E-04
   +7.24200000E-04  +7.53400000E-05  +4.09800000E-05  +4.74100000E-05  +1.52200000E-05
   +1.89000000E-06  -9.17600000E-05  -2.40400000E-05  -5.20000000E-06  -9.53000000E-06
   -3.89000000E-06  +2.36000000E-06  +1.49500000E-05  +9.69000000E-06  -5.18300000E-05
   -2.62900000E-05  +3.62000000E-05  -5.44800000E-05  -1.61150000E-04  +2.15000000E-06
   -4.61000000E-06  -1.53800000E-05  -1.15400000E-05  -5.43000000E-06  -1.20000000E-07
   -3.56000000E-06  +1.90000000E-05  -4.80000000E-07  +1.77500000E-05  -2.08900000E-05
   -2.17400000E-05  -3.59200000E-05  +2.12300000E-05  +2.42700000E-05  -3.47000000E-06
   +9.07000000E-06  +1.31500000E-05  +4.68300000E-05  +1.55500000E-05  +1.29300000E-05
   +2.92623210E-01  +1.46997000E-03  -6.00610000E-03  -5.37700000E-04  -2.77693600E-02
   -7.02478000E-03  -1.13908600E-02  -6.86820300E-02  -7.71793500E-02  -3.23317600E-02
   +2.28242100E-02  +1.04964300E-02  +8.76662000E-03  +6.60710000E-04  -4.05375000E-03
   -1.76734000E-03  +2.41700000E-04  +6.94860000E-04  +3.37060000E-04  -2.20930000E-04
   +4.02910000E-04  -1.04590000E-04  +7.52200000E-05  +3.70000000E-07  +7.73000000E-06
   +9.20140000E-04  +4.46032000E-03  -2.02060000E-04  +1.90645000E-03  +1.97240000E-04
   +1.12429000E-03  -1.09580000E-04  -2.69620000E-04  -5.76350000E-04  +4.03310000E-04
   -3.06550000E-04  +2.56340000E-04  +5.80400000E-05  +9.90000000E-06  +1.12110000E-04
   +3.11170000E-04  +1.56410000E-04  -5.00500000E-05  -8.50000000E-05  -1.24950000E-04
   -1.26540000E-04  +3.63390000E-04  +5.38750000E-04  -8.44900000E-05  -3.05190000E-04
   -1.45050000E-04  -5.90900000E-05  -1.51000000E-05  -3.32000000E-06  +1.26340000E-04
   +4.21800000E-05  +1.61100000E-05  +2.41400000E-05  -1.12400000E-05  -1.26300000E-05
   -1.91200000E-05  -6.59000000E-06  -2.68200000E-05  -5.26100000E-05  +3.65000000E-06
   -2.57400000E-05  +5.37700000E-05  -3.41600000E-05  -3.74000000E-06  +3.97400000E-05
   +2.69200000E-05  +7.58700000E-05  +5.86900000E-05  -2.45200000E-05  -1.80400000E-05
   -5.30000000E-06  +5.10200000E-05  +8.71000000E-06  -4.44500000E-05  -3.00900000E-05
   -2.85000000E-06  +2.64000000E-06  +2.89700000E-05  +1.76700000E-05  +7.58700000E-05
   +1.09200000E-05  +9.84000000E-06  -6.61800000E-05  +7.01476700E-02  +7.75015800E-02
   +9.64470000E-04  -1.29315000E-03  +9.61760000E-04  -6.31587000E-03  +4.03400000E-05
   -1.23884000E-03  -1.04786620E-01  -3.15712900E-02  -8.76864200E-02  -6.92880000E-03
   -2.97310000E-03  +7.41038000E-03  -3.87190000E-03  -8.13170000E-04  +1.20245800E-02
   +6.74360000E-04  +5.94160000E-04  -1.78174000E-03  -7.58310000E-04  +6.00770000E-04
   +1.05716000E-03  +1.97510000E-04  +3.45000000E-05  -2.43790000E-04  +1.68713000E-03
   -9.73550000E-04  +9.47350000E-04  +7.25980000E-04  +4.32840000E-04  -2.51176000E-03
   +2.61680000E-04  -8.36670000E-04  -6.97310000E-04  +2.03960000E-04  -3.34500000E-05
   +2.56340000E-04  +1.36600000E-05  +9.02000000E-06  -1.09860000E-04  +3.47540000E-04
   -5.38500000E-05  +1.40310000E-04  +5.39300000E-05  +2.11190000E-04  +3.59100000E-05
   +3.86440000E-04  +2.80200000E-05  -4.07460000E-04  -2.82980000E-04  -9.72100000E-05
   -1.05900000E-04  +1.56570000E-04  -2.62700000E-05  -8.71900000E-05  +2.91900000E-05
   +1.33300000E-05  +3.71100000E-05  -4.70400000E-05  +2.61200000E-05  -3.03000000E-06
   -1.59500000E-05  +3.44300000E-05  -2.77100000E-05  -2.85200000E-05  -2.12200000E-05
   -8.48600000E-05  +3.37000000E-06  -1.56000000E-06  -5.51000000E-06  +3.29100000E-05
   +6.57800000E-05  +3.68800000E-05  -2.64300000E-05  -1.72900000E-05  +2.73000000E-06
   -9.59000000E-06  -4.47800000E-05  -2.25300000E-05  -5.92600000E-05  -8.55900000E-05
   -3.20000000E-05  +1.72000000E-05  +7.03800000E-05  +5.75500000E-05  -4.05700000E-05
   -4.59100000E-05  -8.76500000E-05  +1.15211470E-01  +3.58609000E-02  +7.77458500E-02
   -2.81810000E-04  +1.47240000E-04  -1.01040000E-04  -1.55516000E-03  +2.51090000E-04
   -3.37512000E-03  +7.04030000E-03  +2.56285000E-02  +3.89510000E-03  -5.97203900E-02
   -4.15860000E-02  -1.34049100E-02  +6.98000000E-05  -2.97932400E-02  -4.56356000E-03
   -4.71015000E-03  +8.61700000E-05  -2.35923000E-03  +4.99720000E-04  -7.92940000E-04
   -7.67130000E-04  -1.70460000E-04  +4.14200000E-05  +4.83800000E-05  -4.28170000E-04
   +2.73684000E-03  -1.13846000E-03  +2.32114000E-03  +2.99029000E-03  +2.06767000E-03
   +6.81000000E-06  +6.27600000E-05  +1.09130000E-04  +8.56100000E-05  +3.92700000E-05
   +5.09000000E-06  -5.20800000E-05  -1.09450000E-04  +1.71300000E-05  +3.16400000E-05
   +7.58000000E-05  -4.86800000E-05  -9.54000000E-06  -5.14800000E-05  -3.65700000E-05
   +1.54900000E-05  +4.30800000E-05  -5.81600000E-05  -6.78200000E-05  -4.48900000E-05
   -1.15000000E-05  -3.64000000E-05  +4.15500000E-05  +2.94000000E-05  -2.70000000E-07
   +3.34000000E-06  +8.22000000E-06  -7.52000000E-06  +2.34000000E-06  +3.38000000E-06
   -1.25100000E-05  -1.65900000E-05  +3.41000000E-05  +9.18000000E-06  +2.01600000E-05
   +4.93300000E-05  -2.49800000E-05  -1.33000000E-06  +1.90400000E-05  -8.50000000E-07
   +1.85800000E-05  -4.40000000E-07  +9.34000000E-06  +6.87000000E-06  -1.65900000E-05
   +2.87000000E-06  +2.70500000E-05  +7.82000000E-06  +1.66600000E-05  -1.44400000E-05
   -1.32500000E-05  +1.07900000E-05  +1.35300000E-05  +2.41900000E-05  +4.40900000E-05
   -1.61600000E-05  +5.72600000E-05  -3.01710000E-04  -5.51250000E-04  +2.85084000E-03
   +5.71876600E-02  +1.58610000E-04  +4.98050000E-04  +2.25070000E-04  +2.49723000E-03
   +1.47433000E-03  -3.64120000E-04  -4.22098000E-03  -1.56436600E-02  -4.32987000E-03
   -4.16906200E-02  -3.29426170E-01  -4.83742500E-02  +2.59489000E-03  -7.42889000E-03
   +9.51000000E-05  -1.32144000E-03  +7.07540000E-04  -7.40300000E-04  -1.96710000E-04
   -4.07800000E-05  +1.07670000E-04  +1.00330000E-04  -5.90800000E-05  -4.68800000E-05
   +1.40320000E-04  -7.48880000E-04  +4.77180000E-04  -2.65380000E-04  +2.35245000E-03
   +2.08970000E-04  -3.41800000E-05  -2.21400000E-05  -2.04800000E-05  -2.86400000E-05
   -2.85400000E-05  +5.18000000E-06  +2.82400000E-05  +8.54200000E-05  -2.79200000E-05
   -4.85800000E-05  -5.58200000E-05  +2.08900000E-05  +3.48300000E-05  +4.90800000E-05
   +4.12600000E-05  -4.79000000E-06  -5.27600000E-05  +5.00700000E-05  +8.19000000E-05
   +4.56000000E-05  +1.55900000E-05  +4.44100000E-05  +1.78800000E-05  -8.99500000E-05
   -5.22000000E-06  -3.14000000E-06  -1.02200000E-05  +8.18000000E-06  -2.52000000E-06
   -6.30000000E-07  -6.75000000E-06  +1.91900000E-05  -3.34300000E-05  +6.49000000E-06
   -2.48300000E-05  -5.79700000E-05  +1.78600000E-05  +2.65000000E-06  -9.48000000E-06
   +7.20000000E-07  +1.28600000E-05  +1.43700000E-05  -7.21000000E-06  +5.94000000E-06
   +2.00200000E-05  +1.84100000E-05  -3.99700000E-05  -2.13500000E-05  -3.93800000E-05
   -3.83800000E-05  -2.47100000E-05  -7.72000000E-06  +4.10900000E-05  +2.98200000E-05
   +9.50000000E-07  +9.07000000E-06  -4.78400000E-05  +6.23000000E-06  +7.45170000E-04
   +9.57020000E-04  +4.22316700E-02  +3.47945850E-01  +1.70500000E-05  +2.97240000E-04
   -4.29700000E-04  -4.62113000E-03  +2.30770000E-03  +6.57122000E-03  -3.94660000E-04
   +6.76545000E-03  +6.78579000E-03  -1.40236500E-02  -4.84409600E-02  -4.95811600E-02
   +1.97240000E-04  -1.26058600E-02  +2.40581000E-03  -2.94338000E-03  +8.02500000E-05
   +7.39650000E-04  -6.54550000E-04  +1.42710000E-03  +1.38595000E-03  +7.94400000E-05
   -4.20300000E-05  -1.18290000E-04  +1.40825000E-03  -3.50375000E-03  +1.52814000E-03
   +1.39152000E-03  +1.74633000E-03  -1.18775000E-03  +2.76600000E-04  +3.50500000E-05
   -1.93520000E-04  -6.79900000E-05  +8.71800000E-05  -7.63500000E-05  -1.81200000E-05
   -2.63000000E-06  +3.70000000E-07  +5.21000000E-05  +2.90500000E-05  +6.36000000E-06
   +3.15000000E-06  +1.42100000E-05  -5.91000000E-06  +3.91200000E-05  -8.82400000E-05
   +1.00430000E-04  -5.23900000E-05  -2.50000000E-05  -2.26100000E-05  -1.54070000E-04
   -7.43700000E-05  +1.61910000E-04  +8.32000000E-06  +8.45000000E-06  +9.39000000E-06
   -6.50000000E-06  +5.80000000E-06  -2.27000000E-06  +6.41000000E-06  -2.80700000E-05
   +2.39500000E-05  +1.38300000E-05  -3.02100000E-05  -6.22900000E-05  +1.61100000E-05
   +3.42000000E-06  +6.19000000E-06  +1.82400000E-05  +1.09300000E-05  +2.03700000E-05
   -2.89000000E-06  -2.04800000E-05  -2.27100000E-05  -1.15600000E-05  +9.60900000E-05
   +3.15600000E-05  -6.71700000E-05  -7.50100000E-05  +2.98300000E-05  -1.19000000E-06
   +5.31100000E-05  +5.76600000E-05  +1.48200000E-05  +1.38900000E-05  +1.19900000E-05
   +3.05701000E-03  +9.08780000E-04  -6.27288000E-03  +1.65224700E-02  +5.18566800E-02
   +3.80992200E-02  -1.60476200E-02  -7.77186000E-03  -5.75925000E-03  +2.58597000E-03
   +2.15034000E-03  -8.19260000E-04  +4.07670000E-04  +2.97340000E-04  +1.54190000E-04
   +9.07750000E-04  -1.09056000E-03  -1.08240000E-04  -4.52695000E-03  +2.53246000E-03
   -2.57056000E-03  -3.02613210E-01  -7.38602200E-02  -7.20364000E-02  +8.53630000E-04
   +1.11710000E-04  -5.15770000E-04  -1.31690000E-04  -7.51800000E-05  +1.83000000E-06
   -1.96397000E-03  +8.84080000E-04  -1.70995000E-03  +1.85159000E-03  -2.90800000E-04
   +1.20819000E-03  -1.41900000E-04  -1.03550000E-04  +2.98200000E-05  +5.49000000E-05
   -1.95600000E-05  +5.94200000E-05  -6.74000000E-06  -2.40900000E-05  +1.51900000E-05
   +8.24800000E-05  +8.99000000E-06  +3.32000000E-05  -6.37500000E-05  +8.12000000E-06
   -3.77700000E-05  +4.42500000E-05  +1.13430000E-04  -6.27000000E-06  -7.72600000E-05
   -2.53100000E-05  -1.71700000E-05  -1.09940000E-04  -4.05300000E-05  +1.36730000E-04
   +1.16800000E-05  -2.80000000E-06  +3.96000000E-06  -1.06000000E-06  -4.00000000E-07
   -3.77000000E-06  +1.85000000E-05  +6.27000000E-06  -1.71000000E-05  +4.35000000E-06
   -1.13300000E-05  -6.02000000E-06  +4.70000000E-07  -5.16000000E-06  -5.52000000E-06
   -4.17000000E-06  +1.36100000E-05  -2.53000000E-05  +3.17200000E-05  -8.57000000E-06
   -9.23000000E-06  -1.96500000E-05  +4.71800000E-05  +9.40000000E-06  +9.61000000E-06
   +6.22000000E-06  -4.93100000E-05  -3.04700000E-05  +7.50800000E-05  +5.53900000E-05
   +4.97400000E-05  +1.36000000E-05  +5.91300000E-05  -7.69900000E-05  -5.82300000E-05
   -4.19000000E-05  -1.74120000E-04  -7.21800000E-05  -1.61890000E-04  +3.18782030E-01
   +2.39162300E-02  +9.65083000E-03  +5.93979000E-03  +1.32797000E-03  -2.88198000E-03
   +1.31440000E-04  +2.97040000E-04  -3.31730000E-04  +2.25710000E-04  +6.61120000E-04
   -5.87424000E-03  +6.19000000E-05  -3.16178300E-02  -3.34648000E-03  -8.85200000E-03
   -7.36967300E-02  -7.80062200E-02  -1.95383800E-02  -2.68360000E-04  -3.68000000E-05
   +3.89200000E-05  +1.08910000E-04  -7.31900000E-05  -1.16400000E-05  +9.24850000E-04
   +2.77400000E-05  +8.90230000E-04  +3.29769000E-03  +3.30891000E-03  +8.15770000E-04
   +1.29100000E-04  +5.56000000E-05  -5.15100000E-05  -1.55600000E-05  +3.98400000E-05
   -3.09000000E-05  -6.57000000E-06  +1.04700000E-05  -8.68000000E-06  -4.85000000E-05
   +4.29000000E-06  -4.22000000E-05  +6.83200000E-05  +1.69200000E-05  +6.10900000E-05
   -3.31500000E-05  -7.25200000E-05  +1.03800000E-05  +6.46700000E-05  +2.67300000E-05
   +2.13800000E-05  +4.56800000E-05  +8.99700000E-05  +2.05400000E-05  -3.49000000E-06
   +7.50000000E-07  -6.40000000E-06  +3.22000000E-06  -9.80000000E-07  +1.96000000E-06
   -3.66000000E-05  -1.38700000E-05  +2.17400000E-05  +1.90000000E-06  -6.58000000E-06
   -2.17100000E-05  +6.07000000E-06  +3.06000000E-06  -1.42000000E-06  -4.95000000E-06
   +5.95000000E-06  +3.08000000E-06  -3.09700000E-05  +1.08900000E-05  +2.84000000E-06
   +4.71000000E-06  -9.09000000E-06  -1.80000000E-05  -1.66000000E-05  +2.39000000E-06
   -5.65800000E-05  -2.24400000E-05  +4.28600000E-05  +2.08400000E-05  -8.22000000E-06
   +4.06200000E-05  -3.60500000E-05  -3.66500000E-05  +2.28410000E-04  +1.52000000E-06
   -1.50310000E-03  -3.07530000E-04  -7.38160000E-04  +7.66669200E-02  +7.64328500E-02
   -5.00502000E-03  -9.25980000E-04  +4.80410000E-03  -4.78454000E-03  +1.43040000E-03
   +6.93830000E-03  +2.48320000E-04  +6.41900000E-05  -3.53480000E-04  -5.47110000E-04
   -4.90700000E-05  +1.64909000E-03  -2.27985000E-03  -5.88810000E-04  +3.07387000E-03
   -7.20973700E-02  -1.91785400E-02  -5.83216900E-02  -2.12342000E-03  -3.02110000E-04
   +9.25630000E-04  -3.63000000E-05  +5.54700000E-05  -1.83000000E-05  +3.36971000E-03
   -1.62584000E-03  +2.28595000E-03  +9.22910000E-04  +1.27050000E-04  -1.64217000E-03
   +2.43860000E-04  +2.55270000E-04  +2.61760000E-04  -4.25300000E-05  +6.96000000E-06
   -9.08800000E-05  -1.10000000E-06  -5.86000000E-06  -1.55000000E-06  +2.13400000E-05
   +3.12100000E-05  +1.45000000E-06  +3.73900000E-05  -9.69000000E-06  +6.90000000E-06
   -7.93700000E-05  -1.27330000E-04  -1.00700000E-05  -5.55000000E-05  -2.72600000E-05
   -1.58600000E-05  +7.18200000E-05  -7.78200000E-05  -2.30900000E-04  +8.28000000E-06
   +3.58000000E-06  +5.43000000E-06  -7.14000000E-06  -7.00000000E-07  -4.44000000E-06
   +2.47200000E-05  +2.62000000E-06  +7.27000000E-06  -3.20000000E-07  +1.23700000E-05
   +6.47000000E-06  -5.34000000E-06  -1.74000000E-06  +3.85000000E-06  +3.19300000E-05
   +1.81500000E-05  +3.01800000E-05  +2.36200000E-05  -1.17600000E-05  +2.08400000E-05
   +2.21000000E-05  -2.58700000E-05  +3.22500000E-05  -1.58000000E-06  -1.40100000E-05
   +4.51400000E-05  -2.24000000E-06  -5.28100000E-05  -3.39000000E-05  -1.45200000E-05
   -4.38000000E-05  -8.00000000E-07  +6.87500000E-05  +9.67100000E-05  -1.65360000E-04
   +8.13000000E-06  +7.54000000E-06  +1.66240000E-04  +7.99546000E-02  +2.12413100E-02
   +4.77920000E-02  -6.64630300E-02  -5.68443700E-02  -5.70205000E-03  -3.29759000E-03
   -2.99534300E-02  -2.04471000E-03  -5.83701000E-03  +8.73850000E-04  -1.79827000E-03
   +4.98190000E-04  +3.43950000E-04  +7.90970000E-04  -3.24032000E-03  -3.80750000E-04
   -4.55264000E-03  +9.23772000E-03  +2.56736100E-02  -2.32350000E-04  +4.50490000E-04
   -3.34430000E-04  -8.41000000E-05  -5.97600000E-05  +2.45800000E-05  -7.67000000E-06
   +3.04286000E-03  +1.51887000E-03  +2.01942000E-03  -1.72770000E-04  +2.42272000E-03
   +6.26780000E-04  +1.27500000E-04  +2.13650000E-04  -8.40800000E-05  -3.04000000E-05
   -1.39100000E-05  +3.55000000E-05  +2.58100000E-05  +6.94900000E-05  -2.62000000E-06
   -6.14200000E-05  -3.08500000E-05  -2.25500000E-05  +7.23100000E-05  +3.38900000E-05
   +3.03800000E-05  +2.39000000E-05  -2.45900000E-05  +4.41700000E-05  +7.67600000E-05
   +3.78800000E-05  +2.00200000E-05  -7.72530000E-04  -2.29200000E-05  +9.00400000E-05
   -6.73000000E-06  -5.66000000E-06  -1.00600000E-05  +7.41000000E-06  -5.56000000E-06
   -1.30000000E-07  -4.85000000E-06  -1.29400000E-05  -5.32700000E-05  +2.96000000E-06
   -1.40200000E-05  -1.85800000E-05  +1.12500000E-05  +3.28000000E-06  -4.25000000E-06
   -1.04362000E-03  +9.38040000E-04  +1.26089000E-03  -5.27100000E-05  +1.94600000E-05
   -1.26300000E-05  +3.02060000E-04  +1.75170000E-04  +8.79000000E-06  -2.09300000E-05
   +1.11160000E-04  -1.02800000E-04  +9.39100000E-05  -2.51600000E-05  +1.48860000E-04
   +6.57000000E-05  +4.49400000E-05  +9.61600000E-05  +8.21800000E-05  -1.64238000E-03
   -6.04470000E-04  +2.02850000E-04  -2.15000000E-05  +5.94700000E-05  +2.93170000E-04
   -1.74660000E-04  +2.02577000E-03  +6.64466300E-02  -5.59608300E-02  -3.30336030E-01
   -9.84265000E-03  +1.47305000E-03  -6.57254000E-03  +8.63650000E-04  -1.78008000E-03
   +8.58720000E-04  -2.14650000E-04  +3.69170000E-04  +3.64840000E-04  +1.40850000E-04
   +2.44071000E-03  +1.88570000E-03  +1.29660000E-03  -6.65214000E-03  -1.59386000E-02
   -1.39813000E-03  -3.37750000E-04  -3.98260000E-04  -2.15480000E-04  -1.96520000E-04
   -7.02600000E-05  -6.39700000E-05  +6.52390000E-04  +1.49619000E-03  -1.91450000E-04
   +4.70150000E-04  -2.08867000E-03  +1.42450000E-04  +2.47000000E-05  +9.84100000E-05
   +1.54250000E-04  -3.72000000E-06  +8.40000000E-06  +1.20100000E-05  +1.60000000E-07
   +8.70000000E-07  +1.15300000E-05  +2.67800000E-05  +4.77000000E-06  +2.90000000E-06
   +4.81000000E-06  +1.05500000E-05  +5.50000000E-07  -5.36000000E-06  -5.61000000E-06
   -1.65000000E-06  -2.41200000E-05  -5.31000000E-06  -3.45000000E-06  +2.22850000E-04
   -5.42820000E-04  -6.19750000E-04  +5.74000000E-06  -2.56000000E-06  -4.90000000E-07
   +2.14000000E-06  -1.66000000E-06  -3.06000000E-06  +7.19000000E-06  -9.12000000E-06
   -2.07300000E-05  -4.40000000E-07  -1.19000000E-05  -7.91000000E-06  +3.96000000E-06
   -1.61000000E-06  -3.50000000E-06  +1.30897000E-03  +2.14670000E-04  -3.58170000E-04
   +7.19700000E-05  -2.16500000E-05  +4.90700000E-05  +2.81100000E-04  +1.67440000E-04
   +6.31900000E-05  +6.96200000E-05  +7.77700000E-05  -5.29700000E-05  +1.54200000E-05
   -8.43100000E-05  +1.55550000E-04  +3.71700000E-05  +2.70100000E-05  +5.07200000E-05
   -6.79800000E-05  -3.57270000E-04  -9.22600000E-05  +1.33300000E-05  -8.90600000E-05
   -7.19400000E-05  +5.24980000E-04  +9.62120000E-04  -2.83840000E-04  +5.70025800E-02
   +3.50359810E-01  -5.80906000E-03  -8.77088000E-03  -4.28057500E-02  -1.46896000E-03
   -6.08629000E-03  +1.07391000E-03  -1.61169000E-03  -4.70820000E-04  +4.60140000E-04
   +6.62400000E-04  +3.08040000E-04  -1.90326000E-03  -4.39996000E-03  -3.71560000E-04
   +1.27401300E-02  -7.14250000E-04  +6.74030000E-03  +1.02674600E-02  -1.07559000E-03
   -8.46100000E-05  +8.98180000E-04  +7.89700000E-05  +1.01010000E-04  +8.39400000E-05
   +2.19183000E-03  -8.11050000E-04  +1.05720000E-03  +8.13130000E-04  +1.25420000E-04
   -2.63737000E-03  +1.38970000E-04  +7.66800000E-05  +3.29700000E-05  -1.53200000E-05
   -2.83200000E-05  -3.12900000E-05  -2.11000000E-06  +9.69000000E-06  -9.77000000E-06
   +1.42500000E-05  +1.53400000E-05  +1.07800000E-05  +1.21900000E-05  +7.50000000E-06
   +2.41200000E-05  -5.40100000E-05  -9.18400000E-05  -3.38500000E-05  -2.27700000E-05
   -1.30700000E-05  -1.17200000E-05  +4.73120000E-04  +4.02700000E-05  -1.21330000E-04
   +4.71000000E-06  +3.19000000E-06  +4.15000000E-06  -1.05700000E-05  -2.00000000E-07
   -2.00000000E-07  +7.66000000E-06  -2.06000000E-06  +1.44900000E-05  +2.85000000E-06
   +1.20900000E-05  -7.98000000E-06  -4.71000000E-06  +7.00000000E-08  +2.87000000E-06
   +1.20609000E-03  -5.81370000E-04  -4.99300000E-04  -1.07430000E-04  -9.88000000E-06
   -1.01300000E-05  -1.17440000E-04  -4.68800000E-05  -2.23600000E-05  +1.91400000E-05
   -5.77100000E-05  +4.51100000E-05  -8.59700000E-05  +1.13500000E-05  -1.54200000E-04
   -1.13840000E-04  -6.40600000E-05  -7.29300000E-05  -4.09210000E-04  -4.33240000E-04
   +8.57890000E-04  +1.37960000E-04  +6.69600000E-05  -1.66590000E-04  +2.17961000E-03
   -9.67800000E-05  -7.16732000E-03  +8.08000000E-03  +1.05027400E-02  +2.80820000E-02
end_hess

