# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -807.48116270    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +2.18717714E+00  +9.68841796E-01  -1.63072944E+00
   006   +4.59238637E+00  +2.13178593E+00  -1.20240470E+00
   006   +6.60828660E+00  +7.58882923E-01  -3.25830936E-01
   006   +6.42499863E+00  -1.86031448E+00  -4.03350372E-02
   006   +4.21065444E+00  -3.10270224E+00  -7.88038738E-01
   006   +2.19237337E+00  -1.75132632E+00  -1.66390973E+00
   001   +4.76539118E+00  +4.13707332E+00  -1.54737294E+00
   001   +8.37986511E+00  +1.70468330E+00  +8.28548876E-02
   008   +8.35614781E+00  -3.30209640E+00  +8.48727546E-01
   001   +4.15950109E+00  -5.14547661E+00  -7.23613984E-01
   001   +5.19808579E-01  -2.71877666E+00  -2.33206856E+00
   006   +2.03655667E-01  +1.85029115E+00  +1.63054002E+00
   006   -2.32975068E+00  +8.40618176E-01  +1.04378311E+00
   006   +1.57619407E+00  +6.06700954E-01  +3.79390239E+00
   006   +4.12056539E-01  +4.69681893E+00  +1.71063728E+00
   006   -2.98982324E+00  -1.66812556E+00  +1.57325912E+00
   006   -5.31704193E+00  -2.65588919E+00  +9.13049708E-01
   006   -7.09232374E+00  -1.15899969E+00  -3.12794205E-01
   006   -6.50491179E+00  +1.33849892E+00  -8.51192148E-01
   006   -4.17207596E+00  +2.30681610E+00  -1.77225109E-01
   001   -1.65908516E+00  -2.89133394E+00  +2.52171188E+00
   001   -5.75651456E+00  -4.60647782E+00  +1.36135170E+00
   008   -9.40550537E+00  -2.02765973E+00  -1.00452523E+00
   001   -7.89551953E+00  +2.51061976E+00  -1.78310266E+00
   001   -3.79025123E+00  +4.26846039E+00  -5.98662112E-01
   001   +5.44092524E-01  +9.09891908E-01  +5.56055903E+00
   001   +1.81230665E+00  -1.42058115E+00  +3.54562480E+00
   001   +3.45343353E+00  +1.42017550E+00  +4.01488427E+00
   001   -9.18333147E-01  +5.48011500E+00  +3.08628823E+00
   001   +2.30635895E+00  +5.26041675E+00  +2.28499658E+00
   001   +2.60782919E-02  +5.56504174E+00  -1.15551793E-01
   001   -9.57903855E+00  -3.75967858E+00  -5.15071215E-01
   001   +9.77581876E+00  -2.24918873E+00  +1.23008811E+00
   008   +7.23009015E-01  +2.21735314E+00  -3.40515942E+00
   001   -9.86618511E-01  +1.61598915E+00  -3.28830672E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +2.50000000E-07  -2.90000000E-07  -5.00000000E-08
   +2.00000000E-07  -6.00000000E-07  +8.00000000E-08
   +2.10000000E-07  -1.39000000E-06  +2.00000000E-07
   -8.00000000E-08  -6.70000000E-07  +5.00000000E-08
   -7.70000000E-07  -5.80000000E-07  -1.50000000E-07
   -2.50000000E-07  -2.70000000E-07  -1.00000000E-08
   +6.60000000E-07  -6.90000000E-07  +1.90000000E-07
   +2.00000000E-07  -1.39000000E-06  +1.50000000E-07
   -6.20000000E-07  -1.36000000E-06  -4.00000000E-08
   -9.00000000E-07  -6.60000000E-07  -1.60000000E-07
   -4.80000000E-07  +4.00000000E-08  -1.10000000E-07
   +2.30000000E-07  -3.00000000E-08  +1.50000000E-07
   +0.00000000E+00  +3.10000000E-07  -4.00000000E-08
   +2.00000000E-08  -3.60000000E-07  +4.00000000E-08
   +7.30000000E-07  -9.00000000E-08  +1.50000000E-07
   -2.70000000E-07  +5.50000000E-07  -1.00000000E-07
   -5.30000000E-07  +9.10000000E-07  -2.00000000E-07
   -1.80000000E-07  +1.23000000E-06  -1.40000000E-07
   +1.90000000E-07  +1.18000000E-06  -5.00000000E-08
   +2.80000000E-07  +7.10000000E-07  -1.00000000E-08
   -5.40000000E-07  +2.40000000E-07  -1.10000000E-07
   -8.40000000E-07  +9.00000000E-07  -2.50000000E-07
   -4.00000000E-07  +1.65000000E-06  -2.40000000E-07
   +4.20000000E-07  +1.40000000E-06  -1.00000000E-08
   +7.20000000E-07  +7.10000000E-07  +1.10000000E-07
   +2.00000000E-08  -3.00000000E-07  +2.00000000E-08
   -3.40000000E-07  -4.10000000E-07  -5.00000000E-08
   +1.40000000E-07  -7.00000000E-07  +4.00000000E-08
   +8.30000000E-07  +5.00000000E-08  +1.90000000E-07
   +7.80000000E-07  -4.40000000E-07  +2.10000000E-07
   +8.60000000E-07  +5.00000000E-08  +2.60000000E-07
   -6.70000000E-07  +1.62000000E-06  -2.70000000E-07
   -5.00000000E-07  -1.66000000E-06  +0.00000000E+00
   +3.40000000E-07  +2.00000000E-08  +8.00000000E-08
   +2.90000000E-07  +3.40000000E-07  +4.00000000E-08
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +4.43859840E-01  +9.66429200E-02  +5.62720940E-01  +2.72175160E-01  -1.12720970E-01
   +1.57692120E-01  -1.66241520E-01  -7.89430500E-02  -9.50141900E-02  +5.91688420E-01
   -8.56565500E-02  -1.57453860E-01  -1.52061500E-02  -2.08252100E-02  +7.12201770E-01
   -1.53022600E-02  +1.08031400E-02  -7.12597400E-02  +1.43168870E-01  -1.18613170E-01
   +2.06285120E-01  -4.95449800E-02  +4.02790000E-04  -6.96799000E-03  -2.71874100E-01
   +1.24708200E-01  -9.02127900E-02  +6.92642310E-01  +4.82474400E-02  +3.72290600E-02
   -2.66637400E-02  +5.22959400E-02  -1.82704250E-01  +4.19909300E-02  +4.23079700E-02
   +6.27433250E-01  -2.69905000E-02  -7.57981000E-03  +1.06749900E-02  -7.60132600E-02
   +6.28738700E-02  -8.82710400E-02  +1.77173010E-01  -5.85632000E-02  +1.88264780E-01
   -4.21233000E-03  -3.09949100E-02  -1.32618400E-02  +3.56835500E-02  +1.65654100E-02
   +1.00850500E-02  -1.32348680E-01  +1.96440200E-02  -2.51418600E-02  +6.20309120E-01
   -3.38020000E-02  -3.67169700E-02  +3.69534000E-03  +8.23811500E-02  -4.90348900E-02
   +3.43297600E-02  -8.17690500E-02  -2.67134900E-01  +1.47281000E-03  -7.26870000E-04
   +6.45295410E-01  +8.69990000E-03  -1.01185500E-02  -1.55017800E-02  -9.87420000E-04
   +1.30539400E-02  +3.96238000E-03  -1.24507200E-02  +3.42324900E-02  -7.03333100E-02
   +1.82859160E-01  -6.00498400E-02  +2.14905230E-01  -3.07405000E-03  +6.36687100E-02
   +2.99559700E-02  -3.37936200E-02  +1.55823600E-02  -1.81817700E-02  +2.32918400E-02
   -7.30407500E-02  +1.14903900E-02  -2.02006180E-01  -2.04598900E-02  -5.06213200E-02
   +5.86458610E-01  +2.45798700E-02  -1.92849800E-02  +1.59525500E-02  -1.07410000E-03
   -1.34670000E-04  -2.70604000E-03  -2.70647300E-02  -2.32400900E-02  -7.08173000E-03
   -1.15271020E-01  -1.78514710E-01  -3.59596400E-02  -2.78459700E-02  +7.55457360E-01
   -3.69479000E-03  +2.88261300E-02  +2.20939300E-02  -1.19506800E-02  +5.21530000E-03
   -7.82832000E-03  +8.24185000E-03  -2.14721700E-02  +1.19791100E-02  -4.41398600E-02
   -1.27402000E-03  -8.07732600E-02  +1.75638300E-01  -4.41500900E-02  +1.96592660E-01
   -8.90483800E-02  -4.16550100E-02  -3.88924300E-02  +1.07215400E-02  -3.52500700E-02
   +8.63661000E-03  -1.16218400E-02  +2.46614300E-02  -6.17578000E-03  -6.53582100E-02
   -2.78624100E-02  -2.50264600E-02  -2.63549450E-01  +1.40238130E-01  -9.05125400E-02
   +6.70377300E-01  -4.89163500E-02  -2.30191160E-01  +5.20563700E-02  -1.82138400E-02
   -1.14382300E-02  -1.69025200E-02  +1.01892700E-02  -2.66011000E-02  +6.85247000E-03
   +3.37950100E-02  +5.99161500E-02  +8.84258000E-03  +7.19211000E-02  -2.07655780E-01
   +3.20729500E-02  +1.67480000E-04  +6.04078890E-01  -2.75438700E-02  -2.38621500E-02
   -6.79275000E-02  +1.60824700E-02  -8.28043000E-03  +8.80704000E-03  -4.80494000E-03
   +1.71797500E-02  -5.04402000E-03  -2.82423600E-02  -1.67655800E-02  -4.03251000E-03
   -8.95214900E-02  +6.02437100E-02  -9.14811800E-02  +2.21506360E-01  -9.29443000E-03
   +2.35684040E-01  +1.96848000E-03  -2.83955400E-02  +4.75632000E-03  -5.87324200E-02
   -2.72086300E-02  -1.68568000E-03  +6.11663000E-03  +2.51620500E-02  -4.09878000E-03
   -2.81463000E-03  +1.50684000E-03  -3.39487000E-03  -1.03753000E-03  +2.50830000E-04
   -1.66040000E-04  -4.70925000E-03  -1.21577000E-03  -1.78341000E-03  +5.70494200E-02
   +2.41110000E-03  -1.05580800E-02  +3.18045000E-03  -2.89433800E-02  -3.34753570E-01
   +5.23927900E-02  -3.42528000E-03  -1.11139300E-02  +1.67430000E-03  +2.31142000E-03
   +2.15201000E-03  +2.39050000E-03  -5.57940000E-04  +5.01220000E-04  -4.41800000E-04
   -2.70588000E-03  -8.96800000E-05  +4.37100000E-05  +2.81392100E-02  +3.54142590E-01
   +1.06078000E-03  -3.20669000E-03  +2.68189000E-03  -5.15386000E-03  +5.09861100E-02
   -4.35646600E-02  +2.63460000E-03  +9.19905000E-03  +3.37280000E-03  -3.39052000E-03
   +2.06220000E-03  +5.69442000E-03  -7.64700000E-05  -2.42310000E-04  -7.79310000E-04
   -1.87259000E-03  -6.01320000E-04  +2.90905000E-03  +3.08868000E-03  -5.66167100E-02
   +3.44654200E-02  +7.87910000E-04  +3.73744000E-03  -3.35739000E-03  -1.84316400E-02
   -1.37790000E-02  -3.95890000E-03  -2.60211040E-01  -1.12585330E-01  -5.37102500E-02
   -2.52512000E-03  +2.98737000E-03  -2.34433000E-03  +1.71439000E-03  -5.54390000E-04
   -4.87200000E-04  +2.60220000E-04  +1.65830000E-04  +2.31030000E-04  +4.64200000E-04
   +6.63220000E-04  +1.78063000E-03  +2.76731950E-01  +2.10468000E-03  -1.48647000E-03
   +2.20627000E-03  +1.58320500E-02  +1.21081100E-02  +2.92111000E-03  -1.12388800E-01
   -1.21048690E-01  -2.12939900E-02  -2.84793900E-02  -7.76839000E-03  -7.21548000E-03
   +3.45930000E-04  -5.78374000E-03  +1.40126000E-03  +1.08549000E-03  -2.77540000E-04
   +3.98500000E-04  -2.95600000E-05  +5.81230000E-04  -1.04787000E-03  +1.21146110E-01
   +1.22596830E-01  -4.19110000E-03  +8.03130000E-04  +6.18570000E-03  -7.34642000E-03
   -6.42271000E-03  +1.99450000E-03  -5.35681700E-02  -1.89852500E-02  -4.76539100E-02
   +1.40496000E-03  +3.43370000E-04  +3.92946000E-03  -2.09230000E-04  +1.89107000E-03
   +4.46794000E-03  -6.03560000E-04  +1.35743000E-03  -1.03968000E-03  +1.63209000E-03
   -1.09400000E-03  -4.41258000E-03  +6.06457800E-02  +2.28119700E-02  +3.87578500E-02
   -1.29704000E-03  +3.01547000E-03  +6.76720000E-03  -1.24607000E-03  +5.06870000E-04
   -4.37829000E-03  -3.14959000E-03  +4.08864000E-03  -4.17392000E-03  -2.13936550E-01
   +1.14393060E-01  -8.23797200E-02  -4.76807100E-02  +2.58523500E-02  -2.27382400E-02
   +2.42039000E-03  -8.05279000E-03  -1.57066000E-03  -2.58250000E-04  -3.34600000E-05
   -2.49230000E-04  +3.02859000E-03  -3.47810000E-04  +2.32086000E-03  +5.95110010E-01
   +3.22287000E-03  +2.41467000E-03  -3.29994000E-03  -1.01670900E-02  -2.62333000E-03
   -1.01327000E-03  +4.70370300E-02  -3.24874400E-02  +2.15818000E-02  +6.51446400E-02
   -1.74106850E-01  +4.20520300E-02  -1.62303000E-02  +1.83674200E-02  -7.23007000E-03
   +8.24000000E-05  -6.98887000E-03  +1.94088000E-03  +1.64157000E-03  -9.37570000E-04
   +5.75020000E-04  +3.36750000E-04  +2.53552000E-03  -5.87520000E-04  +1.14823640E-01
   +4.17392120E-01  -3.87420000E-04  +9.38340000E-04  +1.90517000E-03  -2.09399000E-03
   +1.23797000E-03  +3.88703000E-03  -9.32227000E-03  +5.87405000E-03  +3.18063000E-03
   -7.40534700E-02  +5.91555400E-02  -6.84606900E-02  -1.81117300E-02  +8.58157000E-03
   -2.98803000E-03  -3.85160000E-04  -1.76458000E-03  +2.33733000E-03  -2.30660000E-04
   +1.09840000E-04  +2.99070000E-04  +1.96345000E-03  -1.08525000E-03  -2.64978000E-03
   +1.95891670E-01  -8.48673000E-03  +9.53964700E-02  -2.48154000E-03  +1.26190000E-04
   -4.78192000E-03  -4.51640000E-04  +5.50080000E-04  -1.30400000E-04  -3.85901000E-03
   -1.84063000E-03  -2.72981000E-03  +4.41469000E-03  -2.69222200E-02  +1.18773000E-03
   -5.68056300E-02  -9.73196000E-03  -7.91222000E-03  +4.91601000E-03  +2.66115900E-02
   +4.45660000E-04  +7.09300000E-05  +5.13500000E-05  +1.52550000E-04  -7.27100000E-05
   -1.29898000E-03  +2.73650000E-04  +1.51911000E-03  +8.20470000E-04  +1.50470000E-03
   +5.25551300E-02  +1.67621000E-03  +1.85605000E-03  +1.37676000E-03  -8.81600000E-05
   +7.44140000E-04  -1.02340000E-04  -2.60788000E-03  +1.45520000E-04  -1.00950000E-03
   +3.55229000E-03  -1.25308900E-02  +2.04085000E-03  -1.17335700E-02  -3.42230950E-01
   +8.05330000E-03  -2.06612000E-03  -1.15646900E-02  -5.07970000E-04  +3.18000000E-06
   -6.43400000E-05  +4.76300000E-05  -6.87800000E-05  -5.26570000E-04  +1.71730000E-04
   +3.73370000E-04  +1.25273000E-03  +1.87900000E-05  +1.02466100E-02  +3.62871310E-01
   -3.17358000E-03  +2.62731000E-03  +6.94553000E-03  -1.49237000E-03  +3.46900000E-04
   -1.13504000E-03  -3.17744000E-03  -1.44315000E-03  +3.41693000E-03  +1.34472000E-03
   -7.83807000E-03  +5.11016000E-03  -9.49101000E-03  +7.75575000E-03  -4.02280100E-02
   +1.75337000E-03  +9.62510000E-03  +3.93808000E-03  +8.54000000E-05  -1.05930000E-04
   -4.11240000E-04  -1.12130000E-04  -6.29860000E-04  +2.37450000E-04  +1.54884000E-03
   -2.67030000E-04  -2.25645000E-03  +9.93529000E-03  -1.00188600E-02  +2.92467200E-02
   +1.51981000E-03  +3.30563000E-03  -4.35050000E-04  +8.66740000E-04  +5.79000000E-06
   -7.96560000E-04  +1.51090000E-04  +1.82960000E-04  +3.31140000E-04  +3.99230000E-04
   +3.75732000E-03  -3.63804000E-03  -1.56912000E-02  -1.34536000E-02  -7.74623000E-03
   -2.41891810E-01  -1.11706290E-01  -8.61348800E-02  +1.20950000E-04  +3.81200000E-05
   +5.34900000E-05  -8.95000000E-05  -3.45900000E-05  +1.52840000E-04  -1.15309000E-03
   -8.55040000E-04  -4.78970000E-04  -3.81300000E-05  +3.03080000E-04  +2.32091000E-03
   +2.56056190E-01  -2.76120000E-02  -9.43482000E-03  -1.05544500E-02  +1.32865000E-03
   -5.63419000E-03  +2.97190000E-04  +8.98470000E-04  -9.55430000E-04  +3.52060000E-04
   +3.13871000E-03  -8.07300000E-04  +1.31478000E-03  +1.49385300E-02  +1.18282500E-02
   +5.98527000E-03  -1.10853290E-01  -1.24833100E-01  -4.54524200E-02  -1.55876000E-03
   -5.82690000E-04  -2.04410000E-04  -8.68300000E-05  +7.91600000E-05  +3.76200000E-05
   +8.30900000E-04  +4.79140000E-04  +2.03120000E-04  -3.56740000E-04  +8.77340000E-04
   -1.43150000E-04  +1.18174350E-01  +1.27361940E-01  -9.55090000E-04  -9.69660000E-04
   +9.66760000E-04  -3.90130000E-04  +4.76880000E-04  +3.15824000E-03  +4.88900000E-04
   +2.21210000E-04  -5.38250000E-04  -3.70726000E-03  +1.60595000E-03  +6.11715000E-03
   -7.60799000E-03  -6.74450000E-03  +1.99294000E-03  -8.49061000E-02  -4.09076500E-02
   -6.69030400E-02  +9.20000000E-07  -6.68000000E-06  -3.09740000E-04  +5.52100000E-05
   -9.35300000E-05  -4.49220000E-04  -6.13150000E-04  -2.33390000E-04  +2.62150000E-04
   +2.34827000E-03  -1.66920000E-04  -4.56491000E-03  +9.41048400E-02  +4.75252100E-02
   +5.94720000E-02  +5.79504500E-02  -3.85850000E-02  -8.60588800E-02  -5.17327800E-02
   -4.68175000E-03  +8.43046000E-03  +7.78035000E-03  -1.82630100E-02  +7.86251000E-03
   -4.74190000E-03  +6.85996000E-03  -5.20150000E-03  +1.32165200E-02  -1.55674000E-03
   +8.06169000E-03  -8.74059000E-03  +3.84608500E-02  +5.83190000E-03  +4.93070000E-04
   +4.39900000E-05  -1.57622000E-03  +4.47530000E-04  -4.50740000E-04  -2.91040000E-04
   +4.54100000E-05  -1.68940000E-04  +2.03100000E-04  +2.28380000E-04  -5.00700000E-05
   +3.63130000E-04  -3.31080000E-04  -6.40540000E-04  -9.04810000E-04  +3.76377390E-01
   -2.64223600E-02  -1.23133100E-02  +2.19335700E-02  +1.05078300E-02  +6.49001000E-03
   +3.36147000E-03  -2.45449000E-03  +2.22216000E-03  -1.73572000E-03  +4.54040000E-03
   +9.05910000E-04  +2.14212000E-03  -8.74932000E-03  -1.32128000E-03  -3.83248000E-03
   +1.26884800E-02  -1.68760300E-02  -1.00896200E-02  -4.15320000E-04  -6.69980000E-04
   +4.11810000E-04  -1.80300000E-05  +9.09700000E-05  -4.42810000E-04  -9.70420000E-04
   +3.19770000E-04  -4.07700000E-04  -3.88790000E-04  +1.03060000E-04  +6.09380000E-04
   -4.40000000E-04  -1.73100000E-05  +8.22400000E-04  +5.15540800E-02  +4.96553180E-01
   -1.00311780E-01  +4.51658000E-02  +9.04219900E-02  +4.92570700E-02  +7.21117000E-03
   +4.58850000E-04  -7.93697000E-03  +1.81733800E-02  -9.23656000E-03  +8.36758000E-03
   -6.33678000E-03  +6.55375000E-03  -1.83024400E-02  -6.59200000E-05  -1.18693700E-02
   +1.74035900E-02  -4.43242300E-02  -6.72411000E-03  -6.42040000E-04  -2.76880000E-04
   +1.50530000E-03  -4.02500000E-04  +2.64250000E-04  +8.30000000E-07  -3.93686000E-03
   +2.39024000E-03  -2.02349000E-03  -2.49260000E-04  +1.61810000E-04  +1.90490000E-04
   -3.57020000E-04  +3.89730000E-04  +1.69704000E-03  +1.96147960E-01  -7.62668800E-02
   +2.70317620E-01  -2.93044500E-02  +4.97086000E-03  +3.27617600E-02  +1.02046200E-02
   +2.14730000E-03  -5.07060000E-04  -2.50203000E-03  +2.86064000E-03  -1.91120000E-03
   -6.33380000E-04  -5.29750000E-04  +6.24580000E-04  -1.82627000E-03  -2.47410000E-04
   -6.94760000E-04  +2.39900000E-05  -5.53458000E-03  -4.35730000E-04  +7.29100000E-05
   -1.76900000E-05  +2.22500000E-04  +1.22400000E-04  +8.89800000E-05  -6.51000000E-06
   +2.11998000E-03  -1.28889000E-03  +8.45820000E-04  +3.72600000E-05  -1.14680000E-04
   +9.03700000E-05  -2.16830000E-04  -7.65400000E-05  -7.36480000E-04  -1.62051260E-01
   -4.91872600E-02  -6.43453900E-02  +5.65615930E-01  -1.48173000E-03  +2.42323000E-03
   +1.09698100E-02  +2.61413000E-03  -3.22320000E-04  -1.32836000E-03  -4.44800000E-04
   +5.49240000E-04  -3.84710000E-04  -6.57830000E-04  +4.09890000E-04  +6.29000000E-06
   -3.65770000E-04  +3.87510000E-04  -6.41270000E-04  +2.00102000E-03  -2.50318000E-03
   -1.48819000E-03  +1.53590000E-04  +1.44580000E-04  -2.70000000E-06  +6.20100000E-05
   +2.59700000E-05  +1.03530000E-04  +1.44453000E-03  -9.05080000E-04  +6.22640000E-04
   -1.88000000E-06  -5.59300000E-05  +5.58000000E-06  +5.37970000E-04  -1.38940000E-04
   -1.89810000E-04  -2.82761200E-02  -1.13472020E-01  -6.45655000E-03  +3.67810500E-02
   +6.16353690E-01  +8.42396000E-03  +3.47393000E-03  +8.65530000E-04  +8.89080000E-04
   -6.45110000E-04  -1.89790000E-03  -2.47320000E-04  +3.67590000E-04  +1.08090000E-04
   -1.44093000E-03  -2.87600000E-05  -3.75610000E-04  +1.18463000E-03  +4.45610000E-04
   +5.80800000E-05  +8.13920000E-04  -1.61219000E-03  -9.02670000E-04  -2.38800000E-05
   +1.19360000E-04  +9.03800000E-05  +1.07970000E-04  +5.43300000E-05  +4.26800000E-05
   +1.79896000E-03  -1.07225000E-03  +9.17960000E-04  +5.11000000E-05  -1.01990000E-04
   -1.08600000E-04  +5.73760000E-04  -7.66000000E-05  -9.26700000E-05  -2.67275400E-02
   +5.12261000E-03  -7.72702600E-02  +1.45638290E-01  -1.26950290E-01  +2.76327930E-01
   -1.00582000E-03  -4.18390000E-04  +6.22407000E-03  +2.86871000E-03  +4.36900000E-05
   +1.78999000E-03  -9.01100000E-04  +1.94955000E-03  -1.15350000E-04  +1.24568000E-03
   -8.38210000E-04  +8.63120000E-04  -1.47902000E-03  -9.95300000E-05  +6.87680000E-04
   +1.86130000E-04  -2.08877000E-03  +6.16610000E-04  -5.67200000E-05  -9.38300000E-05
   +2.30690000E-04  -2.04930000E-04  +2.35600000E-05  -1.91700000E-05  -1.09274000E-03
   +6.58230000E-04  -6.37930000E-04  -8.07300000E-05  +5.34400000E-05  -9.33500000E-05
   +1.58900000E-05  +1.08680000E-04  +2.37200000E-04  -9.96066400E-02  +2.44909500E-02
   -5.42653300E-02  -2.18774100E-02  +1.10710100E-02  -2.69944900E-02  +5.58659040E-01
   -1.44100000E-04  +1.07595000E-03  -1.24026000E-03  -8.46760000E-04  -7.96980000E-04
   -4.50000000E-07  +1.99090000E-04  -8.06900000E-05  -9.05270000E-04  -9.36170000E-04
   +1.23180000E-04  -4.54740000E-04  +2.04123000E-03  -1.18250000E-04  +3.16810000E-04
   -7.59430000E-04  +6.68660000E-04  -1.22361000E-03  +1.53060000E-04  +5.31700000E-05
   -1.32720000E-04  -2.44300000E-05  -5.21200000E-05  +1.02370000E-04  +5.35620000E-04
   -3.39270000E-04  +2.49810000E-04  +6.40800000E-05  -1.06010000E-04  -1.59200000E-05
   -7.44100000E-05  +1.37600000E-05  -1.23800000E-05  +2.00816000E-02  -1.06865930E-01
   +4.15019200E-02  -1.40783000E-03  +9.65755000E-03  -8.48035000E-03  +2.18223800E-02
   +5.77823990E-01  +5.25387000E-03  -7.56230000E-04  -1.63140500E-02  -2.78718000E-03
   -1.44958000E-03  -1.55809000E-03  +2.56910000E-04  -2.72050000E-04  -5.84660000E-04
   -5.21230000E-04  +2.65120000E-04  -1.00235000E-03  +6.48460000E-04  +1.67230000E-04
   -2.77740000E-04  +4.18600000E-05  +3.13323000E-03  -1.31583000E-03  +1.22330000E-04
   +5.33000000E-06  -2.41840000E-04  +6.96200000E-05  +9.06000000E-06  +4.09200000E-05
   +3.84930000E-04  -2.69920000E-04  +4.08320000E-04  +1.65100000E-05  -9.78900000E-05
   -3.08500000E-05  +1.00270000E-04  -4.56900000E-05  -2.57650000E-04  -6.23402500E-02
   +4.93656000E-02  -1.37298220E-01  -3.43333000E-03  +8.53910000E-04  -6.22803000E-03
   -2.23160700E-02  +2.46676600E-02  +4.91964310E-01  -4.89659000E-03  +1.08848400E-02
   +7.41900000E-03  +9.30350000E-04  +1.07411000E-03  +1.42255000E-03  -2.81000000E-04
   +1.72888000E-03  -3.74480000E-04  +7.36710000E-04  -1.00878000E-03  +5.35850000E-04
   -7.77970000E-04  +2.95530000E-04  -6.12490000E-04  -5.88530000E-04  -2.69999000E-03
   +9.76820000E-04  -2.88130000E-04  +2.88970000E-04  +5.39860000E-04  -1.64330000E-04
   +3.11800000E-05  +6.98400000E-05  -1.02412000E-03  +6.04030000E-04  -5.13030000E-04
   +1.56700000E-05  +2.10900000E-05  -1.43390000E-04  +6.23100000E-05  +1.04350000E-04
   +1.46810000E-04  -7.26285300E-02  -9.65033000E-03  -1.21848800E-02  -4.45611000E-03
   -3.37907600E-02  -1.31081000E-03  +7.24730000E-04  +1.38639200E-02  -5.75450000E-04
   +5.80069600E-01  +3.95462000E-03  -5.79823000E-03  -8.56135000E-03  +2.97130000E-04
   -2.07790000E-04  -1.19869000E-03  -9.57600000E-05  -3.62110000E-04  -3.86700000E-05
   +5.10300000E-04  +1.78370000E-04  +1.43920000E-04  -4.89690000E-04  -3.93160000E-04
   -2.18830000E-04  +4.47960000E-04  +5.27540000E-04  +5.40550000E-04  -7.09700000E-05
   -3.51470000E-04  +1.66020000E-04  -3.94200000E-05  -4.35000000E-06  -1.07300000E-05
   -6.51070000E-04  +3.45310000E-04  -2.83970000E-04  -2.73800000E-05  +4.73800000E-05
   +7.15000000E-06  +2.80000000E-07  +2.00200000E-05  -3.46300000E-05  -1.29809700E-02
   -1.98852210E-01  +7.74486000E-03  -6.30722000E-03  -1.44306300E-02  -4.71369000E-03
   +2.58770000E-03  -2.17825700E-02  +3.13203000E-03  +6.77960000E-04  +4.75526140E-01
   +7.65456000E-03  -1.49836500E-02  -8.69663000E-03  -1.39113000E-03  -7.54640000E-04
   -1.71319000E-03  +3.19550000E-04  -1.92291000E-03  +3.31200000E-04  -7.21500000E-04
   +1.31905000E-03  -5.71340000E-04  +8.54330000E-04  -6.43550000E-04  +9.30030000E-04
   +6.89670000E-04  +3.23759000E-03  -1.47157000E-03  +7.59010000E-04  -9.62060000E-04
   -1.19290000E-04  +1.00640000E-04  +2.19000000E-06  -1.13200000E-04  +9.78820000E-04
   -6.62550000E-04  +5.59840000E-04  -3.62200000E-05  -5.82700000E-05  +1.34780000E-04
   -1.14930000E-04  -1.32500000E-05  -6.27300000E-05  -1.62163400E-02  -6.62896000E-03
   -6.80606200E-02  +3.41176000E-03  -6.05224000E-03  +1.46539000E-03  -2.07742000E-03
   +3.12316700E-02  +1.63813000E-03  +1.71443200E-02  -1.77526600E-02  +5.68292600E-01
   +1.35830000E-04  +3.87760000E-04  -4.29691000E-03  -7.46810000E-04  +6.55790000E-04
   -7.61100000E-05  +6.62500000E-05  -1.20162000E-03  +2.93830000E-04  +6.44420000E-04
   +9.71770000E-04  -1.40800000E-05  -9.03210000E-04  -1.18060000E-04  -4.95950000E-04
   +2.63630000E-04  -3.99740000E-04  +1.56650000E-03  -1.68900000E-05  -4.48200000E-05
   -6.49100000E-05  +2.84100000E-05  -7.03000000E-06  -7.85700000E-05  +1.48390000E-04
   -2.01310000E-04  +1.11810000E-04  -5.32200000E-05  +5.79000000E-05  +6.19300000E-05
   -7.87910000E-04  -4.80800000E-05  +4.95990000E-04  -1.23430300E-02  -3.44259500E-02
   +7.06198000E-03  -1.26813270E-01  -1.58731400E-02  -1.74785800E-02  -1.50165000E-03
   -9.77900000E-04  +7.19330000E-04  -4.63434000E-03  +8.71300000E-05  -2.25385000E-03
   +6.50277760E-01  +3.41874000E-03  -7.79600000E-04  -9.26470000E-03  -2.98682000E-03
   -2.25110000E-04  +5.80220000E-04  +7.76630000E-04  -1.13997000E-03  +5.95440000E-04
   +2.88360000E-04  +5.93480000E-04  -1.56400000E-04  +2.86290000E-04  -9.80000000E-05
   +2.22490000E-04  +3.38190000E-04  +1.10395000E-03  +2.32150000E-04  -6.01900000E-05
   -3.03400000E-05  -7.49200000E-05  +1.35300000E-05  -3.84100000E-05  -3.24900000E-05
   -2.38760000E-04  +6.25300000E-05  -1.80500000E-05  +5.17300000E-05  -6.46400000E-05
   -8.18900000E-05  +2.67830000E-04  +2.54420000E-04  -6.54600000E-05  -2.83675300E-02
   -1.29861500E-02  +3.63007000E-03  -6.09507700E-02  -2.79522750E-01  +4.34859700E-02
   +9.56100000E-05  -7.23750000E-04  +6.47240000E-04  +2.03570000E-04  +1.45123000E-03
   -6.35230000E-04  +3.17895600E-02  +6.37869840E-01  -1.11880000E-04  +1.30330000E-04
   +4.56880000E-04  +1.30440000E-04  -5.33100000E-05  +3.19110000E-04  -2.70000000E-06
   +3.81520000E-04  +3.75000000E-06  -4.24170000E-04  -3.94680000E-04  -6.16200000E-05
   +2.18670000E-04  +2.47720000E-04  +8.64300000E-05  +6.06380000E-04  +9.44000000E-06
   -1.43836000E-03  +3.15300000E-05  +2.12800000E-05  -4.82700000E-05  +6.77000000E-06
   +1.63100000E-05  +2.46000000E-06  +8.39100000E-05  +6.85500000E-05  -3.07700000E-05
   -5.89100000E-05  +4.91900000E-05  +6.38100000E-05  +9.68020000E-04  +1.16490000E-04
   -2.21310000E-04  +2.27771000E-03  -7.25118000E-03  +3.92848000E-03  -4.02740000E-03
   +6.24454200E-02  -9.08734000E-02  -6.07790000E-04  -1.16380000E-03  +5.81250000E-04
   -3.15439000E-03  -8.51820000E-04  +1.14277000E-03  +2.00188410E-01  -1.48628970E-01
   +2.73268240E-01  +3.23400000E-05  -7.09290000E-04  +3.35103000E-03  +4.71360000E-04
   -4.57810000E-04  +6.92200000E-05  +4.26400000E-05  +9.41050000E-04  -1.57530000E-04
   +1.44900000E-04  -8.48710000E-04  +2.13950000E-04  +2.05060000E-04  +4.15000000E-06
   +1.22670000E-04  -3.95900000E-04  +1.00170000E-04  -3.67280000E-04  +5.59500000E-05
   +4.01500000E-05  +6.89000000E-06  -5.42900000E-05  -7.95000000E-06  +4.79500000E-05
   -7.75570000E-04  +5.78940000E-04  -3.99910000E-04  +1.16600000E-05  +2.12900000E-05
   -1.45400000E-05  +7.37400000E-05  +1.58150000E-04  +2.01610000E-04  +8.94189000E-03
   +1.64468000E-03  -2.64292000E-03  +1.37417000E-03  -7.71001000E-02  +2.19082900E-02
   -4.87170000E-04  +4.04790000E-04  -2.64830000E-04  -8.29460000E-04  +6.21900000E-05
   +5.31010000E-04  -2.98425290E-01  -5.24711100E-02  -8.26685800E-02  +6.20715230E-01
   +7.29100000E-04  -1.53850000E-04  +6.87110000E-04  -2.55500000E-05  +9.04000000E-05
   -2.60880000E-04  +7.93300000E-05  -1.86280000E-04  +2.72900000E-05  -3.30590000E-04
   +2.24760000E-04  -1.35170000E-04  +1.22510000E-04  +2.53510000E-04  -3.30300000E-05
   -1.54930000E-04  -1.02040000E-04  -2.38510000E-04  +5.61000000E-05  +3.53400000E-05
   -1.53600000E-05  +2.19600000E-05  +1.45000000E-05  +1.95900000E-05  +4.22940000E-04
   -2.32320000E-04  +1.72840000E-04  -3.79800000E-05  +1.58500000E-05  +1.39000000E-05
   -8.31700000E-05  +2.83000000E-05  +1.52500000E-04  +1.14191000E-03  -4.67189000E-03
   +2.44970000E-03  -3.28905100E-02  -8.52034000E-03  -7.83519000E-03  +1.07408000E-03
   -9.77200000E-05  +3.24320000E-04  -1.34315000E-03  -2.39920000E-04  -1.85830000E-04
   -1.15339540E-01  -1.56891340E-01  -1.70086400E-02  +8.29241600E-02  +6.91316460E-01
   -9.04340000E-04  -4.75080000E-04  +1.54808000E-03  +2.76730000E-04  -7.42000000E-05
   +2.06570000E-04  +5.81200000E-05  +5.52360000E-04  -1.06500000E-05  +3.37180000E-04
   -4.28580000E-04  +2.11240000E-04  -2.08130000E-04  -4.14100000E-05  -7.96000000E-06
   -2.30010000E-04  -2.12270000E-04  -1.38270000E-04  +2.68200000E-05  +9.40000000E-06
   +9.27000000E-06  -2.76600000E-05  -4.74000000E-06  +3.79000000E-06  -6.46500000E-04
   +4.50270000E-04  -2.92660000E-04  -7.63000000E-06  +1.12600000E-05  -5.80800000E-05
   +1.72790000E-04  +8.47700000E-05  +1.50000000E-04  +8.26920000E-04  +3.98325000E-03
   +3.02524000E-03  +8.41138000E-03  -2.71387800E-02  +1.90708400E-02  -4.49240000E-04
   +7.48700000E-05  -2.43440000E-04  +7.51120000E-04  +4.44100000E-04  +5.61820000E-04
   -6.35271600E-02  +9.26595000E-03  -8.78669700E-02  +1.80959600E-01  -1.48040670E-01
   +2.49493100E-01  +1.15348000E-03  +3.53690000E-04  -8.65370000E-04  -7.09540000E-04
   +4.15100000E-05  -5.12260000E-04  +2.34260000E-04  -1.02534000E-03  +1.69540000E-04
   -1.15264000E-03  +1.14779000E-03  -5.40680000E-04  +5.44080000E-04  +3.63330000E-04
   +1.00650000E-04  -2.29700000E-05  +1.88980000E-04  -4.06390000E-04  -2.04200000E-05
   +3.42000000E-05  +1.21400000E-05  +1.20730000E-04  +2.12400000E-05  +6.11600000E-05
   +1.74155000E-03  -1.10811000E-03  +7.60440000E-04  -1.11800000E-05  -7.24300000E-05
   +2.08300000E-05  -1.82140000E-04  +1.16150000E-04  +2.19910000E-04  -3.79318000E-03
   -7.97710000E-04  +2.50550000E-04  -3.25050000E-04  +2.14925800E-02  -4.43802000E-03
   +3.08890000E-04  +3.16420000E-04  +5.54800000E-05  +4.70520000E-04  -1.34600000E-04
   +5.31000000E-05  -4.76647100E-02  -3.05984000E-03  -2.01746000E-02  -1.95824420E-01
   +1.03640130E-01  -8.71673900E-02  +6.31816110E-01  +4.03849000E-03  -1.67108000E-03
   +6.06750000E-04  -1.69415000E-03  -9.09670000E-04  -5.39150000E-04  +6.37550000E-04
   -4.27860000E-04  +2.54090000E-04  -7.63600000E-04  +2.46220000E-04  -3.77120000E-04
   +9.56510000E-04  +1.12000000E-04  +3.10750000E-04  -5.35500000E-04  +1.63182000E-03
   -1.74170000E-04  +1.39200000E-05  +6.33200000E-05  +8.90000000E-07  +2.15400000E-05
   -1.56800000E-05  +1.33890000E-04  +2.97030000E-04  -1.70220000E-04  +1.03320000E-04
   +2.84100000E-05  -3.50700000E-05  +2.20800000E-05  +6.71900000E-05  +1.56000000E-04
   +2.16150000E-04  -1.87209000E-03  -7.67970000E-04  +8.18200000E-04  +2.13151900E-02
   -6.41487600E-02  +2.80092700E-02  +6.38250000E-04  +2.80030000E-04  -7.11890000E-04
   -7.49300000E-05  +4.52410000E-04  +2.10010000E-04  +5.09665600E-02  +7.12821000E-02
   +9.03000000E-05  +2.57758800E-02  -2.04473740E-01  +5.48537100E-02  +6.61864900E-02
   +6.81258940E-01  -6.40960000E-04  +6.53040000E-04  -2.57300000E-04  +2.89060000E-04
   +2.67750000E-04  -1.27240000E-04  -1.27180000E-04  -2.33030000E-04  -5.97400000E-05
   -2.13220000E-04  +3.59490000E-04  -9.37700000E-05  -5.25300000E-05  +4.92900000E-05
   -1.19670000E-04  +7.50200000E-05  -4.11670000E-04  +1.14600000E-04  -1.04700000E-05
   -7.11000000E-06  +1.67100000E-05  +3.24500000E-05  +1.30900000E-05  -5.54000000E-06
   +5.76080000E-04  -3.78890000E-04  +2.69330000E-04  -2.47400000E-05  -1.05500000E-05
   +1.12400000E-05  -2.11930000E-04  -6.61900000E-05  -1.61600000E-05  -9.97540000E-04
   -2.52240000E-04  -6.98620000E-04  -4.04369000E-03  +2.75026000E-02  -1.64887600E-02
   -1.01280000E-04  -5.34200000E-05  +1.86160000E-04  +1.47720000E-04  -2.10410000E-04
   +4.30900000E-05  -3.73862900E-02  -2.31665900E-02  -5.83992000E-03  -6.16029600E-02
   +8.72418600E-02  -1.22594070E-01  +1.76938000E-01  -1.38146400E-01  +2.78297940E-01
   -4.64794000E-03  +2.26527000E-03  +3.85890000E-04  +2.15872000E-03  +6.38050000E-04
   +5.60150000E-04  -6.88000000E-04  +8.22250000E-04  -3.72290000E-04  +2.14700000E-04
   -4.60800000E-04  +2.55360000E-04  -4.70220000E-04  -1.05680000E-04  -1.19600000E-04
   +4.10800000E-05  -1.62322000E-03  +1.89430000E-04  -3.24000000E-05  -5.98400000E-05
   +9.70000000E-07  +1.27800000E-05  +1.53100000E-05  -9.75800000E-05  +4.76500000E-05
   -1.64400000E-05  +2.57100000E-05  +5.48000000E-06  -4.73000000E-06  -1.62800000E-05
   -5.28600000E-05  -5.02800000E-05  -2.97900000E-04  +6.76541000E-03  +3.20723000E-03
   -4.44917000E-03  -4.48223300E-02  +3.66680500E-02  -3.37861600E-02  -1.83305000E-03
   -4.44830000E-04  +6.10030000E-04  +1.03050000E-04  -1.10730000E-04  +3.06040000E-04
   -3.05587300E-02  -3.37767700E-02  -1.17031000E-03  +5.00353100E-02  +1.24347800E-02
   +1.35017100E-02  -1.24682710E-01  +6.88239000E-03  -2.44456600E-02  +6.61494950E-01
   -5.90375000E-03  +2.09054000E-03  +6.94820000E-04  +2.37448000E-03  +8.15780000E-04
   +7.73050000E-04  -7.04200000E-04  +9.22490000E-04  -3.58200000E-04  +9.17170000E-04
   -4.50480000E-04  +5.17660000E-04  -1.32053000E-03  -1.28840000E-04  -4.74400000E-04
   +7.32880000E-04  -2.12038000E-03  +1.31890000E-04  +1.58000000E-06  -6.20300000E-05
   -6.12000000E-06  -2.40300000E-05  +1.25300000E-05  -1.14840000E-04  -5.31880000E-04
   +3.38520000E-04  -2.40330000E-04  -3.65100000E-05  +4.46200000E-05  -1.35300000E-05
   -4.18900000E-05  -2.90600000E-05  -8.68200000E-05  +7.00634000E-03  -2.39902000E-03
   +2.60140000E-03  -5.30260000E-03  +5.81008500E-02  -1.99912600E-02  +3.64730000E-04
   +6.69760000E-04  +7.04000000E-04  -8.51090000E-04  -9.40710000E-04  +1.28240000E-04
   -3.46830100E-02  -4.27427200E-02  -1.85627000E-03  +5.56521900E-02  -3.09673500E-02
   +3.58415300E-02  -6.74286500E-02  -3.04541680E-01  +4.59525700E-02  +3.50519200E-02
   +6.62225210E-01  -1.53637000E-03  +7.46240000E-04  -4.62490000E-04  +5.30280000E-04
   +4.27900000E-05  +1.98590000E-04  -1.05360000E-04  +1.84090000E-04  -7.38300000E-05
   +4.50000000E-06  -6.34000000E-05  +1.64900000E-05  -1.09330000E-04  -6.69200000E-05
   +3.87300000E-05  -7.14200000E-05  -2.13220000E-04  +2.66980000E-04  -2.64100000E-05
   -2.29700000E-05  -1.60800000E-05  +1.93500000E-05  -4.07000000E-06  -5.50000000E-06
   +3.29500000E-05  -2.94600000E-05  +1.50600000E-05  +1.65600000E-05  -1.47800000E-05
   -2.32000000E-06  -1.01330000E-04  -7.89000000E-06  -1.54490000E-04  -1.73639000E-03
   +2.96435000E-03  +2.66860000E-03  -1.96078100E-02  -9.25160000E-04  -9.06800000E-05
   -3.04600000E-05  +7.18300000E-05  +2.65270000E-04  +3.35800000E-04  +3.03630000E-04
   -2.06570000E-04  -7.15880000E-04  -9.42860000E-04  -2.64148000E-03  -4.38810000E-04
   +1.73141300E-02  +2.25233000E-03  -1.57269000E-03  +7.51882200E-02  -9.45549600E-02
   +2.09807760E-01  -1.50010620E-01  +2.61813630E-01  +8.75477000E-03  -3.72395000E-03
   -4.38990000E-03  -4.67117000E-03  -1.02846000E-03  -7.89730000E-04  +1.48923000E-03
   -1.88234000E-03  +8.13210000E-04  +2.26100000E-05  +9.25440000E-04  -4.18870000E-04
   +8.12260000E-04  +7.54300000E-05  +2.15100000E-04  -7.64000000E-05  +2.88656000E-03
   +5.26700000E-05  +1.08800000E-05  +7.17300000E-05  -1.66300000E-05  -7.11000000E-06
   -4.61100000E-05  +1.05620000E-04  -4.24750000E-04  +2.16480000E-04  -1.29830000E-04
   +9.08000000E-06  +8.96000000E-06  -1.44000000E-06  +1.71890000E-04  +1.72880000E-04
   +5.03450000E-04  -3.67241400E-02  +1.28547700E-02  -1.32381900E-02  -1.95647430E-01
   +3.92819200E-02  -6.26363300E-02  -1.40021000E-03  -3.01725000E-03  -2.81200000E-05
   -1.42926000E-03  +7.65400000E-04  -1.26700000E-05  +4.82215400E-02  +5.29756500E-02
   +5.05390000E-04  -5.81549500E-02  +6.21573000E-03  -2.52356600E-02  +8.06632000E-03
   -8.87612000E-02  +3.03243800E-02  -3.00975350E-01  -4.86132100E-02  -8.58371700E-02
   +6.13683870E-01  -2.16863000E-03  +6.66910000E-04  +2.62241000E-03  +1.25069000E-03
   +2.37280000E-04  +1.11680000E-04  -3.76770000E-04  +5.73670000E-04  -2.16800000E-04
   -1.22900000E-04  -4.12220000E-04  +6.97000000E-05  -1.88500000E-05  -1.30820000E-04
   +8.84000000E-05  -2.31150000E-04  -4.87610000E-04  -2.10300000E-05  -3.70700000E-05
   -2.85700000E-05  +6.60000000E-06  +6.96000000E-06  +1.46300000E-05  -1.40200000E-05
   +5.27800000E-05  -1.26000000E-06  +2.10000000E-07  -1.29400000E-05  +1.03800000E-05
   +2.86400000E-05  -8.78000000E-05  -1.29140000E-04  -1.23210000E-04  +2.35116000E-03
   +1.49672000E-02  -8.97206000E-03  +8.31102500E-02  -1.84190950E-01  +7.10718900E-02
   -4.47472000E-03  -1.24986000E-03  +1.54180000E-04  -1.39250000E-03  +4.51310000E-04
   -6.80330000E-04  +1.60773500E-02  -3.49231700E-02  +2.00647300E-02  +6.40509000E-03
   -3.40895000E-03  +2.77637000E-03  -3.54730700E-02  -1.08061200E-02  -1.05988200E-02
   -1.11023520E-01  -1.55960820E-01  -1.62801200E-02  +8.29909000E-02  +6.93668420E-01
   +2.27237000E-03  -3.33400000E-05  -6.47398000E-03  -1.99716000E-03  -1.82820000E-04
   +6.93240000E-04  +6.07850000E-04  -6.21850000E-04  +4.47780000E-04  +3.58200000E-05
   +4.00350000E-04  -1.18550000E-04  +1.36380000E-04  +1.17230000E-04  +2.37700000E-05
   +5.92000000E-06  +5.65090000E-04  +1.84380000E-04  +1.66500000E-05  +1.33900000E-05
   -9.46100000E-05  +2.81200000E-05  -2.66700000E-05  -2.37900000E-05  -9.53300000E-05
   +3.58600000E-05  -3.57900000E-05  +3.75600000E-05  -2.03800000E-05  -3.50100000E-05
   +1.36570000E-04  +2.06080000E-04  +1.50020000E-04  -1.86292000E-02  -6.52360000E-04
   +9.80010000E-04  -7.57191800E-02  +5.24707300E-02  -1.14737600E-01  -8.94080000E-04
   -3.83610000E-04  +8.27620000E-04  -3.94900000E-04  +1.28459000E-03  -9.85100000E-04
   +1.22999800E-02  +3.45267500E-02  +1.39762000E-03  -2.45023300E-02  +3.45893000E-03
   -1.42229200E-02  +1.32520600E-02  -3.23128600E-02  +1.78048500E-02  -6.67363700E-02
   +8.44441000E-03  -8.93914000E-02  +1.67787860E-01  -1.30920100E-01  +2.51316260E-01
   -2.25030000E-04  -6.40800000E-05  +1.51050000E-04  -3.62000000E-06  -2.73800000E-05
   +7.34800000E-05  +1.89500000E-05  +6.10700000E-05  -1.98100000E-05  -5.10600000E-05
   -1.13800000E-05  -4.83700000E-05  -1.53980000E-04  +1.10900000E-05  -1.56270000E-04
   +4.86700000E-05  -9.77600000E-05  +3.99860000E-04  -1.20000000E-07  +3.24000000E-06
   +3.64000000E-06  +3.70000000E-07  +5.33000000E-06  +1.24000000E-05  +1.46000000E-06
   +6.31000000E-06  -1.24400000E-05  -2.90000000E-06  +4.13600000E-05  +4.37600000E-05
   -1.45910000E-04  -6.83700000E-05  +4.62100000E-05  -8.72230000E-04  +4.72700000E-04
   +7.52780000E-04  +9.21115000E-03  -3.68447000E-03  +3.31840000E-03  -6.84000000E-04
   -1.49680000E-03  -2.97870000E-04  +1.64160000E-04  +1.36030000E-04  -8.62900000E-05
   -1.75260480E-01  +1.09533830E-01  -9.32278500E-02  -1.44697200E-02  +1.80012600E-02
   -1.33511900E-02  -2.03026000E-03  -3.99504000E-03  -2.84084000E-03  -3.65100000E-04
   -6.52050000E-04  +5.51010000E-04  +1.22231000E-03  -2.56119000E-03  -1.20125000E-03
   +1.86339650E-01  +2.71990000E-04  -2.84120000E-04  +1.52830000E-04  -8.17600000E-05
   +2.17000000E-06  -9.14100000E-05  -1.27000000E-06  -1.50300000E-04  -1.69000000E-06
   -8.85600000E-05  +1.24760000E-04  -2.63100000E-05  -5.24500000E-05  +1.61810000E-04
   -9.78800000E-05  +1.84970000E-04  +5.80000000E-05  -1.65760000E-04  +3.57000000E-06
   +6.83000000E-06  +1.60500000E-05  -2.26000000E-06  -5.40000000E-07  +9.73000000E-06
   +9.33000000E-05  -6.62400000E-05  +2.46100000E-05  +2.69400000E-05  -3.06400000E-05
   -8.67000000E-06  +9.47000000E-05  +7.69200000E-05  +2.61900000E-05  +1.56089000E-03
   +2.15730000E-04  -1.88900000E-05  +2.12118500E-02  -1.14353400E-02  +1.38848600E-02
   +6.03770000E-04  -4.29120000E-04  -2.07720000E-04  -1.16680000E-04  +5.72700000E-05
   -3.00500000E-04  +1.09368870E-01  -1.61353060E-01  +8.55091900E-02  -9.73110000E-03
   +1.01847200E-02  -6.06700000E-03  -3.62398000E-03  +6.25390000E-04  +8.60130000E-04
   -8.24690000E-04  -5.60810000E-04  -5.45470000E-04  -3.00211000E-03  -4.93638000E-03
   +2.38732000E-03  -1.16174010E-01  +1.65937380E-01  +1.64690000E-04  +2.30790000E-04
   -2.71470000E-04  -1.17800000E-05  -8.42200000E-05  -1.07270000E-04  -1.50420000E-04
   -1.45990000E-04  -8.60500000E-05  -2.18000000E-06  -8.01000000E-06  +9.30000000E-07
   +2.88160000E-04  -8.75400000E-05  +9.44000000E-05  +1.44390000E-04  +2.13860000E-04
   -8.63000000E-06  -2.85600000E-05  -2.01500000E-05  +3.99000000E-06  -6.16000000E-06
   -9.05000000E-06  -3.72000000E-06  +9.94600000E-05  -1.03500000E-04  +4.03400000E-05
   +7.82300000E-05  -5.31500000E-05  -1.28900000E-05  -1.18610000E-04  +1.79100000E-05
   -4.08280000E-04  +6.09750000E-04  -6.24120000E-04  -2.13398000E-03  -5.03455000E-03
   +2.86861000E-03  +1.04264000E-03  -7.52480000E-04  -3.93060000E-04  +4.37400000E-05
   -6.91800000E-05  -1.54390000E-04  -2.39350000E-04  -9.28744900E-02  +8.60110700E-02
   -1.04378120E-01  -4.55578000E-03  +5.45940000E-03  +4.03250000E-04  -3.13953000E-03
   +6.96770000E-04  +6.41030000E-03  +6.59850000E-04  -5.46320000E-04  -7.06690000E-04
   -9.96710000E-04  +2.58756000E-03  +4.95110000E-03  +1.05138780E-01  -9.36272000E-02
   +9.93382800E-02  +7.72000000E-05  -3.68900000E-05  -3.21500000E-05  +1.77500000E-05
   +2.78900000E-05  +1.62400000E-05  +1.24300000E-05  +4.26700000E-05  +9.33000000E-06
   +7.59300000E-05  -5.43600000E-05  +2.98000000E-05  -4.02600000E-05  -2.84600000E-05
   -1.45000000E-05  -3.39800000E-05  -2.16600000E-05  +2.24500000E-05  +1.12400000E-05
   +3.92000000E-06  -8.42000000E-06  -3.55000000E-06  +1.58000000E-06  -4.30000000E-06
   -1.09870000E-04  +8.60900000E-05  -5.35400000E-05  -3.07900000E-05  +1.90000000E-05
   +2.48000000E-06  +5.57000000E-06  -5.15900000E-05  +1.47800000E-05  +5.75810000E-04
   -1.26978000E-03  +2.05690000E-04  -3.61243000E-03  -1.81370000E-03  -3.82406000E-03
   +4.77300000E-05  -1.64100000E-05  +6.42900000E-05  -5.15390000E-04  -2.94200000E-05
   -1.67200000E-05  -1.43634000E-03  -2.82239200E-02  +7.47570000E-03  -6.80931400E-02
   -5.59104800E-02  +3.52653000E-03  +6.98294000E-03  +1.92513500E-02  -5.08322000E-03
   -1.74308000E-03  +2.37939000E-03  -3.79263000E-03  -1.48820000E-03  +1.91970000E-04
   -2.61010000E-04  +1.36030000E-04  +7.69520000E-04  +1.72917000E-03  +6.71389800E-02
   -9.67000000E-06  -2.26600000E-05  -9.21000000E-05  +2.82700000E-05  +1.79300000E-05
   +3.95000000E-05  -9.18000000E-06  +5.07700000E-05  -9.40000000E-07  +1.23040000E-04
   -7.69000000E-05  +4.95900000E-05  -6.12000000E-05  -2.66800000E-05  -1.16900000E-05
   +5.19000000E-06  -2.58700000E-05  +2.73500000E-05  +5.32000000E-06  -1.65000000E-06
   -5.03000000E-06  -9.56000000E-06  -2.10000000E-06  -7.20000000E-06  -1.51810000E-04
   +9.91700000E-05  -6.69800000E-05  -5.33000000E-06  +9.46000000E-06  -3.44000000E-06
   +7.37000000E-06  -2.31900000E-05  -1.16500000E-05  +2.56430000E-04  -5.44910000E-04
   +2.46800000E-04  -2.58818000E-03  +2.33326000E-03  +7.45410000E-04  -7.31700000E-05
   +8.60000000E-07  +5.81200000E-05  -2.08390000E-04  +4.90000000E-05  -5.52600000E-05
   -3.74470000E-04  -7.93143000E-03  +3.24334000E-03  -5.61055200E-02  -3.07064490E-01
   +6.51686600E-02  -1.01894800E-02  -1.48099500E-02  +1.87298000E-03  +2.89904000E-03
   -5.86500000E-05  +3.01122000E-03  +5.86940000E-04  +6.01590000E-04  -2.69120000E-04
   +3.59420000E-04  +4.73250000E-04  -1.48178000E-03  +6.30317000E-02  +3.25862330E-01
   -1.43500000E-05  +9.40000000E-06  +6.73900000E-05  +3.28500000E-05  -3.94500000E-05
   +2.12000000E-06  -1.56500000E-05  +2.59700000E-05  -1.95900000E-05  -5.00000000E-06
   -3.30400000E-05  +5.06000000E-06  +1.53100000E-05  -8.56000000E-06  -1.13400000E-05
   +5.87800000E-05  +4.38800000E-05  -9.38000000E-06  -5.39000000E-06  -2.00000000E-06
   +6.40000000E-07  -3.94000000E-06  -1.97000000E-06  +3.93000000E-06  -1.43600000E-05
   +3.82000000E-06  -1.48200000E-05  +1.37500000E-05  -9.70000000E-07  +1.77500000E-05
   +1.34200000E-05  +3.84500000E-05  -4.41000000E-06  +5.42200000E-05  -3.64220000E-04
   +3.61200000E-04  -3.87029000E-03  +8.45210000E-04  +5.69575000E-03  -3.28700000E-05
   +4.40400000E-05  +6.38000000E-06  -2.20000000E-06  +5.94800000E-05  -1.22970000E-04
   -1.45173000E-03  -8.42309000E-03  +4.71495000E-03  +3.55736000E-03  +6.54342700E-02
   -5.34719700E-02  +4.66879000E-03  +1.41969800E-02  +1.44451000E-03  -4.03985000E-03
   +2.67170000E-03  +2.93805000E-03  -4.11060000E-04  -4.72400000E-04  -9.58870000E-04
   +1.83232000E-03  -1.30221000E-03  -3.37045000E-03  -2.00118000E-03  -7.16997900E-02
   +4.58196000E-02  -1.26707000E-03  -4.38180000E-04  -1.58843000E-03  +2.57110000E-04
   +1.66530000E-04  +8.12640000E-04  -1.29720000E-04  +7.36480000E-04  +8.85000000E-06
   +1.75441000E-03  -1.01881000E-03  +6.89420000E-04  -9.96170000E-04  -4.31390000E-04
   -2.02940000E-04  +3.95390000E-04  -3.76530000E-04  +5.70310000E-04  -3.00000000E-08
   -5.90800000E-05  -3.26000000E-05  -1.31390000E-04  -3.24700000E-05  -1.04860000E-04
   -2.20480000E-03  +1.37663000E-03  -9.44090000E-04  -3.57000000E-06  +9.33100000E-05
   -4.91400000E-05  +1.32920000E-04  -8.77700000E-05  -1.67330000E-04  +5.96800000E-05
   +2.93260000E-04  +1.17406000E-03  -1.47084000E-03  -2.13217000E-03  +3.40000000E-05
   -4.66010000E-04  -5.51970000E-04  +2.01470000E-04  -4.86780000E-04  +2.62320000E-04
   -3.11600000E-04  +3.47405000E-03  +4.09643000E-03  -2.89487000E-03  -4.48880100E-02
   -1.67320700E-02  -1.71879600E-02  -2.69579380E-01  -4.36017000E-02  -8.14835800E-02
   -1.78604200E-02  -2.05870700E-02  -3.60883000E-03  +1.98724000E-03  +2.03080000E-03
   -2.11619000E-03  -1.41758000E-03  -5.15900000E-04  -3.34090000E-04  +2.44949000E-03
   +8.75160000E-04  +2.25462000E-03  +3.70664830E-01  -7.83290000E-04  -1.13020000E-04
   -7.37360000E-04  +2.05730000E-04  +1.76020000E-04  +3.74930000E-04  -8.91900000E-05
   +3.00750000E-04  +1.04000000E-06  +8.21350000E-04  -4.15590000E-04  +3.20370000E-04
   -5.40640000E-04  -1.72220000E-04  -1.30890000E-04  +2.26710000E-04  -3.31370000E-04
   +2.30210000E-04  +6.89000000E-06  -2.46700000E-05  -1.48700000E-05  -5.54000000E-05
   -1.07000000E-05  -5.65900000E-05  -9.56080000E-04  +6.09360000E-04  -4.10690000E-04
   -2.18300000E-05  +5.53200000E-05  -2.19800000E-05  +4.44000000E-05  -5.24200000E-05
   -5.72200000E-05  +1.42340000E-04  +3.35640000E-04  +1.42760000E-04  -2.09377000E-03
   +5.07359000E-03  -3.22370000E-03  -1.95120000E-04  -3.11650000E-04  +1.51490000E-04
   -2.12410000E-04  +2.47800000E-05  -1.14690000E-04  -3.61478000E-03  -7.48049000E-03
   +3.09540000E-03  +1.94013200E-02  +1.35026300E-02  +6.95564000E-03  -9.00573100E-02
   -1.25665370E-01  -1.11155100E-02  -5.64520200E-02  -2.35136800E-02  -1.35456700E-02
   +8.23690000E-03  -4.56176000E-03  +6.12823000E-03  +6.56770000E-04  +3.47720000E-04
   +2.09970000E-04  +1.62786000E-03  +2.56528000E-03  -1.45493000E-03  +1.37211420E-01
   +6.31377200E-01  -1.58630000E-04  -1.53520000E-04  -5.95340000E-04  -2.69500000E-05
   +2.83400000E-05  +2.06020000E-04  -7.92000000E-06  +1.36730000E-04  +2.96400000E-05
   +4.34510000E-04  -2.44210000E-04  +1.61790000E-04  -2.11370000E-04  -1.02220000E-04
   -2.37000000E-06  +5.26900000E-05  -5.25500000E-05  +1.38250000E-04  -1.47000000E-06
   -1.49000000E-05  -1.69400000E-05  -2.95000000E-05  -9.85000000E-06  -3.04600000E-05
   -5.59750000E-04  +3.53200000E-04  -2.30750000E-04  +1.90000000E-06  +2.15400000E-05
   -2.89000000E-05  +4.86400000E-05  -1.18800000E-05  -7.12600000E-05  +3.28580000E-04
   -1.15510000E-04  -8.25500000E-05  +4.65080000E-04  -2.97473000E-03  -2.80050000E-04
   -1.11980000E-04  -9.36800000E-05  +4.62300000E-05  -1.48010000E-04  +6.99400000E-05
   -7.86100000E-05  -3.20760000E-04  +6.50265000E-03  +4.98797000E-03  -2.92291200E-02
   -8.17281000E-03  +8.88000000E-06  -6.59122600E-02  +8.55379000E-03  -7.32018900E-02
   +7.35021000E-03  +9.38260000E-04  +1.01097500E-02  -3.79166000E-03  +3.84507000E-03
   +2.07055000E-03  -8.58710000E-04  -3.38120000E-04  -2.18380000E-04  +2.12915000E-03
   -1.72713000E-03  -2.41108000E-03  +1.00128900E-01  -1.38347970E-01  +1.13517610E-01
   -6.90700000E-05  +6.03800000E-05  -2.36610000E-04  +3.79400000E-05  +3.59000000E-06
   +5.19300000E-05  -7.50000000E-07  +3.33700000E-05  +1.02500000E-05  +7.48800000E-05
   -3.31600000E-05  +2.60200000E-05  -5.39200000E-05  -2.09700000E-05  -4.77000000E-06
   +1.75500000E-05  -4.08900000E-05  +5.25000000E-05  -3.64000000E-06  -5.35000000E-06
   -1.10500000E-05  -2.38000000E-06  -2.32000000E-06  -6.30000000E-06  -8.18100000E-05
   +4.99300000E-05  -3.04400000E-05  +1.20000000E-06  +3.11000000E-06  -5.73000000E-06
   +3.33000000E-06  -1.59000000E-06  -1.75500000E-05  -1.54490000E-04  +9.83290000E-04
   -7.98660000E-04  -2.21787000E-03  -4.00230000E-03  -2.56005000E-03  -4.19770000E-04
   -2.16740000E-04  +1.01610000E-04  +6.01000000E-06  +8.02200000E-05  +1.72200000E-05
   -3.25700000E-04  -7.10980000E-04  +4.95960000E-04  +1.08817000E-03  -2.28515000E-03
   -1.12524000E-03  +7.32079000E-03  -5.59304000E-03  +2.56099000E-03  -1.85315540E-01
   +1.09984230E-01  -9.54339600E-02  -1.37313600E-02  +1.79032300E-02  -1.20491800E-02
   -1.12260000E-04  +1.63850000E-04  +2.01740000E-04  +3.55200000E-04  -3.04490000E-04
   +3.06110000E-04  +4.58360000E-04  +9.72170000E-04  +1.31885000E-03  +1.93022730E-01
   -9.51400000E-05  +3.46700000E-05  +7.72200000E-05  +6.75500000E-05  +3.37500000E-05
   -4.23000000E-06  -1.92100000E-05  +1.07500000E-05  -1.64800000E-05  -1.40200000E-05
   +6.90000000E-07  -5.30000000E-07  -5.10000000E-06  +2.24000000E-06  -8.45000000E-06
   +4.19000000E-06  -4.43500000E-05  -1.98900000E-05  -1.66000000E-06  -5.10000000E-07
   +2.01000000E-06  +7.80000000E-07  +2.18000000E-06  -8.40000000E-07  +2.83900000E-05
   -1.62000000E-05  +1.07100000E-05  -4.18000000E-06  +7.40000000E-07  +2.99000000E-06
   -1.02100000E-05  -5.00000000E-06  +1.30300000E-05  -1.38010000E-04  +5.37390000E-04
   -2.94140000E-04  -3.64771000E-03  +5.06130000E-04  +7.37950000E-04  -1.03080000E-04
   -8.80300000E-05  +2.21000000E-06  +3.57300000E-05  +1.11000000E-05  +6.36000000E-06
   -1.18178000E-03  -7.18200000E-04  -5.74270000E-04  -2.77472000E-03  -4.79516000E-03
   +2.08183000E-03  +2.36801800E-02  -1.12399100E-02  +1.47392400E-02  +1.08312590E-01
   -1.55153440E-01  +8.12443000E-02  -9.37826000E-03  +1.11946000E-02  -6.55148000E-03
   +1.22350000E-04  -1.25100000E-05  -1.70320000E-04  +1.02880000E-03  -8.01750000E-04
   +6.90640000E-04  +6.24060000E-04  +1.87439000E-03  -1.38570000E-03  -1.17460600E-01
   +1.57797070E-01  -9.90500000E-05  -1.97200000E-05  +1.08690000E-04  +7.07300000E-05
   +3.54200000E-05  +1.26100000E-05  -2.17600000E-05  +3.23500000E-05  -2.48900000E-05
   +5.30100000E-05  -3.49600000E-05  +2.42700000E-05  -3.72600000E-05  -7.66000000E-06
   -1.84100000E-05  +2.64200000E-05  -4.60700000E-05  -2.33800000E-05  +1.23000000E-06
   -1.53000000E-06  +3.17000000E-06  -6.76000000E-06  +4.90000000E-07  -1.98000000E-06
   -5.41200000E-05  +3.47600000E-05  -2.45800000E-05  -8.50000000E-07  +3.28000000E-06
   +1.28000000E-06  +7.60000000E-07  -1.64000000E-06  +1.37300000E-05  -1.69600000E-05
   +4.37950000E-04  +8.09900000E-05  -3.16274000E-03  +5.14170000E-04  +6.16093000E-03
   +5.32100000E-05  -6.21000000E-05  +1.65100000E-05  -3.92800000E-05  -1.60100000E-05
   +6.27000000E-06  +5.61270000E-04  -3.81970000E-04  -6.21970000E-04  -9.13500000E-04
   +2.33217000E-03  +4.50343000E-03  -6.39045000E-03  +3.17240000E-03  +1.55036000E-03
   -9.50838700E-02  +8.14705000E-02  -9.96522100E-02  -3.43192000E-03  +4.68769000E-03
   -4.81970000E-04  +2.04970000E-04  -1.71110000E-04  -5.88930000E-04  -1.23710000E-04
   +9.80500000E-05  -1.69570000E-04  +1.31030000E-03  -1.33514000E-03  -2.51010000E-03
   +1.05200160E-01  -8.91513500E-02  +9.55699600E-02  -6.42600000E-04  +2.73570000E-04
   -4.39480000E-04  +7.24500000E-05  +2.47000000E-05  +1.19350000E-04  -4.09500000E-05
   +2.44200000E-05  -2.76700000E-05  -5.62800000E-05  +7.72000000E-06  -1.67500000E-05
   +1.30900000E-05  -5.43700000E-05  +7.15000000E-06  +4.79700000E-05  -2.58700000E-05
   +7.84300000E-05  -4.74400000E-05  -2.29600000E-05  +2.26000000E-05  +1.08700000E-05
   -7.30000000E-07  -2.24000000E-06  +5.72700000E-05  -4.68100000E-05  +2.59100000E-05
   +1.43900000E-05  -1.32700000E-05  +1.98000000E-06  +4.70000000E-07  -1.25900000E-05
   -2.84400000E-05  -1.15690000E-04  +3.90740000E-04  +1.45248000E-03  +9.75802000E-03
   +1.97739800E-02  -3.26290000E-03  +2.68790000E-04  -2.11140000E-04  -6.61600000E-05
   -2.35666000E-03  -2.42860000E-04  -1.61054000E-03  -2.10326000E-03  +2.18792000E-03
   -4.14094000E-03  -1.19963000E-03  +2.76850000E-04  -1.17990000E-04  -3.14891000E-03
   -1.89030000E-03  -4.08872000E-03  -1.82951000E-03  -2.84093300E-02  +6.13208000E-03
   -6.64001600E-02  -5.19350100E-02  +3.23927000E-03  +3.65960000E-04  +1.19771000E-03
   -2.17970000E-04  -3.64900000E-05  +4.92700000E-05  +2.58680000E-04  -2.81040000E-04
   -1.56424000E-03  +3.41980000E-04  +1.38010000E-04  +8.51750000E-04  +1.71360000E-03
   +7.10721500E-02  +7.14460000E-04  -4.66520000E-04  +8.08030000E-04  -1.57540000E-04
   +4.00000000E-07  -2.00120000E-04  +3.07700000E-05  -7.66400000E-05  +1.85100000E-05
   +2.45000000E-06  +3.37800000E-05  -3.25000000E-06  +2.33500000E-05  +6.02000000E-05
   -1.95500000E-05  -3.10000000E-05  +8.43800000E-05  -1.73660000E-04  +3.32100000E-05
   +1.85800000E-05  +6.90000000E-06  -1.13000000E-05  +5.99000000E-06  +4.12000000E-06
   +6.91000000E-06  +5.03000000E-06  -1.70000000E-06  -1.96200000E-05  +1.36500000E-05
   +5.59000000E-06  -1.26800000E-05  +6.34000000E-06  +5.45900000E-05  -7.47420000E-04
   -9.48130000E-04  -8.34650000E-04  -5.12489000E-03  -1.26354100E-02  +2.60099000E-03
   +3.61700000E-05  +5.66900000E-05  -1.19030000E-04  -2.05641000E-03  -2.49900000E-04
   -3.66710000E-04  +2.55753000E-03  -2.16620000E-04  +2.92023000E-03  +4.66010000E-04
   +6.24630000E-04  -3.40110000E-04  -2.09092000E-03  +2.24627000E-03  +8.51360000E-04
   -3.61690000E-04  -7.28376000E-03  +3.23688000E-03  -5.14444800E-02  -3.20675420E-01
   +6.16479600E-02  -3.25340000E-04  -7.43470000E-04  +1.24440000E-04  +5.28000000E-06
   -1.30380000E-04  -1.62890000E-04  -2.28800000E-04  -6.86580000E-04  +1.40450000E-04
   +3.05350000E-04  +5.06520000E-04  -1.36484000E-03  +6.09503600E-02  +3.40359500E-01
   +1.32734000E-03  -6.58990000E-04  +5.42030000E-04  -3.46260000E-04  -1.01140000E-04
   -2.51930000E-04  +3.84400000E-05  -1.78170000E-04  +4.15800000E-05  -1.40320000E-04
   +5.87400000E-05  -8.13900000E-05  +2.36280000E-04  +2.11200000E-05  +1.15310000E-04
   -8.95700000E-05  +4.16900000E-04  -1.67110000E-04  -1.01700000E-05  -2.32000000E-06
   +3.77800000E-05  -9.05000000E-06  +4.03000000E-06  +1.79000000E-05  +9.71000000E-05
   -6.81300000E-05  +4.14400000E-05  -2.50000000E-06  -5.51000000E-06  +7.35000000E-06
   -1.23400000E-05  -3.17700000E-05  -2.46300000E-05  +1.83613000E-03  -5.13500000E-05
   -1.94723000E-03  +3.31003000E-03  +1.37240400E-02  +1.04906000E-03  -2.16050000E-04
   -2.51320000E-04  -2.13150000E-04  -8.29110000E-04  -4.76600000E-05  +1.15770000E-04
   -4.17251000E-03  +3.04238000E-03  +3.52982000E-03  -3.06490000E-04  -4.10770000E-04
   -1.12688000E-03  -4.02172000E-03  +8.32060000E-04  +6.34402000E-03  -2.06132000E-03
   -7.95638000E-03  +5.43104000E-03  +3.16338000E-03  +6.07949000E-02  -5.48416300E-02
   +2.84620000E-04  +7.53270000E-04  -1.43020000E-04  +2.76880000E-04  -1.59040000E-04
   -5.37540000E-04  +1.28600000E-05  -3.23470000E-04  +2.10260000E-04  +1.87610000E-03
   -1.21146000E-03  -3.49757000E-03  +3.84220000E-04  -6.70372800E-02  +4.67395800E-02
   -4.09400000E-05  -3.55480000E-04  -1.39782000E-03  -7.81880000E-04  +3.52210000E-04
   -1.92660000E-04  +4.14180000E-04  -5.25620000E-04  +5.75060000E-04  -3.64900000E-05
   +1.71310000E-04  +2.44330000E-04  +1.03100000E-05  -5.18100000E-05  +1.14020000E-04
   -1.41610000E-04  +6.34940000E-04  -2.15480000E-04  +1.91200000E-05  +2.21000000E-06
   -3.49000000E-05  +3.21500000E-05  -1.91600000E-05  -2.04500000E-05  +1.78380000E-04
   -1.11120000E-04  +3.47200000E-05  +2.61900000E-05  -6.27000000E-06  +1.44000000E-06
   +3.64100000E-05  -2.03000000E-06  -5.16200000E-05  +6.52412000E-03  -2.22687000E-03
   -1.38786100E-02  +8.22810000E-04  -2.71760000E-04  -7.80190000E-04  -1.11498400E-01
   +2.03343000E-02  +1.10108630E-01  +3.26580000E-04  -5.26380000E-04  +1.91180000E-04
   +3.65180000E-04  +2.88930000E-04  +2.75470000E-04  -3.27050000E-04  -2.84400000E-05
   -3.40500000E-05  -3.85000000E-06  -3.73130000E-04  +1.00560000E-04  +2.43550000E-04
   +2.88480000E-04  -1.73000000E-06  -1.90410000E-04  +1.69940000E-04  +3.73080000E-04
   +7.58400000E-05  -1.29720000E-04  -5.56300000E-05  +9.86000000E-06  +1.52300000E-05
   -1.00000000E-05  +1.95130000E-04  +1.08980000E-04  +3.47000000E-05  +3.30500000E-05
   -2.50000000E-07  -1.23100000E-05  +4.15000000E-06  -8.34000000E-06  -5.63100000E-05
   +1.19893850E-01  -3.34300000E-04  -9.03430000E-04  +4.16100000E-04  +4.76630000E-04
   +3.84140000E-04  +2.17660000E-04  +2.10230000E-04  -2.89260000E-04  +1.57150000E-04
   +3.22650000E-04  +1.69260000E-04  -2.38100000E-05  -8.56460000E-04  +2.41630000E-04
   -6.89340000E-04  +7.14100000E-04  -2.89780000E-04  +5.88600000E-05  -3.06300000E-05
   +1.47000000E-06  +4.35700000E-05  -1.10100000E-05  +1.11100000E-05  -8.58000000E-06
   -2.86770000E-04  +1.54210000E-04  -9.39700000E-05  -3.03400000E-05  +2.78000000E-05
   +1.08600000E-05  +9.21000000E-06  +1.08900000E-05  -8.30000000E-07  -6.14381000E-03
   +9.33560000E-04  +1.25618800E-02  -6.10040000E-04  +1.13340000E-04  -5.38230000E-04
   +1.91451000E-02  -5.10982500E-02  -3.25833200E-02  -1.11990000E-04  +6.40910000E-04
   -4.53010000E-04  -1.31260000E-04  +5.26860000E-04  +2.05080000E-04  -1.60070000E-04
   -5.02300000E-05  +5.85400000E-05  +6.79300000E-05  +1.32700000E-05  -1.83700000E-05
   -4.42800000E-05  -6.53200000E-05  +2.66200000E-05  +1.29350000E-04  -2.31030000E-04
   -1.33200000E-04  +4.27310000E-04  -1.76430000E-04  -1.29220000E-04  -1.46400000E-05
   -6.61000000E-06  -6.22000000E-06  -2.04000000E-05  -3.59600000E-05  -5.52000000E-06
   -1.82300000E-05  +9.90000000E-07  +1.80600000E-05  +4.51200000E-05  -7.89000000E-06
   +4.08900000E-05  -2.34861800E-02  +5.20427900E-02  -1.10709000E-03  +4.79360000E-04
   +4.79830000E-04  -1.06385000E-03  -1.04360000E-04  +2.62990000E-04  +1.41710000E-04
   -5.22710000E-04  +3.82100000E-04  -4.58400000E-04  +4.02540000E-04  -4.69940000E-04
   +2.78410000E-04  +8.30600000E-05  +1.98860000E-04  -5.18800000E-05  +8.30780000E-04
   +2.71050000E-04  +5.54600000E-05  +4.98700000E-05  -5.86600000E-05  +8.09800000E-05
   -3.46000000E-06  +2.40000000E-06  +7.14910000E-04  -4.54780000E-04  +3.88570000E-04
   +3.07000000E-05  -5.47700000E-05  -1.82000000E-06  -1.42900000E-05  -5.50500000E-05
   -6.18700000E-05  +7.70081000E-03  -2.24688000E-03  -2.44637900E-02  +2.30708000E-03
   +1.04710000E-03  +1.46617000E-03  +1.14074380E-01  -3.54789600E-02  -2.29694310E-01
   +1.17350000E-04  -6.16450000E-04  +6.86420000E-04  -3.54700000E-05  -5.81990000E-04
   +1.81970000E-04  -2.75600000E-04  -1.13000000E-05  -5.28600000E-05  +5.84100000E-05
   -4.63830000E-04  +1.15410000E-04  +5.01530000E-04  +3.84700000E-04  +1.04800000E-05
   -1.07052000E-03  +4.67230000E-04  -2.00620000E-04  +1.01760000E-04  -1.53700000E-04
   -2.29560000E-04  +3.09000000E-06  -7.48000000E-06  -2.68500000E-05  -7.26500000E-05
   +1.01800000E-05  +3.90000000E-06  +2.05500000E-05  -4.90000000E-06  -4.48300000E-05
   -1.15000000E-05  -3.16600000E-05  -1.27200000E-05  -1.21130910E-01  +3.53048700E-02
   +2.53342280E-01  +1.39160000E-04  +2.34880000E-04  +9.45500000E-04  -3.20500000E-05
   -1.24770000E-04  +8.11400000E-05  -1.53830000E-04  +1.18630000E-04  -7.25700000E-05
   -4.95460000E-04  -3.96040000E-04  +2.44780000E-04  +1.53010000E-04  +2.77180000E-04
   +6.13410000E-04  +4.20000000E-06  -3.07090000E-04  +4.17440000E-04  +8.14000000E-06
   +2.76900000E-05  -7.31100000E-05  +4.74400000E-05  +1.29500000E-05  -2.03600000E-05
   -3.80900000E-05  +1.17150000E-04  -1.15350000E-04  +2.69500000E-05  +1.68200000E-05
   +4.24300000E-05  -2.95700000E-05  -4.44400000E-05  -1.38390000E-04  -6.58660000E-04
   +1.47788500E-02  +4.18707000E-03  +4.59430000E-04  -3.37200000E-04  +4.00430000E-04
   -5.08342000E-02  +2.88073200E-02  +1.26970000E-03  -1.33844000E-03  +1.47010000E-04
   -2.42780000E-03  -1.32398000E-03  +4.48530000E-04  -6.29690000E-04  -1.29960000E-04
   -2.57590000E-04  +3.46100000E-05  +4.71700000E-05  -1.87830000E-04  +8.53100000E-05
   +2.30480000E-04  +1.32200000E-05  +7.25000000E-05  -6.84700000E-05  -8.97500000E-05
   -4.18000000E-06  -1.95605000E-03  -1.05258000E-03  -8.60450000E-04  -8.41000000E-06
   +1.04900000E-05  -2.65500000E-05  +8.35200000E-05  -3.67000000E-06  +4.42400000E-05
   +1.49000000E-05  +4.40000000E-07  +5.40000000E-07  +8.97600000E-05  -5.78200000E-05
   +7.14600000E-05  -2.17849000E-03  +1.67347700E-02  +1.93609000E-03  +5.24262600E-02
   +3.57900000E-05  -9.32320000E-04  -5.49140000E-04  +1.68170000E-04  +1.62950000E-04
   +2.00150000E-04  -2.08700000E-05  -1.97120000E-04  +2.94340000E-04  +6.41000000E-04
   +1.32730000E-04  -2.79010000E-04  -6.75230000E-04  +2.21880000E-04  -1.55590000E-03
   +8.95880000E-04  -5.66200000E-05  -5.87240000E-04  +6.13400000E-05  +4.29000000E-05
   -6.85700000E-05  +1.52300000E-05  +8.80000000E-07  -2.02800000E-05  -4.17720000E-04
   +2.00350000E-04  -1.16000000E-04  -3.87500000E-05  -4.97900000E-05  -3.41500000E-05
   +9.55000000E-06  -1.52000000E-05  -1.58800000E-05  +8.94440000E-04  -1.36427700E-02
   -2.91190000E-04  -9.44850000E-04  -3.80150000E-04  +3.43910000E-04  +2.82715000E-02
   -3.10083770E-01  -3.41880500E-02  +1.71696000E-03  -3.24580000E-04  +2.58473000E-03
   -1.31723000E-03  -1.02038000E-03  -3.91790000E-04  -8.40500000E-05  +5.83090000E-04
   -3.11020000E-04  -1.34430000E-04  -3.64600000E-05  -2.08900000E-05  -1.16770000E-04
   -1.42700000E-05  -6.66600000E-05  +2.47110000E-04  -1.87000000E-06  +1.24070000E-04
   -1.23384000E-03  +9.82760000E-04  -6.21610000E-04  +2.44800000E-05  -1.95300000E-05
   -8.06000000E-06  -4.33800000E-05  +7.96100000E-05  -1.46400000E-05  +1.19600000E-05
   +4.47000000E-06  -8.20000000E-07  -9.45200000E-05  +2.85400000E-05  -6.70500000E-05
   -1.27990000E-04  -3.65741000E-03  -4.91390000E-04  -3.04003400E-02  +3.39478990E-01
   -1.08621000E-03  +2.75820000E-04  +7.30480000E-04  +6.27730000E-04  -1.11100000E-05
   +1.35760000E-04  -2.39920000E-04  +3.03170000E-04  -1.46390000E-04  +7.95770000E-04
   -3.43430000E-04  -3.20800000E-05  +6.00740000E-04  -6.27760000E-04  -8.88230000E-04
   -9.31400000E-05  +3.37400000E-05  -1.47196000E-03  -5.89500000E-05  -2.82400000E-05
   +5.96800000E-05  -4.17600000E-05  -1.91700000E-05  +1.76300000E-05  -3.07930000E-04
   +1.32700000E-04  -1.80380000E-04  +5.76000000E-06  -1.88600000E-05  +4.77000000E-06
   +4.26800000E-05  -1.47100000E-05  -5.59800000E-05  +7.53230000E-04  +2.62666800E-02
   +4.45413000E-03  +1.32230000E-04  -6.64200000E-04  +4.44690000E-04  +1.83256000E-03
   -3.65378400E-02  -5.01346900E-02  -2.38914000E-03  +1.78912000E-03  -4.28558000E-03
   -2.53010000E-04  -4.97310000E-04  -1.77640000E-04  -1.38320000E-04  -2.58000000E-06
   -1.06740000E-04  -4.25500000E-05  -1.59040000E-04  +1.00670000E-04  +8.76200000E-05
   +5.80100000E-05  +2.49000000E-06  +5.66900000E-05  +6.75900000E-05  -7.78800000E-05
   -1.02325000E-03  -1.55690000E-04  +3.91060000E-04  +2.84000000E-06  -2.67000000E-06
   -8.45000000E-06  +1.02720000E-04  +6.82000000E-05  +1.21700000E-05  +6.06000000E-06
   +9.02000000E-06  +1.50000000E-07  +7.81300000E-05  -5.34000000E-06  +4.33000000E-05
   +1.68809000E-03  -2.74234400E-02  -3.51818000E-03  -1.42141000E-03  +3.82305700E-02
   +5.57799200E-02  -4.94850000E-04  -4.05430000E-04  +3.93000000E-04  -1.99320000E-04
   +3.89880000E-04  +2.58650000E-04  +9.75000000E-06  -4.34050000E-04  +1.18593000E-03
   -3.06700000E-04  +5.27670000E-04  +3.96600000E-04  -8.08100000E-05  +3.72700000E-05
   -1.95210000E-04  +7.19000000E-05  +1.47330000E-04  -1.02350000E-04  +1.48500000E-05
   +3.15300000E-05  -5.75900000E-05  +3.26000000E-06  -5.27700000E-05  +2.38000000E-06
   +2.84880000E-04  -2.15720000E-04  +4.34400000E-05  -1.30000000E-06  -8.58000000E-06
   +5.98000000E-06  +7.19000000E-06  +3.10700000E-05  +7.54000000E-06  -1.48843700E-02
   -6.21010000E-03  -2.13290000E-03  -8.31670000E-04  +2.22327000E-03  -2.16789000E-03
   -2.69957360E-01  -9.90411800E-02  -2.60660300E-02  +2.80970000E-04  -1.34791000E-03
   +6.15410000E-04  +3.62670000E-04  +6.29190000E-04  +6.92700000E-05  +2.24200000E-05
   -4.34600000E-05  -7.10000000E-07  +2.45800000E-04  +2.32470000E-04  +7.86000000E-06
   -3.30400000E-04  +9.32600000E-05  -5.88500000E-05  -1.66160000E-04  -8.80750000E-04
   -1.29330000E-04  -3.40600000E-05  +2.85700000E-05  +8.77000000E-05  -3.39200000E-05
   -2.57800000E-05  -4.00000000E-08  -2.54930000E-04  -1.30270000E-04  -6.28300000E-05
   -9.66400000E-05  -2.50100000E-05  +1.43900000E-05  -9.62000000E-06  +7.58900000E-05
   -5.94600000E-05  -1.38710600E-02  -6.44358000E-03  -1.92289000E-03  +4.83093000E-03
   +1.99974000E-03  +5.14240000E-04  +2.94276730E-01  +1.45970000E-04  -5.23600000E-05
   -6.82750000E-04  -5.04700000E-04  +2.25000000E-04  -6.38400000E-05  +2.33850000E-04
   +9.13300000E-05  +3.88450000E-04  -3.19780000E-04  -1.60790000E-04  -9.20000000E-05
   +1.10240000E-04  -7.98600000E-05  -6.14300000E-05  +2.86700000E-05  +1.77750000E-04
   -2.39380000E-04  -3.41600000E-05  -5.37700000E-05  +8.23700000E-05  +2.34200000E-05
   +6.32000000E-06  -5.19400000E-05  +3.19910000E-04  -1.67900000E-04  +2.33690000E-04
   -1.53400000E-05  +3.89200000E-05  +3.52800000E-05  +1.84000000E-06  +1.44200000E-05
   +1.09250000E-04  +1.26097900E-02  +4.76428000E-03  +1.23829000E-03  +8.31930000E-04
   -1.37248000E-03  +2.74994000E-03  -1.00393750E-01  -9.24091100E-02  -1.15365300E-02
   +1.98134000E-03  +6.40890000E-04  +2.71880000E-04  -2.11880000E-04  -9.26020000E-04
   -6.25700000E-05  -1.64700000E-05  +3.36090000E-04  -1.61620000E-04  -1.34800000E-04
   -1.19350000E-04  +2.20900000E-05  +1.85820000E-04  -5.06000000E-06  -1.22620000E-04
   +4.81380000E-04  +5.17620000E-04  +2.20210000E-04  +1.26430000E-04  +6.51170000E-04
   -8.44900000E-05  +9.51000000E-06  -1.11200000E-05  +1.07000000E-06  +2.68100000E-05
   +8.32200000E-05  -1.49400000E-05  +5.41300000E-05  +1.64300000E-05  -4.76000000E-06
   -2.44300000E-05  +7.92100000E-05  +5.58700000E-05  +5.69715000E-03  +1.64391000E-03
   +7.41340000E-04  -2.93084800E-02  -1.12676000E-02  -2.12111000E-03  +1.07788190E-01
   +9.81171600E-02  -8.10650000E-04  +3.90520000E-04  +5.87110000E-04  -3.20960000E-04
   +4.11300000E-04  -3.08680000E-04  +7.20300000E-04  -3.67520000E-04  +5.76900000E-05
   +5.97340000E-04  -3.33140000E-04  -6.15000000E-06  -3.31180000E-04  +6.66200000E-05
   -2.23540000E-04  +3.42830000E-04  -4.59300000E-04  -5.99100000E-05  +1.97100000E-05
   -6.23000000E-06  -4.61600000E-05  -8.75000000E-06  -1.62000000E-06  -2.30700000E-05
   -1.32870000E-04  +1.33510000E-04  -9.66700000E-05  -4.90000000E-07  +3.74600000E-05
   +2.83500000E-05  +2.67000000E-06  +5.14900000E-05  +8.68000000E-05  -2.42092900E-02
   -1.11496700E-02  -4.18572000E-03  -1.90353000E-03  +3.07420000E-03  -3.14225000E-03
   -2.30500700E-02  -9.82176000E-03  -4.74083300E-02  -3.77000000E-06  -1.24133000E-03
   +3.11700000E-04  -6.13800000E-05  +5.71190000E-04  +4.99700000E-05  -9.90800000E-05
   -6.93200000E-05  +2.72400000E-05  +8.40800000E-05  +2.98300000E-05  -2.67900000E-05
   -2.54490000E-04  +3.42790000E-04  -6.94600000E-05  -1.13136000E-03  -9.26470000E-04
   -2.73690000E-04  +3.48190000E-04  +3.51000000E-06  +1.18100000E-05  -3.56200000E-05
   -2.20700000E-05  +3.90000000E-07  -7.59900000E-05  -4.70900000E-05  -1.59100000E-05
   -1.17660000E-04  -4.27700000E-05  -1.45900000E-05  +2.14600000E-05  +1.91800000E-05
   -4.62400000E-05  +2.47428700E-02  +1.22665500E-02  +3.39124000E-03  -4.53667000E-03
   -1.84997000E-03  -1.34163000E-03  +2.93367100E-02  +8.72617000E-03  +5.19856900E-02
   +1.06670000E-04  -1.78240000E-04  -1.54314000E-03  -8.43100000E-05  -5.83000000E-05
   +2.25520000E-04  +1.86200000E-04  -1.34880000E-04  +8.91600000E-05  +1.09710000E-04
   +4.09900000E-05  +3.74400000E-05  +7.56400000E-05  +1.67350000E-04  -5.54100000E-05
   -8.58400000E-05  +1.59700000E-05  +8.69300000E-05  +4.69300000E-05  +3.08630000E-04
   -2.22230000E-04  -1.64300000E-05  -7.53000000E-06  +1.14600000E-05  -1.68000000E-05
   +3.56800000E-05  -1.43800000E-05  +7.03000000E-06  +8.58000000E-06  -3.35200000E-05
   +6.41000000E-06  +5.61200000E-05  +1.64000000E-06  +1.48476000E-03  +2.22690000E-04
   -1.63859000E-03  +2.85800000E-05  -9.90350000E-04  -1.08915000E-03  -1.16130000E-04
   +1.07430000E-04  +1.07400000E-05  -1.54491400E-01  +5.98484600E-02  +1.12181590E-01
   +1.08150000E-04  +3.76740000E-04  +9.12800000E-05  +9.07900000E-05  -4.24900000E-05
   +6.70800000E-05  -6.66500000E-05  +1.72000000E-04  -6.37800000E-05  -1.80330000E-04
   -1.34790000E-04  +2.26200000E-05  +3.14250000E-04  -1.57570000E-04  +1.99090000E-04
   +1.79400000E-05  -1.26500000E-05  -2.30100000E-05  +1.57000000E-05  +1.88300000E-05
   +8.58000000E-06  +1.33710000E-04  +4.35800000E-05  +2.25600000E-05  +1.14100000E-05
   -7.37000000E-06  -1.03100000E-05  -1.46380000E-04  -6.15600000E-05  -3.77520000E-04
   +3.33200000E-05  +2.87540000E-04  -1.96700000E-04  +5.13000000E-05  +1.33750000E-04
   -2.06950000E-04  +1.00300000E-05  -4.41100000E-05  +2.18480000E-04  +1.65990070E-01
   +9.57140000E-04  -3.61298000E-03  +5.68610000E-04  -1.52056000E-03  +2.14630000E-04
   +9.13600000E-05  +3.47800000E-04  -1.01790000E-03  +3.36150000E-04  -3.52730000E-04
   +9.71560000E-04  -2.89790000E-04  +4.94000000E-05  -6.30200000E-05  +1.51750000E-04
   +5.41760000E-04  +5.47090000E-04  -7.43400000E-04  +1.63870000E-04  +2.18970000E-04
   -1.42610000E-04  +6.20300000E-05  -5.83000000E-06  +1.11300000E-05  +7.83920000E-04
   -4.96540000E-04  +3.57730000E-04  -1.52500000E-05  -3.30400000E-05  +7.08500000E-05
   -4.25800000E-05  -6.18800000E-05  -4.15700000E-05  +1.80333500E-02  -1.70320600E-02
   -2.10957400E-02  +1.83309000E-03  +1.56863000E-03  +6.55520000E-04  -2.42210000E-04
   +8.87280000E-04  -5.99410000E-04  +6.34608700E-02  -7.85751600E-02  -6.50091300E-02
   -4.84000000E-04  -6.76590000E-04  +6.67740000E-04  +5.15620000E-04  +7.96300000E-05
   +1.00060000E-04  -1.83810000E-04  +2.68240000E-04  -1.67210000E-04  -2.14850000E-04
   -9.54400000E-05  +2.64400000E-05  -2.58780000E-04  +3.76600000E-04  -3.42200000E-04
   +1.26000000E-06  +6.10000000E-06  -5.63900000E-05  +5.77600000E-05  -9.12000000E-06
   -5.53600000E-05  +1.06100000E-05  -5.13000000E-06  +2.82400000E-05  +7.36000000E-06
   -8.92000000E-06  -1.97300000E-05  -1.89370000E-04  -5.61500000E-05  -3.31700000E-04
   -1.38200000E-05  -2.02570000E-04  +6.81280000E-04  -2.84220000E-04  -6.27200000E-05
   +1.88760000E-04  -5.80300000E-05  -1.23660000E-04  -7.45500000E-05  -6.73504900E-02
   +8.85795400E-02  -9.91440000E-04  +3.80890000E-04  -1.36150000E-04  -1.22700000E-04
   +4.44830000E-04  +1.17550000E-04  +1.45300000E-05  -2.73630000E-04  +6.51900000E-05
   +4.30000000E-07  +2.81580000E-04  -3.06200000E-05  -1.78700000E-04  +2.82900000E-05
   -2.66800000E-05  +5.28500000E-05  -1.68330000E-04  +6.69300000E-05  -1.67090000E-04
   -4.83400000E-05  -1.42700000E-05  +3.36300000E-05  -5.57000000E-06  -7.10000000E-07
   +2.15110000E-04  -1.74650000E-04  +9.10600000E-05  +5.97000000E-06  -1.83100000E-05
   -4.00000000E-06  +1.80000000E-06  -3.98700000E-05  -2.24600000E-05  -1.04083000E-03
   -1.55334000E-03  -8.69100000E-04  +8.23030000E-04  +3.96360000E-04  +8.33560000E-04
   +1.26400000E-05  -2.85970000E-04  +4.23400000E-05  +1.11775960E-01  -6.17682400E-02
   -1.60913930E-01  -3.72920000E-04  -4.51420000E-04  -4.69300000E-05  +2.30540000E-04
   +1.00310000E-04  +3.47100000E-05  +2.10700000E-05  +1.01910000E-04  -9.72700000E-05
   -2.33400000E-04  +1.33190000E-04  +7.93000000E-06  -1.17400000E-05  -2.91460000E-04
   +3.12180000E-04  +2.71000000E-06  +7.03900000E-05  +3.75000000E-06  -6.60000000E-07
   -5.01000000E-06  -1.05200000E-05  -8.38600000E-05  -1.00000000E-07  -2.48900000E-05
   -2.30900000E-05  -1.54000000E-05  -2.71000000E-06  -2.24600000E-05  +9.35900000E-05
   -7.52600000E-04  +2.12050000E-04  -2.03600000E-05  +4.73900000E-05  +9.54700000E-05
   -1.82050000E-04  +2.64000000E-06  -1.07700000E-05  +2.18700000E-05  +5.25300000E-05
   -1.23825460E-01  +7.05794900E-02  +1.72497800E-01  -1.68260000E-04  -2.61600000E-05
   -3.06640000E-04  -6.01630000E-04  +2.00650000E-04  +8.06840000E-04  +8.35200000E-05
   -6.72900000E-05  +8.33400000E-05  -1.28340000E-04  +1.57100000E-04  -1.32530000E-04
   +1.11260000E-04  +1.54770000E-04  -1.75300000E-05  -1.05510000E-04  -5.38600000E-05
   -5.11800000E-05  -2.97060000E-04  +7.15000000E-04  +5.58400000E-04  +8.50000000E-07
   -5.15000000E-06  +3.14600000E-05  +2.82850000E-04  -1.61370000E-04  +1.42000000E-04
   +3.77000000E-06  -1.10000000E-05  -1.59500000E-05  +4.44000000E-06  +2.15000000E-05
   +9.97000000E-06  -2.14755000E-03  +8.05900000E-05  -1.40230000E-04  +1.26880000E-04
   -6.96000000E-04  +1.36100000E-05  +5.09670000E-04  +1.43976000E-03  -2.48100000E-04
   -2.77002220E-01  -6.67457100E-02  -7.10597700E-02  +1.65480000E-04  +4.51510000E-04
   -3.30550000E-04  -1.99940000E-04  -1.24780000E-04  -1.73900000E-05  +2.16850000E-04
   -7.71000000E-06  +9.69700000E-05  +1.34830000E-04  -1.58600000E-04  +2.46300000E-05
   +1.90100000E-04  +1.63760000E-04  -5.21500000E-05  +3.53600000E-05  -9.22200000E-05
   +3.86200000E-05  -4.62600000E-05  -1.42200000E-05  +1.69600000E-05  -2.17000000E-04
   -1.18280000E-04  -5.14300000E-05  -1.39500000E-05  +5.97000000E-06  -6.66000000E-06
   +3.22300000E-05  -2.65490000E-04  +2.95900000E-04  -1.66550000E-04  -1.53440000E-04
   -1.06900000E-05  +4.15730000E-04  +2.67730000E-04  +5.03700000E-05  +6.06980000E-04
   +9.74200000E-05  +2.04960000E-04  -1.80958700E-02  -5.13236000E-03  -6.59159000E-03
   +3.00451740E-01  -6.23280000E-04  +8.01900000E-04  +6.33280000E-04  -5.20200000E-05
   +2.09710000E-04  -3.60020000E-04  +2.97880000E-04  -3.80450000E-04  +2.41580000E-04
   +1.63850000E-04  +2.45290000E-04  +7.11900000E-05  -2.02550000E-04  +1.42600000E-04
   -1.57670000E-04  +1.75000000E-05  -3.14100000E-04  +1.19840000E-04  +1.85230000E-04
   +1.18100000E-04  -2.92750000E-04  +2.17400000E-05  +5.84000000E-06  -1.90700000E-05
   +8.51600000E-05  -5.47900000E-05  +5.66700000E-05  +6.44000000E-06  -2.27000000E-06
   -2.83700000E-05  +1.10800000E-05  +3.59000000E-05  +2.95500000E-05  -3.14136100E-02
   -1.00042400E-02  -9.35068000E-03  +1.11811000E-03  -6.35798000E-03  +5.78150000E-04
   -1.75942000E-03  +8.98020000E-04  -8.27110000E-04  -6.29915700E-02  -6.42671300E-02
   -1.87482800E-02  -1.72244000E-03  -9.10600000E-05  -8.02220000E-04  -1.07040000E-04
   -4.13980000E-04  +2.83080000E-04  +2.46120000E-04  +1.76600000E-05  +2.95100000E-05
   -1.74930000E-04  +2.02320000E-04  -1.19830000E-04  +7.68960000E-04  -5.47620000E-04
   +7.51940000E-04  +2.74000000E-05  -6.15500000E-05  -5.33500000E-05  -1.64960000E-04
   -6.78700000E-05  -1.79300000E-05  -1.83640000E-04  -2.98100000E-05  -7.00700000E-05
   -4.64600000E-05  -1.30100000E-05  -1.88000000E-06  +8.11500000E-05  +4.13530000E-04
   -1.09170000E-04  +1.26660000E-04  +4.34800000E-05  +4.87800000E-05  +1.88450000E-04
   +4.74300000E-04  -2.15760000E-04  +9.64550000E-04  -6.50080000E-04  +6.44410000E-04
   +1.09179800E-02  +2.54673000E-03  +4.53104000E-03  +7.11655100E-02  +7.40097000E-02
   -6.58850000E-04  +4.52690000E-04  -2.59590000E-04  -2.58760000E-04  -6.72580000E-04
   -1.31490000E-04  +3.74580000E-04  -2.56990000E-04  +1.12220000E-04  +2.27330000E-04
   +3.30380000E-04  +7.06000000E-06  -2.51680000E-04  +1.02830000E-04  -1.41700000E-04
   +2.91560000E-04  -1.15220000E-04  +1.60110000E-04  +5.63880000E-04  -2.50400000E-05
   -9.07000000E-04  -1.18100000E-05  -2.78700000E-05  +5.64600000E-05  -4.24100000E-05
   +6.03600000E-05  -4.77500000E-05  +4.86000000E-06  +5.54000000E-06  +4.18000000E-06
   +5.44000000E-06  +6.05100000E-05  +1.72400000E-05  -1.57114000E-03  -3.65850000E-04
   -1.78586000E-03  -7.12800000E-05  +4.48830000E-04  +7.75720000E-04  +9.63060000E-04
   +1.02487000E-03  +2.22500000E-05  -7.06243300E-02  -1.97030800E-02  -6.83448700E-02
   -2.52630000E-04  -2.34900000E-05  +2.14640000E-04  +1.85150000E-04  -1.28830000E-04
   +9.35000000E-06  -1.01270000E-04  +1.03890000E-04  -8.39900000E-05  -2.27000000E-05
   -2.16800000E-04  +1.31230000E-04  -2.99180000E-04  +2.28660000E-04  -4.75000000E-05
   +1.33800000E-05  -1.41200000E-05  +6.92900000E-05  -5.00000000E-08  -1.92700000E-05
   -3.22900000E-05  +1.89200000E-05  -3.71100000E-05  +1.97400000E-05  -8.33000000E-06
   +4.59000000E-06  +2.17000000E-06  +3.61470000E-04  -2.53930000E-04  -8.85100000E-05
   +1.08020000E-04  +6.37400000E-05  -1.05300000E-04  +7.53900000E-05  +7.00000000E-08
   -1.20600000E-04  -9.96000000E-05  +5.08400000E-04  +3.24660000E-04  +2.05541400E-02
   +6.27016000E-03  +6.73648000E-03  +7.68913800E-02  +2.08297700E-02  +7.01662900E-02
   -3.78450000E-04  +9.19420000E-04  -1.67810000E-04  +4.39320000E-04  +4.56460000E-04
   -6.50100000E-05  -1.85560000E-04  +5.71400000E-05  -6.53400000E-05  -9.71000000E-05
   -1.83160000E-04  +2.99100000E-05  +7.46300000E-05  -8.81800000E-05  +1.11100000E-05
   -9.47300000E-05  -9.00700000E-05  +2.54000000E-06  -4.29860000E-04  -1.12480000E-04
   +6.54400000E-05  +4.78900000E-05  +7.13000000E-06  -4.86600000E-05  +8.59000000E-05
   -8.12000000E-05  +7.05500000E-05  +7.14000000E-06  -1.21800000E-05  -2.15000000E-06
   +2.83000000E-06  -3.76700000E-05  -2.25700000E-05  -5.57760000E-04  +1.61590000E-03
   +2.73650000E-03  -1.29800000E-04  +5.14200000E-05  -1.40630000E-04  -2.12190000E-04
   +5.10720000E-04  -1.65190000E-04  -5.69053000E-02  +1.84946800E-02  -4.59598700E-02
   +1.51500000E-05  +1.56170000E-04  -1.09880000E-04  +6.05100000E-05  +8.10000000E-05
   +4.45000000E-06  -2.14500000E-05  +5.33200000E-05  -7.19500000E-05  -1.05670000E-04
   -2.92100000E-05  -2.07800000E-05  -7.59050000E-04  -7.74850000E-04  +2.82490000E-04
   -5.79000000E-06  +4.24000000E-05  -1.45700000E-05  +1.14400000E-05  +1.56400000E-05
   +3.91000000E-06  +3.97200000E-05  +4.22100000E-05  +1.97900000E-05  -5.57000000E-06
   -1.28900000E-05  +1.60000000E-07  -3.23330000E-03  -1.62640000E-03  -3.80850000E-04
   -4.65800000E-05  +6.02000000E-05  -2.58340000E-04  +5.00190000E-04  +2.84630000E-04
   -2.11260000E-04  +5.76380000E-04  +1.96500000E-05  +1.79250000E-04  +4.11408000E-03
   -9.58124000E-03  +1.95080300E-02  -4.32554000E-03  +1.28893100E-02  -2.69626600E-02
   +6.16989000E-02  +4.59100000E-04  -1.06380000E-03  +3.23082000E-03  +3.39180000E-04
   +5.01800000E-05  -3.20280000E-04  -1.08940000E-04  +1.42200000E-04  -7.02000000E-05
   +2.18900000E-05  -4.08800000E-05  +8.53400000E-05  -1.77830000E-04  +1.52340000E-04
   -2.28070000E-04  +1.29150000E-04  -3.82570000E-04  -2.93210000E-04  +2.46790000E-04
   +3.21600000E-05  -2.20000000E-06  -3.90400000E-05  +1.92600000E-05  +1.10000000E-05
   -1.37100000E-05  +3.23300000E-05  -4.76300000E-05  -3.08200000E-05  +2.80600000E-05
   +2.82700000E-05  -1.43700000E-05  -3.68800000E-05  +2.35100000E-05  +9.54911000E-03
   -1.23080000E-02  +2.83503500E-02  +4.00220000E-04  +4.85190000E-04  -2.13720000E-04
   -1.01101000E-03  -6.48365000E-03  -1.48759000E-03  +1.92522300E-02  -9.18291200E-02
   +9.84045900E-02  +1.56800000E-05  -2.43910000E-04  -2.15210000E-04  +1.44370000E-04
   +1.05900000E-04  +2.49900000E-05  -6.94500000E-05  +1.36500000E-04  -2.43400000E-05
   -2.42650000E-04  +1.24760000E-04  -1.73100000E-04  +6.37300000E-05  -9.53900000E-05
   -1.10710000E-04  +6.82700000E-05  +1.51200000E-04  +4.69800000E-05  -6.63000000E-06
   +4.45000000E-06  +2.12700000E-05  +6.94400000E-05  +6.13700000E-05  +1.88000000E-06
   -9.66000000E-06  -1.32400000E-05  -4.38000000E-06  -1.47283000E-03  +8.55500000E-05
   -1.83540000E-04  -2.37760000E-04  +1.57750000E-04  -1.58600000E-05  +7.75910000E-04
   -7.89790000E-04  +1.61478000E-03  -4.19300000E-05  +1.64820000E-04  -2.39980000E-04
   -3.12549000E-03  +4.82495000E-03  -1.09962600E-02  -9.86160000E-04  +3.12021000E-03
   -8.24957000E-03  -2.25330600E-02  +1.02273660E-01  -8.07000000E-05  +7.66700000E-05
   -1.83320000E-04  +4.86570000E-04  +2.60110000E-04  -2.18490000E-04  -1.28410000E-04
   +1.14420000E-04  -2.44200000E-05  +2.60080000E-04  -8.13400000E-05  +1.46910000E-04
   -2.84110000E-04  +3.99900000E-05  -1.48150000E-04  -2.72070000E-04  -2.36860000E-04
   +1.49890000E-04  -4.98500000E-05  -2.33800000E-05  +9.84300000E-05  -1.95500000E-05
   +9.66000000E-06  -1.37300000E-05  -2.10980000E-04  +1.06310000E-04  -1.03410000E-04
   -2.63100000E-05  +2.25300000E-05  -3.38400000E-05  +1.12600000E-05  -2.73300000E-05
   +1.16700000E-05  +1.02619000E-03  +1.10485000E-03  +2.92220000E-03  -7.48530000E-04
   +2.03320000E-04  -2.50100000E-05  +5.60800000E-04  -3.39960000E-04  +3.96290000E-04
   -4.66797300E-02  +1.00270490E-01  -2.60415330E-01  +1.92660000E-04  +6.67500000E-05
   -1.21100000E-05  +2.15000000E-06  -8.77000000E-05  +2.67900000E-05  -1.51930000E-04
   +1.05620000E-04  -9.53800000E-05  +5.31300000E-05  -5.96810000E-04  +1.79910000E-04
   -9.86050000E-04  +4.98130000E-04  -5.48510000E-04  -1.78300000E-05  -6.51400000E-05
   +9.33000000E-06  +7.40000000E-06  -1.84000000E-06  +9.84000000E-06  +6.14200000E-05
   -6.14100000E-05  +4.82600000E-05  +1.41100000E-05  +2.21900000E-05  +6.70000000E-07
   -5.76710000E-04  -9.12310000E-04  +5.42280000E-04  +5.03800000E-05  -2.30660000E-04
   +5.33900000E-05  +7.59900000E-05  -1.95330000E-04  +1.17400000E-04  +1.50610000E-04
   -8.27100000E-05  +3.05300000E-05  -4.93520000E-03  +8.21311000E-03  -1.80871000E-02
   -4.49150000E-04  +2.33912000E-03  -6.39574000E-03  +5.18203300E-02  -1.08079370E-01
   +2.83308290E-01  +1.00500000E-05  +4.61000000E-05  +1.15500000E-05  -4.35300000E-05
   +1.78700000E-05  -4.43300000E-05  +3.36900000E-05  -9.43600000E-05  +1.74900000E-05
   -1.50650000E-04  +1.41990000E-04  -6.58600000E-05  +2.98100000E-05  +5.28800000E-05
   -9.45000000E-06  -1.40300000E-05  -3.89000000E-05  -4.62800000E-05  -9.70000000E-07
   +6.43000000E-06  +4.03000000E-06  +1.74500000E-05  +4.67000000E-06  +9.94000000E-06
   +2.11080000E-04  -1.23230000E-04  +8.74500000E-05  -1.64500000E-05  -1.19000000E-06
   +3.28000000E-06  -1.67700000E-05  +1.54400000E-05  +4.57100000E-05  -1.69450000E-04
   +9.56100000E-05  -1.76900000E-05  +3.89300000E-05  +6.52870000E-04  -2.44000000E-04
   +8.14100000E-05  +5.55000000E-06  -9.46000000E-06  +7.59700000E-05  -8.29000000E-06
   +1.30300000E-05  -7.14360000E-04  -3.05700000E-04  +4.99600000E-05  +2.13845000E-03
   -1.22648000E-03  +1.70031000E-03  -9.77759000E-03  -4.59015200E-02  +1.19116400E-02
   -6.16623000E-03  -1.07577000E-03  -3.07139000E-03  +1.33392000E-03  -1.51280000E-03
   +2.22100000E-04  +1.43050000E-04  +3.34900000E-05  +5.50100000E-05  -6.93840000E-04
   +1.79451000E-03  -1.10838000E-03  -4.12825800E-02  -1.34024500E-02  -1.14404400E-02
   -4.19400000E-05  +6.93700000E-05  +1.88770000E-04  -3.83650000E-04  -6.81600000E-05
   -4.85600000E-05  -1.73100000E-05  -8.21000000E-06  -2.93000000E-06  -4.01600000E-05
   +3.26300000E-05  -1.86000000E-06  +3.05300000E-05  +2.70200000E-05  +7.37000000E-06
   -1.30500000E-05  -1.10600000E-05  +4.30000000E-06  +2.56500000E-05  +2.99000000E-05
   -1.10000000E-07  -1.07100000E-05  -4.84000000E-06  -1.64900000E-05  +5.54127200E-02
   +1.55350000E-04  +4.66900000E-05  +1.37790000E-04  -4.08100000E-05  -2.78900000E-05
   -9.22700000E-05  +1.52200000E-05  -9.01500000E-05  +3.70000000E-07  -2.04470000E-04
   +1.19340000E-04  -8.09400000E-05  +1.23020000E-04  +5.85900000E-05  +2.53000000E-05
   -4.41900000E-05  +4.99300000E-05  -6.45600000E-05  -1.32000000E-06  +5.51000000E-06
   +3.60000000E-06  +1.42100000E-05  +2.77000000E-06  +1.23000000E-05  +2.56500000E-04
   -1.66010000E-04  +1.10300000E-04  +6.78000000E-06  -1.39700000E-05  +7.04000000E-06
   -1.72600000E-05  +2.18200000E-05  +1.65800000E-05  -8.16200000E-05  -6.28600000E-05
   -1.08730000E-04  +4.89300000E-05  +5.15700000E-04  -3.51800000E-05  +3.99800000E-05
   +5.73500000E-05  -1.57400000E-05  +4.85200000E-05  -1.82000000E-05  +4.46400000E-05
   -9.66600000E-05  -1.17910000E-03  +1.21710000E-04  +4.94024000E-03  +5.01622000E-03
   +1.29200000E-04  -2.17571000E-03  -1.95864300E-02  +4.54147000E-03  -2.50196000E-03
   +2.11440000E-03  -1.03320000E-03  +1.91000000E-04  -7.99140000E-04  +8.77760000E-04
   +2.46830000E-04  +6.09000000E-05  +6.03500000E-05  -9.22250000E-04  -4.24470000E-04
   -5.20400000E-05  -6.06659500E-02  -4.92923000E-01  +1.33314100E-01  +1.63020000E-04
   +3.85610000E-04  -2.00180000E-04  -1.63780000E-04  -2.68700000E-05  -1.30640000E-04
   -2.06800000E-05  +4.70000000E-06  -2.00000000E-08  -7.32000000E-06  +1.64000000E-06
   -1.34200000E-05  +2.63600000E-05  -1.64000000E-06  +3.85000000E-06  -9.40000000E-06
   -1.03800000E-05  +5.55000000E-06  +2.49100000E-05  +2.35500000E-05  -6.00000000E-06
   -3.99000000E-06  -8.70000000E-06  -1.37500000E-05  +6.07543300E-02  +5.06846160E-01
   -1.17300000E-05  -2.47800000E-05  +3.70100000E-05  -7.49000000E-06  -9.44000000E-06
   -4.07000000E-06  -3.67000000E-06  -4.70000000E-06  -3.70000000E-06  -1.04000000E-06
   +1.64000000E-06  +9.60000000E-07  -2.07000000E-06  -2.23000000E-06  -1.67400000E-05
   +4.87200000E-05  +2.01500000E-05  -3.13200000E-05  -4.31000000E-06  -5.80000000E-07
   +5.79000000E-06  -1.86000000E-06  +1.10000000E-07  +3.43000000E-06  +2.60000000E-06
   -4.69000000E-06  -9.09000000E-06  +1.20000000E-06  +2.70000000E-07  +1.43400000E-05
   +9.20000000E-07  +7.62000000E-06  +3.43400000E-05  -8.46000000E-06  +7.19000000E-05
   -6.39000000E-06  -8.41000000E-05  +1.42050000E-04  -4.54800000E-05  +1.20000000E-07
   -2.92700000E-05  +5.40000000E-07  +3.69600000E-05  +1.77500000E-05  -4.82000000E-06
   +5.00000000E-06  +3.60300000E-05  -6.74560000E-04  -2.87020000E-04  -2.43069000E-03
   -2.33830000E-04  -2.40035000E-03  -1.38857600E-02  +7.82700000E-04  -2.70752000E-03
   -4.83190000E-04  +1.17508000E-03  -1.95020000E-04  +1.22270000E-04  +1.53081000E-03
   -2.69000000E-06  -1.50200000E-05  -3.06300000E-05  -2.25420000E-04  +1.07453000E-03
   +1.01180000E-04  +4.02427000E-03  +1.53277980E-01  -5.17317200E-02  +1.48140000E-04
   -2.42990000E-04  -3.96020000E-04  -3.22800000E-05  -8.81900000E-05  -1.84840000E-04
   +2.60000000E-07  -8.22000000E-06  -2.25400000E-05  -1.85800000E-05  +1.22300000E-05
   +1.20200000E-05  +4.20000000E-07  +1.93900000E-05  -8.80000000E-07  +2.42000000E-06
   -2.32200000E-05  -1.20500000E-05  +6.56000000E-06  +1.00700000E-05  -2.21000000E-06
   -5.73000000E-06  +2.91000000E-06  +7.30000000E-07  +1.74651000E-03  -1.37592200E-01
   +4.97195300E-02  +7.59910000E-04  +1.65950000E-04  -8.16390000E-04  -1.49874000E-03
   -2.09510000E-04  -8.29000000E-06  +5.30650000E-03  -2.37743000E-03  +2.36519000E-03
   -3.43213200E-02  -2.10712300E-02  -8.93008000E-03  -2.40769000E-03  +5.12560000E-03
   -1.86246000E-03  -2.88880000E-04  -1.56049000E-03  -4.14200000E-04  +2.53150000E-04
   -1.78440000E-04  +6.87500000E-05  -3.63100000E-05  +1.33555000E-03  -3.80000000E-04
   -3.32211360E-01  -2.06874210E-01  -9.34724600E-02  +2.21590000E-04  +1.32670000E-04
   +2.71630000E-04  -2.66620000E-04  +2.60880000E-04  -8.04300000E-05  -1.75150000E-04
   +1.55990000E-04  +5.08200000E-04  -1.92970000E-04  -2.07410000E-04  -1.66340000E-04
   +7.90000000E-05  -1.03490000E-04  -1.51400000E-05  +1.20220000E-04  +5.52600000E-05
   -9.76500000E-05  -2.72600000E-05  +2.80200000E-05  -5.10000000E-06  +1.11760000E-04
   -6.71500000E-05  +9.31000000E-05  -2.81350000E-04  -8.91000000E-05  -8.70200000E-05
   +3.44600000E-05  +1.05240000E-04  -1.90000000E-07  +1.08400000E-05  +1.59200000E-05
   -7.99000000E-06  -1.24100000E-05  -2.81800000E-05  -1.28600000E-05  +1.58400000E-05
   +2.51000000E-05  -2.80000000E-07  +3.52910000E-04  +1.53030000E-04  +9.31100000E-05
   +1.42400000E-05  -3.73000000E-06  +9.09000000E-06  -1.49100000E-05  -2.70000000E-07
   -1.49800000E-05  +3.05700000E-05  +2.04900000E-05  -8.17700000E-05  -5.13400000E-05
   -8.29000000E-06  +3.34000000E-06  -3.38100000E-05  +8.87100000E-05  +5.38500000E-05
   +2.22600000E-05  -8.73900000E-05  -3.82300000E-05  -2.52800000E-05  +2.01400000E-05
   +1.57400000E-05  -1.08500000E-05  -5.62000000E-06  +3.22600000E-05  -3.91600000E-05
   -3.96000000E-05  -3.75000000E-06  +3.64386680E-01  +2.48370000E-04  -1.93500000E-04
   -7.02250000E-04  -1.01740000E-04  -9.99260000E-04  +2.19320000E-04  +4.29808000E-03
   +2.59329000E-03  +8.69390000E-04  +2.44631600E-02  +1.24395200E-02  +7.22426000E-03
   +3.65562000E-03  -2.16984000E-03  +2.06775000E-03  -1.03610000E-04  +1.07844000E-03
   +2.17630000E-04  +6.00000000E-07  +2.84700000E-05  +3.35500000E-05  -1.54931000E-03
   -1.37420000E-03  -1.10220000E-04  -2.56400610E-01  -2.24222640E-01  -6.53884700E-02
   +2.34690000E-04  +1.56780000E-04  +7.41700000E-05  +1.70790000E-04  -1.26400000E-04
   +3.54500000E-05  +8.66000000E-06  +8.56000000E-06  +2.58660000E-04  -1.04870000E-04
   -5.00500000E-05  -8.07500000E-05  +9.41000000E-05  +7.94000000E-06  +2.23800000E-05
   +8.47700000E-05  +5.12700000E-05  -4.08700000E-05  -2.79600000E-05  +1.86600000E-05
   +1.72000000E-06  +2.34200000E-05  +3.38000000E-06  +3.15300000E-05  +1.18300000E-05
   +4.72100000E-05  -1.36400000E-05  -2.98000000E-05  -1.91800000E-05  +6.59000000E-06
   +4.64100000E-05  -1.05400000E-05  +2.82800000E-05  +1.37900000E-05  +8.23000000E-06
   -2.23200000E-05  -1.30000000E-07  -3.45000000E-06  -1.43000000E-06  -9.24000000E-06
   -9.41000000E-06  -2.91000000E-06  -6.00000000E-07  -2.50000000E-07  -1.85000000E-06
   +1.00400000E-05  -6.37000000E-06  -3.68000000E-06  -4.58700000E-05  +2.01900000E-05
   -2.40100000E-05  +2.20000000E-06  +1.30900000E-05  -1.16900000E-05  -1.21500000E-05
   -3.32500000E-05  -4.18900000E-05  -3.38500000E-05  -4.66500000E-05  +2.17000000E-06
   -2.57300000E-05  -3.19100000E-05  -2.87300000E-05  +9.64000000E-06  -7.89000000E-06
   +7.11000000E-06  +6.89000000E-06  +2.27000000E-06  +1.29000000E-06  +2.25309870E-01
   +2.12879630E-01  +2.01770000E-04  -1.52850000E-04  -9.55800000E-05  -1.03370000E-04
   -1.69000000E-06  -6.82790000E-04  +1.40635000E-03  -1.33055000E-03  -1.00050000E-04
   -1.48348500E-02  -9.72950000E-03  -6.68574000E-03  -1.94736000E-03  +2.40224000E-03
   +1.36534000E-03  -8.28120000E-04  -2.05870000E-04  +9.77860000E-04  +5.29800000E-05
   -5.94500000E-05  -1.51600000E-05  +1.56800000E-05  +8.90760000E-04  +4.25840000E-04
   -8.68671400E-02  -4.71862800E-02  -2.92341900E-02  +2.87410000E-04  +5.13300000E-05
   -3.60460000E-04  -2.09100000E-05  +6.90800000E-05  -2.20300000E-04  -1.73920000E-04
   +6.26800000E-05  +4.27820000E-04  -1.18440000E-04  -4.29800000E-05  -1.31360000E-04
   +1.61550000E-04  +3.27700000E-05  -1.15430000E-04  +8.33600000E-05  +2.79200000E-05
   -1.13330000E-04  +1.18400000E-05  -7.93000000E-06  -2.03500000E-05  +3.78600000E-05
   -1.75600000E-05  +2.21900000E-05  -8.35600000E-05  -1.81300000E-05  -2.00200000E-05
   -5.07000000E-06  +3.60100000E-05  -1.01100000E-05  +1.19500000E-05  -1.47700000E-05
   -8.44000000E-06  +8.80000000E-07  +5.67000000E-06  +9.72000000E-06  +4.55000000E-06
   +8.30000000E-06  +6.11000000E-06  +1.06450000E-04  +4.59700000E-05  +1.79500000E-05
   -1.80000000E-07  -1.30000000E-07  +5.86000000E-06  -3.63000000E-06  +3.52000000E-06
   -2.08000000E-06  -8.01000000E-06  +5.33000000E-06  -6.50700000E-05  +4.20000000E-06
   +5.31400000E-05  +7.08100000E-05  -2.00200000E-05  -1.14620000E-04  +5.52600000E-05
   +1.89100000E-05  -5.53300000E-05  -1.74400000E-05  -2.20600000E-05  -9.92000000E-06
   +3.05800000E-05  -2.54500000E-05  +2.00600000E-05  +5.31000000E-06  -1.11500000E-05
   -1.15900000E-05  +7.39000000E-06  +1.02576540E-01  +5.52554400E-02  +3.43857200E-02
   -1.29613190E-01  +3.99753600E-02  -9.38341500E-02  -4.24752200E-02  +2.13682600E-02
   -3.92311300E-02  -6.46740000E-04  -1.09762000E-02  +9.59900000E-05  -7.17720000E-04
   +1.30799000E-03  -6.54560000E-04  +6.72144000E-03  +9.50970000E-04  +5.26160000E-04
   -4.99666000E-03  +1.88140200E-02  -1.01571000E-02  +1.88182000E-03  +9.35330000E-04
   +2.05241000E-03  -1.84792000E-03  +1.02757000E-03  +3.17200000E-04  -7.95560000E-04
   +9.25240000E-04  -5.20490000E-04  -4.34010000E-04  +3.72590000E-04  +1.71200000E-05
   +1.33937000E-03  +3.07730000E-04  +1.71397000E-03  -7.19533000E-03  +3.81942000E-03
   +1.03859900E-02  -5.77335000E-03  -3.31545000E-03  +2.08117000E-03  +1.41727000E-03
   -3.59420000E-04  -1.51612000E-03  +1.30844000E-03  +1.67996000E-03  -1.37562000E-03
   +2.33547000E-03  +3.93287000E-03  +1.96600000E-04  -2.65565000E-03  -6.37020000E-04
   -1.00007000E-03  +9.89610000E-04  -3.24911000E-03  +1.04252000E-03  +3.64727000E-03
   +3.27940000E-03  +9.70490000E-04  -4.92795000E-03  -4.68130000E-04  +5.84612000E-03
   +3.98000000E-06  -3.32830000E-04  +4.00900000E-05  -5.97700000E-05  +4.39000000E-06
   -3.61600000E-05  +2.36850000E-04  +3.25430000E-04  +2.48500000E-05  +8.32900000E-05
   +5.69300000E-05  -1.00700000E-05  +4.35760000E-04  -1.07003000E-03  -1.14738000E-03
   -2.21210000E-04  +3.19880000E-04  -7.09060000E-04  -3.47940000E-04  -2.88900000E-05
   +1.69560000E-04  +1.00600000E-05  +1.53160000E-04  +3.09310000E-04  +3.63460000E-04
   -9.60110000E-04  +5.68300000E-04  +2.09250000E-04  +1.36800000E-04  +5.83860000E-04
   -3.54680000E-04  -1.16242000E-03  +1.19500000E-03  +1.03050000E-04  -1.68400000E-05
   +7.88000000E-06  +2.16470000E-04  -2.52280000E-04  +1.04360000E-04  +6.31447460E-01
   +1.91968100E-02  -1.24096800E-01  +6.88296400E-02  -5.99292000E-03  +1.40319400E-02
   -7.51202000E-03  -5.93310000E-04  -3.92752000E-03  +1.43347000E-03  +2.59125000E-03
   +4.32704000E-03  +8.48130000E-04  -1.03243800E-02  -6.27422000E-03  -1.85086000E-03
   +3.50136800E-02  -2.75323700E-02  +3.77325600E-02  +1.06257000E-03  +9.74430000E-04
   -1.00396000E-03  -5.42780000E-04  +3.45840000E-04  +1.60890000E-04  +6.67800000E-04
   -4.12420000E-04  +1.97710000E-04  +2.08428000E-03  -1.00169000E-03  -7.77380000E-04
   +4.67360000E-04  +2.99496000E-03  -1.68356000E-03  +2.85798000E-03  -2.74403000E-03
   -5.92380000E-04  +1.71856000E-03  +1.92840000E-03  +9.84880000E-04  -1.09268000E-03
   +8.18840000E-04  +1.19063000E-03  +4.08100000E-05  -1.73525000E-03  -2.29800000E-05
   -5.37870000E-04  -8.15120000E-04  -5.49500000E-05  +7.12080000E-04  +4.07440000E-04
   +1.85120000E-04  -4.26600000E-05  +7.32270000E-04  -1.62560000E-04  -7.95270000E-04
   -5.69980000E-04  -5.11060000E-04  +1.52481000E-03  -8.32190000E-04  -5.66410000E-04
   +5.28500000E-05  +1.43690000E-04  -1.00970000E-04  +2.26500000E-05  +2.39000000E-06
   -7.99000000E-06  -2.94850000E-04  -9.14100000E-05  -5.84500000E-05  -1.00200000E-04
   -3.91600000E-05  -2.63100000E-05  -3.90570000E-04  +7.80870000E-04  +2.91910000E-04
   +2.77220000E-04  -5.46600000E-05  +6.35090000E-04  +9.33700000E-05  +2.22650000E-04
   -2.50400000E-04  +1.58530000E-04  -1.34830000E-04  -1.00820000E-04  -4.19680000E-04
   +1.07244000E-03  -9.04220000E-04  -1.76280000E-04  +1.85500000E-05  -6.76110000E-04
   -2.22470000E-04  +1.74446000E-03  -2.10002000E-03  +1.44400000E-05  +2.21700000E-05
   -1.60800000E-05  -4.85100000E-05  -2.92800000E-05  -2.77500000E-05  +9.91798300E-02
   +2.22432000E-01  -8.30973900E-02  +9.13129900E-02  -1.12758480E-01  -5.63300000E-05
   +5.56101000E-03  -8.76510000E-03  -1.40865000E-03  +5.42990000E-03  -1.96830000E-04
   +4.35409000E-03  -1.90235000E-03  +1.94404000E-03  -6.67949000E-03  +5.78400000E-05
   -2.09932000E-03  -2.53480000E-03  -2.93814000E-03  -5.91934000E-03  +9.71570000E-04
   -2.07640000E-04  -2.23600000E-04  -2.16380000E-04  +1.94310000E-04  +1.85380000E-04
   -3.12361000E-03  +1.83561000E-03  -1.52738000E-03  -3.92570000E-04  +1.48610000E-04
   -1.43610000E-04  +1.24442000E-03  -1.89420000E-04  -2.92390000E-04  +6.73463000E-03
   +5.66274000E-03  -4.11171900E-02  -7.68446000E-03  -2.36489000E-03  -2.62916000E-03
   +4.32382000E-03  -2.16068000E-03  -3.67758000E-03  -1.88596000E-03  +1.77237000E-03
   +6.88900000E-04  +1.33419000E-03  +1.52793000E-03  -1.79960000E-04  -7.84670000E-04
   -1.79800000E-05  -3.34480000E-04  -1.97050000E-04  -5.62570000E-04  -7.03000000E-06
   +5.40420000E-04  +3.10360000E-04  +5.22440000E-04  +5.05760000E-04  +4.33300000E-05
   +5.81840000E-04  -1.87790000E-04  -1.81820000E-04  +1.18840000E-04  +7.33100000E-05
   +7.58600000E-05  -2.81800000E-05  +9.72710000E-04  +4.56110000E-04  +4.03050000E-04
   +2.58220000E-04  -3.18400000E-05  -5.28000000E-05  +5.55000000E-06  -3.04830000E-04
   -5.73140000E-04  -9.83950000E-04  +9.44260000E-04  -2.31134000E-03  -2.95320000E-04
   +1.13200000E-04  +1.15730000E-04  -9.96400000E-05  +5.80800000E-05  +1.45080000E-04
   +4.04230000E-04  +1.02450000E-04  +1.66600000E-04  +1.22060000E-04  -1.46530000E-04
   -6.01530000E-04  +1.99780000E-04  -5.71730000E-04  -1.62463000E-03  -4.69000000E-05
   -8.89300000E-05  -9.29600000E-05  +4.51320000E-04  +2.06800000E-04  +4.67500000E-05
   +7.45205000E-02  -1.32776890E-01  +2.07587880E-01  -2.86018300E-02  -6.50762000E-03
   -6.61303000E-03  -2.06696000E-03  +3.78021000E-03  -5.35500000E-04  +2.59070000E-04
   -1.51775000E-03  -4.23810000E-04  +2.60210000E-04  +7.11330000E-04  -7.17200000E-05
   -6.04090000E-04  -6.38360000E-04  -5.50620000E-04  +1.96860000E-03  -1.03463000E-03
   +2.66769000E-03  +8.70700000E-05  +1.32970000E-04  +2.81240000E-04  -8.07100000E-05
   +1.21790000E-04  -1.01070000E-04  +2.13870000E-04  -1.14280000E-04  +1.96810000E-04
   +2.51160000E-04  -1.45950000E-04  -9.28800000E-05  -8.33600000E-05  +9.26550000E-04
   -1.76700000E-05  -1.26694000E-03  -7.70710000E-04  +1.97996000E-03  +4.68769000E-03
   +6.33500000E-04  +2.08172000E-03  -6.97720000E-04  -5.70100000E-05  +6.14490000E-04
   -3.00720000E-04  -2.86190000E-04  -5.13400000E-05  -9.71930000E-04  -1.48344000E-03
   +6.81200000E-05  +1.29379000E-03  +3.38690000E-04  +4.89870000E-04  -9.60700000E-04
   +1.05542000E-03  -6.10990000E-04  -2.50987000E-03  -1.75633000E-03  -6.42740000E-04
   +9.41470000E-04  +1.07915000E-03  -1.98945000E-03  +1.76700000E-05  +2.06580000E-04
   -7.66200000E-05  +4.66100000E-05  +1.91000000E-05  -4.63800000E-05  +2.62020000E-04
   +6.36500000E-05  +8.30700000E-05  -3.44300000E-05  -6.17000000E-06  +1.29700000E-05
   -3.34870000E-04  +5.62400000E-04  +1.09172000E-03  +2.47100000E-04  -7.48600000E-05
   +3.51320000E-04  +1.56510000E-04  -2.47400000E-05  -3.46700000E-05  -5.83600000E-05
   -3.44300000E-05  -1.05540000E-04  -1.52300000E-05  +1.57030000E-04  +1.36510000E-04
   -6.65300000E-05  -2.80100000E-05  -1.37000000E-06  +1.95890000E-04  -2.40870000E-04
   -3.66750000E-04  -9.33400000E-05  -4.14000000E-05  -2.88800000E-05  -4.09900000E-05
   +4.83000000E-06  -1.33900000E-05  -4.49687410E-01  -1.46162450E-01  +1.26583500E-02
   +4.77587260E-01  +2.07421600E-02  +6.22333000E-03  -5.61350000E-04  +2.09257000E-03
   -9.30300000E-04  +2.60478000E-03  -4.96430000E-04  +1.34762000E-03  -1.67680000E-04
   -2.95540000E-04  -4.37610000E-04  -1.43160000E-04  -1.16380000E-04  -1.27420000E-04
   -1.57570000E-04  +2.04730000E-03  +7.83850000E-04  +5.87610000E-04  +2.08250000E-04
   +2.01960000E-04  +3.77200000E-05  +1.00780000E-04  -6.43400000E-05  -5.79000000E-06
   +1.73780000E-04  -2.13210000E-04  +1.52570000E-04  -7.21800000E-05  +1.13800000E-05
   +1.54540000E-04  -5.82930000E-04  -1.37661000E-03  +1.16890000E-04  +1.00508000E-03
   +5.26500000E-05  -1.55700000E-05  +5.33080000E-04  -1.34440000E-04  +1.67080000E-04
   -2.88580000E-04  +2.37000000E-05  +3.14010000E-04  +1.09330000E-04  -1.12430000E-04
   -3.93390000E-04  +8.46200000E-05  -3.45140000E-04  -9.60100000E-05  -3.41990000E-04
   -5.53240000E-04  -7.10100000E-05  -1.06280000E-04  -1.44340000E-04  +1.01350000E-04
   +5.30500000E-05  +2.09200000E-05  +3.31780000E-04  -5.62290000E-04  +1.14059000E-03
   -5.62060000E-04  +1.68000000E-05  -3.54900000E-05  +4.94400000E-05  -1.61800000E-05
   -6.94000000E-06  +2.83900000E-05  +1.38120000E-04  -3.26200000E-05  -2.28800000E-05
   +7.35300000E-05  +2.99100000E-05  +1.67200000E-05  +6.19700000E-04  -1.19954000E-03
   -7.15570000E-04  +1.01120000E-04  -7.34900000E-05  +1.57430000E-04  +5.32800000E-05
   -7.84600000E-05  +8.56100000E-05  -8.07000000E-06  +3.20000000E-07  +2.29200000E-05
   +6.45000000E-06  +3.33500000E-05  +3.10700000E-05  +7.56400000E-05  -3.95100000E-05
   +3.25300000E-04  -3.77970000E-04  -5.93470000E-04  -3.24460000E-04  -1.90400000E-05
   -1.65200000E-05  +4.30600000E-05  -3.83900000E-05  -2.28500000E-05  +1.66700000E-05
   -1.76044410E-01  -8.27094300E-02  +2.86324700E-02  +1.51132020E-01  +7.93778000E-02
   -3.33743600E-02  -1.20605200E-02  -3.79771000E-03  -2.90564000E-03  +4.25244000E-03
   -2.88266000E-03  -1.57643000E-03  -1.14135000E-03  -6.05600000E-05  -4.61520000E-04
   -1.94170000E-04  -1.60590000E-04  +8.70640000E-04  +2.84340000E-04  -1.08230000E-04
   -5.31000000E-06  +1.15487000E-03  +1.04210000E-04  +2.03430000E-04  -3.62700000E-05
   +2.56200000E-05  -4.15420000E-04  +2.82360000E-04  +5.03100000E-05  +5.81680000E-04
   -2.31860000E-04  +2.06900000E-04  -4.55200000E-05  +3.91400000E-05  +4.28200000E-05
   -1.05520000E-04  +1.78340000E-04  +6.01660000E-04  -1.34863000E-03  -2.92510000E-04
   -2.21500000E-04  -8.97430000E-04  -6.39540000E-04  -1.09592000E-03  +1.33890000E-04
   +2.02490000E-04  +1.09960000E-04  +4.31220000E-04  -3.51300000E-04  -3.89660000E-04
   +1.27849000E-03  +2.49048000E-03  +2.03610000E-04  -1.77599000E-03  -8.55000000E-05
   -8.06320000E-04  +1.39186000E-03  -1.25995000E-03  +8.96220000E-04  +1.06373000E-03
   +8.16800000E-04  -5.80000000E-06  +1.01428000E-03  -8.05650000E-04  +2.85840000E-04
   +5.22700000E-05  -1.48360000E-04  -5.33000000E-06  -1.16490000E-04  -7.02300000E-05
   +1.34700000E-05  -1.22493000E-03  -4.32090000E-04  -4.60810000E-04  -2.37720000E-04
   +8.28900000E-05  +6.54800000E-05  +4.22050000E-04  -3.16280000E-04  -3.16320000E-04
   +9.78000000E-06  -3.37200000E-05  +5.57900000E-05  -5.72600000E-05  -2.97300000E-05
   +5.09100000E-05  +9.59600000E-05  +1.36900000E-05  +1.43610000E-04  -1.85100000E-05
   -5.34900000E-05  -9.22000000E-06  +1.09540000E-04  +1.32600000E-04  +2.36280000E-04
   -2.35520000E-04  -3.39800000E-04  -1.28940000E-04  +1.06870000E-04  +1.27490000E-04
   +7.80400000E-05  -4.65100000E-05  -8.87800000E-05  +3.73800000E-05  +4.74224700E-02
   +3.92940700E-02  -2.73504900E-02  -1.03394400E-02  -3.07409100E-02  +3.45919700E-02
end_hess

