# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -807.45908300    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -2.94170563E+00  +1.20176537E+00  +2.71844724E-01
   006   -4.77877718E+00  +6.82927620E-01  +2.06629031E+00
   006   -6.72068380E+00  -1.02003273E+00  +1.58969101E+00
   006   -6.85618499E+00  -2.24345101E+00  -7.19459926E-01
   006   -5.03066940E+00  -1.75493877E+00  -2.54540807E+00
   006   -3.11514050E+00  -6.20494190E-02  -2.03752811E+00
   001   -4.73185255E+00  +1.59721916E+00  +3.89194094E+00
   001   -8.12505117E+00  -1.39118384E+00  +3.03443976E+00
   008   -8.70326229E+00  -3.92865704E+00  -1.30090515E+00
   001   -5.13293852E+00  -2.72625833E+00  -4.34023534E+00
   001   -1.69046493E+00  +2.68239542E-01  -3.46971691E+00
   006   -8.08955434E-01  +3.11269434E+00  +6.84489655E-01
   006   +1.72626720E+00  +1.85867922E+00  +7.17764335E-02
   006   -1.33433721E+00  +5.41140993E+00  -1.00913931E+00
   006   -6.81397155E-01  +4.05209380E+00  +3.42847568E+00
   006   +3.52270410E+00  +2.92133615E+00  -1.51258638E+00
   006   +5.83700226E+00  +1.75981578E+00  -1.96550093E+00
   006   +6.40906498E+00  -5.22551507E-01  -8.18107157E-01
   006   +4.60927840E+00  -1.57500211E+00  +7.59090309E-01
   006   +2.32266483E+00  -4.53424748E-01  +1.21091070E+00
   001   +3.14908223E+00  +4.69854844E+00  -2.44580977E+00
   001   +7.19275291E+00  +2.64284816E+00  -3.22305402E+00
   008   +8.62273214E+00  -1.77977462E+00  -1.16192514E+00
   001   +5.12050896E+00  -3.62950036E+00  +1.78148870E+00
   001   +9.62343221E-01  -1.37354924E+00  +2.43168400E+00
   001   +5.11302191E-02  +6.90717809E+00  -7.00579484E-01
   001   -1.32417836E+00  +4.90904728E+00  -3.00682078E+00
   001   -3.19532415E+00  +6.17229399E+00  -5.62455806E-01
   001   +9.18759481E-01  +5.33196782E+00  +3.63888935E+00
   001   -2.38939015E+00  +5.08403833E+00  +3.94661034E+00
   001   -4.24540917E-01  +2.50058080E+00  +4.75886666E+00
   001   +9.68796191E+00  -8.52543165E-01  -2.29079926E+00
   001   -9.82003921E+00  -4.11842160E+00  +1.08353060E-01
   008   +6.09375097E+00  -5.61486444E+00  +2.53028425E+00
   001   +7.67698078E+00  -5.49726063E+00  +1.62965856E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -1.00000000E-07  -5.60000000E-07  +1.40000000E-07
   -2.00000000E-08  -1.38000000E-06  +0.00000000E+00
   +2.90000000E-07  -1.63000000E-06  -4.80000000E-07
   +5.10000000E-07  -1.06000000E-06  -8.20000000E-07
   +5.10000000E-07  -1.80000000E-07  -6.90000000E-07
   +1.50000000E-07  +0.00000000E+00  -2.40000000E-07
   -2.30000000E-07  -1.90000000E-06  +2.10000000E-07
   +3.60000000E-07  -2.28000000E-06  -6.00000000E-07
   +8.60000000E-07  -1.22000000E-06  -1.27000000E-06
   +6.60000000E-07  +2.60000000E-07  -9.40000000E-07
   +9.00000000E-08  +6.70000000E-07  -1.00000000E-07
   -4.70000000E-07  -2.90000000E-07  +6.30000000E-07
   -1.50000000E-07  +3.40000000E-07  +3.30000000E-07
   -8.70000000E-07  +7.00000000E-08  +1.24000000E-06
   -6.50000000E-07  -1.00000000E-06  +9.10000000E-07
   -5.10000000E-07  +1.11000000E-06  +6.60000000E-07
   -1.00000000E-07  +1.66000000E-06  +2.50000000E-07
   +2.60000000E-07  +1.45000000E-06  -3.00000000E-07
   +4.10000000E-07  +7.30000000E-07  -4.10000000E-07
   +1.50000000E-07  +2.10000000E-07  -2.30000000E-07
   -8.20000000E-07  +1.32000000E-06  +1.14000000E-06
   -3.40000000E-07  +2.27000000E-06  +6.10000000E-07
   +5.00000000E-07  +2.03000000E-06  -5.70000000E-07
   +7.60000000E-07  +6.20000000E-07  -1.16000000E-06
   +3.80000000E-07  -4.00000000E-07  -5.60000000E-07
   -1.13000000E-06  +2.60000000E-07  +1.66000000E-06
   -7.70000000E-07  +6.00000000E-07  +1.11000000E-06
   -1.03000000E-06  -3.80000000E-07  +1.47000000E-06
   -9.00000000E-07  -7.40000000E-07  +1.25000000E-06
   -8.60000000E-07  -1.43000000E-06  +1.17000000E-06
   -3.70000000E-07  -1.27000000E-06  +4.90000000E-07
   +2.70000000E-07  +2.47000000E-06  -3.30000000E-07
   +9.10000000E-07  -1.82000000E-06  -1.34000000E-06
   +1.14000000E-06  +4.30000000E-07  -1.69000000E-06
   +1.11000000E-06  +1.03000000E-06  -1.54000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.01789470E-01  +1.83263270E-01  +3.85585450E-01  -1.21577060E-01  +1.15019260E-01
   +6.04794680E-01  -2.09605960E-01  -6.80768300E-02  +8.38480100E-02  +5.07926380E-01
   -4.25031300E-02  -1.03650960E-01  -9.40690000E-03  +2.26517230E-01  +3.95837850E-01
   +1.36543600E-01  +2.88462000E-02  -2.19509390E-01  -1.08407560E-01  +1.71394520E-01
   +6.65898820E-01  -3.76726500E-02  -1.45666100E-02  +3.98449700E-02  -2.22208530E-01
   -1.43633710E-01  -4.09280100E-02  +5.39804100E-01  -3.42408800E-02  +6.12151000E-03
   +5.03459400E-02  -1.17756520E-01  -1.80283510E-01  -6.34174700E-02  +2.47084730E-01
   +3.81864540E-01  -6.17100000E-04  +2.06776000E-02  +4.91381400E-02  +1.16990500E-02
   -2.39749700E-02  -1.26074410E-01  -1.40774880E-01  +1.43434190E-01  +6.42055830E-01
   -1.11176100E-02  +1.05563400E-02  +3.13733200E-02  +2.70516900E-02  +2.30571000E-03
   -3.35336600E-02  -1.14785900E-01  -4.23421300E-02  -1.52948500E-02  +5.43750270E-01
   +9.48984000E-03  -3.69609000E-03  -1.01020000E-02  -1.93683100E-02  -2.18876100E-02
   -1.89930300E-02  -1.17163900E-02  -1.34844870E-01  -1.17700280E-01  +2.30740540E-01
   +4.09278070E-01  +2.87234800E-02  -1.19598500E-02  -7.50097900E-02  -7.91575300E-02
   -5.26063300E-02  +1.51794100E-02  +4.78712500E-02  -6.94884100E-02  -2.87478070E-01
   -1.19483290E-01  +1.45875490E-01  +6.49869490E-01  +2.23234900E-02  -2.21116300E-02
   -6.98488300E-02  -5.26510100E-02  -2.76801700E-02  +1.86478100E-02  +3.16701700E-02
   +4.03706700E-02  +4.65562100E-02  -1.90302480E-01  -5.36700600E-02  +7.56440700E-02
   +5.23850460E-01  -3.27857000E-03  -1.80341600E-02  -4.89426200E-02  -2.85856700E-02
   -1.88319100E-02  +1.12294000E-02  +2.26931500E-02  +3.12033600E-02  +1.14043400E-02
   -2.36275400E-02  -9.97691400E-02  -2.11630100E-02  +2.48565710E-01  +4.10674330E-01
   -2.86973200E-02  -1.85898100E-02  +1.58467600E-02  +1.80215700E-02  +1.04683600E-02
   -9.13035000E-03  +1.01204600E-02  -1.59903000E-02  -4.02897700E-02  +1.35593300E-01
   +2.47759600E-02  -2.30960190E-01  -9.90292800E-02  +1.86740320E-01  +6.60320020E-01
   -1.10489320E-01  -1.57554100E-02  +3.08580500E-02  +3.12896500E-02  +2.31788700E-02
   +1.34823300E-02  -1.71277600E-02  -1.93195000E-02  -1.83521800E-02  -4.18732700E-02
   -1.43799700E-02  +3.85785400E-02  -2.36572550E-01  -1.55277890E-01  -4.53308600E-02
   +5.63780140E-01  -4.08958800E-02  -1.37605120E-01  -7.11961400E-02  +4.30686400E-02
   +3.16662100E-02  -1.80084800E-02  -2.13923400E-02  -3.28670700E-02  -2.74580600E-02
   -3.60488400E-02  +3.25745000E-03  +5.73849300E-02  -1.28945350E-01  -1.91849220E-01
   -6.99036600E-02  +2.43577910E-01  +3.95933860E-01  -2.23209700E-02  -1.10387880E-01
   -2.60733190E-01  +5.39897700E-02  +1.23480100E-02  -4.90076500E-02  -2.24212600E-02
   -3.08065900E-02  -3.19036000E-02  -6.05894000E-03  +2.40956400E-02  +6.03538700E-02
   +7.95900000E-03  -2.97585800E-02  -1.32997470E-01  -1.36305850E-01  +1.34888320E-01
   +6.20974390E-01  +6.27034000E-03  +1.02840100E-02  +1.83876100E-02  -5.21825000E-02
   -1.09390300E-02  -8.52790000E-04  +2.80032000E-03  -1.10043700E-02  -2.14877400E-02
   -6.59250000E-04  -5.72385000E-03  +1.08276000E-03  -1.29540000E-03  -6.43300000E-05
   -5.93000000E-06  -1.01563000E-03  -3.62713000E-03  +4.76560000E-03  +4.92331500E-02
   +6.23930000E-04  +7.05832000E-03  +4.52113000E-03  -1.08389800E-02  -1.03421800E-01
   -1.18494320E-01  +2.18840000E-04  -5.47459000E-03  -1.87701900E-02  -5.82620000E-03
   +2.41496000E-03  -1.49589000E-03  -2.46500000E-05  -8.64490000E-04  +7.86660000E-04
   -3.52188000E-03  +4.02551000E-03  -4.29080000E-04  +1.77879400E-02  +1.03407390E-01
   -2.05986000E-03  -1.08553500E-02  -1.48981700E-02  -2.45780000E-04  -1.18543360E-01
   -2.83932010E-01  +1.52840000E-03  -1.33488000E-03  -1.66616000E-03  +7.94310000E-04
   -1.63233000E-03  +2.87925000E-03  +1.42730000E-04  +8.77580000E-04  +3.63750000E-04
   +4.87837000E-03  -1.41190000E-04  -1.04907000E-03  +7.76930000E-04  +1.32033590E-01
   +2.99245090E-01  -1.16900000E-05  -5.63148000E-03  -8.58730000E-04  -1.20501500E-02
   -2.11217000E-03  +1.79015200E-02  -1.78675130E-01  -4.41095300E-02  +1.38612150E-01
   +1.63168000E-03  -3.16141000E-03  -2.37040000E-03  +2.98410000E-03  -1.95516000E-03
   +3.06500000E-04  -3.36330000E-04  +1.07830000E-04  -8.85760000E-04  -7.28200000E-04
   +2.03253000E-03  -1.20718000E-03  +1.86470020E-01  -5.21767000E-03  +1.27076000E-03
   -2.96015000E-03  -1.34200500E-02  -2.80590000E-04  +1.62690600E-02  -4.41112400E-02
   -5.33016200E-02  +2.65759400E-02  +8.78643000E-03  +5.82012000E-03  -1.06709600E-02
   -2.15524000E-03  +1.98700000E-03  -4.27150000E-03  -3.13000000E-06  -1.21613000E-03
   -3.87980000E-04  +2.22382000E-03  -1.90030000E-03  +1.20043000E-03  +5.12391500E-02
   +4.83657800E-02  -4.69220000E-04  -2.54462000E-03  +2.25275000E-03  -5.39874000E-03
   -1.52125000E-03  +7.44627000E-03  +1.38813440E-01  +2.65415000E-02  -1.96404680E-01
   +2.24134500E-02  +8.38145000E-03  -1.37513000E-02  -2.20820000E-04  -4.68769000E-03
   -3.58588000E-03  -1.22603000E-03  -6.31110000E-04  -4.36690000E-04  -8.21020000E-04
   +1.50077000E-03  +2.55520000E-04  -1.51647790E-01  -2.78065900E-02  +2.04183070E-01
   -1.29847000E-03  -1.80761000E-03  -5.21126000E-03  +1.03857000E-03  -3.45018000E-03
   +3.27146000E-03  -6.11266000E-03  -1.49224300E-02  -5.47797000E-03  -1.92206800E-01
   -1.32768860E-01  -4.17254700E-02  -3.80011800E-02  -3.52492800E-02  -1.49470000E-03
   +3.96113000E-03  +2.34333000E-03  +6.21588000E-03  -2.65880000E-04  -3.10070000E-04
   -2.02290000E-04  +1.20593000E-03  +3.55208000E-03  -1.21268000E-03  +4.42998720E-01
   -1.55096000E-03  -2.06029000E-03  -4.93380000E-04  -4.50010000E-04  +5.66779000E-03
   -3.89511000E-03  -2.94311800E-02  -1.84161300E-02  -1.20784600E-02  -1.14533930E-01
   -1.62590280E-01  -6.55337800E-02  -2.04492400E-02  -7.46786000E-03  +2.03464000E-03
   -3.92180000E-04  +3.64646000E-03  -1.79535000E-03  -7.57280000E-04  -6.96490000E-04
   -3.02550000E-04  +3.20341000E-03  -6.90300000E-04  +1.93078000E-03  +2.15287510E-01
   +2.11064430E-01  -3.27969000E-03  +1.03055000E-03  +5.64007000E-03  +9.67768000E-03
   +9.24900000E-04  -5.29269000E-03  -3.54966000E-02  -3.50076800E-02  -6.62952000E-03
   -2.48436000E-03  -3.55241400E-02  -1.14520750E-01  +2.81640200E-02  +2.47565900E-02
   +1.41415700E-02  +8.54540000E-04  -5.88536000E-03  -8.44130000E-03  -1.15488000E-03
   -1.03049000E-03  -3.00400000E-04  -1.77839000E-03  +1.49708000E-03  +1.79173000E-03
   -2.16781860E-01  +3.98941100E-02  +4.62229890E-01  -6.78870000E-04  -5.99049000E-03
   +1.06304000E-03  -1.42001000E-03  -2.75730000E-04  +1.11750000E-04  -1.31722000E-03
   -3.14341000E-03  +3.98640000E-03  +6.23067000E-03  +1.06971800E-02  +1.97325800E-02
   -5.30350500E-02  -1.57155600E-02  -5.54017000E-03  +3.40340000E-03  -1.03232600E-02
   -2.15417900E-02  -1.76920000E-04  +3.14700000E-04  -2.00540000E-04  +6.56200000E-05
   +5.95420000E-04  +1.04080000E-03  +2.50160000E-04  +1.89337000E-03  -1.69193000E-03
   +4.72086700E-02  -5.93353000E-03  +2.58049000E-03  -1.51469000E-03  -7.65000000E-05
   -6.84030000E-04  +6.66940000E-04  -2.95444000E-03  +3.04330000E-03  -1.51780000E-04
   -1.45245000E-03  +6.51818000E-03  +5.05709000E-03  -1.50811300E-02  -1.09505360E-01
   -1.25107300E-01  +9.34760000E-04  -5.38642000E-03  -1.80668700E-02  +3.31830000E-04
   -4.05780000E-04  +1.26060000E-04  +6.07800000E-05  +1.57900000E-04  +4.11140000E-04
   +2.11739000E-03  -1.30075000E-03  +8.74760000E-04  +1.95648600E-02  +1.07808700E-01
   +7.48860000E-04  -1.98158000E-03  +2.85086000E-03  +3.92840000E-04  +9.44390000E-04
   +3.64300000E-04  +4.44609000E-03  +1.91740000E-04  -1.06886000E-03  -4.37387000E-03
   -1.34790000E-02  -1.52872600E-02  -4.50142000E-03  -1.23947360E-01  -2.78026230E-01
   +1.15719000E-03  -7.25490000E-04  -3.41810000E-04  -1.75850000E-04  +1.57490000E-04
   -1.37700000E-04  -1.04430000E-04  -4.34960000E-04  -8.38180000E-04  -1.44995000E-03
   +1.05388000E-03  +1.01150000E-03  +5.39515000E-03  +1.36740410E-01  +2.91431760E-01
   +4.42377000E-03  -2.57050000E-04  -1.09847000E-03  +2.82933000E-03  -2.22912000E-03
   +3.34510000E-04  -3.38490000E-04  +1.34220000E-04  -9.24160000E-04  +9.78020000E-04
   -5.68601000E-03  -4.54960000E-04  -1.16062700E-02  -3.11769000E-03  +1.78294100E-02
   -1.87688180E-01  -3.89783700E-02  +1.39890080E-01  +1.73370000E-04  -5.52500000E-05
   -1.79100000E-04  -2.53360000E-04  +2.77100000E-04  -7.80200000E-05  -9.66990000E-04
   -2.45730000E-04  +9.68050000E-04  -7.83050000E-04  +2.21527000E-03  -1.36322000E-03
   +1.95128760E-01  +1.06409900E-02  +7.25587000E-03  -9.77776000E-03  -2.67837000E-03
   +2.13227000E-03  -4.41697000E-03  +1.63590000E-04  -1.05060000E-03  -1.47240000E-04
   -5.69174000E-03  +2.38284000E-03  -3.66881000E-03  -1.51751000E-02  +7.18340000E-04
   +1.52882600E-02  -3.82629200E-02  -5.62225600E-02  +2.44290800E-02  +5.92660000E-04
   +1.93250000E-04  -5.83200000E-04  +3.11280000E-04  -3.56030000E-04  +2.32600000E-04
   -7.87070000E-04  -1.67580000E-04  +9.02820000E-04  +2.53986000E-03  -2.24213000E-03
   +1.37439000E-03  +4.75801600E-02  +5.06098700E-02  +2.04951000E-02  +5.90695000E-03
   -1.42071800E-02  +1.32590000E-04  -4.93498000E-03  -3.70053000E-03  -1.08000000E-03
   -2.78670000E-04  -9.43500000E-05  -1.59300000E-04  -3.43314000E-03  +2.11670000E-03
   -5.39879000E-03  -2.37964000E-03  +7.70076000E-03  +1.39286890E-01  +2.53479400E-02
   -1.94593180E-01  +1.08505000E-03  +3.84840000E-04  -8.81920000E-04  -6.30900000E-05
   +2.62110000E-04  -1.00810000E-04  +2.33000000E-05  +1.42660000E-04  +2.85240000E-04
   -9.76360000E-04  +1.76003000E-03  +2.15900000E-05  -1.52756640E-01  -2.42027300E-02
   +2.03030050E-01  -1.28429370E-01  -4.82081700E-02  -2.91401000E-03  -1.52568700E-02
   -1.52637800E-02  -1.80770000E-03  +1.50651000E-03  -2.38369000E-03  +3.73449000E-03
   -2.26819000E-03  -5.74340000E-04  +1.10686000E-03  +4.26041000E-03  +6.72800000E-05
   +1.40675000E-03  -2.04888000E-03  -5.81420000E-03  -7.15804000E-03  -4.44630000E-04
   +1.80806000E-03  -1.96727000E-03  -7.97700000E-05  -5.14210000E-04  -1.88750000E-04
   +1.46968000E-03  +1.55111000E-03  -3.39100000E-05  +5.14120000E-04  +7.50900000E-05
   +3.39370000E-04  -1.09650000E-03  +1.45861000E-03  +4.48210000E-04  +4.73485990E-01
   -4.96350800E-02  -1.14750050E-01  -1.27759900E-02  -7.11740000E-03  -1.78734000E-03
   +2.63141000E-03  -1.62697000E-03  +4.66570000E-03  -2.03102000E-03  -6.29280000E-04
   -7.81540000E-04  +1.92810000E-04  -2.67210000E-04  +3.44242000E-03  -2.60683000E-03
   -1.24661700E-02  -1.20278200E-02  -6.44491000E-03  +2.19557000E-03  -2.32035000E-03
   -9.62400000E-05  +1.63500000E-04  +4.35930000E-04  -1.81320000E-04  +9.01910000E-04
   +1.49720000E-04  +3.08560000E-04  -3.31310000E-04  +1.28700000E-04  -1.24200000E-05
   +8.03690000E-04  -1.44942000E-03  +1.71867000E-03  +2.56370000E-04  +4.81190330E-01
   -6.34278000E-03  -1.53504500E-02  -8.95413400E-02  +1.23505500E-02  +1.35905700E-02
   +8.88813000E-03  +4.14834000E-03  -7.37090000E-04  -1.41403000E-03  +3.52870000E-04
   -5.26360000E-04  -2.04510000E-03  +1.41952000E-03  -3.77442000E-03  -4.33793000E-03
   -2.26139100E-02  -1.90119000E-02  -2.87040000E-04  -9.26310000E-04  +7.44830000E-04
   -1.07367000E-03  +9.89690000E-04  +6.09760000E-04  +2.84370000E-04  +5.23090000E-04
   +9.27890000E-04  +4.32120000E-04  -9.71090000E-04  -8.71430000E-04  -1.20170000E-04
   -8.28020000E-04  +8.22680000E-04  -2.55490000E-04  +7.05870000E-04  -5.15620000E-04
   +4.81332770E-01  -3.45792300E-02  +1.88214000E-03  +6.91115000E-03  -8.12340000E-04
   +2.58900000E-04  -2.07455000E-03  +8.23000000E-06  -1.05320000E-03  +3.41930000E-04
   -1.87290000E-04  -2.91700000E-05  +4.82960000E-04  +2.92650000E-04  +5.42060000E-04
   +7.38050000E-04  -7.04490000E-04  +6.07350000E-04  -2.73320000E-04  -2.53280000E-04
   +2.46510000E-04  -1.18500000E-04  +5.90700000E-05  -1.90190000E-04  +4.21600000E-05
   +3.66300000E-05  +8.28400000E-05  -3.24800000E-05  +9.46400000E-05  +2.18700000E-04
   -2.25900000E-05  -5.37850000E-04  -4.06240000E-04  -3.07920000E-04  -1.48338220E-01
   +3.68153500E-02  +1.93889800E-02  +5.59647270E-01  -1.64967000E-02  +1.10779300E-02
   +7.31253000E-03  -1.44933000E-03  -2.28834000E-03  -1.95129000E-03  -5.03540000E-04
   -1.44956000E-03  +2.59780000E-04  +2.26990000E-04  +8.57220000E-04  +9.78920000E-04
   +3.17940000E-04  +1.20600000E-05  +2.34000000E-06  -2.18131000E-03  -4.18930000E-04
   -4.17730000E-04  -1.18830000E-04  +5.09030000E-04  -5.12100000E-05  -2.45720000E-04
   -3.34000000E-04  +1.94700000E-05  -8.88810000E-04  -8.12530000E-04  -3.49930000E-04
   -3.07500000E-05  -8.14400000E-05  -5.16200000E-05  -4.75840000E-04  +3.70700000E-05
   -3.78870000E-04  +3.34241600E-02  -1.00020040E-01  +1.03212000E-03  -6.24554500E-02
   +5.30634100E-01  +1.35299000E-03  +2.28680000E-03  +4.06500000E-04  -9.42400000E-05
   -6.81100000E-05  -1.07790000E-04  -1.03140000E-04  -5.86800000E-05  -5.79000000E-06
   +9.50900000E-05  +1.98660000E-04  +4.85800000E-05  -2.31060000E-04  +2.36080000E-04
   +4.26500000E-05  -2.14796000E-03  -1.15860000E-03  -1.40210000E-04  -1.50790000E-04
   -1.76930000E-04  +9.20300000E-05  -1.58700000E-05  -4.20800000E-05  +3.50000000E-06
   -2.56200000E-04  -3.02920000E-04  -7.69000000E-06  -8.66000000E-06  -3.36500000E-05
   -3.72000000E-06  -6.43630000E-04  -2.26540000E-04  +1.44800000E-05  +2.18493800E-02
   -7.71590000E-04  -7.97923700E-02  -1.58203700E-01  -1.81076790E-01  +3.78097020E-01
   +1.92908000E-03  -2.06299900E-02  +1.48591800E-02  -6.99040000E-04  -1.53621000E-03
   -1.17603000E-03  -1.45601000E-03  +2.51730000E-04  -1.02450000E-03  +4.24560000E-04
   +6.73090000E-04  +8.61850000E-04  -1.27250000E-04  +4.87200000E-04  +2.82660000E-04
   -4.05150000E-04  -1.13742000E-03  +3.69430000E-04  +4.26190000E-04  -5.23850000E-04
   +4.27870000E-04  -2.34010000E-04  -9.78600000E-05  -1.08000000E-05  -1.08316000E-03
   -1.04631000E-03  -3.04380000E-04  +4.30000000E-06  -4.27500000E-05  -4.75600000E-05
   -1.34000000E-06  -8.67800000E-05  -3.78200000E-05  -7.86253600E-02  +1.12160700E-02
   -8.59047000E-03  -7.70923000E-03  +2.55921700E-02  -1.79872700E-02  +5.81206670E-01
   -5.75920000E-03  -2.87282600E-02  +1.35006800E-02  +1.62301000E-03  -7.02610000E-04
   -1.17353000E-03  -1.01236000E-03  +1.09510000E-04  -9.74870000E-04  +5.69600000E-05
   +4.32120000E-04  +7.24650000E-04  -8.53900000E-05  +7.42070000E-04  +3.44430000E-04
   +1.06500000E-04  -5.55830000E-04  +1.03503000E-03  +1.22350000E-04  -3.66500000E-04
   +1.59050000E-04  -1.03460000E-04  +5.15600000E-05  -4.21100000E-05  -4.36930000E-04
   -4.89840000E-04  -1.50210000E-04  +1.10860000E-04  -1.23100000E-05  +1.11200000E-05
   -1.37530000E-04  -4.54430000E-04  -8.77000000E-05  +1.67641600E-02  -1.36121590E-01
   +4.72420400E-02  +9.21265000E-03  -1.48932700E-02  +8.48642000E-03  +2.04148800E-02
   +5.04274860E-01  +4.78171000E-03  +2.14029000E-03  +3.00974000E-03  -2.66630000E-04
   -3.65130000E-04  -3.50370000E-04  -3.10290000E-04  -2.86670000E-04  -5.24270000E-04
   +7.45300000E-05  +2.41240000E-04  +7.74920000E-04  +3.67060000E-04  +2.82890000E-04
   -2.02520000E-04  -1.59422000E-03  -1.43643000E-03  -1.66180000E-04  -1.12030000E-04
   -2.97900000E-05  +4.91800000E-05  -1.10650000E-04  -4.32200000E-05  -2.96300000E-05
   -5.32470000E-04  -4.80550000E-04  -2.19160000E-04  -8.13000000E-05  -1.41800000E-05
   -5.15800000E-05  +1.44210000E-04  -5.27690000E-04  -2.51160000E-04  -1.11629600E-02
   +4.36378500E-02  -1.08959870E-01  -1.66341000E-03  -5.20698000E-03  +4.93599000E-03
   -1.55928200E-02  +5.71833600E-02  +5.51986190E-01  -1.45642000E-03  -8.90373000E-03
   -2.52505400E-02  -1.68206000E-03  -9.28320000E-04  -9.03100000E-04  +9.95500000E-05
   -1.74270000E-04  -8.34570000E-04  +3.44590000E-04  +2.51460000E-04  +1.91630000E-04
   +3.90530000E-04  -6.70770000E-04  -1.13042000E-03  -4.00346000E-03  -3.15402000E-03
   +6.43500000E-04  -4.61730000E-04  -1.45943000E-03  -1.04966000E-03  -4.55400000E-05
   +4.75600000E-05  +3.19300000E-05  -4.91240000E-04  -4.50640000E-04  -1.07020000E-04
   -3.02780000E-04  -2.37930000E-04  -9.49000000E-05  -4.93200000E-05  +1.82270000E-04
   -1.75540000E-04  -7.56176600E-02  -4.47450000E-04  -4.28510000E-04  -3.72757000E-03
   +1.06924900E-02  +2.97318100E-02  +1.48090000E-04  -8.46250000E-04  -6.77243000E-03
   +5.85503330E-01  -3.86000000E-03  -9.78619000E-03  -2.35529200E-02  -8.43120000E-04
   -1.39207000E-03  +9.65700000E-05  +5.21330000E-04  -2.03200000E-04  -7.75020000E-04
   -3.33600000E-05  +1.53880000E-04  -1.22540000E-04  +1.87270000E-04  -4.50410000E-04
   -9.75650000E-04  -3.73728000E-03  -1.63096000E-03  +4.78370000E-04  -6.04440000E-04
   -2.06700000E-05  -1.08037000E-03  +6.89600000E-05  +1.33800000E-05  +6.54200000E-05
   -1.51270000E-04  -1.63720000E-04  -4.65300000E-05  -1.65610000E-04  -2.49960000E-04
   -2.32900000E-05  +1.54480000E-04  +1.25900000E-05  -6.50000000E-06  -3.40355000E-03
   -8.53862300E-02  -3.08298300E-02  +5.29966000E-03  -7.51452000E-03  -1.67823000E-02
   +1.12906000E-03  +6.35214000E-03  +2.76916600E-02  -2.40582000E-03  +5.73096240E-01
   -5.73574000E-03  -5.15167000E-03  -5.57665000E-03  +9.46110000E-04  +6.31660000E-04
   +3.50130000E-04  +3.65330000E-04  +7.95500000E-05  -3.12280000E-04  -2.62720000E-04
   -1.87320000E-04  +1.24810000E-04  +4.25430000E-04  +1.63520000E-04  -1.30000000E-05
   +3.25440000E-04  +6.84980000E-04  +3.24530000E-04  +5.41720000E-04  +2.74280000E-04
   +2.74520000E-04  +6.71500000E-05  +8.77400000E-05  -1.04500000E-05  +3.14600000E-04
   +2.66010000E-04  +2.35400000E-05  +6.87800000E-05  +5.43400000E-05  +4.60000000E-05
   -3.64200000E-05  +9.64500000E-05  +3.16200000E-05  -6.62713000E-03  -2.82687100E-02
   -1.63084570E-01  +1.07904800E-02  -9.25168000E-03  -1.29633600E-02  -2.57979000E-03
   -7.23680000E-04  -3.26153500E-02  -7.68123000E-03  -4.44952300E-02  +4.79214870E-01
   -1.32561000E-03  +1.51574000E-03  +1.00534000E-03  -8.30550000E-04  -9.39770000E-04
   -1.15730000E-04  +1.80630000E-04  +1.11360000E-04  +3.49150000E-04  +1.90620000E-04
   +8.46100000E-05  -4.14020000E-04  -3.34500000E-04  -4.44640000E-04  +1.25580000E-04
   +7.20220000E-04  -2.07200000E-05  +3.92620000E-04  -2.61600000E-05  +1.14660000E-04
   -2.65200000E-05  -7.38700000E-05  -3.60400000E-05  -3.75000000E-06  -1.18620000E-04
   -8.24500000E-05  +5.00000000E-08  -3.74000000E-06  -2.86500000E-05  +5.41000000E-06
   -9.51900000E-05  +1.23800000E-04  -3.41460000E-04  -1.78032200E-02  -7.82249000E-03
   +1.49876200E-02  -2.15076380E-01  -1.60638400E-02  +8.68838600E-02  -1.86873000E-03
   -2.37700000E-04  +1.46123000E-03  -9.30890000E-04  -1.06053000E-03  -1.22608000E-03
   +5.93684280E-01  +1.44301000E-03  -1.90130000E-03  -1.38184000E-03  +4.73110000E-04
   +6.29520000E-04  +2.21670000E-04  +1.31000000E-06  +1.52290000E-04  -1.53150000E-04
   -2.09990000E-04  -1.20250000E-04  +3.44600000E-05  +1.54330000E-04  +1.86940000E-04
   -4.05000000E-05  -1.09880000E-04  +3.67600000E-05  +1.18630000E-04  +3.23000000E-06
   -1.25910000E-04  +3.25800000E-05  +8.03400000E-05  +4.16500000E-05  -5.00000000E-07
   +2.33470000E-04  +1.89420000E-04  +6.19500000E-05  +1.78600000E-05  +2.74200000E-05
   +1.58300000E-05  -4.81000000E-05  -7.21500000E-05  +6.80700000E-05  +7.66497000E-03
   +1.13716000E-02  -8.28269000E-03  -6.94567400E-02  -1.49196490E-01  +8.71185600E-02
   +9.27680000E-04  -7.03000000E-05  -7.64250000E-04  +1.97245000E-03  -1.06234000E-03
   -4.71120000E-04  -1.15618910E-01  +6.02600440E-01  -1.84705000E-03  -1.85510000E-04
   +4.22100000E-05  +3.65520000E-04  +3.69750000E-04  -4.75900000E-05  -2.22400000E-04
   -4.49840000E-04  -1.97780000E-04  -6.02800000E-05  +1.10190000E-04  +4.44360000E-04
   +2.39270000E-04  +3.92420000E-04  +1.21170000E-04  -7.25160000E-04  +2.40000000E-06
   -6.76780000E-04  -4.70800000E-05  +3.90200000E-05  +2.18700000E-05  -3.64000000E-06
   -3.26400000E-05  +2.13100000E-05  -1.72830000E-04  -1.69390000E-04  -4.21300000E-05
   -8.20000000E-06  +3.70900000E-05  -3.59300000E-05  -5.41600000E-05  -1.72340000E-04
   +3.30530000E-04  +6.60271000E-03  -6.33280000E-04  -5.92090000E-04  +1.20071460E-01
   +6.13556200E-02  -1.66300500E-01  -1.50040000E-04  -7.83760000E-04  -5.26220000E-04
   -1.39150000E-04  +3.26310000E-04  +2.01340000E-04  -1.60410780E-01  -2.32132090E-01
   +3.69555310E-01  -4.71520000E-04  +5.64800000E-04  +3.10910000E-04  +2.31090000E-04
   +2.49000000E-04  -2.56950000E-04  -1.11610000E-04  -2.42610000E-04  -1.99520000E-04
   +6.31200000E-05  +1.40310000E-04  +3.44930000E-04  +2.14180000E-04  +1.39200000E-04
   -1.49290000E-04  -3.71680000E-04  +1.19300000E-04  +1.10190000E-04  +3.38900000E-05
   +1.44200000E-05  -5.00000000E-08  -1.02000000E-06  -3.29800000E-05  +9.46000000E-06
   -1.66470000E-04  -1.43620000E-04  -9.09400000E-05  -1.74000000E-05  -1.04000000E-05
   -1.14300000E-05  -1.30620000E-04  -1.46840000E-04  -6.29600000E-05  +1.09280000E-03
   -1.53739000E-03  +3.26974000E-03  -4.32693200E-02  -3.22429000E-02  +4.54700600E-02
   +1.00620000E-04  -5.06650000E-04  +1.30000000E-05  -1.46920000E-03  +6.33200000E-04
   +1.86520000E-04  -2.78875790E-01  +1.22083310E-01  +3.61827500E-02  +6.22671400E-01
   +7.08520000E-04  -4.67480000E-04  -4.04390000E-04  -2.63550000E-04  -3.26920000E-04
   +3.34380000E-04  +2.02490000E-04  +4.07410000E-04  +2.59890000E-04  -6.46500000E-05
   -2.70860000E-04  -4.86610000E-04  -2.36490000E-04  -2.25410000E-04  +8.88600000E-05
   +5.40810000E-04  +1.07100000E-05  -3.26700000E-05  -1.37500000E-05  -3.81900000E-05
   +1.03300000E-05  +1.53600000E-05  +4.93400000E-05  -1.37800000E-05  +2.88260000E-04
   +2.89660000E-04  +1.12970000E-04  +3.39200000E-05  -2.76000000E-06  +3.23000000E-05
   +6.98600000E-05  +1.29860000E-04  -1.12070000E-04  -1.38380000E-04  +6.29200000E-04
   +3.09451000E-03  +8.93840000E-03  +5.38857700E-02  -3.36505000E-02  +7.31250000E-04
   -5.92890000E-04  -1.69430000E-04  +1.28570000E-04  -4.62710000E-04  +2.07060000E-04
   +6.75998900E-02  -1.51833070E-01  +2.26641600E-02  -9.43909500E-02  +5.56383400E-01
   +1.05553000E-03  -5.83670000E-04  -5.05190000E-04  +2.03430000E-04  +1.50360000E-04
   +2.12140000E-04  -3.74400000E-05  +4.82000000E-05  -6.02300000E-05  +3.99200000E-05
   +1.97000000E-06  -1.11300000E-05  -3.19400000E-05  +2.66200000E-05  +5.94200000E-05
   +1.37340000E-04  -3.91600000E-05  -3.08000000E-04  +1.67100000E-05  -5.12000000E-06
   +2.89000000E-06  +2.38000000E-06  +2.52800000E-05  +4.92000000E-06  -2.55100000E-05
   -2.86700000E-05  +2.17400000E-05  +1.42600000E-05  +1.83900000E-05  -5.76000000E-06
   +5.03600000E-05  +1.59900000E-05  +8.88500000E-05  +2.96206000E-03  +4.66658000E-03
   +2.66101000E-03  +1.97754900E-02  -1.36911000E-02  +4.34277000E-03  -6.58150000E-04
   +3.92090000E-04  +4.59000000E-06  -1.29013000E-03  +6.03330000E-04  +2.13290000E-04
   +6.98491400E-02  -4.53885000E-03  -9.22814000E-02  -1.97416980E-01  -2.25971860E-01
   +3.66857730E-01  -1.41600000E-04  -3.44740000E-04  -4.50600000E-05  +8.66500000E-05
   +2.02840000E-04  +5.72200000E-05  +1.21570000E-04  +1.11740000E-04  +8.98500000E-05
   -4.99270000E-04  -3.96920000E-04  -9.06900000E-05  +2.12970000E-04  -3.45100000E-05
   -2.28310000E-04  -5.69800000E-05  +8.44900000E-05  +1.95670000E-04  -4.15500000E-05
   -3.07300000E-05  +3.67000000E-06  +6.34100000E-05  +4.64600000E-05  -2.84100000E-05
   +5.82920000E-04  +4.80390000E-04  +1.14100000E-04  +7.88000000E-06  +3.27900000E-05
   +1.88200000E-05  -1.95720000E-04  -1.00450000E-04  -2.89700000E-04  -1.98196000E-03
   -4.76000000E-06  +1.88210000E-04  -2.68102000E-03  -2.26789900E-02  +1.47663400E-02
   +1.95120000E-04  +2.61810000E-04  -1.52820000E-04  +5.17910000E-04  -1.08560000E-04
   +5.30400000E-05  +1.39508100E-02  +2.86204000E-02  -2.41468600E-02  -1.25872330E-01
   +7.42772900E-02  -1.58661400E-02  +6.27054480E-01  -5.85570000E-04  +7.51300000E-04
   +4.59360000E-04  +2.28970000E-04  +3.02980000E-04  -2.68710000E-04  -1.99360000E-04
   -4.34110000E-04  -2.68660000E-04  +1.11930000E-04  +2.94140000E-04  +4.80430000E-04
   +2.16920000E-04  +1.86680000E-04  -6.51100000E-05  -4.09480000E-04  -1.65600000E-05
   -1.09650000E-04  +2.49900000E-05  +5.62100000E-05  -7.73000000E-06  -1.79700000E-05
   -5.21500000E-05  +1.78200000E-05  -3.35080000E-04  -3.07110000E-04  -1.26820000E-04
   -2.79100000E-05  -1.10000000E-07  -3.17000000E-05  -2.73100000E-05  -1.38050000E-04
   +3.86700000E-05  -7.01880000E-04  -1.31547000E-03  +1.07891000E-03  -1.97277100E-02
   -4.75343900E-02  +3.81020500E-02  -1.99060000E-04  -2.67500000E-05  -2.19600000E-05
   -9.48470000E-04  +6.87720000E-04  -1.53310000E-04  +7.56601900E-02  -2.28799300E-02
   -2.27520700E-02  +2.74467000E-03  -2.63484750E-01  +1.23745040E-01  -1.01086240E-01
   +5.62430150E-01  +4.20860000E-04  -1.36210000E-04  -2.12720000E-04  -3.13450000E-04
   -2.80940000E-04  +1.44560000E-04  +1.31620000E-04  +1.95150000E-04  +1.35260000E-04
   +1.54870000E-04  +3.75300000E-05  -3.00110000E-04  -2.54350000E-04  -1.96730000E-04
   +1.39720000E-04  +3.62440000E-04  -1.05560000E-04  +6.04500000E-05  +2.28100000E-05
   -9.25000000E-06  -1.23900000E-05  -1.93600000E-05  +8.15000000E-06  +1.30000000E-06
   -7.34700000E-05  -4.72000000E-05  +1.44500000E-05  +1.18000000E-06  -1.79600000E-05
   +8.82000000E-06  +1.27710000E-04  +1.79060000E-04  +3.72600000E-05  +9.69890000E-04
   +5.59050000E-04  -1.29808000E-03  +1.26925200E-02  +3.96677000E-02  -3.42092200E-02
   +3.69800000E-05  +1.87900000E-05  +2.57010000E-04  +4.84660000E-04  -4.77200000E-04
   +1.76190000E-04  -5.42762600E-02  +5.10350000E-04  +2.79327300E-02  +2.93336000E-02
   +8.68023000E-02  -1.35548570E-01  -1.79957620E-01  -2.07450650E-01  +3.73366550E-01
   +7.90570000E-04  -7.85200000E-05  -3.42270000E-04  -3.70840000E-04  -5.24600000E-04
   +2.96140000E-04  +1.89860000E-04  +3.69560000E-04  +2.53560000E-04  -5.76500000E-05
   -2.01460000E-04  -4.28140000E-04  -2.69180000E-04  -2.46310000E-04  +1.06110000E-04
   +4.79540000E-04  -1.75350000E-04  +8.07400000E-05  -2.69700000E-05  -7.40000000E-06
   -1.24300000E-05  -2.18000000E-06  +2.13500000E-05  -1.32500000E-05  +1.73240000E-04
   +1.86660000E-04  +7.43700000E-05  +5.95000000E-06  -2.29200000E-05  +1.88300000E-05
   +1.78920000E-04  +2.97420000E-04  +6.46000000E-06  +3.47424000E-03  +9.52910000E-04
   +1.72240000E-04  +2.82888000E-03  +7.78890900E-02  -4.69165800E-02  +2.65600000E-04
   -1.42220000E-04  +2.91660000E-04  +2.93000000E-04  -3.62080000E-04  +1.68630000E-04
   -6.23880100E-02  -6.46000000E-04  +3.01763300E-02  +4.57275300E-02  -5.76838000E-02
   +1.69499000E-02  -1.89323930E-01  -2.89596000E-02  +8.45776900E-02  +6.04781640E-01
   -8.35670000E-04  +4.14930000E-04  -2.15140000E-04  +2.53780000E-04  +3.18820000E-04
   -4.50120000E-04  -1.10260000E-04  -2.85880000E-04  -2.85610000E-04  +8.55150000E-04
   +6.86170000E-04  +2.92710000E-04  -2.13440000E-04  +6.58100000E-05  +2.41320000E-04
   -1.31170000E-04  +3.12750000E-04  +5.06700000E-05  +8.90900000E-05  +8.70000000E-06
   -9.77000000E-06  -1.05580000E-04  -4.26400000E-05  +4.36100000E-05  -9.45630000E-04
   -8.78460000E-04  -1.89100000E-04  -7.59000000E-06  -1.52600000E-05  -4.89000000E-05
   +1.06760000E-04  -1.20560000E-04  +2.59400000E-04  +1.67328000E-03  -1.92282000E-03
   +4.25472000E-03  +2.90133900E-02  -2.08603800E-02  +3.34050000E-03  +6.72110000E-04
   -4.50410000E-04  -7.09100000E-05  -1.11436000E-03  +5.38930000E-04  +2.99730000E-04
   -1.06562000E-03  -2.49338000E-03  +6.82700000E-04  -9.62145000E-03  -1.78533800E-02
   +2.09737700E-02  -8.83471100E-02  -1.32634230E-01  +9.06890300E-02  -8.47043700E-02
   +3.66062360E-01  +4.62500000E-05  -1.00480000E-04  -1.49630000E-04  +2.99480000E-04
   +2.22660000E-04  +8.61200000E-05  -7.63900000E-05  -6.10900000E-05  -3.53600000E-05
   -4.36420000E-04  -3.06040000E-04  +1.45500000E-04  +3.10990000E-04  +2.71240000E-04
   -2.56550000E-04  -2.94130000E-04  -3.84900000E-05  -8.99500000E-05  -8.56600000E-05
   +9.43000000E-06  +2.64600000E-05  +6.50700000E-05  +2.56600000E-05  -1.94700000E-05
   +4.35950000E-04  +4.06170000E-04  +6.20500000E-05  +3.70700000E-05  -3.60000000E-07
   +4.22300000E-05  -8.64100000E-05  -2.02360000E-04  -1.31820000E-04  -2.44060000E-04
   +3.55209000E-03  +2.26285000E-03  -1.50987000E-02  -2.10409600E-02  +3.03625500E-02
   -1.28210000E-04  +2.56220000E-04  -3.41900000E-05  -6.61000000E-06  +2.68190000E-04
   -6.55200000E-05  +3.10523200E-02  +4.40570000E-04  -1.79980300E-02  -1.33876800E-02
   +4.54223200E-02  -1.39661400E-02  +1.21404110E-01  +6.01881200E-02  -1.59693050E-01
   -2.04789800E-01  -1.26418360E-01  +2.78840440E-01  -1.65647000E-03  +2.85617000E-03
   -7.42090000E-04  +6.40250000E-04  +8.10310000E-04  -6.49280000E-04  -1.66510000E-04
   -5.37560000E-04  -2.69920000E-04  +2.94700000E-05  +1.63900000E-04  +4.87960000E-04
   +3.38300000E-04  +2.45520000E-04  -1.22370000E-04  -1.28134000E-03  +3.73360000E-04
   -2.69960000E-04  -2.03200000E-05  +7.57300000E-05  +2.32000000E-05  -2.77300000E-05
   -1.83600000E-05  +4.48000000E-06  -2.19480000E-04  -2.26340000E-04  -8.47700000E-05
   -2.34400000E-05  +2.52300000E-05  -2.38100000E-05  -2.32640000E-04  -2.79020000E-04
   -5.24800000E-05  -8.67230000E-03  +2.63430600E-02  -1.18372800E-02  -1.19578120E-01
   +1.08865800E-02  +2.08401200E-02  -5.06434000E-03  +1.67170000E-03  +2.28368000E-03
   -8.16090000E-04  +9.10590000E-04  -1.43920000E-03  +4.94680600E-02  -1.59604700E-02
   -1.05549500E-02  -2.96715400E-02  +3.36936400E-02  -6.16327000E-03  -4.66285000E-02
   -3.20020000E-02  +4.30765500E-02  -3.05560310E-01  +1.27754560E-01  +4.90174300E-02
   +6.46020450E-01  -4.95760000E-04  -7.05660000E-04  +2.77540000E-04  -6.19400000E-05
   +4.07000000E-06  +3.45930000E-04  -1.05450000E-04  -1.99930000E-04  +1.67010000E-04
   -3.66360000E-04  -3.28110000E-04  +6.68000000E-06  +1.05580000E-04  +1.88050000E-04
   +1.46020000E-04  -5.55600000E-05  -3.34900000E-04  -9.38450000E-04  -1.67650000E-04
   +9.21000000E-05  +2.05100000E-05  +2.43600000E-05  +2.37600000E-05  -1.13400000E-05
   +3.46230000E-04  +3.27280000E-04  +1.22590000E-04  +4.52000000E-06  +5.36300000E-05
   -5.20000000E-07  -8.89400000E-05  +1.39180000E-04  +4.12150000E-04  +1.04410700E-02
   -1.29111900E-02  +4.22515000E-03  +7.04412800E-02  -2.43295420E-01  +7.28491500E-02
   +1.76237000E-03  +5.49310000E-04  -9.55370000E-04  +7.14480000E-04  -2.35100000E-04
   +1.01023000E-03  -5.75756100E-02  -2.04165600E-02  +4.62374500E-02  +3.66114800E-02
   -4.33339300E-02  +8.64392000E-03  +1.18752300E-02  +5.80688800E-02  -4.26826900E-02
   +8.28778400E-02  -1.37790730E-01  +1.28069400E-02  -8.39925700E-02  +5.28532650E-01
   -3.97690000E-04  +9.66600000E-05  +5.32500000E-04  +2.82780000E-04  +3.15480000E-04
   -4.90030000E-04  -7.63100000E-05  +3.18100000E-05  -1.81140000E-04  +1.75260000E-04
   +1.49670000E-04  +2.48510000E-04  +1.79520000E-04  +1.65470000E-04  +2.01800000E-05
   -7.23500000E-04  +4.95680000E-04  -7.69000000E-05  +7.36300000E-05  -1.01280000E-04
   +2.55600000E-05  +5.23000000E-06  -3.12500000E-05  +1.12600000E-05  -1.73280000E-04
   -1.46930000E-04  -6.34100000E-05  -2.75000000E-06  +1.44600000E-05  -1.10600000E-05
   -2.33800000E-04  -1.51340000E-04  -4.98200000E-05  -7.41680000E-04  -5.37283000E-03
   +6.18203000E-03  -1.74248300E-02  +1.02696590E-01  -1.23127490E-01  +1.75404000E-03
   -2.75550000E-04  -3.06010000E-04  +1.02595000E-03  -9.87120000E-04  -2.47330000E-04
   +1.54978500E-02  +2.53337800E-02  -1.63119200E-02  -7.87463000E-03  +1.04939600E-02
   -2.47668000E-03  +1.56250700E-02  -2.07442500E-02  +4.02081000E-03  +7.68848100E-02
   -9.79000000E-03  -8.30006600E-02  -2.02640540E-01  -2.00254760E-01  +3.57832190E-01
   -2.05490000E-04  +6.96100000E-05  -1.72470000E-04  -1.20000000E-05  +4.41700000E-05
   -1.42300000E-05  +4.31700000E-05  +2.18300000E-05  +2.92700000E-05  -6.02500000E-05
   -7.04700000E-05  -1.99700000E-05  +9.30000000E-06  +1.85400000E-05  -5.13100000E-05
   -4.12300000E-05  +6.54900000E-05  +9.85100000E-05  -6.87000000E-06  -1.39300000E-05
   -9.00000000E-07  +1.74600000E-05  +1.70000000E-07  -1.71000000E-06  +8.74600000E-05
   +8.31600000E-05  +1.39100000E-05  +5.99000000E-06  -1.10000000E-06  +7.70000000E-06
   +6.16900000E-05  -6.05800000E-05  -1.99600000E-05  +2.35790000E-04  -7.52020000E-04
   -1.57732000E-03  +9.50566000E-03  -1.75978200E-02  +8.52841000E-03  -1.55944000E-03
   +1.52680000E-04  +1.00932000E-03  +2.93050000E-04  +1.15910000E-04  -9.58200000E-05
   -6.44537100E-02  +4.85476500E-02  -1.71905400E-02  -1.82082000E-03  +2.48952100E-02
   -1.29099100E-02  -3.03144000E-03  +2.99302000E-03  +3.26250000E-03  -1.45498000E-03
   -7.03000000E-05  +2.98510000E-04  -1.55338000E-03  -1.29160000E-03  +4.84261000E-03
   +6.63916500E-02  -2.49760000E-04  +2.27350000E-04  +2.60650000E-04  -6.18900000E-05
   -4.57800000E-05  -1.00190000E-04  -1.64000000E-06  -2.41100000E-05  -8.28000000E-06
   +3.10000000E-06  +2.00700000E-05  +4.18000000E-05  +1.82700000E-05  +8.56000000E-06
   -6.36200000E-05  -1.18390000E-04  +2.66500000E-05  +1.49390000E-04  +1.05900000E-05
   -2.69000000E-06  -5.52000000E-06  -3.58000000E-06  -1.24500000E-05  -1.34000000E-06
   -1.64900000E-05  -1.59700000E-05  -2.11600000E-05  -4.53000000E-06  -1.46800000E-05
   +2.71000000E-06  +7.97000000E-06  -8.95200000E-05  -8.99000000E-06  +1.40580000E-04
   -1.84884000E-03  -1.47448000E-03  +3.27476000E-03  -7.42774000E-03  +5.90968000E-03
   +2.01941000E-03  -8.48900000E-05  -4.46890000E-04  +2.96930000E-04  -9.54100000E-05
   -1.21940000E-04  +4.83037000E-02  -2.69530570E-01  +1.21712020E-01  +8.39840000E-04
   -8.33830000E-03  +6.98849000E-03  +3.16142000E-03  +2.50312000E-03  +1.23723000E-03
   -4.86130000E-04  +6.13020000E-04  -7.62700000E-04  -1.03058000E-03  +1.43300000E-03
   +3.70194000E-03  -5.73545100E-02  +2.84674840E-01  -3.06220000E-04  +1.03830000E-04
   +3.13070000E-04  -5.97000000E-05  -8.14600000E-05  -8.33300000E-05  -6.65000000E-06
   -4.18400000E-05  -1.81500000E-05  +1.59300000E-05  +5.10600000E-05  +3.42000000E-05
   +1.48000000E-06  -1.95700000E-05  -1.91900000E-05  -5.40000000E-05  -2.03100000E-05
   +1.25440000E-04  +5.76000000E-06  +1.49400000E-05  -1.30800000E-05  -1.24000000E-05
   -7.65000000E-06  -1.50000000E-06  -5.22300000E-05  -5.88900000E-05  -2.34400000E-05
   -9.27000000E-06  -9.49000000E-06  -4.14000000E-06  +5.30000000E-07  +4.21000000E-06
   -2.11000000E-05  -2.28880000E-03  -8.92700000E-04  -2.21367000E-03  -4.97070000E-03
   +1.65232600E-02  -3.44754000E-03  -8.99900000E-05  +6.91950000E-04  +5.92150000E-04
   +7.66750000E-04  -1.36550000E-04  -1.11610000E-04  -1.67578400E-02  +1.21955610E-01
   -1.06445760E-01  +2.12799000E-03  -5.24809000E-03  +5.66728000E-03  +3.12645000E-03
   +1.24860000E-03  +4.58962000E-03  +5.69780000E-04  -9.36160000E-04  -6.81420000E-04
   +4.69885000E-03  +3.66921000E-03  +1.74695000E-03  +1.56536900E-02  -1.34054870E-01
   +1.03016050E-01  -5.10800000E-05  +2.64940000E-04  +1.53770000E-04  -5.21600000E-05
   -7.38200000E-05  -6.86100000E-05  -1.65500000E-05  -4.24600000E-05  -1.36500000E-05
   +8.98900000E-05  +8.04200000E-05  +2.99300000E-05  -3.62700000E-05  -1.92200000E-05
   +1.71000000E-05  -2.61700000E-05  -1.17100000E-05  +2.44900000E-05  +1.28000000E-05
   +1.78700000E-05  -5.95000000E-06  -1.81100000E-05  -1.34400000E-05  +2.98000000E-06
   -1.15510000E-04  -1.01430000E-04  -3.15500000E-05  -1.26700000E-05  -1.14200000E-05
   -7.34000000E-06  +9.82000000E-06  +1.85700000E-05  +2.80600000E-05  -1.58000000E-06
   -9.39910000E-04  +7.52590000E-04  -2.67942000E-03  +4.45076000E-03  +1.83562000E-03
   +4.98000000E-06  -1.06330000E-04  +2.33600000E-05  -2.76640000E-04  +9.43000000E-05
   -6.01300000E-05  -1.34290900E-02  -1.43803200E-02  +1.72025200E-02  -1.72998590E-01
   -7.32913700E-02  +1.18917750E-01  +4.33876000E-03  +5.99726000E-03  -3.56066000E-03
   +2.00017000E-03  +1.77320000E-03  +7.84510000E-04  -5.90850000E-04  +5.39590000E-04
   -7.90440000E-04  +7.76500000E-05  -7.84480000E-04  -1.64941000E-03  +1.81520130E-01
   +2.00530000E-04  -1.48420000E-04  -8.67500000E-05  +1.44000000E-06  -3.70000000E-07
   +3.01500000E-05  +1.55800000E-05  +4.84600000E-05  +8.20000000E-06  -1.57600000E-05
   -2.95600000E-05  -3.15300000E-05  -1.02300000E-05  +7.50000000E-07  -7.64000000E-06
   +7.73000000E-06  -7.97000000E-06  +2.39900000E-05  +5.31000000E-06  -9.98000000E-06
   -2.20000000E-06  +6.66000000E-06  +6.01000000E-06  -2.30000000E-06  +3.67300000E-05
   +3.31300000E-05  +7.65000000E-06  -2.31000000E-06  -1.52000000E-06  +3.34000000E-06
   +2.35000000E-06  +7.16000000E-06  +6.47000000E-06  +3.94990000E-04  +5.35240000E-04
   -1.49740000E-04  +3.90694000E-03  +9.99510000E-04  +1.18049000E-03  -6.40000000E-05
   +4.66600000E-05  -1.86800000E-05  +2.25700000E-05  +2.74400000E-05  +5.19400000E-05
   +9.77384000E-03  +9.64689000E-03  -9.67553000E-03  -7.38932600E-02  -1.06002010E-01
   +8.48804200E-02  -1.93841100E-02  -6.86008000E-03  +1.73779600E-02  +1.79410000E-03
   -2.21513000E-03  +4.03452000E-03  +9.64560000E-04  -1.17025000E-03  -6.56700000E-04
   -1.17768000E-03  -3.25360000E-04  -1.78394000E-03  +7.82512600E-02  +1.06219460E-01
   +2.24500000E-04  -1.17340000E-04  -7.06900000E-05  -4.12000000E-06  -1.88100000E-05
   +4.65300000E-05  +2.15200000E-05  +4.89200000E-05  +2.11300000E-05  -3.71100000E-05
   -4.70200000E-05  -3.98800000E-05  -3.40000000E-06  -5.44000000E-06  -1.84000000E-05
   +8.05000000E-06  -9.81000000E-06  +1.64500000E-05  +2.84000000E-06  -4.91000000E-06
   -2.98000000E-06  +5.05000000E-06  +9.88000000E-06  -4.34000000E-06  +6.21900000E-05
   +4.92500000E-05  +1.40000000E-05  -3.08000000E-06  +8.90000000E-07  +2.10000000E-06
   -7.20000000E-06  +2.47000000E-06  -5.56000000E-06  +4.22000000E-05  +3.75860000E-04
   +2.75210000E-04  +1.93707000E-03  +8.77030000E-04  +4.54345000E-03  +1.27800000E-05
   -3.81000000E-06  -6.88700000E-05  -1.07300000E-05  +8.09700000E-05  +4.80700000E-05
   +2.01098000E-03  +2.80674000E-03  -4.97230000E-04  +1.19349340E-01  +8.46689800E-02
   -1.47420080E-01  +1.25363700E-02  +4.20229000E-03  -4.31041000E-03  +7.02860000E-04
   +4.08777000E-03  +2.71729000E-03  -1.09380000E-03  -4.38180000E-04  -6.13850000E-04
   -1.40492000E-03  -1.99266000E-03  -2.10440000E-03  -1.31540260E-01  -9.34773000E-02
   +1.49444260E-01  -1.42500000E-04  +9.80570000E-04  +2.52270000E-04  +3.04000000E-06
   -4.81700000E-05  -3.41160000E-04  -2.18420000E-04  -3.92660000E-04  -2.72490000E-04
   +7.46330000E-04  +7.16330000E-04  +3.66780000E-04  -2.02380000E-04  +4.35500000E-05
   +2.55130000E-04  -1.53990000E-04  -7.77900000E-05  -1.32850000E-04  +8.12000000E-05
   +7.60800000E-05  -2.48000000E-05  -1.10160000E-04  -8.76900000E-05  +4.46500000E-05
   -9.86080000E-04  -8.67560000E-04  -2.22520000E-04  -4.54200000E-05  -3.77500000E-05
   -5.94500000E-05  +1.64130000E-04  +9.46200000E-05  +3.71450000E-04  +1.72136000E-03
   -7.16390000E-04  +5.61730000E-04  -1.84853000E-03  +4.13584000E-03  -3.14186000E-03
   -4.86900000E-04  -2.02250000E-04  +3.28630000E-04  -1.44134000E-03  +5.40300000E-04
   -3.42820000E-04  +4.77360000E-04  +7.77700000E-04  +3.15575000E-03  -1.90021400E-02
   +1.63451100E-02  +4.53854000E-03  -2.45847210E-01  +1.21196440E-01  +2.82850400E-02
   -4.87402300E-02  +1.92120100E-02  +1.58147400E-02  +4.06635000E-03  -4.45457000E-03
   +2.46279000E-03  -6.52690000E-04  +4.33910000E-04  +6.27700000E-05  +2.39550000E-03
   -1.95989000E-03  -2.24360000E-03  +5.09620070E-01  +1.11730000E-04  -5.83140000E-04
   -1.68990000E-04  -3.26500000E-05  +2.07000000E-06  +1.80070000E-04  +1.27830000E-04
   +2.56050000E-04  +1.58950000E-04  -3.38490000E-04  -3.66820000E-04  -2.32060000E-04
   +6.43300000E-05  -2.82000000E-05  -1.16460000E-04  +1.15560000E-04  +7.11600000E-05
   +8.72200000E-05  -3.65700000E-05  -5.68300000E-05  +1.76300000E-05  +5.80200000E-05
   +4.15300000E-05  -1.93900000E-05  +4.86090000E-04  +4.49410000E-04  +1.17040000E-04
   +3.66000000E-05  +1.34500000E-05  +3.90400000E-05  -6.91900000E-05  -6.19400000E-05
   -1.74770000E-04  -6.96840000E-04  +4.45500000E-04  -7.60090000E-04  +2.31530000E-03
   +1.91295000E-03  -2.68194000E-03  +2.76240000E-04  +5.84200000E-05  -1.52160000E-04
   +8.09520000E-04  -3.38860000E-04  +1.82770000E-04  -5.16370000E-03  -6.13120000E-04
   +7.91343000E-03  +4.87579700E-02  -2.12696400E-02  -5.63316000E-03  +7.83179200E-02
   -1.44058990E-01  +2.41018200E-02  -1.06045500E-02  +1.28932100E-02  +8.47180000E-04
   +6.97870000E-04  -4.68806000E-03  +4.85637000E-03  +1.46105000E-03  -7.34690000E-04
   -2.53750000E-04  -1.43117000E-03  +1.29721000E-03  -2.76163000E-03  +8.15426000E-03
   +3.28462950E-01  -3.04000000E-06  -1.90620000E-04  +8.07800000E-05  +3.28000000E-06
   -1.41600000E-05  +7.88400000E-05  +1.69700000E-05  +5.63200000E-05  +6.96000000E-05
   -1.76700000E-04  -1.53840000E-04  -5.84700000E-05  +6.95000000E-05  +1.18000000E-05
   -6.38200000E-05  +3.14100000E-05  -5.63000000E-06  -2.97100000E-05  -2.71500000E-05
   -6.80000000E-06  +9.90000000E-06  +1.88700000E-05  +1.59400000E-05  -8.72000000E-06
   +2.18810000E-04  +1.94240000E-04  +5.63900000E-05  +1.96300000E-05  +1.39700000E-05
   +1.35500000E-05  -4.51100000E-05  -3.72200000E-05  -7.36900000E-05  -5.79470000E-04
   -2.19510000E-04  -2.17700000E-04  -1.22881000E-03  -3.99622000E-03  +2.15883000E-03
   +1.38850000E-04  +6.39800000E-05  -1.06850000E-04  +2.55800000E-04  -4.89300000E-05
   +1.47200000E-05  +7.10507000E-03  +4.92755000E-03  +1.12075000E-03  -1.61132500E-02
   +1.12204300E-02  +1.08075800E-02  +5.53233600E-02  +2.06821000E-03  -7.16301800E-02
   +3.42870000E-02  -1.44188100E-02  -2.92068000E-03  -5.84280000E-04  +7.42769000E-03
   -7.49470000E-04  -5.99420000E-04  +2.70930000E-04  +1.57880000E-04  -2.52745000E-03
   -2.52663000E-03  -1.37331000E-03  -2.53006150E-01  -1.94619550E-01  +2.77856000E-01
   +1.12970000E-04  +2.49890000E-04  +8.03200000E-05  +2.41000000E-05  +2.78000000E-06
   -1.09760000E-04  -6.09300000E-05  -1.56220000E-04  -7.90500000E-05  +2.62320000E-04
   +2.57900000E-04  +9.76400000E-05  -7.66900000E-05  -4.96100000E-05  +9.48700000E-05
   +1.84000000E-06  +3.71000000E-06  -1.60900000E-05  +2.95300000E-05  +3.40600000E-05
   -8.25000000E-06  -5.75900000E-05  -1.18100000E-05  +1.10200000E-05  -3.34360000E-04
   -3.41740000E-04  -6.13300000E-05  -2.49900000E-05  +2.28000000E-06  -3.53400000E-05
   +4.05700000E-05  +4.48000000E-05  +8.90700000E-05  +7.42570000E-04  +7.79540000E-04
   -9.13650000E-04  -2.53761000E-03  +9.49850000E-04  +2.04011000E-03  -5.46720000E-04
   +4.46200000E-05  +2.67770000E-04  -1.43640000E-04  -3.87000000E-06  -1.10500000E-04
   -1.71755000E-03  +3.26100000E-05  +5.90870000E-04  +2.10143000E-03  -1.86640000E-03
   +1.05336000E-03  -1.37410000E-03  -3.07975000E-03  +4.60967000E-03  -2.01403900E-02
   -3.89661100E-02  +2.33046200E-02  -3.72757000E-03  +2.08660100E-02  -9.11164000E-03
   +6.43200000E-05  +1.10810000E-04  -9.24600000E-05  -2.01100000E-04  -2.48600000E-05
   +7.51400000E-05  +9.44330000E-04  -1.43442000E-03  -2.07450000E-04  +4.07958800E-02
   -1.00860000E-04  -4.29980000E-04  -1.09360000E-04  -7.81200000E-05  +1.00000000E-07
   +2.17640000E-04  +1.24150000E-04  +2.27480000E-04  +1.78470000E-04  -5.95080000E-04
   -5.19950000E-04  -1.88910000E-04  +1.72100000E-04  +1.56700000E-05  -1.80960000E-04
   +1.01700000E-05  -3.42800000E-05  +1.18900000E-05  -5.76600000E-05  -4.15200000E-05
   +6.68000000E-06  +9.36400000E-05  +3.58800000E-05  -2.86500000E-05  +6.89120000E-04
   +6.47260000E-04  +1.31390000E-04  +1.95400000E-05  +1.03400000E-05  +4.22300000E-05
   -7.76000000E-05  -3.10500000E-05  -1.74760000E-04  -1.51838000E-03  -8.61330000E-04
   +1.25039000E-03  +3.01146000E-03  +4.04252000E-03  -2.23442000E-03  +8.14820000E-04
   -3.69800000E-05  -4.80210000E-04  +3.74310000E-04  -5.80100000E-05  +8.66800000E-05
   +7.53360000E-04  -3.23000000E-05  -6.52820000E-04  -6.72028000E-03  +2.17912000E-03
   +3.47763000E-03  +1.54764700E-02  -2.09510200E-02  +7.51122000E-03  -2.11480500E-02
   +2.74060700E-02  -2.01672300E-02  +6.50326000E-03  -1.87560700E-02  +1.06563400E-02
   -1.39250000E-04  -2.42590000E-04  +1.83950000E-04  +6.57450000E-04  -1.31170000E-03
   +4.08140000E-04  -1.09507000E-03  +2.63678000E-03  -1.96626000E-03  +3.66861100E-02
   -5.37470100E-02  -1.58800000E-05  +1.21130000E-04  +4.50800000E-05  +2.30000000E-07
   +4.66000000E-05  -1.07060000E-04  -2.78300000E-05  -9.47900000E-05  -8.71300000E-05
   +2.17070000E-04  +2.11240000E-04  +8.89600000E-05  -5.70600000E-05  -3.27100000E-05
   +7.19600000E-05  -2.85300000E-05  +2.82100000E-05  +1.94300000E-05  +3.72500000E-05
   +3.75000000E-06  -8.57000000E-06  -3.02000000E-05  -1.41600000E-05  +1.10100000E-05
   -2.68740000E-04  -2.63670000E-04  -6.05700000E-05  -2.07000000E-05  -7.10000000E-07
   -2.73300000E-05  +2.81800000E-05  +3.43100000E-05  +5.30700000E-05  +5.36290000E-04
   +1.61680000E-04  -4.77330000E-04  +8.10710000E-04  -1.19105000E-03  +3.06101000E-03
   -2.77400000E-04  -3.13300000E-05  +1.46820000E-04  -7.47400000E-05  -4.39500000E-05
   -3.35600000E-05  +5.73000000E-05  -2.98750000E-04  -3.14080000E-04  +4.19042000E-03
   +7.93210000E-04  -6.73120000E-04  -7.05046000E-03  +1.70745600E-02  -3.21926000E-03
   +1.22762400E-02  -1.13407900E-02  -2.12982000E-02  -2.12240000E-04  +3.36782000E-03
   +1.86334000E-03  +4.62200000E-05  +9.07800000E-05  -8.00000000E-05  -3.65540000E-04
   +7.57980000E-04  -4.02100000E-04  -4.33830000E-04  -1.73550000E-03  +1.20200000E-05
   -3.50436700E-02  +2.61610900E-02  +1.91297100E-02  -7.45160000E-04  +8.26760000E-04
   -2.65370000E-04  -1.25500000E-04  +2.55700000E-05  +3.44700000E-05  -1.51620000E-04
   -1.80240000E-04  +2.89000000E-06  -3.42000000E-04  -1.85160000E-04  +1.56310000E-04
   +3.18830000E-04  +1.63080000E-04  -6.73000000E-05  -3.50420000E-04  +3.17200000E-05
   -3.51350000E-04  +2.98400000E-05  +4.44200000E-05  +8.47000000E-06  +1.61000000E-05
   +6.72000000E-06  -1.54500000E-05  +2.48090000E-04  +2.11900000E-04  +3.73100000E-05
   +7.45000000E-06  +5.20000000E-06  +1.19500000E-05  +2.94200000E-05  -3.10500000E-05
   +6.34100000E-05  -6.93740000E-04  -2.15660000E-04  -8.90190000E-04  +8.35478000E-03
   +3.15278000E-03  -3.65481000E-03  -1.72100000E-05  -1.17430000E-04  -1.07560000E-04
   -9.10500000E-05  +1.63370000E-04  +7.81800000E-05  +1.53622000E-03  +2.56472000E-03
   +5.20430000E-04  -4.41940000E-04  +6.93270000E-04  -7.73640000E-04  -1.86208000E-03
   +3.68604000E-03  +2.16661000E-03  -1.58318100E-02  -1.13790700E-02  +1.59328800E-02
   -1.77177570E-01  -8.15497500E-02  +1.17760010E-01  +3.36860000E-04  +2.63320000E-04
   -3.18890000E-04  -8.04300000E-05  -1.02880000E-04  -6.47800000E-05  -8.92050000E-04
   -5.99300000E-04  +8.13380000E-04  +5.31720000E-04  -2.37915000E-03  +4.78130000E-04
   +1.87831040E-01  +4.10550000E-04  +2.90200000E-05  -3.89200000E-05  +1.19710000E-04
   +6.86200000E-05  -6.91900000E-05  +7.44600000E-05  +2.56800000E-05  -4.13800000E-05
   +2.47660000E-04  +1.13930000E-04  -1.04850000E-04  -2.02840000E-04  -2.28960000E-04
   +5.86000000E-05  +1.12470000E-04  +3.03730000E-04  +3.81230000E-04  +8.96800000E-05
   -4.23100000E-05  -3.23700000E-05  -3.71800000E-05  +1.73000000E-06  +7.70000000E-06
   -2.49180000E-04  -2.39420000E-04  -5.04600000E-05  -2.57800000E-05  -1.00900000E-05
   -2.16000000E-05  +5.94000000E-06  +2.60800000E-05  -5.92700000E-05  -1.48155000E-03
   -1.16880000E-04  -1.01493000E-03  -1.93046900E-02  -6.27086000E-03  +1.66109800E-02
   -1.40500000E-04  +2.45700000E-05  -5.59100000E-05  +2.35550000E-04  -6.06970000E-04
   +2.29520000E-04  +2.86145000E-03  -3.14673000E-03  +4.23504000E-03  +6.17410000E-04
   -8.10370000E-04  -5.01170000E-04  +4.33346000E-03  +6.50060000E-04  +1.74782000E-03
   +9.26996000E-03  +9.43688000E-03  -9.15530000E-03  -7.97590100E-02  -1.11104690E-01
   +8.32328200E-02  -1.03473000E-03  -4.76970000E-04  +7.78890000E-04  -1.37690000E-04
   -5.17500000E-05  -9.94800000E-05  +4.04270000E-04  +4.41730000E-04  -4.61680000E-04
   -5.41100000E-05  +1.64260000E-04  -9.93020000E-04  +8.36583000E-02  +1.11907550E-01
   -1.76260000E-04  +1.59240000E-04  +2.60710000E-04  -3.25710000E-04  -3.49270000E-04
   +2.05350000E-04  +3.82000000E-05  +1.51060000E-04  +1.39340000E-04  -1.87360000E-04
   -1.42750000E-04  -1.56970000E-04  -7.11900000E-05  -2.01200000E-04  -5.64900000E-05
   +1.73450000E-04  -1.83430000E-04  -1.14220000E-04  +4.49800000E-05  -4.22900000E-05
   -4.81600000E-05  +1.92500000E-05  +3.85000000E-06  -9.44000000E-06  +2.25730000E-04
   +1.73430000E-04  +4.57400000E-05  -1.23300000E-05  +1.77300000E-05  -7.08000000E-06
   +3.58200000E-05  +9.67000000E-05  -1.83100000E-05  -1.83370000E-04  -1.49126000E-03
   -2.02346000E-03  +1.00060100E-02  +5.86621000E-03  -3.05129000E-03  -2.15090000E-04
   -5.95400000E-05  -6.65000000E-05  +1.38500000E-04  -2.62680000E-04  +4.98700000E-05
   +6.84810000E-04  +4.59831000E-03  +3.04202000E-03  -8.83860000E-04  -4.85210000E-04
   -4.57620000E-04  +1.92112000E-03  +1.98960000E-03  +5.12704000E-03  +3.46649000E-03
   +1.37412000E-03  -7.01030000E-04  +1.15927790E-01  +8.31023700E-02  -1.45716450E-01
   +4.60240000E-04  +1.12270000E-04  -4.21990000E-04  -4.74300000E-05  -1.20080000E-04
   -2.34940000E-04  +2.99740000E-04  +6.32700000E-05  -1.24760000E-04  -9.41700000E-04
   -4.59100000E-05  -1.09019000E-03  -1.30630670E-01  -9.31459300E-02  +1.45922060E-01
   +3.75150000E-04  -1.00830000E-04  -4.16710000E-04  +5.57780000E-04  +5.73200000E-05
   -1.54340000E-04  +6.96100000E-05  -3.16700000E-05  -3.57400000E-05  +2.23120000E-04
   +1.72530000E-04  -5.57200000E-05  -1.79960000E-04  -6.28900000E-05  +6.85800000E-05
   +2.86080000E-04  +2.08740000E-04  +4.66510000E-04  -6.87800000E-05  +6.25100000E-05
   +6.50000000E-06  -8.38000000E-06  -6.96000000E-06  +8.94000000E-06  -2.05930000E-04
   -1.73680000E-04  -3.01600000E-05  -1.92000000E-05  +2.65000000E-06  -1.08700000E-05
   -1.77900000E-05  -1.58500000E-05  -1.81800000E-05  +3.73897000E-03  +4.96924000E-03
   +1.01555000E-03  +1.06550000E-04  -1.28760000E-04  +2.92290000E-04  -1.69419170E-01
   -1.29257810E-01  -2.87930900E-02  +3.77790000E-04  +3.51080000E-04  +5.69000000E-05
   -9.71970000E-04  +6.84270000E-04  +7.42470000E-04  +6.64400000E-05  +1.81430000E-04
   -1.24460000E-04  -1.57120000E-04  -1.23000000E-05  +3.61200000E-05  +4.56100000E-05
   +3.25700000E-05  -4.60900000E-05  +8.62600000E-05  -1.12280000E-04  -5.01500000E-05
   -1.16334000E-03  +1.48344000E-03  +5.55310000E-04  +2.77200000E-05  +6.16000000E-06
   +2.03100000E-05  +9.49700000E-05  -2.60700000E-05  -4.12800000E-05  +3.02600000E-05
   -6.45600000E-05  +1.50400000E-05  -6.37000000E-06  -5.60000000E-07  +3.38000000E-06
   +1.83777540E-01  +1.37387000E-03  -3.21714000E-03  +3.83829000E-03  +3.82840000E-04
   -4.33860000E-04  -5.51050000E-04  -6.66140000E-04  -2.39050000E-04  -4.86910000E-04
   +2.49350000E-04  +4.26760000E-04  +6.08990000E-04  +5.05500000E-05  +1.65000000E-04
   +4.17500000E-05  -2.96980000E-04  -1.12160000E-04  +3.32910000E-04  +6.46400000E-05
   -1.12430000E-04  +1.47980000E-04  -1.29630000E-04  -2.45900000E-05  -2.27300000E-05
   -5.71370000E-04  -5.33340000E-04  -1.71250000E-04  -2.26700000E-05  -4.17300000E-05
   -3.21400000E-05  +1.11500000E-05  +1.04830000E-04  -6.34300000E-05  -1.80495200E-02
   -1.79247200E-02  -4.65986000E-03  -8.48230000E-04  +6.70450000E-04  -1.60090000E-04
   -1.27944710E-01  -1.83688580E-01  -2.98541800E-02  -4.87130000E-04  +7.76610000E-04
   -1.63494000E-03  -5.82600000E-05  -4.18890000E-04  +6.02300000E-04  +3.53970000E-04
   +3.00690000E-04  -2.68910000E-04  +1.06000000E-05  +1.25050000E-04  -1.60890000E-04
   -1.90610000E-04  +1.50300000E-05  +8.56900000E-05  +3.26280000E-04  -1.29680000E-04
   +1.38000000E-04  +9.91740000E-04  -2.53970000E-04  -9.88310000E-04  +1.03000000E-05
   -2.59000000E-05  +5.83000000E-06  -1.21480000E-04  +1.19950000E-04  -5.45000000E-06
   -6.28600000E-05  +7.79700000E-05  -3.61800000E-05  -7.25300000E-05  +8.40800000E-05
   -9.81500000E-05  +1.41075190E-01  +1.99820740E-01  -1.46143000E-03  +2.35296000E-03
   -1.83466000E-03  +5.43080000E-04  +4.70440000E-04  +1.43480000E-04  +2.56400000E-05
   -3.19600000E-04  +9.93300000E-05  -2.78000000E-04  -9.12500000E-05  +2.02170000E-04
   +6.08330000E-04  +5.24300000E-05  +3.84000000E-05  +7.13000000E-06  -3.82820000E-04
   -1.28780000E-04  -3.90700000E-05  +1.26880000E-04  -6.78300000E-05  +3.31700000E-05
   +3.79300000E-05  -1.12400000E-05  +2.68520000E-04  +2.77280000E-04  +4.37200000E-05
   +2.93300000E-05  +1.10400000E-05  +1.57700000E-05  -3.11040000E-04  +3.75310000E-04
   +8.73800000E-05  +1.35453900E-02  +1.35871900E-02  +1.49835000E-03  +7.64400000E-05
   -5.14660000E-04  +2.98050000E-04  -2.85732400E-02  -3.09776100E-02  -5.52072400E-02
   +1.01129000E-03  +8.21390000E-04  +9.52360000E-04  -2.08400000E-04  -6.88130000E-04
   +4.64620000E-04  -2.10800000E-05  +2.30790000E-04  -1.52940000E-04  -9.40500000E-05
   -4.68900000E-05  +9.34500000E-05  +8.71000000E-05  -2.12500000E-05  -3.32200000E-05
   +4.67400000E-05  +2.96000000E-05  -1.80370000E-04  +5.64660000E-04  -3.63130000E-04
   -2.12070000E-04  +4.87000000E-06  -6.81000000E-06  +9.67000000E-06  +7.86000000E-06
   +3.69800000E-05  -3.12500000E-05  -3.20000000E-06  +2.70900000E-05  -5.78000000E-06
   +2.69100000E-05  +3.25000000E-05  +5.36000000E-06  +3.11786100E-02  +3.08739500E-02
   +5.68566500E-02  -1.20980000E-04  +2.29830000E-04  +6.75260000E-04  -1.02920000E-04
   -1.16460000E-04  +4.96900000E-05  +1.00420000E-04  +5.07800000E-05  +4.67400000E-05
   -2.14500000E-05  -7.73900000E-05  -7.53200000E-05  -2.23330000E-04  -3.28600000E-05
   -4.92000000E-06  -2.28000000E-06  -1.56090000E-04  -1.03590000E-04  +2.93000000E-06
   +2.98900000E-05  -4.98700000E-05  -1.50000000E-06  +1.29400000E-05  -7.59000000E-06
   +3.24500000E-05  +4.12400000E-05  +4.34000000E-06  +2.20800000E-05  -1.84400000E-05
   +6.62000000E-06  +2.37590000E-04  -9.31900000E-05  +5.31000000E-05  -1.66794000E-03
   -1.94399000E-03  -5.92185000E-03  +4.67440000E-04  -5.01680000E-04  -4.97550000E-04
   -4.70279100E-02  +1.19380000E-04  +2.19252000E-03  -2.46100000E-04  +1.24741000E-03
   -7.19730000E-04  -1.94900000E-04  +4.70570000E-04  -3.98560000E-04  -1.28190000E-04
   -6.13100000E-05  +2.14570000E-04  -7.23900000E-05  -8.41900000E-05  +8.25300000E-05
   +1.35380000E-04  +3.20100000E-05  -8.10900000E-05  -6.51000000E-05  +7.64400000E-05
   +1.94900000E-05  -1.45365000E-03  -1.61050000E-04  -3.94240000E-04  -5.20000000E-06
   -6.90000000E-07  -2.77700000E-05  +1.30520000E-04  -9.66400000E-05  -1.22900000E-05
   +5.81400000E-05  -9.60400000E-05  +3.56900000E-05  -2.81000000E-06  -6.49600000E-05
   +1.99400000E-05  +2.64830000E-04  -4.62252000E-03  -2.17092400E-02  +4.80974500E-02
   +6.93820000E-04  +1.36129000E-03  +1.52130000E-04  -4.48430000E-04  -1.16250000E-04
   +3.69000000E-05  +2.69130000E-04  +2.33540000E-04  +2.07820000E-04  +5.65200000E-05
   -8.70000000E-05  -3.42960000E-04  -1.88640000E-04  -2.02250000E-04  -2.32860000E-04
   -4.00190000E-04  -3.16670000E-04  +6.70670000E-04  +7.28300000E-05  +5.56000000E-06
   -3.19200000E-05  +2.00200000E-05  -6.24000000E-06  +3.47000000E-06  +1.39670000E-04
   +1.04500000E-04  +2.57500000E-05  -8.26000000E-06  -1.61300000E-05  +1.89700000E-05
   +1.38990000E-04  -1.12992000E-03  -2.11750000E-04  -9.55920000E-04  +6.70917000E-03
   +2.51078100E-02  -4.86940000E-04  +1.21692000E-03  -3.76060000E-04  -2.60390000E-04
   -6.55804600E-02  -6.80283200E-02  +7.81100000E-04  -4.23226000E-03  +2.61487000E-03
   +4.69210000E-04  +3.73440000E-04  -1.37890000E-04  +1.03640000E-04  -2.09220000E-04
   +3.85400000E-05  +1.22160000E-04  +1.17360000E-04  -1.64130000E-04  -1.89110000E-04
   +2.69800000E-05  +9.60300000E-05  -1.77780000E-04  -2.24450000E-04  -5.20700000E-05
   +2.61300000E-04  -1.58180000E-04  +4.48900000E-05  +1.59400000E-05  +1.51600000E-05
   +2.21300000E-05  -5.70300000E-05  -3.19000000E-06  +3.56300000E-05  -1.47100000E-05
   +2.44400000E-05  +6.20000000E-07  +9.70000000E-06  +3.24300000E-05  +4.07600000E-05
   +1.98955000E-03  -5.54685000E-03  -2.18224200E-02  -1.26353000E-03  +7.06317500E-02
   -1.09923000E-03  -8.63910000E-04  +5.05940000E-04  +6.85760000E-04  +2.72150000E-04
   -2.44320000E-04  -3.67960000E-04  -3.45020000E-04  -1.29830000E-04  -2.18700000E-04
   +1.30340000E-04  +4.21050000E-04  +5.11050000E-04  +2.61200000E-04  +2.14920000E-04
   +1.46000000E-04  -7.21250000E-04  -1.66070000E-04  -1.23110000E-04  -4.06000000E-05
   +8.85100000E-05  -5.10000000E-06  +1.68600000E-05  -1.27300000E-05  +1.02200000E-05
   +1.91100000E-05  +3.73000000E-06  +4.22300000E-05  +6.89000000E-06  +7.10000000E-06
   -2.62440000E-04  +9.96200000E-05  +3.28800000E-04  +4.41620000E-04  -5.80879000E-03
   -1.74290500E-02  +1.07948000E-03  -7.70660000E-04  +5.13860000E-04  +2.12363000E-03
   -6.57638700E-02  -2.97971140E-01  -6.71100000E-04  +4.60520000E-03  -1.57309000E-03
   +4.29710000E-04  +3.15950000E-04  +1.24530000E-04  -2.79650000E-04  +3.01500000E-05
   +2.67220000E-04  -4.30300000E-05  -2.41870000E-04  +9.25700000E-05  +2.15250000E-04
   -8.52500000E-05  -8.74500000E-05  -2.00370000E-04  +4.48320000E-04  +8.25800000E-05
   -3.11420000E-04  -3.67520000E-04  +5.84600000E-05  -1.76500000E-05  +2.72600000E-05
   +8.93000000E-06  -1.27600000E-05  -2.01600000E-05  +4.65000000E-06  -7.90000000E-07
   -6.39000000E-06  -1.82900000E-05  -1.43600000E-05  -1.00890000E-04  +1.94000000E-06
   +5.66320000E-04  -5.07750000E-04  -3.11159000E-03  -1.89126000E-03  +7.11853000E-02
   +3.24395680E-01  +7.77750000E-04  -1.32070000E-03  -3.24430000E-04  +2.64430000E-04
   +1.12890000E-04  +1.48450000E-04  +1.00110000E-04  +1.29760000E-04  -4.34500000E-05
   +4.88500000E-05  +1.82900000E-05  -1.63090000E-04  -2.29420000E-04  -2.23600000E-05
   +8.74000000E-06  +3.24030000E-04  +2.24420000E-04  +3.21050000E-04  +1.87100000E-05
   +3.14700000E-05  -1.64200000E-05  +2.12600000E-05  +1.81000000E-05  +6.98000000E-06
   -3.54000000E-06  -2.92200000E-05  +1.41900000E-05  -4.99000000E-06  +9.86000000E-06
   -5.00000000E-07  +3.68800000E-05  -6.99000000E-05  -2.44500000E-05  -5.83749000E-03
   +1.35596000E-03  +1.76169000E-03  +7.68360000E-04  +5.52720000E-04  -6.44920000E-04
   -2.69031010E-01  +8.89672200E-02  +5.47684500E-02  -9.57900000E-05  -3.23620000E-04
   +5.37080000E-04  -4.54400000E-05  -1.76260000E-04  +2.67420000E-04  +1.45850000E-04
   +1.80530000E-04  -1.63030000E-04  +1.02180000E-04  +8.00000000E-08  -8.43500000E-05
   -4.71400000E-05  -2.41000000E-05  +7.54000000E-06  -1.88000000E-04  -9.15000000E-05
   +2.49900000E-04  +2.05380000E-04  +2.15940000E-04  -3.88920000E-04  -2.67000000E-05
   +5.79000000E-06  +2.50700000E-05  -2.32580000E-04  +1.40520000E-04  +2.86300000E-05
   -1.09010000E-04  +1.65750000E-04  -5.37400000E-05  +6.24900000E-05  +6.43100000E-05
   -4.31800000E-05  -1.80599500E-02  +8.23409000E-03  +5.05777000E-03  +7.73590000E-04
   -9.69700000E-04  -5.84390000E-04  +2.89445950E-01  +1.42227000E-03  +7.97460000E-04
   -2.84960000E-04  -2.87310000E-04  +1.49910000E-04  +6.58300000E-05  -1.65800000E-04
   -8.65700000E-05  +7.19500000E-05  -2.27440000E-04  -1.98500000E-04  +8.33100000E-05
   +1.37770000E-04  +6.99100000E-05  -7.74400000E-05  -1.73300000E-04  -1.47350000E-04
   -5.40890000E-04  +3.54500000E-05  -3.28400000E-05  +7.23000000E-05  +1.74100000E-05
   -4.21000000E-06  -8.36000000E-06  +2.39180000E-04  +2.35370000E-04  +5.27400000E-05
   +7.05000000E-06  -6.60000000E-06  +9.62000000E-06  +1.47800000E-05  +5.94700000E-05
   +1.49340000E-04  +2.38630000E-02  -1.20926800E-02  -5.68438000E-03  -4.98470000E-04
   -3.51510000E-03  +3.88265000E-03  +8.67186200E-02  -8.05237900E-02  -2.23829700E-02
   -1.46900000E-04  +4.21970000E-04  -1.35496000E-03  -6.90040000E-04  -2.95730000E-04
   +6.36960000E-04  +1.45410000E-04  +2.28170000E-04  -9.00100000E-05  -2.47470000E-04
   +4.85500000E-05  +9.52600000E-05  +2.57700000E-05  -1.71880000E-04  -6.61100000E-05
   +1.55306000E-03  -3.23600000E-04  -3.30600000E-04  -1.09650000E-04  +1.98750000E-04
   -3.98390000E-04  +4.99600000E-05  -1.15900000E-05  -5.72000000E-06  +2.34390000E-04
   -9.04600000E-05  -1.00750000E-04  +1.81560000E-04  -2.80460000E-04  +8.29700000E-05
   +7.77000000E-06  +5.20100000E-05  +5.78000000E-05  -2.13509500E-02  +9.35938000E-03
   +6.08660000E-03  +7.10950000E-03  -3.58873000E-03  -1.45205000E-03  -9.71068200E-02
   +8.91547200E-02  -4.42190000E-04  -3.60920000E-04  +4.66120000E-04  -1.57720000E-04
   -1.85090000E-04  +1.46460000E-04  +9.82500000E-05  +1.05660000E-04  +2.20800000E-05
   +1.01440000E-04  +1.11800000E-05  -1.77960000E-04  -3.48340000E-04  -6.31800000E-05
   +1.05420000E-04  +3.32600000E-04  +7.03600000E-05  -2.96560000E-04  +2.60900000E-05
   +1.64700000E-05  -6.70100000E-05  -4.86000000E-06  +9.50000000E-07  +1.05900000E-05
   -1.10840000E-04  -7.80700000E-05  -9.50000000E-06  +2.05200000E-05  -1.55100000E-05
   +3.70000000E-07  +3.72800000E-05  +6.56000000E-06  +1.17800000E-04  -1.75769600E-02
   +7.42118000E-03  +2.62301000E-03  +2.28050000E-04  +2.71750000E-03  -2.21528000E-03
   +5.59044100E-02  -2.33212200E-02  -6.06752800E-02  -1.24695000E-03  +4.17290000E-04
   +1.11100000E-03  +6.21330000E-04  +4.52660000E-04  -2.26610000E-04  -1.82880000E-04
   -1.59100000E-05  +2.30520000E-04  +3.94000000E-06  -1.41170000E-04  +2.19300000E-05
   +1.04030000E-04  +1.19820000E-04  -1.20070000E-04  -1.04899000E-03  +6.32390000E-04
   +4.32250000E-04  -6.21800000E-05  -5.49070000E-04  -2.59700000E-05  -4.18000000E-06
   +2.17600000E-05  +2.07100000E-05  -1.39200000E-05  -3.07800000E-05  +1.02300000E-05
   -7.86500000E-05  +1.03400000E-04  -4.24400000E-05  -4.28000000E-06  -4.87600000E-05
   +1.92400000E-05  -5.61775000E-03  +2.39194000E-03  +4.51790000E-04  +2.89107800E-02
   -1.06159800E-02  -5.77036000E-03  -5.99642400E-02  +2.10261700E-02  +6.43509200E-02
   +6.58790000E-04  +1.22120000E-04  +8.61500000E-05  -1.45170000E-04  -1.14810000E-04
   +3.87910000E-04  +1.69870000E-04  -5.63600000E-05  -2.47230000E-04  +8.09000000E-05
   +8.55000000E-05  -7.53000000E-06  -6.77300000E-05  -3.97200000E-05  -1.04900000E-04
   +9.62600000E-05  -7.89000000E-06  +2.82930000E-04  +1.54140000E-04  +1.63920000E-04
   -4.59300000E-04  -1.33400000E-05  -1.92100000E-05  +2.06900000E-05  -1.55050000E-04
   -1.45340000E-04  -7.57600000E-05  -3.25700000E-05  +1.09600000E-05  -1.87200000E-05
   +7.69400000E-05  -2.78300000E-05  -6.72600000E-05  -1.76392000E-03  -4.91000000E-05
   +9.19200000E-04  +7.37040000E-04  +1.30513000E-03  +4.10510000E-04  -2.29940000E-04
   -9.19400000E-05  +3.39100000E-04  -2.11787810E-01  -1.31035340E-01  -1.98717800E-02
   +1.97860000E-04  -1.54480000E-04  +8.66900000E-05  +1.06500000E-04  -6.93700000E-05
   -7.03400000E-05  +2.73000000E-06  +1.15320000E-04  -1.18610000E-04  -2.42590000E-04
   +4.49000000E-06  -1.46200000E-05  +3.51300000E-04  -2.13230000E-04  +4.19600000E-05
   +3.38200000E-05  -1.45300000E-05  -2.10300000E-05  +2.86400000E-05  -1.19800000E-05
   -2.96000000E-06  +5.14200000E-05  -2.29300000E-05  +9.09000000E-06  +1.06500000E-05
   -3.65600000E-05  +9.22000000E-06  +2.29600000E-05  +3.89300000E-05  +4.76300000E-05
   +2.38680000E-04  +4.30340000E-04  -4.75830000E-04  +2.47500000E-04  +2.80730000E-04
   +4.96000000E-05  +2.64300000E-05  -1.30260000E-04  +1.53800000E-05  +2.26651090E-01
   +6.20380000E-04  +1.97830000E-04  -2.30644000E-03  +1.19470000E-04  +2.79530000E-04
   -1.95040000E-04  -2.70900000E-05  +1.23730000E-04  -3.21100000E-05  +2.41130000E-04
   +1.29510000E-04  -6.50100000E-05  -6.36800000E-05  -2.26390000E-04  -1.51820000E-04
   -7.27670000E-04  -2.87900000E-05  +2.09150000E-04  +2.75860000E-04  -2.35240000E-04
   +6.46100000E-05  -4.40600000E-05  -6.00000000E-06  +1.86000000E-06  -2.12580000E-04
   -2.05390000E-04  -3.25400000E-05  -2.61100000E-05  -9.03000000E-05  +4.26000000E-06
   +1.52100000E-05  +4.05700000E-05  -7.45800000E-05  -8.06895000E-03  -8.51476000E-03
   -1.07737000E-03  -8.65490000E-04  +4.43480000E-04  +2.23960000E-04  +7.00550000E-04
   +3.87180000E-04  +8.99340000E-04  -1.29894420E-01  -1.50535800E-01  -1.46673400E-02
   +3.31760000E-04  +1.40170000E-04  -3.11700000E-05  +1.43950000E-04  +8.73000000E-06
   -7.63200000E-05  +1.34370000E-04  -3.82100000E-05  -9.73600000E-05  +1.48400000E-05
   -5.14300000E-05  +4.56500000E-05  +1.18140000E-04  -4.57010000E-04  +4.23070000E-04
   -3.69200000E-05  -1.40000000E-05  -3.86300000E-05  -3.12000000E-06  -5.58000000E-06
   -5.15000000E-06  -1.42630000E-04  +9.61800000E-05  +4.60600000E-05  -4.59900000E-05
   +4.00300000E-05  -2.88000000E-05  -7.45300000E-05  +1.53550000E-04  -9.14100000E-05
   -1.19300000E-05  +4.83970000E-04  +1.65000000E-04  +1.96960000E-04  +1.79300000E-05
   -3.57300000E-05  +9.42400000E-05  +3.61200000E-05  +2.10300000E-05  +1.42885300E-01
   +1.60962050E-01  +1.28973000E-03  -8.24300000E-04  -5.88568000E-03  +1.00333000E-03
   +1.63240000E-04  -6.99370000E-04  -2.24540000E-04  -9.88400000E-05  +2.44060000E-04
   +1.59960000E-04  +1.90630000E-04  +4.89200000E-05  +1.35710000E-04  -1.99800000E-04
   -4.06770000E-04  -1.63255000E-03  -1.21662000E-03  +1.82130000E-04  -1.09190000E-04
   +2.94030000E-04  +4.64030000E-04  -3.10000000E-05  -3.84500000E-05  -1.58000000E-06
   -1.70410000E-04  -1.21640000E-04  +1.61700000E-05  -1.25750000E-04  -9.67400000E-05
   -3.30700000E-05  +2.50000000E-07  +4.81900000E-05  -3.49000000E-06  -2.43754600E-02
   -1.99635600E-02  -4.98428000E-03  -1.24729000E-03  +7.37400000E-05  +7.60220000E-04
   -7.80370000E-04  -1.30822000E-03  +1.28891000E-03  -1.78955800E-02  -1.32865300E-02
   -4.79301000E-02  -2.94000000E-05  +1.22560000E-04  +2.35820000E-04  +2.58940000E-04
   -8.81800000E-05  -9.29200000E-05  +1.87760000E-04  +1.30530000E-04  -2.33410000E-04
   -3.47980000E-04  -1.77610000E-04  +1.74930000E-04  +4.16530000E-04  -6.75900000E-05
   +1.10300000E-05  +2.87000000E-06  +3.44200000E-05  -1.04900000E-04  -7.99000000E-06
   -1.07500000E-05  +5.65000000E-06  -2.49410000E-04  +1.16660000E-04  +6.23300000E-05
   -4.02100000E-05  +8.75000000E-05  -2.58600000E-05  +1.33400000E-05  +2.52100000E-05
   +2.56000000E-05  +1.96620000E-04  +7.30540000E-04  -5.05140000E-04  +3.52180000E-04
   +8.48100000E-05  +2.81890000E-04  +7.77300000E-05  +6.92500000E-05  -6.22600000E-05
   +2.05934500E-02  +1.81276400E-02  +5.52187200E-02  -5.51600000E-05  -1.79680000E-04
   +1.72930000E-04  -7.29040000E-04  -1.16844000E-03  +3.20870000E-04  +1.69380000E-04
   -5.96600000E-05  -2.80410000E-04  -1.58220000E-04  -4.09400000E-05  -2.68000000E-06
   +2.53500000E-05  +2.78000000E-06  -5.00000000E-08  +1.30660000E-04  +1.48860000E-04
   +3.65900000E-05  -5.10260000E-04  -1.42890000E-03  -5.81810000E-04  +3.24500000E-05
   -7.39000000E-06  +2.05400000E-05  +6.37000000E-05  +3.97600000E-05  -3.04500000E-05
   +8.91000000E-06  +2.01800000E-05  -2.60000000E-07  -8.41000000E-06  -4.02000000E-06
   -2.39000000E-05  +1.12283000E-03  -1.27690000E-03  -9.70600000E-04  +3.77730000E-04
   +3.98810000E-04  +6.17140000E-04  +4.26770000E-04  -2.40800000E-04  -5.03320000E-04
   -2.31736700E-01  +1.10761720E-01  +5.29592100E-02  +5.77050000E-04  +3.09590000E-04
   -1.23630000E-04  -4.75200000E-05  +1.04180000E-04  -4.86500000E-05  +2.41270000E-04
   -1.20960000E-04  -7.21000000E-05  -7.27800000E-05  -2.23420000E-04  +1.43940000E-04
   +2.77190000E-04  -3.22590000E-04  +2.83750000E-04  -4.17000000E-05  -6.57800000E-05
   -1.19800000E-05  -3.29700000E-05  +4.33000000E-06  +3.15000000E-06  -3.26310000E-04
   +1.57020000E-04  +7.30800000E-05  -8.88800000E-05  +1.53750000E-04  -6.32000000E-05
   -3.35900000E-05  -2.88800000E-05  -3.53900000E-05  -1.89540000E-04  +7.51100000E-05
   +1.19560000E-04  +2.18310000E-04  -2.17600000E-04  -1.26800000E-05  +3.20030000E-04
   -1.94480000E-04  +2.12000000E-04  -1.92728500E-02  +1.34456500E-02  +5.47661000E-03
   +2.51812280E-01  +5.18950000E-04  +3.69230000E-04  +2.81620000E-04  +4.34300000E-05
   -3.62370000E-04  -8.80420000E-04  -2.58780000E-04  +4.56500000E-05  +3.61990000E-04
   -3.93000000E-05  -3.76400000E-05  +6.54200000E-05  +1.12560000E-04  +1.18690000E-04
   +7.09500000E-05  -2.36270000E-04  -9.59600000E-05  -1.01540000E-04  -1.03318000E-03
   -1.57288000E-03  +1.98920000E-04  +2.74000000E-06  -1.92800000E-05  -2.34200000E-05
   +9.18900000E-05  +1.22550000E-04  +8.71600000E-05  +4.76000000E-06  -5.91000000E-06
   +1.26600000E-05  +9.16000000E-06  +2.70500000E-05  +1.23010000E-04  +8.89722000E-03
   -5.87920000E-03  -1.34057000E-03  -2.79600000E-05  +2.64710000E-04  -2.37416000E-03
   -2.76320000E-04  +3.30620000E-04  +1.15107000E-03  +1.09568260E-01  -1.13897640E-01
   -3.16011300E-02  -4.30850000E-04  -3.36590000E-04  +1.79040000E-04  +5.98270000E-04
   -3.53580000E-04  +9.83600000E-05  -6.18000000E-06  +5.05640000E-04  -3.64050000E-04
   -5.83660000E-04  +2.31310000E-04  -8.44000000E-06  +4.08390000E-04  -2.30790000E-04
   -2.17740000E-04  -4.27800000E-05  +4.87000000E-06  -8.46500000E-05  +7.88700000E-05
   +1.19000000E-06  +3.49600000E-05  +2.72750000E-04  -1.62080000E-04  -2.10700000E-05
   +7.39500000E-05  -1.61640000E-04  +5.86900000E-05  +8.46800000E-05  +2.61700000E-04
   +1.86410000E-04  -1.64990000E-04  -3.06300000E-05  -9.11000000E-05  -1.98000000E-04
   -8.51400000E-05  -3.53000000E-06  -1.28550000E-04  +5.00700000E-04  +9.01700000E-05
   -1.70499300E-02  +1.12247200E-02  +5.43298000E-03  -1.20090920E-01  +1.20490900E-01
   +3.56640000E-04  +6.14990000E-04  +8.68550000E-04  -2.63640000E-04  +1.35350000E-04
   +2.77910000E-04  -1.93620000E-04  -9.53100000E-05  -3.73800000E-05  -1.35740000E-04
   -4.87800000E-05  +1.98480000E-04  +1.65790000E-04  +1.36400000E-04  +1.06900000E-05
   -1.40230000E-04  +5.15900000E-05  -2.74750000E-04  -1.73310000E-04  -2.83250000E-04
   +3.10400000E-04  +6.69000000E-06  -1.11700000E-05  -2.12000000E-06  +7.95900000E-05
   +7.46600000E-05  +4.24000000E-06  +2.37300000E-05  -1.67200000E-05  +8.87000000E-06
   +4.88000000E-05  -5.64000000E-06  +7.03600000E-05  +2.63596900E-02  -1.45404000E-02
   -8.07419000E-03  -1.36809000E-03  -1.20460000E-03  -5.34783000E-03  +1.25656000E-03
   -8.98240000E-04  +1.33450000E-03  +5.21254700E-02  -3.05885500E-02  -6.29308500E-02
   +5.14920000E-04  -6.41180000E-04  -2.98800000E-05  +3.11720000E-04  +2.37200000E-05
   +3.85440000E-04  -3.68430000E-04  +1.92040000E-04  +9.51000000E-06  +3.89430000E-04
   +3.20730000E-04  -1.06900000E-05  +9.82000000E-05  +2.45860000E-04  +4.81300000E-05
   -3.77400000E-05  -6.91000000E-05  -2.22760000E-04  +1.07880000E-04  -1.83300000E-05
   -1.11500000E-05  +6.35710000E-04  -3.52900000E-04  -1.41640000E-04  +9.98600000E-05
   -1.81670000E-04  +3.67200000E-05  -1.58860000E-04  -2.91270000E-04  -1.19940000E-04
   +1.21000000E-05  +1.33740000E-04  -6.38700000E-05  -2.79010000E-04  +1.28000000E-06
   +4.35180000E-04  -6.75860000E-04  +4.49270000E-04  -6.34380000E-04  -2.49158000E-03
   +1.94660000E-03  -1.16980000E-04  -5.82497700E-02  +3.57390900E-02  +6.84871400E-02
   +2.67950000E-04  +5.70010000E-04  -1.96020000E-04  +4.27200000E-05  -2.07490000E-04
   -6.81540000E-04  -1.02720000E-04  -6.70600000E-05  +2.61350000E-04  -7.56500000E-05
   -1.98300000E-05  +4.00800000E-05  +1.05760000E-04  +9.48600000E-05  +4.27200000E-05
   -9.14200000E-05  -9.31000000E-05  -6.53500000E-05  -1.20180000E-03  +2.02610000E-04
   -2.58820000E-04  -4.60000000E-06  +6.64000000E-06  -2.43100000E-05  +9.45100000E-05
   +1.10490000E-04  +6.56700000E-05  +5.51000000E-06  +4.84000000E-06  +1.02400000E-05
   -2.33200000E-05  +3.06600000E-05  +7.14100000E-05  -2.04268000E-03  +1.12192000E-03
   -7.42240000E-04  +1.30470000E-04  -8.03340000E-04  +3.47150000E-04  +2.02200000E-05
   -3.89560000E-04  -5.09730000E-04  -5.14328900E-02  +2.59786500E-02  -2.11388900E-02
   -1.59500000E-04  +2.38600000E-05  +8.16800000E-05  +1.35210000E-04  -7.54600000E-05
   +3.68800000E-05  -1.66400000E-05  +1.16130000E-04  -4.94300000E-05  -2.56620000E-04
   +9.96300000E-05  -2.87600000E-05  -1.02100000E-04  +1.42000000E-04  +1.93380000E-04
   +1.21200000E-05  +8.09000000E-06  -5.61200000E-05  +4.62000000E-06  -6.98000000E-06
   -1.21600000E-05  +6.74100000E-05  -3.61600000E-05  -2.23400000E-05  +4.18500000E-05
   -5.93400000E-05  +4.86800000E-05  +1.82020000E-04  +2.65820000E-04  +2.10630000E-04
   +9.46300000E-05  +3.42370000E-04  -5.57600000E-05  +6.24950000E-04  +2.20200000E-04
   -1.60450000E-04  +3.65230000E-04  -2.99500000E-04  +2.26020000E-04  +3.74435000E-03
   -1.91796200E-02  +1.70351600E-02  -2.59591000E-03  +1.99246500E-02  -1.79221000E-02
   +5.22347900E-02  -2.65860000E-04  +4.83550000E-04  +2.63000000E-04  -7.64000000E-04
   +1.42970000E-04  +1.14160000E-04  +5.99100000E-05  -1.03800000E-05  -1.87900000E-04
   -7.42500000E-05  -1.03970000E-04  +6.79000000E-05  +5.22700000E-05  +3.56200000E-05
   -2.37200000E-05  +2.23660000E-04  +9.58900000E-05  +1.99200000E-05  -1.80260000E-04
   -1.05730000E-04  -3.09690000E-04  -1.24700000E-05  +3.89100000E-05  -6.52000000E-06
   +7.74200000E-05  +4.50300000E-05  -1.73500000E-05  +1.91500000E-05  +9.75000000E-06
   +5.49000000E-06  +5.13000000E-06  +6.76000000E-06  -3.17500000E-05  -1.21318000E-03
   +8.22722000E-03  -7.46146000E-03  -8.30400000E-05  +6.03160000E-04  +3.32600000E-05
   -1.76020000E-04  -4.39900000E-05  -1.62141000E-03  +2.62674700E-02  -2.03824830E-01
   +1.31095820E-01  -1.05840000E-04  -2.65200000E-05  +1.54120000E-04  +4.26400000E-05
   +1.87200000E-05  -7.65600000E-05  +4.32800000E-05  +4.17800000E-05  +2.22700000E-05
   -1.88940000E-04  -1.25720000E-04  +5.62300000E-05  +3.29950000E-04  -8.49200000E-05
   -6.88310000E-04  +1.95000000E-05  +6.33000000E-06  -4.67600000E-05  -1.16500000E-05
   -4.50000000E-07  +4.45000000E-06  -1.17890000E-04  +4.93000000E-05  +1.77600000E-05
   -1.92400000E-05  +5.88900000E-05  -1.39800000E-05  +2.16990000E-04  -5.37600000E-04
   -4.06790000E-04  +2.03740000E-04  +2.14910000E-04  -2.52490000E-04  -6.35800000E-05
   +6.43250000E-04  -3.04290000E-04  -1.83560000E-04  +3.85000000E-06  -1.65490000E-04
   +3.80388000E-03  -1.43603600E-02  +1.17989800E-02  +1.04890000E-04  -1.12937600E-02
   +9.13943000E-03  -2.80234200E-02  +2.19814870E-01  +8.68640000E-04  +9.35930000E-04
   +1.34944000E-03  +1.11020000E-04  -1.18360000E-04  +1.15110000E-04  -2.37910000E-04
   -2.92380000E-04  +6.26200000E-05  -1.52330000E-04  +6.66200000E-05  +2.88860000E-04
   +2.45220000E-04  +2.10550000E-04  +3.31000000E-06  +8.21400000E-05  -4.71080000E-04
   -2.06910000E-04  -4.73050000E-04  +7.79300000E-05  +1.01160000E-04  -1.94100000E-05
   -1.05900000E-05  -1.65300000E-05  +3.05400000E-05  +3.06600000E-05  +1.05000000E-06
   -2.51900000E-05  +3.42000000E-05  -2.07600000E-05  -4.13300000E-05  +8.40000000E-05
   +5.57700000E-05  -3.37961000E-03  +2.38496600E-02  -1.84763000E-02  -1.56551000E-03
   +6.98120000E-04  +9.68840000E-04  +2.34940000E-04  -3.47929000E-03  -5.98404000E-03
   -2.05286600E-02  +1.28969310E-01  -1.55686060E-01  +8.55330000E-04  +9.58600000E-05
   -2.82050000E-04  -5.46490000E-04  +3.79000000E-04  +1.21100000E-05  -1.87470000E-04
   -4.75940000E-04  +3.54670000E-04  +7.25190000E-04  -3.89150000E-04  +8.75600000E-05
   +1.01830000E-04  +6.61410000E-04  -8.00400000E-05  -1.38580000E-04  -5.22400000E-05
   +7.25700000E-05  -1.39600000E-05  -7.13000000E-06  -2.69900000E-05  -7.09000000E-05
   +1.76700000E-05  +3.29000000E-06  -6.32000000E-06  +8.11700000E-05  -4.26700000E-05
   -4.41700000E-05  -8.04210000E-04  -1.56640000E-04  +1.60120000E-04  -1.82300000E-04
   +2.55130000E-04  -4.92950000E-04  +1.62888000E-03  -1.32435000E-03  -9.12500000E-05
   -1.19860000E-04  +1.72090000E-04  +7.38680000E-04  -3.14351000E-03  +2.08799000E-03
   +5.76640000E-04  -7.05452000E-03  +5.48479000E-03  +2.32711800E-02  -1.41182390E-01
   +1.70833070E-01  +5.06400000E-05  -1.34450000E-04  -5.74200000E-05  -1.52100000E-05
   -7.42000000E-06  +4.74000000E-05  +4.13700000E-05  +6.61800000E-05  +4.50300000E-05
   -1.35560000E-04  -1.25250000E-04  -5.94300000E-05  +3.18300000E-05  -1.79300000E-05
   -4.34300000E-05  +1.20500000E-05  -5.10000000E-07  +4.88300000E-05  -1.05500000E-05
   -1.06100000E-05  -7.70000000E-07  +1.76200000E-05  +1.38700000E-05  -9.29000000E-06
   +1.70800000E-04  +1.41370000E-04  +3.46200000E-05  -4.91000000E-06  +5.41000000E-06
   +5.18000000E-06  -2.55500000E-05  +2.98000000E-06  -4.94800000E-05  -1.69640000E-04
   +1.37110000E-04  -1.07590000E-04  +4.90650000E-04  +4.07520000E-04  -3.94670000E-04
   +7.63300000E-05  +4.81000000E-06  -2.80200000E-05  +1.50080000E-04  -4.95800000E-05
   +2.72000000E-05  -8.99660000E-04  -2.97850000E-04  +3.00630000E-04  +4.09266000E-03
   -2.21393000E-03  -1.10471000E-03  -3.06191600E-02  -2.12799300E-02  +2.77720100E-02
   -3.92558000E-03  +4.55994000E-03  +2.77400000E-05  +1.48770000E-04  -1.24895000E-03
   +1.51599000E-03  +2.00020000E-04  -1.52510000E-04  -2.85300000E-05  -1.24290000E-04
   +1.58435000E-03  -6.67180000E-04  -1.98385630E-01  -1.20841900E-01  +1.76143040E-01
   -1.20280000E-04  +2.70430000E-04  -2.94190000E-04  -3.04450000E-04  +1.90720000E-04
   -5.43700000E-05  -1.19200000E-05  +3.86500000E-05  +1.14400000E-05  -3.35700000E-05
   +1.68000000E-06  -1.34000000E-05  +4.97300000E-05  -1.89500000E-05  -1.05500000E-05
   -1.17600000E-05  +2.03200000E-05  +3.10100000E-05  +4.54800000E-05  -4.06000000E-05
   -6.41900000E-05  -1.18600000E-05  +1.00500000E-05  +1.22200000E-05  +2.29014450E-01
   +2.24600000E-05  +6.17000000E-06  +2.21100000E-05  +8.70000000E-07  -8.37000000E-06
   -8.01000000E-06  -5.48000000E-06  -6.35000000E-06  -1.30500000E-05  +3.24900000E-05
   +2.99800000E-05  +1.16600000E-05  -5.12000000E-06  -4.82000000E-06  +1.12100000E-05
   +1.85000000E-06  -4.00000000E-08  +5.55000000E-06  +7.15000000E-06  +9.30000000E-07
   -2.76000000E-06  -3.54000000E-06  -1.31000000E-06  +9.20000000E-07  -3.61900000E-05
   -3.67900000E-05  -1.08600000E-05  -5.75000000E-06  -1.90000000E-07  -3.88000000E-06
   +1.22000000E-06  +1.36100000E-05  +1.42000000E-06  -5.89500000E-05  -5.95800000E-05
   -1.47700000E-05  -1.47450000E-04  -3.33660000E-04  +3.82340000E-04  -1.64000000E-05
   +3.06100000E-05  -9.56000000E-06  +4.24500000E-05  -1.68800000E-05  +1.29300000E-05
   +7.14000000E-05  -6.50090000E-04  -5.17800000E-05  +2.54761000E-03  +1.42341000E-03
   -2.68758000E-03  +1.68241900E-02  +9.77756000E-03  -1.63518800E-02  +3.89623000E-03
   -1.53689000E-03  +2.64000000E-06  +2.44130000E-04  +1.22818000E-03  +1.51520000E-04
   +3.25200000E-05  -3.72800000E-05  -2.29500000E-05  -7.01430000E-04  -9.97910000E-04
   +1.34020000E-03  -1.62018160E-01  -1.74971550E-01  +1.91284630E-01  +1.04290000E-04
   +9.29900000E-05  -3.36070000E-04  +1.21510000E-04  -1.36170000E-04  -1.01990000E-04
   -4.26000000E-06  -2.97600000E-05  -1.25300000E-05  +1.33900000E-05  +9.94000000E-06
   +9.00000000E-06  -1.56200000E-05  -2.62000000E-06  +9.43000000E-06  +2.98000000E-06
   -8.36000000E-06  +3.07000000E-06  -1.76000000E-06  +9.74000000E-06  -2.34900000E-05
   +6.03000000E-06  +3.07000000E-06  -7.56000000E-06  +1.39372100E-01  +1.65878560E-01
   +1.56600000E-05  +6.37000000E-05  +2.81000000E-06  -8.52000000E-06  -1.10300000E-05
   -2.07200000E-05  -1.21300000E-05  -2.32700000E-05  -2.51800000E-05  +4.69900000E-05
   +4.68600000E-05  +2.93500000E-05  -1.32100000E-05  +5.00000000E-07  +1.52400000E-05
   -2.33600000E-05  -1.12000000E-05  +8.66000000E-06  +1.13300000E-05  +4.85000000E-06
   -6.62000000E-06  -5.34000000E-06  -6.25000000E-06  +2.23000000E-06  -6.56800000E-05
   -6.07200000E-05  -2.14200000E-05  -1.14300000E-05  -5.85000000E-06  -5.58000000E-06
   +1.33800000E-05  +1.79400000E-05  +3.12300000E-05  +1.26580000E-04  -4.95200000E-05
   +3.84200000E-05  -1.34880000E-04  +6.09700000E-05  +2.98800000E-05  -4.08400000E-05
   -9.47000000E-06  +2.89800000E-05  -1.05830000E-04  +5.75700000E-05  -2.24500000E-05
   +6.64200000E-05  +1.30440000E-04  -8.04930000E-04  -4.07702000E-03  -2.55140000E-04
   +1.51982000E-03  +3.80724000E-03  +3.22146000E-03  -6.48929000E-03  +3.83700000E-04
   -3.31740000E-04  +1.68511000E-03  +6.21430000E-04  +8.60430000E-04  +7.59250000E-04
   -1.42100000E-04  +6.91800000E-05  -1.76200000E-05  +7.79760000E-04  +1.61520000E-04
   +2.45000000E-05  +2.02037320E-01  +1.70180090E-01  -2.13387900E-01  -1.84220000E-04
   -4.19680000E-04  -2.92000000E-06  -1.87100000E-05  -1.29190000E-04  -9.32100000E-05
   +5.88000000E-06  -1.40600000E-05  +5.88000000E-06  +4.63000000E-06  -5.52000000E-06
   -6.92000000E-06  -1.38500000E-05  +2.02100000E-05  +7.80000000E-07  +4.15000000E-06
   -2.87400000E-05  -1.08700000E-05  -2.75500000E-05  +2.63000000E-05  +4.12500000E-05
   +1.28900000E-05  +4.30000000E-07  -1.18300000E-05  -2.03083480E-01  -1.73500990E-01
   +2.16779450E-01  +5.28890000E-04  +3.33400000E-05  -5.07460000E-04  -1.00630000E-03
   -1.32700000E-05  +3.82990000E-04  +3.40499000E-03  +3.40455000E-03  +1.82720000E-04
   -2.72395100E-02  -5.21721000E-03  +2.87672800E-02  -1.86256000E-03  -4.58252000E-03
   -2.95845000E-03  +1.64240000E-04  -1.01430000E-04  +1.98218000E-03  +1.46350000E-04
   +1.80490000E-04  +7.94100000E-05  +1.06290000E-04  -9.06640000E-04  -1.08791000E-03
   -2.09881870E-01  -5.21138800E-02  +2.23718790E-01  +5.22700000E-05  +2.77380000E-04
   -2.88110000E-04  -2.91580000E-04  -1.41540000E-04  -1.87700000E-04  -1.50130000E-04
   -8.67400000E-05  -1.55340000E-04  +2.35900000E-05  +1.48750000E-04  +3.16400000E-05
   +1.32270000E-04  +5.37400000E-05  +5.63200000E-05  +6.60500000E-05  +2.07600000E-05
   -2.32500000E-05  -1.58000000E-06  -2.34900000E-05  +3.07100000E-05  +3.97700000E-05
   -5.27100000E-05  -8.90000000E-07  -1.09830000E-04  +6.52900000E-05  +1.11500000E-05
   -2.78900000E-05  +1.31570000E-04  -5.25100000E-05  +2.49500000E-05  -6.04300000E-05
   +5.13700000E-05  -9.86000000E-06  +6.89000000E-06  +4.76000000E-06  +1.81900000E-05
   -3.66000000E-06  -1.13500000E-05  +1.66600000E-04  -7.38900000E-05  -3.65000000E-05
   +2.88300000E-05  -9.28400000E-05  +3.43600000E-05  -3.68200000E-05  +1.47400000E-05
   -3.83100000E-05  +2.98500000E-05  +7.50500000E-05  -2.90600000E-05  -5.79000000E-06
   -1.45400000E-05  -1.41000000E-06  -2.84000000E-06  -3.34900000E-05  +1.49300000E-05
   +3.88400000E-05  +2.89900000E-05  +6.26000000E-06  -4.01000000E-06  -3.13600000E-05
   -1.09100000E-05  -2.94600000E-05  -2.51000000E-06  -1.34100000E-05  -3.24200000E-05
   +4.86000000E-06  +1.04900000E-05  +2.35727950E-01  +3.52140000E-04  +1.50400000E-05
   -5.81560000E-04  -2.03110000E-04  -6.99470000E-04  +2.75910000E-04  +9.81530000E-04
   +7.36340000E-04  +1.83679000E-03  -2.25644200E-02  -7.36840000E-03  +2.61833900E-02
   -3.90427000E-03  -2.13969000E-03  -2.75911000E-03  -8.34180000E-04  +1.47589000E-03
   +8.97580000E-04  +9.38100000E-05  +5.85000000E-05  +5.50700000E-05  +2.00840000E-04
   -7.81600000E-05  -1.61606000E-03  -3.34414900E-02  -2.56758800E-02  +7.75259000E-03
   +2.50300000E-04  -2.72050000E-04  +1.45490000E-04  -8.75400000E-05  -3.16780000E-04
   -3.50300000E-05  -4.85200000E-05  -8.31200000E-05  -9.82500000E-05  -3.02700000E-05
   +8.73900000E-05  +4.41000000E-06  +6.16600000E-05  +3.57800000E-05  +2.93100000E-05
   +4.99300000E-05  +3.29900000E-05  +2.57000000E-06  +1.46100000E-05  -2.92600000E-05
   +1.26300000E-05  +1.28500000E-05  -3.37200000E-05  +1.26200000E-05  -6.44400000E-05
   +3.41000000E-05  +8.95000000E-06  -3.19300000E-05  +1.42750000E-04  -7.02900000E-05
   +2.16300000E-05  -4.58200000E-05  +2.13600000E-05  -1.57100000E-05  -2.21000000E-06
   +8.14000000E-06  +1.28200000E-05  -4.93000000E-06  -5.38000000E-06  +1.18780000E-04
   -6.40900000E-05  -2.41000000E-05  +6.08600000E-05  -1.09860000E-04  +4.39300000E-05
   -2.71600000E-05  +3.64000000E-05  -1.47700000E-05  +1.94800000E-05  +4.69500000E-05
   +4.68000000E-06  -1.36600000E-05  -1.28800000E-05  +1.11700000E-05  -9.00000000E-08
   -3.24400000E-05  -6.83000000E-06  +2.77300000E-05  +2.63000000E-05  +1.23000000E-06
   +6.88000000E-06  -3.87700000E-05  -1.66700000E-05  -2.37300000E-05  +2.97000000E-06
   -4.77000000E-06  -1.95200000E-05  +6.93000000E-06  +7.49000000E-06  +5.90673500E-02
   +3.42329800E-02  -4.97500000E-05  -1.28400000E-04  -2.69070000E-04  +1.24800000E-04
   +3.55100000E-05  -8.02930000E-04  -4.87143000E-03  -2.00972000E-03  +2.62766000E-03
   -8.22523000E-03  -2.15524000E-03  +6.32349000E-03  -1.80294000E-03  -1.87127000E-03
   +1.16383000E-03  +4.94100000E-04  -1.92500000E-04  +4.15770000E-04  -1.00970000E-04
   -7.70200000E-05  -5.06100000E-05  +1.14021000E-03  +1.18780000E-04  -1.03178000E-03
   +2.63717240E-01  +3.83139600E-02  -3.50227250E-01  -3.69320000E-04  +8.06000000E-05
   +1.87150000E-04  -9.91800000E-05  +2.77300000E-05  -6.39000000E-06  +1.33590000E-04
   +2.46900000E-05  +1.17400000E-05  +2.72000000E-06  -2.10100000E-05  -2.73100000E-05
   -7.86900000E-05  -4.92500000E-05  -5.17000000E-05  -2.03600000E-05  -1.72000000E-06
   +3.43500000E-05  -1.30700000E-05  +6.54000000E-06  -2.42000000E-06  -6.40000000E-07
   +8.11000000E-06  -2.05000000E-06  -1.64000000E-06  -3.27000000E-06  +2.36000000E-06
   +9.67000000E-06  -3.58500000E-05  +1.44200000E-05  -2.21100000E-05  +9.68000000E-06
   +4.42000000E-06  +3.89000000E-06  +1.15000000E-06  -3.98000000E-06  -1.44000000E-06
   +3.00000000E-06  +1.97000000E-06  -1.54800000E-05  +1.01500000E-05  +5.30000000E-07
   -2.04500000E-05  +2.82900000E-05  -8.09000000E-06  +1.04300000E-05  -1.77500000E-05
   +1.39900000E-05  -1.14500000E-05  -3.59700000E-05  +2.42700000E-05  +4.73000000E-06
   +3.39000000E-06  -1.92000000E-06  -4.08000000E-06  +1.70900000E-05  +3.19000000E-06
   +5.88000000E-06  -8.14000000E-06  -1.41100000E-05  +8.50000000E-06  -1.31700000E-05
   +5.49000000E-06  -1.04400000E-05  +1.23700000E-05  -4.35000000E-06  +2.12000000E-06
   +2.70000000E-07  +1.22000000E-06  -2.49955840E-01  -3.20716500E-02  +3.41670350E-01
   -3.87200000E-05  -7.68500000E-05  -2.31200000E-05  -7.94000000E-06  +1.14300000E-05
   +3.93000000E-06  +1.01600000E-05  +5.16500000E-05  -5.09000000E-06  +4.04000000E-06
   -2.36100000E-05  -1.43000000E-05  -7.10000000E-07  +3.92400000E-05  -1.14200000E-05
   -1.41600000E-05  +1.39000000E-05  +1.17000000E-05  -9.30000000E-07  -2.03200000E-05
   +6.73000000E-06  +1.82800000E-05  -8.05000000E-06  +3.05000000E-06  +1.51400000E-05
   +5.94100000E-05  -1.76000000E-06  +1.96600000E-05  -1.21600000E-05  +2.05700000E-05
   -2.95000000E-06  -2.59600000E-05  -1.14300000E-05  -1.11030000E-04  -3.71200000E-05
   +1.16320000E-04  +3.24460000E-04  +3.12280000E-04  +1.63900000E-05  +7.66400000E-05
   -1.90000000E-06  -3.37400000E-05  +4.23800000E-05  -2.49300000E-05  +2.62900000E-05
   +1.42040000E-04  +1.78880000E-04  -2.45200000E-04  -6.09810000E-04  +2.41850000E-04
   +5.55670000E-04  -5.47260000E-04  -2.03372000E-03  +6.76740000E-04  -1.01844600E-02
   +4.50518600E-02  -2.04895400E-02  +1.65593000E-03  -2.95341000E-03  +3.21360000E-04
   -2.15100000E-05  -6.45400000E-05  -4.54300000E-05  +1.56360000E-04  -6.46500000E-05
   -4.69500000E-05  +1.41004000E-03  -9.05510000E-04  +1.72070000E-04  -8.47053000E-03
   -2.39773500E-02  +1.60980500E-02  -2.85260000E-04  -4.59240000E-04  +1.62450000E-04
   +4.61000000E-06  +2.29100000E-05  +9.70000000E-07  -1.18600000E-05  -1.09000000E-06
   -5.60000000E-07  +1.06700000E-05  -2.88400000E-05  +6.76000000E-06  +6.80000000E-06
   +2.48300000E-05  +3.63000000E-06  +1.18600000E-05  -1.27400000E-05  -2.29800000E-05
   -9.90000000E-06  -6.88000000E-06  -1.16000000E-05  +1.96290000E-04  -9.59000000E-05
   -6.73400000E-05  +2.25400000E-05  -1.72500000E-05  +1.03900000E-05  +4.10429350E-01
   +2.22700000E-05  +4.77000000E-05  +2.24600000E-05  +1.79900000E-05  +3.41000000E-06
   -4.50900000E-05  -2.02400000E-05  -3.03800000E-05  -2.19100000E-05  +8.08600000E-05
   +6.28500000E-05  +1.88200000E-05  -2.56400000E-05  +1.15200000E-05  +1.94600000E-05
   -1.44400000E-05  +1.04900000E-05  +5.89000000E-06  +3.06000000E-06  +6.30000000E-06
   +4.30000000E-06  -1.47800000E-05  -7.68000000E-06  +4.04000000E-06  -9.52100000E-05
   -7.12300000E-05  -1.50800000E-05  +5.00000000E-06  -7.08000000E-06  +2.81000000E-06
   +5.57000000E-06  -8.14000000E-06  +2.32100000E-05  +4.67300000E-04  +3.25060000E-04
   -4.39190000E-04  -5.62660000E-04  -1.50752000E-03  +1.61730000E-03  -2.14430000E-04
   -4.80000000E-07  +1.57200000E-04  -6.07000000E-05  +1.22900000E-05  -3.31100000E-05
   -1.51390000E-04  -1.41460000E-04  +9.56000000E-05  +2.21623000E-03  -3.51560000E-04
   -4.81130000E-04  -4.17591000E-03  +6.04134000E-03  -2.67606000E-03  +2.81802400E-02
   -1.00536880E-01  +5.15541400E-02  -3.12195000E-03  +6.86507000E-03  -3.52397000E-03
   +3.34500000E-05  +3.40800000E-05  -1.42950000E-04  -2.26620000E-04  +2.69500000E-04
   -5.70700000E-05  -4.23900000E-04  -1.41675000E-03  +1.50696000E-03  -3.28213500E-02
   +6.27658700E-02  -2.63602200E-02  +1.22221000E-03  -6.57400000E-05  -7.71370000E-04
   +1.90600000E-05  +8.49000000E-06  -6.82000000E-06  +1.26400000E-05  -6.12000000E-06
   -4.44000000E-06  -2.32500000E-05  +6.84300000E-05  -4.56900000E-05  +1.02800000E-05
   +1.67000000E-05  -1.19400000E-05  -1.99000000E-05  +2.33700000E-05  +3.81500000E-05
   -3.13000000E-06  -2.25100000E-05  -1.00000000E-05  +2.32110000E-04  -3.87990000E-04
   +1.04780000E-04  +1.89700000E-05  +8.70000000E-06  -4.89000000E-06  +2.16118000E-02
   +5.24974700E-02  -4.78600000E-05  -4.45900000E-05  +1.59600000E-05  +2.54200000E-05
   -1.31000000E-06  +2.43400000E-05  -5.03000000E-06  +5.64000000E-06  +3.40800000E-05
   -6.10900000E-05  -6.46900000E-05  -3.09500000E-05  +2.42900000E-05  +3.65500000E-05
   -2.18100000E-05  -2.50000000E-06  -1.99000000E-06  -4.23200000E-05  -2.12000000E-05
   +8.70000000E-06  +9.88000000E-06  +1.90000000E-07  +3.99000000E-06  -2.19000000E-06
   +7.35800000E-05  +9.01100000E-05  +2.92700000E-05  +2.52700000E-05  -3.81000000E-06
   +2.12000000E-05  -6.40000000E-06  -3.32900000E-05  -4.86000000E-06  -1.57540000E-04
   -1.43750000E-04  +3.33080000E-04  +4.67100000E-04  +1.21402000E-03  -3.32090000E-04
   +1.31450000E-04  +3.43000000E-06  -6.97300000E-05  -1.72700000E-05  +6.58000000E-05
   -1.93800000E-05  -7.57000000E-06  -8.75500000E-05  -7.02800000E-05  -6.74460000E-04
   +5.90910000E-04  +7.71440000E-04  +2.05896000E-03  -3.77189000E-03  -3.66480000E-04
   -1.00045600E-02  +4.30702900E-02  -1.69531300E-02  +4.27850000E-04  -3.65686000E-03
   +6.38090000E-04  -1.07210000E-04  -1.07050000E-04  -7.25800000E-05  +5.66500000E-05
   -1.41910000E-04  +4.70300000E-05  -1.85740000E-04  +1.71723000E-03  -3.95790000E-04
   +2.18585300E-02  -3.12221500E-02  +1.91857000E-03  -8.50610000E-04  -1.47900000E-05
   -6.18500000E-05  -7.90000000E-07  +4.04000000E-06  -2.57000000E-06  -4.54000000E-06
   +7.00000000E-08  +1.96400000E-05  +4.95000000E-06  -4.75600000E-05  +1.96400000E-05
   +1.10000000E-06  +1.68900000E-05  -5.74000000E-06  +1.49400000E-05  -2.05400000E-05
   +1.27100000E-05  -3.24100000E-05  -1.67600000E-05  +1.46500000E-05  -2.54400000E-04
   +2.69820000E-04  -5.73600000E-05  -5.44000000E-06  -1.39400000E-05  -3.46000000E-06
   -2.24665270E-01  -4.06448800E-02  +1.48851670E-01  -4.98000000E-06  -9.47800000E-05
   -3.09500000E-05  -1.95700000E-05  -1.12100000E-05  +5.29400000E-05  +3.26900000E-05
   +5.77000000E-05  +4.37000000E-05  -1.59780000E-04  -1.35300000E-04  -4.43500000E-05
   +4.55800000E-05  -7.14000000E-06  -4.71100000E-05  +5.46000000E-06  -1.76600000E-05
   +1.98400000E-05  -1.51500000E-05  -8.41000000E-06  -5.40000000E-07  +2.33900000E-05
   +1.03600000E-05  -9.06000000E-06  +1.84190000E-04  +1.60090000E-04  +3.31000000E-05
   -4.04000000E-06  +6.09000000E-06  +4.79000000E-06  -2.40600000E-05  +2.19000000E-06
   -4.96800000E-05  -2.64170000E-04  -1.08870000E-04  +1.93340000E-04  +2.65820000E-04
   +1.97800000E-05  -1.59800000E-05  +1.54490000E-04  -1.16200000E-05  -7.50700000E-05
   +7.95600000E-05  -5.09000000E-06  +1.31600000E-05  +4.99530000E-04  -1.82840000E-04
   -1.16680000E-04  -1.34498000E-03  +5.52280000E-04  +3.11900000E-04  +3.58145000E-03
   -1.31875000E-03  -5.16090000E-04  -2.44658000E-03  +6.54986000E-03  -3.63649000E-03
   -8.35400000E-05  -1.62032000E-03  +9.94490000E-04  -3.90300000E-05  -2.85600000E-05
   +2.47800000E-05  +9.01200000E-05  -2.62270000E-04  +1.41940000E-04  -2.42606000E-03
   +3.22150000E-04  +4.82840000E-04  -6.08937000E-03  -7.73973000E-03  +9.39889000E-03
   -3.59500000E-05  -3.44600000E-05  -3.99400000E-05  -1.70100000E-05  +2.56500000E-05
   +4.57000000E-06  -2.57000000E-05  +7.67000000E-06  -9.07000000E-06  +4.59700000E-05
   -5.33000000E-05  +1.16800000E-05  -1.07500000E-05  +1.28700000E-05  +2.60500000E-05
   +4.26000000E-05  -3.81600000E-05  -3.67200000E-05  -1.72400000E-05  +1.26700000E-05
   +2.63900000E-05  +5.32400000E-05  -2.33700000E-04  +8.76400000E-05  -2.99700000E-05
   -2.59000000E-05  +6.23000000E-06  -3.94240240E-01  -1.21835600E-02  +2.11941620E-01
   +4.02194080E-01  -1.34400000E-05  +1.13090000E-04  +2.41800000E-05  +1.16200000E-05
   -1.94000000E-06  -3.87200000E-05  -2.89900000E-05  -5.66200000E-05  -4.20800000E-05
   +1.30050000E-04  +1.22340000E-04  +5.20500000E-05  -3.07400000E-05  -4.47000000E-06
   +4.51600000E-05  -5.11000000E-06  +1.23000000E-06  -2.09700000E-05  +1.44900000E-05
   +1.07700000E-05  -4.99000000E-06  -1.91200000E-05  -7.56000000E-06  +6.52000000E-06
   -1.54560000E-04  -1.52650000E-04  -3.22300000E-05  -7.88000000E-06  +7.50000000E-07
   -1.36900000E-05  +2.22400000E-05  +1.41800000E-05  +4.36900000E-05  +1.46750000E-04
   -8.08100000E-05  +9.34800000E-05  +1.06220000E-04  +4.99930000E-04  -2.87950000E-04
   -5.58900000E-05  -1.25000000E-06  +8.61000000E-06  -1.06760000E-04  +3.85200000E-05
   -1.65200000E-05  -1.92530000E-04  -3.62000000E-06  +1.01860000E-04  -1.90160000E-04
   +3.16580000E-04  -1.34330000E-04  +2.59379000E-03  -1.89071000E-03  +4.49110000E-04
   +1.40165000E-03  +8.12300000E-04  -2.19347000E-03  +1.28040000E-04  -7.38260000E-04
   +3.49730000E-04  -3.79600000E-05  +2.55800000E-05  -1.06100000E-05  -2.59200000E-05
   +2.67100000E-05  +2.29700000E-05  -9.16020000E-04  +2.60550000E-04  -3.44860000E-04
   +1.84674100E-02  -2.81992000E-03  -6.22290000E-03  -2.46130000E-04  +3.14800000E-05
   +2.09200000E-05  +7.37000000E-06  -3.75700000E-05  -2.51000000E-06  +2.33000000E-05
   -1.73000000E-06  +5.47000000E-06  -3.66700000E-05  +2.04000000E-05  +7.73000000E-06
   +3.18000000E-06  -3.06500000E-05  -2.44300000E-05  -4.04900000E-05  +3.12200000E-05
   +4.43700000E-05  +1.82600000E-05  -6.06000000E-06  -1.56800000E-05  -5.99720000E-04
   +7.14940000E-04  -1.72370000E-04  +1.94600000E-05  +2.75000000E-05  -4.50000000E-06
   -3.67680200E-02  -2.45171100E-02  +3.29418200E-02  +1.63822700E-02  +2.72828800E-02
   +2.27600000E-05  +1.05000000E-06  -1.93100000E-05  -2.96000000E-06  -2.51000000E-06
   -7.36000000E-06  +3.36000000E-06  +2.45000000E-06  -1.11500000E-05  +1.16200000E-05
   +1.14800000E-05  +7.05000000E-06  -4.38000000E-06  -1.26900000E-05  +6.61000000E-06
   -1.03000000E-06  +1.87000000E-06  +2.72200000E-05  +6.06000000E-06  -2.36000000E-06
   -3.66000000E-06  +4.70000000E-07  +2.10000000E-07  -5.90000000E-07  -1.28800000E-05
   -2.15700000E-05  -8.97000000E-06  -1.18900000E-05  +1.04000000E-06  -6.94000000E-06
   +1.16000000E-06  +1.47500000E-05  -1.82000000E-06  +7.57700000E-05  +1.32940000E-04
   -1.25390000E-04  -1.07480000E-04  -1.89580000E-04  +3.99260000E-04  -5.12000000E-05
   +0.00000000E+00  +2.88600000E-05  +2.77400000E-05  -2.39700000E-05  +4.42000000E-06
   -1.25130000E-04  +1.11950000E-04  +2.50500000E-05  +7.60190000E-04  -5.34500000E-04
   -1.68930000E-04  -2.93062000E-03  +2.44396000E-03  +9.36900000E-04  -4.19210000E-04
   -4.88636000E-03  +1.73872000E-03  -6.09100000E-05  +1.27972000E-03  -7.76430000E-04
   +3.53900000E-05  -1.18700000E-05  -2.34500000E-05  -8.19000000E-06  +1.47310000E-04
   -4.17700000E-05  +1.28885000E-03  -9.30300000E-04  -1.20392000E-03  -7.20811000E-03
   +7.40821000E-03  +1.56686000E-03  +1.15890000E-04  -8.80200000E-05  -1.27720000E-04
   -7.70000000E-07  -1.39000000E-06  +2.71000000E-06  -1.43000000E-06  +1.19000000E-06
   -1.00900000E-05  -1.51000000E-06  +1.57000000E-05  -1.24600000E-05  -1.87000000E-06
   -7.92000000E-06  +8.13000000E-06  -9.90000000E-07  +1.27000000E-06  -1.19500000E-05
   +1.17100000E-05  +8.02000000E-06  -4.55000000E-06  +3.00640000E-04  -3.59020000E-04
   -1.92500000E-05  -1.53000000E-06  +3.09000000E-06  +1.21000000E-06  +2.27482650E-01
   +2.01207200E-02  -1.34248670E-01  -2.19192160E-01  -2.46348700E-02  +1.32081370E-01
end_hess

