# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -807.45970390    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -4.45068534E+00  +8.25833817E-01  +2.12539063E+00
   006   -2.73448820E+00  +9.74541020E-01  +1.42138073E-01
   006   -3.41826791E+00  -1.91756839E-01  -2.11870675E+00
   006   -5.69783033E+00  -1.43731012E+00  -2.39700452E+00
   006   -7.38575083E+00  -1.54818736E+00  -3.87031794E-01
   006   -6.74846150E+00  -4.11050054E-01  +1.88157966E+00
   006   -1.91911918E-01  +2.33529246E+00  +3.46311431E-01
   006   -3.94772890E-02  +4.30988841E+00  -1.79067651E+00
   008   -9.65548719E+00  -2.73784813E+00  -5.46453727E-01
   006   +1.99727928E+00  +4.42619431E-01  +1.52889563E-01
   006   +1.67422103E+00  -2.14903345E+00  +4.91797771E-01
   006   +3.67791786E+00  -3.83565565E+00  +3.96475145E-01
   006   +6.11474110E+00  -2.98044395E+00  -4.84459021E-02
   006   +6.52271334E+00  -4.04002107E-01  -3.66341969E-01
   006   +4.47647629E+00  +1.19177011E+00  -2.59059336E-01
   008   +8.14658069E+00  -4.53832040E+00  -1.79502879E-01
   006   +8.63157290E-02  +3.74169190E+00  +2.87094685E+00
   008   +6.02290906E+00  +5.60919360E+00  -2.16798567E-01
   001   -9.86961758E+00  -3.42080873E+00  -2.20675279E+00
   001   -6.16536046E+00  -2.32594120E+00  -4.18299675E+00
   001   -2.12768621E+00  -1.61789241E-01  -3.70482162E+00
   001   -4.01939817E+00  +1.68696714E+00  +3.92546805E+00
   001   -8.06107623E+00  -5.00216658E-01  +3.44514458E+00
   001   -1.69656155E+00  +5.53233679E+00  -1.71166422E+00
   001   +1.63447674E+00  +5.48813885E+00  -1.59731687E+00
   001   +1.29278443E-02  +3.42318241E+00  -3.64724261E+00
   001   +7.90058103E-02  +2.44580813E+00  +4.47271013E+00
   001   +1.87225869E+00  +4.76499491E+00  +2.88801478E+00
   001   -1.43000113E+00  +5.11656181E+00  +3.11988618E+00
   001   +5.00622174E+00  +3.42529667E+00  -5.14081254E-01
   001   +8.41033918E+00  +3.01788590E-01  -7.02425891E-01
   001   +3.32749718E+00  -5.83508001E+00  +6.71274033E-01
   001   -2.01137161E-01  -2.88193546E+00  +8.40151294E-01
   001   +7.62013502E+00  -6.25039535E+00  +6.96482959E-02
   001   +6.80405649E+00  +5.35733317E+00  +1.41098356E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +0.00000000E+00  +1.51000000E-06  -2.40000000E-07
   +1.40000000E-07  +6.90000000E-07  -2.00000000E-07
   -9.00000000E-08  +4.00000000E-07  +0.00000000E+00
   -3.90000000E-07  +9.00000000E-07  +1.80000000E-07
   -4.90000000E-07  +1.74000000E-06  +1.60000000E-07
   -2.80000000E-07  +2.04000000E-06  -8.00000000E-08
   +4.60000000E-07  +1.20000000E-07  -4.00000000E-07
   +1.03000000E-06  -3.60000000E-07  -7.90000000E-07
   -7.50000000E-07  +2.26000000E-06  +2.90000000E-07
   +2.00000000E-08  -4.80000000E-07  +8.00000000E-08
   -6.90000000E-07  -2.80000000E-07  +5.80000000E-07
   -1.05000000E-06  -8.70000000E-07  +1.01000000E-06
   -8.30000000E-07  -1.55000000E-06  +9.00000000E-07
   -1.90000000E-07  -1.70000000E-06  +4.10000000E-07
   +2.30000000E-07  -1.21000000E-06  +0.00000000E+00
   -1.24000000E-06  -2.07000000E-06  +1.32000000E-06
   +7.00000000E-07  +5.50000000E-07  -6.80000000E-07
   +1.28000000E-06  -1.57000000E-06  -8.10000000E-07
   -8.80000000E-07  +2.00000000E-06  +4.40000000E-07
   -5.30000000E-07  +6.50000000E-07  +3.40000000E-07
   +0.00000000E+00  -2.50000000E-07  +3.00000000E-08
   +1.80000000E-07  +1.80000000E-06  -3.90000000E-07
   -3.50000000E-07  +2.70000000E-06  -1.10000000E-07
   +1.35000000E-06  +7.00000000E-08  -1.10000000E-06
   +1.33000000E-06  -7.70000000E-07  -9.80000000E-07
   +8.60000000E-07  -7.60000000E-07  -6.10000000E-07
   +3.50000000E-07  +8.80000000E-07  -4.00000000E-07
   +9.80000000E-07  +1.00000000E-07  -8.20000000E-07
   +1.05000000E-06  +9.70000000E-07  -1.00000000E-06
   +7.50000000E-07  -1.38000000E-06  -4.40000000E-07
   -2.00000000E-08  -2.26000000E-06  +3.60000000E-07
   -1.58000000E-06  -7.10000000E-07  +1.41000000E-06
   -8.60000000E-07  +1.60000000E-07  +6.80000000E-07
   -1.67000000E-06  -1.90000000E-06  +1.65000000E-06
   +1.19000000E-06  -1.42000000E-06  -7.70000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.89620480E-01  +2.03201040E-01  +3.06646040E-01  -5.26179300E-02  +1.66247990E-01
   +6.80078710E-01  -2.04003370E-01  -1.97560000E-02  +1.33805810E-01  +5.58302840E-01
   -4.03929300E-02  -8.53907800E-02  +4.67594000E-03  +1.52538410E-01  +3.12853020E-01
   +7.30584500E-02  -2.44323500E-02  -2.37385240E-01  -7.82169800E-02  +1.20603340E-01
   +6.24853670E-01  +5.03610200E-02  +2.08784100E-02  -9.84580000E-04  -1.29393930E-01
   -3.09495600E-02  -1.34435000E-03  +6.28740450E-01  +3.82444000E-02  +1.91826200E-02
   -2.41223600E-02  -5.23507600E-02  -1.21761650E-01  -6.97821300E-02  +1.98916230E-01
   +2.96665320E-01  +4.51763600E-02  -3.52850000E-04  -5.54024400E-02  -6.18192200E-02
   -9.99027500E-02  -2.61112630E-01  -1.03281250E-01  +1.35702750E-01  +6.52002570E-01
   -5.80834200E-02  -1.78825500E-02  +2.61104100E-02  +3.26617000E-03  -2.99324600E-02
   -7.78644900E-02  -2.91655040E-01  -1.08022570E-01  +1.88893300E-02  +6.00623530E-01
   -1.88259400E-02  -1.00891400E-02  +9.52372000E-03  -1.31210200E-02  -9.86687000E-03
   -3.31501300E-02  -1.31035060E-01  -1.30790740E-01  -1.45045500E-02  +2.17256250E-01
   +2.98106310E-01  +2.30480500E-02  +8.11948000E-03  -1.38591700E-02  -3.01122400E-02
   -9.18880000E-03  +2.51552200E-02  -4.19465500E-02  -4.53582800E-02  -1.25445150E-01
   -5.38239300E-02  +1.71416510E-01  +6.69164490E-01  +5.63014000E-03  -1.13003600E-02
   -3.58330200E-02  -1.18199000E-03  +9.12896000E-03  +1.85981400E-02  -4.25462400E-02
   -1.82279800E-02  +1.22762600E-02  -1.86991780E-01  -1.03183100E-02  +1.33388850E-01
   +6.09070790E-01  -3.01297300E-02  -1.55444100E-02  -7.55708000E-03  +8.40456000E-03
   -8.15625000E-03  -1.81788400E-02  +3.22970000E-04  +1.24223700E-02  +2.46331000E-02
   -3.66601400E-02  -8.79108200E-02  +6.66200000E-04  +1.99717380E-01  +3.18593320E-01
   -8.69405200E-02  -3.37495000E-02  +3.02156800E-02  +1.63052200E-02  -1.80236400E-02
   -8.14338900E-02  +6.33147100E-02  +5.13446600E-02  +5.36106800E-02  +6.03603500E-02
   -3.61774500E-02  -2.50892290E-01  -6.12165600E-02  +1.54214660E-01  +6.75988120E-01
   -2.86102160E-01  -1.26088090E-01  -3.85222300E-02  -3.82422700E-02  -2.49837000E-03
   +5.81078300E-02  -3.12168000E-02  -2.50041100E-02  -2.84068300E-02  +4.94469100E-02
   +1.96614400E-02  -1.87258000E-03  -1.24413190E-01  -2.12491300E-02  +1.30168000E-02
   +6.29565440E-01  -1.04074880E-01  -1.29004630E-01  -4.29729700E-02  -1.78391400E-02
   +1.34646800E-02  +4.30355600E-02  -2.31139400E-02  -2.36549900E-02  -2.25220800E-02
   +3.46255400E-02  +1.87964400E-02  -2.07574100E-02  -4.66373000E-02  -1.20835980E-01
   -7.21910400E-02  +2.11511640E-01  +2.88032740E-01  +2.22491900E-02  -1.22951700E-02
   -1.27122950E-01  +1.34710600E-02  +1.97562100E-02  +4.58443600E-02  -2.56040500E-02
   -2.18111200E-02  -2.68453000E-02  +3.97986200E-02  +3.96890000E-04  -4.54939800E-02
   -5.58353200E-02  -1.06200310E-01  -2.89670060E-01  -1.04610710E-01  +1.44226710E-01
   +6.73875760E-01  -1.72005600E-02  -9.96973000E-03  +2.07627000E-03  -1.52369260E-01
   -4.11620200E-02  -1.95840000E-03  -8.25398000E-03  -8.25494000E-03  -7.43916000E-03
   +4.39720000E-03  -7.58240000E-04  +3.77210000E-04  -2.29482000E-03  -4.26970000E-04
   +1.00090000E-03  +1.83942000E-03  -1.63393000E-03  +2.80495000E-03  +4.81791530E-01
   -3.94362000E-03  +1.83473000E-03  +3.50069000E-03  -4.19076000E-02  -9.56255300E-02
   -9.05882000E-03  -1.43614700E-02  -7.49912000E-03  -3.94448000E-03  -8.61310000E-04
   +3.79345000E-03  -3.11887000E-03  -5.77110000E-04  -8.22900000E-04  -1.05300000E-04
   -9.99430000E-04  +5.33617000E-03  -2.15729000E-03  +1.73459800E-02  +4.68870670E-01
   +1.86274700E-02  +1.08777100E-02  +8.36447000E-03  -4.27203000E-03  -9.79659000E-03
   -9.02954600E-02  -2.56410200E-02  -1.20832000E-02  +2.83070000E-03  -2.42780000E-04
   -3.42018000E-03  -4.56170000E-03  -3.96800000E-05  -4.93870000E-04  -1.84025000E-03
   +3.67751000E-03  -1.77368000E-03  -2.52429000E-03  +3.50645000E-03  +8.01801000E-03
   +4.68615260E-01  -1.57343000E-03  -2.07515000E-03  -1.75302000E-03  -6.82195000E-03
   -2.23182000E-02  +2.30350900E-02  -6.49200000E-04  -2.23058000E-03  +3.62500000E-05
   +1.44860000E-04  +4.88590000E-04  +6.69300000E-04  +6.13610000E-04  +5.96800000E-04
   +8.39880000E-04  -1.80538000E-03  +5.97700000E-04  -5.41030000E-04  -7.58067200E-02
   -5.17658000E-03  +3.82071000E-03  +5.92975710E-01  +8.30620000E-04  -1.23500000E-03
   -1.14737000E-03  -9.56541000E-03  -1.73240300E-02  +1.40460500E-02  -4.71530000E-04
   -8.79790000E-04  +7.51480000E-04  +4.29170000E-04  +4.76720000E-04  +4.22610000E-04
   +1.10340000E-04  +2.30420000E-04  +5.58160000E-04  -8.41240000E-04  +2.22770000E-04
   -4.32260000E-04  -3.86456000E-03  -1.16525290E-01  +4.79499000E-02  +4.16856000E-03
   +5.23626130E-01  -1.03563000E-03  -2.61990000E-04  -2.82790000E-04  +7.12841000E-03
   +3.89594000E-03  +1.43293000E-03  -1.77999000E-03  -6.19530000E-04  +3.78300000E-04
   +3.61920000E-04  -1.40080000E-04  -3.55390000E-04  +3.92370000E-04  +1.16450000E-04
   +4.50160000E-04  -3.09330000E-04  -7.29300000E-05  -2.47730000E-04  +2.06782000E-03
   +4.37980800E-02  -1.24778540E-01  +3.22335000E-03  +6.80137300E-02  +5.24402970E-01
   +2.57793000E-03  -2.80830000E-04  +2.42892000E-03  -2.88834000E-03  -1.86589000E-03
   -2.03779000E-03  +3.51999000E-03  -1.19330000E-04  +4.85508000E-03  -4.17268000E-02
   -2.55556300E-02  -4.91800000E-04  -2.59004850E-01  -9.92648800E-02  +2.34766800E-02
   -1.85488100E-02  -1.73964000E-02  -1.28796500E-02  +2.05370000E-03  +1.04067000E-03
   +6.67460000E-04  -1.31724000E-03  -3.24860000E-04  -6.08490000E-04  +3.58094740E-01
   +1.85002000E-03  +4.97770000E-03  -3.44552000E-03  -1.53773000E-03  -1.58572000E-03
   +1.90725000E-03  -2.79891000E-03  +4.70024000E-03  -3.01745000E-03  -1.31463400E-02
   +2.90654000E-03  -9.21780000E-04  -1.14728010E-01  -1.04479010E-01  -9.84444000E-03
   -2.99839400E-02  -1.06889700E-02  -9.87999000E-03  +1.38603000E-03  +2.49800000E-05
   +6.99280000E-04  -7.24230000E-04  -1.78500000E-04  -3.10700000E-04  +1.80857530E-01
   +1.90266180E-01  +8.43290000E-03  -4.08140000E-04  -7.74766000E-03  -1.86566000E-03
   +1.81245000E-03  +6.67718000E-03  -2.48677000E-03  -6.89961000E-03  -7.74587000E-03
   +3.43959000E-02  +1.65523200E-02  +7.61225000E-03  -2.18431900E-02  -3.25736000E-02
   -1.05054410E-01  -4.69327600E-02  -2.66421700E-02  -1.48793000E-03  +4.44500000E-05
   +3.46450000E-04  +4.37600000E-04  -2.78490000E-04  -1.14370000E-04  -2.02850000E-04
   +4.58219200E-02  +2.10896340E-01  +5.67350190E-01  -5.48970000E-04  +1.06640000E-04
   -2.44759000E-03  -3.31606500E-02  +1.40783000E-02  +4.34373000E-03  +3.82500000E-04
   +8.19750000E-04  +7.88160000E-04  +1.56370000E-04  -1.92880000E-04  +8.40490000E-04
   +5.47240000E-04  +4.51480000E-04  +5.02930000E-04  -3.45000000E-04  -1.46779000E-03
   +7.35400000E-05  -1.29243890E-01  +3.55990200E-02  +4.82896000E-03  +7.30960000E-04
   +5.72075000E-03  -4.59564000E-03  -6.69100000E-04  -2.95130000E-04  -1.86770000E-04
   +6.12237220E-01  -1.94343000E-03  -2.07751000E-03  -7.53970000E-04  -4.91520000E-03
   +1.30253000E-02  +2.51938000E-03  -7.78650000E-04  -9.31240000E-04  +3.85140000E-04
   -4.58780000E-04  -4.33670000E-04  +2.70820000E-04  +9.54870000E-04  +7.54860000E-04
   -3.18000000E-06  -2.16630000E-04  -8.03320000E-04  +3.93730000E-04  +3.89532100E-02
   -1.19733970E-01  -2.31796000E-03  +1.88517600E-02  -2.20835000E-02  +2.18994000E-03
   -1.37333000E-03  -7.67390000E-04  -2.15050000E-04  +7.47674000E-03  +6.19940430E-01
   +4.81820000E-04  +3.74470000E-04  -2.88390000E-04  +2.99460000E-04  +8.61050000E-04
   -1.97620000E-04  -1.33657000E-03  -4.54770000E-04  -2.57460000E-04  +2.87370000E-04
   +2.01540000E-04  +3.69700000E-05  +4.57600000E-05  +1.61150000E-04  +3.26030000E-04
   -2.79990000E-04  -7.35100000E-05  -2.61740000E-04  +6.46152000E-03  -1.30429000E-03
   -6.71566100E-02  -1.92106400E-02  +1.70112000E-02  +1.14621000E-03  -2.33530000E-04
   -1.90790000E-04  -2.50000000E-05  -6.43673100E-02  -4.21341400E-02  +1.89795480E-01
   +7.43140000E-04  +6.24900000E-04  -3.96460000E-04  -1.29109000E-03  +2.93678000E-03
   -3.19640000E-04  -1.27284000E-03  +1.14629000E-03  -6.62030000E-04  +4.04100000E-04
   -2.40000000E-05  -6.66100000E-05  -7.23600000E-05  -2.03100000E-05  +5.25440000E-04
   -4.11150000E-04  -4.96860000E-04  -1.63470000E-04  +7.48009000E-03  +2.34611700E-02
   -3.70456000E-03  -3.24429000E-03  +2.17826000E-03  +1.19624000E-03  -1.31230000E-04
   -9.53600000E-05  -4.43000000E-05  -1.25992180E-01  -6.05206200E-02  +1.65353300E-02
   +7.26867090E-01  -6.86250000E-04  -3.71650000E-04  +8.41590000E-04  +2.99440000E-04
   -2.06663000E-03  +1.96370000E-04  +1.03434000E-03  -9.19110000E-04  -2.01030000E-04
   -4.05800000E-04  -3.31830000E-04  +2.00180000E-04  -2.92380000E-04  -1.12240000E-04
   -3.87090000E-04  +1.24370000E-04  -3.19200000E-05  +1.97120000E-04  +4.14805000E-03
   -1.86100900E-02  +2.89184000E-03  +7.27540000E-04  +1.61430000E-04  -1.31349000E-03
   +2.72140000E-04  +1.46490000E-04  +7.97600000E-05  +1.60225000E-02  -3.06042330E-01
   +2.27389500E-02  +4.58005000E-03  +6.64660050E-01  +6.97000000E-04  -1.78600000E-05
   -2.57190000E-04  -3.78220000E-04  +3.98950000E-04  +6.24940000E-04  -1.49233000E-03
   +6.93280000E-04  -4.86060000E-04  +5.36770000E-04  +5.92970000E-04  -1.83700000E-04
   +2.24000000E-06  +1.14060000E-04  +3.96590000E-04  -3.88020000E-04  -3.40670000E-04
   -6.49100000E-05  -1.70550000E-03  -1.98030000E-03  +4.29934000E-03  +1.92460000E-04
   +4.09280000E-04  -6.29650000E-04  +9.91000000E-06  -1.37600000E-05  -4.84000000E-06
   +6.86590000E-03  +3.52889200E-02  -7.20630500E-02  -8.25993300E-02  -6.02236900E-02
   +1.59098210E-01  -1.96300000E-05  -9.86000000E-06  -2.44820000E-04  -4.82910000E-04
   +9.20820000E-04  -5.03560000E-04  +2.82600000E-05  +1.42930000E-04  +4.19730000E-04
   -6.99000000E-05  -8.51800000E-05  +8.34700000E-05  +3.50690000E-04  +1.49800000E-04
   -6.41700000E-05  +8.97300000E-05  -4.55800000E-05  -7.58700000E-05  +7.48190000E-04
   -2.06906000E-03  +1.89786000E-03  -5.08760000E-04  +1.02900000E-04  +6.32300000E-05
   -3.85710000E-04  -2.06370000E-04  -5.89100000E-05  +5.25474800E-02  +6.55941200E-02
   -1.51359500E-02  -2.54356630E-01  +7.31934600E-02  +1.92859000E-02  +6.80427060E-01
   +4.04030000E-04  +3.23830000E-04  -3.23250000E-04  -1.02099000E-03  +9.77500000E-05
   -1.52300000E-05  -1.53440000E-04  +4.21730000E-04  -1.02400000E-04  +1.54610000E-04
   +1.96710000E-04  +6.43700000E-05  +2.88570000E-04  +9.78400000E-05  +2.10460000E-04
   -9.03000000E-05  -6.99800000E-05  -1.28430000E-04  -2.64089000E-03  -2.43864000E-03
   +1.90012000E-03  +9.09230000E-04  -7.82320000E-04  -2.88840000E-04  -2.72880000E-04
   -1.48520000E-04  -4.08300000E-05  +1.23003400E-02  -4.31137700E-02  +3.16241000E-03
   +1.42935700E-01  -2.17085180E-01  -2.34958000E-03  -7.61454000E-03  +7.40047030E-01
   +1.40180000E-04  +1.07900000E-05  +2.13700000E-05  +5.56700000E-05  -4.73400000E-05
   +2.55200000E-04  -1.79470000E-04  -7.73100000E-05  -2.63080000E-04  +9.37800000E-05
   +1.04870000E-04  -5.55900000E-05  -7.87100000E-05  -2.44000000E-05  +8.70600000E-05
   -1.03480000E-04  -7.65600000E-05  -2.31000000E-06  +9.30280000E-04  +8.52490000E-04
   +6.32493000E-03  +1.08507000E-03  -7.78460000E-04  -2.19320000E-04  +7.26300000E-05
   +4.20500000E-05  +2.00300000E-05  -7.46632000E-03  -3.37262000E-03  +8.29669000E-03
   +1.18464400E-02  +6.75879000E-03  -6.33531600E-02  -7.88613100E-02  -6.75287100E-02
   +1.45405380E-01  +2.35230000E-04  +1.35810000E-04  +7.60600000E-05  -2.44980000E-04
   -6.28830000E-04  +1.91270000E-04  -7.68300000E-05  +7.59600000E-05  -5.81200000E-05
   +2.87330000E-04  +5.33600000E-05  -2.15160000E-04  -7.04260000E-04  -3.50660000E-04
   +6.52300000E-05  +3.62700000E-05  +7.96300000E-05  +9.33300000E-05  -1.83967000E-03
   -1.38800000E-05  -6.20750000E-04  +1.04502000E-03  -2.42670000E-04  -2.70660000E-04
   +7.92610000E-04  +4.16530000E-04  +9.36900000E-05  -3.08169500E-02  -4.45514700E-02
   +9.36133000E-03  -5.95243400E-02  +5.33109800E-02  +3.14744000E-03  -2.88659490E-01
   -1.09153580E-01  +4.42017100E-02  +6.96854210E-01  +1.55000000E-04  +3.27400000E-05
   -1.73150000E-04  +5.88340000E-04  +1.48700000E-04  +5.45880000E-04  -1.86880000E-04
   -2.85200000E-05  -2.76500000E-04  -7.17000000E-05  +1.16330000E-04  +1.53270000E-04
   +6.31390000E-04  +3.76750000E-04  +3.07280000E-04  -3.00410000E-04  -2.21850000E-04
   -2.16290000E-04  +3.94130000E-04  -1.70969000E-03  -5.01600000E-05  +1.52630000E-04
   -1.06170000E-04  +1.80800000E-05  -7.82600000E-04  -4.56600000E-04  -1.09940000E-04
   -4.65205900E-02  -4.75814700E-02  +1.11170200E-02  -5.90381000E-03  +7.58107000E-02
   -7.26562000E-03  -2.67756500E-02  -1.65417140E-01  +1.49840900E-02  -8.51189000E-03
   +7.17463690E-01  -1.19620000E-04  -5.86000000E-06  -1.94000000E-06  -4.60700000E-05
   +8.21400000E-05  -3.14800000E-05  +8.79600000E-05  -3.99200000E-05  +9.88600000E-05
   -7.88000000E-05  -7.57200000E-05  +2.19000000E-05  +3.92300000E-05  +1.39200000E-05
   -7.34600000E-05  +6.60500000E-05  +3.32200000E-05  +3.13000000E-06  +1.11650000E-04
   +2.19130000E-04  -5.96590000E-04  -3.38840000E-04  +2.44100000E-05  +7.25700000E-05
   -4.59800000E-05  -2.40700000E-05  -1.05600000E-05  +8.53873000E-03  +1.02036300E-02
   -5.05789000E-03  +9.00466000E-03  -1.42214600E-02  +2.84577000E-03  +3.60674200E-02
   +2.61341600E-02  -7.70595800E-02  -7.70956500E-02  -5.66857900E-02  +1.77355040E-01
   +9.11000000E-06  +2.52100000E-05  -3.58520000E-04  -4.89150000E-04  +1.06615000E-03
   +5.24640000E-04  -1.71370000E-04  +1.58440000E-04  +4.93000000E-06  +2.62200000E-05
   +8.57800000E-05  +7.69600000E-05  +3.56220000E-04  +1.90680000E-04  +1.87620000E-04
   -1.50070000E-04  -1.88990000E-04  -6.42300000E-05  -1.33412000E-03  -5.18274000E-03
   +4.86030000E-04  +4.44820000E-04  -5.54350000E-04  +2.00990000E-04  -4.26920000E-04
   -2.17520000E-04  -7.10300000E-05  -5.38707100E-02  -3.10866000E-03  +8.57001000E-03
   -1.02779500E-02  +2.51725100E-02  -1.59590000E-03  +1.84230000E-02  -3.25642500E-02
   +1.94161000E-03  -1.35726740E-01  -8.77725000E-02  +1.79950100E-02  +7.50425070E-01
   -3.33300000E-04  -1.41280000E-04  +1.78300000E-05  -1.02133000E-03  +8.49220000E-04
   -2.62540000E-04  +2.23490000E-04  -8.50000000E-07  +2.45300000E-04  -1.12780000E-04
   -1.47950000E-04  +8.55000000E-06  -1.37750000E-04  -1.21550000E-04  -2.81040000E-04
   +2.07150000E-04  +7.83300000E-05  +1.73450000E-04  -2.64010000E-03  -8.22730000E-04
   +5.79920000E-04  -3.11940000E-04  -4.14150000E-04  +1.31200000E-05  +2.13950000E-04
   +1.63320000E-04  +3.69400000E-05  +4.55874100E-02  +6.17125400E-02  -1.07468000E-02
   +2.24920800E-02  -6.51253400E-02  +3.57930000E-03  -8.02055400E-02  -4.51790000E-03
   +1.23745700E-02  -5.74780000E-03  -3.00832100E-01  +2.40517800E-02  -1.46145000E-03
   +6.67747730E-01  +3.38100000E-05  -2.07200000E-05  +7.79900000E-05  +4.04270000E-04
   -3.76260000E-04  +5.22100000E-05  +7.28600000E-05  +2.03200000E-05  -8.73800000E-05
   -3.12200000E-05  -3.33000000E-06  +7.88000000E-06  -5.17000000E-06  -3.44500000E-05
   -4.48300000E-05  +2.20800000E-05  +5.50400000E-05  +9.36000000E-06  +1.23379000E-03
   +1.52100000E-03  +3.95987000E-03  -1.22470000E-04  -2.87360000E-04  +1.02330000E-04
   +3.61100000E-05  +2.50700000E-05  +1.64200000E-05  +3.53149000E-03  -5.22216000E-03
   +5.98811000E-03  -1.00358000E-03  +3.45641000E-03  -1.05833000E-03  +7.58482000E-03
   +6.00369000E-03  +6.75452000E-03  +8.61140000E-03  +3.47307200E-02  -7.47375300E-02
   -8.63754700E-02  -5.45884100E-02  +1.40620630E-01  -7.42060000E-04  -5.57720000E-04
   +5.60200000E-05  -1.18173000E-03  +2.41023000E-03  +2.57580000E-04  +2.85770000E-04
   -3.39910000E-04  +5.71420000E-04  -1.12170000E-04  -3.39060000E-04  -1.30310000E-04
   -2.95760000E-04  -1.06840000E-04  -3.27550000E-04  +2.32320000E-04  +3.95200000E-05
   +2.62530000E-04  -2.83816700E-02  +1.70783000E-03  +4.18975000E-03  -3.53350000E-04
   -3.68060000E-04  +6.51040000E-04  +3.39080000E-04  +1.76830000E-04  +3.52600000E-05
   -2.87696800E-01  -1.97746700E-02  +3.25832900E-02  +1.31655100E-02  -9.62081700E-02
   +1.04234400E-02  -7.40273300E-02  +1.36648700E-02  +8.37947000E-03  +5.57425200E-02
   +8.07426900E-02  -1.60269700E-02  -2.68000530E-01  +9.48622100E-02  +1.93111500E-02
   +6.51734670E-01  +6.13560000E-04  +3.77600000E-04  +7.42860000E-04  +2.54110000E-03
   -4.71746000E-03  -1.02079000E-03  -4.92000000E-05  -1.45030000E-04  -1.26130000E-04
   +3.43960000E-04  +1.98770000E-04  -3.58720000E-04  -9.49650000E-04  -4.63490000E-04
   -7.25600000E-05  +2.01870000E-04  +5.34820000E-04  -4.62800000E-05  +1.45754200E-02
   +1.31699100E-02  -2.58775000E-03  +2.52907000E-03  +6.72780000E-04  -8.43260000E-04
   +1.18703000E-03  +5.74790000E-04  +1.67330000E-04  -7.76042200E-02  -1.14855580E-01
   +1.36873900E-02  -2.96998600E-02  -1.27169100E-02  +7.30872000E-03  +8.49911000E-03
   -5.56677000E-03  -1.10894000E-03  +1.70810600E-02  -4.90255200E-02  +4.06113000E-03
   +1.50641450E-01  -1.92039130E-01  -7.66803000E-03  -6.63643400E-02  +4.55399680E-01
   +1.73110000E-04  +1.96310000E-04  -2.83560000E-04  -9.55820000E-04  -6.13300000E-05
   +9.73150000E-04  -3.46690000E-04  +3.45600000E-05  -1.17090000E-04  +4.11740000E-04
   +2.51140000E-04  -6.12500000E-05  -4.69700000E-05  +1.68310000E-04  +4.89530000E-04
   -3.31790000E-04  -2.31010000E-04  -1.59910000E-04  +3.37650000E-03  -1.29785000E-03
   -3.45500000E-05  -8.34990000E-04  +6.21130000E-04  +4.37500000E-04  -1.15380000E-04
   -1.05430000E-04  -4.67200000E-05  +3.82873400E-02  +8.59937000E-03  -6.95531800E-02
   +3.28924000E-03  +1.53647400E-02  +7.25594000E-03  +7.96484000E-03  -1.34823000E-03
   -3.99324000E-03  -7.95034000E-03  -4.92312000E-03  +4.96623000E-03  +1.37063200E-02
   +6.16260000E-04  -5.67920000E-02  -6.46481300E-02  -2.44724700E-02  +1.32955260E-01
   +6.75500000E-05  +1.31900000E-05  -2.93030000E-04  +3.61600000E-04  +6.21180000E-04
   +2.33300000E-05  -9.66100000E-05  +7.00100000E-05  +2.43900000E-05  -1.81430000E-04
   +3.84000000E-05  +2.24980000E-04  +8.78780000E-04  +4.61920000E-04  +1.83340000E-04
   -2.01590000E-04  -2.10970000E-04  -2.36030000E-04  +1.59974000E-03  -7.75300000E-05
   +5.65590000E-04  -8.88240000E-04  +1.27290000E-04  +3.72030000E-04  -1.03631000E-03
   -5.76110000E-04  -1.41750000E-04  -1.34040000E-04  +5.32343000E-03  -1.67536000E-03
   +1.32325000E-03  -9.46070000E-03  +1.95723000E-03  -4.87322700E-02  +3.82467500E-02
   +4.44209000E-03  -2.42639800E-01  +7.33129700E-02  +2.11130400E-02  +7.60281000E-03
   +9.37196000E-03  -4.70450000E-04  -4.63599000E-03  -4.69793000E-03  +1.52564000E-03
   +3.78701300E-01  -4.09800000E-05  +2.53400000E-05  +1.96790000E-04  -4.13370000E-04
   -4.87070000E-04  -1.34610000E-04  +9.48200000E-05  +2.19200000E-05  +3.68200000E-05
   +1.60640000E-04  -1.38000000E-06  -1.85550000E-04  -7.12480000E-04  -4.00560000E-04
   -1.79520000E-04  +2.03090000E-04  +2.09900000E-04  +2.04280000E-04  -1.11692000E-03
   +3.21110000E-04  -6.36320000E-04  +6.16960000E-04  -8.92400000E-05  -2.84880000E-04
   +8.70410000E-04  +5.08530000E-04  +1.20020000E-04  +5.98614000E-03  +2.98594000E-03
   -4.26840000E-04  -9.11190000E-04  -6.09747000E-03  +1.60897000E-03  -1.15287000E-03
   +8.54307000E-03  +2.22620000E-04  +1.25926590E-01  -1.82191830E-01  -3.90959000E-03
   +4.74455400E-02  -4.74474100E-02  -1.35071000E-03  -8.27243000E-03  +1.61311000E-03
   +1.54021000E-03  +4.38802000E-03  +6.97280190E-01  -3.96500000E-05  -2.55200000E-05
   +4.31100000E-05  +3.22000000E-05  -7.91900000E-05  -3.13700000E-05  +7.43000000E-05
   -1.58600000E-05  -1.55400000E-05  -1.39300000E-05  -1.51800000E-05  +2.90000000E-06
   -5.30200000E-05  -3.73700000E-05  -5.01400000E-05  +2.54500000E-05  +3.05600000E-05
   +4.19600000E-05  -1.52870000E-04  -1.26050000E-04  -5.70890000E-04  +6.37700000E-05
   +5.71300000E-05  -4.34400000E-05  +7.28700000E-05  +4.50500000E-05  +2.24500000E-05
   -9.35810000E-04  -1.11187000E-03  -1.00304000E-03  +1.09613000E-03  +2.64000000E-03
   +7.03517000E-03  +8.28513000E-03  -5.42403000E-03  +9.20400000E-03  +1.57985600E-02
   +3.69260000E-03  -4.66361800E-02  -4.79821000E-03  +4.34253000E-03  +7.75028000E-03
   +2.32695000E-03  +9.75500000E-04  +4.49156000E-03  -5.08677000E-02  -6.85569400E-02
   +4.14624300E-02  -2.19606000E-03  -1.20456000E-03  -3.49590000E-04  -4.60728000E-03
   -1.59392200E-02  -2.77211400E-02  -5.12888000E-03  -2.54610000E-03  +1.37557000E-03
   -2.41180000E-04  -4.89180000E-04  -1.42689000E-03  +4.47450000E-04  +1.05220000E-04
   +3.46800000E-05  +1.37430000E-04  -2.71690000E-04  -1.01319000E-03  -7.74179300E-02
   -3.90133000E-03  -4.43775000E-03  +7.90100000E-04  +2.44680000E-04  +1.18706000E-03
   -6.56520000E-04  -3.53610000E-04  -9.16600000E-05  +9.96000000E-05  +1.43712100E-02
   +2.20618700E-02  -1.55228000E-03  -2.60380000E-04  +5.63010000E-04  -1.29441000E-03
   -8.16900000E-05  -9.94090000E-04  +1.32252000E-03  +7.82900000E-05  -7.75800000E-05
   +1.77220000E-04  -2.17280000E-04  -5.81100000E-04  -2.35490000E-04  +3.12816000E-03
   +7.01360000E-04  -1.29983000E-03  +9.78320000E-04  +1.29320000E-04  +5.88137960E-01
   -3.07100000E-05  -1.00495000E-03  -9.12000000E-05  -5.30575000E-03  -9.96446000E-03
   -1.55645800E-02  -2.46770000E-03  -4.68710000E-04  +6.64620000E-04  +1.09800000E-04
   -1.90000000E-07  -7.95640000E-04  -9.57100000E-05  +1.74750000E-04  +6.94600000E-05
   +3.08750000E-04  -2.13560000E-04  -5.54880000E-04  -7.39018000E-03  -9.69279200E-02
   -4.36946100E-02  +6.38110000E-04  +1.02946600E-02  +2.00030300E-02  -2.26000000E-05
   -3.24500000E-05  -2.07500000E-05  +6.18279000E-03  -1.90242800E-02  -2.18301300E-02
   +9.96590000E-04  +6.06190000E-04  -7.32950000E-04  +9.04050000E-04  -1.38710000E-04
   +1.17367000E-03  -6.51040000E-04  +7.98900000E-05  +5.05000000E-05  -2.78610000E-04
   -2.29050000E-04  +4.25020000E-04  -1.12878000E-03  -3.83970000E-04  -5.96500000E-04
   +5.96450000E-04  -5.10120000E-04  -9.90500000E-05  -4.67018000E-03  +5.54856790E-01
   +6.82490000E-04  +1.18328000E-03  +4.25930000E-04  -5.76765000E-03  -3.71948000E-03
   -2.34930000E-03  +1.20490000E-03  +1.90780000E-04  +3.99800000E-04  +4.03700000E-04
   +4.93300000E-05  +1.94300000E-05  -2.77800000E-04  -1.81520000E-04  +2.47600000E-04
   +2.78380000E-04  +2.08300000E-05  -4.17900000E-04  -9.17916000E-03  -3.91861400E-02
   -1.49496850E-01  -2.09537000E-03  -8.62218000E-03  -3.61322600E-02  +3.71320000E-04
   +1.98330000E-04  -1.15200000E-05  +7.27001000E-03  -9.81817000E-03  -5.74846000E-03
   -8.88900000E-04  +1.59993000E-03  -4.22430000E-04  +1.93350000E-04  +6.16000000E-06
   -6.75600000E-05  +7.87500000E-05  -2.65700000E-04  +4.88100000E-05  -2.38710000E-04
   +7.59800000E-05  +1.63020000E-04  -8.29020000E-04  +7.91220000E-04  -2.08000000E-06
   -4.11730000E-04  +3.65020000E-04  +9.00000000E-07  -1.40682300E-02  -5.75313700E-02
   +4.96583640E-01  -5.29800000E-05  -7.87000000E-05  +8.25200000E-05  +2.51740000E-04
   -3.00860000E-04  -2.58000000E-05  -5.99900000E-05  -1.06530000E-04  +8.10400000E-05
   -7.66700000E-05  -7.32100000E-05  +1.22200000E-05  +1.88110000E-04  +1.23430000E-04
   +1.39200000E-05  -2.38600000E-05  -2.09500000E-05  -9.68600000E-05  -9.87070000E-04
   +6.98990000E-04  +2.88590000E-04  +3.12890000E-04  +9.47510000E-04  -1.15993000E-03
   -2.49570000E-04  -1.59060000E-04  -4.15800000E-05  +3.33960000E-04  +3.85391000E-03
   -3.54450000E-04  +1.31969000E-03  -5.15160000E-04  -1.44880000E-04  -2.35100000E-05
   +1.33430000E-04  -8.73200000E-05  -3.51330000E-04  -9.51940000E-04  +4.69430000E-04
   +1.97160000E-04  +4.42026000E-03  -1.72030000E-04  -1.13861600E-02  -4.93079100E-02
   +3.44095000E-03  +1.99670000E-04  +3.46910000E-04  -7.72300000E-05  +1.03634000E-03
   +3.38720000E-04  +8.22710000E-04  +1.09877680E-01  -6.82300000E-05  -3.28300000E-05
   +9.41200000E-05  -2.65900000E-05  +1.20990000E-04  -2.97800000E-05  +2.30900000E-05
   -1.71800000E-05  -3.04900000E-05  +1.01300000E-05  -1.91500000E-05  -4.28000000E-05
   -1.30010000E-04  -7.00500000E-05  -5.14200000E-05  +5.23200000E-05  +4.96800000E-05
   +5.40200000E-05  -1.10880000E-03  -2.03220000E-04  +6.59330000E-04  -2.31190000E-04
   -5.95370000E-04  -3.32860000E-04  +1.60810000E-04  +8.27500000E-05  +2.40200000E-05
   -8.58630000E-04  +6.46388000E-03  +9.09010000E-04  +2.25523000E-03  -1.72649000E-03
   -6.16250000E-04  -7.48720000E-04  -7.37100000E-05  +2.61460000E-04  -9.16850000E-04
   -3.97200000E-04  -5.64200000E-04  +2.23900000E-04  +7.44062000E-03  -8.76300000E-05
   -2.88055700E-02  -1.09596000E-01  +8.69021000E-03  -1.90360000E-04  +6.15900000E-04
   -9.19100000E-05  +5.54100000E-05  +1.48290000E-04  +1.89360000E-04  -2.16702100E-02
   +5.86225100E-02  +7.77800000E-05  -1.80900000E-05  -1.32480000E-04  -7.18100000E-05
   +4.34700000E-05  +4.25230000E-04  +6.41400000E-05  -1.29700000E-05  -8.30300000E-05
   +6.51800000E-05  +4.93400000E-05  +6.60500000E-05  -1.31100000E-05  +1.25000000E-05
   +4.73900000E-05  -8.14300000E-05  -1.20600000E-05  +2.64400000E-05  -7.55500000E-05
   +1.04000000E-06  -1.13836000E-03  -6.26830000E-04  +6.86850000E-04  +1.91690000E-04
   +1.53000000E-06  +5.46000000E-06  +1.32900000E-05  +2.94930000E-04  +2.53850000E-04
   -1.66172000E-03  +3.09740000E-04  -2.35160000E-04  +9.68200000E-04  -1.98720000E-04
   -1.47090000E-04  -1.43460000E-04  -1.92850000E-04  +1.39030000E-04  +1.02664000E-03
   -2.44120000E-04  +9.79540000E-04  -1.27430000E-03  -3.09483000E-03  -9.87395000E-03
   +4.20161000E-03  +1.90300000E-05  +5.87900000E-05  +1.00920000E-04  -6.49340000E-04
   -6.72970000E-04  -3.21020000E-04  +2.04191120E-01  -7.42786300E-02  +4.35106140E-01
   +1.33692000E-03  -7.29580000E-04  -1.39227000E-03  +7.29400000E-05  +2.65590000E-04
   +7.85580000E-04  -6.66440000E-04  -1.93410000E-04  -3.51800000E-04  +1.98904000E-03
   +7.33370000E-04  -1.90628000E-03  -1.04915600E-02  -1.86348000E-02  -4.24769000E-02
   -5.76068000E-03  -3.40575000E-03  +1.41821000E-03  -2.27420000E-04  +2.54000000E-06
   +1.02310000E-04  +8.86300000E-05  +7.41000000E-06  -1.03100000E-05  -4.13913600E-02
   -2.38677300E-02  -1.42447500E-02  +2.70500000E-05  +1.13170000E-04  +1.19300000E-05
   -1.58500000E-05  -4.38300000E-05  +2.99400000E-05  +4.14700000E-05  +4.58300000E-05
   -3.10000000E-07  -1.29900000E-04  +1.13700000E-04  +4.12000000E-06  +5.76400000E-05
   -2.66000000E-05  -4.90000000E-07  -7.97300000E-05  -1.39220000E-04  +1.44900000E-05
   +1.48520000E-04  -1.12510000E-04  -5.92000000E-06  +8.90100000E-05  +1.67300000E-05
   -2.75200000E-05  +2.73300000E-05  -2.19000000E-05  +1.66000000E-06  +5.58889900E-02
   -1.15760000E-04  +1.12555000E-03  -1.46958000E-03  +3.40100000E-05  +3.06840000E-04
   +4.28330000E-04  -2.33100000E-05  -8.10000000E-04  -2.90800000E-04  +2.83227000E-03
   +8.13650000E-04  +8.30020000E-04  -4.01041000E-03  -1.25962900E-02  -2.22348900E-02
   -3.96456000E-03  +4.44860000E-04  +8.16300000E-04  -1.48020000E-04  -9.39000000E-05
   +2.57400000E-05  +3.81400000E-05  +3.76000000E-06  +1.66100000E-05  -3.96538400E-02
   -8.10576700E-02  -1.66622520E-01  +3.24800000E-05  +1.06820000E-04  +2.45800000E-05
   +1.87600000E-05  -1.25700000E-05  -9.40000000E-07  +3.72700000E-05  +3.16300000E-05
   -1.07500000E-05  -7.54000000E-05  +9.14600000E-05  +2.09000000E-06  +2.89400000E-05
   -4.22400000E-05  -9.80000000E-07  -2.77300000E-05  -7.14900000E-05  +1.44200000E-05
   +1.07790000E-04  -1.04680000E-04  -8.94000000E-06  +6.60800000E-05  +6.49000000E-06
   -1.66400000E-05  +3.60200000E-05  -1.24400000E-05  -8.20000000E-07  +4.53020600E-02
   +9.19253400E-02  +2.61420000E-04  -6.11720000E-04  -3.31900000E-04  +1.72560000E-04
   +1.75460000E-04  +2.81280000E-04  -3.87100000E-05  -1.66670000E-04  -1.03912000E-03
   +3.96353000E-03  +3.73850000E-03  +4.06714000E-03  +1.30570000E-04  -9.22900000E-04
   -5.47374000E-03  +4.09100000E-05  +9.54900000E-05  +2.40758000E-03  -1.89950000E-04
   -7.37800000E-05  -1.42240000E-04  +1.25990000E-04  +4.69500000E-05  +7.33600000E-05
   -6.02481400E-02  -1.89661750E-01  -4.63692520E-01  +7.58800000E-05  +1.05520000E-04
   +1.80900000E-05  -7.97000000E-06  -2.83000000E-05  -6.55000000E-06  +3.05100000E-05
   +1.68900000E-05  -1.25400000E-05  -5.63200000E-05  +5.11800000E-05  +6.84000000E-06
   +3.65300000E-05  -9.01000000E-06  -6.64000000E-06  -2.54300000E-05  -9.12500000E-05
   +5.27000000E-06  +7.21500000E-05  -5.64800000E-05  -1.13700000E-05  +2.74200000E-05
   +4.45000000E-06  -2.92100000E-05  +1.38300000E-05  -1.30600000E-05  -2.56000000E-06
   +5.60622600E-02  +1.87589640E-01  +4.64358540E-01  -1.51923000E-03  -1.68180000E-04
   +4.73570000E-04  -3.01096000E-03  -4.78940000E-03  +1.11887000E-03  -1.55742000E-03
   -1.15470400E-02  -2.59164300E-02  -6.87284800E-02  -3.53797100E-02  -4.85052200E-02
   +7.02522000E-03  +7.72960000E-03  +1.71335100E-02  -1.23032000E-03  -1.76919000E-03
   +4.21450000E-03  +4.58300000E-04  -4.50230000E-04  -1.18240000E-03  +4.46900000E-05
   +8.92000000E-05  -1.09300000E-04  +2.16105000E-03  +2.93519000E-03  -1.50680000E-04
   +9.43000000E-05  -1.21120000E-04  -1.16300000E-05  -3.82500000E-05  +1.62200000E-05
   +4.72200000E-05  -2.61200000E-05  +8.86000000E-06  +2.40500000E-05  +3.22100000E-05
   -6.16100000E-05  -3.00000000E-06  -2.37900000E-05  +4.00100000E-05  +6.48000000E-06
   +1.15900000E-05  +5.80900000E-05  -1.04400000E-05  -6.98500000E-05  +7.39600000E-05
   +1.45100000E-05  -4.73950000E-04  -1.39570000E-04  +8.35400000E-05  -3.66100000E-05
   +6.66000000E-06  +1.75900000E-05  -6.23120000E-04  -7.62950000E-04  -5.57340000E-04
   +6.72675900E-02  +8.52800000E-05  -6.03270000E-04  +5.39400000E-04  -5.05677000E-03
   +4.56463000E-03  -9.66960000E-04  -2.02524000E-03  -3.45805000E-03  -1.39373100E-02
   -3.52132000E-02  -9.15591600E-02  -1.10435860E-01  -2.66953000E-03  +3.18454000E-03
   +1.19509000E-03  -1.61381000E-03  +4.30825000E-03  -6.59100000E-04  +1.05240000E-04
   +2.13320000E-04  -8.12380000E-04  -8.50700000E-05  -8.06000000E-06  +4.34600000E-05
   +2.66554000E-03  -1.73890000E-03  +2.07648000E-03  +7.41800000E-05  -1.53790000E-04
   +5.21000000E-06  +5.61000000E-05  +2.08600000E-05  -2.72000000E-05  -4.69000000E-05
   -1.36000000E-06  +1.01500000E-05  +7.40500000E-05  -1.86500000E-05  -7.86000000E-06
   -2.48000000E-05  -2.32100000E-05  +6.29000000E-06  -1.14400000E-05  +8.85800000E-05
   +2.34000000E-05  -6.19100000E-05  +3.85500000E-05  +4.84000000E-06  -2.07300000E-04
   -1.06590000E-04  +1.16820000E-04  -1.28100000E-05  +1.06000000E-05  +8.53000000E-06
   +1.92240000E-04  +3.87450000E-04  -7.45330000E-04  +4.15285900E-02  +8.86607800E-02
   +7.48300000E-04  +7.89030000E-04  +2.76250000E-04  +5.60310000E-04  -1.44872000E-03
   +2.76911000E-03  +8.70990000E-04  -3.33640000E-04  +5.37570000E-04  -4.88649500E-02
   -1.10552310E-01  -2.68459500E-01  -1.11952500E-02  -1.31381500E-02  -1.65783500E-02
   +4.78005000E-03  -3.15390000E-04  -2.01167000E-03  +3.24820000E-04  -7.58800000E-05
   -8.09700000E-05  -5.66900000E-05  +9.39000000E-06  -4.27800000E-05  -7.85750000E-04
   +1.81956000E-03  +2.22766000E-03  -1.15100000E-05  -6.89800000E-05  -1.25300000E-05
   -4.79000000E-05  +1.44000000E-05  +2.16000000E-05  -1.32700000E-05  -1.67100000E-05
   +1.03600000E-05  +3.23600000E-05  -6.84900000E-05  +1.41000000E-06  -2.35900000E-05
   +4.29100000E-05  +1.06000000E-06  +3.76900000E-05  +5.60700000E-05  -3.27600000E-05
   -6.83500000E-05  +6.96200000E-05  +8.07000000E-06  -1.34900000E-04  -9.62000000E-06
   +2.46800000E-05  -2.63300000E-05  +7.89000000E-06  +4.28000000E-06  +2.07301000E-03
   +5.24000000E-04  -7.73840000E-04  +5.32936200E-02  +1.21795090E-01  +2.82904100E-01
   +1.68638000E-03  -2.82773000E-03  -1.13929000E-03  +8.79593000E-03  +7.53200000E-05
   -5.56342000E-03  -1.67176770E-01  -9.72288000E-03  +1.39449880E-01  -1.32637700E-02
   +2.29900000E-05  +2.29691000E-02  -1.72791000E-03  -5.19340000E-03  -1.10523000E-03
   -4.76300000E-04  +3.35900000E-05  -8.96570000E-04  -7.35260000E-04  +9.05600000E-04
   -4.73400000E-04  -6.78010000E-04  -9.55370000E-04  -2.54010000E-04  -1.38104000E-03
   -2.75740000E-04  +1.12529000E-03  -3.96350000E-04  -2.44400000E-05  -1.66590000E-04
   -2.83000000E-04  +1.75700000E-04  -3.02130000E-04  +1.59530000E-04  -1.45500000E-05
   -4.26500000E-05  -1.71650000E-04  +1.00800000E-05  +1.91900000E-05  -3.78900000E-05
   +3.29800000E-05  -3.06700000E-05  -6.17000000E-06  -6.34500000E-05  +1.96260000E-04
   +1.24990000E-04  -9.20700000E-05  -2.72000000E-06  +1.43250000E-04  +1.25290000E-04
   -1.90500000E-05  -1.08600000E-05  -1.03200000E-05  -5.91000000E-06  +1.63050000E-04
   +1.61440000E-04  +1.82900000E-04  -6.24700000E-05  +1.87471000E-03  -9.38690000E-04
   +1.75126700E-01  -3.07345000E-03  +3.45595000E-03  -4.24193000E-03  +9.33933000E-03
   +5.07654000E-03  -9.91463000E-03  -9.52342000E-03  -4.51933600E-02  -3.12390000E-03
   -1.03856800E-02  +3.62757000E-03  +1.20875100E-02  -5.09371000E-03  +4.44123000E-03
   -2.76872000E-03  +2.03000000E-05  -1.15482000E-03  +4.25900000E-05  +1.55781000E-03
   -1.94267000E-03  +8.88070000E-04  -4.32000000E-04  -8.06860000E-04  -6.41740000E-04
   -6.57300000E-04  -1.98330000E-04  +6.67520000E-04  +2.27300000E-05  +2.47350000E-04
   -8.45200000E-05  +6.08100000E-05  +2.58240000E-04  -9.30100000E-05  +7.76900000E-05
   -1.53240000E-04  -1.08820000E-04  -3.08700000E-05  -5.85000000E-06  +2.56400000E-05
   -6.45400000E-05  +1.17600000E-05  +1.86300000E-05  +1.10260000E-04  -4.13700000E-05
   -1.00640000E-04  +2.46700000E-05  -5.61000000E-05  +4.90000000E-07  +5.82300000E-05
   -2.29310000E-04  +1.57480000E-04  +9.06200000E-05  -2.56000000E-06  +2.64200000E-05
   +8.68000000E-05  +5.20000000E-05  +9.79200000E-05  +2.05588000E-03  -3.03801000E-03
   +1.33843000E-03  +1.66005900E-02  +3.75699300E-02  -1.59224000E-03  -4.53096000E-03
   -3.54417000E-03  +1.90956300E-02  +1.86079000E-03  -1.57654300E-02  +1.39444520E-01
   -2.81471000E-03  -2.27555690E-01  -3.81006000E-03  -1.28522000E-03  +5.82999000E-03
   -6.21910000E-04  -2.51878000E-03  +2.19905000E-03  -1.04919000E-03  -4.62800000E-05
   +5.06200000E-05  +6.75650000E-04  +1.66133000E-03  -3.81530000E-04  +3.90530000E-04
   +7.89200000E-05  -3.41370000E-04  +3.16800000E-05  +8.99600000E-05  +1.67940000E-04
   -3.65800000E-04  -1.32010000E-04  -1.86000000E-06  +4.70700000E-05  +4.24100000E-05
   +9.97900000E-05  -1.41960000E-04  +1.32060000E-04  +8.83200000E-05  -8.77800000E-05
   +3.08720000E-04  -5.88300000E-05  +1.18880000E-04  -2.36840000E-04  +4.55000000E-06
   -4.84420000E-04  -2.22100000E-05  +1.33450000E-04  +2.06510000E-04  -1.91550000E-04
   -1.01700000E-05  -1.17450000E-04  +1.42500000E-05  +4.29400000E-05  -4.71000000E-06
   -2.77100000E-05  +3.53900000E-05  -2.66300000E-05  -6.96000000E-06  -1.71400000E-05
   -5.27900000E-04  +1.61122000E-03  +3.50170000E-04  -1.52332810E-01  +5.10957000E-03
   +2.38492560E-01  -6.81312500E-02  -3.21215200E-02  -4.96195100E-02  +1.00498100E-02
   +8.65351000E-03  +1.64594300E-02  -1.29863000E-03  -2.29808000E-03  +4.56150000E-03
   -1.26029000E-03  +3.03300000E-05  +3.70850000E-04  -2.61039000E-03  -4.85856000E-03
   +1.16570000E-03  -2.32396000E-03  -1.23279700E-02  -2.53727900E-02  -1.46420000E-04
   +1.65331000E-03  -8.62700000E-04  +4.16320000E-04  -4.87600000E-05  -1.38320000E-04
   -2.34570000E-04  -6.29260000E-04  -1.36291000E-03  -2.89900000E-04  -1.23340000E-04
   -8.06500000E-05  +2.72000000E-05  -3.34800000E-05  -3.77700000E-05  +2.09500000E-05
   +1.30000000E-06  -2.38400000E-05  -8.20300000E-05  +8.85100000E-05  +1.82300000E-05
   -1.13200000E-05  -6.22500000E-05  +7.99000000E-06  -6.83100000E-05  +5.61300000E-05
   +1.15600000E-05  +1.04970000E-04  -9.82900000E-05  -1.06900000E-05  -2.11538000E-03
   -1.47183000E-03  +9.64910000E-04  +8.29800000E-05  -1.08000000E-06  -5.63700000E-05
   -3.75340000E-04  -1.39640000E-04  -1.02430000E-04  -8.54800000E-05  +2.72120000E-04
   -1.33060000E-04  +3.22880000E-04  +5.31810000E-04  +1.02598000E-03  +7.11924200E-02
   -3.16752800E-02  -9.53493000E-02  -1.11040280E-01  -4.89000000E-06  +4.68633000E-03
   +8.64930000E-04  -2.33205000E-03  +5.13386000E-03  -9.65250000E-04  +1.04080000E-04
   -7.73100000E-04  +6.61140000E-04  -4.86500000E-03  +5.07695000E-03  -1.30694000E-03
   -2.82331000E-03  -2.23588000E-03  -1.38493400E-02  +1.46612000E-03  -2.93755000E-03
   +6.07600000E-04  -5.13570000E-04  -2.61440000E-04  +1.33600000E-05  -2.27110000E-04
   -3.54470000E-04  -7.76220000E-04  +4.26960000E-04  +4.25120000E-04  -1.64710000E-04
   +8.61300000E-05  +1.55800000E-04  +3.27600000E-05  +4.34600000E-05  -6.58900000E-05
   +4.34100000E-05  -3.66200000E-05  +1.07000000E-05  -1.83000000E-06  +1.03200000E-05
   +2.30400000E-05  -3.26000000E-06  +1.19010000E-04  -1.47550000E-04  +8.00000000E-06
   +2.69500000E-05  -4.02700000E-05  +4.34000000E-06  -2.15212000E-03  -2.53690000E-04
   +2.75130000E-04  +2.84200000E-05  -1.53000000E-06  -1.57000000E-05  -9.05600000E-05
   -2.34840000E-04  +3.10700000E-05  +2.53360000E-04  -5.34230000E-04  +1.52690000E-04
   -9.86000000E-06  +1.18620000E-04  +1.61690000E-04  +4.18352900E-02  +9.21654200E-02
   -4.92549800E-02  -1.10429850E-01  -2.79315880E-01  -6.75170000E-03  -1.07909100E-02
   -1.61202000E-02  +4.70353000E-03  -8.86760000E-04  -2.13137000E-03  +4.62180000E-04
   +7.64140000E-04  +4.06420000E-04  +1.10365000E-03  -1.38326000E-03  +2.64243000E-03
   +1.27857000E-03  -5.83870000E-04  +7.29470000E-04  -2.01606000E-03  -4.91800000E-05
   -9.59920000E-04  +3.45940000E-04  +9.84500000E-05  +7.53800000E-05  -2.48800000E-04
   -2.12090000E-04  -2.00960000E-04  -3.50000000E-05  -3.14000000E-06  +1.06300000E-04
   -3.56000000E-06  -6.95400000E-05  +6.08800000E-05  -2.12100000E-05  +3.35100000E-05
   +1.18700000E-05  +3.80700000E-05  -3.01700000E-05  -1.61300000E-05  +2.99600000E-05
   +3.04100000E-05  -4.70000000E-07  -3.95700000E-05  -5.61300000E-05  +1.64800000E-05
   -3.77200000E-05  +4.84400000E-05  +5.58000000E-06  -1.15257000E-03  -7.92820000E-04
   +2.36300000E-04  -9.17400000E-05  -9.89000000E-06  +8.01400000E-05  -4.03000000E-06
   +7.64500000E-05  +2.64400000E-05  -1.75510000E-04  +1.30780000E-04  -1.18940000E-04
   -4.37830000E-04  -5.58370000E-04  -9.61100000E-04  +5.42639500E-02  +1.22916810E-01
   +2.93982490E-01  -1.20957100E-02  +5.97930000E-04  +2.18966100E-02  -2.14438000E-03
   -4.92585000E-03  -9.64660000E-04  -4.68630000E-04  -5.96000000E-05  -9.59080000E-04
   +1.29446000E-03  -2.60076000E-03  -1.11440000E-03  +7.67202000E-03  -1.19286000E-03
   -6.40197000E-03  -1.70090330E-01  -1.55016700E-02  +1.43264600E-01  -1.42200000E-05
   +1.80790000E-04  +1.04848000E-03  -3.23740000E-04  -1.17330000E-04  -1.13800000E-04
   +2.37110000E-04  +1.88499000E-03  -1.15890000E-04  -2.58500000E-05  -2.38690000E-04
   +1.79400000E-05  -2.00700000E-05  +1.93900000E-05  -2.65600000E-05  -3.83500000E-05
   +3.67000000E-06  -2.56000000E-06  +4.94900000E-05  -3.84200000E-05  -6.80000000E-07
   -2.66900000E-05  +3.33000000E-06  -4.80000000E-07  -2.56500000E-05  +1.16520000E-04
   +2.25000000E-06  -6.36200000E-05  +5.81900000E-05  -5.10000000E-07  -6.27000000E-06
   +1.00360000E-04  +7.37200000E-05  -2.40600000E-05  +8.06000000E-06  -7.05000000E-06
   -7.25100000E-05  +2.59190000E-04  +3.57900000E-05  +3.71110000E-04  +4.43700000E-05
   -4.52430000E-04  -1.42590000E-04  +2.88770000E-04  -1.03400000E-05  -7.58100000E-05
   +1.86485000E-03  -9.03620000E-04  +1.76016300E-01  -8.99439000E-03  +2.56236000E-03
   +1.24854800E-02  -4.90760000E-03  +3.81181000E-03  -2.41236000E-03  -1.22110000E-04
   -1.13938000E-03  -1.09800000E-04  -2.76560000E-03  +2.93996000E-03  -3.75909000E-03
   +8.88767000E-03  +5.86737000E-03  -1.09662000E-02  -1.58669200E-02  -4.25428700E-02
   +2.08463000E-03  -2.30670000E-04  +4.10680000E-04  +5.15750000E-04  -4.45700000E-05
   +8.14700000E-05  -4.69000000E-05  +1.72559000E-03  -2.09740000E-03  +1.80989000E-03
   -2.06810000E-04  -1.62900000E-04  -3.47600000E-05  -3.48000000E-06  -5.79000000E-06
   +4.21600000E-05  +5.60000000E-07  +2.36000000E-06  +6.15000000E-06  +2.02900000E-05
   -2.65700000E-05  -6.66000000E-06  -3.60500000E-05  -6.03000000E-06  +1.37800000E-05
   -2.81000000E-06  +9.57600000E-05  -5.98800000E-05  -2.54800000E-05  +1.76400000E-05
   +3.79000000E-06  +5.18700000E-05  -2.57800000E-05  +7.18100000E-05  +7.82000000E-06
   +4.16000000E-06  -2.37000000E-06  +2.33910000E-04  -3.20630000E-04  +3.40310000E-04
   +5.04590000E-04  -6.10000000E-06  -5.36130000E-04  +2.74390000E-04  -4.99730000E-04
   +2.38130000E-04  +2.07320000E-03  -2.99337000E-03  +1.31196000E-03  +1.94229600E-02
   +3.40634500E-02  -4.21108000E-03  -5.56920000E-04  +6.79830000E-03  -6.17310000E-04
   -2.07910000E-03  +2.26365000E-03  -1.28669000E-03  -3.59180000E-04  -1.96400000E-04
   -1.64737000E-03  -4.05090000E-03  -3.29570000E-03  +2.15449000E-02  +3.04333000E-03
   -1.58591100E-02  +1.41753880E-01  +1.29764000E-03  -2.27336480E-01  -2.00050000E-04
   -1.16990000E-04  +2.12430000E-04  -2.96000000E-05  -5.94300000E-05  -1.21200000E-05
   -4.03110000E-04  +1.65739000E-03  +1.54346000E-03  +3.81400000E-05  +2.94000000E-05
   +1.16300000E-05  +2.55000000E-06  +6.62000000E-06  -1.80600000E-05  +6.15000000E-06
   +8.56000000E-06  -2.30000000E-07  -2.60500000E-05  +2.41200000E-05  +2.75000000E-06
   +1.21200000E-05  -4.31000000E-06  -1.70000000E-06  -1.56500000E-05  -3.55300000E-05
   +1.18400000E-05  +2.93700000E-05  -2.36100000E-05  -1.21000000E-06  +4.80900000E-05
   +3.76600000E-05  -1.23900000E-05  +4.51000000E-06  -3.79000000E-06  -3.00000000E-06
   -5.60600000E-05  +2.91550000E-04  +3.17270000E-04  +8.50620000E-04  +9.23800000E-05
   -9.57160000E-04  -3.35400000E-05  +2.16270000E-04  -7.54300000E-05  -4.01420000E-04
   +1.55724000E-03  +3.67450000E-04  -1.55331520E-01  -9.75630000E-04  +2.36263380E-01
   +4.29760000E-04  +1.80380000E-04  +5.44200000E-05  +7.08930000E-04  -1.42917000E-03
   +9.65200000E-05  +1.65790000E-04  -8.13200000E-05  +1.89850000E-04  +1.14300000E-05
   +1.18150000E-04  -5.72300000E-05  -7.65400000E-05  +9.92000000E-06  +4.51700000E-05
   -3.90400000E-05  +6.22000000E-06  -1.21260000E-04  +7.82940000E-04  -2.48461000E-03
   +1.23283000E-03  -2.23219800E-01  +1.28376370E-01  +9.69479000E-03  +7.86400000E-05
   +6.41000000E-06  +7.31000000E-06  +5.09180000E-04  -2.67200000E-05  +3.65010000E-04
   +3.41000000E-06  -5.29030000E-04  -1.84270000E-04  -1.19660000E-04  +1.28890000E-04
   -8.57500000E-05  +1.98720000E-04  -2.49800000E-05  -4.76400000E-05  +1.56090000E-04
   -8.73000000E-06  -9.40900000E-05  -9.96000000E-06  -6.29900000E-05  -6.53200000E-05
   -1.27660000E-04  +1.40720000E-04  +2.59900000E-05  -1.44140000E-04  -1.40820000E-04
   -4.84100000E-05  -4.39130000E-04  -4.73000000E-06  -3.64540000E-04  -1.51700000E-05
   -4.10000000E-07  -4.88000000E-06  +6.58000000E-06  +1.33000000E-05  +3.23000000E-06
   +3.54100000E-05  -1.87900000E-05  -4.94500000E-05  +1.79800000E-05  -1.13500000E-05
   -8.59000000E-06  +1.96100000E-05  +1.80400000E-05  -2.40000000E-06  +2.39231870E-01
   -5.23520000E-04  +3.35500000E-05  +1.72760000E-04  +1.36595000E-03  +5.54490000E-04
   -2.52120000E-04  -1.47360000E-04  -1.34400000E-05  -5.26320000E-04  -2.15450000E-04
   -3.31000000E-06  -2.70300000E-05  -1.87190000E-04  -2.26660000E-04  -1.79940000E-04
   +1.30760000E-04  +8.05900000E-05  +2.13070000E-04  +1.74269800E-02  -1.52162700E-02
   -6.44390000E-04  +1.25836970E-01  -1.37713800E-01  -8.23733000E-03  +2.59840000E-04
   +1.79060000E-04  +5.68400000E-05  -1.23707000E-03  -2.08129000E-03  +3.90440000E-03
   +9.81040000E-04  -2.73100000E-05  +2.92000000E-05  +2.25080000E-04  -2.54740000E-04
   -3.35670000E-04  -4.82350000E-04  +1.02460000E-04  +9.88800000E-05  +8.87000000E-05
   +8.26000000E-05  -3.46500000E-05  -6.41090000E-04  -7.88590000E-04  +4.61800000E-05
   +4.44590000E-04  -3.24530000E-04  -1.23600000E-05  -1.00880000E-04  +4.03610000E-04
   -1.15500000E-03  -4.09550000E-04  -2.27500000E-05  -1.98140000E-04  -1.81200000E-05
   -3.70500000E-05  -1.96500000E-05  +1.34600000E-05  -1.93200000E-05  +1.75400000E-05
   +1.56970000E-04  -5.05000000E-06  +1.35490000E-04  +2.22600000E-05  -4.85000000E-06
   -1.07000000E-06  +9.23000000E-06  -1.16000000E-05  -1.66000000E-06  -1.39062280E-01
   +1.50297680E-01  +2.71900000E-05  -2.19090000E-04  +3.23700000E-05  -8.46700000E-04
   -4.05830000E-04  +7.84100000E-04  +2.34160000E-04  -1.84800000E-05  -1.65330000E-04
   -2.92620000E-04  +7.86400000E-05  +1.27930000E-04  +9.38700000E-05  +1.99900000E-05
   -8.97800000E-05  +6.73000000E-05  +5.29300000E-05  -6.12500000E-05  -1.92971300E-02
   +1.44773000E-02  -2.63820000E-04  +1.09743800E-02  -9.05163000E-03  -4.83947900E-02
   -1.54660000E-04  -1.03390000E-04  -1.42800000E-05  +1.07008000E-03  +2.61833000E-03
   -3.00056000E-03  -1.05844000E-03  +6.14800000E-04  +1.11910000E-04  +8.54000000E-05
   +2.23550000E-04  +2.07870000E-04  +9.92600000E-05  -9.42800000E-05  -6.48000000E-05
   -1.10690000E-04  +1.09410000E-04  -9.99000000E-06  +3.04790000E-04  +3.09250000E-04
   +1.41760000E-04  -1.91870000E-04  +1.47310000E-04  +1.43600000E-05  -8.73410000E-04
   +4.34740000E-04  +1.20250000E-03  -6.35400000E-05  -8.81100000E-05  -5.23800000E-05
   +9.08000000E-06  +4.23000000E-06  +1.81300000E-05  +9.28000000E-06  -1.47800000E-05
   -9.07000000E-06  +1.79730000E-04  +9.80000000E-07  +3.76500000E-05  +2.39800000E-05
   +3.07500000E-05  -4.70900000E-05  -1.09300000E-05  +1.40800000E-05  +1.38000000E-06
   -1.20915900E-02  +5.07392000E-03  +5.08011500E-02  +6.64880000E-04  -5.82100000E-05
   -2.93390000E-04  +3.38720000E-04  -5.84390000E-04  +2.95810000E-04  +1.14680000E-04
   +9.91300000E-05  +3.56360000E-04  +8.01000000E-05  +6.77600000E-05  -5.43000000E-06
   +1.87080000E-04  +1.65430000E-04  +2.03170000E-04  -1.89080000E-04  -1.25190000E-04
   -2.04750000E-04  -4.48240000E-04  +6.79040000E-04  -2.91600000E-05  -2.31957190E-01
   -1.27905010E-01  -2.25353000E-02  -2.43980000E-04  -1.47380000E-04  -5.42800000E-05
   +4.47140000E-04  -4.40660000E-04  +4.23100000E-04  -2.07180000E-04  -1.43000000E-05
   +5.62000000E-05  +4.02700000E-05  -2.56400000E-05  -2.50800000E-05  -2.46300000E-05
   +1.02400000E-04  +1.76000000E-05  -6.76300000E-05  -1.76280000E-04  -1.81700000E-05
   -4.48400000E-04  +1.74597000E-03  -3.33280000E-04  +5.67400000E-05  -8.73000000E-05
   +2.23000000E-06  +2.45250000E-04  +3.67370000E-04  -3.52030000E-04  -2.34572000E-03
   +1.28565000E-03  -4.68670000E-04  +1.68300000E-05  +1.69200000E-05  +2.42900000E-05
   -1.41700000E-05  -1.70000000E-06  -1.19800000E-05  -3.14400000E-05  -1.96300000E-05
   -7.60400000E-05  -2.32500000E-05  +1.18800000E-05  +4.98600000E-05  -1.27300000E-05
   +7.75000000E-06  -3.64000000E-06  -1.88636600E-02  -1.48477900E-02  -3.09969000E-03
   +2.51590830E-01  -2.87980000E-04  -5.60150000E-04  -4.27070000E-04  +1.94180000E-04
   -1.77889000E-03  +3.36560000E-03  -2.47050000E-04  +3.53600000E-05  +1.34660000E-04
   +5.71800000E-05  -6.65000000E-06  +1.12190000E-04  +2.13200000E-04  +1.25150000E-04
   +2.78050000E-04  -4.41310000E-04  +5.93000000E-06  -4.30200000E-05  -1.75914200E-02
   -1.24346200E-02  -2.50596000E-03  -1.25274020E-01  -1.36982790E-01  -1.57798900E-02
   -3.73540000E-04  -1.73280000E-04  -8.00100000E-05  -5.75130000E-04  +8.64430000E-04
   -3.91720000E-04  +1.79890000E-04  -4.18040000E-04  -1.36980000E-04  -3.15400000E-04
   +2.45280000E-04  +3.65500000E-05  +2.72040000E-04  +1.84830000E-04  -7.75200000E-05
   +3.35990000E-04  -1.67050000E-04  -6.01900000E-05  +1.15100000E-05  -5.35520000E-04
   -5.46000000E-06  -7.82700000E-05  +9.13600000E-05  +8.48000000E-06  -7.58200000E-05
   +7.10100000E-04  -1.61927000E-03  -9.82550000E-04  +2.06770000E-04  -4.71500000E-04
   +3.15800000E-05  +1.35700000E-05  +3.11500000E-05  -2.89300000E-05  -3.26900000E-05
   -2.73800000E-05  +4.32100000E-05  +2.39080000E-04  +4.42800000E-05  +4.32500000E-05
   -4.67100000E-05  +9.32400000E-05  -1.01500000E-04  +6.54000000E-06  -2.24900000E-05
   +1.65618500E-02  +1.26530200E-02  +2.57372000E-03  +1.37401670E-01  +1.46199850E-01
   +7.25750000E-04  +5.83550000E-04  +3.18260000E-04  -8.24290000E-04  +2.81085000E-03
   -3.74609000E-03  +1.20000000E-07  -4.83320000E-04  -3.52590000E-04  +3.25550000E-04
   -9.43900000E-05  +1.28300000E-04  -3.10840000E-04  -9.11000000E-05  +1.24400000E-05
   +2.47200000E-04  -2.78680000E-04  +1.37030000E-04  +2.05935500E-02  +1.38580000E-02
   +6.53620000E-04  -2.46256300E-02  -1.78459900E-02  -5.11380400E-02  +3.59800000E-04
   +2.57750000E-04  +8.11700000E-05  +2.65310000E-04  -1.13099000E-03  +4.87000000E-04
   -1.02690000E-04  +2.16030000E-04  +8.24900000E-05  +1.40730000E-04  -6.52100000E-05
   -2.61500000E-05  -9.06800000E-05  -5.22700000E-05  +5.78600000E-05  -1.55990000E-04
   -1.10060000E-04  -4.96000000E-06  -1.26370000E-04  +7.84040000E-04  -1.40210000E-04
   +5.44800000E-05  -6.76500000E-05  -8.91000000E-06  +1.30899000E-03  +7.51030000E-04
   +1.16738000E-03  +4.45510000E-04  +3.32910000E-04  -4.55270000E-04  +2.21000000E-06
   -6.13000000E-06  -4.34500000E-05  +3.62700000E-05  +3.40000000E-06  +1.65100000E-05
   -2.40480000E-04  +4.17160000E-04  +3.13220000E-04  -4.99000000E-05  +1.55620000E-04
   -6.99800000E-05  +8.34500000E-05  +2.98800000E-05  +2.70000000E-06  +1.92106000E-03
   +1.25881000E-03  -7.39490000E-04  +2.61669600E-02  +1.47732800E-02  +5.56264200E-02
   -2.72520000E-04  -1.00170000E-04  +5.17700000E-05  +2.60240000E-04  +6.72550000E-04
   +2.02890000E-04  -4.04220000E-04  -2.02100000E-04  +5.06250000E-04  -2.71630000E-04
   -2.72500000E-05  -1.42230000E-04  -3.67200000E-05  -8.96100000E-05  -2.19680000E-04
   +2.60720000E-04  +1.11530000E-04  +6.77000000E-05  -1.90338000E-03  +9.48300000E-04
   +7.79310000E-04  -4.72095300E-02  +2.45915000E-03  +5.94774000E-03  +1.20900000E-04
   +4.55400000E-05  +1.25000000E-06  +3.00080000E-04  -1.75400000E-04  -8.11320000E-04
   +4.81100000E-05  +1.51650000E-04  -6.80000000E-06  +1.16330000E-04  -8.39900000E-05
   +1.07000000E-05  -1.79360000E-04  -3.04500000E-05  +6.34000000E-06  -7.13500000E-05
   +2.32690000E-04  +8.93100000E-05  -2.19600000E-05  -4.90910000E-04  +1.10230000E-04
   +7.52400000E-05  -5.46700000E-05  -2.86000000E-06  +1.98300000E-05  -1.00700000E-04
   -2.06530000E-04  -5.47310000E-04  -1.38000000E-05  +5.60800000E-05  -3.09000000E-05
   -2.29700000E-05  +1.71000000E-06  +7.44000000E-06  -1.69000000E-05  +1.88800000E-05
   -1.20950000E-04  -1.36763000E-03  +1.87200000E-05  +2.99700000E-05  +9.22000000E-06
   -6.04800000E-05  +6.08000000E-06  +3.47000000E-06  -5.81000000E-06  -4.00200000E-05
   +1.10378600E-02  +2.43660500E-02  +2.49475000E-03  -1.09408500E-02  -2.45025600E-02
   +4.61525800E-02  -2.96130000E-04  +1.10540000E-04  +5.05200000E-05  +5.99750000E-04
   +8.85390000E-04  -5.96960000E-04  -5.11750000E-04  -8.72180000E-04  +5.04040000E-04
   -8.58900000E-05  -7.70900000E-05  -9.36100000E-05  -5.11100000E-05  +1.31700000E-05
   -2.49710000E-04  +1.86160000E-04  +9.85600000E-05  +1.19410000E-04  +1.45300000E-05
   +9.42304000E-03  +2.07720000E-02  +3.08128000E-03  -1.00829340E-01  -1.09417500E-01
   +1.25250000E-04  +4.61400000E-05  +3.01300000E-05  -3.40920000E-04  +1.74183000E-03
   +4.36700000E-05  -1.75480000E-04  -6.25900000E-05  -1.31380000E-04  -9.17200000E-05
   +6.47000000E-06  +5.18200000E-05  +1.12140000E-04  -2.16400000E-05  -9.54000000E-06
   +4.86200000E-05  +1.04020000E-04  -1.72000000E-05  +6.15800000E-05  -1.36520000E-04
   -6.91000000E-05  -1.29860000E-04  +1.08120000E-04  +6.66000000E-06  -4.23200000E-04
   -3.00680000E-03  +3.09480000E-03  -3.53890000E-04  +5.55700000E-05  -6.70000000E-07
   -1.54500000E-05  -3.14000000E-06  -1.49000000E-05  +8.26000000E-06  -2.67000000E-05
   +2.26200000E-05  -1.38349000E-03  -1.74809000E-03  +2.01410000E-04  +6.23300000E-05
   -7.25000000E-06  -2.07100000E-05  +2.18100000E-05  -2.06300000E-05  +1.14900000E-05
   -1.26809000E-03  -8.31821000E-03  -1.62936900E-02  +2.59238000E-03  -7.95314000E-03
   -1.56037000E-02  -1.90257000E-03  +1.09745180E-01  +5.31960000E-04  +7.99000000E-05
   -1.99290000E-04  -1.30731000E-03  -5.52950000E-04  +2.55680000E-04  -1.39830000E-04
   -1.09742000E-03  -5.73120000E-04  +3.61940000E-04  +1.55170000E-04  +4.58410000E-04
   -1.90220000E-04  +9.61300000E-05  +3.10460000E-04  -3.28190000E-04  -2.03370000E-04
   -9.01000000E-06  +2.81700000E-05  -1.10678600E-02  -2.00085200E-02  +6.51813000E-03
   -1.06741340E-01  -2.63829820E-01  -2.43600000E-05  +4.30600000E-05  +3.91700000E-05
   +9.24460000E-04  -1.24233000E-03  +9.36830000E-04  -1.92390000E-04  +5.61080000E-04
   +1.41750000E-04  +2.48950000E-04  -3.08600000E-05  -1.10430000E-04  -2.07950000E-04
   -1.57980000E-04  +1.69500000E-05  -1.64030000E-04  +2.35550000E-04  -8.57000000E-06
   -2.07660000E-04  -2.37910000E-04  +2.48870000E-04  +5.02000000E-05  -1.45000000E-06
   +1.92300000E-05  +3.39010000E-04  +4.80707000E-03  -3.09370000E-03  -2.47870000E-04
   -1.72700000E-05  +7.90200000E-05  +3.35300000E-05  +8.43000000E-06  -8.41000000E-06
   +4.82800000E-05  -1.73300000E-05  -4.93000000E-06  -2.95890000E-04  +2.72860000E-04
   +9.47580000E-04  -1.49810000E-04  -1.92400000E-05  +1.06310000E-04  +2.28000000E-06
   +2.26600000E-05  -9.16000000E-06  -2.77820000E-04  +1.72260000E-04  -6.08800000E-05
   +4.52530000E-04  -7.27190000E-04  -2.08280000E-03  -5.98422000E-03  +1.16128270E-01
   +2.87564690E-01  -6.25960000E-04  -2.64990000E-04  -9.59760000E-04  +1.94620000E-04
   +3.75470000E-04  -3.02200000E-05  -5.17300000E-05  -6.76900000E-05  +4.99500000E-05
   +1.02350000E-04  +6.99900000E-05  +4.49500000E-05  -6.04200000E-05  -5.56500000E-05
   +1.83400000E-05  -4.19400000E-05  +2.34400000E-05  +2.57070000E-04  -1.58094000E-03
   +2.54870000E-03  -1.95288000E-03  +2.34000000E-06  -4.84520000E-04  -3.41360000E-04
   +1.21870000E-04  +8.24700000E-05  +5.86700000E-05  +1.77200000E-05  -2.86830000E-04
   +6.20050000E-04  +1.39460000E-04  +1.72830000E-04  -8.31000000E-05  +2.59300000E-05
   -8.71000000E-06  -4.56900000E-05  -1.31600000E-04  -2.04600000E-05  +3.74100000E-05
   -5.95500000E-05  +1.89940000E-04  -7.48400000E-05  -1.10190000E-04  -5.82650000E-04
   -4.69800000E-05  +5.56800000E-05  -2.89900000E-05  -1.84000000E-05  -4.76847900E-02
   -7.69970000E-04  +1.03423000E-03  -4.63530000E-04  +3.16000000E-06  +2.57170000E-04
   -1.13700000E-05  -7.11000000E-06  -6.18000000E-06  +9.31000000E-06  +1.22700000E-05
   +1.25500000E-05  -4.87000000E-06  +4.47100000E-05  +6.33400000E-05  -2.39648000E-03
   -3.35690000E-04  -4.03550000E-04  -2.05100000E-05  +1.67700000E-05  -2.40600000E-05
   +1.84580000E-04  -2.76670000E-04  +2.85670000E-04  +1.72720000E-04  +2.80350000E-04
   -1.48370000E-04  +6.28370000E-04  +7.85000000E-05  -1.16790000E-04  +4.93142800E-02
   -1.01618000E-03  +1.91640000E-04  +6.88430000E-04  +1.84000000E-06  +4.41580000E-04
   +4.85290000E-04  +2.14530000E-04  -5.03400000E-05  -5.24000000E-05  +1.11250000E-04
   +2.72600000E-05  -4.27500000E-05  -1.30420000E-04  -5.53200000E-05  +1.96290000E-04
   -1.77700000E-05  -1.49960000E-04  -4.16500000E-04  +1.03312000E-03  +1.03047000E-02
   -1.29526100E-02  -3.59580000E-04  -1.07344000E-03  -2.48975000E-03  +5.35400000E-05
   +8.01000000E-06  -5.74300000E-05  -1.39080000E-04  +1.31453000E-03  -5.63200000E-04
   -1.64770000E-04  +2.07920000E-04  +1.43420000E-04  +4.71600000E-05  -3.86100000E-05
   +1.72200000E-05  +3.05900000E-05  -1.48000000E-04  -1.63000000E-06  -1.44700000E-05
   +1.87560000E-04  -3.37400000E-05  -5.70900000E-05  -2.09490000E-04  +6.35000000E-05
   -1.39880000E-04  +1.34490000E-04  -4.43000000E-06  -1.50880000E-04  -1.57780270E-01
   +1.32438050E-01  -2.99360000E-04  +3.41000000E-05  +1.63940000E-04  -1.44700000E-05
   -1.14700000E-05  -6.84000000E-06  +1.29800000E-05  +1.63400000E-05  -6.48000000E-06
   +3.47000000E-06  +2.20200000E-05  -3.49200000E-05  -7.43860000E-04  -1.74020000E-04
   -6.37020000E-04  +1.04000000E-06  +3.89000000E-05  +2.36000000E-06  -2.21440000E-04
   +5.12500000E-05  -2.16080000E-04  +2.21090000E-04  -8.71000000E-06  -1.82940000E-04
   -7.19300000E-05  +8.34620000E-04  -6.68620000E-04  +2.29569000E-03  +1.68344420E-01
   +4.55750000E-04  -3.27020000E-04  -3.28570000E-04  +8.90770000E-04  +6.42990000E-04
   +7.10610000E-04  -1.07300000E-04  -3.93910000E-04  -1.30290000E-04  +1.81950000E-04
   +1.22930000E-04  +6.20300000E-05  -1.40200000E-05  +1.12660000E-04  +1.23270000E-04
   -2.61340000E-04  -7.03900000E-05  +3.71230000E-04  +1.21427000E-03  +1.87571200E-02
   -2.05580300E-02  -3.11420000E-04  -4.46443000E-03  -4.92449000E-03  -2.59000000E-06
   +7.58000000E-06  +4.97200000E-05  -1.20817000E-03  +1.06217000E-03  +7.62900000E-04
   +9.10400000E-05  -8.75100000E-05  +2.41510000E-04  +2.39990000E-04  -2.74790000E-04
   -1.79800000E-05  -1.01240000E-04  -3.15320000E-04  -1.12700000E-05  -1.59140000E-04
   +2.79340000E-04  -7.10600000E-05  +7.31360000E-04  +8.75000000E-05  +1.10340000E-04
   -9.57400000E-05  +9.61100000E-05  +2.85700000E-05  +1.05667000E-03  +1.30334540E-01
   -2.05155780E-01  +1.30880000E-04  -1.36900000E-05  +6.18400000E-05  +1.96000000E-06
   +1.04300000E-05  -3.80000000E-06  -2.16600000E-05  +2.19600000E-05  -1.31100000E-05
   +1.33500000E-05  +1.34970000E-04  +9.45200000E-05  -5.25450000E-04  +2.26960000E-04
   +6.74760000E-04  -2.57500000E-05  -2.65400000E-05  -1.25500000E-05  -1.11660000E-04
   -5.15100000E-05  +2.35220000E-04  -9.74800000E-05  -2.36380000E-04  +3.06990000E-04
   -5.66700000E-05  +1.29927000E-03  -1.53205000E-03  -1.59202000E-03  -1.42414830E-01
   +2.24796050E-01  -1.52600000E-05  -6.57400000E-05  +3.99120000E-04  +7.68090000E-04
   -1.63660000E-04  -3.53410000E-04  +1.03680000E-04  -7.11400000E-05  +3.83280000E-04
   -1.86950000E-04  -6.66800000E-05  -8.06600000E-05  +1.75820000E-04  +7.36200000E-05
   -8.44800000E-05  +1.75630000E-04  -9.26700000E-05  -1.70750000E-04  -3.47024000E-03
   -7.35490000E-04  +3.54680000E-04  +1.98200000E-05  +8.16900000E-05  +5.80810000E-04
   -2.31170000E-04  -1.28600000E-04  -5.88900000E-05  +6.86940000E-04  +9.21100000E-04
   +2.84100000E-05  +4.99400000E-05  -3.61950000E-04  +1.25980000E-04  -1.78730000E-04
   +1.23200000E-04  +4.03400000E-05  +1.32240000E-04  +2.14730000E-04  -6.45800000E-05
   +1.66180000E-04  -2.50480000E-04  +1.11500000E-04  -2.42070000E-04  +5.55830000E-04
   +3.65150000E-04  +4.45500000E-05  -6.70300000E-05  -1.48000000E-06  -2.53257880E-01
   -1.16752140E-01  -8.46870000E-04  -7.57870000E-04  +3.98400000E-05  +4.62840000E-04
   +2.25500000E-05  +2.22200000E-05  +1.44800000E-05  -4.93000000E-05  +1.09100000E-05
   -2.33500000E-05  +5.16400000E-05  -3.23000000E-05  -7.47300000E-05  -5.98900000E-05
   +7.16400000E-05  -5.27190000E-04  -6.24000000E-06  -1.47200000E-05  +1.66900000E-05
   -3.51000000E-05  -1.13420000E-04  +7.71000000E-06  +3.83380000E-04  +2.80010000E-04
   -3.89910000E-04  +2.71880000E-04  +2.05310000E-04  +8.82900000E-05  +1.31524000E-03
   +1.51331000E-03  +6.71000000E-05  +2.73826390E-01  +2.31810000E-04  +3.62320000E-04
   -3.16670000E-04  +7.28590000E-04  -6.17820000E-04  -2.74925000E-03  -1.01578000E-03
   -1.47080000E-04  +1.78480000E-04  +1.30900000E-05  -1.24120000E-04  -2.47920000E-04
   +1.70250000E-04  +5.81200000E-05  +6.53600000E-05  -1.34000000E-04  +2.44200000E-05
   -7.58000000E-05  -1.39026200E-02  -9.45902000E-03  -3.90330000E-04  +5.03560000E-04
   +3.71100000E-04  +1.29251000E-03  -1.96230000E-04  -1.14240000E-04  -2.30700000E-05
   -9.44560000E-04  +4.58740000E-04  +3.06480000E-04  +2.20690000E-04  -6.32980000E-04
   +1.71240000E-04  -4.76840000E-04  +2.04720000E-04  -2.02700000E-05  +4.08310000E-04
   +2.72200000E-04  -9.14600000E-05  +3.88050000E-04  -4.18810000E-04  +5.87100000E-05
   -3.53000000E-06  +9.86500000E-05  +4.91400000E-05  -1.26330000E-04  +8.78700000E-05
   +1.47800000E-05  -1.15597570E-01  -1.13057950E-01  +2.89910000E-04  -2.44500000E-04
   -2.33640000E-04  +2.77860000E-04  +2.57000000E-05  +1.62500000E-05  +1.40500000E-05
   -7.06500000E-05  -8.59800000E-05  -9.54000000E-06  +2.62300000E-05  +2.98500000E-05
   -5.53800000E-05  +3.51600000E-04  -1.77020000E-04  +1.07980000E-04  -4.01100000E-05
   +9.91000000E-06  -4.00000000E-06  +1.22080000E-04  +4.04100000E-05  -2.11500000E-05
   +9.63500000E-05  +5.62830000E-04  +1.25540000E-04  +2.21550000E-04  -8.79900000E-05
   +9.18100000E-05  -1.74285300E-02  -9.93022000E-03  -8.42930000E-04  +1.26910890E-01
   +1.20454580E-01  +8.45070000E-04  +1.15300000E-05  -9.73300000E-04  +1.02956000E-03
   -2.32053000E-03  -5.27061000E-03  -1.63105000E-03  -8.66580000E-04  +3.94600000E-04
   -8.62400000E-05  -7.96200000E-05  -3.94050000E-04  +2.25400000E-04  +9.20400000E-05
   -5.56600000E-05  -1.53780000E-04  +8.30000000E-06  +3.72910000E-04  -2.56814700E-02
   -1.45945800E-02  -2.34456000E-03  -1.32049000E-03  -9.27070000E-04  +1.31128000E-03
   -1.80380000E-04  -7.75500000E-05  +4.57600000E-05  -6.97360000E-04  +1.06173000E-03
   +5.39650000E-04  +2.83610000E-04  -3.74920000E-04  +9.85600000E-05  -3.71610000E-04
   +1.41580000E-04  +4.22000000E-06  +2.61980000E-04  +1.76870000E-04  -5.00300000E-05
   +2.95360000E-04  -9.44000000E-06  -6.33400000E-05  -2.38950000E-04  -9.29700000E-04
   +5.21600000E-05  -1.22600000E-04  +1.20510000E-04  -6.83000000E-06  +2.50130000E-03
   +2.26332000E-03  -4.57607000E-02  -4.80250000E-04  -5.76100000E-05  +1.94500000E-05
   +3.01800000E-05  +2.48000000E-05  +1.16000000E-05  -1.58320000E-04  -5.20000000E-05
   -3.90700000E-05  +4.91500000E-05  -2.54900000E-05  +1.85600000E-05  -1.06000000E-05
   +3.79260000E-04  +5.56790000E-04  -3.66700000E-05  -2.65900000E-05  -3.04000000E-06
   +6.62500000E-05  +6.44300000E-05  -5.68400000E-05  +2.68040000E-04  +4.09070000E-04
   -9.08450000E-04  +2.52590000E-04  +6.97600000E-05  +2.99870000E-04  +2.24019800E-02
   +1.11771000E-02  +5.01590000E-04  -8.59180000E-04  +2.32571000E-03  +5.30694000E-02
   -4.09930000E-04  -8.80650000E-04  +2.65400000E-04  +2.65720000E-04  -3.39990000E-04
   +4.46400000E-05  +1.88660000E-04  +1.14120000E-04  +4.10100000E-05  +3.46000000E-05
   +3.34000000E-06  +5.27000000E-06  -1.35820000E-04  -1.55000000E-06  -4.07000000E-06
   +7.00000000E-05  -2.99900000E-05  -1.04830000E-04  +2.08061000E-03  -3.06702000E-03
   -1.34296000E-03  +1.05160000E-04  -2.27740000E-04  -3.30000000E-07  +1.04450000E-04
   +5.10100000E-05  -9.50000000E-07  +4.19740000E-04  +4.62220000E-04  -4.98900000E-05
   +1.69490000E-04  -7.23160000E-04  +3.24170000E-04  -3.97490000E-04  +1.94040000E-04
   +8.23500000E-05  +4.09030000E-04  +1.41380000E-04  -6.51700000E-05  +1.96830000E-04
   -2.65660000E-04  +8.39000000E-05  +1.49390000E-04  +2.42450000E-04  +1.14630000E-04
   -1.73980000E-04  +1.16750000E-04  -3.05000000E-06  -1.92822450E-01  +1.31346410E-01
   +2.19803600E-02  -2.61460000E-04  -1.18760000E-04  +2.68950000E-04  -1.68700000E-05
   -2.98000000E-06  -8.61000000E-06  +1.33800000E-05  +3.02400000E-05  +2.47000000E-06
   +3.29000000E-06  -5.01000000E-06  +7.92000000E-06  -6.82180000E-04  -1.15053000E-03
   -1.76480000E-04  +3.31400000E-05  -2.61200000E-05  +1.52700000E-05  +1.95380000E-04
   -8.45200000E-05  +3.04380000E-04  -1.76290000E-04  +1.18860000E-04  +4.48200000E-05
   +1.10400000E-04  -2.44440000E-04  +5.65000000E-05  +5.71840000E-04  -2.14896000E-03
   -1.96580000E-04  -1.89138500E-02  +1.93436300E-02  +2.53900000E-03  +2.08511330E-01
   -1.27700000E-05  -1.11580000E-04  -1.00440000E-03  +8.35530000E-04  +4.51430000E-04
   +4.25150000E-04  -3.27390000E-04  -6.74100000E-05  -2.30020000E-04  +2.48800000E-04
   +1.48000000E-04  +4.51000000E-05  -7.93000000E-05  -6.19900000E-05  +1.35290000E-04
   -3.12890000E-04  +1.35710000E-04  +3.75680000E-04  +1.16274000E-02  -1.12464900E-02
   -1.22682000E-03  -1.67700000E-04  +3.98540000E-04  +1.07767000E-03  +1.58120000E-04
   +1.12250000E-04  +8.07500000E-05  -6.87570000E-04  -6.14420000E-04  -3.35233000E-03
   +4.55410000E-04  +9.55100000E-05  -2.67420000E-04  +7.54600000E-05  +9.83100000E-05
   +1.98620000E-04  -2.64270000E-04  +4.55680000E-04  -4.19000000E-06  +2.86220000E-04
   -3.98890000E-04  +2.25620000E-04  -8.06370000E-04  -5.63600000E-04  +5.50600000E-05
   +4.73940000E-04  -4.31350000E-04  -5.20000000E-05  +1.30030090E-01  -1.63826550E-01
   -1.87421800E-02  -2.56590000E-04  -1.14740000E-04  +1.56380000E-04  -1.00800000E-05
   -1.98800000E-05  -6.24000000E-06  +1.98000000E-05  -1.47600000E-05  +2.30800000E-05
   +1.56400000E-05  +7.60000000E-06  +1.23090000E-04  -7.10710000E-04  -1.14923000E-03
   +8.26190000E-04  -2.06300000E-05  -2.04200000E-05  -2.19800000E-05  -7.61300000E-05
   +5.42210000E-04  -1.87530000E-04  -1.05120000E-04  +1.60800000E-05  -1.01640000E-04
   -2.41800000E-04  +3.18800000E-05  +1.91400000E-05  +1.44392000E-02  -1.24737200E-02
   -3.51383000E-03  -1.21552100E-02  +1.19308100E-02  +2.00876000E-03  -1.42823590E-01
   +1.76425150E-01  -1.80930000E-04  +8.33700000E-05  +5.46230000E-04  +5.40650000E-04
   +6.84110000E-04  +8.80230000E-04  -1.33960000E-04  +1.29900000E-04  -3.29370000E-04
   +2.34990000E-04  +9.12200000E-05  -4.05700000E-05  -1.55680000E-04  +1.41200000E-05
   +2.42010000E-04  -1.93110000E-04  -1.06850000E-04  -1.56900000E-04  +2.16734700E-02
   -1.83102600E-02  -3.87806000E-03  +8.06320000E-04  -6.42310000E-04  +1.35646000E-03
   +9.40600000E-05  +4.77000000E-05  -2.37300000E-05  -1.42304000E-03  -2.27086000E-03
   -4.15965000E-03  +5.95860000E-04  -5.30000000E-05  -1.34210000E-04  +5.59590000E-04
   -1.44630000E-04  +3.46500000E-04  -5.40730000E-04  -5.44300000E-05  +2.54800000E-05
   +1.61500000E-05  +9.93800000E-05  +1.31950000E-04  +1.48300000E-05  -7.81400000E-04
   +1.32370000E-04  +4.75630000E-04  -3.59120000E-04  -4.66900000E-05  +2.12772900E-02
   -1.79062200E-02  -5.16220300E-02  -1.56940000E-04  -2.97500000E-05  +1.68400000E-05
   -1.19100000E-05  -2.00400000E-05  -6.86000000E-06  +3.13800000E-05  -2.45000000E-05
   +1.22000000E-05  +2.52900000E-05  -4.17700000E-05  +3.08500000E-05  -2.51500000E-05
   +1.18870000E-04  -5.00000000E-08  +1.19900000E-05  -1.49600000E-05  +5.55000000E-06
   -4.54190000E-04  +3.31920000E-04  -6.04470000E-04  +8.19600000E-05  +1.31640000E-04
   -4.85700000E-05  -2.84960000E-04  +1.54040000E-04  +3.49340000E-04  -1.93729500E-02
   +1.54106100E-02  +3.73594000E-03  +9.51100000E-05  +1.42100000E-05  -9.63940000E-04
   -2.38120500E-02  +2.32080700E-02  +5.44980600E-02  +1.02770000E-04  +1.27520000E-04
   -1.62840000E-04  -1.65200000E-04  +2.87100000E-04  -1.14000000E-04  +2.11700000E-05
   +1.43680000E-04  +6.63000000E-06  +4.30000000E-07  +7.87700000E-05  +4.11000000E-05
   +1.26460000E-04  +3.16600000E-05  +4.32300000E-05  -2.10500000E-05  -4.60200000E-05
   -1.86300000E-05  +1.64831000E-03  -1.34043000E-03  -1.92060000E-04  -1.06047000E-03
   -3.88450000E-04  +1.16530000E-04  -1.16740000E-04  -2.89300000E-05  -1.66200000E-05
   -1.06386000E-03  -2.36647300E-02  +3.29700000E-03  -5.62413000E-03  -2.23050000E-04
   +9.72960000E-04  -6.06070000E-04  +8.74200000E-05  +2.12600000E-05  -2.67100000E-04
   +4.28727000E-03  +2.30990000E-04  +1.24294000E-03  +6.40512000E-03  -5.22760000E-04
   -2.43985900E-02  +3.82062600E-02  -2.77472000E-03  +5.22370000E-04  -7.79920000E-04
   +6.47000000E-06  -8.81080000E-04  +3.95200000E-05  -1.83380000E-04  +2.78003000E-03
   +3.27378000E-02  -4.20531000E-03  +2.98500000E-05  -9.04000000E-06  +1.47500000E-05
   +1.54400000E-05  -1.82500000E-05  +6.67000000E-06  +4.15300000E-05  -9.02800000E-05
   +4.92500000E-05  -1.92000000E-05  -1.84900000E-05  +4.41200000E-05  +7.16000000E-06
   -1.96400000E-05  +7.52000000E-06  +4.53320000E-04  +3.89980000E-04  +6.87200000E-05
   -1.63532000E-03  +1.51044000E-03  -9.65840000E-04  +2.35080000E-04  +1.04540000E-04
   +1.45200000E-04  +2.20160000E-04  +8.48500000E-05  -1.98760000E-04  -3.12450000E-04
   +1.84480000E-04  +8.31590000E-04  +6.88700000E-05  +2.39780000E-04  +1.69430000E-04
   +3.07104100E-02  +1.01670000E-04  +8.87200000E-05  -3.85080000E-04  -6.36600000E-05
   +4.39720000E-04  +2.05950000E-04  -5.20300000E-05  +1.48290000E-04  +2.66100000E-05
   -8.46500000E-05  +1.03720000E-04  +1.72370000E-04  +5.89700000E-04  +2.85350000E-04
   +1.56990000E-04  -1.84990000E-04  -1.59230000E-04  -1.42000000E-04  +4.04554000E-03
   -8.43830000E-04  -6.02930000E-04  -4.66900000E-05  +1.06157000E-03  +5.95120000E-04
   -6.91710000E-04  -3.24300000E-04  -9.47000000E-05  +3.73680000E-04  -2.09648200E-02
   +2.34290000E-03  -8.02524000E-03  +4.41254000E-03  +3.37150000E-04  +1.90664000E-03
   +5.72600000E-05  -2.12570000E-04  +3.71022000E-03  +3.14231000E-03  -1.06926000E-03
   -5.84191000E-03  -3.21511100E-02  +4.42274000E-03  +1.43249700E-02  +1.17330100E-02
   +7.33740000E-04  +9.91150000E-04  -3.64388000E-03  +2.65080000E-04  -9.03620000E-04
   +1.37370000E-04  -4.11240000E-04  +3.39351600E-02  +7.11925100E-02  +3.12238000E-03
   +1.15560000E-04  +3.22100000E-05  +5.73900000E-05  -1.60600000E-05  -5.92100000E-05
   -2.52000000E-05  +7.96300000E-05  -5.62700000E-05  +1.54050000E-04  +2.08300000E-05
   -1.77800000E-05  +4.89300000E-05  -3.46500000E-05  -4.43300000E-05  +2.42100000E-05
   -3.56320000E-04  +1.44490000E-04  -1.48090000E-04  +1.94250000E-04  -1.12089000E-03
   -1.48130000E-04  +1.12660000E-04  -8.50000000E-06  +8.04300000E-05  +1.05170000E-04
   +1.80400000E-05  -7.21200000E-05  +3.09500000E-05  -2.64300000E-04  -2.88900000E-05
   -9.50400000E-05  +3.66310000E-04  +3.40470000E-04  -4.79934500E-02  -3.02444400E-02
   -1.74400000E-05  +2.75700000E-05  +6.82000000E-06  -4.09500000E-05  +6.27500000E-05
   -1.80610000E-04  -8.59200000E-05  -4.50000000E-07  +7.70700000E-05  -1.20000000E-05
   -9.68000000E-06  -3.72300000E-05  +4.49700000E-05  +2.50100000E-05  +1.57200000E-05
   +7.87000000E-06  -2.60800000E-05  -3.26200000E-05  +2.05200000E-04  -1.52400000E-04
   -1.19719000E-03  -1.15510000E-04  -3.86300000E-05  -1.65800000E-05  -5.46700000E-05
   -3.05500000E-05  -1.78300000E-05  +6.58260000E-04  +5.60020000E-04  +4.90955000E-03
   -4.97650000E-04  +1.03521000E-03  +2.56931000E-03  +2.65340000E-04  +1.29500000E-05
   -5.49880000E-04  +1.11870000E-03  +5.22670000E-04  +3.73892000E-03  +4.57020000E-04
   -2.53182000E-03  +5.45731000E-03  +5.75962000E-03  +2.73024800E-02  -3.46331100E-02
   +5.14300000E-05  -4.04120000E-04  -8.27200000E-05  +2.67650000E-04  +3.46600000E-04
   -4.04500000E-05  -1.58575000E-03  +8.18775000E-03  -1.58244800E-02  +5.27000000E-06
   +2.44000000E-06  +6.65000000E-06  -1.13600000E-05  -9.79000000E-06  -3.68000000E-06
   +5.67000000E-06  -1.98200000E-05  -1.64800000E-05  +2.41800000E-05  +2.75000000E-06
   -3.14600000E-05  +5.80000000E-07  -5.07000000E-06  +2.78000000E-06  +1.95140000E-04
   +5.40700000E-05  -4.16800000E-05  -7.14680000E-04  +6.03330000E-04  +4.61950000E-04
   -1.73330000E-04  -8.62400000E-05  -1.48940000E-04  -6.69000000E-06  -3.81300000E-05
   -3.71000000E-06  +3.97610000E-04  -4.63850000E-04  -5.71610000E-04  -2.78280000E-04
   -1.44620000E-04  +6.96000000E-06  +1.93576000E-03  -1.97998600E-02  +4.12811500E-02
   -4.31100000E-05  -3.06000000E-05  -4.62400000E-05  -9.21300000E-05  +2.74250000E-04
   +5.00800000E-05  +8.26000000E-06  -2.50000000E-06  +3.14600000E-05  -3.33100000E-05
   -2.22500000E-05  +2.02100000E-05  +5.87200000E-05  +2.87400000E-05  -4.00000000E-06
   -8.15000000E-06  -2.72700000E-05  +1.69000000E-06  -3.45340000E-04  -8.09270000E-04
   +1.23170000E-04  -2.01900000E-05  -4.01200000E-05  +4.36300000E-05  -7.21100000E-05
   -3.74400000E-05  -1.10900000E-05  -1.14292000E-03  +3.58843000E-03  +6.77280000E-04
   +6.44010000E-04  +4.78910000E-04  -3.06800000E-04  +1.20978000E-03  -5.87930000E-04
   +6.01840000E-04  -1.87534000E-03  +1.24852000E-03  +1.10141000E-03  -3.00001090E-01
   -9.48566400E-02  +4.66261900E-02  -1.78456900E-02  -8.29692000E-03  +3.50072000E-03
   +6.56450000E-04  +4.46500000E-05  -5.71140000E-04  -6.55500000E-05  -1.00000000E-05
   -6.71400000E-05  +9.85860000E-04  +3.70950000E-04  -1.23860000E-04  +6.61000000E-06
   +5.35000000E-06  +6.20000000E-06  -7.38000000E-06  -6.42000000E-06  -3.92000000E-06
   +2.34000000E-06  +9.89000000E-06  -1.85000000E-06  -5.00000000E-08  +1.09800000E-05
   -7.00000000E-08  -8.20000000E-06  -5.33000000E-06  +1.33000000E-06  -3.22000000E-06
   +3.58700000E-05  -2.77500000E-05  -1.39000000E-05  +6.64000000E-06  -6.23000000E-06
   -8.00000000E-08  +1.45000000E-06  -1.21300000E-05  +6.80000000E-06  +3.00000000E-06
   +2.98000000E-06  +9.05000000E-06  +9.00000000E-07  +1.37800000E-05  -7.73000000E-06
   +3.56700000E-05  +3.97500000E-05  -7.46860000E-04  -1.34425000E-03  -3.25950000E-04
   +3.18902340E-01  +2.26000000E-05  +1.64600000E-05  +3.60900000E-05  +1.20400000E-04
   -2.27080000E-04  -7.76400000E-05  +1.14100000E-05  +3.62000000E-06  -8.44000000E-06
   +8.30000000E-07  +9.05000000E-06  -6.96000000E-06  -1.91400000E-05  -1.81200000E-05
   -1.77100000E-05  +1.75200000E-05  +3.54100000E-05  -2.10000000E-07  +5.51530000E-04
   +6.74950000E-04  -2.80000000E-07  -8.22000000E-06  +9.44500000E-05  -3.49300000E-05
   +3.64600000E-05  +2.12800000E-05  +6.85000000E-06  +3.93858000E-03  -2.05218000E-03
   +1.94840000E-04  +8.00680000E-04  -1.52912000E-03  -4.85500000E-05  -2.27000000E-04
   -5.60772000E-03  +1.11687000E-03  -3.00577700E-02  -4.28122000E-03  +5.26650000E-03
   -9.23779700E-02  -9.37181500E-02  +1.88467500E-02  +1.82932300E-02  +1.09813600E-02
   -3.57755000E-03  +3.49060000E-04  +2.41121000E-03  -6.64610000E-04  +2.14100000E-05
   +5.46600000E-05  +6.02900000E-05  -6.05060000E-04  +6.64080000E-04  +1.65610000E-04
   -5.40000000E-07  -3.08000000E-06  -2.22000000E-06  +3.95000000E-06  +5.60000000E-07
   +3.66000000E-06  -9.20000000E-07  -2.04000000E-06  +3.16000000E-06  +4.35000000E-06
   -1.02500000E-05  -2.05000000E-06  +5.55000000E-06  +5.05000000E-06  -8.10000000E-07
   -1.70200000E-05  -2.70900000E-05  +1.15300000E-05  +2.62700000E-05  -3.47200000E-05
   +2.18500000E-05  -6.07000000E-06  -7.49000000E-06  +8.78000000E-06  -9.28000000E-06
   -6.95000000E-06  +6.20000000E-07  -3.10000000E-07  -2.63300000E-05  -4.13100000E-05
   -8.21000000E-06  -2.38100000E-05  -1.51000000E-05  +4.72730000E-04  +5.50630000E-04
   -3.30920000E-04  +9.96436400E-02  +9.22641200E-02  -5.94300000E-05  -3.51200000E-05
   +5.39500000E-05  +1.49920000E-04  -3.90000000E-07  -1.37380000E-04  +7.97700000E-05
   -1.36000000E-06  +1.64000000E-06  -7.93400000E-05  -4.42500000E-05  +2.33400000E-05
   +1.51900000E-05  -3.18800000E-05  -9.14400000E-05  +6.57200000E-05  +4.64200000E-05
   +3.55200000E-05  -3.87700000E-05  +4.58200000E-05  +5.80710000E-04  +1.75000000E-05
   +4.73000000E-05  -4.21800000E-05  +9.01000000E-06  +1.28300000E-05  +5.34000000E-06
   +9.93810000E-04  +8.99990000E-04  +5.68515000E-03  -6.68400000E-05  -6.16730000E-04
   -1.10519000E-03  +1.12930000E-04  +1.06371000E-03  +5.01403000E-03  +4.26605000E-03
   +1.44892000E-03  +5.59791000E-03  +4.74160500E-02  +1.87969100E-02  -4.26245100E-02
   -2.23890000E-04  +3.49300000E-05  +1.27183000E-03  -7.04260000E-04  -5.88170000E-04
   -3.29431000E-03  -2.65300000E-05  +5.33000000E-06  -2.92400000E-05  -3.11890000E-04
   +3.21870000E-04  -7.05760000E-04  -5.30000000E-07  -1.40000000E-06  +1.34000000E-06
   -2.59000000E-06  -3.52000000E-06  +2.69000000E-06  -1.74100000E-05  +1.96400000E-05
   -3.83000000E-06  +4.30000000E-07  -3.94000000E-06  -3.92000000E-06  -1.50000000E-07
   +9.23000000E-06  -1.50000000E-06  -2.67000000E-06  -1.16800000E-05  +2.56000000E-06
   +3.31000000E-06  +6.25000000E-06  +8.61000000E-06  -1.65800000E-05  +2.50000000E-06
   -1.85800000E-05  +1.54200000E-05  +2.09300000E-05  -1.48300000E-05  -1.65000000E-06
   -1.75500000E-05  +1.73100000E-05  +5.20000000E-06  +2.11200000E-05  -6.04000000E-06
   -3.50670000E-04  +5.32800000E-05  -2.12566000E-03  -5.13929500E-02  -2.07375700E-02
   +3.29297800E-02  -1.16000000E-06  -9.58000000E-06  -6.14000000E-06  +1.48710000E-04
   +2.05300000E-05  +1.51000000E-06  +3.16000000E-06  -1.31400000E-05  +1.37200000E-05
   -9.56000000E-06  -4.22400000E-05  +2.56000000E-06  +2.13800000E-05  +2.51200000E-05
   +1.73600000E-05  -2.07900000E-05  -3.74900000E-05  -5.41000000E-06  +6.51360000E-04
   +7.51530000E-04  -1.97280000E-04  -2.17590000E-04  +1.06810000E-04  +9.50700000E-05
   -4.77600000E-05  -4.83700000E-05  -6.24000000E-06  -2.85461000E-03  +3.54075000E-03
   +1.04038000E-03  +8.42159000E-03  +2.46420100E-02  -3.63986000E-03  -6.88113900E-02
   -4.86705600E-02  +1.05798300E-02  -1.21800000E-05  -2.85621700E-02  +3.81813000E-03
   -5.03827000E-03  -1.91373000E-03  +1.69190000E-03  -1.95773000E-03  +6.07550000E-04
   +9.18500000E-05  +2.75991000E-03  -9.37530000E-04  -8.78850000E-04  -1.19780000E-04
   +4.92100000E-05  -5.34100000E-05  +9.09500000E-05  -3.56200000E-05  -5.13000000E-05
   -9.58000000E-06  +1.64300000E-05  -2.51000000E-06  -1.69100000E-05  +5.83000000E-06
   -1.49900000E-05  +1.03200000E-05  +1.96400000E-05  +2.65000000E-06  +7.94000000E-06
   +9.09000000E-06  -5.83000000E-06  -1.10500000E-05  +4.23000000E-06  -3.20000000E-07
   -1.12300000E-05  +7.53800000E-05  -6.77300000E-05  -1.55000000E-06  -7.53000000E-06
   +5.60000000E-06  +9.73000000E-06  -9.52000000E-06  -1.31000000E-05  +1.45300000E-05
   -5.98000000E-06  +2.36200000E-05  -9.21000000E-06  -1.24300000E-05  -5.42000000E-06
   -2.65800000E-05  +3.24300000E-05  +6.20400000E-05  -1.80700000E-05  +6.13000000E-06
   -1.41800000E-05  -2.35000000E-06  -1.40228000E-03  +7.49300000E-05  +6.76410900E-02
   -8.30000000E-06  +5.87000000E-06  +5.21900000E-05  -1.37080000E-04  -7.47900000E-05
   -1.64700000E-05  +3.10000000E-06  -7.95000000E-06  -2.74400000E-05  +2.14200000E-05
   +2.67300000E-05  -2.76100000E-05  -1.00380000E-04  -5.53000000E-05  -2.71100000E-05
   +3.17600000E-05  +4.68800000E-05  +2.46500000E-05  -7.19590000E-04  -4.31890000E-04
   +2.33850000E-04  +2.51190000E-04  -1.34210000E-04  -1.14130000E-04  +1.33780000E-04
   +8.67100000E-05  +1.74500000E-05  +3.67919000E-03  -2.82320000E-04  +1.97210000E-04
   -6.09008000E-03  -1.57181600E-02  +2.93447000E-03  -4.84799700E-02  -3.21148960E-01
   +3.93430700E-02  +4.16669000E-03  -9.78345000E-03  +9.28140000E-04  -2.23757000E-03
   +1.07911000E-03  +8.18930000E-04  +3.75390000E-04  +1.14548000E-03  -2.37130000E-04
   -2.21410000E-04  +3.32546000E-03  -7.79760000E-04  +1.31940000E-04  -7.69400000E-05
   +9.07600000E-05  +6.66800000E-05  +1.24840000E-04  -2.83000000E-05  -7.70000000E-06
   -2.08500000E-05  -6.09000000E-06  +2.13300000E-05  +1.06000000E-06  +1.66400000E-05
   -1.43900000E-05  -2.41300000E-05  -1.84300000E-05  -1.33200000E-05  -1.36500000E-05
   +6.67000000E-06  +1.62200000E-05  -4.80000000E-07  -1.93000000E-06  +2.38300000E-05
   -8.98400000E-05  +7.51900000E-05  -1.33100000E-05  +1.68600000E-05  -9.03000000E-06
   -1.14100000E-05  +1.80600000E-05  +7.18000000E-06  -5.71000000E-06  +1.97300000E-05
   -1.34300000E-05  -1.10600000E-05  +9.28000000E-06  +1.03400000E-05  +1.59800000E-05
   -5.39500000E-05  -6.50800000E-05  -1.90740000E-04  -4.25490000E-04  -4.83300000E-05
   +2.77000000E-05  -4.31780000E-04  +1.82700000E-05  +5.09381000E-02  +3.42251400E-01
   +5.62500000E-05  +1.95700000E-05  -2.49000000E-05  -4.27000000E-05  +6.20000000E-06
   -1.91300000E-05  -9.34000000E-05  +1.79600000E-05  +3.03800000E-05  +4.70800000E-05
   +1.35500000E-05  -2.78400000E-05  -5.81000000E-06  +2.28400000E-05  +7.63600000E-05
   -3.48400000E-05  -2.98400000E-05  -4.31500000E-05  +1.74120000E-04  +3.45000000E-05
   +1.39380000E-04  +1.05860000E-04  -1.00770000E-04  +6.44800000E-05  -1.49900000E-05
   -1.82000000E-05  -1.80200000E-05  +5.86020000E-04  +9.57500000E-05  +6.41648000E-03
   -4.72720000E-04  -1.16021000E-03  +2.87802000E-03  +1.09302300E-02  +3.92710200E-02
   -3.92711200E-02  -6.69000000E-05  +5.60911000E-03  +3.63161000E-03  +1.89466000E-03
   +7.59350000E-04  +4.86585000E-03  +2.60830000E-04  -4.88860000E-04  -6.21160000E-04
   -9.64320000E-04  -6.15860000E-04  -3.74847000E-03  -6.22500000E-05  +3.05300000E-05
   +4.40500000E-05  -1.36200000E-05  +1.52020000E-04  -2.45880000E-04  -5.65000000E-06
   +7.03000000E-06  +6.25000000E-06  -1.79800000E-05  +3.10000000E-07  -1.14100000E-05
   +1.39100000E-05  +1.51700000E-05  -2.42000000E-06  +8.32000000E-06  -1.18600000E-05
   -6.76000000E-06  +4.71000000E-06  -3.94000000E-06  -2.05000000E-06  +3.36900000E-05
   -2.64900000E-05  +1.54000000E-05  +7.00000000E-07  +3.02400000E-05  -1.61700000E-05
   -3.30000000E-07  +4.26000000E-06  -3.16800000E-05  +9.12000000E-06  -4.10000000E-06
   -8.73000000E-06  -2.47600000E-05  -9.67000000E-06  -1.43100000E-05  -3.77400000E-05
   +2.98000000E-06  +3.06200000E-05  -3.23000000E-06  +4.59200000E-05  -9.42100000E-05
   -3.46300000E-05  +2.78120000E-04  -1.25910000E-04  -1.20600200E-02  -4.31669900E-02
   +2.97682600E-02  +1.31770000E-04  +5.92450000E-04  -3.52710000E-04  -1.94859000E-03
   +3.97845000E-03  -4.37120000E-04  -1.86143000E-03  +1.57150000E-03  -1.14252000E-03
   +5.27800000E-04  +2.46040000E-04  -2.53670000E-04  -4.14210000E-04  -2.20020000E-04
   +4.05430000E-04  -1.96170000E-04  -3.04770000E-04  -5.31400000E-05  -1.25995000E-03
   +4.31610000E-04  -5.19480000E-04  -1.07180000E-04  -4.92300000E-05  -7.86500000E-05
   +2.36060000E-04  +1.31050000E-04  -1.68000000E-06  -8.15750000E-04  -1.34646000E-03
   +7.58660000E-04  -2.96122350E-01  -9.47035300E-02  +4.75922700E-02  -1.69052500E-02
   -9.84054000E-03  +4.15748000E-03  -7.40010000E-04  +3.52002000E-03  +6.64690000E-04
   +4.36000000E-04  +5.96540000E-04  -2.65730000E-04  +6.81830000E-04  -1.36635000E-03
   +6.95880000E-04  -1.32130000E-03  -1.95050000E-04  +1.39770000E-04  +6.67100000E-05
   -1.47060000E-04  +1.18740000E-04  -1.41080000E-04  -4.12450000E-04  +2.85900000E-05
   -3.03700000E-05  -2.91600000E-05  -2.00400000E-05  +3.86200000E-05  -4.31000000E-06
   +2.73600000E-05  +7.16500000E-05  -2.35920000E-04  +2.26360000E-04  +8.59000000E-05
   -1.24110000E-04  -2.54500000E-05  -1.00000000E-07  +8.38000000E-06  -2.23700000E-05
   +9.18900000E-05  +1.80800000E-05  -1.97600000E-05  +7.29000000E-06  -3.57700000E-05
   +3.67100000E-05  +1.24000000E-06  +2.09000000E-06  -1.42500000E-05  +1.96700000E-05
   -5.77000000E-05  -5.07400000E-05  -7.07000000E-06  +2.64000000E-06  -1.94700000E-05
   +2.77100000E-05  -3.05000000E-06  -6.08100000E-05  +1.98350000E-04  +7.60160000E-04
   +8.81800000E-05  -7.62600000E-05  -1.19900000E-05  -1.22000000E-05  +7.52890000E-04
   +1.41920000E-04  -6.33750000E-04  +3.18525770E-01  +6.99490000E-04  +1.52410000E-04
   -3.90060000E-04  +1.31908000E-03  -2.08508000E-03  +4.43500000E-05  +9.80190000E-04
   +1.16900000E-04  +9.65510000E-04  -1.56450000E-04  -1.34460000E-04  +1.19520000E-04
   +5.38690000E-04  +1.77120000E-04  +6.40200000E-05  -1.07700000E-05  -1.07740000E-04
   -1.33630000E-04  -1.13458000E-03  +9.34100000E-04  -4.10140000E-04  +2.49600000E-05
   +1.66300000E-04  +8.08300000E-05  -6.05800000E-04  -3.35650000E-04  -8.81400000E-05
   -2.78078300E-02  -7.12877000E-03  +5.45545000E-03  -9.44555200E-02  -9.57320500E-02
   +2.00095100E-02  +2.02821400E-02  +1.02956800E-02  -3.55660000E-03  +3.38538000E-03
   -2.03537000E-03  +4.83870000E-04  +8.57550000E-04  -1.07314000E-03  -1.36900000E-04
   -8.93490000E-04  -3.96157000E-03  +1.30715000E-03  +1.23437000E-03  +2.51090000E-04
   -1.84610000E-04  +1.69950000E-04  -1.54500000E-04  +3.11500000E-05  +3.15200000E-04
   +4.81920000E-04  -2.71000000E-06  +4.05200000E-05  +7.09100000E-05  +3.59600000E-05
   -6.18400000E-05  -8.99000000E-06  -5.74100000E-05  -3.68400000E-05  -1.22800000E-05
   -5.61500000E-05  -3.11200000E-05  -2.01400000E-05  +3.73600000E-05  -2.93200000E-05
   -2.90000000E-07  +1.68100000E-05  +5.57000000E-05  -1.35200000E-05  -2.07800000E-05
   -3.55200000E-05  +1.21020000E-04  -8.06900000E-05  -4.25300000E-05  -4.61000000E-06
   +2.00000000E-06  -3.76600000E-05  -2.31400000E-05  -8.77300000E-05  +2.10800000E-05
   +1.17180000E-04  +6.20900000E-05  -2.38000000E-06  -5.87400000E-05  -5.56000000E-05
   -1.56252000E-03  -1.87593000E-03  -1.78810000E-04  -3.51200000E-05  +3.83000000E-05
   -1.33200000E-05  -2.94830000E-04  +7.80730000E-04  -5.58990000E-04  +9.72418000E-02
   +1.00852770E-01  -4.30290000E-04  -3.00390000E-04  +1.32100000E-04  -4.99300000E-05
   +5.83580000E-04  -4.19100000E-05  -1.95290000E-04  +5.95990000E-04  -8.16200000E-05
   -4.44040000E-04  -4.61000000E-04  +1.92200000E-05  -7.95600000E-05  -1.19820000E-04
   -2.53830000E-04  +3.79210000E-04  +3.88660000E-04  +4.72400000E-05  -3.45490000E-04
   -4.78870000E-04  -3.91489000E-03  -5.12450000E-04  +4.19490000E-04  +1.30530000E-04
   +1.21820000E-04  +6.44100000E-05  -4.25000000E-06  +3.45600000E-03  +1.10667000E-03
   +5.00416000E-03  +4.66626500E-02  +1.98006100E-02  -4.78528500E-02  +1.28034000E-03
   +7.47790000E-04  +3.89884000E-03  +4.95250000E-04  +7.83100000E-05  +6.75225000E-03
   -4.54320000E-04  +8.92400000E-05  -1.24839000E-03  +8.40790000E-04  +1.51318000E-03
   +5.67974000E-03  +1.24590000E-04  -9.34000000E-06  +1.25400000E-05  +4.89760000E-04
   -6.51730000E-04  +1.10250000E-04  +1.60900000E-05  -1.70650000E-04  +1.65010000E-04
   -4.17100000E-05  -6.09000000E-06  -2.28000000E-06  -2.58100000E-05  +2.03600000E-05
   -1.41400000E-05  +8.24300000E-05  +1.60420000E-04  -1.60040000E-04  +4.06200000E-05
   -8.29300000E-05  -7.47500000E-05  +2.40400000E-05  -1.95400000E-05  -3.57000000E-06
   +7.66400000E-05  +1.66800000E-04  -1.15140000E-04  -4.51000000E-06  -1.87400000E-05
   -5.30000000E-07  +4.37000000E-06  +1.26100000E-05  +7.75000000E-06  +2.68200000E-05
   -2.32200000E-05  -7.82500000E-05  -1.84000000E-05  +1.36600000E-05  -3.40900000E-05
   -6.41800000E-05  -4.31600000E-05  -2.26150000E-04  +1.53960000E-04  +9.83800000E-05
   -1.65880000E-04  -4.86000000E-06  -8.44000000E-06  -1.70190000E-04  -6.98070000E-04
   -6.03150000E-04  -4.15696000E-03  -5.09351300E-02  -2.29727600E-02  +3.66375700E-02
   -1.00800000E-05  -1.73100000E-05  +4.05800000E-05  +1.32400000E-05  -2.96800000E-05
   -2.15000000E-06  +1.67200000E-05  -3.35700000E-05  +6.00000000E-07  +1.73200000E-05
   -2.82100000E-05  -2.65900000E-05  -1.18390000E-04  -5.30500000E-05  -1.59300000E-05
   +1.63000000E-05  +9.50000000E-06  +2.70600000E-05  -1.13120000E-04  -2.07400000E-05
   +5.92700000E-05  +4.08900000E-05  -2.66100000E-05  -1.83800000E-05  +1.24460000E-04
   +5.49600000E-05  +1.63300000E-05  -3.19620000E-04  -7.39950000E-04  +4.87300000E-05
   -6.65390000E-04  +2.03130000E-04  -6.63300000E-05  +1.62674000E-03  +3.03314000E-03
   -7.09030000E-04  +7.03724000E-03  +4.10313900E-02  -5.48576000E-03  -4.92648000E-03
   +3.54889000E-03  +6.61750000E-04  +1.25651000E-03  +6.90920000E-04  +1.11800000E-05
   -9.33063700E-02  -1.72822920E-01  +3.03547000E-02  +1.28000000E-06  -6.17000000E-06
   -3.10000000E-07  -4.77200000E-05  -2.92600000E-05  -2.70400000E-05  -2.79900000E-05
   -5.35000000E-06  -1.06200000E-05  -3.25000000E-06  +1.35100000E-05  +6.30000000E-07
   -9.80000000E-06  +1.88200000E-05  -2.21100000E-05  -8.38000000E-06  +6.51000000E-06
   -1.78000000E-06  +2.92000000E-06  +5.43000000E-06  -4.75000000E-06  +1.68900000E-05
   -2.15200000E-05  +8.32000000E-06  -7.65000000E-06  +1.07800000E-05  -7.60000000E-07
   -8.44000000E-06  +6.78000000E-06  -8.12000000E-06  -4.46000000E-06  +9.20000000E-06
   +6.60000000E-06  -1.43000000E-06  +9.76000000E-06  +8.87000000E-06  +2.22800000E-05
   -8.30000000E-06  -7.25000000E-06  -9.93100000E-05  +1.56860000E-04  +2.41900000E-05
   +1.91900000E-05  +1.05650000E-04  -1.16580000E-04  -1.30389000E-03  -1.81962000E-03
   +4.82560000E-04  +4.03800000E-05  -5.03500000E-05  +7.98000000E-06  +9.06996800E-02
   +1.68900000E-05  +7.77000000E-06  -4.98100000E-05  +5.68800000E-05  +9.61500000E-05
   +7.47000000E-06  -1.25600000E-05  +1.61400000E-05  -2.81000000E-06  -3.33900000E-05
   +4.66000000E-06  +4.48600000E-05  +1.75050000E-04  +9.30900000E-05  +3.69400000E-05
   -3.84400000E-05  -4.07000000E-05  -4.51400000E-05  +2.76280000E-04  -2.60300000E-05
   +9.48000000E-05  -1.35950000E-04  +1.84700000E-05  +4.59700000E-05  -2.01660000E-04
   -1.18790000E-04  -2.67600000E-05  -2.47900000E-05  +7.36650000E-04  -1.88760000E-04
   -8.33900000E-05  -1.24470000E-03  +6.04700000E-05  -3.67713000E-03  +5.85912000E-03
   -1.91100000E-04  -7.89900000E-03  -3.34553100E-02  +4.33064000E-03  +4.88776000E-03
   +2.42310000E-04  -3.90050000E-04  -1.03484000E-03  -1.14592000E-03  +3.63740000E-04
   -1.19968600E-01  -4.77151920E-01  +6.51645200E-02  -1.87380000E-04  +8.84600000E-05
   -4.98900000E-05  -1.95000000E-06  -6.22000000E-06  +1.49900000E-05  +2.70400000E-05
   +2.65700000E-05  +1.21600000E-05  -1.37200000E-05  -8.44000000E-06  -1.55600000E-05
   +2.27900000E-05  +1.82000000E-06  +3.90600000E-05  +2.01400000E-05  +2.93000000E-06
   -7.47000000E-06  -1.14300000E-05  -2.75000000E-06  +5.91000000E-06  -2.46100000E-05
   +6.86300000E-05  -2.55800000E-05  +8.54000000E-06  -1.64100000E-05  +7.95000000E-06
   +1.79500000E-05  -1.83200000E-05  +8.91000000E-06  +1.80000000E-05  -1.93800000E-05
   -2.01900000E-05  +2.05000000E-06  -2.59500000E-05  -1.51900000E-05  -3.26700000E-05
   +7.41700000E-05  +6.57000000E-05  +1.96260000E-04  +2.70000000E-06  -5.12400000E-05
   +8.36000000E-06  +4.14770000E-04  -1.07490000E-04  +1.12989000E-03  -1.89580000E-04
   -9.33700000E-05  -2.23940000E-04  +1.56890000E-04  +2.14900000E-05  +1.26773030E-01
   +5.05613470E-01  -1.02700000E-05  +6.74000000E-06  -4.00000000E-07  -4.20000000E-06
   +3.38000000E-06  -1.63900000E-05  -1.10200000E-05  -2.02000000E-06  +2.68400000E-05
   +2.83000000E-06  -5.82000000E-06  -5.78000000E-06  -2.70000000E-06  +5.20000000E-07
   +1.10600000E-05  +5.81000000E-06  +6.15000000E-06  -1.09800000E-05  +2.12000000E-06
   -5.28000000E-06  +1.01060000E-04  +4.67900000E-05  -4.53000000E-06  -8.20000000E-06
   +4.20000000E-07  -2.87000000E-06  -9.94000000E-06  +2.07300000E-05  +2.57900000E-05
   +9.29000000E-06  -7.21800000E-05  -1.48300000E-05  -9.72430000E-04  +3.59000000E-06
   -1.14648000E-03  -7.73510000E-04  -5.36620000E-04  -2.56701000E-03  -1.99843000E-03
   +4.91790000E-04  -2.92360000E-04  +2.26133000E-03  +2.59470000E-04  +1.86940000E-04
   +1.49440000E-03  +2.50176900E-02  +7.26503300E-02  -1.46320900E-02  -4.46000000E-06
   +4.89000000E-06  +1.89100000E-05  -1.76000000E-05  +4.17000000E-06  +7.05000000E-06
   -4.08000000E-06  +2.70000000E-06  +6.07000000E-06  -1.19200000E-05  +4.80000000E-07
   -4.64000000E-06  +6.80000000E-07  +1.19800000E-05  -4.32000000E-06  +4.08000000E-06
   -8.44000000E-06  -4.77000000E-06  +5.59000000E-06  -2.90000000E-06  -4.90000000E-07
   +6.50000000E-07  -1.53100000E-05  +8.65000000E-06  +1.03000000E-06  -1.37000000E-06
   +1.78000000E-06  -4.64000000E-06  +1.43000000E-06  -1.39300000E-05  +1.25300000E-05
   +7.57000000E-06  -9.42000000E-06  -6.68000000E-06  -7.40000000E-06  +4.30000000E-06
   -3.02000000E-06  -3.83000000E-06  -4.44000000E-06  -3.39200000E-05  -2.98200000E-05
   -1.89920000E-04  -9.96900000E-05  -1.25620000E-04  -6.32050000E-04  +1.73770000E-04
   +3.52800000E-04  +5.18020000E-04  +3.15100000E-05  -7.69000000E-06  +3.55900000E-05
   -2.52579300E-02  -6.90156800E-02  +1.47781800E-02  +4.97600000E-05  -5.67000000E-06
   -4.45400000E-05  -7.91500000E-05  -5.31300000E-05  +2.61740000E-04  +6.68800000E-05
   -7.15000000E-06  -5.25700000E-05  +8.21600000E-05  +3.02600000E-05  +2.22000000E-06
   -1.72550000E-04  -8.01700000E-05  +1.42000000E-06  -1.20800000E-05  +2.81000000E-05
   +6.44600000E-05  -1.57150000E-04  +2.43800000E-05  -5.45530000E-04  -1.35900000E-05
   +4.95120000E-04  +3.63900000E-05  +1.97550000E-04  +1.07240000E-04  +3.38900000E-05
   -1.50320000E-04  +8.24870000E-04  -2.62370000E-04  +2.96460000E-04  -2.84050000E-04
   +1.27790000E-04  -2.11800000E-04  +1.60620000E-04  -1.18000000E-06  +2.35500000E-05
   -2.97370000E-04  +8.50800000E-05  +7.94310000E-04  +1.32162000E-03  -3.52100000E-04
   -1.33571000E-03  -3.94593000E-03  +4.69610000E-04  -3.75230000E-04  +4.44840000E-04
   -1.43200000E-05  -5.12830000E-04  -5.40630000E-04  +1.40000000E-07  -9.93978700E-02
   +1.81700800E-02  -1.95557680E-01  -3.02400000E-05  -1.67400000E-05  -1.45800000E-05
   +2.02300000E-05  +1.78700000E-05  +1.39600000E-05  -2.17900000E-05  +1.11800000E-05
   -7.31000000E-06  -6.08300000E-05  -1.37200000E-05  +6.34900000E-05  +7.92000000E-06
   +5.37000000E-06  -8.33000000E-06  -1.54050000E-04  -1.50190000E-04  -1.28300000E-05
   -1.28620000E-04  -1.95560000E-04  -2.23500000E-04  -3.06200000E-05  -2.92500000E-05
   +5.25100000E-05  +1.30900000E-04  +1.17150000E-04  +2.94400000E-05  -4.68320000E-04
   +2.33500000E-04  +1.50080000E-04  +2.73330000E-04  +9.59500000E-05  +7.86000000E-06
   -1.38914000E-03  +4.17336000E-03  -7.57828000E-03  -9.84300000E-05  +3.25930000E-04
   +1.99700000E-04  -3.23000000E-05  +3.54200000E-05  -1.84000000E-05  +5.55000000E-06
   +1.18380000E-04  +2.06800000E-05  +2.97300000E-05  -3.14700000E-05  -1.50000000E-07
   +1.02854300E-01  +1.73300000E-05  +2.72000000E-06  +4.53700000E-05  -1.64900000E-05
   -1.44470000E-04  -6.47100000E-05  +3.82000000E-06  -1.22500000E-05  +2.67000000E-05
   +1.57100000E-05  -2.22600000E-05  -2.60000000E-05  -9.28100000E-05  -4.14500000E-05
   -1.53000000E-05  +2.33100000E-05  +1.02700000E-05  +7.98000000E-06  -2.13210000E-04
   +2.39550000E-04  -3.13790000E-04  +1.22200000E-04  +1.42740000E-04  +1.68400000E-05
   +1.05760000E-04  +4.52500000E-05  +1.17600000E-05  +2.33400000E-05  +1.10110000E-04
   -7.57650000E-04  +2.03410000E-04  +8.47900000E-05  +4.91320000E-04  +2.56700000E-05
   +9.43900000E-05  -1.59150000E-04  +3.55320000E-04  -5.44290000E-04  +7.86760000E-04
   -1.54100000E-05  +1.15920000E-04  -3.32710000E-04  -1.15620000E-03  +4.27170000E-04
   -1.66090000E-03  -2.58770000E-04  +3.87010000E-04  +3.33400000E-05  +2.43130000E-04
   -1.44490000E-04  +2.23800000E-05  +3.10077200E-02  -3.31941000E-02  +7.98051200E-02
   -2.14900000E-05  -3.11000000E-06  -7.91000000E-06  +2.50000000E-07  +9.97000000E-06
   +2.96000000E-06  -1.51700000E-05  +1.05500000E-05  -3.14700000E-05  -7.21000000E-06
   +5.20000000E-06  -7.03000000E-06  +5.60000000E-06  +9.62000000E-06  -4.65000000E-06
   +8.76900000E-05  -3.48100000E-05  +3.78600000E-05  -5.02410000E-04  -2.78100000E-05
   -3.57400000E-05  -3.03800000E-05  -1.23500000E-05  -1.75900000E-05  -8.55400000E-05
   -4.40800000E-05  +2.94200000E-05  +4.24000000E-06  +2.94190000E-04  +1.98600000E-05
   +9.85300000E-05  -3.81300000E-05  -2.94700000E-05  -9.24127000E-03  -1.71241000E-03
   -1.43752100E-02  +2.88170000E-04  -2.32810000E-04  -6.60860000E-04  +2.23700000E-05
   +2.55000000E-05  -1.27290000E-04  +6.87000000E-05  +5.26500000E-05  +8.81600000E-05
   +2.43300000E-05  -5.43500000E-05  -6.60000000E-06  -2.10902300E-02  +3.41955600E-02
   -2.02700000E-05  -1.21600000E-05  +9.06900000E-05  +4.93100000E-05  -1.65780000E-04
   -1.04010000E-04  -5.16000000E-06  -2.86300000E-05  +2.69200000E-05  -3.35000000E-06
   -3.29800000E-05  -4.09700000E-05  -8.28400000E-05  -3.96500000E-05  -3.03800000E-05
   +3.89700000E-05  +2.93200000E-05  +8.47000000E-06  -6.03610000E-04  +1.13510000E-04
   +2.04450000E-04  +4.76160000E-04  +5.70000000E-06  +1.61900000E-05  +9.88200000E-05
   +4.12800000E-05  +9.28000000E-06  -5.14550000E-04  +2.12727000E-03  -2.77900000E-05
   +8.85250000E-04  -2.69880000E-04  -2.17340000E-04  -5.81400000E-05  +2.42320000E-04
   -3.20300000E-05  +8.73600000E-05  -6.01640000E-04  +1.33760000E-04  +3.51320000E-04
   +1.53507000E-03  -1.90640000E-04  -8.38520000E-04  -7.18668000E-03  +1.40154000E-03
   -2.51810000E-04  +4.96460000E-04  -5.06500000E-05  +4.13070000E-04  +1.24300000E-04
   -2.32400000E-05  -2.04853020E-01  +5.66693300E-02  -4.20598930E-01  -1.85900000E-05
   -2.30000000E-06  -7.68000000E-06  -3.82000000E-06  +8.28000000E-06  +8.80000000E-07
   -1.45300000E-05  +1.36400000E-05  -3.73500000E-05  +1.16600000E-05  +5.54000000E-06
   -2.17400000E-05  +7.02000000E-06  +9.61000000E-06  -3.21000000E-06  +6.31800000E-05
   -6.62400000E-05  +4.87200000E-05  -7.55900000E-05  +4.30000000E-07  -8.20700000E-05
   -1.29200000E-05  +2.41900000E-05  -3.81000000E-05  +1.85700000E-05  +3.28900000E-05
   +6.85000000E-06  +4.78600000E-05  -5.11900000E-05  +1.92420000E-04  -3.80800000E-05
   -1.05580000E-04  -9.58600000E-05  +1.57961000E-03  +9.88579000E-03  -2.52826000E-03
   +1.98560000E-04  -3.20580000E-04  -9.91900000E-05  +2.57300000E-05  +6.25700000E-05
   +5.13000000E-06  -5.29300000E-05  +2.77120000E-04  -3.30700000E-05  +2.20700000E-05
   -2.95200000E-05  +9.59000000E-06  +2.03073210E-01  -6.27918100E-02  +4.22107640E-01
end_hess

