# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -807.47012340    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -1.70958288E+00  +1.43965424E-01  -2.20932414E+00
   006   -1.40435085E+00  +1.72790233E+00  -1.17234004E-01
   006   -3.47652883E+00  +2.07444101E+00  +1.46143332E+00
   006   -5.77422377E+00  +9.17878502E-01  +9.79647598E-01
   006   -6.04156393E+00  -6.44112168E-01  -1.12176682E+00
   006   -3.96983519E+00  -1.04409565E+00  -2.70780749E+00
   006   +1.13850484E+00  +3.03955779E+00  +2.99236816E-01
   006   +1.41610647E+00  +5.07187039E+00  -1.75680322E+00
   008   -8.23396417E+00  -1.75437272E+00  -1.72739291E+00
   006   +3.25524318E+00  +1.06976080E+00  +1.94113049E-01
   006   +5.38765914E+00  +1.32355525E+00  -1.30680976E+00
   006   +7.29795908E+00  -4.78973400E-01  -1.29276699E+00
   006   +7.10127159E+00  -2.58799389E+00  +2.43966505E-01
   006   +4.97636141E+00  -2.88314178E+00  +1.76141076E+00
   006   +3.09789124E+00  -1.07647335E+00  +1.72062037E+00
   008   +8.90053256E+00  -4.41686920E+00  +3.42014408E-01
   006   +1.28980778E+00  +4.36825900E+00  +2.87588349E+00
   008   -1.03616289E+01  -3.29640105E+00  +1.95992449E+00
   001   +5.60545135E+00  +2.94215628E+00  -2.53328104E+00
   001   +8.94041753E+00  -2.29630615E-01  -2.49184277E+00
   001   +4.82290004E+00  -4.53867498E+00  +2.94932199E+00
   001   +1.44243097E+00  -1.35348456E+00  +2.89231747E+00
   001   -3.32400834E+00  +3.26342362E+00  +3.11445620E+00
   001   -7.35777312E+00  +1.19036023E+00  +2.24414725E+00
   001   -4.18461101E+00  -2.28391608E+00  -4.31786656E+00
   001   -1.15985421E-01  -1.93799542E-01  -3.44763336E+00
   001   -8.58280117E-02  +5.89751934E+00  +3.01768586E+00
   001   +9.75187309E-01  +3.05701245E+00  +4.43299744E+00
   001   +3.16676666E+00  +5.18305891E+00  +3.11025427E+00
   001   -1.84716232E-01  +6.36452602E+00  -1.66148856E+00
   001   +3.13675045E+00  +6.17548820E+00  -1.48796353E+00
   001   +1.45145146E+00  +4.25112245E+00  -3.64570151E+00
   001   -9.42591614E+00  -1.85163973E+00  -2.56155213E-01
   001   +1.02544573E+01  -3.99966129E+00  -7.81370488E-01
   001   -1.10934698E+01  -4.85737043E+00  +1.36711575E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +3.50000000E-07  +2.00000000E-08  -3.30000000E-07
   +2.00000000E-08  -4.00000000E-08  -1.90000000E-07
   -2.80000000E-07  -2.20000000E-07  -4.70000000E-07
   -1.70000000E-07  -3.00000000E-07  -8.90000000E-07
   +2.00000000E-07  -2.20000000E-07  -1.08000000E-06
   +5.10000000E-07  -2.00000000E-08  -7.40000000E-07
   -1.20000000E-07  +6.00000000E-08  +2.90000000E-07
   +8.00000000E-08  +1.50000000E-07  +3.90000000E-07
   +4.50000000E-07  -2.20000000E-07  -1.36000000E-06
   -3.00000000E-08  +9.00000000E-08  +4.70000000E-07
   +1.40000000E-07  +3.30000000E-07  +8.20000000E-07
   +2.80000000E-07  +3.30000000E-07  +1.02000000E-06
   +7.00000000E-08  +2.70000000E-07  +9.10000000E-07
   -1.30000000E-07  +1.00000000E-07  +5.70000000E-07
   -1.80000000E-07  +1.00000000E-08  +3.90000000E-07
   +1.70000000E-07  +3.30000000E-07  +1.07000000E-06
   -5.70000000E-07  -9.00000000E-08  +3.80000000E-07
   -1.70000000E-07  -5.00000000E-07  -1.83000000E-06
   +3.20000000E-07  +3.40000000E-07  +9.60000000E-07
   +4.30000000E-07  +4.90000000E-07  +1.29000000E-06
   -2.30000000E-07  +5.00000000E-08  +4.20000000E-07
   -3.60000000E-07  -1.00000000E-07  +9.00000000E-08
   -5.70000000E-07  -3.00000000E-07  -3.80000000E-07
   -3.60000000E-07  -4.20000000E-07  -1.12000000E-06
   +7.90000000E-07  +7.00000000E-08  -8.10000000E-07
   +5.70000000E-07  +1.70000000E-07  -9.00000000E-08
   -6.90000000E-07  -1.80000000E-07  +2.30000000E-07
   -7.70000000E-07  -2.10000000E-07  +2.50000000E-07
   -6.50000000E-07  -4.00000000E-08  +6.90000000E-07
   +3.00000000E-08  +7.00000000E-08  +2.40000000E-07
   +0.00000000E+00  +2.00000000E-07  +7.40000000E-07
   +4.10000000E-07  +2.50000000E-07  +3.90000000E-07
   +1.20000000E-07  -4.10000000E-07  -1.59000000E-06
   +3.10000000E-07  +4.50000000E-07  +1.30000000E-06
   +4.00000000E-08  -5.20000000E-07  -2.03000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +7.02841480E-01  +1.18681460E-01  +3.47476910E-01  -1.13375210E-01  +2.25066360E-01
   +5.15763570E-01  -1.24963610E-01  -4.10188800E-02  -3.00857500E-02  +5.98173030E-01
   -1.50895000E-03  -1.53749710E-01  -1.17063490E-01  +8.64820400E-02  +3.61182500E-01
   +2.70103400E-02  -9.63489300E-02  -2.21597210E-01  -9.48900500E-02  +1.94578640E-01
   +5.13180210E-01  +4.31291300E-02  +4.89032100E-02  +5.11552600E-02  -2.39223570E-01
   -1.44271600E-02  +6.88784000E-02  +6.25850700E-01  +2.14350800E-02  +7.96571000E-03
   -1.18771700E-02  +2.56461100E-02  -9.62215700E-02  -5.44524000E-02  +1.28199410E-01
   +3.69390650E-01  +1.38788200E-02  -2.52551100E-02  -3.37581200E-02  +1.27810870E-01
   -3.53553600E-02  -1.84164440E-01  -7.08747900E-02  +2.65280290E-01  +5.62843860E-01
   -2.28827700E-02  -2.39066400E-02  -2.32985700E-02  -5.47118900E-02  +7.81674000E-03
   +4.32102200E-02  -2.90454010E-01  -1.20626120E-01  -5.35086800E-02  +6.95154090E-01
   -1.94729400E-02  -2.49247800E-02  -2.03190700E-02  -2.27672800E-02  +2.57542700E-02
   +3.88237600E-02  -7.79156000E-02  -1.31809030E-01  -5.96934200E-02  +1.22442050E-01
   +3.34896620E-01  -1.83346300E-02  -1.96148000E-02  -2.13122700E-02  -1.40312000E-03
   +2.39969300E-02  +4.13531000E-02  +7.06515000E-03  -3.80955500E-02  -1.18664920E-01
   -1.18998500E-01  +2.30857160E-01  +5.32200020E-01  -6.05784300E-02  -3.35600000E-02
   -1.66000900E-02  -1.85245000E-03  +2.12867000E-02  +2.71792700E-02  +9.51399000E-03
   -1.67483300E-02  -2.80229200E-02  -1.19470630E-01  -1.43440600E-02  +4.27070000E-04
   +6.26897470E-01  +2.13250000E-03  +2.06529900E-02  +2.27556400E-02  +1.91720100E-02
   -1.62594800E-02  -2.40749500E-02  -5.28365100E-02  -1.74713300E-02  -4.32122000E-03
   +1.00782000E-02  -1.45305630E-01  -1.12600180E-01  +9.94257000E-02  +3.52660920E-01
   +3.30281800E-02  +3.64941600E-02  +3.98457200E-02  +2.51596100E-02  -2.17155800E-02
   -5.10798200E-02  -7.67699300E-02  -2.15747600E-02  +1.11635000E-02  +3.85667800E-02
   -9.60838800E-02  -2.34539720E-01  -1.00206070E-01  +2.16600860E-01  +5.40690950E-01
   -3.05101020E-01  -8.53297500E-02  +5.73221000E-03  +1.93105300E-02  -4.67707000E-02
   -7.36150100E-02  -6.08452200E-02  -1.00205300E-02  +1.43890400E-02  +3.85272100E-02
   +3.60961300E-02  +3.65780800E-02  -1.91481500E-01  +9.83706000E-03  +8.15699300E-02
   +6.48988970E-01  -1.29297680E-01  -1.37890040E-01  -4.19262600E-02  -1.58686900E-02
   -1.62773500E-02  -2.50887300E-02  -1.27393000E-02  -4.80926000E-03  +3.97910000E-03
   +2.04707600E-02  +9.30593000E-03  -1.01898700E-02  +3.59586700E-02  -1.03726650E-01
   -5.94965900E-02  +1.44742240E-01  +3.84897790E-01  -5.50322600E-02  -6.22907300E-02
   -1.21088600E-01  -2.87046300E-02  -9.36581000E-03  +1.03002600E-02  +1.32519600E-02
   +2.78228000E-03  -6.44122000E-03  +1.18182900E-02  -2.04131100E-02  -2.51538400E-02
   +1.18378000E-01  -4.40856500E-02  -1.94543300E-01  -6.05636100E-02  +2.75987760E-01
   +5.47529470E-01  -3.95749000E-03  -7.51949000E-03  -7.37897000E-03  -1.52211440E-01
   -3.61574100E-02  -6.06481000E-03  -2.03176000E-02  -1.11466000E-02  -1.67061000E-03
   -2.63360000E-04  -1.14172000E-03  +2.55522000E-03  -8.85920000E-04  +1.16292000E-03
   +1.22599000E-03  +3.08915000E-03  +7.69170000E-04  +1.78309000E-03  +4.74865160E-01
   -1.82892300E-02  -8.83934000E-03  -4.63781000E-03  -3.78639900E-02  -9.47064000E-02
   -1.44319400E-02  -3.32600000E-05  +6.88720000E-03  +3.36933000E-03  +1.12559000E-03
   +4.35089000E-03  -3.98621000E-03  -7.32250000E-04  -9.55270000E-04  -3.76870000E-04
   +7.19400000E-05  +1.95521000E-03  -4.22434000E-03  +6.71840000E-04  +4.79704750E-01
   -2.37124900E-02  -1.09039900E-02  +6.47000000E-04  -1.09568600E-02  -1.62337200E-02
   -8.64515100E-02  +1.42858300E-02  +8.80187000E-03  +7.85603000E-03  +3.32452000E-03
   -3.99225000E-03  -8.43100000E-04  +2.67932000E-03  +7.15210000E-04  -6.93660000E-04
   -1.62630000E-04  -5.24752000E-03  -2.26526000E-03  +3.32900000E-05  +2.20117000E-03
   +4.81206070E-01  -1.25252000E-03  -1.61753000E-03  -1.96120000E-04  -8.63372000E-03
   -2.31494100E-02  +2.14517500E-02  -1.87633000E-03  -1.42795000E-03  -9.74190000E-04
   -7.75250000E-04  +1.59735000E-03  -3.55770000E-04  -2.10605000E-03  -8.64410000E-04
   -1.78450000E-04  +1.32463000E-03  +7.37010000E-04  -1.21620000E-04  -7.63007200E-02
   -9.49760000E-03  +1.01837000E-02  +5.85194570E-01  -4.49420000E-04  -3.47490000E-04
   +6.39640000E-04  -1.19125000E-02  -1.76845600E-02  +1.17203100E-02  +1.41140000E-03
   -8.02850000E-04  -5.21380000E-04  -4.41370000E-04  +1.89520000E-04  -6.37770000E-04
   -3.66740000E-04  +1.23200000E-04  +3.16740000E-04  +3.55250000E-04  +6.29330000E-04
   +5.66900000E-05  -3.58424000E-03  -1.22144730E-01  +4.97243400E-02  -7.70614000E-03
   +5.20232230E-01  -2.37139000E-03  -1.61967000E-03  -9.65870000E-04  +7.28164000E-03
   +2.99052000E-03  +3.06439000E-03  -1.55567000E-03  -3.32030000E-04  -1.23510000E-04
   +3.89600000E-05  +5.25020000E-04  +2.71660000E-04  -1.76183000E-03  -7.71280000E-04
   -6.56200000E-05  +1.39427000E-03  +1.16920000E-04  -4.08830000E-04  +4.65777000E-03
   +4.59784700E-02  -1.23601250E-01  +5.05476000E-03  +6.49745400E-02  +5.30117730E-01
   +1.17408100E-02  +1.60223300E-02  +2.28321400E-02  -1.00155200E-02  -6.97395000E-03
   -4.66242000E-03  +2.05089400E-02  +4.32110000E-04  -4.64130000E-03  -2.22304500E-02
   -4.09454700E-02  -3.58365300E-02  -2.08693890E-01  -7.38102600E-02  -3.44844000E-02
   -8.86424100E-02  -2.09154400E-02  +6.26296000E-03  -3.39240000E-04  +1.17773000E-03
   -2.57964000E-03  +2.11063000E-03  +2.40550000E-04  +1.71540000E-03  +4.15564480E-01
   +3.19751000E-03  +9.02012000E-03  +4.30325000E-03  -6.05612000E-03  -2.29541000E-03
   +1.49309000E-03  +1.41082800E-02  +4.20111000E-03  -1.05355200E-02  -4.14632300E-02
   -2.33545500E-02  -2.81466500E-02  -6.69191600E-02  -9.12458000E-02  -3.88994600E-02
   -1.96688800E-02  +7.89127000E-03  +8.01967000E-03  -3.49150000E-04  +5.76400000E-05
   -9.15510000E-04  +1.18611000E-03  +8.78900000E-05  +1.00241000E-03  +1.16780820E-01
   +1.09962890E-01  +1.05370000E-03  -7.27837000E-03  -7.29250000E-03  +4.05920000E-04
   +1.89879000E-03  +5.28780000E-04  +6.66510000E-04  -4.25417000E-03  -1.47594000E-03
   -3.65603200E-02  -1.58844900E-02  +1.82502000E-03  -4.06875500E-02  -5.14783600E-02
   -1.19720470E-01  +3.25332800E-02  +1.20936800E-02  +1.24941800E-02  +6.69300000E-04
   -1.60700000E-05  +1.22634000E-03  -1.13608000E-03  -2.13990000E-04  -8.13420000E-04
   -9.18050000E-02  +7.07599300E-02  +3.60888860E-01  -1.20684000E-03  +4.74040000E-04
   -9.11740000E-04  -3.54242000E-02  +1.61781900E-02  +2.92377000E-03  -1.05408000E-03
   -7.95520000E-04  -2.41659000E-03  -5.92920000E-04  -1.00775000E-03  +7.79560000E-04
   -5.04740000E-04  +4.38000000E-05  +4.45430000E-04  +7.47550000E-04  +5.72820000E-04
   +6.32240000E-04  -1.29681470E-01  +4.75391000E-02  +7.68192000E-03  +3.08001000E-03
   +2.41170000E-03  -3.78952000E-03  +3.14230000E-04  +2.21460000E-04  -1.25330000E-04
   +5.58287610E-01  -2.69415000E-03  -6.44200000E-04  -1.23616000E-03  -3.23407000E-03
   +1.27715400E-02  +2.88449000E-03  -2.21938000E-03  -2.25818000E-03  -8.73690000E-04
   -5.83620000E-04  -1.26650000E-04  +1.05849000E-03  -1.34896000E-03  -2.65260000E-04
   +1.67000000E-06  +1.10711000E-03  -2.00790000E-04  -3.92740000E-04  +4.39798700E-02
   -1.23573550E-01  +7.12743000E-03  +1.83480000E-02  -2.09268500E-02  +1.25526000E-03
   +1.34385000E-03  +7.76030000E-04  -7.92540000E-04  -8.40803700E-02  +5.23962240E-01
   -2.27430000E-03  -6.49560000E-04  -5.40350000E-04  -1.44900000E-05  +1.39969000E-03
   +2.21000000E-06  -2.63960000E-04  +1.97730000E-04  -1.98200000E-05  +1.09700000E-04
   +2.97830000E-04  +2.76350000E-04  -5.64540000E-04  -3.83700000E-04  -2.59960000E-04
   +1.31230000E-04  +3.56920000E-04  +1.91000000E-06  +1.00069500E-02  +4.60856000E-03
   -7.85726900E-02  -1.88080500E-02  +1.78270700E-02  +8.77890000E-04  +6.58150000E-04
   +3.36050000E-04  -1.70550000E-04  -1.79089580E-01  -1.67598470E-01  +4.09000100E-01
   +7.85930000E-04  +3.47000000E-05  +7.26150000E-04  -6.49910000E-04  +1.12962000E-03
   +3.24610000E-04  -7.50530000E-04  -5.49390000E-04  -4.46000000E-05  +1.67900000E-04
   +9.11600000E-05  +1.87900000E-04  +4.81630000E-04  +1.25100000E-04  -2.48040000E-04
   -5.99800000E-04  -3.07730000E-04  +1.48170000E-04  -1.74369500E-02  +2.34554000E-03
   +1.05734100E-02  -1.35962000E-03  +2.26880000E-04  +9.26630000E-04  -4.32970000E-04
   -2.11010000E-04  +1.22830000E-04  -2.50722250E-01  +2.45395500E-02  +9.89702000E-02
   +5.65504220E-01  -4.03960000E-04  +1.60540000E-04  -9.76000000E-05  +8.10470000E-04
   -2.78090000E-03  -1.04541000E-03  +1.00707000E-03  +7.43030000E-04  +1.47480000E-04
   -6.58600000E-05  -1.01410000E-04  -3.83760000E-04  -7.04800000E-05  +1.24050000E-04
   +2.40090000E-04  +2.63520000E-04  +2.85730000E-04  -2.53500000E-05  +1.75948800E-02
   +6.07711000E-03  -1.23328000E-02  +1.16591000E-03  -5.53530000E-04  -9.80800000E-04
   -4.75800000E-05  -7.10600000E-05  +1.16920000E-04  -2.73785300E-02  -1.18265120E-01
   +5.11316600E-02  -1.16897360E-01  +5.91591790E-01  -7.64040000E-04  -2.29890000E-04
   -9.85650000E-04  -1.81860000E-03  +1.09093000E-03  +2.52000000E-05  -5.14200000E-05
   -3.79800000E-05  +3.82400000E-05  -2.07580000E-04  -1.00960000E-04  +2.30300000E-04
   -7.49570000E-04  -2.80480000E-04  +3.70900000E-05  +6.32790000E-04  +2.83290000E-04
   +2.03700000E-05  +1.73151000E-03  -3.39247000E-03  +3.15499000E-03  -7.05100000E-04
   -6.00760000E-04  -1.34920000E-04  +7.26660000E-04  +4.07210000E-04  -2.57380000E-04
   +1.33814390E-01  +2.00360900E-02  -1.63409970E-01  -1.88094920E-01  -2.28956650E-01
   +4.12510210E-01  -2.81920000E-04  +5.66200000E-05  -1.22290000E-04  +7.22000000E-06
   +6.04950000E-04  +1.96310000E-04  +2.38600000E-05  +2.92600000E-05  -1.28840000E-04
   -3.63800000E-05  +4.27000000E-06  +5.51700000E-05  -2.93450000E-04  -1.18740000E-04
   +4.73100000E-05  +3.82730000E-04  +1.03800000E-05  -1.49260000E-04  -5.18000000E-06
   -9.21630000E-04  +4.37504000E-03  +1.66120000E-04  -7.50870000E-04  +1.31180000E-04
   +3.51840000E-04  +2.07930000E-04  -1.85420000E-04  -4.42994500E-02  +2.50535000E-03
   +3.05553800E-02  -2.25772150E-01  +1.48065850E-01  +5.04824000E-03  +6.08487520E-01
   +8.91920000E-04  +1.77440000E-04  +4.08370000E-04  +4.40430000E-04  -1.27328000E-03
   -3.63260000E-04  +5.31800000E-05  -7.15700000E-05  +2.73500000E-04  +1.56460000E-04
   -8.38000000E-06  -2.19480000E-04  +9.95680000E-04  +3.25670000E-04  -6.08200000E-05
   -9.60280000E-04  -1.46600000E-04  +2.87510000E-04  +1.51590000E-04  +2.36414000E-03
   +2.41023000E-03  +5.39280000E-04  -4.74870000E-04  -3.31200000E-05  -1.07438000E-03
   -5.81690000E-04  +4.82100000E-04  +4.26015800E-02  +4.12407400E-02  -4.86021100E-02
   +9.55826700E-02  -2.12183470E-01  +4.15807300E-02  -1.27177440E-01  +5.53216130E-01
   -1.78900000E-05  -1.74890000E-04  -3.69550000E-04  +8.55290000E-04  -7.23520000E-04
   -2.10370000E-04  +1.58050000E-04  +1.87600000E-04  +1.55120000E-04  -2.56200000E-05
   +8.16000000E-05  +9.59000000E-06  -2.70070000E-04  -1.41060000E-04  -3.03600000E-05
   +2.10020000E-04  +5.14200000E-05  -2.70500000E-05  +4.42825000E-03  +3.63223000E-03
   +2.40514000E-03  -6.00520000E-04  +5.90570000E-04  -1.32820000E-04  +3.24770000E-04
   +1.78490000E-04  -1.06100000E-04  +3.59296000E-03  -2.44787600E-02  +2.08245000E-02
   +3.98670600E-02  +9.43200000E-03  -9.04688600E-02  -2.17876150E-01  -2.07757740E-01
   +4.00469120E-01  +7.20400000E-05  +4.57950000E-04  +5.16550000E-04  -5.67760000E-04
   -2.51650000E-04  +7.31200000E-05  +7.65020000E-04  +2.59380000E-04  -1.37140000E-04
   -1.14590000E-04  -5.22690000E-04  -5.35020000E-04  +7.26090000E-04  +6.02660000E-04
   +4.54530000E-04  -3.68760000E-04  -4.90900000E-05  -2.93800000E-05  -2.48053000E-03
   +4.21770000E-04  +3.39260000E-04  +4.63400000E-04  +1.38080000E-04  -1.35780000E-04
   -1.12147000E-03  -6.79470000E-04  +5.44770000E-04  -2.17590100E-02  -2.90527700E-02
   +3.01502500E-02  +4.49477700E-02  +5.51459000E-03  -2.99306300E-02  -1.25952790E-01
   +2.44782200E-02  +1.94519000E-02  +6.04142080E-01  -6.50300000E-04  -5.47100000E-04
   -8.18850000E-04  +2.86880000E-04  +1.34331000E-03  +3.07380000E-04  -4.82820000E-04
   -3.92900000E-05  -5.29800000E-05  -7.79100000E-05  +2.83560000E-04  +5.01140000E-04
   -1.29211000E-03  -6.33360000E-04  -2.25440000E-04  +1.04265000E-03  +1.30260000E-04
   -2.17740000E-04  -1.20620000E-04  -1.12221000E-03  +1.08700000E-03  -4.23360000E-04
   +2.08200000E-05  +1.21200000E-05  +1.59370000E-03  +9.09530000E-04  -7.33290000E-04
   -2.68091300E-02  -2.44608800E-02  +2.89227100E-02  +5.01573500E-02  -4.49046400E-02
   +4.99590000E-04  -3.82374700E-02  -2.37804140E-01  +1.37175140E-01  -1.21508990E-01
   +5.78493000E-01  +4.76800000E-04  -3.71200000E-05  +3.60160000E-04  +3.01930000E-04
   -4.99960000E-04  -2.29140000E-04  -2.80320000E-04  -1.47430000E-04  +1.58010000E-04
   +1.87140000E-04  +1.15360000E-04  +6.56000000E-06  +4.55970000E-04  +8.37900000E-05
   -1.68040000E-04  -5.42750000E-04  -1.28750000E-04  +1.47250000E-04  +1.06352000E-03
   +2.49470000E-04  -1.41060000E-03  +8.34900000E-05  +1.01130000E-04  +2.40920000E-04
   -4.20310000E-04  -2.22810000E-04  +1.64900000E-04  +2.83045300E-02  +3.04559100E-02
   -4.37623600E-02  -6.05420500E-02  +2.79992500E-02  +2.03236900E-02  +6.14919900E-02
   +9.77065300E-02  -1.72878200E-01  -1.93921370E-01  -2.01883800E-01  +4.18834100E-01
   +3.46910000E-04  -1.76100000E-04  +1.37250000E-04  +3.48250000E-04  -1.55340000E-04
   -3.46380000E-04  -5.75040000E-04  -2.42100000E-04  +1.19460000E-04  +2.85910000E-04
   +3.75760000E-04  +2.89530000E-04  -1.16220000E-04  -2.96320000E-04  -3.77840000E-04
   -2.25070000E-04  -1.33560000E-04  +1.33230000E-04  +3.54956000E-03  -1.25719000E-03
   +2.27770000E-03  +4.32010000E-04  -5.08570000E-04  +3.19600000E-04  +3.28260000E-04
   +2.13800000E-04  -1.70370000E-04  +3.75866400E-02  +4.86860900E-02  -5.22435900E-02
   -6.00334600E-02  +1.97709800E-02  +2.15001000E-02  +2.30644200E-02  -6.35057700E-02
   +3.33323000E-02  -2.29347760E-01  +1.33402800E-02  +8.98199400E-02  +5.79258660E-01
   -2.63100000E-04  +2.24780000E-04  -2.15850000E-04  -7.17780000E-04  +7.96000000E-05
   -2.70950000E-04  +2.81270000E-04  +2.94750000E-04  -1.94250000E-04  -1.61800000E-05
   -3.40000000E-06  +1.57400000E-05  -2.14250000E-04  -1.08130000E-04  +5.77200000E-05
   +3.61630000E-04  +1.54420000E-04  -1.15570000E-04  -1.63212000E-03  -4.29010000E-04
   +5.34739000E-03  +1.11797000E-03  -7.12340000E-04  -3.05100000E-04  +3.01020000E-04
   +1.80430000E-04  -1.28100000E-04  +9.03746000E-03  -4.00930900E-02  +2.64804300E-02
   +2.09513100E-02  -9.85123000E-03  -8.22955000E-03  -2.73832900E-02  +1.85848700E-02
   +1.02793000E-02  -4.69500300E-02  -1.22601490E-01  +6.32619300E-02  -1.39883120E-01
   +6.14955610E-01  -1.46120000E-04  +2.38100000E-05  -5.63400000E-05  +4.11630000E-04
   -7.06900000E-05  -6.25000000E-06  +3.39810000E-04  +9.16300000E-05  +2.47200000E-05
   -1.71440000E-04  -2.34470000E-04  -1.63920000E-04  +8.63900000E-05  +1.82450000E-04
   +1.98710000E-04  +1.20470000E-04  +1.00730000E-04  -8.90200000E-05  +2.09960000E-03
   +4.22140000E-03  +2.41230000E-04  -6.20640000E-04  +5.95450000E-04  +1.70190000E-04
   -2.20980000E-04  -1.28570000E-04  +1.29160000E-04  -2.43993800E-02  +1.71226000E-03
   +2.26807200E-02  +2.13655300E-02  -7.74352000E-03  -1.09991000E-02  +9.09329000E-03
   +3.28382700E-02  -1.92531900E-02  +1.29441260E-01  +2.56263600E-02  -1.68870160E-01
   -1.84749260E-01  -2.34769020E-01  +4.00358470E-01  -1.23311000E-03  +8.67100000E-05
   -1.04972000E-03  -1.90620000E-04  +2.93518000E-03  -1.13277000E-03  +5.45880000E-04
   +3.07790000E-04  -2.86130000E-04  -3.04190000E-04  -3.15130000E-04  +7.51000000E-05
   -6.09640000E-04  -1.46940000E-04  +1.92970000E-04  +7.30670000E-04  +2.27800000E-04
   -1.74430000E-04  +2.22321000E-03  +2.05791400E-02  -1.54271000E-02  -4.34646000E-03
   +3.44730000E-03  +1.16906000E-03  +5.22490000E-04  +2.77820000E-04  -1.54160000E-04
   -1.17347150E-01  -2.42281100E-02  +4.59089700E-02  +2.09755400E-02  -2.97365900E-02
   +1.26566300E-02  -1.21621900E-02  +2.05513600E-02  -8.30867000E-03  -4.70965800E-02
   +4.21356000E-03  +2.77696800E-02  -2.39362100E-01  +1.59590600E-01  +4.60638000E-03
   +6.28774940E-01  +9.21100000E-05  -4.69000000E-04  -7.29770000E-04  -5.30560000E-04
   -9.75910000E-04  +6.48200000E-04  -1.96310000E-04  -8.40100000E-05  +3.09950000E-04
   -1.51220000E-04  -5.55800000E-05  +1.14100000E-04  -9.35200000E-05  -1.26560000E-04
   -2.89500000E-05  -8.01400000E-05  +2.02450000E-04  +2.33970000E-04  +5.76172000E-03
   -2.07205500E-02  +1.13025300E-02  +2.81708000E-03  -9.98250000E-04  -8.51730000E-04
   +7.16400000E-05  +4.43200000E-05  +9.48700000E-05  +2.76787100E-02  -2.33345800E-01
   +8.99280500E-02  -6.99372600E-02  +1.72303800E-02  +3.69201800E-02  +2.45924000E-02
   -5.71193700E-02  +2.07577800E-02  +4.84374600E-02  +4.48776000E-02  -5.82661200E-02
   +1.06528390E-01  -2.28219000E-01  +4.57909000E-02  -1.30199710E-01  +5.53613930E-01
   -7.21910000E-04  +7.46590000E-04  -2.52200000E-04  -6.74290000E-04  +4.38460000E-04
   +2.09170000E-04  +5.20580000E-04  +2.53940000E-04  -5.82290000E-04  +1.73900000E-05
   +1.18210000E-04  -1.46620000E-04  -1.06550000E-04  -3.08000000E-05  +1.64540000E-04
   +3.85850000E-04  +1.53730000E-04  -9.95900000E-05  -4.73145000E-03  +6.28280000E-04
   +4.14433000E-03  +1.22378000E-03  -5.07800000E-04  +1.75400000E-05  +1.89350000E-04
   +1.05210000E-04  -1.10750000E-04  +1.02913300E-02  +1.22033740E-01  -1.58488760E-01
   +3.95026900E-02  +1.22564800E-02  -2.40249400E-02  -1.09234900E-02  +2.34407600E-02
   -1.22971400E-02  -1.93873000E-03  -3.10962200E-02  +2.40508100E-02  +3.98245600E-02
   +1.29738500E-02  -9.35661300E-02  -2.07377480E-01  -1.88837320E-01  +3.97345900E-01
   -4.91040000E-04  -5.83610000E-04  -7.35060000E-04  +5.35780000E-04  +1.06435000E-03
   +9.18000000E-05  -7.88850000E-04  -1.83100000E-04  -2.77000000E-05  +5.00800000E-05
   +5.07940000E-04  +6.43510000E-04  -1.25659000E-03  -7.73820000E-04  -4.22410000E-04
   +8.39350000E-04  +7.67000000E-05  -1.26090000E-04  +1.41127000E-03  -9.88720000E-04
   +5.03000000E-04  -6.50070000E-04  -9.53000000E-06  +1.74880000E-04  +1.67673000E-03
   +9.82850000E-04  -8.02660000E-04  +1.20600000E-04  +4.39067000E-03  -4.68117000E-03
   -1.43001000E-03  +1.32463000E-03  +4.74479000E-03  -1.11452000E-03  +1.08611000E-02
   -3.53120000E-04  -1.93091230E-01  +1.35877620E-01  +2.41584000E-03  -4.35857900E-02
   +3.82370800E-02  +6.20563000E-03  +2.52999000E-03  -6.46218000E-03  +5.73411000E-03
   +5.37596100E-01  +5.25130000E-04  +5.95830000E-04  +7.27140000E-04  -5.36470000E-04
   -1.12104000E-03  -1.10940000E-04  +7.05160000E-04  +1.59650000E-04  +2.75900000E-05
   -1.57600000E-05  -4.28190000E-04  -5.88480000E-04  +1.23819000E-03  +7.10120000E-04
   +3.62070000E-04  -8.50390000E-04  -6.83300000E-05  +1.28290000E-04  -1.20822000E-03
   +7.45840000E-04  -1.20655000E-03  +6.08860000E-04  -4.19000000E-05  -1.39880000E-04
   -1.60141000E-03  -9.16700000E-04  +7.66430000E-04  +3.19917000E-03  -5.35230000E-04
   -1.72137000E-03  -4.94834000E-03  +2.46735000E-03  +6.72856000E-03  +4.06207900E-02
   -3.64603400E-02  +5.53054000E-03  +9.70710800E-02  -2.00645200E-01  +4.40470200E-02
   +8.50476000E-03  +5.95212000E-03  -4.44448000E-03  -1.00656000E-03  -1.44685000E-03
   +4.84832000E-03  -7.96252600E-02  +2.97832480E-01  -7.09000000E-06  -2.61200000E-05
   -5.35600000E-05  -7.47300000E-05  +7.16100000E-05  +1.07370000E-04  +6.08000000E-06
   -1.86700000E-05  +5.62000000E-06  -3.86100000E-05  -1.66400000E-05  +1.57000000E-05
   -3.83800000E-05  -1.39000000E-06  +9.38000000E-06  +3.82300000E-05  +9.30000000E-06
   -1.37500000E-05  -4.48190000E-04  -3.40850000E-04  -1.76450000E-04  +2.79000000E-05
   +9.67000000E-06  -3.89800000E-05  +3.58100000E-05  +1.98900000E-05  +6.39000000E-06
   -3.07934000E-03  -3.18557000E-03  +2.79165000E-03  +9.15181000E-03  +2.76159000E-03
   +3.21150000E-04  -2.03429300E-02  +2.43049500E-02  +6.33720000E-03  +2.83136300E-02
   +1.98198300E-02  -7.48207800E-02  +2.58991500E-02  -2.30004100E-02  +6.36693000E-03
   +2.15031000E-03  +8.18646000E-03  -1.93573000E-03  -2.65125500E-01  -1.30920700E-01
   +2.80241180E-01  -5.87367000E-03  -2.19671000E-03  +2.85480000E-04  -2.31661000E-03
   -1.48818300E-02  -2.87754900E-02  -2.29175000E-03  -8.53410000E-04  -8.21490000E-04
   +3.73210000E-04  +7.01000000E-06  -3.91150000E-04  -6.60390000E-04  -4.58210000E-04
   -2.46510000E-04  +8.36180000E-04  -1.17053000E-03  -1.29392000E-03  -7.61559700E-02
   -7.80260000E-04  -1.62100000E-03  +5.41680000E-04  +1.56318000E-03  +3.90303000E-03
   +7.64220000E-04  +4.75110000E-04  -4.11320000E-04  -2.36011000E-03  +1.33050200E-02
   +2.26239500E-02  -4.56160000E-04  +1.84595000E-03  -4.77500000E-04  -1.22699000E-03
   +2.08050000E-04  -1.23141000E-03  +3.22350000E-04  -9.40280000E-04  +4.71590000E-04
   -2.10500000E-04  -5.69490000E-04  +4.60800000E-05  -2.69700000E-04  +6.59140000E-04
   +7.40890000E-04  -1.01547000E-03  +1.05561000E-03  +1.38300000E-05  +5.86676810E-01
   -2.44084000E-03  +2.88150000E-04  +1.18190000E-04  -5.07354000E-03  -9.25939000E-03
   -1.57731600E-02  -3.29800000E-04  -7.57150000E-04  +6.52450000E-04  +4.62680000E-04
   -4.54930000E-04  -5.60820000E-04  +1.35400000E-05  +1.65230000E-04  -1.02550000E-04
   +3.14900000E-05  -3.92500000E-04  -5.43660000E-04  -4.05203000E-03  -9.52015100E-02
   -4.19445100E-02  +4.98110000E-04  +9.41301000E-03  +2.13162900E-02  -1.41090000E-04
   -1.29860000E-04  +3.27400000E-05  +6.34031000E-03  -1.72950500E-02  -2.29311100E-02
   -1.48334000E-03  -1.25148000E-03  +5.10700000E-04  +8.78540000E-04  -5.47010000E-04
   +1.18586000E-03  +3.56500000E-05  +9.18870000E-04  -6.88150000E-04  -6.38900000E-05
   +8.29040000E-04  +1.40840000E-04  +7.74240000E-04  -6.85910000E-04  -1.17976000E-03
   +6.57730000E-04  -7.57610000E-04  +2.36900000E-05  -3.52385000E-03  +5.58789180E-01
   +5.32260000E-04  +6.17470000E-04  +4.42650000E-04  -6.16436000E-03  -4.08087000E-03
   -5.27732000E-03  +1.32334000E-03  +4.97940000E-04  +2.22970000E-04  +1.95850000E-04
   -3.32380000E-04  -5.28910000E-04  +2.81580000E-04  +2.76220000E-04  +3.54200000E-04
   +1.92020000E-04  +4.15100000E-05  +1.07940000E-04  -6.33553000E-03  -3.75269700E-02
   -1.53026090E-01  +9.12500000E-05  -7.25681000E-03  -3.61896300E-02  -4.11570000E-04
   -2.79040000E-04  +1.99470000E-04  +7.49819000E-03  -9.74422000E-03  -4.11974000E-03
   -1.04740000E-03  +2.79960000E-04  -4.12900000E-05  -5.46900000E-05  +3.29240000E-04
   -9.78200000E-05  +1.78100000E-05  -3.44030000E-04  +4.17070000E-04  +3.77890000E-04
   +9.12200000E-05  -1.92630000E-04  -1.43947000E-03  +1.40432000E-03  -2.04280000E-04
   -4.36150000E-04  +4.37210000E-04  -6.64100000E-05  -1.02077200E-02  -5.48951800E-02
   +4.93430030E-01  +7.55920000E-04  +1.40523000E-03  +1.83210000E-03  -2.74340000E-04
   -1.98840000E-04  -4.00220000E-04  +1.30245000E-03  +2.57830000E-04  -5.50340000E-04
   +4.38550000E-04  -2.60025000E-03  -2.97507000E-03  +7.18507000E-03  +4.36129000E-03
   +3.52819000E-03  -2.95093000E-03  +2.46240000E-04  +8.70230000E-04  -2.06420000E-04
   -6.02500000E-05  -2.43480000E-04  +2.98580000E-04  +6.41900000E-05  +2.18270000E-04
   -2.12988400E-02  -1.00650300E-02  +2.51879600E-02  +2.32000000E-05  +2.55550000E-04
   +1.01400000E-04  -1.53400000E-05  -4.72700000E-05  +9.16900000E-05  +3.20500000E-05
   -1.26500000E-04  +3.56600000E-05  -1.01910000E-04  +1.75740000E-04  -5.97900000E-05
   +2.44000000E-05  +2.65100000E-05  -2.91400000E-05  +1.06410000E-04  -1.76400000E-05
   -2.79400000E-05  +1.81000000E-04  -1.95070000E-04  +6.55000000E-06  +1.33450000E-04
   -8.33000000E-06  -8.46300000E-05  +9.54364000E-02  +3.95600000E-04  +7.66680000E-04
   +1.83343000E-03  -1.02091000E-03  -1.92730000E-04  +5.78540000E-04  +2.72112000E-03
   +3.53570000E-04  -5.59530000E-04  -6.78870000E-04  -4.79872000E-03  -2.96155000E-03
   +8.29918000E-03  +5.40595000E-03  +5.02588000E-03  -3.89715000E-03  +1.20911000E-03
   +4.53840000E-04  -2.92590000E-04  +1.72360000E-04  -3.97690000E-04  +3.97240000E-04
   +6.84800000E-05  +2.72690000E-04  -3.54119200E-02  -8.88933000E-03  +2.78492500E-02
   +4.88000000E-05  +2.22970000E-04  +9.96900000E-05  -4.94800000E-05  -1.58500000E-05
   +9.13200000E-05  +5.42800000E-05  -1.43390000E-04  +3.53300000E-05  -1.77110000E-04
   +2.22270000E-04  -4.86700000E-05  +5.79600000E-05  +4.64100000E-05  -2.73700000E-05
   +6.15700000E-05  -1.43400000E-05  +4.62200000E-05  +2.53050000E-04  -2.26940000E-04
   +2.06000000E-06  +1.37100000E-04  -3.02500000E-05  -8.84500000E-05  +1.85851850E-01
   +3.97670200E-01  -3.50158000E-03  -5.63145000E-03  -7.18444000E-03  +2.11262000E-03
   +1.80341000E-03  +1.10324000E-03  -6.08925000E-03  -2.83790000E-04  +2.78315000E-03
   +7.64650000E-04  +8.19980000E-03  +1.07353100E-02  -2.70341200E-02  -2.00793100E-02
   -1.13761600E-02  +1.33906100E-02  -9.78370000E-04  -3.83049000E-03  +9.38470000E-04
   -3.51600000E-05  +1.32600000E-03  -1.40798000E-03  -2.36840000E-04  -9.87600000E-04
   +6.64404000E-02  +3.44390000E-02  -4.63331000E-02  -2.34290000E-04  -1.06088000E-03
   -3.67400000E-04  +1.91770000E-04  +1.17950000E-04  -4.29740000E-04  -2.30460000E-04
   +6.57470000E-04  -1.77070000E-04  +8.01200000E-04  -1.04213000E-03  +2.36780000E-04
   -2.38190000E-04  -1.88450000E-04  +1.71130000E-04  -2.76130000E-04  +4.28500000E-05
   -1.19140000E-04  -1.14944000E-03  +1.09179000E-03  -4.64000000E-06  -6.21400000E-04
   +6.83100000E-05  +2.97890000E-04  +6.12400700E-02  +1.41432420E-01  +8.02286600E-02
   -2.73100000E-05  +1.58970000E-04  +1.51990000E-04  -2.14920000E-04  +1.37550000E-04
   -1.39040000E-04  +6.27100000E-05  +2.06900000E-05  -5.76100000E-05  +1.48800000E-05
   -6.66800000E-05  -4.65800000E-05  +1.20010000E-04  +6.64500000E-05  +5.59500000E-05
   -6.85300000E-05  +9.99000000E-06  -3.23900000E-05  +1.35340000E-04  -1.51646000E-03
   -1.52118000E-03  -1.34751000E-03  +8.27560000E-04  +6.79710000E-04  -1.53640000E-04
   -8.68900000E-05  +6.61300000E-05  +3.53833000E-03  -2.01211000E-02  +1.41027700E-02
   -5.83467200E-02  -1.96889100E-02  +2.57895100E-02  +5.62307000E-03  +1.91884600E-02
   -1.41445500E-02  -1.36139000E-03  +4.52694000E-03  +2.55500000E-03  -1.28487000E-03
   +2.84850000E-04  -1.41540000E-04  -2.88965000E-03  +9.75110000E-04  +5.41383000E-03
   -7.61700000E-05  +1.16186000E-03  -7.26600000E-04  +3.37440000E-04  -3.19600000E-05
   -8.02600000E-05  -2.54500000E-05  -1.92800000E-05  +1.04000000E-04  +5.74808200E-02
   -1.48180000E-04  +2.17200000E-05  +6.77600000E-05  -1.59440000E-04  +3.65380000E-04
   +2.76940000E-04  -1.15130000E-04  -7.47300000E-05  -8.31500000E-05  -4.49000000E-06
   +8.71000000E-06  +3.14300000E-05  -8.18800000E-05  -1.88100000E-05  +4.29000000E-06
   +8.24100000E-05  -1.17700000E-05  -6.32800000E-05  -6.20130000E-04  -1.79784000E-03
   -1.16001000E-03  +2.60585000E-03  -9.96980000E-04  -3.06910000E-04  +8.71400000E-05
   +4.61100000E-05  -5.84200000E-05  -2.16340000E-04  +8.78720000E-04  +2.54748000E-03
   -2.00106500E-02  -2.31466570E-01  +1.42667570E-01  -3.76117000E-03  -1.32685200E-02
   +1.35504800E-02  +4.79434000E-03  +9.95580000E-04  +1.40848000E-03  +1.42040000E-04
   +1.31000000E-05  -9.17210000E-04  +8.03280000E-04  +2.76431000E-03  +2.29632000E-03
   +2.24810000E-04  -1.19679000E-03  +7.01060000E-04  +2.73390000E-04  -2.31830000E-04
   -5.68300000E-05  +9.81000000E-06  +1.56000000E-05  -6.18300000E-05  +1.54930600E-02
   +2.46264940E-01  -7.25600000E-05  -1.29900000E-05  +7.22600000E-05  -2.43240000E-04
   +2.36490000E-04  +1.93220000E-04  -1.05480000E-04  -7.46400000E-05  -4.36300000E-05
   +1.01900000E-05  +7.68000000E-06  +3.15800000E-05  -8.02500000E-05  -1.71100000E-05
   -1.60100000E-05  +4.57000000E-05  -2.25800000E-05  -2.67100000E-05  -2.26836000E-03
   -4.36430000E-04  -2.27303000E-03  -4.83750000E-04  +9.18430000E-04  +5.61790000E-04
   +7.82100000E-05  +3.62400000E-05  -4.57600000E-05  +4.92750000E-04  +1.50921600E-02
   -6.08701000E-03  +2.62666100E-02  +1.42711340E-01  -1.50666390E-01  +1.19479000E-03
   -7.51090000E-04  +3.24624000E-03  +2.35282000E-03  +1.56428000E-03  +5.01360000E-03
   -4.29300000E-05  -1.00316000E-03  -5.23970000E-04  +5.48575000E-03  +2.02090000E-03
   +2.10302000E-03  -9.31700000E-05  +1.07650000E-04  +1.33200000E-05  +6.82990000E-04
   -3.28450000E-04  +1.04200000E-05  +1.91600000E-05  +8.78000000E-06  -5.07200000E-05
   -2.99819000E-02  -1.57818420E-01  +1.51298560E-01  -7.31000000E-05  -5.87000000E-05
   -4.73800000E-05  +8.43400000E-05  +2.63780000E-04  +9.74500000E-05  -1.42690000E-04
   -7.20300000E-05  -3.03800000E-05  +1.04500000E-05  +5.89700000E-05  +8.02300000E-05
   -1.21700000E-04  -8.24600000E-05  -4.92700000E-05  +7.25400000E-05  -7.05000000E-06
   -2.09000000E-05  -2.22420000E-04  -6.10000000E-04  +7.60810000E-04  -7.02200000E-05
   -8.22800000E-05  +2.08400000E-05  +1.65760000E-04  +9.87000000E-05  -9.70700000E-05
   -1.61330000E-04  +5.13809000E-03  +9.59020000E-04  -1.43463500E-02  -5.45849000E-03
   +1.39644200E-02  -2.28799550E-01  -2.25252100E-02  +1.38310080E-01  -1.87345000E-03
   +4.14517000E-03  +1.07912000E-03  +2.68183000E-03  +5.30910000E-04  +1.56380000E-03
   +5.34000000E-06  +2.26550000E-04  -8.13110000E-04  +2.01576000E-03  -1.70741000E-03
   -2.71139000E-03  -2.17450000E-04  +1.37680000E-04  -9.25300000E-05  +1.97200000E-05
   +2.80300000E-05  -1.26860000E-04  -2.08470000E-04  -9.51820000E-04  -1.84946000E-03
   +2.41518630E-01  +3.61900000E-05  +3.33500000E-05  +6.40600000E-05  +1.21170000E-04
   -3.07380000E-04  -7.56200000E-05  +7.54400000E-05  +3.71600000E-05  +2.39700000E-05
   +1.37000000E-05  -6.38000000E-06  -5.45900000E-05  +9.35700000E-05  +4.27100000E-05
   +1.72400000E-05  -6.95300000E-05  +6.83000000E-06  +9.72000000E-06  +6.56160000E-04
   +5.64680000E-04  -3.90880000E-04  -3.87900000E-05  +7.40600000E-05  -5.45000000E-05
   -1.07750000E-04  -6.69200000E-05  +5.19200000E-05  +4.52736000E-03  -1.01489000E-03
   +2.28976000E-03  +1.77409800E-02  +6.65448000E-03  -1.42122200E-02  -2.26211700E-02
   -5.82736700E-02  +3.15712600E-02  -2.04733500E-02  +1.66471000E-03  +1.46059100E-02
   +1.04112000E-03  -2.67047000E-03  +4.94835000E-03  +5.02230000E-04  -1.48764000E-03
   +3.11000000E-06  -2.31284000E-03  +1.24772000E-03  -2.15709000E-03  +9.11800000E-05
   -4.89000000E-06  +7.42000000E-05  -1.63500000E-05  -1.64800000E-05  +7.40100000E-05
   -1.35503000E-03  -3.44710000E-04  -1.72387000E-03  +2.20707300E-02  +5.48219800E-02
   +2.16600000E-05  +3.02200000E-05  +6.18900000E-05  +9.98700000E-05  -1.33390000E-04
   -1.68000000E-05  +3.84400000E-05  -2.64000000E-06  +1.51300000E-05  +7.81000000E-06
   -1.86900000E-05  -4.11700000E-05  +8.59000000E-05  +4.31000000E-05  +1.92500000E-05
   -6.97300000E-05  -6.34000000E-06  +2.69000000E-06  +9.98000000E-06  +2.14520000E-04
   +2.81160000E-04  +1.03300000E-05  -4.03100000E-05  -5.44500000E-05  -1.07570000E-04
   -6.75500000E-05  +4.73000000E-05  +1.13884000E-03  +1.97230000E-03  +4.72324000E-03
   -1.52069000E-03  +3.43640000E-04  +2.80657000E-03  +1.38433230E-01  +3.15660800E-02
   -1.40686240E-01  +1.75952500E-02  -9.42060000E-04  -6.17122000E-03  +1.20225000E-03
   +5.31467000E-03  +1.40877000E-03  -1.05650000E-03  +2.12850000E-04  -5.25440000E-04
   -2.31150000E-03  -2.51152000E-03  -9.84250000E-04  -2.00000000E-06  +7.96700000E-05
   +6.40000000E-06  -9.59000000E-06  -1.77700000E-05  +7.19900000E-05  -1.59206000E-03
   -1.97683000E-03  -1.84045000E-03  -1.52146870E-01  -3.54423500E-02  +1.42133600E-01
   -3.31900000E-05  -3.33700000E-05  -1.94200000E-05  +1.29870000E-04  +3.99200000E-05
   +1.51200000E-05  -3.70800000E-05  -1.87200000E-05  +2.62000000E-06  -8.78000000E-06
   +7.19000000E-06  +2.98400000E-05  -7.83000000E-05  -3.17700000E-05  -1.40300000E-05
   +3.83400000E-05  -2.80300000E-05  -5.28000000E-06  +5.82670000E-04  +6.86860000E-04
   -6.35870000E-04  -3.08660000E-04  +1.35080000E-04  +7.40400000E-05  +7.85900000E-05
   +3.23300000E-05  -3.56500000E-05  -1.34231000E-03  +4.71117000E-03  +2.62503000E-03
   -1.48130000E-03  +4.36650000E-04  +1.42100000E-05  -2.95449000E-03  +9.84870000E-04
   +4.55250000E-03  +3.58598000E-03  -2.16255900E-02  +1.51803700E-02  -5.71820900E-02
   -1.36882300E-02  +2.21587600E-02  +6.34738000E-03  +1.86840200E-02  -1.44664600E-02
   +9.51230000E-04  -7.13200000E-04  -2.18040000E-03  +2.32000000E-05  -6.37200000E-05
   -1.04910000E-04  +3.59700000E-05  +6.00000000E-07  -4.97200000E-05  -8.68600000E-05
   -1.64410000E-04  -2.89560000E-04  -8.68100000E-05  -1.11243000E-03  +7.69600000E-04
   +5.19546600E-02  +1.16300000E-05  +7.21400000E-05  +4.40100000E-05  -2.25730000E-04
   -1.11750000E-04  -3.82900000E-05  +8.13900000E-05  +4.07600000E-05  -1.40300000E-05
   -2.47000000E-06  -3.98300000E-05  -6.40400000E-05  +9.78800000E-05  +6.42900000E-05
   +4.44700000E-05  -4.78600000E-05  +5.91000000E-06  +1.66700000E-05  -3.68180000E-04
   -2.75310000E-04  +7.52360000E-04  +2.90110000E-04  -1.92310000E-04  -1.13210000E-04
   -1.28910000E-04  -7.34000000E-05  +5.24800000E-05  +4.89744000E-03  +9.71000000E-04
   +1.49074000E-03  +7.72400000E-05  +1.35010000E-04  -7.67480000E-04  +5.64930000E-04
   +2.22010000E-03  +1.74220000E-03  +2.71807000E-03  -3.94100000E-04  +1.95160000E-03
   -1.49481400E-02  -2.39241870E-01  +1.43527300E-01  -4.01152000E-03  -1.23244300E-02
   +1.25458800E-02  -1.03301000E-03  -5.29500000E-05  -1.54441000E-03  +5.53600000E-05
   -2.35500000E-05  +4.07100000E-05  -2.17400000E-05  -1.75400000E-05  +7.86400000E-05
   -1.94700000E-04  -2.31770000E-04  -2.04920000E-04  -1.31000000E-06  -5.27000000E-06
   -4.88500000E-05  +1.32636700E-02  +2.50186260E-01  -5.25700000E-05  +3.46000000E-06
   -1.86900000E-05  -8.01900000E-05  +2.04300000E-05  +2.53000000E-06  +6.10000000E-06
   +1.46100000E-05  -3.38300000E-05  -5.57000000E-06  -7.50000000E-07  -1.71000000E-06
   -6.27200000E-05  -1.38700000E-05  +1.37700000E-05  +4.81700000E-05  -1.87700000E-05
   +6.47000000E-06  +3.23940000E-04  +5.20200000E-05  +2.07970000E-04  -3.55900000E-05
   -6.47300000E-05  -6.96000000E-06  +5.21800000E-05  +1.99300000E-05  -3.87300000E-05
   +2.34957000E-03  +1.93932000E-03  +5.16022000E-03  +1.62640000E-04  -9.83560000E-04
   -4.04030000E-04  +4.86240000E-03  +1.43496000E-03  +1.41734000E-03  -6.94110000E-04
   +1.70555600E-02  -5.74123000E-03  +2.28154800E-02  +1.42622400E-01  -1.44109450E-01
   +5.20790000E-04  -1.66873000E-03  +3.68360000E-03  -2.06402000E-03  -1.67844000E-03
   -9.57600000E-04  -1.29200000E-05  -7.55000000E-06  -6.38200000E-05  +1.88300000E-05
   +2.06000000E-06  -4.70900000E-05  -2.73620000E-04  -2.30830000E-04  -4.05450000E-04
   +5.91000000E-06  +6.43840000E-04  -5.12690000E-04  -2.54589200E-02  -1.56908700E-01
   +1.44258650E-01  -2.10840000E-04  +2.65300000E-04  -1.69780000E-04  -3.84690000E-04
   +6.13330000E-04  -4.53790000E-04  +3.91300000E-05  +1.08700000E-04  -9.10600000E-05
   -1.43130000E-04  -1.50890000E-04  -1.02760000E-04  -3.48000000E-05  +7.26600000E-05
   +1.38070000E-04  +1.51040000E-04  +3.37200000E-05  +2.24100000E-05  -8.93560000E-04
   -7.79300000E-05  -1.04783000E-03  -3.01000000E-06  -1.16200000E-04  -9.02100000E-05
   -1.01850000E-04  -6.96000000E-05  +6.08800000E-05  +1.27723000E-03  +4.91900000E-04
   +1.32855000E-03  +2.42318000E-03  +7.68710000E-04  +1.69711000E-03  +1.28500000E-05
   +2.67170000E-04  -8.74440000E-04  +6.74540000E-04  +4.82482000E-03  +1.41612000E-03
   -1.39460500E-02  -4.58187000E-03  +1.42376200E-02  -2.36691430E-01  -2.67529200E-02
   +1.35767950E-01  -1.12200000E-03  -1.50730000E-04  +7.71360000E-04  -2.55700000E-05
   +6.20600000E-05  +1.85260000E-04  -1.31300000E-05  -1.94800000E-05  +9.18700000E-05
   +2.32400000E-05  +1.20330000E-04  -7.59000000E-06  -2.01730000E-04  -1.66690000E-04
   -1.78380000E-04  -2.11470000E-04  -1.03507000E-03  -1.98830000E-03  +2.49076710E-01
   +1.67810000E-04  +1.22680000E-04  +2.66900000E-04  +5.40820000E-04  -1.94590000E-04
   +2.02890000E-04  -1.12460000E-04  -4.74700000E-05  +4.53200000E-05  +1.96970000E-04
   +2.25140000E-04  +1.50660000E-04  -1.23830000E-04  -2.20180000E-04  -2.27230000E-04
   -1.19970000E-04  -2.03570000E-04  -1.34500000E-05  -1.33156000E-03  -1.64950000E-04
   -9.70560000E-04  -9.05500000E-05  +5.30700000E-05  -1.08450000E-04  +2.64550000E-04
   +1.51940000E-04  -1.86450000E-04  -2.11984600E-02  +2.21002000E-03  +1.41138900E-02
   +1.30012000E-03  -2.72070000E-03  +5.16324000E-03  +3.38540000E-04  -1.05425000E-03
   -2.17830000E-04  +4.65784000E-03  -7.80460000E-04  +3.19619000E-03  +1.90985300E-02
   +6.70276000E-03  -1.31041600E-02  -2.72511300E-02  -6.12256700E-02  +3.00802500E-02
   +8.81610000E-04  +3.24680000E-04  -7.65180000E-04  +1.46300000E-05  -6.62610000E-04
   +3.21640000E-04  +8.34300000E-05  +3.62800000E-05  -2.30800000E-04  -1.15293000E-03
   -6.78100000E-05  +7.80790000E-04  -2.06380000E-04  -9.90900000E-05  -2.72320000E-04
   -1.54735000E-03  -5.02620000E-04  -1.88526000E-03  +2.52512200E-02  +5.89745600E-02
   +1.96250000E-04  -1.07240000E-04  +3.88300000E-05  -3.40320000E-04  +4.15270000E-04
   +1.30370000E-04  -1.45110000E-04  -1.90740000E-04  +1.37230000E-04  -1.07550000E-04
   -1.60190000E-04  -1.49610000E-04  +4.08750000E-04  +3.01510000E-04  +1.30500000E-04
   -3.83720000E-04  -1.34490000E-04  +6.65700000E-05  -2.74350000E-04  -1.73195000E-03
   -1.73446000E-03  -1.98950000E-04  +1.00200000E-05  -4.82100000E-05  -5.88640000E-04
   -3.64360000E-04  +2.66540000E-04  +1.55731400E-02  +1.39025000E-03  -6.00301000E-03
   +1.69495000E-03  +5.58543000E-03  +1.63107000E-03  -1.01975000E-03  -1.14900000E-04
   -4.32500000E-04  +1.63627000E-03  +3.02225000E-03  +5.57107000E-03  -8.99430000E-04
   +1.28331000E-03  +4.14293000E-03  +1.34981640E-01  +2.92880100E-02  -1.40377510E-01
   +2.23010000E-04  -1.85060000E-04  -1.04300000E-05  +1.73400000E-05  -1.13470000E-04
   -1.65000000E-05  -6.35900000E-05  -1.00170000E-04  +3.75350000E-04  +8.11750000E-04
   -5.70000000E-06  -4.75870000E-04  -1.73920000E-04  -2.96700000E-04  -4.09060000E-04
   -1.79988000E-03  -2.19984000E-03  -2.31635000E-03  -1.49958260E-01  -3.54780400E-02
   +1.40312040E-01  -3.45403000E-03  -6.05060000E-04  +4.24149000E-03  +7.81928000E-03
   +1.43190900E-02  +1.90292400E-02  -5.87944000E-02  -1.61376600E-02  -1.31624600E-02
   +1.28545000E-03  -1.72900700E-02  -2.32881900E-02  -3.71134000E-03  -3.56930000E-03
   +9.24760000E-04  -1.21646000E-03  -5.71500000E-05  -2.37900000E-05  +6.20930000E-04
   +1.12110000E-03  -5.95910000E-04  +1.77260000E-04  -7.85000000E-05  -8.99700000E-05
   -3.50420000E-04  -9.44600000E-04  -1.37806000E-03  -1.19550000E-04  +2.69400000E-05
   -2.27870000E-04  -3.23000000E-06  -4.05200000E-05  -3.28900000E-05  +3.65800000E-05
   -3.65400000E-05  +2.14500000E-05  -4.86300000E-05  +7.05200000E-05  +2.23000000E-06
   +1.44000000E-05  +1.37000000E-06  -4.96100000E-05  -4.71900000E-05  -9.93700000E-05
   +3.74800000E-05  +8.08000000E-05  -7.97400000E-05  -8.68000000E-06  -1.87397000E-03
   -5.06450000E-04  +4.69730000E-04  +5.40000000E-05  +3.77300000E-05  -9.20700000E-05
   -6.09000000E-06  +1.35900000E-05  +6.90000000E-06  +1.72400000E-05  -4.00000000E-08
   +2.13000000E-06  +5.08000000E-06  -2.83000000E-06  +8.27000000E-06  +5.98100000E-05
   +6.15100000E-05  +2.46100000E-05  +6.09869100E-02  -5.49580000E-04  +4.42210000E-03
   -2.86936000E-03  -3.90730000E-04  +1.57401000E-03  -3.69906000E-03  -1.63489400E-02
   -1.42352820E-01  -1.42342590E-01  +1.67780000E-04  -3.94375000E-03  -1.16452000E-02
   -4.41625000E-03  +4.67671000E-03  -2.83969000E-03  +2.01870000E-04  -5.34370000E-04
   +8.30730000E-04  +4.55350000E-04  -2.77852000E-03  +1.32203000E-03  -6.28210000E-04
   -1.72100000E-04  -3.57600000E-05  +5.29820000E-04  -5.03500000E-04  -8.62320000E-04
   +3.79060000E-04  +3.33550000E-04  -1.45640000E-04  +6.36000000E-05  -1.13920000E-04
   +7.42600000E-05  -5.30000000E-06  -2.32300000E-05  -7.51000000E-06  +2.08400000E-05
   +2.67300000E-05  -2.33600000E-05  -3.37600000E-05  -3.16600000E-05  +6.08600000E-05
   +1.48290000E-04  +8.97000000E-05  -1.34320000E-04  -1.10000000E-06  -1.64300000E-05
   +1.42300000E-05  -1.75338000E-03  +1.92400000E-04  -6.97300000E-05  +3.49800000E-05
   +1.40020000E-04  -2.02350000E-04  -1.00200000E-05  -3.06000000E-06  +7.85000000E-06
   +4.54000000E-06  -1.10900000E-05  -9.20000000E-07  +6.75000000E-06  -1.25800000E-05
   -8.21000000E-06  -1.82000000E-06  -8.67400000E-05  -1.53900000E-05  +2.26049000E-02
   +1.43582520E-01  +4.34339000E-03  -2.64165000E-03  +4.90470000E-04  -2.90145000E-03
   -1.14171400E-02  -1.09596200E-02  -1.25461400E-02  -1.42679180E-01  -2.40274320E-01
   +1.14732000E-03  -2.91629000E-03  -7.87000000E-04  +1.36110000E-04  -2.90245000E-03
   +3.73068000E-03  +5.11980000E-04  +9.35780000E-04  +3.20000000E-07  -1.80395000E-03
   +7.86320000E-04  -1.62736000E-03  +5.56290000E-04  +5.17200000E-05  +5.99700000E-05
   +2.25720000E-04  +2.06490000E-04  -3.59180000E-04  -2.04330000E-04  -6.91400000E-05
   +8.97900000E-05  -2.26600000E-05  +6.00900000E-05  -1.46600000E-05  -7.00000000E-07
   +3.06700000E-05  +5.30000000E-07  +1.71800000E-05  -4.09800000E-05  -1.26000000E-06
   -1.23900000E-05  +1.27200000E-05  +1.31200000E-05  -1.50000000E-05  -6.80000000E-06
   +5.70600000E-05  -4.31900000E-05  +5.08900000E-05  +1.43000000E-06  -1.23445000E-03
   -8.86190000E-04  +3.19420000E-04  +1.07630000E-04  +2.37600000E-05  -3.36590000E-04
   +3.10000000E-06  -7.15000000E-06  -1.48700000E-05  -8.78000000E-06  +2.53000000E-06
   -7.90000000E-07  -5.76000000E-06  +4.86000000E-06  -3.95000000E-06  +1.03200000E-05
   -2.67500000E-05  -2.35700000E-05  +1.46674200E-02  +1.58728320E-01  +2.50186860E-01
   +8.26000000E-06  -1.09740000E-04  -7.43580000E-04  -2.53495000E-03  -4.54994000E-03
   -1.12624000E-03  -1.54450500E-02  +5.24327000E-03  +1.81641600E-02  -2.25921380E-01
   +2.53450900E-02  +1.39303050E-01  +5.21040000E-03  -2.17314000E-03  -3.14746000E-03
   +1.24592000E-03  -1.82134000E-03  -1.00650000E-04  -2.87010000E-04  +6.20060000E-04
   +8.22240000E-04  -1.45500000E-04  -9.99000000E-06  -9.44700000E-05  +4.21160000E-04
   +1.37242000E-03  -3.36000000E-04  -1.02070000E-04  -2.63260000E-04  +1.74900000E-05
   -4.68900000E-05  +8.76800000E-05  -2.77000000E-05  -8.11000000E-06  +2.20300000E-05
   +1.25300000E-05  +4.06900000E-05  -4.12300000E-05  +1.56000000E-06  -2.28400000E-05
   +1.80400000E-05  +7.23000000E-06  -2.38600000E-05  -4.70000000E-06  +3.15100000E-05
   -5.51100000E-05  +5.41600000E-05  -3.69000000E-06  +6.83000000E-06  +8.25800000E-05
   +6.64400000E-05  -4.89750000E-04  -6.92730000E-04  +1.34310000E-04  +6.11000000E-06
   -1.09300000E-05  -8.40000000E-06  -1.18000000E-05  +8.76000000E-06  +2.76000000E-06
   -8.67000000E-06  +9.42000000E-06  -1.40000000E-06  +2.06000000E-06  -1.50000000E-05
   +9.90000000E-07  +4.25310000E-04  +1.15603000E-03  -1.02742000E-03  +2.37225470E-01
   -8.01110000E-04  -1.70441000E-03  -4.69370000E-04  -3.82713000E-03  +3.70108000E-03
   -3.25107000E-03  -1.16832600E-02  +6.03213000E-03  +9.51817000E-03  +2.44743100E-02
   -4.93767100E-02  -3.35753400E-02  +1.23840400E-02  +7.98960000E-04  -1.29065000E-02
   -7.57040000E-04  +8.96440000E-04  -5.57604000E-03  -1.84890000E-04  +2.12150000E-04
   +5.28410000E-04  -2.28180000E-04  +2.40300000E-05  -1.42050000E-04  +5.10903000E-03
   +1.47380000E-04  +1.58859000E-03  -2.12930000E-04  -2.37800000E-04  -5.26200000E-05
   +2.08900000E-05  +1.59900000E-05  -5.97100000E-05  -3.66200000E-05  +1.05800000E-04
   -9.53000000E-06  +8.71700000E-05  -1.36160000E-04  +4.08500000E-05  -1.13200000E-05
   -2.59200000E-05  +2.50500000E-05  -2.59500000E-05  +1.50700000E-05  -5.46700000E-05
   -1.44920000E-04  +1.33660000E-04  -1.47000000E-06  +2.31000000E-06  +1.67900000E-05
   +1.00670000E-04  -3.21500000E-05  +6.63470000E-04  -7.69610000E-04  +6.63000000E-06
   -1.38700000E-05  -5.94000000E-06  -1.76600000E-05  +1.17500000E-05  +1.16500000E-05
   -7.90000000E-07  +7.61000000E-06  -5.85000000E-06  +3.59000000E-06  -1.17600000E-05
   +3.70700000E-05  +1.36193000E-03  -2.54209000E-03  +2.21148000E-03  -2.43584200E-02
   +4.28707500E-02  -1.07482000E-03  -7.65100000E-05  -6.24260000E-04  -8.57390000E-04
   -3.36511000E-03  +2.67167000E-03  -6.96150000E-03  +5.64460000E-04  +8.13387000E-03
   +1.39452180E-01  -3.59053400E-02  -1.64073520E-01  +2.26314900E-02  -1.70189000E-03
   -9.89137000E-03  -6.06510000E-04  -5.28915000E-03  -1.86376000E-03  -2.56860000E-04
   +8.70100000E-05  +3.12200000E-04  -3.06200000E-05  -4.38600000E-05  -4.55500000E-05
   -7.86100000E-04  +3.39227000E-03  +1.06792000E-03  +3.95500000E-05  -5.86100000E-05
   +3.60000000E-07  -1.43100000E-05  +2.77200000E-05  +3.31000000E-06  +1.62000000E-06
   -2.80000000E-07  +3.95000000E-06  +5.60000000E-06  -2.34000000E-06  -3.56000000E-06
   -1.12500000E-05  +1.11000000E-05  -1.66000000E-06  -9.96000000E-06  -4.13000000E-06
   +2.02000000E-05  -5.27000000E-06  +8.61000000E-06  -9.40000000E-07  +1.08800000E-05
   +5.71300000E-05  -1.08800000E-05  +5.56730000E-04  +1.57820000E-04  -7.17770000E-04
   +2.61000000E-06  -3.25000000E-06  -4.57000000E-06  -2.81000000E-06  +7.90000000E-07
   -1.51000000E-06  -4.62000000E-06  +3.61000000E-06  -6.60000000E-07  +7.00000000E-08
   -5.01000000E-06  -6.70000000E-07  -5.61790000E-04  +2.35882000E-03  -6.68700000E-04
   -1.51381990E-01  +4.11208700E-02  +1.66552180E-01  +2.49634000E-03  -1.66974100E-02
   -2.25307300E-02  -3.76628000E-03  -3.82915000E-03  +7.61540000E-04  -1.40969000E-03
   -7.41900000E-05  +8.07000000E-05  -3.46844000E-03  -4.46130000E-04  +3.71075000E-03
   +6.55801000E-03  +1.49025500E-02  +1.98317000E-02  -6.02441600E-02  -2.16372100E-02
   -1.84849700E-02  +4.83010000E-04  -5.51120000E-04  -1.07394000E-03  +4.36800000E-05
   +9.40200000E-05  -8.52400000E-05  +2.15132000E-03  +1.17636000E-03  -1.67263000E-03
   +1.17620000E-04  -8.29600000E-05  -2.70000000E-07  +8.32000000E-06  +2.16900000E-05
   -7.35000000E-06  -1.71800000E-05  +4.77300000E-05  +9.21000000E-06  +1.66700000E-05
   -3.96800000E-05  +7.19000000E-06  -8.96000000E-06  +2.59300000E-05  +1.90700000E-05
   -4.84000000E-06  +7.94000000E-06  +1.71600000E-05  -4.49300000E-05  +5.78600000E-05
   +1.13400000E-05  -4.08640000E-04  -1.07120000E-04  +6.80600000E-05  -3.35000000E-06
   +3.52500000E-05  -1.70160000E-04  +2.71000000E-06  -1.15100000E-05  -8.57000000E-06
   -1.53200000E-05  +4.20000000E-07  -3.61000000E-06  -1.15000000E-05  +4.18000000E-06
   -1.38000000E-05  +9.00000000E-08  -2.39500000E-05  -3.30000000E-07  +1.67100000E-05
   +1.52810000E-04  -1.74270000E-04  +2.67130000E-04  +7.31180000E-04  +1.05366000E-03
   +5.68011400E-02  +6.94070000E-04  -3.75052000E-03  -1.10781600E-02  -3.94391000E-03
   +4.55735000E-03  -2.76389000E-03  +2.62400000E-05  -3.99130000E-04  +8.53620000E-04
   -1.99070000E-04  +3.47274000E-03  -1.97074000E-03  -2.29536000E-03  +1.30684000E-03
   -3.96391000E-03  -2.14381100E-02  -1.50479810E-01  -1.46707480E-01  +1.96310000E-04
   -3.30900000E-05  -4.97990000E-04  -9.50300000E-05  -5.18800000E-05  -1.61900000E-05
   +7.11780000E-04  -2.01849000E-03  +1.71202000E-03  +2.02350000E-04  -1.18050000E-04
   +2.36800000E-05  -3.56800000E-05  +3.89600000E-05  +3.55400000E-05  -5.49000000E-06
   -1.40300000E-05  +1.84300000E-05  +3.02700000E-05  +8.80000000E-07  -2.04400000E-05
   -2.25600000E-05  -2.56000000E-06  -3.69000000E-06  +3.97300000E-05  +4.55300000E-05
   +7.90000000E-07  -2.18700000E-05  +1.07400000E-05  +4.08000000E-06  -2.01020000E-04
   -1.44140000E-04  +4.80400000E-05  +6.61700000E-05  +1.82300000E-05  +2.46000000E-06
   -3.56000000E-06  -1.20300000E-05  -5.14000000E-06  -8.62000000E-06  +1.84000000E-06
   +4.20000000E-07  +3.39000000E-06  +9.50000000E-07  +5.41000000E-06  -1.56000000E-06
   -5.82000000E-06  +1.89900000E-05  +1.63320000E-04  -4.74420000E-04  +2.55030000E-04
   -1.07210000E-04  +6.67700000E-05  -1.38420000E-04  +2.51526000E-02  +1.50850010E-01
   +1.15458000E-03  -1.70719000E-03  +5.56550000E-04  +3.28960000E-04  -2.97156000E-03
   +3.81626000E-03  +5.88980000E-04  +8.86150000E-04  +2.89900000E-05  +4.20319000E-03
   -2.18362000E-03  -1.42040000E-04  -5.34590000E-03  -1.32716300E-02  -1.07710600E-02
   -1.67037700E-02  -1.46636220E-01  -2.30820720E-01  +3.07880000E-04  -1.35380000E-04
   -1.37150000E-04  +4.10500000E-05  +4.92100000E-05  -2.97700000E-05  -2.42496000E-03
   +1.87115000E-03  +9.42620000E-04  -7.21600000E-05  +8.84000000E-06  -5.35000000E-06
   +2.54400000E-05  -5.67000000E-06  -3.99200000E-05  -3.44000000E-06  +3.18500000E-05
   -1.26400000E-05  -6.76000000E-06  -2.72100000E-05  +2.30300000E-05  +8.09000000E-06
   +2.11400000E-05  +1.91300000E-05  -2.26900000E-05  -2.74800000E-05  +1.38400000E-05
   -1.86900000E-05  +3.30600000E-05  +8.00000000E-07  -8.12700000E-05  +3.13200000E-05
   +2.91500000E-05  -1.76010000E-04  -1.26140000E-04  +5.02800000E-04  +6.10000000E-06
   +3.38000000E-06  -1.34000000E-06  -2.29000000E-06  +1.72000000E-06  -8.80000000E-07
   -1.27200000E-05  +2.04000000E-06  -1.62900000E-05  +3.38000000E-06  -1.71700000E-05
   -1.88700000E-05  -1.44330000E-04  +2.90680000E-04  -2.46880000E-04  -2.05920000E-04
   -5.34130000E-04  -6.01020000E-04  +1.91605500E-02  +1.61479210E-01  +2.38954090E-01
   -2.26394290E-01  +3.17472800E-02  +1.34958150E-01  +5.81797000E-03  -5.68850000E-04
   -1.95362000E-03  +1.37530000E-03  -1.59129000E-03  -1.70240000E-04  -8.44500000E-05
   -8.79600000E-05  -6.47880000E-04  -1.71066000E-03  -4.66515000E-03  -1.28904000E-03
   -1.68667700E-02  +5.50043000E-03  +1.82510700E-02  -5.14930000E-04  +1.99480000E-04
   -6.23620000E-04  -1.34060000E-04  -2.11900000E-04  +2.35800000E-05  -9.77130000E-04
   +2.91360000E-04  +8.87140000E-04  -7.55350000E-04  -4.95740000E-04  -8.56480000E-04
   -5.89800000E-05  -9.84100000E-05  -1.43050000E-04  -1.30650000E-04  +1.85290000E-04
   +1.68100000E-05  -2.49270000E-04  +3.37700000E-05  +1.68020000E-04  +2.95610000E-04
   -1.44330000E-04  -5.03000000E-05  -3.26570000E-04  -2.04900000E-05  -3.53160000E-04
   +1.28360000E-04  -1.10750000E-04  -1.92100000E-05  +3.12500000E-05  +1.41380000E-04
   -2.29300000E-05  +3.86900000E-05  +3.21300000E-05  -1.76190000E-04  +4.15100000E-05
   -3.02400000E-05  +9.35000000E-06  +1.09800000E-05  +2.34000000E-06  -7.96000000E-06
   +3.36000000E-06  -3.54000000E-06  +9.14000000E-06  +1.69400000E-05  +1.45800000E-05
   +8.10700000E-05  +2.46110000E-04  -1.59880000E-04  -2.09840000E-04  -8.65100000E-05
   +1.40550000E-04  -3.93600000E-05  +5.24610000E-04  +1.03925000E-03  -1.08307000E-03
   +2.39970470E-01  +3.25609800E-02  -5.60101100E-02  -3.80631800E-02  +1.56322100E-02
   +1.73725000E-03  -1.08604600E-02  -2.04891000E-03  +1.48251000E-03  -5.56658000E-03
   -3.68470000E-04  -1.18619000E-03  +6.72000000E-05  -3.61971000E-03  +4.27497000E-03
   -3.93204000E-03  -1.27708200E-02  +6.59941000E-03  +9.16985000E-03  +1.18811000E-03
   -1.49857000E-03  +1.28930000E-03  -1.22560000E-04  -4.35780000E-04  -4.98300000E-04
   -1.35656000E-03  -3.62320000E-04  +7.81420000E-04  -2.72270000E-04  +1.69090000E-04
   -6.13100000E-05  +4.55100000E-05  -6.81100000E-05  -4.66700000E-05  -8.16500000E-05
   +8.42200000E-05  -1.50000000E-06  -1.63420000E-04  -2.33000000E-05  +1.30860000E-04
   +2.10900000E-04  -2.52650000E-04  -1.19710000E-04  -1.15120000E-04  +3.14080000E-04
   -1.85540000E-04  +1.27110000E-04  -1.39600000E-04  -1.41100000E-05  +1.43950000E-04
   -4.87400000E-05  +1.15550000E-04  -7.16600000E-05  -1.52580000E-04  +3.31930000E-04
   -1.00010000E-04  -6.98500000E-05  +3.60000000E-06  +2.45000000E-05  +2.43000000E-06
   +2.60000000E-06  +2.46400000E-05  -1.22700000E-05  +2.31700000E-05  -3.64500000E-05
   +3.40200000E-05  +7.11100000E-05  +8.18240000E-04  -3.28400000E-05  -5.88850000E-04
   +2.16620000E-04  -3.88340000E-04  +3.39940000E-04  +1.46240000E-03  -2.61262000E-03
   +2.33776000E-03  -3.10464300E-02  +4.90346600E-02  +1.34242980E-01  -3.70294300E-02
   -1.56622600E-01  +2.05574400E-02  -3.16890000E-03  -1.03773300E-02  -2.74010000E-04
   -5.80088000E-03  -1.72463000E-03  -1.08316000E-03  +1.12390000E-04  -4.28200000E-04
   -3.59500000E-04  -4.14648000E-03  +3.27332000E-03  -6.23442000E-03  -4.15000000E-06
   +7.52639000E-03  +6.83170000E-04  +1.73561000E-03  -8.01380000E-04  -8.22000000E-06
   -4.18900000E-05  -1.16250000E-04  -3.01320000E-04  -1.78200000E-05  +3.19920000E-04
   -4.24440000E-04  -3.69250000E-04  -3.00700000E-05  -4.25430000E-04  +2.35940000E-04
   +2.97210000E-04  -5.10500000E-05  -1.37920000E-04  +9.43900000E-05  -3.28170000E-04
   +2.28760000E-04  -3.62300000E-05  +8.46400000E-05  +9.12700000E-05  -3.28800000E-05
   +9.96900000E-05  +4.14230000E-04  -1.66010000E-04  +3.47040000E-04  -3.05610000E-04
   -2.88000000E-06  -1.98220000E-04  +6.83900000E-05  -1.75600000E-05  -1.91400000E-05
   +2.98100000E-05  +9.29600000E-05  +4.58000000E-06  +1.26500000E-05  -2.31000000E-05
   +3.26000000E-05  +8.80000000E-07  -1.06000000E-05  +2.60000000E-07  -2.15500000E-05
   -6.04000000E-06  +3.71800000E-05  -8.10500000E-05  -2.28000000E-06  +1.09857000E-03
   -8.80600000E-05  -6.64630000E-04  -5.16700000E-05  +3.59640000E-04  -1.94770000E-04
   -6.73430000E-04  +2.63000000E-03  -1.03020000E-03  -1.46651690E-01  +4.50141000E-02
   +1.60457640E-01  +1.15160000E-04  +1.30470000E-04  +7.14900000E-05  -5.04900000E-05
   -1.02800000E-04  +2.38870000E-04  -1.04057000E-03  -1.01967000E-03  +1.43220000E-04
   +8.37700000E-05  -1.79620000E-04  -2.53260000E-04  -4.94000000E-06  +1.15970000E-04
   +4.42500000E-05  -3.71000000E-05  +2.30200000E-05  +4.24800000E-05  +8.67670000E-04
   -2.09140000E-03  -2.49410000E-04  +2.49030000E-04  -1.63630000E-04  -2.12360000E-04
   -1.24720000E-04  -9.91100000E-05  +3.97500000E-05  +5.92780000E-04  +5.31610000E-04
   +3.87010000E-04  +5.02000000E-04  +1.01940000E-04  -7.18800000E-05  +5.76200000E-05
   +1.28600000E-05  -5.67000000E-05  +2.84850000E-04  -1.51620000E-04  -1.01730000E-04
   -2.86080000E-04  +4.07700000E-05  +3.68900000E-05  +1.97080000E-04  -4.61320000E-04
   +3.67400000E-04  -2.58240000E-04  +2.31950000E-04  +1.96500000E-05  -1.67286090E-01
   +1.31740330E-01  +9.97475000E-03  -1.51400000E-05  -2.63100000E-05  +9.85300000E-05
   -5.97000000E-05  -4.50200000E-05  -7.38000000E-06  -1.91200000E-05  +7.82000000E-06
   +1.10700000E-05  -2.12300000E-05  +6.71000000E-06  -1.64400000E-05  +3.47400000E-05
   +7.91300000E-05  +5.37000000E-06  -1.50143000E-03  -1.71077000E-03  -4.11350000E-04
   +2.29900000E-05  -1.25400000E-05  +2.63900000E-05  +1.34500000E-05  +1.36600000E-05
   -1.40000000E-06  -7.56000000E-06  +4.24000000E-06  -1.19000000E-06  +1.81875460E-01
   -2.71050000E-04  -3.26300000E-05  -1.03710000E-04  +7.10690000E-04  +2.95210000E-04
   +2.76200000E-04  +2.91600000E-04  -3.18410000E-04  -9.82070000E-04  -3.34130000E-04
   +1.88040000E-04  +3.48400000E-04  +1.66400000E-04  +6.25700000E-05  +9.78200000E-05
   +6.50100000E-05  +1.18010000E-04  +1.10400000E-04  +9.99166000E-03  -1.10355700E-02
   +4.76710000E-04  -2.04070000E-04  +5.11030000E-04  +1.39739000E-03  -1.35470000E-04
   -3.09000000E-06  +1.55860000E-04  -1.04120000E-04  -5.31700000E-04  -3.27834000E-03
   -6.51780000E-04  -3.33010000E-04  +2.08890000E-04  +5.27900000E-04  -5.14860000E-04
   +2.99880000E-04  -2.07600000E-05  +5.97260000E-04  -4.30940000E-04  -2.99120000E-04
   +1.88630000E-04  -2.46300000E-05  +3.11580000E-04  -1.38330000E-04  -2.94080000E-04
   +3.96580000E-04  -4.06340000E-04  +3.01000000E-05  +1.30596780E-01  -1.92444110E-01
   -1.11681400E-02  -1.58600000E-05  -9.70000000E-07  +9.76800000E-05  -2.23600000E-05
   +7.70000000E-06  -1.20260000E-04  +9.74000000E-05  -1.98000000E-05  +3.65100000E-05
   +6.57000000E-06  -3.97500000E-05  +7.31000000E-06  +1.07960000E-04  +2.11540000E-04
   +1.44700000E-04  -1.41507000E-03  -7.12820000E-04  +5.63980000E-04  -2.39900000E-05
   -1.23800000E-05  -2.06200000E-05  -1.67000000E-06  -1.02600000E-05  +1.26200000E-05
   +2.35000000E-05  +4.51000000E-05  +1.31240000E-04  -1.43903100E-01  +2.07097070E-01
   -1.86000000E-05  +7.83900000E-05  -2.06470000E-04  +3.13040000E-04  +4.90580000E-04
   +7.71460000E-04  -3.03690000E-04  +2.06250000E-04  +3.12620000E-04  -1.72730000E-04
   -1.57570000E-04  -1.75370000E-04  +1.94000000E-06  +1.17910000E-04  +1.87150000E-04
   +9.29500000E-05  +7.92000000E-05  +3.48700000E-05  +2.04076100E-02  -2.07717600E-02
   -2.45466000E-03  +9.27580000E-04  -1.10791000E-03  +1.37926000E-03  -1.30750000E-04
   -8.30000000E-05  +4.70000000E-05  -1.14445000E-03  -1.61057000E-03  -4.73971000E-03
   +3.85090000E-04  -7.08170000E-04  +1.01100000E-04  +2.53430000E-04  +3.26400000E-05
   +3.91180000E-04  -3.12800000E-04  +2.62030000E-04  -3.18700000E-05  +4.77360000E-04
   +7.21000000E-06  +1.22660000E-04  +1.96800000E-04  +2.82890000E-04  -1.67700000E-05
   +4.52150000E-04  -4.69400000E-04  -2.39000000E-05  +9.66521000E-03  -9.87453000E-03
   -4.90228100E-02  -2.08700000E-05  -2.24300000E-05  +8.67600000E-05  -4.66000000E-05
   -9.19100000E-05  -1.97470000E-04  +8.41500000E-05  -4.21600000E-05  -4.36000000E-06
   +2.96300000E-05  -3.82800000E-05  +1.64000000E-05  -2.79630000E-04  -2.83710000E-04
   -8.58900000E-05  -2.21440000E-04  -1.51740000E-04  +2.90420000E-04  +1.49000000E-06
   -1.71000000E-06  +9.90000000E-06  +1.60000000E-05  -1.54200000E-05  +7.82000000E-06
   +4.35700000E-05  -1.25200000E-05  +5.50700000E-05  -1.09945400E-02  +1.38668600E-02
   +5.23175400E-02  +9.24000000E-06  +3.21600000E-05  +2.08300000E-05  +2.82040000E-04
   +5.12070000E-04  -3.47280000E-04  -3.59700000E-05  -2.24110000E-04  -6.36660000E-04
   -1.20360000E-04  -6.73500000E-05  +1.04990000E-04  +1.45160000E-04  +1.07160000E-04
   +8.69100000E-05  +6.80000000E-07  +7.21300000E-05  +7.66000000E-05  -1.39989000E-03
   +1.62539000E-03  -1.81869000E-03  -1.53800000E-05  -1.62020000E-04  -4.51790000E-04
   -1.76500000E-04  -7.39100000E-05  +1.33700000E-04  +5.32000000E-06  -6.24910000E-04
   +3.54380000E-04  -2.52110000E-04  +1.10160000E-04  +1.14590000E-04  +1.60610000E-04
   -1.46850000E-04  +4.74900000E-05  +3.08800000E-05  +1.66090000E-04  -9.32900000E-05
   -2.99360000E-04  +1.05540000E-04  -6.07400000E-05  -2.34600000E-05  +6.10300000E-05
   -2.89100000E-05  +4.66700000E-05  -5.04300000E-05  -7.60000000E-06  -5.34248000E-02
   -2.64371300E-02  +3.13898200E-02  -1.48800000E-05  -2.23600000E-05  +1.27930000E-04
   +3.52200000E-05  -3.95000000E-06  -6.94900000E-05  +3.00000000E-06  -7.11000000E-06
   -9.07000000E-06  +1.32400000E-05  +1.35500000E-05  +1.67600000E-05  +2.75410000E-04
   +1.27050000E-04  +1.05890000E-04  -1.13280000E-03  +3.81820000E-04  -4.38770000E-04
   -1.08200000E-05  +2.84700000E-05  -2.23600000E-05  +1.28000000E-05  +4.08000000E-06
   +1.02100000E-05  -8.85000000E-06  +3.38300000E-05  +4.62000000E-05  +3.55995000E-03
   +1.35668800E-02  -1.72802900E-02  +5.47241400E-02  +2.72440000E-04  -8.51000000E-06
   +6.66600000E-05  -1.63770000E-04  +6.17470000E-04  +4.69780000E-04  -5.35570000E-04
   +4.62050000E-04  +1.93240000E-04  +1.04400000E-05  -1.77320000E-04  -2.82460000E-04
   +2.87900000E-05  +4.63400000E-05  +1.56160000E-04  +1.43700000E-05  +2.40500000E-05
   -1.12200000E-05  +3.05221000E-03  +9.64329000E-03  -1.17378200E-02  -6.38100000E-05
   -9.11450000E-04  -2.32324000E-03  -1.18950000E-04  -1.02520000E-04  +1.25200000E-05
   -1.29290000E-04  +9.60040000E-04  +2.77000000E-06  +1.04430000E-04  -2.95400000E-05
   +8.69800000E-05  -6.79600000E-05  +1.19760000E-04  -1.04440000E-04  +1.29000000E-05
   -7.82800000E-05  +1.13560000E-04  -5.08500000E-05  -1.16490000E-04  +6.85600000E-05
   +3.94100000E-04  -2.68590000E-04  -6.56420000E-04  -1.23560000E-04  +1.02400000E-04
   +4.70000000E-07  -2.63768200E-02  -1.60435800E-01  +1.30899360E-01  -1.76300000E-05
   -2.88800000E-05  +6.64100000E-05  -1.14300000E-05  -6.58000000E-06  -1.37600000E-05
   -1.54100000E-05  +5.10000000E-07  -1.30000000E-07  -6.30000000E-06  -2.05000000E-06
   -2.45200000E-05  +9.75000000E-06  -8.88610000E-04  -3.87230000E-04  +2.28800000E-05
   -2.35460000E-04  -1.76000000E-04  -3.60000000E-06  +4.61800000E-05  -8.65000000E-06
   +1.63200000E-05  +1.03500000E-05  -4.14000000E-06  +1.13200000E-05  +1.03000000E-06
   -4.07500000E-05  -5.37555000E-03  -1.41156000E-02  +1.67092500E-02  +2.96215300E-02
   +1.72481250E-01  -9.33200000E-05  -5.09200000E-04  -1.26530000E-04  +1.08265000E-03
   +9.24650000E-04  +1.19617000E-03  +1.65300000E-04  -2.59190000E-04  -7.24000000E-06
   -3.45450000E-04  -1.57520000E-04  +1.38170000E-04  -1.03390000E-04  +1.62940000E-04
   +1.81410000E-04  +2.81550000E-04  +1.48210000E-04  +2.72000000E-05  +4.55313000E-03
   +1.91277800E-02  -2.03913900E-02  -2.79370000E-04  -4.30162000E-03  -5.12948000E-03
   +5.17000000E-06  +1.28000000E-05  +3.68800000E-05  -1.39120000E-03  +1.00291000E-03
   +7.60110000E-04  +8.27970000E-04  -1.75780000E-04  -1.82600000E-04  -4.03920000E-04
   +4.62390000E-04  -7.42700000E-05  -2.97840000E-04  -3.42790000E-04  +3.53030000E-04
   +4.62400000E-04  -4.19270000E-04  +2.00920000E-04  +3.36380000E-04  +6.63370000E-04
   -1.18620000E-04  -4.41500000E-05  +2.34700000E-05  -5.78000000E-06  +3.13660700E-02
   +1.28668170E-01  -1.96943120E-01  +1.42900000E-05  -2.88000000E-06  +1.48900000E-05
   -1.48560000E-04  -6.90000000E-06  +6.46900000E-05  -9.98000000E-06  -1.16700000E-05
   -2.36200000E-05  +4.39900000E-05  -9.53000000E-06  +2.78000000E-06  -2.73790000E-04
   -6.74090000E-04  +5.64000000E-05  -5.79800000E-04  +3.16450000E-04  +7.05900000E-05
   -2.32700000E-05  -1.74200000E-05  -1.30400000E-05  -1.35800000E-05  +3.28600000E-05
   -2.75900000E-05  -2.44600000E-05  +1.03520000E-04  +4.20600000E-05  -7.26050000E-04
   -2.38971000E-03  +2.13800000E-03  -3.39249000E-02  -1.40370160E-01  +2.15614780E-01
   -5.01100000E-05  +4.52100000E-05  +1.61180000E-04  +7.46110000E-04  +9.07200000E-05
   +3.70200000E-05  -3.59710000E-04  +1.06370000E-04  +4.38730000E-04  +2.28560000E-04
   +3.43900000E-05  -9.09100000E-05  -2.74490000E-04  -1.72950000E-04  -1.32990000E-04
   +1.10980000E-04  -9.13200000E-05  -1.80250000E-04  -2.06964000E-03  -6.55200000E-05
   +8.54210000E-04  +1.68700000E-05  +1.98480000E-04  +4.27560000E-04  +3.25460000E-04
   +1.55760000E-04  -2.13480000E-04  +8.94450000E-04  +1.22893000E-03  +2.95440000E-04
   +2.55870000E-04  -1.83840000E-04  +9.29100000E-05  +8.93600000E-05  -7.63200000E-05
   -7.13100000E-05  +5.94900000E-05  +3.56300000E-05  -1.14810000E-04  -1.69540000E-04
   +1.78300000E-05  -3.01700000E-05  +2.05380000E-04  -3.45650000E-04  +2.58580000E-04
   +2.66000000E-06  +1.38300000E-05  +2.26100000E-05  -2.73699700E-01  -9.74215300E-02
   -2.63299500E-02  +3.35100000E-05  +4.77500000E-05  -2.30520000E-04  +1.72900000E-05
   -2.69900000E-05  -1.24800000E-05  +2.05700000E-05  -1.75700000E-05  +1.79000000E-06
   -8.28000000E-06  -9.12000000E-06  -7.25000000E-06  +3.34200000E-05  +7.16300000E-05
   +8.62000000E-06  +2.69600000E-04  -1.31610000E-04  -4.70830000E-04  -7.01000000E-06
   -2.92000000E-05  +8.97000000E-06  -2.59800000E-05  -2.42000000E-06  -8.85000000E-06
   +7.08700000E-05  -5.07800000E-05  -6.53500000E-05  -1.80271200E-02  -8.95604000E-03
   -1.82089000E-03  -3.61158000E-03  -5.62800000E-04  -5.79590000E-04  +2.94436940E-01
   -1.07948000E-03  -4.89800000E-05  -5.37800000E-05  +9.39360000E-04  -7.14760000E-04
   -3.12279000E-03  +2.61900000E-04  +1.37950000E-04  -3.75340000E-04  -2.70000000E-06
   +3.21950000E-04  +2.30640000E-04  -1.26690000E-04  -2.01250000E-04  -1.67070000E-04
   +1.31770000E-04  -2.73560000E-04  -2.03820000E-04  -1.39474600E-02  -8.11402000E-03
   -1.98676000E-03  +5.07270000E-04  +1.54530000E-04  +1.00529000E-03  +2.89420000E-04
   +1.93220000E-04  -1.27850000E-04  -1.14676000E-03  +4.34000000E-04  +7.47200000E-05
   +3.28940000E-04  +1.01580000E-04  -3.91300000E-05  +1.19320000E-04  +3.98000000E-06
   -5.76400000E-05  +1.76800000E-04  -1.72530000E-04  -4.35400000E-05  +1.90300000E-05
   +1.82900000E-05  +4.61100000E-05  -9.08500000E-05  -3.43850000E-04  +4.88870000E-04
   -1.80650000E-04  +1.97760000E-04  +1.00600000E-05  -9.57502700E-02  -8.78571700E-02
   -1.00038900E-02  +4.85900000E-05  +5.18500000E-05  -2.25400000E-04  -3.43800000E-05
   -3.81000000E-06  -5.17600000E-05  -1.58800000E-05  -2.28000000E-06  -1.30000000E-07
   -1.35300000E-05  -5.69000000E-06  -1.60300000E-05  -2.95000000E-06  +1.23750000E-04
   -1.36530000E-04  +6.35900000E-05  -2.20700000E-04  +3.22690000E-04  -3.26800000E-05
   -1.31500000E-05  -1.95600000E-05  -6.85000000E-05  -8.38000000E-05  +2.01600000E-05
   +4.60000000E-06  +4.83600000E-05  -6.00000000E-05  +2.25152200E-02  +1.06026700E-02
   +2.64616000E-03  -1.88860300E-02  -8.04887000E-03  -3.06961000E-03  +1.05813240E-01
   +9.34091600E-02  -1.82312000E-03  -7.75550000E-04  +6.97800000E-05  +1.43572000E-03
   -2.04410000E-03  -5.14077000E-03  +8.14590000E-04  -3.26150000E-04  -4.57390000E-04
   -1.74750000E-04  +1.29910000E-04  +3.35790000E-04  -1.36430000E-04  -5.70400000E-05
   -8.96900000E-05  +2.75710000E-04  -2.90460000E-04  -3.75850000E-04  -2.68426200E-02
   -1.20393200E-02  -4.98864000E-03  -1.33306000E-03  -8.15440000E-04  +1.27099000E-03
   +2.25340000E-04  +1.78160000E-04  -7.80000000E-05  -9.90710000E-04  +5.95920000E-04
   +6.51310000E-04  -8.01000000E-06  +1.26740000E-04  +2.03520000E-04  +1.84040000E-04
   -1.33190000E-04  -5.24900000E-05  +2.42000000E-04  -3.55000000E-06  -2.04920000E-04
   -4.28150000E-04  +3.77800000E-05  +8.57100000E-05  +4.15670000E-04  -1.71820000E-04
   +2.06200000E-05  -2.10440000E-04  +1.84570000E-04  +1.59400000E-05  -2.42120400E-02
   -9.37539000E-03  -4.88844000E-02  +4.68300000E-05  +4.54400000E-05  -1.76500000E-04
   +3.12400000E-05  +1.17000000E-05  -1.02480000E-04  -1.06500000E-05  -1.02300000E-05
   +9.81000000E-06  +1.38400000E-05  +1.02100000E-05  +2.89000000E-06  +2.62000000E-05
   +1.05700000E-05  +5.49500000E-05  -3.06800000E-05  +4.37360000E-04  +3.17650000E-04
   -2.95000000E-05  -4.86500000E-05  -1.55000000E-06  -1.38630000E-04  -4.98000000E-05
   -3.28100000E-05  +8.99000000E-06  +3.97800000E-05  -1.09100000E-05  +1.42785000E-03
   +1.05089000E-03  -7.86230000E-04  +2.28476700E-02  +8.45857000E-03  +3.14884000E-03
   +2.76376600E-02  +1.43374300E-02  +5.52424400E-02  +2.99540000E-04  +2.21040000E-04
   +2.49560000E-04  +8.11030000E-04  -1.36421000E-03  -1.66110000E-04  +2.70640000E-04
   +1.37720000E-04  +1.23360000E-04  +4.53800000E-05  -8.17000000E-06  -1.06810000E-04
   +1.87870000E-04  +6.82100000E-05  -2.97900000E-05  -2.59710000E-04  +2.69700000E-05
   -1.73800000E-05  +1.83850000E-03  -3.30173000E-03  +5.19310000E-04  -2.12719110E-01
   +1.32324800E-01  +1.11020800E-02  -1.88410000E-04  -1.23420000E-04  +8.80400000E-05
   +2.94340000E-04  -6.84100000E-04  +8.46460000E-04  -3.82170000E-04  -1.19340000E-04
   +4.53470000E-04  +2.49830000E-04  +1.45280000E-04  -2.07040000E-04  +5.55200000E-05
   -3.44200000E-05  -2.98700000E-05  -7.80000000E-05  +3.32500000E-05  -4.91300000E-05
   +2.96490000E-04  -2.87450000E-04  +1.95590000E-04  -1.10740000E-04  +1.45460000E-04
   -3.52700000E-05  -8.92900000E-05  -1.94050000E-04  +5.92500000E-05  -1.48200000E-05
   -2.89500000E-05  +1.12590000E-04  +2.35460000E-04  +1.94710000E-04  -4.98360000E-04
   -1.27700000E-05  +1.61000000E-06  +2.14200000E-05  -8.22000000E-06  -1.59600000E-05
   -2.30000000E-05  +8.25500000E-05  +5.83700000E-05  -3.40700000E-05  +3.16900000E-05
   +2.36700000E-05  +1.24300000E-05  +2.24400000E-05  +1.86300000E-05  +1.00000000E-05
   -1.66000000E-06  +9.14000000E-06  -3.05000000E-06  +1.84700000E-05  -5.46700000E-05
   +1.89600000E-05  +2.69120000E-04  -1.30520000E-04  -4.45330000E-04  +2.00430000E-04
   -2.42320000E-04  -7.80800000E-05  +1.26100000E-05  +1.12900000E-04  +8.65400000E-05
   +2.27850760E-01  -9.80200000E-05  -1.15570000E-04  -4.59890000E-04  +1.31626000E-03
   +4.76670000E-04  -3.69200000E-05  -5.70000000E-05  +1.98960000E-04  -8.39400000E-05
   -3.18130000E-04  -2.56910000E-04  -1.55810000E-04  +2.61560000E-04  +2.13510000E-04
   +2.56860000E-04  -8.56600000E-05  +3.39900000E-05  +4.29300000E-05  +1.76143400E-02
   -1.64735600E-02  -1.31904000E-03  +1.30368690E-01  -1.49853140E-01  -9.79596000E-03
   -4.42930000E-04  -2.33340000E-04  +2.11710000E-04  -1.86338000E-03  -2.11742000E-03
   +3.84517000E-03  -6.22120000E-04  +9.19500000E-05  +4.61450000E-04  +1.24950000E-04
   +8.20000000E-05  -1.54200000E-05  -3.14870000E-04  +1.86750000E-04  +7.07500000E-05
   -3.04400000E-05  -3.93410000E-04  +1.45340000E-04  +1.40248000E-03  -4.23660000E-04
   -2.44040000E-04  +2.91670000E-04  -2.54080000E-04  -3.76000000E-05  -5.09000000E-05
   +4.03420000E-04  -1.35714000E-03  -6.79100000E-05  -6.81500000E-05  +2.86100000E-04
   -1.53610000E-04  +5.14200000E-05  -2.91550000E-04  +5.59000000E-05  -2.21100000E-05
   -2.86000000E-06  +8.12200000E-05  -1.18610000E-04  -2.94400000E-05  -2.66200000E-05
   +2.63000000E-05  +7.40900000E-05  +1.83000000E-05  -2.52300000E-05  +8.23200000E-05
   -7.44000000E-06  +1.63000000E-05  +3.25000000E-06  +5.64000000E-06  -1.04000000E-05
   +2.58000000E-06  +2.88300000E-05  +1.00060000E-04  +1.45950000E-04  -1.26580000E-04
   +6.50730000E-04  +3.62470000E-04  -3.20120000E-04  +1.00120000E-04  -1.05170000E-04
   -1.15860000E-04  +6.01000000E-05  +1.45800000E-05  -1.42850340E-01  +1.63715090E-01
   +3.93200000E-04  -5.52500000E-05  -1.90420000E-04  -6.95290000E-04  -2.99420000E-04
   +4.44270000E-04  -2.68830000E-04  -1.18530000E-04  +2.00420000E-04  +2.12830000E-04
   +1.72410000E-04  +8.11100000E-05  -4.43600000E-05  -1.50500000E-04  -2.18350000E-04
   -3.00850000E-04  +3.53200000E-05  +3.21600000E-05  -1.81747500E-02  +1.48130400E-02
   -3.72440000E-04  +1.22987400E-02  -1.09173700E-02  -4.77259900E-02  +9.75600000E-05
   +7.25300000E-05  -8.95200000E-05  +1.63198000E-03  +2.50302000E-03  -3.25207000E-03
   +8.71400000E-04  +1.93210000E-04  -2.81750000E-04  -1.97410000E-04  +6.46300000E-05
   +2.01220000E-04  +4.76700000E-05  -1.54120000E-04  +1.99600000E-05  +1.84650000E-04
   +2.07700000E-04  -2.14640000E-04  -1.17145000E-03  +9.51950000E-04  +3.72490000E-04
   -9.66900000E-05  +4.33300000E-05  +1.79100000E-05  -1.19853000E-03  +8.82090000E-04
   +1.14313000E-03  +1.67800000E-05  +3.03600000E-05  -1.03160000E-04  -1.88240000E-04
   -5.09150000E-04  +7.29900000E-05  -1.33800000E-05  +3.11800000E-05  +1.46200000E-05
   -1.00300000E-04  +5.95000000E-05  -2.86000000E-05  +1.76000000E-06  -2.78300000E-05
   +9.65000000E-06  +3.73000000E-05  -4.50000000E-07  -8.89900000E-05  +4.89000000E-06
   -6.95000000E-06  +1.02200000E-05  +1.43900000E-05  -1.68300000E-05  +6.55000000E-06
   +2.21100000E-05  +2.64000000E-06  +8.96300000E-05  +3.18760000E-04  -2.30730000E-04
   -7.16950000E-04  +2.33540000E-04  -2.29100000E-04  +2.28460000E-04  +4.39600000E-05
   +5.11000000E-06  -6.30600000E-05  -1.37537000E-02  +7.16497000E-03  +5.13060300E-02
   +8.48500000E-05  +9.11300000E-05  +3.30380000E-04  +4.73940000E-04  -1.08922000E-03
   +1.03814000E-03  +2.43280000E-04  -3.35890000E-04  -1.26720000E-04  +7.11000000E-06
   +2.20590000E-04  +1.20010000E-04  -2.79040000E-04  -2.05210000E-04  -1.42690000E-04
   +9.45500000E-05  +1.37400000E-05  -6.38300000E-05  -2.70524000E-03  -8.17400000E-04
   -5.40010000E-04  -2.33463520E-01  -1.17784310E-01  -3.14525500E-02  +4.27260000E-04
   +2.66860000E-04  -2.80990000E-04  -1.24070000E-04  +1.26700000E-04  +1.81080000E-04
   -7.04310000E-04  +9.27280000E-04  +6.12910000E-04  +2.17660000E-04  +1.58810000E-04
   -1.89240000E-04  -1.20860000E-04  +2.41200000E-05  -2.63300000E-05  +7.15000000E-06
   +2.12000000E-06  +7.66000000E-06  +1.19540000E-04  -1.39700000E-04  +2.49600000E-05
   +3.68800000E-05  +4.43000000E-06  -2.88700000E-05  +3.03810000E-04  +3.54010000E-04
   -5.11820000E-04  +8.10200000E-05  +9.58500000E-05  -3.82320000E-04  -5.95680000E-04
   +1.71741000E-03  -2.22400000E-05  +2.47800000E-05  -2.25000000E-06  +2.76700000E-05
   +4.77000000E-06  -1.81900000E-05  -1.12200000E-05  -9.00000000E-06  +7.33000000E-06
   -1.67400000E-05  -4.25600000E-05  +3.04200000E-05  +3.16700000E-05  -2.71100000E-05
   -4.05300000E-05  -1.29500000E-05  -2.73700000E-05  -5.98000000E-06  -1.11200000E-05
   -4.80000000E-07  -2.11500000E-05  -2.80200000E-05  -2.10690000E-04  -8.89500000E-05
   +6.26500000E-05  +2.55920000E-04  +2.29250000E-04  +5.80100000E-05  +3.45470000E-04
   +6.97500000E-05  +4.47480000E-04  -1.94292800E-02  -1.39916700E-02  -4.00444000E-03
   +2.54025690E-01  -6.44700000E-04  -4.02830000E-04  -1.77080000E-04  +2.02800000E-04
   -2.07925000E-03  +3.96027000E-03  -1.57410000E-04  -4.26470000E-04  -2.76720000E-04
   -4.93970000E-04  +2.32470000E-04  -8.23900000E-05  -7.83620000E-04  -1.86070000E-04
   +1.70540000E-04  +7.46660000E-04  +1.25440000E-04  -1.05570000E-04  -1.94323000E-02
   -1.21000400E-02  -3.79653000E-03  -1.16669640E-01  -1.21183940E-01  -1.97494600E-02
   +7.28540000E-04  +4.21880000E-04  -4.25210000E-04  -5.26490000E-04  +7.86910000E-04
   -4.51160000E-04  -5.87000000E-05  -5.67260000E-04  +4.98570000E-04  +3.61930000E-04
   +1.60800000E-04  -2.42540000E-04  +1.49360000E-04  -2.69000000E-05  -1.25520000E-04
   -1.74880000E-04  +1.85070000E-04  -1.14800000E-05  +2.19370000E-04  -1.59300000E-04
   +1.98410000E-04  -1.55430000E-04  +2.13570000E-04  -3.11300000E-05  -5.16300000E-05
   +6.34470000E-04  -1.51721000E-03  +1.14110000E-04  +1.32720000E-04  -5.35410000E-04
   +1.25679000E-03  -1.35828000E-03  -8.10900000E-04  -1.39400000E-05  -2.75900000E-05
   +1.16200000E-05  -1.40300000E-05  +1.00000000E-07  -2.24600000E-05  -4.17000000E-06
   +7.46000000E-05  -1.08030000E-04  +2.30000000E-05  -1.07850000E-04  +1.40310000E-04
   -7.52400000E-05  -5.62000000E-05  -4.43000000E-05  -1.85900000E-05  -4.22900000E-05
   +1.00000000E-08  -3.77000000E-06  +1.63530000E-04  -6.71500000E-05  +1.36250000E-04
   -1.63600000E-05  +1.35480000E-04  +3.27110000E-04  -3.54000000E-06  -1.60220000E-04
   +3.25670000E-04  +4.81720000E-04  +5.19870000E-04  +1.70651100E-02  +1.18932200E-02
   +3.26403000E-03  +1.28442670E-01  +1.30631100E-01  +1.48290000E-04  -1.81880000E-04
   +2.24680000E-04  -9.24310000E-04  +2.45000000E-03  -2.97005000E-03  +1.09094000E-03
   +3.34250000E-04  +1.30870000E-04  -1.60420000E-04  -5.80230000E-04  -9.96500000E-05
   +4.17370000E-04  +4.19710000E-04  +3.16990000E-04  +1.89140000E-04  -1.04480000E-04
   +2.25780000E-04  +2.01743600E-02  +1.21921600E-02  +1.59282000E-03  -3.15691000E-02
   -2.09042000E-02  -5.32756300E-02  -5.59380000E-04  -3.13200000E-04  +3.14550000E-04
   -3.57300000E-05  -6.17090000E-04  +5.11040000E-04  -4.87960000E-04  -3.65900000E-04
   +5.09390000E-04  +5.70000000E-06  +1.92410000E-04  -1.62080000E-04  -1.81480000E-04
   -3.10000000E-06  +1.19800000E-04  +1.16660000E-04  -5.72700000E-05  -3.73600000E-05
   +4.79900000E-05  -1.37700000E-05  -2.15440000E-04  +8.13800000E-05  -3.25800000E-05
   -3.54500000E-05  +1.17136000E-03  +5.87520000E-04  +1.16363000E-03  -8.38300000E-05
   -1.19370000E-04  +3.79830000E-04  +2.22680000E-04  -2.05250000E-04  +2.72500000E-05
   +1.13000000E-05  -3.94000000E-06  +1.19000000E-05  +2.13000000E-05  +3.47000000E-06
   +1.01700000E-05  +3.38100000E-05  +1.66200000E-05  +1.13800000E-05  +5.25000000E-06
   +1.41730000E-04  -1.06490000E-04  +3.83000000E-05  +7.56900000E-05  -2.97000000E-06
   +2.85000000E-05  +2.05200000E-05  +4.29000000E-06  -1.84450000E-04  +4.12390000E-04
   -1.76300000E-05  +5.31900000E-05  -1.39410000E-04  -5.26000000E-05  -1.88820000E-04
   -1.66500000E-04  +3.25320000E-04  -3.98210000E-04  +1.35150000E-04  -6.33980000E-04
   +2.06513000E-03  +1.31491000E-03  -6.38550000E-04  +3.37025200E-02  +1.96207000E-02
   +5.57857200E-02  -1.06070000E-04  -2.22600000E-05  +1.52120000E-04  +2.68920000E-04
   +6.75490000E-04  +6.47020000E-04  -2.34490000E-04  -6.37300000E-05  +4.13200000E-05
   +1.85020000E-04  -3.20000000E-06  +1.77800000E-05  +2.37480000E-04  +1.38800000E-05
   -5.15500000E-05  -4.38170000E-04  -4.15300000E-05  -7.49200000E-05  -1.94781000E-03
   +1.34650000E-03  +2.45008000E-03  -4.73407100E-02  +1.11447000E-03  +3.76821000E-03
   -2.37720000E-04  -1.34420000E-04  +6.79100000E-05  +2.20860000E-04  -2.17640000E-04
   -5.33000000E-04  +1.38400000E-04  +4.44230000E-04  -5.27120000E-04  -1.03750000E-04
   -9.05300000E-05  +2.18020000E-04  -6.20500000E-05  +4.03900000E-05  +2.80000000E-06
   +6.82500000E-05  -7.53500000E-05  +1.85300000E-05  -8.75700000E-05  +2.88400000E-05
   -4.17900000E-05  +9.61700000E-05  -1.38150000E-04  +2.62100000E-05  -6.97400000E-05
   -3.09600000E-04  +2.45040000E-04  -3.18900000E-05  -2.64800000E-05  +1.39770000E-04
   -1.18176000E-03  +7.39700000E-05  -4.69390000E-04  +4.12000000E-06  -1.60000000E-07
   -2.45000000E-05  +8.82000000E-06  -6.59000000E-06  +1.47400000E-05  -2.56000000E-05
   -3.81400000E-05  +3.91100000E-05  +4.69000000E-05  +1.62200000E-05  -6.29100000E-05
   -1.02000000E-06  +2.28500000E-05  -3.93000000E-06  +7.92000000E-06  -2.24300000E-05
   +1.11300000E-05  +1.72040000E-04  -4.29940000E-04  +5.93100000E-05  +1.02880000E-04
   -2.94000000E-04  -2.42590000E-04  +6.72380000E-04  -2.52800000E-05  +1.50890000E-04
   +3.22690000E-04  +1.56080000E-04  +3.48090000E-04  +8.52700000E-05  +9.73803000E-03
   +2.38626000E-02  +1.31876000E-03  -1.03674900E-02  -2.52146200E-02  +4.78026900E-02
   -4.15430000E-04  -1.84000000E-06  +6.98010000E-04  +7.06140000E-04  +8.52690000E-04
   +6.61900000E-05  -1.81790000E-04  +2.79100000E-05  -8.33500000E-05  +1.46710000E-04
   +2.32500000E-05  +5.52100000E-05  +2.82600000E-04  +7.43300000E-05  -8.43500000E-05
   -1.96200000E-04  -1.60200000E-04  -1.37620000E-04  -6.45970000E-04  +9.53963000E-03
   +2.10062700E-02  +9.93790000E-04  -9.29941800E-02  -1.01983620E-01  -1.88140000E-04
   -1.33590000E-04  +8.85500000E-05  -4.35000000E-05  +1.17201000E-03  -3.73250000E-04
   +6.15290000E-04  +1.29320000E-04  +7.57000000E-06  +3.49900000E-05  -1.91810000E-04
   +7.04000000E-05  +1.60500000E-04  +2.79500000E-05  -1.74270000E-04  -1.61650000E-04
   +1.11210000E-04  +4.41400000E-05  -2.33700000E-04  -1.31660000E-04  -2.53700000E-05
   -7.89100000E-05  +3.88400000E-05  +2.29600000E-05  -5.29000000E-04  -3.13390000E-03
   +2.93953000E-03  -2.56700000E-05  -3.22300000E-05  +1.44250000E-04  +4.50940000E-04
   -2.54310000E-04  +2.50550000E-04  +1.64900000E-05  +2.05400000E-05  +2.82900000E-05
   -7.77000000E-06  +1.89300000E-05  +1.23000000E-05  +1.00600000E-05  +4.00900000E-05
   +2.00800000E-05  +3.92000000E-05  -1.95900000E-05  +1.10100000E-05  +6.40000000E-06
   +6.81000000E-06  +7.00000000E-06  -1.09000000E-05  -2.34000000E-06  +1.15800000E-05
   -1.94390000E-04  -9.30260000E-04  +4.27000000E-06  -2.74080000E-04  +7.03200000E-05
   +1.20740000E-04  +6.02700000E-05  +7.89990000E-04  +1.34077000E-03  +1.81970000E-04
   -8.66700000E-05  +6.54600000E-05  -1.18698000E-03  -8.10905000E-03  -1.77177600E-02
   +1.97987000E-03  -7.03488000E-03  -1.43785700E-02  -1.45299000E-03  +1.00186920E-01
   -1.94300000E-05  -7.96510000E-04  -1.44990000E-04  -1.50478000E-03  -5.56290000E-04
   +4.97970000E-04  +8.06660000E-04  +1.97300000E-05  -1.65010000E-04  -4.65310000E-04
   -2.25730000E-04  -1.17710000E-04  -2.95930000E-04  +1.94710000E-04  +2.81020000E-04
   +6.03050000E-04  +1.92810000E-04  +2.58770000E-04  +2.39590000E-04  -1.02325200E-02
   -1.99346700E-02  +4.26586000E-03  -9.98151400E-02  -2.70192710E-01  +1.20190000E-04
   +8.02400000E-05  +3.39000000E-06  +7.91450000E-04  -1.15836000E-03  +7.87330000E-04
   +4.34670000E-04  +2.23940000E-04  +7.73000000E-05  -3.00860000E-04  +1.67650000E-04
   +2.35260000E-04  -1.42160000E-04  -1.94420000E-04  +1.43810000E-04  +2.11610000E-04
   -1.85530000E-04  -2.61300000E-05  -2.51300000E-05  +5.17030000E-04  +2.11600000E-05
   +9.10000000E-07  -2.66400000E-05  +9.03000000E-06  +9.10130000E-04  +4.85422000E-03
   -2.80915000E-03  +1.32300000E-05  +5.61000000E-06  -6.46700000E-05  -5.79000000E-04
   -2.21210000E-04  +2.84600000E-05  -1.22800000E-05  +3.08200000E-05  -5.43000000E-06
   -2.51800000E-05  -1.45300000E-05  -3.35100000E-05  -4.98200000E-05  -1.02480000E-04
   +2.66700000E-05  -1.40970000E-04  +1.60700000E-05  +6.97600000E-05  +4.51000000E-06
   +7.68000000E-06  -1.48700000E-05  +4.36500000E-05  -2.65000000E-06  +1.26800000E-05
   -1.81350000E-04  +3.86890000E-04  +2.64140000E-04  +3.11000000E-06  +3.91200000E-05
   +3.88150000E-04  -9.04400000E-05  -6.26850000E-04  -1.51972000E-03  +8.66000000E-06
   +2.68800000E-05  +3.09680000E-04  -2.59030000E-04  -2.11000000E-06  -4.70970000E-04
   +4.72810000E-04  -8.35160000E-04  -2.64724000E-03  -4.75890000E-03  +1.08235140E-01
   +2.94622380E-01  -4.52345000E-03  -5.47918000E-03  -6.83881000E-03  +3.82389000E-03
   +1.95887000E-03  +1.68440000E-04  -9.72471000E-03  -4.10000000E-06  +3.31844000E-03
   +5.15246000E-03  +1.40774800E-02  +1.19161100E-02  -6.24983500E-02  -2.18241700E-02
   +1.20715700E-02  +1.33550600E-02  -6.15761000E-03  -6.66722000E-03  +1.03860000E-03
   -3.64730000E-04  +1.59303000E-03  -1.61384000E-03  -2.53840000E-04  -1.14356000E-03
   -9.82414700E-02  +6.55049000E-03  +1.13480280E-01  -1.89370000E-04  -1.11278000E-03
   -4.50280000E-04  +2.19800000E-04  +1.23890000E-04  -4.90580000E-04  -2.39950000E-04
   +7.26190000E-04  -2.14680000E-04  +8.71020000E-04  -1.14626000E-03  +2.68550000E-04
   -2.70360000E-04  -2.03380000E-04  +1.88320000E-04  -3.40830000E-04  +9.68000000E-06
   -1.04390000E-04  -1.25981000E-03  +1.20395000E-03  -1.61100000E-05  -6.76020000E-04
   +7.74200000E-05  +3.52300000E-04  +7.64090000E-03  +2.60319700E-02  -4.42791900E-02
   +1.23180000E-04  -6.15500000E-05  -5.79200000E-05  -1.33790000E-04  +8.23500000E-05
   +7.85800000E-05  -6.80400000E-05  +9.58300000E-05  -4.90000000E-05  +1.01680000E-04
   -2.64560000E-04  +4.24990000E-04  +8.02600000E-05  -3.53040000E-04  -1.96250000E-04
   +5.24220000E-04  -2.72396000E-03  -8.74820000E-04  -4.27000000E-06  +6.66600000E-05
   +4.43860000E-04  -5.20290000E-04  +2.76740000E-04  -6.77100000E-05  +1.04470000E-04
   +9.46600000E-05  +1.01920000E-04  +1.31930000E-04  +9.22700000E-05  -2.20000000E-07
   -2.45200000E-04  -2.50090000E-04  -2.04550000E-04  +1.23490000E-04  +3.24570000E-04
   -1.11750000E-04  -4.11850000E-04  -5.93810000E-04  +4.41150000E-04  +1.61620000E-04
   +1.59990000E-04  -7.57200000E-05  +1.42220830E-01  -3.01507000E-03  -4.72121000E-03
   -7.50364000E-03  +3.44972000E-03  +1.59096000E-03  -3.30560000E-04  -8.65483000E-03
   -5.48970000E-04  +3.39565000E-03  +2.62690000E-03  +1.05561200E-02  +1.26785300E-02
   -4.23335600E-02  -2.06096400E-02  -1.21800000E-04  +1.23077500E-02  +2.37490000E-04
   -5.47239000E-03  +9.75700000E-04  -3.08710000E-04  +1.51135000E-03  -1.56249000E-03
   -2.38590000E-04  -1.12178000E-03  +5.06047600E-02  +2.65702000E-03  -4.21780600E-02
   -2.33440000E-04  -1.03898000E-03  -4.07910000E-04  +2.09260000E-04  +1.02530000E-04
   -4.43790000E-04  -2.38880000E-04  +6.81400000E-04  -1.81980000E-04  +7.96150000E-04
   -1.05597000E-03  +2.47230000E-04  -2.48000000E-04  -1.99170000E-04  +1.63780000E-04
   -2.92600000E-04  +3.08200000E-05  -1.36530000E-04  -1.15827000E-03  +1.09031000E-03
   -1.01000000E-05  -6.15310000E-04  +1.06310000E-04  +3.46690000E-04  +4.45822000E-03
   -1.22445000E-03  -2.36325100E-02  +9.96100000E-05  -6.55200000E-05  -5.07800000E-05
   -1.25640000E-04  +7.63700000E-05  +7.48500000E-05  -4.37600000E-05  +8.23700000E-05
   -3.70300000E-05  +9.53300000E-05  -2.14630000E-04  +4.09220000E-04  +1.07700000E-05
   -2.23790000E-04  -2.58050000E-04  +2.52150000E-04  -1.89205000E-03  -1.69068000E-03
   -2.82730000E-04  -1.14280000E-04  +7.20920000E-04  -1.08800000E-04  +2.02850000E-04
   +2.09760000E-04  +1.05300000E-04  +6.16300000E-05  +8.92700000E-05  +1.20020000E-04
   +9.08300000E-05  +8.89000000E-06  -2.20570000E-04  -2.31780000E-04  -1.89440000E-04
   +1.19900000E-04  +2.91320000E-04  -1.16560000E-04  -3.84600000E-04  -5.60670000E-04
   +4.48030000E-04  +1.33350000E-04  +1.47880000E-04  -5.04800000E-05  -1.75098000E-02
   +1.27746100E-02  +5.92583000E-03  +9.34112000E-03  +1.32729400E-02  -5.51335000E-03
   -3.20127000E-03  -3.37080000E-04  +1.46583400E-02  +2.81340000E-04  -5.72388000E-03
   -7.77594000E-03  -1.86973700E-02  -1.75588100E-02  +4.26388100E-02  +3.45147000E-02
   +3.11768400E-02  -2.73077400E-02  +1.30411000E-03  +7.08970000E-03  -1.69266000E-03
   +5.18400000E-04  -2.70315000E-03  +2.65053000E-03  +4.11740000E-04  +1.86148000E-03
   +8.39800400E-02  -4.22376600E-02  -2.02619660E-01  +3.54540000E-04  +1.85698000E-03
   +6.86700000E-04  -3.74300000E-04  -2.00390000E-04  +7.89270000E-04  +4.19200000E-04
   -1.21229000E-03  +3.42050000E-04  -1.47817000E-03  +1.92121000E-03  -4.34790000E-04
   +4.56670000E-04  +3.50410000E-04  -3.18740000E-04  +5.06830000E-04  -4.68300000E-05
   +2.30360000E-04  +2.11857000E-03  -2.00749000E-03  +1.64100000E-05  +1.10457000E-03
   -1.27440000E-04  -5.49340000E-04  -2.08688000E-02  -2.48257600E-02  +3.78414600E-02
   -1.93970000E-04  +1.10750000E-04  +9.12800000E-05  +2.29750000E-04  -1.34930000E-04
   -1.32210000E-04  +9.11400000E-05  -1.50280000E-04  +7.68200000E-05  -1.73000000E-04
   +4.16200000E-04  -7.07000000E-04  +2.20700000E-05  +5.63540000E-04  +3.99490000E-04
   -3.35970000E-04  +1.88700000E-03  -3.98820000E-04  +1.62930000E-04  +1.26490000E-04
   -8.81440000E-04  +1.73650000E-04  -6.55560000E-04  -1.98030000E-04  -1.72900000E-04
   -1.92180000E-04  -1.60660000E-04  -2.44130000E-04  -1.29360000E-04  -3.06900000E-05
   +4.35040000E-04  +4.02710000E-04  +3.13870000E-04  -2.09520000E-04  -5.27970000E-04
   +1.95810000E-04  +6.81470000E-04  +9.79130000E-04  -7.25050000E-04  -2.51480000E-04
   -2.59080000E-04  +1.06000000E-04  -8.42288100E-02  +5.60973600E-02  +1.37040190E-01
   +7.05300000E-05  +1.01120000E-04  +1.57540000E-04  -6.01600000E-05  -1.83330000E-04
   -2.38700000E-05  +1.24890000E-04  +2.02100000E-05  -4.83000000E-06  -7.00000000E-07
   -8.80600000E-05  -1.17700000E-04  +2.22950000E-04  +1.38840000E-04  +7.62700000E-05
   -1.56880000E-04  -2.13800000E-05  +2.70700000E-05  -1.44850000E-04  +1.52600000E-04
   -1.61590000E-04  +9.32700000E-05  -6.03000000E-06  -6.34000000E-06  -3.03620000E-04
   -1.84530000E-04  +1.38520000E-04  +6.28220000E-04  +1.72240000E-04  -3.63610000E-04
   -1.09421000E-03  -1.34710000E-04  +3.49660000E-04  +4.39230000E-03  -3.42324000E-03
   -1.03880000E-03  -3.11527200E-02  -7.17321000E-03  +2.26383500E-02  -1.35345000E-03
   +5.31594000E-03  -1.30539000E-03  -2.48340000E-04  -8.45450000E-04  +1.71775000E-03
   -3.02189130E-01  -6.32554700E-02  +2.28396020E-01  +1.42130000E-04  -9.18600000E-05
   +5.19500000E-05  -2.69300000E-05  -4.91400000E-05  +2.05000000E-04  +1.57750000E-04
   -2.22070000E-04  +2.42000000E-05  +3.77300000E-05  +1.24090000E-03  -5.01690000E-04
   +1.80200000E-04  -9.81800000E-05  -3.61820000E-04  -2.45290000E-04  +2.33370000E-04
   -1.47640000E-04  -9.24000000E-06  -2.10000000E-06  +3.87000000E-06  +8.64000000E-06
   +2.54500000E-05  -3.20000000E-07  -3.30000000E-06  +4.91000000E-06  -2.28000000E-06
   -1.71900000E-05  -2.07000000E-06  -5.36800000E-05  +3.81200000E-05  -6.16300000E-05
   -5.93700000E-05  -9.41000000E-06  +1.32000000E-05  +5.23000000E-06  -2.59000000E-06
   +3.03300000E-05  +2.97100000E-05  +3.57100000E-05  -3.60300000E-05  +2.02000000E-06
   +4.80000000E-07  +4.20000000E-05  -4.39000000E-06  -2.84400000E-05  +8.12000000E-06
   -1.35300000E-05  +2.24350000E-04  +2.09900000E-04  -3.79750000E-04  +3.30737990E-01
   -4.42300000E-05  -5.95800000E-05  -7.49400000E-05  +6.50200000E-05  +8.22700000E-05
   +3.84200000E-05  -7.57100000E-05  -1.88700000E-05  +1.80000000E-06  +4.28000000E-06
   +5.48400000E-05  +6.10400000E-05  -1.22950000E-04  -7.48700000E-05  -4.14900000E-05
   +9.17700000E-05  +4.63000000E-06  -1.05500000E-05  -2.26700000E-05  -1.03450000E-04
   +6.71600000E-05  -4.66700000E-05  +3.33700000E-05  -1.85100000E-05  +1.69830000E-04
   +9.64300000E-05  -8.75200000E-05  -4.11420000E-04  -3.10030000E-04  +5.05340000E-04
   +1.60920000E-04  -6.14790000E-04  -1.58090000E-04  +1.60085000E-03  +1.09761000E-03
   -2.35026000E-03  +2.95350100E-02  +4.22276000E-03  -2.29327800E-02  +4.09080000E-03
   -3.65881000E-03  +1.33482000E-03  +6.49240000E-04  +1.54100000E-03  -3.23660000E-04
   -1.02874290E-01  -6.65759200E-02  +1.06073720E-01  -2.72800000E-05  +1.67300000E-05
   -2.75000000E-06  +2.03800000E-05  +2.36400000E-05  -1.22800000E-04  -4.16800000E-05
   +3.67700000E-05  -2.69900000E-05  -9.95770000E-04  -8.45500000E-04  +1.57569000E-03
   -2.09200000E-05  -8.76600000E-05  -2.74720000E-04  +1.37120000E-04  -2.75590000E-04
   -6.05600000E-05  +1.20000000E-05  -2.24000000E-06  -5.62000000E-06  -4.73000000E-06
   -1.40100000E-05  -6.30000000E-07  -6.67000000E-06  -1.39000000E-06  -3.35000000E-06
   +1.20100000E-05  +1.92400000E-05  +2.20500000E-05  -1.14200000E-05  +3.29400000E-05
   -9.70000000E-07  +1.31200000E-05  -5.29000000E-06  -1.07700000E-05  +1.80000000E-07
   -2.41700000E-05  -6.56000000E-06  -2.89200000E-05  +1.97500000E-05  +7.36000000E-06
   -1.28200000E-05  -4.81100000E-05  -4.43000000E-06  +2.63300000E-05  +4.67000000E-06
   +1.33500000E-05  -1.31840000E-04  -1.17970000E-04  +2.22580000E-04  +6.82674300E-02
   +6.54916700E-02  -4.02900000E-05  -2.42000000E-05  -1.12500000E-05  +4.30500000E-05
   +4.58100000E-05  -5.49000000E-06  -3.26300000E-05  -1.23800000E-05  -3.35000000E-06
   +2.00000000E-06  +9.59000000E-06  +1.02000000E-05  -3.85900000E-05  -1.82600000E-05
   -4.54000000E-06  +2.68700000E-05  +2.65000000E-06  -1.57000000E-06  +1.04840000E-04
   -5.02500000E-05  +3.68300000E-05  -3.55700000E-05  +3.50000000E-07  +2.08200000E-05
   +4.05800000E-05  +2.09100000E-05  -3.21400000E-05  -9.31500000E-05  +1.47410000E-04
   -5.20600000E-05  +1.44900000E-04  +2.61700000E-05  -8.14510000E-04  -4.39926000E-03
   +7.97060000E-04  +1.31115000E-03  -1.81670000E-03  -4.65200000E-05  -1.37686000E-03
   -5.59250000E-04  +5.89470000E-04  +2.14885000E-03  +7.57810000E-04  +5.68520000E-04
   +7.78320000E-04  +2.54837810E-01  +8.13683700E-02  -2.17142760E-01  -6.82800000E-05
   +7.13500000E-05  -3.59800000E-05  +6.30000000E-06  +5.66000000E-06  -3.69900000E-05
   -9.46800000E-05  +8.16700000E-05  -3.86000000E-05  +9.99380000E-04  +1.76730000E-04
   -1.82400000E-04  -4.19160000E-04  -2.23020000E-04  -1.22460000E-04  -8.33500000E-05
   -1.13750000E-04  -9.54000000E-05  +9.12000000E-06  -1.26000000E-06  -6.02000000E-06
   -1.82000000E-06  -5.45000000E-06  -2.40000000E-07  -1.18800000E-05  -1.94000000E-06
   -3.81000000E-06  +1.06000000E-05  +1.88500000E-05  +2.31100000E-05  -1.72800000E-05
   +2.98600000E-05  +2.86300000E-05  +1.06300000E-05  -2.71000000E-06  -6.87000000E-06
   -4.89000000E-06  -2.51200000E-05  -3.25000000E-06  +1.82000000E-06  +1.79200000E-05
   -5.04000000E-06  +1.95000000E-06  -5.13000000E-06  +1.08700000E-05  -2.57000000E-06
   -6.60000000E-06  -9.05000000E-06  -3.51900000E-05  -3.30600000E-05  +6.28500000E-05
   -2.49246900E-01  -8.34245600E-02  +2.15550100E-01  -6.13300000E-05  -4.80000000E-07
   +3.91330000E-04  -5.85060000E-04  +5.41300000E-05  +7.24670000E-04  +1.64541000E-03
   -6.95000000E-05  -1.25470000E-04  -4.26330000E-04  -1.44433000E-03  -4.55130000E-04
   -2.62610000E-04  -3.97600000E-04  +3.42090000E-04  -3.43590000E-04  +8.52840000E-04
   +1.69000000E-04  -2.77420000E-04  +1.36000000E-04  -2.85420000E-04  +2.70520000E-04
   +4.51500000E-05  +1.59240000E-04  -3.82190000E-03  -4.67430000E-04  -9.45600000E-05
   +1.72900000E-05  +1.55290000E-04  +5.77800000E-05  -3.51500000E-05  -1.42300000E-05
   +6.43100000E-05  +4.30600000E-05  -1.07130000E-04  +3.58700000E-05  -1.87620000E-04
   +1.99790000E-04  -2.91000000E-05  +6.52900000E-05  +4.11300000E-05  -3.01000000E-05
   +2.51600000E-05  -6.22000000E-06  +4.69100000E-05  +2.40260000E-04  -2.08900000E-04
   +2.12000000E-06  +1.16010000E-04  -7.63000000E-06  -4.89100000E-05  -8.83381500E-02
   -1.82174300E-01  -6.06039700E-02  -2.03800000E-05  +9.76000000E-06  +3.04000000E-06
   +2.52800000E-05  -1.29700000E-05  -1.68200000E-05  -6.08000000E-06  -1.43400000E-05
   -2.46000000E-06  -2.14700000E-05  +2.72500000E-05  -8.14700000E-05  +3.70300000E-05
   +1.17750000E-04  +1.60200000E-05  -2.02160000E-04  +7.11570000E-04  -2.80200000E-04
   -5.56600000E-05  -1.40500000E-05  +3.73000000E-05  +8.14300000E-05  -3.73400000E-05
   -1.28300000E-05  -2.09100000E-05  -2.14800000E-05  -1.80300000E-05  -2.88400000E-05
   -1.52900000E-05  -1.20900000E-05  +5.28100000E-05  +4.08300000E-05  +2.81800000E-05
   -2.29600000E-05  -5.28000000E-05  +2.38700000E-05  +7.81600000E-05  +9.84000000E-05
   -7.36200000E-05  -2.44200000E-05  -2.62600000E-05  +9.72000000E-06  +5.06388000E-03
   +4.53580000E-04  -5.40947000E-03  -4.87800000E-05  +2.36900000E-05  +3.78000000E-06
   +8.70292600E-02  +1.44299000E-03  +2.26671000E-03  +2.71572000E-03  -1.21062000E-03
   -7.76110000E-04  -1.85760000E-04  +3.02451000E-03  +9.60500000E-05  -9.01240000E-04
   -4.43350000E-04  -3.50570000E-03  -4.35097000E-03  +9.06120000E-03  +5.67890000E-03
   +3.00245000E-03  -4.48762000E-03  +4.61080000E-04  +1.84579000E-03  -4.64460000E-04
   +1.01310000E-04  -6.36630000E-04  +6.57780000E-04  +1.03120000E-04  +4.54620000E-04
   -1.30584200E-02  -5.86363000E-03  +5.95543000E-03  +7.63800000E-05  +4.70630000E-04
   +1.76610000E-04  -8.82100000E-05  -5.72200000E-05  +2.03130000E-04  +1.03660000E-04
   -3.10190000E-04  +9.41000000E-05  -3.91880000E-04  +5.04180000E-04  -1.12160000E-04
   +1.22240000E-04  +8.95900000E-05  -8.94100000E-05  +1.30540000E-04  -4.93000000E-06
   +4.91200000E-05  +5.55550000E-04  -5.32640000E-04  +5.74000000E-06  +2.96410000E-04
   -2.42400000E-05  -1.37840000E-04  -1.83891970E-01  -3.91366990E-01  -1.33617390E-01
   -5.44400000E-05  +2.53800000E-05  +2.40200000E-05  +5.86300000E-05  -3.49400000E-05
   -3.40100000E-05  +2.89800000E-05  -4.01200000E-05  +2.26700000E-05  -4.88000000E-05
   +1.15700000E-04  -1.80690000E-04  +7.29100000E-05  +1.43070000E-04  +1.41290000E-04
   -1.89390000E-04  +6.35710000E-04  +2.37930000E-04  -5.40000000E-06  +1.40000000E-07
   -1.64500000E-04  +1.33810000E-04  -8.86900000E-05  -6.60700000E-05  -4.27300000E-05
   -5.44900000E-05  -4.35600000E-05  -6.31600000E-05  -3.22800000E-05  -5.70000000E-06
   +1.12470000E-04  +1.06180000E-04  +8.17400000E-05  -5.12500000E-05  -1.37000000E-04
   +4.61500000E-05  +1.75520000E-04  +2.50230000E-04  -1.74110000E-04  -7.06900000E-05
   -6.67700000E-05  +3.47200000E-05  +6.48172000E-03  +2.58555000E-03  -1.66999300E-02
   -9.80600000E-05  +5.99000000E-05  +1.58600000E-05  +1.82125120E-01  +3.89202500E-01
   +1.04735000E-03  +1.57666000E-03  +1.55535000E-03  -3.53040000E-04  -5.86030000E-04
   -7.74670000E-04  +7.02420000E-04  +1.38230000E-04  -5.46820000E-04  -1.68810000E-04
   -1.37674000E-03  -2.59237000E-03  +6.70077000E-03  +4.15888000E-03  +1.69314000E-03
   -2.88242000E-03  -3.09710000E-04  +1.17727000E-03  -5.43600000E-05  -4.94900000E-05
   -1.79140000E-04  +2.11750000E-04  +3.02000000E-05  +1.72820000E-04  -4.04976000E-03
   -4.74380000E-03  -9.66010000E-04  +6.58000000E-05  +1.71600000E-04  +5.54600000E-05
   -4.20600000E-05  -1.22500000E-05  +7.57300000E-05  +4.16100000E-05  -1.13830000E-04
   +2.47600000E-05  -1.14850000E-04  +1.66170000E-04  -4.33400000E-05  +2.85000000E-05
   +2.57300000E-05  -2.17600000E-05  +4.83500000E-05  -4.50000000E-07  +1.44100000E-05
   +1.72010000E-04  -1.65770000E-04  -3.10000000E-06  +9.32300000E-05  -1.70000000E-05
   -4.66800000E-05  -6.82994400E-02  -1.48732200E-01  -6.39049100E-02  -1.25600000E-05
   +1.22700000E-05  +8.74000000E-06  +2.04600000E-05  -1.12500000E-05  -1.07600000E-05
   +5.59000000E-06  -9.78000000E-06  +9.54000000E-06  -7.93000000E-06  +2.64300000E-05
   -5.43600000E-05  +2.05000000E-05  -2.00100000E-05  +8.73100000E-05  +3.37000000E-05
   -1.87200000E-05  +3.50880000E-04  +6.70000000E-05  -1.49200000E-05  -9.88300000E-05
   +2.46400000E-05  -3.61400000E-05  -2.16300000E-05  -1.61400000E-05  -7.60000000E-06
   -1.02600000E-05  -1.49000000E-05  -8.86000000E-06  -1.40000000E-07  +2.97700000E-05
   +3.37800000E-05  +2.91300000E-05  -2.04700000E-05  -3.85100000E-05  +1.38600000E-05
   +5.07300000E-05  +8.18100000E-05  -5.61000000E-05  -2.14000000E-05  -2.64300000E-05
   +1.28700000E-05  +1.25923000E-03  +7.56564000E-03  +1.88582000E-03  -2.96800000E-05
   +1.91900000E-05  +8.93000000E-06  +6.54644300E-02  +1.42292890E-01  +6.21548600E-02
end_hess

