# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -807.46930790    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -1.74912757E+00  +1.16408125E+00  +3.30634487E-01
   006   -3.64234032E+00  +1.46331601E+00  +2.14456011E+00
   006   -5.77798933E+00  -2.49850805E-02  +2.14064513E+00
   006   -6.14302579E+00  -1.85177336E+00  +2.41709670E-01
   006   -4.16993738E+00  -2.24654994E+00  -1.52504053E+00
   006   -2.06237376E+00  -7.34025059E-01  -1.48856524E+00
   001   -3.45077406E+00  +2.87809937E+00  +3.60350431E+00
   001   -7.23606188E+00  +1.97104218E-01  +3.55269831E+00
   008   -8.00011481E+00  -3.57254661E+00  +5.96047545E-01
   001   -4.37525389E+00  -3.73462403E+00  -2.91111149E+00
   001   -5.84176616E-01  -1.05232043E+00  -2.86627113E+00
   006   +6.02288171E-01  +2.83950842E+00  +2.17466926E-01
   006   +2.95412676E+00  +1.16429835E+00  +3.83033356E-02
   006   +3.07350335E-01  +4.58367996E+00  -2.08682735E+00
   006   +8.82456211E-01  +4.52252578E+00  +2.56607288E+00
   006   +4.80410790E+00  +1.46664069E+00  -1.79185338E+00
   006   +6.94222243E+00  -5.76423706E-02  -1.84488465E+00
   006   +7.26453800E+00  -1.92965825E+00  -4.44870983E-02
   006   +5.42937356E+00  -2.26866448E+00  +1.80581810E+00
   006   +3.31895157E+00  -7.39413037E-01  +1.82809716E+00
   001   +4.61452575E+00  +2.90535422E+00  -3.22919772E+00
   001   +8.35458191E+00  +2.21708076E-01  -3.30237117E+00
   008   +9.30769688E+00  -3.48179977E+00  +5.21958891E-03
   001   +5.68165475E+00  -3.74002528E+00  +3.20100436E+00
   001   +1.89606595E+00  -1.05033582E+00  +3.26660626E+00
   001   +1.86655614E+00  +5.92683458E+00  -2.20736293E+00
   001   +2.21087872E-01  +3.51904807E+00  -3.84810711E+00
   001   -1.43949013E+00  +5.66166484E+00  -1.91157847E+00
   001   +2.63487491E+00  +5.59498646E+00  +2.42501477E+00
   001   -6.71768828E-01  +5.86814836E+00  +2.72103708E+00
   001   +9.63853280E-01  +3.41245738E+00  +4.29909287E+00
   001   +1.04244486E+01  -3.06463565E+00  -1.35429841E+00
   001   -8.75389218E+00  -3.92814771E+00  -1.01432096E+00
   008   -8.22663117E+00  +2.15522080E-01  -2.33586423E+00
   001   -7.02850964E+00  +1.39062473E+00  -3.03894943E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -1.00000000E-07  -2.60000000E-07  +2.40000000E-07
   +3.20000000E-07  -3.30000000E-07  +4.00000000E-07
   +1.30000000E-07  -8.60000000E-07  +3.60000000E-07
   +9.10000000E-07  -6.30000000E-07  +1.04000000E-06
   -1.90000000E-07  -2.30000000E-07  +4.10000000E-07
   -3.00000000E-08  -5.00000000E-08  +1.50000000E-07
   +2.50000000E-07  -4.30000000E-07  +5.80000000E-07
   +4.10000000E-07  -8.00000000E-07  +8.40000000E-07
   +1.80000000E-07  -8.40000000E-07  +6.20000000E-07
   +5.00000000E-08  -2.10000000E-07  +3.00000000E-07
   -1.60000000E-07  +9.00000000E-08  +0.00000000E+00
   -1.40000000E-07  +5.00000000E-08  +8.00000000E-08
   +0.00000000E+00  +2.50000000E-07  -3.30000000E-07
   -5.50000000E-07  +1.20000000E-07  +1.70000000E-07
   -4.00000000E-08  -5.00000000E-08  +1.10000000E-07
   -2.10000000E-07  +4.70000000E-07  -5.20000000E-07
   -1.60000000E-07  +6.60000000E-07  -7.90000000E-07
   +2.30000000E-07  +5.80000000E-07  -9.40000000E-07
   +5.50000000E-07  +3.00000000E-07  -7.80000000E-07
   +3.60000000E-07  +1.40000000E-07  -4.20000000E-07
   -5.60000000E-07  +5.40000000E-07  -3.70000000E-07
   -3.70000000E-07  +8.40000000E-07  -9.00000000E-07
   +3.10000000E-07  +8.10000000E-07  -1.26000000E-06
   +7.20000000E-07  +2.90000000E-07  -8.40000000E-07
   +4.30000000E-07  -5.00000000E-08  -2.00000000E-07
   -6.60000000E-07  +2.50000000E-07  +8.00000000E-08
   -6.70000000E-07  +1.90000000E-07  +1.30000000E-07
   -6.50000000E-07  -2.00000000E-08  +4.50000000E-07
   -1.10000000E-07  +9.00000000E-08  -2.00000000E-08
   -1.50000000E-07  -2.00000000E-07  +3.60000000E-07
   +2.50000000E-07  -1.90000000E-07  +1.00000000E-07
   +1.30000000E-07  +9.10000000E-07  -1.31000000E-06
   +2.90000000E-07  -6.70000000E-07  +8.20000000E-07
   -4.60000000E-07  -3.30000000E-07  +5.70000000E-07
   -3.30000000E-07  -4.60000000E-07  +9.00000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.24149620E-01  +1.18990030E-01  +4.32312690E-01  -1.35800270E-01  +1.68421320E-01
   +4.77095000E-01  -1.95613040E-01  -2.99793500E-02  +6.81767200E-02  +5.42889410E-01
   +2.04287600E-02  -1.08788460E-01  -6.40202500E-02  +1.73986340E-01  +4.78188170E-01
   +1.24423640E-01  -2.49534500E-02  -1.90777580E-01  -1.19209220E-01  +2.50971200E-01
   +5.13026160E-01  -5.18717800E-02  +7.31421000E-03  +5.41457600E-02  -2.58024290E-01
   -1.46777900E-01  -1.04308400E-02  +6.18123250E-01  -2.71390100E-02  +2.98398800E-02
   +4.72088900E-02  -1.08240380E-01  -1.76916940E-01  -4.88221200E-02  +1.76891180E-01
   +4.30236510E-01  +8.36069000E-03  +2.40511400E-02  +2.52407200E-02  +4.83132900E-02
   -1.11230500E-02  -1.11622330E-01  -1.92846630E-01  +1.92670300E-01  +5.07411480E-01
   +2.11376000E-03  +2.22496800E-02  +1.66227100E-02  -3.02062000E-03  -2.17294400E-02
   -1.91060500E-02  -9.06429300E-02  -1.84228500E-02  +1.85345500E-02  +4.77874810E-01
   +9.83457000E-03  -1.95278900E-02  -2.03453600E-02  -3.09365300E-02  -2.29112800E-02
   -5.92424000E-03  -1.57707000E-02  -1.82206760E-01  -1.39045830E-01  +2.08456680E-01
   +4.67903470E-01  +1.95155200E-02  -1.28205100E-02  -3.77218800E-02  -6.18376000E-02
   -2.05398700E-02  +3.08851100E-02  +3.97789900E-02  -7.90788700E-02  -1.89796440E-01
   -1.91671360E-01  +2.13588990E-01  +4.52814100E-01  +1.39609900E-02  -5.76808600E-02
   -6.97748400E-02  -5.13436900E-02  -1.41447100E-02  +2.17708400E-02  +3.25262300E-02
   +3.21714500E-02  +1.41533300E-02  -1.47282620E-01  -2.55603200E-02  +1.19071060E-01
   +5.46996250E-01  -1.75574300E-02  -3.20198600E-02  -2.80559000E-02  -1.73228500E-02
   -6.14812000E-03  +8.77658000E-03  +2.54408600E-02  +1.18295200E-02  -1.09092300E-02
   +2.50548100E-02  -1.07407240E-01  -6.92727200E-02  +1.89027200E-01  +5.12309300E-01
   -2.26997800E-02  -5.32695000E-03  +2.00400200E-02  +1.31568300E-02  +3.25068000E-03
   -8.93467000E-03  +1.15504300E-02  -2.46519200E-02  -1.96212700E-02  +9.74654400E-02
   -3.47298900E-02  -1.90127640E-01  -1.19836080E-01  +2.44806430E-01  +4.75411520E-01
   -1.16872320E-01  -2.73110000E-04  +3.74981800E-02  +4.16220600E-02  +2.69047600E-02
   +3.88564000E-03  -2.08462100E-02  -1.92956000E-02  -1.00715500E-02  -4.97946400E-02
   +2.54639000E-03  +2.16255100E-02  -2.69748790E-01  -1.56571380E-01  -4.13430000E-04
   +6.25734900E-01  -4.92343200E-02  -1.76574240E-01  -7.87251700E-02  +5.87737000E-02
   +1.45927700E-02  -3.73337800E-02  -2.92867600E-02  -3.18403100E-02  -1.36168700E-02
   -3.98939200E-02  +3.65298800E-02  +2.12420600E-02  -9.56766000E-02  -1.80890790E-01
   -4.31562300E-02  +1.52745860E-01  +4.22540260E-01  -1.65344700E-02  -1.18759280E-01
   -1.84349610E-01  +3.80762800E-02  -1.43601900E-02  -3.57643300E-02  -1.70535100E-02
   -1.76579200E-02  -1.03261700E-02  -6.16380000E-04  +2.95842000E-02  +1.40224200E-02
   +4.94913400E-02  -1.44386700E-02  -1.03227030E-01  -1.87579710E-01  +1.95838370E-01
   +4.85536860E-01  +7.48915000E-03  +1.58178300E-02  +1.48008100E-02  -5.79545900E-02
   -2.47167700E-02  -1.28805600E-02  +1.21578000E-03  -1.90910000E-02  -1.95304300E-02
   -2.24412000E-03  -4.51334000E-03  +3.08953000E-03  -9.14240000E-04  -4.06500000E-05
   -3.05220000E-04  -1.95748000E-03  -1.16573000E-03  +4.83868000E-03  +5.96069000E-02
   -1.88210000E-04  +1.11919000E-03  -2.65307000E-03  -2.43854000E-02  -1.86603420E-01
   -1.49181960E-01  -6.35420000E-04  -8.56784000E-03  -1.40897900E-02  -4.65710000E-03
   +3.09953000E-03  -2.17868000E-03  -1.30640000E-04  -3.34140000E-04  +1.01993000E-03
   -1.25388000E-03  +3.49101000E-03  -2.16341000E-03  +3.35941200E-02  +1.94765760E-01
   -3.71181000E-03  -1.52208100E-02  -1.08872500E-02  -1.23852200E-02  -1.49298830E-01
   -1.98801420E-01  +1.28352000E-03  +7.06020000E-04  +3.95376000E-03  +2.01771000E-03
   -1.85578000E-03  +3.91539000E-03  +7.04490000E-04  +1.04375000E-03  -2.80700000E-04
   +5.08052000E-03  -2.19095000E-03  -2.34520000E-04  +1.22020200E-02  +1.64672870E-01
   +2.04338250E-01  -9.68650000E-04  -5.45589000E-03  +8.39940000E-04  -1.16300700E-02
   +4.26581000E-03  +1.78652500E-02  -1.99815060E-01  +1.80786800E-02  +1.50213730E-01
   +5.66095000E-03  -2.77586000E-03  -4.65004000E-03  +1.16610000E-03  -2.18421000E-03
   +2.05480000E-04  -2.04480000E-04  -7.79200000E-05  -7.90400000E-04  -3.72730000E-04
   +1.59562000E-03  -1.62932000E-03  +2.06461020E-01  -5.42006000E-03  +1.33670000E-03
   -2.71495000E-03  -1.27830500E-02  +7.12220000E-03  +1.31587800E-02  +1.59692800E-02
   -5.35965100E-02  -3.33815600E-02  +1.61849300E-02  +2.47361000E-03  -1.45946700E-02
   -2.14949000E-03  -8.44060000E-04  -4.60295000E-03  -2.21900000E-04  -1.19920000E-03
   +1.55420000E-04  +2.01906000E-03  -1.62098000E-03  +2.10400000E-03  -1.51860200E-02
   +4.58394000E-02  +1.10731000E-03  -2.85415000E-03  +3.43521000E-03  -2.82149000E-03
   -1.54198000E-03  +5.54710000E-03  +1.48016160E-01  -3.13488900E-02  -1.90600250E-01
   +1.86982900E-02  -1.18192000E-03  -1.31746100E-02  -6.54950000E-04  -4.84430000E-03
   -1.07346000E-03  -9.57080000E-04  +2.31900000E-05  -2.37010000E-04  -1.31517000E-03
   +2.36525000E-03  -1.10270000E-03  -1.62087650E-01  +3.73072000E-02  +1.95608580E-01
   -1.87751000E-03  -3.01819000E-03  -2.59869000E-03  +4.73418000E-03  -1.26167000E-03
   -1.78604000E-03  -1.39144900E-02  -2.45268100E-02  -7.88185000E-03  -1.91990900E-01
   -1.33752660E-01  +5.27748700E-02  -4.04318100E-02  -3.56711300E-02  +1.40195400E-02
   +3.81929000E-03  +8.11776000E-03  +9.89568000E-03  -5.12360000E-04  -2.01880000E-04
   -1.37250000E-04  -1.52350000E-04  +1.57216000E-03  -1.16036000E-03  +3.48740130E-01
   -2.07227000E-03  -6.81600000E-05  +1.70370000E-03  +3.79716000E-03  +2.89838000E-03
   -5.77860000E-03  -3.38567500E-02  -2.98620400E-02  -3.37143000E-03  -1.19603860E-01
   -1.59854080E-01  +2.33847300E-02  -5.94281000E-03  +5.71290000E-04  +6.70031000E-03
   -3.43570000E-04  +1.23353000E-03  -2.61968000E-03  -7.96480000E-04  -6.39550000E-04
   -2.63500000E-05  +1.29502000E-03  +2.15760000E-04  +2.27068000E-03  +2.24622840E-01
   +2.34581280E-01  -1.88526000E-03  -2.99760000E-04  +3.06940000E-04  +6.24039000E-03
   -3.80609000E-03  -4.73391000E-03  -2.95399100E-02  -2.80092200E-02  +6.03321000E-03
   +2.28423800E-02  -6.84079000E-03  -9.77489800E-02  +1.71094500E-02  +2.18392700E-02
   +5.65429000E-03  +4.05904000E-03  -1.00201000E-03  -1.01486000E-03  -1.27639000E-03
   -4.66140000E-04  -1.74220000E-04  -7.78250000E-04  +2.40580000E-03  +8.66750000E-04
   +1.42242600E-01  +5.18610100E-02  +5.32860490E-01  -2.39745000E-03  -4.57846000E-03
   +3.03434000E-03  -9.24840000E-04  +9.25500000E-05  -9.69000000E-06  -2.82137000E-03
   -7.56320000E-04  +3.94204000E-03  +4.44709000E-03  +1.78075200E-02  +1.61791700E-02
   -5.60979400E-02  -2.59524100E-02  -1.29861400E-02  +2.33884000E-03  -1.97431300E-02
   -1.82250600E-02  -4.97700000E-05  +1.80560000E-04  -2.34290000E-04  +4.25860000E-04
   +7.21170000E-04  +9.49220000E-04  +1.50417000E-03  +8.61090000E-04  -1.64282000E-03
   +5.42621700E-02  -5.00609000E-03  +2.12434000E-03  -2.20791000E-03  -9.07000000E-06
   -3.02400000E-04  +9.17440000E-04  -2.56150000E-04  +2.58698000E-03  -1.53934000E-03
   -1.55461000E-03  -1.59587000E-03  -2.39008000E-03  -2.80574100E-02  -1.99898000E-01
   -1.48987340E-01  +8.95110000E-04  -6.71639000E-03  -1.32369600E-02  +1.94550000E-04
   -3.35010000E-04  +2.00920000E-04  -1.68300000E-04  +3.58600000E-05  -1.54490000E-04
   +1.53903000E-03  -1.88630000E-04  +1.18379000E-03  +3.09031400E-02  +2.05284130E-01
   +2.20060000E-03  -1.95553000E-03  +4.45726000E-03  +5.94170000E-04  +1.05828000E-03
   -5.00760000E-04  +4.43779000E-03  -1.81481000E-03  -6.64000000E-04  -6.64485000E-03
   -1.67204400E-02  -9.39216000E-03  -9.15486000E-03  -1.51308650E-01  -1.83209980E-01
   +9.36310000E-04  +8.27620000E-04  +4.58712000E-03  -2.24630000E-04  +2.56330000E-04
   -2.57250000E-04  -1.69910000E-04  -8.03920000E-04  -5.68840000E-04  -1.86745000E-03
   +2.55338000E-03  +1.39734000E-03  +1.08754800E-02  +1.65239870E-01  +1.85706460E-01
   +5.69174000E-03  -3.85870000E-04  -2.43111000E-03  +1.79200000E-03  -2.00971000E-03
   +4.48760000E-04  -7.69400000E-05  +1.36190000E-04  -4.35320000E-04  -4.48720000E-04
   -5.59531000E-03  -1.71230000E-04  -1.44527000E-02  +5.31131000E-03  +1.80915000E-02
   -2.00722900E-01  +2.58126900E-02  +1.42503240E-01  +2.73400000E-04  -1.74760000E-04
   -1.71350000E-04  -1.52220000E-04  +2.10350000E-04  -9.83400000E-05  -1.58831000E-03
   +5.61900000E-05  +1.14904000E-03  -2.00350000E-04  +1.50818000E-03  -1.74270000E-03
   +2.10958010E-01  +1.73955900E-02  +1.57178000E-03  -1.43140500E-02  -2.51131000E-03
   -8.13990000E-04  -5.42894000E-03  -5.62320000E-04  -1.13061000E-03  +1.17780000E-04
   -4.52063000E-03  +1.10894000E-03  -2.95551000E-03  -1.52281600E-02  +6.95868000E-03
   +1.33737000E-02  +2.64855300E-02  -5.85162100E-02  -3.95090900E-02  +8.45780000E-04
   +4.69200000E-05  -9.16450000E-04  +2.56190000E-04  -2.60910000E-04  +2.85500000E-04
   -6.20840000E-04  -1.15920000E-04  +5.88100000E-04  +1.84206000E-03  -1.50577000E-03
   +2.10130000E-03  -2.39050400E-02  +5.42495100E-02  +1.62792600E-02  -2.25303000E-03
   -1.07770300E-02  +3.23140000E-04  -5.49629000E-03  +4.83500000E-05  -9.35110000E-04
   +3.64520000E-04  -3.81300000E-05  +1.06072000E-03  -3.46477000E-03  +3.66285000E-03
   -1.39532000E-03  -9.39950000E-04  +3.86687000E-03  +1.41458080E-01  -3.84348000E-02
   -1.79184590E-01  +8.62480000E-04  -3.35200000E-05  -6.08360000E-04  -1.31010000E-04
   +3.38780000E-04  -2.30030000E-04  -3.90520000E-04  +1.81790000E-04  +2.77580000E-04
   -1.46732000E-03  +2.46277000E-03  -1.42555000E-03  -1.55592650E-01  +4.53033900E-02
   +1.84660360E-01  -1.40638120E-01  -4.38818500E-02  +9.51203000E-03  -1.63170400E-02
   -1.32163000E-02  +3.21566000E-03  +5.14080000E-04  -7.87630000E-04  +3.53777000E-03
   -1.52418000E-03  -3.38000000E-06  +8.55530000E-04  +3.89960000E-03  +7.65410000E-04
   +1.25601000E-03  -3.80968000E-03  -9.72107000E-03  -5.38638000E-03  -4.41400000E-05
   +6.30700000E-04  -2.11590000E-03  -2.92430000E-04  -3.18450000E-04  -2.32460000E-04
   +7.85240000E-04  +1.02567000E-03  -1.63790000E-04  +3.88140000E-04  +2.89930000E-04
   +2.15650000E-04  -7.41610000E-04  +1.46499000E-03  +2.69430000E-04  +4.74309620E-01
   -4.60368300E-02  -1.09342380E-01  -6.52220000E-03  -1.10527000E-03  +7.37866000E-03
   +2.86476000E-03  +5.15740000E-04  +2.80265000E-03  -4.25190000E-03  -2.34330000E-04
   -4.94260000E-04  -2.94140000E-04  -4.56660000E-04  +3.91500000E-04  -4.18689000E-03
   -2.03497800E-02  -1.39435100E-02  -7.78090000E-04  +1.30665000E-03  -2.15501000E-03
   +3.68560000E-04  +7.39680000E-04  +2.96750000E-04  +1.19790000E-04  +3.89860000E-04
   +4.86600000E-05  +1.91870000E-04  -5.35540000E-04  -2.50270000E-04  +1.93500000E-05
   +3.28450000E-04  -8.34530000E-04  +1.71488000E-03  +1.88680000E-04  +4.79716160E-01
   +4.66073000E-03  -9.44247000E-03  -8.32599000E-02  +1.53301000E-02  +1.20230300E-02
   +4.80086000E-03  +3.85950000E-03  -3.00004000E-03  -5.48760000E-04  +1.25726000E-03
   -1.23466000E-03  -1.44080000E-04  +5.68400000E-05  -5.70425000E-03  -1.90061000E-03
   -1.81583200E-02  -1.08374700E-02  +5.97742000E-03  -1.04297000E-03  +1.12072000E-03
   -1.38643000E-03  +6.38620000E-04  +5.75180000E-04  +6.18900000E-05  -1.59560000E-04
   +9.58070000E-04  -5.89000000E-05  -1.10903000E-03  -6.71120000E-04  +7.92000000E-06
   -7.81240000E-04  +1.03364000E-03  -1.08326000E-03  +8.86540000E-04  +4.13903000E-03
   +4.79426690E-01  -3.54654900E-02  +9.79426000E-03  +5.66169000E-03  -9.68960000E-04
   -9.14110000E-04  -1.86025000E-03  -2.47530000E-04  -7.05490000E-04  +8.47700000E-04
   -3.49870000E-04  +4.86900000E-05  +2.07020000E-04  +7.80610000E-04  +8.80670000E-04
   +5.15440000E-04  -1.48371000E-03  -1.47770000E-04  -8.25780000E-04  -1.78790000E-04
   +2.34120000E-04  -1.82800000E-04  -4.73200000E-05  -1.57810000E-04  +4.54100000E-05
   +6.29500000E-05  +6.67200000E-05  +5.55100000E-05  +6.55400000E-05  +2.44360000E-04
   -1.31330000E-04  -7.87950000E-04  -4.56300000E-04  -1.82040000E-04  -1.39996680E-01
   +4.70565100E-02  +7.91526000E-03  +5.38999350E-01  -9.30623000E-03  +1.40033600E-02
   +2.79479000E-03  -1.77232000E-03  -2.84031000E-03  -5.81510000E-04  -3.65620000E-04
   -4.69520000E-04  +1.05764000E-03  -5.47490000E-04  +9.85770000E-04  -3.01720000E-04
   +1.03264000E-03  +1.26040000E-04  -1.45300000E-04  -3.26792000E-03  -1.38632000E-03
   -7.99590000E-04  -6.28300000E-05  +3.52010000E-04  -1.14120000E-04  -2.70880000E-04
   -1.83220000E-04  -3.02300000E-05  -2.53760000E-04  -6.00190000E-04  +1.39320000E-04
   -7.58300000E-05  -6.23500000E-05  -1.08200000E-05  -8.29620000E-04  -3.24800000E-05
   -3.27930000E-04  +4.36654300E-02  -1.09142980E-01  +6.33494000E-03  -1.24219670E-01
   +4.46534360E-01  +5.85026000E-03  -1.80140000E-03  -1.38352000E-03  +1.51160000E-04
   +6.40530000E-04  +3.00910000E-04  +2.19640000E-04  +3.24880000E-04  -1.72350000E-04
   +4.92900000E-05  -9.55300000E-05  -2.02080000E-04  -3.49350000E-04  +2.57880000E-04
   +5.44000000E-06  -1.64477000E-03  -7.39080000E-04  +1.85640000E-04  -1.59400000E-04
   -2.25580000E-04  +1.79100000E-04  +5.86800000E-05  +4.04700000E-05  +4.50000000E-07
   -4.16900000E-05  -8.61700000E-05  +1.16210000E-04  -5.42000000E-06  +5.90000000E-07
   +2.84000000E-06  -6.91710000E-04  -9.75700000E-05  +1.93540000E-04  +1.09886600E-02
   +3.69405000E-03  -8.26234200E-02  -1.53415440E-01  -1.80033860E-01  +5.06870960E-01
   -6.41100000E-05  -1.71079100E-02  +2.26756700E-02  -1.78866000E-03  -1.58421000E-03
   -7.82820000E-04  -8.15360000E-04  +7.94250000E-04  -4.70230000E-04  -1.10213000E-03
   +1.12844000E-03  -9.21300000E-04  +1.28424000E-03  +8.06410000E-04  +3.06000000E-05
   -1.44652000E-03  -2.14184000E-03  +2.21690000E-04  +2.83600000E-04  -4.07880000E-04
   +5.44920000E-04  -1.10810000E-04  -1.28610000E-04  +4.68600000E-05  -2.02810000E-04
   -7.99490000E-04  +2.32560000E-04  +3.54500000E-05  -4.87000000E-05  +1.78100000E-05
   -1.05700000E-04  -1.40450000E-04  -1.59500000E-05  -7.58881700E-02  +2.49833000E-03
   -3.58387000E-03  -3.54169000E-03  +1.83829200E-02  -2.35499700E-02  +5.83338680E-01
   -6.86679000E-03  -1.91262800E-02  +1.87547200E-02  +1.18497000E-03  -8.78080000E-04
   -8.32130000E-04  -7.18990000E-04  +2.11500000E-05  -6.98480000E-04  -4.26960000E-04
   +6.77560000E-04  -7.85600000E-05  +5.90020000E-04  +8.21810000E-04  +3.28000000E-05
   -8.95140000E-04  -9.08750000E-04  +6.74430000E-04  -2.90300000E-05  -1.96010000E-04
   +1.44040000E-04  -3.71400000E-05  +5.08000000E-06  -2.15200000E-05  -8.85300000E-05
   -4.38940000E-04  +5.65400000E-05  +1.21850000E-04  -4.35300000E-05  +5.29100000E-05
   -1.48970000E-04  -5.38870000E-04  +3.42900000E-05  +8.89438000E-03  -1.09477690E-01
   +4.78729100E-02  +6.67704000E-03  -1.51053300E-02  +1.67527300E-02  +9.10913000E-03
   +5.37576680E-01  +8.44213000E-03  +9.68994000E-03  -3.90723000E-03  -1.17057000E-03
   -2.08930000E-04  +1.55410000E-04  +2.78040000E-04  +5.32300000E-05  +2.40480000E-04
   -7.12900000E-04  +5.00890000E-04  -4.25790000E-04  +1.02924000E-03  +2.14200000E-05
   -2.95880000E-04  -2.07013000E-03  -1.80603000E-03  -5.26280000E-04  -1.16400000E-04
   +8.36300000E-05  -2.72600000E-05  -6.90700000E-05  -5.07300000E-05  -1.35600000E-05
   +1.13500000E-05  -2.72770000E-04  +9.89000000E-05  -1.12610000E-04  +5.37000000E-06
   -4.61600000E-05  +1.40660000E-04  -4.19230000E-04  -5.72600000E-05  -1.00578100E-02
   +4.37651700E-02  -1.35491640E-01  -4.28187000E-03  +6.72760000E-04  +2.01475000E-03
   -1.33195900E-02  +6.41499200E-02  +5.13601360E-01  -3.63872000E-03  -1.74974900E-02
   -2.40681000E-02  -1.58120000E-03  -8.06870000E-04  -5.73410000E-04  +3.47300000E-04
   -2.26360000E-04  -5.29050000E-04  -9.76700000E-05  +2.69660000E-04  -2.32540000E-04
   +7.38820000E-04  -1.11997000E-03  -9.71120000E-04  -4.83497000E-03  -2.74106000E-03
   +1.47830000E-03  -2.53795000E-03  -2.70156000E-03  -3.92380000E-04  -1.94400000E-05
   +8.62200000E-05  -2.14100000E-05  -2.45420000E-04  -2.91800000E-04  +1.05570000E-04
   -4.01370000E-04  -2.09190000E-04  -4.39500000E-05  -4.20100000E-05  +1.25670000E-04
   -2.21710000E-04  -7.67973700E-02  -3.28273000E-03  -4.78006000E-03  -1.13516000E-03
   +1.72406500E-02  +2.31924700E-02  +1.30830000E-04  -1.19878000E-03  -3.82497000E-03
   +5.85717890E-01  -6.90208000E-03  -1.49593300E-02  -1.73572800E-02  -2.10500000E-05
   -6.06840000E-04  +8.36730000E-04  +5.28490000E-04  -4.95280000E-04  -6.94240000E-04
   -6.73000000E-05  +9.63000000E-06  +3.79000000E-06  +1.11590000E-04  -5.85730000E-04
   -6.52720000E-04  -2.97267000E-03  -2.51600000E-04  +6.35670000E-04  -1.36299000E-03
   -6.38200000E-04  -8.02160000E-04  +8.12100000E-05  +5.67200000E-05  +3.04300000E-05
   -6.56600000E-05  -9.08000000E-06  -3.34300000E-05  -1.33830000E-04  -1.73280000E-04
   +5.77200000E-05  +1.53110000E-04  +1.56200000E-05  +3.23200000E-05  -7.77803000E-03
   -1.07658640E-01  -4.76256000E-02  +6.65729000E-03  -1.81157900E-02  -1.87685300E-02
   +1.46555000E-03  +1.06400700E-02  +1.49832300E-02  -8.63700000E-03  +5.42006410E-01
   -4.85728000E-03  -1.18551000E-03  +1.82265000E-03  +1.53868000E-03  +9.53490000E-04
   -7.97900000E-05  -1.42700000E-05  -1.85010000E-04  -3.11240000E-04  +9.54400000E-05
   -1.55620000E-04  +4.89280000E-04  +1.83120000E-04  +3.62440000E-04  +2.10730000E-04
   +1.53558000E-03  +1.03463000E-03  -8.22600000E-05  +9.72280000E-04  +4.31910000E-04
   +4.39740000E-04  +4.58300000E-05  +6.36700000E-05  -3.27700000E-05  +9.71700000E-05
   +1.72600000E-04  -9.80800000E-05  +1.37770000E-04  +1.13870000E-04  +1.52800000E-05
   -5.73400000E-05  +7.84000000E-05  +3.07000000E-06  -9.36557000E-03  -4.43065400E-02
   -1.40354770E-01  +7.56596000E-03  -8.96886000E-03  -4.31197000E-03  -3.77006000E-03
   -1.37680600E-02  -3.68731900E-02  -1.29496000E-02  -6.22773900E-02  +5.12680590E-01
   -1.21758000E-03  +1.55027000E-03  +3.96580000E-04  -7.92900000E-04  -7.69170000E-04
   +1.28380000E-04  +1.45060000E-04  +1.39380000E-04  +2.38830000E-04  +2.77660000E-04
   -1.18260000E-04  -1.13540000E-04  -6.01470000E-04  -3.74840000E-04  +2.20310000E-04
   +9.05930000E-04  +2.88820000E-04  +5.28430000E-04  -1.05700000E-05  +7.24900000E-05
   -3.49600000E-05  -6.14200000E-05  -1.56100000E-05  -1.21400000E-05  -3.86300000E-05
   +8.56000000E-06  -4.90900000E-05  +1.90300000E-05  -3.91600000E-05  +2.98800000E-05
   -1.51770000E-04  -2.38100000E-05  -4.21030000E-04  -1.75463300E-02  +3.52140000E-04
   +1.51130400E-02  -2.16956060E-01  +2.48858100E-02  +9.50541900E-02  -1.04976000E-03
   -1.19670000E-04  +1.12468000E-03  -7.22300000E-04  -1.41920000E-03  -7.79550000E-04
   +5.57265870E-01  +7.10210000E-04  -2.42969000E-03  -7.49930000E-04  +7.42750000E-04
   +8.13090000E-04  -6.55200000E-05  -9.18300000E-05  -1.10670000E-04  -2.51070000E-04
   -1.61960000E-04  -3.21000000E-06  +1.38580000E-04  +3.18460000E-04  +2.95500000E-04
   -4.64800000E-05  -5.16070000E-04  -2.80700000E-05  -1.50680000E-04  -2.16700000E-05
   -9.08500000E-05  +7.13900000E-05  +7.56100000E-05  +1.89300000E-05  +1.70000000E-05
   +7.45500000E-05  +7.49800000E-05  +2.62500000E-05  +7.88000000E-06  +4.77800000E-05
   -2.46300000E-05  -1.08140000E-04  -4.45500000E-05  +2.50510000E-04  +1.28137900E-02
   +6.00829000E-03  -1.31605000E-02  -1.68797600E-02  -1.07461910E-01  +5.83682300E-02
   +6.39820000E-04  -4.20200000E-04  -8.92530000E-04  +1.89317000E-03  -1.11215000E-03
   +5.43600000E-05  -1.73087330E-01  +4.86840660E-01  -1.90512000E-03  +9.76100000E-04
   +2.23970000E-04  +4.37900000E-05  -7.53600000E-05  +2.60300000E-05  -1.08060000E-04
   -2.64280000E-04  +1.83050000E-04  -3.20900000E-04  +2.88600000E-04  -1.17560000E-04
   +6.08930000E-04  +3.80080000E-04  +7.80000000E-05  -1.00026000E-03  -5.52830000E-04
   -8.65620000E-04  -3.51400000E-05  +7.80200000E-05  -1.86000000E-05  -4.19300000E-05
   -6.22000000E-06  -2.16000000E-06  -1.07770000E-04  -1.84370000E-04  +1.15590000E-04
   -4.07500000E-05  +4.44400000E-05  -7.08400000E-05  -7.72500000E-05  -1.48100000E-05
   +3.59970000E-04  +3.00915000E-03  -3.62509000E-03  +3.16001000E-03  +1.40933480E-01
   +2.58900400E-02  -2.08958510E-01  -5.97220000E-04  -6.24910000E-04  +4.93000000E-05
   -7.37270000E-04  +7.95830000E-04  +3.87800000E-05  -1.47785420E-01  -2.40609050E-01
   +5.27049540E-01  +8.67000000E-06  +7.02360000E-04  +1.86860000E-04  +8.67600000E-05
   +2.38000000E-05  -1.64380000E-04  -1.36100000E-05  -9.70700000E-05  +2.80900000E-05
   -1.78820000E-04  +2.93920000E-04  -8.83600000E-05  +5.17550000E-04  +9.09300000E-05
   -1.59960000E-04  -4.79370000E-04  -1.28790000E-04  -1.58770000E-04  +4.29000000E-05
   +1.41300000E-05  -1.45400000E-05  -1.18100000E-05  -1.28900000E-05  +9.30000000E-07
   -5.99300000E-05  -1.58980000E-04  +3.46200000E-05  -3.00900000E-05  +3.21000000E-06
   -1.54200000E-05  -1.44500000E-04  -1.27160000E-04  +2.00000000E-05  +1.18291000E-03
   -2.47300000E-05  +4.17889000E-03  -4.18326000E-02  -7.21291000E-03  +4.75070900E-02
   +1.17140000E-04  -5.28800000E-04  +2.04160000E-04  -1.55816000E-03  +8.93300000E-04
   -5.93500000E-05  -2.53037640E-01  +1.43176350E-01  -1.46620000E-04  +5.91156570E-01
   +6.81410000E-04  -1.25856000E-03  -3.80190000E-04  -2.14800000E-05  +3.45300000E-05
   +3.05010000E-04  +6.54300000E-05  +2.22380000E-04  -9.39800000E-05  +3.19960000E-04
   -5.12930000E-04  +1.35810000E-04  -7.81190000E-04  -2.11820000E-04  +1.69820000E-04
   +9.29470000E-04  +3.68690000E-04  +1.53910000E-04  -2.31700000E-05  -3.68500000E-05
   +3.48300000E-05  +2.68700000E-05  +3.05900000E-05  -1.12000000E-06  +1.06660000E-04
   +2.98010000E-04  -7.92800000E-05  +6.72900000E-05  -1.96900000E-05  +4.75000000E-05
   +1.42960000E-04  +8.30700000E-05  -1.68000000E-04  +8.79300000E-04  +3.25908000E-03
   +2.81711000E-03  +2.50589900E-02  +3.51089500E-02  -5.02817100E-02  +4.27500000E-04
   -4.10020000E-04  -5.71500000E-05  -6.39600000E-05  -2.22270000E-04  +3.64320000E-04
   +1.00989870E-01  -1.71534410E-01  +4.05331100E-02  -1.73534410E-01  +4.52700360E-01
   +8.09780000E-04  -5.67610000E-04  -2.36980000E-04  +2.12880000E-04  +2.29620000E-04
   +5.77800000E-05  -4.82400000E-05  -5.33300000E-05  -7.59500000E-05  -3.05900000E-05
   +1.44070000E-04  -3.33400000E-05  +1.68850000E-04  +1.02360000E-04  +1.45100000E-05
   -9.13700000E-05  -2.37820000E-04  -2.82830000E-04  +1.70900000E-05  +7.52000000E-06
   -5.66000000E-06  +7.81000000E-06  +1.16400000E-05  +4.24000000E-06  -8.30400000E-05
   -1.08040000E-04  +4.82200000E-05  -3.58000000E-06  +1.96500000E-05  -2.73100000E-05
   +3.42700000E-05  +1.44600000E-05  +1.10050000E-04  +3.95612000E-03  +4.03807000E-03
   +2.49180000E-04  +1.20598500E-02  -2.49731800E-02  +2.42413100E-02  -7.19190000E-04
   +6.16650000E-04  -1.44480000E-04  -1.18416000E-03  +9.17000000E-04  -1.13180000E-04
   +4.58131900E-02  +7.03484000E-03  -1.04047510E-01  -1.87460400E-01  -2.20351540E-01
   +5.20018140E-01  -3.82800000E-04  -4.77090000E-04  +1.47810000E-04  +4.74900000E-04
   +3.62050000E-04  -1.31580000E-04  -1.66220000E-04  -1.25940000E-04  -2.06210000E-04
   -3.64200000E-05  -5.48810000E-04  +4.48280000E-04  -2.53200000E-04  -1.64730000E-04
   -2.14140000E-04  +1.55280000E-04  +4.21600000E-04  +3.01110000E-04  -5.36100000E-05
   -1.67400000E-05  +2.32700000E-05  +5.47900000E-05  +2.74000000E-06  +6.29000000E-06
   +4.26310000E-04  +5.12010000E-04  -1.39200000E-04  +4.23900000E-05  +1.87800000E-05
   +2.69200000E-05  -2.69900000E-04  -2.15860000E-04  -3.04940000E-04  -2.24507000E-03
   +3.19930000E-04  +3.20680000E-04  -7.64721000E-03  -1.93853700E-02  +2.37286500E-02
   +4.25300000E-04  +1.69490000E-04  -2.37370000E-04  +5.27240000E-04  -1.06880000E-04
   +9.54100000E-05  +2.19876800E-02  +1.52114800E-02  -3.24800100E-02  -1.21365210E-01
   +5.29314000E-02  -1.56215900E-02  +5.93051600E-01  +6.75300000E-05  +1.22830000E-03
   +1.52280000E-04  -1.75420000E-04  -1.21300000E-04  -6.93300000E-05  +2.74600000E-05
   -1.34560000E-04  +1.40380000E-04  -1.83290000E-04  +6.37240000E-04  -3.07950000E-04
   +6.64790000E-04  +1.97200000E-04  -7.90000000E-06  -5.76780000E-04  -5.69400000E-04
   -3.76020000E-04  +5.32200000E-05  +4.99300000E-05  -4.53200000E-05  -4.39100000E-05
   -1.67500000E-05  -1.52000000E-06  -2.88230000E-04  -4.63210000E-04  +1.20660000E-04
   -6.04400000E-05  +9.91000000E-06  -5.12900000E-05  +6.55900000E-05  -6.74000000E-06
   +1.72350000E-04  -1.03700000E-04  -9.00550000E-04  +9.76730000E-04  -1.76965000E-02
   -2.20727000E-02  +3.21244800E-02  -2.69330000E-04  +4.75900000E-05  +1.10970000E-04
   -9.30950000E-04  +6.48800000E-04  -2.71490000E-04  +5.09661500E-02  -3.28268500E-02
   -2.59219000E-03  +2.80924000E-03  -2.01414970E-01  +1.43587560E-01  -1.68052560E-01
   +4.81307800E-01  +3.61940000E-04  -6.22060000E-04  -3.10020000E-04  -3.43990000E-04
   -1.87050000E-04  +2.51200000E-04  +1.77180000E-04  +2.49880000E-04  +2.50000000E-05
   +2.41420000E-04  -2.66010000E-04  -3.74400000E-05  -5.96740000E-04  -1.99240000E-04
   +1.68040000E-04  +6.55160000E-04  +1.82080000E-04  +3.20270000E-04  +4.49000000E-06
   -3.64400000E-05  +6.37000000E-06  +2.85000000E-06  +1.36800000E-05  -4.91000000E-06
   +1.30000000E-06  +1.04120000E-04  -4.23300000E-05  +2.09700000E-05  -2.71200000E-05
   +3.63400000E-05  +1.78340000E-04  +1.89870000E-04  -6.13900000E-05  +1.20281000E-03
   +2.64940000E-04  -1.76642000E-03  +2.14991200E-02  +3.34913100E-02  -6.00847200E-02
   +5.49400000E-05  +1.00300000E-04  +2.23430000E-04  +6.93150000E-04  -6.46820000E-04
   +4.70120000E-04  -7.24082100E-02  +2.59031800E-02  +3.09886400E-02  +3.96361600E-02
   +1.02800720E-01  -2.14287200E-01  -1.62928040E-01  -2.13295530E-01  +5.29417650E-01
   +4.20380000E-04  -1.92230000E-04  -3.77060000E-04  -4.44960000E-04  -3.40330000E-04
   +2.30490000E-04  +2.51620000E-04  +2.59940000E-04  +9.55600000E-05  +1.38710000E-04
   -5.74000000E-06  -2.15960000E-04  -3.76190000E-04  -1.48910000E-04  +2.13320000E-04
   +4.94590000E-04  -1.95200000E-05  +2.62090000E-04  +8.62000000E-06  -1.58100000E-05
   -1.00100000E-05  -2.61000000E-05  +9.82000000E-06  -1.11200000E-05  -1.23950000E-04
   -1.05910000E-04  +2.15200000E-05  -7.58000000E-06  -2.74900000E-05  +8.56000000E-06
   +2.88140000E-04  +2.86910000E-04  -1.22300000E-05  +4.27786000E-03  +1.38390000E-04
   +8.95800000E-04  +1.66634000E-02  +4.94531100E-02  -6.26715400E-02  +2.75510000E-04
   -2.44940000E-04  +3.99470000E-04  -4.51300000E-05  -1.33640000E-04  +3.62520000E-04
   -5.78993700E-02  +1.49417800E-02  +2.69735100E-02  +4.00507700E-02  -5.16805000E-02
   +3.10966300E-02  -1.94025750E-01  +1.66858900E-02  +8.12233600E-02  +5.77899460E-01
   -5.88310000E-04  -1.33100000E-04  -2.06970000E-04  +1.86950000E-04  +2.47480000E-04
   -2.09100000E-04  +4.65400000E-05  -2.51200000E-05  +5.90000000E-07  -9.94900000E-05
   +1.27290000E-04  -5.41400000E-05  +3.29710000E-04  +1.83110000E-04  -1.27820000E-04
   -3.02390000E-04  +1.24550000E-04  -1.83300000E-04  +2.72000000E-06  -1.90300000E-05
   +1.49300000E-05  +1.52400000E-05  +4.33000000E-06  +4.41000000E-06  -2.62100000E-05
   -4.65200000E-05  +3.60600000E-05  +2.34800000E-05  +8.47000000E-06  +1.55400000E-05
   -6.24800000E-05  -2.46030000E-04  +1.45690000E-04  -6.50300000E-05  +7.43900000E-04
   +5.53402000E-03  +1.76745900E-02  -2.78299800E-02  +2.49312100E-02  +1.12558000E-03
   -5.36470000E-04  -2.86090000E-04  -6.57910000E-04  +7.45660000E-04  +9.54200000E-05
   +1.62929400E-02  -7.04371000E-03  -8.48605000E-03  -2.29035800E-02  +1.33762300E-02
   +1.29055900E-02  -3.15875300E-02  -1.12879630E-01  +7.09750800E-02  -1.96721450E-01
   +5.02322510E-01  +4.92070000E-04  +4.58500000E-05  -5.50000000E-06  +3.31180000E-04
   +1.53230000E-04  -5.42000000E-06  -2.25590000E-04  -1.97010000E-04  -6.82100000E-05
   -8.02700000E-05  -8.16100000E-05  +1.81880000E-04  +1.69770000E-04  +9.90700000E-05
   -1.78820000E-04  -1.99040000E-04  -6.62500000E-05  -9.31800000E-05  -6.01800000E-05
   +5.89500000E-05  +9.93000000E-06  +9.06000000E-06  +3.80000000E-06  +2.90000000E-07
   +1.17810000E-04  +1.43040000E-04  -2.04800000E-05  +2.31500000E-05  +1.53000000E-06
   +2.16200000E-05  -6.62100000E-05  -1.38750000E-04  -3.21400000E-05  +9.04220000E-04
   +4.43002000E-03  -1.57786000E-03  -2.64038100E-02  -6.78280000E-04  +3.10120600E-02
   -9.25430000E-04  +6.61970000E-04  +1.70170000E-04  +1.10760000E-04  +1.09400000E-05
   -2.75030000E-04  +2.63061600E-02  -7.66685000E-03  -1.54547300E-02  -6.30100000E-04
   +3.62067000E-02  -3.10215000E-02  +1.33686570E-01  +3.18718800E-02  -2.14166530E-01
   -1.44688790E-01  -2.47100160E-01  +5.16278020E-01  -6.12720000E-04  +2.84725000E-03
   -1.46234000E-03  +5.81040000E-04  +3.22950000E-04  -4.83890000E-04  -2.02270000E-04
   -3.78110000E-04  +3.37900000E-05  -2.83700000E-04  +2.90660000E-04  -8.08000000E-06
   +7.45420000E-04  +2.87980000E-04  -2.12090000E-04  -1.55923000E-03  -1.75710000E-04
   -8.11740000E-04  -4.56100000E-05  +1.16570000E-04  -1.43700000E-05  -2.44600000E-05
   -1.45000000E-06  -6.50000000E-07  -2.38000000E-06  -1.19370000E-04  +8.14200000E-05
   -1.92300000E-05  +4.08500000E-05  -3.23800000E-05  -3.53460000E-04  -2.45050000E-04
   +7.18500000E-05  -5.08274000E-03  +2.06555700E-02  -1.90117400E-02  -1.17546910E-01
   +1.26738300E-02  +2.51852000E-02  -4.79099000E-03  +3.02705000E-03  +1.51183000E-03
   -5.42170000E-04  +4.14690000E-04  -1.66886000E-03  +4.01603000E-02  -2.41097300E-02
   +1.67995000E-03  -2.28190000E-02  +2.67784000E-02  -1.37535100E-02  -4.63366500E-02
   -7.57486000E-03  +4.72238700E-02  -2.70134090E-01  +1.55170770E-01  -9.35720000E-04
   +6.13038150E-01  -5.64610000E-04  -5.50400000E-04  +5.83240000E-04  +3.36000000E-06
   +3.61400000E-05  +1.56040000E-04  -1.68580000E-04  -1.21430000E-04  +9.49100000E-05
   -4.17000000E-06  -1.26240000E-04  +4.62000000E-05  +1.38900000E-05  +2.63380000E-04
   +2.28960000E-04  -2.77480000E-04  -4.11740000E-04  -8.03000000E-04  -1.09530000E-04
   +6.99600000E-05  +9.44000000E-06  -1.16100000E-05  +1.29400000E-05  -4.54000000E-06
   -4.02600000E-05  +5.03600000E-05  +6.12900000E-05  -8.61000000E-06  +4.85500000E-05
   -4.62100000E-05  -1.07790000E-04  +3.09540000E-04  +3.93830000E-04  +9.03261000E-03
   -1.52532000E-02  +1.09183200E-02  +5.43996700E-02  -1.98064180E-01  +9.46416800E-02
   +2.36342000E-03  -4.43800000E-04  -9.35510000E-04  +9.56970000E-04  -4.83250000E-04
   +1.10124000E-03  -5.67011800E-02  +1.18939800E-02  +4.11595100E-02  +3.02437200E-02
   -4.39637300E-02  +2.04015800E-02  +2.78160600E-02  +3.71632900E-02  -6.04960900E-02
   +1.12621940E-01  -1.83767610E-01  +4.44388200E-02  -1.70716470E-01  +4.58347530E-01
   -4.58810000E-04  +2.18500000E-05  +4.84650000E-04  +2.85070000E-04  +2.06460000E-04
   -6.41680000E-04  +9.93800000E-05  +1.80280000E-04  -1.29210000E-04  -1.31110000E-04
   +1.43340000E-04  -9.30000000E-06  +3.65990000E-04  +1.05580000E-04  -1.57730000E-04
   -6.83690000E-04  +5.80870000E-04  -9.46700000E-05  +9.04500000E-05  -1.47400000E-04
   +6.53900000E-05  +4.90000000E-05  -3.53700000E-05  +2.05700000E-05  +3.46700000E-05
   -1.61500000E-05  -1.57700000E-05  +1.59900000E-05  +6.59000000E-06  +1.62600000E-05
   -3.29630000E-04  -2.77990000E-04  -1.84160000E-04  -4.81961000E-03  +5.55200000E-05
   +5.74197000E-03  -2.15504000E-02  +1.27972500E-01  -1.93466260E-01  +1.61468000E-03
   -6.87150000E-04  -1.47320000E-04  +8.30770000E-04  -1.10479000E-03  -9.67800000E-05
   +3.71870700E-02  +1.53133000E-02  -3.80348500E-02  -1.74428800E-02  +2.32622800E-02
   -1.48324500E-02  +8.31451000E-03  -3.22197000E-02  +3.05949300E-02  +4.54570200E-02
   +1.03458200E-02  -1.08138780E-01  -1.83604040E-01  -2.01926410E-01  +5.10246300E-01
   -2.33540000E-04  +7.61100000E-05  -1.00890000E-04  +4.36000000E-06  +4.22000000E-06
   -2.79200000E-05  +2.58300000E-05  +1.24500000E-05  +1.63000000E-05  -3.47500000E-05
   -7.15400000E-05  +3.04800000E-05  -1.26600000E-05  -6.63000000E-06  -6.90800000E-05
   -3.79000000E-05  +1.33370000E-04  +8.44400000E-05  -4.78000000E-06  -1.16900000E-05
   +2.37000000E-06  +6.68000000E-06  -2.94000000E-06  -3.90000000E-07  +5.91800000E-05
   +6.78700000E-05  -1.52200000E-05  +5.63000000E-06  -1.35000000E-06  +9.25000000E-06
   +5.93500000E-05  -8.23000000E-05  +8.87000000E-06  -2.64410000E-04  -1.47762000E-03
   -1.33587000E-03  +7.93956000E-03  -1.54758500E-02  +1.41797700E-02  -2.52673000E-03
   +1.38552000E-03  +1.01214000E-03  +3.71900000E-04  -9.30000000E-06  -1.04270000E-04
   -5.76149800E-02  +2.48790200E-02  -1.20394000E-02  +1.08367000E-03  +1.88623400E-02
   -1.87439800E-02  -1.98907000E-03  +4.66062000E-03  +2.62037000E-03  -1.31040000E-03
   -3.75000000E-05  +1.11040000E-04  -1.59164000E-03  +1.27966000E-03  +5.39614000E-03
   +5.91076000E-02  -2.32150000E-04  +4.30090000E-04  +2.70740000E-04  -1.06180000E-04
   -1.14830000E-04  -6.16300000E-05  +9.75000000E-06  -9.40000000E-07  +3.17100000E-05
   -6.08900000E-05  +5.96600000E-05  -2.44000000E-05  +9.11200000E-05  -1.14100000E-05
   -7.27100000E-05  -1.67460000E-04  +9.71000000E-06  +9.71300000E-05  +1.17400000E-05
   -1.78000000E-06  -1.09900000E-05  -9.83000000E-06  -1.05400000E-05  -2.07000000E-06
   +9.96000000E-06  -2.93900000E-05  -3.22000000E-06  -1.00900000E-05  -1.13800000E-05
   +7.30000000E-06  -8.15000000E-06  -8.85300000E-05  +3.02800000E-05  -7.69420000E-04
   -2.33776000E-03  -1.27768000E-03  +6.72800000E-04  +1.17197000E-03  +3.05491000E-03
   +2.68285000E-03  -6.55230000E-04  -4.80030000E-04  +4.30230000E-04  -2.24500000E-04
   -9.90500000E-05  +2.45643400E-02  -1.90590570E-01  +1.48425150E-01  +3.98650000E-04
   -9.15943000E-03  +1.35613800E-02  +4.87233000E-03  +2.69620000E-03  +1.41551000E-03
   -1.54750000E-04  -2.45560000E-04  -9.62920000E-04  +1.17197000E-03  +3.69506000E-03
   +2.58937000E-03  -3.39340700E-02  +1.99496960E-01  -1.93560000E-04  +1.90900000E-04
   +1.89460000E-04  -6.50200000E-05  -8.80300000E-05  -9.78000000E-06  +4.30000000E-06
   -1.22700000E-05  +6.10000000E-06  -1.05600000E-05  +6.03100000E-05  -2.66600000E-05
   +2.09100000E-05  -1.38200000E-05  +5.04000000E-06  -3.05000000E-05  -3.78300000E-05
   +6.46600000E-05  +1.60000000E-06  +1.05900000E-05  -1.59700000E-05  -8.87000000E-06
   -1.54000000E-06  -2.54000000E-06  -1.54300000E-05  -4.81500000E-05  +2.43000000E-06
   -6.99000000E-06  -4.58000000E-06  -1.74000000E-06  -6.30000000E-07  +2.38600000E-05
   -3.06700000E-05  -2.35863000E-03  -5.35440000E-04  -1.50544000E-03  -3.82715000E-03
   +1.62257800E-02  -1.04718100E-02  -3.26770000E-04  +7.02700000E-04  +4.38500000E-04
   +6.17170000E-04  -2.03110000E-04  -2.55900000E-05  -1.15044300E-02  +1.48364480E-01
   -1.93016490E-01  +1.54220000E-03  -1.29951000E-03  +3.68985000E-03  +2.35708000E-03
   +1.58651000E-03  +3.88419000E-03  +2.23990000E-04  -1.05569000E-03  -2.52860000E-04
   +5.52106000E-03  +2.30696000E-03  -1.35040000E-04  +1.10577900E-02  -1.63755080E-01
   +1.98565600E-01  +4.38800000E-05  +2.97790000E-04  +6.67000000E-05  -1.09180000E-04
   -1.05730000E-04  -1.15100000E-05  +2.74200000E-05  +1.42300000E-05  +4.34400000E-05
   -1.64500000E-05  +8.13000000E-05  -6.34500000E-05  +4.74200000E-05  -1.90000000E-07
   +5.51000000E-06  -7.09900000E-05  -6.28400000E-05  -7.41000000E-06  +1.45100000E-05
   +9.13000000E-06  -1.14500000E-05  -1.28900000E-05  -5.22000000E-06  -2.32000000E-06
   -4.60900000E-05  -7.32900000E-05  +1.18300000E-05  -1.75000000E-05  -8.46000000E-06
   -3.09000000E-06  +1.01300000E-05  +2.85900000E-05  +2.58500000E-05  -1.16030000E-04
   -5.43570000E-04  +9.53550000E-04  -1.31831000E-03  +5.44956000E-03  +6.40130000E-04
   -3.34000000E-05  -1.00480000E-04  +4.59500000E-05  -2.57910000E-04  +1.04230000E-04
   -8.57200000E-05  -1.34139700E-02  -5.93629000E-03  +1.91526200E-02  -1.82340660E-01
   -1.84625400E-02  +1.42062230E-01  +2.74289000E-03  +3.73902000E-03  -2.88411000E-03
   +2.47267000E-03  +2.09847000E-03  +3.64850000E-04  -3.75660000E-04  +3.04330000E-04
   -8.88140000E-04  -2.59850000E-04  -1.44286000E-03  -1.58749000E-03  +1.91074330E-01
   +1.75760000E-04  -2.72360000E-04  -5.49000000E-05  +3.98500000E-05  +4.48400000E-05
   +1.15700000E-05  +4.63000000E-06  +2.12000000E-05  -3.15500000E-05  +2.15700000E-05
   -4.68800000E-05  +2.65000000E-05  -5.08600000E-05  -4.30000000E-06  -7.31000000E-06
   +3.04800000E-05  +3.82400000E-05  +4.38900000E-05  +3.45000000E-06  -1.17100000E-05
   +2.07000000E-06  +8.21000000E-06  +4.09000000E-06  -5.00000000E-08  +1.96100000E-05
   +2.77700000E-05  -1.09900000E-05  -9.50000000E-07  -3.30000000E-07  +3.33000000E-06
   +1.59000000E-06  +7.46000000E-06  +3.37000000E-06  +5.21630000E-04  +5.35870000E-04
   -3.92810000E-04  +4.93785000E-03  +9.53710000E-04  +2.30142000E-03  -6.79700000E-05
   +3.78500000E-05  -6.16200000E-05  +6.43600000E-05  +3.99400000E-05  +5.10500000E-05
   +1.26389100E-02  +6.01068000E-03  -1.46230700E-02  -1.85529100E-02  -5.44822200E-02
   +3.91487200E-02  -1.59377800E-02  +1.72266000E-03  +1.57927200E-02  +2.47426000E-03
   -7.95020000E-04  +5.15844000E-03  +5.08720000E-04  -1.35407000E-03  -5.22900000E-05
   -1.75875000E-03  -1.23266000E-03  -1.81964000E-03  +1.75369300E-02  +4.96343700E-02
   +8.83200000E-05  -1.17460000E-04  -1.83700000E-05  +2.96500000E-05  +1.67000000E-05
   +1.44000000E-05  -5.44000000E-06  +4.79000000E-06  -1.93300000E-05  +1.23500000E-05
   -5.10000000E-05  +3.27400000E-05  -4.65600000E-05  -1.44800000E-05  -1.25700000E-05
   +2.47600000E-05  +3.49100000E-05  +3.19900000E-05  -7.80000000E-07  -2.45000000E-06
   +2.00000000E-08  +3.62000000E-06  +3.16000000E-06  -1.00000000E-06  +2.90900000E-05
   +3.56900000E-05  -1.19500000E-05  +1.00000000E-07  -6.00000000E-08  +1.80000000E-06
   -1.20400000E-05  -4.36000000E-06  -1.24100000E-05  -2.89500000E-05  +2.50550000E-04
   +1.94720000E-04  +9.29680000E-04  +1.93305000E-03  +3.87153000E-03  +1.40800000E-05
   -4.11000000E-05  -5.00000000E-05  +6.80000000E-06  +6.26500000E-05  +2.55000000E-06
   -1.20653000E-03  +4.78200000E-04  +2.53740000E-03  +1.42193720E-01  +3.91499400E-02
   -1.91698330E-01  +1.88210600E-02  -3.28480000E-04  -1.07118600E-02  -8.05000000E-05
   +5.50896000E-03  -2.64160000E-04  -1.19203000E-03  +1.64910000E-04  -2.62100000E-04
   -1.24865000E-03  -2.07381000E-03  -8.59160000E-04  -1.56140860E-01  -4.37645400E-02
   +1.98355790E-01  +3.37890000E-04  +1.19481000E-03  -6.95100000E-05  -5.07340000E-04
   -3.74130000E-04  -1.32100000E-05  +1.75560000E-04  +2.85500000E-05  +2.45950000E-04
   -1.05750000E-04  +8.06330000E-04  -5.37570000E-04  +5.61840000E-04  +2.04150000E-04
   +1.54430000E-04  -5.07700000E-04  -6.50600000E-04  -3.60990000E-04  +8.06800000E-05
   +3.92500000E-05  -5.45000000E-05  -7.23500000E-05  -1.87600000E-05  -5.49000000E-06
   -4.92020000E-04  -6.77420000E-04  +1.79660000E-04  -8.00400000E-05  -1.29700000E-05
   -5.70400000E-05  +1.81640000E-04  +2.10360000E-04  +3.37450000E-04  +1.60874000E-03
   -8.34080000E-04  +4.32650000E-04  -1.90851000E-03  +3.34817000E-03  -4.20302000E-03
   -5.71690000E-04  -3.56100000E-05  +3.34900000E-04  -1.25542000E-03  +5.26810000E-04
   -4.40010000E-04  +9.36160000E-04  +1.82070000E-03  +3.40304000E-03  -1.24031900E-02
   +1.76700500E-02  -1.29707000E-03  -2.22523720E-01  +1.35192110E-01  -3.98328000E-03
   -4.37143800E-02  +2.89032100E-02  +9.51398000E-03  +4.27925000E-03  -3.92381000E-03
   +4.75042000E-03  -4.43180000E-04  +4.27300000E-04  -1.14090000E-04  +1.94787000E-03
   -2.73617000E-03  -1.92122000E-03  +4.87591460E-01  -2.74920000E-04  -9.52220000E-04
   +5.76200000E-05  +3.17310000E-04  +2.43870000E-04  +2.32300000E-05  -9.84100000E-05
   +3.18800000E-05  -1.53640000E-04  +8.02600000E-05  -6.13930000E-04  +3.64180000E-04
   -4.43190000E-04  -1.49060000E-04  -1.12550000E-04  +4.20460000E-04  +5.25230000E-04
   +2.68280000E-04  -5.93500000E-05  -3.91200000E-05  +4.97400000E-05  +5.37200000E-05
   +1.14900000E-05  +5.46000000E-06  +3.47680000E-04  +5.19940000E-04  -1.22630000E-04
   +7.57800000E-05  +6.44000000E-06  +5.30800000E-05  -1.20060000E-04  -1.67580000E-04
   -2.19500000E-04  -1.20327000E-03  +2.54770000E-04  -9.47430000E-04  +2.50633000E-03
   -4.48360000E-04  -2.23671000E-03  +4.10020000E-04  -1.27900000E-05  -2.19860000E-04
   +1.00082000E-03  -4.75470000E-04  +3.21570000E-04  -3.15523000E-03  +3.54798000E-03
   +7.30766000E-03  +4.14287800E-02  -2.47490900E-02  +4.51368000E-03  +1.04077550E-01
   -1.59768220E-01  +4.27070600E-02  +5.11268000E-03  +7.66662000E-03  -4.57699000E-03
   +4.30820000E-04  -2.80810000E-04  +5.27666000E-03  +1.19181000E-03  -9.01450000E-04
   +6.10300000E-05  -2.25274000E-03  -3.31900000E-05  -2.64349000E-03  -1.02903520E-01
   +2.34947630E-01  -8.47100000E-05  +5.11000000E-05  +1.03700000E-04  +4.57300000E-05
   +1.91000000E-06  -1.60000000E-06  -5.16200000E-05  -4.16300000E-05  -2.89000000E-06
   +4.49000000E-06  -1.82100000E-05  +3.89200000E-05  +3.63000000E-06  +5.71000000E-06
   -1.32100000E-05  +3.01000000E-06  -7.08000000E-06  -3.02100000E-05  -1.26800000E-05
   +1.43900000E-05  +1.55000000E-06  -2.56000000E-06  +4.30000000E-07  +5.00000000E-08
   +1.62100000E-05  +2.94000000E-05  +1.82000000E-06  +1.12100000E-05  +6.00000000E-06
   -1.77000000E-06  -2.44100000E-05  -2.28500000E-05  -1.31300000E-05  -4.75710000E-04
   -3.47770000E-04  +1.11500000E-05  -2.32294000E-03  -3.57253000E-03  +4.60996000E-03
   +4.63300000E-05  +1.17800000E-05  -5.84600000E-05  +2.63600000E-05  +1.38300000E-05
   -6.06100000E-05  +9.12417000E-03  +3.23207000E-03  -3.02298000E-03  -2.75184300E-02
   +2.39099100E-02  +5.95758000E-03  +3.00640400E-02  +1.75712600E-02  -8.76586100E-02
   +3.55051300E-02  -2.38459800E-02  +4.62886000E-03  +2.23400000E-05  +8.77848000E-03
   -4.76834000E-03  -9.65500000E-04  +6.91350000E-04  +3.52300000E-05  -2.44367000E-03
   -2.28321000E-03  +3.73290000E-04  -2.58734010E-01  -1.44408440E-01  +3.94687220E-01
   +1.41730000E-04  +8.19300000E-05  +4.04000000E-06  -1.25800000E-05  -2.81000000E-05
   -4.96000000E-06  -1.12400000E-05  -3.24100000E-05  +2.84000000E-06  +6.82000000E-06
   +6.16600000E-05  -1.89600000E-05  +1.73900000E-05  -2.09000000E-05  +2.60700000E-05
   -3.72900000E-05  -4.38600000E-05  -2.10000000E-07  +4.01000000E-06  +9.55000000E-06
   -7.90000000E-06  -1.21100000E-05  +2.74000000E-06  -2.86000000E-06  -2.41600000E-05
   -6.02700000E-05  +8.88000000E-06  -1.57200000E-05  -4.00000000E-07  -1.55500000E-05
   +1.54000000E-06  +2.98800000E-05  -3.39000000E-06  +4.35100000E-04  +6.91350000E-04
   -8.83830000E-04  -1.98776000E-03  +4.89368000E-03  +2.65568000E-03  -3.51680000E-04
   +1.21080000E-04  +1.19270000E-04  +1.02400000E-05  -7.38600000E-05  -1.12640000E-04
   -1.43921000E-03  +8.57900000E-05  +2.60710000E-04  -1.83264000E-03  +1.16163000E-03
   +4.58385000E-03  +7.62793000E-03  -1.61120200E-02  +1.54467800E-02  -5.84126400E-02
   +3.08526800E-02  -1.56603200E-02  +1.74463000E-03  +1.81352900E-02  -1.87699600E-02
   -1.07610000E-04  -2.09860000E-04  -2.64750000E-04  +1.58790000E-04  -9.01370000E-04
   +8.12950000E-04  +6.60400000E-04  -1.09152000E-03  -2.02675000E-03  +5.36606000E-02
   -1.96530000E-04  -1.24890000E-04  +1.71500000E-05  +4.68200000E-05  +5.06800000E-05
   -2.64500000E-05  -9.87000000E-06  -6.94000000E-06  -2.44700000E-05  -6.31000000E-06
   -2.54000000E-05  +3.10300000E-05  +3.90000000E-07  -2.73000000E-06  -1.53000000E-06
   -1.53600000E-05  +4.46700000E-05  +4.56000000E-06  +1.53000000E-06  -1.39200000E-05
   +4.54000000E-06  +8.90000000E-06  -1.20000000E-07  +1.75000000E-06  +2.45500000E-05
   +2.43100000E-05  -1.26100000E-05  +1.20000000E-06  +1.69000000E-06  -4.10000000E-07
   -5.03000000E-06  -7.79000000E-06  -1.98900000E-05  -1.02950000E-04  -1.03640000E-04
   +7.47480000E-04  +4.96495000E-03  +2.77224000E-03  +1.50309000E-03  +2.44940000E-04
   -1.62360000E-04  -1.17520000E-04  +5.73700000E-05  -2.05100000E-05  +1.37400000E-05
   -2.04700000E-04  -8.16200000E-05  -7.97100000E-04  +8.41910000E-04  +2.93533000E-03
   +1.99754000E-03  +3.39018000E-03  +2.31700000E-04  +2.56061000E-03  +2.98739800E-02
   -1.96448520E-01  +1.50208840E-01  -4.90100000E-05  -8.55667000E-03  +1.24921200E-02
   -2.32010000E-04  -3.47560000E-04  -2.16660000E-04  -1.24700000E-05  -6.08300000E-05
   -2.34200000E-05  -1.35468000E-03  -8.17940000E-04  -1.65942000E-03  -3.55535400E-02
   +2.02544370E-01  -7.10300000E-05  +2.45300000E-05  +3.14800000E-05  +1.08700000E-05
   +8.72000000E-06  -3.91900000E-05  -3.52000000E-06  -1.75000000E-05  -9.52000000E-06
   -1.54500000E-05  +5.34000000E-05  -9.70000000E-06  +4.62100000E-05  -2.66000000E-06
   +1.88000000E-05  -5.79700000E-05  -2.79800000E-05  -1.26400000E-05  +8.08000000E-06
   -5.88000000E-06  -3.49000000E-06  -1.23000000E-06  -2.10000000E-06  -1.00000000E-08
   -1.50600000E-05  -4.73500000E-05  +1.37000000E-06  -1.47300000E-05  +1.47000000E-06
   -1.43200000E-05  +4.68000000E-06  +2.12900000E-05  -8.54000000E-06  +2.92620000E-04
   +4.60200000E-05  +1.71330000E-04  +2.31383000E-03  +1.91997000E-03  +3.96169000E-03
   -9.39000000E-06  -6.13600000E-05  +5.34000000E-06  -2.88000000E-05  -4.31000000E-06
   -4.91700000E-05  +4.98430000E-04  -1.03690000E-03  -2.24640000E-04  +4.96607000E-03
   +1.69451000E-03  -4.47660000E-04  -5.56251000E-03  +1.82649200E-02  -1.02811300E-02
   -1.47430500E-02  +1.49298150E-01  -1.86373480E-01  +1.02973000E-03  -2.26267000E-03
   +4.53508000E-03  -2.43470000E-04  -2.43010000E-04  -2.62200000E-04  -1.90150000E-04
   +6.92690000E-04  -7.12170000E-04  -1.82958000E-03  -1.81972000E-03  +1.13160000E-04
   +1.57305100E-02  -1.64132620E-01  +1.90763010E-01  -6.43940000E-04  +5.41150000E-04
   -4.37380000E-04  +9.25000000E-06  +9.21500000E-05  -7.47600000E-05  -2.07340000E-04
   -1.42730000E-04  -3.53700000E-05  -1.14230000E-04  -7.57700000E-05  +1.27140000E-04
   +1.63400000E-04  +6.78700000E-05  -2.74100000E-05  -2.63870000E-04  +9.05400000E-05
   -2.21230000E-04  +4.85700000E-05  +1.64500000E-05  +1.37000000E-06  +1.06300000E-05
   -1.14700000E-05  +7.52000000E-06  +8.29600000E-05  +9.56200000E-05  -1.77000000E-05
   +6.69000000E-06  +3.90000000E-07  +7.50000000E-06  +3.24300000E-05  -1.93000000E-05
   +4.61300000E-05  -7.53860000E-04  -5.64750000E-04  -9.07790000E-04  +6.04593000E-03
   +9.38270000E-04  -2.60948000E-03  -2.05400000E-05  -1.38350000E-04  -6.53200000E-05
   -3.21200000E-05  +1.71410000E-04  +1.14580000E-04  +2.26677000E-03  +2.34235000E-03
   +4.97230000E-04  -3.55510000E-04  +2.52340000E-04  -9.02950000E-04  -3.77980000E-04
   +5.44432000E-03  +9.62630000E-04  -1.32943500E-02  -4.95006000E-03  +1.93597800E-02
   -1.88918030E-01  -2.34114900E-02  +1.41335260E-01  +2.53110000E-04  +1.33680000E-04
   -2.43530000E-04  -1.88100000E-04  -2.37110000E-04  -1.33810000E-04  -1.05529000E-03
   -2.32460000E-04  +1.07967000E-03  -2.83160000E-04  -1.55637000E-03  -1.76132000E-03
   +1.97615130E-01  +4.45400000E-04  +3.17400000E-05  +1.17270000E-04  -9.46400000E-05
   -9.47500000E-05  +6.92800000E-05  +1.67180000E-04  +1.01170000E-04  +2.23000000E-06
   +8.22600000E-05  +8.44200000E-05  -1.30930000E-04  -1.96310000E-04  -2.13900000E-04
   +7.69600000E-05  +1.96300000E-04  +2.07410000E-04  +2.46410000E-04  +8.07600000E-05
   -7.53200000E-05  -2.95600000E-05  -1.66200000E-05  +8.56000000E-06  -4.81000000E-06
   -8.57800000E-05  -1.42970000E-04  -5.40000000E-07  -2.34000000E-05  -9.57000000E-06
   -1.90700000E-05  +1.21200000E-05  +3.33900000E-05  -8.82000000E-05  -1.56839000E-03
   -7.56490000E-04  -1.08532000E-03  -1.65914100E-02  +1.91321000E-03  +1.53975400E-02
   -1.24010000E-04  +9.89000000E-06  -1.01620000E-04  +1.48460000E-04  -5.96350000E-04
   +4.09060000E-04  +2.78485000E-03  -6.97650000E-04  +5.36083000E-03  +2.80740000E-04
   -1.04429000E-03  -2.84100000E-04  +5.32618000E-03  +1.49404000E-03  +3.25368000E-03
   +1.41769700E-02  +6.69271000E-03  -1.36096100E-02  -2.39144800E-02  -5.90156700E-02
   +3.88288900E-02  -8.84150000E-04  -7.00600000E-05  +8.47320000E-04  -2.69020000E-04
   -2.40300000E-04  -2.83450000E-04  +6.23860000E-04  +2.58380000E-04  -7.98770000E-04
   -1.96777000E-03  -1.49087000E-03  -1.99568000E-03  +2.09304500E-02  +5.44497800E-02
   -4.28710000E-04  +3.92140000E-04  +1.28810000E-04  -1.15950000E-04  -1.45270000E-04
   +1.82830000E-04  -1.74170000E-04  -4.59200000E-05  -3.25900000E-05  +1.04050000E-04
   -2.19210000E-04  +2.30320000E-04  -2.90350000E-04  -1.43260000E-04  +1.61200000E-05
   +2.29060000E-04  -1.61570000E-04  -4.25800000E-05  +7.36000000E-06  -1.81200000E-05
   -1.94400000E-05  +5.41000000E-06  -6.54000000E-06  +1.05000000E-06  +9.24800000E-05
   +1.58070000E-04  -5.95600000E-05  +6.17000000E-06  +8.55000000E-06  -9.05000000E-06
   +6.56600000E-05  +8.45300000E-05  -1.59400000E-05  +8.67100000E-05  -1.85871000E-03
   -1.12281000E-03  +1.61295400E-02  +2.02861000E-03  -1.05547300E-02  -2.12960000E-04
   -2.65800000E-05  -1.90000000E-05  +4.29000000E-06  -4.70400000E-05  -7.58400000E-05
   +3.38720000E-04  +5.82252000E-03  -2.08630000E-04  -1.05944000E-03  -1.89590000E-04
   -9.60500000E-05  +1.22909000E-03  +3.06309000E-03  +4.31612000E-03  -7.57990000E-04
   +1.47262000E-03  +3.43727000E-03  +1.40877280E-01  +3.78874500E-02  -1.90785670E-01
   +8.54390000E-04  +2.87300000E-05  -6.90710000E-04  -1.22510000E-04  -3.08030000E-04
   -2.82100000E-04  +2.73540000E-04  -1.47430000E-04  -5.55500000E-05  -1.45675000E-03
   -2.32639000E-03  -1.21113000E-03  -1.55614510E-01  -4.49574600E-02  +1.96767330E-01
   +3.08800000E-04  -4.18260000E-04  +1.30600000E-05  +4.64830000E-04  -1.75930000E-04
   -1.07930000E-04  +7.48800000E-05  -2.79000000E-06  -3.00000000E-07  +1.31410000E-04
   +1.62040000E-04  -1.09520000E-04  -1.18520000E-04  -1.72000000E-05  +5.95700000E-05
   +2.64890000E-04  +2.91500000E-04  +3.97490000E-04  -5.09500000E-05  +6.23700000E-05
   -6.31000000E-06  -1.28700000E-05  +2.39000000E-06  -6.70000000E-06  -1.38250000E-04
   -1.80670000E-04  +2.88400000E-05  -2.42800000E-05  -1.55000000E-06  -1.26700000E-05
   -2.53900000E-05  +9.60000000E-07  -2.11900000E-05  +2.48645000E-03  +2.97196000E-03
   -5.49540000E-04  +3.38300000E-05  +1.16100000E-05  +2.93760000E-04  -2.01759250E-01
   -1.31575640E-01  +9.62890000E-03  +3.98030000E-04  +3.62980000E-04  -2.26190000E-04
   -8.73260000E-04  +9.19880000E-04  +6.41250000E-04  +1.12580000E-04  +1.54720000E-04
   -2.30370000E-04  -1.87160000E-04  +1.81500000E-05  +3.52400000E-05  +6.23400000E-05
   -2.59900000E-05  -5.59000000E-06  +1.01790000E-04  -9.40100000E-05  -3.75300000E-05
   -1.23850000E-03  +1.89526000E-03  +5.81500000E-05  +3.36500000E-05  +7.92000000E-06
   +2.19200000E-05  +8.84200000E-05  -3.71700000E-05  -3.62100000E-05  +1.21400000E-05
   -1.82900000E-05  -5.60000000E-06  -5.43000000E-06  -1.27000000E-06  -2.46000000E-06
   +2.19433610E-01  +8.30240000E-04  -1.23438000E-03  +3.83367000E-03  +2.50810000E-04
   -3.91720000E-04  -3.53340000E-04  -5.29100000E-04  -1.42620000E-04  -1.13970000E-04
   -2.93890000E-04  +5.29440000E-04  -4.92500000E-05  +7.13630000E-04  +2.19010000E-04
   -1.53000000E-06  -5.98360000E-04  -5.79180000E-04  +1.08530000E-04  +3.72500000E-05
   -3.77000000E-05  +1.22040000E-04  -7.29900000E-05  -1.10900000E-05  -2.91700000E-05
   -1.42030000E-04  -3.05560000E-04  +6.16500000E-05  -2.12400000E-05  -2.72800000E-05
   -7.41000000E-06  -7.79300000E-05  +1.81980000E-04  -9.94700000E-05  -1.52636000E-02
   -1.28679600E-02  +3.26910000E-04  -6.92070000E-04  +5.80390000E-04  -3.23170000E-04
   -1.30344290E-01  -1.58386100E-01  +7.88975000E-03  -1.11140000E-04  +5.85950000E-04
   -1.49806000E-03  -2.98200000E-05  -4.89260000E-04  +8.02560000E-04  +3.25460000E-04
   +2.07230000E-04  -3.68300000E-04  +6.36200000E-05  -1.57000000E-06  -1.25590000E-04
   -1.73580000E-04  +1.54420000E-04  -1.73100000E-05  +2.83980000E-04  -1.17180000E-04
   +1.55150000E-04  +1.45508000E-03  -1.15740000E-03  -9.83760000E-04  +2.01000000E-06
   -2.92100000E-05  +1.93600000E-05  -1.38490000E-04  +1.56130000E-04  -4.52200000E-05
   -1.06600000E-05  -8.74000000E-06  -1.90300000E-05  -2.80000000E-05  +6.28000000E-05
   -1.24860000E-04  +1.42663540E-01  +1.70847750E-01  -1.92750000E-03  +2.05681000E-03
   -3.68483000E-03  +9.37100000E-04  +5.83240000E-04  +7.06700000E-05  -9.55400000E-05
   -4.20020000E-04  +2.82000000E-05  +1.78820000E-04  -2.12000000E-04  +4.31210000E-04
   +2.30540000E-04  -3.61200000E-05  +1.23200000E-04  +2.61630000E-04  -1.73540000E-04
   +1.38560000E-04  -2.17300000E-05  +1.01500000E-04  -1.32250000E-04  +3.64500000E-05
   +4.79000000E-05  -1.79900000E-05  +7.30300000E-05  +2.76410000E-04  -7.57300000E-05
   +2.55200000E-05  +2.44500000E-05  +1.35000000E-06  -2.28970000E-04  +3.47910000E-04
   -2.47600000E-05  +2.04226200E-02  +1.67915900E-02  -3.02666000E-03  +2.06080000E-04
   -6.77690000E-04  +6.03450000E-04  +9.48074000E-03  +6.93259000E-03  -4.83122500E-02
   +1.18383000E-03  +7.46060000E-04  +1.19235000E-03  -2.48970000E-04  -4.17370000E-04
   +4.39050000E-04  -1.12220000E-04  +1.36510000E-04  -1.16870000E-04  -1.34280000E-04
   -3.06000000E-05  +1.68770000E-04  +1.34890000E-04  -7.12300000E-05  -4.09700000E-05
   -3.82300000E-05  -1.00600000E-05  -2.41200000E-04  +2.89910000E-04  -3.26560000E-04
   +1.30590000E-04  +7.59000000E-06  +4.28000000E-06  +7.63000000E-06  +6.36400000E-05
   -2.42400000E-05  -3.36400000E-05  +2.06500000E-05  +1.29600000E-05  +8.97000000E-06
   +4.07300000E-05  +1.06400000E-05  +3.03400000E-05  -1.09883900E-02  -1.08106700E-02
   +5.12898600E-02  +4.80000000E-06  +5.61280000E-04  +6.61560000E-04  -1.56120000E-04
   -9.94000000E-05  +9.70200000E-05  +1.35120000E-04  +7.08900000E-05  +7.64300000E-05
   -7.07800000E-05  -1.07510000E-04  -1.13200000E-05  -2.31540000E-04  -4.99500000E-05
   -5.16500000E-05  -3.59100000E-05  -1.44950000E-04  -3.28200000E-05  +6.82000000E-06
   +1.21100000E-05  -6.14700000E-05  -2.12000000E-06  +9.41000000E-06  -1.14500000E-05
   +6.00600000E-05  +7.87900000E-05  -2.08900000E-05  +2.11600000E-05  -1.24500000E-05
   +1.39800000E-05  +2.11920000E-04  -1.54430000E-04  +8.36300000E-05  -1.97423000E-03
   -2.10494000E-03  -2.77446000E-03  +3.29720000E-04  -5.09690000E-04  -3.46700000E-04
   -4.77963200E-02  -6.09162000E-03  -9.03984000E-03  -6.92200000E-05  +7.33500000E-04
   -6.63260000E-04  -1.38950000E-04  +4.38180000E-04  -6.24510000E-04  -1.14620000E-04
   -2.49500000E-05  +2.51510000E-04  -8.23700000E-05  -2.68000000E-06  +6.31500000E-05
   +1.29630000E-04  -9.80900000E-05  +6.42000000E-06  -7.93300000E-05  +9.86500000E-05
   -3.92500000E-05  -1.52680000E-03  -9.88700000E-05  -3.06230000E-04  -7.32000000E-06
   -2.43000000E-06  -2.82400000E-05  +1.14270000E-04  -1.14630000E-04  +2.65100000E-05
   +8.37000000E-06  -7.59000000E-06  +8.24000000E-06  -1.83800000E-05  -5.51000000E-05
   +5.44900000E-05  -4.84160000E-04  -1.20911900E-02  -2.15830100E-02  +4.87254600E-02
   +4.34010000E-04  +9.32060000E-04  +8.02900000E-05  -1.32500000E-04  -4.90000000E-06
   -7.77700000E-05  +8.10100000E-05  +3.35000000E-05  +3.15200000E-05  +1.83080000E-04
   -8.15700000E-05  +5.99700000E-05  -1.80210000E-04  -1.79110000E-04  -1.09120000E-04
   -2.92310000E-04  -2.46900000E-05  +7.30070000E-04  +2.91800000E-05  -1.46700000E-05
   +1.39200000E-05  +8.06000000E-06  -3.95000000E-06  +2.83000000E-06  +4.36400000E-05
   +5.42600000E-05  -4.70500000E-05  +3.71000000E-06  -1.00600000E-05  +2.01000000E-05
   -1.60000000E-05  -8.71280000E-04  +2.00660000E-04  +2.71090000E-04  +1.03356500E-02
   +1.69562300E-02  -8.11300000E-05  +8.85460000E-04  -4.68180000E-04  -6.49103000E-03
   -1.22921000E-01  -1.21597520E-01  +2.86050000E-04  -2.09546000E-03  +2.82895000E-03
   +7.06530000E-04  +2.78160000E-04  -1.93230000E-04  +1.81800000E-05  -1.63070000E-04
   +1.64390000E-04  +1.18670000E-04  -6.10000000E-06  -1.69320000E-04  -1.25930000E-04
   +6.19800000E-05  +5.01300000E-05  -2.37230000E-04  -8.43100000E-05  +1.88800000E-05
   +3.43160000E-04  -2.39930000E-04  +2.18150000E-04  +1.33400000E-05  +3.03000000E-05
   +1.79700000E-05  -7.01800000E-05  +1.57300000E-05  +3.56300000E-05  -1.17100000E-05
   +1.58200000E-05  +8.62000000E-06  +7.60000000E-07  +2.26100000E-05  +2.80200000E-05
   +1.11466000E-03  -1.03392300E-02  -1.67715100E-02  +5.87930000E-03  +1.32177240E-01
   -1.47192000E-03  -9.29920000E-04  +7.08140000E-04  +9.03490000E-04  +1.51460000E-04
   -3.14140000E-04  -5.16160000E-04  -3.44540000E-04  -8.33100000E-05  -1.90460000E-04
   +2.83530000E-04  +1.57490000E-04  +7.32560000E-04  +3.63120000E-04  +2.69620000E-04
   +7.81200000E-05  -8.97870000E-04  -8.08100000E-05  -1.36390000E-04  +1.48800000E-05
   +9.33700000E-05  -4.81000000E-06  +1.73800000E-05  -1.57600000E-05  -5.38900000E-05
   -4.11700000E-05  +5.01200000E-05  +3.29900000E-05  +1.42800000E-05  -5.32000000E-06
   -2.39020000E-04  +5.47200000E-04  +1.70090000E-04  -5.92590000E-04  -1.41483900E-02
   -2.07878500E-02  +1.01127000E-03  -9.67330000E-04  +9.17570000E-04  -8.95750000E-03
   -1.19444210E-01  -2.40270900E-01  -2.10940000E-04  +4.80067000E-03  -3.88536000E-03
   +3.46080000E-04  +2.16670000E-04  +6.42800000E-05  -2.82880000E-04  +1.71000000E-04
   +2.17760000E-04  -9.69200000E-05  -1.84500000E-04  +1.97760000E-04  +2.29800000E-04
   -1.53680000E-04  -4.02800000E-05  -4.74100000E-05  +5.05220000E-04  -3.55800000E-05
   -3.98630000E-04  -2.57040000E-04  +1.96520000E-04  -1.90400000E-05  +2.49900000E-05
   -7.27000000E-06  +7.57000000E-06  -1.80300000E-05  +6.05000000E-06  -2.66600000E-05
   -2.36300000E-05  -2.95000000E-05  -2.96800000E-05  -1.02100000E-04  +3.40400000E-05
   +1.82270000E-04  +1.91846000E-03  +2.56132000E-03  +1.02804700E-02  +1.29889280E-01
   +2.62401420E-01  +6.78090000E-04  -1.36035000E-03  -5.18800000E-05  +1.99610000E-04
   +1.37640000E-04  +1.24940000E-04  +1.17510000E-04  +6.81400000E-05  -7.95600000E-05
   +8.24400000E-05  -5.93700000E-05  -4.61600000E-05  -3.01340000E-04  -2.81300000E-05
   -8.20000000E-06  +3.68080000E-04  +3.69200000E-04  +1.98330000E-04  +2.38700000E-05
   +2.82400000E-05  -2.08800000E-05  +2.39500000E-05  +1.37200000E-05  +6.93000000E-06
   +6.62000000E-06  -3.84000000E-06  -5.72000000E-06  +1.95000000E-06  +4.82000000E-06
   -1.32000000E-06  +2.37900000E-05  -5.98300000E-05  +1.15200000E-05  -3.08646000E-03
   +7.36360000E-04  +9.42190000E-04  +7.54920000E-04  +5.59900000E-05  -2.59940000E-04
   -2.42274100E-01  +1.18886460E-01  +2.12544700E-02  -1.50520000E-04  -1.05400000E-04
   +4.47240000E-04  -9.19900000E-05  -1.13630000E-04  +4.04330000E-04  +1.56960000E-04
   +1.45700000E-04  -2.24760000E-04  +1.15340000E-04  -7.55100000E-05  -4.05500000E-05
   -7.94600000E-05  +9.47900000E-05  -1.02390000E-04  -1.69200000E-05  -5.58200000E-05
   +2.95880000E-04  +1.11660000E-04  +1.13600000E-04  -4.92240000E-04  -1.96600000E-05
   +8.72000000E-06  +2.52400000E-05  -1.97430000E-04  +1.61480000E-04  -2.54500000E-05
   -3.75000000E-05  +1.68000000E-06  -1.79700000E-05  +7.01800000E-05  +5.25000000E-05
   -6.02200000E-05  -1.93347800E-02  +1.32384100E-02  +2.46373000E-03  +2.02441000E-03
   -2.08117000E-03  -2.55720000E-04  +2.60151200E-01  +1.27333000E-03  +3.61920000E-04
   -1.93170000E-04  -1.60350000E-04  +1.83240000E-04  -1.49400000E-05  -2.54710000E-04
   -9.39000000E-05  +5.59300000E-05  -8.19000000E-05  -2.08340000E-04  +1.65490000E-04
   +5.33000000E-06  +7.99000000E-06  -3.63700000E-05  -8.46500000E-05  -2.02200000E-04
   -4.97790000E-04  +3.62200000E-05  -2.00700000E-05  +6.59800000E-05  +2.60000000E-07
   -1.06200000E-05  +3.81000000E-06  +9.96900000E-05  +2.06380000E-04  -2.67400000E-05
   +6.25000000E-06  -5.15000000E-06  +5.58000000E-06  +3.29500000E-05  +1.16830000E-04
   +1.42620000E-04  +1.66082200E-02  -1.24568500E-02  -1.70556000E-03  -8.38450000E-04
   -1.50370000E-03  +3.77374000E-03  +1.17553920E-01  -1.18116280E-01  -1.40531300E-02
   -4.67870000E-04  +3.03510000E-04  -1.16346000E-03  -4.72510000E-04  +9.20900000E-05
   +5.25610000E-04  +1.00940000E-04  +1.27800000E-04  -4.68700000E-05  -2.82910000E-04
   +1.09960000E-04  +9.32700000E-05  +4.84300000E-05  -3.32860000E-04  +1.60540000E-04
   +1.24789000E-03  -1.82230000E-04  -3.10640000E-04  -1.89500000E-04  -6.36700000E-05
   -3.09190000E-04  +5.03100000E-05  -8.14000000E-06  -1.68000000E-06  +2.52110000E-04
   -1.72880000E-04  -4.85700000E-05  +7.33200000E-05  -1.03320000E-04  -3.26400000E-05
   -7.27000000E-06  +3.47600000E-05  +7.28900000E-05  -1.83409900E-02  +1.20924700E-02
   +2.21880000E-03  +1.41361900E-02  -8.71770000E-03  -6.66390000E-04  -1.29768730E-01
   +1.27971700E-01  -8.41410000E-04  -1.58120000E-04  +5.48650000E-04  -3.17790000E-04
   -1.95450000E-04  +2.71470000E-04  +3.19040000E-04  +2.07730000E-04  +8.97400000E-05
   -1.30740000E-04  +2.22400000E-05  -2.75020000E-04  -1.99610000E-04  -1.33400000E-05
   +5.10500000E-05  +3.26120000E-04  -3.51400000E-05  -1.90870000E-04  +1.51400000E-05
   -4.24000000E-06  -1.05850000E-04  +2.50000000E-06  +9.71000000E-06  +2.25000000E-06
   -2.55100000E-05  -5.71900000E-05  +2.94100000E-05  +1.29300000E-05  -4.24000000E-06
   +1.97000000E-06  +1.56800000E-05  +1.23600000E-05  +5.78000000E-05  -2.23742100E-02
   +1.39856500E-02  +7.39910000E-04  +8.70720000E-04  +2.46410000E-03  -4.32634000E-03
   +2.28642700E-02  -1.52188900E-02  -4.91727800E-02  -1.09097000E-03  +8.59260000E-04
   +1.33277000E-03  +8.81680000E-04  +2.64860000E-04  -5.74580000E-04  -2.15410000E-04
   +2.80900000E-05  +2.64720000E-04  +1.01880000E-04  -1.49250000E-04  +2.26800000E-05
   +1.25040000E-04  +2.34700000E-04  -2.82300000E-04  -1.44548000E-03  +8.91220000E-04
   +4.39210000E-04  -8.27100000E-05  -5.41690000E-04  +2.81490000E-04  -2.11100000E-05
   +3.13300000E-05  +8.92000000E-06  -1.08530000E-04  +3.39600000E-05  +3.86100000E-05
   -1.18910000E-04  +5.71300000E-05  -1.28100000E-05  -6.50000000E-07  -3.79200000E-05
   +1.25900000E-05  +5.68860000E-04  -7.54700000E-04  -1.04121000E-03  +2.41479700E-02
   -1.30983200E-02  -1.66758000E-03  -2.38619500E-02  +1.17498700E-02  +5.39439400E-02
   +7.04850000E-04  +2.84700000E-05  -2.03800000E-04  -1.56370000E-04  +6.87300000E-05
   +4.29710000E-04  +2.16990000E-04  -1.03430000E-04  -1.70410000E-04  -7.47700000E-05
   +1.35560000E-04  -8.58000000E-05  +5.69800000E-05  -8.71400000E-05  -1.36180000E-04
   -7.35900000E-05  +7.37000000E-06  +2.28830000E-04  +1.21570000E-04  -1.14550000E-04
   -4.82700000E-04  -3.47000000E-06  -4.96000000E-06  +1.05700000E-05  -9.02700000E-05
   -1.35790000E-04  -1.62200000E-05  -3.67800000E-05  -6.40000000E-07  -1.78500000E-05
   +6.90100000E-05  -5.09000000E-05  -6.10700000E-05  -3.17312000E-03  -7.53570000E-04
   +1.00327000E-03  +7.59720000E-04  +1.38278000E-03  +9.23400000E-05  -1.55020000E-04
   +1.14530000E-04  +4.40620000E-04  -2.44517500E-01  -1.19677090E-01  +1.75700500E-02
   +2.49250000E-04  -1.39740000E-04  +1.10140000E-04  +9.28000000E-05  -8.77600000E-05
   -7.14800000E-05  +2.13500000E-05  +5.22400000E-05  -1.43300000E-04  -2.18510000E-04
   -1.57700000E-05  +2.38000000E-06  +3.32130000E-04  -2.35170000E-04  +1.80760000E-04
   +2.47100000E-05  -1.98900000E-05  -1.71000000E-05  +2.44900000E-05  -1.53100000E-05
   +1.29000000E-06  +1.57500000E-05  +3.45000000E-06  +2.05200000E-05  -2.73000000E-06
   -8.40000000E-06  -2.34000000E-06  +3.25300000E-05  +6.54200000E-05  +1.79100000E-05
   +2.60440000E-04  +2.84750000E-04  -5.83700000E-04  +3.03870000E-04  +2.43070000E-04
   -2.61900000E-05  +2.98800000E-05  -1.18390000E-04  +4.64100000E-05  +2.62435630E-01
   +8.42150000E-04  -1.33947000E-03  -3.71523000E-03  +2.71280000E-04  +6.14300000E-05
   -4.59280000E-04  +3.79200000E-05  +2.42630000E-04  +1.61030000E-04  +3.67900000E-05
   +1.36800000E-04  -2.11200000E-04  +1.23270000E-04  -3.19890000E-04  -1.95280000E-04
   -1.23119000E-03  -3.07870000E-04  +2.56000000E-04  +1.79490000E-04  -8.27900000E-05
   +3.02450000E-04  -4.16900000E-05  +1.53000000E-06  -1.82000000E-05  -9.43600000E-05
   -1.30320000E-04  +6.81700000E-05  -8.70100000E-05  -8.80500000E-05  +2.32200000E-05
   -8.10000000E-07  +3.56500000E-05  -7.54300000E-05  -1.62959700E-02  -1.21146100E-02
   +1.13231000E-03  -1.19244000E-03  +5.41050000E-04  +2.94770000E-04  +4.82380000E-04
   +2.81970000E-04  +1.12885000E-03  -1.17860700E-01  -1.17879200E-01  +1.17442500E-02
   +3.43830000E-04  +1.29020000E-04  -6.13300000E-05  +1.33730000E-04  -1.11900000E-05
   -9.44900000E-05  +2.07160000E-04  -1.43770000E-04  -8.64000000E-05  -4.15100000E-05
   +2.46000000E-05  +5.17000000E-05  +1.17420000E-04  -3.21690000E-04  +5.57600000E-04
   -3.67900000E-05  -1.71100000E-05  -5.18900000E-05  -1.14700000E-05  -7.92000000E-06
   +3.19000000E-06  -2.15760000E-04  +1.81700000E-04  +1.76100000E-05  -1.24700000E-05
   -1.05900000E-05  -1.29100000E-05  -3.20000000E-05  +1.11030000E-04  -1.49030000E-04
   +8.62700000E-05  +5.97880000E-04  -1.00070000E-04  +2.49010000E-04  -1.01600000E-05
   +4.06000000E-05  +1.14730000E-04  +5.57800000E-05  -2.14700000E-05  +1.30221110E-01
   +1.27369750E-01  +8.31420000E-04  -2.42226000E-03  -4.54159000E-03  +8.16170000E-04
   -3.08000000E-04  -5.46890000E-04  -1.69790000E-04  +6.10600000E-05  +3.04190000E-04
   +2.30900000E-05  +1.17250000E-04  -1.33480000E-04  +1.92010000E-04  -2.68730000E-04
   -2.60350000E-04  -1.49494000E-03  -9.35110000E-04  +4.19310000E-04  -7.18500000E-05
   +5.23350000E-04  +2.82900000E-04  -2.01700000E-05  -3.44200000E-05  +8.88000000E-06
   -3.11400000E-05  -2.45400000E-05  +7.22900000E-05  -1.29390000E-04  -5.77100000E-05
   -1.67400000E-05  -8.03000000E-06  +4.29900000E-05  +7.00000000E-08  -2.29898000E-02
   -1.44863200E-02  +1.19690000E-04  -9.19120000E-04  +3.08840000E-04  +6.84290000E-04
   -1.06753000E-03  -8.41210000E-04  +1.33062000E-03  +1.93332300E-02  +1.28758700E-02
   -4.80703500E-02  -6.96900000E-05  +1.56260000E-04  +1.83520000E-04  +1.60080000E-04
   -9.97500000E-05  -4.38600000E-05  +1.70470000E-04  +1.28000000E-05  -2.03570000E-04
   -3.80590000E-04  -1.02800000E-05  +1.36360000E-04  +3.80390000E-04  -3.13600000E-05
   -1.30830000E-04  +1.51500000E-05  +4.85000000E-06  -9.54700000E-05  -8.52000000E-06
   -8.00000000E-06  +1.06700000E-05  -1.96510000E-04  +1.26810000E-04  +2.00800000E-05
   +1.59400000E-05  +1.40800000E-05  +1.84000000E-06  +3.30200000E-05  -8.60000000E-07
   +6.62000000E-05  +2.36010000E-04  +3.63570000E-04  -6.64950000E-04  +3.02740000E-04
   +1.27180000E-04  +2.49450000E-04  +5.46300000E-05  +1.89200000E-05  -8.29800000E-05
   -1.99125000E-02  -9.22628000E-03  +5.32841800E-02  -3.35300000E-05  +4.30000000E-06
   +3.39150000E-04  -6.65430000E-04  -8.29240000E-04  +5.61760000E-04  +5.48500000E-05
   -2.01830000E-04  -2.71870000E-04  -6.82500000E-05  -9.44000000E-06  +7.70600000E-05
   -2.72800000E-05  +1.62900000E-05  +1.85900000E-05  +1.17990000E-04  +1.57250000E-04
   -3.33000000E-06  -1.13137000E-03  -1.84476000E-03  -4.10400000E-05  +3.35400000E-05
   -1.72500000E-05  +3.25200000E-05  +2.18300000E-05  +1.66500000E-05  -4.74500000E-05
   +1.62100000E-05  +1.03800000E-05  -1.56000000E-06  -7.64000000E-06  -5.49000000E-06
   -1.02600000E-05  +2.36092000E-03  -2.92162000E-03  -5.04080000E-04  +4.04750000E-04
   +4.70950000E-04  +1.19420000E-04  +4.06380000E-04  -3.62020000E-04  -2.43280000E-04
   -2.00406990E-01  +1.31205100E-01  +1.27193700E-02  +6.12930000E-04  +1.16090000E-04
   -1.96940000E-04  -1.70200000E-05  +9.50800000E-05  -6.74700000E-05  +2.62040000E-04
   -1.81730000E-04  -4.15400000E-05  -1.58770000E-04  -6.51000000E-06  +7.73400000E-05
   +2.74110000E-04  -3.04240000E-04  +4.10360000E-04  -5.11600000E-05  -6.59700000E-05
   +3.47000000E-06  -2.15000000E-05  +3.06000000E-06  +7.37000000E-06  -2.83450000E-04
   +1.95140000E-04  +2.15400000E-05  -2.04100000E-05  +2.89000000E-06  -1.27100000E-05
   -2.20000000E-05  +3.89000000E-06  -2.37500000E-05  -2.02180000E-04  +1.35760000E-04
   +8.16500000E-05  +1.57640000E-04  -2.36280000E-04  +5.71000000E-05  +2.74820000E-04
   -1.01700000E-04  +2.40270000E-04  -1.91422200E-02  +1.85330300E-02  +1.00779000E-03
   +2.17729050E-01  +8.10950000E-04  +4.68540000E-04  +2.12230000E-04  +1.37050000E-04
   -3.88040000E-04  -8.47830000E-04  -3.51590000E-04  +2.50120000E-04  +3.89520000E-04
   +5.26500000E-05  -8.77400000E-05  +1.81500000E-05  +1.15820000E-04  +1.30300000E-04
   +7.51200000E-05  -2.87130000E-04  -7.88800000E-05  -9.84900000E-05  -1.38683000E-03
   -1.09221000E-03  +8.69020000E-04  -1.63500000E-05  -3.47500000E-05  -6.14000000E-06
   +8.10900000E-05  +1.38840000E-04  +6.70100000E-05  +3.91000000E-06  -7.94000000E-06
   +1.77000000E-05  +3.97400000E-05  +6.88100000E-05  +1.26840000E-04  +1.45288400E-02
   -1.20962800E-02  -1.05930000E-04  -5.62320000E-04  -1.23469000E-03  -3.64160000E-03
   +9.86600000E-05  +5.39440000E-04  +1.49024000E-03  +1.29857680E-01  -1.58976760E-01
   -1.10022100E-02  -4.11500000E-04  -4.52380000E-04  +3.30130000E-04  +6.61180000E-04
   -3.57390000E-04  +3.00160000E-04  -1.70330000E-04  +5.11760000E-04  -4.93960000E-04
   -2.78440000E-04  +1.46950000E-04  +9.02000000E-06  +3.25620000E-04  -1.26880000E-04
   -2.68020000E-04  -5.49800000E-05  -3.28800000E-05  -1.34870000E-04  +1.10840000E-04
   -4.74000000E-06  +2.46800000E-05  +4.63500000E-04  -3.56970000E-04  +1.77800000E-05
   +1.43100000E-05  -3.93000000E-05  +1.08800000E-05  +6.29500000E-05  +2.09640000E-04
   +9.46400000E-05  -1.25870000E-04  -1.32700000E-05  -1.22060000E-04  -2.97360000E-04
   +2.00700000E-05  +1.32810000E-04  -2.89180000E-04  +6.02260000E-04  -3.32870000E-04
   -1.29839700E-02  +1.21401400E-02  +1.07826000E-03  -1.42733050E-01  +1.70910520E-01
   +2.34600000E-04  +5.51740000E-04  +5.78000000E-04  -2.10470000E-04  +4.02410000E-04
   +3.90430000E-04  -1.60290000E-04  -1.36140000E-04  -1.08910000E-04  -8.89700000E-05
   -1.28100000E-05  +1.26700000E-04  +1.29780000E-04  +7.45900000E-05  -2.21700000E-05
   -5.83800000E-05  -2.65000000E-06  -2.32720000E-04  +2.50210000E-04  +2.79200000E-04
   +1.88370000E-04  +5.78000000E-06  -4.32000000E-06  +9.79000000E-06  +2.78600000E-05
   +3.14300000E-05  -2.34400000E-05  +1.59400000E-05  -1.15100000E-05  +7.46000000E-06
   +4.85300000E-05  -7.23000000E-06  +3.69700000E-05  +2.08188100E-02  -1.63909800E-02
   -2.85006000E-03  -1.47465000E-03  -2.35081000E-03  -3.91258000E-03  +1.20276000E-03
   -8.19590000E-04  +1.21642000E-03  +1.23616900E-02  -9.93536000E-03  -4.93644700E-02
   +4.73200000E-04  -6.06500000E-04  +1.14070000E-04  +2.18200000E-04  +1.61240000E-04
   +3.12950000E-04  -3.62230000E-04  +1.66870000E-04  +5.52400000E-05  +5.50900000E-04
   +6.27700000E-05  +3.84400000E-05  +6.01300000E-05  +3.82900000E-04  -1.04890000E-04
   -4.79700000E-05  -1.12930000E-04  -1.59320000E-04  +7.77700000E-05  -3.15400000E-05
   -1.46600000E-05  +4.78820000E-04  -3.82420000E-04  -3.94000000E-05  +3.77800000E-05
   -2.58400000E-05  +1.64700000E-05  -2.56670000E-04  -3.67420000E-04  -9.72000000E-06
   +8.21700000E-05  +1.21160000E-04  -8.10100000E-05  -1.82900000E-04  +1.67340000E-04
   +3.90280000E-04  -5.85280000E-04  +1.33820000E-04  -6.81950000E-04  +2.00077000E-03
   -1.81377000E-03  -1.11042000E-03  -1.43966600E-02  +1.40136000E-02  +5.21950000E-02
   +3.35970000E-04  +5.35950000E-04  -3.80780000E-04  -6.89000000E-05  -3.87580000E-04
   -5.97440000E-04  -1.66270000E-04  -8.55000000E-06  +1.96580000E-04  +6.33900000E-05
   -5.39200000E-05  +5.82000000E-05  +3.61000000E-05  +9.16100000E-05  +5.32400000E-05
   -3.85700000E-05  -4.64900000E-05  -8.03000000E-06  -1.47467000E-03  +1.40680000E-04
   -3.32420000E-04  -1.63200000E-05  +9.30000000E-07  -1.71500000E-05  +4.73200000E-05
   +9.19100000E-05  +2.79000000E-05  +9.15000000E-06  +6.77000000E-06  +7.94000000E-06
   -1.00200000E-05  +5.00500000E-05  +5.53700000E-05  -1.97105000E-03  +2.01267000E-03
   -2.81744000E-03  -5.21000000E-06  -5.67850000E-04  +5.40190000E-04  -5.10200000E-05
   -6.84670000E-04  -6.69810000E-04  -4.75611100E-02  +6.10896000E-03  -8.33038000E-03
   -1.55400000E-04  +8.14600000E-05  +8.43200000E-05  +1.35400000E-04  -7.63100000E-05
   +4.37500000E-05  -3.16300000E-05  +1.13130000E-04  -7.58500000E-05  -2.40090000E-04
   +2.94800000E-05  -1.65800000E-05  -6.96600000E-05  +1.87380000E-04  +4.46300000E-05
   +8.17000000E-06  -7.21000000E-06  -5.87900000E-05  +2.78000000E-06  -9.20000000E-06
   -1.07300000E-05  +5.75100000E-05  -4.81400000E-05  -9.37000000E-06  +1.92500000E-05
   +1.83400000E-05  +1.51500000E-05  +2.25880000E-04  +2.35990000E-04  +1.05430000E-04
   +1.57860000E-04  +3.04660000E-04  -1.84940000E-04  +6.24420000E-04  +1.73240000E-04
   -3.05190000E-04  +3.03440000E-04  -2.65140000E-04  +2.95260000E-04  +1.88345000E-03
   -1.48834600E-02  +2.38699200E-02  -4.93140000E-04  +1.26495700E-02  -2.12026700E-02
   +4.84732500E-02  -5.76200000E-05  +9.02820000E-04  +5.19730000E-04  -5.42460000E-04
   +3.29320000E-04  +1.09670000E-04  -8.24900000E-05  -2.02100000E-04  -1.86960000E-04
   -3.21800000E-05  -3.93600000E-05  +1.96070000E-04  +9.20000000E-05  +6.87400000E-05
   -3.05900000E-05  +2.47960000E-04  -7.41300000E-05  -1.75900000E-05  -3.00900000E-04
   -2.30330000E-04  -1.93100000E-04  -1.58600000E-05  +3.65700000E-05  -2.02800000E-05
   +1.86700000E-05  +1.64800000E-05  -4.30600000E-05  +1.37000000E-05  +1.53700000E-05
   -9.08000000E-06  +9.00000000E-08  +1.46000000E-05  -2.94800000E-05  -2.76260000E-04
   +1.05747200E-02  -1.64197700E-02  -4.55550000E-04  +9.77250000E-04  +1.42380000E-04
   -2.71220000E-04  -1.96141000E-03  -2.80139000E-03  +6.46433000E-03  -1.29463100E-01
   +1.24623350E-01  +2.06710000E-04  -1.82000000E-06  +3.96400000E-05  -1.45260000E-04
   +1.37000000E-04  -1.11230000E-04  +1.72800000E-05  -8.83900000E-05  +1.68950000E-04
   +1.33800000E-05  -1.49140000E-04  +1.09470000E-04  +3.68280000E-04  -2.37910000E-04
   -7.07090000E-04  -2.59300000E-05  -1.42700000E-05  -7.44000000E-06  -1.71900000E-05
   -4.31000000E-06  -1.80000000E-06  -1.40090000E-04  +8.49300000E-05  +5.10000000E-06
   -1.35000000E-06  -5.57000000E-06  -2.20900000E-05  +1.08840000E-04  -1.01267000E-03
   -2.57000000E-04  +2.40120000E-04  +2.59000000E-05  -1.77480000E-04  -1.73030000E-04
   +8.43500000E-04  -9.65720000E-04  -2.44460000E-04  -1.11400000E-05  -1.30970000E-04
   +1.98005000E-03  -9.07300000E-03  +1.29125600E-02  -1.14522000E-03  -1.08174200E-02
   +1.64818500E-02  -5.85089000E-03  +1.39357950E-01  +1.02674000E-03  +1.03136000E-03
   +8.57410000E-04  +3.78270000E-04  -1.88710000E-04  +5.03200000E-05  -3.56200000E-04
   -1.68640000E-04  +1.60080000E-04  +9.56000000E-06  +1.24320000E-04  +8.10500000E-05
   +1.98600000E-04  +1.49060000E-04  +2.95600000E-05  -7.42800000E-05  -4.98430000E-04
   -1.95600000E-05  -4.29540000E-04  +2.31310000E-04  +1.50690000E-04  -1.47600000E-05
   -3.39400000E-05  +7.29000000E-06  -6.40000000E-07  -8.14000000E-06  +2.65800000E-05
   -2.27200000E-05  +1.72400000E-05  -2.62800000E-05  -3.47100000E-05  +9.51800000E-05
   +2.38400000E-05  -6.68720000E-04  +1.49706400E-02  -2.06847600E-02  -1.35613000E-03
   +8.78080000E-04  +7.63060000E-04  -2.67290000E-04  -4.66755000E-03  -4.05315000E-03
   -8.11700000E-03  +1.22442300E-01  -2.34394890E-01  +7.95950000E-04  -9.42100000E-05
   -2.94630000E-04  -4.69100000E-04  +3.74240000E-04  -5.42500000E-05  -1.92190000E-04
   -3.19570000E-04  +4.13690000E-04  +5.61170000E-04  -3.09010000E-04  +1.77730000E-04
   +1.88050000E-04  +6.99980000E-04  -1.68440000E-04  -1.28340000E-04  -1.77200000E-05
   +9.59800000E-05  -9.80000000E-06  -1.49200000E-05  -1.91400000E-05  -3.63700000E-05
   +9.88000000E-06  +3.40000000E-07  +4.32500000E-05  -4.81000000E-06  -1.56000000E-06
   -2.23630000E-04  -5.88150000E-04  +2.20340000E-04  +6.80300000E-05  -1.55270000E-04
   +3.87620000E-04  -3.12080000E-04  +9.94500000E-04  -1.52071000E-03  -3.90800000E-05
   -4.78100000E-05  +2.31780000E-04  -2.55110000E-04  +4.83150000E-04  -1.31028000E-03
   +1.37850000E-04  -2.27484000E-03  +2.99925000E-03  +9.62020000E-03  -1.33159680E-01
   +2.55868520E-01  -2.52700000E-05  -1.73470000E-04  +2.55000000E-06  +7.01800000E-05
   +4.59700000E-05  -4.68000000E-06  -2.43300000E-05  -4.32000000E-06  -4.37900000E-05
   +1.29100000E-05  -1.27270000E-04  +8.95900000E-05  -9.16800000E-05  -3.96100000E-05
   -1.96400000E-05  +6.03400000E-05  +9.29400000E-05  +8.41100000E-05  -8.53000000E-06
   -8.12000000E-06  +4.09000000E-06  +1.06400000E-05  +1.74000000E-06  +4.00000000E-08
   +8.48000000E-05  +9.86700000E-05  -3.38400000E-05  +1.10000000E-07  +7.70000000E-07
   +5.07000000E-06  -2.70100000E-05  -1.01700000E-05  -4.81500000E-05  -1.48360000E-04
   +1.15730000E-04  -1.42260000E-04  +5.61880000E-04  +2.29940000E-04  -5.64970000E-04
   +7.25700000E-05  -3.75000000E-06  -2.06900000E-05  +1.42860000E-04  -5.74800000E-05
   +4.07600000E-05  -1.01543000E-03  -1.35020000E-04  +4.26320000E-04  +3.84277000E-03
   -2.98596000E-03  -5.87370000E-04  -2.98844700E-02  -8.24859000E-03  +3.11246700E-02
   -2.95907000E-03  +5.27883000E-03  -1.57494000E-03  +1.47310000E-04  -7.10930000E-04
   +1.95341000E-03  +1.87340000E-04  -1.90900000E-04  +2.59800000E-05  +1.92700000E-05
   +1.26664000E-03  -9.59530000E-04  -2.12574100E-01  -4.57577300E-02  +2.18719380E-01
   +9.44800000E-05  -1.43500000E-04  -3.31640000E-04  -3.21820000E-04  +1.89700000E-04
   -1.31050000E-04  -7.25000000E-06  +4.16700000E-05  -2.41000000E-06  -3.24700000E-05
   +1.02000000E-06  -1.43200000E-05  +4.53800000E-05  -2.55900000E-05  -2.56000000E-06
   -5.88000000E-06  +3.03700000E-05  +2.48300000E-05  +3.89000000E-05  -6.07300000E-05
   -5.04300000E-05  -9.61000000E-06  +1.39200000E-05  +4.83000000E-06  +2.41759820E-01
   +4.82500000E-05  +7.06800000E-05  +2.31800000E-05  -3.05100000E-05  -2.70100000E-05
   -1.82000000E-06  +1.06200000E-05  -1.00000000E-07  +8.11000000E-06  +4.77000000E-06
   +7.32800000E-05  -3.72600000E-05  +4.48300000E-05  +1.33100000E-05  +1.82900000E-05
   -3.62500000E-05  -4.87300000E-05  -2.05200000E-05  +1.08900000E-05  +5.30000000E-07
   -6.45000000E-06  -4.53000000E-06  -7.70000000E-07  -5.30000000E-07  -4.30700000E-05
   -6.74400000E-05  +8.59000000E-06  -1.10400000E-05  -1.66000000E-06  -5.97000000E-06
   +1.11800000E-05  +2.48500000E-05  +1.24800000E-05  -1.63200000E-05  -8.25300000E-05
   +5.85300000E-05  -2.33780000E-04  -2.33290000E-04  +5.20770000E-04  -3.53600000E-05
   +2.52300000E-05  -1.14000000E-05  -1.85000000E-05  +1.24200000E-05  -2.79000000E-06
   +9.86300000E-05  -6.29290000E-04  -1.57770000E-04  +1.04237000E-03  +5.96880000E-04
   -2.51734000E-03  +2.11974600E-02  +3.41627000E-03  -2.36549900E-02  +4.31275000E-03
   -2.08347000E-03  +1.20468000E-03  +4.85730000E-04  +1.55709000E-03  -2.85730000E-04
   -4.32800000E-05  +1.43700000E-05  -2.42900000E-05  -5.26360000E-04  -5.28220000E-04
   +1.63735000E-03  -7.75536700E-02  -5.85545500E-02  +1.22700310E-01  -8.58900000E-05
   -1.83340000E-04  -2.98720000E-04  +1.17140000E-04  -2.54430000E-04  -7.50800000E-05
   -5.10000000E-06  -4.10700000E-05  +7.90000000E-07  +2.11300000E-05  +8.50000000E-06
   +7.02000000E-06  -2.53600000E-05  +1.31500000E-05  +8.85000000E-06  +3.89000000E-06
   -2.21500000E-05  +5.20000000E-07  -1.35300000E-05  +2.58600000E-05  -6.78000000E-06
   +1.16100000E-05  -4.44000000E-06  -1.18600000E-05  +5.12617200E-02  +5.69096900E-02
   +3.06000000E-05  +6.93000000E-05  -1.36100000E-05  -3.02600000E-05  -2.14100000E-05
   +1.33000000E-06  +9.59000000E-06  +4.20000000E-07  +1.02900000E-05  -1.85900000E-05
   +4.01200000E-05  -2.56700000E-05  +3.80900000E-05  +1.09600000E-05  +5.42000000E-06
   -4.87900000E-05  -4.62900000E-05  -1.09000000E-05  +7.93000000E-06  +5.70000000E-07
   -6.72000000E-06  -2.72000000E-06  -2.00000000E-06  -3.40000000E-07  -1.83700000E-05
   -3.64100000E-05  +4.26000000E-06  -1.19700000E-05  -2.84000000E-06  -3.01000000E-06
   +1.27100000E-05  +2.22500000E-05  +2.51500000E-05  +1.38820000E-04  -3.77300000E-05
   +3.53400000E-05  -1.68750000E-04  +1.39190000E-04  -5.56400000E-05  -3.61900000E-05
   -4.00000000E-06  +3.12000000E-05  -1.00690000E-04  +6.39900000E-05  -4.04500000E-05
   +1.57040000E-04  +3.24800000E-05  -8.72090000E-04  -5.00614000E-03  +7.37150000E-04
   +2.33157000E-03  -1.06998000E-03  +1.19120000E-04  -1.82262000E-03  -5.97770000E-04
   +4.38130000E-04  +2.21128000E-03  +6.95040000E-04  +6.43310000E-04  +3.68650000E-04
   -1.31200000E-04  +8.88100000E-05  -3.34800000E-05  +1.01545000E-03  +1.85210000E-04
   -4.69740000E-04  +2.53535620E-01  +9.70349000E-02  -3.14857050E-01  -4.02350000E-04
   -2.47040000E-04  +6.03000000E-05  -5.33200000E-05  -1.27780000E-04  -3.97600000E-05
   +6.40000000E-06  -2.67000000E-06  +1.10600000E-05  -1.99000000E-06  -9.53000000E-06
   -6.79000000E-06  -4.17000000E-06  +1.84100000E-05  -8.48000000E-06  -8.90000000E-07
   -2.70700000E-05  -3.10000000E-06  -2.14500000E-05  +3.61500000E-05  +3.56000000E-05
   +9.60000000E-06  -4.04000000E-06  -6.92000000E-06  -2.47932700E-01  -9.91078600E-02
   +3.13129450E-01  -4.90220000E-04  -1.17580000E-04  -8.70600000E-05  +1.37426000E-03
   -2.10850000E-04  +4.27300000E-05  -2.33918000E-03  -1.89430000E-03  +5.52230000E-04
   -1.58307300E-02  -1.18071600E-02  -3.08063900E-02  +1.52600000E-05  +4.28900000E-05
   -2.68850000E-04  +8.16220000E-04  -3.66200000E-05  +2.68130000E-04  -8.08700000E-05
   -4.15000000E-06  +4.44600000E-05  -8.80300000E-05  +1.15530000E-04  -1.20100000E-04
   -1.06922980E-01  -5.99881800E-02  -1.58756470E-01  -1.15325000E-03  +6.15400000E-04
   +9.00710000E-04  +2.19890000E-04  +5.44000000E-05  +5.92800000E-05  -5.93200000E-05
   +4.90800000E-05  +9.50400000E-05  +2.02400000E-05  +3.03500000E-05  +1.26700000E-05
   +2.90000000E-07  -3.34500000E-05  -3.02000000E-05  +6.89300000E-05  +3.02900000E-05
   -1.49600000E-05  -2.06600000E-05  +1.19200000E-05  +4.25200000E-05  +1.73300000E-05
   -2.38600000E-05  +2.41200000E-05  -1.14030000E-04  +6.91600000E-05  -3.00000000E-07
   +2.44900000E-05  +2.79100000E-05  -1.91900000E-05  +3.40000000E-06  +3.04200000E-05
   +1.75000000E-05  -8.76000000E-06  -4.76000000E-06  -5.88000000E-06  +8.15000000E-06
   -4.97000000E-06  -9.22000000E-06  +1.21970000E-04  -6.99500000E-05  -2.83000000E-06
   -1.02600000E-05  -6.96000000E-06  -5.67000000E-06  -1.28400000E-05  -1.06900000E-05
   -2.58400000E-05  +1.46500000E-05  +1.28700000E-05  +1.10700000E-05  -8.80000000E-06
   -1.84100000E-05  +2.76200000E-05  -8.49000000E-06  -1.51000000E-06  +1.38900000E-05
   +2.09100000E-05  +2.32700000E-05  +8.93000000E-06  -1.42400000E-05  -1.03700000E-05
   -8.20000000E-07  -1.27600000E-05  -3.76000000E-06  -1.17600000E-05  -2.79900000E-05
   +5.95000000E-06  +2.38000000E-06  +1.25675480E-01  +2.93490000E-04  -1.43010000E-04
   -1.16290000E-04  +3.80350000E-04  -1.64221000E-03  -1.66550000E-03  -5.89002000E-03
   -2.40541000E-03  +1.28538000E-03  -2.04761100E-02  -1.97307700E-02  -2.87686200E-02
   -6.59050000E-04  +1.27030000E-03  +5.78410000E-04  +4.22180000E-04  +3.76620000E-04
   +8.86780000E-04  -4.07350000E-04  -1.86650000E-04  +1.30000000E-05  -7.74000000E-06
   +4.04300000E-04  +1.33200000E-05  -4.64101400E-02  -2.98263300E-02  -5.80826900E-02
   -2.78300000E-05  +4.29210000E-04  -3.90430000E-04  +1.82100000E-05  +1.75900000E-05
   -4.79000000E-05  -3.12680000E-04  -2.33200000E-05  -3.00170000E-04  +3.09000000E-06
   +2.05880000E-04  +4.36000000E-05  +2.84680000E-04  +1.46610000E-04  +1.33260000E-04
   +8.17300000E-05  -3.29700000E-05  -6.01400000E-05  -2.02500000E-05  -1.76600000E-05
   +6.85100000E-05  +6.38200000E-05  -1.13920000E-04  +3.86100000E-05  -1.88510000E-04
   +1.72940000E-04  -4.10200000E-05  +3.60500000E-05  +2.17500000E-05  -4.89400000E-05
   +4.48400000E-05  -1.06500000E-05  +1.64400000E-05  -2.17700000E-05  +1.20800000E-05
   +1.65200000E-05  +2.63900000E-05  -8.96000000E-06  -1.33500000E-05  +2.45460000E-04
   -1.89200000E-04  -1.39700000E-05  +1.61000000E-05  -7.16000000E-06  +1.70300000E-05
   -3.15900000E-05  +3.42100000E-05  -6.53000000E-05  +5.95300000E-05  +1.01710000E-04
   -9.76500000E-05  -3.22500000E-05  -2.09500000E-05  +1.89500000E-05  -2.61000000E-06
   -7.63900000E-05  +1.29800000E-05  +2.71000000E-05  +5.08700000E-05  +2.71000000E-05
   -1.74200000E-05  -1.26500000E-05  -1.90000000E-05  -1.28000000E-05  -2.09400000E-05
   +1.56100000E-05  -3.51400000E-05  +2.57200000E-05  +1.47700000E-05  +7.14478500E-02
   +4.72655200E-02  +2.73360000E-04  +7.37660000E-04  +6.26910000E-04  -1.47560000E-04
   -3.41560000E-04  +7.19390000E-04  +6.57800000E-04  +2.69483000E-03  +1.79162000E-03
   -1.18154000E-03  -1.40679000E-03  +4.09051000E-03  +3.68554000E-03  +3.65312000E-03
   -3.93090000E-04  -5.80360000E-04  -2.09561000E-03  -1.02592000E-03  +2.78600000E-05
   +3.87900000E-05  +8.62000000E-06  -1.62740000E-04  +2.79870000E-04  -2.91800000E-05
   -1.93295910E-01  -9.20668900E-02  -4.30737380E-01  -1.05720000E-04  -2.68860000E-04
   -4.84380000E-04  +1.10730000E-04  +8.11600000E-05  -1.55700000E-05  -1.42210000E-04
   +3.82300000E-05  -8.15700000E-05  -3.05200000E-05  -2.36700000E-05  -7.71000000E-06
   +4.75000000E-06  +3.22300000E-05  -2.42700000E-05  -1.12300000E-05  +7.93000000E-06
   +6.48000000E-06  +7.84000000E-06  -6.11000000E-06  -1.68700000E-05  -6.07000000E-06
   +9.51000000E-06  -8.45000000E-06  -3.00000000E-08  -9.77000000E-06  +1.39200000E-05
   +6.43000000E-06  -6.66000000E-06  -3.95000000E-06  -1.97200000E-05  -7.79000000E-06
   +3.22000000E-06  +0.00000000E+00  +1.99000000E-06  +9.20000000E-07  +2.75000000E-06
   +2.68000000E-06  +1.41000000E-06  -6.38000000E-06  +3.23000000E-06  -4.90000000E-06
   -1.86000000E-06  +1.45000000E-06  +1.90000000E-07  -1.49000000E-06  +3.68000000E-06
   +3.96000000E-06  +8.90000000E-06  +8.20000000E-07  -8.71000000E-06  +3.79000000E-06
   +7.30000000E-07  -1.01300000E-05  +6.21000000E-06  -4.69000000E-06  +3.24000000E-06
   +3.98000000E-06  -2.48000000E-06  -6.36000000E-06  +3.47000000E-06  -8.69000000E-06
   -1.24000000E-06  -3.54000000E-06  +2.46000000E-06  -5.54000000E-06  +2.98000000E-06
   +1.90000000E-06  +2.68000000E-06  +1.88958490E-01  +8.89526800E-02  +4.26337090E-01
   -3.80365000E-03  +9.91280000E-04  +4.09460000E-03  +9.11226000E-03  +4.52748000E-03
   -5.62618000E-03  -1.30614000E-02  -8.74133000E-03  -1.86329500E-02  +1.52489400E-02
   -9.72982000E-03  +1.90379000E-02  -2.17233100E-02  +6.88189000E-03  +3.98263000E-03
   -1.63241000E-03  +3.97354000E-03  -9.15030000E-04  +4.48660000E-04  +3.12400000E-05
   +8.55400000E-05  +3.15170000E-04  -4.87610000E-04  +7.21050000E-04  -5.30867000E-03
   -1.40296100E-02  +1.41647000E-03  +8.19310000E-04  -1.01642000E-03  -1.32080000E-04
   +5.91500000E-04  -1.46790000E-04  +1.97080000E-04  +2.42490000E-04  +1.45940000E-04
   -3.46600000E-05  -7.81000000E-06  -1.37200000E-05  -3.50000000E-05  +1.97480000E-04
   +6.15200000E-05  +1.62110000E-04  -3.25600000E-05  -2.84000000E-06  -4.78800000E-05
   +2.40900000E-05  -1.32700000E-05  -3.31400000E-05  -9.03000000E-06  +2.47500000E-05
   -4.28300000E-05  +1.07140000E-04  -8.07900000E-05  +1.74500000E-05  +3.16000000E-06
   -3.86000000E-06  +8.38000000E-06  -2.53700000E-05  -6.03600000E-05  +3.43100000E-05
   +2.79500000E-05  +1.58900000E-05  +6.10000000E-07  -5.14000000E-06  +3.44000000E-06
   +7.13000000E-06  -1.17100000E-04  +8.51600000E-05  -4.82000000E-06  -7.47000000E-06
   +7.10000000E-06  -2.59000000E-06  +2.25800000E-05  +3.02000000E-06  -2.02000000E-06
   -4.04000000E-05  -5.93000000E-06  -9.94300000E-05  +8.26500000E-05  -1.96300000E-05
   -9.28300000E-05  +9.29000000E-06  +4.55000000E-05  +6.92500000E-05  -5.02000000E-06
   +1.00000000E-06  -8.81000000E-06  +1.73000000E-06  +4.60000000E-07  +8.80000000E-06
   -1.45100000E-05  -7.81000000E-06  -3.99800000E-05  +2.31900000E-05  -1.09100000E-05
   -1.51000000E-06  -8.59360000E-04  +6.27970000E-04  +3.23971000E-03  +2.64161870E-01
   +3.94988000E-03  +7.62320000E-04  -3.17004000E-03  -8.69271000E-03  -1.98345000E-03
   +3.86674000E-03  +7.40653000E-03  +8.28436000E-03  +1.18985500E-02  -3.11303600E-02
   +2.26425000E-03  -2.17915200E-02  +1.81918400E-02  -5.11546000E-03  -2.80343000E-03
   -7.22090000E-04  -4.13895000E-03  -1.60930000E-03  -1.02910000E-04  +5.66000000E-05
   +4.86000000E-05  -1.20420000E-04  -1.24440000E-04  -2.05350000E-04  +7.58700000E-03
   -1.56957200E-02  +1.73705300E-02  -7.15760000E-04  +8.34710000E-04  +6.78330000E-04
   -2.53830000E-04  +2.53690000E-04  -1.84080000E-04  -1.19460000E-04  -1.47080000E-04
   +2.94290000E-04  +3.75100000E-05  -9.90300000E-05  -3.58800000E-05  -9.35100000E-05
   -1.92620000E-04  -2.39910000E-04  +2.47200000E-05  +1.48200000E-05  +3.44000000E-05
   +1.46200000E-05  +1.43300000E-05  -1.72100000E-05  -4.32400000E-05  +8.46700000E-05
   -1.57600000E-05  +7.57900000E-05  -9.02600000E-05  +2.56900000E-05  -2.80100000E-05
   -1.81000000E-06  +3.24400000E-05  -5.35100000E-05  +4.53400000E-05  -3.29100000E-05
   +9.54000000E-06  -2.24300000E-05  -2.59700000E-05  -1.84400000E-05  +1.92000000E-06
   +4.31000000E-06  -1.20810000E-04  +1.03570000E-04  +1.31100000E-05  -1.55000000E-05
   +1.61000000E-06  -1.47600000E-05  +3.62000000E-06  -3.77100000E-05  +4.77700000E-05
   -4.64100000E-05  -5.62000000E-06  +7.36500000E-05  -2.85000000E-06  +3.15000000E-06
   +4.83700000E-05  +5.29000000E-06  +1.43830000E-04  +9.54000000E-06  -2.52200000E-05
   -2.03700000E-05  +1.38100000E-05  -1.27000000E-06  +5.04200000E-05  +3.69600000E-05
   +1.86000000E-05  +2.53100000E-05  +1.36700000E-05  +1.13500000E-05  -1.62800000E-05
   -1.18900000E-05  +1.60369000E-03  +2.44224000E-03  -4.91420000E-04  +2.34599550E-01
   +2.35613290E-01  -1.57817000E-03  -5.47959000E-03  -4.69589000E-03  +2.43348000E-03
   +2.07144000E-03  -3.39728000E-03  -1.21519300E-02  -7.98235000E-03  -1.97686800E-02
   +3.46675900E-02  -1.15358800E-02  +2.58691200E-02  -2.54204200E-02  +3.46367000E-03
   +3.78354000E-03  +6.35722000E-03  +1.17225500E-02  +5.44382000E-03  +4.32030000E-04
   -8.60100000E-05  +3.82290000E-04  +5.69530000E-04  -3.79000000E-04  +1.49533000E-03
   -9.30547000E-03  +9.92835000E-03  -1.19283800E-02  +7.17100000E-04  -2.78240000E-04
   +4.30320000E-04  +2.05590000E-04  -1.30700000E-04  +2.95390000E-04  +3.86600000E-04
   +1.54240000E-04  -2.43550000E-04  +1.30820000E-04  +9.70900000E-05  +1.18700000E-05
   +3.54080000E-04  +6.28400000E-05  +1.46720000E-04  +6.01600000E-05  -7.19900000E-05
   -4.29600000E-05  -8.37500000E-05  +6.05400000E-05  +1.01090000E-04  +5.75800000E-05
   -8.73900000E-05  +3.66500000E-05  -7.10000000E-06  +6.97200000E-05  -9.36000000E-05
   -4.64300000E-05  +4.34900000E-05  +3.49900000E-05  +1.28150000E-04  +4.07400000E-05
   +1.41900000E-05  -8.90000000E-07  -1.24000000E-06  -1.95000000E-06  -6.43000000E-06
   -9.89000000E-06  -7.30000000E-06  +4.48600000E-05  -3.40300000E-05  +1.21900000E-05
   +4.31000000E-06  -2.54000000E-06  +4.65000000E-06  +2.90900000E-05  -3.31300000E-05
   -4.51900000E-05  -3.42100000E-05  +9.06800000E-05  -1.75400000E-05  -5.90900000E-05
   -2.11400000E-05  +9.89700000E-05  -7.13000000E-06  +3.47000000E-05  -2.60600000E-05
   -2.80500000E-05  +1.44100000E-05  +3.05000000E-05  -1.68200000E-05  +7.66100000E-05
   +1.56900000E-05  +2.17300000E-05  -2.37000000E-06  +3.91700000E-05  -1.18600000E-05
   -1.37000000E-06  -3.73000000E-06  -7.87030000E-04  -2.44141000E-03  +5.41250000E-04
   -1.30107810E-01  -1.35217310E-01  +8.62707600E-02  +4.60140000E-04  -9.81010000E-04
   -1.03705000E-03  -1.33436000E-03  -7.81070000E-04  +6.62510000E-04  +1.31632000E-03
   +2.25892000E-03  +1.77237000E-03  -7.45840000E-04  -3.00690000E-04  -1.37668000E-03
   +4.94770000E-04  +2.38798000E-03  -2.64595000E-03  -2.39870000E-04  -1.36650000E-04
   +6.73090000E-04  -4.19000000E-05  -3.48000000E-05  +5.85900000E-05  -5.98300000E-05
   +2.13600000E-05  -1.09850000E-04  +3.72825000E-03  +6.54559000E-03  -1.45946000E-03
   -1.31320000E-04  +1.54730000E-04  -1.89800000E-05  -9.53700000E-05  +9.18000000E-06
   +4.37700000E-05  -2.07600000E-05  +1.30000000E-05  +3.67700000E-05  -8.86000000E-06
   -8.13000000E-06  +2.91300000E-05  -1.21020000E-04  -1.37200000E-05  -9.74900000E-05
   +2.83600000E-05  -2.22400000E-05  +2.54000000E-05  -1.09000000E-06  +1.32100000E-05
   +6.42000000E-06  -1.37000000E-06  -6.04000000E-06  +2.20200000E-05  -4.97300000E-05
   +2.86700000E-05  -1.44000000E-06  +9.44000000E-06  -1.71000000E-06  -7.80000000E-07
   +2.46800000E-05  +1.87800000E-05  -8.21000000E-06  -2.00000000E-05  -8.16000000E-06
   +4.32000000E-06  +2.35000000E-06  -1.81000000E-06  -4.07000000E-06  +5.32300000E-05
   -3.69600000E-05  +1.38000000E-06  +2.74000000E-06  -3.17000000E-06  +1.39000000E-06
   +2.74000000E-06  -2.99000000E-06  -2.87000000E-06  +6.20500000E-05  -1.94200000E-05
   +9.91000000E-05  -1.10870000E-04  +4.19500000E-05  +7.98100000E-05  +2.52500000E-05
   -1.08680000E-04  -7.93500000E-05  -1.05000000E-06  +3.43000000E-06  +2.57000000E-06
   -1.08000000E-06  +5.19000000E-06  -6.12000000E-06  +6.57000000E-06  +4.19000000E-06
   +2.69400000E-05  -1.15000000E-05  +4.52000000E-06  +5.20000000E-07  -3.38720000E-04
   +4.74390000E-04  -1.30772000E-03  -2.44786290E-01  -2.31233230E-01  +1.33052660E-01
   +2.41903950E-01  +4.31930000E-04  +1.34828000E-03  +7.52050000E-04  -1.09587000E-03
   -6.46730000E-04  +6.22200000E-04  +1.19037000E-03  +1.82570000E-03  +1.58065000E-03
   -8.53842000E-03  -1.22700000E-03  -3.52094000E-03  +3.70050000E-03  -1.32138000E-03
   -3.38600000E-04  -1.27202000E-03  -1.39141000E-03  -1.60409000E-03  -3.39300000E-05
   -8.26000000E-06  -1.51260000E-04  +8.70000000E-06  +2.50000000E-06  -1.79350000E-04
   +1.93646000E-03  -2.47617000E-03  +2.80034000E-03  +8.73000000E-06  -1.80820000E-04
   +1.30270000E-04  -3.14200000E-05  +8.28900000E-05  -2.91400000E-05  +2.23100000E-04
   +9.28800000E-05  +9.13500000E-05  -9.08900000E-05  -2.25310000E-04  +2.60300000E-05
   -4.43000000E-04  +1.00840000E-04  -6.56400000E-05  -1.64290000E-04  -3.80000000E-06
   +9.14600000E-05  +5.74000000E-05  +1.05000000E-06  -1.20950000E-04  -7.60000000E-05
   +9.50600000E-05  -2.54900000E-05  +1.49250000E-04  -1.40610000E-04  +5.49800000E-05
   -7.60000000E-06  -6.90100000E-05  +3.35900000E-05  -3.68500000E-05  -1.94900000E-05
   -5.78600000E-05  -2.84000000E-06  -4.79000000E-06  +1.36300000E-05  -1.73000000E-05
   +1.44500000E-05  +1.45700000E-05  -1.96000000E-04  +1.26590000E-04  +6.48000000E-06
   +2.47000000E-06  +7.91000000E-06  -2.30000000E-06  +2.84300000E-05  -6.75000000E-06
   +8.27500000E-05  +4.12900000E-05  -1.56900000E-04  +1.12790000E-04  -1.24600000E-05
   +7.01400000E-05  -2.13800000E-05  +3.59300000E-05  -1.38230000E-04  -1.29780000E-04
   -4.08000000E-05  -6.16600000E-05  -3.12600000E-05  +3.27300000E-05  -2.51000000E-06
   -3.02600000E-05  +3.92100000E-05  +1.00000000E-06  +3.27400000E-05  +3.73000000E-05
   -9.06000000E-06  -6.72000000E-06  +7.65300000E-05  +1.49161000E-03  +1.96040000E-04
   -2.17656020E-01  -2.23309210E-01  +1.35864490E-01  +2.21715370E-01  +2.26138190E-01
   -5.39150000E-04  -1.14190000E-03  -3.08170000E-04  +3.26680000E-04  -7.76100000E-04
   -6.28960000E-04  +4.96800000E-05  -4.74430000E-04  -1.47840000E-03  +7.06557000E-03
   +4.47090000E-04  +2.37272000E-03  -2.44204000E-03  +6.50250000E-04  -4.25900000E-05
   +1.20063000E-03  +2.13209000E-03  +1.20110000E-03  -8.61000000E-06  -1.70200000E-05
   +5.23500000E-05  +5.90000000E-06  +1.17370000E-04  +3.73900000E-05  -4.58020000E-04
   +4.30062000E-03  -1.21983000E-03  +1.28130000E-04  -4.26430000E-04  +3.41300000E-05
   +1.84520000E-04  -1.27320000E-04  +1.09800000E-05  -1.83410000E-04  -1.32720000E-04
   -1.99320000E-04  +3.46400000E-05  +2.09420000E-04  -1.49800000E-05  +1.26500000E-04
   +1.88960000E-04  +1.94220000E-04  +8.48000000E-05  +4.85400000E-05  -6.56100000E-05
   -4.65400000E-05  -2.73900000E-05  +8.89900000E-05  +7.57900000E-05  -1.14000000E-04
   +1.93500000E-05  -1.54790000E-04  +1.48830000E-04  -4.20200000E-05  +1.58400000E-05
   +4.29700000E-05  -4.27200000E-05  +5.21800000E-05  -1.25900000E-05  +5.06500000E-05
   -4.03000000E-06  +2.45800000E-05  +1.02900000E-05  +3.05600000E-05  -9.93000000E-06
   -1.12600000E-05  +2.11840000E-04  -1.50910000E-04  -1.74200000E-05  +5.10000000E-06
   -5.73000000E-06  +9.17000000E-06  -2.36600000E-05  +2.26800000E-05  -7.12600000E-05
   +4.99000000E-05  +6.84500000E-05  -1.03640000E-04  +7.32600000E-05  -8.26600000E-05
   -2.29600000E-05  -4.50900000E-05  -8.03400000E-05  +7.66200000E-05  +5.51400000E-05
   +4.25200000E-05  +1.62200000E-05  -1.58800000E-05  -5.30500000E-05  -1.01700000E-05
   -2.82900000E-05  -1.30200000E-05  -2.41800000E-05  -3.17600000E-05  +1.71500000E-05
   +1.65000000E-05  -1.29190000E-04  +1.94400000E-05  -1.28618000E-03  +1.22776540E-01
   +1.31355960E-01  -8.47864200E-02  -1.28442750E-01  -1.36191380E-01  +8.61854200E-02
end_hess

