# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -807.47018240    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +1.87089258E+00  +1.20259307E+00  -4.84049478E-01
   006   +3.75401310E+00  +1.59773729E+00  -2.28752998E+00
   006   +5.90386894E+00  +9.18286567E-02  -2.40127183E+00
   006   +6.24300520E+00  -1.83795670E+00  -6.74155265E-01
   006   +4.45016850E+00  -2.19171322E+00  +1.26929277E+00
   006   +2.22860805E+00  -7.45752189E-01  +1.22708687E+00
   001   +3.55560397E+00  +3.08868955E+00  -3.66901941E+00
   001   +7.30128912E+00  +4.20073049E-01  -3.86197306E+00
   008   +8.22822553E+00  -3.42599314E+00  -7.10998180E-01
   001   +4.56240210E+00  -3.88182818E+00  +2.40240584E+00
   001   +7.97689099E-01  -1.14404221E+00  +2.63220249E+00
   006   -4.91303281E-01  +2.86320461E+00  -2.73366146E-01
   006   -2.83618613E+00  +1.17717722E+00  -9.42141147E-02
   006   -1.61084486E-01  +4.54651626E+00  +2.06923490E+00
   006   -8.25739431E-01  +4.60585048E+00  -2.57146417E+00
   006   -4.65701202E+00  +1.42962533E+00  +1.78064616E+00
   006   -6.79003442E+00  -9.18204849E-02  +1.84484405E+00
   006   -7.14722457E+00  -1.91904808E+00  +5.68461512E-03
   006   -5.34894246E+00  -2.20857520E+00  -1.88799655E+00
   006   -3.23306759E+00  -6.77339778E-01  -1.91950327E+00
   001   -4.43617707E+00  +2.83130018E+00  +3.24967463E+00
   001   -8.18639451E+00  +1.22458357E-01  +3.32117104E+00
   008   -9.26114382E+00  -3.36973311E+00  +1.42333636E-01
   001   -5.59809674E+00  -3.64037812E+00  -3.33214107E+00
   001   -1.83890036E+00  -9.55871600E-01  -3.39197338E+00
   001   -1.72382894E+00  +5.87637654E+00  +2.26769593E+00
   001   -2.21594195E-02  +3.43229208E+00  +3.79640258E+00
   001   +1.57471958E+00  +5.64152268E+00  +1.88364627E+00
   001   -2.58525575E+00  +5.65811813E+00  -2.37607526E+00
   001   +7.12266673E-01  +5.97202405E+00  -2.71470401E+00
   001   -9.22594276E-01  +3.54090897E+00  -4.33240410E+00
   001   -9.27547715E+00  -4.55578965E+00  -1.22215241E+00
   001   +9.39564427E+00  -2.93020397E+00  -2.00140054E+00
   008   +6.36103938E+00  -3.97325812E-01  +4.10333400E+00
   001   +5.95267230E+00  +1.30602667E+00  +3.60237649E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -1.50000000E-07  +1.10000000E-07  -5.80000000E-07
   -8.30000000E-07  +7.00000000E-07  -1.23000000E-06
   -8.70000000E-07  +7.80000000E-07  -2.49000000E-06
   -1.70000000E-07  +2.80000000E-07  -3.10000000E-06
   +5.70000000E-07  -3.00000000E-07  -2.55000000E-06
   +5.50000000E-07  -3.20000000E-07  -1.29000000E-06
   -1.45000000E-06  +1.08000000E-06  -7.10000000E-07
   -1.45000000E-06  +1.21000000E-06  -2.92000000E-06
   -1.40000000E-07  +3.50000000E-07  -4.37000000E-06
   +1.09000000E-06  -6.10000000E-07  -3.07000000E-06
   +1.12000000E-06  -7.60000000E-07  -8.30000000E-07
   -9.00000000E-08  +3.00000000E-08  +8.00000000E-07
   +0.00000000E+00  -7.00000000E-08  +1.26000000E-06
   +7.90000000E-07  -6.20000000E-07  +1.14000000E-06
   -1.03000000E-06  +6.50000000E-07  +1.41000000E-06
   +7.30000000E-07  -6.40000000E-07  +2.02000000E-06
   +7.70000000E-07  -7.30000000E-07  +2.40000000E-06
   +1.40000000E-07  -2.00000000E-07  +2.01000000E-06
   -6.20000000E-07  +3.90000000E-07  +1.27000000E-06
   -6.80000000E-07  +4.20000000E-07  +8.70000000E-07
   +1.25000000E-06  -1.05000000E-06  +2.33000000E-06
   +1.35000000E-06  -1.15000000E-06  +3.03000000E-06
   +2.00000000E-07  -2.80000000E-07  +2.46000000E-06
   -1.15000000E-06  +7.90000000E-07  +9.60000000E-07
   -1.24000000E-06  +8.80000000E-07  +2.60000000E-07
   +8.20000000E-07  -7.10000000E-07  +2.12000000E-06
   +1.46000000E-06  -1.10000000E-06  +7.70000000E-07
   +6.70000000E-07  -5.30000000E-07  +7.70000000E-07
   -9.90000000E-07  +5.80000000E-07  +2.39000000E-06
   -1.13000000E-06  +7.50000000E-07  +1.20000000E-06
   -1.70000000E-06  +1.16000000E-06  +1.16000000E-06
   -3.10000000E-07  +1.00000000E-07  +2.14000000E-06
   -6.50000000E-07  +7.40000000E-07  -4.68000000E-06
   +1.69000000E-06  -1.02000000E-06  -2.78000000E-06
   +1.43000000E-06  -9.30000000E-07  -2.16000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.30700070E-01  -1.24320310E-01  +4.54691730E-01  -1.37290530E-01  -1.79433070E-01
   +4.69777790E-01  -2.06433470E-01  +3.22188600E-02  +7.32458100E-02  +5.37921610E-01
   -2.11244800E-02  -1.08988410E-01  +5.87155300E-02  -1.63749060E-01  +4.97989090E-01
   +1.26631870E-01  +2.11510200E-02  -1.82849380E-01  -1.35800780E-01  -2.40498100E-01
   +4.90460660E-01  -4.20643600E-02  -1.10320400E-02  +4.86812200E-02  -2.47003130E-01
   +1.38434170E-01  +3.51230000E-03  +5.82702020E-01  +2.42933100E-02  +4.25224900E-02
   -5.24899700E-02  +8.58411900E-02  -1.64345120E-01  +4.16139300E-02  -1.58976140E-01
   +4.47631140E-01  +1.30037100E-02  -2.66711200E-02  +2.39812800E-02  +5.58640500E-02
   +1.78405000E-03  -1.04642880E-01  -1.97432260E-01  -2.15417990E-01  +5.05865950E-01
   -3.90336000E-03  -1.12777900E-02  +9.93903000E-03  +1.17722000E-02  +1.91029000E-02
   -2.59476500E-02  -1.18557210E-01  +4.87329600E-02  -1.10019700E-02  +5.74820260E-01
   -1.82983800E-02  -2.50895100E-02  +3.28372800E-02  +5.95337100E-02  -3.64870500E-02
   -5.25764000E-03  -1.26683000E-03  -2.02557890E-01  +1.41404320E-01  -1.80120450E-01
   +5.07945950E-01  +1.82797000E-02  +2.95559300E-02  -4.88063900E-02  -7.15373700E-02
   +2.70759900E-02  +3.04068600E-02  +4.41868900E-02  +9.61429700E-02  -2.04347930E-01
   -1.52910560E-01  -2.01965290E-01  +4.97852820E-01  +1.57842000E-02  +4.76536000E-02
   -5.43174700E-02  -4.44029700E-02  +4.76102000E-03  +2.33560300E-02  +2.87230800E-02
   -3.19979600E-02  +1.81720800E-02  -1.83272920E-01  +8.59590000E-03  +1.09207040E-01
   +5.13567300E-01  +2.48874300E-02  -1.83642800E-02  +1.09431500E-02  +7.32408000E-03
   -7.41671000E-03  -4.34337000E-03  -2.26699700E-02  +1.26354400E-02  +1.80070900E-02
   -3.23571700E-02  -1.13189230E-01  +7.14904700E-02  -1.72949280E-01  +5.47767560E-01
   -1.92755800E-02  +1.51320100E-02  +5.73958000E-03  +1.45219500E-02  -1.23526900E-02
   -4.27892000E-03  -2.68482000E-03  +3.83684100E-02  -2.85739700E-02  +9.71039400E-02
   +2.79362500E-02  -1.69957030E-01  -1.97927550E-01  -2.61936440E-01  +3.69705910E-01
   -1.21269520E-01  +1.21030300E-02  +2.69574000E-02  +3.84879700E-02  -2.15169600E-02
   +5.39570000E-04  -1.80232400E-02  +2.03490800E-02  -9.72961000E-03  -2.94990700E-02
   -5.02807000E-03  +2.34110500E-02  -2.41016590E-01  +1.39496060E-01  +3.90129800E-02
   +5.96850140E-01  +5.75511100E-02  -2.12590460E-01  +1.02992400E-01  -5.60214000E-02
   +5.13990000E-03  +4.52133500E-02  +2.67550800E-02  -3.83986000E-02  +1.44174900E-02
   +1.54272700E-02  +3.35073900E-02  -3.97281500E-02  +8.18921800E-02  -1.70197830E-01
   +1.92903900E-02  -1.29228500E-01  +4.58251060E-01  -2.52688600E-02  +1.31177250E-01
   -1.82407900E-01  +4.35025000E-02  +1.84321900E-02  -4.18531800E-02  -1.87710100E-02
   +2.49491800E-02  -1.43872500E-02  +1.85464800E-02  -3.21128100E-02  +2.68136900E-02
   +3.94069000E-02  +2.22429700E-02  -8.35765700E-02  -1.77261040E-01  -2.21597590E-01
   +4.94003360E-01  +8.28115000E-03  -1.54034500E-02  +1.34977200E-02  -5.79962400E-02
   +2.61007000E-02  -1.21442500E-02  +1.28319000E-03  +1.95750100E-02  -1.75455700E-02
   -2.23932000E-03  +4.56293000E-03  +2.59143000E-03  -1.07134000E-03  -9.16500000E-05
   +9.25400000E-05  -2.02842000E-03  +6.84470000E-04  +5.41702000E-03  +5.86854700E-02
   +1.00684000E-03  +4.66100000E-04  +4.12593000E-03  +2.59323100E-02  -2.01904220E-01
   +1.48206570E-01  +5.75170000E-04  -8.35563000E-03  +1.30848000E-02  +4.80124000E-03
   +2.12549000E-03  +1.41778000E-03  -1.08830000E-04  -1.67220000E-04  -5.40360000E-04
   +6.71790000E-04  +3.17845000E-03  +2.47421000E-03  -3.51314000E-02  +2.11128860E-01
   -3.60813000E-03  +1.64835200E-02  -9.20016000E-03  -1.14559100E-02  +1.48752480E-01
   -1.82678570E-01  +1.65815000E-03  -1.08369000E-03  +4.53820000E-03  +2.51268000E-03
   +1.13106000E-03  +4.02460000E-03  +1.51630000E-04  -9.65880000E-04  -2.22940000E-04
   +5.38563000E-03  +2.15585000E-03  -1.50950000E-04  +1.08605200E-02  -1.64337390E-01
   +1.86000630E-01  -1.23956000E-03  +5.35070000E-03  +7.63180000E-04  -1.35587400E-02
   -6.33492000E-03  +1.91216500E-02  -1.79806720E-01  -2.32438400E-02  +1.42022590E-01
   +3.16900000E-03  +4.02562000E-03  -3.45875000E-03  +1.97146000E-03  +2.33895000E-03
   +3.34630000E-04  -1.62840000E-04  +1.99710000E-04  -7.39620000E-04  -2.73460000E-04
   -1.41577000E-03  -1.63101000E-03  +1.88480250E-01  +4.86067000E-03  +8.24910000E-04
   +1.96788000E-03  +1.20909000E-02  +6.72595000E-03  -1.44621700E-02  -2.26388100E-02
   -5.78219900E-02  +4.41438500E-02  -1.64402100E-02  +1.70795000E-03  +1.62039300E-02
   +2.38038000E-03  -1.37695000E-03  +4.80744000E-03  +5.96100000E-04  -1.31986000E-03
   +2.18650000E-04  -1.72054000E-03  -1.13090000E-03  -1.83024000E-03  +2.24624000E-02
   +5.25317100E-02  +1.01387000E-03  +1.76374000E-03  +3.58814000E-03  -1.00356000E-03
   +7.19870000E-04  +2.13539000E-03  +1.42253730E-01  +4.38299600E-02  -1.92257550E-01
   +1.77448500E-02  +4.00280000E-04  -1.09602800E-02  -3.92390000E-04  +5.62483000E-03
   -1.40210000E-04  -6.79510000E-04  -1.53580000E-04  +4.50000000E-07  -1.27566000E-03
   -2.01833000E-03  -9.41460000E-04  -1.55765360E-01  -4.91255300E-02  +1.98943560E-01
   -2.77448000E-03  -1.02169000E-03  +1.36153000E-03  +6.36042000E-03  +3.52330000E-04
   +6.96000000E-04  -1.34505600E-02  +2.32087000E-02  -2.33724000E-03  -2.30188400E-01
   +1.46222910E-01  +6.73293000E-03  -3.86664000E-02  +3.00704900E-02  +1.71287200E-02
   -9.66200000E-04  -9.76680000E-04  +1.62496000E-03  -4.10430000E-04  +1.72660000E-04
   -2.39460000E-04  +1.86900000E-03  -2.53392000E-03  -1.94886000E-03  +5.07376580E-01
   +2.87096000E-03  +1.93783000E-03  -4.47113000E-03  -6.36177000E-03  +3.90184000E-03
   +8.78966000E-03  +4.44693400E-02  -2.94927400E-02  +4.79587000E-03  +1.11298080E-01
   -1.75912810E-01  +3.78951400E-02  +4.99166000E-03  +5.16751000E-03  -8.42734000E-03
   +1.32010000E-03  -8.13770000E-04  +6.70471000E-03  +1.11889000E-03  -8.82570000E-04
   -2.51100000E-05  -2.21816000E-03  +7.81100000E-05  -2.73090000E-03  -9.38298600E-02
   +2.69687790E-01  -2.02936000E-03  -3.33178000E-03  +4.08280000E-03  +9.32734000E-03
   +3.26624000E-03  -2.69280000E-03  -2.58002500E-02  +2.42549000E-02  +7.88868000E-03
   +3.27172600E-02  +1.41460900E-02  -8.36646500E-02  +3.16946000E-02  -2.53300200E-02
   -1.91068000E-03  +1.05007000E-03  +6.67293000E-03  -5.27032000E-03  -1.03753000E-03
   +4.56330000E-04  -1.09320000E-04  -2.48315000E-03  -2.27121000E-03  +1.89850000E-04
   -2.64541740E-01  -1.48824890E-01  +3.60620410E-01  -3.33926000E-03  +3.38299000E-03
   +3.10029000E-03  -1.17311000E-03  +4.20960000E-04  +7.54600000E-05  -1.58816000E-03
   +9.39500000E-05  +4.27939000E-03  +6.84265000E-03  -1.78442300E-02  +9.35446000E-03
   -5.07283900E-02  +1.97966900E-02  +5.86190000E-03  +1.24461000E-03  +2.36439600E-02
   -1.68783100E-02  -5.67900000E-05  -1.35210000E-04  -1.89880000E-04  +2.63570000E-04
   -7.49570000E-04  +8.59070000E-04  +3.75650000E-04  -4.21720000E-04  -1.40646000E-03
   +5.17277800E-02  +2.96870000E-03  +7.70590000E-04  +1.32483000E-03  +2.40000000E-06
   +5.05060000E-04  -8.93930000E-04  +8.63020000E-04  +9.29420000E-04  +1.13020000E-03
   +4.19663000E-03  +1.47432000E-03  -7.82410000E-04  +2.15370000E-02  -2.51178990E-01
   +1.53585680E-01  -3.17056000E-03  -6.00024000E-03  +7.90093000E-03  -1.23440000E-04
   -2.02840000E-04  -9.95100000E-05  -2.05900000E-05  -2.09700000E-05  -1.18170000E-04
   -1.34903000E-03  -5.71400000E-05  -7.60570000E-04  -1.94953300E-02  +2.62729650E-01
   +1.13232000E-03  +2.06230000E-04  +5.15320000E-03  +1.15539000E-03  -4.89300000E-04
   -8.06400000E-04  +4.92123000E-03  +6.18720000E-04  -7.47560000E-04  -7.10430000E-04
   +2.13198500E-02  -1.12493700E-02  +5.62203000E-03  +1.47234000E-01  -1.31742250E-01
   -3.37516000E-03  +8.03520000E-04  +1.81951000E-03  -1.79440000E-04  -1.92090000E-04
   -1.84580000E-04  -2.46870000E-04  +6.19940000E-04  -7.47720000E-04  -2.82610000E-03
   -1.24427000E-03  +5.22200000E-04  +2.12773000E-03  -1.55078180E-01  +1.45625320E-01
   +6.93824000E-03  +1.68264000E-03  -2.76338000E-03  +1.68495000E-03  +2.50569000E-03
   +7.79910000E-04  -7.48400000E-05  +1.38000000E-04  -6.13620000E-04  -1.36907000E-03
   +4.59773000E-03  -1.25840000E-04  -1.52958500E-02  -5.51803000E-03  +1.85487600E-02
   -1.92089960E-01  -3.47129600E-02  +1.41624830E-01  +2.03390000E-04  +5.23300000E-05
   -3.56990000E-04  -1.66510000E-04  -2.15400000E-04  -1.18560000E-04  -8.91980000E-04
   -4.43360000E-04  +1.11504000E-03  +1.08220000E-04  -6.27410000E-04  -1.25284000E-03
   +2.01862500E-01  -1.69142000E-02  +1.78928000E-03  +1.58412600E-02  +2.85133000E-03
   -9.12800000E-04  +5.70262000E-03  +4.37470000E-04  -8.18720000E-04  -4.31120000E-04
   +4.74970000E-03  +8.56250000E-04  +2.88295000E-03  +1.30758900E-02  +6.80411000E-03
   -1.27387300E-02  -3.27597800E-02  -6.35808600E-02  +4.74401700E-02  -1.00836000E-03
   -1.98480000E-04  +7.50110000E-04  -2.74910000E-04  -2.33820000E-04  -2.75110000E-04
   +5.80150000E-04  +2.85730000E-04  -7.67010000E-04  -1.58720000E-03  -5.38130000E-04
   -1.82266000E-03  +3.14327200E-02  +5.85839400E-02  +1.54522300E-02  +3.51061000E-03
   -8.84082000E-03  +6.04820000E-04  +5.84877000E-03  +5.84550000E-04  -6.99870000E-04
   -1.67970000E-04  -1.06010000E-04  +8.50580000E-04  +2.40858000E-03  +3.00658000E-03
   -2.27576000E-03  +1.13077000E-03  +4.12294000E-03  +1.42484450E-01  +4.61483400E-02
   -1.85551160E-01  +6.82960000E-04  -1.07820000E-04  -7.52320000E-04  -1.44660000E-04
   -3.17560000E-04  -2.78790000E-04  -2.95000000E-06  -3.68200000E-05  +1.24870000E-04
   -1.14938000E-03  -1.29859000E-03  -1.19838000E-03  -1.55490290E-01  -5.48879600E-02
   +1.89621140E-01  -1.40138940E-01  +4.19780000E-02  +1.26406800E-02  -1.72074100E-02
   +1.22400000E-02  +3.09293000E-03  +1.09152000E-03  +4.70600000E-04  +3.50068000E-03
   -1.67351000E-03  +3.35200000E-05  +6.32830000E-04  +3.89351000E-03  +6.21290000E-04
   +2.29696000E-03  -4.66526000E-03  +1.00754300E-02  -5.84784000E-03  +1.20700000E-05
   -4.80030000E-04  -2.20873000E-03  -1.28170000E-04  +4.99160000E-04  +5.62000000E-06
   +1.35078000E-03  -1.08755000E-03  -4.51860000E-04  +2.34800000E-04  -2.11050000E-04
   +1.45560000E-04  -7.96660000E-04  -1.69903000E-03  +7.18200000E-05  +4.75333640E-01
   +4.52218700E-02  -1.09131340E-01  +4.59618000E-03  -9.83300000E-04  +7.10297000E-03
   -3.98537000E-03  -6.63380000E-04  +2.62176000E-03  +4.29502000E-03  +3.48000000E-05
   -9.42790000E-04  +6.39840000E-04  +1.22880000E-04  +5.79500000E-04  +3.92028000E-03
   +2.18707200E-02  -1.51348700E-02  +1.13800000E-05  -1.30093000E-03  -2.12302000E-03
   -3.76580000E-04  -6.33750000E-04  +6.61190000E-04  +3.00700000E-04  -4.76850000E-04
   +1.20250000E-04  -3.71900000E-04  +5.50000000E-04  -9.34000000E-05  +1.12950000E-04
   -5.16870000E-04  -9.15610000E-04  -1.90111000E-03  +1.56192000E-03  +4.81500050E-01
   +8.72402000E-03  +6.19031000E-03  -8.15598000E-02  +1.51473000E-02  -1.27682900E-02
   +2.61558000E-03  +3.72567000E-03  +2.78916000E-03  +1.25700000E-04  +6.17600000E-05
   +9.58250000E-04  -1.16614000E-03  +9.34880000E-04  +6.43504000E-03  -1.27889000E-03
   -1.83128400E-02  +1.00047600E-02  +5.09027000E-03  -1.15670000E-03  -1.12611000E-03
   -1.47639000E-03  +8.68690000E-04  -3.41860000E-04  +1.88170000E-04  +4.83810000E-04
   -9.09520000E-04  -8.14200000E-05  -1.08709000E-03  +6.22920000E-04  +1.90590000E-04
   -1.03569000E-03  -1.27138000E-03  -1.45124000E-03  +8.72380000E-04  -1.11957000E-03
   +4.81307360E-01  -3.49289500E-02  -1.01372600E-02  +6.21057000E-03  -1.17750000E-03
   +7.91570000E-04  -2.29017000E-03  -2.54590000E-04  +8.80740000E-04  +8.29260000E-04
   -1.19410000E-04  -2.86370000E-04  +4.86290000E-04  +2.83680000E-04  -7.07510000E-04
   +6.20330000E-04  -1.23869000E-03  -4.38670000E-04  -6.67290000E-04  -2.00590000E-04
   -2.50640000E-04  -1.96520000E-04  -4.92000000E-06  +2.29870000E-04  +1.30400000E-04
   -3.14400000E-05  -1.56000000E-06  -8.08800000E-05  +1.23410000E-04  -1.18050000E-04
   -7.88700000E-05  -7.71220000E-04  +4.47340000E-04  -1.75400000E-04  -1.39509040E-01
   -4.67371900E-02  +8.14333000E-03  +5.29812610E-01  +9.27794000E-03  +1.33317200E-02
   -2.17321000E-03  +1.88130000E-03  -2.52919000E-03  +8.75200000E-04  +6.95510000E-04
   -8.07820000E-04  -7.42300000E-04  -2.44620000E-04  +9.53590000E-04  -5.48520000E-04
   -7.55100000E-05  +1.18440000E-04  +3.27420000E-04  +2.59593000E-03  -6.12380000E-04
   -2.12000000E-05  +5.46700000E-05  +3.34080000E-04  +8.39300000E-05  +2.74180000E-04
   -2.65400000E-04  -1.10320000E-04  +7.54390000E-04  -6.55610000E-04  +2.41700000E-05
   +7.07100000E-05  -8.64900000E-05  -4.96500000E-05  +8.31590000E-04  -3.05100000E-05
   +2.96770000E-04  -4.47430000E-02  -1.09500570E-01  -6.36083000E-03  +1.32782100E-01
   +4.42352390E-01  +6.59342000E-03  +2.63609000E-03  -1.43557000E-03  +4.79810000E-04
   -7.49530000E-04  +3.89720000E-04  +1.77150000E-04  -2.94380000E-04  -1.95210000E-04
   +8.16300000E-05  +1.63880000E-04  -2.79540000E-04  -3.52750000E-04  -2.90810000E-04
   +1.42100000E-05  -1.45610000E-03  +8.73890000E-04  +2.47440000E-04  -1.72380000E-04
   +2.29170000E-04  +1.85960000E-04  +5.66600000E-05  -7.48700000E-05  -3.62200000E-05
   -7.25700000E-05  +6.29300000E-05  +1.30510000E-04  -6.43000000E-06  -3.32000000E-06
   +4.15000000E-06  -5.83120000E-04  +7.44300000E-05  +2.51180000E-04  +1.09475100E-02
   -4.27456000E-03  -8.37455900E-02  -1.46584840E-01  +1.78390550E-01  +5.20644920E-01
   -4.79980000E-04  +1.80888500E-02  +2.23934900E-02  -9.78170000E-04  +1.81347000E-03
   -4.41290000E-04  -1.41415000E-03  -1.18270000E-04  -1.02210000E-03  +2.07970000E-04
   -8.31980000E-04  +6.84240000E-04  -5.43500000E-05  -9.97190000E-04  -5.95310000E-04
   -4.78740000E-04  +8.75360000E-04  +1.64611000E-03  +2.85770000E-04  +3.91520000E-04
   +6.21870000E-04  -2.13470000E-04  +4.94200000E-05  +1.83000000E-06  -1.00595000E-03
   +8.61140000E-04  +9.32500000E-05  +3.70900000E-05  +5.33800000E-05  +2.72700000E-05
   -6.65700000E-05  +1.95250000E-04  +2.55400000E-05  -7.68189300E-02  -4.40052000E-03
   -6.02094000E-03  -4.12870000E-03  -1.75305700E-02  -2.36497100E-02  +5.83019760E-01
   +6.56989000E-03  -1.89353100E-02  -1.85670000E-02  -1.28641000E-03  -1.01402000E-03
   +6.47120000E-04  +7.72780000E-04  -2.06730000E-04  +7.80570000E-04  -4.44900000E-05
   +6.06670000E-04  -5.43710000E-04  -3.60000000E-05  +8.56250000E-04  +2.81460000E-04
   +3.56760000E-04  -3.44790000E-04  -1.63960000E-03  +3.85100000E-05  -1.86240000E-04
   -1.79150000E-04  +7.53600000E-05  +4.61500000E-05  +5.84000000E-05  +4.38940000E-04
   -4.14260000E-04  -2.28200000E-05  -9.81500000E-05  -8.80000000E-06  -2.84600000E-05
   +1.09470000E-04  -5.32740000E-04  -6.07700000E-05  -8.93408000E-03  -1.07693680E-01
   -4.71394200E-02  -6.94280000E-03  -1.47774400E-02  -1.71689400E-02  -1.09127600E-02
   +5.42054130E-01  +7.73961000E-03  -9.40218000E-03  -5.42348000E-03  -9.27380000E-04
   +7.89600000E-05  +1.08560000E-04  -3.65100000E-05  +2.70590000E-04  +4.80800000E-05
   -8.38900000E-05  -2.27350000E-04  +4.41970000E-04  +3.54700000E-04  +3.38100000E-05
   -5.18280000E-04  -1.52517000E-03  +1.24261000E-03  +1.16600000E-05  -1.15180000E-04
   -9.31900000E-05  -2.49500000E-05  -7.83700000E-05  +5.22000000E-05  +3.19000000E-06
   -2.58800000E-04  +1.98380000E-04  -4.78100000E-05  -1.02210000E-04  +3.81800000E-05
   -5.10000000E-06  +5.65700000E-05  +3.60860000E-04  -3.19800000E-05  -1.05387500E-02
   -4.41549200E-02  -1.39545040E-01  -4.47791000E-03  -8.54100000E-04  +2.35079000E-03
   -1.43565100E-02  -6.21741100E-02  +5.12262440E-01  -4.34297000E-03  +1.81312300E-02
   -2.33422500E-02  -1.18059000E-03  +7.47900000E-04  -7.08910000E-04  +5.17700000E-05
   +5.15760000E-04  -7.11000000E-04  +2.57590000E-04  -2.93970000E-04  +2.00130000E-04
   +2.96050000E-04  +1.28085000E-03  -9.64220000E-04  -4.73115000E-03  +2.12610000E-03
   +1.55416000E-03  -2.14891000E-03  +2.48481000E-03  -4.75610000E-04  -2.16800000E-05
   -5.49700000E-05  +1.21800000E-05  -4.48910000E-04  +3.51780000E-04  +4.73600000E-05
   -3.72570000E-04  +2.03690000E-04  +3.12400000E-05  -7.32700000E-05  -1.52750000E-04
   -2.51480000E-04  -7.68632200E-02  +4.75555000E-03  -6.06493000E-03  -4.84020000E-04
   -1.77297700E-02  +2.24601100E-02  -3.11800000E-05  +1.52846000E-03  -4.43811000E-03
   +5.83852050E-01  +7.15257000E-03  -1.50575900E-02  +1.65410100E-02  +1.93250000E-04
   -4.40730000E-04  -7.47960000E-04  -5.48740000E-04  -5.31190000E-04  +6.81720000E-04
   +1.84730000E-04  +2.48200000E-05  +4.17000000E-05  -1.37310000E-04  -7.13470000E-04
   +5.37980000E-04  +2.90605000E-03  -2.24000000E-04  -5.65770000E-04  +1.05887000E-03
   -5.24070000E-04  +8.37950000E-04  -8.72700000E-05  +4.58500000E-05  -3.44400000E-05
   -1.73800000E-05  -3.15800000E-05  +3.10200000E-05  +1.36390000E-04  -1.23880000E-04
   -6.40200000E-05  -1.22850000E-04  +3.93500000E-05  -1.10300000E-05  +9.37691000E-03
   -1.10070920E-01  +4.79438900E-02  -6.45070000E-03  -1.91227200E-02  +1.86169000E-02
   -1.70789000E-03  +1.07518400E-02  -1.37342500E-02  +9.73352000E-03  +5.38277710E-01
   -4.42613000E-03  +7.28300000E-05  +2.89486000E-03  +1.42994000E-03  -7.13650000E-04
   -1.07390000E-04  +1.67880000E-04  -1.97900000E-05  -1.35280000E-04  -8.23700000E-05
   +8.43100000E-05  +1.51640000E-04  +3.95640000E-04  -2.95540000E-04  +5.14230000E-04
   +1.48432000E-03  -8.48130000E-04  -3.81740000E-04  +8.48710000E-04  -4.71350000E-04
   +5.53830000E-04  +4.83100000E-05  -5.85600000E-05  -5.18300000E-05  +2.54670000E-04
   -1.98010000E-04  -6.42500000E-05  +1.27060000E-04  -1.13660000E-04  -1.99900000E-05
   -4.68700000E-05  -8.43200000E-05  -4.47000000E-06  -1.07508800E-02  +4.48992400E-02
   -1.37198000E-01  +7.31178000E-03  +8.98309000E-03  -4.20300000E-03  -4.62774000E-03
   +1.50242200E-02  -3.68052200E-02  -1.42367700E-02  +6.24805700E-02  +5.15016010E-01
   -1.03650000E-03  -1.46111000E-03  +2.58400000E-04  -9.95320000E-04  +7.18350000E-04
   +2.91310000E-04  +2.16020000E-04  -3.43870000E-04  +3.04630000E-04  +1.79400000E-05
   +1.77740000E-04  -3.69040000E-04  -2.28540000E-04  +2.06910000E-04  +1.64000000E-06
   +6.94350000E-04  -2.92000000E-06  +5.34350000E-04  -1.07300000E-05  -6.86000000E-05
   -3.91400000E-05  -5.85600000E-05  +2.35300000E-05  +4.71000000E-06  +3.88800000E-05
   -4.57800000E-05  +1.95800000E-05  -1.03000000E-06  +1.41900000E-05  +2.19700000E-05
   -1.03760000E-04  +3.48000000E-05  -4.18780000E-04  -1.68064900E-02  -6.15860000E-04
   +1.54820000E-02  -2.09590410E-01  -2.86226900E-02  +9.05560100E-02  -1.17970000E-03
   -4.31500000E-05  +1.20981000E-03  -8.07250000E-04  +1.37302000E-03  -7.32380000E-04
   +5.53463790E-01  -5.16240000E-04  -2.31958000E-03  +5.65700000E-04  -8.56800000E-04
   +7.31780000E-04  +1.19750000E-04  +9.26200000E-05  -1.43940000E-04  +2.67870000E-04
   +8.93900000E-05  +5.11400000E-05  -1.57150000E-04  -2.38670000E-04  +2.15460000E-04
   -9.91900000E-05  +5.30700000E-04  +4.24000000E-06  +2.21330000E-04  +3.34500000E-05
   -7.81100000E-05  -6.02400000E-05  -8.24700000E-05  +2.27600000E-05  -1.03000000E-06
   -7.73400000E-05  +5.06500000E-05  -6.56000000E-06  -1.54500000E-05  +3.21900000E-05
   +3.03200000E-05  +7.10400000E-05  -6.10900000E-05  -2.45380000E-04  -1.25773700E-02
   +5.64750000E-03  +1.35148400E-02  +1.16783200E-02  -1.06002290E-01  -5.55074300E-02
   -6.92010000E-04  -4.72280000E-04  +9.05200000E-04  -1.88056000E-03  -1.07353000E-03
   -7.90800000E-05  +1.84759800E-01  +4.78872770E-01  -2.24260000E-03  -1.03025000E-03
   +3.75500000E-04  +2.43340000E-04  -2.86800000E-05  -2.81200000E-04  -3.37510000E-04
   +5.45310000E-04  +9.57000000E-06  +7.82400000E-05  -3.46150000E-04  +3.59590000E-04
   +1.20580000E-04  -2.52270000E-04  +1.23090000E-04  -7.12440000E-04  +1.63840000E-04
   -6.96880000E-04  -3.07700000E-05  -8.52300000E-05  -2.75400000E-05  -4.07700000E-05
   +4.61600000E-05  +4.06100000E-05  -3.00840000E-04  +2.37170000E-04  +1.57300000E-05
   -6.42000000E-06  -2.43000000E-06  -3.95900000E-05  -5.74100000E-05  +8.53000000E-06
   +3.39310000E-04  +3.22826000E-03  +3.96517000E-03  +3.52825000E-03  +1.37894440E-01
   -2.21119800E-02  -2.12088080E-01  -6.49430000E-04  +6.77460000E-04  +7.65700000E-05
   -7.86030000E-04  -8.50100000E-04  +1.54300000E-05  -1.40108700E-01  +2.34372420E-01
   +5.42523730E-01  -1.90360000E-04  -6.13550000E-04  +1.05650000E-04  +2.30970000E-04
   -7.99400000E-05  -3.09450000E-04  -1.58710000E-04  +3.00430000E-04  -8.44700000E-05
   +1.21740000E-04  -2.70860000E-04  +2.64790000E-04  +1.64480000E-04  -3.75300000E-05
   -1.22480000E-04  -2.38250000E-04  -1.94370000E-04  -1.07600000E-05  +4.09200000E-05
   -1.77700000E-05  -9.78000000E-06  -1.50000000E-05  +2.56000000E-05  +1.90800000E-05
   -2.04900000E-04  +1.71700000E-04  -2.46300000E-05  -1.74200000E-05  +8.32000000E-06
   -2.23000000E-06  -1.66640000E-04  +1.08390000E-04  +3.10200000E-05  +1.26836000E-03
   +2.16000000E-06  +4.10030000E-03  -4.01210400E-02  +6.10565000E-03  +4.81524400E-02
   +1.01510000E-04  +5.07650000E-04  +1.72060000E-04  -1.46731000E-03  -8.67830000E-04
   -3.07400000E-05  -2.58348130E-01  -1.46098660E-01  +8.09700000E-04  +5.97391990E-01
   -9.48630000E-04  -1.00575000E-03  +3.24730000E-04  +2.40070000E-04  -6.03500000E-05
   -5.28040000E-04  -2.85820000E-04  +4.98820000E-04  -8.44600000E-05  +1.70760000E-04
   -4.63190000E-04  +3.88180000E-04  +2.12350000E-04  -1.46150000E-04  -1.21910000E-04
   -5.54910000E-04  -1.63140000E-04  +1.05060000E-04  +2.11900000E-05  -3.73300000E-05
   -2.94600000E-05  -2.98400000E-05  +5.15200000E-05  +3.30500000E-05  -3.47790000E-04
   +3.10850000E-04  -1.35200000E-05  -4.10300000E-05  +1.11300000E-05  -1.33800000E-05
   -1.56410000E-04  +8.74700000E-05  +1.67030000E-04  -9.49810000E-04  +3.33276000E-03
   -2.72477000E-03  -2.41161000E-02  +3.41000900E-02  +5.18657200E-02  -4.03900000E-04
   -4.52740000E-04  +1.43900000E-05  +1.75680000E-04  -1.61490000E-04  -3.16210000E-04
   -1.05387990E-01  -1.74064210E-01  -4.06020300E-02  +1.86357680E-01  +4.48573360E-01
   +6.60160000E-04  +5.61290000E-04  -1.27040000E-04  +3.81200000E-04  -2.66940000E-04
   -4.95500000E-05  -1.16130000E-04  +1.79900000E-04  -1.24230000E-04  +1.03410000E-04
   -1.56520000E-04  +9.79600000E-05  +5.74300000E-05  -7.29300000E-05  +7.20200000E-05
   -7.43000000E-05  +1.41150000E-04  -2.82580000E-04  +1.81800000E-05  -4.36000000E-06
   -5.47000000E-06  +9.90000000E-07  -1.08500000E-05  +4.63000000E-06  -1.58780000E-04
   +1.24090000E-04  +2.65400000E-05  +3.34000000E-06  -1.19400000E-05  -2.41900000E-05
   +3.61400000E-05  -1.74500000E-05  +1.08570000E-04  +3.75799000E-03  -3.99670000E-03
   -3.09240000E-04  +1.26726100E-02  +2.65090400E-02  +2.65756700E-02  -7.13970000E-04
   -6.67040000E-04  -1.59420000E-04  -1.05768000E-03  -8.78160000E-04  -7.48400000E-05
   +4.82516100E-02  -5.91199000E-03  -1.09333840E-01  -1.88635820E-01  +2.12948410E-01
   +5.45459310E-01  -1.77930000E-04  +4.24820000E-04  +1.10680000E-04  +8.54500000E-05
   -2.18470000E-04  +6.97200000E-05  +2.36080000E-04  -2.94910000E-04  +6.83100000E-05
   -5.43570000E-04  +5.37670000E-04  -1.24340000E-04  +2.51380000E-04  +1.67800000E-04
   -7.46000000E-05  -1.27850000E-04  -5.50200000E-05  +1.10310000E-04  -5.90800000E-05
   +3.14700000E-05  +2.09600000E-05  +9.42900000E-05  -2.91300000E-05  -3.93000000E-05
   +7.36670000E-04  -5.45500000E-04  -7.89100000E-05  -3.48000000E-06  -2.13700000E-05
   -2.87500000E-05  -2.67340000E-04  +2.21660000E-04  -2.88530000E-04  -2.25415000E-03
   -4.07480000E-04  +1.35780000E-04  -5.88941000E-03  +1.75127300E-02  +2.14548100E-02
   +3.76740000E-04  -1.76180000E-04  -2.79620000E-04  +6.61030000E-04  +1.95550000E-04
   +1.73020000E-04  +1.76077900E-02  -1.61136800E-02  -3.19678600E-02  -1.16272100E-01
   -4.88833200E-02  -1.82643900E-02  +5.74389040E-01  +2.40870000E-04  +1.00439000E-03
   -1.38330000E-04  -1.77240000E-04  +4.35300000E-05  +3.61560000E-04  +3.10870000E-04
   -5.34440000E-04  +1.15830000E-04  -4.14060000E-04  +6.08870000E-04  -3.28100000E-04
   -4.35400000E-05  +1.44220000E-04  +1.71200000E-05  +1.94310000E-04  -1.91700000E-05
   +1.20310000E-04  -6.05600000E-05  +5.04900000E-05  +3.70400000E-05  +6.42500000E-05
   -4.36400000E-05  -4.31700000E-05  +6.25330000E-04  -4.99790000E-04  -3.01900000E-05
   +2.06200000E-05  -1.21500000E-05  +4.09000000E-06  -6.38500000E-05  -2.01000000E-06
   -1.58550000E-04  +1.31530000E-04  -9.25100000E-04  -9.25750000E-04  +1.64481100E-02
   -2.19516500E-02  -3.30865900E-02  +2.48930000E-04  +7.70700000E-05  -8.30100000E-05
   +7.59660000E-04  +5.56130000E-04  +1.99810000E-04  -5.03136300E-02  -3.16747100E-02
   +3.41161000E-03  -3.27097000E-03  -1.94848400E-01  -1.42487910E-01  +1.80411520E-01
   +4.83284640E-01  +5.99070000E-04  +5.45730000E-04  -3.46210000E-04  -5.24090000E-04
   +2.36110000E-04  +4.47970000E-04  +2.59870000E-04  -4.30690000E-04  +1.11670000E-04
   -4.36300000E-05  +2.92730000E-04  -3.49410000E-04  -3.00950000E-04  +1.01140000E-04
   +4.01000000E-05  +4.48390000E-04  +1.37060000E-04  +2.13560000E-04  +1.72000000E-06
   +2.74400000E-05  -7.80000000E-07  -1.89000000E-06  -2.28200000E-05  -1.58300000E-05
   +1.41330000E-04  -1.34060000E-04  +2.24800000E-05  +1.44800000E-05  +9.67000000E-06
   +3.69200000E-05  +1.84790000E-04  -1.84880000E-04  -5.62300000E-05  +1.32686000E-03
   -2.32970000E-04  -1.60300000E-03  +1.98999700E-02  -3.38954400E-02  -6.32066500E-02
   +8.03400000E-05  -5.16600000E-05  +3.00840000E-04  +4.61330000E-04  +5.29660000E-04
   +3.30470000E-04  -7.27577900E-02  -2.56886300E-02  +3.39122600E-02  +3.55088500E-02
   -1.02415860E-01  -2.22931170E-01  -1.45270020E-01  +2.18475380E-01  +5.45225230E-01
   +5.38770000E-04  +2.09220000E-04  -4.66190000E-04  -4.10750000E-04  +2.88260000E-04
   +3.00870000E-04  +1.69770000E-04  -2.37990000E-04  +7.29100000E-05  +1.41240000E-04
   +5.01000000E-05  -2.45300000E-04  -3.09990000E-04  +3.71500000E-05  +6.82100000E-05
   +4.27310000E-04  +7.07900000E-05  +2.61610000E-04  +6.58000000E-06  +6.88000000E-06
   -9.84000000E-06  -4.30900000E-05  -9.95000000E-06  -3.85000000E-06  -1.57680000E-04
   +9.60200000E-05  +4.93200000E-05  -1.30000000E-06  +1.81100000E-05  +2.53500000E-05
   +3.02680000E-04  -2.78800000E-04  -2.43700000E-05  +4.36204000E-03  -3.10780000E-04
   +9.41850000E-04  +1.47811000E-02  -4.82942900E-02  -6.37372400E-02  +2.81740000E-04
   +2.16250000E-04  +4.26820000E-04  -1.81710000E-04  +5.73400000E-05  +2.97570000E-04
   -5.72009600E-02  -1.51053700E-02  +2.76186800E-02  +4.03095700E-02  +5.06290500E-02
   +3.17898100E-02  -1.93944280E-01  -2.56019700E-02  +7.84745500E-02  +5.62164870E-01
   +7.23760000E-04  -1.25100000E-05  +2.62530000E-04  -3.94260000E-04  +2.78670000E-04
   +3.47340000E-04  +7.93700000E-05  -2.08280000E-04  +9.04300000E-05  -9.07500000E-05
   +1.60230000E-04  -1.96700000E-04  -1.05610000E-04  +9.73600000E-05  +1.03470000E-04
   +1.73080000E-04  +3.41600000E-04  +1.53670000E-04  +1.59000000E-06  -1.58500000E-05
   -2.19200000E-05  -1.05800000E-05  -2.10000000E-07  -7.97000000E-06  +1.10750000E-04
   -7.61200000E-05  +1.51300000E-05  -4.11700000E-05  +4.01000000E-06  -2.43700000E-05
   +7.84100000E-05  -2.54910000E-04  -1.63690000E-04  -7.24000000E-06  +1.06126000E-03
   -5.55092000E-03  -1.71042800E-02  -2.77599700E-02  -2.74052800E-02  -1.06230000E-03
   -5.30190000E-04  +3.11820000E-04  +6.57250000E-04  +7.64620000E-04  -9.23800000E-05
   -1.75498000E-02  -8.14523000E-03  +9.59270000E-03  +2.27421800E-02  +1.52303200E-02
   -1.19077700E-02  +2.34522100E-02  -1.12148850E-01  -7.02289800E-02  +1.98849530E-01
   +4.78436940E-01  +4.39570000E-04  -1.03600000E-04  +1.25350000E-04  +2.85810000E-04
   -1.28070000E-04  -3.21700000E-05  -1.09880000E-04  +1.29960000E-04  +6.68000000E-06
   -1.88870000E-04  +4.06400000E-05  +8.60100000E-05  +2.65330000E-04  +7.73000000E-06
   -4.92000000E-05  -2.66090000E-04  +1.60150000E-04  -1.93970000E-04  -5.83500000E-05
   -5.06900000E-05  +8.01000000E-06  +2.03900000E-05  -8.22000000E-06  -1.30100000E-05
   +1.91520000E-04  -1.44900000E-04  -3.00100000E-05  +8.04000000E-06  -1.20000000E-05
   -9.20000000E-06  -6.73800000E-05  +1.38790000E-04  -3.07700000E-05  +8.51460000E-04
   -4.38206000E-03  -1.75998000E-03  -2.55560200E-02  -2.86920000E-04  +3.10558700E-02
   -9.00890000E-04  -6.70900000E-04  +1.46940000E-04  +1.75840000E-04  +2.20600000E-05
   -2.39540000E-04  +2.55907600E-02  +7.76522000E-03  -1.62308400E-02  -9.29170000E-04
   -3.59790000E-02  -3.29488400E-02  +1.35205130E-01  -2.77184200E-02  -2.18738070E-01
   -1.43709810E-01  +2.38535230E-01  +5.27210010E-01  -1.03641000E-03  -2.71792000E-03
   -1.33278000E-03  +8.70400000E-04  -4.03640000E-04  -7.99550000E-04  -3.30120000E-04
   +6.46740000E-04  -5.07500000E-05  +6.28700000E-05  -3.26910000E-04  +3.92090000E-04
   +3.99620000E-04  -1.35710000E-04  -7.07600000E-05  -1.42386000E-03  -1.99610000E-04
   -7.25230000E-04  -3.59500000E-05  -1.07700000E-04  -1.87400000E-05  -2.32800000E-05
   +1.49400000E-05  +9.97000000E-06  -1.88610000E-04  +1.72880000E-04  -4.33000000E-06
   -1.27100000E-05  -1.55900000E-05  -3.61700000E-05  -3.76930000E-04  +2.59430000E-04
   +9.97300000E-05  -5.41454000E-03  -2.01938600E-02  -1.93281900E-02  -1.17581620E-01
   -1.64185800E-02  +2.25429500E-02  -4.67763000E-03  -3.04835000E-03  +1.53535000E-03
   -5.17650000E-04  -3.50220000E-04  -1.67123000E-03  +4.10918200E-02  +2.38310900E-02
   +8.72670000E-04  -2.29678500E-02  -2.77172700E-02  -1.53562300E-02  -4.46168700E-02
   +9.03451000E-03  +5.10270000E-02  -2.63434100E-01  -1.51748700E-01  -1.43896000E-03
   +6.00185910E-01  +7.05750000E-04  -3.60720000E-04  -1.04530000E-03  -1.20900000E-04
   +6.02500000E-05  -2.10600000E-05  +1.96970000E-04  -1.82160000E-04  -6.06500000E-05
   +4.24400000E-05  -2.77000000E-05  -9.53000000E-05  +2.03600000E-05  +1.67980000E-04
   -3.14490000E-04  +2.64090000E-04  -5.28760000E-04  +9.40270000E-04  +9.98400000E-05
   +7.44600000E-05  +4.49000000E-06  +4.65000000E-06  -1.88000000E-06  -4.95000000E-06
   -9.70000000E-06  +3.39200000E-05  -3.97200000E-05  -1.39400000E-05  +2.68400000E-05
   +3.98800000E-05  +1.19020000E-04  +3.31830000E-04  -3.47820000E-04  -9.23124000E-03
   -1.51059600E-02  -1.13663600E-02  -5.64034300E-02  -1.95815800E-01  -9.63474700E-02
   -2.44873000E-03  -4.79760000E-04  +9.84650000E-04  -9.94490000E-04  -4.64600000E-04
   -1.09273000E-03  +5.52574900E-02  +1.36531700E-02  -4.10754200E-02  -2.97143200E-02
   -4.33459800E-02  -2.16325800E-02  -2.53339600E-02  +3.68487900E-02  +6.16817800E-02
   -1.10972890E-01  -1.77497180E-01  -4.21437700E-02  +1.76407230E-01  +4.47899470E-01
   -3.88670000E-04  -3.54400000E-05  +9.63100000E-05  +4.00260000E-04  -5.55200000E-05
   -5.53890000E-04  -5.54000000E-06  -7.16100000E-05  -2.52960000E-04  +1.01900000E-04
   -1.42390000E-04  +2.09980000E-04  +1.29580000E-04  -1.05130000E-04  -2.03110000E-04
   -5.42280000E-04  -8.80400000E-04  +7.06500000E-05  +8.65800000E-05  +1.36890000E-04
   +8.03200000E-05  +3.27900000E-05  +1.77500000E-05  +9.56000000E-06  -4.65400000E-05
   +3.94800000E-05  -4.74400000E-05  +2.09000000E-05  +1.99000000E-06  +3.39500000E-05
   -3.29100000E-04  +2.87690000E-04  -1.38270000E-04  -5.02534000E-03  -3.59560000E-04
   +5.82706000E-03  -2.52830400E-02  -1.30659640E-01  -2.01593790E-01  +1.60143000E-03
   +7.36350000E-04  -1.71530000E-04  +8.46560000E-04  +1.17636000E-03  -1.10800000E-04
   +3.72624100E-02  -1.42772000E-02  -4.01673700E-02  -1.75883700E-02  -2.35193700E-02
   -1.53995400E-02  +1.08511600E-02  +3.22976200E-02  +3.07517000E-02  +4.58346600E-02
   -7.20961000E-03  -1.07381940E-01  -1.80833920E-01  +2.00315480E-01  +5.28304510E-01
   -2.07200000E-04  -6.96100000E-05  -1.38920000E-04  -4.47300000E-05  -7.00000000E-07
   -2.04500000E-05  +4.76800000E-05  -3.64700000E-05  +2.97900000E-05  -7.21100000E-05
   +6.49500000E-05  +8.41000000E-06  -9.25000000E-06  +1.29000000E-05  -7.16100000E-05
   -1.69600000E-05  -1.21100000E-04  +9.32700000E-05  -5.99000000E-06  +1.08300000E-05
   +2.62000000E-06  +1.30600000E-05  +3.24000000E-06  -1.48000000E-06  +9.34400000E-05
   -7.03400000E-05  -1.86800000E-05  +4.95000000E-06  +2.30000000E-06  +7.26000000E-06
   +4.96200000E-05  +7.21900000E-05  +9.75000000E-06  -2.82460000E-04  +1.49175000E-03
   -1.25754000E-03  +8.02255000E-03  +1.47522700E-02  +1.42966500E-02  -2.70143000E-03
   -1.55705000E-03  +1.05036000E-03  +3.69450000E-04  +1.65600000E-05  -1.07810000E-04
   -5.85289100E-02  -2.73589300E-02  -1.58117600E-02  +8.80170000E-04  -1.86197100E-02
   -1.91895400E-02  -1.66008000E-03  -4.89933000E-03  +2.64331000E-03  -1.29874000E-03
   -2.18200000E-05  +1.55220000E-04  -1.41764000E-03  -1.35114000E-03  +5.34906000E-03
   +5.98523000E-02  +2.40790000E-04  +3.48630000E-04  -1.91930000E-04  +1.19740000E-04
   -9.89900000E-05  +6.74100000E-05  +1.25300000E-05  -2.62700000E-05  -1.43200000E-05
   +3.95000000E-06  +4.32200000E-05  -4.60100000E-05  -6.94000000E-06  -4.19000000E-06
   +9.52600000E-05  +9.04100000E-05  +9.28300000E-05  -1.68240000E-04  -1.24200000E-05
   -2.59000000E-06  +7.53000000E-06  +9.72000000E-06  -1.23400000E-05  -2.93000000E-06
   +1.97100000E-05  -2.68600000E-05  +1.47300000E-05  +8.57000000E-06  -1.22900000E-05
   -1.36900000E-05  +1.28900000E-05  -7.83300000E-05  -3.82800000E-05  +7.93880000E-04
   -2.31361000E-03  +1.16609000E-03  -6.50520000E-04  +1.68768000E-03  -2.73128000E-03
   -2.80073000E-03  -7.90850000E-04  +5.32650000E-04  -4.23110000E-04  -2.28840000E-04
   +1.03900000E-04  -2.70871800E-02  -1.83554410E-01  -1.47216160E-01  -9.16390000E-04
   -8.71961000E-03  -1.41560000E-02  -4.98034000E-03  +2.95887000E-03  -1.62259000E-03
   +6.02200000E-05  -2.45520000E-04  +9.55940000E-04  -1.28792000E-03  +3.73704000E-03
   -2.37707000E-03  +3.70244700E-02  +1.91531450E-01  -1.69300000E-04  -9.91700000E-05
   +1.65760000E-04  -6.20300000E-05  +6.91700000E-05  -6.38000000E-06  -1.57000000E-06
   +1.53400000E-05  +6.42000000E-06  +2.07300000E-05  -3.39200000E-05  -1.18900000E-05
   +3.08000000E-06  -1.47000000E-06  -2.01000000E-06  -1.22700000E-05  +1.39100000E-05
   +9.74400000E-05  +3.18000000E-06  -8.50000000E-06  -1.48900000E-05  -1.05900000E-05
   +7.00000000E-07  -8.30000000E-07  -4.19100000E-05  +4.16400000E-05  +5.22000000E-06
   -9.62000000E-06  +3.30000000E-06  -1.07000000E-06  -1.30000000E-06  -2.72800000E-05
   -3.12200000E-05  -2.26382000E-03  +3.88730000E-04  -1.38053000E-03  -4.18003000E-03
   -1.61540600E-02  -1.10895100E-02  -2.69290000E-04  -7.28220000E-04  +4.02090000E-04
   +5.76900000E-04  +1.97800000E-04  -2.61400000E-05  -1.52704200E-02  -1.47325760E-01
   -2.00357420E-01  +1.63964000E-03  +1.20408000E-03  +3.98865000E-03  +2.52382000E-03
   -1.63589000E-03  +3.79725000E-03  +2.77970000E-04  +1.02153000E-03  -1.28620000E-04
   +5.39499000E-03  -2.14186000E-03  -5.45410000E-04  +1.50220600E-02  +1.62763000E-01
   +2.06410340E-01  +3.17800000E-05  -2.04540000E-04  +2.06600000E-05  -7.47300000E-05
   +7.84800000E-05  -1.42600000E-05  -1.20300000E-05  +1.42200000E-05  +9.71000000E-06
   +3.43500000E-05  -3.64700000E-05  +1.60500000E-05  -3.28900000E-05  -2.87000000E-06
   -2.54600000E-05  -4.85000000E-06  -1.39200000E-05  +5.42600000E-05  +1.16500000E-05
   -8.08000000E-06  -8.37000000E-06  -1.25800000E-05  +6.37000000E-06  +2.33000000E-06
   -5.28500000E-05  +4.40100000E-05  -9.00000000E-07  -1.06100000E-05  +8.24000000E-06
   +6.87000000E-06  +8.60000000E-07  -2.29400000E-05  +1.56800000E-05  -1.19680000E-04
   +4.63220000E-04  +8.69240000E-04  -9.88460000E-04  -5.44625000E-03  +7.69840000E-04
   -1.44100000E-05  +1.03590000E-04  +4.74200000E-05  -2.17810000E-04  -9.25600000E-05
   -7.70400000E-05  -1.20480100E-02  +4.87532000E-03  +1.84594500E-02  -1.84449910E-01
   +1.42891300E-02  +1.47325040E-01  +5.68226000E-03  -2.42424000E-03  -3.13611000E-03
   +1.98281000E-03  -2.42994000E-03  +4.07560000E-04  -3.23910000E-04  -1.87390000E-04
   -9.06240000E-04  -3.98340000E-04  +1.63570000E-03  -1.62925000E-03  +1.91183400E-01
   -2.08570000E-04  -2.42600000E-04  +4.67300000E-05  -2.27700000E-05  +2.10700000E-05
   -3.87100000E-05  -2.64600000E-05  +4.70600000E-05  +1.61300000E-05  +1.25500000E-05
   -3.83000000E-05  +2.28900000E-05  +1.08800000E-05  +8.00000000E-08  -3.42000000E-06
   -8.61000000E-06  +4.39000000E-06  -2.01300000E-05  -4.09000000E-06  -1.14300000E-05
   -1.83000000E-06  -7.31000000E-06  +7.84000000E-06  +5.81000000E-06  -3.52500000E-05
   +2.47800000E-05  +1.65000000E-06  +2.30000000E-06  +1.27000000E-06  -2.85000000E-06
   -3.28000000E-06  +7.50000000E-06  -4.68000000E-06  -4.56720000E-04  +5.07450000E-04
   +4.34070000E-04  -5.08413000E-03  +1.16163000E-03  -2.48122000E-03  +6.94700000E-05
   +4.11100000E-05  +6.71600000E-05  -6.47100000E-05  +4.16400000E-05  -4.85200000E-05
   -1.23985200E-02  +5.72487000E-03  +1.47278900E-02  +1.33050100E-02  -5.28788400E-02
   -3.23778800E-02  +1.59837600E-02  +3.24985000E-03  -1.65080700E-02  -2.75802000E-03
   -5.61340000E-04  -4.93816000E-03  -3.78960000E-04  -1.31667000E-03  +5.76500000E-05
   +1.97511000E-03  -1.43788000E-03  +1.85731000E-03  -1.27228400E-02  +4.64470400E-02
   +1.04550000E-04  +7.17200000E-05  -1.08700000E-05  -3.22000000E-06  +4.85000000E-06
   +3.19200000E-05  +1.90100000E-05  -3.02600000E-05  +2.43000000E-06  -2.24900000E-05
   +3.54600000E-05  -1.61900000E-05  -3.03000000E-06  +8.70000000E-06  -2.84000000E-06
   +2.82000000E-06  +2.10000000E-06  +1.05000000E-05  +8.30000000E-07  +2.17000000E-06
   -7.10000000E-07  +3.05000000E-06  -4.91000000E-06  -4.63000000E-06  +3.78100000E-05
   -2.56400000E-05  -2.61000000E-06  -2.73000000E-06  -2.30000000E-07  -4.60000000E-07
   -9.29000000E-06  +1.65000000E-06  -8.58000000E-06  -8.29000000E-05  -1.91850000E-04
   +2.03850000E-04  +8.86060000E-04  -2.21524000E-03  +3.71721000E-03  +7.99000000E-06
   +4.26100000E-05  -4.77600000E-05  +6.10000000E-07  -5.69700000E-05  -2.29000000E-06
   -1.84764000E-03  -4.38390000E-04  +3.56182000E-03  +1.46267350E-01  -3.33136500E-02
   -2.02739240E-01  +1.85839700E-02  -2.53010000E-04  -1.12345700E-02  -4.47000000E-06
   -5.24163000E-03  -4.79350000E-04  -1.21958000E-03  -1.56560000E-04  -2.16820000E-04
   -1.22851000E-03  +2.16784000E-03  -8.21580000E-04  -1.60675450E-01  +3.67256800E-02
   +2.08818860E-01  +4.54000000E-05  -9.19620000E-04  -1.26510000E-04  -1.04000000E-05
   +1.68970000E-04  -3.13400000E-04  -3.28490000E-04  +5.07370000E-04  -1.14970000E-04
   +6.56340000E-04  -7.49050000E-04  +2.74270000E-04  -2.05260000E-04  -2.02630000E-04
   +1.57200000E-05  -3.60100000E-05  -7.24000000E-06  -4.72000000E-06  +8.84600000E-05
   -4.63400000E-05  -4.48000000E-05  -1.14400000E-04  +5.21500000E-05  +5.58300000E-05
   -9.33020000E-04  +7.15030000E-04  +7.95500000E-05  -2.39500000E-05  +3.21000000E-05
   +1.65200000E-05  +1.78020000E-04  -2.10650000E-04  +3.14870000E-04  +1.63780000E-03
   +8.51130000E-04  +4.77520000E-04  -2.57770000E-03  -2.25359000E-03  -2.54059000E-03
   -5.25180000E-04  +1.80900000E-05  +3.61700000E-04  -1.26957000E-03  -5.36340000E-04
   -4.41470000E-04  +1.67940000E-03  +4.34970000E-04  +3.46428000E-03  -9.46074000E-03
   -1.87533500E-02  -7.04299000E-03  -2.34429170E-01  -1.00324430E-01  +4.79350000E-02
   -3.90569000E-02  -3.08703100E-02  +6.22943000E-03  +3.58068000E-03  +2.07336000E-03
   +5.54716000E-03  -6.14900000E-05  -2.07190000E-04  -1.59260000E-04  -1.58920000E-04
   +1.55903000E-03  -1.21897000E-03  +3.16021120E-01  -6.04000000E-06  -8.13890000E-04
   -1.47430000E-04  +2.75000000E-05  +8.95400000E-05  -2.72760000E-04  -2.57350000E-04
   +4.43650000E-04  -9.39100000E-05  +4.94860000E-04  -5.98120000E-04  +2.31190000E-04
   -1.05340000E-04  -1.65150000E-04  +3.81200000E-05  -1.08300000E-04  +3.72900000E-05
   -4.37000000E-06  +6.69500000E-05  -4.62400000E-05  -4.48600000E-05  -8.70400000E-05
   +3.72100000E-05  +3.90400000E-05  -7.17120000E-04  +5.71420000E-04  +5.95400000E-05
   -4.10700000E-05  +2.17500000E-05  -1.31000000E-06  +1.30490000E-04  -1.70920000E-04
   +2.19330000E-04  +1.27912000E-03  +3.06620000E-04  +9.82740000E-04  -2.60775000E-03
   +1.72990000E-04  +3.27995000E-03  -3.76330000E-04  -9.24000000E-06  +2.49130000E-04
   -1.00169000E-03  -4.71390000E-04  -3.32420000E-04  +4.31756000E-03  +3.12980000E-03
   -6.15155000E-03  -4.12134500E-02  -2.80885800E-02  -5.97053000E-03  -1.30572140E-01
   -1.44062550E-01  -4.16838000E-03  -7.61949000E-03  +3.65873000E-03  -3.10560000E-04
   -2.94640000E-03  +6.10420000E-04  -5.21550000E-03  -9.67140000E-04  -7.80250000E-04
   -1.33850000E-04  +1.71789000E-03  -3.46690000E-04  +2.28617000E-03  +1.70465320E-01
   +3.98510220E-01  -7.21400000E-05  -9.15200000E-05  +1.55390000E-04  +3.87500000E-05
   +7.89000000E-06  -1.02900000E-05  -4.09200000E-05  +3.90500000E-05  +1.00900000E-05
   -3.15000000E-06  -1.73000000E-05  +1.06600000E-05  +3.37400000E-05  +1.79000000E-06
   +2.05400000E-05  -2.30800000E-05  +5.84400000E-05  -6.90200000E-05  -7.92000000E-06
   -1.46400000E-05  -2.76000000E-06  -4.75000000E-06  +1.43000000E-06  +1.27000000E-06
   -1.86000000E-06  +1.44000000E-06  +7.01000000E-06  +5.60000000E-06  -4.72000000E-06
   -1.02600000E-05  -1.46100000E-05  +9.25000000E-06  +1.98000000E-06  -3.35920000E-04
   +3.58240000E-04  +1.08240000E-04  -2.11280000E-03  +3.59877000E-03  +4.76583000E-03
   +1.52200000E-05  -2.33000000E-05  -5.22400000E-05  -6.59600000E-05  -7.31500000E-05
   -7.97600000E-05  +8.24192000E-03  -2.73424000E-03  -5.11274000E-03  -3.35499600E-02
   -2.57281400E-02  +6.63800000E-03  +1.29776800E-02  -3.01195300E-02  -9.00266500E-02
   +3.31241100E-02  +1.98331300E-02  +4.07385000E-03  -1.71730000E-04  -9.50105000E-03
   -3.69863000E-03  -1.05329000E-03  -7.93910000E-04  +2.35600000E-05  -9.90820000E-04
   +2.47912000E-03  +1.64830000E-04  -5.12301400E-02  +2.84726090E-01  +4.01669750E-01
   +1.27120000E-04  -5.93800000E-05  -9.32000000E-06  +5.09000000E-06  +1.72200000E-05
   -2.34300000E-05  -2.91400000E-05  +5.48100000E-05  -1.13000000E-06  +5.31300000E-05
   -5.91100000E-05  +8.30000000E-06  +3.22000000E-06  -1.00000000E-06  +3.01500000E-05
   -2.78700000E-05  +2.30600000E-05  +2.64900000E-05  +7.91000000E-06  -8.52000000E-06
   -8.27000000E-06  -1.67000000E-05  -7.20000000E-07  +2.10000000E-07  -7.67900000E-05
   +7.57600000E-05  +1.60400000E-05  -1.90600000E-05  +2.59000000E-06  -1.63500000E-05
   +8.15000000E-06  -3.45900000E-05  +1.11000000E-06  +5.12320000E-04  -6.91380000E-04
   -9.56790000E-04  -2.07346000E-03  -4.96837000E-03  +2.51550000E-03  -3.70890000E-04
   -1.33680000E-04  +1.42590000E-04  -5.08000000E-06  +7.23900000E-05  -1.10770000E-04
   -1.53002000E-03  -1.85870000E-04  +3.20250000E-04  -1.43196000E-03  -9.87160000E-04
   +4.78119000E-03  +5.89621000E-03  +1.42091700E-02  +1.48667100E-02  -5.75460100E-02
   -2.98099000E-02  -1.38802400E-02  +1.45058000E-03  -1.79236700E-02  -1.98091800E-02
   -1.18380000E-04  +2.20610000E-04  -2.63780000E-04  +2.64710000E-04  +8.31440000E-04
   +6.98630000E-04  +1.56325000E-03  +2.83684000E-03  -1.35427000E-03  +5.43608000E-02
   +1.89050000E-04  -1.37490000E-04  -9.07000000E-06  -1.40600000E-05  +3.48300000E-05
   -4.76000000E-06  -2.35800000E-05  +3.43500000E-05  +8.39000000E-06  +6.22400000E-05
   -5.49400000E-05  -5.00000000E-07  -2.74000000E-05  -7.75000000E-06  +1.52000000E-06
   +2.85800000E-05  +2.71200000E-05  -2.74000000E-06  +2.39000000E-06  -1.46500000E-05
   -5.22000000E-06  -1.68700000E-05  +2.35000000E-06  +3.18000000E-06  -8.29700000E-05
   +6.15800000E-05  +1.36800000E-05  +4.20000000E-07  +2.59000000E-06  +1.66000000E-06
   +1.10700000E-05  -1.27800000E-05  +2.87400000E-05  +1.53260000E-04  -9.30600000E-05
   -8.69100000E-04  -5.16968000E-03  +2.56975000E-03  -1.18134000E-03  -2.88210000E-04
   -1.88350000E-04  +1.38400000E-04  -6.42800000E-05  -1.05300000E-05  -1.85200000E-05
   +7.87200000E-05  -1.59170000E-04  +7.74920000E-04  -6.28240000E-04  +3.37587000E-03
   -1.81829000E-03  -4.87181000E-03  -1.14613000E-03  -1.84431000E-03  -2.99535700E-02
   -1.81522490E-01  -1.45718180E-01  -6.03900000E-05  -9.49057000E-03  -1.39209900E-02
   +2.45820000E-04  -3.68200000E-04  +1.99030000E-04  -2.10900000E-05  -1.40140000E-04
   -5.24200000E-05  +2.48035000E-03  +4.45660000E-04  +2.82719000E-03  +3.56739900E-02
   +1.88223950E-01  -6.29700000E-05  -1.53600000E-05  -2.13000000E-06  +1.90200000E-05
   -4.57000000E-06  -5.22700000E-05  -2.26100000E-05  +4.55800000E-05  -2.27100000E-05
   +4.55400000E-05  -5.95400000E-05  +3.25800000E-05  +8.01000000E-06  -1.30800000E-05
   +2.20500000E-05  -3.36100000E-05  -1.89300000E-05  +2.49000000E-05  +1.06600000E-05
   +4.45000000E-06  -3.80000000E-06  -5.23000000E-06  +3.62000000E-06  +2.58000000E-06
   -6.51500000E-05  +6.09500000E-05  +3.57000000E-06  -1.66100000E-05  +1.31000000E-06
   -1.20000000E-05  +9.24000000E-06  -2.53900000E-05  -3.15000000E-06  +3.43780000E-04
   -7.98800000E-05  +1.05440000E-04  +1.95309000E-03  -1.72499000E-03  +3.83808000E-03
   -3.94200000E-05  +4.62000000E-05  +2.38900000E-05  -4.38400000E-05  +4.50000000E-07
   -4.86300000E-05  +5.68800000E-04  +1.00588000E-03  -1.89630000E-04  +5.22737000E-03
   -1.47946000E-03  -8.33330000E-04  -7.01763000E-03  -1.82990300E-02  -1.10925100E-02
   -1.41954500E-02  -1.45666860E-01  -1.89880190E-01  +9.63890000E-04  +1.59109000E-03
   +3.59780000E-03  -2.36410000E-04  +2.30150000E-04  -2.53700000E-04  -3.21670000E-04
   -7.84330000E-04  -7.34760000E-04  -1.89300000E-03  +2.43382000E-03  +6.07450000E-04
   +1.45774800E-02  +1.60355050E-01  +1.96379670E-01  -6.96580000E-04  -6.19770000E-04
   -3.88750000E-04  +8.38000000E-06  -1.11900000E-05  -4.05400000E-05  -1.25270000E-04
   +8.27700000E-05  +8.99000000E-06  -1.71330000E-04  +7.27600000E-05  +9.02800000E-05
   +2.20450000E-04  -1.75900000E-05  +1.70000000E-06  -3.72300000E-04  -4.58900000E-05
   -3.21560000E-04  +5.09100000E-05  -7.19000000E-06  -2.29000000E-06  +1.31800000E-05
   +4.09000000E-06  -6.22000000E-06  +1.44690000E-04  -1.07110000E-04  -2.46300000E-05
   -1.16000000E-06  -5.21000000E-06  -6.65000000E-06  +4.34100000E-05  +2.40600000E-05
   +4.73200000E-05  -8.82290000E-04  +5.82500000E-04  -9.62430000E-04  +6.29879000E-03
   -7.44320000E-04  -2.75073000E-03  -1.63000000E-05  +1.39180000E-04  -6.40500000E-05
   -3.20400000E-05  -1.61760000E-04  +1.24120000E-04  +2.32091000E-03  -2.48431000E-03
   +4.15040000E-04  -3.78390000E-04  -1.64590000E-04  -9.09560000E-04  -5.06840000E-04
   -5.51366000E-03  +6.83090000E-04  -1.28889000E-02  +4.57654000E-03  +1.95926100E-02
   -1.83191260E-01  +1.93403900E-02  +1.41994360E-01  +2.57090000E-04  -1.24470000E-04
   -2.51220000E-04  -1.89280000E-04  +2.42060000E-04  -1.34670000E-04  -1.33478000E-03
   -5.03200000E-05  +9.78590000E-04  -3.22310000E-04  +1.55454000E-03  -1.62906000E-03
   +1.91368370E-01  -4.83490000E-04  -9.20300000E-05  +3.55000000E-05  +8.59800000E-05
   -5.92600000E-05  -1.02310000E-04  -1.10670000E-04  +1.03180000E-04  +2.85000000E-06
   -1.38290000E-04  -2.04300000E-05  +1.30450000E-04  +1.95100000E-04  -1.02370000E-04
   -1.61400000E-05  -2.22520000E-04  +2.54700000E-04  -3.46910000E-04  -7.38400000E-05
   -7.16600000E-05  +2.16100000E-05  +2.21800000E-05  +8.10000000E-06  -7.60000000E-07
   +1.33740000E-04  -1.21580000E-04  -2.40900000E-05  +2.62400000E-05  -1.23100000E-05
   +1.09900000E-05  -1.15800000E-05  +3.65200000E-05  +9.18200000E-05  +1.62247000E-03
   -9.28790000E-04  +1.08215000E-03  +1.60323900E-02  +2.51646000E-03  -1.53680400E-02
   +1.38150000E-04  +4.66000000E-06  +1.09940000E-04  -1.68980000E-04  -5.96290000E-04
   -4.24120000E-04  -3.02686000E-03  -3.57370000E-04  -5.36617000E-03  -1.70530000E-04
   -1.06989000E-03  +2.80420000E-04  -5.28403000E-03  +1.36130000E-03  -3.12501000E-03
   -1.37590100E-02  +6.08486000E-03  +1.39948500E-02  +1.98437800E-02  -5.69157400E-02
   -3.64666900E-02  +8.59870000E-04  -5.00200000E-05  -8.38680000E-04  +2.74970000E-04
   -2.55120000E-04  +2.86210000E-04  -8.46080000E-04  -2.04000000E-05  +8.07210000E-04
   +1.92725000E-03  -1.44774000E-03  +1.90325000E-03  -1.66848800E-02  +5.22279000E-02
   -2.10790000E-04  -3.22530000E-04  +3.10570000E-04  -4.20510000E-04  +2.17790000E-04
   +3.23660000E-04  +4.80200000E-05  -2.10780000E-04  +1.05260000E-04  -1.85370000E-04
   +2.01600000E-04  -1.47860000E-04  -2.83700000E-05  +1.29260000E-04  +8.84300000E-05
   +4.60400000E-05  +4.56320000E-04  -1.70300000E-04  +3.15000000E-06  +1.39000000E-05
   -2.79700000E-05  +1.95500000E-05  +4.39000000E-06  -5.84000000E-06  +2.52320000E-04
   -1.81230000E-04  -1.11300000E-05  -8.64000000E-06  -1.29500000E-05  -2.88000000E-05
   +7.27000000E-05  -8.82800000E-05  -2.74500000E-05  +1.52010000E-04  +1.86968000E-03
   -1.12526000E-03  +1.62990100E-02  -1.71809000E-03  -1.12463100E-02  -2.23560000E-04
   +2.01200000E-05  +4.43000000E-06  +5.32000000E-06  +3.51500000E-05  -9.28800000E-05
   +2.80280000E-04  -5.89717000E-03  -4.69420000E-04  -1.10339000E-03  +1.33030000E-04
   -1.36080000E-04  +1.08727000E-03  -2.73347000E-03  +4.07322000E-03  -8.83890000E-04
   -1.42693000E-03  +3.07575000E-03  +1.41350250E-01  -3.55264400E-02  -1.97378280E-01
   +8.65030000E-04  +1.26000000E-06  -7.33860000E-04  -1.32020000E-04  +3.08670000E-04
   -2.52990000E-04  +2.01570000E-04  +1.44640000E-04  -4.37800000E-05  -1.35330000E-03
   +2.22198000E-03  -9.25520000E-04  -1.56119770E-01  +4.21436800E-02  +2.04497890E-01
   +4.20440000E-04  +5.16740000E-04  -8.08200000E-05  +5.20570000E-04  +1.04120000E-04
   -1.52930000E-04  +2.31400000E-05  +5.92500000E-05  -1.67400000E-05  +2.19790000E-04
   -1.49790000E-04  -6.33400000E-05  -1.68680000E-04  -3.54500000E-05  +1.85000000E-06
   +3.33870000E-04  -3.83450000E-04  +4.83710000E-04  -5.71900000E-05  -6.73400000E-05
   -1.08600000E-05  -1.91900000E-05  +2.76000000E-06  +6.91000000E-06  -2.38490000E-04
   +1.69720000E-04  +3.59400000E-05  -1.42100000E-05  +2.91000000E-06  +1.08000000E-06
   -2.89900000E-05  -7.24000000E-06  -1.76400000E-05  +2.82149000E-03  -3.14123000E-03
   -6.53330000E-04  +1.96000000E-05  +2.54000000E-06  +2.93590000E-04  -2.02034240E-01
   +1.30739160E-01  +1.71097900E-02  +4.12390000E-04  -3.66500000E-04  -2.06450000E-04
   -6.10260000E-04  -7.81850000E-04  +6.02550000E-04  +9.19100000E-05  -1.37640000E-04
   -2.10980000E-04  -1.69570000E-04  -8.80000000E-06  +3.49200000E-05  +5.17000000E-05
   +1.76600000E-05  -5.55000000E-06  +1.09380000E-04  +1.19540000E-04  -1.99000000E-05
   -9.28780000E-04  -1.70611000E-03  -3.58500000E-05  +3.27000000E-05  -1.00200000E-05
   +2.27100000E-05  +8.80500000E-05  +3.91200000E-05  -3.07200000E-05  +1.37500000E-05
   +1.95800000E-05  -2.18000000E-06  -4.95000000E-06  -1.39000000E-06  -8.23000000E-06
   +2.19235280E-01  -5.97230000E-04  -1.32040000E-03  -3.60781000E-03  -4.55480000E-04
   -4.27750000E-04  +3.63100000E-04  +6.92120000E-04  -4.18400000E-04  +2.86210000E-04
   -1.09450000E-04  +5.46880000E-04  -5.03860000E-04  -2.82280000E-04  +1.69750000E-04
   +1.02050000E-04  +3.34420000E-04  -1.29320000E-04  -3.96220000E-04  -4.79500000E-05
   -3.72700000E-05  -1.39070000E-04  +9.95200000E-05  -7.25000000E-06  +2.39800000E-05
   +4.04770000E-04  -3.35660000E-04  -2.79000000E-06  +1.55200000E-05  -2.81600000E-05
   -3.08000000E-06  +7.16000000E-05  +1.76580000E-04  +1.01550000E-04  +1.46582200E-02
   -1.19399500E-02  -4.84350000E-04  +7.09360000E-04  +5.52860000E-04  +2.35960000E-04
   +1.29403340E-01  -1.56222070E-01  -1.44705100E-02  +1.14040000E-04  +5.20820000E-04
   +1.41716000E-03  +1.86420000E-04  -4.28120000E-04  -9.21250000E-04  -3.07750000E-04
   +2.38700000E-04  +4.21050000E-04  -3.72200000E-05  -2.93600000E-05  +8.26900000E-05
   +1.68930000E-04  +1.62360000E-04  +3.86200000E-05  -3.02170000E-04  -1.11290000E-04
   -1.35410000E-04  -1.25696000E-03  -1.03991000E-03  +9.54980000E-04  -1.81900000E-05
   -3.37600000E-05  -1.48200000E-05  +1.09330000E-04  +1.44640000E-04  +5.93300000E-05
   +1.19700000E-05  -2.80000000E-06  +2.13800000E-05  +2.97900000E-05  +6.20500000E-05
   +1.28290000E-04  -1.42160030E-01  +1.67948760E-01  -1.72808000E-03  -2.69485000E-03
   -3.33246000E-03  +7.31090000E-04  -5.62200000E-04  -5.53100000E-05  +1.42660000E-04
   +2.50000000E-04  +1.83740000E-04  -1.45590000E-04  +9.92100000E-05  +1.88000000E-06
   +5.79410000E-04  +2.57330000E-04  +4.79620000E-04  -9.53800000E-05  +4.47520000E-04
   -3.95660000E-04  -1.81700000E-05  -9.11400000E-05  -1.52410000E-04  +6.36600000E-05
   -2.65400000E-05  -1.23200000E-05  +3.11040000E-04  -2.76530000E-04  -4.76000000E-05
   +1.18800000E-05  -3.91200000E-05  -2.61900000E-05  -2.03630000E-04  -3.50160000E-04
   -5.89700000E-05  +2.07745500E-02  -1.61600200E-02  -3.39707000E-03  +2.57540000E-04
   +6.19250000E-04  +5.50400000E-04  +1.68213900E-02  -1.35132400E-02  -5.01669400E-02
   +1.16818000E-03  -7.27720000E-04  +1.18997000E-03  -2.51760000E-04  +3.89570000E-04
   +4.27190000E-04  -1.28180000E-04  -1.39420000E-04  -1.08300000E-04  -1.04390000E-04
   +3.30700000E-05  +1.78500000E-04  +1.37420000E-04  +7.67700000E-05  -4.03500000E-05
   -6.35200000E-05  +1.84700000E-05  -2.36870000E-04  +2.48550000E-04  +3.02880000E-04
   +1.60950000E-04  +6.26000000E-06  -2.04000000E-06  +6.20000000E-06  +4.56100000E-05
   +2.13900000E-05  -2.94300000E-05  +1.98100000E-05  -1.32400000E-05  +8.75000000E-06
   +4.04900000E-05  -1.25600000E-05  +3.24200000E-05  -1.92585600E-02  +1.79107200E-02
   +5.28892100E-02  +1.62800000E-05  -4.61990000E-04  +4.92260000E-04  -2.25520000E-04
   +8.03400000E-05  +1.26210000E-04  +1.08530000E-04  -8.33400000E-05  +7.02400000E-05
   -1.45170000E-04  +1.23610000E-04  +3.35900000E-05  -2.53400000E-04  -8.04000000E-06
   -1.62380000E-04  +8.27100000E-05  +9.28300000E-05  +1.04580000E-04  +8.18000000E-06
   -1.20700000E-05  -6.37800000E-05  +4.37000000E-06  -9.54000000E-06  -1.38600000E-05
   +1.30290000E-04  -9.95200000E-05  -3.35100000E-05  +3.22000000E-05  +2.02200000E-05
   +2.77700000E-05  +1.93220000E-04  +1.33190000E-04  +9.56500000E-05  -2.00926000E-03
   +2.39522000E-03  -3.07712000E-03  +3.43280000E-04  +5.42890000E-04  -3.15020000E-04
   -4.85403700E-02  +1.01417200E-02  -1.45050300E-02  -5.88400000E-05  -7.93470000E-04
   -6.94940000E-04  -1.41240000E-04  -4.45490000E-04  -6.33330000E-04  -1.02320000E-04
   +2.06300000E-05  +2.61060000E-04  -8.47800000E-05  -7.29000000E-06  +4.95500000E-05
   +1.34670000E-04  +1.09600000E-04  +1.49800000E-05  -8.12000000E-05  -1.11320000E-04
   -3.81000000E-05  -1.55975000E-03  +1.07130000E-04  -2.51300000E-04  -1.73600000E-05
   +1.50000000E-07  -2.35600000E-05  +1.04900000E-04  +1.09850000E-04  +3.27100000E-05
   +1.12700000E-05  +1.36400000E-05  +1.06200000E-05  -1.75800000E-05  +5.82900000E-05
   +5.82900000E-05  -1.12552000E-03  +1.27324700E-02  -2.12209300E-02  +4.95953600E-02
   -4.80100000E-04  +9.95300000E-04  -1.04790000E-04  +1.63480000E-04  +2.16000000E-06
   +4.99900000E-05  -1.44480000E-04  +1.52990000E-04  -1.00680000E-04  -4.76900000E-05
   -1.05880000E-04  +1.73380000E-04  -4.36500000E-05  -1.07730000E-04  +4.22000000E-05
   +3.85510000E-04  -1.57770000E-04  -6.55630000E-04  -2.15000000E-05  -1.44300000E-05
   -1.23400000E-05  -1.30900000E-05  -3.22000000E-06  -2.28000000E-06  -9.91900000E-05
   +6.31200000E-05  +4.77000000E-06  +7.28000000E-06  +3.56000000E-06  -4.34000000E-06
   +4.20000000E-07  -7.36990000E-04  -1.71630000E-04  -6.91500000E-04  +1.04107400E-02
   -1.63226100E-02  +5.53700000E-05  +8.40580000E-04  +4.70650000E-04  +1.05448900E-02
   -1.29878380E-01  +1.24518260E-01  -3.42790000E-04  -1.92594000E-03  -2.83280000E-03
   -6.87590000E-04  +2.84080000E-04  +2.06900000E-04  -2.55300000E-05  -1.70020000E-04
   -1.68120000E-04  -1.08110000E-04  -6.90000000E-07  +1.79100000E-04  +1.25560000E-04
   +5.93400000E-05  -5.23200000E-05  +2.32290000E-04  -7.29100000E-05  -2.25500000E-05
   -3.59340000E-04  -2.52740000E-04  -2.20680000E-04  -1.38200000E-05  +3.51800000E-05
   -1.95300000E-05  +6.78200000E-05  +2.00600000E-05  -3.43600000E-05  +1.33400000E-05
   +1.74600000E-05  -6.88000000E-06  -4.50000000E-07  +2.22100000E-05  -2.88000000E-05
   -6.07550000E-04  -1.06482600E-02  +1.61713500E-02  -1.00522800E-02  +1.39505430E-01
   -1.51338000E-03  +7.15780000E-04  +1.10623000E-03  +1.04819000E-03  -8.45000000E-05
   -4.77090000E-04  -5.27670000E-04  +4.94200000E-04  -1.27460000E-04  -4.69000000E-05
   -3.99470000E-04  +3.62990000E-04  +5.85840000E-04  -1.76320000E-04  +4.06140000E-04
   +5.01300000E-05  +6.89270000E-04  -2.10920000E-04  -1.28220000E-04  -1.60900000E-05
   +9.55000000E-05  -1.13500000E-05  -8.21000000E-06  -1.50100000E-05  -1.39540000E-04
   +8.67200000E-05  +1.21600000E-05  +2.78300000E-05  -2.31400000E-05  -2.29400000E-05
   -1.74370000E-04  -5.33430000E-04  +1.43230000E-04  -1.22407000E-03  +1.50226200E-02
   -2.08321500E-02  +9.97920000E-04  +9.30360000E-04  +9.30070000E-04  -1.42861000E-02
   +1.22291150E-01  -2.32765470E-01  -2.66980000E-04  -4.67006000E-03  -4.00688000E-03
   +3.13660000E-04  -2.03970000E-04  +5.56400000E-05  -2.63800000E-04  -1.67820000E-04
   +2.00520000E-04  -9.25400000E-05  +1.65290000E-04  +1.87150000E-04  +2.33380000E-04
   +1.69470000E-04  -3.51600000E-05  -4.44300000E-05  -5.07230000E-04  -5.40300000E-05
   -3.65930000E-04  +2.28050000E-04  +2.04860000E-04  -1.78900000E-05  -2.49500000E-05
   -4.70000000E-06  +7.40000000E-06  +9.66000000E-06  +1.12700000E-05  -2.49400000E-05
   +2.61800000E-05  -2.82100000E-05  -3.15400000E-05  +9.38300000E-05  +3.33500000E-05
   +2.69190000E-04  -2.71097000E-03  +3.60439000E-03  +1.61567400E-02  -1.32885420E-01
   +2.54140970E-01  +7.44140000E-04  +1.47304000E-03  -5.56500000E-05  +1.70010000E-04
   -1.30860000E-04  +1.78330000E-04  +1.52940000E-04  -1.46570000E-04  -5.19800000E-05
   +4.04400000E-05  +9.81600000E-05  -1.67900000E-04  -2.50210000E-04  -4.62800000E-05
   -3.53900000E-05  +3.81760000E-04  -3.15060000E-04  +2.15730000E-04  +2.16900000E-05
   -3.50400000E-05  -3.45700000E-05  +2.83900000E-05  -1.84600000E-05  +8.10000000E-07
   +2.37900000E-05  -5.88000000E-06  +2.12000000E-05  +6.07000000E-06  -3.35000000E-06
   +3.52000000E-06  +2.83500000E-05  +6.60500000E-05  +2.09300000E-05  -3.79782000E-03
   -1.10102000E-03  +1.13550000E-03  +7.66250000E-04  -8.68800000E-05  -4.20900000E-04
   -2.38805920E-01  -1.19492170E-01  +2.22085500E-02  -1.67860000E-04  +5.07700000E-05
   +5.00220000E-04  -6.87100000E-05  +1.01590000E-04  +4.17950000E-04  +1.38920000E-04
   -1.55020000E-04  -2.41700000E-04  +1.29150000E-04  +1.06110000E-04  -2.99800000E-05
   -9.02000000E-05  -1.11440000E-04  -1.13560000E-04  -4.92400000E-05  +3.62800000E-05
   +3.14240000E-04  +9.38400000E-05  -1.15610000E-04  -5.10490000E-04  -6.16000000E-06
   -8.50000000E-06  +2.13500000E-05  -2.04210000E-04  -1.82560000E-04  -3.36300000E-05
   -4.88000000E-05  -1.58400000E-05  -2.41500000E-05  +7.43800000E-05  -5.33500000E-05
   -6.91200000E-05  -1.93009800E-02  -1.34415200E-02  +2.52532000E-03  +2.55001000E-03
   +2.40704000E-03  -2.96620000E-04  +2.56755860E-01  -1.11622000E-03  +6.73210000E-04
   +2.01350000E-04  +2.38610000E-04  +1.10520000E-04  +4.89000000E-06  +2.11250000E-04
   -7.82000000E-05  -4.36700000E-05  +2.14380000E-04  -9.61200000E-05  -1.76700000E-04
   -4.71300000E-05  -4.46400000E-05  +2.66500000E-05  +1.51750000E-04  -3.02830000E-04
   +6.45600000E-04  -4.39600000E-05  -1.99500000E-05  -6.74400000E-05  -1.02500000E-05
   -1.25000000E-05  +1.68000000E-06  -2.03400000E-04  +1.73740000E-04  +4.29000000E-05
   -1.43800000E-05  -9.61000000E-06  -2.66000000E-06  -4.13200000E-05  +1.27780000E-04
   -1.30130000E-04  -1.61365100E-02  -1.22887200E-02  +1.72791000E-03  +7.49430000E-04
   -1.31702000E-03  -3.73748000E-03  -1.18192770E-01  -1.20204630E-01  +1.49414800E-02
   +5.15820000E-04  +2.85430000E-04  +1.14470000E-03  +4.36480000E-04  +1.10660000E-04
   -5.32590000E-04  -8.35900000E-05  +1.37060000E-04  +5.49900000E-05  +2.84280000E-04
   +9.72800000E-05  -1.12650000E-04  -6.66400000E-05  -3.33270000E-04  -1.40960000E-04
   -1.19853000E-03  -1.74100000E-04  +3.22680000E-04  +2.10040000E-04  -7.12600000E-05
   +2.93230000E-04  -4.39000000E-05  -5.34000000E-06  -3.37000000E-06  -2.61220000E-04
   -1.75390000E-04  +3.14600000E-05  -8.10000000E-05  -1.17550000E-04  +1.96600000E-05
   +1.00800000E-05  +3.47800000E-05  -8.20400000E-05  +1.80093400E-02  +1.21198200E-02
   -2.26573000E-03  -1.47903600E-02  -9.22403000E-03  +7.76880000E-04  +1.30650770E-01
   +1.30007530E-01  -8.36760000E-04  +3.84490000E-04  +3.78150000E-04  -2.31880000E-04
   +1.46910000E-04  +2.94770000E-04  +1.73830000E-04  -1.46170000E-04  -1.17200000E-05
   +2.04200000E-05  +6.01700000E-05  -1.12690000E-04  -3.88330000E-04  -8.98200000E-05
   -1.19710000E-04  +4.91560000E-04  -1.23620000E-04  +3.32000000E-05  +1.34000000E-05
   +1.20300000E-05  -1.02360000E-04  -2.83000000E-06  -9.16000000E-06  +7.07000000E-06
   -8.62600000E-05  +6.32200000E-05  +1.11600000E-05  +2.78500000E-05  +1.73300000E-05
   +2.81200000E-05  +1.79100000E-05  -1.25000000E-05  +5.48400000E-05  -2.26780800E-02
   -1.46387400E-02  +7.13230000E-04  +7.49870000E-04  -2.37146000E-03  -4.47333000E-03
   +2.39764600E-02  +1.61626600E-02  -4.91064100E-02  -1.07180000E-03  -9.02840000E-04
   +1.35052000E-03  +8.73430000E-04  -2.76110000E-04  -6.47050000E-04  -2.00820000E-04
   -5.74000000E-06  +2.78210000E-04  +9.94100000E-05  +1.30360000E-04  -5.69000000E-06
   +1.07910000E-04  -2.21420000E-04  -2.65890000E-04  -1.45496000E-03  -9.14470000E-04
   +4.36130000E-04  -6.67300000E-05  +5.37350000E-04  +3.25720000E-04  -2.15600000E-05
   -3.53200000E-05  +9.64000000E-06  -1.14450000E-04  -4.16100000E-05  +4.44000000E-05
   -1.23230000E-04  -7.17200000E-05  -1.78300000E-05  -4.00000000E-08  +3.97000000E-05
   +8.75000000E-06  +1.53715000E-03  +1.48045000E-03  -1.19183000E-03  +2.35693600E-02
   +1.30060400E-02  -1.82119000E-03  -2.49173300E-02  -1.28281300E-02  +5.42670400E-02
   +7.69790000E-04  +1.29620000E-04  -4.26680000E-04  -1.25500000E-04  -1.00100000E-04
   +3.85520000E-04  +1.28600000E-04  +1.56480000E-04  -2.25310000E-04  +5.61200000E-05
   -8.39800000E-05  +2.24900000E-05  -7.26100000E-05  +3.96300000E-05  -1.84710000E-04
   -3.89800000E-05  -1.06060000E-04  +3.18320000E-04  +1.79950000E-04  +1.02810000E-04
   -4.55570000E-04  -1.89400000E-05  +8.03000000E-06  +2.08600000E-05  -1.51520000E-04
   +1.47110000E-04  -2.04700000E-05  -2.55700000E-05  +7.24000000E-06  +5.90000000E-07
   +6.72800000E-05  +5.13800000E-05  -5.18200000E-05  -3.66655000E-03  +1.05035000E-03
   +1.10964000E-03  +7.71170000E-04  -1.40712000E-03  +5.37400000E-05  -1.76570000E-04
   -1.11010000E-04  +4.54830000E-04  -2.45907320E-01  +1.17721800E-01  +2.37852600E-02
   +2.43340000E-04  +1.40900000E-04  +1.21250000E-04  +9.46800000E-05  +9.51400000E-05
   -6.86900000E-05  +1.84600000E-05  -5.66000000E-05  -1.59120000E-04  -2.27900000E-04
   +1.44300000E-05  +6.58000000E-06  +3.60140000E-04  +2.27610000E-04  +1.83690000E-04
   +2.28200000E-05  +2.01000000E-05  -1.70900000E-05  +2.18400000E-05  +1.50000000E-05
   +3.47000000E-06  +2.37400000E-05  -6.82000000E-06  +2.30200000E-05  -1.41000000E-06
   +1.05400000E-05  -8.10000000E-07  +3.29200000E-05  -6.50300000E-05  +1.57300000E-05
   +2.58820000E-04  -2.79810000E-04  -5.92230000E-04  +3.05140000E-04  -2.35260000E-04
   -4.14900000E-05  +3.67400000E-05  +1.18390000E-04  +4.46300000E-05  +2.64001320E-01
   -7.50010000E-04  -1.57572000E-03  +3.94366000E-03  -4.89140000E-04  +6.58500000E-05
   +5.26270000E-04  +1.13210000E-04  +1.43650000E-04  -9.07000000E-05  -2.02670000E-04
   +1.11840000E-04  +4.25800000E-05  +4.10000000E-05  -3.47060000E-04  +2.58190000E-04
   +1.17684000E-03  -1.12690000E-04  -3.65260000E-04  -1.33500000E-04  -5.90800000E-05
   -3.31540000E-04  +4.68000000E-05  -1.15300000E-05  -1.20000000E-06  +1.95790000E-04
   -1.41350000E-04  -5.50100000E-05  +8.90600000E-05  -8.03500000E-05  -4.72500000E-05
   +1.57900000E-05  +4.53200000E-05  +8.20000000E-05  +1.69177500E-02  -1.23313500E-02
   -1.79984000E-03  +1.20928000E-03  +5.78680000E-04  -3.06260000E-04  -4.74980000E-04
   +2.78960000E-04  -1.10846000E-03  +1.15910210E-01  -1.14898290E-01  -1.51022400E-02
   -3.21760000E-04  +1.22250000E-04  +7.18200000E-05  -1.44810000E-04  -3.35800000E-05
   +8.73400000E-05  -2.17220000E-04  -1.29570000E-04  +1.18580000E-04  +6.71000000E-05
   +3.55900000E-05  -6.16300000E-05  -1.58470000E-04  -3.00280000E-04  -5.71870000E-04
   +3.61100000E-05  -1.69700000E-05  +5.19800000E-05  +5.32000000E-06  -9.47000000E-06
   -9.60000000E-07  +2.08370000E-04  +1.85950000E-04  -4.77000000E-06  +1.53800000E-05
   -5.95000000E-06  +1.44700000E-05  +3.90600000E-05  +1.06110000E-04  +1.49300000E-04
   -9.14400000E-05  +5.85120000E-04  +1.30520000E-04  -2.50010000E-04  -1.40400000E-05
   -3.95600000E-05  -1.15000000E-04  +5.47000000E-05  +2.71800000E-05  -1.28098010E-01
   +1.24441730E-01  +6.75520000E-04  +2.45760000E-03  -4.22099000E-03  +8.84190000E-04
   +2.94370000E-04  -5.41710000E-04  -2.26360000E-04  +3.19300000E-05  +2.41500000E-04
   +6.35100000E-05  -1.50490000E-04  +2.02000000E-05  +1.23160000E-04  +3.06520000E-04
   -2.81400000E-04  -1.45774000E-03  +8.25310000E-04  +3.84280000E-04  -7.81800000E-05
   -4.95760000E-04  +2.26990000E-04  -1.86900000E-05  +3.53800000E-05  +1.29100000E-05
   -8.39800000E-05  +2.51700000E-05  +3.96700000E-05  -1.19390000E-04  +5.11800000E-05
   -6.49000000E-06  -1.46600000E-05  -4.21500000E-05  -1.78000000E-06  -2.25293400E-02
   +1.39031000E-02  +9.13330000E-04  -8.92990000E-04  -2.93600000E-04  +6.89130000E-04
   -1.02674000E-03  +7.81080000E-04  +1.32705000E-03  +2.54244600E-02  -1.62003400E-02
   -4.94670900E-02  -8.89500000E-05  -1.57560000E-04  +1.83450000E-04  +1.62580000E-04
   +1.10670000E-04  -3.16700000E-05  +1.57300000E-04  -2.04900000E-05  -2.19000000E-04
   -3.85020000E-04  -2.07000000E-06  +1.35070000E-04  +3.79520000E-04  +2.52300000E-05
   -1.51810000E-04  +1.48600000E-05  -2.84000000E-06  -9.70100000E-05  -3.41000000E-06
   +8.19000000E-06  +8.29000000E-06  -1.76670000E-04  -1.26880000E-04  +1.39000000E-05
   +1.42900000E-05  -1.86800000E-05  +4.30000000E-07  +3.63700000E-05  +1.40000000E-07
   +6.57600000E-05  +2.21100000E-04  -3.24030000E-04  -6.62010000E-04  +3.00090000E-04
   -1.23940000E-04  +2.25510000E-04  +5.64100000E-05  -1.20500000E-05  -8.30600000E-05
   -2.65442500E-02  +1.28450200E-02  +5.44395900E-02  -3.05600000E-05  -2.49700000E-05
   +3.30240000E-04  -1.09172000E-03  +9.67470000E-04  +6.93970000E-04  +1.39290000E-04
   +1.87320000E-04  -2.72970000E-04  -1.54580000E-04  +2.53500000E-05  +2.09500000E-05
   +4.20500000E-05  -2.32700000E-05  +3.76100000E-05  +9.04300000E-05  -1.06850000E-04
   -3.70900000E-05  -1.44841000E-03  +2.03854000E-03  +4.07500000E-05  +3.08300000E-05
   +1.17000000E-06  +1.92900000E-05  +6.14800000E-05  -1.71600000E-05  -4.06200000E-05
   +1.22000000E-05  -1.25800000E-05  -8.99000000E-06  -3.55000000E-06  +1.10300000E-05
   -7.00000000E-06  +2.65418000E-03  +3.21836000E-03  -4.89020000E-04  +4.32560000E-04
   -4.41020000E-04  +4.10400000E-05  +4.31900000E-04  +3.70570000E-04  -2.22380000E-04
   -1.97094190E-01  -1.30948100E-01  +1.14995500E-02  +5.97750000E-04  -1.06120000E-04
   -2.15100000E-04  -7.67000000E-06  -8.16800000E-05  -5.98300000E-05  +2.70490000E-04
   +1.74110000E-04  -6.43300000E-05  -1.67770000E-04  -2.60000000E-07  +8.80800000E-05
   +3.01780000E-04  +2.82970000E-04  +4.30240000E-04  -5.02000000E-05  +6.79800000E-05
   +5.79000000E-06  -1.35100000E-05  -1.60000000E-06  +4.01000000E-06  -2.79580000E-04
   -2.09430000E-04  +1.00700000E-05  -2.63700000E-05  -1.10400000E-05  -1.75800000E-05
   -2.64900000E-05  +2.78000000E-06  -2.44800000E-05  -1.95480000E-04  -1.39270000E-04
   +7.82300000E-05  +1.56900000E-04  +2.36500000E-04  +7.61000000E-05  +2.74590000E-04
   +9.39500000E-05  +2.28810000E-04  -1.91540800E-02  -1.89132700E-02  +7.91350000E-04
   +2.14957130E-01  -6.67350000E-04  +6.39090000E-04  -3.32950000E-04  -8.63600000E-05
   -5.02890000E-04  +8.27860000E-04  +3.15270000E-04  +2.05400000E-04  -3.77450000E-04
   +8.81000000E-06  +1.80400000E-05  -6.35500000E-05  -1.59390000E-04  +4.75700000E-05
   -7.62700000E-05  +3.33930000E-04  -1.15410000E-04  +1.92120000E-04  +1.52182000E-03
   -1.07617000E-03  -8.88640000E-04  +7.77000000E-06  -3.25600000E-05  +1.39000000E-05
   -8.00100000E-05  +1.30280000E-04  -4.49000000E-05  +2.68000000E-06  -4.58000000E-06
   -8.70000000E-07  -4.96400000E-05  +6.58100000E-05  -1.20710000E-04  -1.50454700E-02
   -1.25488000E-02  +1.58600000E-05  +6.74130000E-04  -1.42761000E-03  +3.70459000E-03
   -1.76050000E-04  +5.69410000E-04  -1.55165000E-03  -1.29650500E-01  -1.61930920E-01
   +1.01135300E-02  +4.07280000E-04  -4.79800000E-04  -3.78480000E-04  -6.54410000E-04
   -3.41530000E-04  -2.97460000E-04  +2.36700000E-04  +4.98130000E-04  +4.57580000E-04
   +2.32460000E-04  +1.56190000E-04  +1.44200000E-05  -3.22140000E-04  -1.13750000E-04
   +2.99770000E-04  +5.55500000E-05  -3.33400000E-05  +1.35250000E-04  -9.85900000E-05
   -1.57000000E-06  -2.95900000E-05  -5.11690000E-04  -3.89930000E-04  -5.12400000E-05
   -2.59500000E-05  -5.14100000E-05  -2.31200000E-05  -5.32800000E-05  +2.01350000E-04
   -9.51200000E-05  +1.24020000E-04  -1.41900000E-05  +1.25450000E-04  +3.05820000E-04
   +3.50400000E-05  -1.48800000E-04  +3.31180000E-04  +6.20770000E-04  +3.64000000E-04
   +1.25667600E-02  +1.19990400E-02  -9.16690000E-04  +1.42372840E-01  +1.74444570E-01
   +2.34660000E-04  -5.93580000E-04  +5.22530000E-04  -1.97610000E-04  -4.35880000E-04
   +3.26230000E-04  -1.13110000E-04  +1.39590000E-04  -8.72000000E-05  -9.50900000E-05
   -3.47600000E-05  +1.58060000E-04  +8.37100000E-05  -2.66200000E-05  -2.16100000E-05
   -2.22600000E-05  -5.91000000E-06  -2.35650000E-04  +2.72380000E-04  -3.04090000E-04
   +2.24200000E-04  +2.01000000E-06  +1.33000000E-06  +4.68000000E-06  +4.07600000E-05
   -1.72100000E-05  -3.37300000E-05  +1.44900000E-05  +8.99000000E-06  +4.97000000E-06
   +4.68100000E-05  +5.37000000E-06  +3.39600000E-05  +2.01685900E-02  +1.62010500E-02
   -2.67349000E-03  -1.55551000E-03  +2.43552000E-03  -3.69849000E-03  +1.22350000E-03
   +8.15700000E-04  +1.19476000E-03  +1.12141100E-02  +8.99279000E-03  -4.91264800E-02
   +4.97550000E-04  +6.02620000E-04  +1.26990000E-04  +1.80240000E-04  -2.16310000E-04
   +2.50900000E-04  -4.09010000E-04  -9.33300000E-05  +1.94740000E-04  +6.25800000E-04
   -5.79800000E-05  +2.32000000E-06  +1.95800000E-05  -3.95670000E-04  -1.08910000E-04
   -4.57100000E-05  +1.08200000E-04  -1.47530000E-04  +6.45300000E-05  +3.28900000E-05
   -1.35400000E-05  +4.62890000E-04  +3.88730000E-04  -1.82500000E-05  +4.05800000E-05
   +2.89700000E-05  +1.85400000E-05  -2.64400000E-04  +3.81910000E-04  -4.88000000E-06
   +8.83800000E-05  -1.17320000E-04  -7.99500000E-05  -1.71250000E-04  -1.79390000E-04
   +3.74430000E-04  -6.07670000E-04  -1.15490000E-04  -6.63390000E-04  +2.61666000E-03
   +2.49599000E-03  -1.12091000E-03  -1.31071400E-02  -1.29527000E-02  +5.17474700E-02
   +3.09450000E-04  -6.48490000E-04  -2.55790000E-04  +1.94900000E-05  +3.64060000E-04
   -5.26390000E-04  -1.19110000E-04  -1.14400000E-05  +2.19650000E-04  -3.68300000E-05
   -1.04200000E-05  +1.54200000E-05  +1.39800000E-04  -3.91300000E-05  +9.84200000E-05
   -1.08650000E-04  +1.48920000E-04  -1.14410000E-04  -1.30786000E-03  -1.94630000E-04
   -3.17190000E-04  -6.98000000E-06  +1.73000000E-06  -2.18900000E-05  +7.53200000E-05
   -9.37200000E-05  +2.33300000E-05  +3.55000000E-06  -1.03800000E-05  -7.05000000E-06
   -8.55000000E-06  -5.36800000E-05  +4.50200000E-05  -1.96391000E-03  -2.26393000E-03
   -3.32364000E-03  -2.67400000E-05  +5.49670000E-04  +5.52460000E-04  -7.36800000E-05
   +7.93570000E-04  -7.99640000E-04  -4.76648100E-02  -6.97977000E-03  -1.01553600E-02
   -1.42050000E-04  -8.60200000E-05  +9.09600000E-05  +1.27600000E-04  +7.24500000E-05
   +4.67400000E-05  -2.99200000E-05  -1.10960000E-04  -8.00100000E-05  -2.37370000E-04
   -3.03100000E-05  -1.29500000E-05  -5.98200000E-05  -1.80430000E-04  +2.17000000E-05
   +4.00000000E-06  +8.78000000E-06  -5.76200000E-05  -1.22000000E-06  +9.49000000E-06
   -1.01000000E-05  +5.64200000E-05  +4.94100000E-05  -7.45000000E-06  +2.32200000E-05
   -1.41400000E-05  +1.69500000E-05  +2.22370000E-04  -2.24370000E-04  +1.02440000E-04
   +1.52390000E-04  -2.89360000E-04  -1.94690000E-04  +6.18290000E-04  -1.89420000E-04
   -3.58990000E-04  +3.13270000E-04  +2.64450000E-04  +2.98380000E-04  +2.14711000E-03
   +1.43205400E-02  +2.43117300E-02  -7.34440000E-04  -1.19783900E-02  -2.13016500E-02
   +4.83464600E-02  -5.28200000E-05  +9.51090000E-04  -5.32590000E-04  +5.61370000E-04
   +2.82740000E-04  -9.00100000E-05  +2.32100000E-05  -1.62130000E-04  +1.31030000E-04
   +7.18300000E-05  +5.70000000E-06  -1.38530000E-04  -1.08300000E-04  +3.78800000E-05
   -2.81200000E-05  -2.22520000E-04  -9.50000000E-05  +5.45500000E-05  +2.39440000E-04
   -2.04410000E-04  +1.26520000E-04  +1.26000000E-05  +2.91800000E-05  +1.80100000E-05
   -5.52300000E-05  +1.44900000E-05  +3.76200000E-05  -1.23500000E-05  +1.43900000E-05
   +1.24800000E-05  +1.43000000E-06  +1.62000000E-05  +3.07900000E-05  +4.54550000E-04
   +1.03786300E-02  +1.71162100E-02  +4.90130000E-04  +9.99260000E-04  -1.12480000E-04
   +3.25170000E-04  -2.11988000E-03  +2.85867000E-03  -7.31929000E-03  -1.22784900E-01
   -1.21290600E-01  -2.32140000E-04  +4.50000000E-06  -2.21900000E-05  +1.54250000E-04
   +1.41800000E-04  +1.18540000E-04  -2.34100000E-05  -9.06900000E-05  -1.80230000E-04
   -2.23300000E-05  -1.59280000E-04  -1.12460000E-04  -3.42150000E-04  -2.25980000E-04
   +6.80770000E-04  +2.72800000E-05  -1.44400000E-05  +5.08000000E-06  +1.36700000E-05
   -5.19000000E-06  +3.41000000E-06  +1.54110000E-04  +9.55400000E-05  +4.17000000E-06
   +3.08000000E-06  +1.45000000E-06  +2.39700000E-05  -9.45800000E-05  -9.90760000E-04
   +2.20470000E-04  -2.31520000E-04  +1.81800000E-05  +1.71410000E-04  +1.97560000E-04
   +8.57480000E-04  +9.95450000E-04  +2.56770000E-04  -6.06000000E-06  +1.17640000E-04
   -2.09061000E-03  -8.59993000E-03  -1.28435700E-02  +9.66690000E-04  -1.05985000E-02
   -1.70611400E-02  +6.87517000E-03  +1.32196120E-01  +1.00121000E-03  -1.06560000E-03
   +1.08683000E-03  +3.25070000E-04  +1.79380000E-04  +6.49100000E-05  -2.86320000E-04
   +2.03640000E-04  +1.65610000E-04  -2.47800000E-05  -1.97970000E-04  +1.27600000E-04
   +2.50140000E-04  -1.03130000E-04  +5.56000000E-05  -1.51720000E-04  +5.74880000E-04
   -1.17830000E-04  -3.63180000E-04  -2.07850000E-04  +8.03700000E-05  -2.11900000E-05
   +2.51800000E-05  -2.27000000E-06  -4.04700000E-05  +1.42400000E-05  +1.13100000E-05
   -2.77500000E-05  -2.03200000E-05  -4.37900000E-05  -1.94700000E-05  -8.31500000E-05
   +2.43600000E-05  -7.82730000E-04  -1.43452600E-02  -2.07524200E-02  -1.38543000E-03
   -9.02900000E-04  +7.96960000E-04  -3.33590000E-04  +4.82279000E-03  -3.86242000E-03
   -9.85787000E-03  -1.19168030E-01  -2.39707070E-01  +8.03230000E-04  +1.06240000E-04
   -3.32900000E-04  -4.62800000E-04  -3.95330000E-04  -8.27100000E-05  -2.02090000E-04
   +3.37630000E-04  +4.86080000E-04  +6.12110000E-04  +3.19030000E-04  +1.69030000E-04
   +1.49960000E-04  -7.03490000E-04  -1.44080000E-04  -1.27210000E-04  +1.53700000E-05
   +1.04100000E-04  -5.81000000E-06  +1.61700000E-05  -1.91100000E-05  -5.40800000E-05
   -1.13100000E-05  -1.22600000E-05  +3.98200000E-05  +3.22000000E-06  -6.82000000E-06
   -2.29610000E-04  +5.70240000E-04  +2.31850000E-04  +6.66000000E-05  +1.28930000E-04
   +3.91110000E-04  -3.40020000E-04  -9.50610000E-04  -1.52141000E-03  -3.66600000E-05
   +3.61900000E-05  +2.52820000E-04  -3.79940000E-04  -9.22260000E-04  -2.08464000E-03
   +1.66370000E-04  +2.06377000E-03  +2.88335000E-03  +1.17104000E-02  +1.29678090E-01
   +2.61812310E-01  -2.56200000E-05  +2.83900000E-05  +2.13300000E-05  -1.46200000E-05
   -4.67000000E-06  +3.29200000E-05  +3.49700000E-05  -4.38300000E-05  +2.29300000E-05
   -9.28000000E-05  +8.81500000E-05  -2.85700000E-05  +4.20200000E-05  +2.07800000E-05
   +1.89800000E-05  -3.19200000E-05  +4.61800000E-05  +1.54900000E-05  -1.05800000E-05
   -1.47000000E-06  -2.91000000E-06  +1.11600000E-05  -5.27000000E-06  -8.52000000E-06
   +1.18850000E-04  -7.71200000E-05  -8.41000000E-06  -1.48900000E-05  -4.45000000E-06
   -1.32000000E-05  -1.86600000E-05  -1.63000000E-06  -3.65600000E-05  -1.82250000E-04
   +2.66500000E-05  +1.01640000E-04  -4.83000000E-06  +4.12600000E-04  +6.12190000E-04
   +7.47200000E-05  +2.05400000E-05  -3.13500000E-05  +5.36300000E-05  +9.00000000E-08
   -1.23200000E-05  +1.46349000E-03  -9.60900000E-04  -8.78050000E-04  -4.98830000E-03
   -3.60205000E-03  +1.95575000E-03  -5.27635000E-03  -2.96165900E-02  -3.22924000E-02
   +1.50643000E-03  -1.64290000E-04  -2.25247000E-03  -6.57060000E-04  -1.93290000E-04
   -2.41970000E-04  -3.47360000E-04  -1.17600000E-04  -5.01000000E-06  -1.15110000E-04
   +1.83880000E-04  -1.73120000E-04  -3.48504400E-02  +7.45647000E-03  +3.56339400E-02
   -6.43170000E-04  +7.29170000E-04  +1.87669000E-03  +1.25730000E-04  +8.35200000E-05
   -4.90800000E-05  -1.94700000E-05  -3.83000000E-06  -5.71000000E-06  -9.43000000E-06
   -1.07200000E-05  -7.68000000E-06  +2.02600000E-05  +3.54900000E-05  +1.96300000E-05
   -8.40000000E-06  -9.57000000E-06  +1.67200000E-05  +2.58300000E-05  +3.65100000E-05
   -1.08500000E-05  -9.56000000E-06  -1.95100000E-05  +2.44900000E-05  +4.38736300E-02
   -8.86000000E-06  +1.13070000E-04  +4.13200000E-05  +4.40000000E-07  -1.52900000E-05
   +4.35000000E-05  +3.87400000E-05  -7.45100000E-05  +2.42800000E-05  -1.11270000E-04
   +1.18500000E-04  -3.67600000E-05  +2.47100000E-05  +3.26000000E-05  -1.64000000E-05
   +6.02000000E-06  +5.79000000E-06  -1.73600000E-05  -1.69200000E-05  +2.36000000E-06
   +8.13000000E-06  +1.54200000E-05  -4.86000000E-06  -6.72000000E-06  +1.45260000E-04
   -1.21260000E-04  -1.32200000E-05  +1.06300000E-05  -2.97000000E-06  +2.79000000E-06
   -2.78000000E-05  +3.42800000E-05  -3.48600000E-05  -1.91060000E-04  -8.87700000E-05
   +7.55000000E-06  +3.98100000E-05  +4.89880000E-04  +5.02400000E-04  +7.08700000E-05
   -1.74000000E-06  -3.07000000E-05  +8.71100000E-05  +2.98200000E-05  +2.81200000E-05
   +1.70500000E-04  +3.17040000E-04  -1.80261000E-03  -4.47898000E-03  -3.10900000E-05
   +1.41824000E-03  -1.25589000E-03  -2.26680300E-02  -2.20654400E-02  +3.75313000E-03
   +2.93818000E-03  +1.20368000E-03  +3.13000000E-06  -9.66530000E-04  -3.98830000E-04
   -1.78810000E-04  -2.06880000E-04  +1.35670000E-04  +2.46610000E-04  -3.74800000E-05
   +4.11410000E-04  -2.32321600E-02  -2.32365590E-01  -2.45634030E-01  -1.01327000E-03
   +1.75860000E-04  +4.37650000E-04  +2.12390000E-04  +1.08340000E-04  -3.38900000E-05
   -1.02400000E-05  -1.56000000E-05  -1.48300000E-05  -9.31000000E-06  -1.09900000E-05
   +6.31000000E-06  +2.50300000E-05  +3.36100000E-05  +1.89500000E-05  +3.45000000E-06
   -3.87500000E-05  +1.18000000E-05  +4.14700000E-05  +4.64100000E-05  -3.24400000E-05
   -2.14400000E-05  -1.26800000E-05  +1.37100000E-05  +2.56742900E-02  +2.52221810E-01
   +1.30800000E-05  +6.04500000E-05  -1.96800000E-05  -1.94300000E-05  -5.82000000E-06
   +1.35200000E-05  +2.64000000E-05  -3.29100000E-05  -2.93000000E-06  -3.04400000E-05
   +3.46500000E-05  -7.12000000E-06  +7.05000000E-06  +3.70000000E-06  -5.38000000E-06
   +7.80000000E-07  -1.55700000E-05  +3.59500000E-05  +8.90000000E-07  +9.31000000E-06
   +2.06000000E-06  +9.03000000E-06  -1.23000000E-06  -2.70000000E-06  +4.29800000E-05
   -3.01900000E-05  -1.04400000E-05  -7.07000000E-06  -1.10000000E-07  +1.56000000E-06
   -7.93000000E-06  -1.51000000E-06  -2.25100000E-05  -1.26740000E-04  -4.99800000E-05
   -1.48990000E-04  +1.70890000E-04  +8.52800000E-05  +1.65540000E-04  +1.62600000E-05
   -5.46000000E-06  -1.76800000E-05  +1.23670000E-04  +7.48400000E-05  +4.90200000E-05
   +4.14420000E-04  -8.66110000E-04  +3.70080000E-04  +8.73350000E-04  +6.09380000E-04
   +2.05689000E-03  +5.70250000E-04  +2.34327000E-03  -5.81870000E-04  +2.32277000E-03
   +4.58090000E-03  +2.41790000E-03  -8.20000000E-07  -1.93540000E-04  -8.79340000E-04
   -8.29600000E-05  +7.73500000E-05  -2.81200000E-05  -1.04690000E-04  +4.62880000E-04
   +7.74200000E-05  +7.44300000E-05  -2.71985430E-01  -3.19152340E-01  -1.36240000E-04
   -1.07574000E-03  -5.38460000E-04  +1.24710000E-04  +8.83200000E-05  -3.41000000E-05
   -6.68000000E-06  -1.01000000E-06  -1.19000000E-06  -5.22000000E-06  -4.40000000E-06
   -7.89000000E-06  +9.34000000E-06  +1.47300000E-05  +3.09000000E-06  -1.67000000E-06
   -9.00000000E-06  +1.67000000E-05  +1.39400000E-05  +3.92200000E-05  -4.89300000E-05
   +8.23000000E-06  -1.37900000E-05  -5.68000000E-06  -4.28912000E-03  +2.65799870E-01
   +3.16303610E-01  +6.54500000E-04  +7.65860000E-04  -1.17559000E-03  -1.69235000E-03
   +1.19610000E-04  +9.10190000E-04  +4.30437000E-03  -3.77428000E-03  -7.06910000E-04
   -3.07369500E-02  -8.64568000E-03  +2.97484300E-02  -2.67296000E-03  +4.82663000E-03
   -1.67122000E-03  +5.65250000E-04  -9.27270000E-04  +2.15036000E-03  +2.12410000E-04
   -1.35830000E-04  +6.24800000E-05  -1.24820000E-04  +1.17371000E-03  -1.01221000E-03
   -2.28417650E-01  -6.29116800E-02  +2.18525150E-01  +1.35270000E-04  -9.26500000E-05
   -4.02530000E-04  -2.73280000E-04  +1.95820000E-04  -7.15400000E-05  -1.28760000E-04
   +8.16000000E-05  -1.42330000E-04  +3.86400000E-05  -1.26090000E-04  -1.42200000E-05
   +1.09090000E-04  -4.58900000E-05  +1.86700000E-05  +6.41900000E-05  -1.12500000E-05
   -1.40300000E-05  -2.25100000E-05  +9.90000000E-07  +4.81400000E-05  +4.26300000E-05
   +6.38600000E-05  +2.35600000E-05  -1.37500000E-04  -1.13230000E-04  -2.26300000E-05
   +2.45600000E-05  -3.34300000E-05  -3.15900000E-05  +1.89100000E-05  +5.12000000E-06
   +4.56100000E-05  -1.13800000E-05  -6.28000000E-06  +1.68000000E-06  +9.07000000E-06
   +4.95000000E-06  -7.79000000E-06  +1.68470000E-04  +1.18630000E-04  -2.25000000E-06
   -1.14000000E-06  +1.26400000E-05  +6.18000000E-06  -2.23100000E-05  -1.62000000E-06
   -4.26300000E-05  +3.42000000E-05  -5.50600000E-05  -3.05600000E-05  -1.70900000E-05
   +1.12000000E-05  +1.82100000E-05  -8.18000000E-06  +2.77000000E-05  +1.31300000E-05
   +4.14400000E-05  -1.95900000E-05  -6.00000000E-06  -4.07000000E-06  +3.59200000E-05
   +5.40000000E-07  -2.92100000E-05  -1.50000000E-06  -8.87000000E-06  -2.96600000E-05
   -2.18900000E-05  -6.51000000E-06  +2.58040470E-01  -2.25730000E-04  +1.09770000E-04
   +1.19860000E-04  -2.16050000E-04  -6.29370000E-04  +8.34000000E-05  +1.24696000E-03
   +2.51770000E-04  -2.77049000E-03  +2.33619300E-02  +4.76883000E-03  -2.34278600E-02
   +4.38171000E-03  -2.13419000E-03  +8.25140000E-04  +7.98240000E-04  +1.03223000E-03
   -5.23620000E-04  -1.18000000E-05  +4.61700000E-05  +1.55100000E-05  -5.77740000E-04
   -5.65670000E-04  +1.57914000E-03  -9.83670200E-02  -7.41859500E-02  +1.32422250E-01
   +5.13100000E-05  +7.57000000E-06  -3.05160000E-04  +2.14880000E-04  -1.96720000E-04
   +4.24700000E-05  +1.98400000E-05  -1.13050000E-04  +4.78600000E-05  +2.28500000E-05
   +6.90200000E-05  +2.09700000E-05  -3.20900000E-05  +1.75500000E-05  -1.33600000E-05
   -3.55100000E-05  +2.69100000E-05  +5.39000000E-06  -4.71000000E-06  -2.16600000E-05
   -1.79000000E-05  -1.99400000E-05  -3.05500000E-05  -1.56500000E-05  +7.81700000E-05
   +6.50900000E-05  +9.92000000E-06  -1.72800000E-05  +5.96000000E-06  +2.54100000E-05
   -7.36000000E-06  -9.31000000E-06  -3.27000000E-06  +1.04500000E-05  +2.48000000E-06
   -6.70000000E-06  -5.98000000E-06  -2.68000000E-06  +2.70000000E-06  -9.63700000E-05
   -7.73600000E-05  -6.80000000E-07  -1.16700000E-05  -8.43000000E-06  -8.42000000E-06
   +1.35000000E-05  +2.33400000E-05  +1.64700000E-05  -1.65400000E-05  +2.82300000E-05
   +6.56000000E-06  +7.19000000E-06  -3.67000000E-06  -5.77000000E-06  +4.00000000E-07
   -2.19200000E-05  -5.20000000E-06  -2.80300000E-05  +1.48400000E-05  +6.36000000E-06
   -5.22000000E-06  -4.14200000E-05  +7.00000000E-07  +2.18000000E-05  +5.21000000E-06
   +6.24000000E-06  +1.05000000E-05  +1.85200000E-05  +4.64000000E-06  +6.94310900E-02
   +7.13815600E-02  -2.31720000E-04  -9.21800000E-05  +1.24630000E-04  +4.09580000E-04
   -2.48710000E-04  -1.11026000E-03  -5.14575000E-03  +1.00385000E-03  +1.64228000E-03
   +9.79350000E-04  -4.18730000E-04  -2.57525000E-03  +5.09800000E-04  +7.47710000E-04
   +3.10297000E-03  +5.01070000E-04  +4.69630000E-04  -2.66670000E-04  -7.15200000E-05
   +1.25360000E-04  +2.11100000E-05  +1.03204000E-03  +2.83260000E-04  -3.64010000E-04
   +2.48783020E-01  +1.07190460E-01  -2.81672740E-01  -3.35090000E-04  -1.60950000E-04
   -9.74700000E-05  +7.61000000E-05  -1.23750000E-04  +3.29200000E-05  +1.85680000E-04
   +1.69800000E-05  +8.57100000E-05  +2.36800000E-05  +4.33500000E-05  -2.49600000E-05
   -1.17160000E-04  +7.05100000E-05  -2.90500000E-05  -3.42500000E-05  -5.62000000E-06
   +3.15900000E-05  -5.33000000E-06  -7.48000000E-06  -1.42200000E-05  -1.29200000E-05
   -2.49500000E-05  -1.61200000E-05  +4.50000000E-05  +4.22300000E-05  +1.43700000E-05
   -1.07600000E-05  +5.75000000E-06  +1.16500000E-05  -2.68100000E-05  -3.41000000E-06
   +7.85000000E-06  +1.03000000E-05  -4.40000000E-07  -7.08000000E-06  -2.07000000E-06
   -3.49000000E-06  +2.49000000E-06  -6.29900000E-05  -5.11300000E-05  -4.95000000E-06
   -1.28800000E-05  -9.34000000E-06  -5.04000000E-06  +1.49100000E-05  +2.00000000E-05
   +2.43600000E-05  -2.33500000E-05  +4.22900000E-05  +3.46600000E-05  +1.65000000E-05
   -1.07000000E-06  -1.61000000E-05  -1.94000000E-06  -3.02300000E-05  +4.00000000E-08
   -7.24000000E-06  +1.85900000E-05  -8.45000000E-06  +5.44000000E-06  -2.82000000E-06
   +1.12000000E-05  -1.41000000E-06  -1.17700000E-05  -9.80000000E-06  +5.66000000E-06
   +1.05500000E-05  +6.77000000E-06  -2.46232120E-01  -1.08767390E-01  +2.80924960E-01
   -8.67910000E-04  -3.74602000E-03  +1.73074000E-03  -3.26435000E-03  +3.58375000E-03
   -7.57490000E-04  +4.46866000E-03  -6.54675000E-03  +3.45033000E-03  +4.41688000E-03
   +5.67004000E-03  -1.83587800E-02  +1.28426900E-02  +1.05491500E-02  +2.89698100E-02
   -2.01722500E-02  +5.88370000E-03  -1.08485600E-02  -1.19700000E-05  -3.94700000E-05
   +1.43000000E-06  +1.06750000E-04  -1.65950000E-04  +1.52700000E-05  +9.65060000E-04
   -9.05790000E-04  +3.28910000E-03  -3.07377000E-03  -3.83028000E-03  -5.39865000E-03
   +1.43080000E-03  +1.94420000E-04  +2.24270000E-04  +2.83340000E-04  +2.90870000E-04
   +6.76800000E-04  +6.84700000E-05  +7.74300000E-05  -5.64900000E-05  -1.98310000E-04
   -1.64660000E-04  +1.92240000E-04  +1.46000000E-06  -1.51330000E-04  -4.74800000E-05
   +6.00000000E-08  +3.58800000E-05  -2.35400000E-05  -2.25400000E-05  -5.06100000E-05
   -7.29900000E-05  +1.49490000E-04  +1.28070000E-04  +4.20500000E-05  -4.38800000E-05
   -2.07000000E-05  +1.52600000E-05  -4.58100000E-05  -6.83000000E-06  +2.07000000E-05
   +6.07800000E-05  -2.59100000E-05  -1.78900000E-05  +2.89000000E-06  -8.49000000E-06
   +1.09700000E-05  -1.85240000E-04  -1.51140000E-04  -1.21500000E-05  -2.71100000E-05
   -1.82600000E-05  -2.14100000E-05  +3.30000000E-07  +3.51700000E-05  +2.29800000E-05
   -5.67200000E-05  +8.10000000E-05  -9.34900000E-05  +3.38170000E-04  +2.44400000E-05
   -1.18710000E-04  +1.77500000E-05  -9.41700000E-05  +6.48700000E-05  -9.74000000E-06
   +3.51000000E-06  +1.65900000E-05  +1.13900000E-05  -1.78000000E-06  +2.30700000E-05
   -2.00000000E-08  +1.20000000E-07  -7.01300000E-05  +2.05700000E-05  +3.11900000E-05
   +1.04300000E-05  -2.39780000E-04  -9.73500000E-05  -4.16200000E-04  +3.53077000E-02
   -9.71380000E-04  -3.71066000E-03  +4.90643000E-03  +2.14510000E-04  +2.95278000E-03
   -3.01904000E-03  +2.32896000E-03  -3.17872000E-03  +1.91352000E-03  +5.62846000E-03
   +9.74820000E-04  -1.34888300E-02  +1.36697900E-02  -6.65717000E-03  +2.53003200E-02
   -1.10192700E-02  +6.78921000E-03  -3.83247000E-03  -6.02000000E-06  -5.59500000E-05
   -5.10000000E-07  +1.03140000E-04  +7.01100000E-05  +1.16410000E-04  -1.54277000E-03
   +1.83660000E-04  +3.61290000E-04  -7.40444000E-03  -7.78781000E-03  -1.07603200E-02
   +3.64580000E-04  -4.87700000E-05  +1.20820000E-04  -3.64300000E-05  -9.81400000E-05
   +7.59000000E-06  -6.71400000E-05  +1.17900000E-05  +6.27400000E-05  -4.33300000E-05
   -2.03000000E-06  +4.02000000E-06  -3.11400000E-05  +7.04300000E-05  -3.45900000E-05
   +7.00500000E-05  +2.29500000E-05  -8.18900000E-05  -2.90100000E-05  -2.52700000E-05
   -1.49300000E-05  +1.79700000E-05  +3.22200000E-05  +3.98300000E-05  +4.16100000E-05
   +4.74900000E-05  -1.10600000E-05  -2.84700000E-05  +4.50500000E-05  -1.41500000E-05
   -1.22800000E-05  -5.60000000E-06  +1.85300000E-05  +2.16000000E-06  -4.83000000E-06
   +1.97000000E-06  -2.44900000E-05  -4.85000000E-06  -6.28000000E-06  +8.22000000E-06
   -2.02000000E-06  +5.50000000E-06  +6.02000000E-06  -1.65500000E-05  +8.46000000E-06
   +4.71600000E-05  +4.10200000E-05  -1.61500000E-05  -1.20770000E-04  -7.09800000E-05
   -4.89400000E-05  +5.27400000E-05  +1.01730000E-04  -7.40900000E-05  -1.63300000E-05
   -7.49000000E-06  +1.08000000E-06  +6.69000000E-06  -1.15600000E-05  -2.34500000E-05
   +9.21000000E-06  +1.54000000E-05  +3.14800000E-05  +1.01800000E-05  -2.75000000E-06
   +6.38000000E-06  -1.14470000E-04  +1.37260000E-04  -4.78700000E-05  -1.16334970E-01
   +4.72040520E-01  -2.23959000E-03  -7.67924000E-03  +8.47989000E-03  +1.91767000E-03
   +2.96853000E-03  -4.69859000E-03  +1.83561000E-03  -5.89268000E-03  +1.51450000E-03
   +1.11146300E-02  +4.29300000E-04  -3.13647300E-02  +2.41306800E-02  +1.66498600E-02
   +3.93359300E-02  -2.61107300E-02  +1.08685400E-02  -1.26065700E-02  -2.15000000E-05
   -1.59920000E-04  -5.80000000E-07  +2.93260000E-04  +1.18720000E-04  +6.97450000E-04
   -5.23177000E-03  +1.16519000E-03  +2.54125000E-03  -4.02524000E-03  -4.14226000E-03
   -5.68181000E-03  +4.55230000E-04  +2.36000000E-06  +9.03800000E-05  +9.47800000E-05
   -1.48160000E-04  +4.62090000E-04  -5.73100000E-05  +1.37340000E-04  +7.68700000E-05
   +6.34700000E-05  +1.35670000E-04  -8.15600000E-05  +5.16000000E-06  +3.82200000E-05
   -6.90900000E-05  +1.31200000E-04  +3.48600000E-05  -1.24680000E-04  -9.06400000E-05
   -1.43750000E-04  -3.02500000E-05  +5.94600000E-05  +1.28150000E-04  +1.03370000E-04
   +7.34100000E-05  +4.44100000E-05  -1.51000000E-06  -1.11610000E-04  +7.89000000E-06
   -4.66500000E-05  +1.65000000E-06  +2.36800000E-05  -7.51000000E-06  -1.80400000E-05
   -9.90000000E-07  -1.60000000E-07  -1.19690000E-04  -1.13560000E-04  +5.67000000E-06
   -1.78200000E-05  -1.67000000E-06  -2.13000000E-05  +5.49000000E-06  +1.72100000E-05
   +3.41600000E-05  -2.05000000E-06  +4.50600000E-05  -3.01100000E-05  -6.91500000E-05
   -1.75100000E-05  -9.12900000E-05  +3.86500000E-05  -4.83900000E-05  +9.47000000E-06
   -3.99900000E-05  -1.10400000E-05  +2.01800000E-05  -7.23000000E-06  -6.41700000E-05
   +7.50000000E-07  +1.54300000E-05  +2.16400000E-05  +1.22900000E-05  +1.82000000E-06
   +2.50600000E-05  -4.53000000E-06  -1.74300000E-05  +7.75200000E-04  +1.81020000E-04
   +3.88407200E-02  -1.43480530E-01  +5.41441600E-02  -1.77410000E-04  +6.01920000E-04
   +3.09760000E-04  +9.23770000E-04  -8.63700000E-05  -5.03820000E-04  -5.41820000E-04
   -2.53030000E-04  -1.06300000E-05  -1.14900000E-04  -1.78300000E-04  +7.27740000E-04
   +8.76100000E-05  -5.83652000E-03  -9.00720000E-04  -3.89000000E-04  -1.63916000E-03
   -1.95110000E-04  -6.42000000E-06  -7.26000000E-06  +6.96500000E-05  -2.57100000E-05
   +1.06250000E-04  +1.14420000E-04  -4.64640000E-04  +3.69390000E-04  -1.78300000E-05
   -6.74590000E-04  -8.29710000E-04  -6.83410000E-04  -2.56050000E-04  -1.36520000E-04
   +2.82900000E-05  -1.46560000E-04  -1.33200000E-04  -1.23550000E-04  -5.93800000E-05
   -4.14000000E-05  +7.55500000E-05  +5.85700000E-05  +8.63500000E-05  -2.40200000E-04
   +7.02900000E-05  +1.01460000E-04  +2.47300000E-05  +2.35600000E-05  -1.19400000E-05
   -3.21000000E-06  +4.08000000E-06  +2.66400000E-05  +4.73500000E-05  -1.34220000E-04
   -8.70400000E-05  -2.20000000E-07  +5.56900000E-05  +2.07500000E-05  -2.18000000E-05
   +3.19800000E-05  -5.44000000E-06  -1.68000000E-05  -5.05800000E-05  +1.15700000E-05
   +2.10600000E-05  +4.30000000E-06  +3.77000000E-06  -7.65000000E-06  +1.53370000E-04
   +1.16920000E-04  +4.17000000E-06  +1.49500000E-05  +1.54100000E-05  +1.14500000E-05
   -1.53000000E-06  -1.53400000E-05  -1.88100000E-05  +1.33260000E-04  -3.93000000E-05
   +1.71760000E-04  -3.44940000E-04  -1.01090000E-04  +1.98580000E-04  +2.96700000E-05
   +2.03140000E-04  -1.32940000E-04  +3.66000000E-06  -2.17100000E-05  +2.60000000E-06
   -8.12000000E-06  -8.44000000E-06  -1.95900000E-05  +2.00000000E-06  -2.00000000E-07
   +6.23300000E-05  -2.08000000E-05  -2.22900000E-05  -7.39000000E-06  +1.06130000E-04
   +1.05560000E-04  +1.53390000E-04  -3.22738300E-02  +1.15221280E-01  -4.08985200E-02
   +3.39875900E-02  -1.07148000E-03  -1.42094000E-03  +2.91130000E-03  +1.71397000E-03
   -2.06390000E-04  -7.29300000E-04  -2.03600000E-05  +1.22360000E-04  -4.82670000E-04
   +2.90900000E-03  -1.02654000E-03  -2.10745000E-03  +2.90674000E-03  -2.52062000E-03
   +5.67413000E-03  -2.89348000E-03  +2.17555000E-03  -1.71460000E-03  +3.16100000E-05
   +1.38200000E-05  +8.49000000E-05  -4.85600000E-05  +1.46700000E-05  +1.05420000E-04
   -1.61269000E-03  +9.71500000E-04  +8.49300000E-05  -4.15030000E-04  -2.73230000E-04
   -8.69510000E-04  +6.89700000E-05  +3.62500000E-05  -2.30600000E-05  -4.09340000E-04
   +1.50860000E-04  +3.34700000E-05  +3.29900000E-05  -1.78430000E-04  -6.95700000E-05
   +3.61390000E-04  +1.62340000E-04  -1.35700000E-05  +1.29070000E-04  -4.85000000E-05
   -8.96600000E-05  -1.86900000E-05  +3.76800000E-05  +7.34200000E-05  +4.94100000E-05
   +4.79700000E-05  -2.44000000E-06  -1.27120000E-04  -9.39000000E-05  -1.17600000E-05
   +3.06500000E-05  -5.25200000E-05  -5.88000000E-05  -2.90000000E-05  +1.83900000E-05
   +7.17100000E-05  +9.03000000E-06  -1.00200000E-05  -1.42000000E-05  +1.47200000E-05
   +6.58000000E-06  -5.63000000E-06  +1.55260000E-04  +1.05030000E-04  -1.11700000E-05
   -1.90000000E-06  +9.31000000E-06  +5.41000000E-06  -3.91600000E-05  -2.75700000E-05
   -6.67400000E-05  -5.95100000E-05  -1.26260000E-04  -1.25970000E-04  +6.24600000E-05
   +9.39200000E-05  -4.65500000E-05  -7.55100000E-05  -1.85480000E-04  +1.99670000E-04
   +5.80000000E-05  -5.61600000E-05  +1.10100000E-05  -2.39600000E-05  +3.88100000E-05
   +2.29200000E-05  -5.88200000E-05  +4.58000000E-06  -6.91800000E-05  -2.66100000E-05
   -2.02900000E-05  -3.40000000E-06  +1.62360000E-04  +2.96400000E-05  -7.91900000E-05
   +1.05771710E-01  -4.61845260E-01  +1.28266980E-01  -1.07536130E-01  +4.64052850E-01
   -7.03970000E-04  -1.51400000E-05  +4.38090000E-04  +2.20670000E-04  +5.93380000E-04
   -4.26060000E-04  +5.68480000E-04  +3.72710000E-04  -4.24800000E-04  -5.62760000E-04
   -2.46357000E-03  +8.50780000E-04  -1.96480000E-04  -7.35306000E-03  -9.58380000E-04
   -2.49400000E-05  -1.45177000E-03  -3.17300000E-05  +2.66000000E-06  -1.43000000E-06
   +3.90900000E-05  -2.74000000E-05  +2.21400000E-05  +2.10100000E-05  +3.41410000E-04
   +1.81300000E-04  -5.58470000E-04  -5.41420000E-04  -1.11799000E-03  -7.14890000E-04
   +2.62330000E-04  +2.62190000E-04  +5.32500000E-05  -2.43960000E-04  +2.68010000E-04
   +1.97500000E-05  +3.79700000E-05  -1.45600000E-04  -6.42600000E-05  -2.58900000E-05
   -2.10270000E-04  +1.59090000E-04  +7.03800000E-05  -8.95900000E-05  -7.49400000E-05
   -2.37500000E-05  +3.88400000E-05  +6.86000000E-05  +4.59600000E-05  +5.88300000E-05
   -1.02100000E-05  -6.20600000E-05  -6.55800000E-05  -2.02700000E-05  -8.90000000E-07
   -3.68200000E-05  -3.58300000E-05  +2.23700000E-05  +2.21500000E-05  +5.56300000E-05
   +1.63700000E-05  -2.29700000E-05  -3.00000000E-08  +1.61500000E-05  +5.71000000E-06
   -1.69000000E-06  +9.49500000E-05  +6.77900000E-05  -1.03300000E-05  +2.81000000E-06
   +3.72000000E-06  +6.26000000E-06  -2.03600000E-05  -2.07900000E-05  -4.71700000E-05
   +3.06900000E-05  -1.13000000E-05  -1.14020000E-04  +1.98320000E-04  +1.00050000E-04
   -5.65200000E-05  -1.88100000E-05  +4.27300000E-05  +1.15780000E-04  +5.08000000E-05
   -3.46300000E-05  +1.40800000E-05  -8.04000000E-06  +4.98300000E-05  +2.84000000E-06
   -3.10500000E-05  +1.09700000E-05  -5.12700000E-05  -1.28700000E-05  -1.29200000E-05
   -2.40000000E-07  +4.66000000E-05  -1.44760000E-04  -3.84200000E-05  -4.13036600E-02
   +1.42048710E-01  -5.28485100E-02  +4.17793700E-02  -1.30950860E-01  +5.46437700E-02
end_hess

