# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -807.46900940    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -2.40599631E+00  -3.89473201E-01  -1.59265390E+00
   006   -2.09700372E+00  +1.08946435E+00  +6.24380005E-01
   006   -3.94508827E+00  +8.89332245E-01  +2.46099855E+00
   006   -5.96302198E+00  -7.82268324E-01  +2.22710273E+00
   006   -6.15027399E+00  -2.35510965E+00  +1.28994929E-01
   006   -4.34765903E+00  -2.19884517E+00  -1.74810202E+00
   006   +2.37812623E-01  +2.77169406E+00  +8.93104028E-01
   006   +2.99745253E-02  +4.99126477E+00  -9.64624770E-01
   008   -8.12687233E+00  -3.99315132E+00  +4.35718608E-02
   006   +2.58595322E+00  +1.14581883E+00  +4.05486705E-01
   006   +2.93743930E+00  -1.06225200E+00  +1.79506747E+00
   006   +5.04031696E+00  -2.57717770E+00  +1.46427816E+00
   006   +6.87086857E+00  -1.90863178E+00  -2.97276952E-01
   006   +6.55689935E+00  +2.73605198E-01  -1.70801184E+00
   006   +4.43591549E+00  +1.77026978E+00  -1.35061264E+00
   008   +8.97615693E+00  -3.31954816E+00  -7.11221227E-01
   006   +4.72110765E-01  +3.89153656E+00  +3.56222019E+00
   008   -4.00914931E+00  +2.03972898E+00  -4.13179668E+00
   001   +8.96441943E+00  -4.76387600E+00  +3.76192501E-01
   001   +5.25477796E+00  -4.28703831E+00  +2.57263140E+00
   001   +1.52050676E+00  -1.63290980E+00  +3.15800604E+00
   001   +4.24486672E+00  +3.45283411E+00  -2.49154258E+00
   001   +7.97839418E+00  +7.82691099E-01  -3.08490531E+00
   001   +2.22352165E+00  +4.96723837E+00  +3.68935984E+00
   001   -1.08741059E+00  +5.17517561E+00  +3.97701834E+00
   001   +5.24374874E-01  +2.43224092E+00  +5.01520587E+00
   001   -7.38208906E-02  +4.36390342E+00  -2.91822318E+00
   001   -1.69446473E+00  +6.04806347E+00  -5.75005613E-01
   001   +1.62710702E+00  +6.27528119E+00  -7.36537913E-01
   001   -3.83259000E+00  +2.01496629E+00  +4.16045794E+00
   001   -7.38503717E+00  -9.10203469E-01  +3.68943192E+00
   001   -4.46228646E+00  -3.38334323E+00  -3.41224463E+00
   001   -8.42732087E-01  -5.34875713E-01  -2.89487525E+00
   001   -8.08526963E+00  -4.91783421E+00  -1.50992094E+00
   001   -5.42724905E+00  +2.52982448E+00  -3.09884287E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +8.00000000E-08  -3.70000000E-07  +4.80000000E-07
   +0.00000000E+00  +1.20000000E-07  -2.10000000E-07
   +1.20000000E-07  +8.30000000E-07  -2.40000000E-07
   -1.80000000E-07  +7.10000000E-07  -1.00000000E-08
   -3.60000000E-07  +6.30000000E-07  +9.30000000E-07
   -1.00000000E-08  +5.00000000E-08  +3.20000000E-07
   +1.30000000E-07  +1.10000000E-07  -4.90000000E-07
   +3.40000000E-07  -2.70000000E-07  -9.70000000E-07
   -3.30000000E-07  +5.40000000E-07  +8.30000000E-07
   +6.00000000E-08  -1.40000000E-07  -1.20000000E-07
   -1.40000000E-07  +1.80000000E-07  +3.30000000E-07
   -2.60000000E-07  -7.00000000E-08  +7.50000000E-07
   -1.90000000E-07  -6.10000000E-07  +6.50000000E-07
   +0.00000000E+00  -8.90000000E-07  +1.80000000E-07
   +1.00000000E-07  -6.90000000E-07  -1.70000000E-07
   -2.30000000E-07  -8.60000000E-07  +9.60000000E-07
   +2.00000000E-07  +6.80000000E-07  -7.30000000E-07
   +4.00000000E-08  -5.20000000E-07  -5.50000000E-07
   -3.90000000E-07  -6.20000000E-07  +1.29000000E-06
   -3.80000000E-07  +1.30000000E-07  +1.12000000E-06
   -2.00000000E-07  +5.40000000E-07  +4.80000000E-07
   +2.60000000E-07  -9.00000000E-07  -5.70000000E-07
   +8.00000000E-08  -1.29000000E-06  +5.00000000E-08
   +2.70000000E-07  +5.90000000E-07  -9.30000000E-07
   +2.80000000E-07  +9.00000000E-07  -1.03000000E-06
   +6.00000000E-08  +1.02000000E-06  -4.10000000E-07
   +3.50000000E-07  -6.70000000E-07  -8.10000000E-07
   +4.20000000E-07  -4.00000000E-08  -1.23000000E-06
   +4.30000000E-07  -3.20000000E-07  -1.23000000E-06
   +7.00000000E-08  +1.15000000E-06  -3.80000000E-07
   -1.70000000E-07  +1.30000000E-06  +2.00000000E-07
   -2.30000000E-07  -4.70000000E-07  +7.70000000E-07
   -6.00000000E-08  -5.90000000E-07  +2.10000000E-07
   -3.80000000E-07  +2.00000000E-07  +1.04000000E-06
   +2.30000000E-07  -3.50000000E-07  -5.00000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.82141150E-01  +1.82614250E-01  +3.47792280E-01  -1.93699940E-01  +2.28255180E-01
   +4.51017190E-01  -1.11359270E-01  -4.28333000E-02  -1.56094300E-02  +5.25484490E-01
   -1.05396500E-02  -1.51121700E-01  -8.60548900E-02  +1.51584790E-01  +3.67331260E-01
   +2.28342000E-02  -1.10105610E-01  -1.87865320E-01  -1.29010230E-01  +1.23817330E-01
   +5.46977330E-01  +2.90243500E-02  +2.42816800E-02  +4.29977600E-02  -2.07673150E-01
   -4.53871500E-02  +8.22094200E-02  +5.00870560E-01  +2.18506800E-02  +1.54647500E-02
   +5.11880000E-04  -1.82980200E-02  -9.55664500E-02  -3.39012200E-02  +1.97194300E-01
   +4.15625920E-01  +1.61806800E-02  -1.74934500E-02  -4.27627500E-02  +1.37920810E-01
   +3.34031000E-03  -2.19948310E-01  -1.15888720E-01  +2.09965050E-01  +6.15957830E-01
   -1.36553400E-02  -1.12963500E-02  -1.84663700E-02  -4.51832700E-02  -1.11739900E-02
   +4.76080700E-02  -2.17271040E-01  -1.37984130E-01  -2.88333700E-02  +5.54830340E-01
   -1.07677500E-02  -2.88599300E-02  -1.30857000E-02  -3.58195000E-02  +1.05448300E-02
   +5.33005100E-02  -9.92809700E-02  -1.74336610E-01  -6.07247900E-02  +2.09871950E-01
   +4.02645600E-01  -7.61398000E-03  -2.22791100E-02  -5.11586000E-03  +4.25306000E-03
   +1.83646900E-02  +3.69614400E-02  +3.42903700E-02  -1.41417300E-02  -1.21924110E-01
   -1.75448340E-01  +1.66500550E-01  +5.80050220E-01  -3.07749700E-02  -3.21753600E-02
   +1.88422600E-02  -1.11294900E-02  +8.47533000E-03  +2.27422900E-02  +2.91777600E-02
   -5.23863000E-03  -3.61234900E-02  -1.14301150E-01  -4.87195700E-02  -2.17437000E-02
   +5.37196240E-01  -1.68299600E-02  +2.04156000E-02  +1.53289300E-02  +1.42570700E-02
   -4.13874000E-03  -1.75089900E-02  -3.47713700E-02  -2.89621500E-02  -7.73218000E-03
   -9.09850000E-04  -1.54368450E-01  -1.23317700E-01  +2.19489570E-01  +4.42784230E-01
   +1.86252000E-02  +6.09403400E-02  +4.23671000E-03  +2.82949400E-02  -7.81726000E-03
   -5.65733100E-02  -8.14665100E-02  -4.20902100E-02  +3.14901900E-02  +4.97530200E-02
   -7.04936100E-02  -2.27693020E-01  -1.27084210E-01  +1.67257520E-01  +5.64362670E-01
   -2.21269660E-01  -8.99610400E-02  -3.21014000E-03  +1.85620600E-02  -2.06181600E-02
   -4.12112100E-02  -4.38655700E-02  -1.78714100E-02  +1.79085000E-02  +2.97051300E-02
   +4.43197500E-02  +4.38339300E-02  -1.97792610E-01  -5.00503400E-02  +8.22154600E-02
   +4.97038760E-01  -1.47997580E-01  -1.65128560E-01  -5.38323700E-02  -6.55706000E-03
   -1.36423500E-02  -2.03424700E-02  -1.93784500E-02  -1.12740900E-02  +9.69232000E-03
   +2.24600500E-02  +2.74397000E-02  +3.20929000E-03  -5.55196000E-03  -1.08359700E-01
   -5.37601500E-02  +1.97951630E-01  +4.30859190E-01  +7.73400000E-04  -5.24278800E-02
   -8.79775100E-02  -3.07279900E-02  -1.97858300E-02  +2.12976400E-02  +2.75205300E-02
   +1.23063000E-02  -1.53552800E-02  +3.45613000E-03  -3.67849700E-02  -5.08868300E-02
   +1.41298480E-01  +1.21156000E-02  -2.16198430E-01  -1.44922930E-01  +2.07448720E-01
   +6.00652950E-01  -3.06588000E-03  -5.35050000E-03  -7.81052000E-03  -1.38166230E-01
   -4.62486900E-02  +1.64570000E-04  -1.55080400E-02  -1.41164900E-02  +7.37530000E-04
   +9.95910000E-04  -1.82597000E-03  +2.90007000E-03  -1.89561000E-03  -8.19400000E-05
   +1.49152000E-03  +3.01712000E-03  +6.91850000E-04  +1.10868000E-03  +4.66464550E-01
   -1.39270200E-02  -1.00464800E-02  -4.05785000E-03  -4.54165700E-02  -1.05313140E-01
   -1.08869300E-02  -7.03150000E-03  +2.94323000E-03  +3.38460000E-03  -8.31480000E-04
   +5.30196000E-03  -3.02954000E-03  -3.30600000E-05  -6.69210000E-04  -4.64390000E-04
   -9.70430000E-04  +1.76523000E-03  -2.98957000E-03  +2.39880000E-03  +4.80151750E-01
   -2.21441300E-02  -1.76631300E-02  +2.51344000E-03  -7.16493000E-03  -1.38285300E-02
   -8.62754200E-02  +1.63671000E-02  +1.31584700E-02  +6.92514000E-03  +3.49564000E-03
   -2.80771000E-03  -2.35026000E-03  -6.12020000E-04  -1.40140000E-04  +7.90800000E-05
   +1.80151000E-03  -3.00101000E-03  -4.48470000E-03  -1.66761000E-03  -4.99600000E-04
   +4.81091940E-01  -7.58760000E-04  +4.01170000E-04  -5.71850000E-04  +9.18100000E-05
   -2.13334400E-02  +1.82048900E-02  -2.67918000E-03  -1.70469000E-03  -1.01824000E-03
   -8.27580000E-04  +1.33568000E-03  -1.90290000E-04  +9.92310000E-04  +1.58590000E-04
   -7.59490000E-04  -8.30840000E-04  -4.01400000E-05  +6.69460000E-04  -7.57367800E-02
   +1.00689000E-03  -1.54438000E-03  +5.86105430E-01  +9.21600000E-05  +4.71790000E-04
   +6.60760000E-04  -7.77619000E-03  -2.26286100E-02  +1.30043600E-02  +1.14915000E-03
   -6.14770000E-04  -1.17127000E-03  -7.48460000E-04  +1.17670000E-04  -5.93130000E-04
   -5.21800000E-05  +3.15760000E-04  +4.40830000E-04  -1.03550000E-04  +6.62120000E-04
   -5.16700000E-05  +8.54035000E-03  -1.31738990E-01  +5.06351400E-02  +8.51140000E-03
   +5.05957130E-01  -1.80763000E-03  -4.18800000E-04  -1.54289000E-03  +6.68543000E-03
   +4.01411000E-03  +2.35673000E-03  -1.31295000E-03  -2.66810000E-04  +7.70000000E-05
   +1.33960000E-04  +4.05510000E-04  +3.10450000E-04  +7.01280000E-04  -1.81290000E-04
   -8.11290000E-04  -3.82070000E-04  -6.04370000E-04  +5.42370000E-04  -6.72219000E-03
   +4.44401700E-02  -1.16943120E-01  -3.43447000E-03  +6.52605700E-02  +5.54317340E-01
   +3.81205000E-03  +2.33784000E-03  +6.65386000E-03  -4.27210000E-04  -2.47827000E-03
   -3.47744000E-03  -8.41430000E-04  -1.03114000E-03  +3.74511000E-03  -4.19916000E-03
   -1.37636400E-02  -6.81432000E-03  -2.12388540E-01  -1.15273950E-01  +3.17750700E-02
   -3.62125200E-02  -3.43828300E-02  -2.68720000E-04  +1.07603000E-03  +4.82640000E-04
   +4.58200000E-04  -8.67270000E-04  -1.01940000E-04  -4.97890000E-04  +2.84423660E-01
   -8.78670000E-04  +3.82854000E-03  +4.78300000E-04  -1.37446000E-03  -2.60655000E-03
   +6.45150000E-04  +2.42407000E-03  +3.69487000E-03  -4.74870000E-03  -3.37691900E-02
   -2.77659300E-02  -1.14825400E-02  -1.39111930E-01  -1.58056940E-01  -5.21534000E-03
   -1.56708800E-02  -1.66642000E-03  -3.45770000E-03  +1.04614000E-03  -5.07500000E-05
   +7.90350000E-04  -7.64810000E-04  -1.97000000E-04  -3.19440000E-04  +1.79781320E-01
   +3.31908720E-01  +3.34118000E-03  -8.51459000E-03  -1.87608000E-03  -2.70901000E-03
   +1.05743000E-03  +4.30764000E-03  +9.08131000E-03  -5.09800000E-04  -6.49185000E-03
   -3.68640700E-02  -3.47310300E-02  -1.56622000E-03  -6.82499000E-03  -3.64054100E-02
   -9.20827600E-02  +3.00786200E-02  +2.35881400E-02  +3.84501000E-03  -2.16360000E-04
   +3.00100000E-04  +1.71210000E-04  -4.25300000E-05  -4.92100000E-05  -1.97800000E-05
   -4.03787000E-02  +2.60704310E-01  +4.99585470E-01  -1.28497000E-03  +7.20170000E-04
   -1.36254000E-03  -3.67217700E-02  +8.03361000E-03  +7.13083000E-03  -4.89300000E-04
   -2.93390000E-04  -2.08858000E-03  -1.22090000E-04  -1.23467000E-03  +5.60490000E-04
   -9.79200000E-05  +6.69500000E-05  +4.08330000E-04  +2.22350000E-04  +4.30210000E-04
   +6.02880000E-04  -1.37433350E-01  +4.40216000E-02  +1.61926700E-02  -2.93592000E-03
   +7.33205000E-03  -2.70609000E-03  -2.23000000E-05  -2.03600000E-05  -4.07000000E-05
   +5.31395870E-01  -2.76726000E-03  +3.89180000E-04  -1.70133000E-03  -1.01419400E-02
   +1.29681300E-02  +5.30573000E-03  -1.40810000E-03  -2.49194000E-03  -1.04503000E-03
   -3.21410000E-04  -8.22940000E-04  +8.51020000E-04  +7.20220000E-04  +4.23040000E-04
   -2.87310000E-04  -2.54270000E-04  -6.13920000E-04  +4.68070000E-04  +3.94662700E-02
   -1.09096060E-01  +1.22406000E-03  +2.30868700E-02  -1.85206600E-02  -3.32501000E-03
   -7.76390000E-04  -6.80620000E-04  -1.15620000E-04  -9.46230700E-02  +5.18719270E-01
   -2.18394000E-03  -8.72910000E-04  -2.39960000E-04  +2.85123000E-03  +1.45523000E-03
   -2.38540000E-04  -4.20640000E-04  -3.22800000E-05  +1.42310000E-04  +5.75200000E-05
   +2.28270000E-04  +7.77100000E-05  +1.98650000E-04  +9.15700000E-05  -1.66730000E-04
   -3.23730000E-04  +2.22090000E-04  +7.27000000E-05  +1.85646900E-02  -1.32711000E-03
   -8.15185000E-02  -1.87521900E-02  +1.25394500E-02  +4.50443000E-03  -2.35020000E-04
   -2.96540000E-04  +6.05200000E-05  -1.70836010E-01  -1.77845590E-01  +4.37228870E-01
   -1.11101000E-03  +6.98450000E-04  -1.21504000E-03  -7.97480000E-04  +3.04325000E-03
   -8.50440000E-04  +3.17880000E-04  +5.37730000E-04  -4.16910000E-04  -2.50000000E-05
   -2.72130000E-04  +9.17000000E-05  +1.68210000E-04  -1.90700000E-05  -1.84000000E-06
   +1.43480000E-04  -1.73500000E-05  -3.45700000E-05  -4.76879000E-03  +2.37598400E-02
   -1.47563700E-02  -4.71475000E-03  +2.56047000E-03  +2.07539000E-03  -1.22990000E-04
   -1.08780000E-04  +4.65000000E-06  -1.17239730E-01  +8.47964000E-03  +2.67624300E-02
   +6.01235810E-01  +5.07600000E-05  -3.95130000E-04  -9.83460000E-04  -2.97940000E-04
   -7.98830000E-04  +3.72460000E-04  +9.51500000E-05  -4.67200000E-05  +2.78460000E-04
   -2.19430000E-04  -3.49140000E-04  +5.12000000E-06  -2.45090000E-04  +3.87000000E-06
   +3.16140000E-04  +3.19900000E-05  +3.41660000E-04  +1.39300000E-05  +9.73485000E-03
   -1.66890100E-02  +6.58480000E-03  +2.16232000E-03  -1.54170000E-04  -8.25690000E-04
   +4.04700000E-05  +1.39700000E-05  +4.81500000E-05  +5.79596700E-02  -2.44081250E-01
   +8.78380900E-02  -1.31919860E-01  +5.37271700E-01  -5.25130000E-04  +6.23300000E-04
   -2.72650000E-04  -7.08580000E-04  +4.65000000E-05  +6.65870000E-04  +2.20920000E-04
   +3.35970000E-04  -5.58880000E-04  +6.18200000E-05  +2.60910000E-04  -9.07900000E-05
   +2.19730000E-04  +2.36000000E-06  -1.01990000E-04  -2.67600000E-05  -5.27300000E-05
   +1.37850000E-04  -3.18080000E-03  -4.23535000E-03  +6.91734000E-03  +2.03515000E-03
   -7.62500000E-04  -4.31870000E-04  -3.48400000E-05  -2.97000000E-06  -2.06100000E-05
   -1.05114700E-02  +1.21488110E-01  -1.53315770E-01  -2.14011300E-01  -1.97600130E-01
   +4.34646980E-01  +3.14920000E-04  -3.80110000E-04  +4.77990000E-04  +3.94890000E-04
   -5.67700000E-05  -3.78460000E-04  -4.27890000E-04  -3.81520000E-04  +1.15270000E-04
   +1.55340000E-04  +2.18510000E-04  +7.47500000E-05  +1.77350000E-04  +8.59100000E-05
   -1.81250000E-04  -2.30030000E-04  -1.82000000E-05  +1.67850000E-04  +4.43642000E-03
   -3.32600000E-05  +1.14196000E-03  +2.34320000E-04  -3.35340000E-04  +3.61240000E-04
   -1.87350000E-04  -1.61980000E-04  +7.89000000E-06  +1.67399300E-02  +6.04384800E-02
   -5.18210600E-02  -2.61082310E-01  +9.88643800E-02  +6.59827600E-02  +5.62943080E-01
   -8.79100000E-05  +4.22390000E-04  -4.31020000E-04  -7.27170000E-04  -9.98000000E-06
   -5.03200000E-05  +1.61420000E-04  +3.64530000E-04  -2.11290000E-04  +9.04700000E-05
   +5.24800000E-05  +4.30000000E-07  +2.92310000E-04  +6.84000000E-06  -1.81520000E-04
   -1.61130000E-04  -7.86100000E-05  +1.13600000E-04  -2.76170000E-04  -1.08848000E-03
   +5.50793000E-03  +1.21279000E-03  -5.47470000E-04  -4.15940000E-04  -1.45580000E-04
   -9.45000000E-05  -2.45000000E-06  +2.14574900E-02  -3.16262600E-02  +1.46621500E-02
   +1.49031590E-01  -1.86899450E-01  -8.52931000E-03  -1.59405610E-01  +5.83193630E-01
   -1.33590000E-04  +1.17720000E-04  -2.36620000E-04  +4.24620000E-04  -7.58500000E-05
   -2.17400000E-05  +3.37940000E-04  +2.38360000E-04  -6.15000000E-06  -1.37540000E-04
   -1.99880000E-04  -6.17600000E-05  -2.16800000E-04  -6.78800000E-05  +1.79740000E-04
   +2.12730000E-04  +9.87500000E-05  -1.99790000E-04  +1.04351000E-03  +4.58344000E-03
   +4.22160000E-04  -6.96120000E-04  +5.63340000E-04  +2.21480000E-04  +1.76200000E-04
   +1.75860000E-04  +1.43000000E-06  -2.18269400E-02  -1.22357100E-02  +3.30299700E-02
   +2.89586500E-02  +2.60533600E-02  -9.84584600E-02  -1.83963720E-01  -2.27406960E-01
   +4.20199770E-01  -5.14700000E-05  +1.07200000E-05  +6.07000000E-04  -2.84540000E-04
   -6.82420000E-04  -1.05820000E-04  +2.87870000E-04  +2.64330000E-04  -6.98000000E-06
   +1.74000000E-05  -4.83000000E-06  -4.89700000E-05  -7.60960000E-04  -3.97960000E-04
   +2.54910000E-04  +4.72400000E-04  +5.87400000E-05  -3.88810000E-04  -2.19042000E-03
   +3.96830000E-04  +1.65850000E-04  +3.68440000E-04  +2.33430000E-04  -1.62210000E-04
   +7.42680000E-04  +6.37320000E-04  +3.28900000E-05  -6.75472000E-03  -2.26050900E-02
   +1.80329800E-02  -4.52530500E-02  +2.41977000E-02  +1.49120800E-02  -1.97673000E-01
   -5.25799600E-02  +1.27811570E-01  +5.75888220E-01  -2.82950000E-04  +4.22750000E-04
   -9.79990000E-04  -4.60200000E-05  +1.21770000E-03  +4.61060000E-04  -4.38300000E-05
   +8.03900000E-05  -9.72500000E-05  -2.02000000E-05  -1.52110000E-04  +6.10100000E-05
   +6.97750000E-04  +2.96520000E-04  -2.33030000E-04  -2.64010000E-04  -2.19720000E-04
   +3.03860000E-04  -5.64730000E-04  -1.08998000E-03  +9.01450000E-04  -2.12190000E-04
   +9.65700000E-05  +1.03000000E-06  -6.25020000E-04  -5.41770000E-04  -4.82700000E-05
   -2.12341600E-02  -3.73257900E-02  +3.82581300E-02  -1.82609000E-02  +5.60280800E-02
   -2.70486300E-02  +7.85927000E-03  -1.36829730E-01  +4.43637000E-02  -1.42004550E-01
   +5.79298550E-01  +2.90010000E-04  -3.93600000E-04  +4.29480000E-04  +3.36660000E-04
   -2.27390000E-04  -2.78840000E-04  -3.01260000E-04  -2.83140000E-04  +1.42510000E-04
   +7.19700000E-05  +1.31970000E-04  +1.64000000E-05  -7.27000000E-06  +4.19700000E-05
   -6.63500000E-05  -1.46810000E-04  +6.00700000E-05  +2.86400000E-05  +1.32943000E-03
   +2.56170000E-04  -1.24194000E-03  +4.06900000E-05  -2.47700000E-05  +3.17420000E-04
   -2.31400000E-05  -2.29300000E-05  +7.70000000E-06  +1.67968500E-02  +3.89447500E-02
   -4.67299900E-02  +4.64606100E-02  -5.62712900E-02  +1.22015400E-02  +8.33942400E-02
   +8.64543100E-02  -1.90472040E-01  -1.80716900E-01  -2.11330300E-01  +4.45626150E-01
   -2.50280000E-04  +3.65980000E-04  -4.31730000E-04  +2.30200000E-05  +6.50970000E-04
   +3.07250000E-04  +5.53900000E-05  +1.10850000E-04  -1.04990000E-04  +3.25700000E-05
   -2.26600000E-05  +4.63000000E-05  +2.99710000E-04  +2.10000000E-05  -1.64240000E-04
   -4.03900000E-05  -2.11320000E-04  +9.30600000E-05  +1.08794000E-03  -7.86800000E-04
   +4.02261000E-03  +1.56170000E-04  -5.42100000E-04  +3.53800000E-05  -1.86360000E-04
   -1.31960000E-04  -2.92300000E-05  -4.10008100E-02  -1.47511100E-02  +4.43677900E-02
   -2.21559900E-02  +3.22190200E-02  -1.06759100E-02  +3.91811900E-02  -2.27815500E-02
   -4.43505000E-03  -1.16012260E-01  -7.65070000E-03  +3.69105100E-02  +6.01012070E-01
   +5.37920000E-04  -5.07120000E-04  +6.43630000E-04  +6.18520000E-04  -1.01610000E-03
   -4.92200000E-04  -3.70200000E-05  -1.60610000E-04  +2.29910000E-04  +3.52000000E-05
   +1.69840000E-04  -6.05900000E-05  -3.98030000E-04  -1.54610000E-04  +1.28320000E-04
   +6.68200000E-05  +1.83310000E-04  -1.30540000E-04  +2.10960000E-04  +1.72871000E-03
   +3.29264000E-03  +6.45200000E-04  -5.69800000E-04  -6.34500000E-05  +3.44660000E-04
   +3.15750000E-04  +3.97800000E-05  +2.25486500E-02  +4.99387400E-02  -4.71771200E-02
   +3.00656900E-02  -5.19105300E-02  +1.56624000E-02  -5.72043300E-02  +3.91689000E-03
   +4.31547600E-02  +4.91618500E-02  -2.47209270E-01  +9.71052900E-02  -1.39769390E-01
   +5.43990390E-01  +1.65610000E-04  -7.52600000E-05  -2.28960000E-04  +9.14500000E-04
   -7.17020000E-04  -4.62200000E-04  +1.90080000E-04  +2.11470000E-04  +1.43360000E-04
   -4.62500000E-05  -1.02300000E-05  -1.10470000E-04  +9.79000000E-06  +7.13700000E-05
   +9.97800000E-05  +2.38100000E-05  +8.28100000E-05  -1.73800000E-05  +3.87567000E-03
   +4.25440000E-03  +1.33621000E-03  -6.84110000E-04  +6.22840000E-04  -3.71100000E-05
   -6.10000000E-05  -6.52000000E-05  +7.73000000E-06  +1.66904000E-02  -2.18451200E-02
   +1.15930900E-02  -9.15914000E-03  +1.42380300E-02  -7.32178000E-03  +2.12544500E-02
   +1.91919700E-02  -2.05763100E-02  -5.37323000E-03  +1.36785200E-01  -1.69674810E-01
   -2.24160850E-01  -2.12443760E-01  +4.45289780E-01  +3.85330000E-04  -3.54760000E-04
   +8.99700000E-04  -1.07298000E-03  +1.22874000E-03  +5.03920000E-04  -7.25590000E-04
   -8.17140000E-04  +2.54900000E-05  +1.12080000E-04  +7.78400000E-05  +2.06560000E-04
   -1.67900000E-05  +4.58600000E-05  -9.34900000E-05  -3.01100000E-05  -5.72700000E-05
   +4.69500000E-05  -1.70459500E-02  -2.11189000E-03  +1.51294500E-02  -1.71734000E-03
   -1.10970000E-04  +1.12107000E-03  -2.88000000E-06  -7.80000000E-07  -4.00000000E-08
   -2.12058930E-01  +8.37752000E-03  +9.48146100E-02  +3.96832000E-02  -6.28509800E-02
   +2.55627800E-02  -5.76018000E-02  +1.21768900E-02  +2.82962400E-02  +1.97759500E-02
   +6.42685200E-02  -6.02784000E-02  -2.57705690E-01  +9.32588800E-02  +6.72760100E-02
   +5.54558070E-01  -1.76770000E-04  +9.74300000E-05  +1.19540000E-04  +9.97650000E-04
   -2.29141000E-03  -1.24928000E-03  +6.61060000E-04  +7.35450000E-04  +7.97800000E-05
   -8.57200000E-05  -3.37700000E-05  -2.93490000E-04  -2.55370000E-04  +2.42200000E-05
   +3.12280000E-04  +2.33870000E-04  +2.92160000E-04  -1.77970000E-04  +1.19431700E-02
   +8.96703000E-03  -1.22590200E-02  +1.08654000E-03  -3.37480000E-04  -1.06205000E-03
   +1.70970000E-04  +1.10680000E-04  +9.66000000E-06  -4.09959400E-02  -1.25950830E-01
   +7.22835100E-02  -2.45999600E-02  +6.07700000E-04  +2.27546800E-02  +9.53486000E-03
   -5.32372000E-03  -5.31781000E-03  +2.18604200E-02  -3.42148000E-02  +1.18763800E-02
   +1.43621990E-01  -1.83455920E-01  -8.55830000E-03  -1.47007130E-01  +5.82704870E-01
   -7.25090000E-04  +2.87030000E-04  -1.38496000E-03  -1.63207000E-03  +6.18340000E-04
   +1.23260000E-04  +3.10890000E-04  +1.42720000E-04  +6.74100000E-05  -1.06550000E-04
   -3.48690000E-04  +5.37900000E-05  +1.86670000E-04  +5.15100000E-05  -2.85800000E-05
   -1.24150000E-04  +5.77100000E-05  +2.39720000E-04  +5.24180000E-03  -2.51932000E-03
   +4.44030000E-04  -2.52730000E-04  -6.79340000E-04  -4.10870000E-04  -2.55470000E-04
   -2.33430000E-04  +1.59900000E-05  +1.31858640E-01  +3.91144900E-02  -1.87977880E-01
   -2.73266000E-03  +4.88441400E-02  -2.60297200E-02  +2.98723500E-02  -7.06213000E-03
   -1.90012900E-02  -2.84003700E-02  -1.72884400E-02  +3.46358800E-02  +2.99348900E-02
   +2.62130400E-02  -1.01299810E-01  -1.76466390E-01  -2.27435530E-01  +4.38450760E-01
   -1.68860000E-04  +1.96880000E-04  -8.21290000E-04  +2.17730000E-04  +1.27156000E-03
   +2.52020000E-04  -3.39470000E-04  -2.00860000E-04  -1.09560000E-04  +2.55100000E-05
   -2.21100000E-05  +9.08000000E-05  +9.86760000E-04  +4.55720000E-04  -3.73610000E-04
   -5.40920000E-04  -2.13790000E-04  +4.84840000E-04  +1.46247000E-03  -9.43570000E-04
   +2.78870000E-04  -5.28120000E-04  -9.48700000E-05  +2.60110000E-04  -9.23570000E-04
   -8.01580000E-04  -4.99200000E-05  -2.46113000E-03  +2.80300000E-03  -1.89059000E-03
   +3.44334000E-03  -3.37261000E-03  +5.12175000E-03  -3.93816300E-02  +2.95990700E-02
   +1.20511700E-02  -2.33311780E-01  +8.84524700E-02  +6.61566000E-02  -8.44698000E-03
   +1.92256100E-02  -3.17743000E-03  +1.48541000E-03  -1.22653000E-03  +3.32433000E-03
   +3.14787590E-01  +1.83890000E-04  -1.67440000E-04  +6.66250000E-04  -1.61940000E-04
   -1.06490000E-03  -1.51910000E-04  +2.74300000E-04  +1.28410000E-04  +7.33700000E-05
   -3.01700000E-05  +4.37800000E-05  -8.38000000E-05  -7.42740000E-04  -3.44640000E-04
   +2.83980000E-04  +3.69940000E-04  +1.83220000E-04  -3.83610000E-04  -1.06827000E-03
   +5.95810000E-04  -8.64490000E-04  +3.77270000E-04  +2.47100000E-05  -1.67310000E-04
   +6.97880000E-04  +6.32100000E-04  +3.87200000E-05  +3.14419000E-03  +1.76585000E-03
   -4.04676000E-03  +2.82717000E-03  -2.67744000E-03  +5.40757000E-03  +8.51490000E-04
   +7.48124000E-03  +1.03068000E-03  +1.25534010E-01  -1.50633800E-01  -7.59228000E-03
   +4.72213400E-02  -3.37952000E-02  -2.01391000E-03  -6.16021000E-03  +1.01278000E-03
   +7.47414000E-03  -1.50762270E-01  +5.17288180E-01  +4.71400000E-05  -4.80900000E-05
   +8.70300000E-05  -8.52300000E-05  -1.67310000E-04  +6.74000000E-05  +1.01180000E-04
   +9.97000000E-06  +2.16900000E-05  -5.61100000E-05  -5.55500000E-05  -2.73300000E-05
   -1.85560000E-04  -4.20300000E-05  +1.26020000E-04  +1.19670000E-04  +6.85900000E-05
   -1.19670000E-04  -5.89080000E-04  -2.56060000E-04  -1.62320000E-04  +8.05600000E-05
   +4.16100000E-05  -7.24200000E-05  +1.45340000E-04  +1.26550000E-04  +1.11600000E-05
   -1.60100000E-03  -4.17544000E-03  +3.01292000E-03  +6.24120000E-04  +9.65512000E-03
   -3.02210000E-04  +3.32131800E-02  -1.89543000E-02  +5.97060000E-04  +3.84690100E-02
   +1.83136500E-02  -8.40388500E-02  -2.40476400E-02  +1.74907700E-02  +1.13128000E-02
   +7.15906000E-03  +3.97607000E-03  -2.71862000E-03  -8.78633000E-02  -2.61560960E-01
   +2.83423310E-01  -4.67426000E-03  -2.66422000E-03  +4.71890000E-04  -3.46068000E-03
   -1.18203500E-02  -2.72116200E-02  -2.40508000E-03  -9.72870000E-04  -9.53540000E-04
   +2.92590000E-04  -6.02200000E-05  -6.89160000E-04  +5.24560000E-04  +4.70300000E-05
   -3.07830000E-04  +1.29500000E-05  -1.07865000E-03  -9.40250000E-04  -7.62683900E-02
   -1.75727000E-03  -4.07979000E-03  +4.18030000E-04  +2.56600000E-05  -3.15853000E-03
   -4.81990000E-04  -3.88330000E-04  -8.29000000E-06  -1.73082000E-03  +1.18513100E-02
   +2.65262600E-02  -4.52450000E-04  +8.83200000E-04  +1.03885000E-03  -1.23180000E-04
   -6.65460000E-04  +4.35500000E-05  +6.08670000E-04  -8.52030000E-04  +3.14680000E-04
   -1.49866000E-03  +2.15300000E-05  -1.02810000E-03  -8.97420000E-04  +2.11809000E-03
   -4.17310000E-04  -1.21019000E-03  +9.71060000E-04  +1.23090000E-04  +5.84978290E-01
   -3.10065000E-03  -7.25820000E-04  +1.87210000E-04  -5.74080000E-03  -1.03560900E-02
   -1.96265400E-02  -6.69170000E-04  -1.09838000E-03  +1.74660000E-04  +4.51620000E-04
   -3.51190000E-04  -7.52400000E-04  -1.05310000E-04  +2.55500000E-05  -1.84600000E-04
   -5.93000000E-06  -4.98470000E-04  -6.71350000E-04  -4.85006000E-03  -8.90073200E-02
   -3.59030400E-02  +1.86489000E-03  +7.84129000E-03  +2.58899600E-02  -5.75100000E-05
   -7.64600000E-05  -1.29400000E-05  +5.02692000E-03  -1.17228900E-02  -2.03855200E-02
   +8.03710000E-04  -5.13550000E-04  -1.22707000E-03  -1.60690000E-04  +6.68770000E-04
   +1.53860000E-04  -2.06330000E-04  +6.61920000E-04  -4.55790000E-04  +8.43830000E-04
   -3.60210000E-04  +7.88220000E-04  -1.04583000E-03  -1.29094000E-03  +5.08720000E-04
   +5.90660000E-04  -5.23860000E-04  -9.45000000E-06  -4.38028000E-03  +5.66456970E-01
   +8.65160000E-04  +8.93550000E-04  +6.85820000E-04  -6.10391000E-03  -4.46528000E-03
   -3.84704000E-03  +1.48414000E-03  +8.02090000E-04  +1.42520000E-04  +8.78200000E-05
   -2.65970000E-04  -5.35960000E-04  -4.29260000E-04  +5.56000000E-05  +6.88820000E-04
   +5.06720000E-04  +3.93010000E-04  -2.21360000E-04  -9.42037000E-03  -3.31177800E-02
   -1.57667680E-01  -2.67849000E-03  -3.09184000E-03  -3.50528100E-02  +2.84340000E-04
   +1.94110000E-04  -6.30300000E-05  +8.90521000E-03  -1.01090400E-02  -1.02871500E-02
   -1.49728000E-03  +8.82840000E-04  -1.05670000E-04  +1.74970000E-04  +3.45520000E-04
   -1.61820000E-04  +1.87020000E-04  -5.95200000E-05  +1.24780000E-04  +1.84990000E-04
   +1.61650000E-04  +1.43670000E-04  -1.10600000E-03  -1.51680000E-04  +1.40280000E-04
   -3.34030000E-04  +2.47380000E-04  -9.91000000E-06  -1.26980100E-02  -5.03704300E-02
   +4.86501500E-01  -3.88633000E-03  -1.52369400E-02  +2.74306400E-02  -2.30502000E-03
   -4.01858000E-03  -1.21284100E-02  -1.92305000E-03  -7.30320000E-04  +8.74700000E-05
   +8.44780000E-04  -3.32039000E-03  -5.47668000E-03  -4.47818000E-03  +3.93846000E-03
   +1.15043500E-02  +1.04712300E-02  +1.00126100E-02  -5.47505000E-03  +5.30220000E-04
   -2.87970000E-04  +1.63080000E-04  -2.56774000E-03  -1.44476000E-03  +1.16841000E-03
   +2.61850000E-04  -8.83090000E-04  -1.03305000E-03  +1.60500000E-04  +3.09060000E-04
   -1.74760000E-04  +7.54500000E-05  -1.89790000E-04  +1.30900000E-04  -1.61090000E-04
   +1.38780000E-04  +8.53600000E-05  +1.88710000E-04  +1.75000000E-06  -1.18760000E-04
   +1.32650000E-04  -5.50800000E-05  -1.09930000E-04  -6.81700000E-05  -9.76200000E-05
   +1.38920000E-04  -1.47840000E-04  +1.08420000E-04  +5.68000000E-06  +1.53510000E-04
   +2.99830000E-04  -1.73630000E-04  +3.30853100E-01  -5.25520000E-03  +2.13708500E-02
   -3.34949500E-02  -7.01990000E-04  +6.31292000E-03  +2.16822400E-02  +9.97533000E-03
   +4.52777000E-03  -4.49321000E-03  -5.40187000E-03  -3.83474000E-03  +4.66400000E-05
   +4.39589000E-03  -1.17618000E-03  -2.19842000E-03  -1.20087200E-02  -2.38936500E-02
   +1.09873400E-02  -1.09114000E-03  -1.34531000E-03  +5.05740000E-04  -1.96327000E-03
   -1.00576000E-03  -3.67780000E-04  -1.69345000E-03  -6.20960000E-04  -4.99970000E-04
   +7.79100000E-05  +6.15400000E-05  -1.90150000E-04  -2.78220000E-04  -7.64600000E-05
   +7.16900000E-05  +7.68600000E-05  +2.53800000E-05  -9.24200000E-05  +1.26540000E-04
   -1.97190000E-04  +5.66200000E-05  -2.77100000E-05  +1.85780000E-04  -7.03300000E-05
   +9.45500000E-05  -1.39960000E-04  -3.02100000E-05  -1.76080000E-04  +1.71710000E-04
   +1.80300000E-05  +3.72800000E-05  +2.25870000E-04  -2.27660000E-04  -1.05040860E-01
   +4.86967600E-02  +1.78960100E-02  -3.75163100E-02  +3.68221300E-02  -4.67557000E-03
   -4.65218000E-03  -2.96952800E-02  -6.57102000E-03  -2.18891000E-03  +1.41957000E-03
   +1.81310000E-03  -2.02994000E-03  -5.59322000E-03  -8.12663000E-03  +5.54494000E-03
   +1.33978400E-02  +1.75932000E-02  +2.64849400E-02  -1.36793900E-02  +1.35218000E-03
   +3.04260000E-04  +2.65410000E-04  -6.22200000E-04  -1.12253000E-03  +9.48270000E-04
   +1.15046000E-03  -5.81860000E-04  -5.53030000E-04  +5.57650000E-04  +4.08410000E-04
   -5.35900000E-05  +3.83940000E-04  +1.17940000E-04  +1.24280000E-04  -2.96990000E-04
   +2.72680000E-04  +1.91300000E-04  -5.53000000E-05  +3.45780000E-04  -2.61680000E-04
   +2.13510000E-04  -2.96750000E-04  +1.69500000E-05  -3.57390000E-04  +6.07700000E-05
   +4.26220000E-04  +1.59280000E-04  -1.38210000E-04  -6.28000000E-06  +2.57360000E-04
   +1.27270000E-04  -1.66620000E-04  -2.43509390E-01  +8.00037000E-02  +1.83726820E-01
   -1.29100000E-05  -3.67700000E-05  +9.88100000E-05  -3.33100000E-05  -6.97600000E-05
   -3.47900000E-05  +9.23000000E-06  -2.74000000E-06  +1.85400000E-05  -1.27000000E-06
   -7.55000000E-06  +6.62000000E-06  -1.36020000E-04  -6.30200000E-05  +4.25900000E-05
   +8.47300000E-05  +8.53000000E-06  -4.69300000E-05  -1.76790000E-04  -5.30800000E-05
   +8.86700000E-05  +7.26400000E-05  -1.32200000E-05  -2.67700000E-05  +1.21770000E-04
   +8.58400000E-05  +7.86000000E-06  -2.84900000E-05  -5.32150000E-04  +5.13930000E-04
   -6.43740000E-04  +2.49640000E-04  -1.83170000E-04  +1.47970000E-03  +7.14230000E-04
   -2.15617000E-03  -4.58573000E-03  +3.55630700E-02  -2.53170600E-02  -4.96339000E-03
   +3.15547000E-03  +2.56596000E-03  +1.48520000E-03  +1.09197000E-03  -6.24060000E-04
   -3.53120100E-02  -2.06102900E-02  +3.75086200E-02  +5.15600000E-05  +6.90000000E-06
   -1.38000000E-05  +2.12200000E-05  +1.05500000E-05  -2.31000000E-05  +4.36674800E-02
   -2.33100000E-05  +3.44900000E-05  -1.12270000E-04  +3.89200000E-05  +1.72250000E-04
   +1.38600000E-05  -6.33200000E-05  -2.51600000E-05  -1.04400000E-05  +1.52700000E-05
   +6.13000000E-06  +1.66200000E-05  +1.66930000E-04  +7.79200000E-05  -6.47700000E-05
   -7.93800000E-05  -4.19100000E-05  +8.63200000E-05  +1.98480000E-04  -9.98100000E-05
   +5.48000000E-06  -7.16300000E-05  -7.26000000E-06  +1.87500000E-05  -1.48340000E-04
   -1.42090000E-04  -7.76000000E-06  -6.57800000E-05  +6.02150000E-04  -3.91340000E-04
   -2.49400000E-05  -1.09425000E-03  +3.36140000E-04  -4.12196000E-03  +4.14848000E-03
   -8.79470000E-04  +7.43170000E-04  -2.62074200E-02  +1.69745600E-02  +4.29573000E-03
   +4.07020000E-04  -1.73928000E-03  -2.90850000E-04  -2.60180000E-04  +1.67353000E-03
   +1.70179800E-02  -3.41380420E-01  +2.40762370E-01  -1.07400000E-04  +4.89400000E-05
   -2.91000000E-05  -2.19300000E-05  -3.26600000E-05  +2.06900000E-05  -1.82708000E-02
   +3.63601330E-01  -1.53400000E-05  +1.01500000E-05  +2.76000000E-05  +1.32400000E-05
   -2.81300000E-05  -1.47700000E-05  -2.14900000E-05  +3.30000000E-06  +2.60000000E-07
   +1.83100000E-05  +2.68300000E-05  +4.17000000E-06  +3.22000000E-06  -1.74000000E-05
   -2.08800000E-05  +1.07000000E-06  -1.69100000E-05  +1.91000000E-05  -7.43000000E-05
   +6.50100000E-05  -1.31380000E-04  -1.02000000E-06  +5.21000000E-06  -1.33300000E-05
   +9.77000000E-06  +5.78000000E-06  -4.77000000E-06  +1.53760000E-04  +1.77000000E-06
   +5.01600000E-05  +1.01700000E-05  +1.50730000E-04  -7.73380000E-04  +1.43982000E-03
   -4.22928000E-03  +1.23705000E-03  +7.53170000E-04  -7.35466000E-03  +2.21783000E-03
   +1.72045000E-03  -9.27350000E-04  +1.59449000E-03  +3.82790000E-04  +7.28750000E-04
   +9.28620000E-04  +9.33314000E-03  +2.67031380E-01  -2.09573420E-01  +9.69800000E-05
   -7.35100000E-05  +2.85000000E-05  +7.26000000E-06  -3.27000000E-06  -1.37900000E-05
   -1.37841600E-02  -2.55944670E-01  +2.05074030E-01  -3.08300000E-05  +8.70000000E-07
   -9.30000000E-06  +1.63550000E-04  +8.50900000E-05  -2.80100000E-05  -7.12700000E-05
   -3.78200000E-05  +7.50000000E-06  +1.31000000E-05  +3.37000000E-06  +3.02700000E-05
   +6.68800000E-05  +2.64600000E-05  -3.49100000E-05  -7.30000000E-06  -4.72100000E-05
   +4.34600000E-05  +5.17880000E-04  +8.65420000E-04  -7.33690000E-04  -3.78460000E-04
   +1.04550000E-04  +1.37660000E-04  -6.30700000E-05  -7.82600000E-05  +2.79000000E-06
   -2.04488000E-03  +4.30391000E-03  +3.42134000E-03  +1.88076000E-03  +2.16351000E-02
   -1.54779700E-02  -5.65326900E-02  +2.82208100E-02  -4.67232000E-03  +5.65879000E-03
   -1.74384000E-02  +1.16883000E-02  -1.56880000E-03  -4.64000000E-05  +4.90217000E-03
   -1.55751000E-03  +1.56090000E-04  +3.28200000E-04  +1.58186000E-03  -2.47544000E-03
   -1.91933000E-03  +2.74000000E-06  -4.39000000E-05  -1.30970000E-04  -1.56800000E-05
   -2.31900000E-05  -1.12500000E-05  -6.64080000E-04  +1.02355000E-03  +7.40500000E-05
   +5.32588500E-02  -1.26700000E-05  +2.59000000E-06  +6.09000000E-05  -1.96480000E-04
   -1.65790000E-04  -2.08600000E-05  +4.85600000E-05  +4.75800000E-05  -2.47000000E-06
   -6.01000000E-06  +9.40000000E-07  -1.86900000E-05  -9.66200000E-05  -4.77100000E-05
   +3.87000000E-05  +5.32700000E-05  +1.91100000E-05  -3.45100000E-05  -2.52630000E-04
   -3.14910000E-04  +8.02540000E-04  +3.00270000E-04  -1.25260000E-04  -1.70400000E-04
   +9.34300000E-05  +8.38500000E-05  +9.90000000E-07  +4.72043000E-03  +1.95106000E-03
   +7.67680000E-04  -4.58210000E-04  -1.17373700E-02  +1.07829500E-02  +2.83903300E-02
   -2.43266420E-01  +1.34786890E-01  +6.09704000E-03  -5.69891000E-03  +2.94534000E-03
   -4.93640000E-04  +2.50371000E-03  +2.49197000E-03  -1.91440000E-04  +2.06500000E-04
   -6.77460000E-04  -1.97537000E-03  +1.58100000E-03  -2.63083000E-03  +7.15900000E-05
   -1.09300000E-05  +2.16700000E-05  +2.44200000E-05  +2.35400000E-05  -1.07600000E-05
   -1.13143000E-03  +2.25900000E-05  +1.17999000E-03  -3.36883200E-02  +2.56253370E-01
   -4.68600000E-05  +4.09900000E-05  -1.52600000E-05  -7.79300000E-05  -4.70000000E-07
   -4.50000000E-06  -3.35000000E-05  +1.37300000E-05  -2.51600000E-05  +1.60100000E-05
   +1.67500000E-05  +1.09700000E-05  +5.06500000E-05  +9.20000000E-06  -2.38700000E-05
   +2.38000000E-06  -4.47300000E-05  +5.18600000E-05  +2.95140000E-04  -9.82000000E-06
   +3.15230000E-04  +9.43000000E-06  -6.55100000E-05  -3.92900000E-05  -3.88600000E-05
   -4.71800000E-05  -4.76000000E-06  +2.97861000E-03  +1.35948000E-03  +4.43371000E-03
   +8.69760000E-04  -4.67802000E-03  +5.32560000E-03  -4.95919000E-03  +1.34796030E-01
   -1.28816940E-01  -5.45413000E-03  +1.92746500E-02  -6.35599000E-03  +5.24160000E-03
   +2.14560000E-03  +2.18150000E-04  +4.78590000E-04  -9.12730000E-04  -5.51580000E-04
   -2.36134000E-03  -2.26293000E-03  -5.67690000E-04  -2.75700000E-05  +8.71000000E-06
   -4.99700000E-05  +6.30000000E-07  -1.04200000E-05  -2.70000000E-06  +1.66645000E-03
   -3.05390000E-04  -3.45560000E-04  +3.91105000E-03  -1.48094750E-01  +1.29205710E-01
   -1.85470000E-04  +5.00300000E-05  -8.23000000E-05  -5.88800000E-04  +6.84490000E-04
   -3.96070000E-04  -2.10760000E-04  +9.10100000E-05  -3.73000000E-05  -1.17270000E-04
   -1.19390000E-04  +9.39000000E-06  -2.35640000E-04  -9.15400000E-05  +1.59840000E-04
   +2.53610000E-04  +8.79500000E-05  -7.64200000E-05  -9.52340000E-04  -4.47040000E-04
   -1.02252000E-03  -1.56000000E-06  -1.25380000E-04  -1.33080000E-04  +1.59080000E-04
   +1.45110000E-04  +5.50000000E-07  +6.05004000E-03  +1.13950000E-03  -2.16473000E-03
   -1.86933110E-01  -4.86701000E-02  +1.34757200E-01  -1.31891300E-02  -8.46046000E-03
   +1.78555300E-02  -4.26030000E-04  +5.26455000E-03  +1.78013000E-03  -3.17980000E-04
   +3.34450000E-04  -8.75060000E-04  +2.37817000E-03  +2.23877000E-03  +1.09295000E-03
   -1.34131000E-03  -1.35620000E-04  +9.59260000E-04  -7.72800000E-05  +1.86670000E-04
   +1.72510000E-04  -6.12000000E-06  -2.10700000E-05  -4.23000000E-06  +1.20040000E-04
   -2.34800000E-04  +7.71500000E-05  -3.16090000E-04  -1.14994000E-03  -1.93520000E-03
   +1.95527710E-01  +7.26400000E-05  +1.44450000E-04  +3.56380000E-04  +3.93100000E-04
   -5.73600000E-05  +4.44700000E-05  -7.41800000E-05  -5.78400000E-05  +3.07400000E-05
   +1.82380000E-04  +2.18330000E-04  +8.07300000E-05  +2.71090000E-04  -2.56900000E-05
   -2.97600000E-04  -1.80190000E-04  -2.40610000E-04  +1.54560000E-04  -1.52438000E-03
   -2.58600000E-04  -9.19690000E-04  -6.98000000E-05  -8.70000000E-07  -1.16990000E-04
   -1.70230000E-04  -1.56500000E-04  -1.92000000E-06  -1.94980200E-02  -1.39369000E-03
   +1.72083400E-02  -4.88987900E-02  -7.68881800E-02  +6.03180700E-02  +1.39445200E-02
   +8.46464000E-03  -1.27684000E-02  +4.89931000E-03  +2.02440000E-04  +2.28788000E-03
   +4.32810000E-04  -9.87210000E-04  -4.40560000E-04  +2.76336000E-03  -2.78594000E-03
   +4.94000000E-03  +8.11570000E-04  +1.67600000E-04  -7.45710000E-04  +1.36980000E-04
   -6.81470000E-04  +3.48520000E-04  -7.52000000E-06  +8.81400000E-05  -1.22820000E-04
   -7.09400000E-05  +1.15550000E-04  -6.00500000E-05  -1.55815000E-03  -5.32160000E-04
   -1.81555000E-03  +4.89693500E-02  +7.54048400E-02  +1.34890000E-04  -3.65280000E-04
   +2.40100000E-04  -2.62810000E-04  +2.33210000E-04  +5.97900000E-05  -5.90300000E-05
   -2.96080000E-04  +1.74480000E-04  -1.77290000E-04  -1.21200000E-04  -4.48200000E-05
   -3.85030000E-04  -5.32000000E-06  +2.95710000E-04  +1.99870000E-04  +8.79600000E-05
   -2.46230000E-04  -2.60160000E-04  -1.72432000E-03  -1.75275000E-03  -2.26480000E-04
   -1.56200000E-05  -2.72400000E-05  +2.19670000E-04  +1.44190000E-04  -1.13000000E-06
   +1.26985300E-02  +3.57979000E-03  -6.94330000E-03  +1.34359780E-01  +5.96524900E-02
   -1.72674800E-01  +1.86006000E-03  +2.49804000E-03  +8.54610000E-04  +2.12878000E-03
   +1.96943000E-03  +5.17123000E-03  -1.01374000E-03  -3.24430000E-04  -3.03180000E-04
   +9.78080000E-04  +5.42163000E-03  +1.96271000E-03  +3.62920000E-04  -1.05980000E-04
   -2.17160000E-04  +5.66400000E-05  -1.65000000E-04  -3.86900000E-05  -1.13670000E-04
   +4.68000000E-06  -2.01410000E-04  -6.35800000E-05  +6.47300000E-05  -3.91800000E-05
   -1.72770000E-03  -2.12596000E-03  -1.83481000E-03  -1.49414890E-01  -6.77309200E-02
   +1.76546350E-01  -5.24000000E-05  +9.66300000E-05  +3.06000000E-06  -2.59260000E-04
   +1.23810000E-04  -1.80400000E-05  +2.69800000E-05  +3.83900000E-05  -3.69000000E-05
   +3.64300000E-05  +2.03700000E-05  +3.74100000E-05  -3.68100000E-05  -9.45800000E-05
   -7.01300000E-05  -3.53800000E-05  -5.34100000E-05  -6.84000000E-06  -1.85800000E-05
   -1.18382000E-03  -1.71232000E-03  -1.47042000E-03  +6.78900000E-04  +1.10589000E-03
   +8.60900000E-05  +8.56900000E-05  +7.98000000E-06  +7.67849000E-03  -1.75515700E-02
   +1.10297500E-02  -1.57532000E-03  +1.83530000E-04  +5.52022000E-03  -1.30512000E-03
   +9.58000000E-06  +1.42320000E-04  -1.60993000E-03  +4.25535000E-03  +3.53355000E-03
   +1.23696000E-03  +2.20320700E-02  -1.45452400E-02  -5.67245300E-02  +2.61397500E-02
   -7.72211000E-03  -2.39800000E-05  +1.12420000E-03  -7.98170000E-04  +3.83780000E-04
   +2.69300000E-05  -1.26660000E-04  +1.69640000E-04  +1.10450000E-04  +9.41600000E-05
   -3.38240000E-04  +1.96990000E-04  -4.72100000E-05  -1.16730000E-04  -1.88960000E-04
   -2.80530000E-04  +2.27070000E-04  -1.05810000E-03  +6.72070000E-04  +5.62961300E-02
   -1.44310000E-04  +1.00960000E-04  +9.71000000E-06  -2.00280000E-04  +3.13680000E-04
   +3.24560000E-04  -1.11060000E-04  -7.29600000E-05  -6.89400000E-05  +2.31000000E-05
   +2.19400000E-05  +4.85900000E-05  +6.23900000E-05  -1.62400000E-05  -8.67900000E-05
   -3.73600000E-05  -8.39200000E-05  +1.58600000E-05  -4.35390000E-04  -1.97494000E-03
   -1.12653000E-03  +2.36218000E-03  -5.42850000E-04  -6.98810000E-04  -2.27100000E-05
   -1.56200000E-05  -9.21000000E-06  +1.25712000E-03  -2.72804000E-03  +4.57367000E-03
   +1.78150000E-04  +2.55229000E-03  +2.99027000E-03  -1.06490000E-04  +1.71320000E-04
   -8.81700000E-04  +4.32989000E-03  +2.23981000E-03  +1.36455000E-03  +3.58870000E-04
   -1.08140000E-02  +1.09346500E-02  +2.56817800E-02  -2.46501090E-01  +1.38681560E-01
   +1.96280000E-04  -9.05920000E-04  +5.77540000E-04  +2.89500000E-04  -1.86680000E-04
   -1.20230000E-04  +4.90500000E-05  -2.15900000E-05  -1.25000000E-06  +1.14680000E-04
   -1.60000000E-04  -1.05660000E-04  -1.56870000E-04  -2.66450000E-04  -2.34730000E-04
   +1.64580000E-04  -2.32450000E-04  +8.98100000E-05  -3.44256900E-02  +2.60725300E-01
   -7.10000000E-05  +3.30400000E-05  +7.69500000E-05  -2.25750000E-04  +1.76270000E-04
   +2.45750000E-04  -1.32930000E-04  -1.00350000E-04  -3.08800000E-05  +1.82200000E-05
   +1.20800000E-05  +3.00900000E-05  +4.49100000E-05  +2.36000000E-05  -3.67400000E-05
   +2.37000000E-06  -4.18700000E-05  +1.93600000E-05  -2.40565000E-03  -4.84780000E-04
   -1.78222000E-03  -2.17580000E-04  +7.20540000E-04  +5.39180000E-04  -4.40700000E-05
   -4.65800000E-05  -9.06000000E-06  -3.34277000E-03  +1.76766100E-02  -6.57193000E-03
   +5.52963000E-03  +2.75612000E-03  +7.30400000E-04  +2.04740000E-04  -9.44710000E-04
   -5.34740000E-04  +3.50224000E-03  +1.36911000E-03  +4.50854000E-03  +1.77072000E-03
   -4.26186000E-03  +6.04418000E-03  -7.31767000E-03  +1.38862890E-01  -1.39425850E-01
   -1.11750000E-04  -7.60100000E-05  +1.72260000E-04  +6.40140000E-04  -2.32470000E-04
   -7.71700000E-05  -4.05200000E-05  -7.68800000E-05  -8.23400000E-05  +1.53300000E-05
   -1.64520000E-04  -8.46800000E-05  -3.04240000E-04  -2.00170000E-04  -3.52700000E-04
   -2.05030000E-04  +9.24420000E-04  -5.13390000E-04  +5.17650000E-03  -1.52771770E-01
   +1.38933350E-01  -4.38500000E-05  +1.77700000E-05  -3.30000000E-05  +2.86500000E-05
   +2.31660000E-04  +1.05940000E-04  -7.79300000E-05  -7.13200000E-05  -2.51400000E-05
   +1.31700000E-05  +1.66600000E-05  +3.12000000E-05  +7.56900000E-05  +9.14000000E-06
   -6.39200000E-05  -5.66100000E-05  -4.77500000E-05  +4.24300000E-05  -1.22260000E-04
   -6.23110000E-04  +7.49170000E-04  -2.35000000E-05  -1.20490000E-04  +2.85000000E-06
   -5.78600000E-05  -4.85600000E-05  -5.91000000E-06  -9.34900000E-04  +5.10188000E-03
   +1.87515000E-03  -3.02620000E-04  +3.96280000E-04  -8.62370000E-04  +2.03246000E-03
   +2.16702000E-03  +9.58600000E-04  +5.30109000E-03  +2.95727000E-03  -2.17437000E-03
   -1.89347190E-01  -4.51005500E-02  +1.41464940E-01  -1.22410900E-02  -8.48667000E-03
   +1.67164300E-02  -1.27050000E-04  -1.43543000E-03  -1.35183000E-03  -2.29120000E-04
   +1.15600000E-04  -5.35200000E-05  +2.06000000E-06  -8.88000000E-06  -8.16000000E-06
   -1.14860000E-04  -2.07350000E-04  -1.58940000E-04  +2.54200000E-04  +8.36300000E-05
   -2.86520000E-04  -1.93080000E-04  -2.37380000E-04  -1.87520000E-04  -3.91080000E-04
   -1.22745000E-03  -1.94207000E-03  +1.96509710E-01  +2.26600000E-05  -2.17900000E-05
   +6.58100000E-05  +1.40220000E-04  -2.14980000E-04  -7.98500000E-05  +2.38200000E-05
   +3.06200000E-05  +5.24000000E-06  -2.30000000E-07  +2.40200000E-05  -2.23600000E-05
   -2.68400000E-05  -7.14000000E-06  +1.55800000E-05  +7.34000000E-06  +2.37700000E-05
   -2.08000000E-05  +5.00210000E-04  +4.93890000E-04  -3.72450000E-04  -8.67600000E-05
   +5.97500000E-05  -4.79700000E-05  +2.75700000E-05  +1.94300000E-05  +2.60000000E-07
   +4.78944000E-03  +2.37800000E-04  +1.80840000E-03  +6.28780000E-04  -1.27158000E-03
   -2.97830000E-04  +2.58758000E-03  -2.72366000E-03  +4.46956000E-03  -1.98971100E-02
   -7.81670000E-04  +1.85195400E-02  -4.39372900E-02  -7.23370900E-02  +5.85180900E-02
   +1.29631100E-02  +8.56979000E-03  -1.35874500E-02  -1.20890000E-03  +6.93990000E-04
   -2.35878000E-03  +7.36900000E-05  +1.29300000E-05  +5.32000000E-05  -1.27400000E-05
   -8.48000000E-06  -1.90200000E-05  -1.32520000E-04  +1.57920000E-04  -4.45430000E-04
   -9.78310000E-04  -3.34580000E-04  +8.56280000E-04  -2.09950000E-04  -1.27400000E-04
   -2.84150000E-04  -1.63794000E-03  -5.65770000E-04  -1.81042000E-03  +4.63640900E-02
   +6.80974900E-02  +1.27100000E-05  -1.81200000E-05  +5.78500000E-05  +1.16900000E-04
   -1.18780000E-04  -3.95400000E-05  +1.22800000E-05  +3.75000000E-06  +1.19400000E-05
   +2.73000000E-06  +1.87500000E-05  -7.13000000E-06  -4.12500000E-05  -2.35600000E-05
   +7.94000000E-06  +1.19500000E-05  +8.42000000E-06  -2.55100000E-05  +3.25900000E-05
   +2.21910000E-04  +1.61560000E-04  -1.70000000E-05  -2.36200000E-05  -7.23900000E-05
   +4.41600000E-05  +3.29100000E-05  +2.38000000E-06  +1.91445000E-03  +1.53157000E-03
   +4.66611000E-03  -1.11313000E-03  -3.64500000E-05  -2.91670000E-04  +6.45570000E-04
   +4.79377000E-03  +1.64698000E-03  +1.49390500E-02  +2.37265000E-03  -6.88616000E-03
   +1.40620950E-01  +5.95021800E-02  -1.78439430E-01  +7.69450000E-04  +1.39912000E-03
   +9.55330000E-04  -1.52917000E-03  -2.18049000E-03  -8.94150000E-04  +1.26200000E-05
   +6.62800000E-05  +2.59500000E-05  +6.60000000E-07  +1.90000000E-06  -1.66800000E-05
   -2.13850000E-04  -3.92980000E-04  -1.12010000E-04  +5.19480000E-04  +1.37690000E-04
   -5.24370000E-04  -1.89930000E-04  -2.60310000E-04  -3.82600000E-04  -1.63970000E-03
   -2.11825000E-03  -1.74582000E-03  -1.54911490E-01  -6.49794400E-02  +1.81903240E-01
   -3.74800000E-05  +9.64600000E-05  +1.37500000E-04  +6.84100000E-04  +7.82800000E-05
   -9.53300000E-05  -1.34580000E-04  +3.21000000E-06  +3.92750000E-04  +1.66300000E-04
   -1.84400000E-05  -2.03940000E-04  +1.49490000E-04  +1.97400000E-05  -1.63340000E-04
   -1.42780000E-04  -1.70540000E-04  -6.04000000E-06  -2.81084000E-03  -7.61880000E-04
   +8.41710000E-04  -1.41320000E-04  +6.34000000E-05  +5.26620000E-04  -1.50430000E-04
   -1.50080000E-04  -4.18300000E-05  +7.81450000E-04  +1.25321000E-03  +3.60160000E-04
   +3.15420000E-04  -2.30530000E-04  +1.29290000E-04  -1.84020000E-04  -2.50000000E-05
   -2.04400000E-05  +6.10000000E-07  +6.54200000E-05  -1.09500000E-04  +6.56500000E-05
   -4.93100000E-05  -8.85800000E-05  +2.58030000E-04  -1.94050000E-04  +6.43200000E-05
   +3.53100000E-05  -2.91000000E-06  +2.17400000E-05  -2.44636080E-01  -1.20562160E-01
   -1.25018300E-02  +6.92900000E-05  +6.81600000E-05  +2.33900000E-05  -9.60000000E-06
   -1.62000000E-06  -3.09000000E-06  -1.24000000E-06  -1.06200000E-05  -3.30000000E-06
   +3.53900000E-05  +6.06900000E-05  +2.95000000E-05  +2.55800000E-05  -1.13100000E-05
   -1.26700000E-05  +2.07500000E-05  -1.50300000E-05  -1.04000000E-06  +2.62447010E-01
   -8.95080000E-04  -7.11300000E-05  +6.34100000E-05  +5.30730000E-04  -2.46310000E-04
   -2.75009000E-03  +5.67600000E-05  +1.94770000E-04  -2.97240000E-04  +4.94700000E-05
   +2.81760000E-04  +1.33740000E-04  +3.15240000E-04  +1.61300000E-05  -2.92000000E-04
   -1.22090000E-04  -2.98550000E-04  -1.02300000E-05  -1.08301200E-02  -8.63610000E-03
   -1.04423000E-03  +6.46180000E-04  +2.44330000E-04  +1.04566000E-03  -1.87390000E-04
   -1.42160000E-04  +1.99900000E-05  -9.51770000E-04  +4.26210000E-04  +2.16530000E-04
   +3.36700000E-05  -4.02280000E-04  +5.15350000E-04  +6.36100000E-05  +2.39500000E-05
   +2.19100000E-05  +1.60920000E-04  -1.37490000E-04  -6.12500000E-05  +7.27100000E-05
   +3.69900000E-05  -8.24200000E-05  +3.47380000E-04  +8.02200000E-05  -9.47100000E-05
   -1.55000000E-04  +1.48710000E-04  +2.88700000E-05  -1.19292310E-01  -1.19572220E-01
   -6.51617000E-03  +3.91700000E-05  +9.39500000E-05  +1.14600000E-05  +3.95000000E-06
   -3.44800000E-05  -3.17000000E-06  -1.79500000E-05  -7.63000000E-06  -1.67700000E-05
   -5.29100000E-05  +1.40590000E-04  -1.39700000E-04  -3.66800000E-05  -2.29000000E-06
   -2.38700000E-05  -4.75000000E-06  -6.92000000E-06  -3.33000000E-06  +1.31343550E-01
   +1.27612280E-01  -1.65710000E-03  -9.95920000E-04  +4.70300000E-05  +9.98260000E-04
   -1.29126000E-03  -5.61377000E-03  +8.82120000E-04  -8.62300000E-05  -6.21050000E-04
   -1.44090000E-04  +2.53200000E-05  +3.36330000E-04  +1.89610000E-04  +9.64500000E-05
   -1.60660000E-04  +1.12500000E-05  -3.04630000E-04  -3.13470000E-04  -2.59244400E-02
   -1.62984900E-02  -3.85858000E-03  -1.02084000E-03  -1.09703000E-03  +1.35657000E-03
   -1.45500000E-04  -7.39000000E-05  +5.02400000E-05  -1.12351000E-03  +2.76510000E-04
   +8.27050000E-04  +4.12410000E-04  -8.13800000E-05  -2.25200000E-05  -3.86090000E-04
   -2.75100000E-05  +1.31890000E-04  +2.04470000E-04  +2.82300000E-05  -2.20940000E-04
   +1.68920000E-04  -9.26700000E-05  -7.54100000E-05  +9.37000000E-06  +1.48730000E-04
   +1.71570000E-04  -2.19230000E-04  +1.64750000E-04  +4.91100000E-05  -1.03471100E-02
   -5.38994000E-03  -4.63729700E-02  +1.09710000E-04  +3.38800000E-05  +1.45730000E-04
   +1.76100000E-05  -2.51300000E-05  +1.32400000E-05  +9.01000000E-06  +1.68700000E-05
   -4.60000000E-07  +3.27100000E-05  +1.34500000E-05  +4.14200000E-05  +1.24800000E-05
   +1.05600000E-05  -9.08900000E-05  -5.81000000E-06  -1.07800000E-05  +5.84000000E-06
   +1.26351700E-02  +9.68863000E-03  +5.33077400E-02  +1.20700000E-04  +1.25660000E-04
   +9.80300000E-05  -4.35900000E-05  -1.97930000E-04  +2.80620000E-04  -7.67410000E-04
   -1.04553000E-03  +3.45780000E-04  +9.76600000E-05  -1.45770000E-04  -2.98320000E-04
   -1.98350000E-04  +1.06600000E-05  +1.04620000E-04  +9.06700000E-05  +5.61000000E-05
   -3.68800000E-05  +1.82279000E-03  -2.31523000E-03  -9.99810000E-04  +3.39820000E-04
   -2.85490000E-04  -3.37110000E-04  +7.79300000E-05  +3.33200000E-05  -3.67200000E-05
   +5.08130000E-04  +4.66130000E-04  +3.14330000E-04  +2.71080000E-04  -3.69650000E-04
   +3.55280000E-04  -1.63270000E-04  -2.61900000E-05  +7.42000000E-05  +2.74300000E-04
   -1.79630000E-04  -8.00100000E-05  -3.43400000E-05  +1.09930000E-04  -6.05100000E-05
   +6.02990000E-04  +1.48660000E-04  -1.88160000E-04  -2.94410000E-04  +2.21450000E-04
   +5.24300000E-05  -2.01103560E-01  +1.25442440E-01  +3.81623900E-02  -1.71100000E-05
   -2.65900000E-05  -7.24500000E-05  +2.51800000E-05  -4.47800000E-05  +7.02000000E-06
   -2.65900000E-05  +1.67500000E-05  -1.51600000E-05  -2.37400000E-05  +1.37500000E-05
   -2.59200000E-05  -4.90200000E-05  -5.84800000E-05  +4.18000000E-06  -1.66600000E-05
   +5.00000000E-07  +2.66000000E-06  -1.92826800E-02  +1.79451700E-02  +4.71421000E-03
   +2.18438560E-01  -2.21500000E-04  -1.41330000E-04  -8.95100000E-05  +6.77520000E-04
   +3.66410000E-04  +1.63480000E-04  +2.59500000E-05  -3.74780000E-04  -8.44880000E-04
   -2.41840000E-04  +1.22350000E-04  +4.10670000E-04  -2.85200000E-05  +1.01200000E-05
   +9.55200000E-05  +1.28380000E-04  +1.65590000E-04  -6.57000000E-06  +9.73575000E-03
   -8.19105000E-03  -1.16383000E-03  -1.89690000E-04  +3.85880000E-04  +1.37538000E-03
   +6.72500000E-05  +1.13690000E-04  +6.96600000E-05  -1.61810000E-04  -1.62450000E-04
   -2.79009000E-03  +2.94800000E-04  -1.52130000E-04  -2.91670000E-04  -3.58910000E-04
   +1.30970000E-04  -1.06700000E-05  -1.14710000E-04  +5.13610000E-04  -3.58520000E-04
   +5.52070000E-04  -3.84140000E-04  +1.23490000E-04  -4.68260000E-04  -4.04680000E-04
   +2.31250000E-04  +3.63560000E-04  -2.72600000E-04  -7.40000000E-07  +1.24333290E-01
   -1.49605470E-01  -3.10700700E-02  -3.69200000E-05  -4.20400000E-05  +7.44400000E-05
   -3.17400000E-05  +3.97900000E-05  -1.66700000E-05  +1.45300000E-05  -4.55000000E-05
   +7.77000000E-06  +1.21730000E-04  +2.91760000E-04  +1.58000000E-04  -3.46400000E-05
   +1.69100000E-05  -8.96300000E-05  +8.05600000E-05  -7.70000000E-07  +3.48300000E-05
   -1.31469400E-02  +1.16391700E-02  +3.66859000E-03  -1.36607250E-01  +1.59973410E-01
   -6.43100000E-05  +7.41200000E-05  -3.22990000E-04  +4.00270000E-04  +5.79470000E-04
   +8.25920000E-04  -2.25170000E-04  +2.20040000E-04  +2.85070000E-04  -1.83690000E-04
   -9.70100000E-05  -2.48600000E-05  -9.74300000E-05  -2.05900000E-05  +1.38430000E-04
   +8.07900000E-05  +7.90100000E-05  -3.13000000E-06  +2.35685500E-02  -1.76585600E-02
   -6.45352000E-03  +1.18779000E-03  -1.10616000E-03  +1.39152000E-03  +6.27600000E-05
   +5.88600000E-05  -6.60000000E-07  -1.51130000E-03  -1.40665000E-03  -5.08280000E-03
   +1.04290000E-04  +3.89760000E-04  -7.25600000E-05  +5.25100000E-04  +6.74400000E-05
   +3.50400000E-05  -4.30530000E-04  +1.67600000E-04  +1.12490000E-04  +3.27780000E-04
   +9.29300000E-05  +3.20560000E-04  +4.69990000E-04  -7.68190000E-04  +3.74600000E-05
   +5.29820000E-04  -4.37720000E-04  -9.16500000E-05  +3.74886800E-02  -2.98239700E-02
   -5.72904300E-02  +5.79100000E-05  +5.22900000E-05  +1.29130000E-04  -1.52800000E-05
   +4.91300000E-05  -4.45400000E-05  +4.38100000E-05  -4.27600000E-05  +1.41900000E-05
   -2.49330000E-04  -3.28670000E-04  -4.38900000E-05  -5.47600000E-05  -8.82400000E-05
   -1.93190000E-04  +8.90000000E-05  -3.28200000E-05  -1.05900000E-05  -1.17885000E-03
   +1.29658000E-03  -5.57980000E-04  -4.19671200E-02  +3.53449700E-02  +6.20081900E-02
   -9.83000000E-06  -1.00270000E-04  +1.75400000E-05  +3.45500000E-04  +6.13310000E-04
   -3.17780000E-04  -1.93950000E-04  -3.06010000E-04  -6.47670000E-04  -1.14860000E-04
   -1.10500000E-04  +1.74000000E-04  -1.31910000E-04  +3.58800000E-05  +1.64480000E-04
   +1.52400000E-04  +1.66870000E-04  -5.63700000E-05  -1.99711000E-03  +2.15282000E-03
   -1.77370000E-03  -1.22080000E-04  -3.75900000E-04  -6.38390000E-04  +8.63600000E-05
   +9.55600000E-05  +3.12500000E-05  +1.16000000E-05  -7.11510000E-04  +3.63380000E-04
   -1.11280000E-04  +2.17580000E-04  +1.31190000E-04  -2.55590000E-04  +4.45700000E-05
   -1.21400000E-05  -2.34400000E-05  +1.38680000E-04  -6.94100000E-05  +1.40150000E-04
   -9.50000000E-05  +3.07500000E-05  -1.68260000E-04  +7.00100000E-05  +1.04050000E-04
   +5.83200000E-05  -4.71700000E-05  -1.68100000E-05  -4.72764500E-02  +5.04732000E-03
   -4.35882000E-03  -1.76300000E-05  -5.89200000E-05  +1.49500000E-05  -1.08100000E-05
   +1.95100000E-05  +1.29200000E-05  +2.15200000E-05  +1.08000000E-05  +2.11400000E-05
   +2.25600000E-04  +3.10740000E-04  +2.15900000E-04  +1.53800000E-05  +3.34000000E-06
   -5.65900000E-05  -6.80000000E-07  -5.67000000E-06  -1.05300000E-05  +1.54670000E-03
   -1.96348700E-02  +2.00391300E-02  -1.60180000E-04  +1.70196000E-02  -1.79742800E-02
   +4.81759900E-02  +2.76600000E-04  +1.07430000E-04  +2.63300000E-05  -2.27340000E-04
   +5.26490000E-04  +3.50790000E-04  -7.35910000E-04  +2.96040000E-04  +1.12190000E-04
   +5.30000000E-06  -1.10520000E-04  -2.34630000E-04  -8.88500000E-05  -6.28500000E-05
   +1.35790000E-04  +2.63300000E-05  +2.03100000E-05  -3.78200000E-05  +3.02100000E-05
   +9.05062000E-03  -9.31430000E-03  -1.76880000E-04  -3.38270000E-04  -1.77732000E-03
   +6.69700000E-05  +2.82600000E-05  -3.22300000E-05  -9.60700000E-05  +7.41390000E-04
   +1.25180000E-04  +3.71300000E-04  -4.73280000E-04  -8.28070000E-04  -1.41950000E-04
   -6.99700000E-05  +3.14000000E-05  +8.27400000E-05  +1.54000000E-06  +5.20400000E-05
   -2.26200000E-05  +4.53700000E-05  -8.55400000E-05  +1.32600000E-05  +1.36300000E-05
   +1.31380000E-04  -1.27210000E-04  +8.63100000E-05  +1.63200000E-05  +5.36187000E-03
   -1.86189680E-01  +1.34751740E-01  +4.89200000E-05  +1.96500000E-05  +2.91500000E-05
   +1.07700000E-05  -1.13300000E-05  +1.25100000E-05  -1.67300000E-05  +3.09000000E-06
   -2.46400000E-05  +2.79700000E-04  -9.31330000E-04  -6.21350000E-04  +5.24000000E-06
   -4.51000000E-06  -3.07700000E-05  -1.33600000E-05  -2.11000000E-06  -8.10000000E-07
   +1.81144000E-03  -1.15207700E-02  +1.06435800E-02  -1.41827000E-03  -1.33084900E-02
   +1.29003300E-02  -5.00502000E-03  +2.01419250E-01  +3.95400000E-05  -4.23350000E-04
   -5.36500000E-05  +1.08943000E-03  +1.03763000E-03  +1.09049000E-03  +1.65090000E-04
   -1.46360000E-04  +1.19500000E-04  -3.02110000E-04  -3.34640000E-04  +7.71600000E-05
   -1.78070000E-04  +1.89430000E-04  +3.75770000E-04  +2.82820000E-04  +2.42140000E-04
   -1.31920000E-04  -2.62130000E-04  +2.18955700E-02  -1.92094000E-02  -2.84250000E-04
   -3.95587000E-03  -5.97031000E-03  +8.03000000E-06  -5.30000000E-06  -9.72000000E-06
   -1.48107000E-03  +9.04420000E-04  +9.33630000E-04  +2.62250000E-04  +6.80810000E-04
   -2.01750000E-04  +5.62100000E-04  -3.92740000E-04  +1.47880000E-04  -2.02830000E-04
   -4.21420000E-04  +4.08940000E-04  -4.58640000E-04  +4.17890000E-04  -1.82700000E-05
   +8.23110000E-04  -3.88500000E-05  -2.94310000E-04  -8.69200000E-05  +2.84600000E-05
   -5.27000000E-06  -3.90893000E-03  +1.32540510E-01  -1.76916160E-01  -1.68920000E-04
   -2.47980000E-04  -1.57200000E-05  +2.90500000E-05  -1.49300000E-05  -4.92000000E-06
   +3.93600000E-05  +3.70000000E-07  -1.10900000E-05  -1.73240000E-04  -9.13390000E-04
   -3.64100000E-05  -1.53300000E-04  -2.35800000E-05  +9.26400000E-05  -8.44000000E-06
   -1.47300000E-05  -2.46200000E-05  +1.90210000E-04  -2.08534000E-03  +1.50431000E-03
   -2.72500000E-04  -5.48850000E-03  +4.91288000E-03  +5.03159000E-03  -1.45156030E-01
   +1.93752270E-01  -1.99880000E-04  +1.53600000E-04  -9.19760000E-04  +3.05800000E-04
   +7.92590000E-04  +9.87730000E-04  -1.70210000E-04  -4.88000000E-05  +1.28420000E-04
   +2.34740000E-04  +3.56050000E-04  +3.16470000E-04  +2.19590000E-04  -5.50120000E-04
   -9.55320000E-04  -7.86110000E-04  -6.29880000E-04  +4.61030000E-04  -1.85946000E-03
   -4.51660000E-04  -1.69279000E-03  -4.64145300E-02  -4.91266000E-03  -1.36099500E-02
   +1.23980000E-04  +1.78470000E-04  +9.14700000E-05  +1.72940000E-04  -4.93500000E-04
   -3.37220000E-04  -7.16600000E-05  +6.71000000E-05  -1.91100000E-05  +1.41180000E-04
   -1.43540000E-04  -4.83000000E-06  -8.10900000E-05  +2.33000000E-06  +5.86900000E-05
   -1.16810000E-04  -1.04940000E-04  +2.71570000E-04  -6.34000000E-06  +5.66540000E-04
   -6.53380000E-04  +1.10950000E-04  -1.28520000E-04  +1.12400000E-05  -8.31800000E-05
   +2.91190000E-04  -1.57800000E-04  -5.81630000E-04  -2.47120000E-04  +4.42100000E-05
   -7.80000000E-06  +1.23400000E-05  -1.49000000E-06  +1.61000000E-05  -2.05700000E-05
   +8.90000000E-06  -1.43000000E-06  -6.18100000E-05  +6.89500000E-05  -1.50898000E-03
   +3.05600000E-05  -2.69760000E-04  -1.40700000E-05  +8.93000000E-06  -2.14300000E-05
   +2.85570000E-04  +1.96980000E-04  +3.01670000E-04  +1.75120000E-04  -2.59370000E-04
   -3.02780000E-04  +6.81750000E-04  -9.96500000E-05  -9.64900000E-05  +4.85276700E-02
   -5.08700000E-04  -5.73250000E-04  +8.28390000E-04  +5.33210000E-04  +1.08076000E-03
   -1.07570000E-04  -3.56310000E-04  -8.40400000E-05  +6.09800000E-05  +2.02140000E-04
   +1.76460000E-04  +1.02580000E-04  +3.52600000E-05  -1.25440000E-04  -1.98390000E-04
   -1.79700000E-05  -1.62900000E-04  -1.23150000E-04  +9.32190000E-04  +9.29901000E-03
   +2.46030600E-02  -4.26324000E-03  -7.69131700E-02  -8.43109200E-02  +1.17110000E-04
   +8.37500000E-05  +7.70000000E-07  -4.03900000E-04  +1.18486000E-03  -3.77610000E-04
   -2.16690000E-04  -1.99540000E-04  -3.88000000E-05  -1.56140000E-04  +6.66900000E-05
   +6.30400000E-05  +1.01030000E-04  +8.84900000E-05  -1.87370000E-04  +8.44200000E-05
   -2.35090000E-04  +6.57100000E-05  +5.82200000E-04  +2.48650000E-04  -1.71440000E-04
   -3.54700000E-05  -7.89000000E-06  +2.62900000E-05  +2.35670000E-04  -4.13899000E-03
   +2.95576000E-03  -1.26973000E-03  -1.14975000E-03  -8.06330000E-04  +9.79000000E-06
   -5.66000000E-06  +5.45000000E-06  +9.80000000E-07  +1.66400000E-05  +2.22300000E-05
   +1.55700000E-05  +4.80900000E-05  +3.86600000E-05  +4.51760000E-04  -1.75030000E-04
   +1.82900000E-04  +2.48600000E-05  +2.30400000E-05  +2.61100000E-05  +2.44780000E-04
   -6.23800000E-05  +2.62300000E-05  -2.69410000E-04  -1.95700000E-05  +7.07400000E-05
   +1.62630000E-04  +6.89080000E-04  +1.69841000E-03  +4.06700000E-03  +8.28026700E-02
   +1.74600000E-04  +3.21570000E-04  -3.04930000E-04  -7.32340000E-04  -5.05180000E-04
   +2.94030000E-04  +5.21870000E-04  +1.03760000E-04  -2.48600000E-04  -2.89580000E-04
   -2.69620000E-04  -1.17190000E-04  -1.94800000E-04  +1.30770000E-04  +3.50780000E-04
   +1.96790000E-04  +2.04960000E-04  -3.38800000E-05  -3.55810000E-04  -6.71072000E-03
   -1.76394800E-02  -1.08063500E-02  -8.13838800E-02  -2.96738970E-01  +1.30800000E-05
   +6.70000000E-07  -1.97000000E-06  +7.57510000E-04  -8.64970000E-04  +6.08790000E-04
   -7.23200000E-05  +4.23840000E-04  +4.49400000E-05  +1.97880000E-04  -1.68870000E-04
   -3.68400000E-05  -9.82800000E-05  -1.45840000E-04  +7.41900000E-05  -2.52490000E-04
   -2.03800000E-05  +3.03130000E-04  +5.91080000E-04  +3.11730000E-04  -1.30200000E-05
   +4.05300000E-05  -5.96900000E-05  +1.57800000E-05  -3.70400000E-05  +4.20124000E-03
   -1.94031000E-03  -2.33789000E-03  -1.95953000E-03  -9.78740000E-04  -7.13000000E-06
   +1.20000000E-06  -5.58000000E-06  -1.72500000E-05  -1.88900000E-05  -2.18000000E-05
   -9.96000000E-06  -9.62100000E-05  +3.35400000E-05  -4.07990000E-04  -2.98400000E-04
   +2.91410000E-04  -2.13000000E-06  +3.81000000E-05  +1.20600000E-05  -1.20000000E-07
   -2.25900000E-05  +2.13170000E-04  -3.40000000E-06  +4.75200000E-05  +3.52090000E-04
   -2.05470000E-04  -4.23850000E-04  -1.19207000E-03  +1.36547700E-02  +8.81985400E-02
   +3.21693340E-01  +2.26950000E-04  +4.70100000E-05  +3.66420000E-04  +6.87260000E-04
   -1.05531000E-03  -3.90520000E-04  +2.33440000E-04  +2.13530000E-04  +8.94300000E-05
   +5.49100000E-05  +4.19400000E-05  -7.76300000E-05  -5.35400000E-05  +3.01000000E-06
   -5.21000000E-06  -5.32200000E-05  +5.51500000E-05  -8.70800000E-05  -2.18672000E-03
   -3.08000000E-06  +8.95390000E-04  -2.37675640E-01  +1.15186760E-01  +4.47972300E-02
   +5.93800000E-05  +1.99000000E-05  +9.04000000E-06  +7.66290000E-04  +1.60800000E-05
   -6.25800000E-05  +7.89400000E-05  -1.40400000E-04  +2.62930000E-04  -1.19480000E-04
   +1.08110000E-04  -7.39400000E-05  +1.25510000E-04  -6.70000000E-05  -5.84400000E-05
   +1.75680000E-04  +1.89530000E-04  -1.97770000E-04  -1.49800000E-04  -2.05990000E-04
   +4.52870000E-04  -1.84570000E-04  +1.71900000E-04  -1.76000000E-06  -1.33910000E-04
   -2.30240000E-04  +4.32590000E-04  -8.74100000E-05  -2.18660000E-04  -2.91500000E-04
   +1.76500000E-05  -2.43100000E-05  +3.05000000E-06  -3.89100000E-05  +1.21800000E-05
   -2.21500000E-05  +7.01800000E-05  +6.73800000E-05  -4.84600000E-05  +1.56030000E-04
   +2.00520000E-04  -5.30170000E-04  -3.24000000E-06  +7.10000000E-07  +2.08400000E-05
   +1.71800000E-05  +1.07070000E-04  +8.59000000E-05  +3.16280000E-04  -1.58820000E-04
   -6.41730000E-04  +3.16520000E-04  -2.50700000E-04  -1.00000000E-04  +1.27284000E-03
   -1.65970000E-03  -7.34860000E-04  +2.55383890E-01  -1.61740000E-04  -1.54240000E-04
   -6.82590000E-04  +1.30016000E-03  +7.48380000E-04  -1.44840000E-04  -5.58800000E-05
   +2.12690000E-04  -2.94000000E-05  -2.23990000E-04  -1.55060000E-04  +5.75500000E-05
   -1.60440000E-04  -1.80550000E-04  +3.20800000E-05  +1.78800000E-05  -6.37400000E-05
   +2.30400000E-05  +2.12745700E-02  -1.50429100E-02  -4.99353000E-03  +1.13249280E-01
   -1.14517160E-01  -2.69287200E-02  +1.66700000E-04  +1.84420000E-04  +2.73500000E-05
   -1.11652000E-03  -3.06151000E-03  +4.08169000E-03  +1.53549000E-03  -3.55140000E-04
   -4.83980000E-04  +3.09800000E-05  -4.05790000E-04  +1.47060000E-04  -2.90790000E-04
   +9.34400000E-05  +1.12100000E-04  +1.29520000E-04  +1.33230000E-04  -6.97700000E-05
   -6.11490000E-04  -3.11800000E-05  +6.32140000E-04  +2.70370000E-04  -1.66060000E-04
   -7.12800000E-05  -1.25070000E-04  +3.79520000E-04  -1.45862000E-03  +1.58150000E-04
   +5.16090000E-04  +7.35630000E-04  -3.78000000E-05  +3.86600000E-05  -6.04000000E-06
   +1.10430000E-04  -1.27360000E-04  -3.88300000E-05  -1.36300000E-05  +2.09900000E-05
   +8.33700000E-05  -1.92030000E-04  +1.04450000E-04  -3.17290000E-04  +4.98200000E-05
   -9.92000000E-06  +2.36000000E-06  -1.28940000E-04  +4.43100000E-05  +5.60900000E-05
   -1.87050000E-04  +6.13730000E-04  +4.62350000E-04  -3.48060000E-04  +6.79500000E-05
   -8.88300000E-05  +8.41303000E-03  -5.33431000E-03  -1.52774000E-03  -1.25477770E-01
   +1.25535300E-01  +1.69350000E-04  +2.26940000E-04  -5.83880000E-04  -3.95420000E-04
   -2.43040000E-04  +7.09570000E-04  -1.88050000E-04  -1.61420000E-04  +1.85710000E-04
   +1.92320000E-04  +2.65500000E-04  +1.34120000E-04  +2.21900000E-04  -2.28690000E-04
   -5.85480000E-04  -5.21810000E-04  -2.93110000E-04  +3.47630000E-04  -1.79598600E-02
   +1.10126300E-02  +2.18634000E-03  +4.60308800E-02  -2.82107900E-02  -5.67143300E-02
   -6.50200000E-05  -1.93000000E-05  +4.28700000E-05  +6.75380000E-04  +2.76845000E-03
   -2.81884000E-03  -1.09896000E-03  +7.42370000E-04  +5.25340000E-04  +1.06440000E-04
   +1.57870000E-04  -2.00930000E-04  +4.50700000E-05  -9.97200000E-05  -3.19000000E-06
   -1.75140000E-04  -3.54800000E-05  +2.65770000E-04  +7.77150000E-04  +3.43580000E-04
   -4.33680000E-04  -5.41300000E-05  -7.23000000E-06  +3.71400000E-05  -1.24128000E-03
   +7.21100000E-04  +1.14040000E-03  +2.69440000E-04  +9.35620000E-04  +6.59390000E-04
   +1.17400000E-05  -1.13000000E-05  -2.90000000E-06  -1.01350000E-04  +4.38200000E-05
   -1.76700000E-05  +9.81000000E-06  -2.57900000E-05  +3.40900000E-05  -1.86820000E-04
   -5.37190000E-04  +1.24810000E-04  -1.05200000E-05  +2.92700000E-05  +1.58200000E-05
   +1.67000000E-06  +2.81000000E-06  -7.81400000E-05  +2.25670000E-04  +9.15000000E-06
   -6.91820000E-04  +2.10600000E-04  -1.95940000E-04  +2.25080000E-04  +2.64530400E-02
   -1.50382000E-02  -4.97924000E-03  -4.92984700E-02  +2.59223600E-02  +6.06817800E-02
   +1.99830000E-04  +7.00500000E-05  +5.91900000E-04  +4.61890000E-04  -2.93450000E-04
   -1.17720000E-04  +4.43750000E-04  -1.15760000E-04  -1.62870000E-04  +2.82000000E-06
   -5.86800000E-05  -5.53000000E-05  +1.74640000E-04  +2.31590000E-04  +8.91000000E-05
   -1.51400000E-05  +9.75200000E-05  -5.48400000E-05  +1.51262000E-03  +2.24802000E-03
   -5.47500000E-05  -2.08485100E-01  -1.27583290E-01  -2.44085800E-02  -2.16280000E-04
   -2.05390000E-04  -2.54200000E-05  +4.03600000E-05  +2.72100000E-05  +2.66890000E-04
   +1.48960000E-04  -1.23820000E-04  -3.78000000E-05  +3.25000000E-05  -2.38000000E-06
   -5.41000000E-06  -1.72510000E-04  +1.14500000E-05  +5.69000000E-06  +1.30620000E-04
   +1.74420000E-04  -1.93470000E-04  -7.55480000E-04  +7.98200000E-04  +8.83290000E-04
   +9.26000000E-05  -3.38100000E-05  -3.75400000E-05  +3.10920000E-04  +4.64690000E-04
   -2.89470000E-04  -3.73620000E-04  -4.70290000E-04  -6.33940000E-04  -1.84000000E-05
   +1.11800000E-05  -5.22000000E-06  +1.33500000E-05  -2.35400000E-05  -9.49000000E-06
   -9.42000000E-06  +8.50000000E-07  -1.04200000E-05  -8.56610000E-04  +1.62749000E-03
   +3.01750000E-04  +4.00600000E-05  +4.27000000E-06  +2.91700000E-05  +3.28830000E-04
   +6.83900000E-05  +2.95960000E-04  -1.83720000E-04  -1.43850000E-04  +3.49100000E-05
   +2.03380000E-04  +2.33220000E-04  +1.11980000E-04  -5.59750000E-04  +1.07516000E-03
   +4.20340000E-04  -1.93461900E-02  -1.71901200E-02  -3.88757000E-03  +2.26678580E-01
   -4.11580000E-04  +3.36360000E-04  -3.63710000E-04  +1.63822000E-03  -2.30803000E-03
   +3.98583000E-03  -4.28750000E-04  -5.14710000E-04  -3.65430000E-04  -3.73640000E-04
   +1.89450000E-04  -3.53000000E-06  +4.27090000E-04  +1.55190000E-04  -1.97380000E-04
   -2.11460000E-04  -1.36790000E-04  +2.48860000E-04  -2.03684400E-02  -1.65623600E-02
   -2.97109000E-03  -1.26070690E-01  -1.47263950E-01  -1.98625800E-02  -4.10910000E-04
   -3.43760000E-04  -3.10500000E-05  -7.17800000E-04  +8.79020000E-04  -3.82530000E-04
   +3.02800000E-04  -1.37510000E-04  +1.99710000E-04  -2.04540000E-04  +1.82050000E-04
   +1.19900000E-05  +9.31600000E-05  +1.10300000E-05  -1.37110000E-04  +3.18860000E-04
   +2.25030000E-04  -2.67720000E-04  +9.99400000E-05  -5.68490000E-04  +5.81970000E-04
   -1.26340000E-04  +1.52120000E-04  -1.04700000E-05  -3.99640000E-04  +6.81110000E-04
   -1.57982000E-03  -9.76900000E-05  +8.88200000E-05  +3.65650000E-04  +6.94000000E-06
   -2.14200000E-05  -3.55000000E-06  -2.29500000E-05  -1.20000000E-06  -2.79600000E-05
   -3.46600000E-05  +8.06200000E-05  -1.14470000E-04  +1.03853000E-03  -8.32640000E-04
   -1.10638000E-03  +8.31000000E-06  -3.55500000E-05  +0.00000000E+00  +4.01430000E-04
   +5.10670000E-04  +6.35590000E-04  +1.31790000E-04  -1.41700000E-05  +1.28690000E-04
   +3.66920000E-04  +1.21810000E-04  -2.04220000E-04  -6.75336000E-03  -6.12662000E-03
   +9.21700000E-05  +1.29969100E-02  +1.12309900E-02  +2.34674000E-03  +1.38848180E-01
   +1.60308690E-01  +2.52230000E-04  -2.34010000E-04  +4.37420000E-04  -1.56512000E-03
   +2.22500000E-03  -2.57795000E-03  +9.44680000E-04  +4.50880000E-04  +1.63800000E-05
   -1.20750000E-04  -6.57660000E-04  -2.04340000E-04  -5.50880000E-04  +2.67250000E-04
   +9.24480000E-04  +7.76850000E-04  +4.43590000E-04  -4.38060000E-04  +1.70328400E-02
   +1.36762500E-02  +2.99030000E-04  -2.47623100E-02  -2.11413100E-02  -5.21174800E-02
   +2.35170000E-04  +1.71860000E-04  -5.29900000E-05  +2.26200000E-05  -5.86110000E-04
   +4.34670000E-04  +3.72200000E-05  -9.44000000E-06  -2.25310000E-04  +8.93000000E-05
   -1.77300000E-05  -4.90000000E-05  -1.18560000E-04  -5.61100000E-05  +1.23120000E-04
   -2.27700000E-05  +2.16540000E-04  -1.60670000E-04  -2.51380000E-04  -6.11360000E-04
   +5.36560000E-04  +4.42200000E-05  +5.34000000E-06  -4.34500000E-05  +1.16457000E-03
   +7.39330000E-04  +8.74690000E-04  -1.31044000E-03  -9.41030000E-04  -7.21980000E-04
   -7.42000000E-06  +1.41000000E-05  +1.43000000E-06  +2.16200000E-05  +9.03000000E-06
   +9.38000000E-06  +2.73300000E-05  +3.08000000E-05  -2.71000000E-06  +4.60420000E-04
   -5.01440000E-04  -2.61250000E-04  +1.63500000E-05  -6.01000000E-06  +1.12100000E-05
   -4.53060000E-04  +2.33070000E-04  -6.46220000E-04  +8.14800000E-05  -1.04240000E-04
   -6.05800000E-05  -1.17100000E-04  -2.40850000E-04  +3.23010000E-04  -2.37769100E-02
   -1.75480500E-02  -1.24270000E-04  +5.26434000E-03  +4.59119000E-03  -1.39150000E-04
   +2.67936100E-02  +1.90024200E-02  +5.40651100E-02  -1.30165000E-03  -2.84787000E-03
   +5.26298000E-03  +7.71925000E-03  +1.21487300E-02  +1.65095100E-02  -5.50128700E-02
   -1.58261500E-02  -7.24597000E-03  +2.57862000E-03  -1.36929500E-02  -2.07129900E-02
   -8.54230000E-04  -5.26380000E-03  +1.24112000E-03  -1.36806000E-03  -2.10520000E-04
   +4.05540000E-04  -9.51900000E-05  +2.10592000E-03  -1.02313000E-03  +3.95960000E-04
   +2.26700000E-05  -1.55410000E-04  +2.35700000E-05  -8.11870000E-04  -1.00513000E-03
   -2.81220000E-04  -8.19700000E-05  -1.73600000E-04  -4.98700000E-05  -1.36300000E-04
   +7.27000000E-05  +1.38700000E-05  +1.60300000E-05  -6.12900000E-05  -6.29800000E-05
   +5.07300000E-05  +1.75500000E-05  +4.09100000E-05  -1.51700000E-05  +1.84200000E-05
   -1.64400000E-05  -1.86200000E-05  -5.45000000E-05  +8.84000000E-05  -6.14300000E-05
   -2.24700000E-05  -8.28680000E-04  -4.19260000E-04  +5.86730000E-04  +5.65800000E-05
   +2.65110000E-04  +4.62400000E-05  -1.23800000E-05  +1.66400000E-05  +4.95000000E-06
   +7.72000000E-06  -4.73000000E-06  +1.00300000E-05  +5.48700000E-05  +8.24600000E-05
   +1.59700000E-05  -7.33000000E-06  +1.14000000E-05  +4.63000000E-06  +1.18700000E-05
   +5.84000000E-06  +2.77000000E-06  +2.24310000E-04  +1.96260000E-04  -7.24200000E-05
   -8.02000000E-04  -1.21177000E-03  -1.12650000E-04  -1.35026000E-03  -1.89190000E-04
   -4.29880000E-04  +4.19600000E-05  +7.73100000E-05  -9.32600000E-05  +3.05900000E-05
   +2.68000000E-05  +3.55800000E-05  -5.32900000E-05  +6.17300000E-05  -2.21500000E-05
   +5.16644300E-02  -3.25887000E-03  +3.70572000E-03  -1.58135000E-03  -1.47850000E-04
   +5.71405000E-03  +2.52431000E-03  -1.38605000E-02  -1.33740330E-01  -1.37366750E-01
   -1.00898000E-03  -8.16705000E-03  -1.74617400E-02  -5.48917000E-03  +2.82854000E-03
   -8.70260000E-04  +5.26230000E-04  -1.60700000E-04  +6.13020000E-04  +1.22211000E-03
   -2.65591000E-03  +9.38470000E-04  -6.01340000E-04  -2.52220000E-04  -3.42600000E-05
   -1.28050000E-04  -6.28100000E-04  -9.95710000E-04  +3.17960000E-04  +4.22420000E-04
   -2.14830000E-04  +9.98500000E-05  +9.67700000E-05  -1.43750000E-04  -3.85000000E-06
   -4.02500000E-05  +3.67100000E-05  -2.87900000E-05  +5.56600000E-05  -5.04000000E-06
   +1.16500000E-05  -3.59300000E-05  -9.32000000E-06  +9.21400000E-05  -1.23540000E-04
   +6.75000000E-05  +4.93700000E-05  -5.45100000E-05  +4.76000000E-06  -1.60920000E-03
   +1.67520000E-04  +2.22660000E-04  -1.24120000E-04  +1.03500000E-05  -3.41360000E-04
   +4.09000000E-06  +5.22000000E-06  -8.33000000E-06  +9.67000000E-06  -1.42000000E-05
   -7.71000000E-06  +1.91500000E-05  -6.35900000E-05  -1.26800000E-05  -1.27800000E-05
   +2.00000000E-07  +1.34000000E-05  +1.07400000E-05  -1.15300000E-05  -3.83000000E-06
   +5.59300000E-05  -2.60940000E-04  +3.88840000E-04  -1.57277000E-03  -1.28223000E-03
   -1.31740000E-04  +2.34810000E-04  -2.20180000E-04  +1.63590000E-04  +2.33500000E-05
   -2.10000000E-06  -2.05500000E-05  +4.16000000E-05  -2.92900000E-05  +8.50000000E-07
   +5.96400000E-05  -1.14550000E-04  +1.34460000E-04  +2.29752800E-02  +1.36883300E-01
   +5.44163000E-03  -9.28640000E-04  -1.04865000E-03  -2.10681000E-03  -1.29761200E-02
   -1.48476700E-02  -7.90131000E-03  -1.37489200E-01  -2.53086770E-01  +1.85958000E-03
   +6.66600000E-05  +1.47772000E-03  +1.66853000E-03  -1.51718000E-03  +2.36693000E-03
   -3.07860000E-04  +4.75640000E-04  +4.43680000E-04  -2.14168000E-03  +4.84870000E-04
   -1.29967000E-03  +5.50570000E-04  +1.26410000E-04  +6.29600000E-05  -1.03180000E-04
   -2.08380000E-04  -6.14800000E-05  -1.89770000E-04  -1.02860000E-04  +1.26630000E-04
   +8.34000000E-06  +1.41100000E-05  +3.81900000E-05  -9.84000000E-06  +6.18000000E-06
   +2.57800000E-05  +1.41500000E-05  -2.90100000E-05  -8.74000000E-06  -1.37900000E-05
   +2.87800000E-05  +9.10000000E-06  -2.75300000E-05  +5.00600000E-05  -1.26300000E-05
   -3.97400000E-05  +3.71900000E-05  +9.11000000E-06  -1.07109000E-03  -9.76970000E-04
   +3.43290000E-04  +2.11450000E-04  -4.66500000E-05  +5.97760000E-04  -1.83000000E-06
   -7.88000000E-06  -1.89000000E-06  -6.05000000E-06  +3.30000000E-06  -4.69000000E-06
   +7.70000000E-06  -3.71300000E-05  -2.92100000E-05  -2.29000000E-06  -9.84000000E-06
   -1.30600000E-05  -7.92000000E-06  +1.54000000E-06  -1.40000000E-07  -4.70510000E-04
   +1.83850000E-04  +4.06950000E-04  -4.24130000E-04  +4.43870000E-04  +3.51640000E-04
   -3.39760000E-04  -2.59610000E-04  +1.38840000E-04  -8.33200000E-05  -2.54300000E-05
   +6.64200000E-05  -1.71600000E-05  +7.64900000E-05  -7.33300000E-05  +1.77600000E-05
   +1.50560000E-04  -8.80600000E-05  +7.35935000E-03  +1.51681270E-01  +2.65288390E-01
   -2.82640000E-04  +5.41500000E-05  -6.76010000E-04  -6.82940000E-04  -5.29231000E-03
   -9.40000000E-07  -1.04583800E-02  +3.99330000E-04  +1.74982600E-02  -1.88797860E-01
   -1.96338000E-02  +1.48301000E-01  +4.78682000E-03  -2.43334000E-03  -1.69642000E-03
   +2.12926000E-03  -2.10009000E-03  +3.82160000E-04  -1.45920000E-04  +4.21810000E-04
   +7.60340000E-04  -1.30190000E-04  -4.09300000E-05  -7.16300000E-05  -3.48170000E-04
   +1.74669000E-03  -8.30400000E-04  -8.19000000E-06  -2.23340000E-04  -2.58000000E-06
   -2.87800000E-05  -2.58000000E-05  +5.39100000E-05  -2.62200000E-05  +1.33800000E-05
   +7.41000000E-06  +5.15100000E-05  -3.77700000E-05  -7.96000000E-06  -8.80000000E-06
   +1.71500000E-05  +8.25000000E-06  -4.98500000E-05  +7.25400000E-05  -2.81500000E-05
   -6.34200000E-05  +5.18100000E-05  +4.87000000E-06  -3.21700000E-05  +5.24600000E-05
   +5.00600000E-05  -5.71000000E-06  +7.40000000E-07  -2.93600000E-05  +3.63000000E-06
   -9.48000000E-06  +4.88000000E-06  -1.41300000E-05  +1.28000000E-05  +1.40000000E-07
   +1.27000000E-05  -1.65700000E-05  +5.03000000E-06  +8.81000000E-06  -6.24000000E-06
   -9.37000000E-06  -8.11000000E-06  +6.59000000E-06  +3.05000000E-06  -4.68000000E-06
   -3.17300000E-05  -2.62500000E-05  +3.20000000E-05  -1.17400000E-05  +1.08000000E-06
   -1.59600000E-05  -1.38900000E-05  -1.88700000E-05  -6.27000000E-06  +8.70000000E-06
   -6.29000000E-06  +2.06400000E-05  -6.53000000E-06  -1.24000000E-06  -1.54400000E-05
   -7.95200000E-05  +2.57400000E-05  -5.59650000E-04  +1.80312000E-03  -1.28574000E-03
   +1.94791120E-01  +1.13360000E-04  -1.08085000E-03  +1.39600000E-05  -5.15980000E-03
   +7.62580000E-04  -2.83720000E-03  -1.35771100E-02  +3.18643000E-03  +1.53568600E-02
   -2.06256600E-02  -4.92027500E-02  +3.65705000E-03  +1.25799200E-02  +7.16384000E-03
   -1.35588100E-02  -2.13737000E-03  +2.74220000E-04  -5.00993000E-03  -2.99350000E-04
   +2.33480000E-04  +7.28890000E-04  -1.71410000E-04  +2.27000000E-06  -5.04700000E-05
   +1.63239000E-03  -6.34080000E-04  +2.02076000E-03  -1.51780000E-04  -2.18250000E-04
   -1.81900000E-05  +4.07000000E-06  +2.16500000E-05  -3.92900000E-05  -5.30000000E-06
   +5.15000000E-06  +1.85100000E-05  +2.76900000E-05  -2.22000000E-05  -1.07000000E-06
   -9.26000000E-06  +2.78200000E-05  +1.81400000E-05  -2.28700000E-05  +2.92300000E-05
   +1.04000000E-06  -4.31200000E-05  +2.70700000E-05  +5.40000000E-06  +8.75300000E-05
   +5.30700000E-05  +8.81800000E-05  -4.69600000E-05  +1.65000000E-05  -3.13700000E-05
   +4.88000000E-06  -3.58000000E-06  -1.50000000E-07  +1.76000000E-06  +2.32000000E-06
   -2.24000000E-06  -1.08700000E-05  +3.33000000E-06  -6.06000000E-06  -1.40000000E-06
   -1.09900000E-05  -5.76000000E-06  -6.91000000E-06  +2.85000000E-06  +3.30000000E-06
   -9.14000000E-06  -7.90000000E-07  -3.52500000E-05  -8.04000000E-06  -3.03300000E-05
   -8.30000000E-06  +4.26000000E-06  +4.32600000E-05  -2.41000000E-05  +7.69000000E-06
   -9.26000000E-06  +6.71000000E-06  +1.60700000E-05  -3.36000000E-06  +3.48000000E-06
   -2.87000000E-06  -4.39000000E-05  +4.17100000E-05  +2.06784000E-03  -1.67969000E-03
   +1.39037000E-03  +2.46954300E-02  +4.14935600E-02  -9.84320000E-04  -3.74740000E-04
   -3.74500000E-05  -2.16270000E-04  -2.48099000E-03  +2.87189000E-03  -3.41748000E-03
   -1.01576000E-03  +6.30632000E-03  +1.47357790E-01  +2.29382000E-03  -2.03762940E-01
   +2.08256000E-02  +3.90884000E-03  -1.22446700E-02  -8.42300000E-05  -4.92810000E-03
   -2.38330000E-03  -2.27140000E-04  +2.23500000E-05  +1.17650000E-04  +6.15400000E-05
   -2.29500000E-05  +7.54000000E-06  -1.09484000E-03  +1.89142000E-03  +8.70390000E-04
   +3.32200000E-05  +5.01000000E-06  +7.40000000E-06  +1.31000000E-06  -1.49800000E-05
   +2.24500000E-05  +2.22000000E-06  +1.25800000E-05  -1.01700000E-05  -2.46300000E-05
   +2.09600000E-05  -7.10000000E-07  +8.27000000E-06  -1.47100000E-05  +2.91000000E-06
   -7.08000000E-06  +4.87000000E-06  +9.15000000E-06  +3.22900000E-05  -2.12900000E-05
   -5.42000000E-06  +9.46000000E-06  +3.46200000E-05  -3.42300000E-05  -5.41000000E-05
   -3.49700000E-05  -2.26600000E-05  -5.90000000E-06  +4.66000000E-06  -1.00000000E-07
   -4.70000000E-07  -1.51000000E-06  +1.10000000E-06  -2.19000000E-06  +7.65000000E-06
   -1.06400000E-05  -9.20000000E-07  +7.90000000E-07  -1.20000000E-07  +1.12000000E-06
   -5.10000000E-07  -2.18000000E-06  +1.77000000E-05  -2.99000000E-06  +3.26000000E-06
   +2.10000000E-05  -1.66900000E-05  +1.92000000E-06  -2.19500000E-05  -1.41500000E-05
   -1.02000000E-05  +8.20000000E-07  +4.41000000E-06  -1.31500000E-05  +2.82000000E-06
   -9.30000000E-06  +1.26100000E-05  -1.47000000E-06  -3.17000000E-06  -2.68200000E-05
   -9.45700000E-04  +1.82169000E-03  -1.17170000E-04  -1.61857840E-01  -1.81539000E-03
   +2.09201240E-01  +2.29217000E-03  -1.27651400E-02  -2.04348200E-02  -1.33021000E-03
   -5.15116000E-03  +1.32467000E-03  -1.49971000E-03  -5.39360000E-04  +2.85100000E-05
   -1.23290000E-03  -2.15777000E-03  +5.07318000E-03  +5.52893000E-03  +1.11452800E-02
   +1.74943900E-02  -5.26128700E-02  -1.87185200E-02  -4.02978000E-03  +6.13900000E-04
   -4.73600000E-04  -8.64170000E-04  -2.85200000E-05  +7.24000000E-05  -6.18700000E-05
   +1.17699000E-03  +3.61151000E-03  -1.19676000E-03  +1.26870000E-04  -5.97300000E-05
   -1.27200000E-05  +2.86000000E-06  +5.47000000E-06  +7.40000000E-06  -1.18600000E-05
   +3.46500000E-05  +4.11500000E-05  +3.47600000E-05  -4.52200000E-05  +4.73000000E-06
   -2.60600000E-05  +4.71000000E-05  +1.17500000E-05  +5.99000000E-06  +2.60000000E-05
   -1.32500000E-05  -6.72600000E-05  +7.15100000E-05  +2.46500000E-05  -3.19390000E-04
   -1.23070000E-04  +8.12300000E-05  -2.37700000E-05  +1.50770000E-04  +1.99540000E-04
   -1.04700000E-05  -1.64400000E-05  -1.23700000E-05  -2.18600000E-05  +5.47000000E-06
   -2.20900000E-05  +1.11100000E-05  -3.83300000E-05  -4.76000000E-06  +7.46000000E-06
   -8.55000000E-06  -1.11100000E-05  -1.59800000E-05  -2.07000000E-06  -2.75000000E-06
   -4.48700000E-05  -3.79400000E-05  -1.15690000E-04  +1.04000000E-05  +1.99600000E-05
   +2.63400000E-05  +1.88800000E-05  +1.29100000E-05  -1.93800000E-05  -3.50000000E-06
   -1.32400000E-05  +1.48200000E-05  -1.83000000E-06  +5.97000000E-06  +1.22000000E-06
   -1.98000000E-05  -3.47600000E-05  +3.31400000E-05  -1.72010000E-04  +3.12050000E-04
   -2.28730000E-04  +1.08310000E-04  +8.65070000E-04  +7.59290000E-04  +4.80700500E-02
   -3.50100000E-05  -1.07449500E-02  -1.71282900E-02  -5.10818000E-03  +7.14640000E-04
   -4.19700000E-05  +2.95060000E-04  +1.77500000E-05  +4.63980000E-04  -2.23022000E-03
   +2.81633000E-03  -1.45399000E-03  -3.96452000E-03  +4.70513000E-03  +2.30283000E-03
   -1.54203000E-02  -1.38415720E-01  -1.39457590E-01  +1.84330000E-04  -1.27200000E-05
   -1.11917000E-03  +2.33500000E-05  +6.96100000E-05  +6.27000000E-06  +2.39695000E-03
   -6.33670000E-04  +2.32455000E-03  +1.67530000E-04  -5.83500000E-05  -2.10900000E-05
   +1.98300000E-05  +1.72100000E-05  +2.67500000E-05  -3.61400000E-05  +4.05000000E-06
   +6.02000000E-06  +4.66000000E-05  -1.26400000E-05  -2.79300000E-05  +2.27000000E-06
   +2.64000000E-06  +5.69000000E-06  -2.10700000E-05  +2.18100000E-05  +1.54500000E-05
   -4.89300000E-05  +3.19600000E-05  +1.02300000E-05  -3.39230000E-04  -2.13710000E-04
   +8.25900000E-05  -2.38690000E-04  +1.38183000E-03  -8.97130000E-04  +8.54000000E-06
   -4.77000000E-06  +1.38000000E-06  +6.00000000E-07  +5.94000000E-06  +4.48000000E-06
   -1.71000000E-06  -2.25000000E-06  +5.05000000E-06  +6.17000000E-06  -7.21000000E-06
   -5.28000000E-06  -7.55000000E-06  -4.80000000E-07  +9.00000000E-07  +1.55000000E-06
   -8.63800000E-05  -1.20410000E-04  +1.67400000E-05  -1.74200000E-05  -1.40200000E-05
   +1.19000000E-06  +1.89200000E-05  +8.68000000E-06  +3.80600000E-05  -2.54000000E-06
   +7.33000000E-06  +7.32000000E-06  -1.93000000E-06  +1.38000000E-05  -1.36000000E-05
   -2.12400000E-05  -1.65300000E-05  +2.62910000E-04  -3.34980000E-04  +1.13570000E-04
   +1.95440000E-04  -1.57480000E-04  +2.70510000E-04  +2.29457100E-02  +1.41682240E-01
   +1.03803000E-03  +1.12641000E-03  +2.09979000E-03  +1.01573000E-03  -1.21272000E-03
   +2.03895000E-03  +1.84390000E-04  +5.77690000E-04  +1.21190000E-04  +4.99727000E-03
   -3.62400000E-04  -7.79340000E-04  -5.62122000E-03  -1.65552100E-02  -1.27434300E-02
   -4.42336000E-03  -1.41509260E-01  -2.42287840E-01  +3.65160000E-04  -8.56900000E-05
   +7.65600000E-05  -3.86600000E-05  -1.10500000E-05  -7.47000000E-06  -1.47090000E-03
   +2.26882000E-03  +1.41500000E-03  -6.52000000E-06  -2.51500000E-05  -2.45000000E-06
   +6.50000000E-06  -2.03100000E-05  +5.55000000E-06  -4.31000000E-06  +2.35400000E-05
   +3.27500000E-05  +2.97000000E-05  -3.97100000E-05  +1.34100000E-05  -8.76000000E-06
   +2.41100000E-05  -1.07900000E-05  +1.73000000E-06  +7.91000000E-06  -3.37800000E-05
   -5.04700000E-05  +5.18100000E-05  +9.19000000E-06  -2.47600000E-05  +1.95500000E-05
   +3.01100000E-05  +2.26570000E-04  +3.39390000E-04  +1.59770000E-04  -5.20000000E-06
   -1.42400000E-05  -4.11000000E-06  -1.92200000E-05  +4.95000000E-06  -1.84500000E-05
   +1.37900000E-05  -2.52200000E-05  -1.09800000E-05  +9.72000000E-06  +5.75000000E-06
   -2.62000000E-06  -2.86000000E-06  +2.41000000E-06  +1.13000000E-06  -1.97800000E-05
   +1.14300000E-05  -3.71000000E-06  -1.80000000E-06  +2.12100000E-05  +1.13000000E-05
   +1.29300000E-05  -3.05000000E-06  -1.74700000E-05  -1.22000000E-06  +8.78000000E-06
   -4.40000000E-07  -2.51000000E-06  +5.37000000E-06  -5.61000000E-06  -1.22800000E-05
   -2.30300000E-05  +1.46200000E-05  -1.88900000E-04  +1.78180000E-04  -1.50300000E-04
   -3.45440000E-04  -5.10240000E-04  -8.58240000E-04  +3.22503000E-03  +1.53903810E-01
   +2.51981710E-01  -2.21840710E-01  +4.31441000E-03  +1.54292090E-01  +6.95792000E-03
   -1.39866000E-03  -3.74073000E-03  +9.03180000E-04  -1.89065000E-03  -5.18740000E-04
   -1.66100000E-05  -4.01190000E-04  -1.18518000E-03  -1.06042000E-03  -3.14459000E-03
   +6.85230000E-04  -9.93909000E-03  +3.61190000E-03  +1.37538900E-02  -6.44760000E-04
   +5.38370000E-04  -5.66160000E-04  +1.36450000E-04  +3.48500000E-05  +5.89400000E-05
   -8.76140000E-04  -3.94800000E-04  +6.69980000E-04  -9.62920000E-04  -7.31290000E-04
   -9.92980000E-04  -4.23810000E-04  -1.49440000E-04  -3.90890000E-04  +3.25650000E-04
   -8.36700000E-05  -6.75700000E-05  -2.75410000E-04  +1.60500000E-05  +2.13910000E-04
   -1.84230000E-04  +2.18950000E-04  +7.85000000E-05  -8.08700000E-05  -1.25100000E-04
   -2.01060000E-04  +1.65810000E-04  -1.16470000E-04  -3.94400000E-05  -1.78600000E-05
   +1.29970000E-04  -2.19500000E-05  -6.02953000E-03  +5.26483000E-03  -2.64310000E-03
   -2.15400000E-05  +2.83800000E-05  +7.60000000E-07  +1.08200000E-05  -1.07500000E-05
   +1.12100000E-05  +3.30700000E-05  +1.63400000E-05  +7.93300000E-05  +4.15200000E-05
   -2.54200000E-05  -3.10000000E-07  +2.68000000E-06  +4.43000000E-06  -8.01000000E-06
   +6.07300000E-05  +2.82000000E-06  -3.30000000E-06  -1.20600000E-05  +3.12000000E-05
   +5.02800000E-05  -1.04100000E-05  +5.70000000E-06  -1.81600000E-05  +1.95540000E-04
   +6.42800000E-05  +2.86700000E-05  +1.30000000E-06  +4.34000000E-05  +3.89600000E-05
   -1.96000000E-05  +4.28300000E-05  -1.21930000E-04  +2.12740000E-04  +3.84400000E-05
   -3.75070000E-04  -1.18260000E-04  +1.15030000E-04  -4.31800000E-05  -3.26000000E-05
   +8.26110000E-04  -7.18820000E-04  +2.33716800E-01  +7.40377000E-03  -4.33127600E-02
   -3.08088500E-02  +1.39597600E-02  +4.46244000E-03  -7.02928000E-03  -9.30750000E-04
   +1.00164000E-03  -4.42965000E-03  -4.40270000E-04  -6.87120000E-04  +4.64420000E-04
   -3.85132000E-03  -9.01660000E-04  -5.04141000E-03  -2.11256600E-02  +1.94525000E-03
   +1.61773500E-02  +1.05015000E-03  -8.45550000E-04  +5.03280000E-04  -1.73570000E-04
   -1.80170000E-04  -5.13380000E-04  -8.88960000E-04  -4.78360000E-04  +1.27686000E-03
   -4.32750000E-04  -4.07300000E-05  -1.46800000E-04  -2.69740000E-04  +3.10360000E-04
   -1.67060000E-04  +2.93730000E-04  -2.79340000E-04  -1.67590000E-04  -1.42540000E-04
   -1.24050000E-04  +1.84880000E-04  -1.62020000E-04  +1.71370000E-04  +4.16000000E-05
   +3.74300000E-05  -3.03200000E-05  -1.18640000E-04  +1.05300000E-04  -9.53200000E-05
   -2.66900000E-05  +4.36000000E-05  -3.91700000E-05  +1.06870000E-04  +1.00119300E-02
   -7.67594000E-03  +4.19340000E-03  +1.48900000E-05  +1.95100000E-05  +1.21200000E-05
   +3.32500000E-05  -8.67000000E-06  +2.46800000E-05  -1.19400000E-05  +1.28200000E-05
   +1.07550000E-04  -1.01420000E-04  -1.17360000E-04  +3.61000000E-06  +1.02000000E-05
   +9.90000000E-06  +2.82000000E-06  -5.54800000E-05  +1.07500000E-05  +1.45100000E-05
   +1.90000000E-06  +5.22400000E-05  -2.44000000E-06  +4.39900000E-05  -8.24000000E-06
   +9.47700000E-05  -1.54340000E-04  -6.85600000E-04  +2.36720000E-04  -3.77600000E-05
   +1.12190000E-04  +5.32300000E-05  -5.07000000E-06  +5.98700000E-05  +3.45990000E-04
   +6.43320000E-04  +2.10590000E-04  -6.78280000E-04  +2.08380000E-04  -1.65840000E-04
   +1.86190000E-04  +1.75951000E-03  -9.81140000E-04  +1.15893000E-03  -7.57537000E-03
   +4.89703900E-02  +1.49842590E-01  -2.77379700E-02  -1.64937580E-01  +1.98098400E-02
   -1.81868000E-03  -1.46593000E-02  -5.79320000E-04  -5.45150000E-03  -2.51917000E-03
   -9.23860000E-04  -8.37450000E-04  -9.87660000E-04  -7.02710000E-04  -1.34803000E-03
   +5.10667000E-03  +1.39030000E-04  +2.64421000E-03  +2.90354000E-03  +4.43890000E-04
   +1.52401000E-03  -4.59190000E-04  +1.39200000E-05  -7.46200000E-05  +1.55950000E-04
   -4.95600000E-05  -3.15220000E-04  -4.36600000E-05  -2.13750000E-04  -2.66480000E-04
   +1.32850000E-04  +6.96800000E-05  +5.21240000E-04  -1.08680000E-04  +3.05500000E-05
   +1.61820000E-04  -5.29400000E-05  -3.99100000E-04  +2.18910000E-04  +1.11900000E-05
   +4.22300000E-05  -2.29520000E-04  +3.69100000E-05  -5.08950000E-04  +1.14390000E-04
   +4.73610000E-04  +4.48110000E-04  -3.18380000E-04  -7.14100000E-05  -1.17120000E-04
   +1.05590000E-04  -4.95700000E-05  -8.68704000E-03  +7.52095000E-03  -3.69146000E-03
   -4.38800000E-05  +5.91900000E-05  -1.10200000E-05  +1.31300000E-05  -3.75700000E-05
   -3.10000000E-07  +2.91900000E-05  -7.01900000E-05  -6.45500000E-05  +3.42200000E-05
   +5.84500000E-05  -1.96500000E-05  +3.91800000E-05  +6.48000000E-06  -6.48000000E-06
   -3.24700000E-05  -4.44900000E-05  +2.77400000E-05  -2.67500000E-05  +1.10950000E-04
   +7.02800000E-05  +4.82600000E-05  -2.80100000E-05  +1.07200000E-05  +1.66370000E-04
   -2.65800000E-05  +1.04970000E-04  -1.23900000E-05  +1.22840000E-04  +7.36800000E-05
   -1.72500000E-05  -1.28500000E-05  -1.15530000E-04  +8.18850000E-04  +3.55520000E-04
   -8.74010000E-04  -7.84300000E-05  +1.92430000E-04  -1.20480000E-04  -1.18711000E-03
   +1.57217000E-03  -3.45090000E-04  -1.57417430E-01  +2.28347700E-02  +1.80555990E-01
   -1.59130000E-04  -6.60000000E-07  +1.86390000E-04  -1.31200000E-04  +1.41150000E-04
   +6.08940000E-04  +1.78554000E-03  -6.05580000E-04  -9.09930000E-04  -4.33828000E-03
   -4.39887000E-03  +6.98760000E-04  -3.86506000E-03  -2.17499600E-02  -3.34497100E-02
   +1.27874000E-03  +2.07070000E-04  -2.73719000E-03  -1.59900000E-04  +3.28000000E-05
   +7.25100000E-05  +5.07000000E-05  -6.87000000E-06  +1.25100000E-05  -3.28225000E-02
   +6.59397000E-03  +4.84111000E-02  -1.05200000E-05  +2.68400000E-05  +1.07800000E-05
   +8.70000000E-06  +1.02400000E-05  +2.80100000E-05  +3.29600000E-05  +3.53900000E-05
   -1.30500000E-05  -1.18140000E-04  +7.36800000E-05  +1.55100000E-05  +1.96000000E-05
   -2.51000000E-05  +1.59700000E-05  -1.12700000E-05  -6.61000000E-06  +2.85100000E-05
   +1.26090000E-04  -7.59800000E-05  -1.46600000E-05  +6.83700000E-05  +1.92500000E-05
   -2.33600000E-05  -2.97930000E-04  -7.75000000E-06  -1.12760000E-04  -3.09500000E-05
   +1.32400000E-05  -6.32000000E-06  -8.87000000E-06  -1.11600000E-05  -7.31000000E-06
   -1.30200000E-05  -6.50000000E-07  -3.76100000E-05  -1.03200000E-05  -1.30000000E-06
   -3.19000000E-06  +4.19000000E-06  -2.44000000E-06  -7.66000000E-06  +1.51200000E-05
   +2.84600000E-05  +2.30400000E-05  -1.84700000E-05  +6.70000000E-07  -4.29000000E-06
   -9.97000000E-06  -8.13000000E-06  -1.03600000E-05  -1.76400000E-05  -2.31700000E-05
   +4.96000000E-06  -1.00300000E-05  -1.01100000E-05  +7.11000000E-06  +2.32600000E-05
   +3.10200000E-05  -7.31000000E-06  -2.63740000E-04  -1.19780000E-04  -1.03500000E-05
   -1.58920000E-04  +1.72840000E-04  -2.07220000E-04  -6.04190000E-04  +3.42340000E-04
   +1.86471000E-03  +5.85700000E-05  +5.46200000E-05  -3.05200000E-05  +3.94641500E-02
   +3.56500000E-04  -1.03260000E-03  -5.29100000E-05  -8.95300000E-05  +3.15170000E-04
   +4.60960000E-04  +4.24480000E-04  +5.46460000E-04  -1.89049000E-03  -5.06691000E-03
   -1.47266000E-03  +8.30050000E-04  -1.01684000E-03  -2.08249600E-02  -2.80063900E-02
   +3.18653000E-03  +2.55532000E-03  +6.52090000E-04  -1.72360000E-04  -5.71800000E-05
   -1.25200000E-05  +9.08000000E-05  +7.81000000E-06  +4.89200000E-05  -1.63186900E-02
   -1.45731020E-01  -2.09637770E-01  +3.55000000E-06  +1.13930000E-04  +5.63500000E-05
   +1.73400000E-05  +9.79000000E-06  -1.60000000E-07  +3.49500000E-05  +1.88600000E-05
   -4.48000000E-05  -1.45180000E-04  +1.23630000E-04  +3.81000000E-06  +2.68200000E-05
   -6.44100000E-05  +1.92800000E-05  -1.84000000E-06  -2.18300000E-05  +5.04000000E-05
   +1.76250000E-04  -1.47050000E-04  -3.09400000E-05  +7.98600000E-05  +6.09000000E-06
   -3.15900000E-05  +1.19030000E-04  +2.76670000E-04  -1.05140000E-04  -1.47500000E-05
   +3.67700000E-05  +2.58000000E-06  +2.07500000E-05  -1.75700000E-05  +1.64200000E-05
   -2.94300000E-05  +3.35800000E-05  -2.96400000E-05  -1.95900000E-05  -1.05000000E-06
   +8.71000000E-06  +9.14000000E-06  -3.08000000E-06  -6.42000000E-06  +2.14200000E-05
   +2.95100000E-05  +2.95900000E-05  -1.21300000E-05  -9.58000000E-06  -1.65300000E-05
   -1.04900000E-05  -1.44400000E-05  +5.88000000E-06  -3.57500000E-05  -2.28500000E-05
   +5.90000000E-06  -1.65000000E-06  -3.42200000E-05  +1.60000000E-07  +4.02100000E-05
   +5.19800000E-05  -1.57100000E-05  -2.21690000E-04  -2.40870000E-04  +6.99200000E-05
   +2.27990000E-04  -9.33000000E-05  +3.42400000E-04  -1.01846000E-03  +2.31400000E-04
   +6.83580000E-04  +1.41390000E-04  +2.00860000E-04  -1.58000000E-06  +1.92959900E-02
   +1.65453110E-01  -1.04810000E-04  -3.00490000E-04  -1.24190000E-03  -3.74600000E-05
   +2.37100000E-04  +4.27050000E-04  +6.64640000E-04  -5.42040000E-04  +9.54600000E-05
   +2.04390000E-04  +2.54350000E-04  +2.03532000E-03  +9.92990000E-04  -2.51550000E-04
   -3.78485000E-03  +2.48760000E-03  +4.30003000E-03  +3.63172000E-03  -9.34900000E-05
   +4.93000000E-06  -1.22350000E-04  +8.62600000E-05  +2.55300000E-05  +4.64600000E-05
   +1.04495900E-02  -2.40348890E-01  -4.07461510E-01  +4.41000000E-06  +5.20300000E-05
   +8.48000000E-06  -7.00000000E-08  -1.56800000E-05  +2.08500000E-05  +1.22500000E-05
   +1.26100000E-05  -8.00000000E-06  -5.09900000E-05  +4.04800000E-05  +6.59000000E-06
   +1.74500000E-05  -2.50000000E-05  -5.52000000E-06  -9.31000000E-06  -6.93000000E-06
   +8.49000000E-06  +5.93400000E-05  -4.16800000E-05  -1.57300000E-05  +2.35000000E-05
   -8.00000000E-08  -1.29900000E-05  -6.11200000E-05  +7.26500000E-05  -1.25660000E-04
   -1.08500000E-05  +7.09000000E-06  +4.11000000E-06  -5.32000000E-06  -3.01000000E-06
   +1.20000000E-07  -8.12000000E-06  +8.60000000E-07  -2.33400000E-05  -2.37000000E-06
   +6.94000000E-06  +3.46000000E-06  +6.98000000E-06  +6.20000000E-07  -2.03000000E-06
   +1.06200000E-05  +1.39300000E-05  +6.10000000E-06  -6.26000000E-06  -3.42000000E-06
   -5.33000000E-06  -5.75000000E-06  -3.14000000E-06  -7.03000000E-06  -4.35000000E-06
   -6.23000000E-06  -4.01000000E-06  -4.08000000E-06  -1.27200000E-05  +7.48000000E-06
   +1.46900000E-05  +3.39800000E-05  -2.60700000E-05  -7.58500000E-05  +5.51800000E-05
   -1.60000000E-06  -1.15220000E-04  +4.10230000E-04  +2.06840000E-04  -2.58720000E-04
   -7.43950000E-04  -6.90470000E-04  +1.40060000E-04  +1.00670000E-04  +1.70300000E-05
   -1.44487800E-02  +2.36648370E-01  +4.06933840E-01  -2.04962000E-03  -6.50470000E-04
   +5.91823000E-03  -4.77520000E-04  -1.37131000E-03  -2.26129000E-03  -3.90110000E-04
   -5.73040000E-04  -1.01180000E-04  -5.72000000E-06  -4.02800000E-04  -4.67530000E-04
   -3.16760000E-04  +1.67745000E-03  +2.56725000E-03  +2.19433000E-03  +1.58635000E-03
   -1.41409000E-03  -2.88540000E-04  +1.15300000E-05  -2.12450000E-04  -3.26460000E-04
   +1.66400000E-04  +4.42850000E-04  -8.33370000E-04  -7.29130000E-04  -4.39480000E-04
   -2.99700000E-05  +1.66570000E-04  +5.24900000E-05  +8.96400000E-05  -6.27000000E-05
   +4.12400000E-05  +1.99200000E-05  +4.72300000E-05  -2.38300000E-05  -1.49470000E-04
   +1.50980000E-04  -1.10400000E-05  +7.47400000E-05  -1.20250000E-04  -7.94000000E-06
   -2.53300000E-05  -5.50600000E-05  +5.83300000E-05  +2.06340000E-04  -1.53130000E-04
   -4.09200000E-05  +1.34810000E-04  +3.63000000E-05  -4.67500000E-05  -3.20997240E-01
   +1.14066030E-01  +2.26245150E-01  -2.72300000E-05  +3.01200000E-05  +3.04000000E-06
   +1.08600000E-05  -1.78700000E-05  +9.43000000E-06  -1.90700000E-05  +3.57100000E-05
   -6.69000000E-05  -6.35000000E-06  +3.80200000E-05  +3.88300000E-05  +2.51500000E-05
   -5.99000000E-06  -7.10000000E-06  +4.77800000E-05  +4.21400000E-05  +3.83700000E-05
   -6.45000000E-06  -3.85400000E-05  -3.56300000E-05  -1.93800000E-05  -1.06700000E-05
   -1.00000000E-07  -1.54000000E-05  +1.67610000E-04  +4.78700000E-05  +3.30800000E-05
   -4.44580000E-04  -2.97680000E-04  +2.61370000E-04  -6.79200000E-05  -1.15630000E-04
   -7.37800000E-05  +5.88800000E-05  +2.64100000E-05  +2.58500000E-05  -1.06630000E-04
   +6.24700000E-05  +7.09700000E-05  -3.23490000E-04  -2.42800000E-05  -2.55950000E-04
   +6.83230000E-04  -9.61400000E-04  +1.24080000E-04  -9.77100000E-05  +1.28140000E-04
   +3.22994810E-01  +4.70896000E-03  -1.02246000E-03  -2.83554000E-03  +3.52500000E-04
   -4.36000000E-06  +8.70040000E-04  +1.11023000E-03  +3.22250000E-04  -2.25590000E-04
   -3.76950000E-04  +4.96410000E-04  +3.88230000E-04  -5.76610000E-04  -8.29630000E-04
   -7.60260000E-04  +3.51690000E-04  -1.74982000E-03  -1.66820000E-04  +1.96240000E-04
   +2.56080000E-04  -1.78280000E-04  -6.28110000E-04  +1.99180000E-04  +2.34500000E-05
   +1.80850000E-04  +2.45250000E-04  +7.74400000E-05  -7.76700000E-05  -2.28400000E-04
   +1.00140000E-04  +5.09900000E-05  +2.79100000E-05  -7.34400000E-05  -2.35000000E-06
   -6.46800000E-05  +2.22000000E-05  +3.68300000E-05  -3.36000000E-05  +7.56000000E-06
   -4.05900000E-05  +1.46500000E-05  +2.88300000E-05  +1.53800000E-05  +4.39300000E-05
   -7.12700000E-05  -5.10100000E-05  +2.05000000E-05  +1.25100000E-05  -1.56230000E-04
   -6.60300000E-05  +5.78600000E-05  +1.07902130E-01  -4.28734500E-02  -6.82392100E-02
   +1.38300000E-05  -2.33000000E-06  +1.27000000E-06  +1.27000000E-05  -1.23000000E-06
   +3.37000000E-06  +2.78500000E-05  -1.46400000E-05  +4.95800000E-05  -3.17100000E-05
   -7.24000000E-06  +2.80800000E-05  -7.12000000E-06  +7.29000000E-06  +5.16000000E-06
   -4.47000000E-05  -4.54600000E-05  -3.58900000E-05  +2.92300000E-05  +2.30800000E-05
   -4.99500000E-05  +4.90100000E-05  -3.44200000E-05  +7.15900000E-05  -1.10240000E-04
   +2.27790000E-04  +1.64180000E-04  +2.87400000E-05  -3.62600000E-04  -4.92520000E-04
   +1.74180000E-04  -2.17900000E-04  +8.87900000E-05  -2.37000000E-05  +1.23200000E-05
   -1.11440000E-04  -2.54300000E-05  +8.01000000E-06  -6.05700000E-05  +1.12010000E-04
   -1.18400000E-05  -2.63500000E-05  +5.57730000E-04  -8.92880000E-04  +4.95200000E-04
   -2.54300000E-05  -2.22270000E-04  +2.72200000E-05  -1.13733240E-01  +4.67806000E-02
   -6.34699000E-03  +6.23691000E-03  -7.28720000E-04  -1.07804000E-03  +1.26430000E-03
   +1.64276000E-03  +3.26300000E-05  -3.52400000E-04  -2.66890000E-04  +8.94300000E-04
   +4.10290000E-04  +3.08210000E-04  +9.28760000E-04  +1.76270000E-04  -9.04500000E-04
   -2.80189000E-03  -1.16066000E-03  +7.69910000E-04  -2.36220000E-04  -7.48000000E-05
   +3.01500000E-05  -3.49570000E-04  +8.08000000E-06  -1.32690000E-04  -3.72380000E-04
   -1.97740000E-04  -6.96800000E-05  -1.00420000E-04  -2.28600000E-05  -4.57000000E-06
   -7.27500000E-05  -4.32000000E-05  -2.61600000E-05  +8.59900000E-05  -5.23400000E-05
   -4.93600000E-05  -5.23100000E-05  -2.50100000E-05  +6.22000000E-05  -3.96500000E-05
   +4.56000000E-05  +3.53000000E-06  +1.00420000E-04  -2.31700000E-05  -6.42500000E-05
   +4.23500000E-05  -2.63800000E-05  -9.05000000E-06  -9.20000000E-07  -5.76000000E-06
   +3.12300000E-05  +2.39374910E-01  -7.73475100E-02  -1.83148320E-01  -6.84000000E-06
   +7.05000000E-06  +1.62000000E-06  +6.13000000E-06  -5.03000000E-06  +3.60000000E-06
   -5.44000000E-06  +3.02600000E-05  +2.84100000E-05  -2.74600000E-05  -1.07000000E-05
   +1.59000000E-05  +3.10000000E-06  +3.80000000E-07  -1.81000000E-06  +2.33400000E-05
   +3.35000000E-06  -8.53000000E-06  +9.14000000E-06  -4.50400000E-05  -4.75900000E-05
   -1.53000000E-06  -6.65000000E-06  +1.71900000E-05  -1.17450000E-04  -2.29400000E-05
   -6.41500000E-05  -2.44300000E-05  -3.07580000E-04  -8.14200000E-05  +1.63760000E-04
   -1.16130000E-04  +1.07800000E-05  -1.76100000E-05  +8.79000000E-06  -3.43400000E-05
   -1.80400000E-05  -3.16000000E-06  +1.80000000E-05  +1.25020000E-04  -9.87000000E-05
   -3.84300000E-05  -1.02778000E-03  +1.00484000E-03  -5.43400000E-04  +5.27600000E-05
   -5.27800000E-05  +7.90000000E-05  -2.29144880E-01  +7.08044200E-02  +1.83201350E-01
end_hess

