# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -807.46937080    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -2.23035423E+00  +8.95367281E-01  +7.46970838E-02
   006   -4.67932915E+00  +1.97136588E+00  +2.69161204E-01
   006   -6.83787049E+00  +5.52599182E-01  +3.57045141E-02
   006   -6.65886213E+00  -2.02862259E+00  -4.63474338E-01
   006   -4.28825121E+00  -3.14703556E+00  -7.42043530E-01
   006   -2.13227965E+00  -1.70663303E+00  -5.26798446E-01
   001   -4.85347540E+00  +3.96751453E+00  +6.59852620E-01
   001   -8.68551024E+00  +1.39890980E+00  +2.40775926E-01
   008   -8.83309809E+00  -3.34928903E+00  -6.69658135E-01
   001   -4.14348340E+00  -5.14811496E+00  -1.15565206E+00
   001   -3.09254182E-01  -2.58937698E+00  -7.86944758E-01
   006   +6.36652788E-02  +2.60246786E+00  -4.71352643E-01
   006   +2.54589648E+00  +1.11775691E+00  -3.30101075E-01
   006   -3.82285472E-01  +3.66104747E+00  -3.14642190E+00
   006   +2.21652661E-01  +4.86721313E+00  +1.34092684E+00
   006   +4.03933461E+00  +6.50072622E-01  -2.43666537E+00
   006   +6.29708700E+00  -6.79373145E-01  -2.26489968E+00
   006   +7.11247231E+00  -1.58062096E+00  +5.21221200E-02
   006   +5.64528323E+00  -1.14502203E+00  +2.18571325E+00
   006   +3.40836496E+00  +1.82437698E-01  +1.98505716E+00
   001   +3.47365665E+00  +1.31570113E+00  -4.28154362E+00
   001   +7.41661330E+00  -1.00433967E+00  -3.95000175E+00
   008   +9.30203175E+00  -2.89108968E+00  +3.47403483E-01
   001   +6.28093335E+00  -1.85838308E+00  +3.99239573E+00
   001   +2.26038799E+00  +4.52173150E-01  +3.65122976E+00
   001   +1.17459539E+00  +4.88657210E+00  -3.71397276E+00
   001   -5.92555855E-01  +2.16407981E+00  -4.54702298E+00
   001   -2.10901235E+00  +4.78266272E+00  -3.17343312E+00
   001   +1.86512998E+00  +6.00726389E+00  +8.46016242E-01
   001   -1.44135084E+00  +6.07414124E+00  +1.18821057E+00
   001   +3.89502280E-01  +4.26497488E+00  +3.29422588E+00
   001   +1.01355566E+01  -3.04581664E+00  -1.24955257E+00
   001   -8.47049329E+00  -5.08635425E+00  -1.02368815E+00
   008   -2.01923107E+00  +5.89711071E-01  +4.02058951E+00
   001   -3.08324808E+00  -8.78810521E-01  +4.16083224E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +3.00000000E-08  +1.30000000E-07  -5.00000000E-08
   +1.30000000E-07  +5.00000000E-07  -1.40000000E-07
   +5.00000000E-08  +7.40000000E-07  +3.90000000E-07
   -2.00000000E-07  +4.30000000E-07  +8.60000000E-07
   -5.20000000E-07  +2.70000000E-07  +9.80000000E-07
   -1.60000000E-07  +2.40000000E-07  +6.10000000E-07
   +3.60000000E-07  +6.30000000E-07  -3.90000000E-07
   +1.10000000E-07  +9.00000000E-07  +3.10000000E-07
   -3.80000000E-07  +7.30000000E-07  +1.27000000E-06
   -5.80000000E-07  +2.20000000E-07  +1.35000000E-06
   -2.70000000E-07  -6.00000000E-08  +6.20000000E-07
   +2.80000000E-07  +0.00000000E+00  -4.50000000E-07
   +3.00000000E-08  -2.70000000E-07  -3.00000000E-07
   +6.00000000E-08  -5.40000000E-07  -6.40000000E-07
   +4.80000000E-07  +3.00000000E-07  -8.70000000E-07
   -1.20000000E-07  -8.00000000E-07  -3.10000000E-07
   -2.60000000E-07  -1.00000000E-06  -1.60000000E-07
   -1.60000000E-07  -6.20000000E-07  -1.00000000E-08
   +4.00000000E-08  -1.00000000E-07  -1.00000000E-08
   +7.00000000E-08  +1.50000000E-07  -1.10000000E-07
   -6.00000000E-08  -1.20000000E-06  -3.70000000E-07
   -3.60000000E-07  -1.43000000E-06  -1.30000000E-07
   -2.90000000E-07  -7.50000000E-07  +1.30000000E-07
   +4.00000000E-08  +2.40000000E-07  +1.50000000E-07
   +1.80000000E-07  +5.10000000E-07  -1.00000000E-07
   +2.10000000E-07  -8.10000000E-07  -9.50000000E-07
   -1.00000000E-07  -8.10000000E-07  -2.80000000E-07
   +2.30000000E-07  -3.90000000E-07  -7.30000000E-07
   +5.60000000E-07  +4.00000000E-08  -1.21000000E-06
   +6.10000000E-07  +4.00000000E-07  -1.06000000E-06
   +5.00000000E-07  +5.80000000E-07  -6.60000000E-07
   -3.90000000E-07  -1.15000000E-06  +1.10000000E-07
   -5.60000000E-07  +6.30000000E-07  +1.60000000E-06
   +2.80000000E-07  +1.07000000E-06  +2.50000000E-07
   +1.20000000E-07  +1.19000000E-06  +3.30000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.76578010E-01  -1.81000600E-02  +6.09199680E-01  -6.82232900E-02  +5.15961300E-02
   +1.16601880E-01  -2.44035190E-01  +4.38635700E-02  +5.51131500E-02  +6.47989180E-01
   +8.24309200E-02  -1.54526820E-01  -2.20944100E-02  +3.95342600E-02  +7.28239210E-01
   +1.66913200E-02  -1.03745400E-02  -5.24397300E-02  -1.20257400E-02  +1.04359820E-01
   +1.64152790E-01  -5.16088800E-02  +4.58948000E-03  -6.93541000E-03  -2.99903330E-01
   -1.44419600E-01  -1.86333800E-02  +7.71082350E-01  -2.97835600E-02  +5.30588200E-02
   -1.30376300E-02  -6.49328600E-02  -1.99446160E-01  -1.74586000E-02  -1.31240400E-02
   +6.47889120E-01  -3.92398000E-03  +6.65010000E-03  +6.75942000E-03  -1.07892500E-02
   -2.41321700E-02  -6.08278800E-02  -1.29691000E-02  +1.05083850E-01  +1.47816180E-01
   -1.46905900E-02  +3.05703200E-02  +1.58257100E-02  +4.35470200E-02  -2.51565900E-02
   -4.66269000E-03  -1.34554630E-01  -9.45899000E-03  +3.71110000E-04  +6.95435170E-01
   +3.36784600E-02  -4.16421500E-02  +1.66579000E-03  -9.18633200E-02  -3.87832000E-02
   -1.25798800E-02  +8.07913300E-02  -2.80626230E-01  -4.53899800E-02  +1.80368300E-02
   +6.86037510E-01  +6.94072000E-03  -7.07998000E-03  -8.53346000E-03  -1.88155100E-02
   -6.91868000E-03  +3.03630000E-04  +1.66831100E-02  -4.01290300E-02  -7.82479900E-02
   -9.15300000E-03  +1.01422050E-01  +1.81874060E-01  +2.98661100E-02  -5.81302700E-02
   -3.17830100E-02  -6.05080400E-02  -8.19200000E-03  -1.77977000E-03  +2.81101000E-02
   +7.75823000E-02  +1.35127800E-02  -2.48440680E-01  +2.64359900E-02  +9.02778000E-03
   +6.67003680E-01  -2.53826500E-02  -3.00687900E-02  -7.15997000E-03  -3.91178000E-03
   -2.75307000E-03  -2.22500000E-04  +3.12553000E-02  -1.27722700E-02  -5.19637000E-03
   +1.20948700E-01  -1.80142550E-01  -2.55059700E-02  +1.87471500E-02  +7.25430950E-01
   -8.08328000E-03  -4.73468000E-03  +8.58830000E-03  +1.50602000E-03  +3.55380000E-04
   -2.75758000E-03  +5.06001000E-03  -6.83986000E-03  +7.31352000E-03  +2.69283700E-02
   -2.13147400E-02  -7.30222200E-02  -8.30420000E-03  +1.22090020E-01  +1.47900900E-01
   -1.23626600E-01  +3.32191400E-02  +2.10137900E-02  +2.40577900E-02  +3.68165300E-02
   +8.56428000E-03  -1.35919200E-02  -2.77103200E-02  -4.75552000E-03  -6.89837200E-02
   +2.20657700E-02  +6.76865000E-03  -2.84906620E-01  -1.41917410E-01  -2.14409000E-02
   +7.52540380E-01  -3.42168000E-03  -2.78945630E-01  -8.56524000E-03  +5.18008900E-02
   -1.26457400E-02  -8.73493000E-03  -1.91822000E-02  -4.53880400E-02  -7.33840000E-03
   -4.09855100E-02  +6.91923400E-02  +1.40111300E-02  -7.10909400E-02  -1.98817650E-01
   -2.90028200E-02  -4.60399000E-03  +6.21068810E-01  +9.11608000E-03  -5.05985400E-02
   -5.89233900E-02  +7.78850000E-03  -2.12209000E-03  +6.35016000E-03  -4.49931000E-03
   -8.18835000E-03  -3.85996000E-03  -9.75616000E-03  +1.45403600E-02  +5.80996000E-03
   -2.05660000E-04  -2.38246800E-02  -6.35392400E-02  -3.18433400E-02  +9.62913900E-02
   +1.67631850E-01  +2.82815000E-03  +2.78341300E-02  +4.89512000E-03  -6.08661700E-02
   +2.53880100E-02  +4.74453000E-03  +5.76487000E-03  -2.72368100E-02  -4.97314000E-03
   -3.92717000E-03  -2.38037000E-03  -6.61700000E-05  -1.12104000E-03  -3.15120000E-04
   +1.34600000E-05  -5.46481000E-03  +2.38676000E-03  +2.99720000E-04  +6.26457100E-02
   +8.28880000E-04  -9.00509000E-03  -2.18702000E-03  +2.34155200E-02  -3.32142420E-01
   -5.66295100E-02  +4.06983000E-03  -1.19553000E-02  -3.80279000E-03  -2.70551000E-03
   +7.46380000E-04  -1.52614000E-03  -7.47100000E-05  +6.41160000E-04  +3.35520000E-04
   +2.41175000E-03  +2.75340000E-04  -8.86720000E-04  -2.38086600E-02  +3.52927140E-01
   -2.02788000E-03  -8.84430000E-04  +2.32313000E-03  +8.66361000E-03  -5.89265000E-02
   -5.08364600E-02  -1.62790000E-04  -3.55904000E-03  +5.33529000E-03  -5.02810000E-04
   -4.25660000E-04  +8.54474000E-03  +6.08610000E-04  +2.42160000E-04  -1.11717000E-03
   +3.47060000E-04  -1.36078000E-03  +4.62439000E-03  -5.56303000E-03  +6.40381200E-02
   +3.79955700E-02  -1.89005000E-03  -3.91603000E-03  -2.86470000E-04  -1.76295100E-02
   +1.25997700E-02  +2.51692000E-03  -2.91241750E-01  +1.10115590E-01  +2.69518500E-02
   +7.54700000E-05  -1.64586000E-03  -2.82220000E-04  +1.09248000E-03  -1.45150000E-04
   -4.70500000E-05  +3.31170000E-04  -3.87780000E-04  -4.69800000E-05  +8.54910000E-04
   -1.35410000E-04  -2.10530000E-04  +3.07942760E-01  -3.28764000E-03  -1.38854000E-03
   -1.52733000E-03  -1.74345900E-02  +1.20152200E-02  +1.92419000E-03  +1.08531610E-01
   -1.10941440E-01  -1.70441100E-02  +3.03508200E-02  -7.11779000E-03  -2.92761000E-03
   -6.19870000E-04  -5.44961000E-03  -2.06325000E-03  -1.13376000E-03  -8.82710000E-04
   -3.87000000E-06  +3.11350000E-04  +6.88170000E-04  +1.03069000E-03  -1.17275790E-01
   +1.10498970E-01  -7.83950000E-04  -2.07448000E-03  +7.16474000E-03  -2.48057000E-03
   +1.00320000E-03  +3.14895000E-03  +2.67541100E-02  -1.73575500E-02  -3.90451800E-02
   +6.12079000E-03  -2.03719000E-03  +3.60496000E-03  -1.65840000E-04  -1.77755000E-03
   +4.68365000E-03  -4.25800000E-05  +3.67680000E-04  -8.15310000E-04  -5.61400000E-05
   +1.23150000E-03  -4.83137000E-03  -2.89564100E-02  +1.92810000E-02  +2.92395200E-02
   -1.76741000E-03  -1.90102000E-03  -5.64447000E-03  +1.10993000E-03  +4.14906000E-03
   +1.89314000E-03  +2.92500000E-05  -1.66756600E-02  -2.54087000E-03  -2.72060310E-01
   -6.73922900E-02  -7.30582000E-03  -5.51278100E-02  -3.25918800E-02  -4.82073000E-03
   +2.00031000E-03  +9.88867000E-03  +3.62355000E-03  +2.83390000E-04  +1.19720000E-04
   +5.95000000E-06  +8.89900000E-04  -1.48350000E-04  -4.01700000E-04  +3.94035060E-01
   -4.71242000E-03  +3.84297000E-03  -3.21943000E-03  +1.37099900E-02  -2.04856000E-03
   -2.72400000E-05  -5.55314600E-02  -4.23017500E-02  -7.55979000E-03  -1.19721790E-01
   -1.61800140E-01  -1.98958100E-02  +8.02764000E-03  +1.18025600E-02  -2.56000000E-04
   +9.62600000E-05  -5.61807000E-03  -1.78549000E-03  -1.42538000E-03  -9.22300000E-04
   -2.10120000E-04  +9.87700000E-05  +2.17625000E-03  +8.81410000E-04  +2.58955500E-02
   +6.80473120E-01  -6.58850000E-04  +9.37950000E-04  -1.29927000E-03  +2.81636000E-03
   -1.31342000E-03  +4.29908000E-03  -1.05022700E-02  -9.32679000E-03  +5.47111000E-03
   -1.81658800E-02  -2.18504700E-02  -4.71102700E-02  +2.70148000E-03  +8.34860000E-04
   +1.10160900E-02  +3.34260000E-04  -2.15750000E-03  +6.53354000E-03  -3.39430000E-04
   -1.98630000E-04  -7.94800000E-05  +7.20000000E-07  +1.08714000E-03  -2.95270000E-03
   -4.06943000E-03  +1.28220880E-01  +5.36423200E-02  -4.26172000E-03  -2.76441000E-03
   +8.26900000E-05  -1.32425000E-03  -5.72980000E-04  -1.47340000E-04  -5.04547000E-03
   +2.14762000E-03  +6.11830000E-04  +2.14876000E-03  +2.74461400E-02  +5.53782000E-03
   -6.22290300E-02  +2.21693900E-02  +5.48566000E-03  +6.71008000E-03  -2.69030600E-02
   -6.06116000E-03  +9.48700000E-05  -2.36900000E-05  +4.87000000E-06  +1.29380000E-04
   +1.39706000E-03  +2.21660000E-04  +3.11422000E-03  +1.01750000E-03  +8.76900000E-05
   +6.05986300E-02  -3.27190000E-03  +8.25950000E-04  -9.97300000E-04  +1.19580000E-04
   +5.93330000E-04  +3.70080000E-04  +2.70386000E-03  +1.02741000E-03  -9.87030000E-04
   -5.25383000E-03  -1.19692600E-02  -3.04375000E-03  +2.20780300E-02  -3.21272050E-01
   -5.96964300E-02  +3.40472000E-03  -1.32865100E-02  -3.69310000E-03  +7.32000000E-06
   -1.07900000E-04  +1.24240000E-04  -8.34000000E-05  -5.69410000E-04  -1.09490000E-04
   +2.08720000E-04  +3.17731000E-03  +1.42367000E-03  -2.21129500E-02  +3.41845260E-01
   -7.59860000E-04  -1.51144000E-03  +7.30034000E-03  +4.55180000E-04  +2.91730000E-04
   -8.44250000E-04  +7.88580000E-04  -1.25052000E-03  +4.79374000E-03  -1.30393000E-03
   -3.35010000E-03  +2.70667000E-03  +5.72250000E-03  -5.99285800E-02  -4.56779500E-02
   +2.22500000E-04  -2.07068000E-03  +2.42563000E-03  +2.65000000E-05  +1.01060000E-04
   -6.02260000E-04  +2.28000000E-06  -2.15310000E-04  +1.56370000E-04  -2.26200000E-04
   +1.21759000E-03  -3.39903000E-03  -5.46282000E-03  +6.59083800E-02  +3.68950500E-02
   +2.59852000E-03  +8.83420000E-04  +1.33310000E-04  +7.48110000E-04  -3.20420000E-04
   +2.09400000E-04  +3.50160000E-04  -5.07920000E-04  -1.30930000E-04  -1.62561000E-03
   -3.57378000E-03  -2.31980000E-04  -1.71779600E-02  +1.21717400E-02  +3.38713000E-03
   -2.85926700E-01  +1.12249920E-01  +3.38868000E-02  +1.41550000E-04  -1.56650000E-04
   +1.97500000E-05  -5.62400000E-05  +2.87100000E-05  -2.82100000E-05  -1.28739000E-03
   +4.14790000E-04  +1.12000000E-05  +8.86550000E-04  -8.77200000E-05  -2.12440000E-04
   +3.04945660E-01  +2.73217100E-02  -7.87461000E-03  -3.50534000E-03  -2.33250000E-04
   -5.68629000E-03  -2.51715000E-03  -7.86610000E-04  -9.16570000E-04  +1.58570000E-04
   -3.46957000E-03  -1.18260000E-03  -1.74671000E-03  -1.73558900E-02  +1.11625400E-02
   +2.03961000E-03  +1.11667620E-01  -1.13264470E-01  -2.06793800E-02  +1.53192000E-03
   -5.08000000E-04  -1.54670000E-04  +5.89600000E-05  +4.88900000E-05  +1.54870000E-04
   -1.09549000E-03  +3.43750000E-04  +5.45200000E-05  +3.09090000E-04  +6.63410000E-04
   +1.13050000E-03  -1.17385930E-01  +1.16780540E-01  +7.18338000E-03  -5.06156000E-03
   +2.02388000E-03  -4.42750000E-04  -2.24558000E-03  +4.54117000E-03  -3.59200000E-05
   +4.97270000E-04  -1.05732000E-03  +2.63330000E-04  -2.26654000E-03  +7.83293000E-03
   -3.61342000E-03  +2.11700000E-04  +5.71457000E-03  +3.37232400E-02  -1.69002400E-02
   -4.46228100E-02  +3.43400000E-04  -1.00800000E-04  +2.14500000E-04  +2.40100000E-05
   +1.48330000E-04  -5.88260000E-04  -2.52050000E-04  +1.37520000E-04  -3.58210000E-04
   -2.34060000E-04  +1.08217000E-03  -4.62065000E-03  -3.60353200E-02  +2.41177700E-02
   +3.21483600E-02  -1.33360960E-01  -3.18036100E-02  +1.06881100E-02  -2.45786400E-02
   -1.59492700E-02  +4.05973000E-03  -1.70138000E-03  +3.20826000E-03  +2.27221000E-03
   -1.67814000E-03  -5.20300000E-05  -2.59130000E-04  +1.01499000E-03  +1.91975000E-03
   +1.97368000E-03  +4.12296000E-03  -6.17714000E-03  -2.13160000E-03  +8.32140000E-04
   -4.38930000E-04  -1.04607000E-03  -4.68810000E-04  -5.11900000E-04  -3.60040000E-04
   +1.69029000E-03  +9.74960000E-04  +9.20300000E-05  +6.34290000E-04  +5.37430000E-04
   +4.17550000E-04  -7.22510000E-04  +1.49585000E-03  -5.86500000E-04  +4.79641070E-01
   -3.26130500E-02  -1.10230600E-01  +1.53635000E-03  +5.03124000E-03  +1.38049300E-02
   +6.44600000E-05  +4.34998000E-03  -1.66145000E-03  -1.15230000E-04  -2.85600000E-05
   -1.33509000E-03  -3.35980000E-04  +2.11040000E-03  -3.18682000E-03  -3.19420000E-04
   -2.51554200E-02  -1.70674300E-02  +4.21036000E-03  +5.48910000E-04  -9.24800000E-04
   -3.36540000E-04  +9.78120000E-04  +5.53260000E-04  +3.97520000E-04  +2.52260000E-04
   +4.91270000E-04  +1.11120000E-04  -8.63520000E-04  -3.59650000E-04  -3.85720000E-04
   -2.76620000E-04  +7.52150000E-04  -8.67300000E-05  -1.73288300E-02  +4.71650370E-01
   +1.51935000E-02  +4.45814000E-03  -6.09674200E-02  +1.02340000E-04  +6.11310000E-04
   -2.30690000E-04  -2.00400000E-04  +1.04605000E-03  +3.52938000E-03  -5.07290000E-04
   -6.94210000E-04  -2.25930000E-04  +1.80388000E-03  -3.36616000E-03  +3.54590000E-03
   -8.04854000E-03  -5.26071000E-03  +2.68354000E-03  +1.55210000E-04  +7.52570000E-04
   -1.85595000E-03  -1.55250000E-04  -7.62100000E-05  +2.14890000E-04  +9.16210000E-04
   +9.07410000E-04  -2.84130000E-04  -5.19070000E-04  -4.28980000E-04  -1.39410000E-04
   +1.40500000E-04  +3.66760000E-04  -2.25063000E-03  +1.05309400E-02  +8.38580000E-03
   +4.65855560E-01  -3.20610300E-02  +7.60711000E-03  +9.29410000E-04  -1.25918000E-03
   -2.72737000E-03  -1.85630000E-04  -6.47610000E-04  +8.12080000E-04  +1.92250000E-04
   -1.33650000E-04  -3.72550000E-04  -3.38300000E-05  -6.74370000E-04  +1.14246000E-03
   +4.21590000E-04  -1.41378000E-03  -5.91250000E-04  -2.45790000E-04  -5.03200000E-05
   +9.44800000E-05  -4.88800000E-05  -1.45180000E-04  -1.08800000E-04  -3.30800000E-05
   +1.63850000E-04  +2.29400000E-04  +1.59000000E-06  +1.67000000E-04  +8.32400000E-05
   +3.95200000E-05  -1.43243000E-03  -5.90190000E-04  -1.22000000E-04  -1.45907950E-01
   +4.42814200E-02  -3.77853000E-03  +5.23345140E-01  -1.00499300E-02  +1.30384000E-02
   -5.38860000E-04  -3.36901000E-03  -3.56720000E-03  +5.74540000E-04  -6.48440000E-04
   +1.26436000E-03  +2.51650000E-04  +2.90240000E-04  -7.04500000E-05  +1.15300000E-05
   -3.73660000E-04  +1.53760000E-04  -6.85300000E-05  -3.24925000E-03  -2.30773000E-03
   -3.50200000E-04  -4.22600000E-05  +2.05420000E-04  -4.77700000E-05  -2.97910000E-04
   -1.77620000E-04  -1.09160000E-04  -4.44360000E-04  -2.82690000E-04  -2.16900000E-05
   -3.23700000E-05  -7.17800000E-05  +1.69700000E-05  -2.83602000E-03  -9.40450000E-04
   -1.39010000E-04  +4.37163700E-02  -9.86050800E-02  +6.54297000E-03  -1.80737270E-01
   +3.05752730E-01  +8.55930000E-03  -5.30826000E-03  -4.69120000E-04  +8.21770000E-04
   +1.63613000E-03  +8.68900000E-04  +6.59720000E-04  +7.39800000E-05  +4.40000000E-06
   -3.07600000E-05  -4.30140000E-04  -6.81500000E-05  -1.21860000E-04  -8.27000000E-06
   +8.84800000E-05  -7.04780000E-04  -2.94070000E-04  +5.58730000E-04  -2.50250000E-04
   -1.59820000E-04  -1.21470000E-04  +1.56880000E-04  +1.20790000E-04  -8.19800000E-05
   +1.68480000E-04  +2.08560000E-04  +1.96800000E-05  +4.51000000E-06  +2.38900000E-05
   +6.63000000E-06  -2.92540000E-04  +5.70900000E-05  +1.45400000E-04  -4.99730000E-04
   +5.05878000E-03  -9.16530300E-02  -5.36744600E-02  -5.82011300E-02  +6.56887570E-01
   +2.94332000E-03  -9.90743000E-03  +2.42459000E-02  -2.72891000E-03  -1.57967000E-03
   +2.19417000E-03  +9.33440000E-04  +9.23260000E-04  -4.70140000E-04  +9.29940000E-04
   -6.37550000E-04  -8.71400000E-05  -5.27590000E-04  +5.08160000E-04  -8.85410000E-04
   -8.54890000E-04  -1.01696000E-03  +1.03862000E-03  -3.45030000E-04  +7.16000000E-06
   +4.49740000E-04  -3.29100000E-05  +1.99700000E-05  +2.98600000E-05  -1.14537000E-03
   -6.74270000E-04  -6.81200000E-05  -7.41200000E-05  -7.32100000E-05  -3.38700000E-05
   -7.88300000E-05  -2.05390000E-04  +3.57200000E-04  -7.80893000E-02  +4.39179000E-03
   -8.51673000E-03  -6.80465000E-03  +1.22687900E-02  -2.81158300E-02  +5.87216530E-01
   -3.59389000E-03  -1.30633300E-02  +2.22765000E-02  -3.84240000E-04  +2.74500000E-05
   +1.25472000E-03  +5.19890000E-04  +3.74100000E-05  -1.79200000E-04  +1.71860000E-04
   +1.61870000E-04  -6.83000000E-05  -1.04480000E-04  +1.86580000E-04  -9.19940000E-04
   -5.51990000E-04  -5.21630000E-04  +8.46260000E-04  +3.40000000E-06  -2.80080000E-04
   -1.91880000E-04  +5.64700000E-05  +3.14800000E-05  +8.09300000E-05  -4.30190000E-04
   -3.49230000E-04  -2.67900000E-05  +3.64000000E-06  -4.34600000E-05  +2.65200000E-05
   +6.96900000E-05  -1.36280000E-04  +3.93880000E-04  +7.60545000E-03  -8.68261500E-02
   +3.32759400E-02  +6.10007000E-03  -8.48989000E-03  +1.74785200E-02  +7.30907000E-03
   +5.67787650E-01  +8.81448000E-03  +1.23199800E-02  -1.37571600E-02  -8.64760000E-04
   +1.61580000E-04  -2.65200000E-04  -3.26750000E-04  +1.05100000E-05  +8.23600000E-05
   -2.66350000E-04  +2.72040000E-04  +2.07160000E-04  +5.11450000E-04  -1.02670000E-04
   -2.13700000E-05  -7.80060000E-04  -1.65284000E-03  -2.79240000E-04  +4.95600000E-05
   +9.82500000E-05  +5.09200000E-05  -7.71400000E-05  -3.94400000E-05  -1.12850000E-04
   -1.78030000E-04  -1.78070000E-04  -4.18000000E-05  -6.72900000E-05  -7.54400000E-05
   -3.65000000E-06  +1.10900000E-04  -3.13800000E-05  +6.02200000E-05  -1.39837300E-02
   +2.81222500E-02  -1.53339270E-01  -6.03930000E-03  +3.81669000E-03  -2.19398000E-03
   -2.10657300E-02  +4.77255800E-02  +4.81263540E-01  -3.58920000E-04  -2.08778400E-02
   -1.45344800E-02  -9.60240000E-04  -5.92440000E-04  -2.56500000E-04  +4.14260000E-04
   +2.25130000E-04  +7.89000000E-06  +3.34530000E-04  +3.07000000E-06  -5.35100000E-05
   +6.47510000E-04  -1.01458000E-03  +2.37040000E-04  -4.53274000E-03  -2.29170000E-03
   +5.27060000E-04  -1.28635000E-03  -1.08486000E-03  -1.43360000E-04  -1.82000000E-05
   +1.24700000E-05  +2.69800000E-05  -5.11240000E-04  -2.62070000E-04  -3.49900000E-05
   -3.06580000E-04  -2.35420000E-04  -6.68800000E-05  -5.93100000E-05  -4.75100000E-05
   -1.95810000E-04  -7.64303500E-02  -1.73514000E-03  -2.51234000E-03  -2.20334000E-03
   +2.35395200E-02  +1.93437400E-02  +8.09100000E-05  -3.23174000E-03  -5.19170000E-03
   +5.81859350E-01  -8.50898000E-03  -2.15660400E-02  -1.02839200E-02  -6.27160000E-04
   +7.58250000E-04  -1.34890000E-04  +5.79090000E-04  -8.04890000E-04  +1.97900000E-05
   -2.78590000E-04  +4.14800000E-05  +6.76000000E-05  +4.00130000E-04  -7.70950000E-04
   +1.50240000E-04  -2.53461000E-03  -2.23030000E-04  -4.62870000E-04  +4.06170000E-04
   -3.58320000E-04  -1.36970000E-04  +5.16900000E-05  +8.34800000E-05  -2.38600000E-05
   +1.49850000E-04  +2.17000000E-05  -3.05800000E-05  -1.33830000E-04  -1.10970000E-04
   +1.66400000E-05  +9.67500000E-05  +1.17470000E-04  -1.40940000E-04  -4.05830000E-03
   -1.32037280E-01  -4.96153900E-02  +8.36215000E-03  -2.06997200E-02  -1.27128200E-02
   +4.54710000E-04  +7.65686000E-03  +2.36144000E-03  -9.66295000E-03  +5.05339340E-01
   -3.89281000E-03  +4.32744000E-03  +4.07827000E-03  +9.90360000E-04  -2.76400000E-05
   +4.72090000E-04  -6.82000000E-05  -3.89730000E-04  -7.39100000E-05  +7.20200000E-05
   +1.82940000E-04  -4.52700000E-05  -4.47480000E-04  +6.72440000E-04  -8.63000000E-06
   +2.37860000E-03  +1.83593000E-03  -4.80150000E-04  -1.79570000E-04  +4.53400000E-05
   -4.48500000E-05  +3.88900000E-05  +1.12300000E-05  -1.56800000E-05  +2.92000000E-06
   -5.35100000E-05  +1.53700000E-05  +1.69920000E-04  +1.49690000E-04  +8.06900000E-05
   -9.87100000E-05  -7.84100000E-05  +7.16300000E-05  -4.47216000E-03  -4.56450800E-02
   -1.13310630E-01  +5.89910000E-03  -3.08895000E-03  +1.18790000E-03  -3.92226000E-03
   -2.64678200E-02  -3.41552800E-02  -6.81662000E-03  -6.57199200E-02  +5.60235490E-01
   -8.84180000E-04  +1.95390000E-03  +4.39480000E-04  -7.60890000E-04  -5.78370000E-04
   +1.78500000E-05  +5.40000000E-07  +3.66760000E-04  +9.03300000E-05  +2.30000000E-06
   -8.67700000E-05  -1.16830000E-04  +1.94570000E-04  -2.46770000E-04  +1.65100000E-05
   +3.58120000E-04  +6.85000000E-06  +5.61820000E-04  +6.75100000E-05  +3.23000000E-06
   +4.64000000E-06  -3.89700000E-05  -2.07400000E-05  -4.58200000E-05  +1.56290000E-04
   +8.63700000E-05  +1.86900000E-05  +1.33300000E-05  +1.06300000E-05  +3.93700000E-05
   -5.57350000E-04  -7.75540000E-04  -2.28720000E-04  -1.49438300E-02  +6.81099000E-03
   +1.94686400E-02  -1.80737570E-01  +5.22879500E-02  +6.49700300E-02  -2.29483000E-03
   +3.67500000E-04  +7.21360000E-04  -1.63163000E-03  -8.05210000E-04  -6.69910000E-04
   +5.56887190E-01  -3.53870000E-04  -2.11513000E-03  -2.34270000E-04  +3.70360000E-04
   +4.23370000E-04  -1.43460000E-04  -3.77000000E-05  -1.60070000E-04  -8.01000000E-06
   -1.24000000E-05  -3.50000000E-06  -2.85200000E-05  -1.65240000E-04  +3.72690000E-04
   +9.17500000E-05  -5.95880000E-04  -4.08060000E-04  +8.51800000E-05  -9.39200000E-05
   -1.01000000E-05  +7.73000000E-06  +2.06700000E-05  +2.04600000E-05  +2.20900000E-05
   -1.09190000E-04  -8.47000000E-06  +6.65000000E-06  +1.59400000E-05  -4.47000000E-06
   -1.25500000E-05  -6.67980000E-04  +3.03640000E-04  +3.06580000E-04  +1.02758600E-02
   -1.22467000E-03  -1.20691800E-02  +4.16521300E-02  -8.99237100E-02  -1.85838000E-03
   +1.24655000E-03  -1.33684000E-03  -1.01407000E-03  +1.89642000E-03  -1.03593000E-03
   +2.07300000E-04  -2.33008560E-01  +2.94607540E-01  -1.88778000E-03  +9.25890000E-04
   +1.84030000E-04  -5.01540000E-04  -3.35270000E-04  -6.86100000E-05  -2.09460000E-04
   +1.22650000E-04  +2.05200000E-05  +1.09230000E-04  +1.05600000E-05  +6.38000000E-06
   -2.76410000E-04  +3.04760000E-04  +4.08200000E-05  -2.82550000E-04  -9.13090000E-04
   -1.44680000E-04  +2.30000000E-07  +4.49500000E-05  +4.86300000E-05  -6.81900000E-05
   -2.33300000E-05  +2.81000000E-06  -2.76240000E-04  -1.21550000E-04  -2.78500000E-05
   -1.24000000E-05  -5.62000000E-05  -5.34000000E-06  -7.40900000E-05  +4.73370000E-04
   +1.11250000E-04  +2.89721000E-03  -3.05597000E-03  +7.74277000E-03  +1.25360430E-01
   -3.55201700E-02  -2.57445810E-01  -2.88120000E-04  +1.62360000E-04  +4.74770000E-04
   -1.68355000E-03  +1.28621000E-03  -2.67730000E-04  -2.33467600E-02  -9.41266200E-02
   +7.19720080E-01  +4.85900000E-05  +2.46700000E-04  -1.15660000E-04  +5.09400000E-05
   -8.76800000E-05  -7.62300000E-05  -1.16000000E-04  -1.91980000E-04  -4.21100000E-05
   +2.17250000E-04  +2.17530000E-04  +1.07210000E-04  -9.83600000E-05  +1.86300000E-05
   -3.40000000E-05  -9.55400000E-05  +7.46700000E-05  -2.83250000E-04  +5.41000000E-05
   +1.84700000E-05  +5.00000000E-06  -3.32700000E-05  -1.73400000E-05  +2.64800000E-05
   -3.13660000E-04  -2.35900000E-04  -3.98400000E-05  -3.24300000E-05  -3.16600000E-05
   -4.10400000E-05  +2.79300000E-05  +7.52500000E-05  +3.07460000E-04  +2.71099000E-03
   +1.78288000E-03  +3.10540000E-03  -2.99375700E-02  +1.00161900E-02  +6.33134800E-02
   +4.26000000E-05  -2.26300000E-04  +3.56310000E-04  -1.90123000E-03  +8.55990000E-04
   -3.34990000E-04  -2.69892640E-01  +1.27140820E-01  -3.72020700E-02  +5.74914870E-01
   +1.10187000E-03  -1.10167000E-03  -7.10800000E-05  +3.00550000E-04  +4.58040000E-04
   -2.74500000E-05  +1.54400000E-04  +3.11800000E-05  -6.33000000E-06  -1.44810000E-04
   -1.63410000E-04  -7.84500000E-05  +9.65300000E-05  -2.06100000E-05  +7.49400000E-05
   +3.32780000E-04  -1.78680000E-04  +2.16750000E-04  -3.46100000E-05  +2.64000000E-06
   -2.51000000E-06  +5.01100000E-05  +3.07600000E-05  +9.77000000E-06  +2.43470000E-04
   +2.01390000E-04  +3.03000000E-05  +4.87800000E-05  +4.64500000E-05  +1.90900000E-05
   +1.06520000E-04  -1.53380000E-04  -3.66510000E-04  +2.19745000E-03  +5.68164000E-03
   +3.56860000E-04  +1.81602700E-02  +5.07656000E-03  -4.30419300E-02  +1.28480000E-04
   -1.56160000E-04  -1.51530000E-04  -5.19730000E-04  +2.83550000E-04  +1.22230000E-04
   +1.15631480E-01  -1.33221240E-01  +3.39100900E-02  -2.45354650E-01  +2.78333030E-01
   +2.40340000E-04  -1.04110000E-04  +3.25700000E-05  -2.26250000E-04  +7.80300000E-05
   -4.42000000E-06  +8.12000000E-06  +3.44900000E-05  -1.50000000E-06  +1.05630000E-04
   +7.47600000E-05  +3.43500000E-05  -4.06000000E-06  +1.09710000E-04  +1.62800000E-05
   -1.35380000E-04  -3.48420000E-04  -9.46000000E-05  +2.43000000E-05  -2.06500000E-05
   -1.81000000E-05  -1.08800000E-05  -7.10000000E-07  +6.54000000E-06  -2.01610000E-04
   -1.22050000E-04  -8.37000000E-06  -6.62000000E-06  -1.74100000E-05  -3.96500000E-05
   +6.40600000E-05  +1.90580000E-04  +9.27000000E-06  +2.43394000E-03  +7.75380000E-04
   -3.22042000E-03  +1.73735500E-02  -1.60816000E-02  +4.21543300E-02  -1.04931000E-03
   +5.93690000E-04  -3.65390000E-04  -4.01770000E-04  +3.03120000E-04  -2.42190000E-04
   +2.32034200E-02  -1.00765000E-03  -1.26584130E-01  -6.91575600E-02  -7.04081500E-02
   +7.10405390E-01  +1.70630000E-04  -7.80700000E-04  -7.92000000E-06  +5.99500000E-05
   +2.37320000E-04  -2.05620000E-04  +2.30240000E-04  +2.10610000E-04  +5.73400000E-05
   -7.93380000E-04  -5.03100000E-04  -8.23800000E-05  +4.02010000E-04  -2.89350000E-04
   -1.08560000E-04  -1.70480000E-04  +4.01900000E-04  -8.22200000E-05  -6.18300000E-05
   -2.29800000E-05  +1.11800000E-05  +7.33700000E-05  +1.00100000E-05  +1.70400000E-05
   +9.62190000E-04  +6.24490000E-04  +1.00620000E-04  +3.94700000E-05  +9.13600000E-05
   +2.92000000E-05  -3.76610000E-04  -4.73420000E-04  -5.70100000E-05  -2.05718000E-03
   +6.11480000E-04  +9.06100000E-05  +5.50050000E-04  -6.51073000E-03  +1.39473500E-02
   +3.84060000E-04  +6.29100000E-05  -2.74370000E-04  +5.57210000E-04  -4.63100000E-05
   +2.96890000E-04  -2.42338000E-03  +8.98852000E-03  -3.39858700E-02  -1.31732540E-01
   +5.02219400E-02  -7.57622400E-02  +5.82735550E-01  -1.34900000E-04  +8.05150000E-04
   -5.87700000E-05  -2.00250000E-04  -2.03660000E-04  +8.46300000E-05  -1.33440000E-04
   -8.08300000E-05  -1.35900000E-05  +4.18310000E-04  +2.93100000E-04  +6.14900000E-05
   -1.63820000E-04  +9.43800000E-05  +2.40000000E-06  +1.31430000E-04  -2.09640000E-04
   +6.93800000E-05  +6.24500000E-05  +1.18700000E-05  -4.16000000E-06  -4.83100000E-05
   -1.19600000E-05  -1.03500000E-05  -5.13640000E-04  -3.55620000E-04  -5.20300000E-05
   -3.00700000E-05  -5.09400000E-05  -2.54600000E-05  +3.09740000E-04  +1.91100000E-04
   +5.16700000E-05  +7.70610000E-04  -7.93470000E-04  +2.95130000E-04  -6.01383000E-03
   -3.92199000E-03  +7.02227000E-03  -6.91600000E-05  +1.69680000E-04  +2.33180000E-04
   -5.00930000E-04  +1.52450000E-04  -6.48900000E-05  +1.89714900E-02  -1.11322700E-02
   +1.33321200E-02  +3.61583200E-02  -1.06121400E-01  +8.64863100E-02  -2.29846530E-01
   +3.09241160E-01  +1.45530000E-04  -4.01880000E-04  -6.25900000E-05  +2.87980000E-04
   +8.78400000E-05  +1.98810000E-04  +6.25500000E-05  -2.21200000E-05  -1.67800000E-05
   -6.04000000E-06  -4.44200000E-05  -7.88100000E-05  -2.00000000E-06  -8.39800000E-05
   +2.55300000E-05  +2.41960000E-04  +2.62520000E-04  +3.26150000E-04  -2.58400000E-05
   -6.12000000E-06  -3.30000000E-07  +2.66000000E-05  +1.99300000E-05  -3.28500000E-05
   +1.22520000E-04  +8.26800000E-05  +1.40000000E-07  +1.68000000E-05  +1.31700000E-05
   +6.63700000E-05  +1.05130000E-04  -1.11980000E-04  -1.60260000E-04  +6.81660000E-04
   +3.35200000E-05  -2.23920000E-03  +1.13430700E-02  +7.82620000E-03  -8.53441200E-02
   +2.30100000E-05  -1.90600000E-05  +9.26900000E-05  +1.06810000E-03  -5.40080000E-04
   +5.53560000E-04  -8.57423800E-02  +4.35787600E-02  +3.38023800E-02  -2.98182000E-03
   +4.49964400E-02  -3.00028480E-01  -5.08301100E-02  -7.46818100E-02  +7.12117490E-01
   +1.66870000E-04  +7.54900000E-05  +1.63230000E-04  +3.03300000E-05  -7.82800000E-05
   +2.84320000E-04  -9.09000000E-06  -3.52400000E-05  -6.18600000E-05  +1.88440000E-04
   +1.38790000E-04  -3.07000000E-05  +6.37000000E-06  -8.13000000E-05  +4.92300000E-05
   +1.54010000E-04  +1.49670000E-04  +4.17920000E-04  +1.47900000E-05  -3.69000000E-06
   -1.04800000E-05  -1.10100000E-05  +4.98000000E-06  -3.68000000E-05  -1.60720000E-04
   -1.23330000E-04  -2.84400000E-05  -1.20700000E-05  -1.89200000E-05  +3.28500000E-05
   +2.53990000E-04  +6.60200000E-05  -3.26010000E-04  +4.48008000E-03  +1.08742000E-03
   -1.26196000E-03  -5.19850000E-03  +2.12511600E-02  -7.47195400E-02  -2.98690000E-04
   +4.37800000E-05  +3.59350000E-04  +2.67700000E-04  -3.40250000E-04  +3.49970000E-04
   -5.05295300E-02  +2.22869900E-02  +2.63044600E-02  +4.99588400E-02  -2.96660700E-02
   +3.28133800E-02  -1.60908980E-01  +4.11583300E-02  +5.20131400E-02  +5.80087140E-01
   +3.06860000E-04  -6.51790000E-04  +9.04000000E-06  +2.87700000E-04  +2.27530000E-04
   -1.24420000E-04  -3.41000000E-05  -1.10780000E-04  -6.45400000E-05  -3.29000000E-06
   +1.20400000E-05  +8.17000000E-05  -3.64900000E-05  +1.17550000E-04  -1.43300000E-05
   +1.58690000E-04  -6.20800000E-05  -4.86250000E-04  -3.66100000E-05  +1.44300000E-05
   +3.23000000E-06  +1.43100000E-05  +4.44000000E-06  +3.64300000E-05  -2.30700000E-05
   +1.38700000E-05  -6.52000000E-06  +2.68300000E-05  +1.87000000E-05  -8.31000000E-06
   -1.35500000E-05  -9.78400000E-05  +3.96990000E-04  +1.24591000E-03  +4.30808000E-03
   +2.40506000E-03  +1.27069700E-02  -6.41311000E-03  +3.85105400E-02  +3.28360000E-04
   +4.73700000E-05  -1.08180000E-04  -5.15630000E-04  +5.02050000E-04  -7.98100000E-05
   +2.23257000E-02  -1.40913700E-02  -1.26867900E-02  -2.20356100E-02  +2.29946000E-02
   -7.84331000E-03  +2.82275600E-02  -8.95316800E-02  +8.99067000E-03  -2.53828900E-01
   +2.96803570E-01  +9.32270000E-04  +5.98500000E-05  +3.42930000E-04  -4.85200000E-04
   +1.35860000E-04  -1.41190000E-04  +1.59880000E-04  +3.37800000E-04  +6.76400000E-05
   -4.16330000E-04  -2.75610000E-04  -2.16200000E-05  +3.90640000E-04  -7.28800000E-05
   -5.41100000E-05  -2.23150000E-04  -4.33360000E-04  -2.81380000E-04  -7.31000000E-06
   -1.54400000E-05  -1.20600000E-05  +2.14600000E-05  +1.21000000E-06  +1.15600000E-05
   +4.22090000E-04  +2.94360000E-04  +5.32000000E-05  +7.96000000E-06  +3.44100000E-05
   -1.94800000E-05  -1.20390000E-04  -8.55500000E-05  +1.92700000E-05  -5.81470000E-04
   +1.95567000E-03  -5.00927000E-03  -2.94050600E-02  +1.25769100E-02  +3.19891000E-02
   -1.46921000E-03  +8.38530000E-04  +9.14000000E-06  +3.91370000E-04  -4.12600000E-04
   -2.81440000E-04  +2.57014100E-02  -1.25518400E-02  -1.65396900E-02  -8.86700000E-03
   +1.64132500E-02  -5.07227900E-02  +1.21432650E-01  -3.11779200E-02  -2.73016720E-01
   -1.91163800E-02  -1.01607220E-01  +7.17843260E-01  +9.73800000E-04  +4.44730000E-04
   -9.08260000E-04  -4.59000000E-05  -7.32000000E-06  -1.51500000E-05  +3.69700000E-05
   +1.92700000E-05  +8.35900000E-05  +1.17960000E-04  -9.60000000E-07  +5.41100000E-05
   -9.31500000E-05  +7.51900000E-05  -1.09300000E-04  -5.08930000E-04  -4.29190000E-04
   -9.03870000E-04  +1.94300000E-05  -6.68000000E-06  -4.06800000E-05  -6.75000000E-06
   -2.01000000E-06  +1.85000000E-06  -1.15400000E-04  -7.61600000E-05  +1.29100000E-05
   +3.00000000E-08  -3.50000000E-07  -5.24500000E-05  -1.04556000E-03  -5.94010000E-04
   -5.65800000E-05  -1.00251400E-02  +1.14240900E-02  -2.50279600E-02  -1.32910900E-01
   +3.84669100E-02  -1.36642500E-02  -4.46983000E-03  +2.73700000E-03  +1.26133000E-03
   -4.71970000E-04  -4.73200000E-05  -1.61722000E-03  +5.18055400E-02  -2.34425900E-02
   -8.34926000E-03  -3.49279300E-02  +2.25991100E-02  -2.50044200E-02  -3.49755700E-02
   +8.83283000E-03  +6.69079300E-02  -2.86557030E-01  +1.36679800E-01  -3.90741300E-02
   +5.99923500E-01  -9.36140000E-04  -7.35040000E-04  +1.56110000E-04  +6.15660000E-04
   +6.46500000E-05  -7.21800000E-05  -1.51220000E-04  -2.41460000E-04  +4.98500000E-05
   +6.75100000E-05  +8.04900000E-05  -4.78400000E-05  -3.05210000E-04  +3.71310000E-04
   +1.81940000E-04  -5.59420000E-04  -5.31380000E-04  -2.23640000E-04  -5.99000000E-05
   +3.68300000E-05  +3.85000000E-05  +4.29000000E-06  +1.35200000E-05  -1.19200000E-05
   -1.73480000E-04  -5.35400000E-05  -1.58200000E-05  +2.01100000E-05  -8.64000000E-06
   -6.31000000E-06  -9.77440000E-04  +2.59970000E-04  -3.90530000E-04  +8.03300000E-03
   -6.28328000E-03  +1.34640500E-02  +4.91927400E-02  -1.08095900E-01  +4.56055900E-02
   +2.85543000E-03  -8.41500000E-04  -3.25960000E-04  +1.66875000E-03  -5.26890000E-04
   +8.11120000E-04  -3.21306100E-02  +2.38743000E-02  +1.82803500E-02  +2.41090500E-02
   -2.09349500E-02  +1.87855100E-02  +1.83092000E-02  +1.32393000E-03  -4.92165300E-02
   +1.24587220E-01  -1.40639710E-01  +3.67088900E-02  -2.34863870E-01  +2.97496930E-01
   +3.29540000E-04  -5.80370000E-04  -8.46020000E-04  +1.09331000E-03  +4.43300000E-05
   -1.92080000E-04  -5.00100000E-05  -5.93890000E-04  -2.01500000E-05  +4.03640000E-04
   +2.31630000E-04  +3.34900000E-05  -3.90340000E-04  -1.53000000E-04  -9.90200000E-05
   +3.76280000E-04  +1.29108000E-03  +1.06410000E-04  +7.31000000E-06  +5.31000000E-06
   +1.80000000E-07  +1.72100000E-05  -3.44000000E-06  +5.12800000E-05  -2.38620000E-04
   -2.27910000E-04  -3.32800000E-05  +1.10000000E-06  +1.68100000E-05  +1.37600000E-05
   -5.37160000E-04  -6.78490000E-04  -6.12900000E-05  -6.52032000E-03  +3.81386000E-03
   +4.21478000E-03  -7.33750500E-02  +7.89112300E-02  -2.67691520E-01  +1.56884000E-03
   -8.01700000E-04  +3.44180000E-04  -5.43800000E-05  -6.45750000E-04  +2.67540000E-04
   +3.73586300E-02  -8.63756000E-03  -6.13965800E-02  -2.99034700E-02  +2.12541000E-02
   -2.56934600E-02  +1.62584100E-02  -1.96834600E-02  +5.56065300E-02  +2.15390300E-02
   +1.47678000E-03  -1.34744410E-01  -8.53596500E-02  -6.18702600E-02  +6.94227470E-01
   -4.06270000E-04  +8.85000000E-05  -9.52400000E-05  +5.28200000E-05  -9.09900000E-05
   +2.72700000E-05  -4.39000000E-05  -2.38400000E-05  -5.82000000E-06  -5.34200000E-05
   -3.42500000E-05  +6.44000000E-06  -5.22600000E-05  -1.90100000E-05  -2.14900000E-05
   +4.81000000E-05  +1.86240000E-04  -3.50900000E-05  -8.34000000E-06  +5.44000000E-06
   +1.20400000E-05  -1.30000000E-06  -2.81000000E-06  -4.62000000E-06  +6.73400000E-05
   +4.47400000E-05  +1.29000000E-06  +4.62000000E-06  +5.83000000E-06  +9.71000000E-06
   +9.95300000E-05  +5.44000000E-06  +3.26500000E-05  -6.67190000E-04  -1.85906000E-03
   -7.18110000E-04  +1.03927800E-02  -6.05068000E-03  +1.42956600E-02  -3.32245000E-03
   +2.68428000E-03  +1.02409000E-03  +4.50520000E-04  -1.25000000E-06  -1.91470000E-04
   -7.61955200E-02  +3.43399800E-02  -6.90226100E-02  -4.19749000E-03  +9.29165000E-03
   -2.56057500E-02  -2.10686000E-03  +5.33160000E-03  +1.20439000E-03  -1.12723000E-03
   -1.09440000E-04  +5.04260000E-04  -1.66630000E-04  +3.21631000E-03  +4.10229000E-03
   +8.13181600E-02  -2.98570000E-04  +5.43950000E-04  +2.18600000E-04  -1.53680000E-04
   -1.72220000E-04  +6.66400000E-05  -1.31900000E-05  +1.77400000E-05  -6.86000000E-06
   +1.79700000E-05  +3.64700000E-05  +1.51800000E-05  -1.40900000E-05  -6.26200000E-05
   -5.65400000E-05  -9.34100000E-05  +1.61830000E-04  -3.95800000E-05  +1.65800000E-05
   -1.41100000E-05  -1.91000000E-06  -1.35100000E-05  -9.98000000E-06  -7.94000000E-06
   -3.21000000E-05  -4.85400000E-05  -1.34500000E-05  -1.56400000E-05  -1.71700000E-05
   +1.31300000E-05  +1.32240000E-04  -3.52400000E-05  +9.17700000E-05  -1.88902000E-03
   -2.90325000E-03  -1.97760000E-04  -1.47896000E-03  +5.86846000E-03  -4.08289000E-03
   +2.93447000E-03  -9.59670000E-04  -4.90200000E-04  +5.52260000E-04  -2.99080000E-04
   -8.54000000E-06  +3.41483000E-02  -7.41645800E-02  +8.66509400E-02  +4.35004000E-03
   -1.55593000E-03  +1.50966800E-02  +5.37105000E-03  +4.44572000E-03  +3.05990000E-04
   -1.37320000E-04  -9.94670000E-04  -5.25420000E-04  +3.26754000E-03  +5.06060000E-03
   -4.69100000E-04  -4.59205400E-02  +7.07959100E-02  +1.30890000E-04  +5.24000000E-05
   +1.71160000E-04  -1.51510000E-04  +4.27800000E-05  +6.01000000E-06  +5.80800000E-05
   +5.16000000E-05  +1.69300000E-05  -1.73700000E-05  +5.57000000E-06  -1.45300000E-05
   +9.63500000E-05  -1.26700000E-05  +1.12200000E-05  -3.72900000E-05  -1.06370000E-04
   +2.68800000E-05  +2.02700000E-05  -2.78800000E-05  -2.23400000E-05  +5.03000000E-06
   +3.95000000E-06  -3.94000000E-06  +9.37000000E-06  -2.90000000E-06  +5.63000000E-06
   -1.01000000E-06  +1.24000000E-06  -9.36000000E-06  -5.57600000E-05  -2.10900000E-05
   -8.47900000E-05  -1.86402000E-03  +5.28380000E-04  -7.13720000E-04  -9.10919000E-03
   +9.28704000E-03  -1.76136100E-02  -1.28726000E-03  +9.16550000E-04  +1.91420000E-04
   +2.49890000E-04  -4.78100000E-05  +1.17700000E-04  -6.84794300E-02  +8.59144100E-02
   -2.91610100E-01  +1.30314000E-03  -2.68010000E-04  +1.09388000E-03  +8.61600000E-04
   +5.03190000E-04  +2.29185000E-03  +6.22940000E-04  -6.51690000E-04  +4.15810000E-04
   +4.45142000E-03  -5.99790000E-04  -3.17507000E-03  +7.57189500E-02  -9.54711500E-02
   +3.07756300E-01  +4.10600000E-05  +2.73670000E-04  +9.75000000E-06  -4.62100000E-05
   -8.27200000E-05  +3.45600000E-05  -3.15000000E-05  -2.24800000E-05  -7.76000000E-06
   +8.33500000E-05  +6.30700000E-05  +1.53500000E-05  -5.01900000E-05  +9.95000000E-06
   -1.07200000E-05  -1.27000000E-05  -3.91100000E-05  -5.73000000E-06  +2.24400000E-05
   +3.26000000E-06  -4.50000000E-07  -1.31200000E-05  -5.53000000E-06  -3.77000000E-06
   -1.11330000E-04  -8.30300000E-05  -1.81700000E-05  -1.75000000E-05  -2.11700000E-05
   +3.13000000E-06  +1.88100000E-05  +4.94700000E-05  +2.91300000E-05  +1.14460000E-04
   +1.18100000E-05  +1.18935000E-03  -2.04537000E-03  +5.22529000E-03  -1.22662000E-03
   -2.43200000E-05  -9.81900000E-05  +8.30600000E-05  -3.58490000E-04  +1.08180000E-04
   -1.07270000E-04  -1.05059100E-02  +2.63534000E-03  +2.41851200E-02  -1.32832430E-01
   +3.43494500E-02  +1.24300870E-01  +5.73542000E-03  +6.74890000E-04  -8.48517000E-03
   +1.74435000E-03  +2.61598000E-03  -1.92277000E-03  -8.25380000E-04  +1.93500000E-05
   -8.75660000E-04  -3.50770000E-04  -2.10011000E-03  -6.16790000E-04  +1.37482950E-01
   +1.74530000E-04  -2.33170000E-04  -1.81200000E-05  +7.61400000E-05  +6.30500000E-05
   +2.41500000E-05  +2.74400000E-05  -2.28600000E-05  -4.68000000E-06  -4.16600000E-05
   -2.36000000E-05  -1.41000000E-06  +3.33000000E-06  -1.46000000E-06  -5.04000000E-06
   -1.11600000E-05  +3.04300000E-05  -2.27400000E-05  -5.50000000E-07  -4.86000000E-06
   -8.00000000E-08  +1.08000000E-05  +4.77000000E-06  -3.60000000E-06  +4.72800000E-05
   +2.68400000E-05  +4.08000000E-06  -4.25000000E-06  +1.85000000E-06  +4.17000000E-06
   -1.05700000E-05  -4.87000000E-06  +1.51400000E-05  +2.41360000E-04  +4.50760000E-04
   -6.10830000E-04  +5.16796000E-03  +3.44246000E-03  +1.71514000E-03  -5.44900000E-05
   -3.15000000E-05  -7.03400000E-05  +6.43800000E-05  +8.35100000E-05  +3.59200000E-05
   +7.88533000E-03  +2.37170000E-04  -1.44671900E-02  +3.41741300E-02  -4.59791300E-02
   -3.07319800E-02  -4.73918000E-03  +5.14774000E-03  +8.95774000E-03  +2.71631000E-03
   +3.56379000E-03  +2.84332000E-03  +2.75900000E-05  -1.12359000E-03  +2.95140000E-04
   -2.21440000E-03  -2.86220000E-03  -5.95880000E-04  -4.02545600E-02  +3.94907300E-02
   +9.45000000E-06  -6.12700000E-05  +1.52200000E-05  -1.05700000E-05  +2.08900000E-05
   -1.21600000E-05  +1.67400000E-05  +2.33900000E-05  +5.27000000E-06  -6.07700000E-05
   -4.17900000E-05  -6.55000000E-06  +3.07400000E-05  -1.46400000E-05  -2.68000000E-06
   -7.56000000E-06  +5.10000000E-07  -1.69200000E-05  -4.67000000E-06  -2.40000000E-07
   +1.85000000E-06  +4.80000000E-06  +1.32000000E-06  +3.90000000E-07  +7.02200000E-05
   +4.82600000E-05  +8.43000000E-06  +4.21000000E-06  +6.88000000E-06  -2.50000000E-07
   -2.29900000E-05  -2.77100000E-05  -7.64000000E-06  -2.04690000E-04  +1.51840000E-04
   +1.08070000E-04  -5.61550000E-04  +1.18975000E-03  +2.18347000E-03  +5.53300000E-05
   -2.88200000E-05  -1.79900000E-05  +2.11300000E-05  +3.41100000E-05  -3.17000000E-06
   -2.82077000E-03  +1.04799000E-03  +5.07953000E-03  +1.24437410E-01  -3.08258600E-02
   -2.47763450E-01  +2.02575300E-02  -7.52105000E-03  -1.75261000E-02  -2.60375000E-03
   +3.28162000E-03  -3.88794000E-03  -1.20265000E-03  +5.18840000E-04  -9.80100000E-05
   -1.83770000E-04  -8.44630000E-04  +8.11500000E-04  -1.36021310E-01  +3.32289800E-02
   +2.60773410E-01  -1.26750000E-04  +1.29689000E-03  -9.03500000E-05  -2.53190000E-04
   -4.19570000E-04  +2.25010000E-04  -2.76980000E-04  -2.13030000E-04  -5.26700000E-05
   +9.00730000E-04  +6.02150000E-04  +1.03860000E-04  -4.37350000E-04  +2.60920000E-04
   +7.28900000E-05  +3.37500000E-05  -4.27570000E-04  +1.62500000E-04  +1.02840000E-04
   +1.63800000E-05  -1.78700000E-05  -9.80600000E-05  -2.38200000E-05  -2.28500000E-05
   -1.11664000E-03  -7.48800000E-04  -1.15020000E-04  -6.34000000E-05  -1.18740000E-04
   -3.99300000E-05  +2.73560000E-04  +5.77230000E-04  +6.13800000E-05  +1.98532000E-03
   -1.12714000E-03  +4.99760000E-04  -2.96957000E-03  +1.86003000E-03  -3.69285000E-03
   -5.78020000E-04  +9.00700000E-05  +4.10200000E-04  -1.13797000E-03  +1.56960000E-04
   -4.98920000E-04  +2.61309000E-03  +2.88619000E-03  +4.96560000E-04  -2.38164900E-02
   +2.02479000E-02  -6.18361000E-03  -2.39962030E-01  +1.20006930E-01  -4.05407200E-02
   -3.79320700E-02  +2.44430600E-02  +6.18491000E-03  +5.05384000E-03  -7.74350000E-04
   +3.65796000E-03  -7.85090000E-04  +4.96130000E-04  -2.45050000E-04  +1.97012000E-03
   -3.31551000E-03  -4.66380000E-04  +4.27730920E-01  -8.50800000E-05  -7.32270000E-04
   +8.58900000E-05  +1.44830000E-04  +2.28930000E-04  -1.37050000E-04  +1.52140000E-04
   +1.46050000E-04  +3.50200000E-05  -5.12540000E-04  -3.70910000E-04  -6.57800000E-05
   +2.44290000E-04  -1.49900000E-04  -4.09400000E-05  +8.40000000E-07  +2.59880000E-04
   -1.11060000E-04  -7.26700000E-05  -7.99000000E-06  +1.45100000E-05  +5.50300000E-05
   +1.47800000E-05  +1.42700000E-05  +6.55770000E-04  +4.58730000E-04  +6.76200000E-05
   +5.87900000E-05  +7.75800000E-05  +3.00700000E-05  -1.74990000E-04  -3.49860000E-04
   -3.43200000E-05  -1.61381000E-03  -2.85400000E-05  -4.98790000E-04  +1.32848000E-03
   -2.24232000E-03  +6.32390000E-04  +3.16720000E-04  -5.78800000E-05  -2.43860000E-04
   +7.58510000E-04  -1.57530000E-04  +2.77380000E-04  +1.53686000E-03  +6.56485000E-03
   +2.63958000E-03  +2.70143300E-02  -6.52946000E-03  +5.61056000E-03  +1.10662950E-01
   -1.14647760E-01  +3.66826700E-02  +1.82133800E-02  -2.20971000E-03  -4.07719000E-03
   +4.10750000E-04  +4.56242000E-03  +7.50110000E-04  +7.31020000E-04  -4.20940000E-04
   +1.70100000E-04  -3.26209000E-03  -2.09105000E-03  -9.81760000E-04  -1.92107920E-01
   +1.37381750E-01  +8.29000000E-06  +2.00120000E-04  +9.87200000E-05  -1.65250000E-04
   -3.48000000E-05  -1.48600000E-05  +3.74000000E-06  +6.47400000E-05  +1.44400000E-05
   -1.47000000E-06  -1.68000000E-06  +1.35000000E-06  +4.03200000E-05  +1.48000000E-05
   +6.95000000E-06  -4.63800000E-05  -1.53400000E-04  -2.50700000E-05  +1.01100000E-05
   -2.02000000E-06  -4.47000000E-06  -7.31000000E-06  -2.83000000E-06  -1.42000000E-06
   -2.07800000E-05  -1.03400000E-05  +7.11000000E-06  -1.02000000E-06  -2.56000000E-06
   -1.59000000E-05  +1.58000000E-06  +4.21600000E-05  -1.57700000E-05  -9.42900000E-05
   -1.59000000E-04  +4.16680000E-04  -1.37042000E-03  -7.19150000E-04  +7.06272000E-03
   -5.68000000E-05  +4.08000000E-06  -2.82300000E-05  -1.69910000E-04  +4.84900000E-05
   -9.84900000E-05  +7.83220000E-03  -1.59240000E-03  -7.80812000E-03  -4.10606500E-02
   +2.55357000E-02  -6.89430000E-04  +4.46442000E-03  +1.08961600E-02  -1.12835700E-01
   +4.07973400E-02  -2.38231200E-02  +9.27864000E-03  -2.92049000E-03  +4.65140000E-03
   -1.00819600E-02  -1.33170000E-03  +7.85210000E-04  -1.19880000E-04  -1.14159000E-03
   -6.24170000E-04  +2.50495000E-03  -1.79505770E-01  -1.83982000E-03  +5.49251000E-01
   +2.01150000E-04  +1.51490000E-04  +9.30800000E-05  -1.26130000E-04  -2.96600000E-05
   +4.57000000E-06  +1.22900000E-05  +4.43400000E-05  +1.49700000E-05  -1.69500000E-05
   +1.29000000E-06  -5.20000000E-06  +3.56100000E-05  -1.31500000E-05  +6.21000000E-06
   -6.25000000E-05  -1.06610000E-04  +3.88700000E-05  +1.38100000E-05  -4.15000000E-06
   -3.73000000E-06  -5.44000000E-06  -2.47000000E-06  -5.55000000E-06  -7.85000000E-06
   -1.24100000E-05  +5.76000000E-06  -1.25000000E-05  -9.82000000E-06  -1.36800000E-05
   +2.00100000E-05  +4.23500000E-05  -2.62400000E-05  +2.70590000E-04  +2.72050000E-04
   -1.14865000E-03  -2.01379000E-03  +5.51940000E-03  +1.00802000E-03  -4.16840000E-04
   +1.48380000E-04  +8.33900000E-05  +3.71600000E-05  -1.17610000E-04  -9.31700000E-05
   -1.27854000E-03  +9.37600000E-05  +5.85180000E-04  -4.65910000E-04  +2.69814000E-03
   +3.49083000E-03  +9.44864000E-03  -5.60627000E-03  +1.59911400E-02  -8.00279900E-02
   +3.95483000E-02  -7.47248700E-02  -3.48037000E-03  +8.53545000E-03  -2.48870600E-02
   -1.45300000E-04  -3.14710000E-04  -1.46280000E-04  +3.32370000E-04  -3.60770000E-04
   +9.11170000E-04  +4.37440000E-04  -1.96165000E-03  -1.14017000E-03  +7.76783000E-02
   -1.12230000E-04  -1.12770000E-04  -3.57500000E-05  +8.22300000E-05  +1.54000000E-05
   -2.58800000E-05  -1.72000000E-06  -5.16200000E-05  +1.84000000E-06  -1.60000000E-05
   +1.31500000E-05  -4.19000000E-06  -9.31000000E-06  -1.12000000E-06  +3.26000000E-06
   -1.64100000E-05  +6.54300000E-05  +3.57900000E-05  -3.20000000E-07  -2.33000000E-06
   +2.16000000E-06  +4.30000000E-06  +6.00000000E-08  +3.27000000E-06  +1.20800000E-05
   -2.07000000E-06  +1.07000000E-06  -4.57000000E-06  -6.70000000E-07  -1.47000000E-06
   -2.95000000E-06  -6.91000000E-06  -2.22800000E-05  -4.57000000E-06  +2.19360000E-04
   +7.51280000E-04  +5.59078000E-03  +4.65543000E-03  +3.28670000E-04  +1.78220000E-04
   -1.27170000E-04  -1.09900000E-04  +5.86800000E-05  -1.42700000E-05  -4.79500000E-05
   -8.73000000E-05  -7.83700000E-04  -4.85380000E-04  +2.64670000E-03  +3.92067000E-03
   -3.81550000E-04  -1.06660000E-04  +6.02859000E-03  -4.88541000E-03  +3.89596100E-02
   -7.60160700E-02  +9.06564900E-02  +3.74236000E-03  -1.89990000E-03  +1.47197700E-02
   -3.26390000E-04  -5.41170000E-04  -4.58000000E-05  -1.23600000E-04  +1.08300000E-04
   -3.27940000E-04  -2.02929000E-03  -2.13419000E-03  -2.98170000E-04  -4.56983800E-02
   +7.05128700E-02  +1.29600000E-05  +5.61800000E-05  -7.72000000E-06  +3.00000000E-07
   -2.11200000E-05  +6.64000000E-06  -1.28200000E-05  -2.56000000E-05  -3.36000000E-06
   +3.60600000E-05  +3.63200000E-05  +4.75000000E-06  -2.26200000E-05  +6.91000000E-06
   +6.25000000E-06  -1.56500000E-05  -5.85000000E-06  +2.48300000E-05  +7.28000000E-06
   -7.30000000E-07  -2.75000000E-06  -4.15000000E-06  -1.93000000E-06  -9.80000000E-07
   -5.19800000E-05  -4.13300000E-05  -3.67000000E-06  -8.55000000E-06  -7.35000000E-06
   -7.86000000E-06  +1.69300000E-05  +3.33100000E-05  -1.62500000E-05  +2.16530000E-04
   -4.15000000E-05  +1.97700000E-05  +8.10090000E-04  +6.45490000E-04  +2.16765000E-03
   -5.61300000E-05  +2.70000000E-06  +2.33100000E-05  -5.07700000E-05  -4.19000000E-06
   -2.47800000E-05  +8.42720000E-04  -7.31330000E-04  +3.29220000E-04  +4.03668000E-03
   -7.61820000E-04  -2.72080000E-03  -1.20515100E-02  +1.14474500E-02  -1.85036700E-02
   -7.32425100E-02  +8.96869800E-02  -2.83984870E-01  +1.04050000E-03  -5.28100000E-04
   +2.86588000E-03  -1.06100000E-04  -7.16600000E-05  -5.34300000E-05  -3.86000000E-04
   +4.00180000E-04  -1.00651000E-03  -7.77220000E-04  -5.35430000E-04  +1.72507000E-03
   +8.07052300E-02  -9.88205500E-02  +2.98282190E-01  +4.21070000E-04  +7.70410000E-04
   +9.27970000E-04  -1.58649000E-03  +1.18860000E-04  -9.83500000E-05  +3.48600000E-04
   +9.35120000E-04  +1.63430000E-04  -8.36850000E-04  -6.22900000E-04  -8.07900000E-05
   +8.40070000E-04  -6.15000000E-06  -4.82200000E-05  -3.89820000E-04  -1.38627000E-03
   -3.13240000E-04  +3.95300000E-05  -4.79800000E-05  +1.53700000E-05  +2.19800000E-05
   -7.00000000E-08  -1.47000000E-06  +7.93840000E-04  +5.92450000E-04  +9.71200000E-05
   +2.79400000E-05  +4.44200000E-05  -1.88000000E-06  +1.33940000E-04  +1.17660000E-04
   +5.60700000E-05  -1.36250000E-04  -1.22267000E-03  -2.60390000E-04  +1.10507500E-02
   -1.60883000E-03  -9.34554000E-03  -2.26060000E-04  -1.96910000E-04  -2.07000000E-06
   -4.93730000E-04  +3.74040000E-04  -1.83720000E-04  +9.50600000E-04  +3.21708000E-03
   -2.39167000E-03  -5.27080000E-04  -1.45440000E-04  -8.49830000E-04  -1.10328000E-03
   +5.31456000E-03  -6.86840000E-04  -9.74093000E-03  +3.73908000E-03  +2.12773400E-02
   -1.42907920E-01  +2.92397500E-02  +1.35069870E-01  +4.62980000E-04  -1.44240000E-04
   -8.05820000E-04  -1.28310000E-04  -2.73190000E-04  -2.48200000E-05  -4.58010000E-04
   +4.68100000E-05  +1.05191000E-03  -2.95650000E-04  -2.26818000E-03  -6.20040000E-04
   +1.46877780E-01  +1.44520000E-04  +3.62850000E-04  +9.63800000E-05  -3.45890000E-04
   -8.30400000E-05  +2.42400000E-05  +1.25610000E-04  +1.94530000E-04  -1.94400000E-05
   +1.07400000E-05  -1.44600000E-04  -8.54000000E-06  -4.26400000E-05  -1.20710000E-04
   -1.74800000E-05  -9.27000000E-05  +6.54900000E-05  +1.27720000E-04  +5.31100000E-05
   -1.49800000E-05  +2.88000000E-06  -5.23000000E-06  -4.22000000E-06  -6.50000000E-07
   +4.72400000E-05  +2.01900000E-05  +1.10000000E-05  -1.52500000E-05  -9.06000000E-06
   -4.72000000E-06  +1.55770000E-04  -1.45800000E-05  -8.49400000E-05  -1.74450000E-03
   -2.09689000E-03  -4.25650000E-04  -6.21992000E-03  +6.63015000E-03  +8.90965000E-03
   -1.16830000E-04  -1.99740000E-04  -1.19500000E-04  +3.31190000E-04  -4.22390000E-04
   +6.34560000E-04  +3.20598000E-03  +4.10510000E-03  +3.09349000E-03  -1.40360000E-04
   -1.12474000E-03  +2.61050000E-04  +5.91278000E-03  +4.95202000E-03  +2.01696000E-03
   +9.82092000E-03  +2.42300000E-03  -1.39326100E-02  +2.83078200E-02  -5.31014500E-02
   -2.72702000E-02  -3.82020000E-04  +1.58560000E-04  +5.16930000E-04  -3.19380000E-04
   -5.05890000E-04  -1.28740000E-04  +4.77220000E-04  -1.67240000E-04  -8.47250000E-04
   -2.56874000E-03  -3.37350000E-03  -6.57160000E-04  -3.78082400E-02  +4.51416500E-02
   -9.46680000E-04  +6.42500000E-05  -6.52050000E-04  +1.67150000E-04  -1.05700000E-04
   +6.57000000E-05  -7.10900000E-05  -9.01300000E-05  -3.59400000E-05  -1.59100000E-05
   +4.08200000E-05  -1.22700000E-05  -6.04300000E-05  -2.13500000E-05  +1.83700000E-05
   -5.37900000E-05  +2.18850000E-04  -4.48900000E-05  -1.73000000E-05  +1.06100000E-05
   -9.51000000E-06  +5.40000000E-07  -3.07000000E-06  -6.19000000E-06  +3.62600000E-05
   +1.08500000E-05  +7.81000000E-06  +4.97000000E-06  +8.96000000E-06  +2.47000000E-06
   +1.15990000E-04  +4.54000000E-06  -5.20300000E-05  +2.35840000E-04  -1.25206000E-03
   -1.98700000E-05  +1.68446400E-02  -4.65247000E-03  -1.73876800E-02  +5.64400000E-05
   -1.39800000E-05  +3.88200000E-05  +2.33330000E-04  +1.23700000E-05  -2.44250000E-04
   -1.91689000E-03  +3.33016000E-03  -3.86058000E-03  -9.79780000E-04  +2.27510000E-04
   +3.45720000E-04  -7.58110000E-04  +2.28762000E-03  +1.43861000E-03  -3.80497000E-03
   +1.92218000E-03  +7.47789000E-03  +1.30617550E-01  -2.84603200E-02  -2.54445110E-01
   +8.23230000E-04  -3.24360000E-04  -9.44140000E-04  +1.10700000E-05  -1.70620000E-04
   -2.42900000E-05  -8.63900000E-05  -1.53400000E-05  +3.11790000E-04  -3.63340000E-04
   -1.15999000E-03  +5.74000000E-04  -1.43113140E-01  +2.82748600E-02  +2.67131800E-01
   -1.33170000E-04  -5.53580000E-04  +3.11340000E-04  -1.88420000E-04  -4.04810000E-04
   +2.61100000E-04  +3.21820000E-04  +3.91420000E-04  +2.01550000E-04  +3.25610000E-04
   -1.95900000E-04  -5.77500000E-05  -3.09380000E-04  -1.33710000E-04  +1.14000000E-05
   +2.16640000E-04  +5.71930000E-04  +1.55980000E-04  +6.21000000E-05  -5.92700000E-05
   -2.78630000E-04  -3.62000000E-06  +2.21000000E-06  +3.05000000E-06  -1.30350000E-04
   -6.53100000E-05  -2.83000000E-05  -1.53600000E-05  -8.32000000E-06  -2.66900000E-05
   +1.10900000E-05  -8.80000000E-07  -3.99000000E-05  +3.54661000E-03  +3.63358000E-03
   -2.59898000E-03  +3.12870000E-04  +2.46080000E-04  +5.02800000E-05  -2.01672950E-01
   -1.21557730E-01  +5.43453600E-02  +1.71740000E-04  +3.48780000E-04  -1.39510000E-04
   -4.45630000E-04  +1.10624000E-03  +3.43470000E-04  +7.51100000E-05  +3.64100000E-05
   -1.66220000E-04  -1.51710000E-04  +9.34000000E-06  +2.41000000E-06  +3.04900000E-05
   -2.46000000E-06  -7.77000000E-06  +1.90090000E-04  -1.03060000E-04  +8.62000000E-06
   -6.63180000E-04  +1.27051000E-03  -3.81110000E-04  +3.99400000E-05  +2.73200000E-05
   +9.47000000E-06  +9.40300000E-05  -6.03800000E-05  -1.90400000E-05  +8.67000000E-06
   -2.74800000E-05  +1.87000000E-06  -2.48200000E-05  +2.14000000E-06  +1.14400000E-05
   +2.18535610E-01  +1.05818000E-03  +1.18680000E-04  +2.99262000E-03  +2.28860000E-04
   +1.02550000E-04  -4.68300000E-05  -1.15160000E-04  -1.94940000E-04  -2.74870000E-04
   +2.70300000E-05  +3.43600000E-04  +5.41500000E-05  +4.28230000E-04  +2.09040000E-04
   -1.21550000E-04  -3.94290000E-04  -4.50280000E-04  +2.65910000E-04  -8.25200000E-05
   +6.27400000E-05  +2.18530000E-04  -2.51400000E-05  -7.45000000E-06  -5.17000000E-06
   -3.30850000E-04  -2.61920000E-04  -1.95800000E-05  -1.74800000E-05  -3.27000000E-05
   +3.40000000E-06  -4.60200000E-05  -4.95300000E-05  -1.25500000E-05  -9.02357000E-03
   -8.00299000E-03  +2.82654000E-03  -7.68660000E-04  +3.57310000E-04  -2.64520000E-04
   -1.20370030E-01  -1.40898510E-01  +4.11590900E-02  +2.01040000E-04  +2.99380000E-04
   -1.11380000E-03  +8.62100000E-05  -8.75900000E-05  +1.04489000E-03  +2.63420000E-04
   +7.46500000E-05  -4.43100000E-04  +4.67000000E-05  -5.99300000E-05  -1.27390000E-04
   -2.03960000E-04  +1.26400000E-04  -4.06300000E-05  +3.14840000E-04  -6.47100000E-05
   +1.50910000E-04  +6.71480000E-04  -1.45573000E-03  -7.30890000E-04  +6.87000000E-06
   -1.58200000E-05  +2.89000000E-05  -1.74070000E-04  +1.12200000E-04  -8.05400000E-05
   -1.55400000E-05  -1.20400000E-05  -1.37200000E-05  -1.36910000E-04  +7.51000000E-06
   -7.38900000E-05  +1.31409100E-01  +1.50517680E-01  -2.45955000E-03  +1.20412000E-03
   -4.96849000E-03  +5.29990000E-04  +2.39850000E-04  -2.34390000E-04  -1.98290000E-04
   -3.31220000E-04  +1.61820000E-04  -4.35680000E-04  +2.51420000E-04  -7.98000000E-06
   +4.37700000E-04  +4.15200000E-05  +3.62250000E-04  +2.31440000E-04  +1.51920000E-04
   -2.01080000E-04  +3.81700000E-05  -5.11000000E-05  -6.29800000E-05  +3.62400000E-05
   +7.92000000E-06  -2.01100000E-05  +4.55450000E-04  +2.76700000E-04  +3.08800000E-05
   +5.01700000E-05  +4.51700000E-05  +2.63200000E-05  -1.13000000E-05  +9.33100000E-05
   -1.87120000E-04  +2.32353100E-02  +1.73073700E-02  -8.87063000E-03  +6.69320000E-04
   -6.86150000E-04  +9.46280000E-04  +5.35147500E-02  +4.05225500E-02  -6.60286800E-02
   +1.11439000E-03  +8.63780000E-04  +1.39426000E-03  -1.15010000E-04  -1.23460000E-04
   +4.67360000E-04  -2.49940000E-04  +7.57900000E-05  -8.08700000E-05  -1.36140000E-04
   +3.90900000E-05  +2.76490000E-04  +2.47080000E-04  -1.18140000E-04  -3.37500000E-05
   -2.30400000E-04  -1.58300000E-04  -3.60420000E-04  -2.21900000E-05  -1.05840000E-04
   +1.94980000E-04  +1.20000000E-05  +1.45900000E-05  -2.87000000E-06  +1.13210000E-04
   -6.55600000E-05  -2.00200000E-05  +3.62700000E-05  +2.89700000E-05  +5.48000000E-06
   +1.16630000E-04  +3.97300000E-05  +1.42100000E-05  -5.88983100E-02  -4.69886700E-02
   +7.17451600E-02  -8.35600000E-05  +3.48270000E-04  +6.60930000E-04  +2.11270000E-04
   +4.74160000E-04  +4.84000000E-06  -1.44830000E-04  -2.37290000E-04  -1.52350000E-04
   -1.25560000E-04  +4.95100000E-05  +7.84000000E-06  -1.71800000E-05  -4.27000000E-06
   -3.21800000E-05  +1.76500000E-04  -1.56360000E-04  +6.45000000E-05  +9.75500000E-05
   -6.66400000E-05  +1.21000000E-06  +2.00000000E-06  +2.93000000E-06  +2.10300000E-05
   +2.72800000E-05  +9.29000000E-06  -1.37900000E-05  +1.76300000E-05  +3.78000000E-06
   +1.76700000E-05  +1.87100000E-05  +6.74200000E-05  -8.27000000E-06  -1.96781000E-03
   -3.93840000E-03  -2.29841000E-03  +2.99410000E-04  -4.13810000E-04  +1.25800000E-05
   -5.00711500E-02  -1.97457300E-02  -1.77063800E-02  -1.60270000E-04  +6.68770000E-04
   -8.62210000E-04  -5.65800000E-04  +1.89560000E-04  -1.01181000E-03  -4.42300000E-05
   +2.13900000E-05  +3.35510000E-04  -3.90700000E-05  +3.06400000E-05  +3.38900000E-05
   +1.05920000E-04  -6.65400000E-05  +4.13100000E-05  -8.22100000E-05  +1.02910000E-04
   +4.52700000E-05  -2.54918000E-03  +4.39950000E-04  -6.00500000E-05  -1.81300000E-05
   -1.56100000E-05  -2.64500000E-05  +1.27710000E-04  -8.26800000E-05  +6.29100000E-05
   +3.89000000E-06  -7.84000000E-06  +9.17000000E-06  +6.12300000E-05  -4.64100000E-05
   +4.95100000E-05  -1.86159000E-03  -1.72529700E-02  -1.74053000E-02  +5.20371300E-02
   -2.73590000E-04  +9.33960000E-04  +6.63170000E-04  +2.91520000E-04  -2.38120000E-04
   -1.38770000E-04  +1.48000000E-06  +6.69400000E-05  +1.75900000E-05  -3.39800000E-05
   -4.87300000E-05  -2.19700000E-05  -3.35900000E-05  -7.81000000E-06  +1.25000000E-05
   +6.74100000E-05  +1.80420000E-04  +7.40500000E-05  -6.62700000E-05  +3.82000000E-05
   +2.90300000E-05  +3.36000000E-06  -5.30000000E-06  -2.38600000E-05  +1.11570000E-04
   +7.68700000E-05  +3.01800000E-05  +9.83000000E-06  +1.51100000E-05  +1.25200000E-05
   +6.36200000E-05  -2.87500000E-05  +1.12000000E-05  +5.66680000E-04  +9.12564000E-03
   +8.41769000E-03  +7.86100000E-05  +3.38090000E-04  -4.44200000E-04  -2.04521200E-02
   -1.92299830E-01  -1.31813470E-01  +3.55740000E-04  -2.69200000E-04  +1.51204000E-03
   +1.10184000E-03  +7.73900000E-05  -7.52730000E-04  -3.64000000E-06  -5.35300000E-05
   +4.49830000E-04  +1.13690000E-04  -1.14230000E-04  -1.48130000E-04  -7.41200000E-05
   +2.93100000E-05  +4.87200000E-05  -2.15230000E-04  +3.51000000E-06  +7.04100000E-05
   +9.97880000E-04  -2.49540000E-04  +6.60830000E-04  +4.18000000E-06  +4.16100000E-05
   -8.43000000E-06  -4.93500000E-05  +1.26800000E-05  +6.62900000E-05  -1.33400000E-05
   +1.42500000E-05  +4.48000000E-06  +2.89200000E-05  +4.14000000E-06  +2.88700000E-05
   +2.26320000E-04  -1.27699500E-02  -1.19661200E-02  +1.99502200E-02  +2.06696650E-01
   -1.08185000E-03  -9.98660000E-04  +8.28930000E-04  +1.71200000E-04  +1.10900000E-04
   -1.85000000E-05  -1.25400000E-05  -1.84000000E-06  -6.48000000E-05  -1.71300000E-04
   +2.55680000E-04  -2.40800000E-05  +6.47210000E-04  +3.00850000E-04  +8.84600000E-05
   -3.10300000E-05  -4.69890000E-04  +8.78100000E-05  -1.55460000E-04  +2.45000000E-05
   +4.99900000E-05  +1.58900000E-05  +6.91000000E-06  +1.12800000E-05  -2.70700000E-05
   -1.92600000E-05  +1.19500000E-05  +3.40900000E-05  +1.70100000E-05  -5.03000000E-06
   -7.90000000E-05  +1.17420000E-04  -1.24870000E-04  -1.48311000E-03  -2.25678300E-02
   -1.82463900E-02  +9.82710000E-04  -6.73310000E-04  +7.67800000E-04  -1.76495000E-02
   -1.30184930E-01  -1.67153340E-01  -8.13400000E-04  +3.89468000E-03  -5.91440000E-03
   +4.31490000E-04  +2.14900000E-04  -1.28400000E-04  -2.30910000E-04  +1.60830000E-04
   +2.72610000E-04  -1.49500000E-05  -1.02280000E-04  +2.02950000E-04  +1.83300000E-04
   -1.06990000E-04  -9.00000000E-08  -5.86500000E-05  +3.73800000E-04  -1.24720000E-04
   -3.06400000E-04  -1.26210000E-04  +6.55700000E-04  -2.01900000E-05  +2.19200000E-05
   -1.21900000E-05  +5.60000000E-06  -5.28000000E-06  +2.41100000E-05  -2.77900000E-05
   -2.23300000E-05  -9.17000000E-06  -1.34700000E-05  -1.21770000E-04  +7.96600000E-05
   +5.25490000E-04  +7.34706000E-03  +6.49081000E-03  +1.91968700E-02  +1.43038930E-01
   +1.83286190E-01  +4.35840000E-04  -1.32331000E-03  +5.02000000E-04  -5.44460000E-04
   -5.61990000E-04  +8.58120000E-04  +1.48110000E-04  +2.08560000E-04  +1.55890000E-04
   +9.15000000E-05  -1.85790000E-04  -1.12410000E-04  -1.93500000E-04  -1.70820000E-04
   -3.41000000E-06  +1.18480000E-04  +3.76570000E-04  +1.20400000E-05  -1.73700000E-05
   -1.96350000E-04  +3.58590000E-04  +2.32200000E-05  +8.30000000E-06  +4.25600000E-05
   +8.43000000E-05  +7.22700000E-05  +1.16200000E-05  -9.80000000E-07  +1.47400000E-05
   -1.46400000E-05  -1.79900000E-05  -3.44800000E-05  -1.41400000E-05  -5.12246000E-03
   +2.04865000E-03  +5.87760000E-04  +7.18160000E-04  +1.90480000E-04  -9.24070000E-04
   -2.37469860E-01  +1.23432790E-01  -7.58070000E-04  -3.19000000E-06  +1.16560000E-04
   +7.85700000E-04  +7.09900000E-05  +1.32200000E-04  +3.37100000E-04  +1.69940000E-04
   +7.89800000E-05  -2.12020000E-04  +1.97270000E-04  -1.04900000E-04  -1.01550000E-04
   -2.13770000E-04  +7.40000000E-05  -1.07030000E-04  -1.51000000E-06  +2.41380000E-04
   +3.60340000E-04  -1.45210000E-04  -1.43180000E-04  -5.28860000E-04  -2.42000000E-05
   +2.37300000E-05  +2.56900000E-05  -2.92420000E-04  +1.52040000E-04  -4.46700000E-05
   -6.22400000E-05  -1.03600000E-05  -1.42900000E-05  -2.98800000E-05  +3.07400000E-05
   -3.58600000E-05  -1.88153400E-02  +1.37609800E-02  -1.61260000E-04  +3.52217000E-03
   -2.91801000E-03  +1.51680000E-04  +2.56528020E-01  +1.02847000E-03  +2.88390000E-04
   -4.42350000E-04  +2.39040000E-04  -1.00790000E-04  -2.22200000E-05  -4.57890000E-04
   -3.25630000E-04  -2.51360000E-04  -1.85560000E-04  +1.06870000E-04  +8.75500000E-05
   +2.14160000E-04  +1.47170000E-04  +8.63500000E-05  -2.01420000E-04  -3.52580000E-04
   +3.58200000E-05  -1.43060000E-04  +2.21000000E-04  +3.26430000E-04  -2.33500000E-05
   -1.28200000E-05  +2.27200000E-05  +2.46500000E-05  +4.63900000E-05  +3.25000000E-06
   +2.59000000E-06  +1.06600000E-05  -1.59200000E-05  +1.44000000E-05  +1.45370000E-04
   -4.08900000E-05  +9.79291000E-03  -8.05288000E-03  -1.28550000E-04  -4.89390000E-04
   -5.26800000E-05  +2.22296000E-03  +1.22249870E-01  -1.26325640E-01  +1.35190000E-04
   -7.65810000E-04  +3.85740000E-04  -1.22758000E-03  -7.90300000E-05  +4.04110000E-04
   +1.26390000E-04  +1.12810000E-04  +2.81600000E-05  +1.48770000E-04  -1.65100000E-04
   +6.38000000E-05  -6.14400000E-05  +1.70200000E-05  -9.78500000E-05  +2.46890000E-04
   +7.77040000E-04  -9.14400000E-05  -2.45370000E-04  -3.21260000E-04  -2.25470000E-04
   +8.29800000E-05  +4.75200000E-05  +4.88000000E-06  -9.66000000E-06  +2.03250000E-04
   -1.41270000E-04  +2.51700000E-05  +4.66700000E-05  -8.13200000E-05  +1.14000000E-06
   +7.63200000E-05  +3.70000000E-05  +2.18000000E-05  -1.65840900E-02  +1.15988400E-02
   -2.73640000E-04  +1.99349300E-02  -1.24725600E-02  +7.15440000E-04  -1.34741220E-01
   +1.34402420E-01  -9.05380000E-04  -4.01080000E-04  +7.24450000E-04  -2.42330000E-04
   +8.25070000E-04  +2.67000000E-06  +3.72090000E-04  +1.74480000E-04  -9.55000000E-06
   +2.47350000E-04  -3.24690000E-04  -5.78600000E-05  -3.45410000E-04  -8.55100000E-05
   -1.63400000E-05  +2.61090000E-04  +1.71910000E-04  +3.55200000E-05  +4.86740000E-04
   -3.12200000E-05  -6.66160000E-04  +1.84000000E-06  +2.39500000E-05  +1.38300000E-05
   -1.15260000E-04  -7.30200000E-05  -3.20400000E-05  -1.90000000E-06  -4.19000000E-06
   -2.87000000E-06  -2.58700000E-05  -3.96400000E-05  -2.23000000E-05  -2.55286000E-02
   +1.64325900E-02  -2.05619000E-03  +6.77240000E-04  +1.47983000E-03  -5.82163000E-03
   +1.43964000E-03  -1.48110000E-03  -4.57369800E-02  -1.08578000E-03  +1.24552000E-03
   +1.48310000E-03  +8.33980000E-04  -2.75260000E-04  -1.13133000E-03  -1.83310000E-04
   +6.08500000E-05  +4.08380000E-04  +2.17290000E-04  -1.15550000E-04  -8.60000000E-07
   -6.91000000E-05  +4.25400000E-05  -4.43460000E-04  -1.60617000E-03  +9.70080000E-04
   +4.60590000E-04  +1.15040000E-04  -3.00090000E-04  +7.07020000E-04  -3.86000000E-05
   +2.30700000E-05  -4.66000000E-06  -1.46670000E-04  +7.00300000E-05  +6.11000000E-05
   -1.49860000E-04  +5.95800000E-05  -1.28800000E-05  -8.84000000E-06  +9.61000000E-06
   +5.29800000E-05  +6.50301000E-03  -5.27963000E-03  -7.78160000E-04  +1.90387200E-02
   -1.07219800E-02  +1.37530000E-04  -4.95400000E-04  -1.65664000E-03  +5.33863700E-02
   +5.38960000E-04  +9.14000000E-06  -1.18530000E-04  -6.90800000E-05  +2.03530000E-04
   +5.56800000E-05  +1.41540000E-04  -2.49100000E-04  -1.13810000E-04  +1.04660000E-04
   +1.01710000E-04  +2.44200000E-05  -1.59500000E-05  -1.13080000E-04  -2.32500000E-05
   -3.46900000E-05  +2.64560000E-04  -2.85900000E-05  +4.81600000E-04  -1.23020000E-04
   +9.07800000E-05  -1.19300000E-05  +5.16000000E-06  -1.34000000E-06  -1.66890000E-04
   -1.71780000E-04  -2.45500000E-05  -2.40700000E-05  -2.67700000E-05  +6.68000000E-06
   +6.19400000E-05  -6.09300000E-05  +5.50000000E-07  -2.08957000E-03  +1.32150000E-04
   +1.09327000E-03  +5.79680000E-04  +1.30467000E-03  -1.49070000E-04  -1.50700000E-04
   +2.44370000E-04  +2.74380000E-04  -2.19380910E-01  -1.18373380E-01  +5.27377300E-02
   +3.78080000E-04  -1.61840000E-04  +3.55300000E-05  -2.47000000E-05  -3.08500000E-05
   -1.13090000E-04  -5.07700000E-05  -1.05000000E-05  +2.59000000E-05  -4.84800000E-05
   -9.37500000E-05  -1.81400000E-05  +2.08530000E-04  +1.04400000E-05  +1.50490000E-04
   +2.44500000E-05  +1.21000000E-06  -2.03300000E-05  +1.96000000E-05  -1.84200000E-05
   -3.60000000E-06  +4.25700000E-05  +4.95000000E-06  -2.19000000E-06  +7.60000000E-07
   -8.96000000E-06  +1.40000000E-07  +7.00000000E-06  +3.75000000E-05  -3.09200000E-05
   +2.39010000E-04  +4.20700000E-05  -5.95980000E-04  +2.58880000E-04  +2.63170000E-04
   -1.02360000E-04  -4.51500000E-05  -1.22790000E-04  +5.68500000E-05  +2.35611570E-01
   +1.88878000E-03  -2.98360000E-03  -2.98421000E-03  +3.86030000E-04  -2.04430000E-04
   +1.10980000E-04  -1.12740000E-04  +2.69940000E-04  +3.99800000E-05  +3.11900000E-04
   +5.80100000E-05  -3.13000000E-06  +1.27440000E-04  -3.68600000E-04  +5.84700000E-05
   -1.52166000E-03  -6.42160000E-04  +1.41070000E-04  -2.24550000E-04  +1.65980000E-04
   +2.41900000E-05  -4.07900000E-05  -2.33200000E-05  +8.61000000E-06  -3.13400000E-04
   -1.57840000E-04  -2.86200000E-05  -1.21250000E-04  -9.58300000E-05  -2.73900000E-05
   -1.29100000E-05  -1.82500000E-05  -6.41600000E-05  -2.07652900E-02  -1.63931000E-02
   +5.85018000E-03  -1.31673000E-03  +7.00810000E-04  +4.22860000E-04  +4.55400000E-05
   +5.55120000E-04  +1.37655000E-03  -1.16025330E-01  -1.25270800E-01  +3.67217600E-02
   +4.76520000E-04  +4.22900000E-05  -1.95620000E-04  -9.47300000E-05  +4.22100000E-05
   -1.97870000E-04  +1.75150000E-04  -1.86910000E-04  +1.40660000E-04  +1.28720000E-04
   -1.78100000E-05  +2.88800000E-05  +2.13090000E-04  +1.62600000E-05  +4.07320000E-04
   -1.88600000E-05  -1.34500000E-05  -1.33300000E-05  -1.41500000E-05  -1.16800000E-05
   +7.36000000E-06  -2.40440000E-04  +1.75870000E-04  -3.16400000E-05  -8.88000000E-06
   -1.82600000E-05  -8.40000000E-06  -2.42710000E-04  +3.12300000E-05  -6.29100000E-05
   +1.24840000E-04  +5.31680000E-04  -5.53190000E-04  +3.60430000E-04  +9.96800000E-05
   +6.80800000E-05  +1.18620000E-04  +2.29000000E-05  -1.20770000E-04  +1.28573370E-01
   +1.38130350E-01  +8.97660000E-04  -2.60768000E-03  -1.90582000E-03  -4.18990000E-04
   -1.99120000E-04  -1.89100000E-05  +8.52900000E-05  +2.78560000E-04  +8.11000000E-06
   -1.81630000E-04  -1.02460000E-04  -2.86100000E-05  +4.06830000E-04  -2.48600000E-04
   +2.57600000E-05  -1.14318000E-03  -1.02832000E-03  +1.33180000E-04  +8.27100000E-05
   +1.16320000E-04  -3.08700000E-05  -1.25300000E-05  -5.12000000E-06  +1.42000000E-06
   +8.22000000E-05  +7.71300000E-05  +1.67800000E-05  -6.58700000E-05  -4.58600000E-05
   -2.80100000E-05  -1.55700000E-05  +2.70100000E-05  -3.02800000E-05  -1.67897900E-02
   -1.20630800E-02  +2.89228000E-03  -5.08270000E-04  +3.01140000E-04  +6.22040000E-04
   -9.67490000E-04  -5.27000000E-04  +1.09269000E-03  +5.40753000E-02  +3.79274000E-02
   -6.44929300E-02  -9.31400000E-05  +2.30000000E-04  +3.51800000E-05  +8.18000000E-05
   -6.40300000E-05  -3.69700000E-05  +6.92300000E-05  -1.17700000E-05  -9.66700000E-05
   -2.75300000E-04  -1.29200000E-05  +1.21560000E-04  +1.43480000E-04  -4.11500000E-05
   -1.61780000E-04  +2.78100000E-05  -3.45200000E-05  -5.00600000E-05  -1.36900000E-05
   -6.09000000E-06  +5.60000000E-06  -1.30660000E-04  +7.42000000E-05  -5.87000000E-06
   +4.47000000E-06  +1.82100000E-05  -8.44000000E-06  +1.69020000E-04  -1.57000000E-05
   +2.67500000E-05  +1.97200000E-04  -9.19800000E-05  -6.10400000E-04  +2.15240000E-04
   +2.19050000E-04  +2.18570000E-04  -2.08700000E-05  +4.36400000E-05  -6.04100000E-05
   -5.88833900E-02  -3.65861600E-02  +6.76776400E-02  -3.55960000E-04  +9.55100000E-05
   +4.61240000E-04  -1.14419000E-03  -8.24830000E-04  -3.53060000E-04  +1.87130000E-04
   -2.42120000E-04  -6.07900000E-05  -1.77910000E-04  -6.57000000E-06  +2.86200000E-05
   +6.26200000E-05  -1.22000000E-06  -2.05800000E-05  +1.02710000E-04  +1.40610000E-04
   -1.92200000E-05  -1.14703000E-03  -1.72203000E-03  -4.54050000E-04  +1.29700000E-05
   +1.86500000E-05  -1.77100000E-05  +1.17240000E-04  +1.76700000E-05  +9.14000000E-06
   +1.55000000E-05  +1.43600000E-05  +2.38000000E-06  -2.89400000E-05  -3.20600000E-05
   -1.16900000E-05  +1.67571000E-03  -1.97730000E-03  -1.37460000E-04  +4.32050000E-04
   +4.33370000E-04  +1.77290000E-04  +2.68600000E-04  -3.57680000E-04  -2.38370000E-04
   -2.22506670E-01  +1.25504030E-01  -1.81003500E-02  +7.33220000E-04  -3.99000000E-06
   -4.28820000E-04  -2.64000000E-04  +1.59760000E-04  -1.90050000E-04  +2.59850000E-04
   -2.10260000E-04  +2.54990000E-04  +1.09780000E-04  -6.11700000E-05  +5.38500000E-05
   +1.54760000E-04  +5.28700000E-05  +3.07220000E-04  -2.31500000E-05  -3.09900000E-05
   +7.36600000E-05  -3.51400000E-05  -4.20000000E-06  +5.79000000E-06  -3.38100000E-04
   +2.03810000E-04  -2.89200000E-05  -1.62600000E-05  +3.73000000E-06  -1.35500000E-05
   -1.07060000E-04  -8.57700000E-05  +3.13800000E-05  -1.37340000E-04  +1.47880000E-04
   +6.60000000E-07  +2.18590000E-04  -2.37410000E-04  +9.73000000E-05  +3.99150000E-04
   -6.36200000E-05  +3.37880000E-04  -1.98140200E-02  +1.55192700E-02  -3.16827000E-03
   +2.42982670E-01  +8.83320000E-04  +6.97560000E-04  +1.81540000E-04  +4.22550000E-04
   -1.01904000E-03  -2.24210000E-04  -4.02880000E-04  +4.80510000E-04  +1.40130000E-04
   +3.98500000E-05  -5.89900000E-05  -7.69000000E-06  +4.71300000E-05  +1.72530000E-04
   +8.57000000E-06  -2.00940000E-04  -1.31900000E-04  +1.26100000E-04  -1.73852000E-03
   -1.14710000E-04  -2.33830000E-04  -1.84400000E-05  -3.17300000E-05  -1.70000000E-07
   +3.70100000E-05  +1.54010000E-04  +2.32800000E-05  -9.80000000E-07  +1.32300000E-05
   -1.57100000E-05  +6.76100000E-05  +1.60850000E-04  +2.99300000E-05  +2.11994100E-02
   -1.43201500E-02  +2.89253000E-03  -9.79130000E-04  -2.87276000E-03  -3.90283000E-03
   +4.42300000E-04  +6.29710000E-04  +1.66634000E-03  +1.23771980E-01  -1.35842280E-01
   +1.24483600E-02  +2.65600000E-04  -6.50580000E-04  +6.30930000E-04  +6.42710000E-04
   -3.46200000E-05  +1.06860000E-04  -3.36280000E-04  +2.10420000E-04  -4.49610000E-04
   -8.81600000E-05  +7.25400000E-05  -3.18700000E-05  +2.02230000E-04  +1.14000000E-06
   -2.41050000E-04  -7.47200000E-05  -8.03000000E-05  -1.09060000E-04  +1.53460000E-04
   -4.66000000E-06  -5.10000000E-07  +5.16490000E-04  -3.14900000E-04  +6.85800000E-05
   +3.39800000E-05  -3.40000000E-05  +2.70500000E-05  +2.52700000E-05  +2.12870000E-04
   -5.19300000E-05  -1.15800000E-04  -1.66100000E-05  -8.39700000E-05  -3.46890000E-04
   +1.02720000E-04  +1.91770000E-04  -4.53530000E-04  +5.47310000E-04  -5.86780000E-04
   -1.46055600E-02  +1.12584100E-02  -2.06552000E-03  -1.36660850E-01  +1.46416630E-01
   -2.75820000E-04  +5.56480000E-04  +4.90920000E-04  -5.82000000E-06  +4.53000000E-06
   -9.35100000E-05  -7.42500000E-05  -4.11000000E-05  -8.89000000E-06  -5.36200000E-05
   +5.43400000E-05  +7.72400000E-05  +3.24200000E-05  +2.98300000E-05  -1.85400000E-05
   +1.05830000E-04  +1.89600000E-05  +1.72000000E-05  -3.24900000E-04  -2.22330000E-04
   +4.94300000E-04  -4.36000000E-06  -3.69000000E-06  -5.16000000E-06  +2.77000000E-05
   +1.27600000E-05  -1.32700000E-05  +7.59000000E-06  +2.48000000E-06  -7.49000000E-06
   +2.52300000E-05  +2.42700000E-05  +7.68000000E-06  +1.71353400E-02  -1.10313700E-02
   -2.11840000E-04  -1.18039000E-03  -2.74766000E-03  -2.38632000E-03  +1.35743000E-03
   -7.23920000E-04  +9.46780000E-04  -1.92066900E-02  +1.36799500E-02  -4.94021000E-02
   +5.43390000E-04  -4.37890000E-04  +2.21970000E-04  +2.17300000E-04  +2.45740000E-04
   +1.40450000E-04  -2.20420000E-04  +9.53700000E-05  -3.13700000E-05  +3.15850000E-04
   +1.07730000E-04  +4.56100000E-05  -1.33000000E-06  +3.61230000E-04  -2.70930000E-04
   -5.10300000E-05  -1.59120000E-04  -4.00200000E-05  +6.11600000E-05  -3.22900000E-05
   -9.01000000E-06  +2.93740000E-04  -2.30470000E-04  +3.97400000E-05  +3.08800000E-05
   +6.70000000E-07  +1.10700000E-05  -8.19000000E-05  -4.77160000E-04  +2.45080000E-04
   +6.84600000E-05  +5.95900000E-05  -8.44000000E-05  -1.01070000E-04  +2.42980000E-04
   +2.90030000E-04  -4.86320000E-04  -1.80380000E-04  -6.53480000E-04  +6.58390000E-03
   -5.16977000E-03  -1.90870000E-04  +2.10842100E-02  -1.07405500E-02  +5.07430000E-02
   +8.42470000E-04  +6.33230000E-04  -1.98470000E-04  -8.60680000E-04  +1.55610000E-04
   +9.30000000E-05  +7.58900000E-05  +2.21700000E-04  +6.87100000E-05  -4.76510000E-04
   -1.02930000E-04  -3.18100000E-05  +5.36450000E-04  +4.01400000E-05  +7.22000000E-06
   -2.06450000E-04  -7.86370000E-04  -1.36420000E-04  +1.60330000E-04  +9.71600000E-05
   -1.88770000E-04  +1.27500000E-05  +4.84000000E-06  -6.58000000E-06  +3.42600000E-04
   +2.30470000E-04  +4.46900000E-05  +1.50300000E-05  +1.84300000E-05  -1.20600000E-05
   +8.67000000E-06  +6.04000000E-05  +1.26400000E-05  -1.91710000E-03  +4.23540000E-04
   -2.03391000E-03  +1.91500000E-05  -5.12000000E-04  +3.83350000E-04  -1.61810000E-04
   -6.69280000E-04  -5.56800000E-04  -4.93220700E-02  +7.94367000E-03  -2.11250300E-02
   -1.44010000E-04  +1.07850000E-04  +1.13700000E-05  +1.97210000E-04  -7.15900000E-05
   +2.70500000E-05  -7.37000000E-05  +7.37000000E-05  -1.05950000E-04  -1.77470000E-04
   +3.71000000E-06  -6.24800000E-05  -4.88600000E-04  +4.51260000E-04  +4.37860000E-04
   +6.08000000E-06  -1.27300000E-05  -4.60200000E-05  +9.26000000E-06  -1.08500000E-05
   -1.15900000E-05  +9.99400000E-05  -6.30800000E-05  -8.74000000E-06  +1.10900000E-05
   +2.27800000E-05  +7.19000000E-06  +1.87070000E-04  +1.02482000E-03  -1.13740000E-04
   +1.30560000E-04  +2.09130000E-04  -2.56800000E-04  +6.53790000E-04  +6.09800000E-05
   -3.64760000E-04  +3.48130000E-04  -2.29960000E-04  +3.12690000E-04  +3.05699000E-03
   -7.21335000E-03  +2.54533200E-02  -1.81854000E-03  +7.79526000E-03  -2.60580400E-02
   +4.94659800E-02  +7.85520000E-04  +1.94231000E-03  +7.57030000E-04  -8.17180000E-04
   +3.70600000E-05  -6.95500000E-05  +9.03800000E-05  +4.31090000E-04  +3.43400000E-05
   -4.77320000E-04  -1.31530000E-04  -1.37500000E-05  +5.96970000E-04  +5.56200000E-05
   -5.74800000E-05  -1.02780000E-04  -8.74280000E-04  -6.08200000E-05  -9.62000000E-06
   -5.15900000E-05  +7.69400000E-05  +4.74000000E-06  -5.91000000E-06  -1.12100000E-05
   +3.58970000E-04  +2.37470000E-04  +4.52500000E-05  +1.78400000E-05  +2.51700000E-05
   -1.42800000E-05  -1.01200000E-05  +5.42000000E-06  +8.80000000E-06  -2.21292000E-03
   +8.09006000E-03  -2.45417100E-02  -7.34630000E-04  +1.13026000E-03  +3.89280000E-04
   -4.01880000E-04  -4.36532000E-03  -3.14520000E-03  +8.96195000E-03  -7.32489900E-02
   +8.39145000E-02  +3.01000000E-04  +1.25900000E-05  -9.76600000E-05  -2.34890000E-04
   +1.18330000E-04  -7.54700000E-05  +2.04900000E-05  +2.18900000E-05  +2.38750000E-04
   +1.06740000E-04  -1.09180000E-04  +1.97950000E-04  +5.60380000E-04  -7.37630000E-04
   -5.81160000E-04  -8.20800000E-05  +6.91000000E-06  +4.80700000E-05  -1.80600000E-05
   -1.21500000E-05  -2.14000000E-06  -9.59900000E-05  +3.40400000E-05  +6.55000000E-06
   +5.68000000E-06  -1.39500000E-05  -1.46600000E-05  +1.00779000E-03  -1.69828000E-03
   +2.56100000E-05  +2.01620000E-04  -7.15800000E-05  +2.39900000E-05  -2.76160000E-04
   +6.08230000E-04  -1.76904000E-03  -2.13880000E-04  -4.42500000E-05  +1.49000000E-06
   +2.89823000E-03  -5.35083000E-03  +1.50921200E-02  +1.45130000E-04  -5.66153000E-03
   +1.67900800E-02  -9.62316000E-03  +8.08756600E-02  +8.15520000E-04  +9.75330000E-04
   +1.80020000E-04  -3.51400000E-04  -6.18200000E-05  -6.60000000E-05  +1.68100000E-05
   +6.81600000E-05  -8.50000000E-06  -4.10900000E-05  +2.20100000E-05  -6.55000000E-06
   +1.26280000E-04  +2.16300000E-05  -3.07200000E-05  -6.40400000E-05  -2.57610000E-04
   -7.68000000E-06  -9.60000000E-07  -4.37900000E-05  -7.87600000E-05  -5.68000000E-06
   -3.35000000E-06  -7.99000000E-06  -9.11000000E-06  -1.56200000E-05  +1.00800000E-05
   -1.91000000E-06  +9.90000000E-07  -9.65000000E-06  -2.74600000E-05  -4.66000000E-06
   +1.00000000E-07  -1.89173000E-03  +5.87453000E-03  -1.75295300E-02  -9.16510000E-04
   +5.58210000E-04  +3.67490000E-04  -1.69810000E-04  -4.14794000E-03  -1.86796000E-03
   -2.29402400E-02  +7.92174500E-02  -3.01204040E-01  +4.37950000E-04  -6.48000000E-05
   -2.66600000E-04  -3.23490000E-04  +1.93380000E-04  -9.75000000E-06  -7.83100000E-05
   -9.65200000E-05  +2.96820000E-04  +3.77830000E-04  -7.57300000E-05  +2.19480000E-04
   -7.41300000E-05  +7.93940000E-04  -3.10290000E-04  -9.76800000E-05  +2.58800000E-05
   +8.62000000E-05  -1.19500000E-05  -1.83700000E-05  -6.51000000E-06  -3.32000000E-05
   +4.86000000E-06  +1.64300000E-05  +2.87600000E-05  +1.62000000E-05  -4.21000000E-06
   -3.07800000E-04  -1.59800000E-05  +7.75980000E-04  +5.69700000E-05  -1.85000000E-06
   +3.15700000E-04  -2.09810000E-04  +4.15100000E-04  -1.17261000E-03  +3.74800000E-05
   -7.04000000E-06  +2.25150000E-04  -8.45790000E-04  +1.14307000E-03  -4.47075000E-03
   +2.93020000E-04  -4.45000000E-06  -4.09740000E-04  +2.45322000E-02  -8.70279500E-02
   +3.25365080E-01  +1.79400000E-05  -1.56610000E-04  -9.28000000E-06  +2.40800000E-05
   +3.23400000E-05  -1.82300000E-05  +3.79600000E-05  +2.63800000E-05  +5.90000000E-06
   -1.47350000E-04  -8.76500000E-05  -1.60700000E-05  +5.86700000E-05  -4.30700000E-05
   -1.16800000E-05  -4.18400000E-05  +8.48500000E-05  -1.19000000E-05  -1.09200000E-05
   -4.39000000E-06  +2.22000000E-06  +1.30000000E-05  +8.40000000E-07  +8.40000000E-07
   +1.69680000E-04  +1.04490000E-04  +1.58900000E-05  -5.05000000E-06  +1.04300000E-05
   +6.89000000E-06  -3.91700000E-05  -4.93200000E-05  +7.70000000E-07  -2.02970000E-04
   +6.73900000E-05  -1.48710000E-04  +4.13050000E-04  -5.79700000E-05  -7.79350000E-04
   +7.78000000E-05  -1.53600000E-05  -1.51400000E-05  +1.21870000E-04  -1.25200000E-05
   +3.56200000E-05  -9.11510000E-04  +9.06800000E-05  +4.80410000E-04  +3.15491000E-03
   -2.45021000E-03  +6.45780000E-04  -2.50538000E-02  +5.06146000E-03  +3.91444200E-02
   -4.22359000E-03  +4.26115000E-03  -2.90976000E-03  +5.84760000E-04  +1.74710000E-04
   +2.12226000E-03  +1.78580000E-04  -1.41220000E-04  +6.34000000E-05  -1.30300000E-04
   +6.89210000E-04  -1.66472000E-03  -1.30335100E-01  +3.70105700E-02  +1.74634390E-01
   +9.79000000E-06  -2.70900000E-04  -1.90270000E-04  -3.51840000E-04  +1.16650000E-04
   -1.52820000E-04  -7.92000000E-06  +4.57900000E-05  -1.02200000E-05  -3.76800000E-05
   -1.07900000E-05  -1.67700000E-05  +5.15300000E-05  -2.97800000E-05  -4.50000000E-06
   -7.59000000E-06  +2.95400000E-05  +1.32700000E-05  +4.28900000E-05  -5.76900000E-05
   -2.56600000E-05  -1.34400000E-05  +8.06000000E-06  +1.67000000E-06  +1.56559630E-01
   +3.96400000E-05  +8.84700000E-05  -9.65000000E-06  -7.84000000E-06  -2.48100000E-05
   +1.99700000E-05  -1.63200000E-05  -3.49300000E-05  -6.07000000E-06  +8.10200000E-05
   +6.18800000E-05  +1.04500000E-05  -4.13100000E-05  +2.31100000E-05  +7.71000000E-06
   -3.15000000E-06  -2.08200000E-05  +1.11100000E-05  +1.46700000E-05  -1.36000000E-06
   -4.03000000E-06  -6.27000000E-06  -1.85000000E-06  -1.41000000E-06  -1.02610000E-04
   -7.85300000E-05  -1.19300000E-05  -1.54700000E-05  -1.43600000E-05  -4.17000000E-06
   +2.75300000E-05  +5.51400000E-05  +9.22000000E-06  +5.21900000E-05  -7.50000000E-05
   +8.78100000E-05  -1.53920000E-04  +9.13900000E-05  +4.83150000E-04  -2.89200000E-05
   +1.23500000E-05  +4.00000000E-07  -6.22300000E-05  +2.73600000E-05  -2.68000000E-05
   +9.63500000E-05  -7.51210000E-04  -2.12350000E-04  -1.33552000E-03  +5.43900000E-05
   -1.25317000E-03  +1.37995700E-02  -5.74246000E-03  -2.33962000E-02  +3.97260000E-03
   -3.91080000E-04  +1.77515000E-03  +5.74900000E-04  +1.49855000E-03  -9.06480000E-04
   -9.63300000E-05  +2.20700000E-05  -3.58200000E-05  +1.96830000E-04  +2.32350000E-04
   +1.24692000E-03  +2.76160100E-02  -1.72298300E-02  -1.21867700E-02  -2.48900000E-04
   -3.54450000E-04  -5.71800000E-05  +9.74700000E-05  -3.25200000E-04  +1.54400000E-05
   +5.90000000E-07  -3.46900000E-05  +1.11000000E-05  +1.83200000E-05  +7.63000000E-06
   +4.93000000E-06  -2.28100000E-05  +2.14700000E-05  +6.60000000E-06  +1.36000000E-06
   -3.09500000E-05  +4.15000000E-06  -2.57100000E-05  +3.63900000E-05  +4.38000000E-06
   +1.61700000E-05  -3.09000000E-06  -1.02000000E-05  -4.43929100E-02  +2.28716800E-02
   -2.61900000E-05  +6.17500000E-05  -2.02300000E-05  -1.92100000E-05  -2.60100000E-05
   +1.35100000E-05  -1.42300000E-05  -6.86000000E-06  -3.66000000E-06  +3.15600000E-05
   +2.23800000E-05  +5.21000000E-06  -2.20700000E-05  +1.22200000E-05  -2.40000000E-06
   -5.06000000E-06  -1.54200000E-05  +6.49000000E-06  +4.93000000E-06  +6.10000000E-07
   +1.02000000E-06  -4.82000000E-06  -1.86000000E-06  -6.50000000E-07  -4.41100000E-05
   -3.01500000E-05  -8.74000000E-06  -5.29000000E-06  -7.86000000E-06  +3.31000000E-06
   +1.62100000E-05  +3.37600000E-05  +1.22800000E-05  +1.62960000E-04  -6.18900000E-05
   +5.50000000E-07  -1.69330000E-04  +1.64390000E-04  -1.90110000E-04  -2.08600000E-05
   +3.06000000E-06  +4.41300000E-05  -7.83600000E-05  +2.91600000E-05  -5.05300000E-05
   +1.17000000E-04  -4.13200000E-05  -8.99990000E-04  -5.15800000E-03  +2.06229000E-03
   +3.61901000E-03  -3.50035000E-03  +9.53770000E-04  +2.45201000E-03  -1.42565000E-03
   +8.73340000E-04  +1.81282000E-03  +3.85670000E-04  +1.06680000E-04  -2.98000000E-05
   -1.50340000E-04  +8.49200000E-05  -4.52600000E-05  +9.87030000E-04  -2.31650000E-04
   -1.08728000E-03  +2.20479080E-01  -3.83798200E-02  -4.38956720E-01  -2.81790000E-04
   -3.19000000E-06  +3.33590000E-04  -1.98800000E-05  -3.76000000E-05  +4.37100000E-05
   +9.24000000E-06  +6.59000000E-06  +1.04000000E-05  -6.84000000E-06  -1.47200000E-05
   -6.13000000E-06  -5.87000000E-06  +6.69000000E-06  -1.47000000E-05  -1.50000000E-07
   -1.98900000E-05  -3.12000000E-06  -2.19800000E-05  +3.16100000E-05  +2.83300000E-05
   +3.20000000E-06  -1.79000000E-06  -1.22000000E-06  -2.11216270E-01  +3.44270900E-02
   +4.32941640E-01  -4.06500000E-05  +4.88690000E-04  +1.19800000E-05  +1.38610000E-03
   -8.90720000E-04  -1.55350000E-04  -5.98693000E-03  -2.72197000E-03  -2.39520000E-04
   +3.88752000E-03  -4.43586600E-02  -8.87785000E-03  +2.01813000E-03  -2.81955000E-03
   -7.24400000E-04  -7.04660000E-04  -2.19270000E-04  -6.93700000E-05  -3.12090000E-04
   -1.50130000E-04  -1.70200000E-05  +4.85000000E-05  -1.04650000E-04  -3.61600000E-05
   -7.05159500E-02  +1.33171240E-01  +2.79596200E-02  -1.24620000E-03  +2.02126000E-03
   +4.57480000E-04  +3.69800000E-05  +3.31200000E-05  +3.21100000E-05  -1.48660000E-04
   +5.37900000E-05  +1.13930000E-04  +1.48900000E-05  +4.35800000E-05  -9.50000000E-07
   +1.57700000E-05  +4.03000000E-06  -1.43200000E-05  +6.11300000E-05  +1.60700000E-05
   -4.11200000E-05  -5.10000000E-07  +3.13300000E-05  +4.66300000E-05  +2.25500000E-05
   -7.24000000E-06  +3.93800000E-05  -1.36890000E-04  +6.83000000E-05  -1.40900000E-05
   +2.10300000E-05  +1.36900000E-05  -3.33100000E-05  +1.44700000E-05  +2.91400000E-05
   -2.38300000E-05  -1.44400000E-05  -1.04800000E-05  +3.76000000E-06  +7.59000000E-06
   -1.08000000E-05  -8.42000000E-06  +1.48610000E-04  -7.56500000E-05  +9.42000000E-06
   -1.72000000E-06  -9.53000000E-06  +2.42000000E-06  -2.75800000E-05  -1.07500000E-05
   -1.33800000E-05  +2.97300000E-05  +1.21100000E-05  -1.24900000E-05  -9.36000000E-06
   -1.00900000E-05  +2.13700000E-05  +4.05000000E-06  -1.27900000E-05  +1.45000000E-05
   +1.51300000E-05  +3.59000000E-05  +7.58000000E-06  -1.89000000E-05  -8.80000000E-07
   -2.61000000E-06  -1.14700000E-05  -1.52700000E-05  +2.29000000E-06  -3.07600000E-05
   +7.84000000E-06  +4.24000000E-06  +7.14598500E-02  +2.00050000E-04  +3.27470000E-04
   +1.02748000E-03  +2.14760000E-04  -1.12982000E-03  -7.32980000E-04  -3.97787000E-03
   +1.84947000E-03  -3.39900000E-04  +3.53595000E-03  -2.96780000E-02  -5.49059000E-03
   +4.48228000E-03  +5.81337000E-03  +1.34232000E-03  -9.99400000E-05  -1.56592000E-03
   -4.22440000E-04  -2.61790000E-04  -1.15200000E-04  +9.25100000E-05  +1.50000000E-05
   +4.02800000E-04  +2.01530000E-04  +8.13240300E-02  -4.88880960E-01  -9.78723400E-02
   -1.04086000E-03  -2.98700000E-04  -1.47730000E-04  +2.12820000E-04  +1.33500000E-04
   +2.15000000E-05  -2.32600000E-04  -3.70600000E-05  -1.43560000E-04  -3.10900000E-05
   +6.11300000E-05  -2.02600000E-05  +1.39870000E-04  +4.88900000E-05  +7.40000000E-06
   +7.32700000E-05  -2.57000000E-05  +1.43600000E-05  -2.55600000E-05  +1.84500000E-05
   +3.50100000E-05  +4.88100000E-05  -4.11300000E-05  +3.53500000E-05  -1.67120000E-04
   +9.18000000E-05  -1.85700000E-05  +2.89800000E-05  -3.88000000E-06  -6.96600000E-05
   +1.60900000E-05  +2.84800000E-05  +3.88600000E-05  -1.39900000E-05  +4.25000000E-06
   +2.00000000E-06  +1.86900000E-05  -5.18000000E-06  -1.22300000E-05  +1.90330000E-04
   -1.20020000E-04  +4.33000000E-06  +3.53000000E-06  +7.80000000E-07  +1.06600000E-05
   -1.29290000E-04  -6.01000000E-06  -5.37000000E-06  +2.53000000E-05  +4.59000000E-05
   -5.17000000E-05  -1.85200000E-05  -7.46000000E-06  +1.03600000E-05  -5.32000000E-06
   -1.60900000E-05  +8.44000000E-06  +2.50100000E-05  +4.38800000E-05  -1.76400000E-05
   -1.73700000E-05  -7.79000000E-06  -5.16000000E-06  -5.70000000E-05  -5.43800000E-05
   +3.00000000E-06  -2.62000000E-05  +2.25000000E-05  +6.92000000E-06  -8.47025200E-02
   +5.12899690E-01  -1.13630000E-04  +6.35600000E-05  +2.18060000E-04  +3.81630000E-04
   -4.66910000E-04  +1.43926000E-03  -6.59690000E-04  -4.08220000E-04  +2.92039000E-03
   +5.27040000E-04  -4.09786000E-03  -3.35485000E-03  +8.17820000E-04  +1.57939000E-03
   -1.17824000E-03  +4.37000000E-06  -1.82280000E-04  -7.64910000E-04  -9.10400000E-05
   +6.40800000E-05  -3.64840000E-04  -2.51300000E-05  +1.86070000E-04  -4.60480000E-04
   +1.76552200E-02  -9.92867200E-02  -2.54331100E-02  -1.42950000E-04  -2.28680000E-04
   +5.46970000E-04  +5.91700000E-05  +3.09900000E-05  +6.33100000E-05  -6.57900000E-05
   -1.93700000E-05  -5.35500000E-05  -4.62000000E-06  +8.91000000E-06  -1.74300000E-05
   +4.18000000E-05  +4.10500000E-05  +2.42900000E-05  +3.02800000E-05  +4.10000000E-07
   -1.07700000E-05  -1.21700000E-05  -7.00000000E-08  +1.83400000E-05  +1.14200000E-05
   -1.54200000E-05  -3.23000000E-06  -2.58900000E-05  +1.26200000E-05  +5.96000000E-06
   +4.55000000E-06  +7.22000000E-06  -1.43500000E-05  +5.97000000E-06  +1.02800000E-05
   +1.32300000E-05  +2.02000000E-06  +9.84000000E-06  -5.44000000E-06  +9.88000000E-06
   +1.10000000E-07  -3.01000000E-06  +2.88900000E-05  -1.52500000E-05  -7.71000000E-06
   -7.32000000E-06  -1.98000000E-06  -1.47000000E-06  -2.37500000E-05  -9.27000000E-06
   -2.49000000E-06  -8.50000000E-07  +1.11900000E-05  -2.26400000E-05  +1.50000000E-05
   -1.70700000E-05  -3.96000000E-06  -3.55000000E-06  +5.15000000E-06  +9.01000000E-06
   +1.06200000E-05  +1.53200000E-05  +2.03000000E-06  -4.80000000E-06  -4.95000000E-06
   -1.23000000E-06  -1.42500000E-05  -1.30500000E-05  -6.07000000E-06  -3.30000000E-06
   +3.76000000E-06  +5.84000000E-06  -1.84314100E-02  +1.02739150E-01  +2.63994800E-02
   -7.11476000E-03  -5.07742000E-03  -3.92801000E-03  -3.63956000E-03  +3.59390000E-04
   -3.55126000E-03  -1.74618000E-03  -2.44374000E-03  -3.94512000E-03  -5.25210000E-04
   +4.27398000E-03  +5.68780000E-04  +8.47280000E-04  -2.58100000E-05  -1.39300000E-05
   -7.42400000E-05  -6.21510000E-04  -1.52371000E-03  +8.82400000E-05  -3.74210000E-04
   +3.29110000E-04  +2.75280000E-04  -2.79000000E-05  +3.02200000E-04  -4.48990000E-04
   -9.39280000E-04  -1.66120000E-04  +8.81900000E-05  -1.98300000E-05  -8.72900000E-05
   -5.03200000E-05  -2.53950000E-04  -4.03020000E-04  -3.68140000E-04  -2.23950000E-03
   +5.17144000E-03  -8.54000000E-05  +4.92190000E-04  +3.01210000E-04  -1.36451000E-03
   -7.19230000E-04  -3.14300000E-05  -1.17681000E-03  -1.03497000E-03  +5.70960000E-04
   +4.74680000E-04  -7.11900000E-05  +9.30500000E-05  -3.72860000E-04  +1.54510000E-04
   +1.63630000E-04  +4.93470000E-04  +1.21950000E-04  -1.53930000E-04  -3.57600000E-04
   -2.45210000E-04  +1.67170000E-03  -4.43588000E-03  -7.28360000E-04  -2.53978000E-03
   -6.51400000E-05  -3.41700000E-05  +1.67210000E-04  -5.54000000E-05  -1.02300000E-05
   +5.48800000E-05  -6.50140000E-04  +3.64430000E-04  +1.86470000E-04  -2.57900000E-05
   -1.26270000E-04  -9.38000000E-05  -3.29531000E-03  +8.08540000E-04  +3.00683000E-03
   +1.63610000E-04  -5.90600000E-05  +4.55060000E-04  -4.79900000E-05  +1.03310000E-04
   +8.44300000E-05  +8.86100000E-05  -1.17470000E-04  -2.60000000E-07  +1.02320000E-04
   -2.33190000E-04  +5.39410000E-04  +1.53880000E-04  -3.40500000E-04  +9.74800000E-05
   -5.77200000E-04  -1.17450000E-03  +1.40221000E-03  +5.79800000E-05  -5.22400000E-05
   -6.75000000E-06  -1.52500000E-05  +1.46940000E-04  +7.94600000E-05  +2.08223990E-01
   -5.36641000E-03  -8.40113000E-03  -2.11139000E-03  +5.16570000E-04  -9.57390000E-04
   +9.44340000E-04  +1.16955000E-03  +2.48467000E-03  +6.13750000E-04  +2.25030000E-03
   -3.04614000E-03  -7.83300000E-04  -2.08801000E-03  -1.41200000E-05  -1.59215000E-03
   -1.35402000E-03  -3.78720000E-04  -3.47512000E-03  -3.49250000E-04  +4.03220000E-04
   +2.34890000E-04  -4.94100000E-05  +9.00400000E-05  -1.70010000E-04  +3.41900000E-05
   +6.78030000E-04  +1.33630000E-04  +1.83400000E-05  +8.98900000E-05  +3.62090000E-04
   -8.22800000E-05  +2.43630000E-04  +6.75240000E-04  +2.42890000E-04  -2.45825000E-03
   +5.01323000E-03  +8.34750000E-04  -2.39870000E-04  -2.26340000E-04  -1.61061000E-03
   -4.22530000E-04  +1.48200000E-04  -2.52931000E-03  -1.97176000E-03  +8.29120000E-04
   -1.38840000E-04  +5.40400000E-05  -7.96500000E-05  +3.63400000E-05  +8.10000000E-06
   -1.73150000E-04  -1.27660000E-04  -5.81300000E-05  +4.31700000E-05  -1.51820000E-04
   +2.43580000E-04  +1.27070000E-04  -6.04670000E-04  +1.32661000E-03  +5.05300000E-04
   +7.19700000E-05  -4.64400000E-05  -9.30500000E-05  -2.32400000E-05  +1.14500000E-05
   -4.71000000E-06  -1.06930000E-04  +9.93400000E-05  -3.32000000E-05  -1.11450000E-04
   +2.19500000E-05  -2.50300000E-05  +4.82040000E-04  -1.03722000E-03  -5.30500000E-05
   +1.66760000E-04  -1.68920000E-04  +4.89630000E-04  +3.14900000E-05  +1.04160000E-04
   +1.33560000E-04  -4.59000000E-06  +5.96000000E-06  -1.49240000E-04  -3.49000000E-06
   -3.30190000E-04  +9.00080000E-04  +5.68400000E-05  +6.38800000E-05  -6.06300000E-05
   -7.27570000E-04  -1.33856000E-03  +1.94026000E-03  -1.08100000E-05  -1.39900000E-05
   -6.02000000E-06  +1.45990000E-04  -2.69000000E-06  +4.76600000E-05  +2.63068260E-01
   +3.63303530E-01  +1.52210800E-02  +1.59760000E-03  +4.78705000E-02  -3.36117200E-02
   +7.97054000E-03  -1.56744900E-02  +5.19963000E-03  +1.07712800E-02  -1.44761000E-03
   -2.55595000E-03  -3.72390000E-03  -4.53080000E-04  +8.97129000E-03  +2.05570000E-03
   -2.47367000E-03  -5.74845000E-03  -2.74585000E-02  -2.04714000E-02  +7.86770000E-04
   -8.33230000E-04  +1.11761000E-03  +3.21670000E-04  +1.99170000E-04  +5.59740000E-04
   -3.46200000E-04  +3.08100000E-05  -1.68900000E-05  +3.82450000E-04  +1.08300000E-04
   +3.40070000E-04  -3.06550000E-04  +5.36670000E-04  +1.20815000E-03  +1.26614000E-03
   +1.71316000E-03  -6.89295000E-03  -6.74200000E-04  -3.99270000E-04  +3.85310000E-04
   -9.88180000E-04  -1.06838000E-03  +5.61230000E-04  -1.17764000E-03  -1.17910000E-04
   +9.99200000E-04  -3.21500000E-05  -4.27000000E-05  -1.89900000E-05  -2.23400000E-05
   +1.04910000E-04  -1.61570000E-04  -2.13200000E-05  -1.85220000E-04  +1.74670000E-04
   +9.82700000E-05  -7.44000000E-06  -5.24140000E-04  +1.34722000E-03  +7.94000000E-05
   +1.46427000E-03  +2.76900000E-05  -4.41400000E-05  -4.77700000E-05  -1.43600000E-05
   +1.65100000E-05  -2.70000000E-07  -2.59700000E-05  +5.46200000E-05  -6.37800000E-05
   +1.52000000E-05  +3.19000000E-05  -7.82000000E-06  +5.47800000E-05  +2.34460000E-04
   -8.39050000E-04  -3.01330000E-04  -4.62100000E-04  +3.79530000E-04  +4.12800000E-05
   +6.49500000E-05  -4.94310000E-04  -1.59380000E-04  +1.82420000E-04  -2.06600000E-04
   +9.28000000E-06  -6.25480000E-04  -6.42550000E-04  +6.70800000E-05  +1.14410000E-04
   +9.87000000E-06  -1.45310000E-04  +4.88000000E-06  -2.82690000E-04  +8.66000000E-06
   -2.41000000E-06  -1.31500000E-05  +1.18360000E-04  -4.81400000E-05  +2.10200000E-05
   -1.17185800E-02  -2.68124500E-02  +1.29209600E-02  -1.86584000E-03  -1.51510000E-04
   -3.62936000E-03  +3.79113000E-03  +1.06752000E-03  -5.75470000E-04  -1.57512000E-03
   -1.62743000E-03  +4.73120000E-04  +8.57410000E-04  +1.97590000E-04  -1.74610000E-04
   -7.56190000E-04  -2.16600000E-05  -4.33140000E-04  +6.32630000E-04  +2.24038000E-03
   +5.08650000E-04  -5.14000000E-05  +1.18690000E-04  -2.12690000E-04  -9.30300000E-05
   +1.81200000E-05  -7.72500000E-05  -1.04964000E-03  -6.34930000E-04  -4.94900000E-05
   -3.47800000E-05  -4.13000000E-06  +7.56700000E-05  -1.52790000E-04  -3.50900000E-05
   +2.62080000E-04  -1.35140000E-04  +6.12800000E-05  -2.90070000E-04  +1.73340000E-04
   +8.23200000E-05  +1.87800000E-05  +3.10620000E-04  +2.28300000E-04  +3.25500000E-05
   +2.08340000E-04  -1.03400000E-05  -4.65990000E-04  +3.61800000E-05  -1.10000000E-07
   +1.32200000E-05  -1.94900000E-05  +1.32700000E-05  +1.08700000E-05  -1.21330000E-04
   +7.99300000E-05  -2.66900000E-05  -8.53800000E-05  +9.81500000E-05  +3.58680000E-04
   -5.41130000E-04  +2.26510000E-04  -4.60140000E-04  -1.56200000E-05  -6.37000000E-06
   +1.72200000E-05  -5.01000000E-06  -6.47000000E-06  -3.51000000E-06  +1.29400000E-05
   +5.25000000E-06  +3.44500000E-05  -5.98100000E-05  -3.22400000E-05  -2.81000000E-05
   +4.42480000E-04  -6.68700000E-04  +2.88410000E-04  +5.54200000E-05  +5.62900000E-05
   -9.49800000E-05  -1.40500000E-05  -8.80000000E-06  +1.11880000E-04  +8.00000000E-08
   -4.80400000E-05  +3.72800000E-05  +6.12700000E-05  +5.82000000E-06  +1.36780000E-04
   +3.90000000E-06  -1.24410000E-04  +1.66300000E-04  +6.96100000E-05  +4.28950000E-04
   +2.73100000E-04  -2.32700000E-05  -6.30000000E-07  +2.26000000E-06  +2.99900000E-05
   +1.05340000E-04  -5.50100000E-05  -1.84564850E-01  -2.53685890E-01  +2.39127700E-02
   +1.84478530E-01  -1.58517000E-03  -6.96420000E-04  -4.18057000E-03  +2.62919000E-03
   -1.32620000E-03  +6.21500000E-04  +3.52100000E-05  -1.21199000E-03  -3.55740000E-04
   +1.35718000E-03  +1.15367000E-03  -8.97000000E-05  -2.78046000E-03  -7.73620000E-04
   +2.80220000E-04  +1.73101000E-03  +3.47516000E-03  +3.59700000E-04  -1.82030000E-04
   +1.00930000E-04  -2.58300000E-05  -2.42200000E-05  -3.56800000E-05  +1.87600000E-05
   -1.28253000E-03  -1.07250000E-03  -8.02900000E-05  -3.68500000E-05  -1.07780000E-04
   -1.57510000E-04  +1.38600000E-04  -9.89100000E-05  -2.49130000E-04  -2.70060000E-04
   -2.23650000E-04  -6.49600000E-04  -1.11410000E-04  +2.08240000E-04  +5.56200000E-05
   +4.49770000E-04  +3.79920000E-04  +5.73800000E-05  -5.19120000E-04  -9.66000000E-05
   -7.13210000E-04  +5.64600000E-05  -4.50000000E-06  +5.50800000E-05  -1.35300000E-05
   -1.63200000E-05  +6.96600000E-05  +1.54600000E-05  -2.19100000E-05  -6.29400000E-05
   +1.72400000E-05  -8.42200000E-05  +2.85900000E-05  +5.96800000E-04  -1.08480000E-04
   -3.93760000E-04  -3.04300000E-05  +9.82000000E-06  +4.51500000E-05  +2.00000000E-07
   -7.99000000E-06  +4.57000000E-06  +2.83800000E-05  -2.55400000E-05  +2.90900000E-05
   +5.96700000E-05  +5.22000000E-06  +1.58400000E-05  +1.19100000E-05  +1.03440000E-04
   +1.12200000E-05  +7.22800000E-05  +1.47700000E-04  -1.71480000E-04  -2.78500000E-05
   -1.21800000E-05  +1.60090000E-04  +8.94000000E-06  -9.51600000E-05  +4.07600000E-05
   +5.16600000E-05  -2.66300000E-05  +4.65700000E-04  +5.16800000E-05  -3.41800000E-05
   -2.78900000E-05  +4.85010000E-04  +1.40940000E-04  +5.83700000E-04  +2.84000000E-06
   +1.86000000E-06  -1.18000000E-06  -4.51100000E-05  +2.03630000E-04  -6.96500000E-05
   -2.52923760E-01  -3.48346010E-01  +3.59595800E-02  +2.52033020E-01  +3.48495940E-01
   +4.80848000E-03  +6.67568000E-03  -1.14502000E-03  +7.19550000E-04  +1.05147000E-03
   -1.12850000E-03  -2.92560000E-04  +4.19300000E-04  +4.12430000E-04  -2.73583000E-03
   -1.37350000E-04  +2.73210000E-04  +1.65849000E-03  -7.43130000E-04  +5.66570000E-04
   +8.35870000E-04  +8.88500000E-05  -2.80957000E-03  +5.88800000E-05  -1.22550000E-04
   -3.99600000E-05  +6.22800000E-05  -1.07330000E-04  +1.11150000E-04  +1.27902000E-03
   +7.29410000E-04  -4.70900000E-05  +2.32600000E-05  +6.40800000E-05  +7.37000000E-05
   +3.00000000E-06  -4.93000000E-06  +7.64900000E-05  +6.35600000E-05  +1.00385000E-03
   -1.90353000E-03  -1.08410000E-04  -1.18350000E-04  +7.21100000E-05  +7.95130000E-04
   +4.07360000E-04  -1.39290000E-04  +1.42170000E-04  -1.27860000E-04  -5.85600000E-04
   -3.09300000E-05  -4.21400000E-05  -1.01500000E-04  -2.15900000E-05  +1.82600000E-05
   -4.92300000E-05  +9.19200000E-05  -6.90200000E-05  +4.54900000E-05  +3.94200000E-05
   -6.36000000E-06  +2.48600000E-05  -3.65200000E-05  +2.11100000E-05  +1.66310000E-04
   +1.45500000E-05  +1.71200000E-05  -6.73000000E-06  -2.90000000E-06  +1.48900000E-05
   +1.77000000E-06  -1.23460000E-04  +6.38300000E-05  -2.73900000E-05  -2.93400000E-05
   +2.05900000E-05  +9.50000000E-07  +2.83960000E-04  -5.91900000E-05  -7.10300000E-05
   -1.33310000E-04  +2.38900000E-05  -2.46940000E-04  +1.96600000E-05  -1.89600000E-05
   -1.36000000E-06  -2.29200000E-05  +3.62900000E-05  +2.07800000E-05  -8.11200000E-05
   +1.27210000E-04  -6.24000000E-06  -1.60300000E-05  +6.66900000E-05  +2.89000000E-05
   +8.30500000E-05  -1.58680000E-04  -1.00730000E-04  +2.22500000E-05  -4.69000000E-06
   -1.70000000E-07  -1.29440000E-04  -2.02880000E-04  +2.25900000E-05  +1.29174500E-02
   +2.27072500E-02  -1.72793300E-02  -2.01575900E-02  -3.16337300E-02  +2.37919100E-02
end_hess

