# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -882.65746810    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -2.78230969E+00  -7.39793529E-01  +2.26381777E+00
   006   -1.69819186E+00  -2.02086888E+00  +2.37428506E-01
   006   -3.14033208E+00  -2.19606276E+00  -1.96206504E+00
   006   -5.52483379E+00  -1.14819624E+00  -2.14866523E+00
   006   -6.54982743E+00  +1.39160947E-01  -1.07705325E-01
   006   -5.16340427E+00  +3.32512177E-01  +2.10970293E+00
   006   +9.73410890E-01  -3.10003488E+00  +3.89163301E-01
   006   +1.45580221E+00  -4.38384768E+00  +2.94450097E+00
   008   -8.88797805E+00  +1.14757201E+00  -3.78831789E-01
   006   +2.97179079E+00  -8.37491115E-01  -1.97859710E-02
   006   +3.05009678E+00  +8.64841769E-01  +2.25518682E+00
   006   +2.28709813E+00  +3.25551601E+00  +2.23107542E+00
   006   +1.28977668E+00  +4.45371285E+00  -8.81898746E-02
   006   +1.55248275E+00  +2.96718065E+00  -2.43404114E+00
   006   +2.34398922E+00  +5.86833283E-01  -2.39881241E+00
   008   +5.32681471E+00  -2.04512192E+00  -2.46377857E-01
   008   +3.88408620E-01  +6.55918223E+00  -6.81805545E-02
   006   +1.44436007E+00  -5.11182717E+00  -1.64707132E+00
   008   +8.33048491E+00  +1.00448403E+00  -7.82676146E-01
   001   -9.35529940E+00  +2.03012090E+00  +1.12894510E+00
   001   -5.93847390E+00  +1.32448294E+00  +3.72517931E+00
   001   -1.76450260E+00  -5.34772095E-01  +4.02062895E+00
   001   -2.40336046E+00  -3.16865814E+00  -3.59825995E+00
   001   -6.60868050E+00  -1.30722226E+00  -3.87320542E+00
   001   +2.48207053E-01  -6.04602370E+00  +3.09260014E+00
   001   +3.41767468E+00  -4.99119906E+00  +3.08170576E+00
   001   +1.04449402E+00  -3.18142680E+00  +4.55849791E+00
   001   +1.41162993E+00  -4.36898975E+00  -3.56385046E+00
   001   +3.27979121E+00  -5.98991000E+00  -1.35891014E+00
   001   -5.16187918E-03  -6.56900427E+00  -1.50975386E+00
   001   +3.83051963E+00  +2.53590313E-02  +3.94899445E+00
   001   +2.36389493E+00  +4.43376609E+00  +3.90134440E+00
   001   +1.06808378E+00  +3.92288781E+00  -4.17517562E+00
   001   +2.56160962E+00  -4.56856991E-01  -4.14491498E+00
   001   +6.79247486E+00  -7.64501150E-01  -9.29449984E-01
   001   +7.38343931E+00  +2.45979163E+00  -2.21250732E-01
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +2.20000000E-07  +1.52000000E-06  +2.80000000E-07
   -3.00000000E-08  +2.60000000E-07  +9.50000000E-07
   -3.20000000E-07  -8.90000000E-07  +1.18000000E-06
   -2.20000000E-07  -7.30000000E-07  +7.30000000E-07
   +4.00000000E-08  +5.50000000E-07  +1.00000000E-07
   +2.70000000E-07  +1.63000000E-06  -1.10000000E-07
   -2.50000000E-07  +1.10000000E-07  +1.40000000E-06
   -9.00000000E-08  +1.48000000E-06  +2.05000000E-06
   +1.30000000E-07  +6.10000000E-07  -2.90000000E-07
   +2.40000000E-07  -4.30000000E-07  -1.00000000E-07
   +3.30000000E-07  +8.40000000E-07  -1.02000000E-06
   +5.70000000E-07  +9.30000000E-07  -2.45000000E-06
   +6.10000000E-07  -6.40000000E-07  -3.05000000E-06
   +1.80000000E-07  -1.52000000E-06  -2.17000000E-06
   -1.90000000E-07  -1.68000000E-06  -8.30000000E-07
   -2.80000000E-07  -4.60000000E-07  +2.50000000E-07
   +5.90000000E-07  +1.40000000E-07  -4.14000000E-06
   -4.90000000E-07  -1.13000000E-06  +2.45000000E-06
   +1.30000000E-07  -1.36000000E-06  -1.75000000E-06
   +3.50000000E-07  +1.50000000E-06  -7.60000000E-07
   +4.70000000E-07  +2.65000000E-06  -6.20000000E-07
   +2.90000000E-07  +2.39000000E-06  +4.00000000E-08
   -5.40000000E-07  -1.85000000E-06  +1.65000000E-06
   -3.90000000E-07  -1.60000000E-06  +9.10000000E-07
   -2.30000000E-07  +1.72000000E-06  +3.06000000E-06
   -3.00000000E-07  +1.44000000E-06  +2.20000000E-06
   +1.00000000E-07  +2.38000000E-06  +1.29000000E-06
   -6.60000000E-07  -2.25000000E-06  +2.07000000E-06
   -7.50000000E-07  -1.10000000E-06  +2.78000000E-06
   -6.90000000E-07  -8.90000000E-07  +3.39000000E-06
   +3.00000000E-07  +1.90000000E-06  -8.60000000E-07
   +8.00000000E-07  +1.98000000E-06  -3.05000000E-06
   +1.10000000E-07  -2.55000000E-06  -2.69000000E-06
   -3.40000000E-07  -2.66000000E-06  -2.80000000E-07
   -2.60000000E-07  -1.59000000E-06  -2.80000000E-07
   +2.80000000E-07  -7.30000000E-07  -2.33000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.22114530E-01  -1.82548630E-01  +2.88479910E-01  +1.03802410E-01  +1.50906370E-01
   +6.67745810E-01  -1.50617880E-01  +6.84770800E-02  +8.04909300E-02  +5.59362230E-01
   +4.44453900E-02  -1.27052840E-01  -1.01007420E-01  -1.42510010E-01  +2.99173010E-01
   +2.27237700E-02  -7.41824800E-02  -2.38602310E-01  +5.78050600E-02  +1.40478660E-01
   +6.19605520E-01  +5.74674900E-02  -3.34925000E-02  -2.45196800E-02  -1.73885310E-01
   +2.33222800E-02  -6.24054200E-02  +6.18389080E-01  -1.58941100E-02  +1.12544600E-02
   -1.23082100E-02  +1.96642000E-03  -8.40335100E-02  -4.48722800E-02  -2.01189550E-01
   +3.06830170E-01  +2.13160000E-02  -3.51901000E-02  -5.59330600E-02  -1.20758520E-01
   -1.67784300E-02  -2.52937850E-01  +4.38144000E-02  +1.76682540E-01  +6.54307890E-01
   -4.21235400E-02  +2.84124400E-02  +2.44537900E-02  -2.92644200E-02  -9.10853000E-03
   -6.86989200E-02  -3.11370300E-01  +1.18321320E-01  +6.51120000E-03  +6.40014080E-01
   +2.67305500E-02  -2.23107400E-02  -1.62468500E-02  +7.87334000E-03  +1.89234900E-02
   +4.08601500E-02  +9.60939600E-02  -1.15449470E-01  -2.82299400E-02  -1.98609840E-01
   +2.85959680E-01  +2.16500800E-02  -1.50785800E-02  -1.53947300E-02  -2.37023400E-02
   +1.78100800E-02  +2.84529500E-02  -5.56521100E-02  +1.85679000E-03  -1.26815820E-01
   +1.09425920E-01  +1.59686300E-01  +6.70869990E-01  -3.11084400E-02  +5.70139000E-03
   -2.64965000E-02  +4.10556000E-03  -6.98534000E-03  -4.14209000E-03  -1.53104600E-02
   +1.90745300E-02  +2.78126300E-02  -1.37739830E-01  +6.12156500E-02  +7.62859500E-02
   +6.25719100E-01  -1.38570800E-02  +1.81186400E-02  +2.43886600E-02  -6.77921000E-03
   -1.26261500E-02  -2.55529100E-02  +3.89305800E-02  -1.50167900E-02  +5.54203000E-03
   +3.48424300E-02  -1.31326970E-01  -1.10248340E-01  -1.94896800E-01  +3.22776250E-01
   -7.80590200E-02  +4.97743700E-02  +3.29640000E-02  -4.19445000E-03  -2.60672200E-02
   -7.77917400E-02  +7.90935400E-02  -2.02942000E-02  +4.94812300E-02  +7.95416000E-03
   -7.81682800E-02  -2.59206830E-01  +6.61063900E-02  +1.64025730E-01  +6.62895310E-01
   -3.03168430E-01  +9.45488200E-02  -5.17003000E-02  -1.45702100E-02  +3.85639400E-02
   +6.98309900E-02  -5.16921500E-02  +1.06821000E-02  -3.39062700E-02  +5.62885000E-02
   -3.06582600E-02  -2.16717200E-02  -1.65042650E-01  +2.58217000E-02  -4.95375600E-02
   +6.16577380E-01  +1.19478910E-01  -1.16537870E-01  +2.59380000E-04  +1.91205800E-02
   -8.79933000E-03  -2.06177300E-02  +1.15419600E-02  -5.99133000E-03  +8.49347000E-03
   -1.52111500E-02  +1.16951300E-02  -1.03658900E-02  -1.57558000E-03  -8.99077800E-02
   -5.55292100E-02  -2.12802070E-01  +2.95613620E-01  +9.48755000E-03  -2.92239600E-02
   -1.22525880E-01  +2.33715700E-02  +2.74058000E-03  +3.96740400E-02  -2.90907800E-02
   +6.49439000E-03  -2.27296300E-02  +1.85877400E-02  -2.90959900E-02  -4.47179900E-02
   -1.21973450E-01  -2.19113100E-02  -2.75821580E-01  +5.47202700E-02  +1.79061720E-01
   +6.58021710E-01  -1.41482600E-02  +1.02376300E-02  +6.50338000E-03  -1.56819500E-01
   +3.20779100E-02  -7.07264000E-03  -1.88538800E-02  +7.58048000E-03  -7.94475000E-03
   +3.74125000E-03  -2.01160000E-04  -3.22892000E-03  -3.41172000E-03  +1.24359000E-03
   -4.31040000E-04  +4.69133000E-03  +1.23176000E-03  +1.39956000E-03  +4.35041130E-01
   +1.63839700E-02  -5.47129000E-03  +5.80930000E-04  +4.20782400E-02  -8.76597500E-02
   -4.91326000E-03  +6.25600000E-04  +2.55183000E-03  +2.90435000E-03  +1.27099000E-03
   +4.41971000E-03  -2.60107000E-03  -1.79460000E-04  -4.39860000E-04  -2.31710000E-04
   +2.10843000E-03  +3.53698000E-03  -3.74382000E-03  -6.36830300E-02  +4.26075210E-01
   +2.28430100E-02  -6.88389000E-03  +7.67094000E-03  -6.93654000E-03  -5.57424000E-03
   -9.15066500E-02  -2.40203700E-02  +1.09605200E-02  +4.80331000E-03  -3.25191000E-03
   -2.78111000E-03  -3.35104000E-03  +1.64880000E-04  -5.67380000E-04  -1.75952000E-03
   +9.42160000E-04  -3.55633000E-03  -3.70237000E-03  +1.02576400E-02  +1.40577700E-02
   +4.87454110E-01  -6.12230000E-04  +1.48423000E-03  -2.97470000E-04  -9.38858000E-03
   +1.44383000E-02  -3.02451100E-02  -2.89420000E-03  +3.05622000E-03  +1.56369000E-03
   -1.65666000E-03  -6.80720000E-04  -2.84210000E-04  +6.61370000E-04  -4.93260000E-04
   -5.71720000E-04  +2.42020000E-04  -3.73890000E-04  -7.00630000E-04  -7.78231700E-02
   +1.04516000E-02  -1.46046200E-02  +5.87777460E-01  +1.58560000E-04  +2.94260000E-04
   +3.56970000E-04  +5.22883000E-03  -6.10126000E-03  +1.13601900E-02  +3.98060000E-04
   -9.58070000E-04  -5.84950000E-04  +1.00120000E-04  +3.69880000E-04  +1.09000000E-04
   -3.07300000E-05  -7.94300000E-05  +1.02300000E-05  -1.57790000E-04  +2.45930000E-04
   +2.42720000E-04  +1.05115600E-02  -9.31136300E-02  +3.80558000E-02  +8.02462000E-03
   +5.54480690E-01  +8.62530000E-04  -6.71700000E-05  +4.26090000E-04  -8.12869000E-03
   +3.85228000E-03  -2.12690000E-03  +1.30772000E-03  +8.30000000E-05  -2.38700000E-05
   +1.52380000E-04  +4.86800000E-05  -6.64400000E-05  -4.01470000E-04  +6.31200000E-05
   +5.04700000E-05  +1.47840000E-04  -2.51990000E-04  -4.86300000E-04  -1.32360700E-02
   +3.52558300E-02  -1.55147250E-01  -1.92364400E-02  +6.01981000E-02  +5.08065430E-01
   +4.55675000E-03  -1.42330000E-04  -3.47887000E-03  -5.09351000E-03  +2.72326000E-03
   -7.26630000E-04  +5.05959000E-03  -1.92770000E-04  +3.21210000E-04  -3.09149100E-02
   +2.17654900E-02  +8.16180000E-03  -2.73858090E-01  +8.66224800E-02  -5.50794800E-02
   -3.93353000E-02  +2.00541200E-02  -9.32896000E-03  +3.58029000E-03  -3.25520000E-04
   -2.62130000E-04  -1.08956000E-03  -2.34700000E-05  +4.39810000E-04  +4.03046530E-01
   +2.81721000E-03  +4.86611000E-03  -3.61310000E-03  +1.99030000E-03  -1.50092000E-03
   +3.01933000E-03  -2.41711000E-03  +4.26814000E-03  -5.58551000E-03  +3.47919600E-02
   -1.03388700E-02  -3.12439000E-03  +1.06499850E-01  -9.56813500E-02  +6.06680000E-04
   +7.37186000E-03  +7.01932000E-03  +7.08040000E-04  -1.99732000E-03  -4.17020000E-04
   +4.67180000E-04  +4.86720000E-04  +2.30400000E-05  -2.16680000E-04  -2.05755590E-01
   +2.26274070E-01  +4.32632000E-03  -7.77193000E-03  -6.77938000E-03  +3.23230000E-04
   +2.83533000E-03  +6.45345000E-03  -6.50412000E-03  -2.02525000E-03  -8.50379000E-03
   +4.16225800E-02  -1.92271600E-02  +8.81746000E-03  -1.11677500E-02  -2.03837100E-02
   -1.06544410E-01  -4.33033900E-02  +1.66274600E-02  +3.22180000E-04  +2.74080000E-04
   +3.15820000E-04  +2.72470000E-04  +2.94800000E-05  -3.00700000E-05  -5.26800000E-05
   -5.43923600E-02  +2.27347870E-01  +4.94112420E-01  +1.34486000E-03  -1.84786000E-03
   -2.05481000E-03  -3.16907700E-02  -1.40717400E-02  +2.29983000E-03  +1.00093000E-03
   -7.17500000E-04  +2.96790000E-03  -1.05114000E-03  +2.35548000E-03  +6.65790000E-04
   +1.71858000E-03  -9.05740000E-04  +2.31930000E-04  -1.20743000E-03  +1.16334000E-03
   -1.82782000E-03  -4.21096400E-02  -1.44620000E-04  -2.19372000E-03  +6.61680000E-04
   -3.11120000E-03  +2.87441000E-03  -2.02540000E-03  +8.51390000E-04  +7.12000000E-06
   +3.68067250E-01  +3.49300000E-04  -1.27592000E-03  -2.33900000E-05  -5.64570000E-04
   +1.02525300E-02  -1.78033000E-03  +1.21532000E-03  -1.44023000E-03  +6.32280000E-04
   -2.24240000E-04  -3.12620000E-04  +3.51380000E-04  -1.31560000E-04  +1.65710000E-04
   -6.38240000E-04  +5.21300000E-04  -5.48090000E-04  +3.44070000E-04  +8.38795000E-03
   -7.03956100E-02  +2.08154000E-03  -1.20923700E-02  -1.72626500E-02  +5.33058000E-03
   +4.89530000E-04  -2.29810000E-04  +5.43000000E-05  -6.83197700E-02  +4.39416400E-01
   -1.52620000E-04  +2.51000000E-05  +3.29430000E-04  +6.32170000E-04  -1.88253000E-03
   -6.91430000E-04  -1.79650000E-04  +6.51030000E-04  -2.67910000E-04  -4.21410000E-04
   +3.89980000E-04  -3.13800000E-04  -2.60640000E-04  -1.39500000E-04  -3.20210000E-04
   +3.75180000E-04  -3.46610000E-04  +2.72270000E-04  -4.40725000E-03  +7.82340000E-04
   -6.82070000E-02  +1.86618000E-02  +2.38566800E-02  -4.69408000E-03  +2.12730000E-04
   -5.78300000E-05  -2.89800000E-05  +2.89900700E-02  +8.83758000E-03  +5.25888110E-01
   -2.23924000E-03  -1.33984000E-03  +8.04300000E-05  -7.85600000E-05  -4.61870000E-04
   -6.69810000E-04  -2.66500000E-05  +8.59000000E-05  -2.14500000E-05  -1.95920000E-04
   +3.47700000E-05  +2.36200000E-05  +8.76100000E-05  -1.02860000E-04  -3.66140000E-04
   +3.37730000E-04  -3.25000000E-06  +2.45560000E-04  +8.87850000E-04  -1.30452900E-02
   -1.51653700E-02  -6.19910000E-04  -4.99240000E-04  +8.87730000E-04  -4.21600000E-05
   +5.55700000E-05  +3.51200000E-05  -6.63389800E-02  -7.78546000E-03  -2.08197800E-02
   +2.73816150E-01  -1.07543000E-03  -5.12830000E-04  +9.35100000E-04  +5.17330000E-04
   +1.55020000E-04  +2.82200000E-05  -1.14960000E-04  +1.62440000E-04  -4.80900000E-04
   +2.51930000E-04  -3.71440000E-04  -3.17920000E-04  -2.59900000E-05  +3.35160000E-04
   +2.58510000E-04  -1.01080000E-04  -3.35540000E-04  -9.19000000E-06  -1.18192800E-02
   -2.33174800E-02  -1.62120100E-02  -7.11870000E-04  -2.32400000E-03  +1.22670000E-04
   +3.12500000E-04  -1.95870000E-04  -5.14500000E-05  +4.58979000E-03  -1.09754790E-01
   -5.02240800E-02  -2.07820080E-01  +7.89092980E-01  +9.25980000E-04  +5.61360000E-04
   +2.73850000E-04  -4.45980000E-04  +4.32500000E-05  -1.59650000E-04  -2.71820000E-04
   -5.02100000E-05  -2.63570000E-04  +3.77420000E-04  -3.65820000E-04  -9.35900000E-05
   -1.42820000E-04  +1.86080000E-04  +4.12770000E-04  -2.83050000E-04  +2.99000000E-05
   -2.27660000E-04  -7.21056000E-03  -3.51033000E-03  +5.32366000E-03  +2.81800000E-04
   +9.68590000E-04  +1.80104000E-03  +2.68320000E-04  -1.71030000E-04  -1.41600000E-05
   -1.21681500E-02  -4.13255400E-02  -1.71299750E-01  +1.23547290E-01  -3.47431900E-02
   +5.67444730E-01  -1.46701000E-03  -8.20690000E-04  +1.04101000E-03  +2.18100000E-04
   -4.61700000E-04  -2.81930000E-04  +4.70000000E-07  +1.22120000E-04  -1.01380000E-04
   -8.97000000E-06  -1.33930000E-04  -2.26420000E-04  +1.60850000E-04  +1.54400000E-04
   +4.24700000E-05  -7.14400000E-05  -4.67380000E-04  +9.79000000E-06  -3.66311000E-03
   -1.64267000E-03  +5.95200000E-04  +3.79340000E-04  -5.11300000E-05  -4.63000000E-06
   +3.80900000E-05  -3.39100000E-05  -4.77600000E-05  +8.74786000E-03  +4.88054000E-03
   +3.94944000E-03  -1.01011960E-01  +1.40690270E-01  -2.00108000E-02  +2.07757830E-01
   -1.97990000E-04  +5.94600000E-05  +3.23340000E-04  +6.59170000E-04  -4.03950000E-04
   +1.62790000E-04  -5.56800000E-05  +1.77590000E-04  -1.23780000E-04  +3.60100000E-05
   +7.89100000E-05  -9.67000000E-06  +1.64200000E-05  -1.51300000E-05  +6.87800000E-05
   -1.67980000E-04  +1.01690000E-04  -1.29430000E-04  +2.24819000E-03  +8.92710000E-04
   -1.35672000E-03  -5.23500000E-05  +4.05670000E-04  -1.48610000E-04  -1.13690000E-04
   +1.19460000E-04  -3.98000000E-05  +5.52309000E-03  -2.03987400E-02  -3.75835000E-03
   +1.43881030E-01  -5.07024290E-01  +5.24373000E-03  -1.96807520E-01  +8.04699330E-01
   +2.14750000E-04  +1.24250000E-04  -9.66040000E-04  -4.63300000E-05  +1.11140000E-04
   +2.20770000E-04  -3.28970000E-04  -1.21420000E-04  -1.47310000E-04  +2.61400000E-04
   -1.99390000E-04  +7.44100000E-05  -2.80740000E-04  +8.55000000E-05  +1.12700000E-05
   -3.70200000E-05  +2.53020000E-04  +4.07280000E-04  -5.69650000E-04  -1.44327000E-03
   -1.80945000E-03  +4.79100000E-04  +2.82690000E-04  -7.50620000E-04  +3.77440000E-04
   -1.96270000E-04  +8.37600000E-05  +7.28412000E-03  -2.32324700E-02  +4.00408000E-03
   -1.62007200E-02  -1.00930100E-02  -1.22138330E-01  +8.98796400E-02  +1.00862460E-01
   +5.91078150E-01  +3.86100000E-04  -4.22020000E-04  +4.39570000E-04  +4.98300000E-04
   -5.05200000E-04  +1.93600000E-05  +1.87980000E-04  +4.08800000E-05  +2.37330000E-04
   -2.39220000E-04  +2.61970000E-04  -1.56600000E-05  +2.31010000E-04  -2.20610000E-04
   -1.92250000E-04  -3.65100000E-04  +5.26720000E-04  -3.07820000E-04  +2.35431000E-03
   +1.26210000E-04  -5.82150000E-04  -3.67770000E-04  -2.84730000E-04  -2.47490000E-04
   -5.23190000E-04  +4.35300000E-04  -5.89300000E-05  -1.40599900E-02  -7.90822000E-03
   +3.94448000E-03  -1.96413000E-03  +1.39589300E-02  -4.02546000E-03  -9.17372500E-02
   +4.32557000E-03  -3.57749700E-02  +3.26769260E-01  -7.38420000E-04  +4.85790000E-04
   -9.06500000E-05  -2.03780000E-04  +5.35150000E-04  -1.37390000E-04  -8.25000000E-05
   +2.01720000E-04  -6.20100000E-04  +3.20730000E-04  -2.02600000E-04  -2.58370000E-04
   -1.53738000E-03  +8.01610000E-04  +1.59510000E-04  +3.85530000E-04  -4.73700000E-04
   +5.48140000E-04  -2.09389000E-03  -1.61807000E-03  -1.38160000E-04  +7.39130000E-04
   +4.42540000E-04  +6.23900000E-05  +1.75287000E-03  -1.15380000E-03  +1.32640000E-04
   -1.42986000E-03  +6.98500000E-05  +1.69800000E-03  +1.47437400E-02  -2.26562800E-02
   +2.42206800E-02  +8.77617000E-03  -9.25291800E-02  +1.86865200E-02  -2.66387500E-01
   +8.43997710E-01  -5.72690000E-04  +6.13610000E-04  +1.66394000E-03  +1.18120000E-04
   +1.69850000E-04  -6.60180000E-04  +7.18530000E-04  +2.48300000E-04  -1.11130000E-04
   -7.09950000E-04  +6.19010000E-04  -4.59210000E-04  -1.60580000E-04  -4.83200000E-05
   -2.07990000E-04  +4.77760000E-04  -6.91040000E-04  -2.37210000E-04  +5.27600000E-05
   -8.17800000E-05  -2.72457000E-03  +4.71500000E-04  +1.25291000E-03  +4.87100000E-04
   +6.09200000E-05  -4.13200000E-05  -1.48410000E-04  +4.79736000E-03  +3.53540000E-04
   +9.55974000E-03  -1.79274000E-03  +1.88692200E-02  +1.66050200E-02  -3.57159200E-02
   +1.10716400E-02  -2.06531830E-01  +4.89454600E-02  +2.73106000E-02  +5.31209480E-01
   +6.53130000E-04  -7.93550000E-04  -5.11200000E-04  -1.39504000E-03  -1.43250000E-03
   +1.23061000E-03  -7.86100000E-04  -6.55510000E-04  +8.23580000E-04  +5.00650000E-04
   -4.97830000E-04  -3.88000000E-06  +2.82980000E-04  +1.54280000E-04  +2.71480000E-04
   -2.33840000E-04  +3.09530000E-04  -2.65870000E-04  -3.40584000E-03  -9.77570000E-04
   -5.27930000E-04  +6.06460000E-04  +4.53150000E-04  +3.08630000E-04  -1.64820000E-04
   +3.51900000E-05  -1.25200000E-05  +5.01000000E-03  +1.11238600E-02  -4.99799000E-03
   -2.28490000E-04  +1.19677000E-03  +1.53669000E-03  +1.49638000E-02  -2.09953000E-03
   -1.18458600E-02  -8.20607100E-02  +2.28621000E-03  -4.79202000E-03  +2.05068310E-01
   +1.11420000E-04  -2.46900000E-05  -2.93430000E-04  +3.98480000E-04  -1.08402000E-03
   +3.65000000E-04  -2.78030000E-04  -7.19300000E-05  +2.31400000E-04  +4.35400000E-05
   -2.19900000E-05  +5.01800000E-05  +1.38720000E-04  -1.35590000E-04  +1.64500000E-04
   -2.82650000E-04  +1.90270000E-04  -1.08900000E-05  +1.68431000E-03  +1.39632000E-03
   +8.69510000E-04  -7.73450000E-04  -6.89350000E-04  -1.87310000E-04  -2.32460000E-04
   +1.93670000E-04  -8.25000000E-06  +4.63065000E-03  -1.52345400E-02  +3.59705000E-03
   +8.02050000E-04  -3.59217000E-03  -4.58553000E-03  +1.20770000E-03  +2.00501600E-02
   +6.40491000E-03  +7.39730000E-04  -9.94559800E-02  -2.74180500E-02  -2.29604440E-01
   +7.82914980E-01  -6.75100000E-05  -5.56800000E-05  -3.77730000E-04  +1.82620000E-04
   +2.32100000E-04  -1.37900000E-04  +1.05300000E-05  -1.61700000E-04  -6.25700000E-05
   +1.08030000E-04  -2.78900000E-05  +1.78400000E-04  +3.58820000E-04  -1.63570000E-04
   +6.60600000E-05  -1.57770000E-04  +7.17600000E-05  +1.49910000E-04  +2.02930000E-04
   +1.10436000E-03  -2.51627000E-03  +4.80140000E-04  +5.23460000E-04  -2.39600000E-05
   -3.32070000E-04  +2.30320000E-04  -3.84000000E-06  -8.33061000E-03  +2.29030200E-02
   +5.87298000E-03  +1.30473000E-03  -1.68406000E-03  -1.06236000E-03  -2.57726000E-03
   -1.21057200E-02  -2.93819600E-02  -3.80324000E-03  -3.63567800E-02  -2.12997930E-01
   +7.08263300E-02  -5.64696900E-02  +6.22753890E-01  +6.80000000E-07  -1.57900000E-04
   +7.26600000E-05  -8.42570000E-04  -1.62510000E-03  +1.78674000E-03  -1.70370000E-03
   -1.26057000E-03  +1.28620000E-04  +3.46040000E-04  -1.70650000E-04  -1.30760000E-04
   -3.83000000E-06  +2.29340000E-04  -1.48920000E-04  +1.81850000E-04  +2.38830000E-04
   +1.34000000E-05  +7.44332000E-03  -7.81446000E-03  +1.63717200E-02  -3.53214000E-03
   -3.59728000E-03  -8.66110000E-04  +3.77400000E-05  -5.09400000E-05  +2.48200000E-05
   -7.17613800E-02  +4.07126000E-03  -1.11401500E-02  +3.45422000E-03  -3.30968000E-03
   -5.44682000E-03  -1.10342000E-03  +1.87491000E-03  -1.18216000E-03  +1.28703000E-03
   +7.92020000E-03  +5.22610000E-03  -1.01573850E-01  +1.49386450E-01  -1.02369000E-02
   +2.36821630E-01  +4.26300000E-04  -6.11130000E-04  -2.51340000E-04  -1.40623000E-03
   -5.01700000E-04  +1.73932000E-03  -1.19083000E-03  -5.01280000E-04  +6.38000000E-04
   +4.37980000E-04  -6.07880000E-04  -1.20730000E-04  +8.08500000E-05  +2.52130000E-04
   +2.06190000E-04  -1.00410000E-04  +9.22400000E-05  -1.69290000E-04  -4.25311000E-03
   -1.83527700E-02  +2.10184400E-02  -1.96963000E-03  -2.27368000E-03  -3.25900000E-05
   +1.40120000E-04  -1.40190000E-04  -1.34700000E-05  +1.65945200E-02  -1.03957190E-01
   +3.83190300E-02  -6.56513000E-03  +1.32166600E-02  -1.46869800E-02  +1.45798000E-03
   -2.53807000E-03  +1.46238000E-03  +9.44100000E-03  -2.83710700E-02  -1.68114700E-02
   +1.50683300E-01  -5.04435290E-01  +1.37307400E-02  -2.02554290E-01  +8.01092140E-01
   +5.70000000E-06  -8.50100000E-05  -4.30460000E-04  +1.32468000E-03  +5.19650000E-04
   -1.77200000E-04  -7.95100000E-05  +2.97700000E-04  +5.92150000E-04  -8.38800000E-05
   +9.82000000E-06  -8.74100000E-05  +2.30600000E-04  -1.14760000E-04  +5.32000000E-05
   -1.79570000E-04  +7.98100000E-05  -1.16710000E-04  +7.48733000E-03  +1.01283600E-02
   -3.52914000E-03  -1.13981000E-03  -1.45548000E-03  -2.61900000E-05  -3.58200000E-04
   +1.63190000E-04  -2.55200000E-05  -2.43659600E-02  +3.58984200E-02  -1.84655790E-01
   -5.81952000E-03  +9.98629000E-03  -3.47165000E-02  -1.69819000E-03  +4.31124000E-03
   -9.36320000E-04  +9.05288000E-03  -2.31573100E-02  +1.73105300E-02  -7.02768000E-03
   -1.11678000E-03  -1.26766800E-01  +8.31384000E-03  +6.92959700E-02  +5.95833910E-01
   -1.05619000E-03  +1.52473000E-03  +1.42766000E-03  +2.74508000E-03  -3.51771000E-03
   +4.46270000E-04  -1.06558000E-03  +7.18600000E-04  -1.75454000E-03  +1.02622000E-03
   -1.20548000E-03  -8.72090000E-04  -2.05098000E-03  +8.41880000E-04  -3.77950000E-04
   +1.50532000E-03  -5.09860000E-04  +1.29158000E-03  -5.54547300E-02  -1.58537200E-02
   +9.74079000E-03  +1.91526000E-03  +2.06381000E-03  +8.47310000E-04  +2.17551000E-03
   -9.47020000E-04  +5.03400000E-05  -1.46177440E-01  +8.72048000E-02  +1.31500000E-04
   -1.97499900E-02  +1.45730200E-02  +1.67780500E-02  -1.79000000E-05  -2.60732000E-03
   +6.40970000E-04  -1.42312000E-03  -2.97560000E-04  -1.18367000E-03  -5.98240000E-04
   -8.93390000E-04  -3.02561000E-03  -2.87470900E-02  +1.82626900E-02  -4.95818000E-03
   +3.08178140E-01  -3.77200000E-05  +4.38920000E-04  -1.51040000E-04  -2.08295000E-03
   -2.77147000E-03  +3.37460000E-04  -2.06140000E-04  +2.25800000E-04  -4.91900000E-05
   -6.59000000E-06  +1.46750000E-04  -1.04570000E-04  -2.58250000E-04  -4.95200000E-05
   -3.45400000E-05  +3.02700000E-05  +2.05020000E-04  +5.60200000E-05  -1.94498600E-02
   +6.07775000E-03  +2.27167000E-03  +4.64380000E-04  -4.25490000E-04  +1.42606000E-03
   +1.23440000E-04  +2.07900000E-05  +6.51000000E-06  +5.84800300E-02  -1.07549200E-01
   +3.87230000E-03  +3.36557900E-02  -2.10119000E-02  -9.85736000E-03  -1.89583000E-03
   -7.86290000E-04  -4.15615000E-03  +2.11072000E-03  +2.14431000E-03  -8.74750000E-04
   -4.29690000E-04  +8.86300000E-05  +4.40865000E-03  +3.10576900E-02  -1.58424200E-02
   +8.27310000E-04  -3.66186600E-02  +2.48602410E-01  +1.23560000E-04  -5.25770000E-04
   -6.84960000E-04  -4.69490000E-04  +7.42440000E-04  +7.37810000E-04  +2.08150000E-04
   -2.17590000E-04  +2.59820000E-04  -1.09800000E-04  +2.25680000E-04  +3.77120000E-04
   +6.15280000E-04  -2.51530000E-04  +7.11900000E-05  -4.39570000E-04  +2.67100000E-04
   -2.39020000E-04  +1.12832900E-02  +3.09621000E-03  -6.06010000E-04  -4.97700000E-05
   +9.11910000E-04  -7.88370000E-04  -6.66670000E-04  +2.90510000E-04  +2.93800000E-05
   +1.03222500E-02  -7.16693000E-03  -6.83347900E-02  +3.18783900E-02  -1.83884200E-02
   -3.57910000E-03  +3.18420000E-04  -2.89384000E-03  -4.93480000E-04  -1.63695000E-03
   -1.10373000E-03  -8.51414000E-03  -4.51260000E-04  +3.87765000E-03  -1.94404000E-03
   -2.90659300E-02  +1.61542900E-02  +8.58633000E-03  -5.13047500E-02  -3.15240200E-02
   +8.68853300E-02  -4.41300000E-04  +2.79040000E-04  -1.32420000E-04  -1.98700000E-04
   +2.95210000E-04  -4.99600000E-05  -1.01260000E-04  +5.21100000E-05  -2.37400000E-04
   +1.90130000E-04  -1.86860000E-04  -3.51500000E-05  -4.31240000E-04  +3.48060000E-04
   +1.54840000E-04  +2.23410000E-04  -4.33920000E-04  +2.69790000E-04  -1.39894000E-03
   -4.55680000E-04  +2.60050000E-04  +3.53350000E-04  +2.05220000E-04  +9.54000000E-06
   +6.26840000E-04  -5.34370000E-04  +6.70100000E-05  +2.59985000E-03  +8.33290000E-04
   -8.82160000E-04  +6.55980000E-04  -2.22949000E-03  -5.62127000E-03  +4.25618000E-03
   +3.77994700E-02  -1.05777200E-02  -1.69680970E-01  +2.36857200E-01  -4.14641000E-03
   +1.31781900E-02  +2.48777200E-02  +7.63107000E-03  +2.43480000E-03  -1.85687000E-03
   +2.46042000E-03  -9.12700000E-05  +1.32530000E-04  +4.76550000E-04  +1.54975270E-01
   +3.67070000E-04  -2.55010000E-04  +1.73870000E-04  +4.11340000E-04  -4.82850000E-04
   +1.71000000E-06  -2.60000000E-07  -9.72300000E-05  +3.60880000E-04  -2.18400000E-04
   +1.70210000E-04  +2.16510000E-04  +1.20755000E-03  -6.03860000E-04  +3.28300000E-05
   -4.00020000E-04  +2.72190000E-04  -4.77960000E-04  +2.35323000E-03  +8.89250000E-04
   -6.47200000E-05  -7.39180000E-04  -4.09630000E-04  -2.66000000E-05  -1.36768000E-03
   +8.75740000E-04  -1.10800000E-04  -1.57116000E-03  +1.57600000E-05  -5.81590000E-04
   +9.68330000E-04  +7.30671000E-03  +8.05082000E-03  +3.23053700E-02  -4.61138200E-02
   +1.99387000E-02  +2.37397400E-01  -6.20161530E-01  -7.88647000E-03  +2.81141200E-02
   -5.39015300E-02  -2.17866600E-02  -1.71831000E-03  +6.68753000E-03  -9.34232000E-03
   -3.59160000E-04  -1.15753000E-03  +5.81820000E-04  -2.94751890E-01  +7.11198650E-01
   +1.90810000E-04  -2.17680000E-04  -4.85780000E-04  -8.32000000E-06  -1.67600000E-05
   +2.48670000E-04  -2.35240000E-04  -4.00200000E-05  -1.34900000E-05  +2.12070000E-04
   -2.04070000E-04  +1.57550000E-04  -1.96000000E-06  +4.28700000E-05  +1.24500000E-05
   -1.55050000E-04  +2.11930000E-04  +3.09500000E-05  -4.38000000E-06  +7.11200000E-05
   +8.25800000E-04  -1.12550000E-04  -3.60280000E-04  -1.65220000E-04  +9.07000000E-06
   -5.31000000E-06  +7.77600000E-05  -1.14447000E-03  +5.34500000E-05  -3.84266000E-03
   -2.73248000E-03  -4.47990000E-04  -8.00435000E-03  -2.00730600E-02  +4.30281400E-02
   +1.27253500E-02  -4.47887000E-03  -7.37754000E-03  -1.07338400E-01  +1.75009200E-02
   -4.54967800E-02  +1.19597100E-02  -1.74380000E-04  -9.07000000E-04  -8.37299000E-03
   +5.02590000E-04  +1.88790000E-04  +2.71935000E-03  +7.69372000E-03  +9.92562000E-03
   +9.06310200E-02  -4.68974000E-03  +1.90346000E-03  -2.48162000E-03  -7.77715000E-03
   +2.32016700E-02  +2.35022400E-02  -2.89743000E-03  +1.85173000E-03  -7.34590000E-04
   +1.14180000E-04  +4.26170000E-04  +1.19192000E-03  +3.67480000E-04  -3.49700000E-05
   +1.35480000E-04  -7.57990000E-04  +2.23450000E-04  +1.35158000E-03  -7.88324200E-02
   +1.29018700E-02  +9.82851000E-03  +1.28069000E-03  -2.32108000E-03  -2.76121000E-03
   -7.06970000E-04  +3.42200000E-04  -1.91700000E-05  -4.88590000E-04  -1.82359600E-02
   -1.48356100E-02  -3.17927000E-03  -1.66309000E-03  +2.96151000E-03  +5.38080000E-04
   -1.13153000E-03  -4.35730000E-04  -9.69090000E-04  +6.31340000E-04  -7.66440000E-04
   +1.90120000E-04  -3.04850000E-04  -4.16760000E-04  +8.26200000E-05  +6.78010000E-04
   -5.24280000E-04  -4.22880000E-04  -2.28248000E-03  -1.62037000E-03  +5.18630000E-04
   -8.01180000E-04  +2.22380000E-04  +5.93383300E-01  +9.32660000E-04  -1.79690000E-04
   +9.28360000E-04  +6.60294000E-03  -1.10880900E-02  -9.22306000E-03  +3.39520000E-04
   -5.17360000E-04  -2.29220000E-04  -3.67980000E-04  -1.56740000E-04  -4.37210000E-04
   +8.01200000E-05  +4.31300000E-05  +6.37600000E-05  -4.10200000E-05  +9.31300000E-05
   -5.93890000E-04  +1.45851200E-02  -1.22883370E-01  -4.93172600E-02  -1.55793000E-03
   +9.17919000E-03  +6.08641000E-03  -9.59600000E-05  +4.32900000E-05  -2.10600000E-05
   -3.85196000E-03  -2.30272900E-02  -1.71526300E-02  -2.43984000E-03  -1.57685000E-03
   +2.26591000E-03  +2.04550000E-04  -5.77760000E-04  -2.34440000E-04  -5.38380000E-04
   +2.16480000E-04  -8.03260000E-04  -2.20180000E-04  +1.72190000E-04  -4.56510000E-04
   +1.79300000E-04  -8.17580000E-04  +9.76000000E-05  -1.01050000E-04  -2.34019000E-03
   -1.75099000E-03  +2.70520000E-04  -3.51850000E-04  +2.37150000E-04  +1.19018500E-02
   +5.17089920E-01  -1.91938000E-03  +1.25600000E-05  +1.90000000E-07  +4.27558000E-03
   -7.29650000E-04  +2.30518000E-03  -5.35640000E-04  +1.36708000E-03  +3.39930000E-04
   -1.13950000E-04  +7.20300000E-05  -3.70010000E-04  +2.69440000E-04  -1.65000000E-04
   +1.96080000E-04  -2.74800000E-04  -1.62600000E-05  +2.35620000E-04  +9.93170000E-03
   -4.56492700E-02  -1.27305760E-01  +5.24006000E-03  -2.05646300E-02  -3.67454600E-02
   -3.65860000E-04  +1.41590000E-04  -6.81400000E-05  -2.69878000E-03  -7.64840000E-04
   +2.35252000E-03  +1.29973000E-03  +4.72160000E-04  -8.79930000E-04  -3.27740000E-04
   +3.05900000E-04  +8.68500000E-05  +4.02040000E-04  -1.20530000E-04  +6.25930000E-04
   -1.99540000E-04  -1.54860000E-04  -8.60080000E-04  -1.56160000E-04  +2.47450000E-04
   +1.95432000E-03  -1.49479000E-03  -1.24976000E-03  +3.34060000E-04  -8.30800000E-05
   +3.49900000E-05  -2.39820000E-04  +1.40531000E-02  -6.16814700E-02  +5.45193620E-01
   -3.21000000E-05  +7.03400000E-05  +3.96130000E-04  +2.46230000E-04  +4.10600000E-04
   -2.70890000E-04  +5.67000000E-05  -1.07700000E-04  -1.95890000E-04  +1.78480000E-04
   -3.38080000E-04  -1.46980000E-04  -5.34480000E-04  +2.64950000E-04  -1.03520000E-04
   +3.10290000E-04  -2.06680000E-04  +2.39920000E-04  -2.27224000E-03  -3.43439000E-03
   +1.47033000E-03  +3.58900000E-05  +4.66500000E-05  +2.70760000E-04  +6.98060000E-04
   -3.25150000E-04  +2.39200000E-05  +1.45717000E-03  -1.02647000E-03  -3.05104000E-03
   +5.93700000E-05  -3.00470000E-04  +3.11122000E-03  -1.21463000E-03  -2.50775000E-03
   -1.22318000E-03  +8.81400000E-04  -2.07170000E-04  -5.18290000E-04  -7.48890000E-04
   -1.73598000E-03  +8.14930000E-04  -6.16890000E-04  +1.23810000E-03  -1.43188000E-03
   -7.99972800E-02  -5.44724000E-02  +3.27640900E-02  -1.54870000E-04  +5.98400000E-05
   +1.64650000E-04  -5.56320000E-04  +6.16960000E-04  -7.11830000E-04  +1.97154240E-01
   -1.73300000E-05  +2.97840000E-04  +3.80270000E-04  +5.97380000E-04  +5.55720000E-04
   -3.42960000E-04  -1.75400000E-05  +1.12200000E-05  -3.53730000E-04  +1.83130000E-04
   -2.88550000E-04  -1.51700000E-04  -5.57040000E-04  +2.55600000E-04  -4.65000000E-05
   +2.42750000E-04  -1.35490000E-04  +2.27910000E-04  -2.40985000E-03  -4.04563000E-03
   +1.39870000E-03  +3.10450000E-04  +1.71430000E-04  +1.61460000E-04  +6.82840000E-04
   -2.94050000E-04  +1.81900000E-05  +5.12294000E-03  +5.78680000E-04  -1.22430000E-04
   +1.37688000E-03  -8.14350000E-04  +1.85739000E-03  -1.07880000E-04  -4.05310000E-04
   -9.45380000E-04  +1.04840000E-04  +4.61110000E-04  -4.06000000E-06  +1.33420000E-04
   -2.11670000E-04  +1.54260000E-04  +5.17670000E-04  +3.36220000E-04  -1.13387000E-03
   -9.18787400E-02  -6.33493000E-02  +3.46302600E-02  +4.38300000E-05  -3.31070000E-04
   +2.32400000E-05  -1.40960000E-04  +3.73470000E-04  -5.33120000E-04  -1.86986020E-01
   +3.76156060E-01  -7.58700000E-05  +1.62270000E-04  +1.98200000E-04  +7.67840000E-04
   +3.81350000E-04  +1.51040000E-04  -1.66780000E-04  +6.24000000E-05  -4.32520000E-04
   +2.74410000E-04  -3.15230000E-04  -1.07600000E-04  -3.99570000E-04  +2.10000000E-04
   +2.72900000E-05  +1.51950000E-04  -6.15400000E-05  +2.26530000E-04  -8.88570000E-04
   -3.02591000E-03  -3.79590000E-04  +5.84700000E-05  +9.47600000E-05  +2.45950000E-04
   +4.74620000E-04  -2.10000000E-04  +2.13200000E-05  +5.66657000E-03  +3.94639000E-03
   -1.29880000E-04  +4.26760000E-04  -7.92800000E-05  -7.89470000E-04  +9.42010000E-04
   +5.98620000E-04  +9.32680000E-04  -2.26610000E-04  -1.32730000E-04  -2.42870000E-03
   -5.37180000E-04  -4.94180000E-04  +1.24722000E-03  -1.33948000E-03  -3.55160000E-04
   -1.02857000E-03  -8.01132000E-03  -5.37996000E-03  +5.55373000E-03  +5.43200000E-05
   -1.99900000E-05  +7.65160000E-04  +3.38700000E-05  -2.15320000E-04  -1.48510000E-04
   -9.22011200E-02  +1.28944310E-01  +5.78924900E-02  -8.05150000E-04  +1.64460000E-04
   +4.11080000E-04  +3.26160000E-04  -4.02540000E-04  -7.23820000E-04  +9.12020000E-04
   +9.35000000E-04  +1.59185000E-03  -5.68223000E-03  +2.70490000E-03  -2.98832000E-03
   -1.79805600E-02  +2.44108800E-02  +3.95779400E-02  +2.49241000E-03  -1.03387000E-03
   +1.76715000E-03  -2.97940000E-04  -8.85900000E-05  -8.84200000E-05  +9.10700000E-05
   +1.33000000E-05  +5.98000000E-06  -6.43890500E-02  +5.90607000E-02  +6.84278200E-02
   +5.16900000E-05  +1.32100000E-05  -1.50100000E-05  +9.57000000E-06  +4.16200000E-05
   +4.08000000E-06  +4.99800000E-05  -3.85600000E-05  -4.72600000E-05  -9.89900000E-05
   -1.58000000E-06  +2.98200000E-05  +4.70200000E-05  -2.22400000E-05  +2.04200000E-05
   +3.53000000E-06  +3.60400000E-05  +1.39600000E-05  -1.64310000E-04  -7.18400000E-05
   +5.92000000E-05  +1.13760000E-04  +4.60900000E-05  -2.60500000E-05  +7.46900000E-05
   -4.26000000E-06  +3.28800000E-05  -5.37900000E-05  -7.47400000E-05  -3.77800000E-05
   +8.57836100E-02  +1.69820000E-04  -8.60930000E-04  -3.93190000E-04  -1.83890000E-04
   +3.71130000E-04  +3.80490000E-04  +2.49050000E-04  +1.05375000E-03  -1.35722000E-03
   +3.13264000E-03  +1.29536000E-03  +1.18447000E-03  +5.86380000E-03  -1.27004800E-02
   -1.68946500E-02  -3.48177000E-03  +9.97320000E-04  +7.74790000E-04  +2.73330000E-04
   +2.59000000E-06  +3.52300000E-05  -4.42500000E-05  -1.61400000E-05  +1.33300000E-05
   +7.91559600E-02  -1.30420970E-01  -2.01826480E-01  -1.68900000E-04  +3.39600000E-05
   +3.65000000E-06  -2.26300000E-05  +3.54200000E-05  +3.50200000E-05  +6.55000000E-06
   -5.43100000E-05  +7.52300000E-05  -1.87580000E-04  +4.30460000E-04  -7.41000000E-06
   -3.63000000E-06  -7.33000000E-05  -6.40500000E-05  -6.97000000E-06  +3.31700000E-05
   -3.72300000E-05  +2.08880000E-04  -1.49900000E-05  -5.51200000E-05  +2.35750000E-04
   -3.11400000E-04  -1.06000000E-05  -7.25300000E-05  +3.68000000E-06  -2.03900000E-05
   +7.35300000E-05  +5.36200000E-05  +4.27100000E-05  -8.53271000E-02  +1.40452650E-01
   +2.37230000E-04  -1.73740000E-04  -9.48210000E-04  -3.78430000E-04  +2.66680000E-04
   -7.87500000E-05  +1.39550000E-04  -7.58200000E-04  +1.85680000E-04  -1.70847000E-03
   +6.10220000E-04  +1.99107000E-03  -1.81941000E-03  +3.09539000E-03  +2.08342000E-03
   -4.14664000E-03  +3.61233000E-03  +3.11341000E-03  +2.80660000E-04  -6.73100000E-05
   -1.04150000E-04  -7.89500000E-05  +2.29300000E-05  +5.83500000E-05  +1.13275100E-01
   -2.23421130E-01  -3.91430050E-01  -1.81430000E-04  +4.25000000E-05  +4.43800000E-05
   +1.35300000E-05  +3.36400000E-05  +3.09000000E-06  +2.16200000E-05  +2.48700000E-05
   -3.00000000E-06  +3.90400000E-05  -2.81600000E-05  +6.92900000E-05  -1.76500000E-05
   -5.34000000E-06  +4.39000000E-06  +1.54600000E-05  -3.86000000E-06  -3.08700000E-05
   +1.53140000E-04  +1.04100000E-05  -6.00800000E-05  -4.83700000E-05  +8.37000000E-06
   -4.62600000E-05  -9.44000000E-06  -4.55000000E-06  -2.98800000E-05  +3.30700000E-05
   +3.84900000E-05  +2.38300000E-05  -1.05936140E-01  +2.17231890E-01  +3.85923030E-01
   -6.52886000E-03  +1.37977400E-02  +2.46718600E-02  -3.28847000E-03  +3.89594000E-03
   -2.26696000E-03  -1.16589000E-03  -1.28290000E-04  -6.56660000E-04  -2.96520000E-04
   +1.27837000E-03  -3.93070000E-03  +7.76697000E-03  -6.88395000E-03  -1.35061400E-02
   -9.32628700E-02  +5.84894400E-02  +7.70476500E-02  +3.69910000E-04  +7.17810000E-04
   +1.09647000E-03  +1.40500000E-05  -7.28000000E-05  +1.09080000E-04  +2.26319000E-03
   -2.84182000E-03  +4.02320000E-04  -3.94300000E-05  +8.17200000E-05  +3.05200000E-05
   -3.79500000E-05  +6.48100000E-05  +5.61900000E-05  +4.89300000E-05  -1.77000000E-05
   +5.26400000E-05  -1.70920000E-04  +3.16160000E-04  +1.33320000E-04  -1.83600000E-05
   -7.62900000E-05  -5.18600000E-05  -4.01000000E-05  +1.78000000E-05  -6.45500000E-05
   +1.13610000E-04  -4.76500000E-05  -7.38600000E-05  +1.93210000E-04  -1.99550000E-04
   -1.03670000E-04  -4.97700000E-04  +6.43600000E-05  -1.02310000E-04  +7.27400000E-05
   +4.84700000E-05  +1.73800000E-05  -3.96780000E-04  +7.09760000E-04  +5.18350000E-04
   +9.48333100E-02  +3.22308000E-03  -3.17467000E-03  -1.07675500E-02  +4.40692000E-03
   +4.88838000E-03  -7.20050000E-04  -2.04820000E-04  -5.75510000E-04  +6.01500000E-04
   +9.42720000E-04  +4.51868000E-03  -1.37459000E-03  +4.08675000E-03  +1.75013000E-03
   -1.34344000E-03  +5.87644900E-02  -1.04863190E-01  -1.13227980E-01  -3.27800000E-05
   +6.83100000E-05  -7.61280000E-04  +4.86900000E-05  +3.74900000E-05  +5.63400000E-05
   -2.57659000E-03  -1.81364000E-03  +2.18142000E-03  +2.93200000E-05  -6.14800000E-05
   -1.44000000E-06  -4.71900000E-05  -3.22900000E-05  +8.46000000E-06  -5.77000000E-06
   -2.23000000E-05  +2.13900000E-05  -1.16820000E-04  +1.25910000E-04  +3.91000000E-06
   +2.86000000E-06  -1.81200000E-05  +1.71700000E-05  -1.84800000E-05  -1.29100000E-05
   +1.48400000E-05  -9.98600000E-05  -3.22100000E-05  +4.21100000E-05  +1.24810000E-04
   -5.17400000E-05  -3.30300000E-05  +1.31280000E-04  +1.42700000E-05  +1.25600000E-04
   -3.56600000E-05  -4.67300000E-05  -1.86800000E-05  -2.51270000E-04  +3.37520000E-04
   -8.59300000E-04  -6.65803400E-02  +1.02636290E-01  -2.13072000E-03  +1.97958000E-03
   +5.05569000E-03  -1.71386000E-03  -1.00754000E-03  +2.54527000E-03  -1.07754000E-03
   +8.42210000E-04  -1.50460000E-04  -4.48953000E-03  -1.20286000E-03  -3.07586000E-03
   +1.51136100E-02  -1.48213400E-02  -1.55607500E-02  +7.73499500E-02  -1.13248810E-01
   -2.32024780E-01  -3.18940000E-04  -7.60800000E-05  +2.02310000E-04  +6.06700000E-05
   +1.45100000E-05  -2.24800000E-05  +9.82760000E-04  +1.78285000E-03  +1.97582000E-03
   +4.63800000E-05  +1.64800000E-05  -1.35000000E-06  +3.06100000E-05  -3.03300000E-05
   -3.67700000E-05  +2.92000000E-06  +4.28200000E-05  -5.30300000E-05  +1.75480000E-04
   -3.17740000E-04  -2.75900000E-05  +5.38000000E-06  +5.07800000E-05  +2.15000000E-05
   +1.65500000E-05  -1.87100000E-05  +2.06800000E-05  -4.45500000E-05  +1.86900000E-05
   +2.00600000E-05  -1.98700000E-04  +1.93960000E-04  +4.21700000E-05  +5.12900000E-05
   +1.57800000E-05  -1.71400000E-05  -2.77200000E-05  -1.73400000E-05  -1.31900000E-05
   -2.00361000E-03  +4.49210000E-04  -9.69830000E-04  -8.35975600E-02  +1.24346770E-01
   +2.42754400E-01  -1.26350390E-01  -6.17116000E-03  -1.24551220E-01  +1.07204200E-02
   +5.95410000E-04  +9.46630000E-03  +6.69440000E-04  +3.39998000E-03  +1.97719000E-03
   -8.15470000E-04  +1.18210000E-04  +7.61790000E-04  -2.70996000E-03  +4.87763000E-03
   +7.66100000E-05  -1.09383800E-02  -3.23744000E-03  -2.63219300E-02  -6.40600000E-04
   -1.23596000E-03  +9.95500000E-05  -1.78046000E-03  +1.43382000E-03  +1.71210000E-04
   -1.21684000E-03  +5.48300000E-05  -1.35500000E-03  -3.19600000E-04  +1.74260000E-04
   +2.07910000E-04  -1.06533000E-03  -8.10010000E-04  +5.57370000E-04  -8.97290000E-04
   -3.19090000E-04  +2.06490000E-04  +7.82500000E-05  -4.37900000E-05  +9.20400000E-05
   -4.98000000E-06  +6.04000000E-06  -4.97800000E-05  +1.52200000E-05  +6.99000000E-06
   -2.34100000E-05  +6.42900000E-05  -7.75700000E-05  -7.91700000E-05  -5.80000000E-05
   +9.39400000E-05  -5.67100000E-05  +2.30970000E-04  -3.55900000E-05  -1.63800000E-05
   -6.53000000E-06  -1.96200000E-05  +6.36000000E-06  +1.88480000E-04  -1.70620000E-04
   -1.43980000E-04  +2.35500000E-05  -1.67914000E-03  +8.79900000E-04  +1.36449320E-01
   -6.68950000E-03  -4.73343200E-02  -3.14224600E-02  -8.42931000E-03  +3.05499000E-03
   -1.24513800E-02  +3.59645000E-03  +3.23309000E-03  -4.11502000E-03  +4.91000000E-06
   -1.14516000E-03  +2.04470000E-04  +4.98169000E-03  +4.66694000E-03  -2.15703000E-03
   +7.59912000E-03  +5.24333000E-03  +1.14784300E-02  -1.63870000E-03  -1.96445000E-03
   +9.70850000E-04  +9.38640000E-04  -1.16394000E-03  -5.12690000E-04  +3.72150000E-04
   -1.04220000E-04  +7.08250000E-04  -4.04680000E-04  +3.20210000E-04  +1.76220000E-04
   -4.66010000E-04  +6.45800000E-05  -4.01900000E-05  -3.46440000E-04  -2.94900000E-04
   +2.91540000E-04  -4.24600000E-05  +8.18300000E-05  +1.34810000E-04  +2.35800000E-05
   -2.75800000E-05  +4.18000000E-06  -1.56700000E-04  -4.38000000E-06  -5.06200000E-05
   +2.95890000E-04  -1.70530000E-04  -1.02000000E-04  +7.20000000E-05  -9.74900000E-05
   -8.79200000E-05  +7.86600000E-05  -2.64840000E-04  +2.51190000E-04  +1.27430000E-04
   +4.09900000E-05  +3.93200000E-05  -7.52500000E-05  +4.93300000E-05  +4.05000000E-05
   -1.86806000E-03  -2.99263000E-03  +1.41664000E-03  +6.35380000E-04  +4.07788200E-02
   -1.24216970E-01  -3.08234200E-02  -2.69553660E-01  -1.44731200E-02  -8.78840000E-04
   -1.58126600E-02  +2.33472000E-03  -4.38237000E-03  -2.27294000E-03  +9.11590000E-04
   +1.75620000E-04  +2.99970000E-04  -3.55170000E-04  -1.94903000E-03  +2.72996000E-03
   +6.66130000E-04  -1.50209000E-03  +1.56585000E-03  -8.28390000E-04  +1.59879000E-03
   -8.14440000E-04  -9.52200000E-04  +4.21090000E-04  -1.93480000E-04  -2.42940000E-04
   +1.58950000E-04  -1.38190000E-04  +5.22470000E-04  -3.44130000E-04  -4.12400000E-04
   -2.15600000E-05  -6.30710000E-04  +2.05600000E-04  -6.95130000E-04  -4.37700000E-05
   +6.56680000E-04  -3.18970000E-04  +3.31730000E-04  -9.51720000E-04  +7.12100000E-05
   +9.81400000E-05  +1.28240000E-04  +1.56000000E-06  -3.64800000E-05  +5.33900000E-05
   -1.60300000E-04  +1.67930000E-04  +1.97550000E-04  +1.82370000E-04  -2.50150000E-04
   +2.50310000E-04  +9.74800000E-05  +4.78500000E-05  +9.31000000E-05  -9.45900000E-05
   -3.39600000E-05  +6.72000000E-06  +5.98400000E-05  -4.41700000E-05  -3.29900000E-05
   +5.85760000E-04  +1.63515000E-03  +3.35700000E-04  +1.38041810E-01  +3.46252200E-02
   +2.83054740E-01  -4.16460000E-04  +1.49046000E-03  -4.35408000E-03  +1.11479000E-02
   -7.77376000E-03  -1.20361700E-02  -9.17776300E-02  +5.46999700E-02  +7.92758800E-02
   -6.82439000E-03  +1.44222400E-02  +2.42110000E-02  -2.82154000E-03  +4.37818000E-03
   -2.17545000E-03  -1.18544000E-03  -2.43420000E-04  -5.97890000E-04  -2.45530000E-04
   -1.47435000E-03  +8.48170000E-04  +3.37470000E-04  +1.63700000E-04  +1.20530000E-04
   -4.87220000E-04  +8.03300000E-04  +1.28644000E-03  -2.91920000E-04  +1.21320000E-04
   -1.36680000E-04  +7.50600000E-05  -4.70500000E-05  +1.04900000E-05  -3.48500000E-05
   +2.13600000E-05  +2.43600000E-05  +2.67600000E-05  -1.46920000E-04  -1.94640000E-04
   +6.60000000E-06  +1.33380000E-04  +1.99710000E-04  -3.68000000E-06  -1.42670000E-04
   -1.93540000E-04  -3.52700000E-05  +1.29900000E-05  +1.11960000E-04  -5.84200000E-05
   +1.55090000E-04  +6.30600000E-05  -9.80090000E-04  +7.83640000E-04  -1.17153000E-03
   -3.58400000E-05  -1.77800000E-05  +2.52900000E-05  -3.99590000E-04  +9.93000000E-05
   +3.09700000E-05  -8.17500000E-05  -2.25000000E-04  +1.38490000E-04  +4.61500000E-04
   -4.58850000E-04  -8.14200000E-04  +9.59666400E-02  +1.55222000E-03  +4.94029000E-03
   -1.70554000E-03  +1.64851000E-03  +2.60420000E-03  -1.44928000E-03  +5.42070000E-02
   -1.08988960E-01  -1.15367090E-01  +4.53108000E-03  -1.76593000E-03  -1.09935400E-02
   +4.45093000E-03  +5.91298000E-03  -1.09633000E-03  -4.77280000E-04  -7.00400000E-04
   +6.32230000E-04  -9.52140000E-04  -2.69249000E-03  +7.45080000E-04  +3.44030000E-04
   -1.85860000E-04  -1.09100000E-05  +2.34160000E-04  -3.85810000E-04  -5.54870000E-04
   -6.81400000E-04  +3.59740000E-04  -3.12030000E-04  -4.36600000E-05  +8.37000000E-06
   +1.52170000E-04  +2.06400000E-05  -6.44600000E-05  +9.56500000E-05  -1.65000000E-05
   -1.84150000E-04  -4.58280000E-04  +2.16110000E-04  +1.44310000E-04  +1.96410000E-04
   +1.82400000E-05  +1.76400000E-05  -1.68900000E-04  +2.87170000E-04  -1.15760000E-04
   -1.67200000E-05  -2.61400000E-05  +1.24590000E-04  +1.55790000E-04  +1.40675000E-03
   -4.43700000E-05  +4.00070000E-04  +1.41160000E-04  +7.94800000E-05  +9.36200000E-05
   +4.95100000E-05  -2.31290000E-04  +7.84200000E-05  -2.20830000E-04  -5.17580000E-04
   +1.61100000E-04  +8.55700000E-05  +1.22850000E-04  -7.49100000E-05  -6.55409700E-02
   +1.05709330E-01  -4.66725000E-03  -1.54635000E-03  -3.09529000E-03  +1.13176800E-02
   -1.28277000E-02  -1.57188600E-02  +7.92521300E-02  -1.14261510E-01  -2.41159760E-01
   -2.84366000E-03  +1.46364000E-03  +4.97750000E-03  -2.24803000E-03  -1.33222000E-03
   +2.32749000E-03  -5.22390000E-04  +7.75340000E-04  +2.01290000E-04  +2.01104000E-03
   +4.91700000E-05  -6.23870000E-04  -2.49870000E-04  +1.09220000E-04  +1.23540000E-04
   +2.48000000E-04  -6.73100000E-05  +6.93900000E-05  +1.14150000E-04  +1.57400000E-05
   -3.13900000E-05  +8.58200000E-05  -3.34500000E-05  -1.38800000E-05  -5.73600000E-05
   +2.64300000E-05  +6.24500000E-05  +5.16300000E-05  -1.05420000E-04  -2.36210000E-04
   -3.80000000E-05  +6.21800000E-05  +1.75730000E-04  +6.73100000E-05  -1.03080000E-04
   -1.36060000E-04  -1.47280000E-04  +1.12200000E-05  +1.33810000E-04  -6.18800000E-05
   +1.09230000E-04  +7.99700000E-05  +1.10409000E-03  -5.28740000E-04  +1.99970000E-04
   -1.08170000E-04  -5.59800000E-05  +7.41000000E-06  -5.55600000E-05  +1.31910000E-04
   +1.54900000E-05  +1.92610000E-04  +1.49720000E-04  -1.00210000E-04  +6.46410000E-04
   -6.97020000E-04  -9.38330000E-04  -8.57705100E-02  +1.26625390E-01  +2.51937060E-01
   -7.40540000E-04  +2.05420000E-04  +8.27940000E-04  -2.78652000E-03  +4.62133000E-03
   +9.20400000E-05  -9.94442000E-03  -3.76441000E-03  -2.48587000E-02  -1.33314680E-01
   -4.31409000E-03  -1.30163690E-01  +9.71809000E-03  +2.09822000E-03  +1.07979900E-02
   +3.49560000E-04  +3.09754000E-03  +1.59306000E-03  +7.53100000E-05  -9.78100000E-05
   -1.16422000E-03  -4.27570000E-04  +6.35400000E-05  +7.68400000E-05  +4.33490000E-04
   -1.88832000E-03  -3.49000000E-06  -6.88700000E-05  +1.33670000E-04  -4.70900000E-05
   +5.35000000E-06  +3.76100000E-05  +4.51500000E-05  +1.29200000E-05  -3.50700000E-05
   +4.81300000E-05  -4.92100000E-05  +6.46700000E-05  -8.14900000E-05  +1.92000000E-05
   +3.66000000E-06  -1.54100000E-05  +1.40400000E-05  +3.42500000E-05  -4.33600000E-05
   +7.12500000E-05  -3.40100000E-05  +1.09000000E-05  +4.94700000E-05  -5.42700000E-05
   +4.35400000E-05  +2.68300000E-05  -1.09190000E-04  -4.47500000E-05  +5.53600000E-05
   +3.61200000E-05  +3.48300000E-05  -1.38100000E-05  -2.74310000E-04  -8.58400000E-05
   +4.09980000E-04  +1.32200000E-05  +6.82130000E-04  -9.72400000E-05  -2.79720000E-04
   +6.79000000E-06  -3.70700000E-05  -1.83787000E-03  +9.22530000E-04  +1.36452880E-01
   +3.82590000E-04  -1.11387000E-03  +9.42000000E-05  +4.73926000E-03  +4.56386000E-03
   -1.88538000E-03  +6.43304000E-03  +4.10943000E-03  +1.17647300E-02  -3.73952000E-03
   -4.43891900E-02  -2.70519000E-02  -9.04079000E-03  +4.25277000E-03  -1.34558800E-02
   +3.32914000E-03  +2.47322000E-03  -3.71460000E-03  +1.84010000E-04  +4.03410000E-04
   +4.87720000E-04  +5.50000000E-06  +2.39000000E-05  -7.06300000E-05  -1.66389000E-03
   -1.90580000E-03  +1.85267000E-03  +1.00220000E-04  -2.43600000E-05  +8.70000000E-07
   +1.36900000E-05  -5.18100000E-05  -2.63000000E-06  -2.57000000E-05  -2.37200000E-05
   +2.79200000E-05  -2.02800000E-05  +2.09500000E-05  -7.75000000E-05  +3.07800000E-05
   +1.89200000E-05  -3.12800000E-05  -4.40000000E-07  +1.89200000E-05  +3.00400000E-05
   -5.48300000E-05  -6.38000000E-06  +3.11700000E-05  +3.34800000E-05  -1.54000000E-05
   +4.58900000E-05  -3.67700000E-05  -1.59400000E-05  +3.22200000E-05  -7.04000000E-06
   -2.30600000E-05  -1.67100000E-05  -2.27330000E-04  -2.90850000E-04  +3.58050000E-04
   -4.87920000E-04  -1.12380000E-04  -6.52170000E-04  -2.52540000E-04  -4.82460000E-04
   +2.27030000E-04  -2.02849000E-03  -3.18679000E-03  +1.50846000E-03  +2.27180000E-03
   +3.57163700E-02  +1.19533000E-03  -1.60890000E-04  +1.11740000E-04  -4.09300000E-04
   -1.64432000E-03  +2.66311000E-03  +1.48540000E-03  -5.49140000E-04  +2.96723000E-03
   -1.28844630E-01  -2.76893100E-02  -2.63042750E-01  -1.71718200E-02  -2.57870000E-04
   -1.63172900E-02  +2.10218000E-03  -3.97238000E-03  -2.10299000E-03  +1.93390000E-04
   -1.20340000E-04  +3.56600000E-05  +1.18600000E-05  -4.15900000E-05  +2.88800000E-05
   +2.50370000E-04  +1.73411000E-03  +1.25808000E-03  -6.80600000E-05  +1.67000000E-05
   -3.20000000E-07  -2.72000000E-06  +1.41900000E-05  +4.79000000E-06  +5.03000000E-06
   -1.48000000E-06  +5.95000000E-06  -2.91000000E-06  +3.92700000E-05  +3.34000000E-06
   -4.10000000E-06  -9.92000000E-06  -1.64300000E-05  +8.80000000E-07  +1.03700000E-05
   -2.15000000E-06  +6.39200000E-05  +5.14000000E-06  -2.10200000E-05  +7.23000000E-06
   -3.59500000E-05  +6.36000000E-06  -5.48900000E-05  +7.56000000E-06  -1.11400000E-05
   +2.11200000E-05  +2.28600000E-05  +1.51300000E-05  +1.04300000E-05  +3.06840000E-04
   +2.44250000E-04  -6.06700000E-04  -2.34000000E-05  -9.02890000E-04  +3.51000000E-05
   +2.18390000E-04  -1.07190000E-04  +4.67270000E-04  +1.70355000E-03  +2.72420000E-04
   +1.41381450E-01  +3.04850400E-02  +2.74911290E-01  -1.99700000E-05  -3.72500000E-05
   +3.51300000E-05  +6.31210000E-04  +6.53330000E-04  +1.01000000E-05  +1.07080000E-04
   -1.66580000E-04  -4.48900000E-05  +3.00500000E-05  -1.77900000E-05  +1.72500000E-05
   -1.06910000E-04  +5.53700000E-05  -1.86800000E-05  -4.84600000E-05  -9.30500000E-05
   +6.79600000E-05  +2.29585000E-03  +5.19518000E-03  -1.13470000E-03  -1.41112780E-01
   -1.29098940E-01  +1.03919100E-02  +1.41090000E-04  -4.17200000E-05  +3.11000000E-06
   +1.20870000E-04  +1.13282000E-03  -1.25881000E-03  -5.72800000E-05  +1.74080000E-04
   -2.71610000E-04  +5.28400000E-05  -9.84400000E-05  +1.88280000E-04  -5.00200000E-05
   -1.20000000E-06  -2.24860000E-04  -2.42000000E-06  +1.24890000E-04  +5.85000000E-06
   +2.57280000E-04  +2.22430000E-04  -2.69900000E-05  -9.70600000E-05  -6.49640000E-04
   +6.38280000E-04  +3.56900000E-05  -5.71800000E-05  +6.98200000E-05  +2.63710000E-04
   +1.78000000E-04  -1.02780000E-04  -3.25400000E-05  -6.79700000E-05  -3.27200000E-05
   -1.86700000E-05  +9.38000000E-06  +7.47000000E-06  +6.40000000E-06  -7.43000000E-06
   -2.11000000E-06  +1.51130000E-04  +3.32600000E-05  +3.54700000E-05  +2.19300000E-05
   +8.45000000E-06  +2.43700000E-05  +1.64800000E-05  -4.14000000E-06  +3.98000000E-06
   +1.48847080E-01  +2.16930000E-04  -3.08800000E-05  -3.98260000E-04  -7.04010000E-04
   +5.19220000E-04  -3.44920000E-04  +4.77800000E-04  +3.82000000E-06  +2.16840000E-04
   -1.93150000E-04  +1.23660000E-04  +1.33060000E-04  +1.24700000E-04  -1.81690000E-04
   -1.83320000E-04  +2.47800000E-04  +1.73500000E-05  +8.52000000E-05  -8.53960000E-03
   -1.31725000E-02  +1.63818000E-03  -1.28503100E-01  -2.21670700E-01  +1.29412200E-02
   -1.28960000E-04  +9.33000000E-05  +1.26700000E-05  +1.22341000E-03  -7.80460000E-04
   +2.14992000E-03  -1.71880000E-04  +3.04420000E-04  +1.71590000E-04  +5.35400000E-05
   -3.80700000E-05  +1.78070000E-04  -2.16720000E-04  +2.46860000E-04  -9.44200000E-05
   +1.26010000E-04  -4.05900000E-05  +2.23420000E-04  -7.12630000E-04  -4.02940000E-04
   -2.28500000E-04  +5.15010000E-04  +4.64170000E-04  -3.94490000E-04  +1.46190000E-04
   -2.54000000E-04  +3.65300000E-05  +4.26500000E-05  +5.83920000E-04  -1.61190000E-03
   +1.16090000E-04  +1.44600000E-04  +9.50700000E-05  +5.25000000E-06  -2.78900000E-05
   -2.12000000E-06  -1.02300000E-05  -2.27800000E-05  +1.18900000E-05  -2.20590000E-04
   -6.00700000E-05  +1.18850000E-04  +1.82000000E-06  -1.37100000E-05  -7.24000000E-06
   -7.13000000E-06  -2.07000000E-05  +6.17000000E-06  +1.40765810E-01  +2.39222960E-01
   -7.03300000E-05  +1.83000000E-06  -1.63500000E-05  +8.23380000E-04  -5.28630000E-04
   +8.74000000E-04  -2.29630000E-04  -2.10680000E-04  -5.46600000E-05  +1.01380000E-04
   -5.15700000E-05  -1.27050000E-04  -1.27830000E-04  +7.62600000E-05  +2.64700000E-05
   +1.32220000E-04  +1.05870000E-04  +1.02320000E-04  +1.65262000E-02  +2.31626900E-02
   -4.19316000E-03  +9.24040000E-03  +1.16835800E-02  -4.66429300E-02  +1.99920000E-04
   -1.18590000E-04  +9.05000000E-06  -6.03940000E-04  +2.69978000E-03  -5.16611000E-03
   -8.09620000E-04  -8.32460000E-04  -9.47740000E-04  +5.00700000E-05  +2.34200000E-05
   +4.38180000E-04  +2.35630000E-04  -2.42180000E-04  -7.61280000E-04  -2.37700000E-04
   +3.94470000E-04  -7.65100000E-05  +1.40752000E-03  +7.30940000E-04  +6.74610000E-04
   -1.07091000E-03  -3.48310000E-04  +3.19540000E-04  -8.36300000E-05  +1.71480000E-04
   +2.48360000E-04  +8.56880000E-04  +1.15468000E-03  +7.73150000E-04  -1.50960000E-04
   -1.79040000E-04  -4.20200000E-05  -1.46600000E-05  +1.53400000E-05  +1.55300000E-05
   +9.75000000E-06  -3.64000000E-06  -1.54700000E-05  -1.73880000E-04  -2.20400000E-05
   -1.36000000E-06  -3.32700000E-05  +3.29100000E-05  -4.49400000E-05  +1.96100000E-05
   +2.40000000E-05  -2.21000000E-06  -9.56409000E-03  -1.61055000E-02  +5.36059400E-02
   +1.45840000E-04  -1.64090000E-04  -2.72350000E-04  +3.17750000E-04  +5.92140000E-04
   -1.12430000E-03  +4.21520000E-04  +3.16150000E-04  +4.42150000E-04  -3.23500000E-04
   +9.74900000E-05  +9.54500000E-05  +2.88010000E-04  -1.87870000E-04  -1.95340000E-04
   +9.43800000E-05  -1.13300000E-05  -6.90200000E-05  -4.27088000E-03  +1.15269000E-03
   +2.43410000E-04  -2.95251210E-01  +7.64268100E-02  -1.61333500E-02  -3.52040000E-04
   +1.50540000E-04  +4.09000000E-06  -2.86350000E-04  +1.09340000E-04  -3.68110000E-04
   -1.65200000E-05  +5.27100000E-05  -1.89490000E-04  +6.31600000E-05  -6.32900000E-05
   +1.34990000E-04  -7.87300000E-05  -3.09700000E-05  -8.43500000E-05  +8.67000000E-06
   +6.79000000E-06  -4.09500000E-05  +4.01200000E-05  +2.12650000E-04  +7.39400000E-05
   -8.87500000E-04  -1.60462000E-03  +1.51984000E-03  +5.47300000E-05  -1.98200000E-05
   +3.24900000E-05  +1.19720000E-04  -1.15700000E-04  +6.52480000E-04  -1.00950000E-04
   -1.14840000E-04  -9.10000000E-06  +3.75100000E-05  -2.30200000E-05  -2.36400000E-05
   -2.75200000E-05  +8.23000000E-06  +1.67300000E-05  -3.46900000E-05  -1.55070000E-04
   -8.20000000E-06  +6.74000000E-06  -1.66400000E-05  -8.36800000E-05  -4.52100000E-05
   -1.84100000E-05  +9.27000000E-06  -1.57327100E-02  +6.30759000E-03  -7.16910000E-04
   +3.18863090E-01  +1.93790000E-04  -5.19300000E-05  +8.07500000E-05  +2.16450000E-04
   -3.37670000E-04  +2.78276000E-03  +6.19520000E-04  -5.34060000E-04  -1.74190000E-04
   +1.85990000E-04  +9.82200000E-05  +2.09840000E-04  -9.47700000E-05  +2.86700000E-05
   +6.94000000E-05  -4.16000000E-05  -3.36900000E-05  +1.66060000E-04  +1.49870000E-02
   -5.81289000E-03  +7.34240000E-04  +7.43329000E-02  -7.08496800E-02  +3.72684000E-03
   +2.02710000E-04  -5.71300000E-05  +1.08600000E-05  +1.14102000E-03  -3.89240000E-04
   +3.51900000E-05  +1.37680000E-04  -8.45700000E-05  +3.24030000E-04  -1.58110000E-04
   +1.34880000E-04  -2.81020000E-04  +1.05840000E-04  -9.84100000E-05  +1.36530000E-04
   -5.26700000E-05  +6.17300000E-05  -7.68300000E-05  -1.15800000E-05  +6.17000000E-05
   +1.13100000E-05  -5.59380000E-04  +1.90420000E-04  -1.36940000E-04  -1.15890000E-04
   +1.64420000E-04  -5.92200000E-05  -6.32360000E-04  -1.18800000E-05  -1.04176000E-03
   -1.34280000E-04  +6.67000000E-06  -8.22700000E-05  -2.97000000E-05  +1.33500000E-05
   +3.67000000E-06  +3.10400000E-05  -2.41800000E-05  -1.63600000E-05  -5.96600000E-05
   +2.70960000E-04  +1.56080000E-04  -3.47400000E-05  +1.50500000E-05  +5.92600000E-05
   +8.78500000E-05  +3.39000000E-06  -6.45000000E-06  -2.54848400E-02  +9.39644000E-03
   -1.71822000E-03  -8.34697200E-02  +7.36557700E-02  +1.51390000E-04  -6.68880000E-04
   -4.08800000E-04  +6.67620000E-04  +1.59194000E-03  -5.36780000E-03  -1.09249000E-03
   +8.81280000E-04  +3.08580000E-04  -3.38250000E-04  -2.57630000E-04  -5.35700000E-05
   +3.03350000E-04  -1.00210000E-04  -5.82800000E-05  -2.00340000E-04  -3.45200000E-05
   +2.18570000E-04  -2.83348100E-02  +7.96294000E-03  -2.48397000E-03  -1.31788100E-02
   +2.76280000E-03  -4.88120300E-02  -3.12730000E-04  +1.92160000E-04  +2.71600000E-05
   -4.05910000E-04  +2.05450000E-04  +8.44810000E-04  +3.61390000E-04  +1.41850000E-04
   +1.90250000E-04  -3.04200000E-05  +3.99000000E-06  -9.99200000E-05  -6.23400000E-05
   +6.72500000E-05  +6.90900000E-05  +4.27500000E-05  -5.21800000E-05  +1.46500000E-05
   -6.66400000E-05  -2.09170000E-04  -3.98000000E-06  +7.45140000E-04  +1.96180000E-04
   -4.57280000E-04  +4.01000000E-05  -4.92500000E-05  -3.18900000E-05  -1.35944000E-03
   +8.12780000E-04  +1.13169000E-03  +3.14620000E-04  +1.18910000E-04  +4.29400000E-05
   +6.97000000E-06  -6.02000000E-06  -3.24700000E-05  -4.57700000E-05  +2.77000000E-06
   +1.19600000E-05  +1.93350000E-04  +3.31900000E-04  +3.73960000E-04  +6.28800000E-05
   +1.27280000E-04  -5.78000000E-05  -1.27520000E-04  +1.79900000E-05  +2.20000000E-07
   +1.52171000E-03  -8.32060000E-04  -1.00268000E-03  +1.66262900E-02  -6.19553000E-03
   +5.40141500E-02  -1.05983000E-03  +5.83940000E-04  -9.87470000E-04  +1.79740000E-04
   -5.65960000E-04  +3.35890000E-04  -1.29610000E-04  +4.49000000E-06  +1.22400000E-05
   +1.82790000E-04  -4.32000000E-05  +1.68200000E-05  -1.11000000E-04  +6.62500000E-05
   +1.06330000E-04  -1.21880000E-04  +2.18400000E-05  +1.17220000E-04  -5.56820000E-04
   -4.37578000E-03  -3.86832000E-03  -5.80172400E-02  +3.44696400E-02  +4.37862200E-02
   +1.45290000E-04  -6.11500000E-05  +3.06700000E-05  +4.31500000E-05  +4.63700000E-04
   +4.45750000E-04  +4.71260000E-04  -4.55230000E-04  +8.22930000E-04  -2.56650000E-04
   +1.80040000E-04  -4.95410000E-04  +9.65200000E-05  -1.10750000E-04  +4.52670000E-04
   -3.34800000E-05  -1.74000000E-05  -5.60400000E-05  +1.53000000E-06  -1.67800000E-04
   -1.01070000E-04  -9.84800000E-05  -2.83480000E-04  -8.85800000E-05  -1.23480000E-04
   +1.84220000E-04  -1.63930000E-04  -2.01090000E-04  +7.72330000E-04  -1.13752000E-03
   +1.06260000E-04  +2.98200000E-05  +2.33600000E-05  -3.11200000E-05  +2.53300000E-05
   -4.68000000E-06  +1.57200000E-05  +2.70700000E-05  -2.35800000E-05  -2.11456000E-03
   +2.64330000E-03  -7.87890000E-04  +4.88400000E-05  +1.06000000E-06  +6.80400000E-05
   +1.33000000E-05  +7.00000000E-07  +6.12000000E-06  +4.08998000E-03  -1.13853200E-02
   -1.58487400E-02  -4.16102000E-03  +1.86740200E-02  +2.43631700E-02  +6.13833600E-02
   +9.02310000E-04  -1.02972000E-03  +5.44120000E-04  +4.64000000E-05  +3.70510000E-04
   -1.14627000E-03  -4.33000000E-06  +1.46990000E-04  +1.13900000E-05  -8.23500000E-05
   -3.10000000E-07  +5.69800000E-05  +1.11120000E-04  +3.45900000E-05  -1.05610000E-04
   -8.18600000E-05  -2.96400000E-05  +1.07080000E-04  -4.30101000E-03  +1.01974300E-02
   +1.19279000E-02  +3.40121000E-02  -1.43997820E-01  -1.27506540E-01  -7.66400000E-05
   +4.16300000E-05  +2.23500000E-05  +1.88900000E-05  +9.85130000E-04  -7.98300000E-04
   -1.20498000E-03  -1.04641000E-03  -4.63700000E-05  +1.42190000E-04  +2.76200000E-05
   +2.79000000E-05  +2.39240000E-04  -6.94000000E-05  +3.25800000E-05  -6.34200000E-05
   +5.75000000E-06  -2.73900000E-05  +2.08470000E-04  +7.15700000E-05  -3.52100000E-05
   -2.36070000E-04  -1.05140000E-04  +3.17500000E-05  -7.10500000E-05  +6.63300000E-05
   -3.26000000E-06  +6.34320000E-04  -8.95340000E-04  +1.99268000E-03  -5.96300000E-05
   -4.14300000E-05  -1.62400000E-05  +3.10000000E-06  +3.85000000E-06  -1.65600000E-05
   -1.31700000E-05  -2.87600000E-05  +1.36400000E-05  +2.87036000E-03  -1.60486000E-03
   +9.72540000E-04  -1.31100000E-05  -1.55000000E-06  -4.58000000E-06  -1.94400000E-05
   -4.53000000E-06  +5.70000000E-06  +6.84254000E-03  -1.49030000E-02  -1.97349200E-02
   +4.44550000E-04  -5.91855000E-03  -6.10658000E-03  -3.94743500E-02  +1.57931130E-01
   +4.28310000E-04  -9.26630000E-04  -4.69290000E-04  +1.40947000E-03  -5.59060000E-04
   +6.60340000E-04  -3.75020000E-04  -2.24400000E-05  -1.64700000E-04  +2.78270000E-04
   -9.39100000E-05  +7.04700000E-05  +1.10690000E-04  +6.01100000E-05  +2.23520000E-04
   -3.22830000E-04  +2.01460000E-04  +5.60560000E-04  +5.53783000E-03  -1.85596000E-02
   -1.91272100E-02  +4.22864400E-02  -1.24714270E-01  -2.12649170E-01  +8.39800000E-05
   +2.80800000E-05  +6.09700000E-05  -1.27040000E-04  -8.59650000E-04  +8.79600000E-05
   -3.74680000E-04  -2.44270000E-04  -4.94740000E-04  +3.29000000E-05  -3.48900000E-05
   +6.47940000E-04  +3.81700000E-05  +3.97000000E-05  -8.39460000E-04  -4.81200000E-05
   +2.19560000E-04  +2.70240000E-04  +8.00300000E-05  -1.91960000E-04  +1.99750000E-04
   -2.65210000E-04  +1.39980000E-04  +2.71250000E-04  +3.01200000E-05  -7.56000000E-05
   +2.87750000E-04  -8.77290000E-04  +4.14823000E-03  -5.22412000E-03  -2.06550000E-04
   -9.53100000E-05  +3.39400000E-05  -4.41200000E-05  +9.28000000E-06  -9.60000000E-06
   -3.35200000E-05  -1.73100000E-05  -1.70300000E-05  -3.36080000E-04  +7.72510000E-04
   +1.06304000E-03  +1.56480000E-04  -4.10000000E-05  +1.47840000E-04  +1.49000000E-06
   +2.03600000E-05  -8.20000000E-06  -7.87580000E-04  +1.78127000E-03  +2.02871000E-03
   -4.01250000E-04  +2.06231000E-03  +2.19225000E-03  -4.68713200E-02  +1.37920810E-01
   +2.30213780E-01  -2.99500000E-05  +1.15000000E-05  -1.31380000E-04  +1.66760000E-04
   -2.25470000E-04  -6.94800000E-05  -9.33680000E-04  +4.91160000E-04  +7.99340000E-04
   -1.96300000E-05  -7.31400000E-05  -1.96690000E-04  -3.44700000E-05  +5.25100000E-05
   +5.50000000E-07  +6.78800000E-05  -6.00300000E-05  -7.67000000E-05  -1.53084000E-03
   -3.38777000E-03  +3.70845000E-03  -1.72690000E-04  +3.72910000E-04  +2.76970000E-04
   +8.59600000E-05  -5.71300000E-05  -3.51900000E-05  +2.45960000E-04  -1.05610000E-04
   -7.68560000E-04  +4.91000000E-06  -6.58100000E-05  +4.69400000E-05  -3.06600000E-05
   +3.62400000E-05  -8.70000000E-07  +8.69800000E-05  -8.10600000E-05  -1.04310000E-04
   -6.66600000E-05  +1.54770000E-04  +1.73850000E-04  +6.54900000E-05  -4.39850000E-04
   -2.52960000E-04  +1.53650000E-04  +3.10260000E-04  +3.85770000E-04  -7.13800000E-05
   +1.10620000E-04  +4.27600000E-05  -4.63862500E-02  +2.57559000E-03  -4.48555000E-03
   -2.36400000E-05  -8.23000000E-06  +1.84330000E-04  -9.51000000E-06  +9.78000000E-06
   -1.42000000E-06  +7.90000000E-06  -7.23000000E-06  -9.54000000E-06  +1.81500000E-05
   -5.13900000E-05  -5.77600000E-05  -2.06448000E-03  +9.14260000E-04  +3.06090000E-04
   -2.22700000E-05  -3.56000000E-06  +1.53500000E-05  +3.17000000E-05  +3.37100000E-04
   -1.71070000E-04  +3.31640000E-04  -9.88500000E-05  +3.38750000E-04  +6.78960000E-04
   +2.39600000E-05  +1.33430000E-04  +4.76986000E-02  -6.90100000E-05  -1.19560000E-04
   -1.01370000E-04  -2.49980000E-04  +5.80510000E-04  +4.96720000E-04  +8.24440000E-04
   -1.60000000E-04  +7.11170000E-04  +9.69000000E-05  -1.48760000E-04  -2.50150000E-04
   +9.89700000E-05  +5.13200000E-05  +1.72070000E-04  -1.06970000E-04  +1.66600000E-05
   -3.30900000E-05  -1.65394000E-03  +1.08079900E-02  -2.11611000E-02  +8.81440000E-04
   -3.26078000E-03  -2.72783000E-03  -2.11100000E-05  -1.62600000E-05  -3.98600000E-05
   -1.43060000E-04  +1.25360000E-03  +2.39230000E-04  +3.00800000E-04  +5.71200000E-05
   +5.84700000E-05  -1.30400000E-05  +5.08000000E-06  +7.15000000E-05  +3.03700000E-05
   -2.08750000E-04  -3.96060000E-04  -4.52000000E-06  +2.31490000E-04  +2.97140000E-04
   -4.42160000E-04  -1.94311000E-03  -2.43570000E-04  -2.30680000E-04  -2.32320000E-04
   +8.11300000E-05  -5.94300000E-05  +1.90590000E-04  +1.27370000E-04  +1.82957000E-03
   -8.63395500E-02  +9.49271500E-02  -5.15800000E-05  -6.69700000E-05  +3.50000000E-06
   +1.25000000E-05  -5.04000000E-06  -5.03000000E-06  +1.37000000E-06  +8.13000000E-06
   -1.31900000E-05  -2.38400000E-05  +5.54100000E-05  -6.23000000E-06  +1.19827000E-03
   -6.39200000E-05  -4.23210000E-04  -2.50000000E-07  +9.16000000E-06  +6.41000000E-06
   +3.27630000E-04  +1.57420000E-04  -1.71520000E-04  -1.34350000E-04  -1.28400000E-04
   -2.63700000E-05  -1.35510000E-04  +8.03270000E-04  -1.40118000E-03  -2.69196000E-03
   +9.46007300E-02  +2.02800000E-04  -2.08240000E-04  +3.91500000E-05  -9.32990000E-04
   +2.79130000E-04  +1.04980000E-04  -9.20600000E-04  -1.22910000E-04  -6.54460000E-04
   +1.46010000E-04  +1.57450000E-04  +6.13060000E-04  -9.02600000E-05  +8.83600000E-05
   -5.73000000E-05  -6.94400000E-05  +7.19000000E-05  +8.16100000E-05  -1.41016000E-03
   +1.02872900E-02  -1.82954500E-02  +1.31184000E-03  -4.66733000E-03  -3.08305000E-03
   +1.98400000E-05  +1.39200000E-05  +8.98400000E-05  +1.19570000E-04  +3.91630000E-04
   -5.16050000E-04  -5.21500000E-05  +1.51520000E-04  +1.65960000E-04  +7.55600000E-05
   -1.33720000E-04  +2.28990000E-04  -2.06460000E-04  -4.59600000E-05  -6.71790000E-04
   +1.17610000E-04  +1.68350000E-04  +7.66990000E-04  +1.73690000E-04  +7.28370000E-04
   -7.74460000E-04  +2.29450000E-04  +1.16550000E-04  +4.64890000E-04  +5.27000000E-06
   +1.27130000E-04  +2.62020000E-04  -3.88551000E-03  +9.24996100E-02  -2.81176590E-01
   +1.40310000E-04  +7.93200000E-05  +1.80750000E-04  -1.24300000E-05  +1.12100000E-05
   -2.15000000E-06  +2.47900000E-05  +9.20000000E-07  -2.16000000E-06  -6.83700000E-05
   +1.36230000E-04  +8.69400000E-05  +8.21300000E-05  +3.35760000E-04  +1.13407000E-03
   +2.93300000E-05  -2.87100000E-05  -8.97000000E-06  -1.96400000E-05  -1.61280000E-04
   +4.53710000E-04  +4.76600000E-05  +6.40000000E-07  +2.70810000E-04  -3.58780000E-04
   +6.36020000E-04  -1.44318000E-03  +5.48700000E-03  -1.03286480E-01  +3.05609030E-01
   +2.52980000E-04  +3.15400000E-05  -5.43160000E-04  +3.02660000E-04  +9.19780000E-04
   +6.22350000E-04  +1.43050000E-04  +2.30400000E-05  -1.09860000E-04  +1.78110000E-04
   +1.04600000E-04  +9.05500000E-05  +2.53360000E-04  -3.10600000E-05  +1.91340000E-04
   -3.10340000E-04  +3.16700000E-05  +2.70000000E-07  -3.88756000E-03  +1.04004000E-03
   -6.34950000E-04  +4.67770000E-04  -4.73470000E-04  -9.37210000E-04  -2.97700000E-04
   +1.28170000E-04  -6.03000000E-06  +7.26100000E-05  +5.10030000E-04  +3.66780000E-04
   -1.05430000E-04  +1.32490000E-04  -1.87880000E-04  +3.79400000E-05  +5.91200000E-05
   +1.05830000E-04  -1.80600000E-05  -4.79000000E-05  -1.31000000E-05  +4.15100000E-05
   +5.88300000E-05  -1.11000000E-06  -1.02090000E-04  -9.52400000E-05  +9.77100000E-05
   -1.10931000E-03  -2.15860000E-03  -8.10910000E-04  +1.03100000E-05  +3.83600000E-05
   +2.07000000E-06  -2.67531790E-01  +1.05487810E-01  -3.62191900E-02  +5.80000000E-04
   +3.69530000E-04  -7.79000000E-05  +3.04800000E-05  -3.06400000E-05  -1.30400000E-05
   -5.68300000E-05  -1.73100000E-05  +1.88100000E-05  +4.37600000E-05  +5.15800000E-05
   +8.33500000E-05  -1.26620000E-04  -9.61200000E-05  +3.69440000E-04  -1.05100000E-05
   +2.39000000E-06  -1.34600000E-05  -2.82380000E-04  +5.47500000E-05  +1.16610000E-04
   +4.87270000E-04  -8.36200000E-05  +3.19150000E-04  +3.28320000E-04  -2.10260000E-04
   -7.14900000E-05  +8.71370000E-04  -1.06070000E-03  +3.69390000E-04  +2.88683630E-01
   +1.36705000E-03  -3.18810000E-04  +4.38570000E-04  -7.69440000E-04  -2.12797000E-03
   -3.39921000E-03  -1.71500000E-04  +2.88700000E-04  -4.97950000E-04  +1.74910000E-04
   -4.36600000E-05  -4.10800000E-05  -1.59280000E-04  +4.19300000E-05  +1.06970000E-04
   -7.27000000E-06  -6.24300000E-05  -4.01460000E-04  +2.13053500E-02  -1.03476500E-02
   +3.44941000E-03  +5.92900000E-05  +5.82790000E-04  +1.53675000E-03  +1.99800000E-04
   -9.52700000E-05  +1.16500000E-05  +8.44430000E-04  -2.44670000E-04  +3.46800000E-04
   -2.03200000E-05  +1.25520000E-04  -9.11000000E-05  -6.62500000E-05  +7.83400000E-05
   -1.90000000E-06  +1.67490000E-04  -4.30500000E-05  +1.40750000E-04  -7.13200000E-05
   +7.30000000E-06  -7.94700000E-05  -1.82940000E-04  -1.47860000E-04  +1.04620000E-04
   -1.36368000E-03  -7.93840000E-04  +2.23930000E-04  -8.33400000E-05  +6.07000000E-05
   -4.41000000E-05  +1.02867800E-01  -9.56423300E-02  +1.73300800E-02  -6.60300000E-04
   -3.38820000E-04  +6.02200000E-05  -2.61300000E-05  +1.96100000E-05  +5.24000000E-06
   +1.15710000E-04  -6.51100000E-05  +1.17000000E-06  -5.13800000E-05  -1.76700000E-05
   -5.56800000E-05  -3.65840000E-04  -6.21000000E-06  +8.82600000E-05  +4.52700000E-05
   +9.83000000E-06  +8.30000000E-07  -1.83410000E-04  +7.16000000E-06  -1.00270000E-04
   -2.95570000E-04  +4.74840000E-04  -4.97190000E-04  -3.10980000E-04  -9.08600000E-05
   +2.22280000E-04  +1.09061100E-02  -5.63199000E-03  +1.62273000E-03  -1.13755330E-01
   +1.02396370E-01  +1.18338000E-03  -5.36610000E-04  +5.71850000E-04  -7.07530000E-04
   -3.14812000E-03  -3.81101000E-03  -5.56250000E-04  -1.81300000E-05  -9.82480000E-04
   -1.04300000E-05  +1.53540000E-04  +4.54950000E-04  -1.92070000E-04  -1.53300000E-05
   -1.92490000E-04  +2.30840000E-04  +1.98300000E-05  -2.41340000E-04  +2.17443200E-02
   -9.55113000E-03  +1.64830000E-03  +1.54279000E-03  -8.05810000E-04  +7.18580000E-04
   +1.21500000E-04  -3.15800000E-05  +8.88800000E-05  -1.38670000E-04  +7.21920000E-04
   +6.63780000E-04  +1.32670000E-04  +2.61300000E-05  -1.01620000E-04  -2.30000000E-06
   +7.13700000E-05  +1.42200000E-05  -3.72600000E-05  -8.43200000E-05  -4.14900000E-05
   -3.09500000E-05  +2.80200000E-05  +1.11740000E-04  +1.12440000E-04  +1.01270000E-04
   -2.03290000E-04  -4.03350000E-04  -7.00450000E-04  -3.07750000E-04  -1.39500000E-05
   +8.58700000E-05  +1.65800000E-05  -3.83043600E-02  +1.89944700E-02  -5.37169800E-02
   +1.67240000E-04  +8.05500000E-05  -1.60090000E-04  -2.23200000E-05  +1.79900000E-05
   +4.33000000E-06  +1.27130000E-04  -1.76900000E-05  -6.95000000E-06  -5.19000000E-05
   -7.50600000E-05  +4.55300000E-05  +1.40160000E-04  +2.80310000E-04  +5.77330000E-04
   +3.03100000E-05  -1.13300000E-05  -1.92000000E-06  +3.49700000E-05  +1.38570000E-04
   +5.26800000E-05  -3.13080000E-04  -3.17790000E-04  -9.12530000E-04  -1.40860000E-04
   +1.71320000E-04  +2.66650000E-04  -2.75083600E-02  +1.19232700E-02  -3.73202000E-03
   +4.03276200E-02  -1.58980300E-02  +5.95186100E-02  +2.59280000E-04  -9.67100000E-05
   -4.24800000E-05  +4.89680000E-04  +9.51230000E-04  +1.96500000E-05  -3.45460000E-04
   +6.90550000E-04  -1.98630000E-04  +9.01900000E-05  -4.35800000E-05  -3.29300000E-05
   -1.16160000E-04  +4.90300000E-05  +5.24300000E-05  -3.08000000E-06  -1.07400000E-05
   -1.85000000E-06  +2.91068000E-03  +4.60268000E-03  +3.34020000E-04  -1.68990000E-04
   +1.08710000E-04  +1.44500000E-05  +1.35520000E-04  -6.19900000E-05  -2.81000000E-06
   +1.65350000E-04  +1.79079000E-03  +8.80320000E-04  +2.37350000E-04  +1.49160000E-04
   -1.07040000E-04  -1.62000000E-05  +1.35450000E-04  -8.72000000E-06  +2.38700000E-05
   +3.14900000E-05  +1.36420000E-04  +5.75900000E-05  +1.01100000E-05  +6.80000000E-06
   -8.07800000E-05  +9.86800000E-05  +5.72300000E-05  -2.31020000E-04  -1.00801000E-03
   -5.72630000E-04  -4.71000000E-06  -1.65500000E-05  -4.33500000E-05  -1.82037520E-01
   -1.35431550E-01  +1.39630600E-02  +3.76750000E-04  +2.12780000E-04  -1.02760000E-04
   -1.54000000E-05  +3.20000000E-06  +1.05400000E-05  +1.15200000E-05  -3.51900000E-05
   +2.96000000E-06  +2.03700000E-05  +1.73100000E-05  -2.76300000E-05  -1.31110000E-04
   +4.44840000E-04  -1.51330000E-04  +2.43400000E-05  +1.74100000E-05  -8.67000000E-06
   +2.57650000E-04  +8.64500000E-05  -3.80540000E-04  -1.74700000E-05  -1.06410000E-04
   +6.55400000E-05  +1.38940000E-04  +2.60890000E-04  -1.23020000E-04  +7.01030000E-04
   +2.24172000E-03  -4.14480000E-04  -1.77522100E-02  -2.06864900E-02  +2.98112000E-03
   +1.95677400E-01  +4.53820000E-04  -5.18300000E-05  -3.44050000E-04  -9.68280000E-04
   +7.61030000E-04  +5.02960000E-04  +1.84580000E-04  +1.78000000E-06  -3.35220000E-04
   +3.52200000E-04  +6.48500000E-05  +1.37390000E-04  +1.51090000E-04  -2.58300000E-05
   +2.92310000E-04  -3.76860000E-04  +1.19720000E-04  -6.79500000E-05  -1.55924900E-02
   -1.78497000E-02  +1.54240000E-03  -9.70000000E-06  +2.66220000E-04  +1.23239000E-03
   -2.15000000E-04  +1.16150000E-04  +1.10000000E-06  +6.62690000E-04  -2.51860000E-03
   -3.33949000E-03  -8.67090000E-04  -3.88020000E-04  +8.25250000E-04  +1.28410000E-04
   -2.63080000E-04  -2.11150000E-04  -3.57960000E-04  +2.86260000E-04  -1.11910000E-04
   +7.51700000E-05  -1.28010000E-04  -1.27040000E-04  -1.19870000E-04  +4.40240000E-04
   -3.46230000E-04  +1.03839000E-03  +3.98130000E-04  -1.02810000E-04  +2.11950000E-04
   -3.29010000E-04  +2.86200000E-05  -1.33501100E-01  -1.78805300E-01  +1.43983400E-02
   -7.20300000E-05  +1.04100000E-05  +1.03890000E-04  +1.95300000E-05  -3.33900000E-05
   -3.48000000E-06  -3.85900000E-05  -2.69600000E-05  +2.43100000E-05  -2.02000000E-05
   -9.22000000E-06  +9.05800000E-05  +5.91200000E-05  -6.05870000E-04  +6.69230000E-04
   +5.85000000E-06  -2.16600000E-05  -8.72000000E-06  +3.97000000E-05  +7.00920000E-04
   -3.31690000E-04  +1.16320000E-04  +3.47000000E-05  +2.59600000E-05  +3.35280000E-04
   +2.11540000E-04  +6.03300000E-05  -7.88795000E-03  -8.32572000E-03  +2.95510000E-04
   +9.98824000E-03  +1.11834700E-02  -1.45287000E-03  +1.46016140E-01  +1.94819430E-01
   +7.31100000E-05  +1.44560000E-04  -2.94860000E-04  -4.01250000E-04  +6.45460000E-04
   +7.41300000E-04  -9.71000000E-06  +3.57400000E-05  +6.87790000E-04  +7.01400000E-05
   -1.18130000E-04  -1.46570000E-04  +1.16900000E-04  +6.25100000E-05  +1.75220000E-04
   -1.54200000E-04  +8.73000000E-06  -1.03850000E-04  -1.57710800E-02  -1.62174900E-02
   +1.04180000E-04  -8.53340000E-04  -9.14880000E-04  +8.12390000E-04  -8.85000000E-05
   +3.20700000E-05  -4.89300000E-05  +2.00090000E-04  -2.85499000E-03  -3.39290000E-03
   -8.26630000E-04  -4.15940000E-04  +9.39410000E-04  +1.35800000E-04  -3.45830000E-04
   -2.59200000E-05  -2.67500000E-04  +1.69470000E-04  -5.14500000E-04  +1.06320000E-04
   +2.48600000E-05  +3.70090000E-04  +1.02400000E-04  +4.16470000E-04  -8.46070000E-04
   +6.41580000E-04  +2.35190000E-04  +2.56860000E-04  +8.76400000E-05  -1.22850000E-04
   +1.81280000E-04  +1.43762900E-02  +1.54168900E-02  -4.86818000E-02  +3.19000000E-06
   +4.44600000E-05  +1.09750000E-04  +9.87000000E-06  -1.43500000E-05  -5.05000000E-06
   -3.11600000E-05  -2.25200000E-05  +8.31000000E-06  -5.84000000E-06  -5.51600000E-05
   -7.54000000E-06  +1.26440000E-04  +3.14760000E-04  -3.95870000E-04  -2.32000000E-05
   -1.34900000E-05  +7.55000000E-06  +2.18390000E-04  +1.45140000E-04  -9.04820000E-04
   +2.95300000E-05  -3.10800000E-05  -5.57100000E-05  +2.51550000E-04  +3.14670000E-04
   +2.42220000E-04  +2.19797300E-02  +2.07029500E-02  -1.16286000E-03  -3.63317000E-03
   -4.14201000E-03  -6.11170000E-04  -1.64619500E-02  -1.31472100E-02  +5.22747500E-02
   +1.85900000E-05  -5.16600000E-05  -3.61010000E-04  -1.75980000E-04  -1.21140000E-04
   -2.17800000E-05  +1.82500000E-05  -3.40700000E-05  +1.12930000E-04  -2.17900000E-05
   +4.35000000E-05  +6.18700000E-05  -2.89300000E-05  -3.23900000E-05  -7.79500000E-05
   +6.54400000E-05  +5.58100000E-05  +1.52310000E-04  +6.51870000E-04  +1.25404000E-03
   +2.81360000E-04  +1.94820000E-04  -5.11360000E-04  -4.77470000E-04  +4.58700000E-05
   -2.26600000E-05  +4.05500000E-05  +4.85800000E-05  +2.43424000E-03  -1.61194000E-03
   -8.54410300E-02  +4.82104300E-02  -9.45409700E-02  +6.18668000E-03  +5.22769000E-03
   -9.65134000E-03  +1.18694700E-02  +3.89852000E-03  -2.20803000E-03  -1.95731000E-03
   -3.55410000E-04  +5.42760000E-04  +8.38490000E-04  -9.39690000E-04  +4.80400000E-04
   +1.76251000E-03  -1.23921000E-03  +6.04000000E-05  -2.54551000E-03  -4.47400000E-04
   +5.46110000E-04  +5.34800000E-05  -1.19190000E-04  +1.05080000E-04  +1.90260000E-04
   +1.19530000E-04  -1.91360000E-04  -1.63800000E-05  +1.51300000E-05  -1.13600000E-05
   -2.11000000E-06  +1.29600000E-05  -1.41300000E-05  -1.46880000E-04  +2.42000000E-05
   +1.21180000E-04  +1.15400000E-05  +7.86000000E-06  +2.50100000E-05  +7.35000000E-06
   +1.69100000E-05  +7.80000000E-07  +2.68000000E-06  +2.31120000E-04  +2.92570000E-04
   +2.54400000E-05  +6.52200000E-05  -1.66700000E-05  -7.07940000E-04  -8.74570000E-04
   +3.48860000E-04  +1.06400000E-05  +3.84100000E-05  +9.41900000E-05  +9.47000000E-06
   +1.98600000E-05  -2.28000000E-05  -1.90300000E-05  -1.35100000E-05  -1.31200000E-05
   +7.47717000E-02  +7.54700000E-05  -6.09500000E-05  -3.17900000E-05  -1.26950000E-04
   -1.09920000E-04  +3.68800000E-05  +3.58600000E-05  -5.98500000E-05  +1.84200000E-05
   +9.32000000E-06  +1.88200000E-05  +1.44600000E-05  -3.83000000E-06  -6.51000000E-06
   -6.66000000E-06  -3.50000000E-07  +2.87200000E-05  +1.56300000E-05  +2.75180000E-04
   +1.15893000E-03  +3.53550000E-04  -1.35135000E-03  -1.05846000E-03  +1.87290000E-04
   +7.21000000E-06  -3.45000000E-06  +4.13000000E-06  -6.20283000E-03  +8.54964000E-03
   -1.69845500E-02  +4.78771900E-02  -1.01191170E-01  +9.46628800E-02  +1.37104200E-02
   -8.30526000E-03  +2.77614200E-02  +3.65355000E-03  -1.69181000E-03  -5.43523000E-03
   -6.22770000E-04  +5.09700000E-05  +3.96560000E-04  +5.27960000E-04  -3.01795000E-03
   -2.38020000E-03  -7.61940000E-04  +1.22799000E-03  +1.09803000E-03  +5.74560000E-04
   -2.28163000E-03  +2.29833000E-03  +1.50320000E-04  -1.10000000E-05  +1.31150000E-04
   +2.73080000E-04  +1.56400000E-04  -6.57200000E-05  -5.32000000E-06  +1.51000000E-06
   +1.18000000E-06  +8.28000000E-06  -1.07000000E-06  +1.70000000E-06  +5.21500000E-05
   +5.93700000E-05  +7.77200000E-05  +3.70000000E-07  +1.20100000E-05  +7.10000000E-07
   +5.97000000E-06  +3.78000000E-06  -1.35000000E-06  +1.54100000E-04  -1.64500000E-05
   -4.90200000E-05  +1.99330000E-04  -4.21270000E-04  +7.80000000E-06  -9.89150000E-04
   -1.23038000E-03  +3.70000000E-06  +2.09800000E-05  +5.70600000E-05  +9.94400000E-05
   +1.19000000E-05  -9.82000000E-06  -3.08900000E-05  -3.26100000E-05  -3.16900000E-05
   +2.85400000E-05  -5.47701300E-02  +1.07573480E-01  +7.89000000E-06  -8.48000000E-06
   -1.25950000E-04  +1.55050000E-04  -3.01500000E-05  +1.11530000E-04  -5.04000000E-06
   -2.39700000E-05  -3.55900000E-05  +5.52400000E-05  -3.63700000E-05  +1.82900000E-05
   -8.27000000E-06  +2.67900000E-05  +1.27000000E-05  -1.58400000E-05  +9.71000000E-06
   +5.84700000E-05  +2.46020000E-04  +4.40940000E-04  -6.16220000E-04  +6.79020000E-04
   +6.54930000E-04  -3.46340000E-04  +3.03400000E-05  -1.58300000E-05  +1.02100000E-05
   -9.84721000E-03  +1.14771400E-02  -1.81293100E-02  -9.43082500E-02  +9.53582700E-02
   -2.53853350E-01  -7.27570000E-04  -3.54922000E-03  +5.44762000E-03  -3.21162000E-03
   -2.35735000E-03  +1.18257000E-03  +6.15480000E-04  +3.43880000E-04  +7.73450000E-04
   +5.09960000E-04  -4.49556000E-03  -2.51632000E-03  -5.95270000E-04  +1.05338000E-03
   +2.99299000E-03  +6.25170000E-04  +5.64710000E-04  -1.06000000E-05  -1.30440000E-04
   -1.02220000E-04  +1.25410000E-04  -1.76780000E-04  -2.05620000E-04  +4.54410000E-04
   -3.92000000E-06  +7.17000000E-06  -1.43000000E-06  +2.62000000E-06  -4.70000000E-07
   -2.68000000E-06  -1.13270000E-04  +3.92200000E-05  +5.36000000E-05  +1.12900000E-05
   +2.91400000E-05  +8.76000000E-06  +9.42000000E-06  +1.68000000E-06  +3.00000000E-07
   +1.38320000E-04  +2.15200000E-04  +4.54460000E-04  +4.75600000E-05  -3.23890000E-04
   -5.79800000E-05  +6.75300000E-05  +8.00240000E-04  +8.91540000E-04  +1.76700000E-05
   +7.26000000E-05  +8.94300000E-05  +2.52700000E-05  -3.54600000E-05  -1.18800000E-05
   -1.29600000E-05  -1.04210000E-04  -2.38800000E-05  +1.03711450E-01  -1.02100220E-01
   +2.64480220E-01  +2.15900000E-05  +8.79800000E-05  -1.39450000E-04  -1.89740000E-04
   -1.97100000E-05  +1.33000000E-05  +2.19400000E-05  -3.32400000E-05  +9.67400000E-05
   -9.23000000E-06  +1.44300000E-05  +4.76100000E-05  -7.07600000E-05  +1.01000000E-05
   -6.60500000E-05  +3.92000000E-05  +5.62000000E-05  +2.17400000E-05  -2.22180000E-04
   +1.29789000E-03  +1.94695000E-03  -2.07980000E-04  -1.96270000E-04  +1.74310000E-04
   +5.81900000E-05  -1.66100000E-05  +2.54200000E-05  +8.42999000E-03  +5.87234000E-03
   -1.97329000E-03  +4.86467000E-03  +5.64462000E-03  +7.44760000E-03  -4.29341800E-02
   -1.33718000E-03  -1.48347500E-02  +3.97564000E-03  -8.26721000E-03  -9.08104000E-03
   +4.72590000E-04  +2.30717000E-03  -1.99489000E-03  -4.86710000E-04  +9.58200000E-05
   +3.27400000E-05  +2.05214000E-03  -1.97741000E-03  -1.64891000E-03  -1.16230000E-03
   -1.74000000E-04  +2.08000000E-03  +5.87870000E-04  +4.13370000E-04  -2.59220000E-04
   +8.44100000E-05  -2.00570000E-04  -7.19600000E-05  -2.64000000E-05  -6.10000000E-07
   -1.15600000E-05  -4.47300000E-05  -1.76100000E-05  +9.63000000E-06  +7.48400000E-05
   -8.68000000E-05  +7.86600000E-05  +5.50000000E-07  +1.84300000E-05  +7.70000000E-06
   +5.00000000E-06  +7.99000000E-06  +6.25000000E-06  +1.28300000E-05  -1.45700000E-05
   -2.81100000E-05  +2.67000000E-06  +4.46900000E-05  -1.26800000E-05  +4.99000000E-05
   -9.23000000E-05  -6.90700000E-05  +7.55000000E-06  -2.41500000E-05  +2.73500000E-05
   -1.19200000E-05  -1.56000000E-06  -1.59400000E-05  -3.45200000E-05  +1.67890000E-04
   +1.75530000E-04  -6.26369000E-03  -2.37345000E-03  +2.32349000E-03  +3.09513800E-02
   -6.37000000E-05  +6.03000000E-05  -1.59090000E-04  +6.60800000E-05  -6.61100000E-05
   +3.91700000E-05  -5.65000000E-06  +3.55000000E-06  +5.36000000E-05  -1.39300000E-05
   +2.98300000E-05  +3.69700000E-05  -3.98100000E-05  -3.03000000E-06  -4.29100000E-05
   +1.21000000E-05  +3.93100000E-05  +4.63200000E-05  +9.34900000E-05  +1.95740000E-04
   +9.07700000E-05  -7.18700000E-05  -3.46600000E-05  -3.02600000E-05  +1.66800000E-05
   -5.38000000E-06  +2.06500000E-05  +3.76765000E-03  -5.28310000E-04  +2.58885000E-03
   -1.42459000E-03  -1.41696600E-02  -2.68439700E-02  -1.96047000E-03  -1.46125770E-01
   -1.35420300E-01  +1.67747000E-03  +9.58807000E-03  +1.24859000E-02  +1.31125000E-03
   -1.27752000E-03  +2.05911000E-03  +3.78100000E-05  -1.74140000E-04  +2.46630000E-04
   +6.79220000E-04  -1.75537000E-03  -1.23210000E-03  -1.51185000E-03  +6.68170000E-04
   -1.64224000E-03  -5.38300000E-05  +1.86100000E-05  +9.26000000E-06  -4.94440000E-04
   -3.56520000E-04  +1.54990000E-04  -1.47200000E-05  +7.08000000E-06  -9.51000000E-06
   -3.19600000E-05  +1.80000000E-07  -3.16000000E-06  +1.88500000E-05  -1.03870000E-04
   +4.33000000E-05  +1.01300000E-05  -3.78000000E-06  +1.66400000E-05  -3.12000000E-06
   +5.16000000E-06  +2.96000000E-06  -5.12000000E-06  -2.42300000E-05  +2.48000000E-05
   +1.60000000E-07  +3.58900000E-05  -9.61000000E-06  +4.78000000E-06  -4.48100000E-05
   +9.13000000E-06  +7.36000000E-06  -7.10000000E-07  -1.90000000E-06  +2.66000000E-05
   +1.53800000E-05  +6.00000000E-06  -3.60000000E-06  -3.08200000E-05  -1.29700000E-05
   -2.22534000E-03  +1.10800000E-05  +9.64960000E-04  -6.05870000E-04  +1.52855060E-01
   +2.04200000E-05  -1.25800000E-05  -7.02700000E-05  +4.04100000E-05  +6.30000000E-06
   +1.70100000E-05  -2.12300000E-05  -4.34000000E-06  +1.46600000E-05  +1.34100000E-05
   -1.80500000E-05  +3.00400000E-05  +1.96600000E-05  -8.71000000E-06  -1.81300000E-05
   -7.99000000E-06  +2.54900000E-05  +7.33000000E-06  +1.32420000E-04  -3.02100000E-04
   -3.91330000E-04  +4.30000000E-07  +2.79000000E-06  -3.99100000E-05  -2.14800000E-05
   +1.69700000E-05  +7.74000000E-06  -2.80399000E-03  +2.78280000E-04  +1.15035000E-03
   -7.42100000E-04  +3.86907000E-03  +6.21649000E-03  -1.45079600E-02  -1.36003860E-01
   -2.49884390E-01  +9.34640000E-04  -1.97441500E-02  -1.80811600E-02  -2.26371000E-03
   +3.27549000E-03  -2.78814000E-03  +6.22800000E-05  +5.57320000E-04  +2.66560000E-04
   -3.11710000E-04  +6.11280000E-04  +7.61880000E-04  +9.72990000E-04  +1.77082000E-03
   +3.97405000E-03  -1.08830000E-04  -4.10200000E-05  +2.97000000E-05  +8.64400000E-05
   +1.15970000E-04  +9.77800000E-05  -2.57000000E-06  -6.82000000E-06  -3.32000000E-06
   -2.04800000E-05  -6.19000000E-06  +1.13600000E-05  -1.60200000E-05  -4.87700000E-05
   +3.36600000E-05  +1.01100000E-05  +1.93100000E-05  +1.31200000E-05  +4.31000000E-06
   +5.52000000E-06  +7.00000000E-08  +4.70000000E-07  -4.90000000E-07  +2.14500000E-05
   -4.90000000E-06  -3.96000000E-06  +1.03500000E-05  -6.00000000E-07  +9.09000000E-06
   +3.34300000E-05  +4.52000000E-06  +1.88300000E-05  +1.70300000E-05  -1.18000000E-06
   -9.81000000E-06  +5.88000000E-06  +5.16000000E-06  -3.07700000E-05  -1.62200000E-05
   +2.10359000E-03  +3.44810000E-04  +3.98540000E-04  +1.62363800E-02  +1.46370130E-01
   +2.59376930E-01  +4.24100000E-05  -4.43200000E-05  -2.92000000E-06  -2.88430000E-04
   +4.08000000E-05  -1.31700000E-05  +6.70800000E-05  -1.20700000E-05  -3.46900000E-05
   -1.44500000E-05  +9.06300000E-05  -4.06600000E-05  -3.55700000E-05  +3.40400000E-05
   +8.23500000E-05  -3.55500000E-05  -5.11000000E-06  -3.46800000E-05  -6.12050000E-04
   +7.72550000E-04  -2.12535000E-03  +4.97850000E-04  +4.98770000E-04  +1.54890000E-04
   +1.56800000E-05  +1.17000000E-05  -2.24400000E-05  +9.74431000E-03  +5.31671000E-03
   -1.04349000E-03  -4.83520000E-04  +1.43590000E-04  +2.44690000E-04  +1.45864000E-03
   +1.25614000E-03  +5.59570000E-04  +4.39301000E-03  -1.53770000E-03  +2.39283000E-03
   -5.71018800E-02  +3.72298700E-02  -5.88132300E-02  +2.81057000E-03  +4.13872000E-03
   -8.13372000E-03  +2.11229000E-03  -1.82849000E-03  +1.57324000E-03  -1.56137000E-03
   -8.33560000E-04  -1.89600000E-04  -3.04300000E-05  -1.31780000E-04  -6.24600000E-05
   +7.90400000E-05  -4.88200000E-05  +2.38330000E-04  -1.91700000E-05  -2.71000000E-06
   +9.91000000E-06  +4.56000000E-06  -5.48000000E-06  -4.53000000E-06  -2.30000000E-06
   +1.05300000E-05  -1.52600000E-05  +1.73900000E-05  -1.57300000E-05  +8.25000000E-06
   -2.50200000E-05  -3.44400000E-05  -3.65000000E-06  -4.34700000E-05  +1.17220000E-04
   -2.11100000E-04  -2.49100000E-05  +1.10800000E-05  -4.47000000E-06  +8.66000000E-06
   -1.75700000E-05  -1.09100000E-05  -1.42000000E-06  +7.79000000E-06  +6.07600000E-05
   -8.95000000E-06  +2.51600000E-05  +2.59500000E-05  +7.21000000E-06  +2.59000000E-06
   +1.67400000E-05  -1.38330000E-04  -5.77200000E-05  +5.14200000E-05  +3.29260000E-04
   -9.78300000E-05  +2.13650000E-04  +4.64072300E-02  -1.53600000E-05  -9.10000000E-06
   -3.06500000E-05  +5.72400000E-05  -1.31600000E-05  -1.96200000E-05  +3.74400000E-05
   +4.28400000E-05  +1.33700000E-05  -2.99100000E-05  +8.68900000E-05  -4.50200000E-05
   -5.58800000E-05  +3.45400000E-05  +5.82500000E-05  -1.61800000E-05  -3.45000000E-06
   -3.87600000E-05  +1.63950000E-04  +1.92990000E-04  -1.04150000E-04  -5.01600000E-05
   -1.62500000E-05  -6.99000000E-06  +4.89000000E-06  -8.71000000E-06  -1.34700000E-05
   +3.28850000E-03  -7.59070000E-04  -3.77219000E-03  -7.92800000E-05  -3.13340000E-04
   -1.53920000E-04  +8.55660000E-04  -1.99859000E-03  -2.59925000E-03  -3.59594000E-03
   +1.00981800E-02  -1.60618400E-02  +3.64439100E-02  -1.14127810E-01  +1.12746080E-01
   +7.51467000E-03  -1.09035600E-02  +2.80545400E-02  +1.53811000E-03  -1.62673000E-03
   +1.64062000E-03  -8.48680000E-04  +7.52530000E-04  +2.51207000E-03  -3.86700000E-05
   +1.02800000E-05  +3.11300000E-05  -2.33950000E-04  -8.44400000E-05  -1.01670000E-04
   -8.07000000E-06  +6.65000000E-06  -1.47000000E-06  -3.66000000E-06  +5.30000000E-07
   -6.50000000E-06  +3.98000000E-06  -1.19600000E-05  -7.96000000E-06  +1.80600000E-05
   -6.79100000E-05  +4.99000000E-06  -3.73200000E-05  -1.99400000E-05  +5.50000000E-07
   -1.48600000E-05  -1.62900000E-05  +2.33000000E-05  +3.52000000E-06  +2.90000000E-05
   -1.95300000E-05  +4.96000000E-06  -1.32000000E-06  +1.74100000E-05  +1.84000000E-05
   -6.05000000E-06  +1.13600000E-05  +4.14000000E-06  +2.45200000E-05  +1.16000000E-06
   -1.00700000E-05  -3.69300000E-05  -9.58000000E-06  -1.33000000E-05  +8.36000000E-05
   +1.52530000E-04  -3.55810000E-04  +4.46820000E-04  -7.46650000E-04  -4.22037500E-02
   +1.18236420E-01  +3.74000000E-06  -1.69000000E-06  -5.79700000E-05  +3.25200000E-05
   -2.74300000E-05  +3.00100000E-05  -8.10600000E-05  +2.48900000E-05  -2.72000000E-06
   +4.67900000E-05  -7.65300000E-05  +5.40700000E-05  +1.34200000E-05  -5.93000000E-06
   -2.20400000E-05  -1.75700000E-05  +1.18100000E-05  +1.15800000E-05  -4.51600000E-05
   -8.19000000E-05  +2.84910000E-04  -5.04400000E-05  -1.12250000E-04  -2.26200000E-05
   +8.16000000E-06  -1.88800000E-05  +1.64600000E-05  -4.32800000E-04  -1.65208000E-03
   +9.88850000E-04  +1.64300000E-04  -5.63450000E-04  +2.52380000E-04  +8.81850000E-04
   -3.87686000E-03  -2.93492000E-03  -8.38751000E-03  +1.72991100E-02  -1.91169100E-02
   -5.88738000E-02  +1.13204100E-01  -2.69616670E-01  +1.03549000E-03  -3.13179000E-03
   +5.56972000E-03  -1.42940000E-04  +2.13930000E-04  +8.84200000E-05  +9.74350000E-04
   -1.11673000E-03  +4.21400000E-03  +6.30100000E-05  +4.31800000E-05  +1.62800000E-05
   +5.45700000E-05  +3.09000000E-06  +7.67400000E-05  +9.49000000E-06  +8.77000000E-06
   -1.10900000E-05  -5.05000000E-06  +3.09000000E-06  -1.20000000E-06  -8.66000000E-06
   -1.65600000E-05  +4.43600000E-05  -9.10000000E-07  +2.31300000E-05  +5.99000000E-06
   +1.34700000E-05  +1.83900000E-05  +3.08000000E-06  +1.14000000E-05  -7.23000000E-06
   +4.99000000E-05  +1.03400000E-05  -8.69000000E-06  -2.07000000E-06  -2.30700000E-05
   -6.40000000E-07  +2.40300000E-05  -5.98000000E-06  +1.06200000E-05  +3.20000000E-07
   +1.25000000E-06  -7.32000000E-06  -6.50000000E-06  -7.60000000E-06  +1.63600000E-05
   +7.15000000E-06  -5.89700000E-05  +1.46660000E-04  +5.85200000E-05  -6.17650000E-04
   +6.11420000E-04  -1.02426000E-03  +6.47722800E-02  -1.21492850E-01  +2.80177890E-01
   -1.31910000E-04  +6.15800000E-05  +9.50800000E-05  +6.82700000E-05  -1.43700000E-05
   -1.57160000E-04  +6.52000000E-06  +1.25190000E-04  +1.72470000E-04  -6.05400000E-05
   +1.17570000E-04  -9.53900000E-05  -9.06700000E-05  +1.74000000E-05  -3.98800000E-05
   +1.14090000E-04  -6.11500000E-05  -1.93200000E-05  +4.01730000E-04  +6.25230000E-04
   -7.00570000E-04  +7.22700000E-05  -3.68000000E-06  +1.61200000E-05  +6.83900000E-05
   -4.78200000E-05  -9.17000000E-06  +2.27639000E-03  -2.37402000E-03  -4.84059000E-03
   +3.44770000E-04  +3.77030000E-04  -1.44198000E-03  -2.02589000E-03  -4.94850000E-04
   +2.79430000E-04  +1.22945300E-02  +4.81890000E-03  -2.15330000E-03  +8.98625000E-03
   +7.91957000E-03  +8.60158000E-03  -4.63279000E-02  +1.88429800E-02  +2.38227500E-02
   +1.87133000E-03  -1.33173000E-03  +1.05391000E-03  -2.69674000E-03  -5.16610000E-04
   +5.15400000E-04  -6.40000000E-05  -1.42080000E-04  +3.57770000E-04  +2.15280000E-04
   +6.53800000E-05  +4.03750000E-04  -1.32400000E-05  +9.78000000E-06  +5.20000000E-07
   +1.06200000E-05  +9.80000000E-07  -1.02900000E-05  -1.55400000E-05  -2.41600000E-05
   -3.63100000E-05  -1.18790000E-04  -2.41030000E-04  -2.43800000E-05  -2.20100000E-05
   +1.08000000E-06  +3.92000000E-06  -1.46000000E-06  +1.83000000E-05  -1.27000000E-06
   -1.56600000E-05  +1.96500000E-05  -2.03700000E-05  -3.91000000E-06  +1.61000000E-05
   -2.41200000E-05  +2.53930000E-04  -8.70040000E-04  +1.09260000E-04  -3.90300000E-05
   +1.23970000E-04  -1.08640000E-04  -4.19800000E-05  +3.99200000E-05  -7.45800000E-05
   +1.00282000E-03  +1.11090000E-04  -5.20810000E-04  -1.25570000E-04  -4.90200000E-05
   +1.19810000E-04  -6.91128000E-03  -2.60508000E-03  +6.35240000E-04  +3.12265400E-02
   -9.83000000E-06  +4.44500000E-05  +5.76300000E-05  -6.45400000E-05  -9.50800000E-05
   -1.70940000E-04  -4.23400000E-05  -2.58100000E-05  +3.76000000E-05  -2.24500000E-05
   -8.60000000E-06  -1.99900000E-05  -1.09200000E-05  -1.14300000E-05  -6.52600000E-05
   +5.82000000E-05  -9.76000000E-06  +1.69000000E-05  -3.46000000E-05  +8.16480000E-04
   -6.82220000E-04  +1.63940000E-04  -3.21000000E-05  -1.34210000E-04  +2.30600000E-05
   -1.19900000E-05  +6.83000000E-06  -8.14010000E-04  +9.73052000E-03  +1.44797600E-02
   +9.97940000E-04  -2.36222000E-03  +2.05723000E-03  -7.24050000E-04  +4.10600000E-05
   -6.66800000E-05  +5.55102000E-03  -9.50890000E-04  +4.11749000E-03  +4.70450000E-03
   -1.15411700E-02  -2.91767400E-02  +1.89882800E-02  -1.26816670E-01  -1.22182920E-01
   -7.20120000E-04  +8.47310000E-04  -1.17015000E-03  -2.03930000E-04  -2.56528000E-03
   -2.06240000E-03  -2.77120000E-04  -1.26053000E-03  +6.13900000E-04  +4.11790000E-04
   +2.00330000E-04  +1.47640000E-04  -6.06000000E-06  -1.17000000E-06  +9.00000000E-08
   +2.31000000E-06  -6.70000000E-06  +4.51000000E-06  +2.51000000E-06  -2.70000000E-06
   -2.67000000E-06  -7.43500000E-05  +4.74000000E-06  -1.77700000E-05  +1.58200000E-05
   +1.52200000E-05  -4.10000000E-07  -3.74400000E-05  -2.90700000E-05  -2.11400000E-05
   +2.54000000E-06  +2.13000000E-05  +1.65800000E-05  +1.45900000E-05  +2.18900000E-05
   -9.99800000E-05  -9.91290000E-04  -2.41824000E-03  +6.16300000E-04  +2.46400000E-05
   +6.40000000E-06  -2.18700000E-05  +1.62800000E-05  +8.17200000E-05  -1.57930000E-04
   +4.13030000E-04  +8.04070000E-04  +6.41420000E-04  -8.58300000E-05  +6.73000000E-05
   -1.32580000E-04  -2.52909000E-03  -1.09010000E-04  +5.27170000E-04  -2.42487400E-02
   +1.35893070E-01  +3.03000000E-05  -5.36200000E-05  -1.00780000E-04  -1.05600000E-05
   +1.25600000E-04  +9.97500000E-05  -7.30400000E-05  -9.99300000E-05  -2.19300000E-04
   +9.11900000E-05  -6.99900000E-05  +1.01890000E-04  +6.75100000E-05  +9.12000000E-06
   +6.44600000E-05  -1.20530000E-04  +7.45600000E-05  +2.82200000E-05  -4.98840000E-04
   -9.02200000E-04  -3.04900000E-04  +7.81100000E-05  +2.33760000E-04  +1.56960000E-04
   -5.68900000E-05  +4.01900000E-05  +7.71000000E-06  +4.04858000E-03  -1.56143600E-02
   -1.93674400E-02  -1.43111000E-03  +4.59286000E-03  -2.70653000E-03  +3.82690000E-04
   -9.86700000E-05  +8.73680000E-04  -1.27445000E-03  +1.15777000E-03  +1.38040000E-04
   -1.23349000E-03  +2.99044000E-03  +5.29639000E-03  +2.45387200E-02  -1.24003910E-01
   -2.66626630E-01  +2.70020000E-04  -1.03290000E-04  +2.81844000E-03  +3.25730000E-04
   -1.30100000E-04  +3.28980000E-04  -1.79160000E-04  -2.62210000E-04  -5.37530000E-04
   +3.48000000E-06  -1.26300000E-05  +3.02600000E-04  +4.94000000E-06  -9.88000000E-06
   -9.20000000E-07  -1.59700000E-05  +3.44000000E-06  +4.40000000E-06  -2.71800000E-05
   -7.10000000E-06  +5.08400000E-05  +1.33520000E-04  +9.01100000E-05  +1.48490000E-04
   -6.90000000E-07  -7.07000000E-06  -7.40000000E-07  +4.11600000E-05  +1.07310000E-04
   -5.76500000E-05  +3.64000000E-06  -4.42600000E-05  -2.17200000E-05  -5.94300000E-05
   -3.92000000E-05  +1.33760000E-04  +1.92440000E-04  +3.87400000E-04  +1.13234000E-03
   +3.64500000E-05  -8.18100000E-05  +7.83900000E-05  -1.28800000E-05  -1.44680000E-04
   +4.79360000E-04  -1.97040000E-04  -9.38690000E-04  -1.09660000E-03  -4.29000000E-06
   -1.48560000E-04  +6.23700000E-05  +4.56510000E-04  +8.22000000E-06  +1.03730000E-03
   -2.53111900E-02  +1.32971730E-01  +2.78400480E-01  +4.54990000E-04  -9.82780000E-04
   -1.57164000E-03  -3.10836000E-03  -2.07038000E-03  +7.62500000E-04  +3.40030000E-04
   -1.08340000E-04  +1.60024000E-03  -9.17200000E-04  +1.36176000E-03  +6.93040000E-04
   +2.30114000E-03  -1.08526000E-03  +2.43320000E-04  -1.17690000E-03  +6.20210000E-04
   -1.12549000E-03  +5.44763000E-03  +1.52083900E-02  -3.33108000E-03  -5.32920000E-04
   -3.27690000E-04  -9.61640000E-04  -2.76738000E-03  +1.22448000E-03  -7.08100000E-05
   -3.32317800E-02  -1.80558000E-02  +1.29065800E-02  -2.12435000E-03  +4.63050000E-04
   -6.16688000E-03  +1.03332000E-03  +3.19491000E-03  +2.22011000E-03  -5.36270000E-04
   -1.06422000E-03  +8.05140000E-04  +2.55640000E-04  +1.86241000E-03  -1.30880000E-03
   +1.05614000E-03  -7.34320000E-04  +3.25499000E-03  +1.18971600E-02  +7.41773000E-03
   -3.32039000E-03  +5.75200000E-05  +1.02149000E-03  -3.13220000E-04  +9.48640000E-04
   -5.80670000E-04  +1.78575000E-03  +3.97651000E-02  +5.60215900E-02  +6.09037000E-03
   +2.51260000E-04  -2.46010000E-04  -1.66460000E-04  -1.98860000E-04  +1.50410000E-04
   +8.06400000E-05  +1.97500000E-05  -2.83420000E-04  +2.22300000E-04  +3.53100000E-05
   -3.81190000E-04  +1.85890000E-04  -1.50250000E-04  +8.10500000E-05  -8.86000000E-05
   +2.29160000E-04  -4.44500000E-04  +5.01790000E-04  +3.16880000E-04  +9.06400000E-05
   -4.77440000E-04  -2.31420000E-04  +1.29130000E-04  +3.39850000E-04  -1.11850000E-04
   +1.08980000E-04  -4.11130000E-04  -9.97010000E-04  +9.04030000E-04  -2.38920000E-04
   -5.03250000E-04  -7.13000000E-05  -1.45310000E-04  -3.57390000E-04  -4.93250000E-04
   +3.83520000E-04  -2.12220000E-04  +8.51890000E-04  -1.22860000E-04  -6.58040000E-04
   +2.26470000E-04  +4.69000000E-06  -5.39520000E-04  -4.50510000E-04  -2.77510000E-04
   -1.87801000E-02  +5.72640000E-04  -1.26708000E-03  -1.51609000E-03  -2.95417000E-03
   -8.62990000E-04  +7.39800000E-04  +4.90480000E-04  -2.32120000E-04  +1.61111000E-03
   -8.88850000E-04  +1.23815000E-03  +7.51870000E-04  +2.36641000E-03  -1.03245000E-03
   +3.10260000E-04  -1.24764000E-03  +5.42520000E-04  -1.17981000E-03  +1.04001900E-02
   +1.26916900E-02  -4.55234000E-03  -9.38410000E-04  -8.13450000E-04  -6.07660000E-04
   -2.72932000E-03  +1.17189000E-03  -7.12600000E-05  -6.31195000E-03  +1.98682000E-03
   -1.93118000E-03  -5.29790000E-04  +1.31910000E-03  -6.92142000E-03  +1.03149000E-03
   +2.50999000E-03  +2.49600000E-03  -3.42360000E-04  -1.81964000E-03  -6.17400000E-05
   +1.50270000E-04  +1.36051000E-03  -5.81110000E-04  +1.31378000E-03  -3.41350000E-04
   +3.15700000E-03  +3.85039000E-02  -3.39947800E-02  -6.40300000E-04  -1.20090000E-04
   +1.57250000E-03  -4.90100000E-05  +3.92160000E-04  -1.13289000E-03  +1.72446000E-03
   +6.10158200E-02  +3.46081200E-02  +2.59420000E-04  +2.76030000E-04  -2.27480000E-04
   -1.71450000E-04  -1.64620000E-04  +1.60370000E-04  +6.57900000E-05  +3.45500000E-05
   -2.18700000E-04  +1.57770000E-04  +3.67300000E-05  -3.02130000E-04  +1.73020000E-04
   -1.19050000E-04  +8.52000000E-05  -8.88000000E-05  +1.18670000E-04  -3.82170000E-04
   +5.58440000E-04  +2.54600000E-04  +1.78710000E-04  -5.43640000E-04  -1.71740000E-04
   +1.53400000E-04  +2.89430000E-04  -1.15570000E-04  +2.25980000E-04  -3.24430000E-04
   -1.15423000E-03  +9.25360000E-04  -1.09190000E-04  -5.27460000E-04  -7.68400000E-05
   -1.74670000E-04  -2.86170000E-04  -3.31430000E-04  +4.59800000E-04  -2.98310000E-04
   +8.28260000E-04  -8.99800000E-05  -4.40720000E-04  +1.91340000E-04  -3.54000000E-06
   -3.18760000E-04  -4.13560000E-04  -1.56000000E-05  -8.63056900E-02  -2.19301100E-02
   -5.32000000E-06  +5.11100000E-05  +1.18840000E-04  -6.51800000E-05  -7.58000000E-05
   -3.13200000E-05  +4.10600000E-05  +3.35300000E-05  +9.65000000E-06  -8.30000000E-06
   +1.12000000E-06  -4.43700000E-05  -7.27900000E-05  +4.84200000E-05  +1.58100000E-05
   +2.47500000E-05  -2.48300000E-05  -3.39700000E-05  -1.22421000E-03  -5.07380000E-04
   +7.40580000E-04  +6.19800000E-05  +2.97600000E-05  -1.00980000E-04  +8.65200000E-05
   -4.66800000E-05  -1.04400000E-05  -1.60281000E-03  +6.72590000E-04  -2.90211000E-03
   +1.71075000E-03  -1.20960000E-04  +9.30850000E-04  -4.19670000E-04  -5.37110000E-04
   -1.03728000E-03  +3.00090000E-04  +4.11110000E-04  +1.81803000E-03  +5.71800000E-05
   -5.94800000E-04  -8.33050000E-04  -5.90070000E-04  +1.04575000E-03  +1.12772000E-03
   +4.62865500E-02  +3.62996200E-02  -2.90746600E-02  -2.83300000E-05  -3.01440000E-04
   -5.97900000E-04  -2.45570000E-04  +1.49040000E-04  +6.24800000E-05  -2.01716700E-02
   -3.34414200E-02  -1.17377400E-02  -1.51200000E-05  +8.38000000E-06  +6.08000000E-06
   +1.74200000E-05  -9.05000000E-06  -5.33000000E-06  -2.35900000E-05  -3.39000000E-06
   -2.81700000E-05  -4.28200000E-05  -2.07100000E-05  -3.99000000E-05  -4.88000000E-06
   -5.31000000E-06  +4.14000000E-06  +4.04700000E-05  -3.43000000E-05  -2.10600000E-05
   +6.72300000E-05  -6.88700000E-05  +1.49950000E-04  +5.92000000E-05  +3.60000000E-07
   -9.10300000E-05  -1.92580000E-04  +9.01000000E-06  -1.61910000E-04  +5.03600000E-05
   -2.45480000E-04  +1.61310000E-04  +1.27570000E-04  -2.59200000E-05  -1.26670000E-04
   +1.94290000E-04  +1.10380000E-04  -3.97410000E-04  -1.06400000E-04  -2.02820000E-04
   -1.65900000E-05  +1.84900000E-05  -1.71100000E-05  -3.77300000E-05  -4.55610000E-04
   -8.40700000E-05  -5.48780000E-04  -1.91347300E-02  +5.25845000E-03  +4.40299900E-02
   +6.82000000E-05  +3.95200000E-05  -1.19040000E-04  -6.63400000E-05  +1.24500000E-04
   +9.24000000E-06  +1.45100000E-05  +2.67900000E-05  -1.93600000E-05  -1.61400000E-05
   +6.35300000E-05  +1.81200000E-05  -6.38500000E-05  +7.77000000E-06  +2.23900000E-05
   -5.33500000E-05  +7.79800000E-05  -1.34700000E-05  +5.65380000E-04  +4.03250000E-04
   -4.40310000E-04  +6.72400000E-05  +1.90700000E-05  -1.54000000E-05  +5.20500000E-05
   -1.06600000E-05  +6.50000000E-06  -6.58340000E-04  -4.07260000E-04  +1.47661000E-03
   -3.05170000E-04  -1.03221000E-03  -4.91170000E-04  +4.86390000E-04  +1.67071000E-03
   +5.84150000E-04  -1.04768000E-03  +7.68520000E-04  -4.06920000E-04  +3.22100000E-05
   +7.38320000E-04  -1.91300000E-04  -2.66210000E-04  -7.31150000E-04  -2.02900000E-04
   +1.83189000E-03  -3.74300000E-03  -9.94480000E-04  +2.53100000E-04  -5.87890000E-04
   +1.25840000E-04  +2.25710000E-04  -1.04340000E-04  +1.14560000E-04  -1.56222030E-01
   +2.16448590E-01  +8.84952400E-02  -3.11800000E-05  -3.80000000E-06  +7.20000000E-07
   -1.05200000E-05  -9.82000000E-06  +2.00000000E-06  -1.44100000E-05  -4.95700000E-05
   +8.39000000E-05  -6.52000000E-06  -4.04800000E-05  +2.11800000E-05  -4.99000000E-06
   -4.97000000E-06  +2.90000000E-06  +3.43000000E-06  +3.68500000E-05  +1.42600000E-05
   +1.71000000E-06  +2.10500000E-05  -3.70900000E-05  -2.30200000E-05  -9.55000000E-06
   +7.29100000E-05  +2.03300000E-05  -1.28800000E-05  -2.13900000E-05  -1.46840000E-04
   +1.06130000E-04  -8.25100000E-05  -6.58500000E-05  +6.30500000E-05  +3.93000000E-05
   +3.63300000E-05  +5.73900000E-05  -3.64900000E-05  -4.00400000E-05  +9.51900000E-05
   -2.34800000E-05  +9.50000000E-07  +3.20400000E-05  +2.28500000E-05  +3.19100000E-05
   -4.32300000E-05  +7.92800000E-05  +2.72542000E-03  -1.09927800E-02  -4.73428000E-03
   +1.52625720E-01  -9.69500000E-05  +3.15210000E-04  +4.06970000E-04  +8.95030000E-04
   +4.10010000E-04  -1.22140000E-04  -1.49200000E-04  +8.62100000E-05  -4.52130000E-04
   +2.73630000E-04  -3.48740000E-04  -2.15020000E-04  -6.67120000E-04  +3.21730000E-04
   -1.93500000E-05  +2.61520000E-04  -1.11980000E-04  +2.83140000E-04  -1.17148000E-03
   -2.82118000E-03  +5.56430000E-04  +1.71310000E-04  +2.14000000E-04  +1.53970000E-04
   +7.77700000E-04  -3.46060000E-04  +1.82200000E-05  +3.10870000E-04  +2.97433000E-03
   -6.44860000E-04  +8.93000000E-06  +9.43770000E-04  +1.67277000E-03  -2.55300000E-05
   -1.39894000E-03  -5.60900000E-05  +2.69030000E-04  +1.45355000E-03  -1.95750000E-04
   -4.51300000E-05  -7.94330000E-04  +1.33370000E-04  -1.73950000E-04  +3.94990000E-04
   -1.15544000E-03  -9.43987000E-03  -6.94704000E-03  +3.74685000E-03  +9.65400000E-05
   -1.24400000E-03  +7.83200000E-05  -6.67800000E-05  +9.91700000E-05  -3.17560000E-04
   +1.88530840E-01  -3.43664600E-01  -1.24809890E-01  -8.29600000E-05  +6.76300000E-05
   +4.63500000E-05  +4.63200000E-05  -4.32500000E-05  -2.22500000E-05  -3.62400000E-05
   +3.32200000E-05  -3.77900000E-05  -2.21200000E-05  +7.33600000E-05  -3.82000000E-05
   +3.35700000E-05  -2.46400000E-05  +2.56400000E-05  +3.13900000E-05  +1.01970000E-04
   -1.14390000E-04  -2.88700000E-05  -1.22570000E-04  +1.40530000E-04  +4.04600000E-05
   -2.88000000E-05  -6.88700000E-05  -1.61000000E-06  -3.53700000E-05  +5.42900000E-05
   +1.15220000E-04  -2.20220000E-04  +4.59000000E-06  +1.36080000E-04  +6.19000000E-05
   +2.86200000E-05  -3.12700000E-05  +4.25800000E-05  +7.53000000E-05  +1.40150000E-04
   -1.71080000E-04  -8.66500000E-05  +1.39020000E-04  -1.03490000E-04  +3.65800000E-05
   +3.14100000E-05  +7.60900000E-05  -4.72000000E-06  +2.27467100E-02  +3.62925000E-03
   -7.76122000E-03  -2.03016650E-01  +3.47127340E-01  -6.86900000E-05  +4.64200000E-05
   +1.52030000E-04  +4.49800000E-05  -4.79500000E-05  -8.45100000E-05  +2.59700000E-05
   +2.31100000E-05  -1.83200000E-05  -2.20100000E-05  +2.85000000E-06  -6.45600000E-05
   -7.59100000E-05  +2.60300000E-05  -2.18200000E-05  +7.16100000E-05  -5.33600000E-05
   +2.15900000E-05  -6.39150000E-04  -2.12970000E-04  +1.33080000E-04  +6.63800000E-05
   +9.21700000E-05  +3.55300000E-05  +8.13500000E-05  -3.25600000E-05  -1.45900000E-05
   -1.62430000E-04  -1.06780000E-03  +6.46390000E-04  -7.16300000E-05  +7.43340000E-04
   +6.13130000E-04  -8.60910000E-04  -9.78230000E-04  -8.06480000E-04  +3.03640000E-04
   +8.46600000E-05  +2.85970000E-03  +4.06270000E-04  +4.77530000E-04  -6.95330000E-04
   +4.82290000E-04  -8.59750000E-04  -2.33400000E-04  -4.12245000E-03  +2.05911000E-03
   +1.22490000E-03  -1.27870000E-04  +2.98700000E-05  -8.96220000E-04  -7.89400000E-05
   +8.58000000E-05  -4.31900000E-05  +8.07110600E-02  -1.30624590E-01  -5.12157300E-02
   -6.62000000E-06  +4.67000000E-06  +1.44600000E-05  +1.70900000E-05  -6.99000000E-06
   -2.49000000E-06  +2.98000000E-06  +2.45200000E-05  -6.46800000E-05  -1.49400000E-05
   -2.21100000E-05  -2.67500000E-05  -6.95000000E-06  -9.38000000E-06  +2.62000000E-06
   -1.64200000E-05  -1.50000000E-07  -7.00500000E-05  -1.90800000E-05  +1.75600000E-05
   +4.90800000E-05  +5.15500000E-05  -1.14600000E-05  -7.42300000E-05  -2.55400000E-05
   -3.03100000E-05  -4.94900000E-05  +7.90400000E-05  -6.09400000E-05  +4.19200000E-05
   +5.69900000E-05  -1.15700000E-05  -3.24500000E-05  +2.00240000E-04  +2.22950000E-04
   -3.97500000E-04  +1.83850000E-04  -1.22190000E-04  -2.24060000E-04  -1.13520000E-04
   -2.64100000E-05  -1.55250000E-04  -1.42050000E-04  -4.28700000E-05  -1.55320000E-04
   +7.15215000E-03  +1.62062000E-03  -1.29705000E-03  -8.33623600E-02  +1.28660380E-01
   +5.08490500E-02
end_hess

