# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -959.80831880    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +3.43915349E+00  +1.34666631E+00  -1.44432727E+00
   006   +4.00302501E+00  -9.34014938E-01  -2.44040423E-01
   006   +6.25577335E+00  -1.06403853E+00  +1.08845633E+00
   006   +7.89220950E+00  +9.85808030E-01  +1.22286260E+00
   006   +7.29335180E+00  +3.22521693E+00  +8.46166163E-03
   006   +5.04242601E+00  +3.39964106E+00  -1.33526100E+00
   006   +2.17649609E+00  -3.16561302E+00  -5.04098666E-01
   006   +2.37062180E+00  -4.16180408E+00  -3.22229366E+00
   008   +8.81020434E+00  +5.29675917E+00  +7.09281406E-02
   006   -4.95095003E-01  -2.27034349E+00  +1.37332760E-01
   006   -2.53350431E+00  -2.59077273E+00  -1.42611732E+00
   006   -4.92738691E+00  -1.59304610E+00  -7.65845755E-01
   006   -5.43304341E+00  -5.91223584E-01  +1.70620651E+00
   006   -3.25805468E+00  -2.60981286E-01  +3.25922548E+00
   006   -9.29369369E-01  -1.07698161E+00  +2.49125337E+00
   008   -7.66762205E+00  +8.54244607E-02  +2.25008879E+00
   008   -7.00447180E+00  -2.11772332E+00  -2.24474362E+00
   006   +2.84461004E+00  -5.35230158E+00  +1.28454549E+00
   008   -4.52375112E+00  +3.12545518E+00  -2.35703063E+00
   001   +1.02882297E+01  +4.93862569E+00  +1.04885463E+00
   001   +9.63680734E+00  +8.26790340E-01  +2.28535880E+00
   001   +6.78375241E+00  -2.77929316E+00  +2.06360348E+00
   001   +1.67806731E+00  +1.52875246E+00  -2.47165678E+00
   001   +4.57408755E+00  +5.15543224E+00  -2.27004300E+00
   001   +4.31789953E+00  -4.70737273E+00  -3.61301071E+00
   001   +1.17850698E+00  -5.82136298E+00  -3.50082634E+00
   001   +1.83274136E+00  -2.72823903E+00  -4.60062780E+00
   001   +2.86460271E+00  -4.75607670E+00  +3.25636331E+00
   001   +1.43752689E+00  -6.84381239E+00  +1.09179899E+00
   001   +4.68690909E+00  -6.15859294E+00  +8.30457456E-01
   001   +6.68841634E-01  -7.80806238E-01  +3.73742294E+00
   001   -3.52114329E+00  +5.77874930E-01  +5.10575972E+00
   001   -4.37859790E+00  +9.37352870E-01  -1.44054004E+00
   001   -2.37243490E+00  -3.50893434E+00  -3.24494227E+00
   001   -7.97258289E+00  +3.11806917E+00  +1.65042487E+00
   001   -8.42333819E+00  -1.64502059E+00  -1.18802803E+00
   001   -5.41127861E+00  +2.94474507E+00  -3.93005584E+00
   008   -7.73306791E+00  +4.80374784E+00  +8.50625343E-01
   001   -7.28421531E+00  +5.95465956E+00  +2.16777685E+00
   001   -5.70997232E+00  +4.02709456E+00  -1.14695781E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +2.70000000E-07  -4.40000000E-07  +1.60000000E-07
   -3.00000000E-08  -3.10000000E-07  +4.60000000E-07
   -2.00000000E-07  -4.00000000E-07  +7.00000000E-07
   -3.00000000E-08  -5.30000000E-07  +6.70000000E-07
   +2.70000000E-07  -5.90000000E-07  +3.90000000E-07
   +4.60000000E-07  -5.30000000E-07  +1.50000000E-07
   -1.90000000E-07  -2.20000000E-07  +4.60000000E-07
   +0.00000000E+00  -4.60000000E-07  +5.70000000E-07
   +4.60000000E-07  -6.90000000E-07  +3.80000000E-07
   -2.00000000E-07  +1.00000000E-07  +3.00000000E-08
   -1.90000000E-07  +5.00000000E-08  -1.80000000E-07
   +5.00000000E-07  +6.00000000E-08  -4.80000000E-07
   -2.30000000E-07  +4.30000000E-07  -5.00000000E-07
   -2.50000000E-07  +5.10000000E-07  -3.90000000E-07
   -3.00000000E-07  +3.90000000E-07  +0.00000000E+00
   -4.70000000E-07  +8.70000000E-07  -1.10000000E-06
   +1.10000000E-07  +5.40000000E-07  -2.20000000E-07
   -5.60000000E-07  -9.00000000E-08  +7.20000000E-07
   -6.00000000E-08  +9.50000000E-07  -1.60000000E-07
   +3.30000000E-07  -7.40000000E-07  +5.50000000E-07
   -1.50000000E-07  -5.70000000E-07  +8.70000000E-07
   -4.20000000E-07  -3.20000000E-07  +9.10000000E-07
   +4.00000000E-07  -3.30000000E-07  -1.00000000E-08
   +6.80000000E-07  -5.60000000E-07  -6.00000000E-08
   +0.00000000E+00  -6.60000000E-07  +8.20000000E-07
   -1.10000000E-07  -3.90000000E-07  +6.00000000E-07
   +2.70000000E-07  -5.40000000E-07  +3.80000000E-07
   -6.90000000E-07  +1.00000000E-07  +6.70000000E-07
   -6.70000000E-07  +2.00000000E-08  +7.20000000E-07
   -6.20000000E-07  -3.20000000E-07  +9.80000000E-07
   -4.40000000E-07  +3.30000000E-07  +7.00000000E-08
   -4.80000000E-07  +8.20000000E-07  -4.90000000E-07
   +2.50000000E-07  +4.30000000E-07  -3.80000000E-07
   +5.00000000E-08  -9.00000000E-08  +3.00000000E-08
   -8.00000000E-08  +1.17000000E-06  -9.30000000E-07
   -2.10000000E-07  +5.20000000E-07  -8.50000000E-07
   +7.40000000E-07  +3.20000000E-07  -9.00000000E-07
   +7.50000000E-07  +5.40000000E-07  -1.37000000E-06
   +2.30000000E-07  +9.30000000E-07  -1.35000000E-06
   +8.10000000E-07  -3.20000000E-07  -1.92000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.23598200E-01  +9.41764200E-02  +6.30838090E-01  +2.28271510E-01  -1.33384490E-01
   +3.23682680E-01  -1.25507850E-01  -1.48767000E-03  -2.98008700E-02  +5.61789810E-01
   +5.61880900E-02  -2.56360570E-01  +1.02369860E-01  +4.87469600E-02  +5.82988460E-01
   -5.32355600E-02  +6.99114500E-02  -1.27317820E-01  +1.97000670E-01  -1.20824240E-01
   +3.44572160E-01  +3.00279000E-03  +7.58255700E-02  -3.31144600E-02  -2.65489290E-01
   -2.96716800E-02  -1.02012420E-01  +5.64675440E-01  +3.10725300E-02  +2.55634900E-02
   +1.04734500E-02  +2.82855500E-02  -1.26617190E-01  +3.86985200E-02  +6.68143900E-02
   +6.73309800E-01  -1.56139900E-02  +3.54975900E-02  -1.42314100E-02  -1.24825250E-01
   +7.13560000E-03  -1.40702940E-01  +2.16619560E-01  -1.69303210E-01  +3.31075530E-01
   -5.63067000E-03  -1.64530100E-02  +5.09698000E-03  -3.77751700E-02  -1.25729800E-02
   -2.09389100E-02  -1.94984200E-01  -1.43005810E-01  -2.18307600E-02  +6.06594320E-01
   -1.23948300E-02  -6.79892400E-02  +1.84675900E-02  -5.73824300E-02  +4.26523300E-02
   -4.55383700E-02  -8.43539900E-02  -2.51276090E-01  +2.54751500E-02  +8.56577600E-02
   +6.33235730E-01  +3.54882000E-03  +1.58173100E-02  -7.68416000E-03  -3.18792000E-03
   -2.11429400E-02  +1.31288800E-02  -4.44896300E-02  -7.22776000E-03  -8.19315300E-02
   +2.42142550E-01  -1.49225120E-01  +3.21462610E-01  -3.88200100E-02  -6.52567400E-02
   +2.46241000E-03  -3.44727100E-02  +3.44467600E-02  -3.03012000E-02  +5.70619100E-02
   +7.00825000E-03  +2.79787800E-02  -1.38422510E-01  +2.38798000E-03  -4.08360800E-02
   +6.01905350E-01  -1.56484000E-02  +4.69285600E-02  -2.62958700E-02  +3.20184200E-02
   -2.31608700E-02  +2.45217900E-02  -4.31128600E-02  -5.51034200E-02  -1.85237000E-03
   +7.25504200E-02  -2.60687780E-01  +1.16240190E-01  +7.93847700E-02  +6.55152660E-01
   -1.71742900E-02  -5.39606300E-02  +1.37307100E-02  -2.91838500E-02  +2.61166900E-02
   -3.23837000E-02  +4.82812300E-02  +2.62631000E-02  +1.86914800E-02  -6.80593100E-02
   +7.59193500E-02  -1.37453490E-01  +2.18956950E-01  -1.45947980E-01  +3.44094390E-01
   -2.05305330E-01  -9.41132000E-02  -4.58174200E-02  +4.93226200E-02  -4.20107300E-02
   +4.10081300E-02  -5.62333400E-02  -2.44731100E-02  -1.99746000E-02  +6.76262000E-03
   +6.89412200E-02  -2.76685300E-02  -2.48968880E-01  -1.64165100E-02  -9.48490400E-02
   +5.72497050E-01  -1.53207360E-01  -2.70994700E-01  -4.92769000E-03  +2.30860000E-03
   -5.07493600E-02  +2.40931100E-02  -2.55433100E-02  -1.42099000E-02  -9.77267000E-03
   +2.82254800E-02  +2.63854400E-02  +9.12460000E-03  +5.10869900E-02  -1.28235330E-01
   +5.08699000E-02  +8.68671400E-02  +7.03795240E-01  -2.28308600E-02  +2.84239000E-02
   -8.40563400E-02  +2.24236800E-02  -1.21378000E-03  +2.15777600E-02  -2.01207000E-02
   -9.49453000E-03  -1.05679800E-02  -1.18512400E-02  +3.22131600E-02  -1.08167800E-02
   -1.20433150E-01  +1.25622500E-02  -1.44375730E-01  +2.16074620E-01  -1.71742120E-01
   +3.18163490E-01  +7.02714000E-03  -1.96529000E-03  +4.57301000E-03  -1.17323360E-01
   -4.05136400E-02  -1.32590400E-02  -1.47837400E-02  -2.10936500E-02  -2.72101000E-03
   -7.67690000E-04  +3.06180000E-04  -4.60944000E-03  -2.50836000E-03  +6.90300000E-05
   -9.61290000E-04  +2.46441000E-03  +2.94181000E-03  -2.50579000E-03  +4.75733380E-01
   -1.81970500E-02  -2.53035600E-02  -1.13248000E-03  -4.41826500E-02  -1.36896800E-01
   -7.13630000E-04  -4.46259000E-03  +5.19203000E-03  -3.16802000E-03  +1.45883000E-03
   +1.76903000E-03  +2.90898000E-03  -4.51940000E-04  -1.28816000E-03  +1.74970000E-04
   +2.34697000E-03  -1.04676000E-03  +3.45682000E-03  -5.01601000E-03  +4.80948530E-01
   +1.12115500E-02  +9.78027000E-03  +4.40680000E-03  -1.14457300E-02  +1.69146000E-03
   -7.64472100E-02  -8.01528000E-03  -1.20406800E-02  +1.86393000E-03  -4.28572000E-03
   +1.68858000E-03  +3.63227000E-03  -5.30180000E-04  +9.40840000E-04  -1.12162000E-03
   -2.91643000E-03  +4.59837000E-03  +1.83476000E-03  +1.04297000E-03  -5.46730000E-04
   +4.84239200E-01  -1.07630000E-04  -3.45030000E-04  -6.82610000E-04  -1.27796000E-03
   -9.37547000E-03  -2.06901500E-02  -2.87800000E-04  -1.67893000E-03  +1.80040000E-04
   -9.49820000E-04  -3.90270000E-04  +1.12263000E-03  +1.84180000E-04  +8.34570000E-04
   -2.43230000E-04  -3.22410000E-04  +4.22010000E-04  +3.80800000E-05  -7.61740400E-02
   +1.27147000E-03  +3.46430000E-03  +5.85791430E-01  -9.63900000E-04  -8.23450000E-04
   -1.26324000E-03  -4.51197000E-03  -1.55411200E-02  -2.68166200E-02  +1.52723000E-03
   -1.27571000E-03  +2.99460000E-04  -8.02490000E-04  -9.08620000E-04  +1.32134000E-03
   -1.79790000E-04  +1.14414000E-03  -6.24440000E-04  -8.12200000E-05  +8.40780000E-04
   +3.34450000E-04  +3.90507000E-03  -8.63318600E-02  -3.42882300E-02  +2.66062000E-03
   +5.70821010E-01  +1.06559000E-03  +1.56583000E-03  -2.31540000E-04  -6.91943000E-03
   -1.15074300E-02  -7.06025000E-03  +1.24113000E-03  +4.12980000E-04  -3.46000000E-06
   -6.04000000E-05  +2.23790000E-04  +4.28600000E-05  -1.40500000E-05  -3.04050000E-04
   +2.74550000E-04  -3.24640000E-04  +1.40550000E-04  -1.15180000E-04  +8.23793000E-03
   -2.94084500E-02  -1.62191540E-01  +1.21755600E-02  -4.37930300E-02  +4.80633820E-01
   +6.79320000E-04  +8.05438000E-03  -5.50799000E-03  +1.75809000E-03  -4.83475000E-03
   +4.31915000E-03  -2.97881000E-03  -1.12221000E-03  -5.60585000E-03  +6.46874000E-03
   -2.81541000E-03  -8.54250000E-04  -1.63403270E-01  -1.27224620E-01  -1.88526300E-02
   -3.78438700E-02  -4.52158900E-02  -8.18002000E-03  +1.13022000E-03  +9.60600000E-04
   -2.14410000E-04  -7.43400000E-04  -6.93270000E-04  +3.58710000E-04  +5.51320130E-01
   +2.09837000E-03  -1.98817000E-03  +3.86757000E-03  -3.49873000E-03  -9.63970000E-04
   -1.27552000E-03  +5.89703000E-03  +1.92088000E-03  +5.66271000E-03  -3.61368300E-02
   -4.64249200E-02  +1.12700000E-03  -8.38715500E-02  -2.39179640E-01  +2.77981600E-02
   -1.19226200E-02  +2.33411000E-03  -4.90297000E-03  +1.15505000E-03  +1.12759000E-03
   -1.06343000E-03  -1.01588000E-03  -1.05028000E-03  +4.70930000E-04  +6.67330000E-02
   +3.48880990E-01  -3.20097000E-03  +7.18735000E-03  +2.46510000E-04  +3.16606000E-03
   -2.81894000E-03  +1.68949000E-03  -8.53502000E-03  +1.63694000E-03  +2.36594000E-03
   +1.21471600E-02  +2.03767800E-02  +8.84007000E-03  -3.55096000E-02  +3.18263000E-03
   -6.53081000E-02  -2.09270600E-02  -2.38324900E-02  +4.48898000E-03  +5.29110000E-04
   -1.78060000E-04  -3.77050000E-04  -1.05420000E-04  -6.22800000E-05  -2.21000000E-05
   +2.71710510E-01  -8.63991900E-02  +2.15050110E-01  -2.74380000E-04  +3.57960000E-04
   +7.00140000E-04  -3.35280700E-02  -2.73836000E-03  +2.01059000E-03  -2.36930000E-04
   -9.30860000E-04  +1.82888000E-03  -2.62600000E-05  -5.77370000E-04  -8.11330000E-04
   -3.32690000E-04  +8.39400000E-05  -3.56090000E-04  +3.98900000E-05  +8.98670000E-04
   -3.40050000E-04  -1.60733070E-01  +2.87013200E-02  +1.86319200E-02  -3.76767000E-03
   +4.10742000E-03  +6.65455000E-03  +1.00020000E-04  +1.37700000E-04  +7.64700000E-05
   +6.51880920E-01  -3.00036000E-03  -1.88715000E-03  +9.81670000E-04  -2.18999000E-02
   +9.13976000E-03  +3.20043000E-03  -5.97030000E-04  -2.87036000E-03  +1.10442000E-03
   -5.14250000E-04  -1.21607000E-03  -9.31310000E-04  -1.89320000E-04  +1.20146000E-03
   -4.40740000E-04  +1.13420000E-04  +4.74220000E-04  -6.48400000E-05  +2.75005300E-02
   -8.09760200E-02  -1.44381400E-02  +1.19203800E-02  -4.61841000E-03  -3.97702000E-03
   -6.95020000E-04  -9.98460000E-04  -1.88800000E-05  -6.00965900E-02  +2.71123160E-01
   +4.13700000E-04  +6.17080000E-04  +2.92710000E-04  -4.34627000E-03  +3.39617000E-03
   +1.01911000E-03  -1.23050000E-04  -1.26466000E-03  +7.72000000E-05  -1.87850000E-04
   -5.76730000E-04  -2.53000000E-04  -1.67990000E-04  +5.48280000E-04  -3.03710000E-04
   +5.07600000E-04  -1.59230000E-04  +7.59600000E-05  +1.42047600E-02  -1.37868400E-02
   -9.05248600E-02  +3.18202900E-02  -1.17942100E-02  -9.35460000E-03  -1.71320000E-04
   -3.15280000E-04  +1.21260000E-04  +8.96430200E-02  +1.59584960E-01  +5.61597950E-01
   +9.71970000E-04  +5.10700000E-04  -4.82970000E-04  -1.02024000E-03  +1.35386000E-03
   -1.44850000E-04  -7.95530000E-04  -9.71770000E-04  -4.07600000E-04  +9.91800000E-05
   +6.27480000E-04  -2.64920000E-04  +2.69570000E-04  -4.40660000E-04  +4.57140000E-04
   -3.23710000E-04  -5.06010000E-04  -2.78300000E-04  -2.37862400E-02  -1.39760000E-03
   -1.42242800E-02  -2.03758000E-03  +3.70540000E-04  -6.33580000E-04  +1.31500000E-04
   +2.52610000E-04  -4.33000000E-06  -2.82697800E-01  -1.06877000E-03  -9.81243200E-02
   +6.56444290E-01  -6.15420000E-04  -2.08050000E-04  +2.48770000E-04  +6.67200000E-05
   -1.51920000E-03  +2.65080000E-04  +4.47920000E-04  +5.63900000E-04  +1.87340000E-04
   -6.17500000E-05  -3.30190000E-04  +1.21890000E-04  -1.80790000E-04  +2.12580000E-04
   -2.17750000E-04  +1.40460000E-04  +3.93340000E-04  +1.24250000E-04  +7.66045000E-03
   +4.65045000E-03  +6.98690000E-03  +7.22930000E-04  -8.22970000E-04  +1.97310000E-04
   -5.59800000E-05  -9.42400000E-05  -1.63500000E-05  -2.88216400E-02  -8.65146500E-02
   -5.93023400E-02  -7.17513300E-02  +2.75595950E-01  +3.20510000E-04  +5.65460000E-04
   -5.88910000E-04  +2.77128000E-03  -8.33670000E-04  -4.02800000E-04  -1.58300000E-05
   +2.67400000E-04  -4.79200000E-05  +1.38110000E-04  +4.42650000E-04  +1.80250000E-04
   -1.27100000E-05  -3.38690000E-04  +1.71190000E-04  +5.63600000E-05  -2.83030000E-04
   +4.81600000E-05  +2.45257000E-03  +3.61961000E-03  +9.21636000E-03  +1.30249000E-03
   +3.32070000E-04  +1.85490000E-04  +2.88860000E-04  +3.60160000E-04  +3.52600000E-05
   -1.49744830E-01  -3.58214000E-02  -2.04979560E-01  +8.13654700E-02  +2.32628910E-01
   +6.40617790E-01  -2.69830000E-04  +7.59700000E-05  -1.57250000E-04  -4.62910000E-04
   +3.93700000E-04  +1.02100000E-04  +6.37000000E-06  -4.00000000E-05  +7.73800000E-05
   +1.10700000E-05  -5.51300000E-05  -6.63900000E-05  -2.77690000E-04  -1.35460000E-04
   -8.87800000E-05  +2.60100000E-04  -1.01180000E-04  +1.36840000E-04  +6.83700000E-05
   -4.64300000E-05  -2.77432000E-03  +6.31590000E-04  -3.44160000E-04  -6.38070000E-04
   +2.36820000E-04  +2.21800000E-04  +2.91800000E-05  -4.30216400E-02  +2.33997000E-03
   -2.31285600E-02  -2.60700100E-01  +9.05821900E-02  +6.34082400E-02  +6.98202890E-01
   +1.18467000E-03  -6.97200000E-05  +1.63910000E-04  +1.64700000E-03  -1.21950000E-03
   -6.78490000E-04  -4.80880000E-04  +7.40200000E-05  -8.20750000E-04  +8.30000000E-05
   +9.05200000E-04  -1.34680000E-04  -1.50760000E-04  -1.11716000E-03  +4.41380000E-04
   -2.31980000E-04  -3.29570000E-04  -1.97150000E-04  -1.22784000E-03  +5.67276000E-03
   -2.84828000E-03  +9.29770000E-04  -2.11030000E-04  -4.25300000E-05  +7.04900000E-04
   +1.02301000E-03  -1.54100000E-05  +1.97781700E-02  +2.71048600E-02  +5.49454300E-02
   +3.07094500E-02  -8.19036200E-02  -6.55281800E-02  -9.07816800E-02  +2.39499870E-01
   +2.94300000E-05  +1.94810000E-04  -2.76010000E-04  -9.72100000E-05  -2.54190000E-04
   -1.11580000E-04  -2.19150000E-04  -1.78500000E-04  -1.65010000E-04  +1.05410000E-04
   +4.23120000E-04  -4.12600000E-05  -2.01510000E-04  -5.64080000E-04  +1.24050000E-04
   +9.27000000E-06  -1.45430000E-04  +3.04000000E-06  -2.54567000E-03  -2.60254000E-03
   -7.32140000E-04  +1.08547000E-03  -3.97530000E-04  -1.15100000E-04  +4.33020000E-04
   +5.29690000E-04  +4.93700000E-05  -5.87404000E-03  +1.60767300E-02  +3.32513300E-02
   +2.48348900E-02  -4.41261300E-02  -1.18978710E-01  +1.37760400E-02  +1.72984010E-01
   +5.29286040E-01  -1.67230000E-04  +2.03980000E-04  -1.55350000E-04  +1.34130000E-04
   -8.28650000E-04  -2.06460000E-04  +1.88400000E-05  +3.66390000E-04  -8.96600000E-05
   +1.49100000E-04  +4.43990000E-04  -4.51600000E-05  -8.85180000E-04  -1.10709000E-03
   -5.15300000E-05  +4.85040000E-04  -1.84320000E-04  +2.65530000E-04  -3.06420000E-03
   +5.49260000E-04  +1.16230000E-04  +6.09740000E-04  +1.71630000E-04  +3.32820000E-04
   +1.07650000E-03  +1.28837000E-03  +1.33550000E-04  -5.93368000E-03  -1.30730900E-02
   -2.90053400E-02  +2.20042900E-02  -2.46004000E-03  +3.59215700E-02  -8.86367500E-02
   +5.52950400E-02  +2.49442600E-02  +7.73085170E-01  -6.73100000E-05  -1.39020000E-04
   +2.88700000E-05  -3.94690000E-04  +6.62480000E-04  +2.08940000E-04  +2.53100000E-05
   -1.49600000E-05  +1.37250000E-04  -3.75900000E-05  -2.87200000E-04  -1.12300000E-05
   +1.21000000E-04  +3.79480000E-04  -8.03900000E-05  +6.91000000E-06  +5.68800000E-05
   +2.69700000E-05  -2.34150000E-04  -1.03987000E-03  -3.92400000E-04  -1.32460000E-04
   +7.91400000E-05  -4.15000000E-05  -2.74010000E-04  -3.65370000E-04  -2.07000000E-05
   -9.71458000E-03  -1.28865300E-02  -1.69734600E-02  +3.01121700E-02  -9.90089000E-03
   -9.05067000E-03  -1.61745000E-03  -8.25765300E-02  -5.90560200E-02  -1.20098620E-01
   +2.98847350E-01  -3.18340000E-04  -2.44500000E-04  +2.87840000E-04  -1.12883000E-03
   +1.08020000E-03  +2.83860000E-04  +2.91480000E-04  +2.95000000E-05  +3.60220000E-04
   -1.69830000E-04  -6.84050000E-04  -4.11300000E-05  +1.45700000E-05  +6.76470000E-04
   -2.79160000E-04  +1.54230000E-04  +1.93750000E-04  +7.12700000E-05  -6.97290000E-04
   -9.25380000E-04  -1.84478000E-03  -2.58060000E-04  -1.27340000E-04  -1.40790000E-04
   -4.16070000E-04  -5.70120000E-04  -3.68900000E-05  -2.14627000E-02  -1.67938300E-02
   -4.60804200E-02  +6.00993300E-02  -1.02058100E-02  +4.47951000E-03  -2.12109600E-02
   -6.86124600E-02  -2.00877060E-01  +1.31227300E-02  +1.42204460E-01  +5.31337570E-01
   +4.98450000E-04  +1.16080000E-04  -2.35060000E-04  +5.99980000E-04  -6.70600000E-05
   -3.60500000E-05  -3.33170000E-04  -4.01030000E-04  -2.83440000E-04  +7.32200000E-05
   +3.05230000E-04  +7.04000000E-06  +4.84820000E-04  +7.46300000E-05  +2.86870000E-04
   -4.97080000E-04  -1.89310000E-04  -3.25550000E-04  +3.81654000E-03  -8.55400000E-05
   -9.09320000E-04  +1.97890000E-04  -7.31900000E-05  -3.60780000E-04  -3.15750000E-04
   -3.28720000E-04  -7.12600000E-05  +1.78079000E-02  +3.12279800E-02  +7.10650800E-02
   -5.40061500E-02  +1.28775700E-02  -1.46450900E-02  +2.64571200E-02  -3.47616900E-02
   -3.54419200E-02  -1.82621460E-01  -4.16440000E-03  -5.12450100E-02  +6.77062850E-01
   -1.66270000E-04  +1.48990000E-04  +1.45390000E-04  -3.56840000E-04  -3.01160000E-04
   +2.97410000E-04  +2.12140000E-04  +2.36380000E-04  +2.22510000E-04  +2.15000000E-05
   -9.33800000E-05  +1.93000000E-05  +8.23600000E-05  +1.42850000E-04  -5.25900000E-05
   +8.23700000E-05  +1.56300000E-04  +1.09180000E-04  -7.35520000E-04  +2.16801000E-03
   -3.37880000E-03  +8.20270000E-04  -1.28770000E-04  -3.47500000E-05  -8.40700000E-05
   -7.64200000E-05  +8.95000000E-06  +1.34839500E-02  -2.79795000E-03  -2.01480200E-02
   +7.69289000E-03  -1.66782000E-03  +1.97688000E-03  -1.60746700E-02  +3.35636000E-03
   -1.43463000E-03  -1.40613700E-02  -9.01812900E-02  -4.67169300E-02  -1.14621930E-01
   +2.47665010E-01  +2.22500000E-05  +2.62120000E-04  -3.45000000E-06  -6.76440000E-04
   -2.65380000E-04  +1.34060000E-04  -1.72300000E-05  -3.36900000E-05  +1.74990000E-04
   +7.54900000E-05  +8.41800000E-05  +5.05200000E-05  +2.90100000E-04  +1.54220000E-04
   +6.86600000E-05  -1.94840000E-04  -3.83700000E-05  -1.07050000E-04  -1.24107000E-03
   -3.31919000E-03  -4.01742000E-03  +1.43095000E-03  -4.02510000E-04  -3.71800000E-05
   -2.11850000E-04  -2.49870000E-04  -2.87000000E-05  +3.23546700E-02  -9.05990000E-03
   +2.02505000E-03  -8.82331000E-03  +3.71676000E-03  -5.71864000E-03  -2.27207500E-02
   -2.40080400E-02  -2.63367000E-02  -9.17117100E-02  -2.78054300E-02  -1.84426970E-01
   -2.03792000E-02  +2.23859840E-01  +6.24391040E-01  -9.18050000E-04  -2.51300000E-04
   +4.54600000E-04  -7.98920000E-04  +1.74556000E-03  +2.41144000E-03  +5.12610000E-04
   +3.37860000E-04  +4.92240000E-04  -4.46300000E-05  -4.99450000E-04  -1.15850000E-04
   -2.07610000E-04  +2.03760000E-04  -2.32670000E-04  +3.53930000E-04  +1.53050000E-04
   +2.06630000E-04  -5.89774000E-03  +1.38593800E-02  +2.85623000E-02  -6.34080000E-03
   +1.73163000E-03  -3.89100000E-05  -3.75000000E-05  -1.03750000E-04  +8.22000000E-06
   -1.26546900E-01  +3.96270000E-03  -1.44062500E-02  +3.99274000E-02  -1.95222700E-02
   -1.41929400E-02  -1.15989400E-02  +2.80261000E-02  +1.35333900E-02  -5.34965600E-02
   -2.74073000E-03  -2.56686000E-02  -3.49612940E-01  +9.83545300E-02  +9.57688700E-02
   +7.46596160E-01  -2.68870000E-04  -5.21130000E-04  +7.56770000E-04  -9.09930000E-04
   +2.06120000E-04  +9.50800000E-05  +2.04830000E-04  +1.38610000E-04  +1.85570000E-04
   -1.35140000E-04  -2.21700000E-04  -6.40600000E-05  -7.77200000E-05  +4.78600000E-05
   -1.75630000E-04  +1.29200000E-05  +2.86880000E-04  -3.65400000E-05  +5.60577000E-03
   -4.49871000E-03  -9.03300000E-03  +1.28344000E-03  +6.08240000E-04  +3.45060000E-04
   -3.25800000E-05  -1.27500000E-05  -3.00300000E-05  +3.31041500E-02  -1.12298360E-01
   -7.25618800E-02  -3.11609600E-02  +1.00081700E-02  -2.12079400E-02  +1.06208300E-02
   -2.41804800E-02  -1.17400500E-02  +1.23095300E-02  +1.34375300E-02  +3.04256300E-02
   +7.34706900E-02  -1.00582070E-01  -5.84762300E-02  -8.97970800E-02  +2.55902460E-01
   +1.01724000E-03  -7.73140000E-04  -8.14600000E-05  +7.18850000E-04  -3.99350000E-04
   -6.25760000E-04  -5.83550000E-04  -1.95470000E-04  -7.30930000E-04  -1.26450000E-04
   -2.61900000E-05  -3.03700000E-04  -4.83400000E-05  -2.13430000E-04  +1.50410000E-04
   -2.87720000E-04  -4.66200000E-05  -2.24620000E-04  +9.83307000E-03  -3.68469000E-03
   -4.32843000E-03  -8.95000000E-05  -5.04100000E-05  +4.49270000E-04  +2.49800000E-05
   +8.24600000E-05  -7.31600000E-05  +4.54928100E-02  -8.29964700E-02  -2.29928760E-01
   -5.59658100E-02  -4.38250000E-03  -4.20825400E-02  +2.11864500E-02  -2.89310800E-02
   -2.51142000E-02  +8.51513000E-03  +2.31575000E-02  +5.45655400E-02  +3.66649900E-02
   -4.53813600E-02  -1.47248180E-01  +5.16605100E-02  +1.85947270E-01  +5.68723720E-01
   +2.28000000E-06  -1.92000000E-04  +1.17280000E-04  -4.48890000E-04  +1.23132000E-03
   +4.07100000E-04  +5.45300000E-05  -3.70510000E-04  +2.71810000E-04  -1.42750000E-04
   -6.11230000E-04  +4.44300000E-05  +8.63110000E-04  +1.25686000E-03  -2.11800000E-05
   -4.46580000E-04  +1.59510000E-04  -2.46980000E-04  +2.39752000E-03  -9.20390000E-04
   -8.05300000E-04  -8.17580000E-04  -6.01600000E-05  -3.55930000E-04  -1.16777000E-03
   -1.43336000E-03  -1.35780000E-04  +1.30854000E-03  +6.84718000E-03  +1.41028700E-02
   -7.08004000E-03  +7.77122000E-03  -5.29636000E-03  -4.89716000E-02  -1.56757000E-02
   +3.83874000E-02  -4.24427440E-01  +1.14888230E-01  +7.96724900E-02  -7.24681300E-02
   +1.19479600E-02  +6.54370000E-04  +1.01769900E-02  -6.66045000E-03  -1.47045400E-02
   +5.25263630E-01  +6.08100000E-05  +1.19540000E-04  -1.02500000E-05  +1.97480000E-04
   -6.57600000E-04  -2.87730000E-04  -2.28000000E-05  +1.51920000E-04  -1.55330000E-04
   +4.08500000E-05  +3.39990000E-04  -2.17400000E-05  -3.43050000E-04  -6.05770000E-04
   +3.84400000E-05  +1.66290000E-04  -5.79700000E-05  +1.28160000E-04  -9.11460000E-04
   +1.01680000E-04  +7.27190000E-04  +3.52990000E-04  -2.51000000E-06  +1.33470000E-04
   +5.21150000E-04  +6.99130000E-04  +6.87400000E-05  +8.73650000E-04  -1.51224000E-03
   -1.51697000E-03  -9.02800000E-05  +2.61234000E-03  -1.68980000E-03  +2.99498400E-02
   +1.29472000E-02  -2.46837600E-02  +9.89735900E-02  -1.11049080E-01  -3.41622200E-02
   +8.24956000E-03  +1.72189400E-02  +2.96565000E-03  -2.11532000E-03  +4.67339000E-03
   -1.98244000E-03  -1.35039310E-01  +1.13676650E-01  -5.89000000E-06  +1.29600000E-04
   -9.16200000E-05  +2.70250000E-04  -4.38220000E-04  -4.78300000E-05  -6.09800000E-05
   +7.17400000E-05  -6.71600000E-05  +7.40700000E-05  +2.33150000E-04  +2.62300000E-05
   -1.32730000E-04  -3.19030000E-04  +4.21300000E-05  +4.47100000E-05  -5.86200000E-05
   +4.11300000E-05  -9.15300000E-05  +4.18920000E-04  +6.33570000E-04  +1.35100000E-04
   -1.36700000E-05  +4.30700000E-05  +2.57580000E-04  +3.27890000E-04  +4.69200000E-05
   +2.70747000E-03  +2.30167000E-03  +4.84201000E-03  -8.77678000E-03  -2.38287000E-03
   -5.44872000E-03  +4.48863800E-02  -2.29009700E-02  -2.63452000E-02  +8.49305600E-02
   -3.24521000E-02  -1.08906950E-01  -2.51511500E-02  +9.08326000E-03  +2.09905000E-02
   -1.52540000E-04  -5.68159000E-03  -7.61844000E-03  -1.20310490E-01  +4.42314100E-02
   +1.17571310E-01  -1.19660000E-04  -2.52600000E-05  +1.35110000E-04  -2.66390000E-04
   +6.56360000E-04  +1.85190000E-04  +1.49760000E-04  -8.74400000E-05  +2.38730000E-04
   -6.01800000E-05  -3.67580000E-04  +7.87700000E-05  +4.15820000E-04  +6.84290000E-04
   -8.62100000E-05  -1.31730000E-04  +1.33210000E-04  -6.48500000E-05  +3.21090000E-04
   -2.67620000E-04  -1.66469000E-03  -3.21980000E-04  -1.01240000E-04  -6.31800000E-05
   -6.00760000E-04  -7.32070000E-04  -3.13300000E-05  -4.85371000E-03  -1.15984000E-03
   -4.34386000E-03  -2.96663100E-02  -1.61870100E-02  -2.44102100E-02  -2.13630500E-01
   -2.23112200E-02  -1.14113590E-01  -3.33945900E-02  -3.95654000E-03  -4.48265000E-03
   +9.10962000E-03  +3.75350000E-04  +4.31272000E-03  -7.10285000E-03  +3.56903000E-03
   +3.23775000E-03  +2.37234100E-02  +2.27431000E-03  +1.31120100E-02  +5.66186770E-01
   -1.00110000E-04  +2.47600000E-05  +9.34700000E-05  +2.95100000E-05  -3.86600000E-05
   +6.47300000E-05  +1.14960000E-04  +7.89900000E-05  +9.53800000E-05  -2.43900000E-05
   -1.01350000E-04  +4.32800000E-05  +8.56700000E-05  +1.70470000E-04  -5.08300000E-05
   +2.78000000E-06  +8.44600000E-05  +2.78900000E-05  +6.64810000E-04  +4.36280000E-04
   +2.77080000E-04  -2.26080000E-04  -8.90400000E-05  +5.00200000E-05  -1.34520000E-04
   -1.49810000E-04  +0.00000000E+00  +2.19880000E-04  -1.35675000E-03  -8.83240000E-03
   +1.72215900E-02  +5.10597000E-03  +1.34425300E-02  -2.08623100E-02  -5.57965300E-02
   -5.10525000E-02  -1.58938800E-02  -2.62211000E-03  -8.29875000E-03  +4.07727000E-03
   +4.19105000E-03  -1.82259000E-03  -3.22655000E-03  +1.68066000E-03  +2.62270000E-03
   +4.54060000E-04  -1.62255000E-03  -2.74940000E-03  -4.71901000E-02  +1.01860560E-01
   -1.30980000E-04  +2.79900000E-05  +5.26900000E-05  -3.06740000E-04  +2.23580000E-04
   +1.82520000E-04  +8.84500000E-05  +3.36000000E-06  +1.74720000E-04  -1.94800000E-05
   -2.02290000E-04  +5.37800000E-05  +1.83800000E-04  +3.53090000E-04  -6.74300000E-05
   -3.83300000E-05  +9.60000000E-05  -3.50000000E-06  +6.28300000E-04  -7.87580000E-04
   +6.15280000E-04  -3.17360000E-04  +6.88200000E-05  -1.72200000E-05  -2.96300000E-04
   -3.55030000E-04  +3.18000000E-06  +1.20540000E-03  -4.14465000E-03  -3.33952000E-03
   +5.94898000E-03  +4.23793000E-03  +1.13630300E-02  -5.64407600E-02  -4.48715100E-02
   -1.55537730E-01  -4.13442100E-02  -1.90133200E-02  -3.08357700E-02  +6.17732000E-03
   -5.20295000E-03  -3.29178000E-03  -2.51880000E-03  +1.91934000E-03  +1.00473000E-03
   -4.00980000E-03  -7.86800000E-05  -2.13318000E-03  -7.55707700E-02  +1.45079630E-01
   +3.76728650E-01  -3.53054000E-03  -2.99063000E-03  -1.29199000E-03  +6.51490000E-03
   -1.62170200E-02  +1.41246000E-02  -9.86760000E-04  -1.51635000E-03  +8.64630000E-04
   +1.06490000E-04  -3.85590000E-04  +3.65780000E-04  +3.66050000E-04  +4.05830000E-04
   -3.59500000E-05  +5.65330000E-04  -1.03013000E-03  +3.41300000E-04  -8.06386500E-02
   +1.88381700E-02  -1.62638600E-02  +5.94230000E-04  -4.34130000E-04  -9.69910000E-04
   -4.79960000E-04  -5.69060000E-04  -8.02400000E-05  -1.64820800E-02  +2.59936000E-02
   -1.97226700E-02  -1.03910000E-04  +1.59554000E-03  +1.54269000E-03  -1.18037000E-03
   -2.25120000E-04  +1.37327000E-03  +8.90820000E-04  -3.82430000E-04  -1.33072000E-03
   +2.57300000E-05  -4.10350000E-04  -3.21810000E-04  -4.33410000E-04  +7.67440000E-04
   -6.34580000E-04  -1.32494000E-03  +6.17220000E-04  +4.56830000E-04  -6.66510000E-04
   -2.55840000E-04  +3.26800000E-05  +5.81124830E-01  -3.68868000E-03  -1.66929000E-03
   -5.98210000E-04  +1.86928000E-03  -2.56241600E-02  +1.72141900E-02  -4.34050000E-04
   -5.52600000E-04  -6.09750000E-04  +9.22990000E-04  -5.31100000E-04  +5.64160000E-04
   -9.72400000E-05  +4.55100000E-05  +7.48000000E-05  +7.37930000E-04  -8.26820000E-04
   +4.60610000E-04  +1.44963800E-02  -1.30923340E-01  +4.69557300E-02  -1.98645000E-03
   +6.94747000E-03  -2.03279000E-03  -4.13300000E-05  -1.19360000E-04  +3.60000000E-06
   +1.28314500E-02  -1.28859400E-02  +6.26725000E-03  -1.81076000E-03  -7.33180000E-04
   -5.06460000E-04  +3.59700000E-04  -3.19000000E-06  -3.75530000E-04  +7.99100000E-05
   +1.36670000E-04  +2.23350000E-04  -1.35340000E-04  +3.71530000E-04  +2.02130000E-04
   -5.65800000E-05  -1.32130000E-04  +5.73200000E-04  -5.76300000E-05  -2.37800000E-05
   -3.02400000E-05  -4.86800000E-05  +5.50100000E-05  -6.18600000E-05  +2.16537100E-02
   +5.11065140E-01  -1.29991000E-03  -1.04030000E-03  -7.51700000E-05  +3.56278000E-03
   -4.08820000E-04  +2.23890000E-03  -9.32800000E-04  -9.67420000E-04  -3.52660000E-04
   -6.67000000E-06  -1.33000000E-04  -4.86400000E-05  +1.83350000E-04  +5.31600000E-05
   +2.41890000E-04  -2.20880000E-04  -4.38960000E-04  +1.52240000E-04  -1.22446100E-02
   +4.41209100E-02  -1.13244540E-01  -8.94501000E-03  +2.54615800E-02  -3.36517600E-02
   -2.17630000E-04  -2.53040000E-04  -4.96300000E-05  -3.96309000E-03  -1.81978000E-03
   +5.51958000E-03  +4.10450000E-04  -1.67680000E-04  -4.47600000E-04  +6.39360000E-04
   -1.53800000E-04  -7.55580000E-04  -3.66540000E-04  +1.55510000E-04  +1.33857000E-03
   -5.42670000E-04  +7.76000000E-06  -2.43170000E-04  +1.95182000E-03  -6.27870000E-04
   +4.35000000E-06  +7.84760000E-04  -3.52500000E-04  -4.06800000E-04  +1.64600000E-04
   +2.45100000E-05  -6.13000000E-05  -1.38440200E-02  +5.88977200E-02  +5.46165770E-01
   +4.71870000E-04  +1.64300000E-05  +3.80460000E-04  -2.59330000E-04  -8.95300000E-05
   -1.12660000E-04  +8.37800000E-05  +1.33910000E-04  -2.31300000E-05  -9.29800000E-05
   -8.86300000E-05  -2.29600000E-05  +2.81280000E-04  +2.62860000E-04  +4.37600000E-05
   -1.53410000E-04  +9.91700000E-05  -1.10330000E-04  -6.40600000E-05  -3.79800000E-05
   +1.30000000E-05  +3.23300000E-05  -4.72200000E-05  +8.14800000E-05  -2.70890000E-04
   -2.72710000E-04  -6.44500000E-05  +5.88300000E-04  -1.05492000E-03  -4.07000000E-05
   +3.26906000E-03  +5.62090000E-04  -8.17640000E-04  +1.51411000E-03  +5.69565000E-03
   -6.15181000E-03  -7.22306000E-03  +2.37946000E-03  +4.51759000E-03  +1.78174000E-03
   +6.19930000E-04  +6.02390000E-04  -6.53240000E-04  -3.02070000E-04  +4.51110000E-04
   +7.96055000E-03  -5.89730000E-03  -1.57784000E-03  +3.71158000E-03  -1.11345000E-03
   +2.68707000E-03  +5.71900000E-05  -8.40000000E-07  -2.19800000E-05  +3.35029370E-01
   +6.76320000E-04  +1.10590000E-04  +1.57270000E-04  +7.48100000E-05  -9.71780000E-04
   -4.79060000E-04  -2.13990000E-04  +2.19690000E-04  -4.50580000E-04  -1.22800000E-05
   +6.28800000E-04  -1.85800000E-04  -2.79190000E-04  -9.04910000E-04  +2.52050000E-04
   +4.75700000E-05  -2.09510000E-04  +1.16520000E-04  -1.19189000E-03  -1.04030000E-04
   +1.08727000E-03  +6.77220000E-04  -3.32500000E-05  +7.66300000E-05  +6.92370000E-04
   +1.04377000E-03  +2.02200000E-05  +7.48539000E-03  +8.31889000E-03  +1.71285900E-02
   -2.90334600E-02  +9.53785000E-03  -2.32451000E-03  +5.84466000E-03  -8.59687100E-02
   +4.45852400E-02  +2.92196400E-02  -1.28593100E-02  -1.52874300E-02  -1.27598400E-02
   -2.47340000E-04  -5.17674000E-03  +1.18155300E-02  -6.53343000E-03  -9.90641000E-03
   -2.40770000E-02  +1.61672500E-02  +1.98778000E-03  +2.93430000E-03  +1.05345500E-02
   -3.59658000E-03  +9.65860000E-04  -1.00800000E-04  -3.95820000E-04  -8.17365900E-02
   +1.74970290E-01  -7.59950000E-04  -2.67600000E-05  -2.27680000E-04  +4.89300000E-05
   +4.64110000E-04  +3.52370000E-04  +4.24800000E-05  -1.96780000E-04  +2.16620000E-04
   +5.10700000E-05  -2.19350000E-04  +9.24600000E-05  -2.61300000E-05  +2.43060000E-04
   -1.47710000E-04  +1.02070000E-04  +7.57000000E-05  +1.18280000E-04  +6.54240000E-04
   -1.23700000E-04  -4.96000000E-04  -3.37950000E-04  +1.29680000E-04  -2.02210000E-04
   -1.47450000E-04  -2.69060000E-04  +6.03900000E-05  -4.41770000E-03  -3.65061000E-03
   -6.54455000E-03  +1.11324700E-02  -3.96288000E-03  +1.87713000E-03  -6.19965000E-03
   +2.87170300E-02  -9.85906000E-03  -5.75636000E-03  +8.46266000E-03  -1.89074000E-03
   +6.59901000E-03  +8.08880000E-04  +1.78432000E-03  -3.76844000E-03  +2.56719000E-03
   +4.57140000E-03  +1.91422000E-03  -4.06420000E-04  +1.89631000E-03  +3.90368000E-03
   -2.83512000E-03  +4.17527000E-03  -4.86520000E-04  +6.11200000E-05  +2.62290000E-04
   +8.84395600E-02  +1.30655090E-01  +6.09569120E-01  -4.12230000E-04  +8.52910000E-04
   -1.48276000E-03  +6.01550000E-04  -7.96800000E-05  +2.38390000E-04  -1.10727000E-03
   +1.02520000E-04  -2.85430000E-04  +4.48098000E-03  +3.74380000E-03  +1.63347000E-03
   -2.85175600E-02  +5.02863000E-03  -1.67086000E-02  -2.25400000E-05  -4.89124000E-03
   +6.29910000E-04  -1.28310000E-04  -1.64780000E-04  +1.26590000E-04  +1.21140000E-04
   +1.17650000E-04  -5.08600000E-05  -3.57508270E-01  +6.11264300E-02  -2.24423050E-01
   +1.68200000E-05  +1.45220000E-04  +5.15500000E-05  -4.52600000E-05  +2.38100000E-05
   -4.43500000E-05  -4.64700000E-05  -1.56730000E-04  -8.45200000E-05  -1.98170000E-04
   +5.36200000E-05  +7.67300000E-05  +4.50900000E-05  +3.06400000E-05  +3.86900000E-05
   +1.50000000E-06  +8.50000000E-07  -4.49600000E-05  +2.14310000E-04  -8.19900000E-05
   -4.06600000E-05  +1.22100000E-04  +3.57800000E-05  +6.80300000E-05  +6.90500000E-05
   +1.29000000E-05  +2.32200000E-05  +4.12100000E-05  -1.18720000E-04  +4.35500000E-05
   +3.82169080E-01  -8.39140000E-04  +1.52109000E-03  -4.20980000E-04  +5.68690000E-04
   -3.15210000E-04  +4.75040000E-04  -2.17650000E-04  -6.19370000E-04  -1.51800000E-04
   -1.86474000E-03  +1.52834000E-03  -2.01020000E-03  -3.59647700E-02  +3.53023000E-03
   -2.27682500E-02  -3.52434000E-03  -5.16329000E-03  +8.09660000E-04  +2.79800000E-05
   -1.16470000E-04  +4.75000000E-05  +2.76700000E-05  +2.36800000E-05  -6.49000000E-06
   +1.05366220E-01  -6.52923500E-02  +8.35956800E-02  -1.60200000E-05  +6.83100000E-05
   +5.41800000E-05  -2.60700000E-05  +1.57000000E-06  -3.14500000E-05  -3.19800000E-05
   -9.98500000E-05  -6.45300000E-05  -1.68280000E-04  +4.32100000E-05  +5.84000000E-05
   +4.48400000E-05  +9.51000000E-06  +3.42200000E-05  -6.61000000E-06  +2.65000000E-06
   -7.80000000E-06  +1.75690000E-04  -8.40400000E-05  -4.00700000E-05  +8.79000000E-05
   +1.77000000E-05  +4.00600000E-05  +3.13400000E-05  +4.39700000E-05  -6.50000000E-07
   +4.42100000E-05  -1.08840000E-04  +1.59200000E-05  -6.49108600E-02  +6.61375300E-02
   -8.61390000E-04  +5.01290000E-04  +9.50830000E-04  +1.04760000E-04  +1.20030000E-04
   +7.21000000E-06  -1.53800000E-04  +2.50800000E-05  -7.97130000E-04  +3.80163000E-03
   +1.17700000E-03  +8.11830000E-04  -9.64950000E-04  +5.01720000E-04  -3.27143000E-03
   +1.79860000E-04  +5.08500000E-05  +2.24947000E-03  -8.78900000E-05  -6.33800000E-05
   +2.88700000E-05  +5.29700000E-05  +7.77800000E-05  -2.78400000E-05  -2.41471800E-01
   +5.84964100E-02  -1.63453590E-01  -4.00600000E-05  +2.10400000E-05  -1.14000000E-05
   +1.42300000E-05  -9.93000000E-06  -1.19300000E-05  +2.70000000E-07  -1.07300000E-05
   -2.40900000E-05  -5.44200000E-05  +1.37000000E-05  +3.08500000E-05  +2.17600000E-05
   -4.25000000E-06  +1.06300000E-05  +1.47500000E-05  +6.53000000E-06  +2.64100000E-05
   +6.20900000E-05  -3.71100000E-05  -2.80000000E-05  +1.64600000E-05  -3.69000000E-06
   -3.61000000E-06  +3.45100000E-05  +7.88000000E-06  +2.19000000E-05  +1.94000000E-05
   -2.59100000E-05  -1.83900000E-05  +2.39611890E-01  -6.07454400E-02  +1.63787800E-01
   +2.10250000E-04  -8.48600000E-05  +7.43430000E-04  +9.68360000E-04  -4.55072000E-03
   -1.62008000E-03  -1.29342100E-02  +4.21557000E-03  -1.02627100E-02  -2.51839420E-01
   +1.64060200E-02  -1.31990780E-01  -5.53944000E-03  -4.74074000E-03  -3.77116000E-03
   +2.47230000E-03  +9.05130000E-04  -2.21255000E-03  -2.44310000E-04  +6.08210000E-04
   -5.65610000E-04  -1.68290000E-04  -1.54370000E-04  +7.54600000E-05  +1.85656000E-03
   +1.20334000E-03  +2.95783000E-03  +5.63100000E-05  -1.78830000E-04  -9.75500000E-05
   -4.31700000E-05  +3.47000000E-05  +6.48600000E-05  +2.36200000E-05  +5.78300000E-05
   +5.12300000E-05  +1.54920000E-04  -3.30900000E-05  -5.73000000E-05  -6.40100000E-05
   +2.92000000E-06  -1.68200000E-05  -1.80100000E-05  -8.87000000E-06  -4.90100000E-05
   -1.65660000E-04  +7.35000000E-05  +4.74500000E-05  -7.18200000E-05  -7.95000000E-06
   -2.37400000E-05  -7.23600000E-05  +5.33700000E-05  -2.16200000E-05  -3.63400000E-05
   +7.22500000E-05  -3.76000000E-06  +5.31000000E-06  +1.38004000E-03  -8.57560000E-04
   +2.66105210E-01  -4.01310000E-04  -1.61192000E-03  +1.72400000E-05  -3.88125000E-03
   -2.80862000E-03  +1.41799000E-03  -2.16452200E-02  +6.38662000E-03  -1.40841200E-02
   +1.64750400E-02  -5.96573100E-02  +2.01104400E-02  +2.27593500E-02  +2.41454000E-03
   +1.37856800E-02  +3.46630000E-04  -3.95655000E-03  +3.93045000E-03  -7.67160000E-04
   +5.93640000E-04  -4.04460000E-04  -1.03180000E-04  -5.45000000E-05  +8.67600000E-05
   +1.88664000E-03  +2.31110000E-03  -1.43768000E-03  -1.13320000E-04  -3.15960000E-04
   -1.22300000E-04  -1.21600000E-05  +9.02000000E-06  +5.13100000E-05  -4.69000000E-06
   +1.00540000E-04  +2.89000000E-05  +7.68000000E-05  -2.90500000E-05  -5.92300000E-05
   -1.03200000E-05  +9.39000000E-06  -7.48000000E-06  -1.13600000E-05  -8.08000000E-06
   +8.06000000E-06  -9.60400000E-05  +4.29900000E-05  +2.45900000E-05  -4.84700000E-05
   -7.17000000E-06  -2.66200000E-05  +1.05700000E-05  +9.85600000E-05  -4.27200000E-05
   +3.10000000E-06  +8.35100000E-05  -4.29100000E-05  -1.13278000E-03  -1.05588000E-03
   -4.77000000E-06  -1.56646200E-02  +5.72161200E-02  +9.26320000E-04  +2.19600000E-04
   -5.88110000E-04  -1.64500000E-03  +1.13745000E-03  +5.38601000E-03  -2.58770000E-04
   +7.50290000E-04  +1.66952000E-03  -1.32091990E-01  +2.01060300E-02  -1.16136810E-01
   -1.44804800E-02  -2.07398000E-03  -3.25174000E-03  -1.97333000E-03  +4.30306000E-03
   +2.89838000E-03  -9.22900000E-05  +2.01800000E-04  +2.93050000E-04  -1.00000000E-05
   +7.75600000E-05  +2.55900000E-05  +2.69719000E-03  -1.78616000E-03  -1.87521000E-03
   -1.45280000E-04  -1.72050000E-04  -4.71200000E-05  +2.57500000E-05  -2.83400000E-05
   +3.45500000E-05  +8.65000000E-06  +8.32900000E-05  +3.77300000E-05  +6.57500000E-05
   -2.99700000E-05  -4.88700000E-05  +3.24000000E-06  -4.98000000E-06  -1.99500000E-05
   +4.24000000E-06  -9.63000000E-06  +3.23000000E-05  -7.92100000E-05  +2.94800000E-05
   +1.48800000E-05  -4.66200000E-05  -1.50600000E-05  -3.24800000E-05  +3.63000000E-06
   -2.41400000E-05  -6.79100000E-05  -1.51300000E-05  +4.33700000E-05  -1.99400000E-05
   +1.22740000E-04  +1.42840000E-03  +7.44800000E-05  +1.45515520E-01  -2.24905000E-02
   +1.14973190E-01  -3.38364000E-03  -9.00520000E-04  -5.47544000E-03  -5.48720000E-04
   +2.30694100E-02  -1.19051100E-02  -7.42788700E-02  +5.86447800E-02  -4.34605100E-02
   +8.17024000E-03  -1.77224200E-02  +9.51975000E-03  -3.86940000E-04  -4.22542000E-03
   -2.91975000E-03  -1.16335000E-03  -5.64580000E-04  +2.39200000E-04  +4.46600000E-05
   +1.58594000E-03  +1.61061000E-03  +2.97940000E-04  +6.22000000E-05  +7.28600000E-05
   +1.33350000E-04  -1.04663000E-03  +4.81440000E-04  -1.48230000E-04  -2.28010000E-04
   +1.42950000E-04  -4.44100000E-05  -3.04200000E-05  +4.92400000E-05  -1.21300000E-05
   -1.14670000E-04  -2.39300000E-05  -8.89000000E-05  +2.55600000E-05  -1.41000000E-05
   +4.67300000E-05  -1.65300000E-05  +7.28100000E-05  -6.01900000E-05  -9.52600000E-05
   -1.42850000E-04  +1.01670000E-04  -5.92200000E-05  -3.00000000E-07  +7.35400000E-05
   +1.52600000E-05  +3.90600000E-05  -1.00325000E-03  -6.37880000E-04  -4.88610000E-04
   -3.50900000E-05  -1.74750000E-04  +9.70400000E-05  +1.23700000E-04  +4.01400000E-05
   +7.69200000E-05  -2.43200000E-04  +9.90660000E-04  +1.88413000E-03  +7.36906900E-02
   -7.13860000E-04  +2.02816000E-03  +1.52192000E-03  +6.00100000E-04  +2.02951000E-03
   +1.33101000E-03  +5.90290100E-02  -2.55799670E-01  +1.19084450E-01  +7.93135000E-03
   -1.67322800E-02  +1.23549400E-02  -4.54069000E-03  -6.08440000E-04  +6.10990000E-04
   -4.08960000E-04  +1.56090000E-04  -7.69590000E-04  +4.60950000E-04  -1.34799000E-03
   -8.21980000E-04  -1.24540000E-04  -1.87200000E-04  -6.92700000E-05  -6.77000000E-06
   -1.48809000E-03  +6.13590000E-04  +1.30610000E-04  +2.69570000E-04  +2.78230000E-04
   +5.80000000E-05  -3.54700000E-05  -8.95900000E-05  +2.09200000E-05  -2.08400000E-05
   -3.89800000E-05  -6.17100000E-05  +3.69600000E-05  +8.27600000E-05  -1.41300000E-05
   -1.19800000E-05  -3.67000000E-05  +9.10200000E-05  +4.24700000E-05  +9.74800000E-05
   +7.87100000E-05  -4.00500000E-05  -4.12400000E-05  +2.87700000E-05  -4.34000000E-06
   -1.05000000E-06  -2.44940000E-03  -1.51600000E-03  -5.45410000E-04  +1.76500000E-05
   -2.10700000E-05  -2.99000000E-06  +2.45760000E-04  +6.90300000E-05  +9.05300000E-05
   +5.44180000E-04  +3.73740000E-04  -1.47648000E-03  -5.85254200E-02  +2.74949530E-01
   -5.43593000E-03  +1.26732000E-03  +3.29766000E-03  -2.86074000E-03  +1.42725900E-02
   -2.78902000E-03  -4.39627100E-02  +1.19140190E-01  -1.10138170E-01  -4.20180000E-04
   -2.22636000E-03  +4.11040000E-03  -2.75681000E-03  +7.72140000E-04  +5.67600000E-03
   +1.51990000E-04  -8.60380000E-04  -7.89420000E-04  +2.12387000E-03  -8.04000000E-05
   -2.74513000E-03  -6.90080000E-04  -4.55530000E-04  -1.01200000E-05  +6.28500000E-05
   +3.45000000E-06  +6.68600000E-05  +3.09190000E-04  +2.37820000E-04  +2.42510000E-04
   +4.69800000E-05  -3.79600000E-05  -8.57500000E-05  +3.76700000E-05  -4.04500000E-05
   -2.04500000E-05  -2.31500000E-05  +3.57300000E-05  +6.41800000E-05  -6.24000000E-06
   -2.87900000E-05  -2.94000000E-05  +6.90400000E-05  +2.63600000E-05  +1.31130000E-04
   +5.11000000E-05  -4.47300000E-05  -3.06900000E-05  +8.10000000E-07  -1.87800000E-05
   -1.00200000E-05  -8.67800000E-05  +7.11540000E-04  +6.71340000E-04  -3.10200000E-05
   -6.52400000E-05  +4.14100000E-05  -9.00000000E-08  -2.12400000E-05  -3.53400000E-05
   +2.04454000E-03  -1.21374000E-03  -2.51985000E-03  +5.00323500E-02  -1.30992250E-01
   +1.06327510E-01  -2.60690640E-01  +1.94157300E-02  -1.28063210E-01  -3.07730000E-03
   -2.91570000E-04  -3.73453000E-03  +2.22701000E-03  +6.72110000E-04  -2.32209000E-03
   +2.14280000E-04  -2.26880000E-04  +8.26880000E-04  +1.65439000E-03  -3.97524000E-03
   -2.08051000E-03  -1.22798000E-02  +3.55346000E-03  -1.06523700E-02  -1.14821000E-03
   -3.52660000E-04  +1.08156000E-03  -3.34000000E-05  +1.15630000E-04  -2.39210000E-04
   -1.04816000E-03  +2.78400000E-05  -5.78960000E-04  -3.23210000E-04  -1.07356000E-03
   +4.51620000E-04  -2.70400000E-05  -2.32620000E-04  +1.60150000E-04  -1.04130000E-04
   +4.60300000E-05  -1.70700000E-05  -1.97910000E-04  +4.48800000E-05  -6.05700000E-05
   +1.83220000E-04  +4.81000000E-05  -9.79000000E-06  -1.05820000E-04  -2.82380000E-04
   +4.36000000E-05  +1.31660000E-04  -4.40100000E-05  -1.06000000E-06  +4.76100000E-05
   +2.87800000E-05  +5.59400000E-05  -1.41300000E-05  +9.65300000E-05  +1.35400000E-04
   +2.76400000E-05  +4.07700000E-05  -1.43830000E-04  -1.76520000E-04  -1.41730000E-04
   +8.58700000E-05  -2.18380000E-04  +9.14500000E-05  +2.10820000E-04  -1.84440000E-04
   -1.13140000E-04  -1.43670000E-04  +2.75016590E-01  +1.98953600E-02  -6.08515400E-02
   +1.87333200E-02  +2.34889400E-02  +3.58080000E-03  +1.32272200E-02  +1.25330000E-04
   -4.13504000E-03  +4.10645000E-03  -3.11670000E-04  -1.11163000E-03  -1.42920000E-04
   -3.76160000E-03  -2.71873000E-03  +2.14367000E-03  -2.27003800E-02  +5.82133000E-03
   -1.31694900E-02  +1.02442000E-03  +2.44440000E-04  -6.62820000E-04  +3.89500000E-05
   -6.24570000E-04  +2.13700000E-04  -1.12306000E-03  +3.04950000E-04  -7.44350000E-04
   -4.10080000E-04  -6.18010000E-04  +2.70350000E-04  -3.78820000E-04  -4.97200000E-05
   -7.62500000E-05  -2.22840000E-04  -2.32050000E-04  -4.35100000E-05  -4.73030000E-04
   +5.97000000E-06  -4.98000000E-05  +4.04780000E-04  -1.79870000E-04  +7.53000000E-06
   -2.41770000E-04  +1.56960000E-04  +5.55110000E-04  +4.48020000E-04  -2.39820000E-04
   -7.13400000E-05  +1.70820000E-04  +6.60000000E-07  +7.55200000E-05  +1.91100000E-05
   +9.50100000E-05  -4.36200000E-05  -1.59270000E-04  -5.87850000E-04  +2.99020000E-04
   -2.46740000E-04  -3.06100000E-04  -1.07480000E-04  +1.37410000E-04  +9.36000000E-06
   -1.99770000E-04  +1.31349000E-03  -7.75000000E-06  +7.33070000E-04  -1.79235200E-02
   +6.02826100E-02  -1.26899700E-01  +1.80400600E-02  -1.16281270E-01  -1.28219700E-02
   +4.39260000E-04  -2.90455000E-03  -2.56806000E-03  +4.46991000E-03  +3.20313000E-03
   +9.58390000E-04  +2.05900000E-05  -5.90080000E-04  -2.23566000E-03  +1.89505000E-03
   +6.56865000E-03  -1.08232000E-03  +1.35885000E-03  +3.23379000E-03  +4.79410000E-04
   -1.39809000E-03  -2.16034000E-03  +1.72600000E-05  -1.92370000E-04  +3.68300000E-05
   -2.60520000E-04  -1.47960000E-04  -7.47200000E-05  -3.68800000E-05  +2.39690000E-04
   +1.32800000E-04  +5.45210000E-04  -3.19600000E-04  +2.66930000E-04  +1.30440000E-04
   +3.05540000E-04  +2.22380000E-04  +3.85640000E-04  -8.40700000E-05  -2.05330000E-04
   +3.22500000E-05  -1.46400000E-04  -5.26900000E-05  -4.06900000E-05  -1.82890000E-04
   -2.07610000E-04  -3.71260000E-04  +1.26770000E-04  +8.49200000E-05  -1.70790000E-04
   -1.10910000E-04  -1.23260000E-04  +2.47560000E-04  +7.13400000E-05  -6.66600000E-05
   -1.27190000E-04  +1.10810000E-04  -2.47850000E-04  +1.22720000E-04  -5.75200000E-05
   -1.30060000E-04  +2.21010000E-04  -2.17440000E-04  -5.02060000E-04  -6.59540000E-04
   -6.34700000E-05  -3.40010000E-04  +1.42072710E-01  -2.22557000E-02  +1.13097910E-01
   +8.86692000E-03  -1.73327600E-02  +1.00525300E-02  -3.72860000E-04  -4.39325000E-03
   -3.00344000E-03  -1.36715000E-03  -7.37750000E-04  +7.34800000E-05  -3.35628000E-03
   -1.01881000E-03  -4.58669000E-03  -3.69740000E-04  +2.48823500E-02  -1.25308000E-02
   -7.12281600E-02  +5.40092700E-02  -4.05686900E-02  +6.53860000E-04  -6.18090000E-04
   +4.26510000E-04  +2.14400000E-05  +5.38200000E-05  +9.91900000E-05  +1.03579000E-03
   +4.05490000E-04  +2.31647000E-03  +5.84300000E-05  -4.26000000E-06  -3.20600000E-05
   +5.27100000E-05  -1.08900000E-05  +1.09500000E-05  -2.59700000E-05  +1.19200000E-04
   -2.04300000E-05  -2.33000000E-06  -1.65000000E-06  -1.12900000E-05  +9.30000000E-07
   +3.83900000E-05  +5.30000000E-06  -1.91400000E-05  +6.04000000E-06  -1.21900000E-05
   -1.82000000E-05  +4.34000000E-05  -6.90000000E-07  -1.00900000E-05  +9.29000000E-06
   -1.00000000E-06  -2.41770000E-04  -1.31670000E-04  -6.94000000E-05  +9.36700000E-05
   +2.32280000E-04  -1.22600000E-04  +2.21600000E-04  -1.34100000E-05  +4.22260000E-04
   -2.99420000E-04  +1.21655000E-03  -6.21440000E-04  -9.61100000E-05  +1.25080000E-04
   +3.13060000E-04  -2.37380000E-04  +1.15957000E-03  +2.10297000E-03  +6.67478200E-02
   +7.96447000E-03  -1.54713400E-02  +1.14831700E-02  -4.63575000E-03  -7.63710000E-04
   +6.43680000E-04  -3.59690000E-04  +2.31900000E-04  -6.59620000E-04  -5.14280000E-04
   +1.67871000E-03  +1.13010000E-03  -2.25855000E-03  +6.13400000E-05  +6.51650000E-04
   +5.54194300E-02  -2.65058230E-01  +1.18898900E-01  +6.31060000E-04  -4.05280000E-04
   +7.31350000E-04  -4.75500000E-05  -2.91700000E-05  +6.96300000E-05  +7.75520000E-04
   +5.69060000E-04  -1.07256000E-03  +1.76200000E-04  -5.55700000E-05  -8.09200000E-05
   +3.03900000E-05  +2.50000000E-06  +2.41200000E-05  +8.85000000E-06  +1.43160000E-04
   +9.59000000E-06  +7.30900000E-05  -2.03700000E-05  -2.44900000E-05  -2.64100000E-05
   +1.60000000E-05  -8.43000000E-06  -4.09000000E-06  +2.84800000E-05  +6.24000000E-06
   -9.25500000E-05  +5.67900000E-05  +1.07900000E-05  -5.84000000E-05  -6.61000000E-06
   -3.37700000E-05  -3.05710000E-04  -2.33500000E-04  -1.46060000E-04  +5.41100000E-05
   +1.86060000E-04  -1.20230000E-04  +6.90400000E-05  -1.66100000E-05  -1.50170000E-04
   -2.58600000E-05  +7.86000000E-05  -7.46600000E-05  +1.58670000E-04  -1.35730000E-04
   -1.37050000E-04  +5.96400000E-04  +3.03300000E-04  -1.62254000E-03  -5.76144900E-02
   +2.79316820E-01  +4.05850000E-04  -2.97409000E-03  +4.17592000E-03  -2.79338000E-03
   +1.13303000E-03  +5.87742000E-03  -6.00000000E-08  -8.63900000E-04  -6.33200000E-04
   -4.80011000E-03  +7.99300000E-04  +2.37382000E-03  -2.36362000E-03  +1.59646400E-02
   -2.37396000E-03  -4.09249600E-02  +1.18012990E-01  -1.03928120E-01  -2.90130000E-04
   -3.25400000E-05  +2.81710000E-04  +6.93000000E-06  -1.25000000E-06  -6.20100000E-05
   +2.26209000E-03  -1.20129000E-03  -1.61801000E-03  +1.28940000E-04  +3.92300000E-05
   -1.79800000E-05  -4.91200000E-05  +3.15500000E-05  -4.68400000E-05  +1.93100000E-05
   -3.67800000E-05  -2.46100000E-05  -3.16300000E-05  +1.95800000E-05  +5.33000000E-05
   +9.11000000E-06  -4.63500000E-05  +1.10000000E-05  +9.18000000E-06  +4.61400000E-05
   +4.33100000E-05  +5.22100000E-05  -5.50000000E-05  -2.59700000E-05  +3.97000000E-06
   -7.83000000E-06  -1.37500000E-05  +1.65500000E-05  -8.63800000E-05  -2.34100000E-05
   +1.76200000E-05  -9.78400000E-05  -4.26900000E-05  +3.87590000E-04  -2.00120000E-04
   -2.35160000E-04  -1.19780000E-04  +6.32480000E-04  -3.80870000E-04  +3.05770000E-04
   -1.61930000E-04  -4.97900000E-04  +2.16404000E-03  -1.30642000E-03  -3.06020000E-03
   +4.55670900E-02  -1.29695220E-01  +1.00207640E-01  +1.01290000E-04  +4.47530000E-04
   -2.51750000E-04  +9.42730000E-04  -1.02412000E-03  -3.73060000E-04  +2.14630000E-04
   +2.08030000E-04  -8.17700000E-05  +1.03370000E-04  +1.14470000E-04  +6.30500000E-05
   +8.40200000E-05  -5.96800000E-05  +1.15790000E-04  -1.49790000E-04  -6.60600000E-05
   +3.09200000E-05  -2.65791000E-03  +2.37210000E-04  -6.28050000E-04  -2.90517100E-01
   +6.74836500E-02  +4.64885300E-02  +1.76900000E-05  +6.66000000E-06  -2.38300000E-05
   +7.90310000E-04  +1.01060000E-04  +2.03800000E-04  -2.28850000E-04  -8.80000000E-07
   -2.82090000E-04  +3.38360000E-04  +8.87300000E-05  +3.01180000E-04  +2.68980000E-04
   -3.42800000E-05  -7.11000000E-05  -1.57240000E-04  +6.51200000E-05  +1.13430000E-04
   +1.54000000E-06  -1.42600000E-04  -4.04730000E-04  -3.52740000E-04  +1.72690000E-04
   +1.24040000E-04  -1.76250000E-04  -2.20000000E-07  -5.81800000E-05  +1.96500000E-04
   -1.77480000E-04  -5.89550000E-04  -4.05900000E-05  +2.36310000E-04  -6.43300000E-05
   -5.02000000E-06  -8.70000000E-07  +7.07000000E-06  +1.87900000E-05  +2.18400000E-05
   +2.12000000E-06  +8.52000000E-06  +2.97700000E-05  +2.24300000E-05  +4.45600000E-05
   -8.44600000E-05  +1.50000000E-06  -1.14100000E-05  +8.78000000E-06  +1.02600000E-05
   +3.12885810E-01  +2.01510000E-04  -3.26220000E-04  +3.92450000E-04  +1.06189000E-03
   +4.22280000E-04  +4.24900000E-05  -2.92960000E-04  +9.15300000E-05  -2.11800000E-05
   -1.13060000E-04  -1.90800000E-05  -2.66800000E-05  -1.22300000E-04  -1.52480000E-04
   -4.24200000E-05  -4.36000000E-05  +1.00400000E-05  +3.83700000E-05  +1.10421800E-02
   -5.10010000E-03  -2.43834000E-03  +6.61240800E-02  -6.51582900E-02  -1.18377200E-02
   +1.15360000E-04  +1.72460000E-04  +2.19200000E-05  -5.14440000E-04  -2.90100000E-04
   -2.42030000E-03  -4.47570000E-04  +1.57120000E-04  -3.66750000E-04  +6.90000000E-06
   +4.06100000E-05  +2.42300000E-05  -2.43130000E-04  +4.73800000E-05  -1.48200000E-05
   +6.06000000E-05  -1.94220000E-04  -1.45750000E-04  +8.20270000E-04  +2.76990000E-04
   -2.96800000E-05  +2.06660000E-04  -9.40300000E-05  -1.98000000E-06  +1.00410000E-04
   +4.22900000E-05  +4.01000000E-05  -6.24370000E-04  +7.66800000E-05  +8.67100000E-04
   +1.11200000E-05  -1.19120000E-04  +3.18800000E-05  -2.19600000E-05  -2.10000000E-05
   -2.43900000E-05  +1.51200000E-05  +1.69000000E-06  -4.58000000E-06  +3.85300000E-05
   +1.10500000E-05  -4.59000000E-05  -2.53500000E-05  +1.41830000E-04  -1.18270000E-04
   +1.21100000E-05  -1.11000000E-06  -1.43100000E-05  -7.34792100E-02  +6.76833500E-02
   -3.74280000E-04  -3.16210000E-04  +8.38800000E-05  +9.51380000E-04  +8.17270000E-04
   +7.07190000E-04  -2.57000000E-06  +9.82800000E-05  +2.33990000E-04  -1.94520000E-04
   -1.91050000E-04  -5.85700000E-05  -2.78830000E-04  +6.17000000E-06  -2.19490000E-04
   +4.33290000E-04  +1.13520000E-04  +7.22500000E-05  +2.94691000E-02  -8.55926000E-03
   -7.54496000E-03  +4.41774200E-02  -1.14609700E-02  -5.42207100E-02  +1.79850000E-04
   +2.05990000E-04  +3.22800000E-05  -1.41359000E-03  -1.68424000E-03  -5.53902000E-03
   -1.17546000E-03  -1.12840000E-04  -4.57480000E-04  +2.06590000E-04  -2.71510000E-04
   +1.25130000E-04  -2.79850000E-04  +1.05680000E-04  +8.34700000E-05  -1.03650000E-04
   -2.23330000E-04  -4.25000000E-04  +1.98535000E-03  -5.17090000E-04  -1.55000000E-06
   +2.38890000E-04  -8.15200000E-05  +1.22700000E-05  +1.22200000E-04  +4.30400000E-05
   +8.36300000E-05  +1.43559000E-03  -7.70690000E-04  +1.22750000E-03  -2.93600000E-05
   -1.82990000E-04  +1.36620000E-04  -2.80200000E-05  -1.08300000E-05  -4.30000000E-06
   +1.03800000E-05  -1.20000000E-05  +8.45000000E-06  -3.70000000E-05  +2.19600000E-05
   -1.07520000E-04  -2.04600000E-05  +2.19100000E-05  +3.93800000E-05  -1.16000000E-05
   +6.21000000E-06  +2.54000000E-06  -4.98368300E-02  +1.56280700E-02  +6.19270600E-02
   +1.56220000E-04  +5.84200000E-04  -2.62020000E-04  +7.32740000E-04  -3.53830000E-04
   -2.21330000E-04  +3.38670000E-04  -7.96700000E-05  +4.05000000E-06  +1.22140000E-04
   +1.23470000E-04  +1.09900000E-05  +3.27170000E-04  +7.04000000E-05  +1.81640000E-04
   -3.76300000E-04  -1.43290000E-04  -3.11900000E-05  +7.71250000E-04  +2.51046000E-03
   +3.02230000E-04  -1.37540690E-01  -1.24141540E-01  -1.88882800E-02  -1.96100000E-04
   -2.15810000E-04  -4.09200000E-05  +1.06780000E-04  +1.31540000E-04  -1.43580000E-04
   -1.05199000E-03  +9.49510000E-04  +1.55280000E-04  +3.48600000E-05  +3.04600000E-05
   +7.91600000E-05  -1.89950000E-04  +4.72000000E-06  -1.83000000E-06  +7.83500000E-05
   -1.30000000E-05  -2.92800000E-05  +6.91900000E-05  -7.25600000E-05  -1.39000000E-06
   +1.40720000E-04  -5.49700000E-05  -9.32000000E-06  +8.50800000E-05  +1.31700000E-05
   +2.10400000E-05  +1.01240000E-04  +4.76700000E-05  +1.08280000E-04  +2.06000000E-05
   -5.56700000E-05  +2.20000000E-05  +3.11300000E-05  +1.05500000E-05  +1.31800000E-05
   -1.10700000E-05  -7.86000000E-06  -1.78900000E-05  -6.54700000E-05  +3.11800000E-05
   +3.09300000E-05  +7.07100000E-05  -9.32800000E-05  -5.38900000E-05  -2.18300000E-05
   -1.01300000E-05  +1.70300000E-05  -1.59982700E-02  -2.52411300E-02  -3.76617000E-03
   +1.48381630E-01  -2.68930000E-04  -9.17800000E-05  -3.52350000E-04  -3.23000000E-05
   -8.45400000E-05  -2.81829000E-03  +7.99470000E-04  -1.54450000E-04  +1.32200000E-04
   -3.84190000E-04  -6.14940000E-04  +2.25260000E-04  -9.62400000E-05  +6.25280000E-04
   -3.24260000E-04  +2.84590000E-04  +2.26480000E-04  -1.98600000E-05  -6.35589000E-03
   -9.27032000E-03  -2.75000000E-05  -1.23175910E-01  -2.19191930E-01  -2.61559000E-02
   -3.09350000E-04  -4.28000000E-04  -3.52000000E-06  -5.31380000E-04  +2.84660000E-04
   +3.84800000E-04  -4.75040000E-04  +2.23200000E-05  -8.85100000E-04  +3.70870000E-04
   +8.14000000E-05  +3.97390000E-04  +2.83400000E-05  +3.59000000E-06  +1.10000000E-05
   -1.95410000E-04  +6.96200000E-05  +5.21700000E-05  +3.10140000E-04  -7.99500000E-05
   -2.77400000E-04  -1.59970000E-04  +1.30190000E-04  +1.36350000E-04  -5.13300000E-05
   +7.14700000E-05  +2.22200000E-05  +3.26230000E-04  +5.27290000E-04  +1.22625000E-03
   +6.48000000E-06  +2.13480000E-04  -6.74500000E-05  +5.50500000E-05  +3.68000000E-05
   +2.95300000E-05  -8.09600000E-05  -3.27200000E-05  +3.61100000E-05  +8.10000000E-07
   +3.35800000E-05  -9.71800000E-05  -1.38200000E-04  +1.65580000E-04  +1.92810000E-04
   -8.00000000E-07  -3.79300000E-05  +3.12000000E-06  +5.58447000E-03  +7.99012000E-03
   +1.62987000E-03  +1.36029250E-01  +2.36255040E-01  -2.59780000E-04  +1.93530000E-04
   +3.78000000E-06  +1.09442000E-03  -8.78360000E-04  -5.23120000E-03  -2.26770000E-04
   -7.67590000E-04  +3.67000000E-05  -2.63240000E-04  -1.06310000E-04  +4.28230000E-04
   +2.62940000E-04  +3.56140000E-04  -3.53600000E-05  -4.49670000E-04  -5.51600000E-05
   +1.49340000E-04  -1.87461600E-02  -2.42211000E-02  -4.30285000E-03  -1.86948700E-02
   -2.47675100E-02  -5.19044100E-02  -4.12660000E-04  -5.61710000E-04  -6.69000000E-05
   -4.99020000E-04  +4.99040000E-04  +9.55400000E-04  +4.90080000E-04  +9.82400000E-05
   +2.69090000E-04  +1.16970000E-04  -1.70900000E-05  -2.33000000E-06  +2.28130000E-04
   +9.63000000E-06  +1.43080000E-04  -2.17770000E-04  +5.72500000E-05  +2.95600000E-05
   +4.77900000E-05  +1.03580000E-04  -3.39330000E-04  -1.68190000E-04  +7.42100000E-05
   -5.02000000E-06  -3.35500000E-05  +9.00000000E-08  -4.83300000E-05  -6.49590000E-04
   -1.27765000E-03  +1.40063000E-03  -6.72000000E-06  +8.35000000E-05  -1.91500000E-05
   +6.52800000E-05  +6.30000000E-06  +2.74600000E-05  -8.38600000E-05  -5.49200000E-05
   -3.16000000E-06  +4.31200000E-05  -5.49100000E-05  -2.27140000E-04  +2.81510000E-04
   -2.01440000E-04  -1.23300000E-04  -2.23100000E-05  -4.94300000E-05  +1.18700000E-05
   +2.86203000E-03  +5.01858000E-03  -1.68050000E-04  +2.06896200E-02  +2.99792800E-02
   +5.59837500E-02  +5.39100000E-05  -3.36300000E-05  +1.39410000E-04  -1.30300000E-05
   +5.99190000E-04  -2.54910000E-04  -2.82900000E-04  -1.23020000E-04  -1.32840000E-04
   +1.33210000E-04  +1.69930000E-04  -2.60400000E-05  +8.10800000E-05  -1.65640000E-04
   +6.86400000E-05  -3.05730000E-04  -1.59820000E-04  +5.39500000E-05  -9.73480000E-04
   -2.11974000E-03  +1.73689000E-03  -6.53618400E-02  +4.94492700E-02  -4.69623000E-02
   +1.76900000E-05  +3.22700000E-05  +1.02500000E-05  +3.05930000E-04  -5.12670000E-04
   +2.86830000E-04  -2.45000000E-04  -9.41900000E-05  +6.48980000E-04  -1.12460000E-04
   +4.13300000E-05  -1.80770000E-04  -1.30020000E-04  +1.38300000E-05  +4.74500000E-05
   +1.11520000E-04  -5.21600000E-05  -3.19100000E-05  +1.47800000E-05  +6.27000000E-06
   +4.70500000E-05  +1.84180000E-04  -9.84900000E-05  -8.03800000E-05  +9.66300000E-05
   -1.80900000E-05  +5.25000000E-06  -4.55100000E-05  -7.31000000E-05  +3.94550000E-04
   +3.34000000E-05  -1.34420000E-04  -4.83000000E-06  -5.12000000E-06  -1.07600000E-05
   -1.23700000E-05  -2.30000000E-07  +4.55000000E-06  +6.65000000E-06  +5.17400000E-05
   +1.71000000E-06  +7.46800000E-05  +2.36520000E-04  +1.37200000E-05  -8.05100000E-05
   +1.14500000E-05  -1.13700000E-05  -1.63700000E-05  -6.99476000E-03  +2.15371400E-02
   -2.08736300E-02  +5.06917000E-03  -1.30896700E-02  +1.36275700E-02  +6.80122000E-02
   -3.24630000E-04  -2.49310000E-04  -6.08420000E-04  -2.48410000E-04  +9.09460000E-04
   -1.78560000E-04  +1.70200000E-05  -2.68600000E-05  +9.81900000E-05  +8.64000000E-06
   +8.05400000E-05  -8.87100000E-05  -4.30000000E-05  -6.93000000E-05  +5.31700000E-05
   +9.93000000E-05  -6.11200000E-05  +4.17000000E-05  -3.79647000E-03  +7.44567000E-03
   -7.82869000E-03  +4.95274700E-02  -1.81199510E-01  +1.25457410E-01  +1.14860000E-04
   +1.28530000E-04  +1.21100000E-05  +1.22180000E-04  +3.60880000E-04  +2.42170000E-04
   +8.07790000E-04  +3.61680000E-04  +3.00990000E-04  -2.17550000E-04  +6.67700000E-05
   -1.95870000E-04  +1.01710000E-04  -5.41100000E-05  +3.02500000E-05  +1.23900000E-05
   +1.39000000E-06  -1.81400000E-05  -2.86320000E-04  +3.32000000E-06  +1.15590000E-04
   -2.90100000E-05  -2.04300000E-05  -6.32000000E-05  +8.60000000E-06  -1.23000000E-06
   -5.79100000E-05  +2.70000000E-07  -1.03880000E-04  -1.64191000E-03  -2.08000000E-06
   -1.94200000E-05  -2.98000000E-05  -1.40500000E-05  -7.01000000E-06  -2.48000000E-06
   +1.37500000E-05  +5.03000000E-06  +6.12000000E-06  -6.40000000E-06  -3.64000000E-06
   -1.29700000E-05  +1.10840000E-04  -6.01020000E-04  -3.63650000E-04  +1.12900000E-05
   +6.55000000E-06  -2.49400000E-05  +9.34970000E-04  -5.79694000E-03  +4.52864000E-03
   +8.26364000E-03  -1.64991200E-02  +1.62032100E-02  -5.49508200E-02  +1.94682830E-01
   -4.42470000E-04  +5.82090000E-04  -4.96400000E-05  +1.30867000E-03  +1.20216000E-03
   +8.62080000E-04  -8.46400000E-04  -2.84100000E-04  -1.70990000E-04  +3.37540000E-04
   +5.69580000E-04  -5.70500000E-05  +3.82800000E-04  -3.77750000E-04  +3.14340000E-04
   -4.07350000E-04  -5.24500000E-04  +1.52770000E-04  -8.37451000E-03  +2.19566200E-02
   -1.91309800E-02  -4.67505100E-02  +1.23165980E-01  -1.63223970E-01  +5.74300000E-05
   +5.81800000E-05  -5.35000000E-06  -1.11251000E-03  +6.94880000E-04  +1.40271000E-03
   -9.51000000E-05  -5.21500000E-05  +1.08260000E-04  +3.70440000E-04  -2.98760000E-04
   +1.42100000E-04  +1.49930000E-04  +8.75100000E-05  +2.06390000E-04  -2.99150000E-04
   +1.14930000E-04  +4.09400000E-05  +7.98700000E-05  -5.34610000E-04  -2.39160000E-04
   -1.14570000E-04  +3.59100000E-05  +2.88800000E-05  -1.79400000E-05  +5.32000000E-06
   -1.38400000E-05  +6.29740000E-04  -3.72246000E-03  -5.88997000E-03  -7.72400000E-05
   -7.60100000E-05  +1.15480000E-04  -7.68000000E-06  -1.16600000E-05  -8.78000000E-06
   +1.11200000E-05  -5.23000000E-06  -2.44500000E-05  +1.51840000E-04  +2.37000000E-06
   +5.58700000E-05  +3.68330000E-04  -6.20870000E-04  -7.62300000E-05  -4.10200000E-05
   -1.58300000E-05  -4.60000000E-07  +1.50955000E-03  -4.98187000E-03  +4.20144000E-03
   +1.84055000E-03  -3.77627000E-03  +3.01300000E-03  +5.10313500E-02  -1.35070710E-01
   +1.79262860E-01  -1.13320000E-04  +3.47000000E-06  +5.96500000E-05  +1.97820000E-04
   -6.82000000E-05  +6.45250000E-04  +2.57710000E-04  -5.43240000E-04  +4.46050000E-04
   -1.13660000E-04  +1.31160000E-04  -1.85720000E-04  -1.42300000E-05  -5.16300000E-05
   +2.82400000E-05  +2.00600000E-05  +5.66200000E-05  -2.45300000E-05  -1.76276000E-03
   -2.95420000E-03  -6.70371000E-03  -4.03080000E-04  +1.10205000E-03  -6.23970000E-04
   +5.26400000E-05  +1.29840000E-04  -1.62100000E-05  +5.71600000E-04  -6.09370000E-04
   -4.19830000E-04  -4.32980000E-04  +9.39800000E-05  -5.35200000E-05  +7.01200000E-05
   -4.15910000E-04  -1.23580000E-04  -5.35400000E-05  +1.06440000E-04  +1.37700000E-04
   -2.94490000E-04  +1.58300000E-05  +1.84290000E-04  -3.39890000E-04  +1.84390000E-04
   -3.45130000E-04  +9.56500000E-05  -5.34700000E-05  +1.57000000E-06  +1.64180000E-04
   +9.03600000E-05  +1.16200000E-04  -4.76301200E-02  +9.93600000E-05  -1.36671000E-03
   -7.38000000E-06  -2.74640000E-04  +1.25410000E-04  -2.02100000E-05  -2.77200000E-05
   +1.63000000E-06  +7.55000000E-06  -3.44000000E-06  +1.70600000E-05  -9.97130000E-04
   -1.54390000E-04  +4.79880000E-04  -2.23700000E-05  +3.18900000E-05  -3.64000000E-05
   +7.68000000E-06  +6.24000000E-06  -1.86800000E-05  +3.47650000E-04  -6.84400000E-05
   -3.52680000E-04  +4.60000000E-05  +2.52030000E-04  +2.85600000E-04  +6.59910000E-04
   +3.68800000E-05  -4.69860000E-04  +4.82415100E-02  +2.41710000E-04  -1.72280000E-04
   -5.89100000E-05  -1.34100000E-05  +1.39386000E-03  -2.31640000E-04  -5.60170000E-04
   -6.78100000E-05  +1.07900000E-04  -5.46000000E-05  -2.06010000E-04  -6.21000000E-06
   -2.05490000E-04  +3.54600000E-05  -1.75860000E-04  +1.82450000E-04  +1.61930000E-04
   +6.05800000E-05  -2.22690000E-04  +7.87389000E-03  +2.36525700E-02  +1.27190000E-03
   -3.81051000E-03  +2.68541000E-03  +9.16700000E-05  +8.05000000E-05  +2.36300000E-05
   -9.29260000E-04  +7.15670000E-04  -2.43550000E-04  +3.18760000E-04  +1.82400000E-05
   -3.43300000E-05  -9.12900000E-05  +2.70580000E-04  +1.30180000E-04  +2.17300000E-05
   -1.12900000E-05  -1.68850000E-04  +3.37000000E-06  -1.34640000E-04  -2.11930000E-04
   +6.47200000E-04  -2.63630000E-04  +6.26550000E-04  -1.34310000E-04  +2.62900000E-05
   +3.65800000E-05  -9.70300000E-05  -6.32700000E-05  -4.08200000E-05  +2.30780000E-04
   -7.20404500E-02  -7.85250500E-02  -7.81000000E-06  +1.54960000E-04  -7.00800000E-05
   -1.46700000E-05  -2.67000000E-06  -5.02000000E-06  -1.55000000E-05  +1.08600000E-05
   +3.55700000E-05  -5.92160000E-04  -3.60410000E-04  +3.23560000E-04  -2.90200000E-05
   +4.26800000E-05  +2.07100000E-05  +3.60000000E-06  +2.17400000E-05  +1.74700000E-05
   -1.22360000E-04  -1.34480000E-04  -2.81200000E-05  +2.75420000E-04  +1.26200000E-04
   +1.12730000E-04  +1.54000000E-05  +6.60210000E-04  +1.57556000E-03  -6.50550000E-04
   +7.81209300E-02  -2.89000000E-06  +5.13830000E-04  +7.92600000E-05  -6.07130000E-04
   -1.22321000E-03  +6.28550000E-04  -5.00440000E-04  +2.09620000E-04  +1.07300000E-04
   +2.86080000E-04  +1.73290000E-04  +2.35680000E-04  +1.70430000E-04  -1.86840000E-04
   +9.89000000E-05  -1.83250000E-04  -1.98640000E-04  -4.03100000E-05  +3.79130000E-04
   -6.99767000E-03  -1.80290900E-02  -1.50375000E-03  +4.52855000E-03  -1.82488000E-03
   +8.55000000E-06  -2.15600000E-05  +6.93000000E-06  +1.35547000E-03  -1.24420000E-04
   +4.88040000E-04  -7.32980000E-04  +1.18340000E-04  -1.92160000E-04  +1.17050000E-04
   -6.42530000E-04  -5.17000000E-05  +1.08920000E-04  +2.06680000E-04  +7.02600000E-05
   -3.30530000E-04  +1.22600000E-04  +3.27730000E-04  +6.72200000E-05  -8.40930000E-04
   -3.98360000E-04  -6.04800000E-05  +3.14500000E-05  +5.85300000E-05  +1.77140000E-04
   +1.41430000E-04  +1.45830000E-04  -1.95834000E-03  -7.66182300E-02  -2.90834270E-01
   -8.36000000E-06  -2.64310000E-04  +1.34010000E-04  +1.02900000E-05  +1.65900000E-05
   -9.01000000E-06  +6.82000000E-06  +3.41900000E-05  +5.70000000E-07  +5.92900000E-04
   -1.64710000E-04  -6.24600000E-05  +6.30900000E-05  -8.74800000E-05  +1.28900000E-05
   +2.62600000E-05  -3.43000000E-06  -3.50700000E-05  -3.81200000E-05  -1.23800000E-05
   +3.40520000E-04  +3.03100000E-05  -1.40900000E-05  +3.81820000E-04  +1.91200000E-05
   -3.41460000E-04  -1.41587000E-03  +2.38405000E-03  +8.30205300E-02  +3.16772320E-01
   +4.61750000E-04  +4.89640000E-04  -1.06430000E-04  -2.92230000E-04  +1.25131000E-03
   -1.37662000E-03  -5.95700000E-04  +1.87560000E-04  -5.11390000E-04  +3.15560000E-04
   -1.68410000E-04  +2.08620000E-04  +4.79000000E-06  +1.46000000E-05  +1.18300000E-05
   -8.80700000E-05  +1.74200000E-05  +3.38500000E-05  +4.11566000E-03  +7.05675000E-03
   +1.21680000E-04  -4.39900000E-05  +1.66670000E-04  +2.07500000E-04  -5.46200000E-05
   -1.38770000E-04  +2.80200000E-05  +9.96330000E-04  +1.29844000E-03  +2.41410000E-04
   +1.58860000E-04  -9.89900000E-05  -1.51250000E-04  -1.92100000E-05  -1.19010000E-04
   -3.43700000E-05  -1.38080000E-04  +3.22700000E-05  +1.06620000E-04  -5.32200000E-05
   -5.97300000E-05  +5.55200000E-05  +1.75350000E-04  -3.50700000E-05  -8.05100000E-05
   +1.58470000E-04  -4.69600000E-05  -4.78000000E-05  +9.85300000E-05  +2.16600000E-05
   +4.52300000E-05  -1.75684230E-01  -1.35348290E-01  -1.83789400E-02  +1.92400000E-05
   -9.24900000E-05  +3.72300000E-05  +2.88100000E-05  +3.36300000E-05  -1.93000000E-06
   -8.01000000E-06  +4.95000000E-06  -2.00000000E-05  +3.36840000E-04  -3.11710000E-04
   +5.04050000E-04  +9.46400000E-05  -5.14500000E-05  +4.95000000E-06  +5.13000000E-06
   +3.00600000E-05  +2.88700000E-05  -1.11500000E-05  -1.17930000E-04  -9.86200000E-05
   +2.37380000E-04  +1.67000000E-05  +3.23730000E-04  +1.13600000E-04  +2.14450000E-04
   +1.22420000E-04  +6.99500000E-05  +1.37344000E-03  +3.94500000E-04  +1.87906400E-01
   -1.40306000E-03  -6.10580000E-04  -3.01040000E-04  +2.55981000E-03  -2.44729000E-03
   +3.68085000E-03  +6.88330000E-04  +1.08520000E-04  +3.89120000E-04  -1.14940000E-04
   +6.60500000E-05  -4.05000000E-06  +2.94690000E-04  +2.21160000E-04  +9.59400000E-05
   +1.08720000E-04  -4.35900000E-04  +9.81100000E-05  -1.67027000E-02  -1.98090700E-02
   -2.61526000E-03  -2.39960000E-04  +4.82750000E-04  -1.38351000E-03  -2.60940000E-04
   -2.93890000E-04  -5.59900000E-05  -1.42988000E-03  +8.22540000E-04  -1.40600000E-04
   +5.30290000E-04  +2.39850000E-04  -2.22400000E-05  +1.03670000E-04  +4.42500000E-05
   +1.86410000E-04  +3.16230000E-04  -9.31000000E-05  -4.78800000E-05  -1.54910000E-04
   +1.90900000E-05  -2.14400000E-05  +2.01420000E-04  -2.11820000E-04  -6.67250000E-04
   -3.10250000E-04  +1.90420000E-04  +6.75800000E-05  -5.18400000E-05  +1.37000000E-06
   -5.57200000E-05  -1.32997040E-01  -1.84753970E-01  -2.01715200E-02  +1.78000000E-05
   +2.22700000E-04  -1.05500000E-04  +3.51500000E-05  +2.26300000E-05  +1.87800000E-05
   -5.21000000E-05  -3.24700000E-05  -7.65000000E-06  +1.28100000E-04  +1.45390000E-04
   -2.27750000E-04  +4.43300000E-05  +9.03000000E-06  +9.43700000E-05  -7.43300000E-05
   -1.30780000E-04  -3.64600000E-05  +1.20140000E-04  +4.50500000E-05  +1.71700000E-05
   +1.37550000E-04  +6.21860000E-04  +5.88260000E-04  +3.27930000E-04  +2.26940000E-04
   -1.19520000E-04  -5.95727000E-03  -6.69914000E-03  -3.67020000E-04  +1.44914340E-01
   +2.02289050E-01  +8.78380000E-04  +9.64600000E-04  +4.00540000E-04  -1.80264000E-03
   +2.30163000E-03  -2.38184000E-03  -7.84240000E-04  +9.99900000E-05  -1.03800000E-04
   +1.60220000E-04  +9.81400000E-05  +1.73440000E-04  +2.49700000E-05  -1.33960000E-04
   +1.14000000E-05  -2.24200000E-04  +1.57080000E-04  -1.57550000E-04  +1.39037900E-02
   +1.49208700E-02  +4.18850000E-04  +1.09162000E-03  +9.28080000E-04  +9.94800000E-04
   +5.83700000E-05  +2.69200000E-05  +9.59000000E-06  +6.59070000E-04  -4.24250000E-04
   +3.90100000E-04  +1.30460000E-04  -1.60590000E-04  +1.39040000E-04  -7.90200000E-05
   +1.24480000E-04  -3.96000000E-05  -1.68700000E-04  -3.56800000E-05  -1.03480000E-04
   +3.95520000E-04  +8.25500000E-05  +7.59400000E-05  -4.16090000E-04  -5.73100000E-05
   -1.37720000E-04  +1.90840000E-04  -5.84900000E-05  -3.03400000E-05  +7.73000000E-06
   -6.50000000E-06  -1.45200000E-05  -1.92895800E-02  -2.13007100E-02  -5.00046700E-02
   +1.75000000E-06  +1.35700000E-05  -1.40000000E-05  -2.50000000E-07  +8.33000000E-06
   -1.94000000E-06  +4.55000000E-06  +2.66900000E-05  +1.89300000E-05  +2.41070000E-04
   -4.28780000E-04  -7.75100000E-05  -3.00000000E-08  -2.06500000E-05  +6.28000000E-06
   +7.83800000E-05  +6.23600000E-05  -2.89700000E-05  -3.12400000E-05  +1.06300000E-05
   -4.78700000E-05  -3.42840000E-04  -8.62000000E-05  -6.85780000E-04  -1.44640000E-04
   -2.81280000E-04  +2.01610000E-04  -2.20388200E-02  -2.18094200E-02  -1.81713000E-03
   +2.21233500E-02  +1.88780200E-02  +5.27660000E-02  +1.28770000E-04  +1.99980000E-04
   -5.59900000E-05  -1.94550000E-04  -2.95460000E-04  -1.51910000E-04  -8.53110000E-04
   -8.32710000E-04  -8.61030000E-04  +3.57270000E-04  -2.03280000E-04  +2.28160000E-04
   -1.20350000E-04  -7.07000000E-05  +4.24700000E-05  -1.14200000E-05  -4.28900000E-05
   +3.50000000E-07  -6.77621000E-03  +1.79528000E-03  +1.86088000E-03  +3.09930000E-04
   -4.23620000E-04  +7.40690000E-04  +4.52700000E-05  -2.03100000E-05  +3.40000000E-05
   -2.44700000E-05  +1.81482000E-03  -1.78971000E-03  +6.97750000E-04  +3.80480000E-04
   +3.30710000E-04  -1.08910000E-04  +3.15900000E-04  +3.56800000E-04  +5.51540000E-04
   -1.66230000E-04  -3.67580000E-04  -1.79170000E-04  -2.03900000E-05  -1.97000000E-05
   +1.23710000E-04  -2.07430000E-04  -5.44730000E-04  -6.24190000E-04  +2.87620000E-04
   +1.55110000E-04  -2.51120000E-04  -8.37800000E-05  -1.06940000E-04  -2.59772030E-01
   +9.10381400E-02  +5.46991900E-02  -1.13200000E-05  +4.02580000E-04  -1.93800000E-04
   +1.39000000E-06  +1.92300000E-05  +5.10000000E-07  +2.11800000E-05  +1.85200000E-05
   -2.57400000E-05  -3.88400000E-04  -2.01653000E-03  +2.09000000E-05  -7.88000000E-06
   -3.90000000E-05  +4.28800000E-05  +2.91000000E-06  +1.71000000E-05  +1.39300000E-05
   +4.26260000E-04  -1.72500000E-05  -5.89750000E-04  -1.95100000E-04  +8.01700000E-05
   -4.63500000E-05  +3.29720000E-04  -1.76080000E-04  -6.43400000E-05  +1.30983000E-03
   -1.44243000E-03  -7.16320000E-04  -1.83239800E-02  +9.25498000E-03  +5.50121000E-03
   +2.83591910E-01  -1.70520000E-04  -1.94990000E-04  +1.93000000E-04  +3.73400000E-04
   +9.12080000E-04  -3.71950000E-04  +8.45100000E-05  -8.92940000E-04  +3.88360000E-04
   -3.80010000E-04  +9.52300000E-05  -1.98780000E-04  -1.50030000E-04  +7.34000000E-06
   -1.20600000E-04  +1.43900000E-04  +2.18400000E-04  +7.30000000E-07  +2.20637200E-02
   -8.98656000E-03  -6.47030000E-03  +6.55000000E-05  +6.59220000E-04  -1.51630000E-03
   +9.44500000E-05  +1.98360000E-04  -7.28000000E-06  +7.46860000E-04  -2.59043000E-03
   +3.81602000E-03  -4.73800000E-05  -3.06440000E-04  -4.04850000E-04  +3.97740000E-04
   -3.20630000E-04  -4.11320000E-04  -3.26140000E-04  +1.83020000E-04  +5.92420000E-04
   -1.16480000E-04  +1.50500000E-05  +1.09900000E-05  +3.09080000E-04  +2.61400000E-05
   +8.47600000E-05  +5.10470000E-04  -2.32240000E-04  -1.89350000E-04  +3.00570000E-04
   +1.05930000E-04  +2.23800000E-05  +8.98346900E-02  -8.63527100E-02  -2.28252200E-02
   -5.83000000E-06  -4.61280000E-04  +2.17470000E-04  -2.99800000E-05  -4.63700000E-05
   -8.56000000E-06  +1.63400000E-05  -2.84500000E-05  +1.15000000E-06  -1.57941000E-03
   -1.80068000E-03  -1.03388000E-03  -4.17000000E-06  +9.80800000E-05  -1.03010000E-04
   +1.19300000E-05  +4.46000000E-06  -2.09900000E-05  -3.56040000E-04  +3.54000000E-04
   +5.72560000E-04  -1.41160000E-04  -3.10600000E-05  +1.19390000E-04  -2.98030000E-04
   -4.14600000E-05  -1.83650000E-04  +8.22539000E-03  -4.39524000E-03  -1.56936000E-03
   -2.07158900E-02  +1.01251200E-02  +6.11174000E-03  -9.88905900E-02  +9.29967500E-02
   -8.50200000E-05  -2.33700000E-05  -1.79530000E-04  +1.78030000E-04  -5.25590000E-04
   +3.75800000E-04  +6.81150000E-04  -4.32640000E-04  +5.26890000E-04  -1.17040000E-04
   +2.55310000E-04  -1.77860000E-04  +1.52730000E-04  -1.57400000E-05  +9.67200000E-05
   -7.81600000E-05  -3.74300000E-05  -3.52700000E-05  -1.87363900E-02  +7.28358000E-03
   +3.26864000E-03  -1.21914000E-03  +4.08000000E-04  +1.08931000E-03  -3.95300000E-05
   +2.32200000E-05  -3.71100000E-05  -1.08920000E-04  +2.70393000E-03  -2.28808000E-03
   -6.14950000E-04  +2.93740000E-04  +1.62140000E-04  -1.82210000E-04  -4.88870000E-04
   +2.34590000E-04  +2.67370000E-04  +4.73900000E-05  -1.90690000E-04  -3.73940000E-04
   -6.53200000E-05  +1.73160000E-04  +5.58600000E-05  -3.88650000E-04  -2.62210000E-04
   -3.44500000E-04  +1.70370000E-04  +1.10690000E-04  +2.70200000E-05  +4.94600000E-05
   +8.17000000E-05  +5.50703700E-02  -2.41170900E-02  -6.21975400E-02  +1.48400000E-05
   -2.96400000E-05  -2.90800000E-05  -3.53000000E-06  -1.62500000E-05  +7.71000000E-06
   -4.18000000E-06  -1.12900000E-05  +1.32900000E-05  -3.93020000E-04  -3.18690000E-04
   -6.59400000E-05  -3.80300000E-05  +1.35100000E-05  +6.51000000E-06  -1.76000000E-05
   +1.76000000E-06  +6.50000000E-06  +2.77610000E-04  +2.88430000E-04  -5.61970000E-04
   -4.40700000E-05  -1.30840000E-04  -5.50600000E-05  +1.70200000E-04  -1.71960000E-04
   +2.81610000E-04  +2.79930900E-02  -1.08117100E-02  -5.52133000E-03  -3.65905000E-03
   +1.78052000E-03  -2.51200000E-05  -5.89098400E-02  +2.35992900E-02  +6.50047100E-02
   -2.58600000E-04  -8.68800000E-05  +3.05550000E-04  -5.87800000E-04  +1.20630000E-04
   +7.06200000E-04  +2.35000000E-06  +7.06600000E-05  +1.07430000E-04  -9.90000000E-05
   -1.78080000E-04  -1.72200000E-05  -2.39940000E-04  -3.58700000E-05  -1.56240000E-04
   +2.64830000E-04  +1.91530000E-04  +7.33800000E-05  -4.06060000E-04  -5.89500000E-05
   +4.10470000E-04  +1.09420000E-04  -1.12340000E-04  -1.14800000E-05  +1.16190000E-04
   +1.33790000E-04  +2.99200000E-05  +6.46491000E-03  +6.89510000E-04  +2.67121000E-03
   +9.31920000E-04  +8.78710000E-04  +8.81320000E-04  +9.28400000E-05  +3.84500000E-04
   +4.95550000E-04  -2.22807000E-03  +3.63335000E-03  +2.75712000E-03  -1.83062800E-02
   -4.49248000E-03  -1.97084700E-02  -2.26007710E-01  -2.84549500E-02  -1.32933240E-01
   -1.64652000E-03  -3.27160000E-04  -9.35140000E-04  +5.18000000E-06  -1.99670000E-04
   -1.49570000E-04  -2.15860000E-04  +3.25120000E-04  +9.59000000E-05  -2.34000000E-05
   +2.88780000E-04  -1.43310000E-04  -1.40000000E-05  -1.42300000E-05  -1.30200000E-05
   +1.55800000E-05  -7.20000000E-07  +5.22000000E-06  +1.38300000E-05  +4.36600000E-05
   -3.95000000E-06  +2.43000000E-06  -1.67600000E-05  -6.95900000E-05  +4.69000000E-06
   +6.90000000E-06  -1.26500000E-05  +7.34800000E-05  -9.80000000E-06  -2.81500000E-05
   -7.22000000E-06  -8.37000000E-06  -3.37000000E-05  -8.28000000E-06  -1.70700000E-05
   +1.21200000E-05  -3.56500000E-05  +5.69250000E-04  +2.53810000E-04  +1.47400000E-05
   -2.36800000E-05  -3.35900000E-05  +1.35000000E-05  -5.18700000E-05  +1.47370000E-04
   +2.40965880E-01  +2.84700000E-05  +2.20550000E-04  -7.60400000E-05  +7.78100000E-05
   +2.61640000E-04  +1.02120000E-04  -8.65800000E-05  -7.74100000E-05  -9.30800000E-05
   +2.96100000E-05  +5.82400000E-05  -8.89000000E-06  +6.08800000E-05  -6.33100000E-05
   +8.12800000E-05  -9.68600000E-05  -2.17440000E-04  -1.07610000E-04  -7.97920000E-04
   -1.59841000E-03  +8.57440000E-04  -9.23300000E-05  -1.50770000E-04  +1.16140000E-04
   -2.55300000E-05  -5.93100000E-05  -1.69700000E-05  -1.12999500E-02  +3.35363000E-03
   -7.43033000E-03  +7.28090000E-04  +2.47229000E-03  -4.44456000E-03  +8.29310000E-04
   -4.85560000E-04  -3.74600000E-04  +1.95329000E-03  +7.39811000E-03  -4.32279000E-03
   +1.04921500E-02  +7.27279000E-03  +5.50943000E-03  -2.92742200E-02  -5.18673300E-02
   -3.19004900E-02  +6.05620000E-04  -1.07826000E-03  +9.03050000E-04  -3.30850000E-04
   -4.66510000E-04  +1.35790000E-04  +9.36800000E-05  -3.35070000E-04  -5.45680000E-04
   -5.42200000E-05  +5.13000000E-05  +5.08000000E-05  -1.18900000E-05  +7.66000000E-06
   +1.52500000E-05  -1.68900000E-05  +2.20000000E-07  +8.93000000E-06  +1.03790000E-04
   -3.71300000E-05  -8.30000000E-07  +2.95200000E-05  +2.71600000E-05  +6.44200000E-05
   -1.82800000E-05  -1.28300000E-05  +1.97100000E-05  +4.27800000E-05  +4.76600000E-05
   +2.48200000E-05  -9.20000000E-06  +2.21800000E-05  -2.40000000E-05  -2.21600000E-05
   -9.03000000E-06  +1.11160000E-04  +7.96890000E-04  -1.07830000E-03  +1.59320000E-04
   +4.63700000E-05  +7.85400000E-05  +1.56000000E-06  +4.59000000E-06  +1.43600000E-04
   +4.27120000E-04  +2.78477800E-02  +4.11294300E-02  -1.48950000E-04  +4.61340000E-04
   -1.37120000E-04  +4.70000000E-04  -2.19330000E-04  -5.69900000E-05  +3.35720000E-04
   +2.15230000E-04  +2.63530000E-04  +9.97700000E-05  -7.86400000E-05  +8.10200000E-05
   +3.12020000E-04  +2.43920000E-04  +1.32700000E-05  -1.36960000E-04  +5.04000000E-06
   -3.75700000E-05  -1.12271000E-03  +1.19878000E-03  -2.12290000E-04  +1.37640000E-04
   +8.83100000E-05  +2.46000000E-05  -2.91940000E-04  -3.45410000E-04  -2.70100000E-05
   -2.30235800E-02  -3.49830000E-03  -1.21991700E-02  +1.71932000E-03  -4.32347000E-03
   -3.95903000E-03  +5.36610000E-04  -5.90920000E-04  +4.03600000E-04  +2.50019000E-03
   -4.37773000E-03  +1.43969000E-03  +8.03417000E-03  -2.32020000E-04  +9.57564000E-03
   -1.32659030E-01  -3.13725900E-02  -1.60943710E-01  -2.05910000E-04  +8.65870000E-04
   +2.06890000E-04  +8.66700000E-05  +4.39430000E-04  +1.43700000E-04  +5.76100000E-05
   -8.65600000E-05  -2.73290000E-04  +3.26800000E-05  -7.46500000E-05  -1.89000000E-06
   +4.87300000E-05  +2.74900000E-05  +2.34600000E-05  -3.19700000E-05  -1.39000000E-06
   -7.92000000E-06  +2.05800000E-05  -2.05000000E-06  -2.33900000E-05  -1.40000000E-05
   -8.37600000E-05  +1.74300000E-05  -1.17000000E-06  -2.36800000E-05  -6.02000000E-06
   +8.43900000E-05  -4.39200000E-05  -5.23000000E-06  -1.96200000E-05  +1.26870000E-04
   +6.83200000E-05  -4.44000000E-05  -5.37600000E-05  +6.73000000E-05  +3.17500000E-05
   -1.34320000E-04  +4.40150000E-04  -2.64300000E-05  +1.67280000E-04  +1.12080000E-04
   +5.81400000E-05  -3.27400000E-05  +1.18320000E-04  +1.43797670E-01  +3.90650200E-02
   +1.65784320E-01  +8.44000000E-06  -1.16400000E-05  -1.52100000E-05  +1.39420000E-04
   +1.09990000E-04  -4.39000000E-06  +3.63000000E-06  -2.92400000E-05  -5.26000000E-06
   -1.24000000E-05  -3.90100000E-05  -1.59600000E-05  +2.23600000E-05  +4.16800000E-05
   +4.08000000E-06  -1.32200000E-05  -2.15000000E-05  -2.40100000E-05  +4.98580000E-04
   +5.46500000E-04  +1.10595000E-03  -4.36160000E-04  +7.53300000E-05  -4.02900000E-05
   -4.26800000E-05  -6.38000000E-05  -1.75100000E-05  -4.11237000E-03  +2.83043000E-03
   +4.98320000E-04  -1.82351000E-03  +1.76680000E-04  -4.10110000E-04  -3.70882000E-03
   -6.80520000E-04  -2.17144000E-03  +8.51701000E-03  -9.90994000E-03  -2.41417800E-02
   -6.18611500E-02  +1.67551600E-02  +2.83869200E-02  +1.13945000E-03  +1.20201200E-02
   +2.68096500E-02  +1.75159000E-03  +3.63220000E-04  +3.03793000E-03  -3.34640000E-04
   -5.39680000E-04  -1.72602000E-03  +4.55300000E-05  -8.56700000E-05  +7.60200000E-05
   -4.72700000E-05  -3.41000000E-05  +6.76600000E-05  -1.37000000E-06  +5.30000000E-06
   +1.26600000E-05  -1.61900000E-05  -3.52000000E-06  +4.05000000E-06  +2.20000000E-07
   +1.14600000E-05  +9.89000000E-06  -2.95000000E-06  +2.57200000E-05  +2.00000000E-08
   -8.15000000E-06  -6.94000000E-06  +1.15000000E-05  -3.48700000E-05  +5.30400000E-05
   +1.48830000E-04  +1.51100000E-05  -8.30000000E-07  -1.89400000E-05  +1.72700000E-05
   -1.45700000E-05  +3.44000000E-06  -2.31000000E-06  +1.43600000E-05  -5.01200000E-05
   -5.10000000E-07  -5.27000000E-06  -8.43000000E-06  -3.24800000E-05  +2.04800000E-05
   -3.32400000E-05  +7.38250000E-04  -1.13326000E-03  +3.38990000E-04  +5.91064500E-02
   -3.91500000E-05  +4.08300000E-05  +7.88000000E-06  -1.49940000E-04  -1.66480000E-04
   -2.28000000E-06  +1.83200000E-05  +2.61000000E-05  +2.96400000E-05  +7.42000000E-06
   -5.72000000E-06  +1.17400000E-05  -3.84900000E-05  -1.83300000E-05  -1.60300000E-05
   +2.50200000E-05  -1.24900000E-05  -1.74300000E-05  +1.84200000E-05  +2.96380000E-04
   -4.10660000E-04  +1.71060000E-04  -1.14930000E-04  +7.80000000E-07  +2.93600000E-05
   +2.24500000E-05  +2.71000000E-06  +2.98486000E-03  +7.49678000E-03  -1.18449000E-03
   -1.58043000E-03  -4.62470000E-04  +2.04870000E-04  +1.60158000E-03  +3.25569000E-03
   -3.67016000E-03  +2.47659000E-03  +4.03119000E-03  -1.89946000E-03  +1.54320100E-02
   -8.70768900E-02  -1.12168600E-01  +1.38312000E-03  -1.02353000E-03  -9.97065000E-03
   -7.89690000E-04  -2.89386000E-03  +1.22850000E-03  -1.62800000E-05  -4.49790000E-04
   +4.03340000E-04  +9.84600000E-05  -5.15300000E-05  +2.89500000E-05  +2.68600000E-05
   -3.69300000E-05  -1.11020000E-04  -9.03000000E-06  -3.16000000E-06  +2.00000000E-08
   +7.18000000E-06  +2.88000000E-06  +1.61000000E-06  +4.16000000E-06  -1.02500000E-05
   -5.55000000E-06  +2.55000000E-06  -1.53000000E-06  +2.35800000E-05  -6.24000000E-06
   -8.50000000E-07  +9.99000000E-06  +6.35000000E-06  -8.59000000E-05  -3.48000000E-05
   -1.45300000E-05  -1.23600000E-05  -2.37900000E-05  +2.20000000E-06  +2.05000000E-06
   +3.97400000E-05  +2.01000000E-05  -1.40000000E-06  -4.28300000E-05  -1.01500000E-05
   -1.50900000E-05  -1.97300000E-05  +3.62000000E-06  -4.43300000E-05  -1.74500000E-05
   -7.97510000E-04  -4.47488000E-03  +2.55334000E-03  -2.03016600E-02  +8.22074800E-02
   +1.19500000E-05  -1.05300000E-05  +2.37000000E-06  +2.11900000E-05  -4.14300000E-05
   -1.19800000E-05  -1.93400000E-05  +1.21500000E-05  -3.22900000E-05  +6.02000000E-06
   +4.67200000E-05  -3.12000000E-06  -1.44800000E-05  -5.81100000E-05  +1.57300000E-05
   +4.90000000E-06  +1.67400000E-05  +2.84400000E-05  -4.16190000E-04  -3.07690000E-04
   -1.98180000E-04  +1.52630000E-04  +1.07600000E-05  +5.03000000E-05  +4.56300000E-05
   +7.23700000E-05  +1.09000000E-05  +1.08751000E-03  -2.41232000E-03  +2.56605000E-03
   -2.83790000E-04  +7.35970000E-04  +4.81820000E-04  -4.10494000E-03  -1.58726000E-03
   +1.01503000E-03  +7.84895000E-03  -9.44279000E-03  -1.50666700E-02  +2.86561900E-02
   -1.13704240E-01  -2.87560880E-01  -1.71346000E-03  -2.35612000E-03  -3.21724000E-03
   -3.60510000E-04  +2.87400000E-03  +2.33145000E-03  -2.90750000E-04  -8.93900000E-05
   -1.45123000E-03  +3.85600000E-05  +3.08700000E-05  -8.25800000E-05  -1.44200000E-04
   +6.71000000E-04  +2.70900000E-05  -2.00000000E-06  -7.10000000E-06  -8.10000000E-06
   +8.86000000E-06  +4.74000000E-06  +6.90000000E-07  -7.01000000E-06  -2.94000000E-06
   -4.72000000E-06  -1.75000000E-06  -2.31900000E-05  -3.33000000E-06  +1.02400000E-05
   +7.55000000E-06  -1.77600000E-05  +1.40100000E-05  +4.49000000E-06  -5.49800000E-05
   -5.29000000E-06  +1.09800000E-05  +9.18000000E-06  -1.70900000E-05  +2.26000000E-06
   -2.14400000E-05  -1.02100000E-05  +1.44400000E-05  +2.36000000E-05  -3.26000000E-06
   +8.69000000E-06  +9.90000000E-07  +3.17000000E-05  -2.92300000E-05  +2.91100000E-05
   +7.48760000E-04  +2.06073000E-03  -1.42690000E-04  -3.17391300E-02  +1.24572270E-01
   +3.01460410E-01  -4.34030000E-04  +7.65700000E-05  -3.50670000E-04  -1.23680000E-04
   +2.71330000E-04  +1.95730000E-04  +2.53900000E-05  -4.06900000E-05  +1.47130000E-04
   +4.06400000E-05  -1.17820000E-04  +2.59600000E-05  -1.03530000E-04  +8.98400000E-05
   -8.23200000E-05  +1.85000000E-04  -8.66100000E-05  +1.34920000E-04  +1.96950000E-04
   -1.43110000E-04  -2.64710000E-04  -1.34060000E-04  -8.10000000E-05  -8.83200000E-05
   +2.08500000E-05  -2.94800000E-05  +3.00000000E-05  -6.97681000E-03  -1.52684000E-03
   -1.23947200E-02  +5.09639000E-03  +1.09919000E-03  +2.32896000E-03  -9.76756000E-03
   +6.30419000E-03  +3.60200000E-03  -5.10820000E-03  -4.59449000E-03  -2.68997000E-03
   +7.04902000E-03  +6.73200000E-04  +9.10620000E-04  -6.21858000E-03  +5.98469000E-03
   +6.11203000E-03  -2.45381000E-03  +6.25210000E-04  +3.02569000E-03  -1.63731000E-02
   -1.33711900E-02  -6.76571000E-03  -3.96660000E-04  +6.45200000E-05  +2.47510000E-04
   -2.43497400E-02  -9.95115000E-03  +3.07238000E-03  +6.74000000E-06  -2.65000000E-06
   -1.93000000E-06  +6.73000000E-06  -1.42300000E-05  -9.96000000E-06  +4.01800000E-05
   -9.10000000E-07  +2.78100000E-05  -1.11000000E-04  -6.56900000E-05  +1.94400000E-04
   -1.77500000E-05  -2.15500000E-05  -3.01000000E-06  +5.43500000E-05  +1.71900000E-05
   +8.36600000E-05  +8.04000000E-06  +8.63200000E-05  +3.23000000E-05  -5.23300000E-05
   -2.93900000E-05  +1.41260000E-04  +1.00080000E-04  -6.29900000E-05  +1.26670000E-04
   +1.51600000E-05  -3.02600000E-05  -2.54900000E-05  -1.01310000E-04  +1.49180000E-04
   -2.30000000E-06  -9.26000000E-05  -1.92220000E-04  +3.55150000E-04  -6.40100000E-05
   -4.70280000E-04  +1.75890000E-04  +6.35806300E-02  -1.24495000E-03  -9.76900000E-05
   -5.82960000E-04  +2.90420000E-04  +1.28915000E-03  +6.86600000E-04  +2.30320000E-04
   -3.40690000E-04  +6.07450000E-04  +9.92300000E-05  -7.21250000E-04  +2.80180000E-04
   +2.27340000E-04  +1.02202000E-03  -3.42670000E-04  +8.01300000E-05  +1.12640000E-04
   +1.77500000E-05  +1.75564000E-03  +6.26610000E-04  -1.55177000E-03  -9.62810000E-04
   +1.73160000E-04  -1.22500000E-04  -7.25600000E-04  -1.15564000E-03  +3.15800000E-05
   -8.61068000E-03  -9.62026000E-03  -2.40356400E-02  +3.78197800E-02  -2.54363600E-02
   +9.89591000E-03  -1.18426900E-02  +4.29673500E-02  -3.14032800E-02  -4.00737700E-02
   +6.16200000E-05  +3.35265200E-02  +1.28741600E-02  +1.56203000E-03  +5.97122000E-03
   -1.60055200E-02  +8.14142000E-03  +1.11846700E-02  +3.80044600E-02  -1.67164900E-02
   -7.11077000E-03  -1.01736900E-02  -1.74495200E-02  +3.46820000E-03  -1.32274000E-03
   +1.77730000E-04  +3.90190000E-04  -9.37333000E-03  +2.40166300E-02  -1.66084300E-02
   +1.40550000E-04  +1.14500000E-04  +1.53600000E-05  -6.86500000E-05  -1.03760000E-04
   -4.95400000E-05  +2.71110000E-04  +5.90000000E-06  +9.09400000E-05  -2.70240000E-04
   +8.65830000E-04  -2.63600000E-05  -2.97360000E-04  -2.65290000E-04  +7.57500000E-05
   -3.04060000E-04  +1.34530000E-04  +2.68450000E-04  +5.12000000E-05  -3.22710000E-04
   -1.17100000E-04  +1.36660000E-04  +3.33600000E-05  +1.52570000E-04  +3.94560000E-04
   -2.18050000E-04  +4.24070000E-04  +1.12180000E-04  -2.93670000E-04  -1.84800000E-05
   -5.22190000E-04  +6.22480000E-04  +9.03000000E-05  -3.18080000E-04  -1.36870000E-04
   +1.63190000E-04  +1.12030000E-04  +5.46000000E-05  -8.41560000E-04  -1.17490000E-03
   -1.26643700E-02  +7.01320000E-04  +7.55000000E-05  +2.37130000E-04  +2.12030000E-04
   -8.13060000E-04  -4.50970000E-04  -8.99800000E-05  +2.24980000E-04  -3.18780000E-04
   -8.05000000E-06  +4.23650000E-04  -9.55300000E-05  -1.09800000E-04  -5.62960000E-04
   +1.92900000E-04  -5.39500000E-05  -8.23800000E-05  -4.67300000E-05  -9.67710000E-04
   +3.92290000E-04  +7.48660000E-04  +4.95190000E-04  -4.15000000E-05  +2.37630000E-04
   +3.94010000E-04  +6.06330000E-04  -1.21200000E-05  +7.05963000E-03  +5.16975000E-03
   +1.11253200E-02  -1.51033500E-02  +4.53643000E-03  -3.26062000E-03  +1.07946800E-02
   -8.01672000E-03  -5.89525000E-03  +1.73893700E-02  +2.87182000E-03  -7.08223000E-03
   -1.47892300E-02  -1.06860000E-04  -2.78597000E-03  +6.15973000E-03  -5.38549000E-03
   -9.30895000E-03  -7.14917000E-03  +3.77812000E-03  -4.48350000E-04  -1.44769200E-02
   -6.55417000E-03  -5.29919000E-03  +8.38160000E-04  -6.87600000E-05  -5.27560000E-04
   +4.48176000E-03  -2.99499900E-02  -3.23537600E-02  -7.88700000E-05  -5.83900000E-05
   -7.96000000E-06  +4.10800000E-05  +6.31200000E-05  +3.60900000E-05  -1.12990000E-04
   -1.95400000E-05  -5.95800000E-05  +1.42340000E-04  -3.54540000E-04  +1.49290000E-04
   +1.31620000E-04  +1.25530000E-04  -2.97400000E-05  +1.09160000E-04  -7.53200000E-05
   -1.97620000E-04  -4.26500000E-05  +5.87700000E-05  +3.43500000E-05  -2.24500000E-05
   +3.87400000E-05  -1.33610000E-04  -1.72240000E-04  +1.08670000E-04  -1.41620000E-04
   -6.68500000E-05  +1.61810000E-04  +4.24000000E-06  +3.36110000E-04  -3.61850000E-04
   +9.26200000E-05  +3.64980000E-04  +1.60400000E-05  -2.99200000E-05  +1.85870000E-04
   +1.91350000E-04  +4.18650000E-04  +8.90764000E-03  +2.86808500E-02  +4.98829000E-02
   -4.75700000E-05  +9.19100000E-05  -1.45500000E-05  -1.09660000E-04  -1.05710000E-04
   +2.13130000E-04  -4.92000000E-06  +4.19800000E-05  +3.01000000E-05  +2.53700000E-05
   +5.34600000E-05  -2.18600000E-05  -5.13400000E-05  -9.73600000E-05  -8.09000000E-06
   +1.97000000E-05  -2.34000000E-06  +4.98900000E-05  +8.08950000E-04  -9.80180000E-04
   +5.57070000E-04  -1.22208000E-03  +3.38700000E-05  -4.34690000E-04  +8.75400000E-05
   +1.13670000E-04  +1.55700000E-05  +9.31822000E-03  -1.10406600E-02  -2.03420500E-02
   -5.91405400E-02  +1.62841400E-02  +1.92165100E-02  +1.54569000E-03  +1.25938300E-02
   +2.68538600E-02  -4.01731000E-03  +2.21404000E-03  -2.41988000E-03  -6.74410000E-04
   -4.23500000E-05  -1.28300000E-05  -3.80074000E-03  +6.07220000E-04  -3.75806000E-03
   -1.15853000E-03  +7.00010000E-04  +1.83402000E-03  +2.64874000E-03  -1.45069000E-03
   -4.17020000E-04  +1.82980000E-04  +1.07590000E-04  +6.57300000E-05  -1.64100000E-05
   -1.18460000E-04  -1.12300000E-05  -1.16300000E-05  -1.47000000E-05  -1.10200000E-05
   +1.89600000E-05  +4.38000000E-06  -1.62000000E-06  -9.08000000E-06  -1.36700000E-05
   -1.05500000E-05  +7.02900000E-05  -4.58400000E-05  -3.03300000E-05  +5.75000000E-06
   +8.54000000E-06  -7.95000000E-06  +3.28960000E-04  -2.38000000E-06  +4.45000000E-05
   -1.25165000E-03  +1.10240000E-03  +3.59300000E-04  -9.36810000E-04  -2.21090000E-04
   +5.32670000E-04  +5.95500000E-05  -4.76400000E-05  +1.34370000E-04  +2.75600000E-05
   -3.77000000E-06  -4.62000000E-05  -2.48700000E-05  -3.73700000E-05  -9.43000000E-06
   +3.28740000E-04  -4.77390000E-04  -1.27534000E-03  +4.35500000E-05  -1.90250000E-04
   +9.49200000E-05  +1.88070000E-04  +1.79190000E-04  +1.03400000E-05  +5.66882300E-02
   -1.76910000E-04  +1.28110000E-04  -1.53300000E-04  -6.50180000E-04  +3.49710000E-04
   -7.22800000E-05  -5.37200000E-05  -1.64050000E-04  +8.94500000E-05  +1.29400000E-05
   -2.32100000E-05  -2.12600000E-05  -2.64000000E-05  +3.36700000E-05  -1.59700000E-05
   +4.21400000E-05  -4.31000000E-05  +5.88600000E-05  -3.74850000E-04  -4.15933000E-03
   +1.65043000E-03  +1.01877000E-03  +6.36590000E-04  -4.65900000E-05  +1.94000000E-06
   -2.43400000E-05  +1.28700000E-05  +9.07690000E-04  +4.72781000E-03  -3.28370000E-03
   +1.17426900E-02  -1.00480030E-01  -1.19543380E-01  +3.15360000E-03  -3.16751000E-03
   -1.40612900E-02  +2.21542000E-03  +4.25746000E-03  +1.96091000E-03  -4.86180000E-04
   -2.46540000E-04  +3.59140000E-04  +7.09020000E-04  +5.97414000E-03  -3.30287000E-03
   +9.02450000E-04  -6.67870000E-04  -1.18082000E-03  -5.87760000E-04  -1.33940000E-03
   +1.73818000E-03  +1.01170000E-03  -1.48800000E-04  -1.54990000E-04  -1.46940000E-04
   -2.83940000E-04  +6.30900000E-04  +3.13000000E-06  -1.76000000E-06  -1.01000000E-06
   -3.14000000E-06  -1.49200000E-05  -4.28000000E-06  +6.95000000E-06  -2.86000000E-06
   +8.69000000E-06  +4.46700000E-05  -9.51900000E-05  -1.85100000E-05  -3.87000000E-06
   -1.19600000E-05  -1.19000000E-05  +8.12200000E-05  -3.30410000E-04  +3.11380000E-04
   +1.35834000E-03  -5.30500000E-04  -2.68300000E-04  -4.94640000E-04  -2.53460000E-04
   +3.38080000E-04  -1.92500000E-05  -1.70300000E-05  +3.91000000E-06  -2.48000000E-06
   -3.18700000E-05  +6.52000000E-06  +2.50800000E-05  -2.14970000E-04  +1.94470000E-04
   +9.10900000E-05  -3.64850000E-04  +7.32100000E-05  -1.49320000E-04  -6.23700000E-04
   +1.53650000E-04  -1.13619000E-03  +1.82438000E-03  -5.58540000E-04  -1.92080100E-02
   +9.57881300E-02  -2.97000000E-06  -1.93300000E-05  +4.37000000E-05  +2.67980000E-04
   -2.99000000E-05  +3.62300000E-05  +1.02000000E-05  +4.68900000E-05  -1.48100000E-05
   -3.10000000E-06  +2.21000000E-05  +1.11800000E-05  +3.01000000E-06  -1.96700000E-05
   -4.45000000E-06  +8.65000000E-06  +6.37000000E-06  +1.45300000E-05  +1.76320000E-03
   +1.33013000E-03  -1.59913000E-03  +1.49026000E-03  -5.72010000E-04  +2.12520000E-04
   +1.67200000E-05  +2.75900000E-05  +3.50000000E-06  +3.02091000E-03  -8.79564000E-03
   -1.15389700E-02  +1.95512900E-02  -1.21608390E-01  -2.79417650E-01  -2.37551000E-03
   -3.59527000E-03  -4.30686000E-03  -1.93090000E-04  -1.78710000E-03  +2.07143000E-03
   -1.11260000E-04  +5.16750000E-04  +4.26060000E-04  -4.17481000E-03  -2.80559000E-03
   +5.68590000E-04  +3.65440000E-04  -7.14600000E-05  -9.93700000E-05  +1.23620000E-04
   +1.53856000E-03  +5.80460000E-04  -5.90860000E-04  -1.56300000E-05  +1.01810000E-04
   -4.95500000E-05  -3.59320000E-04  +1.96100000E-04  -3.10000000E-07  -1.54000000E-06
   -4.64000000E-06  +4.14000000E-06  +2.82000000E-06  -2.70000000E-07  +3.85000000E-06
   -4.08000000E-06  -1.11200000E-05  -1.79000000E-05  -2.99700000E-05  -3.30400000E-05
   +1.79000000E-06  +2.53000000E-06  -1.92000000E-06  +3.86350000E-04  +2.70290000E-04
   +3.52600000E-04  +4.25040000E-04  +3.83190000E-04  +2.43690000E-04  +4.97340000E-04
   -1.53490000E-04  +3.77700000E-05  +5.27800000E-05  +1.83000000E-06  +5.42000000E-05
   -2.95500000E-05  +6.39300000E-05  -5.27500000E-05  -7.18700000E-05  +1.51780000E-04
   -8.51000000E-05  +2.57780000E-04  -2.84780000E-04  -7.79480000E-04  +1.28790000E-04
   +2.76400000E-04  -1.92970000E-04  +8.03220000E-04  -8.13800000E-05  -4.43400000E-04
   -2.15331400E-02  +1.35468480E-01  +2.93808070E-01  -1.14300000E-05  +3.58000000E-06
   -4.30800000E-05  +4.32200000E-05  -5.65000000E-05  -1.91600000E-05  -2.10900000E-05
   +6.35000000E-06  -2.44000000E-05  +1.74300000E-05  +5.34500000E-05  -1.15000000E-05
   -1.02790000E-04  -1.27900000E-04  -1.27000000E-06  +4.37400000E-05  -3.05800000E-05
   +1.67000000E-05  -1.47650000E-04  +4.15100000E-05  +1.99700000E-05  +6.23000000E-05
   +1.27000000E-06  +3.15000000E-06  +1.21190000E-04  +1.35750000E-04  +1.02800000E-05
   +4.28000000E-06  -2.01000000E-06  -1.37730000E-04  -2.35200000E-04  -1.45410000E-04
   +3.14700000E-05  +2.41450000E-04  +5.09630000E-04  +3.52870000E-04  -4.50964000E-03
   +7.29065000E-03  -7.79000000E-06  -4.16370000E-04  -3.59030000E-04  +4.67910000E-04
   -4.10970000E-04  -1.40070000E-04  +2.57610000E-04  -8.54685000E-03  -5.18392000E-03
   +6.02990000E-04  -5.23100000E-04  +2.11300000E-05  -6.47550000E-04  +6.40200000E-05
   +1.73000000E-06  -2.44000000E-05  -1.96960000E-04  +9.63210000E-04  -6.99070000E-04
   -2.61300000E-05  -1.86100000E-05  -3.03000000E-06  +1.41100000E-05  +6.74000000E-06
   +9.68000000E-06  -7.75000000E-06  -5.32000000E-06  +2.61000000E-06  -1.55300000E-05
   -1.10000000E-05  +4.53900000E-05  -9.64000000E-06  +2.39000000E-06  +3.71000000E-06
   +3.00700000E-05  -1.43900000E-05  -1.32900000E-05  -1.31700000E-05  +1.09000000E-05
   +1.04400000E-05  -1.54100000E-05  +2.50000000E-07  +1.26600000E-05  -1.71700000E-05
   +1.27900000E-05  -1.09300000E-05  -1.48900000E-05  +1.65600000E-05  -5.95000000E-06
   +4.12900000E-05  -2.98900000E-05  +2.49000000E-06  +1.84200000E-05  +7.82100000E-05
   -1.25000000E-05  -4.93000000E-06  +1.77800000E-04  -3.03910000E-04  -5.16490000E-04
   +1.23136000E-03  +4.65880000E-04  +9.04000000E-06  -1.17300000E-05  -9.26000000E-06
   +4.48662300E-02  -6.00000000E-05  -7.06500000E-05  -2.32000000E-05  -9.99300000E-05
   +5.56210000E-04  +2.21390000E-04  +1.29800000E-05  -1.81250000E-04  +1.33300000E-04
   -2.99400000E-05  -2.89670000E-04  +4.41300000E-05  +3.45770000E-04  +5.74360000E-04
   -3.03700000E-05  -1.74510000E-04  +5.21400000E-05  -1.48200000E-04  +9.80500000E-04
   -2.70980000E-04  -3.80830000E-04  -3.50770000E-04  -3.34000000E-06  -1.18080000E-04
   -4.97900000E-04  -6.82130000E-04  -6.33700000E-05  +1.82970000E-04  +2.38524000E-03
   +4.34883000E-03  -2.79359000E-03  +1.73131000E-03  -1.71349000E-03  -6.23896000E-03
   -1.05382500E-02  +8.58568000E-03  +3.97674800E-02  -7.82543000E-03  -9.90567000E-03
   -1.05053400E-02  -3.65120000E-04  -1.78283000E-03  +3.39416000E-03  -2.30763000E-03
   -3.40232000E-03  -2.88175200E-02  +2.12386400E-02  +9.96520000E-04  +2.23647000E-03
   +1.66932000E-03  +1.85855000E-03  -4.95960000E-04  -8.97000000E-06  +2.69610000E-04
   +8.16356000E-03  -1.72314300E-02  -4.47764000E-03  +7.60200000E-05  +8.29500000E-05
   +3.34000000E-05  -6.72100000E-05  -4.12900000E-05  -2.64500000E-05  +7.11700000E-05
   +2.60600000E-05  +3.55800000E-05  +4.53700000E-05  +2.66900000E-04  -1.13050000E-04
   -5.78400000E-05  -6.27400000E-05  +6.16300000E-05  -1.58880000E-04  +8.70500000E-05
   +9.40800000E-05  +4.76500000E-05  -1.20890000E-04  -8.22700000E-05  +8.99200000E-05
   +3.72000000E-06  -2.51700000E-05  +7.12000000E-05  -3.59200000E-05  -1.23700000E-05
   +5.16400000E-05  -1.68820000E-04  +4.75100000E-05  -2.57140000E-04  +2.00690000E-04
   -1.08140000E-04  -2.28210000E-04  +1.10940000E-04  -2.52970000E-04  +3.55100000E-05
   +3.98980000E-04  -4.93040000E-04  -4.40140000E-04  +1.77199800E-02  -4.82043000E-03
   -2.17880000E-04  +2.29410000E-04  +1.37180000E-04  +5.17313700E-02  +2.97269000E-01
   +4.05100000E-05  +1.01900000E-05  +3.42500000E-05  -3.51000000E-06  -1.07240000E-04
   -5.41100000E-05  +8.50000000E-06  +4.76000000E-05  -2.74600000E-05  -2.63000000E-06
   +4.37800000E-05  -1.51300000E-05  -4.63700000E-05  -8.87000000E-05  +9.69000000E-06
   +2.61500000E-05  -4.45000000E-06  +2.23800000E-05  -2.08500000E-04  +4.89900000E-05
   +4.24000000E-05  +7.52700000E-05  -7.33000000E-06  +3.30600000E-05  +7.50500000E-05
   +1.10560000E-04  +3.10000000E-06  -1.12360000E-04  -6.66240000E-04  -1.17169000E-03
   +9.96720000E-04  -3.32320000E-04  +1.43740000E-04  +2.96778000E-03  +3.03514000E-03
   -2.17756000E-03  -8.55745000E-03  -4.93850000E-04  +9.65230000E-04  +2.15021000E-03
   -4.39940000E-04  +1.59837000E-03  -1.02382000E-03  +4.27360000E-04  +6.80020000E-04
   +6.91761000E-03  -6.39038000E-03  -7.66887000E-03  -7.23550000E-04  +3.48590000E-04
   -9.34040000E-04  +9.21800000E-05  +5.77000000E-06  -4.80800000E-05  -1.97869000E-03
   +2.60008000E-03  +9.64970000E-04  -1.23700000E-05  -1.20600000E-05  -1.33000000E-06
   +7.63000000E-06  +8.74000000E-06  +5.14000000E-06  -1.79800000E-05  -1.23000000E-06
   -7.29000000E-06  -2.17000000E-06  -6.87500000E-05  +1.16400000E-05  +1.93700000E-05
   +1.77900000E-05  -1.05800000E-05  +2.63500000E-05  -1.99100000E-05  -2.34600000E-05
   -8.77000000E-06  +1.99000000E-05  +1.69000000E-05  -1.41000000E-05  +2.77000000E-06
   -3.50000000E-07  -1.58500000E-05  +3.70000000E-06  +9.00000000E-08  -8.55000000E-06
   +3.41400000E-05  -6.26000000E-06  +4.79700000E-05  -3.64400000E-05  +2.15400000E-05
   +4.36000000E-05  +4.02900000E-05  +3.38200000E-05  -1.83520000E-04  -8.52100000E-05
   -1.31190000E-04  +1.14648000E-03  -5.74850000E-03  +1.00561000E-03  +1.00010000E-04
   -7.31100000E-05  -4.29700000E-05  -2.25797300E-02  -1.13061540E-01  +1.23962840E-01
   +1.52000000E-06  +6.78000000E-06  -3.61700000E-05  +6.09600000E-05  -5.85200000E-05
   -2.76800000E-05  -3.72000000E-05  -8.27000000E-06  -4.29600000E-05  +1.68900000E-05
   +7.48700000E-05  -1.58400000E-05  -9.17600000E-05  -1.44920000E-04  +1.09700000E-05
   +3.04200000E-05  -3.37700000E-05  +1.54100000E-05  -1.22340000E-04  +1.12660000E-04
   -2.22130000E-04  +7.69400000E-05  -2.04400000E-05  -3.11100000E-05  +1.26490000E-04
   +1.48190000E-04  +1.09500000E-05  -5.95100000E-04  +1.15320000E-03  +1.51105000E-03
   -2.80157000E-03  -2.32780000E-03  -3.40928000E-03  -4.89091400E-02  +6.75165000E-03
   +1.39477700E-02  +2.35534000E-03  +5.38870000E-04  -1.32846000E-03  -2.28367000E-03
   +5.82330000E-04  +8.54700000E-04  +6.75420000E-04  -4.15980000E-04  -4.81280000E-04
   -3.30451000E-03  +4.17540000E-04  +1.78292000E-03  -2.97108590E-01  +8.01157700E-02
   +1.73976190E-01  -2.02100000E-05  +1.01100000E-05  +1.30100000E-05  +3.86400000E-05
   +6.51320000E-04  +1.13630000E-04  -2.65800000E-05  -1.94300000E-05  -4.34000000E-06
   +1.42400000E-05  +7.55000000E-06  +1.02400000E-05  -9.55000000E-06  -4.45000000E-06
   +1.88000000E-06  -1.36200000E-05  -2.01600000E-05  +3.52000000E-05  -6.60000000E-06
   +4.36000000E-06  -7.50000000E-07  +3.91100000E-05  -7.93000000E-06  -2.91000000E-06
   -1.48000000E-05  +3.61100000E-05  +9.11000000E-06  -2.38500000E-05  -1.55600000E-05
   +1.99000000E-05  -2.29800000E-05  +1.34700000E-05  -1.87600000E-05  -1.42700000E-05
   +2.50300000E-05  -5.12000000E-06  +3.47500000E-05  -7.11000000E-06  -2.14100000E-05
   +5.49000000E-06  +5.72400000E-05  -1.36700000E-05  +4.36970000E-04  -3.53000000E-05
   +2.72740000E-04  -8.31020000E-04  +2.36560000E-04  +1.33830000E-04  +1.01950000E-04
   -9.57000000E-05  -2.72600000E-05  +5.41680000E-04  -3.97650000E-04  -2.48400000E-05
   +3.51748830E-01  -1.92400000E-05  +2.34000000E-06  -2.76900000E-05  +8.25600000E-05
   -1.52200000E-05  -9.81000000E-06  +8.71000000E-06  +6.55000000E-06  -8.40000000E-07
   +8.96000000E-06  -8.30000000E-07  +1.12300000E-05  -1.42800000E-05  -4.46000000E-06
   -6.48000000E-06  +1.09100000E-05  -5.99000000E-06  +1.50000000E-06  -4.09200000E-05
   +1.56660000E-04  -9.90700000E-05  +1.52200000E-05  +5.37000000E-06  +3.12700000E-05
   +1.39200000E-05  -4.90000000E-07  +3.30000000E-07  -2.30730000E-04  +2.39900000E-05
   -2.05956000E-03  +1.26383000E-03  -1.57212000E-03  -9.89100000E-05  -4.21059000E-03
   +5.16086000E-03  +4.89628000E-03  -9.48541000E-03  +3.67190000E-03  -1.58697000E-03
   +3.03802000E-03  -7.01380000E-04  +8.48900000E-04  -1.35742000E-03  +7.94170000E-04
   +1.12805000E-03  +6.40930000E-03  -3.18681000E-03  +6.99078000E-03  +9.35932100E-02
   -4.49139900E-02  -7.72965600E-02  +4.59000000E-06  +4.07600000E-05  -1.54500000E-05
   +1.01387000E-03  +1.36120000E-04  +4.77000000E-06  -5.89000000E-06  +7.00000000E-07
   +1.66000000E-06  +2.28000000E-06  +1.99000000E-06  +3.85000000E-06  +9.45000000E-06
   -2.27000000E-06  +3.43000000E-06  -7.67000000E-06  +1.85200000E-05  +1.76200000E-05
   -1.20800000E-05  -5.80000000E-06  +6.25000000E-06  +4.46000000E-06  -2.49000000E-06
   -6.30000000E-06  -8.97000000E-06  -1.23600000E-05  -3.00000000E-07  -4.58000000E-06
   +3.14000000E-06  +1.46400000E-05  +9.43000000E-06  -3.65000000E-06  +2.12100000E-05
   -5.72000000E-06  -4.49000000E-06  -1.49800000E-05  +3.94000000E-06  +1.07200000E-05
   +2.57300000E-05  +7.45700000E-05  -4.06700000E-05  +2.92500000E-05  -1.25810000E-04
   +1.10700000E-04  -1.18880000E-04  -2.06966000E-03  -4.11260000E-04  -4.18280000E-04
   -8.91700000E-05  -3.24030000E-04  +9.49800000E-05  -4.12710000E-04  -6.20160000E-04
   -9.19920000E-04  -8.65952800E-02  +4.19744900E-02  +6.51000000E-06  -2.52000000E-06
   +7.92000000E-06  -2.28600000E-05  +1.77800000E-05  -2.55400000E-05  +1.17200000E-05
   +8.30000000E-06  -2.47000000E-06  -3.30000000E-07  -2.82000000E-06  -8.22000000E-06
   -2.88000000E-05  -2.03500000E-05  -5.93000000E-06  +2.51800000E-05  -5.09000000E-06
   -4.50000000E-07  -3.52930000E-04  -1.79500000E-05  -2.41630000E-04  +6.71400000E-05
   -8.72000000E-06  +1.55300000E-05  +2.89000000E-05  +2.67000000E-05  -4.27000000E-06
   -1.40514000E-03  -6.74080000E-04  -1.52803000E-03  -2.75075000E-03  -2.82722000E-03
   -3.36670000E-03  -1.80540500E-02  +1.16327300E-02  +1.43693400E-02  -2.03997900E-02
   -1.46360000E-04  -1.27910000E-04  +5.15893000E-03  +1.40590000E-04  +6.06220000E-04
   -1.80766000E-03  +1.10981000E-03  +1.81827000E-03  +1.18732000E-02  +6.85089000E-03
   +7.22221000E-03  +2.14340840E-01  -8.06223100E-02  -1.92382490E-01  +2.60400000E-05
   -1.06300000E-05  -1.40700000E-05  -4.49550000E-04  +1.50337000E-03  -1.05345000E-03
   -9.35000000E-06  -2.68000000E-06  +5.42000000E-06  +1.20000000E-07  +2.56000000E-06
   +4.80000000E-06  -6.16000000E-06  +2.93000000E-06  +2.40000000E-06  -1.28500000E-05
   -1.93000000E-05  +2.54500000E-05  -1.69000000E-06  +4.68000000E-06  +7.24000000E-06
   +2.36000000E-06  -1.07300000E-05  -1.46800000E-05  -4.47000000E-06  -1.36600000E-05
   +1.76600000E-05  +2.37000000E-06  +2.10900000E-05  +1.85000000E-06  -6.83000000E-06
   -1.70000000E-06  -3.65000000E-06  -3.29000000E-06  +2.50800000E-05  -2.81000000E-06
   +2.90800000E-05  -2.24000000E-06  +1.61800000E-05  +1.19180000E-04  -1.41870000E-04
   +3.45200000E-05  -2.34650000E-04  -8.12000000E-05  -6.50600000E-05  -1.50850000E-04
   -3.95339000E-03  +5.26500000E-04  +2.39710000E-04  -9.71600000E-05  -1.34880000E-04
   +3.33930000E-04  -2.45292000E-03  +1.22956000E-03  -1.86942900E-01  +6.76432400E-02
   +1.73517570E-01  -2.01320000E-04  +2.44700000E-05  -2.24300000E-05  +8.63900000E-05
   +8.29000000E-06  +5.29700000E-05  -1.84700000E-05  -5.07500000E-05  +6.13000000E-06
   +2.86800000E-05  +2.22000000E-05  +9.04000000E-06  -7.07000000E-05  -7.14400000E-05
   -1.85700000E-05  +4.66800000E-05  +8.46000000E-06  +4.18500000E-05  +4.39200000E-05
   -2.04300000E-05  -1.34100000E-05  -2.70500000E-05  +7.41800000E-05  -6.98200000E-05
   +6.92900000E-05  +6.26500000E-05  +2.31100000E-05  -9.31000000E-06  +4.20100000E-05
   +3.12100000E-04  -5.50580000E-04  -9.86500000E-05  -2.86500000E-05  +1.72725000E-03
   -6.30580000E-04  +1.11177000E-03  +7.20340000E-04  -6.70750000E-04  +9.34800000E-05
   -4.17170000E-04  +5.70900000E-05  -6.74500000E-05  +2.10900000E-04  -1.68410000E-04
   -2.60620000E-04  -7.38500000E-04  +3.04110000E-04  -3.27710000E-04  -1.12655000E-03
   +1.04362000E-03  -9.09280000E-04  -3.61000000E-06  +1.09300000E-05  +6.08000000E-06
   -1.53224400E-01  -1.23867100E-02  -2.33378500E-01  -1.14000000E-05  -1.23000000E-05
   -7.74000000E-06  +1.08900000E-05  -2.48000000E-06  +5.19000000E-06  +1.42800000E-05
   -7.17000000E-06  +7.99000000E-06  +5.41000000E-06  +2.88100000E-05  -1.36780000E-04
   -3.25100000E-05  -2.88800000E-05  -2.37300000E-05  +8.54000000E-06  -1.38500000E-05
   +2.02000000E-05  -3.09000000E-06  -2.16100000E-05  +6.86000000E-06  -2.03100000E-05
   -7.04000000E-06  +3.61000000E-05  +6.49000000E-06  -1.91000000E-06  +1.45400000E-05
   -4.94000000E-06  -9.31000000E-06  -3.32000000E-06  +1.23000000E-06  +1.61000000E-06
   -5.30000000E-07  +2.14000000E-06  +8.10000000E-06  -5.59000000E-06  -1.69100000E-05
   +9.98000000E-06  -1.17600000E-05  -1.55724000E-03  +8.72770000E-04  -2.05876000E-03
   +2.31300000E-05  +1.85320000E-04  +1.93000000E-05  +4.04100000E-04  +1.40750000E-04
   +1.37600000E-04  -2.10000000E-05  -5.54070000E-04  +6.33280000E-04  +1.43039910E-01
   +3.50500000E-05  -1.68800000E-05  -2.28000000E-06  +3.72100000E-05  +6.64900000E-05
   +1.05500000E-05  -5.07000000E-06  -2.99500000E-05  +1.07400000E-05  +6.70000000E-06
   -2.68400000E-05  +1.38700000E-05  +4.85000000E-05  +6.19200000E-05  +6.97000000E-06
   -3.90700000E-05  +2.86500000E-05  -4.53400000E-05  +4.17200000E-05  +4.05400000E-05
   -3.09800000E-05  -3.29700000E-05  -2.57000000E-05  +3.67400000E-05  -6.63400000E-05
   -9.47400000E-05  -2.93000000E-06  +4.06920000E-04  +3.83530000E-04  +2.09420000E-04
   -1.14401000E-03  -8.87200000E-05  -1.22600000E-04  +2.48258000E-03  -2.73521000E-03
   +2.76919000E-03  +5.99770000E-04  -1.58243000E-03  +8.21760000E-04  -1.15565000E-03
   -3.62950000E-04  -3.01590000E-04  +1.43550000E-04  +7.28500000E-05  -5.34420000E-04
   -2.60480000E-04  -2.71700000E-05  -5.59030000E-04  -1.94410000E-03  +9.27970000E-04
   -2.63450000E-03  -3.00000000E-05  -1.74000000E-05  -6.16000000E-06  -6.73341000E-03
   -4.02666100E-02  -5.04303600E-02  +8.49000000E-06  +1.00600000E-05  +2.16000000E-06
   -6.79000000E-06  -5.78000000E-06  -1.08000000E-06  +1.20500000E-05  +1.18000000E-06
   +4.53000000E-06  +1.75600000E-05  +7.58300000E-05  +8.30000000E-06  -2.22900000E-05
   -1.66900000E-05  -1.47000000E-06  -3.26400000E-05  +1.58800000E-05  -1.32300000E-05
   +2.17000000E-06  -4.18500000E-05  -6.85000000E-06  +4.51400000E-05  +3.08800000E-05
   -2.03800000E-05  +6.50000000E-06  +3.70000000E-07  -9.69000000E-06  +1.68000000E-06
   -1.86200000E-05  +7.43000000E-06  -1.59800000E-05  +1.50000000E-05  +2.06000000E-06
   +1.02900000E-05  -2.88600000E-05  -2.76000000E-05  -2.11300000E-05  +2.03000000E-05
   -4.70800000E-05  +9.46901000E-03  +1.00223300E-02  +1.44273200E-02  +1.20330000E-04
   -2.45070000E-04  -4.71000000E-05  -2.03300000E-05  +5.18010000E-04  +1.59690000E-04
   -4.74300000E-04  -1.45940000E-04  +5.19390000E-04  +1.12615800E-02  +3.37155100E-02
   +6.70400000E-05  -2.10900000E-05  -6.48400000E-05  +3.53300000E-05  -9.57700000E-05
   -5.92200000E-05  -1.47800000E-05  +2.09100000E-05  -3.59300000E-05  +6.77000000E-06
   +5.70700000E-05  -1.85700000E-05  -7.74600000E-05  -1.12380000E-04  +1.44400000E-05
   +3.97600000E-05  -4.20500000E-05  -6.14000000E-06  -1.75430000E-04  +5.05900000E-05
   +1.18680000E-04  +9.52300000E-05  -5.82000000E-05  +4.58900000E-05  +1.09940000E-04
   +1.26270000E-04  -9.31000000E-06  +2.77350000E-04  +2.74450000E-04  +8.58510000E-04
   -1.25615000E-03  +5.43090000E-04  -3.28300000E-05  -2.50800000E-04  -2.65391000E-03
   +5.90570000E-04  +1.18010000E-04  +4.71010000E-04  -5.79300000E-04  -8.83900000E-05
   -6.18900000E-05  -1.62030000E-04  +5.10150000E-04  -3.36800000E-04  -3.37920000E-04
   -3.40650000E-04  -3.47810000E-04  +4.06150000E-04  +5.99200000E-04  -7.44670000E-04
   +2.62050000E-04  +1.05890000E-04  -2.19900000E-05  -5.80600000E-05  -1.93139790E-01
   -5.47127600E-02  -3.98555270E-01  -2.46900000E-05  -1.22400000E-05  +6.61000000E-06
   +8.49000000E-06  +9.84000000E-06  +1.07700000E-05  -1.69700000E-05  -1.74000000E-06
   +1.51000000E-06  -8.77600000E-05  -1.29000000E-06  +1.29090000E-04  -3.61000000E-06
   +2.23500000E-05  +2.91000000E-05  +3.19500000E-05  -9.98000000E-06  -2.93000000E-05
   -1.52700000E-05  +1.54000000E-05  +1.24000000E-05  -4.79000000E-06  +2.58400000E-05
   -1.79000000E-06  -3.18500000E-05  +2.01800000E-05  -3.93500000E-05  -1.63500000E-05
   +2.67700000E-05  +2.44000000E-06  +5.67700000E-05  -4.90000000E-05  +4.64000000E-06
   +1.93000000E-05  +1.59200000E-05  +2.68000000E-06  -6.83000000E-06  +8.03000000E-06
   +1.57000000E-05  -4.16749000E-03  +6.16099000E-03  -8.43104000E-03  +5.55000000E-06
   -9.94600000E-05  -2.60800000E-05  +9.07800000E-05  -2.28500000E-05  -3.83160000E-04
   +2.44770000E-04  +5.25040000E-04  -5.09300000E-05  +2.13216570E-01  +5.17799800E-02
   +4.26360740E-01  +1.21430000E-04  -1.24000000E-06  +1.85870000E-04  -1.41320000E-04
   -9.50000000E-07  -1.92100000E-05  +6.74000000E-05  +6.16000000E-05  +2.17700000E-05
   -5.71200000E-05  -9.10900000E-05  +5.86000000E-06  +2.40230000E-04  +2.48810000E-04
   +2.29600000E-05  -9.70100000E-05  +7.63400000E-05  -1.85900000E-05  +7.90400000E-05
   -1.83700000E-05  -4.39600000E-05  -4.43400000E-05  -2.14400000E-05  +3.57800000E-05
   -2.44130000E-04  -2.38990000E-04  -2.89500000E-05  -2.00810000E-04  -8.24800000E-04
   -1.42321000E-03  +2.03259000E-03  -7.14010000E-04  +3.91320000E-04  +2.98680000E-04
   +4.80974000E-03  -3.53783000E-03  -6.65306000E-03  +4.00600000E-04  +2.07731000E-03
   +2.53357000E-03  +7.71780000E-04  +5.73420000E-04  -7.31980000E-04  +6.30590000E-04
   +8.43130000E-04  +1.09844000E-02  -4.35650000E-03  -6.79100000E-05  +2.56210000E-04
   -3.95180000E-04  +3.12290000E-04  -5.32600000E-05  +6.27000000E-06  +1.86600000E-05
   -1.14978300E-02  +2.01630200E-02  +2.38199800E-02  +5.48600000E-05  +3.86800000E-05
   +7.45000000E-06  -2.88600000E-05  -4.45000000E-06  -2.05800000E-05  -7.23000000E-06
   +1.40200000E-05  -1.74000000E-05  +4.93900000E-05  -8.57600000E-05  -1.09080000E-04
   +6.59300000E-05  +2.44400000E-05  -2.69400000E-05  -4.27700000E-05  +1.54100000E-05
   -3.80000000E-07  +2.32000000E-05  +2.86000000E-06  -3.60000000E-06  +2.44400000E-05
   +2.16000000E-06  -3.87000000E-05  +2.03600000E-05  -2.41900000E-05  +2.18500000E-05
   +2.46000000E-05  +4.90000000E-07  +4.08000000E-06  -4.52100000E-05  +3.16400000E-05
   +1.17700000E-05  -3.01000000E-06  -7.18300000E-05  +4.23100000E-05  -5.21000000E-05
   -2.86170000E-04  +2.84670000E-04  -8.32000000E-06  -1.13566400E-02  +4.14455000E-03
   +4.22100000E-05  -8.19500000E-05  +1.35000000E-06  -2.71939800E-02  -4.08455000E-02
   +2.25750300E-02  -5.54010000E-04  +2.91570000E-04  +3.34800000E-05  -3.93399000E-03
   +2.01722000E-03  +9.34360000E-04  +8.26553700E-02  -4.96200000E-05  +4.25100000E-05
   -8.48000000E-05  +1.27110000E-04  -3.94430000E-04  -1.47470000E-04  -4.21700000E-05
   +1.00030000E-04  -1.08260000E-04  +4.58800000E-05  +2.60490000E-04  -3.63900000E-05
   -3.53640000E-04  -5.41480000E-04  +1.65900000E-05  +1.74090000E-04  -7.98900000E-05
   +1.57060000E-04  -7.07070000E-04  +1.60750000E-04  +3.02130000E-04  +2.68790000E-04
   +2.19500000E-05  +5.17600000E-05  +4.70410000E-04  +6.30370000E-04  +6.88500000E-05
   +1.10070000E-04  -9.92050000E-04  -1.69064000E-03  +3.88330000E-04  -3.51020000E-04
   +7.53170000E-04  +3.57006000E-03  +3.77094000E-03  -3.80862000E-03  -2.35515800E-02
   +9.14280000E-04  +6.69478000E-03  +5.03805000E-03  +3.02880000E-04  +7.85170000E-04
   -1.48455000E-03  +1.18350000E-03  +1.39372000E-03  +1.97871700E-02  -4.36207200E-02
   +5.90904000E-03  -1.08210000E-03  -1.01324000E-03  -9.49720000E-04  +3.72060000E-04
   +3.91000000E-06  -1.90860000E-04  +1.14736200E-02  +5.18656000E-03  -1.41155300E-02
   -6.97800000E-05  -8.01900000E-05  -3.25400000E-05  +6.10400000E-05  +3.10100000E-05
   +2.44500000E-05  -4.97100000E-05  -2.31200000E-05  -2.00500000E-05  -7.37600000E-05
   -1.58670000E-04  +1.17740000E-04  +3.02300000E-05  +3.51500000E-05  -6.11000000E-05
   +1.32130000E-04  -7.16600000E-05  -6.38200000E-05  -3.86600000E-05  +9.35600000E-05
   +6.09900000E-05  -8.10400000E-05  -9.96000000E-06  +3.40100000E-05  -6.48100000E-05
   +3.41900000E-05  -2.97000000E-06  -4.25000000E-05  +1.22610000E-04  -3.09400000E-05
   +1.97750000E-04  -1.58700000E-04  +6.34100000E-05  +1.65890000E-04  -6.94600000E-05
   +1.62610000E-04  -3.42300000E-05  -2.66600000E-04  +2.52570000E-04  -5.31480000E-04
   -4.29098000E-03  +1.28708000E-03  +8.53700000E-05  -1.01450000E-04  -9.15500000E-05
   -3.96689300E-02  -2.95852440E-01  +1.51197990E-01  +3.40980000E-04  +4.38730000E-04
   +1.32360000E-03  +1.02786000E-03  -8.63100000E-04  +3.81150000E-04  +1.25639740E-01
   +5.94748170E-01  -1.75980000E-04  -4.94000000E-06  -1.55460000E-04  +1.01990000E-04
   +8.31600000E-05  +7.69200000E-05  -5.07700000E-05  -8.82100000E-05  +2.18700000E-05
   +4.22600000E-05  +2.48400000E-05  +2.49500000E-05  -7.19900000E-05  -6.22800000E-05
   -1.85400000E-05  +2.85800000E-05  -1.78500000E-05  +3.01400000E-05  +1.73750000E-04
   -3.99200000E-05  +1.92000000E-05  -5.65200000E-05  +4.30000000E-05  -6.57400000E-05
   +5.71700000E-05  +4.53900000E-05  +3.60200000E-05  +4.97840000E-04  +1.22648000E-03
   +2.41284000E-03  -2.93612000E-03  +1.12531000E-03  -3.30770000E-04  -2.20093000E-03
   -7.70014000E-03  +4.25132000E-03  +1.30245100E-02  -1.51390000E-03  -3.10930000E-03
   -3.47439000E-03  -1.18270000E-04  -1.69171000E-03  +1.92997000E-03  -1.03772000E-03
   -1.54536000E-03  -1.00184200E-02  +1.70774200E-02  +5.34905000E-03  +8.96360000E-04
   +4.20340000E-04  +9.87740000E-04  -3.80100000E-05  -1.33100000E-05  +1.40400000E-05
   +2.82685600E-02  -2.72128400E-02  -2.23166400E-02  -4.04000000E-06  -1.26800000E-05
   -1.62500000E-05  +1.37400000E-05  -8.21000000E-06  +6.40000000E-07  +2.56600000E-05
   -1.01200000E-05  +1.12100000E-05  -4.63400000E-05  +1.17790000E-04  +1.87000000E-05
   -4.71300000E-05  -3.51400000E-05  -1.19800000E-05  -3.55000000E-06  +5.82000000E-06
   +2.66000000E-05  +2.10000000E-07  -1.71500000E-05  -1.33600000E-05  -4.76000000E-06
   -1.16000000E-05  +2.54800000E-05  +6.97000000E-06  +6.66000000E-06  -1.02000000E-06
   -1.75000000E-06  -2.91300000E-05  +4.86000000E-06  -2.09200000E-05  +9.38000000E-06
   -2.10900000E-05  +6.94000000E-06  +3.74000000E-06  -6.74600000E-05  +1.48270000E-04
   +4.55700000E-05  +2.81210000E-04  -2.16960000E-04  +1.53072000E-02  -6.44946000E-03
   -1.10860000E-04  +1.68170000E-04  +2.96900000E-05  +1.20097800E-02  +1.00937150E-01
   -1.25268030E-01  +1.56700000E-04  +3.41840000E-04  -1.09545000E-03  +1.67953000E-03
   -4.83230000E-04  +7.90710000E-04  +6.27626400E-02  +1.02261320E-01  +4.54187290E-01
   +2.38300000E-05  +2.86000000E-06  -2.01300000E-05  +2.26300000E-05  +1.02400000E-05
   -1.66000000E-06  -8.97000000E-06  -8.54000000E-06  -5.30000000E-06  +7.84000000E-06
   +6.00000000E-06  -7.86000000E-06  -6.18900000E-05  -4.15000000E-05  -1.00000000E-05
   +2.12000000E-05  -2.19600000E-05  -3.42000000E-05  -2.67200000E-05  +2.24700000E-05
   -1.55800000E-05  +1.03000000E-05  -1.03000000E-05  +5.31000000E-06  +5.38800000E-05
   +2.84300000E-05  -8.82000000E-06  -1.51140000E-04  -9.87200000E-05  -2.88000000E-04
   +3.95650000E-04  -1.18020000E-04  -1.47700000E-05  +2.08000000E-05  +5.54890000E-04
   +1.04370000E-04  +5.79050000E-04  +2.23210000E-04  +6.15100000E-05  +1.70900000E-04
   -3.53930000E-04  +1.77690000E-04  -3.53360000E-04  +9.52200000E-05  +2.46870000E-04
   -3.03190000E-04  +1.86580000E-04  -2.42600000E-05  -2.67020000E-04  -1.15870000E-04
   -1.85410000E-04  -1.12000000E-06  -1.30000000E-07  +3.56000000E-06  -5.50531000E-03
   +2.40905000E-03  +3.89942000E-03  -2.28000000E-05  -6.49000000E-06  +6.60000000E-06
   +3.61000000E-06  +1.85000000E-06  +8.65000000E-06  +4.70000000E-07  -2.12000000E-06
   +6.75000000E-06  +7.24000000E-06  +1.87700000E-05  +3.53700000E-05  -2.55500000E-05
   -4.36000000E-06  +3.60500000E-05  +9.06000000E-06  -7.30000000E-07  -2.04000000E-06
   -9.10000000E-06  -5.50000000E-06  -1.31000000E-06  -5.50000000E-07  +3.43000000E-06
   +6.99000000E-06  -2.17000000E-06  +6.36000000E-06  -6.26000000E-06  -7.96000000E-06
   -2.95000000E-06  -3.25000000E-06  +1.01800000E-05  -4.10000000E-07  -1.28000000E-06
   -2.45600000E-05  +3.11700000E-05  -3.94000000E-06  +2.90500000E-05  +1.54430000E-04
   -2.24620000E-04  +1.07750000E-04  -9.03090000E-04  +4.72260000E-04  -5.20000000E-07
   -3.39000000E-06  -4.46000000E-06  -2.01838000E-03  -2.23944000E-03  -6.63193000E-03
   +4.06100000E-05  +1.89000000E-05  +7.06000000E-06  -3.11800000E-05  -1.13300000E-04
   -4.32300000E-05  -4.11120600E-02  -9.56059200E-02  -8.88039800E-02  +4.03545700E-02
   +1.66000000E-05  +7.00000000E-08  +3.23200000E-05  -2.08200000E-05  +5.21700000E-05
   +2.55500000E-05  +1.42300000E-05  -1.07000000E-05  +2.28900000E-05  -1.14500000E-05
   -5.44700000E-05  +1.21100000E-05  +1.00270000E-04  +1.35280000E-04  +1.18000000E-06
   -4.45300000E-05  +2.71600000E-05  -3.58500000E-05  +1.20800000E-04  -4.78000000E-06
   -2.87700000E-05  -5.40300000E-05  -2.61000000E-06  -1.90000000E-07  -1.14310000E-04
   -1.53110000E-04  -1.76400000E-05  +1.00700000E-05  -5.33000000E-05  +5.11700000E-05
   +7.42500000E-05  -1.41500000E-05  +8.13600000E-05  -1.69260000E-04  +2.06450000E-04
   -7.42600000E-05  +4.51900000E-05  -5.45980000E-04  +2.23150000E-04  -3.06900000E-05
   +2.21040000E-04  -2.94300000E-04  +1.67900000E-04  +2.74400000E-05  -3.08300000E-05
   +6.79800000E-04  -1.11235000E-03  +1.92550000E-03  -2.78200000E-05  +4.66200000E-05
   +1.55910000E-04  -5.38100000E-05  -3.98000000E-06  +1.65300000E-05  -1.59559000E-03
   +1.45109000E-03  +1.36631000E-03  +1.68600000E-05  +2.12400000E-05  +7.32000000E-06
   -1.26000000E-05  -5.15000000E-06  -6.14000000E-06  +1.04200000E-05  +2.92000000E-06
   +7.10000000E-07  +1.39900000E-05  +2.07600000E-05  -3.47300000E-05  -1.29000000E-06
   -3.49000000E-06  +1.19800000E-05  -2.64200000E-05  +1.39400000E-05  +1.14300000E-05
   +7.25000000E-06  -1.87200000E-05  -1.09000000E-05  +1.66000000E-05  +2.91000000E-06
   -7.93000000E-06  +1.71500000E-05  -7.67000000E-06  +7.83000000E-06  +8.02000000E-06
   -1.93200000E-05  +3.18000000E-06  -3.29800000E-05  +2.67000000E-05  -5.20000000E-07
   -1.54200000E-05  -4.42000000E-06  -2.09600000E-05  +7.32300000E-05  -1.03170000E-04
   +2.08940000E-04  -1.72000000E-06  -5.12160000E-04  +8.61400000E-05  +5.60000000E-07
   +2.03300000E-05  +8.35000000E-06  -9.92394000E-03  -1.95636600E-02  -3.44856200E-02
   -2.74200000E-05  -1.03140000E-04  -1.48450000E-04  +8.01700000E-05  +9.45200000E-05
   -2.28990000E-04  -8.58620700E-02  -2.41328810E-01  -2.10019960E-01  +9.39096700E-02
   +2.63232060E-01  +5.27000000E-06  -5.57000000E-06  +1.11000000E-05  -1.96100000E-05
   +1.13100000E-05  -2.19000000E-06  +7.88000000E-06  +6.39000000E-06  -2.33000000E-06
   -8.52000000E-06  -1.25900000E-05  -8.28000000E-06  +2.61200000E-05  +2.80300000E-05
   +6.20000000E-06  -6.14000000E-06  -5.39000000E-06  +7.05000000E-06  +2.13800000E-05
   -2.10000000E-05  -1.83500000E-05  -1.86000000E-06  -1.73000000E-06  -3.24000000E-06
   -2.44300000E-05  -2.32200000E-05  -1.09900000E-05  -1.20600000E-05  +6.96500000E-05
   +1.28150000E-04  -8.61000000E-06  +2.01400000E-05  -8.86200000E-05  -1.94590000E-04
   -3.15960000E-04  +1.19790000E-04  +1.12929000E-03  +9.21000000E-06  -4.17840000E-04
   -3.29330000E-04  +8.28600000E-05  +1.86440000E-04  +1.25620000E-04  -1.03890000E-04
   -1.98230000E-04  -1.27429000E-03  +2.92012000E-03  -1.19628000E-03  +1.32500000E-04
   +6.12300000E-05  +4.42900000E-05  -1.44300000E-05  +3.68000000E-06  +1.48300000E-05
   +2.32179000E-03  -5.51360000E-04  -4.20540000E-04  +3.42000000E-06  +5.32000000E-06
   +6.86000000E-06  -6.93000000E-06  +8.00000000E-07  -7.10000000E-07  -2.62000000E-06
   +4.56000000E-06  +7.00000000E-07  -5.60000000E-06  -1.11200000E-05  -1.16800000E-05
   +1.34900000E-05  +4.51000000E-06  -5.18000000E-06  -4.49000000E-06  +1.06000000E-06
   +1.11000000E-06  +2.72000000E-06  -5.80000000E-07  -5.70000000E-07  +8.90000000E-07
   +1.08000000E-06  -4.68000000E-06  -9.80000000E-07  -2.85000000E-06  -3.89000000E-06
   +3.05000000E-06  -2.46000000E-06  +2.78000000E-06  -8.12000000E-06  +5.24000000E-06
   -5.66000000E-06  -1.97400000E-05  +3.76000000E-06  +3.96000000E-06  -5.52400000E-05
   +3.83600000E-05  -8.68500000E-05  +8.20200000E-05  +1.55310000E-04  -9.10800000E-05
   -6.81000000E-06  +1.30000000E-06  +2.89000000E-06  +4.53687000E-03  +1.05949500E-02
   +1.35321800E-02  -1.34000000E-05  -6.78000000E-06  -3.32500000E-05  -2.41220000E-04
   +9.81800000E-05  +2.53930000E-04  -9.47352500E-02  -2.55094040E-01  -3.16241570E-01
   +9.33189800E-02  +2.44065930E-01  +3.06595130E-01  -1.82390000E-04  -5.43000000E-06
   -2.32140000E-04  +1.76890000E-04  -4.63000000E-06  +2.97500000E-05  -8.33900000E-05
   -8.44700000E-05  -1.72100000E-05  +7.60800000E-05  +1.19060000E-04  +1.01500000E-05
   -2.77030000E-04  -3.12050000E-04  -2.92400000E-05  +1.06820000E-04  -7.17200000E-05
   +4.69700000E-05  -3.64400000E-05  -6.69000000E-06  +1.04030000E-04  +2.99200000E-05
   +4.80700000E-05  -5.70400000E-05  +2.80190000E-04  +3.00810000E-04  +5.56100000E-05
   +5.60830000E-04  +1.33687000E-03  +2.70848000E-03  -3.59544000E-03  +1.17983000E-03
   -3.08240000E-04  -2.16970000E-04  -8.69737000E-03  +5.07043000E-03  +1.17645300E-02
   -2.88973000E-03  -3.66961000E-03  -3.57333000E-03  -8.13200000E-04  -1.15865000E-03
   +1.77756000E-03  -1.11566000E-03  -1.66363000E-03  -8.90481000E-03  +9.27459000E-03
   +3.08490000E-04  -1.58400000E-04  +9.44230000E-04  +3.92740000E-04  +7.63700000E-05
   -1.37900000E-05  -3.92200000E-05  -1.51346580E-01  +8.67521200E-02  +1.12479380E-01
   -4.94900000E-05  -4.87300000E-05  -2.14900000E-05  +3.79200000E-05  +1.42000000E-06
   +1.85000000E-05  +1.34700000E-05  -1.90200000E-05  +1.60500000E-05  -4.37500000E-05
   +1.21060000E-04  +1.15850000E-04  -7.86900000E-05  -3.94800000E-05  +5.24000000E-06
   +4.41600000E-05  -1.77300000E-05  +6.40000000E-06  -2.16100000E-05  -1.33000000E-06
   +1.26000000E-06  -3.07400000E-05  -1.23200000E-05  +4.26200000E-05  -2.08700000E-05
   +2.58400000E-05  -1.98900000E-05  -2.42900000E-05  -1.09000000E-06  -1.73000000E-06
   +4.77300000E-05  -4.31600000E-05  -1.25800000E-05  +1.97800000E-05  +6.62300000E-05
   -6.24200000E-05  +1.16120000E-04  +7.36500000E-05  +1.58350000E-04  -9.30140000E-04
   +2.04313300E-02  -8.66856000E-03  -9.50700000E-05  +1.98430000E-04  -8.13000000E-06
   -1.54705000E-03  -1.24701900E-02  +4.70269000E-03  +4.66130000E-04  -6.27520000E-04
   -2.94120000E-04  +1.55706900E-02  -1.46561400E-02  -1.68109100E-02  -6.87151000E-03
   -5.97508000E-03  -1.35480400E-02  +8.06493000E-03  +2.64313000E-03  -4.73702000E-03
   +1.38857880E-01  +1.89520000E-04  +1.54000000E-06  +1.68320000E-04  -1.55450000E-04
   +1.44940000E-04  +1.07100000E-05  +5.88200000E-05  +1.94400000E-05  +4.84900000E-05
   -5.12000000E-05  -1.53250000E-04  +6.63000000E-06  +2.12970000E-04  +3.11400000E-04
   -2.08000000E-06  -1.01660000E-04  +7.14500000E-05  -1.32530000E-04  +1.82650000E-04
   -2.65300000E-05  -1.74020000E-04  -9.04700000E-05  -5.34400000E-05  +3.19200000E-05
   -2.73280000E-04  -3.51790000E-04  -5.38700000E-05  -8.76940000E-04  -9.00420000E-04
   -2.21890000E-03  +2.52321000E-03  -1.20511000E-03  +4.70470000E-04  +1.53600000E-04
   +4.28405000E-03  -1.06415000E-03  -4.48688000E-03  -1.70280000E-04  +1.87345000E-03
   +2.48421000E-03  +1.95560000E-04  +8.31460000E-04  -1.38213000E-03  +1.02227000E-03
   +1.50992000E-03  +3.42288000E-03  -4.84773000E-03  -7.30210000E-04  -2.49320000E-04
   +3.85760000E-04  -5.58860000E-04  -1.75190000E-04  +6.69000000E-06  +9.45100000E-05
   +7.81178700E-02  -8.61645300E-02  -7.69289600E-02  +3.59900000E-05  +4.67800000E-05
   +2.35600000E-05  -3.64500000E-05  -1.18300000E-05  -1.26700000E-05  +6.76000000E-06
   +1.61100000E-05  -6.40000000E-07  +1.19150000E-04  -1.85000000E-05  -4.08700000E-05
   +1.49000000E-06  +4.97000000E-06  +5.32700000E-05  -5.81300000E-05  +3.41200000E-05
   +1.42900000E-05  +1.54500000E-05  -2.45600000E-05  -1.72500000E-05  +4.49700000E-05
   +1.09300000E-05  -3.18300000E-05  +3.48000000E-05  -2.47000000E-05  +1.27000000E-05
   +2.17900000E-05  -3.50500000E-05  +6.06000000E-06  -8.28300000E-05  +8.11100000E-05
   -1.04200000E-05  -7.79300000E-05  +7.50000000E-07  -9.41000000E-06  -5.85900000E-05
   -1.02500000E-05  -1.99030000E-04  +1.12762100E-02  -2.07912200E-02  -5.07550000E-03
   +6.44400000E-05  -5.75800000E-05  +2.30700000E-05  -6.13438000E-03  +1.11198600E-02
   +4.87969000E-03  -5.74580000E-04  -4.80160000E-04  +4.30590000E-04  -5.18620000E-04
   +5.38670000E-04  -8.99990000E-04  -9.96582000E-03  -1.78136100E-02  +9.18602000E-03
   +1.97317000E-03  -1.97757000E-03  -2.03443000E-03  -7.55901100E-02  +1.16821710E-01
   +3.16360000E-04  -2.68000000E-06  +2.93260000E-04  -2.12890000E-04  +2.75000000E-05
   -6.90100000E-05  +9.93100000E-05  +1.06310000E-04  +1.47900000E-05  -8.31700000E-05
   -1.42030000E-04  -1.75500000E-05  +2.37970000E-04  +3.04430000E-04  +1.38400000E-05
   -1.15570000E-04  +6.20800000E-05  -1.24830000E-04  -2.20400000E-05  +3.24300000E-05
   -1.53710000E-04  -1.84300000E-05  -7.48200000E-05  +9.07400000E-05  -2.69920000E-04
   -3.15150000E-04  -7.64200000E-05  -8.22630000E-04  -1.81675000E-03  -3.87415000E-03
   +5.36868000E-03  -1.64084000E-03  +1.66050000E-04  +1.31910000E-03  +1.35772700E-02
   -6.43763000E-03  -1.30580200E-02  +4.54858000E-03  +4.44000000E-03  +4.48873000E-03
   -1.24220000E-04  +1.50601000E-03  -3.17823000E-03  +1.60244000E-03  +2.72807000E-03
   +1.02654000E-02  -1.06933000E-02  -1.36031000E-03  -1.31162000E-03  -1.05379000E-03
   -1.06906000E-03  -8.83100000E-05  +2.01500000E-05  +4.92900000E-05  +7.26254600E-02
   -4.96865600E-02  -1.52131010E-01  +3.36000000E-05  +4.88900000E-05  +3.24700000E-05
   -4.12900000E-05  -3.90000000E-07  -1.16300000E-05  -1.92700000E-05  +2.19900000E-05
   -1.27300000E-05  +1.49910000E-04  -1.22330000E-04  -6.97100000E-05  +5.58900000E-05
   +3.87500000E-05  +5.09800000E-05  -4.52300000E-05  +2.12500000E-05  -1.61600000E-05
   +1.58100000E-05  -5.85000000E-06  -4.92000000E-06  +3.96600000E-05  +1.82100000E-05
   -5.41100000E-05  +2.01500000E-05  -2.46100000E-05  +1.39800000E-05  +2.04900000E-05
   -8.60000000E-07  -2.50000000E-07  -4.29300000E-05  +5.02700000E-05  +1.62800000E-05
   -4.17100000E-05  -2.13000000E-05  +5.18800000E-05  -7.67500000E-05  +8.26700000E-05
   -4.15450000E-04  -4.69503000E-03  -2.50509100E-02  +1.92091500E-02  +1.26230000E-04
   -2.59910000E-04  -5.14000000E-06  +5.26741000E-03  +1.51177000E-02  -6.34498000E-03
   -4.50690000E-04  +4.49500000E-05  +7.33210000E-04  +2.01521800E-02  -1.55603800E-02
   -2.10355500E-02  -1.90403100E-02  +3.23009000E-03  +9.81873000E-03  -2.05518000E-03
   -2.87974000E-03  -2.06536000E-03  -7.49131200E-02  +7.05204700E-02  +1.56120910E-01
end_hess

