# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -883.33247630    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +3.22927382E+00  -1.11917385E+00  +1.62708654E+00
   006   +3.47062303E+00  +1.10332384E+00  +2.26673159E-01
   006   +5.68990158E+00  +1.43368248E+00  -1.12707122E+00
   006   +7.60115281E+00  -3.67194490E-01  -1.09082306E+00
   006   +7.31875071E+00  -2.55328051E+00  +3.19851474E-01
   006   +5.10731300E+00  -2.92615599E+00  +1.68879610E+00
   006   +1.34191901E+00  +3.06386330E+00  +2.99173594E-01
   006   +1.33419659E+00  +4.27638657E+00  +2.93522283E+00
   008   +9.11410998E+00  -4.38521946E+00  +4.31251327E-01
   006   -1.16229098E+00  +1.75263662E+00  -3.03950559E-01
   006   -3.26531820E+00  +1.92536539E+00  +1.18920263E+00
   006   -5.50191979E+00  +6.07330510E-01  +5.50841308E-01
   006   -5.75358821E+00  -7.50348658E-01  -1.78519716E+00
   006   -3.53086366E+00  -8.62456174E-01  -3.29589370E+00
   006   -1.36653835E+00  +3.41524374E-01  -2.57135070E+00
   008   -7.79206623E+00  -1.98131406E+00  -2.17744132E+00
   008   -7.69989416E+00  +1.11395737E+00  +1.87033501E+00
   006   +1.72893016E+00  +5.18573578E+00  -1.64397660E+00
   008   -6.20370608E+00  -4.10188969E+00  +1.82219978E+00
   001   +1.05299868E+01  -3.91285592E+00  -5.89233384E-01
   001   +9.31202275E+00  -5.63139642E-02  -2.17428597E+00
   001   +5.97613843E+00  +3.11368723E+00  -2.25261650E+00
   001   +1.50732206E+00  -1.45442544E+00  +2.68193431E+00
   001   +4.88752749E+00  -4.64148301E+00  +2.77731604E+00
   001   +3.18066263E+00  +5.10849513E+00  +3.30939309E+00
   001   -7.53518207E-02  +5.77558027E+00  +3.06871412E+00
   001   +9.59117897E-01  +2.89075206E+00  +4.41271439E+00
   001   +1.86944968E+00  +4.45671040E+00  -3.56551830E+00
   001   +1.23416231E-01  +6.47392532E+00  -1.57539403E+00
   001   +3.43133245E+00  +6.27415344E+00  -1.23511130E+00
   001   +2.88827481E-01  +1.81518174E-01  -3.76629404E+00
   001   -3.62394659E+00  -1.91499614E+00  -5.04574598E+00
   001   -5.18329532E+00  -2.01196722E+00  +1.35867094E+00
   001   -3.29150714E+00  +3.04116173E+00  +2.90078657E+00
   001   -7.29178132E+00  -3.84136590E+00  +2.56626845E-01
   001   -9.03653015E+00  +5.05577681E-01  +7.83013669E-01
   001   -7.27026983E+00  -3.82565657E+00  +3.26433617E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -4.00000000E-08  -3.30000000E-07  -1.80000000E-07
   -1.00000000E-08  -3.00000000E-08  +2.10000000E-07
   +3.00000000E-08  +2.40000000E-07  +4.00000000E-07
   +7.00000000E-08  +2.10000000E-07  +1.40000000E-07
   -2.00000000E-08  +2.00000000E-08  -3.90000000E-07
   -8.00000000E-08  -3.30000000E-07  -5.30000000E-07
   -2.00000000E-08  +1.00000000E-08  +5.70000000E-07
   -9.00000000E-08  -6.20000000E-07  +8.60000000E-07
   -1.00000000E-08  -8.00000000E-08  -6.70000000E-07
   +5.00000000E-08  +8.00000000E-08  +8.00000000E-08
   +1.00000000E-08  -3.10000000E-07  +7.00000000E-08
   -9.60000000E-07  -7.00000000E-08  +6.40000000E-07
   -3.20000000E-07  +2.90000000E-07  -9.50000000E-07
   +1.10000000E-07  +2.60000000E-07  -2.70000000E-07
   +1.70000000E-07  +6.70000000E-07  -4.00000000E-08
   +3.70000000E-07  +5.20000000E-07  -1.02000000E-06
   +2.20000000E-07  -5.10000000E-07  -2.10000000E-07
   +5.00000000E-08  +3.90000000E-07  +1.08000000E-06
   +1.00000000E-08  -2.60000000E-07  -1.99000000E-06
   +4.00000000E-08  +1.40000000E-07  -5.20000000E-07
   +8.00000000E-08  +4.80000000E-07  +2.70000000E-07
   +9.00000000E-08  +5.20000000E-07  +7.90000000E-07
   -1.10000000E-07  -5.50000000E-07  -3.60000000E-07
   -1.10000000E-07  -5.80000000E-07  -9.00000000E-07
   -1.10000000E-07  -7.20000000E-07  +1.13000000E-06
   -9.00000000E-08  -6.00000000E-07  +1.11000000E-06
   -2.20000000E-07  -9.40000000E-07  +5.60000000E-07
   +2.10000000E-07  +7.70000000E-07  +9.30000000E-07
   +4.00000000E-08  +3.30000000E-07  +1.24000000E-06
   +3.00000000E-08  +3.30000000E-07  +1.42000000E-06
   +1.70000000E-07  +8.60000000E-07  -7.00000000E-08
   +2.60000000E-07  +1.08000000E-06  -6.50000000E-07
   -6.00000000E-08  +9.00000000E-08  -5.70000000E-07
   -6.00000000E-08  -7.10000000E-07  +4.90000000E-07
   +1.10000000E-07  -3.00000000E-08  -9.50000000E-07
   +3.80000000E-07  -1.70000000E-07  -5.00000000E-07
   -1.80000000E-07  -4.50000000E-07  -1.24000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.52851430E-01  -1.08804680E-01  +5.73063680E-01  -1.96967790E-01  -1.87013620E-01
   +3.52973210E-01  -1.20976530E-01  +2.19227800E-02  +1.32439000E-02  +5.78659020E-01
   -3.33766700E-02  -2.44446440E-01  +1.15819290E-01  -6.46836600E-02  +5.40714060E-01
   +4.60298700E-02  +8.72057700E-02  -1.44043630E-01  -1.71651510E-01  -1.65521610E-01
   +3.70238340E-01  +1.80415800E-02  -7.40573500E-02  +3.82586000E-02  -2.63955750E-01
   +1.82547100E-02  +9.36128800E-02  +5.87734590E-01  -3.10370800E-02  +1.44871000E-02
   +1.23508800E-02  -3.72606000E-02  -1.22156220E-01  +5.08953800E-02  -9.38473300E-02
   +6.14462250E-01  +1.33910300E-02  +3.44662100E-02  -1.84034600E-02  +1.25647790E-01
   +2.31441400E-02  -1.45985190E-01  -1.81533610E-01  -2.24264990E-01  +3.66367650E-01
   -1.13648600E-02  +2.39111300E-02  -9.61871000E-03  -4.62395200E-02  +2.39178000E-03
   +2.66760300E-02  -2.28755440E-01  +1.47187840E-01  +4.25535000E-03  +6.34931070E-01
   +1.97667400E-02  -5.92709700E-02  +2.22468300E-02  +4.52751800E-02  +4.50070700E-02
   -4.46732400E-02  +9.10807700E-02  -2.14645210E-01  +4.08418000E-02  -1.03742020E-01
   +5.74843840E-01  -7.22190000E-03  +1.97910100E-02  -1.11984100E-02  +1.82724000E-03
   -2.32327100E-02  +1.91188600E-02  +3.63544100E-02  +1.20492200E-02  -8.53810600E-02
   -2.08771790E-01  -2.05366080E-01  +3.53565460E-01  -4.86768000E-02  +5.18541800E-02
   -3.61363000E-03  -2.51588500E-02  -3.24991600E-02  +2.94837000E-02  +5.02355600E-02
   +5.41219000E-03  -2.78575700E-02  -1.31086160E-01  +1.78940700E-02  +2.25295200E-02
   +6.27691590E-01  +4.46183000E-03  +4.93739400E-02  -2.95459100E-02  -3.00874900E-02
   -2.75822600E-02  +2.80201600E-02  +5.33449700E-02  -4.60140400E-02  +1.51820000E-04
   -4.92900600E-02  -2.50046310E-01  +1.30477320E-01  -9.98328800E-02  +5.99174860E-01
   +2.39131200E-02  -5.38276000E-02  +2.10163900E-02  +2.79130200E-02  +2.94313900E-02
   -3.71910000E-02  -5.62318000E-02  +2.48654700E-02  +1.64977100E-02  +6.12972500E-02
   +9.48965600E-02  -1.55999340E-01  -1.86333730E-01  -1.98676040E-01  +3.75080380E-01
   -2.41785380E-01  +1.01793370E-01  +3.61031000E-02  +4.21494600E-02  +5.12852600E-02
   -4.85412700E-02  -6.26684100E-02  +1.92384200E-02  +1.93265700E-02  +2.07077600E-02
   -6.72353000E-02  +3.22525600E-02  -2.42480620E-01  +7.26339000E-03  +8.58294300E-02
   +6.01557490E-01  +1.58419050E-01  -2.30814340E-01  +1.56277700E-02  +8.79980000E-03
   -4.14135200E-02  +2.37549600E-02  +2.03854900E-02  -8.85747000E-03  -7.02893000E-03
   -2.84277100E-02  +1.61955900E-02  +1.04350800E-02  -5.72590700E-02  -1.27273150E-01
   +6.19167100E-02  -1.16574440E-01  +6.38431180E-01  +3.51700000E-03  +4.49999600E-02
   -8.78500300E-02  -2.27601000E-02  +1.50459000E-03  +1.94481200E-02  +1.92421800E-02
   -6.65702000E-03  -9.08596000E-03  +9.84781000E-03  +3.06837100E-02  -1.44605200E-02
   +1.22297470E-01  +2.82020100E-02  -1.51395740E-01  -1.78237890E-01  -2.29646810E-01
   +3.54130420E-01  +3.56831000E-03  +5.64972000E-03  -4.85126000E-03  -1.30270970E-01
   +4.25675000E-02  +9.25741000E-03  -1.80507200E-02  +1.79705500E-02  +1.40543000E-03
   -4.99190000E-04  -1.85660000E-04  +4.13092000E-03  -2.58413000E-03  -2.31270000E-04
   +9.99220000E-04  +3.19491000E-03  -2.20616000E-03  +2.20333000E-03  +4.74511240E-01
   +2.12983100E-02  -2.11144100E-02  +6.36110000E-04  +4.63328600E-02  -1.23696020E-01
   +5.64597000E-03  +1.97148000E-03  +7.04066000E-03  -3.11843000E-03  -1.40069000E-03
   +2.03109000E-03  +3.60407000E-03  +3.23520000E-04  -1.15610000E-03  +3.03740000E-04
   -1.59478000E-03  -9.65440000E-04  +4.06500000E-03  +3.20975000E-03  +4.81622960E-01
   -1.44722300E-02  +1.03547700E-02  +3.48803000E-03  +6.88192000E-03  +7.71131000E-03
   -7.70785900E-02  +9.46325000E-03  -1.10871300E-02  +3.15486000E-03  +4.10808000E-03
   +2.45440000E-03  +3.18556000E-03  +3.49750000E-04  +9.70560000E-04  -1.22016000E-03
   +2.39762000E-03  +5.16666000E-03  +1.01091000E-03  -1.56834000E-03  -2.25550000E-04
   +4.84578390E-01  -2.30920000E-04  +4.87220000E-04  +8.14030000E-04  -4.23994000E-03
   +1.30329300E-02  +2.34368300E-02  -3.43920000E-04  +1.83686000E-03  -4.01800000E-04
   -1.13334000E-03  +2.29520000E-04  -1.29802000E-03  +2.81580000E-04  -9.09380000E-04
   +4.02610000E-04  -2.48340000E-04  -5.76470000E-04  -2.27000000E-06  -7.57894200E-02
   +1.16033000E-03  +3.25698000E-03  +5.87433710E-01  +9.33850000E-04  -6.36320000E-04
   -1.11420000E-03  +7.30439000E-03  -1.57318600E-02  -2.28517200E-02  -1.46447000E-03
   -1.23365000E-03  +3.67170000E-04  +7.91760000E-04  -6.22920000E-04  +1.20552000E-03
   +7.26900000E-05  +9.57810000E-04  -6.54420000E-04  -7.90600000E-05  +8.07890000E-04
   +2.02980000E-04  -1.70373000E-03  -9.21023500E-02  -3.95359500E-02  +6.50800000E-04
   +5.63286400E-01  -1.39525000E-03  +1.40252000E-03  -2.37150000E-04  +7.94341000E-03
   -9.43160000E-03  -3.86320000E-03  -1.16585000E-03  +3.41480000E-04  -7.90500000E-05
   -5.82700000E-05  +2.95000000E-04  -1.03280000E-04  +6.00900000E-05  -3.70930000E-04
   +3.67720000E-04  +3.16830000E-04  +1.19190000E-04  -1.51960000E-04  -1.93257000E-03
   -3.54280200E-02  -1.57089380E-01  -3.78627000E-03  -5.14081800E-02  +4.88158940E-01
   +2.09272000E-03  -7.12153000E-03  +5.55407000E-03  +5.51010000E-04  +4.78917000E-03
   -4.50837000E-03  -2.25352000E-03  +8.85730000E-04  +4.66523000E-03  +2.80700000E-05
   +9.43656000E-03  -2.21110000E-04  -1.95183100E-01  +1.34661350E-01  +1.98491000E-03
   -4.54161700E-02  +3.91786200E-02  +5.16403000E-03  +1.39469000E-03  -9.27920000E-04
   +4.40030000E-04  -9.59860000E-04  +6.64900000E-04  -4.91270000E-04  +5.68230540E-01
   -1.37101000E-03  -2.21347000E-03  +4.78757000E-03  +3.48125000E-03  -2.23190000E-04
   -1.72858000E-03  -5.83498000E-03  +1.95859000E-03  +6.45913000E-03  +4.13320300E-02
   -3.78356200E-02  +5.68409000E-03  +9.32765700E-02  -2.03746250E-01  +4.30829600E-02
   +7.32058000E-03  +7.37519000E-03  -3.96771000E-03  -1.10272000E-03  +7.55750000E-04
   -1.11121000E-03  +9.98200000E-04  -7.66610000E-04  +4.90320000E-04  -5.89048600E-02
   +3.10958800E-01  +2.27957000E-03  +7.74463000E-03  -7.97310000E-04  -3.03900000E-03
   -3.05301000E-03  +2.07592000E-03  +8.71072000E-03  +2.90129000E-03  +1.62143000E-03
   -1.86667500E-02  +2.26352800E-02  +6.63197000E-03  +2.59564700E-02  +2.11806100E-02
   -6.97831700E-02  +2.32692400E-02  -2.06516100E-02  +6.85950000E-03  -3.96510000E-04
   -3.52290000E-04  -2.50190000E-04  +1.38500000E-05  +2.76900000E-05  -6.54200000E-05
   -2.51298050E-01  -1.32798160E-01  +2.36751170E-01  -4.64870000E-04  -3.89870000E-04
   -7.75680000E-04  -3.61307700E-02  -3.91307000E-03  -2.83758000E-03  -4.83820000E-04
   +1.08276000E-03  -2.01246000E-03  -1.85640000E-04  +7.83690000E-04  +8.61240000E-04
   -3.12450000E-04  -2.30590000E-04  +4.19160000E-04  +1.85680000E-04  -8.71110000E-04
   +4.45770000E-04  -1.50341970E-01  -3.92015600E-02  -1.51949600E-02  -7.53480000E-04
   -3.82303000E-03  -5.62484000E-03  +2.68100000E-05  -3.28100000E-05  -7.69600000E-05
   +6.37369820E-01  +3.04525000E-03  -1.26624000E-03  +9.16800000E-04  +1.58490700E-02
   +1.23349500E-02  +2.53925000E-03  +9.08350000E-04  -2.58317000E-03  +1.06763000E-03
   +6.78150000E-04  -1.22605000E-03  -7.08530000E-04  -4.35900000E-05  +1.25446000E-03
   -5.34570000E-04  -2.18160000E-04  +2.80060000E-04  -3.77400000E-05  -3.72881000E-02
   -9.32918500E-02  -1.72840900E-02  -1.34388400E-02  -8.39114000E-03  -5.24609000E-03
   +9.08220000E-04  -9.70460000E-04  +7.18500000E-05  +9.29314200E-02  +3.17927430E-01
   -7.97220000E-04  +5.69230000E-04  +2.56450000E-04  +1.82209000E-03  +3.08374000E-03
   +5.34620000E-04  +2.57230000E-04  -1.01307000E-03  -2.09300000E-05  +2.16860000E-04
   -4.50350000E-04  -1.61240000E-04  +4.55400000E-05  +4.34500000E-04  -2.66580000E-04
   -3.90060000E-04  -2.58480000E-04  +3.06300000E-05  -1.08682400E-02  -1.63011200E-02
   -8.87676600E-02  -2.88033800E-02  -1.63669700E-02  -8.53091000E-03  +1.85360000E-04
   -2.25190000E-04  +1.24450000E-04  -1.19599510E-01  +1.66951100E-01  +5.32958560E-01
   +8.13600000E-04  -2.86810000E-04  +5.07630000E-04  -6.66450000E-04  -1.31601000E-03
   +1.13570000E-04  -8.49360000E-04  +8.26440000E-04  +2.74310000E-04  +1.67900000E-04
   -4.91710000E-04  +2.78290000E-04  +1.91130000E-04  +3.56140000E-04  -4.34500000E-04
   -3.71660000E-04  +4.15620000E-04  +2.14100000E-04  -2.24445000E-02  -1.54698000E-03
   +1.26807000E-02  -1.54597000E-03  -3.48180000E-04  +7.33630000E-04  +1.12750000E-04
   -1.65060000E-04  +2.13100000E-05  -2.94450430E-01  -1.74222400E-02  +1.08043760E-01
   +6.48205580E-01  +6.19700000E-04  -7.30800000E-05  +3.55320000E-04  -3.29220000E-04
   -1.91983000E-03  +2.74880000E-04  -6.54070000E-04  +6.85130000E-04  +1.42070000E-04
   +1.07510000E-04  -2.99750000E-04  +1.99030000E-04  +1.80510000E-04  +2.07470000E-04
   -2.52180000E-04  -2.44510000E-04  +4.04880000E-04  +1.03120000E-04  -1.19033000E-02
   +4.65702000E-03  +9.02687000E-03  -7.84670000E-04  -8.35990000E-04  +3.79380000E-04
   +3.17700000E-05  -5.37500000E-05  -1.12600000E-05  +1.68526400E-02  -9.27742000E-02
   -5.41874800E-02  +1.00487540E-01  +3.43845150E-01  -3.78600000E-04  +4.22960000E-04
   -7.10050000E-04  -2.61999000E-03  -1.08896000E-03  -3.33600000E-04  +8.10000000E-06
   +2.09990000E-04  -6.01700000E-05  -2.06480000E-04  +4.41260000E-04  +1.40630000E-04
   +5.58800000E-05  -3.19650000E-04  +1.96350000E-04  -1.78000000E-06  -3.03950000E-04
   +9.86700000E-05  -2.87676000E-03  +3.60356000E-03  +8.60172000E-03  -1.25768000E-03
   +2.74220000E-04  +1.76070000E-04  -3.37110000E-04  +3.12230000E-04  +1.04800000E-05
   +1.52181160E-01  -2.68067700E-02  -1.93955310E-01  -1.21549650E-01  +2.54199280E-01
   +5.88855080E-01  -1.91530000E-04  -9.45700000E-05  +2.02020000E-04  -2.77020000E-04
   -3.53760000E-04  -5.35200000E-05  -1.16400000E-05  +4.83000000E-06  -3.47500000E-05
   +3.47600000E-05  +2.77000000E-06  +5.48400000E-05  -3.45150000E-04  +1.88760000E-04
   +5.91500000E-05  +2.51920000E-04  +1.50950000E-04  -1.55240000E-04  -2.34810000E-04
   -1.94110000E-04  +3.14236000E-03  +6.36640000E-04  +5.31940000E-04  +5.77150000E-04
   +3.52010000E-04  -2.67390000E-04  -1.40700000E-05  -4.31384900E-02  -6.62835000E-03
   +2.11569000E-02  -2.37735000E-01  -1.09169990E-01  -5.38115300E-02  +6.66167100E-01
   -9.88720000E-04  -2.81730000E-04  +6.55000000E-05  -1.64099000E-03  -1.43217000E-03
   -5.25600000E-04  +5.17950000E-04  -1.19400000E-05  -8.13080000E-04  -2.31080000E-04
   +8.69780000E-04  -1.93160000E-04  +3.68250000E-04  -1.07064000E-03  +5.04360000E-04
   +2.77470000E-04  -2.97910000E-04  -1.33940000E-04  +2.28850000E-04  +5.70295000E-03
   -3.46067000E-03  -8.52120000E-04  -3.42060000E-04  -2.47000000E-05  -8.74590000E-04
   +9.08470000E-04  -8.69100000E-05  -2.80588600E-02  +2.99849100E-02  +5.60003500E-02
   -5.00160300E-02  -1.15644590E-01  -7.28959200E-02  +1.31071460E-01  +3.00798690E-01
   +4.97700000E-05  +1.88820000E-04  -2.49660000E-04  +3.86470000E-04  -4.51400000E-05
   -3.93100000E-05  +2.04230000E-04  -1.77080000E-04  -5.32400000E-05  -1.15290000E-04
   +2.73490000E-04  -6.49200000E-05  +1.64890000E-04  -3.29360000E-04  +1.22470000E-04
   +1.49300000E-05  -1.00160000E-04  +4.91000000E-06  +2.89379000E-03  -3.30029000E-03
   +8.89400000E-05  -7.82480000E-04  -5.06430000E-04  -9.04900000E-05  -3.18480000E-04
   +2.91820000E-04  +8.07000000E-06  +3.37695000E-03  +1.78285400E-02  +2.81204600E-02
   -2.22499600E-02  -4.85643600E-02  -1.10862720E-01  -3.68352200E-02  +2.11939650E-01
   +4.67759180E-01  -1.29310000E-04  -1.36900000E-04  +8.93000000E-05  -1.29860000E-04
   +5.47620000E-04  +8.43500000E-05  +1.06580000E-04  -3.35010000E-04  +6.10100000E-05
   +1.45240000E-04  -2.60520000E-04  +8.22000000E-05  -8.61180000E-04  +7.37510000E-04
   -1.31000000E-06  +4.07960000E-04  +1.73970000E-04  -2.39110000E-04  -2.81444000E-03
   -6.59660000E-04  +1.51040000E-04  +5.31980000E-04  -1.11440000E-04  -2.78110000E-04
   +9.94180000E-04  -8.92780000E-04  -1.57000000E-05  -1.17150900E-02  +1.72776200E-02
   +3.14008700E-02  +3.06267400E-02  +3.71789000E-03  -3.41625800E-02  -9.14011200E-02
   -5.67188600E-02  -5.52706000E-03  +6.88826160E-01  +1.17520000E-04  -1.74080000E-04
   +8.74200000E-05  +3.30960000E-04  +1.04672000E-03  +2.10820000E-04  -3.39100000E-05
   -8.77600000E-05  +2.00300000E-04  +1.36260000E-04  -4.29720000E-04  +3.00600000E-05
   -3.56580000E-04  +5.92560000E-04  -1.46130000E-04  +3.80300000E-05  +9.90300000E-05
   -4.89300000E-05  -9.07900000E-05  -1.22005000E-03  -5.78510000E-04  +3.05710000E-04
   +7.07100000E-05  -1.28260000E-04  +5.97100000E-04  -5.82780000E-04  +9.21000000E-06
   +1.19936800E-02  -1.12090700E-02  -1.41768200E-02  -2.68755300E-02  -1.48668300E-02
   -1.24784300E-02  +8.75176000E-03  -1.06134700E-01  -7.13412100E-02  +1.81742730E-01
   +3.92549750E-01  +3.17540000E-04  -1.64200000E-04  +2.59210000E-04  +8.74900000E-04
   +1.11892000E-03  +2.17670000E-04  -2.97530000E-04  +3.72700000E-05  +3.26400000E-04
   +2.36730000E-04  -5.95970000E-04  +2.20200000E-05  -6.09600000E-05  +5.54630000E-04
   -3.16060000E-04  -1.69710000E-04  +1.65920000E-04  +5.64500000E-05  +9.15590000E-04
   -6.93860000E-04  -1.72610000E-03  +1.89100000E-04  -1.06680000E-04  -1.27880000E-04
   +4.13590000E-04  -4.31430000E-04  +1.14300000E-05  +2.32584200E-02  -1.64744300E-02
   -4.13932300E-02  -5.38177000E-02  -1.74521900E-02  +2.82662000E-03  +3.38057500E-02
   -8.80364600E-02  -1.79166290E-01  -7.50479500E-02  +1.40579090E-01  +4.93725720E-01
   +4.70960000E-04  -8.75800000E-05  +2.55120000E-04  +5.68010000E-04  +3.00860000E-04
   +2.71600000E-05  -3.56190000E-04  +3.31450000E-04  +2.15530000E-04  +1.34850000E-04
   -3.25310000E-04  +3.19000000E-06  +4.64280000E-04  +1.41000000E-05  -2.70430000E-04
   -4.86790000E-04  +1.34200000E-04  +2.57210000E-04  +3.60486000E-03  +1.90790000E-04
   +1.49604000E-03  +3.40140000E-04  +1.63710000E-04  +3.39790000E-04  -3.00120000E-04
   +2.29620000E-04  +3.44600000E-05  +2.67203700E-02  -3.30597000E-02  -6.40846100E-02
   -5.18868700E-02  -1.82774500E-02  +1.37786300E-02  +2.21628100E-02  +3.99454700E-02
   +3.46891200E-02  -1.86208030E-01  -5.04527000E-03  +5.88302900E-02  +6.34576980E-01
   +2.07420000E-04  +1.86930000E-04  +1.15980000E-04  +5.23650000E-04  -2.27880000E-04
   +3.48540000E-04  -3.02570000E-04  +2.63910000E-04  +2.43740000E-04  -2.33000000E-06
   -1.14600000E-04  +4.59200000E-05  -6.25800000E-05  +1.20130000E-04  -1.06970000E-04
   -1.37040000E-04  +1.69850000E-04  +1.38890000E-04  +1.18674000E-03  +1.72546000E-03
   -3.58487000E-03  -8.99400000E-04  -2.55640000E-04  +1.67300000E-05  +6.49500000E-05
   -4.59800000E-05  +1.84800000E-05  -1.17153000E-02  -1.24533000E-02  -2.81733700E-02
   -1.34861900E-02  -3.97742000E-03  +3.04500000E-03  +1.96740500E-02  +7.65278000E-03
   +4.81200000E-05  +9.40407000E-03  -9.18638300E-02  -4.30691900E-02  +1.71788890E-01
   +3.41292940E-01  -6.63800000E-05  +2.50970000E-04  -2.25600000E-05  +6.88420000E-04
   -1.43690000E-04  +1.10590000E-04  +5.60100000E-05  -3.84200000E-05  +1.62460000E-04
   -9.01400000E-05  +9.14400000E-05  +3.18800000E-05  -2.76820000E-04  +9.24800000E-05
   +6.81300000E-05  +1.86930000E-04  -4.60300000E-05  -1.18090000E-04  +1.78943000E-03
   -3.52322000E-03  -3.55480000E-03  -1.30175000E-03  -5.98910000E-04  -1.29800000E-05
   +2.12680000E-04  -1.92500000E-04  -8.13000000E-06  -2.99975300E-02  -1.23282600E-02
   +2.94243000E-03  +9.65342000E-03  +4.25992000E-03  -5.58014000E-03  +2.28836500E-02
   -2.32993600E-02  -2.30619400E-02  +9.57432000E-02  -2.05760400E-02  -1.77164290E-01
   -2.91537000E-02  +2.56184300E-01  +5.80994790E-01  -9.23500000E-04  +1.51870000E-04
   -5.90270000E-04  -6.24040000E-04  -2.06732000E-03  -2.29026000E-03  +5.52130000E-04
   -3.11740000E-04  -4.80880000E-04  -1.39630000E-04  +5.32340000E-04  +9.93600000E-05
   -1.47250000E-04  -2.35660000E-04  +2.51070000E-04  +3.47470000E-04  -1.52950000E-04
   -1.35150000E-04  -2.18147000E-03  -1.54716200E-02  -2.57816300E-02  -5.77509000E-03
   -2.61474000E-03  +6.09600000E-05  -1.04160000E-04  +1.34150000E-04  -4.69000000E-06
   -1.20891330E-01  -6.41500000E-04  +2.70447400E-02  +3.07999500E-02  +2.37564500E-02
   +1.73566200E-02  -9.51497000E-03  -2.60808300E-02  -1.02908400E-02  -5.13815500E-02
   -6.06175000E-03  +1.96457700E-02  -3.21489230E-01  -1.38933980E-01  -8.10579200E-02
   +7.19698230E-01  +1.11770000E-04  -3.84010000E-04  +6.70950000E-04  +6.75110000E-04
   -1.52800000E-05  -2.89700000E-04  -7.45200000E-05  +6.32600000E-05  +6.64400000E-05
   +1.33490000E-04  -1.13060000E-04  -6.16600000E-05  +6.90100000E-05  -2.07900000E-05
   -1.10800000E-04  -9.02000000E-06  +2.30940000E-04  -1.07290000E-04  -5.84297000E-03
   -8.35201000E-03  -1.28351600E-02  -2.15312000E-03  +6.57900000E-05  +3.48930000E-04
   -6.69000000E-06  +3.62200000E-05  -3.02200000E-05  -3.50688600E-02  -1.27277220E-01
   -7.63269000E-02  +4.03090000E-02  +1.51973400E-02  -2.21362500E-02  -1.26413600E-02
   -3.24071400E-02  -1.39901400E-02  -2.57180500E-02  +1.47968500E-02  +3.65427100E-02
   -1.05908870E-01  -1.42718980E-01  -7.60027700E-02  +1.47299410E-01  +3.19277660E-01
   -8.86570000E-04  -8.70350000E-04  -9.50800000E-05  -7.64990000E-04  -6.57370000E-04
   -6.33320000E-04  +5.96720000E-04  -1.62300000E-04  -7.30300000E-04  +1.17030000E-04
   -1.28600000E-05  -2.79940000E-04  +1.04660000E-04  -2.18220000E-04  +1.63940000E-04
   +2.65920000E-04  -2.41000000E-05  -1.63340000E-04  -8.66251000E-03  -4.98646000E-03
   -3.72394000E-03  +1.44300000E-04  -7.93600000E-05  +4.52390000E-04  -8.45400000E-05
   +1.11940000E-04  -7.03600000E-05  -2.74947100E-02  -9.44115400E-02  -2.17376510E-01
   +5.41200700E-02  -1.86374000E-03  -3.75246000E-02  -1.90951800E-02  -3.01472800E-02
   -2.23912600E-02  -1.29436000E-02  +2.46175500E-02  +4.89332600E-02  -2.67672000E-02
   -5.74246000E-02  -1.39418410E-01  -8.43155900E-02  +1.98730200E-01  +5.33732310E-01
   -1.67200000E-05  +1.20230000E-04  -8.77300000E-05  -1.84530000E-04  -1.06167000E-03
   -2.45870000E-04  -5.24000000E-06  +3.05720000E-04  -2.56820000E-04  -1.81910000E-04
   +4.60380000E-04  -8.95900000E-05  +8.65580000E-04  -9.12580000E-04  +9.76100000E-05
   -3.56910000E-04  -1.58310000E-04  +2.13290000E-04  +1.90816000E-03  +1.05787000E-03
   +5.84110000E-04  -6.88120000E-04  -1.07400000E-05  +2.93560000E-04  -1.12407000E-03
   +1.03332000E-03  +6.47000000E-06  +3.46585000E-03  -7.62579000E-03  -1.34906300E-02
   -8.24163000E-03  -8.43527000E-03  +6.33120000E-03  -3.45106300E-02  +9.34188000E-03
   -3.40143600E-02  -3.41697520E-01  -1.64952430E-01  -4.51407500E-02  -6.32212600E-02
   -2.95513700E-02  +2.70452000E-03  +8.48305000E-03  +8.73203000E-03  +1.45864800E-02
   +4.27737350E-01  -9.75800000E-05  +1.32120000E-04  +5.51000000E-06  -1.02940000E-04
   -9.00570000E-04  -2.72610000E-04  -2.05700000E-05  +2.13940000E-04  -2.02530000E-04
   -1.07080000E-04  +3.81170000E-04  -5.81500000E-05  +5.13670000E-04  -6.40550000E-04
   +9.70400000E-05  -2.06040000E-04  -7.69500000E-05  +1.54450000E-04  +1.10941000E-03
   +4.33830000E-04  +8.57650000E-04  -4.52660000E-04  -6.22500000E-05  +2.03580000E-04
   -7.42200000E-04  +7.34110000E-04  +5.21000000E-06  +7.42800000E-04  -3.61118000E-03
   -4.99351000E-03  -3.27804000E-03  -1.08250000E-03  -1.50592000E-03  -4.10079100E-02
   +3.50067000E-03  -3.75271100E-02  -1.53422600E-01  -1.71104530E-01  -3.88557400E-02
   -2.20528700E-02  +1.03979800E-02  +4.10671000E-03  +3.72236000E-03  +6.69019000E-03
   +2.49660000E-04  +2.12582570E-01  +1.77510880E-01  +4.76200000E-05  +8.58700000E-05
   -1.25580000E-04  -1.74090000E-04  -2.10410000E-04  +6.70400000E-05  +7.09700000E-05
   -1.73000000E-06  -1.44900000E-05  -8.44000000E-05  +1.28140000E-04  +2.07900000E-05
   +6.71000000E-05  -1.42350000E-04  +4.03900000E-05  +8.43000000E-06  -4.28300000E-05
   +1.35400000E-05  -3.11360000E-04  +2.48930000E-04  +4.00840000E-04  -1.79000000E-06
   -1.32700000E-05  -2.96400000E-05  -1.27520000E-04  +1.16610000E-04  +2.45500000E-05
   -3.23020000E-03  +3.62956000E-03  +6.27225000E-03  +1.05208300E-02  -1.25952000E-03
   -5.33227000E-03  -3.26065500E-02  -3.52936300E-02  -1.32627800E-02  -5.96170000E-02
   -4.20316000E-02  -1.01179220E-01  +2.80062400E-02  +1.40445100E-02  +1.84468200E-02
   -3.25700000E-04  -7.69773000E-03  -7.71924000E-03  +8.99421800E-02  +6.58960600E-02
   +1.25425550E-01  -7.35300000E-05  -2.42700000E-05  -1.61870000E-04  -1.41060000E-04
   -6.39180000E-04  -1.19970000E-04  +1.31210000E-04  +7.92500000E-05  -2.28440000E-04
   -1.05900000E-04  +3.19600000E-04  -1.08340000E-04  +5.44250000E-04  -6.00860000E-04
   +1.21030000E-04  -1.41510000E-04  -1.45520000E-04  +9.16800000E-05  +3.20230000E-04
   +3.56700000E-04  +1.56071000E-03  -3.38270000E-04  +6.39500000E-05  +4.76400000E-05
   -7.11480000E-04  +6.37750000E-04  -2.73300000E-05  -3.85223000E-03  +2.65830000E-04
   +2.73873000E-03  -3.32887300E-02  +1.38578200E-02  +2.05134600E-02  -2.18497890E-01
   +2.05851700E-02  +1.08696000E-01  -3.49631100E-02  +9.81830000E-04  +1.58445000E-03
   +7.05525000E-03  +9.33170000E-04  -3.72829000E-03  -5.38535000E-03  -3.72598000E-03
   -1.56736000E-03  +2.35101600E-02  +4.35420000E-04  -1.07205000E-02  +5.52251590E-01
   +6.67100000E-05  +5.39800000E-05  +6.57500000E-05  +1.73300000E-05  -6.91200000E-05
   +5.63500000E-05  -1.08450000E-04  +7.41500000E-05  +7.70600000E-05  +2.92100000E-05
   -6.39300000E-05  +4.20400000E-05  -8.22700000E-05  +1.11190000E-04  -4.99100000E-05
   -1.80600000E-05  +7.38000000E-05  +2.62800000E-05  -6.44380000E-04  +1.96920000E-04
   +5.13870000E-04  +2.36940000E-04  -3.34500000E-05  +6.00800000E-05  +1.10100000E-04
   -8.40900000E-05  +1.16500000E-05  -5.52200000E-04  -2.22609000E-03  -7.73464000E-03
   -2.10233900E-02  +6.92993000E-03  +1.41040300E-02  +1.66206600E-02  -5.78289300E-02
   -5.07616100E-02  +1.70223500E-02  -5.65022000E-03  -6.12049000E-03  -3.25407000E-03
   +2.34863000E-03  -3.03802000E-03  +1.92162000E-03  +1.58852000E-03  +1.87660000E-03
   +2.01485000E-03  -1.32684000E-03  -3.70821000E-03  +7.02212500E-02  +1.33463070E-01
   +6.41400000E-05  +4.64300000E-05  +5.56300000E-05  +2.53950000E-04  +2.12120000E-04
   +1.30900000E-04  -6.19800000E-05  +9.69000000E-06  +1.32910000E-04  +3.45500000E-05
   -1.42800000E-04  +5.34100000E-05  -1.96750000E-04  +2.46240000E-04  -6.77100000E-05
   +3.27100000E-05  +7.81800000E-05  -2.01500000E-05  -3.59510000E-04  -7.62690000E-04
   +7.01570000E-04  +2.35910000E-04  +1.05180000E-04  -1.00200000E-05  +2.76810000E-04
   -2.41970000E-04  +2.59000000E-05  -1.09916000E-03  -4.06113000E-03  -8.83670000E-04
   -4.67026000E-03  +4.66544000E-03  +9.99985000E-03  +4.97063400E-02  -4.82028100E-02
   -1.34062580E-01  +4.16074000E-02  -1.65525800E-02  -2.25794700E-02  -4.10134000E-03
   -7.08328000E-03  -2.59884000E-03  +1.26676000E-03  +1.64333000E-03  +5.61100000E-05
   +2.90984000E-03  +1.95904000E-03  -6.32440000E-04  +8.15553900E-02  +1.70080070E-01
   +3.57205140E-01  -4.50209000E-03  +2.76144000E-03  +1.12212000E-03  +4.18031000E-03
   +1.92326200E-02  -1.78314400E-02  -1.56954000E-03  +1.43716000E-03  -7.16410000E-04
   +2.18400000E-04  +5.30520000E-04  -5.48300000E-04  +3.86140000E-04  -3.44280000E-04
   +7.27300000E-05  +4.96440000E-04  +1.18926000E-03  -5.51440000E-04  -7.73310600E-02
   -1.15827800E-02  +1.11745400E-02  +2.29080000E-04  -8.86830000E-04  +2.06005000E-03
   -5.60650000E-04  +5.21270000E-04  +1.99200000E-05  -1.12123400E-02  -2.42339800E-02
   +2.01946100E-02  -3.19860000E-04  -1.64196000E-03  -1.30638000E-03  -1.02940000E-03
   +2.84910000E-04  -1.38392000E-03  +5.76290000E-04  +7.21030000E-04  +1.19550000E-03
   +4.52900000E-05  +3.40130000E-04  +2.87660000E-04  -3.97240000E-04  -8.40660000E-04
   +4.69350000E-04  -1.07988000E-03  -7.96320000E-04  -2.16970000E-04  -6.66320000E-04
   +1.33790000E-04  -1.00930000E-04  +5.85466640E-01  +3.41818000E-03  -9.36890000E-04
   -3.31820000E-04  +1.76304000E-03  -2.17716600E-02  +1.68295300E-02  +4.63030000E-04
   -6.60970000E-04  -6.28470000E-04  -7.96080000E-04  -5.36180000E-04  +5.35200000E-04
   +1.38550000E-04  +2.58800000E-05  +9.14600000E-05  -5.45770000E-04  -7.26410000E-04
   +5.17620000E-04  -7.29974000E-03  -1.27380800E-01  +4.95244600E-02  +1.56831000E-03
   +8.74630000E-03  -4.97024000E-03  -1.05300000E-05  -4.62600000E-05  +1.29500000E-05
   -1.24698200E-02  -1.77971100E-02  +1.05323200E-02  +1.85673000E-03  -7.95050000E-04
   -6.36790000E-04  -5.65100000E-04  +1.25700000E-05  -6.76630000E-04  -2.02400000E-05
   +2.78020000E-04  +4.83260000E-04  +1.33650000E-04  +4.47290000E-04  +2.13790000E-04
   -1.48230000E-04  -3.04350000E-04  +5.96070000E-04  -1.40620000E-04  -1.50730000E-04
   -8.75300000E-05  -3.78100000E-05  +4.93900000E-05  -9.61800000E-05  -1.13400500E-02
   +5.14970700E-01  +1.12296000E-03  -7.09100000E-04  +7.75700000E-05  -3.57250000E-03
   +1.30233000E-03  +6.30130000E-04  +9.17320000E-04  -9.39220000E-04  -1.64090000E-04
   +1.17260000E-04  -5.78500000E-05  -1.17590000E-04  -1.97940000E-04  +5.28000000E-05
   +2.39220000E-04  +3.29830000E-04  -3.02810000E-04  +1.47970000E-04  +7.15571000E-03
   +4.59702900E-02  -1.19791550E-01  +5.91556000E-03  +2.33012600E-02  -3.50848000E-02
   +2.40310000E-04  -2.02340000E-04  -3.34200000E-05  +4.95000000E-03  +9.52100000E-05
   +5.30067000E-03  -6.57910000E-04  -2.93840000E-04  -3.77280000E-04  -5.08480000E-04
   -1.32100000E-04  -7.08740000E-04  +1.77680000E-04  +4.16710000E-04  +1.29147000E-03
   +6.39200000E-04  +2.44000000E-06  -2.10120000E-04  -1.88648000E-03  -9.55260000E-04
   -1.05250000E-04  -6.71590000E-04  -5.18360000E-04  -2.54070000E-04  -1.56070000E-04
   -2.34100000E-05  -8.38300000E-05  +7.14650000E-03  +6.25049400E-02  +5.37602820E-01
   -1.85600000E-04  -2.08200000E-05  -1.30200000E-04  -1.78890000E-04  -2.36540000E-04
   -1.15780000E-04  +1.68850000E-04  -3.11500000E-05  -1.63840000E-04  -9.27000000E-05
   +2.55200000E-04  -7.32100000E-05  +2.52850000E-04  -3.85350000E-04  +1.24110000E-04
   -6.77000000E-06  -1.20550000E-04  +1.25600000E-05  +2.18410000E-04  +5.24500000E-05
   +4.07160000E-04  -1.85830000E-04  -8.41000000E-06  -1.18400000E-05  -3.84960000E-04
   +3.67490000E-04  -9.01000000E-06  -5.68855000E-03  +6.08821000E-03  +1.03884500E-02
   +1.62113300E-02  +6.86284000E-03  -1.85961000E-03  -6.27138000E-03  -3.84838200E-02
   +2.78687700E-02  -2.89258600E-02  -2.27301400E-02  -8.61269000E-03  +1.35229800E-02
   +1.15972000E-03  -3.63078000E-03  -6.47582000E-03  -6.74057000E-03  -7.02564000E-03
   +2.28916400E-02  +3.03525200E-02  -2.04170900E-02  +2.68048000E-03  +9.04463000E-03
   -5.37321000E-03  -3.41970000E-04  -1.26850000E-04  -1.73600000E-04  +3.62256460E-01
   -6.37380000E-04  -3.46100000E-05  +7.92400000E-05  -1.28280000E-04  -9.58830000E-04
   -4.09990000E-04  +2.13680000E-04  +1.49770000E-04  -4.54370000E-04  -1.18650000E-04
   +6.10480000E-04  -2.10220000E-04  +5.18370000E-04  -8.99840000E-04  +3.02170000E-04
   -4.00400000E-05  -1.78030000E-04  +8.38100000E-05  +1.01116000E-03  +3.15660000E-04
   +1.04216000E-03  -6.38880000E-04  -9.53900000E-05  +1.13170000E-04  -9.01890000E-04
   +9.47980000E-04  -5.52000000E-05  -9.95881000E-03  +8.63509000E-03  +1.72114400E-02
   +2.56545400E-02  +1.08085200E-02  -2.54166000E-03  -1.44400600E-02  -7.65298600E-02
   +4.25127900E-02  -2.48894000E-02  -2.28791700E-02  -2.02205000E-03  +1.42125000E-02
   +1.45305000E-03  -5.55865000E-03  -1.02650400E-02  -1.04977000E-02  -1.05768100E-02
   +1.74771900E-02  +1.29614500E-02  +5.04306000E-03  -3.91319000E-03  +7.77359000E-03
   -4.19032000E-03  -9.93470000E-04  -2.90690000E-04  -5.10130000E-04  -7.94146000E-02
   +1.20035740E-01  +3.93250000E-04  -6.28000000E-06  -1.36790000E-04  +1.42700000E-05
   +5.85530000E-04  +2.67660000E-04  -9.19000000E-06  -1.68810000E-04  +2.17880000E-04
   +3.39200000E-05  -2.67790000E-04  +9.91800000E-05  -2.40550000E-04  +4.02690000E-04
   -1.32200000E-04  +4.73900000E-05  +8.25300000E-05  -2.05400000E-05  -7.77310000E-04
   -4.07180000E-04  -4.53290000E-04  +3.63820000E-04  +8.54200000E-05  -1.73880000E-04
   +4.28850000E-04  -4.48670000E-04  +4.86500000E-05  +2.38777000E-03  -3.53200000E-04
   -1.35878000E-03  -3.72952000E-03  -3.22810000E-04  -5.78240000E-04  +1.09935500E-02
   +8.80238000E-03  +3.04740000E-04  -2.12851800E-02  +3.36809000E-03  -1.98778700E-02
   +4.19650000E-04  +3.24490000E-04  +8.09930000E-04  +6.50430000E-04  +6.22610000E-04
   +1.40097000E-03  +9.76548000E-03  +3.83008800E-02  -2.76206500E-02  -6.50378000E-03
   -1.02831000E-03  +5.07425000E-03  +5.35440000E-04  +1.23420000E-04  +3.25760000E-04
   -1.05928030E-01  +4.85725000E-03  +6.20369660E-01  -3.88150000E-04  -9.71540000E-04
   +1.60096000E-03  +6.50960000E-04  +1.77800000E-04  -3.15870000E-04  -1.12096000E-03
   -1.58660000E-04  +3.11320000E-04  +4.69887000E-03  -3.39130000E-03  -1.01135000E-03
   -3.23215600E-02  -8.29535000E-03  +2.04881400E-02  -1.26899000E-03  +5.34626000E-03
   -1.23511000E-03  -1.41440000E-04  +1.55840000E-04  -1.44180000E-04  +1.36760000E-04
   -9.69700000E-05  +6.22500000E-05  -3.29659300E-01  -7.94063700E-02  +2.17888990E-01
   +3.04600000E-05  -1.62770000E-04  -4.70800000E-05  -3.65900000E-05  -2.02700000E-05
   +4.81400000E-05  -6.72100000E-05  +1.75980000E-04  +5.71000000E-05  -1.78040000E-04
   -1.06040000E-04  -6.84300000E-05  +4.58800000E-05  -2.58000000E-05  -3.65500000E-05
   +5.33000000E-06  +4.89000000E-06  +5.04300000E-05  +2.00520000E-04  +1.17800000E-04
   +1.70000000E-05  +1.37720000E-04  -3.07100000E-05  -5.91500000E-05  +7.87100000E-05
   -8.59000000E-06  -1.96500000E-05  +7.25400000E-05  +1.55060000E-04  -7.87500000E-05
   +3.59066030E-01  +6.17460000E-04  +1.51999000E-03  -2.40970000E-04  -4.36140000E-04
   -3.28500000E-04  +4.62950000E-04  +1.61680000E-04  -6.02220000E-04  -1.34470000E-04
   +1.96811000E-03  +1.17427000E-03  -2.23965000E-03  +3.08344700E-02  +5.37757000E-03
   -2.08393000E-02  +4.04316000E-03  -3.74514000E-03  +1.26908000E-03  -2.74500000E-05
   -9.69600000E-05  +4.21100000E-05  -1.78600000E-05  +1.17400000E-05  -2.99000000E-06
   -1.21639100E-01  -7.61653600E-02  +1.06066200E-01  +1.68300000E-05  +5.78700000E-05
   +4.53500000E-05  +1.61800000E-05  -3.12000000E-06  -2.54700000E-05  +3.27400000E-05
   -8.16800000E-05  -3.54900000E-05  +1.13610000E-04  +6.59700000E-05  +3.98700000E-05
   -3.33600000E-05  +2.62000000E-06  +2.66500000E-05  +7.10000000E-07  -4.40000000E-07
   -4.71000000E-06  -1.20630000E-04  -8.47500000E-05  -1.83600000E-05  -7.10200000E-05
   +6.78000000E-06  +2.32900000E-05  -3.25800000E-05  +3.66800000E-05  -7.89000000E-06
   -4.26900000E-05  -9.93200000E-05  +4.03800000E-05  +8.55593700E-02  +7.40375500E-02
   +7.11430000E-04  +5.62580000E-04  +9.34730000E-04  -7.96400000E-05  +1.32990000E-04
   -3.73600000E-05  +1.43360000E-04  +3.06100000E-05  -7.90630000E-04  -4.10604000E-03
   +5.92010000E-04  +9.17100000E-04  -2.11593000E-03  -1.75570000E-04  -1.31166000E-03
   -5.62360000E-04  +6.09690000E-04  +2.12766000E-03  +9.33100000E-05  -4.27100000E-05
   +2.83300000E-05  -5.85700000E-05  +6.64200000E-05  -3.37800000E-05  +2.42340540E-01
   +8.37635700E-02  -1.80185240E-01  +3.52800000E-05  +2.56400000E-05  -1.12600000E-05
   -1.36000000E-05  -1.24000000E-05  -1.06000000E-05  -1.20000000E-07  -8.20000000E-06
   -1.57200000E-05  +2.87500000E-05  +2.12800000E-05  +2.40000000E-05  -1.19800000E-05
   -4.70000000E-06  +7.30000000E-06  -2.09700000E-05  +2.73000000E-06  +2.21500000E-05
   -3.65800000E-05  -3.30800000E-05  -1.98900000E-05  -8.46000000E-06  -6.54000000E-06
   -5.88000000E-06  -3.12300000E-05  +8.50000000E-07  +2.14500000E-05  -7.85000000E-06
   -1.79700000E-05  -2.91000000E-06  -2.36693940E-01  -8.55127000E-02  +1.78733030E-01
   +1.16190000E-04  +2.65970000E-04  -7.58050000E-04  -3.06560000E-04  +4.99541000E-03
   +9.23230000E-04  -1.50661000E-02  -6.17982000E-03  +1.26345600E-02  -2.44977050E-01
   -3.17016500E-02  +1.30456210E-01  -2.92806000E-03  +4.11023000E-03  +1.43545000E-03
   +2.49724000E-03  +1.44030000E-04  +1.62582000E-03  -2.51720000E-04  -6.63710000E-04
   +6.78280000E-04  -2.04720000E-04  +1.31330000E-04  -1.00990000E-04  +2.32022000E-03
   -1.42680000E-03  -2.57914000E-03  +1.14900000E-05  +2.36110000E-04  +1.03630000E-04
   -4.25500000E-05  -5.01800000E-05  -6.88100000E-05  +3.46400000E-05  -7.38100000E-05
   -3.47200000E-05  +1.29600000E-04  +7.42200000E-05  +5.43800000E-05  -5.12900000E-05
   -1.10200000E-05  +1.56600000E-05  -3.13100000E-05  +5.91000000E-06  +3.72700000E-05
   -1.45180000E-04  -9.75400000E-05  -2.74100000E-05  -7.82900000E-05  +3.29000000E-06
   +2.11400000E-05  -5.95600000E-05  -7.72900000E-05  +3.04500000E-05  -3.79000000E-05
   -9.08300000E-05  +4.23000000E-05  +1.40400000E-05  -1.14213000E-03  +9.53920000E-04
   +2.59276670E-01  +5.63360000E-04  -1.49510000E-03  -7.41000000E-06  +4.35576000E-03
   -1.22950000E-03  +2.24971000E-03  +1.86076400E-02  +7.38041000E-03  -1.28775300E-02
   -3.17938700E-02  -6.18395300E-02  +3.36994500E-02  -2.22213800E-02  +9.35650000E-04
   +1.36743200E-02  +6.73410000E-04  -3.19347000E-03  +4.76238000E-03  +6.55370000E-04
   +5.79720000E-04  -3.38910000E-04  +8.37200000E-05  -1.05500000E-05  +7.97100000E-05
   -2.06905000E-03  +1.50230000E-03  -2.15685000E-03  +1.64960000E-04  -2.89080000E-04
   -8.08500000E-05  +9.86000000E-06  +1.35500000E-05  +4.03900000E-05  -1.00000000E-06
   +8.98500000E-05  +1.04200000E-05  -4.67700000E-05  -4.40500000E-05  -4.72400000E-05
   -1.72000000E-06  +8.16000000E-06  -7.59000000E-06  +8.04000000E-06  -4.12000000E-06
   +2.10300000E-05  +6.61400000E-05  +4.62200000E-05  +3.78000000E-06  +3.88800000E-05
   -4.98000000E-06  -1.96000000E-05  -4.08800000E-05  +7.86800000E-05  -5.49800000E-05
   +2.03600000E-05  +6.90800000E-05  -4.35500000E-05  +1.25737000E-03  -9.41530000E-04
   +2.08020000E-04  +3.22017500E-02  +5.87815900E-02  -9.86900000E-04  +1.77740000E-04
   -6.13100000E-04  +1.05536000E-03  +1.98418000E-03  +5.07152000E-03  -1.63160000E-03
   +2.15440000E-04  +2.84933000E-03  +1.30593410E-01  +3.37068000E-02  -1.21155920E-01
   +1.66564900E-02  -3.38430000E-04  -4.33842000E-03  +1.28863000E-03  +5.08892000E-03
   +2.09787000E-03  +7.30000000E-06  +1.83730000E-04  +3.13420000E-04  -1.18200000E-05
   +8.54900000E-05  +1.14400000E-05  -2.23038000E-03  -2.46904000E-03  -1.51197000E-03
   +1.47810000E-04  -1.30770000E-04  -2.18200000E-05  -2.06000000E-05  -2.51400000E-05
   +3.03100000E-05  -1.54800000E-05  +7.88100000E-05  +1.97600000E-05  -4.56600000E-05
   -4.01800000E-05  -3.57200000E-05  -3.63000000E-06  -6.96000000E-06  -1.78800000E-05
   -5.94000000E-06  -4.99000000E-06  +3.36200000E-05  +6.05200000E-05  +3.31200000E-05
   +3.98000000E-06  +4.32100000E-05  -1.31300000E-05  -2.50100000E-05  +2.52000000E-06
   -3.86300000E-05  -6.21300000E-05  +2.57500000E-05  +4.92700000E-05  -2.63800000E-05
   -4.28670000E-04  +1.47602000E-03  -6.45900000E-05  -1.43507090E-01  -3.78003400E-02
   +1.20519360E-01  -3.53018000E-03  +5.62220000E-04  +5.10110000E-03  +2.71849000E-03
   -2.18714300E-02  +1.35748700E-02  -6.12825400E-02  -2.95802900E-02  +2.91477000E-02
   +6.33354000E-03  +1.99368200E-02  -1.29485100E-02  -1.64695000E-03  +4.30225000E-03
   +2.37858000E-03  -1.27667000E-03  +3.48580000E-04  -1.62470000E-04  +4.18300000E-04
   -1.44967000E-03  -1.40588000E-03  +2.89360000E-04  +3.60000000E-07  -6.28600000E-05
   -3.69700000E-05  +1.19503000E-03  -6.71990000E-04  -1.58340000E-04  +1.53960000E-04
   -1.83060000E-04  -2.73900000E-05  +3.01300000E-05  -4.53500000E-05  -7.83000000E-06
   +9.42600000E-05  +2.11600000E-05  -8.88700000E-05  -5.47700000E-05  +7.59000000E-06
   +4.80900000E-05  +1.52300000E-05  -6.91900000E-05  -6.50300000E-05  +9.15100000E-05
   +1.23210000E-04  +9.83000000E-05  +7.84100000E-05  -1.56300000E-05  +7.42600000E-05
   -7.27000000E-06  -2.80300000E-05  -9.31780000E-04  +3.87280000E-04  +5.74500000E-04
   +3.56600000E-05  +1.52970000E-04  -8.62800000E-05  +1.62590000E-04  -3.53700000E-05
   -8.56900000E-05  +8.30000000E-07  -1.17196000E-03  -1.53860000E-03  +6.00867200E-02
   +3.83080000E-04  +2.53446000E-03  +2.34809000E-03  -4.48970000E-04  +1.08010000E-04
   +2.77463000E-03  -2.98767300E-02  -2.45785330E-01  +1.36134980E-01  -4.56012000E-03
   -1.38600100E-02  +1.23899500E-02  +4.58270000E-03  +8.49510000E-04  +1.49117000E-03
   +2.03700000E-04  +1.14660000E-04  -8.78440000E-04  -4.37890000E-04  -1.68711000E-03
   -1.17115000E-03  +2.47460000E-04  -2.20080000E-04  -4.89000000E-05  +1.90350000E-04
   -1.23481000E-03  +6.44830000E-04  -2.05780000E-04  +3.23980000E-04  +2.67080000E-04
   -6.46900000E-05  -5.85000000E-05  -1.03930000E-04  -1.60900000E-05  -1.32400000E-05
   -2.85700000E-05  +3.05900000E-05  +5.73100000E-05  +8.29500000E-05  +3.48200000E-05
   -1.65800000E-05  -5.04500000E-05  -1.20870000E-04  +4.64400000E-05  +1.22960000E-04
   -5.45000000E-05  -4.81700000E-05  -3.32000000E-05  -1.62200000E-05  -1.18700000E-05
   -7.19000000E-06  +2.24209000E-03  -6.95030000E-04  -2.21860000E-04  -1.29900000E-05
   -1.73300000E-05  +6.69000000E-06  -2.26750000E-04  +3.30700000E-05  +7.25800000E-05
   -7.49990000E-04  -1.57160000E-04  -1.93976000E-03  +2.72181500E-02  +2.61371060E-01
   +5.13616000E-03  +2.08899000E-03  +2.97251000E-03  +9.46020000E-04  +1.41321000E-02
   -4.27999000E-03  +2.96327300E-02  +1.36201030E-01  -1.32807140E-01  +1.14966000E-03
   -4.37230000E-04  +3.14219000E-03  +2.18865000E-03  +1.61000000E-03  +5.47666000E-03
   -6.64900000E-05  -9.50870000E-04  -6.34030000E-04  -2.08524000E-03  -5.07220000E-04
   -2.58791000E-03  +7.20040000E-04  -3.31420000E-04  +2.53600000E-05  -8.25500000E-05
   +1.08600000E-04  +3.78000000E-06  -3.33590000E-04  +2.06000000E-04  +2.02470000E-04
   -4.58200000E-05  -5.66000000E-05  -7.08000000E-05  -3.17500000E-05  -2.24900000E-05
   -1.30900000E-05  +7.24000000E-06  +4.65400000E-05  +5.14700000E-05  +1.59700000E-05
   -2.99700000E-05  -2.18300000E-05  -6.69000000E-05  +2.17000000E-05  +1.12010000E-04
   -3.22700000E-05  -4.94900000E-05  -1.19200000E-05  +9.93000000E-06  -2.05500000E-05
   -1.05500000E-05  -4.02640000E-04  +8.36210000E-04  +5.90010000E-04  -2.39000000E-06
   -4.82000000E-05  +3.36400000E-05  +2.37600000E-05  -2.42900000E-05  -4.03200000E-05
   -1.77537000E-03  -1.71381000E-03  -2.23840000E-03  -3.36257700E-02  -1.50623680E-01
   +1.31356820E-01  -2.51935480E-01  -3.55132600E-02  +1.27138650E-01  +1.19380000E-04
   +6.58100000E-05  +1.89471000E-03  +2.22926000E-03  +3.13070000E-04  +1.74338000E-03
   +1.15090000E-04  +3.34980000E-04  -8.30860000E-04  +4.98390000E-04  +4.59189000E-03
   +1.33707000E-03  -1.47639300E-02  -5.41958000E-03  +1.29266100E-02  -1.00641000E-03
   +1.05140000E-04  -9.94800000E-04  -3.76100000E-05  +2.22900000E-05  +2.08170000E-04
   -1.20835000E-03  -1.62500000E-04  +7.00600000E-04  -4.18430000E-04  +8.29990000E-04
   -5.32150000E-04  -1.14000000E-04  +2.03590000E-04  -1.49010000E-04  -1.40750000E-04
   +3.65700000E-05  +1.78600000E-05  -2.22080000E-04  -8.65900000E-05  +4.47900000E-05
   +2.03730000E-04  +1.00800000E-05  +1.16700000E-05  -1.33810000E-04  +2.06510000E-04
   -9.53900000E-05  +1.62630000E-04  +1.09250000E-04  -1.90300000E-05  +8.72300000E-05
   -2.45200000E-05  -6.45600000E-05  +2.20500000E-05  -1.19070000E-04  -1.17680000E-04
   -1.43600000E-05  +3.02500000E-05  -3.11600000E-05  -2.31180000E-04  +1.43440000E-04
   -8.61000000E-05  -1.84110000E-04  -1.36940000E-04  -1.70310000E-04  -3.35100000E-05
   +1.14820000E-04  +3.78000000E-05  +2.66570200E-01  -3.59351600E-02  -6.42527200E-02
   +3.17194700E-02  -2.28835000E-02  +1.53031000E-03  +1.31531800E-02  +9.17230000E-04
   -3.31202000E-03  +5.00536000E-03  +4.12800000E-04  -1.04028000E-03  -2.24860000E-04
   +4.37553000E-03  -1.05580000E-03  +3.11619000E-03  +1.97774400E-02  +7.24434000E-03
   -1.17551400E-02  -1.24659000E-03  -7.99500000E-05  -9.96120000E-04  +2.93800000E-05
   -6.60690000E-04  +3.10760000E-04  +9.14670000E-04  +3.60120000E-04  -6.81030000E-04
   +3.98910000E-04  -2.94810000E-04  +2.28130000E-04  +2.34370000E-04  -2.62300000E-05
   -6.51200000E-05  +1.76130000E-04  -2.25600000E-05  -3.03500000E-05  +3.81410000E-04
   +9.16400000E-05  -3.94000000E-05  -3.31730000E-04  -2.14310000E-04  +1.37500000E-05
   +1.69980000E-04  +2.30430000E-04  +4.72840000E-04  -3.31510000E-04  -2.85090000E-04
   +2.68600000E-05  -1.15910000E-04  -3.09300000E-05  +2.94000000E-05  -4.83300000E-05
   +7.19900000E-05  -7.89400000E-05  -2.00000000E-06  -3.56270000E-04  +2.63570000E-04
   +2.44720000E-04  -2.62050000E-04  -1.04160000E-04  -1.80560000E-04  -7.22300000E-05
   -2.67060000E-04  -1.25805000E-03  -1.07440000E-04  +7.24030000E-04  +3.52228600E-02
   +6.25233600E-02  +1.26406510E-01  +3.10499200E-02  -1.21243440E-01  +1.47967000E-02
   +1.81586000E-03  -4.25375000E-03  +1.79216000E-03  +5.38625000E-03  +2.35499000E-03
   -9.72480000E-04  -8.58700000E-05  -5.75350000E-04  +1.53160000E-03  +2.90448000E-03
   +6.08829000E-03  -1.00302000E-03  +1.11523000E-03  +4.22875000E-03  -1.59970000E-04
   -1.64109000E-03  -1.93177000E-03  -4.00000000E-08  -1.31180000E-04  +1.70100000E-05
   +1.87510000E-04  -1.50650000E-04  -4.70000000E-07  -5.33500000E-05  +2.85870000E-04
   +4.42600000E-05  -4.88430000E-04  -3.64700000E-04  +2.87950000E-04  -2.15060000E-04
   +2.82760000E-04  +1.70120000E-04  -3.53470000E-04  -1.61030000E-04  -1.73930000E-04
   +1.78300000E-05  -1.24000000E-04  -3.60300000E-05  +6.61300000E-05  -2.01030000E-04
   -2.30730000E-04  +3.39910000E-04  +1.84450000E-04  +4.46300000E-05  +1.98110000E-04
   -8.74600000E-05  -1.05120000E-04  -2.43000000E-04  +8.16000000E-06  -7.43200000E-05
   +1.40110000E-04  +2.17460000E-04  -1.59540000E-04  -1.36840000E-04  -6.01200000E-05
   -1.15880000E-04  -1.70050000E-04  -2.86430000E-04  -4.58680000E-04  +7.87370000E-04
   +1.41300000E-05  -3.94690000E-04  -1.40691850E-01  -3.73239200E-02  +1.18995420E-01
   +7.12455000E-03  +1.95066400E-02  -1.33224600E-02  -1.66846000E-03  +4.45742000E-03
   +2.44950000E-03  -1.48447000E-03  +4.86110000E-04  -2.15700000E-05  -3.50984000E-03
   +6.59280000E-04  +4.29294000E-03  +2.76877000E-03  -2.34046100E-02  +1.44797400E-02
   -6.01327200E-02  -2.30861500E-02  +2.57255700E-02  +6.25840000E-04  +7.22960000E-04
   -5.85310000E-04  +2.95200000E-05  -5.67100000E-05  -1.05560000E-04  +1.19850000E-03
   -4.97550000E-04  -2.07828000E-03  +9.52700000E-05  +2.35300000E-05  +3.51700000E-05
   +2.65600000E-05  +6.31000000E-06  -1.08500000E-05  -2.35500000E-05  -8.36900000E-05
   +1.52200000E-05  +1.99800000E-05  +2.61200000E-05  +1.73300000E-05  -2.85000000E-06
   -4.14700000E-05  +4.72000000E-06  -1.43500000E-05  -4.10000000E-06  +1.06400000E-05
   -2.97100000E-05  -6.40400000E-05  +2.40000000E-05  -6.50000000E-06  -1.43400000E-05
   -1.17000000E-06  -3.07090000E-04  +1.31860000E-04  +7.21900000E-05  -5.70000000E-07
   -1.48910000E-04  +9.70900000E-05  +2.25870000E-04  +1.69800000E-05  -3.97650000E-04
   -1.29310000E-04  -1.19183000E-03  +7.31510000E-04  -5.54200000E-05  -1.35410000E-04
   -2.75740000E-04  +1.72300000E-05  -1.35885000E-03  -1.71009000E-03  +5.52823100E-02
   -4.77882000E-03  -1.28537100E-02  +1.14061500E-02  +4.70262000E-03  +7.90850000E-04
   +1.53801000E-03  +1.13270000E-04  +2.24410000E-04  -7.31940000E-04  +1.91850000E-04
   +2.06394000E-03  +1.79571000E-03  +2.62063000E-03  -1.42985000E-03  +2.35178000E-03
   -2.44534700E-02  -2.53828270E-01  +1.36542290E-01  -4.51400000E-04  -3.27570000E-04
   +7.17820000E-04  +5.02800000E-05  -2.28300000E-05  +4.99700000E-05  -8.42650000E-04
   +1.23340000E-04  -1.54571000E-03  -1.72880000E-04  -8.39700000E-05  -6.43700000E-05
   -4.88000000E-06  +1.70100000E-05  +9.90000000E-06  -1.48400000E-05  +8.80500000E-05
   +2.52000000E-06  -6.38600000E-05  -3.78300000E-05  -1.69200000E-05  +2.50600000E-05
   +5.63000000E-06  -6.44000000E-06  -4.10000000E-06  +2.98900000E-05  +7.40000000E-06
   +7.22700000E-05  +6.03700000E-05  -1.24200000E-05  +5.01600000E-05  -3.69000000E-06
   -2.48300000E-05  +2.94570000E-04  -1.85930000E-04  -1.17240000E-04  +1.94600000E-05
   +1.08700000E-04  -7.93500000E-05  -6.34300000E-05  -6.40400000E-05  -2.24920000E-04
   -1.13000000E-06  -4.08200000E-05  -2.18800000E-05  -1.67460000E-04  -2.09910000E-04
   -2.06270000E-04  -7.95860000E-04  -2.82110000E-04  -2.15090000E-03  +2.37118900E-02
   +2.66203670E-01  +4.95050000E-04  -1.34916000E-03  +3.34234000E-03  +2.15167000E-03
   +1.98125000E-03  +5.63974000E-03  +1.15850000E-04  -9.35910000E-04  -4.83770000E-04
   +4.59231000E-03  +1.52060000E-03  +2.13109000E-03  -1.10100000E-04  +1.59287400E-02
   -3.89500000E-03  +2.63332300E-02  +1.35674460E-01  -1.26577570E-01  +3.26720000E-04
   +6.64500000E-05  +2.29300000E-04  -6.20000000E-06  -5.33000000E-06  -6.99700000E-05
   -1.97780000E-03  -1.65667000E-03  -1.37893000E-03  -1.12200000E-04  +2.53300000E-05
   -6.53000000E-06  +3.95400000E-05  +3.27800000E-05  -5.20700000E-05  -1.28100000E-05
   -4.04100000E-05  -1.83300000E-05  +2.17100000E-05  +3.60800000E-05  +4.90400000E-05
   +1.23000000E-06  -4.44600000E-05  +1.75400000E-05  -1.88000000E-05  +3.90400000E-05
   +2.95800000E-05  -4.07000000E-05  -5.77300000E-05  -1.48200000E-05  -2.33000000E-06
   -1.18300000E-05  -1.20200000E-05  -3.36600000E-05  -6.94200000E-05  -1.06300000E-05
   -1.59800000E-05  -7.81200000E-05  +1.13500000E-05  -3.42990000E-04  -2.72480000E-04
   -1.96410000E-04  +2.54100000E-05  +5.99520000E-04  -4.39130000E-04  -2.61190000E-04
   -2.30410000E-04  -4.61550000E-04  -1.90679000E-03  -1.86627000E-03  -2.74345000E-03
   -2.92560800E-02  -1.49355840E-01  +1.24995080E-01  +1.69940000E-04  -3.40560000E-04
   +2.31250000E-04  +9.51400000E-04  +1.12864000E-03  +3.19750000E-04  +2.20600000E-04
   -2.04550000E-04  +8.81000000E-05  +8.76700000E-05  -8.44200000E-05  -5.64400000E-05
   +3.89700000E-05  +6.81200000E-05  -1.02740000E-04  -1.38680000E-04  +2.78300000E-05
   -4.57700000E-05  -5.04920000E-04  +6.78410000E-04  +1.07008000E-03  -2.66697840E-01
   -9.80362500E-02  -4.24170300E-02  +4.08500000E-05  -2.48100000E-05  +2.25600000E-05
   +6.41060000E-04  +1.08050000E-04  +3.17790000E-04  -3.27890000E-04  +2.48700000E-05
   +3.60660000E-04  +3.70250000E-04  -7.55100000E-05  -2.73520000E-04  +1.74920000E-04
   +8.65200000E-05  +4.66000000E-05  -1.29590000E-04  -5.86000000E-05  -7.74800000E-05
   +1.24690000E-04  +1.70680000E-04  +3.79580000E-04  -2.57540000E-04  -2.06200000E-04
   -7.59300000E-05  -1.56210000E-04  -1.58000000E-05  +4.38400000E-05  +9.46000000E-05
   +2.30710000E-04  +4.07650000E-04  -5.69700000E-05  -1.86230000E-04  +1.00500000E-04
   -8.74000000E-06  +2.69000000E-06  -3.81000000E-06  +2.34200000E-05  -1.83500000E-05
   -8.00000000E-08  +1.65600000E-05  -2.58300000E-05  -6.84000000E-06  +3.17900000E-05
   +7.11400000E-05  +4.66000000E-06  -7.93000000E-06  -1.07600000E-05  -7.34000000E-06
   +2.86774180E-01  -1.13990000E-04  -3.78140000E-04  +4.69440000E-04  -1.07676000E-03
   +4.63420000E-04  +5.79400000E-05  +3.19680000E-04  +1.04190000E-04  -5.10000000E-06
   +1.29030000E-04  -1.23200000E-05  -4.33000000E-05  +1.62960000E-04  -1.40100000E-04
   -4.87900000E-05  +1.18400000E-05  +2.20500000E-05  +3.77400000E-05  -1.24904100E-02
   -7.69993000E-03  -2.63635000E-03  -9.64454900E-02  -8.97228100E-02  -1.76486200E-02
   -1.51040000E-04  +1.68630000E-04  +1.04600000E-05  +8.57550000E-04  -5.27790000E-04
   -2.80968000E-03  +4.80750000E-04  +1.80070000E-04  -3.41500000E-04  +1.76700000E-05
   +3.89500000E-05  +1.12900000E-05  +2.67090000E-04  +1.18160000E-04  -1.12800000E-05
   -2.73400000E-05  -2.38550000E-04  -1.80610000E-04  -9.85320000E-04  +1.15490000E-04
   -4.07000000E-06  -2.33570000E-04  -1.51730000E-04  +2.56500000E-05  -1.33840000E-04
   +3.53000000E-05  +3.71800000E-05  +5.02690000E-04  +1.75710000E-04  +9.94500000E-04
   -4.66000000E-05  -1.52850000E-04  +9.28900000E-05  +2.66400000E-05  -2.01600000E-05
   -2.36000000E-05  -1.25500000E-05  -3.84000000E-06  -3.38000000E-06  -3.42400000E-05
   -4.00000000E-08  -5.29900000E-05  +7.67000000E-06  +1.42010000E-04  -1.37170000E-04
   -1.18900000E-05  -6.11000000E-06  -1.54900000E-05  +1.06443210E-01  +9.51657900E-02
   +4.28800000E-04  -2.18570000E-04  +7.73600000E-05  -9.89460000E-04  +6.85660000E-04
   +6.45530000E-04  -1.41200000E-05  +1.14900000E-04  +2.22430000E-04  +2.02450000E-04
   -1.52150000E-04  -4.55800000E-05  +2.57460000E-04  +2.55000000E-05  -2.08050000E-04
   -4.40690000E-04  +4.55600000E-05  +5.98300000E-05  -2.70358800E-02  -1.24985100E-02
   -7.03689000E-03  -4.02844400E-02  -1.70315700E-02  -5.36905800E-02  -1.97730000E-04
   +1.71090000E-04  +1.46100000E-05  +1.70611000E-03  -1.79390000E-03  -5.18684000E-03
   +1.08039000E-03  -7.84600000E-05  -3.75340000E-04  -1.86790000E-04  -2.49400000E-04
   +1.35260000E-04  +2.21300000E-04  +1.58430000E-04  +7.73400000E-05  +1.53860000E-04
   -2.31610000E-04  -4.00580000E-04  -1.80991000E-03  -7.88880000E-04  +2.27800000E-05
   -1.93350000E-04  -1.01300000E-04  +4.55300000E-05  -1.16240000E-04  +3.02300000E-05
   +5.93100000E-05  -1.35597000E-03  -8.68820000E-04  +1.18037000E-03  -5.63300000E-05
   -1.88050000E-04  +1.22800000E-04  +2.76300000E-05  -5.65000000E-06  -2.25000000E-06
   -8.05000000E-06  -1.24800000E-05  +8.64000000E-06  +3.53500000E-05  +1.62000000E-05
   -1.00540000E-04  +2.18700000E-05  +1.82200000E-05  +4.66800000E-05  +1.24300000E-05
   +7.92000000E-06  +3.33000000E-06  +4.48659600E-02  +2.23410400E-02  +6.08465200E-02
   +1.75390000E-04  -5.02930000E-04  +3.52000000E-04  +6.59010000E-04  +5.35100000E-04
   +7.20300000E-04  +4.44620000E-04  +1.61810000E-04  -3.93000000E-05  +5.07600000E-05
   -5.46000000E-06  -6.28700000E-05  +3.23840000E-04  -1.48650000E-04  -1.01910000E-04
   -3.31180000E-04  +5.09600000E-05  +1.61900000E-05  -4.38810000E-04  -7.30950000E-04
   -1.21490000E-04  -1.72234610E-01  +1.32006390E-01  +9.58553000E-03  -2.86990000E-04
   +2.55470000E-04  +1.73500000E-05  +2.10700000E-05  -1.18800000E-04  +1.36800000E-04
   -7.73350000E-04  -9.67870000E-04  +4.30000000E-07  +8.72500000E-05  -2.51900000E-05
   -1.17860000E-04  -1.64690000E-04  -3.04100000E-05  -3.61000000E-06  +4.88500000E-05
   +1.15300000E-05  +2.08800000E-05  +9.07700000E-05  +8.96100000E-05  +2.60000000E-05
   +1.07270000E-04  +4.95800000E-05  -1.74800000E-05  +7.55700000E-05  -1.69600000E-05
   -1.28600000E-05  +1.66450000E-04  -8.64500000E-05  -3.12340000E-04  +2.23600000E-05
   +4.50900000E-05  -3.18500000E-05  +4.28500000E-05  -1.12900000E-05  -1.66200000E-05
   -2.62000000E-05  +1.10300000E-05  +1.08500000E-05  -5.76700000E-05  -3.86200000E-05
   -3.70000000E-06  +4.83400000E-05  +8.94000000E-05  +1.87900000E-05  -2.31200000E-05
   +1.11400000E-05  -1.81900000E-05  -1.81578400E-02  +2.17590500E-02  +1.45980000E-03
   +1.86342320E-01  +3.19130000E-04  -1.30870000E-04  -2.94120000E-04  +1.23790000E-04
   -3.30990000E-04  -3.09580000E-03  -6.71980000E-04  -3.05650000E-04  +1.46500000E-04
   +4.94890000E-04  -5.25780000E-04  +2.90140000E-04  +2.43600000E-05  +6.00300000E-04
   -3.94870000E-04  -3.21060000E-04  +1.86380000E-04  -3.49400000E-05  +9.23172000E-03
   -1.00853300E-02  +6.70390000E-04  +1.31111580E-01  -1.86826040E-01  -1.00374700E-02
   +3.64820000E-04  -3.78690000E-04  +3.38500000E-05  +5.74170000E-04  +4.25880000E-04
   +4.06750000E-04  +5.18260000E-04  -1.52710000E-04  -9.62600000E-04  -4.32350000E-04
   +7.52900000E-05  +4.13520000E-04  -3.98400000E-05  -2.25200000E-05  +2.28300000E-05
   +2.00860000E-04  +9.94000000E-05  +5.00000000E-05  -2.79770000E-04  -1.26130000E-04
   -2.79620000E-04  +1.55900000E-04  +1.90780000E-04  +1.05460000E-04  +5.38100000E-05
   +7.39900000E-05  +7.79000000E-06  -3.55000000E-04  +4.76000000E-04  +1.28691000E-03
   +1.99200000E-05  +1.54510000E-04  -8.24900000E-05  -5.89700000E-05  +3.01400000E-05
   +2.65500000E-05  +8.94700000E-05  -1.92600000E-05  +4.14700000E-05  -1.39000000E-05
   +1.43000000E-05  -1.12920000E-04  +1.01940000E-04  +2.07630000E-04  +1.76540000E-04
   +4.52000000E-06  -3.80100000E-05  +4.68000000E-06  -9.39350000E-03  +1.06331200E-02
   +1.07407000E-03  -1.44784350E-01  +2.00759350E-01  +2.10910000E-04  +2.51710000E-04
   +1.11800000E-05  -8.29550000E-04  -1.37972000E-03  -4.95716000E-03  +3.92090000E-04
   -7.14950000E-04  +9.08800000E-05  +2.46430000E-04  +4.56000000E-06  +4.11390000E-04
   -3.00890000E-04  +2.68020000E-04  -4.49400000E-05  +4.56270000E-04  +4.74000000E-06
   +1.51060000E-04  +2.13002400E-02  -2.09905200E-02  -2.23616000E-03  +9.19111000E-03
   -8.68393000E-03  -4.88311900E-02  +4.50840000E-04  -4.64560000E-04  -1.98900000E-05
   +3.85280000E-04  +5.75900000E-04  +8.45940000E-04  -5.14350000E-04  +5.69500000E-05
   +2.79370000E-04  -9.76600000E-05  -2.93000000E-05  -2.98300000E-05  -2.15260000E-04
   -2.30600000E-05  +1.36470000E-04  +1.85730000E-04  +8.00300000E-05  +1.76900000E-05
   -2.83700000E-05  +6.63600000E-05  -3.05040000E-04  +1.38890000E-04  +8.33200000E-05
   -3.33200000E-05  +3.55300000E-05  -3.15000000E-06  -4.47700000E-05  +8.40670000E-04
   -1.13748000E-03  +1.39511000E-03  +2.99000000E-06  +5.47000000E-05  -5.11200000E-05
   -6.03200000E-05  -2.83000000E-06  +2.47000000E-05  +8.55000000E-05  -4.18800000E-05
   +1.20000000E-07  -3.37200000E-05  -8.70500000E-05  -2.08820000E-04  -2.66380000E-04
   -2.70380000E-04  -1.07370000E-04  +2.76900000E-05  -4.03300000E-05  +1.53500000E-05
   -3.24222000E-03  +4.31268000E-03  -6.45780000E-04  -1.07414600E-02  +1.24702500E-02
   +5.23827200E-02  -3.64700000E-05  +3.81700000E-05  -3.94600000E-05  +8.24400000E-05
   -7.22100000E-04  +2.88910000E-04  -3.09850000E-04  +1.09220000E-04  +1.10070000E-04
   +1.73290000E-04  -1.69120000E-04  +5.47000000E-05  +5.97300000E-05  +1.84090000E-04
   -1.00220000E-04  -3.20860000E-04  +1.32430000E-04  -8.06800000E-05  -1.75206000E-03
   +3.17880000E-04  -2.92020000E-04  -5.58995000E-02  -3.28772600E-02  +3.50096100E-02
   +4.10300000E-05  -4.43500000E-05  -7.14000000E-06  +2.83660000E-04  +4.73800000E-04
   -3.94610000E-04  -6.60900000E-05  -9.63500000E-05  -6.86800000E-04  -1.59970000E-04
   -4.08400000E-05  +2.06730000E-04  -8.40200000E-05  -4.30700000E-05  -5.02100000E-05
   +9.15500000E-05  +5.98200000E-05  +3.33200000E-05  -1.66200000E-05  +1.34700000E-05
   -5.70300000E-05  +1.45090000E-04  +1.31650000E-04  +6.20300000E-05  +9.60900000E-05
   +2.48500000E-05  -3.80000000E-07  -5.73500000E-05  +1.61010000E-04  -9.07800000E-05
   +3.02700000E-05  +1.00920000E-04  -3.92100000E-05  -8.77000000E-06  +1.19900000E-05
   +1.13300000E-05  +2.64000000E-06  -5.19000000E-06  -6.80000000E-06  +5.16400000E-05
   -1.45000000E-06  -7.08000000E-05  +2.61460000E-04  +1.55860000E-04  +1.21530000E-04
   +8.99000000E-06  +1.44000000E-05  +1.78800000E-05  -4.43905000E-03  -1.96034800E-02
   +2.14053500E-02  +4.45933000E-03  +1.47541800E-02  -1.67919900E-02  +5.75997500E-02
   +4.16700000E-04  -2.57700000E-04  -6.42730000E-04  -1.43000000E-06  +8.99680000E-04
   -6.63300000E-05  +2.47200000E-05  -1.86900000E-05  +1.05610000E-04  -3.14300000E-05
   +8.99600000E-05  -9.70300000E-05  +3.62800000E-05  -6.17400000E-05  +7.91700000E-05
   -9.91000000E-05  -8.93100000E-05  +5.16100000E-05  +3.17829000E-03  +9.08434000E-03
   -1.00936700E-02  -3.30041400E-02  -1.73002330E-01  +1.30694510E-01  -1.30440000E-04
   +1.08510000E-04  -2.80000000E-07  -6.47900000E-05  +4.81600000E-04  +2.68450000E-04
   -8.40940000E-04  +3.19520000E-04  +2.11700000E-04  +1.72770000E-04  +4.19000000E-05
   -1.55660000E-04  -1.13610000E-04  -6.29000000E-05  +2.41200000E-05  +4.88000000E-06
   +1.81200000E-05  -2.68000000E-06  +2.85250000E-04  +2.57000000E-05  +1.11290000E-04
   +5.30900000E-05  -3.11000000E-06  -5.42600000E-05  +1.11700000E-05  +9.00000000E-07
   -5.41000000E-05  +5.43000000E-05  -5.41700000E-04  -2.06721000E-03  +9.98000000E-06
   +1.77100000E-05  -3.44200000E-05  +1.43300000E-05  -4.64000000E-06  -1.53000000E-06
   -1.57400000E-05  +1.56000000E-06  +1.27000000E-06  +1.45000000E-06  -5.21000000E-06
   -1.86500000E-05  +1.85400000E-05  -7.91040000E-04  -3.81920000E-04  -7.80000000E-06
   +1.96000000E-06  -2.44200000E-05  -9.21220000E-04  -8.61147000E-03  +8.24785000E-03
   -5.89609000E-03  -1.45640300E-02  +1.53929800E-02  +3.68322700E-02  +1.86291110E-01
   +3.41190000E-04  +6.60060000E-04  -7.53800000E-05  -1.46651000E-03  +9.81160000E-04
   +7.53050000E-04  +8.50370000E-04  -1.68260000E-04  -1.45430000E-04  -4.02920000E-04
   +4.84180000E-04  -8.74000000E-05  -3.22620000E-04  -3.75660000E-04  +3.31830000E-04
   +4.54470000E-04  -4.38380000E-04  +2.02410000E-04  +5.47534000E-03  +2.07613500E-02
   -1.99277500E-02  +3.51096000E-02  +1.28447640E-01  -1.81385330E-01  -5.37600000E-05
   +3.54500000E-05  -9.41000000E-06  +1.03234000E-03  +9.28050000E-04  +1.32305000E-03
   +1.53310000E-04  -1.25520000E-04  +2.40600000E-05  -3.97740000E-04  -2.92620000E-04
   +1.77360000E-04  -1.49390000E-04  +8.16400000E-05  +1.92790000E-04  +2.76560000E-04
   +1.48050000E-04  +3.87900000E-05  -1.09500000E-05  -5.50960000E-04  -1.98580000E-04
   +1.06860000E-04  +6.42400000E-05  +3.01600000E-05  +3.60100000E-05  +2.92000000E-06
   -2.01600000E-05  +2.51100000E-05  -4.14713000E-03  -5.42857000E-03  -2.03700000E-05
   -8.41300000E-05  +4.46300000E-05  +7.40000000E-06  -1.04900000E-05  -7.22000000E-06
   -9.25000000E-06  -9.56000000E-06  -2.43900000E-05  -1.52630000E-04  -6.28000000E-06
   +5.17600000E-05  -2.81180000E-04  -6.75370000E-04  -7.44000000E-06  +4.43200000E-05
   -9.59000000E-06  +3.61000000E-06  -9.55730000E-04  -4.67530000E-03  +4.45813000E-03
   -8.42630000E-04  -2.37018000E-03  +1.73309000E-03  -3.83048300E-02  -1.40377990E-01
   +1.98937060E-01  -8.06200000E-05  -2.45000000E-06  -4.60800000E-05  +2.04020000E-04
   -1.38990000E-04  -5.85200000E-04  +2.00530000E-04  +4.31350000E-04  -4.90270000E-04
   -1.03190000E-04  -1.11190000E-04  +1.99300000E-04  -4.44500000E-05  +4.39200000E-05
   -7.92000000E-06  +5.28400000E-05  -6.71900000E-05  +2.20000000E-05  -2.09644000E-03
   +1.90111000E-03  +3.47523000E-03  -1.56930000E-04  -6.38000000E-04  +3.42660000E-04
   +8.50500000E-05  -1.29920000E-04  +2.45800000E-05  +3.71840000E-04  +5.92820000E-04
   +4.70120000E-04  -3.73770000E-04  -1.27020000E-04  +5.86200000E-05  +6.13400000E-05
   +3.84450000E-04  +7.38900000E-05  -2.18100000E-05  -1.24220000E-04  -1.00090000E-04
   -2.86180000E-04  -5.84000000E-05  -1.54210000E-04  -2.41610000E-04  -1.45160000E-04
   +2.41930000E-04  +5.91600000E-05  +3.92200000E-05  -1.65800000E-05  +1.51070000E-04
   -7.22000000E-05  -8.53000000E-05  -4.84216700E-02  +5.83843000E-03  +1.65564500E-02
   +1.00330000E-04  +2.52580000E-04  -9.94200000E-05  -2.59700000E-05  +2.47000000E-05
   -2.66000000E-06  +4.99000000E-06  +6.30000000E-07  -2.27400000E-05  -1.04422000E-03
   +4.88400000E-05  -5.22180000E-04  -2.22100000E-05  -3.76000000E-05  +3.68600000E-05
   +8.93000000E-06  -6.23000000E-06  +1.67900000E-05  +2.99160000E-04  +1.51210000E-04
   +3.45250000E-04  +1.27700000E-04  -2.76740000E-04  -2.79710000E-04  +6.60790000E-04
   -1.00500000E-05  +2.86860000E-04  +4.89422000E-02  -2.32320000E-04  -1.69230000E-04
   -4.65300000E-05  -8.89800000E-05  +1.23203000E-03  -3.55730000E-04  +5.53310000E-04
   +1.48740000E-04  +3.24300000E-05  +4.78900000E-05  -1.96900000E-04  +4.70500000E-05
   +1.82010000E-04  +3.95400000E-05  -1.70900000E-04  -1.80410000E-04  +1.16810000E-04
   +4.43700000E-05  -1.62000000E-03  +9.33357000E-03  +2.22839700E-02  -7.34710000E-04
   -3.52352000E-03  +2.85486000E-03  -8.99400000E-05  +4.91600000E-05  +2.06400000E-05
   +7.73000000E-04  +9.04620000E-04  -1.44340000E-04  -3.04210000E-04  -2.98100000E-05
   -5.42300000E-05  +7.77400000E-05  +2.84500000E-04  +1.19850000E-04  -5.22000000E-06
   -3.48000000E-05  -1.77310000E-04  -2.65000000E-06  -1.50810000E-04  -1.95870000E-04
   -6.61850000E-04  -3.71980000E-04  +6.55050000E-04  +1.27150000E-04  +4.96300000E-05
   +2.59300000E-05  +1.06100000E-04  -5.33000000E-05  -2.73100000E-05  +5.77362000E-03
   -8.37191100E-02  -9.24461700E-02  +8.28100000E-05  +1.83310000E-04  -6.76400000E-05
   +1.08700000E-05  +3.19000000E-06  -5.81000000E-06  +1.41900000E-05  +1.82200000E-05
   +3.12400000E-05  +4.13780000E-04  -2.23250000E-04  +2.51840000E-04  +1.57800000E-05
   +3.78300000E-05  +2.41000000E-05  -6.85000000E-06  +2.05800000E-05  +1.58900000E-05
   +1.82690000E-04  -9.25300000E-05  +6.02000000E-05  -2.80970000E-04  +6.10600000E-05
   +9.02400000E-05  -4.03500000E-05  +7.38990000E-04  +1.46162000E-03  -6.14904000E-03
   +9.05198500E-02  -5.23700000E-05  +5.10450000E-04  +4.40500000E-05  +7.73390000E-04
   -1.12565000E-03  +6.84950000E-04  +4.51350000E-04  +2.66370000E-04  +8.41200000E-05
   -3.15240000E-04  +1.46290000E-04  +2.31270000E-04  -1.46390000E-04  -1.98270000E-04
   +1.17070000E-04  +2.11680000E-04  -1.78420000E-04  -2.00900000E-05  +1.07222000E-03
   -8.97307000E-03  -1.90115100E-02  +9.59810000E-04  +4.80328000E-03  -2.35424000E-03
   -6.90000000E-07  -2.81600000E-05  +9.87000000E-06  -1.39525000E-03  -3.71920000E-04
   +4.41760000E-04  +7.45540000E-04  +1.88640000E-04  -1.69170000E-04  -1.29390000E-04
   -6.84380000E-04  -1.95500000E-05  -1.39470000E-04  +1.89290000E-04  +5.39800000E-05
   +2.74470000E-04  +2.01840000E-04  +3.19930000E-04  +1.16930000E-04  -8.42040000E-04
   -3.45840000E-04  +4.94300000E-05  +6.64400000E-05  +3.33900000E-05  -1.85940000E-04
   +1.34170000E-04  +1.08070000E-04  +1.69350800E-02  -9.04574600E-02  -2.78200020E-01
   -1.41580000E-04  -2.79450000E-04  +7.35700000E-05  -1.38000000E-05  +1.49600000E-05
   -1.00300000E-05  -1.20500000E-05  +3.20900000E-05  -4.34000000E-06  -6.19030000E-04
   -2.27580000E-04  -4.70100000E-05  -5.16300000E-05  -1.01900000E-04  +2.05900000E-05
   -2.43700000E-05  -1.13400000E-05  -3.49300000E-05  +1.95400000E-05  +2.16400000E-05
   +3.35930000E-04  -2.01100000E-05  +2.97000000E-06  +3.72470000E-04  +6.67000000E-05
   -5.03070000E-04  -1.48217000E-03  -1.87473100E-02  +9.82390400E-02  +3.03161610E-01
   +3.35070000E-04  -3.59320000E-04  +1.82910000E-04  +1.71640000E-04  -8.42740000E-04
   +9.47430000E-04  -4.62020000E-04  -1.38370000E-04  +4.21980000E-04  +2.67350000E-04
   +1.60390000E-04  -2.00300000E-04  +6.16700000E-05  -3.82300000E-05  -2.71700000E-05
   -8.52800000E-05  +2.73500000E-05  -4.31000000E-05  +2.58854000E-03  -4.12142000E-03
   +6.03260000E-04  -1.55000000E-05  -2.58540000E-04  -2.69000000E-06  -1.15490000E-04
   +1.57730000E-04  -3.43900000E-05  +9.71440000E-04  -1.28142000E-03  -1.25740000E-04
   +2.23150000E-04  +1.04580000E-04  +1.39470000E-04  -1.47600000E-05  +1.11990000E-04
   -8.64000000E-06  -6.86700000E-05  -4.20400000E-05  -9.11800000E-05  -8.48100000E-05
   +3.47500000E-05  -5.53200000E-05  +1.81740000E-04  +1.20630000E-04  +1.80390000E-04
   +1.01270000E-04  +3.62000000E-05  +2.74200000E-05  +9.38800000E-05  -1.52900000E-05
   -2.85100000E-05  -2.14057530E-01  +1.32620030E-01  +8.20617000E-03  +4.11300000E-05
   +7.51500000E-05  -3.23700000E-05  +3.77500000E-05  -3.06100000E-05  +2.14000000E-06
   -1.48600000E-05  -4.00000000E-08  +2.06400000E-05  +3.24040000E-04  +1.99490000E-04
   -4.58670000E-04  +9.18600000E-05  +6.20500000E-05  -2.57500000E-05  -2.56000000E-06
   -1.58000000E-05  -2.22500000E-05  -9.25000000E-06  +1.14190000E-04  +8.89900000E-05
   +2.71260000E-04  -9.77300000E-05  -3.80770000E-04  +1.92940000E-04  -2.24660000E-04
   -8.74800000E-05  -1.17397000E-03  -2.06710000E-04  -3.17680000E-04  +2.29391260E-01
   +1.46519000E-03  -4.34650000E-04  -2.08700000E-04  -2.13199000E-03  -2.43289000E-03
   +3.76617000E-03  -7.05840000E-04  +6.64300000E-05  +4.32090000E-04  +1.29940000E-04
   +9.97300000E-05  -1.98400000E-05  -3.11200000E-04  +1.70490000E-04  +6.89900000E-05
   -4.97800000E-05  -4.18910000E-04  +1.31910000E-04  +1.86481200E-02  -1.71723400E-02
   -9.57980000E-04  +9.54000000E-05  +4.26620000E-04  -1.36137000E-03  +2.76710000E-04
   -2.32000000E-04  -3.45400000E-05  +1.44483000E-03  +7.34590000E-04  -1.69340000E-04
   -5.08710000E-04  +2.14090000E-04  -3.73300000E-05  -1.20880000E-04  +2.10900000E-05
   +1.60270000E-04  -2.75090000E-04  -1.71920000E-04  -5.08100000E-05  +9.28900000E-05
   +4.58900000E-05  -3.10400000E-05  -7.85300000E-05  -2.66720000E-04  -6.12430000E-04
   +2.61930000E-04  +2.32430000E-04  +8.24000000E-06  +5.59700000E-05  +8.68000000E-06
   -4.91200000E-05  +1.30347060E-01  -1.49103640E-01  -7.58821000E-03  +3.88000000E-05
   +2.10890000E-04  -1.47230000E-04  -3.31100000E-05  +1.55400000E-05  +1.65900000E-05
   +5.35800000E-05  -2.24000000E-05  -2.30000000E-07  -9.58700000E-05  +6.89500000E-05
   -3.01750000E-04  -3.70500000E-05  +1.67900000E-05  +8.87500000E-05  +8.62600000E-05
   -1.19500000E-04  -3.11200000E-05  -1.25830000E-04  +4.81600000E-05  +1.54300000E-05
   -1.68410000E-04  +6.37220000E-04  +4.39710000E-04  -3.15420000E-04  +1.22700000E-04
   -1.35060000E-04  +8.60250000E-03  -7.28761000E-03  +1.40260000E-04  -1.42742690E-01
   +1.63145190E-01  -1.11726000E-03  +8.88300000E-04  +3.48400000E-04  +1.68887000E-03
   +2.51986000E-03  -2.81282000E-03  +8.23950000E-04  +2.21660000E-04  -1.77520000E-04
   -1.85120000E-04  +6.58800000E-05  +1.79310000E-04  +2.89400000E-05  -1.43840000E-04
   +1.24900000E-05  +1.95530000E-04  +2.05810000E-04  -1.87590000E-04  -1.72431100E-02
   +1.40195900E-02  -7.47310000E-04  -1.25256000E-03  +8.32100000E-04  +1.00574000E-03
   -8.35100000E-05  +3.38600000E-05  +1.11000000E-05  -6.77770000E-04  -5.28410000E-04
   +4.29670000E-04  -8.97200000E-05  -1.69830000E-04  +1.62220000E-04  +1.09650000E-04
   +1.39540000E-04  -5.14400000E-05  +1.71110000E-04  +2.90000000E-06  -1.04950000E-04
   -4.06210000E-04  +2.62300000E-05  +6.40100000E-05  +4.19720000E-04  +1.14700000E-05
   -9.48400000E-05  -1.78960000E-04  -1.09360000E-04  -2.74000000E-06  -1.75900000E-05
   -8.17000000E-06  -8.40000000E-06  +9.44008000E-03  -8.57620000E-03  -4.74630900E-02
   +2.27900000E-05  +6.04000000E-06  +2.49800000E-05  +1.49000000E-06  +7.49000000E-06
   -3.61000000E-06  -1.20700000E-05  +2.91600000E-05  +1.62600000E-05  -1.58150000E-04
   -5.20200000E-04  -4.00000000E-08  +8.05000000E-06  -2.05300000E-05  +5.15000000E-06
   -9.41500000E-05  +5.56700000E-05  -3.26900000E-05  +3.96100000E-05  +1.11300000E-05
   -4.81300000E-05  +3.87830000E-04  -1.35980000E-04  -7.13370000E-04  +2.02900000E-04
   -2.56210000E-04  +2.28690000E-04  +2.43309000E-02  -1.80848400E-02  -3.45800000E-05
   -1.07979700E-02  +4.70806000E-03  +5.05905700E-02  +1.25300000E-04  -1.48350000E-04
   +4.64200000E-05  -1.19540000E-04  +1.97550000E-04  +1.58100000E-04  -8.08530000E-04
   +9.94920000E-04  +5.74070000E-04  +2.30790000E-04  +1.47700000E-04  -1.60990000E-04
   -1.29390000E-04  +4.77600000E-05  -4.31600000E-05  +4.69000000E-06  +1.09300000E-05
   +1.11000000E-06  -3.80744000E-03  -1.37764000E-03  -9.20290000E-04  +2.54380000E-04
   +3.30330000E-04  -5.68470000E-04  +6.28300000E-05  -1.73300000E-05  -2.46600000E-05
   +2.71560000E-04  -1.28755000E-03  +1.35988000E-03  +6.61680000E-04  -3.08090000E-04
   -2.19870000E-04  -1.32500000E-05  -2.14340000E-04  -2.45620000E-04  +4.08870000E-04
   +2.62740000E-04  +2.39480000E-04  -1.75100000E-04  -1.52800000E-05  +1.59400000E-05
   +1.02830000E-04  +2.58110000E-04  +4.83190000E-04  -4.57100000E-04  -3.23290000E-04
   -3.42400000E-05  -1.96760000E-04  +4.39900000E-05  +6.99600000E-05  -2.29428370E-01
   -1.14720560E-01  -4.60669800E-02  -1.02170000E-04  -3.33330000E-04  +2.12400000E-04
   -4.08000000E-06  -9.85000000E-06  +1.55000000E-06  +2.52000000E-05  -5.20000000E-06
   +2.61200000E-05  -4.19290000E-04  +1.51451000E-03  +3.82500000E-05  -1.16400000E-05
   +1.81300000E-05  -2.88000000E-05  +6.10000000E-06  -1.88500000E-05  -9.64000000E-06
   +3.58810000E-04  +5.13300000E-05  +5.13180000E-04  -2.07410000E-04  -9.71300000E-05
   +3.64300000E-05  +2.53450000E-04  +2.27680000E-04  +6.84800000E-05  +2.64205000E-03
   +2.69152000E-03  +8.64120000E-04  -1.92313000E-02  -1.38876200E-02  -5.64730000E-03
   +2.49641440E-01  +2.15890000E-04  -1.71730000E-04  +2.11880000E-04  -5.12080000E-04
   +8.42330000E-04  -4.19710000E-04  -4.05800000E-05  -6.12970000E-04  +4.78250000E-04
   +3.83810000E-04  +1.38110000E-04  -2.04050000E-04  +1.33920000E-04  +2.10400000E-05
   -1.27740000E-04  -1.69870000E-04  +1.93970000E-04  -1.73300000E-05  -1.99689600E-02
   -1.21722500E-02  -5.79907000E-03  +2.10000000E-07  +6.50370000E-04  -1.58290000E-03
   -1.11660000E-04  +1.73310000E-04  -2.79500000E-05  -3.41080000E-04  -2.40163000E-03
   +4.03611000E-03  +1.58930000E-04  -3.39960000E-04  -3.83890000E-04  -3.54650000E-04
   -3.72860000E-04  -4.14630000E-04  +2.31880000E-04  +3.63300000E-04  +5.78380000E-04
   +1.62100000E-04  +2.22400000E-05  +2.89700000E-05  -3.21040000E-04  -4.32400000E-05
   +9.45100000E-05  -4.60760000E-04  -3.28180000E-04  -1.07140000E-04  -3.23560000E-04
   +7.51800000E-05  -3.49000000E-06  -1.13578670E-01  -1.19355130E-01  -2.85646100E-02
   -1.94210000E-04  -5.14920000E-04  +2.52320000E-04  +3.47000000E-05  -4.28800000E-05
   -4.06000000E-06  -9.11000000E-06  -2.99600000E-05  +6.67000000E-06  +1.13251000E-03
   -1.10548000E-03  -7.91220000E-04  -3.21000000E-06  +9.23800000E-05  -1.16860000E-04
   -1.12800000E-05  -2.27000000E-06  -2.22100000E-05  +3.18150000E-04  +4.55300000E-04
   +5.79040000E-04  +1.16660000E-04  -2.70300000E-05  +1.34880000E-04  +3.29030000E-04
   +4.91000000E-06  -1.51110000E-04  -9.20487000E-03  -6.35042000E-03  -1.58969000E-03
   +1.67117400E-02  +1.16824600E-02  +4.76393000E-03  +1.25491530E-01  +1.28463330E-01
   +7.22900000E-05  -1.72900000E-05  -2.01860000E-04  -6.54200000E-05  -5.72520000E-04
   +4.31340000E-04  -5.92970000E-04  -3.64850000E-04  +5.18580000E-04  +4.74900000E-05
   +2.36290000E-04  -1.76840000E-04  -1.61890000E-04  -3.25900000E-05  +1.04100000E-04
   +9.75700000E-05  -4.50200000E-05  -3.01600000E-05  +1.89522500E-02  +1.11071500E-02
   +3.27534000E-03  +1.11628000E-03  +5.97770000E-04  +1.17834000E-03  +4.66100000E-05
   +9.89000000E-06  -3.62200000E-05  -2.67690000E-04  +2.65503000E-03  -2.81105000E-03
   +6.35570000E-04  +4.17260000E-04  +1.79310000E-04  +1.76600000E-04  -4.95920000E-04
   +2.99800000E-04  -2.36780000E-04  -6.73200000E-05  -2.32690000E-04  +3.25730000E-04
   +1.44600000E-05  +1.68540000E-04  +5.89000000E-05  -3.99620000E-04  -1.95560000E-04
   +3.19650000E-04  +2.68140000E-04  +4.29700000E-05  -6.21000000E-06  +5.43100000E-05
   +7.36600000E-05  -4.63564100E-02  -2.99027200E-02  -5.96824400E-02  -2.68600000E-05
   +3.04900000E-05  -9.97200000E-05  +2.50000000E-06  -1.16100000E-05  +9.25000000E-06
   +7.36000000E-06  -5.71000000E-06  +1.53700000E-05  +2.52770000E-04  -1.58110000E-04
   +1.31200000E-05  +3.50100000E-05  +1.37100000E-05  +1.42900000E-05  +1.85200000E-05
   +4.90000000E-06  +8.62000000E-06  -3.18560000E-04  +1.84540000E-04  -6.10720000E-04
   +5.00800000E-05  -1.28860000E-04  -4.95700000E-05  -1.68630000E-04  -1.68460000E-04
   +3.04290000E-04  -2.54580700E-02  -1.45505900E-02  -4.80194000E-03  +1.82921000E-03
   +1.18756000E-03  -5.69220000E-04  +4.97482800E-02  +2.95351200E-02  +6.25899400E-02
   -2.32070000E-04  -1.91800000E-05  -2.75850000E-04  -5.09200000E-04  -3.03500000E-04
   -7.19560000E-04  -2.60700000E-05  -7.40600000E-05  -1.04840000E-04  -1.17380000E-04
   +1.53360000E-04  +8.82000000E-06  -2.27180000E-04  +2.81000000E-05  +1.34520000E-04
   +2.57780000E-04  -1.21300000E-04  -3.69200000E-05  -5.27000000E-04  +8.68900000E-05
   -5.01620000E-04  +7.41300000E-05  +1.43150000E-04  -1.53600000E-05  +1.23860000E-04
   -1.06400000E-04  -1.57500000E-05  +4.52089000E-03  -4.60330000E-04  -1.35285000E-03
   +1.11749000E-03  -1.04405000E-03  -1.48110000E-04  +1.35330000E-04  -2.66480000E-04
   -4.79260000E-04  -1.10301000E-03  -4.97932000E-03  -1.54896000E-03  -1.71554800E-02
   +2.69922000E-03  +1.78805600E-02  -2.37889160E-01  +1.34861900E-02  +1.33707400E-01
   -1.65010000E-03  +1.85680000E-04  +7.76690000E-04  -2.84100000E-05  +2.51830000E-04
   +7.43600000E-05  -1.91000000E-04  -3.16270000E-04  -1.21600000E-05  -5.75200000E-05
   -2.61120000E-04  +1.79620000E-04  -1.74000000E-05  +1.15600000E-05  +9.02000000E-06
   +1.25000000E-05  +2.41000000E-06  -5.57000000E-06  +3.46600000E-05  -3.95900000E-05
   +6.70000000E-06  +1.75000000E-06  +1.59100000E-05  +5.61300000E-05  +1.88000000E-06
   -3.53000000E-06  +9.03000000E-06  +7.62200000E-05  +1.57700000E-05  +2.32200000E-05
   -1.13500000E-05  +6.11000000E-06  +3.56900000E-05  -1.18600000E-05  +1.44400000E-05
   -3.01000000E-05  +1.41580000E-04  -4.17050000E-04  -2.50740000E-04  +1.93000000E-05
   +1.65000000E-05  +2.98800000E-05  +1.13200000E-05  +8.57000000E-06  -2.07440000E-04
   +2.52613420E-01  -8.98300000E-05  +2.33460000E-04  -1.47950000E-04  -2.36750000E-04
   +2.03280000E-04  -3.89000000E-05  +6.73300000E-05  -6.40900000E-05  -8.16200000E-05
   -5.89000000E-05  +6.06400000E-05  -1.01500000E-05  -1.16650000E-04  -4.24400000E-05
   +1.09360000E-04  +1.82050000E-04  -2.27360000E-04  -9.55900000E-05  +9.48570000E-04
   -1.25152000E-03  +8.47440000E-04  +1.17150000E-04  -9.71400000E-05  +1.27060000E-04
   +8.41800000E-05  -1.01840000E-04  -1.56300000E-05  +1.32929700E-02  +4.20816000E-03
   -8.41468000E-03  -6.49620000E-04  +1.65362000E-03  -4.78560000E-03  -5.81360000E-04
   -7.69640000E-04  -3.55300000E-04  -3.49669000E-03  +5.66697000E-03  -5.26422000E-03
   -1.51570900E-02  +6.16668000E-03  +7.69605000E-03  +1.43528600E-02  -4.96153700E-02
   -2.06061200E-02  -2.71040000E-04  -9.18630000E-04  +1.09415000E-03  +2.94430000E-04
   -3.20830000E-04  +2.29700000E-04  -5.95800000E-05  -4.59240000E-04  -5.46220000E-04
   +2.63300000E-05  -5.54400000E-05  +1.53660000E-04  +3.87000000E-06  +1.49400000E-05
   +1.85500000E-05  +2.27500000E-05  +4.13000000E-06  +7.57000000E-06  -9.99700000E-05
   -5.84600000E-05  +1.81000000E-06  -2.98000000E-05  +2.76200000E-05  +6.76300000E-05
   +2.09100000E-05  -1.06500000E-05  +2.24200000E-05  -4.18800000E-05  +4.27900000E-05
   +2.58700000E-05  +6.07000000E-06  +3.04000000E-05  -1.59400000E-05  +1.98500000E-05
   +1.82000000E-06  +1.11770000E-04  -6.21460000E-04  -1.25173000E-03  +2.09490000E-04
   -5.43300000E-05  +8.39100000E-05  +1.34200000E-05  -3.08500000E-05  +1.72020000E-04
   +3.83700000E-04  -1.03470600E-02  +4.06925300E-02  +7.86100000E-05  +4.70650000E-04
   -1.83980000E-04  -4.49240000E-04  -3.49060000E-04  -7.35500000E-05  -3.70760000E-04
   +1.82610000E-04  +2.45640000E-04  -9.57500000E-05  -6.90000000E-05  +8.75800000E-05
   -3.50070000E-04  +1.91080000E-04  +1.99000000E-06  +1.43180000E-04  +2.32600000E-05
   -4.19100000E-05  +8.74440000E-04  +1.41006000E-03  -3.31130000E-04  -1.54020000E-04
   +7.66400000E-05  +6.79000000E-06  +3.35530000E-04  -2.94810000E-04  +1.77000000E-06
   +2.28380400E-02  -1.36845000E-03  -1.11214300E-02  -1.03055000E-03  -5.12105000E-03
   -3.31196000E-03  -6.79430000E-04  -5.74550000E-04  +3.63540000E-04  -1.48799000E-03
   -5.24145000E-03  +2.30179000E-03  -7.37282000E-03  -7.17050000E-04  +9.53957000E-03
   +1.33267800E-01  -2.01514800E-02  -1.51716210E-01  -1.63360000E-04  +9.09170000E-04
   +1.38600000E-05  -1.06510000E-04  +4.36570000E-04  +6.82800000E-05  -4.27400000E-05
   -8.28700000E-05  -2.29020000E-04  -1.37150000E-04  -8.15200000E-05  -1.47960000E-04
   -5.28900000E-05  +2.08900000E-05  +2.05100000E-05  +3.11100000E-05  +2.41000000E-06
   -8.31000000E-06  -1.17400000E-05  -4.40000000E-06  -2.19600000E-05  +2.26600000E-05
   -8.35500000E-05  +2.99900000E-05  +3.01000000E-06  -2.19300000E-05  -5.81000000E-06
   -7.55200000E-05  -5.67600000E-05  -4.13000000E-06  -4.70000000E-07  +1.35960000E-04
   +6.14800000E-05  +5.09400000E-05  -4.10000000E-05  +6.49000000E-05  +2.00800000E-05
   -6.56400000E-05  +4.42270000E-04  +3.94000000E-06  +1.72320000E-04  +9.66300000E-05
   -5.33800000E-05  -4.35000000E-05  +9.21200000E-05  -1.45360970E-01  +2.72609600E-02
   +1.54938320E-01  +1.70000000E-07  +3.29000000E-06  +1.31700000E-05  +1.18900000E-04
   -6.59900000E-05  +1.09400000E-05  -5.20000000E-07  +2.49600000E-05  -7.70000000E-07
   -1.38400000E-05  +3.43000000E-05  +1.33300000E-05  +1.32500000E-05  -2.64700000E-05
   -1.44000000E-06  -9.96000000E-06  +2.64600000E-05  +2.28000000E-05  +5.36370000E-04
   -5.14970000E-04  -1.02920000E-03  -3.91930000E-04  -1.09180000E-04  +3.73900000E-05
   -3.52300000E-05  +4.47900000E-05  +1.15800000E-05  -3.14848000E-03  -4.34504000E-03
   +6.62200000E-05  -1.82739000E-03  -2.38950000E-04  +2.79780000E-04  -3.34056000E-03
   -1.27090000E-04  +2.68878000E-03  +6.26247000E-03  +1.30454500E-02  +2.38553400E-02
   -5.65712900E-02  -1.04620800E-02  -5.16384000E-03  +3.63614000E-03  -1.39973700E-02
   -2.36401700E-02  +1.50597000E-03  +5.43200000E-05  -3.30677000E-03  -4.90690000E-04
   +7.22570000E-04  +1.56586000E-03  +6.75100000E-05  +1.03460000E-04  -8.13700000E-05
   -1.48110000E-04  +5.40000000E-06  -2.06240000E-04  -3.79000000E-06  -4.70000000E-06
   -1.16200000E-05  -1.39600000E-05  -6.00000000E-08  -4.98000000E-06  +1.11000000E-06
   -1.06600000E-05  -8.07000000E-06  -9.50000000E-07  -2.04200000E-05  -5.05000000E-06
   -9.75000000E-06  +3.60000000E-06  -1.23900000E-05  -1.96300000E-05  -5.53000000E-05
   -1.37020000E-04  +1.13800000E-05  +1.91000000E-06  +1.87100000E-05  +1.36500000E-05
   +1.50700000E-05  -1.10300000E-05  +1.54000000E-06  -1.14100000E-05  +5.82500000E-05
   -3.48000000E-06  +5.84000000E-06  +1.34000000E-05  -2.56800000E-05  -9.47000000E-06
   +3.29600000E-05  +3.72210000E-04  +1.81472000E-03  -8.67240000E-04  +5.31128700E-02
   +3.00100000E-05  +5.18000000E-05  +8.54000000E-06  +2.00050000E-04  -1.51450000E-04
   +1.74800000E-05  -1.60700000E-05  +3.28300000E-05  +2.67500000E-05  -1.37100000E-05
   +6.32000000E-06  +1.07700000E-05  +4.80700000E-05  -2.72100000E-05  -1.00900000E-05
   -2.56200000E-05  -1.60800000E-05  -1.12800000E-05  +1.31620000E-04  +1.23900000E-04
   -5.51470000E-04  -2.18870000E-04  -1.56550000E-04  +1.62700000E-05  -4.76500000E-05
   +3.50700000E-05  +2.76000000E-06  -4.17958000E-03  +5.93664000E-03  -2.16978000E-03
   +8.47420000E-04  -4.68420000E-04  +4.85160000E-04  -2.25772000E-03  +2.64773000E-03
   -3.30127000E-03  -9.84860000E-04  +4.30304000E-03  -5.65580000E-04  -1.07162800E-02
   -1.18340470E-01  -1.34009700E-01  +3.55420000E-04  -3.57759000E-03  -1.28793900E-02
   +1.25062000E-03  -2.44329000E-03  +1.30635000E-03  -5.81400000E-05  -3.02400000E-05
   +6.34430000E-04  -9.92100000E-05  -5.27500000E-05  +1.58300000E-05  +3.79070000E-04
   +2.06400000E-04  +1.17760000E-04  +1.02300000E-05  -3.88000000E-06  -2.25000000E-06
   -1.13000000E-05  +2.77000000E-06  +9.40000000E-07  -8.90000000E-07  -1.37600000E-05
   -6.41000000E-06  +1.58000000E-06  -1.30900000E-05  +2.73400000E-05  +3.88000000E-06
   +2.86000000E-06  +6.89000000E-06  -1.80000000E-06  -9.66800000E-05  -5.00600000E-05
   +1.83500000E-05  -5.09000000E-06  -1.53200000E-05  +2.43000000E-06  +6.59000000E-06
   +4.21200000E-05  -1.83000000E-05  -9.01000000E-06  -3.16600000E-05  +1.30200000E-05
   -8.74000000E-06  -1.84700000E-05  -6.36000000E-06  -5.16900000E-05  -4.57000000E-06
   +1.38875000E-03  -3.62529000E-03  +2.76376000E-03  +1.36489400E-02  +1.16243620E-01
   -1.31000000E-05  -2.09300000E-05  +4.96000000E-06  -3.72300000E-05  -1.74800000E-05
   -7.38000000E-06  +1.46800000E-05  +6.31000000E-06  -3.44800000E-05  -7.15000000E-06
   +3.58700000E-05  -6.07000000E-06  +3.61000000E-06  -3.55100000E-05  +1.84400000E-05
   -1.13000000E-06  +2.45300000E-05  +2.59500000E-05  +4.16150000E-04  -2.82150000E-04
   -1.31960000E-04  -1.25770000E-04  +1.07700000E-05  +4.77100000E-05  -3.27000000E-05
   +4.50600000E-05  +3.46000000E-06  -4.59070000E-04  -3.07831000E-03  +3.16176000E-03
   +1.89640000E-04  +9.19630000E-04  +3.71300000E-04  +4.34691000E-03  -1.20869000E-03
   +1.45955000E-03  -5.55919000E-03  -1.20458600E-02  -1.30562400E-02  -4.66523000E-03
   -1.34525200E-01  -2.64323880E-01  +1.86932000E-03  -2.55411000E-03  -2.15222000E-03
   -4.61970000E-04  +3.09664000E-03  +1.63182000E-03  +3.14290000E-04  -2.41290000E-04
   -1.43822000E-03  -1.78800000E-05  +2.97700000E-05  -8.94300000E-05  +4.11300000E-05
   +3.59750000E-04  -3.65400000E-05  -7.90000000E-07  -4.62000000E-06  -5.92000000E-06
   -5.61000000E-06  +2.62000000E-06  -3.30000000E-07  +5.90000000E-06  -1.40000000E-07
   -3.35000000E-06  +2.78000000E-06  -1.55100000E-05  -1.05100000E-05  -1.16700000E-05
   +3.07000000E-06  -1.80800000E-05  -8.17000000E-06  +1.18200000E-05  -5.05400000E-05
   +5.10000000E-07  +8.38000000E-06  +7.78000000E-06  +1.45100000E-05  +3.70000000E-06
   -2.94800000E-05  +7.58000000E-06  +1.67500000E-05  +2.91400000E-05  -1.07000000E-06
   +5.93000000E-06  +4.64000000E-06  -2.21700000E-05  -2.02600000E-05  +3.23700000E-05
   -1.18792000E-03  +2.39998000E-03  -6.82270000E-04  +5.95439000E-03  +1.47900260E-01
   +2.75278360E-01  -2.23100000E-05  -3.27500000E-05  +2.38470000E-04  -4.24000000E-06
   +6.52200000E-05  +2.98500000E-05  -9.20200000E-05  -1.70000000E-06  +5.42200000E-05
   +7.33200000E-05  -1.36530000E-04  +5.27000000E-05  -2.55200000E-04  +2.64330000E-04
   -5.60000000E-05  +1.06570000E-04  +1.45600000E-04  -8.54300000E-05  -3.77160000E-04
   +1.78980000E-04  -3.18030000E-04  +1.26530000E-04  +6.99000000E-05  +2.16000000E-05
   +3.29210000E-04  -3.04740000E-04  -2.07000000E-06  +3.45800000E-05  -2.63180000E-03
   -1.71040000E-04  -7.65102000E-03  -8.25549000E-03  +1.32397000E-03  -3.04008000E-03
   +1.95195900E-02  -2.11677700E-02  +1.23906600E-02  +1.47052300E-02  +7.25269000E-03
   -2.58723000E-03  -5.85370000E-04  +2.65643000E-03  +1.08853000E-03  -6.74620000E-04
   +9.58010000E-04  -1.44639000E-02  -1.46709200E-02  +2.11807000E-03  -1.71440200E-02
   +6.75841000E-03  +8.65473000E-03  +1.53990000E-04  +5.80700000E-05  +1.20300000E-05
   -1.10394300E-02  +2.60511300E-02  +1.79924000E-03  -5.52800000E-05  +3.74000000E-05
   +5.05000000E-06  +3.34200000E-05  -1.19400000E-05  -1.52300000E-05  -2.33000000E-05
   +8.36000000E-06  -6.31000000E-06  -5.13000000E-05  +6.61700000E-05  -2.29490000E-04
   +1.55100000E-05  -1.92100000E-05  +1.77200000E-05  +8.82300000E-05  +4.37900000E-05
   +1.89600000E-05  -7.45000000E-06  -7.87300000E-05  -3.17000000E-05  -5.49200000E-05
   -8.21000000E-06  -5.34900000E-05  -3.81500000E-05  -2.88600000E-05  +4.32400000E-05
   -2.17000000E-05  -3.94500000E-05  +5.34000000E-06  +6.98700000E-05  +9.64400000E-05
   +6.26000000E-06  -2.34600000E-05  +2.50540000E-04  -2.14350000E-04  -1.47100000E-04
   +2.51410000E-04  -3.41000000E-04  +6.94599600E-02  +7.76360000E-04  +6.32500000E-05
   -1.76930000E-04  -5.66600000E-05  +1.10460000E-03  +4.60890000E-04  -2.78090000E-04
   -1.51320000E-04  +5.59540000E-04  +1.03260000E-04  -7.01930000E-04  +2.84140000E-04
   -5.91580000E-04  +1.03984000E-03  -3.66830000E-04  +1.94700000E-05  +1.79190000E-04
   -8.25300000E-05  -1.37568000E-03  +4.11300000E-05  -1.33042000E-03  +8.06270000E-04
   +1.58770000E-04  -4.94300000E-05  +1.04043000E-03  -1.09788000E-03  +8.12500000E-05
   +1.13635800E-02  -1.13863100E-02  -2.51530000E-02  -3.47898900E-02  -2.16295400E-02
   +8.89772000E-03  +1.50216900E-02  +5.16774500E-02  -3.95105300E-02  +5.10874400E-02
   +1.82966000E-02  +3.64818100E-02  -1.79002800E-02  -4.17740000E-04  +6.11771000E-03
   +1.47193400E-02  +1.35424600E-02  +1.28867100E-02  -3.94239300E-02  -3.67517700E-02
   +9.52308000E-03  +1.30461000E-02  -2.22552200E-02  +5.70023000E-03  +1.18884000E-03
   +3.74600000E-04  +4.47110000E-04  +3.34115000E-02  +1.80908400E-02  -2.33956000E-03
   -1.83210000E-04  +1.13280000E-04  +1.70500000E-05  +1.00910000E-04  -8.00300000E-05
   -5.50800000E-05  -2.02990000E-04  +3.39000000E-06  +4.75600000E-05  -7.07300000E-05
   +4.86240000E-04  -1.86710000E-04  +1.92210000E-04  -1.41950000E-04  +8.54700000E-05
   +2.34470000E-04  +1.81910000E-04  +2.25270000E-04  -4.00100000E-05  -2.11030000E-04
   -7.00200000E-05  -1.22490000E-04  -2.81000000E-06  +9.66900000E-05  -3.43550000E-04
   -2.42130000E-04  +4.26860000E-04  -9.01000000E-05  -2.39910000E-04  -1.64700000E-05
   +3.85990000E-04  +6.36170000E-04  +5.16200000E-05  +2.61520000E-04  -1.27600000E-04
   +2.82540000E-04  +1.46520000E-04  -3.45630000E-04  -6.07040000E-04  -2.45952800E-02
   -2.91376200E-02  -4.17070000E-04  +2.09600000E-05  +1.12970000E-04  -1.86470000E-04
   -7.75930000E-04  -2.91330000E-04  +5.88500000E-05  +1.52340000E-04  -2.70330000E-04
   -7.89000000E-05  +3.63700000E-04  -9.25600000E-05  +2.64860000E-04  -5.06000000E-04
   +1.76480000E-04  -1.29100000E-05  -8.18500000E-05  +8.24000000E-06  +6.38490000E-04
   +6.29990000E-04  +6.05850000E-04  -4.05190000E-04  -2.76900000E-05  +1.95580000E-04
   -5.00410000E-04  +5.21570000E-04  -3.85400000E-05  -5.88643000E-03  +3.04928000E-03
   +7.68531000E-03  +9.53112000E-03  +6.02940000E-04  -6.25200000E-04  -1.55094700E-02
   +4.05595000E-03  -9.71867000E-03  -1.40643600E-02  -1.55847000E-03  -5.19281000E-03
   +1.42001700E-02  +1.81082000E-03  -1.33125000E-03  -3.94790000E-03  -6.61179000E-03
   -7.40036000E-03  -1.20501000E-03  +5.26964000E-03  -7.25749000E-03  +1.53865100E-02
   -5.30517000E-03  -3.43550000E-03  -7.34980000E-04  -1.84480000E-04  -5.44450000E-04
   -1.26535700E-02  -2.50997000E-02  -3.59051200E-02  +8.94500000E-05  -5.04100000E-05
   -8.28000000E-06  -5.51200000E-05  +4.89200000E-05  +3.25500000E-05  +8.11900000E-05
   -2.18400000E-05  -4.06700000E-05  +1.05200000E-05  -2.24320000E-04  +1.50780000E-04
   -8.30100000E-05  +7.10600000E-05  -2.82700000E-05  -8.83900000E-05  -9.64200000E-05
   -1.51490000E-04  +4.20100000E-05  +4.10000000E-05  +3.03400000E-05  +2.81600000E-05
   +3.42200000E-05  -8.16700000E-05  +1.18660000E-04  +1.02650000E-04  -9.58000000E-05
   +5.05700000E-05  +1.44750000E-04  -1.47100000E-05  -2.52120000E-04  -3.43870000E-04
   +1.32770000E-04  -2.72480000E-04  +4.21900000E-05  -2.39700000E-05  -4.75960000E-04
   +4.71320000E-04  +1.75000000E-04  +1.61248900E-02  +2.91888700E-02  +5.68136300E-02
   -5.43700000E-05  -1.06790000E-04  +5.01500000E-05  -1.73720000E-04  +2.04100000E-05
   -2.14490000E-04  -2.60000000E-06  -2.90500000E-05  -3.92500000E-05  +3.56800000E-05
   -4.16000000E-05  +2.60100000E-05  -6.40400000E-05  +7.90500000E-05  +2.19000000E-06
   +2.35500000E-05  +6.47000000E-06  -5.43400000E-05  +5.75190000E-04  +1.46192000E-03
   -8.50880000E-04  -2.56465000E-03  -7.49200000E-04  +2.25550000E-04  +9.68700000E-05
   -9.20000000E-05  -7.95000000E-06  +7.47281000E-03  +1.37098900E-02  +1.95664700E-02
   -5.82141800E-02  -5.23652000E-03  +5.20817000E-03  +4.84653000E-03  -1.40371400E-02
   -2.27661600E-02  -3.47882000E-03  -2.82262000E-03  +1.71410000E-03  -1.04623000E-03
   -2.48500000E-05  +4.66200000E-05  -3.53946000E-03  -1.32764000E-03  +4.40674000E-03
   -8.50190000E-04  -1.26648000E-03  -1.46760000E-03  +2.35345000E-03  +1.62059000E-03
   -2.10500000E-05  +2.94830000E-04  -3.48800000E-05  -2.91900000E-05  +4.43100000E-05
   +1.20220000E-04  +1.60510000E-04  -1.24400000E-05  +1.32800000E-05  +9.54000000E-06
   +1.82800000E-05  +2.60000000E-07  +2.13000000E-06  -8.91000000E-06  +1.40400000E-05
   +6.80000000E-06  +6.27400000E-05  +6.45200000E-05  +2.68300000E-05  +5.50000000E-06
   -4.13000000E-06  +9.52000000E-06  +2.84060000E-04  +4.11400000E-05  -3.50400000E-05
   -8.33570000E-04  -1.23352000E-03  -2.26450000E-04  -1.25472000E-03  -1.84000000E-05
   -6.74560000E-04  +5.22700000E-05  +4.26100000E-05  -1.29840000E-04  +2.42300000E-05
   +1.25300000E-05  +4.48900000E-05  -2.85200000E-05  +6.00600000E-05  -1.73400000E-05
   +2.60450000E-04  +6.45050000E-04  +1.25583000E-03  -1.57100000E-05  +2.38330000E-04
   -1.22970000E-04  -1.31270000E-04  -3.05020000E-04  -2.42720000E-04  +5.57428500E-02
   +1.49550000E-04  +1.10250000E-04  -1.61560000E-04  +5.52410000E-04  +4.24300000E-04
   -1.09730000E-04  +7.58800000E-05  -1.48130000E-04  +9.80300000E-05  -4.51000000E-06
   -3.06900000E-05  -1.44500000E-05  +1.01200000E-05  +4.54600000E-05  -1.68200000E-05
   -2.73500000E-05  -3.95000000E-05  +5.25600000E-05  +8.16770000E-04  -3.70312000E-03
   +1.66727000E-03  -2.10899000E-03  +1.19140000E-04  -1.52220000E-04  +1.69700000E-05
   -3.56700000E-05  +1.38400000E-05  -1.49409000E-03  +5.29304000E-03  -1.03612000E-03
   -5.67850000E-04  -1.30122330E-01  -1.38204860E-01  -1.13385000E-03  -7.44960000E-03
   -1.73677200E-02  -3.62350000E-03  +3.91186000E-03  +2.11346000E-03  +1.10137000E-03
   -1.80640000E-04  +1.71490000E-04  -1.89304000E-03  +4.71701000E-03  -3.73693000E-03
   -5.12110000E-04  -1.01567000E-03  -1.16526000E-03  +7.22100000E-04  -6.25180000E-04
   +2.13351000E-03  -8.90050000E-04  -2.95020000E-04  -1.45120000E-04  -1.35170000E-04
   -4.27060000E-04  +3.81610000E-04  -5.09000000E-06  -8.50000000E-07  -2.80000000E-07
   +7.56000000E-06  -1.47600000E-05  -3.07000000E-06  -8.61000000E-06  -1.32000000E-06
   +7.86000000E-06  -2.11500000E-05  -8.65900000E-05  -6.75000000E-06  +5.65000000E-06
   -1.36900000E-05  -1.05800000E-05  -1.01540000E-04  -2.93620000E-04  +3.93220000E-04
   -1.36149000E-03  -7.80560000E-04  -2.73840000E-04  +2.82730000E-04  -2.52180000E-04
   +3.05610000E-04  +2.57200000E-05  -6.14000000E-06  -1.11900000E-05  +1.85600000E-05
   -3.16700000E-05  +9.52000000E-06  +1.23100000E-05  -1.86520000E-04  +1.91580000E-04
   -7.25800000E-05  -3.05030000E-04  +1.52570000E-04  +2.30840000E-04  -4.91830000E-04
   +1.56200000E-04  +9.40320000E-04  +9.89470000E-04  -1.65980000E-04  +9.00930000E-03
   +1.31014450E-01  -1.78900000E-05  -2.74200000E-05  +7.45600000E-05  -3.20940000E-04
   -1.09570000E-04  +3.59200000E-05  -2.58000000E-05  +6.29800000E-05  -3.21400000E-05
   +2.64000000E-06  +2.62100000E-05  +1.18500000E-05  +7.10000000E-07  -2.61600000E-05
   -2.72000000E-06  -9.54000000E-06  +1.18500000E-05  +6.99000000E-06  -1.91886000E-03
   +1.37498000E-03  -2.07288000E-03  -1.58493000E-03  -9.28310000E-04  +1.89400000E-04
   -2.34900000E-05  +3.05400000E-05  -3.50000000E-07  -3.29470000E-04  -1.07275600E-02
   -1.07421100E-02  +3.59799000E-03  -1.39585350E-01  -2.51775880E-01  +3.45340000E-03
   -3.45867000E-03  -2.58741000E-03  +5.59370000E-04  -2.08853000E-03  +1.77438000E-03
   -5.01680000E-04  +5.54750000E-04  +5.22140000E-04  +4.81186000E-03  -2.46640000E-03
   +1.83132000E-03  -4.57500000E-04  -1.79100000E-04  -8.09800000E-05  -1.46820000E-04
   +1.61935000E-03  +3.54700000E-05  +7.15720000E-04  +1.14080000E-04  +1.26300000E-04
   -1.24610000E-04  -3.39560000E-04  +2.26990000E-04  +1.43000000E-06  -1.83000000E-06
   -4.42000000E-06  -5.36000000E-06  +4.02000000E-06  -8.00000000E-08  -1.43000000E-06
   -5.97000000E-06  -1.28200000E-05  +2.52500000E-05  -1.87300000E-05  -2.70800000E-05
   -2.95000000E-06  +4.17000000E-06  -5.70000000E-07  -4.62730000E-04  +2.68420000E-04
   +2.96060000E-04  -4.15990000E-04  +4.29320000E-04  +2.25220000E-04  -5.41770000E-04
   -2.42540000E-04  +9.42000000E-06  -6.13000000E-05  -2.64000000E-06  +5.77200000E-05
   +2.16100000E-05  +8.04500000E-05  -6.20000000E-05  +4.69900000E-05  +1.85820000E-04
   -1.19370000E-04  -1.78480000E-04  -2.78540000E-04  -7.40890000E-04  -1.99540000E-04
   +2.91640000E-04  -2.30810000E-04  -5.25450000E-04  +1.26710000E-04  -5.78830000E-04
   -5.42089000E-03  +1.55168680E-01  +2.63861280E-01  -2.54000000E-06  +1.05600000E-05
   +5.90500000E-05  +5.93700000E-05  -5.28200000E-05  -2.23300000E-05  -5.24900000E-05
   +4.74900000E-05  +7.34000000E-06  +2.15900000E-05  -1.84300000E-05  +3.23000000E-06
   -3.01500000E-05  +3.03500000E-05  -9.15000000E-06  -1.43700000E-05  +2.71800000E-05
   +1.93100000E-05  +1.20140000E-04  +4.54300000E-05  -7.42000000E-06  -1.61000000E-05
   -1.59700000E-05  +3.92100000E-05  +2.58800000E-05  -6.47000000E-06  -2.47000000E-06
   +1.44985000E-03  -1.96206000E-03  -3.48475000E-03  -4.15555000E-03  -1.91850000E-03
   +1.02525000E-03  -3.82040000E-04  +7.19049000E-03  -7.09065000E-03  +1.44791300E-02
   +2.51611000E-03  +9.35542000E-03  -7.03997000E-03  -6.53450000E-04  +7.05220000E-04
   +1.80000000E-03  +2.70124000E-03  +2.19465000E-03  -1.91649800E-02  -1.44679100E-02
   +6.12357000E-03  +3.57070000E-04  -1.28475000E-03  -7.11200000E-05  -7.07000000E-06
   +1.30800000E-05  -1.13000000E-05  -1.44537300E-01  +2.33924500E-02  -1.34570000E-01
   -1.02600000E-05  +2.85000000E-06  +2.00000000E-07  +1.69000000E-06  +2.18000000E-06
   -4.34000000E-06  +7.75000000E-06  +2.01000000E-06  -8.83000000E-06  +2.68400000E-05
   -5.15700000E-05  -1.74100000E-05  -2.55700000E-05  +8.97000000E-06  -1.14800000E-05
   -7.00000000E-06  -7.32000000E-06  -7.09000000E-06  -3.23000000E-06  +1.98200000E-05
   +1.48900000E-05  +4.23000000E-06  +6.23000000E-06  +2.16000000E-06  -1.30100000E-05
   -1.48800000E-05  +3.54300000E-05  -9.33000000E-06  +2.50100000E-05  -1.58200000E-05
   -1.41300000E-05  +7.90000000E-06  +3.44200000E-05  -3.89000000E-05  -1.58030000E-04
   +1.34120000E-04  +2.19250000E-04  -2.89840000E-04  +1.65180000E-04  -1.86623300E-02
   -2.57714000E-02  -8.02335000E-03  -6.26700000E-05  -9.66700000E-05  +1.07000000E-05
   +1.58449380E-01  +7.85900000E-05  -1.65200000E-05  -5.28000000E-05  -1.92700000E-05
   +3.04310000E-04  +1.03980000E-04  +1.65500000E-05  -9.71700000E-05  +8.51600000E-05
   +2.04700000E-05  -1.31280000E-04  +4.33400000E-05  -1.88210000E-04  +2.40200000E-04
   -4.33500000E-05  +7.28200000E-05  +2.01400000E-05  -6.49000000E-05  -4.48540000E-04
   -1.85740000E-04  -1.98330000E-04  +1.77740000E-04  +3.70100000E-05  -7.14400000E-05
   +2.73640000E-04  -2.86820000E-04  +6.94000000E-06  -2.26970000E-04  +1.25724000E-03
   +1.96903000E-03  +1.63519000E-03  +1.29024000E-03  -5.43410000E-04  +5.20830000E-04
   -6.78640000E-03  +6.17847000E-03  -2.23585100E-02  -1.70409800E-02  +2.12890000E-04
   +4.99746000E-03  +2.28580000E-04  -3.51370000E-04  -1.13974000E-03  -1.43846000E-03
   -1.48118000E-03  +8.02450000E-03  +1.01159500E-02  -1.42735200E-02  -7.23760000E-04
   +1.67628000E-03  +9.60000000E-04  +2.45190000E-04  +3.91900000E-05  +1.37280000E-04
   +1.37172100E-02  -3.66085500E-02  +2.37250200E-02  -4.19200000E-05  +3.26600000E-05
   +8.83000000E-06  +3.14900000E-05  -1.87200000E-05  -1.13400000E-05  -4.41000000E-05
   +6.58000000E-06  +1.76300000E-05  -4.34500000E-05  +1.37090000E-04  -5.43900000E-05
   +4.44400000E-05  -3.06400000E-05  +2.88500000E-05  +7.28600000E-05  +5.21700000E-05
   +4.95300000E-05  -1.23400000E-05  -7.59600000E-05  -3.66400000E-05  -4.32900000E-05
   -6.57000000E-06  -5.28000000E-06  -3.83300000E-05  -2.41000000E-05  +1.87000000E-06
   -1.25600000E-05  -8.73100000E-05  +2.71100000E-05  +1.11910000E-04  +1.12570000E-04
   -5.82100000E-05  +1.49000000E-04  +1.10740000E-04  -1.33220000E-04  -7.50300000E-05
   +2.11800000E-04  -2.26260000E-04  -1.17972000E-02  +8.63201000E-03  -1.76257700E-02
   +1.48920000E-04  +2.51150000E-04  +7.71500000E-05  +1.06283900E-02  +4.07126400E-02
   -1.27190000E-04  +3.11400000E-05  +1.60070000E-04  +1.00680000E-04  -3.31280000E-04
   -1.38380000E-04  -1.03520000E-04  +1.67050000E-04  -6.78400000E-05  +1.70000000E-05
   +6.92700000E-05  -3.83600000E-05  +1.21240000E-04  -1.44700000E-04  +1.95000000E-05
   -8.27400000E-05  +5.40000000E-07  +4.64500000E-05  +6.67350000E-04  +3.16960000E-04
   +7.92900000E-05  -2.01570000E-04  -5.45600000E-05  +1.42760000E-04  -1.93210000E-04
   +2.08540000E-04  -2.67300000E-05  +2.87329000E-03  -4.82943000E-03  -8.25428000E-03
   -8.59221000E-03  -4.75572000E-03  +2.33571000E-03  -6.95559000E-03  +2.05057400E-02
   -1.57085500E-02  +4.63342500E-02  +2.78167200E-02  +1.03047500E-02  -1.41900000E-02
   -1.52544000E-03  +3.22164000E-03  +5.56391000E-03  +5.87925000E-03  +5.52354000E-03
   -2.17043500E-02  -4.29622000E-02  +1.07414700E-02  +5.15673000E-03  -1.22378000E-03
   -2.51767000E-03  -2.31350000E-04  -6.44000000E-06  -1.39430000E-04  -7.97976100E-02
   +3.66145900E-02  -1.96610730E-01  +3.30300000E-05  -1.68000000E-05  +4.57000000E-06
   -2.09500000E-05  +2.36900000E-05  +9.12000000E-06  +4.97500000E-05  +8.00000000E-08
   -2.36600000E-05  +5.84500000E-05  -2.16830000E-04  +3.99900000E-05  -6.99800000E-05
   +4.78100000E-05  -1.13500000E-05  -6.78600000E-05  -6.58600000E-05  -6.32900000E-05
   +1.80100000E-05  +7.17300000E-05  +5.72100000E-05  +3.37200000E-05  +2.45200000E-05
   +6.21000000E-06  +1.23300000E-05  -2.34000000E-06  +5.10300000E-05  +4.02000000E-06
   +1.13080000E-04  -4.99900000E-05  -1.29660000E-04  -8.41900000E-05  +1.12790000E-04
   -1.20780000E-04  -7.28700000E-05  +2.42390000E-04  +3.09710000E-04  -4.61890000E-04
   +5.03400000E-05  -2.13657600E-02  -4.58987600E-02  +1.11770300E-02  -3.16230000E-04
   -2.82980000E-04  -8.99700000E-05  +1.08069160E-01  +8.98027000E-03  +1.99379710E-01
   +1.26000000E-06  +4.00000000E-08  +3.39700000E-05  +5.96600000E-05  +6.81800000E-05
   +2.61300000E-05  -3.24800000E-05  +3.19000000E-06  +4.18900000E-05  +2.51300000E-05
   -6.42300000E-05  +2.06300000E-05  -1.10390000E-04  +1.22270000E-04  -1.97500000E-05
   +2.84200000E-05  +3.43200000E-05  -1.81600000E-05  -1.08130000E-04  -1.56540000E-04
   +2.85910000E-04  +7.15800000E-05  +3.60200000E-05  +2.37100000E-05  +1.41850000E-04
   -1.22950000E-04  +2.00000000E-06  -6.71870000E-04  -1.14988000E-03  -8.44140000E-04
   -2.98697000E-03  +3.00232000E-03  +3.00934000E-03  -4.61030400E-02  -1.19824100E-02
   -1.74024000E-02  +4.44580000E-04  -1.10633000E-03  +1.20814000E-03  -1.14388000E-03
   -9.04350000E-04  -8.30780000E-04  +2.58150000E-04  +1.79560000E-04  +3.17500000E-05
   -9.95670000E-04  -2.39130000E-04  -2.41541000E-03  -2.73041430E-01  -9.93901700E-02
   -1.72288850E-01  -3.55100000E-05  -2.31500000E-05  -1.80600000E-05  -4.88000000E-06
   -1.07745000E-03  +5.93800000E-05  -2.89900000E-05  +1.46300000E-05  +2.16000000E-06
   +1.45900000E-05  -6.39000000E-06  -9.77000000E-06  -9.43000000E-06  +2.46000000E-06
   -2.85000000E-06  -1.62100000E-05  +1.42000000E-05  -3.86200000E-05  -6.42000000E-06
   -5.09000000E-06  -5.50000000E-07  +3.65200000E-05  +1.36800000E-05  +4.23000000E-06
   -1.10100000E-05  -3.74500000E-05  -9.22000000E-06  -2.40800000E-05  +8.22000000E-06
   -2.39300000E-05  -1.89900000E-05  -1.27200000E-05  +1.58300000E-05  -1.08600000E-05
   -2.74200000E-05  +8.66000000E-06  +3.20100000E-05  +5.10000000E-06  +2.01500000E-05
   +2.84400000E-05  -3.48500000E-05  +1.35400000E-05  +3.64400000E-04  +1.19640000E-04
   -2.60620000E-04  -1.23134000E-03  +4.35520000E-04  -2.48710000E-04  +1.18720000E-04
   +1.75950000E-04  +1.27100000E-05  +3.08200000E-04  +1.09254000E-03  +3.87010000E-04
   +3.24304590E-01  +1.30900000E-05  +5.54000000E-06  -2.40900000E-05  -6.25800000E-05
   -3.52700000E-05  -1.06200000E-05  -1.04200000E-05  +9.60000000E-06  -3.25000000E-06
   -9.06000000E-06  +8.30000000E-07  +1.05500000E-05  +1.24800000E-05  -3.67000000E-06
   -4.47000000E-06  -9.41000000E-06  -7.36000000E-06  +1.83000000E-06  +7.01300000E-05
   +8.63100000E-05  -3.68100000E-05  -1.74100000E-05  +1.10300000E-05  +4.19400000E-05
   -1.35900000E-05  -7.80000000E-07  -2.70000000E-07  +1.29230000E-04  -2.34420000E-04
   -2.15974000E-03  -1.02636000E-03  -1.21119000E-03  +7.81600000E-05  +1.70237000E-03
   +5.18773000E-03  +4.77928000E-03  +1.12995700E-02  +4.75670000E-03  -1.48278000E-03
   -3.21947000E-03  -1.30416000E-03  +1.23516000E-03  +1.34869000E-03  +1.10570000E-03
   +1.06707000E-03  -8.08784000E-03  -2.36838000E-03  +5.21918000E-03  -1.15682970E-01
   -6.60220300E-02  -1.03870430E-01  -5.76900000E-05  +2.86000000E-05  -4.17900000E-05
   -1.38951000E-03  -2.41370000E-04  +3.39870000E-04  +5.60000000E-06  +1.85000000E-06
   +1.70000000E-06  -2.65000000E-06  +2.65000000E-06  +3.55000000E-06  -7.90000000E-06
   -3.19000000E-06  +2.45000000E-06  -1.88000000E-06  +9.73000000E-06  +1.74400000E-05
   +9.43000000E-06  -1.90000000E-06  +5.93000000E-06  -4.82000000E-06  -6.93000000E-06
   -9.66000000E-06  +1.04600000E-05  -1.01800000E-05  -1.75000000E-06  +6.26000000E-06
   +3.53000000E-06  +1.36500000E-05  -9.85000000E-06  -1.75000000E-06  +2.50400000E-05
   +6.50000000E-06  -4.37000000E-06  -1.75900000E-05  -1.29800000E-05  -4.45000000E-06
   +3.91700000E-05  -9.67000000E-05  -3.93400000E-05  +3.03600000E-05  +1.22180000E-04
   +7.20200000E-05  -9.70300000E-05  +2.33714000E-03  +2.69800000E-05  -9.58560000E-04
   +1.38450000E-04  -2.47180000E-04  +1.03410000E-04  +1.53255000E-03  -2.33535000E-03
   -6.73880000E-04  +1.10343120E-01  +6.35816900E-02  -9.31000000E-06  -3.07000000E-06
   +8.17000000E-06  +1.62600000E-05  +2.20300000E-05  -2.04800000E-05  -6.51000000E-06
   -5.30000000E-07  -6.75000000E-06  +4.40000000E-07  +5.30000000E-07  -8.56000000E-06
   +2.08200000E-05  -1.43100000E-05  -5.00000000E-08  -1.48600000E-05  -6.79000000E-06
   -2.26000000E-06  +2.86500000E-04  +3.30000000E-06  -2.04590000E-04  -5.38700000E-05
   -1.46600000E-05  +3.16000000E-06  -2.31300000E-05  +1.69200000E-05  -5.62000000E-06
   +1.19549000E-03  -2.47090000E-04  -7.13040000E-04  +3.22097000E-03  -2.08507000E-03
   -2.81669000E-03  +1.64889200E-02  +1.12089200E-02  +1.23709900E-02  +1.57048700E-02
   +1.00334000E-03  +4.74950000E-04  -3.32671000E-03  -4.80070000E-04  +4.74060000E-04
   +1.01871000E-03  +9.46090000E-04  +1.07584000E-03  -9.53313000E-03  +4.30732000E-03
   -7.68600000E-05  -2.14003220E-01  -1.08140230E-01  -2.05062220E-01  -8.45000000E-06
   -1.56100000E-05  -6.29000000E-06  +8.01880000E-04  +1.13821000E-03  -2.01921000E-03
   +7.06000000E-06  -7.30000000E-07  +4.52000000E-06  +5.50000000E-07  +2.23000000E-06
   +3.75000000E-06  +5.53000000E-06  +3.74000000E-06  +1.59000000E-06  +1.21500000E-05
   -1.04700000E-05  +1.99500000E-05  -3.40000000E-07  +4.35000000E-06  +4.50000000E-06
   +1.39000000E-06  -1.00000000E-05  -8.80000000E-06  +5.15000000E-06  -9.66000000E-06
   +1.43800000E-05  -4.30000000E-06  +1.45600000E-05  -1.28000000E-06  +7.96000000E-06
   -1.95000000E-06  -6.05000000E-06  -1.63000000E-06  +2.20200000E-05  +7.70000000E-07
   -2.23000000E-05  -1.40000000E-06  +7.96000000E-06  -7.19100000E-05  -9.79000000E-05
   +1.46200000E-05  +2.00660000E-04  -6.80300000E-05  -9.75000000E-06  -9.92690000E-04
   -2.95315000E-03  -3.70800000E-05  -1.29630000E-04  -3.94800000E-05  -9.91900000E-05
   +5.27590000E-04  -1.01135000E-03  +3.24876000E-03  +1.89605580E-01  +9.53646400E-02
   +1.93768420E-01  -8.26600000E-05  -1.73200000E-05  +4.10600000E-05  +5.28300000E-05
   +3.06400000E-05  -1.25300000E-05  -2.13300000E-05  +1.81100000E-05  +5.70000000E-06
   +2.44700000E-05  -2.96900000E-05  +1.93000000E-06  -8.45100000E-05  +7.33000000E-05
   +1.10000000E-06  +3.50500000E-05  +1.11400000E-05  -2.26500000E-05  -3.09500000E-05
   -1.36400000E-05  -1.87700000E-05  +1.64900000E-05  -2.90600000E-05  +2.84100000E-05
   +9.15000000E-05  -7.14400000E-05  -7.75000000E-06  +7.41000000E-05  -8.03500000E-05
   -3.82140000E-04  -7.60680000E-04  -1.42720000E-04  +1.80600000E-05  +1.31149000E-03
   +7.37660000E-04  -3.21450000E-04  -8.88280000E-04  -8.91180000E-04  -5.37400000E-05
   +1.17510000E-04  -1.81960000E-04  +9.37100000E-05  +1.92990000E-04  +2.21450000E-04
   +1.64760000E-04  -1.91920000E-03  +3.36144000E-03  -2.58292000E-03  -6.11830000E-04
   -3.10160000E-04  +2.50450000E-04  +3.05400000E-05  +1.69000000E-06  +1.23100000E-05
   -2.13812080E-01  +3.89688800E-02  +2.44963990E-01  -1.77300000E-05  +1.09400000E-05
   +3.86000000E-06  +1.10900000E-05  -5.50000000E-07  -6.08000000E-06  +2.38000000E-06
   +5.69000000E-06  -4.93000000E-06  -3.63000000E-06  -1.10100000E-05  +1.40500000E-05
   -2.11000000E-05  +8.20000000E-06  +5.82000000E-06  +1.51800000E-05  +1.21700000E-05
   -4.47000000E-06  -7.91000000E-06  +8.80000000E-07  -5.88000000E-06  -1.58300000E-05
   +2.42000000E-06  -1.92900000E-05  -4.18000000E-06  -5.96000000E-06  -1.30000000E-07
   -8.15000000E-06  -4.18000000E-06  +3.69000000E-06  +1.65500000E-05  +1.59300000E-05
   -2.15000000E-06  +1.33600000E-05  -1.38700000E-05  +4.14000000E-06  -1.91200000E-05
   +7.37000000E-06  -4.17000000E-06  -6.84618000E-03  +1.79944000E-03  +8.71907000E-03
   +2.37400000E-05  -9.64700000E-05  +1.70400000E-05  +1.69186600E-02  -4.84652000E-03
   -1.55390500E-02  +3.53450000E-04  +6.35830000E-04  -9.26520000E-04  +2.05853990E-01
   -3.15000000E-05  -9.56000000E-06  +1.48600000E-05  -2.17500000E-05  +4.75200000E-05
   +3.31000000E-06  +2.10000000E-07  -1.73400000E-05  +1.25000000E-05  +6.08000000E-06
   -2.97900000E-05  +1.42100000E-05  -7.99800000E-05  +7.28400000E-05  -1.03000000E-06
   +3.79100000E-05  +2.26700000E-05  -3.66000000E-05  -4.85200000E-05  +9.56000000E-06
   -3.83000000E-05  +2.69800000E-05  +2.58000000E-06  +1.79100000E-05  +9.51000000E-05
   -9.32400000E-05  +1.32000000E-06  -4.31970000E-04  +2.54560000E-04  +4.06220000E-04
   +1.20638000E-03  -5.87500000E-05  -1.13300000E-04  -4.44377000E-03  -2.10573000E-03
   +3.76021000E-03  +1.38050000E-04  -3.44748000E-03  +2.64012000E-03  +1.33637000E-03
   -1.35390000E-04  -3.57770000E-04  -2.88880000E-04  -2.25320000E-04  -5.81440000E-04
   -7.92970000E-04  -2.96870000E-04  -3.78470000E-04  +3.09577000E-03  +2.10067000E-03
   -3.41141000E-03  +2.18600000E-05  -6.96000000E-06  -2.95000000E-06  +4.82135000E-02
   -3.18955500E-02  -7.71317900E-02  -1.45000000E-05  +1.18200000E-05  +2.26000000E-06
   +9.61000000E-06  -3.44000000E-06  -2.81000000E-06  -1.01800000E-05  +1.55000000E-06
   +1.68000000E-06  -2.04600000E-05  +3.67000000E-05  -1.41900000E-05  +9.10000000E-06
   -6.03000000E-06  +3.49000000E-06  +2.94300000E-05  +1.23700000E-05  -6.13000000E-06
   -4.80000000E-07  -3.98600000E-05  -4.39000000E-06  -3.15500000E-05  +1.43300000E-05
   -1.73000000E-05  -6.70000000E-06  -3.53000000E-06  -5.73000000E-06  -1.77000000E-06
   -1.72800000E-05  +7.37000000E-06  +1.56400000E-05  +1.45600000E-05  +1.26000000E-06
   +3.56000000E-06  -3.20600000E-05  -2.05300000E-05  +1.95900000E-05  +4.53300000E-05
   -5.66400000E-05  -7.97522000E-03  +9.28224000E-03  +1.30160700E-02  -1.17180000E-04
   -9.15600000E-05  -4.76300000E-05  -1.44022000E-03  -2.98000000E-04  +2.73894000E-03
   +6.69560000E-04  -8.07240000E-04  +1.15336000E-03  -3.91771100E-02  +2.76916900E-02
   -7.97700000E-05  -1.40400000E-05  -3.03100000E-05  -1.96800000E-05  -1.22730000E-04
   -6.18700000E-05  +1.72700000E-05  +2.60700000E-05  -5.32900000E-05  -1.72800000E-05
   +7.10900000E-05  -2.86200000E-05  +9.63700000E-05  -1.20130000E-04  +3.32600000E-05
   -2.76400000E-05  -4.45300000E-05  +3.62000000E-06  +1.86280000E-04  +8.31500000E-05
   +1.33150000E-04  -9.54000000E-05  -4.47800000E-05  +3.67400000E-05  -1.41090000E-04
   +1.29890000E-04  -1.67400000E-05  -6.35710000E-04  +4.71140000E-04  +9.08450000E-04
   +1.54910000E-03  +7.63720000E-04  -5.36100000E-05  +1.88650000E-04  -3.27370000E-03
   +7.71360000E-04  -1.07647000E-03  +4.08940000E-04  -7.84480000E-04  +4.12370000E-04
   -2.81590000E-04  -7.65000000E-05  -4.99840000E-04  -4.76640000E-04  -5.18870000E-04
   -4.45520000E-04  +1.30789000E-03  +3.68820000E-04  -1.74150000E-04  -1.66546000E-03
   -1.56250000E-04  -1.23490000E-04  -3.91600000E-05  -6.83100000E-05  +2.06673090E-01
   -5.69695000E-02  -3.44045200E-01  +2.83100000E-05  -1.13800000E-05  +4.60000000E-06
   -1.21400000E-05  +1.08600000E-05  +1.01800000E-05  +2.06300000E-05  -9.50000000E-07
   -2.30000000E-06  +3.08600000E-05  -2.55200000E-05  +9.06900000E-05  -1.03500000E-05
   +2.17400000E-05  +1.13900000E-05  -3.33900000E-05  -2.20800000E-05  -2.88800000E-05
   +1.22200000E-05  +2.24600000E-05  +1.43800000E-05  +9.27000000E-06  +1.86100000E-05
   -3.61000000E-06  +3.09800000E-05  +2.21000000E-05  -3.55100000E-05  +1.25300000E-05
   +3.35500000E-05  -1.57000000E-06  -5.43000000E-05  -6.49900000E-05  +1.25000000E-05
   -3.39800000E-05  +4.45000000E-06  +1.04400000E-05  +9.45000000E-06  +1.08700000E-05
   +1.48700000E-05  +4.18235000E-03  +6.80766000E-03  -4.13218000E-03  +4.50000000E-06
   -1.12070000E-04  -2.45400000E-05  +2.48314100E-02  -6.37060000E-03  -2.32141400E-02
   -3.80910000E-04  +1.01237000E-03  -3.91600000E-04  -2.34434520E-01  +5.84333300E-02
   +3.71303930E-01
end_hess

