# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -806.84359350    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +2.91643055E+00  +1.17006340E+00  -5.36733013E-02
   006   +4.98799387E+00  +1.52091066E+00  +1.51224201E+00
   006   +7.10247355E+00  -2.89077291E-02  +1.35794556E+00
   006   +7.17767139E+00  -1.97686608E+00  -3.88419326E-01
   006   +5.11887392E+00  -2.36556740E+00  -1.97484121E+00
   006   +3.03502266E+00  -8.10418004E-01  -1.79300482E+00
   001   +4.99789233E+00  +3.01992067E+00  +2.89942519E+00
   001   +8.69130706E+00  +2.91027376E-01  +2.61103770E+00
   008   +9.18421913E+00  -3.55728799E+00  -6.31876576E-01
   001   +5.17958608E+00  -3.89482052E+00  -3.32866512E+00
   001   +1.43939780E+00  -1.15934313E+00  -3.02679482E+00
   006   +5.75907532E-01  +2.87032900E+00  -2.90281483E-04
   006   -1.78681639E+00  +1.21558288E+00  +2.41620058E-01
   006   +5.92905811E-01  +4.70868873E+00  +2.24631210E+00
   006   +5.60958571E-01  +4.45131310E+00  -2.43367534E+00
   006   -1.87754006E+00  -6.01934964E-01  +2.18855971E+00
   006   -3.92054641E+00  -2.16538697E+00  +2.58979819E+00
   006   -6.00288486E+00  -1.94221601E+00  +1.01166163E+00
   006   -6.09019108E+00  -5.80166946E-03  -8.82855398E-01
   006   -3.84270169E+00  +1.44105629E+00  -1.32160033E+00
   001   -2.41653562E-01  -8.09464371E-01  +3.40067642E+00
   001   -3.89266655E+00  -3.59925403E+00  +4.04452527E+00
   008   -8.00377525E+00  -3.42587141E+00  +1.11585588E+00
   001   -7.55588665E+00  +1.43763298E+00  -1.06509663E-01
   001   -3.90579117E+00  +2.77968793E+00  -2.86237826E+00
   001   +7.14888908E-01  +3.72090732E+00  +4.05035065E+00
   001   +2.17011924E+00  +6.02957899E+00  +2.11839647E+00
   001   -1.14969084E+00  +5.80713620E+00  +2.24459049E+00
   001   +4.18482704E-01  +3.26952833E+00  -4.11456114E+00
   001   -9.97694663E-01  +5.80095772E+00  -2.44719533E+00
   001   +2.31892460E+00  +5.51606315E+00  -2.56191109E+00
   001   +1.04704353E+01  -3.09918774E+00  +5.53589865E-01
   008   -8.19911363E+00  -3.19925938E-02  -2.40864600E+00
   001   -9.04060150E+00  -2.84799217E+00  -3.11805839E-01
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +2.00000000E-08  -9.00000000E-08  -2.00000000E-07
   +1.30000000E-07  -2.80000000E-07  -4.30000000E-07
   +1.20000000E-07  -4.60000000E-07  -6.90000000E-07
   -1.10000000E-07  -3.30000000E-07  -6.60000000E-07
   -3.80000000E-07  -1.60000000E-07  -5.40000000E-07
   -2.40000000E-07  -1.30000000E-07  -3.30000000E-07
   +3.80000000E-07  -3.10000000E-07  -3.50000000E-07
   +2.10000000E-07  -5.20000000E-07  -8.00000000E-07
   -3.10000000E-07  -4.00000000E-07  -9.40000000E-07
   -5.70000000E-07  -1.50000000E-07  -6.00000000E-07
   -3.90000000E-07  +3.00000000E-08  -1.60000000E-07
   +1.10000000E-07  -2.00000000E-08  +6.00000000E-08
   +1.60000000E-07  +8.00000000E-08  +3.30000000E-07
   +4.10000000E-07  -9.00000000E-08  +9.00000000E-08
   -5.00000000E-08  +4.00000000E-08  +1.10000000E-07
   +1.70000000E-07  +1.50000000E-07  +8.00000000E-08
   -4.00000000E-08  +1.00000000E-07  +2.80000000E-07
   -6.00000000E-08  +1.40000000E-07  +6.40000000E-07
   -1.10000000E-07  +4.90000000E-07  +5.30000000E-07
   -2.60000000E-07  +1.90000000E-07  +4.00000000E-07
   +2.40000000E-07  -7.00000000E-08  +1.00000000E-08
   +1.40000000E-07  +1.10000000E-07  +2.40000000E-07
   -9.00000000E-08  +4.60000000E-07  +6.10000000E-07
   +8.00000000E-08  +4.60000000E-07  +7.50000000E-07
   -1.50000000E-07  +3.60000000E-07  +4.30000000E-07
   +5.30000000E-07  -1.50000000E-07  +7.00000000E-08
   +4.80000000E-07  -1.40000000E-07  +0.00000000E+00
   +4.60000000E-07  +2.00000000E-08  +2.90000000E-07
   -2.60000000E-07  +1.10000000E-07  +6.00000000E-08
   +1.00000000E-08  +1.60000000E-07  +2.80000000E-07
   +1.00000000E-08  -2.00000000E-08  -4.00000000E-08
   -1.80000000E-07  -5.50000000E-07  -1.09000000E-06
   -2.90000000E-07  +4.80000000E-07  +7.70000000E-07
   -1.90000000E-07  +4.90000000E-07  +8.20000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.75316840E-01  -9.51679300E-02  +4.64031030E-01  +1.49883390E-01  +1.93106770E-01
   +4.51302920E-01  -2.46158540E-01  +1.84825900E-02  -9.15654100E-02  +5.91000140E-01
   -2.90464800E-02  -1.10765390E-01  -5.75077700E-02  -1.34652930E-01  +5.10849310E-01
   -1.34840660E-01  -3.04522000E-02  -1.75099960E-01  +1.47594300E-01  +2.58947760E-01
   +4.68186820E-01  -4.80905300E-02  -4.74254000E-03  -3.75288500E-02  -2.54799220E-01
   +1.42463180E-01  +1.30676100E-02  +6.35434510E-01  +3.18650900E-02  +3.79757000E-02
   +4.65210700E-02  +9.44650100E-02  -1.76679370E-01  -4.98384600E-02  -1.38346670E-01
   +4.74892190E-01  -3.84362000E-03  +2.55328000E-02  +2.76221900E-02  -3.04730100E-02
   -2.17799200E-02  -9.74332000E-02  +1.80101910E-01  +2.38846560E-01  +4.52965330E-01
   -1.43895200E-02  -2.48444000E-02  -2.88202500E-02  +3.59791600E-02  +1.25768100E-02
   +3.14504500E-02  -1.25564150E-01  +3.91693600E-02  +1.77141000E-03  +6.30770350E-01
   -2.28455600E-02  -2.42805400E-02  -3.04612700E-02  +5.32147600E-02  -3.45217400E-02
   -2.02302000E-03  -1.80473700E-02  -2.12142310E-01  -1.42641140E-01  -1.34648210E-01
   +5.03279090E-01  -2.66235100E-02  -3.18231600E-02  -5.08676100E-02  +6.95078800E-02
   -2.59377400E-02  +1.89391900E-02  -5.07814900E-02  -1.08091140E-01  -1.98978360E-01
   +1.56651170E-01  +2.31017230E-01  +4.69139310E-01  +2.86565300E-02  +5.11646100E-02
   +6.07197200E-02  -6.37078700E-02  +1.52822100E-02  -2.14761900E-02  +3.43825700E-02
   -5.76644300E-02  -3.72736800E-02  -2.21660300E-01  +9.80036000E-03  -8.13740900E-02
   +6.10677030E-01  +1.51309700E-02  -2.95715000E-02  -2.52659200E-02  +1.66543700E-02
   -6.88745000E-03  +6.11489000E-03  -2.48914300E-02  +1.24392400E-02  -1.11005400E-02
   -4.51268800E-02  -1.16849590E-01  -6.85879500E-02  -1.58486050E-01  +5.26810530E-01
   +2.60929800E-02  -3.77672000E-03  +2.09437000E-02  -2.08593200E-02  +5.56413000E-03
   -1.02287400E-02  -7.17378000E-03  -3.07594900E-02  -2.43050000E-02  -1.31158230E-01
   -3.56282800E-02  -1.82330000E-01  +1.41138150E-01  +2.67082470E-01  +4.58236460E-01
   -1.19156470E-01  -5.23508000E-03  -3.49503500E-02  +3.31726800E-02  -2.66054400E-02
   -1.02491400E-02  -1.84846800E-02  +2.41222100E-02  +1.30375300E-02  -5.18291800E-02
   -4.12552000E-03  -3.58511500E-02  -2.70799440E-01  +1.53861820E-01  +1.53129900E-02
   +6.55122760E-01  +4.17669000E-02  -2.07899210E-01  -9.94599100E-02  -6.33937100E-02
   +1.06005400E-02  -3.52967000E-02  +2.80427400E-02  -4.62404300E-02  -2.27266400E-02
   +3.61327200E-02  +4.05167400E-02  +5.64604100E-02  +1.05508350E-01  -1.89043930E-01
   -5.48461300E-02  -1.38602730E-01  +4.78446790E-01  +9.27315000E-03  -1.27548240E-01
   -1.81675760E-01  -4.40130500E-02  -1.36704600E-02  -3.01364000E-02  +1.67397600E-02
   -2.52824800E-02  -1.65778400E-02  +1.22107000E-03  +3.28553700E-02  +3.28101900E-02
   -2.90182200E-02  -2.61271500E-02  -1.01412010E-01  +1.72191130E-01  +2.19428610E-01
   +4.46330850E-01  +6.11687000E-03  -1.79809900E-02  -1.55096000E-02  -5.53351700E-02
   +3.24803000E-03  -7.27249000E-03  +3.37135000E-03  +1.95038500E-02  +1.77288300E-02
   -2.40432000E-03  +4.37082000E-03  -2.00047000E-03  -1.31653000E-03  +1.04200000E-04
   +3.34500000E-05  -2.94340000E-03  +8.37420000E-04  -5.08031000E-03  +5.44436900E-02
   +2.79610000E-04  +4.30890000E-04  -3.43704000E-03  +3.04064000E-03  -2.03262590E-01
   -1.50245080E-01  -1.45505000E-03  -9.83436000E-03  -1.30942200E-02  +4.58665000E-03
   +2.45965000E-03  -1.94570000E-03  -6.05000000E-06  -1.67830000E-04  +9.76720000E-04
   +6.53150000E-04  +3.47115000E-03  -2.74334000E-03  -8.83480000E-03  +2.13039270E-01
   +1.46939000E-03  -1.44633500E-02  -8.09719000E-03  -7.67185000E-03  -1.50295020E-01
   -1.81276270E-01  -1.43320000E-03  -6.30510000E-04  +2.09377000E-03  -1.74681000E-03
   -2.08003000E-03  +4.60872000E-03  -8.24700000E-05  +1.04559000E-03  -3.26010000E-04
   -5.19593000E-03  -2.51376000E-03  +1.44303000E-03  +8.91417000E-03  +1.66636620E-01
   +1.85211170E-01  -1.31936000E-03  +5.16160000E-03  -1.96120000E-04  -1.53763600E-02
   -6.47574000E-03  -1.64849300E-02  -2.18784460E-01  -2.80216400E-02  -1.37915190E-01
   +4.03580000E-04  +3.83926000E-03  +1.20021000E-03  +2.41011000E-03  +1.31735000E-03
   -8.12980000E-04  -1.09020000E-04  +3.00370000E-04  +8.47240000E-04  +4.25100000E-05
   -1.09498000E-03  +1.53171000E-03  +2.31038270E-01  +4.59661000E-03  +6.50710000E-04
   -2.76867000E-03  +1.47190300E-02  +6.50368000E-03  +1.29487400E-02  -2.81421100E-02
   -5.72503000E-02  -3.96713100E-02  -1.86299000E-02  +1.23558000E-03  -1.40449100E-02
   +1.76118000E-03  -1.27534000E-03  -5.36843000E-03  +5.56790000E-04  -1.37010000E-03
   +5.15000000E-06  -1.44997000E-03  -1.04730000E-03  +2.01126000E-03  +2.80860600E-02
   +5.28139300E-02  -4.85150000E-04  -2.47484000E-03  +4.21016000E-03  +2.93616000E-03
   +1.49690000E-04  +4.00201000E-03  -1.38038780E-01  -3.96326400E-02  -1.52376990E-01
   -1.94984900E-02  -4.11880000E-04  -7.88318000E-03  -3.83160000E-04  -5.67698000E-03
   +2.95190000E-04  +1.13775000E-03  -1.71600000E-04  -5.19180000E-04  +1.22372000E-03
   +2.22291000E-03  -1.39124000E-03  +1.51310440E-01  +4.45753300E-02  +1.55115060E-01
   -1.02381000E-03  +3.96929000E-03  +4.86584000E-03  -6.92140000E-04  +1.26189000E-03
   -3.80638000E-03  -8.00929000E-03  +1.44746200E-02  +2.48728000E-03  -2.22138740E-01
   +1.33435320E-01  +1.53428600E-02  -4.84401500E-02  +3.20659600E-02  -4.02307000E-03
   +3.56144000E-03  -5.33789000E-03  -5.69308000E-03  -2.70690000E-04  +3.29040000E-04
   +1.37770000E-04  +2.44150000E-03  -2.35666000E-03  +1.76882000E-03  +5.51349930E-01
   +2.96856000E-03  -2.78800000E-04  +1.94910000E-03  -4.44221000E-03  +3.15204000E-03
   -6.98192000E-03  +4.15831000E-02  -2.66728200E-02  -8.60373000E-03  +9.78289900E-02
   -1.65619830E-01  -5.24311100E-02  +4.98171000E-03  +8.35974000E-03  +3.96610000E-03
   -3.47320000E-04  -7.68850000E-04  -5.35989000E-03  +1.17135000E-03  -9.33850000E-04
   -1.71040000E-04  -1.82275000E-03  +2.28320000E-04  +2.86507000E-03  -7.59871800E-02
   +2.49917370E-01  +2.95735000E-03  +3.25989000E-03  +3.45610000E-03  -9.28204000E-03
   -3.55031000E-03  -9.35330000E-04  +2.74520600E-02  -2.50401200E-02  +3.49323000E-03
   -1.70098200E-02  -3.12400400E-02  -8.28351100E-02  -2.87367400E-02  +2.02490800E-02
   +8.51273000E-03  -1.12202000E-03  -8.31299000E-03  -3.44747000E-03  +9.37870000E-04
   -6.93920000E-04  -7.13800000E-05  +2.26430000E-03  +2.57530000E-03  -3.90650000E-04
   +2.43221020E-01  +1.57682200E-01  +3.16707410E-01  -2.44054000E-03  +4.54837000E-03
   -2.05669000E-03  -1.49790000E-03  +2.26650000E-04  -9.45100000E-05  -2.99393000E-03
   +8.19220000E-04  -4.29500000E-03  +5.95658000E-03  -1.90858100E-02  -1.68282600E-02
   -5.63451000E-02  +1.05204600E-02  -2.48416000E-03  +4.13849000E-03  +1.89589300E-02
   +1.79622700E-02  -4.96000000E-05  -1.67430000E-04  +2.46840000E-04  +5.50700000E-05
   -1.02235000E-03  -8.60870000E-04  +1.11119000E-03  -7.85870000E-04  +1.92900000E-03
   +5.15939400E-02  +4.69793000E-03  +2.50642000E-03  -2.03833000E-03  -1.03970000E-04
   -7.70000000E-06  +8.09780000E-04  +4.46370000E-04  +2.76759000E-03  -2.13951000E-03
   +3.13910000E-03  -4.49920000E-04  -3.18889000E-03  +9.37926000E-03  -2.09279210E-01
   -1.52002560E-01  -1.75968000E-03  -9.17280000E-03  -1.20341800E-02  -1.96520000E-04
   -3.22740000E-04  +2.44740000E-04  -8.37000000E-06  -7.76200000E-05  +1.66900000E-05
   -1.07403000E-03  -6.47200000E-04  +1.81256000E-03  -1.31675900E-02  +2.16645870E-01
   -1.68958000E-03  -2.40248000E-03  +4.69836000E-03  -3.34460000E-04  +1.00607000E-03
   -2.41670000E-04  -4.66274000E-03  -1.89142000E-03  +8.96970000E-04  +3.20212000E-03
   -1.64306300E-02  -7.90755000E-03  -3.38500000E-03  -1.51223520E-01  -1.75574560E-01
   -9.04260000E-04  +4.42710000E-04  +2.75429000E-03  +2.25170000E-04  +2.65800000E-04
   -3.45440000E-04  +8.75300000E-05  -5.92820000E-04  -5.93440000E-04  +1.76245000E-03
   +1.93091000E-03  -5.31720000E-04  +3.84639000E-03  +1.66395170E-01  +1.78682230E-01
   +3.92593000E-03  +4.83330000E-04  +4.65460000E-04  +2.13886000E-03  +1.52087000E-03
   -8.73260000E-04  -1.17240000E-04  +3.09680000E-04  +8.99680000E-04  -4.74250000E-04
   +4.99341000E-03  -6.06830000E-04  -1.52500200E-02  -5.56273000E-03  -1.66721000E-02
   -2.24662200E-01  -3.25056300E-02  -1.36099350E-01  +1.62980000E-04  +1.41190000E-04
   +1.10270000E-04  -1.60190000E-04  -1.88290000E-04  +1.26820000E-04  -1.19647000E-03
   -2.40810000E-04  -8.99160000E-04  +6.20100000E-05  -1.18723000E-03  +1.66507000E-03
   +2.37137140E-01  -1.92418100E-02  +1.53595000E-03  -1.35794900E-02  +2.06267000E-03
   -1.23651000E-03  -5.60459000E-03  +3.42290000E-04  -1.00804000E-03  +2.79620000E-04
   +4.82554000E-03  +1.11511000E-03  -3.78086000E-03  +1.60929700E-02  +7.03779000E-03
   +1.17602700E-02  -3.30585100E-02  -6.14404800E-02  -3.82757900E-02  -1.03061000E-03
   -9.21800000E-05  -7.50060000E-04  -2.26840000E-04  -2.11840000E-04  +3.11310000E-04
   +7.19440000E-04  +2.92600000E-04  +7.06170000E-04  -1.64569000E-03  -1.28898000E-03
   +2.20154000E-03  +3.13512400E-02  +5.74461000E-02  -1.71647500E-02  -2.38523000E-03
   -7.93036000E-03  -8.02550000E-04  -6.00077000E-03  +4.34470000E-04  +1.05607000E-03
   +1.54180000E-04  -3.89200000E-04  -8.21700000E-04  -3.57975000E-03  +4.84912000E-03
   +2.51871000E-03  -8.94280000E-04  +5.08332000E-03  -1.35631490E-01  -3.75076500E-02
   -1.52274290E-01  -9.20050000E-04  -5.60700000E-05  -5.54100000E-04  +1.18530000E-04
   +3.31610000E-04  -3.37970000E-04  -1.41860000E-04  +1.60520000E-04  +6.25600000E-05
   +1.38620000E-03  +2.48235000E-03  -1.79504000E-03  +1.49741160E-01  +4.49290300E-02
   +1.54011600E-01  -1.40619750E-01  +4.28306900E-02  -5.72611000E-03  -1.94057900E-02
   +1.45880700E-02  -9.00900000E-04  +1.86480000E-04  +2.45800000E-04  -3.94678000E-03
   -2.52821000E-03  -1.28230000E-04  -1.05417000E-03  +3.91084000E-03  -9.89320000E-04
   -1.65068000E-03  -1.45562000E-03  +7.89188000E-03  +5.78461000E-03  +4.33830000E-04
   -6.55700000E-04  +2.13805000E-03  -2.06330000E-04  +5.48160000E-04  +6.60900000E-05
   +1.70704000E-03  -1.17231000E-03  +3.01050000E-04  +5.35910000E-04  -2.30350000E-04
   -3.29420000E-04  -7.97610000E-04  -1.39734000E-03  -1.66380000E-04  +4.73682360E-01
   +4.58035500E-02  -1.11037980E-01  -9.24923000E-03  +4.44340000E-04  +6.55456000E-03
   +3.62505000E-03  -7.43030000E-04  +2.98342000E-03  -4.09565000E-03  +2.58780000E-04
   -9.67860000E-04  -3.39870000E-04  -5.35360000E-04  +2.75460000E-04  -4.47526000E-03
   +2.11607700E-02  -1.59916200E-02  -1.91744000E-03  -1.43450000E-03  -2.19537000E-03
   +7.28530000E-04  -6.00740000E-04  +5.55070000E-04  -1.94570000E-04  -8.04570000E-04
   +3.22490000E-04  +4.34770000E-04  +7.18740000E-04  -1.45760000E-04  -1.18770000E-04
   -2.34460000E-04  -6.98200000E-04  +1.80891000E-03  -1.56637000E-03  +4.82214800E-01
   -2.70733000E-03  -1.11661300E-02  -8.07339700E-02  -1.22211100E-02  +1.15028500E-02
   +4.54480000E-03  -4.19000000E-03  -2.88398000E-03  +1.59685000E-03  -2.86770000E-04
   -1.00833000E-03  -1.56506000E-03  -1.65365000E-03  -5.58378000E-03  -8.56940000E-04
   +1.90392800E-02  -1.13077600E-02  +3.15429000E-03  +1.29065000E-03  +1.32008000E-03
   -2.02835000E-03  -8.64380000E-04  +3.27140000E-04  +2.97390000E-04  -5.98060000E-04
   +1.09337000E-03  -2.92800000E-05  +8.13100000E-04  -7.28830000E-04  +1.40300000E-04
   +8.94140000E-04  +1.17703000E-03  -1.40277000E-03  +1.28324000E-03  -7.27990000E-04
   +4.83359180E-01  -3.67795500E-02  -9.68255000E-03  -6.42640000E-04  -7.86770000E-04
   +7.62250000E-04  +2.37775000E-03  -2.79330000E-04  +1.03911000E-03  -7.54250000E-04
   -2.49190000E-04  -3.24140000E-04  -5.61250000E-04  +4.01270000E-04  -7.20670000E-04
   -5.19220000E-04  -7.90420000E-04  -6.43310000E-04  +6.31870000E-04  -1.74980000E-04
   -2.81850000E-04  +2.72480000E-04  -6.64000000E-06  +2.12130000E-04  -1.30930000E-04
   -4.40500000E-05  +1.67300000E-05  +9.83800000E-05  +1.22880000E-04  -1.67210000E-04
   +7.86400000E-05  -5.54670000E-04  +4.58810000E-04  +2.57300000E-04  -1.39811650E-01
   -4.40013400E-02  +3.07530000E-03  +5.91646210E-01  +1.04748600E-02  +1.36800700E-02
   +3.10380000E-04  +1.31812000E-03  -2.40003000E-03  -1.10911000E-03  +7.55090000E-04
   -1.17912000E-03  +5.17370000E-04  -3.45590000E-04  +1.20500000E-03  +6.34160000E-04
   -2.47140000E-04  +4.27700000E-05  -3.51900000E-05  +2.85661000E-03  -6.30140000E-04
   -5.15640000E-04  +7.29800000E-05  +3.78260000E-04  -1.61610000E-04  +2.82590000E-04
   -2.67000000E-04  +9.34500000E-05  +1.09773000E-03  -8.94870000E-04  -1.62920000E-04
   +5.32000000E-05  -1.19980000E-04  -9.35000000E-06  +6.02010000E-04  -8.56300000E-05
   -3.20750000E-04  -4.20487000E-02  -1.07088450E-01  +1.39732600E-02  +9.84020900E-02
   +4.07981500E-01  -1.82249000E-03  -1.72179000E-03  -4.80500000E-05  -1.25440000E-04
   +6.52760000E-04  +1.22280000E-04  -1.96720000E-04  +3.38750000E-04  -2.86300000E-05
   +9.43000000E-06  -2.90110000E-04  -3.31470000E-04  +3.82480000E-04  +2.13400000E-04
   +1.41250000E-04  +1.10818000E-03  -7.57930000E-04  +3.17100000E-05  +2.10530000E-04
   -2.22320000E-04  +1.54410000E-04  -6.78500000E-05  +4.89500000E-05  -1.66000000E-05
   -1.06790000E-04  +7.48800000E-05  +1.37410000E-04  -1.40900000E-05  +4.07200000E-05
   -1.22200000E-05  +5.81900000E-04  -7.94100000E-05  -3.00000000E-08  +6.46160000E-04
   +1.16845900E-02  -8.26347400E-02  +1.49971640E-01  -1.79186650E-01  +4.72303510E-01
   +1.60250000E-04  +1.88727900E-02  +2.27691400E-02  -1.83396000E-03  +1.16554000E-03
   +7.27570000E-04  +2.11450000E-04  +5.12860000E-04  +7.21600000E-04  +3.93030000E-04
   -2.72230000E-04  -8.76300000E-05  +3.65330000E-04  +1.18160000E-03  +8.62920000E-04
   -5.04007000E-03  +2.43692000E-03  -1.13040000E-03  -8.54290000E-04  +1.84923000E-03
   +7.76750000E-04  -3.86600000E-05  -5.82800000E-05  -1.47000000E-05  -5.84390000E-04
   +4.34950000E-04  +1.67400000E-05  -3.53590000E-04  +2.58050000E-04  +4.34100000E-05
   +2.15300000E-05  -9.04800000E-05  +2.26990000E-04  -7.59795000E-02  -2.43076000E-03
   -3.34685000E-03  -5.31073000E-03  -1.98858000E-02  -2.26467700E-02  +5.86502590E-01
   +4.62552000E-03  -1.62019500E-02  -1.69643700E-02  +4.12430000E-04  -6.88070000E-04
   +5.81020000E-04  -6.38400000E-04  -4.55880000E-04  -5.55620000E-04  +1.56420000E-04
   +3.40600000E-05  -1.14800000E-04  -3.38880000E-04  -5.67760000E-04  -5.96600000E-04
   +3.07321000E-03  -4.07980000E-04  +3.16130000E-04  +2.65090000E-04  -1.51200000E-04
   -9.03500000E-04  -9.05300000E-05  +4.42200000E-05  +5.08800000E-05  -3.25200000E-05
   -1.67700000E-05  -1.38700000E-05  +1.22780000E-04  -1.60340000E-04  +5.47500000E-05
   -1.34420000E-04  +2.08900000E-05  +4.11300000E-05  +1.81388000E-03  -1.14549820E-01
   -4.97559200E-02  -9.55193000E-03  -1.97141100E-02  -1.71515700E-02  +1.10336000E-03
   +5.32791070E-01  +4.42655000E-03  -2.43982000E-03  -5.73040000E-04  -1.01110000E-03
   +8.49580000E-04  +9.18000000E-06  -2.12650000E-04  +2.52900000E-05  -1.60680000E-04
   +2.39230000E-04  -9.41300000E-05  +2.21460000E-04  -4.14300000E-04  +2.06690000E-04
   +1.26930000E-04  -1.02843000E-03  +6.35380000E-04  +8.95800000E-05  -5.88980000E-04
   +1.15710000E-04  +4.89660000E-04  -4.92200000E-05  +6.72700000E-05  -5.00700000E-05
   -3.07470000E-04  +2.07070000E-04  -2.43000000E-05  -8.54500000E-05  +9.89000000E-05
   +9.89000000E-06  +7.98500000E-05  +1.11250000E-04  -4.61200000E-05  +9.78200000E-04
   -4.60778800E-02  -1.34382800E-01  -6.96309000E-03  -5.51573000E-03  +1.06091000E-03
   +3.30745000E-03  -6.35377200E-02  +5.18170910E-01  -5.00340000E-03  +1.73211200E-02
   -2.36929600E-02  -4.39470000E-04  +1.88298000E-03  +7.19750000E-04  -1.38068000E-03
   -1.59100000E-05  +1.37638000E-03  +4.23920000E-04  -9.34920000E-04  -6.57810000E-04
   -1.31550000E-04  -6.74140000E-04  -9.58200000E-05  -4.08050000E-04  +7.49810000E-04
   -8.40450000E-04  +3.07290000E-04  +4.09250000E-04  -6.75480000E-04  -2.38420000E-04
   +5.72400000E-05  +2.30300000E-05  -1.18307000E-03  +9.75170000E-04  +7.72300000E-05
   +2.76400000E-05  +5.44200000E-05  +1.66600000E-05  -5.31100000E-05  +1.07140000E-04
   -1.13800000E-05  -7.58015600E-02  +1.97350000E-03  -3.40667000E-03  -4.04170000E-04
   -1.63891100E-02  +2.46476700E-02  +5.00250000E-04  +5.66790000E-04  -1.09219000E-03
   +5.87608620E-01  +8.64796000E-03  -1.72411400E-02  +1.85761900E-02  -1.53689000E-03
   -1.11146000E-03  -5.64380000E-04  +8.01790000E-04  -3.14000000E-04  -1.05471000E-03
   -1.23600000E-05  +7.10100000E-04  +6.81130000E-04  -1.55280000E-04  +7.64910000E-04
   -4.22400000E-05  +6.26430000E-04  -5.01990000E-04  +1.04773000E-03  +3.55800000E-05
   -2.30170000E-04  +2.17650000E-04  +9.78900000E-05  +3.50200000E-05  -7.79700000E-05
   +5.41580000E-04  -5.05540000E-04  -6.60800000E-05  -7.02800000E-05  -1.77700000E-05
   +1.02700000E-05  +1.66740000E-04  -6.07280000E-04  +4.33700000E-05  -1.97301000E-03
   -1.04241810E-01  +4.65721200E-02  -4.52010000E-03  -1.37696400E-02  +1.83594000E-02
   -4.74160000E-04  +1.06262000E-02  -1.70327000E-02  +2.98760000E-04  +5.47573270E-01
   -7.83998000E-03  +7.43416000E-03  -1.41240000E-03  +9.20900000E-04  -2.69210000E-04
   -1.20550000E-04  +1.83210000E-04  -3.50250000E-04  -2.35630000E-04  -1.01900000E-04
   +3.87450000E-04  +5.21040000E-04  -3.63340000E-04  -5.27000000E-05  -2.10220000E-04
   +1.66796000E-03  -1.21165000E-03  -1.94270000E-04  +8.47500000E-05  +4.12600000E-05
   +3.35700000E-05  +1.14020000E-04  -6.27900000E-05  -5.25000000E-06  +5.73970000E-04
   -4.47600000E-04  -1.09850000E-04  +1.07550000E-04  -2.26400000E-05  -6.68100000E-05
   -1.32590000E-04  -4.10180000E-04  -4.58400000E-05  +1.63698000E-03  +4.31658100E-02
   -1.45320640E-01  +4.95836000E-03  +3.99703000E-03  -3.09465000E-03  -9.18690000E-04
   +1.17166800E-02  -3.72304900E-02  +3.21394000E-03  +6.06973600E-02  +5.05809260E-01
   -8.16680000E-04  -2.59519000E-03  +1.91435000E-03  +5.63490000E-04  -3.20370000E-04
   +4.90720000E-04  -1.96790000E-04  +4.73130000E-04  -4.98200000E-05  -7.46300000E-05
   -1.43320000E-04  -2.77770000E-04  +2.81320000E-04  -1.51150000E-04  +1.43850000E-04
   -1.00773000E-03  -3.46600000E-05  +6.93240000E-04  -5.52200000E-05  -1.35170000E-04
   +4.15500000E-05  -3.22600000E-05  +3.63000000E-06  +3.59000000E-06  -1.08310000E-04
   +9.88000000E-05  +8.74000000E-06  -6.31000000E-06  -1.74200000E-05  +1.84500000E-05
   -2.31510000E-04  +1.73390000E-04  -1.14280000E-04  -6.74230000E-04  -1.88248700E-02
   +2.12925000E-02  -1.18348470E-01  +3.53251000E-03  -3.65347900E-02  -5.22080000E-04
   -4.81420000E-04  +1.75124000E-03  -5.18836000E-03  -3.12190000E-03  -8.05860000E-04
   +6.61160770E-01  +4.06940000E-04  -4.41020000E-04  +7.03710000E-04  +1.05030000E-04
   -4.09300000E-05  +2.01280000E-04  +1.14820000E-04  -3.47400000E-05  +1.29140000E-04
   +8.29200000E-05  -1.37020000E-04  +1.46400000E-05  +8.98500000E-05  +1.49650000E-04
   +2.24730000E-04  -1.19660000E-04  -4.90840000E-04  -7.13030000E-04  +1.05180000E-04
   +7.56900000E-05  -2.33200000E-05  +8.97000000E-06  +8.46000000E-06  -8.66000000E-06
   -7.71000000E-05  +8.42500000E-05  +5.32600000E-05  +1.24000000E-06  +3.97200000E-05
   -4.12300000E-05  +1.19250000E-04  +3.60890000E-04  +2.50120000E-04  -6.83499000E-03
   -1.44304000E-02  +1.32926100E-02  -4.14525400E-02  -1.70996710E-01  +8.19483500E-02
   -9.54920000E-04  -5.78200000E-04  +1.27192000E-03  -2.64123000E-03  -4.16880000E-04
   -6.94510000E-04  +1.53187670E-01  +4.27942060E-01  +8.37450000E-04  +8.35600000E-04
   -3.53960000E-04  -6.01050000E-04  +1.68480000E-04  -7.15020000E-04  -5.52900000E-05
   +3.61800000E-05  -2.62160000E-04  -1.29410000E-04  +1.47310000E-04  +2.12100000E-04
   -2.39190000E-04  +5.92700000E-05  -1.55930000E-04  +8.09230000E-04  +9.15180000E-04
   -7.92200000E-05  -8.66800000E-05  -1.35070000E-04  +8.18500000E-05  -2.80700000E-05
   -2.72600000E-05  +2.07600000E-05  +9.24000000E-05  -7.56600000E-05  -6.79900000E-05
   -1.05700000E-05  -3.02000000E-06  +1.61100000E-05  +2.73100000E-04  -3.64330000E-04
   -2.20220000E-04  +6.78528000E-03  +4.42870000E-03  +1.01706000E-03  +1.44326900E-02
   +1.13100120E-01  -1.86362330E-01  -5.01350000E-04  -8.22710000E-04  -1.48050000E-04
   -7.03360000E-04  -1.57730000E-04  +3.09650000E-04  +1.51284550E-01  -2.05234880E-01
   +4.65841130E-01  +3.05600000E-04  +2.05340000E-04  +3.16420000E-04  -3.33940000E-04
   +2.54650000E-04  -9.77700000E-05  +1.80000000E-04  -2.37130000E-04  -3.86100000E-05
   +4.04840000E-04  +5.29000000E-06  +2.83470000E-04  -4.36350000E-04  +1.25820000E-04
   -3.04070000E-04  +4.73250000E-04  -4.53900000E-05  -2.38250000E-04  +2.75900000E-05
   +2.90900000E-05  -4.46000000E-06  -4.97400000E-05  -9.03000000E-06  +1.26000000E-06
   -3.23180000E-04  +2.04350000E-04  -2.19700000E-05  -1.33400000E-05  +2.28700000E-05
   +5.57000000E-06  +2.59230000E-04  -3.11530000E-04  +8.03000000E-06  +3.54331000E-03
   +5.67900000E-04  -1.62570000E-03  +3.11717900E-02  -4.17517200E-02  +6.32963800E-02
   +1.25740000E-04  +2.96600000E-04  -5.27790000E-04  +4.23410000E-04  +2.63900000E-04
   -3.30040000E-04  -2.64393120E-01  -1.05419490E-01  -1.53880600E-02  +5.97439190E-01
   +6.37000000E-04  -7.65200000E-05  -2.66790000E-04  -2.65450000E-04  +2.69670000E-04
   -2.40520000E-04  +1.87800000E-05  -9.83300000E-05  -4.81700000E-05  -4.05900000E-05
   +6.38900000E-05  +1.10420000E-04  -1.44910000E-04  +1.52590000E-04  -1.13930000E-04
   +1.68390000E-04  +1.88580000E-04  -1.11350000E-04  +4.27000000E-06  -1.76400000E-05
   +2.08400000E-05  -1.44600000E-05  +2.64000000E-06  +9.88000000E-06  +3.39600000E-05
   -1.78500000E-05  -1.20800000E-05  -3.30500000E-05  +2.62000000E-06  +2.48000000E-05
   +8.76600000E-05  -2.25740000E-04  +1.03950000E-04  +1.10722000E-03  +1.03903000E-03
   +5.17815000E-03  -1.17069500E-02  -2.44255200E-02  +2.72004700E-02  +6.33690000E-04
   +7.15930000E-04  -7.59500000E-05  -1.15605000E-03  -5.46610000E-04  -1.50290000E-04
   -1.54838670E-01  -1.88876460E-01  +4.05892000E-02  +1.58175050E-01  +4.89327560E-01
   -5.24090000E-04  +1.81660000E-04  +1.23730000E-04  -8.59500000E-05  +2.63100000E-05
   +1.02830000E-04  +1.25580000E-04  -1.34440000E-04  +1.39500000E-05  +2.67430000E-04
   -2.32500000E-05  +1.15710000E-04  -2.37380000E-04  +9.24500000E-05  -1.76990000E-04
   +1.76570000E-04  -2.31620000E-04  -7.11100000E-05  +5.65800000E-05  +6.16200000E-05
   -9.60000000E-06  -1.33400000E-05  +1.80000000E-06  -9.24000000E-06  -1.99690000E-04
   +1.43050000E-04  -4.64000000E-06  -1.55300000E-05  -1.59000000E-06  +2.52600000E-05
   +2.26600000E-05  -8.19200000E-05  -1.49400000E-05  -1.70536000E-03  +3.42835000E-03
   -2.22433000E-03  +2.75492300E-02  +9.92156000E-03  +1.64712500E-02  -9.78600000E-05
   -1.86600000E-05  -3.13960000E-04  +1.00435000E-03  +5.92500000E-04  +1.70850000E-04
   +3.58023700E-02  +6.99850700E-02  -1.11016680E-01  +1.29905490E-01  -2.75922930E-01
   +4.90799620E-01  -2.60390000E-04  +3.63800000E-05  -1.51140000E-04  +1.17550000E-04
   -1.92120000E-04  +1.08700000E-05  +7.08800000E-05  -5.98000000E-05  -6.62400000E-05
   -6.51860000E-04  +3.45320000E-04  -5.02000000E-05  +3.10120000E-04  +1.05800000E-04
   +2.60360000E-04  -1.88480000E-04  -7.31100000E-05  -9.79500000E-05  -5.48500000E-05
   +2.37000000E-06  +4.47000000E-06  +7.99400000E-05  -1.16400000E-05  +2.46200000E-05
   +6.91060000E-04  -4.75590000E-04  -1.24300000E-05  +1.46800000E-05  -3.20100000E-05
   -1.28900000E-05  -1.93220000E-04  +2.44860000E-04  +2.26080000E-04  -2.57450000E-03
   -2.85700000E-05  -4.48950000E-04  -1.60752400E-02  +2.17715800E-02  -3.41926300E-02
   +7.01800000E-05  -2.06360000E-04  +1.41460000E-04  +3.01830000E-04  -6.98100000E-05
   +1.92770000E-04  -5.83957300E-02  -4.31178100E-02  +8.34739000E-03  -2.18055420E-01
   +3.56962400E-02  -1.30845580E-01  +6.95034030E-01  -1.39100000E-04  +8.72210000E-04
   +2.86200000E-05  -3.54000000E-05  -6.23500000E-05  -1.62860000E-04  +1.91780000E-04
   -3.87310000E-04  -9.84900000E-05  -3.54140000E-04  +4.79770000E-04  +2.16880000E-04
   +1.05700000E-05  +7.65900000E-05  +2.58500000E-05  +2.63910000E-04  -1.93540000E-04
   -9.23600000E-05  -6.88200000E-05  +6.28700000E-05  -5.31500000E-05  +6.67300000E-05
   -3.70200000E-05  +2.92900000E-05  +5.78100000E-04  -4.59900000E-04  -4.46900000E-05
   +5.09000000E-05  -2.41700000E-05  -4.55400000E-05  -2.55200000E-05  +7.64300000E-05
   +1.72150000E-04  -3.96070000E-04  +1.10200000E-04  +1.71831000E-03  +1.36401400E-02
   -1.08599800E-02  +1.76803400E-02  +1.20986000E-03  +7.64060000E-04  -6.59940000E-04
   +2.81080000E-04  -6.03300000E-05  +1.99500000E-04  -7.78067000E-03  +2.56175200E-02
   -3.24574700E-02  -1.20764500E-02  -1.09525840E-01  +4.23841300E-02  +1.60944010E-01
   +4.54773740E-01  -3.12940000E-04  -2.68090000E-04  -1.03640000E-04  +3.23830000E-04
   -1.69840000E-04  +1.64580000E-04  -1.62910000E-04  +2.49520000E-04  +7.60500000E-05
   -1.53500000E-04  -1.20510000E-04  -2.54480000E-04  +2.52950000E-04  -9.99200000E-05
   +1.38090000E-04  -2.96340000E-04  -2.75200000E-05  +1.69790000E-04  -9.50000000E-06
   -2.76800000E-05  +3.04000000E-06  +1.01800000E-05  +1.23700000E-05  -7.69000000E-06
   +2.92500000E-05  +4.13000000E-06  +1.97200000E-05  -5.30000000E-07  -1.20900000E-05
   +1.71900000E-05  -1.55180000E-04  +1.43440000E-04  -2.92700000E-05  -7.48380000E-04
   -4.17750000E-04  -1.66792000E-03  -1.94465700E-02  +2.10843400E-02  -4.09512000E-02
   -5.67800000E-04  -5.66340000E-04  +5.85800000E-04  +2.30700000E-05  +9.90700000E-05
   +1.54360000E-04  -2.61108800E-02  -4.58478300E-02  +3.45371600E-02  -9.73387300E-02
   +6.17762900E-02  -1.94714840E-01  +1.89370690E-01  -1.82489210E-01  +4.79798640E-01
   -8.79640000E-04  -5.90130000E-04  +1.20730000E-04  +4.50840000E-04  -2.68090000E-04
   +4.63270000E-04  -1.72780000E-04  +3.87720000E-04  +1.83420000E-04  +1.10820000E-04
   -3.61270000E-04  -3.80100000E-04  +3.19920000E-04  -1.37880000E-04  +1.38370000E-04
   -4.64610000E-04  -3.41510000E-04  +3.27400000E-05  +3.53800000E-05  +1.22800000E-05
   -2.55800000E-05  -1.83000000E-06  +3.90400000E-05  -3.64000000E-05  -2.83630000E-04
   +2.15640000E-04  +7.93000000E-05  -5.65000000E-06  +1.94700000E-05  -7.60000000E-07
   -1.40630000E-04  +1.70350000E-04  -2.25100000E-05  +1.32478000E-03  +7.88030000E-04
   -2.80885000E-03  -4.87803600E-02  +1.23511000E-02  -3.55946600E-02  -1.14350000E-03
   -5.42100000E-04  +7.80200000E-05  +9.72100000E-05  +6.42080000E-04  -2.75620000E-04
   -1.52053700E-02  -2.47398600E-02  +1.70554600E-02  +1.96509500E-02  +2.00198200E-02
   -6.38567000E-03  -1.09876790E-01  -1.75964500E-02  -8.02937000E-03  +4.98610690E-01
   -5.78170000E-04  -4.31340000E-04  -2.35720000E-04  -1.22230000E-04  +1.04040000E-04
   +2.30500000E-05  -3.09800000E-05  +4.63000000E-05  -1.18030000E-04  -3.04990000E-04
   +9.87300000E-05  -8.05000000E-06  +7.56400000E-05  +7.62200000E-05  +7.07800000E-05
   -1.13490000E-04  +1.42840000E-04  -7.13800000E-05  -5.18900000E-05  -5.12900000E-05
   +4.00400000E-05  +9.57000000E-06  +7.52000000E-06  +1.17600000E-05  +2.58360000E-04
   -1.43540000E-04  -2.73800000E-05  -1.35600000E-05  -2.48300000E-05  +2.39600000E-05
   -9.88400000E-05  +3.14600000E-05  +5.12800000E-05  -9.52420000E-04  +2.63437000E-03
   +2.44132000E-03  -1.09211400E-02  +8.69847000E-03  -7.74916000E-03  +6.21820000E-04
   +1.69830000E-04  +3.92390000E-04  +8.02400000E-05  -1.13520000E-04  -7.17100000E-05
   -2.25290000E-03  -1.82988000E-02  +1.18066800E-02  +3.11651800E-02  +1.71867200E-02
   +3.17336000E-03  -4.80560000E-03  -1.42719610E-01  +7.07328700E-02  +1.20168740E-01
   +4.50119990E-01  -1.02368000E-03  -6.98390000E-04  -2.30660000E-04  -5.60770000E-04
   +3.96380000E-04  -1.78380000E-04  +1.60210000E-04  -3.01940000E-04  -3.16940000E-04
   -3.84730000E-04  +4.39150000E-04  +3.04170000E-04  -1.22100000E-04  +2.36020000E-04
   -3.65100000E-05  +3.09990000E-04  +9.71700000E-05  -2.53470000E-04  -1.05750000E-04
   -4.59400000E-05  +2.47000000E-05  +2.00500000E-05  -7.89000000E-06  +3.11000000E-05
   +5.46900000E-04  -3.96320000E-04  -6.10900000E-05  +1.92900000E-05  -2.68300000E-05
   -1.21500000E-05  +3.80400000E-05  +2.95400000E-05  +2.81510000E-04  -5.13801000E-03
   +5.52807000E-03  +1.56120000E-03  -1.96816000E-03  -3.16747300E-02  +4.10464700E-02
   +1.73329000E-03  +1.17384000E-03  -1.47830000E-04  +1.06362000E-03  +6.72980000E-04
   -1.95210000E-04  +1.82910700E-02  +2.32706700E-02  -2.03572900E-02  -3.66899500E-02
   +1.17797200E-02  -2.01286400E-02  +1.51018700E-02  +9.88505100E-02  -1.55366540E-01
   +3.21328900E-02  -1.34802650E-01  +4.10577260E-01  -3.69180000E-04  -1.53750000E-03
   -2.47400000E-04  -1.06816000E-03  +9.22170000E-04  -2.99610000E-04  +2.58770000E-04
   -4.26950000E-04  -3.64920000E-04  +1.09780000E-04  +2.95040000E-04  +5.31540000E-04
   -4.61800000E-04  +4.32820000E-04  -1.72060000E-04  +8.19010000E-04  +4.12000000E-05
   -6.60910000E-04  -1.35200000E-05  -8.98000000E-05  +7.18400000E-05  -5.64700000E-05
   +5.25000000E-06  +2.40200000E-05  +1.17810000E-04  -1.02440000E-04  -3.87700000E-05
   -1.42300000E-05  +1.40000000E-05  -1.91800000E-05  -7.55500000E-05  -1.05700000E-05
   +4.83990000E-04  -2.12871000E-02  -1.45115000E-03  -1.29884600E-02  -2.69451970E-01
   -2.57325500E-02  -1.04829600E-01  -4.14250000E-04  +1.61394000E-03  +9.19790000E-04
   -1.26893000E-03  -4.59190000E-04  -9.92890000E-04  +3.00532700E-02  +5.89157000E-02
   -4.78588700E-02  -5.64361000E-02  -1.55076000E-02  -1.69934800E-02  +3.76504200E-02
   -2.30583400E-02  +4.82712200E-02  -1.68838450E-01  -1.02556430E-01  -6.42102000E-03
   +5.81257550E-01  -7.90770000E-04  -2.63678000E-03  -4.58450000E-04  -6.99760000E-04
   +7.07010000E-04  +8.58500000E-05  +4.36800000E-05  +1.33100000E-05  -2.00200000E-04
   +2.95830000E-04  -5.91400000E-05  +1.34410000E-04  -2.38260000E-04  +2.95470000E-04
   -5.97200000E-05  +3.17660000E-04  -6.18000000E-06  -2.76330000E-04  +5.16300000E-05
   -1.01120000E-04  +8.70100000E-05  -8.93500000E-05  +3.09900000E-05  +2.81000000E-06
   -2.60000000E-04  +1.78960000E-04  +4.24500000E-05  -3.06000000E-05  +4.27100000E-05
   -5.90000000E-06  +2.02600000E-05  -5.61700000E-05  +2.75350000E-04  -1.42169400E-02
   +6.08661000E-03  -1.10916600E-02  +1.33945400E-02  -9.64227600E-02  +4.36304800E-02
   -1.97822000E-03  -1.16135000E-03  +4.53030000E-04  -1.00543000E-03  -9.30030000E-04
   -7.18450000E-04  +2.06904300E-02  +6.04984000E-03  +1.60636800E-02  -6.72793000E-03
   -4.72083000E-03  -6.85880000E-04  -1.83390900E-02  -2.30284700E-02  +1.81513700E-02
   -9.15462600E-02  -1.38892130E-01  +4.28551900E-02  +1.06126750E-01  +4.18664310E-01
   +2.22855000E-03  +9.74150000E-04  -4.24900000E-05  -1.06610000E-04  -1.09890000E-04
   -8.17300000E-05  +2.51380000E-04  -3.83490000E-04  +3.96000000E-05  -7.26700000E-05
   +2.62440000E-04  +2.59810000E-04  -8.92800000E-05  +2.98520000E-04  +6.57400000E-05
   +5.10840000E-04  -2.01100000E-04  -6.33170000E-04  +3.19800000E-05  +8.89600000E-05
   -3.27900000E-05  +5.11700000E-05  -3.22600000E-05  +2.74400000E-05  +3.04140000E-04
   -2.27050000E-04  -1.06900000E-05  +5.63000000E-06  +1.52000000E-06  -3.75700000E-05
   +3.20300000E-05  -2.27900000E-05  +3.20450000E-04  -6.70400000E-04  -3.50381000E-03
   +6.46924000E-03  -1.54016350E-01  +3.22739800E-02  -1.96156190E-01  +9.67220000E-04
   +7.92150000E-04  -3.41000000E-05  +1.02219000E-03  -3.31230000E-04  +1.50680000E-04
   -1.65947700E-02  +2.54257700E-02  -3.04086100E-02  -1.30501800E-02  -4.07838000E-03
   -4.45389000E-03  +2.79441900E-02  +5.19971000E-03  +7.35776000E-03  +2.82805000E-02
   +4.60419700E-02  -1.11462190E-01  +1.56548680E-01  -2.57867910E-01  +5.35245960E-01
   -6.27430000E-04  -7.25980000E-04  +8.32020000E-04  -6.17500000E-05  -1.38390000E-04
   +1.13730000E-04  -1.57310000E-04  +1.82440000E-04  -1.20100000E-05  -2.90910000E-04
   +4.48300000E-05  -1.65490000E-04  +3.19300000E-04  -9.23100000E-05  +3.92400000E-05
   -3.18280000E-04  -1.11180000E-04  +3.46640000E-04  +4.91800000E-05  -2.78300000E-05
   -8.16000000E-06  +1.11000000E-05  -8.80000000E-07  +1.19500000E-05  +1.74000000E-04
   -1.16360000E-04  +7.02000000E-06  +2.57000000E-06  -3.60000000E-06  -7.10000000E-06
   +1.11800000E-05  +2.17900000E-05  -6.38400000E-05  -7.32750000E-04  +4.92000000E-05
   +8.10760000E-04  +3.65766000E-03  -2.17250000E-04  -3.86590000E-04  -8.84000000E-05
   -1.81580000E-04  -9.64000000E-05  -1.06300000E-05  +1.34910000E-04  +6.60400000E-05
   -2.34955200E-01  +1.84287900E-02  -1.37492050E-01  -1.51171500E-02  +3.08558000E-03
   -1.61332700E-02  -6.69490000E-04  -4.96042000E-03  -1.95960000E-04  -1.74000000E-06
   -5.09950000E-04  +5.68650000E-04  +2.08127000E-03  -1.40331000E-03  -3.06270000E-04
   +2.47651930E-01  -3.69020000E-04  -8.53000000E-06  +8.80400000E-05  -5.67000000E-05
   -2.23400000E-05  +2.15600000E-05  -1.12790000E-04  +6.20500000E-05  -1.09900000E-05
   -2.23980000E-04  -1.23400000E-05  -1.50810000E-04  +2.86630000E-04  -2.38820000E-04
   +1.10180000E-04  -1.82950000E-04  +3.41780000E-04  +2.77310000E-04  -8.53200000E-05
   -8.51600000E-05  -1.02100000E-05  +2.77900000E-05  +1.06800000E-05  -1.86000000E-06
   +1.99410000E-04  -1.62420000E-04  +4.07000000E-06  +2.48500000E-05  -7.58000000E-06
   -2.30400000E-05  -2.44400000E-05  +2.54900000E-05  -8.63500000E-05  +1.29060000E-03
   -8.07800000E-04  -1.03505000E-03  +1.74758600E-02  +2.96593000E-03  +1.32889300E-02
   -1.16930000E-04  -5.67930000E-04  +4.85180000E-04  +1.18670000E-04  -5.60000000E-06
   -1.27970000E-04  +1.91169000E-02  -5.56006900E-02  +2.60612700E-02  -1.59282800E-02
   +7.00299000E-03  -1.04786600E-02  -5.79900000E-03  +1.19000000E-03  +3.77127000E-03
   -3.00900000E-04  -2.87260000E-04  +9.46200000E-05  -2.31238000E-03  -6.87520000E-04
   +4.96571000E-03  -1.50450800E-02  +4.94727000E-02  +3.34440000E-04  +3.98090000E-04
   +1.90200000E-05  +4.27890000E-04  -1.79740000E-04  +2.67850000E-04  +3.11300000E-05
   +1.17190000E-04  +9.40500000E-05  +3.42540000E-04  -1.65820000E-04  -3.75100000E-05
   -8.39200000E-05  -9.39300000E-05  -4.39700000E-05  -2.32000000E-05  -3.80310000E-04
   -2.17290000E-04  -1.39100000E-05  -2.68700000E-05  -2.18000000E-05  -3.20100000E-05
   -2.44000000E-06  -1.02300000E-05  -3.59820000E-04  +2.42780000E-04  +1.64700000E-05
   -2.21000000E-06  +2.05800000E-05  -5.69000000E-06  -4.40800000E-05  +7.40100000E-05
   +9.06000000E-06  -4.53300000E-04  -1.59244000E-03  -1.04748000E-03  -1.91556600E-02
   +1.44635000E-03  -7.81013000E-03  +1.15600000E-05  +2.97200000E-05  -7.50700000E-05
   +2.22360000E-04  -4.39100000E-05  -3.40000000E-05  -1.36778700E-01  +2.49529500E-02
   -1.51778640E-01  +5.17353000E-03  +1.80651000E-03  +7.35693000E-03  -7.66990000E-04
   +4.11942000E-03  +3.64540000E-03  +1.34000000E-03  -1.47520000E-04  -5.65640000E-04
   -1.19585000E-03  +5.69899000E-03  -1.37073000E-03  +1.50411950E-01  -3.29002200E-02
   +1.53318510E-01  +9.65000000E-05  -4.57900000E-05  -1.31100000E-05  +1.26200000E-05
   +1.78400000E-05  +9.33000000E-06  -2.29400000E-05  +4.57700000E-05  -3.56000000E-06
   +9.89000000E-06  -3.31800000E-05  -1.34900000E-05  -6.08000000E-06  +3.09800000E-05
   -1.81800000E-05  -7.75000000E-06  +2.94000000E-06  -1.13900000E-05  +4.31000000E-06
   -1.00100000E-05  +7.01000000E-06  -1.36100000E-05  -2.30000000E-06  +4.07000000E-06
   -4.07300000E-05  +4.71200000E-05  -6.77000000E-06  -1.26600000E-05  -1.80000000E-07
   +1.54700000E-05  +3.18000000E-06  -2.33200000E-05  +1.57000000E-06  +5.14240000E-04
   -5.40560000E-04  +9.06080000E-04  -2.40953000E-03  -4.25912000E-03  -1.63234000E-03
   +4.53800000E-05  +9.30500000E-05  +9.10900000E-05  -3.54090000E-04  -1.25820000E-04
   -6.57600000E-05  +4.83895000E-03  -1.78885900E-02  +1.91738600E-02  -5.58475100E-02
   -1.17178000E-03  -1.10257800E-02  +4.85430000E-03  +2.05572300E-02  -2.00576800E-02
   -1.99655000E-03  -4.21008000E-03  -2.99507000E-03  -1.05113000E-03  +1.77860000E-04
   -5.12900000E-05  +1.17470000E-04  +1.66788000E-03  +1.20148000E-03  +5.13885800E-02
   +2.05060000E-04  -9.92000000E-05  -2.86500000E-05  -4.37200000E-05  +4.25200000E-05
   -2.97800000E-05  -4.44000000E-06  -6.04000000E-06  -2.22100000E-05  +2.33700000E-05
   +4.71000000E-06  +2.32500000E-05  -2.98400000E-05  +2.00000000E-08  +4.60000000E-07
   +3.61700000E-05  +5.71600000E-05  -8.63000000E-06  -1.95000000E-06  -1.57900000E-05
   +5.85000000E-06  -1.02400000E-05  +3.00000000E-07  +7.90000000E-07  -2.14200000E-05
   +1.01900000E-05  -5.32000000E-06  +1.11000000E-06  +2.12000000E-06  -3.08000000E-06
   -4.60000000E-07  -1.15500000E-05  -1.39100000E-05  +2.29740000E-04  -4.74000000E-05
   +7.99990000E-04  -4.46582000E-03  +2.15173000E-03  +2.64941000E-03  -4.46900000E-05
   -1.14600000E-05  +2.65900000E-05  -2.54130000E-04  -1.68490000E-04  -8.86800000E-05
   +2.96416000E-03  -7.76983000E-03  +1.27216600E-02  -2.15965000E-03  -1.90019090E-01
   +1.53321720E-01  -1.60275000E-03  +1.12651000E-03  +3.04686000E-03  -9.53960000E-04
   +4.19680000E-03  +9.02740000E-04  -9.04300000E-04  -3.27110000E-04  -9.32460000E-04
   +1.29108000E-03  -1.64326000E-03  -2.49920000E-03  +3.45763000E-03  +1.94221650E-01
   +1.22580000E-04  +1.95500000E-05  -1.71500000E-05  -5.01500000E-05  +1.50400000E-05
   -6.63800000E-05  +1.86600000E-05  -5.42200000E-05  -2.77300000E-05  -1.22500000E-05
   +5.51000000E-05  +4.62300000E-05  -1.26000000E-05  -2.23500000E-05  +2.10900000E-05
   +4.12700000E-05  +4.85500000E-05  +1.27000000E-05  -8.66000000E-06  -5.04000000E-06
   -1.93000000E-06  +3.84000000E-06  -3.80000000E-06  +9.40000000E-07  +5.21900000E-05
   -5.42900000E-05  -6.97000000E-06  +1.61000000E-05  +2.00000000E-08  -1.91400000E-05
   -6.65000000E-06  +1.81500000E-05  -9.94000000E-06  -3.20320000E-04  +1.18860000E-04
   +2.89200000E-05  -9.07740000E-04  +2.24111000E-03  +5.12388000E-03  +1.47000000E-06
   -3.34000000E-05  -6.72700000E-05  +7.64400000E-05  -4.05300000E-05  +1.78700000E-05
   -2.42480000E-04  +2.05833000E-03  +9.11630000E-04  -1.21839700E-02  +1.52166150E-01
   -1.96513490E-01  +2.35562000E-03  +1.50658300E-02  -8.08345000E-03  -3.05617000E-03
   +1.88606000E-03  +1.25959000E-03  -1.40522000E-03  -1.02586000E-03  -3.23530000E-04
   +1.54758000E-03  -2.39439000E-03  -1.63443000E-03  +1.23789500E-02  -1.67979640E-01
   +2.01088450E-01  +2.46760000E-04  -5.86720000E-04  +1.12390000E-04  -6.37700000E-05
   +1.84340000E-04  +1.43810000E-04  -1.41550000E-04  +2.50880000E-04  +9.81700000E-05
   +6.42460000E-04  -4.93020000E-04  -8.09200000E-05  -2.58660000E-04  -7.17800000E-05
   -1.93140000E-04  -2.60400000E-05  +1.23170000E-04  +6.67800000E-05  +8.12400000E-05
   -3.68600000E-05  +3.34700000E-05  -9.82100000E-05  +3.38700000E-05  -3.44900000E-05
   -8.07450000E-04  +5.90800000E-04  +3.00000000E-05  -4.25000000E-05  +3.51500000E-05
   +4.19700000E-05  +1.04130000E-04  -2.23750000E-04  -2.49500000E-04  +1.91625000E-03
   -8.82600000E-05  -1.12444000E-03  +3.37380000E-03  -7.84314000E-03  +1.38912500E-02
   -1.07855000E-03  -4.23390000E-04  +5.69150000E-04  -4.13560000E-04  +1.48200000E-05
   -2.76570000E-04  +1.01909100E-02  +1.29825800E-02  -1.05705500E-02  -5.26762200E-02
   -3.17354000E-02  -1.02705100E-02  -2.59151140E-01  -1.53253640E-01  +1.88197100E-02
   +7.95870000E-03  -5.05601400E-02  -1.07805500E-02  -1.16818500E-02  +1.45297000E-03
   -2.54968000E-03  -1.13658000E-03  -3.52820000E-04  +5.87700000E-05  +8.59240000E-04
   +1.68444000E-03  +1.75348000E-03  +4.55453040E-01  +1.08620000E-04  -6.12410000E-04
   +5.96400000E-05  +9.82000000E-06  +1.13630000E-04  +1.69200000E-04  -1.47880000E-04
   +2.94720000E-04  +9.67300000E-05  +4.81580000E-04  -4.57340000E-04  -1.29470000E-04
   -1.38130000E-04  -6.02900000E-05  -1.40910000E-04  -9.51600000E-05  +1.02070000E-04
   +4.72200000E-05  +6.75400000E-05  -4.19200000E-05  +3.70500000E-05  -8.06400000E-05
   +2.78000000E-05  -2.51400000E-05  -6.61620000E-04  +5.10950000E-04  +2.94800000E-05
   -5.11100000E-05  +2.60000000E-05  +4.91100000E-05  +6.98900000E-05  -1.83410000E-04
   -1.68300000E-04  +1.04735000E-03  -1.22560000E-04  -1.19642000E-03  +5.01670000E-04
   -2.26808000E-03  +2.76760000E-03  -8.36550000E-04  -3.53960000E-04  +4.35670000E-04
   -3.50580000E-04  -2.52200000E-05  -1.62410000E-04  +3.26632000E-03  +4.05484000E-03
   +3.42302000E-03  -8.26262000E-03  +7.59504000E-03  -8.72090000E-03  -1.27572570E-01
   -1.85575350E-01  +4.77342600E-02  -2.98454500E-02  -4.62178700E-02  +1.28758900E-02
   -6.49830000E-04  +1.31119000E-03  +6.34056000E-03  +4.35190000E-04  +3.04090000E-04
   -4.00010000E-04  +1.83220000E-04  -7.71680000E-04  -2.03518000E-03  +1.29463270E-01
   +2.95215720E-01  +6.79100000E-05  +1.07780000E-04  +1.01000000E-04  -4.14900000E-05
   -1.15700000E-05  -8.40000000E-06  +5.71300000E-05  -6.46500000E-05  -4.13000000E-06
   -3.33300000E-05  +6.79600000E-05  +4.05300000E-05  -2.53200000E-05  +2.69200000E-05
   +1.23000000E-06  +1.03200000E-05  -3.93000000E-05  -5.83700000E-05  +1.86000000E-06
   +1.56300000E-05  -3.28000000E-06  +1.20800000E-05  -2.37000000E-06  +2.58000000E-06
   +6.34800000E-05  -4.88300000E-05  +3.46000000E-06  -7.40000000E-06  +3.31000000E-06
   -5.49000000E-06  +1.60000000E-07  -6.89000000E-06  +2.28500000E-05  +2.94170000E-04
   -3.98260000E-04  -2.53000000E-05  +2.37762000E-03  -3.71926000E-03  +4.54810000E-03
   +2.65700000E-05  +4.66100000E-05  -7.24700000E-05  -8.96000000E-06  +4.61900000E-05
   -5.90700000E-05  -9.61740000E-04  +8.92536000E-03  -4.20406000E-03  -2.89804500E-02
   -2.32029800E-02  +9.54879000E-03  -1.60741500E-02  +2.99450100E-02  -9.56308200E-02
   +1.91940900E-02  +1.85378300E-02  -3.09762000E-03  -7.18783000E-03  +4.23185000E-03
   -7.97450000E-04  -1.08395000E-03  -7.68600000E-04  +2.76010000E-04  +2.85851000E-03
   -1.77516000E-03  -3.51830000E-04  +1.69001270E-01  -1.65698850E-01  +3.53419830E-01
   +3.88680000E-04  +4.66590000E-04  -8.46500000E-05  -2.02930000E-04  +4.50800000E-05
   -3.16700000E-04  +1.52300000E-04  -2.88760000E-04  -1.64560000E-04  -5.36470000E-04
   +4.84330000E-04  +1.97590000E-04  +4.08800000E-05  +1.64930000E-04  +7.95700000E-05
   +1.66400000E-04  +1.52830000E-04  -7.78700000E-05  -6.33800000E-05  -1.66900000E-05
   +1.80400000E-05  +5.73900000E-05  -3.70000000E-05  +4.35200000E-05  +6.88650000E-04
   -4.73830000E-04  -6.75100000E-05  +6.35000000E-06  -4.35900000E-05  +3.49000000E-06
   -9.10200000E-05  +2.86900000E-05  +1.99700000E-04  -6.37350000E-04  -1.06268000E-03
   -6.69330000E-04  +1.79516000E-03  -6.88494000E-03  +7.24959000E-03  +2.60700000E-05
   -7.46100000E-05  +1.66060000E-04  +4.48510000E-04  +1.08600000E-04  -3.17100000E-05
   +3.44825000E-03  +2.89859000E-03  +1.24280000E-03  +1.93341000E-03  +3.43931000E-03
   -3.70363000E-03  +7.13288000E-03  +2.72118900E-02  -1.24059400E-02  +9.99340000E-04
   +4.96604500E-02  +6.59657200E-02  -3.39034800E-02  +1.24999000E-03  +4.71610000E-03
   -6.78900000E-05  -1.68740000E-04  -2.53550000E-04  -3.44530000E-04  -1.65990000E-04
   -2.22540000E-04  -2.13168200E-02  -1.19173400E-02  -4.96048000E-03  +5.91663500E-02
   -9.02000000E-06  -1.52360000E-04  +2.91200000E-05  +1.13610000E-04  -5.00600000E-05
   +9.93600000E-05  -6.13200000E-05  +1.02030000E-04  +3.91800000E-05  +6.91100000E-05
   -1.16190000E-04  -8.89500000E-05  +4.63000000E-05  -6.31200000E-05  +1.85300000E-05
   -1.07740000E-04  -3.55000000E-05  +6.61200000E-05  +4.52000000E-06  -1.90000000E-06
   -7.83000000E-06  -9.29000000E-06  +1.05700000E-05  -9.58000000E-06  -1.22220000E-04
   +8.58600000E-05  +1.42600000E-05  +1.90000000E-07  +4.38000000E-06  +3.51000000E-06
   -1.81000000E-06  +2.13800000E-05  -7.49100000E-05  +3.30610000E-04  -2.06740000E-04
   -4.80400000E-04  -5.43495000E-03  +5.08093000E-03  -8.91724000E-03  -4.49720000E-04
   -1.53930000E-04  +1.40090000E-04  -1.56950000E-04  +5.47300000E-05  -2.10800000E-05
   -5.74985000E-03  -7.27679000E-03  +5.73369000E-03  +9.24919000E-03  +3.03184000E-03
   +4.76302000E-03  +7.90950000E-04  -7.50510000E-03  -1.70353400E-02  +1.10717050E-01
   -1.03744000E-01  -3.89886100E-02  +4.93100000E-05  -8.81100000E-04  +4.70338000E-03
   -2.24700000E-05  -2.64330000E-04  +5.69800000E-05  +4.07600000E-05  +3.97700000E-05
   +1.12900000E-05  -1.39655000E-03  +1.54089000E-03  +3.88447000E-03  -9.83918200E-02
   +1.28584880E-01  +2.08370000E-04  +4.26070000E-04  -1.68080000E-04  -1.86610000E-04
   +5.99600000E-05  -2.46010000E-04  +1.34390000E-04  -2.65990000E-04  -1.33130000E-04
   -3.29390000E-04  +3.66140000E-04  +1.95960000E-04  -1.10400000E-05  +1.21930000E-04
   +1.36400000E-05  +2.29680000E-04  +1.07390000E-04  -5.42100000E-05  -5.14900000E-05
   -5.00000000E-08  -4.60000000E-07  +3.59900000E-05  -3.02000000E-05  +3.20300000E-05
   +4.71790000E-04  -3.36770000E-04  -5.56800000E-05  +1.49600000E-05  -3.24900000E-05
   -3.66000000E-06  -4.48300000E-05  -1.43900000E-05  +1.77360000E-04  -5.41670000E-04
   -1.52750000E-04  +3.44760000E-04  +6.30303000E-03  -7.68991000E-03  +1.31638000E-02
   +5.74130000E-04  +3.57520000E-04  -2.12980000E-04  +3.45530000E-04  -3.29000000E-06
   +7.67800000E-05  +4.68244000E-03  +9.54662000E-03  -6.10513000E-03  -7.42230000E-03
   -1.73034000E-03  -6.36355000E-03  +8.32790000E-03  +2.37980700E-02  -8.79995000E-03
   +1.43596800E-01  -9.04881300E-02  -9.29770000E-03  -2.13871000E-02  -9.77090000E-03
   -6.36237000E-03  +4.91200000E-05  +2.07960000E-04  -1.03380000E-04  -2.73040000E-04
   -4.28900000E-05  -9.74800000E-05  -1.37904700E-02  -4.60671000E-03  -5.79040000E-03
   -9.72559200E-02  +6.63870300E-02  +2.91195200E-02  -2.64730000E-04  -1.12030000E-04
   +1.81520000E-04  -3.30000000E-07  -2.92200000E-05  +7.14700000E-05  +3.14800000E-05
   -7.43000000E-06  -2.35900000E-05  -4.70400000E-05  +4.06000000E-05  -1.03300000E-05
   +1.58000000E-05  -2.51000000E-06  +5.20500000E-05  -5.45400000E-05  -1.12480000E-04
   -7.78100000E-05  -7.70000000E-06  +1.19200000E-05  -4.98000000E-06  +1.33000000E-05
   +6.57000000E-06  -3.61000000E-06  +6.53000000E-05  -5.02300000E-05  +6.60000000E-06
   +4.05000000E-06  +1.81000000E-06  -8.60000000E-06  +5.17900000E-05  +7.33800000E-05
   -1.45400000E-05  +3.47630000E-04  +1.65421000E-03  +1.17988000E-03  +6.40836000E-03
   +1.53207900E-02  -1.78885200E-02  +2.82460000E-04  -2.10000000E-06  +9.37200000E-05
   -2.28674000E-03  -9.91840000E-04  -5.32960000E-04  -3.19699000E-03  -1.97486000E-03
   -4.80490000E-03  -5.17050000E-04  -1.23560000E-04  +2.52350000E-04  -4.55520000E-03
   -1.83197000E-03  -2.04203000E-03  +2.86657000E-03  -1.94421400E-02  +2.09610400E-02
   -5.56406900E-02  +2.11394000E-03  -9.19639000E-03  +3.38900000E-05  +1.19851000E-03
   -7.18680000E-04  +8.32000000E-06  +1.94990000E-04  +2.19550000E-04  -2.47480000E-04
   -1.99329000E-03  +6.38110000E-04  +1.66050000E-03  +4.20270000E-04  +5.26790000E-04
   +5.54028300E-02  +4.26170000E-04  +4.68250000E-04  +2.47010000E-04  +8.66400000E-05
   -1.15210000E-04  -1.24490000E-04  +1.76300000E-05  -5.69800000E-05  +1.27000000E-06
   -2.00800000E-05  +6.92100000E-05  +3.75000000E-05  -1.96400000E-05  -2.96100000E-05
   -4.85900000E-05  +1.32450000E-04  +8.46900000E-05  +1.65240000E-04  -1.24000000E-05
   +4.00000000E-06  -1.01900000E-05  +1.38900000E-05  -1.52800000E-05  +2.83000000E-06
   +5.76500000E-05  -5.83100000E-05  -1.89600000E-05  +1.27600000E-05  -1.45600000E-05
   +3.34000000E-06  +2.31700000E-05  -6.30200000E-05  -2.38000000E-06  +1.00490000E-03
   -2.90988000E-03  -1.57132000E-03  -2.47110000E-04  +3.64832000E-03  +1.70154000E-03
   -6.13260000E-04  -3.27200000E-04  -1.12000000E-06  -2.60307000E-03  -5.38950000E-04
   -7.77000000E-06  -1.97601000E-03  +4.20427000E-03  +3.14970000E-03  +3.29430000E-04
   -3.28950000E-04  -5.59250000E-04  -3.90085000E-03  +1.88523000E-03  +1.80182000E-03
   +2.21921000E-03  -8.03634000E-03  +1.29201900E-02  -6.75800000E-04  -1.72946610E-01
   +1.52941870E-01  -6.25700000E-05  -1.43750000E-04  -1.72280000E-04  +2.22030000E-04
   -4.08260000E-04  -3.47060000E-04  -1.92330000E-04  -2.97160000E-04  +5.01160000E-04
   -8.96930000E-04  +1.97210000E-04  +8.74520000E-04  +5.51456000E-03  +1.77339030E-01
   +3.78060000E-04  +2.25150000E-04  +1.12130000E-04  +3.49100000E-05  -6.27400000E-05
   -7.81500000E-05  +1.49000000E-05  -6.61200000E-05  -2.90000000E-06  -2.98600000E-05
   +6.58900000E-05  +2.17800000E-05  +7.38000000E-06  -1.13700000E-05  +3.77000000E-06
   +4.66700000E-05  +3.35800000E-05  +9.59900000E-05  -3.82000000E-06  +1.10300000E-05
   -1.54900000E-05  +1.12400000E-05  -8.01000000E-06  +2.97000000E-06  +7.42200000E-05
   -6.39500000E-05  -9.99000000E-06  +8.27000000E-06  -8.18000000E-06  -2.79000000E-06
   -1.48000000E-05  +1.50000000E-05  -1.59300000E-05  +2.14047000E-03  -1.11580000E-03
   -2.13292000E-03  +6.01160000E-04  +1.28863200E-02  -7.33878000E-03  -6.91660000E-04
   -2.17450000E-04  +4.24000000E-06  +1.12003000E-03  +1.04440000E-03  +4.03240000E-04
   -4.74315000E-03  +2.78669000E-03  +1.77680000E-03  -7.56300000E-05  -7.53030000E-04
   -1.12110000E-04  +8.37100000E-05  +8.48630000E-04  +2.81080000E-03  -8.49650000E-04
   +3.36605000E-03  -2.18455000E-03  -1.11871300E-02  +1.50289060E-01  -2.13580720E-01
   +2.71460000E-04  +3.23190000E-04  -7.47230000E-04  +1.79230000E-04  -2.32280000E-04
   -3.63520000E-04  -2.62560000E-04  +5.19700000E-04  +8.72300000E-05  -1.24466000E-03
   +3.62440000E-04  -2.81200000E-04  +1.05927800E-02  -1.68706980E-01  +2.20738820E-01
   +2.60740000E-04  -4.01750000E-04  +4.31040000E-04  +2.14500000E-05  +3.67390000E-04
   +5.54710000E-04  -9.85400000E-05  -5.72300000E-05  -2.16100000E-04  -7.48700000E-05
   +2.45000000E-05  -1.99200000E-05  +9.26900000E-05  -7.34400000E-05  -2.38900000E-05
   -6.58100000E-05  +3.33800000E-05  +3.91600000E-05  -1.23334000E-03  -7.44100000E-05
   +5.04600000E-04  -1.90000000E-07  -4.26000000E-06  +2.66200000E-05  +1.10280000E-04
   -1.16720000E-04  -3.48600000E-05  +9.42000000E-06  -5.45000000E-06  -1.23400000E-05
   -1.99500000E-05  -4.47800000E-05  -4.25300000E-05  -1.88931000E-03  -8.83300000E-05
   +1.78710000E-04  +1.68960000E-04  +5.90040000E-04  -4.02070000E-04  -4.80973100E-02
   +7.40184000E-03  -1.40073300E-02  -6.73000000E-06  +7.45100000E-05  +1.12140000E-04
   -4.96900000E-05  -9.77400000E-05  -1.02920000E-04  -2.87710000E-04  -4.67600000E-05
   +7.80500000E-05  +2.47100000E-05  -9.59000000E-05  +6.71600000E-05  +2.45930000E-04
   -1.03990000E-04  -2.03440000E-04  -3.28070000E-04  -4.48900000E-05  -7.65400000E-05
   +2.42860000E-04  -2.77630000E-04  -9.88800000E-05  +1.52200000E-05  -2.49400000E-05
   -2.14400000E-05  +1.61000000E-06  +1.96700000E-05  -5.61000000E-06  -1.27330000E-04
   +4.41400000E-05  -1.48820000E-04  +4.09100000E-05  +2.34700000E-05  +5.64700000E-05
   +4.86478100E-02  -9.35000000E-05  +9.52200000E-04  +4.81200000E-04  +6.35390000E-04
   +2.86670000E-04  +9.97600000E-05  +1.51700000E-05  -1.72710000E-04  -1.33870000E-04
   +1.48900000E-04  +6.28000000E-06  +1.68200000E-04  -1.53180000E-04  +7.47400000E-05
   -4.06200000E-05  -2.28490000E-04  -1.22090000E-04  +2.00000000E-08  +2.94490000E-04
   -2.10780000E-04  -2.23700000E-04  +1.05300000E-05  +2.87000000E-05  -2.28700000E-05
   -8.40500000E-05  +2.71900000E-05  -2.70600000E-05  -1.19000000E-05  +1.81900000E-05
   -9.55000000E-06  +1.41000000E-06  +2.39100000E-05  -2.63600000E-05  -1.69303000E-03
   +1.04510500E-02  -1.82124200E-02  +5.15060000E-04  +9.85530000E-04  +1.01360000E-04
   +7.15081000E-03  -1.12549130E-01  +1.15287120E-01  -8.77700000E-05  -2.44381000E-03
   -2.92930000E-03  -4.36930000E-04  -1.84660000E-04  -6.34410000E-04  -5.29400000E-05
   -1.28990000E-04  +1.21920000E-04  +7.76000000E-05  -8.73100000E-05  +1.35680000E-04
   +1.43620000E-04  -2.38500000E-05  -2.13190000E-04  -2.29260000E-04  +3.79000000E-05
   +5.55600000E-05  -1.14070000E-04  -1.01568000E-03  -1.67280000E-04  -2.36000000E-06
   -1.35600000E-05  -2.45700000E-05  +8.31200000E-05  +5.71000000E-05  -1.06900000E-05
   -6.14000000E-05  +5.35300000E-05  -8.98500000E-05  +3.11100000E-05  -6.70000000E-06
   -1.35600000E-05  -8.47694000E-03  +1.21060440E-01  -9.17520000E-04  +1.05894000E-03
   +9.05020000E-04  -3.49180000E-04  -2.41240000E-04  +7.62100000E-05  +3.17360000E-04
   -1.69300000E-04  +2.01600000E-04  +1.23920000E-04  +1.95190000E-04  +1.76850000E-04
   -2.37920000E-04  +1.62180000E-04  -1.16500000E-05  +6.34900000E-05  -5.09980000E-04
   -2.19700000E-05  +5.51960000E-04  +2.46010000E-04  +3.05900000E-05  +1.80700000E-05
   -2.53500000E-05  -9.84000000E-06  -5.12000000E-06  +2.09200000E-05  +9.40000000E-06
   +2.33800000E-05  +2.16900000E-05  -3.28300000E-05  +3.67700000E-05  +1.06620000E-04
   +3.40100000E-05  -1.46100000E-03  +1.32480200E-02  -2.06453600E-02  +1.44735000E-03
   +6.53090000E-04  +8.41600000E-04  -1.40892900E-02  +1.13352910E-01  -2.49170740E-01
   -2.97630000E-04  -4.95964000E-03  -3.57673000E-03  -2.46400000E-04  +7.95410000E-04
   -2.59170000E-04  -4.91690000E-04  -2.83140000E-04  +2.33220000E-04  +2.75900000E-04
   -1.36530000E-04  +2.37320000E-04  +5.89470000E-04  -2.37170000E-04  -5.14190000E-04
   -9.35280000E-04  -1.35400000E-05  -2.03440000E-04  +1.98440000E-04  -4.81450000E-04
   +2.70730000E-04  -4.42400000E-05  -1.89000000E-05  +8.30000000E-07  -1.16350000E-04
   -6.38900000E-05  -2.90400000E-05  -2.75500000E-04  +1.43320000E-04  -2.63520000E-04
   +1.44670000E-04  +1.62300000E-05  +5.58800000E-05  +1.54689600E-02  -1.23266040E-01
   +2.72057460E-01  -4.10700000E-05  +8.64300000E-05  -2.20390000E-04  -8.99110000E-04
   +1.00008000E-03  -4.55320000E-04  +1.59210000E-04  +1.35670000E-04  +1.78720000E-04
   -1.58580000E-04  +2.56800000E-05  +1.51100000E-05  +3.35000000E-05  -1.03300000E-05
   -4.81000000E-06  +1.11970000E-04  -1.11630000E-04  -1.56700000E-05  -8.34270000E-04
   +1.68872000E-03  +9.41600000E-05  +2.83200000E-05  +6.05000000E-06  -2.45400000E-05
   +7.97700000E-05  -3.36300000E-05  +2.31000000E-05  +9.88000000E-06  -1.86700000E-05
   +5.22000000E-06  -9.21000000E-06  +2.23000000E-06  +1.17700000E-05  -2.71240000E-04
   +7.02510000E-04  +9.66300000E-05  +4.56560000E-04  -6.51670000E-04  -6.85710000E-04
   -2.04929910E-01  -1.30484570E-01  +1.50568600E-02  +2.74300000E-04  +2.80470000E-04
   +3.55060000E-04  +1.61480000E-04  +3.38830000E-04  -4.24470000E-04  -2.38390000E-04
   -2.80900000E-05  -1.95400000E-05  +2.57810000E-04  +1.99510000E-04  +7.44900000E-05
   +2.19100000E-05  +5.58700000E-05  +1.31100000E-04  +5.57740000E-04  -2.52760000E-04
   +1.45750000E-04  +6.86000000E-06  -4.98900000E-05  +1.88400000E-05  -2.15600000E-05
   -3.84000000E-06  +1.53000000E-05  -2.80440000E-04  -1.97390000E-04  -4.04000000E-06
   +1.44610000E-04  -1.79000000E-06  +1.41970000E-04  -5.27700000E-05  +4.49100000E-05
   +9.99000000E-06  +2.06100000E-03  +3.02971000E-03  -2.52940000E-04  +2.22622830E-01
   -5.95300000E-04  +6.70220000E-04  +4.28290000E-04  -6.44000000E-05  -4.67180000E-04
   -6.54730000E-04  +3.58930000E-04  +1.80870000E-04  +2.76430000E-04  +8.55400000E-05
   +8.72000000E-06  +1.25400000E-04  -1.69180000E-04  +1.57250000E-04  +3.60400000E-05
   +2.59860000E-04  -1.11530000E-04  -1.91430000E-04  +1.21570000E-03  -1.08347000E-03
   +6.54740000E-04  -8.40000000E-07  -2.83200000E-05  -1.57300000E-05  -1.18480000E-04
   +1.46430000E-04  +5.04200000E-05  -8.84000000E-06  -8.71000000E-06  +1.97800000E-05
   -1.69000000E-05  +7.04100000E-05  +1.25780000E-04  -1.60805200E-02  -1.31309500E-02
   +2.35173000E-03  +2.20740000E-04  -1.58281000E-03  -4.06391000E-03  -1.29325660E-01
   -1.54780360E-01  +1.22093800E-02  +3.75800000E-05  +5.78740000E-04  +1.52215000E-03
   -3.86900000E-04  -2.08360000E-04  -1.28640000E-04  +3.16700000E-04  +1.35830000E-04
   +1.07100000E-05  -2.59100000E-05  +5.28860000E-04  -3.65050000E-04  -5.05820000E-04
   +1.03140000E-04  +6.64410000E-04  +3.51340000E-04  -5.08280000E-04  +3.35210000E-04
   -3.86600000E-05  +1.77060000E-04  +8.50700000E-05  -9.63000000E-06  -3.38100000E-05
   +1.24100000E-05  -3.65300000E-04  -2.98880000E-04  +5.29700000E-05  +1.54470000E-04
   -2.13800000E-04  +2.83570000E-04  +3.18400000E-05  -8.59200000E-05  -1.44240000E-04
   -1.15049700E-02  -9.65016000E-03  +1.20060000E-04  +1.42139400E-01  +1.66871940E-01
   -1.12390000E-04  +6.52480000E-04  +5.82860000E-04  +4.26930000E-04  +3.26290000E-04
   +4.87300000E-04  +5.92800000E-05  -1.74870000E-04  -1.60010000E-04  +1.55060000E-04
   +3.88000000E-05  +1.43720000E-04  -1.29550000E-04  +6.35100000E-05  -2.38800000E-05
   -1.22100000E-05  +2.71400000E-05  -2.38880000E-04  -1.11630000E-04  +6.15900000E-05
   +9.55800000E-05  -7.63000000E-06  -2.32000000E-06  +1.21400000E-05  -5.48000000E-05
   +1.10400000E-05  -3.28200000E-05  -1.94500000E-05  -1.07900000E-05  +1.00200000E-05
   -3.75700000E-05  -1.06900000E-05  +3.22800000E-05  -2.02594400E-02  -1.57205600E-02
   +6.10360000E-04  +9.06560000E-04  -2.46091000E-03  -3.66076000E-03  +1.53297400E-02
   +1.34486500E-02  -4.94261700E-02  -1.06996000E-03  -7.58610000E-04  +1.28119000E-03
   -1.17840000E-04  +3.27880000E-04  -7.87600000E-05  -4.37210000E-04  +4.39500000E-05
   +1.39710000E-04  +2.24960000E-04  +3.25100000E-04  +6.20000000E-06  -1.02200000E-05
   +4.16000000E-06  +1.71770000E-04  -6.16770000E-04  -5.21450000E-04  +1.70930000E-04
   +2.30230000E-04  -3.63370000E-04  -2.49100000E-05  -2.28100000E-05  -2.84400000E-05
   +1.00600000E-05  -4.48340000E-04  -3.22130000E-04  -4.19000000E-05  -1.32210000E-04
   -5.48900000E-05  +4.36200000E-05  +2.22900000E-05  -1.50590000E-04  -1.47090000E-04
   +2.23641500E-02  +1.67896800E-02  -8.90360000E-04  -1.60485500E-02  -1.14288400E-02
   +5.20888100E-02  +6.03880000E-04  -2.85550000E-04  -3.46130000E-04  -2.84450000E-04
   -1.05750000E-04  -3.98910000E-04  +2.09720000E-04  +1.47570000E-04  +2.19760000E-04
   +1.11320000E-04  -6.08300000E-05  +3.20700000E-05  -8.59200000E-05  +7.17600000E-05
   +7.51200000E-05  +1.38200000E-04  -1.91430000E-04  -2.60190000E-04  +2.73940000E-04
   +1.23470000E-04  +4.74560000E-04  -2.07300000E-05  +5.18000000E-06  -2.16300000E-05
   -1.80320000E-04  +1.62590000E-04  +4.58100000E-05  -2.05600000E-05  -4.63000000E-06
   +1.87900000E-05  +8.15200000E-05  +5.98700000E-05  +5.12000000E-05  -4.46280000E-04
   -1.20118000E-03  -8.41260000E-04  +8.89670000E-04  -1.30319000E-03  +3.17900000E-05
   -2.42496970E-01  +1.21671980E-01  -1.73893000E-03  -5.18000000E-05  -2.21910000E-04
   -2.70980000E-04  +2.40950000E-04  +2.63760000E-04  -2.41830000E-04  -1.82000000E-04
   -5.52000000E-06  +2.04100000E-05  +4.52900000E-05  -4.78300000E-05  +1.07490000E-04
   +7.51400000E-05  +2.64000000E-05  -6.79000000E-06  +2.26730000E-04  +1.53300000E-04
   -1.18930000E-04  +1.37800000E-05  -5.87600000E-05  -1.81000000E-06  -3.43000000E-06
   +8.01000000E-06  -1.10000000E-07  +1.88600000E-05  +1.18000000E-05  -2.25600000E-05
   -5.53800000E-05  +3.98700000E-05  -4.78000000E-05  +2.86200000E-05  +2.21600000E-05
   -1.00900000E-05  -8.28740000E-04  -4.95620000E-04  +2.15090000E-04  -1.94253500E-02
   +1.35628800E-02  -7.28150000E-04  +2.60397670E-01  -1.39950000E-03  -1.77326000E-03
   -3.77057000E-03  -5.90700000E-04  +8.52400000E-05  -4.73670000E-04  +1.14440000E-04
   +1.25380000E-04  +3.71400000E-05  -2.97820000E-04  +1.18850000E-04  -6.17000000E-05
   +1.75000000E-05  -3.53150000E-04  -1.66630000E-04  +1.33953000E-03  -2.14980000E-04
   +1.88190000E-04  -1.25610000E-04  -3.70400000E-05  +3.35660000E-04  +5.09100000E-05
   -1.08500000E-05  -3.63000000E-06  +2.62700000E-04  -1.78490000E-04  +2.39500000E-05
   +8.12800000E-05  -1.05410000E-04  +2.69700000E-05  -2.16000000E-05  +2.90200000E-05
   -7.70900000E-05  +1.76893200E-02  -1.32529200E-02  +2.18100000E-05  +1.34001000E-03
   +5.25380000E-04  +2.11900000E-04  +1.19917390E-01  -1.20975930E-01  +2.22039000E-03
   -2.42070000E-04  +3.27360000E-04  +1.28224000E-03  -1.37500000E-05  -3.53310000E-04
   +5.51960000E-04  +9.40900000E-05  +4.80900000E-05  +3.48800000E-05  -1.96970000E-04
   -1.91560000E-04  -7.97900000E-05  -2.57970000E-04  -2.12200000E-05  -7.44400000E-05
   -3.38650000E-04  +2.43460000E-04  +1.43600000E-05  +2.24000000E-05  +1.24940000E-04
   -1.52490000E-04  +8.94000000E-06  -8.77000000E-06  -9.23000000E-06  +2.05870000E-04
   +1.78110000E-04  -1.76000000E-06  -7.79800000E-05  -6.36200000E-05  -9.93200000E-05
   +1.95800000E-05  -1.38900000E-05  -8.42600000E-05  +1.29725500E-02  -8.35774000E-03
   -6.23730000E-04  -1.80334300E-02  +1.21300600E-02  -4.72770000E-04  -1.32007220E-01
   +1.31275910E-01  -1.44274000E-03  -2.57265000E-03  -3.93214000E-03  -9.04100000E-04
   -2.59500000E-04  -3.74070000E-04  +2.12300000E-04  -4.07800000E-05  +2.07950000E-04
   -9.38400000E-05  +1.48960000E-04  +2.16800000E-05  -1.50150000E-04  -2.44670000E-04
   -2.59680000E-04  +1.41957000E-03  -8.59220000E-04  +3.31210000E-04  +1.08300000E-04
   +5.22360000E-04  +1.73410000E-04  +2.12000000E-05  -3.16800000E-05  +1.07300000E-05
   +1.18750000E-04  -4.38600000E-05  +1.97800000E-05  +1.15970000E-04  -5.44100000E-05
   -2.84200000E-05  -8.96000000E-06  +2.68300000E-05  +1.57000000E-06  +2.17115500E-02
   -1.38530800E-02  -1.46859000E-03  +8.23770000E-04  +4.45500000E-04  +4.98380000E-04
   -3.33702000E-03  +3.17111000E-03  -4.67533800E-02  +1.28324000E-03  -8.16890000E-04
   +1.20618000E-03  -4.33350000E-04  -5.53400000E-05  -3.29900000E-05  +4.13340000E-04
   -1.05400000E-05  +5.41000000E-05  -1.73700000E-04  +4.62000000E-06  -1.60400000E-04
   -2.04600000E-04  -8.07700000E-05  -5.00500000E-05  +9.34800000E-05  +1.86250000E-04
   +1.94040000E-04  -2.16000000E-05  -1.02600000E-05  +6.86900000E-05  -1.81800000E-05
   +1.50900000E-05  +1.16000000E-05  +1.72620000E-04  +1.11250000E-04  +7.63000000E-06
   -1.41000000E-05  -5.92000000E-06  +4.55200000E-05  -3.97400000E-05  -3.35000000E-06
   -8.41800000E-05  -2.46564500E-02  +1.39899400E-02  +7.31610000E-04  +2.45381000E-03
   -1.41780000E-03  -9.18800000E-04  +3.21140000E-03  +1.27123000E-03  +5.10347300E-02
   +1.13620000E-04  -7.16570000E-04  -4.16010000E-04  -2.70500000E-04  +9.38300000E-05
   -8.98800000E-05  +1.82200000E-04  -1.25780000E-04  -7.02300000E-05  +1.21500000E-05
   +1.56020000E-04  +1.19960000E-04  -3.00250000E-04  +7.39100000E-05  +7.19900000E-05
   -9.86200000E-05  +1.03890000E-04  -4.74800000E-05  +3.83400000E-05  -6.81000000E-06
   +6.59800000E-05  +4.10000000E-06  -6.52000000E-06  +7.68000000E-06  +5.81000000E-05
   -4.73000000E-05  +3.81000000E-06  +1.13500000E-05  +1.84600000E-05  -1.73800000E-05
   +2.35850000E-04  +3.10130000E-04  -1.33860000E-04  -1.89346000E-03  +9.67700000E-05
   +2.97700000E-04  +2.75420000E-04  +5.03240000E-04  +3.64660000E-04  -2.69900000E-05
   -4.09700000E-05  +1.92620000E-04  -4.84154900E-02  -1.03803900E-02  -1.52675400E-02
   -6.69200000E-05  -1.05610000E-04  +9.53700000E-05  +1.48450000E-04  +8.43400000E-05
   +5.36000000E-06  -7.92300000E-05  -2.52700000E-05  -5.20100000E-05  -1.74350000E-04
   +8.83900000E-05  -1.52210000E-04  +8.30700000E-05  -2.96500000E-04  +5.87440000E-04
   -1.54700000E-05  +4.01400000E-05  -4.33500000E-05  +1.17400000E-05  +5.22000000E-06
   -1.10700000E-05  +1.22660000E-04  +1.42590000E-04  -3.31700000E-05  -3.39600000E-05
   -1.67100000E-05  +4.86000000E-05  -1.24517000E-03  +1.16890000E-04  +4.98790000E-04
   +6.76760000E-04  +5.04900000E-05  +1.08400000E-05  +1.76000000E-04  +3.18800000E-04
   +1.93180000E-04  +2.69500000E-04  -2.74970000E-04  -2.76550000E-04  +4.90752900E-02
   -3.73340000E-04  +9.33840000E-04  -2.53800000E-05  +1.57230000E-04  -5.00000000E-08
   -8.48100000E-05  -1.05840000E-04  +1.19940000E-04  +1.18340000E-04  +1.15800000E-05
   -7.50600000E-05  -1.41850000E-04  -3.32700000E-05  -1.37740000E-04  -9.61500000E-05
   +4.59630000E-04  -2.51230000E-04  +6.65570000E-04  -2.23000000E-05  -1.07300000E-05
   +1.47100000E-05  -1.61200000E-05  -3.65000000E-06  +2.83000000E-06  -1.37960000E-04
   +8.58500000E-05  +7.54000000E-06  -9.40000000E-07  -4.82000000E-06  +2.25000000E-05
   +1.48500000E-04  -9.60940000E-04  +2.72520000E-04  +1.71087000E-03  +1.04790000E-02
   +1.49527900E-02  +5.74000000E-06  +8.11640000E-04  -3.82190000E-04  +7.23700000E-05
   -1.62037000E-03  +2.75408000E-03  -1.03530000E-02  -1.39899890E-01  -1.28286180E-01
   +2.75610000E-04  -3.56300000E-05  -6.08900000E-05  +7.66400000E-05  +5.97700000E-05
   +1.57500000E-05  -1.30710000E-04  -3.38100000E-05  -1.00010000E-04  +8.77200000E-05
   -9.65100000E-05  +1.17920000E-04  -7.15330000E-04  +2.82000000E-04  -1.08070000E-04
   +2.00000000E-06  +1.90900000E-05  +2.97800000E-05  +1.21300000E-05  +1.55900000E-05
   +6.24000000E-06  +7.22300000E-05  -7.54000000E-06  +3.07700000E-05  -1.38600000E-05
   -4.04000000E-06  -5.67500000E-05  -1.78910000E-04  -1.79010000E-04  +1.93320000E-04
   -4.28700000E-05  +8.55530000E-04  +8.70860000E-04  +2.48780000E-04  +2.43400000E-05
   +1.50540000E-04  -2.30090000E-04  +7.17000000E-06  +1.75460000E-04  +1.19313500E-02
   +1.50576670E-01  +1.47717000E-03  -8.06520000E-04  +6.99320000E-04  -8.23060000E-04
   +8.99000000E-05  -1.95060000E-04  +4.48000000E-04  -3.90890000E-04  -1.02360000E-04
   +2.45380000E-04  +3.34280000E-04  +3.80250000E-04  -5.07100000E-04  +3.27200000E-04
   +2.31670000E-04  -2.03690000E-04  -6.94740000E-04  -1.32980000E-04  +1.48480000E-04
   +1.26200000E-05  +6.91900000E-05  +7.96000000E-06  +1.39200000E-05  -2.13100000E-05
   +4.41900000E-05  -1.58200000E-05  -7.49000000E-06  -4.44400000E-05  +2.28000000E-06
   +4.64000000E-06  +2.02710000E-04  +6.13740000E-04  +1.91100000E-04  -1.91432000E-03
   -1.65408000E-02  -2.09295100E-02  -8.86940000E-04  -1.11893000E-03  +1.22801000E-03
   -2.29170000E-04  +4.64270000E-03  -4.38097000E-03  -1.55554400E-02  -1.26044410E-01
   -2.22780630E-01  +3.83300000E-05  +6.21480000E-04  -1.80860000E-04  -3.25560000E-04
   -1.80760000E-04  -5.06200000E-05  +1.82560000E-04  -1.45680000E-04  +1.94440000E-04
   +3.24920000E-04  +2.43700000E-05  +1.30990000E-04  -2.02130000E-04  +3.06060000E-04
   +5.81500000E-05  +3.56300000E-05  -1.00060000E-04  +3.73000000E-05  +1.55700000E-05
   -2.68500000E-05  -3.29400000E-05  -7.26900000E-05  -7.95300000E-05  +6.49000000E-06
   +5.40600000E-05  +4.59800000E-05  -9.05900000E-05  +5.85050000E-04  -2.29710000E-04
   +5.04000000E-06  +1.19800000E-05  -1.11165000E-03  -1.57002000E-03  -5.51100000E-05
   +1.21960000E-04  +3.46860000E-04  +4.32800000E-05  +9.91400000E-05  +2.64320000E-04
   +1.66538000E-02  +1.37138880E-01  +2.43401030E-01  +5.57680000E-04  +6.65900000E-04
   -7.14590000E-04  +5.28180000E-04  +2.05610000E-04  +1.21260000E-04  -2.11700000E-05
   +5.72500000E-05  +8.94900000E-05  +3.12270000E-04  -1.87600000E-04  +3.44500000E-05
   -2.44680000E-04  -2.96000000E-06  -4.34400000E-05  +2.20980000E-04  -3.76100000E-04
   -4.29610000E-04  -5.15900000E-05  -4.89600000E-05  -1.30500000E-05  -3.30600000E-05
   +8.09000000E-06  -5.32000000E-06  -3.31970000E-04  +2.37740000E-04  +5.18000000E-06
   -2.40100000E-05  +6.61000000E-06  +1.73300000E-05  +1.35900000E-05  +4.89300000E-05
   +1.73200000E-05  -3.45420000E-04  -7.82810000E-04  +1.18280000E-04  -3.28600000E-05
   -1.12910000E-04  -1.39590000E-04  +2.73570000E-04  -2.23660000E-04  +3.84860000E-04
   -2.00507600E-01  +1.31323740E-01  +1.18958000E-03  +1.20710000E-04  +1.60780000E-04
   -4.92600000E-05  +7.89000000E-06  +9.61000000E-06  -2.75400000E-05  -1.27230000E-04
   -3.72700000E-05  +5.41000000E-06  +2.29290000E-04  -1.69480000E-04  +1.18230000E-04
   -9.60360000E-04  -1.04713000E-03  -3.11920000E-04  -1.52800000E-05  -4.41000000E-06
   +1.52000000E-05  +9.90000000E-06  +1.50400000E-05  +8.30000000E-07  +4.38500000E-05
   +1.42000000E-05  +2.91500000E-05  -5.98500000E-05  +2.62900000E-05  -3.82500000E-05
   -1.05985000E-03  -1.82318000E-03  +3.55220000E-04  +1.75560000E-04  -2.63190000E-04
   -2.83300000E-05  -2.10870000E-04  +1.13920000E-04  -6.14800000E-05  +3.08190000E-04
   -1.36250000E-04  -3.67100000E-04  +2.24172000E-03  -3.24190000E-03  +1.08750000E-04
   +2.18114210E-01  -5.61600000E-05  -1.01049000E-03  +3.54958000E-03  -4.94290000E-04
   -4.31380000E-04  -2.44520000E-04  +6.06750000E-04  -3.88890000E-04  -3.58470000E-04
   -8.76200000E-05  +5.28960000E-04  +4.90830000E-04  -2.94010000E-04  +1.48390000E-04
   +2.43000000E-05  +3.46180000E-04  -1.33380000E-04  +2.37660000E-04  -3.00000000E-05
   -2.43200000E-05  +1.34110000E-04  +1.02010000E-04  -4.97000000E-06  -3.90200000E-05
   +4.35650000E-04  -3.49200000E-04  -6.08700000E-05  +1.10100000E-05  -3.78400000E-05
   -9.96000000E-06  +5.97200000E-05  +2.17210000E-04  -1.16800000E-04  +1.34441800E-02
   -1.14661500E-02  -1.32713000E-03  +6.16160000E-04  +5.36790000E-04  -4.94080000E-04
   -1.46230000E-04  +4.87940000E-04  -1.42428000E-03  +1.30217030E-01  -1.59754040E-01
   -7.75490000E-04  -2.82220000E-04  -1.99160000E-04  +2.69940000E-04  +2.17350000E-04
   +1.43820000E-04  -1.01900000E-05  -6.29900000E-05  -2.05000000E-05  -1.09170000E-04
   -5.57830000E-04  +2.56130000E-04  -2.71020000E-04  +3.78900000E-04  -4.32950000E-04
   +6.59480000E-04  +2.24100000E-05  +5.97000000E-05  -1.25110000E-04  +8.60000000E-06
   -9.30000000E-06  -1.48600000E-05  +1.33500000E-04  +1.96520000E-04  -6.73500000E-05
   -5.89200000E-05  -9.85300000E-05  +1.03100000E-04  -1.46802000E-03  -1.22389000E-03
   -4.70770000E-04  -3.05480000E-04  +1.84400000E-05  -7.26100000E-05  -1.14440000E-04
   -2.08200000E-05  +1.24910000E-04  -2.26070000E-04  +6.20040000E-04  +2.99150000E-04
   +1.37373200E-02  -1.14865800E-02  +1.16435000E-03  -1.43226950E-01  +1.71764540E-01
   +9.11980000E-04  +2.11470000E-03  -4.22553000E-03  -4.95860000E-04  +6.13820000E-04
   +1.40630000E-04  -2.02170000E-04  -1.36280000E-04  +3.52530000E-04  +3.34980000E-04
   -1.70470000E-04  -6.20000000E-06  -5.12820000E-04  -6.05000000E-05  +1.16110000E-04
   -1.11300000E-04  -3.33520000E-04  -4.44500000E-05  +3.16400000E-05  +1.17810000E-04
   -1.72620000E-04  -7.87900000E-05  +3.13200000E-05  -3.65000000E-06  -4.58820000E-04
   +3.76850000E-04  +6.69000000E-06  -3.25800000E-05  +2.75800000E-05  +1.79200000E-05
   +2.50940000E-04  +3.53810000E-04  -5.79100000E-05  -2.16124800E-02  +1.71559900E-02
   -8.48260000E-04  -2.51720000E-04  -5.75020000E-04  +6.79120000E-04  -1.07255000E-03
   +9.13890000E-04  +1.32819000E-03  +1.51279000E-03  -1.99739000E-03  -4.83519200E-02
   +5.74000000E-06  -6.33900000E-05  -2.73580000E-04  -1.35720000E-04  -6.02100000E-05
   +2.17500000E-05  +1.74810000E-04  -1.25200000E-05  +9.43800000E-05  +7.84500000E-05
   +1.15420000E-04  -3.68700000E-05  +4.89560000E-04  -2.29290000E-04  +4.14010000E-04
   -4.43100000E-05  +5.40000000E-06  +4.64000000E-05  -1.73800000E-05  +1.08900000E-05
   +8.51000000E-06  -7.19900000E-05  -1.86600000E-05  -2.29600000E-05  +4.30200000E-05
   +1.79100000E-05  +4.13500000E-05  +4.04200000E-05  +7.76900000E-05  +2.04500000E-04
   +2.28010000E-04  -1.22990000E-04  +3.81660000E-04  -5.08500000E-05  -1.34860000E-04
   -5.38100000E-05  +4.65620000E-04  -1.99980000E-04  -7.41340000E-04  +2.07227600E-02
   -1.57353800E-02  +9.33580000E-04  -9.98880000E-04  -9.69440000E-04  +5.10957400E-02
   +8.92170000E-04  +1.27055000E-03  -1.48790000E-04  +2.26380000E-04  -1.68560000E-04
   -1.12170000E-04  +8.14300000E-05  -7.87200000E-05  +5.33100000E-05  +1.12700000E-05
   +6.07300000E-05  +1.14530000E-04  -1.61080000E-04  -6.69000000E-06  +3.79800000E-05
   +2.49370000E-04  -2.37480000E-04  -2.09650000E-04  +2.42600000E-05  -2.16400000E-05
   +2.36000000E-06  +2.50600000E-05  -1.46300000E-05  -2.02000000E-06  +4.58800000E-05
   -2.02100000E-05  -2.23800000E-05  -4.24000000E-06  -1.01400000E-05  +3.34000000E-06
   +2.73000000E-05  +6.24400000E-05  -1.31800000E-05  -3.87760000E-04  +1.06121000E-03
   -9.46850000E-04  +5.55970000E-04  +2.48470000E-04  -3.33290000E-04  -3.86400000E-05
   +2.14010000E-04  -2.93410000E-04  -2.46712000E-01  -1.19925440E-01  +1.29007400E-02
   +1.51970000E-04  +2.34260000E-04  -3.31370000E-04  -1.20750000E-04  -6.29000000E-05
   +4.78500000E-05  +8.71000000E-05  +5.59600000E-05  +4.92400000E-05  +3.17340000E-04
   -8.94200000E-05  +2.31300000E-04  -3.47570000E-04  +7.54300000E-05  -3.16330000E-04
   +8.25800000E-05  -5.47700000E-05  +4.80300000E-05  -2.00100000E-05  +9.84000000E-06
   +1.78100000E-05  -1.60190000E-04  -1.71510000E-04  +4.94500000E-05  +1.14210000E-04
   +3.30600000E-05  -1.16000000E-06  +2.38560000E-04  -1.03050000E-04  +4.63630000E-04
   +2.70440000E-04  +2.25010000E-04  +1.30400000E-05  +2.99960000E-04  +2.65880000E-04
   +4.41870000E-04  +6.82000000E-06  -1.25160000E-04  -5.37500000E-05  -1.15244000E-03
   +3.25560000E-04  +2.22680000E-04  -1.92636800E-02  -1.29386900E-02  +8.56000000E-04
   +2.64772500E-01  -1.16728000E-03  +5.73370000E-04  -1.65390000E-04  +3.46200000E-04
   +1.24450000E-04  +1.37500000E-05  +1.41260000E-04  -1.18000000E-05  +7.44500000E-05
   +2.05180000E-04  -1.35920000E-04  +6.43200000E-05  -3.98000000E-05  +2.35800000E-05
   -3.97200000E-05  +3.93600000E-05  -3.45410000E-04  -5.59230000E-04  -2.93800000E-05
   -1.18200000E-05  +5.72200000E-05  -1.06700000E-05  -7.95000000E-06  -5.10000000E-07
   -1.99220000E-04  +1.73110000E-04  +1.31000000E-06  -1.09700000E-05  -1.06500000E-05
   +1.40100000E-05  -1.72600000E-05  +1.23290000E-04  +1.48850000E-04  -1.53231200E-02
   -1.14573000E-02  +1.22649000E-03  +1.14893000E-03  -1.15475000E-03  +3.45433000E-03
   +3.82420000E-04  +2.79720000E-04  -1.13641000E-03  -1.18086540E-01  -1.17175240E-01
   +6.50935000E-03  -1.19462000E-03  -1.23050000E-04  -9.28400000E-05  -2.45000000E-05
   -3.22560000E-04  +1.70300000E-04  +2.53510000E-04  +1.46150000E-04  +9.48000000E-05
   -1.02720000E-04  +2.01490000E-04  +5.54100000E-05  +5.52060000E-04  +1.53940000E-04
   +3.68190000E-04  +8.01000000E-06  +3.14400000E-05  +7.19900000E-05  -6.74400000E-05
   -9.98100000E-05  -2.18000000E-05  -2.09410000E-04  -1.48700000E-04  -3.27900000E-05
   +1.12060000E-04  -5.33700000E-05  +1.00270000E-04  +1.15280000E-04  -1.39570000E-04
   -2.98310000E-04  +2.33100000E-04  -2.39300000E-05  -6.23800000E-05  +8.87300000E-05
   +5.73090000E-04  +4.52800000E-05  +1.17250000E-04  +5.27800000E-05  +4.24000000E-06
   -1.58310200E-02  -9.49486000E-03  +1.87712000E-03  +1.87572700E-02  +1.21131000E-02
   -1.12953000E-03  +1.29915170E-01  +1.26222060E-01  +9.25950000E-04  -5.08220000E-04
   +6.15220000E-04  +5.43800000E-05  -1.37960000E-04  +1.96310000E-04  -1.79540000E-04
   +1.14250000E-04  -3.74900000E-05  -2.07060000E-04  -2.27300000E-05  -1.99210000E-04
   +4.19210000E-04  +8.98000000E-06  +8.15100000E-05  -4.32070000E-04  +7.84500000E-05
   -2.37400000E-05  -3.10600000E-05  -6.84000000E-06  -9.26600000E-05  +6.83000000E-06
   +9.92000000E-06  +1.00500000E-05  +1.98010000E-04  -1.32360000E-04  +2.86000000E-06
   -1.43700000E-05  -1.22700000E-05  +3.67000000E-06  -2.84000000E-05  -6.92000000E-06
   +6.40400000E-05  +2.37410100E-02  +1.47136900E-02  -3.32207000E-03  -1.39917000E-03
   +2.27197000E-03  -4.47492000E-03  +1.23371000E-03  +8.45320000E-04  +1.24913000E-03
   +1.10414200E-02  +5.61823000E-03  -4.70128500E-02  +1.58666000E-03  +9.81090000E-04
   +1.54170000E-04  -2.01150000E-04  +2.62030000E-04  -3.39140000E-04  -9.36600000E-05
   -1.53490000E-04  -2.90000000E-06  +2.68280000E-04  -1.04930000E-04  +1.01710000E-04
   -1.00161000E-03  +2.32840000E-04  -3.98190000E-04  -3.54000000E-06  -2.19600000E-05
   -2.41000000E-06  +1.18440000E-04  +6.58500000E-05  -3.27500000E-05  +9.09100000E-05
   +1.81800000E-05  +2.96100000E-05  -6.32200000E-05  +6.09600000E-05  -1.23520000E-04
   +1.06910000E-04  -4.50700000E-04  +2.04580000E-04  -3.17020000E-04  -1.40660000E-04
   +3.01130000E-04  -3.71350000E-04  -4.41270000E-04  -7.08580000E-04  -7.02500000E-05
   -9.67000000E-06  -6.18900000E-05  -2.32559300E-02  -1.25529700E-02  +2.22130000E-03
   +5.15640000E-04  -6.54000000E-06  -9.84630000E-04  -1.26789300E-02  -1.06637100E-02
   +5.23738200E-02  +6.50650000E-04  +2.22950000E-04  +4.52950000E-04  -1.08579000E-03
   -1.45790000E-04  -3.92530000E-04  +4.51082000E-03  -3.07895000E-03  +4.48810000E-04
   -3.30896200E-02  -9.04027000E-03  -2.64823300E-02  -2.51380000E-03  +5.25622000E-03
   +1.95162000E-03  -1.75070000E-04  -8.42920000E-04  -1.84672000E-03  +1.87100000E-04
   -1.98790000E-04  -4.57200000E-05  -1.70000000E-06  +1.26053000E-03  +8.29170000E-04
   -2.75929780E-01  -6.57139200E-02  -2.22263640E-01  +1.80060000E-04  -1.00550000E-04
   +3.19760000E-04  -2.91140000E-04  +2.09190000E-04  +1.54690000E-04  -1.64030000E-04
   +1.25940000E-04  +1.60770000E-04  +4.15000000E-05  -1.83950000E-04  +4.72900000E-05
   +7.90000000E-05  -6.20000000E-06  +2.21700000E-05  +1.48950000E-04  -6.82000000E-05
   -6.43400000E-05  +5.88000000E-06  +2.63000000E-05  -4.81600000E-05  +4.24300000E-05
   -1.60800000E-05  +2.62700000E-05  -1.18560000E-04  -9.56800000E-05  -1.81000000E-06
   +6.57000000E-05  -5.82700000E-05  -1.11970000E-04  -4.32900000E-05  +3.11400000E-05
   -4.64100000E-05  -2.79000000E-05  -1.00800000E-05  +5.19600000E-05  -5.20000000E-06
   +2.59000000E-06  -3.35000000E-06  +1.33450000E-04  +1.01440000E-04  -9.72000000E-06
   -1.33830000E-04  +2.62300000E-05  -9.13300000E-05  -6.78000000E-06  -1.01100000E-05
   -9.46000000E-06  -3.05800000E-05  +4.66000000E-06  +1.46400000E-05  -7.32000000E-06
   +3.84300000E-05  +4.30000000E-07  +4.57700000E-05  -2.85100000E-05  -2.07000000E-06
   -1.06900000E-05  +1.39500000E-05  -6.63000000E-06  +4.67300000E-05  -6.24200000E-05
   +5.21500000E-05  -9.92000000E-06  +3.13900000E-05  -2.51600000E-05  +3.07392390E-01
   -3.01370000E-04  -2.51230000E-04  -4.83790000E-04  +1.03430000E-04  -6.26480000E-04
   +1.34500000E-04  +1.52157000E-03  +6.94400000E-04  +2.40283000E-03  +2.45907700E-02
   +4.20463000E-03  +2.08558600E-02  +4.17350000E-03  -2.26986000E-03  -1.59936000E-03
   +5.02780000E-04  +1.53750000E-03  +2.08610000E-04  -3.18400000E-05  +1.11400000E-05
   +2.66800000E-05  -7.68450000E-04  -6.16090000E-04  -1.55137000E-03  -1.02049140E-01
   -6.61543400E-02  -1.17718320E-01  -2.93600000E-05  -1.56620000E-04  +3.10750000E-04
   +1.24660000E-04  -2.49660000E-04  +6.60800000E-05  -1.96600000E-05  -8.12200000E-05
   -4.74300000E-05  +2.65700000E-05  +5.59900000E-05  -2.73400000E-05  -3.27400000E-05
   +2.86000000E-05  +9.36000000E-06  -1.50300000E-05  +1.02200000E-05  +3.96000000E-06
   +1.28000000E-06  +1.89000000E-06  -5.11000000E-06  -2.82900000E-05  -7.70000000E-07
   -2.30300000E-05  +6.48800000E-05  +5.27400000E-05  +4.10000000E-06  -1.07800000E-05
   +1.63500000E-05  +4.19400000E-05  +3.41000000E-06  -2.40500000E-05  +1.74800000E-05
   +1.23600000E-05  +2.28400000E-05  -1.51800000E-05  -7.99000000E-06  -9.20000000E-07
   +6.07000000E-06  -7.11000000E-05  -6.35100000E-05  +8.86000000E-06  +4.49100000E-05
   -5.27000000E-06  +2.89200000E-05  +1.06900000E-05  +2.39000000E-06  +4.89000000E-06
   +2.05800000E-05  +6.91000000E-06  -9.23000000E-06  -4.75000000E-06  -3.93400000E-05
   +3.18000000E-06  -2.67900000E-05  +1.25900000E-05  -6.84000000E-06  +1.25000000E-05
   -3.75000000E-06  +1.05800000E-05  -1.26200000E-05  +2.51500000E-05  +8.15000000E-06
   +3.98000000E-06  -2.08400000E-05  +1.70000000E-07  +7.22366300E-02  +6.39053700E-02
   +1.03650000E-04  -1.67520000E-04  -1.24860000E-04  -1.38850000E-04  -1.76500000E-05
   -8.04660000E-04  +4.65345000E-03  -3.36910000E-04  +1.55674000E-03  +4.07657000E-03
   +8.11030000E-04  +5.96560000E-04  +1.04921000E-03  -9.55240000E-04  +1.97970000E-03
   -6.70030000E-04  -5.67280000E-04  +7.22670000E-04  +1.00570000E-04  -6.71300000E-05
   -4.09500000E-05  -1.04476000E-03  -3.35800000E-04  -3.75700000E-04  -2.55336330E-01
   -9.60824500E-02  -2.43938350E-01  +3.90940000E-04  +2.65120000E-04  -5.43900000E-05
   +8.44800000E-05  +1.10130000E-04  -7.55300000E-05  -1.24930000E-04  +2.74300000E-05
   +3.44800000E-05  -2.22000000E-05  -3.12200000E-05  -2.40900000E-05  +2.95300000E-05
   +4.31000000E-06  +2.69100000E-05  +7.82600000E-05  -5.94000000E-05  -4.37800000E-05
   +1.65300000E-05  -5.15000000E-06  +1.66500000E-05  +1.64400000E-05  +1.58000000E-06
   +8.55000000E-06  -1.77100000E-05  -1.78300000E-05  +8.50000000E-07  -2.10000000E-06
   +7.91000000E-06  -4.00000000E-07  +1.40700000E-05  +1.45200000E-05  -5.65000000E-06
   -7.89000000E-06  -2.28700000E-05  +2.23800000E-05  +1.10200000E-05  +3.54000000E-06
   -3.38000000E-06  +2.65200000E-05  +2.71000000E-05  -7.22000000E-06  -4.64000000E-06
   +6.00000000E-08  -8.50000000E-07  -6.99000000E-06  -2.16000000E-06  -5.49000000E-06
   +4.07000000E-06  +9.51000000E-06  -9.80000000E-06  -4.05000000E-06  -1.41000000E-06
   +1.06800000E-05  -1.26000000E-06  -1.59400000E-05  -7.51000000E-06  -9.63000000E-06
   +2.28000000E-06  -6.04000000E-06  +1.99600000E-05  -2.85800000E-05  +2.77800000E-05
   +9.40000000E-07  +2.34200000E-05  -7.60000000E-07  +2.46707240E-01  +9.74011400E-02
   +2.40524280E-01  -4.13600000E-05  -6.46960000E-04  -3.26800000E-05  +1.00100000E-04
   +9.57900000E-05  +2.72410000E-04  -1.48720000E-04  +2.59880000E-04  +1.37800000E-04
   +6.52390000E-04  -5.14770000E-04  -1.45960000E-04  -1.39960000E-04  -1.32480000E-04
   -1.10780000E-04  -9.15300000E-05  -9.89300000E-05  +6.70000000E-05  +7.61300000E-05
   -1.09000000E-06  -6.72000000E-06  -8.14300000E-05  +3.56900000E-05  -3.94200000E-05
   -7.87700000E-04  +5.46750000E-04  +6.20500000E-05  -1.28800000E-05  +4.52700000E-05
   +6.85000000E-06  +1.02790000E-04  -7.34900000E-05  -2.03080000E-04  +9.25700000E-05
   +1.01034000E-03  -8.84500000E-04  -5.25950000E-04  -2.75327000E-03  -3.97570000E-03
   -3.94590000E-04  -4.80900000E-05  -2.28000000E-06  -3.84490000E-04  +3.13500000E-05
   -2.97600000E-05  -6.34361000E-03  -2.40172000E-03  +2.52680000E-04  +8.56230000E-03
   -1.94338000E-03  +9.34810000E-04  -2.81282900E-02  -9.02980000E-04  -3.33301700E-02
   -1.80845890E-01  -3.96538000E-03  -9.18567600E-02  -2.91673300E-02  -7.46617000E-03
   -2.50404200E-02  +9.52300000E-05  +1.35150000E-04  +6.80000000E-05  -7.32230000E-04
   +4.92610000E-04  -2.05370000E-04  +1.80072200E-02  +6.32000000E-06  +1.42367700E-02
   -2.29965800E-02  -1.07041100E-02  -2.50525300E-02  +1.36065000E-03  +2.72779000E-03
   +2.13782000E-03  +8.00100000E-05  +8.11300000E-05  +2.29630000E-04  -1.33760000E-04
   -3.19680000E-04  +2.28500000E-05  +1.04580000E-04  +6.82200000E-05  +6.17700000E-05
   +7.58600000E-05  -8.19000000E-06  -4.22100000E-05  +9.15700000E-05  +1.10080000E-04
   -5.61600000E-05  -1.45220000E-04  -1.62890000E-04  +7.37400000E-05  +1.48360000E-04
   -5.72200000E-05  +1.01800000E-05  +2.46998960E-01  -5.20150000E-04  -6.46010000E-04
   +7.30400000E-05  +1.88330000E-04  -1.63400000E-05  +3.31620000E-04  -1.54220000E-04
   +3.26490000E-04  +1.47710000E-04  +4.09150000E-04  -4.57420000E-04  -2.25900000E-04
   +1.71300000E-05  -1.20130000E-04  -5.45400000E-05  -2.28030000E-04  -1.46640000E-04
   -5.09000000E-06  +5.41400000E-05  -3.21000000E-06  +1.54000000E-06  -5.17300000E-05
   +3.61600000E-05  -3.42000000E-05  -5.83360000E-04  +4.32130000E-04  +6.28700000E-05
   -2.74400000E-05  +3.61900000E-05  +1.20400000E-05  +5.61600000E-05  -3.41100000E-05
   -1.32630000E-04  -2.41340000E-04  +1.37163000E-03  +2.13650000E-04  -6.87676000E-03
   +7.47724000E-03  -8.77797000E-03  -8.15600000E-05  +3.94800000E-05  -3.91400000E-05
   -2.21610000E-04  -1.04900000E-04  -5.84800000E-05  -5.21019000E-03  -6.28239000E-03
   +1.61238000E-03  +2.73420000E-04  -4.46898000E-03  +8.52530000E-03  -3.92491000E-03
   -2.35136600E-02  +4.00364600E-02  -9.52601500E-02  -1.19327600E-02  +1.50853000E-03
   +9.53683000E-03  +9.45300000E-03  -1.38860800E-02  +2.46070000E-04  +1.98900000E-05
   +6.64000000E-06  +1.59292000E-03  -1.65120000E-04  +2.64910000E-04  +3.94856400E-02
   +5.03356000E-03  +1.89234800E-02  +4.33210500E-02  -1.48788600E-02  +1.85162000E-02
   +1.74889000E-03  +1.67100000E-04  -5.85960000E-04  +1.14890000E-04  +6.59200000E-05
   +2.30470000E-04  -8.94800000E-05  -1.50820000E-04  +9.80900000E-05  +3.86700000E-05
   +2.65200000E-05  -6.18000000E-06  +2.19900000E-05  +1.38900000E-05  +2.72100000E-05
   +4.50900000E-05  +3.94000000E-05  +1.01400000E-05  -7.57300000E-05  -7.01900000E-05
   +8.80800000E-05  +1.03760000E-04  -4.36700000E-05  +1.17900000E-05  +1.49269000E-02
   +2.22367400E-02  -2.12830000E-04  -5.56350000E-04  +2.71240000E-04  +4.08190000E-04
   -1.38240000E-04  +4.92290000E-04  -2.33500000E-04  +4.57190000E-04  +3.03500000E-04
   +7.47100000E-04  -7.29750000E-04  -3.67620000E-04  +5.58000000E-06  -2.84950000E-04
   -3.75100000E-05  -4.16310000E-04  -2.89390000E-04  +9.42900000E-05  +1.14750000E-04
   +3.86400000E-05  -2.66900000E-05  -6.93600000E-05  +5.66100000E-05  -6.47100000E-05
   -9.89030000E-04  +6.88640000E-04  +1.21540000E-04  -2.70500000E-05  +7.55800000E-05
   -9.80000000E-06  +1.17020000E-04  -2.68000000E-06  -3.77230000E-04  +1.56046000E-03
   +1.11090000E-04  -4.22100000E-05  -6.61440000E-03  +1.54043500E-02  -2.00413500E-02
   -7.26650000E-04  -3.41910000E-04  -3.41600000E-05  -7.59670000E-04  -2.07720000E-04
   -8.58000000E-05  -1.01178400E-02  -1.12630600E-02  +5.58364000E-03  +8.26753000E-03
   +2.35973000E-03  +7.10906000E-03  -4.33772400E-02  -7.70910000E-03  -2.51190600E-02
   -1.84879660E-01  +6.08912700E-02  -1.36587590E-01  +2.63991500E-02  +5.14130000E-04
   +1.75665300E-02  +2.23870000E-04  -6.27640000E-04  +9.34300000E-05  -6.62090000E-04
   +1.23000000E-04  -5.55360000E-04  +1.19314800E-02  +9.60160000E-03  +8.55910000E-04
   +3.31670800E-02  -2.01347500E-02  -8.11770000E-03  -9.63720000E-04  -2.19459000E-03
   +5.70140000E-04  +2.49780000E-04  +1.64210000E-04  +6.01830000E-04  -2.06140000E-04
   -4.93230000E-04  +8.47100000E-05  +1.01050000E-04  +7.92900000E-05  -1.23000000E-06
   -7.21700000E-05  +1.04460000E-04  +7.53700000E-05  +8.00300000E-05  -7.53800000E-05
   -1.05590000E-04  -7.75900000E-05  -1.85120000E-04  +2.09110000E-04  +1.98960000E-04
   -5.90900000E-05  -5.04000000E-06  +1.69570310E-01  -4.45465400E-02  +1.67684010E-01
   -1.07500000E-05  +1.09130000E-04  -1.10000000E-06  -7.53000000E-06  -1.63600000E-05
   -2.76500000E-05  +4.01400000E-05  -5.77000000E-05  -2.29300000E-05  -1.41970000E-04
   +1.09980000E-04  +2.23400000E-05  +4.23200000E-05  +3.37900000E-05  +2.91100000E-05
   +2.45000000E-06  -2.33700000E-05  -4.83200000E-05  -1.31500000E-05  +7.30000000E-06
   -1.03000000E-06  +1.84200000E-05  -7.27000000E-06  +1.01600000E-05  +1.73930000E-04
   -1.15690000E-04  -8.50000000E-06  -5.03000000E-06  -7.59000000E-06  +1.00000000E-08
   -2.10100000E-05  +1.33800000E-05  +5.81400000E-05  -2.85780000E-04  +3.73000000E-06
   +1.76140000E-04  -1.48690000E-04  +3.77040000E-04  -8.63320000E-04  +1.69580000E-04
   +7.08000000E-05  -7.93000000E-05  +8.19700000E-05  +1.54600000E-05  +2.25600000E-05
   -1.34876000E-03  -6.45330000E-04  -1.01486000E-03  +3.28580000E-04  -4.35972000E-03
   +2.00880000E-03  -4.75871600E-02  -2.47978000E-03  -3.59864300E-02  -4.56874000E-03
   -2.99160000E-04  +1.12770000E-03  -3.35950000E-04  +2.37960000E-04  -1.01336000E-03
   -2.56670000E-04  -4.75100000E-05  +2.68230000E-04  +9.97000000E-05  +7.10900000E-05
   +4.84100000E-05  -1.49573170E-01  +4.70411900E-02  -1.49478450E-01  +2.20086000E-03
   +6.34860000E-04  +9.82270000E-04  +3.22060000E-04  +1.60720000E-04  +3.60300000E-05
   -8.20000000E-06  -1.35700000E-05  +5.41000000E-06  +5.01500000E-05  +6.49600000E-05
   +6.06900000E-05  -8.23000000E-06  -3.65900000E-05  -2.30700000E-05  -2.86400000E-05
   -7.27000000E-06  +1.79900000E-05  -6.46000000E-06  -3.45200000E-05  +5.53000000E-06
   +4.29300000E-05  +2.97100000E-05  -7.60000000E-06  -3.38200000E-05  +1.26500000E-05
   -2.28000000E-06  -5.44719000E-03  +1.36563000E-03  -2.73710000E-03  +2.06263810E-01
   +5.30800000E-05  +1.34820000E-04  +1.49700000E-05  -5.72600000E-05  -7.40000000E-07
   -7.63000000E-05  +4.47200000E-05  -9.02400000E-05  -4.61600000E-05  -1.41760000E-04
   +1.43130000E-04  +5.82200000E-05  +5.63000000E-06  +3.03400000E-05  +3.05200000E-05
   +3.28800000E-05  +2.89900000E-05  -5.48000000E-06  -1.98900000E-05  +8.40000000E-07
   -2.55000000E-06  +1.78700000E-05  -6.73000000E-06  +7.52000000E-06  +1.86720000E-04
   -1.44910000E-04  -1.46500000E-05  +1.11400000E-05  -6.61000000E-06  -1.07100000E-05
   -1.87500000E-05  +2.58000000E-05  +2.60400000E-05  +1.46140000E-04  -2.47500000E-04
   -3.81300000E-05  +1.22185000E-03  -2.36598000E-03  +3.77350000E-03  -1.14900000E-05
   -8.28000000E-06  +3.24900000E-05  +5.67600000E-05  +4.37500000E-05  -3.76300000E-05
   +2.16437000E-03  +4.18680000E-03  -1.47399000E-03  -8.83793000E-03  -3.16594000E-03
   -6.31400000E-05  -9.70532000E-03  +1.65229200E-02  -2.11425000E-02  -4.06275000E-03
   -1.30555200E-02  -7.00895000E-03  -2.48066000E-03  +2.71880000E-04  -7.64500000E-05
   -2.15180000E-04  -2.69650000E-04  -9.22900000E-05  +2.31270000E-04  -2.38620000E-04
   +7.25600000E-05  +6.11069700E-02  -7.90563700E-02  +1.10493140E-01  -8.90866000E-03
   -3.03937000E-03  -5.87455000E-03  -1.88380000E-04  -1.30650000E-04  -1.32340000E-04
   -3.15900000E-05  -1.91100000E-05  -6.78200000E-05  +1.27800000E-05  +4.65500000E-05
   -6.10400000E-05  -1.41400000E-05  -1.87700000E-05  +1.74000000E-06  -3.18400000E-05
   +2.19100000E-05  +1.26000000E-05  +1.31000000E-06  -6.37300000E-05  -1.94000000E-06
   +4.31500000E-05  +1.61500000E-05  +3.21000000E-06  -3.06600000E-05  +1.89100000E-05
   -6.31000000E-06  +1.16275300E-02  +1.62598600E-02  -8.30290000E-04  -4.22079300E-02
   +6.41760600E-02  -1.35670000E-04  -9.60700000E-05  -2.61000000E-05  +6.76700000E-05
   -2.94400000E-05  +5.32500000E-05  -3.27900000E-05  +6.01600000E-05  +1.80500000E-05
   +5.21400000E-05  -7.11600000E-05  -4.10300000E-05  +2.58100000E-05  -2.33500000E-05
   -2.54000000E-06  -1.45400000E-05  -2.78600000E-05  +2.54800000E-05  -8.40000000E-07
   -3.08000000E-06  -4.45000000E-06  -7.96000000E-06  +1.61000000E-06  -3.62000000E-06
   -7.50100000E-05  +5.60300000E-05  +1.44000000E-06  +7.25000000E-06  -1.97000000E-06
   +3.52000000E-06  +1.50000000E-06  +2.35200000E-05  +1.40000000E-06  -3.43280000E-04
   +2.84040000E-04  +1.49690000E-04  -1.92284000E-03  +3.03259000E-03  -4.56595000E-03
   +9.86400000E-05  +5.51500000E-05  -6.81500000E-05  -1.80000000E-07  -1.97600000E-05
   +5.19000000E-05  -3.93626000E-03  -3.81670000E-03  +2.58193000E-03  +8.22181000E-03
   +3.80771000E-03  +4.22245000E-03  -2.68687800E-02  -1.63331100E-02  +8.80600000E-04
   -1.39480000E-03  +1.45000800E-02  +5.59104000E-03  +3.15874000E-03  -3.29780000E-04
   -1.94484000E-03  +2.64100000E-04  -8.89200000E-05  -1.16700000E-05  -3.94900000E-05
   +1.83800000E-05  -3.33640000E-04  -1.65948980E-01  +9.94252400E-02  -2.58741450E-01
   +8.80235000E-03  -7.61200000E-04  +9.41721000E-03  +6.62180000E-04  +1.59580000E-04
   +5.14000000E-06  +1.45500000E-05  +1.64600000E-05  +6.17200000E-05  +1.55900000E-05
   -5.37000000E-06  +7.79400000E-05  +1.41700000E-05  -2.24200000E-05  -8.47000000E-06
   +7.93000000E-06  -1.65200000E-05  +2.32000000E-06  +2.18000000E-06  +1.42500000E-05
   +1.84900000E-05  -1.32300000E-05  +1.26500000E-05  -5.20000000E-07  +1.24600000E-05
   -8.04000000E-06  +6.20000000E-06  -7.13018000E-03  -2.23494300E-02  -1.01379800E-02
   +1.86435750E-01  -7.74632600E-02  +2.52720630E-01
end_hess

