# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -1035.04020540   # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +6.00178360E+00  +1.78430697E+00  +1.57985166E+00
   006   +4.17290196E+00  -5.56237384E-02  +1.16670536E+00
   006   +4.85888927E+00  -2.14798566E+00  -2.72555880E-01
   006   +7.26583760E+00  -2.40714645E+00  -1.25827791E+00
   006   +9.06784531E+00  -5.48921218E-01  -8.13635914E-01
   006   +8.42314022E+00  +1.55195694E+00  +6.12704015E-01
   006   +1.48931489E+00  +1.09392765E-01  +2.24456413E+00
   006   +1.16516718E+00  -1.98112169E+00  +4.22597844E+00
   008   +1.14597626E+01  -6.90564330E-01  -1.72606539E+00
   006   -3.61410474E-01  -1.29592085E-01  +4.18576501E-02
   006   -1.57997261E-01  +1.85676123E+00  -1.89605705E+00
   006   -2.04233421E+00  +3.37284716E+00  -2.60338977E+00
   006   -4.67041926E+00  +3.41922823E+00  -1.48595155E+00
   008   -5.33851412E+00  +5.40086146E+00  -5.14914532E-01
   006   +9.51811146E-01  +2.65467492E+00  +3.53801772E+00
   006   -2.11432325E+00  -1.96199025E+00  -8.37564125E-02
   006   -3.71707989E+00  -2.33659248E+00  -2.26792646E+00
   008   -5.46153003E+00  -3.91045743E+00  -2.33236239E+00
   008   -5.95092443E+00  +1.37045548E+00  -1.63858971E+00
   008   -9.22955183E+00  +1.97716274E-01  +1.54101099E+00
   001   +1.16648316E+01  -2.21379552E+00  -2.67859978E+00
   001   +7.74142856E+00  -4.05505998E+00  -2.37829614E+00
   001   +3.47862321E+00  -3.61050002E+00  -6.55656628E-01
   001   +5.55605032E+00  +3.45094935E+00  +2.67209454E+00
   001   +9.82871580E+00  +2.99650577E+00  +9.47938922E-01
   001   +2.57766257E+00  -1.72913499E+00  +5.70249428E+00
   001   -6.96523779E-01  -1.89038996E+00  +5.10850787E+00
   001   +1.43080976E+00  -3.86042979E+00  +3.42598609E+00
   001   +1.26889901E+00  +4.24990576E+00  +2.27929459E+00
   001   -1.01821246E+00  +2.72545969E+00  +4.13559873E+00
   001   +2.13702219E+00  +2.87695718E+00  +5.20846272E+00
   001   -2.33698270E+00  -3.31543116E+00  +1.43159523E+00
   001   -3.14461552E+00  -1.47165078E+00  -4.04508278E+00
   001   -1.62603859E+00  +4.92778083E+00  -3.86907116E+00
   001   +1.73608145E+00  +2.24230132E+00  -2.57760722E+00
   001   -7.98836104E+00  +9.56102249E-01  +2.37253409E-01
   001   -1.08969160E+01  +7.28916950E-01  +1.09434477E+00
   001   -8.72222845E+00  -2.29124168E+00  +1.50863506E+00
   008   -8.05172166E+00  -4.23403658E+00  +1.35605182E+00
   001   -6.66615869E+00  -4.24783900E+00  -3.26437615E-01
   001   -7.25390581E+00  -4.72027477E+00  +2.90455746E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +1.30000000E-07  -9.00000000E-08  -4.00000000E-07
   +1.20000000E-07  +7.00000000E-08  -7.00000000E-08
   -1.00000000E-08  -2.90000000E-07  -2.80000000E-07
   -3.00000000E-08  -3.20000000E-07  -3.50000000E-07
   +4.00000000E-08  -4.40000000E-07  -5.70000000E-07
   -1.00000000E-08  -3.30000000E-07  -5.60000000E-07
   +1.50000000E-07  -1.00000000E-07  -2.30000000E-07
   +1.30000000E-07  +1.30000000E-07  +8.00000000E-08
   -2.50000000E-07  -6.00000000E-07  -6.50000000E-07
   -3.70000000E-07  -1.00000000E-08  +2.10000000E-07
   -7.00000000E-08  -2.20000000E-07  -1.30000000E-07
   -8.00000000E-08  +1.70000000E-07  -8.00000000E-08
   +2.30000000E-07  +8.50000000E-07  +2.10000000E-07
   +2.90000000E-07  -2.00000000E-08  +1.00000000E-08
   +2.30000000E-07  +1.40000000E-07  -1.80000000E-07
   -1.70000000E-07  +1.40000000E-07  +2.90000000E-07
   -1.20000000E-07  +1.30000000E-07  +2.70000000E-07
   -1.70000000E-07  -1.00000000E-07  +2.90000000E-07
   -2.00000000E-07  -4.60000000E-07  +4.80000000E-07
   +1.40000000E-07  +6.10000000E-07  +1.17000000E-06
   -2.80000000E-07  -4.70000000E-07  -5.40000000E-07
   -3.40000000E-07  -3.60000000E-07  -2.60000000E-07
   -3.30000000E-07  -3.00000000E-07  -9.00000000E-08
   +2.40000000E-07  -1.70000000E-07  -4.60000000E-07
   +1.60000000E-07  -3.50000000E-07  -6.70000000E-07
   +2.50000000E-07  +1.00000000E-07  -9.00000000E-08
   +2.40000000E-07  +2.10000000E-07  +8.00000000E-08
   +4.00000000E-08  +0.00000000E+00  +5.00000000E-08
   +3.20000000E-07  +2.00000000E-08  -2.50000000E-07
   +3.60000000E-07  +1.30000000E-07  -4.00000000E-08
   +3.90000000E-07  +1.00000000E-07  -2.60000000E-07
   -9.00000000E-08  +1.20000000E-07  +3.10000000E-07
   -3.90000000E-07  -3.00000000E-08  +1.20000000E-07
   -6.00000000E-08  -1.00000000E-07  +3.00000000E-08
   +9.00000000E-08  -7.00000000E-08  -1.80000000E-07
   -2.70000000E-07  +3.00000000E-08  -7.00000000E-08
   +1.20000000E-07  +4.60000000E-07  +4.70000000E-07
   +2.90000000E-07  -2.60000000E-07  +4.20000000E-07
   +1.80000000E-07  +7.70000000E-07  +5.20000000E-07
   -6.80000000E-07  +4.30000000E-07  +8.10000000E-07
   -2.40000000E-07  +4.50000000E-07  +6.20000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.44586600E-01  +5.48646400E-02  +6.04504780E-01  -1.40885470E-01  +2.41646400E-01
   +3.29796800E-01  -2.17839350E-01  -1.32178930E-01  -2.32426900E-02  +5.93689110E-01
   -7.37257800E-02  -2.13663720E-01  -5.74502300E-02  +8.19153500E-02  +5.64495510E-01
   +1.03310900E-02  -3.77184800E-02  -9.17854200E-02  -9.61777300E-02  +1.87856850E-01
   +3.25530920E-01  +5.48571200E-02  +6.13990000E-04  -1.52471800E-02  -1.35060200E-01
   -4.49030000E-04  +2.26655600E-02  +6.83001480E-01  -4.49720800E-02  -4.59504700E-02
   -1.59685300E-02  +5.85145100E-02  -2.37058400E-01  -1.15736260E-01  +1.03571140E-01
   +5.78799790E-01  -4.13730800E-02  -3.13081500E-02  +4.70738000E-03  +5.61194300E-02
   -9.67066500E-02  -1.45110990E-01  -1.25519150E-01  +2.15838700E-01  +3.13329150E-01
   -6.48486500E-02  -2.59099600E-02  +6.08553000E-03  +3.99955000E-03  +7.65563800E-02
   +4.47990000E-02  -3.16071930E-01  -1.86191000E-02  +7.87242700E-02  +6.55941200E-01
   -2.19582800E-02  -1.21665500E-02  +2.50639000E-03  +2.93633500E-02  +2.20253200E-02
   -2.80384000E-03  +4.05526700E-02  -1.15689110E-01  -4.61505200E-02  +5.74550600E-02
   +5.90397740E-01  +8.59470000E-03  +3.97019000E-03  -4.35502000E-03  +1.81599600E-02
   -1.82843800E-02  -8.51531000E-03  +1.12480940E-01  -2.59720200E-02  -1.13844480E-01
   -1.50951370E-01  +2.48273190E-01  +3.22106780E-01  +6.80526000E-03  +3.50667200E-02
   +1.85861400E-02  -6.65790000E-04  -1.87641500E-02  -1.21601900E-02  -4.89531600E-02
   -1.13684800E-02  +1.11376600E-02  -2.02922090E-01  -1.31737930E-01  -2.95571700E-02
   +6.64166300E-01  +8.51260800E-02  +2.64777100E-02  -1.53500900E-02  -1.74897200E-02
   -7.02920600E-02  -3.06209100E-02  -6.15215800E-02  +4.61585800E-02  +4.60318800E-02
   -6.10594700E-02  -2.25083080E-01  -6.86943500E-02  +6.66599000E-02  +5.98758290E-01
   +4.70545100E-02  +1.99888000E-03  -1.31934200E-02  -1.16751400E-02  -3.05018400E-02
   -1.94688800E-02  -1.75843400E-02  +2.90789200E-02  +2.51217200E-02  +1.11516700E-02
   -4.40277500E-02  -9.86627700E-02  -1.35034770E-01  +2.26621210E-01  +3.41159510E-01
   -3.15272880E-01  +3.78050400E-02  +1.09082090E-01  -4.56277400E-02  -5.62476100E-02
   -1.40647300E-02  -3.41431000E-02  +2.74694200E-02  +2.62477900E-02  +5.38325500E-02
   +1.10046000E-03  -1.51792600E-02  -1.28995150E-01  -1.61365100E-02  +1.07986100E-02
   +6.93875290E-01  -2.19295000E-02  -1.18084150E-01  -2.47968300E-02  -1.17882700E-02
   +4.01804700E-02  +2.30724100E-02  +2.43984600E-02  -2.34908200E-02  -2.00234100E-02
   -3.89035000E-02  -3.70760300E-02  -1.25343400E-02  +5.07734400E-02  -2.55484860E-01
   -1.23075850E-01  +1.08600250E-01  +5.92863710E-01  +7.51303700E-02  -4.55478900E-02
   -1.13118460E-01  +1.16181200E-02  +3.81816800E-02  +2.55335100E-02  +2.45512100E-02
   -2.09982000E-02  -2.34986100E-02  -3.78640500E-02  -2.63750400E-02  +6.40638000E-03
   +4.90434000E-02  -9.98806800E-02  -1.45854570E-01  -1.33019150E-01  +2.26509420E-01
   +3.05990500E-01  -2.13495700E-02  -2.78790000E-04  +7.78187000E-03  -1.56659370E-01
   -1.36020000E-03  +2.74903100E-02  -1.09649800E-02  +7.31943000E-03  +8.42206000E-03
   +4.27204000E-03  -2.81740000E-04  +7.90710000E-04  -1.98904000E-03  -1.39877000E-03
   -5.34200000E-04  +5.47820000E-04  -3.15884000E-03  +8.29730000E-04  +4.58947190E-01
   -1.68131200E-02  +6.49118000E-03  +9.29557000E-03  +3.84938000E-03  -8.32439600E-02
   -9.83006000E-03  +2.50862700E-02  +2.73009000E-03  -8.35118000E-03  -1.62900000E-05
   -3.14036000E-03  -4.76133000E-03  +1.24900000E-04  -1.58272000E-03  -6.21470000E-04
   -3.38867000E-03  -9.29750000E-04  -3.13851000E-03  -4.29700000E-04  +4.84405970E-01
   -2.53251000E-03  +2.89393000E-03  +5.68234000E-03  +3.62472600E-02  -7.60764000E-03
   -8.58087400E-02  +1.73708200E-02  -1.80532000E-03  -6.54063000E-03  +5.76340000E-04
   -4.06106000E-03  +2.91125000E-03  +1.52550000E-04  -1.64860000E-04  -6.10130000E-04
   -1.92600000E-05  -3.98249000E-03  +4.35455000E-03  -1.63174000E-03  -8.15198000E-03
   +4.77260230E-01  -8.11250000E-04  +1.38820000E-03  +1.88682000E-03  -1.04290700E-02
   -2.36029800E-02  +2.35606200E-02  -6.73120000E-04  -1.00309000E-03  +1.02826000E-03
   +2.49200000E-05  -3.13020000E-04  -7.64970000E-04  +8.16700000E-04  -7.16410000E-04
   -6.05470000E-04  -1.53206000E-03  +1.15360000E-03  -6.76360000E-04  -7.59521400E-02
   -1.07958400E-02  +1.02183000E-02  +5.85528870E-01  +6.61380000E-04  -2.22480000E-04
   -1.33410000E-04  -7.13360000E-03  +1.22520000E-04  +3.42091000E-03  +1.83946000E-03
   -9.77500000E-05  -5.63150000E-04  -1.40360000E-04  -1.76360000E-04  -3.05400000E-05
   -3.13190000E-04  +3.44170000E-04  +1.06820000E-04  +1.96160000E-04  -2.61910000E-04
   -1.75350000E-04  -6.71375000E-03  -1.28692820E-01  +4.81124100E-02  -8.36011000E-03
   +5.32122410E-01  -1.41273000E-03  -5.85070000E-04  -8.37490000E-04  +1.08339400E-02
   +9.81439000E-03  -1.30462100E-02  +1.72590000E-04  +7.73150000E-04  -1.81250000E-04
   -2.41270000E-04  +1.36550000E-04  +5.03560000E-04  -1.97400000E-05  +4.07100000E-04
   +2.36410000E-04  +4.49870000E-04  -5.64460000E-04  +6.96000000E-06  +5.37177000E-03
   +4.97510100E-02  -1.21802120E-01  +9.53372000E-03  +6.31790800E-02  +5.23789900E-01
   +2.84107000E-03  -2.14715000E-03  -6.63580000E-04  -3.85605000E-03  +1.81550000E-03
   +1.33409000E-03  +3.32919000E-03  -4.99290000E-03  -1.46675000E-03  -4.84284500E-02
   -2.93340000E-04  +2.00733700E-02  -2.86512690E-01  -2.37318700E-02  +7.04207700E-02
   -2.13551400E-02  +1.28679600E-02  +1.74621600E-02  +1.50685000E-03  -7.37000000E-04
   -4.01090000E-04  -1.47256000E-03  +6.32900000E-04  +1.42570000E-04  +3.98031920E-01
   -8.47719000E-03  -5.99911000E-03  -3.39846000E-03  +2.11787000E-03  +5.62050000E-03
   +3.27650000E-03  +2.30609000E-03  -5.52020000E-03  -8.19520000E-03  -3.38213700E-02
   +8.01483000E-03  +1.06866500E-02  +2.00870200E-02  -9.59470500E-02  -3.68518100E-02
   +4.58285400E-02  -3.94900000E-04  -2.05155200E-02  +1.14060000E-04  +3.12720000E-04
   +3.95200000E-04  +2.71210000E-04  -1.58890000E-04  -7.11700000E-05  -3.72738900E-02
   +4.82796690E-01  -4.05274000E-03  -5.63862000E-03  +3.39620000E-03  +2.05661000E-03
   +3.26677000E-03  +1.44160000E-04  +2.75310000E-03  -5.63424000E-03  +3.16144000E-03
   +7.90930000E-04  -1.01345000E-03  +9.05304000E-03  +9.58437000E-02  -2.16560900E-02
   -8.99040700E-02  +3.63563400E-02  -9.02562000E-03  -1.01682600E-02  -6.58820000E-04
   +7.57790000E-04  -2.54380000E-04  +6.73040000E-04  -2.67220000E-04  -9.36800000E-05
   -1.50270020E-01  +2.76342470E-01  +2.39148830E-01  -2.35608000E-03  +1.15284000E-03
   +9.83240000E-04  -3.51689600E-02  -5.71044000E-03  -1.81108000E-02  -1.30050000E-04
   +8.45130000E-04  -1.95690000E-04  -1.25230000E-04  -9.28650000E-04  -1.95830000E-04
   -6.08880000E-04  +5.05300000E-04  +5.05930000E-04  +3.26760000E-04  -1.16283000E-03
   +3.89620000E-04  -1.12771590E-01  -4.77420000E-04  -4.50307100E-02  +2.59157000E-03
   +4.00702000E-03  -1.89398000E-03  +7.91150000E-04  -1.40030000E-04  -3.97840000E-04
   +5.20111190E-01  -2.29300000E-04  -6.78260000E-04  +5.61130000E-04  -2.46728000E-03
   -1.20482000E-03  +5.96920000E-04  +2.00029000E-03  +1.22769000E-03  +3.09700000E-04
   +2.80370000E-04  -1.29320000E-04  -1.75070000E-04  -7.24550000E-04  -2.17800000E-05
   +2.69160000E-04  -1.49080000E-04  -3.99190000E-04  -6.35500000E-05  -1.20592100E-02
   -7.71700200E-02  -8.80370000E-04  +1.69699400E-02  +3.06725000E-03  +1.97099400E-02
   +8.14460000E-04  -1.74350000E-04  -3.70990000E-04  +2.43434200E-01  +5.61098250E-01
   +2.35990000E-03  -9.88360000E-04  -1.71094000E-03  -1.44769000E-03  +1.66678000E-03
   +1.29376200E-02  +2.15464000E-03  -4.04910000E-04  -2.91650000E-04  +4.41910000E-04
   +1.53540000E-04  -6.48480000E-04  -1.01491000E-03  +2.48950000E-04  +6.93230000E-04
   +6.43470000E-04  +4.69860000E-04  -9.34260000E-04  -3.54265600E-02  +6.13515000E-03
   -1.32883810E-01  -1.66980800E-02  +4.75730000E-04  -2.36194000E-02  +1.55313000E-03
   -2.56680000E-04  -6.94220000E-04  +8.52328600E-02  -9.17921200E-02  +4.20513300E-01
   +5.48000000E-05  +9.00900000E-05  +3.75100000E-05  +8.77870000E-04  +1.04328000E-03
   -2.10012000E-03  -1.71800000E-04  +6.62000000E-05  +5.61900000E-05  -3.39500000E-05
   +3.41200000E-05  +1.38250000E-04  +6.83000000E-06  -6.98900000E-05  -9.42500000E-05
   -2.01480000E-04  -6.34700000E-05  +1.88700000E-04  +4.09791000E-03  +1.58715300E-02
   -1.58614400E-02  -3.19416000E-03  -1.81859000E-03  -3.73231000E-03  -1.29210000E-04
   -3.74000000E-06  +9.81600000E-05  -1.03486080E-01  -1.88319000E-02  +1.25654600E-02
   +7.50909650E-01  -8.01390000E-04  -6.14910000E-04  +6.52100000E-05  +1.58700000E-03
   -7.24100000E-05  +1.86239000E-03  +6.44390000E-04  -6.46500000E-05  +8.28390000E-04
   -6.03760000E-04  -2.78800000E-05  +1.67100000E-04  -8.35400000E-05  +4.64690000E-04
   +2.65110000E-04  +4.06060000E-04  -2.03010000E-04  -3.50310000E-04  +9.33145000E-03
   +2.41281000E-03  +2.85226000E-03  -1.81757000E-03  -7.68100000E-05  -9.21960000E-04
   +1.75190000E-04  -5.80300000E-05  -7.69400000E-05  -1.09512600E-02  -1.44551910E-01
   +7.41026400E-02  -1.38692570E-01  +4.62853660E-01  +1.38950000E-04  +5.87920000E-04
   -1.99600000E-04  -1.34999000E-03  +1.26490000E-03  -1.54999000E-03  +1.31800000E-04
   -4.47930000E-04  -8.30550000E-04  -2.15310000E-04  -1.51260000E-04  +1.71710000E-04
   +4.55230000E-04  +3.30300000E-05  -3.86500000E-05  +1.57890000E-04  +1.36850000E-04
   -1.10100000E-05  -7.28896000E-03  +1.86734900E-02  -1.82965900E-02  -3.01599000E-03
   -9.90790000E-04  -1.30139000E-03  -4.98860000E-04  +8.03600000E-05  +2.16630000E-04
   +4.04923000E-03  +7.12504500E-02  -1.52102880E-01  -1.57100000E-03  -2.32084790E-01
   +3.52460650E-01  +2.71370000E-04  +2.50880000E-04  -1.75960000E-04  -6.93810000E-04
   +4.77910000E-04  +1.41840000E-04  +2.98200000E-05  -1.90980000E-04  -5.01560000E-04
   +4.75200000E-05  -5.81900000E-05  -5.39400000E-05  +1.87260000E-04  -2.50000000E-05
   +2.84000000E-05  +1.40930000E-04  +9.95600000E-05  -5.61100000E-05  +1.49261000E-03
   -2.44997000E-03  +1.49214000E-03  +6.33230000E-04  +7.55800000E-05  +4.98780000E-04
   -1.34860000E-04  +3.87500000E-05  +2.85900000E-05  +1.33020200E-02  +1.31168600E-02
   -6.89202000E-03  -3.50626080E-01  +1.79315440E-01  -7.34643000E-02  +6.33336850E-01
   +1.11780000E-04  +1.42690000E-04  -1.00770000E-04  -6.83140000E-04  +1.96410000E-04
   -1.93130000E-04  +3.08400000E-05  -1.40540000E-04  -2.92800000E-04  -9.59500000E-05
   -5.28000000E-05  -1.60100000E-05  +3.17330000E-04  +1.08600000E-05  -6.55300000E-05
   +6.20500000E-05  +9.06800000E-05  +2.41000000E-06  -2.65872000E-03  -2.09939000E-03
   +4.37920000E-04  +5.46020000E-04  +4.70310000E-04  +5.13220000E-04  -3.08520000E-04
   +4.01300000E-05  +1.28300000E-04  +1.93717200E-02  -1.49147900E-02  +1.46740900E-02
   +2.08346040E-01  -2.43020870E-01  +1.01510500E-01  -1.64240860E-01  +5.68225500E-01
   -1.90570000E-04  -2.02780000E-04  +1.13470000E-04  +8.89690000E-04  -1.56610000E-04
   +2.69660000E-04  +9.83500000E-05  +2.70000000E-05  +2.56390000E-04  -1.27900000E-04
   -1.56700000E-05  +8.76700000E-05  -6.69800000E-05  +8.97300000E-05  +2.44800000E-05
   +1.12600000E-05  -5.13400000E-05  -4.34200000E-05  +2.13417000E-03  +2.16034000E-03
   -1.94977000E-03  -7.44730000E-04  -3.62200000E-04  -8.14980000E-04  +5.56200000E-05
   -1.53800000E-05  -1.35000000E-05  -1.59076900E-02  +2.08952300E-02  -1.06873900E-02
   -8.28980300E-02  +9.38959400E-02  -1.03384810E-01  -2.64466700E-02  -2.47323970E-01
   +3.45406140E-01  +2.52000000E-06  -2.23760000E-04  +8.95500000E-05  -1.38610000E-04
   +1.50300000E-05  -8.68200000E-05  -1.31050000E-04  +1.70090000E-04  +3.55970000E-04
   +2.10330000E-04  +1.25190000E-04  +6.37300000E-05  -7.59410000E-04  -1.10200000E-05
   +1.52000000E-04  -1.28410000E-04  -1.82920000E-04  +1.15890000E-04  -3.45120000E-04
   -2.03851000E-03  -3.95190000E-04  +7.13490000E-04  -5.72000000E-06  +4.95620000E-04
   +7.24660000E-04  -1.22060000E-04  -2.32480000E-04  +3.35764000E-03  +9.17880000E-03
   -7.36504000E-03  -9.67744000E-03  +6.88188000E-03  +4.08113000E-03  -1.66572060E-01
   -5.41850000E-03  +3.04861500E-02  +5.45331850E-01  +1.12930000E-04  +3.69310000E-04
   +1.88160000E-04  -1.06240000E-04  -5.06980000E-04  -9.77690000E-04  -2.16750000E-04
   +3.88560000E-04  +1.59660000E-04  +1.11840000E-04  -1.95930000E-04  -2.10810000E-04
   +2.19960000E-04  -2.28700000E-04  -2.40720000E-04  -4.25150000E-04  -3.11700000E-05
   +3.11830000E-04  +1.16214000E-03  -1.06244000E-03  +7.78940000E-04  -1.63680000E-04
   -4.69390000E-04  -2.83850000E-04  -4.13310000E-04  -1.69200000E-05  +1.75340000E-04
   +5.21568000E-03  +8.75937000E-03  -6.06974000E-03  +2.51498900E-02  +2.34872000E-03
   -6.68049000E-03  -9.53441000E-03  -7.40505700E-02  +1.54711400E-02  +1.29922000E-03
   +8.74187670E-01  +2.29840000E-04  +3.33770000E-04  -3.19400000E-05  -2.61240000E-04
   -1.69700000E-04  -4.49900000E-04  -1.14910000E-04  +9.84300000E-05  -2.11180000E-04
   +1.15570000E-04  -1.02470000E-04  -1.66940000E-04  +3.13280000E-04  -1.77330000E-04
   -1.59130000E-04  -1.64550000E-04  +7.97900000E-05  +1.32810000E-04  +4.09130000E-04
   +1.04654000E-03  +2.07330000E-04  -4.90770000E-04  -2.62760000E-04  -3.35700000E-04
   -3.80280000E-04  +4.23800000E-05  +1.28750000E-04  -2.94400000E-03  -4.53829000E-03
   -1.88442000E-03  -1.10408000E-02  -4.98869000E-03  +1.08698400E-02  +3.11130300E-02
   +2.49151700E-02  -1.04872490E-01  -1.36238910E-01  +1.89398100E-01  +3.59645690E-01
   +3.93100000E-05  +2.22070000E-04  -2.50900000E-05  +7.89200000E-05  -2.21600000E-05
   -2.03390000E-04  +4.35900000E-05  -7.55800000E-05  -1.99140000E-04  -1.50890000E-04
   -1.23620000E-04  -6.61000000E-05  +6.04170000E-04  -4.61100000E-05  -1.81740000E-04
   -1.66000000E-05  +1.31800000E-04  +1.50500000E-05  +2.07770000E-04  +8.50430000E-04
   +2.96550000E-04  -4.46620000E-04  -5.63600000E-05  -2.48120000E-04  -6.35410000E-04
   +8.40600000E-05  +2.32920000E-04  -1.21785000E-03  -3.17216000E-03  +4.05784000E-03
   -6.27761000E-03  -1.15848000E-03  +2.34866000E-03  -1.42042400E-02  +3.67117200E-02
   +2.90256200E-02  -1.57691260E-01  +1.57151080E-01  +9.30305700E-02  +1.43960790E-01
   -8.56800000E-05  -3.45690000E-04  -9.00700000E-05  -1.62800000E-05  +2.05160000E-04
   +5.87940000E-04  +4.95800000E-05  -1.40150000E-04  +5.85200000E-05  +5.29900000E-05
   +1.90550000E-04  +1.42220000E-04  -4.73760000E-04  +1.13020000E-04  +2.11780000E-04
   +2.05710000E-04  -4.75200000E-05  -1.57880000E-04  -9.20950000E-04  +7.22340000E-04
   -5.16470000E-04  +1.97770000E-04  +2.85130000E-04  +2.26840000E-04  +5.86270000E-04
   -2.99600000E-05  -2.29530000E-04  -2.99375000E-03  -5.77991000E-03  +3.92330000E-04
   -9.69400000E-05  +6.11913000E-03  -2.82437000E-03  +2.18302800E-02  -1.55350300E-02
   -1.91736300E-02  +1.56173390E-01  -4.89383270E-01  -2.05054010E-01  -1.64854720E-01
   +6.01738700E-01  -9.00500000E-05  -2.74890000E-04  -2.80700000E-05  +8.36800000E-05
   +2.09850000E-04  +3.66110000E-04  -2.73000000E-05  -8.26400000E-05  +1.22520000E-04
   -1.91800000E-05  +1.11560000E-04  +1.16790000E-04  -2.22920000E-04  +7.11900000E-05
   +8.41800000E-05  +9.33300000E-05  -9.78000000E-06  -3.62200000E-05  -5.53940000E-04
   -2.59200000E-04  -3.22950000E-04  +3.07620000E-04  +2.44030000E-04  +2.61060000E-04
   +2.56630000E-04  -1.88000000E-05  -7.42300000E-05  -6.48750000E-04  -1.23494000E-03
   -7.67670000E-04  +5.50102000E-03  +3.62505000E-03  -2.84837000E-03  +2.40325300E-02
   -3.15154500E-02  +3.93342000E-03  +9.08451100E-02  -2.01048000E-01  -1.89020910E-01
   -1.07796880E-01  +2.66088330E-01  +1.67205180E-01  -1.53520000E-03  +4.04190000E-04
   +6.00330000E-04  -7.52923000E-03  +3.03950200E-02  +1.64131300E-02  -5.93350000E-03
   -1.27374000E-03  +1.33223000E-03  -3.75200000E-05  +1.26540000E-03  +1.02519000E-03
   +4.01400000E-04  -1.10400000E-05  -8.04000000E-05  +2.72100000E-04  +1.02635000E-03
   +3.97540000E-04  -7.74819900E-02  +1.08160700E-02  +4.26923000E-03  +1.11465000E-03
   -2.87401000E-03  -1.99467000E-03  -5.89910000E-04  +6.76800000E-05  +2.40270000E-04
   +4.40953000E-03  -1.87821200E-02  -9.44440000E-03  -8.73770000E-04  -5.29580000E-04
   -1.21708000E-03  +3.28400000E-04  -6.38830000E-04  -7.28400000E-04  +1.46530000E-04
   -1.12895000E-03  -8.29240000E-04  -1.68920000E-04  +7.12710000E-04  +8.44110000E-04
   +5.82088930E-01  -1.19869000E-03  +3.52000000E-04  +6.20520000E-04  +5.55396000E-03
   -2.21674000E-03  -1.91671000E-03  -1.01704000E-03  +1.21950000E-04  +3.40130000E-04
   -5.10930000E-04  +2.46600000E-05  +4.24000000E-06  +2.90750000E-04  +2.86090000E-04
   -3.17600000E-05  -2.45790000E-04  -3.35530000E-04  -6.32700000E-05  +1.78967400E-02
   -1.49222010E-01  -3.24574800E-02  +4.09994000E-03  -3.55778100E-02  -7.49475000E-03
   -3.54330000E-04  -1.66100000E-05  +1.25490000E-04  -7.78129000E-03  -7.38920000E-03
   -1.33676300E-02  +9.62500000E-05  +9.52600000E-05  +8.57250000E-04  -5.58690000E-04
   -4.92880000E-04  -3.77020000E-04  +9.45530000E-04  +7.24800000E-04  +1.65030000E-04
   -2.35900000E-04  -2.10120000E-04  -2.08800000E-05  +2.46984800E-02  +4.98480200E-01
   -3.44160000E-04  +4.28440000E-04  -5.11860000E-04  +6.09655000E-03  -1.13307600E-02
   -6.61424000E-03  +1.85989000E-03  +2.01360000E-04  +3.11030000E-04  -1.73220000E-04
   -5.06900000E-04  -1.28210000E-04  +2.18790000E-04  -6.89000000E-06  +1.98580000E-04
   -2.47290000E-04  -4.25140000E-04  -2.62760000E-04  +1.02551200E-02  -3.99876700E-02
   -9.58989900E-02  -3.06437000E-03  +2.01450300E-02  +9.24938000E-03  -1.25340000E-04
   +5.98000000E-06  +1.73900000E-05  +7.97800000E-04  -2.55597700E-02  -1.82120600E-02
   -1.75145000E-03  -7.36670000E-04  -2.07508000E-03  +3.41230000E-04  -7.11090000E-04
   -9.93100000E-05  -4.78800000E-04  -7.70270000E-04  +2.05820000E-04  +1.59310000E-04
   +5.69770000E-04  -8.77000000E-05  +1.35742800E-02  -5.63559700E-02  +5.63358320E-01
   -1.70600000E-04  +4.61760000E-04  +1.98310000E-04  +6.50290000E-04  +5.99360000E-04
   -1.36719000E-03  -5.92140000E-04  -3.00790000E-04  -2.67470000E-04  -2.04740000E-04
   -1.46780000E-04  -1.49190000E-04  +9.28040000E-04  -3.36270000E-04  -5.32600000E-04
   -3.81130000E-04  +2.22110000E-04  +4.22590000E-04  -8.61310000E-03  -2.13295800E-02
   -1.00410600E-02  -2.33175000E-03  -1.00806000E-03  +2.25780000E-04  -1.21696000E-03
   +1.57890000E-04  +5.75310000E-04  -2.57925110E-01  -1.94647190E-01  -3.23173000E-02
   +9.34823000E-03  -1.95413100E-02  +9.58159000E-03  -8.13765000E-03  +1.22249000E-03
   -3.63243000E-03  -1.25717900E-02  -1.13293900E-02  -9.25810000E-04  +3.91517000E-03
   +5.97630000E-03  +2.21780000E-03  -4.24099000E-03  +2.93485000E-03  -1.80016000E-03
   +4.68523430E-01  -2.75520000E-04  +9.04810000E-04  -3.88700000E-05  +1.36296000E-03
   -1.96070000E-04  -1.83339000E-03  +9.40800000E-05  -1.42688000E-03  -3.15800000E-04
   -8.20500000E-05  +2.59710000E-04  +3.82760000E-04  +6.47860000E-04  -2.64340000E-04
   -4.44270000E-04  -1.84440000E-04  +2.26400000E-04  +2.72520000E-04  -8.04052000E-03
   +1.68716000E-03  -3.09376000E-03  +3.22670000E-04  -1.05099000E-03  +1.14950000E-04
   -7.14440000E-04  +2.19300000E-04  +3.23790000E-04  -2.05684190E-01  -2.87183790E-01
   +7.01930000E-04  -1.82608400E-02  -2.15409100E-02  +7.60483000E-03  -2.87643000E-03
   +1.48039000E-03  -9.29420000E-04  -7.76102000E-03  -7.37178000E-03  +6.89430000E-04
   +3.00606000E-03  +2.05597000E-03  -6.00200000E-05  -7.52900000E-05  +1.49544000E-03
   +6.21530000E-04  +2.98057840E-01  +5.56946380E-01  -1.02994000E-03  +9.70540000E-04
   +6.17160000E-04  -4.80110000E-04  -1.09739000E-03  -5.27408000E-03  -2.12860000E-04
   -6.37310000E-04  -6.43000000E-06  -4.99830000E-04  -2.09040000E-04  +2.47330000E-04
   +1.22759000E-03  -2.50350000E-04  -6.28160000E-04  -4.58350000E-04  +7.98000000E-06
   +6.67890000E-04  -1.95859000E-02  -1.84866000E-02  +4.37614000E-03  -1.91764000E-03
   -2.12126000E-03  -1.25888000E-03  -1.58507000E-03  +2.58270000E-04  +7.02320000E-04
   -1.61825400E-02  +1.75341700E-02  -1.06806540E-01  +1.69875900E-02  +1.92450300E-02
   +6.03383000E-03  -7.91790000E-04  -1.48955000E-03  -9.81230000E-04  -4.35089000E-03
   -3.85495000E-03  +2.10020000E-04  +9.36430000E-04  +2.61071000E-03  +9.16980000E-04
   -3.40767000E-03  +1.49882000E-03  -2.66257000E-03  +1.21191320E-01  -1.58917070E-01
   +5.44473810E-01  +7.73000000E-06  -1.18753000E-03  -1.08730000E-04  +8.43370000E-04
   +4.82290000E-04  +3.07391000E-03  +6.27250000E-04  +8.54000000E-05  +1.98360000E-04
   +2.17300000E-04  +4.61580000E-04  +3.54650000E-04  -1.62654000E-03  +6.76080000E-04
   +9.81450000E-04  +8.45530000E-04  -3.55570000E-04  -7.90240000E-04  +4.49376000E-03
   -4.45770000E-03  -4.21106000E-03  +1.18888000E-03  +6.37470000E-04  +6.61340000E-04
   +2.16228000E-03  -2.77720000E-04  -9.43840000E-04  -3.82442300E-02  -3.12551000E-02
   -1.11724100E-02  -9.56706000E-03  +8.50271000E-03  -5.66810000E-04  +4.28484000E-03
   -8.17280000E-04  -5.62040000E-04  +2.54617800E-02  +1.66030100E-02  -1.11317000E-03
   -7.55662000E-03  -9.41337000E-03  -2.23174000E-03  +1.80620000E-04  -1.70702000E-03
   -5.96040000E-04  -1.06859520E-01  +9.75069000E-03  -6.09437700E-02  +5.88674370E-01
   -2.26180000E-04  +1.18350000E-04  +1.25690000E-04  -1.08303000E-03  -7.51280000E-04
   -1.28002000E-03  +2.57620000E-04  -4.10900000E-05  +1.46970000E-04  +6.94200000E-05
   +3.69600000E-05  +1.08510000E-04  -3.89810000E-04  +9.18600000E-05  +1.14170000E-04
   -2.34200000E-05  -2.50910000E-04  +4.46900000E-05  -5.42669000E-03  +1.13421000E-03
   +4.95222000E-03  +9.21910000E-04  +1.74660000E-04  +8.70340000E-04  +4.36250000E-04
   -9.39700000E-05  -1.68940000E-04  -1.82873700E-02  -4.09167000E-03  -2.31160500E-02
   +1.80459000E-03  -4.60017000E-03  -3.23638000E-03  -2.74112000E-03  -8.65100000E-05
   -1.38560000E-04  -2.08610600E-02  -2.29286200E-02  -9.29900000E-04  +4.41495000E-03
   +1.20532400E-02  +4.32954000E-03  +8.21710000E-04  +5.38400000E-05  +8.66080000E-04
   -2.45920400E-02  -8.47386700E-02  +2.84705000E-03  +3.47911350E-01  +4.60683220E-01
   +2.40600000E-05  -4.69560000E-04  -8.41500000E-05  -1.13658000E-03  -4.88230000E-04
   +1.02421000E-03  +5.88810000E-04  +4.18800000E-05  +2.69100000E-05  +2.29570000E-04
   +2.81540000E-04  +9.99400000E-05  -1.02902000E-03  +4.24830000E-04  +5.76990000E-04
   +4.63570000E-04  -3.11650000E-04  -4.45470000E-04  -3.03245000E-03  +7.61811000E-03
   +2.22129000E-03  +3.45850000E-04  +4.93440000E-04  -5.71020000E-04  +1.40628000E-03
   -1.85040000E-04  -6.60380000E-04  -1.37326700E-02  -2.28863500E-02  +9.44410000E-03
   +1.16209000E-03  +1.57261000E-03  -3.40845000E-03  +1.17075000E-03  +7.10870000E-04
   -5.32000000E-05  +5.86485000E-03  +5.35750000E-03  -6.34610000E-04  -2.32336000E-03
   -2.34065000E-03  +4.74950000E-04  +2.74613000E-03  -1.53848000E-03  +2.10067000E-03
   -6.38725800E-02  +1.90404400E-02  -2.28878190E-01  +1.31023300E-02  -1.09879030E-01
   +6.39550880E-01  -8.04700000E-05  +6.51730000E-04  +8.62400000E-05  -7.83100000E-05
   -1.65980000E-04  -1.81376000E-03  -2.94260000E-04  -4.56000000E-05  -1.75440000E-04
   -2.52050000E-04  -2.93860000E-04  -1.73430000E-04  +1.20788000E-03  -3.52620000E-04
   -5.95860000E-04  -4.39300000E-04  +2.46870000E-04  +4.29720000E-04  -1.21696000E-03
   -1.25894000E-03  +2.22264000E-03  -7.92550000E-04  -4.46240000E-04  +7.19700000E-05
   -1.50441000E-03  +2.06650000E-04  +6.17360000E-04  +9.25339000E-03  +1.14582000E-02
   -7.89171000E-03  +2.63004000E-03  -3.32710000E-03  -1.31650000E-04  -2.21123000E-03
   -1.75770000E-04  -7.29080000E-04  -3.70263000E-03  -3.47170000E-04  +8.98220000E-04
   +2.10274000E-03  -3.96440000E-04  -8.92140000E-04  -1.01520000E-03  +8.85230000E-04
   -4.47270000E-04  -3.62214000E-02  -5.06966100E-02  -2.23805300E-02  -3.71396850E-01
   -2.57347260E-01  +1.02659700E-02  +4.41241020E-01  -1.79400000E-05  +2.82360000E-04
   +3.18600000E-05  +5.20660000E-04  +2.45730000E-04  -5.14580000E-04  -3.06180000E-04
   -5.03000000E-05  -1.59600000E-04  -1.74180000E-04  -1.49700000E-04  -1.14570000E-04
   +7.76340000E-04  -2.23450000E-04  -3.49150000E-04  -2.08070000E-04  +2.27950000E-04
   +2.11380000E-04  +1.52782000E-03  -2.70757000E-03  -6.61820000E-04  -5.23500000E-04
   -4.42200000E-04  +4.12200000E-05  -9.60830000E-04  +1.55480000E-04  +3.98550000E-04
   +4.81298000E-03  +1.09160400E-02  -1.61191000E-03  +5.87390000E-04  -9.15460000E-04
   +2.87290000E-04  -6.64600000E-04  -3.96900000E-04  -5.00970000E-04  +8.36508000E-03
   +5.10453000E-03  -3.79690000E-04  -1.20713000E-03  -5.00140000E-03  -1.77219000E-03
   -1.29326000E-03  +6.93450000E-04  -9.45970000E-04  -3.35303400E-02  -1.03432500E-02
   -1.31940000E-02  -2.67856320E-01  -2.86774200E-01  +1.13540800E-02  +3.20042810E-01
   +3.36009190E-01  -7.84100000E-05  -5.48800000E-05  +7.17100000E-05  +2.90680000E-04
   -7.26000000E-06  +6.04700000E-05  -3.34500000E-05  -5.55500000E-05  +8.42400000E-05
   -2.24000000E-05  -5.81000000E-06  +8.33400000E-05  -6.76300000E-05  +2.00300000E-05
   +1.91400000E-05  +2.16700000E-05  -1.10700000E-05  +1.04000000E-06  +3.36440000E-04
   -1.85309000E-03  -3.09050000E-04  +3.28720000E-04  -8.12000000E-06  +1.69680000E-04
   +4.66500000E-05  -6.12000000E-06  +2.04100000E-05  -4.57867000E-03  +9.55240000E-04
   -4.92478000E-03  -1.02103000E-03  +1.66853000E-03  +7.26480000E-04  +6.64750000E-04
   -1.99080000E-04  +6.16430000E-04  +6.91800000E-05  -1.67554000E-03  -3.79260000E-04
   -4.52410000E-04  +1.28328000E-03  +6.75130000E-04  -3.00910000E-04  +8.81700000E-05
   -2.85000000E-04  -3.08140100E-02  -2.48263600E-02  +1.35364700E-02  -8.40875000E-03
   -2.80628000E-03  -1.26055830E-01  -1.22101200E-02  +6.25002000E-03  +1.86105230E-01
   +7.47800000E-05  +2.63150000E-04  -6.86200000E-05  +2.72100000E-05  +7.50200000E-05
   -3.61320000E-04  -1.05220000E-04  -6.44500000E-05  -2.23020000E-04  -1.34020000E-04
   -1.33990000E-04  -1.06670000E-04  +7.32380000E-04  -1.51510000E-04  -2.83200000E-04
   -1.06940000E-04  +2.04060000E-04  +1.10620000E-04  +7.10420000E-04  +6.79090000E-04
   +2.12810000E-04  -6.73960000E-04  -1.06590000E-04  -1.81850000E-04  -8.22690000E-04
   +1.28480000E-04  +3.12020000E-04  -1.45421000E-03  -1.93771000E-03  +2.43230000E-04
   -1.81012000E-03  +1.39407000E-03  +1.96149000E-03  -2.49707000E-02  -3.96101200E-02
   +8.00708000E-03  -2.17648820E-01  -1.48644080E-01  +1.27210100E-02  +3.89907700E-02
   -1.77742800E-02  -1.26138300E-02  -3.48280000E-04  -7.86100000E-05  -1.99400000E-05
   -3.70234000E-03  +5.34817000E-03  -2.07027000E-03  -1.78443800E-02  -3.44828000E-03
   +1.47373000E-03  +1.09685200E-02  -2.22081000E-03  -3.55268000E-03  +2.52462460E-01
   -4.40100000E-05  -2.78720000E-04  -1.71440000E-04  -7.14300000E-05  +2.98660000E-04
   +8.31850000E-04  +1.45190000E-04  -3.04790000E-04  -1.98990000E-04  -2.76700000E-05
   +1.69980000E-04  +1.33970000E-04  -1.90860000E-04  +1.76900000E-04  +2.14110000E-04
   +3.67450000E-04  +3.52500000E-05  -2.71050000E-04  -8.09000000E-04  +2.46342000E-03
   -4.76810000E-04  -9.29500000E-05  +3.42500000E-04  -1.02790000E-04  +3.70380000E-04
   +2.04700000E-05  -1.83180000E-04  -6.25270000E-03  -1.47573300E-02  +3.15230000E-03
   -6.23125000E-03  +2.44110000E-04  +2.12217000E-03  -1.47846000E-02  -7.90960000E-03
   -1.80443000E-03  -1.43454520E-01  -3.00537530E-01  -1.39545200E-02  -3.17535700E-02
   -1.06929190E-01  -3.64054800E-02  +1.22769000E-03  -9.35450000E-04  +9.91690000E-04
   +2.05538600E-02  +5.24206000E-03  +6.78131000E-03  -2.30540500E-02  +2.28612700E-02
   -6.37779000E-03  +1.76928000E-03  -1.79541900E-02  +1.37168000E-03  +2.03422830E-01
   +4.34055430E-01  -6.57200000E-05  -8.42000000E-05  +3.34200000E-05  +6.40700000E-05
   +7.34000000E-06  +9.38400000E-05  -2.03900000E-05  -1.12300000E-05  +1.01030000E-04
   -2.11000000E-06  +2.10900000E-05  +5.89500000E-05  -1.53940000E-04  +2.67800000E-05
   +3.86000000E-05  +1.04600000E-05  -3.73600000E-05  -6.58000000E-06  -1.12870000E-04
   -4.97280000E-04  +7.50300000E-05  +3.51360000E-04  +4.49900000E-05  +1.06840000E-04
   +1.47070000E-04  -2.41900000E-05  -2.83500000E-05  +3.34990000E-04  +4.12841000E-03
   +3.52550000E-04  +2.29651000E-03  +7.83600000E-04  -2.53417000E-03  +1.57712700E-02
   +6.88631000E-03  +1.81093300E-02  +7.17510000E-03  -1.89536200E-02  -8.12222400E-02
   -1.43282200E-02  -3.54763900E-02  +2.11365000E-02  +3.36880000E-04  +6.34000000E-05
   -9.44300000E-05  -4.37451000E-03  +1.57545000E-03  +2.47287000E-03  +3.13163000E-03
   +5.65813000E-03  -9.48563000E-03  -4.62129000E-03  -3.58067000E-03  +4.88882000E-03
   -2.73094800E-02  +4.36868600E-02  +7.70365300E-02  +2.10900000E-05  +1.36750000E-04
   -5.37000000E-06  +5.80500000E-05  -3.33000000E-06  -2.38730000E-04  -5.12100000E-05
   +1.10400000E-05  -6.22000000E-05  -9.25900000E-05  -9.36000000E-05  -5.84100000E-05
   +4.35310000E-04  -8.29400000E-05  -1.75980000E-04  -9.53000000E-05  +1.02980000E-04
   +8.56400000E-05  +3.37450000E-04  -7.40000000E-05  +1.38710000E-04  -1.97140000E-04
   -4.82000000E-05  -1.04800000E-04  -5.03550000E-04  +6.51500000E-05  +1.93140000E-04
   +3.57610000E-04  +7.65800000E-05  +2.02610000E-04  -7.46270000E-04  -7.01900000E-05
   +5.17100000E-04  -1.35834000E-03  -1.29414000E-03  -2.03990000E-03  +1.88749000E-03
   +1.70233200E-02  +6.60943000E-03  +2.32483000E-03  -6.42818000E-03  -2.19129000E-03
   -1.39480000E-04  +4.61500000E-05  -1.53690000E-04  -8.40770000E-04  -9.36400000E-05
   -2.74460000E-04  +8.16500000E-04  -4.74785000E-03  -8.47200000E-05  +1.60211000E-03
   +2.36903000E-03  -3.26630000E-04  -3.44331500E-02  -2.14114000E-02  +3.52747900E-02
   +6.51112410E-01  -7.98000000E-06  -6.81000000E-06  -4.39300000E-05  +5.72000000E-06
   +1.47730000E-04  +3.03400000E-05  -4.71900000E-05  -6.86300000E-05  -8.12400000E-05
   -3.04400000E-05  +2.11400000E-05  +4.00000000E-08  +7.44400000E-05  -9.71000000E-06
   -1.23500000E-05  +3.49100000E-05  +4.45600000E-05  -1.06200000E-05  +1.78980000E-04
   +1.21960000E-04  +2.36000000E-06  -1.64300000E-04  +1.43900000E-05  -1.18900000E-05
   -7.32700000E-05  +3.37000000E-05  +2.08500000E-05  -8.29810000E-04  -1.34525000E-03
   +1.33940000E-04  -1.01920000E-03  +5.29470000E-04  +5.68380000E-04  -3.28560000E-04
   -9.65650000E-04  -6.22630000E-04  +4.21128000E-03  +6.50889000E-03  +3.32180000E-04
   -2.03728000E-03  -1.95577000E-03  +1.01851000E-03  +1.71560000E-04  -6.76000000E-05
   -4.58800000E-05  +1.15378000E-03  +9.08800000E-04  +1.41577000E-03  -4.53795000E-03
   -1.13996000E-02  -2.08045000E-03  +1.19574000E-02  +7.80486000E-03  -9.10877000E-03
   -2.50652800E-02  +3.41918000E-03  +1.84794800E-02  -9.56640500E-02  +2.19868280E-01
   -2.43500000E-05  -1.22120000E-04  +1.85200000E-05  +1.19700000E-05  -3.77000000E-06
   +2.47250000E-04  +3.32800000E-05  -2.29000000E-05  +7.41800000E-05  +4.72900000E-05
   +5.92600000E-05  +6.23100000E-05  -2.77060000E-04  +6.26400000E-05  +1.05560000E-04
   +6.38300000E-05  -6.31500000E-05  -4.84400000E-05  -3.32180000E-04  +1.13400000E-05
   -1.80000000E-04  +3.56410000E-04  +6.31000000E-05  +3.03500000E-05  +3.16940000E-04
   -4.49500000E-05  -1.06920000E-04  -1.56620000E-04  +1.75400000E-04  -1.49610000E-04
   +7.28990000E-04  -1.78160000E-04  -4.51350000E-04  +1.06414000E-03  +2.39382000E-03
   +8.92510000E-04  -3.69070000E-04  -1.76295000E-02  -7.20120000E-03  -1.68934000E-03
   +6.19645000E-03  +3.27374000E-03  +3.16520000E-04  -5.30500000E-05  +1.03490000E-04
   +6.17450000E-04  +3.34660000E-04  +4.18550000E-04  -1.24092000E-03  +5.56142000E-03
   -3.52820000E-04  -2.81759000E-03  -3.26540000E-03  +2.76383000E-03  +4.07589900E-02
   +1.89312000E-02  -2.08403800E-02  -5.07315000E-03  -1.32987180E-01  +2.25940110E-01
   +1.29614000E-03  +1.35476000E-03  +9.36440000E-04  +4.70400000E-05  -7.78210000E-04
   -4.00900000E-04  -6.72520000E-04  +3.52050000E-04  +2.07190000E-04  +2.28448000E-03
   +1.91761000E-03  -9.47000000E-06  -1.09547300E-02  +4.11523100E-02  +2.66010600E-02
   -6.63443000E-03  -1.37572000E-03  +2.29221000E-03  -1.78590000E-04  -1.10730000E-04
   -3.96300000E-05  +6.53600000E-05  +8.00000000E-06  +1.56500000E-05  -4.47316600E-02
   +8.01503000E-03  +1.88575000E-02  -9.05300000E-05  -4.80700000E-05  -8.72000000E-05
   -5.50000000E-06  -2.22500000E-05  +2.85100000E-05  +2.37700000E-05  +4.56200000E-05
   -1.40800000E-05  -1.38070000E-04  +5.92200000E-05  +6.61000000E-05  +1.08650000E-04
   -9.15600000E-05  -4.95100000E-05  +9.20100000E-05  +2.59300000E-05  -4.23000000E-06
   +1.37840000E-04  +3.49900000E-05  +1.33520000E-04  -2.81500000E-04  -7.48700000E-05
   -1.51490000E-04  +2.11290000E-04  +1.29990000E-04  -3.36900000E-05  +1.36070000E-04
   -4.29400000E-05  -3.66700000E-05  +8.40000000E-05  +1.22200000E-05  -5.77300000E-05
   +6.04238100E-02  -1.73350000E-04  +1.86600000E-05  -9.45240000E-04  -2.65860000E-04
   +2.07230000E-04  +8.79100000E-05  +5.64400000E-05  -9.82690000E-04  -1.87050000E-04
   -3.79239000E-03  +3.21869000E-03  +3.71234000E-03  -5.28300000E-05  -4.87713000E-03
   -1.14659000E-03  -1.23260000E-04  +2.40717000E-03  +1.38500000E-04  +1.40620000E-04
   -1.51780000E-04  -1.24000000E-05  -1.43380000E-04  +6.80200000E-05  +3.34900000E-05
   +5.26383000E-02  -3.90803700E-01  -2.42239680E-01  +5.70500000E-05  +1.00430000E-04
   +8.75100000E-05  +1.99700000E-05  +1.21800000E-05  -3.25200000E-05  -2.85400000E-05
   -2.06400000E-05  +8.18000000E-06  +7.89300000E-05  +6.50000000E-06  -2.93600000E-05
   -5.02400000E-05  +2.12400000E-05  +2.05000000E-05  -2.97800000E-05  -2.07000000E-05
   -4.38000000E-06  -7.86400000E-05  -7.76000000E-05  -1.08370000E-04  +1.48330000E-04
   +6.66500000E-05  +8.92900000E-05  -1.14190000E-04  -9.19300000E-05  +1.03800000E-05
   -7.43700000E-05  -1.47800000E-05  +1.87500000E-05  -3.63500000E-05  -2.18600000E-05
   +2.85400000E-05  -4.86034900E-02  +3.91318150E-01  +2.53700000E-05  -1.45269000E-03
   +8.75250000E-04  -1.18520000E-04  +3.35470000E-04  +3.06410000E-04  +3.10200000E-05
   -3.19590000E-04  -8.55970000E-04  -3.30352000E-03  +1.74292000E-03  +1.22818000E-03
   +2.74326000E-03  -1.54735200E-02  -1.27195600E-02  +2.99069000E-03  +6.00850000E-04
   +1.50187000E-03  +9.79000000E-05  -6.50000000E-07  -5.79900000E-05  -5.66000000E-05
   +2.93700000E-05  -1.44000000E-06  +4.47042100E-02  -2.26764890E-01  -1.50372730E-01
   +7.30400000E-05  +4.84300000E-05  +1.44230000E-04  -3.31200000E-05  +5.03000000E-06
   -5.20600000E-05  +1.63000000E-06  -2.54300000E-05  -4.01000000E-06  +2.74400000E-05
   -3.58700000E-05  -1.40700000E-05  -3.78400000E-05  +4.37100000E-05  +4.80000000E-06
   -4.53900000E-05  -1.64500000E-05  -1.69200000E-05  -1.18460000E-04  -5.21400000E-05
   -1.48290000E-04  +1.87870000E-04  +2.46000000E-05  +1.58370000E-04  -1.12310000E-04
   -7.18800000E-05  -2.66100000E-05  -4.97700000E-05  +4.76000000E-05  -8.68000000E-06
   -3.23300000E-05  +3.86000000E-06  +9.46000000E-06  -4.75210300E-02  +2.40735850E-01
   +1.60118120E-01  -1.53494000E-03  -3.97290000E-04  -1.04300000E-05  -4.19437000E-03
   -1.21139000E-03  +3.37440000E-03  -1.82228000E-03  +2.52711900E-02  +1.61255700E-02
   -7.18066700E-02  +4.52729800E-02  +3.95567700E-02  +7.42373000E-03  -1.70095600E-02
   -1.09746100E-02  -2.14278000E-03  -4.15870000E-03  +2.75820000E-04  +3.08960000E-04
   +1.15991000E-03  +6.05650000E-04  +8.32000000E-06  +1.01050000E-04  -8.43900000E-05
   +2.76358000E-03  +2.65090000E-04  -2.15354000E-03  +2.65590000E-04  +9.62800000E-05
   +1.94420000E-04  -4.48300000E-05  -3.38400000E-05  -4.47400000E-05  -1.41000000E-06
   -8.93000000E-06  -1.67400000E-05  +1.86500000E-05  +1.19400000E-05  +8.94000000E-06
   -2.00400000E-05  +5.64000000E-06  -1.06200000E-05  -4.66680000E-04  -1.00950000E-04
   +6.84100000E-05  -1.52430000E-04  -1.20520000E-04  -2.00660000E-04  +1.62660000E-04
   +7.88200000E-05  +2.02760000E-04  -1.04380000E-04  -1.10540000E-04  -4.41400000E-05
   -4.22500000E-05  +7.35000000E-06  -1.56000000E-05  -1.99500000E-05  -1.59700000E-05
   +6.22000000E-06  -7.67510000E-04  +4.77930000E-04  +7.34530000E-04  +7.12794000E-02
   -7.41760000E-04  +5.56500000E-05  +8.01800000E-04  -5.62310000E-04  +3.43492000E-03
   -2.12533000E-03  -8.37810000E-04  +8.95980000E-04  -5.90150000E-04  +4.55680300E-02
   -2.34298310E-01  -1.32158700E-01  +1.05640200E-02  -1.34492400E-02  -1.38711400E-02
   -4.66546000E-03  -8.75790000E-04  -2.05427000E-03  -2.85850000E-04  -1.49500000E-05
   -1.91660000E-04  +4.81300000E-05  -5.54000000E-05  +2.00100000E-05  +8.85950000E-04
   +1.27935000E-03  +2.66853000E-03  -3.97200000E-05  +1.70300000E-05  -7.36200000E-05
   +3.85400000E-05  +1.27300000E-05  +3.65600000E-05  -7.36000000E-06  +7.81000000E-06
   +1.10500000E-05  -1.93000000E-06  +2.26900000E-05  -3.70000000E-07  +1.61700000E-05
   -2.14100000E-05  +1.82000000E-06  +8.10600000E-05  +2.86500000E-05  +2.96900000E-05
   +8.91100000E-05  +8.95000000E-06  +9.73100000E-05  -1.20010000E-04  -1.48400000E-05
   -1.36050000E-04  +7.09500000E-05  +4.70700000E-05  +2.63100000E-05  +2.73100000E-05
   -3.71500000E-05  +1.30200000E-05  +2.00200000E-05  -2.25000000E-06  -5.84000000E-06
   -2.00988000E-03  -5.63270000E-04  +4.67900000E-05  -4.96019300E-02  +2.44990940E-01
   -2.93950000E-04  +6.43260000E-04  -3.95860000E-04  +3.65210000E-03  -1.70231000E-03
   +5.14477000E-03  +1.06157000E-03  -9.79007000E-03  -3.58138000E-03  +3.96517000E-02
   -1.32181370E-01  -1.23833970E-01  +5.06769000E-03  -4.15186000E-03  -6.44000000E-06
   -1.51800000E-05  -2.25707000E-03  +4.18886000E-03  -2.95600000E-05  -6.66910000E-04
   +1.74230000E-04  +5.22700000E-05  +2.12800000E-05  -7.84000000E-06  -1.82563000E-03
   +2.88770000E-03  -1.55665000E-03  -1.71920000E-04  -1.00400000E-04  -1.46220000E-04
   -9.17000000E-06  -1.76300000E-05  +4.80000000E-06  +1.56400000E-05  +1.93400000E-05
   -5.22000000E-06  -7.08400000E-05  +8.40000000E-07  +2.70400000E-05  +4.67700000E-05
   -2.50700000E-05  -1.72300000E-05  +2.23860000E-04  +7.96900000E-05  -9.87000000E-05
   +6.36600000E-05  +8.00200000E-05  +1.05040000E-04  -1.35530000E-04  -5.39100000E-05
   -5.60200000E-05  +1.06470000E-04  +8.00900000E-05  -2.46500000E-05  +6.68100000E-05
   +8.94000000E-06  -2.26300000E-05  +3.40900000E-05  +2.07700000E-05  -2.82300000E-05
   -7.03430000E-04  -8.25500000E-04  +3.26040000E-04  -4.54921900E-02  +1.45673070E-01
   +1.23444920E-01  +1.08690000E-03  +1.01842000E-03  +2.42932000E-03  +9.02169000E-03
   +5.03408000E-03  +1.26543000E-03  -1.83252930E-01  -1.36091280E-01  -2.99952400E-02
   -1.52246200E-02  -2.22203300E-02  -6.27174000E-03  -2.81262000E-03  +1.05933000E-03
   +4.28901000E-03  -3.68710000E-04  +8.72080000E-04  +2.00100000E-04  -5.02920000E-04
   +4.18640000E-04  -6.17380000E-04  -1.92940000E-04  +3.39300000E-05  +2.93820000E-04
   -1.52888000E-03  -1.07836000E-03  -1.32820000E-04  -6.70620000E-04  +9.66340000E-04
   +3.71870000E-04  +4.43800000E-05  -1.02310000E-04  +1.90500000E-05  -3.57800000E-05
   -5.03000000E-06  +2.27600000E-05  -5.83300000E-05  +1.01450000E-04  +4.31000000E-05
   +5.91500000E-05  -8.62600000E-05  -4.75000000E-05  +4.75300000E-05  +8.23200000E-05
   -1.50450000E-04  -4.33730000E-04  +2.16700000E-05  +5.05300000E-05  -4.53100000E-04
   -2.16900000E-05  -2.04210000E-04  +2.45480000E-04  +1.19040000E-04  -1.93500000E-05
   +1.06660000E-04  -8.51600000E-05  -1.06500000E-05  +5.85000000E-05  +1.78100000E-05
   -4.62100000E-05  +1.81750000E-04  -1.77820000E-04  -1.72120000E-04  +4.86420000E-04
   +9.34550000E-04  -1.13942000E-03  +1.93929740E-01  +1.45962000E-03  -2.07106000E-03
   -5.51251000E-03  -1.87562600E-02  -1.29863600E-02  -3.61885000E-03  -1.36018620E-01
   -1.97694060E-01  -4.59039700E-02  +3.63840000E-03  +5.50892000E-03  -3.63610000E-04
   +5.86300000E-04  +3.08627000E-03  -3.07024000E-03  +1.04964000E-03  -1.49610000E-04
   +2.69320000E-04  -7.08530000E-04  -6.04980000E-04  +1.83358000E-03  +1.92900000E-05
   -1.51630000E-04  -1.86400000E-05  -3.90500000E-05  +1.18390000E-04  +1.19890000E-04
   +5.35170000E-04  -6.06010000E-04  -3.34370000E-04  -6.18400000E-05  -4.58500000E-05
   +2.00310000E-04  +4.18200000E-05  -2.19000000E-06  +9.35000000E-06  +3.00000000E-08
   -3.08920000E-04  -1.20620000E-04  -7.24300000E-05  +2.04460000E-04  +1.13840000E-04
   +2.04540000E-04  -9.31000000E-06  +9.52700000E-05  -3.22400000E-04  +4.01540000E-04
   +1.14100000E-05  +7.21230000E-04  +2.75860000E-04  +4.66810000E-04  -3.91200000E-04
   -3.35610000E-04  +4.66300000E-05  -1.42380000E-04  +2.89100000E-04  +1.70100000E-05
   -9.49600000E-05  -7.26000000E-06  +7.95600000E-05  +3.15400000E-05  -1.75300000E-05
   -3.55000000E-06  +5.24970000E-04  -3.81280000E-04  +2.24106000E-03  +1.48716350E-01
   +2.05815620E-01  +2.72965000E-03  -5.18792000E-03  +2.56785000E-03  -1.26882400E-02
   -1.16479700E-02  +1.69935000E-03  -3.01552900E-02  -4.65342400E-02  -5.57584700E-02
   +8.94071000E-03  +8.71696000E-03  +5.99192000E-03  +4.06227000E-03  -3.22922000E-03
   +4.63383000E-03  +2.93370000E-04  +3.11760000E-04  -1.13106000E-03  -1.42085000E-03
   +1.28995000E-03  -1.93485000E-03  +2.32130000E-04  -5.48580000E-04  -4.03350000E-04
   +5.34270000E-04  +5.15940000E-04  +7.89000000E-06  -1.01910000E-04  -5.45700000E-05
   +4.65160000E-04  -8.38500000E-05  -1.82030000E-04  -1.19000000E-06  +4.41300000E-05
   +5.64300000E-05  -1.00780000E-04  -6.61300000E-05  -2.51000000E-05  +5.32500000E-05
   +3.42000000E-05  -3.00000000E-06  -3.11500000E-05  -1.03740000E-04  +1.28670000E-04
   -1.09790000E-04  +1.96500000E-05  -5.45500000E-05  -1.96700000E-04  -2.13600000E-05
   +7.23800000E-05  +2.33050000E-04  +4.19000000E-06  -2.66200000E-05  -1.33780000E-04
   +3.45800000E-05  +5.22600000E-05  -5.56600000E-05  +5.55000000E-06  +2.91100000E-05
   -2.99800000E-05  -6.47800000E-05  +6.64200000E-05  +3.88200000E-05  -1.41871000E-03
   +2.04859000E-03  -2.79507000E-03  +2.91949700E-02  +5.33897700E-02  +4.82922800E-02
   -7.10339000E-02  +4.71446700E-02  +3.73063300E-02  +1.03098200E-02  -1.64260600E-02
   -1.13045100E-02  -2.36362000E-03  -4.48005000E-03  +4.67470000E-04  -1.30073000E-03
   -2.97400000E-04  -9.92400000E-05  -3.83066000E-03  -1.20756000E-03  +3.41021000E-03
   -2.61257000E-03  +2.46573800E-02  +1.63589800E-02  +3.34780000E-04  +7.99810000E-04
   -9.49350000E-04  +2.14360000E-04  +1.02380000E-04  +1.18360000E-04  -2.37440000E-04
   +1.32759000E-03  +8.54590000E-04  -2.23100000E-04  +1.11900000E-05  -5.43800000E-05
   +8.68700000E-05  +2.78500000E-05  +8.18200000E-05  -2.36200000E-05  +8.04900000E-05
   +2.59900000E-05  -1.04470000E-04  -1.11240000E-04  -4.77700000E-05  +7.13300000E-05
   +1.90300000E-05  +5.91100000E-05  -2.32072000E-03  -8.03270000E-04  +5.82530000E-04
   +1.21540000E-04  +1.09100000E-04  +1.37020000E-04  -7.50800000E-05  -1.16880000E-04
   -1.32570000E-04  +1.02870000E-04  +1.15780000E-04  +1.21400000E-05  +9.25100000E-05
   +6.93400000E-05  -2.50000000E-07  +5.31800000E-05  +3.38400000E-05  -2.50200000E-05
   -3.95270000E-04  +1.03740000E-04  +1.24700000E-04  -5.84000000E-06  +1.36460000E-04
   -1.67990000E-04  +3.77100000E-04  -1.02490000E-03  -6.60750000E-04  +7.55041400E-02
   +4.68259300E-02  -2.45591710E-01  -1.32247210E-01  +6.30032000E-03  -1.33246200E-02
   -1.21234500E-02  -4.59156000E-03  -7.61080000E-04  -2.52649000E-03  -3.43450000E-04
   +1.97430000E-04  +8.65480000E-04  -1.20942000E-03  +3.31806000E-03  -2.28487000E-03
   -1.33645000E-03  +1.48606000E-03  -1.11678000E-03  +1.97362000E-03  -1.25297000E-03
   +8.00780000E-04  -5.01020000E-04  +2.80800000E-05  +1.86500000E-05  +2.26380000E-04
   -1.53870000E-04  -1.62880000E-04  +2.06220000E-04  +4.90200000E-05  -1.73560000E-04
   +3.14900000E-05  +2.71900000E-05  -7.13000000E-06  -3.56300000E-05  +1.92300000E-05
   +7.21000000E-06  +1.47200000E-05  -3.27300000E-05  -5.26300000E-05  -4.25000000E-06
   +1.31000000E-05  +5.36000000E-05  +1.19625000E-03  +3.54540000E-04  -5.47540000E-04
   +8.00900000E-05  +7.46000000E-05  +1.63280000E-04  -4.79500000E-05  -3.34100000E-05
   -8.53700000E-05  +3.80100000E-05  +4.60900000E-05  +2.42400000E-05  +4.08000000E-06
   +5.09000000E-06  +1.98400000E-05  +9.83000000E-06  +1.15500000E-05  +8.07000000E-06
   +9.59000000E-06  -9.77000000E-06  +1.14870000E-04  +1.75810000E-04  -1.98980000E-04
   +2.27330000E-04  +3.93020000E-04  -7.73220000E-04  -6.29450000E-04  -5.12482000E-02
   +2.56114690E-01  +3.69816400E-02  -1.32049240E-01  -1.26862490E-01  +1.63433000E-03
   -4.16862000E-03  +1.46075000E-03  +5.16080000E-04  -2.80872000E-03  +4.79723000E-03
   -2.62980000E-04  +8.03110000E-04  -5.62210000E-04  +3.48662000E-03  -2.21059000E-03
   +5.70437000E-03  +1.75198000E-03  -1.01159900E-02  -2.14439000E-03  -5.83760000E-04
   +1.20021000E-03  -2.98750000E-03  +5.96970000E-04  +6.65500000E-05  -1.09730000E-04
   +2.01940000E-04  -5.57990000E-04  -3.77800000E-04  -4.00710000E-04  -2.78830000E-04
   +4.64200000E-04  -8.88700000E-05  +4.86800000E-05  +1.01290000E-04  +7.74700000E-05
   +6.48100000E-05  -1.03300000E-05  -1.73290000E-04  -1.65770000E-04  +2.30000000E-07
   +7.43300000E-05  +5.25800000E-05  -6.57000000E-06  +1.59712000E-03  +2.47000000E-05
   +3.44250000E-04  -1.04940000E-04  +1.84300000E-05  -2.35900000E-04  +1.23260000E-04
   -1.04810000E-04  +7.21700000E-05  -4.19900000E-05  +1.62700000E-05  -2.22500000E-05
   +7.49100000E-05  +1.60070000E-04  -2.81600000E-05  +1.65700000E-05  +3.30700000E-05
   -2.21400000E-05  +6.87000000E-05  +7.94100000E-05  -1.86520000E-04  -1.53670000E-04
   +2.51060000E-04  -5.24660000E-04  +1.42800000E-04  -1.32540000E-04  -3.80700000E-05
   -4.55152600E-02  +1.46724030E-01  +1.25294590E-01  -1.40596100E-02  -2.12216200E-02
   -6.29526000E-03  -3.15628000E-03  +8.17980000E-04  +4.07116000E-03  -3.41780000E-04
   +9.04990000E-04  +2.67040000E-04  +7.61000000E-04  +9.78450000E-04  +2.28023000E-03
   +7.88533000E-03  +6.08716000E-03  +2.62449000E-03  -1.89921680E-01  -1.42276970E-01
   -2.76745700E-02  -2.43040000E-04  -9.69880000E-04  -4.44840000E-04  -2.44180000E-04
   +9.85900000E-05  +6.72000000E-06  +6.01130000E-04  +1.81610000E-04  -1.34537000E-03
   -4.87500000E-05  -1.20700000E-05  +3.13660000E-04  -4.97900000E-05  +1.61200000E-05
   -2.13600000E-05  +1.90400000E-05  -5.37000000E-06  -5.30000000E-06  -9.00000000E-07
   -8.11300000E-05  -2.48500000E-05  -2.03300000E-05  +6.18300000E-05  +2.02500000E-05
   +3.41700000E-05  -6.86600000E-05  -1.00420000E-04  -8.99200000E-05  -5.05300000E-05
   -1.86720000E-04  +1.44320000E-04  -1.95900000E-05  +9.40900000E-05  -9.02800000E-05
   -4.35000000E-05  -9.61000000E-06  -1.77200000E-05  +7.42800000E-05  +1.30000000E-07
   -2.10700000E-05  +1.01400000E-05  +1.03100000E-05  -1.13700000E-05  -2.73400000E-05
   -2.05970000E-04  +4.08130000E-04  +4.43170000E-04  +7.37200000E-05  -7.23000000E-05
   +1.45600000E-05  -2.16920000E-04  +4.50420000E-04  +9.05430000E-04  -1.20754000E-03
   +1.98077200E-01  +4.21094000E-03  +6.32980000E-03  +6.35720000E-04  +6.37800000E-04
   +2.98245000E-03  -2.65527000E-03  +1.28936000E-03  -3.51420000E-04  -4.42300000E-05
   +1.43714000E-03  -1.97872000E-03  -4.86990000E-03  -2.11066800E-02  -1.27403600E-02
   -3.01136000E-03  -1.40925530E-01  -1.99867190E-01  -4.46296400E-02  +1.44940000E-04
   +2.94590000E-04  -7.70500000E-05  +3.86300000E-05  -1.78900000E-05  -5.02400000E-05
   +4.15710000E-04  +8.04120000E-04  +2.34043000E-03  -2.40900000E-05  +2.80900000E-05
   +2.00900000E-05  +4.65000000E-06  +3.43000000E-06  -7.53000000E-06  -1.97000000E-06
   -1.08700000E-05  +2.52000000E-06  +3.01400000E-05  +3.36000000E-06  -7.68000000E-06
   -2.14700000E-05  +6.48000000E-06  +6.56000000E-06  -2.11200000E-05  -3.12900000E-05
   +5.49100000E-05  -3.06800000E-05  -2.16600000E-05  -2.92700000E-05  +6.49600000E-05
   +1.40300000E-05  +3.03400000E-05  -4.69500000E-05  -2.77900000E-05  +1.15500000E-05
   -3.22900000E-05  -2.73000000E-06  +7.94000000E-06  -1.73600000E-05  -6.97000000E-06
   +1.45700000E-05  +6.57000000E-05  +1.95680000E-04  +4.02820000E-04  -8.23110000E-04
   -8.17800000E-04  -1.23270000E-04  +3.59100000E-05  -1.69520000E-04  +2.98900000E-04
   +4.39470000E-04  -3.50920000E-04  +2.23020000E-03  +1.54189400E-01  +2.05728110E-01
   +8.29514000E-03  +9.45063000E-03  +5.18514000E-03  +3.82229000E-03  -2.80065000E-03
   +4.34171000E-03  +4.52450000E-04  +1.50520000E-04  -1.10899000E-03  +2.54010000E-03
   -4.68965000E-03  +2.09081000E-03  -1.29195500E-02  -1.25432100E-02  +2.73456000E-03
   -2.68622400E-02  -4.40112800E-02  -5.15021100E-02  +4.76390000E-04  +1.74670000E-04
   +3.90790000E-04  -7.76000000E-06  -1.66600000E-05  +7.55400000E-05  -1.20177000E-03
   +2.42248000E-03  -1.73292000E-03  +1.08200000E-04  -6.89800000E-05  -1.71380000E-04
   -4.61000000E-06  -2.06000000E-05  +3.70000000E-07  -4.17000000E-06  +2.28000000E-06
   -3.38000000E-06  -3.20600000E-05  +1.76900000E-05  +1.86900000E-05  +2.23000000E-05
   -1.48300000E-05  -2.14000000E-05  -1.06120000E-04  +7.29700000E-05  -4.36100000E-05
   +5.55300000E-05  +9.96900000E-05  +9.99400000E-05  -1.26480000E-04  +2.30000000E-07
   -5.11400000E-05  +7.55900000E-05  +4.00800000E-05  -1.44400000E-05  +3.65900000E-05
   -9.84000000E-06  -1.05300000E-05  +1.73200000E-05  +7.68000000E-06  -1.97600000E-05
   -1.49110000E-04  +4.37620000E-04  -2.52140000E-04  -6.47300000E-04  -5.43770000E-04
   -2.20840000E-04  -1.95140000E-04  +3.13260000E-04  -4.61240000E-04  -1.47155000E-03
   +2.04880000E-03  -2.88463000E-03  +2.78473900E-02  +4.95519700E-02  +4.34733700E-02
   +1.80320000E-04  -1.35250000E-04  -1.56600000E-04  +8.16110000E-04  +2.15000000E-04
   +1.16945000E-03  +2.47090000E-04  -2.81300000E-05  -3.10800000E-05  -1.28920000E-04
   +3.26000000E-05  -7.25700000E-05  -7.39200000E-05  +9.05600000E-05  +4.69900000E-05
   +3.40100000E-05  +3.28100000E-05  -5.53600000E-05  +1.65997000E-03  +6.66000000E-06
   +3.96960000E-03  -1.76807020E-01  -2.41555800E-02  -1.34707570E-01  +1.04050000E-04
   -2.90500000E-05  -2.73900000E-05  +4.94500000E-05  -1.08556000E-03  +8.61770000E-04
   +3.84640000E-04  -6.14400000E-05  +2.61790000E-04  +1.76300000E-05  -2.43300000E-05
   +3.53700000E-05  -1.79600000E-05  -2.20100000E-04  -4.81500000E-05  -2.83900000E-05
   +1.29430000E-04  +5.83900000E-05  -1.77590000E-04  -1.20200000E-04  +7.34800000E-05
   -9.68700000E-05  -3.82670000E-04  -4.61800000E-05  +3.57050000E-04  +1.98630000E-04
   -1.02820000E-04  -1.02560000E-04  -6.03500000E-05  -2.58000000E-06  -1.03100000E-05
   +1.52730000E-04  +1.00000000E-06  -6.98800000E-05  +5.59800000E-05  +2.48100000E-05
   -1.29000000E-05  +6.91000000E-06  +6.09000000E-06  +4.20000000E-06  -4.53000000E-06
   -7.03000000E-06  +3.95400000E-05  -4.80500000E-05  +4.92500000E-05  +3.52000000E-05
   -1.29700000E-05  +2.63000000E-06  +2.16600000E-05  -4.36000000E-06  -4.88000000E-06
   +1.88291190E-01  +1.37120000E-04  +1.40700000E-04  -1.41620000E-04  +7.59370000E-04
   +5.93080000E-04  -2.69110000E-04  -3.58630000E-04  -1.85940000E-04  -8.44500000E-05
   +3.78470000E-04  +1.13860000E-04  +8.27300000E-05  -1.41190000E-04  -1.93200000E-04
   -3.21200000E-05  -1.43010000E-04  -7.91000000E-06  +6.65200000E-05  +1.63170000E-02
   +1.10138000E-03  +1.76400800E-02  -2.52873300E-02  -5.09183000E-02  -2.72958300E-02
   +1.78770000E-04  -5.38000000E-06  -7.19600000E-05  -1.54712000E-03  -3.99140000E-03
   +2.75058000E-03  +1.06154000E-03  +5.69380000E-04  +9.39610000E-04  -1.35770000E-04
   -1.43740000E-04  +2.66410000E-04  -2.08560000E-04  +3.74000000E-06  +1.31410000E-04
   +1.10520000E-04  -3.55300000E-05  -8.75900000E-05  +9.67300000E-04  +1.16312000E-03
   +1.00132000E-03  -6.44540000E-04  -1.73050000E-04  +1.55180000E-04  +7.93000000E-06
   +1.76420000E-04  -1.98720000E-04  +7.48100000E-05  +1.16840000E-04  +2.48000000E-06
   +1.17160000E-04  +1.01940000E-04  -6.51400000E-05  +1.91500000E-05  +4.93900000E-05
   -3.53800000E-05  -1.72200000E-05  +1.72400000E-05  +3.42000000E-06  -8.06000000E-06
   -2.39000000E-06  -2.14400000E-05  -4.85100000E-05  +1.00600000E-04  -7.07000000E-06
   -3.12500000E-05  -7.56600000E-05  +1.06400000E-05  +2.57000000E-06  +9.21000000E-06
   +5.40000000E-06  +2.79083600E-02  +5.59588600E-02  +3.41510000E-04  +2.84300000E-05
   +1.44230000E-04  -1.18821000E-03  -2.74010000E-04  +7.86950000E-04  +3.24220000E-04
   -6.16750000E-04  -1.96370000E-04  -1.49240000E-04  -4.14800000E-05  -5.66000000E-06
   +2.49780000E-04  +1.16420000E-04  -8.47500000E-05  +1.47620000E-04  +1.07440000E-04
   -1.98700000E-05  -1.50446900E-02  -2.72739000E-03  -1.80487500E-02  -1.32828500E-01
   -2.58057500E-02  -1.83301230E-01  -2.40450000E-04  +2.48000000E-05  +1.35150000E-04
   +1.51380000E-03  +3.66582000E-03  -2.10936000E-03  -1.29647000E-03  -4.16090000E-04
   -5.47140000E-04  +2.57060000E-04  +2.30340000E-04  -3.03460000E-04  +1.72500000E-04
   -2.17560000E-04  -1.71480000E-04  -1.39260000E-04  +1.60080000E-04  +1.36910000E-04
   +9.05100000E-05  -1.46491000E-03  +4.74010000E-04  +1.20600000E-04  +3.34470000E-04
   -7.83900000E-05  +4.41810000E-04  +1.04220000E-04  +4.85940000E-04  -3.88680000E-04
   -2.50670000E-04  +1.49700000E-05  -2.04980000E-04  +1.27840000E-04  +7.13800000E-05
   -8.82200000E-05  -2.94800000E-05  +9.87800000E-05  +1.62600000E-05  -1.58500000E-05
   -3.28700000E-05  -1.02700000E-05  +1.17500000E-05  -1.12800000E-05  -5.24500000E-05
   +1.50320000E-04  +9.66200000E-05  -1.06500000E-05  +5.27200000E-05  -2.36700000E-05
   +2.64000000E-06  -3.43000000E-06  -1.24300000E-05  +1.45152440E-01  +2.50037600E-02
   +1.99628070E-01  +5.32890000E-04  +3.26200000E-04  +3.65380000E-04  +3.39810000E-04
   -1.19145000E-03  +1.26111000E-03  +2.45070000E-04  -5.30090000E-04  -1.70990000E-04
   -1.50440000E-04  -9.00400000E-05  -5.35100000E-05  +4.04120000E-04  -8.86300000E-05
   -1.86810000E-04  -2.11280000E-04  +1.68540000E-04  +6.60800000E-05  -3.46360000E-03
   +5.00930000E-04  +5.35870000E-04  -2.64343470E-01  +1.27926700E-02  +1.01284870E-01
   -4.82130000E-04  +6.32200000E-05  +2.06180000E-04  -2.45900000E-04  -3.05950000E-04
   -3.09710000E-04  +8.92900000E-05  +9.09900000E-05  +2.10070000E-04  +2.72600000E-05
   +4.20000000E-07  -1.71000000E-06  -7.87600000E-05  +4.33000000E-06  +8.31700000E-05
   +5.27600000E-05  -2.35200000E-05  -6.76400000E-05  +3.70510000E-04  +6.00060000E-04
   -3.92190000E-04  +1.74400000E-05  -4.61690000E-04  -5.88660000E-04  -8.30000000E-06
   +2.00570000E-04  -3.27050000E-04  +1.65690000E-04  +8.59400000E-05  -3.02800000E-05
   +9.69400000E-05  -2.50000000E-06  -4.28900000E-05  +3.00700000E-05  +3.56100000E-05
   -5.99500000E-05  +4.37800000E-05  -3.58800000E-05  -3.88500000E-05  -3.84400000E-05
   +2.66300000E-05  +1.25000000E-05  -1.76900000E-05  +4.48900000E-05  -4.36100000E-05
   -2.19400000E-05  -5.63900000E-05  -3.30000000E-05  -4.34600000E-05  +9.02000000E-06
   -9.34000000E-06  -1.84988700E-02  +1.80341000E-03  +1.02021400E-02  +2.87408030E-01
   -6.67830000E-04  +1.85290000E-04  +4.00660000E-04  +5.71810000E-04  -3.03962000E-03
   +2.77041000E-03  +1.13050000E-04  -1.24880000E-04  -3.91970000E-04  -6.12160000E-04
   +3.61700000E-05  -1.77940000E-04  +3.78670000E-04  +2.22530000E-04  +2.75700000E-05
   -4.77200000E-05  +1.59050000E-04  -3.00580000E-04  -2.18164900E-02  -2.47200000E-05
   +9.33861000E-03  +1.37596100E-02  -4.93593900E-02  -7.11921000E-03  -4.32510000E-04
   +3.48900000E-05  +2.23450000E-04  -1.00680000E-04  +4.75950000E-04  -5.97230000E-04
   -1.76000000E-06  -1.80910000E-04  -1.63850000E-04  -1.90000000E-07  -2.78600000E-05
   -2.74000000E-06  -2.60800000E-05  +1.28530000E-04  +1.02200000E-04  +1.55500000E-05
   -7.25400000E-05  -1.12820000E-04  -1.24948000E-03  +1.11155000E-03  +4.34240000E-04
   +3.17430000E-04  +4.97440000E-04  -3.02950000E-04  +1.08600000E-04  +4.24200000E-05
   +1.85810000E-04  -1.22520000E-04  -1.37750000E-04  +7.34100000E-05  -4.78000000E-05
   -8.74600000E-05  -3.63200000E-05  -2.30600000E-05  -1.38900000E-04  -8.64000000E-06
   +8.05000000E-06  -4.50400000E-05  -1.67800000E-05  -3.93200000E-05  +1.79200000E-05
   +9.30000000E-06  +1.62400000E-04  +4.66700000E-05  +4.69930000E-04  +3.00000000E-06
   -1.02170000E-04  +1.33290000E-04  -6.16300000E-05  -6.90000000E-06  +2.04500000E-05
   -4.23888000E-03  -6.32170000E-04  +2.25515000E-03  -1.32064100E-02  +5.11674500E-02
   -4.00000000E-05  -3.54100000E-04  -5.19130000E-04  +1.30880000E-04  +3.67586000E-03
   -2.05692000E-03  +3.76370000E-04  +1.66690000E-04  -5.46900000E-05  -1.99250000E-04
   +3.04300000E-05  +8.93200000E-05  -2.51710000E-04  +4.48470000E-04  +2.80350000E-04
   +6.20350000E-04  -3.08710000E-04  -4.84000000E-05  +2.02382900E-02  -2.02971000E-03
   -9.53736000E-03  +1.00120240E-01  -5.84561000E-03  -9.40353500E-02  +4.85980000E-04
   -1.07860000E-04  -2.05580000E-04  +1.06534000E-03  -1.49100000E-05  +6.95770000E-04
   -1.14940000E-04  +7.96300000E-05  -3.48000000E-06  -6.00000000E-05  -2.91000000E-05
   +2.18500000E-05  +7.60600000E-05  +2.74280000E-04  -3.98000000E-06  +1.44200000E-05
   -1.49220000E-04  -2.13300000E-05  +1.19090000E-04  -1.34929000E-03  +4.93840000E-04
   -2.26540000E-04  +1.40450000E-04  -5.04630000E-04  -3.60210000E-04  -2.84380000E-04
   +1.15780000E-04  +8.75200000E-05  +4.44100000E-05  +5.63400000E-05  -2.21200000E-05
   -2.10910000E-04  +5.75900000E-05  +9.98200000E-05  -9.38000000E-05  -4.13000000E-06
   -3.20600000E-05  +4.24500000E-05  +2.09500000E-05  +2.82000000E-05  -2.32400000E-05
   -3.58700000E-05  -2.82300000E-05  -5.87800000E-05  +1.80940000E-04  -3.93700000E-05
   +1.21950000E-04  -8.97400000E-05  +9.08300000E-05  -3.48000000E-05  +2.60700000E-05
   -2.09436300E-02  +1.69426000E-03  +1.10667900E-02  -1.10593510E-01  +4.56403000E-03
   +1.00981310E-01  -2.38370000E-04  -4.60300000E-05  +2.71900000E-05  +3.69050000E-04
   -5.86060000E-04  -7.45950000E-04  -3.39890000E-04  -2.22200000E-04  +3.23850000E-04
   -2.55040000E-04  +7.19700000E-05  +1.31500000E-05  -5.47500000E-05  +1.44250000E-04
   +9.89200000E-05  +1.77000000E-04  -8.97800000E-05  -5.06700000E-05  -1.57611000E-03
   -3.41244000E-03  -1.81358000E-03  -5.21179800E-02  +3.23818600E-02  +1.50390200E-02
   +1.02770000E-04  -4.22000000E-06  -4.39900000E-05  +3.58630000E-04  +7.38390000E-04
   +2.46540000E-04  +1.32200000E-05  -2.72600000E-05  -8.10300000E-05  -5.68500000E-05
   -1.88900000E-05  +4.96400000E-05  -2.54200000E-05  +1.76780000E-04  +7.42400000E-05
   +4.56200000E-05  -1.18040000E-04  -8.31800000E-05  -1.09710000E-04  -4.18540000E-04
   +2.46550000E-04  -1.99700000E-05  +4.28480000E-04  -4.88660000E-04  -1.60920000E-04
   -1.40910000E-04  +5.28900000E-05  +9.14000000E-05  -2.49400000E-05  +2.65900000E-05
   +4.19400000E-05  -1.56820000E-04  -3.80300000E-05  +4.31200000E-05  -8.98600000E-05
   -5.60600000E-05  -2.09300000E-05  -1.00000000E-06  +2.07000000E-05  +1.47100000E-05
   -2.01200000E-05  +2.38000000E-05  -2.92100000E-05  -1.22340000E-04  +7.20630000E-04
   +3.32600000E-05  +5.38200000E-05  -5.44000000E-06  +2.99000000E-06  +4.91000000E-06
   -3.50000000E-06  +3.25147000E-03  -2.11574400E-02  -8.37442000E-03  -2.43486000E-03
   +2.68105800E-02  +1.09244600E-02  +5.35576700E-02  -7.54430000E-04  -2.65910000E-04
   -5.88900000E-05  +1.49462000E-03  +5.49200000E-04  -4.70130000E-04  +1.06050000E-04
   -1.43820000E-04  -7.65370000E-04  -6.12180000E-04  +2.48770000E-04  +1.24270000E-04
   +1.44990000E-04  +4.70970000E-04  +2.86700000E-04  +4.81070000E-04  -1.28790000E-04
   -2.37390000E-04  +2.97727000E-03  -2.00008000E-02  -1.03564200E-02  +3.12524400E-02
   -2.67895480E-01  -9.63636500E-02  +5.39300000E-05  -1.29200000E-05  +6.05000000E-06
   -1.09879000E-03  -2.69100000E-05  -1.26270000E-03  -1.67200000E-05  +2.06580000E-04
   +2.14930000E-04  -2.10000000E-06  +8.39200000E-05  -1.58200000E-05  -7.96100000E-05
   -3.26770000E-04  -1.21650000E-04  +2.36000000E-05  +1.68990000E-04  +1.46620000E-04
   -1.19102000E-03  -3.13777000E-03  +4.91819000E-03  -2.06440000E-04  +5.65810000E-04
   +2.13170000E-04  +2.26500000E-04  +2.05080000E-04  -1.63100000E-04  -1.64400000E-05
   +9.58700000E-05  +3.82800000E-05  +4.88400000E-05  +2.53310000E-04  +1.29300000E-05
   +5.31000000E-06  +9.13300000E-05  +6.01000000E-06  -2.63500000E-05  -2.77000000E-06
   +7.95000000E-06  -3.78600000E-05  -2.66000000E-06  -9.43000000E-06  +1.48350000E-04
   +3.57270000E-04  +4.64050000E-04  +1.38930000E-04  +9.37100000E-05  +2.45600000E-05
   -5.40000000E-07  -1.70800000E-05  +2.00900000E-05  +7.20590000E-04  -3.00510000E-03
   -1.01072000E-03  -3.09780000E-04  +1.12720000E-04  +2.90310000E-04  -3.43683300E-02
   +2.92163200E-01  +2.42340000E-04  -3.37700000E-05  +8.63100000E-05  -7.84180000E-04
   -1.92470000E-04  +7.60850000E-04  +5.02400000E-04  +7.10770000E-04  -2.92810000E-04
   +3.00100000E-05  -1.46380000E-04  -1.51030000E-04  +1.35500000E-05  -1.92450000E-04
   -4.46100000E-05  -1.73120000E-04  +1.29610000E-04  +8.81800000E-05  -2.93520000E-03
   +2.03398400E-02  +9.45037000E-03  +1.54372000E-02  -9.85190700E-02  -9.05889100E-02
   -1.53630000E-04  +1.91000000E-05  +4.57500000E-05  -1.04370000E-04  -1.73830000E-04
   +1.05681000E-03  +3.49330000E-04  -1.03470000E-04  +3.76300000E-05  -1.76000000E-06
   -2.82000000E-05  +8.98700000E-05  +1.29100000E-05  +9.88400000E-05  +3.29600000E-05
   +3.28000000E-06  -6.61000000E-05  -3.41600000E-05  +5.12400000E-04  +2.80242000E-03
   -2.99470000E-03  -8.57620000E-04  -8.54800000E-05  -1.15960000E-04  -1.63650000E-04
   -5.05100000E-05  -1.95440000E-04  +1.41190000E-04  +1.48250000E-04  -2.54700000E-05
   +3.37600000E-05  -9.36200000E-05  +8.58000000E-06  +2.69900000E-05  +4.29600000E-05
   -6.82000000E-06  +1.90700000E-05  -1.63800000E-05  -2.46000000E-06  +3.92000000E-06
   +2.16200000E-05  -7.10000000E-07  +5.37560000E-04  +1.16590000E-04  -1.12064000E-03
   -3.84600000E-05  +3.03000000E-06  -2.63900000E-05  -1.15700000E-05  +7.50000000E-06
   -1.42100000E-05  +4.45907000E-03  -2.03874900E-02  -8.86406000E-03  -3.35200000E-05
   -1.11847600E-02  -5.83481000E-03  -1.60065000E-02  +1.05174360E-01  +9.83490200E-02
   -5.22990000E-04  +7.48180000E-04  +1.84410000E-04  +4.01650000E-04  +7.24700000E-05
   -5.86570000E-04  -3.53900000E-05  +2.63200000E-05  +4.58200000E-05  +1.69320000E-04
   -3.22100000E-05  -7.69100000E-05  -1.12560000E-04  -7.48600000E-05  +2.27400000E-05
   -9.36000000E-05  -1.81910000E-04  +7.46000000E-06  -8.05100000E-04  +4.92221000E-03
   -4.60792000E-03  -3.27290000E-04  +1.13795000E-03  +5.56490000E-04  +1.43260000E-04
   -4.20000000E-05  -8.00700000E-05  -1.11830000E-04  -9.17220000E-04  +4.53330000E-04
   +2.77840000E-04  -6.65200000E-05  -2.74500000E-04  -1.89200000E-04  +1.17850000E-04
   -1.16770000E-04  -3.67350000E-04  -9.92920000E-04  -2.93090000E-04  +2.55350000E-04
   +4.69700000E-04  +4.25910000E-04  -5.35577300E-02  -3.37817400E-02  +2.69918900E-02
   +3.25400000E-05  +3.42200000E-05  -1.29840000E-04  +3.87800000E-05  -2.36260000E-04
   +1.75100000E-05  +1.14140000E-04  +1.47600000E-04  -7.49500000E-05  +2.93210000E-04
   +6.30320000E-04  -8.94500000E-05  +8.98400000E-05  +1.02470000E-04  -1.35560000E-04
   -1.54400000E-05  +7.32000000E-06  +1.01400000E-05  +1.95500000E-05  -1.43600000E-05
   -1.01300000E-05  +1.64000000E-06  -5.07000000E-05  -4.56300000E-05  -1.82654000E-03
   +4.73720000E-04  -3.31070000E-04  -1.48400000E-05  +2.62100000E-05  -1.85100000E-05
   +1.37570000E-04  -1.71300000E-04  +3.31060000E-04  +2.82610000E-04  +2.12480000E-04
   -2.58980000E-04  +6.70860000E-04  +3.60680000E-04  -1.89600000E-04  +5.64683100E-02
   -2.96620000E-04  -9.02500000E-05  -3.23180000E-04  -1.03419000E-03  +1.05485000E-03
   +7.39770000E-04  +9.62200000E-05  -9.56400000E-05  -4.22500000E-04  -2.46840000E-04
   +3.10700000E-05  +1.14790000E-04  +6.67800000E-05  +1.64690000E-04  +1.43870000E-04
   +2.99320000E-04  +2.39090000E-04  -7.21800000E-05  -4.88490000E-03  -2.02366700E-02
   +1.76188500E-02  +1.11724000E-03  -4.60650000E-03  -4.01968000E-03  -2.59000000E-05
   +2.62500000E-05  +1.86300000E-05  +5.90800000E-04  -1.28570000E-04  +1.28687000E-03
   +2.81710000E-04  -1.69200000E-04  +2.90710000E-04  -1.38200000E-05  +8.78300000E-04
   +2.12560000E-04  -9.37240000E-04  -2.78820000E-04  +1.75410000E-04  +3.35960000E-04
   -1.13270000E-04  -1.43410000E-04  -3.37139300E-02  -2.09121060E-01  +1.28505890E-01
   -3.37410000E-04  -4.92200000E-05  -2.15880000E-04  +2.34530000E-04  -1.67570000E-04
   +2.57660000E-04  +1.97000000E-05  +8.49200000E-05  -1.30160000E-04  +3.50350000E-04
   +4.09390000E-04  -1.80070000E-04  +8.51100000E-05  +1.20550000E-04  -1.08290000E-04
   +6.24000000E-06  -7.11000000E-06  +6.31000000E-06  +1.29400000E-05  -2.11200000E-05
   +3.21800000E-05  -7.30000000E-06  +6.06000000E-05  +1.04310000E-04  +5.23910000E-04
   +3.27690000E-04  +2.95470000E-04  +2.06900000E-05  -7.74000000E-06  -2.22200000E-05
   +8.70800000E-05  +2.03550000E-04  -6.74300000E-05  -6.47800000E-05  +2.71820000E-04
   -1.63710000E-04  -1.43310000E-04  -1.42502000E-03  +1.23629000E-03  +3.61176600E-02
   +2.27619650E-01  +6.84750000E-04  +4.64930000E-04  +4.83820000E-04  -2.86600000E-05
   +4.49580000E-04  +5.53380000E-04  -2.34810000E-04  -1.69200000E-05  -7.14300000E-05
   -5.18700000E-05  -4.15100000E-05  -1.30800000E-05  +6.97500000E-05  +1.35430000E-04
   -1.34000000E-05  -9.62000000E-06  -3.07700000E-04  -1.52070000E-04  -3.27189000E-03
   -1.18703800E-02  +9.86509000E-03  +3.07310000E-04  -2.12847000E-03  -1.16222000E-03
   -5.21000000E-06  -4.89100000E-05  -3.02200000E-05  -1.70580000E-04  -1.47220000E-04
   +8.96130000E-04  -7.33440000E-04  -7.91240000E-04  -1.29963000E-03  -3.22190000E-04
   -1.81550000E-04  -7.54690000E-04  -1.28190000E-04  +1.18350000E-04  +1.08100000E-04
   +2.12710000E-04  -1.40000000E-04  -1.20590000E-04  +2.73525500E-02  +1.31480420E-01
   -1.53570240E-01  +1.13110000E-04  +1.10840000E-04  +8.70000000E-06  -5.87400000E-05
   -9.72700000E-05  -1.32310000E-04  +6.66800000E-05  +8.95000000E-05  +1.03700000E-05
   +1.06120000E-04  -3.97700000E-05  -3.09000000E-05  +5.06000000E-05  +8.09000000E-06
   -2.75500000E-05  +6.59000000E-06  -3.28000000E-06  -3.31000000E-06  -8.70000000E-06
   -9.38000000E-06  +8.66000000E-06  +5.46000000E-06  -4.76500000E-05  +1.42600000E-05
   +1.23400000E-05  -2.73190000E-04  -1.93720000E-04  +4.90000000E-06  -7.53000000E-06
   +4.33600000E-05  +2.71060000E-04  -2.12170000E-04  +1.52270000E-04  -1.81010000E-04
   -1.55230000E-04  -6.62000000E-05  +3.15000000E-05  -7.35210000E-04  +7.48780000E-04
   -3.02346400E-02  -1.40398140E-01  +1.65000330E-01  -3.96100000E-05  -3.72910000E-04
   -1.22990000E-04  +7.88410000E-04  +4.80980000E-04  +2.83930000E-04  -7.70800000E-05
   -2.94510000E-04  -6.56000000E-05  -1.12330000E-04  +1.33510000E-04  +6.29700000E-05
   +1.44050000E-04  +2.47900000E-05  -3.96200000E-05  +1.20330000E-04  +2.10600000E-04
   +9.82500000E-05  -4.62791000E-03  -5.54330000E-04  +1.28019000E-03  +8.57900000E-05
   -5.41050000E-04  -1.85650000E-04  -1.97380000E-04  +5.42300000E-05  +1.00590000E-04
   +3.14870000E-04  -4.72500000E-05  -8.63690000E-04  +1.32310000E-04  -1.51460000E-04
   +4.19440000E-04  -5.63800000E-05  +1.03010000E-04  +8.24100000E-05  -6.21600000E-05
   +6.57200000E-05  +1.01980000E-04  -2.88600000E-05  -4.53800000E-05  -1.23900000E-04
   -2.96433650E-01  +6.25799000E-03  +7.45213700E-02  +3.34780000E-04  +7.74000000E-06
   +2.06140000E-04  -1.63900000E-05  +1.04780000E-04  +7.80000000E-05  +5.21100000E-05
   +8.44000000E-06  -2.51900000E-05  +1.43700000E-05  -2.32000000E-05  -3.26000000E-06
   +2.51700000E-05  +1.71800000E-05  -8.12000000E-06  +2.19000000E-05  -1.15900000E-05
   -1.59200000E-05  -4.16100000E-05  +1.60800000E-05  +9.01000000E-06  +5.89900000E-05
   +7.13200000E-05  +5.40800000E-05  +1.52560000E-04  +4.40390000E-04  +8.94900000E-05
   -8.19000000E-06  -1.19000000E-05  +6.20000000E-07  +1.32800000E-05  -3.54000000E-05
   +1.15320000E-04  +3.67280000E-04  +4.73150000E-04  -3.56450000E-04  +3.70410000E-04
   -1.13800000E-05  -1.22280000E-04  -4.02517000E-03  +3.35370000E-04  +3.22550000E-04
   +3.18500070E-01  -8.98440000E-04  -6.72000000E-04  -3.13040000E-04  -7.93760000E-04
   -5.13080000E-03  -2.18478000E-03  +1.77079000E-03  +3.20460000E-04  -5.66880000E-04
   -4.08400000E-05  -3.31130000E-04  -2.07110000E-04  -1.74010000E-04  -4.52000000E-06
   +8.56000000E-05  +1.99610000E-04  +2.88260000E-04  +3.21900000E-05  +2.76965700E-02
   -2.32077000E-03  -8.68627000E-03  +1.25767000E-03  +1.30140000E-03  -6.21440000E-04
   +1.51300000E-04  +3.53300000E-05  -2.59800000E-05  +1.19965000E-03  +6.95780000E-04
   +5.23700000E-05  -1.50980000E-04  -1.11300000E-04  -1.12810000E-04  +3.10500000E-05
   +3.08200000E-05  +1.51400000E-05  +1.41000000E-05  +1.07027000E-03  +3.35750000E-04
   +5.59800000E-05  -5.75940000E-04  -5.59450000E-04  +4.57286000E-03  -4.68956500E-02
   -9.26800000E-04  +7.43500000E-05  +2.45340000E-04  +4.80020000E-04  -4.05590000E-04
   -3.23700000E-05  -3.56920000E-04  +1.40530000E-04  +9.21000000E-05  +4.88800000E-05
   -9.32200000E-05  -6.55100000E-04  +2.70600000E-05  +3.85100000E-05  -1.15690000E-04
   +1.74000000E-05  -2.83300000E-05  +8.38000000E-06  +1.55400000E-05  +1.47040000E-04
   -2.96200000E-05  -4.66500000E-05  -1.93300000E-05  +5.95000000E-06  +2.64200000E-05
   +3.31500000E-05  +3.93000000E-04  +4.34810000E-04  +3.26300000E-05  +2.50000000E-07
   -2.37300000E-05  -6.20300000E-05  -9.11800000E-05  +2.11300000E-05  -3.96320000E-04
   -6.47880000E-04  +3.99390000E-04  -3.54940000E-04  +2.69690000E-04  +2.84900000E-05
   -2.44179600E-02  +1.24072000E-03  +6.07760000E-03  -6.82197000E-03  +5.25198400E-02
   -3.22000000E-04  -4.50410000E-04  +1.26660000E-04  -4.08220000E-04  -3.08998000E-03
   -8.37440000E-04  +1.00042000E-03  +1.19070000E-04  +1.15740000E-04  +9.71800000E-05
   -1.39270000E-04  -2.20980000E-04  -2.15620000E-04  -6.80100000E-05  -2.80000000E-07
   +6.19000000E-05  +6.42300000E-05  +1.48730000E-04  +1.43041900E-02  -6.16550000E-04
   -6.65867000E-03  -6.02210000E-04  +8.76800000E-04  +4.88600000E-05  +1.90440000E-04
   +7.92000000E-06  -6.88100000E-05  +1.55885000E-03  -2.43220000E-04  -7.35800000E-05
   +1.09950000E-04  +1.26180000E-04  +1.25790000E-04  -8.31200000E-05  +3.13000000E-05
   -9.84100000E-05  +1.91000000E-06  -5.05130000E-04  -6.47180000E-04  +9.19000000E-06
   +2.01310000E-04  +5.41220000E-04  +7.31197100E-02  -1.50415000E-03  -6.92520000E-02
   -1.30160000E-04  +1.82250000E-04  +3.47850000E-04  -2.72620000E-04  -3.05550000E-04
   -3.04670000E-04  +2.51770000E-04  +2.54160000E-04  -3.71100000E-05  +1.52710000E-04
   +2.28220000E-04  +9.35400000E-05  +1.58660000E-04  +1.03370000E-04  -1.25490000E-04
   -2.82100000E-05  +1.40500000E-05  +1.37500000E-05  +7.36600000E-05  +1.23000000E-05
   -8.88400000E-05  -2.70000000E-07  -4.83100000E-05  +4.91700000E-05  -1.16390000E-04
   +3.09520000E-04  -2.42470000E-04  +3.49900000E-05  -1.28600000E-05  +1.68600000E-05
   -1.23840000E-04  -1.57700000E-05  +5.97800000E-05  -1.02350000E-04  +1.73180000E-04
   +4.28450000E-04  -9.42700000E-05  +7.21000000E-06  -1.20850000E-04  +1.93784200E-02
   -1.24836000E-03  -5.67604000E-03  -8.18788600E-02  +5.06621000E-03  +7.29242100E-02
   -7.80490000E-04  -2.14930000E-04  +7.81370000E-04  +2.89510000E-04  -4.04450000E-04
   +9.41000000E-05  +3.48400000E-05  +7.74900000E-05  -3.89500000E-05  +1.30410000E-04
   +1.01400000E-05  -5.03000000E-05  -1.86220000E-04  -5.40400000E-05  -4.38000000E-05
   -1.98700000E-05  +1.17990000E-04  +2.22500000E-05  +3.43544000E-03  +1.11028000E-03
   +6.01314000E-03  +2.20350000E-04  +3.01500000E-05  +2.30740000E-04  +1.43660000E-04
   -7.06000000E-06  -4.76100000E-05  -2.98710000E-04  +8.52930000E-04  +1.50540000E-04
   +1.20460000E-04  -1.91620000E-04  +2.37820000E-04  -5.32800000E-05  +5.19400000E-05
   +1.10700000E-04  +3.95500000E-05  +2.16700000E-04  +2.87760000E-04  -5.06300000E-05
   -4.12700000E-05  -2.55050000E-04  -1.37743630E-01  -1.55409400E-02  -1.26713770E-01
   +5.76940000E-04  -6.95600000E-05  -6.48000000E-05  +2.95430000E-04  +1.18590000E-04
   +1.09650000E-04  -1.58050000E-04  -8.41500000E-05  +5.22500000E-05  -9.91000000E-05
   -1.15370000E-04  -3.33300000E-05  -9.95600000E-05  -6.29500000E-05  +6.57300000E-05
   -1.88600000E-05  +9.30000000E-06  +1.08800000E-05  +2.15600000E-05  -6.26000000E-06
   -1.50000000E-05  +2.57000000E-06  -3.91500000E-05  -1.07900000E-05  -1.49836000E-03
   +4.17600000E-05  +1.45965000E-03  +2.53700000E-05  -2.05200000E-05  +3.44600000E-05
   +2.61910000E-04  -1.90190000E-04  +4.68900000E-05  -1.98030000E-04  -5.64300000E-05
   -1.67060000E-04  +3.73600000E-05  -3.71500000E-05  +2.73020000E-04  +2.86643000E-03
   +1.10281000E-03  +5.82475000E-03  -1.58182100E-02  -2.75009000E-03  -2.57780000E-02
   +1.48368820E-01  +2.02990000E-04  +3.77220000E-04  +2.87790000E-04  -3.57260000E-04
   +1.01799000E-03  +7.25080000E-04  +6.45500000E-05  -3.07610000E-04  +6.06200000E-05
   -1.83630000E-04  -1.13900000E-05  +6.83500000E-05  +1.34080000E-04  +1.95210000E-04
   +6.34800000E-05  +1.90040000E-04  -1.08650000E-04  -7.88700000E-05  -1.72299800E-02
   -5.46924000E-03  -2.44550800E-02  -8.86840000E-04  +1.09474000E-03  -1.20051000E-03
   -6.76500000E-05  -1.72400000E-05  +1.56000000E-05  +2.89235000E-03  -4.76673000E-03
   -6.55700000E-04  +2.59010000E-04  -1.12010000E-04  +5.92610000E-04  -1.17600000E-05
   +4.41600000E-04  +1.40220000E-04  -6.78800000E-04  -8.77380000E-04  -1.62880000E-04
   +1.87460000E-04  +3.84450000E-04  +2.24830000E-04  -1.52103200E-02  -4.90747800E-02
   -1.94571100E-02  -1.74584000E-03  -2.59510000E-04  -1.63622000E-03  +4.44840000E-04
   +2.12190000E-04  +1.43490000E-03  -4.93620000E-04  -5.20850000E-04  -1.85680000E-04
   +8.62800000E-05  +8.94820000E-04  -6.23700000E-05  -2.99900000E-05  +7.67800000E-05
   +3.88500000E-05  +1.12300000E-05  -4.68000000E-06  -1.35700000E-05  -2.19300000E-05
   +1.02400000E-05  -2.17800000E-05  -4.81600000E-05  +5.47600000E-05  -2.34700000E-05
   +8.83000000E-06  +1.97560000E-04  +3.11900000E-05  -4.79000000E-06  +1.03500000E-05
   -1.93100000E-05  +4.63030000E-04  -8.04410000E-04  +4.20920000E-04  -6.75400000E-05
   -6.37700000E-05  +9.29700000E-05  +1.84050000E-04  +4.68000000E-04  +1.50500000E-04
   +1.55172400E-02  +3.89793000E-03  +1.88719100E-02  +1.02330000E-04  -8.75240000E-04
   +7.12450000E-04  +1.59983800E-02  +5.41790000E-02  -1.46160000E-04  -9.81470000E-04
   -1.80960000E-04  -6.62250000E-04  +4.08490000E-04  +2.85170000E-04  +3.15850000E-04
   -1.23780000E-04  -1.39000000E-05  -1.50800000E-04  +6.39800000E-05  +9.96900000E-05
   +1.10000000E-05  +5.56800000E-05  -4.00400000E-05  +2.46300000E-04  +4.19150000E-04
   +2.31300000E-04  -8.53469000E-03  -7.64150000E-04  -1.24914700E-02  -1.67200000E-05
   +1.45213000E-03  +5.03890000E-04  -9.78700000E-05  +7.52700000E-05  +8.69900000E-05
   +1.26864000E-03  -2.62819000E-03  -4.70650000E-04  -5.25650000E-04  -2.67150000E-04
   -1.08780000E-04  +3.06270000E-04  -3.11550000E-04  -3.18400000E-05  +3.46300000E-04
   -1.34440000E-04  -1.95150000E-04  -2.21500000E-04  +1.71530000E-04  +1.65500000E-04
   -1.25380340E-01  -2.08951100E-02  -2.22670010E-01  -4.35590000E-04  +4.23700000E-05
   -7.35340000E-04  +1.40680000E-04  +1.37090000E-04  +5.31440000E-04  -3.66270000E-04
   -3.31980000E-04  -2.55200000E-05  -2.60300000E-04  +1.09980000E-04  +9.85500000E-05
   -1.20760000E-04  -2.49300000E-05  +1.23840000E-04  +4.07000000E-06  -1.75000000E-06
   -1.11500000E-05  -5.57000000E-06  +2.00600000E-05  -1.52600000E-05  -3.48700000E-05
   +1.19610000E-04  +2.88000000E-05  +1.07294000E-03  +6.97070000E-04  -5.68110000E-04
   +2.66700000E-05  -2.10900000E-05  -1.98500000E-05  +1.20260000E-04  -1.61120000E-04
   +6.93240000E-04  +9.67200000E-05  -1.20250000E-04  -2.73700000E-05  +3.03580000E-04
   +8.54200000E-05  +1.47730000E-04  -1.11292700E-02  -3.38827000E-03  -1.43544300E-02
   +6.01079000E-03  +1.41078000E-03  +8.92140000E-03  +1.37540390E-01  +2.47804000E-02
   +2.40320150E-01  -7.83800000E-05  +2.03950000E-04  +4.34000000E-06  -4.62370000E-04
   -2.03890000E-04  -6.70470000E-04  -1.02460000E-04  -2.76930000E-04  -1.80260000E-04
   +3.51500000E-05  +1.04490000E-04  +2.40300000E-05  -2.57000000E-06  -5.76000000E-05
   -3.46200000E-05  -1.68400000E-05  -1.06200000E-05  +6.63300000E-05  -2.02271000E-03
   +2.43687000E-03  +2.85978000E-03  -1.18001000E-03  -1.11736000E-03  -1.37566000E-03
   -9.00000000E-08  +2.87800000E-05  +1.03700000E-05  +2.89814000E-03  -1.46021000E-02
   +1.66617800E-02  +2.89079000E-03  -5.42954000E-03  -4.72060000E-03  -6.35530000E-04
   -4.90790000E-04  +1.29189000E-03  -1.85895000E-03  -1.25167000E-03  -2.21900000E-04
   +8.18310000E-04  +1.23290000E-04  -8.43800000E-05  +6.17120000E-04  +3.07570000E-04
   +2.89890000E-04  -5.21259400E-02  -2.78865000E-02  +1.25886500E-02  +7.02163000E-03
   +1.29272700E-02  -1.52464000E-02  -5.90980000E-04  -7.28800000E-05  +2.83847000E-03
   -3.06470000E-04  +1.21079000E-03  +2.03210000E-04  +1.02510000E-04  -2.35460000E-04
   +1.13840000E-04  -1.31700000E-05  -9.29000000E-06  +6.29000000E-06  -9.74000000E-06
   -6.88000000E-06  +1.08400000E-05  +1.08000000E-05  +3.46600000E-05  +1.37890000E-04
   +5.45000000E-06  +9.74000000E-06  +1.29000000E-06  -4.68000000E-06  -3.59000000E-06
   +2.50700000E-05  -1.36300000E-05  +3.24260000E-04  +2.49800000E-04  -1.46960000E-04
   -1.76730000E-04  -6.42140000E-04  -1.57523000E-03  +5.43380000E-04  -9.88490000E-04
   +2.09400000E-05  +1.40230000E-04  +4.21800000E-05  +4.09100000E-05  -2.46700000E-05
   +5.74900000E-05  -7.59800000E-05  +1.22180000E-04  +1.39600000E-05  +4.83738900E-02
   +7.65400000E-05  -1.23700000E-04  -6.32000000E-05  +3.74340000E-04  +3.72910000E-04
   +4.22140000E-04  +3.79400000E-05  +1.15930000E-04  +6.11000000E-06  -8.93000000E-06
   -5.65000000E-06  -3.14300000E-05  -3.38100000E-05  +4.16200000E-05  +6.35800000E-05
   +6.05700000E-05  -7.79000000E-06  -6.87200000E-05  +3.45667000E-03  -2.37126000E-03
   -4.37700000E-04  +7.99500000E-05  +5.70760000E-04  +7.56290000E-04  +7.70000000E-05
   -2.06800000E-05  -4.61200000E-05  -2.97426000E-03  -1.34198600E-02  +1.82649500E-02
   -7.72096000E-03  +2.69226000E-03  +1.60425000E-03  +4.81270000E-04  +5.16920000E-04
   -6.71330000E-04  -2.63000000E-06  +3.92270000E-04  +3.12200000E-04  +5.84000000E-05
   -1.49100000E-04  -2.22830000E-04  -7.38710000E-04  -1.00650000E-04  -5.35700000E-04
   -2.68108200E-02  -1.68860390E-01  +1.47021250E-01  -5.23114000E-03  +2.84466000E-03
   -6.15167000E-03  +3.46119000E-03  +1.03082000E-03  -1.09841000E-03  +9.30190000E-04
   -4.09860000E-04  -3.05420000E-04  +1.34000000E-05  +2.12840000E-04  -2.84180000E-04
   +3.67000000E-06  +5.34000000E-06  +1.03000000E-05  +1.26200000E-05  -5.33000000E-06
   -3.52000000E-06  +1.50000000E-06  -2.15700000E-05  +1.93600000E-05  -4.78000000E-06
   -1.32700000E-05  +2.03500000E-05  +1.49000000E-05  +1.00000000E-08  -9.40000000E-06
   +5.69170000E-04  +1.57380000E-04  -1.74290000E-04  +1.39290000E-04  -9.18800000E-05
   -9.59510000E-04  +4.04420000E-04  +2.37610000E-04  +3.65860000E-04  +6.13800000E-05
   +6.82300000E-05  +1.88000000E-06  +4.30000000E-06  -8.08800000E-05  -2.47500000E-05
   +2.57400000E-05  -2.33600000E-04  -1.12570000E-04  +3.52054800E-02  +1.77442300E-01
   +1.17910000E-04  -1.42170000E-04  -6.66200000E-05  +2.01070000E-04  +4.05120000E-04
   +4.88560000E-04  +1.00360000E-04  +1.99550000E-04  +4.48300000E-05  -1.47100000E-05
   -6.29200000E-05  -4.07200000E-05  -4.62700000E-05  +3.83800000E-05  +5.86000000E-05
   +3.79400000E-05  -6.60000000E-06  -4.65300000E-05  +1.44641000E-03  -1.58076000E-03
   -2.34113000E-03  -3.02083000E-03  -9.28370000E-04  -1.59520000E-03  +6.56500000E-05
   -2.93900000E-05  -3.96100000E-05  +1.03200000E-05  -1.08154000E-03  +5.46468000E-03
   -4.08972000E-03  +1.32243000E-03  +2.66297000E-03  +2.98010000E-04  +2.66930000E-04
   -6.87040000E-04  +3.39500000E-04  +1.20910000E-04  +7.37500000E-05  -1.82280000E-04
   +3.88300000E-05  +5.09400000E-05  -4.05830000E-04  -5.65500000E-05  -4.74400000E-04
   +1.58761100E-02  +1.46144200E-01  -2.07413180E-01  +4.12939000E-03  +1.89419100E-02
   -1.87497400E-02  +1.35355000E-03  -2.49249000E-03  +3.41893000E-03  -4.58000000E-06
   -2.47980000E-04  +1.62980000E-04  -4.36600000E-05  -3.73560000E-04  +9.60100000E-05
   +4.27000000E-06  +1.03900000E-05  +3.58000000E-06  +1.50700000E-05  +2.95000000E-06
   -1.29100000E-05  +8.51700000E-05  -2.43400000E-05  -5.46400000E-05  -1.60400000E-05
   -1.27000000E-05  +5.21000000E-06  +1.48600000E-05  +5.00000000E-08  -1.34400000E-05
   -3.11000000E-05  -4.89180000E-04  +7.22000000E-06  -1.07741000E-03  -4.45410000E-04
   -1.67218000E-03  -6.27490000E-04  -2.29610000E-04  -5.54460000E-04  +6.67000000E-06
   +2.91000000E-05  +6.95000000E-06  +1.20400000E-05  +6.63000000E-06  +1.62200000E-05
   +4.35400000E-05  -1.90920000E-04  -2.36000000E-06  -1.13641600E-02  -1.58776080E-01
   +2.23759620E-01  -4.03900000E-05  +9.40600000E-05  +4.22400000E-05  -5.24200000E-05
   -1.41470000E-04  -3.11400000E-04  -3.40300000E-05  -3.95900000E-05  +3.73800000E-05
   -1.30800000E-05  -2.11200000E-05  +1.02100000E-05  +6.65300000E-05  -4.66100000E-05
   -6.30900000E-05  -6.52000000E-05  +9.67000000E-06  +6.44800000E-05  -5.98630000E-04
   +2.58050000E-04  +5.88390000E-04  -6.85100000E-05  -6.79600000E-05  -8.34000000E-05
   -1.13890000E-04  +1.57400000E-05  +5.84800000E-05  +8.53280000E-04  +2.09510000E-03
   -5.67350000E-04  -8.21140000E-04  -4.94800000E-05  -1.09660000E-03  +4.09600000E-04
   -1.04254000E-03  +6.47340000E-04  -1.54432000E-03  -8.21560000E-04  +3.83400000E-04
   +2.44600000E-04  +9.23370000E-04  +2.83540000E-04  -6.96300000E-05  +2.24730000E-04
   -4.84900000E-05  +7.60136000E-03  -2.93270000E-04  -1.78736700E-02  -6.57743400E-02
   -2.77584200E-02  +5.30812200E-02  -1.32196200E-02  -2.36773800E-02  +2.65554300E-02
   -3.34019000E-03  +4.86820000E-03  +2.58419000E-03  -2.73230000E-04  -1.32420000E-04
   +2.97460000E-04  +6.19000000E-06  -4.94000000E-06  -1.38600000E-05  -1.79600000E-05
   +1.34700000E-05  +2.28000000E-06  +3.54900000E-05  -1.74700000E-05  -3.42200000E-05
   +3.60000000E-06  +9.52000000E-06  -2.03900000E-05  -1.51500000E-05  -1.94000000E-06
   +9.71000000E-06  -8.82700000E-05  -1.87100000E-05  -6.86000000E-06  -6.49600000E-05
   +1.15300000E-05  +8.52200000E-05  +3.71900000E-05  -1.58400000E-05  +5.88000000E-06
   -3.68600000E-05  -3.81500000E-05  +1.09200000E-05  +7.31000000E-06  +4.57200000E-05
   +1.49400000E-05  -1.06400000E-05  -6.32400000E-05  -2.94600000E-05  -5.77500000E-04
   -1.23159000E-03  -2.77102000E-03  +7.53426500E-02  +1.96800000E-05  -7.93500000E-05
   -3.24000000E-06  +7.39000000E-06  +2.00000000E-06  +1.83170000E-04  +5.62900000E-05
   +8.52900000E-05  +1.62900000E-05  +1.51500000E-05  +5.21000000E-06  -6.64000000E-06
   -6.25200000E-05  +3.15900000E-05  +4.27000000E-05  +2.39100000E-05  -2.35200000E-05
   -3.79700000E-05  +1.91960000E-04  -1.94070000E-04  -2.75320000E-04  -2.66500000E-05
   +7.92800000E-05  -1.84100000E-05  +8.92000000E-05  -1.90000000E-05  -4.68100000E-05
   -4.75420000E-04  -1.69524000E-03  +3.39790000E-04  -1.78622000E-03  -8.97620000E-04
   -4.02200000E-04  -6.89440000E-04  -2.44465000E-03  -2.81960000E-04  +3.52257000E-03
   +2.13105000E-03  -8.54110000E-04  -1.01287000E-03  -1.12442000E-03  +3.42600000E-05
   +3.01600000E-05  -1.06210000E-04  -6.13000000E-06  +8.31500000E-04  +1.23720400E-02
   +5.76090000E-04  -2.90480200E-02  -9.13740000E-02  +9.21526400E-02  -2.29267900E-02
   -1.19607700E-02  +2.39658200E-02  +3.65622000E-03  -6.35122000E-03  -4.29150000E-03
   +1.76770000E-04  +1.09174000E-03  -4.72590000E-04  -3.43000000E-06  +8.81000000E-06
   +1.16500000E-05  +2.19400000E-05  -9.29000000E-06  -4.18000000E-06  -1.62800000E-05
   +4.90000000E-06  +2.44700000E-05  -9.58000000E-06  -8.96000000E-06  +1.58000000E-06
   +6.31000000E-06  +1.64000000E-06  -8.19000000E-06  -1.28400000E-05  -8.56000000E-05
   +1.88500000E-05  -1.40200000E-05  +2.94200000E-05  +1.79700000E-05  +4.39300000E-05
   -7.73700000E-05  -2.62800000E-05  -1.66000000E-06  -1.50100000E-05  -1.45800000E-05
   -2.60000000E-06  -1.95600000E-05  -9.06000000E-06  +4.14000000E-06  +2.50900000E-05
   +2.47800000E-05  -2.28861000E-03  +9.46750000E-04  -4.37880000E-04  +5.01696800E-02
   +9.96284900E-02  -2.37500000E-05  +7.67000000E-06  +2.53000000E-05  +4.07800000E-05
   -4.46900000E-05  -1.03700000E-05  -3.64900000E-05  -4.06400000E-05  +3.56300000E-05
   +2.42000000E-06  +3.12000000E-06  +1.83000000E-05  -3.04000000E-05  -3.41000000E-06
   -5.20000000E-07  -6.95000000E-06  -1.98000000E-06  +6.12000000E-06  -9.17600000E-05
   -1.24240000E-04  -1.10680000E-04  -6.83700000E-05  -6.57000000E-06  -1.30260000E-04
   +1.60400000E-05  -1.19000000E-06  +1.09000000E-06  +2.43470000E-04  +1.28217000E-03
   -1.44840000E-04  -2.19260000E-04  -1.79680000E-04  +6.72340000E-04  +2.16740000E-04
   -3.99670000E-04  +2.04180000E-04  +7.99870000E-04  -6.68290000E-04  -4.75580000E-04
   -3.17340000E-04  +1.95260000E-04  +8.04100000E-05  +1.58900000E-05  +1.79500000E-05
   +6.90500000E-05  +5.91193000E-03  +1.38740300E-02  -1.48167000E-02  +5.39276700E-02
   +9.16750500E-02  -2.74842410E-01  +3.21045000E-03  +3.94937000E-03  +1.37687500E-02
   +8.29500000E-05  -7.76860000E-04  +7.26980000E-04  -1.60920000E-04  -1.93130000E-04
   +1.64400000E-04  -8.75000000E-06  +2.03000000E-06  -2.38000000E-06  -1.14300000E-05
   +5.69000000E-06  -5.05000000E-06  -2.87000000E-06  +2.27900000E-05  -6.64300000E-05
   -2.90000000E-07  +5.45000000E-06  -9.43000000E-06  -4.01000000E-06  +2.48000000E-06
   -5.00000000E-07  -8.49900000E-05  -8.29600000E-05  +1.99100000E-05  -9.33900000E-05
   +4.87600000E-05  +1.19170000E-04  +9.32200000E-05  -8.62200000E-05  -1.92800000E-05
   -2.88500000E-05  -7.83000000E-05  -9.50000000E-06  -7.78000000E-06  +2.43600000E-05
   -1.21700000E-05  +1.02300000E-05  -3.01100000E-05  +3.14900000E-05  -2.01543000E-03
   -1.03850000E-03  -2.46799000E-03  -6.02589700E-02  -1.08466320E-01  +2.76547690E-01
   -1.33100000E-05  -1.03800000E-05  +3.05100000E-05  +1.71690000E-04  -3.34700000E-05
   +1.09100000E-05  +2.84700000E-05  +1.51300000E-05  +3.90200000E-05  -1.39000000E-05
   -1.05100000E-05  +9.33000000E-06  -1.83600000E-05  +1.97500000E-05  +8.59000000E-06
   -1.23100000E-05  -2.59400000E-05  +8.12000000E-06  +2.43890000E-04  +8.10300000E-05
   -1.45120000E-04  -5.92900000E-05  -6.19700000E-05  -1.17960000E-04  +1.01700000E-05
   -1.10700000E-05  +1.12000000E-06  -2.41129000E-03  +3.23558000E-03  +1.64641000E-03
   +4.60598000E-03  +2.25443500E-02  -1.65684000E-02  -6.47085700E-02  -4.62523900E-02
   +4.88418100E-02  +2.08515000E-03  -2.23131800E-02  +1.67289100E-02  -2.48200000E-04
   +2.44811000E-03  -2.72877000E-03  -4.92800000E-05  +3.83800000E-05  -4.96200000E-05
   +6.02000000E-04  +5.83520000E-04  -3.24430000E-04  -1.21830000E-03  +8.95160000E-04
   -2.99880000E-04  +2.87070000E-04  -6.30800000E-05  +3.93000000E-06  -7.28229000E-03
   -1.45894000E-03  +3.84040000E-04  -4.11070000E-04  -4.28490000E-04  +7.04130000E-04
   -5.95000000E-06  +6.23000000E-06  -2.63000000E-06  -1.71000000E-06  +2.45000000E-06
   -3.96000000E-06  +7.07000000E-06  -1.21400000E-05  -1.11200000E-05  -3.41000000E-06
   +0.00000000E+00  -2.11000000E-05  -9.65000000E-06  +3.13000000E-06  -6.73000000E-06
   +1.31000000E-06  +9.13000000E-06  -4.89500000E-05  -5.92000000E-06  +1.17200000E-05
   +7.48000000E-06  +1.29600000E-05  -2.59000000E-05  +1.26800000E-05  -1.11000000E-05
   -4.32500000E-05  -1.72900000E-05  -1.66000000E-06  -6.20000000E-06  -8.81000000E-06
   +1.08300000E-05  -3.70500000E-05  -1.09100000E-05  +4.05250000E-04  -6.95400000E-05
   -1.57340000E-04  +1.27500000E-04  -1.48670000E-04  +1.07270000E-04  +6.65697800E-02
   -2.73100000E-05  -2.27400000E-05  -9.24000000E-06  -1.47760000E-04  -1.57300000E-05
   +5.51300000E-05  +4.56500000E-05  +1.15300000E-05  +4.04000000E-06  +5.15000000E-06
   +1.42800000E-05  -3.24000000E-06  -7.64600000E-05  +2.90800000E-05  +4.61900000E-05
   +4.23900000E-05  -2.07900000E-05  -5.38300000E-05  -7.21140000E-04  -1.60881000E-03
   +7.85130000E-04  +4.89980000E-04  +2.09630000E-04  +3.26120000E-04  +1.08480000E-04
   -1.16500000E-05  -5.66000000E-05  +4.74777000E-03  +4.30792000E-03  +5.55248000E-03
   -6.75708000E-03  -9.38378000E-03  +1.29647700E-02  -4.09834600E-02  -2.14020650E-01
   +1.42108820E-01  +1.85127000E-03  +1.02564000E-03  -2.56170000E-04  +1.88240000E-04
   +5.59420000E-04  -9.75000000E-05  -6.55000000E-06  -1.45060000E-04  -1.25340000E-04
   +4.72250000E-04  +5.90050000E-04  -7.88010000E-04  -2.25120000E-04  +3.54100000E-05
   -7.79800000E-05  +1.30290000E-04  +9.33900000E-05  -6.83600000E-05  -4.61370000E-04
   +1.00553000E-03  -7.78000000E-06  -2.48200000E-05  -5.63700000E-05  +4.86200000E-05
   -7.40000000E-06  +2.94000000E-06  +1.59700000E-05  +1.25700000E-05  -1.09200000E-05
   -3.20000000E-06  -6.13000000E-06  +7.38000000E-06  +1.46400000E-05  -7.40000000E-06
   -2.71000000E-06  +1.05100000E-05  +1.06900000E-05  +1.60000000E-07  +3.55000000E-06
   -2.21900000E-05  -1.52240000E-04  +1.55890000E-04  -2.58900000E-05  +5.77000000E-06
   +2.06000000E-06  -4.22000000E-06  -2.31400000E-05  -1.89200000E-05  -3.47000000E-06
   +1.71800000E-05  +1.59000000E-06  -4.29000000E-06  +5.62000000E-06  +1.70600000E-05
   +5.81000000E-06  +2.64800000E-05  +1.79300000E-05  +2.69790000E-04  -1.88710000E-04
   -1.17010000E-04  -1.06190000E-04  -1.01760000E-04  +1.71990000E-04  +4.17140100E-02
   +2.20241660E-01  -4.26200000E-05  +4.36000000E-06  +2.71400000E-05  +2.47100000E-05
   -4.04200000E-05  +3.20400000E-05  +6.76900000E-05  +2.51600000E-05  +3.69900000E-05
   -1.62000000E-05  -1.26900000E-05  +1.24000000E-06  -6.45800000E-05  +4.24700000E-05
   +4.41400000E-05  +2.15700000E-05  -4.72000000E-05  -3.75400000E-05  -3.20910000E-04
   -1.36005000E-03  +6.98530000E-04  +4.09760000E-04  +7.77200000E-05  +1.83040000E-04
   +7.89300000E-05  -1.96800000E-05  -3.86800000E-05  +1.61217000E-03  +6.40377000E-03
   +8.46098000E-03  +9.90730000E-04  +8.75072000E-03  -4.85930000E-04  +4.12508200E-02
   +1.37764010E-01  -1.55616930E-01  -2.86940000E-04  +1.07343900E-02  -2.74550000E-04
   -3.08320000E-04  -1.82305000E-03  +2.77080000E-04  -4.47000000E-06  -5.97200000E-05
   -2.43880000E-04  +6.92230000E-04  +7.47280000E-04  -8.74380000E-04  -6.85010000E-04
   -4.19620000E-04  -4.80630000E-04  +4.67330000E-04  +4.07770000E-04  -2.68300000E-05
   +1.97393000E-03  +8.75140000E-04  -1.32255000E-03  +3.16190000E-04  +1.08210000E-04
   -3.57590000E-04  -8.43000000E-06  +7.09000000E-06  +8.08000000E-06  +6.67000000E-06
   -4.04000000E-06  -7.19000000E-06  +8.90000000E-06  -1.75900000E-05  -4.18000000E-06
   -1.60400000E-05  -1.24000000E-06  -1.91800000E-05  -2.98000000E-06  +3.50000000E-06
   -1.48000000E-06  -2.29400000E-05  -1.43240000E-04  +8.88400000E-05  -3.29800000E-05
   +2.33100000E-05  +1.78800000E-05  +1.34700000E-05  -6.23800000E-05  +3.60000000E-06
   -5.83100000E-05  -3.00100000E-05  -4.61000000E-05  -1.89800000E-05  +8.12000000E-06
   +5.43100000E-05  -8.22000000E-06  -6.09900000E-05  +1.61100000E-05  +6.48640000E-04
   -2.89780000E-04  -3.01990000E-04  +2.81400000E-05  -1.19940000E-04  +1.43080000E-04
   -4.49863700E-02  -1.56493440E-01  +1.53969480E-01  -6.25000000E-06  +4.30930000E-04
   -5.10970000E-04  -1.04218000E-03  +9.70660000E-04  -1.39902000E-03  -2.47190000E-04
   +2.73790000E-04  -7.96950000E-04  +1.55570000E-04  -1.02270000E-04  +8.25600000E-05
   -5.58300000E-05  -8.99200000E-05  +7.32500000E-05  -5.98500000E-05  +4.45000000E-06
   +1.76150000E-04  -4.76150000E-04  -3.34670000E-04  +1.70580000E-04  -1.38400000E-05
   +6.67100000E-05  +1.85280000E-04  -7.19900000E-05  +2.17600000E-05  +1.06700000E-05
   -3.25380000E-04  -2.26837000E-03  +1.21444000E-03  -2.89867940E-01  -4.74223300E-02
   +8.78503200E-02  -2.15742900E-02  -4.50735000E-03  +9.47298000E-03  +3.58086000E-03
   +3.51408000E-03  -2.60114000E-03  -1.84801000E-03  +9.38510000E-04  +1.59922000E-03
   +3.59000000E-06  -1.64340000E-04  +9.89900000E-05  +7.16990000E-04  +8.71140000E-04
   +8.49990000E-04  -2.90350000E-04  +2.16480000E-04  -9.03200000E-05  +8.72200000E-05
   -5.90900000E-05  -6.17600000E-05  -4.83430000E-04  -1.18948000E-03  +1.71430000E-04
   -1.57730000E-04  -1.78340000E-04  +1.51860000E-04  -3.06000000E-06  -7.30000000E-06
   +3.14000000E-06  +5.73000000E-06  -5.41000000E-06  +2.63000000E-06  +1.54900000E-05
   -4.79900000E-05  +7.85300000E-05  +4.07100000E-05  -1.82700000E-05  +6.83000000E-05
   -3.88000000E-06  +1.28000000E-06  -1.60000000E-06  +2.55300000E-05  -2.76400000E-05
   +4.53500000E-05  +8.73000000E-06  -1.51200000E-05  -4.84000000E-06  -2.35400000E-05
   +4.23400000E-05  +5.67000000E-06  -1.44000000E-05  +1.09580000E-04  +6.32200000E-05
   +1.37600000E-05  +4.33900000E-05  -5.11100000E-05  +1.39100000E-05  +5.03500000E-05
   -2.89100000E-05  -9.68100000E-05  +8.32000000E-05  -1.38700000E-05  -1.21720000E-04
   -3.60000000E-06  +6.42100000E-05  +9.13900000E-04  -4.78580000E-04  -1.17278000E-03
   +3.10951000E-01  +5.01700000E-04  +2.38590000E-04  -5.43100000E-05  +1.05490000E-04
   +1.61590000E-04  +2.72270000E-04  +2.27100000E-05  -2.56280000E-04  -1.06710000E-04
   +1.81200000E-04  -1.49600000E-05  -2.54970000E-04  +2.78040000E-04  -1.01310000E-04
   -1.02210000E-04  -1.82050000E-04  +4.02800000E-05  +1.91970000E-04  -6.52130000E-04
   -3.38200000E-05  -1.55210000E-04  +2.30200000E-04  -1.29410000E-04  -6.91600000E-05
   -2.89280000E-04  +2.13500000E-05  +1.03870000E-04  -2.21975000E-02  -6.38399000E-03
   +1.00839100E-02  -5.43404800E-02  -5.16699900E-02  +2.61635200E-02  +2.45765000E-02
   +2.82371000E-03  -2.97278000E-03  +2.95026000E-03  +2.97485000E-03  +8.12525000E-03
   -1.91327000E-03  +7.50000000E-07  -7.72910000E-04  +1.11790000E-04  +1.34210000E-04
   -1.18860000E-04  +1.89256000E-03  -8.36870000E-04  +3.06043000E-03  -5.07440000E-04
   +3.23810000E-04  +4.91390000E-04  -7.30900000E-05  -1.11680000E-04  -1.77730000E-04
   +1.48021000E-03  +1.24268000E-03  -1.84820000E-03  +2.89240000E-04  +1.88800000E-04
   -2.60420000E-04  +4.72600000E-05  -1.98800000E-05  -1.60400000E-05  +3.49000000E-06
   -1.06000000E-05  +2.82200000E-05  -6.44600000E-05  -8.38900000E-05  +9.19000000E-05
   -4.82200000E-05  -4.72500000E-05  -9.68100000E-05  -2.61900000E-05  -1.23000000E-06
   -1.80700000E-05  +5.35700000E-05  +2.80000000E-06  +4.98200000E-05  +4.44300000E-05
   +4.33100000E-05  -1.11790000E-04  -4.94300000E-05  -2.08800000E-05  +2.67500000E-05
   -4.65200000E-05  -2.10700000E-05  -1.07470000E-04  +1.36100000E-05  -3.40900000E-05
   -2.88300000E-05  -6.00000000E-06  -5.54500000E-05  +7.62600000E-05  +1.44370000E-04
   -1.47610000E-03  -4.75890000E-04  -2.62690000E-04  -5.31000000E-05  +7.50600000E-05
   -1.06776000E-03  -2.46874000E-03  -4.84233000E-03  +4.90616000E-02  +5.57893100E-02
   -3.85580000E-04  -1.33240000E-04  -3.96600000E-05  -3.07650000E-04  +1.76620000E-04
   -6.80120000E-04  -3.10290000E-04  +4.80710000E-04  +3.00410000E-04  +1.84970000E-04
   +1.32300000E-05  -9.60200000E-05  -3.41780000E-04  -2.98000000E-06  +3.92600000E-05
   -1.24970000E-04  -1.07450000E-04  +6.73000000E-05  +1.60930000E-04  +3.38500000E-05
   +7.71760000E-04  -1.44190000E-04  +7.38800000E-05  -5.80000000E-07  +3.52340000E-04
   -5.32200000E-05  -1.67620000E-04  +1.88880300E-02  +1.49041000E-03  -1.06613000E-03
   +8.65484800E-02  +3.04037400E-02  -8.30493000E-02  -8.30042000E-03  -3.60099000E-03
   +1.09583600E-02  +5.32295000E-03  +7.79207000E-03  +5.85036000E-03  -4.26312000E-03
   +8.08750000E-04  +9.13640000E-04  -3.34500000E-05  +2.50140000E-04  -4.18700000E-05
   +1.30302000E-03  +3.70100000E-03  -1.25967000E-03  -2.19652000E-03  +1.12880000E-04
   -2.14030000E-03  +1.06549000E-03  +3.20050000E-04  +1.62620000E-04  +3.83190000E-04
   -1.45758000E-03  -1.22255000E-03  +1.89670000E-04  -1.97860000E-04  -1.00160000E-04
   -2.26200000E-05  +1.64000000E-05  +4.29700000E-05  +4.06400000E-05  -3.34200000E-05
   -7.70000000E-06  +1.45000000E-05  -7.61700000E-05  -2.33200000E-05  -2.41200000E-05
   -6.70000000E-06  -1.00090000E-04  +9.93000000E-06  +4.76000000E-06  +7.58000000E-06
   -6.10100000E-05  -2.75300000E-05  -4.06300000E-05  -7.14800000E-05  -8.04000000E-06
   +1.16830000E-04  +6.15600000E-05  -8.00500000E-05  +1.67900000E-05  +5.16800000E-05
   -2.71560000E-04  -2.39220000E-04  -6.04700000E-05  +3.25500000E-05  +1.57110000E-04
   -2.00300000E-05  -1.68200000E-04  +2.77500000E-05  +8.10800000E-05  +1.06678000E-03
   +5.41960000E-04  -1.13010000E-04  -7.06400000E-05  +2.28320000E-04  -1.90227000E-03
   -4.12613000E-03  -4.64002000E-03  -9.55139700E-02  -3.65273900E-02  +7.43112800E-02
   -2.95400000E-05  -1.84350000E-04  +2.85600000E-05  -4.23500000E-05  -4.48300000E-05
   +3.38810000E-04  +8.44500000E-05  -1.62000000E-06  +1.20130000E-04  +1.13040000E-04
   +1.06830000E-04  +8.31600000E-05  -5.47870000E-04  +1.11130000E-04  +2.15730000E-04
   +1.08620000E-04  -1.36970000E-04  -1.01990000E-04  -5.25790000E-04  +4.33700000E-05
   -2.39820000E-04  +4.34920000E-04  +7.53500000E-05  +9.81600000E-05  +6.30240000E-04
   -9.05400000E-05  -2.35080000E-04  -7.92200000E-05  +4.86110000E-04  -4.25310000E-04
   +1.45563000E-03  -3.26990000E-04  -7.37170000E-04  +1.41973000E-03  +1.22220000E-03
   +3.20818000E-03  -1.03030000E-02  -2.98388600E-02  -5.28113000E-03  -2.83028000E-03
   +1.19361800E-02  +3.36851000E-03  +2.48820000E-04  -5.09400000E-05  +2.31270000E-04
   +5.11010000E-04  +3.49300000E-05  -2.64120000E-04  +4.20140000E-04  +1.18463400E-02
   +9.62320000E-04  -7.54915000E-03  -6.35301000E-03  +4.57821000E-03  +1.46875800E-02
   +1.56913000E-02  -2.18986300E-02  -1.20004650E-01  -1.85036900E-02  +6.08135400E-02
   -1.06230000E-04  +5.27300000E-05  +3.42500000E-05  +2.72200000E-05  -2.10600000E-05
   -5.00500000E-05  -8.06300000E-05  +1.29950000E-04  -2.98500000E-05  -7.01600000E-05
   -9.32000000E-06  -3.45600000E-05  +2.13500000E-05  +2.45300000E-05  -2.72800000E-05
   +4.84200000E-05  -5.44200000E-05  +1.43360000E-04  -5.99900000E-05  +5.59300000E-05
   -4.53800000E-05  -3.99400000E-05  -3.27200000E-05  -3.75500000E-05  -1.89450000E-04
   -1.74590000E-04  -6.00800000E-05  -8.97000000E-06  +2.25600000E-05  -2.64050000E-04
   +1.50640000E-04  +2.43000000E-05  +1.81040000E-04  +4.15200000E-05  -2.35320000E-04
   +2.41570000E-04  +5.03900000E-04  -8.12350000E-04  +2.60810000E-04  +4.73480000E-04
   -7.36000000E-06  -4.64880000E-04  +2.49750000E-04  -4.08320000E-04  -1.58070000E-04
   +1.31042640E-01  -4.76000000E-06  -4.55400000E-05  +2.06200000E-05  -1.79900000E-05
   -4.72800000E-05  +6.91200000E-05  +2.29400000E-05  +1.42200000E-05  +5.38100000E-05
   +4.10200000E-05  +2.57300000E-05  +2.21500000E-05  -1.69940000E-04  +2.67300000E-05
   +5.97700000E-05  +1.57100000E-05  -4.62800000E-05  -1.92400000E-05  -2.25000000E-04
   -2.93100000E-05  -4.12000000E-05  +1.78280000E-04  +1.88600000E-05  +1.05900000E-05
   +1.87820000E-04  -3.20800000E-05  -6.64800000E-05  +1.37280000E-04  +4.83850000E-04
   -3.22200000E-05  +6.60330000E-04  -1.57300000E-04  -4.60810000E-04  +5.17900000E-05
   +5.00930000E-04  +1.63960000E-04  -1.06342300E-02  -6.15428000E-03  +5.39355000E-03
   +2.16079000E-03  +2.02608000E-03  -9.89020000E-04  +4.67500000E-05  +1.55300000E-05
   +6.13800000E-05  +4.34100000E-05  -3.77520000E-04  +2.26900000E-05  +2.22359000E-03
   +7.72464000E-03  -6.94220000E-04  -5.21359000E-03  -3.50867000E-03  +2.43955000E-03
   +1.66679800E-02  -1.72574900E-02  -1.44192600E-02  -4.96053700E-02  -7.63092900E-02
   +7.01616300E-02  -3.33300000E-05  +1.94800000E-05  +7.48000000E-06  +9.16000000E-06
   -4.33000000E-06  -1.86000000E-05  -2.72600000E-05  +3.40500000E-05  -1.55300000E-05
   -2.67500000E-05  -3.68000000E-06  -2.00500000E-05  +2.45000000E-06  +8.78000000E-06
   -9.50000000E-06  -6.00000000E-06  -2.48600000E-05  +4.84500000E-05  -2.77400000E-05
   +3.21600000E-05  +2.28400000E-05  -3.79000000E-06  -2.66500000E-05  -1.24200000E-05
   -9.51600000E-05  -7.95000000E-05  -1.71800000E-05  -5.56000000E-06  +5.27900000E-05
   -1.00110000E-04  +5.91800000E-05  -1.84300000E-05  +5.55800000E-05  +1.29810000E-04
   -2.51570000E-04  +1.62390000E-04  +4.93080000E-04  -7.07500000E-04  +1.69090000E-04
   +2.99560000E-04  +6.51800000E-05  -4.38500000E-05  +1.18470000E-04  -9.26400000E-05
   +7.34100000E-05  +3.65132500E-02  +9.69428400E-02  +3.32100000E-05  +1.59340000E-04
   -2.74600000E-05  -9.36000000E-06  +1.47500000E-05  -3.14550000E-04  -4.88000000E-05
   +1.77100000E-05  -1.04990000E-04  -6.71600000E-05  -7.86400000E-05  -7.99500000E-05
   +3.82760000E-04  -8.53100000E-05  -1.46930000E-04  -8.11800000E-05  +9.04900000E-05
   +6.67700000E-05  +4.58430000E-04  +1.79100000E-05  +2.26510000E-04  -4.65650000E-04
   -9.05100000E-05  -3.73500000E-05  -4.36070000E-04  +6.36900000E-05  +1.51980000E-04
   -2.07100000E-05  -4.42740000E-04  +1.43900000E-04  -1.00021000E-03  +4.84780000E-04
   +6.35510000E-04  -1.26012000E-03  -3.86804000E-03  -5.41090000E-04  +2.22780000E-03
   +2.66774500E-02  +1.03680000E-02  +2.20730000E-03  -9.90623000E-03  -5.86191000E-03
   -4.25650000E-04  +5.63400000E-05  -1.16420000E-04  -6.44970000E-04  -3.13340000E-04
   -5.25380000E-04  +1.17206000E-03  -1.04616900E-02  +4.01840000E-04  +5.71320000E-03
   +5.32236000E-03  -4.28678000E-03  -2.46548500E-02  -1.44074000E-02  -1.49870000E-03
   +9.60739500E-02  +6.34988400E-02  -1.35855560E-01  +7.78700000E-05  -3.97700000E-05
   -1.64900000E-05  -1.20200000E-05  +9.49000000E-06  +3.83800000E-05  +6.27600000E-05
   -1.04760000E-04  +3.83100000E-05  +3.64800000E-05  -7.93000000E-06  +3.06500000E-05
   -1.27600000E-05  -1.93000000E-05  +2.48800000E-05  -1.21900000E-05  +5.32200000E-05
   -1.34400000E-04  +7.42700000E-05  +7.10000000E-07  -2.94100000E-05  +5.93000000E-05
   +2.49000000E-06  +1.56300000E-05  +1.86850000E-04  +1.54800000E-04  +4.14500000E-05
   -4.15000000E-06  -4.14000000E-05  +1.20670000E-04  -6.21800000E-05  -4.40600000E-05
   -1.69960000E-04  -2.48350000E-04  +4.89630000E-04  -2.02590000E-04  -5.84280000E-04
   +8.56870000E-04  -2.14070000E-04  -1.13707000E-03  -6.84100000E-05  +5.25910000E-04
   -1.94680000E-04  +3.28270000E-04  +9.21600000E-05  -5.83455100E-02  -5.76644400E-02
   +1.20486450E-01  -2.27000000E-06  -2.46700000E-05  -3.20000000E-07  -1.71300000E-05
   +4.68000000E-06  +4.28900000E-05  +9.45000000E-06  -3.31000000E-06  +7.35000000E-06
   +2.25200000E-05  +2.10500000E-05  +9.35000000E-06  -9.61900000E-05  +1.65900000E-05
   +4.04000000E-05  +2.15700000E-05  -2.22300000E-05  -2.01500000E-05  -3.39800000E-05
   +3.28300000E-05  -2.58700000E-05  +1.45400000E-05  +5.52000000E-06  +1.92800000E-05
   +1.11640000E-04  -1.36300000E-05  -4.42300000E-05  -1.08940000E-04  -1.09820000E-04
   -4.36200000E-05  +3.17500000E-05  -1.90700000E-05  +2.99600000E-05  -5.13900000E-05
   +1.05470000E-04  -1.82780000E-04  -5.66810000E-04  -6.12000000E-06  +4.24220000E-04
   +5.23840000E-04  +1.73840000E-04  -1.40310000E-04  +1.06100000E-05  -1.38500000E-05
   +2.90500000E-05  +1.78550000E-04  +9.31000000E-05  +1.59230000E-04  -5.43820000E-04
   +1.02230000E-04  -1.34270000E-04  +4.83640000E-04  +3.97400000E-05  -3.42100000E-04
   +1.02212000E-03  -1.14068000E-03  +1.43708000E-03  -4.70584420E-01  +1.30514890E-01
   -9.95179600E-02  -1.85800000E-05  +7.13000000E-06  +8.21000000E-06  +4.31000000E-06
   -5.17000000E-06  -6.59000000E-06  -1.10600000E-05  +1.82000000E-05  +1.84000000E-06
   -1.22300000E-05  -3.64000000E-06  -1.49000000E-06  +4.87000000E-06  +3.58000000E-06
   -2.74000000E-06  +1.64000000E-05  +2.07000000E-06  +1.36200000E-05  +2.07000000E-06
   +2.25000000E-06  -2.51600000E-05  -9.38000000E-06  -5.00000000E-07  -5.31000000E-06
   -1.05500000E-05  -6.17000000E-06  -9.31000000E-06  -1.49000000E-06  -5.91000000E-06
   -2.50600000E-05  +1.76100000E-05  +8.04000000E-06  +1.97200000E-05  -1.90500000E-05
   +3.53000000E-06  -1.15000000E-05  +4.02000000E-05  +7.04000000E-06  +3.61000000E-06
   +4.70900000E-05  +6.64000000E-06  -2.29400000E-05  +2.06600000E-05  +1.88000000E-05
   +6.53000000E-06  -2.11479400E-02  +1.00837200E-02  -1.18557900E-02  +4.91285210E-01
   +2.63000000E-06  +9.36000000E-06  +3.88000000E-06  +4.00000000E-07  -1.12300000E-05
   -1.60100000E-05  -1.39000000E-06  +5.62000000E-06  +1.83000000E-06  -2.40000000E-07
   -4.97000000E-06  -3.86000000E-06  +1.18600000E-05  -2.78000000E-06  -5.82000000E-06
   -7.13000000E-06  +5.70000000E-07  +5.01000000E-06  +1.49800000E-05  -1.23100000E-05
   +1.00000000E-05  +5.00000000E-07  -6.84000000E-06  -6.16000000E-06  -1.48400000E-05
   -7.50000000E-07  +5.68000000E-06  +8.92900000E-05  +1.04820000E-04  -4.69500000E-05
   +2.89200000E-05  -5.38100000E-05  +2.78900000E-05  -1.43310000E-04  -7.60500000E-05
   -2.53360000E-04  -5.08300000E-05  +2.47072000E-03  +6.30490000E-04  +1.00681000E-03
   -1.06971000E-03  -5.25930000E-04  -1.17800000E-05  +2.36000000E-06  -1.64300000E-05
   -1.30150000E-04  -1.53790000E-04  -7.28200000E-05  +3.30660000E-04  +1.94270000E-04
   +1.22560000E-04  -2.30050000E-04  -8.27100000E-05  -1.61500000E-04  -2.26153000E-03
   -2.29944000E-03  +2.94918000E-03  +1.42891860E-01  -7.58056500E-02  +5.27091100E-02
   +2.50000000E-06  +6.80000000E-07  -1.04000000E-06  +8.90000000E-07  +4.10000000E-07
   -2.00000000E-08  +1.07000000E-06  -4.99000000E-06  -3.10000000E-07  +6.00000000E-08
   -1.40000000E-07  -2.14000000E-06  -2.48000000E-06  +3.00000000E-08  +3.60000000E-07
   -5.74000000E-06  +1.31000000E-06  -3.34000000E-06  +1.28000000E-06  +1.61000000E-06
   +7.97000000E-06  +2.85000000E-06  -5.05000000E-06  +3.30000000E-07  -6.93000000E-06
   -7.60000000E-07  +6.13000000E-06  +7.76000000E-06  +2.23800000E-05  +8.72000000E-06
   -6.36000000E-06  -6.02000000E-06  -4.68000000E-06  -7.61000000E-06  +2.83000000E-06
   -3.78000000E-06  +1.12000000E-06  +1.96800000E-05  +8.20000000E-06  -1.25500000E-05
   +8.64000000E-06  +3.26400000E-05  +7.25000000E-06  +3.12000000E-05  +5.24500000E-05
   -1.09809800E-02  +7.34320000E-03  -8.68368000E-03  -1.41902530E-01  +6.77604800E-02
   +1.34000000E-06  +1.59800000E-05  +6.80000000E-07  -2.12000000E-06  -9.51000000E-06
   -3.34500000E-05  -3.15000000E-06  +7.46000000E-06  -3.39000000E-06  -4.74000000E-06
   -6.97000000E-06  -8.75000000E-06  +2.78100000E-05  -6.55000000E-06  -1.07600000E-05
   -1.06500000E-05  +5.12000000E-06  +5.43000000E-06  +1.95900000E-05  -1.75400000E-05
   +2.80100000E-05  -1.44600000E-05  -4.90000000E-06  -1.44100000E-05  -3.34900000E-05
   +3.84000000E-06  +8.78000000E-06  +1.02750000E-04  +1.23790000E-04  +3.00900000E-05
   +5.18100000E-05  +4.40000000E-07  -6.91700000E-05  +1.25320000E-04  -1.08470000E-04
   +2.93400000E-04  +2.86720000E-04  +2.02410000E-04  -2.53500000E-04  -1.77230000E-04
   -7.94700000E-05  -3.02900000E-04  -2.40700000E-05  +6.71000000E-06  -2.04000000E-05
   -1.43470000E-04  -1.22870000E-04  -1.35310000E-04  +3.54060000E-04  +1.63360000E-04
   +1.96310000E-04  -3.04990000E-04  -1.10350000E-04  -1.40370000E-04  +1.32142000E-03
   +1.85477000E-03  -3.90472000E-03  -1.32867490E-01  +5.98932500E-02  -5.48874000E-02
   +6.92000000E-06  -2.82000000E-06  +9.70000000E-07  +9.20000000E-07  -1.70000000E-07
   +3.29000000E-06  +4.37000000E-06  -1.01200000E-05  +3.24000000E-06  +2.14000000E-06
   -1.61000000E-06  +1.36000000E-06  -2.05000000E-06  -1.77000000E-06  +3.11000000E-06
   -1.54200000E-05  -1.80000000E-07  -6.75000000E-06  +1.14700000E-05  +1.80000000E-07
   +2.05600000E-05  +6.54000000E-06  -5.05000000E-06  +1.65000000E-06  +3.51000000E-06
   +3.19000000E-06  +4.60000000E-06  +1.08600000E-05  +2.11100000E-05  +2.20200000E-05
   -1.51700000E-05  -9.07000000E-06  -1.14800000E-05  +6.20000000E-06  -7.34000000E-06
   +3.20000000E-06  +7.09000000E-06  +2.24800000E-05  +1.11900000E-05  -2.80300000E-05
   -1.64000000E-06  +7.64000000E-06  -8.90000000E-07  -2.63200000E-05  -6.04000000E-06
   +2.03200000E-02  -1.06731800E-02  +1.10977000E-02  +1.10339400E-01  -4.99750300E-02
   +4.92738900E-02  -8.90000000E-06  -6.33500000E-05  -2.70100000E-05  -3.56500000E-05
   +8.15000000E-05  +1.30130000E-04  +2.91000000E-06  -3.87400000E-05  -2.31200000E-05
   +3.15300000E-05  +5.57200000E-05  +2.44200000E-05  -1.66890000E-04  +3.59900000E-05
   +7.92000000E-05  +6.77900000E-05  -2.55000000E-05  -4.88500000E-05  -4.76600000E-05
   +1.59440000E-04  -5.90300000E-05  -3.21600000E-05  +2.74200000E-05  +6.25800000E-05
   +2.03410000E-04  -1.39300000E-05  -8.45500000E-05  -7.51340000E-04  -1.10872000E-03
   -8.68200000E-05  -4.18980000E-04  +3.80630000E-04  +2.07650000E-04  +1.13150000E-04
   -1.90750000E-04  -1.29870000E-04  +1.18374000E-03  +4.04350000E-04  -4.91220000E-04
   -9.43240000E-04  +2.01930000E-04  +6.51990000E-04  +1.52840000E-04  -7.90500000E-05
   +5.40600000E-05  +1.20580000E-03  +4.76320000E-04  +8.12890000E-04  -3.09897000E-03
   -4.70300000E-03  -4.53570000E-04  +5.79599000E-03  +2.26429000E-03  -4.05132000E-03
   -5.45818000E-03  +9.18850000E-04  +3.76745000E-03  -3.42457700E-02  -2.73082700E-02
   +6.54845000E-03  -3.25500000E-05  +5.90000000E-06  +1.93400000E-05  +3.86000000E-06
   -1.25500000E-05  -4.82000000E-06  -1.76800000E-05  +4.24700000E-05  +1.77400000E-05
   -7.51000000E-06  -4.50000000E-07  +1.28200000E-05  +1.58700000E-05  +4.24000000E-06
   -3.32000000E-06  +7.70900000E-05  +2.70500000E-05  +1.76200000E-05  +1.38000000E-05
   -6.46400000E-05  -1.26170000E-04  -6.37700000E-05  +4.73200000E-05  +5.88000000E-06
   +2.73800000E-05  +4.52600000E-05  -1.57300000E-05  +1.21100000E-05  -7.77800000E-05
   -6.99000000E-06  +7.28000000E-06  +6.99300000E-05  +3.78200000E-05  -2.74670000E-04
   +2.81160000E-04  -2.52880000E-04  -7.18200000E-05  +5.17330000E-04  -5.33200000E-05
   -1.03390000E-04  -1.38000000E-06  -1.17100000E-05  -3.81900000E-05  +6.98300000E-05
   -1.55090000E-04  +1.33312100E-02  -6.90446000E-03  -9.00950000E-03  -1.82038000E-03
   +1.11201300E-02  +4.18790000E-04  +7.73790800E-02  +2.34300000E-05  +7.40700000E-05
   +5.40100000E-05  +1.15600000E-05  -2.26000000E-04  -1.54770000E-04  +6.10900000E-05
   +1.19910000E-04  +8.74100000E-05  +4.09000000E-06  -7.87200000E-05  -2.85500000E-05
   +8.92300000E-05  -2.09000000E-05  -6.24100000E-05  -9.27600000E-05  -2.32800000E-05
   +5.24700000E-05  -1.11390000E-04  -2.07680000E-04  +6.15700000E-05  +6.43800000E-05
   -4.95100000E-05  +2.08700000E-05  -1.18180000E-04  -2.10800000E-05  +5.44100000E-05
   +1.40963000E-03  +1.91188000E-03  -1.32360000E-04  +1.14352000E-03  -8.23270000E-04
   -5.34440000E-04  -1.48460000E-04  +5.85220000E-04  +5.34910000E-04  -4.53029000E-03
   -4.53902000E-03  +3.00670000E-04  +2.39902000E-03  +1.22084000E-03  -1.08655000E-03
   -4.09230000E-04  +1.41840000E-04  +3.14900000E-05  -2.20468000E-03  -1.35873000E-03
   -2.82285000E-03  +7.09368000E-03  +1.48697200E-02  +4.49907000E-03  -1.87660800E-02
   -1.20688900E-02  +1.69478600E-02  +1.47149800E-02  +1.56090000E-03  -1.04430200E-02
   -1.12463400E-02  +1.81702000E-02  -8.74780000E-03  +2.17600000E-05  +1.59700000E-05
   -1.99300000E-05  +1.80500000E-05  +1.18700000E-05  -1.57400000E-05  +1.74000000E-06
   -3.14800000E-05  -3.80000000E-05  -3.04100000E-05  -1.77900000E-05  -3.91900000E-05
   -2.27000000E-05  +1.56000000E-06  -3.12000000E-06  -1.00810000E-04  -7.16900000E-05
   -8.69000000E-06  -4.51400000E-05  +2.43270000E-04  +1.50970000E-04  +1.94720000E-04
   -1.47400000E-04  -7.25500000E-05  -7.40000000E-05  -1.36090000E-04  -1.63000000E-06
   -2.02000000E-05  +1.22580000E-04  -1.01730000E-04  +6.57600000E-05  -1.33590000E-04
   -2.71100000E-05  +3.75140000E-04  -1.07720000E-04  +5.96780000E-04  -3.18670000E-04
   -1.51876000E-03  +2.06100000E-04  +3.34250000E-04  +1.52900000E-05  -5.97300000E-05
   +1.72200000E-04  -1.79310000E-04  +3.29710000E-04  -2.54775400E-02  -1.19003100E-02
   +2.02538800E-02  +6.79223000E-03  +1.13470200E-02  +1.43650000E-04  -1.22955100E-02
   +8.81197200E-02  +3.92000000E-06  +1.83800000E-05  -4.00000000E-06  -1.23600000E-05
   +5.07000000E-06  -5.68300000E-05  -2.93000000E-06  +1.16400000E-05  -9.30000000E-06
   -1.90000000E-06  -6.70000000E-06  -1.11800000E-05  +2.42300000E-05  -8.69000000E-06
   -9.73000000E-06  -1.02500000E-05  +3.51000000E-06  +6.19000000E-06  +4.68500000E-05
   -5.09600000E-05  +4.53100000E-05  -1.02670000E-04  -7.66000000E-06  +2.99300000E-05
   -2.85900000E-05  +3.89000000E-06  +6.74000000E-06  +1.45590000E-04  +1.76470000E-04
   -3.25800000E-05  -4.22400000E-05  -1.50800000E-05  -5.93000000E-06  -3.43000000E-06
   -7.12200000E-05  -2.13600000E-05  +2.89500000E-04  +9.00110000E-04  +3.31360000E-04
   -3.51000000E-06  -5.50680000E-04  -2.81270000E-04  -8.45600000E-05  +3.47400000E-05
   -2.57900000E-05  -2.14510000E-04  -4.09490000E-04  -2.12270000E-04  +1.62304000E-03
   +7.75350000E-04  -3.93830000E-04  +3.20550000E-04  +1.62417000E-03  -2.36557000E-03
   +1.30830000E-04  -1.27745000E-03  -8.36950000E-04  +3.47112000E-03  -9.47802000E-03
   -2.31972000E-02  +6.34000000E-06  -2.96000000E-06  +1.40000000E-06  +1.55000000E-06
   -6.10000000E-07  +3.52000000E-06  +6.44000000E-06  -1.28800000E-05  +7.59000000E-06
   -1.30000000E-07  -3.42000000E-06  +1.98000000E-06  -8.50000000E-07  -2.25000000E-06
   +3.76000000E-06  +4.64000000E-06  +1.85000000E-06  -2.17300000E-05  +1.48300000E-05
   +8.21000000E-06  -1.48500000E-05  +2.45300000E-05  -7.29000000E-06  -6.54000000E-06
   +2.68400000E-05  +1.26900000E-05  -2.87000000E-06  +1.04300000E-05  -1.74700000E-05
   +2.24100000E-05  -9.71000000E-06  -2.06600000E-05  -2.00100000E-05  -3.88500000E-05
   +1.29720000E-04  +1.16300000E-05  +1.60510000E-04  +8.89200000E-05  -1.67100000E-05
   -2.19000000E-05  +9.63000000E-06  +3.16200000E-05  -1.04700000E-05  +3.81000000E-06
   +1.50100000E-05  -2.72281000E-03  +1.02158900E-02  +1.75178000E-03  -2.99910000E-04
   +4.17761000E-03  -2.33768000E-03  -4.81114000E-03  +6.96344000E-03  +8.65029100E-02
   +1.31900000E-05  +1.87920000E-04  +3.84100000E-05  +5.16400000E-05  -1.08060000E-04
   -4.74390000E-04  -3.62900000E-05  +9.62700000E-05  -8.56000000E-06  -1.00020000E-04
   -1.36950000E-04  -8.99300000E-05  +4.92050000E-04  -1.11750000E-04  -2.16960000E-04
   -1.71220000E-04  +8.70700000E-05  +1.31300000E-04  +1.98480000E-04  -5.17870000E-04
   +3.32740000E-04  -2.49300000E-04  -6.94800000E-05  -8.34500000E-05  -5.92550000E-04
   +6.26000000E-05  +2.27540000E-04  +1.95188000E-03  +2.59457000E-03  -5.52400000E-05
   +7.26910000E-04  -8.55610000E-04  -4.00640000E-04  -4.65750000E-04  +1.90270000E-04
   +6.36900000E-05  -1.06602000E-03  +5.49140000E-04  +6.41210000E-04  +1.21192000E-03
   -1.03010000E-03  -1.01230000E-03  -4.81660000E-04  +2.67200000E-04  -2.32090000E-04
   -4.22446000E-03  -1.36228000E-03  -4.04185000E-03  +1.34895100E-02  +1.65030900E-02
   +9.76856000E-03  -3.70245200E-02  -1.74273800E-02  +5.50137200E-02  +5.55129000E-03
   -2.26892000E-03  -4.30315000E-03  +5.43473000E-03  +4.06950900E-02  -5.70600000E-03
   +9.89200000E-05  -3.57000000E-05  -3.89800000E-05  -1.47900000E-05  +2.53300000E-05
   +3.55400000E-05  +7.92500000E-05  -1.46110000E-04  +1.40000000E-06  +3.42200000E-05
   +6.50000000E-07  -1.39600000E-05  -3.52500000E-05  -1.89800000E-05  +2.07600000E-05
   -1.35470000E-04  -5.00100000E-05  -1.18820000E-04  +3.27400000E-05  +5.75000000E-05
   +1.97200000E-04  +1.48220000E-04  -8.98900000E-05  +2.99400000E-05  +2.55400000E-05
   -2.34100000E-05  +3.57500000E-05  +8.36000000E-06  +9.30300000E-05  +8.43500000E-05
   -5.49700000E-05  -1.99430000E-04  -1.49220000E-04  -6.13380000E-04  -6.74600000E-04
   +6.25100000E-04  -1.41672000E-03  -3.11488000E-03  -1.74610000E-04  +1.41250000E-04
   +1.12400000E-05  +9.79800000E-05  +3.27500000E-05  -1.26160000E-04  +3.50090000E-04
   -1.05955800E-02  -1.04113000E-03  +8.18526000E-03  +1.60778000E-03  +4.79450000E-04
   +3.66350000E-04  -3.60962600E-02  +2.02233800E-02  +1.06717600E-02  +2.50164160E-01
   -1.81300000E-05  +7.91000000E-06  -1.84000000E-05  +3.81300000E-05  +1.25140000E-04
   -2.06300000E-05  -7.20000000E-05  -7.44500000E-05  -6.74100000E-05  -3.67400000E-05
   +1.57300000E-05  -3.56000000E-06  +9.01000000E-05  -2.39900000E-05  -2.70200000E-05
   +1.14300000E-05  +4.95800000E-05  +6.11000000E-06  +1.63970000E-04  -1.03200000E-05
   +3.41400000E-05  -1.95300000E-05  -1.39100000E-05  -1.15460000E-04  -1.06910000E-04
   +3.86300000E-05  +3.87100000E-05  -2.86860000E-04  -3.06290000E-04  +1.83930000E-04
   -4.97480000E-04  +1.90790000E-04  +2.74390000E-04  -7.08200000E-05  -3.34910000E-04
   -3.36840000E-04  +2.57338000E-03  +2.99860000E-03  -8.70700000E-05  -1.24938000E-03
   -9.82020000E-04  +5.16020000E-04  +1.69490000E-04  -1.57700000E-05  -1.00330000E-04
   -1.04100000E-04  +8.77760000E-04  +1.35313000E-03  -1.71720000E-03  -5.22623000E-03
   -3.28460000E-03  +2.19208000E-03  +1.72976900E-02  -1.99025000E-03  -7.67355000E-03
   -1.08847000E-03  +5.62761000E-03  +2.85056800E-02  -8.10902300E-02  +7.66237000E-03
   +1.28200000E-05  -2.50000000E-05  +6.00000000E-08  -2.48400000E-05  +9.70000000E-07
   +2.41800000E-05  +2.67800000E-05  -2.94900000E-05  +2.12900000E-05  +3.61300000E-05
   +1.72000000E-05  +2.26900000E-05  +4.14000000E-06  -6.00000000E-06  +8.40000000E-06
   +4.54000000E-06  +3.92200000E-05  -1.44400000E-05  +4.79600000E-05  -1.49850000E-04
   +4.53000000E-06  -1.21720000E-04  +8.49000000E-05  +7.63600000E-05  +4.39100000E-05
   +7.93600000E-05  +1.81200000E-05  +4.47000000E-06  -3.48100000E-05  +9.04300000E-05
   -5.92100000E-05  +3.01400000E-05  -2.32800000E-05  -1.16140000E-04  -3.20180000E-04
   -2.63020000E-04  +1.13244000E-03  +1.44710000E-04  -4.26680000E-04  -1.70840000E-04
   -6.18000000E-06  +6.55300000E-05  -1.10080000E-04  +8.90500000E-05  -1.11650000E-04
   +1.35168700E-02  +2.71940000E-03  -1.10964100E-02  -4.87344000E-03  -9.71898000E-03
   -9.54240000E-04  +1.45101500E-02  -1.16180480E-01  -2.57306700E-02  -1.35627260E-01
   +2.99844860E-01  -1.60600000E-05  -1.64450000E-04  +6.40000000E-06  +1.45000000E-06
   -1.65200000E-05  +4.63440000E-04  +4.75700000E-05  -9.72800000E-05  +6.06700000E-05
   +7.20000000E-05  +9.36700000E-05  +9.33600000E-05  -3.74940000E-04  +9.63400000E-05
   +1.61270000E-04  +1.29540000E-04  -6.68600000E-05  -1.04740000E-04  -3.22160000E-04
   +7.35290000E-04  -3.00740000E-04  +5.14100000E-04  +8.62900000E-05  -6.14600000E-05
   +4.48810000E-04  -5.48400000E-05  -1.57030000E-04  -2.09743000E-03  -2.93172000E-03
   +1.13736000E-03  -5.36930000E-04  +8.40560000E-04  +7.19300000E-05  +5.64720000E-04
   +2.35800000E-05  +2.53810000E-04  -8.77200000E-05  -1.62649000E-03  -6.36840000E-04
   -6.35730000E-04  +1.47632000E-03  +9.65300000E-04  +5.57640000E-04  -2.93500000E-04
   +3.10470000E-04  +4.66264000E-03  +3.29353000E-03  +2.87810000E-03  -1.62533500E-02
   -2.01610300E-02  -1.70139200E-02  +7.28010600E-02  +2.05745000E-02  -6.21968400E-02
   -3.07392000E-03  +3.13765000E-03  +3.47560000E-03  -8.25630000E-04  -5.95630000E-03
   +1.62823500E-02  -8.05300000E-05  +3.45400000E-05  +1.57600000E-05  +4.37000000E-06
   -1.02800000E-05  -3.95100000E-05  -7.68300000E-05  +1.43420000E-04  -5.32400000E-05
   -2.55000000E-05  +5.74000000E-06  +7.70000000E-07  +2.18300000E-05  +1.95600000E-05
   -2.50500000E-05  +1.70000000E-05  -5.23000000E-06  +1.56110000E-04  -7.81900000E-05
   +8.56400000E-05  +4.27300000E-05  -6.45200000E-05  +2.95000000E-05  -5.79500000E-05
   -8.32200000E-05  -4.85800000E-05  -2.08700000E-05  -3.53000000E-05  -1.06200000E-05
   -1.12900000E-04  +6.63500000E-05  +2.16820000E-04  +1.57840000E-04  +9.93820000E-04
   -7.41690000E-04  +3.84560000E-04  +1.03947000E-03  +4.71037000E-03  +9.03840000E-04
   -5.77000000E-05  -5.14900000E-05  -1.28760000E-04  -2.82300000E-05  +3.68600000E-05
   -3.06010000E-04  +5.87846000E-03  +2.15130000E-04  -4.97218000E-03  -4.11650000E-04
   -1.37209000E-03  +6.58180000E-04  -4.01143000E-03  +6.71271000E-03  -6.75181800E-02
   +1.25547710E-01  -1.09833410E-01  +5.63822420E-01  -1.56700000E-05  -2.46650000E-04
   -2.33000000E-05  -3.55300000E-05  +4.84000000E-05  +6.90260000E-04  +6.32100000E-05
   -1.46050000E-04  +5.08900000E-05  +1.27800000E-04  +1.68330000E-04  +1.31730000E-04
   -6.25340000E-04  +1.50550000E-04  +2.72530000E-04  +2.13350000E-04  -1.11310000E-04
   -1.72480000E-04  -3.70520000E-04  +1.03502000E-03  -4.74370000E-04  +5.97540000E-04
   +1.12740000E-04  -5.48000000E-06  +7.53230000E-04  -8.74200000E-05  -2.79680000E-04
   -2.26940000E-03  -3.77400000E-03  +1.14146000E-03  -7.51250000E-04  +9.70620000E-04
   +3.64660000E-04  +6.60980000E-04  -1.08730000E-04  +8.08000000E-05  +4.99590000E-04
   -1.25680000E-03  -7.27830000E-04  -1.09026000E-03  +1.63380000E-03  +1.19604000E-03
   +7.71380000E-04  -4.23700000E-04  +4.32520000E-04  +5.84122000E-03  +4.85670000E-03
   +4.50133000E-03  -2.83194100E-02  -2.90645100E-02  -2.64313000E-03  +9.22579000E-03
   +1.57448700E-02  -2.92285700E-02  -4.51962000E-03  +3.30469000E-03  +4.00454000E-03
   -5.14950000E-04  -1.35717800E-02  +3.36516000E-03  -1.28600000E-04  +5.26700000E-05
   +4.06900000E-05  +1.63800000E-05  -2.64700000E-05  -5.55300000E-05  -1.20580000E-04
   +2.13180000E-04  -4.20900000E-05  -4.48600000E-05  +1.38000000E-06  +1.10400000E-05
   +4.06000000E-05  +2.76600000E-05  -3.26400000E-05  +8.87400000E-05  +2.59600000E-05
   +2.07430000E-04  -6.37700000E-05  +6.05400000E-05  -5.31300000E-05  -1.35060000E-04
   +7.15200000E-05  -7.66500000E-05  -8.08200000E-05  -2.40700000E-05  -4.41700000E-05
   -3.41000000E-05  -5.95400000E-05  -1.40280000E-04  +8.46600000E-05  +3.13920000E-04
   +2.29890000E-04  +1.84130000E-04  -4.69990000E-04  -6.49260000E-04  +3.15154000E-03
   +3.55126000E-03  -1.06257000E-03  -1.31890000E-04  -2.21200000E-05  -1.46040000E-04
   -2.19200000E-05  +1.37150000E-04  -4.58360000E-04  +7.62098000E-03  +3.73768000E-03
   -6.21646000E-03  -5.46420000E-04  -1.17390000E-04  +4.18000000E-05  -1.08623800E-02
   +2.32425000E-02  +1.98369000E-03  -5.91734900E-02  +5.12185000E-03  +1.05108400E-02
   +6.22962100E-02  -1.35000000E-06  -6.75300000E-05  -1.91000000E-06  -9.47600000E-05
   -5.63300000E-05  +1.30930000E-04  +6.55000000E-05  +1.02500000E-05  +3.74800000E-05
   +4.33900000E-05  +3.42700000E-05  +2.99500000E-05  -1.85280000E-04  +5.24600000E-05
   +8.19100000E-05  +5.06900000E-05  -5.41200000E-05  -4.88700000E-05  -3.99320000E-04
   +4.70040000E-04  +8.02500000E-05  +1.11400000E-04  +7.93600000E-05  +4.85500000E-05
   +2.29090000E-04  -3.71800000E-05  -9.20500000E-05  -1.00996000E-03  -1.72283000E-03
   +1.49540000E-04  -1.12340000E-04  +4.12910000E-04  -2.03900000E-04  +2.47930000E-04
   +1.88790000E-04  +1.73610000E-04  -9.97220000E-04  -1.85661000E-03  -3.33670000E-04
   -3.27900000E-05  +1.15976000E-03  +4.61860000E-04  +2.21740000E-04  -1.22820000E-04
   +1.92680000E-04  +3.52880000E-03  -6.64220000E-04  -9.59900000E-05  -1.42645300E-02
   -1.17145300E-02  +1.09148100E-02  +8.23265000E-03  -2.69016300E-02  -9.26529000E-03
   +2.19420000E-04  +2.36568000E-03  +5.35730000E-04  -1.03235000E-03  -4.50807000E-03
   +2.36524000E-03  -3.26800000E-05  +2.24800000E-05  +1.46800000E-05  +2.24700000E-05
   -1.01200000E-05  -2.11400000E-05  -3.59300000E-05  +7.44800000E-05  -3.58000000E-06
   -2.72700000E-05  -9.69000000E-06  -4.67000000E-06  +9.59000000E-06  +7.38000000E-06
   -1.00500000E-05  +2.51200000E-05  -1.75800000E-05  +5.34100000E-05  -2.01800000E-05
   +3.83400000E-05  -3.11700000E-05  +1.37500000E-05  -1.59100000E-05  -3.81300000E-05
   -3.21600000E-05  -1.91400000E-05  -2.05900000E-05  +4.23000000E-06  -2.26200000E-05
   -6.54900000E-05  +3.38700000E-05  +1.03790000E-04  +7.17200000E-05  +2.57000000E-06
   +1.47560000E-04  +1.66900000E-04  -4.19190000E-03  +2.10736000E-03  +9.19990000E-04
   +2.47000000E-05  -3.82800000E-05  -1.02600000E-04  +1.38000000E-05  -1.54900000E-05
   -1.33300000E-04  +1.76298000E-03  -1.04980000E-03  -1.36032000E-03  +7.25300000E-05
   -5.13100000E-05  +1.00730000E-04  +1.08173000E-02  +8.62986000E-03  -1.66460400E-02
   +1.31157800E-02  -4.50174600E-02  +3.72814000E-03  -1.01900000E-02  +7.90972400E-02
   +2.89500000E-05  +2.88150000E-04  -7.03000000E-06  +1.64300000E-05  +4.52800000E-05
   -8.04250000E-04  -1.00610000E-04  +1.47680000E-04  -1.10240000E-04  -1.30120000E-04
   -1.61840000E-04  -1.58420000E-04  +6.68270000E-04  -1.75570000E-04  -2.91620000E-04
   -2.30110000E-04  +1.26340000E-04  +1.92400000E-04  +5.53150000E-04  -1.39670000E-03
   +4.69800000E-04  -7.79130000E-04  -2.00190000E-04  +1.02620000E-04  -8.02510000E-04
   +9.96400000E-05  +2.87980000E-04  +3.83061000E-03  +5.77177000E-03  -2.62870000E-03
   +1.02866000E-03  -1.53721000E-03  -3.81800000E-05  -1.02281000E-03  -6.98600000E-05
   -4.56310000E-04  +5.13030000E-04  +2.43860000E-03  +8.36610000E-04  +1.03692000E-03
   -2.56602000E-03  -1.66674000E-03  -9.78480000E-04  +5.34270000E-04  -5.62700000E-04
   -1.03590700E-02  -8.72609000E-03  -3.72705000E-03  +2.86403000E-02  +3.53679200E-02
   +2.81386300E-02  -4.71926100E-02  -2.04855400E-02  -2.59950600E-02  +5.24915000E-03
   -5.91816000E-03  -6.25167000E-03  +4.85010000E-04  +2.00701700E-02  -6.15704000E-03
   +1.40400000E-04  -6.17100000E-05  -3.26800000E-05  -1.42000000E-05  +2.07700000E-05
   +6.91900000E-05  +1.32250000E-04  -2.54580000E-04  +9.24400000E-05  +4.84200000E-05
   -4.32000000E-06  -4.14000000E-06  -3.92700000E-05  -3.33000000E-05  +4.25100000E-05
   -1.22600000E-05  +3.97200000E-05  -2.64330000E-04  +1.46360000E-04  -1.56050000E-04
   -9.39900000E-05  +5.55400000E-05  -1.66500000E-05  +1.18900000E-04  +1.30330000E-04
   +7.81700000E-05  +4.30900000E-05  +5.00000000E-05  +3.90900000E-05  +1.81770000E-04
   -1.04970000E-04  -3.91270000E-04  -2.74300000E-04  -1.75133000E-03  +1.58225000E-03
   -8.85530000E-04  -1.97433000E-03  -7.43783000E-03  -5.68080000E-04  +1.06110000E-04
   +1.07880000E-04  +2.45000000E-04  +5.61900000E-05  -4.73700000E-05  +5.51160000E-04
   -9.96875000E-03  -4.51261000E-03  +9.22868000E-03  +6.65810000E-04  +5.20500000E-04
   +3.21800000E-04  +1.18497900E-02  -3.83702100E-02  +4.53119000E-03  -1.20714300E-02
   +1.95046300E-02  -2.88768300E-02  +2.80894100E-02  +3.71995000E-03  +4.56367500E-02
   -2.41000000E-06  -3.76000000E-05  -2.25500000E-05  -4.60600000E-05  +8.01300000E-05
   +3.58600000E-05  -2.77000000E-06  -1.02900000E-05  -1.97200000E-05  +3.16000000E-05
   +4.23200000E-05  +1.05900000E-05  -1.36070000E-04  +2.14600000E-05  +6.09900000E-05
   +4.19000000E-05  -2.74800000E-05  -2.79400000E-05  +2.12100000E-05  -7.60800000E-05
   -1.23100000E-05  -1.11120000E-04  +1.39000000E-05  +1.04090000E-04  +1.63620000E-04
   -1.58200000E-05  -6.84700000E-05  -6.94200000E-05  +1.28530000E-04  -5.47800000E-04
   -3.09400000E-05  +6.77200000E-05  +1.30850000E-04  +1.49700000E-05  -4.03500000E-05
   -9.98300000E-05  +3.15300000E-04  +4.99300000E-05  -4.23400000E-05  -1.85340000E-04
   +4.08300000E-05  +4.63600000E-05  +1.35600000E-05  +2.41000000E-06  -2.99700000E-05
   -8.99000000E-05  -7.70230000E-04  +5.98960000E-04  +1.60193000E-03  +1.48049000E-03
   +1.78610000E-03  -7.82322000E-03  -7.18350000E-04  +4.95180000E-03  -3.94840000E-04
   -1.22510000E-04  +1.32100000E-05  -1.39000000E-05  +1.04927000E-03  +1.17557000E-03
   -2.50800000E-05  +8.02000000E-06  +1.58200000E-05  +7.63000000E-06  -1.05900000E-05
   -5.07000000E-06  -1.18100000E-05  +1.83900000E-05  +2.87800000E-05  -1.18900000E-05
   -2.83000000E-06  +4.09000000E-06  +1.06500000E-05  +3.24000000E-06  -1.50000000E-06
   +9.87300000E-05  +4.43600000E-05  -1.22200000E-05  +4.78500000E-05  -1.26410000E-04
   -1.76870000E-04  -9.29300000E-05  +4.62700000E-05  +2.54000000E-05  +1.14500000E-05
   +3.63900000E-05  -8.69000000E-06  +1.20100000E-05  -3.85800000E-05  -8.30000000E-06
   +9.04000000E-06  +2.43000000E-06  +1.42200000E-05  -6.62460000E-04  +2.89290000E-04
   -2.44610000E-04  +1.92700000E-05  -4.85980000E-04  -2.45050000E-04  -2.39800000E-05
   +1.54800000E-05  -7.21000000E-06  +7.77000000E-06  +4.69800000E-05  -4.66100000E-05
   +5.85470000E-04  +1.58030000E-04  -1.41840000E-04  +1.25570000E-04  -1.08450000E-04
   -1.89770000E-04  -5.02849000E-03  -2.44393000E-03  -1.05444400E-02  -1.28947080E-01
   +8.47499500E-02  -1.94702400E-01  +1.76184900E-02  -6.20926000E-03  +4.01088000E-03
   +1.22951660E-01  +9.25000000E-06  -3.97900000E-05  -1.08100000E-05  -4.39400000E-05
   +5.04000000E-06  +7.13600000E-05  +3.91200000E-05  +1.57800000E-05  +2.23500000E-05
   +3.43400000E-05  +1.99500000E-05  +1.40000000E-05  -1.24320000E-04  +2.98000000E-05
   +5.47500000E-05  +3.16900000E-05  -3.55900000E-05  -2.98300000E-05  -3.66000000E-05
   +4.76200000E-05  -7.98200000E-05  -1.00740000E-04  +3.81900000E-05  +1.61950000E-04
   +1.54350000E-04  -2.66100000E-05  -6.12200000E-05  -2.55930000E-04  -4.03930000E-04
   -1.63140000E-04  -8.48100000E-05  +1.56760000E-04  +5.42600000E-05  +9.04200000E-05
   +1.28600000E-05  +1.61500000E-05  -1.74360000E-04  -4.62210000E-04  -2.41800000E-05
   -3.09200000E-05  +2.53130000E-04  +2.23100000E-05  -2.00500000E-05  -3.44500000E-05
   +6.66700000E-05  +7.07730000E-04  -1.10720000E-04  +6.26000000E-06  -2.28830000E-04
   +1.26880000E-04  +1.65290000E-04  +1.66972000E-03  +3.62510000E-04  -1.57703000E-03
   +2.04340000E-04  +3.52840000E-04  -2.66870000E-04  +2.36250000E-04  -5.55456000E-03
   -2.63590000E-03  -2.16600000E-05  +1.59600000E-05  +8.50000000E-06  +1.46100000E-05
   -6.11000000E-06  -1.61900000E-05  -2.51900000E-05  +3.89900000E-05  -2.29000000E-06
   -2.08800000E-05  -9.28000000E-06  -2.29000000E-06  +7.31000000E-06  +4.57000000E-06
   -5.77000000E-06  +6.82800000E-05  -2.68000000E-06  +2.50000000E-07  -2.24500000E-05
   +2.94100000E-05  -1.11330000E-04  +4.78700000E-05  -1.87300000E-05  -5.71800000E-05
   +9.99000000E-06  -6.51000000E-06  -2.02100000E-05  +1.30100000E-05  -3.98200000E-05
   -2.84200000E-05  +2.47200000E-05  +2.22600000E-05  +2.76100000E-05  -3.75730000E-04
   +4.60740000E-04  +1.46900000E-05  -2.35000000E-06  +1.51940000E-04  -1.71500000E-05
   -2.88000000E-06  +1.30000000E-07  -2.76200000E-05  +1.82300000E-05  +1.17600000E-05
   -3.93100000E-05  +8.89400000E-05  +6.98700000E-05  +2.31370000E-04  +1.50400000E-05
   +4.00900000E-05  -4.33280000E-04  +1.03235500E-02  +2.67996000E-03  +2.91551000E-02
   +6.97964200E-02  -6.39966200E-02  +9.71462200E-02  -4.88248000E-03  -1.02874000E-03
   +2.02031000E-03  -7.71510600E-02  +6.68293000E-02  +6.90000000E-07  +3.32500000E-05
   -6.20000000E-06  -1.50500000E-05  +6.83000000E-06  -1.13470000E-04  -5.04000000E-06
   +2.86100000E-05  -9.78000000E-06  -1.20400000E-05  -1.82900000E-05  -1.87000000E-05
   +6.38200000E-05  -1.76400000E-05  -2.63700000E-05  -2.46300000E-05  +8.53000000E-06
   +1.79800000E-05  +8.96700000E-05  -9.66700000E-05  +1.17730000E-04  -1.75220000E-04
   +4.75800000E-05  +1.34100000E-05  -7.77000000E-05  +9.22000000E-06  +2.41000000E-05
   +3.28930000E-04  +3.19220000E-04  +2.61430000E-04  +9.47000000E-06  -1.28360000E-04
   -9.80800000E-05  -6.48900000E-05  -3.01600000E-05  +3.99000000E-06  +1.51610000E-04
   +5.57220000E-04  +1.41640000E-04  +3.55200000E-05  -3.29840000E-04  -1.50980000E-04
   -8.97400000E-05  +6.46200000E-05  -6.26800000E-05  -5.19010000E-04  -2.07900000E-04
   -6.37760000E-04  +9.19140000E-04  +4.94100000E-04  -8.63340000E-04  +3.02956000E-03
   -6.25330000E-04  +2.08200000E-05  -3.86550000E-04  -4.33560000E-04  +2.06000000E-04
   +9.61380000E-04  -4.46923000E-03  -5.55460000E-04  +1.48700000E-05  -6.01000000E-06
   -6.90000000E-07  +1.01000000E-06  +1.81000000E-06  +7.18000000E-06  +1.75600000E-05
   -2.57200000E-05  +8.81000000E-06  +4.10000000E-06  -3.23000000E-06  +1.24000000E-06
   -3.63000000E-06  -4.61000000E-06  +6.44000000E-06  -1.55300000E-05  -1.32700000E-05
   -3.85600000E-05  +4.90100000E-05  -4.77300000E-05  +2.68700000E-05  +3.99000000E-05
   -1.53600000E-05  +1.28600000E-05  +2.27800000E-05  +1.44400000E-05  +1.23000000E-06
   +1.77600000E-05  -5.30000000E-06  +4.13600000E-05  -2.74700000E-05  -4.16800000E-05
   -3.29500000E-05  +3.55910000E-04  -8.27600000E-05  +3.59860000E-04  -1.47540000E-04
   +2.03080000E-04  +1.45700000E-04  +5.99000000E-06  +4.31000000E-06  +3.56800000E-05
   -1.34700000E-05  -1.77700000E-05  +5.44000000E-05  +2.85980000E-04  +3.60870000E-04
   -3.50980000E-04  -1.28480000E-04  -1.25600000E-04  +1.49390000E-04  -8.01140000E-04
   +4.76844000E-03  +4.09801000E-03  -1.83274760E-01  +1.18972720E-01  -4.09719200E-01
   -1.48147100E-02  +4.50072000E-03  -1.12356500E-02  +1.94191940E-01  -1.23649550E-01
   +4.18164730E-01
end_hess

