# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -958.57700290    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -5.56860299E+00  +2.18236824E+00  +1.50556939E+00
   006   -3.68555366E+00  +1.80444737E+00  -2.87206366E-01
   006   -4.30437458E+00  +3.89918102E-01  -2.41725441E+00
   006   -6.69693000E+00  -6.05495172E-01  -2.75664108E+00
   006   -8.55346943E+00  -1.96950414E-01  -9.44187571E-01
   006   -7.97656491E+00  +1.20452074E+00  +1.19277686E+00
   006   -1.01627281E+00  +2.90342137E+00  -3.71695172E-02
   006   -6.69204530E-01  +4.92624410E+00  -2.08404284E+00
   008   -1.09343584E+01  -1.12047683E+00  -1.16523504E+00
   006   +8.74519250E-01  +7.25465029E-01  -2.73088726E-01
   006   +6.25725750E-01  -1.21032328E+00  +1.71077922E+00
   006   +2.35948442E+00  -2.34909334E+00  +3.15225307E+00
   006   +5.20492534E+00  -2.14164008E+00  +3.25522929E+00
   008   +6.24793998E+00  -3.05057322E+00  +5.09114986E+00
   006   -5.56986217E-01  +4.16300543E+00  +2.53928260E+00
   006   +2.60380969E+00  +6.47768332E-01  -2.12653008E+00
   006   +4.41961228E+00  -1.36052698E+00  -2.34187978E+00
   008   +6.31464155E+00  -1.13078961E+00  -3.75341824E+00
   008   +6.33713726E+00  -1.06035600E+00  +1.38028229E+00
   008   +9.49809377E+00  -3.07371770E+00  -1.26559975E+00
   001   -1.10923553E+01  -2.05164265E+00  -2.70725528E+00
   001   -7.11922326E+00  -1.70465707E+00  -4.43281320E+00
   001   -2.88232923E+00  +3.64226828E-02  -3.84647247E+00
   001   -5.18052649E+00  +3.25658731E+00  +3.19829410E+00
   001   -9.42443276E+00  +1.51352140E+00  +2.60091820E+00
   001   -2.09398744E+00  +6.38938262E+00  -1.82261808E+00
   001   +1.18736631E+00  +5.81296588E+00  -1.95609257E+00
   001   -9.07308528E-01  +4.16237300E+00  -3.98130477E+00
   001   -8.95426623E-01  +2.87807169E+00  +4.11047056E+00
   001   +1.40069333E+00  +4.79305965E+00  +2.65591524E+00
   001   -1.77149696E+00  +5.81170682E+00  +2.76288807E+00
   001   +2.81481782E+00  +2.17079793E+00  -3.46951914E+00
   001   +3.95630330E+00  -3.20310175E+00  -1.55132300E+00
   001   +1.65696309E+00  -3.59205761E+00  +4.61969128E+00
   001   -1.32925026E+00  -1.62503295E+00  +2.17483282E+00
   001   +8.49214504E+00  -2.27258521E+00  +2.60172718E-01
   001   +8.03608719E+00  -2.27529884E+00  -2.85437088E+00
   001   +1.11355996E+01  -2.31068698E+00  -1.36564551E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -4.20000000E-07  -9.40000000E-07  -2.90000000E-07
   -4.00000000E-08  -8.00000000E-08  -1.20000000E-07
   +4.40000000E-07  +7.60000000E-07  -8.00000000E-07
   +5.40000000E-07  +8.00000000E-07  -1.67000000E-06
   +2.00000000E-07  -6.00000000E-08  -1.84000000E-06
   -2.80000000E-07  -9.30000000E-07  -1.16000000E-06
   -1.30000000E-07  -1.20000000E-07  +8.80000000E-07
   +1.60000000E-07  +8.10000000E-07  +1.82000000E-06
   +2.60000000E-07  -5.00000000E-08  -2.70000000E-06
   -4.00000000E-08  +1.30000000E-07  +3.50000000E-07
   -2.50000000E-07  -6.90000000E-07  -5.70000000E-07
   -4.40000000E-07  -1.38000000E-06  -7.80000000E-07
   -5.70000000E-07  -1.30000000E-06  -1.00000000E-07
   -8.20000000E-07  -1.82000000E-06  -2.90000000E-07
   -7.00000000E-07  -1.17000000E-06  +1.51000000E-06
   +4.00000000E-07  +1.00000000E-06  +6.60000000E-07
   +5.00000000E-07  +1.18000000E-06  -3.00000000E-08
   +8.10000000E-07  +1.94000000E-06  +5.40000000E-07
   -1.70000000E-07  -3.30000000E-07  +5.30000000E-07
   +3.90000000E-07  +1.05000000E-06  +3.30000000E-07
   +6.00000000E-07  +5.70000000E-07  -3.13000000E-06
   +9.10000000E-07  +1.49000000E-06  -2.23000000E-06
   +7.20000000E-07  +1.44000000E-06  -6.90000000E-07
   -7.50000000E-07  -1.66000000E-06  +2.40000000E-07
   -5.60000000E-07  -1.60000000E-06  -1.30000000E-06
   +3.00000000E-08  +6.30000000E-07  +2.16000000E-06
   +9.00000000E-08  +8.50000000E-07  +2.54000000E-06
   +5.50000000E-07  +1.61000000E-06  +1.44000000E-06
   -9.10000000E-07  -1.85000000E-06  +8.90000000E-07
   -7.20000000E-07  -1.11000000E-06  +2.14000000E-06
   -7.90000000E-07  -1.31000000E-06  +1.98000000E-06
   +5.50000000E-07  +1.59000000E-06  +1.28000000E-06
   +4.20000000E-07  +7.70000000E-07  -7.70000000E-07
   -6.80000000E-07  -1.94000000E-06  -1.43000000E-06
   -3.30000000E-07  -1.01000000E-06  -1.09000000E-06
   +1.00000000E-07  +2.10000000E-07  +4.00000000E-07
   +5.70000000E-07  +1.42000000E-06  +3.40000000E-07
   +3.50000000E-07  +1.07000000E-06  +9.20000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.45120170E-01  +1.36097440E-01  +3.24979770E-01  -5.39704700E-02  +2.41573670E-01
   +6.07544480E-01  -2.23226660E-01  +2.23284900E-02  +1.32292860E-01  +5.95502330E-01
   -1.11764800E-02  -9.03222800E-02  -3.57169100E-02  +9.36470800E-02  +3.21920970E-01
   +7.37752500E-02  -5.48687800E-02  -2.08828030E-01  -8.12555400E-02  +1.86389620E-01
   +5.64934560E-01  +5.29883100E-02  +1.59066500E-02  +2.50954000E-03  -1.33087720E-01
   -1.94881600E-02  +3.87321000E-03  +6.88031820E-01  +4.18084000E-02  +5.62763000E-03
   -2.93979500E-02  -5.25313600E-02  -1.42493260E-01  -9.67247700E-02  +1.23572820E-01
   +3.08889930E-01  +4.84234000E-02  -1.45745800E-02  -4.53142000E-02  -5.53120600E-02
   -1.15292500E-01  -2.41087840E-01  -1.00662330E-01  +2.14615350E-01  +5.78918470E-01
   -6.59202600E-02  -6.73812000E-03  +2.44057300E-02  +7.36406000E-03  -4.34586200E-02
   -7.74791400E-02  -3.14600820E-01  -7.89578500E-02  +1.23178000E-02  +6.57502810E-01
   -9.23033000E-03  -4.41877000E-03  +3.88678000E-03  -1.70754200E-02  -8.60319000E-03
   -1.95274700E-02  -1.12543860E-01  -1.13973640E-01  -2.89927500E-02  +1.46720720E-01
   +3.17059740E-01  +2.04187200E-02  +2.51299000E-03  -1.09815500E-02  -2.99307500E-02
   -4.66632000E-03  +1.86921200E-02  -4.74240000E-02  -4.85895900E-02  -1.17612300E-01
   -5.51426200E-02  +2.48373840E-01  +5.94466210E-01  +1.06713500E-02  -1.74740200E-02
   -3.56657000E-02  -1.86661000E-03  +1.27826000E-02  +2.10723600E-02  -5.10340600E-02
   -1.30460500E-02  +8.22336000E-03  -2.08155790E-01  +2.90323900E-02  +1.32835000E-01
   +6.66811440E-01  -4.57131800E-02  -1.34012700E-02  -1.13480000E-04  +1.23848500E-02
   -1.85069000E-02  -2.93228900E-02  +1.55040200E-02  +2.39936300E-02  +2.93152500E-02
   -1.14578000E-02  -9.71069500E-02  -4.19069400E-02  +1.31695440E-01  +3.36821540E-01
   -8.60725700E-02  -1.69239300E-02  +2.26228700E-02  +1.97718000E-02  -2.94874000E-02
   -7.00116000E-02  +5.87648800E-02  +4.56964500E-02  +4.91616000E-02  +6.17012600E-02
   -6.58842900E-02  -2.21303480E-01  -6.43006500E-02  +2.26623900E-01  +6.01569450E-01
   -3.13703420E-01  -1.09087990E-01  -4.43925700E-02  -4.76763600E-02  +1.22899100E-02
   +5.38478800E-02  -3.24026100E-02  -2.54238900E-02  -2.81189100E-02  +5.23595500E-02
   +1.58003400E-02  +1.82444000E-03  -1.28102360E-01  -7.55144000E-03  +2.02693200E-02
   +6.99062850E-01  -7.52571100E-02  -1.13161940E-01  -4.78209100E-02  -1.33044700E-02
   +2.46725000E-02  +3.78103600E-02  -2.36627800E-02  -2.31099900E-02  -2.17275900E-02
   +3.82819400E-02  +7.18769000E-03  -2.46363900E-02  -4.55953400E-02  -1.43196160E-01
   -9.96503200E-02  +1.30499060E-01  +3.01554590E-01  +1.55784500E-02  -2.77270000E-02
   -1.19496930E-01  +8.99507000E-03  +2.32200100E-02  +4.25561900E-02  -2.48012100E-02
   -2.07513900E-02  -2.52611800E-02  +4.20155400E-02  -1.12075400E-02  -3.64246500E-02
   -4.70107900E-02  -1.22128290E-01  -2.59253390E-01  -1.05350350E-01  +2.25886740E-01
   +5.92583080E-01  -2.19469300E-02  -8.40907000E-03  -5.55370000E-04  -1.54606260E-01
   -2.74800900E-02  -5.07980000E-04  -9.95675000E-03  -8.23019000E-03  -7.94094000E-03
   +4.28247000E-03  -7.07160000E-04  +4.74610000E-04  -2.07874000E-03  +4.86750000E-04
   +1.33834000E-03  +4.36190000E-04  -6.97560000E-04  +3.30115000E-03  +4.56842440E-01
   +2.09890000E-03  +5.46611000E-03  +3.01393000E-03  -3.63255500E-02  -8.58668500E-02
   -8.88181000E-03  -1.69027500E-02  -6.57425000E-03  -2.37059000E-03  -5.16940000E-04
   +2.98608000E-03  -3.90432000E-03  -5.41600000E-05  -5.48790000E-04  -1.50810000E-04
   +8.63500000E-05  +4.35241000E-03  -3.96586000E-03  +2.92053000E-03  +4.76564670E-01
   +1.59080900E-02  +9.21828000E-03  +7.02601000E-03  -6.27949000E-03  -1.08114300E-02
   -8.36217800E-02  -2.55322800E-02  -8.81363000E-03  +1.76546000E-03  +2.35650000E-04
   -4.71429000E-03  -3.26550000E-03  -1.38490000E-04  -6.22380000E-04  -1.59146000E-03
   +3.47933000E-03  -3.03110000E-03  -8.04520000E-04  -1.37250000E-04  -7.52334000E-03
   +4.86690530E-01  -6.22520000E-04  -1.87192000E-03  -1.39355000E-03  -1.09438400E-02
   -2.41317200E-02  +2.28259900E-02  -7.03050000E-04  -1.06546000E-03  +9.91300000E-04
   +4.95200000E-05  +7.81860000E-04  +3.21420000E-04  +8.05960000E-04  +6.40600000E-04
   +8.07200000E-04  -1.55368000E-03  +6.42550000E-04  -1.26525000E-03  -7.61197600E-02
   -1.13510300E-02  +1.12704500E-02  +5.87863630E-01  +1.47271000E-03  -8.59370000E-04
   -5.76630000E-04  -1.13633700E-02  -1.37301700E-02  +9.64561000E-03  -1.56810000E-04
   -2.18960000E-04  +8.10450000E-04  +2.43430000E-04  +5.21300000E-04  +1.48370000E-04
   +5.17000000E-06  +2.47820000E-04  +4.25410000E-04  -4.49860000E-04  +1.86900000E-05
   -5.81330000E-04  -6.14368000E-03  -1.23614940E-01  +4.95834600E-02  -9.52280000E-03
   +5.21801850E-01  -6.40960000E-04  -1.99760000E-04  -2.75110000E-04  +6.80455000E-03
   +2.80303000E-03  +1.07885000E-03  -1.82882000E-03  -6.44720000E-04  -1.48690000E-04
   +1.44730000E-04  +5.86000000E-06  -1.53150000E-04  +3.25030000E-04  +1.27540000E-04
   +3.83960000E-04  -2.36860000E-04  -1.58300000E-04  -3.10990000E-04  +7.37404000E-03
   +4.78422600E-02  -1.26880120E-01  +8.15142000E-03  +6.33069000E-02  +5.36199930E-01
   +2.46749000E-03  +7.38240000E-04  +2.43326000E-03  -3.77532000E-03  -1.40558000E-03
   -2.25529000E-03  +3.36792000E-03  +1.70317000E-03  +5.39505000E-03  -4.93238400E-02
   -2.07196200E-02  -1.54490000E-03  -2.85931180E-01  -7.09909200E-02  +1.75617900E-02
   -1.94009400E-02  -1.67752000E-02  -1.36507600E-02  +1.56783000E-03  +2.44810000E-04
   +7.92860000E-04  -1.49591000E-03  -1.42180000E-04  -6.68390000E-04  +3.94884820E-01
   +4.07697000E-03  +3.56200000E-03  -5.34574000E-03  -2.17900000E-03  +5.47000000E-05
   +3.05079000E-03  -2.51009000E-03  +3.36331000E-03  -5.54004000E-03  -1.60052000E-03
   +8.82487000E-03  -1.04347000E-03  -9.61478600E-02  -9.01529000E-02  -2.41050100E-02
   -3.55480800E-02  -1.00803100E-02  -1.02906100E-02  +6.92740000E-04  -3.29480000E-04
   +7.86550000E-04  -6.99550000E-04  -9.77800000E-05  -2.88680000E-04  +1.43347680E-01
   +2.33037910E-01  +8.78448000E-03  -3.18605000E-03  -5.77898000E-03  -2.45449000E-03
   +3.15210000E-03  +5.56994000E-03  -2.00814000E-03  -8.02039000E-03  -5.63203000E-03
   +3.21127900E-02  +1.02891500E-02  +9.06542000E-03  -2.65304200E-02  -3.88665700E-02
   -9.69436800E-02  -4.67739400E-02  -2.14104700E-02  -2.50954000E-03  -5.60100000E-05
   +3.68130000E-04  +3.49680000E-04  -3.32560000E-04  -7.61300000E-05  -1.89450000E-04
   +3.54757100E-02  +2.76978570E-01  +4.92867990E-01  -2.21881000E-03  -8.88510000E-04
   -1.25702000E-03  -3.51007200E-02  +1.69377700E-02  +5.08040000E-03  -6.36900000E-05
   +2.45980000E-04  -8.36210000E-04  -1.40980000E-04  +2.35290000E-04  +8.83020000E-04
   -6.13590000E-04  -5.24120000E-04  -5.18270000E-04  +3.08240000E-04  -3.44010000E-04
   +1.14294000E-03  -1.11392070E-01  +4.36395500E-02  +1.65363000E-03  +2.55904000E-03
   +1.93964000E-03  -4.12353000E-03  +8.19990000E-04  +4.04440000E-04  +1.79160000E-04
   +5.17655230E-01  -2.34055000E-03  -1.89885000E-03  -9.63090000E-04  +1.48640000E-03
   +1.28092000E-02  +2.40186000E-03  -2.14140000E-03  -3.90310000E-04  -6.42350000E-04
   -3.22610000E-04  -6.17310000E-04  +6.06900000E-05  +8.75850000E-04  +6.60920000E-04
   +3.10640000E-04  -6.86150000E-04  -8.56510000E-04  +4.94850000E-04  +3.44329400E-02
   -1.29352910E-01  +5.47716000E-03  +1.74635800E-02  -2.34855800E-02  +3.80320000E-04
   -1.36244000E-03  -6.23730000E-04  -2.80150000E-04  -7.96147100E-02  +4.10774680E-01
   +1.44700000E-05  +4.97300000E-04  -7.24390000E-04  +1.53684000E-03  +1.61323000E-03
   -8.52920000E-04  -1.90479000E-03  +1.64550000E-04  +1.06239000E-03  -3.50720000E-04
   -1.87790000E-04  -3.94500000E-05  +7.11300000E-04  +2.42680000E-04  -5.53200000E-05
   +1.68210000E-04  -8.30600000E-05  -3.04650000E-04  +1.03133100E-02  -1.88085000E-03
   -7.91370300E-02  -1.66744300E-02  +1.88796700E-02  +3.17368000E-03  -8.11590000E-04
   -3.68780000E-04  -1.92120000E-04  -2.54867020E-01  -9.46542200E-02  +5.66018060E-01
   +1.50650000E-04  -4.72500000E-05  -1.27480000E-04  +3.68610000E-04  +2.27458000E-03
   -1.21644000E-03  -1.22590000E-04  -1.38140000E-04  -5.79700000E-05  -7.09200000E-05
   -8.75600000E-05  +2.03000000E-06  -6.00600000E-05  +4.63500000E-05  -2.75000000E-06
   -1.99810000E-04  -2.49480000E-04  +9.34300000E-05  +4.17331000E-03  +1.60747100E-02
   -1.61763700E-02  -3.26721000E-03  +3.56852000E-03  +1.86729000E-03  -6.42000000E-05
   -6.40000000E-05  +2.05600000E-05  -1.04480960E-01  -1.38933100E-02  +2.19089200E-02
   +7.19797730E-01  -6.67700000E-05  -1.31360000E-04  +4.71780000E-04  +7.99620000E-04
   -1.67276000E-03  +1.31648000E-03  -1.61270000E-04  -6.92280000E-04  -4.65070000E-04
   +3.01880000E-04  +2.09140000E-04  -1.21720000E-04  -4.01420000E-04  -2.00700000E-05
   +1.06490000E-04  -1.47290000E-04  -1.95700000E-05  +7.83100000E-05  +7.06050000E-03
   -1.97467000E-02  +1.91875200E-02  +3.19575000E-03  -1.51463000E-03  -1.15672000E-03
   +4.32000000E-04  +1.93960000E-04  +7.75900000E-05  +1.56289000E-03  -1.50128690E-01
   +6.79119100E-02  -8.57833500E-02  +3.89885170E-01  +9.42740000E-04  +1.34240000E-04
   -6.15140000E-04  -1.41137000E-03  +1.94574000E-03  -3.84140000E-04  -6.31500000E-04
   +9.55410000E-04  +5.87000000E-06  +5.90320000E-04  +1.29120000E-04  -2.09700000E-05
   +6.34800000E-05  +2.40040000E-04  +4.78700000E-04  -3.67530000E-04  -3.49650000E-04
   -2.63020000E-04  -8.66231000E-03  +3.69766000E-03  +2.59793000E-03  +1.93161000E-03
   -8.77640000E-04  +2.43000000E-05  -1.66010000E-04  -7.19700000E-05  -7.54200000E-05
   +1.11615600E-02  +7.17577400E-02  -1.45240300E-01  +8.75653200E-02  -2.62009670E-01
   +4.46090000E-01  +2.76630000E-04  +2.10580000E-04  -3.72460000E-04  -6.92300000E-04
   +4.77000000E-05  -5.12190000E-04  +1.16150000E-04  +6.31030000E-04  +2.63800000E-04
   -7.30500000E-05  +3.61000000E-06  +1.39080000E-04  +4.02810000E-04  +3.54700000E-05
   +2.47100000E-05  +1.46480000E-04  +5.03300000E-05  -1.29370000E-04  +9.58260000E-04
   -1.78454000E-03  +2.12452000E-03  +5.23950000E-04  -4.53860000E-04  -1.00510000E-04
   -3.73830000E-04  -1.29440000E-04  -7.69400000E-05  +1.51213700E-02  +3.26402000E-03
   -6.18921000E-03  -3.11877260E-01  +1.15315320E-01  -1.45746040E-01  +6.46483300E-01
   +1.72690000E-04  +7.44600000E-05  -1.87020000E-04  -6.48040000E-04  +3.60650000E-04
   -1.40830000E-04  -8.93200000E-05  +2.13930000E-04  +4.31700000E-05  +9.53200000E-05
   +6.13300000E-05  -1.19600000E-05  +8.29200000E-05  +3.37900000E-05  +6.76900000E-05
   -2.48200000E-05  -4.61600000E-05  -3.42200000E-05  -2.06334000E-03  -1.34052000E-03
   +1.85338000E-03  +5.90010000E-04  -5.52040000E-04  -2.77980000E-04  -8.02100000E-05
   -2.90600000E-05  -1.50900000E-05  +1.08624300E-02  -1.28767800E-02  +2.06611500E-02
   +1.30237170E-01  -1.56118270E-01  +1.30170430E-01  -5.25149300E-02  +3.75122700E-01
   -1.73680000E-04  -1.29450000E-04  +1.17680000E-04  +7.37590000E-04  -2.60890000E-04
   +3.18810000E-04  -2.24000000E-06  -2.71510000E-04  -1.35230000E-04  +4.98400000E-05
   -8.20000000E-07  -2.68400000E-05  -1.99850000E-04  -4.36700000E-05  -1.59100000E-05
   -3.98700000E-05  +4.35000000E-05  +8.00900000E-05  +2.91592000E-03  +4.53180000E-04
   -2.45479000E-03  -7.42320000E-04  +5.41750000E-04  +5.42630000E-04  +1.97050000E-04
   +9.27100000E-05  +3.49100000E-05  -1.51766600E-02  +1.42306900E-02  -1.19122500E-02
   -1.73210100E-01  +1.39104600E-01  -2.21725090E-01  +1.03727170E-01  -3.09598510E-01
   +5.19470000E-01  -9.51900000E-05  -1.76940000E-04  +2.64560000E-04  -1.06260000E-04
   +1.57000000E-04  +1.14780000E-04  -9.01200000E-05  -4.21870000E-04  -1.49460000E-04
   +2.16120000E-04  -7.25400000E-05  -1.68960000E-04  -8.98860000E-04  -2.16740000E-04
   -5.92500000E-05  -1.06780000E-04  -6.03600000E-05  +2.40510000E-04  -1.20264000E-03
   -2.32100000E-04  +1.79467000E-03  +7.82250000E-04  -5.12140000E-04  -9.50000000E-07
   +8.90710000E-04  +3.10890000E-04  +1.70470000E-04  +4.73569000E-03  +6.24480000E-03
   -9.96857000E-03  -3.84711000E-03  +6.49551000E-03  -9.34652000E-03  -1.68091620E-01
   -1.98366600E-02  +2.04344600E-02  +6.01015310E-01  -1.94370000E-04  -1.30120000E-04
   -2.46200000E-05  +3.77230000E-04  +2.88680000E-04  +1.89890000E-04  -2.19000000E-05
   -2.14820000E-04  -7.65500000E-05  -1.70260000E-04  -2.39000000E-06  +7.37100000E-05
   +2.60580000E-04  +1.37920000E-04  +4.00000000E-07  -9.65600000E-05  -7.82900000E-05
   +1.25500000E-05  +6.59100000E-05  -5.90350000E-04  +1.25899000E-03  +1.40400000E-04
   -1.04600000E-04  +7.42600000E-05  -3.36340000E-04  -1.79400000E-04  -1.51000000E-05
   +4.08524000E-03  -6.18660000E-04  -1.17487500E-02  +1.61657100E-02  +4.71586000E-03
   +2.07453000E-03  -1.27739800E-02  -9.26436100E-02  +3.80770000E-04  -2.68822100E-02
   +3.74443620E-01  -1.21200000E-04  +1.11040000E-04  +2.83220000E-04  +1.70830000E-04
   -9.02240000E-04  -2.11310000E-04  +2.70310000E-04  +1.04160000E-04  +2.41780000E-04
   -1.55000000E-06  -1.29230000E-04  -1.88290000E-04  -4.75180000E-04  -3.50870000E-04
   -2.76170000E-04  +4.05070000E-04  +3.85620000E-04  +1.08880000E-04  -3.58710000E-04
   +7.19210000E-04  -8.41900000E-04  +1.02430000E-04  -5.74500000E-05  -2.24690000E-04
   +7.00240000E-04  +3.35420000E-04  +5.99300000E-05  -4.93987000E-03  -7.40280000E-03
   +5.07899000E-03  -2.18374600E-02  +3.28810000E-04  +3.04570000E-03  +1.09323000E-02
   -7.25691000E-03  -8.10874800E-02  +9.09326500E-02  -2.85126760E-01  +7.74011340E-01
   +8.57000000E-05  +6.04900000E-05  -2.54520000E-04  +3.57800000E-05  +2.20670000E-04
   -4.81500000E-05  +1.55800000E-05  +2.23390000E-04  +6.69100000E-05  -1.52490000E-04
   +6.17000000E-05  +1.47880000E-04  +6.50600000E-04  +2.16330000E-04  +9.46700000E-05
   -4.00300000E-05  -6.03200000E-05  -1.56330000E-04  +6.01810000E-04  -9.73000000E-06
   -5.29140000E-04  -3.99870000E-04  +2.62550000E-04  +8.60500000E-05  -7.02890000E-04
   -2.73230000E-04  -1.14270000E-04  -1.17061000E-03  -2.68426000E-03  +3.21714000E-03
   -8.82388000E-03  -3.10258000E-03  +2.80742000E-03  -4.02360700E-02  +2.10125200E-02
   -5.04450100E-02  -2.40294500E-01  +1.00877180E-01  -2.15368400E-01  +2.49940070E-01
   +1.75900000E-05  +2.54600000E-05  +1.10500000E-04  -1.00060000E-04  -2.58000000E-04
   -4.26900000E-05  +3.32400000E-05  +2.29000000E-06  +1.12600000E-05  +9.73100000E-05
   -1.42300000E-05  -8.49400000E-05  -3.25210000E-04  -1.51990000E-04  -6.40400000E-05
   +8.69700000E-05  +9.43500000E-05  +5.66900000E-05  -2.16190000E-04  +2.36320000E-04
   -3.81350000E-04  +7.57100000E-05  -9.80000000E-06  -6.79400000E-05  +3.92020000E-04
   +1.88760000E-04  +4.54100000E-05  -1.53226000E-03  -4.48590000E-04  +3.12165000E-03
   -3.85970000E-04  +2.67859000E-03  -3.05133000E-03  +9.27102000E-03  +1.68465400E-02
   +1.64215700E-02  +1.07726780E-01  -1.62799160E-01  +1.77645410E-01  -1.18198820E-01
   +1.52452040E-01  +9.36300000E-05  -3.98000000E-05  -3.07120000E-04  -5.16200000E-05
   +6.28550000E-04  +9.49100000E-05  -1.07630000E-04  +6.23900000E-05  -8.26700000E-05
   -8.90900000E-05  +9.28600000E-05  +1.78700000E-04  +5.59540000E-04  +2.76470000E-04
   +1.72520000E-04  -2.25550000E-04  -2.23400000E-04  -1.12350000E-04  +4.33150000E-04
   -5.50390000E-04  +6.38000000E-04  -1.54390000E-04  +9.13000000E-05  +1.72410000E-04
   -7.02210000E-04  -3.08640000E-04  -7.76800000E-05  +2.43355000E-03  +1.05842000E-03
   -3.41082000E-03  -1.18936000E-03  -3.91067000E-03  +4.66164000E-03  -2.91868600E-02
   +2.02295300E-02  -1.11917200E-02  -2.22256920E-01  +1.76973750E-01  -4.40810230E-01
   +2.56114890E-01  -2.50519340E-01  +5.32723450E-01  -2.17927000E-03  -7.60080000E-04
   -4.45140000E-04  -6.41808000E-03  -1.58445800E-02  -3.05058200E-02  -5.95060000E-03
   -1.39522000E-03  +1.10651000E-03  +8.26000000E-06  -9.95520000E-04  -1.28449000E-03
   +3.80480000E-04  +7.99800000E-05  +4.16000000E-05  +3.00230000E-04  -4.33330000E-04
   -1.09089000E-03  -7.70286200E-02  -3.33497000E-03  -8.94785000E-03  +1.13327000E-03
   +2.10539000E-03  +3.48770000E-03  -5.86500000E-04  -2.47850000E-04  -9.65200000E-05
   +3.40487000E-03  +9.71652000E-03  +2.02749000E-02  -7.21190000E-04  +1.31266000E-03
   +2.72620000E-04  +3.39920000E-04  +4.06710000E-04  +6.43770000E-04  +2.94430000E-04
   -1.36560000E-04  +2.69900000E-04  -2.41170000E-04  +1.52310000E-04  -3.87490000E-04
   +5.82286970E-01  +6.20000000E-05  -5.49760000E-04  +5.24240000E-04  -5.77027000E-03
   -6.67177000E-03  -1.19486400E-02  -1.97148000E-03  +2.80000000E-04  +1.69750000E-04
   +1.81410000E-04  -1.39510000E-04  -5.21140000E-04  -2.13920000E-04  +2.04110000E-04
   -3.69000000E-06  +2.60820000E-04  -2.99580000E-04  -4.85880000E-04  -8.58963000E-03
   -9.54075300E-02  -3.97049000E-02  +2.63859000E-03  +9.07609000E-03  +2.10570800E-02
   +9.64100000E-05  +4.60000000E-06  -3.60000000E-07  -1.67200000E-05  -1.69679000E-02
   -2.60209300E-02  +1.51358000E-03  -2.41876000E-03  -5.54520000E-04  -5.18390000E-04
   +2.88660000E-04  -6.95180000E-04  +5.40230000E-04  +6.42140000E-04  -7.30130000E-04
   -5.17200000E-05  -2.10310000E-04  +4.59530000E-04  -1.18729300E-02  +5.64096790E-01
   +1.17348000E-03  +5.76250000E-04  +3.72860000E-04  -5.69829000E-03  -2.39503000E-03
   -3.32266000E-03  +7.66040000E-04  +3.21420000E-04  +1.50330000E-04  +5.32520000E-04
   -1.16400000E-05  -2.45000000E-06  -2.90210000E-04  -2.75800000E-05  +2.95230000E-04
   +2.51150000E-04  -7.99800000E-05  -3.47300000E-04  -1.57366100E-02  -3.26707900E-02
   -1.51619940E-01  -3.33079000E-03  -6.69528000E-03  -3.56329900E-02  +3.37480000E-04
   +1.24250000E-04  -7.75000000E-06  +7.81816000E-03  -1.24488900E-02  -7.08076000E-03
   -2.52080000E-04  +9.51900000E-04  +4.10080000E-04  +5.20110000E-04  -3.97840000E-04
   -4.86790000E-04  -1.05068000E-03  -2.35340000E-04  +7.42010000E-04  +2.37170000E-04
   +1.38540000E-04  -3.03170000E-04  -2.28850100E-02  -5.46455100E-02  +4.95499070E-01
   -2.89360000E-04  -2.47670000E-04  -5.76560000E-04  +4.57230000E-04  +1.73872000E-03
   -2.67510000E-04  -6.80260000E-04  +2.70520000E-04  +4.12630000E-04  -2.03270000E-04
   +1.15030000E-04  +1.37350000E-04  +9.38640000E-04  +5.69890000E-04  +4.03860000E-04
   -4.18130000E-04  -4.47910000E-04  -2.14330000E-04  -1.13510000E-02  +8.66583000E-03
   +2.04860800E-02  -2.29975000E-03  -1.83060000E-04  +8.73350000E-04  -1.23765000E-03
   -5.98590000E-04  -2.11030000E-04  -2.53283980E-01  +3.14465000E-02  +1.99352190E-01
   +8.09373000E-03  -1.16995200E-02  +1.78667500E-02  -5.13249000E-03  +5.25257000E-03
   -1.11922000E-03  -1.19397100E-02  -6.62445000E-03  +9.87683000E-03  +2.75732000E-03
   +3.01500000E-03  -5.16408000E-03  -3.68772000E-03  +1.59284000E-03  -2.89694000E-03
   +5.08710430E-01  +9.98860000E-04  +6.58950000E-04  +9.57580000E-04  +3.66820000E-04
   -5.00178000E-03  -1.28634000E-03  +2.47200000E-04  +6.96100000E-05  -5.81230000E-04
   +4.50820000E-04  +2.28290000E-04  -1.54520000E-04  -1.13694000E-03  -6.13090000E-04
   -3.05150000E-04  +4.69200000E-04  +6.22440000E-04  +1.75100000E-05  +1.89725700E-02
   +4.82367000E-03  -1.86688700E-02  +1.92802000E-03  -1.39922000E-03  -2.12249000E-03
   +1.47172000E-03  +6.67390000E-04  +2.95060000E-04  +1.20497000E-02  -1.06573280E-01
   +2.28629600E-02  -1.54813500E-02  +7.59528000E-03  +1.97578900E-02  +9.49700000E-05
   -1.21624000E-03  -7.49030000E-04  +5.67716000E-03  +3.93909000E-03  -4.25826000E-03
   -1.21076000E-03  -1.41805000E-03  +1.60755000E-03  +3.55112000E-03  -2.92393000E-03
   +1.50508000E-03  -1.32206900E-01  +5.33394190E-01  +4.06840000E-04  +7.15000000E-06
   +1.02235000E-03  -1.09250000E-03  -2.26100000E-03  -6.83350000E-04  -1.46860000E-04
   -2.55790000E-04  -1.47680000E-03  +7.62300000E-05  +4.21110000E-04  +2.58720000E-04
   -6.56650000E-04  -4.58330000E-04  -2.85630000E-04  +1.80230000E-04  +2.60700000E-04
   +1.89420000E-04  +9.54638000E-03  -1.35579000E-03  +3.39911000E-03  -3.27970000E-04
   +2.88480000E-04  -1.00616000E-03  +7.26150000E-04  +3.30620000E-04  +2.52510000E-04
   +2.07909160E-01  +3.93735000E-03  -2.97746150E-01  +1.81603600E-02  +6.40932000E-03
   -2.08063300E-02  +1.14081000E-03  -1.71661000E-03  +1.58253000E-03  +8.66160000E-03
   +4.99412000E-03  -7.09670000E-03  -2.52543000E-03  -1.85834000E-03  +2.38652000E-03
   -4.24420000E-04  +9.77100000E-04  +1.43053000E-03  -2.89705420E-01  -1.82413120E-01
   +5.55448620E-01  +4.21300000E-05  +1.29470000E-04  +1.33130000E-03  +9.66910000E-04
   -3.37891000E-03  -7.43530000E-04  +6.66850000E-04  -1.88080000E-04  -1.31810000E-04
   +2.52900000E-04  -3.41100000E-04  -4.88780000E-04  -1.72881000E-03  -1.07182000E-03
   -8.11750000E-04  +9.21840000E-04  +8.47200000E-04  +4.08090000E-04  +5.03026000E-03
   +5.18231000E-03  +4.63558000E-03  +1.24310000E-03  -5.97010000E-04  -6.06560000E-04
   +2.30915000E-03  +1.03204000E-03  +3.80180000E-04  -4.04072300E-02  +6.64557000E-03
   +3.02830500E-02  -7.94751000E-03  +1.39981000E-03  -7.31116000E-03  +8.09310000E-04
   -7.76900000E-04  +6.12060000E-04  +2.58930000E-02  +1.20714300E-02  -1.49049800E-02
   -5.64592000E-03  -5.70489000E-03  +8.30692000E-03  +5.99100000E-05  +5.86160000E-04
   +1.79516000E-03  -1.29934210E-01  +8.42598100E-02  -1.66145900E-02  +6.55650020E-01
   -2.00000000E-06  -6.39500000E-05  -3.74530000E-04  +1.27754000E-03  +6.44470000E-04
   -4.47980000E-04  -5.46200000E-04  -8.47000000E-06  -6.15000000E-06  -1.87820000E-04
   +8.93500000E-05  +2.31710000E-04  +8.55300000E-04  +5.01510000E-04  +4.20650000E-04
   -4.09200000E-04  -3.69540000E-04  -2.95080000E-04  +3.67768000E-03  +2.51184000E-03
   +7.63311000E-03  -1.51790000E-04  -4.87490000E-04  +4.38650000E-04  -1.18795000E-03
   -5.76730000E-04  -1.94750000E-04  +1.29299500E-02  +9.03346000E-03  -1.89553900E-02
   -2.53254000E-03  -2.81665000E-03  -1.81720000E-04  +2.20700000E-05  +5.84600000E-05
   +1.27213000E-03  -7.42544000E-03  -6.07623000E-03  +1.04088400E-02  +1.75801000E-03
   +2.38229000E-03  -1.84441000E-03  -2.70959000E-03  +2.30591000E-03  -1.48972000E-03
   +8.10018700E-02  -2.20573660E-01  +2.35890900E-02  -2.93308400E-02  +6.39070200E-01
   +2.43840000E-04  +1.86360000E-04  +2.06890000E-04  +1.03793000E-03  -1.53012000E-03
   -8.52960000E-04  -1.82420000E-04  +1.62400000E-04  -3.60600000E-05  -4.85500000E-05
   +7.47500000E-05  +1.22100000E-05  +2.18580000E-04  +1.56900000E-05  +3.05300000E-05
   +1.23570000E-04  +1.19430000E-04  -2.15610000E-04  +5.76161000E-03  +5.16542000E-03
   +6.39480000E-04  -7.93400000E-04  +8.58880000E-04  +3.95200000E-05  -2.13990000E-04
   -7.10100000E-05  -7.31800000E-05  +1.91743100E-02  -2.36177300E-02  -3.66610000E-04
   -2.14179000E-03  -3.28917000E-03  -3.39675000E-03  +3.73020000E-04  +1.13981000E-03
   -6.15890000E-04  +2.65218100E-02  +1.87978300E-02  -2.46345400E-02  -2.76579000E-03
   -1.07598400E-02  +1.41977400E-02  -5.43150000E-04  +6.83190000E-04  +3.66640000E-04
   +1.67426700E-02  +1.13004000E-02  -8.63532800E-02  -2.85873840E-01  -1.39890400E-01
   +3.58046210E-01  -7.74700000E-05  -1.07640000E-04  -7.05280000E-04  +8.43400000E-05
   +1.77323000E-03  +2.78850000E-04  -2.95270000E-04  +1.37610000E-04  +2.03000000E-05
   -3.11930000E-04  +1.70320000E-04  +3.50340000E-04  +1.36490000E-03  +6.80210000E-04
   +4.39110000E-04  -4.86380000E-04  -4.61480000E-04  -3.03460000E-04  -7.18490000E-04
   -2.14505000E-03  +2.04700000E-03  -6.92110000E-04  -8.33600000E-05  +4.44470000E-04
   -1.69885000E-03  -7.24480000E-04  -2.82420000E-04  +8.53819000E-03  +1.00883700E-02
   -1.25091600E-02  +2.15085000E-03  -1.01425000E-03  +2.89286000E-03  -9.37810000E-04
   +2.15253000E-03  +3.20850000E-04  -2.32517000E-03  +1.47967000E-03  +7.89990000E-04
   +2.56861000E-03  -2.79856000E-03  +1.96148000E-03  -1.24948000E-03  +6.79170000E-04
   -9.46920000E-04  -5.54013400E-02  +1.50781300E-02  +4.99867700E-02  -3.87069370E-01
   -4.92567900E-02  +2.01751620E-01  +4.97980700E-01  +4.90300000E-05  +7.34700000E-05
   +1.57410000E-04  -3.21600000E-04  -4.12930000E-04  -5.59500000E-05  +1.14720000E-04
   +3.68300000E-05  +1.94200000E-05  +1.03580000E-04  -1.30400000E-05  -1.15160000E-04
   -3.87740000E-04  -2.04910000E-04  -1.30100000E-04  +1.54220000E-04  +1.46200000E-04
   +8.99200000E-05  -5.67380000E-04  +1.56300000E-05  -2.28186000E-03  +9.78000000E-06
   +1.54090000E-04  -1.38380000E-04  +5.10750000E-04  +2.42120000E-04  +7.74100000E-05
   +1.37496000E-03  -5.09308000E-03  +4.57375000E-03  +8.08800000E-05  -5.72000000E-06
   +5.96760000E-04  -3.55300000E-04  +4.21540000E-04  -2.35620000E-04  +1.29080000E-04
   +2.03130000E-04  -2.25337000E-03  -5.65020000E-04  +6.09660000E-04  -4.22430000E-04
   +8.01130000E-04  -6.33110000E-04  +4.78160000E-04  +3.42280400E-02  +1.29115800E-02
   -2.64175300E-02  -3.85982300E-02  -1.13771920E-01  +5.63950400E-02  -1.84554000E-03
   +1.43096290E-01  -2.90000000E-07  -1.81800000E-05  +1.65680000E-04  -3.92090000E-04
   -1.44980000E-04  +2.49550000E-04  +2.33610000E-04  -1.43660000E-04  -7.38300000E-05
   +9.63500000E-05  -6.73300000E-05  -6.90200000E-05  -4.32660000E-04  -1.97830000E-04
   -1.61430000E-04  +9.24400000E-05  +1.04480000E-04  +1.67700000E-04  -1.25470000E-03
   -8.27630000E-04  -1.51027000E-03  +3.22900000E-04  -1.51100000E-05  -3.05310000E-04
   +5.40380000E-04  +2.28650000E-04  +1.22920000E-04  -4.46067000E-03  +8.02490000E-04
   +7.26761000E-03  +2.18610000E-04  +9.61320000E-04  -5.49460000E-04  +5.74820000E-04
   -5.18020000E-04  +4.31400000E-05  -1.02354300E-02  -6.67939000E-03  +4.71555000E-03
   +9.13160000E-04  +4.10097000E-03  -5.23714000E-03  +7.46730000E-04  -6.05770000E-04
   +3.93040000E-04  +2.53907500E-02  -1.06069500E-02  -5.08890000E-04  +2.21445140E-01
   +5.98944300E-02  -2.27572700E-01  -2.31471900E-01  -8.71707900E-02  +3.02950030E-01
   +7.83300000E-05  +7.87200000E-05  -2.78920000E-04  -2.71600000E-05  +3.25440000E-04
   -6.39600000E-05  -7.34100000E-05  +2.24350000E-04  +5.94600000E-05  -1.45170000E-04
   +1.00740000E-04  +1.51200000E-04  +6.98730000E-04  +2.63870000E-04  +1.58600000E-04
   -8.47800000E-05  -9.04900000E-05  -1.97530000E-04  +7.69300000E-04  -3.47850000E-04
   -7.05200000E-04  -5.58420000E-04  +2.01510000E-04  +1.06690000E-04  -7.83400000E-04
   -2.98810000E-04  -1.49490000E-04  -5.03430000E-04  -8.55520000E-04  +2.96920000E-04
   -3.42210000E-04  -1.97575000E-03  +3.52130000E-04  -2.69191800E-02  -2.35117100E-02
   +3.41153300E-02  -1.89881280E-01  -6.06469500E-02  +1.03169370E-01  +4.28418500E-02
   +3.18790000E-04  +1.71502000E-03  -3.36150000E-04  -8.51200000E-05  +1.77500000E-04
   -4.17170000E-03  +2.39747000E-03  -6.03606000E-03  -2.48656900E-02  -5.69496000E-03
   +5.06770000E-03  +1.97922500E-02  -1.08161000E-03  +8.02628000E-03  +2.27698170E-01
   +2.71000000E-05  +6.43100000E-05  +7.64500000E-05  -9.52800000E-05  -3.06560000E-04
   -3.40600000E-05  +1.33150000E-04  +7.63600000E-05  +3.15500000E-05  +6.89100000E-05
   -8.68000000E-06  -6.67400000E-05  -2.42320000E-04  -1.55960000E-04  -9.14500000E-05
   +1.35870000E-04  +1.36260000E-04  +5.70000000E-05  -8.39300000E-05  +4.32800000E-04
   -6.81340000E-04  -1.23060000E-04  +3.82100000E-05  -4.65200000E-05  +3.42660000E-04
   +1.79810000E-04  +3.97900000E-05  -1.07837000E-03  -1.98270000E-04  +4.75977000E-03
   -2.30930000E-03  -2.10101000E-03  +9.24320000E-04  -1.09302500E-02  +1.32431000E-02
   +1.03040700E-02  -6.47160400E-02  -1.34404470E-01  +1.07630050E-01  -4.04483000E-03
   -4.93935000E-03  +5.58975900E-02  -1.64730000E-04  -5.09990000E-04  +2.87960000E-04
   +7.18680000E-03  +9.14800000E-04  +1.03064000E-03  -9.36802000E-03  -1.09639300E-02
   -1.31685200E-02  -3.47141000E-03  +4.59721000E-03  +3.97298000E-03  +7.00401900E-02
   +1.54932840E-01  +1.77400000E-05  -1.53680000E-04  -2.28550000E-04  +3.70700000E-05
   +8.25960000E-04  +2.80750000E-04  -1.38860000E-04  -1.99970000E-04  -2.34330000E-04
   -1.32600000E-05  +9.76900000E-05  +1.43590000E-04  +2.42590000E-04  +2.42830000E-04
   +1.81980000E-04  -3.52360000E-04  -2.90490000E-04  -2.10000000E-07  -4.00200000E-05
   -6.31950000E-04  +1.69331000E-03  +6.51700000E-05  -1.76550000E-04  +2.31800000E-04
   -4.19200000E-04  -2.22440000E-04  -4.38000000E-06  +7.58919000E-03  +5.53946000E-03
   -1.28556900E-02  +4.36985000E-03  +3.20410000E-04  +3.86700000E-05  +1.37638000E-02
   +1.28117600E-02  -2.95747000E-03  +9.96332400E-02  +9.49092300E-02  -2.33082340E-01
   +1.19482300E-02  +6.55696100E-02  -9.31557400E-02  -7.67870000E-04  +7.53690000E-04
   -9.72120000E-04  -1.97020200E-02  +1.07075700E-02  +8.32099000E-03  +2.58801400E-02
   -1.86791100E-02  +2.89810800E-02  -2.30090000E-04  +3.40030000E-04  -2.18211500E-02
   -1.49189860E-01  -1.57554370E-01  +3.65579400E-01  +9.10000000E-06  -1.93800000E-05
   -2.83120000E-04  +1.42900000E-05  +6.22640000E-04  +1.21340000E-04  -8.25300000E-05
   +7.01100000E-05  -3.43000000E-05  -1.56610000E-04  +8.86300000E-05  +1.78120000E-04
   +7.14790000E-04  +3.26270000E-04  +1.88850000E-04  -2.04790000E-04  -1.87240000E-04
   -1.59800000E-04  +3.62900000E-05  -7.30000000E-04  +2.75290000E-04  -3.09440000E-04
   +8.03700000E-05  +1.12510000E-04  -8.52380000E-04  -3.51900000E-04  -1.34220000E-04
   +1.78117000E-03  +1.01694000E-03  -2.14374000E-03  +1.88180000E-04  +4.84700000E-05
   +4.41420000E-04  -6.88570000E-04  -1.60705000E-03  +2.72640000E-04  -8.47160000E-04
   +1.18813900E-02  -1.42487500E-02  +3.77611000E-03  -3.40157000E-03  +6.27746000E-03
   -3.79500000E-04  +2.47550000E-04  -2.49070000E-04  -4.14640000E-03  +2.90844000E-03
   +6.35548000E-03  +1.49318700E-02  +2.29302000E-03  -1.59589800E-02  -6.53304700E-02
   +3.48883900E-02  -3.38367200E-02  -3.38439500E-02  +1.75488200E-02  +3.86965300E-02
   +6.28560180E-01  -4.10000000E-07  +1.32900000E-05  +1.61510000E-04  -1.50300000E-05
   -3.51300000E-04  -6.24700000E-05  +5.53400000E-05  -3.73100000E-05  -2.10000000E-06
   +9.19400000E-05  -3.83100000E-05  -1.02920000E-04  -4.09900000E-04  -1.92710000E-04
   -1.12170000E-04  +1.16130000E-04  +1.13280000E-04  +9.65300000E-05  +1.47300000E-05
   +4.28920000E-04  -1.06770000E-04  +1.43530000E-04  -5.47100000E-05  -7.25900000E-05
   +4.92970000E-04  +2.14900000E-04  +7.87700000E-05  -1.13224000E-03  -6.49830000E-04
   +1.30678000E-03  -1.16890000E-04  -2.18000000E-06  -1.59620000E-04  +7.05470000E-04
   +1.19549000E-03  -1.16546000E-03  +3.40232000E-03  -7.21166000E-03  +8.82571000E-03
   -2.19265000E-03  +2.19988000E-03  -3.58920000E-03  +1.63170000E-04  -1.31690000E-04
   +1.39100000E-04  +2.19877000E-03  -1.62943000E-03  -3.62860000E-03  -5.95052000E-03
   -1.54499000E-03  +7.23856000E-03  +3.52629800E-02  +8.23000000E-06  +1.36843100E-02
   +2.27824500E-02  +2.19937000E-03  -2.18373700E-02  +1.31101050E-01  +2.20147470E-01
   -1.32600000E-05  -5.30300000E-05  -5.74800000E-05  -3.45500000E-05  +2.66540000E-04
   +1.52260000E-04  +1.54400000E-05  -7.29000000E-05  -7.45600000E-05  -1.26000000E-06
   +1.58100000E-05  +3.86900000E-05  +3.36400000E-05  +4.64800000E-05  +2.82000000E-05
   -8.59600000E-05  -6.42100000E-05  +2.53000000E-05  -4.53050000E-04  -3.49740000E-04
   +4.15730000E-04  +3.14400000E-05  -7.58300000E-05  +2.82200000E-05  -6.61000000E-05
   -3.65600000E-05  +1.17200000E-05  +1.78135000E-03  +2.36925000E-03  -2.61339000E-03
   +1.07156000E-03  +1.84890000E-04  +5.92280000E-04  +7.01490000E-04  +3.08843000E-03
   -8.09610000E-04  -1.50003000E-03  -1.05997600E-02  +1.66272800E-02  -6.74100000E-04
   +5.89920000E-04  -5.26707000E-03  -2.08100000E-04  +6.61600000E-05  -2.39840000E-04
   -4.60253000E-03  +2.39127000E-03  +7.83389000E-03  +1.60097900E-02  +4.44124000E-03
   -3.49949200E-02  -8.37855900E-02  +2.74123900E-02  -9.02451000E-03  +5.59866400E-02
   -1.98424000E-02  -2.74606100E-02  -8.04874600E-02  +4.78408100E-02  +2.57315670E-01
   +1.33386000E-03  -8.87010000E-04  -1.30221000E-03  +1.69200000E-05  +3.84380000E-04
   +7.67730000E-04  -6.46250000E-04  -1.97220000E-04  -3.45750000E-04  +2.21327000E-03
   -6.13500000E-05  -1.96193000E-03  -9.67778000E-03  -2.59536700E-02  -4.15780100E-02
   -6.63823000E-03  -2.36519000E-03  +1.07913000E-03  -1.74940000E-04  +4.40800000E-05
   +1.10460000E-04  +6.17500000E-05  -1.48500000E-05  -8.20000000E-06  -4.30965600E-02
   -1.17004300E-02  +2.62960000E-03  -8.93400000E-05  +7.59400000E-05  +3.75400000E-05
   -1.43100000E-05  -1.63500000E-05  +1.62800000E-05  +4.98300000E-05  +1.51100000E-05
   -2.15100000E-05  -1.57000000E-04  +4.20500000E-05  -8.79400000E-05  +1.12530000E-04
   -4.97300000E-05  +9.67300000E-05  +8.79100000E-05  +6.81000000E-06  -2.24100000E-05
   +1.33890000E-04  -1.22690000E-04  -3.15900000E-05  -2.93510000E-04  +1.25790000E-04
   +4.40400000E-05  +2.33450000E-04  -5.74400000E-05  -6.78000000E-05  +1.28160000E-04
   -3.60200000E-05  +4.68400000E-05  +1.31690000E-04  -7.02400000E-05  +8.17000000E-06
   +5.76065100E-02  +1.23800000E-05  +9.02720000E-04  -1.44596000E-03  +1.09440000E-04
   +2.97330000E-04  +3.49370000E-04  -2.53400000E-05  -8.48180000E-04  -3.26460000E-04
   +3.22069000E-03  +1.16214000E-03  +1.79021000E-03  -2.33826000E-03  -1.26398900E-02
   -1.58899000E-02  -3.05188000E-03  +1.46633000E-03  +5.06620000E-04  -1.04040000E-04
   -4.71000000E-05  -3.15000000E-06  +5.80400000E-05  -1.13000000E-06  +3.00300000E-05
   -3.73025400E-02  -1.43980660E-01  -2.24269330E-01  -7.30200000E-05  +1.31480000E-04
   +5.06700000E-05  +2.20400000E-05  -4.86600000E-05  +1.58000000E-06  +2.15900000E-05
   +1.15000000E-06  -2.14000000E-05  -4.62600000E-05  +5.13400000E-05  -8.10700000E-05
   +5.02200000E-05  -4.92900000E-05  +6.80400000E-05  +4.56000000E-05  -1.53400000E-05
   -1.50800000E-05  +1.24040000E-04  -1.39170000E-04  -5.32000000E-05  -2.07840000E-04
   +1.40860000E-04  +4.12000000E-06  +1.43730000E-04  -6.21800000E-05  -3.81300000E-05
   +4.79200000E-05  -4.92500000E-05  +6.00400000E-05  +6.90400000E-05  -4.82800000E-05
   +1.21100000E-05  +3.98441600E-02  +1.53714230E-01  +2.11640000E-04  -9.58770000E-04
   -4.27100000E-05  +2.70050000E-04  +1.00760000E-04  +2.53210000E-04  -5.76300000E-05
   -2.03630000E-04  -1.00629000E-03  +3.80177000E-03  +3.71057000E-03  +3.34363000E-03
   -1.32120000E-04  -1.99769000E-03  -6.25932000E-03  -1.53780000E-04  +7.28200000E-05
   +2.45880000E-03  -1.51320000E-04  +2.27000000E-06  -1.55560000E-04  +1.50110000E-04
   +3.27800000E-05  +7.30500000E-05  -4.22865900E-02  -2.39295240E-01  -3.98949850E-01
   -6.51800000E-05  +7.63900000E-05  +9.89700000E-05  -1.95100000E-05  -2.48100000E-05
   +1.76000000E-05  +4.15700000E-05  +5.67000000E-06  -1.10300000E-05  -9.18800000E-05
   -2.76000000E-06  -1.02300000E-05  +5.56600000E-05  -1.27700000E-05  +2.75200000E-05
   +3.17900000E-05  -3.63000000E-06  -2.08100000E-05  +8.46700000E-05  -1.06790000E-04
   -8.05300000E-05  -1.68470000E-04  +7.82000000E-05  +5.43300000E-05  +1.30150000E-04
   -2.97400000E-05  -6.65700000E-05  +7.91000000E-05  -9.12000000E-06  -1.44800000E-05
   +6.15200000E-05  -3.41200000E-05  -1.15200000E-05  +3.86888700E-02  +2.38690240E-01
   +4.00663220E-01  -1.55934000E-03  -1.95400000E-05  +3.40270000E-04  -4.19469000E-03
   -3.40041000E-03  +9.61630000E-04  -1.07392000E-03  -1.57430900E-02  -2.54823000E-02
   -6.89753100E-02  -3.48927100E-02  -4.04373100E-02  +7.19422000E-03  +1.11730000E-02
   +1.77964700E-02  -2.39094000E-03  -3.17470000E-04  +4.12665000E-03  +3.31570000E-04
   -5.83830000E-04  -1.16025000E-03  +1.25200000E-05  +8.69800000E-05  -9.66800000E-05
   +2.76550000E-03  +2.09825000E-03  -2.12330000E-04  +2.61150000E-04  -1.79480000E-04
   -8.53000000E-05  -2.92200000E-05  +4.01000000E-05  +2.63800000E-05  -1.27200000E-05
   +1.33200000E-05  +6.49000000E-06  +2.34700000E-05  -2.75600000E-05  +2.28400000E-05
   -2.42400000E-05  +2.42400000E-05  -2.47300000E-05  -4.60270000E-04  -7.76900000E-05
   +8.65800000E-05  -1.56740000E-04  +1.89030000E-04  +1.19950000E-04  +1.75100000E-04
   -1.76650000E-04  -5.72100000E-05  -1.20570000E-04  +5.96900000E-05  +7.88900000E-05
   -4.01200000E-05  +3.80200000E-05  -1.14500000E-05  -3.81500000E-05  +3.04800000E-05
   +8.95000000E-06  -8.06500000E-04  -7.30200000E-04  -4.88770000E-04  +6.81871800E-02
   +2.51710000E-04  -4.15240000E-04  +6.52250000E-04  -3.66146000E-03  +5.15278000E-03
   -1.80597000E-03  -7.99610000E-04  -3.50080000E-03  -1.00142000E-02  -3.50003400E-02
   -1.20614770E-01  -1.31843620E-01  -4.73342000E-03  +2.93750000E-04  -4.01025000E-03
   -3.41300000E-05  +4.25357000E-03  -2.15660000E-03  +3.83700000E-05  +1.77720000E-04
   -6.64900000E-04  -5.21700000E-05  -9.68000000E-06  +2.16000000E-05  +1.77017000E-03
   -1.60946000E-03  +2.88429000E-03  +1.78280000E-04  -1.38240000E-04  -8.94600000E-05
   +1.35300000E-05  +3.92000000E-06  -2.02000000E-05  -2.38400000E-05  -6.89000000E-06
   +1.00900000E-05  +7.65100000E-05  -1.46000000E-06  +1.32100000E-05  -4.52900000E-05
   +1.07900000E-05  -2.54800000E-05  -2.24730000E-04  -1.05960000E-04  +7.17600000E-05
   -6.09500000E-05  +9.94200000E-05  +7.94100000E-05  +1.35780000E-04  -3.84900000E-05
   -3.87700000E-05  -1.03830000E-04  +1.33600000E-05  +5.21700000E-05  -6.18700000E-05
   +4.22000000E-06  +5.60000000E-06  -4.87700000E-05  +2.40200000E-05  +7.14000000E-06
   +6.92440000E-04  +3.37740000E-04  -7.92400000E-04  +4.03963100E-02  +1.19869300E-01
   +7.05770000E-04  +7.99430000E-04  +1.02210000E-04  +3.15940000E-04  -2.19101000E-03
   +3.43471000E-03  +7.64350000E-04  -1.10194000E-03  +9.01400000E-05  -4.07282800E-02
   -1.31832610E-01  -2.40358440E-01  -9.94721000E-03  -1.34194100E-02  -1.34724100E-02
   +4.61813000E-03  -1.98256000E-03  -6.93380000E-04  +2.99560000E-04  -2.04370000E-04
   -5.22800000E-05  -4.85300000E-05  +2.30400000E-05  -5.94100000E-05  -8.43420000E-04
   +2.67798000E-03  +1.33041000E-03  +4.30000000E-05  -7.31100000E-05  +1.15800000E-05
   -2.61800000E-05  +3.12000000E-05  +1.30400000E-05  -6.68000000E-06  +9.68000000E-06
   +7.26000000E-06  +1.22900000E-05  -3.76000000E-05  +5.18600000E-05  -2.48700000E-05
   +3.12100000E-05  -4.04600000E-05  -9.60000000E-05  +2.39200000E-05  +3.01300000E-05
   -9.71400000E-05  +9.81900000E-05  +1.40300000E-05  +1.41490000E-04  -1.28780000E-04
   -3.98000000E-06  -9.67700000E-05  +5.02300000E-05  +2.79900000E-05  -2.72300000E-05
   +3.83800000E-05  -4.24300000E-05  -4.40600000E-05  +3.13000000E-05  -7.92000000E-06
   +2.01576000E-03  +5.31700000E-05  -5.32150000E-04  +4.44230300E-02  +1.45376780E-01
   +2.51592280E-01  +1.15527000E-03  -2.27638000E-03  -9.45700000E-04  +8.61582000E-03
   -9.73490000E-04  -4.34299000E-03  -1.91250370E-01  +2.84493400E-02  +1.37224850E-01
   -1.56905800E-02  +5.81210000E-03  +2.16241600E-02  -2.70871000E-03  -4.21760000E-03
   -1.22967000E-03  -3.13040000E-04  -1.89810000E-04  -8.85860000E-04  -5.85530000E-04
   +5.60920000E-04  -4.25440000E-04  -1.88340000E-04  -2.87780000E-04  -3.06500000E-05
   -1.54134000E-03  +1.12030000E-04  +1.02121000E-03  -7.50470000E-04  -4.56030000E-04
   -1.04063000E-03  +3.80900000E-05  -2.21400000E-05  +8.22100000E-05  -1.39100000E-05
   -1.12200000E-05  +1.25000000E-05  -6.98700000E-05  +4.81400000E-05  -9.87500000E-05
   +6.41300000E-05  -4.32900000E-05  +8.25900000E-05  +5.38800000E-05  +1.58030000E-04
   -7.70500000E-05  -5.01990000E-04  -3.66800000E-05  -9.91900000E-05  -4.51290000E-04
   +1.56180000E-04  -8.85000000E-06  +2.50250000E-04  -6.21100000E-05  -6.14100000E-05
   +1.05490000E-04  -4.34500000E-05  +7.79900000E-05  +1.10400000E-04  -6.44900000E-05
   +1.25700000E-05  +1.73560000E-04  +1.68100000E-04  +1.85280000E-04  +5.11180000E-04
   +1.11489000E-03  -9.01960000E-04  +2.02802380E-01  -2.57884000E-03  +2.67563000E-03
   -5.17594000E-03  +1.28216000E-02  +1.99828000E-03  -1.11689000E-02  +2.85946100E-02
   -5.41954600E-02  -4.28038200E-02  -9.26688000E-03  +5.87392000E-03  +8.59403000E-03
   -4.00413000E-03  +4.68591000E-03  -3.35235000E-03  -2.67380000E-04  -1.14216000E-03
   +2.98590000E-04  +1.37974000E-03  -1.96605000E-03  +1.27485000E-03  -2.30070000E-04
   -3.90490000E-04  -5.61510000E-04  -5.55350000E-04  -1.06300000E-05  +5.10850000E-04
   +1.72900000E-05  +4.48680000E-04  -1.99600000E-05  +8.09300000E-05  -1.94000000E-06
   -1.77230000E-04  -3.44600000E-05  -1.05720000E-04  +4.77700000E-05  +5.77900000E-05
   +4.73900000E-05  -3.97400000E-05  -2.15200000E-05  -1.85200000E-05  +1.31200000E-05
   +9.97200000E-05  -1.05240000E-04  +1.27350000E-04  -1.40000000E-05  -1.68300000E-04
   -1.01300000E-04  -7.16000000E-06  +1.97220000E-04  +6.88500000E-05  +4.71900000E-05
   -9.11900000E-05  -1.14600000E-05  -2.08800000E-05  -5.35000000E-05  +4.00200000E-05
   +5.12000000E-06  -1.66300000E-05  +1.09000000E-05  +6.40300000E-05  +4.02200000E-05
   +6.98700000E-05  +1.38382000E-03  -2.84182000E-03  +2.05230000E-03  -2.75340300E-02
   +4.64784500E-02  -1.36652000E-03  -5.48189000E-03  -2.26535000E-03  +1.94925600E-02
   -3.29893000E-03  -1.28006500E-02  +1.37098160E-01  -4.22184100E-02  -1.91648800E-01
   -4.36951000E-03  -2.22270000E-04  +6.15584000E-03  -7.90860000E-04  -3.18167000E-03
   +2.94307000E-03  -1.05922000E-03  +2.47060000E-04  -1.97950000E-04  +7.18940000E-04
   +1.78742000E-03  -6.12760000E-04  -2.93400000E-05  -1.96800000E-05  -1.51640000E-04
   -2.68600000E-05  +1.27180000E-04  +1.56460000E-04  -4.87820000E-04  -3.15060000E-04
   -6.08910000E-04  +8.75500000E-05  +1.95570000E-04  -9.96600000E-05  -4.44700000E-05
   +1.04000000E-05  +1.92800000E-05  -1.96200000E-05  +1.35520000E-04  -2.55140000E-04
   +8.27000000E-05  -8.69700000E-05  +1.84350000E-04  -2.05710000E-04  +9.40700000E-05
   -4.44000000E-06  +2.31520000E-04  -2.75900000E-05  +4.50340000E-04  -7.40400000E-04
   +4.52160000E-04  +1.93760000E-04  +4.36430000E-04  -1.28950000E-04  -2.21080000E-04
   +1.44210000E-04  -1.09850000E-04  +2.52160000E-04  +1.78820000E-04  -9.73800000E-05
   +3.33400000E-05  -2.20300000E-05  +1.69000000E-06  -1.18200000E-05  -5.06650000E-04
   +2.22778000E-03  -3.63970000E-04  -1.49653040E-01  +4.94987700E-02  +1.99196010E-01
   -6.68694900E-02  -3.20574500E-02  -4.11659400E-02  +9.89388000E-03  +1.14070200E-02
   +1.71265400E-02  -2.61285000E-03  -5.14060000E-04  +4.45455000E-03  -1.31999000E-03
   +7.53000000E-05  +2.53540000E-04  -3.84303000E-03  -3.42405000E-03  +9.50540000E-04
   -1.86511000E-03  -1.60040600E-02  -2.48159300E-02  +6.43620000E-04  +9.93590000E-04
   -8.00700000E-04  +2.05670000E-04  -1.26250000E-04  -1.20040000E-04  -1.74110000E-04
   -8.12380000E-04  -1.32137000E-03  -1.98870000E-04  +6.88000000E-05  -6.94500000E-05
   +3.28600000E-05  -8.15700000E-05  -2.33800000E-05  +1.23000000E-06  -1.41200000E-05
   -6.52900000E-05  -1.27990000E-04  +5.52500000E-05  -9.43000000E-06  +7.15800000E-05
   -4.21800000E-05  +3.51000000E-05  -7.54150000E-04  -6.86400000E-05  +7.32860000E-04
   +1.21970000E-04  -1.52350000E-04  -1.08320000E-04  -8.75300000E-05  +1.26570000E-04
   +9.92100000E-05  +1.28640000E-04  -4.98800000E-05  -8.19400000E-05  +8.02300000E-05
   -5.00700000E-05  -3.03500000E-05  +7.18500000E-05  -4.53600000E-05  -2.19100000E-05
   -3.88910000E-04  -1.26780000E-04  -1.15990000E-04  +1.37000000E-06  +1.66910000E-04
   -1.28600000E-04  +3.62980000E-04  +6.61080000E-04  +1.06343000E-03  +6.85701000E-02
   -3.17932900E-02  -1.23726420E-01  -1.31715410E-01  -1.38135000E-03  +1.58335000E-03
   -3.93141000E-03  -5.20900000E-04  +4.86418000E-03  -2.70056000E-03  +2.22900000E-04
   -5.89820000E-04  +8.07100000E-04  -3.48173000E-03  +5.70621000E-03  -2.26763000E-03
   -1.47504000E-03  -2.14253000E-03  -1.03649100E-02  +6.68260000E-04  -2.98220000E-03
   +1.13009000E-03  -6.00360000E-04  -1.11770000E-04  +4.97000000E-05  -1.84970000E-04
   -3.73360000E-04  -5.76590000E-04  +3.67930000E-04  +4.69620000E-04  -2.51650000E-04
   +1.43650000E-04  +6.32200000E-05  +3.81400000E-05  -9.78200000E-05  +4.72000000E-06
   +4.10600000E-05  +1.75470000E-04  +5.85400000E-05  -1.50520000E-04  -6.08100000E-05
   -1.90800000E-05  +5.83400000E-05  -1.18912000E-03  +4.30480000E-04  -3.61000000E-06
   +1.25450000E-04  -2.39330000E-04  +1.58600000E-05  -1.42240000E-04  +6.77300000E-05
   -1.23350000E-04  +5.35800000E-05  -3.43800000E-05  +3.01800000E-05  -7.56600000E-05
   -5.36600000E-05  +1.56450000E-04  +4.32000000E-06  -4.07000000E-06  +4.50100000E-05
   -7.16100000E-05  -1.89350000E-04  +7.40700000E-05  +1.49600000E-04  -5.29450000E-04
   +2.50330000E-04  -1.37320000E-04  -1.79000000E-05  -1.27700000E-04  +3.91759500E-02
   +1.21861600E-01  -4.10186200E-02  -1.31890130E-01  -2.51123330E-01  -5.57487000E-03
   -1.15874800E-02  -1.31831800E-02  +4.58385000E-03  -2.45361000E-03  -5.75530000E-04
   +2.92140000E-04  +8.64530000E-04  +2.34920000E-04  +9.53420000E-04  -2.36043000E-03
   +3.34764000E-03  +1.21415000E-03  -1.69085000E-03  +5.27830000E-04  -1.91591000E-03
   +7.62280000E-04  -1.33120000E-03  +5.06870000E-04  +1.80600000E-05  +4.36800000E-05
   -2.41340000E-04  -2.03720000E-04  -2.21540000E-04  -1.97470000E-04  -1.67310000E-04
   +4.72900000E-05  -1.06100000E-05  +3.10000000E-06  +2.03600000E-05  +3.16100000E-05
   +3.85000000E-06  +2.15500000E-05  -1.39800000E-05  -4.41300000E-05  +2.80900000E-05
   +1.90000000E-06  +1.88200000E-05  -1.37800000E-05  -1.27535000E-03  -6.43700000E-04
   +3.09900000E-04  -7.91200000E-05  +1.51340000E-04  +6.85800000E-05  +4.58100000E-05
   -7.43900000E-05  -2.46700000E-05  -4.08800000E-05  +2.63600000E-05  +3.08500000E-05
   +2.78000000E-06  +4.08200000E-05  -1.29900000E-05  -1.45300000E-05  +1.40400000E-05
   +4.80000000E-06  -2.35200000E-05  +1.08300000E-04  -1.05300000E-05  -1.69710000E-04
   +2.28950000E-04  -2.04170000E-04  -3.64680000E-04  -6.08870000E-04  -7.63090000E-04
   +4.51812000E-02  +1.46551640E-01  +2.62422390E-01  -1.45166000E-02  +5.90051000E-03
   +2.06365200E-02  -3.05032000E-03  -4.01193000E-03  -1.02947000E-03  -2.67210000E-04
   -2.45930000E-04  -9.07580000E-04  +8.46990000E-04  -2.14042000E-03  -9.01930000E-04
   +7.40293000E-03  -2.42994000E-03  -5.47862000E-03  -1.98239590E-01  +2.62294800E-02
   +1.42956700E-01  -2.66770000E-04  +4.27040000E-04  +9.56900000E-04  -2.39120000E-04
   -7.00000000E-06  -1.03460000E-04  +6.00380000E-04  +1.28954000E-03  -1.84840000E-04
   -3.75400000E-05  -3.09870000E-04  -2.09000000E-06  -5.16600000E-05  +2.44400000E-05
   -1.04200000E-05  +4.26000000E-06  -3.59000000E-06  +2.11000000E-06  +5.79000000E-06
   -4.34700000E-05  +8.24100000E-05  -2.54400000E-05  +3.02500000E-05  -6.28200000E-05
   +3.32100000E-05  +9.76200000E-05  +7.14600000E-05  -9.90300000E-05  +1.81670000E-04
   +6.05600000E-05  +1.58900000E-04  -7.97700000E-05  +3.82000000E-05  -1.04470000E-04
   +3.94000000E-05  +1.64500000E-05  -1.62300000E-05  +3.48200000E-05  -7.28100000E-05
   -4.40000000E-05  +2.57900000E-05  -1.91600000E-05  -1.32200000E-05  +1.94250000E-04
   +2.17000000E-05  +3.91060000E-04  -5.64600000E-05  -4.08340000E-04  -7.30200000E-05
   +2.09080000E-04  -1.02200000E-05  +4.61480000E-04  +1.17056000E-03  -8.80010000E-04
   +2.07096590E-01  -8.61245000E-03  +4.99664000E-03  +9.30430000E-03  -3.77016000E-03
   +4.35737000E-03  -2.89361000E-03  -4.28880000E-04  -1.11445000E-03  +1.27710000E-04
   -2.41285000E-03  +2.19681000E-03  -4.70251000E-03  +1.30296100E-02  +2.99765000E-03
   -1.19932200E-02  +2.54446600E-02  -5.00989400E-02  -4.05920000E-02  -4.91820000E-04
   +3.97760000E-04  +1.58620000E-04  +1.16700000E-05  +7.77000000E-05  -1.77700000E-05
   +1.13637000E-03  -1.78493000E-03  +2.41781000E-03  -1.08990000E-04  -1.71520000E-04
   -7.38000000E-05  +2.01900000E-05  -1.40000000E-06  -1.69600000E-05  -2.14000000E-06
   -3.32000000E-06  -5.55000000E-06  +2.37800000E-05  -2.19000000E-06  +5.24000000E-06
   -1.70600000E-05  +1.61000000E-06  -9.59000000E-06  +1.09090000E-04  -4.35300000E-05
   +7.37400000E-05  -7.21400000E-05  +1.04210000E-04  +1.13890000E-04  +1.45960000E-04
   -4.46600000E-05  +1.13300000E-05  -7.74200000E-05  +1.23400000E-05  +2.83200000E-05
   -3.62600000E-05  +2.77000000E-06  -5.75000000E-06  -3.04000000E-05  +1.52000000E-05
   -8.00000000E-08  +1.40090000E-04  -2.60270000E-04  +4.35900000E-04  +6.57170000E-04
   -2.12440000E-04  -5.15550000E-04  +1.85880000E-04  -4.63220000E-04  +3.11240000E-04
   +1.43182000E-03  -2.91069000E-03  +2.06411000E-03  -2.63040500E-02  +4.19465200E-02
   -4.93992000E-03  +7.71650000E-04  +6.89828000E-03  -8.37370000E-04  -2.75170000E-03
   +2.86464000E-03  -1.30060000E-03  -7.10200000E-05  -4.17670000E-04  -1.35329000E-03
   -4.88534000E-03  -2.17611000E-03  +2.18627000E-02  -2.75765000E-03  -1.24882400E-02
   +1.41601010E-01  -4.11645700E-02  -1.92841320E-01  -1.66740000E-04  -6.53600000E-05
   +3.23760000E-04  -4.55900000E-05  -5.07300000E-05  -2.20100000E-05  -4.12930000E-04
   +2.33656000E-03  +8.41630000E-04  +2.52300000E-05  +3.04000000E-06  +2.54100000E-05
   -1.39700000E-05  -6.36000000E-06  +7.30000000E-07  +8.76000000E-06  +3.11000000E-06
   -5.44000000E-06  -3.12600000E-05  +2.63000000E-06  -2.13000000E-06  +1.95400000E-05
   -6.10000000E-06  +8.22000000E-06  +2.42400000E-05  +5.93700000E-05  -2.68800000E-05
   +2.96800000E-05  -2.06700000E-05  -1.92700000E-05  -6.43100000E-05  +2.23200000E-05
   +9.37000000E-06  +4.49700000E-05  -7.50000000E-06  -1.61200000E-05  +2.89600000E-05
   -2.97000000E-06  -2.41000000E-06  +2.49000000E-05  -1.27900000E-05  -1.78000000E-06
   -7.52100000E-05  +4.01370000E-04  +2.03710000E-04  +8.65020000E-04  -1.04000000E-04
   -8.15300000E-04  -3.21000000E-05  +2.99010000E-04  -1.60360000E-04  -4.22160000E-04
   +2.22287000E-03  -3.31610000E-04  -1.54791030E-01  +4.58311000E-02  +1.98159820E-01
   +1.72570000E-04  +1.51830000E-04  +1.32980000E-04  +8.02730000E-04  -1.16759000E-03
   -2.47750000E-04  +2.54020000E-04  +4.94100000E-05  +5.65800000E-05  -1.34730000E-04
   +6.45400000E-05  -3.15700000E-05  -6.69300000E-05  -4.57200000E-05  -1.01910000E-04
   +4.34700000E-05  +5.31300000E-05  -2.34000000E-05  +1.83610000E-03  -4.09526000E-03
   -7.06500000E-05  -1.79038130E-01  +1.34518670E-01  +2.51726000E-02  +1.00840000E-04
   +2.65700000E-05  +3.25400000E-05  +1.19200000E-05  -8.37160000E-04  +1.06721000E-03
   +3.21690000E-04  -3.31090000E-04  +1.36540000E-04  +1.62900000E-05  -1.02000000E-06
   +2.45300000E-05  +5.80000000E-06  -6.74300000E-05  +1.92570000E-04  -4.48000000E-05
   +4.03300000E-05  -1.15010000E-04  -1.32220000E-04  -1.18580000E-04  +1.29970000E-04
   -1.10170000E-04  +8.32000000E-06  +3.71370000E-04  +3.56960000E-04  +1.38190000E-04
   -1.45450000E-04  -1.55290000E-04  +5.75100000E-05  +1.33900000E-05  -2.44400000E-05
   +5.10200000E-05  -1.33740000E-04  -1.05990000E-04  +5.71800000E-05  -4.42100000E-05
   -1.24900000E-05  -5.31000000E-06  -7.40000000E-06  +3.31000000E-06  +7.31000000E-06
   +4.53000000E-06  +3.82500000E-05  -5.08200000E-05  +4.60600000E-05  +3.48500000E-05
   +9.80000000E-07  +1.36100000E-05  +2.11800000E-05  +4.89000000E-06  +4.99000000E-06
   +1.90619920E-01  -3.35900000E-04  +1.54530000E-04  +1.10800000E-05  +1.22608000E-03
   +7.68220000E-04  -2.20090000E-04  -3.14580000E-04  -1.97510000E-04  -6.27830000E-04
   +1.69030000E-04  -5.86000000E-06  -3.83700000E-05  -2.60400000E-04  -8.32200000E-05
   +1.19240000E-04  -1.63450000E-04  -2.40900000E-05  +1.01490000E-04  +1.55354600E-02
   -1.82975300E-02  -2.84020000E-03  +1.32540510E-01  -1.80849960E-01  -2.62609600E-02
   +2.45100000E-04  +1.39040000E-04  +3.40700000E-05  -1.58990000E-03  -2.17575000E-03
   +3.56820000E-03  +1.28292000E-03  -6.68230000E-04  -4.08580000E-04  -2.42940000E-04
   -2.14920000E-04  +2.66600000E-04  -1.74240000E-04  +5.41900000E-05  -1.56670000E-04
   +1.37020000E-04  -6.42900000E-05  +1.31620000E-04  -3.69700000E-05  +5.07590000E-04
   -1.48040000E-03  -9.01700000E-05  -4.47500000E-05  +2.79670000E-04  -5.04290000E-04
   +4.02670000E-04  +6.59400000E-05  +4.09200000E-04  -1.15280000E-04  -1.40150000E-04
   +1.83710000E-04  -4.28500000E-05  +1.12360000E-04  +1.61940000E-04  -8.58800000E-05
   +2.08800000E-05  -1.57100000E-05  -3.32700000E-05  -1.75400000E-05  +1.00400000E-05
   -1.05500000E-05  +1.15800000E-05  +4.56700000E-05  +9.95700000E-05  +1.53650000E-04
   +8.21000000E-06  -2.86900000E-05  +6.09100000E-05  -2.71000000E-06  -1.28200000E-05
   -3.86000000E-06  -1.45033820E-01  +1.97104310E-01  -1.45540000E-04  -1.24880000E-04
   +1.47530000E-04  -7.29340000E-04  -2.54500000E-04  +5.10110000E-04  +3.62800000E-04
   -8.79500000E-05  -1.97830000E-04  -3.82560000E-04  +8.19600000E-05  +1.04660000E-04
   +1.40450000E-04  -3.02800000E-05  -1.90710000E-04  +1.39740000E-04  +6.51400000E-05
   -3.18000000E-06  -1.60992100E-02  +1.71718100E-02  +1.06376000E-03  +2.62886600E-02
   -2.78478200E-02  -5.12023200E-02  -1.72310000E-04  -6.99000000E-05  -9.71000000E-06
   +1.57145000E-03  +2.80366000E-03  -3.79765000E-03  -9.92580000E-04  +9.99210000E-04
   +5.85940000E-04  +7.92900000E-05  +1.79600000E-04  -2.13530000E-04  +2.23970000E-04
   +8.34200000E-05  -5.97500000E-05  -9.82600000E-05  -3.88000000E-06  +5.42000000E-06
   -1.03055000E-03  +1.02265000E-03  +1.09627000E-03  +6.83220000E-04  +1.69160000E-04
   -1.69230000E-04  -4.51300000E-05  -2.09070000E-04  +1.83960000E-04  -4.11200000E-05
   +1.89600000E-05  +1.05190000E-04  -9.97700000E-05  -5.15700000E-05  +1.08660000E-04
   +1.16000000E-06  +2.43000000E-06  +4.62000000E-05  +1.63000000E-05  +2.42000000E-06
   +1.73900000E-05  +8.77000000E-06  -2.14600000E-05  -1.80000000E-06  +4.39800000E-05
   -3.65000000E-06  +1.09100000E-04  +3.31100000E-05  +8.29000000E-06  -7.24200000E-05
   -1.59000000E-06  +4.85000000E-06  +9.81000000E-06  -2.91134000E-02  +2.55216400E-02
   +5.63004200E-02  +5.16540000E-04  -3.43340000E-04  -2.97730000E-04  +3.05840000E-04
   -1.22099000E-03  +1.10460000E-03  +2.54550000E-04  +1.77770000E-04  +5.24860000E-04
   -1.71170000E-04  +4.79600000E-05  +8.30200000E-05  +3.81310000E-04  +1.65150000E-04
   +7.36600000E-05  -1.77260000E-04  -5.18400000E-05  -1.53170000E-04  -3.33721000E-03
   -5.52860000E-04  -5.09120000E-04  -2.64819790E-01  -1.02269590E-01  -1.73156600E-02
   -4.42720000E-04  -1.92350000E-04  -7.11900000E-05  -1.61640000E-04  +3.19320000E-04
   +2.44360000E-04  +6.11600000E-05  -2.08530000E-04  -5.60700000E-05  +2.41600000E-05
   +1.60600000E-05  +2.17900000E-05  -4.34200000E-05  -3.30500000E-05  +2.63900000E-05
   +2.63700000E-05  +5.68000000E-06  +3.52000000E-06  +3.29920000E-04  +4.09910000E-04
   -5.42560000E-04  -5.73900000E-05  +7.18960000E-04  +4.32040000E-04  -2.60000000E-07
   +2.96020000E-04  -2.04950000E-04  +1.01930000E-04  -3.30300000E-05  -4.14400000E-05
   +5.92200000E-05  +1.29100000E-05  +1.60000000E-07  +1.49000000E-05  -3.12000000E-06
   -6.01000000E-06  +3.91000000E-05  +3.61900000E-05  +3.50200000E-05  -3.52400000E-05
   -1.02100000E-05  -2.54400000E-05  -1.56600000E-05  +3.25700000E-05  -4.14700000E-05
   -3.05300000E-05  +3.42000000E-05  +5.34400000E-05  -3.94500000E-05  +7.92000000E-06
   -8.88000000E-06  -1.83570500E-02  -1.02022500E-02  -2.20063000E-03  +2.87398760E-01
   +7.81700000E-05  -5.13430000E-04  -3.50320000E-04  -2.16210000E-04  -2.17983000E-03
   +3.68495000E-03  -3.89990000E-04  -6.88300000E-05  +1.49040000E-04  +2.05380000E-04
   +9.85700000E-05  +3.27100000E-05  +2.34840000E-04  +2.83330000E-04  +4.73230000E-04
   -6.27780000E-04  -5.48100000E-05  -3.47440000E-04  -2.04136700E-02  -9.74234000E-03
   -2.55599000E-03  -1.00760300E-01  -9.51640100E-02  -7.85155000E-03  -4.83740000E-04
   -2.10680000E-04  -1.26100000E-04  -1.11002000E-03  +6.35200000E-04  -5.65500000E-05
   +6.94200000E-05  -2.16900000E-05  +1.70360000E-04  +5.24400000E-05  +4.00200000E-05
   -3.80800000E-05  -3.99900000E-05  -1.48430000E-04  +2.81330000E-04  -4.36300000E-05
   +7.61000000E-05  -1.55670000E-04  -1.06060000E-04  +4.83170000E-04  -1.32150000E-03
   +2.04980000E-04  -7.03570000E-04  +1.32710000E-04  +3.81540000E-04  +1.42160000E-04
   -2.41390000E-04  -1.87010000E-04  +9.40100000E-05  -8.90000000E-07  -8.06000000E-06
   +1.38770000E-04  -1.94230000E-04  -1.38360000E-04  +8.39600000E-05  -5.18000000E-05
   +2.94300000E-05  +2.05700000E-05  +4.45300000E-05  -2.62200000E-05  -3.54000000E-05
   -2.37500000E-05  +2.73100000E-05  +1.67130000E-04  -5.56000000E-05  +3.47800000E-05
   -9.37400000E-05  +1.26340000E-04  -8.94700000E-05  +2.74500000E-05  -3.75400000E-05
   +2.08084000E-02  +1.11115700E-02  +2.14521000E-03  +1.11181560E-01  +1.02432540E-01
   +6.72320000E-04  +3.82610000E-04  +1.76350000E-04  -5.48000000E-04  +2.71048000E-03
   -2.84849000E-03  -1.27170000E-04  -3.86520000E-04  -1.04870000E-04  +6.30640000E-04
   -1.76380000E-04  +4.68900000E-05  -3.73150000E-04  +3.65600000E-05  +2.34420000E-04
   +2.02300000E-05  -3.06540000E-04  +1.46850000E-04  +2.13178100E-02  +9.24992000E-03
   +3.64060000E-04  -1.79431300E-02  -8.98529000E-03  -5.01778300E-02  +4.09760000E-04
   +2.17170000E-04  +4.39100000E-05  +7.84500000E-05  -6.14310000E-04  +4.83300000E-04
   +9.71000000E-06  -1.53420000E-04  -2.17990000E-04  -2.90000000E-06  -8.34000000E-06
   -2.12600000E-05  +1.08700000E-05  +2.52300000E-05  -3.55000000E-06  -7.06000000E-06
   -1.24100000E-05  -1.47600000E-05  +1.20396000E-03  +4.27410000E-04  +1.12519000E-03
   -2.76790000E-04  -3.02680000E-04  +4.77880000E-04  -9.25300000E-05  +1.77490000E-04
   +3.63500000E-05  +5.88100000E-05  +2.43000000E-05  -1.27200000E-04  +3.14200000E-05
   -6.49500000E-05  -4.19500000E-05  +2.62000000E-06  -6.49000000E-06  -5.28400000E-05
   -4.95000000E-06  -1.50300000E-05  -4.40000000E-05  +3.63100000E-05  +8.00000000E-06
   +1.74400000E-05  -1.64720000E-04  +4.73530000E-04  +3.93700000E-05  -6.30000000E-07
   +1.31710000E-04  -9.87400000E-05  +5.76000000E-05  +2.13800000E-05  -6.40000000E-06
   +4.36393000E-03  +2.33870000E-03  -5.61290000E-04  +1.80822900E-02  +6.87622000E-03
   +5.19635200E-02  -2.48700000E-04  -2.69300000E-05  +4.42600000E-05  +3.51270000E-04
   +7.39550000E-04  +6.59970000E-04  -3.39690000E-04  -3.37910000E-04  +1.89620000E-04
   -2.63450000E-04  -1.27200000E-05  -7.69600000E-05  -5.30000000E-05  -1.03020000E-04
   -1.51620000E-04  +1.77680000E-04  +5.23200000E-05  +9.76900000E-05  -1.69162000E-03
   +1.77653000E-03  +3.62787000E-03  -5.09099600E-02  -1.31093900E-02  -2.95876500E-02
   +1.05140000E-04  +4.65000000E-05  +8.72000000E-06  +3.64400000E-04  -2.11580000E-04
   -6.47490000E-04  +3.42400000E-05  +8.37000000E-05  +2.57000000E-06  -4.79300000E-05
   -4.46900000E-05  +2.83200000E-05  -3.52700000E-05  +5.57400000E-05  -1.14920000E-04
   +4.45000000E-05  -3.73900000E-05  +8.67000000E-05  -1.35230000E-04  -3.25110000E-04
   +4.83290000E-04  -1.01200000E-04  +5.56830000E-04  -5.11020000E-04  -1.80390000E-04
   -1.14750000E-04  +1.15400000E-04  +1.49240000E-04  -6.93900000E-05  +7.24800000E-05
   +3.78200000E-05  -1.11000000E-06  +1.33440000E-04  +1.00630000E-04  -4.58500000E-05
   +7.03400000E-05  -2.10600000E-05  -2.16900000E-05  +2.00000000E-08  +1.49300000E-05
   -2.38300000E-05  +2.01800000E-05  -9.65000000E-06  -7.07320000E-04  +1.08960000E-04
   +4.07900000E-05  +6.42000000E-06  -5.41500000E-05  +3.18000000E-06  +4.17000000E-06
   -4.90000000E-06  +2.93521000E-03  +8.05274000E-03  +2.14950100E-02  -2.03719000E-03
   -1.03825700E-02  -2.70319100E-02  +5.26305500E-02  -2.54030000E-04  +7.58700000E-05
   -2.98000000E-05  +8.27490000E-04  +8.22640000E-04  -1.40960000E-04  -5.41810000E-04
   -2.85320000E-04  +7.03050000E-04  -4.53600000E-05  -1.52900000E-04  -1.53880000E-04
   -3.33000000E-06  -5.28500000E-05  -2.08190000E-04  +1.84040000E-04  +9.30200000E-05
   +1.41390000E-04  +2.58773000E-03  +9.27005000E-03  +2.10971500E-02  -1.34883000E-02
   -8.72194400E-02  -9.57715600E-02  +1.53860000E-04  +4.63600000E-05  +2.45100000E-05
   +1.16000000E-04  +1.01875000E-03  -2.08470000E-04  -3.29440000E-04  +5.19300000E-05
   -1.13670000E-04  +1.54100000E-05  +7.14700000E-05  -3.17300000E-05  -4.67000000E-06
   -3.49000000E-05  +7.03900000E-05  -2.04100000E-05  +2.17400000E-05  -5.09100000E-05
   -5.63500000E-04  -3.16347000E-03  +2.84445000E-03  +9.51200000E-04  -1.94050000E-04
   -6.23900000E-05  +1.33520000E-04  -1.52640000E-04  -1.65600000E-05  -1.22240000E-04
   +3.69600000E-05  +1.05430000E-04  -3.83600000E-05  +4.19400000E-05  -6.56800000E-05
   -4.19900000E-05  +2.61600000E-05  +4.13000000E-06  -1.93400000E-05  -2.45000000E-06
   -1.68700000E-05  -5.77000000E-06  -1.32000000E-06  +2.15900000E-05  -5.24300000E-04
   -1.11555000E-03  +3.32100000E-05  +4.41200000E-05  -2.57400000E-05  +1.18000000E-06
   +1.08200000E-05  -1.24700000E-05  +6.61000000E-06  -4.10576000E-03  -8.47380000E-03
   -2.04922900E-02  +1.71030000E-04  -5.60827000E-03  -1.14835600E-02  +1.37120800E-02
   +9.48018800E-02  +7.59030000E-04  -5.64100000E-05  -2.49110000E-04  -1.48562000E-03
   -4.82690000E-04  +5.45310000E-04  -1.15920000E-04  -7.69480000E-04  -1.30490000E-04
   +6.00160000E-04  +1.19520000E-04  +2.57690000E-04  -1.52770000E-04  +2.83320000E-04
   +4.67320000E-04  -4.75080000E-04  -2.35130000E-04  -1.42870000E-04  -2.59657000E-03
   -9.73535000E-03  -1.96719500E-02  -2.85854900E-02  -9.34762600E-02  -2.73381610E-01
   -5.71900000E-05  +3.10000000E-06  -1.59200000E-05  +1.04596000E-03  -1.08829000E-03
   -6.22600000E-05  +2.89500000E-05  +2.17300000E-04  +1.65490000E-04  -7.25000000E-06
   -1.24400000E-05  +6.52700000E-05  +9.34400000E-05  +3.46900000E-05  -1.50750000E-04
   -1.34000000E-05  -8.22000000E-06  +8.43600000E-05  +1.15914000E-03  +4.81444000E-03
   -2.91084000E-03  +3.73050000E-04  +2.75620000E-04  +4.40290000E-04  -2.86560000E-04
   -2.33260000E-04  +2.51880000E-04  +5.46800000E-05  +3.33400000E-05  +9.65600000E-05
   -1.69500000E-05  -3.22000000E-06  +1.85040000E-04  +3.59800000E-05  -9.58000000E-06
   +7.31800000E-05  +2.67100000E-05  +8.28000000E-06  -1.25000000E-06  +3.67200000E-05
   -1.20400000E-05  -7.10000000E-07  -1.56890000E-04  +4.16840000E-04  +3.91440000E-04
   -1.45090000E-04  +2.08200000E-05  +9.21200000E-05  +6.00000000E-08  +2.05400000E-05
   -1.71500000E-05  -6.90200000E-04  -1.03158000E-03  -3.11144000E-03  +3.56290000E-04
   +5.37000000E-05  -4.55700000E-04  +3.11312600E-02  +1.01932720E-01  +2.97797030E-01
   -3.94360000E-04  -1.91500000E-04  -7.84450000E-04  +4.00120000E-04  +5.78700000E-04
   -1.05780000E-04  -4.35700000E-05  -4.11900000E-05  -3.16200000E-05  +1.65310000E-04
   +7.09500000E-05  +3.54800000E-05  -1.07720000E-04  -2.32900000E-05  +6.73500000E-05
   -9.58200000E-05  -1.93000000E-06  +2.03010000E-04  -9.08250000E-04  +4.19071000E-03
   -4.11705000E-03  -2.59640000E-04  -4.36940000E-04  -1.07329000E-03  +1.40760000E-04
   +8.20200000E-05  +4.81000000E-05  -8.40700000E-05  -4.82270000E-04  +8.57050000E-04
   +3.59860000E-04  +2.07360000E-04  +1.53990000E-04  -2.08020000E-04  +1.37600000E-05
   -2.75830000E-04  -4.30070000E-04  -3.55600000E-05  +2.83360000E-04  +1.17130000E-04
   -1.89200000E-05  -1.14750000E-04  -5.45100700E-02  -2.90748100E-02  +3.48966700E-02
   +8.21000000E-06  +1.14620000E-04  -3.21000000E-05  +2.94000000E-05  -4.48100000E-05
   +2.15330000E-04  +8.17300000E-05  +3.16500000E-05  -1.12590000E-04  +2.07580000E-04
   +6.15800000E-05  -3.06220000E-04  +7.41800000E-05  -3.64100000E-05  -9.04300000E-05
   -1.45800000E-05  -9.77000000E-06  -7.77000000E-06  +1.83200000E-05  +8.89000000E-06
   +1.51600000E-05  +1.10000000E-07  +4.35000000E-05  +4.81200000E-05  -1.36447000E-03
   +4.59040000E-04  -4.20580000E-04  -1.41300000E-05  +1.73300000E-05  -2.57800000E-05
   +1.46900000E-04  -3.44730000E-04  +1.65190000E-04  +2.76040000E-04  +2.65360000E-04
   -2.10810000E-04  +6.75570000E-04  +1.63840000E-04  -3.05270000E-04  +5.66080800E-02
   -6.67280000E-04  +4.77270000E-04  +4.48510000E-04  -7.40000000E-07  +5.14890000E-04
   +4.70420000E-04  +2.23980000E-04  -7.84400000E-05  -2.89300000E-05  +7.06300000E-05
   -2.46000000E-06  -4.57700000E-05  -8.46900000E-05  -2.00600000E-05  +1.44530000E-04
   +1.66200000E-05  -1.48610000E-04  -3.01790000E-04  +3.31158000E-03  +1.00281600E-02
   -1.12103700E-02  -2.59920000E-04  -1.04569000E-03  -2.08450000E-03  +2.27700000E-05
   -2.04400000E-05  -4.75700000E-05  +1.63070000E-04  +8.43720000E-04  +1.00840000E-04
   +8.39100000E-04  -1.13203000E-03  -7.25030000E-04  +8.63600000E-05  -5.76800000E-04
   -1.79800000E-04  +1.98300000E-05  +3.54600000E-05  +1.28100000E-04  -9.31700000E-05
   +1.08700000E-05  -9.24900000E-05  -2.91859900E-02  -1.56948960E-01  +1.30682980E-01
   -1.42300000E-04  +7.03300000E-05  +1.34310000E-04  +1.08280000E-04  -1.97440000E-04
   -6.36600000E-05  -1.17570000E-04  +7.04500000E-05  +6.11300000E-05  -7.71300000E-05
   +3.71900000E-05  -5.93200000E-05  -6.62900000E-05  +3.83600000E-05  -6.81000000E-06
   -8.29000000E-06  -4.37000000E-06  -4.23000000E-06  +1.12400000E-05  +9.90000000E-06
   -7.73000000E-06  -5.90000000E-06  +9.82000000E-06  -4.59600000E-05  +7.65800000E-05
   -1.61970000E-04  -2.67020000E-04  -2.18000000E-06  +4.35500000E-05  -7.57000000E-06
   -2.75490000E-04  +1.71410000E-04  -2.21640000E-04  +1.76320000E-04  -6.18200000E-05
   -1.50970000E-04  -4.14100000E-05  +7.54640000E-04  -6.68660000E-04  +3.22614900E-02
   +1.68681090E-01  +2.44080000E-04  -3.27310000E-04  -1.03620000E-04  +1.05604000E-03
   +7.56900000E-04  +1.09305000E-03  -8.35800000E-05  -4.25910000E-04  -9.44600000E-05
   +2.34730000E-04  +1.08550000E-04  +4.21900000E-05  -6.09300000E-05  +1.44550000E-04
   +1.62970000E-04  -3.05440000E-04  -8.48400000E-05  +2.20870000E-04  +5.09372000E-03
   +1.85706400E-02  -1.99717200E-02  -1.03291000E-03  -4.11119000E-03  -4.90730000E-03
   +9.50000000E-06  +9.80000000E-06  +2.47400000E-05  -6.32150000E-04  +1.20581000E-03
   +8.12900000E-05  +1.50060000E-04  +2.59620000E-04  -2.46970000E-04  -2.22060000E-04
   +4.79100000E-05  +7.12700000E-04  +9.79310000E-04  +1.27220000E-04  -3.79640000E-04
   -3.55650000E-04  -1.00000000E-05  +7.25000000E-06  +3.46567100E-02  +1.28242230E-01
   -2.02910060E-01  +3.71750000E-04  -2.08780000E-04  -5.30500000E-05  -3.00500000E-04
   +2.48170000E-04  -2.46040000E-04  +4.73700000E-05  -1.23310000E-04  +1.20800000E-04
   -3.53510000E-04  -1.36510000E-04  +4.91290000E-04  -5.29400000E-05  +2.20200000E-05
   +1.53000000E-04  -4.86000000E-06  +8.37000000E-06  -6.76000000E-06  -1.45200000E-05
   +3.22400000E-05  -2.26700000E-05  +3.07000000E-06  +1.08990000E-04  +5.86500000E-05
   -5.11150000E-04  +3.15510000E-04  +2.83860000E-04  -2.38400000E-05  -1.94300000E-05
   -9.97000000E-06  -8.26300000E-05  -9.56700000E-05  +2.25130000E-04  +6.53300000E-05
   -1.59330000E-04  +2.81490000E-04  +1.79850000E-04  +1.31504000E-03  -1.43129000E-03
   -3.73760600E-02  -1.40304830E-01  +2.21106600E-01  -9.86800000E-05  +1.23420000E-04
   +4.06480000E-04  +7.81810000E-04  -2.54120000E-04  -4.05240000E-04  -6.20200000E-05
   +6.25000000E-05  +2.90150000E-04  -1.12060000E-04  -6.11800000E-05  -1.31080000E-04
   +1.48720000E-04  +4.36100000E-05  -1.86500000E-05  +1.31760000E-04  -1.06010000E-04
   -2.29240000E-04  -4.08651000E-03  -1.08814000E-03  +4.97590000E-04  +1.02440000E-04
   +1.95570000E-04  +5.45740000E-04  -2.05840000E-04  -1.06850000E-04  -6.50800000E-05
   +3.31290000E-04  +8.37630000E-04  +2.68200000E-05  +1.15060000E-04  -3.58760000E-04
   +1.56380000E-04  -1.36000000E-06  -6.79900000E-05  -5.98400000E-05  -7.51800000E-05
   -5.12300000E-05  -3.09000000E-05  +5.81100000E-05  +7.78000000E-06  +5.38100000E-05
   -2.93049250E-01  -7.79399200E-02  -1.22436000E-02  +3.45690000E-04  -2.53150000E-04
   -5.66400000E-05  -9.06300000E-05  -5.51600000E-05  -1.30820000E-04  +7.34300000E-05
   -9.40000000E-07  -3.82000000E-06  +2.20600000E-05  -9.94000000E-06  +1.33000000E-05
   +1.89800000E-05  -3.17000000E-06  +1.50100000E-05  +2.24700000E-05  +1.66300000E-05
   +1.32200000E-05  -4.00200000E-05  -8.32000000E-06  -1.78500000E-05  +5.97700000E-05
   -5.21000000E-05  -6.99800000E-05  +2.23040000E-04  -8.69600000E-05  -4.70320000E-04
   -8.48000000E-06  +2.00000000E-08  +1.21100000E-05  +1.03000000E-06  -1.18210000E-04
   +2.59900000E-05  +3.59100000E-04  +3.40400000E-04  -4.34790000E-04  +3.60460000E-04
   +1.21850000E-04  +1.50600000E-05  -4.00599000E-03  -3.34560000E-04  -3.77670000E-04
   +3.14983040E-01  +3.50850000E-04  +1.30320000E-04  -4.43270000E-04  +5.04450000E-04
   -7.79170000E-04  -3.00618000E-03  -9.77180000E-04  +1.07360000E-04  +1.01290000E-04
   -8.78700000E-05  -2.05710000E-04  -1.47310000E-04  +2.16240000E-04  +1.80000000E-06
   -5.80400000E-05  -6.40600000E-05  +1.50470000E-04  +6.57900000E-05  -1.38599500E-02
   -6.65333000E-03  -1.03946000E-03  +5.92430000E-04  +8.26200000E-05  +9.07920000E-04
   -1.86170000E-04  -6.86400000E-05  +2.10000000E-06  -1.47553000E-03  -1.07970000E-04
   -2.18980000E-04  -3.26070000E-04  +1.08720000E-04  +1.00840000E-04  +2.24080000E-04
   -2.23100000E-05  +1.49730000E-04  -8.18600000E-05  -3.29390000E-04  +2.89500000E-04
   -1.03400000E-05  +1.00040000E-04  -1.23880000E-04  -7.67722400E-02  -7.16613100E-02
   -3.13351000E-03  +1.03840000E-04  +3.24300000E-04  +1.37760000E-04  +2.81610000E-04
   -2.78310000E-04  -2.66250000E-04  -2.35570000E-04  +7.33900000E-05  +1.75690000E-04
   -5.25800000E-05  +3.62480000E-04  -2.76700000E-05  -1.53080000E-04  +8.91000000E-05
   +6.28800000E-05  +2.77100000E-05  +1.34900000E-05  +1.48600000E-05  -7.09400000E-05
   -8.82600000E-05  +1.01100000E-05  +3.28000000E-06  +4.57100000E-05  -4.73400000E-05
   +1.15500000E-04  -2.28460000E-04  +3.19080000E-04  -3.40600000E-05  +1.71300000E-05
   -1.38300000E-05  +1.28050000E-04  +5.46900000E-05  -1.74400000E-05  +7.98300000E-05
   +4.45080000E-04  +1.61940000E-04  +1.02850000E-04  -1.27540000E-04  +8.79000000E-06
   -1.95359300E-02  -6.09664000E-03  -1.89666000E-03  +8.56155800E-02  +7.52995700E-02
   +9.31650000E-04  -2.99060000E-04  -6.43950000E-04  +9.56330000E-04  -2.15005000E-03
   -5.29256000E-03  -1.80369000E-03  -5.74190000E-04  +2.89780000E-04  +3.91200000E-05
   -2.16400000E-04  -3.43570000E-04  +1.88390000E-04  +9.07800000E-05  -4.52000000E-06
   -2.03930000E-04  +2.55900000E-05  +2.69290000E-04  -2.79989500E-02  -9.21273000E-03
   -3.02066000E-03  -1.25789000E-03  -6.51150000E-04  +1.30242000E-03  -1.69590000E-04
   -3.66900000E-05  +2.71200000E-05  -1.18376000E-03  +1.05570000E-04  +8.03280000E-04
   +2.86340000E-04  -1.16160000E-04  -8.05500000E-05  -8.85800000E-05  -2.06800000E-05
   -3.38400000E-05  -4.78800000E-05  -1.09740000E-04  +3.26560000E-04  -6.44900000E-05
   +4.08900000E-05  -2.11470000E-04  -1.02555300E-02  -2.48485000E-03  -4.73513800E-02
   -2.05100000E-05  +4.14140000E-04  +1.67860000E-04  +3.42740000E-04  -3.37710000E-04
   -4.77100000E-05  -1.85380000E-04  +1.12720000E-04  +5.34500000E-05  -2.33300000E-05
   +8.77700000E-05  -2.99080000E-04  -7.90100000E-05  +4.52500000E-05  -6.61800000E-05
   +2.97900000E-05  +1.69300000E-05  +1.06800000E-05  -1.50590000E-04  -4.99500000E-05
   -3.48400000E-05  +2.15900000E-05  +2.48200000E-05  -1.19000000E-06  -4.29900000E-05
   +4.17850000E-04  +3.93470000E-04  -3.40900000E-05  -2.35500000E-05  -3.80000000E-07
   +7.01800000E-05  +2.27400000E-05  -7.80200000E-05  +4.14960000E-04  +4.12060000E-04
   -6.64180000E-04  +3.55010000E-04  +2.85700000E-05  +2.71940000E-04  +2.39025300E-02
   +6.20292000E-03  +1.87505000E-03  +1.32408700E-02  +6.80301000E-03  +5.31675100E-02
   -7.23760000E-04  -7.51320000E-04  +1.80110000E-04  +2.66050000E-04  -6.24400000E-05
   +4.25370000E-04  +3.86900000E-05  +3.18100000E-05  -6.53300000E-05  +1.27160000E-04
   +5.13300000E-05  -6.21000000E-06  -1.86770000E-04  +4.13000000E-05  +4.38100000E-05
   -1.22500000E-05  -2.11200000E-05  -1.19700000E-04  +3.02689000E-03  -5.20384000E-03
   -9.53060000E-04  +1.84390000E-04  -2.04280000E-04  -7.19500000E-05  +1.42450000E-04
   +4.77200000E-05  +1.22900000E-05  -1.71090000E-04  -1.50360000E-04  -7.61400000E-04
   +2.98100000E-05  -1.70480000E-04  +2.10690000E-04  +2.87800000E-05  -7.44800000E-05
   -2.23700000E-05  -1.10800000E-05  -1.90510000E-04  +1.62160000E-04  -3.35000000E-05
   +6.23400000E-05  -8.61200000E-05  -1.42206220E-01  +1.28471330E-01  +1.60293500E-02
   +5.05830000E-04  +8.75900000E-05  +6.49700000E-05  +3.08570000E-04  -1.10230000E-04
   -1.00100000E-04  -1.49900000E-04  +2.40600000E-05  +5.56200000E-05  -4.93700000E-05
   +1.72780000E-04  -3.09900000E-05  -1.00300000E-04  +5.70100000E-05  +2.47800000E-05
   -1.84600000E-05  -1.09300000E-05  -9.86000000E-06  +2.09000000E-05  +1.58900000E-05
   +6.52000000E-06  +1.56000000E-06  +1.09700000E-05  +3.71100000E-05  -1.24826000E-03
   -1.42258000E-03  -1.43580000E-04  +2.49800000E-05  -3.45500000E-05  +2.09600000E-05
   +2.76740000E-04  -6.06200000E-05  +2.13690000E-04  -1.95450000E-04  +1.63120000E-04
   +4.96300000E-05  +5.26700000E-05  -2.79230000E-04  +2.10600000E-05  +3.23978000E-03
   -6.01370000E-03  -1.09919000E-03  -1.63383600E-02  +2.52414400E-02  +2.71840000E-03
   +1.53020750E-01  +2.12980000E-04  -2.10220000E-04  -1.08196000E-03  +6.41610000E-04
   +2.96070000E-04  +4.50540000E-04  -3.03310000E-04  -1.47100000E-05  -1.26910000E-04
   +1.49420000E-04  +1.00500000E-04  +7.25300000E-05  -1.15900000E-05  -3.99600000E-05
   +5.02300000E-05  -2.60830000E-04  +2.38970000E-04  +4.46620000E-04  +8.53225000E-03
   -1.19943500E-02  -6.81950000E-04  -5.29700000E-05  +4.98000000E-04  +1.48572000E-03
   +1.02290000E-04  +9.08600000E-05  +8.38400000E-05  -1.14907000E-03  -4.21680000E-04
   -2.79170000E-03  +4.01670000E-04  -1.23630000E-04  -2.25660000E-04  -2.03820000E-04
   +5.10200000E-05  -2.47490000E-04  -3.69370000E-04  +4.11600000E-05  -4.28800000E-05
   +2.02740000E-04  -6.65000000E-05  +1.35440000E-04  +1.27296620E-01  -2.18720850E-01
   -2.09459400E-02  +3.54520000E-04  -7.54390000E-04  +9.93700000E-05  -1.48710000E-04
   +5.11460000E-04  +6.90000000E-05  +4.09250000E-04  -1.80440000E-04  -1.84340000E-04
   +2.39410000E-04  -8.15000000E-06  +3.87900000E-05  +1.87590000E-04  -9.79300000E-05
   +4.90000000E-07  -4.20000000E-06  -1.12400000E-05  -2.40000000E-06  +5.62000000E-06
   -1.39100000E-05  +2.00500000E-05  +3.23700000E-05  +2.90300000E-05  +1.20790000E-04
   -1.00757000E-03  -5.40780000E-04  +6.86050000E-04  -2.61000000E-05  -2.00400000E-05
   -2.27500000E-05  -1.06960000E-04  +7.01160000E-04  -1.21560000E-04  -9.84000000E-05
   -2.66500000E-05  -1.17470000E-04  -3.06490000E-04  +1.34510000E-04  +8.12500000E-05
   +1.16833400E-02  -1.46378900E-02  -3.22705000E-03  -6.50775000E-03  +9.22479000E-03
   +1.43332000E-03  -1.39612200E-01  +2.35717940E-01  -2.25670000E-04  +2.61750000E-04
   +3.44940000E-04  +3.45880000E-04  +6.78520000E-04  +1.04613000E-03  -4.82500000E-05
   +6.36700000E-05  -2.99860000E-04  +1.81200000E-04  +7.24400000E-05  -4.77000000E-06
   -1.37110000E-04  +5.62900000E-05  +1.89600000E-04  -1.88620000E-04  -7.00100000E-05
   -1.00800000E-04  +1.79888100E-02  -2.42204000E-02  -5.23065000E-03  +9.11830000E-04
   -1.24727000E-03  +1.13304000E-03  +6.99700000E-05  +1.88400000E-05  -1.31700000E-05
   -2.71728000E-03  -7.48680000E-04  -5.11732000E-03  -1.55550000E-04  +5.25720000E-04
   -1.38640000E-04  -5.80800000E-05  +1.17120000E-04  +4.13370000E-04  +6.70430000E-04
   +2.31690000E-04  -5.30960000E-04  -1.39730000E-04  -1.07560000E-04  +2.54100000E-04
   +1.55863800E-02  -1.94063300E-02  -4.89015800E-02  +1.63627000E-03  -1.68280000E-03
   -9.67900000E-05  -4.62600000E-04  +1.41628000E-03  +5.17900000E-05  +6.19290000E-04
   -4.22650000E-04  -2.82270000E-04  -9.06800000E-05  -1.87770000E-04  +7.04470000E-04
   +1.55660000E-04  -7.99500000E-05  +1.63130000E-04  -1.07800000E-05  -1.35200000E-05
   -5.41000000E-06  +2.14700000E-05  -2.17000000E-05  +1.04400000E-05  +4.87700000E-05
   -2.19300000E-05  +5.85800000E-05  -4.47600000E-05  -1.75000000E-05  +1.78630000E-04
   +4.26000000E-06  -2.01200000E-05  +1.02500000E-05  -4.51330000E-04  +4.60670000E-04
   -8.26380000E-04  +5.61900000E-05  +1.01110000E-04  -6.10000000E-05  -1.97690000E-04
   +1.42210000E-04  +4.50720000E-04  -1.56326500E-02  +1.84794000E-02  +3.53449000E-03
   -5.55320000E-04  +1.38136000E-03  -7.80400000E-04  -1.67115500E-02  +2.45320700E-02
   +5.42846500E-02  -7.09800000E-05  -1.51000000E-06  -2.30600000E-04  -5.05900000E-04
   +7.17280000E-04  +2.26180000E-04  -1.14600000E-04  +1.91640000E-04  +2.79320000E-04
   +4.50700000E-05  -2.09900000E-05  -1.05350000E-04  +1.32000000E-06  +4.24600000E-05
   +7.16300000E-05  -2.94600000E-05  -7.65000000E-05  +7.73000000E-06  -1.95060000E-03
   -2.84857000E-03  -2.27293000E-03  -1.43558000E-03  +1.49977000E-03  +1.28401000E-03
   -9.89000000E-06  -1.53600000E-05  -3.16200000E-05  +3.09316000E-03  -1.60283300E-02
   +1.40816700E-02  +3.07381000E-03  +4.48692000E-03  +5.17162000E-03  -6.25960000E-04
   -1.07541000E-03  +4.93510000E-04  -1.79264000E-03  -1.62150000E-04  +1.52903000E-03
   +5.83030000E-04  +1.66070000E-04  -3.94860000E-04  +5.73120000E-04  -2.13650000E-04
   -3.55130000E-04  -5.43829200E-02  -1.38945700E-02  +2.74316400E-02  +7.75989000E-03
   +1.78072100E-02  -1.41500800E-02  -1.00300000E-04  -2.56488000E-03  +2.32150000E-04
   -1.05430000E-04  +3.48640000E-04  -1.55856000E-03  -1.20230000E-04  +2.47100000E-05
   -4.28400000E-05  -1.26600000E-05  -5.59000000E-06  +9.45000000E-06  -1.04900000E-05
   -1.14300000E-05  +5.59000000E-06  +1.57000000E-06  -1.44100000E-04  -3.12300000E-05
   +5.48000000E-06  +1.07000000E-06  -8.03000000E-06  -6.49000000E-06  -2.78200000E-05
   +3.55000000E-06  +2.50000000E-07  -2.37280000E-04  -3.42540000E-04  -1.36930000E-04
   +7.61080000E-04  +1.95000000E-04  -1.83577000E-03  +1.11909000E-03  -5.62850000E-04
   +1.67100000E-05  -4.19700000E-05  -1.48120000E-04  +4.10500000E-05  -4.96600000E-05
   +2.38800000E-05  -6.94800000E-05  -1.37000000E-06  -8.83000000E-05  +4.93377500E-02
   -1.07290000E-04  -6.22800000E-05  -1.71890000E-04  -2.29640000E-04  +5.40460000E-04
   +4.22180000E-04  -1.29270000E-04  +4.30300000E-05  +2.27740000E-04  +3.19500000E-05
   -4.25100000E-05  -7.42100000E-05  +4.72800000E-05  +7.50100000E-05  +6.08600000E-05
   -5.59500000E-05  -6.45400000E-05  -1.72800000E-05  -1.67375000E-03  -2.45139000E-03
   -1.46627000E-03  +3.27951000E-03  -1.65451000E-03  -9.84030000E-04  -7.39700000E-05
   -4.85600000E-05  -3.62400000E-05  -2.26500000E-05  +6.41286000E-03  -1.62532000E-03
   +4.39902000E-03  +2.40361000E-03  +1.31368000E-03  -3.58240000E-04  -5.90370000E-04
   +2.22980000E-04  -3.17410000E-04  +6.31500000E-05  +3.23220000E-04  +8.15900000E-05
   +6.65300000E-05  -1.30470000E-04  +3.99440000E-04  -4.77490000E-04  -7.49400000E-05
   -1.53821700E-02  -2.11800980E-01  +1.50479560E-01  -1.66312000E-03  -1.88942400E-02
   +1.75116400E-02  -2.51686000E-03  +2.91779000E-03  -2.04889000E-03  -1.23510000E-04
   +2.30810000E-04  -6.60740000E-04  -5.28810000E-04  +2.44240000E-04  -6.88030000E-04
   -6.16000000E-06  +5.81000000E-06  +1.07900000E-05  -1.84900000E-05  -1.30600000E-05
   +9.40000000E-07  -1.00030000E-04  -5.81900000E-05  -2.72200000E-05  +1.83000000E-05
   +9.55000000E-06  -1.39300000E-05  -1.64200000E-05  -1.63200000E-05  -2.80000000E-07
   +6.57000000E-05  -2.40000000E-05  -5.07620000E-04  +1.15392000E-03  -1.69995000E-03
   -5.79790000E-04  +8.17130000E-04  -6.19030000E-04  -2.82270000E-04  -9.32000000E-06
   +7.28000000E-06  +4.34000000E-05  -1.08900000E-05  +1.72000000E-05  -1.80000000E-06
   -3.79300000E-05  -4.86000000E-06  -1.84450000E-04  +9.31551000E-03  +2.27755910E-01
   -7.60800000E-05  -7.59700000E-05  -1.88950000E-04  -4.45000000E-04  +6.35410000E-04
   +4.12850000E-04  -7.58600000E-05  +2.75900000E-05  +1.37550000E-04  +1.37900000E-05
   -2.69700000E-05  -4.26000000E-06  +8.94900000E-05  +1.06350000E-04  +8.45000000E-05
   -9.86800000E-05  -1.09680000E-04  -2.69400000E-05  -3.60133000E-03  -7.61120000E-04
   -2.63092000E-03  -7.91000000E-06  +6.07730000E-04  +5.30020000E-04  -1.55140000E-04
   -8.04000000E-05  -4.27200000E-05  +3.25257000E-03  +1.77036200E-02  -1.23835400E-02
   +7.68790000E-03  +1.55998000E-03  +2.89188000E-03  -5.46750000E-04  -6.52490000E-04
   +2.07720000E-04  -4.30070000E-04  -9.53600000E-05  +5.35080000E-04  +6.26300000E-05
   +1.38100000E-04  -2.35310000E-04  +7.21280000E-04  -4.95130000E-04  -2.00460000E-04
   +2.37053300E-02  +1.49044540E-01  -1.68417460E-01  +5.21497000E-03  -4.37785000E-03
   +3.81858000E-03  -2.54342000E-03  -5.65070000E-04  -1.98850000E-04  -5.74180000E-04
   +1.68800000E-04  -8.07710000E-04  -2.87160000E-04  +1.94230000E-04  -3.05790000E-04
   +4.43000000E-06  +1.50600000E-05  +1.35800000E-05  -2.06800000E-05  -1.17300000E-05
   -8.83000000E-06  +5.96000000E-06  +8.32000000E-06  -1.56000000E-06  +1.12500000E-05
   +2.72800000E-05  -1.56700000E-05  -2.12300000E-05  -1.75900000E-05  +1.86000000E-06
   -5.89820000E-04  -1.23300000E-04  +1.34950000E-04  -8.86700000E-05  -1.05836000E-03
   -1.06580000E-04  -4.47000000E-04  +4.05170000E-04  +3.21460000E-04  -4.98500000E-05
   -9.75000000E-06  +6.17200000E-05  +1.03200000E-05  -4.33600000E-05  -7.54800000E-05
   -3.74900000E-05  -8.25300000E-05  -2.07220000E-04  -3.22712300E-02  -1.61313690E-01
   +1.76952940E-01  -4.15000000E-05  -5.16600000E-05  -9.70200000E-05  -6.21000000E-05
   +3.13260000E-04  +1.83060000E-04  -4.03000000E-05  -4.14900000E-05  +2.99900000E-05
   -7.47000000E-06  -9.95000000E-06  +2.23700000E-05  +6.89100000E-05  +6.91100000E-05
   +5.41400000E-05  -7.33300000E-05  -6.72500000E-05  -1.10700000E-05  -6.80240000E-04
   -5.90200000E-04  -2.43040000E-04  -9.12400000E-05  +8.03300000E-05  +5.87800000E-05
   -1.19270000E-04  -6.33300000E-05  -1.95300000E-05  +3.63860000E-04  +4.47230000E-04
   -1.81631000E-03  -8.09400000E-05  +1.32324000E-03  -1.36830000E-04  +5.97120000E-04
   -8.34600000E-04  +1.92460000E-04  -1.97947000E-03  -2.43573000E-03  +1.11132000E-03
   +4.96700000E-05  +1.35640000E-03  -1.28348000E-03  -4.45800000E-05  +2.42100000E-05
   -2.09450000E-04  +8.20272000E-03  +1.94232400E-02  -2.47468000E-03  -6.55101500E-02
   -3.58904800E-02  +2.69627100E-02  -8.69708000E-03  -2.77173100E-02  +2.16388300E-02
   -3.21927000E-03  -1.96459000E-03  -9.45227000E-03  -1.18129000E-03  +1.35670000E-03
   -7.18040000E-04  +6.85000000E-06  +1.57900000E-05  +4.64000000E-06  -1.81000000E-05
   -7.60000000E-07  -1.54900000E-05  +2.69800000E-05  +4.30500000E-05  +1.83000000E-05
   +4.76000000E-06  +2.37000000E-05  -9.03000000E-06  -1.65800000E-05  -9.53000000E-06
   +1.23000000E-06  -1.05890000E-04  +1.24900000E-05  +4.58000000E-05  -7.52700000E-05
   -1.09520000E-04  -3.04200000E-05  +6.65200000E-05  +9.10000000E-07  +5.20500000E-05
   -3.65400000E-05  -1.46100000E-05  +5.82600000E-05  +1.44700000E-05  -1.25800000E-05
   -3.94300000E-05  -9.91000000E-06  +2.00200000E-05  +5.91300000E-05  -1.53632000E-03
   +2.98080000E-03  +1.05425000E-03  +7.04602200E-02  +1.74700000E-05  +2.20400000E-05
   -7.91000000E-06  -6.90000000E-05  +3.40300000E-05  -2.26100000E-05  +2.70000000E-05
   +3.67200000E-05  -2.60600000E-05  -5.50000000E-07  +1.69800000E-05  +3.80000000E-07
   +2.46900000E-05  +1.78000000E-06  +7.20000000E-07  +1.11000000E-06  +4.90000000E-07
   +6.00000000E-07  -4.07000000E-05  -2.23180000E-04  -1.90640000E-04  +7.48100000E-05
   -1.16380000E-04  +1.74800000E-05  -1.32500000E-05  +2.38000000E-06  -1.50000000E-06
   -2.89280000E-04  +8.65500000E-05  +9.59490000E-04  +3.14890000E-04  +6.04770000E-04
   -4.21970000E-04  +2.28730000E-04  +7.63000000E-06  -5.66890000E-04  -1.71842000E-03
   +4.05500000E-05  -7.60510000E-04  +5.12420000E-04  +2.46700000E-05  -1.60040000E-04
   +1.06400000E-05  +3.45500000E-05  -3.10000000E-07  -4.97302000E-03  -1.31035400E-02
   +1.36470600E-02  -3.67612200E-02  -2.83350330E-01  +9.05229200E-02  -5.61751000E-03
   +9.72292000E-03  +5.91336000E-03  -3.99460000E-04  +1.07573000E-03  -2.40651000E-03
   -1.55203000E-03  +3.17880000E-04  -1.25998000E-03  +7.72000000E-06  -3.71000000E-06
   +1.94000000E-06  +1.18400000E-05  -5.47000000E-06  +6.69000000E-06  +2.00000000E-07
   -6.31900000E-05  +1.70600000E-05  -2.72000000E-06  -5.94000000E-06  +5.62000000E-06
   +2.70000000E-06  -2.35000000E-06  +2.58000000E-06  +7.78100000E-05  +1.48900000E-05
   -8.47900000E-05  +8.27800000E-05  +1.14110000E-04  +5.12000000E-05  -9.46000000E-05
   -1.92500000E-05  -9.81600000E-05  +1.96000000E-05  -2.11000000E-06  -6.73800000E-05
   +1.06300000E-05  -5.84000000E-06  +2.02800000E-05  -9.93000000E-06  +2.28500000E-05
   -2.79900000E-05  +2.11529000E-03  -1.96360000E-03  -9.48060000E-04  +4.63785700E-02
   +2.86559480E-01  -2.39300000E-05  -1.76600000E-05  -1.00360000E-04  -3.41300000E-05
   +2.53810000E-04  +5.38000000E-05  -5.88300000E-05  +1.45200000E-05  +7.26700000E-05
   -1.87000000E-05  -4.03000000E-06  +1.75200000E-05  +9.63500000E-05  +6.09500000E-05
   +4.68400000E-05  -4.28100000E-05  -4.91300000E-05  -2.73600000E-05  -3.50790000E-04
   -4.07620000E-04  -1.74410000E-04  +5.00000000E-06  -2.54100000E-05  +1.02520000E-04
   -1.31930000E-04  -6.57200000E-05  -2.72600000E-05  +1.01640000E-04  +6.11870000E-04
   -1.73478000E-03  +1.20932000E-03  -4.29010000E-04  -2.13150000E-04  +3.51090000E-04
   +1.45030000E-04  -1.19474000E-03  -5.40979000E-03  -4.91822000E-03  +2.41102000E-03
   +6.95580000E-04  +1.95526000E-03  -2.03136000E-03  -5.70700000E-05  +5.29000000E-06
   -1.25070000E-04  -4.71680000E-04  +1.81023000E-03  +1.19495800E-02  +2.34921200E-02
   +8.94957600E-02  -7.99208000E-02  +2.15085600E-02  +2.29005500E-02  -5.36603000E-03
   -6.66503000E-03  -4.97529000E-03  -1.45328800E-02  -3.48230000E-04  +3.72360000E-04
   +8.51950000E-04  +9.59000000E-06  +1.59000000E-05  +1.04700000E-05  -2.25500000E-05
   -4.86000000E-06  -1.29100000E-05  +1.91700000E-05  +2.41700000E-05  +1.73500000E-05
   +1.14500000E-05  +6.67000000E-06  -8.43000000E-06  -1.06400000E-05  -1.00800000E-05
   +2.32000000E-06  -7.12000000E-06  +1.95100000E-05  -7.46700000E-05  +5.09000000E-06
   -5.00000000E-06  +2.03700000E-05  -2.36500000E-05  -3.00300000E-05  -7.21700000E-05
   +8.30000000E-07  -1.68800000E-05  -1.07900000E-05  +9.53000000E-06  -7.97000000E-06
   -2.40700000E-05  -4.75000000E-06  +3.55300000E-05  +3.44500000E-05  +2.19906000E-03
   +1.57520000E-04  +9.83670000E-04  -3.63244500E-02  -1.05974350E-01  +9.22035700E-02
   -1.49000000E-06  -2.27100000E-05  +1.03300000E-05  +1.51440000E-04  -1.39000000E-05
   +2.32500000E-05  +1.05800000E-05  -2.43900000E-05  -7.20000000E-06  -1.57300000E-05
   -2.59000000E-06  +1.00100000E-05  +1.37600000E-05  +3.16000000E-06  -1.09600000E-05
   -1.66700000E-05  -1.74500000E-05  +9.14000000E-06  +3.16440000E-04  +2.67750000E-04
   -4.24880000E-04  -1.70570000E-04  +1.51010000E-04  +7.64400000E-05  -2.66900000E-05
   -1.76400000E-05  +3.66000000E-06  -2.40531000E-03  +7.00130000E-04  -1.68080000E-03
   +5.91026000E-03  +1.62717900E-02  -1.95017100E-02  -8.91307500E-02  -6.49263000E-02
   +7.24933100E-02  -5.61265000E-03  -1.98001300E-02  +2.39438900E-02  +1.56645000E-03
   +1.99344000E-03  -1.62089000E-03  -2.74000000E-05  -2.61900000E-05  -3.42000000E-05
   +4.02710000E-04  +3.35100000E-05  -4.83080000E-04  -1.30862000E-03  +4.14720000E-04
   -1.29402000E-03  +3.86930000E-04  -1.92150000E-04  +2.97570000E-04  -9.24540000E-03
   -6.58800000E-05  +2.39804000E-03  -5.64350000E-04  +6.04210000E-04  +1.14882000E-03
   -1.36000000E-06  +5.67000000E-06  -3.13000000E-06  -3.65000000E-06  +5.90000000E-07
   -3.33000000E-06  +5.58000000E-06  +8.73000000E-06  +1.12700000E-05  +3.75000000E-06
   +1.65000000E-05  -7.30000000E-07  -1.00900000E-05  +6.94000000E-06  -2.10000000E-06
   +3.16000000E-06  +7.12500000E-05  -4.21100000E-05  +2.14000000E-06  -6.06000000E-06
   -3.15000000E-06  +1.07900000E-05  -1.16600000E-05  +6.73000000E-06  +2.08300000E-05
   +3.22000000E-06  +2.68000000E-05  -2.89000000E-06  +6.93000000E-06  +1.32800000E-05
   +3.55000000E-06  +1.91900000E-05  +1.39200000E-05  +2.80560000E-04  +7.23800000E-05
   +7.87000000E-06  +1.22910000E-04  -7.83100000E-05  +7.32000000E-05  +9.73388700E-02
   +6.11100000E-05  +4.45600000E-05  -1.84000000E-06  -1.67730000E-04  +3.75800000E-05
   -7.16600000E-05  -6.18100000E-05  +5.38400000E-05  +2.17900000E-05  +3.21100000E-05
   -4.00000000E-08  -9.61000000E-06  +3.51300000E-05  +3.51900000E-05  +5.36300000E-05
   -2.00700000E-05  -3.96100000E-05  -5.24100000E-05  +1.59490000E-04  +4.97470000E-04
   -9.25580000E-04  -2.76310000E-04  +7.23200000E-05  +3.64000000E-06  -4.75000000E-05
   -2.45500000E-05  -2.00600000E-05  +6.87950000E-04  +8.26226000E-03  +6.70072000E-03
   -2.02006000E-03  -4.90262000E-03  +1.27828100E-02  -6.42356600E-02  -1.50256630E-01
   +1.28261440E-01  +1.82191000E-03  +8.71110000E-04  +6.40456000E-03  +8.04860000E-04
   +2.33800000E-05  -1.77464000E-03  +7.01300000E-05  -2.54430000E-04  -9.44500000E-05
   -7.02330000E-04  -1.12465000E-03  +5.46900000E-04  +1.03082000E-03  -2.38740000E-04
   -2.15590000E-04  -5.22620000E-04  +1.98990000E-04  +2.82780000E-04  -5.83430000E-04
   +1.09818000E-03  -1.33710000E-04  -2.67360000E-04  +1.67260000E-04  -5.79400000E-05
   +3.20000000E-06  +5.25000000E-06  +6.12000000E-06  -3.41000000E-06  -4.20000000E-06
   -2.80000000E-06  -9.22000000E-06  -3.70000000E-06  -2.68700000E-05  +6.16000000E-06
   -1.97100000E-05  +4.40000000E-07  +7.20000000E-06  -1.45000000E-06  +2.96000000E-06
   +9.65000000E-06  +3.50200000E-05  -9.87000000E-05  +1.93300000E-05  +9.58000000E-06
   +2.79700000E-05  -1.69400000E-05  +1.20100000E-05  -5.23700000E-05  +4.97300000E-05
   -5.96300000E-05  +2.10600000E-05  +4.75000000E-06  +2.47700000E-05  +1.57600000E-05
   +4.10000000E-07  -2.22100000E-05  -5.03100000E-05  -7.56290000E-04  -3.60070000E-04
   -3.62280000E-04  -1.25660000E-04  +1.15200000E-04  -3.81600000E-05  +6.44221800E-02
   +1.50942300E-01  +4.75100000E-05  +5.84000000E-06  -3.58000000E-05  +1.72400000E-05
   +8.08100000E-05  -4.50700000E-05  -4.09600000E-05  +1.91400000E-05  +1.94600000E-05
   +1.38000000E-06  -1.02300000E-05  +1.65400000E-05  +5.36300000E-05  +4.11600000E-05
   +3.75700000E-05  -4.57700000E-05  -6.57800000E-05  -2.50100000E-05  +6.60540000E-04
   +7.59950000E-04  -1.51025000E-03  -4.73430000E-04  +2.64910000E-04  +1.77360000E-04
   -9.02000000E-05  -5.26300000E-05  -1.35600000E-05  -3.03526000E-03  +6.55730000E-03
   +5.47799000E-03  +7.97375000E-03  +1.19983700E-02  -8.51478000E-03  +7.19508600E-02
   +1.31063070E-01  -1.95187970E-01  -2.50179000E-03  +2.46595000E-03  +8.26290000E-04
   -9.70520000E-04  -1.42536000E-03  +7.39810000E-04  +6.33700000E-05  -1.59040000E-04
   -1.97510000E-04  -6.84880000E-04  -8.76030000E-04  +5.15620000E-04  +7.21130000E-04
   -2.66860000E-04  +1.89780000E-04  -3.26760000E-04  +1.29260000E-04  +6.44900000E-05
   +6.24180000E-04  +1.67960000E-04  +7.05340000E-04  +4.35000000E-06  -4.12500000E-05
   -2.62660000E-04  +9.10000000E-07  +1.61300000E-05  +1.26000000E-06  -1.21000000E-05
   +2.70000000E-07  -1.22100000E-05  +4.19000000E-06  +1.70200000E-05  -1.32000000E-06
   +2.08000000E-06  +1.28100000E-05  -1.29000000E-06  -9.80000000E-06  +5.07000000E-06
   -1.24000000E-06  +1.16200000E-05  +1.34200000E-04  -1.40200000E-04  +2.01200000E-05
   -6.43000000E-06  +1.35000000E-05  +1.56000000E-06  -1.11200000E-05  -2.56200000E-05
   +1.22000000E-06  -4.96000000E-06  +6.82500000E-05  -2.82000000E-06  -2.54000000E-06
   +1.49100000E-05  -1.34600000E-05  -9.07000000E-06  +3.57000000E-05  -4.29220000E-04
   -1.98850000E-04  -2.95710000E-04  +2.98100000E-05  +1.93020000E-04  -3.30000000E-07
   -7.29918500E-02  -1.46374040E-01  +2.00297900E-01  -2.30360000E-04  +6.98800000E-04
   -4.37950000E-04  -9.53120000E-04  +1.68318000E-03  -1.26672000E-03  -3.12530000E-04
   +8.32900000E-04  -3.41420000E-04  +1.94130000E-04  -7.33500000E-05  +1.09320000E-04
   -8.51300000E-05  -8.59400000E-05  +9.14600000E-05  -6.83300000E-05  -1.82900000E-04
   -1.40600000E-05  -4.52420000E-04  +3.56740000E-04  +2.42330000E-04  -3.83400000E-05
   -1.76280000E-04  -7.12100000E-05  -4.80400000E-05  +1.00000000E-06  -2.30400000E-05
   -2.35428000E-03  -1.34357000E-03  +2.68127000E-03  -3.02515990E-01  -5.48418800E-02
   +6.14090800E-02  -2.22535100E-02  -4.08637000E-03  +4.43029000E-03  +3.06105000E-03
   +2.02450000E-03  -1.59018000E-03  -1.76457000E-03  +3.08380000E-04  -1.04893000E-03
   -1.26200000E-05  -6.88200000E-05  +2.70280000E-04  +3.49030000E-04  -7.76690000E-04
   -3.78010000E-04  +2.68780000E-04  -1.40510000E-04  -2.30650000E-04  -1.77550000E-04
   +9.71400000E-05  +1.22210000E-04  -2.60580000E-04  -3.05930000E-04  +5.47060000E-04
   -1.45890000E-04  +1.04600000E-04  +9.04500000E-05  -5.89000000E-06  -5.32000000E-06
   +6.93000000E-06  +2.80000000E-06  -4.06000000E-06  +6.25000000E-06  +6.56000000E-06
   -6.37400000E-05  +4.27200000E-05  +7.24400000E-05  -7.16900000E-05  +1.73800000E-05
   +4.50000000E-07  +1.90000000E-07  +5.50000000E-07  +6.06700000E-05  -3.92200000E-05
   +2.57000000E-06  +3.74000000E-06  +8.09000000E-06  +2.65700000E-05  -3.58900000E-05
   -4.64000000E-06  -6.91000000E-05  +4.22200000E-05  -9.54300000E-05  -2.43960000E-04
   +1.92100000E-05  +7.55400000E-05  -5.12100000E-05  +2.19600000E-05  +6.60200000E-05
   -1.19490000E-04  -9.35500000E-05  +7.94800000E-05  -6.34000000E-06  -7.62300000E-05
   -3.61800000E-05  -1.07300000E-05  +1.17733000E-03  +1.63410000E-04  -5.10300000E-04
   +3.26311770E-01  +4.71810000E-04  -1.28160000E-04  -7.14900000E-05  +4.05130000E-04
   -7.31660000E-04  +2.91330000E-04  +3.98720000E-04  +2.91190000E-04  +5.58040000E-04
   -3.35210000E-04  -1.39090000E-04  +4.16100000E-05  +3.72620000E-04  +1.94600000E-05
   -9.55700000E-05  +1.39770000E-04  +6.56900000E-05  -8.10100000E-05  -6.21680000E-04
   +4.58530000E-04  +1.03750000E-04  +9.52700000E-05  +4.40000000E-06  -2.02000000E-06
   -3.82670000E-04  -1.83400000E-04  -6.05100000E-05  -1.99963600E-02  +5.26700000E-04
   +4.51390000E-03  -5.41151400E-02  -6.40497900E-02  +2.20832800E-02  +1.61439700E-02
   +9.99224000E-03  -3.45530000E-04  -2.79080000E-03  +6.59176000E-03  +9.07691000E-03
   +2.25830000E-03  -1.90695000E-03  -7.78920000E-04  -5.15000000E-05  -2.42620000E-04
   +1.57240000E-04  -1.09352000E-03  -1.39785000E-03  +3.97800000E-03  +2.38589000E-03
   -2.01692000E-03  +8.14400000E-05  -1.17945000E-03  +5.32160000E-04  +3.25300000E-05
   +4.50350000E-04  -6.28700000E-04  -2.28242000E-03  -1.01880000E-04  +5.13000000E-05
   -5.91240000E-04  +1.92500000E-05  +4.59400000E-05  +1.75200000E-05  -4.02400000E-05
   -6.95000000E-06  -3.30700000E-05  -8.79000000E-06  -7.55000000E-06  -8.95300000E-05
   +2.49400000E-05  -1.03030000E-04  -1.99200000E-05  -1.93400000E-05  +1.37300000E-05
   +2.78000000E-06  +3.51000000E-05  -3.41200000E-05  -2.53000000E-05  +6.61600000E-05
   +1.00270000E-04  +1.91000000E-06  -5.20000000E-05  +3.70700000E-05  -8.46000000E-05
   -9.41200000E-05  -5.35050000E-04  -3.69060000E-04  +9.10100000E-05  +1.55690000E-04
   +5.89800000E-05  +5.67800000E-05  +7.08700000E-05  -1.76490000E-04  -2.11360000E-04
   +5.11530000E-04  +1.00781000E-03  +9.84000000E-06  +2.54320000E-04  -6.72700000E-05
   +1.26984000E-03  -4.89652000E-03  -4.52739000E-03  +5.61109200E-02  +5.75347700E-02
   -5.78420000E-04  -1.50100000E-05  +2.73810000E-04  -2.70400000E-04  +4.40160000E-04
   +1.06100000E-04  -1.10700000E-04  -1.50840000E-04  -4.09720000E-04  -9.55100000E-05
   -2.24330000E-04  -4.44800000E-05  -3.49370000E-04  -1.15690000E-04  -1.02700000E-04
   +1.66720000E-04  +1.85240000E-04  +7.90600000E-05  +5.29060000E-04  -1.74770000E-04
   +4.14900000E-05  -1.81620000E-04  -1.12410000E-04  -1.71070000E-04  +3.75100000E-04
   +1.43070000E-04  +4.79400000E-05  +2.38141300E-02  +8.77431000E-03  -7.36260000E-03
   +6.64620400E-02  +1.87017200E-02  -5.79448300E-02  -2.24437300E-02  +2.54964000E-03
   +5.46192000E-03  -4.49660000E-04  +8.40097000E-03  +4.98996000E-03  -2.40660000E-04
   -1.42878000E-03  -1.50956000E-03  -1.78740000E-04  -1.27020000E-04  +9.95900000E-05
   -1.66135000E-03  +3.08644000E-03  -8.77050000E-04  +2.59650000E-04  +5.25320000E-04
   +1.36650000E-04  +1.70210000E-04  -1.37840000E-04  -6.26400000E-05  -7.05960000E-04
   -1.44145000E-03  +4.48600000E-05  +1.61510000E-04  -5.78800000E-05  +3.37600000E-05
   -5.01400000E-05  -2.39300000E-05  -2.96000000E-05  +8.10000000E-06  +3.06500000E-05
   -2.26000000E-06  +5.65200000E-05  +8.14400000E-05  -4.62900000E-05  +5.27900000E-05
   -1.12900000E-04  -5.27000000E-05  +3.15900000E-05  -1.38000000E-05  -2.16000000E-06
   -5.98200000E-05  +3.57500000E-05  +3.14000000E-05  -5.46400000E-05  -1.24050000E-04
   +4.27200000E-05  +5.49700000E-05  +2.15200000E-05  -6.55000000E-06  +3.53000000E-05
   -3.09440000E-04  +2.74100000E-05  -4.70000000E-06  -8.50000000E-05  -2.79200000E-05
   +1.11600000E-05  +7.62700000E-05  -3.32500000E-05  -1.30820000E-04  -5.29140000E-04
   -1.35446000E-03  +1.12510000E-04  +1.55960000E-04  +3.19600000E-05  -9.17080000E-04
   -4.96536000E-03  -3.39544000E-03  -6.35347500E-02  -3.31092000E-02  +6.20818800E-02
   -2.39500000E-05  -3.17500000E-05  +1.59120000E-04  -4.94100000E-05  -2.26050000E-04
   +3.91000000E-05  +6.99900000E-05  -1.11550000E-04  -2.91400000E-05  +1.16960000E-04
   -5.12600000E-05  -1.02980000E-04  -5.06500000E-04  -2.04030000E-04  -1.14330000E-04
   +7.98400000E-05  +8.65700000E-05  +1.39750000E-04  -4.55990000E-04  +1.91190000E-04
   +7.50600000E-05  +2.60450000E-04  -1.21760000E-04  -5.99000000E-05  +5.80830000E-04
   +2.33570000E-04  +1.06850000E-04  +2.41990000E-04  +1.19179000E-03  -6.70670000E-04
   +7.27670000E-04  +2.82150000E-04  +9.48000000E-05  +1.27888000E-03  +2.57552000E-03
   -9.20100000E-05  -8.44680000E-03  -1.83354500E-02  +2.97462300E-02  -4.06239000E-03
   +5.16745000E-03  -1.21741000E-02  +1.21820000E-04  -1.42460000E-04  -2.74300000E-05
   -5.71170000E-04  +1.85520000E-04  +1.90867000E-03  +2.75069000E-03  +1.98486000E-03
   -2.15251400E-02  -2.43545100E-02  +7.00546000E-03  +3.05559000E-03  +1.87796200E-02
   -4.78387000E-03  -2.33892700E-02  -8.09243800E-02  +1.06327500E-02  +1.68079300E-02
   -9.12000000E-05  -4.29800000E-05  -5.28300000E-05  +3.44000000E-05  +4.03200000E-05
   +2.70500000E-05  -6.88100000E-05  +4.09000000E-06  -1.03960000E-04  -7.22500000E-05
   +3.35800000E-05  +1.46400000E-05  +1.76600000E-05  +2.07700000E-05  -1.94700000E-05
   +4.62200000E-05  -1.02620000E-04  +3.87900000E-05  -1.27400000E-05  +6.40400000E-05
   -4.21800000E-05  -2.06900000E-05  +3.24100000E-05  +3.35600000E-05  -1.34570000E-04
   +4.49800000E-05  +1.68200000E-04  -1.85000000E-06  +1.75170000E-04  +7.77000000E-06
   +9.90400000E-05  -1.42310000E-04  +2.03000000E-05  -5.31500000E-05  -2.99860000E-04
   -2.51500000E-05  +3.40100000E-04  -6.19890000E-04  +8.19000000E-04  +1.12524000E-03
   +1.71140000E-04  -1.69560000E-04  +1.68000000E-04  -3.46620000E-04  -5.50100000E-05
   +7.37677400E-02  +8.08000000E-06  +9.77000000E-06  -8.32600000E-05  +4.20700000E-05
   +1.22400000E-04  -2.37600000E-05  -4.03900000E-05  +4.83600000E-05  +2.37400000E-05
   -6.75900000E-05  +2.05700000E-05  +5.89100000E-05  +2.80090000E-04  +1.16800000E-04
   +6.53200000E-05  -4.74700000E-05  -5.31700000E-05  -7.78400000E-05  +2.64070000E-04
   -8.85000000E-05  +4.11000000E-06  -1.07000000E-04  +6.51500000E-05  +3.45700000E-05
   -3.24900000E-04  -1.38740000E-04  -5.82000000E-05  +6.75900000E-05  -3.54760000E-04
   +3.07700000E-05  -2.95110000E-04  -2.71600000E-04  -9.85100000E-05  -1.65726000E-03
   -2.14243000E-03  +2.56292000E-03  -6.77963000E-03  +1.25166500E-02  -1.34968400E-02
   +2.86833000E-03  -3.81567000E-03  +5.61692000E-03  -5.16700000E-05  +9.33500000E-05
   -2.09000000E-06  -3.58200000E-04  -2.46990000E-04  -7.72140000E-04  -6.19750000E-04
   +8.24470000E-04  +1.05796700E-02  +1.18862300E-02  -4.17549000E-03  -1.34211000E-03
   -1.16714200E-02  -1.84743200E-02  +1.36245400E-02  +3.20966400E-02  -7.04548400E-02
   -6.53451100E-02  +4.73300000E-05  +2.99900000E-05  +2.68600000E-05  -2.36200000E-05
   -1.88200000E-05  -1.95400000E-05  +3.90700000E-05  +9.50000000E-06  +5.55300000E-05
   +4.15000000E-05  -1.42400000E-05  -1.20300000E-05  -1.13900000E-05  -9.06000000E-06
   +9.43000000E-06  -2.66800000E-05  +5.18200000E-05  -1.69900000E-05  +3.01000000E-06
   -4.51200000E-05  +2.56300000E-05  +7.28000000E-06  -2.07700000E-05  -2.04500000E-05
   +5.76400000E-05  -2.64900000E-05  -6.79000000E-05  -5.46000000E-06  -8.97000000E-05
   -9.97000000E-06  -5.33600000E-05  +6.94500000E-05  +2.16000000E-06  +6.42600000E-05
   +4.51800000E-05  -9.00000000E-06  -1.12280000E-03  +7.54300000E-05  -6.15540000E-04
   -1.25846000E-03  -1.07210000E-04  +1.83050000E-04  -1.17340000E-04  +1.25000000E-04
   -4.15200000E-05  +1.60347000E-03  +6.79406800E-02  +1.42300000E-05  +3.22700000E-05
   -1.01760000E-04  +3.63700000E-05  +1.11570000E-04  -6.13900000E-05  -5.88900000E-05
   +9.62200000E-05  +4.89300000E-05  -8.06400000E-05  +2.76300000E-05  +6.14900000E-05
   +3.44770000E-04  +1.33670000E-04  +7.73300000E-05  -3.66600000E-05  -4.71100000E-05
   -1.04710000E-04  +3.83160000E-04  -1.20120000E-04  -1.73100000E-04  -1.87980000E-04
   +9.30600000E-05  +3.73200000E-05  -3.91040000E-04  -1.57650000E-04  -7.96900000E-05
   -8.63110000E-04  -1.30023000E-03  +1.17557000E-03  -8.82520000E-04  -3.64800000E-05
   -5.75400000E-04  -7.98900000E-04  -2.70148000E-03  +9.28900000E-04  +1.05802300E-02
   +7.97456000E-03  -2.20928200E-02  +2.22770000E-04  -1.01140000E-03  +7.50872000E-03
   -2.60200000E-05  +8.80900000E-05  +6.42900000E-05  +8.45400000E-04  -1.10476000E-03
   -2.59825000E-03  -1.12521200E-02  +1.51970000E-03  +2.12140300E-02  +2.47122200E-02
   -5.99415000E-03  -1.94074000E-03  -3.58865200E-02  +1.30176400E-02  +1.97293000E-03
   +6.17069300E-02  -5.54556100E-02  -1.29090530E-01  +6.00600000E-05  +2.89100000E-05
   +4.03200000E-05  -2.99300000E-05  -2.91700000E-05  -1.91400000E-05  +4.78900000E-05
   -1.08000000E-06  +6.34800000E-05  +5.71400000E-05  -3.44000000E-05  -1.29600000E-05
   -7.67000000E-06  -1.52500000E-05  +1.40700000E-05  -1.37300000E-05  +6.92200000E-05
   -4.11700000E-05  +1.37500000E-05  -2.47900000E-05  +4.76100000E-05  -8.72000000E-06
   -2.54100000E-05  -4.69100000E-05  +1.16440000E-04  -3.00400000E-05  -1.54810000E-04
   -1.62000000E-06  -1.38010000E-04  +2.02400000E-05  -7.31100000E-05  +1.02220000E-04
   -5.26200000E-05  +1.10130000E-04  +2.49290000E-04  -1.47900000E-05  -1.24460000E-03
   +1.25620000E-04  -1.08519000E-03  -1.22625000E-03  +9.03000000E-05  +3.71480000E-04
   -1.64850000E-04  +4.09870000E-04  +3.15200000E-05  -2.34892500E-02  +3.39736600E-02
   +1.54745590E-01  -4.62000000E-06  +6.29500000E-05  +3.46480000E-04  -3.10000000E-05
   -8.51960000E-04  -2.35520000E-04  +7.84500000E-05  -1.54500000E-05  +1.15840000E-04
   +1.72260000E-04  -1.16270000E-04  -2.30790000E-04  -8.13660000E-04  -3.96360000E-04
   -2.33480000E-04  +2.96620000E-04  +2.54770000E-04  +1.57500000E-04  +1.65120000E-04
   +8.79670000E-04  -7.46570000E-04  +3.25500000E-04  -3.00500000E-05  -1.51970000E-04
   +9.92950000E-04  +4.18030000E-04  +1.39000000E-04  -3.70586000E-03  -2.35744000E-03
   +4.77154000E-03  -1.10192000E-03  -2.38920000E-04  -9.34390000E-04  +5.60200000E-05
   -1.21934000E-03  +2.29700000E-05  +1.78687000E-03  -2.90220000E-04  -1.65736000E-03
   -2.21363000E-03  +2.27802000E-03  -1.19794000E-03  +6.47160000E-04  -3.76390000E-04
   +5.02600000E-04  +8.64059000E-03  -6.78538000E-03  -1.13691800E-02  -5.42001400E-02
   +1.10705800E-02  +4.12377500E-02  +1.46512100E-02  -6.59557000E-03  -4.56820000E-04
   -1.70841400E-02  +6.62632000E-03  +4.04150000E-04  -1.80590100E-02  -1.20191700E-02
   +4.71250900E-02  -1.51950000E-04  -8.67400000E-05  -5.98000000E-05  +3.63000000E-05
   +4.82300000E-05  +5.58600000E-05  -1.33990000E-04  -1.30300000E-05  -2.36990000E-04
   -6.11300000E-05  -3.98700000E-05  +1.17400000E-05  +6.29600000E-05  +3.28200000E-05
   -2.59700000E-05  +1.57010000E-04  -1.95880000E-04  -4.28100000E-05  -6.71000000E-06
   +1.99780000E-04  +3.70100000E-05  -1.73090000E-04  +5.05700000E-05  -1.02460000E-04
   -5.29000000E-06  +7.99800000E-05  -7.28100000E-05  -3.11700000E-05  +1.13670000E-04
   +1.43420000E-04  +8.49000000E-05  -2.12300000E-04  -3.31020000E-04  +1.71050000E-04
   +9.41420000E-04  +5.34480000E-04  +3.28881000E-03  +2.40887000E-03  -6.09010000E-04
   -3.71760000E-04  +2.34800000E-04  +1.32360000E-04  +9.89500000E-05  +6.13820000E-04
   -2.14130000E-04  +3.43038000E-02  -1.55876300E-02  -2.09914700E-02  +4.26723700E-02
   -1.68500000E-05  -3.93800000E-05  -2.49590000E-04  -3.68900000E-05  +6.21360000E-04
   +1.56630000E-04  -8.03400000E-05  +2.09000000E-05  -4.09000000E-06  -1.03470000E-04
   +5.36900000E-05  +1.34940000E-04  +4.89880000E-04  +2.54930000E-04  +1.58960000E-04
   -1.86780000E-04  -1.73350000E-04  -1.04110000E-04  -4.25780000E-04  -8.58990000E-04
   +1.37600000E-04  -1.80430000E-04  +2.26300000E-05  +1.20870000E-04  -6.11030000E-04
   -2.70370000E-04  -9.32500000E-05  +3.06649000E-03  +2.09941000E-03  -3.25529000E-03
   +6.02710000E-04  +9.47900000E-05  +5.95350000E-04  -1.28150000E-04  +4.97140000E-04
   +5.98400000E-05  +3.21800000E-05  +1.11530000E-03  +3.01690000E-04  +1.03866000E-03
   -1.72273000E-03  +1.34018000E-03  -2.63000000E-04  +1.47660000E-04  -3.12210000E-04
   -4.22298000E-03  +4.90064000E-03  +9.79340000E-03  +1.89942000E-02  +3.83397000E-03
   -2.83363200E-02  -1.17097800E-02  -4.84310100E-02  +1.73544400E-02  +7.80383000E-03
   -4.51317000E-03  +1.70714000E-03  -7.62282000E-03  -3.50511500E-02  +2.94900000E-05
   +8.33000000E-05  +6.07500000E-05  +3.89100000E-05  -3.82300000E-05  -2.76700000E-05
   -4.06300000E-05  +8.85800000E-05  +2.47400000E-05  +1.36700000E-04  +4.16000000E-05
   +2.59900000E-05  -1.49200000E-05  -3.94500000E-05  -2.37300000E-05  +1.49900000E-05
   -8.00600000E-05  +1.18700000E-04  +8.17000000E-06  +1.27100000E-05  -1.12010000E-04
   -4.17000000E-06  +7.23300000E-05  -3.36100000E-05  +3.80400000E-05  +4.15000000E-06
   -4.39000000E-05  +4.20600000E-05  +1.46800000E-05  -8.25300000E-05  -8.11600000E-05
   -6.00300000E-05  +1.11650000E-04  +1.67520000E-04  -3.13230000E-04  -5.33650000E-04
   -4.61660000E-04  -2.93335000E-03  -4.11660000E-04  -3.28810000E-04  +1.26520000E-04
   -1.96990000E-04  -8.70200000E-05  -8.87700000E-05  -3.63460000E-04  +1.00980000E-04
   -1.64739800E-02  +1.12716400E-02  +6.87171000E-03  +1.87424500E-02  +6.26856200E-02
   +2.85000000E-06  +5.03500000E-05  +1.66420000E-04  -3.99800000E-05  -4.54130000E-04
   -1.56090000E-04  +1.75100000E-05  +2.13800000E-05  +8.87500000E-05  +8.88800000E-05
   -5.44200000E-05  -1.23630000E-04  -3.98480000E-04  -1.95480000E-04  -1.08820000E-04
   +1.58880000E-04  +1.32270000E-04  +6.27500000E-05  +1.34760000E-04  +4.32590000E-04
   -7.67670000E-04  +1.38120000E-04  +3.36500000E-05  -7.81100000E-05  +4.87740000E-04
   +2.07500000E-04  +5.87300000E-05  -1.44630000E-03  -2.44050000E-03  +2.85981000E-03
   -8.67110000E-04  -1.74610000E-04  -5.31190000E-04  -1.46850000E-04  -8.63620000E-04
   -4.27400000E-05  +2.41807000E-03  +1.73890000E-03  -3.86765000E-03  -1.23565000E-03
   +6.13960000E-04  +6.42090000E-04  +4.30810000E-04  -2.42790000E-04  +2.92850000E-04
   +8.43188000E-03  -1.10681000E-03  -8.29739000E-03  -1.90506000E-03  -1.44766700E-02
   +3.21373000E-02  +3.03041500E-02  +7.49848000E-03  -3.75414300E-02  -1.27512400E-02
   +3.45122000E-03  +2.66777000E-03  +1.36427800E-02  +4.15521000E-03  -2.75183800E-02
   -7.51500000E-05  -4.55200000E-05  -2.21900000E-05  +1.20800000E-05  +1.83500000E-05
   +2.96600000E-05  -6.19500000E-05  -1.33900000E-05  -1.15300000E-04  -2.34400000E-05
   -3.25200000E-05  +3.38000000E-06  +3.59100000E-05  +1.29000000E-05  -1.12700000E-05
   +8.75600000E-05  -1.01240000E-04  -3.57300000E-05  +8.00000000E-08  +1.07910000E-04
   +4.11500000E-05  -1.10380000E-04  +1.95900000E-05  -7.08100000E-05  +2.30400000E-05
   +4.25000000E-05  -8.18600000E-05  -2.16600000E-05  +3.10000000E-05  +8.58900000E-05
   +2.70100000E-05  -1.14920000E-04  -2.22550000E-04  -1.70030000E-04  +6.29020000E-04
   +4.28190000E-04  +2.34175000E-03  +1.64421000E-03  -2.04219000E-03  -3.54400000E-04
   +1.03470000E-04  +9.53900000E-05  +2.20800000E-05  +4.20410000E-04  -1.21420000E-04
   +7.96125000E-03  -3.67760000E-03  -3.70585100E-02  -4.93852000E-02  +8.86881000E-03
   +6.85472700E-02  -4.37000000E-06  +2.10000000E-06  +4.59800000E-05  -5.61000000E-06
   -9.36900000E-05  -1.84700000E-05  +1.39000000E-05  -1.23600000E-05  +8.08000000E-06
   +2.87700000E-05  -1.68900000E-05  -3.04900000E-05  -1.31600000E-04  -5.81800000E-05
   -3.25300000E-05  +3.53400000E-05  +3.12800000E-05  +3.00300000E-05  -2.65300000E-05
   +9.61600000E-05  -4.35900000E-05  +4.28400000E-05  -1.93100000E-05  -1.81600000E-05
   +1.54590000E-04  +6.17600000E-05  +2.41100000E-05  -2.57050000E-04  -6.52800000E-05
   +3.48660000E-04  -8.61000000E-06  -2.21600000E-05  -4.35800000E-05  +8.16100000E-05
   +1.34700000E-05  -1.09180000E-04  -2.02630000E-04  -2.74350000E-04  +1.12544000E-03
   -9.09200000E-05  +2.27940000E-04  -6.15270000E-04  +5.49100000E-05  -4.42500000E-05
   +3.66200000E-05  +4.89620000E-04  -3.63870000E-04  -4.65520000E-04  -8.64240000E-04
   +1.11900000E-04  +6.39870000E-04  +1.91717000E-03  +1.30565000E-03  -1.27407000E-03
   +1.28211000E-03  +1.05877000E-03  -2.53300000E-05  -4.42409240E-01  -1.87318840E-01
   +3.19111600E-02  -2.55300000E-05  -1.10400000E-05  -1.11400000E-05  +4.95000000E-06
   +9.35000000E-06  +6.91000000E-06  -1.72600000E-05  +9.10000000E-07  -3.09500000E-05
   -1.38800000E-05  +1.40000000E-07  +2.47000000E-06  +7.44000000E-06  +5.20000000E-06
   -4.79000000E-06  +2.10400000E-05  -2.54800000E-05  -5.00000000E-07  -1.69000000E-06
   +2.85500000E-05  -6.50000000E-07  -1.58200000E-05  +8.15000000E-06  -5.23000000E-06
   -1.16700000E-05  +1.26000000E-05  +9.70000000E-06  -2.72000000E-06  +2.66400000E-05
   +1.45800000E-05  +1.87100000E-05  -3.15900000E-05  -2.32900000E-05  +1.55100000E-05
   -1.71000000E-06  +2.25600000E-05  +8.91800000E-05  -5.17200000E-05  +1.92600000E-05
   +6.20900000E-05  +2.09500000E-05  -1.31200000E-05  +2.57500000E-05  +2.11700000E-05
   -1.41600000E-05  -1.50605700E-02  -9.14950000E-03  -1.53590000E-03  -1.05398400E-02
   -5.59886000E-03  +2.22569000E-03  +4.65344270E-01  +8.80000000E-07  -1.98000000E-06
   -4.80000000E-07  +1.67300000E-05  -9.50000000E-06  -2.00000000E-07  -2.03000000E-06
   -2.11000000E-06  +1.76000000E-06  -8.69000000E-06  -1.81000000E-06  +7.70000000E-06
   +3.18000000E-05  +1.46000000E-05  +5.18000000E-06  -4.99000000E-06  -7.07000000E-06
   -8.66000000E-06  +1.83400000E-05  +2.91300000E-05  +1.51400000E-05  +2.25400000E-05
   +1.14900000E-05  +5.60000000E-07  -3.64400000E-05  -1.91700000E-05  -5.06000000E-06
   +1.33100000E-05  -6.32900000E-05  -2.90500000E-05  +2.33900000E-05  +1.27000000E-06
   -5.99000000E-06  +2.08500000E-05  +1.56030000E-04  +1.19220000E-04  -1.55600000E-05
   -2.86900000E-04  -1.92140000E-04  +5.92000000E-05  -1.39420000E-04  -3.12700000E-05
   +1.99100000E-05  +7.97000000E-06  +1.44000000E-06  -2.65300000E-05  -5.79200000E-05
   -3.29460000E-04  -3.90760000E-04  -2.52710000E-04  +5.76010000E-04  +3.84702000E-03
   -2.96368000E-03  +2.97595000E-03  +2.27865000E-03  -2.39537000E-03  -2.28122000E-03
   -2.18797820E-01  -1.09975440E-01  +1.01891700E-02  +4.68000000E-06  +6.43000000E-06
   +1.45000000E-06  -3.20000000E-06  -1.80000000E-07  -3.64000000E-06  +1.97000000E-06
   +5.74000000E-06  +3.08000000E-06  +5.50000000E-06  +1.07000000E-06  -3.39000000E-06
   -1.66000000E-06  +1.33000000E-06  +2.40000000E-07  -5.83000000E-06  -2.01000000E-06
   +2.74000000E-06  -7.72000000E-06  -1.30000000E-05  -1.04000000E-06  +5.00000000E-07
   -1.63000000E-06  -1.86000000E-06  -3.75000000E-06  -3.61000000E-06  +5.09000000E-06
   -5.24000000E-06  -3.57000000E-06  -4.11000000E-06  -1.76000000E-06  +1.30000000E-07
   -1.36000000E-06  +4.10100000E-05  +2.96400000E-05  +3.13500000E-05  +1.16530000E-04
   +9.06000000E-05  +1.06110000E-04  -5.85000000E-06  +6.72000000E-06  +3.35000000E-06
   -2.25000000E-06  -1.08300000E-05  -9.09000000E-06  +1.03096600E-02  +7.11172000E-03
   +3.21195000E-03  +2.37121000E-03  +4.92784000E-03  -6.23942000E-03  +2.00116400E-01
   +1.03809510E-01  -3.09000000E-06  +1.30000000E-07  -9.13000000E-06  +2.50000000E-06
   +2.61200000E-05  -3.83000000E-06  -6.53000000E-06  +5.13000000E-06  +2.03000000E-06
   -7.89000000E-06  +3.94000000E-06  +5.88000000E-06  +2.85000000E-05  +1.26300000E-05
   +8.47000000E-06  -6.64000000E-06  -6.87000000E-06  -8.26000000E-06  -1.06000000E-06
   -3.09700000E-05  +2.21400000E-05  -1.34700000E-05  +5.66000000E-06  +3.25000000E-06
   -3.50600000E-05  -1.38700000E-05  -8.34000000E-06  +6.87300000E-05  +9.42100000E-05
   -6.63200000E-05  +6.28000000E-06  -9.26000000E-06  -4.30000000E-07  -6.89800000E-05
   +2.13610000E-04  +1.01850000E-04  -2.46600000E-05  -1.24674000E-03  +1.72275000E-03
   -7.42850000E-04  +3.33530000E-04  -6.75320000E-04  -9.68000000E-06  +1.09200000E-05
   -1.32200000E-05  -1.84140000E-04  +1.30340000E-04  +3.62930000E-04  +1.49935000E-03
   +1.98570000E-04  -1.44236000E-03  -5.90130000E-03  +5.69593000E-03  -3.91791000E-03
   +3.52192000E-03  -3.51665000E-03  -4.05759000E-03  +1.94662400E-02  +2.42539000E-03
   -4.65690200E-02  +5.10000000E-06  +2.14000000E-06  +4.89000000E-06  -3.52000000E-06
   -3.77000000E-06  -1.53000000E-06  +7.03000000E-06  -3.00000000E-07  +8.72000000E-06
   +4.07000000E-06  -1.08000000E-06  -1.48000000E-06  -7.70000000E-07  -1.84000000E-06
   +1.34000000E-06  -3.65000000E-06  +6.72000000E-06  +1.14000000E-06  +7.20000000E-07
   -5.03000000E-06  +6.26000000E-06  +5.80000000E-07  -4.84000000E-06  -1.70000000E-06
   +4.71000000E-06  +7.00000000E-08  -1.81000000E-06  -7.50000000E-07  -6.95000000E-06
   +2.48000000E-06  -4.46000000E-06  +6.48000000E-06  +7.17000000E-06  -3.08300000E-05
   -3.54500000E-05  +6.66000000E-06  +9.37400000E-05  -2.60540000E-04  -3.11300000E-05
   +3.43300000E-05  +2.03000000E-06  -2.66000000E-06  -5.91000000E-06  -2.67700000E-05
   -5.35000000E-06  +2.09187400E-02  +1.89125900E-02  +6.88068000E-03  -6.45210000E-03
   -1.48051700E-02  +1.06075500E-02  -3.21551800E-02  -8.11005000E-03  +3.70611900E-02
end_hess

