# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -882.08545700    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -5.00389715E+00  -3.05669742E-01  +2.42536064E+00
   006   -3.31089152E+00  +9.20525435E-01  +8.33810541E-01
   006   -3.87447328E+00  +9.75512012E-01  -1.73558447E+00
   006   -6.03511321E+00  -1.43048470E-01  -2.68828688E+00
   006   -7.70722618E+00  -1.35289934E+00  -1.06337098E+00
   006   -7.18084560E+00  -1.42684749E+00  +1.50327425E+00
   006   -9.11314716E-01  +2.23255753E+00  +1.78810351E+00
   006   -1.22671205E+00  +5.08865933E+00  +1.39909849E+00
   008   -9.85634167E+00  -2.48318303E+00  -1.87474385E+00
   006   +1.32246804E+00  +1.12156663E+00  +3.13053989E-01
   006   +1.65468325E+00  -1.59910308E+00  +6.79266027E-01
   006   +3.69216881E+00  -3.13678755E+00  +7.22070906E-01
   006   +6.43544780E+00  -2.81339221E+00  -6.10381891E-02
   008   +7.21755518E+00  -4.48573377E+00  -1.43900038E+00
   006   -4.15206398E-01  +1.77578404E+00  +4.61386539E+00
   006   +2.90530370E+00  +2.68053405E+00  -9.99888174E-01
   006   +4.99386212E+00  +1.56425232E+00  -2.16972172E+00
   008   +7.19641960E+00  +2.52324336E+00  -2.32921036E+00
   008   +7.58136095E+00  -8.11217340E-01  +6.46692030E-01
   001   -1.00008285E+01  -2.32253771E+00  -3.67029596E+00
   001   -6.41913148E+00  -7.74568038E-02  -4.69893313E+00
   001   -2.59515587E+00  +1.89990383E+00  -3.03913073E+00
   001   -4.64466118E+00  -4.07129137E-01  +4.43321801E+00
   001   -8.48570836E+00  -2.37241322E+00  +2.75918655E+00
   001   -2.92341995E+00  +5.70636557E+00  +2.38695865E+00
   001   +3.68710906E-01  +6.14166471E+00  +2.17076035E+00
   001   -1.44976390E+00  +5.58332120E+00  -5.87381676E-01
   001   -3.04834056E-01  -2.23926548E-01  +5.08196956E+00
   001   +1.37330318E+00  +2.64589721E+00  +5.14883315E+00
   001   -1.90520963E+00  +2.63595315E+00  +5.74613208E+00
   001   +2.82980868E+00  +4.70958523E+00  -8.00989711E-01
   001   +4.72690698E+00  -3.32947243E-01  -2.92519775E+00
   001   +3.29202707E+00  -5.08119968E+00  +1.23288823E+00
   001   -9.84924277E-02  -2.51429355E+00  +1.21337143E+00
   001   +8.15676099E+00  +9.80188384E-01  -1.35922526E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -1.90000000E-07  +1.00000000E-07  -4.50000000E-07
   +0.00000000E+00  +2.80000000E-07  -1.40000000E-07
   +1.80000000E-07  +7.40000000E-07  -1.70000000E-07
   +1.60000000E-07  +1.08000000E-06  -5.00000000E-07
   -1.10000000E-07  +9.70000000E-07  -7.80000000E-07
   -2.90000000E-07  +5.30000000E-07  -7.70000000E-07
   +8.00000000E-08  -2.10000000E-07  +1.90000000E-07
   +4.50000000E-07  -8.00000000E-08  +6.70000000E-07
   -1.70000000E-07  +1.39000000E-06  -1.13000000E-06
   +1.60000000E-07  -2.90000000E-07  +2.10000000E-07
   -2.70000000E-07  -2.80000000E-07  +2.00000000E-08
   -4.60000000E-07  -4.00000000E-07  -4.40000000E-07
   -2.50000000E-07  -9.90000000E-07  +1.60000000E-07
   -4.50000000E-07  -6.30000000E-07  -3.10000000E-07
   -1.80000000E-07  -6.90000000E-07  +2.40000000E-07
   +6.20000000E-07  -2.80000000E-07  +2.80000000E-07
   +6.10000000E-07  +1.30000000E-07  +8.90000000E-07
   -6.60000000E-07  -3.40000000E-07  +5.90000000E-07
   -1.80000000E-07  -7.60000000E-07  +4.00000000E-07
   +0.00000000E+00  +1.63000000E-06  -1.11000000E-06
   +3.00000000E-07  +1.43000000E-06  -5.10000000E-07
   +4.10000000E-07  +7.70000000E-07  +7.00000000E-08
   -3.80000000E-07  -1.70000000E-07  -4.20000000E-07
   -4.70000000E-07  +4.90000000E-07  -1.01000000E-06
   +4.30000000E-07  -4.00000000E-08  +6.70000000E-07
   +5.00000000E-07  -3.80000000E-07  +9.30000000E-07
   +5.80000000E-07  +2.50000000E-07  +7.20000000E-07
   -4.10000000E-07  -7.40000000E-07  -9.00000000E-08
   -1.30000000E-07  -9.60000000E-07  +4.70000000E-07
   -1.60000000E-07  -7.00000000E-07  +2.50000000E-07
   +6.00000000E-07  -1.90000000E-07  +9.40000000E-07
   +1.30000000E-07  +9.00000000E-08  +1.40000000E-07
   -6.50000000E-07  -5.70000000E-07  -6.40000000E-07
   -3.80000000E-07  -1.60000000E-07  -4.00000000E-07
   +5.90000000E-07  -1.04000000E-06  +1.03000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.54280810E-01  +2.28950040E-01  +2.85407510E-01  +5.36769400E-02  -5.98285000E-02
   +7.38313300E-01  -1.92649450E-01  -8.84727400E-02  +1.01790140E-01  +5.18086860E-01
   -8.01348800E-02  -1.24612190E-01  +7.99845000E-02  +1.94271550E-01  +3.08898990E-01
   +4.18708000E-02  +4.53390700E-02  -2.02916890E-01  +7.04631000E-03  -6.75389100E-02
   +6.52857420E-01  +4.46286000E-02  +1.89947300E-02  +1.15175400E-02  -1.20742980E-01
   -2.88612500E-02  -9.88731000E-03  +5.86723370E-01  +1.19702000E-02  +1.32337800E-02
   +1.48629600E-02  -1.96870600E-02  -8.54636100E-02  +2.91180800E-02  +2.54971810E-01
   +3.02865090E-01  +5.87055300E-02  +4.14861200E-02  -4.50423500E-02  -7.06478400E-02
   -4.99546000E-03  -3.10052450E-01  +1.26729500E-02  -7.12379800E-02  +6.86478180E-01
   -5.39449200E-02  -3.08700100E-02  +1.22342400E-02  +6.61635000E-03  +1.14525100E-02
   -7.95646200E-02  -2.67678510E-01  -1.15372000E-01  -4.23296900E-02  +5.59611950E-01
   -3.04260600E-02  -2.20677700E-02  +7.16647000E-03  +3.98429000E-03  +1.73726700E-02
   -4.32106300E-02  -1.06093610E-01  -1.20107400E-01  -1.04970600E-02  +2.43717440E-01
   +2.75880220E-01  +7.33081000E-03  +4.33010000E-03  -4.60011000E-03  -3.07023000E-02
   -1.59752400E-02  -7.15348000E-03  -1.03627560E-01  -4.57449900E-02  -1.59160070E-01
   +5.84741900E-02  -5.41312000E-02  +7.35280110E-01  +8.48557000E-03  +8.83529000E-03
   -3.49780800E-02  -2.22138000E-03  -1.57265000E-03  +2.20166200E-02  -4.12052200E-02
   -2.47141900E-02  -2.78899000E-03  -1.81904850E-01  -8.08682100E-02  +1.06079160E-01
   +5.75920130E-01  +1.67135000E-02  +1.41281400E-02  -1.93970400E-02  -1.06460000E-03
   -1.02786000E-02  +2.31655700E-02  -3.25167000E-02  -1.47371300E-02  -1.27782000E-02
   -7.01889300E-02  -1.22391240E-01  +8.39693700E-02  +2.32705490E-01  +3.08224500E-01
   -8.61677900E-02  -4.93705300E-02  -3.00741000E-03  +2.12026500E-02  +2.29634600E-02
   -7.72532500E-02  +4.90608900E-02  +1.69610400E-02  +7.75649300E-02  +3.34309500E-02
   +4.15958300E-02  -2.21918440E-01  +4.25134700E-02  -5.68164400E-02  +7.22281350E-01
   -2.68532310E-01  -1.05016860E-01  -9.96880400E-02  -3.77793100E-02  -3.24223200E-02
   +4.36205100E-02  -2.70447600E-02  -8.56813000E-03  -3.50454100E-02  +4.43915000E-02
   +1.94440200E-02  +1.16640800E-02  -1.17476070E-01  -2.81283900E-02  +8.57062000E-03
   +5.95327350E-01  -1.14408420E-01  -1.20468120E-01  -4.31681200E-02  -2.57806100E-02
   -9.94434000E-03  +1.65913900E-02  -9.12623000E-03  -6.15790000E-03  -1.34013800E-02
   +1.30804900E-02  +1.37408900E-02  +1.31739100E-02  -1.78601200E-02  -8.79394800E-02
   +4.17699600E-02  +2.67721790E-01  +2.96778020E-01  -3.82983000E-02  -7.31455000E-03
   -1.58543830E-01  -2.92799000E-03  -1.01467800E-02  +6.64780500E-02  -3.11683900E-02
   -1.14218800E-02  -4.71427500E-02  +5.17776900E-02  +3.65366900E-02  -3.48599000E-02
   -5.98787800E-02  +2.21098000E-03  -3.23491480E-01  +1.41325800E-02  -7.65277400E-02
   +7.01331580E-01  -1.84068700E-02  -1.08170600E-02  -6.47015000E-03  -1.37814370E-01
   -3.64183300E-02  -1.68024900E-02  -8.79137000E-03  -3.98061000E-03  -9.99031000E-03
   +5.00116000E-03  -8.99420000E-04  -6.82080000E-04  -1.93797000E-03  -7.84970000E-04
   +1.33925000E-03  +1.53180000E-03  -3.75670000E-03  +2.24949000E-03  +4.52630780E-01
   -1.22924600E-02  -4.55169000E-03  -4.38320000E-03  -4.05796900E-02  -8.96468700E-02
   -7.10475000E-03  -1.20150000E-04  +1.39305000E-03  -4.59075000E-03  -6.23490000E-04
   +4.41684000E-03  +2.27288000E-03  -2.63550000E-04  -7.16290000E-04  +1.05590000E-03
   -3.18816000E-03  +4.27490000E-03  +1.58848000E-03  -3.12230000E-03  +4.87564140E-01
   +1.13296200E-02  +6.76731000E-03  +1.22391100E-02  -2.77056900E-02  -1.20692100E-02
   -9.41225800E-02  -2.77512300E-02  -1.59235200E-02  -8.17938000E-03  -2.01240000E-04
   +1.60607000E-03  -5.01474000E-03  -1.80360000E-04  +1.36400000E-04  -1.46142000E-03
   +2.28075000E-03  +2.48188000E-03  -2.04656000E-03  +2.80245000E-03  -6.55088000E-03
   +4.71748910E-01  -7.37880000E-04  -7.59020000E-04  -2.05664000E-03  -9.93490000E-04
   -2.92949100E-02  +3.66886000E-03  -4.78870000E-04  -1.43877000E-03  -1.17180000E-04
   -1.23310000E-04  +2.72090000E-04  +6.28520000E-04  +7.71230000E-04  +2.04260000E-04
   +9.40840000E-04  -1.65638000E-03  +7.64030000E-04  -5.77960000E-04  -7.58236400E-02
   +6.23540000E-03  -1.22309000E-03  +5.86708910E-01  +1.43030000E-03  -7.06600000E-05
   -1.01094000E-03  -9.90759000E-03  -2.46689000E-02  -2.00595000E-03  +9.41450000E-04
   -4.06530000E-04  +7.08360000E-04  -3.69700000E-05  +2.61930000E-04  +6.18280000E-04
   +3.00000000E-06  +5.47500000E-05  +3.33680000E-04  -6.38320000E-04  +4.19240000E-04
   -2.90250000E-04  +1.31574000E-02  -1.72077540E-01  +1.52078500E-02  +1.71332900E-02
   +4.67278430E-01  +5.58110000E-04  -8.94600000E-05  -9.85520000E-04  +2.60180000E-04
   -1.05564100E-02  +1.81165000E-03  -1.34094000E-03  -1.21267000E-03  -1.01790000E-04
   +2.44810000E-04  +3.46850000E-04  +2.06240000E-04  +3.03320000E-04  -8.50900000E-05
   +7.29590000E-04  -6.43170000E-04  +1.71790000E-04  -6.56510000E-04  -9.16360000E-04
   +1.37894100E-02  -7.85037600E-02  -2.03388000E-03  +9.75691000E-03  +5.92889540E-01
   +3.27514000E-03  -1.06244000E-03  +2.01582000E-03  -3.86522000E-03  -5.42500000E-04
   -2.50212000E-03  +4.37012000E-03  -2.45534000E-03  +4.91226000E-03  -3.86302500E-02
   -2.63196200E-02  -1.39514300E-02  -2.43574670E-01  -1.10299160E-01  -3.40850400E-02
   -1.48873800E-02  -1.01516300E-02  -2.04365200E-02  +1.33786000E-03  +1.33600000E-04
   +7.24460000E-04  -1.34351000E-03  -8.11200000E-05  -6.36630000E-04  +3.29655060E-01
   -2.35126000E-03  +3.48288000E-03  +2.79847000E-03  -1.01173000E-03  -1.10966000E-03
   -2.68102000E-03  -1.31840000E-03  +5.83585000E-03  +5.29694000E-03  -3.14239400E-02
   -6.84299000E-03  -8.69812000E-03  -1.04261210E-01  -1.03774940E-01  -8.02827000E-03
   -5.17197000E-03  +5.70418000E-03  -7.19483000E-03  +1.07942000E-03  -4.85270000E-04
   +1.92140000E-04  -6.67170000E-04  -6.73200000E-05  -2.75890000E-04  +1.58813960E-01
   +1.22358650E-01  +8.52887000E-03  +6.78313000E-03  -6.15412000E-03  -3.27772000E-03
   -2.73990000E-03  +6.27188000E-03  -2.81422000E-03  +7.19760000E-04  -8.59707000E-03
   +2.02821800E-02  +1.12246300E-02  +1.39291200E-02  -7.95963300E-02  -3.41393100E-02
   -1.29113190E-01  -5.41709500E-02  -2.68886100E-02  -2.35420100E-02  +4.68800000E-04
   -3.27770000E-04  +6.72580000E-04  -7.16670000E-04  -6.79100000E-05  -3.94980000E-04
   +1.16017260E-01  -2.11230500E-02  +6.72359730E-01  -1.98047000E-03  -4.86800000E-04
   -8.33870000E-04  -3.60409500E-02  -5.26400000E-05  +1.07880000E-02  +3.95070000E-04
   +6.98090000E-04  -5.72380000E-04  -1.84290000E-04  -4.28030000E-04  +7.09400000E-04
   -8.97640000E-04  -4.07950000E-04  -1.49504000E-03  +9.87730000E-04  -3.50100000E-04
   +1.09201000E-03  -1.22171760E-01  +2.96547400E-02  +2.71438800E-02  -5.37714000E-03
   +8.67254000E-03  +2.48707000E-03  +1.35407000E-03  +7.53100000E-04  +7.59120000E-04
   +4.76077140E-01  -1.83778000E-03  -1.87564000E-03  -1.76611000E-03  -8.95632000E-03
   +6.21392000E-03  +1.05191800E-02  -6.22300000E-04  +4.27870000E-04  -1.61549000E-03
   +1.41530000E-04  -4.47650000E-04  -4.44700000E-05  +2.45000000E-05  +1.35340000E-04
   +3.40710000E-04  -3.87350000E-04  -1.24361000E-03  +2.07250000E-04  +1.73241800E-02
   -1.00081020E-01  -1.18281800E-02  +2.81668800E-02  -1.45088300E-02  -1.84417600E-02
   -3.55260000E-04  -2.18140000E-04  -1.71460000E-04  +7.13039100E-02  +5.83086090E-01
   -1.47837000E-03  -3.59820000E-04  -1.52534000E-03  -5.21300000E-04  +7.30309000E-03
   +6.38601000E-03  -2.83267000E-03  -1.18873000E-03  +7.07570000E-04  -3.75890000E-04
   -6.26660000E-04  -5.40780000E-04  +9.77700000E-04  +6.55750000E-04  +4.07000000E-04
   -9.84800000E-05  -5.97180000E-04  -2.68960000E-04  +3.25854500E-02  -1.87077000E-02
   -9.39727600E-02  -2.66709000E-03  -1.51776000E-03  +2.30005000E-03  -1.27685000E-03
   -6.02330000E-04  -6.92080000E-04  -1.90599350E-01  -1.12178680E-01  +3.60255260E-01
   +6.20270000E-04  +8.43610000E-04  -5.32800000E-04  -1.92979000E-03  +3.95371000E-03
   +1.19811000E-03  -7.06920000E-04  +2.60190000E-04  +1.42730000E-04  +1.97500000E-04
   -4.72000000E-06  +1.37710000E-04  +3.05030000E-04  +1.28990000E-04  +5.77370000E-04
   -4.30560000E-04  -6.33260000E-04  -5.68990000E-04  -4.85739000E-03  +2.49620300E-02
   -2.09885000E-03  -3.97285000E-03  +8.88950000E-04  +3.62819000E-03  -5.94840000E-04
   -3.65690000E-04  -3.01530000E-04  -1.04906900E-01  -1.41443100E-02  +1.35279200E-02
   +7.15484580E-01  -5.28330000E-04  -9.07990000E-04  +7.97530000E-04  +2.40682000E-03
   -2.64061000E-03  -1.75277000E-03  +7.00140000E-04  -5.02840000E-04  -8.32080000E-04
   -1.46360000E-04  +1.10660000E-04  -1.03620000E-04  -6.53330000E-04  -2.86380000E-04
   -7.70850000E-04  +4.16340000E-04  +3.65870000E-04  +6.57430000E-04  +1.66195500E-02
   -1.24975300E-02  +1.34525000E-03  +1.20183000E-03  +3.93320000E-04  -7.03710000E-04
   +9.39730000E-04  +5.29440000E-04  +5.09960000E-04  +2.61188700E-02  -2.05866700E-01
   +6.16908000E-03  -9.34250500E-02  +5.99739940E-01  +6.56870000E-04  +6.96480000E-04
   -3.44240000E-04  -1.25638000E-03  +2.84530000E-04  +8.63580000E-04  -7.22230000E-04
   +5.84570000E-04  +3.25890000E-04  +5.47720000E-04  +3.16410000E-04  +1.55970000E-04
   +1.00140000E-04  -1.31300000E-04  +5.88270000E-04  -3.31030000E-04  -1.40940000E-04
   -3.68850000E-04  +1.00182000E-03  -1.61740900E-02  +5.23946000E-03  +3.62781000E-03
   +1.55640000E-04  -1.32744000E-03  -1.64010000E-04  -4.35300000E-05  -1.02350000E-04
   +1.21333500E-02  +2.31560800E-02  -7.97985000E-02  -9.51576000E-02  -7.71997800E-02
   +1.77323590E-01  -1.46340000E-04  +6.06700000E-05  +1.26920000E-04  +1.24990000E-04
   -3.26310000E-04  -1.30272000E-03  +4.19620000E-04  +2.80220000E-04  +6.02290000E-04
   -2.90740000E-04  -2.32280000E-04  -3.63100000E-05  +1.55300000E-05  -6.49000000E-06
   -5.62180000E-04  +4.66720000E-04  +4.45820000E-04  +3.78030000E-04  +3.21955000E-03
   +5.14170000E-04  +1.20906000E-03  +5.58930000E-04  -2.48410000E-04  -1.59300000E-04
   +1.96900000E-04  +1.55410000E-04  +1.32960000E-04  +1.06186900E-02  +2.71768700E-02
   -4.95126000E-03  -3.45620400E-01  +1.42640770E-01  +8.17364000E-03  +6.31224790E-01
   +3.60050000E-04  +5.78500000E-04  -2.32610000E-04  -1.53250000E-03  +7.41570000E-04
   +2.98000000E-04  -3.28530000E-04  +2.91350000E-04  +3.57330000E-04  +7.70300000E-05
   +3.41100000E-05  +1.42490000E-04  +4.44670000E-04  +1.47020000E-04  +3.70380000E-04
   -1.31820000E-04  -1.51790000E-04  -3.42840000E-04  -2.62930000E-03  -4.27335000E-03
   +1.53230000E-03  +8.69130000E-04  -2.05700000E-05  -8.06330000E-04  -5.35350000E-04
   -2.89220000E-04  -2.64870000E-04  +2.22799100E-02  -3.14962600E-02  +7.18985000E-03
   +1.87765190E-01  -2.26349840E-01  +1.12586600E-02  -1.09053490E-01  +6.55979690E-01
   +1.06860000E-04  +7.60900000E-05  -3.70400000E-05  +1.71090000E-04  +1.11680000E-04
   +2.52000000E-04  -2.00410000E-04  -3.24400000E-05  -1.49300000E-04  +1.71190000E-04
   +1.13210000E-04  +2.54400000E-05  -2.11800000E-05  -2.25700000E-05  +2.14860000E-04
   -1.55180000E-04  -1.46960000E-04  -1.45740000E-04  +1.07374000E-03  +4.57580000E-04
   +4.34560000E-04  -2.04850000E-04  -6.41700000E-05  +2.54630000E-04  -5.09500000E-05
   -3.49600000E-05  -3.36500000E-05  -7.33336000E-03  -9.85728000E-03  +3.93160000E-03
   -8.30725000E-03  +2.92270700E-02  -5.83350200E-02  -6.72730500E-02  -8.35281900E-02
   +1.84787420E-01  -1.01710000E-04  -4.78050000E-04  +2.10310000E-04  +4.12280000E-04
   -1.90170000E-04  +4.19000000E-06  +7.63900000E-05  -3.02130000E-04  -4.54650000E-04
   +1.58340000E-04  +1.12750000E-04  -2.14340000E-04  -9.00210000E-04  -3.55390000E-04
   -3.76500000E-04  +5.45800000E-05  -8.84200000E-05  +2.96950000E-04  -5.36310000E-04
   -1.09377000E-03  +1.22430000E-03  +7.70620000E-04  -1.04510000E-04  -2.52450000E-04
   +9.43590000E-04  +4.23900000E-04  +4.27630000E-04  +2.89798000E-03  +1.49848800E-02
   -1.00204500E-02  -1.33822000E-03  -8.76460000E-04  +7.19613000E-03  -1.56184090E-01
   -1.86336100E-02  +1.39849200E-02  +5.23050200E-01  -1.90810000E-04  -1.66090000E-04
   -1.72430000E-04  +4.84660000E-04  +1.87580000E-04  +4.96930000E-04  -4.65500000E-05
   -2.09670000E-04  -2.56660000E-04  -1.49140000E-04  -1.32200000E-04  +8.48100000E-05
   +3.45430000E-04  +2.38390000E-04  +2.99530000E-04  -2.06750000E-04  -1.81600000E-04
   -1.63680000E-04  +5.58740000E-04  -1.17977000E-03  +5.23350000E-04  +1.48400000E-05
   -1.72400000E-04  +7.09300000E-05  -4.71650000E-04  -3.55970000E-04  -2.59040000E-04
   +7.17118000E-03  +2.18415800E-02  -9.75805000E-03  +2.67224500E-02  -3.39479000E-03
   -1.14669000E-03  -2.32336900E-02  -7.39155000E-02  +2.12948200E-02  +1.75905800E-02
   +7.74297160E-01  -2.61050000E-04  -7.33700000E-05  -1.19840000E-04  +5.65150000E-04
   +1.93900000E-05  +2.24850000E-04  +8.67800000E-05  -1.11380000E-04  +2.47100000E-05
   -2.16960000E-04  -1.53460000E-04  +2.79300000E-05  +4.16830000E-04  +2.44520000E-04
   +1.20550000E-04  -9.74000000E-06  +4.06200000E-05  -1.79700000E-05  +2.87890000E-04
   -4.77050000E-04  -1.05300000E-05  -7.49000000E-05  -6.58200000E-05  +7.32100000E-05
   -4.42000000E-04  -2.80270000E-04  -2.29970000E-04  +8.04270000E-04  +6.58031000E-03
   -9.08282000E-03  -1.03121000E-03  -1.47831400E-02  +7.60711000E-03  +9.06374000E-03
   +3.69503600E-02  -8.17352600E-02  -1.18767540E-01  +2.70193090E-01  +4.46629110E-01
   +1.54930000E-04  +3.87080000E-04  -2.22840000E-04  -4.24740000E-04  +3.74430000E-04
   +1.75500000E-04  -1.09860000E-04  +1.84790000E-04  +2.93950000E-04  -1.11980000E-04
   -9.47300000E-05  +1.81070000E-04  +7.01780000E-04  +2.95230000E-04  +3.87330000E-04
   -1.31120000E-04  -4.71900000E-05  -3.18410000E-04  +1.37800000E-04  +2.95900000E-05
   -4.53210000E-04  -4.15170000E-04  +5.34500000E-05  +1.41150000E-04  -7.87630000E-04
   -3.88840000E-04  -3.68120000E-04  -5.88060000E-04  -9.54466000E-03  +4.99072000E-03
   -9.66662000E-03  +2.84073000E-03  -2.07446000E-03  -2.31173200E-02  +2.78624600E-02
   +3.88399800E-02  -1.75277800E-01  +1.54197610E-01  +1.45637690E-01  +1.72751230E-01
   -3.53500000E-05  -1.85330000E-04  +2.07190000E-04  +1.36870000E-04  -3.73600000E-04
   -3.07800000E-04  +8.83200000E-05  -3.08000000E-05  -8.81700000E-05  +1.23970000E-04
   +1.24990000E-04  -1.29270000E-04  -5.26110000E-04  -2.66610000E-04  -3.44180000E-04
   +1.61210000E-04  +1.32640000E-04  +2.64030000E-04  -2.31930000E-04  +5.33670000E-04
   -1.27300000E-05  +1.97300000E-04  +5.74100000E-05  -1.12150000E-04  +6.34260000E-04
   +3.85700000E-04  +3.18600000E-04  -2.44101000E-03  -3.80619000E-03  +6.85070000E-04
   -1.39447000E-03  +5.27359000E-03  +5.67770000E-04  +1.66039500E-02  -4.91988000E-03
   -2.16380100E-02  +1.45886890E-01  -3.74820720E-01  -2.42620680E-01  -1.63315290E-01
   +4.48444940E-01  -1.46000000E-06  -1.92360000E-04  +1.62180000E-04  +9.12200000E-05
   -2.97910000E-04  -1.60330000E-04  +5.07200000E-05  -3.01300000E-05  -1.91410000E-04
   +1.16620000E-04  +1.26520000E-04  -7.95100000E-05  -4.46660000E-04  -2.12330000E-04
   -2.59770000E-04  +8.11000000E-05  +4.11700000E-05  +1.97900000E-04  -1.37710000E-04
   +1.98130000E-04  +9.79400000E-05  +1.75690000E-04  +3.23400000E-05  -8.98200000E-05
   +5.19170000E-04  +3.00020000E-04  +2.74490000E-04  -4.38210000E-04  +8.24650000E-04
   -1.59100000E-05  +5.33716000E-03  +4.37452000E-03  +3.87610000E-04  +3.17539500E-02
   -3.20240700E-02  -6.07556000E-03  +1.36224260E-01  -2.36931040E-01  -2.80507630E-01
   -1.64277190E-01  +3.26726750E-01  +2.96030170E-01  -1.32689000E-03  -4.95720000E-04
   -5.20580000E-04  -5.64791000E-03  +4.14820000E-03  -3.09383900E-02  -4.73760000E-03
   -2.92480000E-03  -2.25370000E-04  +7.42000000E-05  +1.50000000E-07  -1.47524000E-03
   +3.55220000E-04  +6.21000000E-05  +3.92900000E-05  +2.46020000E-04  +3.82340000E-04
   -9.46230000E-04  -7.69285300E-02  +3.52432000E-03  -8.46576000E-03  -2.20270000E-04
   +2.39103000E-03  -4.41440000E-03  -4.52700000E-04  -2.23550000E-04  -1.98370000E-04
   +5.48252000E-03  -5.21233000E-03  +2.52636200E-02  -1.61714000E-03  +1.50969000E-03
   +1.67118000E-03  +1.08556000E-03  -5.34620000E-04  +9.51600000E-05  +1.38180000E-04
   -3.19290000E-04  -1.80970000E-04  -2.13540000E-04  +2.14580000E-04  +1.17950000E-04
   +5.82387950E-01  -5.63470000E-04  -8.56300000E-04  -6.06250000E-04  -2.59108000E-03
   +2.29388000E-03  -1.58593900E-02  -3.16873000E-03  -1.23663000E-03  -9.42600000E-05
   -1.68920000E-04  +1.72280000E-04  -7.35990000E-04  +2.77600000E-05  +2.66000000E-04
   +1.57200000E-05  +9.85500000E-05  +4.51500000E-05  -4.55270000E-04  +3.56420000E-03
   -7.92388700E-02  +1.16545500E-02  +5.93032000E-03  -1.31330300E-02  +3.75240900E-02
   -2.10230000E-04  -1.40850000E-04  -8.61800000E-05  -5.36317000E-03  +3.35766000E-03
   -1.04938400E-02  +2.13515000E-03  -1.96679000E-03  -1.49256000E-03  -1.09461000E-03
   +6.15230000E-04  +3.52370000E-04  +5.81080000E-04  +7.07930000E-04  +9.66900000E-05
   -8.06100000E-05  -3.12520000E-04  -1.09190000E-04  +2.10250000E-03  +5.95127710E-01
   +1.09378000E-03  +8.59000000E-06  +5.67510000E-04  -7.87178000E-03  -2.72580000E-04
   -1.26034300E-02  -7.99900000E-04  -3.52300000E-05  +4.11960000E-04  +5.35190000E-04
   +2.48310000E-04  -3.46920000E-04  -3.26050000E-04  -1.37390000E-04  +2.41720000E-04
   +3.35030000E-04  +2.53910000E-04  -5.91490000E-04  -1.98505400E-02  +1.68620300E-02
   -1.65138060E-01  -2.93881000E-03  +9.30463000E-03  -1.22882500E-02  +2.70870000E-04
   +1.42020000E-04  +5.67000000E-05  +8.35653000E-03  -2.06172000E-03  -2.83877800E-02
   +2.08380000E-04  +3.70990000E-04  -8.71850000E-04  +7.30600000E-05  +3.42460000E-04
   -2.89470000E-04  -1.46050000E-04  -1.40410000E-04  +1.81610000E-04  +3.79900000E-05
   +8.85100000E-05  +6.67000000E-06  -2.47392000E-02  +1.21137200E-02  +4.64927040E-01
   -4.01160000E-04  +5.28700000E-05  -8.13270000E-04  -3.23460000E-04  +2.02913000E-03
   +1.32172000E-03  -6.28060000E-04  -2.18720000E-04  +5.29740000E-04  -3.37060000E-04
   -1.35720000E-04  +2.31750000E-04  +1.14491000E-03  +5.69930000E-04  +8.94150000E-04
   -4.34770000E-04  -3.85880000E-04  -6.03360000E-04  -1.27185000E-02  -1.11785000E-02
   +2.16722600E-02  -3.60287000E-03  -9.14030000E-04  +2.02129000E-03  -1.46002000E-03
   -7.96390000E-04  -7.51060000E-04  -1.85549310E-01  -8.54258100E-02  +1.18724770E-01
   +2.22240900E-02  -3.04843500E-02  +1.45233000E-03  -1.52029800E-02  +7.23301000E-03
   +7.09577000E-03  -1.32973700E-02  -1.94648800E-02  -6.50980000E-03  +5.40727000E-03
   +5.01064000E-03  +1.30938000E-03  -4.71727000E-03  +1.99116000E-03  -1.53215000E-03
   +5.26515580E-01  +2.34750000E-04  +5.48500000E-04  +1.06730000E-04  +7.53030000E-04
   -7.61570000E-04  -1.33940000E-03  +4.97700000E-05  -2.46910000E-04  +9.07450000E-04
   +1.68090000E-04  +1.58600000E-04  -2.62040000E-04  -1.99300000E-04  -9.16900000E-05
   +1.27600000E-05  +1.00610000E-04  +2.25650000E-04  -3.03500000E-05  +2.24411000E-03
   +1.16215800E-02  -6.95775000E-03  +1.85778000E-03  -3.73350000E-04  -1.55305000E-03
   +2.99760000E-04  +1.76570000E-04  +8.78600000E-05  -1.22966360E-01  -2.34876540E-01
   +1.10119060E-01  -1.79781800E-02  -1.98868600E-02  +2.07955400E-02  -9.70750000E-04
   +2.32651000E-03  +8.39000000E-06  -2.12257000E-03  -4.22475000E-03  -2.64674000E-03
   +1.18332000E-03  +1.26598000E-03  +1.66753000E-03  +2.72083000E-03  -1.07872000E-03
   -1.85189000E-03  +1.99508400E-02  +7.54384060E-01  +1.04356000E-03  -4.19860000E-04
   +1.53717000E-03  +9.30800000E-04  -3.01296000E-03  -4.44221000E-03  +7.32800000E-05
   +8.33380000E-04  -1.46979000E-03  +2.52270000E-04  +3.34440000E-04  +3.23020000E-04
   -1.13494000E-03  -6.12550000E-04  -9.52470000E-04  +4.27480000E-04  +5.39020000E-04
   +5.56090000E-04  +1.75286100E-02  +1.33769600E-02  -2.77964000E-03  +7.22920000E-04
   +6.34980000E-04  -2.02855000E-03  +1.41135000E-03  +6.70210000E-04  +7.96810000E-04
   +1.11420410E-01  +7.29047500E-02  -1.59079520E-01  -3.05519000E-03  +1.72530400E-02
   +5.08540000E-03  +4.97048000E-03  -5.08620000E-03  -4.29689000E-03  +1.08517100E-02
   +1.58181100E-02  +6.04346000E-03  -5.07330000E-03  -3.67959000E-03  -5.71150000E-04
   +1.94148000E-03  -1.45714000E-03  +1.03096000E-03  -2.55841210E-01  -7.29471000E-03
   +2.86085800E-01  +1.23820000E-04  -8.64720000E-04  +1.16126000E-03  +1.13706000E-03
   -1.81566000E-03  -2.10743000E-03  +5.13890000E-04  +9.88100000E-05  -3.78970000E-04
   +4.52460000E-04  +2.07530000E-04  -6.57610000E-04  -1.80620000E-03  -8.85590000E-04
   -1.44548000E-03  +8.11760000E-04  +5.75990000E-04  +9.68550000E-04  +2.16676000E-03
   +1.33363000E-03  +6.08292000E-03  +1.61952000E-03  -8.95700000E-05  -8.86340000E-04
   +2.30941000E-03  +1.22852000E-03  +1.11666000E-03  -5.85575900E-02  -4.27972300E-02
   +3.28734100E-02  -1.84411700E-02  +2.39853000E-02  -5.96006000E-03  +1.48381600E-02
   -7.25428000E-03  -7.17097000E-03  +2.60761700E-02  +3.99221300E-02  +1.47727700E-02
   -8.54992000E-03  -1.10690600E-02  -7.09660000E-03  +2.71790000E-04  -3.48210000E-04
   +1.83728000E-03  -1.91613920E-01  +9.96980100E-02  +6.51273700E-02  +7.66828050E-01
   -2.11410000E-04  -9.58000000E-06  -2.84890000E-04  +2.28420000E-04  +8.45460000E-04
   +6.93520000E-04  -2.03850000E-04  -1.55360000E-04  +5.54800000E-05  -8.13200000E-05
   -1.07560000E-04  +1.90800000E-05  +2.61140000E-04  +1.29540000E-04  +2.79320000E-04
   -1.59050000E-04  -1.72760000E-04  -1.71180000E-04  -2.47890000E-04  -4.31580000E-03
   +4.22350000E-03  +9.25290000E-04  -1.01211000E-03  -6.56690000E-04  -3.88290000E-04
   -2.40580000E-04  -2.18890000E-04  -1.24517500E-02  +2.60342500E-02  +6.88116000E-03
   +1.88176000E-03  -7.43558000E-03  +1.36002000E-03  -4.62423000E-03  -3.83640000E-04
   +2.54451000E-03  -2.97607000E-03  -1.91468900E-02  +8.72310000E-03  +2.16900000E-03
   +3.44994000E-03  -9.29900000E-05  -1.72644000E-03  +1.06041000E-03  -1.11500000E-04
   +8.85442200E-02  -1.83685340E-01  -5.98994900E-02  +6.77187900E-02  +6.28947640E-01
   +1.74270000E-04  +3.99900000E-05  +1.12170000E-04  +1.57359000E-03  +1.92980000E-04
   -1.20916000E-03  -3.67170000E-04  +4.01100000E-05  -1.49710000E-04  -9.98900000E-05
   -1.80100000E-05  +1.45810000E-04  +3.80680000E-04  +1.31900000E-04  +2.78640000E-04
   -1.22500000E-04  +6.14000000E-05  -2.36170000E-04  +5.96390000E-03  +2.29375000E-03
   +8.20340000E-03  -5.14080000E-04  -1.54300000E-04  +2.12620000E-04  -4.91800000E-04
   -2.70120000E-04  -2.50140000E-04  +2.34639500E-02  +7.17384000E-03  -1.63960600E-02
   -4.39210000E-04  -3.41746000E-03  -4.33319000E-03  +7.35100000E-05  +2.23619000E-03
   +1.63055000E-03  +8.10830000E-04  +1.14841400E-02  +1.77028000E-03  +1.04692000E-03
   -4.47085000E-03  -5.73469000E-03  -2.60023000E-03  +1.39995000E-03  +5.40610000E-04
   +8.44111000E-02  -6.28213800E-02  -1.18154630E-01  -1.11118910E-01  +1.64577150E-01
   +2.82183680E-01  -1.03780000E-04  +3.28660000E-04  -5.84020000E-04  +1.59730000E-04
   +1.00653000E-03  +8.52120000E-04  -2.14080000E-04  +3.23100000E-05  +9.53600000E-05
   -3.60190000E-04  -1.82200000E-04  +3.84260000E-04  +1.17572000E-03  +5.65640000E-04
   +7.65250000E-04  -4.14490000E-04  -2.56740000E-04  -5.19330000E-04  +1.36609000E-03
   -2.36678000E-03  +1.91489000E-03  -6.27680000E-04  -5.68510000E-04  +2.51980000E-04
   -1.43702000E-03  -7.47480000E-04  -6.74120000E-04  +1.48563400E-02  +3.29552600E-02
   -1.01390100E-02  +1.04146500E-02  -1.53598200E-02  +3.07145000E-03  -8.81231000E-03
   +4.28208000E-03  +8.20258000E-03  -1.62229000E-02  -2.37380100E-02  -1.72356500E-02
   +4.32747000E-03  +6.56654000E-03  +3.21894000E-03  -1.80562000E-03  +7.73980000E-04
   -4.59160000E-04  -8.02934300E-02  -2.04486200E-02  +3.25995800E-02  -3.97874840E-01
   -1.54570330E-01  -4.27299000E-03  +5.02951380E-01  +8.47500000E-05  +9.19100000E-05
   +6.66300000E-05  +4.84600000E-05  -8.29600000E-05  -3.44220000E-04  -7.49200000E-05
   +9.48000000E-05  +6.39000000E-05  +1.78200000E-05  +6.44700000E-05  +2.71400000E-05
   +8.68400000E-05  +3.27000000E-06  +5.51300000E-05  +3.68000000E-06  +7.14300000E-05
   -4.49700000E-05  +5.03670000E-04  +1.40792000E-03  +3.23500000E-05  -3.21580000E-04
   +4.45300000E-05  +1.20140000E-04  -7.85200000E-05  -8.20000000E-07  -3.25000000E-05
   +3.34073000E-03  -7.31830000E-03  -3.27690000E-03  -3.14403000E-03  +2.39464000E-03
   -6.07660000E-04  +2.19933000E-03  -2.58680000E-04  -2.10279000E-03  +9.96171000E-03
   +2.04943000E-02  +1.26748800E-02  +1.01480000E-03  -7.55279000E-03  -6.13214000E-03
   -2.37500000E-05  -2.51200000E-05  +5.27000000E-05  +9.62628000E-03  +3.14001100E-02
   -5.74769000E-03  -1.57584930E-01  -1.84080940E-01  +1.80685000E-03  +1.43781800E-01
   +3.08159830E-01  -7.02800000E-05  -3.76100000E-05  -5.60700000E-05  -5.86900000E-04
   -9.38400000E-05  +5.56630000E-04  +1.81890000E-04  -3.68200000E-05  -5.03000000E-06
   +4.16800000E-05  -5.94000000E-06  -4.71900000E-05  -1.86250000E-04  -5.70800000E-05
   -1.28190000E-04  +2.86900000E-05  -5.34000000E-05  +1.15950000E-04  -2.03268000E-03
   -9.96800000E-04  -3.48831000E-03  +1.61000000E-05  +3.11880000E-04  -5.56900000E-05
   +2.32400000E-04  +1.08540000E-04  +1.24010000E-04  -4.59490000E-04  -3.18682000E-03
   +7.48136000E-03  +5.84270000E-04  +1.77175000E-03  +1.07351000E-03  +1.15350000E-03
   +4.12120000E-04  +9.27100000E-04  -1.03723800E-02  -1.75899000E-02  -1.59961900E-02
   -3.39890000E-04  +8.12214000E-03  +8.35466000E-03  +1.06167000E-03  -5.80690000E-04
   -1.47930000E-04  +2.63384900E-02  +1.94403000E-03  +1.17124800E-02  +1.96288600E-02
   +1.36198000E-03  -6.68130000E-02  +2.12689000E-03  -6.83510900E-02  +1.00958100E-01
   +1.42700000E-05  +2.30120000E-04  -2.16870000E-04  -1.37620000E-04  +2.23380000E-04
   +3.15780000E-04  -7.62900000E-05  +1.08080000E-04  +1.45660000E-04  -1.08950000E-04
   -3.28800000E-05  +1.56250000E-04  +5.66450000E-04  +2.35970000E-04  +3.01840000E-04
   -1.19770000E-04  -1.12700000E-05  -1.90730000E-04  +2.24770000E-04  -1.14520000E-04
   -6.47250000E-04  -4.14520000E-04  -3.78000000E-05  +1.79000000E-04  -6.30320000E-04
   -2.87180000E-04  -2.79080000E-04  -7.58280000E-04  -3.84530000E-03  -7.62690000E-04
   -3.24831000E-03  +2.17294000E-03  -1.07056000E-03  -2.11769500E-02  -3.74389400E-02
   -7.12680000E-03  -1.91694530E-01  -1.54618790E-01  -3.50760400E-02  +3.85909700E-02
   -1.12763000E-03  -9.54698000E-03  -3.87040000E-04  +4.90000000E-07  +4.18000000E-06
   +1.21381000E-03  +3.16154000E-03  -2.09131000E-03  -2.08902400E-02  -1.44283000E-02
   +8.20961000E-03  +3.63804200E-02  -1.37023800E-02  +1.18012700E-02  +1.87974210E-01
   +7.79400000E-05  +8.31300000E-05  +1.85770000E-04  -2.13550000E-04  -3.13950000E-04
   -4.23210000E-04  +3.68700000E-05  +1.39190000E-04  +2.16470000E-04  +1.11260000E-04
   +1.12390000E-04  -1.03730000E-04  -2.17280000E-04  -1.69950000E-04  -2.35770000E-04
   +2.05140000E-04  +2.17590000E-04  +1.52940000E-04  -4.58070000E-04  +1.13723000E-03
   -8.49390000E-04  -1.23170000E-04  +1.81530000E-04  -3.44100000E-05  +3.40290000E-04
   +2.76400000E-04  +1.79370000E-04  -8.86422000E-03  -2.37601100E-02  +7.69759000E-03
   -1.29714500E-02  +9.18939000E-03  -1.81806000E-03  -1.34332600E-02  -1.74140600E-02
   -1.39871300E-02  -1.42961600E-01  -2.92120360E-01  -6.70116500E-02  -2.09117400E-02
   -8.09955400E-02  -6.20513400E-02  +3.58270000E-04  -6.84410000E-04  +2.87550000E-04
   +2.48884400E-02  +5.06893000E-03  -1.67326300E-02  -5.14623100E-02  -7.75731000E-03
   +6.16634000E-03  +5.77447800E-02  -5.43161800E-02  +5.76294100E-02  +1.81488030E-01
   +4.15093990E-01  +1.12600000E-05  +1.29200000E-05  -9.18200000E-05  +1.93100000E-05
   +7.88800000E-05  +1.81500000E-04  +1.66000000E-05  +3.48700000E-05  -1.01830000E-04
   -1.09300000E-05  +1.01300000E-05  +8.57900000E-05  +5.24500000E-05  +2.56800000E-05
   +5.09600000E-05  -7.42000000E-05  -6.34800000E-05  -1.69100000E-05  +3.51430000E-04
   -2.30070000E-04  +4.15440000E-04  -7.50800000E-05  -7.60900000E-05  +6.94000000E-05
   -7.90200000E-05  -3.95700000E-05  -1.20800000E-05  +3.95355000E-03  +8.11066000E-03
   -1.30727000E-03  +3.93778000E-03  -2.22182000E-03  -4.88380000E-04  +4.32647000E-03
   -3.94517000E-03  +1.75204700E-02  -4.22626700E-02  -8.95748800E-02  -1.11919860E-01
   -1.57465100E-02  -5.46774200E-02  -1.52190000E-03  -5.23760000E-04  +8.29000000E-05
   -1.82580000E-04  -9.56959000E-03  -4.62060000E-04  +6.42939000E-03  +2.21455100E-02
   +3.15439000E-03  -7.97833000E-03  -2.71645400E-02  +4.36609000E-02  -2.70691100E-02
   +5.95576000E-02  +1.24735710E-01  +1.41008280E-01  +1.37909000E-03  -5.87000000E-06
   -1.44602000E-03  +5.43800000E-05  -1.64600000E-04  +7.47290000E-04  -6.38160000E-04
   +6.79100000E-05  -3.42870000E-04  +1.61664000E-03  +1.69959000E-03  -1.32399000E-03
   -8.56827000E-03  +2.78124000E-03  -4.43544100E-02  -4.96271000E-03  -4.11033000E-03
   -7.79230000E-04  -1.47210000E-04  -4.52100000E-05  +9.92400000E-05  +6.66000000E-05
   +1.25000000E-05  -6.22000000E-06  -3.59464300E-02  -1.77035000E-02  -5.84530000E-03
   -1.37070000E-04  -9.24000000E-06  +5.24800000E-05  +2.50200000E-05  -4.81200000E-05
   +4.06400000E-05  -6.68000000E-06  +5.49100000E-05  +2.98000000E-06  -1.50360000E-04
   +1.98300000E-05  +3.96300000E-05  +1.09420000E-04  -5.56300000E-05  -4.14000000E-05
   +7.01200000E-05  +3.68600000E-05  -8.01000000E-06  +1.57810000E-04  -4.34600000E-05
   -9.81100000E-05  -2.93310000E-04  +1.29300000E-05  +6.25900000E-05  +1.95330000E-04
   +3.23000000E-05  -3.29600000E-05  +1.09450000E-04  -6.64000000E-06  +2.20100000E-05
   +4.80388800E-02  -1.66570000E-04  +1.70897000E-03  -4.31170000E-04  -1.00380000E-04
   -1.41300000E-05  +3.95560000E-04  +2.50300000E-05  -6.17550000E-04  -1.47220000E-04
   +8.76280000E-04  -2.26660000E-04  -1.63623000E-03  -2.92874000E-03  -1.33603000E-03
   -2.33673800E-02  -3.91653000E-03  +7.52600000E-05  -4.67250000E-04  +6.81000000E-06
   -8.56400000E-05  +8.07500000E-05  -2.81600000E-05  -1.28500000E-05  -3.50600000E-05
   -1.15126900E-02  -1.98066900E-02  +6.80525500E-02  -8.55500000E-05  +8.66800000E-05
   +2.34900000E-05  +6.29200000E-05  -7.99100000E-05  -8.45000000E-06  -4.43200000E-05
   +4.14500000E-05  +7.67000000E-06  -3.48700000E-05  +1.01920000E-04  +6.64600000E-05
   +4.66100000E-05  -7.97600000E-05  -5.74200000E-05  +3.78500000E-05  +2.90000000E-06
   -5.88000000E-06  +9.21500000E-05  -4.32500000E-05  -4.67200000E-05  -1.47260000E-04
   +4.58500000E-05  +3.38500000E-05  +8.82700000E-05  -2.14800000E-05  -2.86000000E-06
   +2.03000000E-05  -8.19000000E-05  +3.23000000E-06  +1.80653200E-02  +2.08704400E-02
   +8.34000000E-05  +3.85930000E-04  -8.75120000E-04  +3.38240000E-04  +5.45600000E-05
   +5.29210000E-04  -9.04100000E-05  +6.23200000E-05  -1.25138000E-03  +4.61278000E-03
   +1.79702000E-03  +5.23036000E-03  -1.66848000E-03  +1.24429000E-03  -1.86917000E-02
   -1.94816000E-03  -1.17062000E-03  +2.34168000E-03  -2.03820000E-04  +1.30200000E-05
   -1.11700000E-04  +1.55970000E-04  +1.39700000E-05  +8.44100000E-05  -5.21978100E-02
   +4.13752200E-02  -5.30164330E-01  -1.81310000E-04  +1.76400000E-05  +1.68890000E-04
   +6.51200000E-05  -1.14970000E-04  +1.94500000E-05  -1.81900000E-05  +6.42400000E-05
   +4.01000000E-06  -1.26140000E-04  +6.93400000E-05  +6.78200000E-05  +1.03400000E-04
   -8.46200000E-05  -8.04500000E-05  +5.00200000E-05  +1.97500000E-05  -2.53000000E-05
   +2.01330000E-04  -3.08400000E-05  -1.96440000E-04  -3.10200000E-04  +5.72400000E-05
   +8.01900000E-05  +1.90860000E-04  +1.21200000E-05  -4.15000000E-05  +7.90900000E-05
   -4.43800000E-05  +6.90000000E-07  +5.14368900E-02  -4.34781700E-02  +5.42908630E-01
   -1.43724000E-03  -3.43060000E-04  +2.18360000E-04  -2.01595000E-03  -5.29703000E-03
   -1.56271000E-03  -4.87880000E-04  +2.15547000E-03  -2.69819100E-02  -6.26315000E-02
   -9.71962000E-03  -4.97263100E-02  +6.74829000E-03  -1.28754000E-03  +1.89836500E-02
   -9.34680000E-04  -4.14275000E-03  +2.52345000E-03  +2.80810000E-04  +1.73450000E-04
   -1.15029000E-03  -8.50000000E-06  +1.35290000E-04  -2.80800000E-05  +1.50469000E-03
   +2.95652000E-03  +1.14432000E-03  +2.97380000E-04  -4.25500000E-05  -1.55940000E-04
   -4.97300000E-05  +5.75000000E-05  +3.14900000E-05  +1.69600000E-05  -1.13500000E-05
   +1.02000000E-06  +2.21300000E-05  -8.60300000E-05  -6.80600000E-05  -2.96000000E-05
   +5.62200000E-05  +6.39000000E-05  -3.79130000E-04  -1.70770000E-04  +7.11000000E-06
   -1.83850000E-04  +2.75200000E-05  +1.89100000E-04  +1.69990000E-04  -9.38600000E-05
   -1.03300000E-04  -1.04000000E-04  +1.06200000E-05  +4.67000000E-05  -1.57800000E-05
   +5.86100000E-05  +1.53500000E-05  -5.59970000E-04  -5.48110000E-04  -7.63410000E-04
   +6.00863900E-02  -3.48140000E-04  -1.05098000E-03  -1.05200000E-04  -5.14320000E-03
   +4.41590000E-03  +8.36600000E-05  -1.71798000E-03  +3.56358000E-03  -1.43259300E-02
   -9.64810000E-03  -4.11906600E-02  +1.30943400E-02  +2.77081000E-03  +3.83318000E-03
   +1.40735500E-02  -4.20067000E-03  +2.73143000E-03  +2.33934000E-03  -2.30520000E-04
   +5.26320000E-04  -5.15730000E-04  -3.73000000E-06  -1.79500000E-05  +2.17300000E-05
   +3.05315000E-03  -2.01640000E-03  -2.86920000E-04  +1.86320000E-04  +1.88600000E-05
   -1.65320000E-04  +2.46100000E-05  -4.54000000E-06  -1.22400000E-05  -2.01700000E-05
   -5.97000000E-06  +2.87000000E-06  +3.95900000E-05  +4.24200000E-05  +1.60900000E-05
   -1.97800000E-05  -1.54700000E-05  -1.22200000E-05  -1.83250000E-04  -1.70020000E-04
   -2.81100000E-05  -4.41200000E-05  -1.99800000E-05  +1.00670000E-04  +6.79800000E-05
   +1.86400000E-05  -4.64000000E-06  -4.67700000E-05  -2.67400000E-05  +1.48900000E-05
   -2.98400000E-05  -3.65800000E-05  -3.65000000E-06  -9.11810000E-04  +6.04300000E-05
   -3.10990000E-04  +1.34312400E-02  +3.31042700E-02  +6.56210000E-04  +1.76480000E-04
   +6.30050000E-04  -2.09958000E-03  -4.67950000E-04  +2.04109000E-03  -1.17300000E-05
   +1.43013000E-03  -7.43463000E-03  -5.00882800E-02  +1.30328800E-02  -3.27199710E-01
   -9.53978000E-03  -2.59797000E-03  -1.62367700E-02  +2.98913000E-03  +2.62323000E-03
   -6.69420000E-04  +1.75660000E-04  +2.77470000E-04  -4.07980000E-04  -7.00800000E-05
   +1.67000000E-05  -2.28900000E-05  +5.33530000E-04  -6.65630000E-04  +2.94404000E-03
   +2.17810000E-04  -6.49300000E-05  -1.21420000E-04  -4.58400000E-05  +7.61700000E-05
   -3.06000000E-06  +2.54500000E-05  -3.40100000E-05  -4.18000000E-06  +6.30300000E-05
   -6.17900000E-05  -5.11400000E-05  -5.70200000E-05  +5.83500000E-05  +5.24200000E-05
   -1.91440000E-04  -1.22450000E-04  +1.77600000E-05  -1.45900000E-04  +3.68600000E-05
   +1.38830000E-04  +2.06480000E-04  -5.35900000E-05  -6.25300000E-05  -1.27060000E-04
   -2.61000000E-06  +2.89000000E-05  -4.47000000E-05  +4.34100000E-05  -5.60000000E-07
   +1.75829000E-03  +1.18451000E-03  -5.16570000E-04  +5.59374100E-02  -1.39882300E-02
   +3.47166130E-01  +2.16751000E-03  -2.25829000E-03  -2.08767000E-03  +7.68641000E-03
   +2.70058000E-03  -4.08666000E-03  -1.62269680E-01  -8.69820200E-02  +1.08909320E-01
   -1.21197800E-02  -1.19705700E-02  +1.82478400E-02  -7.69900000E-04  -4.53968000E-03
   -3.56428000E-03  -4.90650000E-04  +5.50600000E-04  -6.94530000E-04  -8.12640000E-04
   +1.23579000E-03  +2.03650000E-04  -1.02110000E-04  -2.15410000E-04  -1.16150000E-04
   -1.26584000E-03  -7.75790000E-04  +7.70800000E-04  -8.02600000E-04  +7.47400000E-05
   -9.57520000E-04  +9.06700000E-05  -1.37270000E-04  +6.70100000E-05  -7.76800000E-05
   +4.91000000E-05  +3.73100000E-05  -8.79200000E-05  +1.01740000E-04  +5.80500000E-05
   +8.54300000E-05  -7.74300000E-05  -5.48900000E-05  -4.05800000E-05  +1.79780000E-04
   +3.96900000E-05  -2.49870000E-04  -1.22410000E-04  -1.18170000E-04  -5.63900000E-04
   +3.69300000E-05  +5.08000000E-05  +2.77520000E-04  +2.24400000E-05  -1.32500000E-05
   +9.19800000E-05  -9.45400000E-05  +4.28100000E-05  +1.43460000E-04  +6.43600000E-05
   +2.29060000E-04  -4.27540000E-04  +2.31448000E-03  +1.22070000E-04  +1.69116410E-01
   -2.08710000E-03  +5.18942000E-03  +6.71010000E-04  -8.38140000E-04  +3.46857000E-03
   +1.77680000E-04  -8.70296200E-02  -1.00901470E-01  +8.19187800E-02  -8.18784000E-03
   -2.05523000E-03  +9.73956000E-03  -4.63180000E-03  +5.44331000E-03  -9.31050000E-04
   +5.49280000E-04  -8.44430000E-04  -5.83930000E-04  +1.32042000E-03  -2.44919000E-03
   -4.86880000E-04  -1.41760000E-04  -1.26490000E-04  -4.81950000E-04  -6.50740000E-04
   -5.83240000E-04  +3.60840000E-04  +3.00440000E-04  +3.96820000E-04  +6.30800000E-04
   -8.22200000E-05  -1.18400000E-05  -1.63470000E-04  +1.03040000E-04  -1.27690000E-04
   -6.22600000E-05  +4.98900000E-05  -5.96000000E-06  +1.88100000E-05  -4.90400000E-05
   +3.03500000E-05  -1.33900000E-05  +2.22620000E-04  -9.69200000E-05  +1.54800000E-05
   -2.57670000E-04  +1.78500000E-05  -3.16340000E-04  +3.06530000E-04  +4.47900000E-05
   -9.05100000E-05  -1.85550000E-04  -9.19400000E-05  +6.37100000E-05  -8.88000000E-05
   +1.28100000E-05  -4.64400000E-05  +9.76800000E-05  +2.49900000E-05  +1.27320000E-04
   +2.27514000E-03  -3.07261000E-03  -6.83420000E-04  +9.92657700E-02  +9.71809800E-02
   -2.61398000E-03  +2.83090000E-04  -5.72167000E-03  +2.10398300E-02  +1.46315900E-02
   -1.34696100E-02  +1.08887290E-01  +8.24464500E-02  -1.73797480E-01  -8.69300000E-03
   -5.97041000E-03  +1.04660000E-02  -3.09454000E-03  -7.09680000E-04  +2.36020000E-04
   -8.77120000E-04  -6.40620000E-04  -3.33090000E-04  +1.23040000E-03  +3.37560000E-04
   +5.61820000E-04  -1.15130000E-04  +4.62600000E-05  -5.56350000E-04  -3.56490000E-04
   -2.95370000E-04  +4.13820000E-04  -5.80740000E-04  +2.67520000E-04  -5.74290000E-04
   +1.17950000E-04  +1.41190000E-04  -7.02400000E-05  -1.20240000E-04  -1.72800000E-05
   +2.14400000E-05  -4.45000000E-06  +2.56040000E-04  +1.20030000E-04  +5.56300000E-05
   -1.31500000E-04  -8.16700000E-05  -7.01000000E-05  -4.14300000E-05  +4.38800000E-05
   +2.79140000E-04  -3.22320000E-04  +1.62890000E-04  -6.78930000E-04  +1.41800000E-04
   +3.81400000E-04  +4.38240000E-04  +3.07000000E-06  -1.41240000E-04  +8.53000000E-05
   -2.28830000E-04  +6.58800000E-05  +2.37300000E-05  +7.10000000E-06  +5.03100000E-05
   +5.30490000E-04  -4.25020000E-04  +7.82220000E-04  -1.16480880E-01  -8.95358000E-02
   +1.81573240E-01  -6.30647400E-02  -6.10937000E-03  -4.93726500E-02  +8.88168000E-03
   -1.48660000E-04  +1.86117400E-02  -8.89860000E-04  -4.65214000E-03  +2.65155000E-03
   -1.33550000E-03  -1.45730000E-04  +2.17750000E-04  -1.65629000E-03  -5.42028000E-03
   -1.59985000E-03  -7.10870000E-04  +1.19531000E-03  -2.68814600E-02  -3.52820000E-04
   +1.92360000E-03  +8.85500000E-05  +3.79780000E-04  +8.69300000E-05  -1.23870000E-04
   -1.56860000E-04  +1.08580000E-04  -1.42910000E-03  -2.52090000E-04  -9.74900000E-05
   -2.33100000E-05  -7.86200000E-05  -6.92200000E-05  -8.19500000E-05  +3.05600000E-05
   +3.36500000E-05  -3.81500000E-05  -1.19800000E-04  +3.90700000E-05  +9.62900000E-05
   +7.46800000E-05  -5.01300000E-05  -6.16300000E-05  -1.67596000E-03  -1.36468000E-03
   +1.40600000E-04  +9.88900000E-05  +2.16300000E-05  -9.80500000E-05  -6.85700000E-05
   +2.18300000E-05  +9.23000000E-05  +8.38600000E-05  +3.06600000E-05  -5.98200000E-05
   +6.36100000E-05  +1.35100000E-05  -3.97600000E-05  -3.59120000E-04  -5.96600000E-05
   -1.53030000E-04  -1.29760000E-04  +3.31810000E-04  +1.88200000E-05  +3.22850000E-04
   -9.02600000E-05  +1.11618000E-03  +6.37084700E-02  -5.96832000E-03  -4.53477700E-02
   +1.68493700E-02  +3.26578000E-03  +3.87750000E-03  +1.39209700E-02  -4.78846000E-03
   +3.34796000E-03  +2.38039000E-03  +2.46000000E-05  -1.09998000E-03  -1.98850000E-04
   -5.49645000E-03  +4.98705000E-03  +1.83670000E-04  -2.99490000E-03  +4.58698000E-03
   -1.38852100E-02  +2.40256000E-03  -2.36959000E-03  -3.26150000E-04  -6.44100000E-04
   -2.62680000E-04  -1.11740000E-04  -2.08800000E-05  +8.09700000E-05  -7.16260000E-04
   +1.68600000E-04  +6.51010000E-04  +1.76310000E-04  +1.87790000E-04  -1.08950000E-04
   -2.37100000E-05  -1.69740000E-04  +2.54600000E-05  +3.53200000E-05  +8.86600000E-05
   +1.25890000E-04  +2.43100000E-05  -1.30900000E-05  -5.85400000E-05  -1.62900000E-05
   -1.03713000E-03  +1.36660000E-04  +2.41940000E-04  +2.17470000E-04  -1.34540000E-04
   -2.42300000E-04  -1.46080000E-04  +9.24500000E-05  +2.99700000E-05  +8.96600000E-05
   -4.14500000E-05  +1.87000000E-06  -2.61700000E-05  -1.22990000E-04  +6.05000000E-06
   -6.99500000E-05  -2.40910000E-04  -1.21180000E-04  +3.44070000E-04  -4.99290000E-04
   -7.50500000E-05  +1.50340000E-04  +1.05570000E-04  +7.95470000E-04  +1.25850600E-02
   +3.68004200E-02  -4.90961200E-02  +1.69268700E-02  -3.34192710E-01  -4.70806000E-03
   +1.60760000E-04  -1.46874300E-02  +2.70381000E-03  +2.70541000E-03  -7.97110000E-04
   +3.16750000E-04  -1.00910000E-04  +7.50570000E-04  -1.59582000E-03  +4.00100000E-05
   +1.86942000E-03  -1.49890000E-04  +1.57906000E-03  -7.14856000E-03  -8.83170000E-04
   -9.45630000E-04  -9.05130000E-04  +5.82500000E-05  -6.43800000E-05  +1.11500000E-05
   -2.71390000E-04  -4.58400000E-05  -7.06930000E-04  -4.40000000E-05  +2.15000000E-04
   -1.51100000E-05  +1.68150000E-04  -3.21500000E-05  +4.88600000E-05  -8.17300000E-05
   +7.00000000E-08  +4.03900000E-05  +6.24300000E-05  +6.37000000E-06  -5.15700000E-05
   -2.32600000E-05  +3.05000000E-06  +2.77100000E-05  -1.95127000E-03  -8.14780000E-04
   -1.09800000E-05  +1.86000000E-06  -6.15400000E-05  +1.51000000E-05  -3.48400000E-05
   +1.41100000E-05  -4.63600000E-05  +8.22000000E-06  -2.61300000E-05  +3.57000000E-05
   -2.17900000E-05  -3.97800000E-05  +3.38000000E-05  -6.17800000E-05  -6.34200000E-05
   +4.57000000E-06  -1.44600000E-05  -1.04780000E-04  -9.19400000E-05  -3.31130000E-04
   -4.99100000E-05  -8.02510000E-04  +5.70992300E-02  -1.75124700E-02  +3.55238390E-01
   -1.13521300E-02  -1.07188700E-02  +1.74892500E-02  -1.14752000E-03  -4.37242000E-03
   -3.24016000E-03  -4.03650000E-04  +4.99410000E-04  -7.54630000E-04  +1.69848000E-03
   -2.03588000E-03  -2.00894000E-03  +7.16124000E-03  +1.77629000E-03  -5.26858000E-03
   -1.67955420E-01  -9.34557100E-02  +1.11653630E-01  -1.72740000E-04  -3.94410000E-04
   +9.14880000E-04  -2.37730000E-04  -1.58900000E-05  -1.09220000E-04  -1.80420000E-04
   +1.84578000E-03  +7.03450000E-04  +5.88400000E-05  -2.47850000E-04  -1.54260000E-04
   -9.21900000E-05  +7.42700000E-05  +1.23600000E-05  +4.18300000E-05  -2.96300000E-05
   -1.09400000E-05  +6.26000000E-06  -5.55700000E-05  -2.40000000E-05  -2.38200000E-05
   +4.53100000E-05  +2.19600000E-05  -3.95000000E-06  +6.46200000E-05  +1.07590000E-04
   -9.47000000E-05  +7.28100000E-05  +1.13300000E-04  +1.04720000E-04  -4.30900000E-05
   -9.78000000E-06  -7.00000000E-05  +2.08800000E-05  -3.37000000E-06  -1.12200000E-05
   +5.64600000E-05  -1.30600000E-05  -1.09270000E-04  +2.35380000E-04  +1.39670000E-04
   +2.88340000E-04  +3.16990000E-04  -3.08520000E-04  -1.87960000E-04  +2.85540000E-04
   +1.26580000E-04  -4.64510000E-04  +2.34626000E-03  +1.82910000E-04  +1.73105150E-01
   -6.85982000E-03  -2.66964000E-03  +8.75586000E-03  -4.31949000E-03  +4.92841000E-03
   -8.93060000E-04  +5.71280000E-04  -6.68790000E-04  -3.76280000E-04  -1.96461000E-03
   +4.46592000E-03  +4.83580000E-04  -2.35299000E-03  +4.09548000E-03  -2.78100000E-04
   -9.32853300E-02  -1.02689400E-01  +8.51192800E-02  -4.86510000E-04  +1.68260000E-04
   +3.42160000E-04  -3.14500000E-05  +7.42900000E-05  +3.50700000E-05  +1.83797000E-03
   -2.37139000E-03  -4.47010000E-04  -5.43000000E-06  -1.30470000E-04  -1.87810000E-04
   -1.92400000E-05  +6.86000000E-05  -3.70000000E-05  +3.30100000E-05  -1.59400000E-05
   -5.67000000E-06  +4.27900000E-05  -1.87200000E-05  -2.37800000E-05  -3.31200000E-05
   +1.95500000E-05  +2.06200000E-05  +1.10280000E-04  -7.18900000E-05  +4.42600000E-05
   -1.25180000E-04  -4.90000000E-06  +2.00680000E-04  +1.98990000E-04  -3.81800000E-05
   -5.71000000E-06  -1.01600000E-04  -9.85000000E-06  +6.45000000E-06  -4.77600000E-05
   +9.58000000E-06  -8.84000000E-06  +2.46410000E-04  -3.98040000E-04  -6.36300000E-05
   +1.14710000E-04  -9.60900000E-05  -7.58100000E-05  +2.90380000E-04  -5.34400000E-04
   -3.32800000E-05  +2.28067000E-03  -3.14080000E-03  -7.07010000E-04  +1.03924000E-01
   +9.90024900E-02  -8.79907000E-03  -6.41668000E-03  +1.14530900E-02  -3.00811000E-03
   -7.19370000E-04  +5.05640000E-04  -1.16124000E-03  -7.16540000E-04  -7.20240000E-04
   -2.44274000E-03  +2.05180000E-04  -5.34892000E-03  +2.27800100E-02  +1.60248900E-02
   -1.31716200E-02  +1.10278490E-01  +8.42314400E-02  -1.70898910E-01  -4.79470000E-04
   -1.92030000E-04  +4.04560000E-04  -4.21200000E-05  +1.79100000E-05  -2.46000000E-05
   +4.67860000E-04  -5.77250000E-04  +2.22639000E-03  -3.30000000E-07  -8.68000000E-05
   -9.77900000E-05  -7.01000000E-06  +1.98000000E-05  -1.84600000E-05  +1.51700000E-05
   +4.84000000E-06  -4.19000000E-06  -6.44000000E-06  -2.90000000E-06  +4.90000000E-07
   +3.82000000E-06  -3.21000000E-06  -1.23000000E-06  +8.74400000E-05  +2.02200000E-05
   +3.73900000E-05  -3.40000000E-05  -7.27000000E-06  +9.04800000E-05  +4.87800000E-05
   -1.68800000E-05  +8.07000000E-06  -1.88900000E-05  +2.45000000E-06  -3.51000000E-06
   -5.04000000E-06  +3.53000000E-06  -4.77000000E-06  +4.32200000E-05  -1.19760000E-04
   +4.38350000E-04  +1.00171000E-03  +6.79330000E-04  -8.54530000E-04  +1.03770000E-04
   -4.62300000E-05  +2.62900000E-05  +6.56470000E-04  -4.31860000E-04  +7.94550000E-04
   -1.19473370E-01  -9.18612200E-02  +1.75219220E-01  +2.64740000E-04  +4.67900000E-05
   +1.58780000E-04  +6.85610000E-04  -1.04833000E-03  -9.46150000E-04  +3.80300000E-04
   +1.19800000E-05  +2.21040000E-04  -2.30200000E-04  +1.79000000E-05  +4.48200000E-05
   +7.32000000E-06  +7.51300000E-05  -1.22570000E-04  +5.49900000E-05  +1.02250000E-04
   -1.66000000E-05  -3.36653000E-03  +1.08990000E-04  +1.40622000E-03  -2.33935360E-01
   +6.64545100E-02  +1.09333300E-01  +2.70000000E-06  -3.16700000E-05  -1.32000000E-06
   +4.21920000E-04  -1.50960000E-04  -7.93600000E-05  -1.15570000E-04  -1.18720000E-04
   +1.33620000E-04  +1.55320000E-04  +7.31000000E-06  -3.65900000E-05  +9.18100000E-05
   -1.13950000E-04  -2.16300000E-05  -9.65200000E-05  +9.56500000E-05  +4.28400000E-05
   -1.71100000E-04  -4.38550000E-04  +3.42150000E-04  -1.53450000E-04  -1.56770000E-04
   +1.66230000E-04  +4.29330000E-04  +2.81310000E-04  +4.90000000E-07  -1.94310000E-04
   +2.16000000E-06  -1.89400000E-05  -8.04000000E-05  +1.03610000E-04  -6.13000000E-05
   -6.47000000E-06  +4.10000000E-07  +3.04000000E-06  +5.20000000E-07  +4.73000000E-06
   +4.12000000E-06  +4.87800000E-05  -5.85200000E-05  -2.77200000E-05  +3.03000000E-05
   +1.44000000E-05  +4.85000000E-06  +1.82600000E-05  +5.28000000E-06  +1.15900000E-05
   +2.50322270E-01  -2.00450000E-04  +1.51400000E-04  +1.00000000E-04  +1.46067000E-03
   +9.41540000E-04  -1.60180000E-04  -3.84180000E-04  +4.24500000E-05  -3.27400000E-04
   +2.87610000E-04  +1.08030000E-04  -1.01810000E-04  -2.65990000E-04  -2.21920000E-04
   +7.08000000E-05  -1.57550000E-04  -1.14530000E-04  +4.83400000E-05  +2.66604000E-02
   -1.23606400E-02  -1.59998500E-02  +6.37641700E-02  -6.76803000E-02  -3.73100600E-02
   +2.96590000E-04  +1.74140000E-04  +1.44950000E-04  -7.09230000E-04  -6.20881000E-03
   +2.05528000E-03  +1.67855000E-03  -4.56800000E-04  -1.19561000E-03  -1.53790000E-04
   -3.86140000E-04  +8.61900000E-05  -2.20380000E-04  +8.53000000E-06  +7.81700000E-05
   +1.13260000E-04  -6.44100000E-05  -7.76000000E-05  +3.31220000E-04  +9.34430000E-04
   -1.47772000E-03  -5.72440000E-04  -3.72450000E-04  +4.86100000E-05  -2.64750000E-04
   +4.17120000E-04  +1.72420000E-04  +2.70430000E-04  +3.26700000E-05  -1.20890000E-04
   +1.44370000E-04  +3.09900000E-05  +4.72000000E-06  -2.29000000E-05  -1.15800000E-05
   -4.08300000E-05  +1.74000000E-06  -7.00000000E-07  +1.25800000E-05  +6.83000000E-06
   +7.77000000E-06  +8.52800000E-05  +1.45700000E-05  -7.86400000E-05  +5.78100000E-05
   +6.34000000E-06  -4.44000000E-06  -1.26800000E-05  -7.14525900E-02  +7.81437400E-02
   -2.98640000E-04  -1.66430000E-04  +1.01760000E-04  +1.98420000E-04  +2.24300000E-05
   +3.80990000E-04  +9.61700000E-05  +2.26910000E-04  -5.26040000E-04  -2.36350000E-04
   -3.09900000E-05  +7.40500000E-05  -4.77100000E-05  -2.05900000E-05  -1.33260000E-04
   +3.69900000E-05  +4.66000000E-06  +7.96500000E-05  -3.98103000E-03  +1.47217000E-03
   +6.33250000E-04  +1.09258650E-01  -3.88659100E-02  -1.10815190E-01  +2.67400000E-05
   +2.19100000E-05  +3.45100000E-05  +7.66100000E-05  +1.07051000E-03  -1.59770000E-04
   +1.31000000E-05  +1.53300000E-04  +3.55920000E-04  -1.11100000E-04  +2.70000000E-06
   +2.60700000E-05  +4.50900000E-05  +1.61940000E-04  +6.07900000E-05  +9.45000000E-06
   -6.65300000E-05  -3.48500000E-05  -1.01118000E-03  +5.30300000E-04  +5.71670000E-04
   +4.92320000E-04  +1.22100000E-05  +2.68800000E-04  -4.67310000E-04  -8.28300000E-05
   +2.20820000E-04  +2.73020000E-04  -9.27000000E-06  +3.01500000E-05  +2.08500000E-05
   -1.63730000E-04  +5.53500000E-05  +3.97000000E-06  -1.58100000E-05  -9.95000000E-06
   +2.00800000E-05  -1.92600000E-05  -8.14000000E-06  +8.21900000E-05  -6.93300000E-05
   +1.63450000E-04  +2.85300000E-05  +2.31500000E-05  -3.01800000E-05  -1.10000000E-07
   -3.48000000E-06  +2.53000000E-06  -1.19088740E-01  +4.04424100E-02  +1.16940000E-01
   +5.87540000E-04  +1.07490000E-04  -2.49640000E-04  +3.91400000E-04  -3.57120000E-04
   -2.78210000E-04  +3.23260000E-04  -1.12480000E-04  +4.56390000E-04  -1.16350000E-04
   -5.94900000E-05  +6.65400000E-05  +2.54300000E-04  +1.48690000E-04  +9.23000000E-05
   -4.52800000E-05  -2.38500000E-05  -1.13820000E-04  +2.77108000E-03  +2.81534000E-03
   +1.96495000E-03  -2.09146480E-01  -1.03862250E-01  -7.89326100E-02  -2.67580000E-04
   -1.41430000E-04  -1.19690000E-04  -8.19600000E-05  -3.46860000E-04  +3.36080000E-04
   +2.09400000E-05  -4.66200000E-05  -2.19610000E-04  +2.55700000E-05  -1.49900000E-05
   +6.20000000E-07  -4.27200000E-05  +1.03600000E-05  +2.13000000E-05  +2.22500000E-05
   -1.45500000E-05  -1.99600000E-05  +4.63390000E-04  +4.91590000E-04  +7.94400000E-05
   -4.06210000E-04  +4.70010000E-04  +8.56860000E-04  -1.04640000E-04  +3.55180000E-04
   +8.58300000E-05  +1.58720000E-04  -1.04600000E-05  -5.20000000E-05  +4.53100000E-05
   -2.06800000E-05  +1.53200000E-05  +2.71400000E-05  +1.74200000E-05  +3.66200000E-05
   -2.47600000E-05  +3.64000000E-06  -1.49200000E-05  -4.86500000E-05  +4.14800000E-05
   +2.21000000E-06  -4.39900000E-05  +3.19200000E-05  +5.15100000E-05  -1.39600000E-05
   +2.30000000E-06  +9.60000000E-07  -1.90855200E-02  -1.32510100E-02  -1.12376300E-02
   +2.26601410E-01  -7.76300000E-05  -3.38980000E-04  -7.94330000E-04  +1.47022000E-03
   -5.53776000E-03  +1.59983000E-03  -1.53110000E-04  -2.79500000E-05  +3.85210000E-04
   -2.95330000E-04  +6.60700000E-05  +1.18300000E-04  +4.64500000E-04  +1.47390000E-04
   +3.51230000E-04  -5.98760000E-04  +1.96430000E-04  -2.53330000E-04  -2.52259400E-02
   -1.54051000E-02  -1.15240100E-02  -1.02506300E-01  -1.14008730E-01  -4.90524200E-02
   -6.41220000E-04  -3.34750000E-04  -3.35040000E-04  -1.20917000E-03  +4.08790000E-04
   +3.35710000E-04  +8.06400000E-05  -4.30100000E-05  +1.68330000E-04  +9.26900000E-05
   -4.18000000E-06  +1.12100000E-05  -3.13000000E-05  -2.27840000E-04  -7.17800000E-05
   -3.71600000E-05  +1.16950000E-04  +5.20600000E-05  -1.01267000E-03  +1.11710000E-03
   -1.45103000E-03  +1.90980000E-04  -4.98500000E-05  -1.28490000E-04  +3.59160000E-04
   +3.83130000E-04  -3.68300000E-05  -1.24850000E-04  -5.50000000E-07  +2.81000000E-06
   +5.70000000E-07  +1.91090000E-04  -3.16000000E-06  +3.54000000E-05  -8.54000000E-06
   +7.62400000E-05  -4.57800000E-05  -1.58100000E-05  -4.70300000E-05  +1.36110000E-04
   -3.54900000E-05  -1.42670000E-04  +6.95000000E-05  -1.96690000E-04  +4.63300000E-05
   -1.14400000E-04  +3.00000000E-06  -1.94600000E-05  +7.51938000E-03  +4.80151000E-03
   +4.52359000E-03  +1.13170170E-01  +1.24757250E-01  +5.33860000E-04  +1.45580000E-04
   -4.72000000E-05  -6.54060000E-04  +6.17460000E-04  +4.76390000E-04  -2.31850000E-04
   -3.26910000E-04  -2.19030000E-04  +6.00220000E-04  +3.08200000E-05  +2.24000000E-05
   -1.22720000E-04  -1.57140000E-04  +4.57220000E-04  -2.81880000E-04  -2.38800000E-04
   -2.19710000E-04  +3.92146000E-03  +2.98729000E-03  +1.17020000E-04  -7.84491900E-02
   -5.02610500E-02  -8.66991300E-02  +1.52000000E-05  +6.59300000E-05  -1.20000000E-07
   -6.19140000E-04  -4.93390000E-04  +2.90720000E-04  +1.12300000E-05  +5.46300000E-05
   -1.38520000E-04  +8.77300000E-05  -1.07000000E-06  -3.79900000E-05  +9.17000000E-06
   -1.12000000E-04  -2.42800000E-05  -3.66500000E-05  +6.68100000E-05  +2.22900000E-05
   +7.39940000E-04  +7.94880000E-04  +4.98050000E-04  -1.13400000E-04  -7.25200000E-04
   -1.73000000E-04  +2.14870000E-04  +4.09300000E-04  +6.47300000E-05  -5.38600000E-05
   +8.19900000E-05  -1.27020000E-04  -1.51300000E-05  +1.23980000E-04  -7.63400000E-05
   +1.45600000E-05  +1.01600000E-05  -5.30000000E-06  +1.31200000E-05  -7.38000000E-06
   -9.57000000E-06  -2.14380000E-04  +3.41910000E-04  +3.06480000E-04  +6.25000000E-06
   +4.80100000E-05  +3.11000000E-05  -1.90800000E-05  +4.04700000E-05  -1.96000000E-06
   +1.23563200E-02  +9.02598000E-03  +6.31565000E-03  +8.53354900E-02  +5.39118800E-02
   +8.96548100E-02  -1.22320000E-04  -9.27700000E-05  -1.93400000E-05  +1.59000000E-06
   +1.79800000E-05  +8.12180000E-04  -1.43720000E-04  -2.96450000E-04  -1.31190000E-04
   -2.14340000E-04  -1.18100000E-05  -1.11600000E-05  -4.51100000E-05  -1.85500000E-05
   -1.01200000E-04  +1.10720000E-04  +6.23000000E-06  +5.95300000E-05  -2.45911000E-03
   +5.63590000E-04  -3.34511000E-03  -4.99671900E-02  +6.06732000E-03  -2.83892100E-02
   +5.15700000E-05  +3.66400000E-05  +2.18000000E-05  +5.78890000E-04  +2.55470000E-04
   -1.02799000E-03  +1.44490000E-04  -6.19400000E-05  +4.91600000E-05  -1.05690000E-04
   -3.16700000E-05  +1.74800000E-05  -3.02600000E-05  +1.27080000E-04  +4.11700000E-05
   +4.88600000E-05  -7.28400000E-05  -2.53500000E-05  -1.28670000E-04  +1.09677000E-03
   +6.46400000E-05  -3.70090000E-04  +4.18380000E-04  +2.49210000E-04  -3.60270000E-04
   -2.27090000E-04  +8.25400000E-05  +2.39000000E-04  -3.48100000E-05  +4.82900000E-05
   +5.66000000E-05  -1.39320000E-04  +9.60500000E-05  -9.67000000E-06  -2.05500000E-05
   -8.71000000E-06  +2.26400000E-05  -2.29400000E-05  -2.49000000E-06  +2.09540000E-04
   -3.89560000E-04  -1.57100000E-04  +2.72000000E-06  +4.09900000E-05  -2.69500000E-05
   -1.63000000E-06  +1.04000000E-05  -1.11000000E-06  +3.70091000E-03  -6.93052000E-03
   +2.61839600E-02  -2.06554000E-03  +6.93249000E-03  -2.39917100E-02  +5.16014600E-02
   -6.84370000E-04  -1.61340000E-04  +1.27780000E-04  +1.29684000E-03  +1.34418000E-03
   +4.66020000E-04  -3.38770000E-04  -3.63530000E-04  +6.44770000E-04  -4.24670000E-04
   -6.36200000E-05  -3.68550000E-04  +7.19800000E-05  +1.28740000E-04  -4.91290000E-04
   +4.16650000E-04  +1.51950000E-04  +3.05840000E-04  +2.78872000E-03  -6.37067000E-03
   +3.09301200E-02  +5.43664000E-03  -6.20025900E-02  +5.77579200E-02  +1.53180000E-04
   +4.83800000E-05  +4.76100000E-05  -8.24600000E-04  +1.09933000E-03  +8.55580000E-04
   -3.25890000E-04  +1.28700000E-05  -2.13760000E-04  +1.15100000E-05  +6.62400000E-05
   -5.31000000E-06  -4.31700000E-05  -7.27700000E-05  +1.05300000E-05  +3.48000000E-06
   +2.46900000E-05  -7.69000000E-06  +4.28760000E-04  -6.73436000E-03  -8.05100000E-05
   +5.00250000E-04  +3.65650000E-04  -4.33020000E-04  +3.35830000E-04  +1.25730000E-04
   -1.48840000E-04  -2.01210000E-04  -4.00100000E-05  +4.62900000E-05  -2.14300000E-05
   +1.09690000E-04  -6.84000000E-05  -3.35600000E-05  -9.85000000E-06  -1.66700000E-05
   -2.04600000E-05  -1.81600000E-05  +1.55300000E-05  -5.04500000E-05  -9.26320000E-04
   -9.19480000E-04  +1.16920000E-04  +3.89700000E-05  -6.50400000E-05  +1.48000000E-05
   -2.57900000E-05  -1.30000000E-06  -1.83299000E-03  +1.68680000E-03  -9.36056000E-03
   -3.09300000E-04  +3.68620000E-03  -1.61296300E-02  -7.49676000E-03  +6.80531600E-02
   +3.33510000E-04  +2.02000000E-04  -1.27340000E-04  -5.34590000E-04  -1.31890000E-04
   +3.04940000E-04  -1.98510000E-04  -8.54900000E-04  -2.76650000E-04  +3.96420000E-04
   +2.59500000E-05  +1.05870000E-04  -1.31810000E-04  -1.71500000E-05  +2.53980000E-04
   -1.95330000E-04  -1.34850000E-04  -7.30400000E-05  -4.42800000E-04  -2.06420000E-04
   -3.18633000E-03  -2.84590700E-02  +6.00529700E-02  -3.00000380E-01  +5.01400000E-05
   +3.59500000E-05  +3.05000000E-05  +1.01727000E-03  +7.09000000E-05  -2.44850000E-04
   -1.05090000E-04  +9.74400000E-05  +2.07370000E-04  -1.80100000E-05  +1.92000000E-06
   +3.11700000E-05  +4.27600000E-05  +4.04400000E-05  -2.96300000E-05  -1.67600000E-05
   -2.55000000E-06  +2.75600000E-05  +1.05300000E-04  +1.84156000E-03  +6.53650000E-04
   +8.56460000E-04  -4.61400000E-05  +4.85210000E-04  -3.42600000E-04  -3.84550000E-04
   +3.73800000E-05  +7.36700000E-05  -2.29600000E-05  +1.69140000E-04  -6.73000000E-06
   -8.81000000E-05  +8.76700000E-05  +6.44000000E-06  +1.13100000E-05  -7.14000000E-06
   +2.88700000E-05  -1.25700000E-05  +3.96000000E-06  -3.08980000E-04  -5.96220000E-04
   +4.95400000E-05  -6.85600000E-05  -5.77500000E-05  +5.15000000E-05  +4.33000000E-06
   +1.30400000E-05  -1.68000000E-06  -2.74476000E-03  +3.20932000E-03  -1.38818400E-02
   +4.26580000E-04  +2.45317000E-03  -9.68773000E-03  +3.04466000E-02  -6.48687800E-02
   +3.25117130E-01  -2.93150000E-04  +2.15120000E-04  -7.67860000E-04  +3.67220000E-04
   +5.76410000E-04  +2.96740000E-04  -8.29500000E-05  -5.72700000E-05  -6.47300000E-05
   +1.45980000E-04  +6.59100000E-05  +9.24800000E-05  -7.97500000E-05  -5.66900000E-05
   +4.17500000E-05  -9.40300000E-05  -1.73140000E-04  +1.92880000E-04  -2.34044000E-03
   +5.44691000E-03  -5.76070000E-04  -2.27100000E-04  +2.63400000E-05  -1.40079000E-03
   +1.07710000E-04  +5.45600000E-05  +9.39700000E-05  +3.95100000E-05  -1.06324000E-03
   +2.94400000E-04  -2.78100000E-05  +4.60640000E-04  +4.35640000E-04  -2.16070000E-04
   +8.61600000E-05  -6.28000000E-06  -1.63280000E-04  +4.82300000E-05  +8.50100000E-05
   +9.59000000E-05  -5.81200000E-05  -7.66800000E-05  -4.77247600E-02  +1.34215300E-02
   -3.09678000E-03  +8.17200000E-05  +6.17100000E-05  +4.39000000E-06  -2.86800000E-05
   -7.14000000E-06  +9.43400000E-05  +5.42900000E-05  +7.84100000E-05  -7.72700000E-05
   +5.36000000E-05  +5.59500000E-05  -1.20550000E-04  -1.17900000E-05  -4.19000000E-06
   -1.04300000E-05  +1.22500000E-05  +2.61000000E-06  +1.54300000E-05  -6.50000000E-06
   +1.11000000E-06  +8.14300000E-05  -1.97276000E-03  +7.76500000E-05  -2.42030000E-04
   -1.94100000E-05  +1.64700000E-05  -1.53400000E-05  +2.94740000E-04  -3.80570000E-04
   -2.93000000E-06  +1.55110000E-04  +3.27260000E-04  +7.42700000E-05  +5.87200000E-04
   +4.82670000E-04  -1.34640000E-04  +4.94184600E-02  -7.90390000E-04  +9.20300000E-05
   +4.42570000E-04  -6.02910000E-04  +7.74300000E-05  -1.39750000E-04  +1.60580000E-04
   +1.68800000E-04  +1.25220000E-04  -2.61600000E-05  -1.00100000E-05  -6.89200000E-05
   -3.43300000E-05  -1.14390000E-04  -3.14700000E-05  +1.40820000E-04  +1.75140000E-04
   -2.89910000E-04  +3.23000000E-05  -3.42349000E-03  +3.51740000E-04  +6.60800000E-05
   +6.65350000E-04  +1.76194000E-03  +3.80700000E-05  +3.21200000E-05  -3.40000000E-05
   +6.80280000E-04  -3.28610000E-04  +1.38800000E-04  +5.46510000E-04  -4.56410000E-04
   -1.48203000E-03  -1.39180000E-04  +1.35740000E-04  -3.58480000E-04  -3.10940000E-04
   -2.17440000E-04  +1.56610000E-04  +1.31430000E-04  +5.42300000E-05  -2.00700000E-05
   +1.35478400E-02  -3.07245310E-01  +5.84128300E-02  -3.37760000E-04  +3.00000000E-08
   +2.42560000E-04  +2.86720000E-04  -1.94670000E-04  -1.81240000E-04  -1.86210000E-04
   +1.41840000E-04  +1.74000000E-06  +1.14690000E-04  +3.37650000E-04  -1.52800000E-04
   -5.15000000E-06  -9.07000000E-06  -7.18000000E-06  +2.35700000E-05  -8.43000000E-06
   +3.29000000E-06  +3.14000000E-06  -3.63000000E-06  -7.70000000E-05  -1.67190000E-04
   +7.17200000E-05  -5.50650000E-04  -2.65000000E-06  +4.20300000E-05  +2.49300000E-05
   -1.52360000E-04  +1.80120000E-04  -1.55150000E-04  +1.12660000E-04  +3.48800000E-04
   -1.83060000E-04  +9.87300000E-05  -2.73920000E-04  +1.15240000E-04  -1.45044100E-02
   +3.32852950E-01  -1.83250000E-04  -1.43210000E-04  +1.55620000E-04  +7.39670000E-04
   +1.66230000E-04  +1.57092000E-03  +1.45600000E-04  -2.18050000E-04  -2.91020000E-04
   +1.97560000E-04  +1.05620000E-04  +6.55800000E-05  -9.77700000E-05  -6.97000000E-05
   +2.14600000E-04  -1.90390000E-04  -1.70250000E-04  -8.93200000E-05  -8.65950000E-04
   +3.06510500E-02  -5.52981000E-03  -6.72260000E-04  -7.89500000E-05  -6.51085000E-03
   +2.74700000E-05  +9.82000000E-06  -3.79000000E-06  -8.46930000E-04  +1.13975000E-03
   +9.21150000E-04  +8.85850000E-04  +2.17380000E-04  -9.16610000E-04  -4.47000000E-05
   -5.10960000E-04  +1.31430000E-04  +5.91280000E-04  +3.35040000E-04  -1.16540000E-04
   -3.17760000E-04  +7.15000000E-06  +1.09590000E-04  -2.70221000E-03  +5.57174900E-02
   -6.08722500E-02  +3.28790000E-04  -1.17960000E-04  -1.21100000E-05  -2.77980000E-04
   +1.06700000E-04  +1.17100000E-05  +1.31600000E-04  -1.64030000E-04  +6.15700000E-05
   -2.88660000E-04  -4.24320000E-04  +1.11650000E-04  -1.09700000E-05  +4.97000000E-06
   -5.00000000E-06  -1.29100000E-05  +3.50100000E-05  +1.19000000E-06  -1.39600000E-05
   +6.13500000E-05  +7.45500000E-05  -5.24180000E-04  -5.40300000E-05  +9.38600000E-05
   -2.41100000E-05  +1.10400000E-05  -4.91000000E-06  -2.04870000E-04  -5.98100000E-05
   +3.40800000E-05  +2.05610000E-04  -1.46500000E-04  +8.77000000E-06  -3.69820000E-04
   +2.08112000E-03  -2.76510000E-04  +4.05741000E-03  -6.22626400E-02  +6.67864700E-02
   -1.97600000E-05  -2.02970000E-04  +3.05480000E-04  +7.97930000E-04  +1.39910000E-04
   -4.54180000E-04  -1.38800000E-05  -2.13960000E-04  +1.89850000E-04  -9.18800000E-05
   +3.19700000E-05  -1.29780000E-04  +1.03860000E-04  +6.84200000E-05  +2.13700000E-05
   +1.22370000E-04  +4.73700000E-05  -2.12570000E-04  -3.92831000E-03  -1.71191000E-03
   -2.46680000E-04  -1.40940000E-04  -2.89200000E-04  +4.41970000E-04  -1.52280000E-04
   -7.13800000E-05  -1.02660000E-04  +3.30640000E-04  +6.18560000E-04  +5.58470000E-04
   +2.91750000E-04  -3.57460000E-04  -1.04470000E-04  -1.31300000E-04  +2.00600000E-05
   -8.08500000E-05  -4.22800000E-05  -3.82000000E-06  +5.13000000E-06  +3.95900000E-05
   -2.09700000E-05  -1.57400000E-05  -2.52804630E-01  -1.00333130E-01  -5.89354700E-02
   +3.04400000E-04  -3.84800000E-05  -2.20940000E-04  -4.96300000E-05  +4.14700000E-05
   -1.02590000E-04  +5.19900000E-05  +1.81000000E-05  +1.13700000E-05  +3.73000000E-05
   +7.91000000E-06  -3.56800000E-05  +1.64500000E-05  +9.60000000E-06  +1.81400000E-05
   -4.21900000E-05  +9.48000000E-06  -1.40800000E-05  +5.78600000E-05  +2.81000000E-06
   -7.37100000E-05  +8.99300000E-05  +3.15910000E-04  -3.22410000E-04  -1.02000000E-06
   -1.26900000E-05  +7.39000000E-06  +3.69100000E-05  -1.10520000E-04  -5.04400000E-05
   +2.50460000E-04  +6.62270000E-04  -2.23410000E-04  +3.47630000E-04  +1.77790000E-04
   +1.43550000E-04  +2.44630000E-03  +1.76746000E-03  +1.25347000E-03  +2.70642260E-01
   -3.16520000E-04  +7.86200000E-05  +3.00370000E-04  -3.48200000E-05  -7.78000000E-06
   +1.00543000E-03  +2.02710000E-04  +4.17380000E-04  +2.38290000E-04  -8.59300000E-05
   -8.54900000E-05  +1.86400000E-05  +8.14600000E-05  +1.10700000E-05  -5.12600000E-05
   +6.13600000E-05  +1.74140000E-04  -8.72800000E-05  +4.97918000E-03  +5.38180000E-04
   +9.94850000E-04  +1.16418000E-03  +6.65590000E-04  +4.00690000E-04  -7.46900000E-05
   -4.26600000E-05  -5.94800000E-05  -4.74520000E-04  +4.29710000E-04  -4.53150000E-04
   -4.02360000E-04  -2.78150000E-04  +2.14630000E-04  +2.97490000E-04  -6.52400000E-05
   +2.01900000E-05  -9.86700000E-05  -2.67830000E-04  -9.03000000E-05  -8.23000000E-06
   +1.25550000E-04  +8.20400000E-05  -1.00590590E-01  -9.70668200E-02  -2.88670500E-02
   +1.97200000E-04  +4.19300000E-05  -3.97900000E-05  -4.22800000E-05  +1.27600000E-05
   -9.97100000E-05  +4.43100000E-05  -7.14800000E-05  +6.55100000E-05  +7.23000000E-05
   +1.26990000E-04  +2.42060000E-04  +8.18000000E-06  +1.50000000E-07  +8.91000000E-06
   +3.58900000E-05  -3.80800000E-05  -3.80000000E-06  -1.05000000E-06  +3.75500000E-05
   -3.55100000E-05  +1.71080000E-04  -2.71910000E-04  -3.66890000E-04  -1.38100000E-05
   +2.34700000E-05  +1.00500000E-05  +6.01200000E-05  -1.64500000E-05  +6.60700000E-05
   -6.75100000E-05  -1.91790000E-04  +4.48520000E-04  -4.57000000E-05  +1.11900000E-05
   -1.65590000E-04  -2.79157000E-02  -1.18348200E-02  -8.12739000E-03  +1.09943510E-01
   +1.01190330E-01  +8.42110000E-04  +5.38410000E-04  -6.27400000E-04  +8.43990000E-04
   +2.12810000E-03  -6.07886000E-03  -1.85147000E-03  -9.47960000E-04  -8.15100000E-05
   -9.50000000E-06  -1.58000000E-06  -4.67710000E-04  +2.46420000E-04  +1.36290000E-04
   +1.29900000E-05  -1.78390000E-04  -1.06100000E-04  +2.52280000E-04  -2.77322300E-02
   -1.39472600E-02  -1.02895800E-02  -3.13220000E-04  -1.51803000E-03  +9.41130000E-04
   -2.12300000E-04  -1.19010000E-04  -2.78400000E-05  -1.88202000E-03  -7.79550000E-04
   +2.39560000E-04  -1.24000000E-06  +7.74900000E-05  +5.24500000E-05  +1.39850000E-04
   -1.15420000E-04  +5.63000000E-06  -4.79000000E-05  -2.86320000E-04  -8.51000000E-05
   -5.02400000E-05  +1.53460000E-04  +7.98500000E-05  -5.69551400E-02  -2.77596100E-02
   -6.27431600E-02  -1.35930000E-04  +2.26590000E-04  +4.56780000E-04  +5.23390000E-04
   -9.19600000E-05  -3.49770000E-04  -3.06740000E-04  -1.85000000E-06  +1.31340000E-04
   -3.73800000E-05  +2.73930000E-04  -1.99200000E-05  +3.60500000E-05  +1.55800000E-05
   +2.70900000E-05  -1.40190000E-04  -9.44700000E-05  -7.50500000E-05  +7.12000000E-06
   +5.10900000E-05  +1.57000000E-05  +7.03100000E-05  -1.28110000E-04  +4.87840000E-04
   -4.45700000E-05  -8.59000000E-06  -1.19800000E-05  +1.08100000E-04  +9.93300000E-05
   -1.59500000E-05  +2.00490000E-04  +8.29520000E-04  +6.81200000E-05  +3.78500000E-04
   -8.66900000E-05  +1.60060000E-04  +6.74933000E-03  +2.40386000E-03  +1.29379000E-03
   +6.46142500E-02  +3.00719300E-02  +7.21147600E-02  -4.15990000E-04  -8.11930000E-04
   -1.75030000E-04  +2.46310000E-04  -2.59310000E-04  +3.13180000E-04  +5.71400000E-05
   +8.72900000E-05  -6.23400000E-05  +1.18330000E-04  +7.92500000E-05  +1.76200000E-05
   -1.96510000E-04  -3.88900000E-05  +6.74100000E-05  -1.01800000E-05  +6.89100000E-05
   -1.47480000E-04  +4.31576000E-03  -2.60619000E-03  -4.43502000E-03  +3.76990000E-04
   -1.11630000E-04  -4.69310000E-04  +1.26780000E-04  +6.04500000E-05  +3.06400000E-05
   -4.43460000E-04  +3.42760000E-04  -7.95880000E-04  +8.56400000E-05  -2.30480000E-04
   +1.39700000E-04  +6.82500000E-05  -9.21600000E-05  +3.05000000E-06  +7.64900000E-05
   -1.38150000E-04  -1.01040000E-04  -7.40500000E-05  +9.48800000E-05  +7.38500000E-05
   -1.90094180E-01  +8.32780600E-02  +1.07086220E-01  +5.55020000E-04  +7.93200000E-05
   +9.80200000E-05  +2.72670000E-04  +4.63000000E-05  +9.16000000E-06  -6.04000000E-05
   -3.00900000E-05  -2.98000000E-06  -4.61100000E-05  +6.58300000E-05  +8.70800000E-05
   -1.60700000E-05  -6.93000000E-06  -1.54700000E-05  +1.74400000E-05  +1.68800000E-05
   +1.37200000E-05  +2.74000000E-06  -1.05400000E-05  +2.29800000E-05  -5.33590000E-04
   -9.68010000E-04  -7.87500000E-04  +3.70600000E-05  -3.58600000E-05  -6.50000000E-07
   +2.60620000E-04  -1.14690000E-04  +8.67000000E-06  -2.08270000E-04  +3.15600000E-05
   +1.64570000E-04  +1.39190000E-04  -2.24880000E-04  -1.24000000E-04  -7.95380000E-04
   -8.39450000E-04  -5.27120000E-04  -1.86021400E-02  +1.28569300E-02  +1.51127900E-02
   +2.04824540E-01  +1.66100000E-04  +2.79220000E-04  -9.14420000E-04  +3.63370000E-04
   +1.85400000E-05  -3.09610000E-04  -1.67070000E-04  -1.09200000E-04  +1.99100000E-05
   +2.80800000E-05  +7.72000000E-06  +7.50500000E-05  +3.07000000E-05  -1.73000000E-06
   -8.40600000E-05  -8.72200000E-05  -7.47900000E-05  +4.04440000E-04  -3.83816000E-03
   +1.03508000E-03  +4.37399000E-03  -6.14320000E-04  +4.22320000E-04  +9.68590000E-04
   +6.36200000E-05  +2.55900000E-05  +1.02930000E-04  +1.03069000E-03  -4.44940000E-04
   +5.94120000E-04  +2.42160000E-04  -2.12580000E-04  -5.47410000E-04  -2.62310000E-04
   +2.21910000E-04  -1.77160000E-04  -4.43710000E-04  -2.70100000E-04  +8.87000000E-05
   +2.13440000E-04  +3.50500000E-05  -5.05500000E-05  +8.26611100E-02  -9.55043600E-02
   -6.19858500E-02  -7.57190000E-04  +2.23530000E-04  +3.64260000E-04  +3.45330000E-04
   -2.77330000E-04  -4.05920000E-04  -2.68550000E-04  +7.41000000E-05  +1.35870000E-04
   +1.72410000E-04  +3.74400000E-04  -1.17290000E-04  -1.27000000E-06  -2.24000000E-06
   -3.57000000E-06  -2.64000000E-06  -2.71000000E-06  +1.14000000E-05  -6.36000000E-06
   -1.37000000E-05  +7.45900000E-05  -7.04780000E-04  -9.68870000E-04  -2.07630000E-04
   -1.70800000E-05  +2.41000000E-06  -2.08600000E-05  +2.46280000E-04  +1.95800000E-05
   +5.07820000E-04  -1.67750000E-04  -3.80200000E-05  -7.87100000E-05  -1.17500000E-04
   +5.31500000E-05  -1.89260000E-04  +2.27542600E-02  -1.10347300E-02  -1.74779500E-02
   -1.05302400E-02  +6.11112000E-03  +8.83566000E-03  -9.06130700E-02  +9.99824100E-02
   -1.04850000E-04  +2.53560000E-04  -1.17460000E-04  +5.95690000E-04  +2.19700000E-05
   +1.41730000E-03  -2.45860000E-04  +1.68000000E-04  -2.12800000E-04  +2.10070000E-04
   +1.26960000E-04  +1.08960000E-04  -1.07990000E-04  -1.24880000E-04  +1.67150000E-04
   -2.99620000E-04  -1.04910000E-04  +1.51850000E-04  +2.38885300E-02  -1.33615600E-02
   -2.00248200E-02  +9.57140000E-04  -1.33998000E-03  +1.06005000E-03  +1.08400000E-04
   +5.93400000E-05  +7.29100000E-05  -3.64567000E-03  +2.41261000E-03  -4.81481000E-03
   +4.10470000E-04  -5.29600000E-05  -2.85100000E-05  -3.58630000E-04  +1.04370000E-04
   +2.31960000E-04  +8.86400000E-05  +3.00560000E-04  +7.44900000E-05  +5.14600000E-05
   -1.69370000E-04  -8.39500000E-05  +1.05755860E-01  -6.06884100E-02  -1.24268650E-01
   +1.68273000E-03  -1.00812000E-03  -1.00689000E-03  -4.53760000E-04  +7.97200000E-04
   +9.49490000E-04  +8.16960000E-04  -6.60900000E-05  -3.64780000E-04  +1.36920000E-04
   -3.23880000E-04  +2.10940000E-04  -9.17000000E-06  -1.41300000E-05  -1.63800000E-05
   +2.92800000E-05  -2.62700000E-05  +1.09000000E-06  +6.34700000E-05  -6.14600000E-05
   +9.17300000E-05  -4.76430000E-04  -7.60350000E-04  +1.40550000E-04  -2.46000000E-06
   -2.54900000E-05  -2.23800000E-05  -6.37100000E-04  +8.82910000E-04  -1.59650000E-04
   -3.69400000E-05  +1.47670000E-04  -5.07100000E-05  -3.09760000E-04  -1.89580000E-04
   +4.25550000E-04  -6.24281000E-03  +2.71104000E-03  +3.97165000E-03  -6.28037000E-03
   +4.43156000E-03  +4.64158000E-03  -1.15406310E-01  +6.57441400E-02  +1.37766990E-01
   -1.44700000E-05  +1.82030000E-04  -1.10710000E-04  -4.21640000E-04  +2.90480000E-04
   +1.71710000E-04  -1.13030000E-04  -6.04000000E-06  +2.73310000E-04  +7.66000000E-06
   +6.16000000E-05  -3.81300000E-05  +4.50000000E-06  -1.28100000E-05  +7.81300000E-05
   -1.08100000E-05  -5.04100000E-05  -5.64400000E-05  -7.74040000E-04  -5.70170000E-04
   -2.12916000E-03  -1.36894000E-03  -4.22680000E-04  +9.54800000E-04  -1.59800000E-05
   -1.08000000E-06  -2.83700000E-05  +8.01740000E-03  -1.73589800E-02  -5.01636000E-03
   +2.35946000E-03  -1.23365000E-03  +5.67944000E-03  -1.73911000E-03  -4.30800000E-04
   +4.18900000E-04  -1.05583000E-03  -1.33459000E-03  +4.89260000E-04  +6.65000000E-04
   +3.15060000E-04  -2.43340000E-04  +2.48910000E-04  +3.25330000E-04  -2.87530000E-04
   -5.77581500E-02  +1.13326700E-02  +1.20176000E-02  +9.25534000E-03  +2.68687000E-02
   +2.36282000E-03  -1.19192000E-03  -2.89366000E-03  -1.46052000E-03  +4.11300000E-04
   +1.70341000E-03  -7.25640000E-04  -3.27000000E-06  -1.20300000E-05  +4.42000000E-06
   -3.12000000E-06  -1.54200000E-05  -3.72000000E-06  +7.56700000E-05  -1.08370000E-04
   -5.10400000E-05  +3.66000000E-06  -6.08000000E-06  -6.13000000E-06  +9.57000000E-06
   -2.25700000E-05  -1.04900000E-05  +2.12350000E-04  +1.22660000E-04  -2.65250000E-04
   -2.80590000E-04  +6.50590000E-04  +9.66510000E-04  -1.78929000E-03  +5.16010000E-04
   -3.00200000E-05  +2.08300000E-05  +6.55300000E-05  -1.47590000E-04  +5.49500000E-05
   -4.90800000E-05  -2.37200000E-05  -7.50500000E-05  -2.74000000E-05  +3.31500000E-05
   +4.64617700E-02  -3.18200000E-05  -1.72300000E-05  +9.13000000E-06  +1.98790000E-04
   -2.94700000E-05  +5.95900000E-05  -1.31500000E-05  -4.93000000E-06  +3.29000000E-05
   +1.80000000E-05  +1.93100000E-05  -4.18600000E-05  -3.39100000E-05  -2.16500000E-05
   -3.15800000E-05  +2.11400000E-05  +2.92500000E-05  +4.28800000E-05  +1.22266000E-03
   -1.18462000E-03  -4.01760000E-04  +2.20390000E-03  +1.78990000E-04  -9.84760000E-04
   +5.97200000E-05  +3.23200000E-05  +2.51200000E-05  +2.05250000E-04  -1.44844700E-02
   -8.52580000E-04  -2.50555000E-03  +1.14268000E-03  +4.31000000E-05  +4.03070000E-04
   -3.04290000E-04  -5.84000000E-06  -1.09770000E-04  -1.21740000E-04  -3.61000000E-05
   -7.49100000E-05  +4.22200000E-05  +8.11700000E-05  -1.22490000E-04  -8.69400000E-05
   +6.79400000E-05  +1.24804000E-02  -3.42245140E-01  -2.93020200E-02  -1.94862000E-03
   -9.67342000E-03  -1.27094000E-03  +1.18810000E-04  +1.41715000E-03  +2.42660000E-04
   +1.42610000E-04  +3.60060000E-04  -5.79600000E-05  -6.67000000E-06  -4.79000000E-06
   -7.12000000E-06  +2.13000000E-06  -1.84000000E-06  +4.96000000E-06  -3.06100000E-05
   -2.62500000E-05  -3.66100000E-05  +4.90000000E-06  -1.45600000E-05  -3.35000000E-06
   +1.08000000E-06  +2.83000000E-06  -1.40000000E-06  +3.63500000E-04  +3.23860000E-04
   -3.10050000E-04  +9.02950000E-04  +1.43650000E-04  -5.28210000E-04  +3.38280000E-04
   +5.65600000E-05  -4.57600000E-04  +2.49100000E-05  +2.26500000E-05  -2.85100000E-05
   -2.77800000E-05  -5.90000000E-06  +1.08930000E-04  +8.96000000E-06  +2.69100000E-05
   +2.63500000E-05  -1.54069500E-02  +3.65119470E-01  -1.05360000E-04  +1.05090000E-04
   -2.80460000E-04  -5.15940000E-04  +2.32590000E-04  +8.23570000E-04  -1.85100000E-04
   -1.52270000E-04  +2.87450000E-04  +7.80000000E-06  +1.54900000E-05  -4.39900000E-05
   +1.46010000E-04  +8.64600000E-05  +2.22120000E-04  -1.19060000E-04  -1.09980000E-04
   -1.48290000E-04  -2.68919000E-03  -5.62830000E-04  -3.18122000E-03  +1.44749000E-03
   +4.30270000E-04  +5.09010000E-04  -2.26500000E-04  -1.18890000E-04  -1.45280000E-04
   +1.90589000E-03  +2.04059100E-02  +2.07377000E-03  +7.91477000E-03  +2.89070000E-04
   +3.22386000E-03  -1.46281000E-03  -4.53490000E-04  +3.78080000E-04  -6.56780000E-04
   -1.77538000E-03  -5.63570000E-04  +4.02890000E-04  +4.82850000E-04  +4.08230000E-04
   +7.55500000E-04  -5.41700000E-05  -4.95870000E-04  +1.83713000E-03  -3.32012300E-02
   -3.44464900E-02  +8.76557000E-03  -1.84494300E-02  -1.50506000E-03  -4.70340000E-03
   +2.43297000E-03  -2.41693000E-03  +3.03970000E-04  +2.55923000E-03  -9.74030000E-04
   +1.05100000E-05  +4.44000000E-06  +3.45300000E-05  -3.26400000E-05  -2.21300000E-05
   -2.46500000E-05  -2.52000000E-06  -5.83200000E-05  -1.11600000E-05  +1.75900000E-05
   +3.86200000E-05  -3.24000000E-06  -2.03200000E-05  -3.20100000E-05  -1.60200000E-05
   -3.73520000E-04  -2.22100000E-05  -3.98170000E-04  +9.49540000E-04  -1.01026000E-03
   -1.05787000E-03  -4.31790000E-04  +1.56000000E-05  -9.45500000E-05  -5.15700000E-05
   -6.33300000E-05  +5.54300000E-05  -5.25800000E-05  -3.51000000E-06  -1.22080000E-04
   -1.04470000E-04  +1.79900000E-05  -1.71190000E-04  -1.62763300E-02  +3.31577700E-02
   +3.61423100E-02  -2.76800000E-05  +6.20000000E-06  -6.11700000E-05  +3.43000000E-06
   +3.18700000E-05  +1.75130000E-04  -2.76600000E-05  -7.70100000E-05  +2.21500000E-05
   +6.90000000E-06  -1.71500000E-05  -1.97500000E-05  +2.97000000E-06  +8.83000000E-06
   +4.98400000E-05  -2.80000000E-05  -2.94200000E-05  -3.58600000E-05  -1.77110000E-04
   -1.53240000E-04  -1.66060000E-04  -1.11820000E-04  +7.11400000E-05  +1.36400000E-04
   -3.45600000E-05  -2.59100000E-05  -2.90500000E-05  -8.85020000E-04  +9.40070000E-04
   -4.56920000E-04  -1.04732000E-03  +1.07659000E-03  +8.23960000E-04  +8.96250000E-04
   -1.05277000E-03  +1.05050000E-04  +4.75420000E-04  -1.85450000E-04  -5.36775000E-03
   -8.67020000E-04  +7.57260000E-04  +2.17367000E-03  -9.03700000E-05  +1.26770000E-04
   -8.85900000E-05  +5.86742000E-03  +2.13893500E-02  +1.07748000E-02  -6.03358900E-02
   -1.59809000E-02  -1.82591000E-03  -1.29965500E-02  -3.85156800E-02  -1.24549700E-02
   -2.27226000E-03  +2.58373000E-03  -2.11037000E-03  -6.81000000E-06  +4.69000000E-06
   +6.20000000E-06  -1.93200000E-05  +5.78000000E-06  -7.77000000E-06  -6.14000000E-06
   +5.74400000E-05  +2.09800000E-05  +3.99000000E-06  +1.73000000E-05  -1.25000000E-06
   -7.06000000E-06  -5.99000000E-06  -4.37000000E-06  -1.11220000E-04  -5.86400000E-05
   +6.08000000E-06  -8.52400000E-05  -1.04980000E-04  -1.05190000E-04  +6.07200000E-05
   +1.90000000E-06  +2.49200000E-05  -1.28600000E-05  -4.19900000E-05  +1.98100000E-05
   +3.00000000E-06  +1.07400000E-05  -3.35100000E-05  +1.27000000E-06  -1.32400000E-05
   +4.13900000E-05  -2.22739000E-03  +1.21687000E-03  +3.22129000E-03  +7.35532800E-02
   +2.10800000E-05  -7.60000000E-06  +4.16400000E-05  +2.50800000E-05  -4.33100000E-05
   -7.72200000E-05  +5.61600000E-05  +5.61300000E-05  -5.29600000E-05  -1.12700000E-05
   -2.21000000E-06  +1.80700000E-05  +5.95000000E-06  +2.29000000E-06  -2.32700000E-05
   +7.99000000E-06  +1.02400000E-05  +1.85300000E-05  +3.09970000E-04  +4.29300000E-05
   +8.87200000E-05  -3.70200000E-05  +1.19400000E-05  -8.98200000E-05  +7.34000000E-06
   +4.16000000E-06  +1.38600000E-05  +7.47260000E-04  -4.85520000E-04  +1.33510000E-03
   -5.22300000E-04  -2.46850000E-04  +6.57690000E-04  -1.31271000E-03  -1.50941000E-03
   +2.12592000E-03  +3.57690000E-03  +1.92890000E-03  +6.12611000E-03  +3.59200000E-04
   -1.47633000E-03  -1.17066000E-03  -2.45800000E-05  -1.94200000E-05  +8.92400000E-05
   -2.08268000E-03  -8.58948000E-03  -7.46521000E-03  -1.76816300E-02  -2.81710080E-01
   -9.61883200E-02  -1.60007300E-02  -9.93084000E-03  -5.91755000E-03  +2.34756000E-03
   -2.35568000E-03  +1.89089000E-03  +5.51000000E-06  +1.76000000E-06  -3.92000000E-06
   +1.47600000E-05  +1.39000000E-06  +3.08000000E-06  +2.05200000E-05  -3.53900000E-05
   -1.53800000E-05  -3.35000000E-06  -8.07000000E-06  +3.11000000E-06  +2.29000000E-06
   +3.22000000E-06  +3.31000000E-06  +3.59000000E-05  +2.03200000E-05  +3.82100000E-05
   +4.42600000E-05  +5.26200000E-05  +4.11800000E-05  -1.53300000E-05  -6.46000000E-06
   +3.31600000E-05  +2.54000000E-06  +2.80500000E-05  -1.43700000E-05  +2.30000000E-07
   -6.62000000E-06  +1.56100000E-05  -7.55000000E-06  +2.05600000E-05  -2.81000000E-06
   -2.80140000E-04  +2.14700000E-04  -2.63839000E-03  +3.09995000E-02  +3.05376190E-01
   -2.28700000E-05  +7.86200000E-05  -1.02100000E-04  -1.63610000E-04  +1.73350000E-04
   +2.33880000E-04  -5.04500000E-05  -1.79100000E-05  +6.65900000E-05  -1.41500000E-05
   -8.28000000E-06  +1.80600000E-05  +9.49000000E-05  +4.22000000E-05  +1.02740000E-04
   -5.08800000E-05  -5.05100000E-05  -7.18300000E-05  -4.77120000E-04  -3.79950000E-04
   -4.25180000E-04  +2.06490000E-04  -2.51390000E-04  -1.71700000E-05  -1.30160000E-04
   -6.85600000E-05  -7.21000000E-05  -1.36299000E-03  +1.61839000E-03  -9.15710000E-04
   +1.10902000E-03  +1.75628000E-03  -8.54380000E-04  +1.56215000E-03  +9.18230000E-04
   -1.55629000E-03  -5.12744000E-03  -1.22660000E-04  -4.51223000E-03  +6.13640000E-04
   +8.37620000E-04  +4.16720000E-04  -1.00690000E-04  +1.79780000E-04  -1.28690000E-04
   -1.01220000E-03  -1.93257200E-02  +1.28075400E-02  -2.65689000E-03  -9.39044000E-02
   -9.39991500E-02  +3.68930000E-03  +7.00553000E-03  +1.31593100E-02  -3.91371000E-03
   +3.91839000E-03  -3.24928000E-03  +9.92000000E-06  +6.78000000E-06  +1.94700000E-05
   -1.65300000E-05  -3.75000000E-06  -1.30600000E-05  +3.29300000E-05  -2.95100000E-05
   +2.14300000E-05  +5.53000000E-06  +1.22900000E-05  +8.10000000E-07  -6.01000000E-06
   -1.59200000E-05  -5.98000000E-06  +2.89700000E-05  +1.18410000E-04  -1.01230000E-04
   +5.37200000E-05  +4.01600000E-05  +1.23880000E-04  -9.70100000E-05  +1.70800000E-05
   -1.78800000E-04  +5.02000000E-06  -5.15000000E-06  -3.20200000E-05  +2.50000000E-05
   -7.37000000E-06  -2.35400000E-05  -1.66600000E-05  -1.11300000E-05  +7.33700000E-05
   +4.17115000E-03  +4.02400000E-05  +1.99678000E-03  +3.29770000E-03  +9.80730300E-02
   +7.51911400E-02  +1.91800000E-05  -1.71000000E-05  +3.09000000E-06  +1.10910000E-04
   +2.72500000E-05  -3.72300000E-05  +1.65300000E-05  -1.03800000E-05  +2.60000000E-06
   -1.48200000E-05  -1.95100000E-05  -6.20000000E-07  -8.62000000E-06  +3.39000000E-06
   -2.26700000E-05  -6.88000000E-06  -3.15200000E-05  -8.04000000E-06  +3.42720000E-04
   +9.04300000E-04  -2.49030000E-04  -2.72990000E-04  +2.02400000E-05  +1.83040000E-04
   -3.25000000E-06  -1.44300000E-05  -1.23000000E-06  -2.94437000E-03  +2.50122000E-03
   +1.81551000E-03  +2.48870000E-03  +2.79010400E-02  -5.72147000E-03  -6.48217700E-02
   -5.98802900E-02  +2.19455700E-02  -1.05980000E-04  -2.82742800E-02  +8.02799000E-03
   +3.03680000E-04  +3.00814000E-03  -1.89394000E-03  +3.02300000E-05  -2.60000000E-05
   -9.29400000E-05  -1.35240000E-04  +4.72000000E-06  -4.39280000E-04  -7.76860000E-04
   +1.82260000E-04  -2.32900000E-04  +3.01480000E-04  -1.81450000E-04  +4.39010000E-04
   -6.54526000E-03  -2.15752000E-03  +6.28710000E-04  -9.52000000E-06  +4.95000000E-06
   -1.39000000E-06  -5.43000000E-06  +3.14000000E-06  -1.28000000E-06  -2.68000000E-06
   +1.03500000E-05  +7.53000000E-06  -4.63000000E-06  +1.63300000E-05  +1.26200000E-05
   -1.30000000E-05  +8.63000000E-06  +3.66000000E-06  -1.72600000E-05  +1.08970000E-04
   +3.00000000E-08  +7.67000000E-06  -2.06000000E-06  +1.42000000E-06  +7.43000000E-06
   -7.18000000E-06  -8.95000000E-06  +3.53600000E-05  -2.25200000E-05  +5.72100000E-05
   -6.36000000E-06  -2.82700000E-05  +1.13200000E-05  -6.36000000E-06  -1.43100000E-05
   +1.11000000E-05  +5.15200000E-05  +8.50800000E-05  -7.36100000E-05  +3.15100000E-05
   +4.21700000E-05  -1.50600000E-04  +7.21091700E-02  +3.00400000E-05  +2.77900000E-05
   +2.82700000E-05  -1.95380000E-04  -5.62000000E-06  -3.15300000E-05  -2.69500000E-05
   +1.95500000E-05  +3.12700000E-05  +1.69300000E-05  +1.57900000E-05  -4.58000000E-06
   -7.49000000E-06  -1.15100000E-05  +1.44100000E-05  +4.37000000E-06  +1.22700000E-05
   -2.18100000E-05  -3.44350000E-04  -3.35910000E-04  -6.11000000E-06  +1.00970000E-04
   -1.03700000E-05  -1.57870000E-04  +1.42100000E-05  +1.43600000E-05  +2.09000000E-06
   +2.28377000E-03  +6.85590000E-04  +2.46736000E-03  -3.30054000E-03  -1.53107100E-02
   +5.35638000E-03  -5.40459700E-02  -3.07984830E-01  +7.28546000E-02  +1.65783000E-03
   -4.58936000E-03  -5.41340000E-04  +1.01760000E-03  +1.85562000E-03  -1.99800000E-04
   +9.33700000E-05  -9.19200000E-05  -6.64700000E-05  +2.40570000E-04  -3.17680000E-04
   -3.66410000E-04  +2.47000000E-05  +2.02650000E-04  +8.92000000E-06  -2.50700000E-05
   -5.43500000E-05  +1.49630000E-04  -1.08477000E-03  +2.10440000E-04  +8.88750000E-04
   +3.20000000E-07  -4.94000000E-06  -5.40000000E-07  +5.65000000E-06  -3.27000000E-06
   +2.43000000E-06  -9.41000000E-06  +8.40000000E-07  -2.43600000E-05  +2.70000000E-06
   -1.20500000E-05  -7.82000000E-06  +9.54000000E-06  -3.70000000E-07  +9.80000000E-07
   +1.44900000E-05  -5.31200000E-05  -2.01000000E-05  +3.55000000E-06  +4.90000000E-07
   +1.51000000E-05  -1.99400000E-05  +2.32300000E-05  -7.94000000E-06  +4.72300000E-05
   -3.96800000E-05  -2.36200000E-05  -9.60000000E-07  -6.27000000E-06  +1.20200000E-05
   -4.40000000E-06  +8.63000000E-06  -5.64700000E-05  -2.48680000E-04  -4.96800000E-05
   -1.98880000E-04  -1.26640000E-04  -8.09800000E-05  -1.77860000E-04  +5.38703600E-02
   +3.25218550E-01  +8.90000000E-05  +1.04080000E-04  +1.10700000E-05  -4.10830000E-04
   +1.52900000E-04  -1.31380000E-04  -3.48500000E-05  +3.34700000E-05  +1.18100000E-04
   -3.42000000E-06  -3.08400000E-05  -6.56000000E-06  -9.05000000E-06  -1.04100000E-05
   +1.33900000E-05  +3.15000000E-06  -2.55300000E-05  -7.03200000E-05  -2.62400000E-05
   +1.36534000E-03  -8.50820000E-04  -3.66410000E-04  -6.23500000E-05  +1.06370000E-04
   -7.92000000E-06  -9.88000000E-06  -1.78300000E-05  +6.18700000E-04  +3.50897000E-03
   +1.23238000E-02  +6.44496000E-03  +1.14703000E-03  +6.49169000E-03  +1.30485200E-02
   +6.88518800E-02  -6.05947000E-02  +1.43384000E-03  +7.98221000E-03  +6.12094000E-03
   -1.17600000E-05  -6.52950000E-04  -1.25031000E-03  +3.01580000E-04  -1.56250000E-04
   -3.84810000E-04  -1.56852000E-03  -1.70636000E-03  -2.02070000E-04  +2.93082000E-03
   -1.05069000E-03  -4.46720000E-04  -2.29684000E-03  +1.03965000E-03  +3.51390000E-04
   +3.82394000E-03  +2.10549000E-03  -1.05593000E-03  -1.50700000E-05  +7.50000000E-07
   +4.22000000E-06  -5.81000000E-06  +3.94000000E-06  -2.18000000E-06  -2.40800000E-05
   +2.77500000E-05  -3.18500000E-05  -1.38100000E-05  -7.81000000E-06  +1.56000000E-06
   +2.80000000E-06  +7.92000000E-06  +3.72000000E-06  -3.05000000E-06  +1.17370000E-04
   -5.21800000E-05  +2.92200000E-05  +5.70000000E-06  +3.08100000E-05  -2.61700000E-05
   +2.57400000E-05  -3.69400000E-05  +4.99900000E-05  -1.43650000E-04  +1.12470000E-04
   -7.43000000E-06  -4.26000000E-05  +1.07500000E-05  -1.98600000E-05  -8.82000000E-05
   -6.35000000E-05  -1.02273000E-03  +2.68900000E-05  -8.35660000E-04  -1.21870000E-04
   +3.08640000E-04  -9.92400000E-05  -2.16445500E-02  -7.80863100E-02  +4.68545800E-02
   -9.21460000E-04  +7.15890000E-04  +1.71410000E-04  -1.58117000E-03  +2.22843000E-03
   -9.86100000E-05  -4.74370000E-04  +6.54810000E-04  +3.40800000E-05  +2.63990000E-04
   -2.49600000E-05  +4.37200000E-05  -1.94420000E-04  -1.95390000E-04  +2.03000000E-06
   -6.55600000E-05  -1.36900000E-04  -6.94900000E-05  -4.58420000E-04  +6.75520000E-04
   +2.50410000E-04  -9.30800000E-05  -8.94000000E-05  -1.82020000E-04  +1.05440000E-04
   +7.88800000E-05  +5.03500000E-05  +3.83740000E-03  +1.57282000E-03  -7.67130000E-04
   -2.53650720E-01  -1.09916810E-01  +6.62777800E-02  -2.66207300E-02  -8.84410000E-03
   +8.18599000E-03  +3.79168000E-03  +2.91850000E-03  -9.81470000E-04  -1.81911000E-03
   +1.01382000E-03  +1.70887000E-03  -7.38800000E-05  -7.37800000E-05  +4.29140000E-04
   +5.37500000E-05  +9.67330000E-04  +2.74920000E-04  +6.51100000E-05  +5.27200000E-05
   -2.00040000E-04  +6.66000000E-05  -2.10140000E-04  +1.41410000E-04  -4.47400000E-04
   -7.31150000E-04  +2.13700000E-05  -1.60500000E-05  -1.60900000E-05  -1.52400000E-05
   +5.89000000E-06  -2.74000000E-06  +8.60000000E-06  +2.16900000E-05  -5.84200000E-05
   +3.43400000E-05  +1.10770000E-04  -1.36700000E-05  -8.76000000E-06  +1.51000000E-05
   -6.88000000E-06  -3.42000000E-06  +7.83900000E-05  +2.25100000E-05  -2.04000000E-05
   -1.18100000E-05  -6.48200000E-05  +1.97200000E-05  -2.42300000E-05  +3.37200000E-05
   -5.70700000E-05  +1.80640000E-04  +2.76660000E-04  -2.75420000E-04  +2.90000000E-06
   +7.67800000E-05  -2.53000000E-05  -2.80300000E-05  +2.56680000E-04  -7.80800000E-05
   +1.35480000E-04  +2.36390000E-04  -1.60410000E-04  -1.02360000E-04  +9.64000000E-05
   -1.06320000E-04  +4.58690000E-04  +1.58450000E-04  -1.64991000E-03  +2.77364290E-01
   +5.42130000E-04  +2.37100000E-04  -1.72550000E-04  +6.29570000E-04  -4.20840000E-04
   -2.38330000E-04  +3.19080000E-04  +1.13950000E-04  +8.14830000E-04  -3.30670000E-04
   -2.23900000E-04  +4.01200000E-05  +4.48830000E-04  +2.16530000E-04  -1.24100000E-04
   +8.07100000E-05  +2.36400000E-05  -6.09200000E-05  -1.28605000E-03  -5.17760000E-04
   +4.24310000E-04  +1.46980000E-04  +8.80200000E-05  -5.22600000E-05  -4.57760000E-04
   -2.42230000E-04  -1.97730000E-04  -2.65475800E-02  -1.52925300E-02  +1.01179000E-02
   -1.09010800E-01  -1.12033380E-01  +3.44077600E-02  +2.28429200E-02  +6.42637000E-03
   -4.18173000E-03  +7.73700000E-05  -2.02341000E-03  +3.68136000E-03  +2.09690000E-04
   +1.27000000E-04  -9.84770000E-04  +3.89200000E-05  -3.78780000E-04  -4.08300000E-05
   +4.23560000E-04  -4.72195000E-03  +1.22516000E-03  +2.73192000E-03  -9.90600000E-04
   -1.10753000E-03  -1.69269000E-03  +5.66490000E-04  -1.39260000E-04  +1.07391000E-03
   +2.38067000E-03  -1.17960000E-03  +3.07500000E-05  +2.56500000E-05  +5.45000000E-05
   -3.64800000E-05  -1.27600000E-05  -2.98000000E-05  -2.45000000E-05  +1.35800000E-05
   -7.46400000E-05  +4.59700000E-05  -1.53700000E-05  -2.08200000E-05  -4.22500000E-05
   +5.70000000E-06  +1.35300000E-05  +7.06500000E-05  -1.68300000E-05  -4.65100000E-05
   +3.67200000E-05  +1.26610000E-04  +8.12500000E-05  -9.08300000E-05  +7.34100000E-05
   -5.39100000E-05  -3.32800000E-05  -1.25200000E-05  -7.91010000E-04  +5.74300000E-05
   +1.64800000E-04  +1.46830000E-04  +1.64300000E-05  +2.28260000E-04  -9.15700000E-05
   -5.89130000E-04  -6.10370000E-04  +1.10466000E-03  +3.69400000E-05  +1.09700000E-05
   -4.11400000E-05  +1.60787000E-03  +6.65570000E-04  -2.49018000E-03  +1.08174470E-01
   +1.27272060E-01  -1.60070000E-04  -3.90540000E-04  +1.70430000E-04  +2.74660000E-04
   -2.60330000E-04  +3.32690000E-04  +1.32440000E-04  -2.76800000E-05  -1.69240000E-04
   -1.83510000E-04  -2.02550000E-04  -1.92860000E-04  -1.46150000E-04  +8.04000000E-06
   -1.91750000E-04  +1.24560000E-04  +1.07910000E-04  +1.58480000E-04  -2.20970000E-04
   -4.87500000E-04  -6.73180000E-04  -1.28060000E-04  -1.27600000E-05  -1.81540000E-04
   +1.61010000E-04  +5.71100000E-05  +5.42000000E-05  +5.99437000E-03  +1.00301600E-02
   -8.89910000E-04  +6.92540300E-02  +3.21515000E-02  -5.96435300E-02  -8.29490000E-04
   -1.64525000E-03  +6.78797000E-03  +3.31650000E-03  +1.22440000E-03  +1.08365700E-02
   -3.14431000E-03  +1.61551000E-03  -1.08510000E-04  -9.13000000E-05  -5.89720000E-04
   -1.53890000E-04  -2.60444000E-03  +8.38460000E-04  +4.74124000E-03  +2.52803000E-03
   -1.28765000E-03  -6.33930000E-04  -1.50808000E-03  +4.97210000E-04  +6.80000000E-07
   +1.27265000E-03  +2.04047000E-03  -2.22405000E-03  -3.39600000E-05  +6.97000000E-06
   -2.07800000E-05  -1.61000000E-05  +2.28100000E-05  +1.86000000E-06  +1.54000000E-05
   +8.73600000E-05  +9.14000000E-06  +9.72500000E-05  -7.04400000E-05  -1.57080000E-04
   +4.08000000E-06  +9.18000000E-06  +1.03000000E-06  -3.28600000E-05  +1.06600000E-05
   +3.71100000E-05  +1.96000000E-06  -6.67100000E-05  -8.05000000E-06  +1.66500000E-05
   +7.51800000E-05  -2.02800000E-05  +1.53950000E-04  -8.35900000E-04  -9.72200000E-04
   +5.93400000E-05  -1.66600000E-05  +1.97000000E-06  -5.46000000E-06  +2.28450000E-04
   +3.61000000E-06  +1.32700000E-04  +2.50640000E-04  -4.96490000E-04  -3.07900000E-05
   +2.89380000E-04  +4.47000000E-05  -2.00935000E-03  -1.75916000E-03  -7.71970000E-03
   -7.28435600E-02  -4.07591800E-02  +5.06006600E-02  -7.50000000E-07  -7.29700000E-05
   +1.27710000E-04  -2.72000000E-05  -1.93250000E-04  -1.97500000E-04  +5.50800000E-05
   -1.18500000E-05  +2.77100000E-05  +6.79900000E-05  +2.76800000E-05  -1.02420000E-04
   -2.80980000E-04  -1.35120000E-04  -1.94760000E-04  +1.16460000E-04  +6.94700000E-05
   +1.25710000E-04  -3.50840000E-04  +1.89530000E-04  -2.88420000E-04  +1.47260000E-04
   +8.76400000E-05  -8.36600000E-05  +3.45690000E-04  +1.84260000E-04  +1.56090000E-04
   -3.69255000E-03  -5.93782000E-03  +3.15753000E-03  -2.35971000E-03  +2.57128000E-03
   -4.59410000E-04  +2.65980000E-04  -2.96453000E-03  -2.44247000E-03  -1.69055000E-03
   +2.35896000E-03  +5.87087000E-03  -1.21236000E-03  -5.20360000E-04  +1.29650000E-03
   +3.87630000E-04  -2.30550000E-04  +1.24090000E-04  +6.30705000E-03  -2.22102000E-03
   -5.87523000E-03  -6.71303700E-02  +1.87927700E-02  -6.44790000E-03  -5.02770900E-02
   +4.59209800E-02  -3.56585400E-02  -1.67728100E-02  -1.51335600E-02  +3.31199000E-03
   -5.16100000E-05  -2.57100000E-05  -4.20400000E-05  +1.62000000E-05  +5.94000000E-06
   +2.84400000E-05  -6.59100000E-05  +5.64200000E-05  -1.05070000E-04  -1.54200000E-05
   -2.23200000E-05  -6.86000000E-06  +1.84500000E-05  +2.29200000E-05  +2.89000000E-06
   +6.58300000E-05  -4.07000000E-05  -6.21200000E-05  -2.59900000E-05  +5.19700000E-05
   +4.57500000E-05  -7.40200000E-05  +5.20300000E-05  -2.85500000E-05  -9.00000000E-08
   +7.05100000E-05  -4.25200000E-05  -1.88000000E-06  -1.36800000E-05  +9.69600000E-05
   +2.35200000E-05  +7.99600000E-05  -1.85420000E-04  +8.47270000E-04  +5.28500000E-05
   +5.57960000E-04  +5.73520000E-04  -7.49290000E-04  +5.70840000E-04  -6.13480000E-04
   -1.56090000E-04  +5.13660000E-04  +2.49900000E-05  +4.99220000E-04  +4.48880000E-04
   +1.35380700E-01  -6.95200000E-05  +4.60100000E-05  -2.34490000E-04  +7.39000000E-06
   +3.29620000E-04  +4.87230000E-04  -1.74600000E-05  -6.25900000E-05  -6.63300000E-05
   -1.05960000E-04  -7.83300000E-05  +1.23770000E-04  +2.79310000E-04  +1.67580000E-04
   +2.32490000E-04  -1.73560000E-04  -1.59560000E-04  -1.42490000E-04  -1.62000000E-05
   -1.09347000E-03  +1.62550000E-04  -4.38900000E-05  -1.64430000E-04  +7.74900000E-05
   -3.76390000E-04  -2.38620000E-04  -1.77340000E-04  +8.07242000E-03  +1.80008200E-02
   -4.46459000E-03  +7.86488000E-03  -8.24198000E-03  +2.41472000E-03  -4.48924000E-03
   +2.24532000E-03  +6.88123000E-03  -2.35992800E-02  -4.21387200E-02  -1.68032500E-02
   +1.93120000E-03  +1.28584300E-02  +6.15647000E-03  -4.54790000E-04  +3.02650000E-04
   -3.32930000E-04  -2.10577700E-02  -6.10052000E-03  +1.77363200E-02  +5.49763200E-02
   +3.95773600E-02  -2.71574300E-02  -1.15773300E-02  -1.02534970E-01  +2.47772800E-02
   +3.52344700E-02  +4.44848800E-02  -3.00140400E-02  +3.62500000E-05  +4.93300000E-05
   +4.56100000E-05  -3.20400000E-05  +8.61000000E-06  -3.53900000E-05  +9.21700000E-05
   -3.30200000E-05  +1.60190000E-04  -1.50200000E-05  +6.50600000E-05  +3.29900000E-05
   -3.85400000E-05  -2.61100000E-05  -8.67000000E-06  -8.73400000E-05  +2.27400000E-05
   +1.26240000E-04  +4.06400000E-05  -8.20400000E-05  -1.00600000E-04  +1.26540000E-04
   -9.07200000E-05  +9.47700000E-05  -8.08300000E-05  -2.19540000E-04  +2.33550000E-04
   -1.47900000E-05  +9.67600000E-05  -1.32110000E-04  +1.04300000E-05  -2.15210000E-04
   +2.80060000E-04  -1.35332000E-03  -2.45320000E-04  -2.45228000E-03  -2.95400000E-03
   -1.27212000E-03  -4.15170000E-04  +3.76420000E-04  +1.24000000E-06  -2.25169000E-03
   +1.74450000E-04  -1.25316000E-03  -1.13933000E-03  -4.26655900E-02  +4.59940600E-02
   +3.61000000E-05  +6.34100000E-05  +6.26000000E-05  -8.82600000E-05  -2.17000000E-05
   -2.19150000E-04  -5.24600000E-05  +1.05400000E-05  +1.34690000E-04  +1.98400000E-05
   +2.30400000E-05  -4.03800000E-05  -8.26000000E-06  -2.55400000E-05  -1.67700000E-05
   +5.62900000E-05  +6.86000000E-05  -1.18900000E-05  +1.54400000E-05  +6.27190000E-04
   -4.64570000E-04  -4.89500000E-05  +6.53900000E-05  +1.37000000E-06  +2.50000000E-05
   +3.88000000E-05  -1.83000000E-06  -2.04737000E-03  -7.99816000E-03  +1.41471000E-03
   -4.02244000E-03  +3.32743000E-03  -1.40685000E-03  +4.13250000E-04  -2.03063000E-03
   -4.34153000E-03  +1.19522000E-02  +2.77117900E-02  +2.50701700E-02  -4.40880000E-04
   -1.10133000E-02  -9.80734000E-03  +3.15830000E-04  -1.46370000E-04  +1.44180000E-04
   +9.55231000E-03  +5.00862000E-03  -8.95556000E-03  -3.88876700E-02  -1.86419600E-02
   +2.14670400E-02  +1.09585100E-02  +1.72973200E-02  -2.83703000E-02  -2.50524500E-02
   -4.37592500E-02  -8.03228000E-03  -9.60000000E-07  -1.91900000E-05  +5.16000000E-06
   -6.76000000E-06  -1.34100000E-05  +4.40000000E-07  -1.42400000E-05  +1.29700000E-05
   -4.61000000E-05  +3.06700000E-05  -2.81100000E-05  -3.05800000E-05  +1.87000000E-05
   +1.00000000E-07  +1.86000000E-06  +5.05700000E-05  +3.51000000E-05  -6.01900000E-05
   +5.49000000E-06  +2.40800000E-05  +9.50800000E-05  -9.45700000E-05  +3.24200000E-05
   -7.84900000E-05  +6.83300000E-05  +1.50020000E-04  -1.53140000E-04  +1.12400000E-05
   -1.02410000E-04  +2.57800000E-05  -5.20700000E-05  +1.21690000E-04  -1.54740000E-04
   +1.79310000E-04  +1.38000000E-04  +1.27710000E-03  +2.02176000E-03  +2.44540000E-03
   +2.08156000E-03  -5.61330000E-04  -7.32200000E-05  +1.29785000E-03  -1.11490000E-04
   +7.66160000E-04  +6.74660000E-04  +3.57593500E-02  +2.59051800E-02  +8.43745000E-03
end_hess

