# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -883.30810450    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +2.98368580E+00  +3.09595242E+00  -1.23478636E+00
   006   +1.04558411E+00  +2.28764732E+00  +2.20637588E-01
   006   +1.47294203E+00  +4.92415185E-01  +2.24292953E+00
   006   +3.21722388E+00  -1.30590921E+00  +2.26023203E+00
   006   +6.60477550E+00  +1.39836601E-01  -4.85577971E-01
   006   +5.60392517E+00  +2.38837457E+00  -1.16251534E+00
   006   -1.63751787E+00  +3.36362005E+00  +3.50513895E-02
   006   -2.08245470E+00  +5.13189202E+00  +2.29711085E+00
   008   +8.80586822E+00  -7.03543047E-01  -3.55127851E-01
   006   -3.51690374E+00  +1.16152808E+00  -2.23100618E-02
   006   -5.66987105E+00  +1.06128981E+00  +1.46897222E+00
   006   -7.36200145E+00  -9.40606001E-01  +1.30511248E+00
   006   -6.92234910E+00  -2.89558090E+00  -3.78325292E-01
   006   -4.77487665E+00  -2.83582222E+00  -1.89005946E+00
   006   -3.11259941E+00  -8.36092651E-01  -1.69743399E+00
   008   -8.50273069E+00  -4.90669972E+00  -6.24821423E-01
   006   -2.04640278E+00  +4.92370680E+00  -2.37823821E+00
   008   +4.62875163E+00  -1.85785709E+00  +9.67388323E-02
   001   -9.90348709E+00  -4.71836026E+00  +5.02627943E-01
   001   -9.02582598E+00  -9.67712512E-01  +2.50072890E+00
   001   -6.07495678E+00  +2.55250900E+00  +2.80495812E+00
   001   -1.43032058E+00  -8.31448420E-01  -2.86386918E+00
   001   -4.43225697E+00  -4.37095941E+00  -3.19476154E+00
   001   -1.60671233E+00  +3.83350070E+00  -4.06937309E+00
   001   -4.02187886E+00  +5.49755565E+00  -2.48854480E+00
   001   -8.93732831E-01  +6.63282475E+00  -2.38069560E+00
   001   -6.37807914E-01  +6.59911863E+00  +2.30353698E+00
   001   -3.92136000E+00  +6.05585096E+00  +2.17348787E+00
   001   -1.99157308E+00  +4.14258513E+00  +4.10206700E+00
   001   +3.20053705E-01  +6.23649198E-01  +3.93006766E+00
   001   +3.63022646E+00  -2.51316078E+00  +3.85680099E+00
   001   +6.97556261E+00  +3.73784424E+00  -1.84923488E+00
   001   +2.58170982E+00  +4.58711685E+00  -2.57822505E+00
   001   +8.71320293E+00  -3.35380623E+00  -8.35313265E-02
   008   +7.70595492E+00  -5.08787657E+00  +1.53770638E-01
   001   +8.15234489E+00  -5.83640823E+00  +1.74039308E+00
   001   +5.84811519E+00  -3.76611249E+00  +2.54823949E-01
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -5.00000000E-08  -9.00000000E-08  +7.00000000E-08
   -7.00000000E-08  -5.00000000E-08  +1.00000000E-07
   -1.30000000E-07  +1.10000000E-07  +4.00000000E-08
   -1.20000000E-07  +1.20000000E-07  +1.20000000E-07
   +5.00000000E-08  -2.40000000E-07  +2.90000000E-07
   +3.00000000E-08  +0.00000000E+00  +1.50000000E-07
   +5.00000000E-08  -2.00000000E-08  -1.70000000E-07
   -4.00000000E-08  +4.00000000E-08  -1.80000000E-07
   +2.00000000E-08  -6.00000000E-08  +3.50000000E-07
   +6.00000000E-08  +5.00000000E-08  -9.00000000E-08
   +4.00000000E-08  +9.00000000E-08  -2.30000000E-07
   -3.00000000E-08  +0.00000000E+00  -1.70000000E-07
   -6.00000000E-08  +0.00000000E+00  -7.00000000E-08
   +1.00000000E-07  +3.00000000E-08  -1.10000000E-07
   +2.00000000E-08  -4.00000000E-08  -8.00000000E-08
   +0.00000000E+00  +1.00000000E-08  -1.10000000E-07
   +1.20000000E-07  -7.00000000E-08  -1.70000000E-07
   +2.00000000E-08  -7.00000000E-08  -5.00000000E-08
   -1.00000000E-08  +4.00000000E-08  -1.50000000E-07
   -8.00000000E-08  +9.00000000E-08  -2.10000000E-07
   -5.00000000E-08  +7.00000000E-08  -2.20000000E-07
   +3.00000000E-08  -7.00000000E-08  +1.00000000E-08
   +7.00000000E-08  -7.00000000E-08  +0.00000000E+00
   +1.40000000E-07  -1.10000000E-07  -1.30000000E-07
   +1.20000000E-07  -7.00000000E-08  -2.80000000E-07
   +1.00000000E-07  -9.00000000E-08  -2.10000000E-07
   -1.00000000E-07  +7.00000000E-08  -2.20000000E-07
   -5.00000000E-08  +5.00000000E-08  -2.70000000E-07
   -8.00000000E-08  +1.50000000E-07  -2.10000000E-07
   -8.00000000E-08  +1.10000000E-07  -6.00000000E-08
   -1.40000000E-07  +7.00000000E-08  +2.40000000E-07
   +1.30000000E-07  -4.00000000E-08  +1.30000000E-07
   +1.10000000E-07  -7.00000000E-08  -4.00000000E-08
   +0.00000000E+00  +0.00000000E+00  +4.50000000E-07
   -1.00000000E-08  -1.00000000E-07  +1.30000000E-07
   -1.00000000E-07  +0.00000000E+00  +4.90000000E-07
   +0.00000000E+00  +1.30000000E-07  +8.20000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.81202160E-01  -2.10537700E-02  +4.30862060E-01  -1.28663410E-01  -2.74710240E-01
   +4.47871430E-01  -3.00042050E-01  -8.53927900E-02  +1.58724890E-01  +6.29101100E-01
   -5.30748800E-02  -1.27566400E-01  +8.37580000E-02  -5.47290000E-03  +3.73868920E-01
   +1.37754460E-01  +9.89034100E-02  -1.93058520E-01  -1.53257400E-01  -2.14935330E-01
   +4.68997250E-01  +1.98481500E-02  -1.91321600E-02  +1.20219300E-02  -1.00339810E-01
   +2.02076600E-02  +5.29716000E-03  +5.53567660E-01  -2.61284100E-02  -4.44203000E-03
   +2.99035600E-02  +3.65073100E-02  -1.39393600E-01  +6.78406600E-02  -3.13122180E-01
   +5.26899430E-01  +2.13869100E-02  +1.76589600E-02  -2.69813200E-02  -2.01424000E-02
   +8.53286000E-02  -1.72026800E-01  -1.51555390E-01  -1.11414940E-01  +5.46670630E-01
   -1.21454000E-02  -1.37624000E-03  +1.17812500E-02  +2.32438000E-03  +2.88776200E-02
   -2.72854700E-02  -2.81908870E-01  +2.32057750E-01  +7.71845000E-03  +4.68434180E-01
   +2.80365000E-03  +4.98500000E-05  -2.95131000E-03  +1.89418200E-02  -1.87686800E-02
   +1.58426100E-02  +2.46331800E-01  -3.18445680E-01  +2.41336900E-02  -3.52697130E-01
   +5.75920950E-01  -1.76783000E-02  +4.70117000E-03  -1.30904000E-03  -1.05667500E-02
   +2.71529600E-02  -6.06280000E-04  +2.55538000E-03  +1.77167500E-02  -9.17785700E-02
   -5.01847100E-02  -1.55640300E-01  +5.16789700E-01  -2.23653900E-02  +2.99182700E-02
   -9.94776000E-03  +3.55612000E-03  +4.56726000E-03  -7.44992000E-03  +4.61406000E-03
   -7.59619000E-03  +1.23756000E-03  -3.19113300E-02  +6.27104000E-03  +2.93326600E-02
   +6.34550390E-01  +5.45669100E-02  -1.34946800E-02  -2.45054000E-03  -2.10536100E-02
   -1.55847100E-02  +1.51818700E-02  -2.90889000E-03  +1.07418000E-02  -2.36546100E-02
   -1.20111000E-02  +1.78825200E-02  +4.63340000E-02  -3.33981080E-01  +6.39892450E-01
   -3.18058400E-02  +4.84874000E-03  -1.16764000E-03  +1.15912300E-02  +1.14462200E-02
   -1.02213100E-02  +6.21728000E-03  -9.35707000E-03  +1.05762100E-02  +1.35926300E-02
   +9.19431000E-03  -2.78107000E-02  +6.63968300E-02  -1.06132110E-01  +2.00668270E-01
   -2.60082590E-01  +5.78828800E-02  -1.26429800E-02  -4.14935500E-02  -1.44193300E-02
   +2.26108600E-02  -8.76235000E-03  +1.41788400E-02  -1.38229700E-02  +1.25636400E-02
   -8.10450000E-04  +5.60634000E-03  -1.37170370E-01  +1.08411370E-01  -1.35162100E-02
   +6.67604990E-01  +1.92999500E-02  -1.00777420E-01  +2.64651000E-02  +3.92493000E-03
   +2.51390100E-02  -1.53038200E-02  +5.78986000E-03  -1.41000500E-02  +9.79322000E-03
   +3.28160000E-04  -5.18049000E-03  -1.38699100E-02  +1.11074950E-01  -3.39336030E-01
   +7.28053500E-02  -5.64942800E-02  +6.67498800E-01  +8.47612000E-03  +2.18565000E-02
   -6.52297600E-02  +1.45468400E-02  -7.10416000E-03  +7.09619000E-03  +1.24104000E-03
   -1.48364000E-03  -3.24517000E-03  -6.92490000E-04  +1.79060000E-03  +6.95333000E-03
   -3.48956900E-02  +8.50283300E-02  -7.90623900E-02  -3.99760200E-02  -2.10846820E-01
   +1.85537750E-01  -2.67042100E-02  +6.20564000E-03  +3.37618000E-03  -1.53056760E-01
   +3.30461000E-02  -1.97042000E-03  -6.00380000E-03  +6.73313000E-03  -6.47031000E-03
   +8.91340000E-04  -1.73418000E-03  +1.33334000E-03  -2.34663000E-03  +1.84448000E-03
   -8.21020000E-04  +3.13714000E-03  -1.02795000E-03  +2.53518000E-03  +4.70211020E-01
   -6.62728000E-03  +7.59096000E-03  -3.49146000E-03  +3.39014000E-02  -8.54317600E-02
   +8.22828000E-03  +2.21111900E-02  -1.39925600E-02  +5.45968000E-03  -1.99800000E-03
   +3.67880000E-04  +2.96352000E-03  +9.00500000E-05  -9.69900000E-04  -3.28400000E-05
   -5.96200000E-04  +4.66499000E-03  +5.52885000E-03  -2.68057000E-03  +4.80948710E-01
   +1.38662900E-02  -8.78381000E-03  +5.01868000E-03  -3.92075000E-03  +1.36297700E-02
   -8.37998700E-02  -2.26915900E-02  +8.35269000E-03  +2.56936000E-03  +1.89680000E-04
   +3.11247000E-03  -5.02866000E-03  -9.35550000E-04  +3.66240000E-03  -1.76650000E-03
   +3.71348000E-03  +4.43084000E-03  +2.11867000E-03  -6.74780000E-04  -1.95791000E-03
   +4.79284530E-01  +1.79460000E-04  +2.71172000E-03  -9.27250000E-04  -1.33703900E-02
   +1.97142300E-02  +2.58546500E-02  -2.09640000E-04  +7.34800000E-04  -2.54090000E-04
   -4.94600000E-05  -1.94200000E-04  +9.70260000E-04  +1.30350000E-03  -2.13126000E-03
   +1.01959000E-03  -1.96343000E-03  -4.96800000E-04  -1.42687000E-03  -7.69446900E-02
   +1.05986300E-02  +1.41601700E-02  +5.82498220E-01  -1.98266000E-03  -1.23250000E-03
   +6.25620000E-04  +1.08312100E-02  -1.12401900E-02  -1.14905200E-02  +1.32120000E-04
   -8.89000000E-05  +8.50600000E-05  +5.21800000E-05  +2.46020000E-04  -5.92530000E-04
   -2.56380000E-04  +7.10770000E-04  -3.43090000E-04  +5.78410000E-04  +2.79100000E-05
   +4.50440000E-04  +6.74078000E-03  -1.10448420E-01  -4.69678300E-02  +1.40838600E-02
   +5.33171290E-01  -8.57850000E-04  +8.12500000E-05  -1.26720000E-04  +8.19970000E-03
   -4.46320000E-03  +1.24209000E-03  -9.23350000E-04  -9.85400000E-05  +2.98000000E-04
   -3.88530000E-04  +4.61750000E-04  +8.56000000E-05  +3.84380000E-04  -1.41220000E-03
   +6.13280000E-04  -6.32370000E-04  +4.81800000E-04  -1.28560000E-04  +8.17834000E-03
   -4.30603600E-02  -1.33515090E-01  +1.06364700E-02  -6.28397200E-02  +5.16137440E-01
   +1.55513000E-02  -1.95429000E-03  +5.77920000E-04  -5.88265000E-03  -3.97591000E-03
   +3.89198000E-03  -4.09144000E-03  +5.50697000E-03  -2.23623000E-03  -1.26990000E-04
   -5.05117000E-03  -5.71739000E-03  -4.46293200E-01  +1.62810310E-01  -2.81362000E-02
   -3.72197800E-02  +4.10712600E-02  -8.16790000E-03  +2.15668000E-03  -1.06841000E-03
   +1.10624000E-03  -1.57968000E-03  +2.61370000E-04  -7.64540000E-04  +5.68573140E-01
   -1.82187300E-02  -5.91840000E-04  +5.29601000E-03  +6.66814000E-03  +5.12419000E-03
   -5.53236000E-03  +2.67185000E-03  -5.43534000E-03  +7.51672000E-03  +4.78750000E-04
   -2.11050000E-04  -9.65390000E-03  +1.34738800E-01  -1.62587060E-01  +1.73650800E-02
   +6.42537200E-02  -2.48164200E-02  +8.67460000E-03  -1.29297000E-03  +5.96360000E-04
   -1.63030000E-03  +1.26256000E-03  -2.95000000E-04  +7.30110000E-04  -1.43981090E-01
   +2.18110490E-01  +4.65949000E-03  +1.25093000E-03  +7.60131000E-03  -2.65154000E-03
   -4.33290000E-04  -6.57980000E-04  -3.36000000E-06  +3.41610000E-04  -3.96890000E-04
   -2.26770000E-03  +2.21754000E-03  +6.24426000E-03  -2.49143100E-02  +1.24446300E-02
   -6.51442100E-02  -1.59339300E-02  +1.32323100E-02  +1.34583300E-02  +2.53470000E-04
   -7.56600000E-04  +6.27000000E-06  -2.18200000E-04  +2.85800000E-05  -2.05980000E-04
   +1.90204300E-02  -3.47143000E-02  +4.59100200E-02  -1.19253000E-03  +1.18410000E-03
   -2.76857000E-03  -3.39945000E-02  -2.24398200E-02  +2.54591000E-03  -9.70680000E-04
   -3.70260000E-04  -4.60140000E-04  -1.56920000E-04  -6.21270000E-04  +4.09110000E-04
   +6.11790000E-04  -1.06110000E-03  +6.03060000E-04  -9.94230000E-04  +1.82308000E-03
   +1.20394000E-03  -1.18369260E-01  -4.63489600E-02  +5.30736000E-03  +4.25721000E-03
   +1.15100000E-04  -3.62239000E-03  -8.24030000E-04  +5.55480000E-04  -2.98950000E-04
   +5.38368700E-01  +1.33337000E-03  -1.79055000E-03  +5.09700000E-04  -5.96240000E-04
   +1.06026300E-02  -8.33200000E-04  +2.04824000E-03  +9.76280000E-04  +1.92780000E-04
   +1.20470000E-04  -5.05100000E-04  +2.87580000E-04  -1.08147000E-03  +1.94800000E-03
   -7.16980000E-04  +1.16120000E-03  -1.36663000E-03  -4.97460000E-04  -4.40616400E-02
   -1.32699880E-01  -1.08879500E-02  -1.35331500E-02  -2.07705800E-02  -3.32927000E-03
   +1.58693000E-03  -1.26850000E-03  +3.38080000E-04  +9.82115200E-02  +5.22019840E-01
   +7.72850000E-04  -3.78370000E-04  -1.90330000E-04  -2.36620000E-04  +5.66370000E-04
   +6.03330000E-04  -1.93241000E-03  +2.75980000E-04  -3.58220000E-04  +7.39000000E-06
   -3.46850000E-04  -2.41970000E-04  +2.90870000E-04  -2.84760000E-04  +2.42260000E-04
   -2.66710000E-04  +2.09080000E-04  -5.11100000E-05  +7.83078000E-03  -8.14788000E-03
   -7.99747200E-02  -1.81165900E-02  -2.20120900E-02  -8.07910000E-04  -3.19170000E-04
   +1.98680000E-04  -5.48100000E-05  -1.89834280E-01  +1.54712300E-01  +4.29429500E-01
   -7.92010000E-04  +4.39730000E-04  +2.38200000E-05  -4.87640000E-04  -7.57050000E-04
   +2.13460000E-04  +1.96390000E-04  -3.90930000E-04  -5.20500000E-05  -2.22210000E-04
   +3.41460000E-04  +3.28540000E-04  -3.38950000E-04  -2.06700000E-05  -1.10900000E-04
   +2.12430000E-04  -1.35350000E-04  +1.04880000E-04  -1.47974200E-02  -5.27096000E-03
   +8.64019000E-03  -1.28423000E-03  -7.52430000E-04  +9.45330000E-04  +2.01690000E-04
   -7.59200000E-05  -4.34000000E-06  -2.48945460E-01  -4.69158000E-02  +1.00291600E-01
   +5.39416320E-01  -1.08469000E-03  +5.91830000E-04  -8.15600000E-05  -6.24580000E-04
   -2.75296000E-03  +5.42570000E-04  +2.60470000E-04  -3.06410000E-04  +1.89550000E-04
   -4.29150000E-04  +3.24030000E-04  -9.02100000E-05  -3.16400000E-05  -2.68180000E-04
   -2.55600000E-05  +4.13700000E-05  +1.22290000E-04  +1.58460000E-04  -1.96964000E-02
   +2.72407000E-03  +1.35271100E-02  -1.37885000E-03  -1.08682000E-03  +9.76570000E-04
   -1.62370000E-04  +1.78640000E-04  -6.69000000E-05  +2.45431000E-03  -1.17274660E-01
   -3.57161700E-02  +1.25734310E-01  +5.86772220E-01  +2.27400000E-04  +1.82700000E-05
   -1.14340000E-04  -1.95291000E-03  -1.71239000E-03  +8.30000000E-05  -4.90170000E-04
   +9.34100000E-05  -3.23600000E-04  +4.05600000E-04  -3.47960000E-04  -2.59920000E-04
   +4.88590000E-04  -4.28400000E-04  +2.33570000E-04  -4.55890000E-04  +5.79940000E-04
   +1.77350000E-04  -6.36400000E-05  +3.66476000E-03  +4.31991000E-03  -9.78450000E-04
   +5.10310000E-04  +5.10800000E-05  -5.36790000E-04  +3.46880000E-04  -8.78300000E-05
   +1.34723940E-01  -1.37198000E-03  -1.65664400E-01  -2.03465200E-01  +2.18436100E-01
   +4.41294210E-01  +1.63350000E-04  -2.06900000E-05  -1.39880000E-04  -4.54700000E-05
   -5.82730000E-04  -3.28700000E-05  +2.20100000E-05  +2.96000000E-06  +2.61950000E-04
   -3.62700000E-05  +1.01200000E-05  -5.00900000E-05  +2.17230000E-04  -1.46760000E-04
   +7.12800000E-05  -1.22560000E-04  +1.52240000E-04  -9.69000000E-06  -2.29700000E-05
   +4.85590000E-04  +4.62675000E-03  +1.40110000E-04  +8.33200000E-04  +1.88620000E-04
   -2.04360000E-04  +1.21000000E-04  -3.25800000E-05  -3.81102100E-02  -1.36642600E-02
   +2.37954200E-02  -1.97986410E-01  -1.46733950E-01  -1.19645000E-03  +5.79691190E-01
   +6.69050000E-04  -2.43000000E-05  -5.10000000E-04  -8.93220000E-04  -1.66768000E-03
   +3.39150000E-04  -2.33440000E-04  +1.20650000E-04  +4.45660000E-04  +1.99000000E-04
   -1.12570000E-04  -2.37000000E-04  +7.60870000E-04  -8.86790000E-04  +4.30190000E-04
   -6.37770000E-04  +7.69530000E-04  +1.71400000E-05  -6.04380000E-04  +2.82478000E-03
   -1.87520000E-03  -3.60970000E-04  -4.54990000E-04  +5.35900000E-05  -8.62700000E-04
   +6.35300000E-04  -1.53520000E-04  -5.19182400E-02  +2.94813700E-02  +5.20826400E-02
   -9.65493800E-02  -2.36072980E-01  -5.14594900E-02  +1.46880950E-01  +5.55488460E-01
   +3.98120000E-04  -1.60300000E-04  +8.45800000E-05  +7.30220000E-04  +6.91080000E-04
   -6.01400000E-05  +2.65900000E-05  +2.04650000E-04  -1.30660000E-04  +2.07450000E-04
   -1.22280000E-04  -2.04880000E-04  +2.80570000E-04  -1.11330000E-04  +7.34400000E-05
   -1.41460000E-04  +1.10410000E-04  -7.89900000E-05  +4.66462000E-03  -3.27919000E-03
   +1.95292000E-03  -5.27030000E-04  -6.94630000E-04  -1.45310000E-04  -2.40560000E-04
   +1.45410000E-04  -8.03000000E-06  -3.29390000E-03  +2.54754800E-02  +2.64967200E-02
   +3.34443100E-02  -1.59007100E-02  -9.45094200E-02  -2.29269310E-01  +1.93221650E-01
   +4.26493530E-01  -9.90600000E-05  -1.06820000E-04  -7.25000000E-06  -2.67370000E-04
   -5.44800000E-05  -3.47100000E-05  +6.73300000E-05  -7.44000000E-06  +2.74850000E-04
   -1.94850000E-04  +2.39100000E-04  +7.12600000E-05  -1.11033000E-03  +2.76980000E-04
   -4.90200000E-05  +2.89980000E-04  -2.87850000E-04  +6.16500000E-05  -2.27506000E-03
   -4.63870000E-04  +4.83950000E-04  +3.55450000E-04  -8.35200000E-05  -2.22740000E-04
   +9.52910000E-04  -5.24090000E-04  +8.65400000E-05  -2.82097800E-02  +2.60302100E-02
   +3.52679400E-02  +5.03391200E-02  +7.69844000E-03  -2.88619200E-02  -1.29136540E-01
   -1.45382900E-02  +3.38617100E-02  +5.77049280E-01  -6.45760000E-04  +5.25000000E-06
   +3.27190000E-04  +1.87300000E-04  +1.33346000E-03  -2.63890000E-04  +2.20630000E-04
   -2.27660000E-04  -6.08600000E-05  -3.37040000E-04  +2.84970000E-04  +3.60900000E-04
   -1.48925000E-03  +9.90910000E-04  -4.03720000E-04  +7.67600000E-04  -9.19420000E-04
   +3.56000000E-05  -2.68760000E-04  -1.06935000E-03  -9.45110000E-04  +3.92150000E-04
   +6.84500000E-05  -1.08610000E-04  +1.47786000E-03  -9.69180000E-04  +1.98800000E-04
   +2.42859500E-02  -1.44693800E-02  -2.29964900E-02  -3.50823100E-02  -4.67302700E-02
   -9.01460000E-03  +4.56629900E-02  -2.18182830E-01  -1.37295320E-01  +1.35415670E-01
   +5.78225840E-01  -5.13260000E-04  +5.94400000E-05  +2.52000000E-04  +4.10880000E-04
   +7.86540000E-04  -1.57220000E-04  +2.43480000E-04  -9.38000000E-05  -1.62970000E-04
   -1.96760000E-04  +1.43450000E-04  +2.22880000E-04  -3.36540000E-04  +4.30580000E-04
   -2.44900000E-04  +3.82900000E-04  -4.00720000E-04  -1.39000000E-05  +8.78710000E-04
   -2.18680000E-04  -1.47610000E-03  +1.16410000E-04  -1.01550000E-04  +2.26160000E-04
   +3.74090000E-04  -2.82120000E-04  +6.17700000E-05  +3.36105100E-02  -2.45754100E-02
   -4.72999800E-02  -5.96056400E-02  -3.97580000E-02  +1.69228800E-02  +7.57411300E-02
   -9.31820800E-02  -1.89066240E-01  -2.06344380E-01  +1.90367070E-01  +4.44439570E-01
   -2.87900000E-05  +6.18000000E-05  -5.34900000E-05  +2.09000000E-05  -2.80100000E-05
   -2.24100000E-04  +4.17760000E-04  -1.98900000E-04  -1.06250000E-04  -6.23800000E-05
   +1.33560000E-04  +1.58770000E-04  +4.24730000E-04  -1.01280000E-04  +1.51100000E-05
   +1.91700000E-05  +6.59900000E-05  -4.29300000E-05  +2.68692000E-03  +1.23243000E-03
   +3.00830000E-03  +5.54660000E-04  +6.19840000E-04  +3.50250000E-04  -3.81330000E-04
   +2.12860000E-04  -5.05800000E-05  +4.33776200E-02  -3.48293200E-02  -5.16931500E-02
   -5.50577800E-02  -2.65210300E-02  +1.83126900E-02  +1.24576900E-02  +6.04854200E-02
   +3.92317100E-02  -2.32674300E-01  -3.31907300E-02  +9.43969600E-02  +5.49112810E-01
   -6.38260000E-04  +2.81680000E-04  +3.87140000E-04  +8.53440000E-04  +4.63810000E-04
   +2.30250000E-04  +4.09090000E-04  -1.33870000E-04  -1.16180000E-04  -1.43700000E-04
   +3.33100000E-04  +1.03620000E-04  -3.31520000E-04  +9.44600000E-05  -1.12900000E-04
   +2.06670000E-04  -2.27430000E-04  +5.77000000E-06  +1.86033000E-03  +5.61020000E-04
   -5.10859000E-03  -9.60170000E-04  -7.82540000E-04  +3.25530000E-04  +2.42240000E-04
   -1.00640000E-04  +2.40400000E-05  +2.24066000E-03  -4.23127400E-02  -3.69068900E-02
   -2.73697400E-02  -1.66137800E-02  +9.93515000E-03  +2.54594900E-02  +3.13277300E-02
   -2.69499000E-03  +2.48097600E-02  -1.15959860E-01  -4.85700500E-02  +1.46399790E-01
   +6.12300240E-01  -4.01600000E-05  -4.30900000E-05  +1.62490000E-04  +6.41620000E-04
   +2.99190000E-04  +7.81000000E-06  -2.79270000E-04  +1.77280000E-04  -1.11450000E-04
   +4.28100000E-05  -1.15540000E-04  -8.47200000E-05  -3.14690000E-04  +1.55370000E-04
   -2.90300000E-05  +6.54000000E-06  -7.32300000E-05  +4.82100000E-05  +2.83217000E-03
   -3.80857000E-03  -3.09930000E-04  -5.52100000E-04  -6.69560000E-04  +1.15660000E-04
   +3.04460000E-04  -2.29290000E-04  +4.27800000E-05  -2.38764600E-02  -9.51969000E-03
   +1.95427700E-02  +1.83362700E-02  +9.78980000E-03  -9.42688000E-03  +1.49256300E-02
   -2.80040100E-02  -2.17239400E-02  +1.34037670E-01  -6.66136000E-03  -1.73024230E-01
   -2.00162460E-01  +2.28042280E-01  +4.32473130E-01  +9.40550000E-04  -2.45380000E-04
   -5.70340000E-04  -8.02900000E-04  -3.05957000E-03  -1.40491000E-03  -1.42704000E-03
   +1.22080000E-04  -5.45400000E-04  +2.75910000E-04  -4.02060000E-04  -5.83580000E-04
   +9.14800000E-05  -5.64070000E-04  +3.33350000E-04  -5.73680000E-04  +6.35670000E-04
   +1.87220000E-04  +5.68764000E-03  -1.62384800E-02  -1.52319400E-02  -3.53528000E-03
   -3.83798000E-03  +8.24090000E-04  -2.76440000E-04  +2.29750000E-04  -8.57600000E-05
   -1.19262520E-01  +3.27773300E-02  +5.86933100E-02  +1.00411800E-02  +2.77916400E-02
   +1.86506800E-02  -7.74335000E-03  -1.47414300E-02  -7.17085000E-03  -4.02283300E-02
   -1.53402700E-02  +1.99989500E-02  -2.08928490E-01  -1.56998710E-01  -1.89094000E-03
   +6.00282630E-01  +6.27990000E-04  +1.06500000E-05  -5.81980000E-04  +3.03900000E-05
   -1.69335000E-03  -1.01253000E-03  -2.03950000E-04  -3.40070000E-04  +4.69460000E-04
   -4.57900000E-05  +2.90720000E-04  +1.12480000E-04  +9.30000000E-06  -6.31000000E-04
   +2.54190000E-04  -1.53520000E-04  +2.59500000E-04  -1.39060000E-04  -2.51514000E-03
   -2.18650400E-02  -1.51578700E-02  -3.08531000E-03  -1.82259000E-03  +8.89440000E-04
   -2.18970000E-04  +2.66240000E-04  -9.53600000E-05  -1.56584100E-02  -2.17506750E-01
   -8.83301800E-02  +6.57479100E-02  +3.12944300E-02  -3.07586600E-02  -1.80265000E-02
   -5.80449700E-02  -2.49437500E-02  -5.78323700E-02  +3.10416900E-02  +6.12360400E-02
   -1.06558910E-01  -2.52886650E-01  -5.68946300E-02  +1.51463700E-01  +5.58999450E-01
   +8.04390000E-04  -5.83000000E-06  -7.42060000E-04  -7.11710000E-04  -1.27305000E-03
   +1.23180000E-04  -7.81500000E-04  -5.24460000E-04  -7.30700000E-05  +1.02410000E-04
   -3.13800000E-05  +5.10720000E-04  +4.58310000E-04  -8.03600000E-05  +1.34620000E-04
   -1.82200000E-04  -6.38300000E-05  -1.63200000E-04  -5.08719000E-03  -3.03194000E-03
   +3.02595000E-03  +9.01430000E-04  +4.35970000E-04  +3.26600000E-05  -2.39670000E-04
   +1.03780000E-04  -1.16900000E-05  +2.31922500E-02  -1.24259710E-01  -1.73320470E-01
   +4.55163000E-02  -3.49544000E-03  -2.65195700E-02  -9.53751000E-03  -2.79515100E-02
   -1.60506100E-02  -9.98510000E-03  +3.11424700E-02  +3.10542300E-02  +3.33227200E-02
   -2.04539900E-02  -9.87674300E-02  -2.16112920E-01  +1.76121170E-01  +4.20708710E-01
   +5.36350000E-04  +6.24700000E-05  -3.31060000E-04  -8.88600000E-05  -9.81090000E-04
   +1.53320000E-04  -1.44400000E-04  +6.62600000E-05  -2.99000000E-06  +2.74680000E-04
   -2.09130000E-04  -2.37000000E-04  +1.44951000E-03  -8.43870000E-04  +3.26930000E-04
   -6.53060000E-04  +7.63910000E-04  -5.26200000E-05  +1.19263000E-03  +8.98310000E-04
   +3.62180000E-04  -4.94780000E-04  -7.42800000E-05  +2.50220000E-04  -1.40497000E-03
   +8.79050000E-04  -1.78700000E-04  +9.39350000E-04  -3.59913000E-03  -5.22970000E-03
   -1.91847000E-03  -2.31029000E-03  +5.32661000E-03  +4.21088000E-03  -5.92674000E-03
   -6.48200000E-05  -1.66238750E-01  -1.31414270E-01  -2.18868000E-03  -3.73478000E-02
   -4.34354800E-02  +2.20495000E-03  +1.51354000E-03  +6.20330000E-03  +6.75206000E-03
   +5.19669470E-01  +6.52280000E-04  +7.18400000E-05  -3.92290000E-04  -7.29300000E-05
   -1.26843000E-03  +1.87450000E-04  -1.86000000E-04  +9.24300000E-05  +8.96000000E-06
   +3.43610000E-04  -2.11860000E-04  -3.18780000E-04  +1.65791000E-03  -1.16285000E-03
   +4.52270000E-04  -8.14100000E-04  +9.90380000E-04  -6.36700000E-05  +1.36671000E-03
   +7.66560000E-04  +1.23069000E-03  -5.83800000E-04  -1.48350000E-04  +2.76800000E-04
   -1.67315000E-03  +1.13777000E-03  -2.33830000E-04  -2.80587000E-03  -1.44847000E-03
   +6.88420000E-04  +3.61028000E-03  +3.23031000E-03  -5.79651000E-03  -3.44865900E-02
   -3.89809700E-02  -8.67457000E-03  -9.38590500E-02  -2.20700990E-01  -5.42007900E-02
   -1.48911300E-02  -2.04665000E-03  +4.32565000E-03  +1.09546000E-03  +2.33860000E-04
   -4.06218000E-03  +1.20988320E-01  +3.03819620E-01  +3.08900000E-05  +3.01600000E-05
   +1.19000000E-06  -4.46400000E-05  -1.41020000E-04  +1.15670000E-04  -3.89600000E-05
   +4.42700000E-05  -3.42900000E-05  +6.63000000E-05  -5.05500000E-05  -8.68000000E-05
   +1.03980000E-04  -5.82300000E-05  +2.38400000E-05  -7.69800000E-05  +6.93700000E-05
   +2.02400000E-05  -3.42790000E-04  +3.74010000E-04  -6.42600000E-05  -1.19400000E-05
   -2.11300000E-05  -2.23400000E-05  -1.03930000E-04  +5.41900000E-05  -2.56000000E-06
   -3.67967000E-03  +2.45450000E-03  +3.03514000E-03  +9.73114000E-03  -1.45240000E-03
   -2.02940000E-04  -2.00490600E-02  -2.97424800E-02  +3.66354000E-03  +2.32619100E-02
   -2.75587800E-02  -7.93143800E-02  +2.18940100E-02  +2.50260100E-02  +8.61006000E-03
   +3.16281000E-03  -7.71945000E-03  -2.81435000E-03  -2.68571370E-01  +1.03338070E-01
   +2.89685100E-01  -2.15826000E-03  +6.23490000E-04  -9.53370000E-04  -6.28908000E-03
   +1.82174200E-02  -2.79436000E-02  -5.84223000E-03  +1.16185000E-03  +1.05549000E-03
   +3.64510000E-04  +9.68740000E-04  -1.74106000E-03  +8.20420000E-04  -3.72570000E-04
   +6.50000000E-07  -2.48300000E-05  +9.39000000E-04  -5.87040000E-04  -7.72784100E-02
   +5.44963000E-03  -9.49152000E-03  +1.06316000E-03  -2.73175000E-03  +4.81519000E-03
   -9.02070000E-04  +5.42600000E-04  -6.57200000E-05  +7.57790000E-04  -1.27770700E-02
   +1.83036500E-02  -5.19430000E-04  -1.66446000E-03  -4.59340000E-04  -1.01901000E-03
   -1.47260000E-04  -1.11715000E-03  +2.38640000E-04  +7.79820000E-04  +4.11590000E-04
   -3.24590000E-04  +4.39110000E-04  +5.98300000E-05  -1.59430000E-04  -6.54420000E-04
   +4.93700000E-04  -8.21710000E-04  -1.06278000E-03  -5.09400000E-05  +5.81044370E-01
   +2.47930000E-04  -5.28410000E-04  -4.04550000E-04  +6.99546000E-03  -8.42273000E-03
   +1.14029600E-02  +1.66244000E-03  +5.53490000E-04  -5.40600000E-05  -1.47200000E-04
   -1.23950000E-04  +4.21100000E-04  +1.62460000E-04  -1.82690000E-04  +3.02490000E-04
   -3.98970000E-04  -4.24840000E-04  +2.48970000E-04  +8.83145000E-03  -1.02242110E-01
   +4.67026200E-02  -1.95496000E-03  +9.75729000E-03  -1.56786400E-02  -1.07040000E-04
   +4.08800000E-05  -1.03470000E-04  -3.99143000E-03  -2.33414000E-02  +2.35744600E-02
   +1.71985000E-03  -9.80960000E-04  -6.13250000E-04  -8.45970000E-04  -5.21460000E-04
   -1.39341000E-03  -8.33800000E-05  +9.08730000E-04  +7.23270000E-04  -1.94940000E-04
   +8.94420000E-04  -1.29340000E-04  -5.31120000E-04  -6.63190000E-04  +1.26958000E-03
   -6.40890000E-04  -9.19560000E-04  -7.33100000E-05  +1.11504800E-02  +5.48906790E-01
   +9.54940000E-04  -2.21060000E-04  +7.27300000E-05  -5.24741000E-03  +2.77739000E-03
   -2.84622000E-03  +1.22317000E-03  -6.84220000E-04  +3.53150000E-04  +6.49100000E-05
   -1.72480000E-04  +1.98720000E-04  -1.61190000E-04  +4.46850000E-04  -2.14580000E-04
   +5.09460000E-04  -3.15480000E-04  -2.81300000E-05  -1.29994900E-02  +4.19104600E-02
   -1.42798840E-01  -2.13317000E-03  +1.16245700E-02  -3.72876900E-02  +3.68000000E-04
   -2.61140000E-04  +9.71100000E-05  +5.61533000E-03  +9.36566000E-03  -1.63701000E-03
   -8.27130000E-04  -4.79430000E-04  -6.79600000E-05  -8.73000000E-05  -4.11570000E-04
   -2.27400000E-04  -6.41500000E-05  +4.16440000E-04  +5.21890000E-04  +3.99970000E-04
   +8.89500000E-05  -1.87370000E-04  -1.29226000E-03  -1.67837000E-03  -3.03760000E-04
   -4.46800000E-04  -5.70100000E-04  -1.08740000E-04  -2.04089300E-02  +5.85415400E-02
   +5.05461990E-01  -8.92513000E-03  +4.57622000E-03  -2.58904000E-03  +5.25855000E-03
   -6.78468000E-03  +2.70861000E-03  -2.64046900E-02  +1.44519100E-02  +4.52507400E-02
   -8.24183700E-02  +2.98314300E-02  +6.80411800E-02  -3.24751300E-02  +3.39643400E-02
   -1.90203300E-02  -1.71031000E-03  -1.97606500E-02  +8.74813000E-03  -7.01000000E-06
   +5.14080000E-04  -1.25301000E-03  +2.37650000E-04  -2.74340000E-04  +8.80250000E-04
   -6.26691300E-02  -3.01082700E-02  +1.97817200E-02  +3.01070000E-04  -1.19160000E-04
   -1.62600000E-05  +2.59610000E-04  +2.36470000E-04  -2.55740000E-04  -2.67000000E-06
   -1.14120000E-04  -2.24590000E-04  +6.44880000E-04  +6.15020000E-04  +7.63100000E-05
   -2.05500000E-04  +8.49300000E-05  +1.79650000E-04  +1.32950000E-04  +3.79320000E-04
   -1.13420000E-04  -6.33530000E-04  -6.92430000E-04  -6.44200000E-05  -5.11220000E-04
   +1.24720000E-04  -1.32920000E-04  +2.86921550E-01  -1.74582000E-03  +1.29678000E-03
   -1.85590000E-03  -2.14365000E-03  -3.51773000E-03  +2.04171000E-03  +1.58542800E-02
   +3.63160000E-03  -3.32184200E-02  +3.91275800E-02  -9.81677500E-02  -2.74199800E-02
   +5.90478000E-02  -8.89610000E-02  -1.86415700E-02  -4.66037300E-02  -3.82738000E-02
   +1.47120500E-02  -7.06140000E-04  +1.04053000E-03  -8.92940000E-04  +6.40990000E-04
   -1.36230000E-04  +2.75500000E-04  -3.71160100E-02  +3.33194800E-02  +2.62840000E-03
   +1.25110000E-04  -4.59170000E-04  +1.15900000E-05  +4.57500000E-05  +2.36000000E-04
   +1.45940000E-04  +2.06500000E-05  +1.90700000E-04  +7.28000000E-05  -2.84550000E-04
   -4.23850000E-04  -7.73100000E-05  +1.57370000E-04  +5.22800000E-05  -1.94350000E-04
   +8.63600000E-05  +5.53700000E-05  -1.10980000E-04  +4.12500000E-04  +5.75140000E-04
   +1.75900000E-05  +1.18410000E-04  +9.75500000E-05  -5.80400000E-05  -8.07243500E-02
   +2.77251040E-01  +2.44555200E-02  -5.28300000E-03  -3.96704000E-03  -1.09168500E-02
   -1.01423200E-02  +8.97316000E-03  +1.12038700E-02  +2.57486000E-03  -2.37441900E-02
   +8.19538500E-02  -2.14273500E-02  -1.87585620E-01  -2.24846800E-02  -3.61431900E-02
   -2.53725900E-02  -2.38175000E-03  +3.09595100E-02  -6.18036000E-03  -3.45430000E-04
   +9.08160000E-04  +2.13442000E-03  -7.30960000E-04  +5.03480000E-04  -7.83130000E-04
   +1.67773500E-02  +5.33490000E-03  +4.64047000E-03  -2.10410000E-04  +1.20460000E-04
   +8.93900000E-05  -9.79700000E-05  +7.33300000E-05  +2.34190000E-04  -8.13800000E-05
   -6.72000000E-05  +1.79100000E-04  -2.41060000E-04  -2.21720000E-04  -3.29500000E-05
   +4.51000000E-05  +7.44500000E-05  -4.74700000E-05  +2.46930000E-04  -2.90490000E-04
   -5.14450000E-04  +2.24820000E-04  +2.75560000E-04  +7.11000000E-05  +4.58540000E-04
   -8.60300000E-05  +8.09600000E-05  -1.25211590E-01  +2.31861900E-02  +2.76857390E-01
   -1.15150000E-04  +3.87000000E-06  +5.31800000E-05  +4.31500000E-05  +1.79650000E-04
   -3.95300000E-05  +4.83300000E-05  -3.46000000E-05  +2.93100000E-05  -6.32200000E-05
   +6.95900000E-05  +6.50500000E-05  -2.73020000E-04  +1.19010000E-04  -4.95300000E-05
   +1.23110000E-04  -1.33750000E-04  +3.60000000E-06  -1.39360000E-04  -1.28430000E-04
   -1.56110000E-04  +7.01400000E-05  +1.47200000E-05  -2.18000000E-05  +2.52190000E-04
   -1.32130000E-04  +2.58400000E-05  +6.05020000E-04  -8.17800000E-05  -3.03580000E-04
   -1.07908000E-03  +5.25100000E-05  +3.43860000E-04  +4.20134000E-03  +3.84560000E-03
   -1.02451000E-03  -2.82327700E-02  +2.27775000E-03  +1.99572200E-02  -3.87090000E-04
   -4.86013000E-03  -1.51997000E-03  -2.38380000E-04  +5.57860000E-04  +1.73495000E-03
   -3.21828360E-01  +1.91982700E-02  +2.39942400E-01  +1.22510000E-04  +1.00880000E-04
   +6.07000000E-05  +1.28690000E-04  -4.77300000E-05  -5.73800000E-05  +3.46704660E-01
   -6.99700000E-05  -1.37800000E-05  +3.08600000E-05  -4.13000000E-06  +9.39200000E-05
   -4.06900000E-05  +3.08500000E-05  -8.21000000E-06  +2.50000000E-06  -3.98100000E-05
   +3.21600000E-05  +3.25600000E-05  -2.14180000E-04  +1.32330000E-04  -4.56900000E-05
   +8.92700000E-05  -1.04860000E-04  +1.68500000E-05  -3.90000000E-06  -1.20670000E-04
   -7.75500000E-05  +4.40100000E-05  +4.32400000E-05  +1.18000000E-06  +2.06940000E-04
   -1.41870000E-04  +2.79900000E-05  +5.28800000E-04  -1.73320000E-04  -5.49770000E-04
   -2.21690000E-04  -6.65060000E-04  +1.98960000E-04  -9.70840000E-04  +1.27073000E-03
   +2.21657000E-03  -3.32303300E-02  -4.17150000E-04  +2.51850600E-02  -3.63220000E-03
   -4.52963000E-03  -1.97946000E-03  -9.40360000E-04  +1.50396000E-03  +5.93660000E-04
   +5.74685000E-02  -4.30067500E-02  -6.78945800E-02  +3.45000000E-05  +3.01600000E-05
   +1.73200000E-05  +9.74200000E-05  -7.62300000E-05  -3.27700000E-05  -2.01747000E-02
   +4.71041100E-02  -5.25000000E-06  +9.29000000E-06  -6.51000000E-06  +2.25700000E-05
   -3.07800000E-05  -1.44500000E-05  +6.88000000E-06  -9.85000000E-06  +2.42100000E-05
   -7.04000000E-06  +1.54200000E-05  +9.91000000E-06  +3.14200000E-05  -5.56400000E-05
   +1.89000000E-05  -1.77900000E-05  +3.06000000E-05  -9.09000000E-06  +1.04860000E-04
   +3.60100000E-05  +2.98700000E-05  -3.20500000E-05  -4.24000000E-06  +2.75300000E-05
   -4.24700000E-05  +4.54900000E-05  -1.34700000E-05  -3.61600000E-05  -1.54380000E-04
   -1.22070000E-04  +1.01870000E-04  -1.02000000E-06  -7.96440000E-04  -4.34256000E-03
   -1.25656000E-03  +1.39506000E-03  -4.13785000E-03  -2.63100000E-05  +3.77100000E-04
   -7.54200000E-04  -1.09760000E-03  +1.95783000E-03  +7.64130000E-04  -4.26680000E-04
   +7.77950000E-04  +2.65955500E-01  -4.07272500E-02  -2.21135350E-01  -5.94500000E-05
   -7.26000000E-05  -4.19100000E-05  -6.80000000E-07  +2.97500000E-05  -1.17800000E-05
   -2.58033130E-01  +4.36898100E-02  +2.18046740E-01  +5.31000000E-06  +4.89900000E-05
   -6.04100000E-05  +2.24300000E-05  -2.42640000E-04  +6.77800000E-05  -3.29100000E-05
   -8.11000000E-06  +5.11200000E-05  -9.30000000E-06  +2.14000000E-06  -2.85500000E-05
   +1.73210000E-04  -1.36060000E-04  +4.43500000E-05  -7.97300000E-05  +9.93000000E-05
   -7.86000000E-06  -1.80680000E-04  +5.15000000E-04  +7.45810000E-04  -7.08700000E-05
   +5.27500000E-05  +4.28800000E-05  -1.83560000E-04  +1.26430000E-04  -3.03800000E-05
   +8.79030000E-04  -5.06766000E-03  +8.46430000E-04  -1.27179900E-02  +2.38470000E-03
   +1.24487100E-02  -2.31987100E-01  -7.68084000E-03  +1.40287190E-01  -3.81990000E-03
   -4.99380000E-03  +2.36268000E-03  +2.77100000E-03  -1.24700000E-05  +2.10988000E-03
   +8.09600000E-05  -2.22000000E-06  -8.05780000E-04  +1.61766000E-03  +1.97409000E-03
   -2.80477000E-03  -1.79900000E-04  -1.28950000E-04  -1.01510000E-04  -4.60700000E-05
   +6.72000000E-05  +8.37000000E-06  +3.90300000E-05  +1.02879000E-03  +1.10923000E-03
   +2.44540210E-01  +8.05000000E-06  +3.64500000E-05  -5.40100000E-05  -1.70170000E-04
   -3.77930000E-04  +4.39300000E-05  -1.21000000E-05  -1.78300000E-05  +1.24700000E-05
   +1.39900000E-05  +1.73000000E-06  -2.46500000E-05  +1.04010000E-04  -1.13970000E-04
   +4.48200000E-05  -7.93300000E-05  +1.03800000E-04  +2.01700000E-05  -6.99070000E-04
   +5.73800000E-04  +4.94460000E-04  +2.31700000E-05  +7.71600000E-05  +7.51300000E-05
   -1.24660000E-04  +8.30100000E-05  -2.16000000E-05  -4.41257000E-03  -1.82167000E-03
   -2.64135000E-03  -1.97987600E-02  +3.92841000E-03  +1.57375800E-02  -7.61065000E-03
   -5.36977800E-02  -9.28862000E-03  +1.85602000E-02  +4.25154000E-03  -1.35295100E-02
   -5.06180000E-04  -2.04853000E-03  -4.98832000E-03  -2.56850000E-04  -1.52450000E-03
   -1.84050000E-04  +2.54698000E-03  +1.42047000E-03  +2.02647000E-03  -1.05400000E-04
   -1.19400000E-05  -8.31500000E-05  -1.93600000E-05  +4.01100000E-05  +1.68100000E-05
   -1.12212000E-03  -7.22640000E-04  -1.08480000E-04  +1.09450200E-02  +5.01951100E-02
   -4.94500000E-05  +3.19000000E-06  +3.59000000E-05  +1.24670000E-04  +1.32640000E-04
   -1.43000000E-05  +1.86000000E-06  +4.07000000E-06  +2.44900000E-05  -3.00700000E-05
   +1.67200000E-05  -6.80000000E-06  -9.30400000E-05  +4.84400000E-05  -2.41800000E-05
   +5.17000000E-05  -5.69500000E-05  -5.94000000E-06  -2.33100000E-05  -1.91310000E-04
   +3.07770000E-04  +4.40000000E-06  +5.11500000E-05  -4.83800000E-05  +8.68100000E-05
   -4.39900000E-05  +1.04200000E-05  +1.04313000E-03  -2.32422000E-03  +4.41485000E-03
   -2.89660000E-03  -4.39980000E-04  +3.89943000E-03  +1.40351270E-01  -9.24285000E-03
   -1.41459070E-01  +1.88117000E-02  +3.71484000E-03  -6.93819000E-03  +1.72949000E-03
   -5.40397000E-03  +6.47270000E-04  -1.05098000E-03  -3.96270000E-04  -5.39070000E-04
   -2.39630000E-03  +2.40647000E-03  -6.96980000E-04  +2.99000000E-06  -6.45700000E-05
   -1.10700000E-05  +4.20700000E-05  -1.15800000E-05  -7.26000000E-06  -4.18800000E-04
   -1.66822000E-03  -3.07170000E-04  -1.54253640E-01  +1.11608600E-02  +1.43246860E-01
   -3.22300000E-05  -3.19100000E-05  -8.67300000E-05  -2.06050000E-04  -2.37570000E-04
   -1.77740000E-04  +1.12900000E-05  -6.84300000E-05  +1.84470000E-04  -7.22500000E-05
   +2.91100000E-05  +3.75600000E-05  -1.13500000E-04  +6.52300000E-05  -1.35100000E-05
   +5.14000000E-05  -1.84500000E-05  +2.90100000E-05  +1.35200000E-05  +1.89791000E-03
   -1.46737000E-03  -4.52840000E-04  -2.55200000E-04  +5.06670000E-04  +1.15690000E-04
   -8.09800000E-05  +5.63000000E-06  +1.14681000E-03  +1.92186700E-02  +1.58082600E-02
   -6.49916000E-02  +3.64367900E-02  +4.48394800E-02  +7.13686000E-03  -1.58915300E-02
   -1.36541600E-02  -2.90760000E-04  -4.85799000E-03  +2.34869000E-03  -1.21249000E-03
   -4.10740000E-04  -2.68850000E-04  -2.70253000E-03  -1.98542000E-03  +5.56424000E-03
   +5.93200000E-05  -9.79090000E-04  -7.12930000E-04  +3.30400000E-04  +8.49800000E-05
   -7.91600000E-05  +1.11170000E-04  -8.03700000E-05  -1.12370000E-04  +1.27350000E-04
   +5.57100000E-05  -8.02800000E-05  -4.42150000E-04  +1.48703000E-03  -1.70599000E-03
   +6.25287300E-02  +3.96600000E-05  -7.63500000E-05  +9.03400000E-05  +2.23460000E-04
   +4.29280000E-04  -2.65980000E-04  +2.79600000E-05  +5.02300000E-05  -1.26640000E-04
   +4.56300000E-05  -6.07900000E-05  -1.53900000E-05  -7.41100000E-05  +1.76040000E-04
   -6.74800000E-05  +8.03400000E-05  -9.16400000E-05  +4.87000000E-06  +9.51620000E-04
   -1.61522000E-03  +1.02990000E-03  -1.89788000E-03  -7.09370000E-04  +2.66100000E-04
   +1.17530000E-04  -1.03240000E-04  +3.03600000E-05  +1.63420000E-04  +4.47988000E-03
   -1.83950000E-04  +3.65261500E-02  -2.03611150E-01  -1.42145320E-01  +6.09314000E-03
   -1.36791000E-02  -1.62749400E-02  -5.10663000E-03  +9.62400000E-05  -1.46925000E-03
   -2.96530000E-04  -1.78510000E-04  +9.23810000E-04  -1.80646000E-03  +2.73372000E-03
   -1.63945000E-03  -1.01170000E-04  -1.27986000E-03  -8.90690000E-04  -2.62710000E-04
   -2.86160000E-04  +1.51800000E-05  -6.07100000E-05  -3.02000000E-05  +7.50900000E-05
   +2.36010000E-04  +6.76100000E-05  -8.24800000E-05  +1.09087000E-03  -3.12760000E-04
   +1.90260000E-03  -3.46841700E-02  +2.15889660E-01  -3.93000000E-05  +6.64400000E-05
   -4.40700000E-05  -2.94890000E-04  -1.94340000E-04  +1.79290000E-04  -9.15000000E-06
   -5.66200000E-05  +6.02100000E-05  -2.53700000E-05  +6.36200000E-05  +1.65900000E-05
   -1.39100000E-05  -1.42820000E-04  +4.95300000E-05  -3.43900000E-05  +6.74600000E-05
   -1.59000000E-06  -2.15379000E-03  +2.53860000E-04  -2.19040000E-03  -4.53850000E-04
   -1.05126000E-03  +4.95820000E-04  -4.49900000E-05  +7.01100000E-05  -1.95300000E-05
   +2.21718000E-03  -1.42091600E-02  -7.06582000E-03  +4.53319400E-02  -1.42180810E-01
   -1.70324830E-01  +1.56727000E-03  -4.15870000E-04  +2.04256000E-03  +2.09833000E-03
   -1.65815000E-03  +4.84777000E-03  -1.35480000E-04  +1.02457000E-03  -3.76930000E-04
   +5.58788000E-03  -1.37433000E-03  +1.90552000E-03  -7.13700000E-05  -2.27750000E-04
   -5.58400000E-05  +6.40000000E-04  +3.83650000E-04  +4.23000000E-05  +6.98400000E-05
   +4.05300000E-05  -3.29000000E-05  +3.71800000E-05  +4.10900000E-05  -4.30300000E-05
   -1.96972000E-03  +1.61172000E-03  -1.60650000E-03  -5.06927300E-02  +1.57698240E-01
   +1.73103460E-01  -2.88390000E-04  -8.72200000E-05  -4.07600000E-05  -2.14830000E-04
   -7.76310000E-04  -6.03570000E-04  -9.77500000E-05  -2.59150000E-04  -1.65530000E-04
   +1.68900000E-04  +5.44000000E-06  +1.24400000E-05  -2.84890000E-04  -8.54900000E-05
   +5.22800000E-05  -2.22600000E-05  -6.17300000E-05  -3.93800000E-05  -1.25559000E-03
   +3.21500000E-05  -1.19753000E-03  -7.27800000E-05  +1.03670000E-04  -1.11250000E-04
   +1.79360000E-04  -5.76900000E-05  -2.29000000E-06  -1.03522000E-03  -6.65180000E-04
   +3.09485000E-03  +2.52198000E-03  -3.92910000E-04  +2.21315000E-03  +9.22100000E-05
   -7.66400000E-05  -9.19130000E-04  +1.68085000E-03  -4.58978000E-03  +1.47666000E-03
   -1.16474100E-02  +1.42162000E-03  +1.24600200E-02  -2.41804250E-01  -4.06132000E-03
   +1.37972210E-01  -9.78060000E-04  -3.17500000E-05  +6.44460000E-04  -3.58700000E-05
   +6.51600000E-05  +1.96930000E-04  +1.90930000E-04  -8.38800000E-05  +4.64400000E-05
   -2.03770000E-04  -1.20560000E-04  -1.03220000E-04  -2.38150000E-04  +1.55530000E-04
   -1.96520000E-04  -7.13100000E-05  -1.17020000E-04  +6.17100000E-05  +2.53522860E-01
   -4.07120000E-04  -1.08440000E-04  +1.43260000E-04  -2.03600000E-04  -2.06180000E-04
   -2.32770000E-04  -2.71390000E-04  +2.95680000E-04  -4.25650000E-04  +1.49020000E-04
   -1.85280000E-04  +3.07220000E-04  -1.61920000E-04  +5.25200000E-04  -1.51940000E-04
   +5.39000000E-05  -2.55220000E-04  +9.12800000E-05  +1.22899000E-03  -3.19220000E-04
   +9.60240000E-04  +7.77900000E-05  +1.08810000E-04  +5.15700000E-05  +3.51000000E-04
   -3.49750000E-04  +8.36800000E-05  +1.97568600E-02  +5.70460000E-03  -1.30918200E-02
   -8.96940000E-04  -2.15899000E-03  -5.23927000E-03  -1.12710000E-04  -1.09090000E-03
   +6.12300000E-05  -4.45925000E-03  -1.35880000E-03  -3.55346000E-03  -2.10361400E-02
   +3.72130000E-03  +1.44719400E-02  -3.70009000E-03  -5.58513900E-02  -7.64913000E-03
   -1.07274000E-03  +1.39930000E-04  +8.43310000E-04  +2.28900000E-05  -5.55180000E-04
   -3.56190000E-04  -1.27700000E-04  -3.32470000E-04  -2.36440000E-04  -2.15440000E-04
   -3.27640000E-04  +8.54900000E-05  +2.01170000E-04  -1.00290000E-04  +2.72280000E-04
   +1.13211000E-03  +7.78200000E-05  -7.25350000E-04  +8.07110000E-03  +5.32492800E-02
   -9.07130000E-04  +2.33060000E-04  +3.95530000E-04  +7.80400000E-05  -5.18400000E-05
   +3.04400000E-05  +6.67600000E-05  +4.16200000E-05  -3.15770000E-04  -7.11100000E-05
   +1.05560000E-04  -2.47440000E-04  -6.31160000E-04  +2.61040000E-04  -1.69490000E-04
   +3.30410000E-04  -3.59990000E-04  +3.00700000E-05  -2.29020000E-04  +1.77120000E-03
   -1.54233000E-03  -2.41280000E-04  -3.22300000E-05  -3.24600000E-05  +5.63820000E-04
   -2.95250000E-04  +6.93000000E-05  +1.70740500E-02  +1.02177000E-03  -6.84086000E-03
   +2.39339000E-03  -5.58086000E-03  +8.55610000E-04  -1.06676000E-03  -1.39410000E-04
   -4.71140000E-04  +1.59560000E-03  -3.31389000E-03  +5.15637000E-03  -2.44777000E-03
   -1.34184000E-03  +5.19187000E-03  +1.36895700E-01  -7.07572000E-03  -1.40990390E-01
   +8.62700000E-05  +1.77490000E-04  +8.26300000E-05  +1.03000000E-05  +5.16600000E-05
   -9.74000000E-06  +2.00830000E-04  -8.67600000E-05  +1.95610000E-04  -1.64790000E-04
   +2.51700000E-05  -8.37900000E-05  -1.91720000E-04  +2.93230000E-04  -3.66640000E-04
   +8.79800000E-04  +1.56800000E-04  -5.52260000E-04  -1.52263500E-01  +1.14568000E-02
   +1.41507710E-01  +1.83000000E-05  +1.38700000E-05  -1.28800000E-05  +5.93600000E-05
   -3.16000000E-06  +5.85000000E-06  +2.13000000E-06  -2.87700000E-05  +3.22100000E-05
   +3.84600000E-05  +3.45500000E-05  -6.63400000E-05  -2.13400000E-05  -1.44190000E-04
   +5.05700000E-05  -3.85600000E-05  +6.93200000E-05  -1.99000000E-06  +6.37530000E-04
   -5.26790000E-04  -6.19240000E-04  -2.48880000E-04  -1.42360000E-04  +6.62700000E-05
   -4.08300000E-05  +8.63800000E-05  -1.51300000E-05  -2.74380000E-04  -5.10176000E-03
   +2.39850000E-03  -1.40754000E-03  -6.04400000E-04  -1.26820000E-04  -2.75049000E-03
   -1.88886000E-03  +4.60814000E-03  +1.35198000E-03  +2.07023000E-02  +1.68795500E-02
   -6.29508000E-02  +3.10542900E-02  +4.08788200E-02  +7.83994000E-03  -1.53110100E-02
   -1.41255900E-02  +7.73390000E-04  +9.67800000E-04  -2.30237000E-03  +1.40900000E-05
   +7.27000000E-05  -8.52300000E-05  +3.15600000E-05  +9.38000000E-05  +5.98900000E-05
   +1.68530000E-04  +8.82300000E-05  -4.37310000E-04  -2.12190000E-04  +1.03117000E-03
   +8.55900000E-04  -1.32140000E-04  +2.00720000E-04  -3.03550000E-04  -4.73210000E-04
   +1.72300000E-03  -1.89982000E-03  +5.76684100E-02  +2.12800000E-05  +2.36400000E-05
   -5.02000000E-06  +1.77060000E-04  -5.64000000E-05  +4.04900000E-05  -1.06000000E-05
   +2.50300000E-05  +1.20900000E-05  +2.73700000E-05  -1.30400000E-05  -7.83500000E-05
   +7.79800000E-05  -8.89100000E-05  +2.93800000E-05  -5.66600000E-05  +7.08400000E-05
   +1.22400000E-05  +5.18580000E-04  -2.32160000E-04  -8.63670000E-04  -2.90070000E-04
   -2.64730000E-04  +1.19190000E-04  -1.02990000E-04  +7.06600000E-05  -1.14400000E-05
   -5.25000000E-03  +1.12600000E-05  -1.58383000E-03  -2.78490000E-04  -8.73700000E-05
   +8.05970000E-04  -1.47017000E-03  +2.17687000E-03  -1.16548000E-03  -2.60862000E-03
   +2.88306000E-03  +3.55860000E-04  +3.23578300E-02  -2.12163690E-01  -1.44848110E-01
   +6.31469000E-03  -1.27856900E-02  -1.53487100E-02  +1.31617000E-03  -1.94500000E-05
   +1.37473000E-03  -5.25200000E-05  -1.82000000E-05  -6.07400000E-05  -2.72000000E-05
   +4.57900000E-05  +6.41900000E-05  +1.56540000E-04  -9.86400000E-05  +1.75390000E-04
   -3.22800000E-05  +1.56650000E-04  +1.68090000E-04  +2.32550000E-04  -2.23850000E-04
   +1.91090000E-04  +1.20406000E-03  -4.51620000E-04  +2.13177000E-03  -3.22718700E-02
   +2.21249080E-01  +5.81800000E-05  +6.07000000E-06  -6.01600000E-05  -1.00980000E-04
   -7.22100000E-05  -5.09000000E-06  +2.06300000E-05  -5.86700000E-05  +4.08600000E-05
   +2.42400000E-05  +5.56500000E-05  -1.27400000E-05  +3.49400000E-05  -1.59900000E-04
   +6.92300000E-05  -5.19600000E-05  +8.55900000E-05  -1.86000000E-05  +3.55740000E-04
   -3.36100000E-05  +1.02110000E-04  -5.88300000E-05  +4.33300000E-05  +1.78200000E-05
   -7.94600000E-05  +1.11820000E-04  -2.82100000E-05  +2.13670000E-03  -2.04067000E-03
   +4.92191000E-03  +1.09700000E-05  +1.02127000E-03  -2.67440000E-04  +4.91708000E-03
   -8.07300000E-04  +1.28515000E-03  +1.06037000E-03  -1.63577900E-02  -6.96734000E-03
   +4.15735300E-02  -1.43943570E-01  -1.64794720E-01  +7.72110000E-04  +4.45610000E-04
   +2.63962000E-03  -2.16017000E-03  +1.52756000E-03  -7.55650000E-04  -2.29900000E-05
   +6.31000000E-06  -5.77800000E-05  +2.27000000E-06  +9.56000000E-05  +1.44600000E-05
   -3.88780000E-04  +2.26290000E-04  -9.73200000E-05  +9.62000000E-05  -6.04640000E-04
   -5.36430000E-04  -2.86160000E-04  +2.17080000E-04  -3.88430000E-04  -2.08792000E-03
   +1.77651000E-03  -2.05083000E-03  -4.57742000E-02  +1.58521070E-01  +1.67014700E-01
   -3.58280000E-04  +2.21620000E-04  -4.71070000E-04  +5.06320000E-04  -4.26830000E-04
   -5.96570000E-04  +1.41700000E-05  +2.12500000E-05  -1.88000000E-05  +5.21500000E-05
   -8.96000000E-05  +3.03000000E-05  -1.30550000E-04  +2.25590000E-04  -3.74100000E-05
   -1.39500000E-05  -1.42130000E-04  +1.92070000E-04  -6.27110000E-04  -2.88915000E-03
   -4.06622000E-03  -1.97010000E-04  +4.37750000E-04  -7.81780000E-04  +2.08910000E-04
   -1.92100000E-04  +2.47000000E-05  -1.11890000E-04  +4.29300000E-04  +3.36680000E-04
   -2.29920000E-04  -1.37140000E-04  +1.25210000E-04  +1.23420000E-04  +1.32760000E-04
   +4.97200000E-05  +5.50800000E-05  -1.27170000E-04  -8.78400000E-05  -2.83140000E-04
   -1.12100000E-04  -4.23900000E-05  +5.76800000E-05  -2.76100000E-05  -1.27090000E-04
   +1.17200000E-05  +2.79500000E-05  -5.26000000E-06  -5.94569700E-02  +3.10123500E-02
   +4.81360400E-02  +1.90000000E-06  -1.01940000E-04  +2.02600000E-05  -3.73000000E-06
   -1.13500000E-05  +9.37000000E-06  -1.80000000E-06  +7.09000000E-06  -7.69000000E-06
   +3.27400000E-05  +1.73600000E-05  -7.70800000E-05  +2.06580000E-04  +3.07700000E-05
   +4.28800000E-05  +1.45800000E-05  -1.42000000E-05  +1.31500000E-05  +6.16829900E-02
   +6.46330000E-04  +5.89650000E-04  -1.47070000E-04  -2.56630000E-04  +5.00610000E-04
   -2.37950000E-04  -3.28940000E-04  -5.53600000E-05  -1.26960000E-04  +1.86400000E-05
   +4.87000000E-06  +1.72200000E-05  +6.56300000E-05  +3.22900000E-05  +6.63500000E-05
   -1.09820000E-04  -5.00200000E-05  +1.30930000E-04  -4.48917000E-03  +8.97547000E-03
   +1.44756200E-02  +3.45810000E-04  -1.44183000E-03  +2.43945000E-03  -2.47800000E-05
   -3.75600000E-05  -1.71500000E-05  +1.37790000E-04  +1.11979000E-03  +2.10290000E-04
   -1.90960000E-04  -7.38500000E-05  -7.32900000E-05  +9.61100000E-05  +1.78980000E-04
   +1.31640000E-04  +4.03100000E-05  -1.18960000E-04  -1.51230000E-04  -1.34000000E-05
   -1.59920000E-04  -1.09290000E-04  -3.63300000E-04  -1.78950000E-04  +5.49120000E-04
   +1.20510000E-04  +1.25630000E-04  +8.25000000E-06  +3.08516300E-02  -1.26549280E-01
   -1.19436880E-01  -2.71400000E-05  -5.09200000E-05  -3.40200000E-05  -1.38500000E-05
   -9.24000000E-06  +3.55000000E-06  +1.64100000E-05  +1.11000000E-06  +1.34000000E-06
   +2.51600000E-05  -3.30000000E-06  -1.63000000E-06  +2.30220000E-04  -6.84500000E-04
   +2.29940000E-04  +1.80000000E-07  -1.51000000E-06  +2.07400000E-05  -3.48854100E-02
   +1.35301550E-01  +7.56000000E-06  +2.49460000E-04  +1.51470000E-04  +1.23957000E-03
   -8.17430000E-04  +1.17586000E-03  -6.07100000E-05  +5.38380000E-04  -1.48100000E-04
   +1.50160000E-04  -1.46110000E-04  +8.92300000E-05  -4.89200000E-05  -9.07200000E-05
   +1.11600000E-04  -2.63810000E-04  -8.17000000E-06  +2.04020000E-04  +5.86212000E-03
   -1.51357900E-02  -2.11519200E-02  -8.62470000E-04  +4.52771000E-03  -4.34843000E-03
   +5.59800000E-05  -2.66900000E-05  -1.33400000E-05  -1.26015000E-03  -1.04750000E-03
   +6.70910000E-04  +8.25100000E-04  +3.02850000E-04  -2.02060000E-04  -3.44940000E-04
   -5.22140000E-04  -1.22400000E-04  -3.42320000E-04  +3.00840000E-04  +3.92820000E-04
   +4.54780000E-04  +4.40990000E-04  +1.85620000E-04  +3.31520000E-04  -5.66560000E-04
   -8.23900000E-05  -3.20500000E-05  -3.06800000E-05  -1.23600000E-05  +4.75979800E-02
   -1.17240000E-01  -2.25060870E-01  +2.30900000E-05  -4.71000000E-06  -5.30300000E-05
   +5.18000000E-06  +1.21800000E-05  -6.17000000E-06  -9.35000000E-06  +9.69000000E-06
   -2.11500000E-05  -1.43700000E-04  -1.36400000E-05  +6.25400000E-05  -3.06190000E-04
   +4.91810000E-04  +6.50900000E-05  +3.96800000E-05  +1.65100000E-05  +2.98000000E-06
   -5.15977900E-02  +1.27456360E-01  +2.46198080E-01  -5.58000000E-06  -2.28660000E-04
   +2.65280000E-04  +7.84020000E-04  +1.56840000E-04  -4.80110000E-04  -1.58630000E-04
   -1.35190000E-04  +2.83740000E-04  +1.90600000E-05  +9.65400000E-05  -2.10960000E-04
   +3.09410000E-04  -3.91750000E-04  +2.10300000E-05  -5.20700000E-05  +3.52170000E-04
   -2.58480000E-04  -5.06524000E-03  +9.01690000E-04  +7.10610000E-04  +5.46200000E-05
   -1.97190000E-04  +5.72380000E-04  -4.26200000E-04  +3.43310000E-04  -3.80900000E-05
   +9.66980000E-04  -1.35627000E-03  +2.10140000E-04  +2.60380000E-04  +1.53080000E-04
   +1.49730000E-04  +1.30870000E-04  +1.57680000E-04  -5.40000000E-05  +1.00910000E-04
   -4.06100000E-05  -1.61220000E-04  -1.98150000E-04  -6.63700000E-05  -1.90200000E-05
   +1.81970000E-04  +4.28110000E-04  +3.66170000E-04  +4.60000000E-07  -1.86000000E-05
   +2.42600000E-05  -2.96237730E-01  +7.10988900E-02  -1.18887900E-02  -6.92900000E-05
   +1.58090000E-04  +4.47500000E-05  -3.45000000E-06  +1.58000000E-06  -8.13000000E-06
   +2.12800000E-05  +2.36800000E-05  +3.33000000E-06  +5.62000000E-06  +4.12300000E-05
   -2.80600000E-05  +2.85900000E-05  -9.10200000E-05  -2.23700000E-05  -1.17200000E-05
   +1.18400000E-05  -8.95000000E-06  -5.51000000E-03  +7.03670000E-04  -6.66310000E-04
   +3.19537380E-01  -7.30320000E-04  -1.41170000E-04  +5.09750000E-04  -5.06400000E-04
   -1.43620000E-03  +3.56591000E-03  +1.24094000E-03  +2.08000000E-04  -1.16290000E-04
   -2.53900000E-05  -2.56620000E-04  +3.88150000E-04  -3.63360000E-04  +8.55800000E-05
   -4.88100000E-05  +1.86710000E-04  +1.25190000E-04  -9.21000000E-05  +1.73412100E-02
   -7.51288000E-03  +1.35963000E-03  -3.97650000E-04  +5.66300000E-05  -9.97200000E-04
   +2.81820000E-04  -1.15130000E-04  +4.60300000E-05  +1.32149000E-03  +4.89380000E-04
   -5.51200000E-05  -2.83280000E-04  +1.20280000E-04  +2.57700000E-05  -1.56330000E-04
   -6.44800000E-05  +2.86800000E-05  -1.84620000E-04  -1.69080000E-04  +7.31800000E-05
   +4.56500000E-05  +3.91500000E-05  -6.32500000E-05  +7.70000000E-05  -2.63250000E-04
   -4.68770000E-04  +1.69420000E-04  +2.24600000E-04  +4.29000000E-06  +6.91663700E-02
   -6.59762000E-02  +2.07443000E-03  +1.48510000E-04  -3.46300000E-05  -1.54980000E-04
   -2.81200000E-05  -2.83600000E-05  +2.20400000E-05  +1.95500000E-05  -6.40000000E-07
   +2.80000000E-07  +3.79800000E-05  -1.63000000E-06  +7.32100000E-05  +3.99000000E-06
   +1.08840000E-04  +1.28540000E-04  +9.85000000E-06  -1.47000000E-06  +1.32300000E-05
   +1.65423300E-02  -4.92281000E-03  +1.68985000E-03  -7.73664100E-02  +7.06235800E-02
   +8.16740000E-04  +5.61510000E-04  -2.71270000E-04  +8.47280000E-04  +2.24285000E-03
   -4.29651000E-03  -1.65041000E-03  +5.56040000E-04  +2.25530000E-04  +1.22420000E-04
   +2.11290000E-04  -3.84550000E-04  +2.05790000E-04  -1.16720000E-04  +1.01140000E-04
   -2.64940000E-04  +2.16800000E-05  +1.75490000E-04  -2.64506300E-02  +8.09602000E-03
   -3.23028000E-03  -1.40058000E-03  +5.67210000E-04  +1.14283000E-03  -1.64720000E-04
   +6.79700000E-05  -4.34300000E-05  -7.87340000E-04  -6.04930000E-04  +5.74730000E-04
   -8.20500000E-05  -1.42920000E-04  +2.14190000E-04  +1.68670000E-04  +1.79450000E-04
   -1.90800000E-05  +2.30780000E-04  +6.76000000E-06  -2.13410000E-04  -4.14340000E-04
   -1.11570000E-04  +6.97300000E-05  +3.95320000E-04  +2.18410000E-04  -7.51000000E-06
   -1.64320000E-04  -1.74770000E-04  -6.10000000E-07  -9.87824000E-03  +1.68268000E-03
   -4.68293400E-02  -7.32700000E-05  -2.94000000E-06  +3.39900000E-05  +2.45700000E-05
   +6.69000000E-06  +4.50000000E-07  -9.56000000E-06  +7.28000000E-06  +1.20400000E-05
   +3.58500000E-05  -8.00000000E-06  -1.12000000E-04  +2.51000000E-05  +2.25000000E-06
   +5.33900000E-05  +1.50500000E-05  -9.67000000E-06  +3.85000000E-06  +2.57709800E-02
   -5.95666000E-03  +2.09034000E-03  +1.24621400E-02  -6.35063000E-03  +5.19876900E-02
   -1.02619000E-03  +9.17410000E-04  +1.01820000E-04  -7.95500000E-05  -8.56100000E-05
   +3.34200000E-04  +8.27400000E-05  -8.15300000E-05  -1.03610000E-04  +1.92400000E-05
   -1.30300000E-05  +1.35430000E-04  -2.07320000E-04  +3.94500000E-05  -2.83900000E-05
   +8.10600000E-05  +2.25600000E-05  -6.62500000E-05  +2.22600000E-03  +4.36336000E-03
   +3.20240000E-04  +2.83690000E-04  +1.38630000E-04  +2.46600000E-05  +1.54290000E-04
   -6.36200000E-05  +2.66000000E-05  +5.38140000E-04  -3.31850000E-04  -1.85500000E-04
   +4.06420000E-04  -4.76400000E-05  -3.01100000E-05  +1.35150000E-04  +1.02750000E-04
   +2.47600000E-05  +2.81070000E-04  +9.41300000E-05  -1.70750000E-04  -3.15380000E-04
   -1.17730000E-04  +3.83800000E-05  +1.72210000E-04  +4.85070000E-04  +3.66060000E-04
   -1.76980000E-04  -1.86950000E-04  +9.03000000E-06  -1.31457140E-01  -1.23943070E-01
   -1.68539000E-03  +6.18000000E-05  -4.04600000E-05  -6.66900000E-05  +2.73900000E-05
   +1.28800000E-05  -1.12600000E-05  -7.34000000E-06  -7.56000000E-06  +1.54300000E-05
   -7.39800000E-05  +4.60700000E-05  -3.45000000E-05  +4.90800000E-05  -8.69700000E-05
   +2.32300000E-05  -2.07100000E-05  -3.52000000E-06  -1.56300000E-05  +3.88493000E-03
   +7.29300000E-03  -3.68360000E-04  -1.58398600E-02  -2.61830000E-02  -7.16690000E-04
   +1.42137320E-01  -4.21130000E-04  -4.04980000E-04  +8.51730000E-04  -6.42060000E-04
   +5.18520000E-04  -2.38460000E-04  +3.49380000E-04  -1.22200000E-04  +1.66420000E-04
   -1.01870000E-04  +1.37570000E-04  -6.14700000E-05  -3.26700000E-05  -3.21220000E-04
   -8.33300000E-05  +2.15730000E-04  +4.84380000E-04  -4.26250000E-04  -1.01713800E-02
   -1.41504700E-02  -1.41187000E-03  +8.64000000E-05  +5.65030000E-04  -1.52590000E-03
   -1.94990000E-04  +2.89960000E-04  +6.83000000E-06  +5.69320000E-04  -1.06112000E-03
   +3.66555000E-03  +7.18450000E-04  -2.67740000E-04  -2.47140000E-04  -4.68540000E-04
   -5.43280000E-04  -4.05100000E-04  +6.94000000E-06  +6.09840000E-04  +4.60330000E-04
   +1.85490000E-04  +2.05580000E-04  +5.97000000E-06  -2.86020000E-04  -1.13590000E-04
   +3.35740000E-04  -4.07330000E-04  -5.26270000E-04  -6.19100000E-05  -1.22858750E-01
   -2.28355700E-01  -2.30447000E-03  +4.42100000E-05  +1.84340000E-04  +1.27600000E-05
   +6.62300000E-05  +4.23300000E-05  -3.13600000E-05  -1.00370000E-04  -3.37300000E-05
   -3.36400000E-05  +1.84200000E-05  -1.22600000E-05  +1.43910000E-04  -8.39500000E-05
   +1.41190000E-04  -1.33100000E-04  -7.43000000E-06  -4.55600000E-05  -1.49500000E-05
   -9.47472000E-03  -1.30076800E-02  +1.01784000E-03  +5.43561000E-03  +8.47141000E-03
   -4.14700000E-05  +1.35919890E-01  +2.46736810E-01  -4.23200000E-04  -3.96200000E-04
   +3.47770000E-04  +3.10480000E-04  -4.72410000E-04  +5.47430000E-04  +9.34000000E-06
   -3.66100000E-05  -1.33090000E-04  +3.14500000E-05  -5.32400000E-05  +5.83900000E-05
   -7.27400000E-05  +2.98000000E-06  -2.00700000E-05  -1.96600000E-05  -9.62000000E-06
   -3.87500000E-05  +1.64229000E-02  +2.18459900E-02  -6.90790000E-04  +8.34560000E-04
   +1.14573000E-03  +1.27727000E-03  +6.12100000E-05  -2.09300000E-05  +1.45000000E-05
   -1.48642000E-03  +1.88780000E-03  -4.08425000E-03  +3.78190000E-04  +6.66170000E-04
   +1.21040000E-04  +1.77660000E-04  -1.09050000E-04  +3.43560000E-04  -2.99580000E-04
   -2.19730000E-04  +2.23100000E-05  +5.32090000E-04  +6.06500000E-05  +1.24080000E-04
   +1.79620000E-04  -2.35110000E-04  -2.59100000E-05  +3.66040000E-04  +4.73280000E-04
   +4.00000000E-06  -1.64194000E-03  -3.53482000E-03  -4.82843400E-02  +3.01100000E-05
   -1.67900000E-05  -4.07700000E-05  -5.22500000E-05  -2.34000000E-06  +2.61100000E-05
   +6.49800000E-05  +4.57900000E-05  -8.07000000E-06  -4.14300000E-05  +9.77900000E-05
   -1.79950000E-04  -2.92770000E-04  +2.76310000E-04  -9.73700000E-05  +2.58100000E-05
   +3.79300000E-05  +1.88500000E-05  -1.60188100E-02  -2.07204800E-02  +7.87310000E-04
   -4.22560000E-04  -1.01439000E-03  -1.00945000E-03  +1.96430000E-03  +6.02040000E-04
   +5.08593200E-02  +2.60020000E-04  +2.55400000E-05  +5.76700000E-05  +8.52270000E-04
   +1.45501000E-03  +2.91110000E-04  +9.24200000E-05  -2.93100000E-05  -1.46500000E-05
   -8.62400000E-05  +1.06700000E-05  +6.50000000E-07  -1.48520000E-04  +8.61500000E-05
   -2.48000000E-05  +4.48800000E-05  -9.89000000E-05  -5.83000000E-05  +2.34152000E-03
   +4.84898000E-03  +9.86740000E-04  -1.82666960E-01  -1.37138990E-01  +1.78950000E-04
   +1.47140000E-04  -8.20400000E-05  +1.61700000E-05  +6.89900000E-05  +7.11110000E-04
   +1.14266000E-03  -4.57550000E-04  +7.89000000E-06  +4.74880000E-04  +2.61610000E-04
   -1.20160000E-04  -2.30220000E-04  +2.09900000E-05  +3.83500000E-05  -1.20100000E-05
   -6.76400000E-05  +1.50000000E-06  -5.34900000E-05  +3.36450000E-04  +3.43790000E-04
   +2.09580000E-04  -7.67300000E-05  -1.41900000E-04  -4.70700000E-05  -1.84960000E-04
   +6.93700000E-05  -4.28800000E-05  +7.15900000E-05  -5.23300000E-05  -2.52800000E-05
   +3.07300000E-05  +3.15700000E-05  +5.50000000E-06  -1.06000000E-05  -4.06000000E-06
   +2.14600000E-05  +3.10500000E-04  -6.73100000E-05  -5.03000000E-04  +9.89700000E-05
   -4.63700000E-05  -2.55800000E-05  -4.58000000E-06  +2.16400000E-05  -2.12200000E-05
   +1.35230000E-04  +2.65280000E-04  -5.41600000E-05  +2.90300000E-05  -1.24460000E-04
   +6.89100000E-05  +2.46450000E-04  +1.52370000E-04  -4.16290000E-04  +1.95354800E-01
   +6.91540000E-04  +3.96000000E-04  -2.99700000E-05  -1.49970000E-03  +6.23110000E-04
   +6.62160000E-04  +1.73320000E-04  -4.23500000E-04  +4.30150000E-04  -3.93900000E-05
   +1.32770000E-04  -2.85300000E-05  +1.87910000E-04  -3.78830000E-04  +1.01310000E-04
   -1.19000000E-06  +1.83350000E-04  -1.02870000E-04  -1.37633900E-02  -1.64161200E-02
   -1.37580000E-04  -1.35073820E-01  -1.81511080E-01  +2.31003000E-03  -2.91330000E-04
   +2.55100000E-04  -4.90900000E-05  +1.79507000E-03  -1.26558000E-03  -3.61995000E-03
   +5.20040000E-04  +1.90230000E-04  -3.77000000E-04  -8.51600000E-05  +1.03510000E-04
   +1.55000000E-06  +2.95630000E-04  +1.95200000E-04  -8.13200000E-05  +4.47100000E-05
   -3.80920000E-04  -1.36060000E-04  -1.19180000E-03  -4.15650000E-04  +1.94140000E-04
   -2.45990000E-04  -2.77350000E-04  +1.41300000E-05  +1.79360000E-04  +3.80280000E-04
   +1.26229000E-03  +1.02820000E-04  +1.03320000E-04  -5.79200000E-05  +3.23300000E-05
   +2.56700000E-05  -1.53500000E-05  -5.03300000E-05  -2.54600000E-05  +2.24000000E-06
   +1.49090000E-04  -2.90900000E-05  +2.45120000E-04  +1.76300000E-05  +1.87500000E-05
   -9.22500000E-05  -5.70400000E-05  -1.20710000E-04  +2.17500000E-05  +2.80380000E-04
   +1.38760000E-04  +8.09400000E-05  +1.10190000E-04  +5.83000000E-05  +2.25200000E-05
   +2.94100000E-05  +6.85220000E-04  -2.54220000E-04  +1.47628320E-01  +1.97217240E-01
   +2.25790000E-04  +2.05820000E-04  +1.89780000E-04  -1.17814000E-03  +3.63320000E-04
   +9.73650000E-04  +7.15600000E-05  +2.34600000E-05  -2.12940000E-04  -1.52210000E-04
   +1.85800000E-05  +3.63500000E-05  +1.42380000E-04  -1.80080000E-04  +6.19900000E-05
   -3.75300000E-05  +9.09000000E-05  -1.65450000E-04  -1.77919700E-02  -1.86757200E-02
   -1.76075000E-03  +1.76564000E-03  +3.50905000E-03  -4.67031800E-02  -2.22830000E-04
   +1.57150000E-04  -4.62000000E-05  +1.89172000E-03  -2.14853000E-03  -3.90311000E-03
   +9.26130000E-04  -8.22100000E-05  -2.95710000E-04  -1.90020000E-04  -1.06790000E-04
   +1.74360000E-04  +3.73600000E-05  +1.74530000E-04  +2.83200000E-05  +2.36050000E-04
   -2.12480000E-04  -2.31260000E-04  -1.19171000E-03  -1.15760000E-03  +2.86210000E-04
   -1.07350000E-04  -7.98800000E-05  +1.40400000E-05  -1.03870000E-03  -1.12806000E-03
   +1.15893000E-03  +3.20000000E-07  +8.54900000E-05  +1.85600000E-05  +4.56000000E-06
   -3.97000000E-06  -7.55000000E-06  -1.56800000E-05  -3.61900000E-05  +1.22900000E-05
   -1.83740000E-04  +4.95650000E-04  +1.29800000E-04  -1.01400000E-05  +2.67500000E-05
   -1.01600000E-05  -9.55300000E-05  -8.44900000E-05  -2.83100000E-05  +2.21990000E-04
   +2.50840000E-04  +2.55070000E-04  +7.35700000E-05  +8.09000000E-06  -6.13400000E-05
   +2.42440000E-04  +4.11700000E-04  -7.32070000E-04  -2.60505000E-03  +9.99020000E-04
   +5.10082800E-02  +9.48830000E-04  +6.74440000E-04  -2.68150000E-04  -2.76000000E-06
   +9.43350000E-04  +2.06811000E-03  +9.47600000E-05  -3.96070000E-04  +2.53360000E-04
   -5.61500000E-05  +5.86600000E-05  -1.38800000E-05  +5.36530000E-04  -6.42470000E-04
   +2.66980000E-04  -4.40340000E-04  +2.72210000E-04  -1.37050000E-04  -4.57720000E-03
   +1.37801000E-03  -6.25340000E-04  -2.59318540E-01  +1.05344900E-01  -1.72647200E-02
   -6.10030000E-04  +4.36220000E-04  -1.03660000E-04  -1.57520000E-04  -2.55520000E-04
   +1.47130000E-04  -7.70880000E-04  -1.01913000E-03  +6.09430000E-04  +2.91100000E-04
   -1.37110000E-04  -2.54970000E-04  -1.33830000E-04  -5.75400000E-05  -3.75100000E-05
   +4.96000000E-06  -2.44300000E-05  -1.12900000E-05  +1.32360000E-04  +1.73520000E-04
   +5.59200000E-05  +5.48800000E-05  +6.11000000E-06  -3.60900000E-05  +3.96080000E-04
   -3.13350000E-04  -7.73220000E-04  +2.32000000E-05  +2.14900000E-04  -6.74100000E-05
   -1.04000000E-06  +1.54700000E-05  +4.39000000E-06  +2.50800000E-05  +1.00300000E-05
   +2.66300000E-05  -9.68800000E-05  -1.44523000E-03  -2.79300000E-04  -1.74000000E-05
   -3.10100000E-05  -4.17800000E-05  +4.42000000E-06  +1.92400000E-05  -8.16000000E-06
   +2.86600000E-04  -1.86680000E-04  +1.81800000E-05  +4.40620000E-04  -1.35050000E-04
   +4.34290000E-04  -2.21930000E-04  +6.33500000E-05  +1.04800000E-04  -1.87446500E-02
   +1.08617300E-02  -2.10512000E-03  +2.82390120E-01  -6.85200000E-05  -3.31310000E-04
   +1.67050000E-04  +4.58500000E-05  -1.17600000E-03  -3.37183000E-03  +1.72610000E-04
   +2.69100000E-05  +7.72800000E-05  -1.42140000E-04  +4.72600000E-05  -1.65030000E-04
   -5.00260000E-04  +6.18090000E-04  -2.90490000E-04  +6.33640000E-04  -9.16100000E-05
   +2.25330000E-04  +1.79534200E-02  -8.92973000E-03  +2.18880000E-03  +1.04281230E-01
   -9.91592700E-02  +8.20010000E-03  +5.38500000E-04  -4.03340000E-04  +6.97300000E-05
   +3.97330000E-04  +7.01230000E-04  +4.38620000E-04  +1.43410000E-04  -7.02340000E-04
   -6.21570000E-04  -3.67010000E-04  +8.88500000E-05  +2.59180000E-04  -1.12790000E-04
   -1.25900000E-05  +1.14600000E-04  +1.32220000E-04  +2.00380000E-04  +3.34200000E-05
   -2.07880000E-04  -1.68180000E-04  -1.59380000E-04  +9.04200000E-05  +1.84490000E-04
   +4.66300000E-05  -3.99200000E-05  +5.25080000E-04  +1.45929000E-03  +1.15240000E-04
   -2.37260000E-04  +9.16400000E-05  -3.00200000E-05  -4.76000000E-05  -1.45000000E-06
   +1.36200000E-05  -2.72600000E-05  -1.16600000E-05  -1.01753000E-03  -1.43309000E-03
   +6.21700000E-04  +5.86000000E-06  +8.08700000E-05  +1.16880000E-04  +9.26000000E-06
   +5.30000000E-07  +1.87400000E-05  -2.46900000E-04  -1.06930000E-04  +1.37130000E-04
   -3.36840000E-04  +4.64380000E-04  -3.43600000E-04  -1.65060000E-04  -3.51500000E-05
   -1.25470000E-04  -2.06313100E-02  +1.15134800E-02  -1.98993000E-03  -1.14646080E-01
   +1.05521950E-01  +6.36200000E-05  -7.00240000E-04  +2.43480000E-04  +3.87110000E-04
   -2.21881000E-03  -4.37728000E-03  +1.35130000E-04  +4.60240000E-04  -2.41730000E-04
   +3.85500000E-04  -2.27360000E-04  -2.05900000E-05  -3.16390000E-04  +9.34020000E-04
   -4.04880000E-04  +5.91050000E-04  -5.37600000E-05  +3.91600000E-04  +2.33472700E-02
   -1.04873000E-02  +7.45360000E-04  -1.76991300E-02  +9.24771000E-03  -4.84697700E-02
   +5.48930000E-04  -4.90830000E-04  +1.31610000E-04  -3.06300000E-05  +5.62250000E-04
   +5.45190000E-04  -5.61130000E-04  +2.22450000E-04  +4.50290000E-04  -6.45000000E-06
   -1.80370000E-04  -1.42500000E-04  -1.61000000E-04  -9.38000000E-06  +1.30240000E-04
   +9.92900000E-05  +8.62400000E-05  -2.19300000E-05  +2.41900000E-05  -2.00000000E-07
   -2.21940000E-04  +5.77900000E-05  +3.37900000E-05  -2.95000000E-05  +1.25458000E-03
   -5.58960000E-04  +1.17160000E-03  -5.41830000E-04  -1.38800000E-04  +4.16980000E-04
   -3.65000000E-06  +1.32000000E-06  +1.01900000E-05  +7.06000000E-06  +2.81000000E-06
   +9.49000000E-06  +9.59800000E-05  +3.79600000E-05  +1.73930000E-04  +4.23500000E-05
   +7.36000000E-06  +3.04300000E-05  +2.03000000E-05  -4.27000000E-06  +9.39000000E-06
   -2.06100000E-04  +1.22780000E-04  +3.63880000E-04  -4.38970000E-04  -1.11280000E-04
   -7.05030000E-04  +4.14400000E-05  +1.45190000E-04  -4.06600000E-05  +6.84540000E-04
   -2.92490000E-04  -9.75250000E-04  +1.79413300E-02  -7.44197000E-03  +5.20404500E-02
   -3.38370000E-04  +1.33800000E-05  +4.26000000E-05  +3.84800000E-04  -5.68200000E-04
   +1.77150000E-04  -4.37530000E-04  +2.54920000E-04  +5.79700000E-04  -2.51390000E-04
   +1.29300000E-04  -8.58800000E-05  -2.29960000E-04  +4.74400000E-05  -4.23100000E-05
   +1.66230000E-04  -7.22200000E-05  +2.99000000E-06  -1.45128000E-03  -3.19233000E-03
   +3.81749000E-03  -4.77826600E-02  +6.48182000E-03  -1.07551900E-02  +1.71640000E-04
   -8.67400000E-05  +1.38000000E-06  +1.77750000E-04  +2.15280000E-04  -5.78780000E-04
   +2.86830000E-04  -3.69100000E-04  -4.99430000E-04  -1.18810000E-04  +5.90300000E-05
   +2.24830000E-04  -3.97300000E-05  -2.64500000E-05  -1.54100000E-05  +5.07000000E-05
   +7.12900000E-05  +2.98400000E-05  -1.18660000E-04  -2.28800000E-05  -4.70200000E-05
   +5.90400000E-05  +1.23900000E-04  +3.68700000E-05  -1.31800000E-04  +4.13330000E-04
   +4.05250000E-04  +2.69630000E-04  -8.84900000E-05  -1.41320000E-04  -2.15300000E-05
   -2.71300000E-05  -6.29000000E-06  +3.99000000E-06  -2.63000000E-06  -1.93500000E-05
   -1.04916000E-03  -4.93600000E-05  -4.24620000E-04  -1.48800000E-05  +3.56500000E-05
   +4.21800000E-05  +7.27000000E-06  +2.97000000E-06  +1.70300000E-05  +6.41200000E-04
   +4.93000000E-05  +2.31130000E-04  +3.71650000E-04  -1.30940000E-04  +3.45160000E-04
   +8.56000000E-06  +3.03210000E-04  -1.73240000E-04  +1.70964000E-03  -1.06739800E-02
   +2.09105800E-02  -4.69990000E-04  +1.40025400E-02  -2.57980900E-02  +4.84078200E-02
   +2.98480000E-04  +5.82700000E-05  +2.26000000E-05  -4.96960000E-04  +4.56550000E-04
   +6.80520000E-04  +5.40810000E-04  -6.69860000E-04  -7.71070000E-04  -5.74500000E-05
   -3.99100000E-05  +9.21600000E-05  +2.02150000E-04  -1.86110000E-04  +9.11900000E-05
   -1.85060000E-04  +1.07080000E-04  -7.44200000E-05  -1.70348000E-03  +1.06886400E-02
   -1.70164400E-02  +6.80215000E-03  -1.12229850E-01  +1.14782070E-01  -1.88560000E-04
   +1.32780000E-04  -2.77600000E-05  -3.58700000E-05  +1.10368000E-03  +2.95720000E-04
   -6.00540000E-04  +9.45100000E-05  -3.05800000E-05  -1.42000000E-06  -1.63570000E-04
   -7.26900000E-05  -1.60330000E-04  -2.75600000E-05  +1.68700000E-04  +1.52570000E-04
   +1.22570000E-04  -4.01200000E-05  +2.50460000E-04  -8.60800000E-05  +2.37000000E-06
   +9.54800000E-05  +8.15100000E-05  -1.95700000E-05  +6.37530000E-04  -2.15826000E-03
   -2.70344000E-03  -1.66900000E-05  +1.12780000E-04  -1.51000000E-05  -1.10800000E-05
   -3.60000000E-07  +9.35000000E-06  -1.16100000E-05  +2.53500000E-05  -2.83200000E-05
   -4.54090000E-04  -2.97730000E-04  -3.04880000E-04  -2.01400000E-05  +2.07500000E-05
   -1.93800000E-05  +7.96000000E-06  +2.37200000E-05  -7.96000000E-06  -4.06400000E-05
   +7.82620000E-04  -1.06491000E-03  -1.31950000E-04  -1.13480000E-04  -6.77300000E-05
   +2.76880000E-04  +1.82160000E-04  -1.93190000E-04  +2.80990000E-03  -1.07440200E-02
   +1.91134500E-02  -7.65450000E-04  -7.43678000E-03  +1.15467900E-02  -8.48623000E-03
   +1.21691040E-01  +4.96790000E-04  -7.39900000E-05  -8.13800000E-05  -1.11262000E-03
   +5.68230000E-04  +1.53710000E-04  +4.67600000E-05  +9.37670000E-04  -6.33200000E-04
   +4.61200000E-04  -4.32950000E-04  +3.45610000E-04  +2.29040000E-04  +3.02270000E-04
   -5.01300000E-05  -1.51970000E-04  -2.41000000E-05  +9.31100000E-05  -1.85215000E-03
   +1.35496700E-02  -2.00287800E-02  -1.05879000E-02  +1.13451040E-01  -2.48889650E-01
   -3.19200000E-05  -1.01250000E-04  +5.61500000E-05  +6.90070000E-04  +1.31239000E-03
   +9.04540000E-04  +3.26760000E-04  -1.82340000E-04  +1.07430000E-04  -2.63840000E-04
   -2.77580000E-04  +1.71860000E-04  -1.91990000E-04  +1.75780000E-04  +1.87010000E-04
   +2.18590000E-04  +2.17680000E-04  -2.56200000E-05  +2.90800000E-05  -5.61930000E-04
   -1.57900000E-05  -4.90000000E-06  +6.32000000E-06  +5.62000000E-06  +1.53094000E-03
   -4.75054000E-03  -3.69636000E-03  -6.67420000E-04  +7.25400000E-05  +3.12170000E-04
   -1.11300000E-05  -9.93000000E-06  -1.20500000E-05  -1.83900000E-05  -2.95600000E-05
   -1.21600000E-05  -5.96670000E-04  +1.18550000E-04  -6.20900000E-05  -4.96800000E-05
   +9.60700000E-05  +2.22100000E-05  -2.90400000E-05  +1.28100000E-05  -3.56500000E-05
   -2.65280000E-04  +8.46350000E-04  -1.59192000E-03  -1.37100000E-05  -5.33400000E-05
   +2.90920000E-04  +3.27600000E-05  -8.70100000E-05  +3.97500000E-04  -2.20600000E-05
   -7.27470000E-04  +8.49930000E-04  +1.69680000E-04  +4.86710000E-04  -1.32582000E-03
   +1.17558700E-02  -1.24178670E-01  +2.71658850E-01  +2.67430000E-03  +2.44056000E-03
   -1.59084000E-03  +6.00732000E-03  -4.42141000E-03  +6.16620000E-04  -1.41648690E-01
   +2.43662500E-02  +1.30696490E-01  -6.10338000E-03  -2.42609000E-03  +2.06136600E-02
   +1.90404000E-03  -8.02150000E-04  +4.90750000E-04  -1.79210000E-03  +9.13780000E-04
   -2.47300000E-05  -3.73750000E-04  -5.30960000E-04  -2.87110000E-04  -5.46610000E-04
   +8.14530000E-04  -4.67370000E-04  -2.58410000E-04  +4.24620000E-04  -1.40860000E-04
   -3.59480000E-04  +1.59300000E-04  -3.70510000E-04  -1.52000000E-05  +9.59000000E-06
   -4.79000000E-06  -5.72700000E-05  -7.82600000E-05  +4.25100000E-05  -1.52780000E-04
   -8.82800000E-05  +4.59500000E-05  +9.14700000E-05  +8.71600000E-05  -1.86800000E-05
   +4.12000000E-06  -6.28500000E-05  -1.07670000E-04  +1.03150000E-04  +1.23170000E-04
   +4.75000000E-06  +4.16100000E-05  -3.51400000E-05  +8.96000000E-06  +4.01100000E-04
   +7.34607000E-03  +6.78390000E-04  -1.93400000E-05  -1.94400000E-05  +4.14000000E-06
   +1.17200000E-05  +2.15000000E-06  -6.12000000E-06  -2.94500000E-05  +7.00500000E-05
   +1.60000000E-07  -3.78000000E-06  -9.58000000E-06  +4.23100000E-05  +4.31000000E-06
   +5.95000000E-06  +9.31000000E-06  +5.52000000E-06  +5.55000000E-06  +1.13700000E-05
   +4.52800000E-05  -1.76100000E-05  +1.20000000E-05  +4.60000000E-06  -3.03500000E-05
   +2.66100000E-05  +4.64000000E-06  -1.21160000E-04  +1.27950000E-04  +1.04300000E-05
   -3.82400000E-05  -1.12190000E-04  -2.99490000E-04  +1.27657000E-03  -5.54800000E-05
   +1.41651010E-01  +4.24123000E-03  -1.20912000E-03  +1.86697000E-03  -1.28210800E-02
   +1.79152000E-03  +1.93700800E-02  +1.69309300E-02  -4.36615200E-02  -9.97963000E-03
   +1.22588800E-02  -6.83120000E-04  -1.87292700E-02  +5.28800000E-04  -3.10063000E-03
   +8.48410000E-04  -1.31935000E-03  +1.64260000E-03  +5.80300000E-05  -4.60770000E-04
   +3.58360000E-04  -2.70650000E-04  +2.73400000E-04  -9.78230000E-04  +7.98840000E-04
   +1.56150000E-04  +1.05310000E-03  -1.44920000E-04  +2.67000000E-04  +1.65380000E-04
   -1.24170000E-04  -2.77300000E-05  +3.44400000E-05  +1.22550000E-04  +2.14000000E-05
   -3.53700000E-05  +9.83000000E-06  +3.97400000E-05  -1.64800000E-05  -7.09000000E-05
   -6.77700000E-05  -1.54240000E-04  +2.73300000E-05  +2.35300000E-05  +4.79300000E-05
   +6.00800000E-05  -2.71100000E-05  -5.76300000E-05  +1.04900000E-05  -1.35130000E-04
   -2.14050000E-04  -1.69740000E-04  +8.99692000E-03  +1.28774000E-03  -1.72780000E-04
   -1.13200000E-05  +9.74000000E-06  -1.48700000E-05  -1.74700000E-05  +7.47000000E-06
   -4.62000000E-06  +8.21300000E-05  +1.31300000E-05  -3.76300000E-05  -1.14100000E-05
   -1.59200000E-05  -2.28400000E-05  -9.72000000E-06  -5.91000000E-06  -1.00100000E-05
   -4.60700000E-05  +2.42900000E-05  -1.72040000E-04  +5.38900000E-05  +3.40500000E-05
   -4.25900000E-05  -3.32300000E-05  +3.04100000E-05  +3.23900000E-05  +1.57600000E-05
   +1.53500000E-05  +7.75000000E-06  -9.83700000E-05  +2.80610000E-04  -4.12330000E-04
   +1.44952000E-03  -1.43442000E-03  -5.23010000E-04  -2.70071000E-02  +4.75418800E-02
   -1.58927000E-03  +2.55204000E-03  -3.00942000E-03  +1.38683300E-02  -3.57909000E-03
   -1.21090900E-02  +1.34283410E-01  -1.01969300E-02  -2.44761570E-01  +9.12440000E-04
   +6.27260000E-04  +2.93910000E-04  +5.84080000E-04  +3.53160000E-04  -1.88500000E-04
   -6.37540000E-04  -1.55540000E-04  +1.50050000E-04  +1.11419000E-03  -3.71190000E-04
   -1.76390000E-04  +1.59770000E-04  -5.26300000E-05  -1.67140000E-04  +6.76390000E-04
   -2.64070000E-04  +2.23980000E-04  -2.42930000E-04  +1.55910000E-04  +1.26400000E-05
   -6.85100000E-05  -8.39000000E-05  +1.70860000E-04  -1.15550000E-04  -8.54400000E-05
   +6.41600000E-05  -2.37410000E-04  -1.10260000E-04  +4.63700000E-05  +1.23650000E-04
   +7.51700000E-05  -4.26100000E-05  +1.32260000E-04  -3.35600000E-04  -1.84670000E-04
   +1.78450000E-04  +1.96870000E-04  +1.97200000E-05  -9.80600000E-05  -2.17400000E-05
   +5.00000000E-08  +9.81070000E-04  +2.96773000E-03  +2.64924000E-03  -3.38900000E-05
   -1.92000000E-05  +6.91000000E-06  +1.63000000E-05  +3.83000000E-06  -8.30000000E-06
   -5.57700000E-05  +1.93500000E-05  -2.11600000E-05  +3.12700000E-05  +5.79000000E-05
   +7.63600000E-05  +5.62000000E-06  +1.97900000E-05  -1.58000000E-06  +2.50400000E-05
   +4.25100000E-05  +8.78000000E-05  -9.08200000E-05  +2.21000000E-05  +1.61500000E-05
   +1.39200000E-05  -1.23150000E-04  +2.58400000E-05  -1.39700000E-05  -1.77330000E-04
   +5.05900000E-05  -5.70100000E-05  -6.47900000E-05  +2.54320000E-04  +3.62000000E-05
   -1.30120000E-04  +8.17790000E-04  -1.49366190E-01  +9.25881000E-03  +2.55488140E-01
   -3.53899000E-03  +4.76060000E-04  -1.16720000E-04  +2.80096000E-03  +6.21509000E-03
   +2.01044000E-03  +2.50412000E-03  +1.18013500E-02  -1.57823600E-02  -5.90903000E-02
   +5.11282900E-02  -4.67076300E-02  +2.84788000E-03  +6.01617000E-03  +4.68370000E-04
   +2.07371000E-03  -2.44161000E-03  +2.52280000E-04  +5.42390000E-04  +3.81930000E-04
   -2.64790000E-04  +5.25000000E-05  -5.86600000E-05  -2.56800000E-05  -6.48660000E-04
   -8.59620000E-04  -3.03860000E-04  +1.15300000E-05  -4.24100000E-05  +5.54900000E-05
   -1.44400000E-05  -2.83900000E-05  -2.48800000E-05  -2.66000000E-06  -3.73100000E-05
   +9.00000000E-07  +1.20200000E-05  +3.60300000E-05  +4.19000000E-06  -2.02200000E-05
   -6.76100000E-05  +5.41400000E-05  +2.76600000E-05  +6.95000000E-06  +4.21400000E-05
   -4.29300000E-05  -8.12400000E-05  +1.03300000E-05  -1.44970000E-04  -5.78800000E-05
   +3.50600000E-05  -3.27551000E-03  -1.10442200E-02  +2.52044900E-02  -1.01400000E-05
   +9.46000000E-06  -1.61300000E-05  -1.72700000E-05  -1.52000000E-06  -5.23000000E-06
   +1.53300000E-05  +4.67000000E-06  -7.81000000E-06  +2.31000000E-05  +6.87200000E-05
   -1.06300000E-05  -2.10800000E-05  -5.18000000E-06  -2.93900000E-05  +2.56400000E-05
   +1.65800000E-05  -7.96000000E-06  -4.72600000E-05  -3.90000000E-06  -3.94000000E-05
   +1.47400000E-05  -4.89700000E-05  +2.46000000E-05  -4.49000000E-06  -3.11400000E-05
   -3.52000000E-06  -3.82700000E-05  +3.38000000E-06  +7.69000000E-06  +1.95300000E-05
   -3.90000000E-06  +2.04100000E-05  -1.93878000E-03  -2.57029000E-03  -1.69760000E-03
   +5.62756700E-02  -1.63278000E-03  +3.08440000E-04  -4.08470000E-04  +7.64047000E-03
   +4.03216000E-03  -1.11155000E-03  +3.08495000E-03  -8.31281000E-03  +1.95029600E-02
   +4.92531300E-02  -1.51038890E-01  +1.40263500E-01  -6.56850000E-04  +1.13412000E-03
   -2.69350000E-04  +1.61741000E-03  -2.82830000E-04  +1.85120000E-04  -2.47080000E-04
   -8.99510000E-04  +1.16431000E-03  +7.38000000E-05  +1.05900000E-05  +3.80000000E-05
   -2.24080000E-04  -6.06830000E-04  -3.51930000E-04  -2.61250000E-04  -2.19150000E-04
   -1.75000000E-06  -1.42000000E-06  +2.20800000E-05  -9.17000000E-06  +8.91000000E-06
   +2.34700000E-05  -2.85000000E-06  -5.25200000E-05  -5.17400000E-05  -6.40000000E-07
   +1.65700000E-05  -1.71200000E-05  +2.30600000E-05  +4.01000000E-06  +3.42100000E-05
   -1.60000000E-07  +5.53300000E-05  +5.39300000E-05  +5.10000000E-06  +5.00270000E-04
   -1.38530000E-04  -1.41990000E-04  +4.99500000E-05  +6.97594000E-03  -9.32764000E-03
   -1.45400000E-05  -6.74000000E-06  +4.30000000E-07  +1.06500000E-05  +5.64000000E-06
   -3.08000000E-06  +1.65000000E-06  -1.31000000E-05  +2.80000000E-06  +2.87900000E-05
   +8.29000000E-06  -1.66800000E-05  -3.90000000E-06  +5.88000000E-06  -9.22000000E-06
   -7.42000000E-06  +2.68300000E-05  +1.03500000E-05  +2.69500000E-05  -1.27420000E-04
   +1.48710000E-04  -1.45000000E-05  -3.78700000E-05  +1.17000000E-05  -5.67000000E-06
   -3.46900000E-05  -3.14000000E-06  +1.51300000E-05  -5.76800000E-05  -1.93200000E-05
   -9.30000000E-07  -1.97000000E-06  +1.44300000E-05  -2.12293000E-03  -2.31627000E-03
   -1.74034000E-03  -5.66933900E-02  +1.50582180E-01  -3.10900000E-05  -4.76750000E-04
   -3.12970000E-04  +2.14765000E-03  +1.31076000E-03  +1.08647000E-03  +2.27323000E-03
   -3.65425000E-03  +5.31111000E-03  -4.49148400E-02  +1.42145340E-01  -2.17757880E-01
   -4.52019000E-03  -3.03160000E-03  -5.95140000E-04  +1.34263000E-03  +1.14777000E-03
   -6.92600000E-05  +2.82270000E-04  +2.18900000E-05  +5.85810000E-04  -1.09760000E-04
   +4.58800000E-05  -5.67100000E-05  +8.39630000E-04  -2.34440000E-04  -1.82020000E-04
   -6.37500000E-05  -3.12700000E-05  +2.22300000E-05  -1.21200000E-05  +1.60000000E-07
   -4.28000000E-06  -7.52000000E-06  -2.27300000E-05  +6.77000000E-06  -2.29700000E-05
   +4.58000000E-06  +1.08500000E-05  -1.92000000E-06  -3.82300000E-05  +4.24900000E-05
   +4.47300000E-05  -5.33000000E-06  -3.51000000E-05  -3.09000000E-06  -2.39300000E-05
   +8.92000000E-06  +1.37530000E-04  -7.44400000E-05  +3.10000000E-07  +7.98664000E-03
   +9.04631000E-03  -2.78087200E-02  -1.02300000E-05  +2.81000000E-06  -6.70000000E-06
   -3.93000000E-06  -1.20000000E-07  -2.12000000E-06  +2.28000000E-06  +2.97000000E-06
   -5.58000000E-06  +3.06700000E-05  +1.91100000E-05  +1.46200000E-05  -9.94000000E-06
   +3.94000000E-06  -2.49500000E-05  +1.31500000E-05  +1.11900000E-05  -4.55000000E-06
   -3.48000000E-06  -4.44900000E-05  +3.38600000E-05  -5.08000000E-06  -2.66000000E-05
   +6.17000000E-06  -3.97000000E-06  -2.42400000E-05  -1.25100000E-05  -2.15700000E-05
   +9.81000000E-06  +4.62700000E-05  -1.45000000E-06  -1.11400000E-05  +2.19200000E-05
   -1.55523000E-03  -1.11289000E-03  -1.85530000E-04  +3.67946500E-02  -1.47937630E-01
   +2.40597380E-01  -1.66390900E-02  -1.97524100E-02  +1.10780800E-02  -3.68436000E-03
   +2.03728000E-03  -1.75604000E-03  -3.43300000E-05  +3.44650000E-04  -9.68550000E-04
   -4.89510000E-04  +9.20400000E-05  +1.26597000E-03  +7.33960000E-03  +5.28577000E-03
   -3.18042000E-03  -1.80993270E-01  -1.28405280E-01  +6.56611500E-02  +1.49840000E-04
   +1.42280000E-04  +1.37032000E-03  -5.10290000E-04  +6.19000000E-05  -1.82290000E-04
   -5.14230000E-04  +9.90980000E-04  -4.49150000E-04  -2.80000000E-07  +2.09250000E-04
   -4.51000000E-06  -1.43200000E-05  -5.51700000E-05  -1.73600000E-05  -1.27000000E-05
   -4.58800000E-05  -4.66000000E-06  +5.96700000E-05  +7.86200000E-05  +1.64700000E-05
   -3.48400000E-05  -2.93000000E-06  +2.41000000E-05  -5.00000000E-06  -3.58500000E-05
   -3.97300000E-05  -8.63400000E-05  -1.01140000E-04  -7.81000000E-06  +1.45300000E-05
   -1.13810000E-04  +8.01200000E-05  +1.59696000E-03  +4.46144000E-03  -1.14250000E-03
   +1.43100000E-05  +1.15300000E-05  -2.17000000E-06  -1.50300000E-05  -1.01600000E-05
   +4.51000000E-06  +1.08000000E-05  +1.52400000E-05  -5.94000000E-06  -2.48000000E-06
   +3.44300000E-05  +3.67300000E-05  -7.20000000E-06  -1.06900000E-05  -6.52000000E-06
   +1.31200000E-05  -1.75300000E-05  -2.63700000E-05  -1.87500000E-05  +4.48100000E-05
   -3.85300000E-05  -2.42000000E-06  +4.26100000E-05  +2.79000000E-06  +1.66300000E-05
   -2.99000000E-06  -1.67200000E-05  -7.62400000E-05  +1.25850000E-04  +1.50940000E-04
   +1.37500000E-05  -1.80200000E-05  +1.36000000E-05  -3.24000000E-06  -9.33800000E-05
   +1.02880000E-04  +1.76030000E-04  +4.70000000E-07  -4.49400000E-05  +1.92642530E-01
   +1.05067200E-02  +7.76453000E-03  -4.52745000E-03  +1.41792000E-03  -5.77050000E-04
   +1.00624000E-03  -2.25490000E-04  +5.12460000E-04  -2.30370000E-04  +1.04212000E-03
   -1.00592000E-03  -9.04340000E-04  -1.79762700E-02  -1.61365000E-02  +9.15432000E-03
   -1.26988000E-01  -1.76222230E-01  +7.60333100E-02  +2.69560000E-04  +7.42000000E-05
   -2.16940000E-04  -5.50000000E-07  +4.66800000E-05  +8.78000000E-06  -1.16010000E-03
   +2.50590000E-03  -2.26501000E-03  +5.52000000E-06  -1.71800000E-05  -6.87000000E-06
   +2.08000000E-05  +1.18500000E-05  -1.93300000E-05  -6.50000000E-06  -1.64500000E-05
   -1.58200000E-05  +2.84600000E-05  +3.81100000E-05  +1.27500000E-05  -1.07900000E-05
   +1.56900000E-05  -2.45000000E-06  -2.34900000E-05  +6.55000000E-06  -1.30000000E-07
   -3.54900000E-05  -4.00000000E-05  -5.07000000E-06  -5.47600000E-05  +2.97800000E-05
   +1.16300000E-05  -2.08510000E-04  -6.73522000E-03  +4.78820000E-03  +8.27000000E-06
   +4.89000000E-06  +1.15000000E-06  -2.12000000E-06  -2.14000000E-06  +2.66000000E-06
   +6.89000000E-06  -1.75000000E-06  +1.81000000E-06  +1.37300000E-05  -2.57000000E-06
   +3.23800000E-05  +9.30000000E-07  -4.29000000E-06  +2.11000000E-06  -9.08000000E-06
   -1.40200000E-05  -3.11000000E-06  +3.67000000E-06  -3.31000000E-06  -8.46000000E-06
   +8.05000000E-06  -7.99000000E-06  +1.31900000E-05  +4.80000000E-07  -1.49100000E-05
   -5.76000000E-06  -1.49900000E-05  +4.22000000E-06  -6.35000000E-06  +8.82000000E-06
   -1.07000000E-05  -2.15400000E-05  -8.19100000E-05  -3.66200000E-05  -3.52900000E-05
   -3.28500000E-05  +1.99930000E-04  +3.08330000E-04  +1.34615160E-01  +1.89332210E-01
   +4.58410000E-03  -2.79776000E-03  +2.22030000E-04  -1.81886000E-03  -1.03803000E-03
   +3.95137000E-03  -1.12878000E-03  +1.90254000E-03  -1.90468000E-03  +1.16400000E-05
   -1.27927000E-03  +2.62134000E-03  +1.08748000E-02  +5.28460000E-04  -9.77760000E-04
   +6.16660100E-02  +8.28053900E-02  -6.64442100E-02  +4.93750000E-04  +5.44760000E-04
   +8.05040000E-04  -3.83390000E-04  +1.83400000E-04  -1.41020000E-04  -2.92487000E-03
   +3.05950000E-04  -2.55690000E-03  +8.98400000E-05  +7.47100000E-05  -4.62000000E-05
   +2.77500000E-05  +1.19900000E-05  -3.07200000E-05  -1.11600000E-05  -5.85100000E-05
   -2.92600000E-05  +3.67500000E-05  +7.79600000E-05  +3.73000000E-05  -2.10500000E-05
   +1.64200000E-05  +6.57000000E-06  -6.53200000E-05  -3.95100000E-05  -3.28400000E-05
   -7.37000000E-05  -9.43700000E-05  -9.67000000E-06  -1.02600000E-05  -7.22300000E-05
   +3.81700000E-05  -2.75340000E-04  +3.80723000E-03  +4.02962000E-03  +1.31800000E-05
   +1.02800000E-05  +1.80000000E-07  -7.50000000E-06  -6.73000000E-06  +4.47000000E-06
   +1.83600000E-05  +7.97000000E-06  -5.71000000E-06  +1.70000000E-06  +3.21900000E-05
   +6.70700000E-05  -1.13100000E-05  -1.17200000E-05  -8.46000000E-06  -1.87800000E-05
   -3.63900000E-05  -4.52700000E-05  +1.70500000E-05  +2.66900000E-05  -3.46900000E-05
   +1.43800000E-05  +5.20900000E-05  +2.69500000E-05  +1.08900000E-05  -3.58500000E-05
   -6.53000000E-06  -9.84600000E-05  +1.15270000E-04  +1.11800000E-04  +2.48000000E-05
   -3.05600000E-05  -2.67800000E-05  -1.34290000E-04  -2.75720000E-04  +3.77300000E-05
   +3.22270000E-04  +2.55940000E-04  +2.08490000E-04  -7.19048900E-02  -8.27909200E-02
   +6.05164500E-02  -6.71464900E-02  +4.08862800E-02  -3.54307800E-02  +9.49989000E-03
   -1.63830000E-02  +1.56144400E-02  -2.90489000E-03  -1.06030000E-04  +4.39270000E-03
   -1.19458000E-03  +3.27110000E-04  -3.59300000E-05  -4.93892000E-03  +3.01300000E-04
   -1.95903000E-03  -5.52006000E-03  +2.32187400E-02  -1.74716000E-02  -1.95700000E-05
   -1.29420000E-03  -7.21000000E-04  +1.40710000E-04  +7.07100000E-05  -1.47500000E-05
   -3.02290000E-04  +1.65690000E-03  +5.02560000E-04  -1.29360000E-04  -5.79000000E-06
   -2.24560000E-04  -1.25300000E-05  +3.45500000E-05  -1.13900000E-05  +2.56100000E-05
   +5.00600000E-05  +4.20100000E-05  -5.03600000E-05  -9.90500000E-05  -1.90800000E-05
   +5.58000000E-06  +8.43000000E-06  -2.67900000E-05  +2.29200000E-05  +6.29800000E-05
   +1.82400000E-05  +8.84000000E-05  +1.14090000E-04  +3.89000000E-06  -1.73772000E-03
   -2.98140000E-04  +4.16440000E-04  +5.29150000E-04  +1.31810000E-04  +2.94410000E-04
   -1.25300000E-05  -1.56500000E-05  +7.77000000E-06  +1.81500000E-05  +4.25000000E-06
   +2.20000000E-07  -1.16300000E-05  -1.27900000E-05  +6.99000000E-06  +6.94100000E-05
   -1.47000000E-05  +1.39100000E-05  +6.98000000E-06  +7.86000000E-06  +8.38000000E-06
   -9.93170000E-04  -2.61700000E-05  -4.16920000E-04  +2.67030000E-04  +6.04500000E-05
   +1.30390000E-04  -1.34372000E-03  +1.11572000E-03  -1.73330000E-04  +5.52500000E-05
   -1.60000000E-07  +3.71400000E-05  +1.80000000E-06  -4.64200000E-05  -7.30000000E-06
   +5.31700000E-05  +7.90000000E-07  -1.46050000E-04  +4.83840000E-04  -7.39290000E-04
   +1.00338000E-03  -1.21000000E-06  -1.40840000E-04  -7.72600000E-05  +7.04020000E-04
   -8.20600000E-05  +2.31100000E-04  +7.43772800E-02  +3.45306500E-02  -1.97096990E-01
   +1.42057060E-01  +5.31222000E-03  -2.66458000E-03  +7.86517000E-03  -9.21740000E-04
   +4.45051000E-03  +6.21680000E-03  -5.92630000E-04  +2.19960000E-04  -2.71152000E-03
   +1.38222000E-03  +5.37633000E-03  +3.96430000E-04  +4.88084000E-03  -6.84528000E-03
   +7.43213000E-03  +1.09730000E-04  -3.58689000E-03  -2.47046000E-03  +8.41980000E-04
   -1.72210000E-04  +6.39500000E-05  +1.14135000E-03  -1.88626000E-03  -1.76720000E-04
   -5.40760000E-04  +2.84560000E-04  +1.79370000E-04  -8.46800000E-05  -1.42010000E-04
   -8.45100000E-05  +7.30000000E-06  +1.07500000E-05  +2.77500000E-05  -1.36100000E-05
   +1.70000000E-07  +9.50000000E-07  +3.26000000E-06  -2.47600000E-05  -5.14400000E-05
   -1.00270000E-04  +8.28700000E-05  +1.46570000E-04  +1.06200000E-05  +3.57000000E-06
   -1.18000000E-05  +1.63872000E-03  +5.04090000E-04  -4.53000000E-06  -6.13670000E-04
   -1.13610000E-04  +2.26353000E-03  +1.49000000E-06  -5.07000000E-06  +3.24000000E-06
   -1.95000000E-06  -1.32000000E-05  +1.17000000E-06  +2.53000000E-06  -8.87000000E-06
   +1.05000000E-06  +6.77600000E-05  -6.74700000E-05  +1.89400000E-05  +1.53000000E-06
   -1.13400000E-05  +1.10100000E-05  -5.33560000E-04  -3.46290000E-04  -4.30750000E-04
   +3.37390000E-04  -8.47700000E-05  -5.44840000E-04  +1.58759000E-03  -7.19900000E-05
   +1.75230000E-04  -4.64700000E-05  -4.07800000E-05  +4.64100000E-05  -3.01300000E-05
   -1.65740000E-04  -2.04350000E-04  +1.05000000E-06  +3.08000000E-06  -4.83700000E-05
   +3.85860000E-04  -9.33000000E-04  +8.30520000E-04  -3.84790000E-04  -3.76410000E-04
   -6.51600000E-05  +2.22090000E-04  +2.74800000E-04  -1.65650000E-03  -4.86746400E-02
   +2.02975470E-01  -3.71644700E-02  +1.40360380E-01  -1.66447160E-01  +2.24500000E-04
   +1.77481200E-02  -1.12418800E-02  +3.68329000E-03  +5.05285000E-03  +4.83954000E-03
   -3.71760000E-04  -5.22800000E-04  -2.91869000E-03  +1.17651000E-03  +2.59367000E-03
   +4.75870000E-04  +3.58849000E-03  -1.12962000E-03  +4.09218000E-03  -2.48956000E-03
   -2.55571000E-03  -3.39569000E-03  +1.19047000E-03  -1.41790000E-04  +6.98500000E-05
   +4.02960000E-04  -8.22230000E-04  -2.96490000E-04  -4.62300000E-04  +1.29850000E-04
   +1.67420000E-04  -9.82200000E-05  -1.52880000E-04  -4.36500000E-05  +2.00900000E-05
   +2.43000000E-06  +2.86300000E-05  +1.45600000E-05  +2.26000000E-05  -2.63700000E-05
   -3.42000000E-05  -5.04300000E-05  +1.67000000E-06  -1.63100000E-05  +3.13500000E-05
   +1.67570000E-04  -2.43100000E-05  -4.48000000E-05  -2.53000000E-06  -1.22805000E-03
   +7.28940000E-04  +5.04290000E-04  -8.28950000E-04  +4.78610000E-04  +2.59268000E-03
   +2.30000000E-07  +3.86000000E-06  -5.88000000E-06  -9.45000000E-06  -8.39000000E-06
   -1.03000000E-06  +1.80000000E-06  +4.32000000E-06  -1.97000000E-05  +3.06600000E-05
   +2.33900000E-05  -3.78700000E-05  -5.90000000E-06  -8.42000000E-06  -2.71000000E-06
   -5.71830000E-04  +3.61700000E-05  -1.54100000E-05  -4.12880000E-04  -4.76750000E-04
   +1.92870000E-04  -2.33060000E-04  -6.29740000E-04  +3.77660000E-04  +3.34400000E-05
   -1.15410000E-04  -1.13740000E-04  +7.32000000E-05  -2.61100000E-04  -2.65220000E-04
   -8.82600000E-05  -1.88400000E-05  +9.55000000E-05  +6.08900000E-05  -6.94600000E-05
   +1.35480000E-04  -6.59220000E-04  -3.86230000E-04  -1.37000000E-04  +3.33700000E-05
   -5.41540000E-04  -4.57220000E-04  +3.39309000E-02  -1.59230500E-01  +1.71722240E-01
   +2.29706000E-03  +1.13480000E-04  -6.39460000E-04  -9.60200000E-04  -6.66360000E-04
   +6.94870000E-04  -9.60100000E-05  +6.23960000E-04  -1.36037000E-03  -1.36043000E-03
   -6.73700000E-04  +2.71205000E-03  +1.27446700E-02  +1.80074700E-02  -2.35374000E-03
   -5.84326000E-03  +2.01128000E-03  -2.32080000E-04  +5.75300000E-05  -4.60600000E-05
   +2.14760000E-04  -1.04220000E-04  +3.51400000E-05  -8.62000000E-05  -3.50116600E-02
   +3.10533000E-03  -5.15460000E-04  -2.76100000E-05  +1.15190000E-04  -2.12700000E-05
   -1.40900000E-05  -2.75800000E-05  -1.50200000E-05  +2.34000000E-06  -4.20600000E-05
   +9.10000000E-07  -2.27300000E-05  +2.53200000E-05  +2.09800000E-05  +8.19000000E-06
   -1.42400000E-05  +1.78000000E-05  -2.80000000E-05  -4.58600000E-05  +2.52100000E-05
   -7.03000000E-06  -4.48200000E-05  +4.19000000E-06  -9.22000000E-06  -9.71000000E-06
   +2.09000000E-05  +1.61204000E-03  -7.98176000E-03  -5.22330000E-04  -9.35000000E-06
   +5.31000000E-06  -8.01000000E-06  -5.36000000E-06  -2.81000000E-06  -3.68000000E-06
   +3.74000000E-06  +1.02800000E-05  -1.48700000E-05  -1.25700000E-05  +5.16600000E-05
   -8.20000000E-06  -2.46600000E-05  -4.01000000E-06  -2.42600000E-05  +1.26700000E-05
   +8.93000000E-06  -6.40000000E-06  -1.67500000E-05  -3.70000000E-07  -5.10000000E-07
   -6.07000000E-06  -3.14900000E-05  -7.80000000E-07  -3.16000000E-06  -2.75900000E-05
   -9.46000000E-06  -2.48800000E-05  +2.52700000E-05  +5.57500000E-05  -3.22000000E-06
   -3.98000000E-06  +3.37900000E-05  +7.71600000E-05  -1.54160000E-04  +5.08700000E-05
   +9.01900000E-05  +1.27670000E-04  -5.35800000E-05  +8.48500000E-05  -4.33790000E-04
   -8.62300000E-05  -1.87940000E-04  +1.83250000E-04  +1.32430000E-04  +1.43923400E-01
   +8.76467000E-03  -4.74200000E-04  -1.51108000E-03  -3.47297000E-03  -2.60915000E-03
   +2.43436000E-03  -1.60146000E-03  +2.56202000E-03  -2.32046000E-03  -9.74130000E-04
   -2.52136000E-03  +1.46517000E-03  +8.18710800E-02  -1.17099400E-02  +1.14552000E-03
   -1.86096100E-02  +1.23019700E-02  -2.75722000E-03  +9.94660000E-04  -3.71130000E-04
   +8.37770000E-04  -7.67530000E-04  +1.64090000E-04  -3.87260000E-04  -4.74391200E-02
   +4.60751400E-02  -6.76113000E-03  -2.98510000E-04  +8.09720000E-04  -1.46920000E-04
   +7.14300000E-05  -1.15810000E-04  -2.39280000E-04  -8.07600000E-05  -4.47000000E-04
   -1.18110000E-04  +4.32980000E-04  +7.45730000E-04  +1.95940000E-04  -1.67930000E-04
   +6.42700000E-05  +2.23960000E-04  -1.06010000E-04  -1.37980000E-04  -8.27600000E-05
   -6.66550000E-04  -8.93220000E-04  -3.01000000E-05  -3.91260000E-04  -3.92700000E-05
   +1.38460000E-04  -2.39068000E-03  -3.43849000E-02  +4.78449000E-03  +8.77400000E-05
   +1.17390000E-04  -4.10200000E-05  -9.52800000E-05  -5.30000000E-05  +2.69600000E-05
   +7.03000000E-05  +6.35100000E-05  -4.64100000E-05  +7.45900000E-05  +2.56840000E-04
   +2.18330000E-04  -7.79700000E-05  -4.51400000E-05  -1.08250000E-04  +1.29080000E-04
   +2.16800000E-05  +1.86600000E-05  -2.25010000E-04  +1.07950000E-04  -5.47000000E-05
   +4.68200000E-05  -1.87860000E-04  +2.76000000E-05  +5.04700000E-05  -1.84290000E-04
   -9.77300000E-05  -2.92640000E-04  +2.63230000E-04  +2.70020000E-04  +8.56800000E-05
   -7.81600000E-05  +3.00700000E-05  -4.89900000E-05  -1.44250000E-04  +3.24030000E-04
   -1.80670000E-04  +7.58420000E-04  +8.34620000E-04  -2.96890000E-04  -1.36729000E-03
   -3.66700000E-04  -4.22220000E-04  +8.28840000E-04  +3.17620000E-04  +5.39019700E-02
   +7.01741600E-02  -1.52981000E-03  +6.72400000E-04  +1.28112000E-03  +6.90460000E-04
   +2.81670000E-04  -1.79710000E-04  +8.95700000E-05  -7.73200000E-05  +4.12100000E-04
   +9.39940000E-04  -3.58260000E-04  -1.34881000E-03  -1.10550000E-02  +2.80504000E-03
   -1.39264000E-03  +2.81339000E-03  -2.14549000E-03  +1.18372000E-03  -1.74450000E-04
   +4.25000000E-06  -2.07450000E-04  +1.48460000E-04  -3.63200000E-05  +7.98400000E-05
   +6.71498000E-03  -1.04409100E-02  -1.73526200E-02  +3.16300000E-05  -1.12840000E-04
   +9.97000000E-06  -3.13000000E-06  +1.80400000E-05  +1.99100000E-05  +1.33800000E-05
   +6.11100000E-05  +4.92000000E-06  -4.56800000E-05  -8.95700000E-05  -2.08100000E-05
   +2.04900000E-05  +2.61000000E-06  -3.54000000E-05  -3.51000000E-06  +3.73200000E-05
   +1.85400000E-05  +7.69600000E-05  +1.11030000E-04  -5.17000000E-06  +4.69900000E-05
   +1.19100000E-05  -1.86100000E-05  -2.86157000E-03  +5.62520000E-03  -4.35040000E-04
   -6.15000000E-06  -1.59500000E-05  +1.00800000E-05  +1.51300000E-05  +5.55000000E-06
   -1.61000000E-06  -4.85000000E-06  -1.34100000E-05  +8.82000000E-06  -2.63000000E-06
   -3.80800000E-05  -1.70300000E-05  +1.04800000E-05  +1.00000000E-07  +2.20100000E-05
   -2.17300000E-05  -7.56000000E-06  -8.34000000E-06  +3.40800000E-05  -1.44100000E-05
   +3.33000000E-06  -3.50000000E-06  +3.14700000E-05  -1.40000000E-06  -4.57000000E-06
   +2.73600000E-05  +2.10700000E-05  +4.29900000E-05  -4.08900000E-05  -6.43300000E-05
   -1.92000000E-06  +1.40700000E-05  -2.75900000E-05  +7.71000000E-06  +2.05300000E-05
   -8.28400000E-05  +1.63010000E-04  +3.24400000E-05  -1.54480000E-04  -5.67900000E-05
   -3.89800000E-05  -4.58290000E-04  +1.52120000E-04  -2.24810000E-04  -1.53590000E-04
   -9.38970000E-04  -1.08910200E-02  +6.46893000E-02  -3.54513000E-03  -3.25600000E-05
   +7.74460000E-04  +2.02080000E-03  +8.57530000E-04  -1.13982000E-03  -1.27015000E-03
   -9.23410000E-04  +4.93714000E-03  +6.05678000E-03  +3.67930000E-03  -1.45333500E-02
   -4.70574900E-02  -7.03670000E-03  +4.38332000E-03  +1.05147200E-02  -1.92903000E-03
   -3.96500000E-05  +2.99340000E-04  +1.68500000E-05  -2.96200000E-04  -3.39800000E-05
   -3.43800000E-05  +1.10410000E-04  +3.27144800E-02  -4.42057500E-02  +7.37311000E-03
   -2.34600000E-05  +1.14000000E-06  +2.99000000E-06  +8.38000000E-05  +2.96600000E-05
   -6.54900000E-05  -4.60300000E-05  -7.93200000E-05  -6.40200000E-05  +3.20510000E-04
   +3.04130000E-04  +2.20700000E-05  -1.21370000E-04  +8.61000000E-05  +5.77400000E-05
   +4.96400000E-05  +8.97900000E-05  -1.26700000E-04  -3.22980000E-04  -3.21640000E-04
   -2.58700000E-05  -1.70820000E-04  +2.68800000E-05  -1.72000000E-06  -3.99693500E-02
   +8.59450500E-02  -1.00676000E-03  +7.33700000E-05  +4.70900000E-05  +2.42000000E-06
   -3.21800000E-05  -1.53000000E-05  +2.45400000E-05  +2.48800000E-05  -3.40000000E-06
   +2.60600000E-05  +8.57400000E-05  -4.44500000E-05  +1.53130000E-04  +4.32100000E-05
   -9.32000000E-06  +2.97600000E-05  +2.51600000E-05  -1.36100000E-05  +3.33700000E-05
   -6.06300000E-05  +4.91100000E-05  -2.25100000E-05  +4.04900000E-05  -3.51000000E-06
   +1.33200000E-05  +3.43900000E-05  +4.35000000E-06  -1.92400000E-05  -5.76900000E-05
   +4.94500000E-05  -6.27200000E-05  +5.59500000E-05  -3.02500000E-05  -1.08430000E-04
   -6.29800000E-04  +5.53200000E-04  -7.12800000E-05  -4.32680000E-04  -1.00100000E-03
   +1.15836000E-03  -1.87100000E-04  +1.45459000E-03  -2.11980000E-04  +1.90630000E-04
   -1.75660000E-04  -2.87990000E-04  -8.74430000E-02  -3.43479200E-02  -2.54617800E-02
   +2.17905190E-01  -4.00947000E-03  +2.61780000E-04  +7.83320000E-04  +9.97120000E-04
   +1.36411000E-03  -1.01518000E-03  +2.48601000E-03  -1.26662000E-03  -2.58438000E-03
   -3.55677000E-03  -2.24554000E-03  +1.16391900E-02  -3.04718600E-02  +6.95862000E-03
   -3.32218000E-03  +7.48941000E-03  -6.94498000E-03  +1.50038000E-03  -1.01349000E-03
   +2.43460000E-04  -4.51040000E-04  +6.33880000E-04  -9.82500000E-05  +2.09950000E-04
   +1.12500700E-02  -8.47626300E-02  +1.43906800E-02  +2.24330000E-04  -6.50830000E-04
   +1.18980000E-04  -1.16210000E-04  +7.94400000E-05  +2.39700000E-04  +9.36500000E-05
   +4.21190000E-04  +1.41770000E-04  -5.75650000E-04  -8.33270000E-04  -1.78730000E-04
   +2.21310000E-04  -9.32700000E-05  -2.63650000E-04  +1.54400000E-05  +3.19800000E-05
   +1.53960000E-04  +7.64810000E-04  +9.86980000E-04  +3.31900000E-05  +4.46350000E-04
   +1.58100000E-05  -9.76800000E-05  +5.22233300E-02  -4.17697300E-02  -4.92602000E-03
   -1.08210000E-04  -1.34620000E-04  +3.93400000E-05  +1.01570000E-04  +5.04700000E-05
   -3.34000000E-05  -7.98100000E-05  -4.61200000E-05  +2.28200000E-05  -1.33330000E-04
   -1.96840000E-04  -2.78340000E-04  +5.51500000E-05  +3.86900000E-05  +9.94800000E-05
   -1.26190000E-04  -1.32000000E-05  -3.76200000E-05  +2.23770000E-04  -1.24290000E-04
   +5.97000000E-05  -6.07200000E-05  +1.67560000E-04  -3.51000000E-05  -5.98100000E-05
   +1.49420000E-04  +9.00600000E-05  +2.70940000E-04  -2.48940000E-04  -1.56960000E-04
   -1.16900000E-04  +8.08900000E-05  +6.06900000E-05  +6.54560000E-04  -3.86710000E-04
   -2.04090000E-04  +2.05870000E-04  -3.07600000E-05  -1.96697000E-03  +2.60280000E-04
   +1.14090000E-04  +2.42090000E-04  +2.42850000E-04  -5.18280000E-04  -1.79700000E-05
   -7.83663200E-02  -1.19819390E-01  -3.52278000E-03  -9.01012000E-03  +3.77964030E-01
   +9.37450000E-04  -2.20280000E-04  -4.20310000E-04  -3.60750000E-04  -2.44160000E-04
   +2.04420000E-04  -4.57800000E-04  +1.21440000E-04  +7.37330000E-04  -1.44563000E-03
   +3.36379000E-03  -5.41030000E-04  +9.15208000E-03  -1.05458000E-03  +9.88650000E-04
   -2.04867000E-03  +1.03895000E-03  -5.72900000E-04  +6.40300000E-05  -3.80000000E-05
   +1.26940000E-04  -8.18400000E-05  +2.26000000E-05  -5.09900000E-05  -2.70452000E-03
   +2.05741600E-02  +9.33799000E-03  -3.28700000E-05  +5.88300000E-05  +9.48000000E-06
   +8.42000000E-06  -1.09000000E-06  -5.79000000E-06  -1.38100000E-05  -4.02000000E-05
   +7.04000000E-06  +3.95500000E-05  +6.31100000E-05  +6.51000000E-06  -1.46800000E-05
   -1.10300000E-05  +1.82300000E-05  +2.72000000E-05  -1.41100000E-05  -2.47100000E-05
   -5.12800000E-05  -7.31600000E-05  +1.30400000E-05  -1.19300000E-05  -1.44500000E-05
   +3.44000000E-06  -5.05263000E-03  +2.37870000E-04  +1.61613300E-02  +1.29000000E-06
   +1.31900000E-05  -1.19200000E-05  -1.36000000E-05  -8.70000000E-07  +6.90000000E-07
   -1.16000000E-06  +1.08200000E-05  -4.04000000E-06  -1.02000000E-06  +1.44000000E-06
   +5.64000000E-06  +5.95000000E-06  +6.47000000E-06  -1.31100000E-05  +1.08900000E-05
   +4.57000000E-06  +7.06000000E-06  -1.68400000E-05  +5.03000000E-06  +3.20000000E-07
   +2.26000000E-06  -1.47200000E-05  +1.30000000E-07  +4.26000000E-06  -1.21300000E-05
   -1.25400000E-05  -2.34500000E-05  +2.37500000E-05  +3.42800000E-05  +8.10000000E-07
   -1.31600000E-05  +1.43900000E-05  -2.43610000E-04  +4.83400000E-05  -7.27000000E-06
   -6.70800000E-04  +3.23280000E-04  +4.63880000E-04  -4.87000000E-06  -1.16130000E-04
   +9.91500000E-05  -6.97300000E-05  +1.08900000E-04  +7.00300000E-05  +3.58290000E-04
   +1.44311000E-02  -4.68638800E-02  +1.07629970E-01  -2.12009970E-01  +4.87285240E-01
   +5.17900000E-05  -4.86000000E-05  +1.36990000E-04  +4.53600000E-05  -5.79700000E-05
   +3.26100000E-05  -2.99320000E-04  -1.50200000E-05  +6.42160000E-04  -5.27400000E-05
   +1.13304000E-03  -1.55578000E-03  -2.16756000E-03  -2.11800000E-04  -1.57240000E-04
   +3.59980000E-04  -1.13070000E-04  +4.75500000E-05  -5.07200000E-05  +7.64000000E-06
   +3.79400000E-05  +1.13000000E-05  +2.20000000E-06  -1.76000000E-06  +4.41090000E-04
   -5.66554000E-03  -6.75780000E-04  +2.05700000E-05  -1.49400000E-05  +4.51000000E-06
   -1.04500000E-05  -3.55000000E-06  +1.49300000E-05  +7.12000000E-06  +1.22700000E-05
   +1.56600000E-05  -4.70900000E-05  -4.20100000E-05  -5.70000000E-06  +1.82800000E-05
   -2.44300000E-05  +1.04100000E-05  +2.06300000E-05  +9.80000000E-07  +9.93000000E-06
   +5.34900000E-05  +3.42200000E-05  +1.28800000E-05  +3.17700000E-05  -7.92000000E-06
   -7.90000000E-06  -4.69161000E-03  +6.15732000E-03  +3.15068000E-03  -2.09900000E-05
   -3.84000000E-06  -6.43000000E-06  +2.58000000E-06  +5.40000000E-06  -7.23000000E-06
   -3.19000000E-06  -3.90000000E-07  -4.84000000E-06  -2.79000000E-06  +4.70000000E-06
   -1.81600000E-05  -1.25000000E-05  +5.13000000E-06  -1.83000000E-05  -4.89000000E-06
   +2.25000000E-06  -5.50000000E-06  +1.38300000E-05  -6.82000000E-06  +3.97000000E-06
   -8.79000000E-06  +2.00000000E-07  -2.80000000E-07  -7.86000000E-06  +6.90000000E-07
   +4.53000000E-06  +1.40000000E-05  -7.43000000E-06  -1.85000000E-06  -4.42000000E-06
   +4.95000000E-06  +7.46000000E-06  -1.26950000E-04  +5.81000000E-05  -2.39500000E-05
   -2.08130000E-04  +1.66490000E-04  +5.63070000E-04  +7.90000000E-07  -1.26400000E-05
   -9.83300000E-05  +1.64100000E-05  -1.51300000E-05  +1.82200000E-05  +8.80911000E-03
   +1.23953000E-03  +1.83654000E-02  -7.07728800E-02  +4.92632700E-02  -1.13950010E-01
   +6.18182700E-02  +2.36340000E-04  +4.27500000E-05  +6.26900000E-05  -2.28600000E-05
   -3.23100000E-05  +8.38300000E-05  -3.77200000E-05  +2.66700000E-05  -2.24450000E-04
   +3.92770000E-04  -7.68470000E-04  +1.35110000E-04  -7.48400000E-05  -8.69760000E-04
   +2.61620000E-04  -1.59200000E-04  +4.90310000E-04  -5.21100000E-05  +1.25180000E-04
   -2.36100000E-05  -5.20000000E-07  -5.41900000E-05  +1.71000000E-06  -1.14400000E-05
   -2.12559000E-03  -4.11539000E-03  -2.16708000E-03  -3.17700000E-05  +7.01800000E-05
   -1.60400000E-05  +2.04600000E-05  -3.24000000E-06  -3.05800000E-05  -1.53800000E-05
   -5.98400000E-05  -2.19800000E-05  +1.06650000E-04  +1.40820000E-04  +2.26100000E-05
   -3.78300000E-05  +1.19900000E-05  +3.84800000E-05  +6.40000000E-06  +6.66000000E-06
   -2.55500000E-05  -1.23580000E-04  -1.60750000E-04  -1.97000000E-06  -6.24000000E-05
   -2.43000000E-06  +6.28000000E-06  +1.92762000E-03  -1.33990000E-04  -1.30656000E-03
   +1.66300000E-05  +2.46000000E-05  -7.19000000E-06  -1.53600000E-05  -5.43000000E-06
   +5.77000000E-06  +1.15100000E-05  +4.66000000E-06  -9.10000000E-07  +1.71000000E-05
   +1.49100000E-05  +3.59800000E-05  -2.10000000E-07  -1.65000000E-06  -1.36300000E-05
   +1.58300000E-05  +1.11000000E-06  +5.01000000E-06  -2.80200000E-05  +1.82400000E-05
   -8.53000000E-06  +8.50000000E-06  -1.95600000E-05  +6.04000000E-06  +7.53000000E-06
   -1.96600000E-05  -7.49000000E-06  -3.28600000E-05  +2.68400000E-05  +8.96000000E-06
   +1.91600000E-05  -7.55000000E-06  -1.10100000E-05  +1.50400000E-05  -9.41000000E-06
   +2.08500000E-05  +3.34860000E-04  +6.97100000E-05  -2.12420000E-04  -3.31000000E-05
   -7.90000000E-07  -9.30500000E-05  +1.36500000E-05  +1.90400000E-05  -2.46900000E-05
   +1.23369900E-02  -4.54710000E-03  +2.48483100E-02  +3.82797200E-02  -1.06191310E-01
   +1.72046320E-01  -4.94119800E-02  +1.19974610E-01  -2.91000000E-04  +4.71000000E-05
   -8.60000000E-07  +7.18800000E-05  +1.29670000E-04  -8.59300000E-05  +2.47260000E-04
   -1.02800000E-04  -3.87240000E-04  -4.84420000E-04  -3.63360000E-04  +1.36591000E-03
   -3.80030000E-04  +9.73700000E-04  -3.65760000E-04  +1.99470000E-04  -4.44740000E-04
   +1.17750000E-04  -2.95500000E-05  +2.84500000E-05  -2.18500000E-05  +2.73300000E-05
   -7.98000000E-06  +1.49600000E-05  +5.30440000E-04  -2.89298000E-03  +7.50240000E-04
   +1.96800000E-05  -2.45100000E-05  -6.35000000E-06  -1.19300000E-05  -3.65000000E-06
   +5.05000000E-06  +8.43000000E-06  +2.18300000E-05  -2.54000000E-06  -2.98200000E-05
   -3.60100000E-05  -2.16000000E-06  +1.00000000E-05  -3.92000000E-06  -3.63000000E-06
   -7.47000000E-06  +3.63000000E-06  +1.83800000E-05  +3.41300000E-05  +3.89700000E-05
   -6.01000000E-06  +1.34300000E-05  +1.13000000E-06  -2.91000000E-06  +3.93563000E-03
   -5.36169000E-03  -6.88710000E-04  -4.01000000E-06  -7.35000000E-06  +6.31000000E-06
   +8.47000000E-06  +6.40000000E-07  -1.08000000E-06  +9.80000000E-07  -5.77000000E-06
   +2.40000000E-07  -3.53000000E-06  +4.84000000E-06  -1.45200000E-05  -6.78000000E-06
   -1.47000000E-06  -1.13000000E-06  -4.81000000E-06  -8.50000000E-07  -5.42000000E-06
   +9.40000000E-06  -3.63000000E-06  +2.00000000E-06  -3.12000000E-06  +4.93000000E-06
   +2.20000000E-07  -3.74000000E-06  +2.81000000E-06  +6.28000000E-06  +1.11100000E-05
   -1.02200000E-05  -9.13000000E-06  -1.99000000E-06  +8.14000000E-06  -1.01000000E-06
   +9.06400000E-05  -6.78000000E-05  -2.47600000E-05  +2.03870000E-04  +3.83200000E-05
   -1.82030000E-04  +4.06700000E-05  -3.08100000E-05  +5.57400000E-05  +2.64000000E-06
   -3.23100000E-05  -1.50600000E-05  -1.20959000E-03  +1.74236000E-03  -5.14696000E-03
   -1.10597850E-01  +2.04420100E-01  -4.19393890E-01  +1.13495210E-01  -2.01975310E-01
   +4.21833690E-01  +2.89236000E-03  -3.83500000E-05  -7.03850000E-04  -1.97896000E-03
   -9.75500000E-04  +1.45318000E-03  +1.50186000E-03  +9.63700000E-04  -5.20626000E-03
   -1.34207000E-02  +2.25352000E-03  +1.63172400E-02  +5.60898400E-02  -7.42111000E-03
   -4.63970000E-03  -1.16761100E-02  -1.20932000E-03  +8.94960000E-04  -6.84330000E-04
   +1.33530000E-04  +2.31560000E-04  +2.34810000E-04  +1.33600000E-05  -3.04900000E-05
   -2.19685800E-02  +2.58425500E-02  -2.79727000E-03  +1.20970000E-04  -2.28130000E-04
   +3.21600000E-05  -1.40550000E-04  -3.34000000E-06  +1.56890000E-04  +9.48000000E-05
   +2.50490000E-04  +1.13430000E-04  -5.96320000E-04  -6.70560000E-04  -8.16100000E-05
   +2.27040000E-04  -1.45180000E-04  -1.76170000E-04  -5.81600000E-05  -1.02600000E-04
   +2.22600000E-04  +6.57810000E-04  +7.50810000E-04  +3.27600000E-05  +3.57490000E-04
   -3.54600000E-05  -2.96400000E-05  -3.47714600E-02  -3.13670600E-02  +9.70460000E-04
   -1.17570000E-04  -1.07820000E-04  +1.78200000E-05  +7.84400000E-05  +3.35100000E-05
   -3.81400000E-05  -5.20100000E-05  -1.55600000E-05  -2.20700000E-05  -1.40930000E-04
   -4.62000000E-06  -2.88570000E-04  -3.16600000E-05  +1.96600000E-05  +3.28000000E-06
   -7.58800000E-05  +8.09000000E-06  -6.23600000E-05  +1.52340000E-04  -1.03160000E-04
   +4.26100000E-05  -6.79800000E-05  +7.20100000E-05  -2.56200000E-05  -6.01700000E-05
   +5.16300000E-05  +5.49400000E-05  +1.60440000E-04  -1.34770000E-04  +5.55000000E-06
   -9.62600000E-05  +6.70100000E-05  +1.17830000E-04  +8.32890000E-04  -2.99830000E-04
   +1.00220000E-04  +1.98497000E-03  +3.98520000E-04  -2.13860000E-03  +4.93590000E-04
   -2.05233000E-03  +8.46090000E-04  -4.92700000E-05  +8.02900000E-05  +3.70730000E-04
   -3.85015200E-02  -3.48668500E-02  +1.17988700E-02  -1.83623800E-02  -3.19090000E-04
   +9.02904000E-03  +6.75652000E-03  -1.62506000E-03  -5.89103000E-03  +7.02146300E-02
   -1.64651000E-03  +6.20400000E-05  +2.54940000E-04  +1.69097000E-03  +1.02190000E-04
   -6.07540000E-04  -3.54134000E-03  +2.70860000E-04  +7.72195000E-03  +9.92825000E-03
   +4.26970000E-03  -2.39532200E-02  -3.74246400E-02  -3.03287400E-02  +1.08068700E-02
   +5.70723000E-03  +1.32924000E-03  -5.78160000E-04  +1.01829000E-03  -1.03140000E-04
   -3.51100000E-05  -4.61380000E-04  +1.62300000E-05  -4.36000000E-06  +2.10470000E-02
   -2.10779800E-02  +1.19088000E-03  -1.16120000E-04  +4.54860000E-04  -8.68200000E-05
   +1.61210000E-04  -4.04700000E-05  -2.41020000E-04  -9.67800000E-05  -3.65570000E-04
   -1.63610000E-04  +6.48990000E-04  +8.38400000E-04  +1.59200000E-04  -2.45650000E-04
   +1.25070000E-04  +2.87270000E-04  +4.81100000E-05  +7.90800000E-05  -2.05870000E-04
   -7.97210000E-04  -9.89580000E-04  -4.17200000E-05  -4.95010000E-04  +1.21400000E-05
   +5.39700000E-05  -6.41478000E-03  -1.26578000E-02  +1.38179400E-02  +1.23000000E-04
   +1.35580000E-04  -3.12200000E-05  -9.86900000E-05  -4.75600000E-05  +3.68800000E-05
   +8.75400000E-05  +2.33900000E-05  +3.12000000E-06  +1.97080000E-04  +1.45580000E-04
   +3.32240000E-04  -4.35400000E-05  -4.03600000E-05  -8.44400000E-05  +1.09900000E-04
   +8.90000000E-07  +5.20200000E-05  -2.06010000E-04  +1.42240000E-04  -6.82800000E-05
   +7.35600000E-05  -1.26100000E-04  +4.10800000E-05  +6.74100000E-05  -1.02430000E-04
   -7.79500000E-05  -2.34100000E-04  +2.22360000E-04  +2.54600000E-05  +1.46940000E-04
   -8.16300000E-05  -1.64690000E-04  -1.15831000E-03  +1.05487000E-03  +2.22880000E-04
   -2.02987000E-03  +3.18500000E-04  +4.07917000E-03  -8.14500000E-05  +1.28102000E-03
   -3.17510000E-04  +5.26000000E-05  +1.41760000E-04  -3.24860000E-04  -2.11183000E-03
   +4.48154600E-02  -6.54181000E-03  -3.22565900E-02  -2.25529600E-02  +1.37408000E-03
   -2.43527000E-03  -3.97256000E-03  +3.91051000E-03  +5.07870300E-02  +3.66454200E-02
   +6.11170000E-04  -1.24670000E-04  -3.90590000E-04  -3.42710000E-04  -2.89500000E-04
   +2.14240000E-04  +1.03728000E-03  +6.85690000E-04  -4.03725000E-03  +9.34640000E-03
   -1.89303100E-02  +2.39323000E-03  -2.83311000E-03  +3.10097000E-03  +7.80010000E-04
   +1.44970000E-04  +8.36490000E-04  -3.40690000E-04  +3.95700000E-05  +8.42500000E-05
   -3.00000000E-06  -1.93000000E-06  +2.60000000E-07  +2.56000000E-06  -2.23470000E-04
   +8.37930000E-04  -1.53433000E-03  +4.18700000E-05  +2.96300000E-05  -2.33900000E-05
   -9.43000000E-06  -1.83800000E-05  -1.22200000E-05  +1.41100000E-05  +4.02000000E-06
   -1.63200000E-05  -5.35500000E-05  -3.79100000E-05  +1.68000000E-05  +2.30700000E-05
   +1.07000000E-05  -3.72000000E-06  -5.68600000E-05  -2.78400000E-05  +3.71500000E-05
   +3.63900000E-05  +3.36700000E-05  -1.35100000E-05  -2.51200000E-05  +1.51800000E-05
   +1.50100000E-05  +2.44560000E-04  +2.25141400E-02  -4.23788000E-02  -3.09000000E-06
   -8.73000000E-06  +7.35000000E-06  +9.25000000E-06  -3.00000000E-06  -2.49000000E-06
   +6.25000000E-06  -3.35000000E-06  -6.00000000E-06  +3.66000000E-06  +5.58600000E-05
   +1.50000000E-07  -2.95900000E-05  -1.37100000E-05  -6.28000000E-06  +1.88000000E-06
   +2.21000000E-06  -8.56000000E-06  -3.91000000E-06  +5.50000000E-07  -6.33000000E-06
   -3.44000000E-06  -1.28500000E-05  +5.40000000E-07  -5.12000000E-06  -1.05000000E-05
   +3.09000000E-06  +6.00000000E-07  -2.27000000E-06  +4.78000000E-06  -1.30000000E-06
   +1.29200000E-05  +9.76000000E-06  +8.94500000E-04  -1.12590000E-04  +3.42750000E-04
   +6.99280000E-04  -2.79290000E-04  -9.30040000E-04  -2.09300000E-05  +4.15830000E-04
   +3.76720000E-04  -4.14000000E-06  +1.02410000E-04  +6.34000000E-05  +3.76767000E-03
   -3.50692000E-03  +6.21187000E-03  +2.74111600E-02  -3.14332000E-03  -4.76727800E-02
   -2.00350800E-02  +8.62467000E-03  +2.19217000E-03  -2.06808600E-02  -1.08422600E-02
   +8.47147100E-02
end_hess

