# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -806.82562090    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +3.98727245E+00  +2.10075178E+00  -1.28108184E+00
   006   +1.95389229E+00  +1.66080831E+00  +1.89069661E-01
   006   +2.01002864E+00  -1.48368704E-01  +2.26626017E+00
   006   +3.34576897E+00  -2.25780372E+00  +2.40967823E+00
   006   +6.96106981E+00  -1.40127308E+00  -3.98662881E-01
   006   +6.45886361E+00  +9.45542358E-01  -1.18635977E+00
   006   -5.14915164E-01  +3.16218054E+00  -5.36985202E-02
   006   -6.73947617E-01  +5.03247976E+00  +2.16403984E+00
   008   +8.74286340E+00  -2.94327005E+00  -5.07675987E-02
   006   -2.73042086E+00  +1.29835850E+00  -8.25664939E-02
   006   -4.86386398E+00  +1.56829190E+00  +1.41555980E+00
   006   -6.86018041E+00  -1.32168262E-01  +1.27942740E+00
   006   -6.75213826E+00  -2.15296655E+00  -3.80619055E-01
   006   -4.62973936E+00  -2.46222848E+00  -1.89783446E+00
   006   -2.66398363E+00  -7.57527719E-01  -1.73425634E+00
   008   -8.63856024E+00  -3.88130451E+00  -5.99915058E-01
   006   -6.42628519E-01  +4.71348148E+00  -2.50316365E+00
   008   +4.77005729E+00  -3.11116358E+00  +3.41726824E-01
   001   -9.98461433E+00  -3.45985137E+00  +5.31277951E-01
   001   -8.50117524E+00  +1.26823384E-01  +2.47859215E+00
   001   -5.01485408E+00  +3.12096411E+00  +2.73432172E+00
   001   -1.01070846E+00  -1.04105358E+00  -2.90792537E+00
   001   -4.54701942E+00  -4.04856336E+00  -3.18330569E+00
   001   -3.85947627E-01  +3.52864457E+00  -4.16800657E+00
   001   -2.49359338E+00  +5.60655357E+00  -2.64123394E+00
   001   +7.78749794E-01  +6.20643452E+00  -2.53211489E+00
   001   +9.88685771E-01  +6.24697381E+00  +2.14799295E+00
   001   -2.33870803E+00  +6.23715433E+00  +2.00134697E+00
   001   -7.54070778E-01  +4.08959011E+00  +3.99392087E+00
   001   +8.31095439E-01  +2.33559622E-01  +3.89539602E+00
   001   +3.40418430E+00  -3.52243026E+00  +4.00755872E+00
   001   +8.06514471E+00  +1.99428999E+00  -1.88699315E+00
   001   +3.83319668E+00  +3.59031766E+00  -2.67425090E+00
   001   +6.62593339E+00  -4.21609250E+00  +6.56443800E-01
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -1.80000000E-07  +1.08000000E-06  +5.10000000E-07
   -2.00000000E-08  +3.00000000E-07  +2.80000000E-07
   +1.40000000E-07  -4.60000000E-07  -2.60000000E-07
   +3.90000000E-07  -4.40000000E-07  -1.11000000E-06
   +3.80000000E-07  +1.33000000E-06  -7.60000000E-07
   -2.00000000E-08  +1.28000000E-06  +2.20000000E-07
   -3.40000000E-07  +5.00000000E-08  +8.50000000E-07
   -6.20000000E-07  -7.90000000E-07  +1.53000000E-06
   +4.40000000E-07  +1.20000000E-06  -1.15000000E-06
   -4.00000000E-08  -2.70000000E-07  +1.20000000E-07
   -2.70000000E-07  -1.12000000E-06  +2.70000000E-07
   +1.20000000E-07  -1.25000000E-06  -4.00000000E-07
   +4.40000000E-07  -8.00000000E-07  -1.25000000E-06
   +3.30000000E-07  +6.00000000E-08  -1.21000000E-06
   +2.60000000E-07  +3.70000000E-07  -5.70000000E-07
   +6.70000000E-07  -8.20000000E-07  -1.79000000E-06
   -4.90000000E-07  +9.10000000E-07  +1.42000000E-06
   +4.00000000E-07  +5.70000000E-07  -1.23000000E-06
   +5.70000000E-07  -1.46000000E-06  -1.68000000E-06
   +6.00000000E-08  -1.96000000E-06  -3.70000000E-07
   -3.70000000E-07  -1.57000000E-06  +7.80000000E-07
   +3.40000000E-07  +9.70000000E-07  -6.80000000E-07
   +7.10000000E-07  +6.10000000E-07  -1.78000000E-06
   -2.90000000E-07  +1.50000000E-06  +9.70000000E-07
   -6.20000000E-07  +6.90000000E-07  +1.71000000E-06
   -6.80000000E-07  +1.09000000E-06  +1.99000000E-06
   -7.50000000E-07  -5.60000000E-07  +1.99000000E-06
   -7.60000000E-07  -9.60000000E-07  +1.94000000E-06
   -5.20000000E-07  -1.47000000E-06  +1.22000000E-06
   -4.00000000E-08  -1.21000000E-06  -1.10000000E-07
   +5.10000000E-07  -9.20000000E-07  -1.48000000E-06
   -1.50000000E-07  +1.82000000E-06  +6.00000000E-07
   -3.40000000E-07  +1.52000000E-06  +1.09000000E-06
   +7.60000000E-07  +7.30000000E-07  -1.69000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.67266180E-01  -6.40113500E-02  +4.28728620E-01  -1.78257200E-01  -2.50989510E-01
   +4.66693380E-01  -3.26272470E-01  -4.97290100E-02  +1.77941050E-01  +6.23766070E-01
   -2.33855900E-02  -1.06410070E-01  +5.75350000E-02  -4.16315400E-02  +3.69151810E-01
   +1.62738030E-01  +7.26864500E-02  -2.03784880E-01  -1.96578820E-01  -1.80197730E-01
   +4.78776150E-01  +9.34365000E-03  -2.08885600E-02  +1.83283900E-02  -9.13581700E-02
   +9.51397000E-03  +1.81423800E-02  +4.44772060E-01  -2.25642700E-02  +3.48412000E-03
   +2.37186800E-02  +2.33470900E-02  -1.40838620E-01  +6.37014200E-02  -3.00268230E-01
   +6.48739220E-01  +2.16058700E-02  +1.28166100E-02  -2.52354400E-02  -2.63573000E-03
   +8.14497200E-02  -1.68699770E-01  -1.61890470E-01  -9.54192600E-02  +5.28333120E-01
   -7.12974000E-03  -4.64780000E-04  +9.52846000E-03  +9.72213000E-03  +1.90076600E-02
   -2.01394100E-02  -1.91494170E-01  +2.08955050E-01  -3.66900000E-05  +3.45918810E-01
   +2.46173000E-03  +9.59730000E-04  -4.63406000E-03  +1.30160700E-02  -2.36598100E-02
   +1.79190500E-02  +2.20358490E-01  -4.18437500E-01  +4.60865600E-02  -2.96639930E-01
   +7.12352380E-01  -1.63740500E-02  +7.82425000E-03  -1.64805000E-03  -5.52166000E-03
   +2.78429300E-02  -1.76068000E-03  -4.97922000E-03  +3.95501000E-02  -9.48922900E-02
   -7.99150800E-02  -1.81964730E-01  +5.13659610E-01  -7.92361000E-03  +2.98448700E-02
   -1.15943900E-02  +5.21720000E-04  +2.72338000E-03  -4.72843000E-03  +2.57176000E-03
   -5.28955000E-03  +2.47340000E-04  -2.99636100E-02  +1.89987800E-02  +2.58971200E-02
   +3.89705820E-01  +4.72118600E-02  -3.14962300E-02  +5.00606000E-03  -2.10020700E-02
   -6.14575000E-03  +1.06300000E-02  +2.02066000E-03  +6.38357000E-03  -2.08744800E-02
   -1.13390600E-02  +2.37761000E-02  +3.85572200E-02  -2.89068930E-01  +8.45387820E-01
   -2.96933800E-02  +1.31637200E-02  -2.51406000E-03  +1.36649200E-02  +7.11458000E-03
   -8.72430000E-03  +2.00450000E-03  -8.62464000E-03  +1.23816900E-02  +1.53353700E-02
   +7.67682000E-03  -3.21236400E-02  +7.22455000E-02  -1.97467190E-01  +2.17270910E-01
   -2.35928630E-01  +7.91762500E-02  -7.06092000E-03  -3.93751300E-02  +1.63488000E-03
   +1.52055700E-02  -3.38581000E-03  +8.97036000E-03  -1.03034300E-02  +9.83346000E-03
   -3.34205000E-03  +2.96454000E-03  -1.04094880E-01  +6.89215200E-02  -6.57880000E-03
   +6.28965530E-01  +4.68230800E-02  -1.13675070E-01  +2.66508200E-02  +1.37975200E-02
   +1.99406800E-02  -1.52624100E-02  +1.67993000E-03  -1.32244100E-02  +1.03747900E-02
   +1.51439000E-03  -5.68193000E-03  -1.53017100E-02  +6.48603200E-02  -3.99172790E-01
   +1.04495210E-01  -4.79566000E-02  +6.99758520E-01  +1.11970000E-02  +2.02797000E-02
   -6.49831300E-02  +1.27952500E-02  -1.00411900E-02  +7.90780000E-03  +2.12000000E-04
   -2.02849000E-03  -3.88881000E-03  -1.66377000E-03  +2.63778000E-03  +7.62728000E-03
   -1.95231600E-02  +1.15467050E-01  -8.80274400E-02  -7.28925500E-02  -2.29876100E-01
   +2.01675380E-01  -2.58593100E-02  +1.20098200E-02  +2.74496000E-03  -1.38394690E-01
   +4.06523800E-02  -2.05761000E-03  -6.47980000E-04  +4.49428000E-03  -5.77253000E-03
   -1.22760000E-04  -1.65676000E-03  +2.07003000E-03  -1.48130000E-03  +1.72767000E-03
   -7.45360000E-04  +2.59036000E-03  -2.33020000E-04  +3.38752000E-03  +4.67705720E-01
   -1.09800000E-04  +6.60639000E-03  -3.96357000E-03  +4.17046200E-02  -9.73032100E-02
   +8.90956000E-03  +1.94023000E-02  -1.78489600E-02  +7.57566000E-03  -1.93600000E-03
   +7.83300000E-04  +2.40915000E-03  -3.63800000E-05  -1.52228000E-03  +2.32340000E-04
   -3.14610000E-04  +5.42913000E-03  +5.09394000E-03  +5.87750000E-04  +4.81388980E-01
   +1.27375800E-02  -1.06315900E-02  +5.63628000E-03  -3.62229000E-03  +1.41366600E-02
   -8.39826800E-02  -2.15315000E-02  +1.31648300E-02  +1.18584000E-03  +1.08449000E-03
   +2.66209000E-03  -5.13028000E-03  -1.99650000E-04  +3.74465000E-03  -2.07843000E-03
   +4.30625000E-03  +3.82373000E-03  +2.03475000E-03  -1.45259000E-03  -2.47456000E-03
   +4.80396130E-01  -2.96000000E-05  +2.32277000E-03  -8.74210000E-04  -8.38055000E-03
   +1.99005100E-02  +2.31337400E-02  -2.07400000E-05  +7.37880000E-04  -2.55750000E-04
   -6.64700000E-05  -1.39860000E-04  +8.27040000E-04  +5.93310000E-04  -2.18132000E-03
   +1.11996000E-03  -1.79165000E-03  -3.24020000E-04  -1.36861000E-03  -7.49947900E-02
   +5.24093000E-03  +6.63418000E-03  +5.86305140E-01  -2.13900000E-03  -1.25973000E-03
   +8.41270000E-04  +1.05256000E-02  -1.67918100E-02  -1.51804000E-02  +1.02850000E-04
   -2.93970000E-04  +1.70180000E-04  +9.93000000E-05  +2.48270000E-04  -7.10610000E-04
   -1.87550000E-04  +1.04383000E-03  -5.68520000E-04  +8.13830000E-04  +6.88800000E-05
   +6.89310000E-04  +1.10784000E-03  -1.14737660E-01  -4.91359500E-02  +5.84977000E-03
   +5.27180630E-01  -9.18790000E-04  +2.18220000E-04  -1.03270000E-04  +7.16581000E-03
   -5.23915000E-03  +1.91325000E-03  -8.85320000E-04  +1.55200000E-05  +1.75710000E-04
   -3.29060000E-04  +5.51220000E-04  +1.25780000E-04  +6.60400000E-05  -1.58773000E-03
   +8.11370000E-04  -5.17990000E-04  +5.60550000E-04  -2.00940000E-04  +1.34270000E-03
   -4.41150900E-02  -1.31239080E-01  +4.53600000E-04  -6.38456200E-02  +5.20143120E-01
   +3.65801000E-03  -3.25498000E-03  +2.42983000E-03  -1.82384000E-03  -1.23183000E-03
   +1.25798000E-03  -3.69457000E-03  +4.14974000E-03  +3.72906000E-03  -1.71743000E-03
   -6.19743000E-03  -1.95631300E-02  -3.39173470E-01  +2.11163000E-01  -4.60273000E-02
   +5.80220000E-03  +2.26228100E-02  -7.30320000E-03  +1.30542000E-03  -8.23580000E-04
   +3.06480000E-04  -9.03890000E-04  +2.33630000E-04  -3.43370000E-04  +4.98100000E-01
   -1.91245100E-02  +4.54982000E-03  +3.83248000E-03  +7.64411000E-03  +2.30990000E-03
   -4.23277000E-03  -8.75730000E-04  -4.19103000E-03  +1.09849300E-02  +3.80211000E-03
   +3.73890000E-03  -2.02704900E-02  +1.58101810E-01  -2.53406400E-01  +4.80311100E-02
   +5.14832100E-02  -4.13245000E-02  +1.29759500E-02  -1.06151000E-03  +1.01081000E-03
   -1.76751000E-03  +1.29458000E-03  -5.02790000E-04  +9.53940000E-04  -2.41340280E-01
   +2.46560500E-01  +6.41787000E-03  +2.20000000E-04  +7.60650000E-03  -3.52117000E-03
   +2.69540000E-04  -5.82100000E-05  +1.03165000E-03  +1.35105000E-03  -2.89004000E-03
   -4.01718000E-03  +1.31834000E-03  +1.18735500E-02  -2.49074400E-02  +3.88888700E-02
   -7.83612100E-02  -1.72254100E-02  +1.85497200E-02  +9.79338000E-03  +1.36970000E-04
   -8.20540000E-04  +3.31830000E-04  -3.76030000E-04  +1.41380000E-04  -3.74040000E-04
   +3.46540700E-02  -4.23253900E-02  +5.55036500E-02  -7.96650000E-04  +1.00699000E-03
   -2.53175000E-03  -3.64041900E-02  -1.46236500E-02  +2.29280000E-03  -6.59430000E-04
   +4.76700000E-05  -5.54730000E-04  -3.91060000E-04  -6.73780000E-04  +3.83510000E-04
   +2.40850000E-04  -7.34980000E-04  +5.22180000E-04  -4.48770000E-04  +1.73975000E-03
   +1.08058000E-03  -1.33625410E-01  -4.65445000E-02  +4.23371000E-03  +1.68461000E-03
   -3.45351000E-03  -3.99819000E-03  -3.37780000E-04  +4.41810000E-04  -2.70370000E-04
   +5.68597590E-01  +1.24884000E-03  -2.16602000E-03  +8.43750000E-04  +7.11462000E-03
   +1.32121900E-02  -1.52147000E-03  +2.19576000E-03  +5.64140000E-04  +4.86460000E-04
   +1.02450000E-04  -3.20780000E-04  +2.13290000E-04  -5.31890000E-04  +2.22449000E-03
   -9.13490000E-04  +9.42810000E-04  -1.82444000E-03  -6.37760000E-04  -4.37784000E-02
   -1.18029480E-01  -1.08961800E-02  -1.77329300E-02  -1.81752100E-02  -2.33068000E-03
   +9.97430000E-04  -1.48264000E-03  +5.26050000E-04  +8.93228100E-02  +4.94301790E-01
   +5.49990000E-04  -4.43210000E-04  -1.68240000E-04  -4.59090000E-04  +1.36030000E-04
   +5.65560000E-04  -1.95545000E-03  +5.94560000E-04  -4.98800000E-04  -1.17940000E-04
   -3.72030000E-04  -2.56430000E-04  +2.49500000E-04  -3.01690000E-04  +2.31240000E-04
   -1.92970000E-04  +2.33900000E-04  -4.99300000E-05  +7.13783000E-03  -8.64493000E-03
   -7.98225800E-02  -2.11377900E-02  -1.81752600E-02  -3.86930000E-04  -2.55780000E-04
   +2.62090000E-04  -7.26500000E-05  -1.63522580E-01  +1.82615830E-01  +4.26609800E-01
   -7.57250000E-04  +6.69330000E-04  -1.50900000E-05  -8.47010000E-04  -1.07120000E-03
   +3.57280000E-04  +2.87000000E-06  -4.84160000E-04  -2.97900000E-05  -8.95500000E-05
   +4.37570000E-04  +3.80440000E-04  -3.08270000E-04  -1.11060000E-04  -6.49600000E-05
   +1.22870000E-04  -8.97000000E-05  +1.34050000E-04  -1.83039900E-02  -1.67258000E-03
   +1.07732800E-02  -1.36473000E-03  -4.14020000E-04  +1.02015000E-03  +1.90740000E-04
   -5.78000000E-06  -3.13300000E-05  -2.51699700E-01  -2.33987600E-02  +9.39408000E-02
   +5.80643500E-01  -7.89470000E-04  +6.33140000E-04  -9.99200000E-05  -1.01357000E-03
   -2.46555000E-03  +6.06970000E-04  +1.51820000E-04  -2.40350000E-04  +1.67500000E-04
   -2.68810000E-04  +2.87420000E-04  -1.33990000E-04  -5.27700000E-05  -3.43840000E-04
   +3.73800000E-05  -2.07800000E-05  +1.86600000E-04  +1.36840000E-04  -1.62109000E-02
   +6.34708000E-03  +1.20049900E-02  -1.06727000E-03  -5.36410000E-04  +8.99310000E-04
   -8.93800000E-05  +2.24380000E-04  -9.03700000E-05  +2.63610900E-02  -1.14100250E-01
   -5.24269800E-02  +1.25913950E-01  +5.50716460E-01  +1.85780000E-04  -2.27400000E-05
   -4.46900000E-05  -2.12718000E-03  -1.33214000E-03  -8.51000000E-06  -4.77550000E-04
   +1.75830000E-04  -3.70510000E-04  +2.92680000E-04  -4.62160000E-04  -2.82090000E-04
   +3.36220000E-04  -4.18430000E-04  +2.29570000E-04  -2.93450000E-04  +6.11530000E-04
   +1.55860000E-04  +6.71950000E-04  +3.57514000E-03  +4.11797000E-03  -7.69580000E-04
   +7.21670000E-04  +5.70700000E-05  -3.98680000E-04  +3.52990000E-04  -1.04490000E-04
   +1.32920760E-01  -2.38712500E-02  -1.65609650E-01  -1.67097810E-01  +2.46953260E-01
   +4.37091040E-01  +2.16120000E-04  -8.07400000E-05  -2.00420000E-04  -2.56240000E-04
   -7.85270000E-04  +5.68400000E-05  +3.10100000E-05  +7.08200000E-05  +3.21370000E-04
   -3.60800000E-05  -1.67300000E-05  -1.17370000E-04  +2.06150000E-04  -3.17020000E-04
   +1.60740000E-04  -1.35480000E-04  +2.80470000E-04  -1.58100000E-05  +3.29700000E-05
   +9.32040000E-04  +4.25892000E-03  +2.04560000E-04  +7.09790000E-04  +1.92750000E-04
   -2.29310000E-04  +2.22060000E-04  -7.10600000E-05  -4.67310300E-02  -5.51250000E-04
   +3.22633700E-02  -2.38500040E-01  -1.46814330E-01  -7.24686000E-03  +6.25326830E-01
   +5.02870000E-04  -1.24990000E-04  -4.04300000E-04  -1.00841000E-03  -1.41403000E-03
   +3.25650000E-04  -1.21990000E-04  +2.16350000E-04  +3.69200000E-04  +1.11650000E-04
   -1.82690000E-04  -2.70300000E-04  +4.22010000E-04  -8.69170000E-04  +4.36770000E-04
   -3.82520000E-04  +7.51210000E-04  -9.97000000E-06  -1.32060000E-04  +2.70377000E-03
   -2.63032000E-03  -4.66480000E-04  -5.04250000E-04  +1.85100000E-05  -5.35800000E-04
   +6.17490000E-04  -1.89250000E-04  -3.91195300E-02  +3.90074100E-02  +4.75646600E-02
   -9.62099700E-02  -1.96723520E-01  -4.89261700E-02  +1.33744450E-01  +5.13825420E-01
   +3.15500000E-04  -2.21320000E-04  +1.06510000E-04  +8.63000000E-04  +5.85800000E-04
   -1.06840000E-04  +1.14920000E-04  +1.91360000E-04  -1.14680000E-04  +1.55690000E-04
   -1.64560000E-04  -2.22700000E-04  +2.07970000E-04  -9.08600000E-05  +4.60000000E-05
   -8.64300000E-05  +8.43900000E-05  -8.29200000E-05  +4.10985000E-03  -3.94195000E-03
   +2.02112000E-03  -6.07140000E-04  -5.97730000E-04  -1.54110000E-04  -1.92640000E-04
   +1.09890000E-04  -1.93000000E-06  +1.62855000E-03  +2.54449300E-02  +2.55115300E-02
   +3.21715700E-02  -1.91791200E-02  -9.36789400E-02  -1.97196710E-01  +2.26159900E-01
   +4.22525880E-01  -1.58540000E-04  -4.88500000E-05  +2.25800000E-05  -1.98760000E-04
   +1.81040000E-04  -5.74600000E-05  +7.99100000E-05  -3.73600000E-05  +2.74810000E-04
   -1.95120000E-04  +3.67280000E-04  +1.32620000E-04  -9.52690000E-04  +5.88540000E-04
   -1.29980000E-04  +2.96370000E-04  -4.25050000E-04  +7.66600000E-05  -2.39353000E-03
   -2.64550000E-04  +3.18200000E-04  +4.05400000E-04  -1.53770000E-04  -2.35690000E-04
   +9.41860000E-04  -5.75440000E-04  +1.00430000E-04  -1.95385100E-02  +2.71178100E-02
   +3.06561600E-02  +4.29020900E-02  -7.77528000E-03  -3.01584300E-02  -1.26158910E-01
   -2.97841700E-02  +1.11700600E-02  +6.20029380E-01  -4.88240000E-04  +1.38950000E-04
   +2.47650000E-04  +3.54790000E-04  +1.28168000E-03  -2.33900000E-04  +7.90300000E-05
   -2.91580000E-04  -8.26600000E-05  -2.04830000E-04  +3.54120000E-04  +3.83740000E-04
   -8.40090000E-04  +1.02649000E-03  -4.15380000E-04  +4.59270000E-04  -8.67250000E-04
   +5.39600000E-05  -3.17000000E-06  -1.00899000E-03  -1.00514000E-03  +3.22690000E-04
   +3.18200000E-05  -7.68800000E-05  +9.41720000E-04  -8.18160000E-04  +2.07640000E-04
   +2.54069900E-02  -2.35260500E-02  -2.87998800E-02  -5.07387600E-02  -4.01853500E-02
   -3.20990000E-03  +3.06736800E-02  -2.23370270E-01  -1.40417830E-01  +1.27901150E-01
   +5.40118310E-01  -4.04300000E-04  +1.40980000E-04  +1.97050000E-04  +4.42600000E-04
   +6.79890000E-04  -1.36490000E-04  +1.59930000E-04  -1.73940000E-04  -1.59160000E-04
   -9.98600000E-05  +2.01270000E-04  +2.57900000E-04  -1.86900000E-04  +3.78110000E-04
   -2.29240000E-04  +2.33260000E-04  -3.84490000E-04  +2.88000000E-06  +8.82780000E-04
   -3.60760000E-04  -1.46427000E-03  +8.61200000E-05  -1.05840000E-04  +2.36620000E-04
   +2.25240000E-04  -2.59510000E-04  +7.59700000E-05  +2.87457400E-02  -3.00665400E-02
   -4.68497700E-02  -6.48023300E-02  -2.86881700E-02  +1.77490200E-02  +5.88270100E-02
   -1.03671940E-01  -1.86358770E-01  -1.74424960E-01  +2.19513140E-01  +4.40710690E-01
   -1.01810000E-04  +1.01770000E-04  -1.80200000E-05  +1.12210000E-04  +4.45900000E-05
   -1.26180000E-04  +4.17000000E-04  -3.20230000E-04  -1.06620000E-04  +9.91000000E-06
   +2.03240000E-04  +1.86580000E-04  +2.59920000E-04  -1.84740000E-04  +2.73500000E-05
   +3.15500000E-05  +2.82600000E-05  -3.95500000E-05  +3.27003000E-03  +8.49170000E-04
   +2.13600000E-03  +4.50660000E-04  +4.36020000E-04  +3.97390000E-04  -2.66550000E-04
   +1.87290000E-04  -4.39300000E-05  +3.54001200E-02  -4.85313300E-02  -5.65433300E-02
   -6.23682400E-02  -1.85958700E-02  +2.01986900E-02  +2.71235700E-02  +6.13717600E-02
   +3.70524100E-02  -2.29949130E-01  -1.30405400E-02  +8.55502000E-02  +5.96546670E-01
   -5.03500000E-04  +3.85500000E-04  +3.73260000E-04  +8.30130000E-04  +2.61240000E-04
   +2.39540000E-04  +2.87550000E-04  -1.72990000E-04  -9.12900000E-05  -3.87800000E-05
   +3.12070000E-04  +8.40400000E-05  -2.95050000E-04  +1.06670000E-04  -1.00350000E-04
   +1.00990000E-04  -2.04990000E-04  +1.91900000E-05  +1.44454000E-03  -1.67900000E-05
   -5.50020000E-03  -1.17470000E-03  -6.65420000E-04  +2.72840000E-04  +2.37460000E-04
   -1.01190000E-04  +1.42400000E-05  -1.11146400E-02  -3.52991400E-02  -2.73940100E-02
   -1.96349500E-02  -8.84485000E-03  +6.92895000E-03  +2.64722900E-02  +1.66502000E-02
   -9.52243000E-03  +4.51003100E-02  -1.18701210E-01  -6.41463800E-02  +1.48394660E-01
   +5.70433910E-01  -3.90400000E-05  -3.04200000E-05  +1.62520000E-04  +6.91590000E-04
   +2.11200000E-04  -2.28600000E-05  -2.15130000E-04  +2.07080000E-04  -9.95700000E-05
   +2.86000000E-06  -9.63000000E-05  -7.45500000E-05  -2.00310000E-04  +2.19190000E-04
   -5.54000000E-05  -6.30000000E-06  -7.16400000E-05  +4.60600000E-05  +2.12975000E-03
   -4.27669000E-03  -2.59150000E-04  -6.73850000E-04  -5.83960000E-04  +1.22840000E-04
   +2.17680000E-04  -1.90950000E-04  +3.62100000E-05  -2.50898300E-02  -4.72045000E-03
   +2.02270500E-02  +2.00444700E-02  +6.62716000E-03  -9.77715000E-03  +9.56753000E-03
   -3.05063900E-02  -2.13539600E-02  +1.30631190E-01  -2.91401700E-02  -1.72688450E-01
   -1.62283770E-01  +2.55299030E-01  +4.27317650E-01  +8.21730000E-04  -3.97920000E-04
   -5.48890000E-04  -1.03224000E-03  -3.00705000E-03  -1.44301000E-03  -1.38170000E-03
   +3.74110000E-04  -5.45050000E-04  +1.22300000E-04  -4.54070000E-04  -5.69660000E-04
   +1.40800000E-05  -5.23880000E-04  +3.23470000E-04  -3.63770000E-04  +6.50070000E-04
   +1.15420000E-04  +1.67019000E-03  -2.05094100E-02  -1.73714500E-02  -4.63693000E-03
   -3.35042000E-03  +1.03117000E-03  -1.48530000E-04  +3.16380000E-04  -1.22990000E-04
   -1.18519440E-01  +1.66528800E-02  +4.30822600E-02  +2.56048300E-02  +2.89305300E-02
   +1.30050000E-02  -1.43529900E-02  -2.20298300E-02  -1.07566200E-02  -4.99288300E-02
   -1.51336000E-03  +2.99877700E-02  -2.52293990E-01  -1.57682160E-01  -8.81221000E-03
   +6.45276700E-01  +4.44830000E-04  -5.44900000E-05  -5.02640000E-04  +5.16200000E-05
   -1.14187000E-03  -5.76730000E-04  -4.66000000E-05  -2.91600000E-04  +5.59290000E-04
   +4.26500000E-05  +3.84410000E-04  +2.60800000E-04  -1.18660000E-04  -5.45640000E-04
   +2.35470000E-04  -1.57400000E-05  +1.34820000E-04  -1.70870000E-04  -6.58130000E-03
   -1.83322500E-02  -1.21559400E-02  -2.61095000E-03  -7.70040000E-04  +7.14710000E-04
   +2.01000000E-06  +2.71290000E-04  -1.19900000E-04  -3.22583800E-02  -2.19951120E-01
   -9.61655200E-02  +6.71072300E-02  +1.51418500E-02  -3.43004600E-02  -2.55567200E-02
   -5.19235600E-02  -2.28813600E-02  -4.40875700E-02  +4.19377000E-02  +5.72790300E-02
   -1.06867160E-01  -2.10609860E-01  -5.38684700E-02  +1.35564200E-01  +5.16010120E-01
   +6.85710000E-04  -1.68850000E-04  -7.37780000E-04  -8.09600000E-04  -9.85770000E-04
   +2.20270000E-04  -8.73750000E-04  -3.29760000E-04  -9.62000000E-05  +6.94000000E-06
   -2.69100000E-05  +4.63590000E-04  +3.27980000E-04  -5.78600000E-05  +1.46520000E-04
   -1.07450000E-04  -1.30600000E-04  -1.74390000E-04  -5.38938000E-03  -1.79416000E-03
   +3.20821000E-03  +1.02823000E-03  +3.02880000E-04  +2.54200000E-05  -1.64190000E-04
   +1.64400000E-05  +1.95900000E-05  +2.80760000E-03  -1.26046100E-01  -1.70794960E-01
   +4.34704800E-02  -1.16178800E-02  -2.64964400E-02  -1.37229300E-02  -2.55143900E-02
   -1.53518400E-02  -3.86549000E-03  +3.22957300E-02  +2.98581900E-02  +3.13138900E-02
   -2.34810800E-02  -9.75228600E-02  -1.87186000E-01  +2.07192230E-01  +4.17514090E-01
   +5.03110000E-04  -5.76600000E-05  -3.18530000E-04  -2.23340000E-04  -1.13119000E-03
   +1.73190000E-04  -1.06220000E-04  +1.35340000E-04  -3.63900000E-05  +2.51690000E-04
   -3.75010000E-04  -3.14570000E-04  +1.13121000E-03  -1.16951000E-03  +4.25760000E-04
   -5.15050000E-04  +9.06800000E-04  -9.08300000E-05  +1.53996000E-03  +8.14850000E-04
   +5.31130000E-04  -5.80600000E-04  +1.26600000E-05  +2.89840000E-04  -1.22058000E-03
   +9.66480000E-04  -2.27370000E-04  -3.26410000E-04  -4.01453000E-03  -4.99120000E-03
   -1.38607000E-03  -1.38492000E-03  +4.32224000E-03  -3.51645000E-03  -1.20688300E-02
   -1.40213000E-03  -2.04897410E-01  -1.35100780E-01  -9.00969000E-03  -4.60459600E-02
   -3.62039900E-02  +3.69463000E-03  +2.83297000E-03  +5.98977000E-03  +5.94697000E-03
   +5.51554200E-01  +4.41060000E-04  -5.23800000E-05  -2.66980000E-04  -1.71510000E-04
   -1.05950000E-03  +1.55290000E-04  -9.20900000E-05  +1.41910000E-04  -2.55800000E-05
   +2.30900000E-04  -3.09240000E-04  -3.01020000E-04  +9.00950000E-04  -1.12047000E-03
   +4.19360000E-04  -4.54790000E-04  +8.47650000E-04  -8.40200000E-05  +1.22532000E-03
   +4.62370000E-04  +1.13392000E-03  -4.92690000E-04  -4.16000000E-05  +2.28400000E-04
   -1.01553000E-03  +8.96770000E-04  -2.21290000E-04  -3.17347000E-03  -3.83370000E-04
   +1.60750000E-03  +4.63315000E-03  +2.85788000E-03  -6.68331000E-03  -4.07324000E-02
   -3.18655500E-02  -8.13449000E-03  -9.74759000E-02  -1.84719410E-01  -5.15677700E-02
   -7.55415000E-03  +6.63704000E-03  +4.04276000E-03  +7.43630000E-04  -9.62060000E-04
   -5.06208000E-03  +7.95679300E-02  +2.74022730E-01  +1.63000000E-05  +2.71200000E-05
   +1.65400000E-05  -5.83200000E-05  -1.17160000E-04  +9.54100000E-05  -1.81400000E-05
   +4.34800000E-05  -3.17400000E-05  +4.66500000E-05  -5.81300000E-05  -8.32700000E-05
   +5.85600000E-05  -4.02300000E-05  +1.17600000E-05  -4.85000000E-05  +5.73800000E-05
   +1.99000000E-05  -3.09180000E-04  +4.16340000E-04  -8.15600000E-05  -7.86000000E-06
   -1.57300000E-05  -2.88800000E-05  -6.52300000E-05  +3.92500000E-05  +5.10000000E-07
   -3.16831000E-03  +3.08936000E-03  +3.02791000E-03  +9.30846000E-03  -3.05034000E-03
   -1.50570000E-04  -2.41044700E-02  -2.56795800E-02  +4.19232000E-03  +2.01238500E-02
   -2.91898800E-02  -7.87931000E-02  +2.60722600E-02  +2.13265700E-02  +8.21712000E-03
   +1.81086000E-03  -8.17161000E-03  -2.67265000E-03  -2.50732850E-01  +1.44868230E-01
   +2.90024770E-01  -2.03275000E-03  +9.00100000E-04  -1.17398000E-03  -2.10274000E-03
   +1.65317000E-02  -2.58946500E-02  -5.19406000E-03  +2.23136000E-03  +8.17540000E-04
   +5.38020000E-04  +7.63850000E-04  -1.65174000E-03  +5.40840000E-04  -4.99960000E-04
   +3.58300000E-05  +6.07600000E-05  +7.44070000E-04  -5.31770000E-04  -7.56003800E-02
   +6.11920000E-04  -9.64730000E-04  +5.50710000E-04  -1.24798000E-03  +2.37584000E-03
   -6.70920000E-04  +5.28560000E-04  -8.44900000E-05  -2.86056000E-03  -1.57924200E-02
   +2.22965200E-02  -4.91530000E-04  -1.77386000E-03  -5.47000000E-04  -1.19603000E-03
   -6.91600000E-05  -1.32005000E-03  +3.66720000E-04  +8.84870000E-04  +5.19560000E-04
   -2.51870000E-04  +6.15270000E-04  +4.90800000E-05  -3.28240000E-04  -6.90700000E-04
   +7.30270000E-04  -1.08732000E-03  -1.02431000E-03  -4.73200000E-05  +5.84726080E-01
   +5.34890000E-04  -8.05800000E-04  -2.49790000E-04  +5.83792000E-03  -1.19701100E-02
   +1.59692900E-02  +2.67248000E-03  -1.05670000E-04  -1.04190000E-04  -2.68570000E-04
   -2.08780000E-04  +7.07080000E-04  +2.24900000E-05  -1.48240000E-04  +3.15230000E-04
   -4.70220000E-04  -4.89570000E-04  +3.98120000E-04  +3.93019000E-03  -1.01977140E-01
   +4.67400000E-02  -3.16820000E-04  +1.01499800E-02  -1.73506500E-02  +6.08100000E-05
   -2.87300000E-05  -1.10630000E-04  -7.47504000E-03  -1.91774100E-02  +2.04952100E-02
   +1.62454000E-03  -1.02439000E-03  -5.30030000E-04  -7.68620000E-04  -4.12160000E-04
   -1.18565000E-03  +2.47000000E-06  +8.01920000E-04  +6.58380000E-04  +1.60900000E-05
   +8.17240000E-04  -1.22780000E-04  -5.99420000E-04  -4.98070000E-04  +1.17440000E-03
   -6.18100000E-04  -6.47790000E-04  -5.82200000E-05  +4.53053000E-03  +5.49103150E-01
   +9.09620000E-04  -2.69420000E-04  -6.96200000E-05  -4.81924000E-03  +3.83050000E-03
   -3.46001000E-03  +1.04747000E-03  -8.39430000E-04  +4.60040000E-04  -1.78000000E-06
   -1.84910000E-04  +1.81890000E-04  -4.40900000E-05  +4.90880000E-04  -2.67620000E-04
   +4.68560000E-04  -3.89300000E-04  +8.12000000E-06  -5.46837000E-03  +4.26668800E-02
   -1.45051010E-01  +8.52800000E-05  +1.06383200E-02  -3.72393300E-02  +2.16050000E-04
   -3.15920000E-04  +1.37930000E-04  +7.19528000E-03  +8.51406000E-03  -2.05997000E-03
   -9.21310000E-04  -3.35770000E-04  -7.40200000E-05  -1.45730000E-04  -3.82800000E-04
   -2.01130000E-04  +2.32000000E-05  +4.07960000E-04  +4.99770000E-04  +3.88380000E-04
   -1.57300000E-05  -1.85260000E-04  -1.54517000E-03  -1.39538000E-03  -2.75750000E-04
   -5.22640000E-04  -4.76310000E-04  -1.00150000E-04  -1.01139200E-02  +6.03710100E-02
   +5.03059270E-01  -1.06078700E-02  +7.57827000E-03  -4.17936000E-03  +4.63342000E-03
   -9.04162000E-03  +2.45013000E-03  -2.40067300E-02  +1.95253700E-02  +4.14288400E-02
   -7.38150500E-02  +3.62970800E-02  +5.39550500E-02  -5.69539000E-02  +2.77920600E-02
   -1.94508500E-02  -6.25226000E-03  -2.62265200E-02  +1.30460200E-02  +1.08310000E-04
   +8.38960000E-04  -1.80994000E-03  +4.72160000E-04  -3.98940000E-04  +1.18767000E-03
   -1.52632360E-01  -5.65720300E-02  +4.57033900E-02  +3.53380000E-04  -5.03470000E-04
   +1.32200000E-05  +3.14160000E-04  +2.64850000E-04  -2.28880000E-04  +3.28300000E-05
   +1.69700000E-05  -2.28170000E-04  +6.59030000E-04  +3.49870000E-04  +2.65300000E-05
   -1.56060000E-04  +1.20870000E-04  +1.05960000E-04  +1.84230000E-04  +4.39130000E-04
   -9.29700000E-05  -5.72020000E-04  -3.94130000E-04  -6.42900000E-05  -4.24350000E-04
   +2.44470000E-04  -1.77600000E-04  +3.42312320E-01  +3.76537000E-03  +7.72580000E-04
   -3.34740000E-03  -4.42405000E-03  -2.31171000E-03  +2.52160000E-03  +2.44699000E-02
   -2.96352000E-03  -4.31523000E-02  +4.63503700E-02  -1.14615840E-01  -2.52794200E-02
   +5.88579300E-02  -1.02083370E-01  -1.88660900E-02  -4.94882500E-02  -1.57958500E-02
   +1.21138600E-02  -1.83100000E-05  +1.00287000E-03  -2.55930000E-04  +2.08960000E-04
   -1.71500000E-05  -9.51000000E-05  +1.78733500E-02  +6.90927000E-02  -1.69010800E-02
   -4.14600000E-05  -9.18600000E-05  -4.30600000E-05  +4.71900000E-05  +1.32430000E-04
   +9.86200000E-05  -9.38000000E-06  +2.83200000E-05  +5.42800000E-05  -2.36210000E-04
   -1.77930000E-04  -4.64000000E-06  +1.23690000E-04  +5.26800000E-05  -1.39340000E-04
   -7.99000000E-06  -8.95600000E-05  -1.41560000E-04  +2.82580000E-04  +2.77990000E-04
   +5.86000000E-06  +4.21300000E-05  +6.29000000E-05  +2.21400000E-05  -6.73165400E-02
   +2.11592680E-01  +2.05310800E-02  -1.06933000E-02  -3.41893000E-03  -1.19382900E-02
   -6.89821000E-03  +7.18837000E-03  +1.15002500E-02  -1.90317000E-03  -1.80644200E-02
   +7.09283800E-02  -2.54646700E-02  -1.76426270E-01  -3.68371300E-02  -2.68945100E-02
   -2.08544100E-02  +7.52566000E-03  +2.78061200E-02  -9.13484000E-03  -3.36040000E-04
   +9.84430000E-04  +1.99719000E-03  -6.23750000E-04  +5.67440000E-04  -7.71620000E-04
   +3.38891500E-02  +3.80481000E-03  +2.14466600E-02  -5.61300000E-05  +8.50800000E-05
   +1.54150000E-04  -1.91050000E-04  +5.02100000E-05  +3.06770000E-04  -5.47600000E-05
   +2.63800000E-05  +2.11100000E-04  -3.49840000E-04  -2.74630000E-04  -8.10200000E-05
   +6.57800000E-05  +2.93700000E-05  -6.63300000E-05  +1.98950000E-04  -3.87480000E-04
   -4.40660000E-04  +3.78770000E-04  +3.29810000E-04  +7.02500000E-05  +4.33170000E-04
   -1.65070000E-04  +8.89100000E-05  -1.06323440E-01  +3.53533600E-02  +2.63415660E-01
   -9.81000000E-05  +2.66500000E-05  +4.41900000E-05  +5.89000000E-05  +1.78100000E-04
   -3.90100000E-05  +3.44000000E-05  -4.26700000E-05  +3.13600000E-05  -4.93400000E-05
   +9.21100000E-05  +7.39200000E-05  -2.13250000E-04  +1.63440000E-04  -5.73700000E-05
   +9.19700000E-05  -1.46240000E-04  +9.92000000E-06  -1.58240000E-04  -1.28590000E-04
   -1.62150000E-04  +7.72200000E-05  +7.75000000E-06  -2.09000000E-05  +2.19030000E-04
   -1.43000000E-04  +2.95000000E-05  +6.64070000E-04  -2.07170000E-04  -3.84970000E-04
   -1.10119000E-03  +1.27680000E-04  +3.66700000E-04  +4.53977000E-03  +3.30685000E-03
   -6.88190000E-04  -3.23733700E-02  +7.69335000E-03  +2.38135200E-02  -1.82033000E-03
   -5.30108000E-03  -1.73137000E-03  -2.46170000E-04  +8.38330000E-04  +1.78076000E-03
   -2.99652170E-01  +6.32192700E-02  +2.25723370E-01  +1.41220000E-04  +8.31700000E-05
   +6.14500000E-05  +1.34660000E-04  -3.32200000E-05  -7.94700000E-05  +3.29721820E-01
   -4.23000000E-05  -3.35000000E-06  +1.65400000E-05  -6.44000000E-06  +6.12800000E-05
   -3.48100000E-05  +1.81500000E-05  -1.20000000E-05  +3.03000000E-06  -2.13400000E-05
   +3.73500000E-05  +2.39500000E-05  -1.06770000E-04  +1.25810000E-04  -4.03900000E-05
   +4.45700000E-05  -7.95700000E-05  +1.93300000E-05  +8.96000000E-06  -9.66900000E-05
   -4.83700000E-05  +3.58700000E-05  +3.41900000E-05  +5.69000000E-06  +1.16420000E-04
   -1.01480000E-04  +2.44200000E-05  +3.80260000E-04  -2.50060000E-04  -4.97920000E-04
   -1.45160000E-04  -6.35660000E-04  +1.41450000E-04  -1.54291000E-03  +9.10600000E-04
   +2.36579000E-03  -2.78620800E-02  +3.98684000E-03  +2.17323300E-02  -4.11564000E-03
   -3.06921000E-03  -1.62980000E-03  -6.14540000E-04  +1.53264000E-03  +2.86690000E-04
   +1.01589320E-01  -6.41551400E-02  -1.07587840E-01  +1.61700000E-05  +9.84000000E-06
   +6.09000000E-06  +4.78600000E-05  -3.86800000E-05  -3.33100000E-05  -6.86265000E-02
   +6.27980200E-02  -2.35000000E-06  +1.03500000E-05  -6.10000000E-06  +1.59600000E-05
   -4.13700000E-05  -1.13500000E-05  +4.78000000E-06  -4.95000000E-06  +1.92400000E-05
   -4.63000000E-06  +7.84000000E-06  +6.70000000E-06  +1.78100000E-05  -6.44800000E-05
   +2.41800000E-05  -1.26500000E-05  +3.55100000E-05  -1.12500000E-05  +1.11280000E-04
   +2.68800000E-05  +2.99600000E-05  -3.19100000E-05  +1.67000000E-06  +2.77400000E-05
   -2.80400000E-05  +4.58400000E-05  -1.80100000E-05  -8.27800000E-05  -1.54660000E-04
   -1.09940000E-04  +1.21710000E-04  -1.64900000E-05  -8.01240000E-04  -4.48191000E-03
   -5.49870000E-04  +1.36942000E-03  -3.73208000E-03  +5.76320000E-04  +9.16400000E-05
   -8.76190000E-04  -9.17380000E-04  +2.00898000E-03  +7.01950000E-04  -5.43860000E-04
   +7.84210000E-04  +2.55490910E-01  -8.47691500E-02  -2.22204430E-01  -7.14300000E-05
   -6.34500000E-05  -4.10200000E-05  +1.62700000E-05  +1.76700000E-05  -5.19000000E-06
   -2.47589510E-01  +8.64380400E-02  +2.19339570E-01  +3.79000000E-06  +4.71000000E-05
   -6.04900000E-05  -4.41800000E-05  -2.85890000E-04  +8.14600000E-05  -3.54900000E-05
   +5.50000000E-06  +4.06300000E-05  -6.15000000E-06  -1.04700000E-05  -3.57800000E-05
   +1.11820000E-04  -1.72420000E-04  +5.87200000E-05  -6.13600000E-05  +1.14790000E-04
   -9.10000000E-06  -1.89900000E-04  +6.26070000E-04  +8.05630000E-04  -5.45200000E-05
   +7.80600000E-05  +5.04700000E-05  -1.35200000E-04  +1.30940000E-04  -3.85900000E-05
   -6.78030000E-04  -5.21483000E-03  +4.81790000E-04  -1.50303000E-02  +5.67282000E-03
   +1.48443700E-02  -2.29057020E-01  +2.30658900E-02  +1.37227380E-01  -1.26511000E-03
   -4.03989000E-03  +1.44400000E-04  +2.55806000E-03  -8.00710000E-04  +1.27154000E-03
   -1.15500000E-05  -2.53370000E-04  -8.16690000E-04  +2.28819000E-03  +1.78639000E-03
   -2.45861000E-03  -2.14020000E-04  -1.00570000E-04  -1.11210000E-04  -1.57900000E-05
   +3.89600000E-05  +2.28600000E-05  +1.56800000E-05  +9.12920000E-04  +1.04956000E-03
   +2.42075170E-01  +2.44000000E-06  +2.47500000E-05  -3.40200000E-05  -2.08470000E-04
   -2.99050000E-04  +3.50700000E-05  -4.83000000E-06  -1.17800000E-05  +1.74000000E-06
   +1.39500000E-05  -4.41000000E-06  -2.07200000E-05  +4.05900000E-05  -9.48700000E-05
   +4.04500000E-05  -4.22800000E-05  +8.95900000E-05  +1.89600000E-05  -5.90600000E-04
   +5.73030000E-04  +3.56700000E-04  +4.72000000E-05  +6.00000000E-05  +6.75000000E-05
   -6.03100000E-05  +6.55600000E-05  -2.08300000E-05  -4.58322000E-03  -2.64820000E-04
   -2.68166000E-03  -1.66808000E-02  +6.42642000E-03  +1.35334500E-02  +2.31683000E-02
   -5.66604500E-02  -3.31969000E-02  +1.96620800E-02  +1.68431000E-03  -1.39424300E-02
   -1.28545000E-03  -1.94729000E-03  -5.22799000E-03  -5.22210000E-04  -1.43702000E-03
   -3.28900000E-05  +2.36505000E-03  +7.50610000E-04  +2.41783000E-03  -7.24800000E-05
   +1.89200000E-05  -6.70100000E-05  -3.18000000E-06  +1.28200000E-05  +1.71800000E-05
   -1.24033000E-03  -7.15110000E-04  -2.77260000E-04  -2.26681900E-02  +5.26535000E-02
   -3.72100000E-05  +1.15800000E-05  +2.87400000E-05  +1.36850000E-04  +1.13150000E-04
   -1.26300000E-05  -2.40000000E-06  +5.22000000E-06  +2.35100000E-05  -2.38500000E-05
   +2.05300000E-05  -6.68000000E-06  -6.27700000E-05  +5.45200000E-05  -2.54000000E-05
   +3.37500000E-05  -5.71400000E-05  -5.60000000E-06  -3.34000000E-05  -1.89200000E-04
   +3.12720000E-04  +7.27000000E-06  +4.87100000E-05  -5.11400000E-05  +6.51700000E-05
   -4.23500000E-05  +1.08300000E-05  +7.25890000E-04  -2.39816000E-03  +4.46729000E-03
   -2.70649000E-03  -1.16900000E-05  +3.73358000E-03  +1.37312510E-01  -3.31610700E-02
   -1.41967190E-01  +1.88969900E-02  +4.86770000E-04  -6.84657000E-03  +8.46410000E-04
   -5.56911000E-03  +7.87100000E-04  -1.08133000E-03  -2.16550000E-04  -5.41160000E-04
   -2.00556000E-03  +2.72945000E-03  -7.30560000E-04  -1.05500000E-05  -6.82200000E-05
   -8.85000000E-06  +4.11400000E-05  -4.76000000E-06  -1.10000000E-05  -6.61200000E-04
   -1.57216000E-03  -2.85490000E-04  -1.50724980E-01  +3.74152800E-02  +1.43696980E-01
   -2.86500000E-05  -2.99500000E-05  -7.21400000E-05  -1.90970000E-04  -1.50890000E-04
   -1.82360000E-04  +5.70000000E-07  -6.41400000E-05  +1.63890000E-04  -6.02800000E-05
   +4.59200000E-05  +3.04600000E-05  -7.78300000E-05  +9.19800000E-05  -1.75700000E-05
   +5.20400000E-05  -2.78900000E-05  +3.17600000E-05  +2.47960000E-04  +1.54131000E-03
   -1.23972000E-03  -1.88104000E-03  -1.02253000E-03  +5.15960000E-04  +9.67300000E-05
   -7.82700000E-05  +1.03500000E-05  +4.37227000E-03  +1.92193600E-02  +1.51908100E-02
   -5.75613800E-02  +1.12145800E-02  +2.03021800E-02  +4.96903000E-03  -1.92127800E-02
   -1.59513400E-02  -1.86317000E-03  -4.50943000E-03  +2.16943000E-03  -1.29811000E-03
   -2.22980000E-04  -1.17710000E-04  -3.09038000E-03  -9.71800000E-04  +5.22347000E-03
   -1.52200000E-04  -1.17447000E-03  -8.41030000E-04  +2.93890000E-04  +2.47000000E-06
   -6.64100000E-05  +9.05100000E-05  -6.59600000E-05  -9.78400000E-05  +1.74730000E-04
   +4.11400000E-05  -9.26200000E-05  -6.08200000E-05  +1.41510000E-03  -1.39746000E-03
   +5.76050800E-02  +4.44200000E-05  -7.02300000E-05  +9.89200000E-05  +3.21820000E-04
   +4.19020000E-04  -2.38370000E-04  +3.08300000E-05  +3.82800000E-05  -1.42840000E-04
   +4.72300000E-05  -7.09700000E-05  -1.99300000E-05  -8.36000000E-06  +1.68820000E-04
   -7.91000000E-05  +4.79100000E-05  -9.44500000E-05  +2.96000000E-06  +5.25080000E-04
   -2.03242000E-03  +1.25706000E-03  -2.76551000E-03  -1.03416000E-03  +1.52660000E-04
   +3.93100000E-05  -9.95900000E-05  +4.16100000E-05  +5.40200000E-05  +8.85210000E-04
   -2.85684000E-03  +1.14420100E-02  -2.15500990E-01  -1.47184310E-01  +2.96737000E-03
   -1.17333200E-02  -1.37339100E-02  -4.77248000E-03  +1.66072000E-03  -1.78129000E-03
   -1.01810000E-04  -8.81600000E-05  +9.45390000E-04  -7.79220000E-04  +3.14426000E-03
   -2.50955000E-03  -2.81920000E-04  -1.09169000E-03  -7.44600000E-04  -3.45460000E-04
   -2.28100000E-04  +4.55100000E-05  -1.12320000E-04  +2.13900000E-05  +9.01500000E-05
   +2.19940000E-04  +2.81500000E-05  -6.99600000E-05  +1.01989000E-03  -6.94440000E-04
   +2.14232000E-03  -5.96203000E-03  +2.28189100E-01  -3.28000000E-05  +7.64100000E-05
   -4.12700000E-05  -3.23210000E-04  -1.69790000E-04  +1.92620000E-04  -1.30000000E-05
   -4.45400000E-05  +5.58700000E-05  -1.31600000E-05  +6.19400000E-05  +1.95000000E-05
   -3.49200000E-05  -1.50220000E-04  +6.05300000E-05  -2.26500000E-05  +7.55100000E-05
   -5.99000000E-06  -2.11893000E-03  +5.63690000E-04  -2.22167000E-03  -6.77240000E-04
   -9.93500000E-04  +4.93610000E-04  -8.59000000E-06  +8.67000000E-05  -3.37300000E-05
   -1.70070000E-04  -1.45324500E-02  -7.00382000E-03  +2.07845900E-02  -1.47221500E-01
   -1.67166010E-01  +1.45275000E-03  -4.50810000E-04  +2.26474000E-03  +1.89460000E-03
   -1.94210000E-03  +4.88922000E-03  +1.41900000E-05  +1.02435000E-03  -4.06250000E-04
   +5.30381000E-03  -2.24937000E-03  +1.92385000E-03  -1.11990000E-04  -1.90830000E-04
   -5.06300000E-05  +6.87810000E-04  +2.80310000E-04  +3.75200000E-05  +9.91300000E-05
   +8.98000000E-06  -4.04500000E-05  +4.13100000E-05  +3.21300000E-05  -4.19500000E-05
   -1.69515000E-03  +1.90360000E-03  -1.64930000E-03  -2.33971300E-02  +1.63411230E-01
   +1.69643510E-01  -3.47090000E-04  -6.52900000E-05  -3.57100000E-05  -4.46170000E-04
   -7.44550000E-04  -6.71000000E-04  -1.24210000E-04  -1.79790000E-04  -1.68210000E-04
   +1.38070000E-04  -2.32200000E-05  +9.68500000E-05  -1.92080000E-04  +6.24000000E-05
   +1.44000000E-06  -3.58700000E-05  -8.98200000E-05  -3.05100000E-05  -1.00218000E-03
   +1.46540000E-04  -1.01581000E-03  -3.06100000E-05  +1.28000000E-04  -1.06760000E-04
   +1.74280000E-04  -7.30100000E-05  -3.22000000E-06  +2.21575000E-03  -1.74190000E-04
   +8.63700000E-04  +2.24099000E-03  -1.09907000E-03  +1.35956000E-03  -3.78000000E-06
   -2.73570000E-04  -8.92400000E-04  +1.85350000E-04  -4.87224000E-03  +9.60650000E-04
   -1.44891700E-02  +4.63317000E-03  +1.48159600E-02  -2.36425520E-01  +2.73564200E-02
   +1.34918830E-01  -1.13836000E-03  +1.77400000E-04  +7.81940000E-04  -4.11900000E-05
   -4.90000000E-05  +1.40490000E-04  +1.30210000E-04  -1.21280000E-04  -3.12800000E-05
   -2.59690000E-04  -1.30280000E-04  -8.82400000E-05  -1.79150000E-04  +1.71500000E-04
   -1.52670000E-04  +9.11900000E-05  -1.22940000E-04  -5.05700000E-05  +2.49245500E-01
   -3.58810000E-04  -1.43400000E-05  +1.51770000E-04  -2.28420000E-04  -7.90300000E-05
   -2.63360000E-04  -1.34260000E-04  +2.83960000E-04  -3.60250000E-04  +2.01000000E-05
   -1.33810000E-04  +2.95860000E-04  -5.00000000E-07  +5.35190000E-04  -1.61980000E-04
   +1.51900000E-05  -2.34600000E-04  +9.87000000E-05  +1.34068000E-03  -5.10010000E-04
   +1.12830000E-03  +9.07500000E-05  +6.92800000E-05  +7.10800000E-05  +1.49060000E-04
   -3.59160000E-04  +1.15240000E-04  +2.04260100E-02  +2.24529000E-03  -1.35658300E-02
   -1.60668000E-03  -1.95375000E-03  -5.48093000E-03  -3.23340000E-04  -1.04349000E-03
   +2.23800000E-04  -4.70955000E-03  +1.16710000E-04  -3.65273000E-03  -1.80011100E-02
   +6.61983000E-03  +1.23320900E-02  +2.77228400E-02  -6.00933000E-02  -3.12684900E-02
   -8.45790000E-04  +2.89830000E-04  +7.24790000E-04  -5.93200000E-05  -5.95180000E-04
   -3.75440000E-04  -2.33390000E-04  -1.60110000E-04  -2.24790000E-04  -2.22810000E-04
   -2.65240000E-04  +1.04410000E-04  +2.13680000E-04  -1.53560000E-04  +2.98190000E-04
   +1.11739000E-03  -8.63700000E-05  -7.42090000E-04  -2.58867600E-02  +5.67861500E-02
   -7.33710000E-04  +4.03510000E-04  +3.75540000E-04  -2.53600000E-05  -1.50690000E-04
   -4.41800000E-05  +7.33900000E-05  +7.35000000E-06  -2.89190000E-04  -1.58900000E-05
   +1.08280000E-04  -2.26450000E-04  -4.26150000E-04  +2.94260000E-04  -1.88130000E-04
   +1.80440000E-04  -3.15560000E-04  +4.49600000E-05  +3.16600000E-05  +1.77810000E-03
   -1.56104000E-03  -2.42230000E-04  +1.51100000E-05  -3.48300000E-05  +4.14810000E-04
   -2.42540000E-04  +4.83900000E-05  +1.67402200E-02  -1.80049000E-03  -6.82022000E-03
   +1.41519000E-03  -5.86483000E-03  +9.81970000E-04  -1.05373000E-03  +7.39300000E-05
   -4.64750000E-04  +1.12901000E-03  -3.45181000E-03  +5.21409000E-03  -2.33086000E-03
   -9.61520000E-04  +4.99961000E-03  +1.34138450E-01  -3.05323200E-02  -1.41776350E-01
   +1.24640000E-04  +1.58610000E-04  +6.19600000E-05  +1.96300000E-05  +6.60300000E-05
   -1.40800000E-05  +1.62610000E-04  -3.10800000E-05  +1.57750000E-04  -1.54880000E-04
   +5.57900000E-05  -8.67700000E-05  -1.45350000E-04  +3.17910000E-04  -3.71450000E-04
   +8.78660000E-04  -6.32000000E-06  -5.29110000E-04  -1.48577550E-01  +3.73888300E-02
   +1.42360100E-01  +1.89000000E-05  +1.14600000E-05  -1.01800000E-05  +8.59700000E-05
   -3.28900000E-05  +1.67000000E-05  -4.79000000E-06  -1.25400000E-05  +2.93500000E-05
   +4.87400000E-05  +4.01000000E-06  -7.89400000E-05  -3.11700000E-05  -1.52310000E-04
   +5.66300000E-05  -2.83900000E-05  +8.35600000E-05  -4.54000000E-06  +5.98690000E-04
   -6.82170000E-04  -7.34810000E-04  -3.20900000E-04  -1.30100000E-04  +8.33700000E-05
   -1.72100000E-05  +9.77300000E-05  -2.50700000E-05  -1.87867000E-03  -4.72480000E-03
   +2.20475000E-03  -1.50169000E-03  -3.65200000E-04  +1.01000000E-05  -3.10674000E-03
   -9.79500000E-04  +4.37191000E-03  +4.36439000E-03  +2.06090700E-02  +1.64474300E-02
   -5.65633900E-02  +5.01117000E-03  +1.60814400E-02  +5.72999000E-03  -1.86165900E-02
   -1.62279000E-02  +1.08252000E-03  +7.73650000E-04  -2.04058000E-03  +1.89700000E-05
   +6.72300000E-05  -9.76800000E-05  +6.04900000E-05  +6.43600000E-05  +6.50900000E-05
   +1.90540000E-04  +2.92000000E-05  -4.05200000E-04  -3.90700000E-05  +1.07149000E-03
   +8.41980000E-04  -6.50900000E-05  +1.72680000E-04  -2.70060000E-04  -4.57200000E-05
   +1.61578000E-03  -1.55894000E-03  +5.15144200E-02  +1.40700000E-05  +1.55600000E-05
   +1.70000000E-06  +1.53340000E-04  -8.17900000E-05  +3.62300000E-05  -4.30000000E-06
   +2.87200000E-05  +3.48000000E-06  +1.89700000E-05  -2.52100000E-05  -6.35200000E-05
   +4.94800000E-05  -6.93600000E-05  +1.99200000E-05  -3.42800000E-05  +5.84800000E-05
   +1.00700000E-05  +3.62190000E-04  -2.20160000E-04  -7.55560000E-04  -2.79100000E-04
   -1.86380000E-04  +1.10930000E-04  -6.70200000E-05  +5.82700000E-05  -1.17300000E-05
   -4.89495000E-03  +1.64285000E-03  -1.88685000E-03  -2.04100000E-05  +4.45900000E-05
   +8.04330000E-04  -5.60710000E-04  +2.52561000E-03  -1.92062000E-03  -2.85549000E-03
   -2.13000000E-04  -2.42943000E-03  +6.29426000E-03  -2.22382770E-01  -1.49048240E-01
   +3.18745000E-03  -1.09039700E-02  -1.26497700E-02  +1.09052000E-03  -3.39410000E-04
   +1.70893000E-03  -5.48100000E-05  -1.84800000E-05  -4.28600000E-05  -2.81400000E-05
   +1.84000000E-05  +5.28800000E-05  +1.02830000E-04  -1.24130000E-04  +2.45030000E-04
   +2.72000000E-06  -2.36100000E-05  +3.62700000E-05  +2.02280000E-04  -2.82160000E-04
   +2.34570000E-04  +1.11388000E-03  -8.83130000E-04  +2.38158000E-03  -3.82022000E-03
   +2.31526240E-01  +4.78500000E-05  -5.84000000E-06  -5.50900000E-05  -1.06180000E-04
   -5.47500000E-05  +3.96000000E-06  +1.21100000E-05  -4.31700000E-05  +3.61800000E-05
   +2.83600000E-05  +2.71200000E-05  -1.77800000E-05  -6.58000000E-06  -1.54020000E-04
   +7.47100000E-05  -2.60400000E-05  +8.24000000E-05  -2.37300000E-05  +3.31960000E-04
   -8.60900000E-05  +1.34230000E-04  -4.30100000E-05  +5.60400000E-05  +9.84000000E-06
   -2.71900000E-05  +9.64000000E-05  -3.42300000E-05  +1.87388000E-03  -2.30011000E-03
   +4.96517000E-03  +2.01070000E-04  +9.95670000E-04  -3.07080000E-04  +4.72027000E-03
   -1.62947000E-03  +1.30302000E-03  -1.61359000E-03  -1.64534600E-02  -6.76070000E-03
   +1.68842300E-02  -1.48236280E-01  -1.61524900E-01  +8.09170000E-04  +5.88080000E-04
   +2.84711000E-03  -1.89665000E-03  +1.82749000E-03  -7.95820000E-04  -2.00100000E-05
   +8.77000000E-06  -5.90400000E-05  +4.90300000E-05  +5.79000000E-05  +1.77300000E-05
   -3.41800000E-04  +2.92010000E-04  -9.84300000E-05  -1.72900000E-05  -6.07590000E-04
   -5.39390000E-04  -2.50420000E-04  +2.57230000E-04  -3.90420000E-04  -1.80818000E-03
   +2.07455000E-03  -2.08578000E-03  -1.87012400E-02  +1.63186110E-01  +1.63358040E-01
   -1.76140000E-04  +3.57010000E-04  -5.56210000E-04  +4.23980000E-04  -4.47130000E-04
   -6.11290000E-04  -1.55500000E-05  +1.12400000E-05  -2.92000000E-05  +2.89900000E-05
   -8.63100000E-05  +2.99300000E-05  -2.87300000E-05  +2.56780000E-04  -4.78700000E-05
   -4.70700000E-05  -1.55550000E-04  +2.30080000E-04  -1.64575000E-03  -1.02266000E-03
   -1.43496000E-03  -1.16200000E-04  +1.58950000E-04  -3.41530000E-04  +1.13300000E-04
   -1.98500000E-04  +3.31000000E-05  +2.03500000E-05  +6.39980000E-04  +3.47240000E-04
   -2.75890000E-04  -1.06350000E-04  +1.11770000E-04  +1.64670000E-04  +1.37180000E-04
   +6.66200000E-05  +3.74300000E-05  -1.54840000E-04  -1.09330000E-04  -3.03810000E-04
   -9.23100000E-05  -6.13900000E-05  -2.28400000E-05  -4.73000000E-05  -3.06700000E-05
   +3.81900000E-05  +4.09900000E-05  -4.68000000E-06  -5.11022400E-02  +1.91714800E-02
   +2.76047400E-02  -5.83800000E-05  -4.45400000E-05  +1.81800000E-05  -7.88000000E-06
   -1.16300000E-05  +9.94000000E-06  +1.68000000E-06  +6.60000000E-06  -7.45000000E-06
   +3.76400000E-05  +8.08000000E-06  -7.49600000E-05  +2.38230000E-04  -1.53420000E-04
   +1.04400000E-04  +1.14700000E-05  -1.65900000E-05  +1.63100000E-05  +5.22808800E-02
   +7.57130000E-04  +4.27820000E-04  -5.42900000E-05  -1.90100000E-04  +6.09540000E-04
   -1.42430000E-04  -3.37490000E-04  -1.30000000E-06  -1.43580000E-04  +1.72400000E-05
   +1.41200000E-05  +9.90000000E-06  +7.59200000E-05  -6.15000000E-06  +7.41400000E-05
   -1.03550000E-04  -2.12300000E-05  +1.02190000E-04  -2.67006000E-03  +9.90392000E-03
   +1.42474000E-02  +1.00940000E-04  -1.38519000E-03  +2.47523000E-03  -5.03100000E-05
   -7.94000000E-06  -2.13500000E-05  +2.98600000E-04  +9.78850000E-04  +1.24840000E-04
   -1.41800000E-04  -2.06600000E-05  -9.62700000E-05  +9.16100000E-05  +1.30080000E-04
   +1.15170000E-04  +2.57000000E-06  -9.11300000E-05  -1.23700000E-04  +3.07900000E-05
   -1.38890000E-04  -1.01810000E-04  -4.00670000E-04  -1.17680000E-04  +5.81410000E-04
   +1.35380000E-04  +9.82700000E-05  +5.97000000E-06  +1.90706000E-02  -1.40417900E-01
   -1.27657300E-01  -4.19300000E-05  -2.87900000E-05  -2.50100000E-05  -1.40500000E-05
   -4.88000000E-06  +2.20000000E-06  +1.62800000E-05  -2.66000000E-06  +2.44000000E-06
   +1.58100000E-05  -9.99000000E-06  +1.15900000E-05  +4.31700000E-05  -7.55100000E-04
   +2.19410000E-04  -8.50000000E-07  +4.70000000E-07  +1.89400000E-05  -2.19061600E-02
   +1.50758640E-01  +7.39000000E-06  +2.72060000E-04  +1.55590000E-04  +1.13816000E-03
   -1.00844000E-03  +1.15739000E-03  +6.41000000E-05  +4.89310000E-04  -1.40870000E-04
   +9.86300000E-05  -1.43170000E-04  +1.01890000E-04  -2.87000000E-05  -5.04900000E-05
   +1.05740000E-04  -2.32810000E-04  +6.51000000E-06  +2.08730000E-04  +3.36718000E-03
   -1.65641900E-02  -2.10227800E-02  -1.02390000E-04  +4.54207000E-03  -4.54284000E-03
   +4.81600000E-05  -3.39900000E-05  -1.88200000E-05  -1.42710000E-03  -8.39190000E-04
   +6.73220000E-04  +8.51300000E-04  +1.52400000E-04  -1.99460000E-04  -4.24160000E-04
   -4.54830000E-04  -1.11700000E-04  -2.82590000E-04  +3.54140000E-04  +3.84860000E-04
   +5.07410000E-04  +3.67790000E-04  +1.94110000E-04  +2.42130000E-04  -6.38750000E-04
   -8.36100000E-05  -4.31000000E-05  -2.78700000E-05  -1.15200000E-05  +2.75086200E-02
   -1.25393380E-01  -2.19533060E-01  +1.05200000E-05  +8.52000000E-06  -6.00800000E-05
   +7.57000000E-06  +1.11900000E-05  -6.42000000E-06  -8.18000000E-06  +1.12000000E-05
   -2.13800000E-05  -1.39140000E-04  +1.67800000E-05  +6.41100000E-05  -2.22030000E-04
   +5.44410000E-04  +9.54400000E-05  +4.16800000E-05  +8.41000000E-06  +2.83000000E-06
   -2.97264300E-02  +1.36410950E-01  +2.40116380E-01  -1.73530000E-04  -2.58650000E-04
   +4.10080000E-04  +6.06220000E-04  -2.16940000E-04  +2.01760000E-04  +3.91300000E-05
   -8.00800000E-05  +2.61130000E-04  +2.82800000E-05  +2.09300000E-05  -1.29920000E-04
   +7.91600000E-05  -3.98390000E-04  +3.85200000E-05  +4.59300000E-05  +3.58600000E-04
   -3.02000000E-04  -1.93573000E-03  -8.27500000E-05  +8.71740000E-04  -2.85400000E-05
   -1.89070000E-04  +4.22800000E-04  -2.19270000E-04  +3.14240000E-04  -4.43100000E-05
   +9.48400000E-04  -1.41728000E-03  +2.53300000E-04  +2.39970000E-04  +1.48670000E-04
   +1.40220000E-04  +1.12050000E-04  +1.14770000E-04  -5.79300000E-05  +4.75300000E-05
   -7.25200000E-05  -1.35690000E-04  -1.82400000E-04  -2.07000000E-05  -3.18300000E-05
   +2.45530000E-04  +3.29030000E-04  +2.73240000E-04  +3.03400000E-05  +1.26200000E-05
   +2.36800000E-05  -2.67077460E-01  +1.05176620E-01  -1.46335000E-02  +3.26300000E-05
   +5.85700000E-05  +1.47400000E-05  -8.28000000E-06  -2.52000000E-06  -3.93000000E-06
   +2.62100000E-05  +1.81800000E-05  +2.99000000E-06  +2.09200000E-05  +3.38400000E-05
   -1.45800000E-05  +2.03100000E-05  -7.38700000E-05  -1.13000000E-06  -7.56000000E-06
   +1.22200000E-05  -6.59000000E-06  -2.72161000E-03  +3.26400000E-04  -4.01320000E-04
   +2.87389050E-01  -6.90360000E-04  +5.86300000E-05  +4.73350000E-04  -8.33070000E-04
   -1.20446000E-03  +3.46458000E-03  +1.23494000E-03  -1.75800000E-05  -1.01440000E-04
   -9.75100000E-05  -2.04660000E-04  +4.12300000E-04  -2.91730000E-04  +2.20140000E-04
   -5.28500000E-05  +1.87740000E-04  +5.17300000E-05  -5.46500000E-05  +1.58237000E-02
   -1.01449900E-02  +1.50380000E-03  -3.94920000E-04  +1.52710000E-04  -1.06911000E-03
   +2.62170000E-04  -1.75170000E-04  +5.29100000E-05  +1.20879000E-03  +5.12610000E-04
   -1.12740000E-04  -3.14250000E-04  +1.31550000E-04  +1.13300000E-05  -1.67890000E-04
   -4.15600000E-05  +4.62300000E-05  -2.11010000E-04  -1.35090000E-04  +8.39000000E-05
   +6.00400000E-05  +3.22700000E-05  -5.54900000E-05  +7.18000000E-06  -3.38640000E-04
   -5.19210000E-04  +1.97090000E-04  +1.91650000E-04  -1.83000000E-06  +1.03253800E-01
   -9.53632400E-02  +5.59238000E-03  +1.25810000E-04  -2.87700000E-05  -1.64870000E-04
   -3.11400000E-05  -2.28800000E-05  +2.36100000E-05  +1.44900000E-05  -6.24000000E-06
   +9.00000000E-08  +3.43200000E-05  -1.15200000E-05  +6.25100000E-05  +1.72000000E-05
   +1.19540000E-04  +1.36660000E-04  +1.12700000E-05  -6.26000000E-06  +1.46900000E-05
   +1.66759300E-02  -7.97599000E-03  +2.03727000E-03  -1.13937110E-01  +1.02748520E-01
   +8.84710000E-04  +3.75740000E-04  -2.33060000E-04  +1.24361000E-03  +2.03383000E-03
   -4.44811000E-03  -1.55588000E-03  +8.22280000E-04  +1.50350000E-04  +1.64390000E-04
   +1.88910000E-04  -3.91020000E-04  +1.65450000E-04  -1.44050000E-04  +9.90600000E-05
   -2.38720000E-04  +5.35400000E-05  +1.70490000E-04  -2.50744200E-02  +1.25811900E-02
   -3.71077000E-03  -1.28129000E-03  +7.94850000E-04  +1.13862000E-03  -1.37310000E-04
   +7.79000000E-05  -4.88700000E-05  -8.85740000E-04  -4.76340000E-04  +6.15470000E-04
   -8.75500000E-05  -1.35550000E-04  +2.10880000E-04  +1.91740000E-04  +1.42820000E-04
   -2.72600000E-05  +2.31850000E-04  -2.38700000E-05  -2.08860000E-04  -4.28640000E-04
   -3.78600000E-05  +7.12800000E-05  +4.27010000E-04  +1.53960000E-04  -3.56000000E-06
   -1.97210000E-04  -1.52470000E-04  +2.06000000E-06  -1.26678300E-02  +4.88917000E-03
   -4.70884200E-02  -7.78800000E-05  -1.19800000E-05  +4.07400000E-05  +2.64200000E-05
   +3.17000000E-06  -5.40000000E-07  -9.23000000E-06  +8.83000000E-06  +1.11700000E-05
   +3.44300000E-05  -1.15000000E-05  -1.04590000E-04  +2.73200000E-05  -5.15000000E-06
   +5.41100000E-05  +1.30500000E-05  -1.17700000E-05  +3.57000000E-06  +2.40506300E-02
   -1.00112400E-02  +2.36997000E-03  +1.46984200E-02  -9.93179000E-03  +5.25456300E-02
   -7.46840000E-04  +9.16900000E-04  +2.77650000E-04  -1.81980000E-04  +4.99100000E-05
   +2.57470000E-04  +1.16830000E-04  -1.36900000E-04  -6.82500000E-05  -1.40000000E-07
   +2.11000000E-05  +1.22750000E-04  -1.72410000E-04  +2.29900000E-05  -4.00200000E-05
   +1.27090000E-04  +8.54800000E-05  -1.43570000E-04  +7.29940000E-04  +1.77310000E-03
   +1.84200000E-05  +3.14900000E-04  +1.64200000E-04  -2.48820000E-04  +1.06050000E-04
   -1.72700000E-05  +2.43900000E-05  +5.47140000E-04  -6.03610000E-04  +4.84970000E-04
   +5.01650000E-04  -1.73040000E-04  -7.63100000E-05  +4.41600000E-05  -8.72000000E-06
   -5.24600000E-05  +3.04370000E-04  +1.55180000E-04  -8.44600000E-05  -2.82650000E-04
   -3.07700000E-05  +3.71200000E-05  +1.93890000E-04  +4.36360000E-04  +4.08140000E-04
   -2.87680000E-04  -2.33350000E-04  +1.69000000E-06  -1.74505690E-01  -1.33242090E-01
   +3.89670000E-04  +6.89300000E-05  -1.37300000E-05  -6.79100000E-05  +4.17100000E-05
   +1.30200000E-05  -1.70600000E-05  -2.62700000E-05  -9.14000000E-06  +8.87000000E-06
   -5.74400000E-05  +5.40100000E-05  -4.96000000E-06  +2.62100000E-05  -6.73400000E-05
   -1.31000000E-06  -2.31100000E-05  -7.47000000E-06  -1.73200000E-05  +3.11003000E-03
   +4.67045000E-03  -2.80860000E-04  -1.85631200E-02  -2.16439300E-02  -3.05380000E-04
   +1.89233540E-01  -4.10600000E-04  -5.61480000E-04  +9.78330000E-04  -5.78080000E-04
   +5.66480000E-04  -2.63970000E-04  +2.83970000E-04  -1.33040000E-04  +1.89350000E-04
   -7.11500000E-05  +1.31160000E-04  -8.18000000E-05  -1.15760000E-04  -3.50660000E-04
   -5.36500000E-05  +2.53380000E-04  +4.93030000E-04  -4.87320000E-04  -1.21832700E-02
   -1.22691600E-02  -1.36023000E-03  +1.62480000E-04  +4.88970000E-04  -1.48123000E-03
   -9.80900000E-05  +3.07880000E-04  -1.59900000E-05  +2.35030000E-04  -9.59260000E-04
   +3.59436000E-03  +5.99030000E-04  -3.69100000E-04  -2.31170000E-04  -5.65310000E-04
   -4.66110000E-04  -3.80140000E-04  +5.61200000E-05  +5.81390000E-04  +4.71420000E-04
   +2.72180000E-04  +1.72320000E-04  +6.53000000E-06  -3.24470000E-04  -1.23790000E-04
   +2.79080000E-04  -4.35020000E-04  -4.08380000E-04  -5.58800000E-05  -1.32210210E-01
   -1.85059820E-01  +4.11650000E-04  +1.31320000E-04  +8.81100000E-05  +1.08600000E-05
   +6.49700000E-05  +2.92500000E-05  -2.95600000E-05  -1.00290000E-04  -1.44300000E-05
   -3.77100000E-05  +2.78800000E-05  -1.50000000E-05  +1.41510000E-04  -7.21100000E-05
   +1.80180000E-04  -1.40040000E-04  -1.07100000E-05  -4.08900000E-05  -1.09800000E-05
   -1.25378900E-02  -1.24863500E-02  +1.33768000E-03  +9.91269000E-03  +1.11512800E-02
   -1.93460000E-04  +1.45837300E-01  +1.99005840E-01  -4.94430000E-04  -2.60970000E-04
   +3.17950000E-04  +2.43570000E-04  -5.06660000E-04  +5.84000000E-04  +1.44000000E-06
   -5.89000000E-05  -1.37110000E-04  +1.67800000E-05  -4.80300000E-05  +6.00500000E-05
   -4.97200000E-05  +3.76400000E-05  -2.04500000E-05  -1.82100000E-05  -2.69500000E-05
   -2.02200000E-05  +2.01264900E-02  +1.90303200E-02  -9.40030000E-04  +1.00889000E-03
   +1.03770000E-03  +1.29412000E-03  +5.28600000E-05  -3.18300000E-05  +1.75000000E-05
   -1.10397000E-03  +2.05045000E-03  -4.25700000E-03  +4.57130000E-04  +6.22380000E-04
   +1.22540000E-04  +1.82690000E-04  -1.15570000E-04  +3.58530000E-04  -3.33530000E-04
   -1.86490000E-04  +9.54000000E-06  +5.31350000E-04  -2.28900000E-05  +1.22490000E-04
   +1.36910000E-04  -2.89460000E-04  -3.32400000E-05  +4.46510000E-04  +4.15940000E-04
   -7.50000000E-07  +1.41890000E-04  -9.19970000E-04  -4.81141000E-02  +1.79200000E-05
   -1.48000000E-05  -4.03700000E-05  -5.36800000E-05  +6.05000000E-06  +2.69800000E-05
   +7.45900000E-05  +3.49500000E-05  -5.84000000E-06  -3.26200000E-05  +9.90700000E-05
   -1.85180000E-04  -2.51100000E-04  +3.18480000E-04  -9.13400000E-05  +3.15600000E-05
   +3.28000000E-05  +1.85200000E-05  -1.89734800E-02  -1.74281300E-02  +1.09662000E-03
   -8.58590000E-04  -1.31500000E-03  -9.53520000E-04  -5.55240000E-04  -2.22248000E-03
   +5.07257900E-02  +3.79330000E-04  +2.58700000E-05  +4.69800000E-05  +8.44450000E-04
   +1.37660000E-03  +3.35590000E-04  +7.94600000E-05  -1.14440000E-04  +4.68000000E-05
   -7.47900000E-05  +5.20200000E-05  -2.81000000E-06  -8.08000000E-05  +3.18100000E-05
   -9.04000000E-06  +3.16100000E-05  -6.39300000E-05  -6.98200000E-05  +5.85770000E-04
   +2.18527000E-03  +8.71890000E-04  -2.25679840E-01  -1.29512850E-01  +2.94766000E-03
   +8.11700000E-05  -3.31800000E-05  +7.87000000E-06  +4.27500000E-04  +4.82560000E-04
   +5.91230000E-04  -3.37800000E-04  +1.37590000E-04  +4.29430000E-04  +2.28770000E-04
   -1.47270000E-04  -2.26440000E-04  +7.81400000E-05  +5.57200000E-05  -2.45000000E-05
   -7.13500000E-05  -4.96700000E-05  -7.14400000E-05  +1.98960000E-04  +2.49650000E-04
   +2.36760000E-04  -1.43670000E-04  -1.62720000E-04  -4.29500000E-05  -1.16270000E-04
   +1.68030000E-04  +1.60600000E-04  +8.48800000E-05  -3.93400000E-05  -3.92700000E-05
   +4.11300000E-05  +2.91100000E-05  +2.42000000E-06  -1.87700000E-05  -4.31000000E-06
   +2.13200000E-05  +2.46000000E-04  -2.01830000E-04  -4.86190000E-04  +9.19200000E-05
   -5.82300000E-05  -4.05400000E-05  -1.29100000E-05  +5.96000000E-06  -1.77000000E-05
   +2.22640000E-04  +2.50120000E-04  -4.43900000E-05  +2.13900000E-05  -1.19710000E-04
   +7.51900000E-05  +2.91350000E-04  +2.00170000E-04  -4.55060000E-04  +2.42062670E-01
   +7.11260000E-04  +2.98350000E-04  -2.79400000E-05  -1.59828000E-03  +5.78290000E-04
   +6.27330000E-04  +4.21100000E-05  -3.98120000E-04  +4.06590000E-04  +8.09000000E-06
   +1.08080000E-04  -3.30900000E-05  +8.25500000E-05  -4.43170000E-04  +1.39440000E-04
   +2.53300000E-05  +1.85680000E-04  -1.14960000E-04  -1.69816100E-02  -1.48147800E-02
   -4.46200000E-05  -1.27523400E-01  -1.38044540E-01  +3.81583000E-03  -1.75520000E-04
   +2.98870000E-04  -8.56900000E-05  +1.58411000E-03  -1.78616000E-03  -3.78483000E-03
   +6.14720000E-04  +8.29600000E-05  -4.54590000E-04  -1.11250000E-04  +1.32040000E-04
   +3.82600000E-05  +3.07570000E-04  +1.36950000E-04  -7.37100000E-05  +3.30000000E-06
   -3.80590000E-04  -1.39130000E-04  -1.32715000E-03  -2.84730000E-04  +1.73650000E-04
   -2.63150000E-04  -2.04330000E-04  +2.47300000E-05  +2.27170000E-04  +3.43880000E-04
   +1.28991000E-03  +1.88120000E-04  +5.90000000E-07  -4.59200000E-05  +2.94400000E-05
   +1.48500000E-05  -1.60600000E-05  -5.07000000E-05  -1.62000000E-05  -1.87000000E-06
   +1.26140000E-04  +8.33000000E-06  +3.25000000E-04  +1.00200000E-05  +2.38100000E-05
   -8.49800000E-05  -7.66200000E-05  -1.11410000E-04  +2.72800000E-05  +2.75390000E-04
   +5.49000000E-05  +1.00090000E-04  +1.20260000E-04  +5.86800000E-05  +7.84000000E-06
   +1.03170000E-04  +6.66240000E-04  -2.22480000E-04  +1.39915720E-01  +1.50086930E-01
   +2.35730000E-04  +1.73330000E-04  +1.79670000E-04  -1.07063000E-03  +5.09150000E-04
   +9.59520000E-04  +7.30700000E-05  +4.93300000E-05  -2.42610000E-04  -1.35160000E-04
   +2.49300000E-05  +3.63200000E-05  +6.82200000E-05  -1.86540000E-04  +6.97500000E-05
   -1.96000000E-05  +7.01900000E-05  -1.65450000E-04  -2.01749800E-02  -1.51280600E-02
   -1.43719000E-03  +4.64882000E-03  +4.73650000E-03  -4.71431300E-02  -1.39670000E-04
   +1.60600000E-04  -5.47100000E-05  +1.53316000E-03  -2.48633000E-03  -3.77156000E-03
   +9.06260000E-04  -2.38980000E-04  -3.14070000E-04  -2.03770000E-04  -6.08500000E-05
   +1.89740000E-04  +6.54300000E-05  +1.57190000E-04  +2.23100000E-05  +1.89990000E-04
   -2.42390000E-04  -2.31790000E-04  -1.33701000E-03  -9.30960000E-04  +3.09980000E-04
   -1.11030000E-04  -5.15800000E-05  +1.60200000E-05  -1.23007000E-03  -9.29900000E-04
   +1.14464000E-03  +2.28900000E-05  +4.58600000E-05  +2.98600000E-05  +2.64000000E-06
   -6.00000000E-06  -6.93000000E-06  -1.94800000E-05  -3.22200000E-05  +1.18600000E-05
   -1.36460000E-04  +5.13740000E-04  +1.24760000E-04  -3.00000000E-06  +2.60800000E-05
   -6.88000000E-06  -1.07100000E-04  -6.42200000E-05  -2.73700000E-05  +2.49480000E-04
   +2.16420000E-04  +2.51390000E-04  +6.63000000E-05  -6.08000000E-06  -5.96300000E-05
   +3.15780000E-04  +3.35010000E-04  -7.47860000E-04  -4.98956000E-03  -3.41900000E-04
   +5.12237700E-02  +9.52420000E-04  +4.35510000E-04  -2.30620000E-04  +1.18380000E-04
   +6.88470000E-04  +1.44284000E-03  +3.16000000E-05  -3.77440000E-04  +2.25750000E-04
   -5.26100000E-05  +5.75000000E-05  -5.16400000E-05  +2.36780000E-04  -5.75390000E-04
   +2.41160000E-04  -2.41370000E-04  +2.64250000E-04  -1.03460000E-04  -1.58744000E-03
   +2.72520000E-04  -2.76050000E-04  -2.21848730E-01  +1.25480960E-01  -1.97702000E-02
   -3.10770000E-04  +3.75380000E-04  -1.21520000E-04  -7.39200000E-05  -1.15450000E-04
   +2.31880000E-04  -6.50280000E-04  -7.69880000E-04  +5.17610000E-04  +1.84030000E-04
   -1.34670000E-04  -1.92180000E-04  -1.55840000E-04  -3.34900000E-05  -2.04800000E-05
   +3.16600000E-05  +7.22000000E-06  -7.40000000E-06  +1.17680000E-04  +1.14760000E-04
   +2.46800000E-05  +7.87200000E-05  +3.02700000E-05  -2.37600000E-05  +3.20290000E-04
   -2.95780000E-04  -5.32910000E-04  +1.32630000E-04  +4.18200000E-05  -2.49200000E-05
   -6.19000000E-06  +7.30000000E-06  +3.95000000E-06  +2.71400000E-05  -1.49000000E-06
   +2.44900000E-05  -6.92550000E-04  -1.74619000E-03  -2.00260000E-04  -1.74500000E-05
   -1.26300000E-05  -2.06300000E-05  +8.32000000E-06  +1.87100000E-05  -5.75000000E-06
   +2.09990000E-04  -2.39780000E-04  +4.34200000E-05  +3.72460000E-04  -1.09880000E-04
   +3.74350000E-04  -2.31420000E-04  +1.00680000E-04  +7.68300000E-05  -1.94728700E-02
   +1.58541300E-02  -2.87688000E-03  +2.41021020E-01  -1.62210000E-04  -3.47940000E-04
   +2.16060000E-04  -2.41320000E-04  -1.48222000E-03  -3.68503000E-03  +1.47180000E-04
   +4.56400000E-05  +3.17300000E-05  -1.01380000E-04  +6.84000000E-05  -1.47040000E-04
   -3.13550000E-04  +7.75450000E-04  -3.73690000E-04  +6.11700000E-04  -1.80950000E-04
   +2.60700000E-04  +1.73251400E-02  -1.22931300E-02  +2.57536000E-03  +1.24443580E-01
   -1.36191850E-01  +1.36971600E-02  +4.04020000E-04  -4.71830000E-04  +1.33750000E-04
   +5.43620000E-04  +6.60820000E-04  +4.10230000E-04  +3.20390000E-04  -4.52090000E-04
   -7.12650000E-04  -3.96620000E-04  +1.95380000E-04  +3.11260000E-04  -8.65000000E-05
   +1.14400000E-05  +1.15090000E-04  +1.59500000E-04  +1.81410000E-04  +3.32500000E-05
   -2.48820000E-04  -1.48950000E-04  -1.72740000E-04  +1.15130000E-04  +1.72800000E-04
   +5.20800000E-05  +1.27200000E-05  +5.81880000E-04  +1.56560000E-03  +4.31000000E-06
   -1.43340000E-04  +9.55800000E-05  -3.89000000E-05  -4.47900000E-05  -7.90000000E-07
   +5.83000000E-06  -3.13400000E-05  -1.51200000E-05  -1.33196000E-03  -1.10444000E-03
   +7.04300000E-04  +2.04800000E-05  +8.33200000E-05  +1.24090000E-04  +9.20000000E-06
   -4.50000000E-06  +2.06700000E-05  -3.04360000E-04  -2.01700000E-05  +1.42030000E-04
   -3.22270000E-04  +5.40110000E-04  -4.30900000E-04  -1.33360000E-04  -3.03700000E-05
   -1.35340000E-04  -1.55603300E-02  +1.22421600E-02  -2.03801000E-03  -1.36907670E-01
   +1.46206330E-01  +6.24600000E-05  -6.40400000E-04  +2.44020000E-04  -3.92100000E-05
   -2.27691000E-03  -4.28109000E-03  +2.37800000E-04  +4.13940000E-04  -1.81190000E-04
   +2.99220000E-04  -2.90050000E-04  -1.73300000E-05  -7.98100000E-05  +9.85080000E-04
   -4.89990000E-04  +5.22550000E-04  -1.04280000E-04  +4.05680000E-04  +2.09934300E-02
   -1.40193300E-02  +9.85570000E-04  -2.00806500E-02  +1.48514400E-02  -4.91105700E-02
   +2.38130000E-04  -5.90350000E-04  +2.12250000E-04  +3.33500000E-05  +5.86290000E-04
   +5.57880000E-04  -5.44610000E-04  +3.29050000E-04  +4.90720000E-04  -2.36300000E-05
   -1.91590000E-04  -1.61250000E-04  -1.63560000E-04  +2.11500000E-05  +1.28930000E-04
   +1.09280000E-04  +6.53400000E-05  -2.33300000E-05  +3.26500000E-05  -1.90000000E-07
   -2.25630000E-04  +5.94500000E-05  +1.60000000E-05  -3.19500000E-05  +1.13652000E-03
   -7.52790000E-04  +1.12074000E-03  -6.88940000E-04  +9.87900000E-05  +3.83170000E-04
   -1.96000000E-06  +4.02000000E-06  +1.02400000E-05  +7.87000000E-06  +1.88000000E-06
   +1.15600000E-05  +9.41900000E-05  +2.56200000E-05  +1.48480000E-04  +4.19500000E-05
   -1.62000000E-06  +2.85900000E-05  +1.99400000E-05  -7.46000000E-06  +9.10000000E-06
   -1.74160000E-04  +1.60480000E-04  +3.60360000E-04  -4.31510000E-04  -7.39100000E-05
   -7.12740000E-04  +6.39300000E-05  +1.28940000E-04  -3.79500000E-05  +9.31820000E-04
   -6.45250000E-04  -9.10640000E-04  +2.10319500E-02  -1.32222400E-02  +5.28751900E-02
   -2.45250000E-04  +6.81700000E-05  +3.00000000E-05  +2.15560000E-04  -5.17550000E-04
   +3.32490000E-04  -3.61920000E-04  +3.50470000E-04  +3.59890000E-04  -2.08370000E-04
   +1.59610000E-04  -5.19300000E-05  -1.39320000E-04  +2.22500000E-05  -8.67000000E-06
   +9.94200000E-05  -5.25000000E-05  -1.08500000E-05  -1.99150000E-03  -1.11582000E-03
   +1.07854000E-03  -4.75859400E-02  -4.63005000E-03  +9.21243000E-03  +1.23900000E-04
   -3.06800000E-05  -1.24900000E-05  +2.32480000E-04  +3.24530000E-04  -5.20900000E-04
   +6.89100000E-05  -4.38360000E-04  -5.37410000E-04  -1.08530000E-04  +6.21800000E-05
   +2.14190000E-04  -6.37100000E-05  -2.17200000E-05  +1.02700000E-05  +8.51800000E-05
   +7.47000000E-05  +2.24900000E-05  -8.38500000E-05  -1.98600000E-05  -3.88100000E-05
   +9.30400000E-05  +1.21300000E-04  +3.18900000E-05  -2.96300000E-05  +8.65300000E-05
   -1.19500000E-05  +2.46530000E-04  -7.80300000E-05  -1.27540000E-04  -2.69700000E-05
   -2.30600000E-05  -4.15000000E-06  +1.66000000E-06  +7.40000000E-07  -2.40400000E-05
   -1.20342000E-03  +3.85100000E-05  -4.74240000E-04  -1.30500000E-05  +4.09800000E-05
   +3.75100000E-05  +9.03000000E-06  +4.84000000E-06  +1.50800000E-05  +6.51630000E-04
   +6.77200000E-05  +6.35500000E-05  +3.14860000E-04  -1.99180000E-04  +3.29660000E-04
   +1.10830000E-04  +3.13640000E-04  -2.12410000E-04  +2.93000000E-05  -1.18511100E-02
   +2.40349900E-02  +1.64817000E-03  +1.19335500E-02  -2.39018800E-02  +4.80451700E-02
   +3.21940000E-04  -4.51000000E-06  +2.08700000E-05  -4.49060000E-04  +6.44980000E-04
   +6.57570000E-04  +6.19630000E-04  -1.14453000E-03  -8.19290000E-04  -4.66300000E-05
   -4.18500000E-05  +6.70600000E-05  +1.47640000E-04  -1.93150000E-04  +9.69600000E-05
   -1.58630000E-04  +1.15880000E-04  -7.68100000E-05  +4.65070000E-04  +1.10801800E-02
   -1.80434000E-02  -4.29189000E-03  -1.07043230E-01  +1.11227230E-01  -1.37210000E-04
   +1.35590000E-04  -3.56900000E-05  +1.31890000E-04  +1.07075000E-03  +4.28650000E-04
   -6.56160000E-04  +2.43950000E-04  +7.69400000E-05  -1.25300000E-05  -1.92640000E-04
   -1.15130000E-04  -1.62980000E-04  +9.42000000E-06  +1.80400000E-04  +1.67980000E-04
   +9.11700000E-05  -4.56800000E-05  +2.46190000E-04  -1.41640000E-04  +6.85000000E-06
   +9.17200000E-05  +4.26300000E-05  -2.78500000E-05  +3.22720000E-04  -2.45525000E-03
   -2.74919000E-03  -9.95000000E-06  +7.00500000E-05  +2.89800000E-05  -6.63000000E-06
   +5.53000000E-06  +9.65000000E-06  -9.14000000E-06  +2.65700000E-05  -2.51700000E-05
   -3.89250000E-04  -2.79580000E-04  -2.76160000E-04  -1.47100000E-05  +2.03800000E-05
   -2.48900000E-05  +9.50000000E-06  +2.15000000E-05  -1.23300000E-05  -9.55000000E-06
   +7.72350000E-04  -1.14435000E-03  -2.04050000E-04  -6.24600000E-05  -1.14920000E-04
   +2.91240000E-04  +7.93400000E-05  -1.56730000E-04  +9.40730000E-04  -8.77618000E-03
   +1.57572300E-02  -2.29125000E-03  -8.94814000E-03  +1.58010600E-02  +3.98105000E-03
   +1.17059230E-01  +4.14680000E-04  -1.53810000E-04  -5.95600000E-05  -9.32740000E-04
   +7.23900000E-04  -1.27100000E-05  +2.77190000E-04  +9.71690000E-04  -5.91390000E-04
   +3.07810000E-04  -5.03580000E-04  +3.52980000E-04  +2.29180000E-04  +3.57010000E-04
   -1.23880000E-04  -1.07730000E-04  -4.88300000E-05  +1.07710000E-04  +4.33080000E-04
   +1.28773700E-02  -1.97483700E-02  +9.08500000E-03  +1.09928740E-01  -2.55004660E-01
   -1.38510000E-04  -2.10310000E-04  +1.00150000E-04  +8.85410000E-04  +1.14939000E-03
   +8.47800000E-04  +3.42160000E-04  -2.96830000E-04  +5.28300000E-05  -3.09600000E-04
   -1.92220000E-04  +2.03700000E-04  -1.42970000E-04  +2.00780000E-04  +1.62930000E-04
   +2.31100000E-04  +1.69380000E-04  -1.80600000E-05  -6.27900000E-05  -5.31570000E-04
   +3.50000000E-06  -6.47000000E-06  +9.96000000E-06  +1.04800000E-05  +7.33420000E-04
   -4.95377000E-03  -3.48284000E-03  -7.79380000E-04  +2.29380000E-04  +2.98310000E-04
   -1.37000000E-05  -9.53000000E-06  -1.23200000E-05  -2.15500000E-05  -2.80700000E-05
   -1.06700000E-05  -5.77370000E-04  +2.55440000E-04  -6.05000000E-06  -3.37300000E-05
   +1.07070000E-04  +2.30600000E-05  -2.72000000E-05  +1.56700000E-05  -3.48500000E-05
   -9.84600000E-05  +8.27940000E-04  -1.57583000E-03  -1.13100000E-05  -4.54000000E-05
   +3.00010000E-04  +1.09900000E-05  -7.57500000E-05  +3.97850000E-04  -1.55750000E-04
   -5.02210000E-04  +6.02280000E-04  +3.28520000E-04  +7.02400000E-04  -1.88443000E-03
   -9.81857000E-03  -1.20448910E-01  +2.78145110E-01  +3.04215000E-03  +1.47707000E-03
   -1.11398000E-03  +2.46885000E-03  -3.77766000E-03  +3.88418000E-03  -1.41425080E-01
   +4.44059000E-02  +1.31734060E-01  -6.01132000E-03  -1.35650000E-04  +1.64114300E-02
   +1.26635000E-03  -7.97320000E-04  +3.31240000E-04  -1.35491000E-03  +9.64020000E-04
   -7.72300000E-05  -4.56180000E-04  -2.01460000E-04  -3.73410000E-04  -3.60470000E-04
   +6.59240000E-04  -3.39760000E-04  +3.05700000E-04  +2.03440000E-04  -5.08700000E-05
   -3.41630000E-04  +2.92220000E-04  -5.38020000E-04  -3.31500000E-05  +3.17800000E-05
   -8.98000000E-06  -7.17500000E-05  -8.59200000E-05  +5.24400000E-05  -1.73450000E-04
   -7.23500000E-05  +3.90100000E-05  +9.59000000E-05  +5.20400000E-05  -9.44000000E-06
   -6.84000000E-06  -5.22600000E-05  -1.05070000E-04  +1.22780000E-04  +1.03040000E-04
   +5.29000000E-06  -1.08300000E-05  -7.31900000E-05  -1.33200000E-05  +3.27031000E-03
   +5.54932000E-03  +1.15207000E-03  -2.61100000E-05  -1.54200000E-05  +1.69000000E-06
   +9.27000000E-06  +2.21000000E-06  -7.62000000E-06  -8.63000000E-06  +8.61800000E-05
   -7.29000000E-06  -1.02500000E-05  -4.14000000E-06  +3.82000000E-05  +3.30000000E-06
   +4.73000000E-06  +7.08000000E-06  +9.30000000E-07  +6.68000000E-06  -1.66800000E-05
   +5.70600000E-05  -1.71100000E-05  -2.70000000E-06  -8.86000000E-06  -2.54500000E-05
   +3.62600000E-05  -1.63500000E-05  -1.11170000E-04  +1.26920000E-04  -7.30000000E-06
   +9.24000000E-06  -1.83220000E-04  +8.44300000E-05  +1.13325000E-03  -2.02430000E-04
   +1.41721820E-01  +3.00196000E-03  -2.26458000E-03  +2.16741000E-03  -1.33040800E-02
   +5.41393000E-03  +1.79879500E-02  +3.81150800E-02  -5.62206300E-02  -3.71498400E-02
   +1.43230500E-02  -3.21675000E-03  -2.18346700E-02  +1.26600000E-04  -2.46119000E-03
   +9.29610000E-04  -5.54970000E-04  +1.44594000E-03  -3.82300000E-05  -2.51970000E-04
   +5.28320000E-04  -1.30660000E-04  +7.81500000E-05  -1.05232000E-03  +1.00033000E-03
   +1.43583000E-03  +1.68348000E-03  -4.89640000E-04  +3.63250000E-04  +1.03740000E-04
   -6.67600000E-05  -5.12000000E-06  +4.64100000E-05  +1.47970000E-04  +2.31500000E-05
   -4.06800000E-05  +3.43000000E-06  +5.97600000E-05  -1.34900000E-05  -8.19800000E-05
   -1.13230000E-04  -1.55510000E-04  +2.84000000E-05  +2.66700000E-05  +3.83900000E-05
   +8.07900000E-05  -5.62000000E-05  -7.21000000E-05  +1.20600000E-05  -1.65040000E-04
   -2.00630000E-04  -1.67560000E-04  +9.23738000E-03  -2.81144000E-03  +1.44464000E-03
   -7.05000000E-06  +1.43700000E-05  -1.68300000E-05  -1.96900000E-05  +1.15600000E-05
   -4.95000000E-06  +8.81300000E-05  -1.56200000E-05  -4.32800000E-05  -1.50800000E-05
   -7.43000000E-06  -3.13800000E-05  -1.21000000E-05  -5.29000000E-06  -1.15000000E-05
   -3.83500000E-05  +2.77600000E-05  -1.78050000E-04  +4.79900000E-05  +2.88100000E-05
   -3.87400000E-05  -2.80100000E-05  +3.88500000E-05  +2.81500000E-05  +2.14700000E-05
   +5.07800000E-05  -3.90400000E-05  -3.60700000E-05  +3.10580000E-04  -4.10700000E-04
   +1.30261000E-03  -2.17048000E-03  -4.60200000E-04  -4.80358800E-02  +6.29822600E-02
   -1.34033000E-03  +2.82948000E-03  -2.98449000E-03  +1.38599900E-02  -5.79751000E-03
   -1.26393000E-02  +1.34450490E-01  -3.83749000E-02  -2.31897390E-01  +4.42800000E-04
   +5.86860000E-04  +1.17312000E-03  +7.93140000E-04  +8.07970000E-04  -4.40130000E-04
   -5.33960000E-04  -1.79080000E-04  +1.52630000E-04  +1.12149000E-03  -5.22580000E-04
   -2.25080000E-04  +1.23040000E-04  -3.62300000E-05  -1.54790000E-04  +5.83430000E-04
   -3.54800000E-04  +1.52000000E-04  -2.56080000E-04  +2.03090000E-04  -4.77500000E-05
   -9.46000000E-05  -6.29200000E-05  +1.85400000E-04  -1.31830000E-04  -6.74700000E-05
   +6.06000000E-05  -2.72940000E-04  -7.17500000E-05  +5.76400000E-05  +1.51070000E-04
   +6.35800000E-05  -5.54400000E-05  +6.50400000E-05  -3.90850000E-04  -1.90270000E-04
   +2.26180000E-04  +1.78650000E-04  +1.51900000E-05  -9.94000000E-05  -2.24400000E-05
   +1.14800000E-05  +1.11258000E-03  +2.69768000E-03  +3.75251000E-03  -3.80300000E-05
   -1.41900000E-05  +1.00100000E-05  +2.06600000E-05  +1.14000000E-06  -7.87000000E-06
   -5.41300000E-05  +2.53200000E-05  -2.03400000E-05  +3.46500000E-05  +5.47000000E-05
   +7.88700000E-05  +8.96000000E-06  +1.81300000E-05  -1.60000000E-06  +3.33900000E-05
   +3.99400000E-05  +8.61900000E-05  -8.51000000E-05  +3.48300000E-05  +1.68800000E-05
   -8.09000000E-06  -1.29050000E-04  +3.35100000E-05  -4.35200000E-05  -1.88480000E-04
   +5.63000000E-05  -6.54000000E-05  -6.52800000E-05  +2.54650000E-04  +5.29800000E-05
   -2.09260000E-04  +8.59940000E-04  -1.48985460E-01  +3.93697200E-02  +2.41863190E-01
   -2.97187000E-03  +1.29023000E-03  -4.23270000E-04  +5.36216000E-03  +5.70017000E-03
   +2.16135000E-03  +5.31810000E-03  +1.00862300E-02  -1.13978000E-02  -4.07405400E-02
   +1.82507100E-02  -7.11423000E-03  +3.21566000E-03  +5.01396000E-03  +1.13392000E-03
   +1.22766000E-03  -2.15276000E-03  +6.44030000E-04  +4.09210000E-04  +4.63400000E-05
   -6.27500000E-05  +9.57800000E-05  -8.92500000E-05  -3.28000000E-06  -1.43803000E-03
   -8.77570000E-04  -8.82300000E-04  -8.95700000E-05  -7.83600000E-05  +4.08200000E-05
   -8.82000000E-06  -6.42000000E-06  -3.31800000E-05  -3.14000000E-06  -3.27500000E-05
   +2.23000000E-06  -3.08000000E-06  +1.72500000E-05  +1.08000000E-06  -2.94100000E-05
   -6.79500000E-05  +5.54500000E-05  +3.67900000E-05  +2.14500000E-05  +3.75500000E-05
   -3.28900000E-05  -5.50200000E-05  +1.26600000E-05  -5.15700000E-05  -7.67300000E-05
   -8.02000000E-06  -7.45296000E-03  -1.04144600E-02  +2.40540100E-02  -1.38300000E-05
   +8.03000000E-06  -1.59700000E-05  -1.33000000E-05  +3.39000000E-06  -6.47000000E-06
   +1.43100000E-05  -3.06000000E-06  -5.11000000E-06  +2.96000000E-05  +5.21200000E-05
   -1.55500000E-05  -1.95800000E-05  +3.90000000E-07  -2.85200000E-05  +2.18700000E-05
   +1.96300000E-05  -5.95000000E-06  -4.12300000E-05  -2.39100000E-05  -6.00000000E-06
   +1.40000000E-06  -5.31000000E-05  +2.66100000E-05  -1.12100000E-05  -3.15600000E-05
   -2.70000000E-07  -3.02000000E-05  -1.18900000E-05  -7.66000000E-06  +1.97800000E-05
   -1.06500000E-05  +2.12500000E-05  -2.91885000E-03  -2.57126000E-03  -2.32730000E-03
   +3.80747000E-02  -7.64720000E-04  +3.23320000E-04  -3.71440000E-04  +7.03210000E-03
   +1.58642000E-03  -1.24154000E-03  -5.10940000E-04  -9.59410000E-03  +2.11657100E-02
   +1.57604600E-02  -1.69913430E-01  +1.54817300E-01  -2.06209000E-03  -4.17460000E-04
   -6.19100000E-04  +1.28572000E-03  +2.37200000E-04  +5.66700000E-05  -5.01450000E-04
   -8.00600000E-04  +1.16214000E-03  +6.08000000E-05  +5.23000000E-06  +2.92800000E-05
   -2.62060000E-04  -5.35910000E-04  -1.45130000E-04  -2.95720000E-04  -1.29640000E-04
   -2.69600000E-05  +1.88100000E-05  +2.86000000E-05  -1.74900000E-05  +7.89000000E-06
   +1.14600000E-05  -9.27000000E-06  -3.73400000E-05  -1.96500000E-05  +7.43000000E-06
   +1.29200000E-05  -4.40000000E-06  +1.81500000E-05  +5.73000000E-06  +3.72600000E-05
   -1.42600000E-05  +4.05900000E-05  +2.55800000E-05  +2.81000000E-06  +4.54980000E-04
   -1.97220000E-04  -1.40310000E-04  +4.39125000E-03  +9.11687000E-03  -1.51300300E-02
   -1.01200000E-05  -1.64000000E-06  +7.90000000E-07  +1.02200000E-05  +3.13000000E-06
   -1.24000000E-06  -9.40000000E-07  -1.26100000E-05  +4.76000000E-06  +1.88300000E-05
   -5.21000000E-06  -7.87000000E-06  +4.50000000E-07  +5.65000000E-06  -7.22000000E-06
   -6.23000000E-06  +2.45000000E-05  +1.27900000E-05  +6.27000000E-06  -1.14830000E-04
   +1.46980000E-04  -1.88800000E-05  -2.81400000E-05  +8.73000000E-06  -7.31000000E-06
   -2.83000000E-05  -4.10000000E-06  +4.97000000E-06  -5.40000000E-05  -1.57400000E-05
   -1.28000000E-06  -1.01000000E-05  +1.14600000E-05  -2.12311000E-03  -1.54806000E-03
   -1.40631000E-03  -2.27680800E-02  +1.71171580E-01  -1.99950000E-04  -3.73220000E-04
   -3.36820000E-04  +2.85015000E-03  +1.34716000E-03  +1.30754000E-03  +1.60450000E-03
   -3.17463000E-03  +5.50038000E-03  -3.61699000E-03  +1.52484830E-01  -2.27431070E-01
   -3.94850000E-03  -3.08858000E-03  -8.30110000E-04  +1.45679000E-03  +8.60770000E-04
   -1.79680000E-04  +2.06650000E-04  -6.51900000E-05  +5.93190000E-04  -7.01800000E-05
   +4.24500000E-05  -5.65800000E-05  +9.01570000E-04  +6.31060000E-04  -5.93650000E-04
   -8.48300000E-05  -3.78500000E-05  +2.04600000E-05  -2.43600000E-05  +1.87000000E-06
   -3.93000000E-06  -1.72000000E-06  -6.25000000E-06  +6.61000000E-06  -4.83600000E-05
   -1.47100000E-05  +7.38000000E-06  -6.72000000E-06  -4.91900000E-05  +3.76800000E-05
   +4.83100000E-05  -1.06500000E-05  -1.71600000E-05  +2.24400000E-05  +9.80000000E-07
   +7.09000000E-06  +1.43070000E-04  -1.08080000E-04  -8.09000000E-06  +1.06956100E-02
   +1.02753300E-02  -2.39189200E-02  -1.40900000E-05  +3.10000000E-07  -4.00000000E-06
   +1.32000000E-06  +3.80000000E-07  -2.80000000E-06  +2.71000000E-06  -1.77000000E-06
   -5.41000000E-06  +2.38700000E-05  +1.80000000E-05  -1.20000000E-06  -1.13400000E-05
   +5.25000000E-06  -2.47500000E-05  +1.24800000E-05  +1.25800000E-05  -6.60000000E-06
   -1.02600000E-05  -5.09000000E-05  +4.11000000E-05  -1.17500000E-05  -2.73900000E-05
   +7.78000000E-06  -9.22000000E-06  -2.41200000E-05  -9.53000000E-06  -1.56700000E-05
   +2.73000000E-06  +4.14100000E-05  -4.37000000E-06  -8.52000000E-06  +2.86500000E-05
   -2.03993000E-03  -1.13090000E-03  -4.01350000E-04  -6.08346000E-03  -1.58503190E-01
   +2.45540730E-01  -1.68010900E-02  -1.47964400E-02  +1.03240800E-02  -2.99427000E-03
   +2.43142000E-03  -1.76779000E-03  +5.71900000E-05  +2.15240000E-04  -1.00141000E-03
   -6.43380000E-04  +1.97100000E-04  +1.48162000E-03  +4.08476000E-03  +1.44170000E-04
   -9.51140000E-04  -2.29890340E-01  -1.17383910E-01  +8.09126900E-02  +2.14590000E-04
   +1.55570000E-04  +1.30100000E-03  -4.75630000E-04  +1.46930000E-04  -1.86630000E-04
   -4.43290000E-04  +8.27640000E-04  -5.94320000E-04  +3.71700000E-05  +1.87690000E-04
   -1.02100000E-05  -2.22600000E-05  -4.91000000E-05  -1.50200000E-05  -1.76600000E-05
   -3.99400000E-05  -4.08000000E-06  +6.30100000E-05  +6.12800000E-05  +1.44400000E-05
   -3.17300000E-05  +4.60000000E-07  +2.03100000E-05  -1.53700000E-05  -3.19700000E-05
   -3.08900000E-05  -9.04600000E-05  -7.74100000E-05  -6.08000000E-06  -2.25000000E-06
   -1.08230000E-04  +8.11000000E-05  +3.40400000E-03  +3.96572000E-03  -1.03613000E-03
   +1.40600000E-05  +8.06000000E-06  -2.22000000E-06  -1.45400000E-05  -6.83000000E-06
   +3.78000000E-06  +1.23800000E-05  +1.16500000E-05  -6.74000000E-06  +1.66000000E-06
   +3.15500000E-05  +3.40500000E-05  -9.45000000E-06  -8.86000000E-06  -5.93000000E-06
   +5.05000000E-06  -2.15300000E-05  -2.85100000E-05  -3.68000000E-06  +4.17900000E-05
   -3.88700000E-05  +5.17000000E-06  +4.52800000E-05  +3.23000000E-06  +1.34100000E-05
   -9.13000000E-06  -1.60800000E-05  -5.08200000E-05  +1.31280000E-04  +1.44090000E-04
   +9.00000000E-06  -1.94400000E-05  +1.48000000E-05  -1.19500000E-05  -8.63000000E-05
   +9.85100000E-05  +1.70240000E-04  -2.16300000E-05  -2.60700000E-05  +2.42927430E-01
   +1.44960900E-02  +9.03785000E-03  -6.53956000E-03  +1.83732000E-03  -1.40654000E-03
   +1.31942000E-03  -1.82520000E-04  +4.18110000E-04  -7.73400000E-05  +1.03544000E-03
   -1.32013000E-03  -6.79720000E-04  -2.13861600E-02  -1.35181300E-02  +9.57778000E-03
   -1.17124200E-01  -1.26623060E-01  +6.32373400E-02  +2.26160000E-04  -1.52200000E-05
   -4.99770000E-04  +1.19370000E-04  +1.26200000E-05  +4.90200000E-05  +8.27220000E-04
   +3.10552000E-03  -2.74892000E-03  -1.08900000E-05  -5.87700000E-05  -9.46000000E-06
   +2.74700000E-05  +2.03200000E-05  -1.82300000E-05  -3.90000000E-06  -7.48000000E-06
   -1.53600000E-05  +1.70600000E-05  +1.88200000E-05  +9.93000000E-06  +8.50000000E-07
   +1.61800000E-05  -7.46000000E-06  -2.22000000E-05  +1.93500000E-05  +1.14500000E-05
   -1.88900000E-05  -1.54000000E-05  -3.53000000E-06  -3.75400000E-05  +6.52100000E-05
   -4.49000000E-06  -3.88660000E-04  -5.47140000E-03  +5.63902000E-03  +5.28000000E-06
   +1.51000000E-06  +1.48000000E-06  +1.43000000E-06  -3.00000000E-07  +1.69000000E-06
   +3.68000000E-06  -5.69000000E-06  +2.60000000E-06  +1.12700000E-05  -1.04200000E-05
   +2.24900000E-05  +1.30000000E-06  -2.42000000E-06  +3.37000000E-06  -1.34800000E-05
   -9.88000000E-06  +6.70000000E-07  +5.76000000E-06  -1.71100000E-05  -8.90000000E-07
   +4.06000000E-06  -1.96800000E-05  +1.25500000E-05  -5.85000000E-06  -1.26900000E-05
   -1.65000000E-06  -1.71000000E-06  -2.57600000E-05  -3.90700000E-05  +3.96000000E-06
   -7.37000000E-06  -2.30200000E-05  -8.48800000E-05  -1.37900000E-05  -5.88900000E-05
   -9.13200000E-05  +2.64300000E-04  +3.26340000E-04  +1.24452100E-01  +1.35433680E-01
   +3.11760000E-03  -3.89589000E-03  +1.14145000E-03  -1.97757000E-03  -5.12100000E-04
   +3.24186000E-03  -6.34260000E-04  +1.43757000E-03  -1.75153000E-03  -5.11820000E-04
   -9.21370000E-04  +2.84436000E-03  +1.07496900E-02  -3.93180000E-04  -1.30264000E-03
   +7.86000300E-02  +6.98724600E-02  -6.81499500E-02  +5.07070000E-04  +4.04530000E-04
   +7.46740000E-04  -3.25000000E-04  +2.23440000E-04  -1.45850000E-04  -1.89583000E-03
   +2.81040000E-04  -2.38577000E-03  +7.30700000E-05  +6.34900000E-05  -5.30300000E-05
   +2.46100000E-05  +6.87000000E-06  -3.19100000E-05  -1.89600000E-05  -5.41100000E-05
   -2.50700000E-05  +4.15800000E-05  +6.56800000E-05  +3.41400000E-05  -1.49400000E-05
   +1.75800000E-05  +5.01000000E-06  -6.70900000E-05  -2.29700000E-05  -2.39100000E-05
   -7.88300000E-05  -7.28600000E-05  -8.42000000E-06  -7.39000000E-06  -7.59100000E-05
   +4.83000000E-05  +1.15346000E-03  +4.59485000E-03  +4.28303000E-03  +1.32500000E-05
   +6.72000000E-06  +2.70000000E-07  -7.14000000E-06  -5.47000000E-06  +4.47000000E-06
   +1.65600000E-05  +4.02000000E-06  -6.10000000E-06  +7.08000000E-06  +2.61800000E-05
   +6.06200000E-05  -1.23400000E-05  -9.19000000E-06  -6.90000000E-06  -2.77800000E-05
   -3.78300000E-05  -4.77500000E-05  +2.66200000E-05  +1.97300000E-05  -3.56900000E-05
   +2.09700000E-05  +5.78200000E-05  +2.57100000E-05  +4.05000000E-06  -3.69600000E-05
   -3.98000000E-06  -7.27600000E-05  +1.18100000E-04  +1.04370000E-04  +1.92200000E-05
   -3.16500000E-05  -2.13600000E-05  -1.46110000E-04  -2.10040000E-04  +6.30200000E-05
   +2.73190000E-04  +1.87290000E-04  +2.61180000E-04  -8.87134300E-02  -6.92419700E-02
   +6.19517800E-02  -5.81700300E-02  +1.85970000E-02  -1.25725700E-02  +7.24248000E-03
   -1.75998000E-02  +1.73787400E-02  -2.84629000E-03  +1.56717000E-03  +5.22130000E-03
   -1.10230000E-03  +5.56920000E-04  -2.95720000E-04  -4.73953000E-03  +1.63739000E-03
   -1.79669000E-03  -1.51484000E-03  +2.18071000E-02  -1.66655800E-02  -4.05870000E-04
   -2.00052000E-03  -1.04804000E-03  +2.97850000E-04  -2.04000000E-06  -6.20000000E-06
   +5.30620000E-04  +1.41504000E-03  +2.93170000E-04  -2.42860000E-04  +9.86700000E-05
   -1.87300000E-04  -2.80500000E-05  +8.37000000E-06  -3.77900000E-05  +3.55200000E-05
   +4.24600000E-05  +4.66100000E-05  -6.15900000E-05  -8.11900000E-05  -1.47100000E-05
   +6.00000000E-06  +2.27000000E-06  -3.69200000E-05  +8.51000000E-06  +8.34300000E-05
   +4.89900000E-05  +9.79300000E-05  +8.93000000E-05  -9.10000000E-07  -2.33667000E-03
   +3.40380000E-04  +3.68260000E-04  +7.55830000E-04  -6.57000000E-06  +3.25570000E-04
   -1.30600000E-05  -1.33100000E-05  +8.37000000E-06  +1.63900000E-05  -2.18000000E-06
   +1.18000000E-06  -1.17400000E-05  -1.10600000E-05  +6.51000000E-06  +7.39600000E-05
   -4.14800000E-05  +1.57500000E-05  +7.44000000E-06  +3.65000000E-06  +9.42000000E-06
   -1.12075000E-03  +9.74300000E-05  -5.36570000E-04  +2.91940000E-04  -2.32200000E-05
   +3.51900000E-05  -7.30520000E-04  +1.36431000E-03  -2.11520000E-04  +4.81300000E-05
   -1.53100000E-05  +4.26300000E-05  -1.61200000E-05  -7.17200000E-05  -3.99200000E-05
   +4.98200000E-05  -1.26100000E-05  -1.55630000E-04  +3.03420000E-04  -9.80590000E-04
   +1.13233000E-03  -1.11230000E-04  -2.02710000E-04  -1.39310000E-04  +9.03890000E-04
   -2.74290000E-04  +9.86500000E-05  +6.31090800E-02  +1.24465000E-02  -1.96875630E-01
   +1.47898870E-01  +3.32173000E-03  +3.53350000E-04  +4.91301000E-03  +6.80650000E-04
   +5.02590000E-03  +5.45999000E-03  -2.30770000E-04  -9.01000000E-06  -2.53845000E-03
   +3.06521000E-03  +4.26476000E-03  +2.00950000E-04  +3.85096000E-03  -1.08777100E-02
   +1.04953300E-02  -6.39120000E-04  -3.69942000E-03  -2.38649000E-03  +8.87160000E-04
   -3.48230000E-04  +8.96200000E-05  +8.30500000E-05  -1.96922000E-03  -5.28700000E-05
   -5.17220000E-04  +3.78710000E-04  +2.32880000E-04  -1.07290000E-04  -1.35410000E-04
   -9.42600000E-05  +2.84000000E-06  -2.10000000E-06  +2.09500000E-05  -2.07000000E-06
   +2.14300000E-05  +5.36000000E-06  +2.30000000E-07  -2.94800000E-05  -4.78500000E-05
   -9.54600000E-05  +9.84600000E-05  +1.58580000E-04  -8.60000000E-06  -1.78600000E-05
   -1.27200000E-05  +2.42729000E-03  +5.37900000E-05  -6.12800000E-05  -8.41050000E-04
   +4.55580000E-04  +2.18915000E-03  +3.25000000E-06  -2.74000000E-06  +1.43000000E-06
   -7.26000000E-06  -1.37600000E-05  +1.71000000E-06  +2.59000000E-06  -7.54000000E-06
   -7.00000000E-08  +4.05600000E-05  -7.84900000E-05  +8.63000000E-06  -2.10000000E-06
   -1.22100000E-05  +9.30000000E-06  -4.17270000E-04  -2.98400000E-04  -3.58370000E-04
   +3.09140000E-04  -1.75020000E-04  -5.29250000E-04  +1.75859000E-03  -6.00440000E-04
   +2.15750000E-04  -5.83100000E-05  -2.76300000E-05  +3.19500000E-05  -4.99300000E-05
   -1.75680000E-04  -2.27410000E-04  -1.32500000E-05  +2.48000000E-06  -2.18500000E-05
   +1.35320000E-04  -8.07750000E-04  +6.35260000E-04  -5.07960000E-04  -2.89510000E-04
   -1.18400000E-04  +1.41560000E-04  +2.48510000E-04  -1.35845000E-03  -2.64843400E-02
   +2.05522160E-01  -1.37215400E-02  +1.46758770E-01  -1.77236310E-01  +2.86235000E-03
   +1.68370300E-02  -1.17473600E-02  +4.37674000E-03  +4.51511000E-03  +4.80015000E-03
   -2.66640000E-04  -5.43720000E-04  -2.59354000E-03  +1.07199000E-03  +1.86098000E-03
   +1.18890000E-04  +2.88596000E-03  -1.35693000E-03  +3.87837000E-03  -2.85466000E-03
   -2.13423000E-03  -3.55364000E-03  +1.18466000E-03  -3.41370000E-04  +1.01230000E-04
   +9.69000000E-06  -8.99760000E-04  -1.19680000E-04  -4.60450000E-04  +2.21190000E-04
   +1.65980000E-04  -1.11610000E-04  -1.31200000E-04  -5.52000000E-05  +1.52900000E-05
   -1.17300000E-05  +2.77500000E-05  +1.97400000E-05  +2.84000000E-05  -2.00600000E-05
   -3.90200000E-05  -3.96400000E-05  +3.40000000E-06  -1.23600000E-05  +4.08300000E-05
   +1.63970000E-04  -3.86600000E-05  -4.62600000E-05  -2.71000000E-06  -1.19425000E-03
   +1.07132000E-03  +5.46710000E-04  -7.56030000E-04  +7.84940000E-04  +2.22808000E-03
   +2.14000000E-06  +4.03000000E-06  -6.13000000E-06  -1.12300000E-05  -7.72000000E-06
   -2.00000000E-07  +2.10000000E-07  +4.16000000E-06  -1.94100000E-05  +3.60000000E-05
   +1.80400000E-05  -3.39800000E-05  -7.09000000E-06  -7.30000000E-06  -2.91000000E-06
   -6.01990000E-04  +1.87280000E-04  -4.33500000E-05  -5.52290000E-04  -4.10560000E-04
   +1.84920000E-04  -4.61540000E-04  -6.74020000E-04  +3.66640000E-04  +1.80900000E-05
   -1.18310000E-04  -1.08640000E-04  +2.95800000E-05  -2.75570000E-04  -2.64790000E-04
   -8.83100000E-05  -3.60000000E-06  +9.19500000E-05  +4.77000000E-05  -3.98000000E-05
   +9.62200000E-05  -7.34380000E-04  -2.49120000E-04  -1.94390000E-04  -1.52200000E-05
   -3.72540000E-04  -2.08300000E-04  +8.59323000E-03  -1.64638340E-01  +1.83527220E-01
   +1.11514400E-02  -2.77898000E-03  -2.80320000E-04  -5.65556000E-03  -9.32540000E-04
   +2.39652000E-03  +3.86738000E-03  +2.90970000E-04  -1.17069400E-02  -1.26701500E-02
   -2.61075000E-03  +3.17235500E-02  +1.41746640E-01  -3.76441200E-02  -2.10820000E-03
   -2.39132500E-02  +1.60022200E-02  -3.02709000E-03  -2.12200000E-04  -2.83910000E-04
   +1.03241000E-03  -2.99920000E-04  +2.05690000E-04  -5.03170000E-04  -6.36601000E-03
   +9.26539800E-02  -3.57713000E-02  -9.80300000E-05  +4.30220000E-04  -6.26000000E-05
   -1.65410000E-04  -9.91000000E-05  +3.88500000E-05  +2.91500000E-05  -5.52100000E-05
   +8.39900000E-05  -4.30240000E-04  -1.78480000E-04  +3.02100000E-05  +1.07490000E-04
   -1.51150000E-04  -5.11100000E-05  -1.69190000E-04  -2.43930000E-04  +1.91300000E-04
   +3.30000000E-04  +1.86780000E-04  +2.56100000E-05  +1.71070000E-04  -1.10430000E-04
   +9.47200000E-05  -2.45337000E-02  -2.93809000E-02  -1.28889400E-02  -8.67200000E-05
   -2.64600000E-05  -1.37300000E-05  +1.54600000E-05  -2.53000000E-06  -2.51600000E-05
   -2.15800000E-05  +4.94100000E-05  -7.09100000E-05  -1.01700000E-04  +1.85730000E-04
   -1.94810000E-04  -7.77500000E-05  +9.84000000E-06  -6.58600000E-05  +2.39000000E-05
   +2.37600000E-05  -4.89200000E-05  -6.95000000E-06  -5.03300000E-05  +2.12400000E-05
   -5.70400000E-05  -6.89200000E-05  -9.94000000E-06  -5.13600000E-05  -1.02650000E-04
   -1.15700000E-05  -4.54100000E-05  +3.60100000E-05  +3.00140000E-04  -7.72300000E-05
   +2.17500000E-05  +2.81320000E-04  +5.01630000E-04  -1.97009000E-03  +2.54600000E-05
   +1.98405000E-03  +4.82600000E-04  -1.60238000E-03  -4.04860000E-04  -3.42930000E-03
   -2.35450000E-04  -3.27370000E-04  +8.25390000E-04  +7.73910000E-04  -8.41566000E-02
   +3.14380000E-04  -2.58300000E-04  +4.12650000E-04  -2.72950000E-04  -3.25670000E-04
   +3.68930000E-04  -6.39750000E-04  +1.06338000E-03  +2.41850000E-04  +2.68510000E-04
   -5.19901000E-03  -3.80776000E-03  -1.76147500E-02  -7.16308000E-02  +3.50991900E-02
   +1.63786000E-03  +5.77320000E-04  -5.47560000E-04  +2.36750000E-04  -1.46830000E-04
   +8.08100000E-05  -1.42550000E-04  +3.55000000E-05  -3.35700000E-05  -6.25971000E-03
   -2.93520300E-02  +2.55151000E-03  -3.77600000E-05  +1.87650000E-04  -4.42900000E-05
   +5.32000000E-05  -1.99100000E-05  -8.69500000E-05  -4.98200000E-05  -1.27340000E-04
   -4.67900000E-05  +1.99890000E-04  +2.19570000E-04  +5.85600000E-05  -4.73200000E-05
   +4.30000000E-05  +8.07700000E-05  -1.76200000E-05  +9.30000000E-06  -3.62700000E-05
   -2.67120000E-04  -2.50020000E-04  -7.66000000E-06  -1.26580000E-04  +2.09700000E-05
   +1.75100000E-05  +5.45179100E-02  -4.59696500E-02  +9.69955000E-03  +3.70600000E-05
   +3.30100000E-05  -1.26000000E-05  -3.05800000E-05  -9.41000000E-06  +8.55000000E-06
   +2.51700000E-05  +5.78000000E-06  -4.99000000E-06  +5.60900000E-05  +4.83100000E-05
   +8.57500000E-05  -2.44300000E-05  -9.79000000E-06  -3.12300000E-05  +3.08000000E-05
   -9.30000000E-07  +8.79000000E-06  -5.06000000E-05  +4.82200000E-05  -1.92700000E-05
   +1.05400000E-05  -4.42000000E-05  +1.17400000E-05  +1.08800000E-05  -4.35400000E-05
   -1.87300000E-05  -5.57600000E-05  +7.57500000E-05  +2.02200000E-05  +3.50700000E-05
   -2.08900000E-05  -3.17200000E-05  +4.97320000E-04  +3.52540000E-04  +4.05660000E-04
   -5.85850000E-04  +8.63710000E-04  +7.83510000E-04  -5.35790000E-04  -1.00760000E-04
   -5.07410000E-04  +1.12070000E-04  +2.81000000E-05  -3.03600000E-05  -3.12845700E-02
   +1.49896970E-01  -4.11670000E-04  +5.12180000E-04  +7.99050000E-04  +6.51420000E-04
   -2.65200000E-05  -1.71740000E-04  +1.31498000E-03  -4.05940000E-04  -2.84938000E-03
   +1.21694300E-02  -1.66860100E-02  +4.79960000E-03  -9.87308000E-03  +3.41850500E-02
   +4.97455000E-03  +2.14321000E-03  -8.00010000E-04  +8.64300000E-04  -5.71900000E-05
   -2.44000000E-05  -2.02120000E-04  +1.22650000E-04  -6.04600000E-05  +6.62600000E-05
   -2.55070000E-03  -1.09749300E-02  -2.21968400E-02  -1.27800000E-05  -6.31900000E-05
   -7.28000000E-06  +1.78600000E-05  +1.07200000E-05  -9.23000000E-06  +1.66000000E-06
   +1.34400000E-05  -1.35200000E-05  +2.52000000E-06  -9.82000000E-06  +5.68000000E-06
   +3.79000000E-06  +3.27100000E-05  +6.21000000E-06  +1.29000000E-06  +2.94700000E-05
   -3.00600000E-05  +3.07000000E-06  +1.15400000E-05  -1.05700000E-05  +1.82000000E-06
   +2.06100000E-05  -1.19200000E-05  -3.64402600E-02  +3.92989200E-02  -5.27356900E-02
   +4.27000000E-06  -4.44000000E-06  +8.41000000E-06  +6.79000000E-06  -1.25000000E-06
   +1.35000000E-06  -1.57000000E-06  -8.94000000E-06  +9.39000000E-06  +3.16900000E-05
   -1.79400000E-05  +4.06600000E-05  -3.73000000E-06  -3.76000000E-06  +6.75000000E-06
   -6.44000000E-06  -3.48000000E-06  +1.23000000E-06  +6.25000000E-06  -4.35000000E-06
   +3.40000000E-07  +2.50000000E-06  +9.30000000E-06  -1.16000000E-06  +5.00000000E-07
   +1.11300000E-05  +1.38100000E-05  +1.54400000E-05  -3.77600000E-05  -4.00400000E-05
   +3.34000000E-06  +1.01000000E-05  -2.25000000E-06  +3.53910000E-04  -6.25710000E-04
   +8.64500000E-05  +6.97330000E-04  +2.78050000E-04  +6.24870000E-04  +2.30900000E-05
   +1.26700000E-04  -6.08120000E-04  +1.19490000E-04  -1.22670000E-04  -9.08700000E-05
   +3.16591500E-02  -4.46683500E-02  +6.66718700E-02
end_hess

