# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -882.63622680    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +1.67706751E+00  +1.49080239E-01  +1.85826226E+00
   006   +1.00852776E+00  +2.07037424E+00  -4.24614194E-03
   006   +2.74295052E+00  +2.83205859E+00  -1.69327012E+00
   006   +5.21280367E+00  +1.60218892E+00  -1.89559365E+00
   006   +5.88424226E+00  -3.38773347E-01  +5.25269001E-02
   006   +3.96241347E+00  -9.11706183E-01  +1.97611503E+00
   006   -1.62276280E+00  +3.23110828E+00  +2.19134604E-01
   006   -1.72909391E+00  +4.72875403E+00  +2.70595749E+00
   008   +8.34675005E+00  -5.41954811E-01  +6.96466195E-01
   006   -3.56749885E+00  +1.08892230E+00  +1.30736995E-01
   006   -3.39363838E+00  -7.34710655E-01  -1.75855071E+00
   006   -5.14243251E+00  -2.66541360E+00  -1.96572517E+00
   006   -7.13444195E+00  -2.81755923E+00  -2.61197872E-01
   006   -7.34141043E+00  -1.02549604E+00  +1.63738729E+00
   006   -5.57130586E+00  +8.95920791E-01  +1.81871218E+00
   008   -8.90737733E+00  -4.67033365E+00  -3.63156156E-01
   006   -2.20969473E+00  +5.06741751E+00  -1.94740049E+00
   008   +5.27912928E+00  -1.03623913E+00  -2.45145092E+00
   001   -8.54696688E+00  -5.78384721E+00  -1.74139578E+00
   001   -4.94863165E+00  -4.06451958E+00  -3.44954568E+00
   001   -1.83802339E+00  -6.66837362E-01  -3.08720203E+00
   001   -5.78487136E+00  +2.25790688E+00  +3.32601065E+00
   001   -8.88902620E+00  -1.15545629E+00  +2.96530351E+00
   001   -4.14531474E+00  +5.74480685E+00  -1.75829749E+00
   001   -9.58983271E-01  +6.70645257E+00  -1.90768034E+00
   001   -2.03839861E+00  +4.15166190E+00  -3.78429555E+00
   001   -1.48342951E+00  +3.52442590E+00  +4.35814693E+00
   001   -2.28706169E-01  +6.13972938E+00  +2.71842402E+00
   001   -3.52626503E+00  +5.71894217E+00  +2.89287030E+00
   001   +2.39031062E+00  +4.41098713E+00  -2.93957096E+00
   001   +6.74913967E+00  +2.64157231E+00  -2.76502074E+00
   001   +4.48187273E+00  -2.19915014E+00  +3.47729456E+00
   001   +2.68070704E-01  -3.54650826E-01  +3.25219039E+00
   001   +8.77684037E+00  -2.34701365E+00  +1.38852926E+00
   008   +8.88062602E+00  -4.85867510E+00  +1.30693088E+00
   001   +8.98089678E+00  -5.28441527E+00  -4.64131782E-01
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -1.70000000E-07  +1.00000000E-07  +5.00000000E-08
   +0.00000000E+00  -2.10000000E-07  +7.00000000E-08
   +9.90000000E-07  -1.26000000E-06  +3.10000000E-07
   -1.30000000E-07  -1.23000000E-06  +1.50000000E-07
   -3.90000000E-07  -1.30000000E-06  +3.20000000E-07
   -6.00000000E-07  +2.10000000E-07  +1.20000000E-07
   +8.60000000E-07  +2.40000000E-07  -4.70000000E-07
   -1.40000000E-07  +8.40000000E-07  -5.30000000E-07
   +1.70000000E-07  -2.20000000E-07  +4.70000000E-07
   -3.00000000E-07  +1.80000000E-07  +0.00000000E+00
   +9.00000000E-08  -2.00000000E-08  -3.30000000E-07
   -1.50000000E-07  +3.10000000E-07  -1.90000000E-07
   -3.30000000E-07  +8.20000000E-07  +5.70000000E-07
   -1.40000000E-07  +7.90000000E-07  -7.50000000E-07
   -2.20000000E-07  +7.70000000E-07  -5.80000000E-07
   -7.30000000E-07  +1.49000000E-06  +6.40000000E-07
   +5.10000000E-07  -3.70000000E-07  -4.80000000E-07
   +1.40000000E-07  -6.60000000E-07  +1.02000000E-06
   -5.60000000E-07  +3.70000000E-07  -6.00000000E-08
   -3.40000000E-07  +2.20000000E-07  +5.50000000E-07
   -1.20000000E-07  -3.40000000E-07  +2.20000000E-07
   +6.00000000E-08  +1.20000000E-06  -4.40000000E-07
   -5.60000000E-07  +1.49000000E-06  -8.00000000E-08
   +6.20000000E-07  +2.90000000E-07  -9.30000000E-07
   +1.06000000E-06  +7.00000000E-08  -9.40000000E-07
   +7.50000000E-07  -4.10000000E-07  -8.80000000E-07
   +5.00000000E-08  +6.50000000E-07  -4.80000000E-07
   +7.00000000E-07  +4.50000000E-07  -8.40000000E-07
   +6.80000000E-07  +5.80000000E-07  -9.20000000E-07
   +5.20000000E-07  -3.30000000E-07  -6.90000000E-07
   +5.00000000E-07  -1.14000000E-06  +1.00000000E-07
   -4.20000000E-07  -4.10000000E-07  +1.00000000E-06
   -2.30000000E-07  +3.90000000E-07  +9.00000000E-08
   -5.70000000E-07  -1.89000000E-06  +1.16000000E-06
   -7.90000000E-07  -8.70000000E-07  +1.34000000E-06
   -7.90000000E-07  -7.90000000E-07  +1.43000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +7.76557320E-01  -1.70155350E-01  +3.75526130E-01  -1.36351090E-01  -1.96158490E-01
   +4.49788840E-01  -1.11171670E-01  +3.94482000E-02  -1.93959600E-02  +6.18469700E-01
   +1.66881100E-02  -1.44704340E-01  +7.96569100E-02  -3.06228900E-02  +3.90264940E-01
   +6.79413000E-03  +6.55194200E-02  -1.52983500E-01  -1.88837880E-01  -1.99550370E-01
   +5.12054280E-01  +2.64684200E-02  -1.91325400E-02  +1.29275000E-02  -2.76855070E-01
   -4.66859900E-02  +1.66885880E-01  +5.95031290E-01  -1.57268400E-02  -6.81630000E-03
   +2.41763000E-02  -6.69840300E-02  -1.29819060E-01  +1.02410330E-01  -6.66786000E-02
   +4.85731950E-01  +5.15268000E-03  +2.92052700E-02  -2.44394000E-02  +1.82203590E-01
   +9.16685200E-02  -2.51454640E-01  -1.89264220E-01  -2.76845820E-01  +4.98744370E-01
   -1.34739500E-02  +9.31519000E-03  -9.35538000E-03  -3.66473700E-02  -8.46797000E-03
   +2.40536400E-02  -2.13423240E-01  +6.51349100E-02  +8.41525000E-03  +5.84861540E-01
   +8.94743000E-03  -1.17345600E-02  +6.16677000E-03  +1.32911000E-03  +2.48366000E-02
   -1.96338100E-02  +3.71174600E-02  -1.09701800E-01  +2.03737700E-02  +2.38917200E-02
   +5.25228100E-01  -1.08220700E-02  +3.30586000E-03  -1.01343700E-02  +1.67578200E-02
   -2.14760600E-02  +1.13300600E-02  +3.32046200E-02  +4.63952000E-03  -8.28589200E-02
   -1.26522910E-01  -1.42941680E-01  +3.12441100E-01  -3.04607700E-02  +1.77931000E-03
   +1.25782200E-02  +1.22294000E-03  -4.38087000E-03  +2.24792000E-03  -8.60853000E-03
   +7.01076000E-03  -2.49863300E-02  -4.51339600E-02  +3.16428300E-02  +5.71650000E-03
   +5.63362770E-01  -2.80232000E-03  +1.81126100E-02  -2.11241500E-02  -1.05289200E-02
   -1.80007900E-02  +9.93045000E-03  +3.30189200E-02  -1.87723700E-02  +4.17333000E-03
   -1.18207900E-02  -8.13917300E-02  +4.90846500E-02  -2.06230200E-02  +2.98194000E-01
   +2.01784900E-02  -1.35026800E-02  +1.66935100E-02  +4.08086000E-03  +9.41776000E-03
   -1.33903100E-02  -1.60200000E-02  +4.71462000E-03  +9.22250000E-04  -6.29374000E-03
   +1.37638310E-01  -7.52837100E-02  -3.54938900E-02  -1.02182780E-01  +5.08275470E-01
   -4.40589500E-01  +1.57575600E-01  +1.01834000E-02  -1.83739000E-03  +3.05850500E-02
   -3.03028400E-02  -1.85496300E-02  +5.03260000E-04  +1.08790300E-02  +1.80566200E-02
   -9.70021000E-03  +1.19737200E-02  -1.44723570E-01  -4.80719000E-03  +5.86716000E-02
   +7.23345430E-01  +1.71850920E-01  -1.53960110E-01  +2.92629000E-02  +2.31834600E-02
   -1.28755200E-02  +1.34353200E-02  +2.77332000E-03  +1.53093000E-03  -2.05934000E-03
   -1.27255700E-02  -9.49534000E-03  +2.22945600E-02  -2.67157400E-02  -8.83200600E-02
   +3.77168100E-02  -2.21415790E-01  +3.97472570E-01  -1.22765800E-02  +3.82702600E-02
   -1.03200510E-01  -2.34905900E-02  +7.51888000E-03  +9.43601000E-03  +5.70026000E-03
   +6.44210000E-04  -2.30643000E-03  -3.06541000E-03  +6.95151000E-03  -2.12168700E-02
   +8.53571100E-02  +3.21904900E-02  -1.51263600E-01  -2.84647100E-02  -2.30241420E-01
   +4.95545160E-01  -8.31937000E-03  +8.34833000E-03  -4.99746000E-03  -1.58185160E-01
   +3.54855200E-02  +8.60241000E-03  -1.91379800E-02  +8.12896000E-03  +6.94624000E-03
   +8.33320000E-04  +1.14311000E-03  +2.68152000E-03  -2.01700000E-04  -6.67540000E-04
   +7.85660000E-04  +2.08953000E-03  -6.68270000E-04  +1.09644000E-03  +4.76155030E-01
   +2.20706800E-02  -9.82235000E-03  -1.38081000E-03  +3.72397100E-02  -9.65753600E-02
   +4.18529000E-03  -4.08348000E-03  +1.09640900E-02  -1.33786000E-03  +1.25540000E-03
   +3.93264000E-03  +6.92571000E-03  +5.58330000E-04  -3.88080000E-04  -6.76100000E-05
   -2.05220000E-04  -1.31685000E-03  +3.75460000E-03  -6.86222000E-03  +4.82434200E-01
   -1.99600800E-02  +8.78913000E-03  +5.41530000E-03  +4.03430000E-03  +5.67213000E-03
   -8.15494800E-02  +2.12189600E-02  -8.16035000E-03  +1.70120000E-03  +3.70931000E-03
   +7.19099000E-03  +2.23698000E-03  +1.98042000E-03  +4.86710000E-04  -1.12324000E-03
   -4.87870000E-04  +3.59365000E-03  -2.94534000E-03  +6.06900000E-05  -2.73741000E-03
   +4.81792180E-01  -8.57370000E-04  +1.09554000E-03  +1.12760000E-04  -5.18171000E-03
   +1.66257500E-02  +2.89180400E-02  -3.47678000E-03  +1.77051000E-03  -5.47790000E-04
   -3.62660000E-04  -2.29936000E-03  -1.18713000E-03  -8.83140000E-04  -1.85500000E-04
   +2.31830000E-04  +5.00360000E-04  -2.50670000E-04  +8.83200000E-05  -7.58680100E-02
   +5.07061000E-03  +7.08607000E-03  +5.85084500E-01  +6.28000000E-04  -4.17650000E-04
   -8.67400000E-05  +7.10573000E-03  -1.05496100E-02  -1.49794300E-02  -7.78950000E-04
   -1.03703000E-03  +6.16580000E-04  +2.88520000E-04  +5.03250000E-04  +6.31410000E-04
   +3.65120000E-04  +2.75630000E-04  -2.64590000E-04  -3.67130000E-04  +3.00250000E-04
   -1.08160000E-04  +8.75950000E-04  -1.01047750E-01  -4.38624900E-02  +1.87415000E-03
   +5.49343200E-01  -1.36472000E-03  +1.78830000E-04  +3.35270000E-04  +1.11259000E-02
   -8.02092000E-03  -6.07182000E-03  -2.16608000E-03  -4.09700000E-04  +6.00640000E-04
   +6.07300000E-04  -3.75950000E-04  +2.77510000E-04  -4.56020000E-04  +6.48700000E-05
   +4.43260000E-04  +3.64280000E-04  +2.51990000E-04  -5.52850000E-04  +3.88900000E-05
   -4.00087700E-02  -1.45835680E-01  +6.89700000E-04  -6.11052200E-02  +5.01658220E-01
   -1.13181000E-03  -4.93144000E-03  +9.84081000E-03  -1.93123000E-03  -8.30750000E-04
   +1.14989000E-03  +4.54917000E-03  -2.55600000E-04  +1.44354000E-03  -2.42146300E-02
   +9.43330000E-03  -3.67370400E-02  -2.58124200E-01  -2.42812900E-02  +3.66056000E-03
   -5.09629100E-02  +1.15319500E-02  -1.28664700E-02  -1.53120000E-04  -1.59630000E-04
   -1.06035000E-03  +6.00110000E-04  -2.20510000E-04  +4.48720000E-04  +3.67898630E-01
   -1.87954000E-03  +1.28950000E-03  +2.71140000E-04  +2.59018000E-03  -2.28140000E-04
   -1.49263000E-03  -3.66132000E-03  +1.95285000E-03  +9.90960000E-04  +3.79382900E-02
   -9.26287000E-03  +2.86397100E-02  -3.79005000E-03  -5.87688800E-02  -7.61150000E-04
   -4.66720000E-04  +4.58189000E-03  -3.92519000E-03  +4.95720000E-04  +1.21500000E-05
   +6.86490000E-04  -7.40980000E-04  +1.41310000E-04  -3.64650000E-04  -1.38104700E-02
   +2.66748220E-01  +3.16412000E-03  +1.61765000E-03  -2.07930000E-03  -1.55385000E-03
   +1.49404000E-03  -4.67660000E-04  +7.35320000E-04  -1.08199000E-03  +3.04347000E-03
   -1.61158900E-02  -8.82410000E-04  -2.37315800E-02  -3.38894100E-02  -1.98760000E-03
   -6.13493800E-02  +1.84959000E-02  -1.77800000E-04  +1.25530600E-02  -4.45050000E-04
   -1.99040000E-04  -1.52840000E-04  +2.74890000E-04  -1.64200000E-05  +1.10000000E-06
   +7.99864600E-02  -7.85661100E-02  +1.23293160E-01  -1.28150000E-03  -4.84600000E-04
   -1.21976000E-03  -3.44402500E-02  -2.18203700E-02  +3.02044000E-03  -1.26585000E-03
   +1.85742000E-03  -1.51072000E-03  +3.05090000E-04  +1.43381000E-03  +1.49019000E-03
   +1.28800000E-04  -2.36800000E-05  +4.80540000E-04  +4.56750000E-04  -7.13490000E-04
   +3.53070000E-04  -1.20747930E-01  -4.87305500E-02  +3.74071000E-03  +1.58710000E-03
   -2.43875000E-03  -4.37278000E-03  +6.64700000E-05  -1.89240000E-04  -5.96000000E-06
   +5.04629470E-01  +2.61948000E-03  +3.75850000E-04  +4.04110000E-04  -1.50016000E-03
   +1.16814700E-02  +1.08812000E-03  +2.40427000E-03  -2.40489000E-03  -6.94880000E-04
   -5.31050000E-04  +2.51780000E-04  -1.03338000E-03  +2.97480000E-04  +1.86520000E-04
   +5.85900000E-05  -2.52040000E-04  -2.51400000E-04  +4.35310000E-04  -4.53644700E-02
   -1.27454040E-01  -1.08199400E-02  -1.26607000E-02  -1.72554000E-02  -3.78103000E-03
   -3.77270000E-04  +4.96680000E-04  -2.68960000E-04  +1.31319770E-01  +4.86431200E-01
   -1.85834000E-03  +8.17000000E-06  -2.21140000E-04  +4.12589000E-03  +4.22716000E-03
   -7.30800000E-04  +3.89720000E-04  -1.08299000E-03  +1.08480000E-04  -3.92600000E-05
   -3.10820000E-04  -6.05820000E-04  -1.11760000E-04  +6.06500000E-05  -1.31800000E-05
   -4.78000000E-06  -2.09850000E-04  +7.65800000E-05  +6.99758000E-03  -7.47731000E-03
   -8.19023100E-02  -2.11949600E-02  -2.30443800E-02  -1.17915000E-03  +3.55400000E-05
   +1.77200000E-05  +7.19100000E-05  -1.76496600E-01  +1.57203890E-01  +4.97726720E-01
   -1.04374000E-03  +9.90100000E-05  -8.50420000E-04  -4.34840000E-04  -2.79934000E-03
   -1.67383000E-03  +2.41430000E-04  -3.17940000E-04  -3.25380000E-04  -1.37990000E-04
   +6.40700000E-05  -2.87020000E-04  -5.01700000E-05  -2.31990000E-04  +2.37800000E-05
   +3.00080000E-04  -2.36830000E-04  -1.45940000E-04  +2.38216000E-03  -1.58471300E-02
   -1.74499200E-02  -3.58476000E-03  -3.77270000E-03  +7.49840000E-04  +8.58600000E-05
   -4.84000000E-05  +1.20670000E-04  -1.12086940E-01  +1.28863900E-02  +5.23360900E-02
   +5.63600980E-01  -1.41400000E-05  -1.55600000E-04  +7.13120000E-04  +2.59650000E-04
   -1.29702000E-03  -6.41520000E-04  +7.07800000E-05  -7.76000000E-06  -6.48590000E-04
   +1.91650000E-04  -2.20540000E-04  -7.36300000E-05  -8.61100000E-05  -1.82940000E-04
   -7.41000000E-06  +1.75150000E-04  +1.97980000E-04  -2.72760000E-04  -4.28020000E-03
   -1.95515800E-02  -1.67054600E-02  -2.90853000E-03  -1.81398000E-03  +1.00771000E-03
   +9.09400000E-05  +2.06100000E-05  -4.10900000E-05  -2.88887000E-02  -1.99312340E-01
   -9.36296700E-02  +1.83236130E-01  +5.12404300E-01  -4.77370000E-04  -4.12280000E-04
   +7.32100000E-05  -5.23780000E-04  -7.56360000E-04  +8.49540000E-04  +3.82970000E-04
   -1.49350000E-04  -1.11740000E-03  +8.06600000E-05  -1.32400000E-05  -5.41300000E-05
   +3.21600000E-05  +1.33050000E-04  +3.58810000E-04  +2.40920000E-04  -8.99400000E-05
   -1.40590000E-04  -5.31075000E-03  -3.54094000E-03  +3.14289000E-03  +9.27710000E-04
   +5.22570000E-04  -3.55300000E-05  +4.07100000E-05  -1.84410000E-04  -4.76200000E-05
   +1.05859400E-02  -1.32851020E-01  -2.05758930E-01  -2.08954360E-01  +1.77099420E-01
   +5.00851090E-01  +2.18070000E-04  -3.22800000E-05  +1.18820000E-04  -4.02800000E-05
   -2.49000000E-06  -2.69510000E-04  -3.84270000E-04  +7.19300000E-05  -1.18180000E-04
   +3.30190000E-04  -2.25650000E-04  +2.05320000E-04  +2.54000000E-06  +2.06820000E-04
   -1.72670000E-04  -1.71480000E-04  +6.93100000E-05  +1.55110000E-04  +3.78550000E-03
   +5.55600000E-04  +2.65540000E-03  +4.42640000E-04  +4.79130000E-04  +4.29790000E-04
   +4.60000000E-05  -1.93140000E-04  +1.13240000E-04  +3.39783400E-02  -3.36376700E-02
   -5.78019600E-02  -2.09911730E-01  -1.13014980E-01  +3.24790900E-02  +5.15460530E-01
   +1.86930000E-04  +7.36500000E-05  +9.19200000E-05  +6.12230000E-04  -1.01150000E-04
   -9.67900000E-05  -2.77610000E-04  +3.53790000E-04  +3.97100000E-04  -5.72400000E-05
   -1.61220000E-04  +7.10400000E-05  -1.01720000E-04  +6.88000000E-06  -1.06720000E-04
   -2.11980000E-04  +2.08270000E-04  +1.77430000E-04  +7.24600000E-04  +1.57884000E-03
   -5.06598000E-03  -9.41620000E-04  -6.91040000E-04  +3.13900000E-04  +1.60000000E-06
   +6.20700000E-05  -1.90200000E-05  -9.53440000E-04  -3.69947900E-02  -4.24721800E-02
   -1.55894950E-01  -2.31289690E-01  -1.72553500E-02  +1.84305290E-01  +5.46112740E-01
   -8.68000000E-05  +1.42740000E-04  -9.69700000E-05  +6.83500000E-04  +3.19060000E-04
   -4.30000000E-06  +1.55520000E-04  -2.83800000E-05  +3.05090000E-04  -2.68890000E-04
   +1.33430000E-04  -1.86050000E-04  -4.05000000E-06  -2.05810000E-04  +1.10660000E-04
   +1.44480000E-04  -5.12300000E-05  -5.88700000E-05  +2.38999000E-03  -3.88330000E-03
   -1.59511000E-03  -6.27970000E-04  -7.60360000E-04  +7.10500000E-05  -8.25800000E-05
   +2.20230000E-04  -1.16330000E-04  -2.46300200E-02  -1.17966100E-02  +2.12119300E-02
   -8.51567000E-03  -5.69425200E-02  -1.06223010E-01  -1.85336360E-01  +2.23885250E-01
   +5.07744940E-01  +5.95300000E-05  -5.47500000E-05  +2.02180000E-04  -3.96870000E-04
   +2.06310000E-04  +3.36180000E-04  +5.22170000E-04  -1.82640000E-04  -7.38600000E-05
   -3.92560000E-04  +2.48370000E-04  -3.23230000E-04  -1.02810000E-04  -3.63780000E-04
   +3.36180000E-04  +9.35100000E-05  +1.46370000E-04  -7.97300000E-05  -2.14747000E-03
   -6.19280000E-04  +2.13430000E-04  +4.13370000E-04  -1.32740000E-04  -2.75010000E-04
   -1.22280000E-04  +5.10370000E-04  -3.59710000E-04  -1.90808300E-02  +2.04951400E-02
   +3.27697100E-02  -4.12701300E-02  -4.76132300E-02  -5.10949000E-03  -2.12971080E-01
   +6.99563000E-03  +1.39447060E-01  +5.34825400E-01  +2.25620000E-04  -8.26600000E-05
   +1.97370000E-04  -6.14190000E-04  +9.46330000E-04  +2.18760000E-04  +5.11580000E-04
   -9.20000000E-05  -1.73900000E-05  -4.95310000E-04  +1.60260000E-04  -3.39440000E-04
   +4.10000000E-06  -2.76010000E-04  +3.03900000E-04  -1.08410000E-04  +1.66850000E-04
   +1.73030000E-04  -1.47220000E-04  -8.97780000E-04  -9.25480000E-04  +2.96350000E-04
   +1.01910000E-04  -8.56200000E-05  -2.81920000E-04  +6.79550000E-04  -4.62710000E-04
   +2.01480400E-02  -1.22861200E-02  -2.42165200E-02  -1.10487900E-02  +2.59133700E-02
   +3.26844900E-02  -4.51010100E-02  -1.14325110E-01  -3.83130000E-04  +1.72040540E-01
   +5.44655590E-01  +2.06950000E-04  +3.14100000E-05  +1.32750000E-04  -8.45900000E-05
   +4.61090000E-04  -1.37620000E-04  -1.18860000E-04  +7.88400000E-05  +8.07700000E-05
   -3.76000000E-05  -7.97300000E-05  +4.39900000E-05  +3.86300000E-05  +5.86000000E-05
   -2.25600000E-05  -2.10590000E-04  +1.06020000E-04  +1.98120000E-04  +1.05510000E-03
   -4.46600000E-05  -1.52860000E-03  +6.62600000E-05  -5.64300000E-05  +2.89080000E-04
   -1.19760000E-04  +1.80000000E-04  -1.30380000E-04  +3.17324200E-02  -2.46794600E-02
   -5.93725300E-02  +3.01480000E-02  +6.60362200E-02  +3.79931200E-02  +9.09926300E-02
   -4.86372700E-02  -1.99332370E-01  -1.82340320E-01  +2.00627950E-01  +5.23439020E-01
   -5.44300000E-05  -6.16600000E-05  +8.69700000E-05  +2.01170000E-04  -4.36660000E-04
   +1.08330000E-04  -3.54700000E-05  -1.11000000E-05  -1.19050000E-04  +1.08270000E-04
   +3.91200000E-05  +7.03900000E-05  +6.65000000E-06  +2.56700000E-05  +3.46900000E-05
   +8.95800000E-05  +1.04000000E-05  -1.69040000E-04  +6.23860000E-04  -1.91110000E-04
   +4.60333000E-03  +2.11590000E-04  +6.82280000E-04  +2.17030000E-04  +7.44400000E-05
   -1.32760000E-04  +4.82200000E-05  -3.69518600E-02  -1.23158700E-02  +2.98373800E-02
   -1.01804000E-02  -2.02763700E-02  -1.29706000E-02  +2.01044700E-02  +2.47184800E-02
   +1.25585900E-02  -1.16522990E-01  +2.60111400E-02  +6.70655800E-02  +5.61372230E-01
   -4.35290000E-04  -1.32900000E-04  +6.59800000E-05  -1.20550000E-04  -1.22025000E-03
   +5.81800000E-05  -1.77020000E-04  +6.01300000E-05  -1.91690000E-04  +2.25240000E-04
   +4.29800000E-05  +1.35850000E-04  -9.85800000E-05  +8.18000000E-06  +4.11900000E-05
   +2.75660000E-04  -7.17400000E-05  -3.08270000E-04  -1.07195000E-03  +3.18907000E-03
   -1.70843000E-03  -2.51470000E-04  -4.07410000E-04  +7.60000000E-06  +2.25050000E-04
   -3.48110000E-04  +1.94120000E-04  -4.47692200E-02  +2.36332500E-02  +5.61828000E-02
   -1.83859600E-02  -5.15242900E-02  -2.96237000E-02  +5.39737400E-02  +3.23874200E-02
   -2.76998200E-02  -2.24166000E-02  -1.92173900E-01  -9.34266700E-02  +1.93289640E-01
   +5.15934740E-01  +1.79800000E-05  +1.05710000E-04  -2.13480000E-04  +8.18350000E-04
   +8.81600000E-04  -1.68740000E-04  +1.66450000E-04  -2.18410000E-04  +6.40400000E-05
   +2.72300000E-05  -6.15700000E-05  -1.25760000E-04  -4.44000000E-06  +3.08500000E-05
   -9.28000000E-05  +5.34000000E-05  -7.13500000E-05  -2.80100000E-05  +4.88475000E-03
   -3.00641000E-03  +3.64950000E-04  -6.19350000E-04  -8.59230000E-04  -2.19350000E-04
   +5.05000000E-05  -1.31180000E-04  +1.33770000E-04  -1.27125000E-03  +2.70170300E-02
   +3.32530300E-02  -1.10131300E-02  -2.73042200E-02  -1.94143000E-02  +4.06049600E-02
   -3.54610000E-04  -2.95392200E-02  +2.08689200E-02  -1.39068390E-01  -2.22963700E-01
   -2.19564130E-01  +1.87434180E-01  +5.13700750E-01  +4.23490000E-04  +3.44000000E-05
   +3.58940000E-04  -1.05183000E-03  -1.69228000E-03  +1.54040000E-04  -5.49140000E-04
   +5.75770000E-04  +1.55530000E-04  +8.31400000E-05  -1.23770000E-04  +2.34090000E-04
   -5.25000000E-05  -6.73400000E-05  -1.39030000E-04  -1.48440000E-04  +1.67860000E-04
   +1.51560000E-04  -1.52402100E-02  -5.63346000E-03  +9.97669000E-03  -1.40045000E-03
   -8.63960000E-04  +1.16206000E-03  -2.78900000E-05  +1.18190000E-04  -6.71500000E-05
   -2.22557340E-01  -5.19863200E-02  +9.66159500E-02  +1.91111200E-02  +5.88816200E-02
   +4.73600300E-02  -5.27791100E-02  -2.80723200E-02  +1.88737600E-02  +3.82586500E-02
   -3.45908800E-02  -6.67989400E-02  -2.10210000E-01  -1.09948120E-01  +3.45389700E-02
   +5.11592940E-01  +3.21590000E-04  +5.66400000E-05  +3.11150000E-04  -6.55380000E-04
   -3.32390000E-03  +4.18380000E-04  -1.01777000E-03  +7.93680000E-04  +7.94400000E-05
   +2.12790000E-04  -2.37230000E-04  +3.98430000E-04  +4.94000000E-06  +3.34000000E-05
   -1.67640000E-04  -2.39330000E-04  +2.45430000E-04  -2.35800000E-05  -1.86619900E-02
   +1.25651000E-03  +1.49408300E-02  -1.23260000E-03  -9.77010000E-04  +9.27030000E-04
   +5.53600000E-05  -2.84100000E-05  +4.88000000E-06  -9.42358000E-03  -1.11865850E-01
   -3.29176700E-02  +2.59982500E-02  +3.16205100E-02  -1.53867000E-03  -2.53124600E-02
   -1.75952500E-02  +1.02546100E-02  +1.70145000E-03  -4.08797800E-02  -4.26466600E-02
   -1.53191130E-01  -2.27055190E-01  -1.54457000E-02  +1.71793460E-01  +5.40237680E-01
   -4.87650000E-04  -6.77400000E-05  -6.58700000E-04  -1.50569000E-03  -1.70648000E-03
   -2.15910000E-04  -3.04420000E-04  +1.65420000E-04  +2.51850000E-04  +1.73100000E-04
   +1.55780000E-04  +2.23010000E-04  -3.38400000E-05  +3.92200000E-05  -5.68900000E-05
   +1.34670000E-04  -2.14680000E-04  +1.25000000E-06  -4.61320000E-04  +3.65000000E-03
   +5.16125000E-03  -9.02840000E-04  +5.59390000E-04  +2.61690000E-04  +9.88800000E-05
   -2.45830000E-04  +1.87010000E-04  +1.36967400E-01  +5.20106000E-03  -1.90072550E-01
   +1.56290200E-02  -3.17834900E-02  -3.62987000E-02  +2.06595200E-02  +1.23253600E-02
   -1.11663600E-02  -3.13864100E-02  -9.04226000E-03  +2.28045600E-02  -6.32791000E-03
   -5.50447000E-02  -1.07210710E-01  -1.81277250E-01  +2.18371810E-01  +5.22294220E-01
   -1.93260000E-04  +2.76000000E-05  -1.43390000E-04  +5.46820000E-04  -7.80560000E-04
   -2.95460000E-04  -5.65610000E-04  +1.62640000E-04  -9.15700000E-05  +5.32410000E-04
   -2.42970000E-04  +3.50410000E-04  +4.57200000E-05  +3.36360000E-04  -3.23820000E-04
   +9.46000000E-06  -1.35060000E-04  -7.67500000E-05  +1.14336000E-03  +8.60060000E-04
   +4.00350000E-04  -4.83870000E-04  -8.02000000E-05  +2.72560000E-04  +2.23350000E-04
   -6.52950000E-04  +4.40820000E-04  -1.16202000E-03  -2.68934000E-03  -3.86345000E-03
   +2.90369000E-03  +3.58149000E-03  +7.52125000E-03  -3.26363500E-02  -4.05989000E-02
   +1.31257000E-03  -1.89870860E-01  -1.07205150E-01  +3.42483500E-02  +5.02752000E-03
   -9.16457000E-03  -6.22034000E-03  -4.76090000E-04  -1.04800000E-04  +4.98109000E-03
   +2.73341440E-01  -2.69450000E-04  +8.33900000E-05  -1.72680000E-04  +6.76850000E-04
   -1.03803000E-03  -3.60110000E-04  -6.65110000E-04  +1.65020000E-04  -1.05880000E-04
   +6.20890000E-04  -3.01140000E-04  +4.03460000E-04  -3.83200000E-05  +3.45820000E-04
   -3.96600000E-04  +4.65300000E-05  -1.40260000E-04  -1.11130000E-04  +1.38869000E-03
   +5.82420000E-04  +1.23398000E-03  -5.20420000E-04  -1.32000000E-04  +2.79130000E-04
   +3.43220000E-04  -7.85170000E-04  +5.47240000E-04  -3.50847000E-03  -1.12545000E-03
   +2.05780000E-03  -1.91073000E-03  +1.48443000E-03  -3.85166000E-03  -1.58972500E-02
   -6.91581000E-03  -8.14900000E-04  -1.39346220E-01  -1.93269390E-01  -1.15273400E-02
   -3.30137300E-02  -3.79220100E-02  -1.22467000E-02  +4.07169000E-03  +4.26416000E-03
   -4.70047000E-03  +1.17763350E-01  +4.43698860E-01  -1.63000000E-05  +2.58800000E-05
   -7.41500000E-05  +8.73000000E-05  -1.75540000E-04  -2.76500000E-05  -7.64200000E-05
   +6.13000000E-05  +8.07700000E-05  +3.13200000E-05  -2.99400000E-05  +1.21300000E-05
   +1.34200000E-05  +6.24000000E-06  -6.23100000E-05  +1.32200000E-05  -2.55700000E-05
   -9.12000000E-06  -2.37370000E-04  +3.88240000E-04  +1.74550000E-04  -5.25000000E-05
   -3.55000000E-05  -1.63300000E-05  +1.33000000E-05  -5.92500000E-05  +6.59700000E-05
   -3.56884000E-03  +2.56279000E-03  +4.33035000E-03  +2.39349000E-03  -8.83418000E-03
   -3.28872000E-03  +2.42893700E-02  +2.19612900E-02  +7.98852000E-03  +4.18659000E-03
   -4.10625500E-02  -8.65216200E-02  -2.89234800E-02  -3.47672400E-02  +1.63253000E-03
   +9.21539000E-03  -6.53490000E-04  -4.01449000E-03  -1.17024900E-01  +2.82294400E-01
   +4.00384900E-01  -5.44196000E-03  +1.38342000E-03  +2.00503000E-03  -8.83138000E-03
   +2.19259900E-02  -2.50917900E-02  -1.89174000E-03  +7.30040000E-04  -7.41130000E-04
   +8.08170000E-04  +1.62500000E-04  -4.40020000E-04  +3.88600000E-05  +2.76140000E-04
   -4.66830000E-04  +2.86800000E-05  +1.11406000E-03  -1.32192000E-03  -7.98823300E-02
   +1.02959700E-02  -1.24156700E-02  +6.88390000E-04  -1.05710000E-03  -7.91500000E-05
   +5.93800000E-05  -3.13990000E-04  +2.85610000E-04  +2.70934000E-03  -1.49648800E-02
   +1.71043300E-02  -2.56450000E-04  -7.29350000E-04  +5.92380000E-04  -4.46950000E-04
   +4.40100000E-04  +1.27170000E-04  +4.99660000E-04  +7.18970000E-04  +3.34570000E-04
   -1.10596000E-03  -1.14800000E-05  -1.01308000E-03  -5.15660000E-04  -1.65802000E-03
   -6.41190000E-04  -9.44140000E-04  -1.13364000E-03  -1.63630000E-04  +5.81202770E-01
   +1.81188000E-03  +6.78630000E-04  -1.34850000E-04  +8.75988000E-03  -1.08008300E-02
   +1.06563300E-02  -6.34010000E-04  -5.26460000E-04  -2.74020000E-04  -2.04500000E-04
   -5.71130000E-04  +5.02900000E-04  +9.03000000E-06  +5.75100000E-05  +3.11800000E-05
   -1.16990000E-04  -2.68420000E-04  +3.83310000E-04  +1.51411200E-02  -1.14577030E-01
   +4.94140800E-02  -2.50193000E-03  +9.95515000E-03  -1.03442100E-02  +3.10200000E-05
   -5.73700000E-05  -2.02400000E-05  -3.17532000E-03  -2.59032200E-02  +2.02679100E-02
   -2.43300000E-04  -4.09680000E-04  +1.33516000E-03  -3.48970000E-04  +8.24590000E-04
   -4.32000000E-06  +1.70770000E-04  +7.01570000E-04  +5.57000000E-04  -8.72260000E-04
   -2.84270000E-04  -1.17500000E-03  +1.68555000E-03  -8.61190000E-04  -8.39740000E-04
   -5.97090000E-04  -7.93590000E-04  -1.49670000E-04  +1.65759700E-02  +5.34751840E-01
   +1.97987000E-03  -7.29390000E-04  +3.66200000E-05  -3.93433000E-03  -3.02030000E-04
   +2.16320000E-03  +1.65841000E-03  -7.30690000E-04  -2.88400000E-04  -4.39800000E-05
   +1.58750000E-04  -1.38000000E-05  +8.41200000E-05  +3.27100000E-05  -1.95400000E-05
   +1.10380000E-04  -2.86690000E-04  +4.72180000E-04  -1.64477300E-02  +4.57281600E-02
   -1.31310020E-01  -6.20282000E-03  +1.74877900E-02  -3.65692700E-02  -9.98300000E-05
   +1.36230000E-04  -6.81400000E-05  +5.20893000E-03  +7.77582000E-03  -7.56610000E-04
   -1.28300000E-03  -1.53836000E-03  -2.88500000E-04  +2.15150000E-04  +9.53000000E-05
   -1.73510000E-04  +1.06920000E-04  +3.00770000E-04  +3.78320000E-04  -8.29500000E-05
   -3.30810000E-04  -2.15030000E-04  -5.47000000E-04  -3.96650000E-04  -8.86400000E-05
   -4.42080000E-04  -5.24250000E-04  -1.36980000E-04  -2.23748600E-02  +6.03893000E-02
   +5.24794410E-01  +1.24579000E-03  -7.17950000E-04  +3.94765000E-03  +3.07014000E-03
   +3.64547000E-03  -2.52806000E-03  +1.02592000E-03  +3.04685500E-02  +1.71407300E-02
   -5.32130200E-02  -1.75622900E-02  +1.11496400E-02  -6.43445400E-02  +2.07476000E-03
   -1.69395100E-02  +3.76082000E-03  +1.12068500E-02  +1.39595500E-02  +1.63200000E-05
   -1.72611000E-03  -1.42317000E-03  +1.08600000E-05  -1.11030000E-04  -2.06950000E-04
   -1.71991500E-02  -2.28822600E-02  -4.44804000E-02  -5.99550000E-04  +5.31860000E-04
   +1.43320000E-04  +8.22900000E-05  +3.75100000E-05  -1.72940000E-04  -1.76060000E-04
   +1.06390000E-04  +1.88880000E-04  +4.45730000E-04  +5.37950000E-04  +1.17400000E-04
   -1.11110000E-04  -2.60650000E-04  -6.43500000E-05  +6.33600000E-05  -7.90800000E-05
   -2.30230000E-04  -5.54240000E-04  -6.23050000E-04  -5.47800000E-05  -2.69950000E-04
   -6.56000000E-06  +1.39380000E-04  +1.25557270E-01  +2.78126000E-03  -1.85514000E-03
   +2.39024000E-03  -9.59900000E-04  +7.11240000E-04  +3.84493000E-03  +1.29597500E-02
   -2.21960400E-02  -1.29209600E-02  -2.76418000E-03  -2.21041030E-01  -4.09011000E-03
   -2.71833900E-02  -3.10554500E-02  -9.41085100E-02  -2.40998000E-03  +7.01962000E-03
   +1.05795400E-02  +7.24150000E-04  +1.09227000E-03  +1.52860000E-04  +1.78380000E-04
   +4.02000000E-06  +3.86750000E-04  +1.19491000E-02  -4.67306000E-03  +1.48596300E-02
   +2.42740000E-04  -6.34210000E-04  +4.10100000E-05  +3.65270000E-04  +1.24250000E-04
   -3.00950000E-04  -6.70000000E-06  +2.61300000E-05  +2.98800000E-05  +1.30000000E-05
   -1.50950000E-04  -1.30650000E-04  +6.19000000E-06  +1.83990000E-04  +6.96500000E-05
   +4.96700000E-05  +1.31920000E-04  +2.48380000E-04  +1.14350000E-04  +2.09770000E-04
   +5.91100000E-05  +7.95800000E-05  -2.16200000E-05  -2.59570000E-04  +1.16070300E-02
   +2.93969940E-01  +1.38441000E-03  +6.41860000E-04  -2.80000000E-04  +2.20268000E-03
   +3.79696000E-03  -5.59432000E-03  -6.71058000E-03  +3.20218000E-03  +5.16586000E-03
   +2.08085900E-02  -7.70839200E-02  -2.51199800E-02  -1.84732000E-02  -1.87484400E-02
   -1.96095470E-01  +5.08120000E-04  -1.82662700E-02  -3.54178500E-02  -2.64560000E-04
   +1.16040000E-04  +2.99970000E-04  +1.94600000E-05  +2.82600000E-05  -5.31100000E-05
   -3.24861500E-02  -8.46475000E-03  -2.02465600E-02  +2.00480000E-04  -2.06160000E-04
   +2.25550000E-04  +4.67480000E-04  -3.04500000E-05  -3.93200000E-04  -8.10400000E-05
   -3.97000000E-05  +7.70600000E-05  -3.10000000E-05  -1.65100000E-04  -1.75250000E-04
   -8.95000000E-06  +1.44820000E-04  +1.45030000E-04  -7.60300000E-05  -5.20700000E-05
   +2.77090000E-04  +1.23370000E-04  +1.84060000E-04  +8.33800000E-05  +2.02990000E-04
   -1.97700000E-05  -1.19010000E-04  +3.40204000E-02  +9.70370100E-02  +2.69437490E-01
   +5.34000000E-06  +1.25000000E-05  +1.97600000E-05  -3.55600000E-05  -1.40300000E-05
   +4.29000000E-06  +3.73700000E-05  +1.24700000E-05  +2.57100000E-05  -5.92600000E-05
   +3.34000000E-06  -3.54100000E-05  -5.04000000E-05  -5.77100000E-05  +1.56600000E-05
   +7.20000000E-07  +3.67700000E-05  +8.20000000E-06  -1.29090000E-04  +1.52100000E-05
   +1.00720000E-04  +5.06600000E-05  +3.52200000E-05  -1.58700000E-05  +1.47800000E-05
   +6.39500000E-05  -2.99100000E-05  -1.57630000E-04  +2.52770000E-04  +4.68940000E-04
   -6.00440000E-04  -6.32100000E-05  -1.34260000E-04  +9.25310000E-04  -1.00782000E-03
   -2.62355000E-03  +2.82940000E-03  -2.39167700E-02  -2.76191100E-02  -3.30090000E-03
   -4.37867000E-03  +9.40560000E-04  +1.55144000E-03  -5.92160000E-04  -3.90040000E-04
   -5.62164300E-02  +6.91030600E-02  +1.13420460E-01  +2.17800000E-05  -7.28000000E-06
   -1.87900000E-05  +7.22500000E-05  +3.78500000E-05  +1.79100000E-05  +5.61653200E-02
   +4.32300000E-05  -7.64000000E-06  +1.53800000E-05  -1.02140000E-04  +1.31130000E-04
   +3.95100000E-05  +1.06740000E-04  -1.66500000E-05  +4.33700000E-05  -1.22000000E-04
   +6.25500000E-05  -8.74300000E-05  +8.66000000E-06  -7.86500000E-05  +8.39600000E-05
   -6.55000000E-06  +2.39500000E-05  +1.93300000E-05  -1.95200000E-04  -1.10150000E-04
   +8.09000000E-06  +8.81400000E-05  +1.73100000E-05  -2.97400000E-05  -7.69400000E-05
   +1.61060000E-04  -1.11110000E-04  -1.01140000E-04  +5.17450000E-04  +6.21000000E-04
   +1.24820000E-04  -9.80760000E-04  -4.49380000E-04  +3.18042000E-03  +3.38124000E-03
   +1.07323000E-03  +6.17443000E-03  -2.71930800E-02  -2.87291000E-02  -5.27382000E-03
   -1.88036000E-03  +1.12846000E-03  +5.73990000E-04  +2.91350000E-04  -1.86452000E-03
   +3.65273700E-02  -2.09178530E-01  -2.26543860E-01  +9.30600000E-05  +4.84900000E-05
   +3.06100000E-05  +1.22080000E-04  -2.13900000E-05  -1.38300000E-05  -4.01439400E-02
   +2.34966100E-01  +1.30000000E-07  -3.06000000E-06  +3.59900000E-05  -3.92800000E-05
   +4.58200000E-05  +4.04300000E-05  +3.92700000E-05  -1.01000000E-05  -2.24900000E-05
   -2.95500000E-05  +1.84000000E-05  -3.70000000E-07  -2.12200000E-05  -8.57000000E-06
   +3.27900000E-05  -1.00000000E-08  +1.79700000E-05  +2.90000000E-07  -1.29630000E-04
   -5.72300000E-05  -1.55420000E-04  +3.34700000E-05  +4.22000000E-06  -1.62500000E-05
   +8.00000000E-06  +2.43100000E-05  -2.99900000E-05  +1.59580000E-04  +1.57790000E-04
   +2.60040000E-04  +4.83100000E-05  -2.42410000E-04  -9.41420000E-04  +1.33703000E-03
   +4.96261000E-03  +2.48321000E-03  +5.67590000E-04  -9.34390000E-04  -4.15403000E-03
   +4.15300000E-05  +2.03570000E-04  +2.30501000E-03  +7.00360000E-04  -8.32140000E-04
   +2.93750000E-04  +8.28847200E-02  -2.56552560E-01  -3.20974380E-01  +1.13330000E-04
   +9.48600000E-05  +6.01700000E-05  +3.38300000E-05  -2.82700000E-05  -4.45400000E-05
   -8.55590100E-02  +2.53520000E-01  +3.21247400E-01  -1.77300000E-05  +1.10900000E-05
   +1.88100000E-05  +1.37400000E-04  -4.12900000E-05  -5.89000000E-06  -5.89500000E-05
   +2.11600000E-05  +5.20000000E-06  +2.64400000E-05  -7.31800000E-05  -1.77000000E-05
   -4.93000000E-05  -3.28400000E-05  -6.37900000E-05  -4.29000000E-06  +3.47800000E-05
   -4.20000000E-06  +5.84430000E-04  -4.94580000E-04  -7.27150000E-04  -2.59820000E-04
   -1.46360000E-04  +8.11000000E-05  +4.78600000E-05  -2.61400000E-05  +4.64500000E-05
   -2.59690000E-04  -5.41114000E-03  +2.07778000E-03  +6.14600000E-03  -1.45159900E-02
   -1.67811300E-02  -5.52964400E-02  +1.11074600E-02  +3.01892900E-02  +2.40617000E-03
   +1.63883700E-02  +1.69027500E-02  -1.86274000E-03  -2.05280000E-03  +4.87644000E-03
   -1.48077000E-03  -5.64000000E-04  -6.00000000E-08  +8.44610000E-04  +2.68910000E-03
   -1.79760000E-03  -1.61400000E-05  +6.49600000E-05  -8.21400000E-05  +2.92000000E-06
   +1.01160000E-04  +7.94800000E-05  -7.30890000E-04  -1.22561000E-03  +2.56500000E-05
   +5.07487700E-02  -1.13200000E-05  +2.05400000E-05  -1.32700000E-05  +2.74490000E-04
   -9.09300000E-05  -4.34300000E-05  -1.06560000E-04  +3.76000000E-05  +3.08800000E-05
   +6.66600000E-05  -6.30100000E-05  +1.51600000E-05  +4.27000000E-06  +1.13600000E-05
   -6.81700000E-05  -3.01000000E-06  -5.94000000E-06  -1.15600000E-05  +3.62920000E-04
   -1.38200000E-04  -1.01435000E-03  -3.17300000E-04  -2.91520000E-04  +1.22860000E-04
   +2.16100000E-05  -5.27800000E-05  +5.61400000E-05  -5.63001000E-03  +4.13310000E-04
   -1.28724000E-03  +4.52550000E-03  -1.20156400E-02  -1.78273200E-02  +1.09191600E-02
   -1.78076940E-01  -1.44827420E-01  -3.92289000E-03  +1.78231000E-03  +1.36699000E-03
   -1.69365000E-03  +2.87449000E-03  -8.43210000E-04  -2.60160000E-04  -2.93940000E-04
   +7.78750000E-04  +2.30568000E-03  +1.35826000E-03  +2.76958000E-03  -6.28900000E-05
   -4.69000000E-06  -5.44800000E-05  -5.06200000E-05  +6.43300000E-05  +6.92000000E-05
   +6.29660000E-04  +1.10820000E-04  -1.00276000E-03  -8.88985000E-03  +1.85517250E-01
   -2.10900000E-05  -1.51000000E-06  +1.76000000E-05  +2.03000000E-06  -7.43300000E-05
   +2.63100000E-05  -3.20600000E-05  +8.03000000E-06  -5.94400000E-05  +4.73100000E-05
   -3.72500000E-05  +2.78300000E-05  -4.39500000E-05  +7.70000000E-06  -3.93000000E-05
   -7.40000000E-07  +2.40600000E-05  -8.13000000E-06  +3.81830000E-04  -5.21100000E-05
   +3.10900000E-05  -6.68400000E-05  +1.80000000E-05  +3.67100000E-05  +5.95800000E-05
   -7.20800000E-05  +5.29300000E-05  +1.67672000E-03  -1.92551000E-03  +4.12678000E-03
   +9.62130000E-04  -2.26370000E-04  +1.52767000E-03  +2.98258900E-02  -1.44771480E-01
   -1.96156270E-01  -1.80256000E-03  -1.73426100E-02  -1.03671800E-02  +5.24954000E-03
   -4.83660000E-04  +1.52130000E-04  +2.09480000E-04  +1.03600000E-03  -9.90100000E-05
   -2.29346000E-03  +2.28710000E-03  +3.67920000E-04  -4.97600000E-05  -5.99000000E-06
   -5.07600000E-05  -3.56500000E-05  +3.88000000E-05  +1.54100000E-05  +1.75744000E-03
   +7.25220000E-04  -3.72250000E-04  -3.35580500E-02  +1.59524360E-01  +2.03010190E-01
   -6.86100000E-05  -1.11150000E-04  -1.23520000E-04  -4.85310000E-04  -9.69490000E-04
   -7.75370000E-04  -3.84380000E-04  -1.59630000E-04  -9.14000000E-05  -2.14490000E-04
   -1.96860000E-04  -2.25640000E-04  -1.05130000E-04  -1.61070000E-04  -4.70100000E-05
   +9.48500000E-05  +2.48900000E-05  +7.74800000E-05  -1.22983000E-03  +5.05050000E-04
   -1.14630000E-03  -1.29240000E-04  +9.98100000E-05  -9.13800000E-05  +3.40400000E-05
   +1.06340000E-04  -7.75000000E-06  +1.68956000E-03  -7.22220000E-04  +1.47360000E-03
   -2.14001510E-01  -1.27495000E-02  +1.45035510E-01  -1.13310700E-02  +5.30990000E-04
   +1.45963000E-02  +1.50553000E-03  -5.15081000E-03  +8.96570000E-04  -1.17120000E-04
   +7.62200000E-05  -9.20140000E-04  +2.90275000E-03  -1.39588000E-03  +1.75117000E-03
   -1.10481000E-03  -2.54830000E-04  +6.32150000E-04  +1.26600000E-05  +6.64600000E-05
   +1.85400000E-04  +2.42570000E-04  +1.72240000E-04  +1.87110000E-04  +4.65200000E-05
   +1.82260000E-04  +1.18440000E-04  -7.12930000E-04  +1.52745000E-03  -1.87875000E-03
   +2.23157360E-01  -1.19940000E-04  +1.70270000E-04  -2.73210000E-04  -4.39880000E-04
   -1.35480000E-04  -5.65310000E-04  -1.40900000E-04  -1.91900000E-04  +1.72420000E-04
   -2.72000000E-04  +3.17630000E-04  -5.51000000E-06  +2.54100000E-05  -9.58000000E-06
   +3.06770000E-04  +1.83250000E-04  -2.09330000E-04  +4.29900000E-05  +1.50447000E-03
   -6.23700000E-04  +1.09087000E-03  +9.23600000E-05  +1.10210000E-04  +4.75200000E-05
   -8.49200000E-05  +5.80100000E-05  -1.06820000E-04  +1.68468500E-02  +6.31040000E-03
   -1.34487100E-02  -1.23531200E-02  -5.42464400E-02  -2.52707000E-03  -1.86340600E-02
   +2.93803000E-03  +1.58698600E-02  -4.96439000E-03  -6.45860000E-04  -3.48718000E-03
   -8.74000000E-06  -1.15759000E-03  +2.99400000E-05  -1.77166000E-03  -9.16540000E-04
   -5.41524000E-03  -1.15861000E-03  -2.99610000E-04  +8.67600000E-04  -8.07700000E-05
   -4.62970000E-04  -4.06090000E-04  +1.16800000E-05  -2.47080000E-04  -1.90940000E-04
   +6.21400000E-05  +1.65560000E-04  +1.25950000E-04  +1.89404000E-03  -8.31590000E-04
   +1.71573000E-03  +1.82515200E-02  +5.04930900E-02  +3.35800000E-05  +1.62970000E-04
   -2.55980000E-04  -3.13630000E-04  -5.45450000E-04  -2.98360000E-04  -4.46900000E-05
   +3.48290000E-04  +4.52430000E-04  -3.21090000E-04  +7.16200000E-05  +8.09000000E-06
   -1.45400000E-05  -9.49200000E-05  -3.83600000E-05  -1.05980000E-04  +1.10920000E-04
   +1.01380000E-04  -2.23860000E-04  +1.97780000E-03  -1.13615000E-03  -2.45090000E-04
   -1.86300000E-05  -1.25200000E-05  -1.03520000E-04  +2.48920000E-04  -1.20030000E-04
   +1.79918600E-02  +2.06596000E-03  -9.84475000E-03  +1.43816460E-01  -1.69817000E-03
   -1.70451700E-01  -2.81289000E-03  -1.51142000E-03  +5.24722000E-03  +1.21569000E-03
   -3.20818000E-03  +4.00862000E-03  -1.09111000E-03  -9.42800000E-05  -3.16150000E-04
   +1.76701000E-03  -5.83878000E-03  -4.69890000E-04  -3.36200000E-05  +1.36040000E-04
   +8.64900000E-05  +1.10500000E-05  +2.77000000E-06  -3.31700000E-05  +2.50990000E-04
   -5.13800000E-05  -2.22900000E-05  -2.25700000E-05  -1.00800000E-05  -2.06300000E-05
   -1.70466000E-03  +2.02301000E-03  -1.16347000E-03  -1.58993770E-01  +5.65481000E-03
   +1.74918670E-01  -4.55800000E-05  -1.29930000E-04  +1.10880000E-04  -2.27190000E-04
   -1.60700000E-04  -1.32740000E-04  +4.89600000E-05  -2.16600000E-05  -7.92700000E-05
   -6.44000000E-06  +9.33500000E-05  +3.42100000E-05  +1.72000000E-06  -6.05000000E-06
   +1.04970000E-04  +1.52100000E-05  +1.24800000E-05  -6.26800000E-05  -2.81610000E-04
   +1.88090000E-03  -1.34802000E-03  -3.32010000E-04  -1.56290000E-04  +5.23380000E-04
   -1.05300000E-05  +4.64000000E-05  -7.04000000E-05  +3.42061000E-03  +1.63391800E-02
   +1.64830900E-02  -1.77300000E-03  -2.38625000E-03  +5.53724000E-03  -1.26380000E-03
   -3.35550000E-04  -1.66210000E-04  +5.86600000E-05  -5.39262000E-03  +2.35454000E-03
   +5.79492000E-03  -1.52465000E-02  -1.61293200E-02  -5.60527700E-02  +1.42311100E-02
   +2.93457400E-02  +2.45280000E-04  -6.90710000E-04  -8.56420000E-04  +3.41780000E-04
   +7.99600000E-05  -1.01200000E-04  +2.16300000E-05  -4.24000000E-05  -6.59600000E-05
   -2.66080000E-04  -1.99120000E-04  -1.28350000E-04  -1.73430000E-04  +2.75300000E-04
   -2.62460000E-04  +5.82100000E-05  +9.33260000E-04  +9.36850000E-04  +5.23259900E-02
   +1.12480000E-04  +4.99500000E-05  -1.03960000E-04  +1.08850000E-04  +4.72980000E-04
   -2.33520000E-04  +1.53300000E-04  -1.07800000E-04  +4.68700000E-05  -4.24100000E-05
   +3.90900000E-05  -5.00200000E-05  +3.74300000E-05  +5.03000000E-06  -2.32400000E-05
   -3.93300000E-05  -3.09400000E-05  +7.17800000E-05  +1.23359000E-03  -1.72147000E-03
   +9.20120000E-04  -1.51166000E-03  -3.50640000E-04  +3.05470000E-04  -4.96400000E-05
   +5.14000000E-05  -1.08100000E-05  -1.49200000E-05  +5.37183000E-03  +9.43540000E-04
   -2.30554000E-03  +3.05577000E-03  -1.31840000E-03  -2.29550000E-04  -3.65640000E-04
   +9.26270000E-04  -5.46608000E-03  +9.47350000E-04  -1.73181000E-03  +3.47024000E-03
   -1.15115600E-02  -1.79986700E-02  +1.43030400E-02  -1.77061630E-01  -1.45659480E-01
   +9.37700000E-05  -9.18300000E-04  -1.00377000E-03  -3.28560000E-04  -2.81510000E-04
   +1.84700000E-05  +3.26600000E-05  -2.97800000E-05  +1.62700000E-05  -1.32110000E-04
   -2.75410000E-04  +3.92000000E-05  +2.47200000E-04  -2.77260000E-04  +2.06010000E-04
   -9.94700000E-05  +1.41820000E-04  +2.01360000E-04  -9.93124000E-03  +1.85555520E-01
   -3.22600000E-05  +1.24800000E-05  +4.38600000E-05  -1.64160000E-04  -2.24650000E-04
   +1.25860000E-04  -8.78700000E-05  +7.87300000E-05  +1.70800000E-05  +1.73500000E-05
   -5.11400000E-05  -4.10000000E-07  -4.41400000E-05  -2.61900000E-05  -2.15900000E-05
   +1.29100000E-05  +2.49300000E-05  -6.58000000E-06  -2.15582000E-03  +1.35180000E-04
   -1.62675000E-03  -5.49460000E-04  -1.03332000E-03  +4.05890000E-04  +3.46800000E-05
   -1.72500000E-05  +1.77900000E-05  +6.71440000E-04  -1.44992600E-02  -1.02204000E-02
   +5.56838000E-03  -1.01346000E-03  +4.15000000E-04  -1.04690000E-04  +1.00254000E-03
   -4.58600000E-05  +2.27478000E-03  -1.77514000E-03  +4.20489000E-03  +1.70223000E-03
   -5.61330000E-04  +1.92467000E-03  +2.96841100E-02  -1.45899250E-01  -2.06807890E-01
   -1.09790000E-04  -2.74860000E-04  -1.27130000E-04  +5.63470000E-04  +2.92720000E-04
   +3.07900000E-05  +4.42000000E-06  +5.38200000E-05  +2.27400000E-05  -6.44200000E-05
   +1.04140000E-04  -3.98300000E-05  -2.86090000E-04  +1.68500000E-04  -2.98430000E-04
   -2.83500000E-05  -7.75430000E-04  -6.53990000E-04  -3.36756400E-02  +1.61753470E-01
   +2.13304840E-01  -4.77600000E-05  -4.14000000E-06  +3.15200000E-05  +8.09700000E-05
   -2.03580000E-04  +2.28500000E-05  -9.54400000E-05  +6.60500000E-05  -2.49400000E-05
   +4.64200000E-05  -3.61600000E-05  +4.80700000E-05  -4.85000000E-06  +3.22200000E-05
   -1.55100000E-05  -8.46000000E-06  +8.67000000E-06  -2.13400000E-05  -1.62300000E-04
   +3.48950000E-04  +7.58650000E-04  -5.00500000E-05  +7.24800000E-05  +4.29600000E-05
   +2.82200000E-05  -5.09100000E-05  +2.47900000E-05  +1.04163000E-03  -5.27193000E-03
   +8.16710000E-04  -3.55500000E-05  +1.16530000E-04  -8.59480000E-04  +2.61579000E-03
   -1.24454000E-03  +1.66777000E-03  +9.20690000E-04  -2.91273000E-03  +1.36161000E-03
   -2.13654690E-01  -1.89781400E-02  +1.49244640E-01  -1.09427100E-02  +1.15862000E-03
   +1.36794300E-02  -4.99840000E-04  +1.45506000E-03  -1.48262000E-03  -1.62020000E-04
   -1.03300000E-04  -8.48300000E-05  -4.21400000E-05  +1.01900000E-05  -9.24000000E-06
   -1.51260000E-04  +1.81230000E-04  -2.12690000E-04  +1.74100000E-05  +2.35200000E-05
   -8.15200000E-05  -2.54340000E-04  +2.46190000E-04  -1.84350000E-04  -8.38880000E-04
   +1.57896000E-03  -1.93737000E-03  +2.22179660E-01  -6.44000000E-06  -3.05000000E-06
   -1.94400000E-05  -9.91200000E-05  -3.64280000E-04  -4.41000000E-06  -8.57600000E-05
   +5.55700000E-05  +1.65500000E-05  +3.93900000E-05  +7.80000000E-07  +4.09500000E-05
   -7.29000000E-06  -5.88000000E-06  -1.34900000E-05  +7.79000000E-06  +2.97000000E-06
   -1.08600000E-05  -7.26510000E-04  +4.20910000E-04  +5.10540000E-04  +7.21000000E-05
   +7.31700000E-05  +8.54500000E-05  +1.39700000E-05  -3.01700000E-05  +1.88000000E-05
   -4.85745000E-03  -7.59750000E-04  -2.94474000E-03  -1.30360000E-04  -1.34261000E-03
   -1.69670000E-04  -1.58950000E-03  -1.13678000E-03  -4.94332000E-03  +1.67008700E-02
   +6.52909000E-03  -1.45440700E-02  -2.00286000E-02  -5.27595100E-02  +1.94213000E-03
   -1.72544400E-02  +2.83253000E-03  +1.65236700E-02  +1.28256000E-03  +1.59160000E-04
   +2.34094000E-03  -9.58900000E-05  +1.42700000E-05  -6.01400000E-05  -3.08100000E-05
   +3.65100000E-05  +2.60400000E-05  +1.16810000E-04  +1.53200000E-05  +4.40330000E-04
   +9.28240000E-04  +6.43700000E-05  -7.08910000E-04  +2.13210000E-04  -1.72950000E-04
   +3.02080000E-04  +1.95085000E-03  -8.39230000E-04  +1.69858000E-03  +2.35950500E-02
   +4.72244000E-02  -7.20000000E-06  -5.30000000E-07  +2.06000000E-05  +6.39900000E-05
   +6.62000000E-05  +9.54000000E-06  +1.29800000E-05  +4.23000000E-06  +4.35000000E-06
   -1.88700000E-05  -9.07000000E-06  -1.45400000E-05  -3.63000000E-06  -5.05000000E-06
   +7.38000000E-06  -8.47000000E-06  +1.10800000E-05  -3.08000000E-06  -5.96200000E-05
   -1.35790000E-04  +3.18900000E-04  -9.73000000E-06  +5.66700000E-05  -3.92100000E-05
   -2.07000000E-06  +2.23900000E-05  -1.42200000E-05  +9.10320000E-04  -2.74506000E-03
   +3.77206000E-03  -1.13465000E-03  -4.53630000E-04  -4.46010000E-04  +1.30301000E-03
   -5.31562000E-03  -6.11680000E-04  +2.00653800E-02  +3.95515000E-03  -9.74220000E-03
   +1.48339750E-01  +9.22850000E-04  -1.73537420E-01  -3.78813000E-03  -7.09990000E-04
   +5.34886000E-03  -1.67854000E-03  +2.12984000E-03  +3.97700000E-05  -4.38000000E-06
   -5.28900000E-05  -2.01900000E-05  +2.13400000E-05  -6.80000000E-07  -6.70000000E-06
   -2.70010000E-04  +3.81440000E-04  +6.39400000E-05  +7.95300000E-04  +1.36910000E-04
   -7.01150000E-04  -1.86310000E-04  +2.80070000E-04  -2.67160000E-04  -1.60328000E-03
   +2.05518000E-03  -1.05529000E-03  -1.62775210E-01  -4.96200000E-04  +1.76892170E-01
   -2.75790000E-04  -8.03500000E-05  +3.79200000E-04  +7.11470000E-04  +4.28670000E-04
   -7.92320000E-04  -3.07900000E-05  -6.71600000E-05  +1.21460000E-04  +2.48040000E-04
   -6.89900000E-05  -7.78300000E-05  -3.81000000E-05  +1.14660000E-04  -1.05090000E-04
   -5.09000000E-06  +1.32200000E-04  -2.08200000E-04  -6.67316000E-03  +1.57816000E-03
   +1.27139000E-03  +2.49000000E-06  -2.35070000E-04  +6.80150000E-04  +8.58200000E-05
   -1.77660000E-04  +1.13980000E-04  +8.60150000E-04  -1.31146000E-03  -5.54900000E-05
   +2.80180000E-04  +3.91610000E-04  +3.30740000E-04  -2.58380000E-04  -8.54000000E-05
   +7.20000000E-07  +1.08080000E-04  -4.20100000E-05  -2.10550000E-04  +1.36730000E-04
   +1.72030000E-04  -3.17700000E-05  +2.04130000E-04  +1.21600000E-04  +1.49590000E-04
   -2.20000000E-06  -2.77700000E-05  +2.28900000E-05  -2.87116300E-01  +8.26091700E-02
   +2.53667600E-02  -1.41830000E-04  +9.49700000E-05  +6.18000000E-06  -8.30000000E-06
   +9.06000000E-06  -1.48000000E-06  -9.51000000E-06  +1.14600000E-05  -4.56000000E-06
   +3.11200000E-05  -7.62200000E-05  -1.13500000E-05  +1.28100000E-05  +4.56200000E-05
   -3.14200000E-05  +1.78000000E-05  +2.02800000E-05  +7.23000000E-06  +3.09287390E-01
   +1.37458000E-03  +1.35300000E-05  -2.92550000E-04  -3.39790000E-04  -2.22081000E-03
   +3.86229000E-03  -3.62690000E-04  -1.18120000E-04  +5.38940000E-04  -8.09700000E-05
   +2.77860000E-04  -1.36480000E-04  -4.21100000E-05  -3.04700000E-05  +1.63460000E-04
   +5.50700000E-05  -3.05540000E-04  +3.11620000E-04  +1.99735300E-02  -9.23206000E-03
   -1.89798000E-03  -3.68150000E-04  +1.91710000E-04  -1.15087000E-03  -2.36600000E-05
   +9.66100000E-05  -7.13200000E-05  +1.28154000E-03  +7.18290000E-04  -2.92580000E-04
   -7.40900000E-05  -2.99650000E-04  -5.02490000E-04  +1.39820000E-04  +8.06800000E-05
   -6.72600000E-05  -2.26730000E-04  -1.46480000E-04  +1.38530000E-04  -1.87820000E-04
   -1.10370000E-04  +2.72400000E-05  -2.46930000E-04  +1.29210000E-04  +3.44900000E-05
   +1.75280000E-04  +2.25500000E-04  +1.93800000E-05  +8.05274100E-02  -7.38883600E-02
   -9.40885000E-03  +4.40200000E-05  -3.76000000E-06  -7.13300000E-05  -3.31000000E-06
   -3.94700000E-05  -1.23700000E-05  +1.12400000E-05  +2.37000000E-06  +1.21800000E-05
   +8.04000000E-06  +1.08710000E-04  +1.24730000E-04  +3.83700000E-05  -1.35900000E-05
   +8.52000000E-05  +1.07100000E-05  -6.77000000E-06  +1.80000000E-07  -9.02650800E-02
   +7.99654400E-02  -1.37974000E-03  +6.36100000E-04  +4.76250000E-04  +3.36460000E-04
   +2.74045000E-03  -3.97765000E-03  +5.52170000E-04  +3.91920000E-04  -1.92520000E-04
   -8.25400000E-05  -2.89900000E-05  +1.46570000E-04  +8.33500000E-05  -1.05270000E-04
   +4.52800000E-05  +7.06000000E-05  +2.34070000E-04  -3.21570000E-04  -2.35409800E-02
   +8.45269000E-03  +6.22400000E-04  -1.28274000E-03  +4.94320000E-04  +1.27428000E-03
   -3.70900000E-05  +4.96000000E-06  +1.11700000E-05  -6.43750000E-04  -5.32560000E-04
   +5.54240000E-04  +3.62710000E-04  +1.37750000E-04  -1.17510000E-04  -3.75880000E-04
   -1.04600000E-04  +8.62200000E-05  +1.73470000E-04  -7.80000000E-07  -2.12130000E-04
   +1.35200000E-04  +1.47820000E-04  -4.00000000E-06  -1.34610000E-04  -1.43680000E-04
   +2.05980000E-04  -1.31520000E-04  -1.36160000E-04  -5.62000000E-06  +2.71681600E-02
   -1.02068300E-02  -4.93812500E-02  -2.93000000E-05  +6.40900000E-05  +8.52200000E-05
   +1.30100000E-05  +1.11100000E-05  +1.65500000E-05  +1.50400000E-05  -1.34600000E-05
   +1.43000000E-06  +2.39000000E-05  +2.00500000E-05  +7.09300000E-05  +3.27200000E-05
   +3.30000000E-07  -1.07120000E-04  -2.06000000E-06  +5.24000000E-06  +1.17800000E-05
   -2.77759700E-02  +6.62529000E-03  +5.38391800E-02  +7.47400000E-05  -4.93900000E-05
   -1.09480000E-04  +1.06200000E-04  -7.06500000E-05  +3.48080000E-04  -8.88540000E-04
   +7.30800000E-04  +3.64440000E-04  -3.54000000E-05  +1.59480000E-04  -1.64280000E-04
   -5.28200000E-05  -6.75000000E-05  +8.36800000E-05  +5.89600000E-05  -3.12000000E-05
   +5.87500000E-05  +3.78351000E-03  +5.96350000E-03  +2.65240000E-04  +3.29120000E-04
   +2.67320000E-04  +7.62700000E-05  -4.42000000E-06  +6.07300000E-05  -3.15300000E-05
   +3.91910000E-04  -1.28870000E-04  -5.79510000E-04  +2.47670000E-04  +4.22620000E-04
   +4.08110000E-04  -2.69590000E-04  -1.21810000E-04  +7.25900000E-05  +2.46400000E-04
   +9.05200000E-05  -1.80990000E-04  +1.44550000E-04  +7.09300000E-05  +4.55600000E-05
   +4.34330000E-04  +1.80900000E-05  -8.45000000E-05  -1.47820000E-04  -1.58000000E-04
   +2.66000000E-06  -1.46854130E-01  -1.28295380E-01  -4.91598000E-03  +4.73200000E-05
   +1.05800000E-05  -1.43300000E-05  +1.12200000E-05  +3.40800000E-05  +8.61000000E-06
   -2.20500000E-05  -5.27000000E-06  -1.48000000E-05  +8.23000000E-06  -4.34400000E-05
   +1.71000000E-06  -7.75800000E-05  +6.13500000E-05  -3.66600000E-05  +2.39000000E-06
   -2.43000000E-06  +1.02800000E-05  -1.68451200E-02  -2.45868100E-02  -1.62723000E-03
   +1.59593040E-01  +1.78050000E-04  -4.55200000E-05  +1.55760000E-04  -9.70370000E-04
   +3.17710000E-04  -1.36100000E-05  +5.14800000E-05  -1.98730000E-04  +5.04300000E-04
   +2.41500000E-04  +1.11020000E-04  -2.57130000E-04  -1.20640000E-04  +1.23890000E-04
   -1.21890000E-04  -5.04800000E-05  +8.75500000E-05  -6.13300000E-05  -1.29731300E-02
   -1.59215000E-02  -1.67056000E-03  -1.92630000E-04  +5.94640000E-04  -1.49985000E-03
   +1.25540000E-04  -1.36430000E-04  +1.05940000E-04  +1.06816000E-03  -1.79863000E-03
   +3.82916000E-03  -2.61730000E-04  -1.01600000E-04  +3.74730000E-04  +7.71300000E-05
   +1.88810000E-04  +1.68200000E-05  +1.66080000E-04  +5.69080000E-04  +4.44590000E-04
   -5.29190000E-04  -4.52160000E-04  -4.26720000E-04  +6.50420000E-04  -3.37270000E-04
   -3.57250000E-04  -4.74070000E-04  -5.67590000E-04  -1.10680000E-04  -1.27120830E-01
   -2.12486170E-01  -6.19999000E-03  -1.02610000E-04  +1.44160000E-04  -2.78800000E-05
   +2.17400000E-05  +6.14400000E-05  +5.09400000E-05  -2.08800000E-05  -5.71400000E-05
   -2.97600000E-05  -5.21500000E-05  +1.11460000E-04  -9.78100000E-05  +3.76200000E-05
   -4.00700000E-05  +1.54090000E-04  -9.16700000E-05  -2.14500000E-05  -3.46800000E-05
   +6.77591000E-03  +9.43051000E-03  +3.65640000E-04  +1.39852610E-01  +2.30521340E-01
   +4.65800000E-05  -6.90600000E-05  -1.64830000E-04  +3.68630000E-04  -4.41320000E-04
   +4.60310000E-04  -3.09600000E-04  -4.83800000E-04  +4.50200000E-04  -7.38900000E-05
   +7.03800000E-05  -6.06000000E-05  -4.01800000E-05  +1.21200000E-05  +3.59900000E-05
   +1.67200000E-05  -4.74400000E-05  +1.26000000E-05  +1.58499800E-02  +1.88697600E-02
   -5.73180000E-04  +9.49650000E-04  +9.49220000E-04  +1.15447000E-03  +1.11800000E-05
   -2.07000000E-06  -1.09600000E-05  -1.77224000E-03  +2.24210000E-03  -3.12175000E-03
   +6.27900000E-05  -3.15270000E-04  -7.53100000E-05  +6.80160000E-04  +1.01100000E-04
   +5.29500000E-05  -3.98400000E-04  -1.09290000E-04  +2.29590000E-04  +1.22010000E-04
   -2.41520000E-04  +2.04320000E-04  +4.17790000E-04  +6.07680000E-04  +1.28310000E-04
   +3.33070000E-04  +4.16230000E-04  +1.89200000E-05  -5.07904000E-03  -7.38517000E-03
   -4.87997500E-02  +2.61800000E-05  -2.32000000E-05  -2.88100000E-05  +5.10000000E-07
   -2.78200000E-05  -4.52200000E-05  +3.17200000E-05  +3.27500000E-05  +1.97400000E-05
   -2.95900000E-04  +3.10250000E-04  -7.09800000E-05  -3.63500000E-05  +9.69600000E-05
   -1.35630000E-04  +4.41600000E-05  +4.00100000E-05  -1.22500000E-05  +2.12900000E-03
   +2.99995000E-03  -8.44860000E-04  +5.42269000E-03  +4.68311000E-03  +5.07130400E-02
   +7.25500000E-05  +3.38600000E-05  -3.05900000E-05  +5.53690000E-04  -4.91610000E-04
   -6.66400000E-04  -3.67310000E-04  +2.86650000E-04  -2.89890000E-04  -1.24920000E-04
   +6.70000000E-05  +6.16900000E-05  +6.15600000E-05  -1.23460000E-04  +7.80000000E-05
   +4.71100000E-05  -7.20900000E-05  +6.65500000E-05  -1.10940000E-03  -3.42151000E-03
   -5.86303000E-03  -3.48770000E-04  +9.91300000E-04  -1.01833000E-03  -8.01000000E-05
   +1.31720000E-04  -6.79900000E-05  -1.69780000E-04  +3.11850000E-04  +5.18410000E-04
   +7.88100000E-05  -1.20190000E-04  -1.58190000E-04  -2.20260000E-04  -4.97700000E-05
   -1.67000000E-05  -2.38000000E-06  -9.04700000E-05  -4.45200000E-05  +7.11500000E-05
   +5.36400000E-05  +3.33100000E-05  -1.20960000E-04  -8.62800000E-05  +9.73600000E-05
   +1.69000000E-05  +3.49900000E-05  -5.05000000E-06  -4.87628200E-02  +1.01506400E-02
   +2.09914800E-02  +6.20100000E-05  -1.39800000E-05  +5.34500000E-05  -2.50000000E-07
   -2.01400000E-05  +9.19000000E-06  +2.27500000E-05  -1.05100000E-05  +1.27400000E-05
   +1.72330000E-04  +4.14100000E-05  +6.23300000E-05  +1.51500000E-05  +2.17600000E-05
   -6.73900000E-05  -3.72000000E-06  +7.48000000E-06  -7.49000000E-06  -1.44654000E-03
   +1.36174800E-02  +2.75382400E-02  +1.65162000E-03  -8.25373000E-03  -1.84434200E-02
   +5.02364400E-02  -3.18860000E-04  -8.89900000E-05  -9.72000000E-05  -3.05330000E-04
   +7.52500000E-04  -2.51420000E-04  +5.87900000E-04  +4.42640000E-04  -2.31650000E-04
   -1.99000000E-06  -5.71100000E-05  +6.69500000E-05  +4.85800000E-05  -4.78300000E-05
   +5.00400000E-05  +9.20000000E-06  +4.77300000E-05  -3.70800000E-05  -2.57548000E-03
   +8.98849000E-03  +1.86131100E-02  +7.16010000E-04  -2.35897000E-03  +2.76192000E-03
   -2.30100000E-05  +6.47000000E-06  -1.40200000E-05  +3.11240000E-04  +1.20883000E-03
   +3.33940000E-04  -3.36210000E-04  -1.56860000E-04  +5.68100000E-04  -5.53800000E-05
   -1.89710000E-04  -1.40610000E-04  +3.58600000E-05  -1.30860000E-04  -1.93770000E-04
   +1.36440000E-04  +1.98260000E-04  +1.49680000E-04  -2.70270000E-04  -8.66200000E-05
   -3.58300000E-05  +1.39160000E-04  +1.37070000E-04  +1.79000000E-05  +9.86107000E-03
   -1.04144950E-01  -1.10066180E-01  -2.71900000E-05  +2.37100000E-05  +1.01300000E-05
   -1.73500000E-05  -2.16200000E-05  -1.34900000E-05  -4.60000000E-07  +1.99000000E-06
   +2.32300000E-05  +2.57070000E-04  -6.47980000E-04  +6.56200000E-05  +3.96100000E-05
   -3.97000000E-06  -1.18500000E-05  +1.11800000E-05  -2.53000000E-06  +1.82000000E-06
   -2.12400000E-04  -5.08936000E-03  -8.20118000E-03  +4.00173000E-03  -1.05277500E-02
   -2.17074000E-02  -1.23663500E-02  +1.11209630E-01  +9.40000000E-06  +4.67210000E-04
   +1.20000000E-06  +1.31492000E-03  -8.38190000E-04  +5.70010000E-04  +1.17500000E-05
   +1.55530000E-04  +4.05270000E-04  -2.18630000E-04  +1.80800000E-05  +9.36500000E-05
   +1.85600000E-05  -2.07350000E-04  +1.24770000E-04  +1.59810000E-04  -8.82500000E-05
   +4.31800000E-05  +2.41041000E-03  -1.16655100E-02  -2.07624700E-02  -1.06661000E-03
   +4.75878000E-03  -3.34050000E-03  -3.49700000E-05  +6.20900000E-05  -8.71000000E-06
   -1.17741000E-03  -1.06963000E-03  +7.03260000E-04  +1.97720000E-04  -5.51080000E-04
   -3.24900000E-05  +5.37290000E-04  +4.19010000E-04  +1.62730000E-04  -2.97400000E-04
   +2.96880000E-04  +4.84340000E-04  -3.51240000E-04  -4.94050000E-04  -1.61130000E-04
   +8.19840000E-04  +2.90430000E-04  -2.74770000E-04  -4.92400000E-05  -4.30200000E-05
   -2.55800000E-05  +2.06732700E-02  -1.07646380E-01  -2.58184080E-01  +2.38300000E-05
   +8.08300000E-05  +9.00400000E-05  +1.62500000E-05  +1.75900000E-05  -1.11000000E-06
   +3.37600000E-05  +1.22100000E-05  -3.47000000E-06  -2.54940000E-04  +3.85470000E-04
   +1.45470000E-04  -1.36260000E-04  -1.72800000E-05  +8.73300000E-05  -6.91000000E-06
   +1.34900000E-05  -1.90300000E-05  -1.63020000E-04  -7.03540000E-04  -1.80721000E-03
   +1.12100000E-05  +7.58690000E-04  +6.99270000E-04  -2.20969200E-02  +1.16868780E-01
   +2.81770290E-01  -2.96340000E-04  +2.43750000E-04  +3.80270000E-04  +2.61490000E-04
   -6.11350000E-04  +4.25850000E-04  -7.05000000E-05  +7.91800000E-05  -5.12000000E-06
   +4.16600000E-05  +2.21000000E-06  +5.25500000E-05  -3.07300000E-05  +1.59700000E-05
   +9.10200000E-05  -1.96270000E-04  +4.48000000E-05  -1.09890000E-04  -1.78733000E-03
   -1.25746000E-03  +9.23720000E-04  -5.11544100E-02  +1.95197800E-02  -2.56608600E-02
   -8.02000000E-06  +6.63500000E-05  -1.00560000E-04  +2.26490000E-04  +4.68370000E-04
   -4.36570000E-04  -1.11510000E-04  -6.85700000E-05  -3.92200000E-05  +8.45900000E-05
   +9.98600000E-05  +3.58500000E-05  -7.02500000E-05  -2.36000000E-05  -2.10000000E-06
   -1.11910000E-04  +6.36000000E-06  +2.54670000E-04  +2.16870000E-04  -3.84640000E-04
   -5.66480000E-04  +6.56900000E-05  +1.20280000E-04  +4.42100000E-05  +2.79900000E-05
   -1.38500000E-04  -1.32290000E-04  +5.02700000E-05  -1.66500000E-05  -1.14060000E-04
   -5.33000000E-06  -1.06500000E-05  -4.83000000E-06  +8.36000000E-06  +8.35000000E-06
   +1.57000000E-05  -1.53700000E-05  +4.09300000E-05  +4.80500000E-05  -1.10135000E-03
   +1.14290000E-04  -2.76580000E-04  -6.79000000E-06  -8.85000000E-06  -1.60800000E-05
   +3.88210000E-04  -2.01610000E-04  +2.97540000E-04  +3.12400000E-05  +3.11170000E-04
   -1.24550000E-04  +6.22200000E-04  +1.42860000E-04  -3.90400000E-05  +5.17000900E-02
   +5.88200000E-04  -4.74450000E-04  -8.31330000E-04  -1.63170000E-04  +5.25440000E-04
   +5.50770000E-04  -3.17300000E-05  +8.48000000E-06  +8.02200000E-05  +4.28700000E-05
   -7.29900000E-05  -3.55800000E-05  -4.01300000E-05  +1.06750000E-04  +6.60000000E-05
   -1.24690000E-04  -1.19190000E-04  +8.92300000E-05  -2.62360000E-03  +1.09443300E-02
   -1.35241600E-02  +1.97820400E-02  -1.43375080E-01  +1.28112500E-01  +3.09300000E-05
   -8.48900000E-05  +2.30500000E-05  -5.54100000E-05  +9.04540000E-04  +3.38210000E-04
   +2.15320000E-04  -4.42100000E-05  -3.53200000E-05  +1.35500000E-04  +9.51400000E-05
   -4.31400000E-05  -1.18920000E-04  -3.82100000E-05  +1.66370000E-04  +6.43000000E-06
   -1.35260000E-04  -1.02610000E-04  -5.95520000E-04  +1.18630000E-04  +2.39200000E-05
   +8.27000000E-05  +6.77700000E-05  -1.71100000E-05  +1.67860000E-04  -1.47237000E-03
   -2.62147000E-03  -4.96500000E-05  +2.00300000E-05  +1.50700000E-05  -8.46000000E-06
   -1.41400000E-05  -7.08000000E-06  +1.10000000E-05  +2.25100000E-05  -2.37000000E-06
   -1.33000000E-05  +1.41400000E-05  -2.31100000E-05  -3.30170000E-04  -2.00680000E-04
   -2.31410000E-04  -1.82300000E-05  +3.31300000E-05  -2.50300000E-05  -1.51010000E-04
   -8.83600000E-05  -9.13300000E-05  +2.39340000E-04  +1.80490000E-04  -2.27260000E-04
   -1.28210000E-04  +8.16440000E-04  -8.24420000E-04  -2.18508000E-02  +1.54900890E-01
   +4.09330000E-04  +8.86480000E-04  -4.90380000E-04  -1.21310000E-03  +6.90610000E-04
   +1.95300000E-04  +4.79510000E-04  -1.07070000E-04  -5.69300000E-05  -2.47260000E-04
   +2.09640000E-04  -1.31260000E-04  +8.41400000E-05  -1.81790000E-04  -2.08830000E-04
   +1.49470000E-04  -3.07220000E-04  +4.84830000E-04  -3.45598000E-03  +1.72291400E-02
   -2.01025900E-02  -2.54013800E-02  +1.26363230E-01  -2.17369080E-01  -1.63000000E-04
   -2.60800000E-05  +1.49060000E-04  +7.29140000E-04  +1.23164000E-03  +1.08743000E-03
   +6.61500000E-05  -5.23760000E-04  -5.45200000E-05  +2.08200000E-04  +2.12500000E-04
   -1.42700000E-05  -1.61900000E-04  +1.36240000E-04  +1.94880000E-04  -2.31430000E-04
   -2.67180000E-04  +1.31070000E-04  +2.22880000E-04  -1.67980000E-04  +7.71000000E-05
   +4.22000000E-06  -1.76000000E-06  +8.11000000E-06  +8.71820000E-04  -4.44133000E-03
   -4.53324000E-03  -3.59700000E-05  -3.31600000E-05  +2.02030000E-04  -1.06200000E-05
   +4.85000000E-06  -9.33000000E-06  -2.96100000E-05  +2.04600000E-05  -3.27700000E-05
   -4.48700000E-05  +8.67400000E-05  +2.67600000E-05  -4.73060000E-04  +9.82100000E-05
   +3.28600000E-05  -1.91100000E-05  -2.48100000E-05  -1.04900000E-05  -3.47100000E-05
   -7.97500000E-05  +2.34280000E-04  +1.09330000E-04  -1.21770000E-04  +3.36830000E-04
   -4.41270000E-04  +1.10825000E-03  -1.51587000E-03  +2.81233300E-02  -1.37922190E-01
   +2.37116980E-01  +2.12280000E-04  -1.41850000E-04  +2.51300000E-05  +7.14040000E-04
   +1.38763000E-03  +3.05280000E-04  +3.37440000E-04  -8.60400000E-05  +2.28800000E-05
   -3.87200000E-05  +1.01100000E-05  -9.32600000E-05  -1.17600000E-05  -5.51000000E-06
   -4.90000000E-07  -1.27540000E-04  -3.06000000E-05  -1.69000000E-05  +3.35010000E-04
   +2.11213000E-03  +9.60750000E-04  -1.92505520E-01  -1.35726230E-01  -5.11000000E-05
   -2.10500000E-05  +6.39900000E-05  -3.20600000E-05  +4.38160000E-04  +3.57870000E-04
   +6.78170000E-04  +1.94760000E-04  +1.54080000E-04  +2.04620000E-04  -3.95400000E-05
   -1.46300000E-05  -9.30200000E-05  +1.90600000E-05  +8.00500000E-05  +2.49700000E-05
   +1.94600000E-04  -1.35240000E-04  -2.69200000E-04  -3.18550000E-04  +2.25500000E-05
   +4.99890000E-04  -8.26700000E-05  -1.46210000E-04  -5.49600000E-05  -2.56260000E-04
   -1.22300000E-05  +1.38280000E-04  +6.16000000E-05  -3.74400000E-05  -1.99500000E-05
   +6.74000000E-06  +1.47700000E-05  +6.57000000E-06  -1.86400000E-05  +5.98000000E-06
   -2.24000000E-05  +8.71700000E-05  -4.40100000E-05  -3.69300000E-05  +2.83330000E-04
   +1.57000000E-05  -5.20600000E-04  +1.35000000E-06  -3.21000000E-06  +1.80800000E-05
   +3.13200000E-05  -1.28280000E-04  +4.52100000E-05  +2.14650000E-04  +2.49680000E-04
   -4.96660000E-04  +1.83020000E-04  +2.82870000E-04  -1.70100000E-05  +3.54009000E-03
   +4.24752000E-03  +1.91450000E-04  +2.05595130E-01  -9.99500000E-05  -3.38910000E-04
   +3.71140000E-04  -1.36359000E-03  +6.91200000E-05  +4.17570000E-04  +4.43310000E-04
   +3.68590000E-04  +2.52800000E-05  +2.00390000E-04  -1.45040000E-04  -8.47400000E-05
   -6.53400000E-05  -1.62600000E-05  -5.33300000E-05  +1.73060000E-04  +5.69700000E-05
   -7.36200000E-05  -1.19014400E-02  -1.35827000E-02  -1.05480000E-04  -1.34258750E-01
   -1.71739970E-01  +1.65607000E-03  +1.33160000E-04  -1.06870000E-04  +8.24100000E-05
   +1.21921000E-03  -6.85680000E-04  -3.39006000E-03  -1.02256000E-03  -2.55310000E-04
   +2.16200000E-04  -3.28600000E-05  -3.45350000E-04  -1.19810000E-04  +2.99070000E-04
   +1.54180000E-04  -1.16540000E-04  -5.68100000E-05  +1.36370000E-04  +2.54300000E-05
   +3.82490000E-04  +1.99670000E-04  -3.56940000E-04  -2.37390000E-04  -2.45530000E-04
   -5.43000000E-06  +4.18710000E-04  +3.54800000E-04  +1.07904000E-03  -8.07300000E-05
   +1.00250000E-04  +5.35200000E-05  +2.79100000E-05  +4.19900000E-05  +2.09100000E-05
   -4.97500000E-05  -1.23740000E-04  +1.20800000E-05  +4.61000000E-06  +2.85000000E-05
   -8.15500000E-05  +1.65780000E-04  -1.12220000E-04  +2.09280000E-04  -3.85200000E-05
   -1.09500000E-05  -5.21000000E-06  +1.04790000E-04  +5.48300000E-05  +1.19500000E-05
   +3.20000000E-06  +6.19040000E-04  -8.96700000E-05  +2.56700000E-04  +7.87900000E-05
   +2.56000000E-05  -1.37945500E-02  -1.23881300E-02  -9.06150000E-04  +1.47304960E-01
   +1.85725830E-01  +1.88180000E-04  +5.58300000E-05  -1.69120000E-04  -1.20608000E-03
   -1.18900000E-04  +1.03345000E-03  -2.86500000E-05  +2.82290000E-04  +1.67190000E-04
   +2.38680000E-04  -1.84270000E-04  -1.91600000E-05  -5.10200000E-05  +1.00430000E-04
   -5.17800000E-05  -1.78000000E-04  -5.12500000E-05  +2.98500000E-05  -2.04981800E-02
   -1.96901800E-02  -1.74817000E-03  +1.62129000E-03  +3.06847000E-03  -4.66647200E-02
   +4.32000000E-05  -1.03420000E-04  +3.62000000E-05  +1.57164000E-03  -1.83900000E-03
   -4.83263000E-03  -1.35543000E-03  -1.20400000E-03  +2.71060000E-04  +1.98500000E-04
   -2.29630000E-04  -2.52180000E-04  +8.12000000E-05  +1.68990000E-04  +7.36000000E-06
   -1.97670000E-04  -8.64700000E-05  +2.01080000E-04  +9.55200000E-04  -6.10600000E-05
   -4.60520000E-04  -1.33790000E-04  -1.00280000E-04  +2.03900000E-05  -8.52950000E-04
   -1.11762000E-03  +1.27599000E-03  -9.74400000E-05  +7.19700000E-05  -2.91500000E-05
   +1.65600000E-05  +2.56600000E-05  +8.44000000E-06  -1.04100000E-04  -1.07210000E-04
   -2.66900000E-05  -2.48300000E-05  +4.04600000E-05  -1.37700000E-05  -1.70470000E-04
   +4.41050000E-04  +2.59230000E-04  -1.72900000E-05  -3.77500000E-05  +8.19000000E-06
   +6.33200000E-05  +3.62200000E-05  -7.42600000E-05  +1.78070000E-04  +5.24780000E-04
   -6.62060000E-04  +2.81780000E-04  +1.91470000E-04  +2.60230000E-04  +1.99619400E-02
   +1.64584400E-02  +7.24520000E-04  -1.72755000E-03  +1.51351000E-03  +5.17886300E-02
   +5.81800000E-05  -1.94390000E-04  +1.90680000E-04  +3.60820000E-04  +2.35710000E-04
   +9.89880000E-04  +3.74470000E-04  +4.78460000E-04  -1.25810000E-04  +1.60630000E-04
   -1.47880000E-04  +1.48800000E-05  +1.78100000E-05  +8.12000000E-06  -6.54700000E-05
   +3.94000000E-05  -9.12000000E-06  -4.57300000E-05  -8.71880000E-04  -2.04300000E-05
   -3.65260000E-04  -2.52459360E-01  +1.12186640E-01  +1.86009600E-02  +5.24800000E-05
   -1.41640000E-04  +9.82200000E-05  -1.08350000E-04  -1.98670000E-04  +2.43140000E-04
   +1.22560000E-04  +1.07290000E-04  -1.36000000E-06  +4.50500000E-05  +1.81600000E-05
   -3.31800000E-05  -1.83240000E-04  -3.12900000E-05  +2.42500000E-05  +1.95720000E-04
   -1.41640000E-04  -3.29310000E-04  -7.54210000E-04  -9.82020000E-04  +6.32990000E-04
   +7.72000000E-05  +2.76300000E-05  -3.42400000E-05  +4.44920000E-04  -3.11570000E-04
   -6.48090000E-04  -1.42430000E-04  +6.22600000E-05  +6.62200000E-05  -1.41400000E-05
   -1.35400000E-05  -6.93000000E-06  +8.13000000E-06  +2.19900000E-05  -4.48000000E-06
   -1.37500000E-05  -1.57400000E-05  -2.48500000E-05  -2.31400000E-04  -1.56729000E-03
   -3.48290000E-04  +3.29300000E-05  +1.74000000E-06  +2.90800000E-05  +3.83210000E-04
   -1.76220000E-04  +2.86210000E-04  -1.95620000E-04  +7.74200000E-05  +1.14690000E-04
   +2.51150000E-04  -1.85350000E-04  +8.79000000E-06  -2.46808000E-03  +1.05690000E-04
   +4.07230000E-04  -1.91269400E-02  +1.20208900E-02  +1.23832000E-03  +2.74111800E-01
   +1.46540000E-04  -1.77670000E-04  -3.00900000E-05  -9.07130000E-04  -7.71210000E-04
   -3.01286000E-03  +6.06150000E-04  -1.67080000E-04  +1.25900000E-04  +1.48700000E-04
   +3.25860000E-04  +1.31950000E-04  +1.13990000E-04  +9.89200000E-05  +2.20800000E-05
   -1.74760000E-04  +4.08300000E-05  -3.98500000E-05  +1.52123400E-02  -8.66115000E-03
   -8.49640000E-04  +1.11018120E-01  -1.07793030E-01  -1.01286400E-02  -6.98000000E-05
   +1.85260000E-04  -1.24330000E-04  +4.66850000E-04  +5.97270000E-04  +5.08950000E-04
   -2.28550000E-04  -1.42360000E-04  -1.01190000E-04  +1.16910000E-04  +1.89100000E-04
   +5.66800000E-05  -7.44800000E-05  -4.36900000E-05  +5.81800000E-05  -3.31750000E-04
   +1.28570000E-04  +3.61640000E-04  +1.70920000E-04  -7.44360000E-04  -8.50230000E-04
   +8.56400000E-05  +1.70500000E-04  +6.86400000E-05  -5.25100000E-05  +4.42000000E-04
   +1.39137000E-03  +4.02800000E-05  -5.84500000E-05  -7.99900000E-05  -3.99000000E-06
   -1.81000000E-05  -3.99000000E-06  +1.07600000E-05  +5.69000000E-06  +1.99300000E-05
   +1.72600000E-05  +7.17500000E-05  +1.20890000E-04  -1.14760000E-03  -1.42813000E-03
   +6.17570000E-04  -4.90000000E-07  -3.62400000E-05  -9.95000000E-06  -2.87150000E-04
   +5.33270000E-04  -1.80750000E-04  -1.75240000E-04  -3.04100000E-05  -1.01360000E-04
   -2.21850000E-04  -1.18780000E-04  +1.13750000E-04  +1.64221900E-02  -9.04630000E-03
   -2.46412000E-03  -1.97238000E-02  +1.18866800E-02  +1.81107000E-03  -1.21299760E-01
   +1.14759750E-01  +1.69880000E-04  +5.26140000E-04  -1.04300000E-04  -1.54970000E-03
   -1.99658000E-03  -5.02875000E-03  +1.34359000E-03  -5.59700000E-04  +4.85100000E-05
   -1.29020000E-04  +8.08650000E-04  +2.14040000E-04  +3.36380000E-04  -7.21100000E-05
   -1.91670000E-04  +9.13100000E-05  -6.46500000E-05  +2.91810000E-04  +2.55098400E-02
   -1.32911600E-02  -3.94541000E-03  +1.79376100E-02  -9.03512000E-03  -4.84139600E-02
   -2.85340000E-04  +2.49730000E-04  -2.07200000E-05  +6.63400000E-05  +6.72350000E-04
   +7.83120000E-04  -1.66700000E-05  -1.76000000E-05  -2.30080000E-04  +1.05720000E-04
   +1.18040000E-04  -1.53200000E-05  -1.30400000E-04  -1.02500000E-05  +1.58250000E-04
   -1.13150000E-04  -1.30790000E-04  -7.14000000E-05  -3.64290000E-04  +2.68080000E-04
   +3.09730000E-04  +5.55500000E-05  +5.19900000E-05  -1.28300000E-05  +1.32641000E-03
   -6.36140000E-04  +1.26081000E-03  +2.58100000E-05  -1.25500000E-04  +6.24800000E-05
   -3.93000000E-06  -1.65300000E-05  -4.96000000E-06  +2.12000000E-05  -5.72000000E-06
   +9.08000000E-06  +5.07600000E-05  +1.95200000E-05  +5.06700000E-05  -1.88000000E-06
   -1.27000000E-06  +3.15100000E-04  +6.02000000E-06  -5.77000000E-06  +6.52000000E-06
   -6.08010000E-04  +9.91600000E-05  -7.30860000E-04  +3.52500000E-05  +1.29840000E-04
   -6.11600000E-05  -2.08460000E-04  +7.24200000E-05  +4.25680000E-04  -2.32284500E-02
   +1.12182700E-02  +2.90093000E-03  +3.02410000E-04  -1.47000000E-06  -9.64050000E-04
   -2.08055100E-02  +1.27035100E-02  +5.29592700E-02  -1.31764000E-03  +8.28580000E-04
   +5.61082000E-03  +1.04682800E-02  -1.48063800E-02  +1.21955800E-02  -6.63621500E-02
   +4.40244400E-02  -2.57848600E-02  +1.21363000E-03  +1.91236200E-02  -1.36528700E-02
   -3.56859000E-03  +4.69706000E-03  -1.30819000E-03  -1.78970000E-03  -7.02980000E-04
   +6.82220000E-04  -8.19800000E-05  -1.68420000E-03  -1.67351000E-03  +3.45940000E-04
   +2.86000000E-05  -1.42710000E-04  +1.23801000E-03  -9.94070000E-04  +5.06840000E-04
   -3.20850000E-04  +1.56060000E-04  -1.16540000E-04  -1.26900000E-05  +6.90100000E-05
   +9.69100000E-05  -2.23500000E-05  -1.63000000E-06  -1.83200000E-05  +5.16000000E-06
   -2.22000000E-06  -1.31000000E-06  +2.06300000E-05  -5.92000000E-06  +2.91900000E-05
   -3.33100000E-05  -1.41600000E-05  -7.53100000E-05  +3.73000000E-06  +3.50000000E-07
   -2.80000000E-06  -3.68697000E-03  +6.17840000E-04  +1.01803000E-03  -1.90540000E-03
   +1.73790000E-04  -1.24770000E-03  -1.96000000E-06  -1.57000000E-06  +1.38000000E-06
   +2.42000000E-06  -2.98000000E-06  +3.41000000E-06  +8.97600000E-05  -5.98000000E-06
   +1.81300000E-05  -3.34000000E-06  -3.88000000E-06  -3.20000000E-07  +3.92000000E-06
   -7.95000000E-06  +3.31000000E-06  +1.31600000E-04  -9.49300000E-05  +3.95400000E-05
   -2.02152000E-03  +1.40566000E-03  +3.84220000E-04  -1.42044000E-03  +1.34710000E-04
   -3.05860000E-04  +2.41600000E-05  -1.53100000E-05  -1.00480000E-04  +5.19000000E-05
   -3.94900000E-05  +1.81000000E-06  -3.38300000E-05  -6.63500000E-05  -2.60400000E-05
   +6.85112700E-02  +1.18089000E-03  +2.86849000E-03  +5.38345000E-03  +4.39521000E-03
   -6.27020000E-04  +4.40363000E-03  +3.89432800E-02  -2.19097720E-01  +1.47447240E-01
   +3.73895000E-03  -8.01214000E-03  +1.16365200E-02  +1.07652000E-03  +4.88922000E-03
   -3.95736000E-03  -2.36950000E-03  -1.53630000E-04  +1.45830000E-04  -2.38730000E-04
   -3.36412000E-03  -2.47005000E-03  +8.24830000E-04  -2.33490000E-04  -9.21200000E-05
   +5.88580000E-04  -5.91250000E-04  +2.22410000E-04  -4.96090000E-04  +3.22870000E-04
   +3.06790000E-04  -8.05800000E-05  +8.88200000E-05  +1.97330000E-04  -1.13800000E-05
   -3.59100000E-05  -5.51100000E-05  +1.97400000E-05  +3.05200000E-05  -4.37000000E-06
   +6.59000000E-06  -4.24000000E-06  +2.42900000E-05  -9.98100000E-05  -1.45340000E-04
   -1.17410000E-04  -1.78800000E-05  -3.17100000E-05  -1.83900000E-05  +2.42296000E-03
   +1.03580000E-04  -2.76650000E-04  +5.62860000E-04  -3.18785000E-03  -9.09930000E-04
   -4.47000000E-06  -3.65000000E-06  +9.23000000E-06  +6.50000000E-07  -1.68800000E-05
   +1.15800000E-05  +5.68100000E-05  -8.42300000E-05  +6.24000000E-06  +9.34000000E-06
   -3.79000000E-06  -2.79000000E-06  -6.35000000E-06  -1.65400000E-05  +5.30000000E-07
   +1.87800000E-04  -3.49500000E-05  -5.67840000E-04  +1.83128000E-03  -5.49520000E-04
   -2.13760000E-04  -3.07040000E-04  -2.57110000E-04  -3.65300000E-04  -1.00400000E-05
   -3.56000000E-06  -1.39000000E-05  -1.74000000E-05  -2.07600000E-05  +1.47800000E-05
   -5.72300000E-05  -1.10880000E-04  -1.97720000E-04  -5.25943400E-02  +2.28678600E-01
   +6.62019000E-03  +2.91858000E-03  +4.27718000E-03  -2.18354000E-03  +2.00863800E-02
   -1.11976100E-02  -2.79316800E-02  +1.44943780E-01  -1.49523010E-01  +5.40141000E-03
   -4.97381000E-03  +7.25706000E-03  +9.45200000E-04  +3.58072000E-03  -2.40031000E-03
   -2.31602000E-03  -7.12270000E-04  +6.61360000E-04  -2.65787000E-03  -2.32046000E-03
   -3.03626000E-03  +1.11977000E-03  -1.92110000E-04  -9.28400000E-05  +1.99940000E-04
   -5.25440000E-04  +1.07310000E-04  -4.78150000E-04  +1.90670000E-04  +2.94020000E-04
   -1.17800000E-05  +3.25400000E-05  +1.79820000E-04  -3.94800000E-05  -5.04900000E-05
   -1.18000000E-06  +3.50600000E-05  +5.38400000E-05  -2.22200000E-05  +9.99000000E-06
   -2.19500000E-05  +2.35700000E-05  -1.00820000E-04  -1.50450000E-04  -8.50900000E-05
   -4.87700000E-05  -7.32900000E-05  -1.26100000E-05  -3.55070000E-04  +6.90810000E-04
   +5.07350000E-04  +3.24000000E-05  -2.21730000E-03  -6.59160000E-04  -5.55000000E-06
   +8.75000000E-06  +4.66000000E-06  -6.09000000E-06  -1.32900000E-05  -6.40000000E-07
   +3.07000000E-05  +8.24000000E-06  -2.20100000E-05  +3.31000000E-06  +1.10000000E-05
   -1.84100000E-05  -1.09900000E-05  -1.22800000E-05  -3.90000000E-07  -3.81910000E-04
   -4.40600000E-04  +1.05440000E-04  +2.24470000E-04  -8.64790000E-04  +1.09660000E-04
   -4.62500000E-04  +5.21700000E-05  +6.25300000E-05  -7.56200000E-05  -1.92200000E-05
   +1.07160000E-04  +6.97000000E-06  -8.00300000E-05  -1.17080000E-04  +7.77000000E-06
   -1.98590000E-04  -2.63160000E-04  +2.34426200E-02  -1.59839200E-01  +1.54933750E-01
   +4.71470000E-04  +2.10390000E-04  -7.97730000E-04  -4.18400000E-03  +3.17977000E-03
   -1.51826000E-03  -1.33992600E-02  -1.39318000E-02  +1.35818200E-02  -2.18464000E-01
   -1.01483880E-01  +9.70450700E-02  +6.92031000E-03  +5.93626000E-03  -5.16332000E-03
   -6.39920000E-04  +8.25800000E-04  +3.49610000E-04  +1.07390000E-04  -3.50090000E-04
   +1.12848000E-03  -4.15660000E-04  +7.88500000E-05  -1.16860000E-04  +7.35000000E-04
   -2.17890000E-04  +1.55850000E-04  -7.39400000E-05  +2.41340000E-04  +6.34900000E-05
   -8.08000000E-06  -2.20300000E-05  -3.40100000E-05  -3.84300000E-05  -1.29600000E-05
   +2.62400000E-05  +6.23900000E-05  +6.91400000E-05  +9.70000000E-06  -1.51900000E-05
   -3.96500000E-05  +5.67000000E-06  -3.35400000E-05  -7.37200000E-05  -3.56800000E-05
   -8.28400000E-05  -9.19200000E-05  -1.20200000E-05  +1.40100000E-05  -1.24660000E-04
   +9.62400000E-05  +4.07251000E-03  -2.78558000E-03  -1.50179000E-03  +8.08000000E-06
   +1.43200000E-05  +7.44000000E-06  -7.45000000E-06  -1.38800000E-05  -6.94000000E-06
   +3.50000000E-07  +2.07200000E-05  +3.61900000E-05  +8.01000000E-06  +1.66200000E-05
   -5.95000000E-06  -1.06600000E-05  -9.66000000E-06  +2.54000000E-06  -2.30000000E-05
   +4.69100000E-05  -2.90600000E-05  +1.58500000E-05  +3.19500000E-05  +9.89000000E-06
   +7.03000000E-06  -1.71700000E-05  -2.22100000E-05  +4.26000000E-06  -1.35300000E-05
   +2.44200000E-05  +2.10600000E-05  -1.41000000E-06  -1.35200000E-05  -4.06900000E-05
   +8.61900000E-05  +1.49730000E-04  +4.82510000E-04  +2.17830000E-04  -3.82040000E-04
   +2.24182380E-01  -5.41440000E-04  +3.89500000E-04  +2.80540000E-04  +2.72860000E-03
   -1.63222000E-03  +1.46402000E-03  +1.27540400E-02  +1.09229400E-02  -6.84445000E-03
   -1.02265170E-01  -1.07632590E-01  +6.16709200E-02  -4.66275000E-03  -8.45374000E-03
   -2.69395000E-03  +3.25030000E-04  +1.13111000E-03  -1.00798000E-03  -1.07040000E-04
   -2.70990000E-04  -9.93390000E-04  +3.38920000E-04  -6.62700000E-05  +7.16400000E-05
   +5.31960000E-04  +8.21510000E-04  +1.34720000E-04  -1.21310000E-04  -7.49800000E-05
   +3.10000000E-07  -3.82000000E-06  +4.45700000E-05  +9.01000000E-06  +1.61600000E-05
   +2.27800000E-05  -1.33600000E-05  -8.80000000E-06  -5.36000000E-06  +6.03000000E-06
   -3.04000000E-06  +7.30000000E-07  -1.86000000E-06  +2.36900000E-05  +4.07900000E-05
   -1.89000000E-05  +1.47500000E-05  +2.34300000E-05  +7.80000000E-07  -2.61400000E-05
   +6.66500000E-05  -2.33000000E-05  -1.68626500E-02  -3.03975800E-02  +1.53624400E-02
   +3.99000000E-06  -4.94000000E-06  +7.50000000E-07  +1.22000000E-05  +4.32000000E-06
   +8.78000000E-06  +3.10000000E-05  -4.87500000E-05  +3.96000000E-06  -7.34000000E-06
   -8.79000000E-06  +7.01000000E-06  +5.48000000E-06  +1.13000000E-06  +1.73000000E-06
   +1.88300000E-05  -2.17500000E-05  +2.39000000E-06  +1.94000000E-06  -2.09000000E-06
   +4.65000000E-06  -1.97500000E-05  -5.13000000E-06  +8.04000000E-06  +2.00000000E-08
   +9.41000000E-06  -3.26100000E-05  -5.64000000E-06  +3.06000000E-06  +1.42100000E-05
   +1.93200000E-05  -6.12300000E-05  -1.14340000E-04  -5.87530000E-04  +1.94630000E-04
   -1.62620000E-04  +1.08386670E-01  +1.35289500E-01  -5.19150000E-04  +6.15190000E-04
   -1.32552000E-03  -4.18700000E-05  +2.77390000E-04  +2.48901000E-03  +5.11950000E-04
   +3.59780000E-04  +2.06758000E-03  +9.64049800E-02  +6.84642200E-02  -1.01260930E-01
   +1.98286600E-02  +1.03068300E-02  -8.94020000E-03  -5.05110000E-04  +2.23164000E-03
   -3.93600000E-05  -2.64040000E-04  -8.62100000E-05  +1.99200000E-05  +3.38800000E-05
   +7.13100000E-05  -3.52900000E-05  +8.57470000E-04  -2.31557000E-03  +1.20713000E-03
   +1.75100000E-05  -3.80000000E-07  +1.30700000E-05  -1.09600000E-05  +1.30000000E-07
   +1.98000000E-06  +1.15900000E-05  -6.58000000E-06  -2.05100000E-05  -4.32400000E-05
   -4.46700000E-05  -9.64000000E-06  +2.24000000E-06  +1.37000000E-05  +1.44300000E-05
   -1.15500000E-05  -1.17000000E-05  +2.06400000E-05  +5.08000000E-05  +5.21700000E-05
   +7.22000000E-06  +4.16000000E-05  +4.26000000E-06  -1.25700000E-05  -1.42221800E-02
   -1.21629900E-02  +1.00774800E-02  -7.35000000E-06  -1.02600000E-05  -4.04000000E-06
   +7.30000000E-07  +4.85000000E-06  +2.91000000E-06  +1.77000000E-06  -2.83000000E-05
   -1.72000000E-06  -6.32000000E-06  +2.69000000E-06  -3.13000000E-06  +2.40000000E-06
   +1.88000000E-06  -2.14000000E-06  +2.25900000E-05  -8.66000000E-06  +2.40000000E-07
   +3.96000000E-06  +1.17700000E-05  +5.18000000E-06  -2.61500000E-05  +1.54000000E-06
   -1.58600000E-05  -1.29000000E-05  -3.82000000E-06  +8.25000000E-06  -8.60000000E-07
   -7.42000000E-06  +1.09200000E-05  +7.10000000E-07  +3.12000000E-06  -6.60000000E-07
   +1.48190000E-04  -9.34050000E-04  -2.69970000E-04  -1.02928830E-01  -6.68444100E-02
   +9.59087700E-02  -1.56639000E-03  +1.94212500E-02  -2.12412100E-02  -3.27983000E-03
   +3.77545000E-03  +2.71072000E-03  -1.67485000E-03  +1.46200000E-05  -1.77920000E-04
   -5.28640000E-04  -1.65156000E-03  +4.74335000E-03  +6.37186000E-03  -1.04257500E-02
   +1.27286200E-02  -7.38085900E-02  +4.77649400E-02  -4.77603200E-02  +4.28500000E-04
   +9.25610000E-04  -1.09638000E-03  +7.20800000E-05  -9.00900000E-05  -1.26240000E-04
   +3.51240000E-03  -1.33561000E-03  -7.80200000E-05  +1.17370000E-04  +8.27100000E-05
   -7.02000000E-06  +9.57000000E-06  +1.86000000E-06  +3.06900000E-05  -2.18400000E-05
   -3.65100000E-05  +2.74600000E-05  +4.21400000E-05  +5.15600000E-05  +2.91000000E-06
   -9.23000000E-06  -4.41000000E-05  -1.60000000E-06  +6.41000000E-06  -2.52900000E-05
   -2.31700000E-05  -6.03300000E-05  -8.60600000E-05  -7.40000000E-07  -4.50740000E-04
   +5.57300000E-05  +1.62670000E-04  -9.14990000E-04  -1.35095000E-03  +9.03340000E-04
   -6.32000000E-06  +1.54000000E-05  -4.02000000E-06  -1.37900000E-05  -6.98000000E-06
   -1.49900000E-05  +2.55000000E-06  +3.36000000E-05  +7.40000000E-07  +3.53000000E-06
   +1.21600000E-05  -5.44000000E-06  -1.55200000E-05  -7.80000000E-07  -3.06000000E-06
   -5.79300000E-05  +1.00370000E-04  -1.22000000E-04  +1.96100000E-05  -8.22000000E-06
   +9.71000000E-06  +1.77300000E-05  -7.16000000E-06  -1.45600000E-05  +1.17100000E-05
   -6.36000000E-06  +6.19300000E-05  +1.44000000E-06  -1.01700000E-05  +1.14300000E-05
   -2.26400000E-05  +2.20000000E-06  +4.15700000E-05  -1.16000000E-04  -1.91680000E-04
   -3.92280000E-04  +2.56040000E-04  +3.35300000E-05  +6.60540000E-04  +7.27084200E-02
   +4.36647000E-03  -3.16364000E-03  +1.20786800E-02  +4.27112000E-03  +7.72085000E-03
   +2.91098000E-03  -2.41754000E-03  -1.42040000E-04  -1.30380000E-04  +1.99751000E-03
   -1.50187000E-03  +3.14742000E-03  +5.09436000E-03  +3.25666000E-03  +9.02380000E-04
   +4.69099400E-02  -1.56494660E-01  +1.43768400E-01  -5.30400000E-05  -1.24900000E-04
   +6.42400000E-05  +2.62310000E-04  -1.33440000E-04  -4.79200000E-05  -1.71186000E-03
   +4.44400000E-04  -1.48792000E-03  -2.22760000E-04  -2.00180000E-04  -5.15600000E-05
   -3.53600000E-05  +6.29200000E-05  +3.80200000E-05  +1.61500000E-05  -2.29800000E-05
   +5.75000000E-06  -3.48200000E-05  -4.27900000E-05  -7.24000000E-06  +2.16900000E-05
   +1.57400000E-05  -9.04000000E-06  +9.36000000E-06  +3.80500000E-05  -1.85600000E-05
   +4.19600000E-05  +4.12100000E-05  +8.50000000E-07  +1.36200000E-04  -1.22570000E-04
   -8.78500000E-05  -4.75120000E-04  -1.15252000E-03  -9.58630000E-04  -1.20200000E-05
   -8.14000000E-06  -2.96000000E-06  -1.79000000E-06  +4.52000000E-06  -6.10000000E-07
   +3.30000000E-07  -4.20000000E-07  -4.27700000E-05  +2.31000000E-06  -1.52200000E-05
   +3.97000000E-06  +5.63000000E-06  +4.68000000E-06  -1.99000000E-06  +1.42800000E-05
   -8.24000000E-05  +7.06000000E-06  -8.09000000E-06  -7.34000000E-06  +1.76800000E-05
   -1.45600000E-05  +1.64100000E-05  -3.29700000E-05  +2.98100000E-05  -1.68700000E-05
   +5.35500000E-05  -8.95000000E-06  -1.99100000E-05  +2.41900000E-05  +8.50000000E-06
   -8.02700000E-05  -3.82000000E-05  -3.84340000E-04  -5.45720000E-04  -5.59430000E-04
   -4.94000000E-06  +1.93600000E-05  +2.66930000E-04  -5.62785100E-02  +1.57161200E-01
   +3.88888000E-03  -6.35280000E-04  +5.25844000E-03  +1.67887000E-03  +4.17375000E-03
   +3.54795000E-03  -1.01260000E-03  -8.36010000E-04  +6.68620000E-04  +4.01539000E-03
   -1.19298000E-03  +4.80300000E-05  -5.87047000E-03  +1.51059600E-02  -1.14140700E-02
   -5.00225000E-02  +1.44729260E-01  -2.06189760E-01  +2.23330000E-04  +1.58900000E-04
   -1.45810000E-04  +1.05780000E-04  -6.58700000E-05  -7.22500000E-05  -2.51715000E-03
   +7.02360000E-04  +1.39100000E-04  -8.92700000E-05  -8.90600000E-05  -1.69300000E-05
   -4.73000000E-06  +3.37400000E-05  +2.61500000E-05  +5.87000000E-06  -4.01100000E-05
   +1.08800000E-05  -3.14700000E-05  -3.90000000E-05  -7.15000000E-06  +1.49900000E-05
   +1.59700000E-05  -2.00000000E-08  -1.22400000E-05  +6.26000000E-06  -1.34600000E-05
   +3.20400000E-05  +2.68700000E-05  +1.60000000E-06  -1.02200000E-05  -7.62400000E-05
   +2.53900000E-05  +5.21810000E-04  +1.31380000E-04  -2.67157000E-03  -1.36700000E-05
   -5.05000000E-06  -4.14000000E-06  -8.41000000E-06  +3.93000000E-06  -8.54000000E-06
   -1.53000000E-06  +8.42000000E-06  -3.26200000E-05  +8.30000000E-07  -8.84000000E-06
   +4.00000000E-07  +2.67000000E-06  +9.00000000E-07  -2.00000000E-06  +5.02000000E-06
   -3.08000000E-05  -3.11800000E-05  -3.55000000E-06  +6.20000000E-07  +6.89000000E-06
   -4.67000000E-06  +8.41000000E-06  -3.37400000E-05  +8.46000000E-06  -2.28900000E-05
   +5.27300000E-05  -6.29000000E-06  -2.01000000E-06  +9.41000000E-06  +3.55000000E-06
   -3.75100000E-05  +1.31500000E-05  -2.30920000E-04  -2.37320000E-04  -3.26920000E-04
   -3.06290000E-04  -8.49900000E-05  -3.82350000E-04  +5.04690000E-02  -1.56781360E-01
   +2.12687400E-01  -1.88183490E-01  -4.37720300E-02  +1.36158740E-01  +8.10250000E-03
   +1.79683000E-03  -6.22273000E-03  -4.13530000E-04  +2.27663000E-03  -8.72880000E-04
   -8.20800000E-05  +7.95200000E-05  -4.20210000E-04  -1.25881000E-03  +5.38951000E-03
   -6.42540000E-04  -1.65078400E-02  -7.02089000E-03  +2.20223900E-02  -1.46090000E-04
   +8.74900000E-05  -2.44380000E-04  -4.38840000E-04  +5.59620000E-04  +1.05030000E-04
   -1.21739000E-03  -5.85950000E-04  +5.82070000E-04  -7.57330000E-04  +4.46150000E-04
   -6.14160000E-04  -2.78820000E-04  -3.29400000E-05  -3.41550000E-04  +2.62210000E-04
   +1.70280000E-04  -3.40400000E-05  -2.50820000E-04  -1.16200000E-04  +1.56420000E-04
   -1.16550000E-04  -1.75660000E-04  +6.02000000E-06  -1.10750000E-04  +7.27000000E-05
   -2.96300000E-05  +1.44290000E-04  +1.64440000E-04  +5.50000000E-06  +4.78600000E-05
   -1.35350000E-04  -4.62900000E-05  -1.16240000E-04  -4.81390000E-04  +1.05403000E-03
   -1.06500000E-05  -3.01700000E-05  -7.44000000E-06  +6.49000000E-06  +1.17100000E-05
   +1.09600000E-05  +2.05900000E-05  -2.11000000E-06  +6.32700000E-05  +2.22100000E-05
   +5.12000000E-05  +6.60000000E-06  +7.17000000E-06  -9.80000000E-07  -6.97000000E-06
   +4.37500000E-05  -1.01700000E-05  +1.26600000E-05  -9.50000000E-07  -6.24100000E-05
   +4.32800000E-05  +8.70000000E-06  -3.26000000E-06  -8.11000000E-06  +1.21890000E-04
   +6.94570000E-04  -9.37100000E-05  +1.81700000E-05  -7.92000000E-05  +2.47100000E-05
   -4.69000000E-05  +6.93400000E-05  -1.63410000E-04  +5.19920000E-04  +4.09180000E-04
   -2.49570000E-04  +3.10000000E-05  -7.64900000E-05  +9.06000000E-06  +8.07100000E-05
   -1.79007000E-03  -1.53962000E-03  +2.00418880E-01  -4.45837100E-02  -6.51132800E-02
   +5.65767800E-02  -1.44462700E-02  -1.78365000E-03  +1.41598700E-02  +1.50798000E-03
   -1.52647000E-03  +2.90881000E-03  +9.34170000E-04  -7.86690000E-04  -9.98900000E-05
   +4.06760000E-03  +5.40775000E-03  +5.34781000E-03  +1.19272300E-02  +7.82074000E-03
   -1.02817100E-02  -9.47230000E-04  -1.01500000E-05  +1.09700000E-05  +1.86780000E-04
   -7.51810000E-04  +4.87980000E-04  +2.22043000E-03  -1.29090000E-04  -1.25573000E-03
   +2.40300000E-04  +1.91740000E-04  -1.64870000E-04  -8.55000000E-06  +3.00990000E-04
   +1.69190000E-04  -1.32310000E-04  -2.32370000E-04  +6.57100000E-05  +1.32690000E-04
   +3.58200000E-05  -9.11700000E-05  +6.08700000E-05  -9.69000000E-06  -3.24400000E-05
   +8.27200000E-05  +6.48300000E-05  +1.20300000E-05  -1.21080000E-04  -1.66260000E-04
   -1.39600000E-05  -4.81200000E-05  -1.00070000E-04  -1.58340000E-04  -9.64300000E-04
   -1.33650000E-04  +1.41055000E-03  -1.44000000E-05  +2.25600000E-05  -2.34000000E-06
   -2.47300000E-05  -1.49100000E-05  -2.32200000E-05  -6.17000000E-06  -3.80000000E-07
   -6.70500000E-05  +1.00160000E-04  -3.27900000E-05  -3.09900000E-05  -2.17700000E-05
   +8.71000000E-06  -3.89000000E-06  +5.48600000E-05  +1.18300000E-05  -2.08800000E-05
   -1.88300000E-05  +4.81000000E-05  +2.44000000E-05  -4.94800000E-05  +2.60600000E-05
   -1.33920000E-04  +7.05030000E-04  -1.27342000E-03  -7.04760000E-04  +1.47300000E-05
   +1.21710000E-04  -3.10200000E-05  -5.38700000E-05  +2.56110000E-04  -3.11240000E-04
   -7.86610000E-04  -2.83040000E-04  +4.96520000E-04  -6.34400000E-05  -3.50200000E-05
   -2.06000000E-06  -1.96984000E-03  -3.91633000E-03  -3.24656000E-03  +4.20663900E-02
   +6.18290600E-02  +1.36544650E-01  +5.67689800E-02  -1.84929620E-01  +1.56815800E-02
   +3.68204000E-03  -1.14093500E-02  -2.18691000E-03  +4.28196000E-03  -1.17469000E-03
   -5.84680000E-04  -4.03200000E-05  -1.83330000E-04  +1.11282000E-03  +5.09692000E-03
   +4.64366000E-03  -2.11030000E-03  +1.49730000E-03  +4.92380000E-03  +9.02320000E-04
   -6.42250000E-04  -4.48120000E-04  +8.56900000E-05  -1.87520000E-04  -1.03400000E-04
   +5.68400000E-04  +1.40100000E-05  -7.13490000E-04  -2.81350000E-04  +2.70640000E-04
   +5.70900000E-05  +1.22960000E-04  -3.58330000E-04  -2.34160000E-04  +6.45800000E-05
   -8.09200000E-05  -3.87000000E-05  -2.78530000E-04  -2.03390000E-04  -3.45900000E-05
   -4.53800000E-05  +7.04700000E-05  +1.00940000E-04  -3.00360000E-04  -2.39150000E-04
   +2.63790000E-04  +2.57990000E-04  +2.70250000E-04  +4.22800000E-05  -1.57680000E-04
   -8.31900000E-05  -9.03000000E-06  -6.25680000E-04  -4.45880000E-04  +1.65333000E-03
   -2.74100000E-05  -4.01000000E-05  -2.89000000E-05  -7.70000000E-07  +2.87100000E-05
   -2.84000000E-06  +3.58000000E-05  +9.03900000E-05  +2.28900000E-05  +4.91000000E-06
   -1.38400000E-05  -2.75600000E-05  +1.36000000E-05  +2.29000000E-06  -8.72000000E-06
   -9.13100000E-05  +4.14600000E-05  +2.11500000E-05  +9.91000000E-06  -1.40540000E-04
   +2.73100000E-05  +5.72000000E-05  +3.01800000E-05  +4.31900000E-05  +2.33760000E-04
   -5.03270000E-04  +4.96640000E-04  +3.56000000E-06  -1.74490000E-04  +1.09300000E-05
   -3.71200000E-05  -1.93000000E-06  +1.50410000E-04  +9.68170000E-04  +3.94210000E-04
   -5.88160000E-04  +1.13470000E-04  -1.48750000E-04  +3.36400000E-05  -1.47276000E-03
   -3.93167000E-03  -1.73453000E-03  -1.48646870E-01  -6.50792300E-02  +1.89041170E-01
   -3.97450000E-04  +2.06720000E-04  -4.60520000E-04  +4.62600000E-05  -2.53990000E-04
   +6.64000000E-05  +2.75470000E-04  -2.74590000E-04  -1.03618000E-03  -1.40593000E-03
   -1.22124000E-03  +3.71162000E-03  -1.81825000E-02  +3.05124300E-02  -1.77545500E-02
   +1.60945000E-03  -9.16870000E-04  -8.98910000E-04  +8.64000000E-06  -5.01000000E-05
   +2.18800000E-04  -1.22760000E-04  +5.37000000E-05  -7.90500000E-05  -2.45328000E-02
   +5.42968000E-03  -4.68484000E-03  -1.55000000E-05  +7.82000000E-05  +8.93000000E-06
   +2.58000000E-06  -2.46100000E-05  -1.84200000E-05  -2.19000000E-06  -1.15900000E-05
   +2.14800000E-05  +5.10000000E-06  +3.41300000E-05  +1.56800000E-05  -1.01700000E-05
   -3.66400000E-05  +2.85000000E-06  -4.20000000E-06  -1.69200000E-05  -7.74000000E-06
   -2.06700000E-05  -5.38200000E-05  +5.25000000E-06  +1.66000000E-06  -6.11000000E-06
   +1.40300000E-05  -1.05818000E-03  -2.63639000E-03  -1.78196000E-03  -1.32100000E-05
   +1.53500000E-05  -8.88000000E-06  -1.37200000E-05  +1.12000000E-06  -1.83600000E-05
   +1.26000000E-06  +1.76300000E-05  +1.35600000E-05  -6.40000000E-07  +1.13100000E-05
   -8.39000000E-06  -7.29000000E-06  -2.90000000E-07  -2.13000000E-06  -1.36600000E-05
   -1.20000000E-07  +9.83000000E-06  -6.17000000E-06  -2.72800000E-05  -4.79000000E-06
   +1.47600000E-05  +7.46000000E-06  +4.26000000E-06  -3.00000000E-06  -6.09000000E-06
   +2.94600000E-05  -1.15000000E-06  -2.03100000E-05  -8.57000000E-06  -7.43000000E-06
   +1.73300000E-05  +5.53800000E-05  -3.22350000E-04  +1.30900000E-04  +1.07770000E-04
   +1.16750000E-04  +1.93800000E-05  +2.02120000E-04  -1.18789000E-03  +1.86970000E-04
   +1.44547000E-03  +4.73200000E-05  -5.99000000E-06  +5.89700000E-05  +5.01738200E-02
   +1.56731000E-03  -4.95290000E-04  +2.16772000E-03  -2.95952000E-03  -7.14140000E-04
   +2.16310000E-03  +4.34574000E-03  -7.05380000E-04  +4.86156000E-03  -1.03188800E-02
   +9.65066000E-03  -3.71417700E-02  +5.20224600E-02  -3.58963000E-02  +3.49175600E-02
   -7.52941000E-03  +3.50510000E-03  +4.40808000E-03  -1.19773000E-03  +1.38170000E-04
   -1.39332000E-03  +1.41578000E-03  -3.15460000E-04  +6.14440000E-04  -4.10383000E-02
   -8.00150800E-02  +1.83080200E-02  +3.46390000E-04  -1.07046000E-03  -3.08500000E-05
   +9.14300000E-05  +5.84800000E-05  +2.81190000E-04  +3.54770000E-04  -8.56800000E-05
   -4.06540000E-04  -9.31050000E-04  -1.24237000E-03  -3.14850000E-04  +2.27850000E-04
   +6.41730000E-04  +2.26870000E-04  -1.67220000E-04  +1.02410000E-04  +4.37570000E-04
   +1.20023000E-03  +1.46663000E-03  +1.09700000E-04  +6.30540000E-04  +6.31100000E-05
   -2.68750000E-04  +5.49196000E-03  +2.19105600E-02  +5.86059000E-03  -1.02940000E-04
   -3.02800000E-04  -4.19300000E-05  +6.91700000E-05  +1.04180000E-04  +1.44750000E-04
   -1.77140000E-04  -1.95370000E-04  -4.29660000E-04  -9.63700000E-05  -1.05350000E-04
   +4.64100000E-05  +1.00190000E-04  +5.50100000E-05  -3.69200000E-05  +3.62090000E-04
   -1.88730000E-04  -3.43200000E-05  -9.81600000E-05  +3.16440000E-04  +9.45000000E-06
   -2.58790000E-04  -3.46200000E-05  -1.23680000E-04  -1.20080000E-04  +1.35860000E-04
   +1.79000000E-06  -9.77800000E-05  +2.50060000E-04  +2.03730000E-04  +3.10420000E-04
   -3.51230000E-04  -5.08140000E-04  +2.62817000E-03  +2.19880000E-04  +5.09400000E-04
   -1.99020000E-04  -4.87360000E-04  -3.49500000E-04  +1.78124000E-03  -9.57470000E-04
   -3.32871000E-03  +2.41540000E-04  +1.79290000E-04  -3.75800000E-04  -1.74045000E-03
   -1.09134500E-02  -4.21960000E-04  +2.33450000E-04  -5.28990000E-04  +1.18870000E-04
   -1.87750000E-04  +2.71180000E-04  +8.44100000E-05  -2.32970000E-04  -1.04288000E-03
   -6.97400000E-04  -5.91900000E-05  +3.37054000E-03  -4.89419000E-03  +1.07615800E-02
   -6.71971000E-03  +5.62880000E-04  -1.13802000E-03  +8.52900000E-05  +1.79030000E-04
   +5.66200000E-05  +9.31000000E-05  -1.17430000E-04  +1.85400000E-05  -1.93900000E-05
   -2.19178700E-02  +7.26812300E-02  -3.88418500E-02  -1.38800000E-05  +1.10040000E-04
   -1.46200000E-05  -1.84700000E-05  +4.21000000E-06  -8.32000000E-06  -4.13000000E-05
   +2.95000000E-06  +5.05500000E-05  +1.21330000E-04  +1.54580000E-04  +4.04700000E-05
   -1.84400000E-05  -6.61400000E-05  -3.96600000E-05  +1.52800000E-05  -7.35000000E-06
   -5.43700000E-05  -1.50250000E-04  -1.88640000E-04  -2.15400000E-05  -8.94900000E-05
   -3.45000000E-06  +2.53500000E-05  -9.76800000E-04  -2.14424000E-03  -8.38780000E-04
   +8.47000000E-06  +4.06300000E-05  +9.71000000E-06  -1.75800000E-05  -1.76000000E-05
   -2.18600000E-05  +2.21700000E-05  +3.71500000E-05  +4.32700000E-05  +2.22700000E-05
   +4.84000000E-06  -6.62000000E-06  -8.18000000E-06  -6.19000000E-06  +4.87000000E-06
   -3.79600000E-05  +2.52100000E-05  -3.23000000E-06  +9.60000000E-06  -3.54200000E-05
   +5.46000000E-06  +2.46600000E-05  +1.83000000E-06  +3.40000000E-07  +3.26500000E-05
   -3.21000000E-06  -2.71700000E-05  +8.67000000E-06  -3.77300000E-05  -9.60000000E-06
   -4.32500000E-05  +4.30400000E-05  +2.66100000E-05  -1.66620000E-04  +1.56600000E-05
   +3.21000000E-06  +1.69900000E-05  -1.01190000E-04  +2.65780000E-04  +6.22680000E-04
   +6.04860000E-04  +6.42000000E-05  -2.13900000E-05  +2.62200000E-05  +5.20600000E-05
   +2.63684500E-02  -4.20359100E-02  +6.29536500E-02  +3.72080000E-04  +1.39400000E-05
   -8.99500000E-05  +2.71160000E-04  +1.34640000E-04  -2.35670000E-04  -4.05680000E-04
   +4.24300000E-04  -2.09810000E-04  -9.68600000E-05  -1.82420000E-04  +1.41771000E-03
   -2.60632000E-03  +3.99099000E-03  -2.28090000E-03  -2.19590000E-04  +7.94320000E-04
   +6.69180000E-04  +1.50560000E-04  -3.36900000E-05  -1.84600000E-05  -8.72200000E-05
   -2.57000000E-06  -1.39000000E-05  +6.04330000E-04  +3.21738000E-03  -3.51182000E-03
   -6.63900000E-05  +8.41200000E-05  +2.31000000E-06  -1.75500000E-05  +1.16800000E-05
   -3.92400000E-05  -5.80200000E-05  +4.31200000E-05  +3.02800000E-05  +1.54400000E-04
   +1.63050000E-04  +2.79400000E-05  -2.82200000E-05  -5.98500000E-05  -3.58200000E-05
   +3.37200000E-05  +5.18000000E-06  -5.57200000E-05  -1.75880000E-04  -1.66000000E-04
   -2.40700000E-05  -9.37000000E-05  +4.38000000E-06  +2.61300000E-05  +1.20477000E-03
   +7.87100000E-05  +1.47180000E-03  +4.37200000E-05  +2.76400000E-05  +2.00000000E-05
   +1.88200000E-05  -1.74200000E-05  +9.74000000E-06  +2.84400000E-05  -8.49000000E-06
   +5.96900000E-05  +1.23200000E-05  +5.57000000E-06  +5.46000000E-06  -7.29000000E-06
   -8.66000000E-06  +1.03200000E-05  -4.34100000E-05  +2.56600000E-05  -5.90000000E-07
   +2.17600000E-05  -1.83300000E-05  -1.60000000E-07  +2.48000000E-05  -3.25000000E-06
   +1.84400000E-05  +1.91200000E-05  -1.65700000E-05  -2.84300000E-05  +1.82300000E-05
   -1.34900000E-05  -2.21300000E-05  -4.08400000E-05  +3.44300000E-05  +2.23200000E-05
   -1.63180000E-04  -6.86600000E-05  -1.12100000E-04  -7.43200000E-05  +1.95680000E-04
   -1.92050000E-04  -1.21050000E-04  +4.96200000E-05  -7.38840000E-04  +8.11000000E-06
   -6.70100000E-05  -8.91000000E-06  -5.05200000E-03  -5.50847000E-03  +1.91561000E-03
   +9.72766000E-03  -1.36130000E-04  -4.13400000E-04  +1.98710000E-04  +9.30800000E-04
   +7.65250000E-04  -9.67260000E-04  -1.41709000E-03  +2.78580000E-04  -1.49773000E-03
   +4.14787000E-03  -2.92419000E-03  +1.26059700E-02  -1.67104300E-02  +9.38048000E-03
   -1.18560100E-02  +1.24297000E-03  +3.82060000E-04  -2.81334000E-03  +2.99220000E-04
   -1.20220000E-04  +3.53130000E-04  -3.53960000E-04  +8.04800000E-05  -1.68710000E-04
   +4.65564800E-02  -1.15043170E-01  +4.70958800E-02  -1.13120000E-04  +2.85860000E-04
   +1.97300000E-05  -1.49800000E-05  -2.85900000E-05  -9.02100000E-05  -9.73500000E-05
   +2.39000000E-05  +1.06570000E-04  +2.36970000E-04  +3.08910000E-04  +7.13700000E-05
   -5.95800000E-05  -1.61840000E-04  -4.99300000E-05  +3.75900000E-05  -3.30000000E-05
   -1.06100000E-04  -3.07650000E-04  -3.66130000E-04  -2.63500000E-05  -1.65690000E-04
   -1.70600000E-05  +6.66600000E-05  -3.37303000E-03  -8.70156000E-03  -2.53045000E-03
   +3.15300000E-05  +7.37000000E-05  +1.18400000E-05  -1.32700000E-05  -2.62400000E-05
   -3.33000000E-05  +5.21600000E-05  +4.91100000E-05  +1.14190000E-04  +2.20000000E-05
   +3.00700000E-05  -1.17300000E-05  -2.68900000E-05  -1.46500000E-05  +9.77000000E-06
   -9.98500000E-05  +4.68500000E-05  +1.71000000E-05  +2.69600000E-05  -9.04600000E-05
   -3.30000000E-06  +7.31500000E-05  +1.04100000E-05  +4.25800000E-05  +2.39000000E-05
   -3.48700000E-05  +1.78300000E-05  +2.47000000E-05  -6.97000000E-05  -5.69900000E-05
   -8.61900000E-05  +8.27600000E-05  +1.40670000E-04  -8.77470000E-04  -8.84800000E-05
   -1.68330000E-04  +3.57500000E-05  +2.33270000E-04  -2.29500000E-05  -2.78620000E-04
   -3.94160000E-04  +1.41121000E-03  -1.35100000E-04  -9.94800000E-05  +5.21800000E-05
   -2.60077000E-02  +8.59188700E-02  -2.37394200E-02  -1.14733500E-02  +8.11272200E-02
   -5.83570000E-04  +5.98620000E-04  -2.14780000E-04  -1.06200000E-04  -6.42820000E-04
   +4.57930000E-04  +5.12830000E-04  -1.33670000E-04  -1.74690000E-04  -1.28983000E-03
   +4.46120000E-04  -8.40770000E-04  -3.21388000E-03  -1.61750000E-04  -2.11910000E-04
   +1.61798000E-03  -1.39872000E-03  -4.54250000E-04  -2.77100000E-05  +8.24000000E-06
   +9.24500000E-05  -5.15400000E-05  +2.97300000E-05  -2.83000000E-05  +5.32088000E-03
   -2.89859000E-03  +1.50816000E-03  -2.70000000E-06  +1.94000000E-06  +1.61100000E-05
   -2.94000000E-06  -6.66000000E-06  -7.86000000E-06  +1.08100000E-05  +3.26000000E-06
   -1.38700000E-05  -1.41800000E-05  -1.14800000E-05  -9.00000000E-08  -4.91000000E-06
   -4.44000000E-06  +8.81000000E-06  +6.46000000E-06  +2.98000000E-06  +3.97000000E-06
   +1.60000000E-05  +2.05100000E-05  +7.57000000E-06  +2.39600000E-05  -4.60000000E-07
   +3.42000000E-06  +1.59697000E-03  +2.06914000E-03  +1.48938000E-03  +1.35000000E-06
   -5.72000000E-06  -5.88000000E-06  +7.87000000E-06  +5.15000000E-06  +4.57000000E-06
   -1.06900000E-05  -1.44200000E-05  -1.86000000E-06  -5.98000000E-06  +4.30000000E-06
   +8.00000000E-07  -2.38000000E-06  +1.12000000E-06  -8.10000000E-07  +4.14000000E-06
   -6.83000000E-06  -9.10000000E-07  -2.58000000E-06  +4.78000000E-06  -4.69000000E-06
   -2.45000000E-06  +1.12000000E-06  -1.98000000E-06  -5.45000000E-06  -9.04000000E-06
   -1.09000000E-06  +2.76000000E-06  +8.23000000E-06  -2.02000000E-06  +6.10000000E-06
   +9.05000000E-06  +1.29100000E-05  +3.91400000E-05  +1.06270000E-04  +1.02170000E-04
   +6.36500000E-05  -4.55000000E-05  +1.05850000E-04  -5.10420000E-04  +2.21310000E-04
   +2.26830000E-04  +3.95000000E-06  +5.40500000E-05  +2.88800000E-05  -4.65076000E-03
   -1.83455000E-03  -1.50607000E-02  -2.62545400E-02  +1.09651020E-01  +5.09610090E-01
   -3.16000000E-06  -3.48800000E-05  -1.21650000E-04  -1.08100000E-04  +4.23400000E-05
   +8.94000000E-06  -1.74000000E-05  -1.31890000E-04  +1.82400000E-05  +4.00560000E-04
   +2.24970000E-04  +4.32400000E-05  +4.63670000E-04  +6.47350000E-04  +1.71024000E-03
   -3.06320000E-04  -8.89900000E-05  +2.89490000E-04  -7.11600000E-05  +4.68800000E-05
   -2.78500000E-05  +6.32100000E-05  -1.25100000E-05  +2.11000000E-05  -2.14800000E-04
   +1.45242000E-03  +3.38850000E-04  +5.62800000E-05  -4.89800000E-05  -9.66000000E-06
   +6.52000000E-06  -4.70000000E-06  +3.85300000E-05  +3.79900000E-05  -2.91200000E-05
   -1.21000000E-05  -9.66400000E-05  -9.95100000E-05  -1.39900000E-05  +2.08600000E-05
   +3.77400000E-05  +1.68300000E-05  -2.19300000E-05  -6.51000000E-06  +2.72200000E-05
   +1.08450000E-04  +9.55700000E-05  +1.22200000E-05  +3.77000000E-05  +9.80000000E-07
   -1.40100000E-05  -3.27530000E-04  -1.12329000E-03  -8.90990000E-04  -3.25300000E-05
   -1.45100000E-05  -1.11200000E-05  -2.06700000E-05  +8.48000000E-06  -1.10700000E-05
   -1.79300000E-05  +1.95100000E-05  -3.86800000E-05  -4.69000000E-06  -5.41000000E-06
   -4.71000000E-06  +5.21000000E-06  +4.62000000E-06  -7.11000000E-06  +2.48200000E-05
   -1.05500000E-05  -9.70000000E-07  -1.26000000E-05  +8.22000000E-06  +5.70000000E-07
   -1.38100000E-05  +3.52000000E-06  -9.17000000E-06  -9.21000000E-06  +1.09000000E-05
   +1.38900000E-05  -1.22200000E-05  +8.08000000E-06  +1.18500000E-05  +2.52700000E-05
   -2.09200000E-05  -1.88300000E-05  +7.14100000E-05  -3.30300000E-05  +1.42900000E-05
   -5.41000000E-06  -1.62280000E-04  -2.02100000E-05  +1.94550000E-04  +2.92500000E-05
   +2.50000000E-06  +2.53000000E-05  +3.17500000E-05  +1.56900000E-05  +7.78000000E-05
   -6.45940000E-04  -4.81530000E-04  -3.35647000E-03  +8.00541000E-03  +2.75078900E-02
   +3.03299000E-03  -5.88960000E-04  +2.94780000E-04  -2.17290000E-04  +1.68250000E-04
   -3.21810000E-04  +1.09270000E-04  -1.34000000E-06  -2.12400000E-05  -5.06680000E-04
   -4.62570000E-04  -4.26810000E-04  +1.50392000E-03  +4.95300000E-04  +1.19440000E-03
   -1.42931000E-03  +6.03970000E-04  -8.03880000E-04  -6.07980000E-04  +2.20780000E-04
   -2.19300000E-05  +1.72580000E-04  -2.12440000E-04  +4.63300000E-05  -6.97600000E-05
   +4.34281000E-03  -7.46781000E-03  +2.14053000E-03  -5.06900000E-05  +1.78250000E-04
   +3.25000000E-06  -1.26600000E-05  +2.46000000E-06  -3.95200000E-05  -6.28400000E-05
   +1.13800000E-05  +8.08100000E-05  +1.83710000E-04  +2.39720000E-04  +5.97800000E-05
   -3.73600000E-05  -1.13010000E-04  -4.74800000E-05  +3.20200000E-05  -1.48700000E-05
   -8.10100000E-05  -2.26700000E-04  -2.86920000E-04  -2.21700000E-05  -1.10690000E-04
   -6.67000000E-06  +3.95500000E-05  -5.36220000E-04  -2.11560000E-04  -1.15340000E-04
   +1.37100000E-05  +6.34800000E-05  +6.96000000E-06  -1.79200000E-05  -1.88500000E-05
   -3.24800000E-05  +3.59600000E-05  +3.90500000E-05  +7.10700000E-05  +2.25100000E-05
   +1.49600000E-05  -8.57000000E-06  -1.75600000E-05  -8.38000000E-06  +6.16000000E-06
   -6.04500000E-05  +3.38000000E-05  -1.69000000E-06  +1.39800000E-05  -5.38800000E-05
   +9.10000000E-07  +4.01300000E-05  +5.31000000E-06  +9.54000000E-06  +3.18900000E-05
   -2.10000000E-05  -2.37800000E-05  +1.57300000E-05  -4.34200000E-05  -2.84800000E-05
   -5.63700000E-05  +6.62700000E-05  +6.16100000E-05  -2.07590000E-04  +1.06920000E-04
   +1.25400000E-05  +5.87000000E-05  -9.89000000E-06  +1.50130000E-04  -2.68000000E-04
   +3.59830000E-04  +2.42620000E-04  -7.67200000E-05  +7.32500000E-05  +9.85800000E-05
   -3.41119000E-03  +9.36012000E-03  -1.48182200E-02  +8.34382000E-03  -5.04505600E-02
   -1.06072300E-01  -8.20498000E-03  +4.82121600E-02  -1.23440000E-04  -1.44190000E-04
   -4.16000000E-05  +4.58680000E-04  +1.81030000E-04  -3.51910000E-04  -6.79430000E-04
   +1.23720000E-04  -6.38190000E-04  +1.40433000E-03  -8.86330000E-04  +4.11177000E-03
   -2.80744000E-03  +3.84770000E-03  -2.68307000E-03  +2.63110000E-04  -4.05000000E-05
   -7.54000000E-04  +1.81930000E-04  -1.13600000E-05  +1.55820000E-04  -1.75970000E-04
   +3.30000000E-05  -6.83500000E-05  +4.64093000E-03  -4.99682000E-03  +5.57146000E-03
   -3.99700000E-05  +1.42020000E-04  -7.66000000E-06  -2.17000000E-05  -7.70000000E-07
   -3.03500000E-05  -5.31000000E-05  +1.78700000E-05  +5.89100000E-05  +1.35180000E-04
   +1.75850000E-04  +4.57200000E-05  -2.85300000E-05  -8.59700000E-05  -3.92100000E-05
   +2.19800000E-05  -1.43100000E-05  -6.61200000E-05  -1.74410000E-04  -2.08760000E-04
   -2.23200000E-05  -9.72800000E-05  -5.09000000E-06  +3.74700000E-05  -1.22114000E-03
   -3.16569000E-03  -1.61378000E-03  +1.56700000E-05  +4.22200000E-05  +1.27900000E-05
   -1.35200000E-05  -1.99200000E-05  -1.80700000E-05  +2.96000000E-05  +3.30100000E-05
   +6.46900000E-05  +1.73200000E-05  +1.15300000E-05  -6.49000000E-06  -1.18200000E-05
   -8.95000000E-06  +5.74000000E-06  -5.14100000E-05  +2.87100000E-05  +3.27000000E-06
   +1.49500000E-05  -4.39000000E-05  +1.03000000E-06  +3.50200000E-05  +3.08000000E-06
   +1.52200000E-05  +2.10700000E-05  -1.56700000E-05  -9.91000000E-06  +1.36100000E-05
   -3.65700000E-05  -2.61400000E-05  -4.47900000E-05  +4.77100000E-05  +6.02000000E-05
   -3.35140000E-04  -5.27300000E-05  -9.92300000E-05  -1.19500000E-05  +7.96800000E-05
   +6.39000000E-05  -1.35210000E-04  +7.47800000E-05  +2.99880000E-04  -5.91800000E-05
   +4.39000000E-06  +5.60300000E-05  -9.36250000E-04  +1.33832900E-02  -4.10636000E-03
   +2.81661800E-02  -1.27844300E-01  -4.96653440E-01  -2.83979000E-02  +1.19352230E-01
   +4.96672300E-01
end_hess

