# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -806.87828090    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +2.18145750E+00  -1.34963924E+00  -1.02060640E+00
   006   +1.85868546E+00  +1.21601067E+00  -4.71636941E-01
   006   +3.57532442E+00  +2.40830180E+00  +1.12186767E+00
   006   +5.99539186E+00  +1.51666808E+00  +1.52114893E+00
   006   +6.45141599E+00  -1.80812117E+00  +5.82823482E-01
   006   +4.16518821E+00  -2.83636804E+00  -2.03783602E-01
   006   -5.80579834E-01  +2.51306302E+00  -1.35249961E+00
   006   -9.19059305E-01  +5.14207963E+00  -1.69060280E-01
   008   +8.18981552E+00  -3.25452439E+00  +1.76830213E+00
   006   -2.88789911E+00  +9.22698629E-01  -6.34224433E-01
   006   -4.75951629E+00  +2.44691402E-01  -2.33725851E+00
   006   -6.86009476E+00  -1.14469315E+00  -1.58939488E+00
   006   -7.12344632E+00  -1.88354296E+00  +9.06534836E-01
   006   -5.26642599E+00  -1.22851548E+00  +2.64688240E+00
   006   -3.19404236E+00  +1.47760869E-01  +1.86894194E+00
   008   -9.12879798E+00  -3.24495155E+00  +1.75656444E+00
   006   -3.38118918E-01  +2.87395725E+00  -4.22352649E+00
   008   +7.33079207E+00  +3.71340028E-01  -4.65540525E-01
   001   -1.02616912E+01  -3.57674562E+00  +3.87106698E-01
   001   -8.28851084E+00  -1.65086409E+00  -2.96827026E+00
   001   -4.61434913E+00  +7.83142034E-01  -4.30204677E+00
   001   -1.74782125E+00  +6.09393713E-01  +3.24214729E+00
   001   -5.47091503E+00  -1.82160717E+00  +4.59168440E+00
   001   -1.93883307E+00  +3.92670057E+00  -4.98627269E+00
   001   +1.37577449E+00  +3.93980447E+00  -4.63451926E+00
   001   -2.05825614E-01  +1.06913635E+00  -5.20794694E+00
   001   +6.61900481E-01  +6.38075978E+00  -6.36021739E-01
   001   -2.64435011E+00  +5.99803557E+00  -8.99820551E-01
   001   -1.09824463E+00  +5.04873821E+00  +1.88107135E+00
   001   +2.96679643E+00  +3.96562659E+00  +2.29925727E+00
   001   +7.17922028E+00  +2.13829534E+00  +3.06867499E+00
   001   +3.93480145E+00  -4.85909712E+00  -3.02871095E-02
   001   +5.84804656E-01  -2.32344190E+00  -1.85394573E+00
   001   +9.82766898E+00  -2.55470780E+00  +1.42850383E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -2.00000000E-08  -1.50000000E-07  +9.00000000E-08
   -8.00000000E-08  +1.40000000E-07  -6.60000000E-07
   +9.00000000E-08  +7.50000000E-07  -1.59000000E-06
   +3.40000000E-07  +9.70000000E-07  -1.72000000E-06
   +3.90000000E-07  +8.90000000E-07  -6.10000000E-07
   +9.00000000E-08  +3.80000000E-07  +7.00000000E-08
   -4.10000000E-07  -4.00000000E-07  -6.40000000E-07
   -3.10000000E-07  -2.00000000E-08  -1.45000000E-06
   +7.60000000E-07  +1.27000000E-06  -5.90000000E-07
   -1.20000000E-07  -3.30000000E-07  +4.60000000E-07
   -4.00000000E-07  -1.02000000E-06  +1.11000000E-06
   -1.60000000E-07  -9.30000000E-07  +2.01000000E-06
   +4.60000000E-07  -7.00000000E-08  +2.31000000E-06
   +8.60000000E-07  +6.90000000E-07  +1.72000000E-06
   +5.30000000E-07  +5.50000000E-07  +7.50000000E-07
   +6.80000000E-07  +2.00000000E-08  +3.31000000E-06
   -1.06000000E-06  -1.37000000E-06  -8.10000000E-07
   +0.00000000E+00  +5.60000000E-07  -1.71000000E-06
   +4.30000000E-07  -5.10000000E-07  +3.61000000E-06
   -4.60000000E-07  -1.53000000E-06  +2.51000000E-06
   -9.20000000E-07  -1.71000000E-06  +8.90000000E-07
   +7.20000000E-07  +1.09000000E-06  +2.40000000E-07
   +1.25000000E-06  +1.29000000E-06  +1.97000000E-06
   -1.28000000E-06  -1.78000000E-06  -8.00000000E-07
   -1.26000000E-06  -1.40000000E-06  -1.56000000E-06
   -1.13000000E-06  -1.66000000E-06  -2.00000000E-07
   -5.40000000E-07  -7.00000000E-08  -2.24000000E-06
   -5.20000000E-07  -4.00000000E-07  -1.37000000E-06
   +1.50000000E-07  +6.90000000E-07  -1.43000000E-06
   +3.40000000E-07  +1.11000000E-06  -1.96000000E-06
   +6.20000000E-07  +1.69000000E-06  -2.24000000E-06
   +4.50000000E-07  +3.70000000E-07  +9.00000000E-07
   -1.00000000E-07  -4.60000000E-07  +8.20000000E-07
   +6.10000000E-07  +1.34000000E-06  -1.19000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.21826430E-01  -4.29481300E-02  +6.56025670E-01  +2.20756200E-01  +7.18775800E-02
   +2.65080080E-01  -1.17953060E-01  +5.73183800E-02  -6.13783000E-03  +5.10618280E-01
   -1.12571400E-02  -2.88870080E-01  -5.44353500E-02  -2.86122900E-02  +5.96534670E-01
   -2.60210600E-02  -3.63651300E-02  -7.94744700E-02  +1.84633000E-01  +1.27432920E-01
   +3.45353370E-01  +4.06889900E-02  -6.50732100E-02  -9.75423000E-03  -1.95639380E-01
   -1.67845300E-02  -8.00348700E-02  +6.43280270E-01  -1.46355900E-02  -2.86513600E-02
   -2.31686300E-02  -6.93259500E-02  -1.45473490E-01  -9.05017000E-02  -1.17523360E-01
   +4.98629650E-01  +5.54742000E-03  -4.14242600E-02  -8.16487000E-03  -1.14731750E-01
   -7.12240600E-02  -1.67336760E-01  +1.19648090E-01  +2.51990170E-01  +4.10729580E-01
   -1.60942600E-02  +3.12380700E-02  +4.40455000E-03  -4.09522400E-02  -2.69177800E-02
   -3.70355700E-02  -3.30411180E-01  +1.02845170E-01  -4.80336300E-02  +6.63504900E-01
   +3.05222100E-02  -6.33015500E-02  -2.02865000E-03  +1.73073800E-02  +6.77574400E-02
   +3.92771300E-02  +2.14102900E-02  -9.74787800E-02  -3.50608100E-02  -6.61049200E-02
   +1.71909150E-01  -1.15851600E-02  +1.28972700E-02  -5.20724000E-03  -2.83588100E-02
   -9.26446000E-03  -9.34475000E-03  -4.77040700E-02  +5.23767000E-03  -9.00612400E-02
   +1.45029100E-01  +1.78849140E-01  +4.84663500E-01  -4.57425200E-02  +1.89440600E-02
   -2.26396100E-02  -2.81135000E-03  -2.45739600E-02  -6.28619000E-03  +9.17296000E-03
   +1.21865500E-02  +1.14924200E-02  +1.83723000E-03  +5.79390000E-04  -2.46388400E-02
   +6.96866370E-01  -3.05783500E-02  +8.01633600E-02  -5.17487000E-03  -1.99397200E-02
   -6.16503000E-02  -3.14929600E-02  +7.00167400E-02  -8.66108000E-03  +3.82131400E-02
   -1.59437200E-02  +5.09754100E-02  -6.39830000E-02  +8.02998700E-02  +4.40313930E-01
   -4.11020900E-02  +4.47564300E-02  -7.45156000E-03  -1.58388500E-02  -3.94631400E-02
   -2.59478400E-02  +5.57591600E-02  -1.01364200E-02  +1.61534700E-02  -3.92737700E-02
   +7.77066300E-02  -1.30002600E-02  +1.49663680E-01  -1.94674130E-01  +2.56608960E-01
   -2.43182770E-01  +6.76713300E-02  -8.05450800E-02  +2.03953000E-02  +7.28851200E-02
   +2.55897000E-02  -5.34132500E-02  -3.20828000E-03  -2.66137600E-02  +1.97534900E-02
   -6.55461800E-02  +2.02422700E-02  -2.80480680E-01  -2.02338400E-02  -2.73593400E-02
   +6.36402220E-01  +1.30902060E-01  -2.00317030E-01  +5.66461800E-02  +2.20323200E-02
   -3.10942900E-02  +3.47372000E-03  +7.12046000E-03  -3.19048000E-03  +5.21185000E-03
   -1.14486700E-02  -5.90916000E-03  +5.59183000E-03  -1.06169970E-01  -1.33946390E-01
   -3.17965500E-02  +2.22865000E-03  +7.30234470E-01  -8.05937800E-02  +3.09491100E-02
   -9.54486700E-02  +8.60214000E-03  +2.19193900E-02  +1.65824200E-02  -2.20034800E-02
   -4.48609000E-03  -1.03922400E-02  +1.23199800E-02  -4.25158100E-02  +3.21454000E-03
   -7.39163400E-02  +1.39890000E-02  -6.65108700E-02  +1.77294950E-01  -6.23958800E-02
   +1.99907820E-01  -4.78148000E-03  +1.01192300E-02  -6.61680000E-04  -1.38916290E-01
   +3.32771400E-02  -2.62195700E-02  -2.15162800E-02  +6.26494000E-03  -1.00688200E-02
   +2.63612000E-03  -1.75802000E-03  -4.79631000E-03  -3.02275000E-03  +2.39690000E-04
   +5.07120000E-04  +3.52644000E-03  -6.64360000E-04  -1.42582000E-03  +4.73811870E-01
   +2.80793400E-02  -1.61964500E-02  +8.78245000E-03  +3.53867500E-02  -1.01176270E-01
   +6.62903000E-03  -1.11824300E-02  +1.05391300E-02  -1.04860000E-03  -9.27440000E-04
   -4.27570000E-04  -4.75745000E-03  +1.77400000E-04  -1.03961000E-03  -3.70350000E-04
   -1.21582000E-03  -3.26633000E-03  -2.04214000E-03  +2.14482000E-03  +4.80527400E-01
   +7.28668000E-03  +3.05978000E-03  +4.60077000E-03  -2.76140800E-02  +3.11630000E-04
   -8.47561100E-02  -1.01353300E-02  +8.38964000E-03  +1.15590000E-03  -4.95019000E-03
   +3.75970000E-04  +2.21462000E-03  +1.87470000E-04  -2.92107000E-03  -2.96485000E-03
   -5.25490000E-04  -4.91823000E-03  +4.37007000E-03  -2.41863000E-03  +2.21189000E-03
   +4.79361900E-01  -5.02736000E-03  +1.45860000E-03  -2.22159000E-03  -4.65939000E-03
   +2.74429700E-02  +1.18434000E-02  -1.74032000E-03  +1.60294000E-03  -8.30610000E-04
   +3.32740000E-04  +6.96610000E-04  +5.33430000E-04  +5.78560000E-04  -3.14840000E-04
   +1.06200000E-04  +4.67750000E-04  +1.39293000E-03  +1.46040000E-04  -7.66824000E-02
   +7.01990000E-03  +3.62657000E-03  +5.85275040E-01  +1.68330000E-03  +3.14640000E-04
   +5.44810000E-04  +8.14361000E-03  -1.75615200E-02  -5.68058000E-03  -3.13200000E-04
   -2.98550000E-04  +7.22820000E-04  -9.37740000E-04  +1.22900000E-05  -2.42280000E-04
   +2.08970000E-04  +5.23800000E-05  -2.09260000E-04  -3.38320000E-04  -4.29210000E-04
   -1.96300000E-04  +1.36087200E-02  -1.55269150E-01  -3.82834800E-02  +1.57305800E-02
   +4.78875990E-01  -2.87611000E-03  +5.57440000E-04  -7.21360000E-04  +8.37040000E-04
   +1.04037800E-02  +5.49751000E-03  -8.46680000E-04  +1.11271000E-03  -8.42270000E-04
   +1.13640000E-04  -4.08400000E-05  -8.99000000E-06  +5.36920000E-04  +3.03070000E-04
   +2.08170000E-04  -3.33380000E-04  +7.66160000E-04  +5.86300000E-05  +4.58071000E-03
   -3.48789900E-02  -9.17939000E-02  +6.53578000E-03  -4.21063200E-02  +5.72533840E-01
   -1.18260000E-03  -5.13415000E-03  +9.99290000E-04  -1.82661000E-03  +1.24975000E-03
   -5.18800000E-04  +1.84944000E-03  +5.17870000E-04  -3.12180000E-04  -1.00797500E-02
   +1.28069500E-02  +2.26820000E-03  -2.09636160E-01  +8.63031600E-02  -1.01605770E-01
   -3.62106500E-02  +2.81913600E-02  -2.40706400E-02  +1.91903000E-03  -4.12690000E-04
   -7.95540000E-04  -4.97040000E-04  -1.24920000E-04  -2.62540000E-04  +6.66972310E-01
   +1.47318000E-03  -7.96037000E-03  -1.51678000E-03  +2.81734000E-03  +4.22386000E-03
   +2.54030000E-03  -5.37949000E-03  +3.99400000E-05  -2.63655000E-03  +5.94837000E-03
   -1.57572800E-02  +1.45358000E-02  +5.11382700E-02  -1.35990060E-01  +8.03703100E-02
   -9.12560000E-03  +1.31464700E-02  -4.37275000E-03  -9.56500000E-04  +6.53880000E-04
   +6.47060000E-04  +2.63230000E-04  +1.01930000E-04  +9.17000000E-05  +7.70405100E-02
   +2.94329100E-01  +1.41226000E-03  -3.35337000E-03  +6.16514000E-03  +6.14620000E-04
   +3.08682000E-03  -2.70920000E-04  -2.08409000E-03  +2.46579000E-03  +2.00059000E-03
   -1.17006000E-03  -5.33940000E-04  +6.11078000E-03  -5.21355700E-02  +7.71033900E-02
   -1.08999410E-01  -2.14457300E-02  +9.31360000E-03  -2.93700000E-03  +8.67440000E-04
   -1.17360000E-04  -4.85890000E-04  -2.24560000E-04  -1.93000000E-05  -9.80000000E-05
   +2.11293000E-02  -1.67857470E-01  +1.46285110E-01  -1.53207000E-03  -6.66080000E-04
   +6.40160000E-04  -3.33465800E-02  -1.10820800E-02  +1.15651000E-03  -2.16671000E-03
   +8.43990000E-04  +1.09840000E-03  +1.97050000E-04  +1.87760000E-04  -1.05160000E-03
   -5.43100000E-05  +2.07980000E-04  -8.83000000E-05  -1.72000000E-04  -7.15630000E-04
   -2.30240000E-04  -1.37331960E-01  -4.46118600E-02  +1.65457300E-02  -4.22670000E-04
   -9.20977000E-03  -3.39065000E-03  +6.45600000E-05  -1.39800000E-05  +4.84100000E-05
   +5.34296930E-01  +3.21516000E-03  -1.10757000E-03  -3.24400000E-05  +3.22914000E-03
   +9.45694000E-03  -4.03478000E-03  +1.76430000E-03  -1.41478000E-03  +3.95970000E-04
   +1.86050000E-04  -5.08850000E-04  +9.15380000E-04  -8.93590000E-04  +4.96600000E-04
   +9.65800000E-05  +5.17000000E-04  -9.69800000E-05  -1.37100000E-04  -4.37098000E-02
   -1.00515510E-01  +1.64220000E-02  -2.61527300E-02  -2.74289100E-02  +3.98171000E-03
   +7.39470000E-04  -5.38490000E-04  +3.81020000E-04  +1.86575170E-01  +3.14829530E-01
   +1.10000000E-05  -3.42510000E-04  +4.94700000E-04  -8.39984000E-03  -8.44147000E-03
   +2.39374000E-03  -1.93238000E-03  +1.55868000E-03  -4.18670000E-04  -3.62000000E-05
   +3.84470000E-04  -1.13759000E-03  +3.12480000E-04  -5.81830000E-04  -1.61030000E-04
   +1.98990000E-04  +3.43420000E-04  -2.82300000E-05  +1.29871200E-02  +1.44890600E-02
   -9.46996900E-02  -1.10238200E-02  -6.07307000E-03  +4.16084000E-03  -3.05910000E-04
   +3.06030000E-04  -1.24340000E-04  +7.49346200E-02  -6.80675700E-02  +6.43758410E-01
   +7.46740000E-04  -3.60810000E-04  -5.58000000E-04  -9.45390000E-04  -1.60773000E-03
   +3.58180000E-04  -9.06990000E-04  +4.26580000E-04  -3.72380000E-04  +1.01320000E-04
   -2.23610000E-04  -1.18920000E-04  +9.00400000E-05  +2.89630000E-04  +2.70710000E-04
   -2.49900000E-04  +2.35020000E-04  -2.45300000E-04  -1.69953200E-02  -8.02067000E-03
   -1.23661400E-02  -6.18710000E-04  +1.67227000E-03  +5.40300000E-05  +7.79000000E-06
   -9.28000000E-06  -1.53200000E-05  -2.18697910E-01  -7.15600500E-02  -6.98568800E-02
   +5.49699520E-01  +7.29740000E-04  -3.28340000E-04  -3.79480000E-04  +6.43770000E-04
   -1.90135000E-03  +2.46440000E-04  -8.07610000E-04  +5.49610000E-04  -2.56380000E-04
   +1.29310000E-04  -3.24450000E-04  -8.74300000E-05  +1.25620000E-04  +2.74600000E-04
   +2.42600000E-04  -2.76610000E-04  +3.99170000E-04  -1.92470000E-04  -1.32021400E-02
   -2.15076000E-03  -1.01250400E-02  -1.21503000E-03  -4.84180000E-04  +3.55710000E-04
   +3.15700000E-05  -5.80000000E-06  +5.01000000E-06  -5.74942500E-02  -9.86439800E-02
   -6.29381000E-03  +2.25346890E-01  +2.97213440E-01  +3.64440000E-04  -3.99700000E-04
   -3.62070000E-04  +2.11473000E-03  +1.96092000E-03  -5.33040000E-04  +4.72430000E-04
   -3.10540000E-04  +1.33130000E-04  +4.07000000E-06  -2.00050000E-04  +3.42810000E-04
   -3.05990000E-04  +1.80190000E-04  +8.59800000E-05  +1.35740000E-04  +1.52410000E-04
   +1.07400000E-05  +3.78472000E-03  -8.34970000E-04  +1.13742300E-02  +1.50286000E-03
   +1.05882000E-03  -5.64240000E-04  +3.09200000E-04  -1.82700000E-04  +1.25660000E-04
   -1.29919640E-01  -3.93195100E-02  -2.16563750E-01  +4.81165500E-02  -1.07883240E-01
   +7.22703880E-01  -3.26920000E-04  -1.08530000E-04  +2.38370000E-04  -9.17100000E-05
   -5.54120000E-04  +2.20640000E-04  +1.21710000E-04  +4.79200000E-05  +2.18770000E-04
   -2.46000000E-05  +2.37810000E-04  -9.55400000E-05  +2.43490000E-04  -3.08010000E-04
   -1.49500000E-04  +1.18310000E-04  +3.52100000E-05  +1.35160000E-04  +1.22408000E-03
   -2.04804000E-03  -3.71604000E-03  -1.54445000E-03  -7.66140000E-04  +4.03930000E-04
   -2.07090000E-04  +1.66650000E-04  -7.98200000E-05  -4.15209400E-02  -1.81471800E-02
   -4.24067900E-02  -2.46663310E-01  -1.25417730E-01  +7.15862100E-02  +5.83583820E-01
   -5.47380000E-04  -2.88280000E-04  +7.83300000E-05  -1.03731000E-03  -1.11819000E-03
   +3.58410000E-04  -7.76700000E-05  +2.19420000E-04  +2.49650000E-04  -5.72300000E-05
   +2.94820000E-04  -1.85080000E-04  +2.84150000E-04  -3.42680000E-04  -1.28940000E-04
   +2.56400000E-05  +3.91800000E-05  +1.69250000E-04  -2.71683000E-03  +5.44873000E-03
   -2.35200000E-04  +6.14050000E-04  +3.37990000E-04  +5.51300000E-05  -2.46700000E-04
   +2.16470000E-04  -1.21950000E-04  -2.90323100E-02  -6.13720000E-04  -3.68292600E-02
   -1.10901970E-01  -1.38635610E-01  +6.09557900E-02  +2.46966390E-01  +2.88129520E-01
   +3.77140000E-04  -1.30190000E-04  -2.22770000E-04  -2.17290000E-04  -1.37340000E-04
   -6.88600000E-05  -3.33540000E-04  +5.26000000E-05  -2.28340000E-04  +9.06800000E-05
   -3.28570000E-04  +5.03400000E-05  -3.01460000E-04  +4.17640000E-04  +1.37900000E-04
   -6.55800000E-05  +7.31800000E-05  -1.33330000E-04  -2.97413000E-03  +1.15137000E-03
   -1.84983000E-03  +1.11856000E-03  +6.97480000E-04  -6.47050000E-04  +3.11200000E-04
   -2.16210000E-04  +1.47010000E-04  +3.64089000E-03  -1.10663500E-02  +6.04120900E-02
   +1.15994200E-02  +2.68017400E-02  -1.42316650E-01  +8.00375000E-02  -8.61443100E-02
   +6.90018010E-01  -2.98900000E-05  -2.54040000E-04  -2.02900000E-05  -1.87680000E-04
   +2.97580000E-04  -1.67950000E-04  +1.54320000E-04  -2.27750000E-04  +6.88500000E-05
   -8.68600000E-05  -1.34820000E-04  +1.74050000E-04  -9.78070000E-04  +4.66200000E-04
   -1.44650000E-04  +3.54090000E-04  +1.59700000E-04  -3.29400000E-05  -2.30129000E-03
   -4.96930000E-04  -1.97230000E-04  +4.74830000E-04  +1.11700000E-05  -1.31060000E-04
   +8.08700000E-04  -4.64610000E-04  +3.45070000E-04  -9.02861000E-03  +5.01828000E-03
   -3.15327500E-02  +2.45396200E-02  +4.36943000E-03  +3.50082600E-02  -1.20018550E-01
   -3.80345000E-02  +3.53673100E-02  +5.85207120E-01  +2.52700000E-05  -1.58460000E-04
   +2.38800000E-05  -1.05700000E-04  +5.59900000E-04  -3.25470000E-04  +1.51320000E-04
   -1.44810000E-04  +2.44700000E-05  -6.39700000E-05  -1.54710000E-04  +1.43550000E-04
   -6.42850000E-04  +3.64160000E-04  -7.89200000E-05  +2.16480000E-04  +2.69200000E-05
   -4.50400000E-05  -5.72020000E-04  -6.04180000E-04  +2.98470000E-04  +4.73800000E-04
   +2.12160000E-04  -1.18860000E-04  +5.29910000E-04  -3.35900000E-04  +2.39860000E-04
   +4.44375000E-03  -3.11275000E-03  -9.30720000E-04  -7.46109000E-03  -6.99578000E-03
   +2.00314600E-02  -2.09831000E-02  -9.96875200E-02  +7.91183900E-02  +2.29427100E-01
   +3.16952420E-01  -5.57950000E-04  +3.23500000E-05  +4.01990000E-04  -4.45300000E-04
   -8.10580000E-04  +3.51610000E-04  +2.71940000E-04  +4.67900000E-05  +3.37680000E-04
   -1.36880000E-04  +5.17390000E-04  -2.00390000E-04  +4.25180000E-04  -6.06240000E-04
   -2.51760000E-04  +1.36470000E-04  -7.40900000E-05  +2.06040000E-04  -9.79040000E-04
   -4.03790000E-04  -2.11491000E-03  -1.15343000E-03  -5.56820000E-04  +8.34130000E-04
   -4.24290000E-04  +3.15630000E-04  -1.89860000E-04  -2.83816400E-02  +6.76450000E-04
   -7.82172900E-02  +8.69621600E-02  +4.92217600E-02  +2.87011000E-03  -3.69540000E-02
   +3.70443700E-02  -3.17754620E-01  +6.17156200E-02  -9.13660100E-02  +6.99049520E-01
   +3.64980000E-04  -1.42200000E-05  -3.65460000E-04  +3.49150000E-04  +1.96260000E-04
   +8.68000000E-05  -2.89450000E-04  +1.72630000E-04  -1.80280000E-04  +1.64140000E-04
   -2.25460000E-04  +4.03800000E-05  +2.79670000E-04  +1.34890000E-04  +2.41830000E-04
   -3.11360000E-04  +2.25400000E-05  -1.61120000E-04  +4.10506000E-03  -5.45030000E-04
   -8.96970000E-04  +2.52000000E-05  -4.00700000E-05  -2.79600000E-04  -1.89470000E-04
   +8.07800000E-05  -8.79500000E-05  +1.90652300E-02  -1.10973200E-02  +7.79327500E-02
   -5.76526400E-02  -2.72781000E-02  -1.47974500E-02  +3.78304000E-02  +2.97959800E-02
   -5.42235900E-02  -1.95792140E-01  -5.73797000E-02  -6.28066200E-02  +5.69912630E-01
   +2.77490000E-04  +1.34310000E-04  -3.94150000E-04  +3.83170000E-04  -2.16310000E-04
   -2.55890000E-04  -3.41900000E-04  +1.46680000E-04  -3.14710000E-04  +6.45200000E-05
   -1.84640000E-04  +2.74000000E-05  -1.75400000E-05  +1.10940000E-04  +1.20560000E-04
   -2.15950000E-04  +3.76300000E-05  -1.68810000E-04  -2.82120000E-04  +4.41941000E-03
   +2.21690000E-03  +5.73390000E-04  +5.84400000E-04  -3.82210000E-04  +2.48000000E-06
   -3.70000000E-07  -1.72100000E-05  -1.13521000E-03  -3.19164000E-03  +4.57689200E-02
   -2.79797900E-02  -1.70783700E-02  -7.78797000E-03  +1.99293300E-02  +2.46459600E-02
   -1.97924700E-02  -4.04599900E-02  -9.52314400E-02  +1.94762000E-03  +2.44733940E-01
   +3.01368030E-01  +6.95100000E-05  -1.99320000E-04  +5.12000000E-05  -8.08410000E-04
   +8.28500000E-05  +1.38690000E-04  -5.94400000E-05  -9.19000000E-06  +1.18700000E-04
   +1.84920000E-04  -1.04850000E-04  +2.93500000E-05  +3.45340000E-04  -5.20600000E-05
   +1.25870000E-04  -2.04960000E-04  -2.24300000E-05  -3.99900000E-05  -1.16441000E-03
   +9.39680000E-04  -5.25484000E-03  -3.73340000E-04  -4.40980000E-04  -6.93600000E-05
   -2.40590000E-04  +1.35850000E-04  -1.11920000E-04  +3.12224100E-02  +1.94500200E-02
   +4.35042000E-03  -1.40713100E-02  -7.25432000E-03  -6.33332000E-03  -1.23250300E-02
   +4.38501000E-03  -4.02793000E-02  -1.31722890E-01  -3.82598800E-02  -2.29656030E-01
   +3.38191800E-02  -1.23865730E-01  +7.23348010E-01  -1.19723000E-03  -2.89000000E-06
   +9.74730000E-04  -5.67450000E-04  -1.24062000E-03  +2.60820000E-03  +5.59550000E-04
   +6.22200000E-05  +6.62660000E-04  -2.36950000E-04  +4.69160000E-04  -5.73300000E-05
   +8.57800000E-05  -2.71640000E-04  -2.48520000E-04  +2.39750000E-04  -2.23200000E-05
   +1.42840000E-04  -3.91162000E-03  -8.39139000E-03  +2.62644800E-02  -6.59580000E-04
   +3.86160000E-04  +1.62982000E-03  -1.19400000E-04  +1.06740000E-04  -5.66700000E-05
   -1.16256640E-01  -2.24263100E-02  -1.91974100E-02  +3.79570100E-02  +2.00388500E-02
   -1.53832800E-02  -2.11062100E-02  -1.60590600E-02  +2.48445100E-02  -4.60283800E-02
   -1.77335500E-02  -4.19158800E-02  -2.63934850E-01  -1.35919260E-01  +7.83323900E-02
   +6.08196600E-01  +4.20600000E-04  -4.18360000E-04  -5.21110000E-04  +7.44600000E-04
   -1.66700000E-04  +8.19510000E-04  -1.60550000E-04  +8.48000000E-05  -6.99400000E-05
   +7.44500000E-05  -2.39900000E-05  +1.19000000E-05  +4.04800000E-05  +3.36200000E-05
   +1.38440000E-04  -6.77600000E-05  +3.46420000E-04  -3.19800000E-05  -5.17923000E-03
   -5.53605000E-03  +1.76706900E-02  -1.32378000E-03  -4.31780000E-04  +1.32017000E-03
   +1.29300000E-05  +4.44300000E-05  -2.23100000E-05  -3.61568900E-02  -1.02616670E-01
   +4.25590800E-02  +3.12757400E-02  +2.49387900E-02  +4.88530000E-03  -1.73039500E-02
   -1.88156000E-02  +2.31654600E-02  -2.98208400E-02  -4.94181000E-03  -4.09847600E-02
   -1.20975990E-01  -1.45847450E-01  +6.70112800E-02  +2.42484420E-01  +3.05517500E-01
   +4.15910000E-04  +9.57930000E-04  -2.62350000E-04  -3.66000000E-06  +3.19920000E-04
   -4.68250000E-04  -4.31870000E-04  -1.02430000E-04  -4.72290000E-04  -7.98100000E-05
   +1.72200000E-05  -2.18600000E-04  -1.93000000E-04  +2.11500000E-04  -9.70000000E-06
   -1.74020000E-04  -2.05850000E-04  -1.78990000E-04  +9.04265000E-03  +6.91956000E-03
   -4.82879000E-03  -2.82850000E-04  -9.44630000E-04  -2.63030000E-04  +6.84000000E-05
   -1.03830000E-04  +4.03900000E-05  +4.10992000E-02  +7.64787400E-02  -2.89714340E-01
   -6.16434900E-02  -2.16777200E-02  -4.83496500E-02  +2.93874400E-02  +2.59243000E-02
   -4.17026200E-02  +9.01602000E-03  -1.19084700E-02  +7.30579300E-02  +1.76504400E-02
   +3.21383400E-02  -1.51706040E-01  +7.72494200E-02  -8.43176500E-02  +6.65850800E-01
   -2.08250000E-04  +1.66370000E-04  +6.44100000E-05  +6.45700000E-05  -7.65260000E-04
   +5.11830000E-04  -1.43120000E-04  +3.02690000E-04  +9.40400000E-05  +7.33800000E-05
   +3.34650000E-04  -2.45730000E-04  +1.20927000E-03  -6.90990000E-04  +8.34400000E-05
   -3.94190000E-04  -1.11370000E-04  +8.57400000E-05  +1.63256000E-03  +5.56080000E-04
   -7.59900000E-04  -1.25648000E-03  -2.32260000E-04  +6.26970000E-04  -1.01778000E-03
   +6.25370000E-04  -4.53410000E-04  -1.47756000E-03  -7.40460000E-04  +5.38452000E-03
   +6.01230000E-04  -3.56667000E-03  -2.22422000E-03  -1.07134500E-02  -1.41053200E-02
   +9.32927000E-03  -2.15398100E-01  -1.15987020E-01  +7.06843800E-02  -4.27108000E-02
   -3.05975700E-02  +7.27476000E-03  +3.98891000E-03  +9.71670000E-04  -6.10720000E-03
   +4.83366530E-01  -1.65370000E-04  +8.46800000E-05  +3.26600000E-05  +9.62000000E-05
   -4.93550000E-04  +4.29500000E-04  -7.55800000E-05  +2.20230000E-04  +7.74700000E-05
   +5.04200000E-05  +2.34880000E-04  -1.65640000E-04  +7.93370000E-04  -5.02090000E-04
   +5.85300000E-05  -2.64970000E-04  -6.16600000E-05  +6.09000000E-05  +1.33958000E-03
   -3.22740000E-04  -7.50770000E-04  -9.28480000E-04  -2.36860000E-04  +4.29520000E-04
   -6.78270000E-04  +4.41970000E-04  -3.10870000E-04  -8.19260000E-04  -1.69188000E-03
   +1.43732000E-03  -1.98987000E-03  +6.28891000E-03  +1.85642000E-03  -2.21561200E-02
   -5.65971000E-03  +1.10858900E-02  -1.05432110E-01  -1.19439350E-01  +6.19724900E-02
   -2.23692800E-02  -6.18711000E-03  +1.72418000E-03  -5.17810000E-04  +4.55155000E-03
   -6.34000000E-05  +2.22708870E-01  +1.57269570E-01  +1.07360000E-04  -1.05350000E-04
   -4.28600000E-05  +9.03000000E-06  +3.86670000E-04  -1.65320000E-04  +3.42000000E-05
   -1.19960000E-04  -3.25300000E-05  +1.47300000E-05  -1.71320000E-04  +1.04180000E-04
   -3.90670000E-04  +2.79800000E-04  -2.21000000E-06  +9.72100000E-05  +4.57000000E-05
   -3.30300000E-05  -2.50160000E-04  -1.54190000E-04  +6.40420000E-04  +5.19050000E-04
   +1.22890000E-04  -3.12480000E-04  +3.45280000E-04  -2.18800000E-04  +1.62490000E-04
   +3.30874000E-03  +6.81400000E-05  +5.71006000E-03  -9.50733000E-03  -2.26291000E-03
   -5.68215000E-03  +4.37893700E-02  +3.11503900E-02  -1.46837300E-02  +2.60099000E-02
   +3.61038800E-02  -1.32685350E-01  -2.68595400E-02  -1.81214100E-02  +1.79112000E-02
   -4.11400000E-05  +3.45916000E-03  -9.65365000E-03  +1.73795980E-01  -5.07800000E-03
   +4.74035240E-01  -7.99510000E-04  +8.48110000E-04  -1.08755000E-03  -2.73196000E-03
   +3.86385000E-03  -3.08682300E-02  +4.20160000E-04  +2.24858000E-03  +8.23280000E-04
   -2.06476000E-03  +1.53174000E-03  +7.40930000E-04  +1.41009000E-03  -1.33806000E-03
   -1.34771000E-03  +3.33000000E-05  -7.37270000E-04  +7.68390000E-04  -7.59025600E-02
   -1.33018000E-03  +3.72021000E-03  -1.53200000E-05  +9.86500000E-04  +4.68426000E-03
   -1.27403000E-03  +8.43100000E-04  -4.56200000E-04  -3.03572000E-03  -4.03467000E-03
   +2.87326600E-02  -1.71124000E-03  -6.23860000E-04  +1.14447000E-03  +1.13500000E-04
   -3.04900000E-05  +8.67080000E-04  +3.66410000E-04  +2.02100000E-04  -2.22430000E-04
   +3.42680000E-04  -5.05850000E-04  +1.34652000E-03  -4.63766000E-03  -2.94100000E-03
   -1.45570000E-04  -5.45060000E-04  -3.84240000E-04  +1.82620000E-04  +5.84645230E-01
   +1.15962000E-03  -5.85330000E-04  +1.12183000E-03  +3.46163000E-03  -2.88723000E-03
   +1.82394500E-02  -1.31968000E-03  -1.46196000E-03  -7.29630000E-04  +1.26251000E-03
   -1.33841000E-03  -5.93150000E-04  -6.12230000E-04  +9.59270000E-04  +9.81620000E-04
   -9.45900000E-05  +4.68770000E-04  -6.28780000E-04  -3.28498000E-03  -7.61552400E-02
   +1.30109300E-02  +3.08249000E-03  -8.29060000E-04  -3.46947800E-02  +6.39740000E-04
   -5.37630000E-04  +2.57000000E-04  -3.43937000E-03  -3.47441000E-03  +2.08541900E-02
   -9.90970000E-04  -1.27981000E-03  +7.44100000E-05  +4.18210000E-04  -1.23210000E-04
   +6.77910000E-04  +7.98000000E-06  +1.86920000E-04  +1.31510000E-04  +1.30700000E-05
   -2.73060000E-04  +9.19090000E-04  -3.48639000E-03  -1.16394000E-03  -1.45410000E-04
   -1.92200000E-04  -1.51070000E-04  +7.63600000E-05  -1.37023000E-03  +5.86526390E-01
   +1.16360000E-03  -8.28690000E-04  -2.65110000E-04  -1.12602500E-02  +7.77527000E-03
   -1.97024000E-02  +1.76140000E-03  +8.18950000E-04  +3.47290000E-04  -5.09940000E-04
   +2.15920000E-04  +2.98300000E-04  -1.85970000E-04  -4.07840000E-04  -6.47600000E-05
   +9.50400000E-05  -5.37580000E-04  +2.45190000E-04  +1.13762100E-02  +1.02541800E-02
   -1.70590960E-01  +2.63763000E-03  -6.03163000E-03  -2.56371800E-02  +1.30010000E-04
   -8.55900000E-05  +3.68500000E-05  +6.99981000E-03  +4.08652000E-03  -1.04473800E-02
   -8.71860000E-04  -1.99000000E-04  +4.77620000E-04  -4.62250000E-04  -7.55300000E-05
   -4.48180000E-04  +2.84800000E-04  +1.38110000E-04  +7.02000000E-05  -4.35390000E-04
   -6.35700000E-05  -1.69340000E-04  +2.94760000E-04  -3.87560000E-04  +4.86900000E-04
   -3.00820000E-04  -1.96470000E-04  +4.79900000E-05  +1.37795100E-02  +2.13306800E-02
   +4.64963240E-01  -5.56084000E-03  +7.42577000E-03  -1.20109000E-03  -4.58510000E-04
   -7.75197000E-03  -3.35664000E-03  -6.44481000E-03  +1.51042700E-02  +3.98357500E-02
   -1.21113580E-01  +7.40610700E-02  +6.78483200E-02  -1.22000720E-01  -1.13680850E-01
   +1.69401100E-02  +4.56415000E-03  -2.75428200E-02  +2.40016600E-02  +1.32183000E-03
   +4.47990000E-04  -1.09789000E-03  -5.14290000E-04  +3.58200000E-05  -1.35460000E-04
   +1.80740400E-02  +2.89423900E-02  -1.57258400E-02  +2.28390000E-04  +2.67860000E-04
   -1.03630000E-04  +1.09610000E-04  +1.01080000E-04  +1.45430000E-04  -1.47760000E-04
   -1.29480000E-04  +1.95560000E-04  +4.61580000E-04  +2.93980000E-04  -2.59020000E-04
   -7.61100000E-05  +4.62500000E-05  -1.55090000E-04  -4.73600000E-05  +4.46900000E-05
   +1.24410000E-04  -5.69350000E-04  -3.64650000E-04  +1.84310000E-04  -9.33310000E-04
   +3.23050000E-04  -1.45500000E-04  +2.22638420E-01  +7.89976000E-03  +2.61327000E-03
   +5.32992000E-03  -8.36886000E-03  -1.81851000E-03  -5.03377000E-03  +3.11441000E-02
   -1.83857100E-02  -2.21757600E-02  +2.84781500E-02  -3.85784200E-02  -5.66079000E-02
   -6.41235400E-02  -2.27322610E-01  +8.60173600E-02  -2.37778900E-02  -3.85010800E-02
   +1.55647200E-02  +1.07082000E-03  -3.63800000E-04  -6.62540000E-04  +9.81900000E-05
   -3.85880000E-04  -3.17670000E-04  -6.95964000E-03  -4.41604200E-02  +2.07585600E-02
   -1.86770000E-04  +3.92690000E-04  -7.76800000E-05  -1.04720000E-04  -3.98700000E-05
   +6.72600000E-05  -2.23600000E-05  -6.45700000E-05  +1.69600000E-05  -2.26600000E-05
   -4.28000000E-06  -5.97200000E-05  +1.89200000E-05  +5.84000000E-05  +7.68800000E-05
   -1.91820000E-04  -4.02800000E-05  -7.66500000E-05  -1.45200000E-05  +1.61000000E-05
   +1.67400000E-05  -1.12073000E-03  +7.63720000E-04  +1.63340000E-04  +2.78638500E-02
   +3.70873170E-01  +1.78966000E-02  -2.86198500E-02  +2.73392000E-03  +8.06594000E-03
   +2.53176400E-02  +1.52067400E-02  -2.76979400E-02  -5.45002000E-03  -1.15807900E-02
   +9.80784400E-02  -1.38361090E-01  -1.86866980E-01  +4.09240700E-02  +1.69882410E-01
   -6.93243000E-02  -3.90135400E-02  -7.36906000E-03  -5.90492000E-03  -4.65800000E-05
   +3.84110000E-04  +1.27020000E-03  +1.66340000E-04  +1.40000000E-06  -4.31800000E-05
   +2.92579000E-03  +2.05853400E-02  -1.09272500E-02  +6.01000000E-06  -3.09820000E-04
   +3.72870000E-04  -1.23740000E-04  -1.09980000E-04  -1.22030000E-04  +1.43050000E-04
   +1.53840000E-04  -1.33470000E-04  -1.70520000E-04  -1.32040000E-04  +2.36550000E-04
   -6.73300000E-05  -5.13600000E-05  +2.95300000E-05  +9.33000000E-06  -5.15300000E-05
   -1.05040000E-04  +2.57390000E-04  +1.70000000E-04  -8.83900000E-05  +9.14450000E-04
   -3.76800000E-04  +8.03600000E-05  -1.22457590E-01  -2.59246700E-02  +2.93733830E-01
   +1.71400000E-05  -4.29700000E-05  -3.49900000E-05  +2.30000000E-05  +1.28230000E-04
   -6.51100000E-05  +4.85000000E-06  -2.99600000E-05  -2.08800000E-05  -6.05000000E-06
   -6.37100000E-05  +3.96400000E-05  -2.06150000E-04  +1.07370000E-04  -1.04400000E-05
   +4.95400000E-05  +2.37500000E-05  -1.43900000E-05  -1.56890000E-04  -3.77600000E-05
   +1.79200000E-04  +1.44790000E-04  +3.15400000E-05  -6.35300000E-05  +1.69720000E-04
   -9.45900000E-05  +7.10700000E-05  +5.43270000E-04  +7.86600000E-05  +5.84810000E-04
   -1.01438000E-03  -8.75600000E-05  -4.12010000E-04  +3.83819000E-03  +2.97251000E-03
   -9.44350000E-04  -2.96838100E-02  -8.59721000E-03  -3.01509200E-02  -2.76310000E-03
   -3.82747000E-03  +4.00386000E-03  +1.32080000E-04  -3.41700000E-04  -2.05277000E-03
   -2.17779260E-01  -7.32903800E-02  -2.14002390E-01  +7.13600000E-05  +2.32200000E-05
   +1.68200000E-05  +1.02130000E-04  +1.64900000E-05  -4.29000000E-05  +2.46570200E-01
   +2.26500000E-05  -8.60000000E-06  +1.55000000E-06  -3.61800000E-05  +6.94800000E-05
   -2.61400000E-05  +1.20200000E-05  -3.91600000E-05  +4.20000000E-07  -9.13000000E-06
   -2.91800000E-05  +2.52200000E-05  -1.15280000E-04  +9.13000000E-05  -8.50000000E-06
   +3.76200000E-05  +7.01000000E-06  -1.51800000E-05  -6.68000000E-05  -4.87000000E-05
   +9.94400000E-05  +6.90700000E-05  +2.55500000E-05  -3.93800000E-05  +1.01190000E-04
   -7.35500000E-05  +4.60500000E-05  +2.95970000E-04  +1.04820000E-04  +4.41240000E-04
   -1.71630000E-04  -7.50500000E-04  -2.26780000E-04  +1.61237000E-03  +3.56980000E-04
   -1.37028000E-03  -1.85966900E-02  -8.42995000E-03  -2.04066300E-02  -3.42611000E-03
   -4.97990000E-04  +2.78413000E-03  -7.97930000E-04  +1.39891000E-03  -9.14870000E-04
   -6.25340400E-02  -2.93572000E-02  -4.45810300E-02  +4.78600000E-05  +2.79400000E-05
   -3.75000000E-06  +5.22900000E-05  -1.80000000E-05  -2.87000000E-05  +8.32555600E-02
   +3.74849000E-02  +1.81000000E-05  +1.33000000E-06  +5.95000000E-06  +2.10000000E-07
   -7.10000000E-06  -3.03600000E-05  +9.88000000E-06  -3.57000000E-06  +2.61000000E-06
   -2.18000000E-06  +2.89000000E-06  +4.39000000E-06  +8.21000000E-06  -6.03000000E-06
   +4.42000000E-06  +9.20000000E-06  -3.51000000E-06  -3.22000000E-06  -1.21830000E-04
   +1.07900000E-05  -4.74000000E-06  +7.80400000E-05  +2.47100000E-05  -5.05200000E-05
   -5.21000000E-06  +1.00000000E-06  -3.92000000E-06  -9.67000000E-06  +4.23100000E-05
   -3.80010000E-04  -6.69400000E-05  -2.76100000E-05  -7.57830000E-04  +4.81142000E-03
   +1.95599000E-03  +2.64623000E-03  +1.19989500E-02  +4.01605000E-03  +9.88309000E-03
   +2.64174000E-03  +1.96847000E-03  +3.19890000E-04  -3.29130000E-04  +5.83100000E-05
   +5.18440000E-04  -2.59515260E-01  -7.09043600E-02  -3.38910960E-01  +1.14700000E-05
   +9.00000000E-07  +3.53500000E-05  -3.82000000E-06  -2.30000000E-07  -3.84000000E-06
   +2.41133950E-01  +6.30235300E-02  +3.27811790E-01  -3.29400000E-05  -1.22000000E-05
   -3.63000000E-06  +2.89700000E-05  -2.63290000E-04  +7.43600000E-05  -8.01500000E-05
   +9.47200000E-05  -1.00700000E-05  +1.49300000E-05  +1.66400000E-05  -4.36000000E-05
   +1.40410000E-04  -6.55400000E-05  +1.41900000E-05  -7.18100000E-05  +1.68100000E-05
   +1.19200000E-05  -8.98500000E-05  +3.24400000E-05  -1.07338000E-03  -2.47000000E-04
   -4.97800000E-05  +1.18940000E-04  -1.11450000E-04  +7.57300000E-05  -4.93100000E-05
   -1.07735000E-03  -5.10824000E-03  +2.14978000E-03  -1.33494300E-02  -4.50864000E-03
   -1.89893000E-02  -1.84464200E-01  -5.73002500E-02  -1.31636960E-01  +2.21506000E-03
   -2.09008000E-03  +3.92486000E-03  +2.59825000E-03  -1.94603000E-03  +5.11430000E-04
   -3.59000000E-04  +1.79540000E-04  +9.19000000E-04  +1.87585000E-03  +3.24265000E-03
   +1.03609000E-03  -3.68700000E-05  +5.36800000E-05  -8.63000000E-05  -5.55700000E-05
   +9.30000000E-07  +2.99500000E-05  +2.87100000E-05  -3.85900000E-05  -1.17566000E-03
   +1.93428460E-01  -1.68600000E-05  +1.02600000E-05  +1.89400000E-05  -2.09050000E-04
   -2.69330000E-04  +9.23900000E-05  -4.98400000E-05  +2.61900000E-05  +2.72000000E-05
   -8.20000000E-06  +6.21600000E-05  -4.15600000E-05  +8.33000000E-05  -5.59700000E-05
   -1.71500000E-05  -4.29000000E-06  -6.34000000E-06  -3.56000000E-06  -4.01100000E-04
   +3.94100000E-04  -5.42960000E-04  -6.73600000E-05  +8.48100000E-05  +1.45200000E-05
   -7.40800000E-05  +4.47400000E-05  -2.94700000E-05  -4.76743000E-03  +3.28508000E-03
   +2.66393000E-03  -1.08326100E-02  -1.19717000E-03  -1.28434000E-02  -5.72899600E-02
   -5.63818500E-02  -4.05054200E-02  +4.50764000E-03  +5.31876000E-03  +6.65226000E-03
   -2.05949000E-03  +3.84560000E-03  +2.79825000E-03  +1.64240000E-04  -1.02747000E-03
   +4.19570000E-04  +3.42816000E-03  -1.93169000E-03  -9.43110000E-04  +3.86200000E-05
   -2.29800000E-05  -7.57700000E-05  -4.09500000E-05  -2.93700000E-05  +2.83800000E-05
   -6.39620000E-04  +2.54450000E-04  -2.58930000E-04  +6.54214000E-02  +5.07311700E-02
   +2.70000000E-07  +1.78000000E-06  -2.15000000E-06  +1.90000000E-06  +3.44400000E-05
   -9.78000000E-06  +1.17200000E-05  -6.34000000E-06  +1.61300000E-05  +3.07000000E-06
   +9.03000000E-06  +3.00000000E-08  +3.63700000E-05  -2.24100000E-05  +3.40000000E-06
   -5.70000000E-06  -9.41000000E-06  +4.81000000E-06  +2.79310000E-04  +1.33860000E-04
   +3.46580000E-04  +2.39200000E-05  +2.10500000E-05  -3.51500000E-05  -3.05400000E-05
   +1.74600000E-05  -1.20100000E-05  +1.62797000E-03  +2.25802000E-03  +1.26571000E-03
   +7.63955000E-03  +2.66059000E-03  +9.65679000E-03  -1.31792270E-01  -4.04752100E-02
   -1.86753010E-01  -2.43973800E-02  -9.91993000E-03  -1.39633700E-02  +1.11756000E-03
   +3.17870000E-03  -5.00632000E-03  +1.26091000E-03  +6.22440000E-04  -6.13380000E-04
   +3.46690000E-04  -1.30366000E-03  +2.35231000E-03  -4.47300000E-05  -6.03800000E-05
   +1.71900000E-05  -1.98500000E-05  +1.21000000E-06  +8.00000000E-06  +1.40998000E-03
   +1.24089000E-03  -1.27271000E-03  +1.43426590E-01  +4.32008800E-02  +1.94193810E-01
   -3.68100000E-05  -1.30450000E-04  +7.62000000E-06  -2.13100000E-04  -1.77400000E-05
   +1.79540000E-04  -4.72400000E-05  -2.32100000E-05  +2.21700000E-05  +4.23700000E-05
   -5.09500000E-05  -1.66000000E-05  -8.45800000E-05  +9.81700000E-05  -6.30000000E-06
   -1.01800000E-05  +2.80900000E-05  +1.89300000E-05  -1.55880000E-04  +2.08699000E-03
   +4.48350000E-04  +3.60380000E-04  +6.64100000E-05  +1.01190000E-04  +9.15800000E-05
   -5.69800000E-05  +4.34800000E-05  +7.49049000E-03  +6.46693000E-03  -2.03763700E-02
   -5.52368800E-02  -1.34266000E-02  +1.64722600E-02  +1.57323000E-03  -7.04303000E-03
   +2.50818300E-02  -1.75084000E-03  -5.38412000E-03  +7.53700000E-05  -1.29281000E-03
   -3.92300000E-05  -8.05000000E-05  -1.61337000E-03  -3.91975000E-03  -4.03270000E-03
   -3.85200000E-04  -5.53160000E-04  +1.38455000E-03  -9.46590000E-04  -7.74890000E-04
   -5.03500000E-04  +4.79200000E-05  -4.07000000E-06  +7.50000000E-07  +1.74470000E-04
   +1.01290000E-04  +9.08000000E-05  -3.24760000E-04  +2.16861000E-03  +2.55020000E-04
   +5.40029800E-02  +1.15410000E-04  +1.42600000E-04  +6.51500000E-05  +2.74530000E-04
   +5.05840000E-04  +9.74800000E-05  +1.11020000E-04  -1.63200000E-04  -3.51500000E-05
   +1.72600000E-05  -4.65200000E-05  +3.26600000E-05  -7.01100000E-05  +6.36800000E-05
   +6.08000000E-06  +3.23100000E-05  -6.89300000E-05  -3.58600000E-05  +1.94169000E-03
   -2.82837000E-03  -4.97950000E-04  -6.90150000E-04  -3.03490000E-04  +6.74800000E-05
   +4.92800000E-05  -5.72800000E-05  +3.09800000E-05  +1.25537000E-03  +6.79151000E-03
   -7.01444000E-03  -1.34424600E-02  -6.33696000E-02  +7.45970400E-02  -8.13620000E-04
   -8.82530000E-04  +1.64911300E-02  -5.44305000E-03  +4.07089000E-03  +1.28802000E-03
   -1.37300000E-05  -1.10593000E-03  -4.88030000E-04  -3.87671000E-03  +4.76283000E-03
   -2.38080000E-04  -3.10700000E-04  -3.44020000E-04  +9.35200000E-04  -1.32115000E-03
   +2.22310000E-04  -2.45470000E-04  +1.40100000E-05  +2.71900000E-05  -1.99900000E-05
   +1.54810000E-04  +3.05500000E-05  +5.20700000E-05  +2.05608000E-03  -2.73473000E-03
   -9.82830000E-04  +2.03513600E-02  +5.76191300E-02  -4.16800000E-05  -1.50300000E-05
   +3.66400000E-05  +4.79600000E-05  -4.92300000E-05  +8.23100000E-05  -1.48200000E-05
   -2.41500000E-05  +1.22100000E-05  +1.29300000E-05  -1.98200000E-05  -1.42000000E-05
   -5.11000000E-06  +1.77700000E-05  -1.02100000E-05  +5.91000000E-06  +6.30000000E-06
   +2.26700000E-05  +1.62881000E-03  +2.75640000E-04  -9.68520000E-04  -3.30330000E-04
   -3.50400000E-05  +4.10200000E-05  +1.42400000E-05  -1.27700000E-05  +1.22300000E-05
   +3.00410000E-03  +6.35129000E-03  -1.55635600E-02  +1.59153500E-02  +7.47218100E-02
   -3.21072290E-01  -1.28444000E-03  +1.28952000E-03  -5.11744000E-03  +4.26310000E-04
   +1.43646000E-03  +2.30504000E-03  -2.53270000E-04  -5.70040000E-04  +6.10930000E-04
   -4.17426000E-03  -5.19420000E-04  -1.17599000E-03  +2.95920000E-04  +2.95620000E-04
   -5.37980000E-04  +1.26004000E-03  +1.00943000E-03  +5.12500000E-05  -3.02000000E-06
   +5.85000000E-06  +1.43500000E-05  -1.16940000E-04  -6.36400000E-05  -5.00500000E-05
   +7.02410000E-04  -7.07820000E-04  +7.07800000E-04  -1.90313800E-02  -8.38715800E-02
   +3.40796090E-01  -2.87110000E-04  +3.52400000E-05  +2.68460000E-04  -5.50520000E-04
   -2.50090000E-04  +7.55830000E-04  -1.10670000E-04  +6.01700000E-05  +3.76600000E-05
   -1.84880000E-04  +9.57400000E-05  -2.01300000E-05  -2.77070000E-04  -1.03500000E-05
   -1.41500000E-04  +2.78150000E-04  -6.25800000E-05  +1.76000000E-06  -9.73830000E-04
   +8.29580000E-04  +6.32550000E-04  +2.38800000E-05  -2.09350000E-04  -1.23540000E-04
   +1.57360000E-04  -9.03600000E-05  +8.85700000E-05  +5.51278000E-03  +3.80380000E-04
   +1.91108000E-03  +2.33445000E-03  -2.21394000E-03  +5.49350000E-04  -3.23020000E-04
   +2.37140000E-04  +9.05730000E-04  -1.07490000E-04  -5.18452000E-03  +1.81435000E-03
   -1.31573900E-02  -5.37773000E-03  -1.85497000E-02  -1.92706920E-01  -5.21866100E-02
   -1.33853370E-01  -1.04557000E-03  -3.53110000E-04  -9.95250000E-04  -2.15400000E-05
   +1.59500000E-04  -1.50000000E-07  +7.83700000E-05  -4.26400000E-05  -6.45000000E-06
   -3.11190000E-04  -7.40400000E-05  +1.06510000E-04  -1.98560000E-04  +2.66560000E-04
   +4.35000000E-06  +2.25570000E-04  +5.79000000E-06  +2.48770000E-04  +2.01692860E-01
   -1.95750000E-04  +7.89900000E-05  +1.53990000E-04  -2.93550000E-04  +2.75150000E-04
   +1.99750000E-04  +1.43090000E-04  +5.09000000E-06  +2.78500000E-04  -1.29430000E-04
   +1.58430000E-04  -3.66900000E-05  +2.11500000E-05  -4.03800000E-05  -1.25800000E-04
   +1.83350000E-04  -1.72920000E-04  +1.40010000E-04  +1.24196000E-03  -2.10737000E-03
   -5.14980000E-04  -1.39710000E-04  -2.98800000E-04  +5.45380000E-04  -3.10000000E-06
   -1.89700000E-05  +3.18100000E-05  +6.58915000E-03  +6.61474000E-03  +5.50200000E-03
   -2.60280000E-03  +4.14029000E-03  +2.85732000E-03  +3.16830000E-04  -9.73200000E-04
   +2.25570000E-04  -5.24591000E-03  +4.72233000E-03  +3.11767000E-03  -1.24995000E-02
   +3.34150000E-04  -1.21426700E-02  -5.12704100E-02  -5.96707300E-02  -3.72481000E-02
   -7.11770000E-04  -2.34650000E-04  -7.08040000E-04  +2.15290000E-04  -2.99000000E-05
   -8.62600000E-05  -1.08800000E-05  -1.47530000E-04  +4.27300000E-05  -1.05860000E-04
   -2.91360000E-04  +1.93400000E-05  +2.98250000E-04  -4.96130000E-04  -1.61790000E-04
   +3.69430000E-04  +1.38320000E-04  +3.55700000E-04  +6.17050700E-02  +5.23325600E-02
   +9.34000000E-06  -5.31660000E-04  +3.85400000E-05  +3.95870000E-04  +2.89490000E-04
   -1.90300000E-05  +2.94980000E-04  +3.23600000E-05  +2.30440000E-04  +8.96100000E-05
   +8.52100000E-05  +9.90300000E-05  +4.49650000E-04  -1.07300000E-04  +6.57700000E-05
   -1.55170000E-04  +1.99500000E-05  +1.12300000E-05  -9.21620000E-04  -1.30759000E-03
   +1.21330000E-04  +1.38200000E-04  +1.00500000E-04  -3.48400000E-04  -3.19230000E-04
   +2.02680000E-04  -1.42660000E-04  -2.26167400E-02  -7.97945000E-03  -1.47192900E-02
   +8.67540000E-04  +3.36451000E-03  -5.19702000E-03  +1.06467000E-03  +3.56930000E-04
   -1.84170000E-04  +1.50746000E-03  +2.86909000E-03  +8.81080000E-04  +8.07962000E-03
   +3.27679000E-03  +9.59562000E-03  -1.33470170E-01  -3.83048800E-02  -1.85425000E-01
   +9.52600000E-05  -3.60400000E-05  +4.39310000E-04  +1.56800000E-04  +1.29000000E-05
   +5.37100000E-05  -1.86760000E-04  -3.67300000E-05  +1.96700000E-05  +2.11010000E-04
   +7.25100000E-05  -1.13100000E-05  -2.12700000E-05  -1.88980000E-04  -1.69100000E-05
   -1.20083000E-03  -4.90290000E-04  -9.05760000E-04  +1.45101720E-01  +3.89457500E-02
   +1.94208430E-01  -1.77200000E-05  -4.61000000E-06  -1.80800000E-05  +1.13030000E-04
   -4.73300000E-05  +1.63500000E-05  -1.88000000E-06  +5.13900000E-05  +3.17000000E-06
   -2.00500000E-05  +4.36300000E-05  -9.10000000E-06  +3.14800000E-05  -5.38400000E-05
   -4.01000000E-06  -1.22500000E-05  +6.76000000E-06  -2.03300000E-05  +4.92620000E-04
   -1.45480000E-04  +1.09885000E-03  +2.38000000E-06  +1.27160000E-04  +6.16000000E-05
   -4.18900000E-05  +3.78500000E-05  -3.14400000E-05  -1.77745000E-03  -5.65824000E-03
   +1.67080000E-04  -1.45637000E-03  -2.37530000E-04  -1.37270000E-04  -1.83921000E-03
   -3.36903000E-03  -3.37873000E-03  +7.19434000E-03  +6.55158000E-03  -2.16806100E-02
   -5.67764700E-02  -1.74193100E-02  +2.24556800E-02  +2.35082000E-03  -6.38661000E-03
   +2.48829600E-02  +6.25780000E-04  +1.99142000E-03  +1.22405000E-03  -3.41250000E-04
   -1.73400000E-04  -4.40600000E-05  -8.29000000E-06  -1.11000000E-06  -1.40000000E-06
   +9.39500000E-05  +2.78830000E-04  +3.11880000E-04  +1.36390000E-04  +3.69780000E-04
   -1.16295000E-03  -1.16710000E-04  +3.21030000E-04  +1.29310000E-04  -3.44200000E-04
   +2.47277000E-03  +3.28800000E-04  +5.17561200E-02  +3.58200000E-05  +4.22500000E-05
   -9.61000000E-06  +2.05320000E-04  -7.25500000E-05  +3.96300000E-05  -4.11000000E-05
   +8.43000000E-06  -3.56600000E-05  +4.58000000E-06  -8.14000000E-06  -4.27000000E-06
   +4.34900000E-05  +2.66500000E-05  +1.91200000E-05  -2.86600000E-05  +4.60000000E-06
   +1.12000000E-06  -1.58900000E-05  +3.04890000E-04  +6.88750000E-04  -3.13900000E-05
   -2.54600000E-05  +2.30000000E-07  -2.45600000E-05  +9.60000000E-07  -9.64000000E-06
   -5.54424000E-03  +4.35114000E-03  +1.27472000E-03  -8.41200000E-05  -9.06820000E-04
   -4.11680000E-04  -3.27643000E-03  +3.56387000E-03  -3.74100000E-04  -3.50020000E-04
   +6.64664000E-03  -7.42157000E-03  -1.69731300E-02  -6.57283200E-02  +8.21182800E-02
   -8.93000000E-05  -1.09745000E-03  +1.61128800E-02  +2.14609000E-03  -1.99411000E-03
   -4.40140000E-04  -2.10580000E-04  -2.11540000E-04  +5.35000000E-06  -1.42100000E-05
   -2.27600000E-05  -1.16900000E-05  +2.93450000E-04  -3.48440000E-04  -9.13000000E-06
   +8.26000000E-05  +9.63400000E-05  -4.82050000E-04  +3.31530000E-04  -5.17480000E-04
   -7.11700000E-05  +2.22378000E-03  -3.21888000E-03  -1.21464000E-03  +2.12974700E-02
   +5.92744200E-02  +1.75300000E-05  +9.64000000E-06  +3.76000000E-06  -1.84800000E-05
   +5.96000000E-05  -2.70200000E-05  -6.20000000E-07  -3.75000000E-05  -2.26200000E-05
   +3.23000000E-06  -3.40100000E-05  +1.49500000E-05  -5.76100000E-05  +6.32000000E-05
   +4.64000000E-06  +1.88100000E-05  +1.19000000E-06  +6.82000000E-06  -3.40630000E-04
   -4.28500000E-05  -2.65160000E-04  +5.93700000E-05  -2.30400000E-05  -4.92900000E-05
   +5.89200000E-05  -4.67700000E-05  +3.18600000E-05  +5.16680000E-04  +1.73349000E-03
   +2.18824000E-03  -4.57630000E-04  -6.36690000E-04  +6.09480000E-04  -3.90876000E-03
   -7.01490000E-04  -1.05110000E-03  +5.99372000E-03  +8.71550000E-03  -1.64847500E-02
   +2.11465900E-02  +8.11055100E-02  -3.17820160E-01  -1.07428000E-03  +9.65450000E-04
   -3.61380000E-03  +9.09400000E-04  -6.09000000E-04  +1.34510000E-03  +1.40440000E-04
   +6.85200000E-05  +4.34400000E-05  +2.58500000E-05  -7.67000000E-06  -1.56600000E-05
   +2.21680000E-04  -6.30600000E-05  +2.26830000E-04  +1.30160000E-04  +2.47620000E-04
   -8.28040000E-04  +9.90600000E-05  -9.99300000E-05  -9.03400000E-05  +8.03440000E-04
   -8.47130000E-04  +5.61690000E-04  -2.42925900E-02  -8.98366400E-02  +3.35292390E-01
   +2.35680000E-04  -5.52420000E-04  -1.65460000E-04  +3.59540000E-04  +4.01340000E-04
   -6.07810000E-04  +6.18040000E-04  +2.27000000E-04  +1.72030000E-04  -5.62300000E-05
   +2.24690000E-04  +6.33700000E-05  +4.23590000E-04  -1.25500000E-04  +5.36200000E-05
   -2.89030000E-04  +2.78300000E-05  -6.41000000E-06  +1.91353000E-03  -1.88057000E-03
   +1.74109000E-03  +3.97830000E-04  -1.96620000E-04  +4.65630000E-04  -2.96790000E-04
   +1.92280000E-04  -1.56300000E-04  -5.55700000E-05  -1.59460000E-04  -2.30890000E-04
   -8.42740000E-04  -1.13714000E-03  -8.19400000E-05  +1.48030000E-04  -2.22500000E-05
   +2.77320000E-04  -1.70800000E-04  -3.34600000E-05  -1.80000000E-06  +3.64900000E-05
   +5.49000000E-06  -6.02000000E-06  +1.27860000E-04  +1.27000000E-04  -6.05000000E-05
   +7.63200000E-05  +4.69600000E-05  +1.81700000E-05  -2.08976400E-01  +1.06284610E-01
   -7.41936800E-02  -1.13290000E-04  -1.28320000E-04  -2.40000000E-07  -5.73000000E-06
   +3.05000000E-06  -8.44000000E-06  +3.15200000E-05  -1.33100000E-05  -1.61200000E-05
   -7.88160000E-04  -1.36588000E-03  +9.23540000E-04  -9.10000000E-06  +2.51000000E-06
   +1.53400000E-05  +1.13700000E-05  +1.81200000E-05  -4.38000000E-06  +2.27194630E-01
   +3.72020000E-04  -1.09490000E-04  +4.23220000E-04  +3.46130000E-04  +5.25200000E-04
   +1.44534000E-03  -6.03580000E-04  -3.41010000E-04  -2.57640000E-04  +4.07570000E-04
   -5.56910000E-04  +2.93630000E-04  -4.58700000E-05  +6.97340000E-04  +3.48510000E-04
   -6.08170000E-04  +1.48830000E-04  -9.79500000E-05  +3.13824000E-03  -3.04808000E-03
   +2.05170000E-04  -6.47330000E-04  +4.05660000E-04  -1.08472000E-03  +2.04290000E-04
   -1.56730000E-04  +4.70700000E-05  +4.58430000E-04  +1.89640000E-04  -1.00380000E-04
   +2.12460000E-04  -9.04800000E-05  +1.13619000E-03  -2.34320000E-04  +1.67200000E-05
   -4.55740000E-04  +1.26800000E-05  -2.18300000E-05  -1.68400000E-05  +8.58600000E-05
   +7.14100000E-05  -8.63400000E-05  -2.27300000E-04  -9.02000000E-05  +7.20900000E-05
   +8.01100000E-05  +7.93600000E-05  -1.11200000E-04  +1.05323140E-01  -1.17303320E-01
   +4.83157800E-02  +1.77490000E-04  +1.21800000E-05  -2.80120000E-04  -3.34200000E-05
   -2.98300000E-05  +2.15400000E-05  -4.98000000E-06  -1.17400000E-05  +2.94100000E-05
   -1.13027000E-03  -1.22868000E-03  -5.33500000E-05  +3.03000000E-06  +5.01000000E-06
   -1.14100000E-04  -1.29000000E-06  -6.26000000E-06  -1.03500000E-05  -1.15598040E-01
   +1.23568010E-01  -2.44170000E-04  -8.63200000E-05  +1.49750000E-04  +1.35229000E-03
   -3.65690000E-04  -6.23352000E-03  +9.66300000E-05  +8.61880000E-04  +2.73550000E-04
   -6.95510000E-04  +5.52530000E-04  +2.71640000E-04  +8.20770000E-04  -3.37390000E-04
   -3.86700000E-04  -4.53190000E-04  -5.15800000E-05  +2.62110000E-04  -2.58397000E-02
   +1.55664000E-02  -1.18835500E-02  -1.22663000E-03  +1.33362000E-03  +1.28592000E-03
   -6.09050000E-04  +3.92470000E-04  -2.49880000E-04  -5.12410000E-04  -4.31200000E-04
   +9.83700000E-04  +1.95320000E-04  -1.00480000E-04  +1.66000000E-05  +2.57830000E-04
   +6.73200000E-05  +6.45300000E-05  +1.31110000E-04  +7.55700000E-05  +1.95830000E-04
   -1.99160000E-04  -1.33370000E-04  +5.82700000E-05  +1.77180000E-04  -1.00340000E-04
   -2.80240000E-04  -1.01570000E-04  -8.15900000E-05  +4.21300000E-05  -7.33144500E-02
   +4.72441000E-02  -8.12036600E-02  -3.38930000E-04  -5.27080000E-04  +2.71350000E-04
   +1.97200000E-05  +2.29400000E-05  -2.46000000E-06  -3.04000000E-06  +1.30200000E-05
   -1.16900000E-05  +4.53720000E-04  +5.78540000E-04  +2.80510000E-04  -5.16500000E-05
   +2.11200000E-05  +9.71700000E-05  -2.22600000E-05  +2.12100000E-05  +7.41000000E-06
   +8.12417000E-02  -5.32366600E-02  +8.91008500E-02  +3.48510000E-04  -2.68500000E-04
   +1.21100000E-05  +6.56690000E-04  +1.13159000E-03  -7.62450000E-04  +3.19070000E-04
   -1.65890000E-04  -3.38000000E-05  +5.60200000E-05  -6.56700000E-05  +1.57030000E-04
   +4.20200000E-05  +1.66670000E-04  +1.05530000E-04  -2.51360000E-04  +1.25000000E-05
   +7.34000000E-06  -2.73842000E-03  -9.48340000E-04  -4.23940000E-04  -1.52310000E-04
   -7.39100000E-05  -4.35890000E-04  +2.85900000E-05  -2.96400000E-05  -6.09000000E-06
   +6.70840000E-04  +9.65800000E-05  +1.32610000E-04  -1.30610000E-04  -1.32610000E-04
   -3.80520000E-04  +1.59820000E-04  -1.27600000E-05  +2.66760000E-04  +1.03780000E-04
   +8.47400000E-05  -6.26000000E-06  -7.27800000E-05  -2.86300000E-05  +1.26440000E-04
   +1.90800000E-05  -7.21200000E-05  -2.94610000E-04  -1.87550000E-04  -1.28700000E-04
   +1.04710000E-04  -2.35797570E-01  -1.17288280E-01  +4.32360900E-02  +2.94800000E-05
   -4.44500000E-05  -4.10600000E-05  +4.35900000E-05  +2.41500000E-05  -9.69000000E-06
   -1.93500000E-05  -2.18100000E-05  -1.75400000E-05  +1.90400000E-04  +1.97640000E-04
   +4.48090000E-04  +7.73500000E-05  -1.69600000E-05  +7.74100000E-05  -3.49300000E-05
   +8.85000000E-06  +1.73100000E-05  -1.92487100E-02  -1.33507000E-02  +4.81110000E-03
   +2.52893570E-01  -7.65500000E-05  -5.29600000E-04  -2.89490000E-04  -5.86580000E-04
   +3.18470000E-04  -6.68800000E-05  +3.69920000E-04  +2.08400000E-05  +1.04420000E-04
   -5.54200000E-05  +1.47480000E-04  +1.85850000E-04  +8.65400000E-05  -2.05220000E-04
   +5.43900000E-05  +6.59300000E-05  +6.96000000E-05  +1.84200000E-05  -3.16010000E-03
   -3.86227000E-03  +8.86450000E-04  +8.31600000E-04  +4.38430000E-04  -6.51610000E-04
   -7.71000000E-05  +1.18600000E-04  -8.65100000E-05  +3.04460000E-04  +5.30180000E-04
   +1.01184000E-03  -2.92100000E-05  +2.70640000E-04  +3.77700000E-05  +1.76600000E-05
   +1.52800000E-04  +1.54100000E-05  +2.02780000E-04  +7.38300000E-05  +6.42200000E-05
   -1.01420000E-04  -1.57370000E-04  +8.55400000E-05  -3.66570000E-04  +2.18920000E-04
   -1.93790000E-04  -1.72220000E-04  -1.36670000E-04  +5.27200000E-05  -1.16424590E-01
   -1.19766030E-01  +2.61136600E-02  -1.68800000E-05  -4.25000000E-06  -1.36400000E-04
   +2.47500000E-05  +2.05700000E-05  +1.95000000E-06  -3.48600000E-05  +6.71000000E-06
   -1.31000000E-06  +2.30350000E-04  -3.29140000E-04  +3.70900000E-05  +9.13000000E-06
   +4.43700000E-05  +5.89300000E-05  -4.25000000E-06  -7.06700000E-05  +1.67000000E-06
   +1.47829400E-02  +9.47437000E-03  -3.96524000E-03  +1.27993220E-01  +1.26414040E-01
   -4.33400000E-04  +2.49660000E-04  +2.13000000E-05  +1.37930000E-03  +1.36990000E-04
   +7.61070000E-04  -1.88430000E-04  -2.66220000E-04  +1.02120000E-04  -1.67170000E-04
   +6.82300000E-05  -1.52360000E-04  -3.99490000E-04  -7.84200000E-05  -1.48960000E-04
   +4.49800000E-04  -4.82200000E-05  +1.68500000E-05  +2.73992400E-02  +1.75292200E-02
   -8.22900000E-03  +6.86040000E-04  +1.30082000E-03  +1.23035000E-03  +2.40760000E-04
   -1.52990000E-04  +1.38460000E-04  -1.23597000E-03  -3.55950000E-04  -6.33567000E-03
   -1.02616000E-03  -2.50990000E-04  -7.21300000E-04  +2.34860000E-04  +9.29200000E-05
   +2.30860000E-04  -2.20940000E-04  -1.79650000E-04  +7.09100000E-05  -9.70400000E-05
   +1.67360000E-04  -4.70150000E-04  +1.85738000E-03  +1.05551000E-03  +1.57200000E-05
   +2.19790000E-04  +1.36840000E-04  -1.42800000E-05  +4.09947800E-02  +2.48938200E-02
   -5.49656800E-02  +1.15000000E-04  +6.50000000E-05  +1.68800000E-05  -1.08500000E-05
   -7.94000000E-06  -1.44000000E-05  +4.28400000E-05  +3.40100000E-05  -8.22000000E-06
   +2.24400000E-05  -1.55210000E-04  +5.35150000E-04  -3.29000000E-06  -6.03300000E-05
   -1.22000000E-05  +1.38610000E-04  +9.42600000E-05  -5.10000000E-05  -9.32074000E-03
   -6.97991000E-03  +1.68808000E-03  -4.64104700E-02  -2.92810600E-02  +6.36760400E-02
   -9.47000000E-06  +2.01120000E-04  -8.43400000E-05  -3.50000000E-06  -9.66260000E-04
   -3.04730000E-04  -1.42450000E-04  +1.09760000E-04  -7.82100000E-05  +1.20920000E-04
   -1.62340000E-04  -3.55600000E-05  -2.92000000E-05  +2.01270000E-04  +1.76600000E-05
   -2.57640000E-04  +5.39000000E-05  -4.37000000E-06  -2.00292000E-03  +2.66295000E-03
   +1.16049000E-03  -1.46940000E-04  -1.74470000E-04  +8.36300000E-04  +6.23500000E-05
   -5.59100000E-05  +3.66700000E-05  +3.22240000E-04  +6.33490000E-04  +4.86000000E-05
   -3.65500000E-05  -6.38400000E-05  +7.29270000E-04  -1.11520000E-04  -1.07700000E-04
   -2.32900000E-04  -8.41600000E-05  -2.68800000E-05  -4.93400000E-05  +1.25850000E-04
   +8.40800000E-05  -5.69100000E-05  -7.54900000E-05  -6.71900000E-05  +8.80000000E-05
   +1.12670000E-04  +8.98300000E-05  -8.28500000E-05  -4.82308900E-02  +1.53147300E-02
   +7.51326000E-03  +6.55800000E-05  +1.86000000E-06  +1.07800000E-05  -3.19300000E-05
   -1.77700000E-05  +1.28200000E-05  -5.03000000E-06  +1.55500000E-05  +2.27900000E-05
   -1.25079000E-03  +3.35110000E-04  +1.52140000E-04  -2.04300000E-05  +2.04100000E-05
   -7.41600000E-05  +8.20000000E-06  +3.38000000E-06  -1.18500000E-05  -1.03958000E-03
   +2.17808800E-02  +1.27852800E-02  +2.42435000E-03  -2.39165800E-02  -1.34941600E-02
   +4.89314800E-02  +3.06990000E-04  -7.72100000E-05  +6.58430000E-04  +2.43400000E-04
   +5.73050000E-04  +2.30590000E-04  -2.42040000E-04  +2.17900000E-05  -1.40770000E-04
   +1.21280000E-04  -1.26570000E-04  +1.09040000E-04  +1.99530000E-04  +2.27770000E-04
   +3.29200000E-05  -3.97900000E-04  +5.14900000E-05  -3.12300000E-05  -2.89400000E-05
   +3.67742000E-03  +2.81967000E-03  -2.37800000E-05  +7.48710000E-04  +1.03670000E-04
   -9.77800000E-05  +3.44800000E-05  -4.27400000E-05  -4.70740000E-04  +2.81760000E-04
   -5.39600000E-05  -7.30120000E-04  +2.36930000E-04  -2.34580000E-04  +1.27420000E-04
   +8.70700000E-05  +2.09490000E-04  -4.58000000E-05  -1.07810000E-04  +2.21600000E-05
   -1.57900000E-05  -1.25800000E-05  +3.08900000E-05  +2.32990000E-04  +1.63200000E-04
   -1.14990000E-04  +6.30200000E-05  +2.63300000E-05  +1.91300000E-05  +1.53940400E-02
   -2.56765160E-01  -1.11166490E-01  -6.67000000E-06  -7.10600000E-05  -2.13400000E-05
   +3.96000000E-06  +2.52000000E-06  -1.49600000E-05  -2.79000000E-06  +3.93500000E-05
   -7.26000000E-06  -1.94000000E-06  -1.07900000E-04  +3.45950000E-04  +1.60600000E-05
   -2.99000000E-06  +5.12800000E-05  +2.36800000E-05  -1.83000000E-06  -8.72000000E-06
   -7.29600000E-04  -1.28110000E-02  -6.85262000E-03  +2.30448000E-03  -1.37080500E-02
   -7.04422000E-03  -1.62085200E-02  +2.77153230E-01  -2.85470000E-04  -5.57910000E-04
   +1.34360000E-04  +1.57457000E-03  -8.97950000E-04  +1.13494000E-03  -8.02850000E-04
   -4.37100000E-05  -2.55010000E-04  +4.41720000E-04  -6.25390000E-04  +1.97790000E-04
   +1.20820000E-04  +6.53560000E-04  +4.13280000E-04  -6.18810000E-04  +4.44450000E-04
   -5.65500000E-05  +1.30335000E-03  -2.85489000E-02  -1.42804300E-02  +3.21280000E-04
   +2.13128000E-03  -6.74589000E-03  +1.39170000E-04  -8.84300000E-05  -2.35000000E-06
   -8.93070000E-04  -6.46240000E-04  +1.58055000E-03  +5.23700000E-05  +1.06010000E-04
   +1.06040000E-04  +2.52030000E-04  +2.57850000E-04  -3.65300000E-05  +1.53710000E-04
   +3.10000000E-07  +3.06770000E-04  -2.67320000E-04  -1.87820000E-04  +3.19900000E-05
   -9.33800000E-05  +4.03350000E-04  -2.83350000E-04  -4.50800000E-05  -3.09400000E-05
   +8.80000000E-07  +7.00679000E-03  -1.08924060E-01  -1.05338080E-01  +1.74540000E-04
   +4.98900000E-05  -2.52960000E-04  +1.27300000E-05  +1.70000000E-06  -1.97000000E-06
   +2.27700000E-05  -2.41000000E-06  -1.69500000E-05  +5.00500000E-04  -6.57800000E-05
   +7.26300000E-05  +3.26200000E-05  -7.38700000E-05  +6.09600000E-05  +1.73100000E-05
   -4.09300000E-05  -1.15400000E-05  +1.30990000E-04  +1.11368800E-02  +5.58907000E-03
   -9.28680000E-04  +6.10801000E-03  +2.70405000E-03  -8.88636000E-03  +1.20324940E-01
   +1.16203090E-01  +2.26390000E-04  -3.14840000E-04  -1.39300000E-05  +3.16880000E-04
   +3.34250000E-04  +6.60500000E-05  -5.97250000E-04  +5.59830000E-04  -9.26630000E-04
   +1.78960000E-04  -1.13070000E-04  +8.03400000E-05  -5.97300000E-05  +1.59130000E-04
   +1.26690000E-04  -1.11500000E-04  +2.24800000E-05  -5.18300000E-05  +2.59022000E-03
   +3.05869000E-03  -1.00330000E-03  -2.05230060E-01  -1.21612030E-01  +4.82649400E-02
   +6.08100000E-05  -4.89900000E-05  +1.19700000E-05  +4.01560000E-04  -3.56940000E-04
   +1.39510000E-04  +5.18060000E-04  -1.72300000E-05  +2.18390000E-04  +2.52500000E-05
   -2.51900000E-05  +3.19700000E-05  +2.65720000E-04  +1.65660000E-04  +1.65900000E-05
   -1.98320000E-04  -7.68500000E-05  -6.04300000E-05  +3.06390000E-04  +1.10050000E-04
   -5.43610000E-04  -2.49420000E-04  -1.61840000E-04  +6.78100000E-05  +2.52630000E-04
   +4.30560000E-04  -2.64800000E-05  +5.78100000E-05  +4.25600000E-05  -5.42200000E-05
   +3.43800000E-05  +2.24400000E-05  +8.33000000E-06  -2.23700000E-05  -9.21000000E-06
   -4.73000000E-06  -5.62000000E-05  +5.86100000E-05  -2.64000000E-05  -2.24300000E-05
   +1.85700000E-05  +1.30200000E-05  -2.33400000E-05  +2.80000000E-06  +1.33500000E-05
   -1.83800000E-04  -1.34020000E-04  +6.77000000E-06  +2.49950000E-04  -6.98100000E-05
   -2.45660000E-04  +1.59020000E-04  +1.31520000E-04  -2.01020000E-04  +2.21963320E-01
   +2.87460000E-04  -2.76400000E-04  -3.63880000E-04  -9.42480000E-04  +1.01282000E-03
   +2.04740000E-04  +2.15140000E-04  -2.47700000E-05  -1.74660000E-04  +4.88400000E-04
   -2.38590000E-04  +7.37300000E-05  +2.28410000E-04  +3.92600000E-05  +3.39060000E-04
   -3.08300000E-04  +2.63380000E-04  +2.32700000E-05  -2.31932400E-02  -1.72534300E-02
   +7.29245000E-03  -1.20271290E-01  -1.39795980E-01  +3.60526300E-02  -1.26900000E-04
   +9.74100000E-05  -1.14960000E-04  +1.29401000E-03  -4.54680000E-03  -3.34289000E-03
   +1.59720000E-04  -4.04840000E-04  +6.22640000E-04  -6.81820000E-04  -1.42000000E-06
   +5.21310000E-04  +3.07680000E-04  +2.73970000E-04  -6.33730000E-04  -2.90100000E-05
   +1.69210000E-04  -5.80000000E-05  -3.31120000E-04  -1.06450000E-04  -2.76270000E-04
   -6.46900000E-04  -4.64160000E-04  +2.65010000E-04  -6.05240000E-04  +8.90110000E-04
   +1.47949000E-03  -9.75300000E-05  +2.68850000E-04  -5.20500000E-05  +7.92200000E-05
   +4.23900000E-05  +3.26200000E-05  -1.33810000E-04  -1.36700000E-05  +2.19800000E-05
   +6.90500000E-05  -1.82860000E-04  -1.29700000E-04  +7.11700000E-05  +2.65100000E-05
   +7.58800000E-05  -2.94400000E-05  -3.37800000E-05  +4.16200000E-05  +9.77500000E-05
   -5.10700000E-05  -1.10990000E-04  +4.71090000E-04  +2.47410000E-04  -8.11750000E-04
   +3.53060000E-04  +2.04130000E-04  +1.88530000E-04  +1.32840360E-01  +1.52791920E-01
   -1.00450000E-04  +6.42000000E-05  -2.03840000E-04  +8.91000000E-05  +5.04890000E-04
   +7.72100000E-05  +1.62520000E-04  +4.58300000E-04  +7.06760000E-04  -2.52890000E-04
   +4.10900000E-05  -2.83100000E-05  -2.19400000E-05  +5.23900000E-05  -1.18060000E-04
   +4.97600000E-05  -4.57300000E-05  -2.98000000E-06  -1.06330000E-02  -8.13894000E-03
   +1.61966000E-03  +4.77008800E-02  +3.69164700E-02  -6.31552500E-02  +4.03700000E-05
   -2.88300000E-05  +3.85200000E-05  +1.10897000E-03  -1.76308000E-03  -5.45480000E-04
   -6.64500000E-04  -3.23330000E-04  +6.80200000E-05  +1.83840000E-04  +3.61670000E-04
   -1.01740000E-04  +2.52310000E-04  +5.04400000E-05  +3.73660000E-04  -6.77890000E-04
   -3.74200000E-05  +3.19600000E-05  +1.33280000E-04  +4.15720000E-04  -1.27750000E-04
   -1.78060000E-04  -1.54270000E-04  +3.31000000E-05  -9.51690000E-04  -5.80030000E-04
   +7.64470000E-04  +9.35600000E-05  -1.75480000E-04  -7.31600000E-05  +1.30700000E-05
   -1.08400000E-05  +1.95100000E-05  -8.44000000E-06  -3.55200000E-05  -1.10900000E-05
   +9.41000000E-06  -1.00680000E-04  -1.64100000E-05  +2.63900000E-04  -3.88700000E-04
   +1.34670000E-04  -2.49900000E-05  +1.01000000E-06  +8.90000000E-06  -1.08430000E-04
   +6.55600000E-05  -6.29400000E-05  +3.80300000E-04  -3.28730000E-04  -3.24520000E-04
   +4.22700000E-05  +2.56090000E-04  +1.70580000E-04  -5.23811600E-02  -3.82424900E-02
   +6.46280300E-02  -3.79800000E-05  -3.14300000E-04  -3.69910000E-04  +7.63150000E-04
   +5.86600000E-04  +3.88720000E-04  -1.68200000E-05  +6.23400000E-05  -3.24880000E-04
   +3.32850000E-04  -9.26900000E-05  +7.40000000E-07  +3.22400000E-04  +1.75300000E-05
   +1.99370000E-04  -2.27530000E-04  +2.19690000E-04  +7.25100000E-05  -3.97278000E-03
   +5.64140000E-04  -1.34550000E-03  -2.37401860E-01  +9.23532400E-02  -8.16884800E-02
   -2.24250000E-04  +1.25700000E-04  -1.27270000E-04  +6.53210000E-04  -1.02011000E-03
   +6.27900000E-04  +1.79910000E-04  +4.67800000E-05  -1.58720000E-04  +1.15620000E-04
   +1.11690000E-04  -1.61500000E-05  +2.91500000E-05  +2.34200000E-05  +1.78390000E-04
   -2.36400000E-04  -1.63700000E-05  -3.14000000E-06  +3.10170000E-04  +1.48220000E-04
   -2.65870000E-04  +2.66100000E-05  -4.66000000E-06  -2.16700000E-05  -4.95700000E-05
   -4.47770000E-04  -4.70010000E-04  -1.15740000E-04  +1.02100000E-04  +1.94000000E-05
   -7.11000000E-06  -3.17000000E-06  +1.73000000E-06  +2.36600000E-05  +1.34100000E-05
   -8.22000000E-06  +2.55700000E-05  +3.48600000E-05  +8.72000000E-06  +3.51700000E-05
   -6.52700000E-05  +1.00800000E-05  -2.96000000E-06  +7.20000000E-06  -2.61000000E-06
   +3.06830000E-04  +3.54100000E-05  +7.00990000E-04  -1.89600000E-05  +8.08500000E-05
   -9.90100000E-05  +3.27840000E-04  -2.34050000E-04  +1.28800000E-04  -1.87948600E-02
   +1.04937200E-02  -9.18364000E-03  +2.54756100E-01  +1.84027000E-03  -4.88830000E-04
   +5.64590000E-04  -1.10879000E-03  -4.58077000E-03  -3.19291000E-03  -7.22780000E-04
   -5.03100000E-05  -8.25640000E-04  +2.63300000E-04  -1.90130000E-04  +9.35300000E-05
   -3.03340000E-04  +1.99750000E-04  +1.16910000E-04  -1.67880000E-04  -4.37090000E-04
   -6.53600000E-05  +2.54433100E-02  -1.44683900E-02  +1.05580000E-02  +9.02196500E-02
   -8.95683700E-02  +3.95647700E-02  +2.27940000E-04  -1.32950000E-04  +7.79400000E-05
   +1.36226000E-03  +8.23730000E-04  +9.89400000E-05  -2.37310000E-04  +2.00500000E-04
   -1.72300000E-05  -2.32560000E-04  -1.30370000E-04  -3.41200000E-05  -2.55660000E-04
   -1.75720000E-04  -1.34710000E-04  +2.66150000E-04  +7.82000000E-05  +7.05100000E-05
   -2.91010000E-04  -7.60500000E-05  +5.08400000E-04  +2.54370000E-04  +1.93150000E-04
   -8.32600000E-05  +1.79220000E-04  +8.00680000E-04  +1.62679000E-03  +1.26830000E-04
   +1.60700000E-04  -7.45600000E-05  -3.42800000E-05  -2.70700000E-05  -1.05500000E-05
   +9.90000000E-06  -6.86000000E-06  +1.29100000E-05  +2.21800000E-05  -6.56100000E-05
   -8.79900000E-05  +4.50000000E-07  +5.59600000E-05  -1.40840000E-04  +3.60000000E-06
   -6.32000000E-06  -7.44000000E-06  -2.31650000E-04  +3.50360000E-04  -8.04580000E-04
   -1.23180000E-04  +2.38400000E-05  -9.11600000E-05  -3.91800000E-04  +1.53230000E-04
   +1.52370000E-04  -1.60491600E-02  +8.52479000E-03  -8.16183000E-03  -1.00983260E-01
   +1.00084610E-01  +7.16020000E-04  -3.79580000E-04  +5.04260000E-04  -2.87320000E-04
   -2.65408000E-03  -1.19470000E-03  -5.47950000E-04  -2.11350000E-04  -5.24990000E-04
   +2.11510000E-04  +1.40000000E-07  +2.14700000E-04  -2.75900000E-05  -1.35510000E-04
   +9.13600000E-05  -4.61200000E-05  -1.52350000E-04  -9.74000000E-06  +1.14517200E-02
   -5.90960000E-03  +3.10167000E-03  -8.24060500E-02  +4.09387500E-02  -8.21931900E-02
   -2.63600000E-05  +4.73500000E-05  -4.34400000E-05  +1.95860000E-04  +1.93880000E-04
   +2.57070000E-04  +2.20610000E-04  +1.34060000E-04  +1.42680000E-04  -4.18500000E-05
   -5.95300000E-05  +3.87300000E-05  -4.53500000E-05  +2.61000000E-06  -1.43770000E-04
   +2.83460000E-04  +3.11700000E-05  +9.40600000E-05  -2.61980000E-04  -5.22500000E-05
   -4.34650000E-04  +6.68000000E-05  +2.21100000E-05  -2.20000000E-06  +1.37267000E-03
   -6.97720000E-04  +1.01951000E-03  -1.41810000E-04  +2.56680000E-04  +4.32200000E-05
   -7.60000000E-06  +1.61300000E-05  +3.96000000E-06  +4.40000000E-07  +4.18000000E-06
   +9.95000000E-06  -3.58400000E-05  -1.10800000E-05  -4.33500000E-05  -8.90000000E-06
   +5.81000000E-06  +1.64450000E-04  -1.94300000E-05  +1.69400000E-05  -1.78000000E-06
   -1.93520000E-04  -2.90370000E-04  -4.20590000E-04  +3.01400000E-05  +1.33700000E-05
   -5.29400000E-05  -7.67300000E-05  +1.91550000E-04  +1.10120000E-04  +7.31311000E-03
   -4.03683000E-03  +2.43957000E-03  +8.95963100E-02  -4.06182900E-02  +8.72533400E-02
   -4.38500000E-05  +1.84280000E-04  -5.54200000E-05  +2.65350000E-04  -3.77940000E-04
   +3.00320000E-04  -3.80270000E-04  +5.95960000E-04  +6.78800000E-04  -2.15870000E-04
   +8.24800000E-05  -1.58510000E-04  -1.32910000E-04  +2.07700000E-05  -1.69820000E-04
   +1.46320000E-04  -1.12340000E-04  +1.46100000E-05  -2.08356000E-03  -7.29010000E-04
   +3.88730000E-03  -4.90226100E-02  -1.63159000E-03  +2.30472700E-02  +1.01990000E-04
   -6.86900000E-05  +6.99300000E-05  -5.02500000E-05  +4.87100000E-05  -8.89860000E-04
   -9.26800000E-05  -8.01300000E-05  -2.81600000E-05  +8.30400000E-05  +2.02400000E-05
   -5.01000000E-05  -4.98800000E-05  -5.87000000E-05  +8.14000000E-05  -2.03890000E-04
   -9.22000000E-06  +3.49000000E-06  -1.51300000E-05  -2.47940000E-04  +1.60870000E-04
   +5.30600000E-05  +4.81200000E-05  -1.73500000E-05  -7.54700000E-05  +8.73440000E-04
   +6.71700000E-05  +1.58280000E-04  -1.97740000E-04  -5.74900000E-05  -8.83000000E-06
   -1.48100000E-05  -2.89000000E-06  +1.28000000E-06  +1.55600000E-05  +4.88000000E-06
   +1.35400000E-05  +3.30000000E-05  +4.02300000E-05  +1.86960000E-04  -1.88750000E-04
   -3.45100000E-05  +2.60800000E-05  -2.44900000E-05  -5.56000000E-06  +2.06480000E-04
   -1.77350000E-04  +3.38000000E-04  +2.83790000E-04  +9.98200000E-05  -3.96050000E-04
   +6.40040000E-04  +8.43000000E-06  +3.32270000E-04  -1.54343000E-03  -3.05960000E-04
   +2.48416100E-02  +2.99045000E-03  +1.07354000E-03  -2.76354200E-02  +5.10740100E-02
   -1.11360000E-04  -2.12880000E-04  +3.58700000E-05  -5.12250000E-04  +1.39075000E-03
   +1.82140000E-04  +4.08260000E-04  -1.70300000E-05  +2.78580000E-04  +9.05100000E-05
   -1.49540000E-04  +8.35000000E-05  +1.05890000E-04  +1.35520000E-04  +9.15400000E-05
   -1.65670000E-04  +8.16800000E-05  -1.93400000E-05  +1.46142000E-03  +2.43521000E-03
   -2.94056600E-02  -2.16677000E-03  -4.85709100E-02  +1.73472100E-02  -1.67400000E-05
   +1.70000000E-07  -6.95000000E-06  +1.03336000E-03  +1.44792000E-03  -3.14620000E-04
   -5.66720000E-04  -1.27300000E-04  -7.02000000E-05  +3.73930000E-04  +2.11590000E-04
   -2.81010000E-04  +8.20400000E-05  -4.75200000E-05  +4.45170000E-04  -3.04950000E-04
   -1.78530000E-04  +2.99020000E-04  -4.49900000E-04  -2.53330000E-04  -6.59460000E-04
   +1.54310000E-04  +8.65900000E-05  -4.54500000E-05  +5.32480000E-04  -5.77315000E-03
   -1.82660000E-03  -3.32300000E-05  +1.84500000E-05  -4.70200000E-05  -1.73400000E-05
   -1.30800000E-05  -5.10000000E-07  +1.96500000E-05  -8.41000000E-06  -2.14000000E-06
   +9.28800000E-05  +1.28700000E-05  +4.70700000E-05  +7.64400000E-05  -1.06290000E-03
   +5.01920000E-04  -1.83900000E-05  -1.72100000E-05  -1.52100000E-05  -2.43890000E-04
   -2.13100000E-05  +5.26200000E-05  +2.27050000E-04  -2.01300000E-05  +2.24200000E-05
   +2.74840000E-04  +2.41260000E-04  -2.00537000E-03  +6.92400000E-05  -1.21942000E-03
   +1.88568300E-02  -2.09263000E-03  -1.34421000E-03  +1.28943800E-02  +6.75070000E-04
   +5.29394000E-02  +2.04990000E-04  -1.69040000E-04  +1.49080000E-04  -1.06732000E-03
   +2.24380000E-04  +3.45500000E-05  -8.94430000E-04  -1.10300000E-04  -2.90950000E-04
   +3.79650000E-04  -3.80400000E-05  +2.74460000E-04  -1.08060000E-04  -6.33300000E-05
   +1.24650000E-04  -3.08600000E-05  +4.27200000E-05  +1.49800000E-05  +7.72600000E-04
   +1.93418000E-03  -1.23128900E-02  +2.26610200E-02  +1.50520300E-02  -3.12044810E-01
   +4.49200000E-05  -8.62000000E-06  -9.88000000E-06  +1.04035000E-03  +7.16300000E-04
   +4.40680000E-04  -6.52330000E-04  -2.14530000E-04  -2.03320000E-04  +3.52790000E-04
   +2.40420000E-04  -1.44040000E-04  +1.88570000E-04  -6.80000000E-05  +3.78820000E-04
   -5.11290000E-04  -1.33480000E-04  +1.93790000E-04  -1.45300000E-05  +7.48540000E-04
   -1.17080000E-04  -3.67700000E-05  -2.89200000E-05  +1.38000000E-05  +2.08980000E-04
   -3.89637000E-03  -2.89110000E-04  -1.65650000E-04  +3.76640000E-04  +7.07700000E-05
   +2.74000000E-06  -1.08200000E-05  -6.30000000E-07  +3.03000000E-06  -2.12900000E-05
   -9.82000000E-06  +1.12600000E-04  +4.92900000E-05  +8.18900000E-05  +2.66180000E-04
   +1.46480000E-04  +2.52640000E-04  -3.99300000E-05  +1.30000000E-06  +1.04900000E-05
   +8.04800000E-05  +7.94100000E-05  +4.54430000E-04  -8.73900000E-05  +1.18530000E-04
   +2.56120000E-04  +1.74080000E-04  -1.20300000E-05  -1.00653000E-03  -4.53970000E-04
   +1.49740000E-04  -5.53317000E-03  +1.69368000E-03  +6.29170000E-04  -1.06318200E-02
   -2.41730500E-02  -1.63136500E-02  +3.39399740E-01  -2.67864000E-03  +6.99000000E-04
   -3.06974000E-03  +8.66526000E-03  -1.80689700E-02  -1.22478800E-02  -7.47452800E-02
   +7.28947400E-02  +4.26671500E-02  -6.18057000E-03  +2.06579800E-02  +1.75714600E-02
   -2.34325000E-03  -2.92667000E-03  -6.36000000E-05  +1.47560000E-03  -4.75470000E-04
   +1.67600000E-04  -1.57710000E-04  -3.56290000E-04  +1.16372000E-03  -1.91976000E-03
   +1.00838000E-03  -2.33632000E-03  -2.46450000E-04  +7.30050000E-04  -7.67410000E-04
   -2.00960000E-04  +4.55600000E-05  -1.59900000E-05  -5.51000000E-05  -1.04000000E-05
   +3.14000000E-05  +5.67500000E-05  +3.10600000E-05  -3.80500000E-05  -5.70600000E-05
   -5.87700000E-05  +3.38500000E-05  +2.93900000E-05  +1.05600000E-05  +1.09800000E-04
   -7.37100000E-05  +1.01380000E-04  -2.60300000E-04  +1.01170000E-04  +7.17600000E-05
   -1.99300000E-05  +3.31030000E-04  +1.67570000E-04  +1.02000000E-04  -4.11364000E-03
   +6.21884000E-03  -5.11800000E-05  -1.16700000E-05  -1.26400000E-05  -2.20000000E-07
   +1.24300000E-05  -7.10000000E-07  +4.45000000E-06  +6.10000000E-07  -1.03500000E-05
   +9.73000000E-06  +1.87300000E-05  -1.07460000E-04  +1.16330000E-04  -3.00000000E-07
   -3.65000000E-06  -7.60000000E-06  -4.20000000E-05  +1.74100000E-05  +4.25300000E-05
   +1.53400000E-05  -2.68700000E-05  +1.00600000E-05  -9.19000000E-06  +3.21900000E-05
   +1.61130000E-04  -5.27330000E-04  +2.96920000E-04  -1.36110000E-04  -1.54600000E-04
   -2.97050000E-04  +2.69050000E-04  -2.26957000E-03  +9.94990000E-04  -2.45900000E-05
   +8.53468600E-02  -1.91800000E-03  +6.99698000E-03  -4.03945000E-03  -8.08800000E-04
   -1.40845300E-02  -1.30889600E-02  +8.02384600E-02  -2.08991300E-01  -1.28237030E-01
   -3.84230000E-03  +2.16682000E-03  -9.41666000E-03  -1.83219000E-03  -6.09788000E-03
   -5.25122000E-03  +5.30854000E-03  -7.35510000E-04  +2.40189000E-03  -6.58670000E-04
   -1.93395000E-03  +2.06972000E-03  +2.13159000E-03  -3.85420000E-04  +1.11610000E-03
   +4.71850000E-04  +2.86660000E-04  +4.35570000E-04  -3.15110000E-04  +3.33190000E-04
   -4.48440000E-04  -7.87500000E-05  -4.93000000E-06  +1.62630000E-04  -6.64000000E-06
   -5.74100000E-05  +5.05100000E-05  -1.24700000E-05  +1.94100000E-05  -1.08420000E-04
   +9.02600000E-05  +3.62800000E-05  +1.50980000E-04  -2.35290000E-04  -2.19900000E-05
   -3.11420000E-04  -1.35200000E-05  -1.47100000E-05  +4.43200000E-05  +3.81620000E-04
   -1.45260000E-04  +1.71030000E-04  -4.18620000E-04  +2.09861000E-03  +3.07487000E-03
   +7.92000000E-06  -1.05000000E-06  +2.20000000E-07  -3.63000000E-06  -1.86800000E-05
   +5.80000000E-06  +1.97000000E-05  +1.22600000E-05  +1.88600000E-05  -1.28650000E-04
   -1.49640000E-04  +8.57800000E-05  -1.82900000E-05  -1.50000000E-05  +1.44000000E-06
   -7.34200000E-05  +1.25310000E-04  +1.19930000E-04  +2.92500000E-05  -5.82000000E-06
   -1.04100000E-05  +1.71600000E-05  +5.02700000E-05  +9.09900000E-05  +9.36150000E-04
   -3.02370000E-04  +5.01900000E-04  +1.64940000E-04  +1.90350000E-04  +4.50510000E-04
   +5.17360000E-04  +1.09000000E-05  +5.38500000E-04  -7.92188600E-02  +2.21745800E-01
   -2.49853000E-03  -7.16377000E-03  +9.34000000E-05  +1.17250000E-02  -8.53827000E-03
   -5.95070000E-04  +3.25992100E-02  -1.33794260E-01  -1.45324950E-01  +3.51706000E-03
   -6.31698000E-03  +7.47811000E-03  +1.15801000E-03  +7.90979000E-03  +6.44198000E-03
   -5.29308000E-03  +1.39776000E-03  -2.60712000E-03  +2.38133000E-03  +2.47430000E-04
   -1.38240000E-03  -3.99200000E-04  -1.08270000E-04  +1.05300000E-05  +3.18880000E-04
   -8.99320000E-04  +1.16400000E-04  +2.22070000E-04  -1.62820000E-04  +4.36020000E-04
   +2.83000000E-05  +5.27100000E-05  -8.59900000E-05  +3.97100000E-05  +6.61000000E-05
   -5.49700000E-05  -1.79900000E-05  -5.07500000E-05  +9.07300000E-05  -4.70100000E-05
   +2.40700000E-05  -1.65700000E-05  +1.60300000E-05  +2.44000000E-05  +3.70100000E-05
   +7.44000000E-05  +5.85000000E-05  -4.32900000E-05  -3.88360000E-04  +1.05690000E-04
   -9.43100000E-05  +1.49940000E-04  -1.25502000E-03  -2.56105000E-03  -6.95000000E-06
   -1.27700000E-05  -2.67000000E-06  +1.50700000E-05  +8.09000000E-06  -2.52000000E-06
   -4.69000000E-06  -2.43600000E-05  -6.90000000E-06  +2.95800000E-05  -3.14500000E-05
   -7.50000000E-06  +1.40100000E-05  +2.52000000E-06  -7.76000000E-06  +2.09000000E-06
   -6.08000000E-05  -1.56710000E-04  -4.59000000E-06  -1.79800000E-05  -2.50900000E-05
   -3.90000000E-06  +6.13100000E-05  +2.04200000E-05  -4.05870000E-04  +8.34740000E-04
   -8.16610000E-04  +4.24580000E-04  +2.47710000E-04  +1.93220000E-04  -2.00700000E-04
   -4.92900000E-05  +4.68730000E-04  -4.45384800E-02  +1.47368120E-01  +1.39124020E-01
   +6.02600000E-05  +3.35250000E-04  +3.78150000E-04  -3.00889000E-03  +5.30580000E-03
   -1.77099000E-03  -9.68672000E-03  -1.29429500E-02  -1.86835500E-02  -1.59065760E-01
   -4.56186900E-02  -1.38895800E-01  -2.59483000E-03  -1.45367000E-03  +4.95590000E-04
   +3.67260000E-04  +1.67340000E-04  -7.32370000E-04  -3.45650000E-04  -1.14049000E-03
   -3.78020000E-04  -2.11800000E-05  -1.20370000E-04  -1.16700000E-05  +2.73550000E-04
   +2.57070000E-04  +3.85950000E-04  -8.07400000E-05  +2.73720000E-04  -2.34120000E-04
   -7.25500000E-05  -6.66000000E-05  +9.25500000E-05  -1.84000000E-05  -4.19600000E-05
   +1.84000000E-05  +9.22900000E-05  +6.40500000E-05  -4.14400000E-05  -3.93600000E-05
   -2.15700000E-05  -1.37200000E-05  -2.42100000E-05  -3.03000000E-05  -4.25600000E-05
   -1.23930000E-04  -8.29200000E-05  +4.85000000E-05  -2.05420000E-04  +6.59400000E-05
   +7.09600000E-05  +1.11267300E-02  +1.15379600E-02  +2.23286000E-02  +1.82300000E-05
   +1.09500000E-05  +7.00000000E-08  -2.06000000E-05  -1.25900000E-05  -2.40000000E-07
   +1.07600000E-05  +1.99800000E-05  +2.86000000E-06  +1.97100000E-05  +3.01400000E-05
   -2.50600000E-05  -1.61100000E-05  -9.60000000E-06  +9.84000000E-06  -1.39700000E-05
   +4.70100000E-05  -1.04660000E-04  +2.88900000E-05  +1.06500000E-05  +1.17800000E-05
   -6.65000000E-06  -1.84800000E-05  -6.87000000E-06  +3.52900000E-05  -1.72300000E-05
   +2.74000000E-06  -3.25900000E-05  +5.32200000E-05  -1.36500000E-05  +4.14000000E-06
   +1.46700000E-05  -1.70000000E-07  -3.12970000E-04  -6.10090000E-04  +1.10945000E-03
   +1.63379690E-01  -7.02420000E-04  -1.44751000E-03  +2.64730000E-04  +3.01724000E-03
   +1.14037000E-03  -2.32890000E-03  +6.88993000E-03  +8.95775000E-03  +9.49586000E-03
   -4.99466400E-02  -6.34704200E-02  -7.20712000E-02  -1.34474000E-03  +2.27508000E-03
   -1.23210100E-02  -1.24127000E-03  +1.64020000E-03  +2.29570000E-04  +3.93990000E-04
   +4.42150000E-04  -1.32460000E-04  -4.18200000E-05  +2.38700000E-05  +1.95900000E-05
   +8.35720000E-04  +8.89000000E-04  +2.45540000E-03  +2.33330000E-04  -1.11580000E-04
   +1.13570000E-04  +1.73700000E-05  -6.00000000E-08  -1.25000000E-05  +1.27500000E-05
   +3.26700000E-05  +7.20000000E-07  +4.47200000E-05  +1.64500000E-05  +1.81400000E-05
   -3.14700000E-05  -2.20000000E-06  -1.21900000E-05  +2.25300000E-05  -1.02400000E-05
   -2.81800000E-05  -3.03700000E-05  -2.30500000E-05  +9.78000000E-06  -2.26200000E-05
   +1.97500000E-05  -9.25400000E-05  -1.01043000E-03  -1.11453600E-02  -1.02490100E-02
   +5.21000000E-06  +4.31000000E-06  -1.94000000E-06  -2.13000000E-06  +6.08000000E-06
   -5.50000000E-07  +1.34800000E-05  -8.09000000E-06  +3.88000000E-06  +2.08600000E-05
   +2.12000000E-05  -2.35500000E-05  -6.41000000E-06  -2.87000000E-06  +2.11000000E-06
   +2.09000000E-06  +5.38400000E-05  -4.18000000E-06  -1.00000000E-07  +3.13000000E-06
   +1.98200000E-05  -7.74000000E-06  +8.60000000E-06  +3.87300000E-05  +1.42100000E-05
   -5.69700000E-05  -2.09000000E-06  -7.48000000E-06  +2.44000000E-06  -1.38600000E-05
   -4.46000000E-06  -4.50000000E-06  -1.49700000E-05  -1.54046000E-03  -1.01414000E-03
   +1.68224000E-03  +4.40468100E-02  +6.20544900E-02  +1.22957000E-03  -2.87360000E-04
   +1.26760000E-04  -4.01640000E-04  +9.84400000E-05  +2.40202000E-03  +9.33600000E-04
   -2.12741000E-03  +1.23018000E-03  -1.36187050E-01  -6.86991200E-02  -2.00083640E-01
   +4.35795000E-03  +6.28458000E-03  +6.87750000E-04  -1.47489000E-03  -1.22493000E-03
   +5.00130000E-04  +3.80000000E-07  -1.83480000E-04  +2.89170000E-04  -1.18100000E-05
   -3.13400000E-05  -4.27900000E-05  -2.50100000E-05  -1.50087000E-03  -2.65800000E-05
   -1.31940000E-04  +6.47800000E-05  -4.82200000E-05  -1.67500000E-05  +2.23000000E-06
   +1.36000000E-05  -6.38000000E-06  -1.69400000E-05  +3.96000000E-06  -6.13000000E-06
   +1.31000000E-06  -1.40700000E-05  +8.17000000E-06  +1.65000000E-06  +3.41000000E-06
   -2.09600000E-05  +2.03000000E-06  +5.72000000E-06  -3.81000000E-06  +5.20000000E-07
   +1.94000000E-06  +1.70800000E-05  -3.90000000E-06  +5.04900000E-05  -3.98495000E-03
   -1.76026900E-02  -2.65039500E-02  +1.58000000E-06  -1.53000000E-06  +2.70000000E-07
   +1.20000000E-07  -5.36000000E-06  -3.40000000E-07  -2.71000000E-06  +3.57000000E-06
   -1.00000000E-07  -5.20000000E-06  -1.14700000E-05  +5.16000000E-06  +2.56000000E-06
   -8.00000000E-08  -2.00000000E-07  -1.34400000E-05  -4.28800000E-05  +4.68000000E-06
   +2.63000000E-06  -3.09800000E-05  -9.00000000E-07  +2.04700000E-05  -6.30000000E-07
   -2.31900000E-05  -1.25300000E-05  +2.06900000E-05  -1.06300000E-05  +2.35000000E-06
   +2.53000000E-06  +1.07200000E-05  +5.75000000E-06  -7.66000000E-06  +1.52800000E-05
   +3.69910000E-04  +1.43111000E-03  -9.66260000E-04  +1.35742720E-01  +8.38784900E-02
   +2.22775590E-01  +4.05962000E-03  +2.70743800E-02  -1.03232000E-03  -2.36901000E-03
   +8.44150000E-04  -3.88762000E-03  +5.63530000E-04  +3.33330000E-04  +2.22060000E-04
   -2.17187000E-03  +6.24170000E-04  +3.84490000E-04  -5.01500000E-05  -2.59492400E-02
   +3.48866000E-03  -5.37207100E-02  -3.65937000E-02  -9.37119000E-03  +4.67400000E-05
   +7.21760000E-04  +6.10300000E-04  -3.28210000E-04  +7.71700000E-05  -1.08910000E-04
   +1.06870000E-03  +7.22780000E-04  +1.40508000E-03  +7.96100000E-05  +4.81300000E-05
   -5.15100000E-05  +6.38000000E-06  +1.27000000E-06  +1.31600000E-05  -1.48900000E-05
   -3.16900000E-05  +2.14800000E-05  -3.52000000E-05  -2.44000000E-06  -3.20200000E-05
   +9.11000000E-06  -4.88600000E-05  +1.75700000E-05  -1.80000000E-06  -2.14100000E-05
   -1.37100000E-05  +6.60000000E-07  -2.29200000E-05  +8.63000000E-06  +6.61500000E-05
   -6.93000000E-05  +1.23970000E-04  -3.93182000E-03  -5.51924000E-03  -2.52522000E-03
   -1.33900000E-05  +7.17000000E-06  +3.36000000E-06  -6.56000000E-06  +3.44000000E-06
   +2.68000000E-06  +7.05000000E-06  +6.00000000E-06  +5.32000000E-06  -3.94000000E-06
   +3.84700000E-05  +7.40000000E-06  -2.03600000E-05  +1.28100000E-05  +1.64600000E-05
   -1.45000000E-06  +2.02400000E-05  +8.90000000E-06  +6.33000000E-06  -1.20800000E-05
   -1.84500000E-05  +2.47500000E-05  -3.12000000E-06  -9.76000000E-06  +5.00000000E-08
   -2.73800000E-05  -6.69000000E-06  -3.93200000E-05  +1.02830000E-04  +5.27500000E-05
   +4.91000000E-06  +6.91000000E-06  +1.85400000E-05  -6.36000000E-06  -1.58820000E-04
   +1.93920000E-04  +1.27190000E-04  +8.87800000E-05  -1.44690000E-04  +5.66401100E-02
   -2.36201000E-03  -1.34599800E-02  +5.69500000E-04  +1.64967000E-03  +1.32843000E-03
   +3.36628000E-03  -1.21368000E-03  +5.08030000E-04  -3.95390000E-04  -1.90210000E-04
   -1.56167000E-03  +4.02330000E-04  +2.39977000E-03  -8.29923000E-03  +4.21853000E-03
   -3.92060900E-02  -3.38004350E-01  +2.29851200E-02  -1.28990000E-04  -3.29670000E-04
   -5.33650000E-04  +2.53410000E-04  -1.66900000E-05  +1.08660000E-04  +7.53220000E-04
   +8.29210000E-04  -9.80300000E-05  +2.98400000E-05  -1.18200000E-04  +6.71100000E-05
   -2.07700000E-05  -2.52000000E-05  -5.72300000E-05  +2.72700000E-05  +5.03500000E-05
   -4.62900000E-05  -1.65800000E-05  -2.35800000E-05  +6.60400000E-05  -1.02700000E-05
   +2.00300000E-05  -1.10000000E-06  +4.81300000E-05  +7.38000000E-06  +2.42900000E-05
   +6.31700000E-05  +5.15100000E-05  -3.01700000E-05  +2.76000000E-05  -1.14800000E-05
   -1.13530000E-04  -6.93750000E-04  +1.04600000E-05  -1.54141000E-03  -4.97000000E-06
   -8.03000000E-06  -2.08000000E-06  +1.10900000E-05  +5.97000000E-06  -1.07000000E-06
   -8.44000000E-06  -1.25900000E-05  -3.60000000E-06  -2.29000000E-06  -3.19400000E-05
   +1.18400000E-05  +1.93300000E-05  -5.06000000E-06  -1.46000000E-05  +1.98200000E-05
   -2.42500000E-05  +3.69900000E-05  -1.01000000E-05  +1.61000000E-05  -4.58000000E-06
   -1.45500000E-05  +1.21000000E-05  -5.87000000E-06  -1.19800000E-05  +1.20600000E-05
   +8.90000000E-07  +2.40400000E-05  -8.77500000E-05  -3.36700000E-05  -7.50000000E-06
   -5.51000000E-06  -1.54500000E-05  +6.49700000E-05  +1.30980000E-04  -2.33040000E-04
   +2.51400000E-05  -3.83400000E-05  -3.55500000E-05  +3.77933700E-02  +3.58118470E-01
   +7.27498000E-03  +3.36431000E-03  +4.40085000E-03  -2.48020000E-03  +4.30654000E-03
   +6.55022000E-03  -5.64454000E-03  -6.86650000E-04  -3.24071000E-03  +3.32518000E-03
   -7.71824000E-03  +2.64668000E-03  +2.22242000E-03  -7.91960000E-04  +1.00392400E-02
   -1.57341000E-02  +2.76265100E-02  -4.22770600E-02  -5.31100000E-05  +3.29710000E-04
   +1.09539000E-03  -1.44790000E-04  -1.97400000E-05  -1.74180000E-04  -7.40000000E-05
   -1.17887000E-03  -2.50851000E-03  +1.32450000E-04  +7.56900000E-05  -2.01000000E-05
   -7.80500000E-05  -9.78500000E-05  -3.01300000E-05  +1.72900000E-05  +3.65000000E-06
   -5.63300000E-05  +5.95200000E-05  +2.90700000E-05  +7.41000000E-05  -7.35300000E-05
   -1.00000000E-06  -2.30300000E-05  +7.09400000E-05  -4.56900000E-05  +3.84100000E-05
   -3.92300000E-05  -2.38700000E-05  -7.66000000E-06  +6.70700000E-05  -7.31700000E-05
   +2.66400000E-05  -4.70010000E-04  +2.11919000E-03  -1.03831000E-03  +4.82000000E-06
   +5.85000000E-06  +3.95000000E-06  -1.51000000E-05  +2.25000000E-06  -3.16000000E-06
   -8.59000000E-06  +1.75200000E-05  -7.06000000E-06  +1.21600000E-05  -2.46000000E-05
   -3.45200000E-05  +1.70000000E-05  -9.84000000E-06  -1.05000000E-05  -2.01500000E-05
   -3.18200000E-05  -2.74900000E-05  -7.94000000E-06  +1.14500000E-05  +2.45300000E-05
   -2.49700000E-05  -8.67000000E-06  -7.91700000E-05  +2.21900000E-05  +2.98900000E-05
   +7.24000000E-06  +1.77100000E-05  +9.09800000E-05  -1.05100000E-05  +1.25600000E-05
   -2.79400000E-05  -3.78000000E-06  +2.82980000E-04  +8.47960000E-04  -6.80980000E-04
   +1.07800000E-05  -3.02710000E-04  -5.09700000E-05  +8.60742000E-03  -2.79459000E-02
   +2.92046600E-02  -2.21892410E-01  -1.06162650E-01  -9.72711400E-02  +4.33147000E-03
   +2.78046000E-03  +1.00670000E-03  +1.34734000E-03  +7.64560000E-04  -1.37485000E-03
   +4.42490000E-04  -2.76380000E-04  +1.24337000E-03  +1.95680000E-04  +4.76396000E-03
   -3.44774000E-03  -1.83328500E-02  -1.23532900E-02  -1.07322100E-02  -9.27940000E-04
   +5.58540000E-04  +9.93290000E-04  -4.82100000E-05  -1.01980000E-04  +1.01710000E-04
   -1.52592000E-03  -5.35080000E-04  -1.00970000E-04  -1.24723000E-03  +1.59628000E-03
   +2.75210000E-04  -1.53970000E-04  +3.11370000E-04  +6.35800000E-05  -1.40130000E-04
   -1.76170000E-04  +8.49800000E-05  -3.35120000E-04  -1.92800000E-04  -1.96230000E-04
   +4.29060000E-04  +1.63780000E-04  +3.01400000E-05  -7.15960000E-04  +4.72810000E-04
   +4.14860000E-04  +2.17520000E-04  +1.50270000E-04  -4.48300000E-05  +1.29350000E-04
   -1.15880000E-04  -1.57060000E-04  +5.95670000E-04  -7.01000000E-06  -5.88850000E-04
   -2.75600000E-05  -2.30300000E-05  -7.00000000E-06  +1.81200000E-05  +9.35000000E-06
   +1.36400000E-05  +6.72700000E-05  -1.79400000E-05  -1.07000000E-06  +4.22100000E-05
   -8.70900000E-05  -5.19300000E-05  +1.01900000E-05  -9.10000000E-07  -1.19600000E-05
   -5.13000000E-06  +1.05530000E-04  +2.01350000E-04  +1.27200000E-05  -6.95000000E-06
   +5.17000000E-06  +1.84870000E-04  +4.24100000E-05  +1.75280000E-04  -1.11800000E-05
   -4.18000000E-05  -2.30300000E-05  +9.07600000E-05  +6.83000000E-06  +2.38300000E-05
   -2.48100000E-05  +1.77000000E-06  +4.55900000E-05  -1.19110000E-04  +4.11900000E-05
   -8.82900000E-05  -6.04900000E-05  +6.99700000E-05  -4.53100000E-05  -7.99000000E-06
   +6.54770000E-04  +2.22242000E-03  +2.37646780E-01  -1.03207400E-01  -1.23039330E-01
   -5.52218200E-02  -2.54421200E-02  -1.15466000E-02  -1.27972900E-02  +2.08945000E-03
   -4.79676000E-03  -2.32881000E-03  +1.11207000E-03  -1.41461000E-03  +6.86850000E-04
   +3.72768000E-03  -7.10010000E-04  +1.65103000E-03  +1.50009300E-02  +1.09147800E-02
   +6.94161000E-03  -1.58835000E-03  +6.57500000E-05  +2.16630000E-04  +5.90500000E-05
   +7.59400000E-05  -2.95000000E-06  +7.13980000E-04  +4.11130000E-04  -1.41760000E-04
   +5.53160000E-04  -2.06650000E-04  +5.38000000E-05  +3.59510000E-04  +2.21590000E-04
   +1.51980000E-04  +6.83200000E-05  -1.62000000E-05  +9.71900000E-05  +3.64250000E-04
   +1.48280000E-04  +1.95300000E-05  -2.18280000E-04  -1.67490000E-04  -5.56100000E-05
   +1.83400000E-04  +2.82820000E-04  -5.85270000E-04  -3.93050000E-04  -2.68900000E-04
   +1.27410000E-04  +2.47560000E-04  -5.37880000E-04  -5.87100000E-05  -1.16120000E-04
   +7.35000000E-05  -4.40160000E-04  +3.67300000E-05  +4.25800000E-05  +1.60400000E-05
   -4.22500000E-05  +4.50000000E-07  -1.23000000E-05  +4.55000000E-05  -4.52500000E-05
   +1.67800000E-05  -1.12500000E-05  -3.63000000E-06  +6.08700000E-05  -2.41800000E-05
   -1.12500000E-05  +2.40000000E-05  +2.52000000E-05  +1.78620000E-04  +1.94070000E-04
   +3.22500000E-05  +1.94640000E-04  -8.79300000E-05  +2.41800000E-05  -2.06450000E-04
   +6.52740000E-04  +2.28800000E-05  +1.28010000E-04  -3.75600000E-05  +7.04300000E-05
   -5.33000000E-06  +4.52700000E-05  -6.81800000E-05  +3.77800000E-05  +8.34900000E-05
   -9.53700000E-04  -1.20230000E-04  -1.42191000E-03  -1.27170000E-04  +9.71700000E-05
   -5.68600000E-05  -2.21080000E-04  +8.54340000E-04  +2.45620000E-04  +1.07430350E-01
   +1.29433620E-01  -9.70008400E-02  -4.75152100E-02  -8.76716800E-02  -3.33623000E-03
   -7.94723000E-03  -2.27040000E-04  -1.09790000E-03  -9.87770000E-04  +6.12436000E-03
   -1.24260000E-03  +3.76884000E-03  -2.37692000E-03  -3.89247000E-03  -3.24884000E-03
   +2.92412000E-03  -2.08308000E-03  -6.12940000E-03  +2.44113000E-03  +6.63650000E-04
   +8.81800000E-04  -2.92252000E-03  +2.00300000E-04  +2.55500000E-05  -2.43800000E-05
   -2.22360000E-04  +7.58500000E-05  +1.79080000E-04  -6.50900000E-05  -5.41700000E-05
   +3.09050000E-04  +4.16820000E-04  +4.43960000E-04  +1.63960000E-04  -1.62570000E-04
   -2.51580000E-04  +2.37070000E-04  +1.50700000E-04  +9.55700000E-05  -3.22110000E-04
   +2.23250000E-04  +3.02590000E-04  -9.94700000E-05  -1.97210000E-04  +6.13100000E-05
   -4.17100000E-05  -2.47330000E-04  -1.47550000E-04  +8.16600000E-05  -1.85350000E-04
   +4.45220000E-04  +1.04190000E-04  -1.10223000E-03  -6.10800000E-04  +1.86268000E-03
   +4.08100000E-05  +1.42200000E-05  +1.19200000E-05  -2.16300000E-05  -7.96000000E-06
   -7.64000000E-06  -6.92700000E-05  +6.74800000E-05  -7.78800000E-05  -6.14800000E-05
   -1.20220000E-04  -4.20000000E-05  +1.22600000E-05  -1.82400000E-05  -1.30000000E-06
   -1.59100000E-05  -2.94640000E-04  -2.10050000E-04  -6.42200000E-05  +3.79800000E-05
   +5.21600000E-05  -1.34910000E-04  +2.95210000E-04  -4.45110000E-04  +1.20900000E-05
   +6.17400000E-05  +9.01000000E-06  +2.60000000E-07  -5.82300000E-05  +6.82000000E-06
   -6.07000000E-06  -4.03800000E-05  -3.09900000E-05  +2.79540000E-04  -1.37690000E-04
   +9.14280000E-04  +1.44470000E-04  +8.34000000E-05  -4.89100000E-05  +1.65943000E-03
   -8.19480000E-04  -3.56287000E-03  +1.07444100E-01  +6.17910700E-02  +8.27401700E-02
   +8.09600000E-05  -1.35422000E-03  -1.43267000E-03  +2.81990000E-04  +4.14010000E-04
   +3.59320000E-04  -6.20020000E-04  -2.97230000E-04  -6.96480000E-04  -8.23460000E-04
   -1.45379000E-03  +1.41450000E-03  -4.24246100E-02  -9.60822000E-03  +2.92835000E-03
   -4.71980000E-04  +4.11041000E-03  -1.78780000E-04  -2.52750000E-04  +9.30400000E-05
   +1.51300000E-04  +7.27900000E-05  +1.53000000E-06  +2.31600000E-05  -4.27023200E-01
   -1.54657680E-01  +6.86441800E-02  +7.06000000E-06  -1.15770000E-04  +6.36200000E-05
   -8.99000000E-06  -1.14500000E-05  -4.05700000E-05  +4.11100000E-05  +4.74400000E-05
   -5.47400000E-05  -1.43120000E-04  -9.51700000E-05  +7.45500000E-05  +3.00400000E-05
   -8.03000000E-06  +4.24600000E-05  +1.49400000E-05  -4.96000000E-06  -3.81300000E-05
   +1.78990000E-04  +1.14240000E-04  -5.71900000E-05  +1.50830000E-04  -8.13900000E-05
   +1.80000000E-07  +6.54502000E-03  -3.65645000E-03  +1.16939000E-03  -3.25700000E-05
   -1.66500000E-05  +1.24000000E-06  +1.87700000E-05  +1.28700000E-05  +6.63000000E-06
   -1.40700000E-05  -9.31000000E-06  +0.00000000E+00  -2.77100000E-05  +7.77000000E-06
   +4.73700000E-05  -1.05000000E-06  +4.99000000E-06  -7.28000000E-06  +5.07200000E-05
   -3.12600000E-05  +7.52000000E-05  -7.65000000E-06  +2.74600000E-05  -4.05900000E-05
   -1.58300000E-05  +6.65000000E-06  -1.61000000E-05  -1.14500000E-05  +3.62700000E-05
   -1.50000000E-05  +4.38900000E-05  -2.61500000E-05  +1.91600000E-05  -2.67300000E-05
   +4.14000000E-06  +9.57000000E-06  +1.72070000E-04  -3.88000000E-06  -1.20990000E-04
   +2.07040000E-04  +2.11560000E-04  -1.99630000E-04  +1.21100000E-05  +3.75800000E-05
   +4.88420000E-04  -1.85520000E-04  +2.46230000E-04  -3.89700000E-05  +4.64182390E-01
   -6.46050000E-04  +1.22600000E-03  +3.82100000E-04  +2.90600000E-05  -6.90800000E-04
   -1.13360000E-04  -1.72260000E-04  -3.93030000E-04  +3.00940000E-04  +3.80083000E-03
   -1.93879000E-03  -2.73950000E-03  +2.90713400E-02  +7.36286000E-03  -2.78576000E-03
   +2.32114000E-03  -1.64285000E-03  +2.08822000E-03  -1.17480000E-04  -4.18000000E-06
   +7.27500000E-05  +4.10000000E-07  +2.55000000E-05  +9.90000000E-07  -1.97446530E-01
   -1.10184600E-01  +5.61479500E-02  -7.00000000E-06  +9.87000000E-06  -1.56400000E-05
   +1.18900000E-05  +1.07400000E-05  +3.73000000E-06  -7.43000000E-06  -1.20900000E-05
   +1.24400000E-05  +3.51700000E-05  +2.43600000E-05  -1.56500000E-05  -2.94000000E-06
   +1.60000000E-07  -9.73000000E-06  -2.20000000E-07  +5.33000000E-06  +1.17500000E-05
   -3.86800000E-05  -2.96300000E-05  +1.10500000E-05  +8.93400000E-05  -3.88000000E-05
   -1.25000000E-05  -3.39964000E-03  +3.71648000E-03  +1.79500000E-05  +5.42000000E-06
   +7.43000000E-06  +4.50000000E-07  -5.03000000E-06  +1.60000000E-07  -1.81000000E-06
   +2.89000000E-06  +2.26000000E-06  -7.00000000E-07  +1.42000000E-06  -1.19000000E-06
   +8.90000000E-07  +2.46000000E-06  +2.00000000E-06  +1.51000000E-06  +2.85000000E-06
   +3.40000000E-07  +3.49700000E-05  +2.28000000E-06  -9.76000000E-06  +7.00000000E-08
   +4.00000000E-06  +3.92000000E-06  +4.01000000E-06  +1.15000000E-06  -1.92600000E-05
   +8.08000000E-06  -4.56000000E-06  -1.90000000E-07  -8.84000000E-06  +8.02000000E-06
   -3.20000000E-06  -1.22800000E-05  +2.49400000E-05  -1.04000000E-04  +4.98700000E-05
   +4.89900000E-05  -3.53240000E-04  +7.91100000E-05  +1.54090000E-04  +1.08100000E-04
   -1.17660000E-04  +1.74740000E-04  -6.44300000E-05  -6.23800000E-05  +1.66055410E-01
   +1.02984500E-01  -1.53822000E-03  -3.04560000E-04  +3.08530000E-04  -3.54300000E-05
   -4.16600000E-04  -1.61160000E-04  +1.53710000E-04  -4.41350000E-04  -4.85480000E-04
   +1.54938000E-03  +9.25690000E-04  +4.71280000E-04  -2.75558800E-02  -1.08762300E-02
   +1.23152000E-03  -2.14797000E-03  +3.82790000E-03  -1.31226000E-03  -1.11300000E-04
   +6.88400000E-05  +2.70700000E-05  +2.40800000E-05  +9.09000000E-06  +3.92000000E-06
   +1.00504080E-01  +6.08433600E-02  -3.44467500E-02  -2.23800000E-05  -2.78300000E-05
   +1.04600000E-05  +1.61400000E-05  +1.41200000E-05  -6.58000000E-06  +1.03400000E-05
   +8.19000000E-06  -1.86700000E-05  -4.41700000E-05  -3.03500000E-05  +2.24700000E-05
   +1.60300000E-05  +2.57000000E-06  +1.29400000E-05  +7.26000000E-06  +1.13800000E-05
   -5.01000000E-06  +5.73900000E-05  +3.68800000E-05  -2.37400000E-05  +7.17400000E-05
   -5.13800000E-05  -4.04000000E-06  +1.22036000E-03  +2.65860000E-04  -4.25640000E-04
   -1.04900000E-05  -4.00000000E-06  +3.00000000E-06  +3.76000000E-06  +5.18000000E-06
   +1.72000000E-06  -1.03300000E-05  -2.97000000E-06  -4.65000000E-06  -1.39300000E-05
   -6.82000000E-06  +2.48700000E-05  +5.71000000E-06  +3.74000000E-06  -4.02000000E-06
   +2.68000000E-05  -1.40000000E-05  +3.18900000E-05  -4.70000000E-07  +3.03000000E-05
   -1.39700000E-05  -1.46400000E-05  -7.12000000E-06  -1.90000000E-06  -1.34000000E-06
   +1.64500000E-05  +1.07000000E-06  +1.28900000E-05  -7.36000000E-06  +8.25000000E-06
   -5.51000000E-06  +2.20000000E-07  -6.09000000E-06  +1.84710000E-04  -8.90500000E-05
   +1.38200000E-05  +1.01460000E-04  -7.04180000E-04  -3.06090000E-04  +3.30480000E-04
   +7.41200000E-05  -2.64910000E-04  -2.02760000E-04  +1.72950000E-04  -4.91000000E-05
   -7.25814900E-02  -5.33330200E-02  +3.53672400E-02
end_hess

