# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -959.77625290    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -2.00167965E+00  -2.69998763E+00  +2.14839542E+00
   006   -3.54439817E+00  -1.66551224E+00  -8.23346538E-03
   006   -2.35001199E+00  -2.27808885E+00  -2.51963838E+00
   006   -7.92273895E-02  -3.28938328E+00  -2.79722537E+00
   006   +1.54588328E+00  -3.97705549E+00  -6.12471996E-01
   006   +2.78674634E-01  -3.69695797E+00  +1.89594290E+00
   006   -3.99916537E+00  +1.27390369E+00  +2.91489364E-01
   006   -5.78441082E+00  +2.19896219E+00  -1.80375013E+00
   008   +3.69819656E+00  -1.50953487E+00  -5.64599740E-01
   006   -1.45578667E+00  +2.64883264E+00  +1.83304921E-01
   006   +1.66111109E-02  +3.01030443E+00  +2.34054883E+00
   006   +2.35373277E+00  +4.18736100E+00  +2.25640308E+00
   006   +3.29326740E+00  +5.06691126E+00  -3.03618265E-02
   006   +1.86700432E+00  +4.73673904E+00  -2.20453889E+00
   006   -4.59644643E-01  +3.54465961E+00  -2.08087910E+00
   008   +5.58396860E+00  +6.21358825E+00  -2.36030808E-02
   006   -5.36578221E+00  +1.80449662E+00  +2.79901486E+00
   008   +2.95308719E+00  -5.95976979E+00  -9.11864257E-01
   001   +6.03698622E+00  +6.68741477E+00  -1.70910473E+00
   001   +3.45898191E+00  +4.44485634E+00  +3.95558438E+00
   001   -6.44474848E-01  +2.35044672E+00  +4.15471644E+00
   001   -1.49661487E+00  +3.30899036E+00  -3.82204148E+00
   001   +2.57586523E+00  +5.39636022E+00  -4.00909427E+00
   001   -5.69529425E+00  +3.83009753E+00  +2.98172411E+00
   001   -7.18113744E+00  +8.39968002E-01  +2.82484584E+00
   001   -4.31614867E+00  +1.19476369E+00  +4.45686060E+00
   001   -7.60588869E+00  +1.26247638E+00  -1.63270973E+00
   001   -5.08395827E+00  +1.84329577E+00  -3.70262270E+00
   001   -6.06936590E+00  +4.23065421E+00  -1.61297663E+00
   001   -3.50637158E+00  -1.89832012E+00  -4.16362403E+00
   001   +6.93528813E-01  -3.73916550E+00  -4.63543652E+00
   001   +1.30149364E+00  -4.46490898E+00  +3.49390630E+00
   001   -2.90503358E+00  -2.65611815E+00  +3.98343230E+00
   001   +3.02834550E+00  -1.03473834E-01  +3.80012930E-01
   001   +4.87979555E+00  -5.60063833E+00  +3.72285463E-01
   008   -5.99908275E+00  -2.78895010E+00  +7.74611051E-02
   001   -5.79386133E+00  -4.57734855E+00  -1.09103697E-01
   008   +6.47326576E+00  -4.42610622E+00  +1.38710226E+00
   001   +5.31494416E+00  -2.57371056E+00  +4.81080243E-01
   001   +8.05811870E+00  -4.70826476E+00  +5.66501823E-01
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -3.10000000E-07  +4.90000000E-07  +5.10000000E-07
   +3.00000000E-08  +1.10000000E-07  +1.90000000E-07
   +4.00000000E-08  -5.60000000E-07  +4.60000000E-07
   +2.50000000E-07  -4.70000000E-07  +7.80000000E-07
   +4.60000000E-07  -7.70000000E-07  +1.04000000E-06
   -2.50000000E-07  +4.10000000E-07  +7.70000000E-07
   +5.00000000E-08  +1.00000000E-07  -6.40000000E-07
   +2.40000000E-07  -2.80000000E-07  -8.80000000E-07
   +1.80000000E-07  -4.30000000E-07  +4.80000000E-07
   +4.00000000E-08  +5.00000000E-08  -5.90000000E-07
   -1.70000000E-07  +4.20000000E-07  -5.80000000E-07
   -1.00000000E-07  +3.50000000E-07  -5.90000000E-07
   +8.00000000E-08  -1.60000000E-07  -7.50000000E-07
   +3.10000000E-07  -5.30000000E-07  -7.70000000E-07
   +1.40000000E-07  -4.30000000E-07  -6.40000000E-07
   +2.00000000E-07  -1.40000000E-07  -7.70000000E-07
   -2.50000000E-07  +6.70000000E-07  -7.80000000E-07
   -5.90000000E-07  +3.10000000E-07  +1.75000000E-06
   +3.00000000E-07  -5.00000000E-07  -9.10000000E-07
   -2.20000000E-07  +7.40000000E-07  -6.20000000E-07
   -2.60000000E-07  +8.40000000E-07  -5.40000000E-07
   +4.10000000E-07  -8.10000000E-07  -7.70000000E-07
   +4.70000000E-07  -9.20000000E-07  -9.30000000E-07
   -1.50000000E-07  +7.30000000E-07  -1.22000000E-06
   -1.90000000E-07  +7.80000000E-07  -6.90000000E-07
   -2.90000000E-07  +1.07000000E-06  -5.60000000E-07
   +1.80000000E-07  -2.20000000E-07  -8.30000000E-07
   +3.70000000E-07  -7.10000000E-07  -7.30000000E-07
   +2.10000000E-07  -2.50000000E-07  -1.32000000E-06
   +2.80000000E-07  -8.00000000E-07  +1.90000000E-07
   +3.30000000E-07  -1.03000000E-06  +9.30000000E-07
   -3.40000000E-07  +6.80000000E-07  +1.16000000E-06
   -3.80000000E-07  +9.10000000E-07  +3.60000000E-07
   -7.00000000E-08  -2.00000000E-08  +3.60000000E-07
   -1.00000000E-08  +2.00000000E-07  +1.94000000E-06
   -5.00000000E-08  +1.60000000E-07  +3.70000000E-07
   -1.20000000E-07  +7.00000000E-08  +4.90000000E-07
   -1.80000000E-07  -3.00000000E-08  +1.18000000E-06
   -5.00000000E-07  +1.50000000E-07  +1.36000000E-06
   -1.30000000E-07  -1.80000000E-07  +1.78000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +7.56200730E-01  -2.45109790E-01  +2.83712570E-01  -1.10806780E-01  -2.93968500E-02
   +6.00629320E-01  -1.01286650E-01  +3.16316500E-02  -4.10271600E-02  +4.75461660E-01
   +1.95741600E-02  -9.16903200E-02  +2.87006100E-02  -2.14414700E-02  +4.18141030E-01
   -3.38266200E-02  +3.90510300E-02  -1.67949040E-01  +2.67731000E-03  -8.90071000E-03
   +5.32448510E-01  +1.34879600E-02  -3.13494000E-03  -1.40437100E-02  -9.15523500E-02
   +1.11193200E-02  +2.41365000E-02  +7.75330340E-01  -3.85805000E-03  +4.23950000E-03
   +1.14572500E-02  +1.98660200E-02  -8.18041400E-02  -2.56968500E-02  -2.61073820E-01
   +2.80657420E-01  +5.85694000E-03  -3.62662000E-03  -3.52212400E-02  +3.31190500E-02
   -1.42821400E-02  -1.87368120E-01  +3.76982800E-02  +8.56314000E-03  +5.85597220E-01
   -2.44131000E-03  +1.01498000E-03  -2.86265000E-03  -1.06997000E-02  +1.00774500E-02
   +1.04566700E-02  -4.81991110E-01  +1.89349160E-01  +3.95467300E-02  +7.43809110E-01
   +1.13484000E-03  -4.63840000E-04  +9.42470000E-04  +7.83813000E-03  +3.01882000E-03
   -1.32274000E-03  +1.90658720E-01  -1.36409250E-01  -2.19558600E-02  -2.72271270E-01
   +2.76225400E-01  -1.15200000E-03  -6.50900000E-05  +6.66770000E-04  +2.40723600E-02
   -1.17497600E-02  +3.42402000E-03  +4.77685900E-02  -2.59543700E-02  -1.31341270E-01
   -7.31072700E-02  +5.57613300E-02  +6.38830550E-01  -1.72172100E-02  +7.40109000E-03
   +2.44276400E-02  -2.25593000E-03  -8.60005000E-03  +4.77040000E-04  -2.20591600E-02
   +1.26791000E-02  -1.74463500E-02  -1.08138020E-01  +1.61687800E-02  -5.68913300E-02
   +4.89217500E-01  +6.93076000E-03  +4.02780000E-03  -1.31910900E-02  -2.66188000E-03
   -1.02050500E-02  -1.68875000E-03  +9.86339000E-03  +2.43440000E-04  +9.77912000E-03
   +2.93726800E-02  -7.30163500E-02  +2.35874700E-02  -2.75809220E-01  +3.43861400E-01
   +1.18988500E-02  -9.95551000E-03  +9.65666000E-03  +5.14100000E-04  -6.28480000E-04
   +8.63595000E-03  -5.05781000E-03  +5.93958000E-03  +1.70103900E-02  -4.75345300E-02
   +1.37416300E-02  -2.01563970E-01  +5.66869000E-03  -1.95225000E-03  +5.69323780E-01
   -4.83703200E-01  +1.86417490E-01  +4.99271000E-02  -1.54263700E-02  +1.31221700E-02
   -5.32495000E-03  -1.79840000E-03  +7.39880000E-04  +3.11753000E-03  +1.48668500E-02
   -2.33517000E-03  -1.51904900E-02  -9.30294400E-02  +2.12978900E-02  +2.78245900E-02
   +7.53078570E-01  +1.89348580E-01  -1.36072570E-01  -8.66334000E-03  +1.21547100E-02
   +9.04880000E-04  -8.82720000E-04  +4.56090000E-04  -7.13800000E-05  -1.17782000E-03
   -3.35634000E-03  +8.02764000E-03  +6.10133000E-03  +6.51757000E-03  -6.90465600E-02
   +1.09740200E-02  -2.82825330E-01  +3.00153540E-01  +4.09494300E-02  -4.35598000E-03
   -1.27363560E-01  -1.91639700E-02  +8.11472000E-03  +1.00467600E-02  +1.38384000E-03
   -7.46800000E-05  -3.43500000E-04  +8.33862000E-03  +1.10456000E-03  -3.03696400E-02
   +3.23011800E-02  +3.96700000E-05  -2.07312050E-01  +5.56587000E-03  -7.38556500E-02
   +5.89018530E-01  -2.90938000E-03  +1.76566300E-02  +1.01243000E-03  -6.92156700E-02
   +2.87195500E-02  +1.86845000E-03  -2.07366000E-03  +1.34788700E-02  +2.66155000E-03
   -5.35410000E-04  -7.76820000E-04  +9.30380000E-04  +1.65837000E-03  +1.60936000E-03
   -1.53970000E-04  -9.46920000E-04  -6.21390000E-04  -1.39176000E-03  +4.95795190E-01
   +1.21021000E-02  -1.61157300E-02  +7.62048000E-03  +2.36060000E-04  -1.01286290E-01
   -2.41445000E-03  +9.39513000E-03  -9.47099000E-03  -1.17964600E-02  -2.91295000E-03
   -6.78740000E-04  +6.92300000E-04  +2.52319000E-03  +4.87160000E-04  +9.48300000E-05
   -3.04498000E-03  -8.66500000E-04  +1.84810000E-04  +1.07586000E-02  +4.18376830E-01
   -3.70987000E-03  +2.36455400E-02  +5.24470000E-03  -6.79800000E-04  -4.38912000E-03
   -7.72823300E-02  +6.37162000E-03  -2.87360600E-02  -2.14233000E-03  -9.44700000E-05
   +3.71000000E-05  -3.27637000E-03  -1.46800000E-04  +5.78700000E-05  -2.53430000E-03
   -9.32940000E-04  +3.87470000E-04  -2.93115000E-03  +1.63730000E-03  -8.03070000E-03
   +4.90719330E-01  -1.22950000E-04  -4.44000000E-05  +2.30210000E-04  -3.07419000E-03
   +7.97092000E-03  -4.50827000E-03  -6.49630000E-04  +4.43860000E-04  +1.25860000E-04
   +3.59510000E-04  -2.50800000E-05  -7.78500000E-05  -4.71530000E-04  -2.73590000E-04
   -2.99420000E-04  +2.73930000E-04  +8.87700000E-05  -1.27400000E-05  -1.12693940E-01
   +1.74599700E-02  -4.23759800E-02  +5.37366970E-01  -3.62510000E-04  -5.32523000E-03
   -3.14782000E-03  +2.14617000E-02  -1.82645500E-02  +2.49201100E-02  +6.23360000E-04
   -6.24280000E-04  -3.49370000E-04  +1.98630000E-04  -1.47000000E-05  +7.10720000E-04
   -1.20514000E-03  -6.14020000E-04  +9.58320000E-04  +8.69790000E-04  -2.47570000E-04
   +9.97520000E-04  +1.87817000E-02  -8.45324600E-02  +2.33450100E-02  +3.38426400E-02
   +5.73689680E-01  -3.17280000E-04  -1.70226000E-03  -6.61410000E-04  +9.23300000E-04
   +4.19445000E-03  +2.42007000E-03  +8.25460000E-04  +1.15680000E-04  +1.92387000E-03
   -2.66000000E-05  +6.23800000E-05  -8.80780000E-04  -2.78760000E-04  -1.28020000E-04
   +6.02310000E-04  +2.92150000E-04  +3.51300000E-05  +3.32230000E-04  -3.97575300E-02
   +2.10418100E-02  -1.28727960E-01  -5.80016900E-02  +2.94011600E-02  +5.41311350E-01
   +2.03639000E-03  -2.87592000E-03  +4.01935000E-03  +6.97830000E-04  -2.23271000E-03
   -4.50320000E-04  +1.62752000E-03  -2.60206000E-03  -3.62999000E-03  -2.61385700E-02
   -1.59816000E-02  -3.32163000E-03  -2.83197200E-02  +7.03573000E-02  +1.98323100E-02
   -2.70341700E-02  -1.69680100E-02  +2.33561000E-03  -6.95820000E-04  -1.52657000E-03
   -1.29000000E-05  +2.38800000E-04  +6.40270000E-04  +6.71800000E-05  +2.32464580E-01
   +8.64120000E-04  -1.64196000E-03  +3.01470000E-03  +4.47700000E-04  -2.06090000E-03
   +6.40970000E-04  +6.78960000E-04  -4.00960000E-04  -1.69981000E-03  -1.21455100E-02
   -4.13770000E-04  -3.12076000E-03  +4.30487600E-02  +2.21459500E-02  +1.23982600E-02
   -1.97048500E-02  -6.18126000E-03  +3.36581000E-03  -8.26070000E-04  -6.97850000E-04
   -1.31050000E-04  +3.60080000E-04  +7.13580000E-04  -8.48400000E-05  -2.00216420E-01
   +4.38692950E-01  -1.05093000E-03  +1.76149000E-03  -1.58594000E-03  +4.70900000E-05
   +1.47570000E-04  -2.88650000E-03  +5.67580000E-04  -1.45782000E-03  -2.62099000E-03
   -1.73903200E-02  -1.16849400E-02  +2.19858000E-03  +1.00889200E-02  +1.44856600E-02
   -3.79523100E-02  +1.73668500E-02  +1.24182200E-02  +7.38000000E-04  +1.65520000E-04
   -3.75800000E-05  +6.65030000E-04  +8.04200000E-05  -2.34100000E-04  -1.74320000E-04
   -5.88406500E-02  +1.72932840E-01  +2.46404960E-01  +4.88420000E-04  +5.42410000E-04
   +5.86970000E-04  +2.31132000E-03  -1.24862200E-02  -1.40769000E-03  +3.85640000E-04
   +4.88100000E-04  -6.14730000E-04  -4.27960000E-04  +6.65350000E-04  +1.76940000E-04
   +2.12858000E-03  +1.12283000E-03  -4.41200000E-05  -4.27590000E-04  +7.03170000E-04
   -2.09700000E-05  -1.50826380E-01  -3.81007200E-02  +1.39523000E-03  -2.48258600E-02
   -9.39103000E-03  -4.85883000E-03  -5.61840000E-04  -1.63071000E-03  -6.75100000E-05
   +5.32855590E-01  -2.03450000E-04  -1.14697000E-03  +6.53280000E-04  -2.64375800E-02
   -1.74235900E-02  +1.13218000E-03  -2.63340000E-04  -9.05150000E-04  -7.61710000E-04
   -6.46830000E-04  -7.77670000E-04  +6.91300000E-05  +3.41690000E-04  +8.12480000E-04
   +1.33180000E-04  -8.40780000E-04  -7.78980000E-04  -6.04800000E-05  -4.45041500E-02
   -9.56269200E-02  +4.34377000E-03  +6.71777000E-03  +4.92806000E-03  -3.23880000E-03
   +6.72660000E-04  -4.73810000E-04  +2.80660000E-04  +1.75261240E-01  +2.90556120E-01
   +1.71300000E-04  +1.08375000E-03  -5.24000000E-06  -2.60961000E-03  -2.28630000E-04
   -1.42262000E-03  -2.51580000E-04  -1.76134000E-03  -1.45710000E-04  -6.28150000E-04
   -5.67710000E-04  +1.32740000E-04  -1.75960000E-04  +1.74480000E-04  -5.35570000E-04
   +4.60870000E-04  +1.63990000E-04  +9.47600000E-05  +1.19469000E-03  +3.85329000E-03
   -9.18387600E-02  -2.29561300E-02  -1.29194400E-02  +1.36536000E-03  +7.07390000E-04
   -2.36850000E-04  -3.66860000E-04  +3.30713100E-02  -6.64329600E-02  +6.58981770E-01
   -3.20600000E-05  -3.78580000E-04  -1.45920000E-04  -1.02869000E-03  +1.43112000E-03
   -3.37700000E-05  -2.23780000E-04  +5.11900000E-04  -1.54400000E-05  +6.34950000E-04
   +1.76420000E-04  -7.94400000E-05  +1.06215000E-03  +3.25100000E-04  +2.72080000E-04
   +2.00000000E-06  -1.49890000E-04  +1.52260000E-04  -1.74677200E-02  -4.81079000E-03
   -2.13892400E-02  -3.18799000E-03  -2.85776000E-03  +1.06570000E-03  -1.51222000E-03
   -1.06189000E-03  -5.49430000E-04  -1.74021680E-01  -4.48050700E-02  -5.65914200E-02
   +5.89690240E-01  -4.24580000E-04  -2.64486000E-03  -6.90190000E-04  +1.74990000E-04
   -5.56860000E-04  +2.04200000E-04  -7.23200000E-05  +1.69160000E-04  -5.40000000E-06
   +1.18390000E-04  +8.67900000E-05  +5.80500000E-05  +1.00239000E-03  +1.14479000E-03
   +5.03080000E-04  -1.01938000E-03  -1.34168000E-03  -1.52100000E-04  -8.44651000E-03
   +6.87660000E-04  -1.31881600E-02  -9.89880000E-04  -1.34721000E-03  +1.17336000E-03
   +6.71880000E-04  -2.43593000E-03  -1.56088000E-03  -3.32755100E-02  -8.56397300E-02
   +1.53126000E-03  +2.20473840E-01  +2.75469060E-01  +1.67990000E-04  -3.11840000E-04
   +5.25200000E-04  +7.08180000E-04  +3.23410000E-04  +1.91850000E-04  -1.27150000E-04
   +3.68030000E-04  -2.77370000E-04  +3.85040000E-04  +3.05870000E-04  -1.84240000E-04
   +4.63200000E-05  -4.29680000E-04  +7.85630000E-04  -3.25150000E-04  -2.83400000E-05
   -4.15030000E-04  -4.69892000E-03  -3.21353000E-03  +7.65815000E-03  +2.33326000E-03
   +1.24007000E-03  -1.08760000E-04  -2.66860000E-04  -1.25800000E-05  -5.07540000E-04
   -1.16961180E-01  -2.79684700E-02  -2.54403240E-01  +7.19045000E-03  -9.41102200E-02
   +7.12502590E-01  -1.53960000E-04  +4.88920000E-04  +6.28200000E-05  -1.33172000E-03
   +6.12450000E-04  -6.32250000E-04  +1.09960000E-04  -4.86230000E-04  +2.86700000E-04
   -3.49630000E-04  -2.08860000E-04  +4.44000000E-06  -1.96937000E-03  -1.52251000E-03
   -7.71570000E-04  +7.41370000E-04  +3.61480000E-04  +1.55330000E-04  +2.80679000E-03
   -1.33795000E-03  -2.51201000E-03  -3.59340000E-04  -6.01310000E-04  +1.61250000E-04
   +5.42250000E-04  +3.04434000E-03  +1.57050000E-03  -2.94932700E-02  -6.33605000E-03
   -6.59621400E-02  -2.93580780E-01  -1.23002190E-01  +3.21297400E-02  +6.14955530E-01
   +2.96480000E-04  -1.50200000E-05  +8.59400000E-05  +5.22570000E-04  +3.96030000E-04
   -1.50000000E-06  +1.02480000E-04  +7.79200000E-05  +5.35000000E-06  -6.37700000E-05
   -1.63570000E-04  +1.33460000E-04  +8.96430000E-04  +1.08320000E-03  -3.09420000E-04
   -1.98020000E-04  -1.20840000E-04  +2.92000000E-05  -1.30741000E-03  +5.38685000E-03
   -9.98800000E-05  -8.72730000E-04  -6.03350000E-04  +3.32530000E-04  -8.86270000E-04
   -2.71095000E-03  -1.17058000E-03  -1.57828200E-02  +6.86747000E-03  -3.74228200E-02
   -1.12786870E-01  -1.20423430E-01  +2.73797000E-02  +2.31849660E-01  +2.57863030E-01
   -4.07700000E-05  -1.48120000E-04  -1.71880000E-04  +5.83530000E-04  -1.41770000E-04
   +7.46500000E-05  +4.72000000E-06  +1.50900000E-05  -1.34760000E-04  +8.41300000E-05
   +4.85000000E-05  +7.45500000E-05  +1.24750000E-04  -4.36210000E-04  -1.34100000E-04
   -1.15700000E-05  -6.61000000E-05  +1.91160000E-04  -2.26872000E-03  +1.46307000E-03
   -4.48532000E-03  -1.03135000E-03  -6.54720000E-04  +7.26100000E-05  -5.47200000E-05
   +3.50180000E-04  -1.13770000E-04  -1.97778100E-02  -1.68070500E-02  +4.12358800E-02
   -2.98005400E-02  -2.41311000E-03  -1.30837010E-01  +7.03297000E-02  -6.68946900E-02
   +7.16470990E-01  -1.10080000E-04  +9.60200000E-05  +2.95230000E-04  +7.35400000E-04
   -1.26484000E-03  -2.24380000E-04  -1.35800000E-04  +9.82000000E-05  -2.29390000E-04
   +9.79600000E-05  +1.65720000E-04  -1.05640000E-04  +7.54960000E-04  -1.46018000E-03
   -1.96460000E-04  +1.93400000E-04  +1.93640000E-04  +1.11640000E-04  -1.69788000E-03
   -1.04930000E-04  +3.17000000E-06  +2.21390000E-04  +2.50030000E-04  -4.15330000E-04
   -1.71256000E-03  +2.09698000E-03  -2.35330000E-04  +2.24235000E-03  +5.55220000E-03
   -8.82505000E-03  -9.59529000E-03  -1.20596200E-02  +3.30631900E-02  -1.33074580E-01
   -4.52555700E-02  +8.04618000E-02  +6.08737450E-01  -1.75900000E-05  +2.36890000E-04
   +2.27700000E-04  -3.72700000E-05  -3.81460000E-04  +3.35600000E-05  -3.62300000E-05
   +2.76970000E-04  -2.12270000E-04  +2.03010000E-04  +1.87690000E-04  -6.91200000E-05
   +3.58530000E-04  -1.04575000E-03  -3.69500000E-05  +1.69580000E-04  +1.40310000E-04
   +5.59000000E-05  -7.81780000E-04  -6.93420000E-04  +2.50720000E-04  +2.49040000E-04
   +2.40840000E-04  -2.65860000E-04  -1.24315000E-03  +6.38750000E-04  +1.55400000E-05
   +5.90359000E-03  -5.26029000E-03  +1.02025800E-02  -2.10723300E-02  -1.03593300E-02
   +9.66602000E-03  -3.38769000E-02  -1.00668920E-01  +7.98802400E-02  +2.17775280E-01
   +2.88503550E-01  +4.94700000E-05  +1.32140000E-04  +2.43900000E-04  -1.48340000E-04
   +2.12150000E-04  -4.77480000E-04  +2.49700000E-05  -1.72510000E-04  +1.27680000E-04
   -1.90650000E-04  -3.06500000E-04  +1.46590000E-04  +3.76060000E-04  +4.73840000E-04
   -7.90660000E-04  +1.64360000E-04  +1.64150000E-04  +9.76500000E-05  -5.62400000E-05
   +6.28300000E-05  -1.73257000E-03  -2.79620000E-04  -2.91750000E-04  +2.16170000E-04
   -2.32230000E-04  -1.14302000E-03  -1.17004000E-03  -9.13544000E-03  +9.81176000E-03
   -8.48990600E-02  +8.53174900E-02  +3.47886500E-02  +3.96874400E-02  +1.06947400E-02
   +4.45765800E-02  -2.92615930E-01  +2.94634500E-02  -8.12611100E-02  +7.13486190E-01
   +6.73100000E-05  -3.68050000E-04  -3.53620000E-04  -1.06349000E-03  +2.30580000E-04
   +9.22480000E-04  -1.40250000E-04  +5.20020000E-04  -3.02700000E-05  +4.75500000E-04
   +3.10700000E-04  -9.07500000E-05  -6.92230000E-04  -4.40790000E-04  +7.57680000E-04
   -4.40730000E-04  -1.49500000E-04  -1.03400000E-05  +3.14071000E-03  -1.85590000E-03
   +5.03570000E-04  +2.26810000E-04  -9.26800000E-05  +7.88200000E-05  +1.86250000E-04
   +1.00654000E-03  -6.35810000E-04  -8.38992000E-03  -2.15106100E-02  +7.57530500E-02
   -5.22801500E-02  -1.82326700E-02  -2.91833300E-02  +5.30102900E-02  +2.79973500E-02
   -2.98835300E-02  -1.65949010E-01  -4.14918400E-02  -4.73739500E-02  +5.96241470E-01
   +1.10150000E-04  -4.38700000E-05  -3.90300000E-05  +7.86610000E-04  +2.79430000E-04
   -5.56900000E-05  +2.57540000E-04  -1.65600000E-05  -1.91200000E-05  -1.20400000E-04
   -9.07200000E-05  -9.70700000E-05  +2.70100000E-05  +2.34240000E-04  +3.87360000E-04
   -1.32780000E-04  -9.79100000E-05  -1.32860000E-04  -1.44478000E-03  +5.52605000E-03
   +2.83430000E-03  +3.69310000E-04  +1.36400000E-05  -2.88000000E-06  -2.43250000E-04
   -7.10000000E-04  +3.72650000E-04  -1.33460000E-02  -5.31825000E-03  +3.30656100E-02
   -1.95927800E-02  -1.07914300E-02  -1.18167800E-02  +2.01280900E-02  +1.91485000E-02
   -4.23302000E-03  -2.74666600E-02  -8.52549800E-02  +1.29325800E-02  +2.32462070E-01
   +2.59980230E-01  -6.19100000E-05  +1.65450000E-04  -6.50000000E-05  -7.10600000E-05
   +7.03800000E-05  -6.71800000E-05  +6.00300000E-05  +1.17410000E-04  -1.38550000E-04
   -7.97500000E-05  -1.96300000E-05  +1.87550000E-04  +1.82190000E-04  +7.86860000E-04
   -7.22500000E-05  +3.18200000E-05  -1.03600000E-05  +3.84300000E-05  +2.24550000E-04
   +1.52702000E-03  -4.37555000E-03  -1.02679000E-03  -6.22790000E-04  -5.44400000E-04
   -1.83500000E-05  -1.11428000E-03  +6.47460000E-04  +2.82418600E-02  +1.03575800E-02
   +3.30463700E-02  -2.70226600E-02  -9.86690000E-03  -1.78712500E-02  +1.24109000E-02
   +1.61746600E-02  -5.09766200E-02  -1.22219500E-01  -2.39463700E-02  -2.80477340E-01
   +1.64529600E-02  -9.39234600E-02  +7.16755030E-01  -2.02030000E-04  +3.09250000E-04
   +1.92700000E-05  -1.36219000E-03  +1.42106000E-03  +5.23620000E-04  +7.48400000E-05
   -3.85150000E-04  +2.36200000E-04  -4.34600000E-05  -1.84650000E-04  -2.42020000E-04
   +4.66790000E-04  +1.33180000E-04  -2.25440000E-04  +5.07750000E-04  -9.47000000E-06
   -1.45900000E-05  -1.10454400E-02  -1.00770000E-02  +2.38400500E-02  -1.85263000E-03
   -2.15669000E-03  +8.60990000E-04  -5.13080000E-04  -4.52360000E-04  +2.71300000E-04
   -1.44762920E-01  -4.36066100E-02  +2.52556600E-02  +5.72189000E-02  +2.05562500E-02
   +1.39976800E-02  -3.97297400E-02  -2.22068200E-02  +2.66360800E-02  -3.32375400E-02
   -3.12311000E-03  -7.56614000E-02  -2.90618620E-01  -1.22250510E-01  +3.69317200E-02
   +6.01316840E-01  -1.25820000E-04  +2.26200000E-04  +3.48300000E-05  -1.15520000E-04
   -1.73890000E-04  -2.04300000E-04  -4.40640000E-04  -2.05617000E-03  +1.08870000E-04
   -4.86350000E-04  -7.91860000E-04  +4.91300000E-05  -2.82300000E-05  +1.05740000E-04
   -5.22380000E-04  +3.08300000E-04  +1.49310000E-04  +6.53800000E-05  -7.07956000E-03
   -3.07459000E-03  +1.28820500E-02  -9.18800000E-05  +5.25500000E-05  -1.34770000E-04
   +1.72720000E-04  -5.77040000E-04  +5.73680000E-04  -5.41990700E-02  -1.04289670E-01
   +4.93048700E-02  +3.00075300E-02  +1.88719900E-02  +1.88954200E-02  -2.28660000E-02
   -1.72604000E-02  +1.69119700E-02  -1.38783300E-02  +3.49084000E-03  -4.57258600E-02
   -1.12100930E-01  -1.21688970E-01  +2.98177400E-02  +2.18504590E-01  +2.67246040E-01
   +8.66300000E-05  -3.10820000E-04  -2.98180000E-04  -4.14300000E-04  -7.90690000E-04
   +1.05980000E-04  +5.92200000E-05  -2.17590000E-04  +5.65620000E-04  +2.48600000E-05
   -2.12710000E-04  -2.86890000E-04  +1.71100000E-05  +4.03020000E-04  +6.52320000E-04
   -4.87020000E-04  -1.76800000E-04  -1.39360000E-04  +7.01733000E-03  +3.00758000E-03
   +5.28775000E-03  +1.30800000E-05  +1.04480000E-03  +7.51440000E-04  +3.57440000E-04
   -1.08410000E-04  +2.90350000E-04  +8.63504900E-02  +8.05223800E-02  -2.71323000E-01
   -3.38330700E-02  -3.71334000E-03  -6.25614600E-02  +2.92615600E-02  +1.84259100E-02
   -2.34846200E-02  -2.18123400E-02  -2.02834400E-02  +5.01789100E-02  -2.79303600E-02
   -2.07774000E-03  -1.29598200E-01  +7.06225100E-02  -6.21074900E-02  +7.12270500E-01
   -2.23700000E-05  -6.47000000E-05  -4.65940000E-04  -9.29690000E-04  +1.54160000E-03
   +2.04310000E-04  +4.25000000E-05  -1.16750000E-04  +4.21900000E-04  -3.09100000E-05
   -1.90800000E-04  +1.07810000E-04  -1.81998000E-03  +7.90950000E-04  +1.00450000E-04
   -1.33400000E-05  -1.11910000E-04  -8.91100000E-05  +1.89298000E-03  +6.34190000E-04
   -1.97100000E-05  -4.84420000E-04  -6.60920000E-04  +4.73760000E-04  +2.39957000E-03
   -6.35730000E-04  +1.08870000E-04  -3.74280000E-03  -7.99910000E-04  +1.42186000E-03
   +2.57361000E-03  -5.93270000E-04  -1.13756000E-03  -2.57529900E-02  -2.02614100E-02
   +1.17242400E-02  -2.64937920E-01  -1.05387070E-01  -3.13450200E-02  -3.85049800E-02
   -2.37655600E-02  -3.38319000E-03  +5.01518000E-03  -6.85590000E-04  -3.93156000E-03
   +3.87914910E-01  -3.92200000E-05  -5.14500000E-05  -2.32510000E-04  -4.69940000E-04
   +7.25800000E-04  +1.08370000E-04  -6.53000000E-06  -8.65000000E-05  +2.23700000E-04
   -7.04500000E-05  -8.50700000E-05  +3.82400000E-05  -4.57430000E-04  +7.54060000E-04
   +9.25100000E-05  -6.97200000E-05  -7.52700000E-05  -3.90500000E-05  +1.29638000E-03
   -4.40830000E-04  -2.23390000E-04  -3.06480000E-04  -3.70390000E-04  +2.78020000E-04
   +7.16560000E-04  -5.54240000E-04  +7.81800000E-05  -1.44926000E-03  -1.27777000E-03
   -1.05195000E-03  +2.75220000E-04  +4.96825000E-03  +1.91516000E-03  -2.49354500E-02
   -7.34199000E-03  +6.89302000E-03  -1.12482450E-01  -9.99314900E-02  -5.43637000E-03
   -1.69369800E-02  +1.67370000E-03  -7.34450000E-04  -2.50502000E-03  +6.20947000E-03
   +1.25133000E-03  +1.94820040E-01  +1.45202610E-01  -1.99300000E-05  -2.10000000E-06
   +4.10000000E-06  +6.99000000E-05  -1.21170000E-04  -1.50500000E-05  +3.35000000E-06
   +1.33100000E-05  -5.53800000E-05  +3.43000000E-06  +2.48700000E-05  +5.35000000E-06
   +1.00980000E-04  -6.29900000E-05  -5.14400000E-05  +1.93000000E-06  +3.72000000E-06
   +2.98800000E-05  -9.35900000E-05  -1.62850000E-04  +3.68910000E-04  +4.18100000E-05
   +4.16200000E-05  -1.27270000E-04  -1.88220000E-04  +1.15740000E-04  +2.16990000E-04
   +1.06297000E-03  -1.06320000E-03  +7.14808000E-03  -7.04310000E-03  -8.22090000E-04
   -9.22617000E-03  +4.73063900E-02  +2.47838900E-02  +2.34810000E-03  +1.52702900E-02
   +1.83672800E-02  -1.10304410E-01  -3.87889700E-02  -1.87203700E-02  +5.19780000E-03
   +4.37814000E-03  +4.90820000E-03  -8.68833000E-03  -1.00522670E-01  -1.34139540E-01
   +5.89142830E-01  -7.11510000E-04  +3.41150000E-04  +4.51950000E-04  -1.99362000E-03
   +6.02769000E-03  +6.15034000E-03  -1.14070000E-04  +3.24520000E-04  -2.91200000E-04
   +2.00080000E-04  +4.82300000E-05  +6.31400000E-05  -3.28260000E-04  -2.97940000E-04
   +3.91060000E-04  +3.78390000E-04  +1.51600000E-05  -1.42710000E-04  -9.80924900E-02
   +7.38390000E-03  +3.82007200E-02  +8.09770000E-03  -3.22819000E-03  -1.71634000E-02
   +2.17740000E-04  +4.45850000E-04  -1.44060000E-04  -1.92379800E-02  +2.61104000E-03
   +2.79915000E-02  -1.61537000E-03  +3.62500000E-05  +4.92500000E-04  +3.94190000E-04
   +1.63630000E-04  +8.33630000E-04  +4.08070000E-04  +2.15770000E-04  +4.03420000E-04
   -1.80990000E-04  -1.28145000E-03  +6.22350000E-04  -3.56882000E-03  -5.46940000E-04
   -1.79579000E-03  -6.43570000E-04  -3.04710000E-04  +9.80000000E-06  +5.57793650E-01
   +6.99280000E-04  -7.28680000E-04  -2.53470000E-04  +1.63704800E-02  -1.20350500E-02
   -3.07533600E-02  +5.07400000E-05  -6.10433000E-03  +2.13677000E-03  +6.25820000E-04
   -1.22330000E-04  -1.22246000E-03  -1.41445000E-03  -4.17490000E-04  -9.74150000E-04
   +1.33430000E-04  +1.36420000E-04  -5.63800000E-04  +8.46379000E-03  -7.79989500E-02
   -1.55835800E-02  -4.27028000E-03  +2.78573000E-03  +9.55324000E-03  +6.84190000E-04
   +5.62150000E-04  +2.69140000E-04  -8.10183000E-03  +1.94424000E-03  +1.52880800E-02
   -1.98854000E-03  +5.76500000E-04  -6.46200000E-04  +5.18300000E-05  -3.47100000E-05
   +6.07480000E-04  +2.97100000E-04  +1.00700000E-04  +3.49440000E-04  -4.09810000E-04
   -8.59070000E-04  +4.67650000E-04  -2.74904000E-03  -9.37620000E-04  -9.13350000E-04
   -6.13100000E-04  -3.02130000E-04  +3.58400000E-05  +1.83422000E-02  +5.82600660E-01
   -3.78840000E-04  -6.25330000E-04  +2.00383000E-03  +2.52664000E-03  -7.68223000E-03
   -4.49931000E-03  +2.75950000E-04  +8.00370000E-04  +3.97800000E-05  -1.73160000E-04
   -1.09140000E-04  +1.67940000E-04  +2.31630000E-04  +3.90600000E-05  +3.70710000E-04
   -1.46150000E-04  +1.22590000E-04  -9.32920000E-04  +3.55725300E-02  -1.34364000E-02
   -1.49359560E-01  +7.91183000E-03  -2.03333000E-03  -3.76723100E-02  -3.86000000E-06
   +1.89430000E-04  -1.41840000E-04  +7.67723000E-03  +3.20211000E-03  -1.54358000E-03
   -6.41380000E-04  -1.33220000E-04  +7.56890000E-04  -2.77500000E-04  +3.06800000E-05
   -5.52910000E-04  +4.18530000E-04  +2.46730000E-04  +1.56370000E-04  -1.22410000E-04
   -1.92030000E-04  -4.18800000E-05  -9.03120000E-04  -1.20163000E-03  +4.31500000E-05
   -5.28750000E-04  -2.70710000E-04  -4.32300000E-05  +5.87482700E-02  -2.50126400E-02
   +5.10072370E-01  +1.83863000E-03  -1.49489000E-03  +5.14861000E-03  +3.00500000E-03
   +2.97906000E-03  -5.66550000E-04  +4.55620000E-04  -4.17400000E-04  -6.72391000E-03
   -2.31083700E-02  +4.19972400E-02  -1.10190000E-03  -2.14572410E-01  +1.33224940E-01
   +1.38628900E-02  -1.39011200E-02  +3.46038000E-02  +1.26653000E-02  -8.50120000E-04
   -1.52841000E-03  +2.91300000E-05  +2.05140000E-04  +7.76560000E-04  +1.02140000E-04
   +3.96940700E-02  -3.52767000E-03  +6.57660000E-03  -9.35400000E-04  -2.98700000E-05
   +1.49090000E-04  -3.58690000E-04  -1.13470000E-04  -1.01640000E-04  +4.82240000E-04
   +1.07690000E-04  -4.63130000E-04  -1.64801000E-03  -7.93900000E-04  +5.77000000E-06
   +3.86700000E-04  +1.95950000E-04  +3.94590000E-04  -1.51520000E-04  +4.45000000E-06
   +1.63880000E-04  +1.92488000E-03  +6.78440000E-04  -1.14590000E-04  +1.46690000E-04
   +8.44850000E-04  -6.61500000E-05  +2.87345350E-01  -6.43580000E-04  +2.14558000E-03
   -4.33961000E-03  -1.39656000E-03  -1.60702000E-03  +3.20480000E-04  +2.73630000E-04
   +1.27073000E-03  +4.67901000E-03  +2.31986000E-02  -1.83890900E-02  +2.95589000E-03
   +1.70515210E-01  -2.51249690E-01  -3.59394200E-02  +1.84849800E-02  -1.55571400E-02
   -1.12539400E-02  -9.31600000E-05  +3.66070000E-04  +8.85000000E-06  +3.17400000E-05
   -9.59900000E-05  -3.61600000E-05  -1.34459900E-02  -6.53691800E-02  -1.68678300E-02
   -1.35610000E-04  -1.75100000E-04  -5.42000000E-06  -2.65140000E-04  -4.72320000E-04
   +9.36000000E-05  +6.46650000E-04  -7.14440000E-04  +3.30310000E-04  +1.14237000E-03
   +5.32830000E-04  -3.20450000E-04  +1.26600000E-05  -1.84220000E-04  -4.79290000E-04
   -4.26700000E-05  +3.27000000E-06  -2.06950000E-04  -7.95130000E-04  -4.80060000E-04
   +7.67600000E-05  +4.93600000E-05  -1.42430000E-04  +3.15900000E-05  -1.76045950E-01
   +3.89418670E-01  +1.31824000E-03  +1.01357000E-03  -6.08479000E-03  -2.88500000E-04
   +5.96070000E-04  -4.23533000E-03  -2.00424000E-03  +1.94920000E-04  -4.67148000E-03
   -2.21908400E-02  +2.73503300E-02  +1.28040100E-02  +1.79808500E-02  -4.46857500E-02
   -1.11991760E-01  +2.89715300E-02  -3.47305200E-02  +1.08317000E-03  -7.88700000E-05
   -1.88060000E-04  +1.01460000E-03  +1.07510000E-04  -2.18400000E-04  -2.13520000E-04
   +3.50526000E-03  -2.90347000E-03  +9.62195000E-03  -4.73900000E-05  -6.01300000E-05
   +2.53230000E-04  -1.57950000E-04  -1.24700000E-04  -2.68310000E-04  +2.92890000E-04
   +7.87600000E-05  -2.90400000E-05  -1.95440000E-04  -9.29800000E-05  +1.84290000E-04
   -2.08430000E-04  -6.18900000E-05  +8.07700000E-05  +1.06170000E-04  +1.66980000E-04
   -2.24080000E-04  +2.35590000E-04  +3.87400000E-05  +3.12000000E-05  -1.05750000E-04
   +3.89490000E-04  -1.60340000E-04  +1.18574100E-02  +7.68181800E-02  +1.37719460E-01
   +9.10000000E-07  +4.99100000E-05  +5.19700000E-05  +2.67500000E-05  -1.64290000E-04
   -1.43000000E-05  -1.03800000E-05  +5.43700000E-05  -2.61800000E-05  +3.26400000E-05
   +3.92200000E-05  -3.97800000E-05  +2.12100000E-04  -2.57690000E-04  -2.17300000E-05
   +2.73800000E-05  +3.28500000E-05  +2.38400000E-05  -1.74240000E-04  -3.29300000E-05
   -1.16740000E-04  +4.27300000E-05  +5.40000000E-05  +3.04000000E-06  -3.09770000E-04
   +2.39840000E-04  -6.63900000E-05  +1.31470000E-04  +1.79930000E-04  -8.10120000E-04
   +1.15562000E-03  -6.20740000E-04  +1.66803000E-03  -5.48094000E-03  -3.38982000E-03
   -2.03590000E-03  -1.67460300E-02  -1.36735600E-02  +4.35295200E-02  +2.40991000E-03
   +1.42897000E-03  +1.46069000E-03  -7.27970000E-04  -1.75820000E-04  +4.47640000E-04
   -6.19041400E-02  -4.03628500E-02  +7.85538200E-02  +8.53100000E-05  +7.42200000E-05
   +3.80500000E-05  -3.26150000E-04  +1.78250000E-04  -3.64400000E-05  +8.18449400E-02
   -5.07000000E-06  +1.92900000E-05  +9.70000000E-07  -4.28100000E-05  -7.02100000E-05
   +1.18000000E-06  -1.15000000E-05  +2.63900000E-05  -5.15000000E-06  +5.61700000E-05
   +2.46400000E-05  -8.83000000E-06  -3.54270000E-04  -5.07020000E-04  -4.40800000E-05
   +8.41300000E-05  +4.75800000E-05  +1.74400000E-05  -9.10900000E-05  -6.02200000E-05
   -4.28600000E-05  +5.14600000E-05  +4.76200000E-05  -1.44700000E-05  +3.58230000E-04
   +5.66630000E-04  -1.62150000E-04  +1.74220000E-04  +1.83610000E-04  -3.38010000E-04
   -3.91000000E-04  +1.25957000E-03  +1.26271000E-03  -3.82518000E-03  +4.90060000E-04
   -1.12761000E-03  -7.34949000E-03  -9.63504000E-03  +2.18237900E-02  +2.31887000E-03
   +2.30410000E-04  -1.00880000E-04  -1.69700000E-05  -7.42440000E-04  +2.04050000E-04
   -4.70591900E-02  -4.35776900E-02  +1.09101870E-01  +1.74700000E-05  +1.74600000E-05
   +3.23500000E-05  +2.42500000E-05  +2.34760000E-04  +1.08200000E-05  +5.64082400E-02
   +5.18225400E-02  -1.85000000E-06  +3.65000000E-06  -3.53400000E-05  -9.96600000E-05
   +1.08320000E-04  +2.79500000E-05  +7.10000000E-07  +3.06000000E-06  +2.77200000E-05
   -8.06000000E-06  -2.15000000E-06  +1.32900000E-05  -3.56600000E-05  +1.08760000E-04
   +3.47700000E-05  -7.90000000E-06  -1.22800000E-05  -6.19000000E-06  +1.86340000E-04
   -1.13200000E-05  -7.05600000E-05  -3.54700000E-05  -3.76100000E-05  +6.28200000E-05
   +4.40700000E-05  -1.09870000E-04  -5.36100000E-05  -2.57420000E-04  -5.58300000E-05
   +2.62370000E-04  -1.51260000E-04  +3.29570000E-04  -3.67770000E-04  -5.83300000E-04
   -5.36300000E-04  +2.21014000E-03  -5.68040000E-04  -1.92980000E-04  -2.16257000E-03
   -4.67384000E-03  -3.17220000E-03  +4.08221000E-03  +2.18310000E-04  +2.43940000E-04
   -1.07574000E-03  +1.26208400E-01  +1.33107630E-01  -4.80540660E-01  -5.37200000E-05
   -2.47100000E-05  -5.07100000E-05  +7.62800000E-05  -7.51000000E-05  -2.66000000E-05
   -1.20583450E-01  -1.29887870E-01  +4.78267670E-01  -1.15300000E-05  +2.96000000E-05
   -3.17000000E-05  -1.22870000E-04  +1.82050000E-04  -2.74000000E-06  -1.61100000E-05
   +2.73000000E-06  +4.21200000E-05  +3.45000000E-06  -1.02100000E-05  +1.24800000E-05
   +2.77900000E-05  +8.11700000E-05  -3.61900000E-05  +1.00600000E-05  +2.27000000E-06
   +1.61900000E-05  +4.87000000E-05  +1.12900000E-04  -1.22199000E-03  -2.01380000E-04
   -2.53770000E-04  +1.36730000E-04  -5.16400000E-05  -8.92300000E-05  -3.01300000E-05
   -2.31985000E-03  -5.18043000E-03  +1.19903000E-03  -1.00208500E-02  -1.98586000E-03
   -2.42903300E-02  -1.35478890E-01  -2.79479200E-02  -1.29314710E-01  +9.27625000E-03
   +6.86260000E-04  +9.92441000E-03  +7.72500000E-04  -2.82792000E-03  +2.05948000E-03
   -7.21710000E-04  +3.28000000E-06  +8.63250000E-04  +2.27610000E-04  +1.85346000E-03
   -3.62950000E-04  +5.00000000E-05  -2.88900000E-05  -5.06400000E-05  +8.79000000E-06
   -4.96800000E-05  +6.05000000E-06  -5.42600000E-05  +2.65810000E-04  -1.27470000E-04
   +1.38610190E-01  -2.57900000E-05  -3.20000000E-07  -3.49700000E-05  -5.85500000E-05
   +8.47300000E-05  -2.12400000E-05  +4.43000000E-06  -3.26900000E-05  +3.76500000E-05
   +1.61600000E-05  -1.02000000E-06  -6.28000000E-06  -3.58630000E-04  -2.78260000E-04
   -4.92400000E-05  +5.39000000E-05  +4.70400000E-05  -1.87300000E-05  -2.23040000E-04
   +4.70540000E-04  -4.63340000E-04  -2.90990000E-04  -2.06850000E-04  +1.97500000E-05
   +4.25300000E-04  +2.78210000E-04  +2.74890000E-04  -4.83545000E-03  +4.66644000E-03
   +1.35666000E-03  -6.49872000E-03  +9.34420000E-04  -1.24075800E-02  -2.81459900E-02
   -4.46453400E-02  -2.59626400E-02  +5.63161000E-03  +5.97437000E-03  +9.16050000E-03
   -2.98731000E-03  +3.64585000E-03  +2.68358000E-03  -1.12960000E-04  -1.14529000E-03
   +2.60200000E-04  +1.96201000E-03  -2.23489000E-03  -1.09695000E-03  +7.28500000E-05
   +1.51000000E-05  -9.52200000E-05  +1.57610000E-04  +1.26190000E-04  +7.45700000E-05
   +2.49430000E-04  -3.60660000E-04  -2.11120000E-04  +3.27029700E-02  +3.65490600E-02
   -1.46300000E-05  +4.36000000E-06  -1.37200000E-05  -1.94000000E-05  +2.55900000E-05
   +5.15000000E-06  +2.10000000E-06  -3.40000000E-06  +1.74000000E-05  +1.94400000E-05
   +1.80000000E-06  -8.34000000E-06  -2.19090000E-04  -1.25630000E-04  +7.20000000E-06
   +2.65400000E-05  +9.73000000E-06  -1.50300000E-05  +1.44580000E-04  +1.44790000E-04
   +1.72830000E-04  -3.07000000E-06  -2.60400000E-05  -4.41000000E-06  +2.78370000E-04
   +1.17220000E-04  +1.57840000E-04  +7.48820000E-04  +1.27599000E-03  +1.98388000E-03
   +2.96164000E-03  +8.69790000E-04  +5.87168000E-03  -1.27971950E-01  -2.51604000E-02
   -2.59708640E-01  -1.87894600E-02  -5.60028000E-03  -1.79472800E-02  +2.54112000E-03
   +2.91484000E-03  -3.57021000E-03  +1.26828000E-03  +4.31810000E-04  +3.34000000E-06
   -4.46300000E-05  -9.22690000E-04  +1.87974000E-03  -3.04600000E-05  -5.33500000E-05
   -1.51000000E-06  +1.22930000E-04  +4.26400000E-05  +3.49900000E-05  -2.64500000E-05
   -1.59140000E-04  +3.58430000E-04  +1.40022930E-01  +2.73380300E-02  +2.71413460E-01
   +1.85690000E-04  -3.47220000E-04  -2.82710000E-04  +3.07370000E-04  -2.16550000E-04
   +6.30500000E-05  +4.91600000E-05  +9.87800000E-05  -5.87500000E-05  -2.68900000E-05
   +4.88000000E-06  +2.76100000E-05  +9.83400000E-05  +9.91800000E-05  +1.24000000E-04
   -2.43520000E-04  -2.18340000E-04  +2.16900000E-05  -1.37830000E-04  +1.44405000E-03
   +3.71080000E-04  -2.01520000E-04  +1.67420000E-04  +2.16450000E-04  -1.18940000E-04
   -3.36000000E-05  -1.26150000E-04  +1.07214600E-02  +5.84756000E-03  -1.42402400E-02
   -8.41922100E-02  -3.67363700E-02  +8.02408200E-02  -5.80236000E-03  -9.81477000E-03
   +2.61486000E-02  -2.47458000E-03  -5.09373000E-03  -1.36683000E-03  -1.05844000E-03
   +1.28950000E-04  -5.35010000E-04  -3.64410000E-04  -2.79830000E-03  -4.03885000E-03
   -4.48440000E-04  -4.61340000E-04  +1.44494000E-03  -1.49170000E-03  -2.26670000E-04
   -1.05899000E-03  -1.03920000E-04  -9.01000000E-06  -6.81300000E-05  -3.91220000E-04
   -1.12670000E-04  +5.58900000E-05  -1.84430000E-04  +2.16394000E-03  +8.45500000E-05
   +8.90104200E-02  -1.35650000E-04  -7.81870000E-04  -3.88530000E-04  -7.10370000E-04
   +1.62030000E-04  -2.43360000E-04  +3.10000000E-05  -4.19000000E-05  +7.70000000E-05
   -1.58200000E-05  +8.10000000E-07  +2.36600000E-05  +9.81900000E-05  -9.43000000E-05
   -2.77020000E-04  -4.28300000E-05  -1.64350000E-04  +2.00000000E-05  +9.81080000E-04
   -3.03118000E-03  -3.34400000E-04  +3.60070000E-04  +1.97110000E-04  -3.22100000E-05
   -1.17240000E-04  -6.20800000E-05  +1.63710000E-04  +1.74667000E-03  +5.35941000E-03
   -3.04810000E-03  -3.70721000E-02  -7.33552500E-02  +8.47101900E-02  -4.58960000E-03
   -8.22390000E-04  +1.35428700E-02  -5.00372000E-03  +5.58142000E-03  +2.73590000E-04
   +1.40070000E-04  -9.46910000E-04  -5.35700000E-04  -2.68069000E-03  +5.26750000E-03
   -2.57450000E-04  -3.30520000E-04  -2.25710000E-04  +7.55370000E-04  -8.38070000E-04
   -7.31300000E-05  -2.12130000E-04  -1.21150000E-04  +6.59000000E-05  +9.07700000E-05
   -9.19600000E-05  -2.32280000E-04  -1.68300000E-05  +2.10244000E-03  -3.30776000E-03
   -8.60420000E-04  +4.70531300E-02  +6.71363400E-02  -3.22380000E-04  +3.60720000E-04
   +4.38600000E-05  -3.99770000E-04  +8.11700000E-05  -2.58550000E-04  +4.43300000E-05
   +1.10600000E-05  +3.05900000E-05  -7.40700000E-05  -5.94900000E-05  +8.96300000E-05
   +4.10330000E-04  +1.64540000E-04  -6.02880000E-04  +4.19970000E-04  +2.35030000E-04
   +3.02840000E-04  +1.70987000E-03  -1.40000000E-05  -4.94820000E-04  -3.72000000E-05
   -5.78600000E-05  +1.26320000E-04  -2.22420000E-04  -3.36510000E-04  +2.04170000E-04
   +1.06306300E-02  +9.14603000E-03  -1.75856600E-02  +7.99659600E-02  +8.43769600E-02
   -2.85961680E-01  -1.56487000E-03  -4.57080000E-04  +2.42877000E-03  -1.23406000E-03
   +4.79890000E-04  +2.08615000E-03  -5.96330000E-04  -6.12090000E-04  +4.24880000E-04
   -4.22800000E-03  -4.06870000E-04  -3.29883000E-03  +2.72020000E-04  +1.53070000E-04
   -9.33400000E-05  +8.98360000E-04  +7.70270000E-04  -1.17050000E-04  -2.36550000E-04
   +2.56000000E-06  +1.61900000E-04  -4.38300000E-05  -6.31300000E-05  +4.86700000E-05
   +5.60930000E-04  -6.69250000E-04  +7.39760000E-04  -8.76399600E-02  -9.33598500E-02
   +3.00828590E-01  +4.98600000E-05  +7.77000000E-05  +7.73400000E-05  +3.58140000E-04
   -1.77560000E-04  -2.05420000E-04  +1.94270000E-04  -2.28360000E-04  +1.22600000E-04
   -1.94790000E-04  -1.51120000E-04  +3.04000000E-06  -2.42800000E-05  +7.11600000E-05
   -1.86020000E-04  -2.19300000E-05  +1.19200000E-05  -2.45000000E-06  -5.59860000E-04
   +1.48850000E-03  -3.77400000E-05  -2.04637000E-03  -8.15990000E-04  +1.29336000E-03
   -8.02000000E-06  -4.51200000E-05  +1.12150000E-04  +1.01438000E-02  +1.55738000E-03
   +8.82111000E-03  +1.12302000E-03  -3.27637000E-03  +2.36092000E-03  -7.32050000E-04
   +9.08000000E-05  +8.53580000E-04  -2.11980000E-03  -5.31651000E-03  +9.72780000E-04
   -1.06616100E-02  -3.55906000E-03  -2.50190100E-02  -1.27826250E-01  -2.40072600E-02
   -1.25342200E-01  -1.21364000E-03  -2.29600000E-04  -1.21396000E-03  -2.38500000E-04
   +1.71670000E-04  -1.18030000E-04  -6.60000000E-07  -1.62200000E-05  +7.86400000E-05
   +1.71250000E-04  +1.05740000E-04  -1.75310000E-04  -1.39440000E-04  +2.90430000E-04
   -4.26000000E-06  +4.75770000E-04  +6.66000000E-05  +6.00800000E-04  +1.36717700E-01
   +3.13700000E-05  -2.36600000E-05  -9.33400000E-05  -7.19040000E-04  +5.48000000E-05
   +4.12770000E-04  +7.89000000E-06  -4.71310000E-04  +2.56120000E-04  +2.54900000E-05
   +7.04100000E-05  -1.44770000E-04  +3.06960000E-04  -5.11800000E-05  +3.59080000E-04
   -4.86600000E-05  -1.61200000E-05  -4.46900000E-05  +1.42862000E-03  -3.03792000E-03
   -5.99850000E-04  -7.61290000E-04  +6.76600000E-05  +5.39030000E-04  -1.66290000E-04
   -7.42700000E-05  -1.72880000E-04  +6.07332000E-03  +6.01036000E-03  +8.32133000E-03
   -3.34898000E-03  +4.50728000E-03  +2.99659000E-03  +1.01990000E-04  -1.21743000E-03
   +1.16410000E-04  -5.17371000E-03  +5.08229000E-03  +1.63519000E-03  -7.98857000E-03
   +2.30809000E-03  -1.27803000E-02  -2.41354000E-02  -4.76027200E-02  -2.51198600E-02
   -5.08890000E-04  -2.79860000E-04  -6.38050000E-04  +3.63370000E-04  +2.71390000E-04
   -5.02400000E-05  -2.16580000E-04  +7.57500000E-05  -1.41040000E-04  +8.84500000E-05
   +3.92600000E-05  -9.73600000E-05  +2.91120000E-04  -5.26740000E-04  -1.20880000E-04
   +3.58380000E-04  +1.01690000E-04  +5.12460000E-04  +3.31256700E-02  +3.86167600E-02
   -5.48700000E-05  -2.62600000E-05  -2.01000000E-06  +6.92400000E-05  +6.10000000E-06
   -1.57100000E-04  +1.14650000E-04  -1.64190000E-04  -8.20700000E-05  -1.56490000E-04
   -1.69570000E-04  +2.18400000E-04  -3.87150000E-04  -1.05110000E-04  -3.72050000E-04
   +1.04340000E-04  +4.08800000E-05  +7.45600000E-05  -1.46059000E-03  -1.01052000E-03
   -3.04630000E-04  -8.81330000E-04  -6.96830000E-04  -1.29200000E-04  +1.88780000E-04
   +2.11860000E-04  +1.22670000E-04  -1.56805900E-02  -4.18547000E-03  -1.77044900E-02
   +2.56455000E-03  +3.20010000E-03  -3.89710000E-03  +8.99200000E-04  +2.14160000E-04
   +2.65640000E-04  +8.46050000E-04  +1.39985000E-03  +1.88455000E-03  +2.68320000E-03
   +1.25682000E-03  +4.42297000E-03  -1.24884090E-01  -2.49110300E-02  -2.68619590E-01
   -1.24680000E-04  -9.69300000E-05  +1.07460000E-04  +1.80370000E-04  +6.09000000E-05
   +1.40660000E-04  +1.97650000E-04  +6.73000000E-06  +1.30560000E-04  +3.12500000E-05
   +1.47500000E-05  -3.34500000E-05  -4.14800000E-05  -1.42880000E-04  -2.85100000E-05
   -8.86350000E-04  -2.57270000E-04  -1.02907000E-03  +1.36573130E-01  +2.62540300E-02
   +2.82057670E-01  -2.37800000E-05  -1.70000000E-06  -4.69600000E-05  -1.21900000E-04
   +1.99970000E-04  +6.04400000E-05  +7.43000000E-06  -3.81000000E-06  +4.53600000E-05
   -5.83000000E-06  -6.70000000E-06  -1.21200000E-05  -2.03200000E-05  +1.09900000E-04
   +5.17200000E-05  -9.51000000E-06  -1.47400000E-05  -1.70100000E-05  +3.07120000E-04
   -1.53840000E-04  +1.24681000E-03  +5.68100000E-05  -3.58700000E-05  +3.68300000E-05
   +2.31000000E-05  -1.12670000E-04  +5.24400000E-05  -2.86994000E-03  -4.95825000E-03
   -1.31669000E-03  -1.26525000E-03  -2.22000000E-05  -5.81460000E-04  -2.97240000E-04
   -2.32093000E-03  -3.68201000E-03  +7.55844000E-03  +4.31640000E-03  -1.52679900E-02
   -8.64347900E-02  -3.99255800E-02  +8.04566800E-02  -5.30823000E-03  -8.48449000E-03
   +2.67031000E-02  +2.13352000E-03  +3.03219000E-03  -2.09060000E-04  -2.38070000E-04
   -2.46910000E-04  -1.32910000E-04  +6.96800000E-05  -6.83600000E-05  -1.32800000E-05
   -4.62010000E-04  -5.90860000E-04  +6.87400000E-04  +4.08290000E-04  +3.77640000E-04
   -7.27100000E-04  -1.05010000E-04  +2.78510000E-04  +1.38810000E-04  -1.95580000E-04
   +2.09634000E-03  +1.90130000E-04  +8.70306400E-02  +1.40000000E-06  -1.83400000E-05
   -4.48200000E-05  -8.24700000E-05  +1.14050000E-04  +5.84900000E-05  -2.35800000E-05
   +1.04300000E-05  +2.53100000E-05  +3.61900000E-05  +3.08900000E-05  +4.02900000E-05
   -2.45020000E-04  -1.84910000E-04  +3.92200000E-05  +1.57000000E-05  +9.90000000E-07
   -4.57000000E-06  -2.15500000E-05  +2.76300000E-04  +6.13600000E-04  +7.88100000E-05
   -2.30400000E-05  +5.35100000E-05  +2.08340000E-04  +2.99270000E-04  -1.98970000E-04
   -4.85319000E-03  +4.57546000E-03  +2.31810000E-04  +1.09900000E-05  -8.95830000E-04
   -6.02150000E-04  -2.07566000E-03  +4.68337000E-03  -3.37990000E-04  -6.59020000E-04
   +4.37961000E-03  -3.39496000E-03  -3.99434100E-02  -6.73645000E-02  +8.11782000E-02
   -3.86250000E-03  -1.62068000E-03  +1.34160800E-02  +2.84168000E-03  -2.30660000E-03
   -1.17405000E-03  -2.91110000E-04  -2.17720000E-04  -2.03800000E-05  +7.73400000E-05
   +5.83900000E-05  -3.88000000E-05  -1.16430000E-04  +3.90440000E-04  +5.37150000E-04
   +1.07500000E-04  +3.38600000E-05  -1.82680000E-04  +2.88390000E-04  -5.53720000E-04
   -4.08700000E-05  +2.06743000E-03  -3.25521000E-03  -7.65090000E-04  +4.66276800E-02
   +6.16461500E-02  +6.04000000E-06  +3.80000000E-06  +2.20800000E-05  +3.47300000E-05
   -8.03200000E-05  -1.17300000E-05  +7.24000000E-06  +3.70000000E-07  -1.45100000E-05
   +7.60000000E-07  +2.01300000E-05  -1.61600000E-05  +1.01430000E-04  -3.89000000E-05
   +5.50000000E-07  -6.21000000E-06  +3.57000000E-06  +5.14000000E-06  -2.16640000E-04
   -8.12900000E-05  -3.92300000E-05  +4.11100000E-05  +7.15500000E-05  +7.06000000E-06
   -1.24430000E-04  +1.93200000E-05  +6.62800000E-05  -6.40120000E-04  +4.74420000E-04
   +2.30546000E-03  -9.69990000E-04  -6.75220000E-04  +2.06040000E-04  -4.27096000E-03
   -6.28280000E-04  -3.06395000E-03  +1.45647600E-02  +1.10872300E-02  -1.81993900E-02
   +8.04969500E-02  +8.17338700E-02  -2.76893020E-01  -1.17438000E-03  -5.79610000E-04
   +2.33133000E-03  +4.36390000E-04  -9.06740000E-04  +2.65122000E-03  +1.08900000E-05
   +5.71200000E-05  +3.35500000E-05  -9.41600000E-05  +4.59300000E-05  -1.49000000E-06
   -2.02447000E-03  -7.12270000E-04  -9.77540000E-04  +6.14120000E-04  +4.91970000E-04
   -9.92260000E-04  +9.54200000E-05  -6.26600000E-05  -5.83200000E-05  +5.41110000E-04
   -6.05930000E-04  +8.11010000E-04  -8.75923900E-02  -8.95045400E-02  +2.91917060E-01
   +1.93640000E-04  +9.78900000E-05  +1.89900000E-04  -2.27864000E-03  -5.54310000E-04
   +2.93143000E-03  +9.02900000E-05  +1.02092000E-03  -2.64530000E-04  -9.31700000E-05
   +2.43100000E-05  +2.36470000E-04  +3.56780000E-04  +1.69950000E-04  +6.55500000E-05
   -3.56900000E-05  -1.53700000E-05  +9.34200000E-05  -4.58959000E-03  +1.64027400E-02
   +2.32285000E-03  +1.36540000E-04  -1.61120000E-04  -1.03282000E-03  -1.71130000E-04
   -2.35680000E-04  -1.57000000E-05  +6.44280000E-04  +1.00854000E-03  -2.28250000E-04
   -5.63400000E-05  -2.56590000E-04  -4.94800000E-05  -1.09130000E-04  -2.36240000E-04
   -3.60500000E-05  -2.05690000E-04  -1.48400000E-05  -1.91290000E-04  +2.30700000E-04
   +1.19530000E-04  +7.27600000E-05  -1.18440000E-04  -2.44910000E-04  +2.28580000E-04
   +2.00220000E-04  +9.50600000E-05  -1.07600000E-05  -5.26995600E-02  +4.02191700E-02
   +2.30816000E-03  -2.03930000E-04  +7.25000000E-06  -3.17200000E-05  -3.11900000E-05
   -2.70000000E-06  +1.77100000E-05  -9.86000000E-06  +1.13400000E-05  +7.63000000E-06
   +6.23600000E-05  +3.75280000E-04  -1.18340000E-04  -1.75000000E-06  +2.47400000E-05
   -4.35500000E-05  +1.03200000E-05  +2.45500000E-05  -6.75000000E-06  +5.42085200E-02
   -2.92120000E-04  +1.26530000E-04  +4.95800000E-05  +5.60100000E-05  +8.48260000E-04
   -6.33440000E-04  -3.11800000E-05  -2.20340000E-04  +2.51950000E-04  +2.81200000E-05
   +6.27800000E-05  -1.85420000E-04  -3.72770000E-04  -1.08980000E-04  +1.53760000E-04
   +8.73400000E-05  +2.54200000E-05  -1.34490000E-04  +8.34940000E-04  -6.39982000E-03
   +1.17830000E-04  -2.90560000E-04  +2.74930000E-04  +9.40810000E-04  +2.46830000E-04
   +1.71900000E-04  -1.54000000E-05  -7.89470000E-04  +5.85620000E-04  +3.76180000E-04
   -1.49000000E-05  +1.68310000E-04  +1.46990000E-04  +2.00140000E-04  +1.67110000E-04
   -9.88100000E-05  +4.46600000E-05  -4.16300000E-05  +2.22150000E-04  -1.68960000E-04
   -1.06610000E-04  -9.09600000E-05  +4.06540000E-04  +3.08770000E-04  -1.85940000E-04
   +2.89000000E-06  +2.91600000E-05  -1.63200000E-05  +4.13338900E-02  -3.07993910E-01
   -2.10285000E-02  +2.81120000E-04  -6.59000000E-05  -2.55400000E-05  +9.76000000E-06
   -1.19100000E-05  -1.13000000E-06  +2.21700000E-05  -7.32000000E-06  -5.49000000E-06
   +1.22200000E-05  -1.71440000E-04  -4.45700000E-05  +6.65000000E-06  +5.74000000E-06
   +8.72000000E-06  +2.49200000E-05  -1.58300000E-05  -7.95000000E-06  -4.56831000E-02
   +3.32865970E-01  -2.63940000E-04  +7.97790000E-04  -8.90430000E-04  +2.45970000E-03
   +4.35800000E-05  -5.14823000E-03  +2.21700000E-05  -1.65486000E-03  +6.83990000E-04
   +1.72750000E-04  -6.09500000E-05  -3.00310000E-04  -5.03210000E-04  -1.12150000E-04
   -5.16080000E-04  +1.15670000E-04  -3.73300000E-05  +4.27300000E-04  +4.93678000E-03
   -2.80848200E-02  -4.22735000E-03  +3.40620000E-04  -1.40081000E-03  +8.80170000E-04
   +1.37780000E-04  +7.37100000E-05  +1.50130000E-04  -9.94420000E-04  -2.26930000E-04
   +1.07583000E-03  +9.35300000E-05  -9.98300000E-05  +1.85460000E-04  +8.96100000E-05
   -2.14100000E-05  +2.90000000E-06  +8.75200000E-05  +4.81900000E-05  +1.70940000E-04
   -1.36990000E-04  -9.87100000E-05  -1.29140000E-04  -2.76800000E-05  +3.30590000E-04
   -1.78440000E-04  -1.46190000E-04  -5.43500000E-05  -1.15100000E-05  +2.26488000E-03
   -1.93964300E-02  -4.77263000E-02  +2.18450000E-04  -3.35900000E-05  +1.95440000E-04
   +1.67300000E-05  +2.85000000E-06  -9.92000000E-06  +5.36000000E-06  -1.91000000E-05
   -1.14000000E-05  +1.53020000E-04  +2.16800000E-04  -1.16600000E-04  +4.45900000E-05
   -1.10200000E-05  -2.58600000E-05  +4.84000000E-06  -4.08100000E-05  -1.19000000E-06
   -5.75739000E-03  +2.28659600E-02  +5.39003600E-02  +1.28100000E-05  +3.01060000E-04
   +1.80700000E-04  -1.61003000E-03  -1.22739000E-03  +2.57740000E-04  +6.89600000E-05
   +1.66120000E-04  -2.09000000E-06  +7.23400000E-05  -8.42000000E-06  -2.85100000E-05
   -2.21010000E-04  -2.44330000E-04  -2.20500000E-05  +1.39590000E-04  +4.22200000E-05
   -7.05900000E-05  -1.42886600E-02  -6.76372000E-03  -1.24870000E-04  +4.98180000E-04
   +1.68710000E-04  -1.57727000E-03  +1.04970000E-04  +2.62500000E-04  +1.80000000E-07
   -4.33370000E-04  +7.16520000E-04  +2.70478000E-03  +1.04860000E-04  -4.19300000E-05
   +1.39860000E-04  -5.94000000E-05  +5.74600000E-05  +2.12140000E-04  +2.24130000E-04
   +1.58050000E-04  +8.83300000E-05  -1.39650000E-04  -2.14480000E-04  +1.72890000E-04
   -6.42830000E-04  -3.71100000E-05  -4.80850000E-04  -3.40170000E-04  -1.93000000E-04
   +3.49600000E-05  -2.60914380E-01  -1.13002250E-01  +1.17273000E-03  +9.60500000E-05
   +7.20100000E-05  +5.00000000E-08  +4.17500000E-05  +1.34800000E-05  -2.48400000E-05
   -2.82700000E-05  -1.85300000E-05  -1.55100000E-05  +3.70690000E-04  -4.09600000E-05
   +2.09720000E-04  +2.83500000E-05  +1.75700000E-05  +1.03730000E-04  -7.34300000E-05
   -7.86600000E-05  +1.16700000E-05  +6.79177000E-03  +3.47861000E-03  -2.16150000E-04
   +2.81834230E-01  -8.47700000E-05  -1.42000000E-04  -8.53000000E-06  +7.51290000E-04
   +3.96570000E-04  +3.18880000E-04  -2.57060000E-04  +4.19600000E-05  -1.26430000E-04
   -3.99900000E-05  +2.25800000E-05  +1.19650000E-04  +1.31410000E-04  +1.40000000E-06
   +1.47400000E-05  -7.46300000E-05  +1.38100000E-05  +3.60000000E-05  +6.21436000E-03
   +2.73160000E-03  +2.98930000E-04  -8.96800000E-05  -6.05100000E-05  +1.48550000E-04
   -1.03160000E-04  -2.40600000E-05  -1.97800000E-05  +3.69540000E-04  +2.05480000E-04
   -8.86210000E-04  +1.30000000E-04  +1.62730000E-04  +8.56100000E-05  +1.46150000E-04
   +1.08990000E-04  -1.49730000E-04  +1.46500000E-04  +2.11400000E-05  +1.94430000E-04
   -1.71360000E-04  -6.01200000E-05  -1.89910000E-04  +4.91860000E-04  +4.77570000E-04
   -2.05260000E-04  -8.72000000E-05  -3.79000000E-05  -1.84100000E-05  -1.15452220E-01
   -1.08425090E-01  +1.65291000E-03  -1.23510000E-04  +4.27200000E-05  -7.12000000E-06
   +1.12900000E-05  +1.04700000E-05  -8.98000000E-06  +3.20000000E-06  +3.21000000E-06
   +2.80000000E-06  -2.46660000E-04  -1.77570000E-04  -7.26900000E-05  -9.98000000E-06
   -2.62000000E-06  +2.13000000E-05  +2.59400000E-05  +1.68000000E-06  -6.69000000E-06
   -2.82221600E-02  -1.28078700E-02  -8.29800000E-05  +1.25129340E-01  +1.14561260E-01
   -2.85500000E-05  -1.28100000E-04  +1.15080000E-04  +5.22280000E-04  +5.59450000E-04
   +7.93740000E-04  -1.31960000E-04  +1.13040000E-04  -3.08600000E-05  -6.03400000E-05
   +1.45800000E-05  +3.89800000E-05  +1.74710000E-04  +4.33900000E-05  +3.11100000E-05
   -1.89500000E-05  -2.30000000E-06  -7.74500000E-05  +2.48143700E-02  +1.40049900E-02
   -1.15642000E-03  +1.60407000E-03  +6.28590000E-04  +9.47710000E-04  -1.10660000E-04
   -1.14950000E-04  +1.18500000E-05  +1.29767000E-03  -1.85791000E-03  -5.29747000E-03
   -6.61360000E-04  +1.79590000E-04  -7.29310000E-04  +4.64600000E-05  +8.40600000E-05
   +3.12520000E-04  -2.42660000E-04  -1.83580000E-04  -1.67190000E-04  +5.60900000E-05
   +4.12230000E-04  -1.20220000E-04  +1.36240000E-03  +3.86870000E-04  +4.19970000E-04
   +3.01490000E-04  +1.15160000E-04  +4.75000000E-05  -1.79416000E-03  +4.67770000E-04
   -4.71228400E-02  -9.38200000E-05  -5.01000000E-06  -3.24800000E-05  -3.37600000E-05
   -1.73800000E-05  +2.35800000E-05  +2.57400000E-05  +3.60000000E-05  +5.22000000E-06
   +2.25250000E-04  -1.58460000E-04  +5.09440000E-04  +7.06400000E-05  -1.27050000E-04
   -2.58000000E-05  +1.04310000E-04  +1.01040000E-04  -1.04800000E-05  -1.97297000E-03
   -6.01650000E-04  -1.17903000E-03  -1.73261000E-03  +5.30370000E-04  +5.36060100E-02
   -1.59270000E-04  +1.18307000E-03  -3.60280000E-04  +6.16180000E-04  -3.84800000E-05
   -9.99420000E-04  -1.60900000E-05  -2.54120000E-04  +2.38600000E-05  +8.68000000E-06
   -3.96000000E-06  -2.34100000E-05  -8.78100000E-05  +3.32100000E-05  -5.34100000E-05
   -1.46750000E-04  -6.51600000E-05  +2.57100000E-04  +9.43303000E-03  -6.31074000E-03
   +1.20197900E-02  -1.35321000E-03  +3.98420000E-04  +2.14537000E-03  +1.11600000E-05
   -9.95800000E-05  +3.15700000E-05  +5.53200000E-04  -3.92840000E-04  -9.17830000E-04
   -3.02399000E-03  -7.54090000E-04  +4.29760000E-04  -5.11700000E-05  -5.98400000E-05
   +2.98270000E-04  -1.50260000E-04  -1.24810000E-04  -2.11400000E-04  +1.50310000E-04
   +1.29380000E-04  +3.88000000E-05  +2.45500000E-05  -9.92500000E-05  +5.19600000E-05
   +1.20040000E-04  +5.30200000E-05  +3.24700000E-05  -1.22721850E-01  +4.28894300E-02
   -1.13933560E-01  +4.82400000E-05  -3.58300000E-05  +2.60800000E-05  -2.59200000E-05
   -1.06700000E-05  +9.92000000E-06  -1.22200000E-05  +2.90300000E-05  +1.09000000E-06
   -3.94579000E-03  -1.59062000E-03  +8.12850000E-04  +3.04000000E-05  +9.79000000E-06
   -4.08400000E-05  +1.42700000E-05  +2.08800000E-05  -6.00000000E-08  -3.19362000E-03
   +4.73740000E-04  -2.90142000E-03  -1.39713300E-02  +1.08853000E-02  -2.25273200E-02
   +1.36995030E-01  +7.65720000E-04  -1.01071000E-03  -6.53060000E-04  -5.71080000E-04
   +5.74110000E-04  -3.49800000E-05  +1.50970000E-04  +4.45400000E-05  +6.85000000E-05
   -7.33300000E-05  -1.10700000E-05  +4.62300000E-05  +3.31990000E-04  +1.65170000E-04
   -2.89820000E-04  -1.30490000E-04  -2.00000000E-06  +2.77920000E-04  -4.76032000E-03
   +6.11630000E-04  -5.40897000E-03  +3.27460000E-04  -1.21040000E-04  -8.58760000E-04
   -2.09510000E-04  -2.35430000E-04  +4.83800000E-05  +2.30710000E-04  +8.81500000E-05
   +2.85680000E-04  -2.28610000E-04  -4.41750000E-04  +8.62500000E-04  -1.98000000E-05
   -7.92200000E-05  -2.68310000E-04  -4.33500000E-05  +3.29000000E-05  +1.08900000E-05
   +9.36800000E-05  +4.62500000E-05  -6.12900000E-05  -1.66740000E-04  -3.60000000E-05
   -6.66800000E-05  +6.76000000E-05  +3.91300000E-05  -5.30900000E-05  +4.24062100E-02
   -7.08557900E-02  +6.58900700E-02  -2.23910000E-04  +1.92900000E-05  +8.28600000E-05
   -8.90000000E-06  +3.87000000E-06  +7.90000000E-07  -1.15200000E-05  -9.87000000E-06
   +1.17300000E-05  -1.41446000E-03  +4.26930000E-04  -1.72290000E-04  +1.80900000E-05
   +1.37200000E-05  -5.98300000E-05  +4.58000000E-06  +9.00000000E-07  -1.22000000E-05
   +1.71683600E-02  -8.42379000E-03  +2.58314100E-02  -7.76497000E-03  +5.15288000E-03
   -1.33300800E-02  -4.75401900E-02  +7.55477200E-02  -7.57900000E-05  +6.09310000E-04
   -6.78610000E-04  -7.71530000E-04  +1.03587000E-03  -2.31700000E-05  -3.06300000E-05
   -2.21200000E-05  +1.62290000E-04  +4.05200000E-05  -5.72200000E-05  +1.35340000E-04
   -9.85400000E-05  -8.34800000E-05  -6.94580000E-04  +9.43300000E-05  -2.48000000E-05
   +7.35100000E-04  -1.60909400E-02  +8.95158000E-03  -1.90639400E-02  +4.02708000E-03
   -1.89706000E-03  -5.13199000E-03  -1.28290000E-04  -7.94500000E-05  +2.25440000E-04
   -1.25937000E-03  -6.17460000E-04  +4.10140000E-04  -8.70110000E-04  -7.92500000E-05
   -6.40480000E-04  +2.33750000E-04  +1.07930000E-04  +6.52520000E-04  -1.04400000E-04
   -7.12300000E-05  +1.14730000E-04  -1.81760000E-04  -1.14800000E-04  +8.57100000E-05
   +2.84340000E-04  +1.78590000E-04  -1.29940000E-04  +2.19500000E-05  -2.69600000E-05
   +8.52300000E-05  -1.11320860E-01  +6.48419500E-02  -2.21312020E-01  -6.39900000E-05
   +5.78900000E-05  +2.31790000E-04  -1.19300000E-05  -7.32000000E-06  -2.20000000E-07
   +2.82000000E-05  +3.47000000E-05  -1.75300000E-05  +5.29320000E-04  -1.53000000E-05
   +1.32118000E-03  -1.68070000E-04  -4.47700000E-05  +1.42770000E-04  +1.53500000E-05
   +3.99000000E-06  -3.42000000E-06  +2.02206000E-03  -9.90750000E-04  +2.61219000E-03
   +5.18660000E-04  -4.05100000E-04  +5.74920000E-04  +1.24004220E-01  -7.14938600E-02
   +2.39620730E-01  +8.97900000E-05  +1.62730000E-04  +1.41500000E-05  -1.69646000E-03
   -1.27832000E-03  -8.28700000E-05  +1.34200000E-05  +3.38020000E-04  -6.00300000E-05
   +1.14410000E-04  +2.00800000E-05  +8.36000000E-06  -2.29250000E-04  -2.45500000E-04
   +1.85800000E-05  +9.95500000E-05  -6.20000000E-07  +1.72500000E-05  -1.84149500E-02
   -8.92221000E-03  +1.92531000E-03  -2.62120780E-01  -1.10655150E-01  +2.20677500E-02
   +1.10960000E-04  +2.69510000E-04  -2.20000000E-05  -1.18241000E-03  +1.68053000E-03
   -3.10129000E-03  -7.76590000E-04  -2.75930000E-04  +6.79550000E-04  -2.01640000E-04
   -1.83770000E-04  -2.59680000E-04  +2.26990000E-04  +2.08070000E-04  -8.17800000E-05
   -7.67400000E-05  +5.04800000E-05  -1.32830000E-04  +2.01140000E-04  -3.40100000E-05
   -3.08210000E-04  -3.62130000E-04  -2.14330000E-04  +2.16600000E-05  +5.59780000E-04
   -2.70900000E-04  +1.69573000E-03  +9.87000000E-05  +7.54600000E-05  +1.40500000E-05
   +4.03800000E-05  +2.95700000E-05  -2.35300000E-05  -8.10800000E-05  -8.57600000E-05
   -2.81000000E-06  -4.50000000E-06  +5.50400000E-05  -9.82700000E-05  +2.44900000E-04
   +4.81800000E-05  -1.69460000E-04  -3.87400000E-05  -3.42800000E-05  +2.43700000E-05
   -2.30900000E-05  +7.18200000E-05  -8.77000000E-05  +7.91710000E-04  +4.53000000E-05
   -4.62510000E-04  +3.29370000E-04  +3.19320000E-04  +1.94810000E-04  +2.83800170E-01
   -2.56260000E-04  +8.39000000E-06  +1.81480000E-04  +7.71610000E-04  +5.83190000E-04
   -4.65970000E-04  -9.49900000E-05  -2.02270000E-04  -4.26700000E-05  -6.62900000E-05
   +2.68400000E-05  +5.27000000E-06  +1.51100000E-04  +1.85900000E-05  -4.39100000E-05
   -7.51600000E-05  +3.90100000E-05  -1.10080000E-04  +1.00611500E-02  +4.81196000E-03
   -1.30069000E-03  -1.13774860E-01  -1.05263570E-01  +1.07853600E-02  -1.05210000E-04
   -4.52500000E-05  -8.70000000E-07  +8.24110000E-04  -4.48620000E-04  +1.52887000E-03
   +7.39150000E-04  +5.31250000E-04  +1.03850000E-04  -1.27660000E-04  -6.04700000E-05
   +2.40920000E-04  +6.61400000E-05  +3.24400000E-05  -2.08880000E-04  +1.83050000E-04
   +1.47500000E-04  +8.59600000E-05  -3.27500000E-05  +1.92020000E-04  +1.40520000E-04
   -3.76600000E-05  -2.92100000E-05  +1.65100000E-05  +1.59990000E-04  +1.79050000E-04
   -2.88190000E-04  -1.33130000E-04  +3.75500000E-05  -1.59000000E-06  +6.48000000E-06
   +7.29000000E-06  -4.85000000E-06  +4.72300000E-05  +7.83000000E-06  -2.60000000E-07
   -8.06000000E-06  -1.08600000E-05  -2.32500000E-05  -1.74060000E-04  -2.52620000E-04
   -7.93300000E-05  +4.96000000E-06  +1.25900000E-05  -4.30000000E-07  -2.20580000E-04
   -1.44360000E-04  +1.19900000E-05  -4.68600000E-05  +4.22950000E-04  -4.55000000E-06
   +2.21440000E-04  -5.76600000E-05  -6.18300000E-05  +1.22114720E-01  +1.11893780E-01
   +4.13400000E-05  -1.16140000E-04  -3.23000000E-05  +9.68500000E-05  -3.69820000E-04
   +6.55440000E-04  +2.80400000E-05  -5.51100000E-05  +8.15100000E-05  -2.14400000E-05
   +3.50000000E-06  -4.94900000E-05  -1.12600000E-04  +5.61000000E-06  +6.63000000E-06
   +4.68600000E-05  -6.00000000E-06  +2.30000000E-07  -2.07751200E-02  -1.14912600E-02
   +7.71750000E-04  +2.46087700E-02  +1.13905900E-02  -4.99796400E-02  +7.73600000E-05
   +6.77600000E-05  +1.88900000E-05  -1.94029000E-03  +2.47929000E-03  -3.88672000E-03
   -1.09907000E-03  -3.78950000E-04  +5.40640000E-04  -1.23780000E-04  -3.40120000E-04
   -1.59670000E-04  +1.86530000E-04  +2.01560000E-04  -2.05490000E-04  +1.00030000E-04
   -9.31000000E-05  +3.97370000E-04  +5.06580000E-04  +9.30800000E-05  -9.02300000E-04
   -1.88310000E-04  -1.01980000E-04  +9.87100000E-05  -1.57280000E-03  -7.50440000E-04
   +7.31700000E-04  +5.37700000E-05  -2.57000000E-06  -9.90000000E-06  -1.66700000E-05
   +4.03000000E-06  -2.27700000E-05  -8.04100000E-05  -9.00800000E-05  -4.10000000E-07
   -6.10600000E-05  +1.06020000E-04  +3.35500000E-05  -1.13030000E-04  -6.24100000E-05
   +6.18310000E-04  -1.76200000E-05  -2.42700000E-05  -2.72000000E-06  +7.25900000E-05
   -2.85500000E-05  -1.55000000E-06  +9.30300000E-05  +3.09920000E-04  -1.11899000E-03
   +2.56930000E-04  +5.70600000E-05  +2.85170000E-04  -2.26512300E-02  -1.45942700E-02
   +5.54531500E-02  -3.32900000E-05  -2.43330000E-04  -2.31700000E-05  +9.61790000E-04
   -3.07850000E-04  +7.79020000E-04  -2.65830000E-04  +1.09859000E-03  +3.35030000E-04
   -1.48470000E-04  -4.66600000E-05  -6.49400000E-05  -9.55100000E-05  +7.95400000E-05
   -8.66300000E-05  +6.87000000E-06  -2.25000000E-06  +4.15800000E-05  +8.97456000E-03
   -5.47884000E-03  -1.79626800E-02  -8.20396700E-02  +1.77826800E-02  +8.89232700E-02
   +4.57300000E-05  -9.20400000E-05  +4.57000000E-05  +8.98110000E-04  -3.65630000E-04
   +7.68470000E-04  -5.08000000E-05  -6.54900000E-05  -8.37300000E-05  +1.69060000E-04
   +1.18590000E-04  -8.23000000E-06  -8.57300000E-05  -1.35910000E-04  +1.96550000E-04
   -9.77000000E-05  -4.00000000E-05  -1.29040000E-04  -2.07192000E-03  -6.24220000E-04
   -9.38300000E-05  +9.85300000E-05  +7.04200000E-05  -2.50700000E-05  -2.50770000E-03
   +1.18017000E-03  -2.39273000E-03  +6.63000000E-05  -5.54400000E-05  +2.61000000E-05
   -1.53000000E-05  -1.42600000E-05  +7.74000000E-06  +6.48000000E-06  +1.55000000E-05
   -1.04000000E-06  +7.52500000E-05  -5.04000000E-06  +5.51600000E-05  -3.40612000E-03
   -1.58406000E-03  -3.50130000E-04  -1.08300000E-05  +9.16000000E-06  -1.09000000E-06
   -2.06970000E-04  -6.70000000E-05  -1.31800000E-05  +2.41980000E-04  +2.62480000E-04
   -2.16180000E-04  +8.24070000E-04  +2.18000000E-06  -1.15702000E-03  -9.22549000E-03
   +7.32509000E-03  +2.63078500E-02  +9.03445600E-02  +1.27800000E-04  +5.57400000E-05
   -1.02100000E-04  -5.97300000E-04  +7.01470000E-04  +2.63660000E-04  +1.02215000E-03
   -1.49579000E-03  +4.69680000E-04  -1.71350000E-04  +9.32800000E-05  -3.47580000E-04
   +3.79640000E-04  +8.26600000E-05  +3.56230000E-04  -8.98800000E-05  -9.36000000E-06
   -6.09100000E-05  -5.46137000E-03  +7.06800000E-04  +9.82787000E-03  +1.74254600E-02
   -5.52790800E-02  -4.49505900E-02  -2.19920000E-04  -1.74130000E-04  -9.63000000E-05
   -2.96000000E-05  +7.88400000E-05  -2.37130000E-04  -8.75100000E-05  -5.91900000E-05
   +1.16230000E-04  +7.52400000E-05  -1.43900000E-05  +4.68200000E-05  -4.91100000E-05
   +3.53600000E-05  -4.41800000E-05  +6.60200000E-05  -4.94300000E-05  +2.04880000E-04
   -4.59670000E-04  -2.88020000E-04  -8.77120000E-04  +8.76600000E-05  +2.83000000E-05
   +4.15200000E-05  +1.32229000E-03  -7.58820000E-04  +1.44245000E-03  -2.59250000E-04
   +4.71600000E-05  -1.41340000E-04  -3.32200000E-05  -3.32000000E-06  -6.27000000E-06
   +2.25000000E-06  +2.01000000E-06  +1.04400000E-05  -2.48000000E-06  -3.70000000E-07
   +4.36900000E-05  -1.43059000E-03  +1.40410000E-04  +1.49140000E-04  -1.37000000E-06
   -2.95000000E-06  -1.61100000E-05  -9.35600000E-05  +4.29630000E-04  +3.17350000E-04
   +3.10060000E-04  -2.20200000E-05  -1.91110000E-04  -7.92600000E-05  +7.36580000E-04
   +7.19690000E-04  -4.80578000E-03  +2.97851000E-03  +1.47191200E-02  -1.99503800E-02
   +5.87855200E-02  +8.94000000E-05  +4.93800000E-05  +1.49800000E-04  +4.56690000E-04
   -9.16140000E-04  -4.43510000E-04  +2.07830000E-04  -9.30630000E-04  -8.36880000E-04
   +2.32200000E-05  -1.13230000E-04  +7.59700000E-04  +1.65100000E-05  +1.97830000E-04
   -6.31510000E-04  -2.13700000E-05  +2.26600000E-05  +1.32330000E-04  +9.91206000E-03
   -4.85691000E-03  -1.85761600E-02  +8.63062300E-02  -4.39387100E-02  -2.77093370E-01
   +1.07290000E-04  -3.51100000E-05  +2.26840000E-04  +1.05696000E-03  +6.14880000E-04
   +8.18700000E-05  -3.15930000E-04  -9.58700000E-05  -3.69400000E-05  +1.36250000E-04
   +3.08900000E-05  +9.06600000E-05  +1.66550000E-04  +7.02200000E-05  +1.91900000E-05
   -3.91100000E-05  -2.12440000E-04  +7.27550000E-04  +1.00270000E-03  +4.48170000E-04
   -8.44250000E-04  -7.43000000E-06  +4.87000000E-06  +1.07990000E-04  -4.37942000E-03
   +2.32292000E-03  -3.38405000E-03  +1.03100000E-04  -7.61900000E-05  +2.21840000E-04
   -3.31100000E-05  -2.14000000E-05  -1.52500000E-05  -1.91700000E-05  -1.03200000E-05
   +7.10000000E-07  +1.86980000E-04  +2.09000000E-06  +1.11480000E-04  +2.12580000E-04
   -1.10200000E-05  +1.42705000E-03  -2.86300000E-05  -2.18900000E-05  -2.29400000E-05
   -8.07000000E-05  +3.04600000E-05  +3.90390000E-04  -1.10800000E-04  -4.15400000E-05
   +3.33080000E-04  +7.34660000E-04  -2.91450000E-04  -1.52712000E-03  +6.28260000E-04
   -6.41980000E-04  -1.98941000E-03  -9.75508100E-02  +4.88053000E-02  +3.01127570E-01
   +1.75760000E-04  +1.19586000E-03  +5.90630000E-04  -3.33779000E-03  +1.30060000E-04
   -3.32899000E-03  +1.73620000E-04  +2.87000000E-05  -3.29690000E-04  -4.94900000E-05
   +1.41500000E-05  -3.48000000E-05  +4.08410000E-04  +2.25140000E-04  -1.55540000E-04
   -1.97560000E-04  +5.51700000E-05  -2.44710000E-04  -5.15464000E-03  +2.12633100E-02
   +1.25383000E-03  -5.04816000E-02  +3.36437600E-02  +4.30523000E-03  -1.90850000E-04
   -2.60870000E-04  +4.25800000E-05  +8.44190000E-04  +9.84620000E-04  +3.93090000E-04
   -1.52500000E-04  -2.43410000E-04  -2.85230000E-04  +2.71980000E-04  +1.46020000E-04
   -9.41700000E-05  -1.60260000E-04  -8.44100000E-05  +2.38230000E-04  -1.38740000E-04
   -2.26420000E-04  +6.13200000E-05  -8.96100000E-05  -1.68490000E-04  -6.56500000E-05
   +2.26350000E-04  +1.14370000E-04  -1.66700000E-05  +1.98690000E-04  -1.21830000E-04
   +1.08148000E-03  -2.30150000E-04  +7.30000000E-06  +2.13000000E-05  -3.78400000E-05
   -8.51000000E-06  +1.45100000E-05  +5.33000000E-06  +3.11600000E-05  +8.61000000E-06
   -1.25000000E-06  +2.23500000E-05  +5.48600000E-05  -5.96300000E-05  +3.50100000E-04
   +2.62240000E-04  -7.53000000E-06  +2.07600000E-05  -1.00000000E-05  +4.75400000E-04
   -2.54360000E-04  -1.08080000E-04  -1.61300000E-05  -1.91890000E-04  -9.11700000E-05
   -1.65700000E-04  -1.57930000E-04  +1.45030000E-04  +6.05956000E-03  -2.80759100E-02
   -3.82500000E-03  -2.43550000E-03  +1.18148900E-02  +8.33560000E-04  +5.32881300E-02
   -8.89700000E-05  -4.01890000E-04  -4.37540000E-04  +6.35520000E-04  +5.52690000E-04
   +1.51550000E-03  -3.04200000E-04  +2.19030000E-04  +1.78300000E-04  +9.54200000E-05
   -7.74000000E-06  +4.63400000E-05  -4.64150000E-04  -1.17750000E-04  -4.07800000E-05
   +1.13400000E-04  +2.66700000E-05  +2.26340000E-04  +1.36285000E-03  -1.08198100E-02
   -1.46599000E-03  +3.51132200E-02  -3.08300960E-01  -2.69366900E-02  +2.71230000E-04
   +1.79320000E-04  +2.43000000E-05  -1.06650000E-03  +6.24150000E-04  -3.11670000E-04
   +4.40400000E-04  +3.37940000E-04  +2.29930000E-04  -2.02800000E-04  -1.22900000E-04
   +1.02280000E-04  +3.45000000E-06  +3.05400000E-05  -2.57250000E-04  +2.53300000E-04
   +1.64540000E-04  +6.09800000E-05  -1.21840000E-04  +1.90920000E-04  -6.06200000E-05
   -1.42200000E-05  +5.71000000E-06  +2.04800000E-05  -3.86710000E-04  +1.52910000E-04
   -9.46990000E-04  +3.19550000E-04  -6.82400000E-05  +4.40700000E-05  +1.03400000E-05
   -1.19700000E-05  +2.40000000E-07  +3.03700000E-05  -3.24400000E-05  -5.19000000E-06
   +1.03100000E-05  +1.76000000E-06  -1.77400000E-05  +5.95200000E-05  -1.70970000E-04
   -4.19000000E-05  +2.19200000E-05  -3.51000000E-06  +1.49000000E-06  -2.02140000E-04
   +5.42040000E-04  +5.29130000E-04  +7.40800000E-05  -1.09930000E-04  -2.67700000E-05
   -6.68300000E-05  +4.83020000E-04  +2.33900000E-05  +2.99604000E-03  -1.24663900E-02
   -1.75973000E-03  -4.28400000E-05  -4.47091000E-03  -8.55000000E-05  -3.93178400E-02
   +3.33767180E-01  +7.36800000E-05  +1.22828000E-03  +8.12470000E-04  -2.60583000E-03
   +8.90370000E-04  -3.83201000E-03  +6.55000000E-05  -5.84000000E-04  -9.52800000E-04
   -2.77700000E-05  -5.30500000E-05  +4.69750000E-04  +2.69210000E-04  +1.44670000E-04
   -5.22230000E-04  -1.87230000E-04  +8.19900000E-05  -1.74180000E-04  -3.57805000E-03
   +2.34938800E-02  +7.40670000E-04  +4.58057000E-03  -2.82720000E-02  -4.95768000E-02
   -5.94200000E-05  -8.96000000E-05  +1.41990000E-04  +8.42870000E-04  -4.27600000E-05
   +8.00840000E-04  +9.23400000E-05  -2.14400000E-04  -2.01660000E-04  +7.55300000E-05
   +9.63700000E-05  -9.90000000E-05  -2.37100000E-05  -9.28900000E-05  +1.26870000E-04
   -7.87100000E-05  +4.93000000E-05  -3.46200000E-05  -6.30600000E-05  +1.49870000E-04
   +3.59490000E-04  +9.02200000E-05  +4.43600000E-05  -4.01500000E-05  -2.58940000E-04
   +1.30344000E-03  +8.31820000E-04  -8.82500000E-05  -1.09000000E-06  +1.60180000E-04
   +5.69000000E-06  -3.00000000E-06  +1.37300000E-05  -3.24000000E-06  +3.59400000E-05
   +4.60000000E-06  -4.84400000E-05  +2.07700000E-05  -2.16100000E-05  -1.40830000E-04
   -3.07530000E-04  -2.35990000E-04  -1.13000000E-06  +2.05500000E-05  -2.39000000E-06
   -1.38120000E-04  -2.60150000E-04  -9.05660000E-04  +7.09300000E-05  +1.16000000E-06
   -2.09900000E-05  +9.18200000E-05  -3.05760000E-04  +2.93370000E-04  -7.06960000E-04
   +3.67263000E-03  -7.52420000E-04  +2.93141000E-03  -2.97047000E-02  -2.09640000E-03
   -1.20698000E-03  +2.89239400E-02  +5.39974300E-02  -9.72240000E-04  +5.57600000E-04
   +2.29128000E-03  +6.97220000E-03  -2.27574000E-03  +1.08167200E-02  -1.41724250E-01
   +3.46585800E-02  -1.28314010E-01  -1.31080100E-02  +6.72457000E-03  -2.65395100E-02
   +1.96870000E-04  +4.97768000E-03  +3.72510000E-03  -3.40190000E-04  -2.54610000E-04
   +1.20740000E-04  +2.15030000E-04  +5.97000000E-05  -1.23400000E-04  -2.84640000E-04
   +1.16999000E-03  -1.39580000E-04  +6.13420000E-04  -3.94680000E-04  +3.56160000E-04
   +4.05400000E-05  +4.61200000E-05  +6.15000000E-06  -3.64400000E-05  -4.94100000E-05
   +9.08000000E-06  +4.94700000E-05  -9.89000000E-06  +3.19700000E-05  -3.36700000E-05
   -2.23500000E-05  -2.71900000E-05  -1.06000000E-06  +2.02700000E-05  +7.48400000E-05
   -1.29150000E-04  +6.73200000E-05  -1.92790000E-04  +4.84200000E-05  +1.01200000E-05
   +1.67700000E-05  -2.27700000E-05  -6.63200000E-05  -8.52800000E-05  -2.66100000E-03
   +1.38303000E-03  -1.81474000E-03  -1.61900000E-05  -1.25000000E-06  -6.30000000E-06
   -4.03000000E-06  +8.20000000E-06  +7.04000000E-06  +6.73000000E-06  -6.23000000E-06
   +2.35300000E-05  +4.26400000E-05  -1.81310000E-04  +2.49700000E-05  -1.32000000E-05
   -1.03500000E-05  -5.21000000E-06  -1.21700000E-05  +2.20500000E-05  -2.04500000E-05
   -1.82400000E-05  +8.72000000E-06  +2.21400000E-05  +9.90000000E-07  -1.36200000E-05
   -2.59300000E-05  -1.82490000E-04  +1.16400000E-05  +6.24700000E-05  -1.18400000E-05
   +1.19487000E-03  +5.55070000E-04  -9.90400000E-05  -3.44800000E-05  +1.52210000E-04
   +1.49091140E-01  +1.53601000E-03  -2.73920000E-04  -6.93860000E-04  -4.92365000E-03
   +3.74434000E-03  -6.12545000E-03  +3.44306100E-02  -5.12392300E-02  +4.02676700E-02
   +1.05081400E-02  +2.97221000E-03  +1.09523900E-02  +5.50509000E-03  +9.34743000E-03
   -2.14254000E-03  -6.09010000E-04  -6.04770000E-04  -5.47700000E-05  -5.67100000E-04
   +7.15120000E-04  +6.38810000E-04  +6.91040000E-04  -1.24605000E-03  -5.80950000E-04
   +2.11644000E-03  +4.11690000E-04  +1.82148000E-03  +6.26000000E-05  -8.09500000E-05
   +1.01740000E-04  -2.68700000E-05  -8.20000000E-07  -5.00000000E-05  +5.82700000E-05
   +4.47900000E-05  +2.57600000E-05  -8.77600000E-05  -4.60900000E-05  +1.53300000E-05
   -9.00000000E-06  +3.10600000E-05  +1.34100000E-04  -4.22700000E-05  +4.08900000E-05
   -1.89580000E-04  +1.01650000E-04  +3.99100000E-05  +1.08400000E-05  +1.62170000E-04
   +5.55100000E-05  +1.22000000E-04  -2.05563000E-03  -2.61330000E-04  -7.72560000E-04
   -2.77200000E-05  -1.46300000E-05  +2.80000000E-06  +4.32000000E-06  +4.50000000E-07
   +1.21000000E-06  +9.22000000E-06  -1.97000000E-06  +3.45700000E-05  -2.09600000E-05
   -1.92440000E-04  +8.01600000E-05  -3.50000000E-06  +5.30000000E-06  -9.23000000E-06
   -1.07400000E-05  -3.84400000E-05  +1.63200000E-05  -2.24700000E-05  +2.19900000E-05
   -4.80000000E-06  -8.37000000E-06  +3.14600000E-05  +1.14980000E-04  -5.47900000E-05
   +8.76400000E-05  +8.87800000E-05  +1.10322000E-03  -2.23469000E-03  -4.93450000E-04
   -6.39600000E-05  +6.61000000E-05  +1.26860000E-04  -4.51772000E-02  +4.40274500E-02
   +4.01510000E-03  -2.06635000E-03  -3.35016000E-03  -1.80663600E-02  +5.22823000E-03
   -1.92614400E-02  -1.29521130E-01  +4.17310100E-02  -2.42156760E-01  +4.59327000E-03
   -2.14246000E-03  +6.99994000E-03  +1.04496000E-03  -1.38386000E-03  -6.59500000E-05
   +1.31360000E-04  -5.09700000E-05  +5.44590000E-04  -4.92720000E-04  +1.11299000E-03
   -4.37570000E-04  +3.13400000E-05  +5.23160000E-04  -4.85620000E-04  -1.43900000E-04
   -1.53280000E-04  +2.17180000E-04  +1.39430000E-04  -7.36300000E-05  +8.79700000E-05
   +2.08800000E-05  -1.56200000E-05  -4.97700000E-05  +8.21700000E-05  +2.03000000E-06
   +4.82400000E-05  +1.41200000E-05  +8.00000000E-07  +1.69400000E-05  -5.43500000E-05
   -2.69000000E-05  +9.91100000E-05  -3.68600000E-05  +8.04000000E-05  -2.92060000E-04
   +1.67200000E-05  -4.33000000E-06  +1.77900000E-05  +1.11290000E-04  -2.64040000E-04
   +1.70460000E-04  +1.69460000E-04  -9.82600000E-05  +4.16060000E-04  -1.20400000E-05
   +2.69000000E-06  -2.75000000E-06  +3.73000000E-06  +1.34500000E-05  +3.13000000E-06
   +6.00000000E-07  +3.71600000E-05  +4.24900000E-05  -6.19900000E-05  -1.24350000E-04
   +1.54690000E-04  -5.43000000E-06  +7.36000000E-06  -2.07000000E-06  +8.25700000E-05
   -1.04350000E-04  -7.03100000E-05  +1.22100000E-05  +1.97800000E-05  -3.87400000E-05
   -9.39000000E-06  +7.19500000E-05  +1.60010000E-04  +6.66300000E-05  -7.70600000E-05
   -5.45000000E-05  -1.22950000E-04  -3.06270000E-04  +1.27644000E-03  -9.79100000E-05
   +1.54120000E-04  +5.59130000E-04  +1.38807400E-01  -4.41007900E-02  +2.52701230E-01
   -2.47720000E-04  -6.91500000E-05  -2.04220000E-04  -8.06710000E-04  +6.45630000E-03
   -2.07960000E-03  -7.24492000E-03  +7.23524000E-03  +2.75376100E-02  -9.20811400E-02
   +2.87683200E-02  +9.59344400E-02  +8.60034000E-03  -3.51904000E-03  -1.90472000E-02
   -2.49484000E-03  +1.59005000E-03  -2.21214000E-03  -4.89130000E-04  -2.70280000E-04
   +1.58967000E-03  +7.45700000E-05  -1.20030000E-04  +1.03430000E-04  +5.70480000E-04
   +5.90650000E-04  +7.39230000E-04  -1.82380000E-04  -9.24000000E-05  -7.83000000E-06
   +5.28700000E-05  +1.55700000E-05  -1.64700000E-05  -4.00000000E-06  -4.24000000E-06
   -5.17000000E-06  -3.90400000E-05  -1.18200000E-05  -3.03600000E-05  +2.28100000E-05
   +2.90800000E-05  +1.23800000E-05  +4.67500000E-05  -9.91000000E-06  +4.89000000E-05
   +3.82800000E-05  +3.56500000E-05  +1.40000000E-07  -2.20000000E-07  +5.63080000E-04
   -1.26190000E-04  +5.78580000E-04  -1.23085000E-03  +2.08657000E-03  -2.90000000E-07
   -1.65200000E-05  +2.54000000E-06  +7.45000000E-06  +1.15000000E-06  -8.00000000E-08
   -2.07500000E-05  +8.30000000E-06  +4.34000000E-06  -1.74500000E-05  +3.22500000E-05
   +2.58000000E-06  +1.52100000E-05  -5.12000000E-06  +2.41000000E-06  -1.02220000E-04
   +5.45000000E-05  +1.73460000E-04  -7.95000000E-06  -2.35100000E-05  -1.05800000E-05
   +1.78200000E-05  -6.63000000E-06  +2.31100000E-05  -5.64000000E-06  -5.59000000E-06
   -1.15900000E-05  +4.21000000E-06  +6.58000000E-06  -6.26000000E-05  -1.26600000E-05
   +2.70700000E-05  -2.97000000E-05  -6.59220000E-04  -3.35029000E-03  +1.72780000E-04
   +9.35821300E-02  -2.03900000E-05  -4.28600000E-04  +1.51080000E-04  +3.70064000E-03
   +1.00642200E-02  +2.53079000E-03  +5.54301000E-03  +2.05084000E-03  -1.33773300E-02
   +2.91454700E-02  -5.51582200E-02  -5.81296000E-02  -9.28540000E-04  +4.44635000E-03
   +6.44266000E-03  +7.44290000E-04  +3.26850000E-04  +8.94930000E-04  -6.71890000E-04
   -1.50400000E-05  +1.70395000E-03  +4.13200000E-05  -1.65790000E-04  +7.17600000E-05
   +4.37540000E-04  -3.91590000E-04  +4.75760000E-04  -5.56900000E-05  -9.26300000E-05
   +1.24500000E-05  +4.92500000E-05  +6.03000000E-06  +4.72400000E-05  -3.94000000E-05
   -4.64500000E-05  +7.29700000E-05  -6.52800000E-05  -1.62200000E-05  -1.19350000E-04
   -1.46500000E-05  +7.46800000E-05  +4.98600000E-05  -6.18000000E-05  -7.00000000E-07
   -3.43500000E-05  +6.10000000E-06  +1.67400000E-05  +2.61600000E-05  -2.03900000E-05
   +5.04950000E-04  -9.23100000E-05  -1.62633000E-03  +1.58900000E-04  -6.37590000E-04
   -1.38900000E-05  -2.59300000E-05  -1.33200000E-05  -2.47000000E-06  -1.99000000E-06
   +5.38000000E-06  +4.25000000E-06  +1.06000000E-06  +1.21300000E-05  +9.31500000E-05
   -1.67900000E-05  +4.61000000E-06  -6.23000000E-06  -5.49600000E-05  +4.85000000E-06
   -1.00550000E-04  +1.32300000E-05  +1.42630000E-04  -4.52800000E-05  +2.71100000E-05
   +1.69100000E-05  +2.15700000E-05  +2.16000000E-06  -3.11000000E-06  -4.66500000E-05
   +3.44600000E-05  -2.73200000E-05  +3.85200000E-05  +7.55000000E-06  -8.14400000E-05
   +1.30500000E-05  -2.17400000E-05  -1.67700000E-05  -3.04161000E-03  -6.56236000E-03
   +7.23760000E-04  -3.62258300E-02  +4.49211500E-02  -2.36210000E-04  +1.80290000E-04
   +3.68950000E-04  -1.03050000E-03  -3.43880000E-04  +1.03015000E-03  -1.87703000E-03
   +6.09190000E-04  +2.59643000E-03  +9.63706000E-02  -5.66975100E-02  -2.92626860E-01
   +1.30635900E-02  -7.50916000E-03  -2.08570600E-02  -3.93929000E-03  +1.35196000E-03
   -1.90038000E-03  +1.10110000E-04  +7.96000000E-05  -5.40400000E-05  -1.78800000E-05
   -6.29100000E-05  -1.55000000E-05  -4.99090000E-04  -2.53000000E-06  +7.24450000E-04
   +2.50100000E-05  +1.24600000E-05  +2.41400000E-05  -3.34000000E-06  -2.88400000E-05
   -2.31000000E-05  +2.31700000E-05  +4.88000000E-06  +2.26300000E-05  +9.62000000E-06
   +6.22000000E-06  -9.81000000E-06  -7.41100000E-05  +1.25600000E-05  +2.47100000E-05
   +3.09600000E-05  +4.13000000E-05  -5.85700000E-05  -3.16100000E-05  -8.34000000E-06
   +1.41900000E-05  -4.31400000E-05  -1.70900000E-05  +5.00000000E-07  +2.82970000E-04
   +3.01820000E-04  +3.86231000E-03  +2.40000000E-06  -1.26300000E-05  -6.68000000E-06
   +8.20000000E-07  +2.35000000E-06  +5.80000000E-07  -3.71000000E-06  +1.88300000E-05
   +3.41700000E-05  +4.08800000E-05  -2.95300000E-05  +1.72800000E-05  -1.58000000E-06
   -2.91100000E-05  +6.71000000E-06  +1.13900000E-05  -1.49300000E-05  +6.73000000E-06
   -2.75000000E-06  +1.10000000E-06  +2.02000000E-06  +3.22000000E-06  +1.80100000E-05
   +2.48500000E-05  -8.09000000E-06  +6.40000000E-06  +3.25000000E-06  +1.58200000E-05
   -1.95000000E-06  +1.57200000E-05  +1.58900000E-05  -1.07500000E-05  +1.39900000E-05
   +5.27140000E-04  +3.75680000E-04  +1.07343000E-03  -1.03583540E-01  +6.17830000E-02
   +3.06400560E-01  -1.08582700E-02  +1.20264100E-02  -2.41770100E-02  -3.12750000E-04
   +6.04987000E-03  +3.48025000E-03  -1.65950000E-04  -1.87930000E-04  +2.75910000E-04
   -1.63037000E-03  +1.01030000E-03  +2.43340000E-03  +9.19080000E-03  -5.48459000E-03
   +1.34879200E-02  -1.21627290E-01  +5.84676500E-02  -1.08314310E-01  -7.48630000E-04
   +1.45300000E-05  -1.51462000E-03  +4.40800000E-05  +5.24350000E-04  +2.10980000E-04
   +3.45290000E-04  +9.76330000E-04  -8.64060000E-04  -1.69080000E-04  -1.03800000E-04
   +3.59200000E-05  +1.87700000E-05  +2.43200000E-05  -6.72900000E-05  +2.75100000E-05
   +2.98100000E-05  -8.15000000E-06  -3.32300000E-05  -2.08900000E-05  +4.14100000E-05
   -6.92000000E-06  -1.54600000E-05  +3.86000000E-06  +5.98800000E-05  +1.89700000E-05
   -2.50000000E-06  +3.82200000E-05  +3.34700000E-05  -3.19000000E-06  +4.68500000E-05
   -1.02650000E-04  -1.39050000E-04  +1.09000000E-06  -7.68170000E-04  -1.97766000E-03
   -3.68000000E-06  -1.07300000E-05  +5.84000000E-06  +1.27200000E-05  -8.10000000E-07
   -6.97000000E-06  -1.23900000E-05  +4.02500000E-05  +6.13000000E-06  -1.86500000E-05
   +5.86000000E-06  +6.05000000E-06  +7.49000000E-06  +2.39000000E-06  -2.58000000E-06
   -6.22000000E-06  +1.90700000E-05  +3.94000000E-05  -3.84000000E-06  -6.68000000E-06
   +1.12800000E-05  +2.05100000E-05  +4.27000000E-06  +6.93200000E-05  -9.35000000E-06
   -2.30200000E-05  +6.83000000E-06  +1.42100000E-05  -5.85000000E-06  -2.38800000E-05
   -1.28450000E-04  +8.11800000E-05  -1.35330000E-04  +3.46900000E-05  -5.61700000E-05
   -9.00900000E-05  +6.47430000E-04  -8.56600000E-05  +6.75880000E-04  +1.25894100E-01
   +6.62575000E-03  -4.41600000E-05  +1.16175200E-02  +2.99852000E-03  +1.03365900E-02
   -1.36378000E-03  -8.68000000E-05  -4.11620000E-04  -2.45800000E-04  +1.01500000E-05
   +8.92860000E-04  -5.69430000E-04  +1.50192000E-03  +2.79579000E-03  -2.29950000E-03
   +5.91882200E-02  -8.23700000E-02  +8.73806000E-02  -8.86250000E-04  +2.97720000E-04
   -1.48600000E-03  +5.94000000E-06  +4.55330000E-04  +1.69410000E-04  +1.18620000E-04
   -4.55800000E-05  -8.08160000E-04  -2.46100000E-05  -1.05130000E-04  +1.11000000E-06
   -9.18800000E-05  +5.18600000E-05  +7.88000000E-05  -3.58100000E-05  +9.14100000E-05
   -4.18400000E-05  -4.69700000E-05  -5.23600000E-05  +1.51670000E-04  -7.08200000E-05
   -2.44900000E-05  -8.53000000E-05  +6.03000000E-05  +2.25600000E-05  -8.08200000E-05
   +2.72000000E-06  +1.79600000E-05  -2.77800000E-05  +1.07700000E-05  -1.78200000E-04
   -1.15670000E-04  -1.90785000E-03  +3.35500000E-04  +1.50620000E-04  -7.11000000E-06
   -8.46000000E-06  +3.50000000E-06  -1.49100000E-05  -5.65100000E-05  -1.67600000E-05
   +1.19260000E-04  -1.85900000E-05  -3.66700000E-05  +3.25000000E-06  +7.03000000E-06
   -1.74400000E-05  -2.00000000E-06  -6.80000000E-07  -7.29000000E-06  +2.02300000E-05
   -2.83200000E-05  +1.10800000E-05  -4.54800000E-05  +3.36900000E-05  +4.14300000E-05
   +6.10500000E-05  +1.27000000E-06  +7.31400000E-05  -5.03500000E-05  +3.25800000E-05
   -2.74000000E-06  +2.36400000E-05  +6.12000000E-06  -4.40000000E-06  -1.17680000E-04
   +2.88600000E-05  -1.14120000E-04  -1.19000000E-05  -1.59100000E-05  +1.31000000E-04
   +1.34800000E-05  +3.07800000E-04  -7.86800000E-05  -6.82330400E-02  +7.45840900E-02
   +5.17527000E-03  -2.74355000E-03  +7.89366000E-03  +1.79984000E-03  +1.34779000E-03
   +1.87540000E-04  +3.30770000E-04  -2.84590000E-04  +2.14210000E-04  +3.89661000E-03
   -1.05740000E-03  -3.14389000E-03  -1.77361300E-02  +1.28299900E-02  -1.89964100E-02
   -1.09670000E-01  +8.55517900E-02  -2.33221200E-01  -1.93950000E-04  -1.03100000E-05
   -1.31020000E-04  +3.91000000E-05  +2.98500000E-05  -3.11000000E-06  +7.46980000E-04
   -4.48210000E-04  +1.04703000E-03  -7.77000000E-06  -2.45000000E-05  +1.98000000E-05
   -5.42400000E-05  -4.08900000E-05  -5.18000000E-05  +7.22100000E-05  -1.68000000E-05
   +4.20000000E-06  -9.66000000E-06  -1.11700000E-05  +1.74000000E-06  -2.87600000E-05
   -9.19000000E-06  +1.39200000E-05  +3.58000000E-06  +2.78000000E-05  -2.07700000E-05
   +2.56900000E-05  +3.86000000E-06  +4.66000000E-06  +1.04700000E-05  +4.53000000E-05
   -1.33900000E-05  +6.08040000E-04  -1.14601000E-03  +4.34891000E-03  -6.34000000E-06
   +2.72000000E-06  -2.06000000E-06  -2.80000000E-07  +1.78500000E-05  +1.00800000E-05
   -1.96100000E-05  +2.39100000E-05  +3.23900000E-05  +1.11000000E-05  -2.34600000E-05
   +2.08200000E-05  -1.29000000E-06  -3.13000000E-06  -5.10000000E-07  -8.27000000E-06
   -4.60000000E-07  +1.59000000E-05  +1.88000000E-06  +1.44000000E-06  +7.86000000E-06
   -4.50000000E-06  -2.50000000E-07  +2.56300000E-05  -6.19000000E-06  +9.12000000E-06
   +9.70000000E-07  +4.82000000E-06  -1.90400000E-05  +2.51900000E-05  -1.50300000E-05
   +8.24000000E-06  +7.95000000E-06  -1.53400000E-04  +4.71000000E-06  +9.66500000E-05
   -9.23540000E-04  +3.19570000E-04  -1.05130000E-03  +1.16064250E-01  -9.34042300E-02
   +2.42738960E-01  -1.06596040E-01  +8.01139000E-03  +1.11497980E-01  +7.42744000E-03
   -1.99460000E-04  -1.49492000E-02  -1.91852000E-03  +1.29821000E-03  -2.28537000E-03
   -3.60350000E-04  -2.16400000E-04  -1.49600000E-05  -1.37360000E-04  +5.62240000E-03
   -3.18973000E-03  -9.60602000E-03  +1.51020000E-03  +2.99523200E-02  +2.57540000E-04
   -9.72600000E-05  -4.42700000E-05  -1.40800000E-05  -4.01100000E-05  +1.00300000E-04
   +4.78390000E-04  -3.36560000E-04  -4.45230000E-04  +1.62200000E-05  +1.29700000E-05
   +1.33000000E-05  -1.02950000E-04  +2.01900000E-05  +2.06150000E-04  +1.82700000E-05
   +2.27200000E-05  -7.20400000E-05  -3.13200000E-05  -2.89200000E-05  +2.96700000E-05
   +9.94000000E-06  +5.24000000E-06  -3.09600000E-05  -3.10600000E-05  -2.24600000E-05
   -3.39500000E-05  +4.63600000E-05  +1.69500000E-05  -2.04100000E-05  -2.04640000E-04
   +1.26211000E-03  +4.26100000E-04  -2.28754000E-03  +1.42387000E-03  +2.20742000E-03
   -7.01000000E-06  +2.97000000E-06  +2.01000000E-06  -1.57500000E-05  -6.15000000E-06
   +7.02000000E-06  +2.54400000E-05  -1.65640000E-04  -4.58300000E-05  +4.31000000E-06
   -3.90000000E-06  -1.80400000E-05  -2.49000000E-06  +5.58000000E-06  -5.13000000E-06
   -1.43380000E-04  -3.31400000E-05  -1.13720000E-04  -2.31670000E-04  +3.68900000E-05
   -2.14300000E-05  -2.26040000E-04  +1.35090000E-03  -1.21420000E-04  -2.73700000E-05
   +1.28100000E-05  -1.88000000E-05  +1.26600000E-05  -3.20500000E-05  +3.53300000E-05
   -2.40100000E-05  +3.25200000E-05  +1.99000000E-05  +5.55220000E-04  -7.13000000E-06
   -8.37650000E-04  +5.94800000E-05  -3.36100000E-05  +1.53350000E-04  -7.89470000E-04
   -3.00364000E-03  -8.44370000E-04  +1.11162440E-01  +7.66747000E-03  -4.28066100E-02
   -1.08865000E-03  -6.54507000E-03  +2.68836000E-03  +1.10906200E-02  +2.41240000E-03
   -8.41710000E-04  +7.84640000E-04  -6.67720000E-04  -5.64170000E-04  -9.21800000E-05
   +5.97393000E-03  +8.45197000E-03  +2.65564000E-03  +9.34145000E-03  +4.58464000E-03
   -1.19462100E-02  -7.16070000E-04  +9.99120000E-04  -3.00860000E-04  +1.48750000E-04
   +2.80100000E-05  -1.72750000E-04  +2.43658000E-03  +1.28759000E-03  -1.78922000E-03
   +7.56700000E-05  -1.18830000E-04  -8.10900000E-05  -1.20000000E-07  +3.00800000E-05
   +2.84720000E-04  -4.83800000E-05  +7.32900000E-05  -1.43420000E-04  -7.53900000E-05
   -5.01400000E-05  +2.15700000E-05  +4.20700000E-05  +5.10000000E-05  -3.60000000E-05
   +8.14000000E-06  -1.78400000E-05  +1.93800000E-05  +8.33800000E-05  +4.18700000E-05
   -3.03900000E-05  +8.71170000E-04  -1.62920000E-03  +1.95030000E-04  -2.08893000E-03
   -1.16150000E-04  +7.75170000E-04  -1.48400000E-05  -1.31500000E-05  +5.22000000E-06
   -8.59000000E-06  -6.00000000E-08  +6.06000000E-06  -7.10900000E-05  -1.52690000E-04
   -1.48270000E-04  +1.90000000E-07  +1.86900000E-05  -3.83400000E-05  +7.68000000E-06
   +5.52000000E-06  -6.07000000E-06  -5.66400000E-05  +1.22180000E-04  -1.38670000E-04
   -1.23800000E-05  +6.67500000E-05  -4.93600000E-05  +1.21048000E-03  -2.63280000E-03
   -3.05740000E-04  -1.19400000E-05  +2.16100000E-05  +2.03500000E-05  -3.42700000E-05
   +6.84800000E-05  -1.29660000E-04  +3.57000000E-06  -5.13100000E-05  -1.51200000E-05
   -4.14900000E-05  +8.52020000E-04  +6.48680000E-04  -8.34100000E-05  +2.66900000E-05
   +7.88000000E-06  -3.44255000E-03  -6.16359000E-03  -1.32802000E-03  -1.64965000E-02
   +3.56357600E-02  +1.12504320E-01  -2.50091000E-03  -2.86246070E-01  +1.31272900E-02
   -7.35690000E-04  -1.85569000E-02  -3.81533000E-03  +2.29879000E-03  -1.87720000E-03
   -1.61130000E-04  -1.58060000E-04  +5.68390000E-04  +8.76700000E-05  +2.19580000E-03
   +1.28156000E-03  -3.84410000E-04  +1.32580000E-03  +1.43212000E-03  +1.91070000E-04
   -8.25060000E-04  -7.51250000E-04  -3.46000000E-05  +2.50620000E-04  +1.80660000E-04
   +5.14270000E-04  +2.81410000E-04  -6.38000000E-05  -1.25230000E-04  +4.24000000E-06
   +1.02540000E-04  -1.08600000E-05  -2.70800000E-05  -3.00990000E-04  +5.16300000E-05
   +1.81600000E-05  +8.16300000E-05  -2.06100000E-05  -7.51000000E-06  +1.55000000E-05
   -4.94100000E-05  -2.01100000E-05  +5.16800000E-05  -2.43600000E-05  +1.62800000E-05
   -1.82000000E-05  -6.90000000E-07  +6.46000000E-06  +1.76600000E-05  +5.54700000E-05
   -9.53440000E-04  -6.13600000E-04  -1.49750000E-04  -1.64010000E-04  +3.38610000E-04
   -7.00000000E-08  -1.14900000E-05  -3.20000000E-07  +8.10000000E-06  -4.23000000E-06
   -3.88000000E-06  +9.00700000E-05  +1.09330000E-04  +1.54120000E-04  +6.78000000E-06
   -3.75400000E-05  +2.67000000E-05  -2.48000000E-06  -1.38600000E-05  +1.41000000E-06
   +1.81890000E-04  -2.20570000E-04  +5.10460000E-04  -8.22800000E-05  +1.13190000E-04
   -4.83000000E-05  +6.24260000E-04  -5.48690000E-04  +1.20398000E-03  -2.77800000E-05
   -7.17000000E-06  -3.13700000E-05  +3.49800000E-05  -8.06500000E-05  +1.11660000E-04
   -9.29300000E-05  +9.83200000E-05  -4.40000000E-05  +5.78430000E-04  -2.60430000E-04
   -1.16939000E-03  +8.60500000E-05  -1.20860000E-04  +4.01300000E-05  -5.60800000E-04
   -1.65723000E-03  +8.53840000E-04  -1.22767480E-01  +2.54149000E-03  +3.00495590E-01
   -7.64410000E-04  +2.20370000E-04  +4.31870000E-04  -3.13330000E-04  -5.04610000E-04
   -4.66950000E-04  -4.08360000E-04  +1.97170000E-04  -5.65280000E-04  -1.22898000E-03
   -8.55470000E-04  +3.82100000E-04  +1.60643900E-02  +3.23242000E-03  -8.24602000E-03
   -8.55700000E-05  -1.01718000E-03  +6.26970000E-04  -3.21610000E-04  -7.72900000E-05
   +1.11400000E-04  +1.19860000E-04  +1.04530000E-04  -9.45200000E-05  -1.12616030E-01
   +1.40051130E-01  +8.68157200E-02  -1.53200000E-03  -4.21780000E-04  -1.15528000E-03
   +6.31350000E-04  +1.26600000E-05  +1.46851000E-03  +3.26050000E-04  +1.61489000E-03
   -1.52200000E-04  +1.08504000E-03  +7.97800000E-04  +2.13540000E-04  -1.50930000E-04
   +3.81940000E-04  +3.67400000E-04  +9.21000000E-05  +5.04100000E-04  -8.82500000E-04
   -1.39322000E-03  -5.82580000E-04  +1.29020000E-04  +9.29800000E-05  +1.36310000E-04
   +5.15900000E-05  +4.90820000E-04  -1.12164500E-02  +1.21272000E-03  +1.11080000E-04
   -1.22970000E-04  -1.67300000E-05  +3.93600000E-05  -4.98790000E-04  -2.77460000E-04
   -2.81700000E-05  +3.16900000E-05  -3.69700000E-05  +6.61000000E-06  -7.65900000E-05
   +1.19850000E-04  -1.28600000E-05  -1.85430000E-04  +5.23900000E-05  -4.20700000E-05
   +4.54000000E-06  +3.52300000E-05  +6.58100000E-05  +1.05400000E-05  -2.93700000E-05
   -3.03700000E-05  -2.18000000E-05  +3.15100000E-05  +6.74100000E-05  -1.05000000E-06
   +3.60900000E-05  -1.75500000E-05  -2.92700000E-05  +3.52400000E-05  -3.60400000E-05
   +9.82000000E-06  +1.08000000E-06  -6.18100000E-05  +2.67070000E-04  +3.71600000E-05
   +1.09130000E-04  +4.83200000E-05  +1.25790000E-04  +1.35000000E-05  +9.39100000E-05
   -2.88600000E-05  -8.17800000E-05  +3.14600000E-05  +3.86500000E-05  +1.03182610E-01
   -3.88770000E-04  +6.56670000E-04  -7.14830000E-04  -9.83630000E-04  +8.18900000E-04
   -5.55120000E-04  +6.13000000E-05  -2.96920000E-04  +2.64690000E-04  -5.96120000E-04
   +9.49000000E-06  -3.52340000E-04  +4.77154000E-03  -1.04324200E-02  -7.72066000E-03
   +1.05277000E-03  +5.53760000E-04  +1.60444000E-03  +8.31240000E-04  +1.02283000E-03
   +1.29130000E-04  -2.98450000E-04  -5.68790000E-04  +6.41000000E-06  +1.37170200E-01
   -3.01789010E-01  -1.89654820E-01  +1.21976000E-03  -2.82430000E-04  -2.38810000E-04
   +3.20715000E-03  +5.74690000E-04  -3.31880000E-04  -2.14626000E-03  +1.89610000E-04
   -1.07773000E-03  -2.09364000E-03  -2.36601000E-03  +1.64985000E-03  +2.40330000E-04
   -3.07580000E-04  +7.80190000E-04  +2.60530000E-04  -4.68290000E-04  +1.67200000E-04
   +1.24492000E-03  +5.23940000E-04  -3.13330000E-04  -3.22590000E-04  -4.50980000E-04
   -8.09200000E-05  -1.82069000E-03  -3.87049000E-03  +1.45832000E-03  -2.14230000E-04
   -3.24000000E-05  +1.25380000E-04  +5.44000000E-06  +1.33890000E-04  +1.16420000E-04
   -2.06010000E-04  +2.68150000E-04  +3.94540000E-04  -8.76300000E-05  +1.59400000E-04
   -1.87870000E-04  -3.13300000E-05  +1.33500000E-04  -1.48070000E-04  +1.71880000E-04
   -1.45860000E-04  -5.68800000E-05  -1.70860000E-04  +2.15700000E-05  +8.49000000E-05
   +3.20900000E-05  +1.81820000E-04  +5.42900000E-05  -1.77950000E-04  +3.65600000E-05
   -6.75300000E-05  +3.46100000E-05  +1.26500000E-04  +1.75700000E-05  +1.87280000E-04
   -1.60090000E-04  +7.24600000E-05  +7.28800000E-05  +9.32000000E-06  +1.50020000E-04
   +6.43600000E-05  +1.41100000E-05  +1.51080000E-04  -1.24270000E-04  -3.01320000E-04
   +1.08570000E-04  +5.22000000E-06  -2.67250000E-04  -7.43900000E-05  -1.42609640E-01
   +3.23725560E-01  +3.66530000E-04  -2.54750000E-04  -4.61570000E-04  -1.32750000E-04
   +4.82200000E-05  +6.28420000E-04  -2.97480000E-04  +2.32080000E-04  +1.93660000E-04
   -1.17630000E-04  -5.29330000E-04  -7.09530000E-04  -4.00306000E-03  -2.71941000E-03
   -8.74380000E-04  +1.09230000E-03  +8.95890000E-04  +2.47190000E-04  -7.70100000E-05
   +2.35300000E-05  -2.17240000E-04  -4.22200000E-05  +1.03000000E-06  +4.13900000E-05
   +9.58215300E-02  -2.11705070E-01  -1.55452970E-01  +2.10130000E-04  -2.20750000E-04
   +5.10890000E-04  +1.78034000E-03  +1.32865000E-03  +1.43800000E-04  -2.11636000E-03
   +4.97380000E-04  -2.80940000E-04  -3.76920000E-04  -3.25410000E-04  +1.99122000E-03
   +5.85670000E-04  -6.28200000E-05  -1.10510000E-03  -8.41180000E-04  -2.75970000E-04
   -6.87040000E-04  +5.97730000E-04  +2.30210000E-04  -3.40590000E-04  +3.69600000E-05
   -7.36900000E-05  +4.93800000E-05  -4.81530000E-04  +3.66159000E-03  +8.21750000E-04
   +9.70000000E-07  +1.77070000E-04  +4.70800000E-05  +6.66200000E-05  -4.35240000E-04
   -2.52320000E-04  +2.39070000E-04  -2.04960000E-04  -2.18350000E-04  -6.80000000E-07
   +4.64300000E-05  -6.06100000E-05  -6.18400000E-05  +1.07580000E-04  -7.38100000E-05
   +2.08100000E-05  -7.46000000E-06  -2.27600000E-05  -1.60800000E-05  +7.61000000E-06
   -2.43100000E-05  +4.95000000E-06  +2.52200000E-05  -6.47400000E-05  -1.10500000E-05
   +5.64000000E-06  -1.93000000E-05  -1.06700000E-05  +2.15800000E-05  -5.12600000E-05
   +1.17000000E-06  -1.17800000E-05  -1.43700000E-05  +4.57700000E-05  +2.31400000E-05
   -4.62500000E-05  +8.45000000E-05  -5.78900000E-05  +7.62400000E-05  +1.80800000E-05
   +4.25200000E-04  -2.54500000E-04  +5.13700000E-05  -5.49700000E-05  -8.53700000E-05
   -9.20536900E-02  +1.99622640E-01  +1.49279930E-01  +3.57380000E-04  +1.45250000E-04
   -1.71541000E-03  -1.54117000E-03  -2.97180000E-04  +6.47580000E-04  +5.60980000E-04
   +3.97000000E-06  +1.56190000E-03  +1.22471000E-03  -8.94725000E-03  +6.09810000E-04
   -2.55177100E-02  +6.40222100E-02  +4.63270000E-03  +7.47620000E-04  -3.41196000E-03
   -9.14200000E-05  +5.10360000E-04  +8.62980000E-04  -1.28410000E-04  -1.55450000E-04
   -4.42580000E-04  -2.21700000E-05  -3.03793900E-02  -6.05786000E-03  -1.41764100E-02
   +4.98120000E-04  +5.66100000E-05  -1.68690000E-04  +2.59130000E-04  +4.37700000E-05
   +4.04400000E-05  -3.16300000E-04  -1.36510000E-04  +4.20740000E-04  +1.47324000E-03
   +6.48270000E-04  -3.83800000E-05  -2.95140000E-04  -1.69760000E-04  -3.30080000E-04
   +4.50300000E-05  -2.73100000E-05  -6.78700000E-05  -1.62396000E-03  -4.76520000E-04
   +7.50300000E-05  -1.11700000E-04  -5.42810000E-04  +2.75800000E-05  +2.82854000E-02
   -1.25102700E-02  +1.48031400E-02  +2.72330000E-04  -5.70600000E-05  -3.21200000E-05
   +1.74800000E-05  -1.77740000E-04  -1.35100000E-04  +1.06100000E-04  +9.10700000E-05
   +1.52470000E-04  -1.67000000E-05  +1.58710000E-04  -1.42950000E-04  -3.75000000E-05
   -3.46600000E-05  +6.69500000E-05  +1.38440000E-04  -1.93240000E-04  -1.23970000E-04
   -7.64400000E-05  +8.75700000E-05  +7.00000000E-05  -1.84200000E-05  +1.53180000E-04
   +4.89500000E-05  -7.87200000E-05  +9.10100000E-05  -3.81300000E-05  -3.46200000E-05
   +1.77580000E-04  -9.23500000E-05  +1.42990000E-04  -2.16220000E-04  +2.85700000E-05
   +1.01557000E-03  +7.20730000E-04  +2.13800000E-05  -1.49710000E-04  +5.54070000E-04
   -3.47990000E-04  +4.48180000E-04  +5.76850000E-04  +2.80880000E-04  +7.65210000E-04
   +2.56890000E-04  -1.41150000E-04  -3.09882000E-03  -1.34223000E-03  -1.86810000E-04
   +2.22898600E-02  +1.11430000E-04  -9.92200000E-05  -4.97670000E-04  -4.36720000E-04
   -4.97300000E-05  +3.94750000E-04  +5.34160000E-04  -2.04900000E-04  +1.37841000E-03
   +2.82698000E-03  -5.90595000E-03  -1.15223000E-03  +1.79238700E-02  +1.81683100E-02
   +1.84296500E-02  +1.51030000E-04  -2.15705000E-03  -5.59430000E-04  +1.79570000E-04
   +2.57490000E-04  -1.01000000E-04  -6.87300000E-05  -1.28770000E-04  +2.44100000E-05
   -1.10770500E-02  -1.23711000E-03  -4.37776000E-03  +1.95560000E-04  +8.15700000E-05
   -4.45500000E-05  +1.12490000E-04  +1.34860000E-04  -1.05000000E-06  -2.42840000E-04
   +6.43900000E-05  +8.99300000E-05  +3.10590000E-04  +1.01330000E-04  +2.62400000E-05
   -1.16870000E-04  -2.34600000E-05  -4.20900000E-05  +2.42200000E-05  +1.71000000E-06
   +2.78100000E-05  -4.18180000E-04  -5.73500000E-05  +1.37000000E-05  -4.63500000E-05
   -1.84490000E-04  +4.85000000E-06  +1.82717900E-02  -4.10762800E-02  -4.60335000E-03
   +6.42500000E-05  -7.24500000E-05  +1.50000000E-06  +1.45500000E-05  -8.70300000E-05
   -5.45600000E-05  +4.78100000E-05  +7.83000000E-06  +3.92200000E-05  -2.65000000E-06
   +4.83100000E-05  -5.78600000E-05  +2.77000000E-06  -2.73400000E-05  +1.57400000E-05
   +4.97000000E-05  -5.24200000E-05  -4.32900000E-05  -4.28200000E-05  +2.22800000E-05
   +2.29800000E-05  +3.28000000E-06  +4.60300000E-05  -7.62000000E-06  -4.33000000E-05
   +2.35400000E-05  -9.40000000E-06  +1.50000000E-06  +6.38900000E-05  -3.43100000E-05
   +4.79100000E-05  -6.27000000E-05  -7.08000000E-06  +6.71790000E-04  +3.73780000E-04
   -4.18700000E-05  -1.58610000E-04  +2.87920000E-04  -1.63220000E-04  +3.51150000E-04
   +5.57360000E-04  -3.30240000E-04  +2.66540000E-04  +2.71390000E-04  -2.82000000E-05
   -1.34270000E-03  -5.37200000E-04  -5.02880000E-04  -3.14706700E-02  +1.02934780E-01
   -2.00710000E-04  +4.36350000E-04  -1.56243000E-03  -8.36640000E-04  -7.36690000E-04
   +7.79730000E-04  -1.47030000E-04  +2.48620000E-04  +8.48890000E-04  -2.42360000E-04
   -4.62149000E-03  -2.29800000E-05  -5.05171000E-03  +4.19163800E-02  +1.04230500E-02
   +1.20051000E-03  -3.42536000E-03  +1.59337000E-03  +3.02670000E-04  +4.87820000E-04
   -1.85430000E-04  -7.47600000E-05  -2.02430000E-04  -9.55000000E-06  -1.84349200E-02
   -6.83686000E-03  -8.64743000E-03  +2.62830000E-04  +8.76000000E-06  -1.20520000E-04
   +1.04460000E-04  -6.11000000E-06  +7.25600000E-05  -1.06510000E-04  -1.29610000E-04
   +2.22950000E-04  +7.94240000E-04  +3.50260000E-04  -3.92800000E-05  -1.03640000E-04
   -1.04300000E-04  -2.14100000E-04  -7.95000000E-06  -3.34500000E-05  -4.05400000E-05
   -8.31110000E-04  -2.61980000E-04  +2.54500000E-05  -2.16000000E-05  -3.29520000E-04
   +4.91200000E-05  +2.58385400E-02  -1.88962800E-02  -2.98727700E-02  +1.41250000E-04
   +3.85000000E-06  -1.04500000E-05  -1.67000000E-06  -8.86800000E-05  -6.46600000E-05
   +7.00800000E-05  +2.56800000E-05  +5.07800000E-05  -2.22400000E-05  +9.11300000E-05
   -7.84600000E-05  -2.43500000E-05  +6.11000000E-06  +3.01100000E-05  +6.67800000E-05
   -9.06500000E-05  -9.65300000E-05  -2.76600000E-05  +4.34400000E-05  +3.67900000E-05
   -2.35200000E-05  +6.28100000E-05  -7.03000000E-06  -3.01800000E-05  +4.40100000E-05
   -1.76400000E-05  -2.60300000E-05  +9.44100000E-05  -6.64200000E-05  +6.54100000E-05
   -1.10670000E-04  +1.21300000E-05  +4.98840000E-04  +4.30290000E-04  -3.92300000E-05
   -1.73900000E-05  +1.71930000E-04  -6.72100000E-05  +8.60690000E-04  +1.04290000E-04
   -1.25308000E-03  +3.88190000E-04  +2.55410000E-04  -6.33000000E-05  -2.13869000E-03
   -1.08252000E-03  +2.11110000E-04  -3.52068600E-02  -5.06160000E-04  +4.82340400E-02
   -4.78471500E-02  -1.49987000E-02  -4.09154000E-03  -1.83190560E-01  -2.14469800E-02
   +7.20811000E-03  -4.14044000E-02  -1.40647300E-02  +8.33987000E-03  +1.44298000E-03
   -3.55320000E-04  +5.50263000E-03  +1.63037000E-03  -3.33711000E-03  -8.09700000E-04
   +3.46720000E-04  +7.47790000E-04  -6.25896000E-03  -4.28004000E-03  -6.27593000E-03
   -5.04400000E-05  -1.09964000E-03  +7.89100000E-04  -5.97110000E-04  -2.55508000E-03
   -6.70690000E-04  -9.75400000E-05  +1.21613000E-03  +1.06900000E-05  -3.93400000E-05
   +2.36490000E-04  -2.67500000E-04  +1.63010000E-04  +9.98700000E-05  -1.11490000E-04
   +1.23670000E-04  +4.54600000E-04  +3.72680000E-04  -9.49000000E-06  -7.84800000E-05
   -6.86800000E-05  -1.14690000E-04  +1.86300000E-04  -1.06730000E-04  -3.38600000E-04
   -4.52860000E-04  -3.50650000E-04  +3.35200000E-05  -8.52370000E-04  +3.25090000E-04
   +8.38610000E-04  -1.83747000E-03  +8.71500000E-04  +1.38420000E-04  +5.83700000E-05
   +1.19330000E-04  -3.57400000E-05  -3.11200000E-05  +6.48000000E-05  +1.23200000E-05
   -1.28090000E-04  +1.27710000E-04  +5.97500000E-05  -1.21130000E-04  +8.39600000E-05
   +3.89400000E-05  -5.30300000E-05  +4.49000000E-05  +2.47500000E-05  +7.37880000E-04
   +3.37800000E-04  -8.23200000E-05  +1.21693000E-03  +3.67330000E-04  -9.78600000E-05
   -1.30000000E-06  +3.27000000E-05  +1.46200000E-04  +1.39305000E-03  +5.72600000E-04
   -1.94340000E-04  -1.04810000E-04  -4.53000000E-05  -4.53700000E-05  +8.55610000E-04
   +4.03040000E-04  +4.29600000E-05  +2.11401000E-03  +5.76500000E-04  -7.28500000E-05
   +1.07230000E-04  +3.21682000E-03  -2.16200000E-05  +1.35350000E-04  +3.54113000E-03
   +7.56640000E-04  +2.34213000E-03  +4.62600000E-04  +3.92570000E-04  +1.12590000E-04
   +9.04110000E-04  +7.67800000E-05  +1.47255000E-03  +2.60060000E-04  +6.27220000E-04
   +3.19748600E-01  +3.29609000E-03  +4.89528000E-03  -1.10370000E-04  -5.72546900E-02
   -1.00980020E-01  +8.48510000E-04  -2.74099000E-03  +2.66521000E-03  +4.31230000E-04
   -3.19860000E-04  +5.82950000E-04  +9.80140000E-04  -9.23990000E-04  -7.83980000E-04
   +6.13590000E-04  -1.99100000E-04  +6.10360000E-04  -2.94000000E-04  -4.00476900E-02
   -2.77270200E-02  +3.80890000E-04  +6.70610000E-04  -7.17330000E-04  +3.72470000E-04
   +6.61530000E-04  +1.18059000E-03  -2.16900000E-04  +3.69915000E-03  -6.89469000E-03
   -1.02209000E-03  -2.90840000E-04  -4.19800000E-05  +8.14800000E-04  -8.97620000E-04
   +1.31430000E-04  +4.77920000E-04  +1.24379000E-03  +5.49870000E-04  -7.12300000E-05
   -7.96460000E-04  +2.78200000E-04  -2.44500000E-04  -5.92700000E-04  -1.27700000E-04
   -6.49480000E-04  -1.60821000E-03  -8.70950000E-04  +1.12160000E-04  +3.43270000E-04
   -2.28960000E-04  -5.67540000E-04  +1.39300000E-04  +4.39310000E-04  -2.05820000E-04
   +1.59470000E-04  +7.15100000E-05  -1.29900000E-04  -1.44450000E-04  -5.65800000E-05
   -3.67800000E-05  +2.00370000E-04  -2.48260000E-04  -1.68930000E-04  +2.20460000E-04
   -2.68210000E-04  +1.84800000E-05  -1.67980000E-04  -8.25100000E-05  +8.18500000E-05
   -6.35760000E-04  -1.25320000E-04  +3.14770000E-04  -9.30390000E-04  -2.64357000E-03
   -1.13056000E-03  -1.13050000E-04  -1.87740000E-04  -3.37500000E-04  -9.74800000E-04
   -3.11610000E-03  +9.33520000E-04  +1.02900000E-05  -1.21790000E-04  +2.78250000E-04
   -9.00020000E-04  -1.49940000E-04  -2.71010000E-04  +4.21520000E-04  -2.22780000E-04
   +2.09340000E-04  -3.88400000E-04  +1.73360000E-04  -3.53000000E-06  -4.33700000E-04
   -2.86040000E-04  -5.29500000E-05  +1.39880000E-04  -6.62400000E-05  -8.82450000E-04
   +2.30320000E-04  -7.08210000E-04  -2.87800000E-05  -2.66680000E-04  -1.35780000E-04
   -3.35100000E-05  +6.33408000E-03  +6.57338150E-01  -3.07868400E-02  -1.13796900E-02
   +3.68825000E-03  +3.76100000E-03  -2.01423000E-03  -6.55838700E-02  +3.78232200E-02
   +1.37913800E-02  -4.97700000E-05  +5.57450000E-04  -8.87210000E-04  -2.89911000E-03
   -1.14353000E-03  +1.11069000E-03  -7.76853000E-03  -1.16297000E-03  +1.21429000E-03
   -2.01904000E-03  -3.20253000E-03  -2.19437000E-03  +2.23756000E-03  -6.85250000E-04
   +1.04978000E-03  +8.43500000E-05  +3.41710000E-04  -5.45950000E-04  +2.41000000E-03
   +3.33160000E-04  -7.22640000E-04  +8.81360000E-04  -1.60230000E-04  +5.50000000E-05
   -2.82200000E-04  +2.46260000E-04  +8.75600000E-05  +8.23600000E-05  +1.00930000E-04
   -2.73000000E-06  +1.68960000E-04  -3.67370000E-04  -6.91000000E-05  +9.13700000E-05
   -1.22400000E-05  -1.08000000E-06  -3.81510000E-04  -1.07680000E-04  -5.31200000E-05
   +4.03000000E-05  +1.00410000E-03  -1.01762000E-03  -4.41860000E-04  +5.70110000E-04
   -2.92370000E-04  +2.66691000E-03  +2.87000000E-06  -1.02400000E-05  -2.43100000E-05
   +1.68100000E-05  +1.92300000E-05  -3.50000000E-06  +4.72000000E-05  +6.40300000E-05
   +1.31700000E-04  +2.98800000E-05  -1.39170000E-04  +1.19320000E-04  -3.91700000E-05
   -4.13900000E-05  +7.53000000E-06  -7.40070000E-04  -3.82220000E-04  +3.76540000E-04
   -1.18634000E-03  -1.52385000E-03  -7.41940000E-04  +2.15380000E-04  +3.41680000E-04
   +2.94430000E-04  +6.65960000E-04  +9.71800000E-04  -4.99740000E-04  -2.06460000E-04
   -4.48120000E-04  +3.70450000E-04  +5.29180000E-04  +2.45760000E-04  +2.80820000E-04
   -1.04247000E-03  +6.03000000E-06  +3.36136000E-03  -1.70870000E-04  -2.77678000E-03
   +3.26300000E-04  +1.32220000E-04  +2.18638000E-03  +7.51660000E-04  +1.18929000E-03
   -7.79570000E-04  +3.03176000E-03  +2.67360000E-04  +3.84210000E-04  -3.86610000E-04
   -4.73060000E-04  -2.51720000E-04  -5.30820000E-04  -1.93872900E-02  +5.64471700E-02
   +6.83355400E-02  +1.22801000E-03  -1.13058000E-03  -5.09030000E-04  -2.58736000E-03
   -4.36158900E-02  -4.13162000E-03  +1.27235000E-03  -1.03020000E-03  +2.28370000E-04
   -4.16470000E-04  +5.68920000E-04  -1.13700000E-05  -1.29645000E-03  -6.83100000E-05
   +2.14080000E-04  -3.89380000E-04  +6.27630000E-04  +1.73820000E-04  -6.44931000E-03
   -2.13585000E-03  +2.55700000E-04  -3.59470000E-04  +6.65600000E-04  -8.70600000E-05
   +8.52590000E-04  +4.10840000E-04  +2.56500000E-05  +6.55470000E-04  -1.48679000E-03
   -1.45630000E-04  -4.26300000E-05  +3.94600000E-05  +1.55450000E-04  -1.80020000E-04
   +8.23700000E-05  +5.59900000E-05  +6.32200000E-05  -1.02800000E-05  +1.44000000E-05
   -1.52490000E-04  +9.12400000E-05  -5.82000000E-06  -7.74700000E-05  -2.81300000E-05
   -1.33190000E-04  -1.33640000E-04  -5.12500000E-05  +8.90000000E-06  -2.73470000E-04
   +5.31750000E-04  +2.73890000E-04  +7.75580000E-04  -1.75960000E-04  +8.18000000E-06
   -2.07000000E-06  -2.48000000E-05  -1.52100000E-05  -1.60800000E-05  -2.51500000E-05
   -8.63000000E-06  +3.95400000E-05  -6.62000000E-05  -8.51600000E-05  +4.65200000E-05
   -7.76200000E-05  +4.42400000E-05  -1.44400000E-05  -2.17100000E-05  +4.10000000E-06
   +1.21920000E-04  +7.99500000E-05  +1.73200000E-05  +2.97600000E-04  -5.65400000E-05
   -3.36390000E-04  +1.17710000E-04  -6.07000000E-06  -3.00000000E-05  +4.22730000E-04
   -8.85300000E-05  +2.63890000E-04  +1.33870000E-04  -5.47000000E-06  -8.71000000E-06
   +1.48170000E-04  +9.69300000E-05  -4.35800000E-05  -2.84500000E-05  +1.17100000E-05
   +5.17000000E-06  -2.60900000E-05  -5.20200000E-05  -2.14800000E-05  -2.44200000E-05
   -6.76400000E-05  -6.01000000E-06  -5.60000000E-05  -4.88200000E-05  -1.01180000E-04
   +1.49300000E-05  -3.48160000E-04  -2.55700000E-05  -5.67300000E-04  -1.24720000E-04
   -2.87320000E-04  -5.17712200E-02  +9.26443500E-02  +1.27337900E-02  +5.85588000E-02
   +8.18110000E-04  +1.82299000E-03  -8.72570000E-04  +4.48209000E-03  -1.65088500E-02
   -1.76886000E-03  +1.06963000E-03  +1.51640000E-03  +9.51530000E-04  +2.58490000E-04
   -4.14550000E-04  -2.15030000E-04  -6.62630000E-04  +7.97170000E-04  -1.67950000E-04
   +3.22610000E-04  -4.65750000E-04  +1.90080000E-04  -3.18889000E-03  -7.63360000E-04
   +2.44640000E-04  -4.54900000E-05  +4.97650000E-04  -1.81060000E-04  +6.03130000E-04
   +1.17380000E-04  +1.17780000E-04  +3.51830000E-04  -4.24650000E-04  -9.70500000E-05
   -6.72300000E-05  +3.98300000E-05  +4.41300000E-05  -1.05560000E-04  +1.15300000E-05
   +1.31600000E-05  -1.13900000E-05  -3.98300000E-05  -1.75400000E-05  -6.81800000E-05
   +2.65700000E-05  +2.78700000E-05  -9.90800000E-05  +2.70000000E-05  -2.90200000E-05
   +2.44400000E-05  +1.99700000E-05  +1.09000000E-06  -5.21100000E-05  +5.37590000E-04
   +2.30990000E-04  +5.14580000E-04  -4.31640000E-04  +6.37300000E-05  -1.10300000E-05
   -1.82100000E-05  -1.17000000E-06  -7.68000000E-06  -6.05000000E-06  +1.24000000E-06
   +8.88000000E-06  -6.31800000E-05  -1.70100000E-05  +1.29600000E-05  -6.44600000E-05
   +3.07000000E-06  -4.95000000E-06  -7.93000000E-06  -2.94000000E-06  -1.87200000E-05
   +8.80600000E-05  +5.51000000E-05  -2.49300000E-05  -1.83000000E-05  +1.16870000E-04
   -2.71100000E-05  -9.90600000E-05  -5.56200000E-05  -1.26940000E-04  -3.08300000E-05
   -1.24550000E-04  -3.12400000E-05  -1.13390000E-04  +7.39600000E-05  -6.65300000E-05
   +8.82500000E-05  -1.03500000E-05  -2.22690000E-04  -2.75800000E-05  +1.68240000E-04
   -4.02000000E-05  -4.15730000E-04  -1.44300000E-05  -5.04100000E-05  -4.01840000E-04
   -4.01100000E-05  -2.08850000E-04  +7.77400000E-05  -2.52500000E-05  +3.80000000E-07
   -1.57240000E-04  -2.52900000E-05  -2.71010000E-04  -3.58700000E-05  -1.43510000E-04
   +4.22957900E-02  -5.22149790E-01  -5.29226800E-02  -4.53602800E-02  +5.36817420E-01
   +5.10470000E-04  -8.03270000E-04  +4.24330000E-04  +4.65680000E-04  +2.04257000E-03
   -1.64186000E-03  -4.86230000E-04  +1.14709000E-03  +7.99070000E-04  +2.86320000E-04
   -3.75430000E-04  -3.44610000E-04  +3.15650000E-04  -1.88510000E-04  +2.53724000E-03
   -1.82860000E-04  +3.23410000E-04  -1.80650000E-04  +1.99180000E-04  +2.00960000E-04
   -5.55290000E-04  -1.01830000E-04  +3.37500000E-04  +2.24800000E-04  -5.69800000E-05
   +1.93820000E-04  -7.26930000E-04  +1.23400000E-05  +6.38900000E-05  +3.51520000E-04
   -2.31500000E-05  +8.88500000E-05  +3.24800000E-05  +6.29000000E-06  +1.95400000E-05
   -4.37400000E-05  -3.21000000E-06  -1.61000000E-05  +7.59900000E-05  -5.52000000E-06
   -2.12700000E-05  -3.77500000E-05  +1.67100000E-05  -6.23200000E-05  +1.85900000E-05
   +1.67100000E-05  +1.14700000E-05  -2.50300000E-05  +1.44250000E-04  -3.31030000E-04
   +1.15220000E-04  -1.52230000E-04  +5.87500000E-05  -9.13030000E-04  +1.96000000E-06
   +4.33000000E-06  +8.32000000E-06  +1.26000000E-06  -1.34000000E-05  -3.23000000E-06
   +9.46000000E-06  -1.98700000E-05  -3.53700000E-05  -1.87500000E-05  +2.86300000E-05
   -3.11300000E-05  -8.80000000E-07  +1.65600000E-05  -2.11000000E-06  -1.60810000E-04
   -2.61400000E-05  -6.46400000E-05  -3.01640000E-04  -1.56510000E-04  +1.48240000E-04
   -1.05320000E-04  -5.09400000E-05  -1.13350000E-04  +2.53780000E-04  +1.62850000E-04
   +2.75700000E-05  +5.21700000E-05  +3.00800000E-05  -1.11300000E-04  +1.31240000E-04
   +4.69400000E-05  -9.16200000E-05  +7.53900000E-05  +5.01880000E-04  -5.52500000E-04
   -8.27000000E-05  +2.07000000E-05  -1.08560000E-04  +5.81100000E-05  -8.80500000E-05
   -1.35170000E-04  -1.92370000E-04  -3.74890000E-04  -6.30870000E-04  -7.71700000E-05
   -1.47650000E-04  +1.19540000E-04  +1.54320000E-04  +8.02400000E-05  +1.86770000E-04
   +7.93838000E-03  -5.69566000E-02  -8.35583000E-03  -8.59276000E-03  +5.44002100E-02
   +9.71064000E-03  +1.45500000E-04  -2.19880000E-04  +8.51110000E-04  +1.30742000E-03
   +3.30000000E-04  -5.30960000E-04  -1.63730000E-04  -2.56850000E-04  -1.09921000E-03
   -3.42740000E-04  +4.36944000E-03  +9.09300000E-04  +1.03768200E-02  -1.99304300E-02
   -6.76879000E-03  -1.80026000E-03  +3.15120000E-04  +1.61200000E-05  -2.90370000E-04
   -7.15110000E-04  +6.89400000E-05  +7.49800000E-05  +3.20810000E-04  +5.42900000E-05
   -3.04797000E-02  +4.50923900E-02  -2.46669800E-02  -1.63760000E-04  +2.00410000E-04
   +1.72860000E-04  -1.91880000E-04  +2.19900000E-04  -1.50690000E-04  -4.79700000E-05
   +3.37090000E-04  -5.02610000E-04  -1.91884000E-03  -9.78420000E-04  +1.30600000E-04
   +1.24530000E-04  +1.90320000E-04  +4.81010000E-04  -2.70000000E-06  +8.08700000E-05
   +1.97570000E-04  +1.87472000E-03  +6.46880000E-04  -1.04500000E-04  +3.70400000E-05
   +3.98300000E-04  -4.69600000E-05  -7.75096400E-02  -1.28815100E-02  -4.43442100E-02
   -3.40810000E-04  -2.57300000E-05  +5.02100000E-05  -1.62700000E-05  +8.66000000E-05
   +1.07120000E-04  -4.80000000E-05  -1.08220000E-04  -1.09470000E-04  +3.15300000E-05
   -1.39020000E-04  +9.05100000E-05  +5.94600000E-05  -7.76000000E-06  -7.89000000E-05
   -8.89800000E-05  +1.59330000E-04  +9.70500000E-05  +1.71900000E-05  -7.86700000E-05
   -4.83100000E-05  +3.70100000E-05  -1.08430000E-04  -5.76500000E-05  +1.92700000E-05
   -8.03600000E-05  +2.98500000E-05  +5.45900000E-05  -1.29360000E-04  +8.63200000E-05
   -9.28400000E-05  +1.75640000E-04  -2.69800000E-05  -4.98250000E-04  -3.05780000E-04
   -1.50000000E-05  +1.01570000E-04  -1.60550000E-04  +1.87680000E-04  -6.67950000E-04
   +8.19700000E-05  +6.03100000E-05  -3.32670000E-04  +4.79100000E-05  +1.47460000E-04
   -2.15332000E-03  -5.17860000E-04  -4.50424000E-03  -2.33993700E-02  -9.27206000E-03
   +1.52509000E-03  -1.44412000E-03  +6.30300000E-05  +4.09770000E-04  +5.03190000E-04
   +2.93910000E-04  -1.25860000E-04  +5.73288990E-01  -1.86760000E-04  +2.99750000E-04
   -8.51200000E-05  +3.79200000E-05  +1.77190000E-04  -1.07400000E-05  -2.21360000E-04
   +4.14900000E-04  -3.65760000E-04  +4.67840000E-04  +5.76706000E-03  -5.33880000E-04
   -4.92938000E-03  -4.55702000E-02  -8.60148000E-03  +1.56701000E-03  +2.60754000E-03
   +1.23225000E-03  -2.92160000E-04  -8.61200000E-05  +4.57700000E-05  +9.80400000E-05
   +1.25520000E-04  -4.10600000E-05  +7.77862600E-02  -3.00586000E-02  +3.44610500E-02
   -3.49760000E-04  -2.59640000E-04  +1.93900000E-05  -1.58350000E-04  -4.10340000E-04
   +1.43330000E-04  +5.37760000E-04  -3.01700000E-04  +5.34900000E-05  +2.66630000E-04
   +3.15490000E-04  -1.29250000E-04  +2.04830000E-04  -1.19800000E-05  -2.18230000E-04
   -2.45900000E-05  -5.21300000E-05  -1.65660000E-04  -3.81500000E-05  -2.72310000E-04
   +1.68400000E-05  +9.93600000E-05  +1.25390000E-04  +3.38500000E-05  -6.50440400E-02
   +1.99336000E-02  -2.35027100E-02  +4.67000000E-05  +2.15780000E-04  -4.27400000E-05
   -5.02100000E-05  +1.49120000E-04  +8.73700000E-05  -4.49100000E-05  +2.46700000E-05
   -4.80400000E-05  -1.27200000E-05  -2.65000000E-06  +5.66500000E-05  -4.23100000E-05
   +6.35900000E-05  +9.62000000E-06  -5.41300000E-05  +1.73200000E-05  +2.41000000E-05
   +8.06500000E-05  +5.88000000E-06  -2.12400000E-05  -3.21600000E-05  -4.28200000E-05
   +2.56200000E-05  +8.07500000E-05  +1.50000000E-06  +7.56000000E-06  -3.52400000E-05
   -3.90000000E-05  -1.97300000E-05  -5.70600000E-05  +2.47400000E-05  -8.14000000E-06
   -5.39610000E-04  -6.96060000E-04  +2.73900000E-05  -9.34000000E-06  -4.63630000E-04
   +1.47650000E-04  +1.64900000E-05  -4.43040000E-04  -1.29790000E-04  -2.53080000E-04
   -4.79950000E-04  -5.29200000E-05  +5.16542000E-03  +1.91612000E-03  +5.35513000E-03
   +3.96939900E-02  -4.26920200E-02  -3.84464000E-03  +3.28450000E-04  +2.71060000E-04
   -8.52000000E-06  -2.20500000E-05  -1.05820000E-04  +2.00000000E-08  -7.05507600E-02
   +1.36759070E-01  +1.08750000E-04  -2.69020000E-04  +1.17105000E-03  +7.34380000E-04
   +2.91780000E-04  -6.35140000E-04  +5.47300000E-05  -2.15340000E-04  -7.11030000E-04
   -5.19740000E-04  +2.16309000E-03  +5.57100000E-04  +5.09008000E-03  -1.26999500E-02
   -5.02179000E-03  -1.23447000E-03  +1.07686000E-03  -1.31160000E-03  -1.36410000E-04
   -3.94770000E-04  +1.31820000E-04  +3.69600000E-05  +1.42710000E-04  +1.76200000E-05
   -2.25679200E-02  +2.62485200E-02  +3.54741000E-03  -9.24300000E-05  +1.32180000E-04
   +1.78390000E-04  -1.39620000E-04  +1.78560000E-04  -1.49000000E-04  -9.13900000E-05
   +1.56140000E-04  -2.86850000E-04  -8.54990000E-04  -4.75720000E-04  +3.10300000E-05
   +1.70000000E-06  +1.02450000E-04  +2.85470000E-04  +4.23700000E-05  +6.65700000E-05
   +1.35680000E-04  +8.32800000E-04  +3.49260000E-04  +6.75000000E-06  -1.36700000E-05
   +2.48440000E-04  -5.61100000E-05  -5.12016800E-02  -4.58454000E-03  -7.87877000E-03
   -1.32850000E-04  -9.30300000E-05  +6.08000000E-06  +3.90000000E-06  +1.19070000E-04
   +7.14100000E-05  -7.81800000E-05  -4.12400000E-05  -3.17300000E-05  +2.99600000E-05
   -8.30200000E-05  +5.37200000E-05  +4.25500000E-05  -4.17700000E-05  -1.99300000E-05
   -4.52500000E-05  +7.97900000E-05  +6.94700000E-05  +1.35000000E-06  -4.34100000E-05
   -2.38800000E-05  +2.94600000E-05  -5.13000000E-05  -5.44000000E-06  +2.99000000E-06
   -4.17100000E-05  +1.31600000E-05  +3.36800000E-05  -7.44100000E-05  +7.16100000E-05
   -4.07700000E-05  +9.35100000E-05  -5.82000000E-06  -2.69630000E-04  -1.16240000E-04
   +2.27200000E-05  +1.09100000E-04  -5.60600000E-05  +1.12000000E-04  -3.20330000E-04
   -2.28460000E-04  +5.27880000E-04  -2.26260000E-04  +3.93200000E-05  +9.65400000E-05
   -4.25922000E-03  -1.66790000E-04  -4.24661000E-03  +1.59623400E-02  -1.59996200E-02
   -4.30912900E-02  -7.53360000E-04  -1.79100000E-05  +4.53980000E-04  +2.71840000E-04
   +1.68040000E-04  -1.57200000E-04  -1.56235760E-01  +4.19486300E-02  +2.18135230E-01
   -1.15220000E-04  +4.94560000E-04  -1.16157000E-03  -9.29000000E-04  +2.01890000E-04
   +8.83100000E-05  +1.02420000E-04  +2.47800000E-04  +3.47130000E-04  +1.96420000E-04
   +1.80782000E-03  -1.02938000E-03  -2.37925300E-02  -3.81146100E-02  -1.08314000E-02
   +2.05342000E-03  +1.52103000E-03  +2.59353000E-03  -1.20300000E-04  +3.23410000E-04
   +4.52200000E-05  +4.69100000E-05  -1.19180000E-04  -7.01700000E-05  -2.13970500E-02
   +8.27308000E-03  -5.19599000E-03  -2.83190000E-04  -4.53280000E-04  -1.48300000E-04
   +5.10200000E-05  -5.45230000E-04  +2.46060000E-04  +5.23090000E-04  -5.36790000E-04
   +5.26300000E-04  +2.13674000E-03  +1.19877000E-03  -2.04820000E-04  +1.22640000E-04
   -1.91700000E-04  -5.84220000E-04  -6.34200000E-05  -1.61550000E-04  -3.16820000E-04
   -1.86190000E-03  -6.98820000E-04  +1.23750000E-04  +6.03800000E-05  -1.26040000E-04
   +4.62600000E-05  -2.52008100E-02  +1.54606100E-02  -8.08619000E-03  +3.55610000E-04
   +9.40600000E-05  -6.57000000E-05  +4.89000000E-06  -2.20000000E-05  -7.42700000E-05
   +4.13000000E-06  +1.08380000E-04  +4.89700000E-05  -4.14600000E-05  +8.69700000E-05
   -7.57000000E-06  -7.25700000E-05  +5.43100000E-05  +7.70400000E-05  +1.61700000E-05
   -9.13100000E-05  -2.18600000E-05  +5.64600000E-05  +5.63200000E-05  +9.40000000E-06
   -4.70600000E-05  +4.30400000E-05  +8.00300000E-05  +5.41100000E-05  +5.47000000E-05
   -1.08100000E-05  -6.10400000E-05  +4.50800000E-05  -6.60800000E-05  +1.66600000E-05
   -8.89000000E-05  +1.36400000E-05  -9.29500000E-05  -4.26560000E-04  +5.36400000E-05
   -3.20900000E-05  -3.26590000E-04  +6.45600000E-05  +3.50830000E-04  -3.71730000E-04
   -1.43560000E-04  +2.28100000E-05  -6.22900000E-04  -1.58440000E-04  +1.55352000E-03
   +2.72166000E-03  +4.39962000E-03  +3.91456400E-02  +5.84271000E-03  +1.95418100E-02
   +1.19566000E-03  +1.51800000E-04  -8.59800000E-05  -3.35640000E-04  -2.57260000E-04
   +1.85400000E-05  -2.28290800E-02  -5.09657400E-02  +1.64344200E-02  +5.69498300E-02
   +2.40780000E-04  -5.14460000E-04  +1.04904000E-03  +5.34110000E-04  -2.76460000E-04
   -6.64180000E-04  +1.00860000E-04  -5.17780000E-04  -8.73430000E-04  -3.70506000E-03
   -4.89615000E-03  +1.63574000E-03  -1.86693000E-03  +4.65243900E-02  -1.70972000E-03
   -2.84541000E-03  -2.01359000E-03  -2.22645000E-03  +1.17820000E-04  -3.16440000E-04
   +8.04400000E-05  -4.35000000E-05  +1.26000000E-05  +4.15200000E-05  -3.14840000E-02
   -4.38428000E-02  -1.66391100E-02  +2.22010000E-04  +2.45170000E-04  +4.11000000E-05
   +1.29860000E-04  +4.92100000E-04  -1.84920000E-04  -5.88620000E-04  +4.97510000E-04
   -3.29970000E-04  -1.05516000E-03  -7.64290000E-04  +2.25840000E-04  -1.18020000E-04
   +1.01920000E-04  +4.38750000E-04  -1.62900000E-05  +6.30400000E-05  +1.53870000E-04
   +8.77050000E-04  +5.91730000E-04  -5.36800000E-05  -8.98900000E-05  +1.15990000E-04
   -6.95400000E-05  +2.96072500E-02  -1.39036700E-02  +8.72128000E-03  -2.25290000E-04
   -2.32200000E-04  +6.77000000E-05  +4.13800000E-05  -1.03780000E-04  -5.76300000E-05
   -4.33000000E-06  -6.49600000E-05  +2.00000000E-06  +2.32500000E-05  -7.04300000E-05
   +9.89000000E-06  +6.72500000E-05  -7.04900000E-05  -4.26600000E-05  +4.69000000E-06
   +5.68900000E-05  +4.10800000E-05  -6.33300000E-05  -4.44300000E-05  -6.22000000E-06
   +4.80900000E-05  -6.19000000E-06  -2.81800000E-05  -6.47000000E-05  -3.85100000E-05
   +9.17000000E-06  +6.16800000E-05  -3.99000000E-05  +8.99200000E-05  +1.32700000E-05
   +6.48500000E-05  +1.55600000E-05  +2.95900000E-04  +9.14610000E-04  -1.08100000E-05
   +1.38560000E-04  +4.06420000E-04  -9.67600000E-05  -5.70450000E-04  +1.36470000E-04
   +8.21470000E-04  +1.30120000E-04  +5.49210000E-04  +1.51290000E-04  +6.38987000E-03
   -8.09798000E-03  +4.57160000E-03  -3.47862300E-02  -3.55690300E-02  -1.72134300E-02
   -1.02308000E-03  -2.10760000E-04  +4.80100000E-04  +2.65810000E-04  +2.57980000E-04
   -1.41680000E-04  -7.35556000E-03  -3.68124000E-03  +1.43541000E-03  +4.68720200E-02
   +5.71168000E-02  -6.49600000E-05  +2.87640000E-04  -1.12253000E-03  -3.72360000E-04
   +7.45500000E-05  +3.64550000E-04  -6.71100000E-05  +2.43370000E-04  +3.07640000E-04
   +7.27440000E-04  +1.34499000E-03  -6.17540000E-04  -8.57189000E-03  -2.06437200E-02
   -1.22054000E-03  +2.22662000E-03  +6.85390000E-04  +1.81945000E-03  -8.53200000E-05
   +1.85290000E-04  -8.63700000E-05  +2.77300000E-05  -1.28000000E-06  -2.66700000E-05
   -1.64023400E-02  +7.09143000E-03  -5.45987800E-02  -1.96590000E-04  -3.02750000E-04
   -2.28380000E-04  +1.61510000E-04  -4.31840000E-04  +2.00880000E-04  +3.57080000E-04
   -1.66490000E-04  +2.53940000E-04  +8.01160000E-04  +5.40210000E-04  -3.90000000E-05
   +6.66900000E-05  -6.46900000E-05  -3.30250000E-04  -5.07200000E-05  -3.87500000E-05
   -2.66920000E-04  -6.88770000E-04  -3.54610000E-04  -1.27600000E-05  +5.95200000E-05
   -7.36600000E-05  +5.40000000E-05  -1.34002200E-02  +7.10280000E-03  -5.78488000E-03
   +1.22010000E-04  +1.45300000E-04  -1.54800000E-05  -9.93000000E-06  -1.27530000E-04
   -8.64400000E-05  +6.58700000E-05  +3.51500000E-05  -2.16700000E-05  -1.94300000E-05
   +3.69700000E-05  +1.19000000E-06  -4.82900000E-05  +4.87000000E-05  +1.33800000E-05
   -3.63000000E-06  -3.55500000E-05  -2.11700000E-05  +3.54700000E-05  +2.90900000E-05
   -7.60000000E-07  -2.90900000E-05  +1.14200000E-05  +1.25500000E-05  +3.61600000E-05
   +2.34200000E-05  -3.30000000E-07  -3.37700000E-05  +2.36200000E-05  -4.89900000E-05
   -1.09400000E-05  -3.94200000E-05  -6.50000000E-06  -5.56400000E-05  -2.77860000E-04
   -6.15000000E-06  -5.78000000E-05  -1.28170000E-04  -2.27800000E-05  +4.38110000E-04
   +3.25150000E-04  -7.28860000E-04  +4.84000000E-06  -3.36410000E-04  -9.28900000E-05
   +1.79187200E-02  -4.68024000E-03  +1.19277000E-02  +1.86752700E-02  +3.23076000E-03
   +1.51794800E-02  +5.85110000E-04  +1.18120000E-04  -2.38940000E-04  -1.53270000E-04
   -1.32310000E-04  +8.42900000E-05  +7.83700000E-03  -3.41599000E-03  -3.55559600E-02
   -1.35552400E-02  +2.51244000E-02  +6.54825400E-02  -1.71600000E-05  +2.88200000E-05
   -4.91200000E-05  -1.19680000E-04  -4.73800000E-05  +1.74800000E-05  +2.94800000E-05
   +1.66300000E-05  +5.59300000E-05  +5.15500000E-05  +5.96100000E-05  -2.41800000E-05
   -1.55840000E-04  -8.46100000E-05  +2.95370000E-04  +2.46300000E-04  -1.74800000E-04
   +1.44120000E-04  +2.96100000E-05  +6.89400000E-05  +7.51000000E-06  -4.60000000E-06
   -3.40200000E-05  -7.66000000E-06  +1.50448000E-03  +4.70160000E-04  -4.44430000E-04
   +1.46600000E-05  -1.90300000E-05  -1.18800000E-05  +1.91000000E-06  -3.93200000E-05
   +4.48000000E-06  +2.85400000E-05  -6.21600000E-05  +4.92100000E-05  +2.07510000E-04
   +1.16510000E-04  -2.67300000E-05  -2.53000000E-05  -2.88800000E-05  -5.02000000E-05
   +7.11000000E-06  +2.70000000E-06  -1.28300000E-05  -1.98840000E-04  -9.36500000E-05
   +1.36400000E-05  -3.94000000E-06  -3.27000000E-05  +2.88000000E-06  -1.16650000E-04
   -1.95293000E-03  -3.35437000E-03  +4.69100000E-05  +2.12900000E-05  -5.27000000E-06
   +2.90000000E-07  +1.62900000E-05  +2.40000000E-07  -4.12000000E-06  +1.48200000E-05
   +1.37200000E-05  -3.42000000E-06  +1.28200000E-05  -5.48000000E-06  -7.69000000E-06
   +7.91000000E-06  +8.86000000E-06  +7.62000000E-06  -1.74900000E-05  -7.75000000E-06
   +4.20000000E-07  +8.35000000E-06  +4.61000000E-06  -4.43000000E-06  +1.07100000E-05
   +9.48000000E-06  +2.00000000E-08  +9.02000000E-06  -3.53000000E-06  -6.12000000E-06
   +1.13500000E-05  -7.32000000E-06  +8.93000000E-06  -1.84400000E-05  +4.13000000E-06
   +1.43600000E-05  -7.83000000E-06  +7.27000000E-06  -1.21800000E-05  -1.20600000E-05
   +2.10000000E-06  -1.34600000E-04  +1.88300000E-05  -2.66800000E-05  +2.36500000E-05
   +5.33000000E-06  -9.98000000E-06  +1.98070000E-04  +2.21030000E-04  -1.44130000E-04
   -1.23579200E-02  +6.59855000E-03  +1.15762300E-02  +1.49440000E-04  -1.96000000E-06
   -1.73300000E-05  -5.23100000E-05  -2.64400000E-05  +2.06000000E-06  -4.23230570E-01
   +6.74357900E-02  +1.99390550E-01  -7.74406000E-03  -2.75760000E-04  +3.73103000E-03
   +4.41628550E-01  -1.32700000E-05  +1.31200000E-05  -7.06000000E-06  +2.72300000E-05
   +6.89000000E-06  -3.78900000E-05  -4.82700000E-05  +1.36000000E-06  -1.55100000E-05
   +9.60700000E-05  +2.72690000E-04  +9.44000000E-06  +6.54700000E-05  -1.97559000E-03
   -5.82080000E-04  +2.08100000E-05  -1.35100000E-04  +1.05300000E-04  +3.25400000E-05
   +8.49000000E-06  +1.13700000E-05  -8.41000000E-06  -8.97000000E-06  +1.40000000E-06
   +4.94855000E-03  -5.03820000E-03  +6.44307000E-03  -2.87900000E-05  -1.11500000E-05
   -1.24100000E-05  +2.63300000E-05  +1.28000000E-05  +3.00000000E-07  -3.83700000E-05
   -8.56000000E-06  +5.04200000E-05  +3.05680000E-04  +1.21130000E-04  -1.49600000E-05
   -3.87500000E-05  -1.08000000E-05  -2.64200000E-05  -5.90000000E-07  +4.62000000E-06
   -2.95000000E-06  -3.04820000E-04  +1.33000000E-06  +2.85900000E-05  -8.91000000E-06
   -2.60000000E-06  -2.78000000E-06  -5.23323000E-03  -1.08178000E-03  -4.97586000E-03
   +5.63500000E-05  -7.90000000E-05  +2.68000000E-06  +1.92800000E-05  -2.08500000E-05
   -2.76200000E-05  -3.90000000E-07  +1.00000000E-07  +6.55000000E-06  -7.50000000E-07
   -1.42000000E-06  -4.47000000E-06  +7.94000000E-06  -1.55400000E-05  +1.26100000E-05
   +3.71000000E-06  +2.00000000E-07  +5.30000000E-07  -7.87000000E-06  -2.27000000E-06
   +8.70000000E-07  +3.66000000E-06  +3.41000000E-06  -2.38000000E-06  -7.62000000E-06
   -1.91000000E-06  -5.80000000E-07  +4.14000000E-06  +1.75000000E-06  +3.93000000E-06
   +4.32000000E-06  -2.00000000E-08  +1.13000000E-06  -2.78200000E-05  -3.30100000E-05
   +1.65000000E-06  +1.10300000E-05  +5.79000000E-06  +1.35200000E-05  +3.01800000E-05
   -3.69900000E-05  -2.96900000E-05  -4.78000000E-06  +1.97200000E-05  +6.64000000E-06
   +2.69200000E-05  +1.64080000E-04  +1.89020000E-04  -6.50897000E-03  +6.94941000E-03
   +1.39163100E-02  -6.76300000E-05  -3.50500000E-05  +9.28000000E-06  +1.24600000E-05
   +2.03900000E-05  -6.64000000E-06  +7.04123900E-02  -4.35460500E-02  -3.93460100E-02
   +8.46018000E-03  +7.12784000E-03  -1.54565200E-02  -7.22260000E-02  +3.73097600E-02
   +2.58900000E-05  -2.60200000E-05  +1.37440000E-04  -3.16000000E-05  -3.14500000E-05
   -6.39800000E-05  -2.29200000E-05  -2.84000000E-05  -5.53700000E-05  +1.39560000E-04
   +2.36640000E-04  +1.52780000E-04  +2.04270000E-04  -3.60090000E-04  -2.77450000E-04
   +5.08300000E-05  -3.91800000E-05  -2.71820000E-04  +1.71300000E-05  +2.12200000E-05
   +2.44000000E-05  -4.09000000E-06  -1.94400000E-05  -1.76000000E-06  -3.31255000E-03
   +3.69946000E-03  -2.99187000E-03  +7.03000000E-06  +5.27000000E-06  -2.83000000E-05
   +1.93200000E-05  +8.53000000E-06  -9.12000000E-06  -1.96000000E-06  -3.90000000E-07
   +3.17000000E-05  +2.78000000E-05  +1.70200000E-05  +8.50000000E-06  +1.65000000E-06
   -2.08900000E-05  +2.28000000E-06  -1.85100000E-05  -8.87000000E-06  +4.43000000E-06
   -2.43100000E-05  -2.36200000E-05  -2.25700000E-05  -3.57000000E-06  -7.20000000E-06
   -1.30000000E-07  -4.09665000E-03  -1.77127000E-03  -3.98534000E-03  -9.19000000E-06
   +3.01800000E-05  +1.61100000E-05  +6.79000000E-06  -8.36000000E-06  -8.13000000E-06
   +1.96000000E-06  +8.83000000E-06  +8.09000000E-06  -7.52000000E-06  +3.87000000E-06
   -8.80000000E-07  -5.09000000E-06  +2.05400000E-05  -6.73000000E-06  +3.92000000E-06
   -6.79000000E-06  +2.40000000E-07  -1.00000000E-07  +2.26000000E-06  +1.83000000E-06
   -3.02000000E-06  +6.54000000E-06  +3.53000000E-06  -9.20000000E-07  +2.96000000E-06
   -1.33000000E-06  +5.00000000E-08  +2.13000000E-06  -3.33000000E-06  +4.86000000E-06
   -6.61000000E-06  +4.03000000E-06  -1.36700000E-05  -2.50300000E-05  +1.16800000E-05
   -3.36700000E-05  -1.28300000E-05  -2.05500000E-05  -1.54020000E-04  -7.07400000E-05
   +1.55620000E-04  +1.40700000E-05  +3.46800000E-05  +1.14000000E-06  -2.90000000E-05
   +3.10080000E-04  -3.38790000E-04  -4.62072000E-03  +5.63696000E-03  +8.14483000E-03
   +4.87000000E-05  -8.40000000E-07  +1.47700000E-05  -1.57800000E-05  -7.45000000E-06
   -2.84000000E-06  +2.25906900E-01  -4.24500700E-02  -1.26507990E-01  -2.93985000E-03
   -4.85880000E-03  +5.47993000E-03  -2.11132010E-01  +3.97371900E-02  +1.20394970E-01
end_hess

