# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -883.29555030    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -3.35692512E+00  +7.64688367E-01  -2.32723831E+00
   006   -3.68425478E+00  -7.74278117E-01  +4.44676852E-02
   006   -3.23174073E+00  +7.99488602E-01  +2.36891714E+00
   006   -2.21248181E+00  +3.08486245E+00  +2.33038270E+00
   006   -1.51345139E+00  +4.37008878E+00  -6.27616456E-02
   006   -2.37188338E+00  +3.06527059E+00  -2.38575183E+00
   006   -1.90831313E+00  -3.18175410E+00  +3.20260395E-02
   006   -2.49394197E+00  -4.82668136E+00  +2.35383257E+00
   008   +1.79805683E+00  +4.23657165E+00  -2.73450898E-01
   006   +8.63141742E-01  -2.34184243E+00  +2.44221298E-02
   006   +2.19577188E+00  -1.96508279E+00  -2.21851453E+00
   006   +4.69054022E+00  -1.19608484E+00  -2.24985053E+00
   006   +5.95386934E+00  -7.61259751E-01  +4.29738450E-03
   006   +4.67404436E+00  -1.09805038E+00  +2.26992995E+00
   006   +2.17216531E+00  -1.88449736E+00  +2.25861265E+00
   008   +8.40510000E+00  -1.97727926E-02  -1.13645568E-01
   006   -2.51835420E+00  -4.82046133E+00  -2.28556808E+00
   008   -1.38157296E+00  +6.84350706E+00  -4.41526481E-02
   001   +9.07048617E+00  +1.72387756E-01  +1.55666773E+00
   001   +5.67804486E+00  -9.14174721E-01  -4.01550304E+00
   001   +1.27940793E+00  -2.26911042E+00  -4.01609925E+00
   001   +1.25200455E+00  -2.13891365E+00  +4.06253967E+00
   001   +5.63456414E+00  -7.86441986E-01  +4.05306054E+00
   001   -1.30450365E+00  -6.48503878E+00  -2.28326057E+00
   001   -4.47788774E+00  -5.43797417E+00  -2.20999780E+00
   001   -2.24073284E+00  -3.85126150E+00  -4.07588018E+00
   001   -4.44359282E+00  -5.47393190E+00  +2.28363221E+00
   001   -2.23059758E+00  -3.85288283E+00  +4.14446076E+00
   001   -1.25398433E+00  -6.47186870E+00  +2.35141682E+00
   001   -3.83902116E+00  -3.31001585E-02  +4.13624875E+00
   001   -1.94508705E+00  +4.18735142E+00  +4.03306484E+00
   001   -2.18069486E+00  +4.12846604E+00  -4.12086579E+00
   001   -4.03289437E+00  -1.10706201E-01  -4.04796966E+00
   001   +2.61160794E+00  +3.38495508E+00  +1.11489099E+00
   001   +9.35466822E-01  +6.29738273E+00  +1.62843546E-02
   008   -6.20841964E+00  -1.72535486E+00  +1.21296269E-01
   001   -7.33908175E+00  -3.13463825E-01  +6.46917637E-02
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -5.10000000E-07  -1.65000000E-06  -2.60000000E-07
   +0.00000000E+00  -7.70000000E-07  +3.90000000E-07
   -7.00000000E-08  +2.40000000E-07  -3.20000000E-07
   -6.10000000E-07  +5.30000000E-07  -1.27000000E-06
   -1.18000000E-06  -2.30000000E-07  -1.89000000E-06
   -1.02000000E-06  -1.47000000E-06  -1.30000000E-06
   +6.00000000E-07  -4.70000000E-07  +1.14000000E-06
   +1.17000000E-06  +4.10000000E-07  +1.91000000E-06
   -1.08000000E-06  +4.10000000E-07  -2.17000000E-06
   +4.90000000E-07  +2.10000000E-07  +4.70000000E-07
   +0.00000000E+00  -3.70000000E-07  +5.90000000E-07
   +1.10000000E-07  +2.70000000E-07  -6.00000000E-08
   +4.00000000E-08  +1.36000000E-06  -7.20000000E-07
   +1.50000000E-07  +1.95000000E-06  -1.60000000E-07
   +6.60000000E-07  +1.51000000E-06  +3.20000000E-07
   -2.00000000E-07  +1.82000000E-06  -9.20000000E-07
   +7.50000000E-07  -1.48000000E-06  +1.91000000E-06
   -1.65000000E-06  -3.00000000E-07  -2.90000000E-06
   -6.00000000E-08  +2.68000000E-06  -1.17000000E-06
   -3.00000000E-07  -3.50000000E-07  -3.60000000E-07
   +0.00000000E+00  -1.31000000E-06  +4.90000000E-07
   +6.90000000E-07  +1.94000000E-06  +5.00000000E-07
   +3.80000000E-07  +2.91000000E-06  -4.60000000E-07
   +1.14000000E-06  -1.19000000E-06  +2.48000000E-06
   +8.50000000E-07  -1.90000000E-06  +2.36000000E-06
   +3.40000000E-07  -2.11000000E-06  +1.50000000E-06
   +1.23000000E-06  +1.00000000E-08  +2.37000000E-06
   +1.08000000E-06  +1.17000000E-06  +1.53000000E-06
   +1.51000000E-06  +7.00000000E-07  +2.47000000E-06
   +2.20000000E-07  +8.30000000E-07  +1.40000000E-07
   -7.10000000E-07  +1.22000000E-06  -1.78000000E-06
   -1.41000000E-06  -2.13000000E-06  -1.74000000E-06
   -4.90000000E-07  -2.54000000E-06  +1.00000000E-07
   -7.30000000E-07  +8.10000000E-07  -1.83000000E-06
   -1.54000000E-06  +2.00000000E-07  -2.88000000E-06
   +2.50000000E-07  -1.32000000E-06  +9.70000000E-07
   -8.00000000E-08  -1.58000000E-06  +5.40000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +2.95120470E-01  +2.62643840E-01  +7.57831790E-01  +7.93946600E-02  +2.88638500E-02
   +5.85993360E-01  -7.18984100E-02  -1.08388800E-02  +8.93846000E-03  +4.26183070E-01
   +6.79710000E-04  -1.08778370E-01  +4.18928800E-02  +3.53324700E-02  +4.62012960E-01
   -5.42627000E-03  +4.46755800E-02  -1.79255620E-01  +3.79653000E-03  -3.45110000E-04
   +5.33590680E-01  +5.59493000E-03  +4.53910000E-03  +1.63440000E-04  -7.20349600E-02
   -9.39220000E-04  -1.97120000E-04  +2.96834370E-01  +4.98968000E-03  +1.26628100E-02
   +1.13003200E-02  -1.29469700E-02  -1.10644740E-01  -4.67604200E-02  +2.64335350E-01
   +7.51475160E-01  -2.65222000E-03  -1.25135300E-02  -3.63730800E-02  -1.44838500E-02
   -4.34882600E-02  -1.78721690E-01  -7.12543400E-02  -4.30865100E-02  +5.95581560E-01
   -4.46620000E-04  -1.38943000E-03  +1.60765000E-03  +5.33951000E-03  -1.00242200E-02
   -5.86836000E-03  -1.38397970E-01  -1.90374660E-01  +1.17858800E-02  +2.55050770E-01
   -9.63580000E-04  -2.35978000E-03  +3.67597000E-03  -7.38540000E-03  -1.68609400E-02
   -4.24210000E-03  -1.92968030E-01  -4.80173590E-01  +7.24060000E-03  +2.62247440E-01
   +7.67901050E-01  +1.04147000E-03  +8.88090000E-04  -5.54240000E-04  -1.01768100E-02
   -2.06592500E-02  +7.26041000E-03  +7.49203000E-03  -4.32505000E-03  -1.25583160E-01
   -1.35918600E-02  +7.45267100E-02  +6.09900030E-01  -2.54064000E-03  -1.61068000E-02
   -7.10445000E-03  -1.28233200E-02  +8.62960000E-03  +4.16490000E-04  -1.75060000E-03
   -1.50626800E-02  +8.64931000E-03  -6.98360200E-02  -3.49713000E-03  +1.83721400E-02
   +1.58676160E-01  -1.27751400E-02  -1.92098900E-02  -2.31980600E-02  +1.35374000E-03
   -7.66430000E-04  +2.29350000E-04  -1.12012300E-02  -1.84594400E-02  +2.34397600E-02
   -1.97532600E-02  -9.65000800E-02  +3.77189400E-02  +1.68259380E-01  +6.09843800E-01
   -1.18819000E-03  -1.48598300E-02  +1.48632100E-02  +8.73590000E-04  -3.88030000E-04
   +9.11846000E-03  +2.49623000E-03  +1.72909800E-02  +1.43773900E-02  +2.29583100E-02
   +2.20921000E-02  -2.10414310E-01  +1.82998500E-02  -7.20670000E-04  +5.61291220E-01
   -1.33503840E-01  -1.85080480E-01  -6.83991000E-03  +5.77116000E-03  -8.53591000E-03
   +6.35460000E-03  -5.74450000E-04  -9.57420000E-04  -1.40545000E-03  +1.10047800E-02
   +2.12709000E-03  +5.80361000E-03  -7.22176200E-02  -2.27322500E-02  -3.46866100E-02
   +2.53998620E-01  -1.86503840E-01  -4.85006480E-01  +9.78167000E-03  -6.57370000E-03
   -1.65917200E-02  +5.34031000E-03  -1.43863000E-03  -2.49123000E-03  -3.67848000E-03
   +3.71561000E-03  +1.62511900E-02  +8.80067000E-03  -7.04209000E-03  -1.00619210E-01
   -2.57389300E-02  +2.55749190E-01  +7.68765640E-01  -3.17788000E-03  +2.07378100E-02
   -1.25186710E-01  +9.46131000E-03  +2.20806600E-02  +5.66591000E-03  -1.09361000E-03
   -8.20840000E-04  -3.45470000E-04  -8.44235000E-03  -8.92046000E-03  -3.03646700E-02
   -3.09825000E-02  -3.87386900E-02  -2.10632070E-01  +2.94654100E-02  -9.22612000E-02
   +6.18981190E-01  +5.24760000E-03  +3.55124000E-03  -6.89052000E-03  -6.92827000E-02
   -4.79690000E-04  -4.74050000E-04  +6.55758000E-03  +3.48193000E-03  +7.21447000E-03
   -3.27942000E-03  -1.37601000E-03  -7.09370000E-04  +3.52712000E-03  +1.19799000E-03
   -1.22780000E-04  -2.52006000E-03  -1.40198000E-03  +7.90860000E-04  +4.64644740E-01
   +7.55654000E-03  -2.10834800E-02  +8.28029000E-03  +2.99491400E-02  -9.78705900E-02
   -6.11730000E-04  +7.46199000E-03  -2.20453900E-02  -8.55954000E-03  +1.31158000E-03
   +1.30873000E-03  -8.13690000E-04  -3.79040000E-04  -1.13209000E-03  +7.37800000E-05
   +1.33627000E-03  +1.29625000E-03  +7.16190000E-04  +3.97202600E-02  +4.43431530E-01
   -1.51683800E-02  +2.24117600E-02  +1.96026000E-03  +4.56900000E-05  -5.68310000E-04
   -7.58249000E-02  +1.50845200E-02  -2.22025900E-02  +1.44817000E-03  -4.50110000E-04
   -8.02180000E-04  -2.73193000E-03  -5.89000000E-05  -2.05500000E-05  -2.85465000E-03
   -7.76200000E-05  +7.57060000E-04  -2.86618000E-03  +1.97480000E-04  +1.74299000E-03
   +4.91140570E-01  -2.93069000E-03  +2.57737000E-03  +1.83598000E-03  +3.56023000E-03
   +1.29419500E-02  -1.60649000E-02  -2.17400000E-04  +7.78200000E-05  -2.50300000E-05
   +3.70660000E-04  +2.18720000E-04  -4.76200000E-04  -1.38531000E-03  -5.19120000E-04
   -5.31140000E-04  +3.82830000E-04  +7.24950000E-04  -6.41610000E-04  -7.97549000E-02
   -1.15508500E-02  +1.44982100E-02  +5.89375070E-01  +2.90747000E-03  -2.81816000E-03
   -2.17565000E-03  +8.64750000E-04  -2.23237100E-02  +2.37537200E-02  -1.32750000E-04
   -1.35645000E-03  +2.45190000E-04  +1.07410000E-04  +2.08790000E-04  +3.65740000E-04
   +7.15200000E-04  +3.80440000E-04  +1.10828000E-03  -9.11600000E-05  -6.00760000E-04
   +6.53650000E-04  -1.24769800E-02  -1.05614700E-01  +4.34015700E-02  -1.49145100E-02
   +5.36221440E-01  +1.09606000E-03  -6.45360000E-04  -3.39070000E-04  -3.63151000E-03
   +4.85450000E-03  -7.29810000E-04  -6.31210000E-04  -4.91700000E-05  +2.13431000E-03
   -7.10000000E-05  -7.60200000E-05  -8.98680000E-04  +3.35640000E-04  +1.31860000E-04
   +5.28850000E-04  -2.19550000E-04  -1.95550000E-04  +2.09750000E-04  +1.39264800E-02
   +4.00004300E-02  -1.39460160E-01  +2.14018700E-02  +6.26078900E-02  +5.24760810E-01
   +8.77000000E-06  +4.76506000E-03  -3.65527000E-03  -2.91630000E-04  +1.28339000E-03
   +2.72970000E-04  -7.01000000E-05  +5.03887000E-03  +4.39645000E-03  -2.59147200E-02
   -1.17152500E-02  +6.45467000E-03  +4.90605700E-02  -2.30846000E-02  +1.26601000E-02
   -2.59881900E-02  -1.17871800E-02  -6.70810000E-03  -2.79661000E-03  +5.75730000E-04
   -2.74500000E-05  +1.18324000E-03  -4.15190000E-04  +4.56300000E-05  +2.06229300E-01
   -7.24700000E-05  +1.29297000E-03  +3.52410000E-04  -3.19220000E-04  -7.07160000E-04
   +6.38850000E-04  +9.22100000E-05  +1.51159000E-03  +7.63490000E-04  -1.48667800E-02
   +2.76924000E-03  -5.33110000E-04  +2.43655900E-02  -7.60886100E-02  +1.72892400E-02
   -8.83488000E-03  +2.82255000E-03  -5.94710000E-04  -5.10500000E-05  +3.57190000E-04
   -1.41190000E-04  -3.71350000E-04  +1.05810000E-04  -1.06340000E-04  -1.66128230E-01
   +2.64552770E-01  -5.17270000E-04  +1.73865000E-03  -2.17207000E-03  -5.77500000E-05
   +1.20600000E-05  -2.31038000E-03  +1.06810000E-04  -2.49328000E-03  -2.10701000E-03
   +1.94538300E-02  +2.31729000E-03  -2.26370000E-04  +7.08491000E-03  +1.11436000E-03
   -4.07436100E-02  -1.86262800E-02  -2.72731000E-03  +1.59000000E-03  +9.29500000E-05
   -8.23300000E-05  +6.10420000E-04  +7.13000000E-05  -2.47820000E-04  -1.42140000E-04
   +1.65022190E-01  -1.69017420E-01  +3.73418690E-01  -1.76600000E-04  +4.18780000E-04
   -9.81600000E-04  -2.63443400E-02  +2.15992000E-03  +3.70080000E-04  -4.38460000E-04
   +7.89090000E-04  +1.05185000E-03  -6.86410000E-04  -6.94910000E-04  -4.22800000E-05
   +1.96710000E-03  +4.35150000E-04  -1.89700000E-05  -4.65800000E-04  -5.78950000E-04
   +3.18700000E-05  -1.63441070E-01  -3.12875700E-02  +4.16660000E-04  -1.12266200E-02
   -6.28132000E-03  +6.74970000E-03  -1.47688000E-03  +1.53090000E-03  +1.84570000E-04
   +5.87482790E-01  +8.54050000E-04  -6.77300000E-05  -8.54100000E-05  +1.67286400E-02
   +1.18736500E-02  -7.90900000E-05  +1.19914000E-03  -4.43160000E-04  -2.25550000E-04
   +9.97280000E-04  -9.70960000E-04  +2.10410000E-04  +1.38248000E-03  +8.36700000E-04
   -1.22160000E-04  +6.79810000E-04  -9.20460000E-04  -2.84660000E-04  -2.44592500E-02
   -8.11562500E-02  -4.00960000E-04  -1.95078900E-02  -7.50189000E-03  +2.43300000E-03
   -9.30680000E-04  -6.27790000E-04  -4.33800000E-05  +1.20490060E-01  +2.21643500E-01
   -1.19392000E-03  +6.69830000E-04  +3.00000000E-06  +1.13070000E-04  +2.76900000E-05
   -1.70833000E-03  +1.18176000E-03  -8.94000000E-04  -9.95700000E-05  +6.81550000E-04
   -2.51100000E-05  +7.74400000E-05  -1.28430000E-04  -7.61000000E-05  -5.35420000E-04
   -6.32380000E-04  +5.12100000E-05  +2.46910000E-04  +3.52070000E-04  -1.63730000E-04
   -9.25501900E-02  +2.81136500E-02  +8.43580000E-03  -2.40600000E-05  +2.44610000E-04
   +5.02100000E-05  +1.19180000E-04  -1.67910000E-04  +9.85971000E-03  +6.71936140E-01
   -1.37491000E-03  +8.37550000E-04  +4.24400000E-04  -1.06850000E-04  -1.42124000E-03
   +1.08390000E-04  +5.75700000E-05  -4.16880000E-04  -2.61200000E-05  +4.72060000E-04
   +1.19210000E-04  +1.30880000E-04  +5.47840000E-04  +2.76770000E-04  -6.37070000E-04
   -7.40400000E-04  +3.85260000E-04  -4.26000000E-05  -1.57695600E-02  -5.86384000E-03
   +2.53132000E-02  -3.87979000E-03  -4.91400000E-05  -1.52117000E-03  -9.71010000E-04
   +7.41760000E-04  +5.13860000E-04  -1.71664730E-01  -3.08880200E-02  +4.51496400E-02
   +6.63493030E-01  +9.16450000E-04  -5.44140000E-04  -1.21410000E-04  +2.09700000E-04
   -1.12572000E-03  +2.56010000E-04  +3.93000000E-06  -1.62920000E-04  -1.36700000E-05
   +8.43900000E-05  +1.60300000E-04  -2.00700000E-05  +4.13930000E-04  +1.61880000E-04
   +1.64690000E-04  +5.07600000E-04  -2.14060000E-04  -1.98090000E-04  -6.15687000E-03
   +3.33300000E-05  +6.83833000E-03  -2.10717000E-03  -5.55300000E-04  +1.89510000E-04
   -1.80310000E-04  -3.82100000E-04  -6.69300000E-05  -2.97930300E-02  -7.65828900E-02
   +9.91988000E-03  +1.59779780E-01  +1.96544130E-01  +1.37000000E-06  -8.57700000E-05
   +4.66270000E-04  -7.45760000E-04  -6.38000000E-05  +1.92640000E-04  -1.61480000E-04
   +2.81390000E-04  -2.61590000E-04  -4.08780000E-04  -1.43000000E-06  -3.21220000E-04
   +2.26550000E-04  -2.73680000E-04  +7.80320000E-04  +1.50400000E-04  +1.61340000E-04
   -3.10370000E-04  +6.21485000E-03  +2.06632000E-03  +6.95944000E-03  -2.30678000E-03
   -7.63990000E-04  -5.25800000E-05  -2.37280000E-04  +6.27950000E-04  +8.62000000E-05
   +1.12171250E-01  +3.02384200E-02  -2.66157200E-01  +3.19678300E-02  +1.87538300E-02
   +7.22441510E-01  +2.33010000E-04  -1.53910000E-04  -8.93100000E-05  +4.93600000E-05
   -1.96220000E-04  +5.34610000E-04  -1.60550000E-04  +2.93840000E-04  -2.61910000E-04
   -4.36520000E-04  +2.46200000E-05  -1.14080000E-04  -6.79250000E-04  -3.04930000E-04
   +7.99620000E-04  +2.36650000E-04  +1.05420000E-04  -1.26580000E-04  +2.95864000E-03
   -1.23267000E-03  +2.20652000E-03  -1.31107000E-03  -9.55700000E-05  -1.84140000E-04
   +6.77680000E-04  -6.60290000E-04  -1.03560000E-04  -2.35432700E-02  -7.78173000E-03
   +7.70564600E-02  -3.34249550E-01  -8.45091300E-02  -3.15902200E-02  +6.80941680E-01
   -1.65700000E-05  -3.26410000E-04  -1.04800000E-05  -9.11370000E-04  -8.23880000E-04
   +5.35650000E-04  -2.20300000E-04  +1.14780000E-04  -1.83970000E-04  -1.03200000E-04
   -2.42000000E-06  +6.40000000E-07  -8.37220000E-04  -8.18100000E-05  +4.51320000E-04
   +4.40700000E-04  -3.70100000E-05  -8.94800000E-05  -1.50599000E-03  +5.85305000E-03
   -1.47920000E-04  +6.43550000E-04  +3.03320000E-04  +8.62400000E-05  +1.36902000E-03
   -9.67050000E-04  -6.21040000E-04  -8.71996000E-03  +4.98246000E-03  +2.50789500E-02
   -8.38152800E-02  -8.60196600E-02  -1.09041900E-02  +1.69662280E-01  +1.82633410E-01
   +1.03100000E-04  -1.16500000E-05  -1.53000000E-04  -1.25940000E-04  +7.69000000E-06
   +2.23200000E-05  -6.70000000E-06  -6.83000000E-05  -1.00050000E-04  -1.19200000E-05
   +5.58000000E-06  +6.54400000E-05  +3.35190000E-04  -2.80010000E-04  -1.67820000E-04
   -3.32000000E-05  -2.68000000E-05  +2.16790000E-04  +1.26957000E-03  +4.38180000E-04
   -4.70315000E-03  +9.30190000E-04  +1.69170000E-04  +5.58700000E-05  -5.34560000E-04
   +8.76330000E-04  +3.60900000E-04  +2.72921300E-02  +8.51770000E-03  +3.99026500E-02
   +3.87646200E-02  +1.13010200E-02  -1.34092460E-01  -3.44498400E-02  -6.00010000E-04
   +7.36132600E-01  +6.75800000E-05  -1.58910000E-04  -3.40780000E-04  -4.51950000E-04
   +1.06114000E-03  +1.13800000E-05  +5.58700000E-05  -1.81220000E-04  +3.72700000E-04
   +2.82910000E-04  -1.34090000E-04  +2.02770000E-04  +4.10700000E-05  +1.46992000E-03
   +2.38300000E-05  +2.05040000E-04  -1.19370000E-04  -1.98320000E-04  -1.72213000E-03
   -7.81150000E-04  -1.19460000E-04  +5.29450000E-04  +6.43200000E-05  +4.80000000E-04
   -2.32770000E-04  -2.66484000E-03  +2.60840000E-04  +4.25814000E-03  +3.31646000E-03
   -2.07478000E-03  -2.71777300E-02  -9.10097000E-03  -2.87772700E-02  -1.55017040E-01
   -2.78647400E-02  -1.09738560E-01  +6.70859540E-01  -5.44700000E-05  +3.98200000E-05
   -3.55700000E-05  -1.31100000E-05  +6.81790000E-04  -1.47000000E-06  -8.62100000E-05
   +5.39400000E-05  +4.90400000E-05  -9.23600000E-05  -3.95000000E-05  +3.02700000E-05
   +2.08810000E-04  +2.06740000E-04  +1.70200000E-05  -9.75700000E-05  -1.86500000E-05
   -2.54500000E-05  -2.73590000E-04  -6.61240000E-04  -7.41000000E-05  +8.14900000E-05
   -2.23600000E-05  +8.69100000E-05  +4.97770000E-04  -1.35657000E-03  -2.47600000E-05
   +3.26700000E-03  -5.10104000E-03  -3.16087000E-03  -1.21407300E-02  -2.53939000E-03
   -6.99805000E-03  -2.52818600E-02  -7.85558800E-02  -3.77848700E-02  +1.53177510E-01
   +2.10822120E-01  -1.30000000E-04  +2.39400000E-05  +2.45200000E-04  -7.94800000E-05
   -3.84870000E-04  -5.58000000E-04  +2.59300000E-04  -2.56430000E-04  +1.62720000E-04
   +3.42500000E-04  -4.10400000E-05  +1.06960000E-04  +4.21210000E-04  +9.93200000E-05
   -6.51760000E-04  -2.49860000E-04  -2.26000000E-06  +8.27100000E-05  -3.12700000E-05
   +3.30010000E-04  -1.79963000E-03  +4.77030000E-04  +5.11200000E-05  +3.25300000E-05
   -7.22900000E-04  +5.25030000E-04  -1.01187000E-03  -1.41363000E-03  -2.28526000E-03
   -8.64960600E-02  -8.60775700E-02  -2.57594400E-02  +4.83427200E-02  -3.31453400E-02
   -1.39105900E-02  -2.93964440E-01  +8.10459000E-03  +1.33360700E-02  +7.25892710E-01
   -1.37850000E-04  +2.16170000E-04  +3.12790000E-04  +3.49700000E-05  -7.76460000E-04
   -6.30770000E-04  +3.85790000E-04  -3.33130000E-04  +2.55400000E-05  +4.01600000E-04
   +1.32440000E-04  +1.45840000E-04  -5.64600000E-04  -3.11000000E-04  -8.24830000E-04
   -3.82640000E-04  -1.01000000E-05  +1.49140000E-04  +2.83679000E-03  -9.55740000E-04
   -2.07769000E-03  +2.66460000E-04  +3.51170000E-04  -1.83820000E-04  +7.94700000E-05
   -1.10120000E-04  +1.25520000E-04  -2.37619900E-02  -1.17706100E-02  -7.60445500E-02
   -5.12807500E-02  -1.46936100E-02  +3.24524700E-02  +6.08241900E-02  +1.68788500E-02
   +2.31525800E-02  -1.63498860E-01  -2.80428700E-02  +3.26762800E-02  +6.60910670E-01
   -1.98960000E-04  +1.16400000E-04  +3.07940000E-04  -9.67330000E-04  -9.92230000E-04
   -5.59050000E-04  -5.92000000E-05  -5.34340000E-04  -5.74900000E-05  +8.31840000E-04
   +5.79500000E-05  +8.27000000E-05  -2.18851000E-03  -3.41990000E-04  -5.14450000E-04
   -7.67200000E-05  +8.71200000E-05  +4.51100000E-05  -1.32807000E-03  +6.07102000E-03
   -1.75300000E-04  +2.30000000E-06  +4.36700000E-05  -1.67530000E-04  +2.91809000E-03
   -2.28267000E-03  +1.49141000E-03  -9.43197000E-03  +4.07977000E-03  -2.51005000E-02
   -1.52243800E-02  -8.31184000E-03  +9.74517000E-03  +1.55453800E-02  +1.30733100E-02
   +6.44094000E-03  -2.78730600E-02  -7.59458900E-02  +5.20858000E-03  +1.63962020E-01
   +1.73870230E-01  -4.66000000E-06  +1.17240000E-04  -1.17920000E-04  +2.15050000E-04
   +3.30390000E-04  +5.70400000E-05  -1.93370000E-04  +1.44450000E-04  -1.55940000E-04
   -1.44500000E-05  +9.59000000E-06  +2.13490000E-04  -6.32750000E-04  +2.34840000E-04
   -1.69410000E-04  +6.69000000E-06  +1.83200000E-05  +6.25300000E-05  -1.00505000E-03
   -1.12025000E-03  -4.65103000E-03  +1.11676000E-03  +2.17210000E-04  -5.37900000E-04
   +9.87750000E-04  -1.03956000E-03  +3.75470000E-04  -2.59627300E-02  -7.03523000E-03
   +3.56899800E-02  +2.74601900E-02  +8.00141000E-03  -2.08094300E-02  -2.21958400E-02
   -8.26643000E-03  -5.24247800E-02  +1.12064610E-01  +2.88438900E-02  -2.90032840E-01
   +2.29778300E-02  +1.61014400E-02  +7.23146390E-01  +7.31000000E-05  -3.13480000E-04
   -1.03040000E-04  +8.93200000E-05  -8.86770000E-04  +3.32000000E-05  -1.79828000E-03
   +1.48029000E-03  -4.45850000E-04  -1.33914000E-03  +4.35230000E-04  +1.34400000E-05
   +1.14265000E-03  +3.53370000E-04  +7.97170000E-04  +4.35780000E-04  +6.06100000E-05
   -1.81500000E-04  -1.57045700E-02  -7.26774000E-03  -2.55695500E-02  -1.89553000E-03
   -1.02040000E-04  -5.36150000E-04  -1.43635000E-03  +1.13464000E-03  -1.09425000E-03
   -1.71745160E-01  -3.26688600E-02  -4.77064900E-02  +6.42439300E-02  +1.74542500E-02
   -2.53575900E-02  -5.12737800E-02  -1.55320300E-02  -3.03219900E-02  -2.34135000E-02
   -5.86660000E-03  +8.77387500E-02  -3.20839300E-01  -8.10157900E-02  -3.30034000E-02
   +6.51696930E-01  -1.51700000E-05  -1.32450000E-04  +1.96700000E-05  +2.42250000E-04
   -1.30546000E-03  -4.52750000E-04  +1.44320000E-03  -1.04745000E-03  +2.15900000E-04
   +9.67930000E-04  -2.56460000E-04  +3.57790000E-04  +4.18070000E-04  +2.33590000E-04
   -3.50020000E-04  +5.45700000E-05  +1.86060000E-04  -6.10700000E-05  -6.42127000E-03
   -6.94210000E-04  -6.85150000E-03  -2.16676000E-03  +2.77000000E-04  -4.43620000E-04
   -5.32560000E-04  -8.42290000E-04  +1.61800000E-04  -3.45026500E-02  -7.87029900E-02
   -1.65304600E-02  +1.98097400E-02  +1.41808800E-02  -1.02964100E-02  -1.69187000E-02
   -8.55644000E-03  -1.08569400E-02  -6.69251000E-03  +6.43440000E-04  +2.94132000E-02
   -8.09950100E-02  -8.41081400E-02  -1.17674500E-02  +1.57571590E-01  +1.94729060E-01
   +8.80800000E-05  -1.92780000E-04  -2.90740000E-04  +7.91650000E-04  +5.41000000E-05
   +1.21840000E-04  +1.02850000E-04  -6.32300000E-05  +6.00970000E-04  -4.92100000E-05
   -9.79300000E-05  -2.39030000E-04  -1.12750000E-04  +3.41680000E-04  +7.44490000E-04
   +3.91930000E-04  -4.27700000E-05  -3.20500000E-04  -6.24981000E-03  -2.05376000E-03
   +6.64348000E-03  -4.54370000E-04  +8.11110000E-04  +8.44330000E-04  +1.34710000E-04
   -3.80760000E-04  -4.39460000E-04  -1.13437420E-01  -3.81971700E-02  -2.69802040E-01
   +2.64654000E-02  +7.23834000E-03  -6.42405900E-02  -3.14440900E-02  -1.05190000E-02
   -2.14098000E-02  +3.14198800E-02  +1.07147900E-02  +4.40511200E-02  +3.26312500E-02
   +1.02813000E-02  -1.27856930E-01  -3.40101900E-02  -6.97170000E-04  +7.26101310E-01
   -7.58200000E-05  -3.12900000E-05  +5.12800000E-04  +3.57240000E-04  -1.56928000E-03
   -8.90000000E-07  -7.04300000E-05  -5.33100000E-05  -5.21090000E-04  -6.04000000E-05
   +2.32200000E-04  -2.24110000E-04  -1.01451000E-03  -1.72763000E-03  +3.42000000E-05
   -4.95600000E-05  +2.18320000E-04  +1.97690000E-04  +1.98253000E-03  +1.34906000E-03
   +1.17410000E-04  -1.00612000E-03  +4.01700000E-05  -5.31370000E-04  +1.19969000E-03
   +1.74528000E-03  -2.09280000E-04  -3.89413000E-03  -1.51009000E-03  +2.52255000E-03
   +5.93096000E-03  +3.80430000E-04  -1.63368000E-03  -3.99239600E-02  -1.49499300E-02
   -1.17275900E-02  -2.93744400E-01  -7.56304000E-02  +3.85214100E-02  -3.91535000E-02
   -1.28645500E-02  +5.06601000E-03  +1.76003000E-03  -2.02740000E-03  +1.24398000E-03
   +4.67606590E-01  +1.20400000E-05  -2.12800000E-05  +1.62340000E-04  +1.44300000E-04
   -5.51770000E-04  +7.28000000E-06  +1.54500000E-05  -2.91500000E-05  -1.72420000E-04
   +4.29600000E-05  +1.37220000E-04  -1.03030000E-04  -9.34610000E-04  -6.15830000E-04
   +1.58900000E-05  +3.50100000E-05  +1.25090000E-04  +8.35900000E-05  +9.22120000E-04
   -3.07220000E-04  +4.74700000E-05  -2.54740000E-04  +3.18700000E-05  -1.57810000E-04
   +9.61300000E-04  +7.84610000E-04  -7.10700000E-05  -9.95680000E-04  -1.68303000E-03
   +1.26972000E-03  +9.30980000E-04  +5.47148000E-03  -9.69960000E-04  -1.57593000E-02
   +2.40080000E-03  -4.03116000E-03  -7.48197600E-02  -6.66640100E-02  +1.15711300E-02
   -1.34563300E-02  +6.16694000E-03  +1.60195000E-03  -2.11710000E-03  +6.81625000E-03
   -1.59220000E-04  +1.31591290E-01  +6.63849800E-02  +2.10400000E-05  +3.29000000E-06
   -1.85500000E-05  +6.31000000E-06  -1.49200000E-05  +8.63000000E-06  -3.30800000E-05
   +1.01800000E-05  -3.62900000E-05  -4.35000000E-06  -8.09000000E-06  +2.72300000E-05
   -3.93000000E-05  -4.05500000E-05  -8.21400000E-05  +7.82000000E-06  +1.70900000E-05
   +3.02000000E-05  +4.09400000E-05  +2.80100000E-05  +3.87270000E-04  -4.08600000E-05
   -2.61500000E-05  -9.33100000E-05  +4.17700000E-05  +1.16300000E-05  +1.41630000E-04
   +1.76910000E-04  +2.43420000E-04  +7.50418000E-03  +6.00861000E-03  +1.58144000E-03
   -1.00581500E-02  -4.97828500E-02  -1.51403000E-02  +5.16381000E-03  -1.16880200E-02
   -4.18568000E-03  -1.12243350E-01  +4.37647900E-02  +1.34042900E-02  +2.83408000E-03
   -6.55340000E-03  -2.58282000E-03  -8.80043000E-03  +1.48863090E-01  +4.33161500E-02
   +5.85325440E-01  -2.44890000E-04  +2.71560000E-04  -1.58500000E-05  +3.94719000E-03
   +1.29008700E-02  +1.60247100E-02  -3.09938000E-03  +2.42184000E-03  -1.76530000E-03
   +6.43700000E-04  +7.52610000E-04  +6.00280000E-04  -1.33691000E-03  -5.10650000E-04
   +5.66130000E-04  +2.87950000E-04  +2.39590000E-04  +4.80690000E-04  -8.05105300E-02
   -1.18543800E-02  -1.51430500E-02  +1.63327000E-03  +2.59941000E-03  +4.69945000E-03
   +1.19920000E-03  -3.05630000E-04  -1.33510000E-04  -1.11871700E-02  -1.94662600E-02
   -2.80377400E-02  -2.16029000E-03  -2.12826000E-03  +6.78030000E-04  +2.44880000E-04
   +3.54000000E-05  -1.19136000E-03  +4.51840000E-04  +6.95600000E-05  -4.41460000E-04
   -1.26739000E-03  +4.78540000E-04  -1.04526000E-03  -4.05432000E-03  -2.11787000E-03
   +2.22664000E-03  -8.90050000E-04  -2.92430000E-04  -1.06800000E-05  +5.88070840E-01
   -5.89400000E-05  -1.47907000E-03  -2.06770000E-04  +5.50660000E-04  -2.25471600E-02
   -2.38068500E-02  +3.14604000E-03  -2.73654000E-03  +2.13445000E-03  -3.13330000E-04
   -6.49870000E-04  -6.39580000E-04  +6.65590000E-04  +3.42480000E-04  -1.15623000E-03
   +7.49200000E-05  +2.20510000E-04  -3.86990000E-04  -1.30258600E-02  -1.05837540E-01
   -4.36811900E-02  +2.66392000E-03  +1.00481100E-02  +1.30273300E-02  -4.80410000E-04
   -9.00000000E-07  +2.69090000E-04  -6.15835000E-03  -7.26501000E-03  -8.25727000E-03
   -1.17500000E-04  +2.80430000E-04  -8.92260000E-04  +3.23560000E-04  +2.35800000E-05
   -2.01080000E-04  +4.87200000E-05  -1.32300000E-05  -1.74400000E-05  -4.57300000E-05
   +3.20850000E-04  -2.10560000E-04  -1.51660000E-04  -4.57040000E-04  +7.25890000E-04
   +7.13100000E-05  +1.51200000E-05  +1.42000000E-05  -1.60525100E-02  +5.37496710E-01
   +7.68660000E-04  +1.83350000E-04  +1.98524000E-03  +3.45598000E-03  -4.94571000E-03
   -7.97470000E-04  -1.16080000E-03  +5.82000000E-04  -3.32090000E-04  +2.94190000E-04
   +1.97980000E-04  +1.78630000E-04  -3.15470000E-04  -1.06160000E-04  +5.56930000E-04
   +2.62100000E-05  +5.21100000E-05  -8.74280000E-04  -1.47831100E-02  -4.04313300E-02
   -1.40159270E-01  -4.92263000E-03  -1.29752800E-02  -3.83403100E-02  -1.10000000E-05
   +1.47640000E-04  -1.36020000E-04  -6.56369000E-03  -2.18376000E-03  +3.06550000E-04
   +6.92220000E-04  +5.80320000E-04  +1.06063000E-03  -2.40100000E-05  +7.34400000E-05
   -6.91610000E-04  -4.62360000E-04  -8.35200000E-05  +3.69800000E-04  +3.67420000E-04
   -1.02500000E-04  -3.92200000E-05  +1.51427000E-03  -1.28000000E-04  -4.44200000E-05
   +5.17230000E-04  +1.59110000E-04  -9.10800000E-05  -2.27596300E-02  -6.23115700E-02
   +5.26084490E-01  +1.11240000E-03  +1.03950000E-03  -2.25446000E-03  +2.36876000E-03
   -7.28820000E-04  -2.54180000E-04  +1.32637000E-03  +1.39389000E-03  +1.44223000E-03
   +1.41146600E-02  -1.86340000E-02  +4.30131000E-03  -1.07495300E-01  +2.12983800E-02
   -1.08674000E-03  +1.30479600E-02  -2.14801600E-02  -3.49294000E-03  -1.44670000E-03
   +2.15630000E-04  +6.28700000E-05  +6.28760000E-04  -3.08340000E-04  -3.84200000E-05
   -6.08729600E-02  +1.35340380E-01  -4.34059000E-03  -1.01792000E-03  -5.78130000E-04
   +3.91000000E-05  -3.78280000E-04  -1.81800000E-04  -2.25830000E-04  +3.31550000E-04
   +5.03060000E-04  -3.18740000E-04  +4.19500000E-04  +1.90470000E-04  -2.38160000E-04
   +2.43620000E-04  +1.27772000E-03  +4.32860000E-04  -7.17140000E-04  -5.82200000E-05
   +1.45330000E-04  +2.12340000E-04  +2.76650000E-04  +1.76300000E-05  +6.05910000E-04
   -2.91630000E-04  +2.69900000E-05  +1.21301500E-01  -9.00900000E-04  +1.85414000E-03
   -6.91486000E-03  +3.04652000E-03  +1.29300000E-04  -1.62040000E-04  -5.02810000E-04
   +1.96276000E-03  +7.25484000E-03  -2.41627000E-03  -4.32355600E-02  +9.40014000E-03
   -5.89116300E-02  -3.60662890E-01  -2.86240000E-03  -5.46178000E-03  -3.88104100E-02
   -7.99185000E-03  -9.15500000E-04  +5.32960000E-04  +7.26000000E-06  +3.82440000E-04
   -2.88070000E-04  -5.56000000E-05  +7.17722100E-02  -1.49611900E-02  +7.80871000E-03
   -3.19610000E-04  -3.08790000E-04  -3.61600000E-05  -2.60400000E-05  -1.61700000E-05
   +1.25020000E-04  +2.83960000E-04  -1.19970000E-04  +4.62590000E-04  -1.35784000E-03
   -5.04780000E-04  +5.44400000E-05  +2.99850000E-04  -3.78320000E-04  -5.08710000E-04
   +1.32380000E-04  -1.52100000E-05  -7.77600000E-05  +1.26215000E-03  +4.49960000E-04
   +2.40800000E-05  +3.74980000E-04  -2.67890000E-04  +5.49000000E-05  -5.61830800E-02
   +5.11024880E-01  -1.90932000E-03  -9.40700000E-04  -5.32197000E-03  -7.52200000E-05
   +1.28000000E-06  -3.30418000E-03  +1.53744000E-03  +7.33820000E-04  -5.29742000E-03
   +5.47727000E-03  +3.86592000E-02  +8.06828000E-03  -4.76058000E-03  +2.87434000E-03
   -1.02830880E-01  -5.02754000E-03  -3.61086800E-02  +9.57011000E-03  +3.00400000E-05
   -2.38100000E-05  +7.89180000E-04  +1.09600000E-04  -2.42810000E-04  -1.64390000E-04
   +1.09804000E-03  -5.75920000E-04  +2.52063700E-02  -1.90800000E-05  +6.73000000E-06
   +1.19690000E-04  +5.75700000E-05  -9.16000000E-06  -1.93350000E-04  -1.61520000E-04
   -2.04700000E-05  +3.00200000E-05  +7.50000000E-06  -1.48900000E-05  +1.92770000E-04
   +1.94250000E-04  +8.03000000E-06  +4.14500000E-05  -7.26800000E-05  +2.18200000E-05
   -1.73040000E-04  -7.06000000E-06  -1.90000000E-06  +3.64600000E-05  -1.02880000E-04
   +2.44610000E-04  -1.69680000E-04  -1.66848000E-03  -2.39699000E-03  +8.55192900E-02
   +3.03900000E-05  -3.51100000E-05  -3.11900000E-05  -1.27940000E-04  +9.19700000E-05
   -3.68000000E-06  +1.63200000E-05  -4.70400000E-05  +2.41500000E-05  +9.83500000E-05
   +4.37000000E-06  +4.52900000E-05  -4.09110000E-04  +2.21530000E-04  -2.68400000E-05
   +6.60000000E-05  +1.19800000E-05  -2.86600000E-05  -1.90280000E-04  -4.31600000E-05
   +1.24660000E-04  +9.49800000E-05  -3.85000000E-06  +3.97000000E-06  +4.97410000E-04
   -3.16210000E-04  +3.85900000E-05  +3.36580000E-04  +1.33280000E-04  +8.90600000E-04
   +7.64250000E-04  -3.20940000E-04  -2.05706000E-03  -6.22816000E-03  -2.49711000E-03
   +2.71626000E-03  -2.34642100E-02  -6.18284000E-03  -4.60308600E-02  +3.32483000E-03
   +1.28437000E-03  -1.15376000E-03  -8.47610000E-04  -1.73160000E-04  -5.11410000E-04
   -9.91423500E-02  -2.79923100E-02  -1.32073100E-01  +9.21100000E-05  +2.62000000E-06
   -4.99600000E-05  +2.10980000E-04  -2.96950000E-04  +7.66000000E-06  +1.25880220E-01
   +1.09700000E-05  +8.78000000E-06  -4.74900000E-05  +1.76000000E-06  +9.95200000E-05
   -1.47000000E-06  +1.51700000E-05  +9.24000000E-06  +3.47200000E-05  -4.00100000E-05
   -4.41800000E-05  +4.18400000E-05  +4.95910000E-04  +1.91610000E-04  -1.49200000E-05
   -3.74000000E-05  -5.42300000E-05  -1.70800000E-05  -7.48900000E-05  -7.06800000E-05
   +4.04900000E-05  +7.90000000E-06  -8.18000000E-06  +7.90000000E-06  -5.84750000E-04
   -1.93230000E-04  -2.55500000E-05  +7.29700000E-05  +1.37770000E-04  +2.04480000E-04
   -4.04830000E-04  +1.57620000E-03  -7.04320000E-04  -2.67429000E-03  +1.51544000E-03
   +8.48130000E-04  -6.70116000E-03  -4.83646000E-03  -1.39910600E-02  +1.28075000E-03
   -5.96290000E-04  -3.44400000E-04  -3.16700000E-05  -7.47880000E-04  -7.97800000E-05
   -2.73495300E-02  -1.16274000E-02  -3.72945800E-02  +6.73000000E-05  +5.94000000E-06
   -1.92300000E-05  -1.98540000E-04  -7.65200000E-05  -1.27200000E-05  +3.56874600E-02
   +1.48462500E-02  -2.19000000E-06  +4.59000000E-06  -3.12800000E-05  +1.30000000E-07
   +1.08720000E-04  +1.01300000E-05  -5.88000000E-06  +1.31300000E-05  +2.57300000E-05
   +4.41000000E-06  +4.47000000E-06  +8.79000000E-06  -8.06900000E-05  +7.17700000E-05
   +2.25000000E-05  +9.67000000E-06  -7.04000000E-06  -8.58000000E-06  -1.48420000E-04
   -1.06070000E-04  -7.23800000E-05  +6.05500000E-05  +1.09000000E-05  +6.16500000E-05
   +1.24930000E-04  -9.84600000E-05  -3.13500000E-05  +2.54080000E-04  +1.39420000E-04
   -1.22470000E-04  -3.46330000E-04  -1.43690000E-04  -1.89570000E-04  +1.18583000E-03
   +4.12520000E-04  +2.16354000E-03  +1.83218000E-03  +4.68130000E-04  -2.93350000E-04
   +5.23344000E-03  +1.45999000E-03  +4.00158000E-03  -9.80000000E-06  +1.41000000E-06
   -8.94650000E-04  -1.83556730E-01  -5.29811500E-02  -4.74914970E-01  +3.97700000E-05
   +1.20700000E-05  -4.67400000E-05  +3.98500000E-05  -8.13200000E-05  -2.18200000E-05
   +1.75840460E-01  +5.07059400E-02  +4.70921220E-01  +3.06000000E-06  -3.59900000E-05
   +4.69100000E-05  +1.77300000E-05  -2.16510000E-04  +4.76000000E-05  -1.60400000E-05
   -2.05400000E-05  -5.99400000E-05  +2.04500000E-05  +3.44200000E-05  -2.14300000E-05
   -2.29300000E-04  -6.39300000E-05  +6.66800000E-05  +4.19400000E-05  +1.02900000E-05
   +1.65900000E-05  +1.31710000E-04  -1.00810000E-04  +1.22359000E-03  -4.46580000E-04
   -2.51400000E-05  -1.02500000E-04  +2.52730000E-04  -6.55900000E-05  -1.20220000E-04
   -3.88538000E-03  -3.44814000E-03  -1.18280000E-03  -9.11887000E-03  -3.29629000E-03
   +2.70627400E-02  -1.21904070E-01  -2.51339300E-02  +1.18538400E-01  +1.06964000E-02
   +1.53253000E-03  -1.37405400E-02  -6.06490000E-04  -1.97561000E-03  -2.94097000E-03
   -9.70330000E-04  +3.57000000E-06  -8.48740000E-04  +8.79160000E-04  +1.34136000E-03
   +7.71110000E-04  +6.23200000E-05  +8.39600000E-05  +8.62800000E-05  +1.06610000E-04
   +3.50000000E-06  -3.34300000E-05  +4.84100000E-05  +1.89730000E-04  +2.15700000E-04
   +1.24401270E-01  +1.23800000E-05  +1.31100000E-05  +2.32000000E-06  +2.94100000E-05
   -5.18800000E-05  -4.86000000E-06  +4.22000000E-06  -1.58300000E-05  +2.98000000E-06
   -3.08300000E-05  -1.12600000E-05  -5.45000000E-06  +3.15330000E-04  +1.88200000E-05
   -4.77000000E-06  -3.35300000E-05  -4.02000000E-06  -3.81500000E-05  -2.76400000E-05
   +2.89440000E-04  +4.47560000E-04  +2.67900000E-05  +5.36300000E-05  -7.80000000E-05
   -4.09750000E-04  +1.11050000E-04  +1.62740000E-04  -3.58925000E-03  +6.41460000E-03
   -5.92440000E-04  -3.77965000E-03  +1.74554000E-03  +8.39579000E-03  -2.50775100E-02
   -4.29943200E-02  +3.38050500E-02  +1.97372000E-03  +5.65557000E-03  -5.19031000E-03
   -2.18850000E-03  +4.88303000E-03  -9.90410000E-04  +8.40800000E-05  -1.03802000E-03
   -1.06230000E-04  +1.38321000E-03  -3.02563000E-03  +3.52480000E-04  -3.60300000E-05
   -5.72000000E-06  -2.37300000E-05  -1.43380000E-04  +5.44300000E-05  +1.35500000E-05
   +1.97570000E-04  -4.70330000E-04  +7.85700000E-05  +2.92165400E-02  +3.33412500E-02
   +2.74000000E-06  +1.59000000E-05  -1.20500000E-05  -6.05000000E-06  +3.99900000E-05
   +1.88000000E-06  -1.31000000E-06  +1.02600000E-05  +1.73500000E-05  -1.86000000E-05
   -1.84400000E-05  +4.89000000E-06  +1.49380000E-04  +5.68800000E-05  +3.02000000E-06
   -3.84000000E-06  -1.84400000E-05  -1.67900000E-05  -1.97260000E-04  -4.21100000E-05
   +1.02940000E-04  +1.49800000E-05  -2.56500000E-05  +1.04500000E-05  -1.91010000E-04
   -4.01000000E-05  +9.22800000E-05  -8.37810000E-04  -2.90910000E-04  +1.88649000E-03
   -2.38875000E-03  -6.86230000E-04  +4.76205000E-03  +1.17219100E-01  +3.27816600E-02
   -2.76811300E-01  +1.75228900E-02  +5.05315000E-03  -1.89486300E-02  -3.54909000E-03
   -1.23242000E-03  -3.44236000E-03  -1.17424000E-03  -3.62410000E-04  +1.90350000E-04
   +4.55400000E-04  +2.17450000E-04  +1.94043000E-03  +6.63000000E-05  -1.69900000E-05
   +4.20000000E-06  -4.99900000E-05  -2.18600000E-05  +3.14000000E-06  +1.11100000E-04
   +3.79700000E-05  +3.77330000E-04  -1.28140460E-01  -3.59035500E-02  +2.90073560E-01
   -1.55510000E-04  +3.61560000E-04  +2.52350000E-04  -2.40370000E-04  -1.20840000E-04
   +1.39660000E-04  +7.10200000E-05  +8.55000000E-06  -1.23100000E-05  -3.70100000E-05
   -2.38900000E-05  -3.81700000E-05  +1.63110000E-04  +1.17050000E-04  +1.52150000E-04
   -1.19860000E-04  -1.87200000E-05  -9.08700000E-05  -2.77730000E-04  +1.16025000E-03
   -4.32620000E-04  +2.86930000E-04  -1.30180000E-04  -1.32970000E-04  -1.59970000E-04
   +2.53900000E-05  -2.68400000E-05  +1.17324900E-02  +2.39026000E-03  +1.25537900E-02
   -1.14259510E-01  -2.43492800E-02  -1.12066580E-01  -1.02739800E-02  -4.88327000E-03
   -2.81524300E-02  -3.72233000E-03  -3.68803000E-03  +1.26511000E-03  -8.77560000E-04
   +9.48800000E-05  +6.99070000E-04  -4.70090000E-04  -2.09029000E-03  +3.47303000E-03
   -7.03290000E-04  -2.26560000E-04  -1.51675000E-03  -2.38568000E-03  -1.43024000E-03
   +9.62510000E-04  -8.32300000E-05  -1.11500000E-04  -3.11100000E-05  -4.10070000E-04
   -7.62800000E-05  -3.39800000E-05  +3.96510000E-04  +1.55215000E-03  +2.70050000E-04
   +1.23410550E-01  +2.10370000E-04  +5.09000000E-06  -5.26800000E-05  +3.91080000E-04
   +6.17140000E-04  -3.25960000E-04  +8.79600000E-05  -1.87500000E-05  +1.20130000E-04
   +7.60000000E-06  -4.38400000E-05  +4.01000000E-05  -9.02400000E-05  -1.33070000E-04
   -4.13550000E-04  -1.71160000E-04  +1.69900000E-05  +7.80200000E-05  +1.41578000E-03
   -3.08535000E-03  -5.49300000E-05  -3.24960000E-04  -2.56240000E-04  -1.02400000E-04
   +3.57000000E-05  +1.53000000E-06  +1.54630000E-04  +1.68602000E-03  +4.84113000E-03
   +3.22318000E-03  -2.46004300E-02  -4.80739100E-02  -3.75213500E-02  -4.45131000E-03
   +3.28970000E-03  -8.57932000E-03  -3.73878000E-03  +7.31060000E-03  +4.27000000E-05
   -5.35000000E-05  -1.17762000E-03  +3.71040000E-04  -1.94250000E-03  +5.92966000E-03
   +1.06682000E-03  -2.24150000E-04  -1.43580000E-04  -4.86050000E-04  -1.32575000E-03
   -5.38110000E-04  +5.08130000E-04  +2.80600000E-05  +6.93200000E-05  +1.12920000E-04
   -6.09900000E-05  -2.77680000E-04  -4.73000000E-06  +1.58602000E-03  -4.20982000E-03
   +1.50880000E-04  +3.23337400E-02  +3.70829300E-02  +4.06200000E-05  +2.26340000E-04
   -1.97400000E-05  +1.19470000E-04  +1.91890000E-04  -1.91520000E-04  -6.47000000E-05
   -1.69100000E-05  +1.11100000E-05  +1.13040000E-04  +1.31000000E-06  +1.01970000E-04
   -4.14430000E-04  -2.10440000E-04  -5.27130000E-04  -3.02950000E-04  +5.55700000E-05
   +3.00150000E-04  -1.51227000E-03  -7.87070000E-04  -4.43870000E-04  +1.21610000E-04
   +5.85900000E-05  +1.45490000E-04  +3.75760000E-04  -1.47360000E-04  +1.16110000E-04
   -1.42303600E-02  -4.73999000E-03  -1.82898400E-02  -1.11928400E-01  -3.74366500E-02
   -2.81893780E-01  +2.12085000E-03  +7.17420000E-04  +3.32622000E-03  +1.12535000E-03
   +3.18570000E-04  +1.78713000E-03  +7.84710000E-04  +2.56780000E-04  +4.38380000E-04
   +3.77959000E-03  +9.68630000E-04  -3.86372000E-03  -3.19260000E-04  -1.09450000E-04
   -2.52500000E-05  -1.33088000E-03  -2.27900000E-05  -3.22100000E-04  +1.99650000E-04
   +9.78300000E-05  +1.17100000E-04  +8.21300000E-05  +2.84500000E-05  +5.51400000E-05
   -1.85020000E-04  -3.29000000E-06  +8.94530000E-04  +1.22688270E-01  +4.13348600E-02
   +2.96798270E-01  +6.78300000E-05  +1.44400000E-05  +1.42100000E-05  -2.46930000E-04
   -1.31250000E-04  -1.45690000E-04  -4.45830000E-04  +6.46390000E-04  -4.25530000E-04
   -3.07130000E-04  +2.79700000E-05  +2.52100000E-05  +9.06900000E-05  +8.98800000E-05
   -1.09740000E-04  -1.83400000E-05  -2.68900000E-05  +2.99500000E-05  -3.72100000E-04
   +1.19672000E-03  +2.81510000E-04  -2.35061000E-03  -1.51000000E-03  -9.88900000E-04
   -1.28200000E-04  -2.17700000E-05  +4.54500000E-05  +1.17448000E-02  +2.22682000E-03
   -1.21443600E-02  -3.46080000E-04  -2.31574000E-03  -3.34286000E-03  -8.06100000E-04
   +1.11200000E-04  -7.19180000E-04  -3.82770000E-03  -3.61383000E-03  -1.51247000E-03
   -1.04037500E-02  -3.73504000E-03  +2.80216300E-02  -1.14561300E-01  -2.21015400E-02
   +1.12905870E-01  -1.21943000E-03  -3.68230000E-04  +1.43730000E-03  +2.75190000E-04
   -1.15770000E-04  +1.22410000E-04  -5.86200000E-05  -9.66400000E-05  +2.29700000E-05
   +2.23620000E-04  +7.38000000E-05  +1.80640000E-04  -3.96200000E-05  +2.11440000E-04
   +5.70700000E-05  +4.89770000E-04  +1.49760000E-04  -7.83880000E-04  +1.23963330E-01
   +6.92900000E-05  -3.15700000E-05  -1.25070000E-04  +4.12740000E-04  +6.48340000E-04
   +3.17250000E-04  +4.41330000E-04  -1.25900000E-04  +1.38590000E-04  -2.07450000E-04
   +3.44200000E-05  -5.93700000E-05  -9.49700000E-05  -1.41660000E-04  +4.21770000E-04
   +2.48900000E-05  -3.71100000E-05  -3.67000000E-05  +1.53253000E-03  -3.17757000E-03
   +1.39790000E-04  -1.29411000E-03  -5.65400000E-04  -5.08520000E-04  +1.21150000E-04
   -5.58200000E-05  -1.51490000E-04  +2.45712000E-03  +4.79165000E-03  -4.43432000E-03
   -2.38402000E-03  +5.94354000E-03  -1.37631000E-03  +4.97600000E-05  -1.19744000E-03
   -1.98730000E-04  -3.62198000E-03  +6.51622000E-03  -5.04800000E-04  -4.40973000E-03
   +2.66949000E-03  +8.73947000E-03  -2.20760000E-02  -4.51092900E-02  +3.10152800E-02
   -3.84840000E-04  -8.01100000E-05  +4.46190000E-04  -3.21270000E-04  -2.68050000E-04
   +1.20910000E-04  +3.04900000E-05  +6.91300000E-05  -1.13570000E-04  +7.99900000E-05
   -2.04200000E-05  +5.88600000E-05  +2.08320000E-04  -6.37600000E-04  +3.03000000E-05
   +2.20470000E-04  +1.20280000E-04  -2.78510000E-04  +2.89843800E-02  +3.52283600E-02
   +5.58400000E-05  +1.27600000E-05  +2.96400000E-05  -1.46620000E-04  -2.20870000E-04
   -2.15800000E-04  -2.68200000E-05  -2.72240000E-04  -3.34100000E-05  +3.66340000E-04
   -9.12100000E-05  +3.49430000E-04  +4.31960000E-04  +2.19610000E-04  -6.04310000E-04
   -9.23800000E-05  +1.04700000E-05  +1.07490000E-04  +1.47960000E-03  +8.39640000E-04
   -3.20140000E-04  +1.20547000E-03  +1.19290000E-04  -1.84000000E-04  -4.54580000E-04
   +1.28460000E-04  +1.48970000E-04  +1.45471300E-02  +4.17850000E-03  -1.82702900E-02
   -3.78925000E-03  -1.35239000E-03  -3.86198000E-03  -8.73280000E-04  -2.11400000E-04
   +3.40920000E-04  -9.71910000E-04  -4.08810000E-04  +1.95229000E-03  -2.13723000E-03
   -6.58160000E-04  +3.14757000E-03  +1.12591980E-01  +3.06638400E-02  -2.82782610E-01
   +2.12920000E-04  +7.64900000E-05  +1.02800000E-05  -1.22570000E-04  -3.71400000E-05
   +1.41190000E-04  -2.06820000E-04  -1.07350000E-04  +1.31740000E-04  -5.22600000E-05
   -1.99200000E-05  -3.59300000E-05  +9.65800000E-05  +3.47500000E-05  -2.02000000E-05
   +8.22120000E-04  +2.19970000E-04  -1.08838000E-03  -1.23615430E-01  -3.37728300E-02
   +2.97856950E-01  -1.91800000E-05  -5.73000000E-06  +7.59400000E-05  +5.93300000E-05
   -2.37750000E-04  -4.28900000E-05  -9.48000000E-06  -3.57500000E-05  -6.34900000E-05
   +5.60700000E-05  +1.28700000E-05  -3.81400000E-05  -2.70150000E-04  -1.44640000E-04
   -5.74100000E-05  +6.27000000E-06  +4.17000000E-05  +3.43000000E-05  +2.48620000E-04
   -2.12820000E-04  -1.33613000E-03  +2.61100000E-05  +8.67600000E-05  -8.38200000E-05
   +2.55760000E-04  +7.18900000E-05  +1.02900000E-04  -4.10787000E-03  -3.33805000E-03
   +1.29808000E-03  -1.19143000E-03  -4.88600000E-05  +8.47390000E-04  -1.76330000E-04
   -1.65474000E-03  +3.36882000E-03  +7.72151000E-03  +1.31360000E-03  +1.33844200E-02
   -1.15812330E-01  -2.65437300E-02  -1.10046750E-01  -9.30142000E-03  -3.59214000E-03
   -2.81556600E-02  +3.12297000E-03  +2.13713000E-03  +6.60420000E-04  -5.23720000E-04
   -2.21200000E-05  +1.21020000E-04  +1.20570000E-04  +5.39800000E-05  +3.74900000E-05
   -4.57440000E-04  -2.99090000E-04  -8.72220000E-04  +4.73960000E-04  +1.84600000E-04
   +6.44350000E-04  -3.63500000E-05  +1.93090000E-04  -1.09970000E-04  +4.10160000E-04
   +1.44366000E-03  +1.91280000E-04  +1.19868430E-01  +2.26000000E-06  -2.50300000E-05
   -7.42000000E-06  +2.71700000E-05  -9.35400000E-05  +2.97000000E-06  +2.37600000E-05
   +1.78100000E-05  +1.12000000E-06  -7.30200000E-05  -1.02200000E-05  +4.02300000E-05
   +4.16160000E-04  +3.37600000E-05  +7.15000000E-06  -2.33300000E-05  -1.40700000E-05
   +3.91000000E-06  -1.00000000E-04  +4.29990000E-04  -4.95790000E-04  -2.02200000E-05
   +7.14000000E-06  +2.86400000E-05  -4.74800000E-04  +1.03890000E-04  -1.80940000E-04
   -3.69153000E-03  +5.88502000E-03  +6.17230000E-04  +1.15640000E-04  -9.30390000E-04
   +2.83030000E-04  -1.55184000E-03  +5.15494000E-03  +6.93830000E-04  +1.05872000E-03
   +3.99397000E-03  +3.31163000E-03  -2.60063000E-02  -4.04074700E-02  -3.52288300E-02
   -3.87457000E-03  +6.98130000E-04  -9.16459000E-03  +1.80221000E-03  -3.37405000E-03
   +2.23950000E-04  +3.11100000E-05  +5.09800000E-05  +8.25300000E-05  -2.02490000E-04
   +8.68000000E-05  -1.60400000E-05  -2.43890000E-04  +4.95220000E-04  -1.99330000E-04
   +1.09500000E-04  +9.09000000E-06  +1.43560000E-04  +1.97390000E-04  -6.33180000E-04
   -1.93500000E-05  +1.46189000E-03  -3.88447000E-03  +1.52030000E-04  +3.05966700E-02
   +3.27816200E-02  -2.11000000E-06  -4.98000000E-06  +2.73800000E-05  +2.53600000E-05
   -6.26900000E-05  +1.91000000E-06  -8.24000000E-06  -1.65900000E-05  -1.88800000E-05
   +1.40200000E-05  +2.23600000E-05  -3.46200000E-05  -1.88470000E-04  -1.14150000E-04
   +5.73000000E-06  +1.32600000E-05  +2.64700000E-05  +1.12900000E-05  +2.38660000E-04
   +3.13200000E-05  +9.86000000E-06  -8.20300000E-05  +2.33400000E-05  +4.90000000E-06
   +1.85610000E-04  +1.40680000E-04  +7.01000000E-05  +6.35190000E-04  +2.12740000E-04
   +2.20939000E-03  +1.25221000E-03  +4.21550000E-04  +1.04670000E-04  +3.99995000E-03
   +1.03406000E-03  -3.69120000E-03  -1.87272400E-02  -5.77597000E-03  -1.84470300E-02
   -1.10068270E-01  -3.60331300E-02  -2.70600890E-01  +1.73633000E-03  +5.45320000E-04
   +3.43952000E-03  -2.69100000E-05  +2.37600000E-05  +2.72475000E-03  -6.11500000E-05
   +2.91700000E-05  +1.80600000E-05  +6.73800000E-05  +5.77400000E-05  +7.29000000E-06
   +2.03723000E-03  +5.73500000E-04  -1.03309000E-03  -8.17990000E-04  -2.95710000E-04
   -1.03593000E-03  -6.24500000E-05  -9.67000000E-06  -3.96700000E-05  -2.55620000E-04
   -4.98000000E-05  +9.28800000E-04  +1.20350230E-01  +3.93519400E-02  +2.85594860E-01
   +4.19000000E-05  -1.88120000E-04  -1.78710000E-04  -9.51140000E-04  -1.55241000E-03
   -1.45659000E-03  +4.27650000E-04  -3.50990000E-04  +7.28900000E-05  -2.07200000E-05
   -1.12180000E-04  -1.21800000E-05  +2.81300000E-05  -3.97400000E-05  -1.89580000E-04
   +3.27300000E-05  +4.64900000E-05  +4.73700000E-05  +3.31682000E-03  -7.06489000E-03
   -8.90080000E-04  -2.03200000E-05  -1.29990000E-04  +8.03300000E-05  -1.32900000E-05
   +5.43700000E-05  +4.31700000E-05  +6.76450000E-04  -8.68560000E-04  -3.51700000E-05
   -9.39900000E-05  -7.05900000E-05  -1.11530000E-04  +1.51000000E-05  +7.65000000E-05
   +9.17900000E-05  -1.11360000E-04  -4.90100000E-05  -1.11300000E-05  +5.10100000E-05
   +2.50400000E-05  +6.57000000E-06  +1.72700000E-04  +1.00630000E-04  -3.03700000E-05
   +1.63830000E-04  +4.37700000E-05  +1.55800000E-05  -1.41853860E-01  +1.29906530E-01
   -1.04887000E-03  -1.18200000E-05  +5.45800000E-05  +3.71500000E-05  -1.73300000E-05
   -5.08000000E-06  -1.00800000E-05  +1.01800000E-05  -1.42000000E-06  -2.41000000E-06
   +1.38970000E-04  -7.62900000E-05  +1.53300000E-04  +1.44900000E-05  -1.19600000E-05
   +2.84300000E-05  +2.22200000E-05  +1.68900000E-05  +9.45000000E-06  +1.50510340E-01
   +1.70570000E-04  +3.16710000E-04  -2.86340000E-04  -2.01602000E-03  -1.21768000E-03
   -3.03798000E-03  +8.56540000E-04  -5.83280000E-04  +5.36880000E-04  -1.74910000E-04
   -1.43890000E-04  -2.85070000E-04  +5.86890000E-04  +2.54840000E-04  -2.67900000E-05
   -4.10500000E-05  -8.59300000E-05  -1.14180000E-04  +1.07637200E-02  -1.69160800E-02
   -1.58680000E-04  +9.53800000E-05  +4.50640000E-04  +1.40943000E-03  -5.00120000E-04
   +1.31560000E-04  +1.80000000E-05  +1.01337000E-03  +6.18420000E-04  +4.72470000E-04
   -1.70560000E-04  +2.05400000E-04  -4.51000000E-06  -3.61000000E-04  +9.48000000E-06
   -1.81000000E-06  -1.20730000E-04  -7.68900000E-05  +2.80180000E-04  +3.41430000E-04
   +1.18330000E-04  -8.87400000E-05  -5.74620000E-04  +8.39000000E-06  -3.21680000E-04
   +1.46930000E-04  +6.36800000E-05  -5.10000000E-06  +1.28570930E-01  -2.20442980E-01
   +2.87808000E-03  -2.68490000E-04  -2.00970000E-04  -2.72000000E-06  -1.70700000E-05
   -2.71600000E-05  -8.40000000E-06  -9.25000000E-06  -2.39700000E-05  -6.02000000E-06
   +2.54330000E-04  -3.04070000E-04  +1.70930000E-04  +2.02000000E-06  -1.81600000E-05
   +4.76400000E-05  +2.04300000E-05  -4.06800000E-05  +6.84000000E-06  -1.40750280E-01
   +2.39170050E-01  -4.41780000E-04  +6.69100000E-04  -9.34550000E-04  -1.39097000E-03
   -2.45567000E-03  -4.51418000E-03  +1.09724000E-03  -8.55050000E-04  +8.19090000E-04
   -1.59190000E-04  -3.13380000E-04  -1.41560000E-04  +4.23320000E-04  +1.88740000E-04
   -6.20290000E-04  -6.93300000E-05  -5.20700000E-05  +4.35030000E-04  +1.52877600E-02
   -2.14975500E-02  -1.56226000E-03  +7.51710000E-04  -1.11591000E-03  +8.42040000E-04
   -2.22480000E-04  +6.56000000E-06  +1.48390000E-04  +6.86740000E-04  +6.26580000E-04
   +9.33630000E-04  +5.48900000E-05  -1.71400000E-04  +3.12130000E-04  -6.49800000E-05
   -8.57000000E-05  -3.77600000E-05  -8.45600000E-05  +2.91000000E-05  +1.79860000E-04
   +1.59670000E-04  +1.65000000E-05  -1.17660000E-04  -1.68220000E-04  +2.37480000E-04
   -2.06030000E-04  +1.16230000E-04  +4.67200000E-05  -2.76000000E-05  -1.98529000E-03
   +3.96626000E-03  -4.64953400E-02  -1.25650000E-04  -7.80000000E-05  +1.51970000E-04
   -1.17800000E-05  -1.15000000E-05  -6.59000000E-06  +1.43300000E-05  -1.91300000E-05
   -6.50000000E-06  -3.15850000E-04  +7.37400000E-05  -1.88520000E-04  -1.85000000E-05
   -4.59000000E-05  -2.33400000E-05  +2.74900000E-05  -3.32400000E-05  +2.90000000E-06
   +3.37934000E-03  -4.70970000E-04  +5.16003000E-02  +2.92200000E-05  -1.16920000E-04
   -1.14420000E-04  -7.96230000E-04  -4.74300000E-05  -3.66110000E-04  -2.05000000E-06
   -1.86820000E-04  +1.12910000E-04  +2.31900000E-05  +1.98000000E-06  -6.16300000E-05
   -1.34170000E-04  +5.92800000E-05  -1.22700000E-05  +4.45800000E-05  +4.56000000E-06
   +2.50200000E-05  -6.17332000E-03  -2.09733000E-03  +1.84120000E-04  +2.66640000E-04
   +2.62900000E-04  +9.92300000E-04  +1.48320000E-04  -1.22680000E-04  -3.40000000E-06
   +4.42050000E-04  -6.46850000E-04  -1.21442000E-03  +1.47790000E-04  +2.41000000E-05
   -1.16870000E-04  +1.53530000E-04  -3.59200000E-05  -3.94600000E-05  +2.67410000E-04
   +4.90900000E-05  -2.09980000E-04  -3.03050000E-04  -3.79100000E-05  -1.37500000E-05
   +1.31860000E-04  -2.19250000E-04  +5.31100000E-04  -3.19790000E-04  -8.96800000E-05
   +7.10000000E-07  -2.97010520E-01  -7.90048100E-02  +1.09405000E-02  +8.04400000E-05
   -6.07800000E-05  +8.78000000E-06  +3.81200000E-05  +1.88600000E-05  +1.92800000E-05
   -1.84400000E-05  -6.44000000E-06  +9.96000000E-06  -5.85000000E-05  +1.59540000E-04
   -1.60380000E-04  +2.40300000E-05  -1.28800000E-05  -9.13300000E-05  -6.66900000E-05
   +2.05800000E-05  -7.61000000E-06  -1.55785600E-02  -6.25846000E-03  +1.14467000E-03
   +3.20896810E-01  +2.71390000E-04  -1.59570000E-04  -9.02300000E-05  -2.10718000E-03
   -3.95600000E-04  +1.47770000E-04  +2.07620000E-04  +7.43200000E-05  -1.04530000E-04
   +7.00200000E-05  +1.24210000E-04  +8.36200000E-05  -2.99140000E-04  -6.59900000E-05
   +4.30700000E-05  +8.40900000E-05  +1.09400000E-04  +5.91900000E-05  -1.83623300E-02
   -6.54282000E-03  +1.11874000E-03  +2.24910000E-04  +2.75750000E-04  +1.32801000E-03
   +3.02050000E-04  -1.10720000E-04  -2.18300000E-05  -4.28000000E-06  -1.28835000E-03
   -2.98438000E-03  -4.40200000E-05  +1.94930000E-04  -8.33700000E-05  -1.79870000E-04
   -7.47700000E-05  -2.33700000E-04  +1.35500000E-04  -1.60100000E-05  +9.53200000E-05
   -7.37400000E-05  +5.33200000E-05  -3.05070000E-04  -1.00561000E-03  -3.36360000E-04
   +2.91670000E-04  -2.35040000E-04  -6.78000000E-05  -2.74300000E-05  -7.63853500E-02
   -7.11033200E-02  +4.29693000E-03  +1.66410000E-04  +6.38100000E-05  +5.14000000E-06
   +1.94600000E-05  +1.59100000E-05  +1.13900000E-05  -3.14400000E-05  +6.00000000E-07
   +1.34900000E-05  +2.61380000E-04  +4.79700000E-05  -2.12720000E-04  +3.47700000E-05
   -1.23300000E-05  -6.29000000E-05  -1.08950000E-04  -1.34000000E-05  -1.54600000E-05
   +2.53883700E-02  +9.54489000E-03  -1.54139000E-03  +8.57841800E-02  +7.40729300E-02
   +9.54500000E-05  -3.86400000E-05  +1.32810000E-04  -5.12140000E-04  +1.27630000E-04
   +7.25940000E-04  -2.70900000E-05  +1.31650000E-04  -3.58200000E-05  +3.91700000E-05
   +6.22600000E-05  +1.23100000E-05  -1.23530000E-04  -9.65100000E-05  +1.72000000E-05
   -1.34400000E-05  +1.02000000E-05  -7.36900000E-05  -2.54230600E-02  -7.14703000E-03
   +1.43900000E-05  -1.63483000E-03  -6.33940000E-04  +8.74320000E-04  +1.51820000E-04
   -3.27000000E-05  +5.56000000E-06  +3.95570000E-04  -2.76195000E-03  -4.66646000E-03
   +3.67400000E-04  +4.48380000E-04  -9.82290000E-04  +2.15300000E-05  +8.99100000E-05
   +4.28420000E-04  +2.71920000E-04  -4.27000000E-06  -2.69720000E-04  -3.51880000E-04
   +1.95820000E-04  -1.31320000E-04  -1.14102000E-03  -5.98250000E-04  +5.10100000E-04
   -2.37620000E-04  -9.61300000E-05  +8.40900000E-05  +1.36010800E-02  +5.61531000E-03
   -4.80145400E-02  +6.19500000E-05  +3.51100000E-05  -1.66500000E-05  +3.37900000E-05
   +1.79800000E-05  +1.80500000E-05  -3.99000000E-05  +6.93000000E-06  +1.12000000E-06
   +5.78800000E-05  -6.42800000E-05  +6.73960000E-04  +4.27500000E-05  -1.30670000E-04
   +6.07000000E-06  -1.42170000E-04  +4.57000000E-06  -8.39000000E-06  -1.05792000E-03
   -2.27130000E-04  -1.15521000E-03  -1.28698300E-02  -2.36319000E-03  +5.38029200E-02
   +2.77600000E-04  +5.40550000E-04  +6.59340000E-04  +3.10520000E-04  -1.49490000E-04
   +7.26410000E-04  -2.86500000E-05  +1.61220000E-04  -7.47100000E-05  -5.77800000E-05
   -2.90200000E-05  -2.00800000E-05  +2.51430000E-04  +6.60300000E-05  +2.38420000E-04
   -1.64120000E-04  -1.65970000E-04  -3.48290000E-04  -4.82440000E-04  +4.84202000E-03
   -5.23455000E-03  -3.94100000E-04  -8.09380000E-04  -8.28870000E-04  -3.01120000E-04
   +1.42310000E-04  -3.52000000E-05  +3.25450000E-04  +5.53930000E-04  +4.74110000E-04
   -7.61090000E-04  -3.53160000E-04  -1.14393000E-03  -1.80100000E-05  +3.74800000E-05
   +2.76310000E-04  -1.04150000E-04  -3.11800000E-05  +2.26200000E-05  +1.82770000E-04
   +7.46300000E-05  +6.77000000E-05  -1.54270000E-04  -6.76000000E-06  +2.47700000E-05
   +1.66670000E-04  +5.27500000E-05  +4.77300000E-05  -5.11126500E-02  -1.88993000E-02
   +3.31582200E-02  -1.55050000E-04  -6.55600000E-05  -7.53200000E-05  -1.67500000E-05
   -1.19000000E-05  -4.44000000E-06  -1.73000000E-05  -1.42900000E-05  -1.21400000E-05
   -2.35822000E-03  -1.61343000E-03  -3.70740000E-04  +3.85000000E-05  +2.97000000E-05
   +8.39600000E-05  +2.05200000E-05  -7.53000000E-06  +1.43500000E-05  +2.70972000E-03
   +9.03398000E-03  -1.76096000E-02  -2.32283000E-03  -1.55090500E-02  +2.71952800E-02
   +5.30670400E-02  +8.60740000E-04  -2.02790000E-03  -1.16540000E-04  +2.42500000E-04
   +1.17685000E-03  +5.46490000E-04  -2.37270000E-04  +7.80500000E-05  +4.64800000E-05
   +6.27400000E-05  +2.98000000E-05  +5.83800000E-05  -3.02840000E-04  -1.58510000E-04
   -2.39500000E-04  -8.71600000E-05  +6.24200000E-05  +9.23800000E-05  +4.00622000E-03
   +1.08878900E-02  -1.62326100E-02  -7.99970000E-04  -1.95945000E-03  -2.53867000E-03
   +1.77870000E-04  -1.66800000E-05  +4.59000000E-05  +1.27000000E-04  +5.48800000E-04
   +8.52790000E-04  -6.33750000E-04  -5.77920000E-04  +4.77910000E-04  -6.63200000E-05
   -5.76900000E-05  -2.53240000E-04  -1.01800000E-04  +5.67500000E-05  +1.76820000E-04
   +1.05090000E-04  -2.19700000E-05  -5.54200000E-05  +3.48000000E-05  +7.14300000E-05
   -1.30990000E-04  +3.73700000E-05  +4.26000000E-06  -4.58100000E-05  -1.82940600E-02
   -1.11095630E-01  +1.14478240E-01  +1.15760000E-04  +1.24260000E-04  +5.86100000E-05
   -1.39400000E-05  -3.86000000E-06  -5.97000000E-06  +9.37000000E-06  -1.38200000E-05
   +6.78000000E-06  -1.86724000E-03  -1.15370000E-04  -6.49880000E-04  +2.50200000E-05
   +2.54300000E-05  +1.88000000E-06  +1.21100000E-05  -4.47000000E-06  -7.88000000E-06
   -5.35680000E-03  -1.21482600E-02  +2.20995300E-02  -1.42570000E-04  -5.22520000E-03
   +7.32615000E-03  +2.10665100E-02  +1.21962170E-01  -4.29110000E-04  +5.09580000E-04
   -6.48180000E-04  -1.74360000E-04  +1.02822000E-03  -2.41030000E-04  +6.88100000E-05
   +9.93200000E-05  +1.80790000E-04  -1.05300000E-05  -1.29970000E-04  +1.90990000E-04
   +1.15740000E-04  -7.46400000E-05  -7.55420000E-04  -6.43600000E-05  +4.56700000E-05
   +7.28720000E-04  +4.21853000E-03  +1.40653600E-02  -1.92776600E-02  -1.43830000E-03
   -4.57863000E-03  -4.27253000E-03  +4.34500000E-05  -1.21900000E-05  +1.99180000E-04
   +1.20596000E-03  +3.72700000E-04  +2.26160000E-04  +7.25720000E-04  +4.25920000E-04
   -1.07402000E-03  -1.32950000E-04  +4.65700000E-05  +7.94600000E-04  +1.37930000E-04
   +3.89900000E-05  -1.63400000E-05  +1.46910000E-04  +6.81100000E-05  +1.23850000E-04
   -2.94110000E-04  -1.22540000E-04  -7.40100000E-05  +2.89000000E-06  -1.84800000E-05
   +1.09910000E-04  +3.19291200E-02  +1.11827050E-01  -2.51206990E-01  -8.30000000E-07
   +9.64300000E-05  +1.99270000E-04  +1.61500000E-05  +8.22000000E-06  +1.03000000E-06
   -4.53600000E-05  +1.61000000E-06  -2.00500000E-05  -8.12700000E-05  -9.94700000E-05
   +1.69817000E-03  +1.32400000E-04  +1.09260000E-04  +1.30950000E-04  -1.68500000E-05
   -8.52000000E-06  +6.70000000E-07  -7.72300000E-05  -5.11240000E-04  +4.96280000E-04
   -7.09000000E-06  +2.94710000E-04  -6.05080000E-04  -3.63007300E-02  -1.24463080E-01
   +2.72477490E-01  -9.17000000E-06  -1.79210000E-04  -1.10650000E-04  -7.26390000E-04
   -6.42400000E-05  +3.89790000E-04  +1.97200000E-05  -1.06140000E-04  +1.00640000E-04
   +5.06900000E-05  +3.51000000E-06  -1.22900000E-05  -1.24180000E-04  +5.68800000E-05
   +1.75000000E-06  +1.64900000E-05  +1.80000000E-06  +6.72300000E-05  -5.83042000E-03
   -2.03145000E-03  -1.45220000E-04  -2.95267340E-01  -8.27482600E-02  -1.03690400E-02
   +1.39310000E-04  -1.23610000E-04  -3.74000000E-06  +3.91480000E-04  -6.59060000E-04
   +1.18377000E-03  +1.69970000E-04  -2.25960000E-04  -5.51330000E-04  -2.95290000E-04
   -1.49400000E-05  -1.50400000E-05  +2.84570000E-04  +6.14200000E-05  +2.09980000E-04
   +1.42200000E-04  -5.22700000E-05  +3.89700000E-05  +1.67970000E-04  +2.30800000E-05
   +1.69910000E-04  -3.43450000E-04  -8.51500000E-05  -1.89100000E-05  +3.12790000E-04
   +2.92140000E-04  -1.01833000E-03  +7.49800000E-05  -6.32900000E-05  -4.50000000E-06
   +4.09300000E-05  +9.44000000E-06  +2.07300000E-05  -5.21300000E-05  +2.08100000E-05
   -9.50000000E-07  +2.30800000E-05  -6.81000000E-06  +9.58600000E-05  -5.83800000E-05
   +1.64420000E-04  +1.22760000E-04  -2.99500000E-05  -4.79000000E-06  -1.78600000E-05
   -1.54840000E-04  -8.24900000E-05  +6.22800000E-05  +5.94470000E-04  +1.81730000E-04
   +2.99730000E-04  +3.87760000E-04  +1.27660000E-04  -1.10750000E-04  +3.18957070E-01
   +2.55340000E-04  +9.48100000E-05  +1.00320000E-04  -2.14170000E-03  -3.90860000E-04
   -1.14700000E-04  +2.74150000E-04  -1.87600000E-04  +3.82400000E-05  +1.02390000E-04
   +9.91100000E-05  -2.55200000E-05  -3.01960000E-04  -6.63100000E-05  -5.98700000E-05
   +3.64500000E-05  +1.13460000E-04  -7.70900000E-05  -1.81717500E-02  -6.74020000E-03
   -1.13076000E-03  -7.99554500E-02  -7.36067100E-02  -4.20299000E-03  +2.90830000E-04
   -1.18890000E-04  +1.16100000E-05  -6.52000000E-06  -1.26278000E-03  +2.97639000E-03
   -9.73310000E-04  -3.40170000E-04  -3.14740000E-04  -7.64200000E-05  +8.95300000E-05
   +3.07230000E-04  +1.37390000E-04  -3.17400000E-05  -8.60800000E-05  -1.59630000E-04
   -9.54300000E-05  +2.15650000E-04  -6.77300000E-05  +1.99890000E-04  +1.32610000E-04
   -2.40500000E-04  -5.25700000E-05  +1.54800000E-05  +1.76170000E-04  +3.16460000E-04
   -1.36863000E-03  +1.63260000E-04  +5.97100000E-05  +1.00000000E-06  +2.96900000E-05
   +8.12000000E-06  +9.20000000E-06  -9.42900000E-05  -8.73000000E-06  +3.46000000E-06
   +3.53500000E-05  -1.13600000E-05  +6.09200000E-05  +2.66220000E-04  +7.50500000E-05
   +1.57920000E-04  -4.25100000E-05  -2.42000000E-06  -2.06000000E-05  +1.96790000E-04
   -6.82000000E-06  +6.60400000E-05  +1.96210000E-04  +6.38340000E-04  +1.06500000E-04
   +2.06460000E-04  -1.69810000E-04  -1.25600000E-04  +8.95673600E-02  +7.66967100E-02
   +2.09100000E-05  -1.25290000E-04  -2.47100000E-05  +5.02600000E-04  -1.68410000E-04
   +6.57510000E-04  -4.30400000E-05  +2.26300000E-05  +7.68500000E-05  -2.01600000E-05
   -2.02700000E-05  -5.12400000E-05  +1.28240000E-04  +9.41800000E-05  +7.00000000E-06
   -2.05000000E-05  -5.44800000E-05  +5.75000000E-06  +2.52270600E-02  +7.54554000E-03
   -4.94500000E-05  -1.29123600E-02  -5.55313000E-03  -4.79783800E-02  -1.66240000E-04
   +3.68600000E-05  +1.61000000E-05  -3.84100000E-04  +2.76407000E-03  -4.64110000E-03
   +1.11965000E-03  +5.87890000E-04  +5.10930000E-04  +3.07110000E-04  -2.16950000E-04
   -1.48490000E-04  -3.04410000E-04  -2.34700000E-05  -1.27980000E-04  +8.48600000E-05
   -7.24500000E-05  +3.42340000E-04  -3.94990000E-04  -4.80920000E-04  -8.47420000E-04
   +2.63660000E-04  +1.04590000E-04  +7.94700000E-05  +1.63150000E-03  +6.39790000E-04
   +8.56710000E-04  -6.63900000E-05  -3.57900000E-05  -1.32500000E-05  +4.87000000E-06
   +4.09000000E-06  -2.83000000E-05  +1.24440000E-04  -4.82000000E-06  -2.00000000E-07
   -4.19000000E-05  +1.31290000E-04  +5.70000000E-07  -3.80500000E-05  +1.15410000E-04
   +5.95590000E-04  +3.71500000E-05  -8.71000000E-06  +1.87000000E-06  -5.28200000E-05
   -6.89300000E-05  -8.57000000E-06  -3.27010000E-04  -6.17300000E-05  -1.16164000E-03
   -2.43430000E-04  -8.06900000E-05  +3.20000000E-04  +1.22595700E-02  +2.36432000E-03
   +5.38521800E-02  -4.02600000E-05  +1.44690000E-04  +6.37700000E-05  +3.86330000E-04
   -1.28560000E-04  -7.40330000E-04  +2.94260000E-04  +3.79640000E-04  -6.03510000E-04
   -1.73440000E-04  -1.48580000E-04  +3.23720000E-04  +2.25910000E-04  +5.85100000E-05
   -2.16440000E-04  -3.95900000E-05  -3.19300000E-05  +2.07500000E-05  -6.42470000E-04
   +4.63739000E-03  +4.99423000E-03  -5.07701400E-02  -1.80489900E-02  -3.12845700E-02
   -2.90530000E-04  +1.14550000E-04  +4.79800000E-05  +3.07100000E-04  +5.57460000E-04
   -4.32030000E-04  -1.56860000E-04  -6.82000000E-06  -6.08000000E-06  +2.02810000E-04
   +3.06500000E-05  -1.65300000E-05  -1.00860000E-04  -2.03800000E-05  -1.28590000E-04
   -7.80100000E-05  +5.48900000E-05  -1.96080000E-04  -9.35200000E-04  -4.25570000E-04
   +1.00097000E-03  +1.70930000E-04  +4.38700000E-05  -2.88600000E-05  -3.53570000E-04
   -7.15420000E-04  +7.28810000E-04  -1.39040000E-04  -5.90300000E-05  +6.78100000E-05
   -3.88700000E-05  -1.66800000E-05  +4.20000000E-07  +1.14900000E-05  -3.09000000E-06
   -7.29000000E-06  +3.74900000E-05  +2.34300000E-05  -7.94400000E-05  -2.21490000E-03
   -1.59380000E-03  +3.27180000E-04  -3.43000000E-06  -1.59700000E-05  +1.91600000E-05
   +3.55700000E-05  -3.50760000E-04  -1.85390000E-04  +3.97400000E-04  +1.97740000E-04
   +2.57990000E-04  +7.43190000E-04  +3.12700000E-05  +2.97090000E-04  -2.14334000E-03
   -1.55341600E-02  -2.71293900E-02  +5.25178400E-02  -2.49650000E-04  +6.97800000E-05
   -3.34000000E-05  +2.45640000E-04  +1.22027000E-03  -6.01150000E-04  +6.38230000E-04
   -1.87186000E-03  +1.06690000E-04  -3.79700000E-05  +9.55700000E-05  -8.85500000E-05
   -2.79560000E-04  -1.59000000E-04  +2.45840000E-04  +5.06700000E-05  +3.73000000E-05
   -6.13000000E-05  +3.81585000E-03  +1.08566900E-02  +1.61599900E-02  -1.75080700E-02
   -1.11411220E-01  -1.14677980E-01  +1.93730000E-04  +1.06800000E-05  -4.75900000E-05
   +1.51960000E-04  +5.39820000E-04  -8.37260000E-04  +1.61400000E-05  +9.13700000E-05
   +1.25620000E-04  +8.91100000E-05  -8.83000000E-06  +4.95800000E-05  -1.13300000E-04
   +3.80000000E-05  -1.34400000E-04  -1.89500000E-05  -5.26300000E-05  +2.23930000E-04
   -7.57850000E-04  -6.77820000E-04  -3.88860000E-04  +4.57200000E-05  +7.42000000E-06
   +4.76400000E-05  -7.80900000E-04  -1.97715000E-03  +2.55166000E-03  +1.06440000E-04
   +1.22790000E-04  -5.64700000E-05  +3.78000000E-06  +9.84000000E-06  -1.43600000E-05
   +1.23200000E-05  -7.48000000E-06  +7.27000000E-06  +2.63800000E-05  +2.17700000E-05
   -4.06000000E-06  -1.77315000E-03  -1.05300000E-04  +5.79890000E-04  +5.49000000E-06
   -1.43900000E-05  -7.57000000E-06  -2.95270000E-04  +2.33920000E-04  +2.65480000E-04
   +1.25610000E-04  -1.65220000E-04  +7.77800000E-05  +5.32000000E-05  +8.71240000E-04
   +1.02913000E-03  -1.08900000E-04  -5.50350000E-03  -7.82558000E-03  +2.05375600E-02
   +1.22161510E-01  -5.76800000E-05  -6.79600000E-05  +1.78320000E-04  +2.29630000E-04
   -1.04152000E-03  -1.57370000E-04  +3.82030000E-04  -6.24130000E-04  -7.36520000E-04
   +3.85700000E-05  -3.53400000E-05  +7.35850000E-04  -1.56950000E-04  +3.76500000E-05
   -7.38880000E-04  -6.25000000E-06  +1.23160000E-04  +1.94710000E-04  -4.11167000E-03
   -1.41841100E-02  -1.91948800E-02  -3.01633100E-02  -1.12221040E-01  -2.50482710E-01
   -9.67300000E-05  -6.88100000E-05  +2.06510000E-04  -1.24566000E-03  -3.60960000E-04
   +2.34920000E-04  +3.14160000E-04  +1.03570000E-04  -1.02530000E-04  -1.76260000E-04
   -5.06700000E-05  +7.31800000E-05  -1.54310000E-04  -4.87700000E-05  +1.10730000E-04
   +2.43220000E-04  -5.70000000E-07  +7.08800000E-04  -8.29770000E-04  -5.28720000E-04
   -8.03240000E-04  -1.79700000E-05  +3.35700000E-05  +9.43100000E-05  +1.47875000E-03
   +4.62059000E-03  -4.32835000E-03  +1.96600000E-05  -8.11500000E-05  +1.98230000E-04
   +3.98100000E-05  +3.70000000E-07  -1.35200000E-05  +1.76000000E-05  +5.48000000E-06
   -9.80000000E-07  -1.38340000E-04  -1.01610000E-04  +1.40440000E-04  +1.70560000E-04
   +1.60670000E-04  +1.47435000E-03  +3.80700000E-05  -5.02000000E-06  -2.35100000E-05
   +7.51400000E-05  +1.00920000E-04  +3.59390000E-04  +1.00940000E-04  +1.12840000E-04
   +3.15580000E-04  -3.46700000E-04  -1.03476000E-03  -1.56674000E-03  +2.57600000E-05
   -3.33150000E-04  -6.41670000E-04  +3.43529700E-02  +1.25019090E-01  +2.71760720E-01
   +4.29870000E-04  -3.30180000E-04  -8.13500000E-05  -9.39260000E-04  -1.50929000E-03
   +1.46715000E-03  +4.34600000E-05  -1.94780000E-04  +1.22460000E-04  +3.30100000E-05
   +4.27500000E-05  -2.37300000E-05  +3.82700000E-05  -3.95400000E-05  +1.77120000E-04
   +1.13000000E-06  -1.11190000E-04  +5.34000000E-06  +3.16917000E-03  -6.78148000E-03
   +9.83480000E-04  -1.45981230E-01  +1.31053060E-01  +1.02097000E-03  -1.86000000E-06
   +7.76300000E-05  -3.68100000E-05  +6.91960000E-04  -9.63360000E-04  +7.73800000E-05
   +2.11620000E-04  +8.81800000E-05  +3.36200000E-05  +6.80000000E-06  +2.34500000E-05
   -2.64200000E-05  -1.03160000E-04  -4.53100000E-05  +5.38200000E-05  +3.84900000E-05
   +9.08400000E-05  -1.00490000E-04  -1.06710000E-04  -8.98700000E-05  +9.68600000E-05
   +1.61120000E-04  +3.75100000E-05  -1.12700000E-05  -7.59600000E-05  -1.10600000E-04
   -7.31300000E-05  -1.67900000E-05  +5.20800000E-05  -3.56800000E-05  -2.36400000E-05
   -5.53000000E-06  -8.51000000E-06  +1.73200000E-05  +1.60300000E-05  -5.59000000E-06
   +1.44200000E-05  -1.28400000E-05  -2.71600000E-05  +1.41620000E-04  -5.82100000E-05
   -1.33980000E-04  +1.48300000E-05  +2.55000000E-06  +5.85000000E-06  +2.80620000E-04
   -3.86600000E-05  -3.04030000E-04  -1.28400000E-04  +1.90170000E-04  +5.93700000E-05
   +4.87700000E-05  -2.95260000E-04  -7.82500000E-05  -1.57891600E-02  +2.49849900E-02
   +1.04102000E-03  +2.67726000E-03  -5.15955000E-03  +5.06500000E-05  +1.55075760E-01
   +8.06500000E-04  -6.22620000E-04  -5.51320000E-04  -1.95275000E-03  -1.16885000E-03
   +3.09513000E-03  +1.93780000E-04  +3.39630000E-04  +2.52370000E-04  -9.86000000E-05
   -8.95200000E-05  +1.20020000E-04  +5.87920000E-04  +2.53450000E-04  +1.73700000E-05
   -8.06700000E-05  -1.39370000E-04  +2.93670000E-04  +1.09654100E-02  -1.69146700E-02
   +2.20560000E-04  +1.29694330E-01  -2.16252970E-01  -2.91464000E-03  -5.01450000E-04
   +1.36400000E-04  +8.21000000E-06  +1.04364000E-03  +6.47750000E-04  -4.75170000E-04
   -5.75460000E-04  +7.24000000E-06  +3.35150000E-04  +3.61610000E-04  +6.73500000E-05
   +1.56480000E-04  -1.42690000E-04  -9.83000000E-05  -3.61910000E-04  -3.87360000E-04
   +4.52900000E-05  +3.22600000E-05  -1.96220000E-04  +2.30960000E-04  -8.01200000E-05
   +1.81230000E-04  +7.03900000E-05  +2.20700000E-05  +5.90900000E-05  +4.22300000E-04
   -1.38683000E-03  -2.71440000E-04  -2.03090000E-04  +6.20000000E-07  -1.96200000E-05
   -2.72000000E-05  -7.06000000E-06  +1.24500000E-05  -3.31600000E-05  -2.35000000E-06
   +3.00000000E-06  -1.63300000E-05  -4.46400000E-05  +2.69360000E-04  -2.93810000E-04
   -1.30120000E-04  -9.50000000E-07  -2.95400000E-05  +1.28900000E-05  -2.43300000E-05
   +7.45540000E-04  +2.46680000E-04  -8.93200000E-05  -3.34000000E-06  +5.44000000E-05
   -3.46700000E-04  +2.23500000E-04  -8.48800000E-05  -6.60717000E-03  +9.81462000E-03
   +2.49800000E-04  +9.26097000E-03  -1.20925200E-02  +4.79280000E-04  -1.41989850E-01
   +2.34605270E-01  -1.02272000E-03  +9.18810000E-04  +8.16480000E-04  +1.33541000E-03
   +2.38575000E-03  -4.45869000E-03  +3.41120000E-04  -6.66770000E-04  -9.55440000E-04
   +6.85300000E-05  +6.68900000E-05  +4.09290000E-04  -4.61470000E-04  -2.16690000E-04
   -5.66800000E-04  +7.13700000E-05  +2.93330000E-04  -1.49860000E-04  -1.55106300E-02
   +2.13155900E-02  -1.55677000E-03  +1.99036000E-03  -3.98056000E-03  -4.65218000E-02
   +2.09290000E-04  -7.58100000E-05  +1.33080000E-04  -7.38590000E-04  -5.74150000E-04
   +9.44500000E-04  +1.53600000E-04  -2.39220000E-04  -1.90310000E-04  -1.32440000E-04
   -3.51000000E-06  -1.16850000E-04  +9.84500000E-05  -2.40000000E-06  +1.29380000E-04
   +1.04900000E-05  +7.72500000E-05  -3.52000000E-06  -2.05300000E-05  +1.47510000E-04
   +2.65240000E-04  -1.34990000E-04  -5.88100000E-05  -3.02900000E-05  -7.52020000E-04
   +1.11319000E-03  +8.66660000E-04  +1.46440000E-04  +9.06000000E-05  +1.45810000E-04
   +2.10000000E-06  +2.56000000E-06  +1.60000000E-05  -2.23400000E-05  +3.19800000E-05
   +1.30000000E-06  +1.94500000E-05  +4.32300000E-05  -2.62500000E-05  +3.10290000E-04
   -7.55700000E-05  -1.67550000E-04  -1.34200000E-05  +1.51700000E-05  -9.06000000E-06
   +2.74360000E-04  -2.72080000E-04  -9.22570000E-04  -4.09700000E-05  -5.52600000E-05
   -1.82000000E-05  +2.00980000E-04  -2.69750000E-04  +3.41920000E-04  -1.13823000E-03
   +1.49732000E-03  -1.16036000E-03  +1.79518400E-02  -2.18023700E-02  +4.35640000E-04
   -3.40440000E-03  +4.28520000E-04  +5.16415300E-02  +4.24200000E-04  +1.82810000E-04
   -1.30785000E-03  +2.19008000E-03  -2.37780000E-04  -3.28349000E-03  -6.79645100E-02
   -3.94394900E-02  +7.42173300E-02  +3.98758000E-03  -5.39829000E-03  +1.36180600E-02
   +9.64946000E-03  -4.83385000E-03  -7.12410000E-04  -1.23369000E-03  -7.11200000E-05
   -9.38300000E-05  +2.13450000E-04  -6.36090000E-04  -4.61810000E-04  +1.83470000E-04
   +2.34330000E-04  +4.68210000E-04  +1.27542000E-03  +1.68562000E-03  -1.50814000E-03
   +5.13000000E-06  +1.11410000E-04  -5.96700000E-05  -3.23400000E-05  -7.19000000E-06
   +7.40000000E-07  +5.54900000E-05  +5.76000000E-06  -4.25100000E-05  -8.22200000E-05
   -1.26700000E-05  +1.25000000E-06  +1.83800000E-05  -4.21900000E-05  -1.39610000E-04
   -1.35000000E-06  -1.23000000E-04  +2.96500000E-04  +8.88100000E-05  +3.87700000E-05
   -2.51100000E-05  +8.68000000E-05  +5.01800000E-05  -1.51600000E-05  -2.43873000E-03
   -2.07214000E-03  +1.37180000E-03  -2.82500000E-05  -1.17700000E-05  +4.67000000E-06
   +3.32000000E-06  -3.95000000E-06  -4.79000000E-06  +7.52000000E-06  +1.60000000E-06
   -4.04800000E-05  -1.50040000E-04  +1.48920000E-04  -9.90800000E-05  -9.57000000E-06
   -7.32000000E-06  +1.12100000E-05  -1.78400000E-05  -9.76000000E-06  -1.86000000E-06
   -4.00000000E-06  -3.38700000E-05  -3.37000000E-06  +6.06000000E-06  -1.86700000E-05
   -6.09600000E-05  -6.70700000E-05  -1.61270000E-04  -7.10400000E-05  +1.06000000E-05
   +9.44690000E-04  -1.31230000E-04  -6.01800000E-05  -1.20680000E-04  -1.87940000E-04
   +5.73961200E-02  -1.11223000E-03  -2.65500000E-03  -2.06941000E-03  +4.42309000E-03
   +9.01157000E-03  -1.56833800E-02  -3.90029100E-02  -9.83569300E-02  +9.71364500E-02
   -1.11007300E-02  -8.81364000E-03  +2.76620600E-02  -5.67460000E-03  -7.40830000E-04
   -4.01720000E-03  +5.29440000E-04  +4.57500000E-05  +7.69600000E-05  -2.58800000E-05
   +9.22400000E-04  +3.92960000E-04  +5.79340000E-04  -1.43406000E-03  -1.01860000E-04
   -1.23542000E-03  -4.86460000E-04  +1.02881000E-03  +4.14300000E-05  -9.09500000E-05
   +7.13000000E-05  -1.98500000E-05  -1.55000000E-06  -4.41800000E-05  -3.31200000E-05
   +5.79000000E-06  +6.60000000E-07  +3.90500000E-05  +1.25100000E-05  +1.98300000E-05
   +5.74000000E-06  +3.58400000E-05  +4.86900000E-05  -4.06500000E-05  -5.33400000E-05
   -2.15800000E-05  -4.03100000E-05  -1.25600000E-05  +1.03000000E-06  -1.35090000E-04
   -4.30400000E-05  +1.66850000E-04  +8.65340000E-04  -1.13888000E-03  +1.04188000E-03
   +1.42700000E-05  +9.10000000E-07  +5.06000000E-06  -2.61000000E-06  -5.37000000E-06
   -1.83000000E-06  -6.05000000E-06  +6.91000000E-06  +1.29000000E-05  +2.45500000E-05
   +5.12100000E-05  +4.88900000E-05  -1.18300000E-05  +1.61000000E-06  -3.61000000E-06
   +3.25000000E-05  -5.02500000E-05  +2.44900000E-05  -9.07000000E-06  +3.68000000E-06
   -2.74600000E-05  -2.13700000E-05  +4.76600000E-05  +1.13500000E-04  -1.01310000E-04
   -7.30200000E-05  -5.23000000E-06  +1.09493000E-03  -2.34988000E-03  -2.77570000E-04
   -7.93100000E-05  +5.84400000E-05  +7.72000000E-05  +4.69523000E-02  +1.04690060E-01
   -1.32995000E-03  -4.33969000E-03  -2.44756000E-03  +9.20501000E-03  +1.25286400E-02
   -1.90647200E-02  +7.44140000E-02  +9.86910700E-02  -2.70914220E-01  -4.98260000E-04
   -2.70676000E-03  +4.16396000E-03  +8.74220000E-04  -1.64669000E-03  +5.09380000E-04
   -1.80690000E-04  +6.30100000E-05  +6.44310000E-04  -4.50030000E-04  +8.51720000E-04
   -6.35650000E-04  -4.40660000E-04  +4.67620000E-04  -5.02910000E-04  +2.64570000E-04
   +1.41400000E-05  +4.82500000E-05  -6.89500000E-05  -1.05600000E-04  +9.14200000E-05
   -5.60000000E-06  -2.37000000E-05  -3.10600000E-05  -5.68800000E-05  -2.21800000E-05
   +4.18500000E-05  -1.54300000E-05  -5.88000000E-06  +3.30900000E-05  +6.03900000E-05
   +2.00900000E-05  +8.61700000E-05  -4.31200000E-05  +5.09100000E-05  -2.98930000E-04
   -7.93000000E-06  -1.00600000E-05  +1.67100000E-05  +1.38190000E-04  -2.39000000E-04
   +1.79240000E-04  -1.58470000E-04  -6.54000000E-06  +2.40850000E-04  +5.05000000E-06
   +8.77000000E-06  -4.03000000E-06  -1.01000000E-05  +6.56000000E-06  +1.49000000E-06
   -2.10900000E-05  +2.51700000E-05  +3.18700000E-05  +1.37290000E-04  -3.45800000E-05
   +1.65270000E-04  -7.50000000E-07  +8.35000000E-06  -4.10000000E-06  +5.36000000E-06
   -1.31820000E-04  -5.90200000E-05  -2.18800000E-05  -6.69000000E-06  -3.63700000E-05
   -3.80700000E-05  +6.85500000E-05  +1.28820000E-04  +1.74700000E-05  -9.23500000E-05
   -3.48500000E-05  +1.70650000E-04  +3.44470000E-04  +1.19768000E-03  -2.88600000E-05
   +2.10380000E-04  +4.95510000E-04  -8.08066800E-02  -1.06338630E-01  +2.83407810E-01
   -4.33620000E-04  +1.72280000E-04  +1.47520000E-04  +9.18395000E-03  -7.23935000E-03
   +9.80530000E-04  +3.02311000E-03  -7.82071000E-03  -1.10911900E-02  -4.58020700E-02
   -2.45923800E-02  -2.67083300E-02  +4.52997000E-03  +5.17859000E-03  +8.31688000E-03
   +2.30040000E-04  -1.93584000E-03  +1.08793000E-03  -7.26960000E-04  -7.13800000E-04
   -2.24645000E-03  -9.69400000E-05  +1.89400000E-04  -1.56790000E-04  +2.90570000E-04
   +3.40100000E-04  -8.29920000E-04  -1.94530000E-04  -2.67000000E-05  +2.50100000E-05
   +8.43900000E-05  +5.04200000E-05  -5.10900000E-05  -4.78300000E-05  -2.10700000E-05
   -6.16600000E-05  -8.47500000E-05  -1.27100000E-05  +1.26660000E-04  +5.64500000E-05
   -1.05470000E-04  -4.76200000E-05  +1.75500000E-05  -5.92900000E-05  -8.10000000E-06
   +5.70600000E-05  -4.08000000E-06  -2.02000000E-05  +5.33480000E-04  -5.11480000E-04
   +2.18550000E-04  -1.28597000E-03  +7.59100000E-05  -1.33735000E-03  -2.89700000E-05
   +1.29500000E-05  +5.40000000E-06  +1.43000000E-06  +3.24000000E-06  -5.30000000E-06
   -2.35000000E-06  -1.40800000E-05  -9.08000000E-06  +6.36600000E-05  +3.54300000E-05
   -2.58300000E-05  -2.64000000E-05  +3.65900000E-05  -1.26000000E-05  -6.79900000E-05
   -1.60490000E-04  -2.02030000E-04  -2.72800000E-05  -2.75400000E-05  -1.48000000E-06
   +1.72000000E-05  +2.03900000E-05  -1.51900000E-05  -1.20000000E-05  -3.63900000E-05
   +3.15300000E-05  +3.28400000E-05  +3.44600000E-05  +1.01980000E-04  +4.08000000E-06
   +2.67000000E-06  +3.35200000E-05  -6.44327000E-03  +3.28801000E-03  -1.01726000E-03
   +3.56645800E-02  +1.16180000E-04  -2.98150000E-04  +2.85130000E-04  -4.41889000E-03
   +7.83450000E-04  +3.50970000E-03  -3.88227000E-03  -1.19678400E-02  -2.64855500E-02
   -2.57971000E-02  -1.33053130E-01  -1.29104150E-01  +3.07990000E-04  +7.77538000E-03
   +1.34913000E-02  -9.54910000E-04  -1.28903000E-03  +2.08327000E-03  -2.37500000E-05
   +2.85210000E-04  +1.86560000E-04  +6.35600000E-05  -2.71200000E-05  -9.78000000E-06
   +6.95050000E-04  -4.28050000E-04  +1.08730000E-04  -6.68900000E-05  -6.95100000E-05
   +1.59700000E-05  -7.97000000E-06  -1.05900000E-05  +6.16600000E-05  +4.07700000E-05
   +2.39200000E-05  +7.07000000E-05  +2.62800000E-05  -7.90000000E-07  -7.61500000E-05
   +7.35000000E-06  +9.37200000E-05  +3.82200000E-05  +2.30000000E-05  +8.76100000E-05
   -8.21600000E-05  +2.31800000E-05  +1.20000000E-05  +2.14600000E-05  +1.72700000E-05
   +1.22400000E-05  +1.13100000E-05  +9.33840000E-04  +1.41888000E-03  -1.32268000E-03
   +1.58100000E-05  -2.80000000E-06  -1.26300000E-05  +7.10000000E-06  +2.01000000E-06
   +3.91000000E-06  -1.00500000E-05  -1.21700000E-05  +1.72500000E-05  -4.69900000E-05
   -1.00600000E-04  +2.54600000E-05  +4.56800000E-05  -2.38900000E-05  +7.51000000E-06
   +2.52300000E-05  -1.90600000E-05  -7.28000000E-06  -3.57000000E-06  +5.13200000E-05
   +1.59200000E-05  -1.27100000E-05  +1.35000000E-06  -1.52100000E-05  +1.48000000E-06
   +4.82700000E-05  -1.67500000E-05  -2.68600000E-05  -1.99600000E-05  -1.47100000E-05
   +1.32100000E-05  -4.08100000E-05  +1.20800000E-05  +2.83558000E-03  -6.14980000E-04
   +6.47620000E-04  +3.17546100E-02  +1.38101420E-01  +4.53700000E-05  +4.53470000E-04
   +2.97960000E-04  +1.72794000E-03  +3.80080000E-04  +5.45170000E-04  +1.56777000E-03
   +3.45779000E-03  +5.95975000E-03  -2.92444200E-02  -1.27616440E-01  -2.56977530E-01
   -5.30560000E-03  -1.85051000E-02  -2.03101200E-02  +2.13297000E-03  +3.63385000E-03
   -2.67179000E-03  -1.46290000E-04  -7.92700000E-05  -1.13990000E-04  +4.93100000E-05
   -3.14800000E-05  -1.58800000E-05  +3.84700000E-04  +3.93960000E-04  +7.41260000E-04
   -1.99400000E-05  +2.08000000E-06  +1.94300000E-05  +1.41700000E-05  -1.87800000E-05
   -1.53000000E-05  -1.73900000E-05  -1.19200000E-05  +2.25200000E-05  -2.72000000E-06
   +1.03000000E-05  -2.20700000E-05  +3.83400000E-05  +7.96100000E-05  +2.71200000E-05
   -6.92300000E-05  +7.10000000E-07  -5.93000000E-05  +1.76000000E-05  +1.19200000E-05
   +1.20400000E-05  +4.99600000E-05  +1.01000000E-05  -1.02000000E-06  -3.49510000E-04
   +5.86670000E-04  +4.32265000E-03  +6.60000000E-06  -1.00400000E-05  -3.76000000E-06
   -2.57000000E-06  +1.59000000E-06  +1.18000000E-06  -1.04400000E-05  +2.15000000E-05
   +2.78200000E-05  -3.20000000E-07  -4.87400000E-05  +2.73700000E-05  +1.97700000E-05
   -1.95900000E-05  +1.06700000E-05  -1.00000000E-06  -1.89200000E-05  +6.92000000E-06
   +2.23000000E-06  -3.48000000E-06  +5.30000000E-07  -1.34900000E-05  +1.25300000E-05
   +2.51600000E-05  +2.10000000E-06  +5.48000000E-06  +4.68000000E-06  -7.39000000E-06
   -7.43000000E-06  +2.29500000E-05  -6.04000000E-06  -1.32900000E-05  +1.63300000E-05
   -1.14955000E-03  +1.83430000E-04  +9.42340000E-04  +3.00882400E-02  +1.37987920E-01
   +2.68648310E-01  +3.71081000E-03  -7.04155000E-03  +1.05442700E-02  +9.13869000E-03
   -6.97897000E-03  -1.15263000E-03  -4.16690000E-04  +5.19600000E-05  -2.92000000E-05
   -8.07700000E-05  -2.18336000E-03  -1.34337000E-03  +4.37386000E-03  +5.85165000E-03
   -1.01609200E-02  -4.42789300E-02  -1.92896400E-02  +1.92214000E-02  -6.61800000E-04
   -6.66990000E-04  +2.26708000E-03  +5.36980000E-04  -5.16680000E-04  -2.17700000E-04
   +1.74640000E-04  +1.82020000E-04  +6.43480000E-04  -1.98200000E-04  -2.44100000E-05
   -7.80000000E-06  -1.23400000E-05  -2.22900000E-05  -1.68900000E-05  +6.14500000E-05
   -3.66500000E-05  +3.95300000E-05  -7.79100000E-05  -1.86500000E-05  -1.06460000E-04
   -3.03700000E-05  -6.22000000E-06  +4.64800000E-05  +5.67600000E-05  +5.45400000E-05
   +3.78800000E-05  +6.03100000E-05  +5.18000000E-06  +1.99600000E-05  -1.07700000E-04
   +2.00500000E-04  +1.59900000E-04  -1.16405000E-03  +6.48800000E-05  +1.55520000E-03
   -1.48600000E-05  +2.90000000E-07  -6.62000000E-06  -2.63100000E-05  +2.66500000E-05
   +9.22000000E-06  +4.57500000E-05  +4.08900000E-05  +1.82100000E-05  -3.04000000E-06
   -1.79400000E-05  +1.13300000E-05  +5.12000000E-06  +2.79000000E-06  +7.41000000E-06
   +3.65000000E-06  -6.40000000E-07  -3.18600000E-05  -1.11700000E-05  -3.80700000E-05
   -2.65100000E-05  +3.76900000E-05  +4.42200000E-05  -9.23600000E-05  -2.44600000E-05
   -2.80600000E-05  +6.20000000E-07  +1.66300000E-05  +2.30600000E-05  +1.70300000E-05
   -6.78700000E-05  -1.63670000E-04  +2.04030000E-04  -1.25000000E-05  +5.27300000E-05
   -1.64900000E-05  +4.58280000E-04  +2.40080000E-04  -5.53170000E-04  +3.31911100E-02
   -2.83333000E-03  -1.13908900E-02  +2.68695600E-02  -4.58464000E-03  +4.71730000E-04
   -3.09250000E-03  +6.85700000E-05  -2.91820000E-04  -3.34990000E-04  -1.19977000E-03
   -1.37109000E-03  -2.06933000E-03  -9.12000000E-05  +8.57015000E-03  -1.41292300E-02
   -1.93976100E-02  -1.28440160E-01  +1.28247110E-01  -2.75000000E-06  +2.63550000E-04
   -1.94100000E-04  +4.25000000E-06  +1.96600000E-05  -1.36500000E-05  +4.93100000E-04
   -5.14970000E-04  +3.31200000E-05  -5.17500000E-05  -6.31100000E-05  -2.05200000E-05
   +6.39700000E-05  +5.11700000E-05  +9.47300000E-05  -2.13100000E-05  +4.66300000E-05
   -3.56100000E-05  +3.18400000E-05  -3.28000000E-06  +8.39100000E-05  +3.39100000E-05
   +1.26000000E-05  -6.37300000E-05  +2.26000000E-06  -5.84000000E-06  -4.97900000E-05
   +1.06600000E-05  +2.41000000E-06  -1.79300000E-05  +5.46000000E-05  -2.98100000E-05
   +1.20500000E-05  +1.01494000E-03  +1.27890000E-03  +1.67582000E-03  +2.93000000E-06
   +2.50000000E-06  -1.47000000E-06  +3.64500000E-05  -1.26400000E-05  -2.25000000E-06
   -3.35300000E-05  -8.80100000E-05  -2.25200000E-05  -7.60000000E-06  -1.27100000E-05
   -1.11500000E-05  +4.39000000E-06  +3.47000000E-06  -4.33000000E-06  +9.91000000E-06
   -3.44200000E-05  -1.35100000E-05  +1.10000000E-06  +4.47600000E-05  +1.50300000E-05
   -2.31500000E-05  -3.05800000E-05  +1.09800000E-05  -5.36000000E-06  +4.70300000E-05
   -1.13800000E-05  -1.12800000E-05  -1.60000000E-07  +1.36900000E-05  +2.46600000E-05
   -1.30100000E-05  +3.79000000E-06  +7.12000000E-06  +6.78900000E-05  +1.58550000E-04
   +2.10070000E-04  +4.96330000E-04  -6.95960000E-04  +2.52000100E-02  +1.32677700E-01
   -1.35009000E-03  -3.02721000E-03  +5.37114000E-03  -1.84179000E-03  -2.67420000E-04
   +6.53600000E-04  +5.20000000E-07  -4.41800000E-04  +2.66510000E-04  -2.33887000E-03
   -3.27087000E-03  -2.34479000E-03  +3.93563000E-03  +1.73682400E-02  -2.02313500E-02
   +2.00829000E-02  +1.27548030E-01  -2.67468910E-01  +1.30170000E-04  +8.52300000E-05
   -1.41690000E-04  -5.17300000E-05  -4.95000000E-06  +3.22000000E-06  -3.09520000E-04
   -5.87230000E-04  +3.49810000E-04  +1.88300000E-05  +3.19000000E-06  +1.53900000E-05
   +4.63900000E-05  +2.74000000E-06  -5.92500000E-05  -4.02100000E-05  -4.38700000E-05
   +1.31500000E-05  +8.33000000E-06  +1.66000000E-06  -1.22000000E-06  +2.97700000E-05
   +1.42200000E-05  +1.96100000E-05  -2.54500000E-05  +2.23300000E-05  -1.82200000E-05
   -2.05200000E-05  -1.06600000E-05  +8.12000000E-06  -4.00600000E-05  +2.21700000E-05
   -2.29000000E-05  +7.03740000E-04  -6.52610000E-04  +3.96125000E-03  +3.13000000E-06
   +3.40000000E-06  -1.98000000E-06  -1.33900000E-05  +1.24700000E-05  +7.11000000E-06
   -1.16000000E-06  +4.09200000E-05  +2.64900000E-05  +8.51000000E-06  -2.23500000E-05
   +2.81100000E-05  +2.34000000E-06  -1.57000000E-06  +3.00000000E-07  +5.86000000E-06
   +8.94000000E-06  +1.82200000E-05  -1.10000000E-06  -2.89000000E-06  +6.62000000E-06
   +4.10000000E-06  +7.50000000E-06  +2.71500000E-05  -7.40000000E-07  +7.11000000E-06
   +2.40000000E-07  +1.00500000E-05  -1.22800000E-05  +2.48800000E-05  +2.74000000E-06
   +1.82300000E-05  +3.42000000E-06  +1.37370000E-04  +9.43300000E-05  +7.52900000E-05
   +4.00540000E-04  +6.18310000E-04  -1.05226000E-03  -2.03977300E-02  -1.37354480E-01
   +2.79320170E-01  -7.32392500E-02  -4.52373500E-02  -8.12983400E-02  +1.57837000E-03
   -7.42790000E-04  +2.43473000E-03  +5.17880000E-04  +3.30450000E-04  +1.09195000E-03
   -1.15800000E-03  +8.55300000E-05  +2.25500000E-04  +9.61357000E-03  -4.97716000E-03
   -8.79300000E-05  +3.29222000E-03  -5.49476000E-03  -1.24799800E-02  +2.21250000E-04
   -6.77250000E-04  +3.81270000E-04  +7.84200000E-05  +7.79000000E-05  +4.47700000E-05
   +1.01175000E-03  +9.76250000E-04  +1.40229000E-03  +8.60000000E-06  +1.02090000E-04
   +3.15200000E-05  -2.97200000E-05  -1.16870000E-04  -2.95880000E-04  +3.00600000E-05
   -2.76400000E-05  +1.44570000E-04  -7.92900000E-05  -1.35400000E-05  -5.34200000E-05
   +4.09500000E-05  +2.59000000E-05  +6.24800000E-05  -2.77400000E-05  -3.07000000E-06
   +9.20000000E-07  +7.82800000E-05  +3.36700000E-05  +2.95400000E-05  +2.70470000E-04
   +1.80160000E-04  -5.05700000E-04  -2.57152000E-03  -1.59688000E-03  -1.19563000E-03
   -1.22500000E-05  -6.03000000E-06  -2.75000000E-06  -1.51600000E-05  -7.35000000E-06
   -6.60000000E-06  -1.72330000E-04  +1.53670000E-04  +1.05090000E-04  +5.29000000E-06
   +5.46000000E-06  +4.06100000E-05  +9.01000000E-06  -5.59000000E-06  +8.73000000E-06
   -6.26600000E-05  -1.43630000E-04  +2.40470000E-04  -6.81100000E-05  -1.54260000E-04
   +5.90000000E-05  -1.40590000E-04  +1.06647000E-03  +1.51010000E-04  +1.66000000E-06
   -3.48700000E-05  -7.40000000E-07  +8.17000000E-06  -2.25700000E-05  +7.28200000E-05
   -2.08800000E-05  +3.40000000E-07  -4.66000000E-06  +7.68470000E-04  -2.64820000E-04
   +1.63200000E-04  -3.05000000E-05  -1.56300000E-05  -1.04320000E-04  -6.33327000E-03
   +2.90271000E-03  +1.29569000E-03  +6.37876700E-02  -4.49418600E-02  -1.03260390E-01
   -9.95956400E-02  +4.90835000E-03  +8.96492000E-03  +1.50739500E-02  -9.66870000E-04
   -2.52866000E-03  +2.15222000E-03  +4.77270000E-04  +2.30700000E-05  -9.75300000E-05
   -5.05140000E-03  -1.01283000E-03  +4.34136000E-03  -1.22522000E-02  -9.53715000E-03
   -2.71609500E-02  -4.48800000E-05  +9.02750000E-04  -3.86650000E-04  -1.33050000E-04
   -4.12800000E-05  -1.62410000E-04  -9.11500000E-04  +2.23000000E-05  -8.96720000E-04
   +3.50000000E-05  -8.05400000E-05  -6.53000000E-05  -3.59000000E-05  -3.75100000E-05
   +5.00200000E-05  +6.70000000E-06  +1.91400000E-05  -5.56100000E-05  +3.82200000E-05
   +1.13800000E-05  -1.12500000E-05  -2.98500000E-05  +1.56000000E-05  -5.53000000E-06
   -3.07100000E-05  -3.94000000E-06  +3.81100000E-05  -3.67000000E-05  -9.11000000E-06
   -4.50000000E-06  +6.76200000E-04  -1.37538000E-03  +2.55500000E-05  +6.62030000E-04
   -1.22097000E-03  -1.16202000E-03  +1.21800000E-05  -3.48000000E-06  +2.23000000E-06
   -6.91000000E-06  +1.84000000E-06  +6.90000000E-07  +4.19700000E-05  +1.75400000E-05
   -6.97400000E-05  -7.63000000E-06  +6.06000000E-06  -1.44000000E-05  -4.77000000E-06
   -5.46000000E-06  +2.20000000E-07  -8.61600000E-05  +5.15400000E-05  -3.32200000E-05
   -1.23800000E-04  -9.77600000E-05  +5.84000000E-06  +1.17196000E-03  -2.54641000E-03
   +3.51070000E-04  -1.05800000E-05  +2.11000000E-06  +2.58900000E-05  -2.24000000E-05
   +4.80200000E-05  -1.09890000E-04  +3.11100000E-05  -4.79800000E-05  -2.42000000E-05
   -1.96990000E-04  +8.08860000E-04  +7.75950000E-04  +4.16000000E-05  +7.04200000E-05
   -1.12660000E-04  +3.16149000E-03  -6.00100000E-04  -2.49760000E-04  +5.30203300E-02
   +1.10680070E-01  -8.15624600E-02  -1.01057070E-01  -2.59857530E-01  -1.00901800E-02
   -1.29368000E-02  -1.89665100E-02  +1.21012000E-03  +4.30419000E-03  -2.69098000E-03
   +1.65890000E-04  -8.43300000E-05  +6.28560000E-04  -1.14870000E-03  +1.85164000E-03
   +4.14030000E-04  +7.43830000E-04  +3.17418000E-03  +5.22237000E-03  +4.38760000E-04
   -8.79930000E-04  -6.09420000E-04  -1.38460000E-04  +2.27420000E-04  +1.77370000E-04
   -3.08140000E-04  -9.84900000E-05  +6.07200000E-05  +6.51700000E-05  +1.02420000E-04
   +8.51900000E-05  +2.24200000E-05  -2.05000000E-05  -2.34150000E-04  -3.97400000E-05
   -2.25300000E-05  +6.98400000E-05  +2.10500000E-05  +7.25000000E-06  +4.50000000E-07
   +4.66600000E-05  +4.25400000E-05  +5.22900000E-05  +6.21000000E-06  +3.55100000E-05
   -2.67700000E-05  -1.00600000E-05  +4.03000000E-06  +1.49100000E-05  +4.58850000E-04
   -4.78220000E-04  -4.64990000E-04  +2.95450000E-04  +1.28160000E-04  +3.18280000E-04
   +6.86000000E-06  -5.49000000E-06  +7.90000000E-07  -1.14000000E-06  -6.99000000E-06
   -7.30000000E-07  -1.04450000E-04  +1.06000000E-06  +1.13190000E-04  +2.25900000E-05
   -2.96500000E-05  +3.09000000E-05  +1.12700000E-05  -8.13000000E-06  +2.25000000E-06
   +5.75100000E-05  -2.01400000E-04  +5.02010000E-04  -2.43000000E-06  +1.48020000E-04
   -6.38600000E-05  -1.65630000E-04  -3.83770000E-04  +1.18150000E-03  +2.46600000E-05
   +1.70200000E-05  -3.75300000E-05  +3.33900000E-05  -6.71400000E-05  +1.28190000E-04
   -3.43000000E-06  +1.29720000E-04  -5.88400000E-05  -2.36820000E-04  -7.92610000E-04
   -1.15482000E-03  +3.07400000E-05  -1.61720000E-04  +7.65100000E-05  +1.29328000E-03
   -7.41120000E-04  +8.47010000E-04  +8.84391700E-02  +1.08472010E-01  +2.71612590E-01
   -2.22100000E-04  +4.63400000E-04  -4.46400000E-04  -4.85250000E-04  -3.79720000E-04
   -1.00221000E-03  -1.13100000E-05  -9.16690000E-04  -4.14480000E-04  +9.33320000E-04
   -1.25840000E-04  +1.31953000E-03  +8.36232000E-03  +3.20553000E-03  -1.64241300E-02
   -3.30390000E-03  -1.03248000E-03  +5.31290000E-04  +6.61710000E-04  -9.97700000E-05
   +2.24610000E-04  -1.95580000E-04  -1.42000000E-06  -3.49500000E-05  -1.17495470E-01
   +8.73907100E-02  -1.65706890E-01  -3.94670000E-04  +1.43350000E-04  -9.79180000E-04
   -1.78930000E-04  -1.49000000E-06  -1.10480000E-04  +8.92000000E-05  -3.34800000E-05
   +5.22300000E-04  +2.20400000E-05  +3.57440000E-04  +7.62030000E-04  +3.12300000E-05
   -1.30783000E-03  -6.91770000E-04  +1.33022000E-03  +7.11560000E-04  +6.44130000E-04
   -6.88490000E-04  -5.18180000E-04  -4.90900000E-05  -2.84620000E-04  +1.81700000E-04
   -5.71000000E-05  -2.69691000E-03  +1.09772300E-02  +4.25903000E-03  -2.64930000E-04
   +3.27950000E-04  -4.92800000E-05  -3.48700000E-05  +4.74100000E-05  -1.36700000E-05
   -2.05200000E-05  -2.04600000E-05  -3.08400000E-05  +1.29400000E-05  -1.73440000E-04
   +1.81340000E-04  -1.73510000E-04  +3.12340000E-04  -1.75450000E-04  +1.26300000E-05
   +1.15600000E-04  +8.32300000E-05  -2.63800000E-05  -5.65800000E-05  -2.47800000E-05
   +4.20200000E-05  -2.76600000E-05  +5.39600000E-05  -1.98500000E-05  -4.76900000E-05
   +3.07500000E-05  +6.44500000E-05  -7.02700000E-05  +8.25400000E-05  -1.14600000E-05
   +1.07240000E-04  +1.57500000E-05  -2.59140000E-04  +1.59820000E-04  +2.47000000E-05
   -3.79520000E-04  +2.28710000E-04  +3.18730000E-04  +1.57530000E-04  +5.74800000E-05
   +1.35010000E-04  +2.84910000E-04  -2.34400000E-04  +9.04700000E-05  +1.24153210E-01
   -1.28260000E-04  -5.08000000E-06  -7.90010000E-04  -1.54160000E-04  +5.92060000E-04
   -3.52740000E-04  -7.54500000E-05  -1.66750000E-04  +1.84690000E-04  -1.87870000E-04
   +3.83260000E-04  +3.52090000E-04  +1.21823700E-02  -4.90526000E-03  -7.67837000E-03
   -2.67979000E-03  +1.88300000E-05  +4.73090000E-04  -9.25410000E-04  +3.68000000E-06
   +1.16690000E-04  +4.06280000E-04  -1.12660000E-04  +2.54500000E-05  +8.65389000E-02
   -1.39920370E-01  +1.72757340E-01  -8.94170000E-04  +4.96910000E-04  -1.22140000E-04
   +3.84700000E-04  -4.58160000E-04  -5.18670000E-04  +2.76570000E-04  -5.53560000E-04
   -5.79450000E-04  +2.95700000E-03  +3.59890000E-04  -1.52601000E-03  +8.22290000E-04
   +1.90019000E-03  +1.37496000E-03  -1.86874000E-03  -6.47820000E-04  +3.07060000E-04
   -1.64888000E-03  -7.86590000E-04  +8.42200000E-05  +4.01910000E-04  -6.17900000E-05
   -6.55400000E-05  +1.10437900E-02  +2.53470000E-03  -2.10470000E-03  +2.12510000E-04
   +2.60840000E-04  +8.14900000E-05  -2.02900000E-05  +6.43400000E-05  +1.26750000E-04
   -4.17400000E-05  +8.34400000E-05  +1.91320000E-04  +1.71900000E-05  +4.91700000E-05
   -1.31430000E-04  -6.94200000E-05  -9.82900000E-05  -1.36810000E-04  -2.35500000E-05
   -1.47130000E-04  -3.40100000E-05  +8.75100000E-05  +9.79100000E-05  +6.35200000E-05
   -1.05770000E-04  +4.35300000E-05  +3.39000000E-05  +8.72400000E-05  +9.98900000E-05
   -4.34800000E-05  -1.03460000E-04  +3.50100000E-05  +2.95400000E-05  -3.29200000E-05
   -1.55210000E-04  +6.39400000E-05  -8.20000000E-07  -6.48400000E-05  +9.13400000E-05
   +1.91350000E-04  -3.48200000E-05  -1.30780000E-04  +1.27580000E-04  -1.78900000E-05
   -1.51300000E-05  +2.82700000E-04  -2.24840000E-04  -4.98300000E-05  -1.02110340E-01
   +1.32002800E-01  -9.92400000E-05  +1.36000000E-06  +2.35910000E-04  -2.54100000E-05
   -1.03680000E-04  +1.67930000E-04  +6.91200000E-05  +1.16900000E-05  -6.12280000E-04
   +1.27898000E-03  +8.64880000E-04  +7.75220000E-04  -6.89675000E-03  -7.88570000E-04
   +1.41193000E-03  +1.74220000E-04  +4.44130000E-04  -3.28500000E-05  -4.57700000E-05
   -2.40300000E-05  -9.12200000E-05  +5.32000000E-06  +4.47800000E-05  +4.35000000E-05
   -1.75189570E-01  +1.84782900E-01  -3.15368000E-01  -7.13200000E-05  -1.36300000E-05
   -3.49930000E-04  -4.65920000E-04  -5.66760000E-04  -5.78380000E-04  +1.26370000E-04
   -9.94000000E-06  -7.55860000E-04  -2.87300000E-04  -3.78090000E-04  +1.10408000E-03
   -3.34670000E-04  -1.18037000E-03  -3.80680000E-04  +1.14308000E-03  +2.63590000E-04
   +2.83700000E-04  +4.90570000E-04  +1.71520000E-04  -1.31000000E-04  +3.61000000E-06
   +4.42000000E-06  -7.72000000E-06  +8.78722000E-03  -5.66737000E-03  -6.36130000E-04
   -2.73900000E-05  +2.41900000E-05  +5.70900000E-05  +1.28600000E-05  -6.71700000E-05
   -5.36400000E-05  +2.77400000E-05  +1.40200000E-05  -1.32000000E-06  +5.39000000E-05
   +2.21560000E-04  -9.06100000E-05  -2.91840000E-04  +4.22940000E-04  -2.24830000E-04
   -1.03000000E-05  +6.06000000E-06  -2.90000000E-07  +7.31000000E-06  +1.47000000E-06
   -2.00000000E-07  -2.30000000E-07  -9.90000000E-06  -1.80500000E-05  +1.00400000E-05
   -2.68000000E-06  -1.54400000E-05  +9.61000000E-06  -1.11800000E-05  -2.08000000E-05
   +5.50000000E-07  +4.95000000E-06  -7.94000000E-06  -5.16700000E-05  +1.04050000E-04
   -1.99000000E-05  +2.77630000E-04  -3.68410000E-04  -4.15120000E-04  +1.73310000E-04
   +2.08000000E-05  +1.75830000E-04  +2.79400000E-05  +3.36700000E-05  -6.78000000E-06
   +1.74725250E-01  -1.81554520E-01  +3.11941510E-01  +3.16300000E-05  -1.14500000E-04
   +7.82480000E-04  -9.26470000E-04  -2.48100000E-05  +1.06410000E-04  +1.45130000E-04
   -9.68700000E-05  -6.91650000E-04  -5.57748000E-03  +3.99803000E-03  -1.74270000E-03
   +2.26681800E-02  -1.07455720E-01  -1.08626000E-03  -4.38418000E-03  +3.95447000E-03
   +2.00135000E-03  +9.42070000E-04  +2.13400000E-05  -3.56400000E-05  -4.67210000E-04
   +1.62430000E-04  -2.87800000E-05  -2.57230900E-02  -6.03328300E-02  -1.94502000E-03
   +9.89880000E-04  +2.31360000E-04  -1.23700000E-05  +2.54490000E-04  +8.90500000E-05
   +3.99390000E-04  -4.42580000E-04  -3.68170000E-04  +2.44930000E-04  -4.66810000E-04
   +6.49200000E-05  +1.50640000E-04  -3.32180000E-04  -9.22460000E-04  -3.09500000E-04
   +4.70750000E-04  -6.07700000E-05  -3.58610000E-04  +1.55800000E-05  -2.95330000E-04
   -9.68000000E-06  -4.51580000E-04  +1.53630000E-04  +2.83000000E-05  +2.58753800E-02
   +4.29657000E-02  +5.29770000E-04  -2.12730000E-04  +1.94440000E-04  -4.92400000E-05
   -7.12700000E-05  +1.23820000E-04  +4.52100000E-05  +6.44500000E-05  -1.09700000E-05
   -1.49520000E-04  +4.82400000E-05  -2.50200000E-05  +1.63440000E-04  -7.02100000E-05
   +1.65150000E-04  -5.02200000E-05  +1.40300000E-05  +1.94490000E-04  +7.09900000E-05
   -7.92100000E-05  -1.29160000E-04  -4.88400000E-05  +1.32590000E-04  -6.21400000E-05
   -3.45000000E-06  -7.63600000E-05  -1.27580000E-04  +5.27000000E-05  +1.23630000E-04
   -5.82000000E-05  -1.86000000E-06  +1.73100000E-05  +1.97890000E-04  -8.27500000E-05
   +1.09968000E-03  -1.03770000E-04  -8.78000000E-06  +3.84530000E-04  -4.36480000E-04
   +2.30510000E-04  +4.37030000E-04  -3.97080000E-04  -2.46040000E-04  +1.02057000E-03
   -5.12900000E-05  -4.61100000E-05  -9.04561000E-03  -5.23417000E-03  -3.66000000E-03
   -6.07024000E-03  +1.74300000E-04  -2.21620000E-04  -2.39180000E-04  +5.44840000E-04
   -3.23320000E-04  -2.83350000E-04  +1.72720000E-04  -1.81900000E-04  -2.34860000E-04
   +6.59937000E-03  -4.46323000E-03  +2.20419000E-03  -1.02252930E-01  +5.02067700E-02
   -3.83163000E-03  +4.96103000E-03  -4.96084000E-03  -1.67952000E-03  -4.03600000E-04
   -1.10990000E-04  +8.27400000E-05  +2.42110000E-04  -7.07300000E-05  +2.25700000E-05
   +4.39651800E-02  -3.46944900E-02  -1.25428400E-02  -6.03380000E-04  -1.47380000E-04
   +3.57500000E-05  -2.59730000E-04  -5.73300000E-05  -2.66080000E-04  +1.54160000E-04
   +3.53510000E-04  -4.19450000E-04  +1.15603000E-03  +3.27820000E-04  -1.73080000E-04
   +6.28700000E-05  +9.75150000E-04  +5.05020000E-04  -5.55230000E-04  +8.18100000E-05
   +1.69320000E-04  -6.63380000E-04  -1.47520000E-04  -3.80000000E-07  +2.13900000E-04
   -2.95000000E-05  -4.27600000E-05  -7.67276800E-02  -5.85550100E-02  -3.77740000E-04
   +2.54260000E-04  -1.86000000E-05  +5.32300000E-05  +5.26900000E-05  -8.21300000E-05
   -4.21000000E-06  -1.13400000E-05  -1.11100000E-05  +8.28000000E-05  +3.08000000E-06
   -2.70700000E-05  -6.77100000E-05  +3.95200000E-05  -1.45590000E-04  -9.90000000E-07
   -2.69100000E-05  -8.07800000E-05  -1.75800000E-05  +7.44100000E-05  +7.14600000E-05
   +1.87800000E-05  -8.02600000E-05  +1.63900000E-05  -1.53500000E-05  +7.23300000E-05
   +7.41500000E-05  -2.04500000E-05  -6.73600000E-05  +4.59000000E-06  +4.79300000E-05
   -3.48800000E-05  -8.34200000E-05  +4.51700000E-05  -1.18141000E-03  +4.61870000E-04
   -3.63800000E-05  -3.33160000E-04  +5.48790000E-04  -2.23930000E-04  -2.48710000E-04
   +5.58160000E-04  +4.20580000E-04  -1.05109000E-03  +2.66890000E-04  +1.01570000E-04
   +1.92707000E-03  +9.86445000E-03  +3.21498000E-03  +1.23440000E-01  +4.04838200E-02
   -1.05190000E-04  -1.63690000E-04  -2.23160000E-04  +1.07700000E-05  +1.13070000E-04
   -1.16800000E-05  +5.06300000E-05  +1.44500000E-05  -9.48600000E-05  -3.58831000E-03
   +1.51555000E-03  -5.25800000E-05  -1.13169000E-03  -6.80720000E-04  +1.47643300E-02
   +3.61211000E-03  -2.03821000E-03  -3.90260000E-04  -4.23900000E-05  +1.17200000E-05
   -7.12000000E-06  +2.48700000E-05  +8.97000000E-06  +1.38400000E-05  -4.14290000E-03
   -3.29219700E-02  -4.10532100E-02  -2.92700000E-05  -3.98100000E-05  -1.63850000E-04
   +1.01010000E-04  -1.20140000E-04  +9.86000000E-06  -8.66400000E-05  -8.80800000E-05
   +4.81000000E-06  -7.38000000E-06  +2.34800000E-05  -1.40500000E-04  +7.90500000E-05
   +3.35730000E-04  +5.65800000E-05  -2.27540000E-04  +1.37870000E-04  +1.72100000E-05
   +2.21100000E-05  +2.70300000E-05  -9.84000000E-06  +2.68000000E-05  -2.66900000E-05
   +5.36000000E-06  -1.98758000E-03  +1.36682000E-03  -2.27095600E-02  +1.44500000E-05
   +6.28000000E-06  +2.20000000E-05  +1.52400000E-05  -1.83200000E-05  -5.51000000E-06
   -1.36500000E-05  +7.18000000E-06  +1.44100000E-05  +1.06800000E-05  +5.91000000E-06
   -1.16400000E-05  -1.38200000E-05  -7.10000000E-06  -5.88000000E-06  -4.92000000E-06
   -1.38100000E-05  -7.99000000E-06  +3.95000000E-06  +1.00600000E-05  +3.12000000E-06
   -4.36000000E-06  +8.30000000E-06  -8.62000000E-06  +4.16000000E-06  +4.97000000E-06
   -3.93000000E-06  -1.36200000E-05  +1.77000000E-06  -1.59200000E-05  +3.54000000E-06
   -1.34700000E-05  -5.07000000E-06  +3.46020000E-04  -2.25950000E-04  +4.00500000E-05
   +3.43080000E-04  +6.24200000E-05  -5.54380000E-04  -3.85140000E-04  -4.94600000E-05
   -3.68670000E-04  -4.09380000E-04  +1.51280000E-04  +3.27900000E-05  +1.72047000E-03
   +1.92869800E-02  +3.66577000E-03  +5.79851000E-03  +1.33636800E-02  +4.72371500E-02
   -2.65994000E-02  -1.61734500E-02  +5.15452000E-03  -1.83206720E-01  -6.04827600E-02
   +4.14168000E-03  -2.90014300E-02  -1.70946300E-02  -3.50117000E-03  +7.04690000E-04
   -5.21320000E-04  -4.93964000E-03  -1.37577000E-03  +2.16567000E-03  -1.56830000E-04
   +9.36450000E-04  -1.78040000E-04  +4.60493000E-03  -3.88667500E-02  -5.67032000E-03
   +7.64780000E-04  -2.29650000E-04  -1.41390000E-04  +1.64130000E-04  -5.68330000E-04
   -7.01000000E-04  +3.79900000E-05  -1.02868000E-03  +5.98944000E-03  +3.05000000E-05
   -3.44460000E-04  +2.45800000E-05  -7.57330000E-04  -2.87210000E-04  -4.74160000E-04
   -2.70040000E-04  +1.32903000E-03  +3.55920000E-04  -1.54950000E-04  -4.47970000E-04
   -5.07610000E-04  +4.07870000E-04  -1.81920000E-04  +6.57000000E-05  +7.17640000E-04
   -1.66071000E-03  -4.19970000E-04  -2.47600000E-05  -2.04010000E-04  -3.72100000E-04
   -1.64920000E-04  +3.89500000E-05  -1.08536000E-03  +8.62000000E-05  +2.03590000E-04
   +4.26800000E-05  +1.07160000E-04  -9.60700000E-05  -8.25500000E-05  +3.60900000E-05
   -1.83500000E-05  +1.38450000E-04  +7.52700000E-05  -1.84100000E-05  +1.32810000E-04
   -6.32300000E-05  -1.32830000E-04  -1.03030000E-04  -6.48300000E-05  +1.76420000E-04
   -7.38800000E-05  -1.54040000E-04  -6.22750000E-04  +1.06026000E-03  +5.26820000E-04
   -1.63630000E-04  +3.09400000E-05  +1.41460000E-04  -8.11570000E-04  +1.06581000E-03
   -5.25020000E-04  -1.29090000E-04  +8.04000000E-06  -1.67700000E-04  +7.42400000E-05
   -1.29940000E-04  +1.76970000E-04  +1.45993000E-03  +1.05338000E-03  -1.28880000E-04
   +1.29040000E-03  -1.92950000E-03  +3.07840000E-04  +1.31038000E-03  -1.79158000E-03
   -3.04860000E-04  +1.45839000E-03  +1.04438000E-03  +1.96990000E-04  +2.25080000E-04
   +1.00990000E-04  +9.85100000E-05  -1.43700000E-04  +4.60260000E-04  -1.49100000E-05
   +5.00409180E-01  -3.14245600E-02  -1.33321700E-02  +5.20484000E-03  -2.46284100E-02
   -1.03084280E-01  +2.75557000E-03  -3.22739700E-02  -1.33474200E-02  -3.40529000E-03
   +4.47090000E-04  +3.37230000E-04  -4.02802000E-03  +1.14020000E-04  +2.54600000E-03
   +5.43200000E-05  +7.85360000E-04  +5.93870000E-04  +3.74932000E-03  +2.89190000E-02
   +7.26970000E-03  -4.43110000E-04  -1.32920000E-04  -1.36142000E-03  +9.63480000E-04
   -2.42832000E-03  +1.33500000E-04  +2.23800000E-05  +2.33097000E-03  -4.70706000E-03
   -4.87600000E-05  +4.05210000E-04  +2.65950000E-04  +3.31050000E-04  +1.70090000E-04
   +4.78730000E-04  +8.58100000E-05  -4.54820000E-04  -2.64530000E-04  +1.11270000E-04
   +3.53350000E-04  +6.40870000E-04  -1.72150000E-04  +1.61290000E-04  +3.43170000E-04
   -3.54980000E-04  +7.81730000E-04  +2.98040000E-04  +1.38200000E-05  -3.34500000E-04
   -1.19432000E-03  -9.89470000E-04  -6.42320000E-04  -8.75140000E-04  +4.10300000E-05
   -1.54700000E-05  -8.86200000E-05  -5.06400000E-05  +1.09320000E-04  -1.11000000E-05
   -2.99100000E-05  +2.33000000E-05  -3.35320000E-04  -5.40900000E-05  +2.20700000E-05
   -3.48250000E-04  +9.14000000E-05  +1.24150000E-04  -7.33000000E-06  +4.50900000E-05
   +1.03447000E-03  +5.55870000E-04  +2.80200000E-04  +2.29413000E-03  -5.18400000E-05
   -5.34560000E-04  +9.22800000E-05  -8.50200000E-05  -2.77290000E-04  +2.42509000E-03
   -1.06350000E-04  +5.23890000E-04  +3.73400000E-05  -8.70200000E-05  +2.64610000E-04
   +1.04681000E-03  +5.54650000E-04  -3.09470000E-04  +1.37396000E-03  +6.23460000E-04
   +7.14790000E-04  +1.82687000E-03  -1.63019000E-03  +2.98390000E-04  +1.76554000E-03
   -1.52023000E-03  -3.18610000E-04  +1.27179000E-03  +5.70280000E-04  -6.64740000E-04
   +5.03830000E-04  -5.94030000E-04  +9.52700000E-05  +5.24220000E-04  +3.26000000E-05
   -6.35000000E-05  -1.69760760E-01  +4.84571950E-01  +3.45772000E-02  +1.58868800E-02
   +5.93710000E-04  +1.42263000E-03  +3.11504000E-03  -6.57422300E-02  -3.21984200E-02
   -1.40512700E-02  +3.27104000E-03  -1.80800000E-05  -2.67866000E-03  -1.93248000E-03
   -2.93880000E-04  -3.73950000E-04  -8.79762000E-03  -4.78270000E-04  +2.43890000E-03
   -2.12094000E-03  +2.40330000E-04  +4.49900000E-05  +2.15163000E-03  -2.93690000E-04
   +1.39264000E-03  -1.49900000E-04  -1.46350000E-04  -4.61590000E-04  +2.13626000E-03
   -5.61300000E-05  +5.07800000E-05  +9.77920000E-04  +1.34900000E-05  +8.90800000E-05
   -3.48870000E-04  -2.62690000E-04  -1.37330000E-04  +7.75100000E-05  -1.76000000E-06
   +7.11000000E-06  +1.70970000E-04  +2.92680000E-04  +1.68120000E-04  +8.99900000E-05
   -5.47400000E-05  -8.11400000E-05  -3.34030000E-04  -9.32000000E-06  -3.14000000E-06
   +3.11300000E-05  +6.73100000E-05  -1.42727000E-03  -2.01580000E-04  +1.35480000E-04
   +1.52200000E-04  +2.22899000E-03  +8.93000000E-06  +2.60000000E-07  -1.31100000E-05
   -3.86400000E-05  +1.13000000E-06  +6.50000000E-07  -6.81200000E-05  +6.54500000E-05
   +1.36820000E-04  +6.92500000E-05  -6.38300000E-05  +1.36250000E-04  +3.94100000E-05
   -2.66000000E-06  +2.38000000E-06  +6.96550000E-04  +2.55250000E-04  +3.09760000E-04
   +1.37196000E-03  -4.89000000E-06  -5.24110000E-04  -4.26240000E-04  +1.33200000E-04
   +3.24040000E-04  -1.30794000E-03  -9.83000000E-06  -4.39010000E-04  +4.59380000E-04
   -1.15970000E-04  +3.30360000E-04  -6.67360000E-04  -2.34490000E-04  +3.32900000E-04
   +4.09120000E-04  +1.10415000E-03  +3.26574000E-03  +1.61853000E-03  -1.69392000E-03
   +5.68290000E-04  -1.67517000E-03  +1.76526000E-03  +6.03040000E-04  -4.09810000E-04
   -1.05793000E-03  +3.30270000E-03  +7.00150000E-04  +2.74620000E-04  -7.34900000E-05
   -6.89800000E-05  +1.71040000E-04  -6.52300000E-05  +4.41912000E-03  -1.92058100E-02
   +6.24981700E-02  +1.54436000E-03  +7.91370000E-04  +9.12570000E-04  -2.86849100E-02
   +3.07207700E-02  -1.24677000E-03  +1.13754000E-03  +7.55900000E-04  -8.72400000E-04
   +2.36300000E-05  +2.29000000E-06  +1.80640000E-04  -7.70660000E-04  -1.24089000E-03
   -1.24930000E-04  -5.34700000E-05  +2.23600000E-05  -1.40800000E-04  -6.20728000E-03
   -3.36478000E-03  +1.02820000E-04  +4.23590000E-04  -7.84420000E-04  +2.67710000E-04
   +1.04925000E-03  +5.69400000E-05  +2.00400000E-05  -4.80110000E-04  +1.44936000E-03
   +3.47800000E-05  -9.84300000E-05  -4.01400000E-05  -1.34030000E-04  -3.75300000E-05
   -1.60220000E-04  +1.34000000E-05  -8.76000000E-06  +4.04000000E-05  -3.95300000E-05
   -9.12700000E-05  -2.01560000E-04  +1.93100000E-05  -1.45600000E-05  -7.36200000E-05
   +1.29460000E-04  -5.37200000E-05  -3.66800000E-05  -1.00000000E-06  +3.96850000E-04
   -7.18370000E-04  -2.53800000E-04  +3.28810000E-04  +7.01250000E-04  +2.18200000E-05
   -3.13300000E-05  +1.91100000E-05  +7.86000000E-06  -2.77900000E-05  +5.77000000E-06
   +3.29000000E-06  -3.92300000E-05  +9.58900000E-05  +5.09900000E-05  -3.76600000E-05
   +9.47300000E-05  -5.76600000E-05  -2.31700000E-05  +6.85000000E-06  -2.54000000E-06
   +1.20560000E-04  -4.37400000E-05  -5.29700000E-05  +6.55800000E-05  +2.05410000E-04
   +1.40910000E-04  -1.27900000E-05  +1.03400000E-04  +4.69000000E-05  +6.02100000E-05
   +2.16950000E-04  -1.26650000E-04  -1.43200000E-05  +1.06080000E-04  -4.94900000E-05
   +1.35450000E-04  -4.85900000E-05  +5.37500000E-05  -1.25260000E-04  -1.35000000E-04
   -1.25280000E-04  -2.32630000E-04  +2.11630000E-04  -7.70000000E-07  -2.54430000E-04
   +2.16980000E-04  +2.16400000E-05  -1.24710000E-04  -1.48940000E-04  +1.76420000E-04
   -1.89790000E-04  +1.84340000E-04  -4.57300000E-05  -1.94270000E-04  -6.90500000E-05
   +2.12200000E-05  -2.23477290E-01  +2.13152790E-01  -8.06594000E-03  +2.55999540E-01
   -1.27011000E-03  +1.55103000E-03  -3.46570000E-04  -1.76890200E-02  +1.03323400E-02
   -3.66890000E-04  -1.23336000E-03  +1.46886000E-03  +4.49820000E-04  +2.08820000E-04
   -8.27990000E-04  -1.27890000E-04  -6.66690000E-04  +5.31000000E-06  +3.11000000E-06
   +1.49900000E-04  -8.80530000E-04  +8.45600000E-05  -2.25704000E-03  -1.03429000E-03
   +4.99200000E-05  -9.82400000E-05  -2.38440000E-04  +4.76000000E-06  +3.05510000E-04
   -9.16200000E-05  -2.54000000E-06  -3.78600000E-04  +7.03750000E-04  -8.08000000E-06
   -1.41400000E-05  +2.79400000E-05  -7.13100000E-05  -5.30000000E-07  -6.17500000E-05
   -1.89100000E-05  +5.19000000E-05  +1.99700000E-05  -2.21200000E-05  -2.50000000E-05
   -8.38400000E-05  +3.25000000E-05  +1.63800000E-05  +2.11300000E-05  +7.42200000E-05
   -1.15230000E-04  -4.33000000E-05  -1.84000000E-06  -7.18900000E-05  -1.36630000E-04
   +9.30000000E-07  +2.32480000E-04  +3.09000000E-06  +3.58000000E-06  -3.80000000E-07
   +1.11200000E-05  +9.22000000E-06  -1.21800000E-05  +4.50000000E-06  +5.34000000E-06
   +1.16500000E-05  +2.28800000E-05  +3.71200000E-05  +1.31100000E-05  +2.23000000E-05
   -3.88600000E-05  -1.38700000E-05  +4.46000000E-06  -6.59000000E-06  +7.24600000E-05
   +8.92300000E-05  +9.24000000E-06  +1.48460000E-04  +2.44900000E-04  +3.27040000E-04
   +1.30970000E-04  +2.67600000E-05  -3.92100000E-05  +1.84570000E-04  +2.98020000E-04
   -3.11310000E-04  +1.26210000E-04  +2.83400000E-05  +3.75000000E-05  +1.07590000E-04
   +1.02930000E-04  -3.25000000E-06  +4.72900000E-05  +1.29140000E-04  -1.14000000E-06
   +1.49610000E-04  -1.68860000E-04  +1.64400000E-05  +1.86400000E-04  -1.73880000E-04
   -1.58900000E-05  +7.77700000E-05  +1.50980000E-04  -5.62800000E-05  -6.06500000E-05
   +6.41800000E-05  -6.91000000E-06  -1.73590000E-04  +8.43200000E-05  +7.41000000E-06
   +2.63954050E-01  -3.56784240E-01  +1.44875700E-02  -2.42094580E-01  +3.45107860E-01
   +4.18060000E-04  -9.38010000E-04  +7.81830000E-04  +1.28724000E-03  -1.16497000E-03
   -2.02792000E-03  -5.18580000E-04  +8.65280000E-04  +5.72410000E-04  +1.18660000E-04
   -8.26900000E-05  -4.10760000E-04  +1.37530000E-04  +8.87600000E-05  +2.81799000E-03
   -1.65900000E-05  +1.05470000E-04  -4.72000000E-04  +4.63190000E-04  +1.40030000E-04
   -5.40030000E-04  -1.59910000E-04  +4.02980000E-04  +1.47300000E-04  +2.50500000E-05
   +1.47370000E-04  -6.39940000E-04  +3.57600000E-05  -1.32200000E-04  +3.46620000E-04
   -1.31500000E-05  +6.42900000E-05  +2.90700000E-05  -2.12200000E-05  +9.58000000E-06
   -3.83800000E-05  -9.61000000E-06  +1.17000000E-06  +7.75800000E-05  +1.69000000E-05
   +2.22000000E-06  -4.28900000E-05  +5.48400000E-05  -7.30800000E-05  +1.22300000E-05
   +1.86100000E-05  +2.75000000E-06  -2.28500000E-05  +1.71520000E-04  -2.59780000E-04
   +1.74040000E-04  -6.13700000E-05  -6.51900000E-05  -7.47860000E-04  -5.90000000E-06
   +3.00000000E-08  +4.91000000E-06  +1.08400000E-05  -1.02000000E-05  -2.86000000E-06
   +1.01700000E-05  -3.09400000E-05  -3.42500000E-05  -1.92000000E-06  +2.01000000E-05
   -2.99500000E-05  -6.78000000E-06  +1.20800000E-05  -2.45000000E-06  +1.00720000E-04
   +7.27000000E-05  -8.21000000E-05  +2.26220000E-04  +1.19700000E-04  +1.30430000E-04
   +1.02470000E-04  +2.00300000E-05  -1.21960000E-04  -2.81620000E-04  -1.34190000E-04
   +8.57000000E-05  -6.22500000E-05  -4.09100000E-05  -9.81100000E-05  -1.45420000E-04
   -8.84800000E-05  -6.88300000E-05  -3.87160000E-04  +1.95020000E-04  -5.98960000E-04
   +1.32100000E-05  +8.86600000E-05  -1.14450000E-04  -4.95600000E-05  -7.53300000E-05
   -1.14450000E-04  +4.01840000E-04  -2.24180000E-04  -7.01530000E-04  -2.14550000E-04
   -8.54000000E-05  +3.00000000E-05  +3.14000000E-05  -6.18800000E-05  +2.22100000E-05
   -1.08033900E-02  +1.53039000E-02  -2.79766000E-03  +9.11475000E-03  -1.41946800E-02
   +4.47788000E-03
end_hess

