# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -959.74895760    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +1.63162750E+00  +4.85152950E-02  -2.26804601E+00
   006   +1.35845867E+00  +1.45803068E+00  +7.29534275E-02
   006   +2.34243536E+00  +3.06422914E-01  +2.36366416E+00
   006   +3.59918946E+00  -1.87950168E+00  +2.28533319E+00
   006   +4.29568704E+00  -3.23539364E+00  -1.19540047E-01
   006   +2.90371206E+00  -2.12864582E+00  -2.34277841E+00
   006   -8.98146389E-01  +3.27471514E+00  +2.82948804E-01
   006   -9.09182570E-01  +4.77775490E+00  +2.76316647E+00
   008   +3.58508826E+00  -5.81910598E+00  +1.25519653E-01
   006   -3.20264572E+00  +1.49752002E+00  +1.53555567E-01
   006   -4.74151124E+00  +1.35802414E+00  -1.96999200E+00
   006   -6.78251775E+00  -2.78908913E-01  -2.08216359E+00
   006   -7.32192526E+00  -1.84654989E+00  -5.22639637E-02
   006   -5.79729457E+00  -1.75467277E+00  +2.08222059E+00
   006   -3.77700971E+00  -1.08398600E-01  +2.16492304E+00
   008   -9.28759602E+00  -3.48619418E+00  -4.41155620E-02
   006   -9.45651810E-01  +5.23061808E+00  -1.85837935E+00
   008   +6.79260972E+00  -2.97975398E+00  -5.01936326E-01
   001   -1.01672985E+01  -3.40237722E+00  -1.62198169E+00
   001   -7.95168389E+00  -3.31696103E-01  -3.76297636E+00
   001   -4.37856486E+00  +2.53735863E+00  -3.59602764E+00
   001   -2.60957119E+00  -1.13255411E-01  +3.84061209E+00
   001   -6.20880274E+00  -2.99101847E+00  +3.65533763E+00
   001   +4.88471209E-01  +6.66434889E+00  -1.51995180E+00
   001   -6.40244690E-01  +4.43281949E+00  -3.72951874E+00
   001   -2.77075979E+00  +6.18207154E+00  -1.87449540E+00
   001   -1.17157589E+00  +3.60422066E+00  +4.42742366E+00
   001   +8.52644344E-01  +5.82285436E+00  +2.96929942E+00
   001   -2.46878793E+00  +6.12154662E+00  +2.71724656E+00
   001   +2.09220638E+00  +1.30204952E+00  +4.12580778E+00
   001   +4.35668422E+00  -2.72382564E+00  +3.98892754E+00
   001   +3.10851957E+00  -3.17418328E+00  -4.08952768E+00
   001   +7.49882014E-01  +7.89880128E-01  -3.95421834E+00
   001   +5.16270701E+00  -6.68814361E+00  -1.03278113E-01
   001   +7.69004087E+00  -3.66221971E-01  -4.42524665E-01
   008   +4.09591398E+00  +4.00580310E+00  -3.29344468E-01
   001   +4.04663740E+00  +4.58804605E+00  -2.04551806E+00
   008   +8.17158026E+00  +1.53879447E+00  -3.46439680E-01
   001   +9.29928891E+00  +1.71231026E+00  +1.05200823E+00
   001   +5.76293315E+00  +3.00083170E+00  -2.07051563E-01
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -2.90000000E-07  -3.50000000E-07  -2.20000000E-07
   +1.04000000E-06  +9.30000000E-07  +4.00000000E-08
   -2.70000000E-07  -5.40000000E-07  +1.10000000E-07
   +6.00000000E-08  -3.00000000E-08  -1.50000000E-07
   +2.20000000E-07  +2.90000000E-07  -4.70000000E-07
   -1.20000000E-07  +4.00000000E-08  -2.20000000E-07
   -4.30000000E-07  -2.50000000E-07  +1.60000000E-07
   +0.00000000E+00  -1.00000000E-08  +9.00000000E-08
   +1.90000000E-07  +1.00000000E-08  -2.70000000E-07
   +1.00000000E-08  -1.20000000E-07  +1.10000000E-07
   -1.20000000E-07  -2.00000000E-08  +2.00000000E-07
   -4.00000000E-08  -7.00000000E-08  +2.00000000E-07
   +9.00000000E-08  -1.40000000E-07  +2.20000000E-07
   +1.00000000E-07  -1.60000000E-07  +1.10000000E-07
   +4.00000000E-08  -7.00000000E-08  +1.20000000E-07
   +4.00000000E-08  -1.50000000E-07  +1.80000000E-07
   -1.00000000E-07  +0.00000000E+00  +1.40000000E-07
   -1.80000000E-07  +2.50000000E-07  -5.00000000E-08
   +2.00000000E-08  -1.80000000E-07  +2.40000000E-07
   -1.00000000E-07  -7.00000000E-08  +2.20000000E-07
   -1.10000000E-07  +1.00000000E-08  +1.70000000E-07
   +1.40000000E-07  -1.60000000E-07  +8.00000000E-08
   +1.90000000E-07  -2.10000000E-07  +1.20000000E-07
   -2.70000000E-07  +1.20000000E-07  +8.00000000E-08
   -2.90000000E-07  +1.30000000E-07  +1.10000000E-07
   -1.40000000E-07  +5.00000000E-08  +2.70000000E-07
   +1.80000000E-07  -2.00000000E-07  +1.30000000E-07
   -1.00000000E-08  -2.00000000E-08  +1.00000000E-07
   -6.00000000E-08  -1.50000000E-07  +2.50000000E-07
   +1.60000000E-07  +0.00000000E+00  -3.00000000E-08
   +2.50000000E-07  +0.00000000E+00  -2.20000000E-07
   -4.00000000E-08  +1.90000000E-07  -1.80000000E-07
   -1.30000000E-07  +1.00000000E-07  -4.00000000E-08
   +1.40000000E-07  +6.00000000E-08  -3.90000000E-07
   -1.00000000E-08  +1.80000000E-07  -6.60000000E-07
   -1.20000000E-07  +4.40000000E-07  +1.10000000E-07
   -2.20000000E-07  +1.60000000E-07  -1.20000000E-07
   +3.00000000E-08  -2.10000000E-07  +1.20000000E-07
   -5.00000000E-08  +4.90000000E-07  -3.00000000E-07
   +2.20000000E-07  -2.90000000E-07  -3.50000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +3.46401810E-01  -2.98237620E-01  +6.28153230E-01  +1.20830220E-01  -2.73476000E-03
   +6.03634550E-01  -8.24406700E-02  +3.81334600E-02  +1.12708600E-02  +2.99395370E-01
   +1.43169200E-02  -1.04210230E-01  -5.41263400E-02  -1.87827340E-01  +3.49746800E-01
   -1.57500800E-02  -3.29454800E-02  -2.11577000E-01  +4.94277600E-02  +3.67444200E-02
   +5.58492420E-01  +1.12306100E-02  -1.23248700E-02  -6.54204000E-03  -9.67012700E-02
   +2.91217600E-02  -2.47600600E-02  +3.02009430E-01  -1.20039900E-02  +2.64177800E-02
   -5.83314000E-03  +4.02443200E-02  -9.42489200E-02  +6.61043000E-03  -2.79254690E-01
   +6.55024950E-01  -7.26760000E-03  +2.28373000E-03  -3.39844600E-02  -5.38198500E-02
   +3.62031500E-02  -2.06946340E-01  +1.64994600E-02  +1.01517090E-01  +6.30962180E-01
   -3.86673000E-03  +7.03752000E-03  +5.34379000E-03  -9.22296000E-03  +2.36797700E-02
   -3.20127100E-02  -1.59641220E-01  +1.90500730E-01  +1.63810400E-02  +3.45921850E-01
   +4.27904000E-03  -1.08637400E-02  -7.72843000E-03  +1.45725700E-02  -2.38456400E-02
   +3.71836500E-02  +1.89828450E-01  -4.04194540E-01  -3.29542200E-02  -2.79984090E-01
   +6.63935390E-01  +3.04321000E-03  -6.25657000E-03  -2.94012000E-03  -1.65491200E-02
   +2.62988100E-02  +1.55228700E-02  -6.56218000E-03  -8.76030000E-03  -1.27441000E-01
   +7.79018500E-02  -3.07722400E-02  +5.95403230E-01  -3.89209000E-03  +1.62005900E-02
   -9.73770000E-04  -4.65760000E-03  -8.88196000E-03  +5.55010000E-03  -4.08629000E-03
   +1.91976700E-02  +1.73899000E-03  -5.05458400E-02  +5.31095000E-03  -6.45704000E-03
   +4.69519720E-01  +1.39055600E-02  -1.77635000E-03  +2.04472400E-02  -6.44277000E-03
   -9.70731000E-03  +3.31188000E-03  +6.29773000E-03  -3.53083000E-03  -2.24455500E-02
   +1.67883400E-02  -9.84016200E-02  -4.75316000E-02  -5.76336400E-02  +4.89261220E-01
   +4.95168000E-03  -1.25675500E-02  +3.48185000E-03  +4.48306000E-03  +3.15199000E-03
   +2.64969800E-02  -4.24813000E-03  +8.03612000E-03  +6.20230000E-03  +4.12697000E-03
   -4.63313300E-02  -1.83950610E-01  +1.36739500E-02  +1.25802300E-02  +5.22993890E-01
   -1.71039490E-01  +1.85976590E-01  -2.47079600E-02  +5.35306000E-03  +1.81922300E-02
   +3.24987000E-02  -6.97461000E-03  +7.90044000E-03  -5.27039000E-03  +1.19450600E-02
   -8.46130000E-03  +3.94040000E-04  -6.24470300E-02  +2.69286200E-02  -4.65266000E-02
   +3.34048190E-01  +1.98632570E-01  -3.98737110E-01  +2.62221000E-03  +6.66557000E-03
   -3.05831900E-02  -3.60109600E-02  +6.66139000E-03  -9.06660000E-03  +6.74030000E-03
   -1.10330100E-02  +1.74977200E-02  -8.37554000E-03  +1.64524500E-02  -8.97026000E-02
   +3.26081600E-02  -2.62210050E-01  +6.77380860E-01  -4.19557000E-03  -2.05789300E-02
   -1.21057990E-01  +1.93938800E-02  -2.87475500E-02  +6.88594000E-03  -2.71177000E-03
   +4.95468000E-03  -1.84205000E-03  -1.47433500E-02  +5.25908000E-03  -3.85670100E-02
   -3.34039900E-02  +3.12085700E-02  -1.81059920E-01  +3.66745700E-02  +1.09540050E-01
   +5.93582770E-01  -5.51100000E-05  +6.17483000E-03  +5.36042000E-03  -1.00798800E-01
   +4.79807600E-02  +1.12044000E-03  -2.18412000E-03  +8.47659000E-03  -2.25411000E-03
   +3.45850000E-04  +5.54420000E-04  -2.01400000E-05  -3.29130000E-04  +8.84770000E-04
   +5.81980000E-04  +1.64011000E-03  -1.27824000E-03  -1.27637000E-03  +4.19497010E-01
   +1.41563400E-02  -7.93863000E-03  -4.67284000E-03  +6.07289000E-02  -1.10689730E-01
   -4.87200000E-03  +1.53039900E-02  -5.24667000E-03  +9.55050000E-04  +2.08396000E-03
   +9.30980000E-04  +4.74780000E-04  -1.91140000E-04  +2.41480000E-04  +2.82860000E-04
   +1.69053000E-03  +5.11590000E-04  -1.46539000E-03  -6.46610000E-03  +4.92766030E-01
   +2.08899000E-02  -1.63346900E-02  +4.38092000E-03  +6.80738000E-03  -7.91648000E-03
   -9.06090900E-02  -2.02827800E-02  +1.58011500E-02  +8.17079000E-03  -1.54724000E-03
   +3.82520000E-04  -5.31362000E-03  -6.76430000E-04  -5.60260000E-04  -1.26203000E-03
   +9.61100000E-05  -1.96284000E-03  -5.39778000E-03  +3.78168000E-03  -3.50548000E-03
   +4.99354420E-01  -4.03738000E-03  +3.07663000E-03  -1.68548000E-03  -1.27848000E-03
   +1.60875800E-02  +2.55101500E-02  -1.49816000E-03  +9.34010000E-04  -8.54000000E-04
   +5.18900000E-05  +8.45100000E-05  +1.16717000E-03  +2.14020000E-04  -4.10590000E-04
   +2.11800000E-05  +2.19000000E-06  +3.76760000E-04  +1.51234000E-03  -7.45532700E-02
   -5.49530000E-04  -1.93407000E-03  +5.91426900E-01  +3.12424000E-03  -1.53257000E-03
   +1.06929000E-03  +4.21736000E-03  -1.37789100E-02  -1.92347400E-02  +1.78800000E-04
   -1.04232000E-03  -3.16060000E-04  -1.55540000E-04  +9.83500000E-05  -6.29300000E-04
   +9.12500000E-05  +2.12220000E-04  -2.51880000E-04  -1.47500000E-04  +1.11370000E-04
   -9.98470000E-04  +1.68097000E-03  -1.03090630E-01  -4.29616000E-02  +2.85456000E-03
   +5.48328140E-01  -2.05188000E-03  +5.23520000E-04  +6.64370000E-04  +6.45466000E-03
   -5.81952000E-03  -1.70569000E-03  +3.86000000E-06  +1.57683000E-03  +8.16480000E-04
   +8.79100000E-05  -2.17730000E-04  -9.33550000E-04  -2.59660000E-04  -2.32370000E-04
   +3.98990000E-04  +2.57630000E-04  -1.51070000E-04  +3.21650000E-04  +2.50660000E-04
   -4.06225700E-02  -1.51604950E-01  -3.99700000E-04  -6.55908200E-02  +5.17349710E-01
   -1.25585000E-03  -3.47740000E-04  -1.58023000E-03  +4.61930000E-04  -7.30320000E-04
   -8.69020000E-04  -3.62040000E-04  -8.79530000E-04  +1.50287000E-03  +5.58059000E-03
   +5.14852000E-03  -2.32146000E-03  -8.17796600E-02  +2.92521100E-02  +8.92720000E-04
   +6.10721000E-03  +1.33797700E-02  +1.94090000E-04  +1.04310000E-04  +8.39600000E-05
   +8.21300000E-05  -4.56000000E-05  +7.52000000E-06  +1.75700000E-05  +5.16756010E-01
   +2.95731000E-03  -1.68450000E-03  +4.97280000E-03  -3.06253000E-03  +2.97631000E-03
   +1.10100000E-05  +1.65406000E-03  -2.39465000E-03  -5.60217000E-03  -2.75347000E-03
   -4.26766400E-02  -1.08903000E-03  -3.20746600E-02  -1.78029060E-01  +1.08341600E-02
   -1.74881000E-03  -3.96122500E-02  +6.61245000E-03  -3.61030000E-04  +1.71380000E-04
   +1.76650000E-04  +3.93510000E-04  -1.20010000E-04  -1.61800000E-05  -1.50259910E-01
   +4.15364590E-01  -2.54879000E-03  +2.62650000E-03  -1.41025000E-03  -7.08760000E-04
   -2.74820000E-04  -5.57365000E-03  +2.34196000E-03  -2.40835000E-03  -1.76096000E-03
   -1.41672000E-03  -2.85328700E-02  +5.27849000E-03  +3.64291000E-03  +7.87290000E-04
   -7.29035800E-02  +4.92770000E-04  +3.06836400E-02  +5.90480000E-04  -9.04200000E-05
   -7.87700000E-05  +3.34180000E-04  -3.51100000E-05  +9.44500000E-05  -8.80700000E-05
   -7.24246600E-02  +7.81442000E-03  +6.15694800E-02  -1.33676000E-03  +1.93863000E-03
   +1.56584000E-03  -3.30541700E-02  -7.35900000E-03  -3.62630000E-04  +1.55580000E-04
   +1.54145000E-03  -1.21652000E-03  +7.88660000E-04  -4.49700000E-04  +1.84590000E-04
   -5.97200000E-05  -1.93800000E-05  +3.54810000E-04  +4.90480000E-04  -1.25231000E-03
   -1.96100000E-04  -1.24866290E-01  -5.09003500E-02  -6.07935000E-03  -3.33958000E-03
   -5.67397000E-03  -7.09488000E-03  -7.98200000E-05  +1.50360000E-04  -8.01500000E-05
   +4.67686840E-01  +3.08490000E-03  -2.37816000E-03  -2.07289000E-03  -4.06985000E-03
   +1.48729600E-02  +2.57770000E-03  +6.62690000E-04  -1.92234000E-03  +5.29290000E-04
   -5.86150000E-04  +1.91730000E-04  +5.32560000E-04  +7.14170000E-04  +8.80630000E-04
   -5.50830000E-04  -1.06013000E-03  +1.08859000E-03  -4.43180000E-04  -3.21708700E-02
   -1.02327270E-01  +4.63391000E-03  -1.59043800E-02  -1.30554000E-02  -6.20737000E-03
   -1.10810000E-04  -4.56260000E-04  +1.00710000E-04  +1.71433730E-01  +3.86727800E-01
   +2.22658000E-03  -1.28769000E-03  -2.99500000E-04  +1.70150000E-03  +1.23732000E-03
   -6.66230000E-04  -4.25970000E-04  +6.93970000E-04  -7.05440000E-04  +5.57100000E-04
   -5.09230000E-04  -4.63800000E-05  -2.41210000E-04  -6.06100000E-05  -5.96780000E-04
   -2.21030000E-04  +8.89880000E-04  -1.21920000E-04  -9.18970000E-03  +2.64688000E-03
   -8.47016100E-02  -2.56823600E-02  -1.77494700E-02  -3.06546000E-03  +6.45500000E-05
   -6.06800000E-05  +1.68560000E-04  +1.17185920E-01  -1.33653020E-01  +6.00256770E-01
   -1.42034000E-03  -8.62700000E-05  +2.04200000E-05  -1.11149000E-03  -2.21258000E-03
   -6.91960000E-04  +6.56650000E-04  -1.77790000E-04  +1.09460000E-04  -3.13900000E-04
   +4.75900000E-04  -7.20400000E-05  +1.77020000E-04  +2.37410000E-04  +2.00030000E-04
   +1.19510000E-04  -1.72510000E-04  -1.22540000E-04  -1.62257200E-02  -4.07598000E-03
   -1.75344300E-02  -1.39354000E-03  +8.56500000E-05  +9.14370000E-04  -1.66000000E-06
   -7.23700000E-05  -9.00400000E-05  -1.73060910E-01  -4.31994000E-02  -8.26412700E-02
   +4.99526810E-01  +5.90840000E-04  -3.14520000E-04  -4.75470000E-04  -7.46350000E-04
   -2.50419000E-03  -4.83580000E-04  +2.39460000E-04  -1.46300000E-05  +2.58090000E-04
   -1.80250000E-04  +2.69350000E-04  -3.05000000E-05  +4.47400000E-05  +2.25680000E-04
   -1.58500000E-04  -1.45260000E-04  +3.80260000E-04  +1.19480000E-04  -1.24573800E-02
   +6.31800000E-04  -1.56915800E-02  -2.96875000E-03  -1.69600000E-03  -2.93000000E-06
   +1.71400000E-05  -1.48120000E-04  +2.55600000E-05  -1.71230900E-02  -9.66757000E-02
   +3.16867800E-02  +2.36731000E-01  +4.35400850E-01  +1.37809000E-03  -1.09385000E-03
   -1.24360000E-04  -3.17074000E-03  +7.10040000E-04  -3.28900000E-04  +5.91240000E-04
   -9.68860000E-04  +5.25600000E-04  -5.48730000E-04  +5.68990000E-04  +1.13970000E-04
   +2.35290000E-04  +6.29920000E-04  -1.38460000E-04  -4.57980000E-04  +7.80530000E-04
   -3.31700000E-04  -2.25300000E-03  -3.44536000E-03  +4.38651000E-03  +1.29321000E-03
   +8.85440000E-04  -7.64300000E-05  +1.18400000E-05  -4.06610000E-04  +7.41400000E-05
   -1.30565600E-01  -1.01405700E-02  -2.49973250E-01  +1.08865420E-01  -1.80046380E-01
   +6.40322970E-01  +3.54240000E-04  +1.59830000E-04  +3.91700000E-05  +1.90874000E-03
   -3.03400000E-05  -5.26900000E-05  -7.02390000E-04  +6.29120000E-04  -2.53700000E-04
   +4.22950000E-04  -5.86880000E-04  -7.22400000E-05  -1.78340000E-04  -3.69750000E-04
   -3.12460000E-04  +1.71600000E-05  +1.60060000E-04  +1.60890000E-04  +2.64515000E-03
   -1.50046000E-03  -4.02338000E-03  -1.85257000E-03  -7.65210000E-04  +1.07460000E-04
   +2.32600000E-05  +2.01490000E-04  +7.71900000E-05  -3.10022000E-02  -2.26673000E-03
   -5.41480900E-02  -2.39554330E-01  -1.49644990E-01  +2.76208000E-03  +5.20462500E-01
   +4.20500000E-05  +7.80420000E-04  +4.00150000E-04  +1.92976000E-03  -1.58035000E-03
   -4.11080000E-04  -7.06630000E-04  +1.01885000E-03  -3.19120000E-04  +5.53890000E-04
   -5.98150000E-04  -1.55640000E-04  -4.19080000E-04  -6.28560000E-04  -1.43570000E-04
   +3.13500000E-04  -1.29500000E-04  +1.72140000E-04  -2.30224000E-03  +3.50609000E-03
   +2.08081000E-03  +2.20500000E-04  +1.98880000E-04  +1.51680000E-04  +7.00000000E-05
   +3.53780000E-04  +7.41700000E-05  -2.37146600E-02  +1.88889400E-02  -5.66758100E-02
   -1.22919120E-01  -1.79151430E-01  +3.47286200E-02  +2.42939020E-01  +4.09699990E-01
   -2.62900000E-05  -1.73960000E-04  -2.31510000E-04  -8.10770000E-04  -5.25430000E-04
   -6.49540000E-04  +2.15810000E-04  -3.32860000E-04  +2.32380000E-04  -1.31470000E-04
   +1.19960000E-04  +7.88800000E-05  +1.73500000E-05  +2.98170000E-04  -2.14380000E-04
   -1.39870000E-04  +1.43420000E-04  +6.02600000E-05  -3.94014000E-03  +2.27685000E-03
   -2.16572000E-03  +2.44140000E-04  +1.61570000E-04  -2.55210000E-04  +2.66800000E-05
   -2.22580000E-04  +8.46900000E-05  -1.54613200E-02  -2.26957400E-02  +2.76699500E-02
   -4.82122500E-02  -8.97292000E-03  -1.19181490E-01  +1.57984050E-01  -1.50197400E-01
   +6.37981040E-01  +8.82380000E-04  -8.27300000E-04  -4.15410000E-04  -2.28523000E-03
   +6.92420000E-04  +1.61080000E-04  +5.84200000E-04  -5.13240000E-04  +5.18300000E-05
   -3.20820000E-04  +3.62220000E-04  +9.96100000E-05  -2.12390000E-04  +9.55890000E-04
   -2.62250000E-04  -6.02770000E-04  +7.35460000E-04  +3.04000000E-05  -1.15038000E-03
   -3.38530000E-04  -1.98460000E-04  +3.79220000E-04  +1.48830000E-04  -4.20320000E-04
   +1.12400000E-04  -8.65150000E-04  +3.85300000E-05  -2.61377000E-03  +1.20081700E-02
   -1.69954700E-02  +7.45924000E-03  -1.26363700E-02  +3.16752100E-02  -1.16301820E-01
   -5.89506000E-02  +3.56931700E-02  +5.30124880E-01  +3.48950000E-04  -7.06180000E-04
   -3.95050000E-04  -2.65828000E-03  +1.14525000E-03  +8.62000000E-06  +6.73860000E-04
   -9.30300000E-04  +3.49990000E-04  -5.24190000E-04  +5.23940000E-04  +1.81070000E-04
   +1.08360000E-04  +9.75220000E-04  -5.93600000E-05  -4.63050000E-04  +3.82730000E-04
   -3.80400000E-05  +5.34300000E-05  -6.37110000E-04  +5.08950000E-04  +7.31780000E-04
   +1.96530000E-04  -2.07500000E-04  +4.63000000E-06  -7.50600000E-04  +1.82000000E-06
   +1.20128500E-02  -9.22510000E-03  +2.40523700E-02  -3.64247600E-02  -3.11388700E-02
   +2.86835000E-03  -2.59211600E-02  -1.62915150E-01  +1.30962300E-01  +2.29918920E-01
   +4.39087820E-01  +2.56080000E-04  +1.12900000E-05  +1.13900000E-04  +1.18739000E-03
   -2.09430000E-04  +1.48600000E-04  -7.06950000E-04  +7.87880000E-04  -3.72030000E-04
   +3.72900000E-04  -5.69160000E-04  -1.50940000E-04  -3.43000000E-04  -2.78970000E-04
   -1.93330000E-04  -4.53200000E-05  +1.19920000E-04  +1.00890000E-04  -1.18675000E-03
   -3.15300000E-05  -1.75711000E-03  -7.82500000E-04  -3.45560000E-04  +2.30970000E-04
   +8.48800000E-05  +3.32900000E-05  +1.52700000E-05  -1.59747800E-02  +2.43863800E-02
   -7.50207900E-02  +7.36353100E-02  +4.02688500E-02  +4.33197900E-02  -2.38035600E-02
   +8.15195900E-02  -2.53511370E-01  +1.35289730E-01  -1.49239670E-01  +6.42150320E-01
   -1.35560000E-04  +2.74310000E-04  -1.88800000E-05  +4.14270000E-04  +1.29600000E-04
   -1.72490000E-04  +1.85530000E-04  -1.50220000E-04  +1.61260000E-04  -8.85100000E-05
   +2.03690000E-04  +2.92200000E-05  +1.86620000E-04  -1.77320000E-04  +2.07220000E-04
   +1.85710000E-04  -1.60790000E-04  -5.68600000E-05  +5.07041000E-03  -1.11514000E-03
   -3.68880000E-04  +2.37460000E-04  +1.01880000E-04  +7.38600000E-05  -5.73300000E-05
   +2.45150000E-04  -3.94000000E-05  +5.21210000E-03  -3.71730400E-02  +6.31773400E-02
   -4.61033600E-02  -2.06140800E-02  -2.94292400E-02  +4.08783300E-02  +4.14733300E-02
   -2.64996600E-02  -1.61627770E-01  -3.51677000E-02  -7.18998400E-02  +5.13280740E-01
   -2.97460000E-04  +4.78150000E-04  +2.31910000E-04  +6.48500000E-04  -1.33359000E-03
   +1.47400000E-05  +5.22780000E-04  -1.07400000E-04  -1.88800000E-05  -2.43000000E-04
   +4.47120000E-04  -9.29900000E-05  -4.50600000E-05  -1.44660000E-04  +4.44090000E-04
   +1.31500000E-04  -2.88600000E-04  +3.09100000E-05  -1.61221000E-03  +2.21824000E-03
   +3.94244000E-03  +4.97420000E-04  +4.36140000E-04  +2.70480000E-04  +7.51400000E-05
   +1.35760000E-04  -1.05030000E-04  -1.59327400E-02  -2.46707400E-02  +3.62400300E-02
   -2.11548900E-02  -1.31101900E-02  -1.49727200E-02  +2.35865500E-02  +2.47665300E-02
   +5.86566000E-03  -3.81756000E-03  -1.00454920E-01  +4.65990100E-02  +2.56920680E-01
   +4.51350340E-01  -4.54590000E-04  +5.65490000E-04  +1.35300000E-04  +1.51500000E-04
   -3.14600000E-05  -4.05020000E-04  -3.22400000E-05  -1.20130000E-04  -2.83200000E-05
   +5.01700000E-05  -3.56800000E-05  +1.52200000E-04  +1.09060000E-04  -4.05400000E-04
   +3.60700000E-05  +2.73990000E-04  -3.64640000E-04  +1.33400000E-04  -7.18770000E-04
   +3.82136000E-03  -3.58165000E-03  -2.97320000E-04  -4.25070000E-04  -3.71870000E-04
   -1.40600000E-05  +4.05060000E-04  -2.46600000E-05  +2.51989700E-02  +3.93274000E-03
   +3.80365700E-02  -2.67229300E-02  -1.28440500E-02  -2.07103600E-02  +6.50665000E-03
   +3.32082400E-02  -4.20715000E-02  -1.28121870E-01  -7.91980000E-04  -2.63065250E-01
   +1.14983120E-01  -1.87312730E-01  +6.35578530E-01  -1.72290000E-04  -1.33000000E-06
   +7.59800000E-05  -1.36630000E-04  -2.71541000E-03  +1.67736000E-03  -2.99514000E-03
   +9.19470000E-04  +1.45210000E-04  +2.77430000E-04  -1.05405000E-03  -1.48560000E-04
   -1.90680000E-04  -4.58000000E-05  -2.31520000E-04  +6.17100000E-05  +1.08600000E-05
   -1.05300000E-05  -6.86773000E-03  -1.58634900E-02  +1.95171900E-02  +7.28600000E-05
   -2.80510000E-04  +1.32429000E-03  -7.38000000E-06  -4.33900000E-05  +3.93500000E-05
   -1.15152120E-01  -3.28790200E-02  -9.19738000E-03  +4.06322700E-02  +2.37543400E-02
   +6.47491000E-03  -2.50484900E-02  -2.63676600E-02  +1.54145600E-02  -3.54221900E-02
   -6.14560000E-04  -5.59891300E-02  -2.47694460E-01  -1.58071730E-01  +3.30220000E-03
   +5.35265190E-01  +1.13731000E-03  -6.24100000E-04  -4.20840000E-04  -7.43700000E-04
   -1.24712000E-03  +9.76700000E-05  +2.09610000E-04  -1.07420000E-04  -8.34000000E-06
   +1.10040000E-04  +1.01710000E-04  +3.83300000E-05  -1.17090000E-04  +3.50240000E-04
   -4.94360000E-04  -2.56040000E-04  +8.69650000E-04  -2.00900000E-05  -8.65067000E-03
   -1.25610800E-02  +1.21572100E-02  -1.22109000E-03  -1.94490000E-04  +3.11400000E-04
   +2.44200000E-05  -2.88010000E-04  +1.37220000E-04  -5.98532600E-02  -1.64503950E-01
   +8.22147100E-02  +4.47282200E-02  +2.47876800E-02  +3.88474700E-02  -2.97623500E-02
   -3.87888200E-02  +1.97605300E-02  -2.35609600E-02  +1.85661400E-02  -6.66593500E-02
   -1.28558470E-01  -1.89831560E-01  +3.79011300E-02  +2.30846820E-01  +4.17829670E-01
   -3.66680000E-04  +4.38860000E-04  -9.36900000E-05  +1.73499000E-03  -9.82380000E-04
   +1.43861000E-03  +4.05910000E-04  +9.08710000E-04  -2.87160000E-04  +1.05880000E-04
   +3.24610000E-04  -4.13750000E-04  -1.62960000E-04  -5.88600000E-05  +8.09630000E-04
   +1.53750000E-04  -4.05190000E-04  -8.57600000E-05  +4.98007000E-03  +4.50450000E-04
   +6.96103000E-03  -5.60620000E-04  -5.05110000E-04  +4.02960000E-04  -1.36000000E-05
   +2.34400000E-05  -2.37160000E-04  +3.84434800E-02  +1.21807250E-01  -2.29849330E-01
   -3.17950000E-02  +6.91841000E-03  -5.24734300E-02  +1.98724700E-02  +2.33541600E-02
   -1.59150300E-02  -1.40914700E-02  -3.06518400E-02  +3.61991400E-02  -4.74260900E-02
   -5.02308000E-03  -1.21860440E-01  +1.60245140E-01  -1.40667680E-01  +6.30318830E-01
   -9.38730000E-04  +1.16310000E-03  +5.61680000E-04  +2.98227000E-03  -1.55440000E-03
   -1.89320000E-04  -7.81270000E-04  +8.76790000E-04  -2.32410000E-04  +5.11530000E-04
   -5.24660000E-04  -1.44680000E-04  +3.37100000E-05  -1.17270000E-03  +2.29140000E-04
   +7.32620000E-04  -8.09440000E-04  +4.81500000E-05  +4.21380000E-04  +9.38030000E-04
   -1.23310000E-04  -7.93360000E-04  -2.45560000E-04  +4.93630000E-04  -7.06700000E-05
   +9.57820000E-04  -4.63200000E-05  -3.34083000E-03  -3.47429000E-03  +2.66550000E-03
   +3.49264000E-03  -2.09618000E-03  -1.64279000E-03  -1.46253900E-02  -2.18785300E-02
   +1.86331000E-03  -2.09574160E-01  -1.40363400E-01  +7.18225000E-03  -3.53791000E-02
   -2.94695400E-02  -1.20490800E-02  +5.58253000E-03  +3.11247000E-03  -4.19419000E-03
   +3.92201960E-01  -7.14620000E-04  +9.60490000E-04  +4.98080000E-04  +2.31530000E-03
   -1.34658000E-03  -9.92000000E-05  -7.08850000E-04  +7.91450000E-04  -2.25330000E-04
   +4.55980000E-04  -4.67480000E-04  -1.32530000E-04  -7.73800000E-05  -1.11583000E-03
   +1.72030000E-04  +5.88500000E-04  -6.29010000E-04  +3.26000000E-06  +8.97650000E-04
   +2.33570000E-04  -5.87760000E-04  -7.47770000E-04  -2.36250000E-04  +3.99290000E-04
   +1.56100000E-05  +9.11240000E-04  -2.43600000E-05  -2.77203000E-03  -2.64305000E-03
   -1.93167000E-03  +1.26441000E-03  +5.65058000E-03  +6.68774000E-03  -3.74685400E-02
   -2.31047600E-02  +4.09787000E-03  -1.21595810E-01  -1.65281760E-01  +3.62445700E-02
   -1.39648700E-02  -3.91810000E-04  -7.36321000E-03  -2.61880000E-04  +3.04006000E-03
   +3.28718000E-03  +1.82161320E-01  +2.12159260E-01  -1.05490000E-04  +1.12840000E-04
   +2.17500000E-05  +8.25200000E-05  -3.20000000E-06  -1.10110000E-04  -4.88500000E-05
   -2.88600000E-05  +3.91600000E-05  +3.12500000E-05  -3.53100000E-05  +2.75900000E-05
   +2.01900000E-05  -9.77400000E-05  -4.79100000E-05  +6.19000000E-05  -6.76400000E-05
   +1.08600000E-05  +4.95960000E-04  -1.68550000E-04  +1.89000000E-04  +1.43800000E-05
   +9.19000000E-06  -2.95300000E-05  -1.90000000E-06  +1.01200000E-04  +3.91900000E-05
   +1.53789000E-03  -2.79528000E-03  +6.16566000E-03  -8.05905000E-03  +8.34510000E-04
   -6.43269000E-03  +2.97430900E-02  +2.72762700E-02  +5.84086000E-03  -3.04911500E-02
   +5.03496000E-03  -1.02343070E-01  -3.97459000E-02  -3.05790300E-02  +2.84709000E-03
   +1.29679000E-03  +8.23412000E-03  -7.58005000E-03  +2.34301920E-01  -6.07505700E-02
   +5.20396930E-01  +2.51480000E-04  +3.64310000E-04  +4.48960000E-04  -4.26167000E-03
   +1.85064900E-02  -2.26937200E-02  -4.29982000E-03  +3.16783000E-03  +2.41676000E-03
   -5.03680000E-04  -1.71700000E-05  -1.35704000E-03  -2.66950000E-04  -6.98280000E-04
   -1.24910000E-04  +1.71590000E-04  -2.77840000E-04  -4.60560000E-04  -7.30906200E-02
   +3.28754000E-03  -1.38103000E-03  +4.42910000E-04  -7.20930000E-04  +1.11806000E-03
   +4.06400000E-05  +2.87630000E-04  +8.37900000E-05  -8.68640000E-04  -2.00578300E-02
   +2.09903000E-02  -1.44292000E-03  -1.32874000E-03  -4.46300000E-04  +2.17140000E-04
   -2.61750000E-04  +8.58230000E-04  +3.80660000E-04  -1.95700000E-05  +1.58940000E-04
   -4.25270000E-04  -4.96990000E-04  +1.15506000E-03  -3.77355000E-03  -2.59436000E-03
   -2.03964000E-03  -4.67320000E-04  -3.08630000E-04  -3.48700000E-05  +5.91371750E-01
   +1.85980000E-04  -5.56200000E-04  -9.33690000E-04  +5.08009000E-03  -1.46508900E-02
   +1.48875900E-02  +1.47467000E-03  -1.64716000E-03  -1.12861000E-03  +6.70200000E-05
   +3.36300000E-04  +6.30020000E-04  +3.22270000E-04  +2.80500000E-04  -2.09900000E-05
   -1.19200000E-05  +2.44780000E-04  +7.63530000E-04  +1.48495000E-03  -1.21238630E-01
   +4.92319800E-02  -1.87410000E-04  +9.98652000E-03  -8.50180000E-03  -4.35900000E-05
   -1.04730000E-04  -3.60100000E-05  -4.77898000E-03  -1.85215900E-02  +1.57675700E-02
   -2.22580000E-04  -9.93050000E-04  -3.96800000E-05  +4.73310000E-04  -2.44540000E-04
   +7.78530000E-04  -6.14300000E-05  +3.64100000E-05  -5.57500000E-05  -5.08900000E-05
   -3.86200000E-05  +9.98040000E-04  -2.08853000E-03  -1.33426000E-03  -1.37969000E-03
   -3.94400000E-05  -7.81000000E-06  +3.55700000E-05  +6.14665000E-03  +5.26365350E-01
   +1.18455000E-03  -1.05756000E-03  +3.92470000E-04  -8.17589000E-03  +5.29722000E-03
   +2.26987000E-03  +2.32265000E-03  -7.26710000E-04  -7.10100000E-05  -2.82550000E-04
   +3.77120000E-04  +5.03360000E-04  +4.23550000E-04  +2.71990000E-04  +5.03470000E-04
   -4.99340000E-04  +3.51340000E-04  -1.09976000E-03  +1.50081000E-03  +4.52344400E-02
   -1.32036250E-01  +1.54704000E-03  +1.80578000E-02  -3.76172000E-02  -3.78600000E-05
   -3.09600000E-05  -9.36900000E-05  +3.25562000E-03  +2.32551000E-03  +8.57310000E-04
   -3.97110000E-04  -1.45589000E-03  +3.56470000E-04  -2.66910000E-04  -3.68150000E-04
   -1.65660000E-04  +2.29890000E-04  +3.61560000E-04  -2.72400000E-05  -2.21980000E-04
   -1.10990000E-04  +1.98990000E-04  -1.69528000E-03  -3.52040000E-04  +7.33100000E-05
   -4.26800000E-04  -3.10880000E-04  -4.27900000E-05  -1.83884000E-03  +6.56097000E-02
   +5.39944970E-01  -1.84854000E-03  +6.66830000E-03  -3.19326000E-03  -8.16038000E-03
   -1.11925900E-02  -1.96732000E-03  +1.48574000E-03  +2.41836000E-03  +5.04791000E-03
   -4.26147700E-02  +6.85926000E-03  +2.30945600E-02  -2.90271750E-01  -2.19283700E-02
   +3.25358500E-02  -5.36049000E-02  +2.45020000E-03  -6.67599000E-03  +1.03877000E-03
   +4.96540000E-04  -1.14600000E-04  -4.79980000E-04  +1.62970000E-04  -5.61400000E-05
   -3.46539900E-02  -3.85141200E-02  +9.60225000E-03  +8.71800000E-05  +2.01380000E-04
   +6.95700000E-05  +1.02020000E-04  +1.84580000E-04  +2.88720000E-04  -1.23550000E-04
   -1.37800000E-04  +2.02960000E-04  +7.68440000E-04  +5.00230000E-04  +4.98600000E-05
   -2.25510000E-04  +7.87200000E-05  -2.59340000E-04  +1.91000000E-06  +2.79030000E-04
   +4.81500000E-05  -8.03400000E-04  -5.45940000E-04  -5.87100000E-05  -4.45130000E-04
   +7.97700000E-05  -1.45670000E-04  +4.28473540E-01  +8.70190000E-04  +6.26500000E-04
   -1.42209000E-03  -2.09086000E-03  -6.82920000E-04  -9.80350000E-04  +1.85398000E-03
   -6.95480000E-04  +1.43593000E-03  +1.03538200E-02  +5.99479000E-03  +1.16560000E-03
   +9.94597000E-03  -9.22889800E-02  -1.86758000E-03  +7.12649000E-03  +5.27673000E-03
   -3.41077000E-03  +1.60350000E-04  +3.22010000E-04  +2.40540000E-04  +2.68000000E-06
   -9.54800000E-05  +7.52100000E-05  -7.02560100E-02  -1.66588500E-02  +1.19322400E-02
   +1.28960000E-04  -4.55940000E-04  -1.77000000E-06  -7.11500000E-05  -5.94700000E-05
   -2.81520000E-04  +1.51060000E-04  +3.06550000E-04  -1.21720000E-04  -4.08450000E-04
   -4.32140000E-04  +1.05120000E-04  +8.54600000E-05  +1.12800000E-04  +1.88230000E-04
   +4.82000000E-05  -1.38380000E-04  +7.27100000E-05  +5.13840000E-04  +5.09910000E-04
   +4.69600000E-05  +1.86790000E-04  -1.76940000E-04  -1.78480000E-04  +4.41027100E-02
   +1.37277500E-01  -7.31464000E-03  +1.61764600E-02  +8.31130000E-03  -2.89723000E-03
   -9.90290000E-04  -2.72277000E-02  +9.45059000E-03  -1.54894300E-02  +5.35271000E-03
   +2.93387900E-02  +8.08926000E-03  +5.84030000E-04  +3.15747100E-02  +3.04204000E-03
   -7.68800900E-02  -1.27802500E-02  -9.28438000E-03  +1.38823200E-02  -6.94490000E-04
   -2.37750000E-04  +6.61050000E-04  -2.44500000E-05  +1.40880000E-04  -1.62390000E-04
   +1.01698600E-02  +6.58535000E-03  +1.35158700E-02  -2.92320000E-04  +3.78900000E-04
   +5.36970000E-04  -1.94580000E-04  +8.32800000E-05  +3.39800000E-05  +2.83840000E-04
   +1.65210000E-04  +9.11100000E-05  +1.22800000E-04  -5.55900000E-05  +2.16970000E-04
   -1.60620000E-04  -3.34550000E-04  -6.81500000E-05  +2.37720000E-04  +3.63010000E-04
   -4.84680000E-04  -8.22500000E-05  -4.06700000E-05  +3.31800000E-05  +9.63100000E-05
   -7.84300000E-05  -3.15120000E-04  -5.77923800E-02  -2.36224000E-03  +5.46875200E-02
   +1.06420000E-04  -6.44300000E-05  -4.84500000E-05  -3.90500000E-04  +8.25800000E-05
   -3.09900000E-05  +1.28260000E-04  -1.23480000E-04  +3.81600000E-05  -7.18300000E-05
   +8.73600000E-05  +2.46000000E-05  -6.47600000E-05  +9.67200000E-05  -3.33600000E-05
   -6.79600000E-05  +8.68900000E-05  +6.91000000E-06  -6.56800000E-05  -7.05700000E-05
   +1.01330000E-04  +1.00020000E-04  +1.82300000E-05  -4.62700000E-05  +4.99900000E-05
   -8.06600000E-05  +2.31600000E-05  +5.38490000E-04  +2.01000000E-05  +6.31120000E-04
   -9.36600000E-04  +2.27200000E-05  -4.63830000E-04  +2.73112000E-03  +3.05025000E-03
   +2.45370000E-04  -2.41516400E-02  +3.52160000E-04  -3.49444700E-02  -2.55782000E-03
   -5.13871000E-03  +1.68564000E-03  +4.38700000E-04  +7.88400000E-05  -1.91710000E-03
   -1.37829840E-01  -1.17365100E-02  -1.92759400E-01  +6.09600000E-05  +2.65400000E-05
   +3.47500000E-05  +1.70420000E-04  -2.88500000E-05  +6.56000000E-06  +1.61890630E-01
   +8.31700000E-05  -1.07460000E-04  -9.05000000E-05  -2.30260000E-04  +1.59310000E-04
   +5.22500000E-05  +9.90700000E-05  -8.35700000E-05  +2.54900000E-05  -5.65300000E-05
   +6.17600000E-05  +1.47000000E-05  +1.49400000E-05  +1.75260000E-04  -1.34000000E-05
   -7.14400000E-05  +7.52200000E-05  +2.24900000E-05  +7.52500000E-05  -5.38400000E-05
   +8.37100000E-05  +7.34600000E-05  +2.19500000E-05  -4.67000000E-06  -1.36600000E-05
   -1.53070000E-04  -1.10700000E-05  +1.97020000E-04  -1.80450000E-04  +6.20920000E-04
   -1.12170000E-04  -6.32420000E-04  -2.95470000E-04  +4.34120000E-04  +5.40650000E-04
   -2.14907000E-03  -1.77422600E-02  -2.26973000E-03  -2.91700400E-02  -4.55827000E-03
   -2.13171000E-03  +1.36924000E-03  -5.37100000E-04  +1.67849000E-03  -6.69590000E-04
   +7.84066000E-03  -2.63857200E-02  +5.54828000E-02  +7.82000000E-06  +1.13400000E-05
   -1.10000000E-07  +5.69900000E-05  -8.71700000E-05  -5.75000000E-06  +1.41371800E-02
   +3.02006900E-02  +8.51300000E-05  -1.33850000E-04  -5.39300000E-05  -2.47330000E-04
   +1.52590000E-04  +3.25600000E-05  +4.33100000E-05  -6.44100000E-05  +1.22900000E-05
   -3.67900000E-05  +3.02300000E-05  +9.94000000E-06  +1.73000000E-05  +9.06900000E-05
   -9.79000000E-06  -7.27900000E-05  +7.63500000E-05  -8.00000000E-06  -7.34600000E-05
   -7.79500000E-05  -2.84000000E-06  +7.07000000E-05  +4.31500000E-05  -5.21200000E-05
   -2.20000000E-06  -7.49100000E-05  -1.37300000E-05  +3.05090000E-04  +3.09290000E-04
   +7.77500000E-05  -2.94250000E-04  -6.97300000E-05  -1.02655000E-03  +5.18833000E-03
   +1.97593000E-03  +3.31919000E-03  +6.48600000E-04  +3.50020000E-04  -2.15509000E-03
   +6.63880000E-04  +5.40690000E-04  +2.33875000E-03  -6.67080000E-04  +3.19590000E-04
   +2.02500000E-05  -2.31267390E-01  +2.35170000E-02  -4.22112670E-01  +2.48900000E-05
   -8.21000000E-06  +4.62400000E-05  +4.43300000E-05  -4.65500000E-05  -6.60000000E-07
   +2.25861090E-01  -2.67267200E-02  +4.20108400E-01  -1.18830000E-04  +1.75650000E-04
   +5.82500000E-05  +2.79910000E-04  -3.82740000E-04  -1.34880000E-04  -5.40800000E-05
   +6.83600000E-05  +1.13600000E-05  +4.29300000E-05  -3.20700000E-05  -3.11000000E-06
   -3.52800000E-05  -1.03970000E-04  -1.40800000E-05  +7.93700000E-05  -8.26200000E-05
   +1.37100000E-05  -8.29800000E-05  +1.23930000E-04  -1.05206000E-03  -3.75890000E-04
   -1.71410000E-04  +5.26400000E-05  +1.06800000E-05  +8.32200000E-05  +2.26800000E-05
   -3.74810000E-04  -5.62411000E-03  -4.40440000E-04  -1.00566900E-02  +1.46968000E-03
   -2.13137400E-02  -1.38625400E-01  -1.43993300E-02  -1.34521560E-01  +4.71497000E-03
   -2.59391000E-03  +5.47594000E-03  +2.58926000E-03  -2.80502000E-03  +4.41130000E-04
   -6.43320000E-04  -2.09560000E-04  +8.85810000E-04  +1.01062000E-03  +3.07047000E-03
   +2.04319000E-03  -2.87400000E-05  +1.20930000E-04  -4.51800000E-05  -3.53200000E-05
   +5.83700000E-05  +1.53000000E-05  +7.64400000E-05  +1.00950000E-04  -9.47450000E-04
   +1.42671520E-01  -3.18600000E-05  +2.26500000E-05  +1.43800000E-05  +3.93010000E-04
   -2.69750000E-04  -3.50000000E-06  -6.87200000E-05  +1.29540000E-04  -6.02900000E-05
   +5.88400000E-05  -6.04800000E-05  -3.17200000E-05  -7.22000000E-06  -4.70600000E-05
   +6.59000000E-06  +2.24900000E-05  -1.47700000E-05  +1.95400000E-05  -6.96790000E-04
   +4.04410000E-04  -6.15540000E-04  -1.02250000E-04  +1.85100000E-05  +7.72800000E-05
   -9.40000000E-06  +2.39800000E-05  -1.51500000E-05  -5.65789000E-03  +1.36654000E-03
   +2.01269000E-03  -1.09604700E-02  +2.77310000E-03  -1.77099300E-02  -1.41202500E-02
   -4.68212700E-02  +3.65656000E-03  +1.03922700E-02  +4.51289000E-03  +1.52868400E-02
   -2.99655000E-03  +6.18710000E-04  +4.45462000E-03  -2.99280000E-04  -1.23226000E-03
   +7.45700000E-05  +3.28645000E-03  -4.13170000E-04  -1.39442000E-03  +1.08880000E-04
   +3.30200000E-05  -7.08000000E-05  -4.62600000E-05  +1.55700000E-05  +6.87000000E-06
   -1.06931000E-03  -3.24990000E-04  -9.62600000E-05  +1.87401200E-02  +4.13214000E-02
   -4.31300000E-05  +4.54800000E-05  +3.92600000E-05  +1.72450000E-04  -9.23600000E-05
   -2.01500000E-05  -5.39600000E-05  +5.73100000E-05  -1.90000000E-05  +3.56900000E-05
   -3.88300000E-05  -1.30600000E-05  +1.18700000E-05  -5.90000000E-05  +6.16000000E-06
   +3.34700000E-05  -3.76300000E-05  -5.28000000E-06  -5.08000000E-06  +2.08850000E-04
   +5.86900000E-05  -2.06000000E-06  +5.60200000E-05  +2.96100000E-05  -9.42000000E-06
   +5.07200000E-05  +1.22000000E-06  -8.58760000E-04  +1.45327000E-03  +3.00744000E-03
   +9.98120000E-04  +7.59760000E-04  +2.33877000E-03  -1.34796640E-01  +3.60831000E-03
   -2.44110360E-01  -1.81786000E-02  -4.51683000E-03  -1.51848200E-02  +8.84280000E-04
   +4.88632000E-03  -1.99894000E-03  +1.16587000E-03  +4.96500000E-04  -2.56500000E-05
   +1.53422000E-03  -1.87876000E-03  +1.77271000E-03  -1.92200000E-05  -2.75100000E-05
   -3.11800000E-05  -5.57200000E-05  +2.38500000E-05  +2.72000000E-06  +1.14260000E-03
   +1.70737000E-03  -7.49610000E-04  +1.47746270E-01  -4.69147000E-03  +2.55815350E-01
   +3.38700000E-05  -1.32000000E-06  -2.11810000E-04  -1.11270000E-04  -2.25210000E-04
   -2.50280000E-04  +3.24400000E-05  -8.47000000E-06  +6.83300000E-05  +1.21400000E-05
   -1.16500000E-05  +2.06000000E-05  -6.19800000E-05  +8.13100000E-05  -1.27180000E-04
   +2.00400000E-05  +3.32900000E-05  +1.81610000E-04  -1.03522000E-03  +1.86033000E-03
   +1.14848000E-03  +5.05920000E-04  +1.73300000E-05  +1.33850000E-04  +1.26200000E-05
   -1.04210000E-04  +4.63600000E-05  +8.55343000E-03  +1.07896500E-02  -1.30346500E-02
   -6.12296900E-02  -3.78242600E-02  +3.47434800E-02  -8.09760000E-04  -1.49492900E-02
   +2.04516600E-02  -6.39820000E-04  -5.63861000E-03  -2.53619000E-03  -1.27056000E-03
   +1.40710000E-04  -2.74110000E-04  +2.56550000E-04  -2.57858000E-03  -4.87686000E-03
   -5.36860000E-04  -9.94260000E-04  +1.03113000E-03  -1.98153000E-03  -2.08277000E-03
   -1.40800000E-03  +9.27200000E-05  -3.64300000E-05  +5.31200000E-05  +1.51750000E-04
   +8.11800000E-05  +1.51440000E-04  -9.47870000E-04  +2.28542000E-03  +1.02602000E-03
   +6.18780000E-02  -9.45300000E-05  -3.05110000E-04  +3.62800000E-05  -1.76700000E-04
   +8.80060000E-04  +4.42470000E-04  +1.38080000E-04  -2.38180000E-04  -5.69900000E-05
   -8.13500000E-05  +7.19400000E-05  +3.84600000E-05  +1.51260000E-04  +4.48500000E-05
   +1.16440000E-04  -8.16000000E-05  -1.87300000E-05  -1.34700000E-04  +1.92243000E-03
   -2.22930000E-03  -6.92640000E-04  -3.54480000E-04  -2.63840000E-04  -2.13200000E-05
   -2.95000000E-05  +1.69300000E-05  -5.86900000E-05  -3.41900000E-05  +4.15730000E-03
   -9.88430000E-04  -3.74853100E-02  -1.43474710E-01  +1.37397760E-01  -3.08191000E-03
   -7.50303000E-03  +1.67130700E-02  -5.82165000E-03  +2.69244000E-03  +6.84890000E-04
   +2.39260000E-04  -5.99560000E-04  -8.39300000E-04  -2.55741000E-03  +3.86446000E-03
   +8.68750000E-04  -3.55640000E-04  -9.12590000E-04  +7.64900000E-04  -2.94092000E-03
   -1.62251000E-03  -1.06187000E-03  -5.49500000E-05  -4.56900000E-05  -6.74400000E-05
   +1.53950000E-04  +6.43500000E-05  +1.14520000E-04  +2.10151000E-03  -1.73878000E-03
   -1.58864000E-03  +4.98606700E-02  +1.49320290E-01  -5.75500000E-05  -5.40000000E-06
   -2.07060000E-04  +2.78110000E-04  +3.68120000E-04  +9.61000000E-06  +4.70700000E-05
   -1.33140000E-04  +3.27900000E-05  -1.55000000E-06  -2.06200000E-05  +5.21500000E-05
   +3.14900000E-05  +6.01600000E-05  -9.84800000E-05  -4.81000000E-06  -8.53000000E-06
   +1.14290000E-04  +2.18479000E-03  +1.33420000E-04  -7.44420000E-04  -3.25670000E-04
   -1.51620000E-04  +6.84600000E-05  -1.62300000E-05  -5.92000000E-05  +2.54200000E-05
   +6.23497000E-03  +1.54111500E-02  -1.47582000E-02  +3.47679300E-02  +1.36280980E-01
   -2.37852740E-01  -1.97235000E-03  -1.72428000E-03  +4.26408000E-03  -2.33117000E-03
   +8.82860000E-04  +2.66834000E-03  -2.64690000E-04  -9.73500000E-04  +1.10430000E-04
   -5.23930000E-03  +6.23600000E-04  -2.49115000E-03  +1.68450000E-04  +2.63700000E-05
   +5.45600000E-05  +3.31200000E-04  +6.54150000E-04  +2.88810000E-04  -4.57000000E-06
   -4.79100000E-05  +4.57100000E-05  -3.00000000E-05  -1.60500000E-05  -3.30900000E-05
   +1.34223000E-03  -1.34109000E-03  +1.30990000E-04  -3.62567100E-02  -1.49891580E-01
   +2.48219820E-01  -4.68900000E-05  +1.23610000E-04  -7.38600000E-05  -2.94000000E-06
   -6.54280000E-04  +4.08370000E-04  -1.81170000E-03  +9.94100000E-05  +6.35340000E-04
   -4.58530000E-04  +7.24500000E-05  -1.00450000E-04  -2.27400000E-05  +1.35240000E-04
   +1.99550000E-04  +4.85300000E-05  -9.05000000E-06  +1.10600000E-05  -1.52968000E-03
   +1.19091000E-03  +3.90840000E-04  -5.84720000E-04  -6.82750000E-04  -1.53570000E-04
   +1.83200000E-05  -1.35020000E-04  -3.61700000E-05  +7.94794000E-03  +2.76570000E-04
   +5.12345000E-03  +2.47216000E-03  -3.21503000E-03  +3.38740000E-04  -6.25930000E-04
   -4.81300000E-05  +8.35530000E-04  +4.50800000E-04  -6.06196000E-03  -7.26750000E-04
   -9.96132000E-03  +2.99430000E-04  -2.16866500E-02  -1.44107710E-01  -8.01989000E-03
   -1.37269860E-01  -7.87690000E-04  -5.97000000E-06  -1.18226000E-03  +1.57020000E-04
   +1.97500000E-04  +6.77700000E-05  +1.21960000E-04  -3.13700000E-05  -1.49140000E-04
   -3.33070000E-04  -9.75800000E-05  +3.39400000E-05  -2.48890000E-04  +2.98850000E-04
   +1.00550000E-04  +2.96040000E-04  -7.17500000E-05  +4.05100000E-04  +1.50722840E-01
   +1.07810000E-04  -2.00120000E-04  -2.53100000E-05  -4.31050000E-04  +6.41240000E-04
   +5.00700000E-05  +8.82000000E-05  +1.22070000E-04  +3.76300000E-04  +3.40100000E-05
   -8.19900000E-05  -1.37890000E-04  +9.47700000E-05  +1.25490000E-04  -7.40300000E-05
   -8.06800000E-05  +4.40900000E-05  -8.12400000E-05  +2.04646000E-03  -9.82200000E-04
   -9.66660000E-04  -4.72360000E-04  -1.14131000E-03  +7.06520000E-04  -5.82800000E-05
   -1.25980000E-04  +5.16600000E-05  +1.14514100E-02  +4.86271000E-03  +1.44840200E-02
   -3.33071000E-03  +7.86160000E-04  +4.78780000E-03  -8.43600000E-05  -1.22555000E-03
   -5.13200000E-05  -6.21617000E-03  +1.88476000E-03  +2.42048000E-03  -1.27748600E-02
   +4.09076000E-03  -1.70073000E-02  -7.53616000E-03  -4.98589100E-02  +7.52163000E-03
   -4.87950000E-04  +3.11500000E-05  -1.00924000E-03  +7.60500000E-05  -2.08850000E-04
   -1.87970000E-04  -4.81400000E-05  -9.84200000E-05  +6.45700000E-05  -1.38650000E-04
   -3.18340000E-04  -1.19440000E-04  +3.19670000E-04  -3.00620000E-04  -2.09930000E-04
   +5.62200000E-04  +2.62760000E-04  +8.80080000E-04  +1.58523000E-02  +4.60833600E-02
   +4.99100000E-05  -1.21460000E-04  -1.10010000E-04  +1.26700000E-05  +8.38780000E-04
   -7.01060000E-04  -6.46750000E-04  +2.60610000E-04  +1.76240000E-04  +2.33070000E-04
   -7.02890000E-04  +1.00320000E-04  +3.48500000E-05  -2.34860000E-04  -4.98600000E-04
   -8.33700000E-05  +1.22780000E-04  +2.30300000E-05  +3.21680000E-04  -1.76599000E-03
   -8.47740000E-04  -3.41220000E-04  -3.74770000E-04  -2.87240000E-04  -2.58100000E-05
   +1.84590000E-04  +1.09540000E-04  -1.50822800E-02  -2.05581000E-03  -1.47178200E-02
   +6.42770000E-04  +5.09480000E-03  -1.94006000E-03  +9.21930000E-04  -4.56300000E-05
   +2.86290000E-04  -1.08285000E-03  +2.45795000E-03  +2.93608000E-03  +4.10590000E-04
   +1.69850000E-03  +2.69848000E-03  -1.36834070E-01  +6.77344000E-03  -2.48336010E-01
   -2.28150000E-04  -1.70880000E-04  -1.09390000E-04  +3.85100000E-05  -4.19000000E-05
   +7.50100000E-05  -1.90290000E-04  +8.58400000E-05  +3.77760000E-04  +1.17140000E-04
   -5.66700000E-05  +4.14000000E-06  +8.55200000E-05  -2.42810000E-04  -1.46190000E-04
   -8.02870000E-04  -1.01930000E-04  -8.54840000E-04  +1.51245300E-01  -8.61744000E-03
   +2.59922510E-01  -5.76300000E-05  +8.83500000E-05  +2.37400000E-05  +2.60520000E-04
   -3.16010000E-04  +7.42800000E-05  -1.25460000E-04  +1.54520000E-04  -6.84000000E-05
   +4.31100000E-05  -6.65300000E-05  -2.30700000E-05  -8.79300000E-05  -1.59230000E-04
   +5.42000000E-05  +3.48600000E-05  -3.70800000E-05  +1.03000000E-05  +2.40180000E-04
   -5.52410000E-04  +7.96780000E-04  +4.09600000E-05  +7.46600000E-05  +1.49580000E-04
   +5.60100000E-05  +1.01310000E-04  -4.86700000E-05  -6.14410000E-04  -5.47903000E-03
   -2.34512000E-03  -1.30081000E-03  -4.30700000E-05  -4.48720000E-04  -1.71280000E-04
   -2.37612000E-03  -4.28795000E-03  +8.40988000E-03  +1.09349000E-02  -1.46722900E-02
   -6.22019300E-02  -4.31761500E-02  +3.71738700E-02  -4.93380000E-04  -1.41078700E-02
   +2.00093600E-02  -1.12460000E-04  +1.75214000E-03  +1.82875000E-03  -3.28970000E-04
   -1.68250000E-04  -4.37500000E-05  +4.12300000E-05  +8.43600000E-05  -2.64100000E-05
   -2.81100000E-05  +2.06340000E-04  +3.65660000E-04  +2.01850000E-04  +6.77670000E-04
   -7.74460000E-04  -2.06400000E-04  +2.83540000E-04  +2.28290000E-04  -9.67760000E-04
   +2.43997000E-03  +1.27370000E-03  +5.74740200E-02  -5.23500000E-05  +4.31000000E-05
   +7.48000000E-06  +3.10500000E-04  -2.03440000E-04  +3.96900000E-05  +2.88200000E-05
   +4.27500000E-05  -5.58000000E-06  +1.44400000E-05  +1.51600000E-05  -1.52600000E-05
   +1.12400000E-05  +1.66900000E-05  +3.78400000E-05  +3.79200000E-05  -3.53600000E-05
   -8.10000000E-07  -6.03500000E-05  -5.14200000E-05  +9.05710000E-04  -2.64400000E-05
   +2.47200000E-05  -2.78700000E-05  -2.49800000E-05  -1.55000000E-05  -7.76000000E-06
   -5.75469000E-03  +2.63457000E-03  +5.12860000E-04  +2.43940000E-04  -3.39460000E-04
   -6.64810000E-04  -2.17550000E-03  +3.12537000E-03  +7.57300000E-04  -1.95375000E-03
   +4.38812000E-03  -1.33348000E-03  -4.25937600E-02  -1.51495380E-01  +1.40688060E-01
   -2.09263000E-03  -7.56212000E-03  +1.53777500E-02  +1.86498000E-03  -1.23214000E-03
   -9.95030000E-04  -2.12260000E-04  -5.89500000E-05  -1.54640000E-04  -4.72800000E-05
   -8.26000000E-06  -2.44300000E-05  +2.40570000E-04  -2.51400000E-04  -1.29940000E-04
   +9.32900000E-05  +6.75300000E-05  -2.19120000E-04  +2.94730000E-04  -3.59730000E-04
   -1.25960000E-04  +2.21593000E-03  -1.91064000E-03  -1.73780000E-03  +4.96720200E-02
   +1.53332520E-01  +1.61600000E-05  -5.04700000E-05  -3.66100000E-05  -2.24400000E-05
   +5.52100000E-05  +2.23700000E-05  +8.73900000E-05  -6.08900000E-05  +2.83500000E-05
   -2.52300000E-05  +5.58400000E-05  +7.38000000E-06  +4.60500000E-05  +1.37630000E-04
   +1.44000000E-06  -1.61900000E-05  +2.03400000E-05  -7.65000000E-06  -2.32800000E-04
   -2.12800000E-05  +2.49010000E-04  +3.62900000E-05  +5.73000000E-06  -4.27600000E-05
   -4.37200000E-05  -9.32700000E-05  +6.42000000E-06  -2.25475000E-03  +1.00715000E-03
   +2.66031000E-03  -6.73040000E-04  -1.08042000E-03  -6.55500000E-05  -4.66622000E-03
   +4.55110000E-04  -2.35822000E-03  +8.17082000E-03  +1.82382100E-02  -1.48415400E-02
   +3.64229400E-02  +1.39478080E-01  -2.28715460E-01  -1.54371000E-03  -2.80468000E-03
   +5.56049000E-03  +1.61059000E-03  -1.21551000E-03  +1.19037000E-03  +5.41000000E-06
   +9.60000000E-07  -2.88000000E-05  -1.70500000E-05  -6.25900000E-05  -9.09000000E-06
   +2.84720000E-04  -2.01190000E-04  +2.40610000E-04  +3.21390000E-04  +6.66210000E-04
   -8.88900000E-04  +2.03900000E-04  -1.51720000E-04  -1.17080000E-04  +1.50517000E-03
   -1.40257000E-03  -6.72700000E-05  -3.92245700E-02  -1.52911940E-01  +2.37230140E-01
   -1.73100000E-05  -1.40110000E-04  +3.21800000E-05  +6.41630000E-04  +7.19230000E-04
   +1.96400000E-04  +7.23200000E-05  -3.16480000E-04  +7.56000000E-06  -8.31700000E-05
   +7.70000000E-05  +7.91000000E-05  +1.98800000E-05  +8.41000000E-05  +6.32000000E-06
   -1.42040000E-04  +8.82700000E-05  -7.97100000E-05  -2.17640000E-04  +1.46898000E-03
   +3.11710000E-04  +5.40450000E-04  +1.81990000E-04  -4.27840000E-04  +1.44400000E-05
   -4.06600000E-05  -5.20000000E-06  +3.17180000E-04  -1.97680000E-04  -1.12800000E-05
   +3.68000000E-06  -2.19780000E-04  -3.12010000E-04  +2.42520000E-04  -5.08700000E-05
   +9.92600000E-05  +1.71360000E-04  +6.77200000E-05  +1.77930000E-04  -2.28120000E-04
   -1.03210000E-04  -2.48600000E-05  +3.43560000E-04  +7.20800000E-05  -3.91160000E-04
   -2.21590000E-04  -1.45260000E-04  +6.95000000E-06  -1.82417430E-01  -1.33574300E-01
   -3.18952100E-02  +6.37400000E-05  -3.03900000E-05  -6.86000000E-06  +4.13100000E-05
   +1.82100000E-05  +9.72000000E-06  -8.33000000E-06  -1.87100000E-05  -2.42800000E-05
   -2.52910000E-04  -4.10000000E-06  +4.70370000E-04  +3.45700000E-05  -3.68700000E-05
   +6.30000000E-05  -3.95200000E-05  +2.31100000E-05  +1.77000000E-05  +2.01157580E-01
   +1.97090000E-04  +5.92200000E-05  -2.49980000E-04  -3.34725000E-03  -1.39818000E-03
   +1.33160000E-04  +2.69570000E-04  +2.93330000E-04  -6.97000000E-05  +6.14900000E-05
   -9.97000000E-06  +6.67000000E-06  -1.42450000E-04  -7.84700000E-05  -7.23500000E-05
   +1.29010000E-04  -6.89400000E-05  +1.68260000E-04  -1.48765200E-02  -1.60071200E-02
   -3.22496000E-03  -3.38700000E-05  +6.85240000E-04  -1.73285000E-03  +4.87600000E-05
   +7.67900000E-05  +8.23000000E-06  +1.34143000E-03  -1.88281000E-03  +3.06866000E-03
   +2.82310000E-04  +4.17370000E-04  +4.66160000E-04  -1.15910000E-04  -6.39600000E-05
   +5.03500000E-05  +2.02470000E-04  +1.05810000E-04  -5.87900000E-05  -2.80400000E-05
   -9.89900000E-05  +3.57800000E-04  -1.04656000E-03  -4.77690000E-04  -5.26460000E-04
   -2.07150000E-04  -1.59080000E-04  -1.81500000E-05  -1.32012430E-01  -1.77790610E-01
   -3.33395800E-02  +2.08800000E-04  +2.00160000E-04  +3.19000000E-05  +2.85100000E-05
   +1.49100000E-05  +1.29900000E-05  -5.01400000E-05  +8.90000000E-07  -2.55000000E-06
   +2.80730000E-04  +4.44500000E-05  -7.02000000E-05  +5.96300000E-05  -7.23000000E-06
   +5.60600000E-05  -7.86300000E-05  -7.65700000E-05  -1.17700000E-05  +1.43448170E-01
   +1.91659390E-01  +4.49300000E-05  -5.98700000E-05  -4.21170000E-04  +1.17579000E-03
   -5.97300000E-04  +2.47770000E-04  -1.10660000E-04  +3.68700000E-05  -1.92200000E-05
   +7.49000000E-05  -7.81600000E-05  -4.56700000E-05  -9.72600000E-05  -1.50900000E-05
   -7.49400000E-05  +1.08170000E-04  -4.18500000E-05  +2.29650000E-04  +1.69830100E-02
   +1.67594900E-02  +2.07368000E-03  +1.27063000E-03  +1.34661000E-03  +6.12530000E-04
   +1.86400000E-05  -3.76900000E-05  +2.13600000E-05  -1.14977000E-03  +3.09779000E-03
   -3.77218000E-03  -5.91480000E-04  -1.29200000E-05  -9.30200000E-04  +7.78800000E-05
   -5.10600000E-05  +3.62630000E-04  -2.00470000E-04  -7.44300000E-05  -1.10740000E-04
   +1.81600000E-04  +7.41000000E-05  -2.89390000E-04  +1.04383000E-03  +8.15190000E-04
   +5.80900000E-04  +1.25440000E-04  +4.88100000E-05  +6.76500000E-05  -3.41275600E-02
   -3.61812900E-02  -5.59671100E-02  +6.24400000E-05  +1.71700000E-05  +2.20500000E-05
   +1.55000000E-06  +1.80900000E-05  -1.15100000E-05  +2.10200000E-05  +1.60900000E-05
   -1.56000000E-06  +9.12200000E-05  -4.08200000E-04  +4.26930000E-04  -7.36400000E-05
   +4.88200000E-05  +5.03900000E-05  +1.12490000E-04  +4.46800000E-05  -6.71000000E-06
   +3.68379400E-02  +3.38818400E-02  +6.14697700E-02  -5.02200000E-04  +8.12970000E-04
   -9.67000000E-05  +6.22460000E-04  +3.09000000E-05  -5.79250000E-04  +9.15400000E-05
   -8.33600000E-05  +1.11420000E-04  -1.21600000E-05  +1.69200000E-05  +4.03300000E-05
   +9.70000000E-07  +1.37810000E-04  -9.78800000E-05  -9.17700000E-05  +1.42000000E-05
   +1.50200000E-05  -2.16292000E-03  -1.58410000E-04  -1.66090000E-03  -3.30600000E-05
   +4.41690000E-04  -3.66630000E-04  -1.14300000E-05  -1.00160000E-04  +2.39100000E-05
   +2.77570000E-04  +1.83060000E-04  +1.55760000E-04  -2.25900000E-04  -2.69990000E-04
   +9.01820000E-04  -4.93100000E-05  +1.20340000E-04  -3.04810000E-04  +3.29400000E-05
   -2.24900000E-05  +2.40300000E-05  +1.75400000E-05  +4.48600000E-05  -5.47300000E-05
   -7.79800000E-05  -3.12200000E-05  -1.40580000E-04  +5.29200000E-05  +6.71300000E-05
   -5.24200000E-05  -5.33010200E-02  +1.50455800E-02  +3.69563900E-02  +4.76000000E-05
   -7.71700000E-05  +5.08500000E-05  -2.59300000E-05  -2.48800000E-05  +8.04000000E-06
   -1.85300000E-05  -1.79000000E-06  +2.46200000E-05  -2.09922000E-03  -1.10078000E-03
   +6.22300000E-05  +3.87000000E-06  +4.05500000E-05  -4.95900000E-05  -4.61000000E-06
   +3.35000000E-06  -5.92000000E-06  +4.90647000E-03  -8.53963000E-03  -2.18215000E-02
   +5.53862400E-02  +7.24880000E-04  -1.71853000E-03  +7.99750000E-04  +4.52060000E-04
   +1.02330000E-03  -7.88820000E-04  -2.03360000E-04  +4.65700000E-05  -3.62600000E-05
   -5.52600000E-05  -8.00000000E-07  -7.88800000E-05  +1.47400000E-04  -8.30200000E-05
   +1.89350000E-04  -2.27700000E-05  -7.48100000E-05  -2.10880000E-04  -3.90871000E-03
   +1.16669500E-02  +1.89664100E-02  +8.59900000E-05  -2.84070000E-03  +2.64571000E-03
   -3.77400000E-05  +1.10810000E-04  -5.83200000E-05  +2.07430000E-04  +5.42960000E-04
   -3.06620000E-04  -6.95960000E-04  -1.33080000E-04  -4.33540000E-04  -4.79800000E-05
   -1.08900000E-04  +1.51260000E-04  -1.08330000E-04  -1.13600000E-05  -1.45460000E-04
   +1.01330000E-04  +5.62700000E-05  +3.48200000E-05  +8.72900000E-05  -1.63940000E-04
   +2.76600000E-05  +5.58600000E-05  +1.39700000E-05  +2.71100000E-05  +1.61575200E-02
   -9.17608400E-02  -9.80694100E-02  -1.57860000E-04  +1.28000000E-06  -7.72300000E-05
   -8.24000000E-06  +4.84000000E-06  -6.17000000E-06  -1.20700000E-05  +1.00400000E-05
   +1.47000000E-06  -1.46993000E-03  -6.52310000E-04  +3.39090000E-04  -5.22000000E-06
   +5.90100000E-05  -6.70000000E-07  -8.76000000E-06  +1.05400000E-05  +1.21700000E-05
   +5.61707000E-03  -8.54282000E-03  -1.88636800E-02  -1.88435600E-02  +1.01065420E-01
   -3.21060000E-04  -9.45100000E-04  -6.58390000E-04  +1.26169000E-03  -1.16781000E-03
   -7.94790000E-04  -2.24410000E-04  +6.64200000E-05  +6.71200000E-05  +1.14930000E-04
   -8.35500000E-05  +5.63100000E-05  -4.78700000E-05  +8.36600000E-05  -6.56680000E-04
   +5.20500000E-05  +1.98500000E-05  +1.02837000E-03  +2.36050000E-03  -1.14378700E-02
   -1.85060200E-02  +4.28670000E-04  +4.82532000E-03  -3.39140000E-03  +1.83500000E-05
   -1.31830000E-04  +1.34170000E-04  -6.98560000E-04  -4.31840000E-04  +1.03320000E-04
   -7.04240000E-04  +1.34710000E-04  -3.57560000E-04  +2.10990000E-04  +1.36000000E-06
   +4.13440000E-04  -5.40100000E-05  -1.57270000E-04  +1.81700000E-05  -5.55600000E-05
   -6.16700000E-05  +3.78300000E-05  +1.12620000E-04  +2.93380000E-04  +3.54900000E-05
   +5.41300000E-05  +2.55800000E-05  +6.04700000E-05  +3.69752300E-02  -9.59236000E-02
   -2.68703440E-01  +2.60220000E-04  -2.22400000E-05  +3.69040000E-04  +1.44100000E-05
   +8.67000000E-06  -1.30600000E-05  +1.88400000E-05  +3.43100000E-05  -3.32000000E-06
   +1.27020000E-04  -2.65910000E-04  +6.62240000E-04  -2.51000000E-06  -1.43240000E-04
   +6.50900000E-05  +2.90400000E-05  +3.32000000E-06  -8.72000000E-06  +9.84680000E-04
   -1.39517000E-03  -3.72666000E-03  -3.99765700E-02  +1.07503990E-01  +2.92091080E-01
   +7.11200000E-05  +5.54400000E-05  +1.68000000E-05  -3.37000000E-04  -1.37562000E-03
   +2.79000000E-06  +1.80210000E-04  +2.80510000E-04  +1.00310000E-04  +7.52100000E-05
   -6.42800000E-05  -1.30320000E-04  -2.70100000E-05  -1.50470000E-04  +5.88700000E-05
   +1.21940000E-04  -7.23800000E-05  +1.39000000E-06  -5.70390000E-04  -3.43970000E-04
   +8.13990000E-04  -1.68380000E-04  -1.69310000E-04  +3.62860000E-04  +7.79000000E-06
   +1.25370000E-04  -2.21900000E-05  +4.44790000E-04  -8.38860000E-04  +1.37270000E-04
   -3.74460000E-04  -1.25958000E-03  -5.05170000E-04  +1.53520000E-04  +1.41000000E-06
   +1.10610000E-04  -1.19800000E-04  -5.78900000E-05  +8.88200000E-05  -4.66300000E-05
   -2.52000000E-06  +1.71200000E-05  +3.12430000E-04  +4.08700000E-05  -7.33700000E-05
   +7.19600000E-05  +5.94700000E-05  +2.24800000E-05  -2.62707190E-01  +1.12237710E-01
   -2.44760000E-04  -2.63400000E-05  +1.21630000E-04  -1.66200000E-05  -4.48000000E-06
   +3.11000000E-06  -1.03000000E-05  +4.35600000E-05  -2.05900000E-05  -2.36400000E-05
   -3.36660000E-04  -1.02151000E-03  -1.70300000E-05  +1.04700000E-05  -1.30100000E-05
   -3.07000000E-06  -1.46400000E-05  +4.82700000E-05  +1.80800000E-05  -1.87270000E-02
   +1.07039500E-02  +8.04900000E-04  -3.27237000E-03  +6.03310000E-04  -4.57680000E-04
   +2.84300320E-01  +9.30300000E-05  -1.15050000E-04  +7.88200000E-05  -1.41466000E-03
   -2.13138000E-03  +4.03708000E-03  +1.20663000E-03  -6.72930000E-04  -6.13690000E-04
   +8.38600000E-05  +6.09000000E-05  +4.09330000E-04  +8.69900000E-05  +3.25620000E-04
   -5.07900000E-05  -1.03690000E-04  +7.43000000E-05  +1.34610000E-04  +1.98950300E-02
   -1.30566700E-02  +1.29070000E-04  -2.49560000E-04  +8.39000000E-06  -1.16390000E-03
   -1.00600000E-05  -1.62350000E-04  -9.80000000E-07  +9.00640000E-04  +1.00667000E-03
   -7.08470000E-04  -2.58200000E-04  -4.88020000E-04  +4.14030000E-04  -3.81230000E-04
   -3.37500000E-05  -1.84800000E-04  -1.78550000E-04  -8.55000000E-06  -3.11880000E-04
   +3.22130000E-04  +2.00070000E-04  +3.44900000E-05  -2.75190000E-04  -1.52140000E-04
   +2.86860000E-04  +1.99040000E-04  +1.63850000E-04  -9.64000000E-06  +1.09662030E-01
   -1.01729230E-01  +3.08000000E-05  +2.53210000E-04  -5.25000000E-05  +7.61000000E-06
   -3.94800000E-05  -3.71100000E-05  -9.20000000E-06  +1.89200000E-05  -3.37600000E-05
   +1.28400000E-05  -4.84460000E-04  -1.48463000E-03  -9.52390000E-04  +2.65700000E-05
   +2.72000000E-05  -1.03680000E-04  +2.43600000E-05  -3.80000000E-06  -1.32400000E-05
   -2.05165600E-02  +1.14729100E-02  +6.36030000E-04  +1.11663100E-02  -6.32145000E-03
   +3.73850000E-04  -1.19173890E-01  +1.12076060E-01  -3.13560000E-04  -2.60300000E-04
   -2.43620000E-04  +1.24420000E-03  +1.23550000E-03  -4.40006000E-03  -1.33882000E-03
   +9.28160000E-04  +5.30930000E-04  -1.53700000E-05  -1.38470000E-04  -3.78630000E-04
   -8.99600000E-05  -1.23510000E-04  -3.38230000E-04  +7.13200000E-05  -9.18600000E-05
   +4.69530000E-04  -2.13532600E-02  +1.21238100E-02  -1.45972000E-03  -1.16153000E-03
   +8.32580000E-04  +8.85040000E-04  +9.43000000E-06  +1.10400000E-05  +6.71300000E-05
   -3.47720000E-04  -9.23520000E-04  +8.50070000E-04  +1.08920000E-04  -2.47150000E-04
   +7.32320000E-04  +9.76500000E-05  +1.51950000E-04  -1.79600000E-04  +1.31430000E-04
   -4.41200000E-05  +2.05940000E-04  -1.69530000E-04  -5.94900000E-05  -9.40500000E-05
   +9.04300000E-05  -5.15600000E-05  -3.26950000E-04  -5.57300000E-05  -1.77300000E-05
   -5.56500000E-05  +1.17628000E-03  -1.28572000E-03  -4.66910700E-02  +2.61400000E-05
   +3.13300000E-05  +2.03830000E-04  -5.55000000E-06  -1.18600000E-05  +1.38200000E-05
   -2.05500000E-05  +1.50900000E-05  +1.42700000E-05  -1.18480000E-04  -6.26250000E-04
   -3.08530000E-04  -2.13400000E-05  +3.53800000E-05  -6.18000000E-06  -2.74400000E-05
   +1.48500000E-05  +5.61000000E-06  -5.45009000E-03  +3.07126000E-03  -7.36130000E-04
   +2.69286900E-02  -1.26509300E-02  +7.96620000E-04  +9.94400000E-05  -2.05594000E-03
   +5.09766900E-02  -9.92800000E-05  +2.21530000E-04  -8.38300000E-05  +2.12900000E-04
   -9.82970000E-04  +4.79810000E-04  -6.07650000E-04  +7.70060000E-04  +6.92440000E-04
   -5.28500000E-05  -7.02300000E-05  -4.32140000E-04  -5.22800000E-05  +1.27350000E-04
   +3.48650000E-04  +8.24100000E-05  -8.87800000E-05  -7.84000000E-06  -2.21972000E-03
   -1.45110000E-04  -5.84680000E-04  -5.11090900E-02  -2.12719400E-02  +2.90418400E-02
   +2.57000000E-06  -1.36880000E-04  -8.30600000E-05  +1.47200000E-05  +5.12590000E-04
   -3.47430000E-04  -2.08700000E-05  -3.92200000E-05  +3.45300000E-05  +9.41300000E-05
   +2.76200000E-05  +2.24100000E-05  -9.81400000E-05  -8.67400000E-05  +5.41000000E-06
   -1.26600000E-04  -2.44500000E-05  +2.33300000E-05  -5.37120000E-04  -8.59560000E-04
   -5.34340000E-04  +8.16500000E-05  +7.13900000E-05  +2.31100000E-05  +6.66700000E-05
   -3.27490000E-04  -5.19680000E-04  +1.42440000E-04  -1.51500000E-05  -2.05790000E-04
   -1.27300000E-05  -1.59500000E-05  -7.61000000E-06  +7.72000000E-06  +8.76000000E-06
   +1.09600000E-05  +3.43000000E-05  +8.27000000E-06  +3.89000000E-05  +1.41950000E-04
   -1.40207000E-03  -3.47970000E-04  +2.60300000E-05  -2.54400000E-05  -1.18400000E-05
   +7.96400000E-05  +3.65160000E-04  -9.67300000E-05  +6.22120000E-04  +7.06200000E-05
   -1.59170000E-04  +2.97650000E-04  -2.33520000E-04  +3.21490000E-04  +5.36549600E-02
   -1.89620000E-04  +9.27300000E-05  +1.09700000E-05  +2.65750000E-04  +2.80300000E-04
   +8.21520000E-04  +1.06590000E-03  -6.24470000E-04  +4.35580000E-04  +1.39350000E-04
   -2.84110000E-04  -4.61880000E-04  -1.05870000E-04  -1.12160000E-04  +9.20300000E-05
   +3.42600000E-05  -2.09300000E-05  +4.72700000E-05  +1.87315000E-03  +1.15746400E-02
   -1.40305900E-02  -2.15481600E-02  -1.41829540E-01  +1.30045050E-01  +6.13000000E-06
   -3.39000000E-06  -3.67100000E-05  +4.46300000E-05  +8.12910000E-04  +9.62110000E-04
   -8.02200000E-05  +5.10900000E-05  +3.91000000E-05  +1.23490000E-04  +5.50800000E-05
   -7.30400000E-05  -1.33720000E-04  -1.30800000E-05  +1.20960000E-04  +9.22900000E-05
   -7.90600000E-05  +1.92000000E-05  -9.61950000E-04  -1.82628000E-03  -1.16352000E-03
   +1.16970000E-04  +9.41500000E-05  +8.90000000E-06  -8.16100000E-05  -1.51547000E-03
   -2.42034000E-03  -8.55000000E-06  +5.80400000E-05  +3.63900000E-05  -1.55800000E-05
   -5.61000000E-06  -4.88000000E-06  +2.09800000E-05  +3.94000000E-06  +3.14000000E-06
   +3.61300000E-05  +3.05000000E-06  +2.73400000E-05  -1.46148000E-03  -2.98191000E-03
   -9.09510000E-04  +2.93100000E-05  -3.21600000E-05  -2.66000000E-05  +3.12800000E-04
   +9.36800000E-05  -2.14880000E-04  -2.79100000E-05  +8.25280000E-04  -8.15250000E-04
   -2.17620000E-04  +8.85000000E-06  -1.98180000E-04  +2.21408000E-02  +1.58311530E-01
   +1.03860000E-04  -2.94450000E-04  +9.28000000E-06  -6.09070000E-04  +1.54891000E-03
   -4.09670000E-04  -6.23370000E-04  -2.04900000E-05  -3.99010000E-04  +6.95000000E-05
   +2.16400000E-05  +7.92080000E-04  +1.34240000E-04  +8.64700000E-05  -4.85560000E-04
   -1.13590000E-04  +7.06600000E-05  +4.54500000E-05  +2.20212000E-03  +1.70555200E-02
   -1.92511500E-02  +2.79794900E-02  +1.26367820E-01  -2.24885980E-01  -3.81600000E-05
   +9.70200000E-05  +1.27510000E-04  +1.24726000E-03  +1.13329000E-03  +6.32580000E-04
   -5.35080000E-04  -8.86000000E-05  -2.13400000E-04  +3.52350000E-04  +2.37840000E-04
   +3.67900000E-05  +1.32570000E-04  -1.26360000E-04  +2.74690000E-04  -3.45620000E-04
   -3.01220000E-04  +4.71510000E-04  -1.80270000E-04  +9.73170000E-04  -4.99260000E-04
   +7.56600000E-05  +9.82000000E-06  +4.90300000E-05  +6.11890000E-04  -4.18336000E-03
   -4.70767000E-03  -9.35200000E-05  -4.72300000E-05  +2.44630000E-04  +8.50000000E-07
   -8.09000000E-06  -5.71000000E-06  +1.53300000E-05  -2.38900000E-05  -1.19200000E-05
   +1.27190000E-04  +5.12800000E-05  +1.36250000E-04  +1.71680000E-04  -8.61760000E-04
   +1.02146000E-03  -5.03200000E-05  +6.96000000E-06  -5.94000000E-06  -2.96300000E-05
   -2.48210000E-04  +2.49480000E-04  -1.70880000E-04  +1.19306000E-03  -1.46429000E-03
   -8.71100000E-05  -6.03200000E-05  +2.17420000E-04  -3.01603200E-02  -1.39740120E-01
   +2.43244800E-01  +1.26240000E-04  -2.32100000E-04  -4.96000000E-06  +2.39940000E-04
   +5.59420000E-04  -3.15170000E-04  +1.92620000E-04  +3.51900000E-05  -2.69100000E-05
   -1.95100000E-05  +4.49900000E-05  +1.19850000E-04  -2.33500000E-05  +2.15500000E-05
   -7.54900000E-05  -7.37500000E-05  +4.79100000E-05  -4.46900000E-05  +7.34850000E-04
   +8.48480000E-04  +5.76810000E-04  -2.47840660E-01  -1.18340170E-01  -2.26885000E-02
   +1.22800000E-05  -3.33200000E-05  +1.42400000E-05  +5.19660000E-04  -6.96600000E-05
   -2.77200000E-05  +5.56170000E-04  +1.08100000E-05  +2.78060000E-04  -1.39450000E-04
   -1.64330000E-04  +1.15160000E-04  +1.65500000E-04  +2.05560000E-04  -1.24560000E-04
   +2.43100000E-05  +3.54100000E-05  -1.86600000E-05  +1.15140000E-04  +1.70110000E-04
   -2.50650000E-04  -2.05130000E-04  -1.68960000E-04  -9.40000000E-06  -1.53230000E-04
   +1.09890000E-04  +2.06570000E-04  +1.42300000E-05  -2.50000000E-05  +4.82100000E-05
   +2.78800000E-05  +1.53100000E-05  +1.93700000E-05  -1.95800000E-05  +5.14000000E-06
   +2.93000000E-06  -1.52800000E-05  +3.04800000E-05  -4.04700000E-05  -4.78500000E-05
   +3.77100000E-05  +2.86200000E-05  -1.31000000E-05  -3.84000000E-06  +5.97000000E-06
   +3.03770000E-04  +2.05750000E-04  -4.09530000E-04  +2.23120000E-04  +2.05820000E-04
   +1.42000000E-06  +1.42000000E-05  -1.09220000E-04  +5.55900000E-05  -1.78901000E-03
   +1.75910000E-04  -2.76860000E-04  +2.66406320E-01  +1.05220000E-04  +1.39660000E-04
   +2.59000000E-06  -2.09619000E-03  -5.73590000E-04  +1.74380000E-04  +2.77640000E-04
   +5.08800000E-05  -4.75370000E-04  +2.00720000E-04  +4.26600000E-05  +3.34760000E-04
   -1.34510000E-04  -1.98280000E-04  -2.40250000E-04  -8.92000000E-06  +5.30300000E-05
   +5.53900000E-05  -1.43742700E-02  -1.02326300E-02  -1.42547000E-03  -1.15926640E-01
   -1.16427600E-01  -1.19464700E-02  +3.77100000E-05  +1.64720000E-04  +4.30800000E-05
   +6.21900000E-05  -1.12844000E-03  -3.38320000E-03  -7.84700000E-05  -6.99110000E-04
   +3.23470000E-04  -4.35450000E-04  -8.94800000E-05  -2.50900000E-05  +1.58680000E-04
   +2.20420000E-04  -2.63470000E-04  +1.50910000E-04  +4.36800000E-05  -1.09670000E-04
   -1.56990000E-04  -8.75300000E-05  -2.21590000E-04  -2.93210000E-04  -2.23410000E-04
   -3.67000000E-06  +5.15940000E-04  +8.00400000E-05  +1.03224000E-03  -2.01400000E-05
   +1.47850000E-04  +1.77110000E-04  +3.24800000E-05  +2.94500000E-05  +2.41600000E-05
   -1.18120000E-04  -8.82000000E-06  +1.19500000E-05  +5.58500000E-05  +5.88000000E-06
   -8.85700000E-05  -9.21300000E-05  +3.48930000E-04  -8.91900000E-05  -1.35400000E-05
   -2.91400000E-05  +1.07200000E-05  +1.09600000E-05  +5.52480000E-04  +1.98520000E-04
   +1.48440000E-04  -1.81800000E-05  -8.80000000E-07  +7.80800000E-05  +6.04800000E-05
   +4.49600000E-05  -1.56495500E-02  -9.37568000E-03  -2.82280000E-03  +1.28768430E-01
   +1.24618290E-01  +1.21800000E-05  +4.03290000E-04  -7.65100000E-05  -1.46880000E-03
   -7.51640000E-04  +1.30743000E-03  -4.44500000E-05  +1.24600000E-04  +1.43790000E-04
   +1.51470000E-04  -1.72270000E-04  -1.51730000E-04  -1.04800000E-04  -9.15500000E-05
   +8.24200000E-05  +6.30100000E-05  +5.24000000E-06  +4.71000000E-05  -2.37377400E-02
   -1.37798000E-02  -3.69006000E-03  -2.03294900E-02  -1.04171500E-02  -5.05169400E-02
   +2.00900000E-05  +7.06400000E-05  -2.11000000E-05  +1.08084000E-03  -1.85042000E-03
   -4.73838000E-03  -6.04460000E-04  -9.35950000E-04  +2.49140000E-04  -3.97180000E-04
   +1.51690000E-04  +1.28410000E-04  +2.73930000E-04  +1.91370000E-04  -8.47800000E-05
   -3.03690000E-04  +5.52000000E-06  +1.28700000E-04  -6.34200000E-05  +6.26880000E-04
   -2.85260000E-04  -3.01530000E-04  -3.08690000E-04  -1.00000000E-06  -1.13768000E-03
   -1.13453000E-03  +1.11822000E-03  +6.79200000E-05  +1.17250000E-04  -1.31400000E-05
   +3.79600000E-05  +1.16600000E-05  +2.90000000E-05  -1.09440000E-04  -4.33900000E-05
   -6.47000000E-06  +1.08000000E-04  -1.31550000E-04  -8.09300000E-05  +2.88930000E-04
   -3.84590000E-04  +2.59090000E-04  -3.92300000E-05  -1.17300000E-05  +1.46600000E-05
   +1.75180000E-04  +6.11230000E-04  -8.56300000E-04  +3.43720000E-04  +1.63020000E-04
   +2.44610000E-04  +9.68800000E-05  -4.02300000E-05  -6.19000000E-05  +2.29298000E-02
   +1.20467700E-02  +3.55512000E-03  +2.35675100E-02  +1.51728300E-02  +5.45976500E-02
   +6.20800000E-05  +6.86900000E-05  -1.49410000E-04  +2.97840000E-04  -7.10520000E-04
   -3.18960000E-04  +1.69870000E-04  +3.50400000E-05  -3.10090000E-04  +1.68430000E-04
   -4.44000000E-05  +1.28900000E-04  -6.56000000E-05  -1.84270000E-04  -1.52530000E-04
   +6.89000000E-05  -3.07000000E-05  +9.21600000E-05  -5.63530000E-04  -8.92760000E-04
   -4.32960000E-04  -2.03892160E-01  +1.34029870E-01  -6.29797000E-03  +4.91000000E-06
   +1.13480000E-04  +2.78300000E-05  +7.07070000E-04  -4.38690000E-04  +1.77560000E-04
   +9.95200000E-05  +1.80510000E-04  -9.95000000E-05  +3.43300000E-05  +4.40600000E-05
   +3.38100000E-05  -7.72300000E-05  -5.63800000E-05  +2.99200000E-05  -7.84700000E-05
   +6.42500000E-05  +4.46300000E-05  +6.79500000E-05  +3.79900000E-05  +3.56200000E-05
   +9.83400000E-05  +5.39100000E-05  -1.43000000E-06  +4.24230000E-04  -1.82390000E-04
   -6.75310000E-04  -9.94600000E-05  +8.63500000E-05  +1.11120000E-04  -1.20700000E-05
   -7.02000000E-06  -8.51000000E-06  +1.60600000E-05  +1.56000000E-05  +5.92000000E-06
   +2.66000000E-05  -6.46000000E-06  +2.33200000E-05  +7.64600000E-05  -2.86500000E-05
   -4.49000000E-06  -7.50000000E-07  +8.56000000E-06  +1.33000000E-06  -4.03730000E-04
   +9.02200000E-05  +1.10860000E-04  +2.15830000E-04  -3.28600000E-04  -9.77600000E-05
   +3.70550000E-04  -1.21800000E-04  +2.71670000E-04  +3.67973000E-03  -4.02796000E-03
   -4.96000000E-05  -1.83404600E-02  +1.88605100E-02  -1.14160000E-03  +2.17064180E-01
   +9.28260000E-04  -4.39420000E-04  +3.30750000E-04  -1.14530000E-03  -1.22785000E-03
   -2.67268000E-03  +1.99400000E-04  +1.75890000E-04  -8.13100000E-05  -4.96700000E-05
   +3.42900000E-05  -1.58870000E-04  -5.56100000E-05  +2.03260000E-04  +7.08200000E-05
   -5.59700000E-05  +4.17000000E-06  -3.56620000E-04  +1.32748700E-02  -1.26178900E-02
   +2.32820000E-04  +1.32966570E-01  -1.60882870E-01  +5.61663000E-03  +1.60800000E-05
   -1.79750000E-04  -1.16400000E-05  +7.20170000E-04  +6.99610000E-04  +5.18250000E-04
   -3.65260000E-04  -4.03000000E-06  -1.31300000E-04  +5.36600000E-05  +7.17400000E-05
   -1.14840000E-04  -7.59600000E-05  -1.63050000E-04  +8.55400000E-05  -1.53420000E-04
   -2.58000000E-05  -9.96900000E-05  -1.77720000E-04  -2.40420000E-04  +5.17520000E-04
   +7.66300000E-05  +1.06490000E-04  -6.91000000E-06  -8.61500000E-05  +5.34560000E-04
   +1.70922000E-03  +1.81610000E-04  -4.09100000E-05  -3.91800000E-05  -1.21500000E-05
   -2.28200000E-05  -1.66400000E-05  +1.02800000E-05  -1.44500000E-05  -5.09000000E-06
   +3.18000000E-06  -4.66000000E-06  -8.61000000E-06  +1.13560000E-04  +1.08050000E-04
   -2.02460000E-04  +1.24200000E-05  -1.95800000E-05  -6.46000000E-06  -9.35300000E-05
   +7.86800000E-05  -1.23350000E-04  -3.55390000E-04  +1.34500000E-05  +1.80210000E-04
   -2.55940000E-04  +6.13850000E-04  -2.44440000E-04  +1.44902700E-02  -1.22393400E-02
   +2.90100000E-05  -1.28988100E-02  +1.25657900E-02  -5.95640000E-04  -1.46915600E-01
   +1.72807440E-01  +1.68685000E-03  -1.10429000E-03  +4.08640000E-04  -1.49425000E-03
   -1.89068000E-03  -5.65423000E-03  -3.97260000E-04  +1.22120000E-04  -7.75470000E-04
   -3.05600000E-05  +1.56500000E-04  +6.21530000E-04  +7.03800000E-05  +1.62810000E-04
   -3.98240000E-04  -1.08230000E-04  +1.31700000E-05  -5.12180000E-04  +2.18392300E-02
   -1.91700100E-02  -1.60430000E-03  -8.43525000E-03  +7.57805000E-03  -4.60221400E-02
   -7.89000000E-06  +1.27100000E-05  +1.00230000E-04  +7.05350000E-04  +9.08470000E-04
   +8.79390000E-04  -1.74120000E-04  +1.22000000E-04  +3.11400000E-05  +8.07000000E-06
   -1.30100000E-05  -8.98500000E-05  -5.95700000E-05  -4.48500000E-05  -5.37000000E-05
   +2.27570000E-04  -7.26100000E-05  +1.34560000E-04  -2.39040000E-04  +7.88200000E-05
   -1.62900000E-04  +1.13040000E-04  +9.99300000E-05  +2.03100000E-05  +1.22010000E-03
   -1.15863000E-03  +5.64400000E-04  +4.26700000E-05  -2.75100000E-05  +1.71590000E-04
   -1.46200000E-05  -2.11000000E-06  -3.57000000E-06  +1.15700000E-05  -1.23100000E-05
   +3.18000000E-06  -3.01300000E-05  -2.10500000E-05  -3.99200000E-05  -1.01790000E-04
   -1.71200000E-05  +9.76500000E-05  -1.00400000E-05  +4.06000000E-06  -7.87000000E-06
   +9.55800000E-05  +1.59250000E-04  +8.21400000E-05  -1.52180000E-04  +1.04320000E-04
   +4.05310000E-04  -3.66660000E-04  +4.70400000E-05  -9.56270000E-04  -2.06855900E-02
   +1.61789100E-02  -3.16570000E-04  -1.63541000E-03  +2.22608000E-03  -1.23731000E-03
   +7.85225000E-03  -4.32390000E-03  +5.36610900E-02  +1.09495000E-03  +1.92198000E-03
   -2.14016000E-03  +3.09324000E-03  -6.34269000E-03  -8.58267000E-03  -4.48188500E-02
   +2.50817500E-02  +2.67820500E-02  +4.61930000E-04  +9.39430000E-03  +1.54863900E-02
   +6.83903000E-03  +6.29626000E-03  -1.82801000E-03  -9.33610000E-04  +5.69800000E-05
   +1.49180000E-04  -1.94640000E-04  -1.60410000E-03  +1.23290000E-04  -7.23550000E-04
   +1.51312000E-03  -7.08030000E-04  -1.13561000E-03  +2.33329000E-03  +1.51606000E-03
   -2.43280000E-04  +3.24960000E-04  -8.16300000E-05  -8.89000000E-05  -1.44700000E-05
   +9.22100000E-05  +6.08800000E-05  -8.27000000E-06  +4.13700000E-05  -7.48100000E-05
   -2.52000000E-05  -5.03300000E-05  +8.64900000E-05  -9.18600000E-05  +1.77700000E-04
   -7.19900000E-05  +7.87800000E-05  -3.45380000E-04  +9.12000000E-05  +6.54100000E-05
   +4.67500000E-05  +1.93070000E-04  +1.07970000E-04  +1.84330000E-04  +2.13781000E-03
   -1.55689000E-03  -2.52748000E-03  -1.22600000E-05  -1.00100000E-05  -4.84000000E-06
   +1.28600000E-05  -1.00400000E-05  +4.95000000E-06  +2.28000000E-05  -1.57700000E-05
   +3.26600000E-05  -8.03490000E-04  -2.71490000E-04  +5.94300000E-05  -8.99000000E-06
   -9.84000000E-06  -1.02800000E-05  +1.99500000E-05  -1.51800000E-05  -2.57200000E-05
   +3.32400000E-05  -5.72200000E-05  +1.44920000E-04  -3.37000000E-05  -1.37700000E-05
   +3.29500000E-05  -2.33609000E-03  +2.32468000E-03  +3.30030000E-04  +3.46700000E-05
   -1.44310000E-04  +1.20360000E-04  -1.06390000E-04  -2.49970000E-04  +1.49020000E-04
   +4.15753900E-02  +2.05185000E-03  -5.27230000E-04  +2.07630000E-03  -1.90925000E-03
   +8.33891000E-03  +1.35455600E-02  +2.45266300E-02  -1.18207880E-01  -1.24378440E-01
   +5.09667000E-03  -1.21256400E-02  -2.84862900E-02  +3.26371000E-03  +2.00651000E-03
   +5.62319000E-03  +2.10520000E-04  -6.29440000E-04  +2.87040000E-04  -3.08060000E-04
   -2.05710000E-04  -2.24010000E-04  +2.08133000E-03  -1.11330000E-03  +2.81300000E-04
   -4.84970000E-04  -4.61300000E-04  -1.87100000E-04  +1.60900000E-05  +1.46260000E-04
   -4.87100000E-05  -5.75000000E-05  -6.44400000E-05  +1.01830000E-04  -3.42000000E-06
   -4.56200000E-05  +4.88600000E-05  -4.17900000E-05  +4.22400000E-05  -5.93600000E-05
   +6.54300000E-05  -5.44400000E-05  +1.12540000E-04  -4.00800000E-05  -1.07300000E-04
   -3.31890000E-04  +6.93000000E-06  -7.52000000E-06  +3.05200000E-05  -7.98400000E-05
   -9.71600000E-05  -1.02260000E-04  +3.04185000E-03  -2.37200000E-04  -2.66905000E-03
   -1.13000000E-06  -1.83000000E-06  +1.59000000E-06  -3.38000000E-06  -8.97000000E-06
   +3.50000000E-06  +1.99000000E-05  +1.35200000E-05  +2.83300000E-05  -3.90550000E-04
   +3.33100000E-05  +2.68600000E-05  -2.00600000E-05  -2.04800000E-05  -1.04400000E-05
   -8.74000000E-06  -3.99700000E-05  +3.70600000E-05  -2.22900000E-05  +3.80100000E-05
   -8.59900000E-05  -1.08600000E-05  +9.17000000E-06  +1.73200000E-05  +2.09771000E-03
   -1.58576000E-03  +1.90460000E-04  +9.80000000E-06  -6.93950000E-04  +2.33900000E-05
   -1.13340000E-04  -7.51000000E-05  +2.15760000E-04  -3.60687600E-02  +1.26078440E-01
   -2.31680000E-03  +3.14080000E-03  -2.14877000E-03  +2.64176000E-03  -1.35796800E-02
   -2.03078100E-02  +2.75601100E-02  -1.21554690E-01  -2.73489220E-01  -5.03640000E-04
   +9.42320000E-04  +4.05791000E-03  -1.96966000E-03  +2.68800000E-05  +7.41400000E-04
   -2.90740000E-04  +5.45210000E-04  +5.00950000E-04  +1.17109000E-03  -8.59680000E-04
   -6.31650000E-04  +1.17258000E-03  -6.52350000E-04  -1.15110000E-04  +2.33040000E-04
   -3.69910000E-04  -1.37600000E-04  +6.90300000E-05  +4.62400000E-05  +1.22090000E-04
   -3.21300000E-05  +5.03200000E-05  +4.80700000E-05  +4.95500000E-05  +1.90900000E-05
   +3.77100000E-05  -1.87100000E-05  +3.86000000E-06  -1.43200000E-05  +2.56700000E-05
   -5.23300000E-05  +1.52920000E-04  +2.16900000E-05  +9.27500000E-05  -3.89540000E-04
   +4.31700000E-05  +3.23400000E-05  +2.81900000E-05  -9.16600000E-05  +6.26200000E-05
   +1.29840000E-04  -1.02130000E-04  +3.71600000E-04  +9.70950000E-04  +3.36000000E-06
   -8.65000000E-06  -4.46000000E-06  +1.77100000E-05  -6.37000000E-06  +3.00000000E-07
   +2.40100000E-05  -2.37100000E-05  +2.17700000E-05  -7.42000000E-05  -1.36330000E-04
   +2.23240000E-04  +5.95000000E-06  -8.75000000E-06  -9.84000000E-06  +1.00600000E-05
   +2.83000000E-05  -3.15600000E-05  +2.58500000E-05  -7.50000000E-05  +1.27120000E-04
   -5.97300000E-05  +8.40800000E-05  -2.82000000E-06  +2.37310000E-04  -8.39380000E-04
   +1.22115000E-03  -1.33000000E-06  +4.27990000E-04  -1.16810000E-04  +2.67310000E-04
   -2.51800000E-04  +5.98030000E-04  -2.95668700E-02  +1.32893600E-01  +2.88208660E-01
   -3.15900000E-04  -6.06370000E-04  +1.17400000E-05  +7.20672000E-03  +6.14825000E-03
   +2.29480000E-04  +2.98656000E-03  +8.53149000E-03  -1.37120900E-02  -8.68368800E-02
   +4.83831700E-02  -9.07493700E-02  +4.11753000E-03  +2.90700000E-05  +8.52931000E-03
   -6.88260000E-04  +1.05098000E-03  +4.55530000E-04  -6.16510000E-04  -1.24999000E-03
   +5.36090000E-04  -3.29000000E-06  -2.40800000E-05  +9.70000000E-06  -3.44530000E-04
   -9.36500000E-05  +1.02400000E-05  -3.71850000E-04  +1.71750000E-04  -6.82800000E-05
   -4.25000000E-06  +8.68000000E-06  +1.02450000E-04  -3.79300000E-05  -9.27300000E-05
   +4.10200000E-05  +6.67000000E-06  +5.63100000E-05  -7.52800000E-05  +1.81400000E-05
   -6.71000000E-06  -1.36600000E-05  -6.87600000E-05  -5.00000000E-08  -1.03650000E-04
   -4.71400000E-05  -4.77400000E-05  +1.12300000E-05  +1.79200000E-04  -9.61900000E-05
   -1.58420000E-04  +2.73783000E-03  -5.75490000E-04  -2.52774000E-03  +3.93000000E-06
   +1.16000000E-06  +3.01000000E-06  -1.02000000E-06  -1.27100000E-05  -1.23000000E-06
   -4.83000000E-06  +1.54500000E-05  +1.50900000E-05  +5.24700000E-05  +6.20300000E-05
   +2.10000000E-07  -2.99300000E-05  -3.74000000E-06  +5.59000000E-06  +1.08300000E-05
   -3.55400000E-05  +5.26000000E-06  +3.60000000E-07  +1.76000000E-05  +1.77100000E-05
   -3.99800000E-05  -6.24200000E-05  +6.26500000E-05  -3.89000000E-06  +4.78700000E-05
   -3.51700000E-05  +2.77100000E-05  -2.04300000E-05  -2.62200000E-05  +3.74000000E-06
   +2.59200000E-05  -9.49000000E-06  -5.02989000E-03  -3.14674000E-03  +1.15145000E-03
   +7.56632800E-02  -3.52230000E-04  -2.46300000E-04  -1.72770000E-04  +7.67086000E-03
   -1.86897000E-03  -1.37934000E-03  +1.10403300E-02  -4.34672000E-03  +2.32344200E-02
   +4.89268300E-02  -9.99491700E-02  +9.45140800E-02  -6.11527000E-03  +8.18636000E-03
   -1.20432500E-02  +8.75050000E-04  -1.42897000E-03  -2.73713000E-03  -4.45780000E-04
   -7.80840000E-04  +1.67119000E-03  -5.16000000E-05  +7.10800000E-05  +9.76300000E-05
   +1.29980000E-04  +2.00532000E-03  +1.38469000E-03  -3.15000000E-04  -5.71500000E-05
   -6.43300000E-05  +2.81900000E-05  +4.27100000E-05  +3.86900000E-05  -2.16100000E-05
   -2.05900000E-05  +6.12000000E-06  -1.75600000E-05  +4.40000000E-06  -3.55000000E-05
   +1.91500000E-05  +2.72300000E-05  -1.63700000E-05  -1.31000000E-06  +1.41700000E-05
   +3.54900000E-05  +1.59600000E-05  +5.35000000E-06  -3.80000000E-07  +5.26510000E-04
   -1.69010000E-04  -2.07350000E-04  +6.49150000E-04  -9.35240000E-04  +1.23490000E-03
   -3.67000000E-06  -1.50000000E-07  -1.19000000E-06  +6.07000000E-06  -8.90000000E-07
   +5.80000000E-07  -8.66000000E-06  -7.31000000E-06  -6.66000000E-06  +3.80600000E-05
   -1.99000000E-06  -2.67000000E-06  -1.70000000E-07  +1.00000000E-05  +6.56000000E-06
   -6.90000000E-06  -2.56500000E-05  +2.90000000E-07  -9.30000000E-06  +2.57600000E-05
   +2.73000000E-05  +1.17000000E-06  -1.52510000E-04  +1.49940000E-04  +1.88000000E-05
   +2.27200000E-05  -6.42700000E-05  +3.37000000E-06  -2.18200000E-05  -1.95800000E-05
   +5.99000000E-06  -9.09000000E-06  -4.82300000E-05  -3.46898000E-03  -1.10662000E-03
   +5.28560000E-04  -5.95597100E-02  +9.90568400E-02  +8.00000000E-07  +2.87160000E-04
   +6.91020000E-04  -9.38330000E-04  -1.70155000E-03  -8.87800000E-05  +2.39315000E-03
   -5.82654000E-03  +5.94035000E-03  -8.85247700E-02  +1.00256360E-01  -2.58545530E-01
   -1.38367500E-02  +1.41259600E-02  -1.93214300E-02  +2.36527000E-03  -3.87662000E-03
   -3.13102000E-03  +3.15180000E-04  +1.81620000E-04  -1.14900000E-04  -6.82000000E-05
   +2.28500000E-05  +6.00000000E-06  +5.05960000E-04  +1.76270000E-04  +3.15117000E-03
   +6.22400000E-05  +4.20000000E-06  +4.10200000E-05  -1.05500000E-05  +8.27000000E-06
   +1.68500000E-05  +1.21200000E-05  +1.11100000E-05  +1.88800000E-05  +3.08300000E-05
   +1.74800000E-05  +7.65000000E-06  -1.45400000E-05  -3.04200000E-05  -1.12300000E-05
   +1.98100000E-05  +1.96400000E-05  -4.99000000E-05  -3.23000000E-05  -3.02000000E-05
   +1.40000000E-06  -6.91100000E-05  -5.08000000E-06  +1.78400000E-05  +9.10620000E-04
   -2.88850000E-04  +4.18648000E-03  +4.56000000E-06  +4.58000000E-06  +9.80000000E-07
   -4.30000000E-07  -1.17000000E-06  -1.02000000E-06  +1.34100000E-05  -1.22400000E-05
   +6.30000000E-06  -1.03500000E-05  +3.35600000E-05  +2.79300000E-05  -1.23600000E-05
   -5.30000000E-07  +5.61000000E-06  -1.88000000E-06  +9.74000000E-06  +8.02000000E-06
   +9.24000000E-06  -1.80800000E-05  +1.62500000E-05  +7.56000000E-06  +2.21300000E-05
   -8.55000000E-06  +9.52000000E-06  +1.14700000E-05  +3.25000000E-06  -6.27000000E-06
   -2.26000000E-06  +9.00000000E-06  -3.38000000E-06  +9.50000000E-06  +3.90000000E-06
   +7.72180000E-04  +9.26460000E-04  +8.97460000E-04  +9.71910900E-02  -1.04573300E-01
   +2.67299770E-01  +6.55972000E-03  +1.13366500E-02  +1.21487600E-02  +6.04627000E-03
   +6.73912000E-03  -2.73757000E-03  -1.42690000E-04  -7.00920000E-04  +2.82380000E-04
   -1.76933000E-03  +2.02287000E-03  -1.26183000E-03  +4.09465000E-03  -6.49419000E-03
   -1.54275400E-02  -5.11819000E-02  +1.89160800E-02  +2.21175600E-02  -4.27760000E-04
   -9.88240000E-04  -9.02900000E-05  +7.21000000E-06  -1.01920000E-04  +1.33960000E-04
   -1.31410000E-04  -8.06100000E-05  +1.16783000E-03  -4.27520000E-04  -2.75000000E-06
   +4.64300000E-05  -1.87000000E-05  +3.90800000E-05  +9.65700000E-05  +1.12800000E-05
   -3.34100000E-05  -1.09000000E-06  +5.20200000E-05  +1.43700000E-05  +6.43600000E-05
   -7.61100000E-05  -5.72300000E-05  -6.91400000E-05  +4.62500000E-05  +7.27200000E-05
   -5.11200000E-05  -5.92600000E-05  -6.40000000E-05  -2.19000000E-05  +1.93930000E-04
   -1.50520000E-04  +9.77600000E-05  +3.09786000E-03  -9.80400000E-05  +3.20805000E-03
   -1.34100000E-05  +9.81000000E-06  +1.61700000E-05  -2.02900000E-05  +7.97000000E-06
   -1.80000000E-06  +9.43000000E-06  -1.62000000E-06  +3.45000000E-06  -9.20000000E-06
   +1.33400000E-05  +6.01000000E-06  -4.79000000E-06  +5.10000000E-07  +2.60000000E-06
   +5.84000000E-06  -3.21100000E-05  -7.05000000E-06  +2.50600000E-05  -2.22000000E-05
   -5.03600000E-05  -2.72400000E-05  -3.54100000E-05  -1.39000000E-05  -1.09700000E-05
   -2.42000000E-06  +5.65000000E-06  +6.08000000E-06  -1.37700000E-05  -2.33600000E-05
   -1.73600000E-05  -2.56000000E-05  -3.00600000E-05  -2.52900000E-05  -8.78300000E-05
   +3.05000000E-05  +1.29339000E-03  +1.08910000E-04  -8.74950000E-04  +3.71428300E-02
   +3.17423000E-03  -6.85915000E-03  -2.44395400E-02  +7.48946000E-03  -1.47467000E-03
   -5.71800000E-04  -2.70270000E-04  -2.53030000E-04  +3.14050000E-04  +1.33294000E-03
   -8.31370000E-04  +2.17761000E-03  -1.36254000E-03  +7.63085000E-03  +1.01084300E-02
   +2.02823200E-02  -1.26175720E-01  -1.24361580E-01  -7.25950000E-04  -7.59010000E-04
   -1.48947000E-03  +4.65170000E-04  -2.78900000E-04  +1.89280000E-04  -2.62270000E-04
   +1.87826000E-03  -1.15608000E-03  -4.34800000E-04  -7.16400000E-05  +6.72700000E-05
   -2.55500000E-05  +6.37400000E-05  +2.70100000E-05  +2.66900000E-05  +3.37400000E-05
   +2.07400000E-05  +2.32800000E-05  -3.66000000E-06  +2.88300000E-05  -3.50800000E-05
   -2.77000000E-05  -3.24800000E-05  +4.73100000E-05  +7.99400000E-05  -1.33000000E-06
   -3.64000000E-06  -1.03000000E-05  -1.71000000E-06  +7.67300000E-05  +3.28400000E-05
   -2.29500000E-05  +3.12500000E-04  -9.11680000E-04  -7.48960000E-04  -1.88000000E-06
   +4.18000000E-06  -1.04000000E-06  +1.36200000E-05  +3.56000000E-06  -1.34000000E-06
   +1.06100000E-05  -3.84100000E-05  -1.62000000E-06  -2.98000000E-06  -8.55000000E-06
   +7.62000000E-06  +1.03000000E-06  +5.07000000E-06  +3.53000000E-06  -1.57000000E-06
   -2.26900000E-05  +9.35000000E-06  +3.84000000E-06  -3.26500000E-05  +9.09000000E-06
   +4.00000000E-07  -5.04000000E-05  +2.10400000E-05  -5.45000000E-06  +5.14000000E-06
   -2.61900000E-05  -1.05000000E-05  +3.89000000E-06  +7.10000000E-07  +6.74000000E-06
   -1.08990000E-04  -1.73740000E-04  -9.05100000E-05  -1.67000000E-05  -1.01400000E-04
   +3.64550000E-04  +6.32760000E-04  +5.33460000E-04  -2.78088300E-02  +1.27796080E-01
   -3.04011000E-03  +4.03745000E-03  +4.85939000E-03  -2.00414000E-03  -1.58030000E-04
   +3.81260000E-04  +3.86960000E-04  +3.34800000E-05  +5.67410000E-04  -2.94210000E-03
   +3.15067000E-03  -2.63557000E-03  +6.79238000E-03  -1.61968600E-02  -1.80051600E-02
   +2.04178700E-02  -1.29720680E-01  -2.68946360E-01  -1.26040000E-04  +2.41080000E-04
   +2.09000000E-04  -1.64100000E-05  +7.15300000E-05  -3.30300000E-05  +5.72320000E-04
   -4.67900000E-05  +3.17344000E-03  +7.56000000E-05  +1.82000000E-05  +2.21900000E-05
   -6.97000000E-06  -2.13000000E-05  -1.02700000E-05  +1.97000000E-05  +3.24900000E-05
   +5.97000000E-06  -2.68500000E-05  -2.81800000E-05  -2.04000000E-06  +1.25600000E-05
   +9.73000000E-06  +2.24300000E-05  -1.14200000E-05  -4.53000000E-06  -3.21900000E-05
   +3.59500000E-05  +4.64400000E-05  +1.12400000E-05  +1.23900000E-05  +1.68000000E-06
   +8.60000000E-07  -8.31850000E-04  +1.00215000E-03  +3.31964000E-03  +5.98000000E-06
   -1.06600000E-05  -5.16000000E-06  +7.78000000E-06  -3.81000000E-06  +2.63000000E-06
   -6.82000000E-06  +2.07000000E-06  -3.05000000E-06  -1.51600000E-05  -1.29000000E-06
   +2.66100000E-05  +4.36000000E-06  -4.82000000E-06  -8.08000000E-06  +7.30000000E-07
   +4.20000000E-06  -6.94000000E-06  -3.43000000E-06  +4.13000000E-06  +1.48000000E-06
   +6.09000000E-06  -7.69000000E-06  +5.40000000E-06  -1.93000000E-05  -7.73000000E-06
   +1.31700000E-05  +1.63000000E-06  +1.74600000E-05  +2.44000000E-06  +6.44000000E-06
   +9.47000000E-06  +3.19000000E-05  +1.41550000E-04  -6.59500000E-05  +2.40100000E-05
   +4.09300000E-05  -8.02230000E-04  -1.10202000E-03  -2.08529600E-02  +1.38045430E-01
   +2.77700690E-01  -9.48551600E-02  +5.38034900E-02  -1.05340500E-01  +3.19998000E-03
   -1.72522000E-03  +2.24510000E-03  +2.13189000E-03  +1.12794000E-03  +8.80380000E-04
   -8.60380000E-04  +1.56600000E-05  +2.11250000E-04  +7.23714000E-03  +5.52781000E-03
   -6.49400000E-05  -4.23301000E-03  +6.39314000E-03  -1.49996100E-02  -7.33850000E-04
   -7.55970000E-04  -6.82900000E-05  +8.23700000E-05  -1.14690000E-04  +1.36900000E-05
   -1.45658000E-03  +2.29609000E-03  -1.33002000E-03  +1.27000000E-05  +3.99820000E-04
   +6.06100000E-05  -1.43450000E-04  -1.58590000E-04  +1.94210000E-04  -1.36430000E-04
   -1.66950000E-04  -1.23880000E-04  -1.69350000E-04  -2.72000000E-05  -1.40000000E-04
   +1.46600000E-04  +8.77300000E-05  +5.81700000E-05  -1.24200000E-04  -2.02300000E-04
   +1.03430000E-04  +1.28230000E-04  +1.06880000E-04  +6.97000000E-06  -6.03660000E-04
   +9.13810000E-04  +8.78900000E-05  +2.34886000E-03  -1.24264000E-03  +1.73333000E-03
   -3.35800000E-05  -1.69400000E-05  -5.00000000E-06  +3.86000000E-06  -1.14800000E-05
   +6.28000000E-06  -1.64710000E-04  +3.02350000E-04  -3.28300000E-05  -2.69000000E-06
   +1.85600000E-05  -3.57700000E-05  -2.00000000E-07  +5.17000000E-06  -4.60000000E-07
   +3.59000000E-05  -7.21800000E-05  -6.81700000E-05  +1.37740000E-04  +1.61908000E-03
   +5.66590000E-04  -6.44100000E-05  +5.96600000E-05  +2.14130000E-04  +1.03900000E-05
   -8.25000000E-06  +5.46000000E-06  -4.49000000E-06  -4.09100000E-05  -4.27900000E-05
   +2.00600000E-05  -3.25700000E-05  -4.37100000E-05  +5.17380000E-04  +9.20500000E-05
   +2.16180000E-04  -1.00970000E-04  -1.03120000E-04  -1.25480000E-04  -4.65784000E-03
   -3.26204000E-03  +1.48870000E-03  +9.22503900E-02  +5.21008700E-02  -8.51475800E-02
   +8.26111000E-02  -7.76354000E-03  +7.54015000E-03  -1.45537400E-02  +1.67558000E-03
   -9.56380000E-04  -2.62577000E-03  +1.02390000E-04  -6.77050000E-04  -2.72520000E-04
   +1.54354000E-03  +1.06883000E-03  -6.31225000E-03  +1.53342500E-02  -9.30320000E-03
   +2.74442200E-02  -2.42600000E-04  -1.63360000E-04  +2.69830000E-04  -1.48210000E-04
   -1.43420000E-04  +1.23990000E-04  -3.61120000E-04  -4.87230000E-04  +4.40040000E-04
   +1.57200000E-04  +6.62000000E-05  -5.32300000E-05  +1.55150000E-04  +4.79400000E-05
   -1.28300000E-04  -6.18900000E-05  -2.10900000E-04  +1.36000000E-05  -6.25600000E-05
   -9.40000000E-07  -2.02300000E-05  +1.78800000E-05  +1.03700000E-05  +2.05800000E-05
   -8.34300000E-05  -9.38400000E-05  +2.13700000E-05  -2.02000000E-06  -2.34300000E-05
   -6.54000000E-06  +7.13320000E-04  -1.46558000E-03  -8.80470000E-04  +3.62270000E-03
   +4.56700000E-05  +1.59447000E-03  -1.95000000E-05  +5.12000000E-06  +1.25100000E-05
   -4.00300000E-05  +1.74600000E-05  +2.63000000E-06  +8.01400000E-05  +8.77900000E-05
   +5.04400000E-05  -1.80000000E-05  +1.00300000E-05  -8.67000000E-06  -4.78000000E-06
   -5.03000000E-06  -1.13000000E-06  -6.00800000E-05  +3.71100000E-05  +5.55300000E-05
   +1.61530000E-03  -3.24481000E-03  -3.91580000E-04  -5.86400000E-05  +1.88760000E-04
   +1.86430000E-04  -1.41200000E-05  +2.65000000E-05  +1.30270000E-04  -9.87000000E-06
   -3.62000000E-06  -3.34400000E-05  +6.76000000E-06  +1.08000000E-05  -6.34000000E-06
   -1.18240000E-04  +5.96670000E-04  -7.29610000E-04  -1.09530000E-04  -2.67700000E-05
   +9.83700000E-05  -3.34014000E-03  -1.18429000E-03  +3.67790000E-04  -6.47799700E-02
   +9.33671500E-02  -1.04539400E-01  +8.13818300E-02  -2.51294390E-01  -1.06923800E-02
   +1.14495000E-02  -1.97559300E-02  +9.16660000E-04  -3.91232000E-03  -2.43077000E-03
   +6.75150000E-04  -3.81410000E-04  +4.21170000E-04  -6.26110000E-04  -2.36164000E-03
   +1.55800000E-03  +9.49190000E-04  -1.30589000E-03  +4.77707000E-03  -9.72370000E-04
   +1.23368000E-03  -2.92070000E-04  +1.17940000E-04  -1.25310000E-04  +1.63910000E-04
   +3.38150000E-04  -3.11490000E-04  +2.91830000E-04  +5.65200000E-05  -1.40290000E-04
   +1.80630000E-04  -1.67620000E-04  +9.65000000E-06  -1.38180000E-04  +1.70350000E-04
   +2.50360000E-04  +9.83700000E-05  +1.94500000E-04  +1.72400000E-05  +2.09440000E-04
   -2.06530000E-04  -1.73780000E-04  -2.49100000E-05  +8.00300000E-05  +2.53580000E-04
   -2.63410000E-04  -1.36890000E-04  -1.21430000E-04  -8.02000000E-06  -2.52090000E-04
   +4.07060000E-04  -4.84000000E-04  -1.19040000E-03  +1.84930000E-04  -1.23730000E-04
   +2.91000000E-05  +2.32800000E-05  +7.57000000E-06  -9.91000000E-06  +4.30000000E-07
   -9.40000000E-06  +1.36360000E-04  -9.11900000E-05  +1.49080000E-04  -3.28800000E-05
   -1.77300000E-05  +7.04800000E-05  -1.56700000E-05  -9.76000000E-06  +1.27000000E-06
   -4.64400000E-05  +2.45560000E-04  +2.06870000E-04  -1.60800000E-05  -1.33420000E-04
   +1.49376000E-03  -4.93800000E-05  +1.58100000E-04  +4.59680000E-04  -7.77400000E-05
   +1.27100000E-05  +1.27900000E-04  +3.62000000E-06  +8.69900000E-05  +6.36000000E-06
   +9.28800000E-05  -9.52400000E-05  -7.47000000E-06  -6.57290000E-04  +6.37900000E-04
   -1.05867000E-03  -2.89100000E-05  +1.25240000E-04  +4.45300000E-05  +1.51915000E-03
   +9.95860000E-04  +7.34650000E-04  +1.14723840E-01  -8.77192800E-02  +2.64583590E-01
   +4.99220000E-04  -5.55600000E-05  +4.81700000E-05  -2.15890000E-04  +3.57410000E-04
   -2.09000000E-04  +8.32490000E-04  -2.80220000E-04  -4.42230000E-04  -1.29142000E-03
   -1.75492000E-03  +6.19760000E-04  +1.15602400E-02  -6.15180000E-03  -1.64586000E-03
   -7.68130000E-04  -7.54800000E-04  +6.33900000E-05  -4.76000000E-05  -1.50100000E-05
   +6.90000000E-07  +2.80000000E-05  -4.43000000E-06  -5.41000000E-06  -4.09140870E-01
   +2.18390680E-01  +5.99106200E-02  +2.41900000E-05  -1.44600000E-05  -4.21000000E-06
   -2.43000000E-06  -1.02200000E-05  -1.84400000E-05  +7.61000000E-06  +2.20000000E-07
   -1.06900000E-05  -1.03300000E-05  -3.86000000E-06  +5.98000000E-06  +1.20700000E-05
   -3.80000000E-06  +4.11000000E-06  +9.83000000E-06  -1.44000000E-05  -3.70000000E-06
   +2.33600000E-05  -2.10000000E-06  -3.15000000E-06  +7.25000000E-06  +1.56000000E-06
   -1.74000000E-06  -4.05898000E-03  +2.65284000E-03  +3.12010000E-04  -1.40100000E-05
   +6.45000000E-06  +1.43000000E-06  -2.27000000E-06  +5.55000000E-06  +2.45000000E-06
   -3.90000000E-06  +4.67000000E-06  +1.85000000E-06  -9.63000000E-06  +1.31000000E-06
   +8.65000000E-06  -4.91000000E-06  +5.50000000E-06  +3.82000000E-06  -5.72000000E-06
   -5.93000000E-06  -4.22000000E-06  +2.80000000E-07  +9.43000000E-06  -1.18000000E-06
   +2.33000000E-06  -4.74000000E-06  +4.72000000E-06  -9.02000000E-06  -2.15000000E-06
   +1.63700000E-05  -4.67000000E-06  +5.30000000E-07  -2.80000000E-07  +4.36000000E-06
   -1.21700000E-05  +4.49000000E-06  +4.44930000E-04  +1.00360000E-04  -9.39600000E-05
   +3.31600000E-05  +1.12240000E-04  -6.20600000E-05  -1.92800000E-05  +2.13380000E-04
   -1.07820000E-04  +2.74530000E-04  +8.10100000E-05  -3.64200000E-05  +4.02564880E-01
   -1.06290000E-04  +1.01990000E-03  +1.10665000E-03  -2.14430000E-04  -8.39960000E-04
   -2.18800000E-05  -3.26900000E-04  +7.21580000E-04  -1.23111000E-03  -3.09800000E-04
   -4.83294000E-03  +9.74000000E-04  +3.94536900E-02  -4.07108200E-02  -4.94492000E-03
   -2.53000000E-04  -4.32210000E-03  -2.06790000E-04  +2.84700000E-05  -7.95500000E-05
   -4.95300000E-05  -3.23100000E-05  +2.65700000E-05  -2.64800000E-05  +1.71437600E-01
   -1.40875650E-01  -2.24856900E-02  -4.85500000E-05  +1.06820000E-04  +2.55000000E-06
   +2.01600000E-05  +2.81300000E-05  +7.73500000E-05  -4.75900000E-05  -7.60100000E-05
   +5.01400000E-05  +2.20010000E-04  +1.73410000E-04  +1.79000000E-06  -4.53500000E-05
   +1.61800000E-05  -6.71500000E-05  -1.48600000E-05  +3.67800000E-05  -1.00600000E-05
   -2.24780000E-04  -1.88120000E-04  -2.13600000E-05  -5.21200000E-05  +3.55500000E-05
   +3.41600000E-05  +1.61423000E-03  +1.24973200E-02  -6.66240000E-04  +3.31300000E-05
   +3.12300000E-05  +1.59400000E-05  -1.47300000E-05  -8.15000000E-06  -1.40700000E-05
   +1.42100000E-05  +3.12000000E-06  +5.30000000E-06  +2.38600000E-05  -6.66000000E-06
   -3.92900000E-05  +3.59000000E-06  -5.10000000E-06  +2.52000000E-06  +1.43500000E-05
   -1.69600000E-05  -2.37000000E-06  +1.79500000E-05  -1.42300000E-05  +1.91200000E-05
   -2.77000000E-05  +2.84200000E-05  -7.27000000E-06  +9.31000000E-06  -1.81700000E-05
   +4.53000000E-06  +1.13300000E-05  -2.49400000E-05  -1.70700000E-05  -2.42700000E-05
   +2.30600000E-05  +1.39900000E-05  +4.22000000E-04  +4.24300000E-05  -3.80500000E-05
   +9.04000000E-06  +4.04200000E-05  -2.56100000E-04  +8.00600000E-05  +8.21500000E-05
   +2.13730000E-04  +3.00050000E-04  +2.89800000E-05  -9.78500000E-05  -2.11937880E-01
   +1.77406090E-01  -1.28673000E-03  +6.22040000E-04  -5.21340000E-04  -1.51980000E-04
   -1.05210000E-04  -1.47192000E-03  +9.54450000E-04  -6.85940000E-04  -6.49130000E-04
   -1.48393000E-03  -2.60609000E-03  +1.01106000E-03  -3.73778000E-03  +2.86567000E-03
   -2.17900000E-05  +2.07799000E-03  +3.30027000E-03  +3.56380000E-04  -3.38900000E-05
   -1.22400000E-05  -2.01200000E-05  +9.30000000E-06  +2.30000000E-06  -9.24000000E-06
   +6.20079500E-02  -3.03335700E-02  -7.89922000E-03  -4.26200000E-05  +2.49300000E-05
   +2.85300000E-05  -8.64000000E-06  +9.95000000E-06  +1.17600000E-05  +2.05600000E-05
   +8.56000000E-06  -1.35000000E-06  +2.93400000E-05  +6.19000000E-06  +3.60300000E-05
   -2.97400000E-05  -2.95300000E-05  -5.18000000E-06  +2.76500000E-05  +3.55700000E-05
   -3.16400000E-05  -1.90700000E-05  -2.10700000E-05  -1.26500000E-05  +1.16100000E-05
   -8.28000000E-06  -5.66000000E-06  +2.24880000E-04  -8.84710000E-04  -1.39955000E-03
   -3.59000000E-06  +8.04000000E-06  +9.02000000E-06  -8.24000000E-06  +4.94000000E-06
   -1.67000000E-06  +7.11000000E-06  -3.42000000E-06  +2.20000000E-06  -1.61900000E-05
   -7.87000000E-06  +2.39100000E-05  +7.26000000E-06  -1.47000000E-06  +3.80000000E-07
   +5.30000000E-07  +1.17000000E-06  +6.93000000E-06  +3.67000000E-06  -1.52600000E-05
   +9.73000000E-06  -3.30000000E-06  -1.00000000E-06  +7.71000000E-06  -1.19800000E-05
   -1.62000000E-06  +2.01900000E-05  +3.60000000E-07  +5.77000000E-06  +1.83000000E-06
   +4.30000000E-06  -7.05000000E-06  +1.49400000E-05  +4.40930000E-04  -3.62000000E-06
   -4.70500000E-05  +8.57200000E-05  -2.66910000E-04  -3.80250000E-04  -2.16770000E-04
   +2.10410000E-04  -4.17570000E-04  -5.74490000E-04  -1.43300000E-05  +1.39210000E-04
   -5.84642400E-02  +2.77960100E-02  +1.11025600E-02  +1.13843000E-03  -2.94230000E-03
   -1.63681000E-03  +2.34257000E-03  +7.10624000E-03  -7.95380000E-04  +1.55762000E-03
   -2.89826000E-03  +1.46275000E-03  -3.07764000E-03  +1.05660000E-03  +2.78753000E-03
   -1.32282200E-02  -7.46727000E-03  +1.12551000E-03  -3.25876000E-03  +9.77810000E-04
   -1.59873000E-03  -6.27930000E-04  -3.23930000E-04  +1.46940000E-04  +2.37820000E-04
   -5.54400000E-05  +5.02800000E-05  +3.00269000E-03  +2.68235000E-03  -6.43590000E-04
   +8.82000000E-05  -1.47280000E-04  -1.04900000E-05  -7.79000000E-05  -1.21250000E-04
   -1.95470000E-04  +8.70800000E-05  +9.87600000E-05  -8.74800000E-05  -2.86010000E-04
   -2.12250000E-04  +3.48200000E-05  +6.56000000E-05  -7.06100000E-05  +8.86900000E-05
   +6.57200000E-05  -1.33070000E-04  -1.43100000E-05  +3.21500000E-04  +2.21610000E-04
   +2.23700000E-05  +1.78270000E-04  -1.79200000E-05  -2.25700000E-05  -5.48742000E-03
   +2.31486100E-02  -1.88770000E-04  -6.81200000E-05  -1.81200000E-05  -1.75100000E-05
   +1.30500000E-05  +2.28900000E-05  +2.26600000E-05  -2.82500000E-05  +2.07100000E-05
   +1.37200000E-05  -6.56500000E-05  +3.20600000E-05  +1.04320000E-04  -1.41800000E-05
   +1.76000000E-05  +3.16000000E-06  -4.06600000E-05  -1.35390000E-04  -1.05000000E-05
   -2.78000000E-06  +7.44700000E-05  -5.45300000E-05  -1.46700000E-05  -1.29280000E-04
   +3.63100000E-05  -6.23600000E-05  +1.21300000E-05  +5.72200000E-05  -6.48000000E-06
   -1.18700000E-05  -3.83900000E-05  +3.35100000E-05  -9.23200000E-05  -3.99900000E-05
   +5.84500000E-05  -1.52580000E-04  -1.29750000E-04  -4.39100000E-05  +1.32620000E-04
   -5.09400000E-05  -4.90800000E-05  +4.54200000E-05  +4.47700000E-05  +1.27540000E-04
   -9.94200000E-05  +1.26900000E-04  -7.91950000E-04  -1.12018000E-03  +2.29890000E-04
   +7.53963500E-02  +3.07904000E-03  -8.50758000E-03  -2.86752000E-03  +8.23104000E-03
   +1.54642800E-02  -1.77965000E-03  +3.85492000E-03  -8.50002000E-03  +2.43381000E-03
   -4.78424000E-03  +6.39410000E-03  +4.03992000E-03  -2.47283200E-02  +1.15225100E-02
   +5.05924000E-03  -5.35086000E-03  +4.93377000E-03  -3.16302000E-03  -1.21949000E-03
   -7.56630000E-04  +2.56570000E-04  +4.49050000E-04  -4.38400000E-05  +1.13940000E-04
   +1.19058500E-02  +8.79110000E-03  -2.51699000E-03  +1.55290000E-04  -1.72440000E-04
   -2.77000000E-05  -1.45220000E-04  -2.27540000E-04  -3.05580000E-04  +1.12940000E-04
   +1.07110000E-04  -1.16650000E-04  -3.50100000E-04  -2.35160000E-04  +5.85800000E-05
   +7.40200000E-05  -1.54330000E-04  +1.00070000E-04  +1.08890000E-04  -2.27820000E-04
   -3.35000000E-05  +3.90610000E-04  +2.27780000E-04  +2.19500000E-05  +3.54770000E-04
   +4.01500000E-05  -2.07700000E-05  +3.99096900E-02  +1.13682400E-02  -4.91571000E-03
   -1.01430000E-04  -2.55000000E-06  -1.66700000E-05  +3.93000000E-06  +3.50500000E-05
   +3.01500000E-05  -2.92600000E-05  +4.90300000E-05  +4.43400000E-05  -1.07020000E-04
   +8.55800000E-05  +1.60790000E-04  -4.21800000E-05  +3.06400000E-05  +1.97000000E-05
   -5.94800000E-05  -3.69460000E-04  -2.93500000E-05  +2.89700000E-05  +1.37880000E-04
   -9.80000000E-05  -9.21800000E-05  -2.50200000E-04  +7.23200000E-05  -1.11150000E-04
   +1.12700000E-05  +1.14110000E-04  +1.19200000E-05  -1.10790000E-04  -1.31330000E-04
   +1.88900000E-05  -1.54290000E-04  -7.89100000E-05  -1.84400000E-05  -6.49400000E-04
   -2.28240000E-04  -3.40000000E-04  +3.00470000E-04  +1.15200000E-04  -3.42860000E-04
   +1.44110000E-04  -1.29480000E-04  +1.07000000E-04  -5.31000000E-04  +2.72720000E-04
   -1.09530000E-03  -2.99262000E-03  +3.92560000E-04  +1.84106900E-02  +1.84572150E-01
   +7.53440000E-04  -1.22873000E-03  -1.22172000E-03  +1.02266000E-03  +1.00430000E-03
   +2.92046000E-03  -8.74790000E-04  +2.76470000E-04  -8.28230000E-04  +1.54086000E-03
   +1.98060000E-04  +1.15510000E-04  -1.29233000E-03  +2.32744000E-03  -2.66929000E-03
   -1.53811000E-03  +6.52710000E-04  +8.71700000E-05  -1.92600000E-05  -6.99100000E-05
   -7.65800000E-05  +2.21000000E-05  -1.52400000E-05  +1.95900000E-05  +1.44672000E-03
   +9.43120000E-04  +3.55410000E-04  +2.38100000E-05  -1.00500000E-05  -7.52900000E-05
   +2.30100000E-05  -1.62700000E-05  +3.08000000E-06  -4.00100000E-05  -4.24500000E-05
   -1.20100000E-05  +6.76000000E-06  +2.97300000E-05  -2.49500000E-05  +1.54400000E-05
   +2.77000000E-05  -6.10000000E-06  -3.10000000E-05  -4.10200000E-05  +6.31600000E-05
   -1.79600000E-05  -2.15900000E-05  -9.33000000E-06  -1.02200000E-05  +3.44700000E-05
   +4.97600000E-05  +2.73143000E-03  -4.60220000E-04  -1.50390400E-02  -4.60000000E-07
   +5.87000000E-06  +4.51000000E-06  -8.17000000E-06  -1.04000000E-06  -1.46000000E-06
   -7.96000000E-06  +1.74700000E-05  -1.42000000E-06  +1.50200000E-05  -9.80000000E-07
   -4.49700000E-05  +4.30000000E-07  +4.39000000E-06  +4.54000000E-06  +2.19000000E-06
   -3.04200000E-05  +1.00000000E-08  -8.39000000E-06  +1.18300000E-05  -4.87200000E-05
   -9.43000000E-06  -8.83000000E-06  -2.52900000E-05  +2.60800000E-05  +4.60000000E-07
   -3.04800000E-05  -4.20000000E-07  -3.75400000E-05  -1.01100000E-05  -2.01300000E-05
   +4.65000000E-06  -2.59200000E-05  +4.24900000E-05  -5.72000000E-06  -9.44700000E-05
   +7.82900000E-05  +2.22370000E-04  -1.28700000E-04  -1.57310000E-04  -1.98400000E-04
   -1.90100000E-05  -2.13200000E-05  -3.41300000E-05  -6.63400000E-05  -4.48300000E-05
   -2.41700000E-04  -2.15370000E-04  +1.74470900E-02  +9.63576000E-03  +6.39398300E-02
   +5.79690000E-04  -2.54893300E-02  -1.05900000E-02  +1.66304500E-02  +5.40136400E-02
   -1.49389900E-02  +6.64491000E-03  -1.46513500E-02  +1.02258400E-02  -5.14725000E-03
   +5.44997000E-03  +1.79448000E-03  -2.46756000E-03  +3.42406000E-03  -1.59879000E-03
   -8.94095000E-03  +7.82929000E-03  -1.40762000E-03  -1.97006300E-02  -1.50609100E-02
   +5.28640000E-04  -1.37140000E-04  -2.60480000E-04  +2.17830000E-04  +2.37795000E-03
   -3.38280000E-04  +5.71900000E-05  -2.62175000E-03  +4.61935000E-03  +6.40800000E-04
   -3.40810000E-04  -3.16580000E-04  +1.25186000E-03  -3.11560000E-04  -1.00029000E-03
   +2.25390000E-04  +1.38618000E-03  +1.22918000E-03  -1.10700000E-05  -5.24410000E-04
   -7.10320000E-04  -6.28880000E-04  -8.66200000E-05  +3.89020000E-04  -7.09480000E-04
   -1.67162000E-03  -1.19739000E-03  -6.29700000E-05  -2.15027000E-03  +1.51876000E-03
   +8.32510000E-04  +1.11352900E-02  +7.29738000E-03  +1.43800000E-03  +2.40930000E-04
   +1.14820000E-04  +1.25510000E-04  -1.20990000E-04  -1.95350000E-04  -1.10110000E-04
   -4.92200000E-05  +2.15720000E-04  +1.25660000E-04  -1.43820000E-04  +2.10920000E-04
   +1.97400000E-04  -5.22600000E-05  -1.35060000E-04  -2.79000000E-06  -4.80270000E-03
   -2.62670000E-04  -1.06334000E-03  +9.13800000E-05  +5.61600000E-05  -1.91200000E-05
   -7.53460000E-04  -8.49540000E-04  -2.79900000E-05  -2.50330000E-04  -6.10100000E-05
   +1.33140000E-04  -1.04111000E-03  +1.62670000E-04  +2.41240000E-04  -2.42300000E-05
   -1.79400000E-05  -5.79300000E-05  -2.39550000E-04  -1.05000000E-06  +3.48610000E-04
   +5.89300000E-05  +2.88100000E-05  +2.34170000E-04  +5.89440000E-04  +4.37420000E-04
   -1.34750000E-04  +6.03000000E-06  +3.77560000E-04  +1.95290000E-04  -5.58820000E-04
   -1.02880000E-04  +1.88970000E-04  -1.27485400E-02  -2.12887800E-02  -1.91264000E-03
   +2.98035330E-01  -7.15063000E-03  -2.62723200E-02  -8.05426000E-03  +2.87042900E-02
   +9.42714000E-03  -8.18409000E-03  -3.52839000E-03  -2.38695300E-02  +1.38742200E-02
   -6.34531000E-03  +4.87810000E-03  +2.13350000E-03  +1.95992000E-03  +2.68861000E-03
   -1.05985000E-03  -8.04142000E-03  +5.03120000E-03  -8.66770000E-04  -2.70565000E-03
   -1.59812000E-03  +8.93950000E-04  -5.85210000E-04  -2.21280000E-04  -4.06530000E-04
   +1.33620000E-04  -2.31190000E-03  +2.58460000E-04  +2.29280000E-04  +6.14210000E-04
   -3.89420000E-04  +1.27510000E-04  +3.28950000E-04  +4.28250000E-04  -6.55000000E-05
   +1.69230000E-04  -7.93100000E-05  +7.61100000E-05  -1.03050000E-04  +4.63800000E-05
   -6.95000000E-05  +1.17830000E-04  -2.25960000E-04  +2.99480000E-04  +3.72050000E-04
   +5.02080000E-04  +1.13000000E-04  +2.32450000E-04  -6.70000000E-06  +1.48855000E-03
   -2.87757000E-03  -5.87870000E-04  +6.32290000E-04  -1.23031000E-03  +1.64290000E-04
   +2.58100000E-05  -6.35700000E-05  -1.88700000E-05  +8.45000000E-05  -4.22500000E-05
   -5.04000000E-06  -6.33700000E-05  -1.61790000E-04  -2.45920000E-04  +5.78800000E-05
   -1.56700000E-04  -1.37400000E-04  +1.17030000E-04  +5.16000000E-06  -4.69700000E-05
   +2.01406000E-03  +2.33639000E-03  +1.93940000E-04  -1.69970000E-04  -1.65600000E-05
   +1.23060000E-04  +1.15682000E-03  +9.15890000E-04  +2.54780000E-04  +5.82980000E-04
   +2.69300000E-04  -4.63650000E-04  +5.00200000E-04  +5.66150000E-04  +1.18513000E-03
   +2.74510000E-04  +3.30370000E-04  -1.32800000E-05  +3.08650000E-04  +2.63040000E-04
   +1.59400000E-04  +7.98340000E-04  +7.48800000E-04  -1.45840000E-04  +9.47000000E-04
   +8.17760000E-04  -1.45750000E-04  +7.99800000E-05  +3.59220000E-04  -4.16310000E-04
   -2.04960000E-04  +5.53980000E-04  +7.51300000E-05  -6.66890000E-04  -1.30900000E-04
   +1.73010000E-04  -1.54574440E-01  +2.05825280E-01  -5.19010000E-03  -1.25002600E-02
   +1.43252000E-03  -9.23804000E-03  -6.22511000E-03  -1.66045300E-02  +5.40765000E-03
   +2.26674300E-02  -7.41433000E-03  +6.19161000E-03  -4.75450000E-03  -2.90437000E-03
   -1.09659000E-03  -7.65260000E-04  -5.12554000E-03  -4.37278000E-03  +2.80066000E-03
   -5.03140000E-04  +2.17976000E-03  +2.01921000E-03  -7.82390000E-04  +4.24620000E-04
   -7.75880000E-04  -6.25540000E-04  +1.08720000E-04  +4.51320000E-04  +1.23562000E-03
   +1.27960000E-04  -6.42630000E-04  +7.71030000E-04  +1.06800000E-05  -7.18000000E-06
   -2.64150000E-04  +1.33360000E-04  +9.10600000E-05  +1.23300000E-04  -2.14900000E-05
   -6.22300000E-05  +4.52800000E-05  -4.92300000E-05  -6.30200000E-05  +1.10620000E-04
   -2.36950000E-04  +4.38200000E-05  -2.97210000E-04  +3.63500000E-05  +1.36200000E-05
   +3.12700000E-05  -1.05865000E-03  +6.95470000E-04  +7.50400000E-05  +1.79660000E-04
   +3.18890000E-04  +4.27167000E-03  +3.97000000E-06  +6.70000000E-07  -1.29600000E-05
   +2.18000000E-05  +1.96200000E-05  +4.02000000E-06  +6.29100000E-05  -1.83600000E-05
   +1.05050000E-04  -6.12900000E-05  +1.59700000E-05  +8.94700000E-05  -3.63800000E-05
   -1.43000000E-05  +1.44000000E-06  -6.40270000E-04  -8.38390000E-04  +1.47570000E-04
   +1.76870000E-04  -1.81000000E-05  +4.28350000E-04  -3.49510000E-04  -2.92710000E-04
   +6.54300000E-05  +5.25800000E-05  +1.03800000E-05  +2.30450000E-04  +9.25990000E-04
   +5.16560000E-04  -2.64340000E-04  +3.42700000E-04  +1.69030000E-04  +4.66400000E-05
   -3.91510000E-04  -4.10160000E-04  +4.61890000E-04  -1.07170000E-03  -7.00910000E-04
   +4.87350000E-04  +7.73750000E-04  +4.35940000E-04  +1.31570000E-04  +6.51800000E-04
   +4.26040000E-04  +4.41120000E-04  +9.71700000E-05  -6.78100000E-05  +2.74000000E-04
   -1.36730000E-04  +3.70950000E-04  -3.47080000E-04  +2.37303700E-02  -1.70100570E-01
   +5.48216960E-01  +1.13810000E-04  +8.86770000E-04  +3.39300000E-04  +6.41254000E-03
   +3.59315000E-03  +5.48806000E-03  -7.49210000E-04  -5.04113000E-03  +1.66584000E-03
   -1.66104000E-03  +1.21495000E-03  +7.19580000E-04  +6.77780000E-04  +2.50670000E-04
   +1.30690000E-03  +7.78320000E-04  -5.58090000E-04  -2.06100000E-04  -1.36250000E-03
   -1.55587000E-03  +1.47342000E-03  -1.09250000E-04  +3.59810000E-04  -1.44720000E-04
   -1.15180000E-04  -1.89490000E-04  -2.70300000E-04  -3.82080000E-04  +5.61420000E-04
   -4.47690000E-04  +6.88300000E-05  +3.89900000E-05  +2.33500000E-04  -7.21700000E-05
   -6.85000000E-06  -1.25570000E-04  -1.51460000E-04  -9.75500000E-05  -7.93900000E-05
   +1.19200000E-04  +9.26400000E-05  -4.77700000E-05  +1.41190000E-04  +2.52600000E-05
   +2.05870000E-04  +1.76930000E-04  +1.62990000E-04  -5.70000000E-07  -9.33640000E-04
   -1.01150000E-03  +2.11100000E-05  -5.69360000E-04  -4.39160000E-04  -1.02327000E-03
   -3.26300000E-05  -3.16900000E-05  -7.98000000E-06  +1.83500000E-05  -6.36000000E-06
   +1.14500000E-05  -1.11110000E-04  -3.73200000E-05  -1.52710000E-04  +1.16800000E-05
   -2.23600000E-05  -4.08700000E-05  +3.37000000E-05  +1.71500000E-05  -9.04000000E-06
   -1.21782000E-03  +2.51624000E-03  +6.61350000E-04  -8.04190000E-04  -2.40370000E-04
   -7.72300000E-04  +8.29640000E-04  +4.69080000E-04  -3.95380000E-04  +4.10400000E-05
   +1.34400000E-05  -2.60940000E-04  +6.48600000E-05  -1.68060000E-04  +5.23400000E-05
   -1.31540000E-04  +9.78000000E-06  +8.04200000E-05  +1.47050000E-04  +1.51330000E-04
   -9.97600000E-05  +2.92140000E-04  +2.02390000E-04  -1.32100000E-04  -5.66400000E-05
   +6.55000000E-06  -3.60200000E-05  -2.42180000E-04  -2.95880000E-04  -5.06840000E-04
   -7.97000000E-06  +4.38800000E-05  -7.81700000E-05  +1.88180000E-04  +3.58880000E-04
   +1.71500000E-04  -4.39234300E-02  +6.08391000E-03  +2.58474000E-03  +4.02211400E-02
   +2.19880000E-04  +1.32286000E-03  -7.41590000E-04  +8.09970000E-04  -1.51200000E-05
   +6.31545000E-03  -6.99750000E-04  -4.88447000E-03  +1.25634000E-03  -1.57770000E-03
   +1.24252000E-03  +7.18640000E-04  +3.05520000E-04  -2.65470000E-04  +1.76725000E-03
   +1.44310000E-03  -1.13723000E-03  -8.90900000E-05  -4.56070000E-04  +5.26250000E-04
   -2.26220000E-04  +2.68190000E-04  -3.30410000E-04  -2.57500000E-05  +1.76400000E-05
   +2.92620000E-04  -4.26450000E-04  +2.44030000E-04  -4.29550000E-04  +1.03010000E-04
   +5.70000000E-07  -3.02600000E-05  -1.52630000E-04  +4.11700000E-05  +3.06000000E-05
   -1.58100000E-05  -9.16200000E-05  -6.95600000E-05  +3.44100000E-05  -6.00000000E-08
   -1.74100000E-05  +5.02000000E-05  +1.36500000E-05  -9.85800000E-05  +1.92300000E-05
   +1.01060000E-04  +5.59300000E-05  +1.68000000E-06  +8.75310000E-04  +1.31650000E-03
   +6.36760000E-04  -2.88970000E-04  +2.81220000E-04  -1.41846000E-03  -2.45400000E-05
   +4.37000000E-06  -3.77000000E-06  -3.35000000E-06  +1.83400000E-05  +7.16000000E-06
   +3.70000000E-07  +3.99000000E-05  +4.92100000E-05  -7.20000000E-07  -7.04000000E-06
   +7.10000000E-06  -9.37000000E-06  +9.38000000E-06  +4.59000000E-06  +1.24645000E-03
   -1.14170000E-03  -6.37250000E-04  -1.41880000E-04  +1.39540000E-04  -2.47660000E-04
   -2.39370000E-04  -4.88830000E-04  -9.08800000E-05  -2.31800000E-05  -3.40100000E-05
   +3.83500000E-05  -1.13330000E-04  +2.49800000E-04  -6.59200000E-05  +1.64140000E-04
   +2.10000000E-07  -9.85800000E-05  +3.58500000E-05  +1.28960000E-04  -8.45000000E-05
   +1.87750000E-04  +1.16210000E-04  -1.33350000E-04  -1.32900000E-04  -7.57800000E-05
   -6.59200000E-05  -5.45400000E-04  -1.68580000E-04  -2.49820000E-04  -2.64900000E-05
   -8.05000000E-05  -7.91900000E-05  +7.13100000E-05  -4.37900000E-04  +3.24760000E-04
   +1.50810100E-02  -6.46209100E-02  +1.40512460E-01  -1.69731600E-02  +7.39988600E-02
   +3.40830000E-04  -1.80041000E-03  +2.42800000E-05  +4.83303000E-03  +5.26630000E-03
   -4.84130000E-04  +2.40610000E-04  -4.19830000E-04  +4.36960000E-04  +8.23000000E-06
   -1.09090000E-04  +3.32700000E-04  -9.93500000E-05  +2.40120000E-04  +1.56500000E-04
   -5.72940000E-04  +2.51830000E-04  -5.14580000E-04  -7.00000000E-05  -6.25590000E-04
   -3.21600000E-04  +2.61900000E-05  -3.60000000E-05  -7.75400000E-05  +5.56500000E-05
   -2.33490000E-04  -2.47700000E-05  -1.60420000E-04  +3.54000000E-04  +6.56000000E-06
   +5.22000000E-06  -5.09900000E-05  +1.17230000E-04  -4.85100000E-05  -9.03200000E-05
   +8.35000000E-06  +1.01150000E-04  +1.05930000E-04  -1.81600000E-05  -2.15200000E-05
   -2.33100000E-05  -4.10000000E-05  -2.18500000E-05  +7.76000000E-06  -4.11800000E-05
   -1.35040000E-04  -9.81500000E-05  -1.19900000E-05  -2.84030000E-04  +1.21852000E-03
   +6.50820000E-04  +1.68250000E-04  -8.39800000E-05  -1.51050000E-04  +1.84000000E-05
   +8.02000000E-06  +1.39100000E-05  -1.82700000E-05  -1.90600000E-05  -8.55000000E-06
   -1.98500000E-05  +2.62200000E-05  +8.05000000E-06  +7.09000000E-06  +1.09600000E-05
   -6.30000000E-07  -2.03000000E-06  -1.04800000E-05  -8.30000000E-07  +2.89300000E-05
   -4.90100000E-04  +3.99960000E-04  -4.40700000E-04  -2.60680000E-04  -4.43090000E-04
   -3.11320000E-04  -2.50880000E-04  -3.21080000E-04  -3.40500000E-05  -3.41900000E-05
   -1.01500000E-05  -6.09000000E-06  +1.33160000E-04  -4.35700000E-05  +2.14200000E-05
   +5.46700000E-05  +3.40300000E-05  -1.09950000E-04  -8.04500000E-05  +1.74220000E-04
   +4.03400000E-05  +1.95600000E-05  -1.56100000E-05  +1.38590000E-04  +1.74800000E-05
   -2.36300000E-05  -4.12860000E-04  -8.15700000E-05  -2.36690000E-04  -2.49700000E-05
   +3.86800000E-05  +1.92900000E-05  -1.11720000E-04  +1.35900000E-05  +1.77140000E-04
   -2.79975000E-02  +1.65535180E-01  -4.80857320E-01  +2.16926400E-02  -1.67407650E-01
   +4.86763610E-01  +2.89690000E-04  -2.39424000E-03  -8.99860000E-04  +6.92666000E-03
   +8.06343000E-03  -7.23370000E-04  -2.03370000E-04  -2.68370000E-03  +8.63820000E-04
   -1.95193000E-03  +1.14359000E-03  +2.97090000E-04  +4.43795000E-03  +1.99223000E-03
   -1.88230000E-04  -1.13983000E-03  +7.64080000E-04  -2.11200000E-05  -4.71660000E-04
   -8.51430000E-04  -1.86620000E-04  -3.30400000E-05  +8.23200000E-05  -7.87000000E-06
   -1.17989000E-03  -2.01024000E-03  +3.33120000E-04  -2.08450000E-04  +5.51420000E-04
   +4.55700000E-05  -6.85000000E-06  -1.30000000E-05  +2.38560000E-04  -1.46270000E-04
   -2.50790000E-04  +1.56730000E-04  +6.05670000E-04  +4.88500000E-04  -1.20000000E-07
   -1.87950000E-04  -5.67300000E-05  -1.95910000E-04  -5.20800000E-05  +8.12800000E-05
   -8.06300000E-05  -7.00200000E-04  -5.21160000E-04  -4.50700000E-05  -2.23190000E-04
   +4.84670000E-04  +2.13000000E-04  +2.16508000E-03  -2.20502500E-02  -5.32350000E-04
   +1.23600000E-04  +6.20800000E-05  +4.42700000E-05  -5.14000000E-05  -4.82500000E-05
   -4.69900000E-05  +6.31700000E-05  +2.95600000E-05  +5.52000000E-05  +5.30000000E-05
   +3.72100000E-05  -8.50300000E-05  -6.03000000E-06  -3.92400000E-05  +6.41000000E-06
   -1.61600000E-05  -5.71790000E-04  +2.85000000E-05  +1.04390000E-04  -4.11800000E-05
   +5.37600000E-05  -3.41050000E-04  -1.07110000E-04  -3.27900000E-05  -3.95200000E-05
   -6.87700000E-05  +4.22700000E-05  +1.01790000E-04  -2.42530000E-04  -3.26560000E-04
   -1.55530000E-04  +4.77400000E-05  +3.36000000E-06  +9.26500000E-05  +1.00660000E-04
   -4.12900000E-05  +2.26100000E-05  -3.69400000E-05  +4.92400000E-05  +4.14900000E-05
   -5.56000000E-06  -4.98600000E-05  +6.55300000E-05  +9.97600000E-05  -4.58600000E-05
   +2.43000000E-06  +7.69450000E-04  -8.15900000E-05  -5.55294700E-02  -5.41880000E-02
   -1.34923600E-02  -4.58573000E-02  +2.89978800E-02  -4.05811000E-03  -3.47039000E-03
   +2.49620000E-04  +1.45081000E-03  +3.07979040E-01  -2.15941000E-03  +6.97833000E-03
   +2.50471000E-03  -8.56633000E-03  -1.74879100E-02  +2.58656000E-03  -3.34365000E-03
   +6.38963000E-03  -2.31931000E-03  +3.07784000E-03  -4.38916000E-03  -2.37502000E-03
   +1.95339400E-02  -9.94493000E-03  -4.23276000E-03  +3.99933000E-03  -3.68659000E-03
   +2.10403000E-03  +1.56939000E-03  +1.23209000E-03  -1.41910000E-04  -4.19080000E-04
   +2.09400000E-05  -3.12900000E-05  -9.23794000E-03  -6.08741000E-03  +2.11616000E-03
   +5.46900000E-05  -1.91460000E-04  -2.25100000E-05  +1.34030000E-04  +2.09240000E-04
   +1.30410000E-04  -4.59600000E-05  +3.75000000E-05  +3.33200000E-05  +7.08600000E-05
   +3.09000000E-06  -4.30500000E-05  +1.50100000E-05  +1.86490000E-04  -1.04800000E-05
   -7.77700000E-05  +1.55230000E-04  +1.31870000E-04  -5.55300000E-05  +1.61700000E-05
   -5.16000000E-06  -2.05030000E-04  -1.96500000E-04  -1.56030000E-04  -4.86268600E-02
   -6.03467400E-02  -1.37540000E-03  +4.28700000E-05  -2.19400000E-05  -5.81000000E-06
   +1.96500000E-05  -9.91000000E-06  -8.78000000E-06  +9.03000000E-06  -6.62100000E-05
   -6.56500000E-05  +8.68600000E-05  -1.01700000E-04  -1.41720000E-04  +4.48100000E-05
   -7.50000000E-06  -1.89100000E-05  +6.83900000E-05  +5.33530000E-04  +1.86000000E-06
   -5.63000000E-05  -1.02390000E-04  +6.76200000E-05  +2.06260000E-04  +2.53880000E-04
   -3.31700000E-05  +1.38370000E-04  +2.48200000E-05  -1.43550000E-04  -5.19700000E-05
   +1.55160000E-04  +2.38430000E-04  +2.82800000E-05  +1.25270000E-04  +4.96400000E-05
   -1.02620000E-04  +3.37090000E-04  +2.26160000E-04  +1.61980000E-04  -3.31000000E-05
   -1.58690000E-04  +2.09570000E-04  -6.92700000E-05  +1.43630000E-04  -1.41650000E-04
   +2.90110000E-04  -2.23170000E-04  +7.86390000E-04  +2.48738000E-03  -3.32160000E-04
   -1.55729200E-02  -2.08253920E-01  +1.98217700E-02  +4.62880600E-02  -4.02515000E-03
   +3.12064000E-03  +1.24145000E-03  -4.92720000E-04  -5.89290000E-04  +7.93133400E-02
   +3.45006440E-01  -3.77480000E-04  +2.04850000E-04  +6.10410000E-04  -3.55730000E-04
   +4.11260000E-04  -2.35729000E-03  +1.35687000E-03  +8.25230000E-04  +5.38270000E-04
   +8.52190000E-04  -6.51020000E-04  -5.07850000E-04  +1.26529000E-03  -1.09365000E-03
   +2.13850000E-04  +1.46740000E-04  -4.68500000E-05  +1.01660000E-04  -3.06800000E-05
   +1.98000000E-05  +6.01600000E-05  -3.43500000E-05  -2.09800000E-05  -2.41000000E-06
   -8.83370000E-04  -4.66470000E-04  +3.32000000E-05  -8.22000000E-06  -6.67000000E-06
   +8.17100000E-05  -4.22500000E-05  +2.19000000E-06  -3.56100000E-05  +5.34500000E-05
   +5.37400000E-05  +5.22000000E-06  -5.70600000E-05  -6.06800000E-05  +1.97000000E-05
   -2.43000000E-06  -3.66500000E-05  +3.18500000E-05  +2.21200000E-05  +1.79500000E-05
   -8.14400000E-05  +7.05700000E-05  +5.83600000E-05  +1.82000000E-05  +3.97200000E-05
   -4.39200000E-05  -5.20700000E-05  -2.75030000E-03  -5.46090000E-03  +1.05658000E-02
   -8.68000000E-06  -9.85000000E-06  -9.83000000E-06  +1.35300000E-05  +3.29000000E-06
   +4.65000000E-06  +7.27000000E-06  -1.78700000E-05  +7.43000000E-06  -2.30900000E-05
   -1.17000000E-06  +5.71600000E-05  -4.50000000E-06  -4.36000000E-06  -5.31000000E-06
   +2.14500000E-05  -1.21600000E-05  -2.23000000E-06  +1.48900000E-05  +6.17000000E-06
   +4.60100000E-05  -2.58000000E-06  -8.16000000E-06  +2.08100000E-05  -6.62700000E-05
   -1.72700000E-05  +5.37000000E-05  -1.80400000E-05  +6.09700000E-05  -5.92600000E-05
   +3.17600000E-05  -1.53500000E-05  +3.36700000E-05  -2.46380000E-04  +3.95400000E-05
   +1.87010000E-04  -2.38000000E-06  -2.89230000E-04  +1.42620000E-04  +5.49400000E-05
   +1.07160000E-04  +6.31800000E-05  +6.24300000E-05  +3.49900000E-05  +8.81000000E-05
   +8.45600000E-05  +1.58840000E-04  +1.93000000E-05  -1.76227600E-02  -1.06251000E-02
   -4.32701600E-02  -5.49060000E-03  +4.16434000E-03  +1.02988200E-02  +2.41955000E-03
   -1.34861000E-03  -1.63500000E-05  +2.79943460E-01  +4.11407700E-02  +3.75071280E-01
   -1.36300000E-05  -2.31600000E-05  +1.49150000E-04  -1.56590000E-04  +5.18880000E-04
   -8.88840000E-04  +5.81070000E-04  +1.36300000E-05  +3.03170000E-04  -6.62900000E-05
   -1.83100000E-04  +8.99000000E-06  -3.69910000E-04  -3.08500000E-04  -2.04090000E-04
   -2.52100000E-05  +5.63000000E-05  +6.55800000E-05  -4.04400000E-05  +2.75200000E-05
   +3.26400000E-05  +1.27100000E-05  -3.27000000E-05  -4.40000000E-07  +8.87200000E-05
   +3.66440000E-04  +2.09400000E-05  +1.66600000E-05  -4.94600000E-05  +3.22100000E-05
   -2.31200000E-05  -1.60200000E-05  -5.24300000E-05  +4.41500000E-05  +4.84000000E-05
   -2.67400000E-05  -1.15570000E-04  -9.51300000E-05  +1.13000000E-05  +2.52000000E-05
   -1.62300000E-05  +4.08400000E-05  +1.52400000E-05  -2.03200000E-05  -2.49200000E-05
   +1.32070000E-04  +9.83300000E-05  +1.22400000E-05  +2.90100000E-05  +5.68000000E-06
   -1.31400000E-05  +9.22590000E-04  +5.70020000E-04  +9.62680000E-04  -2.45800000E-05
   -1.21000000E-05  -8.34000000E-06  +9.06000000E-06  +8.08000000E-06  +9.20000000E-06
   -8.78000000E-06  -2.68000000E-06  +7.00000000E-07  -2.28500000E-05  -1.37000000E-06
   +3.82800000E-05  -2.78000000E-06  +3.93000000E-06  -2.61000000E-06  -1.74100000E-05
   -9.18000000E-06  -6.84000000E-06  -8.41000000E-06  +9.63000000E-06  +2.88000000E-06
   +7.14000000E-06  -2.51900000E-05  +6.84000000E-06  -3.72000000E-05  -1.33000000E-06
   +2.53600000E-05  -1.82400000E-05  +4.95000000E-05  -1.62300000E-05  +3.40400000E-05
   -1.82300000E-05  +1.39000000E-05  -1.51810000E-04  -4.73000000E-06  +9.73000000E-05
   -1.75700000E-05  -1.37190000E-04  +8.48000000E-05  -1.28000000E-06  -9.48000000E-06
   +2.12100000E-05  -8.94000000E-06  -3.74000000E-06  +4.45300000E-05  +3.43800000E-05
   -8.94600000E-05  +1.19600000E-05  -6.30308000E-03  +6.16960000E-04  -8.73837000E-03
   -3.01220000E-03  +2.65978000E-03  +1.60722000E-03  +2.37650000E-04  -4.68700000E-05
   +6.09900000E-05  -2.18790940E-01  -3.82993700E-02  -2.56895620E-01  +2.27531490E-01
   +7.60600000E-05  -3.01400000E-05  -1.79500000E-05  -2.61730000E-04  -2.10800000E-05
   -1.56240000E-04  +1.62990000E-04  -1.07700000E-04  +1.76930000E-04  -2.11670000E-04
   +1.28950000E-04  -2.03000000E-04  +5.63990000E-04  -6.54000000E-05  +3.98260000E-04
   +1.32840000E-04  +6.96400000E-05  -7.49800000E-05  -1.98700000E-05  +5.76500000E-05
   +4.75300000E-05  +6.25500000E-05  +1.53100000E-05  -5.50000000E-07  -2.52980000E-04
   -1.15620000E-04  -5.14000000E-06  +3.83000000E-05  -6.11300000E-05  -1.14700000E-05
   -4.26000000E-06  -1.21000000E-05  -2.91700000E-05  +1.49000000E-05  +2.08500000E-05
   -1.44200000E-05  -5.12900000E-05  -3.87000000E-05  +5.51000000E-06  +1.39500000E-05
   -4.60000000E-06  +1.50400000E-05  +1.25500000E-05  -1.92000000E-05  -1.18000000E-06
   +5.97500000E-05  +3.80500000E-05  +2.58000000E-06  +6.35000000E-05  -2.94100000E-05
   -1.42500000E-05  +2.65130000E-04  -5.13444000E-03  +2.33521000E-03  -1.32800000E-05
   -1.84000000E-06  -2.49000000E-06  +1.82000000E-06  +6.03000000E-06  +4.89000000E-06
   -5.11000000E-06  +2.02000000E-06  -6.60000000E-07  -1.10900000E-05  +7.12000000E-06
   +1.46000000E-05  -2.72000000E-06  +4.52000000E-06  +7.90000000E-07  -8.03000000E-06
   +3.55200000E-05  +2.00000000E-07  -1.42000000E-05  +5.92000000E-06  -1.70000000E-05
   +2.98700000E-05  -4.01000000E-06  +8.47000000E-06  -1.90000000E-06  +4.36000000E-06
   +3.33000000E-06  -4.60000000E-06  +9.69000000E-06  +3.45400000E-05  +1.08700000E-05
   -1.55100000E-05  -5.91000000E-06  +3.85800000E-05  +1.67800000E-05  -4.39900000E-05
   -2.95500000E-05  -6.75200000E-05  +7.31100000E-05  -1.14900000E-05  +1.38100000E-05
   -3.57000000E-06  -2.81500000E-05  -2.14400000E-05  +1.75300000E-05  -3.26700000E-05
   +3.31900000E-05  -3.11800000E-05  -2.29133000E-02  +5.90010000E-03  -3.10125500E-02
   +4.53922000E-03  -3.48817000E-03  -1.39554000E-03  -3.16940000E-04  +4.19210000E-04
   -5.36500000E-05  -1.70152100E-02  -4.57684600E-02  -2.22996100E-02  +3.86643600E-02
   +4.31663200E-02  +3.65300000E-05  -1.89200000E-05  -6.32100000E-05  -3.27160000E-04
   -5.10890000E-04  +4.25830000E-04  -2.22650000E-04  +8.03600000E-05  -1.70190000E-04
   +6.99200000E-05  -4.41000000E-06  +1.04940000E-04  -1.75630000E-04  -2.70000000E-07
   +3.08510000E-04  -2.58000000E-06  +4.29500000E-05  -1.04560000E-04  +4.11700000E-05
   +4.42800000E-05  +1.28500000E-05  +8.13000000E-06  +1.11400000E-05  +5.30000000E-07
   +1.05060000E-04  +8.70300000E-05  -1.14510000E-04  +1.11400000E-05  -1.66200000E-05
   -2.69100000E-05  +1.07300000E-05  +7.30000000E-07  +2.77000000E-06  -1.01300000E-05
   -3.59000000E-06  -2.77000000E-06  +9.02000000E-06  +7.66000000E-06  -1.58000000E-06
   +1.48000000E-06  +1.01900000E-05  -5.30000000E-06  +5.94000000E-06  -7.30000000E-06
   +2.12300000E-05  -8.66000000E-06  -7.37000000E-06  -5.08000000E-06  +6.19000000E-06
   -2.88500000E-05  -8.48000000E-06  +6.70860000E-04  +1.28946000E-03  -2.15600000E-05
   +1.30000000E-06  +1.95000000E-06  +2.18000000E-06  -2.54000000E-06  +2.20000000E-07
   -7.70000000E-07  -1.55000000E-06  +1.21000000E-06  -4.06000000E-06  +3.57000000E-06
   +1.22000000E-06  -7.62000000E-06  +2.88000000E-06  +2.38000000E-06  +1.45000000E-06
   -3.50000000E-07  +2.80600000E-05  +9.65000000E-06  -5.23000000E-06  -4.09000000E-06
   -1.30400000E-05  +1.68700000E-05  +1.14100000E-05  -1.79000000E-06  +2.37800000E-05
   +1.18600000E-05  -1.47400000E-05  -3.09000000E-06  -1.97300000E-05  +3.13400000E-05
   -9.49000000E-06  +8.20000000E-07  -8.89000000E-06  +8.63500000E-05  -2.92500000E-05
   -4.73800000E-05  +1.73900000E-05  +1.10840000E-04  -6.33200000E-05  -7.72000000E-06
   +1.42600000E-05  -1.17200000E-05  +3.77000000E-06  -1.29900000E-05  -1.26300000E-05
   -3.46400000E-05  -2.66300000E-05  +4.00600000E-05  -2.17999000E-03  +1.46422000E-03
   -3.76409000E-03  +3.45665000E-03  -2.39624000E-03  -2.92800000E-05  +7.53200000E-05
   -1.51680000E-04  -3.88000000E-05  -2.68952890E-01  -5.03866500E-02  -3.32145810E-01
   +2.70128680E-01  +4.65720100E-02  +3.35127100E-01  -1.32943000E-03  +7.11081000E-03
   +2.04794000E-03  -1.96057200E-02  -2.14206000E-02  +4.95749000E-03  -3.17023000E-03
   +6.76214000E-03  -2.45764000E-03  +3.82907000E-03  -3.35434000E-03  -1.84792000E-03
   +6.30780000E-03  -3.53632000E-03  -7.24030000E-04  +4.10500000E-03  -3.01263000E-03
   +1.02133000E-03  +1.05442000E-03  +1.27948000E-03  +1.83700000E-04  -1.00750000E-04
   -1.54490000E-04  -1.40340000E-04  -3.01581000E-03  -2.40960000E-04  +4.26650000E-04
   +1.35530000E-04  -7.01260000E-04  -1.27730000E-04  +1.13100000E-04  +1.29930000E-04
   -1.58330000E-04  +1.18470000E-04  +2.72330000E-04  -1.87070000E-04  -6.81980000E-04
   -5.65850000E-04  -4.35900000E-05  +2.41250000E-04  +1.78420000E-04  +1.98630000E-04
   +1.73200000E-05  -5.00000000E-08  +2.07420000E-04  +7.98610000E-04  +6.21180000E-04
   +4.34200000E-05  +3.08650000E-04  -9.89230000E-04  -1.50210000E-04  -1.36884700E-02
   -1.05167400E-02  +2.23780000E-04  -1.29210000E-04  -8.31300000E-05  -5.23800000E-05
   +6.84300000E-05  +5.35200000E-05  +5.22400000E-05  -9.59900000E-05  -6.57900000E-05
   -1.15140000E-04  -2.53200000E-05  -9.13500000E-05  -9.10000000E-06  +3.08300000E-05
   +4.96500000E-05  -1.28500000E-05  -1.67380000E-04  +1.17927000E-03  +2.21000000E-05
   -1.89860000E-04  -2.76200000E-05  -1.13760000E-04  +6.92010000E-04  +3.10060000E-04
   -3.12900000E-05  +1.81700000E-04  +1.28220000E-04  -1.79980000E-04  -1.56010000E-04
   +3.63550000E-04  +6.25990000E-04  +2.19940000E-04  +1.48700000E-05  -9.00000000E-08
   +1.47000000E-05  +2.41300000E-05  -3.09300000E-05  -1.07920000E-04  +1.14530000E-04
   -2.17030000E-04  -7.53800000E-05  -1.52800000E-05  +1.36100000E-04  -1.41020000E-04
   +1.39000000E-05  -6.29500000E-05  +6.02250000E-04  +4.66720000E-04  -9.15000000E-05
   +1.69104700E-02  +2.62109500E-02  +2.87612000E-03  -1.80098020E-01  +1.05717840E-01
   -1.78229200E-02  +5.52974000E-03  +1.81600000E-05  +1.66460000E-03  +7.68773000E-03
   -3.01380100E-02  -1.53799000E-03  -4.84350000E-04  -3.54119000E-03  -2.84841000E-03
   +1.74295810E-01  +8.17010000E-04  -5.29676000E-03  -2.34648000E-03  +6.33562000E-03
   +2.54254700E-02  -4.49675000E-03  +2.11909000E-03  -3.33111000E-03  +2.57231000E-03
   -1.82923000E-03  +1.03276000E-03  +1.36472000E-03  -3.42755000E-03  +4.09360000E-04
   -8.93000000E-05  -2.77506000E-03  +1.63595000E-03  -9.61000000E-04  -3.69492000E-03
   -3.69111000E-03  -5.24000000E-06  +2.27420000E-04  -1.01790000E-04  -2.48210000E-04
   +1.59865000E-03  +6.29250000E-04  -1.42350000E-04  -9.51190000E-04  +1.34315000E-03
   +1.52180000E-04  -1.25740000E-04  -1.83290000E-04  +3.07320000E-04  -1.02450000E-04
   -3.71590000E-04  +1.00750000E-04  +4.55080000E-04  +4.47340000E-04  -1.94300000E-05
   -1.58050000E-04  -2.51620000E-04  -1.74200000E-04  -3.10000000E-06  +2.09300000E-05
   -3.37660000E-04  -5.93220000E-04  -4.62060000E-04  -2.09700000E-05  -1.21710000E-04
   -2.97760000E-04  +5.58470000E-04  +6.38762000E-03  +5.77101000E-03  +2.03490000E-04
   +7.51700000E-05  +5.41600000E-05  +4.74600000E-05  -5.93300000E-05  -5.28100000E-05
   -3.51000000E-05  -1.11000000E-06  +1.02900000E-04  +7.42200000E-05  -4.66400000E-05
   +1.10940000E-04  +1.15760000E-04  -4.03600000E-05  -4.26900000E-05  +1.09900000E-05
   +1.00400000E-04  -4.18980000E-04  +9.04300000E-05  +1.10510000E-04  +4.35500000E-05
   +2.26300000E-05  -2.87460000E-04  -6.59700000E-05  -4.38500000E-05  -1.30700000E-04
   -4.82600000E-05  +1.61050000E-04  +1.65170000E-04  -1.61930000E-04  -2.67740000E-04
   -9.14000000E-05  -2.11600000E-05  +2.94300000E-05  +4.07000000E-06  -8.36000000E-06
   -3.77100000E-05  +4.19700000E-05  -5.42100000E-05  +1.12310000E-04  +1.10930000E-04
   +3.66800000E-05  -2.75100000E-05  +1.79950000E-04  +5.36000000E-05  +1.23150000E-04
   -3.41660000E-04  -3.30230000E-04  +8.22000000E-05  +1.16996000E-03  -1.74069500E-02
   -2.23955000E-03  +8.32306300E-02  -1.05661010E-01  +2.49531500E-02  +8.69104000E-03
   -5.36728000E-03  -4.52840000E-04  -2.01627000E-02  -3.15943000E-03  -4.77293000E-03
   -4.31190000E-03  +5.05139000E-03  +3.83121000E-03  -7.25648100E-02  +1.04617890E-01
   -3.23400000E-04  +6.92980000E-04  -4.35600000E-04  -1.65585000E-03  -5.56627000E-03
   +2.24704000E-03  -3.67610000E-04  +9.80940000E-04  -1.14276000E-03  -6.84700000E-05
   +3.10700000E-04  -4.08260000E-04  +3.02200000E-04  -1.71790000E-04  +9.59340000E-04
   +6.36330000E-04  -6.49290000E-04  -5.25600000E-05  +6.07920000E-04  +7.57120000E-04
   -3.25920000E-04  +9.35800000E-05  -4.35000000E-06  +1.00000000E-06  -1.97730000E-04
   -6.75000000E-05  -2.01060000E-04  +1.99770000E-04  -3.36220000E-04  -2.09100000E-05
   +6.56600000E-05  +2.40100000E-05  -7.92400000E-05  +1.08900000E-05  +6.14800000E-05
   -3.22200000E-05  -9.40300000E-05  -8.45200000E-05  +1.56700000E-05  +2.48800000E-05
   +5.74200000E-05  +2.25700000E-05  -2.10000000E-07  -2.67000000E-06  +1.09140000E-04
   +1.20710000E-04  +8.93000000E-05  -4.72000000E-06  -3.52710000E-04  +4.28060000E-04
   +3.11300000E-05  -8.30020000E-04  -6.45800000E-04  -7.62920000E-04  -1.78400000E-05
   -8.30000000E-06  -6.79000000E-06  +7.07000000E-06  +1.38800000E-05  +7.31000000E-06
   -1.06000000E-06  -7.70000000E-07  -1.57900000E-05  +2.41500000E-05  -2.66500000E-05
   -4.62200000E-05  +1.04200000E-05  +1.33000000E-05  +3.80000000E-07  -2.88430000E-04
   -9.06000000E-06  -2.65730000E-04  +1.27010000E-04  +7.01900000E-05  +7.78100000E-05
   -3.99600000E-05  -5.97500000E-05  +6.78500000E-05  +1.55420000E-04  +5.35400000E-05
   -6.64000000E-05  +1.23200000E-05  +7.41000000E-05  +3.59610000E-04  +5.94200000E-05
   +3.01300000E-05  -6.74700000E-05  +3.19400000E-04  +2.98000000E-05  -2.87810000E-04
   -6.79400000E-05  +2.31300000E-05  -6.93500000E-05  -1.77400000E-05  -1.49400000E-05
   -4.87600000E-05  -1.04110000E-04  -1.80600000E-05  -4.79500000E-05  +2.88400000E-05
   +2.40900000E-05  -2.43200000E-05  +1.78149000E-03  +2.29367000E-03  +3.15930000E-04
   +2.05750200E-02  +3.83148000E-03  -5.34942900E-02  -3.43654000E-02  +2.19141400E-02
   -5.62130000E-03  +6.26930000E-03  -1.15970900E-02  -1.98281500E-02  -6.91498000E-03
   +5.68396000E-03  +5.99640000E-04  +1.42756700E-02  -1.81944000E-02  +7.85421100E-02
end_hess

