# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -883.28539880    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +1.77477642E+00  -5.27619625E-01  -2.23290021E+00
   006   +1.50663250E+00  +1.08570105E+00  -1.10360765E-02
   006   +2.68461760E+00  +2.47264174E-01  +2.28996510E+00
   006   +4.67127497E+00  -1.32009854E+00  +2.12530207E+00
   006   +5.78428620E+00  -2.00469071E+00  -4.05458285E-01
   006   +3.75672099E+00  -2.06806251E+00  -2.40873074E+00
   006   -7.37219335E-01  +2.89461074E+00  +8.13749902E-02
   006   -6.45634626E-01  +4.66368523E+00  +2.37606015E+00
   008   +7.05877881E+00  -4.33826825E+00  -3.47654711E-01
   006   -3.04275117E+00  +1.11945798E+00  +2.29521635E-01
   006   -4.69647950E+00  +8.00330592E-01  -1.78574787E+00
   006   -6.74490118E+00  -8.25560103E-01  -1.63769360E+00
   006   -7.17642827E+00  -2.19912142E+00  +5.52277072E-01
   006   -5.53605072E+00  -1.92683527E+00  +2.58369760E+00
   006   -3.50953740E+00  -2.95510512E-01  +2.40638508E+00
   008   -9.14248982E+00  -3.81686371E+00  +8.16648349E-01
   006   -8.34869709E-01  +4.58724274E+00  -2.26976461E+00
   008   +7.39755600E+00  -3.01826389E-02  -8.13796707E-01
   001   -1.01213811E+01  -3.85275122E+00  -7.03655563E-01
   001   -8.00657836E+00  -1.01879298E+00  -3.23951718E+00
   001   -4.42201041E+00  +1.83187986E+00  -3.52577388E+00
   001   -2.25679245E+00  -1.49338620E-01  +4.01307934E+00
   001   -5.86826240E+00  -3.00814994E+00  +4.28478706E+00
   001   +6.47618896E-01  +6.00445558E+00  -2.14620384E+00
   001   -6.00658322E-01  +3.56126371E+00  -4.03762610E+00
   001   -2.64128256E+00  +5.57284446E+00  -2.33674949E+00
   001   -8.75440129E-01  +3.68898874E+00  +4.16954722E+00
   001   +1.14599796E+00  +5.67793766E+00  +2.40461239E+00
   001   -2.17983916E+00  +6.02927576E+00  +2.22790039E+00
   001   +2.17197957E+00  +1.11395090E+00  +4.06118493E+00
   001   +5.79296419E+00  -1.82470694E+00  +3.75955623E+00
   001   +4.08563366E+00  -3.24779441E+00  -4.04619101E+00
   001   +3.84208185E-01  -3.86476557E-01  -3.72039850E+00
   001   +8.81132373E+00  -3.87471031E+00  -4.14210785E-01
   001   +5.90798318E+00  +2.13939833E+00  -8.62728990E-01
   008   +4.48086583E+00  +3.60648286E+00  -9.01225532E-01
   001   +4.33464959E+00  +4.03675105E+00  -2.65487087E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +2.30000000E-07  +4.60000000E-07  -4.40000000E-07
   +6.00000000E-08  +2.50000000E-07  +4.10000000E-07
   +0.00000000E+00  +3.90000000E-07  -5.50000000E-07
   +8.20000000E-07  +8.00000000E-07  -8.40000000E-07
   +3.30000000E-07  +9.10000000E-07  -1.26000000E-06
   -3.00000000E-08  +1.17000000E-06  -7.10000000E-07
   -4.80000000E-07  -1.40000000E-07  +3.70000000E-07
   -5.50000000E-07  -3.80000000E-07  +4.70000000E-07
   +8.80000000E-07  +1.46000000E-06  -1.30000000E-06
   -1.00000000E-07  -6.10000000E-07  +3.50000000E-07
   -1.10000000E-07  -6.00000000E-07  +5.30000000E-07
   +8.00000000E-08  -1.13000000E-06  +4.90000000E-07
   +6.10000000E-07  -1.35000000E-06  +3.20000000E-07
   +8.30000000E-07  -1.31000000E-06  +3.30000000E-07
   +3.90000000E-07  -9.00000000E-07  +2.80000000E-07
   +8.90000000E-07  -1.85000000E-06  +4.10000000E-07
   -9.70000000E-07  +7.00000000E-08  +5.80000000E-07
   +1.70000000E-07  +1.47000000E-06  -3.60000000E-07
   +7.80000000E-07  -1.84000000E-06  +4.40000000E-07
   -5.00000000E-08  -1.11000000E-06  +5.70000000E-07
   -5.30000000E-07  -3.40000000E-07  +5.60000000E-07
   +6.00000000E-07  -9.10000000E-07  +3.00000000E-08
   +1.13000000E-06  -1.63000000E-06  +1.30000000E-07
   -1.28000000E-06  +3.90000000E-07  +5.40000000E-07
   -9.50000000E-07  +3.50000000E-07  +3.50000000E-07
   -1.15000000E-06  -2.30000000E-07  +8.20000000E-07
   -1.80000000E-07  -5.30000000E-07  +3.60000000E-07
   -7.80000000E-07  -6.00000000E-08  +4.80000000E-07
   -7.80000000E-07  -6.70000000E-07  +8.30000000E-07
   +3.20000000E-07  +0.00000000E+00  -1.80000000E-07
   +8.90000000E-07  +7.60000000E-07  -9.00000000E-07
   +3.00000000E-07  +1.19000000E-06  -8.60000000E-07
   -2.00000000E-07  +5.60000000E-07  -1.00000000E-07
   +8.80000000E-07  +1.76000000E-06  -1.42000000E-06
   -6.50000000E-07  +1.59000000E-06  -4.80000000E-07
   -4.10000000E-07  +8.30000000E-07  -2.10000000E-07
   -9.90000000E-07  +1.19000000E-06  -1.00000000E-08
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.43078020E-01  -2.82536460E-01  +4.17227770E-01  +1.65623120E-01  +1.13334310E-01
   +5.22559030E-01  -9.44121300E-02  +3.45519400E-02  +2.48438000E-03  +3.56867390E-01
   +6.80653000E-03  -1.13803490E-01  -6.48859200E-02  -1.88788380E-01  +3.50970120E-01
   -3.54523800E-02  -5.74421000E-02  -1.83448910E-01  +8.39587700E-02  +6.69400900E-02
   +5.28906030E-01  +2.67450600E-02  -1.58304800E-02  -1.37199900E-02  -1.09264390E-01
   +2.93441900E-02  -1.33683100E-02  +4.89388450E-01  -1.56467100E-02  +1.52146000E-02
   -1.03780700E-02  +4.28676200E-02  -8.54979900E-02  +2.23780000E-04  -3.07696990E-01
   +4.16824710E-01  -3.91670000E-03  -1.87171000E-03  -3.47796700E-02  -7.00812800E-02
   +2.88356000E-02  -2.18127010E-01  -3.06371200E-02  +1.09448210E-01  +6.53900760E-01
   -1.36665000E-02  +9.75670000E-03  +9.98890000E-03  -2.30127300E-02  +2.49411800E-02
   -5.72334300E-02  -2.99940010E-01  +2.04244730E-01  +4.17228300E-02  +5.73941440E-01
   +3.60655000E-03  -5.76908000E-03  -5.38037000E-03  +1.48781300E-02  -9.67160000E-03
   +2.33465000E-02  +2.04455920E-01  -2.28241150E-01  -3.22574500E-02  -3.05081890E-01
   +4.02507260E-01  +6.69556000E-03  -6.20260000E-03  -5.36807000E-03  -2.36863700E-02
   +1.86814900E-02  +2.48593000E-02  -4.16440000E-03  -1.84124300E-02  -1.30165340E-01
   +9.37738800E-02  -2.05411000E-03  +5.84650570E-01  -1.63883600E-02  +6.25803000E-03
   -1.33125000E-02  +1.70093000E-03  +9.57720000E-04  +7.65607000E-03  -1.53619800E-02
   +1.44040400E-02  +1.32834700E-02  -6.27673900E-02  +2.68551500E-02  +1.07925500E-02
   +5.15927240E-01  +1.21929400E-02  +1.15117700E-02  +1.86486300E-02  +2.04717000E-03
   -1.52855900E-02  +1.13726000E-02  -6.45870000E-03  +8.98894000E-03  -2.56565300E-02
   +4.29450600E-02  -6.64406100E-02  -4.99770800E-02  -7.07746600E-02  +4.56864560E-01
   +9.16660000E-03  -5.83970000E-04  +8.77908000E-03  +2.71725000E-03  +4.19970000E-04
   +2.05081800E-02  -7.15285000E-03  +7.29084000E-03  +1.09712000E-03  +1.85250100E-02
   -3.40587100E-02  -1.86223860E-01  +2.25156100E-02  +2.25997000E-02  +4.74872680E-01
   -3.54000200E-01  +2.14565560E-01  -8.76889000E-03  +4.97638000E-03  +2.20427600E-02
   +3.69523900E-02  -1.52665800E-02  +7.50289000E-03  -8.35755000E-03  +2.19452800E-02
   -7.04487000E-03  -1.47907000E-03  -1.14656490E-01  +2.13142900E-02  -5.50821700E-02
   +5.93494900E-01  +2.23568280E-01  -2.37534470E-01  -2.81818000E-02  +1.68018100E-02
   -2.28929800E-02  -1.89756100E-02  +4.89176000E-03  -2.36053000E-03  +3.42887000E-03
   -7.09446000E-03  +8.54564000E-03  -2.95604000E-03  +8.70798000E-03  -6.82236400E-02
   -1.14806800E-02  -2.84706010E-01  +4.92314570E-01  +1.37173600E-02  -4.06045100E-02
   -1.15901540E-01  +2.77315800E-02  -1.92055700E-02  +6.60904000E-03  -5.99354000E-03
   +3.57428000E-03  -2.21653000E-03  -1.65895800E-02  -7.80854000E-03  -3.76201700E-02
   -5.28646400E-02  +2.39167000E-03  -1.60212660E-01  +2.68945200E-02  +1.97389040E-01
   +5.31569960E-01  -1.07117000E-03  +7.33488000E-03  +6.17817000E-03  -1.12094690E-01
   +4.99750900E-02  -2.79175000E-03  -5.73062000E-03  +1.08953800E-02  -3.91753000E-03
   +2.17526000E-03  +9.15820000E-04  -1.59650000E-04  -1.57550000E-03  -1.13884000E-03
   +1.36020000E-04  +2.33732000E-03  -1.04903000E-03  -1.99585000E-03  +4.23918890E-01
   +1.57672600E-02  -7.41149000E-03  -2.18948000E-03  +6.43982000E-02  -1.18941590E-01
   -3.48316000E-03  +1.11800600E-02  +1.12676000E-03  -1.72525000E-03  +4.21505000E-03
   +9.20440000E-04  +4.93980000E-04  -1.35768000E-03  -1.57565000E-03  -3.53780000E-04
   +8.01340000E-04  -4.25820000E-04  -2.99000000E-03  -1.41753300E-02  +4.91485250E-01
   +2.06892100E-02  -1.45885100E-02  +4.41236000E-03  +2.66330000E-03  -6.68397000E-03
   -8.99362900E-02  -2.16869000E-02  +1.42899300E-02  +8.90255000E-03  -3.03834000E-03
   +3.90410000E-04  -5.97750000E-03  -6.39800000E-05  -6.64020000E-04  -8.89870000E-04
   -4.51990000E-04  -3.22561000E-03  -4.79135000E-03  +6.88871000E-03  -3.30090000E-04
   +5.00902270E-01  -4.17311000E-03  +2.55118000E-03  -1.87122000E-03  -1.73360000E-04
   +1.90075600E-02  +2.38154600E-02  -1.05532000E-03  +1.51430000E-03  -8.39960000E-04
   +1.71160000E-04  +1.28290000E-04  +1.05533000E-03  +3.78450000E-04  -1.45740000E-04
   -2.79640000E-04  +6.62600000E-05  +7.19440000E-04  +1.52167000E-03  -7.42885400E-02
   -2.58280000E-03  -4.99052000E-03  +5.92107560E-01  +2.92543000E-03  -8.99200000E-04
   +1.22615000E-03  +4.17250000E-03  -1.73156200E-02  -1.85962600E-02  +2.07600000E-05
   -8.64440000E-04  -2.33180000E-04  -2.84560000E-04  +7.48000000E-05  -6.90720000E-04
   -9.00300000E-05  +1.29080000E-04  -4.12400000E-05  -1.10340000E-04  -2.82950000E-04
   -1.01394000E-03  -5.48600000E-05  -1.13847750E-01  -4.76386800E-02  -1.36709000E-03
   +5.32854810E-01  -2.20770000E-03  +2.75770000E-04  +6.48170000E-04  +6.56375000E-03
   -5.05792000E-03  -3.16830000E-04  -5.97670000E-04  +1.76300000E-03  +6.25190000E-04
   +4.52200000E-04  -2.77530000E-04  -1.08265000E-03  -9.39600000E-05  -3.99560000E-04
   +2.48320000E-04  +1.41020000E-04  +9.58500000E-05  +4.40890000E-04  -2.89655000E-03
   -4.56349300E-02  -1.41795260E-01  -5.00134000E-03  -6.65818300E-02  +5.32224600E-01
   -4.95379000E-03  -2.95200000E-04  -4.84939000E-03  +7.57570000E-04  -2.71177000E-03
   -1.48102000E-03  +2.97030000E-04  +6.47010000E-04  +5.83394000E-03  -1.55738000E-02
   +2.49679800E-02  +7.06190000E-04  -1.33591420E-01  +8.56410800E-02  -1.48818000E-03
   -2.25968100E-02  +3.57476500E-02  -2.25955000E-03  +3.02650000E-04  -3.27000000E-05
   -1.95200000E-05  -2.61860000E-04  +1.00470000E-04  +2.38900000E-05  +6.39558860E-01
   +1.25590000E-03  +1.03127000E-03  +2.59631000E-03  -3.50627000E-03  +1.40620000E-04
   -1.90191000E-03  +2.89958000E-03  -1.91620000E-03  -3.41882000E-03  +1.68013600E-02
   -2.02608200E-02  -2.85997000E-03  +3.10966700E-02  -1.62693790E-01  +1.61033000E-03
   +1.41252600E-02  -1.06124300E-02  +1.29540000E-03  +8.83400000E-05  +5.07490000E-04
   +1.79920000E-04  +1.76120000E-04  -8.28600000E-05  -3.40000000E-06  +3.42413200E-02
   +3.43096590E-01  -3.38180000E-03  +7.67550000E-04  -9.77340000E-04  -7.64480000E-04
   -2.71460000E-04  -4.61780000E-03  +2.67501000E-03  -1.97384000E-03  -2.81211000E-03
   +2.11064000E-02  -2.45049400E-02  +3.85633000E-03  +1.06595000E-03  -4.62028000E-03
   -7.25035300E-02  -1.79169200E-02  +1.87220500E-02  +4.10694000E-03  -8.90800000E-05
   -6.37000000E-05  +3.04030000E-04  +6.83000000E-06  +4.29800000E-05  -8.42800000E-05
   -1.91035900E-02  -9.05401000E-03  +5.13836300E-02  -7.36990000E-04  +1.31517000E-03
   +2.24546000E-03  -3.39853600E-02  -7.41233000E-03  +2.16334000E-03  -6.67610000E-04
   +2.04263000E-03  -2.06384000E-03  +1.98132000E-03  -2.54450000E-04  +3.13710000E-04
   -3.72550000E-04  -7.43920000E-04  -4.52450000E-04  +5.26550000E-04  -7.94300000E-04
   -8.47250000E-04  -1.24133550E-01  -5.14683900E-02  +1.17084000E-03  -4.62677000E-03
   -7.09153000E-03  -6.47223000E-03  -1.30410000E-04  +1.70240000E-04  -6.96400000E-05
   +4.78792200E-01  +3.21684000E-03  -1.97076000E-03  -2.13388000E-03  -3.88144000E-03
   +1.56472900E-02  +1.34170000E-04  +1.52999000E-03  -3.00865000E-03  +1.38759000E-03
   -1.36078000E-03  +1.43150000E-04  +6.55530000E-04  +4.28420000E-04  +1.71256000E-03
   +2.17500000E-04  -1.10821000E-03  +4.29310000E-04  -3.40710000E-04  -3.08920900E-02
   -1.00089010E-01  +7.47702000E-03  -1.91252800E-02  -1.51981300E-02  -4.00470000E-03
   +1.87590000E-04  -5.11570000E-04  +7.08000000E-05  +1.73868990E-01  +3.61275010E-01
   +1.63579000E-03  -5.18680000E-04  -7.41730000E-04  +2.51035000E-03  -4.69820000E-04
   -1.03117000E-03  -7.00060000E-04  +1.06840000E-03  -8.54830000E-04  +1.04251000E-03
   -2.17080000E-04  -1.98220000E-04  -3.61870000E-04  -5.24840000E-04  -3.74870000E-04
   -2.27910000E-04  +4.10080000E-04  +9.52500000E-05  -4.28354000E-03  +5.80309000E-03
   -8.41289800E-02  -2.37681600E-02  -1.57021900E-02  +3.73200000E-04  +9.19200000E-05
   +7.04200000E-05  +1.25560000E-04  +1.08053280E-01  -1.21598630E-01  +6.10413210E-01
   -8.63040000E-04  -2.05590000E-04  +1.65120000E-04  -1.27504000E-03  -2.41891000E-03
   -2.96800000E-04  +8.62420000E-04  +8.25400000E-05  +3.64900000E-05  -5.39410000E-04
   +1.75210000E-04  +3.64100000E-05  +8.27900000E-05  +5.33870000E-04  +2.38690000E-04
   -1.33740000E-04  -3.54200000E-05  -2.45050000E-04  -1.73600800E-02  -5.68842000E-03
   -1.56245000E-02  -1.17021000E-03  +3.18220000E-04  +8.90700000E-04  +3.80900000E-05
   -9.19500000E-05  -5.14600000E-05  -1.84701610E-01  -5.10955300E-02  -8.19786500E-02
   +5.11925390E-01  +5.18280000E-04  -1.68640000E-04  -5.38030000E-04  -1.16145000E-03
   -2.68827000E-03  -2.99930000E-04  +4.98080000E-04  +1.00740000E-04  +2.99020000E-04
   -4.18480000E-04  +1.70800000E-04  +1.52400000E-05  -7.44700000E-05  +3.74140000E-04
   +7.06300000E-05  -2.01130000E-04  +2.04350000E-04  +1.39260000E-04  -1.33942400E-02
   -4.07370000E-04  -1.43506500E-02  -2.75932000E-03  -1.53138000E-03  +2.24970000E-04
   +1.26540000E-04  -1.10870000E-04  +2.82400000E-05  -2.68846800E-02  -9.58720800E-02
   +1.95208200E-02  +2.35052650E-01  +4.01931820E-01  +1.34384000E-03  -3.51260000E-04
   -5.87220000E-04  -3.07048000E-03  +8.58940000E-04  -5.51100000E-04  +1.10099000E-03
   -1.08053000E-03  +6.82420000E-04  -1.03884000E-03  +2.84060000E-04  +2.78910000E-04
   +4.91000000E-06  +8.62550000E-04  +3.94540000E-04  -3.79170000E-04  +2.41100000E-04
   -8.63900000E-05  +3.48300000E-05  -2.18312000E-03  +6.71947000E-03  +1.61804000E-03
   +1.01319000E-03  -2.39580000E-04  +2.18980000E-04  -3.08890000E-04  +2.80300000E-05
   -1.31635780E-01  -2.03889600E-02  -2.39028630E-01  +9.47636800E-02  -1.72958800E-01
   +6.60188320E-01  +2.04410000E-04  +2.15810000E-04  -1.72930000E-04  +1.87691000E-03
   -3.83400000E-05  -7.86300000E-05  -9.93710000E-04  +4.77120000E-04  -2.99360000E-04
   +7.84540000E-04  -2.49460000E-04  -1.88480000E-04  -1.06670000E-04  -6.31230000E-04
   -3.33330000E-04  +5.37100000E-05  +7.38700000E-05  +1.99470000E-04  +2.13374000E-03
   -1.93217000E-03  -4.06662000E-03  -1.87274000E-03  -7.40290000E-04  +2.36570000E-04
   -7.03600000E-05  +1.93790000E-04  +6.33000000E-05  -3.47466200E-02  -7.84333000E-03
   -5.02133100E-02  -2.41717850E-01  -1.47953740E-01  +2.30185300E-02  +5.39100680E-01
   -1.75630000E-04  +6.32800000E-04  +1.71800000E-05  +1.89852000E-03  -1.59549000E-03
   -1.47480000E-04  -1.21561000E-03  +9.95740000E-04  -4.76140000E-04  +1.05484000E-03
   -2.44610000E-04  -2.79220000E-04  -2.44630000E-04  -1.07373000E-03  -3.61750000E-04
   +3.60540000E-04  -6.96000000E-06  +2.50610000E-04  -2.80871000E-03  +3.52193000E-03
   +1.73233000E-03  +2.82420000E-04  +1.96500000E-04  +1.03940000E-04  -1.03980000E-04
   +3.19960000E-04  +5.24300000E-05  -2.76715900E-02  +1.22787500E-02  -5.32534500E-02
   -1.23246410E-01  -1.74175400E-01  +4.65555000E-02  +2.46967670E-01  +3.80521370E-01
   -8.61300000E-05  -2.47860000E-04  -1.70770000E-04  -1.15138000E-03  -5.01090000E-04
   -5.31810000E-04  +5.78540000E-04  -4.05570000E-04  +2.84600000E-04  -3.76920000E-04
   +9.38100000E-05  +1.57520000E-04  -7.31000000E-05  +5.22880000E-04  -4.17000000E-05
   -1.41830000E-04  +5.27600000E-05  +5.71200000E-05  -3.88619000E-03  +2.08691000E-03
   -1.97176000E-03  +3.83930000E-04  +1.74200000E-04  -3.43150000E-04  +1.56850000E-04
   -2.19380000E-04  +4.21800000E-05  -9.53384000E-03  -2.11274600E-02  +3.80917300E-02
   -3.05017600E-02  +4.83453000E-03  -1.21222830E-01  +1.41397310E-01  -1.42322640E-01
   +6.47997840E-01  +7.35340000E-04  -4.07100000E-04  -5.72620000E-04  -2.20072000E-03
   +7.41160000E-04  -1.47480000E-04  +8.00740000E-04  -5.35780000E-04  +2.51230000E-04
   -5.79330000E-04  +1.09330000E-04  +1.84790000E-04  -5.52740000E-04  +8.97160000E-04
   +2.60100000E-05  -3.85640000E-04  +2.32430000E-04  +1.35070000E-04  -1.21805000E-03
   -1.95550000E-04  -1.62930000E-04  +3.56930000E-04  +7.55000000E-05  -4.24650000E-04
   +5.15980000E-04  -6.27900000E-04  +3.12000000E-05  -4.35876000E-03  +1.12776900E-02
   -2.18963200E-02  +1.32109600E-02  -7.54870000E-03  +3.41128000E-02  -1.16263580E-01
   -5.16545600E-02  +3.32680200E-02  +5.46749790E-01  +3.65810000E-04  -4.66990000E-04
   -3.20340000E-04  -2.53557000E-03  +1.08888000E-03  -2.45880000E-04  +1.08826000E-03
   -9.04810000E-04  +4.67250000E-04  -9.09910000E-04  +1.90590000E-04  +3.01790000E-04
   -2.12280000E-04  +1.11608000E-03  +1.89140000E-04  -3.22580000E-04  +8.89200000E-05
   +1.40700000E-05  +1.43120000E-04  -3.29270000E-04  +3.97780000E-04  +6.66430000E-04
   +1.52060000E-04  -2.21850000E-04  +3.67580000E-04  -5.58850000E-04  +4.75000000E-06
   +1.14975200E-02  -5.72201000E-03  +1.72992300E-02  -2.93181900E-02  -2.62850300E-02
   +1.05666100E-02  -2.14182300E-02  -1.43933560E-01  +1.22144590E-01  +2.32559570E-01
   +4.10047100E-01  +1.38370000E-04  +2.63580000E-04  -1.07820000E-04  +1.69311000E-03
   -3.56660000E-04  +9.26300000E-05  -1.26421000E-03  +7.66710000E-04  -4.55400000E-04
   +9.28170000E-04  -3.17500000E-04  -3.11530000E-04  -2.38630000E-04  -8.15540000E-04
   -2.33790000E-04  +1.41170000E-04  -1.92800000E-05  +1.55190000E-04  -1.47921000E-03
   -4.18840000E-04  -1.70876000E-03  -8.73780000E-04  -3.51870000E-04  +3.42510000E-04
   -2.96500000E-05  +1.76390000E-04  +2.06400000E-05  -2.09108400E-02  +1.78903700E-02
   -7.65122000E-02  +7.84305200E-02  +4.62871300E-02  +3.26523300E-02  -2.94455300E-02
   +7.48492200E-02  -2.72440620E-01  +1.19518900E-01  -1.42812470E-01  +6.53794100E-01
   -8.74200000E-05  +4.08000000E-06  +2.10300000E-04  +2.44430000E-04  +2.14730000E-04
   -2.70300000E-05  +3.09490000E-04  -1.28780000E-04  +8.36500000E-05  -2.47500000E-04
   +1.54960000E-04  +8.57200000E-05  +3.26680000E-04  +9.52500000E-05  +9.56500000E-05
   -1.74100000E-05  +2.03800000E-05  -1.51040000E-04  +5.23835000E-03  -8.81040000E-04
   -6.92910000E-04  +2.00800000E-04  +7.81300000E-05  +7.43700000E-05  -1.85860000E-04
   +1.50580000E-04  -2.91800000E-05  +9.81329000E-03  -3.10365300E-02  +6.77034900E-02
   -4.92165600E-02  -2.35368900E-02  -2.57173500E-02  +3.97230700E-02  +4.01838200E-02
   -3.46872900E-02  -1.72920630E-01  -4.18366700E-02  -7.29309600E-02  +5.27591920E-01
   -2.46480000E-04  +2.26300000E-04  +3.79920000E-04  +6.82190000E-04  -1.22197000E-03
   +2.22760000E-04  +7.06920000E-04  +1.12120000E-04  -1.04960000E-04  -5.10000000E-04
   +2.23100000E-04  +4.82300000E-05  +9.64300000E-05  +7.51100000E-05  +2.83520000E-04
   +7.12600000E-05  -3.86000000E-06  -7.66100000E-05  -1.48082000E-03  +2.87348000E-03
   +3.42484000E-03  +5.22070000E-04  +4.29300000E-04  +1.42630000E-04  -4.40900000E-05
   +6.14900000E-05  -7.61700000E-05  -1.15884100E-02  -2.01699500E-02  +4.14811500E-02
   -2.40973500E-02  -1.52015800E-02  -1.37321100E-02  +2.38998300E-02  +2.71180700E-02
   -1.60983000E-03  -1.33463300E-02  -9.73361100E-02  +3.28602500E-02  +2.56273390E-01
   +4.14136530E-01  -3.84380000E-04  +1.76310000E-04  +2.56280000E-04  -5.61700000E-05
   +6.98400000E-05  -2.83750000E-04  -8.20500000E-05  -1.67170000E-04  -2.42630000E-04
   +1.06360000E-04  +7.43400000E-05  +2.00120000E-04  +2.46180000E-04  -1.86050000E-04
   -1.38430000E-04  +1.75540000E-04  -8.46600000E-05  +5.14600000E-05  -9.67770000E-04
   +3.13958000E-03  -4.16715000E-03  -3.28800000E-04  -5.50700000E-04  -2.04110000E-04
   -1.93200000E-04  +2.23490000E-04  +1.91500000E-05  +2.77706900E-02  +1.09421900E-02
   +2.87691300E-02  -2.30549200E-02  -1.19192000E-02  -1.51368100E-02  -7.68000000E-06
   +2.47542200E-02  -4.34908400E-02  -1.32335220E-01  -1.25051500E-02  -2.54458900E-01
   +9.65728600E-02  -1.81990060E-01  +6.57638880E-01  -2.28300000E-04  +2.08950000E-04
   -8.79900000E-05  +4.55210000E-04  -2.82283000E-03  +1.94611000E-03  -2.92608000E-03
   +5.70390000E-04  -5.35000000E-06  +9.51250000E-04  -6.05300000E-04  -3.25210000E-04
   -2.56300000E-04  -5.49170000E-04  -2.04320000E-04  +1.68560000E-04  -8.44600000E-05
   +4.66900000E-05  -6.08362000E-03  -1.38891900E-02  +2.13305200E-02  +7.14400000E-05
   -1.77110000E-04  +1.23358000E-03  +9.82000000E-06  +8.42700000E-05  +1.38200000E-05
   -1.13566540E-01  -2.75028400E-02  -1.24720200E-02  +3.90229000E-02  +2.40928400E-02
   -8.04890000E-04  -2.32384900E-02  -2.36048300E-02  +1.79831900E-02  -3.90969400E-02
   -6.63436000E-03  -5.16874300E-02  -2.50140800E-01  -1.56228400E-01  +2.48205700E-02
   +5.52430880E-01  +7.83290000E-04  -3.14200000E-05  -9.22490000E-04  -6.02580000E-04
   -1.47988000E-03  +2.28580000E-04  +2.39440000E-04  -4.05000000E-06  +8.81700000E-05
   -7.50400000E-05  +9.65600000E-05  +2.59800000E-05  -3.00040000E-04  +1.88760000E-04
   -1.01390000E-04  -1.85620000E-04  +2.90980000E-04  +1.73280000E-04  -7.70477000E-03
   -1.10380700E-02  +1.43119700E-02  -1.22787000E-03  -3.76230000E-04  +4.91540000E-04
   +2.08660000E-04  -1.39670000E-04  +7.11800000E-05  -5.16068800E-02  -1.46249790E-01
   +7.77422600E-02  +4.30499300E-02  +2.75002700E-02  +2.87037700E-02  -2.65117200E-02
   -3.40792600E-02  +2.29463500E-02  -2.77216200E-02  +1.02197800E-02  -6.21659400E-02
   -1.29630290E-01  -1.84071050E-01  +5.05101200E-02  +2.36944650E-01  +3.90540990E-01
   -3.17490000E-04  +1.01400000E-04  +2.84120000E-04  +1.97199000E-03  -1.36640000E-04
   +1.54291000E-03  +2.34650000E-04  +1.34078000E-03  -7.49200000E-05  +3.03300000E-05
   -8.44500000E-05  -5.12410000E-04  -4.26700000E-05  -2.89420000E-04  +4.29820000E-04
   +6.68000000E-05  -1.00860000E-04  -2.20510000E-04  +6.56852000E-03  +2.72529000E-03
   +4.06878000E-03  -5.64140000E-04  -2.81210000E-04  -1.95800000E-05  -5.22400000E-05
   +4.60900000E-05  -1.87310000E-04  +3.67601800E-02  +1.15309530E-01  -2.49182780E-01
   -4.08189600E-02  -1.09153000E-03  -5.38106300E-02  +2.26732300E-02  +2.61676600E-02
   -2.24342700E-02  -7.60691000E-03  -2.78402400E-02  +4.81832900E-02  -2.87192300E-02
   +9.51526000E-03  -1.25009610E-01  +1.43120560E-01  -1.32463070E-01  +6.39303590E-01
   -8.26580000E-04  +6.85270000E-04  +5.95060000E-04  +3.03713000E-03  -1.56735000E-03
   +2.43080000E-04  -1.28722000E-03  +9.58410000E-04  -5.17370000E-04  +9.86270000E-04
   -1.83340000E-04  -2.86110000E-04  +4.46400000E-04  -1.30647000E-03  -1.78840000E-04
   +5.21000000E-04  -2.39870000E-04  -4.67000000E-05  +2.50020000E-04  +5.59110000E-04
   -2.60460000E-04  -8.02260000E-04  -2.04750000E-04  +5.87300000E-04  -5.57000000E-04
   +7.50710000E-04  -2.15000000E-05  -3.24971000E-03  -2.96529000E-03  +3.48315000E-03
   +3.01968000E-03  -2.20484000E-03  -1.89378000E-03  -1.30208100E-02  -2.00104800E-02
   +4.76829000E-03  -2.11548030E-01  -1.38276870E-01  +2.54315800E-02  -3.82656700E-02
   -3.16121700E-02  -6.79499000E-03  +5.26737000E-03  +2.99055000E-03  -5.20938000E-03
   +4.23979080E-01  -6.12490000E-04  +5.86290000E-04  +4.74690000E-04  +2.36257000E-03
   -1.28889000E-03  +2.49140000E-04  -1.11214000E-03  +8.22110000E-04  -4.22780000E-04
   +8.30540000E-04  -1.65750000E-04  -2.51090000E-04  +3.16270000E-04  -1.11975000E-03
   -1.56870000E-04  +3.88520000E-04  -1.69900000E-04  -6.10200000E-05  +7.34130000E-04
   -1.16560000E-04  -6.57630000E-04  -7.53360000E-04  -1.97880000E-04  +4.70600000E-04
   -4.29810000E-04  +6.34970000E-04  -1.37700000E-05  -2.78834000E-03  -2.71947000E-03
   -9.31820000E-04  +8.75160000E-04  +6.21684000E-03  +5.50080000E-03  -3.42410500E-02
   -1.95772000E-02  +8.34758000E-03  -1.20369800E-01  -1.59071730E-01  +4.83315200E-02
   -1.75572300E-02  -3.21261000E-03  -5.73477000E-03  -6.17100000E-05  +3.92364000E-03
   +2.31200000E-03  +1.96187240E-01  +2.00623000E-01  -9.99000000E-06  -5.01100000E-05
   -3.10700000E-05  -3.09110000E-04  +2.05430000E-04  -1.09290000E-04  +1.27460000E-04
   -1.72600000E-04  +7.74800000E-05  -8.43800000E-05  +3.00100000E-05  +6.42700000E-05
   +3.42000000E-06  +1.16580000E-04  -4.00100000E-05  -3.10000000E-05  +1.18600000E-05
   +1.34300000E-05  +4.47820000E-04  -1.74750000E-04  +2.49210000E-04  +1.21310000E-04
   +2.85500000E-05  -9.29800000E-05  +2.33400000E-05  -3.63900000E-05  +2.55400000E-05
   +2.30154000E-03  -1.84564000E-03  +6.23451000E-03  -8.74679000E-03  -9.73600000E-05
   -6.47150000E-03  +3.41283300E-02  +3.05348500E-02  +7.20480000E-04  -1.36751400E-02
   +1.86098900E-02  -1.06573260E-01  -3.61294100E-02  -2.79891300E-02  +8.66353000E-03
   +6.69680000E-04  +6.98891000E-03  -8.32736000E-03  +2.25056700E-01  -4.93088700E-02
   +5.00239100E-01  -7.24700000E-05  +5.04710000E-04  -2.98060000E-04  -4.82118000E-03
   +1.75522900E-02  -2.53131700E-02  -3.85008000E-03  +2.57641000E-03  +2.80101000E-03
   -1.03324000E-03  -1.08300000E-05  -1.41110000E-03  +9.07200000E-05  -4.18830000E-04
   -9.11800000E-05  +4.48840000E-04  -3.03760000E-04  -1.61650000E-04  -7.25598200E-02
   +4.84182000E-03  -3.73229000E-03  +4.45940000E-04  +5.02900000E-05  -6.71700000E-05
   -9.87600000E-05  +1.54560000E-04  +7.81000000E-05  -1.02480000E-04  -1.78597700E-02
   +2.33728300E-02  -1.62501000E-03  -1.41281000E-03  -1.70490000E-04  +2.96760000E-04
   -1.72230000E-04  +8.74110000E-04  +3.92510000E-04  -4.66100000E-05  +1.65110000E-04
   -3.69060000E-04  -4.26860000E-04  +1.23087000E-03  -3.93792000E-03  -2.80880000E-03
   -1.57071000E-03  -4.55850000E-04  -2.84590000E-04  +1.69000000E-05  +5.92772710E-01
   +5.43410000E-04  -1.00811000E-03  -3.25840000E-04  +4.95759000E-03  -1.38492800E-02
   +1.74277300E-02  +1.73924000E-03  -1.48216000E-03  -1.30332000E-03  +2.08070000E-04
   +1.96240000E-04  +8.08270000E-04  +2.37510000E-04  +5.95770000E-04  +2.25300000E-05
   -1.98000000E-04  +3.23990000E-04  +4.69310000E-04  +2.73756000E-03  -1.10569510E-01
   +4.66762700E-02  -3.20100000E-04  +1.05892000E-02  -1.39882100E-02  +1.17100000E-05
   -2.25520000E-04  -1.89200000E-05  -3.84939000E-03  -1.60315000E-02  +1.75280800E-02
   -2.13040000E-04  -1.12157000E-03  +9.58000000E-06  +4.62480000E-04  -2.48350000E-04
   +8.26990000E-04  -7.17900000E-05  +9.63200000E-05  -1.02570000E-04  +2.77800000E-05
   +3.39500000E-05  +1.03294000E-03  -2.42136000E-03  -1.43242000E-03  -1.03178000E-03
   -8.09200000E-05  -5.18300000E-05  +4.78900000E-05  +6.60446000E-03  +5.42584170E-01
   +1.39369000E-03  -5.99340000E-04  +4.12380000E-04  -9.63009000E-03  +6.55697000E-03
   +3.23650000E-04  +2.86580000E-03  -4.53430000E-04  -3.67700000E-05  -4.55370000E-04
   +2.14670000E-04  +6.71640000E-04  +2.98540000E-04  +6.17130000E-04  +9.30220000E-04
   -4.21830000E-04  -1.17400000E-05  -8.87530000E-04  +1.32590000E-04  +4.32602600E-02
   -1.43390240E-01  +3.57100000E-04  +1.24204400E-02  -3.77559900E-02  -4.25500000E-05
   -1.13050000E-04  -9.34300000E-05  +3.62599000E-03  +4.62898000E-03  -2.36050000E-03
   -3.93010000E-04  -1.26209000E-03  +4.54370000E-04  -3.45330000E-04  -3.59780000E-04
   -2.12570000E-04  +2.13670000E-04  +3.50730000E-04  -6.33400000E-05  -2.24790000E-04
   -7.44900000E-05  +6.30500000E-05  -1.27103000E-03  -1.07140000E-04  +3.36480000E-04
   -4.10120000E-04  -3.06960000E-04  +4.12000000E-06  -2.98299000E-03  +6.53411500E-02
   +5.23871280E-01  -5.62750000E-04  -4.78390000E-04  -2.20629000E-03  +7.45800000E-05
   -3.97330000E-03  +2.27629000E-03  -4.01259000E-03  +1.17311000E-03  +1.95034000E-03
   -2.85939400E-02  -2.22537600E-02  +2.15546500E-02  -1.70112380E-01  -8.90720000E-02
   +2.04387500E-02  -3.33259300E-02  -2.96242600E-02  -1.26468000E-03  +2.61930000E-04
   -3.91470000E-04  -2.11550000E-04  -2.62680000E-04  +1.64980000E-04  -2.18800000E-05
   +2.46906200E-02  +8.61370000E-03  -3.89394000E-03  -6.83100000E-05  +5.16350000E-04
   -5.70900000E-05  +1.32570000E-04  +1.68370000E-04  +3.53930000E-04  -2.11740000E-04
   -3.11820000E-04  +2.75830000E-04  +7.65610000E-04  +6.31960000E-04  -1.92510000E-04
   -1.81650000E-04  -1.77000000E-05  -2.35630000E-04  -7.80700000E-05  +2.06860000E-04
   -6.35300000E-05  -8.91050000E-04  -6.82820000E-04  +5.38700000E-05  -2.68900000E-04
   +3.92370000E-04  -2.77700000E-05  +2.48461180E-01  -1.64983000E-03  +2.21062000E-03
   -2.67378000E-03  -1.35035900E-02  -2.03937000E-02  +7.34041000E-03  -2.05750000E-03
   +6.76952000E-03  +1.86687000E-03  -2.13796800E-02  -1.19432300E-02  +1.86662900E-02
   -5.75749700E-02  -1.68482110E-01  +1.91646400E-02  -2.51303300E-02  -1.26231300E-02
   -7.27260000E-03  +2.00742000E-03  +1.72618000E-03  +5.59200000E-05  -4.72800000E-04
   -4.03000000E-06  +1.25710000E-04  -2.64828100E-02  -7.60166200E-02  +1.23546500E-02
   +5.29990000E-04  -9.22860000E-04  +2.62000000E-06  +6.75700000E-05  +1.09340000E-04
   -2.40080000E-04  +1.19590000E-04  +3.84480000E-04  -1.43940000E-04  -3.13110000E-04
   -3.85140000E-04  +1.43540000E-04  +8.14500000E-05  +2.31550000E-04  +7.66500000E-05
   +1.41410000E-04  +5.45700000E-05  +2.95290000E-04  +4.64640000E-04  +4.21690000E-04
   -4.44800000E-05  +1.46670000E-04  -6.50900000E-04  -5.01920000E-04  +1.16393630E-01
   +2.76912280E-01  -1.45566700E-02  +6.45989000E-03  +5.18811000E-03  -2.16941000E-03
   +5.60871000E-03  -3.53196300E-02  +3.10299300E-02  -1.61983900E-02  +1.23628600E-02
   +5.58761000E-03  +2.09297300E-02  +4.60900000E-04  +2.65749200E-02  +3.71890100E-02
   -5.15894100E-02  -6.47950000E-03  -1.28668100E-02  +1.60258700E-02  -2.05940000E-04
   +9.26150000E-04  +2.32910000E-04  +2.81190000E-04  +5.56000000E-06  +1.20870000E-04
   -1.31652000E-03  +5.32329000E-03  +1.18954500E-02  +6.82530000E-04  -4.90200000E-04
   +6.09380000E-04  -3.53390000E-04  -2.06060000E-04  -6.13120000E-04  +4.97990000E-04
   +5.74900000E-04  -1.41220000E-04  -2.38500000E-04  -4.66540000E-04  +5.05970000E-04
   -1.51610000E-04  -3.65580000E-04  +8.91100000E-05  +4.57540000E-04  +1.79400000E-05
   -2.17650000E-04  +4.77210000E-04  +4.09650000E-04  -8.37000000E-06  -1.35700000E-05
   -1.29750000E-04  -7.63560000E-04  -3.74937900E-02  -4.03940200E-02  +3.99096100E-02
   +8.20700000E-05  -4.34300000E-05  -7.86600000E-05  -3.98790000E-04  +1.19520000E-04
   -6.14200000E-05  +2.19840000E-04  -1.34330000E-04  +6.98300000E-05  -1.60100000E-04
   +4.15100000E-05  +5.41700000E-05  -9.34100000E-05  +1.69380000E-04  +1.29800000E-05
   -5.30600000E-05  +3.84700000E-05  +2.44800000E-05  -4.20700000E-05  -2.38000000E-05
   +1.12250000E-04  +1.07700000E-04  +1.45600000E-05  -5.45700000E-05  +9.59600000E-05
   -1.01380000E-04  +8.92000000E-06  +5.94800000E-04  +5.66200000E-05  +6.08860000E-04
   -9.71540000E-04  -4.66100000E-05  -5.00360000E-04  +3.09072000E-03  +3.17301000E-03
   -3.40100000E-05  -2.61334500E-02  -2.24025000E-03  -3.33695100E-02  -2.45692000E-03
   -4.86783000E-03  +2.39288000E-03  +3.43460000E-04  -7.69300000E-05  -1.93211000E-03
   -1.66233420E-01  -2.66031100E-02  -2.07557120E-01  +6.20000000E-05  +3.24500000E-05
   +3.22300000E-05  +1.55490000E-04  -3.48800000E-05  -7.41800000E-05  +1.91881160E-01
   +6.92500000E-05  -8.44500000E-05  -7.27600000E-05  -2.62720000E-04  +1.67760000E-04
   +7.51000000E-06  +1.31420000E-04  -8.64300000E-05  +4.87600000E-05  -9.40200000E-05
   +1.76300000E-05  +2.72900000E-05  -4.60600000E-05  +1.58000000E-04  +1.60100000E-05
   -4.45900000E-05  +2.24100000E-05  +2.01100000E-05  +8.94900000E-05  -3.32700000E-05
   +8.11200000E-05  +7.86100000E-05  +2.66600000E-05  -1.52500000E-05  +5.87400000E-05
   -9.92700000E-05  -3.59000000E-06  +2.61610000E-04  -8.49700000E-05  +5.93130000E-04
   -1.30720000E-04  -6.78010000E-04  -3.02890000E-04  +7.47750000E-04  +4.93290000E-04
   -1.95602000E-03  -1.93795800E-02  -4.54595000E-03  -2.75550500E-02  -4.37673000E-03
   -1.86284000E-03  +1.99593000E-03  -6.49090000E-04  +1.59436000E-03  -7.73560000E-04
   -8.03089000E-03  -2.22587500E-02  +2.54906500E-02  +6.19000000E-06  +1.68000000E-05
   +3.29000000E-06  +8.92100000E-05  -7.04500000E-05  -4.62500000E-05  +3.11935300E-02
   +2.79979800E-02  +7.76000000E-05  -6.93400000E-05  -3.93000000E-05  -2.15050000E-04
   +1.20740000E-04  -7.69000000E-06  +5.52500000E-05  -6.32800000E-05  +2.62000000E-05
   -5.37400000E-05  +2.67000000E-06  +1.46300000E-05  -8.08000000E-06  +8.42200000E-05
   +2.42400000E-05  -4.76200000E-05  +1.65900000E-05  -7.63000000E-06  -6.74200000E-05
   -3.47900000E-05  +4.00000000E-06  +6.15600000E-05  +3.55800000E-05  -5.93300000E-05
   +2.44600000E-05  -4.24700000E-05  -7.75000000E-06  +2.75840000E-04  +2.83640000E-04
   -7.05700000E-05  -2.78100000E-04  -1.11490000E-04  -9.47440000E-04  +5.14719000E-03
   +1.98468000E-03  +3.01281000E-03  +3.70656000E-03  +5.79600000E-04  +2.14130000E-03
   +1.32466000E-03  +1.19168000E-03  +1.94393000E-03  -6.47640000E-04  +1.94270000E-04
   +2.06060000E-04  -2.47681130E-01  -4.99641000E-03  -3.97883820E-01  +2.00000000E-05
   -7.50000000E-06  +4.52100000E-05  +4.02600000E-05  -3.89100000E-05  -3.54500000E-05
   +2.38668850E-01  +9.86290000E-04  +3.92339250E-01  -1.37510000E-04  +1.10230000E-04
   +3.21600000E-05  +3.02590000E-04  -3.83870000E-04  -5.86400000E-05  -8.68400000E-05
   +9.57500000E-05  -1.81900000E-05  +7.54800000E-05  -6.80000000E-07  -1.85600000E-05
   +7.32000000E-06  -1.20750000E-04  -4.52100000E-05  +6.22000000E-05  -1.87300000E-05
   +2.29200000E-05  -1.58490000E-04  +4.73200000E-05  -1.04439000E-03  -3.69580000E-04
   -1.58920000E-04  +8.44000000E-05  -3.30800000E-05  +6.55200000E-05  +1.40600000E-05
   -4.71810000E-04  -5.54386000E-03  +2.49440000E-04  -1.11711300E-02  -3.03310000E-04
   -2.06546500E-02  -1.54199970E-01  -2.62379500E-02  -1.37799180E-01  +3.99064000E-03
   -2.45342000E-03  +4.72814000E-03  +2.63908000E-03  -2.51664000E-03  +4.37560000E-04
   -5.36800000E-04  -9.85700000E-05  +9.28210000E-04  +1.25644000E-03  +3.13181000E-03
   +1.80344000E-03  -3.04700000E-05  +1.15980000E-04  -5.51800000E-05  -5.95400000E-05
   +6.51000000E-05  +5.42100000E-05  +6.24500000E-05  +1.02690000E-04  -1.01014000E-03
   +1.59719080E-01  -2.98200000E-05  +2.15400000E-05  +3.31900000E-05  +4.02490000E-04
   -3.00140000E-04  +3.91200000E-05  -1.50650000E-04  +1.57470000E-04  -9.18900000E-05
   +1.32840000E-04  -3.74600000E-05  -5.20300000E-05  +2.88000000E-06  -1.08090000E-04
   -2.26600000E-05  +1.94100000E-05  -4.82000000E-06  +2.61000000E-06  -7.66470000E-04
   +3.13800000E-04  -5.63090000E-04  -9.20400000E-05  +3.89700000E-05  +7.28900000E-05
   -2.87300000E-05  +4.05600000E-05  -4.89000000E-06  -5.57264000E-03  +1.79284000E-03
   +2.41253000E-03  -1.17211000E-02  +1.37508000E-03  -1.67911500E-02  -2.60018900E-02
   -4.74066700E-02  -1.14780700E-02  +9.47793000E-03  +5.29857000E-03  +1.28635900E-02
   -2.70239000E-03  +1.49571000E-03  +4.29506000E-03  -1.81120000E-04  -1.16636000E-03
   +1.69330000E-04  +3.29039000E-03  -7.70780000E-04  -1.39766000E-03  +1.17830000E-04
   +1.87300000E-05  -8.63700000E-05  -6.33500000E-05  +3.27800000E-05  +6.51700000E-05
   -9.59600000E-04  -1.60100000E-04  -6.61300000E-05  +3.17237600E-02  +4.16914700E-02
   -2.49300000E-05  +2.17900000E-05  +3.75800000E-05  +1.16120000E-04  -5.24500000E-05
   +8.86000000E-06  -7.26500000E-05  +4.45100000E-05  -2.91500000E-05  +5.61300000E-05
   -1.43400000E-05  -1.67700000E-05  +2.77600000E-05  -5.99000000E-05  -8.90000000E-06
   +1.58000000E-05  -1.03500000E-05  -1.24600000E-05  +6.03500000E-05  +1.57910000E-04
   +1.60570000E-04  +2.85600000E-05  +6.62600000E-05  +1.23500000E-05  -3.05300000E-05
   +3.73100000E-05  -5.20000000E-07  -1.66690000E-04  +1.90476000E-03  +2.69044000E-03
   +2.78923000E-03  +8.44220000E-04  +4.93165000E-03  -1.38023500E-01  -1.15603300E-02
   -2.28149160E-01  -2.01682900E-02  -6.01883000E-03  -1.51957500E-02  +8.70000000E-04
   +4.71026000E-03  -2.89402000E-03  +1.22338000E-03  +5.89760000E-04  -2.06910000E-04
   +1.24720000E-03  -1.85962000E-03  +1.87255000E-03  -2.32400000E-05  -4.23600000E-05
   -2.13200000E-05  -4.89600000E-05  +1.68200000E-05  +2.72200000E-05  +1.21230000E-03
   +1.63413000E-03  -9.04830000E-04  +1.50859740E-01  +1.16008400E-02  +2.38471870E-01
   -4.16800000E-05  -1.05570000E-04  -1.79520000E-04  -1.10210000E-04  -2.23370000E-04
   -2.29900000E-04  +3.65300000E-05  -1.77700000E-05  +4.28300000E-05  +4.64900000E-05
   -1.45000000E-06  +2.73300000E-05  -9.70900000E-05  +2.74800000E-05  -1.20380000E-04
   +6.44500000E-05  +9.40000000E-06  +1.89660000E-04  -8.59340000E-04  +1.92809000E-03
   +9.91110000E-04  +4.95010000E-04  +1.13500000E-05  +1.15470000E-04  +7.15300000E-05
   -6.79300000E-05  +3.56300000E-05  +8.10337000E-03  +1.02895100E-02  -1.52688900E-02
   -5.80462700E-02  -2.78753300E-02  +2.75595200E-02  +2.06190000E-04  -1.31668300E-02
   +2.18955200E-02  -9.30300000E-04  -5.76282000E-03  -1.83449000E-03  -1.29506000E-03
   +7.51600000E-05  -2.14180000E-04  -3.06160000E-04  -2.99383000E-03  -4.76160000E-03
   -4.81520000E-04  -8.87580000E-04  +1.15224000E-03  -2.09830000E-03  -2.15046000E-03
   -1.07976000E-03  +9.95000000E-05  -4.43000000E-06  +5.99100000E-05  +1.60710000E-04
   +8.78000000E-05  +1.31240000E-04  -8.01170000E-04  +2.29894000E-03  +8.75990000E-04
   +5.85502400E-02  +4.61000000E-05  -2.24890000E-04  +1.48560000E-04  -1.66730000E-04
   +9.15920000E-04  +3.27260000E-04  +2.12840000E-04  -2.86270000E-04  -1.30800000E-05
   -1.53370000E-04  +1.97900000E-05  +6.49800000E-05  +1.38220000E-04  +1.99710000E-04
   +1.04280000E-04  -1.39130000E-04  -2.27800000E-05  -1.85450000E-04  +2.10030000E-03
   -2.30076000E-03  -6.73550000E-04  -4.28670000E-04  -2.69320000E-04  +2.41900000E-05
   -3.79300000E-05  -3.14700000E-05  -3.62600000E-05  +4.22640000E-04  +5.28886000E-03
   -2.64668000E-03  -2.76207300E-02  -1.20280430E-01  +1.28787130E-01  -2.29605000E-03
   -5.92138000E-03  +1.74541400E-02  -5.88983000E-03  +2.91563000E-03  +1.01182000E-03
   +1.86260000E-04  -7.44600000E-04  -7.61210000E-04  -3.00053000E-03  +3.96066000E-03
   +4.78680000E-04  -2.85330000E-04  -7.93280000E-04  +8.39880000E-04  -2.99878000E-03
   -1.56839000E-03  -7.14470000E-04  +4.24000000E-06  -1.51520000E-04  -9.32100000E-05
   +1.54100000E-04  +6.23700000E-05  +9.66800000E-05  +2.12110000E-03  -2.00306000E-03
   -1.51686000E-03  +3.89154000E-02  +1.23525260E-01  -9.83600000E-05  -5.70300000E-05
   -1.14150000E-04  +2.74410000E-04  +2.99560000E-04  -4.90800000E-05  +3.34100000E-05
   -1.20080000E-04  +2.35900000E-05  +3.14500000E-05  -4.80000000E-07  +3.74200000E-05
   +5.49000000E-06  +5.03700000E-05  -1.14430000E-04  +2.68700000E-05  -7.14000000E-06
   +1.04040000E-04  +2.06990000E-03  +1.42660000E-04  -8.59490000E-04  -3.37280000E-04
   -1.14520000E-04  +8.02100000E-05  +1.72500000E-05  -3.93500000E-05  +2.06600000E-05
   +4.85064000E-03  +1.30706900E-02  -1.55066700E-02  +2.75228000E-02  +1.27529450E-01
   -2.64507920E-01  -1.54422000E-03  -9.61900000E-05  +1.84328000E-03  -1.64093000E-03
   +1.22584000E-03  +2.72818000E-03  -2.05400000E-04  -9.05190000E-04  +2.93140000E-04
   -5.08964000E-03  +2.77390000E-04  -2.05783000E-03  +2.10990000E-04  +1.37500000E-04
   -8.84200000E-05  +7.76020000E-04  +1.01438000E-03  +4.02820000E-04  +3.75500000E-05
   -9.52500000E-05  +7.54900000E-05  -5.10900000E-05  -2.76900000E-05  -4.38000000E-05
   +1.21673000E-03  -1.30088000E-03  +2.44320000E-04  -2.94886200E-02  -1.41257990E-01
   +2.77391900E-01  -5.57500000E-05  +8.71300000E-05  -8.85200000E-05  +3.87600000E-05
   -6.53590000E-04  +4.60480000E-04  -1.80184000E-03  +1.22590000E-04  +5.68410000E-04
   -3.02900000E-04  -3.68000000E-05  -1.63800000E-04  -6.23300000E-05  +1.21440000E-04
   +1.91900000E-04  +4.30800000E-05  +2.38300000E-05  +1.55200000E-05  -1.56025000E-03
   +1.14902000E-03  +3.91870000E-04  -5.13140000E-04  -7.24820000E-04  +5.41700000E-05
   +8.31200000E-05  -1.01160000E-04  -3.86100000E-05  +7.26248000E-03  +6.31120000E-04
   +3.82682000E-03  +2.54287000E-03  -2.94086000E-03  +3.44880000E-04  -5.28980000E-04
   +3.27900000E-05  +9.08580000E-04  +3.40540000E-04  -5.99995000E-03  -6.59000000E-05
   -1.10566400E-02  -1.52916000E-03  -2.09228200E-02  -1.58891630E-01  -2.07795300E-02
   -1.40411520E-01  -8.74880000E-04  -1.14640000E-04  -1.13706000E-03  +1.48260000E-04
   +1.97420000E-04  +6.65200000E-05  +1.06300000E-04  +5.76400000E-05  -1.97180000E-04
   -3.23110000E-04  -9.98500000E-05  +6.05100000E-05  -2.39390000E-04  +2.96550000E-04
   +8.21000000E-05  +2.71110000E-04  -4.26800000E-05  +3.50230000E-04  +1.67042040E-01
   +1.05610000E-04  -1.28980000E-04  -4.64000000E-06  -4.28080000E-04  +6.51510000E-04
   -5.01400000E-05  -1.87060000E-04  +4.81000000E-05  +3.83620000E-04  +2.04780000E-04
   -1.39560000E-04  -1.92880000E-04  +1.83800000E-05  +2.64000000E-05  -5.15400000E-05
   -6.00300000E-05  -2.76700000E-05  -6.69600000E-05  +2.05584000E-03  -1.24232000E-03
   -1.07198000E-03  -4.58810000E-04  -1.03155000E-03  +7.24580000E-04  +1.47800000E-05
   -6.17900000E-05  +1.77800000E-05  +1.07607100E-02  +5.79833000E-03  +1.22101000E-02
   -3.02611000E-03  +1.69890000E-03  +4.65841000E-03  -1.24000000E-05  -1.21912000E-03
   +6.46100000E-05  -6.10594000E-03  +2.46276000E-03  +2.83482000E-03  -1.34124100E-02
   +2.74636000E-03  -1.61983300E-02  -2.03346400E-02  -5.01618700E-02  -9.43036000E-03
   -5.73490000E-04  -6.67200000E-05  -9.68460000E-04  +5.58000000E-05  -2.20100000E-04
   -1.45180000E-04  +7.83000000E-06  -1.25070000E-04  +1.16270000E-04  -1.28850000E-04
   -3.29110000E-04  -8.18700000E-05  +3.17900000E-04  -3.48990000E-04  -2.13850000E-04
   +5.36270000E-04  +3.07620000E-04  +7.39510000E-04  +2.91758800E-02  +4.48595000E-02
   +3.30300000E-05  -9.24100000E-05  -1.31020000E-04  +3.00000000E-07  +6.91790000E-04
   -7.68490000E-04  -9.17320000E-04  -1.46850000E-04  -2.75300000E-05  +5.85240000E-04
   -2.63140000E-04  +1.80000000E-07  +8.55600000E-05  -2.15410000E-04  -3.76960000E-04
   -8.18500000E-05  +2.73700000E-05  +5.92100000E-05  +2.15810000E-04  -1.74258000E-03
   -4.52720000E-04  -1.83090000E-04  -3.51220000E-04  -2.25300000E-05  -1.04500000E-04
   +1.45850000E-04  +8.57700000E-05  -1.72967400E-02  -3.97417000E-03  -1.50687500E-02
   +6.61940000E-04  +4.90884000E-03  -2.91706000E-03  +9.94810000E-04  +1.12660000E-04
   +1.66120000E-04  -3.29660000E-04  +2.79308000E-03  +2.53138000E-03  +2.41459000E-03
   +1.76061000E-03  +5.17095000E-03  -1.40279350E-01  -9.97930000E-03  -2.33597290E-01
   -1.22130000E-04  -1.57880000E-04  +7.19800000E-05  +2.96700000E-05  -2.14300000E-05
   +8.97000000E-05  -1.80270000E-04  -8.52400000E-05  +4.55860000E-04  +1.46780000E-04
   -2.15800000E-05  +6.47000000E-06  +6.00800000E-05  -2.39470000E-04  -1.12520000E-04
   -9.21220000E-04  -2.14830000E-04  -8.81720000E-04  +1.54068000E-01  +8.90616000E-03
   +2.43765680E-01  -3.33900000E-05  +5.40700000E-05  +1.11600000E-05  +2.96310000E-04
   -2.72890000E-04  +1.02930000E-04  -1.44030000E-04  +1.39900000E-04  -7.69000000E-05
   +4.96900000E-05  -2.77200000E-05  -3.65800000E-05  -2.01300000E-05  -9.40000000E-05
   +2.32000000E-05  +1.44300000E-05  +6.16000000E-06  +1.08000000E-06  +2.47890000E-04
   -4.84780000E-04  +8.53400000E-04  +4.66100000E-05  +9.21200000E-05  +1.28710000E-04
   -5.22000000E-06  +4.13500000E-05  -1.96600000E-05  -8.70970000E-04  -5.58811000E-03
   -1.67994000E-03  -1.36453000E-03  -1.41170000E-04  -3.63220000E-04  -7.00560000E-04
   -2.71271000E-03  -4.16994000E-03  +8.04168000E-03  +1.03792300E-02  -1.69551600E-02
   -5.90929600E-02  -3.32537600E-02  +3.19858800E-02  +4.77420000E-04  -1.22838400E-02
   +2.15985500E-02  +1.12250000E-04  +1.84879000E-03  +1.72111000E-03  -3.29590000E-04
   -1.65730000E-04  -1.63900000E-05  -1.68700000E-05  +6.64600000E-05  +5.26000000E-06
   +2.84000000E-06  +2.27340000E-04  +3.57380000E-04  +1.74420000E-04  +6.39080000E-04
   -8.93620000E-04  -1.82940000E-04  +2.93070000E-04  +2.06630000E-04  -8.22310000E-04
   +2.48177000E-03  +1.05804000E-03  +5.41812700E-02  -4.95100000E-05  +2.36500000E-05
   +9.53000000E-06  +3.25700000E-04  -1.98140000E-04  +6.88000000E-05  +1.31000000E-06
   +7.31500000E-05  -1.62000000E-06  +1.77300000E-05  +3.30000000E-06  -2.65700000E-05
   +1.07000000E-05  -2.94600000E-05  +1.09300000E-05  +3.11300000E-05  -1.30300000E-05
   +1.09000000E-06  -5.41400000E-05  +3.58300000E-05  +9.21220000E-04  -2.58900000E-05
   +1.69900000E-05  -3.52300000E-05  -1.84900000E-05  +1.05300000E-05  -8.45000000E-06
   -5.91971000E-03  +2.88445000E-03  +8.22340000E-04  +1.62780000E-04  -4.87490000E-04
   -6.31550000E-04  -2.54130000E-03  +3.24463000E-03  +4.52370000E-04  -1.37932000E-03
   +5.64833000E-03  -2.98205000E-03  -3.25985700E-02  -1.25513070E-01  +1.32528930E-01
   -1.38935000E-03  -6.19513000E-03  +1.64102300E-02  +1.93159000E-03  -1.46000000E-03
   -8.80620000E-04  -2.14790000E-04  -8.34700000E-05  -1.44360000E-04  -3.58900000E-05
   +1.65600000E-05  -2.60000000E-06  +2.64600000E-04  -2.78240000E-04  -9.76600000E-05
   +1.06020000E-04  +9.22900000E-05  -3.04360000E-04  +3.06400000E-04  -3.88480000E-04
   -1.21540000E-04  +2.27239000E-03  -2.23071000E-03  -1.66096000E-03  +3.88012100E-02
   +1.25012740E-01  +1.05200000E-05  -4.01100000E-05  -2.60000000E-05  -7.51100000E-05
   +7.69300000E-05  +1.23000000E-06  +1.04360000E-04  -5.08500000E-05  +4.99800000E-05
   -5.40400000E-05  +1.91400000E-05  +1.23900000E-05  -2.57000000E-06  +8.26100000E-05
   +1.08800000E-05  -8.40000000E-06  -1.44000000E-06  +6.50000000E-07  -2.21780000E-04
   +3.86000000E-05  +1.20470000E-04  +3.37500000E-05  -4.08000000E-06  -5.16000000E-05
   +1.43400000E-05  -4.35600000E-05  +9.50000000E-07  -1.51396000E-03  +1.28831000E-03
   +2.69628000E-03  -6.23410000E-04  -1.02325000E-03  +1.51590000E-04  -4.54604000E-03
   +1.21470000E-04  -1.95745000E-03  +7.19985000E-03  +1.57022200E-02  -1.57705300E-02
   +3.10601900E-02  +1.31528300E-01  -2.57705390E-01  -1.14999000E-03  -1.06499000E-03
   +3.21310000E-03  +1.47993000E-03  -1.09409000E-03  +1.20817000E-03  +4.09900000E-05
   +1.14200000E-05  -1.25900000E-05  +2.48500000E-05  -3.62600000E-05  -2.97700000E-05
   +2.74570000E-04  -1.63670000E-04  +2.35390000E-04  +2.57630000E-04  +5.44910000E-04
   -8.88380000E-04  +1.80540000E-04  -1.44730000E-04  -1.13790000E-04  +1.35181000E-03
   -1.33823000E-03  +8.95100000E-05  -3.38317100E-02  -1.44366000E-01  +2.68784200E-01
   +5.43600000E-05  -7.63700000E-05  +2.59500000E-05  +8.28730000E-04  +8.22400000E-04
   -1.40800000E-05  +9.37000000E-05  -2.63290000E-04  +2.05600000E-05  -1.00000000E-04
   +2.09900000E-05  +4.71300000E-05  +4.60300000E-05  +1.42620000E-04  +7.31800000E-05
   -1.43620000E-04  +1.14300000E-05  -2.17100000E-05  +1.64750000E-04  +1.61549000E-03
   +1.86690000E-04  +5.52070000E-04  +2.14850000E-04  -4.89580000E-04  +2.53100000E-05
   -4.39300000E-05  -2.01100000E-05  +2.96330000E-04  +4.01400000E-05  -2.16290000E-04
   -3.29900000E-05  -2.14360000E-04  -3.26050000E-04  +2.27250000E-04  -4.74300000E-05
   +1.03600000E-04  +1.49530000E-04  +7.16600000E-05  +1.35920000E-04  -1.91650000E-04
   -8.94500000E-05  -1.40500000E-05  +3.43890000E-04  +6.32000000E-05  -3.46450000E-04
   -1.92580000E-04  -1.26100000E-04  +3.26500000E-05  -1.92554260E-01  -1.38141220E-01
   -1.22800100E-02  +6.56500000E-05  -1.83570000E-04  -6.42000000E-06  +3.81100000E-05
   +1.80200000E-05  +4.46000000E-06  -7.48000000E-06  -1.99800000E-05  -2.03600000E-05
   -2.07090000E-04  +3.35300000E-05  +4.77570000E-04  +2.77400000E-05  -2.55500000E-05
   +5.76200000E-05  -3.02300000E-05  +2.57900000E-05  +1.49200000E-05  +2.11151860E-01
   +7.71700000E-05  -2.65230000E-04  -2.31870000E-04  -3.01224000E-03  -1.13707000E-03
   +3.80660000E-04  +2.85410000E-04  +1.72000000E-04  -3.32600000E-05  -5.07700000E-05
   +4.25800000E-05  +7.06100000E-05  -2.11690000E-04  -2.05910000E-04  -4.56900000E-05
   +7.49300000E-05  +3.83100000E-05  +1.05730000E-04  -1.31013200E-02  -1.40594100E-02
   -6.73840000E-04  +6.09100000E-05  +6.35460000E-04  -1.67214000E-03  +2.42100000E-05
   +1.95710000E-04  -3.55000000E-06  +1.24077000E-03  -1.28143000E-03  +2.74326000E-03
   +2.41600000E-04  +4.33380000E-04  +3.13180000E-04  -1.03420000E-04  -2.83800000E-05
   +7.60300000E-05  +1.59110000E-04  +6.93700000E-05  -7.37300000E-05  +1.18500000E-05
   -6.17200000E-05  +3.23300000E-04  -9.47830000E-04  -4.17220000E-04  -3.35440000E-04
   -1.62220000E-04  -1.29820000E-04  +7.02000000E-06  -1.36334550E-01  -1.76815720E-01
   -1.36197800E-02  -2.14340000E-04  +1.00350000E-03  -1.02110000E-04  +2.40300000E-05
   +1.46800000E-05  +7.39000000E-06  -4.56000000E-05  +6.20000000E-06  +2.46000000E-06
   +3.02850000E-04  -2.65300000E-05  -7.23000000E-05  +4.81400000E-05  +7.36000000E-06
   +5.17700000E-05  -6.11500000E-05  -7.39300000E-05  -4.64000000E-06  +1.48163350E-01
   +1.89582370E-01  -1.49830000E-04  -1.21400000E-04  -2.93780000E-04  +1.55736000E-03
   -4.75720000E-04  +3.31320000E-04  -2.93630000E-04  +7.30000000E-05  -9.71300000E-05
   +1.54620000E-04  -5.14000000E-05  -1.02570000E-04  -3.77900000E-05  -8.74000000E-05
   -1.29150000E-04  +1.58560000E-04  -5.10000000E-06  +1.81810000E-04  +1.89747700E-02
   +1.84369600E-02  -5.55380000E-04  +1.28958000E-03  +1.24243000E-03  +6.29870000E-04
   +2.88800000E-05  -2.97900000E-05  +1.44700000E-05  -1.40758000E-03  +2.87961000E-03
   -4.37906000E-03  -6.98520000E-04  -1.22100000E-04  -8.74640000E-04  +9.96600000E-05
   -6.42000000E-06  +3.41580000E-04  -2.19430000E-04  -9.26600000E-05  -8.54700000E-05
   +1.59080000E-04  +6.37600000E-05  -3.51170000E-04  +1.18788000E-03  +9.21150000E-04
   +4.89450000E-04  +1.47060000E-04  +6.76500000E-05  +5.28200000E-05  -1.47640600E-02
   -1.64040400E-02  -4.82460000E-02  +6.04300000E-05  -1.26370000E-04  +1.11450000E-04
   -2.71000000E-06  +1.37100000E-05  -1.34500000E-05  +2.45800000E-05  +1.64500000E-05
   -2.93000000E-06  +1.06550000E-04  -3.66630000E-04  +4.14760000E-04  -7.80200000E-05
   +5.13200000E-05  +4.00200000E-05  +1.21520000E-04  +5.16300000E-05  -1.71500000E-05
   +1.51050000E-02  +1.25782900E-02  +5.45685200E-02  -3.22510000E-04  +6.71890000E-04
   +1.73500000E-05  +6.20580000E-04  -2.17850000E-04  -9.26420000E-04  +9.70700000E-05
   -4.47400000E-05  +1.23580000E-04  +3.16500000E-05  +2.08600000E-05  +2.33300000E-05
   -7.25500000E-05  +8.52000000E-05  -9.26400000E-05  -1.49910000E-04  -2.40100000E-05
   +3.63300000E-05  -2.32150000E-03  -6.86390000E-04  -1.86021000E-03  +4.24000000E-06
   +5.54380000E-04  -4.98000000E-04  +5.09000000E-05  -7.80900000E-05  +2.66300000E-05
   +2.51010000E-04  +2.43660000E-04  +1.76730000E-04  -2.09370000E-04  -1.98850000E-04
   +8.71640000E-04  -5.24500000E-05  +7.35600000E-05  -2.90270000E-04  +2.07300000E-05
   -2.07100000E-05  +1.50100000E-05  +2.43400000E-05  +4.09100000E-05  -5.12900000E-05
   -8.24100000E-05  -3.28600000E-05  -1.23340000E-04  +5.59400000E-05  +6.55700000E-05
   -5.58500000E-05  -5.07223100E-02  +1.50251700E-02  +2.69832000E-02  +7.33700000E-05
   -1.14310000E-04  +9.19500000E-05  -2.52500000E-05  -2.23400000E-05  +1.05400000E-05
   -1.50000000E-05  +2.16000000E-06  +2.48300000E-05  -1.98203000E-03  -8.94040000E-04
   +3.18000000E-04  +1.29000000E-06  +3.10300000E-05  -4.89400000E-05  -2.98000000E-06
   +3.37000000E-06  -6.16000000E-06  +4.16549000E-03  -1.14970500E-02  -2.11932400E-02
   +5.21131800E-02  +7.25290000E-04  -1.32753000E-03  +9.08320000E-04  +5.52670000E-04
   +9.50830000E-04  -6.76680000E-04  -2.50790000E-04  +2.27000000E-05  -3.27100000E-05
   -4.36400000E-05  -2.82900000E-05  -8.38100000E-05  +1.87100000E-04  +3.82000000E-05
   +5.71200000E-05  -1.08060000E-04  -4.97000000E-05  -2.00980000E-04  -2.78571000E-03
   +1.19901000E-02  +1.58964000E-02  +1.88630000E-04  -2.01786000E-03  +2.49178000E-03
   -9.68100000E-05  +5.21700000E-05  -3.03900000E-05  +1.01870000E-04  +4.73500000E-04
   -3.37080000E-04  -8.26240000E-04  -1.28860000E-04  -4.34080000E-04  -6.16000000E-06
   -9.40700000E-05  +2.21490000E-04  -1.13570000E-04  -4.98500000E-05  -1.36740000E-04
   +9.78200000E-05  +5.08200000E-05  +3.12300000E-05  +1.19330000E-04  -1.31850000E-04
   +4.54600000E-05  +5.99600000E-05  +1.92300000E-05  +3.19500000E-05  +1.57911900E-02
   -1.18399530E-01  -1.17864410E-01  -9.03100000E-05  -8.73600000E-05  +1.94100000E-05
   -5.14000000E-06  +6.01000000E-06  -8.58000000E-06  -1.25100000E-05  +1.84600000E-05
   +1.13000000E-06  -1.22017000E-03  -5.07830000E-04  +4.99100000E-04  -7.08000000E-06
   +3.95500000E-05  +4.78000000E-06  -4.87000000E-06  +1.42700000E-05  +1.09400000E-05
   +4.76480000E-03  -1.06957200E-02  -1.77784200E-02  -1.74703700E-02  +1.29377190E-01
   -4.11980000E-04  -1.04658000E-03  -1.63170000E-04  +1.23259000E-03  -1.28919000E-03
   -3.27250000E-04  -2.94650000E-04  +1.27470000E-04  -9.09000000E-06  +3.03690000E-04
   +1.18800000E-05  -3.81000000E-06  -1.47140000E-04  +7.05700000E-05  -7.41770000E-04
   -1.22830000E-04  +1.24150000E-04  +7.33720000E-04  +1.85030000E-03  -1.49909400E-02
   -1.93613600E-02  +3.44040000E-04  +4.63382000E-03  -4.19700000E-03  +1.20380000E-04
   -5.45600000E-05  +1.20210000E-04  -7.14110000E-04  -5.26040000E-04  +2.95700000E-04
   -6.20700000E-04  +1.70630000E-04  -2.63010000E-04  +2.32110000E-04  +5.46600000E-05
   +3.73090000E-04  -2.34600000E-05  -1.48860000E-04  +5.12500000E-05  -7.35400000E-05
   -6.82000000E-05  +4.43400000E-05  +9.37500000E-05  +3.22720000E-04  -4.97000000E-06
   +4.13500000E-05  +2.22400000E-05  +5.18500000E-05  +2.65956800E-02  -1.15484870E-01
   -2.44256280E-01  +2.16330000E-04  +1.38060000E-04  +5.12010000E-04  +1.61200000E-05
   +7.31000000E-06  -1.38500000E-05  +1.93200000E-05  +3.33100000E-05  -7.48000000E-06
   +4.35780000E-04  -8.81000000E-05  +5.37950000E-04  +3.75000000E-06  -1.36370000E-04
   +7.52400000E-05  +2.93600000E-05  -1.25000000E-06  -1.19300000E-05  +2.31700000E-04
   -2.88330000E-04  -8.77010000E-04  -2.85220000E-02  +1.27891970E-01  +2.65289800E-01
   +4.93100000E-05  -4.43000000E-05  -5.09500000E-05  -3.75110000E-04  -1.16576000E-03
   +5.75800000E-05  +1.05520000E-04  +3.30970000E-04  +6.88600000E-05  +1.03810000E-04
   -1.36000000E-05  -1.14490000E-04  -3.51900000E-05  -2.31120000E-04  +1.33700000E-05
   +6.88800000E-05  +2.01000000E-06  -1.57800000E-05  -1.00078000E-03  -1.99360000E-04
   +9.71940000E-04  -1.77350000E-04  -7.14300000E-05  +3.88400000E-04  -5.99600000E-05
   +1.73400000E-04  -1.66700000E-05  +4.35490000E-04  -7.09390000E-04  +1.06020000E-04
   -2.95930000E-04  -1.18620000E-03  -3.79100000E-04  +1.46110000E-04  +1.87000000E-05
   +1.07310000E-04  -1.31300000E-04  -4.04800000E-05  +8.88100000E-05  -2.33900000E-05
   +1.01900000E-05  +2.73200000E-05  +2.84770000E-04  +2.52800000E-05  -5.99400000E-05
   +9.01900000E-05  +6.72200000E-05  +1.14400000E-05  -2.56957130E-01  +1.14517960E-01
   -6.18500000E-03  -2.05360000E-04  +4.91930000E-04  -1.56000000E-06  -6.85000000E-06
   +2.56000000E-06  -1.11100000E-05  +4.48100000E-05  -2.37700000E-05  -2.36500000E-05
   -3.99550000E-04  -1.10042000E-03  +1.15980000E-04  +7.25000000E-06  -1.12800000E-05
   -1.70000000E-07  -9.42000000E-06  +4.83700000E-05  +1.20200000E-05  -1.87509000E-02
   +1.17886600E-02  +1.36680000E-04  -2.18478000E-03  -2.15900000E-05  -3.87660000E-04
   +2.78308850E-01  +1.28120000E-04  -2.28240000E-04  +2.85840000E-04  -1.15980000E-03
   -1.63106000E-03  +3.86053000E-03  +1.04696000E-03  -5.48830000E-04  -6.45690000E-04
   +1.40250000E-04  +3.10500000E-05  +4.55090000E-04  -1.58620000E-04  +2.48690000E-04
   -1.70300000E-05  -2.05970000E-04  +7.88900000E-05  +5.19500000E-05  +1.70927700E-02
   -1.18829400E-02  +6.08550000E-04  -4.13760000E-04  -1.52500000E-05  -1.06412000E-03
   +1.00990000E-04  -6.33100000E-05  +1.77000000E-06  +8.27070000E-04  +9.48530000E-04
   -8.68540000E-04  -8.61500000E-05  -3.11790000E-04  +6.26270000E-04  -3.90360000E-04
   -2.34300000E-05  -2.12380000E-04  -1.59620000E-04  -2.00100000E-05  -2.78840000E-04
   +2.96400000E-04  +1.94970000E-04  -1.60600000E-05  -2.65970000E-04  -1.12120000E-04
   +2.67820000E-04  +1.75470000E-04  +1.45560000E-04  -4.38800000E-05  +1.12219070E-01
   -1.06356560E-01  +2.99353000E-03  +1.05850000E-04  +3.10870000E-04  -4.86400000E-05
   -3.98900000E-05  -3.81600000E-05  -2.20000000E-07  +1.44000000E-05  -3.42900000E-05
   +1.66500000E-05  -6.10060000E-04  -1.60380000E-03  -7.76410000E-04  +2.15900000E-05
   +2.60100000E-05  -1.07830000E-04  +2.11300000E-05  -6.37000000E-06  -1.41500000E-05
   -1.98084800E-02  +1.21132700E-02  -1.70070000E-04  +1.40038800E-02  -7.92081000E-03
   +1.08131000E-03  -1.22468730E-01  +1.15804190E-01  -2.10660000E-04  -4.56960000E-04
   -4.59500000E-05  +1.49254000E-03  +1.27838000E-03  -5.03564000E-03  -1.56091000E-03
   +8.83680000E-04  +6.30790000E-04  +1.59800000E-05  -6.22800000E-05  -5.16670000E-04
   -1.02800000E-05  -1.58210000E-04  -4.10740000E-04  -3.82100000E-05  -2.49200000E-05
   +3.40530000E-04  -2.33945800E-02  +1.38008800E-02  -2.26788000E-03  -1.08441000E-03
   +9.87260000E-04  +1.02187000E-03  +5.10000000E-06  +3.53900000E-05  +5.74400000E-05
   -4.13710000E-04  -9.55770000E-04  +1.09254000E-03  +1.95170000E-04  -9.37400000E-05
   +6.42130000E-04  +1.42250000E-04  +1.42380000E-04  -1.76230000E-04  +1.54110000E-04
   -3.04900000E-05  +2.36410000E-04  -2.00880000E-04  -9.38700000E-05  -7.18500000E-05
   +8.78500000E-05  -6.79900000E-05  -3.42160000E-04  -6.72100000E-05  -2.93400000E-05
   -4.57700000E-05  -4.52448000E-03  +1.53066000E-03  -4.73264900E-02  +1.02100000E-05
   +3.11500000E-05  +3.39480000E-04  -1.40000000E-06  -6.22000000E-06  +1.42200000E-05
   -2.04900000E-05  +2.45500000E-05  +1.39800000E-05  -1.15100000E-04  -4.40810000E-04
   -9.58200000E-05  -2.66400000E-05  +2.68800000E-05  +6.52000000E-06  -2.76800000E-05
   +1.52800000E-05  +5.98000000E-06  -2.27077000E-03  +1.29120000E-03  -9.84460000E-04
   +2.50765900E-02  -1.20727100E-02  +1.61661000E-03  +6.39084000E-03  -5.41325000E-03
   +5.16997400E-02  -9.23800000E-05  +1.44350000E-04  -5.04100000E-05  +3.21050000E-04
   -8.00970000E-04  +5.61530000E-04  -7.32270000E-04  +6.24410000E-04  +6.06520000E-04
   -9.32900000E-05  -1.48440000E-04  -3.20040000E-04  -9.50600000E-05  +3.54700000E-05
   +2.61920000E-04  +7.58300000E-05  -1.20700000E-05  -3.01200000E-05  -2.22370000E-03
   +3.85300000E-04  -1.53088000E-03  -4.99749900E-02  -1.53641600E-02  +2.77232900E-02
   +7.10300000E-05  -6.20800000E-05  -6.94100000E-05  +3.97500000E-05  +5.16970000E-04
   -4.81750000E-04  -2.46800000E-05  -2.20800000E-05  +2.92000000E-05  +9.97400000E-05
   +2.68500000E-05  +1.77000000E-05  -8.72200000E-05  -8.12700000E-05  +7.14000000E-06
   -1.09390000E-04  -2.96000000E-05  +1.07660000E-04  -3.62370000E-04  -5.33590000E-04
   -4.60670000E-04  +8.99400000E-05  +7.33600000E-05  +1.89800000E-05  +7.17200000E-05
   -5.52080000E-04  -6.71360000E-04  +6.76200000E-05  +2.25620000E-04  -2.41880000E-04
   -1.27200000E-05  -1.57200000E-05  -6.04000000E-06  +8.86000000E-06  +8.42000000E-06
   +9.31000000E-06  +3.99500000E-05  +1.54100000E-05  +3.78400000E-05  +5.86130000E-04
   -6.71350000E-04  -4.83700000E-05  +2.03400000E-05  -2.59900000E-05  -1.08800000E-05
   +7.93300000E-05  +3.31290000E-04  -1.44030000E-04  +5.99880000E-04  +8.69700000E-05
   -2.48280000E-04  +2.94890000E-04  -2.02140000E-04  +3.42500000E-04  +5.11208500E-02
   -1.20490000E-04  +3.94000000E-06  +7.57000000E-06  +2.65280000E-04  +5.83600000E-04
   +7.44580000E-04  +6.75560000E-04  -7.92040000E-04  +3.87630000E-04  +1.91880000E-04
   -1.32610000E-04  -3.86510000E-04  -1.01200000E-05  -1.34920000E-04  +3.23000000E-05
   +5.20000000E-07  +8.98000000E-06  +4.84400000E-05  +1.72852000E-03  +1.13370200E-02
   -1.75866100E-02  -1.56161500E-02  -1.12912170E-01  +1.17093170E-01  -1.52000000E-06
   +2.80600000E-05  -2.40400000E-05  +1.66750000E-04  +1.03760000E-03  +7.25600000E-04
   -1.41260000E-04  +3.43200000E-05  +8.44000000E-06  +1.65040000E-04  +7.84700000E-05
   -8.62000000E-05  -8.41100000E-05  -1.15700000E-05  +1.35180000E-04  +9.56100000E-05
   -1.18280000E-04  +2.26570000E-04  -6.82100000E-04  -1.02043000E-03  -1.14928000E-03
   +1.44330000E-04  +1.00250000E-04  +1.11700000E-05  -1.13590000E-04  -2.26511000E-03
   -2.63868000E-03  -5.90600000E-05  +1.16460000E-04  +6.90100000E-05  -1.46500000E-05
   -5.89000000E-06  -3.93000000E-06  +2.09300000E-05  +5.10000000E-07  +2.44000000E-06
   +4.75900000E-05  +1.10700000E-05  +3.54000000E-05  -6.40090000E-04  -1.86116000E-03
   -1.46900000E-04  +9.27000000E-06  -3.09800000E-05  -2.48300000E-05  +2.88130000E-04
   +2.05300000E-05  -1.96040000E-04  -7.58900000E-05  +8.19120000E-04  -1.05818000E-03
   -2.42980000E-04  -2.59000000E-06  -1.71440000E-04  +1.51596000E-02  +1.24481220E-01
   +1.41470000E-04  -2.66190000E-04  +9.67400000E-05  -9.06200000E-04  +1.38586000E-03
   -6.43840000E-04  -3.60870000E-04  +6.48700000E-05  -4.36510000E-04  +8.44200000E-05
   +2.12190000E-04  +8.44340000E-04  +3.25900000E-05  +1.33590000E-04  -4.23860000E-04
   -1.09230000E-04  -3.17500000E-05  +2.38200000E-05  +1.77670000E-03  +1.35921500E-02
   -1.94255900E-02  +2.65988800E-02  +1.13468860E-01  -2.53399690E-01  -7.51100000E-05
   +4.59700000E-05  +1.23170000E-04  +1.34072000E-03  +1.14785000E-03  +5.13120000E-04
   -5.68570000E-04  -1.11320000E-04  -1.95440000E-04  +3.52810000E-04  +2.46110000E-04
   -1.45000000E-05  +1.54260000E-04  -1.19780000E-04  +3.09930000E-04  -3.89240000E-04
   -2.41500000E-04  +3.89450000E-04  +5.96100000E-05  +1.05452000E-03  -1.02990000E-04
   +5.21800000E-05  +1.43000000E-06  +3.04800000E-05  +4.25970000E-04  -4.50672000E-03
   -3.91389000E-03  -1.74100000E-05  -2.60610000E-04  +2.62490000E-04  +8.20000000E-07
   -9.14000000E-06  -4.99000000E-06  +1.30400000E-05  -2.51000000E-05  -1.27300000E-05
   +1.33170000E-04  +6.03300000E-05  +1.16530000E-04  +2.55700000E-04  -2.67300000E-04
   +7.99470000E-04  -4.86900000E-05  +1.00800000E-05  +1.00000000E-08  -8.33600000E-05
   -2.38470000E-04  +3.20220000E-04  -2.40280000E-04  +9.38380000E-04  -1.47843000E-03
   -7.09700000E-05  -2.36400000E-05  +2.39100000E-04  -2.86894300E-02  -1.26053400E-01
   +2.74522450E-01  +1.32490000E-04  -1.21990000E-04  -3.27800000E-05  +3.61700000E-04
   +6.84780000E-04  -1.63130000E-04  +1.80610000E-04  +3.17800000E-05  +2.50300000E-05
   -4.50000000E-06  -1.19000000E-06  +7.60100000E-05  -1.58100000E-05  +5.81900000E-05
   -3.13800000E-05  -4.44500000E-05  -1.77900000E-05  -5.47000000E-06  -1.88960000E-04
   +3.25140000E-04  +3.74390000E-04  -2.55320930E-01  -1.16953910E-01  -2.61828000E-03
   +2.39100000E-05  -4.97700000E-05  +7.05000000E-06  +5.21260000E-04  -1.06880000E-04
   -1.13510000E-04  +5.19380000E-04  +1.55300000E-05  +2.32110000E-04  -1.11570000E-04
   -1.29190000E-04  +1.21860000E-04  +1.55590000E-04  +1.70890000E-04  -1.21400000E-04
   -1.19100000E-05  +2.36200000E-05  -2.20100000E-05  +1.20230000E-04  +1.86360000E-04
   -2.59690000E-04  -1.88460000E-04  -1.55100000E-04  +1.41100000E-05  -1.77680000E-04
   +1.47330000E-04  +2.55320000E-04  +3.26700000E-05  -1.24730000E-04  +1.97700000E-05
   +2.61000000E-05  +1.46200000E-05  +1.55800000E-05  -1.74500000E-05  +4.37000000E-06
   +3.34000000E-06  -1.88600000E-05  +2.46400000E-05  -3.78600000E-05  -3.18200000E-05
   +2.03900000E-05  +2.64000000E-05  -1.31300000E-05  -1.76000000E-06  +6.57000000E-06
   +2.96660000E-04  +1.67120000E-04  -4.63670000E-04  +2.45180000E-04  +1.98390000E-04
   -1.13600000E-05  +2.18000000E-05  -1.02240000E-04  +5.82400000E-05  -1.18508000E-03
   +4.45430000E-04  -2.40500000E-04  +2.73769200E-01  +5.74900000E-05  +1.11920000E-04
   -8.80500000E-05  -2.14128000E-03  -3.93500000E-04  +4.22360000E-04  +2.57200000E-04
   +4.75000000E-06  -2.72410000E-04  +3.40210000E-04  +1.09080000E-04  +1.75690000E-04
   -6.26900000E-05  -3.05270000E-04  -2.38820000E-04  -6.13700000E-05  +5.44000000E-05
   +6.08300000E-05  -1.71521900E-02  -1.16513800E-02  -2.57460000E-04  -1.14208720E-01
   -1.12283290E-01  -3.64850000E-04  -6.11100000E-05  +1.82830000E-04  +4.59600000E-05
   -4.66000000E-06  -1.80302000E-03  -3.72975000E-03  -1.05430000E-04  -7.38110000E-04
   +3.97430000E-04  -4.84880000E-04  -6.58600000E-05  +4.39300000E-05  +1.60380000E-04
   +2.07300000E-04  -3.18480000E-04  +1.33850000E-04  +5.05500000E-05  -6.78200000E-05
   -2.32980000E-04  -9.04100000E-05  -3.05860000E-04  -3.08880000E-04  -2.43730000E-04
   +3.95600000E-05  +3.95500000E-04  +8.23000000E-05  +1.08894000E-03  -1.86350000E-04
   +2.75030000E-04  +2.22510000E-04  +3.68200000E-05  +3.06200000E-05  +2.20300000E-05
   -1.24770000E-04  -9.09000000E-06  +2.01800000E-05  +6.46000000E-05  -2.85900000E-05
   -9.74500000E-05  -3.13000000E-05  +2.62270000E-04  -7.28000000E-06  -1.53400000E-05
   -2.86600000E-05  +1.47600000E-05  +4.22700000E-05  +5.98030000E-04  +4.98700000E-05
   +1.72790000E-04  -7.59000000E-06  +2.83300000E-05  +8.41200000E-05  +5.95900000E-05
   +2.01000000E-05  -1.30321300E-02  -7.76651000E-03  -1.07298000E-03  +1.26873420E-01
   +1.21169450E-01  -2.12900000E-05  +2.61820000E-04  -1.57110000E-04  -1.06729000E-03
   -3.79820000E-04  +1.43087000E-03  -2.25720000E-04  -2.36800000E-05  +1.80970000E-04
   +1.03400000E-04  -9.03300000E-05  -1.27010000E-04  -9.10700000E-05  -1.54410000E-04
   +8.06200000E-05  +5.88000000E-06  +6.77100000E-05  +2.32600000E-05  -2.23289200E-02
   -1.27203700E-02  -1.64710000E-03  -4.88080000E-04  +1.09053000E-03  -4.87561200E-02
   -6.02000000E-06  +1.08710000E-04  -2.64300000E-05  +8.96180000E-04  -2.14984000E-03
   -4.07243000E-03  -6.18590000E-04  -8.03800000E-04  +2.78450000E-04  -3.17410000E-04
   +2.00180000E-04  +1.22540000E-04  +2.44280000E-04  +1.39320000E-04  -4.45600000E-05
   -3.43530000E-04  +1.76600000E-05  +1.18270000E-04  +4.96000000E-06  +5.63230000E-04
   -2.01260000E-04  -2.61220000E-04  -2.71890000E-04  +3.16200000E-05  -1.13296000E-03
   -9.43770000E-04  +1.10305000E-03  -1.34870000E-04  +4.92100000E-04  -9.67200000E-05
   +3.32400000E-05  +8.97000000E-06  +2.31800000E-05  -9.13900000E-05  -4.20200000E-05
   -4.70000000E-07  +9.38800000E-05  -1.43920000E-04  -6.45300000E-05  +2.74240000E-04
   -3.70220000E-04  +2.01400000E-04  -3.39600000E-05  -7.55000000E-06  +1.55400000E-05
   +1.21970000E-04  +4.05270000E-04  -9.53560000E-04  +3.29450000E-04  +1.73760000E-04
   +2.14600000E-04  +8.97700000E-05  -5.40700000E-05  -6.70000000E-05  +2.49345600E-02
   +1.27288900E-02  +1.53358000E-03  +1.78798000E-03  +3.18468000E-03  +5.25791900E-02
   +1.35300000E-04  -4.20200000E-05  -1.73480000E-04  +2.55930000E-04  -6.68530000E-04
   -3.65010000E-04  +8.19300000E-05  +1.01480000E-04  -2.56610000E-04  +3.09800000E-04
   +1.59200000E-05  +3.28300000E-05  +2.20000000E-07  -2.37320000E-04  -1.72790000E-04
   +2.16900000E-05  +2.31000000E-06  +5.62700000E-05  +3.39740000E-04  -1.91160000E-03
   -2.42670000E-04  -1.98966890E-01  +1.33642190E-01  -1.61593600E-02  -6.01700000E-05
   +1.17330000E-04  +2.52100000E-05  +7.38870000E-04  -2.81490000E-04  +2.97780000E-04
   +5.50400000E-05  +1.73590000E-04  -1.33710000E-04  +5.14000000E-05  +5.89500000E-05
   +7.75000000E-06  -8.07300000E-05  -6.55900000E-05  +5.96800000E-05  -7.46300000E-05
   +5.19700000E-05  +3.93500000E-05  +5.65100000E-05  +5.03700000E-05  +4.57400000E-05
   +1.12320000E-04  +6.77700000E-05  -1.39800000E-05  +4.50200000E-04  -2.86190000E-04
   -6.16910000E-04  -1.55610000E-04  +1.17950000E-04  +1.90820000E-04  -1.43800000E-05
   -8.51000000E-06  -8.34000000E-06  +1.77000000E-05  +1.57200000E-05  +3.61000000E-06
   +2.62800000E-05  -4.53000000E-06  +2.02400000E-05  +6.96400000E-05  -3.21000000E-05
   -1.11100000E-05  +0.00000000E+00  +8.15000000E-06  -7.60000000E-07  -3.92940000E-04
   +1.25010000E-04  +1.03320000E-04  +1.93450000E-04  -3.28890000E-04  -4.57400000E-05
   +3.49070000E-04  -9.46600000E-05  +2.54630000E-04  +3.18311000E-03  -3.81421000E-03
   +2.55800000E-04  -1.80467500E-02  +1.95146200E-02  -2.72453000E-03  +2.11490260E-01
   +1.10727000E-03  -3.70370000E-04  +4.16610000E-04  -1.34495000E-03  -1.79876000E-03
   -3.14583000E-03  +1.50940000E-04  +2.74300000E-05  -1.20660000E-04  -1.28180000E-04
   -2.39200000E-05  -8.44900000E-05  -1.46330000E-04  +1.43990000E-04  +1.12770000E-04
   -7.82500000E-05  -1.36690000E-04  -4.16640000E-04  +1.53662400E-02  -1.47562700E-02
   +1.31132000E-03  +1.32334340E-01  -1.64171540E-01  +1.45882700E-02  +1.17400000E-04
   -1.08770000E-04  -1.70100000E-05  +7.86190000E-04  +8.46980000E-04  +4.92100000E-04
   -3.50660000E-04  +1.77400000E-05  -8.74700000E-05  +1.25400000E-05  +2.35500000E-05
   -1.11060000E-04  -7.64600000E-05  -1.36270000E-04  +5.02100000E-05  -8.01000000E-05
   -3.55200000E-05  -6.65800000E-05  -2.34890000E-04  -2.05280000E-04  +4.82440000E-04
   +6.98800000E-05  +1.01790000E-04  -1.42100000E-05  +9.87200000E-05  +5.94000000E-04
   +1.75238000E-03  +1.26290000E-04  +1.09780000E-04  -1.36630000E-04  -1.27200000E-05
   -2.24400000E-05  -1.26000000E-05  +8.31000000E-06  -1.64100000E-05  -3.80000000E-06
   -1.09000000E-06  -7.81000000E-06  -1.75600000E-05  +8.51900000E-05  +8.73700000E-05
   -1.70820000E-04  +9.91000000E-06  -2.01200000E-05  -4.87000000E-06  -7.34900000E-05
   +8.24800000E-05  -1.27090000E-04  -3.64890000E-04  +6.38500000E-05  +2.35480000E-04
   -3.13440000E-04  +5.85380000E-04  -4.26670000E-04  +1.17895700E-02  -1.04833000E-02
   +7.67310000E-04  -1.21643300E-02  +1.24724100E-02  -1.65764000E-03  -1.46475940E-01
   +1.76997890E-01  +1.55623000E-03  -7.91600000E-04  +4.45570000E-04  -1.73314000E-03
   -2.55210000E-03  -5.13556000E-03  -1.18360000E-04  +1.28260000E-04  -6.91050000E-04
   -9.57500000E-05  +2.37010000E-04  +6.31480000E-04  -6.57400000E-05  +1.15590000E-04
   -2.64420000E-04  -9.23200000E-05  -2.10160000E-04  -4.81820000E-04  +1.98582000E-02
   -1.80945400E-02  -2.45740000E-04  -1.81503100E-02  +1.66568700E-02  -4.78738400E-02
   -1.38000000E-05  +2.53800000E-05  +7.79000000E-05  +6.77100000E-04  +9.34290000E-04
   +6.75720000E-04  -1.19450000E-04  +1.14460000E-04  +5.29500000E-05  -1.03700000E-05
   -4.01100000E-05  -6.36400000E-05  -4.82200000E-05  -2.58600000E-05  -7.35600000E-05
   +2.51060000E-04  -5.55600000E-05  +1.33100000E-04  -2.42100000E-04  +1.14700000E-04
   -1.95100000E-04  +9.19700000E-05  +7.73600000E-05  +9.14000000E-06  +1.22483000E-03
   -1.21004000E-03  +5.61330000E-04  +1.08000000E-06  -4.36900000E-05  +7.72100000E-05
   -1.24700000E-05  +1.28000000E-06  +5.30000000E-07  +7.04000000E-06  -9.43000000E-06
   +4.86000000E-06  -3.66100000E-05  -2.36100000E-05  -3.35500000E-05  -1.01640000E-04
   -4.97000000E-06  +1.13360000E-04  -1.32900000E-05  +5.74000000E-06  -5.67000000E-06
   +1.32670000E-04  +1.57200000E-04  +7.23400000E-05  -1.04190000E-04  +1.67700000E-04
   +3.63790000E-04  -3.95870000E-04  -9.56900000E-05  -8.80930000E-04  -2.19193600E-02
   +1.79976500E-02  -1.60986000E-03  +3.53440000E-04  +5.45400000E-05  -1.15899000E-03
   +1.88830200E-02  -1.35027400E-02  +5.48461500E-02  +6.26700000E-05  +2.25407000E-03
   -2.30347000E-03  +4.90864000E-03  -6.30849000E-03  -1.45606700E-02  -5.88264500E-02
   +3.95953700E-02  +6.09475900E-02  -6.56648000E-03  +1.16917100E-02  +2.49872700E-02
   +1.27062000E-03  +7.07219000E-03  -1.73009000E-03  -3.16010000E-04  -6.08620000E-04
   +9.31200000E-05  -4.61190000E-04  -1.42158000E-03  +4.20760000E-04  -6.69590000E-04
   +1.29584000E-03  -8.43880000E-04  -1.78669000E-03  +9.30370000E-04  +1.23919000E-03
   -1.89900000E-04  +3.16640000E-04  -4.68400000E-05  -1.20060000E-04  -6.94300000E-05
   +2.97100000E-05  +9.80300000E-05  +5.27200000E-05  +1.84900000E-05  -7.77500000E-05
   -9.26900000E-05  +3.60000000E-07  +6.54200000E-05  -1.08040000E-04  +1.67950000E-04
   -2.96520000E-04  +4.95500000E-05  -2.84420000E-04  +1.30180000E-04  +1.04710000E-04
   +3.01000000E-05  +2.58280000E-04  +5.90500000E-05  +9.82900000E-05  +2.10297000E-03
   +7.79640000E-04  -2.92279000E-03  -1.97300000E-05  -1.30400000E-05  -4.13000000E-06
   +1.34200000E-05  -1.25000000E-06  +7.89000000E-06  +2.19300000E-05  -1.58300000E-05
   +3.56000000E-05  -1.42931000E-03  -4.70400000E-04  +2.80900000E-05  -9.24000000E-06
   -1.49000000E-06  -8.63000000E-06  +1.30700000E-05  -2.03600000E-05  -9.94000000E-06
   +3.44100000E-05  -4.17500000E-05  +1.36230000E-04  -3.14100000E-05  -2.13000000E-05
   +6.09600000E-05  -1.74018000E-03  +2.17638000E-03  +2.76270000E-04  +6.31000000E-06
   -2.29770000E-04  +2.26950000E-04  -2.11830000E-04  -2.78810000E-04  +1.37480000E-04
   +6.57020000E-02  +2.43342000E-03  +9.06850000E-04  +1.21896000E-03  -3.29898000E-03
   +7.41210000E-03  +7.47295000E-03  +4.43897000E-02  -9.86305700E-02  -1.11431520E-01
   +4.37007000E-03  -5.01699000E-03  -2.09092800E-02  +2.45722000E-03  +3.95865000E-03
   +5.92414000E-03  +5.92890000E-04  -7.18160000E-04  +4.52020000E-04  -8.42440000E-04
   -7.34910000E-04  -4.53000000E-06  +1.57068000E-03  -1.11184000E-03  +6.54840000E-04
   +6.01400000E-05  -8.20460000E-04  -3.71500000E-04  +6.08600000E-05  +2.64040000E-04
   -4.35300000E-05  -1.02410000E-04  -9.77500000E-05  +9.55900000E-05  +4.63000000E-05
   -7.12000000E-06  +5.56500000E-05  -7.03300000E-05  +1.04400000E-05  -3.01600000E-05
   +7.12300000E-05  -1.17690000E-04  +1.48400000E-04  -1.08300000E-05  -1.76860000E-04
   -4.22280000E-04  +4.26400000E-05  +1.85200000E-05  +3.84400000E-05  -9.00000000E-07
   -1.81460000E-04  -1.48640000E-04  +2.60102000E-03  +3.15473000E-03  -3.86286000E-03
   -1.00200000E-05  -3.39000000E-06  +2.02000000E-06  -2.04000000E-06  -6.37000000E-06
   +7.50000000E-06  +3.20100000E-05  +1.38400000E-05  +3.60900000E-05  -6.30450000E-04
   +1.38570000E-04  +1.41400000E-04  -2.92700000E-05  -2.32600000E-05  -8.60000000E-06
   -1.67100000E-05  -3.69900000E-05  +4.58400000E-05  -2.12200000E-05  +3.52200000E-05
   -9.14600000E-05  -2.12400000E-05  +7.33000000E-06  +5.19600000E-05  +1.84588000E-03
   -1.30143000E-03  +1.54450000E-04  +4.07700000E-05  -4.88570000E-04  +8.11300000E-05
   -3.87100000E-05  +7.69400000E-05  +8.37200000E-05  -5.24291400E-02  +9.71996800E-02
   -2.76541000E-03  +2.46071000E-03  -1.83401000E-03  +6.01527000E-03  -1.24141000E-02
   -1.89375700E-02  +6.17504700E-02  -1.06911890E-01  -2.78311860E-01  -2.48650000E-04
   +5.44060000E-04  +3.49258000E-03  -1.72545000E-03  -1.09558000E-03  +2.87760000E-04
   -2.06070000E-04  +2.71580000E-04  +4.25830000E-04  +1.19738000E-03  -9.07500000E-04
   -4.74520000E-04  +9.76140000E-04  -5.24340000E-04  -1.58980000E-04  +3.04210000E-04
   -1.96700000E-05  -5.27900000E-05  -1.00000000E-06  +8.75400000E-05  +9.22800000E-05
   -5.84700000E-05  +5.05200000E-05  +7.98000000E-05  +6.60900000E-05  +1.72600000E-05
   +3.82500000E-05  -4.67700000E-05  +1.75300000E-05  -2.14100000E-05  +6.75700000E-05
   -6.62800000E-05  +2.45990000E-04  +7.36800000E-05  +6.73000000E-05  -6.49320000E-04
   +7.32900000E-05  +4.76000000E-05  +3.25800000E-05  -6.26500000E-05  +6.20200000E-05
   +1.26670000E-04  -4.00350000E-04  -1.53060000E-04  +1.34632000E-03  +1.60000000E-07
   -1.07700000E-05  -3.95000000E-06  +1.94800000E-05  -9.15000000E-06  +1.02000000E-06
   +2.90300000E-05  -1.63800000E-05  +3.23000000E-05  +5.21000000E-06  -1.02640000E-04
   +4.87550000E-04  +5.77000000E-06  -1.26100000E-05  -1.21600000E-05  +1.34800000E-05
   -5.40000000E-06  -2.68400000E-05  +2.32100000E-05  -4.64300000E-05  +1.30880000E-04
   -6.63500000E-05  +7.60600000E-05  -4.77000000E-06  +2.32120000E-04  -7.61700000E-04
   +1.27038000E-03  -1.14500000E-05  +3.71120000E-04  -2.04550000E-04  +2.39020000E-04
   -1.92910000E-04  +5.97360000E-04  -6.66142700E-02  +1.18901600E-01  +2.92180910E-01
   -7.87000000E-05  -9.22790000E-04  -5.73320000E-04  -2.41850000E-04  +8.95808000E-03
   +1.36000000E-04  -2.15459000E-03  +5.57678000E-03  -2.08396800E-02  -1.40672150E-01
   +4.37218700E-02  -1.28034950E-01  +6.83681000E-03  +5.14450000E-04  +1.45144500E-02
   -2.23127000E-03  +7.99890000E-04  +1.18588000E-03  -2.40180000E-04  -6.37440000E-04
   -7.03990000E-04  +9.22700000E-05  -1.21090000E-04  -8.15000000E-05  +4.68760000E-04
   -1.15089000E-03  -8.37080000E-04  -6.64400000E-05  +1.01380000E-04  -3.95700000E-05
   -4.85300000E-05  -5.70100000E-05  -4.21000000E-06  +1.06000000E-06  -1.95500000E-05
   +4.16000000E-06  +1.02900000E-05  +1.43200000E-05  -3.31000000E-06  -1.81500000E-05
   -2.22200000E-05  -1.55800000E-05  -1.95300000E-05  -3.41000000E-05  -2.95800000E-05
   -2.46000000E-05  -2.44700000E-05  +6.03000000E-06  -2.45480000E-04  +1.62800000E-05
   -5.38500000E-05  +1.94699000E-03  +2.01567000E-03  -3.48477000E-03  +6.90000000E-07
   +1.97000000E-06  +8.60000000E-07  -4.54000000E-06  -5.21000000E-06  +1.40000000E-07
   -1.34000000E-06  +1.76600000E-05  +1.30400000E-05  +3.42400000E-05  +2.94800000E-05
   -1.21200000E-05  -1.65000000E-05  -2.95000000E-06  +3.96000000E-06  +1.14700000E-05
   -1.45400000E-05  +1.89100000E-05  +2.22000000E-06  +3.39000000E-06  -6.60000000E-06
   -3.38200000E-05  +4.06000000E-05  -5.33200000E-05  -3.81000000E-06  +3.56000000E-06
   +1.63200000E-05  +1.48700000E-05  +3.70000000E-07  -6.37000000E-06  +2.26000000E-06
   +2.29600000E-05  +2.02700000E-05  -1.97449000E-03  -2.96572000E-03  +9.10860000E-04
   +1.38002680E-01  -5.40220000E-04  -7.28430000E-04  -1.15992000E-03  +7.44210000E-03
   +5.50790000E-03  -2.22445000E-03  +1.49784200E-02  +2.06077000E-03  +1.50273700E-02
   +4.26340300E-02  -6.21227300E-02  +5.25847400E-02  -6.61947000E-03  +5.64855000E-03
   -3.47355000E-03  -1.65200000E-04  -2.42110000E-04  -1.87616000E-03  -6.70990000E-04
   -1.27619000E-03  +1.44510000E-03  +7.35700000E-05  -5.87000000E-06  +4.34000000E-06
   -1.12061000E-03  +5.85230000E-04  +1.45752000E-03  -4.35480000E-04  -3.81000000E-06
   -9.07600000E-05  -2.12300000E-05  +2.07000000E-06  +1.71600000E-05  -9.17000000E-06
   -1.89800000E-05  -6.60000000E-07  -2.63000000E-06  +4.90000000E-06  -1.34900000E-05
   -2.84000000E-06  +3.68000000E-06  -4.30100000E-05  -1.20500000E-05  +1.29800000E-05
   +4.23800000E-05  -2.22000000E-06  -5.82000000E-06  -2.26000000E-06  +4.04680000E-04
   -2.19330000E-04  -3.02840000E-04  +3.03474000E-03  +1.45415000E-03  -1.22047000E-03
   -1.72000000E-06  +1.04000000E-06  +6.00000000E-08  +3.06000000E-06  -3.70000000E-06
   -8.40000000E-07  -1.06400000E-05  +1.47000000E-06  +6.10000000E-07  +4.76700000E-05
   +1.37000000E-06  -1.83300000E-05  -1.47000000E-06  +9.54000000E-06  +5.49000000E-06
   +4.00000000E-06  -3.10200000E-05  +2.20600000E-05  -5.47000000E-06  +3.18600000E-05
   +2.18200000E-05  -2.17000000E-05  -1.24670000E-04  +1.50560000E-04  +1.53400000E-05
   -2.34000000E-06  -3.67000000E-05  +1.28100000E-05  -2.81700000E-05  -1.20300000E-05
   +1.37000000E-06  -1.30500000E-05  -2.22100000E-05  -3.92623000E-03  -3.25953000E-03
   +9.15840000E-04  -5.52740600E-02  +5.23257900E-02  -2.95440000E-04  +5.70200000E-04
   +1.08120000E-03  -1.06500000E-04  -2.94000000E-03  -5.07270000E-04  +4.30601000E-03
   -4.76764000E-03  +7.39513000E-03  -1.27140720E-01  +6.18631200E-02  -2.45102130E-01
   -2.00761900E-02  +5.83991000E-03  -1.90592100E-02  +4.09412000E-03  -1.63206000E-03
   -2.96328000E-03  +3.26290000E-04  +1.90760000E-04  +1.11100000E-05  -9.36000000E-05
   +3.97600000E-05  +3.59500000E-05  +3.90500000E-04  +3.33940000E-04  +3.70556000E-03
   +4.88100000E-05  +1.65100000E-05  +4.34100000E-05  +6.29000000E-06  +2.16700000E-05
   +1.93500000E-05  +8.39000000E-06  +8.63000000E-06  +1.79000000E-05  +3.81000000E-05
   +2.03200000E-05  +3.59000000E-06  -1.38500000E-05  -2.40300000E-05  -9.04000000E-06
   +1.68600000E-05  +2.37500000E-05  -3.23100000E-05  -3.76400000E-05  -3.13400000E-05
   +4.00000000E-06  -2.56300000E-05  -1.98000000E-06  +4.57900000E-05  +1.49090000E-03
   -3.90120000E-04  +4.20014000E-03  +5.68000000E-06  +5.13000000E-06  +1.27000000E-06
   -1.24000000E-06  -4.80000000E-07  -1.63000000E-06  +1.27500000E-05  -1.25200000E-05
   +3.36000000E-06  -5.20000000E-06  +2.09200000E-05  +2.31600000E-05  -5.56000000E-06
   +0.00000000E+00  +3.91000000E-06  -1.41000000E-06  +1.37000000E-05  -5.40000000E-07
   +9.50000000E-06  -1.95000000E-05  +2.48900000E-05  +1.50000000E-05  +2.05600000E-05
   +4.20000000E-07  +6.06000000E-06  +1.36100000E-05  -7.83000000E-06  -6.06000000E-06
   +5.11000000E-06  +4.76000000E-06  +9.20000000E-07  +1.22000000E-05  -1.60000000E-06
   +3.78640000E-04  +1.11786000E-03  +6.97070000E-04  +1.37696920E-01  -6.00463900E-02
   +2.51162850E-01  +4.17527000E-03  +1.57759100E-02  +1.92695800E-02  -1.44752000E-03
   +7.93363000E-03  -2.86134000E-03  -1.37690000E-04  -5.80700000E-04  +2.62170000E-04
   -3.66772000E-03  +1.64983000E-03  -1.81102000E-03  +9.39344000E-03  -9.57199000E-03
   -2.14477100E-02  -6.12219700E-02  +2.84209100E-02  +3.15014400E-02  +2.45110000E-04
   -4.15100000E-05  +1.14703000E-03  -3.79610000E-04  +1.48230000E-04  -1.98400000E-05
   +1.29435000E-03  -6.57760000E-04  +1.96257000E-03  -1.05210000E-04  +6.40600000E-05
   +4.03300000E-05  -2.12100000E-05  -3.82000000E-06  +8.31500000E-05  +1.18800000E-05
   -2.44300000E-05  -9.25000000E-06  +5.11700000E-05  +2.77200000E-05  +4.33100000E-05
   -5.54600000E-05  -5.55600000E-05  -4.11600000E-05  +1.96000000E-05  +2.66200000E-05
   -5.89400000E-05  -6.29900000E-05  -6.19000000E-05  -8.23000000E-06  +1.01920000E-04
   -1.89190000E-04  +2.08300000E-04  -7.00790000E-04  +8.91400000E-05  +4.80902000E-03
   -5.56000000E-06  +9.44000000E-06  +1.26400000E-05  -2.08100000E-05  +2.93000000E-06
   -6.40000000E-07  +2.30000000E-07  +1.16200000E-05  -1.99000000E-06  -7.53000000E-06
   +2.03300000E-05  +6.98000000E-06  -8.14000000E-06  -2.20000000E-06  +3.01000000E-06
   +1.61600000E-05  -1.64800000E-05  -2.16700000E-05  +3.23600000E-05  -2.09600000E-05
   -8.18300000E-05  -2.54700000E-05  -5.40000000E-06  -3.75300000E-05  -9.62000000E-06
   -5.46000000E-06  +2.64000000E-05  +8.29000000E-06  -1.01700000E-05  -1.97300000E-05
   -1.38400000E-05  +7.63100000E-05  +1.15480000E-04  +1.57300000E-05  -1.20350000E-04
   +4.89000000E-05  +9.35880000E-04  +1.47140000E-04  -1.17899000E-03  +5.29579500E-02
   +4.77679000E-03  -3.11624000E-03  -1.70777900E-02  +6.45117000E-03  +5.48104000E-03
   -2.14512000E-03  -6.25230000E-04  -2.36200000E-04  +3.02460000E-04  -3.89800000E-04
   +1.05228000E-03  +7.89420000E-04  +2.45448000E-03  +2.30708000E-03  -4.40905000E-03
   +2.95375800E-02  -1.43645290E-01  -1.38150760E-01  -6.82330000E-04  -1.04836000E-03
   -5.87610000E-04  +2.27750000E-04  -1.67530000E-04  +2.06130000E-04  -6.74750000E-04
   +6.08040000E-04  +6.57360000E-04  -5.67730000E-04  -2.57000000E-06  +1.14170000E-04
   -4.67100000E-05  +7.04300000E-05  +9.20700000E-05  +3.73400000E-05  +1.65500000E-05
   +1.11000000E-05  +4.94000000E-05  +1.44900000E-05  +4.07500000E-05  -5.62600000E-05
   -5.80900000E-05  -5.03100000E-05  +3.73400000E-05  +8.85900000E-05  -4.91700000E-05
   -4.14500000E-05  -3.72600000E-05  -5.00000000E-08  +1.43510000E-04  -1.11460000E-04
   +1.25740000E-04  +1.02023000E-03  +5.55370000E-04  +3.89917000E-03  +1.16000000E-06
   +4.70000000E-06  +3.24000000E-06  +5.33000000E-06  +1.30000000E-06  -2.83000000E-06
   +7.41000000E-06  -2.84500000E-05  -5.09000000E-06  -8.06000000E-06  +4.08000000E-06
   +1.33200000E-05  -2.53000000E-06  +2.38000000E-06  +3.42000000E-06  +1.47300000E-05
   -3.26000000E-05  -1.38400000E-05  +3.95700000E-05  -4.98200000E-05  -4.77900000E-05
   -1.61100000E-05  -5.45100000E-05  +6.22000000E-06  -1.42900000E-05  -9.80000000E-07
   -8.39000000E-06  -1.27000000E-06  +1.59000000E-06  -1.03800000E-05  -1.13000000E-05
   -7.89800000E-05  -8.51700000E-05  -7.90600000E-05  -1.07230000E-04  -1.28620000E-04
   +6.28360000E-04  +6.73340000E-04  -2.58980000E-04  -3.94780200E-02  +1.40945870E-01
   -6.02764000E-03  +1.26919000E-03  +5.23555000E-03  -2.49141000E-03  -3.82567000E-03
   +1.28628000E-03  +1.05778000E-03  +1.47940000E-04  +6.41290000E-04  -3.40968000E-03
   +5.90690000E-04  -1.61965000E-03  +9.75397000E-03  -1.16143100E-02  -9.78147000E-03
   +3.43776800E-02  -1.42140090E-01  -2.42123890E-01  -1.11700000E-05  +5.24400000E-04
   -1.19410000E-04  +5.35100000E-05  +4.69300000E-05  -5.37700000E-05  +1.06989000E-03
   +5.98910000E-04  +2.28588000E-03  +2.25420000E-04  -2.08300000E-05  -1.33700000E-05
   +3.02800000E-05  -2.90600000E-05  -6.27100000E-05  +1.94000000E-06  +1.93100000E-05
   -2.49000000E-06  -5.19700000E-05  -3.92600000E-05  -1.28500000E-05  +3.70600000E-05
   +3.62800000E-05  +4.04000000E-05  -1.14400000E-05  -3.15900000E-05  +1.45000000E-06
   +6.28600000E-05  +6.35600000E-05  +2.87000000E-06  -6.27000000E-05  +7.94700000E-05
   -1.14930000E-04  -2.93195000E-03  -1.33918000E-03  -6.95270000E-04  -3.30000000E-07
   -1.09400000E-05  -5.95000000E-06  +7.21000000E-06  +2.90000000E-07  +3.30000000E-06
   -7.77000000E-06  +9.89000000E-06  +1.56000000E-06  -1.00900000E-05  -7.35000000E-06
   +1.85000000E-05  +6.49000000E-06  -3.84000000E-06  -8.29000000E-06  -1.04000000E-05
   +1.61800000E-05  +4.63000000E-06  -1.46900000E-05  +2.88200000E-05  +5.11700000E-05
   +1.68100000E-05  +1.17500000E-05  +2.43100000E-05  -9.92000000E-06  -2.43000000E-06
   +7.10000000E-06  -3.93000000E-06  +2.03300000E-05  +8.66000000E-06  +1.19500000E-05
   +4.88000000E-06  +5.07000000E-06  +1.72390000E-04  +2.76900000E-05  +5.29500000E-05
   -4.76800000E-05  -7.43780000E-04  -6.82950000E-04  -3.38954900E-02  +1.53734370E-01
   +2.46158820E-01  -1.79682740E-01  +1.96774100E-02  -1.50551510E-01  +5.28363000E-03
   +1.33065000E-03  +4.99642000E-03  +4.60560000E-04  +1.03176000E-03  +7.33090000E-04
   -6.38700000E-05  -3.19010000E-04  +1.69330000E-04  +2.66935000E-03  +6.83326000E-03
   -6.99640000E-04  -1.48384100E-02  +1.49442000E-03  -2.08663100E-02  -7.71000000E-04
   -2.14660000E-04  +1.11790000E-04  +6.03700000E-05  -1.82860000E-04  +1.12300000E-04
   -2.02889000E-03  +4.84420000E-04  -6.22750000E-04  -5.01340000E-04  +6.36030000E-04
   +6.58290000E-04  -3.98560000E-04  +6.86000000E-06  +4.31940000E-04  -1.01860000E-04
   -1.12760000E-04  -1.11310000E-04  -1.25860000E-04  -8.59400000E-05  +5.21000000E-06
   -1.00000000E-08  -1.46800000E-05  -3.91800000E-05  +5.10000000E-07  +9.19800000E-05
   -9.58300000E-05  +1.10130000E-04  +1.01700000E-04  -1.82500000E-05  -4.27520000E-04
   +7.02090000E-04  -3.72990000E-04  +1.44297000E-03  +1.92250000E-04  +1.98551000E-03
   -2.94600000E-05  -2.12800000E-05  -1.80000000E-06  +1.71000000E-05  -1.17800000E-05
   +3.69000000E-06  -1.34990000E-04  +3.12850000E-04  -8.05400000E-05  -2.81000000E-06
   +1.24900000E-05  -2.23500000E-05  -2.60000000E-07  -3.39000000E-06  -6.64000000E-06
   -1.42000000E-06  -1.14900000E-05  +3.90800000E-05  +2.59550000E-04  +9.51170000E-04
   +3.83240000E-04  -5.36800000E-05  +9.60900000E-05  +2.78850000E-04  +2.72000000E-06
   -3.70000000E-06  +3.40300000E-05  -1.02100000E-05  -2.76900000E-05  -3.81200000E-05
   +4.15800000E-05  -5.03200000E-05  -4.53300000E-05  +2.10660000E-04  +9.06800000E-05
   +2.33920000E-04  +2.70000000E-06  -3.87600000E-05  -1.49960000E-04  -1.38450000E-03
   -3.15592000E-03  +2.36087000E-03  +1.90582660E-01  +2.20508200E-02  -4.92476800E-02
   +5.44269000E-03  -1.23480100E-02  +5.72212000E-03  -1.14618000E-02  +1.17240000E-03
   -6.68590000E-04  -2.71449000E-03  +1.00932000E-03  -7.55630000E-04  -5.14740000E-04
   +2.34209000E-03  +2.22369000E-03  -8.64823000E-03  +1.56532700E-02  +3.55184000E-03
   +1.70035800E-02  -5.20270000E-04  -4.56300000E-05  +1.86950000E-04  -8.44700000E-05
   -1.36190000E-04  +1.47480000E-04  +2.15460000E-04  -4.55500000E-04  +7.17970000E-04
   +2.86870000E-04  -5.18700000E-05  -1.54470000E-04  +1.44710000E-04  +7.71500000E-05
   -3.14230000E-04  -2.13000000E-06  -9.34700000E-05  +5.14800000E-05  -1.10100000E-05
   -2.66400000E-05  +8.88600000E-05  -8.53700000E-05  -7.37400000E-05  +3.72200000E-05
   +1.13000000E-05  -1.90300000E-05  -7.56900000E-05  -1.85800000E-05  -5.45700000E-05
   -1.30000000E-07  +4.57490000E-04  -1.10319000E-03  -6.87830000E-04  +2.35785000E-03
   +2.50400000E-03  +3.45332000E-03  -1.56500000E-05  +1.82800000E-05  +1.00500000E-05
   -3.96900000E-05  +2.19200000E-05  -1.62000000E-06  +1.94300000E-04  -2.40600000E-05
   +1.04940000E-04  -2.47400000E-05  +6.70000000E-07  +1.90300000E-05  -1.41400000E-05
   -4.01000000E-06  +4.00000000E-06  -7.04300000E-05  +1.76250000E-04  +1.01070000E-04
   +8.31840000E-04  -2.58886000E-03  +4.32090000E-04  -3.17900000E-05  +2.40750000E-04
   +2.42220000E-04  -1.88600000E-05  +4.61800000E-05  +1.48710000E-04  -7.12000000E-06
   +1.90300000E-05  -2.12200000E-05  +2.52400000E-05  -1.10000000E-05  -5.79000000E-06
   -1.50410000E-04  +8.23870000E-04  -7.98300000E-04  -3.50500000E-05  -9.84000000E-06
   -1.38900000E-05  -3.33129000E-03  -3.47388000E-03  +2.29195000E-03  -2.94220100E-02
   +4.50040400E-02  -1.50424920E-01  +6.66876000E-03  -2.05141230E-01  -1.59651100E-02
   +2.48860000E-03  -1.71610200E-02  +1.32107000E-03  -3.54786000E-03  -1.73978000E-03
   +5.91710000E-04  +2.13500000E-04  +4.73890000E-04  -3.82560000E-04  -3.69002000E-03
   +3.77885000E-03  +3.48989000E-03  -1.48731000E-03  +6.67001000E-03  -7.00030000E-04
   +9.31600000E-04  -2.54810000E-04  +1.27610000E-04  +3.05900000E-05  +4.45200000E-05
   +6.63780000E-04  +1.52800000E-05  +5.94600000E-05  -5.39000000E-06  -1.65110000E-04
   +1.54680000E-04  -1.51600000E-04  -1.79300000E-05  +1.70900000E-04  +2.49350000E-04
   +3.53320000E-04  -1.76000000E-06  +3.60060000E-04  +7.77200000E-05  +3.13760000E-04
   -3.10450000E-04  -2.25780000E-04  -1.05480000E-04  +1.59190000E-04  +4.59090000E-04
   -4.19740000E-04  -2.61830000E-04  -1.97670000E-04  -3.55000000E-06  -6.36500000E-05
   +3.15360000E-04  -2.12330000E-04  -1.43301000E-03  -9.89740000E-04  -1.24637000E-03
   +4.74900000E-05  +2.57300000E-05  +1.46200000E-05  -2.40300000E-05  -7.95000000E-06
   -1.30500000E-05  +1.10860000E-04  -7.96800000E-05  +7.62000000E-05  -2.19100000E-05
   -2.15200000E-05  +7.27100000E-05  -1.37200000E-05  -1.34700000E-05  +1.34000000E-06
   -4.26100000E-05  +2.38060000E-04  +1.33530000E-04  -2.08170000E-04  +4.05420000E-04
   +1.01094000E-03  +2.27000000E-06  +6.68600000E-05  +2.43700000E-04  -6.42300000E-05
   +7.72000000E-06  +6.51200000E-05  +7.83000000E-06  +1.04450000E-04  +3.65000000E-05
   +7.39000000E-05  -7.10100000E-05  +2.82700000E-05  -6.20500000E-04  +3.33120000E-04
   -8.68170000E-04  -7.69200000E-05  +9.53800000E-05  +1.15030000E-04  +1.83844000E-03
   +2.86808000E-03  -7.51790000E-04  +1.61545330E-01  -5.11221000E-03  +2.14387460E-01
   +3.10860000E-04  -3.11120000E-04  -8.32090000E-04  -2.88900000E-04  +4.48350000E-04
   -3.64940000E-04  +9.85200000E-04  -3.20480000E-04  +3.81470000E-04  -1.33028000E-03
   +2.19780000E-04  -1.72980000E-04  -3.06997600E-02  +2.43953000E-03  -1.62690000E-04
   -1.64184000E-03  +2.10056000E-03  +7.95170000E-04  -4.72000000E-06  +1.13480000E-04
   +3.61800000E-05  +3.40400000E-05  -1.75500000E-05  +6.84000000E-06  -4.86292550E-01
   -1.02454450E-01  +1.79977700E-02  +6.43400000E-05  -1.07900000E-04  +7.84000000E-06
   -2.59300000E-05  -3.33200000E-05  -6.84300000E-05  +4.22100000E-05  +6.02100000E-05
   -4.74900000E-05  -1.32160000E-04  -1.10360000E-04  +3.72500000E-05  +3.01200000E-05
   -6.37000000E-06  +4.00100000E-05  +2.72700000E-05  -3.58900000E-05  +8.27000000E-06
   +1.56560000E-04  +1.15300000E-04  -9.10000000E-06  +2.52700000E-05  -3.80300000E-05
   -2.00300000E-05  +2.61554000E-03  -7.11709000E-03  +4.76510000E-04  -2.97900000E-05
   -1.37900000E-05  -6.55000000E-06  +9.52000000E-06  +1.17300000E-05  +8.97000000E-06
   -1.16300000E-05  -2.80000000E-06  -2.80000000E-06  -2.08500000E-05  +3.10000000E-06
   +3.19300000E-05  -1.45000000E-06  +7.21000000E-06  -2.32000000E-06  -9.33000000E-06
   +2.48100000E-05  -4.00000000E-08  -1.30400000E-05  +1.16000000E-05  -1.21300000E-05
   +3.22700000E-05  -1.55900000E-05  +8.73000000E-06  -1.16700000E-05  +1.03500000E-05
   +7.21000000E-06  -1.07300000E-05  +2.90400000E-05  +1.59700000E-05  +2.42800000E-05
   -2.35100000E-05  -4.00000000E-08  +6.24800000E-05  -3.02000000E-06  -4.66100000E-05
   -6.63600000E-05  +1.29640000E-04  +2.34880000E-04  -1.07980000E-04  -4.55200000E-05
   -1.11000000E-06  -7.10500000E-05  +5.01500000E-05  +7.14900000E-05  +5.16865530E-01
   +6.89260000E-04  +3.29840000E-04  +8.53750000E-04  +5.79250000E-04  -5.96900000E-05
   +7.68810000E-04  -9.06720000E-04  +5.74210000E-04  -1.42781000E-03  +3.12059000E-03
   -3.09840000E-03  -7.58500000E-05  +4.89491900E-02  +2.11329000E-03  -2.25226000E-03
   +1.97612000E-03  -4.26927000E-03  -6.52200000E-05  -9.71000000E-05  -1.87000000E-04
   -3.24700000E-05  +1.23000000E-06  +1.07900000E-05  -2.36200000E-05  -1.53021920E-01
   -7.71309600E-02  +6.84467000E-03  -5.30000000E-05  +1.41580000E-04  -3.87300000E-05
   +2.89900000E-05  +2.37800000E-05  +7.13700000E-05  -5.27300000E-05  -8.70400000E-05
   +5.22300000E-05  +1.33610000E-04  +1.27550000E-04  -5.50700000E-05  -1.65900000E-05
   +2.10000000E-06  -3.49200000E-05  -3.79000000E-05  +1.54800000E-05  -1.63100000E-05
   -1.64260000E-04  -1.33140000E-04  +1.06900000E-05  -1.74400000E-05  +6.39500000E-05
   +4.23700000E-05  -7.25261000E-03  +6.68140000E-03  +9.55990000E-04  +2.57400000E-05
   +2.01200000E-05  +8.83000000E-06  -1.33200000E-05  -1.11800000E-05  -8.55000000E-06
   +1.06900000E-05  +1.45900000E-05  +7.00000000E-06  +1.43100000E-05  +4.15000000E-06
   -2.76500000E-05  -4.85000000E-06  -4.86000000E-06  +5.90000000E-06  +1.30900000E-05
   -5.05100000E-05  -1.79000000E-06  +1.62700000E-05  -1.87000000E-06  +5.32000000E-06
   -3.88800000E-05  +8.10000000E-06  -7.86000000E-06  +1.74000000E-06  -1.58000000E-05
   +1.16900000E-05  +1.35900000E-05  -3.92600000E-05  -2.85100000E-05  -2.59300000E-05
   +1.30800000E-05  +5.93000000E-06  +3.96230000E-04  +1.23110000E-04  -7.67400000E-05
   -5.29900000E-05  +2.14720000E-04  -2.29860000E-04  -1.27180000E-04  +1.14710000E-04
   +2.00000000E-05  +3.81400000E-04  +4.51400000E-05  -1.72770000E-04  +1.05279880E-01
   +7.58865800E-02  -1.19436000E-03  +2.52200000E-05  -5.90110000E-04  -2.81420000E-04
   -1.54570000E-04  -8.07280000E-04  +7.98470000E-04  -2.46640000E-04  -8.66680000E-04
   +9.92210000E-04  -3.05767000E-03  +1.15136000E-03  -2.02617000E-03  -3.85490000E-04
   -7.26190000E-04  -1.83704000E-03  +4.48425000E-03  -6.32500000E-04  -4.55000000E-06
   +2.15200000E-05  -2.48100000E-05  +3.27000000E-06  -1.55000000E-06  -5.23000000E-06
   +2.15299400E-02  +5.27468000E-03  +1.54761000E-03  -7.69000000E-06  +2.80000000E-07
   +1.59500000E-05  -1.00800000E-05  +3.36000000E-06  +5.83000000E-06  +1.36900000E-05
   +1.43500000E-05  -4.48000000E-06  +1.81200000E-05  +3.30000000E-07  +2.33000000E-05
   -1.53400000E-05  -1.61300000E-05  -6.13000000E-06  +2.09800000E-05  +2.20800000E-05
   -1.06700000E-05  -9.98000000E-06  -6.61000000E-06  -5.39000000E-06  -9.30000000E-06
   -1.00600000E-05  -5.17000000E-06  +6.69520000E-04  -6.79250000E-04  -1.73838000E-03
   +6.50000000E-07  +2.52000000E-06  +3.89000000E-06  -3.67000000E-06  +1.50000000E-06
   -5.80000000E-07  +3.47000000E-06  -4.59000000E-06  +2.00000000E-08  -7.01000000E-06
   -4.45000000E-06  +1.22400000E-05  +4.56000000E-06  +3.80000000E-07  -7.40000000E-07
   +3.90000000E-06  +1.13400000E-05  +1.02700000E-05  -1.39000000E-06  -1.56600000E-05
   +6.75000000E-06  +2.07000000E-06  +5.13000000E-06  +5.00000000E-07  +5.00000000E-08
   +3.76000000E-06  +4.29000000E-06  -9.80000000E-07  +4.08000000E-06  +9.59000000E-06
   +1.95000000E-06  -2.25000000E-06  +6.42000000E-06  +2.82540000E-04  -5.28500000E-05
   -3.87700000E-05  +2.79180000E-04  -2.35510000E-04  -6.04710000E-04  -1.73630000E-04
   -6.63100000E-05  +3.13400000E-05  -4.05360000E-04  -2.12700000E-05  +1.45260000E-04
   -1.85677600E-02  -5.12976000E-03  +3.23626000E-03  -4.14165000E-03  +5.68050000E-03
   +1.35550000E-03  -2.00569100E-02  -2.20315800E-02  +1.45852600E-02  -1.34215600E-02
   +1.04822200E-02  -5.68853000E-03  +1.24984300E-02  -2.07225000E-03  -6.88227000E-03
   +2.41500700E-02  -2.51047000E-03  -7.08948000E-03  +3.78616000E-03  -1.88521000E-03
   +1.63927000E-03  +6.04200000E-04  +7.69400000E-05  +1.38350000E-04  -3.06410000E-04
   -1.50270000E-04  -2.19590000E-04  -3.38239000E-03  -1.22883900E-02  +1.82068000E-03
   -4.38760000E-04  -1.48450000E-04  -1.84380000E-04  +2.25060000E-04  +2.36520000E-04
   +1.38630000E-04  -6.77000000E-05  -2.89700000E-05  -3.39500000E-05  -2.68340000E-04
   -1.63770000E-04  -1.59020000E-04  +2.00300000E-04  +2.43780000E-04  +6.32900000E-05
   -1.17610000E-04  +1.30130000E-04  +9.95800000E-05  +2.65470000E-04  +2.14440000E-04
   -1.47900000E-05  -2.38000000E-05  -5.96400000E-04  +4.90700000E-05  -2.58573500E-02
   -4.05641900E-02  +1.15322000E-02  -3.50200000E-05  -4.35800000E-05  -1.31100000E-05
   +3.62100000E-05  +7.59000000E-06  +1.27000000E-05  -7.24700000E-05  -5.58600000E-05
   -8.88000000E-05  +4.36900000E-05  -1.12930000E-04  -1.07830000E-04  +2.34700000E-05
   +2.25600000E-05  -6.59000000E-06  -4.96010000E-04  +9.86000000E-04  -1.57320000E-04
   -1.17640000E-04  -5.61800000E-05  -1.45500000E-05  +4.92560000E-04  +2.93760000E-04
   -1.08880000E-04  +1.99150000E-04  +7.75200000E-05  -1.95590000E-04  -1.45890000E-04
   +2.65960000E-04  +5.24830000E-04  +1.10170000E-04  +8.82500000E-05  +2.53000000E-05
   +4.48120000E-04  +1.12403000E-03  -2.91250000E-04  +7.19730000E-04  +6.52720000E-04
   -4.92010000E-04  +2.25300000E-05  +7.27200000E-05  -2.26890000E-04  +6.12200000E-05
   +7.38390000E-04  -1.13500000E-04  -1.32655000E-03  +2.18829000E-03  -3.82610000E-04
   +9.27354100E-02  +4.06357000E-03  -8.55142000E-03  -3.39362000E-03  +1.35201700E-02
   +3.67354900E-02  -1.67135700E-02  +1.56171700E-02  -1.28113400E-02  +8.27936000E-03
   -1.54111300E-02  +2.69230000E-04  +1.14285800E-02  -1.76589300E-02  -2.03959000E-02
   +9.24689000E-03  -6.30113000E-03  -3.81280000E-04  -3.86160000E-03  -2.85366000E-03
   -1.94034000E-03  +3.64600000E-05  +5.33820000E-04  -1.10630000E-04  -2.71200000E-05
   +2.94924000E-03  +1.20394000E-02  -1.27759000E-03  -1.96920000E-04  +7.53500000E-04
   +2.14650000E-04  -3.64470000E-04  -4.21180000E-04  -8.80300000E-05  +9.62700000E-05
   -1.16610000E-04  +1.47700000E-05  +2.48450000E-04  +1.95590000E-04  +1.67200000E-04
   -2.21200000E-04  -4.13520000E-04  -7.12400000E-05  +1.46310000E-04  -2.18890000E-04
   -2.92660000E-04  -2.97530000E-04  -2.45970000E-04  +2.89800000E-05  -5.00500000E-04
   +6.38270000E-04  +4.90270000E-04  -1.72701200E-02  +4.02581400E-02  -1.25515800E-02
   +1.83500000E-05  +4.94900000E-05  +2.43000000E-05  -5.59100000E-05  -1.30800000E-05
   -8.89000000E-06  +1.90000000E-05  +1.37330000E-04  +1.37410000E-04  -1.17430000E-04
   +1.89180000E-04  +2.39500000E-04  -4.75000000E-05  -2.97800000E-05  +1.28000000E-05
   +2.02180000E-04  -1.43286000E-03  +3.20120000E-04  +1.87000000E-04  +1.37700000E-04
   -8.40500000E-05  -7.34640000E-04  -4.88010000E-04  +2.16900000E-05  -2.92690000E-04
   -6.03500000E-05  +3.13350000E-04  +2.09590000E-04  -3.36820000E-04  -6.48080000E-04
   -1.04260000E-04  -1.80980000E-04  -3.43000000E-05  -3.44790000E-04  -1.15499000E-03
   +5.73600000E-05  -9.03660000E-04  -6.53680000E-04  +3.65120000E-04  +3.47300000E-05
   -3.16600000E-05  +4.74770000E-04  +5.44700000E-05  -7.35620000E-04  +2.88180000E-04
   +9.10230000E-04  -3.46426000E-03  +4.77730000E-04  +2.93733000E-03  +5.48364900E-02
   +1.09610000E-04  -5.54600000E-05  -8.65720000E-04  +7.55600000E-05  -4.14604000E-03
   +5.83903000E-03  -2.16810000E-03  +2.16238000E-03  -3.04986000E-03  +2.63034000E-03
   +1.81982000E-03  -2.03454000E-03  -3.31350000E-04  +2.06958000E-03  -2.85900000E-03
   -2.53320000E-04  -5.17610000E-04  +4.28470000E-04  +3.69700000E-04  +2.78320000E-04
   -3.22550000E-04  -2.32000000E-06  -5.14300000E-05  -6.19500000E-05  +3.76900000E-05
   -1.60960000E-04  +8.61020000E-04  +7.93200000E-05  -1.64820000E-04  -5.89200000E-05
   +7.04300000E-05  +3.56700000E-05  +0.00000000E+00  -4.13400000E-05  -1.10200000E-05
   -7.59000000E-06  -3.49000000E-05  -1.12500000E-05  -3.51800000E-05  +3.25700000E-05
   +8.31600000E-05  +8.29000000E-06  -5.22100000E-05  +5.43000000E-06  +9.35500000E-05
   +3.24500000E-05  +1.92800000E-05  -1.07100000E-05  -2.47390000E-04  +3.77700000E-04
   +8.85600000E-05  +2.84406000E-03  -4.71543000E-03  -1.92435000E-02  -3.21000000E-06
   -2.14000000E-06  -6.20000000E-07  +1.53000000E-06  +1.27000000E-06  +1.50000000E-07
   -5.05000000E-06  +6.33000000E-06  -1.70500000E-05  +3.94600000E-05  -3.72100000E-05
   -7.44400000E-05  +7.23000000E-06  +8.03000000E-06  +1.31000000E-06  -2.65390000E-04
   -4.69200000E-05  -2.75790000E-04  +8.35800000E-05  +6.82200000E-05  +9.20000000E-06
   -4.57300000E-05  -3.19500000E-05  +2.26800000E-05  +1.48280000E-04  +3.46200000E-05
   -7.23600000E-05  -1.57900000E-05  +8.04500000E-05  +2.81230000E-04  +4.10200000E-05
   +4.63400000E-05  -4.74700000E-05  +1.80290000E-04  +1.42290000E-04  -1.12870000E-04
   +1.72880000E-04  +3.84210000E-04  -3.28200000E-05  -1.85500000E-05  -2.02670000E-04
   +9.92500000E-05  -9.96000000E-05  -1.47990000E-04  -4.16000000E-06  +4.39500000E-05
   +7.45100000E-05  -3.39250000E-04  -2.96918000E-03  -1.03781100E-02  +8.17213400E-02
   +1.49636000E-03  -2.16990800E-02  -7.59716000E-03  +1.47921500E-02  +4.64599900E-02
   -2.68047400E-02  +1.57644400E-02  -1.77809100E-02  +1.49736400E-02  -1.44132800E-02
   +4.92158000E-03  +7.33170000E-03  -1.64199500E-02  +4.54660000E-04  +6.12073000E-03
   -8.73173000E-03  +2.73142000E-03  -2.12994000E-03  -1.10826800E-02  -7.97128000E-03
   +6.21140000E-04  +3.21890000E-04  -2.74440000E-04  +1.30640000E-04  +3.27742000E-03
   +8.59473000E-03  -8.38520000E-04  -9.50690000E-04  +2.72617000E-03  +5.11120000E-04
   -3.99960000E-04  -3.05060000E-04  +6.29570000E-04  -6.36800000E-05  -5.11680000E-04
   +1.67020000E-04  +9.42180000E-04  +7.27380000E-04  +6.05100000E-05  -5.00520000E-04
   -6.79550000E-04  -3.63120000E-04  -6.10000000E-07  +1.53320000E-04  -4.88790000E-04
   -1.07440000E-03  -7.56920000E-04  +8.20400000E-05  -1.92123000E-03  +1.52535000E-03
   +7.36300000E-04  -1.47831500E-02  +6.88780900E-02  -1.64602900E-02  +1.50610000E-04
   +9.04900000E-05  +6.60900000E-05  -9.22100000E-05  -1.16620000E-04  -5.16000000E-05
   -1.20000000E-07  +1.65360000E-04  +1.47070000E-04  -1.33350000E-04  +2.18270000E-04
   +1.95290000E-04  -4.26900000E-05  -9.61200000E-05  +5.98000000E-06  -4.02027000E-03
   -7.66690000E-04  -3.73720000E-04  +1.17230000E-04  -1.14700000E-05  -5.74000000E-06
   -8.73720000E-04  -8.25110000E-04  +1.23000000E-06  -2.62110000E-04  -4.37100000E-05
   +1.99590000E-04  -9.48250000E-04  +1.52210000E-04  +1.39080000E-04  +4.29000000E-06
   -7.96900000E-05  -9.22400000E-05  -7.16910000E-04  -1.19382000E-03  +2.17730000E-04
   -9.48750000E-04  -7.62040000E-04  +7.02500000E-04  +2.29530000E-04  +4.60340000E-04
   +1.41800000E-05  -3.88520000E-04  -1.04082000E-03  +3.82200000E-04  +8.10820000E-04
   -1.94209000E-03  +3.75010000E-04  -7.00966300E-02  +2.13678600E-02  +2.56432600E-02
   +1.45096190E-01  -5.65252000E-03  -1.68382600E-02  -5.20794000E-03  +1.74451700E-02
   -1.98053000E-03  -8.28872000E-03  -1.64536000E-03  -1.22812500E-02  +1.25091000E-02
   -1.97784000E-03  -3.70080000E-04  -3.36500000E-05  +9.19869000E-03  +7.71049000E-03
   -2.45641000E-03  -4.04937000E-03  -1.16180000E-03  +9.66940000E-04  -6.77250000E-04
   -2.42460000E-04  +4.18340000E-04  -7.61570000E-04  -7.99100000E-05  -3.40510000E-04
   -4.17980000E-04  -7.92612000E-03  +8.10470000E-04  +3.48450000E-04  +3.00440000E-04
   -2.46300000E-04  +2.23930000E-04  +4.05160000E-04  +3.51080000E-04  -8.43700000E-05
   +1.64350000E-04  -8.21700000E-05  +3.54700000E-05  -1.06880000E-04  +8.48000000E-06
   -3.27200000E-05  +1.58130000E-04  -1.89740000E-04  +2.10060000E-04  +4.32090000E-04
   +4.27230000E-04  +1.23990000E-04  +2.17000000E-04  -3.64800000E-05  +9.90530000E-04
   -2.92203000E-03  -1.89240000E-04  +3.34300700E-02  -5.24509500E-02  +6.03858000E-03
   +2.04600000E-05  -6.21000000E-05  -1.64600000E-05  +7.72200000E-05  -3.31300000E-05
   -4.87000000E-06  -6.64900000E-05  -1.97870000E-04  -2.25920000E-04  +9.92900000E-05
   -1.64160000E-04  -1.79240000E-04  +1.02250000E-04  +2.84000000E-06  -4.52000000E-05
   +1.32207000E-03  +2.41059000E-03  -2.82870000E-04  -7.16000000E-05  -5.59400000E-05
   +2.65540000E-04  +1.30417000E-03  +1.04281000E-03  +5.39700000E-05  +6.16400000E-04
   +2.41110000E-04  -5.11760000E-04  +4.01390000E-04  +4.01240000E-04  +1.09553000E-03
   +2.05990000E-04  +3.40660000E-04  +3.19000000E-06  -7.45000000E-06  -5.43700000E-05
   +2.86570000E-04  -2.72340000E-04  +1.18780000E-04  +3.88000000E-06  -1.60800000E-05
   +5.66910000E-04  -2.08300000E-04  -5.55040000E-04  -7.23650000E-04  -2.82360000E-04
   -1.38898000E-03  +2.11975000E-03  -2.38990000E-04  +5.58872900E-02  -8.86764700E-02
   -1.34393900E-02  -1.22673330E-01  +2.16064550E-01  -6.55400000E-04  -5.44093000E-03
   +2.22023000E-03  -1.24216700E-02  -1.25862400E-02  -5.75653000E-03  -3.37850000E-03
   +2.12473000E-02  -1.23958000E-02  +1.05308000E-02  +7.27700000E-05  -5.22533000E-03
   +1.95430000E-04  -2.42271000E-03  -4.47619000E-03  -3.61189000E-03  -1.09484000E-03
   +2.48400000E-04  +2.46775000E-03  +1.97821000E-03  -9.85980000E-04  +2.02190000E-04
   -4.06520000E-04  -2.12970000E-04  -4.03500000E-04  +4.19400000E-04  +5.69680000E-04
   +1.54390000E-04  -7.53650000E-04  +5.79590000E-04  -2.13600000E-05  -3.07600000E-05
   -3.07850000E-04  +1.42360000E-04  +1.23930000E-04  +8.16300000E-05  -1.00780000E-04
   -1.03020000E-04  +4.48100000E-05  +3.70000000E-06  +3.38000000E-06  +1.66390000E-04
   -1.94530000E-04  -2.07300000E-05  -2.73960000E-04  +1.18810000E-04  +6.08900000E-05
   +2.36700000E-05  -6.04980000E-04  +8.98240000E-04  -2.29760000E-04  -2.41587000E-03
   -4.05000000E-06  +1.71716800E-02  -1.09600000E-05  -2.10000000E-06  -1.75700000E-05
   +2.07900000E-05  +2.96800000E-05  +5.20000000E-06  +8.40500000E-05  -2.65000000E-06
   +1.01440000E-04  -4.68900000E-05  -2.44000000E-06  +7.95700000E-05  -3.70800000E-05
   -3.14000000E-06  +7.07000000E-06  -4.22890000E-04  -8.50280000E-04  +1.78100000E-04
   +2.57260000E-04  +6.22200000E-05  +3.95430000E-04  -4.71720000E-04  -3.07500000E-04
   +1.63550000E-04  -2.30200000E-05  -2.69000000E-06  +2.54130000E-04  +8.05650000E-04
   +2.07470000E-04  -6.61300000E-04  +2.40200000E-04  +6.53500000E-05  +3.71700000E-05
   +8.07500000E-05  +3.07490000E-04  -4.75500000E-05  +1.09100000E-05  -5.42430000E-04
   +3.56690000E-04  +2.76700000E-04  +4.53100000E-04  +1.07510000E-04  +3.33790000E-04
   +3.52240000E-04  -3.05600000E-05  +1.78580000E-04  -9.39700000E-05  +1.77180000E-04
   -7.70647000E-03  +1.82249000E-02  -5.56428300E-02  +4.68577900E-02  -1.19181440E-01
   +5.68002210E-01  -6.32410000E-04  +7.12030000E-04  +1.69550000E-04  +6.15830000E-03
   +4.11949000E-03  +2.68860000E-03  +1.23286000E-03  -4.93912000E-03  +2.72942000E-03
   -2.72348000E-03  -2.46340000E-04  +1.30715000E-03  +2.60000000E-05  +3.84500000E-04
   +1.78365000E-03  +1.07953000E-03  +9.35900000E-05  -3.18620000E-04  -1.18936000E-03
   -1.21648000E-03  +1.28518000E-03  -1.47380000E-04  +2.60220000E-04  -1.79820000E-04
   +3.61200000E-05  +7.24200000E-05  -3.93930000E-04  -3.78670000E-04  +5.09030000E-04
   -3.86430000E-04  +9.60800000E-05  +5.89200000E-05  +2.19620000E-04  -7.90800000E-05
   -3.26300000E-05  -1.04230000E-04  -1.38670000E-04  -8.29400000E-05  -6.67500000E-05
   +1.11930000E-04  +7.37700000E-05  -6.07600000E-05  +1.15620000E-04  +4.42000000E-05
   +1.71550000E-04  +1.50640000E-04  +1.38100000E-04  -2.23400000E-05  -8.82580000E-04
   -9.87350000E-04  +2.39730000E-04  -2.74692000E-03  +3.77596000E-03  +1.55389000E-03
   -3.00700000E-05  -2.82100000E-05  -1.51000000E-06  +1.59200000E-05  -6.62000000E-06
   +9.51000000E-06  -1.15370000E-04  -4.21100000E-05  -1.28170000E-04  +1.02700000E-05
   -1.92100000E-05  -3.31700000E-05  +2.89400000E-05  +1.38300000E-05  -1.08200000E-05
   -1.51674000E-03  +2.43450000E-03  +5.41720000E-04  -7.20320000E-04  -3.17920000E-04
   -5.41430000E-04  +7.95510000E-04  +4.09450000E-04  -4.08630000E-04  +4.86500000E-05
   -3.15000000E-06  -2.42510000E-04  +5.62000000E-05  -9.91400000E-05  +1.24470000E-04
   -1.03280000E-04  +2.77500000E-05  +7.54500000E-05  +1.87800000E-05  -2.19400000E-05
   +4.17600000E-05  +8.17000000E-06  +6.28800000E-05  -1.59100000E-04  -1.27780000E-04
   -6.88400000E-05  -3.40200000E-05  -1.88750000E-04  -2.69670000E-04  -1.58330000E-04
   +2.40000000E-07  +6.05000000E-06  -6.12900000E-05  +3.75073000E-03  +5.60740000E-04
   -2.60897900E-02  -3.41377100E-02  +1.83074200E-02  -3.04344100E-02  +3.21180800E-02
   -6.20500000E-04  +1.36180000E-04  -8.35590000E-04  +1.53982000E-03  +1.45005000E-03
   +4.22030000E-03  +6.23700000E-04  -3.47435000E-03  +1.49539000E-03  -1.79566000E-03
   -1.50990000E-04  +7.49860000E-04  +4.25460000E-04  -2.59080000E-04  +1.38038000E-03
   +1.16191000E-03  -1.43300000E-04  -2.12960000E-04  -3.62350000E-04  +3.15050000E-04
   -2.51550000E-04  +2.07090000E-04  -2.41210000E-04  +1.11000000E-05  -2.08350000E-04
   +2.91940000E-04  -2.93750000E-04  +2.16010000E-04  -3.23250000E-04  +1.18310000E-04
   -3.13000000E-06  -4.05100000E-05  -1.21060000E-04  +2.90100000E-05  +2.62500000E-05
   -2.40500000E-05  -9.25700000E-05  -6.39900000E-05  +3.46600000E-05  +1.50300000E-05
   -7.10000000E-06  +5.06400000E-05  -6.02000000E-06  -1.02430000E-04  +3.29400000E-05
   +1.03030000E-04  +6.05200000E-05  -9.25000000E-06  +8.13920000E-04  +1.08382000E-03
   +4.44890000E-04  +9.38890000E-04  -9.85940000E-04  -3.10256000E-03  -2.34500000E-05
   +1.62000000E-06  -2.93000000E-06  -1.88000000E-06  +1.55200000E-05  +5.72000000E-06
   +1.58000000E-06  +3.74400000E-05  +3.01500000E-05  -1.85000000E-06  -1.22000000E-06
   +8.38000000E-06  -7.25000000E-06  +7.72000000E-06  +2.35000000E-06  +1.30563000E-03
   -8.20000000E-04  -4.75750000E-04  -2.28410000E-04  +2.55000000E-06  -2.73910000E-04
   -1.57350000E-04  -3.79260000E-04  -8.18800000E-05  -2.34500000E-05  -3.00200000E-05
   +2.70600000E-05  -1.32880000E-04  +2.15480000E-04  -8.59400000E-05  +1.35850000E-04
   -7.86000000E-06  -7.33000000E-05  -1.34510000E-04  -9.39100000E-05  +1.94200000E-05
   +4.90300000E-05  +9.11400000E-05  -1.37880000E-04  -1.18090000E-04  -2.27640000E-04
   -9.70000000E-07  -2.50690000E-04  -1.72320000E-04  +9.55600000E-05  +8.08200000E-05
   -9.47700000E-05  -2.29200000E-05  +3.01550000E-04  -3.37419000E-03  +2.64228100E-02
   +1.99032300E-02  -4.63689200E-02  +9.93455100E-02  -2.36831800E-02  +5.36269800E-02
   +2.61430000E-04  -1.15784000E-03  -1.40730000E-04  +3.12306000E-03  +3.86605000E-03
   -2.32852000E-03  +7.18610000E-04  +4.75490000E-04  +5.38680000E-04  +4.75220000E-04
   -4.50070000E-04  +3.50420000E-04  -5.86700000E-04  +2.49580000E-04  +1.78120000E-04
   -3.93620000E-04  -2.77420000E-04  -2.06650000E-04  -1.52280000E-04  -4.91430000E-04
   -3.33240000E-04  -2.33100000E-05  -7.44500000E-05  -6.11100000E-05  +2.07330000E-04
   -2.56280000E-04  +2.60500000E-05  -1.23220000E-04  +3.13230000E-04  +2.19900000E-05
   -3.64000000E-06  -3.15400000E-05  +9.28500000E-05  -3.12900000E-05  -7.72700000E-05
   +3.01500000E-05  +1.07150000E-04  +1.00690000E-04  -2.56600000E-05  -3.34800000E-05
   -3.81700000E-05  -2.96500000E-05  -2.52400000E-05  +9.19000000E-06  -6.10700000E-05
   -1.40090000E-04  -1.03060000E-04  +8.10000000E-06  -3.18660000E-04  +1.05320000E-03
   +3.72340000E-04  +9.32510000E-04  -5.42730000E-04  -2.41970000E-04  +2.08600000E-05
   +1.07300000E-05  +1.08000000E-05  -1.67500000E-05  -1.78700000E-05  -6.35000000E-06
   -3.46000000E-06  +2.30700000E-05  +1.90600000E-05  +2.67000000E-06  +1.39300000E-05
   +8.47000000E-06  -5.13000000E-06  -1.11700000E-05  +1.49000000E-06  +6.29600000E-05
   -4.94880000E-04  +3.70910000E-04  -2.61630000E-04  -2.17440000E-04  -1.93030000E-04
   -3.25750000E-04  -2.39710000E-04  -1.40150000E-04  -2.45800000E-05  -2.08800000E-05
   +1.65700000E-05  -3.14100000E-05  +1.36480000E-04  -3.87300000E-05  +3.99800000E-05
   +5.28900000E-05  +2.31000000E-05  -8.73000000E-05  -1.17920000E-04  +1.41630000E-04
   -8.63600000E-05  -1.08830000E-04  +4.87900000E-05  +3.20800000E-05  -2.01900000E-05
   -1.91000000E-05  -1.89220000E-04  -1.41960000E-04  -4.29500000E-05  -7.18900000E-05
   +6.06500000E-05  +1.89800000E-05  +1.16192000E-03  -1.43397000E-03  -4.28488000E-03
   -5.11055800E-02  +1.28449070E-01  -5.04707150E-01  +4.68947900E-02  -1.28489170E-01
   +5.10582460E-01
end_hess

