# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -882.69519690    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   008   +9.75670808E+00  -2.59315002E+00  -5.30755807E-01
   006   +7.55837357E+00  -1.29688653E+00  -2.56208754E-01
   006   +6.86983681E+00  -1.13628057E-01  +1.97389669E+00
   006   +4.59205172E+00  +1.18366362E+00  +2.12901561E+00
   006   +2.95285439E+00  +1.34438358E+00  +8.85704428E-02
   006   +3.69321391E+00  +1.30095362E-01  -2.13621281E+00
   006   +5.94486469E+00  -1.17274569E+00  -2.32564661E+00
   006   +4.28444948E-01  +2.74845243E+00  +2.02917733E-01
   006   +1.59770845E-01  +4.28748485E+00  +2.65108528E+00
   006   +3.06630548E-01  +4.61369843E+00  -2.03162695E+00
   006   -1.79423036E+00  +8.84534094E-01  +8.96297350E-02
   006   -4.27762893E+00  +1.67724412E+00  -1.37925736E-01
   006   -6.34095944E+00  +8.77438189E-02  -1.90676571E-01
   006   -5.95872332E+00  -2.48963232E+00  +3.36407007E-02
   006   -3.49387802E+00  -3.37077173E+00  +3.14291331E-01
   006   -1.46880496E+00  -1.72072804E+00  +3.49502036E-01
   008   -7.94213990E+00  -4.10080006E+00  -8.64043639E-03
   001   +1.07062424E+01  -2.51498762E+00  +1.00614805E+00
   001   +8.10717132E+00  -1.92104477E-01  +3.60498044E+00
   001   +4.12218387E+00  +2.07806354E+00  +3.90273256E+00
   001   +2.46105123E+00  +1.71445393E-01  -3.76741320E+00
   001   +6.48291291E+00  -2.09946122E+00  -4.06572646E+00
   001   +1.71310417E+00  +5.62960558E+00  +2.84625217E+00
   001   -1.59820391E+00  +5.35624132E+00  +2.60865653E+00
   001   +1.15311187E-01  +3.07403839E+00  +4.31518681E+00
   001   +2.43653589E-01  +3.63816898E+00  -3.84293423E+00
   001   -1.35866758E+00  +5.81120264E+00  -1.88859275E+00
   001   +1.97447653E+00  +5.82407883E+00  -2.01183758E+00
   001   -8.24059821E+00  +8.17988829E-01  -3.70757143E-01
   001   +4.15159604E-01  -2.48605800E+00  +5.82010228E-01
   001   -7.31055048E+00  -5.79031386E+00  +1.88012064E-01
   008   -3.25230926E+00  -5.93125900E+00  +5.46389269E-01
   001   -1.50925716E+00  -6.38249481E+00  +7.01936902E-01
   008   -5.78316633E+00  +6.09558746E+00  -6.47873519E-01
   001   -6.11743695E+00  +5.89155921E+00  -2.42861656E+00
   001   -4.81279131E+00  +3.92084050E+00  -1.89553063E-01
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +2.20000000E-07  +6.30000000E-07  +1.80000000E-07
   +1.90000000E-07  +4.10000000E-07  +2.40000000E-07
   -1.70000000E-07  -1.20000000E-07  +4.90000000E-07
   -2.70000000E-07  -2.70000000E-07  +5.60000000E-07
   -2.00000000E-08  +1.70000000E-07  +4.40000000E-07
   +2.60000000E-07  +7.00000000E-07  +2.10000000E-07
   +3.00000000E-07  +8.80000000E-07  +1.00000000E-07
   -1.10000000E-07  -4.00000000E-08  +5.40000000E-07
   -4.40000000E-07  -6.40000000E-07  +8.70000000E-07
   -3.00000000E-08  +5.00000000E-07  +1.00000000E-06
   +7.00000000E-08  -1.60000000E-07  -1.70000000E-07
   -2.10000000E-07  -1.30000000E-07  -1.60000000E-07
   +0.00000000E+00  -3.20000000E-07  -7.80000000E-07
   +8.00000000E-08  -3.50000000E-07  -1.38000000E-06
   +1.70000000E-07  -3.10000000E-07  -1.32000000E-06
   +1.10000000E-07  -1.70000000E-07  -7.00000000E-07
   +3.10000000E-07  -4.00000000E-07  -1.94000000E-06
   +5.00000000E-08  +3.10000000E-07  +2.60000000E-07
   -2.90000000E-07  -4.60000000E-07  +6.00000000E-07
   -4.50000000E-07  -7.30000000E-07  +7.40000000E-07
   +3.90000000E-07  +1.02000000E-06  +1.10000000E-07
   +5.40000000E-07  +1.32000000E-06  -3.00000000E-08
   -5.20000000E-07  -6.20000000E-07  +1.37000000E-06
   -5.20000000E-07  -6.90000000E-07  +9.50000000E-07
   -5.80000000E-07  -1.05000000E-06  +5.90000000E-07
   +2.20000000E-07  +9.50000000E-07  +7.30000000E-07
   -1.50000000E-07  +4.10000000E-07  +1.10000000E-06
   -8.00000000E-08  +5.90000000E-07  +1.43000000E-06
   +4.00000000E-08  -3.40000000E-07  -7.90000000E-07
   +1.20000000E-07  -1.30000000E-07  -7.40000000E-07
   +3.10000000E-07  -3.90000000E-07  -2.30000000E-06
   +3.10000000E-07  -2.70000000E-07  -1.94000000E-06
   +2.70000000E-07  -2.40000000E-07  -1.87000000E-06
   -5.00000000E-08  -9.00000000E-08  +6.30000000E-07
   +0.00000000E+00  +1.90000000E-07  +6.80000000E-07
   -8.00000000E-08  -1.60000000E-07  +3.20000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +4.66800560E-01  -1.56834350E-01  +1.39509040E-01  +2.09011760E-01  +7.18702300E-02
   +5.10321870E-01  -2.45078740E-01  +1.04747250E-01  -9.30610000E-03  +6.03634190E-01
   +1.22153890E-01  -1.16942960E-01  -1.88758700E-02  -2.08155550E-01  +3.27750410E-01
   +3.43862200E-02  -4.25825700E-02  -1.07563310E-01  +8.36880800E-02  +1.40361800E-01
   +6.72689740E-01  -2.18488000E-02  +3.16180100E-02  +3.94194200E-02  -1.29611730E-01
   +2.82268500E-02  -1.14647100E-02  +5.98144870E-01  +1.89499600E-02  -9.50256000E-03
   -2.49246400E-02  +5.46226200E-02  -1.24938900E-01  -7.17865200E-02  -2.18569550E-01
   +2.96285630E-01  +5.47094000E-03  -6.62581000E-03  +3.22370000E-04  +5.96911200E-02
   -1.10025200E-01  -2.83097640E-01  +1.05025340E-01  +1.41258850E-01  +6.70670700E-01
   +2.21406000E-03  -1.26790000E-04  -8.63938000E-03  +4.72781000E-03  +3.00484600E-02
   +8.56070900E-02  -2.74814420E-01  +1.06217510E-01  -2.77078300E-02  +5.73272360E-01
   +2.48433000E-03  +6.33596000E-03  -6.10760000E-04  +1.14353300E-02  -1.70453300E-02
   -3.59778200E-02  +1.27713430E-01  -1.32850200E-01  -7.22753000E-03  -2.12121610E-01
   +3.17993960E-01  -1.35111000E-03  -4.61803000E-03  -6.91977000E-03  +3.54718000E-02
   -7.73336000E-03  +3.32837000E-02  +3.16077600E-02  -3.99001600E-02  -1.23257210E-01
   +5.89191200E-02  +1.63218970E-01  +6.82926300E-01  -2.53364000E-03  +1.41638000E-03
   +1.73633000E-03  -1.08052000E-03  -8.27556000E-03  -1.50626000E-02  -3.55013300E-02
   +1.76044000E-02  -1.57459300E-02  -1.97465330E-01  +2.13686900E-02  -1.35097890E-01
   +5.48202480E-01  +2.29851000E-03  -1.92742000E-03  +1.81040000E-03  -9.23616000E-03
   -7.53811000E-03  -1.77726200E-02  +2.34480000E-03  +1.35105100E-02  +1.95903400E-02
   +4.13714200E-02  -8.67470500E-02  +7.45807000E-03  -1.59997760E-01  +3.20849940E-01
   +3.31406000E-03  +1.00959000E-03  +6.69246000E-03  -1.81374700E-02  -1.75670800E-02
   -8.11454400E-02  -6.03508200E-02  +4.50536300E-02  +4.06574100E-02  -7.57552300E-02
   -2.38273600E-02  -2.47130330E-01  +8.36452500E-02  +1.14755760E-01  +6.25787050E-01
   +4.49091000E-03  +8.76520000E-04  +2.22655000E-03  -4.05199000E-02  +6.34490000E-04
   -6.29389600E-02  -3.22735100E-02  +2.39641100E-02  +2.32950800E-02  +5.01496800E-02
   -2.16918900E-02  +4.41818000E-03  -1.30241070E-01  +3.42106100E-02  +2.70827000E-03
   +6.16712550E-01  -1.16819000E-03  +3.22786000E-03  -6.39983000E-03  +1.86930300E-02
   +1.18759900E-02  +5.31662300E-02  +2.64382400E-02  -2.55223500E-02  -2.06951700E-02
   -3.85632700E-02  +2.02417700E-02  -2.65588600E-02  +5.51502700E-02  -1.24760580E-01
   -6.71329900E-02  -2.10898200E-01  +3.11435820E-01  -3.64168000E-03  -2.99746000E-03
   -8.88123000E-03  -1.34822200E-02  +2.49466800E-02  +5.08718000E-02  +2.76248600E-02
   -2.23477500E-02  -2.41869600E-02  -4.07018100E-02  -1.10268000E-03  -5.66212500E-02
   +6.17310800E-02  -9.91895600E-02  -2.52231430E-01  +1.08459310E-01  +1.27814590E-01
   +6.53588810E-01  -4.20102600E-02  +1.21786600E-02  -4.03092300E-02  -1.74432660E-01
   +3.28106500E-02  -6.25769600E-02  +4.94337200E-02  -3.48038400E-02  -3.52262400E-02
   -5.49768500E-02  +1.85955400E-02  -2.73597900E-02  +9.75210000E-04  +3.04163900E-02
   +7.51328800E-02  -2.91803890E-01  +1.15901020E-01  -2.53278800E-02  +5.97143330E-01
   +2.38383400E-02  +2.52986000E-03  +2.24917900E-02  +8.76626000E-03  -8.91085900E-02
   -3.46377600E-02  -2.02182200E-02  +1.95314600E-02  -5.72610000E-04  +1.89055700E-02
   -1.02921200E-02  +1.02406000E-02  +1.43320400E-02  -1.12953800E-02  -3.30636500E-02
   +1.38401980E-01  -1.40270040E-01  -1.08443900E-02  -2.34132250E-01  +3.20659440E-01
   -6.40064000E-03  +4.19841000E-03  +8.58645000E-03  -1.30435150E-01  +2.47490000E-03
   -2.59167600E-01  +5.41910000E-03  -2.32013200E-02  -4.66636400E-02  -2.57610500E-02
   +9.74820000E-03  -1.61601400E-02  +2.99030600E-02  -8.21407000E-03  +3.08371000E-02
   +3.41420800E-02  -4.39492900E-02  -1.28345920E-01  +5.40446400E-02  +1.70210190E-01
   +6.78020510E-01  +2.00870000E-03  -1.46118000E-03  +1.62450000E-04  -2.18265000E-03
   +5.91820000E-04  -6.63000000E-04  +2.30391000E-03  +1.66685000E-03  -2.79497000E-03
   -1.65556200E-02  +9.96800000E-03  -3.17033000E-03  -1.51020190E-01  +4.23730700E-02
   -5.24510000E-04  -8.14032000E-03  +8.53203000E-03  +6.75580000E-03  +4.17217000E-03
   +8.11770000E-04  -3.51670000E-04  +4.80699960E-01  -1.23721000E-03  +1.09540000E-04
   +2.89770000E-04  +6.21530000E-04  -8.91060000E-04  -2.13630000E-04  +1.21319000E-03
   +5.40898000E-03  -2.03861000E-03  +4.17875000E-03  +1.58613000E-03  +3.73890000E-03
   +4.31082100E-02  -9.77900100E-02  -7.78760000E-03  +1.47538600E-02  -8.04919000E-03
   -3.41213000E-03  +9.29280000E-04  +3.57103000E-03  -3.25820000E-03  -2.01592500E-02
   +4.68806180E-01  -4.82570000E-04  +6.26060000E-04  +3.25720000E-04  -1.67610000E-04
   -4.54660000E-04  -1.99951000E-03  -3.64262000E-03  -1.76472000E-03  -2.52969000E-03
   -1.95934700E-02  +1.15531300E-02  +7.33979000E-03  +1.64525000E-03  -8.47380000E-03
   -9.02070800E-02  +2.47270600E-02  -1.18639400E-02  +4.20604000E-03  +4.58120000E-04
   -3.42285000E-03  -4.57313000E-03  -2.66054000E-03  +8.55134000E-03  +4.66986700E-01
   -7.08880000E-04  +3.70230000E-04  +5.32400000E-05  +4.72720000E-04  -9.52400000E-05
   +8.62000000E-06  +1.21660000E-04  +2.72410000E-04  +1.04074000E-03  -2.30005000E-03
   +1.39354000E-03  +2.22280000E-04  -4.73773000E-03  +1.73659700E-02  +2.66440400E-02
   -4.91229000E-03  +2.63097000E-03  -1.65371000E-03  -3.46230000E-04  +4.72600000E-04
   +1.45976000E-03  -7.75688300E-02  +4.40054000E-03  +3.84293000E-03  +5.90890370E-01
   +3.81700000E-05  -2.68700000E-05  -1.78800000E-05  +6.65500000E-05  +1.42800000E-04
   +4.39700000E-05  -3.37070000E-04  -1.95400000E-04  -5.51420000E-04  +5.54400000E-05
   -9.64190000E-04  -1.79970000E-04  +5.56721000E-03  -1.14007700E-02  -1.53935400E-02
   +2.35317000E-03  -5.95000000E-04  +8.50960000E-04  -7.15800000E-05  -2.04000000E-06
   -8.35880000E-04  +7.83419000E-03  -1.01351320E-01  -4.59039100E-02  +3.93094000E-03
   +5.49075300E-01  -3.90350000E-04  +2.17280000E-04  -3.58100000E-05  +2.64580000E-04
   -2.37860000E-04  +1.24750000E-04  -3.10120000E-04  +9.52500000E-05  -3.53360000E-04
   -5.29640000E-04  +1.23592000E-03  +2.67180000E-04  +5.55931000E-03  -3.48489000E-03
   -1.07933000E-03  -1.48827000E-03  +2.28100000E-04  +3.42650000E-04  -3.30540000E-04
   +4.97500000E-05  +1.11420000E-04  +8.10622000E-03  -4.13881500E-02  -1.44800460E-01
   +1.21551900E-02  -6.00967500E-02  +5.02953660E-01  -1.21602000E-03  +7.60490000E-04
   +1.22040000E-04  +5.24210000E-04  -6.39070000E-04  -9.30290000E-04  -1.87921000E-03
   -5.26180000E-04  +4.45820000E-04  -1.78073000E-03  +2.21171000E-03  +1.64724000E-03
   -6.10489000E-03  +2.09740200E-02  -2.40764200E-02  -5.78660000E-04  +2.32184000E-03
   +5.66600000E-05  +1.97140000E-04  -4.61620000E-04  -6.64240000E-04  -7.53029600E-02
   +4.05477000E-03  -3.00963000E-03  +8.24950000E-04  -3.66970000E-04  +2.13198000E-03
   +5.92439970E-01  +3.20370000E-04  -2.27100000E-04  -5.89400000E-05  -1.15670000E-04
   +2.53680000E-04  +6.05500000E-04  +9.09680000E-04  +2.25640000E-04  -3.65230000E-04
   -5.62240000E-04  -1.34002000E-03  -1.16657000E-03  +8.64892000E-03  -1.65306000E-02
   +1.54235500E-02  +5.61640000E-04  -8.45250000E-04  +7.23010000E-04  -4.63810000E-04
   +4.46660000E-04  +4.06460000E-04  +3.62248000E-03  -1.11869380E-01  +4.76825400E-02
   +2.83400000E-05  +1.07777400E-02  -1.09589200E-02  -4.58917000E-03  +5.29262330E-01
   +5.65800000E-04  -3.11390000E-04  -1.35500000E-04  -3.46230000E-04  +1.46580000E-04
   +5.44460000E-04  +2.84040000E-04  -1.09050000E-04  -2.46370000E-04  +1.10365000E-03
   -1.96090000E-04  -1.57850000E-04  -7.44533000E-03  +4.86224000E-03  +2.65470000E-04
   +1.64731000E-03  -5.47980000E-04  +5.51980000E-04  -3.85990000E-04  -1.67910000E-04
   -4.59470000E-04  -1.96137000E-03  +4.31711400E-02  -1.29379680E-01  -7.46170000E-04
   +1.76241900E-02  -3.66085300E-02  -3.05206000E-03  +6.77552600E-02  +5.17338030E-01
   -5.30420000E-04  +1.83480000E-04  +1.06130000E-04  +3.77590000E-04  -4.05200000E-04
   -4.36180000E-04  -1.84800000E-04  +1.49025000E-03  -7.89500000E-05  -4.79470000E-04
   -5.04700000E-05  +2.20173000E-03  -3.28189800E-02  -1.34920700E-02  -3.42017000E-03
   +6.11890000E-04  -7.67130000E-04  -8.51830000E-04  +1.11460000E-04  +3.25170000E-04
   -8.20240000E-04  -1.29985540E-01  -3.44739900E-02  -3.34755000E-03  -7.68200000E-05
   -6.74263000E-03  -6.95032000E-03  +3.38060000E-04  -6.34960000E-03  +5.25096000E-03
   +6.20518480E-01  +1.26174000E-03  -7.07950000E-04  -9.61300000E-05  -7.59520000E-04
   +7.23520000E-04  -1.01360000E-04  +5.11700000E-05  -8.31550000E-04  +3.70410000E-04
   +2.04546000E-03  -2.18600000E-03  -4.00170000E-04  +5.42380000E-03  +1.32614000E-02
   +1.63942000E-03  +5.08690000E-04  -1.19050000E-03  +6.61900000E-04  +5.48450000E-04
   -6.01500000E-04  +2.86270000E-04  -3.74907200E-02  -1.17726430E-01  -1.26608000E-03
   -1.60459600E-02  -2.00806100E-02  -8.82808000E-03  -1.85117000E-02  -2.09439100E-02
   +3.17741000E-03  -1.58308400E-02  +6.17895860E-01  +1.93670000E-04  -1.79390000E-04
   -4.89000000E-06  +2.05300000E-05  +2.43470000E-04  +3.51120000E-04  +2.83450000E-04
   -1.06210000E-04  -2.86270000E-04  -5.64260000E-04  +4.27910000E-04  -2.64340000E-04
   -5.56480000E-04  +2.93950000E-04  -2.75780000E-04  +1.17434000E-03  -4.40810000E-04
   -2.17290000E-04  -3.74770000E-04  +1.11130000E-04  +1.54600000E-05  -3.55876000E-03
   -2.96920000E-04  -6.65488900E-02  -2.15858700E-02  -2.06716500E-02  -4.29609000E-03
   +2.01639200E-02  +1.77650900E-02  +2.28650000E-04  +3.87211300E-02  -3.24289700E-02
   +1.80734530E-01  -1.90300000E-05  +2.59600000E-05  +1.43200000E-05  -2.19900000E-05
   -6.69000000E-05  +1.29990000E-04  +1.15330000E-04  +8.58300000E-05  -1.22720000E-04
   -5.51760000E-04  +4.36480000E-04  +7.84300000E-05  -1.30840000E-03  -2.52354000E-03
   -9.48600000E-05  +1.41020000E-04  +2.81670000E-04  -5.11360000E-04  -1.04090000E-04
   +2.53660000E-04  +5.70700000E-05  -2.84909500E-02  -1.61687000E-03  -2.08690000E-03
   -6.31030000E-04  +8.98590000E-04  +7.55440000E-04  -5.83590000E-04  +5.38410000E-04
   -7.41880000E-04  -2.94777310E-01  +2.85463600E-02  -1.87427600E-02  +6.55490860E-01
   -1.25751000E-03  +6.40130000E-04  +8.67100000E-05  +9.63880000E-04  -5.38900000E-04
   -1.20200000E-04  -1.78650000E-04  +6.05810000E-04  +3.90900000E-05  -6.05730000E-04
   +3.53620000E-04  +6.04510000E-04  -2.67263000E-03  -4.77814000E-03  -5.84190000E-04
   -6.33000000E-05  -1.37770000E-04  -2.33990000E-04  -3.15390000E-04  +2.40040000E-04
   -3.21310000E-04  -1.45757100E-02  +1.35736700E-02  -1.49459000E-03  -2.63968000E-03
   -6.00760000E-04  +6.54090000E-04  -2.31932000E-03  +8.63090000E-04  -6.92280000E-04
   +8.34932900E-02  -1.17331220E-01  +1.02670100E-02  +5.39796400E-02  +4.58588310E-01
   +3.13500000E-05  -3.51600000E-05  -3.73100000E-05  +8.19700000E-05  +1.03490000E-04
   +4.95040000E-04  +3.47330000E-04  -2.02160000E-04  -1.31140000E-04  -1.58220000E-04
   +1.58060000E-04  -2.82400000E-04  +7.02960000E-04  -7.95400000E-05  +1.03496000E-03
   +2.81410000E-04  -3.14700000E-05  -8.06900000E-05  -4.04140000E-04  +2.72560000E-04
   -1.26080000E-04  -2.14133000E-03  -9.64680000E-04  +9.27710000E-04  -7.41970000E-04
   -7.91150000E-04  +1.26100000E-05  +7.47880000E-04  +4.92930000E-04  +3.29240000E-04
   -2.15163400E-02  +5.29274000E-03  -6.40886300E-02  +3.68968000E-02  -1.38653700E-02
   +1.18347750E-01  -3.38110000E-04  +1.64140000E-04  +2.72800000E-05  +2.81400000E-04
   -1.50190000E-04  -1.27040000E-04  -1.08800000E-04  +1.73210000E-04  +3.37100000E-05
   -2.35300000E-05  -1.83900000E-05  +2.89810000E-04  -4.89440000E-04  -1.07789000E-03
   -3.71400000E-04  -1.29810000E-04  -1.41650000E-04  -7.91000000E-06  +1.32400000E-05
   -5.54600000E-05  -7.13600000E-05  -1.53626000E-03  +5.26767000E-03  -3.62770000E-04
   +3.80170000E-04  +3.90410000E-04  +2.75060000E-04  +5.48080000E-04  +4.81650000E-04
   -1.88050000E-04  -5.72653100E-02  +4.89382000E-03  -6.24844000E-03  -2.62528860E-01
   -1.46562710E-01  -6.67214000E-03  +7.50996870E-01  +6.47200000E-05  -2.02400000E-05
   -4.21000000E-06  -6.42000000E-05  +3.52200000E-05  -1.13810000E-04  -1.04710000E-04
   -2.97200000E-05  +5.68900000E-05  +2.43810000E-04  -9.84300000E-05  -7.67300000E-05
   +1.13703000E-03  +9.55660000E-04  -1.59210000E-04  -6.48800000E-05  +2.39300000E-05
   +2.27430000E-04  +7.86600000E-05  -1.00670000E-04  +3.44200000E-05  +2.78349000E-03
   -1.00822000E-03  -1.85850000E-04  +3.49300000E-05  -1.31900000E-04  +7.89200000E-05
   +3.51040000E-04  -3.63640000E-04  +5.63800000E-05  -4.50761800E-02  +5.90394800E-02
   -8.00776000E-03  -9.12236000E-02  -1.86713360E-01  +1.32725000E-03  -9.50525000E-03
   +6.81334520E-01  -8.02200000E-05  +3.91200000E-05  +1.34100000E-05  +6.25300000E-05
   -3.29100000E-05  -5.00400000E-05  -2.65900000E-05  +3.23600000E-05  +2.82900000E-05
   -6.98000000E-06  -3.75400000E-05  +6.11500000E-05  -2.32610000E-04  -2.85510000E-04
   +1.70780000E-04  -4.93000000E-05  +1.15900000E-05  -5.62600000E-05  +5.82000000E-06
   -2.25200000E-05  -8.40000000E-07  -6.00950000E-04  +9.54150000E-04  +3.58002000E-03
   +1.83240000E-04  +3.10430000E-04  +2.31760000E-04  -5.40600000E-05  -2.08270000E-04
   +9.78800000E-05  -4.00690000E-04  -4.07728000E-03  +4.80899000E-03  -9.74480000E-03
   -1.90762000E-03  -5.37276700E-02  +4.71394200E-02  -3.99344800E-02  +1.28675300E-01
   +9.86440000E-04  -5.79500000E-04  -3.75800000E-05  -8.41080000E-04  +4.76520000E-04
   -1.58700000E-05  +1.10420000E-04  -1.85930000E-04  -1.63740000E-04  +1.94740000E-04
   -1.18450000E-04  -1.44290000E-04  -1.85280000E-04  +7.27750000E-04  -1.37090000E-04
   -7.63000000E-06  -4.90600000E-05  +1.08100000E-04  +2.64460000E-04  -7.70100000E-05
   +2.37860000E-04  -1.75935000E-03  -1.32560000E-04  -3.69800000E-05  +1.21132000E-03
   +6.23870000E-04  -1.05120000E-04  +1.21760000E-03  +3.48940000E-04  +2.85990000E-04
   -3.41409000E-02  +4.56384600E-02  -7.54467000E-03  +5.96923100E-02  -1.65135800E-02
   +5.29883000E-03  -1.41627780E-01  +2.77692000E-03  -6.77454000E-03  +6.98010290E-01
   +5.48480000E-04  -3.07250000E-04  -2.39500000E-05  -4.56620000E-04  +2.46680000E-04
   +9.71500000E-05  +1.85310000E-04  -1.18580000E-04  -1.09090000E-04  -1.40100000E-05
   -3.95400000E-05  -3.03000000E-05  -7.75160000E-04  +9.81800000E-05  +3.38900000E-04
   +3.30000000E-06  -7.43000000E-05  -2.30080000E-04  +1.40370000E-04  +2.86200000E-05
   +1.45030000E-04  -5.87150000E-04  -1.45101000E-03  +4.11070000E-04  +1.57860000E-04
   +2.86500000E-05  -2.87190000E-04  -7.69200000E-05  -8.36100000E-05  +5.40300000E-05
   +4.50356600E-02  -4.11973600E-02  +6.58554000E-03  -7.47410900E-02  -4.83796800E-02
   -1.84091000E-03  +8.57658600E-02  -3.25603620E-01  +2.67223200E-02  +8.89068000E-03
   +7.68540470E-01  +4.90400000E-05  -2.90300000E-05  -7.82000000E-06  -4.90800000E-05
   +4.94000000E-06  -4.13000000E-06  -2.46900000E-05  +2.88700000E-05  -2.73400000E-05
   +5.55100000E-05  +2.68000000E-06  -3.22100000E-05  +1.13840000E-04  +9.35300000E-05
   +1.60000000E-06  -5.95200000E-05  -2.78900000E-05  +9.27600000E-05  +4.60700000E-05
   -3.02600000E-05  +4.90000000E-07  -1.73000000E-05  +2.77900000E-05  -1.20694000E-03
   -1.12540000E-04  -2.01500000E-05  +7.12300000E-05  +3.56080000E-04  +3.82600000E-05
   +7.09300000E-05  -6.54429000E-03  +7.17457000E-03  -6.39050000E-04  +9.62671000E-03
   +2.75957000E-03  +3.72911000E-03  -1.26299800E-02  +2.04747000E-02  -6.53338500E-02
   +4.55998300E-02  -4.71234600E-02  +1.54696110E-01  -4.12780000E-04  +2.76000000E-04
   +3.08700000E-05  +2.94850000E-04  -2.18750000E-04  -5.89800000E-05  +1.36000000E-06
   +1.90450000E-04  +1.23350000E-04  +4.48300000E-05  +3.66400000E-05  +2.67700000E-04
   -6.60970000E-04  -1.29118000E-03  +3.78970000E-04  -1.24310000E-04  -9.50000000E-05
   -4.14350000E-04  +3.11800000E-05  +1.08470000E-04  -3.76700000E-05  +3.28240000E-04
   +2.21214000E-03  -1.06000000E-03  -1.41280000E-03  -8.94240000E-04  -1.77860000E-04
   -9.42840000E-04  -2.82290000E-04  -3.62200000E-05  +6.06086300E-02  -7.39511200E-02
   +1.17960200E-02  -8.32606800E-02  -7.56224000E-03  -5.30556000E-03  +2.83800500E-02
   +8.60618600E-02  -4.27860000E-03  -2.79331390E-01  +9.91070000E-03  -1.82729700E-02
   +7.37618560E-01  +1.31464000E-03  -8.95680000E-04  -4.66100000E-05  -1.17653000E-03
   +6.13310000E-04  +3.61820000E-04  +3.33470000E-04  -4.30830000E-04  -2.88630000E-04
   -4.48240000E-04  +3.60330000E-04  -6.54340000E-04  +8.97150000E-04  +5.73100000E-04
   +6.80900000E-05  +2.81310000E-04  +5.53220000E-04  -7.56100000E-05  -6.27200000E-05
   +9.27600000E-05  +2.95480000E-04  +1.35139000E-03  -2.82871000E-03  +1.25649000E-03
   -5.54700000E-05  -5.05000000E-06  -7.70400000E-05  -4.68000000E-04  -4.17250000E-04
   -1.10020000E-04  -1.79867300E-02  -3.79721900E-02  +7.78820000E-04  -6.67048000E-03
   -3.51090000E-04  -2.31720000E-04  +3.22371700E-02  -1.39215300E-02  +3.40061000E-03
   +1.07119410E-01  -1.27518430E-01  +1.35791100E-02  +2.20899700E-02  +7.05503620E-01
   -1.48410000E-04  +9.30600000E-05  -4.18000000E-06  +1.66270000E-04  -3.30100000E-05
   +6.14700000E-05  +4.99500000E-05  -4.06300000E-05  +8.01000000E-06  -8.94000000E-05
   +1.70000000E-05  +2.29800000E-05  -8.22100000E-05  -5.99800000E-05  +2.94390000E-04
   +1.62370000E-04  -7.39000000E-05  -2.07500000E-04  -9.47200000E-05  +1.72200000E-05
   -5.46400000E-05  -5.25000000E-04  +6.05920000E-04  +6.35532000E-03  +1.03125000E-03
   +1.04703000E-03  -1.08920000E-04  -1.05411000E-03  -7.84620000E-04  -2.62280000E-04
   +6.54187000E-03  -2.67740000E-03  +1.48117000E-03  -5.94001000E-03  -7.47930000E-04
   -1.64051000E-03  -7.53490000E-04  +7.93273000E-03  +2.05257000E-03  -2.66176000E-02
   +5.98240000E-03  -7.59037700E-02  +4.82223700E-02  -4.41113900E-02  +1.53025690E-01
   -4.26190000E-04  +2.75340000E-04  +6.37700000E-05  +1.94560000E-04  -9.75500000E-05
   -7.10010000E-04  -5.06240000E-04  +5.91780000E-04  +2.21510000E-04  +8.18880000E-04
   -7.96930000E-04  +6.62510000E-04  -2.13193000E-03  -3.51976000E-03  +4.19050000E-04
   -1.59447000E-03  -1.51408000E-03  +6.12030000E-04  +5.40770000E-04  -2.63900000E-05
   +7.40700000E-05  +7.38568000E-03  -2.28365900E-02  +3.16703000E-03  -1.53441000E-03
   -1.06331000E-03  +8.64330000E-04  -2.81631000E-03  -1.91915000E-03  -1.12959000E-03
   -1.22996930E-01  +5.91499400E-02  -1.14077700E-02  +1.12083400E-02  +2.85012600E-02
   -2.25745000E-03  -1.21307200E-02  -1.83698300E-02  +3.35270000E-04  -5.32427500E-02
   +1.27969000E-03  -4.55598000E-03  -2.69602930E-01  -1.40442200E-01  -6.59814000E-03
   +7.27231730E-01  -2.70620000E-04  +1.84320000E-04  +5.51800000E-05  +2.69300000E-04
   -1.39900000E-04  -4.33510000E-04  -1.95590000E-04  +8.31400000E-05  +1.95000000E-04
   +6.87020000E-04  -3.83110000E-04  +8.67900000E-04  -9.78990000E-04  -2.83221000E-03
   +2.16210000E-04  -1.34299000E-03  -8.83910000E-04  -1.14730000E-04  +4.67080000E-04
   -3.31550000E-04  +2.55880000E-04  -4.12936000E-03  -1.83674700E-02  +1.85079000E-03
   +3.04650000E-04  +4.46060000E-04  +1.49998000E-03  -3.57570000E-04  +1.72290000E-04
   -1.23132000E-03  -1.33250900E-02  -3.07376110E-01  +2.08343100E-02  +9.20130100E-02
   -1.67737700E-02  +9.13549000E-03  -2.67959300E-02  -5.91803900E-02  +2.56144000E-03
   -5.31281400E-02  +6.61245200E-02  -9.38502000E-03  -5.38365000E-02  -2.06308060E-01
   +7.35902000E-03  -7.73814000E-03  +6.84411200E-01  +1.38400000E-05  -2.98000000E-06
   +1.12500000E-05  -1.11210000E-04  +9.66000000E-06  +3.05020000E-04  +4.51140000E-04
   -3.29410000E-04  +4.57600000E-05  -6.30850000E-04  -1.10270000E-04  -1.55480000E-04
   +3.41000000E-04  +4.71740000E-04  +5.93150000E-04  +1.58293000E-03  +5.57270000E-04
   -6.48670000E-04  -4.00930000E-04  +7.46260000E-04  -2.05950000E-04  +8.80490000E-04
   -9.62800000E-04  +4.45855000E-03  -2.18630000E-04  -6.06770000E-04  -6.63820000E-04
   -2.30700000E-05  +3.00590000E-04  -5.69980000E-04  -5.04366000E-03  +2.73150200E-02
   -6.33031600E-02  -7.02527000E-03  +4.24123000E-03  +7.97528000E-03  +1.49572000E-03
   +4.21302000E-03  +1.47925000E-03  +6.37420000E-04  -5.92853000E-03  +3.75184000E-03
   -1.47346600E-02  +6.38350000E-04  -6.20140500E-02  +5.24401700E-02  -4.92805600E-02
   +1.32738340E-01  -1.00945000E-03  +5.75640000E-04  +5.05000000E-05  +8.59750000E-04
   -4.71390000E-04  -1.38430000E-04  -2.11390000E-04  +2.31300000E-04  +2.32270000E-04
   +6.02400000E-05  -1.82900000E-05  +2.83700000E-04  +3.03230000E-04  -6.36870000E-04
   +8.30000000E-07  -1.14150000E-04  -9.39800000E-05  -5.76100000E-05  -1.44140000E-04
   -3.74700000E-05  -2.06140000E-04  +1.53074000E-03  -9.84000000E-06  -3.51080000E-04
   -1.22795000E-03  -4.76510000E-04  +4.04610000E-04  -9.53400000E-04  -1.79060000E-04
   -3.82370000E-04  +1.50010000E-03  -6.70684000E-03  +1.65469000E-03  -6.71433000E-03
   +4.82048000E-03  -1.35761000E-03  +1.10658100E-02  -6.66946000E-03  +1.25854000E-03
   -2.44828370E-01  -7.86502800E-02  -1.13788100E-02  -5.32152400E-02  -4.20342700E-02
   -1.95139000E-03  +1.66557000E-03  +1.13982100E-02  -1.64963000E-03  +3.98276540E-01
   -8.90680000E-04  +5.36930000E-04  +4.17900000E-05  +7.30950000E-04  -4.23350000E-04
   -1.17400000E-04  -1.99430000E-04  +2.28870000E-04  +1.94730000E-04  -1.12000000E-06
   +4.83100000E-05  +1.77000000E-04  +4.75230000E-04  -5.33850000E-04  -7.99000000E-05
   -6.14300000E-05  +2.06200000E-05  -9.90000000E-06  -1.66980000E-04  +3.45000000E-05
   -1.92640000E-04  +1.27593000E-03  +1.57060000E-04  -4.73540000E-04  -1.07549000E-03
   -4.47910000E-04  +3.91850000E-04  -8.00000000E-04  -1.76490000E-04  -3.35620000E-04
   -3.99567000E-03  -1.21001000E-03  +4.87970000E-04  +4.29125000E-03  +1.90196000E-03
   +4.33490000E-04  -4.50760400E-02  -4.21490100E-02  +3.43740000E-04  -1.33714640E-01
   -1.92505070E-01  +4.21200000E-04  -5.86076000E-03  -7.67847000E-03  +8.17930000E-04
   +4.75208000E-03  -1.19308000E-03  +8.70550000E-04  -1.74358600E-02  +6.82094760E-01
   -1.87100000E-05  +1.22400000E-05  +1.26400000E-05  +1.11500000E-05  -1.21100000E-05
   -3.65300000E-05  -1.59200000E-05  +1.32200000E-05  +2.63500000E-05  +2.79900000E-05
   -1.42900000E-05  +2.63600000E-05  -4.42200000E-05  -3.87700000E-05  -6.05400000E-05
   -6.40000000E-05  -3.80000000E-07  -1.19500000E-05  +1.73200000E-05  -1.59800000E-05
   +1.51800000E-05  +9.66000000E-06  -5.94800000E-05  -1.49300000E-04  +3.68700000E-05
   -1.42600000E-05  -3.17200000E-05  -7.22400000E-05  +1.25600000E-05  -3.51100000E-05
   +5.65000000E-04  -4.25050000E-04  -9.34200000E-04  -1.34109000E-03  +6.18750000E-04
   +4.84806000E-03  +3.98379000E-03  +3.24128000E-03  +6.65895000E-03  -6.52271000E-03
   +5.32303000E-03  -4.27769200E-02  -4.92370000E-03  -2.10007000E-03  +9.48157000E-03
   -9.11450000E-04  +1.46975000E-03  +5.68492000E-03  +3.40227700E-02  -5.55929400E-02
   +3.62425600E-02  -1.61865770E-01  +9.28034000E-03  -1.97692000E-01  -2.79478300E-02
   -6.49560000E-04  -3.77224400E-02  +3.57036000E-03  -2.53372000E-03  -3.73060000E-04
   -9.30660000E-04  +2.96900000E-05  -5.06160000E-04  +4.49460000E-04  +2.62800000E-05
   +7.52890000E-04  +4.47990000E-04  -1.52840000E-04  -2.10655000E-03  -4.12293000E-03
   +4.44032000E-03  +2.69742000E-03  -2.17280000E-04  +1.02160000E-04  +1.50700000E-04
   +9.83200000E-05  -1.61300000E-05  +1.61300000E-05  +1.36070000E-04  -3.04700000E-05
   -5.19100000E-05  +5.88600000E-05  -1.41850000E-04  -2.35400000E-05  -1.80100000E-05
   +1.75140000E-04  -1.60000000E-05  +5.51900000E-05  -4.66000000E-06  +1.41200000E-05
   -1.46460000E-04  -9.50100000E-05  -6.25000000E-06  +3.78800000E-05  -1.30560000E-04
   +1.02000000E-05  +2.80600000E-05  +4.93100000E-05  -5.09000000E-06  +1.60520000E-04
   +1.27220000E-04  +4.97000000E-06  +1.90497660E-01  -8.18580000E-03  -1.79608500E-02
   -4.79925100E-02  +1.55198700E-02  -2.45122000E-03  +2.22826800E-02  -4.41830000E-04
   -2.74900000E-05  +1.76795000E-03  +5.77800000E-05  -7.17140000E-04  +1.63790000E-04
   -1.56070000E-04  +1.04400000E-05  -4.42730000E-04  +5.45190000E-04  +1.55380000E-03
   +5.99950000E-04  +3.97193000E-03  -5.37320000E-04  -1.64352000E-03  +5.09500000E-05
   -7.05000000E-05  -7.60400000E-05  -2.82200000E-05  +1.24200000E-05  +5.07000000E-06
   -6.41300000E-05  +3.65800000E-05  +2.30600000E-05  +1.31800000E-05  +5.07900000E-05
   +4.17000000E-06  -8.00000000E-06  -4.83100000E-05  +5.20000000E-07  -8.33000000E-06
   -4.51000000E-06  +1.08000000E-06  +9.02400000E-05  +4.21100000E-05  +2.56000000E-06
   -4.97100000E-05  +1.84960000E-04  -1.97700000E-05  -5.62000000E-05  -3.13600000E-05
   +1.61500000E-05  -8.09600000E-05  -8.55900000E-05  +1.21000000E-06  -1.10081600E-02
   +2.06624200E-02  -2.42300680E-01  -2.38222600E-02  -4.06294580E-01  +3.64573000E-03
   -1.07050000E-04  +2.07524000E-03  +5.29435000E-03  -1.30817000E-03  +3.27104000E-03
   -1.57650000E-04  +4.69800000E-05  -8.97970000E-04  +1.38040000E-04  -1.78640000E-04
   -9.44100000E-05  -4.61710000E-04  -3.52280000E-04  +2.69600000E-05  +1.36029000E-03
   -8.41290000E-04  +1.85009000E-03  -1.51410000E-04  +7.50800000E-05  +6.98000000E-06
   +2.56300000E-05  +1.88000000E-06  +4.39500000E-05  +8.06200000E-05  -4.57800000E-05
   -5.60800000E-05  +4.96200000E-05  -7.27800000E-05  -2.30500000E-05  +1.12000000E-05
   +5.82300000E-05  +3.30000000E-07  +1.45100000E-05  -5.33000000E-06  +1.77000000E-06
   -4.24700000E-05  -1.81300000E-05  -1.99000000E-06  +2.87600000E-05  -7.38400000E-05
   +1.13700000E-05  +2.52600000E-05  +9.79000000E-06  -1.94000000E-06  +4.17100000E-05
   +4.00800000E-05  -3.81000000E-06  +2.32941040E-01  +2.65151200E-02  +4.00772200E-01
   +2.21879000E-03  -2.86779000E-03  +1.51430000E-03  +5.17464000E-03  +2.12698000E-03
   +7.13324000E-03  -1.52352020E-01  +1.55799300E-02  -1.35060500E-01  -1.20869400E-02
   -7.35860000E-04  -2.35151800E-02  -2.24421000E-03  +5.12827000E-03  +8.30870000E-04
   -6.50180000E-04  +1.62040000E-04  +9.53850000E-04  +1.84235000E-03  +2.57686000E-03
   +1.29578000E-03  +8.22500000E-05  -1.96680000E-04  -1.15502000E-03  -3.08800000E-05
   -9.78000000E-05  -6.64900000E-05  -3.86440000E-04  +1.46880000E-04  +1.12280000E-04
   -1.40900000E-05  +2.64850000E-04  -1.62800000E-05  -3.46400000E-05  -1.45440000E-04
   -2.46000000E-06  -3.00200000E-05  +1.04000000E-05  +1.59000000E-06  +1.05220000E-04
   +4.60900000E-05  -6.40000000E-07  -6.96800000E-05  +1.50820000E-04  -1.66900000E-05
   -5.03700000E-05  -5.33800000E-05  +3.83600000E-05  -9.99300000E-05  -9.67900000E-05
   +3.96000000E-06  -1.13100000E-04  -3.71200000E-05  -1.03900000E-03  +1.58725320E-01
   -2.99651000E-03  -1.93209000E-03  +1.46869000E-03  -8.12458000E-03  +4.61896000E-03
   -1.12803200E-02  +1.53864800E-02  -4.14756100E-02  -1.34730000E-04  +8.98247000E-03
   +2.42433000E-03  +1.37412800E-02  +5.08741000E-03  +3.28663000E-03  -2.13666000E-03
   +2.34180000E-04  -1.16179000E-03  -1.51000000E-04  +2.77359000E-03  +2.76937000E-03
   -3.89104000E-03  +2.13780000E-04  +4.55530000E-04  +5.80080000E-04  -4.11400000E-05
   -1.49100000E-05  +6.79900000E-05  +6.60900000E-05  +6.76900000E-05  -5.68700000E-05
   +1.76350000E-04  -1.70010000E-04  -1.86600000E-05  +1.40200000E-05  +1.12540000E-04
   -5.91600000E-05  +3.64000000E-05  -1.50200000E-05  +1.49500000E-05  -3.18700000E-05
   -2.86800000E-05  -8.93000000E-06  -1.64000000E-06  +9.70000000E-06  +1.47000000E-06
   +6.36000000E-06  -1.76800000E-05  +3.76100000E-05  +3.68000000E-05  +2.61100000E-05
   +2.92000000E-06  +8.77170000E-04  +8.27200000E-05  -2.47300000E-05  -1.98174700E-02
   +3.41551900E-02  +8.33980000E-04  +1.79485000E-03  +2.05749000E-03  -2.09064400E-02
   +3.91794000E-03  -1.60427600E-02  -1.35124600E-01  -4.70800000E-05  -2.34682510E-01
   +2.78308000E-03  -5.61200000E-04  +4.91654000E-03  +2.32170000E-04  -1.71461000E-03
   +2.51848000E-03  +1.24961000E-03  -3.89480000E-04  -1.24400000E-04  +1.87037000E-03
   -4.24306000E-03  -3.19930000E-03  +1.89580000E-04  -1.61260000E-04  +1.04850000E-04
   -5.90900000E-05  +2.77100000E-05  -1.82400000E-05  -5.30000000E-06  -5.44600000E-05
   +2.27000000E-06  -3.55800000E-05  +6.26800000E-05  +5.33000000E-06  +3.12000000E-06
   -6.68500000E-05  +9.02000000E-06  -1.68500000E-05  +5.37000000E-06  -5.06000000E-06
   +5.18300000E-05  +3.06400000E-05  +3.49000000E-06  -1.31800000E-05  +5.48700000E-05
   -8.19000000E-06  -1.48300000E-05  +6.54000000E-06  -8.68000000E-06  -5.04300000E-05
   -4.32200000E-05  +3.10000000E-07  +1.54104000E-03  -1.36693000E-03  -9.74500000E-04
   +1.47818980E-01  +9.34520000E-04  +2.46070990E-01  -6.84150000E-04  +8.52750000E-04
   +1.26947000E-03  -2.50506000E-03  +4.92512000E-03  -1.49914000E-03  -2.89679000E-03
   +1.24720900E-02  +2.45902300E-02  -6.97297100E-02  +3.60833300E-02  +5.34674100E-02
   +1.02725300E-02  -8.64653000E-03  -1.55284600E-02  -8.72890000E-04  +2.51632000E-03
   -4.56300000E-03  -1.19659000E-03  -1.24030000E-04  -4.07640000E-04  -4.25100000E-04
   -1.73374000E-03  +8.76730000E-04  -1.85207000E-03  +1.48685000E-03  -1.07895000E-03
   +4.40750000E-04  +3.71900000E-05  +1.50830000E-04  -3.49310000E-04  +1.65090000E-04
   +3.09400000E-05  -6.08600000E-05  -3.90100000E-05  +5.70000000E-07  -2.68100000E-05
   +3.24100000E-05  +5.60000000E-07  -1.05520000E-04  -6.68600000E-05  -1.41700000E-05
   +3.28000000E-05  -1.14990000E-04  +1.69500000E-05  +6.32100000E-05  +4.22100000E-05
   +6.23800000E-05  +1.00770000E-04  +1.00770000E-04  +5.97000000E-06  +1.86850000E-04
   -6.41500000E-05  +1.46030000E-04  -1.55910000E-04  -2.04674000E-03  +5.07810000E-04
   +7.26639700E-02  +4.24190000E-04  -5.15590000E-04  -7.08060000E-04  +4.99277000E-03
   +4.51467000E-03  -9.41520000E-04  +3.19313000E-03  -2.96018000E-03  -1.40270400E-02
   +3.55649900E-02  -9.95127000E-02  -1.14056650E-01  -4.29400000E-05  +4.88202000E-03
   +1.05807000E-03  +2.55195000E-03  +5.10746000E-03  -9.27240000E-04  -2.20860000E-04
   -8.01530000E-04  +6.78160000E-04  -1.52041000E-03  -2.96052000E-03  +6.65700000E-04
   +2.12521000E-03  -3.65330000E-04  +3.99960000E-04  +4.93300000E-04  -2.87820000E-04
   +1.40800000E-05  -4.49360000E-04  +4.66490000E-04  -1.75260000E-04  -1.13300000E-04
   -1.56970000E-04  +3.03000000E-06  -8.00000000E-06  +3.33300000E-05  +4.70000000E-06
   +5.70200000E-05  +1.11400000E-05  -7.41000000E-06  -9.17000000E-05  -1.12900000E-05
   +1.64400000E-05  -5.36400000E-05  +1.23270000E-04  +7.01500000E-05  -2.88700000E-05
   -5.08100000E-05  +6.89000000E-06  -1.42100000E-04  +1.10800000E-05  -8.11900000E-05
   -1.86557000E-03  -2.69006000E-03  +1.42109000E-03  -4.62854500E-02  +9.72811100E-02
   +1.87490000E-04  -1.23190000E-04  -6.25000000E-05  -1.27789000E-03  -1.14177000E-03
   +2.56689000E-03  -1.50284000E-03  +1.10260000E-04  +1.80978000E-03  +5.30804500E-02
   -1.13241620E-01  -2.73457780E-01  +7.21406000E-03  -1.14831100E-02  -1.63455800E-02
   -4.73659000E-03  -8.36160000E-04  -2.37178000E-03  -4.97600000E-04  +8.08250000E-04
   +2.92790000E-04  +2.07414000E-03  -2.35800000E-05  -7.62170000E-04  +1.05505000E-03
   -8.11430000E-04  +2.95160000E-04  -3.23590000E-04  +9.95400000E-05  +7.37900000E-05
   +5.68800000E-05  -4.21300000E-05  +8.11300000E-05  +2.98200000E-05  +1.33000000E-06
   +1.08800000E-05  -2.72600000E-05  +1.20000000E-05  +3.20000000E-07  -5.56000000E-05
   -2.48900000E-05  -1.01200000E-05  +4.13800000E-05  -2.92900000E-05  +3.25000000E-06
   +1.25500000E-05  -5.08700000E-05  +6.94400000E-05  +3.79700000E-05  +5.30100000E-05
   +2.99000000E-06  -4.77600000E-05  +2.43700000E-05  -4.26100000E-05  +9.03700000E-04
   +1.20677000E-03  +4.24020000E-04  -5.78039600E-02  +1.25446720E-01  +2.87484130E-01
   -9.64190000E-04  +6.17800000E-05  -1.30986000E-03  -1.35034000E-03  +5.51171000E-03
   +6.11220000E-04  -5.93520000E-04  +3.66800000E-05  +9.03360000E-04  +1.75109000E-03
   +2.99115000E-03  +1.24350000E-03  +8.96935000E-03  -1.60690000E-04  +6.22003000E-03
   -1.56839250E-01  +1.03229400E-02  -1.36856650E-01  -1.23820300E-02  +2.59240000E-04
   -2.35134300E-02  -7.46020000E-04  -1.02238000E-03  +3.73820000E-04  +1.66650000E-04
   -1.14140000E-04  +1.97000000E-05  -6.51240000E-04  +9.40260000E-04  +2.36830000E-04
   -3.93250000E-04  +3.61100000E-05  +1.22670000E-04  -1.43200000E-05  +5.25400000E-05
   -1.87120000E-04  -3.33100000E-05  -3.01800000E-05  +3.57000000E-05  -1.66870000E-04
   -1.51700000E-05  -1.51100000E-05  +1.44500000E-04  -1.00970000E-04  +5.86100000E-05
   -2.20660000E-04  -1.60460000E-04  +2.51090000E-04  +1.18760000E-04  +9.77700000E-05
   -5.80000000E-06  -3.56590000E-04  +1.06710000E-04  +3.43400000E-05  -1.61490000E-04
   -2.89700000E-04  +3.61600000E-05  +3.30890000E-04  +3.00000000E-08  +4.70350000E-04
   +1.63869530E-01  +4.73130000E-04  +2.18500000E-05  +7.68510000E-04  +5.45037000E-03
   +4.47511000E-03  -2.70171000E-03  +1.75000000E-06  -1.09276000E-03  +2.53400000E-05
   +3.23069000E-03  +3.09674000E-03  -4.22655000E-03  -9.25011000E-03  +5.08796000E-03
   -1.06877500E-02  +1.01100900E-02  -4.59467900E-02  -1.44084000E-03  +1.05658800E-02
   +3.73750000E-03  +1.30347400E-02  -1.61819000E-03  -1.71303000E-03  +8.99520000E-04
   -4.48600000E-05  -2.46960000E-04  +1.69070000E-04  +3.31030000E-04  -6.75910000E-04
   -5.79330000E-04  -9.35300000E-05  +3.21950000E-04  -6.28600000E-05  -5.47300000E-05
   -2.67500000E-05  -9.79100000E-05  +5.12500000E-05  -1.76000000E-05  +2.76100000E-05
   +5.79500000E-05  +3.47400000E-05  +8.14000000E-06  -1.11870000E-04  +6.80000000E-07
   -3.81200000E-05  -6.07300000E-05  +1.57050000E-04  -1.43880000E-04  -3.44000000E-05
   -8.56400000E-05  -6.00000000E-08  +1.28840000E-04  -2.83600000E-04  +6.85300000E-05
   -3.05990000E-04  -4.80850000E-04  +2.07640000E-04  -5.36570000E-04  +1.28960000E-04
   -5.98580000E-04  -1.79204000E-02  +3.84287400E-02  -2.14440000E-04  +1.40050000E-04
   +8.66500000E-05  +3.47750000E-04  -2.52148000E-03  +2.30699000E-03  +1.01999000E-03
   -5.43400000E-05  +1.84340000E-04  +1.62938000E-03  -4.48411000E-03  -3.36906000E-03
   -1.79420100E-02  +2.05613000E-03  -1.61248800E-02  -1.36931670E-01  -1.22243000E-03
   -2.37577680E-01  +2.90185000E-03  -1.35640000E-03  +5.11196000E-03  -6.44460000E-04
   +1.64716000E-03  -4.60460000E-04  +1.10190000E-04  -5.60000000E-07  +5.31300000E-05
   -5.14950000E-04  +1.28320000E-04  -3.23940000E-04  +4.45940000E-04  -2.75960000E-04
   -3.16800000E-05  +3.26250000E-04  +2.92000000E-06  +9.34600000E-05  -8.71700000E-05
   -1.44380000E-04  -1.75400000E-05  +1.15870000E-04  +2.20830000E-04  -4.44200000E-05
   +1.43240000E-04  +3.43650000E-04  +4.92800000E-05  -9.29100000E-05  +4.28100000E-05
   +2.15180000E-04  -1.80730000E-04  -1.65550000E-04  +1.30000000E-07  +1.37810000E-04
   +1.56800000E-05  +2.61200000E-05  +3.32000000E-06  +2.31750000E-04  -9.33400000E-05
   -9.69510000E-04  +1.71520000E-04  -9.61530000E-04  +1.50024020E-01  +3.10603000E-03
   +2.49219910E-01  +6.56030000E-04  -1.66218000E-03  +1.43445000E-03  +9.45404000E-03
   -8.50655000E-03  -1.68813800E-02  -1.16426000E-03  +2.11366000E-03  -3.94723000E-03
   -1.34062000E-03  +5.09800000E-05  -5.14110000E-04  -2.49408000E-03  +5.00950000E-03
   -1.48041000E-03  -2.04274000E-03  +1.15158600E-02  +2.43852800E-02  -7.33537800E-02
   +4.19148600E-02  +5.88107300E-02  +3.72680000E-04  +4.61390000E-04  +1.09129000E-03
   -4.37330000E-04  +1.36990000E-04  -8.06400000E-05  +6.51600000E-05  -8.93200000E-05
   +1.18420000E-04  +8.83400000E-05  +1.12220000E-04  +1.26500000E-05  -9.21000000E-06
   -5.22000000E-05  +4.13000000E-06  -9.46000000E-06  -1.12500000E-05  -4.92000000E-06
   +3.65600000E-05  +2.43700000E-05  +2.81000000E-06  -4.73100000E-05  +1.12760000E-04
   -1.60000000E-07  -6.46600000E-05  -3.63700000E-05  -7.20200000E-05  -4.05200000E-05
   -5.53600000E-05  -8.40000000E-06  +4.33300000E-05  -1.96220000E-04  +3.25180000E-04
   +3.05580000E-04  -5.27250000E-04  -9.33010000E-04  -1.08670000E-04  -2.68150000E-04
   +1.78830000E-04  -2.23690000E-04  -2.27507000E-03  +6.01320000E-04  +7.03157400E-02
   -1.72450000E-03  -2.07168000E-03  +9.24340000E-04  +1.53228000E-03  +4.75801000E-03
   +1.38104000E-03  +1.97916000E-03  +4.01570000E-03  -7.13440000E-04  -2.11500000E-04
   -5.89670000E-04  +5.93600000E-04  +5.26778000E-03  +4.60559000E-03  -8.91850000E-04
   +2.46711000E-03  -3.39711000E-03  -1.35147700E-02  +4.10433600E-02  -1.00506030E-01
   -1.16066180E-01  -8.58100000E-05  +1.67960000E-04  -7.88810000E-04  +1.74560000E-04
   -8.26400000E-05  +1.30110000E-04  +7.93700000E-05  -1.14000000E-05  +4.02900000E-05
   -7.13400000E-05  -1.15520000E-04  +1.85000000E-05  +3.28600000E-05  +6.95100000E-05
   +2.53600000E-05  +1.28800000E-05  -3.04500000E-05  +9.34000000E-06  -4.41800000E-05
   +4.20000000E-07  -5.80000000E-06  +2.37100000E-05  +4.27800000E-05  +1.75600000E-05
   -5.25700000E-05  +1.11000000E-06  -3.37000000E-05  +3.58400000E-05  +1.64700000E-05
   +8.10000000E-07  -2.36600000E-04  -3.52810000E-04  +1.12560000E-04  -6.95400000E-05
   +4.31700000E-05  +1.81220000E-04  -2.83220000E-04  -5.15210000E-04  +1.31370000E-04
   -2.08263000E-03  -3.08961000E-03  +1.61532000E-03  -4.77452900E-02  +9.72749100E-02
   +1.09634000E-03  +1.13371000E-03  +1.39039000E-03  +1.04776400E-02  -1.36281100E-02
   -1.67323400E-02  -4.43671000E-03  -3.55130000E-04  -2.22521000E-03  -7.75340000E-04
   +8.42740000E-04  +2.12810000E-04  -1.15408000E-03  -1.26349000E-03  +2.55771000E-03
   -1.28815000E-03  +7.45790000E-04  +2.95427000E-03  +5.74965000E-02  -1.15417820E-01
   -2.66369000E-01  -2.46460000E-04  -3.10300000E-05  +5.98400000E-05  +7.46600000E-05
   +4.31000000E-06  +7.11000000E-06  +4.15800000E-05  +4.54000000E-06  -3.52200000E-05
   +1.07500000E-05  -4.08000000E-05  -1.45400000E-05  -1.02800000E-05  +3.80500000E-05
   -2.23800000E-05  +7.77000000E-06  +1.31000000E-05  +1.10000000E-06  -3.31800000E-05
   -2.62600000E-05  -3.56000000E-06  +2.64000000E-05  -1.19450000E-04  +4.77000000E-06
   +7.07700000E-05  +2.40200000E-05  +2.97600000E-05  +3.54600000E-05  +4.54300000E-05
   +2.41000000E-06  +2.36640000E-04  +1.59590000E-04  +2.73440000E-04  +3.40470000E-04
   -4.99360000E-04  -9.30150000E-04  +1.42920000E-04  +1.49810000E-04  -9.23000000E-05
   +1.05918000E-03  +1.27995000E-03  +3.10450000E-04  -6.31587700E-02  +1.26879660E-01
   +2.78684530E-01  +9.21300000E-05  -5.50800000E-05  +9.04000000E-06  -1.20060000E-04
   +1.53400000E-05  +3.05000000E-05  +9.71300000E-05  +2.75700000E-05  +9.12800000E-05
   -4.40760000E-04  +9.39530000E-04  -2.79560000E-04  +3.12620000E-04  +4.38280000E-04
   +4.85000000E-06  +2.27250000E-04  -1.33650000E-04  -4.94400000E-05  +1.26400000E-05
   +8.58000000E-06  -1.43500000E-05  +1.92912000E-03  +3.02099000E-03  +1.39991000E-03
   -2.00051690E-01  -1.30907550E-01  -1.73681300E-02  +7.94400000E-05  +2.19290000E-04
   -2.41000000E-05  +3.29430000E-04  -3.12000000E-04  +7.95800000E-05  +7.66100000E-05
   -5.13510000E-04  -1.99500000E-04  +2.25450000E-04  +3.58640000E-04  -9.06900000E-05
   +5.03210000E-04  -1.78320000E-04  +5.41300000E-05  -4.73310000E-04  +1.17830000E-04
   -1.51410000E-04  +7.82300000E-05  +6.13020000E-04  -3.27750000E-04  -1.89880000E-04
   -1.47640000E-04  +1.65900000E-05  -1.04600000E-05  -8.20000000E-07  -7.16000000E-06
   +3.55200000E-05  +1.95700000E-05  -1.21300000E-05  -5.87600000E-04  +1.02514000E-03
   +7.71300000E-05  +4.07000000E-06  +6.67000000E-06  -5.73000000E-06  +9.00000000E-06
   -3.13300000E-05  +2.01000000E-06  +2.16430900E-01  -1.83750000E-04  +1.17560000E-04
   +5.35800000E-05  +1.09380000E-04  -4.34200000E-05  +2.13120000E-04  +3.36120000E-04
   +8.47100000E-05  +2.74800000E-04  +1.33900000E-04  -1.11150000E-04  -7.19490000E-04
   -8.85570000E-04  +5.35850000E-04  +4.74780000E-04  +3.40670000E-04  -7.29600000E-05
   -2.67000000E-04  -2.74950000E-04  +1.56490000E-04  +6.27000000E-06  -1.29326300E-02
   -1.21333300E-02  -1.21381000E-03  -1.29565470E-01  -1.58004930E-01  -1.37953100E-02
   +1.18380000E-04  +3.85470000E-04  +1.07119000E-03  +8.47220000E-04  -1.04640000E-03
   -3.46714000E-03  +6.84890000E-04  -4.33590000E-04  +4.92200000E-05  -2.04210000E-04
   -3.37180000E-04  +1.42830000E-04  +3.25300000E-04  +4.21410000E-04  -2.70800000E-05
   -2.08540000E-04  +1.66810000E-04  +2.40120000E-04  -4.31340000E-04  +1.58870000E-04
   -1.82940000E-04  -4.71590000E-04  -4.63440000E-04  -1.67300000E-05  +4.24000000E-05
   -3.45100000E-05  -1.44000000E-06  +4.39000000E-06  -1.97700000E-05  -2.31400000E-05
   +5.48440000E-04  -1.17581000E-03  +7.44600000E-04  -1.57900000E-05  +7.99000000E-06
   +1.18500000E-04  -1.95900000E-05  -2.14100000E-05  +1.78700000E-05  +1.42360990E-01
   +1.70622770E-01  -9.57100000E-05  +4.47100000E-05  -3.70800000E-05  +1.56450000E-04
   +1.38800000E-05  +2.38300000E-04  +1.74200000E-04  -1.12920000E-04  -1.56950000E-04
   +1.54160000E-04  +6.32500000E-05  +5.74040000E-04  -5.28390000E-04  +7.25170000E-04
   +8.45240000E-04  +1.40630000E-04  +1.34300000E-04  -3.29030000E-04  -2.24210000E-04
   +8.28700000E-05  -5.91900000E-05  -2.14255100E-02  -1.73656200E-02  -3.20818000E-03
   -1.66132700E-02  -1.29418000E-02  -5.04804400E-02  -7.99450000E-04  -5.62690000E-04
   +1.29095000E-03  +1.35581000E-03  -2.53561000E-03  -3.84214000E-03  -7.80300000E-05
   -6.38890000E-04  +1.83960000E-04  +1.13600000E-05  +4.91500000E-05  +2.74600000E-05
   +4.72070000E-04  +1.92600000E-05  -4.85400000E-05  -5.09280000E-04  -7.72500000E-05
   +2.69200000E-04  -6.36550000E-04  -1.17800000E-04  -2.53300000E-05  -4.17640000E-04
   -3.64050000E-04  +1.43300000E-05  +4.16000000E-06  -3.14000000E-06  +1.23000000E-05
   -1.32600000E-05  -1.46300000E-05  +5.18000000E-06  +1.31600000E-05  +2.24010000E-04
   -6.75600000E-05  -1.99400000E-05  -4.15200000E-05  +2.10100000E-05  -3.07500000E-05
   -2.70100000E-05  +1.00400000E-05  +1.86745000E-02  +1.79148400E-02  +5.29219300E-02
   -2.20320000E-04  +1.08070000E-04  +3.32000000E-05  +1.63090000E-04  -5.47700000E-05
   +1.18950000E-04  +1.93690000E-04  +7.54200000E-05  +1.25740000E-04  +3.86000000E-06
   +9.39000000E-05  -3.14900000E-04  +6.99110000E-04  +1.57680000E-04  +2.93610000E-04
   +1.74700000E-04  +4.88600000E-05  -3.91590000E-04  -1.89470000E-04  +6.75400000E-05
   +5.06400000E-05  -2.97809000E-03  +4.77780000E-04  -3.90200000E-04  -2.48720230E-01
   +1.21267390E-01  -6.45548000E-03  +4.01800000E-05  -1.21540000E-04  -5.60960000E-04
   +6.39700000E-04  -7.79840000E-04  +1.12210000E-04  -3.30980000E-04  -7.20450000E-04
   -4.20250000E-04  +1.34200000E-04  +2.26580000E-04  -7.84900000E-05  +1.52050000E-04
   -1.92070000E-04  +4.38300000E-05  -1.88180000E-04  -1.04200000E-05  -6.88100000E-05
   +1.63500000E-05  +2.45390000E-04  -1.48170000E-04  +2.48800000E-05  +4.77200000E-05
   +6.09000000E-06  +4.03800000E-05  -1.49800000E-05  +5.03000000E-06  -1.44700000E-05
   +1.48800000E-05  -1.96500000E-05  -7.98500000E-05  -1.11910000E-04  +4.55180000E-04
   +4.42900000E-05  +3.37100000E-05  +7.30900000E-05  -3.99900000E-05  -2.13200000E-05
   +1.38600000E-05  -1.88705200E-02  +1.28280500E-02  -8.75570000E-04  +2.68066020E-01
   +1.89770000E-04  -1.21070000E-04  -6.18000000E-06  -1.61880000E-04  +6.91200000E-05
   +8.44000000E-05  +1.51450000E-04  -2.99000000E-06  -7.60000000E-05  -2.32790000E-04
   +3.67730000E-04  -3.76950000E-04  -7.43710000E-04  -8.68320000E-04  -2.88776000E-03
   +1.05776000E-03  -2.19990000E-04  +2.38350000E-04  -2.31300000E-05  -1.11810000E-04
   -2.89710000E-04  +1.46893300E-02  -1.04355500E-02  +2.20160000E-04  +1.19530730E-01
   -1.19708110E-01  +4.22845000E-03  -4.17590000E-04  +4.41070000E-04  +1.38965000E-03
   +1.04243000E-03  +3.67020000E-04  +3.35970000E-04  -2.41900000E-05  +3.10950000E-04
   +1.19050000E-04  -4.16420000E-04  -5.12790000E-04  +9.13200000E-05  -5.13860000E-04
   +3.14000000E-04  -8.89500000E-05  +6.18360000E-04  -7.89700000E-05  +2.33000000E-06
   -1.94850000E-04  -4.64880000E-04  +1.49380000E-04  +1.37980000E-04  +1.18920000E-04
   +2.99000000E-06  -2.40300000E-05  +1.38800000E-05  -8.94000000E-06  +4.80600000E-05
   +2.51000000E-06  +2.23000000E-06  -3.33740000E-04  -1.45220000E-04  +1.29390000E-04
   -3.08300000E-05  +2.29600000E-05  -5.73000000E-05  +6.64000000E-05  -7.87100000E-05
   +2.02000000E-06  -1.87397700E-02  +1.22213100E-02  -7.68610000E-04  -1.30821300E-01
   +1.27843740E-01  +1.59690000E-04  -6.04800000E-05  +5.74400000E-05  -2.26650000E-04
   +9.65500000E-05  -4.23700000E-05  +1.52980000E-04  +7.83000000E-06  +3.81440000E-04
   -8.28520000E-04  +8.25900000E-05  -9.41670000E-04  -9.80330000E-04  -2.51911000E-03
   -5.02888000E-03  +1.52334000E-03  -8.85010000E-04  +4.58450000E-04  +1.03590000E-04
   -6.25800000E-05  -3.95320000E-04  +2.44987500E-02  -1.47969700E-02  -1.48067000E-03
   -9.36476000E-03  +6.07529000E-03  -4.64916500E-02  +1.34411000E-03  -8.77490000E-04
   +1.31035000E-03  +6.80980000E-04  +1.03146000E-03  +4.58350000E-04  +2.04190000E-04
   -7.91370000E-04  +3.81000000E-06  -2.89040000E-04  -5.88000000E-06  -6.20300000E-05
   -2.75180000E-04  +1.81400000E-04  -1.62700000E-05  +3.77750000E-04  -5.42800000E-05
   +4.26100000E-05  -1.92320000E-04  -2.52430000E-04  +1.58460000E-04  +1.19080000E-04
   +1.30290000E-04  -1.47300000E-05  +1.57000000E-06  -8.84000000E-06  -1.44600000E-05
   +3.29200000E-05  -2.31000000E-05  -2.45000000E-06  +5.57100000E-05  +3.42970000E-04
   +5.28150000E-04  -5.46800000E-05  -3.20600000E-05  +2.55600000E-05  +1.45850000E-04
   -4.03600000E-05  -2.03500000E-05  -1.80537000E-03  +1.63456000E-03  -1.05189000E-03
   +9.05575000E-03  -1.89837000E-03  +5.38983800E-02  +1.30830000E-04  -8.56500000E-05
   -5.11300000E-05  -5.46800000E-05  +4.64900000E-05  -3.44800000E-05  -4.24500000E-05
   -3.42100000E-05  -2.52010000E-04  -5.39820000E-04  +2.25900000E-04  +8.84330000E-04
   +1.82690000E-04  -3.52720000E-04  -1.99400000E-05  -5.10100000E-05  +6.54000000E-05
   -5.72700000E-05  +9.50400000E-05  -7.18900000E-05  -3.89000000E-05  -1.66257000E-03
   -2.28240000E-03  +1.87347000E-03  -4.74222700E-02  -3.53323000E-03  +4.35643000E-03
   -4.86000000E-06  +4.76160000E-04  +2.03360000E-04  +6.69300000E-05  +2.40510000E-04
   -6.65100000E-04  -5.23900000E-05  +5.54140000E-04  +9.82400000E-05  -8.17300000E-05
   -2.31780000E-04  +1.02690000E-04  -1.65940000E-04  +3.13800000E-05  -3.22400000E-05
   +1.05850000E-04  -5.30100000E-05  +1.39100000E-05  +9.76600000E-05  -1.53600000E-04
   +6.07100000E-05  +5.66600000E-05  +3.73400000E-05  +1.28100000E-05  -3.59300000E-05
   +1.75700000E-05  +5.27000000E-06  -1.18500000E-05  -1.55800000E-05  +2.74800000E-05
   -2.57365000E-03  +6.74140000E-04  +3.53590000E-04  -2.50000000E-06  -4.65700000E-05
   -6.52700000E-05  +4.78000000E-06  -8.63000000E-06  -8.20000000E-06  -2.22100000E-05
   -1.37741900E-02  +2.04793500E-02  +1.87045000E-03  +1.61018000E-02  -2.29953100E-02
   +4.91224600E-02  -5.26100000E-05  +4.55000000E-06  -5.66600000E-05  +1.34330000E-04
   -5.52500000E-05  +1.85650000E-04  +2.47300000E-05  -1.39140000E-04  -3.71350000E-04
   +1.01789000E-03  +7.00300000E-05  +5.96180000E-04  -5.32900000E-05  +4.76640000E-04
   +4.89150000E-04  -2.05860000E-04  -6.41600000E-05  -6.19800000E-05  -1.12510000E-04
   +3.45000000E-05  -3.64200000E-05  -6.51860000E-04  +1.06339100E-02  -1.46090500E-02
   -4.14105000E-03  -1.44729630E-01  +1.29450870E-01  +3.85550000E-04  -1.45723000E-03
   -2.66246000E-03  +1.89980000E-04  +1.38214000E-03  -6.22740000E-04  +8.38700000E-05
   -1.75220000E-04  +7.03700000E-05  +4.50000000E-06  +1.58550000E-04  -2.79500000E-05
   -5.49200000E-05  -1.19050000E-04  +6.11000000E-06  -5.72000000E-05  -1.46090000E-04
   +3.60200000E-05  +2.26990000E-04  +1.74860000E-04  +1.90790000E-04  +1.33890000E-04
   +1.34450000E-04  -9.96000000E-06  -5.88000000E-06  +7.95000000E-06  +1.27700000E-05
   +4.97000000E-06  +3.18400000E-05  +2.60000000E-06  +1.04917000E-03  -2.55420000E-04
   -5.24650000E-04  -5.01000000E-06  +3.07800000E-05  -2.61500000E-05  -1.02400000E-05
   +1.65800000E-05  -8.14000000E-06  +1.67192000E-03  -1.15928300E-02  +1.56335900E-02
   -1.90251000E-03  -9.82552000E-03  +1.24694200E-02  +2.14642000E-03  +1.54486130E-01
   -3.08000000E-06  +1.37000000E-05  +4.98000000E-05  -2.10000000E-07  +1.28230000E-04
   +1.36730000E-04  +2.59450000E-04  -6.89500000E-05  +3.84130000E-04  -6.22160000E-04
   -2.06890000E-04  -1.85450000E-04  -8.56290000E-04  +6.49990000E-04  +5.72730000E-04
   +1.19090000E-04  -3.74970000E-04  -1.14090000E-04  -1.64210000E-04  +1.15710000E-04
   +4.65700000E-05  -6.08800000E-04  +1.70765100E-02  -2.07412500E-02  +4.15669000E-03
   +1.27312750E-01  -2.18329390E-01  +2.35270000E-04  -4.58626000E-03  -4.56965000E-03
   +1.12953000E-03  +1.10269000E-03  +6.77330000E-04  -5.77280000E-04  +1.53850000E-04
   +2.07210000E-04  +8.45000000E-05  +1.51530000E-04  -3.37400000E-05  +3.33100000E-05
   -2.01630000E-04  -4.01800000E-05  -1.42570000E-04  -2.24450000E-04  -6.05000000E-05
   -1.13100000E-04  -2.45080000E-04  +2.52190000E-04  +8.59600000E-05  +7.11100000E-05
   +2.72800000E-05  +2.27600000E-05  -8.85000000E-06  -1.10400000E-05  +2.02800000E-05
   -2.74500000E-05  -1.25400000E-05  +3.91720000E-04  +1.93250000E-04  +6.15910000E-04
   -2.25300000E-05  +1.41510000E-04  +9.78900000E-05  +2.29400000E-05  +1.68800000E-05
   -1.14900000E-05  +8.38000000E-06  -2.83273000E-03  +3.36818000E-03  +1.13240000E-04
   -5.41800000E-05  -3.32820000E-04  -3.95448000E-03  -1.38990990E-01  +2.39064080E-01
   +1.04370000E-04  -4.60200000E-05  +1.17300000E-05  -5.22900000E-05  +8.20000000E-05
   +1.61610000E-04  +2.44000000E-04  -1.09690000E-04  -2.72400000E-05  -2.41740000E-04
   +1.00970000E-04  -2.29400000E-05  +2.43990000E-04  -6.41960000E-04  -1.07630000E-04
   -6.00960000E-04  +4.61780000E-04  -5.82110000E-04  -2.30500000E-04  +1.67600000E-05
   +1.28510000E-04  -1.91138000E-03  -8.76090000E-04  -4.21350000E-04  +1.45300000E-05
   +1.01610000E-04  +2.56850000E-04  -4.75289300E-02  -3.24184000E-03  -7.01138000E-03
   +3.24500000E-04  +2.17920000E-04  +8.07120000E-04  -3.02900000E-05  +4.21660000E-04
   -1.74980000E-04  -8.71400000E-05  -2.17270000E-04  -7.09200000E-05  -1.97520000E-04
   +2.27700000E-05  -9.00000000E-08  +1.54230000E-04  -7.02500000E-05  +4.97000000E-06
   +3.67100000E-05  -1.08590000E-04  -1.52400000E-05  +8.07400000E-05  +7.24000000E-05
   -4.03000000E-06  -1.46400000E-05  +1.47500000E-05  -3.51000000E-06  +1.22100000E-05
   -3.49000000E-06  +8.60000000E-06  +3.19300000E-05  -9.94000000E-06  +5.84800000E-05
   -3.48670000E-04  +1.66624000E-03  -8.50300000E-05  +1.47000000E-06  +2.23000000E-05
   -1.16600000E-05  +1.20400000E-04  +2.53920000E-04  +2.86210000E-04  +2.68210000E-04
   -2.47500000E-04  -2.32580000E-04  +6.33640000E-04  +6.85200000E-05  +7.09400000E-05
   +4.67542800E-02  -1.03400000E-04  +5.08600000E-05  +2.15700000E-05  +8.00500000E-05
   +1.71200000E-05  -2.35890000E-04  -1.68770000E-04  +8.83500000E-05  +1.00860000E-04
   +2.44350000E-04  +1.11610000E-04  +4.62500000E-05  -4.38680000E-04  +8.04710000E-04
   -7.20690000E-04  +7.12830000E-04  -1.31351000E-03  +4.28180000E-04  +8.19000000E-05
   -5.76900000E-05  -3.41000000E-06  -8.86000000E-06  +9.92187000E-03  +1.91016000E-02
   +3.70350000E-04  -2.60765000E-03  +3.02892000E-03  -3.90695000E-03  -1.11678720E-01
   -1.16567590E-01  +2.84280000E-04  +1.70561000E-03  +8.08500000E-05  -2.72300000E-05
   -1.15640000E-04  -4.75900000E-05  -2.96600000E-05  +1.21400000E-04  -7.86000000E-06
   -9.20200000E-05  -5.69300000E-05  -1.70000000E-06  +5.15500000E-05  -4.71400000E-05
   +3.96000000E-05  +2.11180000E-04  -2.53700000E-05  -1.55720000E-04  +1.28240000E-04
   +1.21310000E-04  +5.79000000E-06  +1.21900000E-05  -1.00100000E-05  +6.92000000E-06
   -2.53000000E-05  -1.69200000E-05  +9.59000000E-06  -5.52100000E-05  -2.87000000E-06
   -1.79100000E-05  +1.73191000E-03  -1.91965000E-03  +3.78950000E-04  -1.59300000E-05
   -3.23700000E-05  +1.78100000E-05  +2.39450000E-04  +3.18300000E-05  +1.71250000E-04
   -2.24240000E-04  -7.21800000E-05  +8.68800000E-05  -6.30300000E-05  +8.58790000E-04
   +1.16641000E-03  +2.19862000E-03  +1.21947230E-01  -5.60000000E-07  +4.57200000E-05
   +5.60100000E-05  +1.67600000E-04  +6.51200000E-05  +2.19870000E-04  +3.08100000E-04
   -1.81930000E-04  +4.41000000E-05  -4.87750000E-04  +8.43000000E-05  -1.77120000E-04
   +1.28534000E-03  -5.94340000E-04  +2.68340000E-04  +1.22520000E-04  -1.08221000E-03
   -6.43860000E-04  -2.88000000E-04  +1.64090000E-04  +5.05530000E-04  -1.05470000E-04
   -1.26907500E-02  -2.03217000E-02  -2.36210000E-04  +4.84356000E-03  -3.52803000E-03
   -7.74220000E-03  -1.13783940E-01  -2.52305780E-01  -1.02181000E-03  -1.23279000E-03
   +9.20670000E-04  +2.57080000E-04  -1.27610000E-04  +3.14590000E-04  +1.49260000E-04
   +1.54390000E-04  -2.98300000E-05  +1.89890000E-04  -9.06200000E-05  +8.80000000E-07
   -2.51480000E-04  +5.38200000E-05  -1.21010000E-04  +2.18770000E-04  +5.03560000E-04
   +1.50710000E-04  -6.39300000E-05  -2.96500000E-05  +2.06700000E-05  +1.03800000E-05
   +5.10000000E-07  +9.20000000E-07  -1.78000000E-06  +2.02800000E-05  -8.10000000E-06
   +1.57060000E-04  -3.15900000E-05  +1.06060000E-04  +3.10740000E-04  +2.52410000E-04
   +1.04764000E-03  -5.54000000E-05  -1.15500000E-05  -2.89000000E-06  -7.80400000E-05
   +2.89400000E-05  +3.34970000E-04  -9.82400000E-05  +1.24170000E-04  +3.06290000E-04
   +9.19900000E-05  -8.03380000E-04  -1.56421000E-03  +7.03710000E-03  +1.24187350E-01
   +2.75219820E-01  -2.22360000E-04  +1.35550000E-04  +3.04800000E-05  +1.64580000E-04
   -1.66160000E-04  -2.36490000E-04  -2.05540000E-04  +1.39670000E-04  +1.95430000E-04
   +6.55630000E-04  +4.66200000E-05  +3.02590000E-04  +3.90050000E-04  +4.70400000E-04
   -3.07650000E-04  +9.95700000E-05  -1.08770000E-04  -3.16330000E-04  +1.21030000E-04
   -7.05700000E-05  +3.60200000E-05  -4.54030000E-04  -5.30900000E-04  -2.88400000E-05
   +2.25380000E-04  -3.74120000E-04  +4.12930000E-04  -2.29281540E-01  +1.29410550E-01
   +1.65648700E-02  +5.38330000E-04  +3.90050000E-04  -4.39180000E-04  -3.40620000E-04
   -1.74553000E-03  +4.65740000E-04  -1.05000000E-04  +2.04590000E-04  +3.25000000E-06
   -4.64200000E-05  -8.05900000E-05  -1.35500000E-05  +4.98400000E-05  -9.21500000E-05
   +3.55900000E-05  -2.26530000E-04  +4.98000000E-05  +1.65000000E-06  +6.56500000E-05
   +1.13970000E-04  -3.08000000E-06  +2.96000000E-05  -9.89000000E-06  +1.69800000E-05
   -1.70400000E-05  -6.51000000E-06  +2.79000000E-06  -1.98300000E-05  -9.71000000E-06
   -4.59600000E-05  -4.84300000E-05  +2.55100000E-05  +7.79100000E-05  -9.98000000E-06
   +3.20000000E-07  +6.95000000E-06  -1.72910000E-04  +1.04510000E-04  -8.98900000E-05
   +4.28040000E-04  -1.15540000E-04  -2.07730000E-04  +1.75450000E-04  -2.21450000E-04
   +1.27940000E-04  +2.71585000E-03  -2.79276000E-03  -2.92880000E-04  +2.49109050E-01
   +3.40010000E-04  -1.79340000E-04  -3.17100000E-05  -2.00460000E-04  +1.21490000E-04
   +2.45450000E-04  +4.04830000E-04  +4.66000000E-06  +5.70000000E-07  +3.38300000E-04
   -5.64560000E-04  -3.79870000E-04  -2.44950000E-04  -1.51913000E-03  +3.24468000E-03
   +1.89220000E-04  +3.68600000E-05  +1.31280000E-04  -3.98700000E-05  -2.47800000E-05
   +1.26140000E-04  +1.67147400E-02  -1.22206200E-02  -1.72031000E-03  +1.52200000E-05
   +6.71810000E-04  -1.65278000E-03  +1.26825910E-01  -1.39958720E-01  -1.21309400E-02
   +7.27640000E-04  +6.24820000E-04  -3.66320000E-04  +1.18700000E-05  -4.70630000E-04
   -5.24000000E-06  -3.64610000E-04  -2.30030000E-04  -8.52200000E-05  -3.49780000E-04
   +2.22030000E-04  -4.15700000E-05  +4.31000000E-04  -8.33900000E-05  +3.26800000E-05
   -1.91560000E-04  -2.87080000E-04  -9.64000000E-05  +8.78300000E-05  +1.13020000E-04
   +7.32000000E-06  -3.61500000E-05  +2.28800000E-05  -2.12800000E-05  +1.12880000E-04
   -2.62000000E-06  -9.96000000E-06  -4.12100000E-05  -3.66700000E-05  +8.51000000E-05
   -5.45200000E-05  +2.86570000E-04  +7.71100000E-05  +2.11100000E-05  -2.70400000E-05
   -1.74100000E-05  -1.21670000E-04  +1.78500000E-05  +1.17170000E-04  -2.69840000E-04
   +6.15530000E-04  +3.00330000E-04  -2.78160000E-04  -2.72100000E-05  -2.30860000E-04
   +1.19693300E-02  -8.86021000E-03  -4.19460000E-04  -1.39611980E-01  +1.49243880E-01
   -3.75150000E-04  +2.77650000E-04  +5.60600000E-05  +2.88880000E-04  -1.35920000E-04
   -1.48950000E-04  -3.40240000E-04  -2.38520000E-04  +1.75090000E-04  -7.30800000E-04
   +6.66090000E-04  +3.26600000E-04  +8.97500000E-04  +2.72528000E-03  -4.18206000E-03
   -4.56200000E-05  -5.07010000E-04  -4.29620000E-04  -2.22820000E-04  -8.78800000E-05
   +1.74840000E-04  -2.13546600E-02  +1.48936000E-02  -4.24400000E-05  -1.36168000E-03
   +8.85190000E-04  +1.17394000E-03  +1.92168200E-02  -1.45561000E-02  -4.95748500E-02
   -3.35860000E-04  -9.95750000E-04  +5.26370000E-04  +1.03140000E-04  +4.80770000E-04
   -2.02030000E-04  +1.74240000E-04  -4.26900000E-05  -2.01000000E-06  +1.22870000E-04
   -8.89800000E-05  +5.18300000E-05  -1.92490000E-04  +8.23000000E-06  -1.10000000E-07
   +8.87400000E-05  +1.74760000E-04  +6.83500000E-05  -5.17100000E-05  -6.59400000E-05
   -1.02700000E-05  +4.05000000E-05  -1.02400000E-05  +3.25200000E-05  -1.04470000E-04
   +3.16800000E-05  -2.44000000E-06  +5.77700000E-05  +1.66470000E-04  -6.95300000E-05
   +2.30900000E-04  +3.85930000E-04  +3.54930000E-04  -3.97300000E-05  +5.08000000E-06
   +1.65000000E-05  -3.25700000E-05  -1.01030000E-04  -4.85100000E-05  +4.47110000E-04
   +2.46000000E-05  -9.73010000E-04  +1.62700000E-04  -1.73150000E-04  +3.20980000E-04
   +2.38175500E-02  -1.54664300E-02  -1.30145000E-03  -1.97350500E-02  +1.07465500E-02
   +5.52004100E-02  +7.63200000E-05  -1.21300000E-05  +1.11000000E-06  -8.02800000E-05
   -1.31400000E-05  -8.74900000E-05  -6.61800000E-05  +1.11300000E-05  +1.24850000E-04
   +4.52320000E-04  -1.92900000E-04  -9.12000000E-06  +6.98960000E-04  +1.34672000E-03
   -2.03730000E-04  +1.10420000E-04  +8.45300000E-05  -1.74640000E-04  +5.25200000E-05
   -1.16930000E-04  +7.12700000E-05  +6.51150000E-04  +2.30352000E-03  -1.37244000E-03
   -1.41160000E-04  +1.52750000E-04  +4.36300000E-05  -2.25174260E-01  -1.27720830E-01
   -3.55944000E-03  +4.63240000E-04  -8.19100000E-05  -3.06900000E-04  +4.49700000E-05
   +1.43500000E-04  +6.97000000E-05  +1.84230000E-04  +7.08800000E-05  +1.12980000E-04
   +2.88160000E-04  -2.52300000E-05  +4.08700000E-05  -2.06400000E-04  +1.69350000E-04
   +7.88300000E-05  -1.11000000E-06  +4.39980000E-04  +1.96970000E-04  -1.44860000E-04
   -1.62170000E-04  -2.82600000E-05  -1.05600000E-05  +8.30000000E-07  -1.39000000E-06
   +2.09100000E-05  -2.07100000E-05  +7.12000000E-06  +2.03100000E-05  +1.12600000E-05
   +8.75000000E-06  +3.35400000E-05  +1.15100000E-05  +6.44000000E-05  +4.31000000E-06
   -1.24900000E-05  +5.00000000E-07  +1.96970000E-04  +9.70000000E-05  +4.42540000E-04
   -3.43700000E-05  -1.27760000E-04  -4.02600000E-05  +1.82830000E-04  +2.24230000E-04
   +1.00910000E-04  -9.81000000E-05  +1.20786000E-03  +2.26140000E-04  -1.87274400E-02
   -1.63598300E-02  -1.19158000E-03  +2.41366880E-01  -2.45640000E-04  +1.75170000E-04
   +2.85000000E-05  +1.62450000E-04  -2.37940000E-04  -2.24760000E-04  -1.91730000E-04
   +1.16280000E-04  +2.09580000E-04  +5.39780000E-04  +9.90000000E-06  +1.91770000E-04
   -1.29106000E-03  +5.28980000E-04  -2.87210000E-04  +1.53440000E-04  -1.27700000E-05
   -4.67260000E-04  +2.74490000E-04  -1.52000000E-05  -4.33000000E-06  -1.65671600E-02
   -1.42520300E-02  +3.40000000E-06  +1.28820000E-04  +3.64330000E-04  -1.10565000E-03
   -1.25408240E-01  -1.36334890E-01  -3.83569000E-03  +1.15364000E-03  -1.83099000E-03
   +3.80497000E-03  +5.16650000E-04  -8.55610000E-04  +3.73100000E-05  -7.89500000E-05
   +6.46400000E-05  -1.14860000E-04  +5.17120000E-04  +1.56780000E-04  +8.31100000E-05
   -3.44490000E-04  -2.84600000E-05  -3.15010000E-04  -8.16730000E-04  +6.76100000E-05
   +8.74200000E-05  -4.51220000E-04  -3.87510000E-04  +1.27000000E-06  +3.40800000E-05
   -3.10500000E-05  +2.30500000E-05  -1.78000000E-05  -9.94000000E-06  -3.71000000E-06
   -2.32400000E-05  +1.04000000E-06  -8.92000000E-06  -1.89170000E-04  -1.90200000E-05
   +1.11370000E-04  -8.99000000E-06  -2.29100000E-05  +1.27500000E-05  +7.61700000E-05
   +5.41390000E-04  +2.73120000E-04  +1.14460000E-04  +4.43600000E-05  +6.84400000E-05
   +2.57610000E-04  +3.08600000E-05  -3.89100000E-05  -1.23016800E-02  -8.95290000E-03
   +5.89010000E-04  +1.51798900E-02  +1.28174600E-02  +6.81230000E-04  +1.38688860E-01
   +1.48117090E-01  +1.62750000E-04  -1.05680000E-04  -5.01000000E-06  -8.97300000E-05
   +3.47800000E-05  -2.47200000E-05  -2.76600000E-05  +2.78900000E-05  -9.50800000E-05
   -9.26800000E-05  -2.20050000E-04  +2.88000000E-06  +8.73110000E-04  -4.53570000E-04
   +8.72000000E-04  -1.68050000E-04  -4.96000000E-06  -1.12550000E-04  +2.28450000E-04
   +8.09800000E-05  +1.22920000E-04  +2.02576400E-02  +1.48946000E-02  -8.63920000E-04
   +8.31320000E-04  +4.30410000E-04  +1.21990000E-03  -4.93342000E-03  -4.55685000E-03
   -4.80230200E-02  -1.14297000E-03  +2.66173000E-03  -3.24256000E-03  -2.03870000E-04
   +4.19050000E-04  +2.39440000E-04  +8.58500000E-05  +4.37300000E-05  +2.59700000E-05
   -1.82580000E-04  -8.45100000E-05  -9.97100000E-05  +1.96200000E-05  +1.75580000E-04
   +2.22380000E-04  +1.01629000E-03  +4.69410000E-04  +3.45100000E-05  +2.30520000E-04
   +1.99240000E-04  +2.21700000E-05  -1.64600000E-05  +2.45000000E-06  -6.57000000E-06
   +1.77200000E-05  +1.55600000E-05  +1.15000000E-06  -2.11700000E-05  +3.21700000E-05
   -4.25400000E-05  -1.99280000E-04  +1.55000000E-05  +8.78000000E-06  -6.68000000E-06
   -6.40000000E-06  -1.07800000E-05  -3.12240000E-04  -2.21460000E-04  -6.04330000E-04
   -1.33300000E-05  -3.92500000E-05  -6.95700000E-05  -2.95930000E-04  -2.05330000E-04
   +2.43460000E-04  -2.39423500E-02  -1.55817700E-02  +6.21640000E-04  +2.38478000E-03
   +1.93012000E-03  -9.12040000E-04  +5.34040000E-03  +2.30030000E-04  +5.06052600E-02
   -7.22400000E-05  +3.88200000E-05  +5.24000000E-06  +5.43300000E-05  -3.25700000E-05
   -4.63000000E-06  -1.18700000E-05  +3.42500000E-05  +3.63000000E-06  -3.67100000E-05
   +2.73000000E-05  +4.38900000E-05  -1.12550000E-04  -2.79450000E-04  -3.99200000E-05
   +3.79000000E-06  +2.54000000E-06  -3.40600000E-05  -2.53200000E-05  +2.10000000E-05
   -1.83600000E-05  -3.44360000E-04  +8.14630000E-04  -5.44100000E-05  -5.22300000E-05
   +2.17300000E-05  +6.17800000E-05  -2.24700000E-05  +3.67400000E-05  -4.34800000E-05
   -1.62120000E-03  -3.51366000E-03  -2.59320000E-04  -1.76964100E-02  +8.69599000E-03
   -1.95740000E-03  -3.03678980E-01  +9.88628000E-02  -2.55117600E-02  -1.48879000E-03
   -8.67920000E-04  -4.44670000E-04  +9.31840000E-04  +2.31400000E-04  -3.30090000E-04
   +7.41260000E-04  -4.93520000E-04  +1.66610000E-04  +6.26520000E-04  +1.35970000E-04
   +2.94290000E-04  +8.90000000E-06  -3.37000000E-06  +3.97000000E-06  -9.83000000E-06
   +6.53000000E-06  -3.09000000E-06  -1.74000000E-06  -1.20300000E-05  +5.20000000E-07
   +2.35000000E-06  -9.21000000E-06  +3.99000000E-06  -5.75000000E-06  +4.65000000E-06
   +2.18000000E-06  -8.53000000E-06  -3.34900000E-05  -3.58100000E-05  +7.64000000E-06
   -2.25000000E-06  -6.65000000E-06  +3.29000000E-06  -1.82000000E-06  -5.84000000E-06
   +1.43000000E-06  -6.80000000E-07  +1.06900000E-05  -1.62300000E-05  -6.18000000E-06
   +6.60000000E-06  -2.65000000E-06  -3.62500000E-05  +2.99800000E-05  +3.22637130E-01
   -3.41100000E-05  +1.89700000E-05  +3.25000000E-06  +1.74900000E-05  -1.64100000E-05
   -1.54500000E-05  -1.29900000E-05  +3.13800000E-05  +2.90000000E-07  -2.20300000E-05
   +2.11100000E-05  +2.63300000E-05  -1.08240000E-04  -2.29170000E-04  -5.04100000E-05
   -7.14000000E-06  +6.71000000E-06  -1.02100000E-05  -2.94000000E-06  +1.09700000E-05
   -7.12000000E-06  -5.78610000E-04  +6.60130000E-04  +2.54700000E-05  -7.21000000E-06
   +5.73800000E-05  +4.99000000E-05  +9.72000000E-06  +9.43500000E-05  -3.89200000E-05
   -4.03600000E-03  -2.07779000E-03  +1.44570000E-04  -1.78655400E-02  +1.15115000E-02
   -1.88404000E-03  +9.64254300E-02  -9.64921500E-02  +1.08761300E-02  +3.07885800E-02
   -5.14975000E-03  +2.97293000E-03  -6.31490000E-04  -4.64024000E-03  +7.42360000E-04
   -5.02150000E-04  -1.49974000E-03  -4.61200000E-05  -6.59880000E-04  +2.71572000E-03
   -5.07930000E-04  +2.49000000E-06  -1.09000000E-06  +2.52000000E-06  -5.32000000E-06
   +4.87000000E-06  -1.60000000E-06  -5.61000000E-06  -9.87000000E-06  -1.56000000E-06
   +5.00000000E-08  -2.76000000E-06  +5.11000000E-06  -3.47000000E-06  +6.60000000E-07
   +2.43000000E-06  +6.52000000E-06  -2.12400000E-05  -1.13000000E-05  +7.75000000E-06
   -1.84800000E-05  -3.00000000E-05  +7.38000000E-06  -8.26000000E-06  -4.90000000E-07
   +3.41000000E-06  -7.99000000E-06  +7.86000000E-06  -4.35400000E-05  -4.34600000E-05
   +2.01500000E-05  +2.16000000E-05  -2.96700000E-05  +1.11300000E-05  -1.04332940E-01
   +9.50165400E-02  -3.40000000E-07  +5.19000000E-06  +5.22000000E-06  -2.25600000E-05
   -2.99800000E-05  -9.88800000E-05  -7.22200000E-05  +4.81100000E-05  +3.13300000E-05
   +6.48000000E-05  -2.87800000E-05  +5.17900000E-05  -1.16040000E-04  -6.08000000E-06
   -1.46310000E-04  -8.94000000E-05  +9.67000000E-06  +4.81000000E-06  +8.68600000E-05
   -5.33300000E-05  +3.76700000E-05  +5.28200000E-05  +3.93500000E-05  +5.40060000E-04
   -7.11000000E-06  -1.57300000E-05  -3.50200000E-05  -2.61400000E-05  +4.37700000E-05
   -3.46400000E-05  -2.73760000E-04  +1.51200000E-04  +5.12308000E-03  +1.65070000E-04
   +2.22800000E-05  +1.54274000E-03  -2.46213300E-02  +1.01958400E-02  -3.71344500E-02
   -3.06341000E-03  +1.09942000E-03  +6.18743000E-03  -4.65880000E-04  +8.08190000E-04
   +6.19424000E-03  +3.15690000E-04  -4.70700000E-05  -1.43565000E-03  +2.93590000E-04
   -5.99140000E-04  -3.80398000E-03  +2.99000000E-06  -1.70000000E-07  +7.10000000E-07
   -2.70000000E-07  +9.33000000E-06  -1.42000000E-06  -1.90000000E-07  -2.71000000E-06
   -3.07000000E-06  +2.08300000E-05  +2.28400000E-05  -5.86000000E-06  +2.89000000E-06
   -3.07000000E-06  +2.22000000E-06  -8.63000000E-06  +1.26800000E-05  -1.58600000E-05
   -6.89000000E-06  -1.49800000E-05  +1.77400000E-05  -1.26500000E-05  +1.92600000E-05
   -1.14300000E-05  +1.81900000E-05  -4.22000000E-06  -2.30900000E-05  -5.21000000E-06
   +1.11900000E-05  +5.82000000E-06  +1.75000000E-06  -1.77100000E-05  +1.70000000E-07
   +2.77672700E-02  -1.23339600E-02  +2.66517600E-02  +4.50440000E-04  -2.74650000E-04
   +7.20000000E-06  -5.20360000E-04  +3.81570000E-04  -2.09220000E-04  -1.92000000E-06
   +1.46330000E-04  -1.28540000E-04  -1.65430000E-04  -4.49130000E-04  +1.92770000E-04
   -8.27930000E-04  -2.96443000E-03  +3.12740000E-04  -1.73672000E-03  -1.44055000E-03
   +1.14707000E-03  +2.86430000E-04  -1.79280000E-04  +3.10100000E-04  -1.35135000E-03
   -4.85260000E-04  +2.83910000E-04  +7.78000000E-06  +1.11840000E-04  -1.36040000E-04
   -9.74400000E-05  +6.64500000E-05  +1.07160000E-04  -9.86060000E-04  +2.54820000E-03
   -4.03790000E-04  +1.21173000E-03  +1.25019000E-03  -3.70460000E-04  +3.92330000E-04
   -9.94260000E-04  +2.13120000E-04  -1.03233000E-03  -3.26808000E-03  -3.35290000E-04
   -1.88972700E-02  +1.26293800E-02  -3.18985000E-03  -2.92882070E-01  +9.61585500E-02
   -3.19487900E-02  -1.23160000E-03  +1.26900000E-05  -1.55600000E-05  -4.90600000E-05
   +3.49500000E-05  -3.40700000E-05  +2.38400000E-05  -6.25000000E-06  +3.09300000E-05
   +7.98700000E-05  +1.21660000E-04  +3.03500000E-05  +6.28500000E-05  +2.28870000E-04
   -2.68830000E-04  +4.75300000E-05  +9.58000000E-06  -3.65900000E-05  +3.91100000E-05
   -1.12900000E-05  +4.24200000E-05  -1.25000000E-05  +1.10600000E-05  +2.18400000E-05
   +2.67500000E-05  +4.05600000E-05  +3.93400000E-05  +1.73100000E-05  -2.93000000E-06
   +8.68000000E-06  +3.61000000E-06  +4.46400000E-05  -3.57600000E-05  +8.49200000E-05
   -2.35300000E-05  +1.03900000E-05  -8.28700000E-05  -3.23000000E-06  -2.44600000E-05
   +3.15037370E-01  +6.36730000E-04  -3.52600000E-04  -4.77100000E-05  -5.16130000E-04
   +2.39780000E-04  +2.50510000E-04  +1.53990000E-04  -2.40860000E-04  -2.38000000E-04
   -8.99410000E-04  +2.84290000E-04  -5.15250000E-04  -1.29380000E-04  -9.42590000E-04
   +4.38000000E-05  -6.59440000E-04  +2.68410000E-04  +7.30510000E-04  -3.89900000E-05
   -1.54000000E-05  +8.21800000E-05  +1.15768000E-03  +1.13671000E-03  -3.48360000E-04
   -2.21570000E-04  -9.84900000E-05  +3.89200000E-05  -7.91800000E-05  +1.38630000E-04
   +4.85200000E-05  +2.82255400E-02  -6.79286000E-03  +3.48521000E-03  +7.06720000E-04
   -4.10430000E-03  +8.58270000E-04  -8.03380000E-04  -1.10771000E-03  -1.34120000E-04
   -2.86958000E-03  -2.35426000E-03  +4.20690000E-04  -1.84357900E-02  +7.85196000E-03
   -1.86423000E-03  +9.55148000E-02  -9.54693200E-02  +1.36850500E-02  -1.19481000E-03
   +3.63600000E-04  -1.24370000E-04  -6.96800000E-05  +4.47300000E-05  -3.89800000E-05
   +4.16900000E-05  -8.63000000E-06  +2.31100000E-05  +4.13700000E-05  -2.05000000E-05
   +4.43600000E-05  +3.09600000E-05  -3.55400000E-05  -4.88800000E-05  +4.26400000E-05
   -3.15000000E-06  -4.12100000E-05  -2.32000000E-06  -9.43800000E-05  -5.74000000E-05
   -2.33700000E-05  +1.13710000E-04  +5.96500000E-05  +4.53000000E-05  -1.09000000E-05
   -5.88600000E-05  +5.62800000E-05  -8.16000000E-06  +7.09000000E-06  +5.44500000E-05
   +1.23870000E-04  -7.40200000E-05  -5.62700000E-05  -4.58600000E-05  -6.19000000E-06
   +4.62100000E-05  +1.29400000E-05  +2.57500000E-05  -1.01790390E-01  +9.94160000E-02
   -9.32400000E-05  +5.66200000E-05  -2.30000000E-05  +7.79500000E-05  -1.04080000E-04
   -2.59880000E-04  -4.67500000E-04  +4.45010000E-04  -1.60700000E-05  +4.55520000E-04
   -2.89940000E-04  +8.25200000E-05  -1.42420000E-04  +2.60670000E-04  -2.05800000E-05
   +2.25970000E-04  +7.39700000E-04  +2.20000000E-05  +4.91070000E-04  -5.44010000E-04
   +7.07500000E-05  +2.58140000E-04  -3.70570000E-04  -3.89113000E-03  -5.09860000E-04
   -6.67690000E-04  +1.67650000E-04  +5.60950000E-04  +4.90130000E-04  +1.40980000E-04
   -2.68188000E-03  +6.96150000E-04  +3.90528000E-03  -7.04590000E-04  +9.26630000E-04
   +5.17262000E-03  +4.70170000E-04  +1.63410000E-04  -1.38130000E-03  -1.39190000E-04
   +2.23850000E-04  +5.49122000E-03  -6.00490000E-04  +9.77890000E-04  +4.59096000E-03
   -3.12337000E-02  +1.32396800E-02  -3.74441200E-02  -4.89800000E-05  -6.34900000E-05
   -3.42080000E-04  +4.21000000E-06  -1.72100000E-05  +1.27400000E-05  -3.24300000E-05
   -2.37400000E-05  -4.57000000E-06  -3.97600000E-05  -8.28800000E-05  -7.37300000E-05
   -4.84400000E-05  +1.88960000E-04  -2.11330000E-04  +3.87200000E-05  +1.54700000E-05
   -2.06600000E-05  +7.89900000E-05  -7.56100000E-05  -2.08540000E-04  +2.09100000E-05
   +1.24700000E-05  -4.08800000E-05  -2.56400000E-05  -3.71900000E-05  -6.81700000E-05
   -1.09600000E-05  +1.54700000E-05  +7.07000000E-06  +5.09000000E-06  -2.26300000E-05
   -9.46000000E-06  -7.50900000E-05  +1.68530000E-04  -1.37470000E-04  -2.76800000E-05
   +1.48500000E-05  +2.55860000E-04  +3.38669500E-02  -1.57847200E-02  +2.76575100E-02
   +9.66100000E-05  -3.10100000E-05  -6.15000000E-06  -1.01850000E-04  +4.22000000E-05
   +3.33000000E-06  +1.17000000E-05  +5.12000000E-06  -2.58400000E-05  -9.86000000E-06
   +2.39700000E-05  -3.64900000E-05  +5.26300000E-05  +3.50000000E-06  -1.13000000E-06
   +2.77400000E-05  +3.95400000E-05  -2.02000000E-06  +7.41000000E-06  +4.61800000E-05
   +1.84600000E-05  -2.53900000E-05  -7.26000000E-06  -8.30100000E-05  -6.17600000E-05
   -1.20000000E-05  +1.62000000E-05  -1.35500000E-05  +1.44600000E-05  +2.74000000E-06
   -4.36630000E-04  +9.46200000E-05  -4.21000000E-06  +1.02719000E-03  -1.49160000E-04
   -7.52800000E-05  -5.45688000E-03  -4.17462000E-03  -2.31030000E-04  +1.02565900E-02
   -3.81276900E-02  +4.27854000E-03  -1.94628000E-03  -9.19565000E-03  +3.87660000E-04
   +6.20340000E-04  +7.90580000E-04  +7.18900000E-05  -1.11822420E-01  +1.89270840E-01
   -2.51580200E-02  -2.98200000E-05  -2.60000000E-06  -3.30000000E-07  +7.80000000E-07
   -9.75000000E-06  +6.67000000E-06  -4.12000000E-06  -1.30800000E-05  +5.39000000E-06
   -5.29000000E-06  -2.92500000E-05  +1.96200000E-05  -1.36900000E-05  -1.37500000E-05
   +8.70000000E-06  +1.77100000E-05  -1.56700000E-05  -1.30300000E-05  +4.30000000E-07
   -4.66000000E-06  -1.35000000E-06  -8.90000000E-07  -5.25000000E-06  -7.65000000E-06
   -1.46000000E-06  -2.95000000E-06  +5.61000000E-06  -2.56000000E-06  -1.30000000E-06
   -2.86000000E-06  +1.19100000E-05  -3.03000000E-06  +4.10000000E-07  +1.12300000E-05
   +1.77000000E-05  +3.05100000E-05  -1.63130000E-04  -3.23600000E-05  -7.63000000E-06
   +1.06510340E-01  +2.31280000E-04  -1.42620000E-04  -9.91000000E-06  -2.01040000E-04
   +1.12030000E-04  +3.11700000E-05  +4.71600000E-05  -5.46400000E-05  -5.16900000E-05
   -1.47400000E-05  +8.63000000E-06  -5.55000000E-05  -5.67000000E-05  +1.17390000E-04
   +3.79000000E-06  +1.64100000E-05  +2.09500000E-05  +3.67000000E-06  +3.37400000E-05
   +1.40000000E-06  +5.06700000E-05  -2.91900000E-04  -4.33300000E-05  +7.75900000E-05
   +2.04910000E-04  +8.15100000E-05  -6.05900000E-05  +1.60810000E-04  +2.85400000E-05
   +5.35700000E-05  -4.53700000E-05  +8.27550000E-04  -2.33040000E-04  +1.10158000E-03
   -1.37742000E-03  +2.90280000E-04  -4.30497000E-03  +4.90710000E-04  -3.08370000E-04
   +4.98059000E-03  -3.67528400E-02  +3.27298000E-03  +2.07820000E-03  +3.92053000E-03
   -4.56000000E-06  +1.50230000E-04  -2.16694000E-03  +1.75650000E-04  +1.37600410E-01
   -4.50634980E-01  +4.91941500E-02  -3.26700000E-05  +2.49200000E-05  -1.01000000E-05
   +2.26900000E-05  -5.02000000E-06  +1.14400000E-05  -2.35300000E-05  +5.70000000E-06
   -9.71000000E-06  -2.55200000E-05  +8.99000000E-06  +3.99000000E-05  +1.09600000E-05
   -2.86000000E-06  -1.19900000E-05  +3.89200000E-05  +8.76800000E-05  +6.61200000E-05
   -3.43000000E-06  -3.17100000E-05  -1.82900000E-05  -1.95600000E-05  -2.26400000E-05
   -1.93200000E-05  -2.15800000E-05  -2.12400000E-05  +1.14100000E-05  -1.59200000E-05
   -2.23100000E-05  +9.64000000E-06  +3.22000000E-05  +7.99800000E-05  -3.42500000E-05
   -4.11000000E-05  +2.87150000E-04  -5.11400000E-05  +2.65090000E-04  +2.91060000E-04
   +2.31200000E-05  -1.42229970E-01  +4.86153940E-01  -8.47000000E-06  +5.86000000E-06
   -9.87000000E-06  +8.85000000E-06  -4.27000000E-06  +8.67000000E-06  -8.03000000E-06
   +1.09400000E-05  -9.76000000E-06  +1.29000000E-05  +6.25000000E-06  +1.28000000E-06
   +1.35000000E-06  +9.90000000E-07  -1.62800000E-05  +7.48000000E-06  -5.87000000E-06
   +2.63000000E-05  -5.60000000E-07  -1.65000000E-06  -7.62000000E-06  +3.53000000E-06
   +8.79000000E-06  +1.30980000E-04  +2.67200000E-05  +2.42000000E-06  +8.36000000E-06
   -3.92300000E-05  -1.65200000E-05  -4.03000000E-06  -8.34200000E-05  -6.45000000E-06
   -5.96900000E-05  -3.36800000E-05  +1.69880000E-04  +1.46222000E-03  -2.70080000E-04
   -3.39070000E-04  +1.32266000E-03  +7.02310000E-04  -6.58790000E-04  -1.93320000E-03
   -5.60210000E-04  -8.63840000E-04  +1.87290000E-03  +9.10400000E-05  +1.91510000E-04
   -9.61060000E-04  -2.08605300E-02  +5.38464600E-02  -1.20126600E-02  -1.37000000E-06
   -4.34000000E-06  +5.78000000E-06  -7.83000000E-06  -3.30000000E-06  -1.26000000E-06
   -3.81000000E-06  -9.53000000E-06  -3.32000000E-06  +1.50000000E-07  +9.46000000E-06
   -4.81000000E-06  +9.18000000E-06  -6.00000000E-08  -1.48000000E-06  -1.83000000E-06
   +2.56000000E-06  +1.12000000E-06  +3.90000000E-06  -2.30000000E-07  +9.08000000E-06
   -1.20400000E-05  +6.02000000E-06  -1.39800000E-05  +5.34000000E-06  +8.00000000E-07
   -1.41300000E-05  +2.01000000E-06  +2.75000000E-06  -7.50000000E-07  -4.10000000E-06
   -1.01000000E-05  +7.23000000E-06  +3.36800000E-05  -4.13800000E-05  -5.99040000E-04
   -5.29600000E-05  -1.59700000E-05  +1.40110000E-04  +2.07050200E-02  -5.24224900E-02
   +1.28347100E-02  +5.70400000E-05  -8.64000000E-05  +5.05000000E-06  -2.46700000E-05
   +2.85500000E-05  +3.20000000E-07  +1.87000000E-06  -5.19000000E-05  +2.02500000E-05
   +3.76300000E-05  -3.00900000E-05  +1.90400000E-05  +3.62500000E-05  +1.25780000E-04
   -1.14100000E-05  -4.11400000E-05  -1.62400000E-05  -2.58700000E-05  +2.26900000E-05
   -9.18600000E-05  +3.08900000E-05  +4.55960000E-04  -8.37580000E-04  +2.30590000E-04
   +2.91300000E-05  +4.67500000E-05  +5.19900000E-05  -3.89100000E-05  -4.87100000E-05
   -8.71000000E-05  -7.86045000E-03  +3.49371000E-03  -1.76770000E-03  +5.37342000E-03
   +4.48600000E-04  +3.88650000E-04  -8.51366000E-03  -4.85843000E-03  -7.49090000E-04
   -1.34114800E-02  +5.12806200E-02  -6.10250000E-03  -1.11491470E-01  +3.93481600E-02
   -8.77510000E-03  +8.89323000E-03  -3.71684600E-02  +3.42948000E-03  +4.16242000E-03
   +6.70849000E-03  +1.13300000E-04  +2.21000000E-05  +3.22100000E-05  -8.68000000E-06
   +2.10700000E-05  +1.43700000E-05  +7.40000000E-07  -1.77500000E-05  +2.76700000E-05
   -2.19800000E-05  -1.74800000E-05  +5.73500000E-05  +1.65000000E-05  +3.54700000E-05
   +2.64900000E-05  -3.21700000E-05  +6.76300000E-05  +1.92600000E-05  -6.38000000E-06
   +3.90900000E-05  -1.13250000E-04  -5.39800000E-05  -3.06200000E-05  -2.60000000E-06
   -8.56000000E-06  -4.25500000E-05  +4.66000000E-06  +4.18500000E-05  -1.83000000E-05
   -9.99600000E-05  +3.03400000E-05  +5.72500000E-05  +4.02000000E-06  +6.31800000E-05
   -2.53500000E-05  +1.69206000E-03  -1.47440000E-04  +3.14649000E-03  -7.83270000E-04
   +6.59410000E-04  +5.85910000E-04  +4.63920000E-04  +1.51410000E-04  +6.31566160E-01
   -1.18291000E-03  +8.38660000E-04  +3.43200000E-05  +9.99060000E-04  -5.83630000E-04
   -1.69090000E-04  -2.48910000E-04  +3.64120000E-04  +2.01450000E-04  +3.33200000E-05
   +1.38400000E-05  +3.04450000E-04  +4.89220000E-04  -4.43040000E-04  -7.51000000E-05
   -3.18600000E-05  -6.83500000E-05  -5.53000000E-05  -1.73200000E-04  +1.40110000E-04
   -2.81760000E-04  +1.99133000E-03  -2.65540000E-04  +5.09020000E-04  -2.21700000E-04
   -3.35590000E-04  +2.08070000E-04  -6.18570000E-04  -4.07450000E-04  -2.74820000E-04
   -8.59700000E-04  -8.69400000E-04  +7.89540000E-04  -4.96268000E-03  -4.72590000E-03
   +1.51080000E-04  +1.65431000E-03  +9.01103000E-03  +5.67200000E-05  +9.28193000E-03
   -4.83189300E-02  +5.34613000E-03  -7.97494000E-03  -3.00123080E-01  +2.12522400E-02
   +3.93980000E-03  -4.35435500E-02  +4.31474000E-03  +3.61530000E-03  +1.10625600E-02
   -8.78940000E-04  +1.00730000E-04  -1.78940000E-04  +7.05200000E-05  -1.54880000E-04
   -4.59000000E-06  -5.10700000E-05  +1.26830000E-04  -6.65600000E-05  +6.98100000E-05
   +1.14510000E-04  -1.36590000E-04  -2.34320000E-04  -1.29520000E-04  -3.45900000E-05
   +1.15170000E-04  -3.08580000E-04  -1.98060000E-04  -1.71430000E-04  -7.80400000E-05
   +2.97480000E-04  +1.59690000E-04  +9.06200000E-05  +1.24740000E-04  -1.92000000E-06
   +1.47720000E-04  +6.11900000E-05  -2.53100000E-05  +1.30120000E-04  +3.00490000E-04
   -6.89500000E-05  -2.95120000E-04  -2.77160000E-04  +1.51150000E-04  -6.15000000E-06
   -7.50370000E-04  +1.99440000E-04  +5.95180000E-04  +3.50433000E-03  -6.01900000E-04
   +2.11339000E-03  -1.35846000E-03  +6.78100000E-05  -1.41788950E-01  +4.46036620E-01
   +1.10030000E-04  -7.78200000E-05  +2.17500000E-05  -1.00270000E-04  +6.75400000E-05
   +1.10200000E-05  +7.54400000E-05  -1.08960000E-04  +4.21000000E-06  -1.11000000E-04
   -1.87000000E-06  -1.14000000E-05  +1.76400000E-05  +1.64800000E-05  +2.50200000E-05
   +1.10410000E-04  +7.92000000E-06  -6.37900000E-05  -2.66700000E-05  +7.31300000E-05
   -5.93000000E-06  -1.81710000E-04  +2.72500000E-05  +1.92500000E-04  +8.11200000E-05
   +1.42260000E-04  +1.02800000E-05  -1.26980000E-04  -8.70900000E-05  +6.81600000E-05
   -1.07507000E-03  +8.99070000E-04  +6.77653000E-03  +8.42980000E-04  +3.40500000E-04
   -1.04662000E-03  -1.12891000E-03  -8.44730000E-04  +4.11074000E-03  -2.59534000E-03
   +8.90706000E-03  +7.87368000E-03  -5.00929000E-03  +2.42360000E-02  -4.20370300E-02
   +1.62720000E-04  +1.13096000E-03  +6.54260000E-03  +3.90530000E-04  -6.31470000E-04
   -3.14187000E-03  -3.64000000E-06  +2.68000000E-05  -1.96300000E-05  +3.58700000E-05
   +1.59700000E-05  +8.35000000E-06  -2.07000000E-06  +4.02200000E-05  +3.73000000E-06
   -1.29400000E-05  -5.37600000E-05  +4.80100000E-05  -2.90400000E-05  -1.40400000E-05
   +1.15400000E-05  +8.28800000E-05  +6.48000000E-06  +7.51600000E-05  +3.77800000E-05
   -4.57000000E-05  -4.86000000E-05  +5.50000000E-06  -2.37500000E-05  +2.79900000E-05
   -1.80800000E-05  -1.80000000E-06  +8.49000000E-06  -1.95900000E-05  -3.64000000E-06
   -1.53100000E-05  -4.78000000E-06  -2.06200000E-05  +3.73700000E-05  +1.37700000E-05
   +1.89360000E-04  -2.57180000E-04  +5.70860000E-04  -7.32980000E-04  -4.25709000E-03
   -3.87700000E-05  +2.78800000E-05  -1.25379000E-03  +5.36594900E-02  -4.46501200E-02
   +3.20629800E-02  -3.75100000E-05  +8.72600000E-05  -7.39000000E-06  -8.20000000E-06
   -1.88700000E-05  -2.44800000E-05  -1.66000000E-05  +7.00700000E-05  -3.61300000E-05
   -2.33000000E-06  +9.44000000E-06  -1.83300000E-05  +1.28890000E-04  -3.09000000E-05
   -7.74000000E-06  +8.39100000E-05  +6.29000000E-06  +2.70300000E-05  -1.20000000E-05
   +1.31550000E-04  -7.36000000E-06  +2.56800000E-04  -1.62120000E-04  +4.58500000E-05
   -4.83700000E-05  -1.87300000E-05  +4.24000000E-06  -9.48000000E-05  -2.42600000E-05
   -4.74000000E-06  -6.68780000E-04  -3.28800000E-04  +4.12900000E-05  -4.24470000E-04
   -6.06420000E-04  +1.22000000E-06  -3.07020000E-04  +8.99090000E-04  -1.31500000E-04
   +6.31460000E-04  -2.48689000E-03  +9.01300000E-05  -5.38249000E-03  +1.36910000E-03
   -3.76200000E-04  +4.38757000E-03  -4.43815000E-03  +7.61060000E-04  +8.63700000E-04
   +1.51010000E-03  -8.05800000E-05  -3.57800000E-05  -3.27900000E-05  +7.98000000E-06
   -2.01200000E-05  -1.69100000E-05  +5.20000000E-07  +1.61500000E-05  -1.37600000E-05
   +1.68000000E-05  +1.08000000E-05  -3.34300000E-05  -2.01100000E-05  -3.45800000E-05
   -3.10300000E-05  +3.89800000E-05  -3.37500000E-05  -2.89900000E-05  -1.30300000E-05
   -2.29100000E-05  +4.75700000E-05  +1.85600000E-05  +2.67600000E-05  +7.80000000E-06
   -2.18000000E-06  +2.71500000E-05  +8.80000000E-07  -1.20000000E-06  +3.02000000E-06
   +4.69700000E-05  -1.45900000E-05  -3.06700000E-05  -3.68300000E-05  +1.24700000E-05
   +8.86700000E-05  +2.12300000E-05  +4.94900000E-05  -9.05380000E-04  +7.20400000E-04
   -1.71460000E-04  +9.65990000E-04  +6.63100000E-05  +1.48620000E-04  -5.13280080E-01
   +1.33213380E-01  -4.56895800E-02  +5.13899800E-01  +3.83580000E-04  -2.72180000E-04
   -8.87000000E-06  -3.81930000E-04  +2.13400000E-04  +4.94400000E-05  +6.64200000E-05
   -7.14100000E-05  -8.41700000E-05  -5.01200000E-05  +4.27100000E-05  -1.19890000E-04
   +1.55600000E-05  +1.07180000E-04  -1.09200000E-05  +3.95100000E-05  +8.31000000E-05
   +2.94600000E-05  +3.12600000E-05  +3.48600000E-05  +8.93700000E-05  -2.96620000E-04
   +1.95800000E-05  -1.93400000E-05  +1.06070000E-04  +4.12300000E-05  -5.20500000E-05
   +1.25280000E-04  +4.70700000E-05  +6.51200000E-05  +3.82700000E-04  -4.81150000E-04
   +9.77000000E-06  -5.01190000E-04  -8.82400000E-05  -1.26900000E-05  +1.85702000E-03
   +6.30490000E-04  +1.89040000E-04  -1.57152000E-03  -7.98104000E-03  +6.56140000E-04
   +4.91245800E-02  -1.77996400E-02  +4.72263000E-03  +1.28662000E-03  +3.03644000E-03
   -1.51830000E-04  -1.87332000E-03  +1.08868000E-03  -2.50590000E-04  -4.03500000E-05
   +5.79300000E-05  -1.93000000E-05  +3.49400000E-05  -1.40000000E-07  +1.85700000E-05
   -2.71300000E-05  -1.03900000E-05  -6.13000000E-06  -2.71100000E-05  -1.65900000E-05
   +6.33100000E-05  +1.66100000E-05  +4.93000000E-06  -2.64900000E-05  +3.05700000E-05
   +6.35100000E-05  +4.13700000E-05  -1.13500000E-05  -9.39000000E-06  -1.35800000E-05
   -1.13600000E-05  -2.77200000E-05  -2.10600000E-05  -1.34300000E-05  -2.07200000E-05
   -2.48000000E-06  -2.21300000E-05  -1.24200000E-05  +6.73000000E-06  +3.06100000E-05
   +6.28200000E-05  -4.07400000E-05  -3.20000000E-07  -4.40610000E-04  +9.75000000E-06
   -2.40479000E-03  -7.62790000E-04  -1.13100000E-04  +1.87126000E-03  -2.74300000E-05
   +1.11900000E-04  +8.18373700E-02  -6.76347700E-02  +1.09781600E-02  -1.29830390E-01
   +8.98411000E-02  -5.54500000E-05  +3.01700000E-05  -3.96300000E-05  +7.90400000E-05
   -2.20200000E-05  +7.77900000E-05  -3.56100000E-05  +7.74900000E-05  -5.37300000E-05
   +8.49000000E-05  -2.22000000E-06  -2.18300000E-05  -2.54200000E-05  +1.09000000E-05
   -3.63900000E-05  -4.93300000E-05  -2.62000000E-06  +9.31200000E-05  -4.82000000E-06
   -9.63200000E-05  -1.19800000E-05  +2.84200000E-05  -1.02500000E-05  -4.12800000E-05
   -1.48300000E-05  -5.65400000E-05  +5.09100000E-05  +1.48000000E-05  +1.54200000E-05
   +7.78000000E-06  +4.37100000E-05  -8.55100000E-05  -6.40010000E-04  -1.00950000E-04
   -8.54900000E-05  +2.42220000E-04  -2.77760000E-04  +2.23860000E-04  +1.02813000E-03
   +6.86500000E-05  +5.49310000E-04  +1.74982000E-03  -4.43928000E-03  +1.65893000E-03
   -2.96633000E-03  +2.80040000E-04  -6.25470000E-04  -3.74360000E-04  +1.64070000E-04
   +1.21770000E-04  +2.43030000E-04  -4.71000000E-06  -2.10800000E-05  +2.15400000E-05
   -3.40900000E-05  -2.23700000E-05  -9.69000000E-06  -1.28000000E-05  -4.36500000E-05
   -1.69700000E-05  -1.01900000E-05  +8.04400000E-05  -5.19000000E-05  +5.58400000E-05
   +2.34500000E-05  -3.50500000E-05  -6.83000000E-06  -9.10000000E-07  -2.47300000E-05
   +1.24000000E-06  +4.90000000E-06  -1.08000000E-06  -6.55000000E-06  +2.93000000E-06
   -2.77200000E-05  +2.84000000E-06  +4.83000000E-06  -2.49300000E-05  +1.96000000E-06
   +1.40000000E-07  +3.00000000E-08  -6.73000000E-06  +3.48000000E-06  -6.73000000E-06
   +2.25100000E-05  +3.42600000E-05  -2.69300000E-04  +1.67400000E-05  +1.43490000E-04
   +5.51470000E-04  +4.98200000E-05  -6.37600000E-05  -8.39960000E-04  -4.12606400E-02
   +1.42585100E-02  -5.60172000E-03  +4.54211800E-02  -1.60969400E-02  +7.05331000E-03
   -2.78100000E-04  +1.85130000E-04  +8.58000000E-06  +1.89860000E-04  -1.63540000E-04
   -6.59000000E-05  -1.30430000E-04  +4.49300000E-05  +7.90200000E-05  +1.42800000E-05
   +1.14370000E-04  +4.54500000E-05  +3.07040000E-04  +4.08660000E-04  -4.55050000E-04
   -7.42000000E-06  +1.62040000E-04  -9.15000000E-06  -6.20000000E-06  +3.37400000E-05
   -7.65700000E-05  -1.36236000E-03  -6.82750000E-04  +1.00999000E-03  +7.85920000E-04
   +2.03380000E-04  -4.19460000E-04  -1.10310000E-04  -1.91424000E-03  +7.18600000E-04
   +1.80100000E-05  -3.55305000E-03  +4.38560000E-04  -1.05887200E-02  +4.82845000E-02
   -2.30753000E-03  +2.88300000E-04  -4.16699000E-03  +8.32670000E-04  -5.76900000E-05
   +8.58130000E-04  -3.56150000E-04  -2.02100000E-04  +2.58810000E-04  +1.57600000E-05
   +1.23385000E-03  +2.18380000E-04  -4.25110000E-04  +1.34750000E-04  -4.11410000E-04
   -1.38100000E-05  +3.51000000E-05  -3.61900000E-05  +1.71100000E-05  -4.79800000E-05
   -4.83000000E-06  -7.86000000E-06  +3.61700000E-05  -2.32500000E-05  +1.47700000E-05
   -1.79200000E-05  -1.55600000E-04  -3.57300000E-05  -2.07600000E-05  +4.00000000E-08
   +1.89700000E-05  +2.53800000E-05  +1.48710000E-04  +1.71240000E-04  -6.43320000E-04
   -3.93100000E-05  +1.75700000E-04  -1.95890000E-04  +1.22800000E-04  -2.46870000E-04
   -4.39650000E-04  +3.89210000E-04  +1.84260000E-04  -2.12756000E-03  +1.63464000E-03
   +2.06750000E-04  -9.78740000E-04  +8.00260000E-04  -2.17100000E-05  +9.89310000E-04
   +6.23820000E-04  +2.01950000E-04  -1.52980000E-04  -3.33800000E-04  -3.55900000E-05
   -7.30400000E-05  +6.23300000E-05  -3.63700000E-05  +2.71630000E-04  -4.65430000E-04
   +1.22670000E-04  -6.31700000E-05  +2.86200000E-05  +5.54000000E-06  +3.15352300E-02
   -1.51540000E-04  +7.68600000E-05  +1.17300000E-05  +1.27750000E-04  -6.23900000E-05
   -2.59000000E-05  -2.59200000E-05  +4.19000000E-05  +4.57200000E-05  +9.95000000E-06
   -2.46400000E-05  +5.51600000E-05  +6.37900000E-05  +6.41600000E-05  +5.13900000E-05
   -3.16300000E-05  -2.11400000E-05  -4.78100000E-05  -2.31800000E-05  -1.02600000E-05
   -2.11800000E-05  +1.20871000E-03  -7.36500000E-05  -6.90180000E-04  -9.69700000E-05
   -2.91000000E-04  +1.29470000E-04  +4.72990000E-04  +2.66320000E-04  -2.18600000E-04
   +1.03559000E-03  +5.63265000E-03  -2.05724000E-03  +2.93978100E-02  -1.09029260E-01
   +4.10953000E-03  -5.27870000E-04  +7.09484000E-03  -1.56967000E-03  +4.49210000E-04
   +2.96000000E-05  +1.23472000E-03  +7.12530000E-04  -7.10550000E-04  -8.78300000E-05
   -1.73052000E-03  -1.16979000E-03  +1.33383000E-03  +2.51720000E-04  +6.95880000E-04
   +8.59500000E-05  +2.61300000E-05  -7.83000000E-06  +5.55000000E-06  -1.20500000E-05
   +7.72000000E-06  -7.69000000E-06  +1.56400000E-05  -6.43000000E-06  +1.21000000E-05
   +1.03200000E-05  +8.10000000E-06  -1.96600000E-05  -5.65000000E-06  +9.25000000E-06
   +2.70000000E-06  +2.30900000E-05  -9.47300000E-05  -4.01400000E-05  -3.17120000E-04
   +1.83270000E-04  -9.16100000E-05  -5.78500000E-05  +5.80900000E-05  +3.61600000E-05
   -9.51400000E-05  +9.37900000E-05  +3.37300000E-05  -4.18760000E-04  -3.63950000E-04
   +1.65970000E-04  +1.63290000E-04  -1.68900000E-04  -1.19700000E-05  -2.72050000E-04
   +6.58070000E-04  -8.17680000E-04  +2.73550000E-04  +4.52550000E-04  +2.27510000E-04
   +3.96200000E-05  -4.84500000E-05  +5.72800000E-05  -2.75800000E-05  +6.60830000E-04
   -2.40630000E-04  +3.10700000E-05  -1.02270000E-04  +3.69000000E-06  -1.44107000E-03
   +5.29547100E-02  +2.00000000E-06  -8.17000000E-06  +1.11800000E-05  +9.92000000E-06
   +1.65300000E-05  +3.66300000E-05  +6.64800000E-05  -8.71000000E-06  +1.61600000E-05
   -4.62000000E-05  -3.79200000E-05  -7.60200000E-05  -3.23000000E-05  -1.20910000E-04
   +3.65490000E-04  -4.38100000E-05  -4.26500000E-05  -5.12500000E-05  -4.18100000E-05
   +2.02900000E-05  +4.28100000E-05  +2.55670000E-04  -8.90700000E-05  -1.24403000E-03
   +1.83460000E-04  -3.35120000E-04  -1.57450000E-04  +1.45000000E-05  +9.14770000E-04
   +5.23720000E-04  +1.02735000E-03  -1.30900000E-03  -1.90974000E-03  -5.28282000E-03
   +1.83521300E-02  +3.03193000E-03  -2.26130000E-04  -1.79475000E-03  -1.65946000E-03
   -6.84250000E-04  +2.78030000E-04  +7.44460000E-04  -1.19110000E-04  -4.68850000E-04
   -1.33180000E-04  +3.93970000E-04  +6.53100000E-04  +1.08473000E-03  +1.12680000E-04
   -2.02600000E-05  +1.92450000E-04  +5.77000000E-06  +3.11000000E-06  -6.57000000E-06
   +9.95000000E-06  +2.99000000E-06  -3.76000000E-06  +3.73200000E-05  -7.30000000E-06
   +4.44000000E-05  +1.16400000E-05  +4.67800000E-05  +1.62100000E-05  -5.93000000E-06
   +9.20000000E-06  -2.37000000E-06  -1.25770000E-04  +2.05000000E-06  -6.97900000E-05
   -2.61400000E-04  +9.16000000E-05  -1.68200000E-05  -1.51440000E-04  +1.07160000E-04
   +1.14080000E-04  -1.19940000E-04  +6.04300000E-05  +4.69200000E-05  +6.51170000E-04
   -5.28680000E-04  -7.40920000E-04  +3.52000000E-04  -2.68950000E-04  +3.34700000E-05
   +1.79060000E-04  -1.03810000E-04  -7.13780000E-04  -4.90900000E-05  +1.58700000E-05
   +2.59690000E-04  -7.21200000E-05  -1.89100000E-05  +7.48400000E-05  -6.86300000E-05
   +5.80300000E-04  -2.54750000E-04  +7.69200000E-05  -2.87100000E-05  -1.32800000E-05
   +9.36499800E-02  +6.27725100E-02  +5.17717590E-01  +2.13970000E-04  -1.25380000E-04
   -4.45000000E-06  -1.66470000E-04  +1.13210000E-04  +4.28400000E-05  +9.02900000E-05
   -3.86600000E-05  -4.15300000E-05  -9.97000000E-06  -4.65700000E-05  -7.63700000E-05
   -1.29260000E-04  -6.20100000E-05  +2.92520000E-04  -1.30500000E-05  -4.85800000E-05
   -3.17600000E-05  +1.44300000E-05  +6.98000000E-06  +7.31900000E-05  +2.42460000E-04
   +7.56900000E-05  -5.67430000E-04  +9.28600000E-05  -2.31820000E-04  -6.47600000E-05
   -3.24930000E-04  +6.41390000E-04  +4.48700000E-04  +1.06800000E-04  -2.66610000E-04
   -3.39730000E-04  -1.09309000E-03  +1.76261000E-03  -1.58410000E-04  +6.80650000E-04
   -7.56260000E-04  -1.31160000E-04  +1.00800000E-05  +2.15300000E-05  -1.44000000E-06
   -1.43830000E-04  +2.36500000E-04  -3.91200000E-05  -5.78100000E-05  +1.00230000E-04
   +2.07830000E-04  -2.73570000E-04  -2.91500000E-04  +5.77000000E-06  -3.21700000E-05
   +1.79100000E-05  -1.12300000E-05  +2.77600000E-05  -5.82000000E-06  +8.73000000E-06
   -6.39000000E-06  +9.10000000E-07  +1.38600000E-05  -7.97000000E-06  +6.28700000E-05
   +4.21600000E-05  +4.98000000E-06  -2.66000000E-06  -9.16000000E-06  -4.68800000E-05
   +2.84200000E-05  -3.16000000E-05  -1.21000000E-05  -5.30000000E-07  +4.74400000E-05
   -6.23400000E-05  +3.47900000E-05  +1.07670000E-04  -1.56780000E-04  +8.46400000E-05
   +7.62500000E-05  -1.02591000E-03  -4.53580000E-04  -8.28320000E-04  +3.66510000E-04
   -2.09650000E-04  +9.46000000E-05  -1.64190000E-04  -3.43920000E-04  +2.07490000E-04
   +1.58400000E-05  -3.62700000E-05  +6.67000000E-05  +1.98300000E-05  +1.97900000E-05
   +1.24900000E-05  -1.87100000E-05  -3.00010000E-04  -5.60000000E-07  -9.36000000E-06
   +4.57600000E-05  -9.18000000E-06  -2.15477700E-02  -1.27990000E-04  -8.82562300E-02
   +2.35828600E-02  -1.04950000E-04  +4.65700000E-05  +5.63000000E-06  +9.13100000E-05
   -4.21400000E-05  -7.94000000E-06  -1.92300000E-05  +1.84200000E-05  +2.18500000E-05
   +6.24000000E-06  -1.59700000E-05  +2.57300000E-05  -2.80300000E-05  -1.10810000E-04
   +3.07200000E-05  -1.02800000E-05  -2.54800000E-05  +1.86000000E-05  -2.34200000E-05
   -1.42300000E-05  -2.45300000E-05  +1.87900000E-04  +9.09100000E-05  +3.56620000E-04
   -2.64300000E-05  -2.38700000E-05  -1.18200000E-05  -2.52950000E-04  -1.13160000E-04
   +1.23260000E-04  -8.21100000E-05  +2.94470000E-04  +1.08877000E-03  +1.73320000E-04
   +5.38830000E-04  +1.33815000E-03  +1.70800000E-05  +6.14000000E-05  +7.04870000E-04
   -2.08060000E-04  -5.24280000E-04  -6.32300000E-04  +7.59800000E-05  -1.85500000E-04
   +1.40440000E-04  -1.78840000E-04  +2.38800000E-05  -6.99470000E-04  +2.11050000E-04
   +3.18230000E-04  -9.97700000E-05  +2.09200000E-05  -3.60000000E-07  +1.80000000E-06
   -5.61000000E-06  +9.08000000E-06  -7.53000000E-06  +1.00400000E-05  +3.72000000E-06
   +5.00000000E-08  +2.18100000E-05  +1.50200000E-05  -2.34400000E-05  +3.07000000E-06
   +9.03000000E-06  +6.30000000E-07  -9.38200000E-05  -3.95000000E-06  -2.81100000E-05
   +1.57240000E-04  +4.80000000E-06  +1.06110000E-04  +2.60400000E-05  -4.47000000E-06
   +6.46000000E-06  +8.66500000E-05  -3.32800000E-05  -5.89500000E-05  -1.58430000E-04
   +3.07480000E-04  -1.87640000E-04  -7.52000000E-05  -4.12600000E-05  -2.73600000E-05
   -3.35730000E-04  -1.62500000E-04  +6.01250000E-04  +1.95000000E-06  +6.10000000E-05
   -1.64310000E-04  +1.69000000E-06  -6.38600000E-05  -2.95800000E-05  -1.22320000E-04
   +3.06920000E-04  +7.35300000E-05  +2.27400000E-05  -4.53800000E-05  +1.24100000E-05
   -6.29001000E-03  -2.85065600E-02  -7.18085500E-02  +1.13412000E-03  +3.01677300E-02
   +1.51040000E-04  -7.17500000E-05  -1.32700000E-05  -1.27970000E-04  +6.40800000E-05
   +2.77600000E-05  +3.24300000E-05  -3.31800000E-05  -3.63500000E-05  +4.97000000E-06
   +9.54000000E-06  -6.24600000E-05  +8.49000000E-06  +1.50370000E-04  +1.11900000E-05
   +3.07000000E-05  +3.60100000E-05  +2.66400000E-05  +2.03300000E-05  +1.84300000E-05
   +2.48800000E-05  -5.43890000E-04  -1.25100000E-04  +6.06100000E-05  +3.14160000E-04
   -4.55000000E-06  -7.63500000E-05  +2.30970000E-04  +1.37540000E-04  +8.55100000E-05
   -5.91610000E-04  -1.98495000E-03  +1.63170000E-04  -1.30916000E-03  +7.81049000E-03
   +4.60390000E-04  +6.37220000E-04  -1.50867000E-03  +1.75990000E-04  +2.50200000E-04
   +3.83540000E-04  -2.90000000E-07  -2.06300000E-04  +5.19540000E-04  -4.63200000E-05
   +7.47670000E-04  +3.09700000E-05  -1.12060000E-04  -3.20200000E-04  -5.82680000E-04
   -1.56000000E-05  -2.81700000E-05  +2.63000000E-06  -3.37000000E-06  +1.05800000E-05
   -1.24700000E-05  +8.39000000E-06  -1.14500000E-05  -4.71000000E-06  -6.70000000E-07
   -1.86500000E-05  -1.72900000E-05  +3.28000000E-05  +3.07000000E-06  -1.44800000E-05
   -4.10000000E-07  +2.60000000E-05  +8.92000000E-05  +7.01500000E-05  -1.79300000E-05
   -4.57300000E-05  -2.94600000E-05  -2.28700000E-05  -7.02000000E-06  -3.54100000E-05
   +6.68000000E-05  -1.19150000E-04  -4.88800000E-05  -1.71160000E-04  -4.97200000E-05
   +1.81900000E-04  +8.06200000E-05  +3.78100000E-05  -7.48200000E-05  +1.43430000E-04
   +2.05650000E-04  -1.74000000E-05  -4.00700000E-05  -3.01810000E-04  +1.86000000E-05
   +5.16000000E-06  +6.80300000E-05  -5.64000000E-06  +1.47360000E-04  -7.61320000E-04
   +7.84100000E-05  -5.84900000E-05  +8.90100000E-05  -6.85000000E-06  -9.83262500E-02
   -4.69685100E-02  -5.01819210E-01  +9.64454100E-02  +5.32746600E-02  +5.04743330E-01
   -1.20220000E-04  +3.03100000E-05  +8.75000000E-06  +1.33750000E-04  -3.53100000E-05
   -3.33300000E-05  -1.85000000E-05  +3.61500000E-05  +1.88100000E-05  +8.49000000E-05
   -1.10260000E-04  +1.47310000E-04  -1.36750000E-04  -2.83690000E-04  +8.01500000E-05
   +1.39500000E-05  -1.46030000E-04  -1.02600000E-05  -2.70000000E-07  -7.65000000E-05
   -3.59300000E-05  +1.60077000E-03  +1.28736000E-03  -3.02240000E-04  -1.04675000E-03
   -3.00100000E-05  +1.95580000E-04  -9.63330000E-04  +2.02390000E-04  -4.32000000E-05
   -1.11410000E-03  +2.26432600E-02  -8.43210000E-04  -2.46957500E-02  -3.43092400E-02
   +1.00737000E-03  +8.82690000E-04  -7.67408000E-03  -1.05260000E-03  -8.87400000E-04
   -3.49773000E-03  +6.09860000E-04  -7.52360000E-04  -1.13599000E-03  +5.34000000E-06
   -4.75595000E-03  +8.64730000E-04  -3.10680000E-04  +5.63860000E-04  +6.82230000E-04
   +9.32700000E-05  +3.04200000E-05  +1.14700000E-05  +6.30000000E-07  +4.94000000E-06
   +2.03100000E-05  -9.32000000E-06  -1.58300000E-05  +2.06400000E-05  -3.65000000E-05
   +3.63300000E-05  +8.68100000E-05  -4.60800000E-05  +1.60900000E-05  +1.60800000E-05
   -8.48000000E-06  +1.18620000E-04  -2.74860000E-04  -1.20970000E-04  -6.49040000E-04
   -3.63810000E-04  -1.16512000E-03  +2.31530000E-04  -8.88400000E-05  +2.05860000E-04
   +1.95650000E-04  -7.55600000E-05  -1.34340000E-04  -1.70646000E-03  -1.19051000E-03
   +1.10356000E-03  +3.28170000E-04  -3.56350000E-04  +1.06200000E-05  -6.27430000E-04
   -4.38860000E-04  -3.18250000E-04  +1.62210000E-04  +1.50066000E-03  -1.84240000E-04
   -5.57500000E-05  -2.59560000E-04  +5.85200000E-05  -4.98200000E-05  +1.16440000E-03
   -1.45390000E-04  +4.77000000E-05  -2.51250000E-04  +1.38800000E-05  +3.18730000E-03
   -2.89498600E-02  -1.45285000E-03  -1.66770000E-04  +5.76629000E-03  +2.43760000E-03
   +3.01235900E-02  +6.72440000E-04  -3.18640000E-04  -4.55700000E-05  -5.83540000E-04
   +2.78200000E-04  +9.98500000E-05  +1.33230000E-04  -1.60420000E-04  -1.58000000E-04
   -3.94900000E-05  +1.10820000E-04  -2.81820000E-04  +7.57400000E-05  +4.90840000E-04
   -1.14910000E-04  +1.00870000E-04  +1.76430000E-04  +9.71000000E-05  +1.07390000E-04
   +7.65600000E-05  +1.19120000E-04  -4.07002000E-03  -7.98300000E-04  +3.99280000E-04
   +2.87620000E-04  +6.11690000E-04  -3.20860000E-04  +1.21820000E-04  +2.15370000E-04
   +3.90900000E-04  -4.73410000E-04  -1.98542700E-02  +1.57747000E-03  -1.36751200E-02
   +7.90255000E-03  -4.11942000E-03  +6.69714000E-03  -3.09870400E-02  +2.25982000E-03
   -2.91582000E-03  +2.26488000E-03  -1.17915000E-03  -2.10270000E-03  +2.30790000E-03
   -2.57800000E-04  +6.70701000E-03  +3.28068000E-03  -6.93070000E-04  -1.04951000E-03
   -3.77276000E-03  +1.61570000E-04  -1.24960000E-04  +1.48900000E-05  -1.98500000E-05
   +4.76500000E-05  -5.36400000E-05  +4.02200000E-05  -5.46700000E-05  -1.22400000E-05
   -3.52000000E-06  -8.17800000E-05  -8.20100000E-05  +1.18550000E-04  +5.21000000E-06
   -5.09200000E-05  -5.40000000E-06  +2.88000000E-04  +2.81580000E-04  +3.05900000E-04
   -2.93930000E-04  -6.46670000E-04  -3.71650000E-04  +2.92000000E-05  -5.46200000E-05
   -1.42910000E-04  +1.88800000E-05  -7.45000000E-05  -1.07600000E-05  +1.39400000E-04
   -5.96550000E-04  +4.44660000E-04  +6.10100000E-05  +3.75390000E-04  -2.25190000E-04
   +1.30011000E-03  +4.93110000E-04  +6.91230000E-04  -6.34250000E-04  -1.83525000E-03
   +7.69500000E-05  -3.13700000E-04  +2.28080000E-04  -6.82500000E-05  +4.67550000E-04
   -2.39838000E-03  +3.32410000E-04  -1.21990000E-04  +4.29230000E-04  -2.52200000E-05
   -3.49010100E-02  +7.17032000E-02  -6.92650000E-03  -1.03956000E-03  -2.36040000E-03
   -1.03144100E-02  +4.52152000E-02  -2.71847800E-02  -7.92100000E-05  +3.69700000E-05
   -3.42000000E-06  +6.89300000E-05  -2.94300000E-05  -1.88800000E-05  -4.49400000E-05
   +2.07900000E-05  -5.24000000E-06  +6.74000000E-06  +1.53200000E-05  +8.58300000E-05
   -1.25000000E-06  +5.90000000E-07  -2.45260000E-04  +5.97500000E-05  -2.30100000E-05
   +4.05900000E-05  -2.27000000E-06  -2.09900000E-05  -6.16800000E-05  +6.98780000E-04
   +4.50400000E-05  -8.23770000E-04  -3.11450000E-04  +3.14380000E-04  -5.10400000E-05
   +3.61400000E-05  -3.70050000E-04  -1.48180000E-04  -1.53520000E-03  +6.35953000E-03
   +4.36484000E-03  +5.15070000E-03  -2.63693900E-02  -2.92891200E-02  -5.02530000E-04
   +4.51214000E-03  +4.94161000E-03  +9.96350000E-04  -7.85480000E-04  +3.61344000E-03
   +3.53680000E-04  +3.91210000E-04  -4.75590000E-04  -2.42945000E-03  -9.94220000E-04
   +2.27502000E-03  +4.77300000E-05  +6.79770000E-04  -1.41120000E-04  +9.79000000E-06
   -3.09000000E-06  +6.56000000E-06  -1.16400000E-05  +4.70000000E-06  -2.52000000E-06
   -2.54700000E-05  +1.32000000E-06  -2.90400000E-05  -2.10000000E-07  -1.66700000E-05
   -3.19900000E-05  +4.99000000E-06  +3.60000000E-07  +1.26000000E-06  +2.65440000E-04
   -1.52360000E-04  +1.45900000E-05  -8.89500000E-04  -5.94620000E-04  -5.81140000E-04
   -3.04200000E-05  -2.05500000E-05  -4.35000000E-05  +1.19200000E-04  -2.85600000E-05
   -8.61700000E-05  +5.86440000E-04  +7.55440000E-04  -4.00000000E-07  -2.99380000E-04
   +7.75400000E-05  +1.07100000E-05  -1.59300000E-05  -2.50270000E-04  -2.04630000E-03
   +6.67800000E-05  +4.70110000E-04  -1.36990000E-04  +1.51170000E-04  -2.74300000E-05
   -1.53890000E-04  +6.73800000E-05  -5.38790000E-04  +1.61900000E-05  -9.72700000E-05
   -5.09000000E-05  -3.69000000E-06  +4.92153000E-03  -1.74583800E-02  -1.54844200E-02
   -7.59124000E-03  +1.58797600E-02  -3.76493000E-03  +2.55860000E-04  +1.81692600E-02
   +3.82576400E-02
end_hess

