# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -882.69526270    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   008   -9.57924266E+00  -3.23294395E+00  -1.62466399E+00
   006   -7.53011436E+00  -1.77543599E+00  -1.10556189E+00
   006   -5.47251064E+00  -1.59212878E+00  -2.72984953E+00
   006   -3.43914454E+00  -8.21865784E-02  -2.09149248E+00
   006   -3.38127923E+00  +1.28746046E+00  +1.56147773E-01
   006   -5.45663505E+00  +1.07271954E+00  +1.75035286E+00
   006   -7.51216574E+00  -4.36663295E-01  +1.14293063E+00
   006   -1.10408744E+00  +2.97983871E+00  +7.24806048E-01
   006   -1.17265049E+00  +5.21721208E+00  -1.12298517E+00
   006   -1.17428888E+00  +4.06079418E+00  +3.41851426E+00
   006   +1.32539549E+00  +1.42525551E+00  +4.69993488E-01
   006   +3.40480665E+00  +2.23322114E+00  -9.14765692E-01
   006   +5.55111223E+00  +7.51139179E-01  -9.81864197E-01
   006   +5.75974366E+00  -1.51538700E+00  +2.56958992E-01
   006   +3.66681907E+00  -2.32845489E+00  +1.64719838E+00
   006   +1.50287667E+00  -8.79673680E-01  +1.74217034E+00
   008   +7.90262884E+00  -2.91217050E+00  +1.23070006E-01
   001   -9.36509701E+00  -4.03522718E+00  -3.23076301E+00
   001   -5.45679378E+00  -2.63797502E+00  -4.49162796E+00
   001   -1.84135464E+00  +1.04496860E-02  -3.36742800E+00
   001   -5.50678649E+00  +2.09188097E+00  +3.51977524E+00
   001   -9.11293574E+00  -5.85534029E-01  +2.40438140E+00
   001   -2.97772066E+00  +6.19228241E+00  -9.42138375E-01
   001   +3.23421121E-01  +6.57579855E+00  -7.16015636E-01
   001   -9.82145306E-01  +4.60017493E+00  -3.07874021E+00
   001   -1.25302621E+00  +2.57277847E+00  +4.84114355E+00
   001   +5.32218850E-01  +5.16354764E+00  +3.75528236E+00
   001   -2.79594979E+00  +5.30592527E+00  +3.68320442E+00
   001   +3.37669886E+00  +3.99456872E+00  -1.94414298E+00
   001   -1.08804598E-01  -1.57194083E+00  +2.80281126E+00
   001   +7.66768864E+00  -4.42187460E+00  +1.10106564E+00
   008   +3.94856212E+00  -4.60016270E+00  +2.83764269E+00
   001   +2.42396698E+00  -5.04883470E+00  +3.69854144E+00
   008   +9.47292133E+00  +1.68196158E+00  -3.30225135E+00
   001   +1.02476524E+01  +1.30454854E-01  -2.73184697E+00
   001   +7.41432550E+00  +1.46298389E+00  -2.22897195E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -8.00000000E-08  -7.30000000E-07  -1.26000000E-06
   +7.90000000E-07  -1.40000000E-07  -1.16000000E-06
   +1.50000000E-07  +6.30000000E-07  +2.40000000E-07
   -3.00000000E-08  +5.00000000E-08  -9.00000000E-08
   +2.90000000E-07  +3.00000000E-08  -4.00000000E-08
   +2.80000000E-07  -1.90000000E-07  +3.80000000E-07
   -5.00000000E-07  -8.10000000E-07  -2.60000000E-07
   -5.20000000E-07  -6.50000000E-07  +2.60000000E-07
   +4.20000000E-07  +6.00000000E-07  +1.26000000E-06
   -4.70000000E-07  -9.60000000E-07  +7.40000000E-07
   -6.70000000E-07  +2.20000000E-07  +2.20000000E-07
   +5.00000000E-07  +8.20000000E-07  -6.00000000E-08
   +1.50000000E-07  +6.10000000E-07  +7.00000000E-08
   +1.40000000E-07  +4.40000000E-07  -2.00000000E-08
   -3.30000000E-07  +6.00000000E-08  -4.40000000E-07
   -4.80000000E-07  -4.60000000E-07  +3.60000000E-07
   +4.90000000E-07  +8.00000000E-08  -3.00000000E-07
   +3.60000000E-07  +3.20000000E-07  -5.70000000E-07
   +3.30000000E-07  +2.20000000E-07  -1.11000000E-06
   +6.00000000E-08  +4.80000000E-07  -9.00000000E-08
   -1.50000000E-07  -1.02000000E-06  -1.70000000E-07
   +0.00000000E+00  -9.00000000E-07  -4.40000000E-07
   -4.70000000E-07  +0.00000000E+00  +8.70000000E-07
   -6.60000000E-07  +4.00000000E-08  +9.10000000E-07
   -1.40000000E-07  +3.20000000E-07  +2.60000000E-07
   -2.60000000E-07  -7.50000000E-07  +1.60000000E-07
   -4.00000000E-08  -2.70000000E-07  +7.90000000E-07
   -4.00000000E-07  -7.30000000E-07  +7.50000000E-07
   -1.60000000E-07  +2.70000000E-07  +8.60000000E-07
   +5.00000000E-07  -2.40000000E-07  -7.30000000E-07
   +2.40000000E-07  +7.30000000E-07  -8.70000000E-07
   +3.10000000E-07  -7.10000000E-07  -5.30000000E-07
   +3.20000000E-07  -3.00000000E-07  -9.30000000E-07
   +7.00000000E-08  +1.17000000E-06  +3.50000000E-07
   +5.00000000E-08  +1.01000000E-06  +2.60000000E-07
   -7.00000000E-08  +7.70000000E-07  +3.50000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +3.19762260E-01  +1.42423730E-01  +2.62313210E-01  -3.90238900E-02  +2.69789790E-01
   +5.33588200E-01  -2.30176690E-01  -1.26717740E-01  -3.77521000E-02  +6.00524710E-01
   -1.03216540E-01  -1.34247120E-01  -5.64608600E-02  +1.82969660E-01  +3.87672450E-01
   +3.54737000E-03  -3.29009900E-02  -1.03910000E-01  -1.04308210E-01  +2.07127280E-01
   +6.12574290E-01  -4.19419400E-02  -1.51970800E-02  +2.26714800E-02  -2.24137910E-01
   -4.42945600E-02  +7.19068300E-02  +5.87386800E-01  -3.41671800E-02  -1.10224000E-03
   +1.39795300E-02  -4.45336000E-03  -9.57780500E-02  -4.02585400E-02  +1.97179430E-01
   +3.73422780E-01  -8.87117000E-03  -3.81547000E-03  +1.16817300E-02  +1.38305040E-01
   -2.83340000E-03  -2.04376780E-01  -1.00038660E-01  +2.30395050E-01  +6.06507820E-01
   +2.66253000E-03  -2.27923000E-03  +6.29340000E-04  -5.02586000E-02  -8.07530000E-03
   +3.56442600E-02  -2.56021530E-01  -1.43016820E-01  -5.68909500E-02  +6.37218610E-01
   +1.85994000E-03  +3.75027000E-03  -7.42730000E-03  -3.59209100E-02  +1.45164200E-02
   +5.34513600E-02  -1.09860670E-01  -1.64026340E-01  -7.27708600E-02  +1.90937900E-01
   +3.62862740E-01  +7.46399000E-03  -3.70431000E-03  -5.87302000E-03  -1.12536800E-02
   +2.75593800E-02  +5.90233900E-02  -1.42052000E-03  -4.18489200E-02  -1.28786290E-01
   -1.31698910E-01  +1.87419220E-01  +5.76967500E-01  -1.44871000E-03  -2.28177000E-03
   -3.78085000E-03  -1.43884300E-02  +1.40564800E-02  +3.24002000E-02  +2.98454300E-02
   -4.45258000E-03  -2.77305400E-02  -1.17237940E-01  -3.60406300E-02  -1.69781900E-02
   +5.61475280E-01  -1.84445000E-03  -1.15129000E-03  +1.86878000E-03  +1.48483300E-02
   -8.59950000E-03  -1.83743400E-02  -2.92357200E-02  -1.82418500E-02  -1.69365500E-02
   -4.02574000E-03  -1.44044490E-01  -1.18198410E-01  +1.42606580E-01  +3.65624410E-01
   -4.32055000E-03  +1.41647000E-03  +4.99545000E-03  +3.44368300E-02  -1.76830500E-02
   -6.77946200E-02  -7.18816000E-02  -4.08588600E-02  +6.82469000E-03  +3.85311600E-02
   -8.78322500E-02  -2.52948580E-01  -1.16771280E-01  +1.61125260E-01  +5.63503730E-01
   -5.25440000E-04  +2.66382000E-03  +9.88792000E-03  +3.51101500E-02  -2.92352200E-02
   -8.07439600E-02  -6.21530300E-02  -2.47135300E-02  +1.32850300E-02  +3.04278300E-02
   +4.80490000E-02  +6.11164400E-02  -2.41065080E-01  -5.07148600E-02  +7.92094500E-02
   +5.78713200E-01  -4.64070000E-04  +4.74271000E-03  -3.72240000E-04  -1.76182000E-03
   -2.30228400E-02  -4.08380900E-02  -2.27191800E-02  -1.29639100E-02  +5.62216000E-03
   +2.28484300E-02  +2.38609800E-02  +4.74020000E-03  -1.83947200E-02  -9.43678700E-02
   -2.85311000E-02  +1.82630530E-01  +3.77119210E-01  +4.41220000E-03  -3.28648000E-03
   -4.66986000E-03  -3.33432100E-02  -1.51519900E-02  +7.87610000E-03  +1.55063200E-02
   +6.82626000E-03  -6.58752000E-03  +1.88766100E-02  -1.85396300E-02  -4.00699500E-02
   +1.33939180E-01  +6.95870000E-04  -1.91666010E-01  -1.04416330E-01  +2.21724770E-01
   +6.16491170E-01  -1.27129000E-03  -2.97431400E-02  -4.20216300E-02  -1.19872010E-01
   +6.57526000E-03  +5.71987200E-02  +3.11224300E-02  +2.18788400E-02  +1.55207800E-02
   -1.62492100E-02  -2.06183100E-02  -2.22751000E-02  -4.59723900E-02  -9.58155000E-03
   +3.43179400E-02  -2.51543930E-01  -1.38347130E-01  -5.23536100E-02  +6.35770030E-01
   -1.13125000E-02  -1.89566100E-02  -3.42507900E-02  -3.07552000E-02  -1.40039850E-01
   -8.74559900E-02  +4.44495300E-02  +2.39530400E-02  -1.57870500E-02  -1.90498300E-02
   -3.16435700E-02  -3.05348000E-02  -3.37284800E-02  +1.52657000E-02  +4.49564000E-02
   -1.05116170E-01  -1.61307820E-01  -6.91935700E-02  +2.00308490E-01  +3.58120780E-01
   -1.10239200E-02  -1.69932000E-02  -1.05404200E-02  -5.62287000E-03  -1.22459840E-01
   -2.73391680E-01  +5.35992300E-02  +5.59788000E-03  -3.25956000E-02  -1.95958800E-02
   -2.90227700E-02  -3.38248500E-02  -6.95050000E-03  +2.27126200E-02  +5.11124500E-02
   +2.83376000E-03  -3.88928200E-02  -1.27711020E-01  -1.40142220E-01  +1.97363060E-01
   +5.95389780E-01  +1.52198000E-03  +1.20654000E-03  +1.45060000E-04  -2.46226000E-03
   -1.15940000E-04  +1.20829000E-03  +3.94575000E-03  +4.56180000E-04  +2.03707000E-03
   -6.09670000E-04  -5.34132000E-03  -7.54393000E-03  -1.37159290E-01  -4.37391100E-02
   -7.15785000E-03  -1.83931400E-02  -1.49049700E-02  -3.69136000E-03  +1.69650000E-04
   -1.55508000E-03  +3.69283000E-03  +4.72321090E-01  +5.82360000E-04  -6.93300000E-05
   +3.89720000E-04  -3.71640000E-04  -6.50220000E-04  -4.89700000E-05  -1.03350000E-04
   +3.17882000E-03  -3.18139000E-03  -1.41215500E-02  -1.12942800E-02  -6.69278000E-03
   -4.54352000E-02  -1.05591600E-01  -1.65285000E-02  -4.93222000E-03  +1.43181000E-03
   +2.77434000E-03  -5.72540000E-04  +4.64382000E-03  -2.91239000E-03  +1.77111000E-03
   +4.80893950E-01  +8.32450000E-04  +1.16451000E-03  +5.58550000E-04  -5.84000000E-05
   -7.40720000E-04  -1.67154000E-03  +2.00745000E-03  -4.31566000E-03  -3.46419000E-03
   -2.38733500E-02  -1.66545600E-02  -2.63353000E-03  -1.07657700E-02  -1.85023800E-02
   -8.92562800E-02  +1.09615800E-02  +1.11219600E-02  +9.28538000E-03  +4.28376000E-03
   -1.73147000E-03  -5.11240000E-04  -2.78690000E-04  -9.43290000E-04  +4.80584010E-01
   -1.12938000E-03  -9.19570000E-04  -4.47920000E-04  +5.28820000E-04  +6.15230000E-04
   +6.71110000E-04  -2.53560000E-04  +5.77380000E-04  +3.09620000E-04  -3.40170000E-04
   -1.01183000E-03  +5.34520000E-04  -3.68538000E-03  -2.28208400E-02  +1.68851500E-02
   -5.43390000E-04  -1.57473000E-03  -1.23565000E-03  -1.29446000E-03  +4.25200000E-04
   -1.14909000E-03  -7.57520300E-02  -1.03678000E-03  +8.27640000E-04  +5.87238310E-01
   -3.83090000E-04  -3.61230000E-04  -1.98370000E-04  +5.93900000E-05  +3.79040000E-04
   +5.68340000E-04  -4.03300000E-05  +7.30530000E-04  +2.46420000E-04  -9.28400000E-05
   -4.76220000E-04  +1.07506000E-03  -9.77595000E-03  -2.47501200E-02  +1.23648000E-02
   +1.67333000E-03  -7.93060000E-04  -8.16560000E-04  -7.17660000E-04  +1.12130000E-04
   -9.42990000E-04  +4.18178000E-03  -1.33077100E-01  +5.03096300E-02  +4.53232000E-03
   +5.09124530E-01  -6.96120000E-04  -5.52820000E-04  -3.44920000E-04  +2.12480000E-04
   +3.09400000E-04  +6.57580000E-04  +3.04720000E-04  +2.45530000E-04  -1.02810000E-04
   -1.71686000E-03  -1.38727000E-03  -3.07880000E-04  +4.84336000E-03  +6.43390000E-04
   +4.67692000E-03  -4.25090000E-04  -5.33630000E-04  -4.85030000E-04  -3.86590000E-04
   -2.02990000E-04  -5.73750000E-04  -2.61561000E-03  +4.66526900E-02  -1.15547350E-01
   -5.55507000E-03  +6.21686100E-02  +5.44004360E-01  -5.77050000E-04  -4.36440000E-04
   -1.79280000E-04  +3.96860000E-04  +2.44970000E-04  +1.79030000E-04  +3.66800000E-04
   -8.43020000E-04  -1.08535000E-03  -4.79069000E-03  -2.87516000E-03  +2.33130000E-04
   +7.63890000E-04  -1.07174900E-02  -2.65485800E-02  -1.87757000E-03  -1.04301000E-03
   -1.16950000E-03  +2.00200000E-04  -2.47760000E-04  -8.31680000E-04  -7.56873900E-02
   +1.88649000E-03  +5.86202000E-03  +5.22350000E-04  -1.24840000E-04  +1.55320000E-04
   +5.86421900E-01  -8.54300000E-05  -8.78000000E-05  -5.16900000E-05  -8.65000000E-05
   +1.26070000E-04  -1.06680000E-04  +2.11470000E-04  -4.21420000E-04  -7.86600000E-04
   -3.38432000E-03  -8.64440000E-04  +9.35500000E-05  -2.64041000E-03  -9.72580000E-03
   -2.07771900E-02  -8.05230000E-04  -1.06946000E-03  +3.92370000E-04  +5.79230000E-04
   -3.06960000E-04  -7.12360000E-04  -1.09915000E-03  -8.84397700E-02  -3.54135000E-02
   -1.27157000E-03  +7.73620000E-03  +2.58230800E-02  +1.31459000E-03  +5.67636000E-01
   +2.66520000E-04  +1.89680000E-04  +2.94500000E-05  -2.76590000E-04  -9.53700000E-05
   +2.22990000E-04  +5.05370000E-04  +4.32300000E-05  -6.88000000E-05  +3.00200000E-05
   +4.21620000E-04  +3.69240000E-04  -5.41115000E-03  -5.40065000E-03  -7.68156000E-03
   +7.91400000E-04  +5.54490000E-04  +3.20600000E-04  +3.76890000E-04  -3.27600000E-05
   -3.79790000E-04  -1.94700000E-04  -3.19485100E-02  -1.59463020E-01  +1.17414000E-03
   -2.80883000E-03  -3.43563400E-02  -8.99460000E-04  -4.84974400E-02  +4.82510670E-01
   +1.23740000E-04  +8.68000000E-05  -2.51400000E-05  -2.98490000E-04  +1.57300000E-05
   +4.78410000E-04  +3.67890000E-04  +4.88870000E-04  +7.11050000E-04  -6.11450000E-04
   +7.52410000E-04  -3.70530000E-04  -3.61382200E-02  +6.93377000E-03  +3.15001000E-03
   -7.65730000E-04  -6.24500000E-05  -2.29973000E-03  -1.93080000E-04  -1.04958000E-03
   +4.53830000E-04  -1.42539980E-01  +4.15004300E-02  +9.78739000E-03  -1.68196000E-03
   +6.69793000E-03  -3.45697000E-03  -6.01143000E-03  +7.54202000E-03  +1.00310000E-02
   +5.75978130E-01  -6.48930000E-04  -6.02230000E-04  -3.22030000E-04  +1.07000000E-04
   +6.93260000E-04  +6.72130000E-04  +2.12040000E-04  -1.45380000E-04  -1.40200000E-05
   -2.05732000E-03  -4.46240000E-04  -6.90960000E-04  -1.19818000E-02  +1.21353000E-02
   +4.37702000E-03  -1.45577000E-03  -2.33733000E-03  -1.56238000E-03  -6.43920000E-04
   -1.09247000E-03  +3.40340000E-04  +3.81570400E-02  -1.07628590E-01  +5.34017000E-03
   +2.40252500E-02  -1.80992900E-02  -1.31297000E-03  +1.30907900E-02  -1.10058500E-02
   -9.16087000E-03  -4.94083200E-02  +5.36621280E-01  -4.15350000E-04  -4.21730000E-04
   -9.19200000E-05  +2.68770000E-04  +2.48710000E-04  +1.21670000E-04  -2.24360000E-04
   +3.55420000E-04  +6.72700000E-05  -2.33764000E-03  -7.87850000E-04  -2.55210000E-04
   -1.82082000E-03  +2.35131000E-03  +5.19750000E-04  -4.27400000E-05  +6.89900000E-05
   -3.78820000E-04  -1.02160000E-04  -1.24390000E-04  -4.97100000E-05  +1.25461800E-02
   +3.59436000E-03  -7.55400000E-02  -1.92685700E-02  +1.23539000E-02  +2.28427000E-03
   +2.72354500E-02  -1.93280500E-02  -7.19212000E-03  -1.47649730E-01  -1.80482920E-01
   +3.53269280E-01  -4.03220000E-04  -2.74940000E-04  -1.12450000E-04  +4.97500000E-04
   +2.17820000E-04  -3.19680000E-04  -4.48480000E-04  -3.98620000E-04  +1.64480000E-04
   +6.60610000E-04  -4.09800000E-05  +5.64010000E-04  -7.93080000E-04  +1.75254000E-03
   +7.25310000E-04  -8.27460000E-04  -7.97170000E-04  -2.83870000E-04  +1.08860000E-04
   +7.64100000E-05  +2.84910000E-04  -1.93681200E-02  -3.99788000E-03  +1.24104800E-02
   -1.77597000E-03  +1.27680000E-04  +1.20323000E-03  -1.03030000E-03  -1.17873000E-03
   -1.31174000E-03  -2.37629750E-01  -9.87086000E-03  +8.26648300E-02  +5.81417090E-01
   +1.32400000E-04  +8.86600000E-05  +4.55800000E-05  -1.67630000E-04  -1.63600000E-05
   +1.08810000E-04  +1.92880000E-04  +2.13540000E-04  -1.24200000E-05  -2.42010000E-04
   +1.07460000E-04  -5.98000000E-06  +1.39256000E-03  -2.14769000E-03  -1.08860000E-03
   +5.79910000E-04  +6.81410000E-04  +1.84470000E-04  +1.13700000E-05  +7.04000000E-05
   -2.22420000E-04  +1.32414900E-02  +9.83389000E-03  -8.06657000E-03  +1.21585000E-03
   -5.24140000E-04  -5.30700000E-04  +1.38682000E-03  -9.12520000E-04  -1.41030000E-04
   -7.02753000E-02  -1.31006420E-01  +6.96932300E-02  -9.83186000E-02  +6.05727230E-01
   +3.99300000E-05  -4.95000000E-06  +3.49500000E-05  -2.66570000E-04  +9.77000000E-06
   +2.52040000E-04  +2.64460000E-04  +2.80990000E-04  +1.55850000E-04  -4.76590000E-04
   +2.25000000E-06  -8.10480000E-04  -1.63079000E-03  -2.45110000E-04  -1.39590000E-04
   +2.76490000E-04  +2.19430000E-04  +1.37820000E-04  -1.58500000E-04  -3.23050000E-04
   -9.04300000E-05  +3.79028000E-03  -7.65140000E-04  +2.73383000E-03  -4.79390000E-04
   -6.11320000E-04  -4.24950000E-04  -2.82860000E-04  +3.46520000E-04  +7.39200000E-05
   +1.17910830E-01  +4.46885000E-02  -1.41805020E-01  -1.44390610E-01  -2.41321590E-01
   +3.28834490E-01  +5.34670000E-04  +3.80620000E-04  +1.34350000E-04  -4.82770000E-04
   -3.00010000E-04  +2.48600000E-05  +3.65510000E-04  +3.24500000E-05  -2.73440000E-04
   -2.31330000E-04  +1.29260000E-04  +1.32720000E-04  -3.80960000E-04  +8.15900000E-05
   +3.49500000E-05  +1.69600000E-04  +1.60440000E-04  +4.55900000E-05  +3.29800000E-05
   -3.79000000E-06  +1.85000000E-05  -1.50920000E-03  -6.29820000E-04  +3.20530000E-03
   +6.20430000E-04  -9.01740000E-04  +1.77500000E-05  -6.91940000E-04  +5.30590000E-04
   +1.38880000E-04  -5.63963700E-02  -1.82004700E-02  +3.86235800E-02  -2.49214830E-01
   +1.43821630E-01  +3.53223000E-03  +4.64490690E-01  +3.16160000E-04  +2.90840000E-04
   +1.56620000E-04  -6.93900000E-05  -3.11800000E-04  -4.82550000E-04  -2.57380000E-04
   -1.91890000E-04  +8.26400000E-05  +5.84000000E-04  -9.95100000E-05  +8.71700000E-05
   +8.78810000E-04  -7.06090000E-04  -4.61260000E-04  -2.98870000E-04  -2.51700000E-04
   +3.63150000E-04  +2.13410000E-04  +4.12760000E-04  +2.54410000E-04  -3.38700000E-04
   +1.77622000E-03  +2.32977000E-03  +5.48520000E-04  -4.20970000E-04  -1.85690000E-04
   +3.23980000E-04  -6.21690000E-04  +3.37180000E-04  +3.25935600E-02  +4.99195200E-02
   -3.85611300E-02  +9.88539900E-02  -1.73717440E-01  +2.90043900E-02  -1.66130310E-01
   +5.44177950E-01  -3.62210000E-04  -2.58200000E-04  -1.15080000E-04  +2.82030000E-04
   +2.02900000E-04  +1.94190000E-04  -6.70100000E-05  +8.31600000E-05  +7.51000000E-05
   +5.07100000E-05  -6.48900000E-05  -2.24960000E-04  +7.30380000E-04  -1.76700000E-04
   -1.63110000E-04  +2.28910000E-04  +1.40700000E-04  +1.88300000E-05  -1.02210000E-04
   -7.85600000E-05  -1.83090000E-04  +3.84384000E-03  +3.02849000E-03  +3.43286000E-03
   -7.64730000E-04  +3.77180000E-04  -3.78500000E-05  -1.65597000E-03  +9.57270000E-04
   -3.06000000E-05  +8.70230000E-03  -1.71581100E-02  +1.33104700E-02  +2.94324300E-02
   +9.97165000E-03  -6.78024800E-02  -6.57095700E-02  -1.92570350E-01  +2.34759980E-01
   +6.23430000E-04  +4.92390000E-04  +1.63660000E-04  -5.34920000E-04  -3.62220000E-04
   -1.00230000E-04  +2.82230000E-04  +5.57000000E-06  -2.49780000E-04  -1.57630000E-04
   +1.65780000E-04  +1.47570000E-04  -2.39450000E-04  -3.17710000E-04  -1.96500000E-05
   +1.19040000E-04  +2.43930000E-04  +5.05100000E-05  +1.09120000E-04  +1.15740000E-04
   +5.54200000E-05  -2.43032000E-03  +1.58800000E-04  -1.10980000E-04  +2.17180000E-04
   +2.69160000E-04  -1.85500000E-04  +5.31840000E-04  -1.30380000E-04  +7.69800000E-05
   -1.17416300E-02  -2.88998200E-02  +2.30504300E-02  +3.26606200E-02  +2.10746300E-02
   -2.67103100E-02  -9.82190200E-02  +5.03924300E-02  -8.94122000E-03  +6.15876210E-01
   -3.89380000E-04  -3.36890000E-04  -1.64050000E-04  +1.65770000E-04  +3.38180000E-04
   +4.38810000E-04  +1.80600000E-04  +1.57270000E-04  -1.49700000E-05  -3.47140000E-04
   -1.34900000E-05  -2.38370000E-04  -4.19770000E-04  +7.86040000E-04  +4.05440000E-04
   +2.32510000E-04  +1.71830000E-04  -2.08500000E-04  -2.02680000E-04  -3.87710000E-04
   -2.38350000E-04  -8.05780000E-04  -1.11849000E-03  +7.19010000E-04  -2.06780000E-04
   -3.02800000E-05  -1.63000000E-05  -7.53640000E-04  +7.25360000E-04  -2.63300000E-04
   -2.57090500E-02  -3.61198600E-02  +3.25257100E-02  +6.19716900E-02  -3.26151200E-02
   -8.17073000E-03  -8.77574000E-03  -2.84838960E-01  +1.41116150E-01  -1.18103390E-01
   +6.36543250E-01  -2.96100000E-05  -1.90100000E-05  +2.35300000E-05  +1.29080000E-04
   -2.01600000E-05  -2.84830000E-04  -2.65210000E-04  -1.82510000E-04  +1.04080000E-04
   +3.24300000E-04  -1.25020000E-04  +1.33040000E-04  +3.81760000E-04  -1.31940000E-04
   -1.62660000E-04  -3.30900000E-04  -2.18700000E-04  +1.04940000E-04  +1.37800000E-04
   +1.68560000E-04  +1.54880000E-04  +8.28410000E-04  +7.94300000E-05  -1.33098000E-03
   -1.91200000E-05  +5.53500000E-05  +2.11310000E-04  +4.25450000E-04  -4.96510000E-04
   +2.25350000E-04  +2.06704600E-02  +3.39344000E-02  -2.89325400E-02  -5.15663200E-02
   +9.14450000E-03  +1.53944000E-02  +2.59829900E-02  +1.14684340E-01  -1.30542830E-01
   -1.41725600E-01  -2.39710890E-01  +3.39604560E-01  +5.35300000E-05  +5.49600000E-05
   +6.89100000E-05  +7.34900000E-05  -1.43040000E-04  -4.37800000E-04  -4.04760000E-04
   -3.02770000E-04  +1.58610000E-04  +5.35310000E-04  -1.97230000E-04  +2.54160000E-04
   +3.93990000E-04  +5.49800000E-05  -3.86570000E-04  -4.47160000E-04  -4.42690000E-04
   +1.76540000E-04  +1.98810000E-04  +2.91750000E-04  +2.58770000E-04  +3.21471000E-03
   -1.18393000E-03  +1.49212000E-03  +6.40390000E-04  -3.87340000E-04  +3.23960000E-04
   -8.58900000E-05  -1.51270000E-04  +2.57890000E-04  +2.91715700E-02  +7.13309000E-02
   -5.53175600E-02  -7.05305200E-02  +7.66972000E-03  +2.61570400E-02  +4.08095000E-02
   -7.25749600E-02  +2.60250100E-02  -2.19901630E-01  +4.25298000E-03  +6.33275400E-02
   +6.67602370E-01  -1.07661000E-03  -9.38170000E-04  -3.31720000E-04  +8.55720000E-04
   +6.96510000E-04  +5.27930000E-04  -1.22410000E-04  +7.78500000E-05  +2.72110000E-04
   -1.36710000E-04  +3.38020000E-04  -7.47900000E-05  -8.06650000E-04  +7.08340000E-04
   -2.15970000E-04  +4.79120000E-04  +3.35880000E-04  -5.21010000E-04  -1.76880000E-04
   -4.41460000E-04  -3.28540000E-04  -2.61840000E-04  -2.18060000E-03  +4.49144000E-03
   +7.44920000E-04  -2.97250000E-04  -2.72160000E-04  -8.78390000E-04  +6.37730000E-04
   +2.92990000E-04  +2.45419300E-02  -3.06647200E-02  +7.76472000E-03  +5.94804000E-03
   +4.18243000E-03  -3.92417000E-03  -2.20148400E-02  -1.23770200E-02  +1.87803100E-02
   -7.99231700E-02  -1.13652950E-01  +6.01769400E-02  -1.12975380E-01  +5.84772470E-01
   +5.26170000E-04  +4.41850000E-04  +1.20200000E-04  -5.00190000E-04  -2.88450000E-04
   +2.04900000E-05  +3.35250000E-04  +1.80990000E-04  -2.79240000E-04  -2.90850000E-04
   -4.47500000E-05  +4.93000000E-06  +2.68320000E-04  -1.39900000E-05  -9.76600000E-05
   +1.28680000E-04  +1.56010000E-04  +1.20070000E-04  -6.87000000E-06  +1.47000000E-05
   -5.62000000E-06  +2.14590000E-04  +3.61996000E-03  +8.80960000E-04  -3.14350000E-04
   +3.39840000E-04  +1.56640000E-04  +2.04580000E-04  +1.34490000E-04  -4.04800000E-05
   -2.60316500E-02  -1.23951800E-02  +2.12848900E-02  +2.80714800E-02  -4.56255000E-03
   -7.16311000E-03  -3.72438000E-03  +4.07400600E-02  -1.94588100E-02  +1.11540370E-01
   +2.30753000E-02  -1.33066490E-01  -1.61279720E-01  -2.07086560E-01  +3.32327270E-01
   -4.21500000E-04  -3.94880000E-04  -1.59580000E-04  +1.25460000E-04  +3.22120000E-04
   +5.82100000E-04  +3.97560000E-04  +2.73410000E-04  -1.94700000E-05  -1.24837000E-03
   +4.60560000E-04  -6.23990000E-04  -1.38473000E-03  +3.05813000E-03  -1.00242000E-03
   +8.52810000E-04  +7.05020000E-04  -6.11380000E-04  -2.76070000E-04  -6.81450000E-04
   -2.92380000E-04  -1.96100000E-03  +2.46607500E-02  -1.39549100E-02  -5.19858000E-03
   +2.43046000E-03  +1.51185000E-03  -5.91890000E-04  +9.68880000E-04  -1.36861000E-03
   -1.16323250E-01  -8.43513000E-03  +2.87476300E-02  +3.21688300E-02  -2.40109100E-02
   +4.05900000E-03  -2.03869900E-02  +2.52264100E-02  -6.13444000E-03  -4.90338000E-02
   -1.37362500E-02  +3.05151500E-02  -2.82463710E-01  +1.41638580E-01  +1.45145400E-02
   +6.66424330E-01  +2.03640000E-04  +1.98890000E-04  +1.14130000E-04  -2.61890000E-04
   -1.72510000E-04  +6.36100000E-05  +1.32800000E-04  +2.94740000E-04  +1.33820000E-04
   -3.29100000E-05  -3.72260000E-04  -8.59680000E-04  -2.70450000E-04  -9.70630000E-04
   +4.60690000E-04  -9.50000000E-05  -2.02800000E-05  +3.30300000E-04  -1.61950000E-04
   -1.77500000E-04  +1.16220000E-04  +9.13963000E-03  -1.63858300E-02  +6.61782000E-03
   +2.08889000E-03  +9.90000000E-07  -6.19110000E-04  +6.25600000E-04  -4.83110000E-04
   +1.19523000E-03  +4.48705200E-02  -2.54635410E-01  +9.09626100E-02  -6.65331300E-02
   -7.54671000E-03  +3.71164200E-02  +3.17920300E-02  -4.96939100E-02  +1.51885200E-02
   +3.00248900E-02  +5.31783800E-02  -4.23002100E-02  +7.10359700E-02  -1.76130510E-01
   +3.72962700E-02  -8.80933400E-02  +5.69729620E-01  -6.44000000E-05  -5.43200000E-05
   -4.84200000E-05  +3.16900000E-05  +1.13630000E-04  +3.25540000E-04  +3.16020000E-04
   +2.81060000E-04  +1.71000000E-06  -8.40750000E-04  +6.88160000E-04  -3.21410000E-04
   -1.00727000E-03  +4.65310000E-04  +2.60860000E-04  +5.90420000E-04  +3.44450000E-04
   -5.39430000E-04  -1.14910000E-04  -4.24000000E-05  -1.98430000E-04  -3.77629000E-03
   -1.56315000E-03  +4.49675000E-03  +1.33210000E-03  -1.69410000E-04  -1.02000000E-04
   +1.09586000E-03  -9.50770000E-04  -5.14740000E-04  -3.57114000E-03  +1.13936190E-01
   -1.29220130E-01  +2.90495600E-02  +1.89810600E-02  -1.61848600E-02  -1.00781500E-02
   +1.84022600E-02  -6.71889000E-03  +4.68131000E-03  -2.36218800E-02  +1.43775200E-02
   +5.53877800E-02  +7.15775000E-03  -8.76158600E-02  -1.77519260E-01  -2.17097540E-01
   +3.27951460E-01  -9.38010000E-04  -7.41440000E-04  -3.02890000E-04  +7.22570000E-04
   +5.94750000E-04  +3.70910000E-04  -2.32140000E-04  +5.36700000E-05  +2.23440000E-04
   -1.20960000E-04  -5.47500000E-05  -1.23380000E-04  +1.77100000E-05  +8.30850000E-04
   +1.38020000E-04  +5.01800000E-05  -6.43600000E-05  -3.11970000E-04  -1.83250000E-04
   -3.13270000E-04  -2.37060000E-04  +1.72824000E-03  -4.90560000E-04  +7.66740000E-04
   -5.22520000E-04  -1.50910000E-04  +2.81820000E-04  -1.27677000E-03  +6.35430000E-04
   -4.68600000E-04  -8.89720000E-04  +4.46303000E-03  -3.77887000E-03  -2.23238000E-03
   -2.15367000E-03  +3.73259000E-03  -6.05798000E-03  +1.48143300E-02  -3.84258000E-03
   -2.50420560E-01  +8.36197500E-02  +4.44369800E-02  -5.00427500E-02  +3.59491500E-02
   +5.76251000E-03  +3.33616000E-03  -6.80659000E-03  +4.89678000E-03  +3.52173420E-01
   +7.15080000E-04  +5.97250000E-04  +2.35440000E-04  -5.08390000E-04  -4.77500000E-04
   -3.29490000E-04  +1.35640000E-04  -3.57300000E-05  -1.68470000E-04  +1.35570000E-04
   +8.81500000E-05  +1.22480000E-04  +1.03690000E-04  -8.30980000E-04  -1.60350000E-04
   -5.74900000E-05  +3.43400000E-05  +2.56170000E-04  +1.65940000E-04  +3.20790000E-04
   +1.98200000E-04  -9.66440000E-04  +6.32700000E-04  -6.85140000E-04  +4.31780000E-04
   +4.76400000E-05  -2.05510000E-04  +9.22290000E-04  -5.07770000E-04  +3.74310000E-04
   +2.44486000E-03  -8.31240000E-04  -6.83320000E-04  -3.94936000E-03  -1.92310000E-04
   +4.10999000E-03  +4.51150800E-02  -3.11870600E-02  +9.25490000E-04  +1.30141770E-01
   -1.53783780E-01  +9.22762000E-03  +5.03134000E-03  -3.19047000E-03  +5.16384000E-03
   -1.82442000E-03  -4.62060000E-04  +4.26906000E-03  -9.57261000E-02  +5.45347740E-01
   +3.82400000E-05  +3.39500000E-05  +2.32200000E-05  -3.72700000E-05  -2.18800000E-05
   -4.24000000E-06  +2.34600000E-05  +1.16000000E-05  -8.73000000E-06  +2.74600000E-05
   -3.60500000E-05  -7.28700000E-05  +7.76000000E-05  -8.80600000E-05  +1.19410000E-04
   -2.03000000E-06  -4.45900000E-05  +4.90400000E-05  -2.80200000E-05  +2.13000000E-06
   +1.82900000E-05  +9.98000000E-06  -4.86300000E-05  +2.25440000E-04  +4.31700000E-05
   +1.62400000E-05  -2.61200000E-05  -1.55840000E-04  +1.31100000E-04  -7.42600000E-05
   -1.82871000E-03  -2.20796000E-03  +7.31830000E-04  +5.10635000E-03  +3.24766000E-03
   -3.47960000E-04  -2.16969400E-02  +1.45601400E-02  +5.74278000E-03  +1.75756400E-02
   +2.95213100E-02  -6.42563400E-02  +2.33230000E-02  -8.32865000E-03  +4.40996000E-03
   +2.11572000E-03  +6.36186000E-03  +8.75770000E-04  -8.78541100E-02  -2.58636070E-01
   +2.15145000E-01  -4.68516700E-02  +2.84621600E-02  +9.20768800E-02  +1.92130000E-04
   -1.99021000E-02  -3.74832200E-02  +1.40545000E-03  -2.54990000E-04  -2.56834000E-03
   -5.96800000E-04  -1.16810000E-04  -2.17590000E-04  -1.33510000E-04  +2.28430000E-04
   +6.08910000E-04  +1.54097000E-03  -6.21150000E-04  -7.55240000E-04  -4.87738000E-03
   -3.92287000E-03  -5.81900000E-05  -1.72150000E-04  +1.24500000E-05  +1.02270000E-04
   +3.35400000E-05  -7.25000000E-06  -1.89700000E-05  +7.23200000E-05  +2.78100000E-05
   -9.60000000E-06  -2.99500000E-05  -1.08200000E-05  +2.78100000E-05  +3.64600000E-05
   +7.46000000E-06  -2.39000000E-06  -9.09700000E-05  -2.39500000E-05  +6.06900000E-05
   -7.83100000E-05  +3.81500000E-05  +2.33000000E-06  -1.12100000E-05  +7.73300000E-05
   -4.55500000E-05  +1.82200000E-05  +2.12100000E-05  +2.54000000E-05  +1.12120000E-04
   -6.73700000E-05  +2.59000000E-06  +5.06374900E-02  +4.53549000E-03  -1.11187290E-01
   -1.91775380E-01  +2.22899000E-03  -1.68915100E-02  -2.65881100E-02  +2.87930000E-03
   +1.53352000E-03  +1.40437000E-03  +7.12900000E-05  -8.34830000E-04  -3.44590000E-04
   -6.40800000E-05  +3.28460000E-04  +5.25800000E-04  +2.91340000E-04  +8.91610000E-04
   -1.65952000E-03  -4.69880000E-03  -4.43240000E-04  +1.61610000E-04  -1.65110000E-04
   -7.28900000E-05  -7.08000000E-06  +5.73800000E-05  +9.99000000E-06  +2.88200000E-05
   +7.00100000E-05  +6.73000000E-06  -1.55900000E-05  -2.09700000E-05  +7.61800000E-05
   +6.46200000E-05  +5.50900000E-05  -1.78200000E-05  +5.72000000E-06  -7.51500000E-05
   -3.47300000E-05  +4.56600000E-05  -1.13730000E-04  +5.75500000E-05  +1.49200000E-05
   +3.05000000E-06  +2.08900000E-04  -1.09400000E-04  +6.47200000E-05  -2.72200000E-05
   -1.11000000E-06  +1.41260000E-04  -1.21200000E-04  -5.82000000E-06  -4.46904000E-03
   +1.26666490E-01  +5.01248300E-02  -2.15585320E-01  -4.27999490E-01  +1.30192000E-03
   -4.56087000E-03  -1.18728600E-02  +2.81518000E-03  +4.41236000E-03  +3.90743000E-03
   +7.54000000E-05  -2.37390000E-04  -1.06766000E-03  +8.90900000E-05  +1.56920000E-04
   +4.64160000E-04  +7.42020000E-04  -7.89780000E-04  -2.90210000E-04  -1.29274000E-03
   -5.54430000E-04  +2.34586000E-03  -1.74250000E-04  -2.02000000E-05  -1.67760000E-04
   +1.36590000E-04  +6.32800000E-05  +8.97400000E-05  +4.94300000E-05  +6.16000000E-06
   -2.06600000E-05  -7.25000000E-06  +4.91900000E-05  +4.08600000E-05  +3.19400000E-05
   -1.54000000E-06  -1.73600000E-05  -5.64800000E-05  -3.99200000E-05  +4.02300000E-05
   -4.67500000E-05  +4.07900000E-05  -4.60000000E-06  -1.65200000E-05  +5.53500000E-05
   -1.83700000E-05  +2.43200000E-05  -1.64700000E-05  +2.04500000E-05  +8.98500000E-05
   -6.17500000E-05  -1.03600000E-05  -5.34078300E-02  +2.17270490E-01  +4.34831440E-01
   +1.82917000E-03  +2.75581000E-03  -6.25120000E-04  +3.90270000E-03  +1.22771900E-02
   +2.06564400E-02  -5.56163600E-02  -6.32913000E-03  +9.88314000E-03  +4.78155000E-03
   -1.23935600E-02  -2.27012500E-02  -2.15834000E-03  -5.14845000E-03  +4.89910000E-04
   -1.62104000E-03  -3.97440000E-04  -1.50100000E-05  -2.74236000E-03  -2.05875000E-03
   +4.22145000E-03  +6.12610000E-04  -4.24240000E-04  -9.77960000E-04  +1.49900000E-05
   +9.36000000E-05  -7.88800000E-05  -3.61490000E-04  -1.58950000E-04  +4.34900000E-05
   +1.33550000E-04  -3.77700000E-05  -1.32100000E-05  -2.95100000E-05  +1.72700000E-05
   +9.78000000E-06  +1.29000000E-05  +2.83000000E-05  -6.73000000E-06  +3.86700000E-05
   -2.34700000E-05  -5.66000000E-06  -1.07200000E-05  -6.35500000E-05  +4.06700000E-05
   -2.80000000E-05  +2.23700000E-05  +1.85400000E-05  -6.32300000E-05  +6.09500000E-05
   +1.08400000E-05  -8.91790000E-04  -1.02159000E-03  -4.25240000E-04  +5.22069000E-02
   +2.45579000E-03  -7.69710000E-04  +2.84013000E-03  -3.21838000E-03  +3.04646000E-03
   +1.30499000E-03  -6.38498000E-03  -1.14420990E-01  -1.29435560E-01  +2.09899000E-03
   -5.95094000E-03  -1.63321800E-02  -5.28922000E-03  +3.26931000E-03  -2.10416000E-03
   -1.54260000E-04  -5.80700000E-04  +6.58390000E-04  -1.80557000E-03  +3.86110000E-03
   -9.18610000E-04  +2.09950000E-04  +1.19040000E-04  -8.40130000E-04  -5.31400000E-05
   -8.80000000E-06  -1.65300000E-05  -2.82130000E-04  -2.22590000E-04  +3.85200000E-05
   +2.06670000E-04  -9.49000000E-05  -3.49100000E-05  -6.11900000E-05  +2.37700000E-05
   +5.22300000E-05  +5.30300000E-05  +8.05000000E-06  -2.47000000E-05  +4.08000000E-05
   -1.05400000E-05  -1.23000000E-05  -9.48000000E-06  -2.93000000E-05  +4.73000000E-06
   +1.39800000E-05  +3.26500000E-05  +1.56100000E-05  -6.39400000E-05  +4.00200000E-05
   +8.61000000E-06  +3.89220000E-04  +3.06490000E-04  -8.07800000E-04  +9.90465000E-03
   +1.14357210E-01  -1.26731000E-03  +2.52454000E-03  +1.56970000E-03  -5.04374000E-03
   -1.31936400E-02  -1.32849900E-02  +9.58022000E-03  -1.29488420E-01  -2.58824510E-01
   +1.59190000E-03  -2.57545000E-03  -3.16303000E-03  -7.83700000E-05  -2.60929000E-03
   +3.26424000E-03  +2.79220000E-04  +8.69260000E-04  +3.09780000E-04  +4.71372000E-03
   -5.84540000E-04  +5.08000000E-06  +4.76880000E-04  -1.33600000E-04  -2.13080000E-04
   -4.85700000E-05  +2.44100000E-05  -6.98600000E-05  -1.70330000E-04  -3.74500000E-05
   +4.44200000E-05  +7.77000000E-06  -5.06700000E-05  -1.67800000E-05  -1.74500000E-05
   +1.33300000E-05  -3.09500000E-05  +3.54900000E-05  +4.09700000E-05  -2.68700000E-05
   +6.58400000E-05  -4.74900000E-05  -1.00000000E-08  -1.80000000E-06  -1.36750000E-04
   +8.12300000E-05  -5.49300000E-05  +1.15900000E-05  +2.54000000E-06  -9.51500000E-05
   +8.77500000E-05  +4.66000000E-06  +1.96256000E-03  +4.87220000E-04  -4.18520000E-04
   -1.03803400E-02  +1.43176180E-01  +2.72193740E-01  -1.39601000E-03  -2.77120000E-04
   +6.85200000E-04  -2.29140000E-04  -5.03330000E-03  -9.97520000E-04  -1.45516600E-02
   -1.92410000E-04  +1.67921700E-02  -2.25146260E-01  -1.62646500E-02  +1.40080440E-01
   +3.49997000E-03  -4.25370000E-04  -2.05470000E-04  +2.28705000E-03  -1.77723000E-03
   +6.21270000E-04  -7.39500000E-05  +8.63300000E-05  -9.19520000E-04  -8.35860000E-04
   +5.47270000E-04  -8.68990000E-04  -5.43400000E-05  -1.84030000E-04  +8.56700000E-05
   -4.30000000E-07  +1.46440000E-04  -3.41100000E-05  -4.81840000E-04  -3.82390000E-04
   -7.29390000E-04  +4.95000000E-05  -3.81900000E-05  -5.59400000E-05  -2.50050000E-04
   +1.58070000E-04  +5.34400000E-05  -2.24180000E-04  -4.12800000E-05  +1.46000000E-04
   +2.70060000E-04  +1.39480000E-04  -1.29990000E-04  -2.27890000E-04  -1.19190000E-04
   -2.77950000E-04  +1.27700000E-04  -9.48700000E-05  -1.81900000E-05  +9.70800000E-05
   +1.64510000E-04  +1.86420000E-04  -5.66200000E-05  +1.63481000E-03  -1.21885000E-03
   +2.36790540E-01  -9.69090000E-04  -2.50300000E-04  +6.28580000E-04  -4.85136000E-03
   +2.81842000E-03  -4.18954000E-03  -1.52096600E-02  +2.93917000E-03  +1.19682200E-02
   -1.55883100E-02  -4.85971600E-02  -8.13890000E-04  +1.32020300E-02  +5.81344000E-03
   -9.45773000E-03  -2.28616000E-03  +2.19415000E-03  -5.10182000E-03  +9.91900000E-05
   -1.10263000E-03  +6.08700000E-05  +1.36540000E-03  -1.58789000E-03  +1.16981000E-03
   -9.80400000E-05  -4.91260000E-04  -5.47210000E-04  +1.63990000E-04  -2.39900000E-05
   +1.23440000E-04  -3.08480000E-04  +1.70920000E-04  -2.44520000E-04  +1.66120000E-04
   -1.10940000E-04  -9.29600000E-05  -1.69510000E-04  +1.78740000E-04  +1.20200000E-05
   -1.79010000E-04  -1.30570000E-04  +1.65740000E-04  +3.25600000E-04  -2.86800000E-05
   -1.84670000E-04  -2.11020000E-04  +9.32000000E-05  -2.22400000E-04  +9.49100000E-05
   -9.07500000E-05  -7.62000000E-06  +7.42900000E-05  +8.67800000E-05  +1.35640000E-04
   +1.96494000E-03  -2.36634000E-03  +1.83999000E-03  +2.19197100E-02  +4.18516900E-02
   -2.73840000E-04  +4.77100000E-05  +2.87020000E-04  -6.06450000E-04  -3.83708000E-03
   +2.35795000E-03  -7.29167000E-03  -1.51607000E-03  +8.19530000E-03  +1.39548040E-01
   -8.63900000E-05  -1.64785830E-01  +2.21521800E-02  +2.49717000E-03  -1.14990200E-02
   +4.19150000E-04  -5.53300000E-03  -3.01614000E-03  -1.11696000E-03  -1.02190000E-04
   -3.98330000E-04  +4.63150000E-04  +1.85400000E-03  -5.01900000E-04  -4.05000000E-06
   -8.23900000E-05  -1.88620000E-04  -1.85500000E-04  +3.22900000E-05  -3.95000000E-06
   -4.46740000E-04  -4.65360000E-04  -5.99200000E-05  -2.77260000E-04  +1.56970000E-04
   +2.39030000E-04  -2.70290000E-04  -1.06510000E-04  +1.61040000E-04  -3.03190000E-04
   +8.85200000E-05  +1.53000000E-06  +2.61000000E-05  +3.20190000E-04  -1.79120000E-04
   +7.76000000E-05  +4.46180000E-04  -5.29100000E-05  +3.48510000E-04  -2.50220000E-04
   +7.15000000E-06  -4.66000000E-06  +2.34400000E-05  +1.22500000E-05  -8.83530000E-04
   +2.11682000E-03  -3.16420000E-04  -1.52610900E-01  +4.08763000E-03  +1.70108230E-01
   +1.54760000E-04  -6.03050000E-04  -1.15868000E-03  -1.83809000E-03  -5.11893000E-03
   +6.48110000E-04  -1.34550000E-03  -1.93970000E-04  -9.60300000E-05  -2.80036000E-03
   -2.49413000E-03  +4.70891000E-03  +5.54260000E-03  +1.26233400E-02  +2.01844800E-02
   -5.51733200E-02  -2.38218000E-03  +1.10253400E-02  +4.05680000E-03  -1.31520500E-02
   -2.21334000E-02  +2.87370000E-04  +1.81444000E-03  -7.33260000E-04  +3.12680000E-04
   +7.35000000E-06  -8.94400000E-05  -5.56310000E-04  -2.69700000E-04  +5.02840000E-04
   -1.96830000E-04  -6.07600000E-05  -1.56420000E-04  +3.84800000E-05  -2.94000000E-06
   -6.53800000E-05  -4.09300000E-05  -2.14300000E-05  +5.36600000E-05  -4.93400000E-05
   +3.56700000E-05  +1.41600000E-05  -1.55300000E-05  +1.00060000E-04  -8.05200000E-05
   -1.80600000E-05  -1.36260000E-04  +4.00000000E-06  +9.28300000E-05  -6.42200000E-05
   -6.19000000E-06  -3.09130000E-04  -1.68800000E-04  -1.67720000E-04  -7.39100000E-05
   +2.77150000E-04  -1.57300000E-04  +1.30970000E-04  +7.26500000E-04  +1.18901000E-03
   +5.32257700E-02  -2.39200000E-05  -4.98440000E-04  -9.36840000E-04  -5.12818000E-03
   +3.68191000E-03  -2.37311000E-03  -1.15580000E-04  -6.86400000E-04  +7.98970000E-04
   -2.40472000E-03  +4.47474000E-03  -1.47545000E-03  +1.47280000E-04  +5.37057000E-03
   +1.46977000E-03  -2.25656000E-03  -1.16731980E-01  -1.29085570E-01  +1.20108000E-03
   -5.13561000E-03  -1.63452400E-02  +1.28261000E-03  -2.55136000E-03  +9.98020000E-04
   -5.47320000E-04  -2.88110000E-04  -5.17200000E-05  -1.37386000E-03  +1.17050000E-04
   +5.76600000E-05  +3.16640000E-04  +4.63050000E-04  -1.51080000E-04  +9.34600000E-05
   -1.19060000E-04  +5.27500000E-05  -7.42000000E-06  -4.52500000E-05  +1.17000000E-06
   -4.44900000E-05  +5.82200000E-05  +1.50000000E-06  +1.06500000E-05  +2.37900000E-05
   -7.36000000E-06  +1.18130000E-04  +8.74100000E-05  -8.59500000E-05  +5.22700000E-05
   -6.66000000E-05  +9.47000000E-06  -1.13190000E-04  -2.47110000E-04  +8.38000000E-06
   +2.50690000E-04  -4.56230000E-04  +2.16420000E-04  -8.86500000E-05  +1.00900000E-04
   +2.07560000E-04  +7.98304000E-03  +1.16613690E-01  -1.42380000E-04  -3.65290000E-04
   -4.37190000E-04  +5.62920000E-04  -2.44308000E-03  +3.31317000E-03  +2.93000000E-05
   +8.74820000E-04  +3.46120000E-04  +4.78515000E-03  -1.26261000E-03  +7.45900000E-05
   -1.00691000E-03  -1.04953700E-02  -1.24093000E-02  +1.14202400E-02  -1.29033210E-01
   -2.67979500E-01  +1.93586000E-03  -2.93589000E-03  -2.79973000E-03  -1.84290000E-03
   +3.54340000E-04  -1.49935000E-03  +5.01570000E-04  +1.39910000E-04  +1.02490000E-04
   -1.07713000E-03  -1.12707000E-03  +2.39200000E-04  -1.60840000E-04  -7.56800000E-05
   +6.33200000E-05  -3.12000000E-05  +4.66500000E-05  +1.46300000E-05  +5.33000000E-06
   +7.36000000E-06  +1.33000000E-06  +1.10800000E-05  -6.47000000E-06  -1.31200000E-05
   -2.51000000E-05  -7.76000000E-06  +1.30400000E-05  +1.88300000E-05  +6.74000000E-06
   +6.06700000E-05  -1.94800000E-05  +2.24300000E-05  +2.23000000E-06  -7.90000000E-05
   +5.61600000E-05  -1.82700000E-05  -1.94910000E-04  +1.92290000E-04  -2.15880000E-04
   -1.34160000E-04  -5.38260000E-04  -7.53210000E-04  -1.16658500E-02  +1.44299640E-01
   +2.81624600E-01  +7.58100000E-05  +1.62211000E-03  -7.31830000E-04  +2.50308000E-03
   -2.22453000E-03  -1.08445000E-03  +2.02736000E-03  -1.73711000E-03  +5.60190000E-04
   -1.63800000E-05  +1.07390000E-04  -8.65570000E-04  -7.11110000E-04  -5.02892000E-03
   -1.02970000E-03  -1.36548300E-02  +4.39870000E-04  +1.59082800E-02  -2.27534110E-01
   -2.24379000E-02  +1.43935280E-01  -2.04040000E-04  +2.51660000E-04  +8.83740000E-04
   -2.00470000E-04  -6.71800000E-05  -1.22740000E-04  -3.09900000E-05  +7.78300000E-05
   +6.80100000E-05  +1.88600000E-05  -2.17860000E-04  -1.36200000E-05  -8.37000000E-05
   +7.00100000E-05  +4.35000000E-06  +4.01200000E-05  +1.01900000E-05  -9.81000000E-06
   +6.43000000E-05  -1.94900000E-05  -1.76400000E-05  -2.46400000E-05  -9.50700000E-05
   +6.31800000E-05  -5.23300000E-05  +7.62000000E-06  +1.99500000E-05  -7.18900000E-05
   +6.07900000E-05  -3.63000000E-06  -8.82600000E-05  +2.09180000E-04  -1.02850000E-04
   +1.50920000E-04  +3.54200000E-05  -1.55600000E-04  -1.69690000E-04  +2.58480000E-04
   -7.21900000E-05  -1.35350000E-04  +1.67023000E-03  -1.24913000E-03  +2.38102920E-01
   +1.46736000E-03  -1.42055000E-03  +2.31591000E-03  +1.27747200E-02  +6.31537000E-03
   -1.04040300E-02  -2.00130000E-03  +1.80569000E-03  -4.71363000E-03  -3.54500000E-05
   -1.24772000E-03  -2.07490000E-04  -4.71175000E-03  +2.30420000E-03  -3.53341000E-03
   -1.37191700E-02  +2.21021000E-03  +1.26678600E-02  -2.31853900E-02  -4.61931000E-02
   +3.09160000E-03  -5.03830000E-04  +4.31600000E-04  +4.26570000E-04  -5.89400000E-05
   +6.43100000E-05  -4.30200000E-05  +5.81500000E-05  +1.43400000E-05  +9.08300000E-05
   -2.12270000E-04  -2.44350000E-04  -5.64600000E-05  -3.32900000E-05  +1.92900000E-05
   -4.61000000E-06  +1.14900000E-05  +5.13200000E-05  -6.96000000E-06  +8.03000000E-06
   -3.81100000E-05  +1.71900000E-05  +1.96400000E-05  +6.20000000E-07  -1.40000000E-07
   -9.01000000E-06  +1.15600000E-05  -2.77100000E-05  -4.42400000E-05  +3.25700000E-05
   +2.87000000E-06  +1.65940000E-04  -2.22510000E-04  +4.17360000E-04  +7.21350000E-04
   +3.10400000E-05  -5.00830000E-04  +2.26730000E-04  -3.90440000E-04  +3.09380000E-04
   +1.97286000E-03  -2.29735000E-03  +1.79610000E-03  +2.71039100E-02  +3.87829300E-02
   -9.98560000E-04  +2.17231000E-03  +1.00414000E-03  +2.43782800E-02  +3.87445000E-03
   -1.11676400E-02  +8.74500000E-05  -5.03701000E-03  -2.86979000E-03  -1.23706000E-03
   -3.95220000E-04  -6.19250000E-04  -7.81400000E-04  -3.32326000E-03  +2.30690000E-03
   -7.80434000E-03  -6.87080000E-04  +8.62374000E-03  +1.42538730E-01  +2.32829000E-03
   -1.66040240E-01  -2.53090000E-04  -1.03900000E-04  +3.80070000E-04  -4.03600000E-05
   -5.32400000E-05  -4.33000000E-05  +2.48700000E-05  +7.21100000E-05  -4.09000000E-06
   +5.49000000E-05  -2.42700000E-05  +1.54800000E-05  -1.10200000E-05  +1.68000000E-05
   +1.06600000E-05  -8.75000000E-06  -1.43300000E-05  +1.50000000E-05  -4.62000000E-06
   +1.37400000E-05  -7.90000000E-06  -1.45200000E-05  +1.04700000E-05  -2.03000000E-06
   -6.30000000E-07  -2.23000000E-06  +7.57000000E-06  +1.81900000E-05  -1.03300000E-05
   -1.45000000E-06  -1.85860000E-04  +3.69380000E-04  +2.33010000E-04  +1.03416000E-03
   +1.50190000E-04  -7.88270000E-04  -8.52500000E-05  +2.93380000E-04  -1.36640000E-04
   -7.76070000E-04  +2.06321000E-03  -2.38630000E-04  -1.55956320E-01  -1.64421000E-03
   +1.69371620E-01  +3.76000000E-05  -4.60000000E-07  +2.61700000E-05  +2.52900000E-05
   -1.45000000E-05  -1.34900000E-04  -1.68390000E-04  +9.17000000E-06  -3.34500000E-05
   +2.56370000E-04  +1.83730000E-04  +3.16800000E-04  +8.76600000E-04  -1.28954000E-03
   -2.36340000E-04  +2.39480000E-04  +1.38860000E-04  +1.57160000E-04  +8.60000000E-05
   +9.06000000E-05  -3.13000000E-05  -1.19603000E-03  -7.60380000E-04  +7.36680000E-04
   -2.56759000E-01  +1.11737020E-01  +2.23610100E-02  -4.15200000E-05  -2.92530000E-04
   +2.59160000E-04  +6.32950000E-04  -2.98710000E-04  +1.69260000E-04  -3.28630000E-04
   -2.17120000E-04  +3.49630000E-04  +4.02330000E-04  +1.68170000E-04  -2.57740000E-04
   +8.10600000E-05  +7.73000000E-06  -5.35200000E-05  -2.55400000E-05  -1.73020000E-04
   +9.67000000E-05  +1.60700000E-05  -1.32970000E-04  +1.46320000E-04  -1.53700000E-04
   +1.62380000E-04  -2.71000000E-05  -9.93000000E-06  +4.21000000E-06  -4.15000000E-06
   -4.79000000E-06  +1.31500000E-05  +7.70000000E-07  +2.62300000E-05  -6.75900000E-05
   -1.35500000E-05  +2.17500000E-05  +2.50000000E-05  -5.00000000E-07  +2.06100000E-05
   +1.37100000E-05  +8.16000000E-06  +2.75895040E-01  +2.33690000E-04  +2.10120000E-04
   +7.81000000E-05  -2.61390000E-04  -1.59440000E-04  +8.90900000E-05  +1.62640000E-04
   +5.41000000E-05  -5.68600000E-05  -1.52890000E-04  -1.62260000E-04  -5.97380000E-04
   +1.41814000E-03  +7.31810000E-04  -9.12700000E-05  -3.02860000E-04  +1.46880000E-04
   +1.48200000E-05  -1.82820000E-04  -7.68600000E-05  +5.46200000E-05  +2.23293100E-02
   -1.43319100E-02  -2.31714000E-03  +1.09383870E-01  -1.03980210E-01  -1.26232000E-02
   -2.90000000E-06  +4.05280000E-04  -1.38257000E-03  -1.38263000E-03  -3.31612000E-03
   +3.95960000E-03  -6.86210000E-04  -4.29500000E-05  +3.80830000E-04  +2.46400000E-05
   +1.43510000E-04  +3.45000000E-05  -2.70730000E-04  +7.23200000E-05  +9.15200000E-05
   -4.09300000E-05  -1.97570000E-04  +5.54300000E-05  +1.54978000E-03  -2.97140000E-04
   -2.49890000E-04  +2.68100000E-04  -1.77670000E-04  -3.88100000E-05  -9.03000000E-06
   -3.71700000E-05  -2.36300000E-05  +9.88000000E-06  -4.68000000E-06  +1.46500000E-05
   +1.26400000E-05  +7.21000000E-05  +1.49650000E-04  +2.12200000E-05  -3.45100000E-05
   +7.25700000E-05  +6.68000000E-06  -1.00600000E-05  -4.74000000E-06  -1.20860090E-01
   +1.14483880E-01  -1.14820000E-04  -8.14700000E-05  -2.10200000E-05  +1.31370000E-04
   -6.24000000E-06  -1.91760000E-04  -3.93830000E-04  -2.36200000E-05  +5.78200000E-05
   +4.04430000E-04  +5.04900000E-05  -1.85860000E-04  -5.24070000E-04  -4.68640000E-04
   +4.17470000E-04  -1.47130000E-04  -1.47200000E-04  +1.58050000E-04  +1.27430000E-04
   +1.12130000E-04  +2.43000000E-05  -1.84748900E-02  +1.01180900E-02  +3.67290000E-04
   +2.36020400E-02  -1.34610100E-02  -4.95484000E-02  -1.31219000E-03  +5.46000000E-04
   +1.05965000E-03  +9.30510000E-04  +2.85214000E-03  -2.66314000E-03  +7.09690000E-04
   +2.29670000E-04  -7.28800000E-05  -1.94730000E-04  +9.36700000E-05  +1.65320000E-04
   +8.30000000E-07  -1.38620000E-04  +2.68000000E-05  +2.29190000E-04  +2.52940000E-04
   -1.55090000E-04  -1.12347000E-03  +6.29040000E-04  +3.91010000E-04  -6.91400000E-05
   +1.82100000E-05  +1.17400000E-05  +1.03600000E-05  -5.00000000E-07  +1.56600000E-05
   +1.64800000E-05  -1.78800000E-05  +1.58000000E-06  +3.76000000E-05  -3.29000000E-06
   +1.05980000E-04  +3.71900000E-05  +1.50500000E-05  -7.08700000E-05  -5.20000000E-07
   +5.19000000E-06  +9.87000000E-06  -2.53426000E-02  +1.01145200E-02  +5.24441800E-02
   -2.89100000E-04  -2.30520000E-04  -8.39300000E-05  +3.03850000E-04  +1.76980000E-04
   -2.08000000E-05  -2.59540000E-04  -2.06100000E-05  +4.12500000E-05  +2.20410000E-04
   +2.33940000E-04  +5.15250000E-04  +5.61470000E-04  -7.39090000E-04  +2.91650000E-04
   +5.24280000E-04  -1.09560000E-04  -1.61530000E-04  +8.71000000E-06  -1.46400000E-05
   -7.90900000E-05  +3.45230000E-04  +1.40486000E-03  +2.90650000E-04  -1.89318100E-01
   -1.26659810E-01  -4.03191200E-02  +2.90270000E-04  +3.02640000E-04  -2.13090000E-04
   -5.12000000E-06  -7.97800000E-05  +2.49300000E-04  -1.11413000E-03  +9.11460000E-04
   +5.74940000E-04  +1.49330000E-04  +1.87360000E-04  -1.04680000E-04  -1.47850000E-04
   +1.16700000E-05  +1.56100000E-05  +1.14800000E-05  +1.25900000E-05  +9.57000000E-06
   +1.15380000E-04  -9.73000000E-05  -3.08000000E-06  +8.04900000E-05  -3.01500000E-05
   -3.13500000E-05  +1.93500000E-05  +3.65200000E-05  +3.01300000E-05  -2.62700000E-05
   -7.24000000E-06  -2.40100000E-05  +1.64500000E-05  -5.23500000E-05  -2.81600000E-05
   -5.61900000E-05  +4.34400000E-05  +2.31100000E-05  -1.79900000E-05  -7.11000000E-06
   +2.47000000E-06  -1.89685700E-02  -1.90434000E-02  -6.45149000E-03  +2.06112440E-01
   -5.55340000E-04  -4.41250000E-04  -2.37000000E-04  +2.31510000E-04  +3.88840000E-04
   +5.47820000E-04  +8.09600000E-05  +1.57250000E-04  +5.77400000E-05  -3.57470000E-04
   -1.04560000E-04  +2.33240000E-04  +4.69890000E-04  -2.92431000E-03  +3.95792000E-03
   +3.42470000E-04  -4.88340000E-04  -4.61610000E-04  -6.05870000E-04  -1.90100000E-04
   -4.94300000E-04  -1.86282100E-02  -1.58273000E-02  -5.89479000E-03  -1.25295980E-01
   -1.60324300E-01  -3.55820300E-02  -1.99360000E-04  +7.43350000E-04  -1.64433000E-03
   -8.06940000E-04  +5.75480000E-04  -2.11230000E-04  -4.80700000E-05  -4.51720000E-04
   +5.02100000E-04  +5.53090000E-04  +1.75960000E-04  -2.62510000E-04  +7.84300000E-05
   +1.06550000E-04  -1.55950000E-04  -1.80510000E-04  -1.73670000E-04  +1.86770000E-04
   +2.08140000E-04  +9.37000000E-06  +1.23690000E-04  -8.66100000E-05  +1.39840000E-04
   -3.36700000E-05  +2.61300000E-05  +3.94700000E-05  +6.34800000E-05  -2.74900000E-05
   -4.78900000E-05  -4.22700000E-05  +1.24600000E-05  +1.20390000E-04  -5.75400000E-05
   +3.42700000E-05  -9.98000000E-05  +1.53750000E-04  -1.04380000E-04  -3.13000000E-06
   -4.26600000E-05  +1.12645500E-02  +1.09790800E-02  +3.68357000E-03  +1.37903570E-01
   +1.73905780E-01  +2.76400000E-04  +2.56780000E-04  +7.50100000E-05  -3.34270000E-04
   -2.16000000E-05  +2.32830000E-04  +6.11910000E-04  -2.32200000E-05  +1.03920000E-04
   +5.28000000E-06  -3.40570000E-04  -5.91600000E-05  -9.68760000E-04  +2.50473000E-03
   -2.30008000E-03  +6.33100000E-04  +4.40630000E-04  +1.97560000E-04  +1.19500000E-05
   -3.28160000E-04  +9.48000000E-05  +1.59766500E-02  +1.34610300E-02  +2.85239000E-03
   -4.03335100E-02  -3.69197200E-02  -5.99372300E-02  +1.03515000E-03  +7.66540000E-04
   +1.09007000E-03  +6.26000000E-05  -5.56470000E-04  +3.87620000E-04  -4.49700000E-04
   -4.84590000E-04  +4.65290000E-04  +4.89700000E-05  +1.91340000E-04  -1.84260000E-04
   -1.23260000E-04  -3.64400000E-05  +1.08730000E-04  +9.32900000E-05  -4.26100000E-05
   -3.94200000E-05  +6.25700000E-05  +8.02000000E-06  -1.81120000E-04  +4.19800000E-05
   +1.38000000E-05  -3.24600000E-05  +7.86000000E-06  -6.70000000E-06  -3.73400000E-05
   +2.67800000E-05  +1.17800000E-05  +1.70400000E-05  -2.73690000E-04  +4.06400000E-04
   +2.54600000E-05  -2.01200000E-05  +1.30250000E-04  -8.63800000E-05  +3.80200000E-05
   +3.52500000E-05  -6.47000000E-06  +2.77812000E-03  +2.69197000E-03  -1.65340000E-04
   +4.37455400E-02  +3.71879900E-02  +6.23315200E-02  +5.80600000E-05  +5.01000000E-05
   +1.54300000E-05  +2.42300000E-05  -1.18940000E-04  -1.74230000E-04  -3.09860000E-04
   -5.91700000E-05  -9.13000000E-05  -6.40400000E-05  -8.10100000E-05  -7.34000000E-06
   +4.70500000E-05  +5.01990000E-04  +5.90750000E-04  -2.62180000E-04  -1.26460000E-04
   +7.13900000E-05  +1.71190000E-04  +1.09360000E-04  +1.09080000E-04  -1.73006000E-03
   -3.63020000E-04  -1.29249000E-03  -4.94858600E-02  +7.26781000E-03  +2.38726400E-02
   -2.16700000E-05  +2.56890000E-04  -2.56460000E-04  +3.42060000E-04  -2.62310000E-04
   -6.13090000E-04  -6.62400000E-05  +4.92130000E-04  -4.32620000E-04  -2.34530000E-04
   -5.83300000E-05  +2.10910000E-04  -7.68600000E-05  -3.26400000E-05  +4.45400000E-05
   +9.02400000E-05  +8.70100000E-05  -1.04730000E-04  -2.76300000E-05  -2.57500000E-05
   -1.78200000E-05  +9.74700000E-05  -1.12960000E-04  +2.19000000E-05  -1.24500000E-05
   -2.47900000E-05  +1.55000000E-06  +1.56700000E-05  -1.76500000E-05  +1.54800000E-05
   +2.54340000E-04  -2.80190000E-04  +3.08900000E-05  +3.49800000E-05  +2.69000000E-05
   -6.22600000E-05  +5.00000000E-07  +8.07000000E-06  -5.11000000E-06  -1.80454000E-03
   +8.27396000E-03  +2.75488600E-02  +2.67225000E-03  -6.48564000E-03  -2.29855900E-02
   +5.03346300E-02  +1.52720000E-04  +9.03700000E-05  +5.11600000E-05  +7.70600000E-05
   -9.53500000E-05  -3.14840000E-04  -1.39560000E-04  -1.85810000E-04  -2.23490000E-04
   -4.53100000E-04  -2.05600000E-04  +6.09310000E-04  +7.73800000E-04  +1.20885000E-03
   +1.22860000E-04  -4.15700000E-04  -3.61200000E-05  -1.48800000E-05  +2.28060000E-04
   +1.96690000E-04  +2.18980000E-04  -2.84910000E-03  +7.89370000E-03  +2.39979200E-02
   +7.16728000E-03  -7.41671000E-02  -8.10692600E-02  +1.26100000E-05  -3.94886000E-03
   +2.82584000E-03  -3.27670000E-04  +1.26803000E-03  -3.38530000E-04  +5.81150000E-04
   +2.10770000E-04  -2.25800000E-05  +6.93300000E-05  -1.86930000E-04  +3.41900000E-05
   +1.66060000E-04  +1.00270000E-04  -1.36340000E-04  -2.07930000E-04  +3.20500000E-05
   +6.88700000E-05  -1.99400000E-04  -1.84840000E-04  -6.14400000E-05  -8.27200000E-05
   +2.99800000E-05  +1.82100000E-05  -2.23800000E-05  -1.23300000E-05  -1.83600000E-05
   -1.00300000E-05  -5.86000000E-06  +2.27600000E-05  -3.84700000E-05  -1.16900000E-03
   -1.08800000E-04  +6.65800000E-05  -1.05600000E-05  -1.51100000E-05  +1.39800000E-05
   -1.09500000E-05  +8.02000000E-06  +3.86500000E-05  -5.04618000E-03  -1.36874100E-02
   +3.72796000E-03  -6.34782000E-03  -1.89840500E-02  -8.68717000E-03  +8.00397800E-02
   -1.19900000E-05  +1.62000000E-05  -9.44000000E-06  -2.63490000E-04  +1.80630000E-04
   +4.28020000E-04  +5.00200000E-04  +2.24630000E-04  +2.65920000E-04  +8.21000000E-05
   -7.19960000E-04  -1.42700000E-04  -1.25387000E-03  -7.01960000E-04  +4.63800000E-04
   +7.29050000E-04  +1.58490000E-04  -1.74450000E-04  -3.62290000E-04  -3.18390000E-04
   -1.74800000E-04  +1.73307000E-03  -7.39221000E-03  -1.85786000E-02  +2.38717200E-02
   -7.87154700E-02  -2.87556020E-01  +4.45900000E-05  +4.79700000E-03  -2.05728000E-03
   +1.01169000E-03  -8.91640000E-04  +5.11960000E-04  +3.89160000E-04  +1.90030000E-04
   +1.85330000E-04  -3.91540000E-04  +1.57230000E-04  +2.51050000E-04  -1.10910000E-04
   -2.28150000E-04  +1.25540000E-04  +2.71330000E-04  +6.36200000E-05  -1.31730000E-04
   -1.06000000E-04  +3.83380000E-04  +1.20440000E-04  -4.85000000E-06  -3.39300000E-05
   +7.50000000E-06  +1.88000000E-05  +9.09000000E-06  -2.14000000E-06  +4.06200000E-05
   -5.60000000E-07  +7.78000000E-06  -2.54390000E-04  +1.83530000E-04  +3.03240000E-04
   -1.37990000E-04  -1.43300000E-05  +7.28600000E-05  -1.72000000E-06  +2.03100000E-05
   -1.56500000E-05  -2.81410000E-04  -4.32360000E-04  -1.56856000E-03  +1.00514000E-03
   -1.11381000E-03  -4.65200000E-03  -2.59797700E-02  +8.51503200E-02  +3.13074000E-01
   +9.56800000E-05  +1.00940000E-04  +7.10700000E-05  -6.88300000E-05  -3.73600000E-05
   -2.13000000E-06  +8.82100000E-05  +7.43300000E-05  +5.05200000E-05  -7.67600000E-05
   -2.11100000E-05  -4.02600000E-05  +2.28860000E-04  +4.64720000E-04  -3.24300000E-04
   +6.39000000E-06  -2.26420000E-04  -7.18920000E-04  -9.49200000E-05  -4.73000000E-06
   +2.32440000E-04  -1.90608000E-03  -3.12940000E-04  +2.60490000E-04  -2.60000000E-06
   -2.27600000E-05  -7.58400000E-05  -4.75123900E-02  -7.02454000E-03  +7.11620000E-03
   +1.41660000E-04  -9.11610000E-04  +4.19140000E-04  -2.13790000E-04  +8.70700000E-05
   +7.59300000E-05  +1.08290000E-04  -1.42440000E-04  +8.69300000E-05  +4.96400000E-05
   +1.57000000E-04  -9.34000000E-05  -3.61460000E-04  +1.40450000E-04  -1.76100000E-05
   -6.18400000E-05  +1.34280000E-04  -8.53700000E-05  +5.76100000E-05  -3.75600000E-05
   -1.03300000E-05  -7.80000000E-06  -9.12000000E-06  -7.54000000E-06  +1.20000000E-05
   +5.90000000E-06  +1.85600000E-05  -2.02700000E-05  +2.77900000E-05  +5.60100000E-05
   -1.07100000E-03  +3.06000000E-04  -4.08170000E-04  -9.17000000E-06  +8.13000000E-06
   -2.20800000E-05  +2.91670000E-04  -3.03470000E-04  +2.44140000E-04  +1.46590000E-04
   +3.60500000E-04  -1.12710000E-04  +6.62940000E-04  +4.68200000E-05  +2.40700000E-05
   +4.78316600E-02  +7.68400000E-05  +3.49700000E-05  -1.72700000E-05  -9.71400000E-05
   -7.74100000E-05  +9.62500000E-05  +6.81700000E-05  +2.37100000E-05  -2.64900000E-05
   +2.50170000E-04  +6.71500000E-05  +4.34700000E-05  -2.49550000E-04  +5.19030000E-04
   +3.29010000E-04  -7.57910000E-04  +2.80700000E-04  +1.18970000E-04  +7.61300000E-05
   -5.16000000E-05  -2.12530000E-04  +9.33300000E-04  +8.83782000E-03  -8.92129000E-03
   +2.03800000E-05  -2.51570000E-04  -1.81011000E-03  -6.96423000E-03  -1.91324250E-01
   +1.34411910E-01  -1.07900000E-04  +7.13400000E-04  -4.59700000E-05  -4.30300000E-05
   -1.31100000E-05  +1.09480000E-04  +5.06900000E-05  +5.87200000E-05  -1.03210000E-04
   +4.38800000E-05  -4.65000000E-06  +4.07400000E-05  -1.23200000E-04  -1.00590000E-04
   +6.63500000E-05  +3.30250000E-04  -1.60930000E-04  -6.49740000E-04  -1.30400000E-04
   +8.57100000E-05  -1.29200000E-05  -7.59000000E-06  -1.30400000E-05  -6.43000000E-06
   +1.92100000E-05  +1.18600000E-05  +6.18000000E-06  +9.93000000E-06  +4.05000000E-06
   -3.64400000E-05  -5.55500000E-05  -1.42880000E-04  -3.07010000E-04  -5.04000000E-06
   +4.27900000E-05  -8.74000000E-06  -1.99340000E-04  +4.31100000E-05  -2.11280000E-04
   +2.50350000E-04  +1.39230000E-04  -2.21340000E-04  -2.70900000E-05  +6.81590000E-04
   -3.86620000E-04  +8.14406000E-03  +2.06318170E-01  +2.94100000E-05  +2.17600000E-05
   +1.83800000E-05  -1.66580000E-04  +1.04440000E-04  +2.43170000E-04  +2.70910000E-04
   +2.00350000E-04  +4.37400000E-05  +1.69700000E-05  -5.07470000E-04  -1.90120000E-04
   +8.89520000E-04  +9.40540000E-04  +1.38748000E-03  +1.63160000E-04  -1.91350000E-04
   +3.23900000E-05  -2.97850000E-04  -2.56150000E-04  +9.28100000E-05  +1.28881000E-03
   +2.26254000E-02  -1.94233600E-02  +5.12480000E-04  -3.87964000E-03  -5.71110000E-03
   +7.45430000E-03  +1.32255660E-01  -1.70945600E-01  -1.54597000E-03  +9.38260000E-04
   +6.58590000E-04  +7.60130000E-04  -3.85100000E-05  -1.22260000E-04  -3.98620000E-04
   +4.11200000E-04  -9.39000000E-05  -2.89440000E-04  -3.89750000E-04  +3.15650000E-04
   +7.33240000E-04  -4.69190000E-04  +1.67880000E-04  +6.57100000E-05  +5.97690000E-04
   +1.66550000E-04  -6.22700000E-05  -4.13000000E-06  -6.23000000E-06  -1.00800000E-05
   +5.74000000E-06  -1.04200000E-05  -1.77700000E-05  +3.58300000E-05  -2.28600000E-05
   -3.79000000E-05  +9.91400000E-05  +5.50000000E-05  -6.21790000E-04  +1.86320000E-04
   +2.43700000E-05  -2.26100000E-05  -1.32500000E-05  -1.96000000E-05  -8.06000000E-05
   -1.33600000E-04  +2.08190000E-04  +9.90300000E-05  -1.64020000E-04  +2.88660000E-04
   -9.55000000E-05  +1.57302000E-03  -1.43188000E-03  -7.85671000E-03  -1.44796070E-01
   +1.87608280E-01  -1.43750000E-04  -1.40320000E-04  -9.70700000E-05  +8.59900000E-05
   +7.58800000E-05  +1.12900000E-05  -8.09100000E-05  -3.43100000E-05  -8.72400000E-05
   +1.82680000E-04  +1.19320000E-04  +2.83030000E-04  +5.32520000E-04  +2.15840000E-04
   +5.89380000E-04  -3.08940000E-04  -2.22000000E-06  +5.00860000E-04  +2.07730000E-04
   -8.41000000E-05  -2.73380000E-04  +1.02510000E-04  +1.24933000E-03  +1.22669000E-03
   -8.34600000E-05  +1.27940000E-04  +2.72460000E-04  -2.35164600E-01  -1.20774050E-01
   -3.53957300E-02  +8.57210000E-04  +1.20952000E-03  +4.07100000E-04  +2.25820000E-04
   -1.22440000E-04  +6.52600000E-05  +3.88500000E-05  -9.71000000E-05  -1.90500000E-05
   +3.37600000E-05  +8.62600000E-05  -1.00610000E-04  -2.24210000E-04  +3.83800000E-05
   -3.94600000E-05  +2.84480000E-04  -2.76580000E-04  +1.09460000E-04  +5.00400000E-05
   -2.37200000E-05  +2.01100000E-05  +1.20800000E-05  +1.60400000E-05  +1.36500000E-05
   -2.05700000E-05  +6.75000000E-06  -2.22500000E-05  +7.99100000E-05  -4.13100000E-05
   -5.98200000E-05  +2.87490000E-04  +2.21100000E-05  -5.40300000E-04  -3.12000000E-06
   -6.87000000E-06  +1.74100000E-05  +1.58900000E-05  -1.31770000E-04  +3.25000000E-05
   +2.89210000E-04  +3.42530000E-04  -3.74830000E-04  +2.49820000E-04  +2.39110000E-04
   +3.38300000E-05  -2.65680000E-04  +8.54580000E-04  +6.60800000E-05  +2.52120920E-01
   -2.16770000E-04  -1.59250000E-04  -4.86000000E-05  +2.60220000E-04  +8.68100000E-05
   -5.01900000E-05  -6.41500000E-05  -2.42400000E-04  -1.42080000E-04  -8.32120000E-04
   -4.72000000E-06  +8.31600000E-05  +8.99730000E-04  -9.50800000E-05  -2.55982000E-03
   +2.56320000E-04  +2.44900000E-04  -3.14990000E-04  -4.24800000E-05  +1.37190000E-04
   +2.25600000E-05  -1.01054100E-02  -8.59017000E-03  -2.15831000E-03  +6.10070000E-04
   +2.92170000E-04  +9.81110000E-04  -1.19346400E-01  -1.23521810E-01  -2.12587400E-02
   -9.89070000E-04  +3.51190000E-04  +6.15800000E-05  +2.96850000E-04  +1.52280000E-04
   +3.97200000E-05  +2.36790000E-04  -3.26900000E-05  -9.26300000E-05  +1.71600000E-04
   -5.14600000E-05  -8.40200000E-05  -5.07400000E-05  -1.30300000E-04  +7.18800000E-05
   +3.74500000E-05  -3.55650000E-04  +4.79860000E-04  -1.46030000E-04  +1.39820000E-04
   +9.88000000E-06  +2.64000000E-05  +2.38600000E-05  +2.37200000E-05  -4.64800000E-05
   -9.90700000E-05  -6.33000000E-06  +1.41200000E-05  +4.18700000E-05  -6.58600000E-05
   +1.83620000E-04  -2.36420000E-04  +2.10630000E-04  -3.66700000E-05  +4.14000000E-06
   -1.06700000E-05  +9.59900000E-05  +4.68800000E-05  +3.00100000E-05  +7.10000000E-06
   +4.61420000E-04  +1.95090000E-04  +1.81280000E-04  -3.36100000E-05  +2.11000000E-06
   -1.94179200E-02  -1.20242100E-02  -4.49277000E-03  +1.31159510E-01  +1.31760880E-01
   -1.96740000E-04  -1.15870000E-04  -1.14400000E-05  +1.72490000E-04  +1.67390000E-04
   +3.53900000E-05  +1.33510000E-04  -2.22800000E-04  -3.56120000E-04  -1.70089000E-03
   -1.02953000E-03  +5.50600000E-05  +1.83479000E-03  -1.27836000E-03  -5.47582000E-03
   +1.05201000E-03  -3.27800000E-05  -5.37810000E-04  -2.27360000E-04  -6.04100000E-05
   +2.01560000E-04  -2.54229500E-02  -1.68579400E-02  -6.68398000E-03  -1.10459000E-03
   -1.14901000E-03  +1.23401000E-03  -3.32735000E-02  -2.01952100E-02  -5.21811700E-02
   -1.17032000E-03  +2.63770000E-04  +6.45910000E-04  -8.68500000E-05  +1.42120000E-04
   +2.49020000E-04  +3.72990000E-04  -1.63450000E-04  -6.17100000E-05  +2.57620000E-04
   +1.16320000E-04  -2.47010000E-04  -4.56310000E-04  -1.95220000E-04  +2.12150000E-04
   +4.03360000E-04  -7.26900000E-05  +2.09800000E-05  -2.19890000E-04  +1.64920000E-04
   +9.87000000E-06  +2.65500000E-05  +2.71100000E-05  +1.85300000E-05  -1.36590000E-04
   -9.17300000E-05  -5.93900000E-05  +8.67000000E-06  +3.93100000E-05  -7.69000000E-06
   -1.13490000E-04  +3.54460000E-04  +3.79760000E-04  -3.12400000E-05  -3.75300000E-05
   -1.97000000E-06  +9.24000000E-05  +3.82000000E-05  -5.59300000E-05  +3.55730000E-04
   +6.94380000E-04  -5.73630000E-04  +3.44520000E-04  +9.53200000E-05  +3.16590000E-04
   +1.92416800E-02  +1.08916700E-02  +3.78364000E-03  +3.69166800E-02  +2.58747300E-02
   +5.95409700E-02  +7.31200000E-05  +3.01300000E-05  -1.70100000E-05  -1.54650000E-04
   -1.47300000E-05  -1.43700000E-05  +2.15200000E-05  -1.42000000E-06  +1.70000000E-06
   +1.24390000E-04  +1.24590000E-04  +6.71900000E-05  -8.31600000E-05  -1.77200000E-04
   +1.43180000E-04  -8.64840000E-04  -1.06089000E-03  +2.94980000E-04  +1.77370000E-04
   -8.74000000E-05  -2.56830000E-04  -7.39820000E-04  -3.16870000E-04  -3.53180000E-04
   +3.06290000E-04  -1.53910000E-04  -4.57140000E-04  -2.13156470E-01  +1.26525980E-01
   +2.43941300E-02  +5.12240000E-04  +5.92620000E-04  +8.67240000E-04  +4.14410000E-04
   +2.45940000E-04  +2.39900000E-05  +1.72780000E-04  +5.28100000E-05  -1.70930000E-04
   +2.99720000E-04  -1.07330000E-04  -8.28400000E-05  -2.60570000E-04  -2.01840000E-04
   +1.33910000E-04  +2.27230000E-04  -4.24710000E-04  +3.47620000E-04  -3.30300000E-04
   +2.53690000E-04  +1.18100000E-05  -1.68600000E-05  -5.90000000E-06  -1.01200000E-05
   +1.06700000E-05  +2.13900000E-05  +2.06000000E-06  -1.04600000E-05  -1.10000000E-07
   -1.84800000E-05  -5.86620000E-04  -1.50739000E-03  -6.56890000E-04  +2.98700000E-05
   -1.16400000E-05  +2.59000000E-05  +3.12620000E-04  -2.05830000E-04  +3.31360000E-04
   -2.16100000E-04  +8.42100000E-05  +8.99200000E-05  +1.95460000E-04  -2.50800000E-04
   -2.39100000E-05  +1.63573000E-03  -2.51483000E-03  -5.49090000E-04  -1.94510300E-02
   +1.69918100E-02  +2.89205000E-03  +2.31497030E-01  +8.15800000E-05  +1.17000000E-04
   +1.04650000E-04  -2.37800000E-05  -4.37000000E-05  +2.54700000E-05  +1.18100000E-04
   +1.22940000E-04  +9.47800000E-05  -2.61470000E-04  -8.04300000E-05  -1.35680000E-04
   +5.51640000E-04  +3.36360000E-04  +2.73880000E-04  +2.23490000E-04  -3.87270000E-04
   -1.05778000E-03  -3.19040000E-04  +1.37390000E-04  +4.20930000E-04  +9.49953000E-03
   -7.71482000E-03  -2.33830000E-04  -3.40540000E-04  +4.06780000E-04  +1.22947000E-03
   +1.25470190E-01  -1.43885210E-01  -1.85663000E-02  +8.01400000E-05  -1.50960000E-04
   -2.57965000E-03  -3.94570000E-04  -2.18470000E-04  +9.75700000E-05  +3.77550000E-04
   -4.72460000E-04  +3.12140000E-04  +2.02100000E-05  +4.94780000E-04  -3.44390000E-04
   -5.57490000E-04  +3.40030000E-04  -8.27000000E-05  +4.53930000E-04  -1.86600000E-04
   -3.45180000E-04  +3.23800000E-04  -2.39960000E-04  +5.35900000E-05  -2.49000000E-06
   -1.14400000E-05  -4.53000000E-06  +5.66000000E-06  -4.28000000E-06  +1.94300000E-05
   +4.73000000E-06  +3.23400000E-05  +1.26530000E-04  -1.19276000E-03  -1.20144000E-03
   +4.02480000E-04  -1.32800000E-05  -2.71300000E-05  -2.35600000E-05  -1.32400000E-04
   +5.73280000E-04  -3.57000000E-05  -1.37050000E-04  -1.86000000E-05  -1.23050000E-04
   -2.43950000E-04  -3.73600000E-05  -1.57000000E-06  +1.81435200E-02  -1.31396700E-02
   -3.88794000E-03  -1.40252800E-02  +1.16288100E-02  +2.48791000E-03  -1.37936670E-01
   +1.53482200E-01  +8.36200000E-05  +6.57100000E-05  +1.00500000E-05  -1.62050000E-04
   -2.56100000E-05  +1.67700000E-04  +1.72160000E-04  +1.18200000E-04  +2.48000000E-05
   -7.80600000E-05  +6.68400000E-05  -2.70380000E-04  +2.73150000E-04  +5.64110000E-04
   +8.46320000E-04  -3.60540000E-04  +5.72800000E-05  +2.54690000E-04  -1.66210000E-04
   -8.66400000E-05  -8.11200000E-05  +2.47218600E-02  -1.75575000E-02  -4.35418000E-03
   +1.04157000E-03  -9.89990000E-04  +1.38838000E-03  +2.37971700E-02  -1.73432200E-02
   -5.13668400E-02  -8.97400000E-04  -1.34911000E-03  -5.08289000E-03  +6.01970000E-04
   -4.54220000E-04  +2.17000000E-05  +6.32800000E-05  -4.29200000E-05  +5.03750000E-04
   -3.85380000E-04  +1.64510000E-04  -5.78000000E-06  +5.20720000E-04  +1.13870000E-04
   -2.55000000E-06  +1.21660000E-04  +2.24900000E-04  +1.49470000E-04  +5.47880000E-04
   -4.30800000E-04  +2.60500000E-05  -7.89000000E-06  -1.86200000E-05  -8.87000000E-06
   +2.33200000E-05  -1.37000000E-05  +1.42600000E-05  +4.03200000E-05  -9.23000000E-06
   +6.45000000E-05  -2.73960000E-04  -3.21330000E-04  +2.64340000E-04  +6.14000000E-06
   -1.31200000E-05  +4.22000000E-06  -5.14490000E-04  +4.04440000E-04  -6.85700000E-04
   +2.35200000E-05  +1.43920000E-04  -4.87700000E-05  -2.81730000E-04  +3.21200000E-05
   +3.97140000E-04  -1.82583100E-02  +1.20592800E-02  +3.02633000E-03  -3.56703000E-03
   +3.40131000E-03  -3.13890000E-04  -2.69876600E-02  +2.16576000E-02  +5.55093900E-02
   +1.10190000E-04  +8.72700000E-05  +2.96900000E-05  -7.25500000E-05  -7.48500000E-05
   -2.83500000E-05  +2.11400000E-05  +2.26000000E-05  -6.10500000E-05  -4.67700000E-05
   +7.79600000E-05  +9.98000000E-05  -1.43020000E-04  +7.21100000E-05  -2.26640000E-04
   +4.60000000E-07  +5.03500000E-05  -1.17100000E-05  +4.29200000E-05  +2.66200000E-05
   +3.44900000E-05  +4.89010000E-04  -8.90080000E-04  -1.49290000E-03  -1.68496000E-03
   +4.25200000E-04  +6.83990000E-04  +2.87210000E-04  +6.92900000E-05  -4.15900000E-05
   +6.23622000E-03  -2.09516100E-02  +1.15234200E-02  -5.33031200E-02  +7.40801000E-03
   +4.11922000E-03  +1.43048000E-03  +2.23122700E-02  -1.34838500E-02  -2.91000000E-03
   +3.26803000E-03  +1.86249000E-03  -1.68655000E-03  -3.47100000E-05  +2.26810000E-04
   -2.88742000E-03  -6.19480000E-04  +4.37777000E-03  +1.15710000E-04  +1.24115000E-03
   -5.97220000E-04  -1.16700000E-05  -2.01700000E-05  -7.13000000E-06  +8.89000000E-06
   +1.67000000E-06  +1.47700000E-05  +5.18200000E-05  -8.06500000E-05  -5.47000000E-06
   -9.86000000E-06  -1.64300000E-05  +7.50000000E-07  +1.46800000E-05  -2.78000000E-06
   +1.49000000E-06  +2.80840000E-04  -6.47000000E-05  -1.13060000E-04  -1.46148000E-03
   +1.53018000E-03  +4.16160000E-04  -1.22730000E-03  +2.94510000E-04  -5.29110000E-04
   +3.65900000E-05  +2.32600000E-05  -1.54550000E-04  +2.70100000E-05  -3.56700000E-05
   +2.54400000E-05  -4.50300000E-05  -2.86600000E-05  -3.92300000E-05  +5.54681600E-02
   -2.43700000E-05  -2.90800000E-05  -2.43300000E-05  +1.61600000E-05  +3.13300000E-05
   +3.34800000E-05  +1.68700000E-05  -4.90000000E-07  -5.58400000E-05  -1.13460000E-04
   +2.93700000E-05  +1.31580000E-04  -2.28240000E-04  +2.59600000E-04  +2.53400000E-04
   -5.77900000E-05  -6.08200000E-05  -9.88700000E-05  -1.08200000E-05  -2.14100000E-05
   -6.29000000E-06  -1.28980000E-04  -1.93926000E-03  -1.46295000E-03  +2.25808000E-03
   -2.90700000E-04  -2.85170000E-04  +3.68250000E-04  -1.66480000E-04  -5.69900000E-05
   +8.01380000E-04  -4.37730000E-03  +4.88883000E-03  +5.14288000E-03  -2.65638020E-01
   +1.35121370E-01  +1.10345000E-03  -1.24939400E-02  +7.03247000E-03  +2.76741000E-03
   +1.32552000E-03  +1.39401000E-03  +9.78700000E-05  -5.35000000E-06  -8.16510000E-04
   -6.60770000E-04  +2.21901000E-03  +2.77986000E-03  +1.99620000E-04  -6.64160000E-04
   +5.74040000E-04  -4.19000000E-06  -1.00000000E-06  +6.91000000E-06  -7.19000000E-06
   -1.34600000E-05  +1.38000000E-06  -1.40000000E-05  -7.58500000E-05  -3.92000000E-06
   +1.04700000E-05  -1.24000000E-06  -5.53000000E-06  -6.41000000E-06  -1.05600000E-05
   -2.14000000E-06  +2.65330000E-04  +1.04560000E-04  -4.70730000E-04  +2.02900000E-03
   -8.12440000E-04  -2.67190000E-04  -8.52100000E-05  -1.48520000E-04  -3.13880000E-04
   -2.60000000E-07  -2.36000000E-06  -3.01900000E-05  -2.94400000E-05  -8.48000000E-06
   +2.07200000E-05  -4.51600000E-05  +1.55000000E-06  -1.07460000E-04  -1.30298700E-02
   +2.83308860E-01  -5.17700000E-05  -5.41000000E-05  -3.00800000E-05  +3.15100000E-05
   +4.50700000E-05  +1.93600000E-05  -1.58900000E-05  -2.09300000E-05  -2.81300000E-05
   -6.74400000E-05  -4.60000000E-06  +1.52290000E-04  -3.48720000E-04  +2.25710000E-04
   +2.44440000E-04  -7.24500000E-05  -9.07800000E-05  -9.80700000E-05  -6.59000000E-06
   -3.45700000E-05  -4.78000000E-06  -2.15084000E-03  -1.02248000E-03  -2.82365000E-03
   -3.39150000E-04  +7.62310000E-04  +7.06540000E-04  +8.23070000E-04  -2.11470000E-04
   -1.59400000E-05  -1.51277000E-03  +1.44260900E-02  -3.47676000E-03  +5.73688000E-03
   +1.34417420E-01  -1.15244690E-01  -1.09113000E-03  -2.08771000E-03  +2.09368000E-03
   +2.07406000E-03  +1.04617000E-03  +4.15695000E-03  +1.81680000E-04  -7.20940000E-04
   -9.43830000E-04  +4.38306000E-03  +2.62839000E-03  +2.92958000E-03  +4.19500000E-05
   +1.22020000E-04  +3.59910000E-04  -5.18000000E-06  +5.94000000E-06  +6.97000000E-06
   -1.02500000E-05  -1.20300000E-05  -4.32000000E-06  +8.47000000E-06  -1.10200000E-05
   -1.67100000E-05  +8.89000000E-06  +1.33500000E-05  -1.55300000E-05  -1.04200000E-05
   -8.42000000E-06  -2.81000000E-06  -4.03860000E-04  -3.52290000E-04  -7.67500000E-05
   +2.73050000E-04  -9.03940000E-04  -7.57000000E-06  -5.54500000E-04  +1.09100000E-04
   -7.11500000E-05  -6.98500000E-05  -3.75900000E-05  +4.35800000E-05  +5.07000000E-06
   -5.71600000E-05  -1.13350000E-04  -1.01800000E-05  -9.16900000E-05  -2.26500000E-04
   -6.10435000E-03  -1.47801530E-01  +1.13712940E-01  +2.14090000E-04  +1.65460000E-04
   +5.17500000E-05  -3.34210000E-04  -1.26000000E-04  +1.47390000E-04  +3.57880000E-04
   +1.41990000E-04  -2.11200000E-05  -3.77390000E-04  +1.57800000E-04  -3.69480000E-04
   -7.13070000E-04  +9.74590000E-04  -5.35400000E-04  -4.66800000E-05  +1.22890000E-04
   -2.15700000E-05  -1.66970000E-04  -1.87310000E-04  -3.94100000E-05  -8.17870000E-04
   +1.44790000E-04  -8.39130000E-04  +4.89000000E-06  -1.07750000E-04  -1.06150000E-04
   -8.46600000E-05  +1.07550000E-04  +1.32640000E-04  +4.54739000E-03  -2.72100000E-04
   -8.02680000E-04  +1.97948000E-03  +1.30864000E-03  +5.70710000E-04  -3.71600000E-05
   +8.59420000E-04  -9.66820000E-04  -1.46336000E-03  +4.14965000E-03  +7.53230000E-04
   -1.64707600E-02  -1.21309200E-02  +1.58577700E-02  -2.26659790E-01  -6.76488900E-02
   +1.19088730E-01  -1.46274000E-03  -1.23140000E-04  +5.12330000E-04  -1.84000000E-05
   -3.27800000E-05  -1.77900000E-05  +1.14500000E-05  +6.72000000E-06  +1.92500000E-05
   +1.87300000E-05  -4.56100000E-05  +6.01900000E-05  +4.54000000E-05  +2.73300000E-05
   +1.13300000E-05  +1.10000000E-05  -1.85000000E-06  -7.78000000E-06  +7.91600000E-05
   -8.66000000E-06  +7.00000000E-07  -1.72100000E-05  -4.34400000E-05  +3.19100000E-05
   -9.33000000E-06  +7.09000000E-06  -3.06800000E-05  +2.12320000E-04  +1.61340000E-04
   -1.34640000E-04  +1.10700000E-05  -4.30300000E-05  +1.52600000E-05  +5.86000000E-06
   +8.61700000E-05  -1.98390000E-04  +2.18880000E-04  +2.05820000E-04  -1.36300000E-05
   +2.39875530E-01  -2.17340000E-04  -1.70930000E-04  -6.95400000E-05  +2.77770000E-04
   +3.72500000E-05  -1.58910000E-04  -2.95530000E-04  -2.55770000E-04  +3.58900000E-05
   +1.89480000E-04  +2.96220000E-04  +4.36110000E-04  +4.97080000E-04  -1.78010000E-04
   +4.36600000E-05  +9.63700000E-05  +1.60700000E-05  -1.50900000E-05  +1.38850000E-04
   +1.01290000E-04  +5.85000000E-06  -1.46356000E-03  -1.68590000E-04  -9.83310000E-04
   -3.34000000E-05  +3.33700000E-05  -1.06450000E-04  +1.66160000E-04  -6.45330000E-04
   +3.39430000E-04  -2.32242700E-02  -3.37011000E-03  +1.32264900E-02  +1.53287000E-03
   -3.49952000E-03  +4.59474000E-03  +9.92140000E-04  -1.04126000E-03  -4.67290000E-04
   +3.65811000E-03  -6.56730000E-04  +2.21750000E-03  +1.48972700E-02  +7.27038000E-03
   -7.81918000E-03  -6.77695500E-02  -8.49079600E-02  +5.72339900E-02  +8.52350000E-04
   +2.45210000E-04  -7.09290000E-04  +2.29000000E-06  +3.01300000E-05  +1.44700000E-05
   -2.64400000E-05  -1.19400000E-05  -2.51900000E-05  +9.50000000E-06  +3.02500000E-05
   -8.91600000E-05  +7.96500000E-05  -7.16600000E-05  -2.47300000E-05  -1.61100000E-05
   +6.52000000E-06  +3.79000000E-06  +7.12400000E-05  +9.99000000E-06  -1.87800000E-05
   -9.60000000E-07  +9.53100000E-05  +2.35600000E-05  -5.36900000E-05  +3.72900000E-05
   -1.03110000E-04  +2.42980000E-04  -5.66490000E-04  -7.29480000E-04  +4.40500000E-05
   +1.54990000E-04  +2.78000000E-05  +5.08200000E-05  +2.28780000E-04  -3.08860000E-04
   -1.12270000E-03  -2.16180000E-04  +8.20780000E-04  +7.18591700E-02  +8.55619600E-02
   +2.65540000E-04  +1.78440000E-04  +8.96600000E-05  -2.36790000E-04  -1.48300000E-04
   -1.70560000E-04  -6.43300000E-05  -2.19760000E-04  -6.69000000E-05  +1.42460000E-04
   -2.48940000E-04  -1.72800000E-04  -1.33540000E-04  +3.57460000E-04  +2.28120000E-04
   -4.80060000E-04  -3.20460000E-04  +2.22420000E-04  +2.44500000E-05  +1.44320000E-04
   +1.49830000E-04  +1.86400000E-05  -1.50466000E-03  -2.04420000E-03  -2.88620000E-04
   -3.74300000E-05  -7.74400000E-05  +1.69900000E-05  -2.27630000E-04  +1.22720000E-04
   +1.23340100E-02  +3.91066000E-03  -4.71177000E-03  +7.61200000E-04  +4.85410000E-03
   +2.48488000E-03  -1.16368000E-03  -3.72800000E-04  -4.55030000E-04  +1.12136000E-03
   +1.91589000E-03  +4.53120000E-03  +9.39320000E-04  +3.44139000E-03  +2.11383000E-03
   +1.17981430E-01  +5.63828200E-02  -1.14634450E-01  +8.66500000E-05  -3.04230000E-04
   -1.76770000E-04  -3.63700000E-05  -2.08900000E-05  -3.73600000E-05  -8.03000000E-06
   +2.78300000E-05  -5.42000000E-06  +5.81300000E-05  +1.09010000E-04  -1.11800000E-05
   +6.25100000E-05  -4.05000000E-05  -4.88900000E-05  +9.87000000E-06  +7.70000000E-07
   -7.71000000E-06  -3.52400000E-05  +9.34700000E-05  -3.53000000E-06  -1.24000000E-05
   -1.15540000E-04  +1.51000000E-05  +3.82500000E-05  +3.39300000E-05  -1.47000000E-06
   +2.09430000E-04  -3.69390000E-04  -1.84260000E-04  +3.06000000E-05  -1.04490000E-04
   +2.63400000E-05  -8.47000000E-06  +2.21230000E-04  -1.48050000E-04  +7.40760000E-04
   +2.37660000E-04  -1.36570000E-04  -1.31044100E-01  -6.48700700E-02  +1.14755100E-01
   +1.13620000E-04  +6.52500000E-05  +3.77500000E-05  -1.13690000E-04  -6.65200000E-05
   -2.95500000E-05  +3.42700000E-05  -2.60200000E-05  -2.24600000E-05  +2.63000000E-06
   -3.38600000E-05  +4.68000000E-06  +1.64000000E-06  -1.40000000E-06  +8.93000000E-06
   -1.54100000E-05  -1.57600000E-05  +3.10500000E-05  +6.29000000E-06  +2.00000000E-08
   +2.96400000E-05  -1.11060000E-04  -5.42600000E-05  +7.11300000E-05  +5.15800000E-05
   -1.20800000E-05  -6.91000000E-06  -1.67000000E-06  +4.08000000E-05  -3.20400000E-05
   -2.85720000E-04  -6.87000000E-05  +1.23460000E-04  +1.27786000E-03  +8.41970000E-04
   -2.58560000E-04  -6.02164000E-03  +2.93027000E-03  +1.19250000E-03  +6.17960000E-04
   +3.71900400E-02  -2.28802200E-02  -2.13000000E-03  +6.87775000E-03  -2.17285000E-03
   +5.20270000E-04  -3.85820000E-04  -2.73330000E-04  -5.22871900E-02  -7.43162700E-02
   +6.41219400E-02  -2.85900000E-05  -7.29000000E-06  -1.81700000E-05  -7.42000000E-06
   +1.40700000E-05  -3.99000000E-06  -1.16200000E-05  +1.62200000E-05  -2.45500000E-05
   -1.08100000E-05  +1.08100000E-05  -5.40000000E-06  +6.30000000E-07  +6.20000000E-06
   -5.86000000E-06  +1.24600000E-05  -2.46800000E-05  +7.55000000E-06  -1.83400000E-05
   -4.20000000E-07  -7.00000000E-06  -4.12000000E-06  +8.94000000E-06  -4.42000000E-06
   -1.50800000E-05  +4.74000000E-06  +3.49800000E-05  -1.15600000E-05  -2.22000000E-06
   +8.08000000E-06  +1.46300000E-05  -1.85400000E-05  +1.41500000E-05  -3.18340000E-04
   +1.65420000E-04  +3.64500000E-05  -3.23000000E-05  -4.25000000E-06  +5.22800000E-05
   +5.61790400E-02  -1.85730000E-04  -1.60760000E-04  -5.93000000E-05  +1.46650000E-04
   +1.23780000E-04  +7.32300000E-05  -4.49300000E-05  -2.67000000E-06  +4.80800000E-05
   -1.16100000E-05  -5.25000000E-06  -1.67200000E-05  -1.23700000E-05  +1.55950000E-04
   +2.02500000E-05  +1.13500000E-05  -3.22000000E-06  -5.68300000E-05  -3.03700000E-05
   -6.62100000E-05  -4.70400000E-05  +2.44560000E-04  -1.39830000E-04  +8.04700000E-05
   -7.27500000E-05  -1.89900000E-05  +2.79600000E-05  -1.52210000E-04  +7.96900000E-05
   -5.55500000E-05  -7.25500000E-05  +5.10920000E-04  -4.21550000E-04  -3.65140000E-04
   -2.96840000E-04  +1.35351000E-03  +2.82454000E-03  +1.52360000E-04  -1.05553000E-03
   +2.10589000E-03  -2.78572400E-02  +1.38784100E-02  -1.89637000E-03  +3.68189000E-03
   -1.69660000E-04  -3.64400000E-05  -1.63269000E-03  +6.29690000E-04  -3.23424500E-02
   -3.62095270E-01  +2.21311520E-01  +1.55200000E-05  +3.69900000E-05  +1.34800000E-05
   -1.53100000E-05  -7.42000000E-06  -2.51200000E-05  +2.45600000E-05  +2.06800000E-05
   +5.50100000E-05  +1.99400000E-05  +1.04300000E-05  -5.83000000E-06  -1.49200000E-05
   -4.57000000E-06  +2.67000000E-06  -2.79800000E-05  +3.99800000E-05  -7.72000000E-06
   +8.75000000E-06  -2.45600000E-05  +5.55000000E-06  +1.86700000E-05  -9.09000000E-06
   -3.53000000E-06  +1.96200000E-05  -1.44900000E-05  -1.10500000E-05  +2.43000000E-06
   -3.81100000E-05  -3.13200000E-05  -5.62000000E-05  +4.81800000E-05  +6.60400000E-05
   +1.54270000E-04  -1.45900000E-05  -5.37800000E-05  -2.82560000E-04  +2.40470000E-04
   +5.44100000E-05  +3.00770800E-02  +3.88833850E-01  +4.46700000E-05  +3.15300000E-05
   +4.06000000E-06  -3.34300000E-05  -2.81100000E-05  -1.42100000E-05  +1.02700000E-05
   -1.01200000E-05  -1.09200000E-05  -6.41000000E-06  +8.91000000E-06  +4.09600000E-05
   +7.25000000E-06  -4.62300000E-05  -2.88100000E-05  -1.58700000E-05  +8.80000000E-06
   +6.65000000E-06  +2.34000000E-05  +2.82800000E-05  +1.58000000E-06  -1.37160000E-04
   +5.26600000E-05  -1.63960000E-04  +2.25400000E-05  +1.29000000E-05  -1.95900000E-05
   +1.35080000E-04  -9.03100000E-05  +5.38100000E-05  +1.57220000E-04  -3.24610000E-04
   +1.62750000E-04  +4.49100000E-04  +8.73130000E-04  +1.09454000E-03  +1.23688000E-03
   -1.06015000E-03  +6.20610000E-04  -2.55000000E-03  -1.57924000E-03  -2.65970000E-04
   +2.87791000E-03  -4.05937000E-03  +2.89019000E-03  -4.90960000E-04  +7.95020000E-04
   -8.19530000E-04  +3.97821900E-02  +2.39777960E-01  -1.61133610E-01  -1.04500000E-05
   -4.38000000E-06  +1.98000000E-06  -8.24000000E-06  +7.40000000E-07  -1.46000000E-06
   -2.72000000E-06  +9.91000000E-06  -2.38500000E-05  +2.66000000E-06  -1.24400000E-05
   -1.90000000E-06  +9.05000000E-06  +1.10000000E-07  -3.70000000E-07  +1.13400000E-05
   -1.58100000E-05  -1.61000000E-06  -7.06000000E-06  +2.51000000E-06  +2.73000000E-06
   -9.29000000E-06  +5.05000000E-06  -1.34800000E-05  +1.17400000E-05  +1.93900000E-05
   -6.19000000E-06  -6.71000000E-06  +1.24000000E-06  +1.97300000E-05  +2.14300000E-05
   -2.56000000E-05  -6.36600000E-05  +4.44500000E-05  -6.04400000E-05  +1.35500000E-05
   +2.28240000E-04  -7.87000000E-05  +4.39800000E-05  -3.95680900E-02  -2.35004290E-01
   +1.59594140E-01  -1.70790000E-04  -1.03860000E-04  -6.53700000E-05  +1.58990000E-04
   +1.02230000E-04  +6.96900000E-05  -3.06200000E-05  +4.46500000E-05  +1.16800000E-05
   -7.09400000E-05  +4.29200000E-05  +3.57500000E-05  +1.17000000E-04  +1.27800000E-05
   +2.61400000E-05  +4.75800000E-05  +3.16900000E-05  -7.98800000E-05  -1.47900000E-05
   -2.01700000E-05  -7.07900000E-05  +6.17970000E-04  +1.17297000E-03  -9.20170000E-04
   -5.16020000E-04  +1.45200000E-04  +1.56180000E-04  +5.81400000E-05  -1.09670000E-04
   -9.11500000E-05  -4.97327000E-03  -2.37453000E-03  +7.10792000E-03  +3.56170000E-03
   +4.58090000E-04  -2.44821000E-03  -5.58778000E-03  +3.33854000E-03  +2.38318000E-03
   -1.95815000E-03  -3.21705700E-02  +2.33447300E-02  -1.05483390E-01  +1.12909700E-02
   +2.04404000E-02  +1.75572000E-03  +3.85830300E-02  -2.02232000E-02  +5.35498000E-03
   -7.46229000E-03  +5.15460000E-04  +3.56200000E-05  +8.92000000E-06  +3.09600000E-05
   -9.50000000E-07  -2.36400000E-05  +2.86000000E-06  -1.31400000E-05  -2.45200000E-05
   +1.96600000E-05  +1.61900000E-05  -1.38200000E-05  +8.08000000E-06  -2.71000000E-06
   -1.25900000E-05  +6.66000000E-06  -2.96000000E-05  +1.36930000E-04  -1.44010000E-04
   +3.18200000E-05  +2.29900000E-05  +9.25000000E-06  +4.13000000E-06  -2.92000000E-06
   -4.70700000E-05  +3.12500000E-05  -2.95600000E-05  -6.03600000E-05  +2.96100000E-05
   +3.19000000E-05  +3.11800000E-05  -1.45400000E-05  +5.39900000E-05  -1.12800000E-05
   +2.56900000E-04  -6.64900000E-05  -2.23170000E-04  +2.23223000E-03  -7.84430000E-04
   -2.33905000E-03  +1.28021000E-03  +8.10800000E-05  -1.11940000E-03  +5.07035040E-01
   +9.16540000E-04  +8.39930000E-04  +2.63640000E-04  -6.93070000E-04  -6.20630000E-04
   -3.82100000E-04  +1.74020000E-04  +7.45900000E-05  -2.64410000E-04  -4.33900000E-05
   +2.56400000E-05  +1.15760000E-04  -2.88570000E-04  -6.63320000E-04  -2.52860000E-04
   -1.92810000E-04  +3.48400000E-05  +2.59460000E-04  +2.06140000E-04  +3.89510000E-04
   +2.19920000E-04  -1.64486000E-03  -3.12970000E-04  +1.24675000E-03  +9.07770000E-04
   -3.47590000E-04  -1.78480000E-04  +2.93270000E-04  -2.83000000E-05  +1.43800000E-05
   +1.95979000E-03  +2.96177000E-03  +1.95935000E-03  +3.52021000E-03  -6.53272000E-03
   +1.59910000E-03  +2.72490000E-04  +7.84003000E-03  -2.37774000E-03  +9.45830000E-04
   -3.55599200E-02  +2.50799600E-02  +5.16294100E-02  -2.45768300E-01  +9.73244900E-02
   +4.77625000E-03  -3.27635200E-02  +2.04045100E-02  -4.83264000E-03  +7.42459000E-03
   -3.93730000E-03  -4.56100000E-05  -2.04950000E-04  -2.68800000E-05  +8.45700000E-05
   +1.21500000E-05  +1.52210000E-04  -1.73850000E-04  -1.77980000E-04  -2.58320000E-04
   -9.33500000E-05  -7.40800000E-05  +2.08800000E-05  +1.08780000E-04  -6.73000000E-06
   +2.91000000E-06  +2.44730000E-04  -3.26730000E-04  +3.80900000E-05  -3.53200000E-05
   +3.10820000E-04  +1.98500000E-05  -1.70380000E-04  +4.74300000E-05  -1.74220000E-04
   -7.10600000E-05  +4.82800000E-05  +8.50000000E-05  -3.51500000E-05  +1.39630000E-04
   +1.67110000E-04  +1.82490000E-04  -2.37140000E-04  -8.98200000E-05  -1.13180000E-04
   -4.90000000E-07  -2.08160000E-04  -1.43744000E-03  +1.88062000E-03  -2.82205000E-03
   -1.49646000E-03  -1.35064000E-03  +6.37760000E-04  +5.67377800E-02  +3.63147320E-01
   -4.58720000E-04  -3.82200000E-04  -1.17080000E-04  +3.45810000E-04  +3.01430000E-04
   +1.87650000E-04  -6.14400000E-05  +3.50100000E-05  +1.49590000E-04  -2.12600000E-05
   +9.80000000E-07  -1.20860000E-04  -1.04550000E-04  +2.15860000E-04  +1.12700000E-04
   +1.65620000E-04  +1.88000000E-06  -1.45480000E-04  -1.31620000E-04  -2.26650000E-04
   -1.12250000E-04  +1.14741000E-03  +7.15300000E-05  +1.59460000E-04  -2.61520000E-04
   +3.28200000E-05  +4.56400000E-05  -1.78290000E-04  +1.10810000E-04  -1.08380000E-04
   +4.25467000E-03  +4.07492000E-03  +3.28414000E-03  -4.41575000E-03  +2.76968000E-03
   -1.32474000E-03  +4.12143000E-03  -3.76105000E-03  +4.64104000E-03  +4.45871000E-03
   +3.97090100E-02  -1.59018300E-02  -2.84789000E-03  +1.12817410E-01  -1.04022930E-01
   -6.46080000E-04  +5.92057000E-03  +4.04836000E-03  -1.06412000E-03  -2.97459000E-03
   -1.04131000E-03  +4.72500000E-05  +8.28600000E-05  +1.71700000E-05  -1.37800000E-05
   -1.45000000E-05  -4.50300000E-05  +9.13200000E-05  +6.05700000E-05  +1.47850000E-04
   +2.43900000E-05  +5.58800000E-05  +1.34000000E-06  -6.25700000E-05  +3.67000000E-06
   -1.86000000E-06  -1.65320000E-04  +4.46600000E-05  -2.68900000E-05  +9.65000000E-06
   -1.93620000E-04  -6.71000000E-06  +1.11920000E-04  -1.60500000E-05  +9.02900000E-05
   -1.83500000E-05  -6.16300000E-05  -1.31800000E-05  +1.54700000E-05  -6.36600000E-05
   -1.17760000E-04  -1.12450000E-04  +6.93100000E-05  +1.05690000E-04  -2.25240000E-04
   -2.04120000E-04  -1.67200000E-04  -1.90226000E-03  -3.32099000E-03  -1.95097000E-03
   -1.82330000E-04  +1.11400000E-05  -1.17389000E-03  -2.25125210E-01  -2.15770520E-01
   +2.38180230E-01  +1.90700000E-05  -2.68600000E-05  +2.07900000E-05  -5.73200000E-05
   -7.54000000E-06  +3.60000000E-07  +2.27200000E-05  -4.60700000E-05  +5.97000000E-06
   +3.18500000E-05  -4.32600000E-05  -5.26200000E-05  +7.67200000E-05  +6.43100000E-05
   +4.80600000E-05  +2.60600000E-05  -1.51300000E-05  +4.16900000E-05  -3.86300000E-05
   -8.09000000E-05  +2.46600000E-05  +1.32740000E-04  +1.19620000E-04  -6.90200000E-05
   -7.04600000E-05  +2.67400000E-05  -1.26500000E-05  -3.41100000E-05  +3.06200000E-05
   -2.64900000E-05  -8.03580000E-04  +1.37460000E-04  -1.15600000E-04  -4.24800000E-04
   +5.43100000E-04  -1.31920000E-04  +9.96200000E-05  -7.37690000E-04  +7.45580000E-04
   +8.40100000E-05  +3.51050000E-03  -1.24113000E-03  +3.68858000E-03  +2.05941000E-03
   -3.34911000E-03  +3.28663000E-03  +3.07939000E-03  -3.29440000E-03  +6.44080000E-04
   -1.28076000E-03  +4.99440000E-04  -2.59200000E-05  +1.41900000E-05  -2.46100000E-05
   -9.91000000E-06  +1.56700000E-05  -1.86200000E-05  +1.25800000E-05  +2.71200000E-05
   +1.99500000E-05  +1.27000000E-06  +3.24600000E-05  -8.08000000E-06  -2.13900000E-05
   +1.59200000E-05  -7.83000000E-06  -1.98700000E-05  +2.33200000E-05  +4.97000000E-06
   -1.30900000E-05  -4.94000000E-05  +2.29000000E-06  +1.86600000E-05  -2.70000000E-07
   +2.03300000E-05  +2.60100000E-05  +2.05000000E-05  +3.82400000E-05  -1.30300000E-05
   -4.99200000E-05  -1.28000000E-06  -1.17900000E-05  +1.30400000E-05  +7.61000000E-06
   -5.12200000E-05  -2.42200000E-05  +8.57000000E-05  -1.01669000E-03  -4.42160000E-04
   +7.98170000E-04  +1.02144000E-03  -1.44160000E-04  -7.38870000E-04  -4.03154960E-01
   -1.10494780E-01  +2.22344860E-01  +3.96432480E-01  -2.65410000E-04  -2.56420000E-04
   -7.91900000E-05  +2.36950000E-04  +1.83770000E-04  +9.41100000E-05  -7.28400000E-05
   -4.60000000E-05  +5.52500000E-05  +3.74000000E-06  +4.96900000E-05  +2.47200000E-05
   +5.23200000E-05  +1.34580000E-04  -9.00000000E-08  +3.17000000E-05  +2.15600000E-05
   -7.61600000E-05  -1.75500000E-05  -6.71100000E-05  -6.43100000E-05  +2.52750000E-04
   +8.99000000E-05  -4.64500000E-05  -1.67700000E-04  +1.26700000E-05  +2.88000000E-05
   -1.17740000E-04  -3.25100000E-05  +1.79300000E-05  -2.04150000E-04  -9.13710000E-04
   +1.50870000E-04  +5.35590000E-04  +3.79740000E-04  -4.70560000E-04  -1.42091000E-03
   +5.42750000E-04  +8.73000000E-04  +2.84283000E-03  -5.66897000E-03  +3.13648000E-03
   -3.76267600E-02  -1.55061600E-02  +2.28673800E-02  -1.45673000E-03  +2.45815000E-03
   -1.11840000E-03  +1.37423000E-03  +9.21860000E-04  -1.13914000E-03  +9.17000000E-06
   +6.44100000E-05  +4.35000000E-06  -2.37000000E-05  -3.13000000E-06  -4.44500000E-05
   +1.49600000E-05  +1.83100000E-05  +4.75700000E-05  +4.13400000E-05  -5.52000000E-06
   -8.44000000E-06  -2.37700000E-05  +4.25000000E-06  +2.82000000E-06  -2.96400000E-05
   +6.78200000E-05  -2.43100000E-05  +7.88000000E-06  -2.58200000E-05  +5.64000000E-06
   +2.00600000E-05  +7.00000000E-08  -1.80100000E-05  +7.21500000E-05  -2.09400000E-05
   -7.19300000E-05  +7.04000000E-06  -2.37100000E-05  -1.76500000E-05  -4.83300000E-05
   +8.22900000E-05  +8.77000000E-06  +1.36750000E-04  +7.32500000E-05  -2.50900000E-05
   +2.02485000E-03  -4.65670000E-04  -2.73820000E-04  -1.67040000E-03  -2.29920000E-04
   +4.29440000E-04  -6.81560900E-02  -5.93289200E-02  +5.97482800E-02  +1.03672410E-01
   +7.77227200E-02  +1.36880000E-04  +7.47600000E-05  +2.51200000E-05  -1.38260000E-04
   -8.07400000E-05  -2.52000000E-05  +1.82200000E-05  -1.02610000E-04  -3.37600000E-05
   +5.11200000E-05  -3.62000000E-06  +5.17700000E-05  +4.49100000E-05  -5.95700000E-05
   -3.21600000E-05  -6.51200000E-05  +8.03000000E-06  +4.51500000E-05  +3.54400000E-05
   +5.56300000E-05  +1.81500000E-05  -1.48130000E-04  -1.41500000E-05  +1.39370000E-04
   +9.50300000E-05  -4.31300000E-05  -5.08500000E-05  +2.22900000E-05  -7.20800000E-05
   +7.41900000E-05  -2.25000000E-05  -1.33300000E-04  -8.87700000E-04  -2.61900000E-05
   -5.00710000E-04  +3.40020000E-04  +1.15907000E-03  +6.29750000E-04  -2.55000000E-05
   -7.17200000E-04  +2.89440000E-03  +6.79080000E-04  +1.93514800E-02  +7.37446000E-03
   -1.40321300E-02  -7.25530000E-04  -2.93013000E-03  +1.45882000E-03  -1.05192000E-03
   +2.37410000E-04  +4.11910000E-04  -4.09100000E-05  -4.17000000E-06  -1.57000000E-05
   -2.17600000E-05  +2.01100000E-05  -2.36900000E-05  -7.14000000E-06  +4.01400000E-05
   -5.66100000E-05  +1.02100000E-05  -2.96600000E-05  -1.08300000E-05  +2.28300000E-05
   -1.11000000E-06  -2.80000000E-07  +3.29700000E-05  -2.85600000E-05  +2.04100000E-05
   -1.81100000E-05  +1.29200000E-05  +7.00000000E-06  -1.47100000E-05  +1.31500000E-05
   -2.73300000E-05  +2.59400000E-05  +2.85800000E-05  +1.14500000E-05  -1.42000000E-05
   -3.45000000E-06  +1.97600000E-05  +2.71600000E-05  -1.21800000E-05  -3.94800000E-05
   +7.94000000E-06  +5.31500000E-05  +1.07990000E-04  -4.79850000E-04  +7.55190000E-04
   +3.53020000E-04  +4.78300000E-05  -2.95460000E-04  -6.62640000E-04  +1.97956380E-01
   +7.61614900E-02  -1.23799100E-01  -2.15465920E-01  -8.40917600E-02  +1.36099210E-01
   +8.25300000E-05  +6.43600000E-05  +3.60100000E-05  -5.81500000E-05  -5.29300000E-05
   -3.67600000E-05  +2.17500000E-05  +5.02000000E-06  -1.07100000E-05  +3.83600000E-05
   -2.00000000E-08  -2.53500000E-05  +8.59000000E-05  -1.86590000E-04  -8.02300000E-05
   +2.46100000E-05  +2.55300000E-05  +6.93100000E-05  +1.68100000E-05  +3.37600000E-05
   +1.88500000E-05  -1.37660000E-04  +6.16650000E-04  -1.26830000E-04  +4.79600000E-05
   -1.14800000E-05  -4.00500000E-05  +9.63900000E-05  -3.39900000E-05  +5.39800000E-05
   -1.97830000E-04  -1.63603000E-03  +1.19836000E-03  +6.45327000E-03  +1.29761000E-03
   -4.37314000E-03  -9.29368900E-02  -3.38988400E-02  +6.36762500E-02  +5.69291000E-03
   +1.16181000E-03  -3.94008000E-03  -1.05627000E-03  +9.30840000E-04  +3.41230000E-04
   -3.37220000E-04  -7.84500000E-05  +1.01860000E-04  +2.08750000E-04  -1.45666000E-03
   +9.54350000E-04  -5.41000000E-06  -8.63000000E-06  -1.32000000E-05  +1.36600000E-05
   +1.37000000E-05  +8.48000000E-06  -1.08500000E-05  -1.23600000E-05  -2.68600000E-05
   -1.22700000E-05  -6.89000000E-06  +4.41000000E-06  +6.54000000E-06  +9.80000000E-06
   -9.40000000E-07  +2.65800000E-05  -2.33300000E-05  +9.63000000E-06  +5.70000000E-07
   +1.61500000E-05  +5.20000000E-07  -4.09000000E-06  +2.31000000E-06  +8.59000000E-06
   -7.57000000E-06  +5.06000000E-06  -3.20000000E-07  -1.07000000E-05  +1.58600000E-05
   +5.41000000E-06  +2.59800000E-05  -2.39700000E-05  -4.47800000E-05  -4.96030000E-04
   +1.01955000E-03  -5.68480000E-04  +3.85500000E-05  +8.14000000E-05  -1.21250000E-04
   -1.96880000E-04  -3.38900000E-05  +9.86800000E-05  +3.32580000E-04  +2.61860000E-04
   -2.63470000E-04  -8.99800000E-05  +2.37000000E-05  -1.46500000E-05  +1.36033150E-01
   +5.70800000E-05  +5.41300000E-05  +2.32800000E-05  -4.29400000E-05  -4.08800000E-05
   -2.30100000E-05  +1.38500000E-05  +1.40600000E-05  -1.46200000E-05  +8.34000000E-06
   +1.10400000E-05  -2.61500000E-05  +2.76400000E-05  -7.32100000E-05  -5.04100000E-05
   +1.09700000E-05  +1.59300000E-05  +3.44100000E-05  +8.32000000E-06  +2.20500000E-05
   +1.60800000E-05  +2.34400000E-05  +2.52630000E-04  +5.27100000E-05  -2.56500000E-05
   -2.93600000E-05  -9.50000000E-06  -4.19500000E-05  +1.82600000E-05  +3.31000000E-06
   -2.95680000E-04  -5.08040000E-04  +6.49590000E-04  +5.62860000E-04  +7.87530000E-04
   -1.67494000E-03  -1.44594500E-02  -3.83454000E-03  +1.16417900E-02  +2.41968000E-03
   -1.27433000E-03  -1.24216000E-03  +1.45500000E-05  +1.78370000E-04  +4.16620000E-04
   -8.26200000E-05  +9.33700000E-05  -1.36970000E-04  -1.85206000E-03  -1.76420000E-04
   +1.17084000E-03  +0.00000000E+00  -1.36000000E-05  -6.26000000E-06  +1.29000000E-05
   +3.50000000E-06  +1.05900000E-05  -1.20000000E-06  -2.78300000E-05  -2.49000000E-06
   -8.87000000E-06  -6.48000000E-06  +5.78000000E-06  +5.09000000E-06  +2.73000000E-06
   +5.90000000E-07  +2.28500000E-05  +4.69000000E-06  -5.07000000E-06  +3.82000000E-06
   +4.22700000E-05  +2.66200000E-05  -2.13000000E-05  -1.28800000E-05  -7.11000000E-06
   +4.45000000E-06  +6.67000000E-06  -1.81500000E-05  +3.48000000E-06  +7.98000000E-06
   +1.01200000E-05  +2.16000000E-06  +3.85000000E-06  +6.99000000E-06  -6.13620000E-04
   +2.05550000E-04  -8.76700000E-05  -2.58400000E-05  +3.34500000E-05  -8.17100000E-05
   -3.42860000E-04  +2.03690000E-04  +3.34600000E-05  -1.11210000E-04  +2.88490000E-04
   -8.55200000E-05  -2.29100000E-05  +1.78000000E-06  -2.90600000E-05  -1.77303560E-01
   +3.98988040E-01  -5.92300000E-05  -3.93800000E-05  -8.82000000E-06  +5.53600000E-05
   +3.59400000E-05  +8.05000000E-06  -2.34700000E-05  -1.17000000E-06  +2.27600000E-05
   +3.79300000E-05  -5.63000000E-06  -4.47400000E-05  -1.65300000E-05  +6.00000000E-05
   +8.12200000E-05  -1.80000000E-07  -1.68500000E-05  -1.91900000E-05  -1.81400000E-05
   -1.35300000E-05  +3.16000000E-06  +1.67770000E-04  -2.57260000E-04  +2.70820000E-04
   -2.43500000E-05  -2.90500000E-05  -2.79300000E-05  -1.48130000E-04  +2.81500000E-05
   -3.80200000E-05  +4.69210000E-04  +1.34487000E-03  -4.90620000E-04  -3.99058000E-03
   -1.97647000E-03  +1.48961000E-03  +5.33613600E-02  +2.06713600E-02  -3.12060700E-02
   -4.78291000E-03  -7.38900000E-04  +9.97750000E-04  +8.63220000E-04  -3.87000000E-05
   +4.87410000E-04  +1.23340000E-04  -1.69570000E-04  -1.45340000E-04  +1.16964000E-03
   +1.04841000E-03  -7.15520000E-04  +1.37300000E-05  +8.48000000E-06  +1.00000000E-07
   +8.59000000E-06  +2.92000000E-06  -2.48000000E-06  +5.70000000E-07  -4.30000000E-07
   +2.16000000E-06  -1.35000000E-06  +6.33000000E-06  +5.77000000E-06  -7.66000000E-06
   -1.72000000E-06  +1.11000000E-06  -2.34900000E-05  +1.07700000E-05  +1.32300000E-05
   +6.65000000E-06  -1.01400000E-05  -2.02100000E-05  +3.28900000E-05  +1.73400000E-05
   +2.49000000E-05  -5.46000000E-06  -1.53600000E-05  +1.29800000E-05  +1.33700000E-05
   +1.41500000E-05  -1.25600000E-05  -5.61000000E-06  +2.48300000E-05  +4.72400000E-05
   +4.09800000E-04  -8.29380000E-04  -9.57000000E-05  -5.40300000E-05  -1.28430000E-04
   -2.28900000E-05  +2.81140000E-04  -1.22350000E-04  -9.00300000E-05  -6.33700000E-05
   -2.64300000E-04  +2.39200000E-04  +2.57900000E-05  -5.24900000E-05  -4.45800000E-05
   +4.61653000E-02  -1.53189510E-01  +7.58429900E-02  +2.03850000E-04  +1.43850000E-04
   +6.56700000E-05  -1.66430000E-04  -1.27050000E-04  -7.64200000E-05  +4.83600000E-05
   -2.45400000E-05  -4.45700000E-05  +1.13600000E-05  -1.20100000E-05  +4.08900000E-05
   +3.79100000E-05  -1.49690000E-04  -4.16900000E-05  -2.17800000E-05  -3.15000000E-06
   +6.12400000E-05  +3.78200000E-05  +5.71900000E-05  +5.10500000E-05  -1.63960000E-04
   +1.68630000E-04  -8.87100000E-05  +9.90100000E-05  -1.19100000E-05  -2.31900000E-05
   +1.36240000E-04  -5.04900000E-05  +3.82100000E-05  +3.62330000E-04  +5.55100000E-05
   -4.99100000E-05  +2.87870000E-04  +3.08600000E-04  -3.19740000E-04  -3.90384000E-03
   +5.63170000E-04  +6.43780000E-04  -2.47110000E-04  -3.39920000E-04  +8.03090000E-04
   -7.58700000E-04  -1.68080000E-04  +4.14870000E-04  +2.65600000E-04  -1.64200000E-04
   -3.30000000E-05  -4.03980000E-04  +6.75380000E-04  -7.17720000E-04  -3.44500000E-05
   -2.27200000E-05  -2.28500000E-05  +4.00000000E-08  +1.70800000E-05  +1.04700000E-05
   -2.66500000E-05  +4.27000000E-06  -5.85200000E-05  -1.78100000E-05  -4.58000000E-06
   -1.89000000E-06  +1.17800000E-05  +1.01200000E-05  -6.53000000E-06  +4.85700000E-05
   -3.71400000E-05  +1.78000000E-06  -1.25800000E-05  +3.46100000E-05  -1.60000000E-07
   -2.72600000E-05  +1.01500000E-05  -1.37400000E-05  -2.00400000E-05  +1.19400000E-05
   +2.72600000E-05  -1.70800000E-05  +2.65900000E-05  +2.72100000E-05  +5.35200000E-05
   -5.55500000E-05  -5.04300000E-05  +1.20890000E-04  -1.34120000E-04  -2.63000000E-05
   +3.54900000E-05  +2.44400000E-05  -3.78900000E-05  +6.28730000E-04  -2.27020000E-04
   -2.10420000E-04  +3.52810000E-04  +6.33890000E-04  -5.38330000E-04  -8.21000000E-06
   -7.00700000E-05  +5.57500000E-05  -1.11719080E-01  +1.67732420E-01  -5.01161800E-02
   +1.22418480E-01  -9.14000000E-05  -7.31300000E-05  -3.30000000E-05  +7.33100000E-05
   +5.84400000E-05  +3.48400000E-05  -2.30800000E-05  -1.97000000E-06  +2.17600000E-05
   -6.35000000E-06  -1.70000000E-07  -7.60000000E-07  -1.88600000E-05  +1.00120000E-04
   +4.47500000E-05  -2.10000000E-06  -1.23100000E-05  -3.78900000E-05  -1.47400000E-05
   -2.81300000E-05  -2.22300000E-05  +2.95400000E-05  -2.40460000E-04  +1.08590000E-04
   -2.97000000E-05  +1.42100000E-05  +2.15000000E-06  -4.81200000E-05  +1.50000000E-05
   -1.82000000E-05  -1.22580000E-04  +4.44990000E-04  -6.39800000E-05  -1.26546000E-03
   -1.20780000E-03  +1.29434000E-03  +5.67363000E-03  +2.82642000E-03  -5.17918000E-03
   -4.43577000E-03  +2.78520000E-03  +9.85980000E-04  +1.26707000E-03  -1.66420000E-04
   -5.16920000E-04  -2.32150000E-04  +1.75660000E-04  +1.86800000E-05  +1.80375000E-03
   -1.83604000E-03  -3.85050000E-04  +8.76000000E-06  +1.47500000E-05  +1.04400000E-05
   -8.77000000E-06  -7.34000000E-06  -1.00800000E-05  +1.05400000E-05  +1.43000000E-05
   +1.97300000E-05  +1.10600000E-05  +4.77000000E-06  -2.72000000E-06  -6.63000000E-06
   -4.34000000E-06  +1.23000000E-06  -2.77500000E-05  +1.25900000E-05  +3.59000000E-06
   -9.30000000E-07  -2.89600000E-05  -7.51000000E-06  +1.76000000E-05  +3.22000000E-06
   +6.53000000E-06  +7.60000000E-06  -4.13000000E-06  -5.48000000E-06  +6.88000000E-06
   -1.38800000E-05  -8.54000000E-06  -1.76000000E-05  +2.40000000E-05  +1.70700000E-05
   +8.26500000E-05  -1.38930000E-04  -2.98900000E-05  +8.32000000E-06  -6.69800000E-05
   +2.50600000E-05  +2.87220000E-04  -2.56860000E-04  -5.79300000E-05  -1.16490000E-04
   -4.97370000E-04  +3.05120000E-04  +2.80100000E-05  -2.75300000E-05  +2.96200000E-05
   +1.93225440E-01  -3.79189050E-01  +1.35954340E-01  -1.86748760E-01  +3.78379340E-01
   -4.28900000E-05  -3.35400000E-05  -1.96900000E-05  +3.27700000E-05  +2.53200000E-05
   +1.89100000E-05  -1.04300000E-05  +5.79000000E-06  +7.29000000E-06  -1.93400000E-05
   +3.40000000E-07  +6.73000000E-06  +2.83400000E-05  +1.77900000E-05  -2.55000000E-05
   +8.80000000E-07  +5.00000000E-07  -7.93000000E-06  -1.72000000E-06  -7.81000000E-06
   -1.80500000E-05  +7.30800000E-05  +8.07100000E-05  +1.55800000E-05  -2.83200000E-05
   +1.35000000E-06  +1.27600000E-05  -2.88700000E-05  +2.60900000E-05  -3.73000000E-06
   -1.46100000E-05  -1.76570000E-04  +2.46180000E-04  +5.82760000E-04  +5.49110000E-04
   -6.52470000E-04  -2.32420000E-03  -2.84997000E-03  +1.12211000E-03  +3.22436000E-03
   -8.51000000E-04  +1.49980000E-04  -4.30880000E-04  +1.47300000E-04  +7.15800000E-05
   +2.08200000E-05  -2.53700000E-05  +1.21000000E-05  -1.37549000E-03  +7.47500000E-05
   -4.91350000E-04  +4.00000000E-06  +5.49000000E-06  +8.91000000E-06  -7.93000000E-06
   -7.31000000E-06  -4.59000000E-06  +8.78000000E-06  +7.19000000E-06  +2.11800000E-05
   +9.09000000E-06  -1.50000000E-06  -3.35000000E-06  -4.90000000E-07  -2.07000000E-06
   +1.12000000E-06  -4.66000000E-06  +1.14800000E-05  -2.45000000E-06  +1.10000000E-06
   -7.34000000E-06  +6.80000000E-06  +6.70000000E-07  -5.94000000E-06  -6.18000000E-06
   +1.11200000E-05  +1.26000000E-06  -1.16800000E-05  -2.18000000E-06  -1.80000000E-05
   -3.24000000E-06  -1.65200000E-05  +1.44400000E-05  +1.09600000E-05  -1.54500000E-04
   +6.81000000E-05  -9.32400000E-05  -2.46700000E-05  +1.90200000E-05  -1.19000000E-05
   -5.08860000E-04  +1.98110000E-04  +3.60200000E-05  -1.15970000E-04  -2.43600000E-05
   +6.13000000E-06  +3.10000000E-06  +7.09200000E-05  -2.65000000E-06  -6.52983300E-02
   +1.47604520E-01  -6.07686700E-02  +5.62127700E-02  -1.38837240E-01  +5.88571100E-02
   -6.65130000E-04  -4.87900000E-04  -2.32400000E-04  +5.29350000E-04  +4.17800000E-04
   +2.47200000E-04  -1.72880000E-04  +2.40500000E-05  +1.33890000E-04  -8.12600000E-05
   +1.97200000E-05  -3.16100000E-05  -2.68670000E-04  +8.18830000E-04  +3.58050000E-04
   -2.87700000E-05  -8.36300000E-05  -3.09030000E-04  -1.24910000E-04  -2.07080000E-04
   -1.46700000E-04  +3.98140000E-04  -2.06531000E-03  +7.96170000E-04  -2.85750000E-04
   +9.92000000E-06  +1.02440000E-04  -5.57170000E-04  +1.78840000E-04  -2.26630000E-04
   -1.23062000E-03  +5.78614000E-03  -1.77814000E-03  -2.20203200E-02  -9.16781000E-03
   +1.69268500E-02  +3.31970900E-02  +1.92952400E-02  -3.58030000E-02  -1.75475700E-02
   +2.14449000E-03  +8.20573000E-03  +5.64195000E-03  -6.71650000E-04  -1.10380000E-03
   -2.04700000E-04  +6.03000000E-04  -4.40850000E-04  +2.72000000E-03  +3.04790000E-04
   -1.99675000E-03  +8.97900000E-05  +7.72000000E-05  +7.98800000E-05  -3.30700000E-05
   -6.57600000E-05  -4.76700000E-05  +7.79600000E-05  +3.87700000E-05  +1.72210000E-04
   +6.78700000E-05  +3.28600000E-05  -5.48000000E-06  -4.68000000E-05  -4.46400000E-05
   +1.53200000E-05  -1.75070000E-04  +1.40690000E-04  -1.26700000E-05  +4.20500000E-05
   -1.21510000E-04  -2.26000000E-05  +9.43200000E-05  +3.08000000E-06  +2.48400000E-05
   +5.22000000E-05  -4.24300000E-05  -4.75800000E-05  +7.40500000E-05  -7.81400000E-05
   -7.56300000E-05  -1.68200000E-04  +2.00190000E-04  +2.24700000E-04  +1.13733000E-03
   -1.79657000E-03  -3.29200000E-05  -1.70790000E-04  -3.09600000E-04  +3.17780000E-04
   -1.41790000E-04  +2.70080000E-04  -2.59030000E-04  -1.28883000E-03  -1.99386000E-03
   +1.66205000E-03  +2.40440000E-04  +1.13600000E-05  -1.29370000E-04  +5.80300100E-02
   +2.43177900E-02  -4.38650300E-02  -7.61170000E-03  -9.32416000E-03  +1.01972100E-02
   -4.95685600E-02  -7.28500000E-05  -5.83300000E-05  -2.55300000E-05  +6.15200000E-05
   +5.03600000E-05  +2.19400000E-05  -2.60400000E-05  -4.29000000E-06  +1.69100000E-05
   -5.87000000E-06  -3.45000000E-06  +2.48900000E-05  +1.33600000E-05  +9.73000000E-06
   +3.95000000E-05  -2.56000000E-06  +0.00000000E+00  -4.05000000E-05  -1.10700000E-05
   -1.46900000E-05  -1.95200000E-05  +2.93210000E-04  -1.02670000E-04  -2.56590000E-04
   -4.48900000E-05  +6.31300000E-05  +8.10000000E-07  +5.05100000E-05  -1.51600000E-05
   +1.50400000E-05  +2.74642000E-03  +6.85210000E-04  -3.42610000E-04  +6.82197000E-03
   +4.34928000E-03  -3.35005000E-03  -1.19735000E-03  -3.59952900E-02  +9.11780000E-03
   -1.55734300E-02  -2.75069000E-03  +1.06850600E-02  +1.06431000E-03  -1.50577000E-03
   +1.87219000E-03  +5.37140000E-04  -1.01572000E-03  +7.34500000E-05  +1.14900000E-05
   +8.38760000E-04  -1.36352000E-03  +8.12000000E-06  +1.15700000E-05  +8.78000000E-06
   -7.05000000E-06  -6.55000000E-06  -7.28000000E-06  +9.40000000E-06  +1.99000000E-05
   +1.53700000E-05  +1.04100000E-05  +1.54000000E-06  -2.47000000E-06  -3.98000000E-06
   -3.87000000E-06  +1.23000000E-06  -3.30700000E-05  -5.30000000E-07  +1.70600000E-05
   +5.93000000E-06  -5.58400000E-05  -1.95900000E-05  +2.58300000E-05  +1.46600000E-05
   +2.77100000E-05  -5.02000000E-06  -4.61000000E-06  +9.79000000E-06  -2.31000000E-06
   -1.38000000E-05  -2.33200000E-05  -1.18800000E-05  -3.63000000E-06  -1.08300000E-05
   +4.15010000E-04  -4.27540000E-04  -6.94510000E-04  -2.28000000E-06  -1.64100000E-05
   +9.42200000E-05  +1.10000000E-05  +9.03500000E-05  -2.71070000E-04  -7.13830000E-04
   -6.63330000E-04  +6.31720000E-04  +3.22800000E-05  -2.07510000E-04  +4.66900000E-05
   +1.59572200E-02  -1.60534500E-02  -1.32726000E-03  +1.78731600E-02  -1.07123000E-03
   -6.08156000E-03  -2.82347900E-02  +5.38598900E-02  +3.37260000E-04  +2.42650000E-04
   +1.09500000E-04  -2.74200000E-04  -2.04740000E-04  -1.19570000E-04  +8.85200000E-05
   -2.16500000E-05  -8.28400000E-05  -2.43000000E-06  +4.10000000E-07  +7.19300000E-05
   +1.03830000E-04  -3.51990000E-04  -1.49340000E-04  -7.81000000E-06  +3.56300000E-05
   +1.22010000E-04  +6.64500000E-05  +9.37000000E-05  +7.24200000E-05  -5.21220000E-04
   +7.39930000E-04  -5.10600000E-04  +1.45940000E-04  -4.80000000E-06  -3.12800000E-05
   +3.88690000E-04  -9.39300000E-05  +1.11070000E-04  -1.65860000E-04  -1.79360000E-03
   +3.24882000E-03  +7.59075000E-03  +3.77190000E-03  -1.97780000E-03  -2.49146100E-02
   -4.45200000E-04  -9.81832000E-03  +1.88012000E-02  +2.87229000E-03  -6.40391000E-03
   -2.08416000E-03  +2.69292000E-03  +1.89177000E-03  -4.94670000E-04  +1.01150000E-04
   -3.80650000E-04  -1.85489000E-03  -1.51192000E-03  +2.17790000E-04  -5.06800000E-05
   -4.10500000E-05  -3.67900000E-05  +7.97000000E-06  +2.67200000E-05  +2.23800000E-05
   -4.24100000E-05  -1.59500000E-05  -8.68100000E-05  -3.05000000E-05  -1.41300000E-05
   -1.92000000E-06  +2.34300000E-05  +1.87700000E-05  -8.55000000E-06  +1.01550000E-04
   -5.67800000E-05  -2.77000000E-06  -5.45000000E-06  +7.65200000E-05  +3.56100000E-05
   -8.31500000E-05  +9.62000000E-06  -3.15000000E-05  -2.80700000E-05  +3.48800000E-05
   +3.54000000E-06  -3.04400000E-05  +2.90300000E-05  +4.51900000E-05  +7.60300000E-05
   -8.49200000E-05  -1.38340000E-04  -1.34330000E-03  +3.06490000E-04  -8.54440000E-04
   +1.28150000E-04  +2.28270000E-04  -5.60900000E-05  -9.89300000E-05  -3.86900000E-04
   -9.15800000E-05  +9.91490000E-04  +1.25889000E-03  -1.21904000E-03  -1.79380000E-04
   +5.59100000E-05  -9.22500000E-05  -3.77658000E-02  -5.01697000E-03  +1.42028900E-02
   -5.97586000E-03  +6.33280000E-03  +1.51522000E-03  +4.71025400E-02  -8.88396000E-03
   +4.24280000E-04
end_hess

