# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -882.70122950    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   008   -8.94125493E+00  -3.07818510E+00  -1.87766893E+00
   006   -6.91978692E+00  -1.61232404E+00  -1.28047598E+00
   006   -4.95889615E+00  -1.14787031E+00  -2.96496993E+00
   006   -2.94699740E+00  +3.52958132E-01  -2.24050047E+00
   006   -2.81920508E+00  +1.43258205E+00  +1.55329082E-01
   006   -4.80192427E+00  +9.44039389E-01  +1.80623707E+00
   006   -6.83254520E+00  -5.57496208E-01  +1.11344468E+00
   006   -5.89423034E-01  +3.15252349E+00  +8.24293709E-01
   006   -9.55496035E-01  +5.67149816E+00  -5.68850647E-01
   006   -4.51479855E-01  +3.72707070E+00  +3.66685835E+00
   006   +1.87974587E+00  +1.85366912E+00  +7.41593829E-02
   006   +3.73595056E+00  +2.95473235E+00  -1.42131560E+00
   006   +5.97410600E+00  +1.69721808E+00  -2.00229810E+00
   006   +6.43537079E+00  -7.06897496E-01  -1.10614100E+00
   006   +4.60486469E+00  -1.87133385E+00  +4.07547112E-01
   006   +2.40686881E+00  -5.78297499E-01  +8.96435043E-01
   008   +8.61570526E+00  -1.92015641E+00  -1.66106206E+00
   001   -8.76126910E+00  -3.70452240E+00  -3.56410409E+00
   001   -4.99755259E+00  -1.97089266E+00  -4.84075034E+00
   001   -1.42366636E+00  +6.68851282E-01  -3.57052483E+00
   001   -4.79204183E+00  +1.72694651E+00  +3.69265763E+00
   001   -8.35506997E+00  -9.32377483E-01  +2.42353012E+00
   001   -2.77126541E+00  +6.48260436E+00  -3.33991143E-02
   001   +5.18013045E-01  +7.02760623E+00  -7.71171492E-02
   001   -9.59710020E-01  +5.41522803E+00  -2.61243295E+00
   001   -3.74986409E-01  +2.00064395E+00  +4.78896711E+00
   001   +1.24600820E+00  +4.82306440E+00  +4.06524122E+00
   001   -2.07787621E+00  +4.82884084E+00  +4.28985691E+00
   001   +3.45367428E+00  +4.82925500E+00  -2.17915970E+00
   001   +7.39194867E+00  +2.59326521E+00  -3.16978287E+00
   001   +8.57448718E+00  -3.55546585E+00  -8.74781508E-01
   008   +5.10849011E+00  -4.22186653E+00  +1.27702460E+00
   001   +3.70375500E+00  -4.74259824E+00  +2.32897271E+00
   008   +4.03649697E-01  -3.58992798E+00  +3.73769039E+00
   001   +7.24252823E-01  -2.63991293E+00  +5.26090541E+00
   001   +8.71258021E-01  -1.86265850E+00  +2.08396364E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +6.10000000E-07  -7.20000000E-07  -9.70000000E-07
   +2.40000000E-07  -6.60000000E-07  -6.50000000E-07
   +3.20000000E-07  -9.00000000E-08  -4.70000000E-07
   +1.30000000E-07  +5.00000000E-08  -1.60000000E-07
   -9.00000000E-08  -2.90000000E-07  +5.00000000E-08
   -1.10000000E-07  -8.40000000E-07  -1.00000000E-07
   +1.20000000E-07  -9.70000000E-07  -4.40000000E-07
   -3.30000000E-07  -1.50000000E-07  +3.60000000E-07
   -5.90000000E-07  +4.00000000E-08  +7.90000000E-07
   -5.30000000E-07  -5.70000000E-07  +4.80000000E-07
   -1.50000000E-07  +3.80000000E-07  +2.30000000E-07
   -1.90000000E-07  +7.60000000E-07  +4.90000000E-07
   -7.00000000E-08  +1.14000000E-06  +3.90000000E-07
   +2.40000000E-07  +1.08000000E-06  +3.00000000E-08
   +4.10000000E-07  +5.60000000E-07  -3.00000000E-07
   +7.00000000E-08  +1.60000000E-07  +6.00000000E-08
   +3.80000000E-07  +1.41000000E-06  -8.00000000E-08
   +6.90000000E-07  -4.30000000E-07  -9.80000000E-07
   +5.20000000E-07  +2.20000000E-07  -6.10000000E-07
   +1.80000000E-07  +4.70000000E-07  -7.00000000E-08
   -2.60000000E-07  -1.13000000E-06  +0.00000000E+00
   +1.20000000E-07  -1.37000000E-06  -5.70000000E-07
   -7.20000000E-07  -2.70000000E-07  +8.50000000E-07
   -7.80000000E-07  +1.30000000E-07  +1.05000000E-06
   -4.90000000E-07  +3.60000000E-07  +7.40000000E-07
   -3.50000000E-07  -7.90000000E-07  +2.30000000E-07
   -6.60000000E-07  -4.30000000E-07  +7.30000000E-07
   -6.80000000E-07  -8.80000000E-07  +6.00000000E-07
   -4.30000000E-07  +8.30000000E-07  +8.20000000E-07
   -1.40000000E-07  +1.48000000E-06  +6.20000000E-07
   +5.70000000E-07  +1.26000000E-06  -3.30000000E-07
   +5.70000000E-07  +4.70000000E-07  -5.70000000E-07
   +5.80000000E-07  +1.50000000E-07  -7.00000000E-07
   +3.60000000E-07  -4.50000000E-07  -6.60000000E-07
   +2.20000000E-07  -7.30000000E-07  -4.80000000E-07
   +2.30000000E-07  -1.90000000E-07  -3.80000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +3.07096900E-01  +1.57467950E-01  +2.20998170E-01  -2.33763300E-02  +2.29671830E-01
   +5.88099410E-01  -2.23620750E-01  -1.27262390E-01  -4.47344900E-02  +5.76965710E-01
   -1.08364460E-01  -1.33068500E-01  -5.59818300E-02  +2.11873680E-01  +3.58538530E-01
   -2.10949000E-03  -3.06389400E-02  -1.11946300E-01  -8.59465900E-02  +1.61076200E-01
   +6.67482510E-01  -3.94014000E-02  -1.97449000E-02  +2.26366700E-02  -2.11979630E-01
   -5.73529000E-02  +6.77582500E-02  +5.62553510E-01  -3.39374900E-02  -4.46217000E-03
   +1.46335400E-02  -2.75308300E-02  -9.55164300E-02  -2.24530700E-02  +2.26840220E-01
   +3.38420350E-01  -1.00830200E-02  -5.12925000E-03  +1.23567000E-02  +1.36952520E-01
   +1.91824100E-02  -2.18315980E-01  -7.94815100E-02  +1.81713180E-01  +6.66797200E-01
   +3.17227000E-03  -2.52001000E-03  +1.05720000E-04  -4.73748900E-02  -1.34750900E-02
   +3.84307900E-02  -2.48815400E-01  -1.40601920E-01  -6.57761500E-02  +6.07854480E-01
   +5.92690000E-04  +5.02913000E-03  -6.06656000E-03  -3.40320900E-02  +3.24203000E-03
   +4.94318400E-02  -1.16304440E-01  -1.59487630E-01  -7.24917100E-02  +2.24695340E-01
   +3.36991970E-01  +7.22076000E-03  -1.87391000E-03  -7.41623000E-03  -1.09269700E-02
   +2.09463900E-02  +6.71293700E-02  -7.91058000E-03  -3.82967400E-02  -1.39072490E-01
   -1.13238210E-01  +1.41056250E-01  +6.31664430E-01  -2.11689000E-03  -2.00315000E-03
   -3.94507000E-03  -1.20271300E-02  +9.30678000E-03  +3.19063000E-02  +2.59484800E-02
   -1.38676000E-03  -2.81925700E-02  -1.14796170E-01  -3.67130900E-02  -2.49792800E-02
   +5.35799460E-01  -1.11012000E-03  -1.42710000E-03  +1.01793000E-03  +9.48613000E-03
   -4.51853000E-03  -9.80793000E-03  -1.92648900E-02  -1.15687400E-02  -1.95337800E-02
   -1.34848600E-02  -1.22225080E-01  -1.03024670E-01  +1.71654900E-01  +3.42594520E-01
   -4.03894000E-03  +5.54710000E-04  +5.73814000E-03  +3.33948500E-02  -8.84659000E-03
   -7.42957000E-02  -7.43310200E-02  -4.60215900E-02  +3.70025000E-03  +3.32622000E-02
   -6.90188500E-02  -2.79212760E-01  -1.01415820E-01  +1.22056100E-01  +6.11806920E-01
   +4.70500000E-04  +1.28233000E-03  +9.98784000E-03  +3.01172600E-02  -1.81851700E-02
   -8.38038200E-02  -5.91767100E-02  -2.77315500E-02  +1.23280300E-02  +3.25009100E-02
   +3.97172100E-02  +6.28057000E-02  -2.26160070E-01  -6.48655500E-02  +7.42381300E-02
   +5.56077540E-01  -1.00937000E-03  +5.05789000E-03  +1.38027000E-03  +2.07111000E-03
   -1.63675100E-02  -4.72658100E-02  -2.58199100E-02  -1.66248400E-02  +5.96727000E-03
   +2.09088200E-02  +2.70002600E-02  +1.46897500E-02  -4.05680200E-02  -9.62136600E-02
   -1.16614200E-02  +2.13693400E-01  +3.42140490E-01  +4.15440000E-03  -2.06585000E-03
   -5.65090000E-03  -3.39700000E-02  -1.86651500E-02  +6.29509000E-03  +1.51288600E-02
   +7.98954000E-03  -6.25191000E-03  +1.82130600E-02  -1.18537500E-02  -4.48776600E-02
   +1.31863330E-01  +2.10611700E-02  -2.03076660E-01  -8.14882300E-02  +1.72286250E-01
   +6.76118680E-01  -2.43306000E-03  -2.47457400E-02  -4.44105900E-02  -1.16420460E-01
   -5.35846000E-03  +5.21495500E-02  +3.24967400E-02  +2.06537400E-02  +1.51948900E-02
   -1.72266500E-02  -1.84824300E-02  -2.45555300E-02  -4.31191000E-02  -1.47821800E-02
   +3.60505700E-02  -2.46984890E-01  -1.37836920E-01  -6.20911300E-02  +6.07117220E-01
   -1.15609100E-02  -1.44476100E-02  -3.60332800E-02  -3.24311500E-02  -1.17800080E-01
   -6.36303300E-02  +3.73235100E-02  +2.69210900E-02  -9.59476000E-03  -1.74891400E-02
   -2.57417200E-02  -2.97451800E-02  -3.32322600E-02  +5.78022000E-03  +4.24114700E-02
   -1.13416530E-01  -1.57940740E-01  -6.96992700E-02  +2.37355850E-01  +3.33012040E-01
   -1.22841400E-02  -1.63709600E-02  -1.42657500E-02  -1.32279900E-02  -1.03512790E-01
   -2.98786890E-01  +5.50522000E-02  +1.38323200E-02  -3.63457500E-02  -2.19629600E-02
   -2.75234000E-02  -3.89152100E-02  -7.60242000E-03  +1.78327300E-02  +5.75810700E-02
   -3.73592000E-03  -3.52930300E-02  -1.38532170E-01  -1.19103080E-01  +1.45884980E-01
   +6.51878450E-01  +1.55380000E-03  +1.32606000E-03  +2.78410000E-04  -2.27284000E-03
   -4.07820000E-04  +1.04153000E-03  +3.89281000E-03  -1.25920000E-04  +1.66424000E-03
   -1.57522000E-03  -4.72412000E-03  -7.63579000E-03  -1.34609500E-01  -4.53293100E-02
   -9.86542000E-03  -1.77460600E-02  -1.47898300E-02  -4.66693000E-03  +6.52320000E-04
   -2.07360000E-03  +3.73284000E-03  +4.74199700E-01  +4.56270000E-04  -2.84150000E-04
   +2.49100000E-04  -3.84500000E-04  -5.30520000E-04  +1.70170000E-04  -5.03140000E-04
   +4.09510000E-03  -2.11516000E-03  -1.09643200E-02  -8.98746000E-03  -6.96453000E-03
   -4.59627100E-02  -1.04917630E-01  -1.62626300E-02  -6.68503000E-03  -1.30714000E-03
   +1.61921000E-03  -1.36067000E-03  +4.90092000E-03  -2.04572000E-03  -2.03780000E-03
   +4.80254690E-01  +7.56290000E-04  +9.92670000E-04  +6.61370000E-04  +3.32000000E-06
   -5.97910000E-04  -1.86470000E-03  +1.77013000E-03  -3.41961000E-03  -4.38022000E-03
   -2.46763300E-02  -1.83840900E-02  -4.01212000E-03  -1.26542900E-02  -1.87756400E-02
   -9.23156700E-02  +1.08192200E-02  +1.11140700E-02  +1.06572000E-02  +4.12068000E-03
   -5.83700000E-04  -1.34045000E-03  -6.31170000E-04  +5.36180000E-04  +4.79985430E-01
   -1.19915000E-03  -9.59770000E-04  -5.16560000E-04  +6.35720000E-04  +5.45910000E-04
   +5.94050000E-04  -4.02850000E-04  +5.27410000E-04  +3.34040000E-04  -4.33800000E-04
   -1.02754000E-03  +4.95960000E-04  +2.97450000E-04  -2.40382800E-02  +1.23154000E-02
   -5.55610000E-04  -1.30565000E-03  -1.28693000E-03  -1.20217000E-03  +5.09280000E-04
   -1.03771000E-03  -7.68579400E-02  +7.54984000E-03  -4.42815000E-03  +5.83792560E-01
   -3.49090000E-04  -3.29230000E-04  -1.86570000E-04  +1.39730000E-04  +2.98750000E-04
   +4.54600000E-04  -2.69180000E-04  +6.64250000E-04  +2.92030000E-04  +3.03110000E-04
   -2.55980000E-04  +1.26484000E-03  -8.39224000E-03  -2.84762500E-02  +8.16999000E-03
   +1.74041000E-03  -4.76020000E-04  -9.33030000E-04  -6.73040000E-04  +2.66530000E-04
   -8.40900000E-04  +1.39474000E-02  -1.49095230E-01  +4.33604400E-02  +1.62735000E-02
   +4.89053920E-01  -6.49620000E-04  -5.06920000E-04  -3.50280000E-04  +2.04020000E-04
   +2.45730000E-04  +6.28170000E-04  +1.52200000E-04  +3.54920000E-04  -5.94400000E-05
   -1.48852000E-03  -1.31036000E-03  -2.80020000E-04  +3.69157000E-03  -2.55229000E-03
   +4.46616000E-03  -4.58400000E-05  -3.70440000E-04  -5.54630000E-04  -3.48070000E-04
   -1.54820000E-04  -5.95870000E-04  -6.58103000E-03  +4.00326200E-02  -9.84158800E-02
   -9.99547000E-03  +5.03098100E-02  +5.65870960E-01  -5.60080000E-04  -4.27640000E-04
   -1.94230000E-04  +3.93210000E-04  +2.58920000E-04  +1.66690000E-04  +3.92240000E-04
   -7.52880000E-04  -1.06105000E-03  -4.44754000E-03  -2.76615000E-03  +1.26070000E-04
   -1.46922000E-03  -5.77371000E-03  -2.73916100E-02  -1.55450000E-03  -6.87830000E-04
   -1.17600000E-03  +1.60240000E-04  -8.53500000E-05  -7.98290000E-04  -7.58951400E-02
   -6.05690000E-04  -1.08073000E-03  +2.68950000E-04  +1.74120000E-04  -4.43435000E-03
   +5.86593950E-01  -1.72860000E-04  -1.47780000E-04  -8.21300000E-05  -1.11700000E-05
   +1.46990000E-04  -1.32240000E-04  +1.03820000E-04  -4.46220000E-04  -8.37340000E-04
   -3.51044000E-03  -1.23701000E-03  +9.96500000E-05  -3.10943000E-03  -5.66058000E-03
   -2.18752700E-02  -1.10032000E-03  -1.01827000E-03  +3.50050000E-04  +5.04610000E-04
   -2.14780000E-04  -7.73910000E-04  -2.20996000E-03  -7.86169100E-02  -2.00768700E-02
   +1.45760000E-03  +2.28158000E-03  +3.22855800E-02  -2.07750000E-04  +5.81563280E-01
   +2.94680000E-04  +2.17400000E-04  +4.69400000E-05  -3.22470000E-04  -1.24370000E-04
   +1.95020000E-04  +5.06350000E-04  +6.37600000E-05  -1.24270000E-04  -2.50140000E-04
   +5.29140000E-04  +3.62280000E-04  -6.49889000E-03  -4.72320000E-03  -9.59407000E-03
   +8.82030000E-04  +2.87540000E-04  +6.33450000E-04  +4.07930000E-04  -1.68600000E-05
   -4.82220000E-04  -6.93362000E-03  -1.77732900E-02  -1.69624220E-01  -1.95561000E-03
   +3.92537000E-03  -2.83557700E-02  -9.65293000E-03  -2.85670200E-02  +4.68368380E-01
   +3.17710000E-04  +2.51170000E-04  +6.37200000E-05  -3.85150000E-04  -1.94370000E-04
   +2.63520000E-04  +2.50790000E-04  +4.21470000E-04  +7.47420000E-04  -1.00984000E-03
   +5.37370000E-04  -3.56330000E-04  -3.49581300E-02  +3.76193000E-03  +6.75137000E-03
   -1.16502000E-03  +9.47500000E-05  -2.04219000E-03  +1.20000000E-07  -7.95170000E-04
   +4.89950000E-04  -1.45780850E-01  +3.86314900E-02  +2.31366700E-02  -6.22087000E-03
   +8.98963000E-03  -9.12270000E-04  -3.18757000E-03  +3.57876000E-03  +1.07211000E-02
   +5.37742850E-01  -5.66410000E-04  -4.96930000E-04  -3.23450000E-04  +1.23800000E-04
   +4.88480000E-04  +6.19190000E-04  +3.37900000E-05  -2.23440000E-04  +8.01900000E-05
   -1.73623000E-03  +3.57100000E-05  -4.36130000E-04  -1.50504400E-02  +9.73080000E-03
   +7.04510000E-03  -1.63032000E-03  -1.75819000E-03  -2.10591000E-03  -5.07270000E-04
   -1.12031000E-03  +2.88620000E-04  +3.12042500E-02  -1.00660870E-01  -1.40607000E-03
   +2.83959800E-02  -1.73149700E-02  -7.91169000E-03  +7.42562000E-03  -5.07762000E-03
   -8.51169000E-03  -6.18289700E-02  +5.65372900E-01  -5.20590000E-04  -5.57500000E-04
   -1.31040000E-04  +3.09620000E-04  +3.27410000E-04  +2.01400000E-05  -4.09990000E-04
   +2.04010000E-04  +1.14920000E-04  -2.66221000E-03  -1.23506000E-03  -5.82620000E-04
   -4.98770000E-04  +3.80375000E-03  +2.41769000E-03  -5.45930000E-04  -6.20000000E-04
   -5.53020000E-04  -1.85390000E-04  -2.29930000E-04  +1.71490000E-04  +2.81207700E-02
   -6.12964000E-03  -7.93725400E-02  -1.44788500E-02  +6.68144000E-03  +5.14628000E-03
   +2.96539500E-02  -1.76223700E-02  -1.60513500E-02  -1.65689780E-01  -1.45224330E-01
   +3.29245140E-01  -3.11150000E-04  -2.23850000E-04  -8.68000000E-05  +3.58910000E-04
   +2.28060000E-04  -2.64120000E-04  -3.22850000E-04  -3.37270000E-04  +1.34330000E-04
   +6.09040000E-04  -3.86800000E-05  +4.49900000E-04  -1.15766000E-03  +1.36296000E-03
   +1.01329000E-03  -6.39300000E-04  -6.97550000E-04  -3.62950000E-04  +6.48100000E-05
   -4.02500000E-05  +2.77090000E-04  -1.65889200E-02  -7.40874000E-03  +1.46172900E-02
   -1.78456000E-03  -4.02590000E-04  +1.24498000E-03  -1.23118000E-03  -7.60210000E-04
   -1.28302000E-03  -2.09697300E-01  -1.58135200E-02  +8.72500500E-02  +5.64858000E-01
   +2.91870000E-04  +2.23290000E-04  +9.78600000E-05  -2.36740000E-04  -1.20920000E-04
   +1.07400000E-05  +1.98750000E-04  +1.66350000E-04  -7.51300000E-05  -1.69840000E-04
   +8.49100000E-05  +2.55800000E-04  +1.60150000E-03  -1.81106000E-03  -1.71512000E-03
   +5.47650000E-04  +5.86840000E-04  +3.47290000E-04  +8.44700000E-05  +2.12830000E-04
   -1.59260000E-04  +8.75371000E-03  +1.24397900E-02  -7.80945000E-03  +1.18544000E-03
   -1.79690000E-04  -7.56780000E-04  +1.98893000E-03  -1.25383000E-03  -4.58800000E-04
   -8.03471700E-02  -1.47683560E-01  +8.21409500E-02  -1.00320230E-01  +6.47830250E-01
   -9.60700000E-05  -1.12610000E-04  -2.33100000E-05  -1.78590000E-04  +5.41300000E-05
   +4.15130000E-04  +2.64500000E-04  +3.56180000E-04  +2.58990000E-04  -7.88560000E-04
   +1.47190000E-04  -8.33670000E-04  -1.83384000E-03  -4.97270000E-04  -5.41160000E-04
   +5.34700000E-04  +5.17330000E-04  +9.01000000E-05  -2.16500000E-04  -4.04450000E-04
   -2.84790000E-04  +7.54585000E-03  +1.07439000E-03  +2.12730000E-04  +4.15200000E-05
   -5.24660000E-04  -8.32870000E-04  -7.73600000E-05  +2.94100000E-04  +2.02240000E-04
   +1.15311170E-01  +5.07818700E-02  -1.50264280E-01  -1.81750240E-01  -1.95441410E-01
   +3.18740480E-01  -7.22200000E-05  -6.00700000E-05  -7.43800000E-05  -7.00000000E-07
   +5.10400000E-05  +2.81270000E-04  +2.03820000E-04  +1.05900000E-04  -1.44980000E-04
   -2.84060000E-04  +1.36400000E-04  +1.41300000E-05  -4.21900000E-04  +4.79770000E-04
   +2.95360000E-04  +2.07010000E-04  +1.97540000E-04  -1.48010000E-04  -1.00120000E-04
   -1.76700000E-04  -1.81330000E-04  +9.27870000E-04  -1.59836000E-03  +3.82615000E-03
   +1.95680000E-04  -5.18380000E-04  -7.39500000E-05  -1.48419000E-03  +7.73590000E-04
   +2.37510000E-04  -4.37976500E-02  -3.24505400E-02  +3.85642000E-02  -2.63601930E-01
   +1.23278640E-01  +4.92766400E-02  +6.19979480E-01  +1.46330000E-04  +1.63010000E-04
   +9.95400000E-05  +2.39300000E-05  -1.45530000E-04  -3.70900000E-04  -2.11130000E-04
   -1.64280000E-04  +9.33200000E-05  +4.90960000E-04  -6.88300000E-05  +2.83900000E-05
   +6.47560000E-04  -3.34510000E-04  -4.05820000E-04  -1.99010000E-04  -2.80040000E-04
   +2.39170000E-04  +1.57280000E-04  +2.94950000E-04  +2.11070000E-04  -5.73400000E-04
   -3.43000000E-06  +2.93074000E-03  +6.99300000E-04  -5.82390000E-04  -2.58900000E-04
   +1.77730000E-04  -5.63580000E-04  +1.38160000E-04  +1.31835500E-02  +5.62011300E-02
   -2.82558300E-02  +6.75167400E-02  -1.64048880E-01  +1.44408700E-02  -7.82862800E-02
   +6.26884840E-01  +4.49800000E-05  +4.37200000E-05  +5.02700000E-05  -1.97400000E-05
   -7.18200000E-05  -6.55800000E-05  -4.53900000E-05  +1.74500000E-05  +5.46400000E-05
   +2.28970000E-04  -1.11930000E-04  -2.84160000E-04  +1.06721000E-03  -6.19190000E-04
   -6.21640000E-04  +1.68940000E-04  +8.52800000E-05  +2.97340000E-04  +3.78000000E-06
   +1.13310000E-04  -3.43600000E-05  +3.44833000E-03  +4.22235000E-03  +3.26291000E-03
   -5.72300000E-04  +3.52430000E-04  +3.39300000E-05  -1.16046000E-03  +6.12050000E-04
   +3.20060000E-04  +1.94198300E-02  -8.31040000E-03  -1.89301000E-03  +7.65892600E-02
   -1.45448800E-02  -9.15399000E-02  -2.21310610E-01  -1.94919270E-01  +3.36361640E-01
   +9.26970000E-04  +7.17300000E-04  +3.16930000E-04  -7.60820000E-04  -5.58970000E-04
   -2.79620000E-04  +3.34740000E-04  -4.26000000E-06  -3.46270000E-04  -8.04700000E-05
   +1.30750000E-04  +2.41720000E-04  -7.70700000E-05  -6.13210000E-04  -1.91300000E-04
   +7.42400000E-05  +2.18160000E-04  +1.96960000E-04  +1.78840000E-04  +1.90660000E-04
   +1.65780000E-04  -2.70032000E-03  +3.97400000E-04  +3.27610000E-04  +3.86700000E-04
   +3.08130000E-04  -2.15250000E-04  +7.87370000E-04  -2.78770000E-04  +5.04000000E-05
   -2.86327000E-03  -2.66006800E-02  +1.39127500E-02  +1.88136000E-02  +3.05754900E-02
   -2.36747700E-02  -1.25771160E-01  +6.64773100E-02  +1.44525000E-03  +6.02059220E-01
   -4.48980000E-04  -3.83000000E-04  -2.07250000E-04  +2.16920000E-04  +3.26630000E-04
   +5.16950000E-04  +1.72220000E-04  +1.65590000E-04  +7.53000000E-06  -3.83330000E-04
   +1.13150000E-04  -1.97270000E-04  -6.52020000E-04  +8.33100000E-04  +5.31430000E-04
   +2.93050000E-04  +2.66490000E-04  -2.78410000E-04  -2.45110000E-04  -4.37390000E-04
   -3.08130000E-04  -4.33450000E-04  -1.42930000E-03  +9.07280000E-04  -2.50150000E-04
   -1.51100000E-05  +3.05700000E-05  -9.36690000E-04  +8.46370000E-04  -1.40960000E-04
   -2.16936800E-02  -4.64959500E-02  +3.36690900E-02  +7.27524600E-02  -2.63931200E-02
   -2.51953300E-02  +3.09145000E-03  -3.07027260E-01  +1.13872070E-01  -1.19968180E-01
   +6.80745160E-01  -2.86630000E-04  -1.96800000E-04  -9.65600000E-05  +3.32480000E-04
   +1.92320000E-04  -1.13140000E-04  -2.49680000E-04  -1.50350000E-04  +1.36740000E-04
   +2.54700000E-04  -9.46400000E-05  +1.46200000E-04  +2.68940000E-04  +1.07580000E-04
   -8.78900000E-05  -2.97280000E-04  -2.42150000E-04  -1.03200000E-05  +9.93600000E-05
   +1.19500000E-04  +7.82800000E-05  +4.84630000E-04  -2.08650000E-04  -2.01483000E-03
   -7.04900000E-05  -5.06600000E-05  +2.30050000E-04  +3.59060000E-04  -4.63420000E-04
   +9.87900000E-05  +1.43668100E-02  +3.75837700E-02  -2.04539900E-02  -4.42742700E-02
   -2.50152000E-03  +2.71453200E-02  +3.25919300E-02  +7.96685700E-02  -1.16726980E-01
   -1.79587160E-01  -1.90552290E-01  +3.27877740E-01  +6.78000000E-05  +7.32400000E-05
   +7.27400000E-05  +5.18400000E-05  -1.03780000E-04  -4.93300000E-04  -4.08970000E-04
   -3.38400000E-04  +1.03740000E-04  +5.55570000E-04  -3.90300000E-04  +1.69720000E-04
   +7.06440000E-04  +9.61900000E-05  -9.36300000E-05  -6.50970000E-04  -5.80280000E-04
   +1.75950000E-04  +2.31660000E-04  +3.39610000E-04  +3.35210000E-04  +3.01656000E-03
   -6.04220000E-04  -1.28520000E-04  +4.08410000E-04  -4.25390000E-04  +3.23180000E-04
   -1.12680000E-04  -1.60540000E-04  +1.95730000E-04  +1.06059100E-02  +7.04898900E-02
   -4.24481300E-02  -5.90725500E-02  -2.46591000E-03  +3.39082900E-02  +4.80423700E-02
   -5.76293900E-02  +2.82795000E-03  -1.86437300E-01  -7.71889000E-03  +6.43100100E-02
   +6.24256070E-01  -7.73590000E-04  -6.50480000E-04  -3.10920000E-04  +6.36040000E-04
   +5.13150000E-04  +4.78130000E-04  -8.53100000E-05  +5.71100000E-05  +2.41720000E-04
   -3.20700000E-05  +1.63290000E-04  -4.78600000E-05  -7.31730000E-04  +2.82970000E-04
   -5.49300000E-05  +2.20900000E-04  +2.37230000E-04  -3.05980000E-04  -1.31960000E-04
   -1.59320000E-04  -3.13610000E-04  -5.31820000E-04  -3.09032000E-03  +3.76573000E-03
   +1.08136000E-03  -2.49890000E-04  -5.85910000E-04  -6.27640000E-04  +3.19890000E-04
   +5.56500000E-04  +3.05368900E-02  -1.75783900E-02  -4.50201000E-03  -4.03494000E-03
   +4.87915000E-03  +8.76740000E-04  -1.59604500E-02  -2.51742200E-02  +2.16651200E-02
   -8.93572800E-02  -1.32114960E-01  +7.18081000E-02  -1.18037010E-01  +6.29493730E-01
   +3.19010000E-04  +2.36560000E-04  +1.01750000E-04  -3.33790000E-04  -2.00170000E-04
   +6.17800000E-05  +2.76490000E-04  +1.90690000E-04  -2.32990000E-04  -2.58260000E-04
   +4.50000000E-06  -2.73900000E-05  +4.33880000E-04  +1.62550000E-04  +3.72700000E-05
   +2.31390000E-04  +1.68320000E-04  +2.89200000E-05  -8.50400000E-05  -1.02800000E-04
   -3.68900000E-05  +5.18350000E-04  +2.73826000E-03  +1.67762000E-03  -5.29290000E-04
   +3.40420000E-04  +2.52830000E-04  -9.30000000E-05  +3.99090000E-04  -1.09850000E-04
   -2.06657100E-02  -3.07640600E-02  +2.44626600E-02  +3.45015900E-02  -7.20110000E-04
   -1.65060300E-02  -1.65591600E-02  +4.27738700E-02  -9.97217000E-03  +1.02979120E-01
   +3.33350000E-02  -1.41274440E-01  -1.93876530E-01  -1.72670310E-01  +3.24702710E-01
   -6.59720000E-04  -6.45720000E-04  -2.52990000E-04  +2.02520000E-04  +4.81910000E-04
   +9.11680000E-04  +6.09300000E-04  +5.16190000E-04  +4.73000000E-05  -1.61116000E-03
   +3.99160000E-04  -8.28070000E-04  -8.68640000E-04  +2.96456000E-03  +3.95290000E-04
   +1.08443000E-03  +6.46530000E-04  -6.75700000E-04  -6.14760000E-04  -1.00758000E-03
   -5.10700000E-04  -5.34214000E-03  +2.50079300E-02  -9.27765000E-03  -5.19798000E-03
   +1.74564000E-03  +2.50770000E-03  -8.56940000E-04  +1.34701000E-03  -1.65747000E-03
   -9.90923900E-02  +3.14483400E-02  +1.36464800E-02  +3.54497100E-02  -1.13452700E-02
   -7.66184000E-03  -2.45127200E-02  +2.47154400E-02  +1.13826000E-03  -4.80529300E-02
   -2.84115900E-02  +3.71639200E-02  -2.72350170E-01  +1.40060280E-01  +4.58862400E-02
   +4.80044480E-01  -4.81880000E-04  -4.38840000E-04  -8.20100000E-05  +1.84530000E-04
   +2.14650000E-04  +2.76930000E-04  +2.58000000E-06  +2.05400000E-04  +3.54360000E-04
   -2.74090000E-04  -1.17420000E-04  -9.96540000E-04  -3.29220000E-04  +5.73150000E-04
   +6.76890000E-04  +3.07500000E-04  -2.38400000E-04  -6.22100000E-05  -4.35750000E-04
   -6.94530000E-04  -1.11800000E-05  +1.49768800E-02  -1.73602100E-02  +2.21200000E-04
   +4.59610000E-04  +5.05480000E-04  -2.00560000E-04  -3.93440000E-04  +1.44150000E-04
   +6.08340000E-04  +7.50053100E-02  -2.75279910E-01  +6.07192700E-02  -6.66178600E-02
   -2.85410200E-02  +5.01216400E-02  +3.61473300E-02  -4.67740100E-02  +3.24341000E-03
   +2.07658300E-02  +5.67601100E-02  -3.47016800E-02  +7.99215800E-02  -1.51950820E-01
   +6.62991000E-03  -1.79736770E-01  +5.50388760E-01  +4.50210000E-04  +4.34500000E-04
   +1.06450000E-04  -2.39440000E-04  -2.44640000E-04  -1.00000000E-08  +2.00610000E-04
   +1.93650000E-04  -9.78700000E-05  -5.59320000E-04  +3.84170000E-04  -1.29790000E-04
   -8.12760000E-04  -1.04706000E-03  -1.18370000E-04  -2.27000000E-05  +4.63320000E-04
   -3.81100000E-05  +2.01970000E-04  +4.45260000E-04  -5.20000000E-07  -3.81055000E-03
   -5.67531000E-03  +5.29078000E-03  +2.62580000E-03  -3.63610000E-04  -8.77190000E-04
   +1.89087000E-03  -1.72344000E-03  +1.29610000E-04  -9.87544000E-03  +8.22430300E-02
   -8.74272500E-02  +1.62631600E-02  +2.31358100E-02  -9.47573000E-03  -2.94037000E-03
   +8.27984000E-03  -2.51190000E-03  +1.70041400E-02  -1.06414600E-02  -9.74230000E-04
   +7.27127800E-02  -2.48389200E-02  -7.97335500E-02  -1.05035540E-01  -1.10471750E-01
   +2.02532930E-01  -9.96010000E-04  -7.74360000E-04  -3.78750000E-04  +7.74060000E-04
   +6.24920000E-04  +4.35980000E-04  -2.63290000E-04  +2.32400000E-05  +2.73490000E-04
   -1.24960000E-04  -5.60600000E-05  -1.42890000E-04  -1.72880000E-04  +8.94010000E-04
   +3.13800000E-04  -9.03000000E-06  -4.89100000E-05  -3.50640000E-04  -1.94760000E-04
   -2.85360000E-04  -2.79060000E-04  +1.82449000E-03  -7.75490000E-04  +3.22830000E-04
   -4.79640000E-04  -2.30140000E-04  +3.01160000E-04  -1.32217000E-03  +6.20670000E-04
   -2.05890000E-04  -2.70310000E-03  +6.10269000E-03  -2.74966000E-03  -8.42430000E-04
   -2.99087000E-03  +4.09628000E-03  -8.01356000E-03  +1.74785400E-02  -8.10510000E-04
   -2.57280600E-01  +7.54320100E-02  +7.63911200E-02  -5.15926800E-02  +2.92766300E-02
   +1.84060000E-02  +7.68509000E-03  -4.95175000E-03  +1.33661000E-03  +3.48240670E-01
   +6.44960000E-04  +5.32850000E-04  +2.47560000E-04  -4.66380000E-04  -4.15820000E-04
   -3.10280000E-04  +1.40560000E-04  -4.13000000E-06  -1.75900000E-04  +1.00240000E-04
   +9.20600000E-05  +1.26500000E-04  +1.36730000E-04  -7.42000000E-04  -3.20210000E-04
   +1.69400000E-05  +4.09400000E-05  +2.45850000E-04  +1.52270000E-04  +2.54210000E-04
   +1.85490000E-04  -9.78150000E-04  +8.20680000E-04  -2.42300000E-04  +3.85660000E-04
   +1.00150000E-04  -2.15560000E-04  +8.96690000E-04  -5.13670000E-04  +1.89140000E-04
   +3.20353000E-03  -6.36150000E-04  -2.33210000E-03  -4.91499000E-03  -9.80070000E-04
   +4.98241000E-03  +4.93403300E-02  -2.64517400E-02  -1.01310900E-02  +1.19407780E-01
   -1.46353210E-01  -1.15478100E-02  +2.59060000E-04  -2.61970000E-04  +4.92265000E-03
   -1.85345000E-03  -2.40022000E-03  +4.98570000E-03  -1.22619040E-01  +5.88820850E-01
   +2.28270000E-04  +1.77370000E-04  +1.00160000E-04  -1.91880000E-04  -1.44560000E-04
   -8.20200000E-05  +7.55600000E-05  +1.54400000E-05  -5.46400000E-05  +2.59900000E-05
   +2.48100000E-05  -4.68400000E-05  -7.00000000E-06  -2.42820000E-04  -3.19200000E-05
   +6.38700000E-05  +1.17800000E-05  +9.17400000E-05  +4.88000000E-06  +2.23000000E-05
   +5.69900000E-05  -2.15860000E-04  +2.04080000E-04  +2.74370000E-04  +1.42150000E-04
   +6.75200000E-05  -7.22800000E-05  +1.24370000E-04  -8.21000000E-06  +5.92000000E-06
   -1.38517000E-03  -3.18184000E-03  +1.20400000E-04  +4.68749000E-03  +4.02545000E-03
   -4.70030000E-04  -1.60280400E-02  +6.59544000E-03  +1.15831800E-02  +5.55241700E-02
   +1.06096600E-02  -7.37262800E-02  +3.19007000E-02  -9.14080000E-03  -1.61233000E-03
   +8.79200000E-04  +5.35439000E-03  +2.85319000E-03  -1.07825920E-01  -1.99614810E-01
   +1.76807090E-01  -4.26781200E-02  +1.40039700E-02  +8.59402400E-02  -7.69520000E-04
   -1.57318000E-02  -3.89972000E-02  +1.28118000E-03  +2.35610000E-04  -2.49947000E-03
   -6.35780000E-04  -5.07100000E-05  -2.39050000E-04  -1.00590000E-04  +1.39610000E-04
   +6.54610000E-04  +1.50885000E-03  -4.94540000E-04  -9.19390000E-04  -4.61474000E-03
   -4.16090000E-03  -1.82240000E-04  -1.58620000E-04  -1.32800000E-05  +1.04760000E-04
   +3.53600000E-05  +1.56000000E-06  -1.31700000E-05  +6.74900000E-05  +3.36500000E-05
   -1.12900000E-05  -3.34600000E-05  -1.98600000E-05  +1.64500000E-05  +2.17400000E-05
   -9.74000000E-06  +1.60200000E-05  -2.74000000E-06  -1.25000000E-06  +8.46000000E-06
   -1.25250000E-04  +4.01300000E-05  +4.82100000E-05  -3.38000000E-06  +7.25100000E-05
   -4.48300000E-05  +2.34200000E-05  +3.69500000E-05  +1.37200000E-05  +1.27570000E-04
   -6.41100000E-05  -2.45800000E-05  +4.71798900E-02  -4.97093000E-03  -7.27563000E-02
   -1.52161920E-01  +1.82101000E-03  -1.38005900E-02  -2.80875500E-02  +2.61818000E-03
   +1.04531000E-03  +8.41410000E-04  +4.20300000E-05  -7.53790000E-04  -3.73340000E-04
   -7.93000000E-05  +2.35470000E-04  +5.56790000E-04  +1.68800000E-04  +1.20902000E-03
   -1.48135000E-03  -4.64738000E-03  -6.69550000E-04  +1.50000000E-06  -1.45750000E-04
   -6.89400000E-05  +2.97600000E-05  +4.49300000E-05  +2.42000000E-06  +1.02400000E-05
   +6.38100000E-05  +1.50200000E-05  -2.02700000E-05  -4.81600000E-05  +4.81700000E-05
   +8.87300000E-05  +4.75600000E-05  -4.11400000E-05  +2.10900000E-05  -4.24000000E-06
   -1.66000000E-05  +3.44000000E-06  -1.43320000E-04  +6.08100000E-05  +4.07900000E-05
   -3.56000000E-06  +1.48340000E-04  -5.71400000E-05  +1.18850000E-04  +1.01610000E-04
   -9.38800000E-05  +1.37530000E-04  -1.03560000E-04  -3.15600000E-05  +5.77535000E-03
   +8.57612100E-02  +4.26185400E-02  -1.77929390E-01  -4.70851820E-01  +1.03527000E-03
   -4.21971000E-03  -1.40224600E-02  +3.10282000E-03  +4.19061000E-03  +4.50813000E-03
   +2.69500000E-05  -1.54920000E-04  -1.13051000E-03  +1.67530000E-04  +1.12450000E-04
   +4.87370000E-04  +6.45240000E-04  -5.94970000E-04  -5.76900000E-04  -1.49759000E-03
   -7.87500000E-04  +2.37601000E-03  -1.91590000E-04  -1.17600000E-05  -1.57200000E-04
   +1.48430000E-04  +5.83800000E-05  +9.06600000E-05  +5.58400000E-05  +1.07700000E-05
   -2.52800000E-05  -1.50300000E-05  +5.18100000E-05  +3.47400000E-05  +1.85000000E-05
   -1.43800000E-05  +4.00000000E-06  +1.32400000E-05  -1.86500000E-05  -1.35300000E-05
   -9.91200000E-05  +4.76300000E-05  +4.10400000E-05  -9.32000000E-06  +7.76200000E-05
   -3.75800000E-05  +1.83500000E-05  -2.72000000E-06  +1.02900000E-05  +1.15880000E-04
   -6.83000000E-05  -3.56900000E-05  -4.56462200E-02  +1.79550200E-01  +4.79445340E-01
   +1.48363000E-03  +3.02528000E-03  -3.95040000E-04  +4.37884000E-03  +9.13816000E-03
   +2.09798000E-02  -5.42045700E-02  -1.13123800E-02  +2.62998000E-03  +3.95716000E-03
   -9.31042000E-03  -2.38190700E-02  -1.75724000E-03  -5.48176000E-03  +1.53000000E-04
   -1.54345000E-03  -3.92320000E-04  +1.51000000E-05  -2.12797000E-03  -2.83639000E-03
   +3.98472000E-03  +5.72010000E-04  -2.91220000E-04  -1.04818000E-03  -1.84000000E-05
   +9.48200000E-05  -6.14400000E-05  -3.28610000E-04  -1.78400000E-04  +5.50900000E-05
   +1.35770000E-04  -1.30300000E-05  -3.54000000E-05  -1.70300000E-05  +2.57000000E-05
   +3.58000000E-06  -9.53000000E-06  +2.64200000E-05  +2.11100000E-05  +5.23600000E-05
   -2.93300000E-05  -1.90100000E-05  -1.50100000E-05  -5.38500000E-05  +2.50500000E-05
   -3.87600000E-05  -4.24600000E-05  +5.38700000E-05  -6.79900000E-05  +6.03800000E-05
   +2.89300000E-05  -7.48710000E-04  -9.97510000E-04  -4.66750000E-04  +5.05419800E-02
   +2.87212000E-03  -1.10690000E-03  +2.42007000E-03  -2.46324000E-03  +4.50758000E-03
   +4.38881000E-03  -1.14112000E-02  -8.60005700E-02  -1.07522920E-01  +1.52265000E-03
   -3.93414000E-03  -1.73413500E-02  -5.46815000E-03  +3.33492000E-03  -1.77902000E-03
   -2.47040000E-04  -7.81360000E-04  +5.52270000E-04  -2.60358000E-03  +3.80082000E-03
   -8.13900000E-05  +9.95000000E-05  +2.47950000E-04  -8.21740000E-04  -3.93300000E-05
   +1.21000000E-06  -2.04900000E-05  -2.69170000E-04  -2.42440000E-04  +2.25000000E-06
   +2.03360000E-04  -5.13600000E-05  -5.85100000E-05  -4.36700000E-05  +2.16900000E-05
   +5.07500000E-05  +2.21000000E-06  -1.25200000E-05  +1.45100000E-05  +6.21100000E-05
   -1.64000000E-06  -3.87600000E-05  -1.98000000E-05  -1.63000000E-05  +9.85000000E-06
   +2.04700000E-05  +9.82000000E-06  +2.68200000E-05  -6.50100000E-05  +3.03600000E-05
   +2.18000000E-05  +5.61500000E-05  +2.63360000E-04  -7.74550000E-04  +1.54548600E-02
   +8.31208600E-02  -1.03783000E-03  +1.97492000E-03  +2.19785000E-03  -5.81013000E-03
   -1.17603500E-02  -1.52465300E-02  +2.29007000E-03  -1.07454260E-01  -2.88670710E-01
   +1.49758000E-03  -2.10706000E-03  -4.51080000E-03  -4.39240000E-04  -2.31032000E-03
   +2.71816000E-03  +3.62030000E-04  +7.67670000E-04  +4.54510000E-04  +4.53648000E-03
   +2.02740000E-04  -5.46140000E-04  +4.54560000E-04  -4.40700000E-05  -3.11240000E-04
   -6.97600000E-05  +1.94500000E-05  -5.81100000E-05  -1.66190000E-04  -7.82300000E-05
   +5.71600000E-05  +4.26800000E-05  -4.64600000E-05  -4.26300000E-05  -1.70100000E-05
   +3.77200000E-05  -3.55400000E-05  -8.21000000E-06  +2.82300000E-05  +5.54000000E-06
   +9.57200000E-05  -5.40800000E-05  -2.24800000E-05  -8.00000000E-07  -1.09870000E-04
   +4.80700000E-05  -7.90600000E-05  -7.36200000E-05  +6.03400000E-05  -1.06150000E-04
   +8.30300000E-05  +2.84800000E-05  +1.97724000E-03  +7.35180000E-04  -5.10120000E-04
   -2.18312000E-03  +1.18950080E-01  +3.05288710E-01  -1.31846000E-03  -3.92210000E-04
   +6.94430000E-04  +4.02100000E-05  -5.15644000E-03  -1.38223000E-03  -1.34274500E-02
   -3.01565000E-03  +1.72230500E-02  -2.08403000E-01  -3.94848800E-02  +1.38654750E-01
   +4.05729000E-03  -2.49310000E-04  -6.64420000E-04  +2.45919000E-03  -2.04188000E-03
   +2.19200000E-04  -1.95060000E-04  +2.17850000E-04  -9.03820000E-04  -9.27690000E-04
   +8.42840000E-04  -7.85260000E-04  +3.23600000E-05  -6.19300000E-05  +1.51650000E-04
   -5.44800000E-05  +1.41830000E-04  -1.71400000E-05  -7.87810000E-04  -4.34470000E-04
   -1.02048000E-03  -6.10300000E-05  -7.53300000E-05  -1.37650000E-04  -1.71000000E-04
   +1.41220000E-04  +6.03800000E-05  -2.88940000E-04  -2.99200000E-05  +2.08230000E-04
   +2.58300000E-04  +2.05710000E-04  -1.53840000E-04  -2.28710000E-04  -8.20300000E-05
   -3.95610000E-04  +1.69590000E-04  -1.07790000E-04  -5.56700000E-05  +9.19800000E-05
   +1.45070000E-04  +1.95540000E-04  -2.87990000E-04  +1.93389000E-03  -1.04789000E-03
   +2.18733450E-01  -9.43560000E-04  -3.75330000E-04  +6.19670000E-04  -5.06292000E-03
   +3.35817000E-03  -3.80528000E-03  -1.41512000E-02  +1.02118000E-03  +1.25565800E-02
   -3.87038900E-02  -5.31932200E-02  +2.09092400E-02  +9.86438000E-03  +6.84866000E-03
   -7.72244000E-03  -2.55395000E-03  +3.22305000E-03  -4.10973000E-03  +2.67280000E-04
   -1.06345000E-03  -9.37200000E-05  +1.39093000E-03  -1.92859000E-03  +9.25800000E-04
   -1.33980000E-04  -2.77780000E-04  -5.04380000E-04  +2.15570000E-04  +3.35700000E-05
   +1.05690000E-04  -3.15850000E-04  +2.29530000E-04  -2.29550000E-04  +1.16770000E-04
   -1.18480000E-04  -1.93660000E-04  -1.63350000E-04  +1.91790000E-04  +4.72400000E-05
   -1.53620000E-04  -1.89350000E-04  +1.67870000E-04  +3.85840000E-04  +2.14700000E-05
   -1.91220000E-04  -3.06340000E-04  +5.65200000E-05  -1.78000000E-04  +7.69700000E-05
   -7.58500000E-05  -3.81800000E-05  +8.01600000E-05  +7.84800000E-05  +1.40450000E-04
   +2.21713000E-03  -2.63318000E-03  +1.38604000E-03  +4.72705700E-02  +4.59307100E-02
   -2.94480000E-04  -1.35100000E-05  +3.39620000E-04  -9.80160000E-04  -3.44988000E-03
   +1.51078000E-03  -7.88100000E-03  -2.52365000E-03  +8.94557000E-03  +1.37898550E-01
   +2.17771900E-02  -1.76137000E-01  +2.26268800E-02  +5.71564000E-03  -1.31551000E-02
   -1.28400000E-05  -4.61679000E-03  -4.25345000E-03  -1.09222000E-03  -2.36520000E-04
   -3.24870000E-04  +6.32880000E-04  +1.66438000E-03  -1.33260000E-04  -6.22100000E-05
   -8.59700000E-05  -2.25840000E-04  -1.81850000E-04  +1.03700000E-05  +2.66500000E-05
   -5.29760000E-04  -4.78670000E-04  +3.50000000E-06  -2.92960000E-04  +3.97000000E-06
   +3.31290000E-04  -8.37200000E-05  -7.48300000E-05  +5.56200000E-05  -4.32940000E-04
   +7.17700000E-05  +8.49700000E-05  +6.77300000E-05  +2.45890000E-04  -1.39730000E-04
   +1.75550000E-04  +7.41810000E-04  -2.21190000E-04  +3.89160000E-04  -2.50030000E-04
   -7.21300000E-05  -3.64000000E-06  +2.21600000E-05  +2.33500000E-05  -6.81680000E-04
   +1.67772000E-03  +2.20550000E-04  -1.50381790E-01  -2.03172300E-02  +1.83452940E-01
   +1.17720000E-04  -4.56730000E-04  -1.21679000E-03  -1.36891000E-03  -5.50820000E-03
   +3.27140000E-04  -1.31350000E-03  -1.69920000E-04  -7.60800000E-05  -2.16347000E-03
   -3.33153000E-03  +4.42191000E-03  +6.06068000E-03  +9.49961000E-03  +2.04933600E-02
   -5.42817500E-02  -7.92316000E-03  +2.81291000E-03  +3.40078000E-03  -1.01269800E-02
   -2.33894400E-02  +5.07600000E-05  +1.98131000E-03  -5.66360000E-04  +3.09640000E-04
   +4.46800000E-05  -9.24400000E-05  -1.09093000E-03  -6.76460000E-04  +3.94830000E-04
   -1.84020000E-04  -4.01300000E-05  -1.79130000E-04  +4.41000000E-06  -1.39700000E-05
   -7.34200000E-05  +2.54000000E-05  -4.28000000E-06  +6.77000000E-06  -7.16400000E-05
   +2.42500000E-05  +4.73900000E-05  +4.98000000E-06  +8.84000000E-05  -5.28600000E-05
   -3.56000000E-05  -1.07870000E-04  +3.13100000E-05  +9.26800000E-05  -5.35300000E-05
   -3.48200000E-05  -3.16280000E-04  -1.36910000E-04  -1.76600000E-04  -1.08390000E-04
   +3.13420000E-04  -1.32200000E-04  +1.75980000E-04  +5.35160000E-04  +1.21266000E-03
   +5.27832300E-02  -2.18900000E-05  -3.83900000E-04  -9.70820000E-04  -5.55585000E-03
   +3.87002000E-03  -2.03796000E-03  -1.24100000E-04  -8.82580000E-04  +6.57760000E-04
   -3.21746000E-03  +4.49794000E-03  -5.61380000E-04  +5.22450000E-04  +6.48477000E-03
   +4.47604000E-03  -7.90678000E-03  -8.69119200E-02  -1.04771000E-01  +3.83390000E-04
   -3.05152000E-03  -1.75215400E-02  +1.58323000E-03  -2.52424000E-03  +7.62600000E-04
   -5.79090000E-04  -2.86340000E-04  -7.24900000E-05  -1.59763000E-03  -7.12700000E-05
   +4.89200000E-05  +2.40320000E-04  +4.50840000E-04  -8.42000000E-06  +1.14230000E-04
   -1.58940000E-04  +2.40100000E-05  +2.20500000E-05  -4.03200000E-05  -9.85000000E-06
   -5.04200000E-05  +7.70800000E-05  -3.84200000E-05  +1.29000000E-06  -5.25800000E-05
   +5.62800000E-05  +2.66740000E-04  +3.01960000E-04  -2.91010000E-04  +4.44500000E-05
   -6.21400000E-05  +9.45000000E-06  -1.05550000E-04  -2.62370000E-04  -2.50700000E-05
   +3.00360000E-04  -4.82620000E-04  +1.64120000E-04  -7.13400000E-05  +1.60820000E-04
   +3.44830000E-04  +1.48100400E-02  +8.38454000E-02  -1.82530000E-04  -3.57510000E-04
   -5.63160000E-04  +1.86370000E-04  -2.04259000E-03  +2.68887000E-03  +4.66400000E-05
   +6.95330000E-04  +5.35710000E-04  +4.55029000E-03  -2.45830000E-04  -5.91310000E-04
   -1.82664000E-03  -8.66852000E-03  -1.41720300E-02  +3.38660000E-03  -1.05144540E-01
   -2.98950060E-01  +1.85428000E-03  -2.39511000E-03  -4.42562000E-03  -1.67621000E-03
   +3.63000000E-05  -1.27887000E-03  +4.36110000E-04  +1.07680000E-04  +8.18300000E-05
   -1.26562000E-03  -1.28726000E-03  +1.18000000E-06  -9.90100000E-05  +1.74500000E-05
   +6.70000000E-05  -1.82000000E-06  +1.69000000E-05  +3.50900000E-05  +3.34000000E-06
   +6.79000000E-06  +6.10000000E-07  +6.12000000E-06  +6.90000000E-06  -1.71800000E-05
   -3.74200000E-05  -1.94000000E-05  +1.56500000E-05  +6.65000000E-05  +5.15700000E-05
   +8.21000000E-06  -1.80600000E-05  +1.59600000E-05  +1.31000000E-05  -8.44400000E-05
   +3.46400000E-05  -3.16000000E-06  -1.68870000E-04  +1.30720000E-04  -1.56710000E-04
   -1.55890000E-04  -4.79530000E-04  -8.31930000E-04  -2.16454000E-03  +1.18028290E-01
   +3.16289160E-01  -1.67360000E-04  +1.83066000E-03  -5.47020000E-04  +3.30701000E-03
   -1.94220000E-03  -1.70555000E-03  +2.17729000E-03  -1.99576000E-03  +2.46970000E-04
   -1.08710000E-04  +2.41720000E-04  -8.48260000E-04  -4.26660000E-04  -5.21296000E-03
   -1.39658000E-03  -1.27050400E-02  -2.32428000E-03  +1.64763800E-02  -2.09764190E-01
   -4.65395400E-02  +1.41348410E-01  -1.93800000E-04  +1.08220000E-04  +9.11850000E-04
   -1.86000000E-04  -4.30900000E-05  -1.07200000E-04  -2.90400000E-05  +5.79200000E-05
   +7.98100000E-05  +7.48500000E-05  -2.09720000E-04  -1.05940000E-04  -9.45500000E-05
   +9.44800000E-05  +1.85100000E-05  +5.82000000E-06  -3.10000000E-07  +1.30400000E-05
   +7.52000000E-05  -3.21400000E-05  -1.58600000E-05  -1.71400000E-05  -1.23700000E-05
   +7.13000000E-06  -1.45540000E-04  -1.74670000E-04  +1.74860000E-04  -6.15500000E-05
   +5.25400000E-05  +4.56000000E-06  -1.11900000E-04  +2.49350000E-04  -6.46200000E-05
   +1.63350000E-04  +6.94100000E-05  -1.76280000E-04  -1.92470000E-04  +2.85960000E-04
   -4.01900000E-05  -4.03160000E-04  +2.03521000E-03  -1.05652000E-03  +2.18662050E-01
   +1.79056000E-03  -1.73048000E-03  +1.85541000E-03  +9.05687000E-03  +7.21990000E-03
   -8.72146000E-03  -2.17830000E-03  +2.67324000E-03  -3.89535000E-03  +1.06990000E-04
   -1.15616000E-03  -3.38650000E-04  -4.84372000E-03  +2.80920000E-03  -3.18235000E-03
   -1.25495600E-02  +2.64130000E-04  +1.29393200E-02  -4.72577800E-02  -5.27091100E-02
   +2.64364600E-02  -4.79100000E-04  +3.76970000E-04  +4.57530000E-04  -6.09700000E-05
   +6.53200000E-05  -2.10500000E-05  +5.24600000E-05  +4.42000000E-06  +8.91500000E-05
   -2.29290000E-04  -2.36310000E-04  -7.52700000E-05  -1.36900000E-05  +3.10000000E-05
   -1.29900000E-05  -2.65800000E-05  +3.87000000E-05  +2.48000000E-05  +3.50300000E-05
   -4.01600000E-05  -2.08000000E-06  +3.53000000E-06  -3.25500000E-05  +1.07600000E-05
   +1.82000000E-06  +4.12600000E-05  -4.81800000E-05  -6.19200000E-05  +3.76200000E-05
   +1.82000000E-05  +2.03340000E-04  -3.06930000E-04  +3.28580000E-04  +5.78370000E-04
   +8.46700000E-05  -4.34260000E-04  +2.51790000E-04  -4.33290000E-04  +2.52180000E-04
   +2.21889000E-03  -2.61245000E-03  +1.32047000E-03  +5.34541800E-02  +4.56457600E-02
   -8.23990000E-04  +1.64958000E-03  +1.56746000E-03  +2.47286000E-02  +7.37985000E-03
   -1.28747900E-02  -2.90230000E-04  -4.19264000E-03  -3.96523000E-03  -1.22223000E-03
   -5.15980000E-04  -5.96960000E-04  -1.13282000E-03  -3.02344000E-03  +1.55756000E-03
   -8.30463000E-03  -2.04085000E-03  +9.61841000E-03  +1.40094600E-01  +2.54976500E-02
   -1.77276290E-01  -2.96970000E-04  -1.21720000E-04  +3.94540000E-04  -2.61500000E-05
   -2.15100000E-05  -4.04000000E-05  +3.14400000E-05  +6.72300000E-05  +1.36500000E-05
   +3.10800000E-05  -3.93200000E-05  -1.87300000E-05  -1.68300000E-05  +1.26400000E-05
   +2.34000000E-05  +6.18000000E-06  -5.92000000E-06  +6.90000000E-06  -1.55000000E-05
   +1.01200000E-05  +1.09000000E-06  -9.57000000E-06  +2.04100000E-05  -7.62000000E-06
   -1.10400000E-05  -2.40700000E-05  +2.79300000E-05  +1.97500000E-05  -8.49000000E-06
   -4.21000000E-06  -1.49570000E-04  +2.80650000E-04  +3.42130000E-04  +1.05096000E-03
   +2.89450000E-04  -8.58990000E-04  -5.73800000E-05  +2.34900000E-04  -5.92000000E-05
   -5.75610000E-04  +1.63557000E-03  +3.16160000E-04  -1.53057240E-01  -2.70232200E-02
   +1.81905860E-01  +2.29800000E-05  -8.60000000E-06  +2.49500000E-05  +6.07200000E-05
   -3.37000000E-06  -2.11150000E-04  -2.52060000E-04  -3.60000000E-05  -1.44000000E-05
   +3.21110000E-04  +1.94900000E-04  +3.29260000E-04  +8.18930000E-04  -1.24398000E-03
   -5.23530000E-04  +1.73680000E-04  +3.82800000E-05  +1.81480000E-04  +1.32920000E-04
   +1.37340000E-04  +2.57900000E-05  -4.29213000E-03  +6.71030000E-04  +1.43627000E-03
   -2.58843710E-01  +9.28032200E-02  +6.36831100E-02  -1.06370000E-04  -3.25650000E-04
   +4.25270000E-04  +9.33760000E-04  +1.24210000E-04  -4.38990000E-04  -1.60770000E-04
   -1.56630000E-04  +2.92920000E-04  +1.37520000E-04  +1.93520000E-04  -1.30610000E-04
   +1.59340000E-04  -3.64100000E-05  -4.95700000E-05  -2.39200000E-05  -7.81600000E-05
   +5.15700000E-05  -2.58560000E-04  -6.70300000E-05  +3.04750000E-04  -1.93690000E-04
   +1.62810000E-04  +1.07200000E-05  -8.35000000E-06  +5.33000000E-06  -1.87000000E-06
   -5.44000000E-06  +1.21900000E-05  +2.09000000E-06  +2.67700000E-05  -6.36400000E-05
   -1.27400000E-05  +2.47500000E-05  +4.90000000E-05  -1.13500000E-05  +2.07500000E-05
   +1.25900000E-05  +1.16000000E-05  +2.78136370E-01  +2.43110000E-04  +2.09790000E-04
   +8.64900000E-05  -2.96620000E-04  -1.63060000E-04  +2.01070000E-04  +3.09730000E-04
   +1.11180000E-04  -6.24500000E-05  -2.87450000E-04  -1.41910000E-04  -5.61710000E-04
   +1.38282000E-03  +8.93320000E-04  -1.46180000E-04  -1.82250000E-04  +1.93320000E-04
   +1.80700000E-05  -2.69380000E-04  -1.46910000E-04  -2.35000000E-05  +2.53667600E-02
   -1.36237200E-02  -7.54537000E-03  +9.02819400E-02  -8.51526800E-02  -2.78846900E-02
   +6.46400000E-05  +5.48290000E-04  -1.44801000E-03  -6.91000000E-04  -4.75194000E-03
   +3.68346000E-03  -7.57380000E-04  -2.97760000E-04  +5.17300000E-04  +1.25370000E-04
   +2.20270000E-04  -7.82500000E-05  -3.13360000E-04  +9.56400000E-05  +1.34800000E-04
   +2.59200000E-05  -3.77970000E-04  +1.57590000E-04  +1.78599000E-03  +1.44280000E-04
   -7.25700000E-04  +2.46490000E-04  -1.45450000E-04  -9.35800000E-05  -1.23000000E-05
   -3.23500000E-05  -2.80900000E-05  +7.48000000E-06  +8.30000000E-07  +1.26400000E-05
   +2.49000000E-06  +6.40600000E-05  +1.29840000E-04  +2.86200000E-05  -6.00300000E-05
   +1.02440000E-04  +8.00000000E-06  -8.77000000E-06  -9.08000000E-06  -1.00919760E-01
   +9.51829000E-02  -7.34100000E-05  -4.11300000E-05  -1.26100000E-05  +7.04900000E-05
   -5.67000000E-06  -1.56070000E-04  -3.01140000E-04  -4.19400000E-05  +5.68400000E-05
   +2.94420000E-04  +6.03800000E-05  -3.07720000E-04  -2.62030000E-04  -2.81220000E-04
   +3.21210000E-04  -2.15830000E-04  -1.31990000E-04  +1.71950000E-04  +6.89700000E-05
   +7.73100000E-05  +2.92700000E-05  -1.40693100E-02  +6.49333000E-03  +2.46707000E-03
   +6.45415400E-02  -2.90181100E-02  -6.64066400E-02  -1.29664000E-03  +4.83750000E-04
   +9.54490000E-04  +1.18720000E-04  +2.77204000E-03  -1.52299000E-03  +6.04310000E-04
   +3.02130000E-04  -1.09100000E-04  -1.36530000E-04  -1.96000000E-06  +2.20360000E-04
   -3.76300000E-05  -1.15110000E-04  +2.61500000E-05  +1.53350000E-04  +3.04190000E-04
   -1.63470000E-04  -7.46230000E-04  +2.45140000E-04  +5.79560000E-04  +6.91000000E-06
   -3.87800000E-05  +9.00000000E-08  +1.14200000E-05  -8.00000000E-06  +8.96000000E-06
   +1.74300000E-05  -1.67400000E-05  +4.50000000E-07  +2.25800000E-05  +1.21900000E-05
   +1.24100000E-04  +3.57400000E-05  +4.90000000E-06  -6.90200000E-05  +9.50000000E-07
   -1.07000000E-06  +1.05800000E-05  -6.98517700E-02  +2.76174100E-02  +6.98701900E-02
   -2.35470000E-04  -1.79510000E-04  -7.21300000E-05  +2.81380000E-04  +1.59980000E-04
   -7.92500000E-05  -2.64470000E-04  -8.56100000E-05  +5.87500000E-05  +2.92400000E-04
   +1.89770000E-04  +5.62280000E-04  +4.34280000E-04  -3.48290000E-04  -2.74000000E-04
   +5.19470000E-04  -2.86500000E-05  -1.66510000E-04  +8.05500000E-05  -2.04000000E-06
   -7.87000000E-06  +2.82320000E-03  +3.61834000E-03  +1.19269000E-03  -1.85055730E-01
   -1.24027320E-01  -4.72788600E-02  +3.59660000E-04  +3.28300000E-04  +4.60000000E-05
   +8.35800000E-05  -1.66450000E-04  +2.33750000E-04  -9.48180000E-04  +6.30130000E-04
   +8.14040000E-04  +5.93800000E-05  +2.40920000E-04  -1.07830000E-04  -1.78070000E-04
   -6.91000000E-06  +7.74400000E-05  +4.48000000E-05  +1.81500000E-05  -9.80000000E-07
   +1.36430000E-04  -2.20700000E-05  -7.99300000E-05  +9.15400000E-05  -3.53200000E-05
   -5.09200000E-05  +2.01300000E-05  +3.17300000E-05  +2.64100000E-05  -2.53000000E-05
   -1.98000000E-06  -2.02300000E-05  -5.59000000E-06  -1.51000000E-05  -1.92200000E-05
   -6.50000000E-05  +7.04700000E-05  +9.36000000E-06  -8.54000000E-06  -5.98000000E-06
   +5.41000000E-06  -1.86500800E-02  -1.87923700E-02  -7.96549000E-03  +2.00502860E-01
   -6.42030000E-04  -5.12500000E-04  -2.90320000E-04  +3.44450000E-04  +3.73510000E-04
   +5.12450000E-04  -1.02370000E-04  +1.64470000E-04  +5.86100000E-05  -3.17430000E-04
   -1.04030000E-04  +3.25420000E-04  +1.23052000E-03  -4.04945000E-03  +3.52495000E-03
   +3.39960000E-04  -3.81910000E-04  -5.78820000E-04  -6.09360000E-04  -1.08620000E-04
   -5.38570000E-04  -2.09034400E-02  -1.77840500E-02  -7.33809000E-03  -1.22668560E-01
   -1.58835800E-01  -4.19128300E-02  -5.27050000E-04  +9.06290000E-04  -1.56586000E-03
   -7.93960000E-04  +5.41650000E-04  -1.35160000E-04  +6.52600000E-05  -2.83210000E-04
   +3.87910000E-04  +3.33320000E-04  +2.20450000E-04  -1.81840000E-04  +1.18480000E-04
   +1.05550000E-04  -1.32510000E-04  -1.57900000E-04  -1.52560000E-04  +1.42890000E-04
   +1.14390000E-04  -8.85400000E-05  +2.68550000E-04  -1.05900000E-04  +1.30050000E-04
   -3.88000000E-06  +2.85100000E-05  +3.52700000E-05  +7.81600000E-05  -3.76200000E-05
   -4.49600000E-05  -5.27700000E-05  +5.82900000E-05  +2.10900000E-05  -6.44500000E-05
   +5.16700000E-05  -1.40780000E-04  +1.63470000E-04  -1.06150000E-04  -1.01300000E-05
   -3.02100000E-05  +9.24963000E-03  +8.93136000E-03  +3.85846000E-03  +1.35443780E-01
   +1.73229510E-01  +1.96030000E-04  +1.85060000E-04  +4.22100000E-05  -3.19070000E-04
   -9.54000000E-06  +4.13880000E-04  +7.12790000E-04  +5.37200000E-05  +5.81500000E-05
   -8.94700000E-05  -3.51360000E-04  -9.35100000E-05  -1.15592000E-03  +2.13752000E-03
   -9.16640000E-04  +6.45850000E-04  +3.42600000E-04  +1.26120000E-04  -1.36920000E-04
   -3.66390000E-04  -8.34000000E-05  +1.19627600E-02  +1.03163900E-02  +2.37777000E-03
   -4.69399200E-02  -4.29954800E-02  -6.48990700E-02  +9.29860000E-04  +6.69050000E-04
   +8.48540000E-04  +2.67600000E-05  -5.29300000E-04  +2.03070000E-04  -1.88470000E-04
   -7.37310000E-04  +4.31940000E-04  +6.00000000E-08  +2.86920000E-04  -1.51620000E-04
   -8.25600000E-05  -6.07500000E-05  +9.15600000E-05  +7.65700000E-05  -5.03500000E-05
   -3.14600000E-05  -1.57200000E-05  +3.74800000E-05  -1.13740000E-04  +7.59000000E-06
   +4.78200000E-05  -3.19400000E-05  +5.15000000E-06  +6.20000000E-07  -2.80500000E-05
   +2.60700000E-05  +4.59000000E-06  +1.16000000E-05  -2.58610000E-04  +3.79390000E-04
   +4.32700000E-05  -9.39000000E-06  +9.49300000E-05  -4.85200000E-05  +1.42000000E-05
   +3.42100000E-05  -1.28500000E-05  +6.42336000E-03  +6.66967000E-03  +1.59740000E-03
   +5.12755300E-02  +4.44881000E-02  +6.65917200E-02  +4.50800000E-05  +4.88000000E-05
   +1.27500000E-05  -2.19100000E-05  -7.58500000E-05  -8.89500000E-05  -2.25030000E-04
   -1.83200000E-05  -3.81200000E-05  +2.47200000E-05  -1.16360000E-04  -1.36070000E-04
   -1.02470000E-04  +2.03500000E-04  +7.48250000E-04  -1.38950000E-04  -9.95500000E-05
   +6.34700000E-05  +9.13900000E-05  +3.97600000E-05  +6.20800000E-05  -1.74930000E-03
   -8.00920000E-04  -4.43346000E-03  -4.68291100E-02  -6.33210000E-04  -2.83100000E-05
   -7.62100000E-05  +1.00312000E-03  -3.02100000E-04  +3.31820000E-04  -2.85170000E-04
   -5.02340000E-04  -6.12200000E-05  +5.24840000E-04  -3.27040000E-04  -9.78000000E-05
   -1.11390000E-04  +2.16030000E-04  -1.10820000E-04  -3.34300000E-05  +3.10100000E-05
   +9.07000000E-05  +6.73700000E-05  -8.52400000E-05  +6.45000000E-05  +1.04250000E-04
   -9.59300000E-05  +1.14430000E-04  -1.15700000E-04  +1.65000000E-06  -5.22000000E-06
   -2.38500000E-05  -2.00000000E-07  +2.40300000E-05  -1.75400000E-05  +1.11400000E-05
   +1.86030000E-04  -9.33100000E-05  +4.23400000E-05  +1.88400000E-05  +3.44500000E-05
   -5.72900000E-05  -6.80000000E-07  +1.17100000E-05  -5.10000000E-06  +9.00300000E-04
   +3.30634000E-03  +2.88487700E-02  +3.15280000E-04  -2.12560000E-03  -2.34284600E-02
   +4.75982600E-02  +1.63090000E-04  +1.00280000E-04  +6.24500000E-05  +9.99400000E-05
   -1.02620000E-04  -4.12480000E-04  -2.67470000E-04  -2.04500000E-04  -2.63660000E-04
   -3.68760000E-04  -7.27200000E-05  +5.60540000E-04  +9.53920000E-04  +1.36042000E-03
   +3.67040000E-04  -5.33230000E-04  -1.24400000E-04  +5.01000000E-05  +2.99200000E-04
   +2.28470000E-04  +2.80890000E-04  -7.69680000E-04  +3.94490000E-03  +2.82274400E-02
   -9.69490000E-04  -5.27996400E-02  -3.83812500E-02  +5.50770000E-04  -5.12799000E-03
   +2.16898000E-03  -5.22510000E-04  +1.30344000E-03  -1.48870000E-04  +3.94480000E-04
   +3.04400000E-04  -1.48130000E-04  +1.47900000E-04  -2.23350000E-04  -3.09700000E-05
   +1.58030000E-04  +1.49830000E-04  -1.55540000E-04  -2.15020000E-04  +1.46400000E-05
   +1.16700000E-04  -1.83890000E-04  -2.68080000E-04  -7.12800000E-05  -6.86000000E-05
   +1.64600000E-05  +2.01600000E-05  -2.52600000E-05  -1.46500000E-05  -1.86600000E-05
   -1.43400000E-05  -7.06000000E-06  +2.12300000E-05  +1.83940000E-04  -7.82980000E-04
   -2.43150000E-04  +7.93000000E-05  +7.10000000E-07  -3.92000000E-05  +1.09500000E-05
   -8.17000000E-06  +3.70000000E-06  -1.06923000E-03  -2.29881000E-03  -1.19767100E-02
   +1.74073000E-03  -2.73209000E-03  -2.03250700E-02  -3.95800000E-04  +5.69972100E-02
   +4.20000000E-06  +1.48100000E-05  -1.06200000E-05  -2.21950000E-04  +1.18900000E-04
   +4.50240000E-04  +5.35200000E-04  +2.03260000E-04  +1.86500000E-04  +1.79000000E-05
   -5.97650000E-04  -3.99100000E-05  -1.04550000E-03  -7.38500000E-04  +5.44330000E-04
   +6.99560000E-04  +2.21010000E-04  -2.14040000E-04  -3.41490000E-04  -2.84860000E-04
   -1.99730000E-04  +1.48880000E-04  -3.16155000E-03  -1.47819100E-02  -9.39300000E-05
   -3.58836500E-02  -3.11343770E-01  -2.36820000E-04  +4.09982000E-03  -6.75750000E-04
   +8.44280000E-04  -4.83790000E-04  +2.65820000E-04  +5.75650000E-04  +1.91170000E-04
   +1.75400000E-04  -2.36390000E-04  -9.19000000E-06  +2.76320000E-04  -4.89600000E-05
   -1.91010000E-04  +4.03300000E-05  +1.53710000E-04  +8.64800000E-05  -1.02900000E-04
   -5.95600000E-05  +2.48500000E-04  +1.30020000E-04  -2.92600000E-05  -2.21800000E-05
   +1.57400000E-05  +1.11600000E-05  +1.06500000E-05  -3.73000000E-06  +3.25600000E-05
   +6.11000000E-06  +6.43000000E-06  -1.80570000E-04  +8.64200000E-05  +1.87080000E-04
   -1.13690000E-04  -3.21200000E-05  +8.52700000E-05  -1.75000000E-06  +1.75000000E-05
   -1.17900000E-05  -7.44460000E-04  -9.53200000E-04  -7.10536000E-03  +7.91180000E-04
   -4.79470000E-04  -5.78787000E-03  +5.13600000E-05  +3.83429000E-02  +3.38241070E-01
   +8.92900000E-05  +9.05200000E-05  +7.43500000E-05  -8.19100000E-05  -2.29700000E-05
   +2.19600000E-05  +1.14420000E-04  +8.63000000E-05  +5.99200000E-05  -1.01670000E-04
   -4.77300000E-05  -7.90400000E-05  +2.81280000E-04  +6.02560000E-04  -2.14840000E-04
   -5.28500000E-05  -2.12650000E-04  -7.60440000E-04  -1.07090000E-04  -7.03800000E-05
   +2.25350000E-04  -1.90554000E-03  +1.55458000E-03  -8.40690000E-04  +5.39000000E-06
   -2.41900000E-04  -7.78720000E-04  -4.73172700E-02  +8.19009000E-03  -4.61695000E-03
   +5.66000000E-05  -8.15970000E-04  +2.85350000E-04  -1.66510000E-04  +4.37500000E-05
   +7.65700000E-05  +1.49620000E-04  -9.55600000E-05  +2.97700000E-05  -1.51500000E-05
   +1.27000000E-04  -5.20800000E-05  -2.15440000E-04  +4.64400000E-05  +9.65300000E-05
   -4.27800000E-05  +1.58040000E-04  -5.77400000E-05  +4.98600000E-05  -3.79500000E-05
   -2.68600000E-05  -7.85000000E-06  -7.30000000E-06  -7.71000000E-06  +1.10000000E-05
   +3.57000000E-06  +1.70500000E-05  -1.97300000E-05  +2.59300000E-05  +6.58500000E-05
   -1.25122000E-03  +3.20470000E-04  -1.86700000E-04  -9.78000000E-06  +6.07000000E-06
   -1.95400000E-05  +3.45060000E-04  -3.45730000E-04  +1.82010000E-04  +1.04620000E-04
   +3.38380000E-04  -2.86400000E-05  +6.09580000E-04  +2.45580000E-04  -1.62840000E-04
   +4.75579900E-02  +8.75800000E-05  +5.36700000E-05  -6.02000000E-06  -6.05100000E-05
   -1.09440000E-04  +1.49800000E-05  +7.96000000E-06  -1.38900000E-05  -2.79000000E-05
   +2.62450000E-04  +1.92060000E-04  +9.88000000E-05  -4.81980000E-04  +4.00360000E-04
   +2.89800000E-05  -7.37850000E-04  +2.92120000E-04  +1.40630000E-04  +1.18680000E-04
   +5.94900000E-05  -1.85740000E-04  +7.41000000E-05  +5.16768000E-03  -4.47247000E-03
   -1.81970000E-04  +6.46390000E-04  -4.68780000E-04  +9.04223000E-03  -2.38010930E-01
   +1.21041160E-01  +1.42250000E-04  +6.04330000E-04  +9.15400000E-05  -1.75280000E-04
   -4.54000000E-06  +1.16150000E-04  +8.36400000E-05  -7.00000000E-08  -8.25900000E-05
   +1.14380000E-04  +3.51600000E-05  -5.97100000E-05  -2.43290000E-04  -3.32600000E-05
   +7.49800000E-05  +2.12630000E-04  -1.76940000E-04  -5.48310000E-04  -1.35550000E-04
   +9.89500000E-05  +1.73400000E-05  -5.87000000E-06  -1.57000000E-05  -6.37000000E-06
   +2.69300000E-05  +4.04000000E-06  +1.43900000E-05  +1.00500000E-05  -8.56000000E-06
   -4.38800000E-05  -6.08200000E-05  -2.37510000E-04  -3.23610000E-04  +4.94000000E-06
   +4.22400000E-05  +2.58000000E-06  -2.17630000E-04  +1.06130000E-04  -2.17180000E-04
   +1.90760000E-04  +2.34840000E-04  -2.72810000E-04  -9.28000000E-06  +3.57310000E-04
   -1.85600000E-05  -9.46655000E-03  +2.58182870E-01  +3.49500000E-05  +1.50700000E-05
   +5.45000000E-06  -1.69170000E-04  +5.07100000E-05  +2.86540000E-04  +2.80050000E-04
   +2.04770000E-04  +2.84000000E-05  +5.97000000E-05  -4.76760000E-04  -2.51330000E-04
   +9.59940000E-04  +8.21430000E-04  +1.57430000E-03  -7.35700000E-05  -1.17410000E-04
   +4.02100000E-05  -2.48020000E-04  -2.85630000E-04  -8.10000000E-06  -1.19236000E-03
   +2.74661700E-02  -1.62137400E-02  +1.07420000E-04  -2.76745000E-03  -6.66529000E-03
   -4.68692000E-03  +1.18974770E-01  -1.22161540E-01  -1.61556000E-03  +7.76800000E-04
   +1.07457000E-03  +8.01010000E-04  +3.70700000E-05  -1.39740000E-04  -4.17070000E-04
   +2.90600000E-04  +6.10300000E-05  -1.68890000E-04  -3.55560000E-04  +1.87700000E-04
   +5.84680000E-04  -3.66360000E-04  -3.18200000E-05  +2.87150000E-04  +4.44920000E-04
   -1.16940000E-04  -4.79400000E-05  -8.32000000E-06  +4.14300000E-05  -1.24500000E-05
   +6.32000000E-06  -1.08300000E-05  -1.88900000E-05  +3.95400000E-05  -1.83600000E-05
   -3.61200000E-05  +7.88300000E-05  +4.85800000E-05  -4.85000000E-04  +1.13750000E-04
   +4.30300000E-05  -2.63300000E-05  -3.70000000E-07  -1.92600000E-05  -1.08000000E-04
   -1.42380000E-04  +1.48770000E-04  +1.70250000E-04  -2.03960000E-04  +2.22210000E-04
   -3.75040000E-04  +1.91021000E-03  -1.15675000E-03  +6.06642000E-03  -1.31565040E-01
   +1.34725560E-01  -1.49860000E-04  -1.42110000E-04  -1.08790000E-04  +7.46400000E-05
   +9.08700000E-05  +4.49100000E-05  -4.94500000E-05  -2.40900000E-05  -1.23110000E-04
   +3.97500000E-05  +1.48100000E-05  +2.58540000E-04  +6.38500000E-04  +1.18360000E-04
   +1.80250000E-04  -2.18990000E-04  -4.72400000E-05  +4.97260000E-04  +1.60880000E-04
   -4.86100000E-05  -3.18150000E-04  -1.69520000E-03  -1.52740000E-04  +1.02794000E-03
   -2.05030000E-04  -4.05800000E-05  +2.82560000E-04  -2.32766730E-01  -1.19464150E-01
   -4.18453500E-02  +7.57400000E-04  +1.19534000E-03  +7.31430000E-04  +2.76220000E-04
   -1.70830000E-04  -5.80000000E-06  +5.68800000E-05  -1.66700000E-05  -1.00560000E-04
   -6.75000000E-06  +7.86200000E-05  -5.31800000E-05  -1.89870000E-04  +2.89100000E-05
   -2.70000000E-06  +3.43550000E-04  -2.15780000E-04  +1.62700000E-05  +3.82600000E-05
   -1.57800000E-05  +9.70000000E-07  +1.38200000E-05  +1.51700000E-05  +1.55200000E-05
   -2.94900000E-05  -1.53000000E-06  -2.39600000E-05  +7.99000000E-05  -3.05000000E-05
   -6.68900000E-05  +2.69050000E-04  +8.03800000E-05  -5.39490000E-04  -4.75000000E-06
   -1.03800000E-05  +1.60700000E-05  +3.58700000E-05  -1.30870000E-04  +1.46000000E-06
   +2.31820000E-04  +4.54510000E-04  -3.81320000E-04  +2.57530000E-04  +2.40290000E-04
   +5.87400000E-05  +1.95014000E-03  +2.08872000E-03  +7.84870000E-04  +2.49489110E-01
   -1.92110000E-04  -1.45580000E-04  -5.38000000E-05  +2.51130000E-04  +8.17000000E-05
   -1.00010000E-04  -1.25270000E-04  -2.18330000E-04  -8.16800000E-05  -4.87090000E-04
   +1.88450000E-04  +1.66460000E-04  +4.51410000E-04  +4.46170000E-04  -1.60937000E-03
   +8.74600000E-05  +2.55550000E-04  -1.78840000E-04  +9.45000000E-06  +1.65950000E-04
   +3.98400000E-05  -5.12755000E-03  -5.27630000E-03  -1.46536000E-03  +7.88280000E-04
   +3.82040000E-04  +6.53920000E-04  -1.18375000E-01  -1.23569190E-01  -2.54438700E-02
   -6.72490000E-04  +2.22190000E-04  -2.22200000E-05  +3.24500000E-04  +1.62070000E-04
   -4.75000000E-05  +4.21000000E-05  +4.35500000E-05  -6.30000000E-05  +1.43780000E-04
   -1.01540000E-04  -1.48900000E-05  +4.65500000E-05  -6.41300000E-05  -2.65100000E-05
   -5.53400000E-05  -3.96740000E-04  +5.41700000E-04  -1.08800000E-04  +1.03140000E-04
   +2.68700000E-05  +2.29400000E-05  +1.82300000E-05  +2.31300000E-05  -1.95300000E-05
   -8.10100000E-05  -5.17000000E-06  +9.03000000E-06  +4.10700000E-05  -6.11600000E-05
   +1.55740000E-04  -3.08190000E-04  +7.59100000E-05  -3.06100000E-05  +8.33000000E-06
   -5.55000000E-06  +7.31600000E-05  +3.79600000E-05  +3.86600000E-05  -5.06800000E-05
   +2.71270000E-04  +2.99530000E-04  +1.00750000E-04  -2.43500000E-05  -7.91800000E-05
   -2.23917900E-02  -1.34728200E-02  -5.74508000E-03  +1.30136680E-01  +1.30823720E-01
   -2.31620000E-04  -1.46910000E-04  -2.52100000E-05  +2.07600000E-04  +1.93130000E-04
   +2.32300000E-05  +1.24430000E-04  -2.44810000E-04  -3.74040000E-04  -1.77974000E-03
   -1.03974000E-03  +9.34000000E-06  +1.45172000E-03  -8.11900000E-05  -6.11464000E-03
   +1.04778000E-03  +7.88200000E-05  -6.85170000E-04  -2.20090000E-04  -6.92800000E-05
   +2.23580000E-04  -2.66899400E-02  -1.78961600E-02  -7.88992000E-03  -6.96380000E-04
   -1.29150000E-03  +1.23321000E-03  -3.96277800E-02  -2.43540700E-02  -5.46112800E-02
   -1.36248000E-03  -2.17800000E-05  +7.81860000E-04  +5.05000000E-05  +1.97850000E-04
   +2.25250000E-04  +2.36610000E-04  -8.78600000E-05  -9.74000000E-05  +2.89980000E-04
   +7.47500000E-05  -2.30650000E-04  -3.48160000E-04  -2.43000000E-04  +2.25440000E-04
   +3.11950000E-04  -1.84160000E-04  +9.13900000E-05  -2.72390000E-04  +1.79360000E-04
   +5.80800000E-05  +3.00800000E-05  +2.79800000E-05  +2.52200000E-05  -1.35610000E-04
   -1.10650000E-04  -6.15100000E-05  -7.69000000E-06  +6.63200000E-05  -1.86600000E-05
   -4.47500000E-05  +2.72870000E-04  +5.17890000E-04  -3.59300000E-05  -3.84200000E-05
   -6.20000000E-06  +1.00740000E-04  +6.24800000E-05  -5.29600000E-05  +2.45780000E-04
   +8.18450000E-04  -3.36130000E-04  +3.83760000E-04  +4.34000000E-05  +2.58040000E-04
   +1.51842600E-02  +8.28095000E-03  +3.08782000E-03  +4.42862200E-02  +2.94659200E-02
   +6.27873200E-02  +7.65600000E-05  +3.38400000E-05  -2.23000000E-05  -1.77020000E-04
   -3.41300000E-05  +2.83200000E-05  +4.52400000E-05  +1.94100000E-05  -3.15000000E-06
   +1.04460000E-04  +9.76700000E-05  +4.34500000E-05  -8.02000000E-05  -1.06180000E-04
   +3.25750000E-04  -9.10760000E-04  -9.85060000E-04  +2.76390000E-04  +1.47290000E-04
   -7.27000000E-05  -3.36960000E-04  +1.17219000E-03  -1.45504000E-03  -1.03682000E-03
   +4.33090000E-04  -1.54380000E-04  -4.80230000E-04  -2.15375320E-01  +1.13721530E-01
   +6.14492600E-02  +4.36280000E-04  +3.94940000E-04  +5.21940000E-04  +5.38930000E-04
   +2.82080000E-04  -5.70400000E-05  -3.17500000E-05  +9.05100000E-05  -4.10500000E-05
   +3.18430000E-04  -1.42680000E-04  -1.02290000E-04  -1.69790000E-04  -1.49640000E-04
   +7.91700000E-05  +1.64800000E-04  -5.63070000E-04  +3.80240000E-04  -3.07630000E-04
   +2.07410000E-04  +7.02400000E-05  -1.92100000E-05  -7.42000000E-06  -1.16000000E-05
   +1.14900000E-05  +1.88700000E-05  +3.92000000E-06  -8.92000000E-06  +1.86000000E-06
   -1.54900000E-05  -7.19330000E-04  -1.54552000E-03  -9.88440000E-04  +2.74800000E-05
   -7.35000000E-06  +2.08700000E-05  +3.13070000E-04  -2.21690000E-04  +1.84910000E-04
   -2.06060000E-04  +6.34100000E-05  +1.31370000E-04  +1.92370000E-04  -2.28400000E-04
   -6.23300000E-05  -3.43200000E-04  -1.07435000E-03  -3.29870000E-04  -1.94597600E-02
   +1.52114600E-02  +7.38032000E-03  +2.33866090E-01  +6.50300000E-05  +9.74400000E-05
   +1.14450000E-04  +1.56000000E-05  -3.11200000E-05  -2.62600000E-05  +7.75200000E-05
   +8.71700000E-05  +1.06980000E-04  -2.42530000E-04  -8.36900000E-05  -5.28000000E-05
   +4.81390000E-04  +2.56660000E-04  +9.78100000E-05  +3.36930000E-04  -2.47600000E-04
   -1.24552000E-03  -2.61890000E-04  +8.04300000E-05  +5.06700000E-04  +5.01316000E-03
   -4.11485000E-03  -5.45660000E-04  -4.56800000E-04  +3.79160000E-04  +1.16852000E-03
   +1.12627350E-01  -1.24031720E-01  -4.14572500E-02  +4.72600000E-05  +5.65910000E-04
   -1.47365000E-03  -4.40900000E-04  -2.99910000E-04  +5.79100000E-05  +4.45850000E-04
   -2.85300000E-04  -2.70000000E-05  -4.19500000E-05  +4.11930000E-04  -2.12500000E-04
   -4.55120000E-04  +1.98140000E-04  +8.66400000E-05  +3.45260000E-04  -6.47500000E-05
   -3.23560000E-04  +1.89200000E-04  -1.33500000E-04  -2.53600000E-05  -4.90000000E-07
   -7.37000000E-06  -2.29000000E-06  +5.80000000E-07  -1.50000000E-06  +1.62300000E-05
   +3.48000000E-06  +2.12700000E-05  +1.18380000E-04  -1.23388000E-03  -1.08712000E-03
   +2.40810000E-04  -1.30500000E-05  -2.32600000E-05  -2.70800000E-05  -4.31800000E-05
   +4.59200000E-04  +1.96440000E-04  -1.55300000E-04  -2.86600000E-05  -9.93300000E-05
   -1.90830000E-04  -6.04900000E-05  -5.07500000E-05  +2.12835700E-02  -1.35179700E-02
   -8.62237000E-03  -1.40024700E-02  +1.02603500E-02  +5.78855000E-03  -1.23463510E-01
   +1.30946740E-01  +8.38500000E-05  +8.27300000E-05  +3.88700000E-05  -1.21540000E-04
   -6.23900000E-05  +1.59640000E-04  +1.67800000E-04  +1.32370000E-04  +5.21100000E-05
   -1.43500000E-04  +3.90500000E-05  -2.50040000E-04  +4.27790000E-04  +4.60210000E-04
   +8.36910000E-04  -2.19910000E-04  +8.11300000E-05  -8.78000000E-06  -2.29940000E-04
   -5.90400000E-05  +5.85400000E-05  +2.59644900E-02  -1.60299700E-02  -9.44826000E-03
   +1.19767000E-03  -1.14386000E-03  +1.37288000E-03  +6.05541000E-02  -4.03470300E-02
   -6.99235600E-02  -1.39947000E-03  -7.51540000E-04  -5.57724000E-03  +5.18010000E-04
   -7.09510000E-04  -1.36800000E-05  +4.24700000E-04  -8.42900000E-05  +3.65310000E-04
   -4.89220000E-04  +3.38300000E-04  -3.48300000E-05  +3.98740000E-04  +6.14800000E-05
   +7.07000000E-06  +3.48770000E-04  +7.52480000E-04  -3.26940000E-04  +6.30760000E-04
   -4.51200000E-04  -8.01000000E-05  -5.69000000E-06  -1.71500000E-05  -9.79000000E-06
   +1.97300000E-05  -1.34900000E-05  +1.12600000E-05  +5.05400000E-05  -3.26000000E-06
   +8.81900000E-05  -4.24660000E-04  -4.85430000E-04  +4.04960000E-04  +1.01000000E-06
   -1.32500000E-05  -6.62000000E-06  -6.61510000E-04  +6.05030000E-04  -5.77500000E-04
   +5.78000000E-06  +1.50630000E-04  -5.07600000E-05  -2.93580000E-04  -4.46400000E-05
   +4.27580000E-04  -1.46552000E-02  +8.58900000E-03  +5.05938000E-03  -4.65669000E-03
   +3.88216000E-03  +1.07571000E-03  -6.73021500E-02  +4.55953400E-02  +7.65005000E-02
   +1.01590000E-04  +8.89200000E-05  +2.60200000E-05  -5.75000000E-05  -6.97700000E-05
   -2.54900000E-05  +1.60200000E-05  +2.84500000E-05  -6.66200000E-05  -4.21400000E-05
   +7.29200000E-05  +1.43010000E-04  -2.07640000E-04  +1.13280000E-04  -1.36910000E-04
   -2.76300000E-05  +1.74000000E-05  -1.35300000E-05  +4.64300000E-05  +4.64200000E-05
   +3.64400000E-05  +5.07200000E-05  -6.70010000E-04  -2.11345000E-03  -9.65880000E-04
   -7.84100000E-05  +9.24560000E-04  +4.09860000E-04  +4.26400000E-05  -7.19400000E-05
   +6.59295000E-03  -1.95939300E-02  +8.73371000E-03  -5.76691300E-02  +3.91635500E-02
   -6.54798000E-03  -2.27080000E-04  +2.50101000E-02  -1.04186500E-02  -2.33014000E-03
   +2.46600000E-03  +2.80935000E-03  -1.51319000E-03  -6.69420000E-04  +4.14150000E-04
   -8.71840000E-04  -6.28090000E-04  +3.52630000E-03  -5.80700000E-05  +1.62743000E-03
   -3.30300000E-04  -7.44000000E-06  -2.16100000E-05  -3.90000000E-06  +8.77000000E-06
   -3.85000000E-06  +1.44200000E-05  +6.44400000E-05  -7.31400000E-05  -2.64300000E-05
   -2.16000000E-06  -3.08000000E-05  -2.46000000E-06  +1.95700000E-05  -6.44000000E-06
   +1.40000000E-07  +2.32400000E-04  -7.24700000E-05  -1.24540000E-04  -7.48070000E-04
   +8.84030000E-04  +5.65710000E-04  -1.42490000E-03  +3.48600000E-04  -3.13240000E-04
   +1.53000000E-06  +4.47100000E-05  -1.82830000E-04  +3.57700000E-05  -1.96800000E-05
   +4.60000000E-06  -3.59700000E-05  -2.06200000E-05  -8.14300000E-05  +5.90625700E-02
   -1.20400000E-05  -9.94000000E-06  -2.34200000E-05  +1.45000000E-05  +1.57300000E-05
   +3.23800000E-05  +1.21300000E-05  +1.17400000E-05  -6.41000000E-05  -1.09900000E-04
   +3.98900000E-05  +1.50490000E-04  -1.98510000E-04  +2.05460000E-04  +2.58230000E-04
   -6.01800000E-05  -4.99100000E-05  -1.00830000E-04  -4.59000000E-06  -4.55000000E-06
   -2.47000000E-06  +2.30610000E-04  -1.68715000E-03  -1.57590000E-03  +1.71862000E-03
   -2.84900000E-05  -5.10180000E-04  +2.39840000E-04  -9.83300000E-05  -1.25100000E-04
   +2.46061000E-03  -8.63038000E-03  +5.32342000E-03  +3.91602900E-02  -2.95049910E-01
   +1.05874730E-01  +3.08790000E-04  -1.00436700E-02  +5.93716000E-03  +2.91433000E-03
   +1.91853000E-03  +9.86600000E-05  -3.78300000E-05  -1.58580000E-04  -5.30520000E-04
   -1.64015000E-03  +9.30980000E-04  +3.00060000E-03  +2.74870000E-04  -7.23480000E-04
   +5.86140000E-04  -1.83000000E-06  -7.05000000E-06  +7.81000000E-06  -4.66000000E-06
   -1.50100000E-05  +2.46000000E-06  +9.50000000E-06  -9.99900000E-05  -7.05000000E-06
   +1.23800000E-05  -1.06200000E-05  -3.80000000E-06  -1.77000000E-06  -1.17400000E-05
   -2.98000000E-06  +2.50600000E-04  +2.69160000E-04  -5.30940000E-04  +1.33573000E-03
   -2.41780000E-04  -3.74130000E-04  -4.71500000E-05  -9.71600000E-05  -3.81590000E-04
   +5.48000000E-06  +1.50700000E-05  -5.74800000E-05  -5.69000000E-06  -5.36000000E-06
   +3.50500000E-05  -5.31500000E-05  +3.84500000E-05  -6.29600000E-05  -4.63789500E-02
   +3.13380780E-01  -6.55200000E-05  -6.07000000E-05  -4.12500000E-05  +5.00600000E-05
   +5.41000000E-05  +2.29200000E-05  -1.51000000E-05  -2.06300000E-05  -3.87700000E-05
   -5.67200000E-05  -1.90600000E-05  +1.86660000E-04  -2.84590000E-04  +1.42320000E-04
   +4.17230000E-04  -1.06240000E-04  -1.21130000E-04  -1.26660000E-04  -4.28000000E-06
   -1.66600000E-05  +2.23000000E-06  -2.61262000E-03  -1.00783000E-03  -2.79534000E-03
   +8.63000000E-05  +6.62850000E-04  +6.78460000E-04  +8.16670000E-04  -1.87420000E-04
   -1.87400000E-04  -2.52394000E-03  +1.69009900E-02  -1.76162000E-03  -6.88205000E-03
   +1.06187520E-01  -8.11311000E-02  +2.16298000E-03  -7.93630000E-03  +5.31592000E-03
   +3.42884000E-03  +6.68710000E-04  +2.96786000E-03  +4.76090000E-04  -1.20290000E-03
   -1.04969000E-03  +3.08679000E-03  +2.94895000E-03  +2.40100000E-03  +1.99860000E-04
   -6.21500000E-05  +7.69590000E-04  -2.46000000E-06  +5.74000000E-06  +1.02200000E-05
   -1.26300000E-05  -1.39200000E-05  -6.79000000E-06  +9.26000000E-06  -1.47600000E-05
   -2.06200000E-05  +1.26300000E-05  +9.65000000E-06  -1.41800000E-05  -1.40300000E-05
   -8.80000000E-06  -5.33000000E-06  -4.11530000E-04  -3.44360000E-04  -1.28670000E-04
   +5.80720000E-04  -1.02791000E-03  -4.37370000E-04  -3.79780000E-04  +6.30700000E-05
   +5.38700000E-05  -5.59300000E-05  -7.93300000E-05  +4.64800000E-05  +3.32000000E-06
   -1.27000000E-06  -9.15500000E-05  -7.12000000E-06  -2.28200000E-05  -2.46000000E-04
   +4.17813000E-03  -1.15238010E-01  +7.79539200E-02  -6.20700000E-05  -4.82000000E-05
   -2.80800000E-05  +5.10500000E-05  +3.47100000E-05  +7.95000000E-06  -3.60900000E-05
   -2.19300000E-05  +2.51000000E-06  -1.89300000E-05  -1.16000000E-05  +2.17200000E-05
   -1.70300000E-05  +1.87780000E-04  +1.49670000E-04  -6.36800000E-05  -6.07900000E-05
   -5.91700000E-05  -5.03000000E-06  -1.75200000E-05  +6.00000000E-06  -1.16370000E-04
   -8.31600000E-04  +5.21320000E-04  -1.32000000E-06  -1.13880000E-04  +5.27000000E-06
   -2.23050000E-04  +1.07320000E-04  -4.44500000E-05  -2.38226000E-03  +3.93407000E-03
   +2.49066000E-03  -1.24532400E-02  -1.36590600E-02  +1.42482500E-02  -1.89775500E-01
   -8.41779700E-02  +1.20798900E-01  +6.61864000E-03  +3.96727000E-03  -2.42202000E-03
   +1.35136000E-03  +2.37723000E-03  +1.59607000E-03  +7.98000000E-05  +9.85290000E-04
   -9.42420000E-04  -3.04800000E-05  -1.41051000E-03  -1.36544000E-03  +3.70000000E-06
   +5.53000000E-06  +9.26000000E-06  -1.30400000E-05  -1.05100000E-05  -8.54000000E-06
   +5.35000000E-06  +1.33200000E-05  +2.03400000E-05  +1.12500000E-05  +1.32000000E-05
   -4.09000000E-06  -9.81000000E-06  -6.78000000E-06  -1.71000000E-06  -5.58000000E-06
   +4.91300000E-05  -2.98000000E-06  +2.97900000E-05  +1.74500000E-05  +1.50800000E-05
   -1.49200000E-05  +1.57300000E-05  -1.51300000E-05  +3.03000000E-06  -8.72000000E-06
   -9.71000000E-06  +2.22600000E-05  -3.29000000E-06  -2.71000000E-06  -2.04400000E-05
   +5.67200000E-05  +9.77300000E-05  -1.43600000E-05  -6.33980000E-04  -1.79574000E-03
   +1.96955720E-01  +1.26100000E-05  +7.39000000E-06  +5.62000000E-06  +0.00000000E+00
   -7.52000000E-06  -1.98800000E-05  -1.10100000E-05  +1.77000000E-06  -1.70000000E-07
   +8.27000000E-06  -1.23200000E-05  +1.28800000E-05  +1.66040000E-04  -1.22750000E-04
   -6.78300000E-05  +3.16000000E-06  -1.55000000E-06  +2.30100000E-05  +1.12900000E-05
   +2.94700000E-05  +5.89000000E-06  +3.86990000E-04  +4.48470000E-04  -2.78630000E-04
   -7.74200000E-05  +6.52200000E-05  -1.27100000E-05  +4.99100000E-05  -6.08000000E-06
   +4.31800000E-05  +4.06950000E-03  +3.76170000E-04  +4.09700000E-04  +1.09391100E-02
   +1.08021400E-02  -9.65734000E-03  -8.27651800E-02  -1.13521830E-01  +8.04405900E-02
   -2.28015800E-02  -7.18071000E-03  +1.79194500E-02  +2.99790000E-03  -3.26662000E-03
   +3.02588000E-03  +8.70140000E-04  -1.25258000E-03  -2.58110000E-04  -7.44610000E-04
   +1.66081000E-03  -2.24559000E-03  -4.90000000E-07  +3.10000000E-07  +2.10000000E-07
   -2.93000000E-06  -9.30000000E-07  +7.10000000E-07  +8.56000000E-06  +8.52000000E-06
   +1.37200000E-05  +4.80000000E-06  -6.49000000E-06  -2.89000000E-06  +2.68000000E-06
   +4.46000000E-06  -5.70000000E-07  -4.47000000E-06  -1.20900000E-05  +2.20800000E-05
   +3.50000000E-07  -3.39300000E-05  -1.47600000E-05  +9.84000000E-06  +1.00400000E-05
   +3.35300000E-05  -2.53000000E-06  +2.04000000E-06  -7.06000000E-06  -1.16500000E-05
   -4.60000000E-06  -1.53100000E-05  -1.06000000E-06  +1.94000000E-06  -2.37500000E-05
   -1.11263000E-03  +8.47200000E-05  -1.36749000E-03  +8.93849400E-02  +1.13024420E-01
   +4.90200000E-05  +3.25600000E-05  +1.94100000E-05  -2.94900000E-05  -3.23500000E-05
   -4.45700000E-05  -1.16000000E-05  -9.58000000E-06  -1.50400000E-05  +1.15200000E-05
   -1.48500000E-05  +1.02600000E-05  +2.14300000E-04  -1.09110000E-04  -3.59700000E-05
   -1.98900000E-05  -2.40500000E-05  +3.47000000E-05  +2.09700000E-05  +3.51000000E-05
   +2.66900000E-05  +4.41500000E-05  +2.19430000E-04  +1.17860000E-04  -2.14700000E-05
   +9.48000000E-06  -6.65200000E-05  +1.14100000E-05  +6.00300000E-05  +3.89100000E-05
   +2.23682000E-03  +4.51280000E-04  +4.40565000E-03  +2.78542000E-03  +3.20442000E-03
   -5.68250000E-04  +1.20102430E-01  +8.14101400E-02  -1.36873240E-01  +9.99642000E-03
   +3.80013000E-03  -1.48432000E-03  +1.41672000E-03  +3.53836000E-03  +4.09620000E-03
   -8.64740000E-04  -1.97960000E-04  -3.09100000E-04  -1.65144000E-03  -1.90487000E-03
   -2.15991000E-03  -7.46000000E-06  -4.30000000E-06  -4.76000000E-06  -3.65000000E-06
   +1.18000000E-06  +2.15000000E-06  -2.61000000E-06  +7.62000000E-06  +1.20000000E-07
   +3.58000000E-06  -3.50000000E-07  -3.81000000E-06  +8.10000000E-07  +7.50000000E-06
   -2.69000000E-06  +1.66400000E-05  -5.30000000E-07  +2.29100000E-05  +2.31700000E-05
   -6.21000000E-06  +6.03000000E-06  -1.96400000E-05  +2.44900000E-05  +1.96900000E-05
   -6.83000000E-06  +9.56000000E-06  -2.60900000E-05  -2.55000000E-06  -7.82000000E-06
   +7.30000000E-07  -1.82000000E-06  +4.12700000E-05  -5.29000000E-06  -1.55602000E-03
   -1.68790000E-03  -2.41193000E-03  -1.32667630E-01  -8.87097400E-02  +1.36270670E-01
   +1.33530000E-04  +8.15900000E-05  +4.81400000E-05  -1.28820000E-04  -8.25000000E-05
   -4.67800000E-05  +3.69200000E-05  -2.15900000E-05  -3.16900000E-05  +4.86000000E-06
   -3.83200000E-05  +8.15000000E-06  +1.30500000E-05  -1.51300000E-05  +1.19500000E-05
   -2.48300000E-05  -1.80000000E-05  +2.78700000E-05  +1.33400000E-05  +3.31000000E-06
   +3.81500000E-05  -1.54850000E-04  -6.61000000E-05  -3.55000000E-06  +4.94800000E-05
   -2.26000000E-06  -1.02400000E-05  +2.89300000E-05  +4.11600000E-05  -3.42700000E-05
   -3.25660000E-04  -2.68310000E-04  +2.97260000E-04  +1.48398000E-03  +1.01824000E-03
   -2.07810000E-04  -6.06429000E-03  +2.28376000E-03  +2.60935000E-03  -4.85703000E-03
   +4.12608700E-02  -1.81666000E-02  -2.66479000E-03  +6.58669000E-03  -8.08150000E-04
   +3.16710000E-04  -7.95100000E-05  -4.31650000E-04  -3.97792800E-02  -3.48342900E-02
   +3.37967900E-02  -3.21800000E-05  -9.52000000E-06  -1.91800000E-05  -8.49000000E-06
   +1.47100000E-05  +4.30000000E-07  -1.71700000E-05  +2.11500000E-05  -2.79200000E-05
   -1.38900000E-05  +1.27500000E-05  -3.20000000E-06  +4.60000000E-07  +7.25000000E-06
   -5.80000000E-06  +1.50400000E-05  -2.48700000E-05  +4.40000000E-07  -1.98800000E-05
   +2.00000000E-08  -6.19000000E-06  -6.29000000E-06  +9.83000000E-06  +1.70000000E-07
   -1.05200000E-05  +5.00000000E-08  +3.96800000E-05  -1.22200000E-05  -4.94000000E-06
   +1.45800000E-05  +2.05000000E-05  -2.39200000E-05  -2.36000000E-06  -3.54560000E-04
   +1.48170000E-04  +8.61700000E-05  -7.37200000E-05  -1.61230000E-04  -1.69270000E-04
   +4.98488500E-02  -1.68430000E-04  -1.44250000E-04  -6.46800000E-05  +1.34250000E-04
   +1.12450000E-04  +7.42500000E-05  -4.36400000E-05  -8.73000000E-06  +4.79900000E-05
   -5.66000000E-06  -1.34900000E-05  -1.82800000E-05  -3.10400000E-05  +1.47110000E-04
   +5.50200000E-05  -8.31000000E-06  -7.94000000E-06  -5.34300000E-05  -2.87500000E-05
   -4.94900000E-05  -4.58100000E-05  +2.19210000E-04  -1.78360000E-04  -3.88500000E-05
   -6.09200000E-05  -3.25800000E-05  +3.10800000E-05  -1.49310000E-04  +8.32400000E-05
   -2.80900000E-05  -3.29190000E-04  +7.89530000E-04  -1.32100000E-04  -6.54100000E-05
   -7.05840000E-04  +1.37609000E-03  +2.58516000E-03  +1.42411000E-03  -1.51522000E-03
   +5.43831000E-03  -2.65900000E-02  +8.27394000E-03  -3.31377000E-03  +4.01229000E-03
   +7.26000000E-04  +1.00387000E-03  -1.29070000E-03  -2.19550000E-04  +7.92716000E-03
   -4.21700290E-01  +1.90642310E-01  +1.52800000E-05  +3.22600000E-05  +1.67500000E-05
   -1.51500000E-05  -5.14000000E-06  -2.36800000E-05  +2.91600000E-05  +1.77500000E-05
   +5.62400000E-05  +1.70300000E-05  +7.87000000E-06  -5.80000000E-06  -1.10800000E-05
   -7.63000000E-06  +2.93000000E-06  -2.70400000E-05  +3.54100000E-05  +2.55000000E-06
   +1.18200000E-05  -2.10400000E-05  +1.86000000E-06  +1.55200000E-05  -6.97000000E-06
   -7.68000000E-06  +1.35800000E-05  -1.63400000E-05  -8.13000000E-06  +2.15000000E-06
   -2.92800000E-05  -3.92900000E-05  -5.00700000E-05  +2.87800000E-05  +7.66800000E-05
   +9.70200000E-05  -2.00200000E-05  -1.20030000E-04  -1.25510000E-04  +1.77460000E-04
   -2.76830000E-04  -1.32364600E-02  +4.45860340E-01  -5.51000000E-06  -5.80000000E-06
   -1.25800000E-05  +1.01300000E-05  +4.47000000E-06  +3.11000000E-06  -1.99000000E-06
   -8.24000000E-06  -1.61000000E-06  -2.93000000E-06  +4.22000000E-06  +4.67800000E-05
   +1.10100000E-05  -9.72000000E-06  -1.48300000E-05  -1.39100000E-05  +8.50000000E-07
   -7.33000000E-06  +1.51500000E-05  +1.82900000E-05  -7.07000000E-06  -1.48170000E-04
   -1.05300000E-05  -2.21830000E-04  -5.25000000E-06  +1.66900000E-05  -1.18500000E-05
   +1.28220000E-04  -8.99400000E-05  +1.81200000E-05  +4.49620000E-04  -2.38310000E-04
   +7.22600000E-05  +3.44090000E-04  +7.94980000E-04  +1.58126000E-03  +2.50009000E-03
   -1.42002000E-03  +4.12040000E-04  -1.49403000E-03  -9.83454000E-03  +2.46696000E-03
   +3.91958000E-03  -4.79160000E-03  +2.02245000E-03  -1.16331000E-03  +5.33560000E-04
   -2.73780000E-04  +1.38568600E-02  +2.12571020E-01  -1.12179260E-01  -3.66000000E-06
   +2.10000000E-06  +7.42000000E-06  -1.10800000E-05  -2.63000000E-06  -5.56000000E-06
   +3.69000000E-06  +1.47700000E-05  -1.00000000E-05  +8.89000000E-06  -1.19000000E-05
   -5.22000000E-06  +5.23000000E-06  -1.21000000E-06  -2.20000000E-07  +5.35000000E-06
   -2.60000000E-06  -5.98000000E-06  -2.36000000E-06  -2.90000000E-06  +4.58000000E-06
   -7.88000000E-06  +4.97000000E-06  -1.18100000E-05  +1.35200000E-05  +2.08200000E-05
   -2.23400000E-05  -3.70000000E-07  -5.09000000E-06  +1.42000000E-05  +6.37000000E-06
   +2.12000000E-06  -6.36400000E-05  +7.76300000E-05  -1.15420000E-04  -1.10630000E-04
   -1.84880000E-04  -2.70340000E-04  -3.28890000E-04  -1.57834200E-02  -1.98604420E-01
   +1.07988860E-01  -2.71800000E-04  -1.90610000E-04  -1.12120000E-04  +2.50820000E-04
   +1.75740000E-04  +1.28360000E-04  -5.40400000E-05  +1.39600000E-05  +4.11200000E-05
   -5.23900000E-05  +6.59600000E-05  +5.72900000E-05  +5.13100000E-05  +4.82300000E-05
   +2.87900000E-05  +6.68200000E-05  +5.66800000E-05  -1.05130000E-04  -2.19100000E-05
   -1.96000000E-05  -1.10870000E-04  +6.43070000E-04  +1.10680000E-03  -5.53690000E-04
   -4.94170000E-04  +9.28600000E-05  +1.92770000E-04  +2.86500000E-05  -1.56320000E-04
   -3.11300000E-05  -2.98191000E-03  -3.44922000E-03  +6.06661000E-03  +2.25413000E-03
   +1.45456000E-03  -2.65397000E-03  -6.08343000E-03  +1.77139000E-03  +4.43801000E-03
   +2.56776000E-03  -2.76034200E-02  +1.73613700E-02  -1.05689680E-01  +3.65219900E-02
   +1.54869700E-02  -7.73798000E-03  +4.00556900E-02  -1.15228400E-02  +7.05178000E-03
   -8.32230000E-03  -1.45841000E-03  +4.53200000E-05  +2.66800000E-05  +3.90400000E-05
   -8.59000000E-06  -2.44700000E-05  -1.61900000E-05  +3.60000000E-06  -1.90500000E-05
   +2.87800000E-05  +3.81200000E-05  -3.32600000E-05  -1.03000000E-06  -2.42000000E-06
   -1.67100000E-05  +8.28000000E-06  -6.66500000E-05  +1.41650000E-04  -1.04930000E-04
   +3.11700000E-05  -2.34000000E-06  +3.30000000E-06  +1.79400000E-05  +8.71000000E-06
   -4.28500000E-05  +8.78000000E-06  -2.33200000E-05  -1.12750000E-04  +3.48700000E-05
   +4.85600000E-05  +8.25000000E-06  -2.62100000E-05  +7.53300000E-05  -1.04100000E-05
   +4.29870000E-04  +3.88400000E-05  -1.18160000E-04  +2.96690000E-04  -1.33879000E-03
   +2.08630000E-04  +2.01052000E-03  +8.09080000E-04  -2.14843000E-03  +4.18669520E-01
   +8.50340000E-04  +7.66150000E-04  +3.09950000E-04  -6.31340000E-04  -5.80440000E-04
   -4.49760000E-04  +1.23190000E-04  +5.31700000E-05  -2.78810000E-04  -2.92300000E-05
   +3.27200000E-05  +1.47810000E-04  -1.46490000E-04  -5.93110000E-04  -2.65670000E-04
   -1.96230000E-04  +1.11400000E-05  +2.55890000E-04  +2.29430000E-04  +3.37290000E-04
   +2.72800000E-04  -1.42284000E-03  -3.96010000E-04  +1.30394000E-03  +7.97660000E-04
   -2.36000000E-04  -2.57390000E-04  +2.53160000E-04  -6.73900000E-05  +5.39900000E-05
   -1.21980000E-04  -1.61912000E-03  +4.45710000E-04  +7.04380000E-03  -6.27561000E-03
   -1.46915000E-03  -4.95007000E-03  +1.06952100E-02  -7.97790000E-04  +6.62567000E-03
   -4.53808400E-02  +2.56181700E-02  +6.81136300E-02  -2.74701300E-01  +7.44341900E-02
   +1.37000700E-02  -3.59079200E-02  +1.41075700E-02  -5.17293000E-03  +7.35795000E-03
   -3.25361000E-03  -4.96000000E-05  -1.84560000E-04  -5.65300000E-05  +8.35300000E-05
   +2.43000000E-06  +1.39970000E-04  -2.29210000E-04  -1.82280000E-04  -2.79250000E-04
   -6.45500000E-05  -6.35700000E-05  +7.89000000E-06  +8.60300000E-05  +5.86000000E-06
   -5.07000000E-06  +2.46730000E-04  -2.57300000E-04  -7.80300000E-05  -5.96000000E-05
   +3.08510000E-04  +7.48200000E-05  -1.89620000E-04  +7.91200000E-05  -1.74000000E-04
   -3.22300000E-05  +1.02070000E-04  -9.12000000E-06  -3.84400000E-05  +1.02800000E-04
   +2.06150000E-04  +1.61330000E-04  -1.44590000E-04  -1.51370000E-04  +5.53190000E-04
   +4.31930000E-04  +5.51220000E-04  +3.08800000E-05  -8.84350000E-04  +5.18000000E-05
   -1.09615000E-03  -1.04843000E-03  +6.85010000E-04  +1.70531100E-02  +4.13045960E-01
   -2.35570000E-04  -1.94330000E-04  -5.96700000E-05  +1.41520000E-04  +1.56010000E-04
   +1.22060000E-04  +1.38000000E-06  +4.59600000E-05  +1.21570000E-04  -1.33900000E-05
   -5.42100000E-05  -1.91440000E-04  -1.03730000E-04  +6.38600000E-05  +1.17690000E-04
   +1.03770000E-04  +1.47400000E-05  -5.90500000E-05  -1.26850000E-04  -1.79220000E-04
   -7.41200000E-05  +9.06440000E-04  +1.09830000E-04  +3.32510000E-04  -8.90600000E-05
   -1.91000000E-05  +1.56800000E-05  -1.65840000E-04  +1.88280000E-04  -1.05900000E-04
   +4.28591000E-03  +5.24031000E-03  +2.99219000E-03  -4.78375000E-03  +1.27744000E-03
   +2.93490000E-04  +7.48718000E-03  -3.32640000E-03  +2.11201000E-03  +5.72700000E-05
   +4.10105600E-02  -1.11106400E-02  +7.35570000E-04  +9.20464800E-02  -8.80104500E-02
   +5.73750000E-04  +1.44859000E-03  +5.48465000E-03  -3.17647000E-03  -6.89350000E-04
   -1.29407000E-03  +2.98700000E-05  +4.30300000E-05  +7.51000000E-06  +2.34000000E-06
   -2.98000000E-06  -1.92800000E-05  +9.33400000E-05  +4.25600000E-05  +1.31410000E-04
   -1.18600000E-05  +6.45300000E-05  +1.42200000E-05  -4.10100000E-05  +1.07000000E-06
   +1.17000000E-06  -1.38690000E-04  -2.37700000E-05  +1.35500000E-05  +1.27000000E-06
   -1.67780000E-04  -3.15600000E-05  +9.99100000E-05  -2.79500000E-05  +7.94900000E-05
   -2.24700000E-05  -6.97700000E-05  +7.97000000E-05  +1.14000000E-06  -5.73200000E-05
   -1.04700000E-04  -7.25400000E-05  -9.11000000E-06  +1.20230000E-04  -4.90420000E-04
   -2.01740000E-04  -1.15710000E-04  -3.62720000E-04  +1.03142000E-03  -4.60330000E-04
   -1.37295000E-03  -5.89810000E-04  -3.89230000E-04  -2.24091590E-01  -1.96845000E-01
   +2.57431950E-01  +1.52720000E-04  +7.88300000E-05  +7.49500000E-05  -2.05750000E-04
   -9.34100000E-05  -3.08900000E-05  +8.75800000E-05  -1.60000000E-06  -4.43000000E-06
   +1.87900000E-05  -1.10610000E-04  -1.60710000E-04  +1.23720000E-04  +3.81800000E-05
   +6.79100000E-05  +3.01400000E-05  -3.09700000E-05  +7.61100000E-05  -6.73200000E-05
   -1.20390000E-04  +4.89800000E-05  +1.44080000E-04  +3.84420000E-04  -1.63710000E-04
   -8.39800000E-05  +4.90000000E-05  +3.03500000E-05  -3.06600000E-05  +2.07950000E-04
   -1.71980000E-04  -1.75486000E-03  +1.30348000E-03  +1.37069000E-03  -1.08527000E-03
   +2.01320000E-04  +3.09890000E-04  +1.55656000E-03  -1.64353000E-03  +7.14020000E-04
   +2.41100000E-04  +6.66689000E-03  -3.27276000E-03  +8.71406000E-03  -9.17594000E-03
   -2.29780000E-04  +4.39556000E-03  +8.23161000E-03  -6.53085000E-03  -3.33410000E-04
   -2.96980000E-04  +6.38910000E-04  -4.16200000E-05  -2.64000000E-06  -3.76600000E-05
   -1.07000000E-06  +2.54900000E-05  -1.63000000E-06  +2.21100000E-05  +3.52900000E-05
   +3.16100000E-05  -4.33700000E-05  +7.78200000E-05  +7.59000000E-06  -2.24700000E-05
   +1.90100000E-05  -8.89000000E-06  -2.61100000E-05  +2.31600000E-05  +2.07600000E-05
   -1.56400000E-05  -7.30500000E-05  -9.96000000E-06  +2.81100000E-05  -2.20500000E-05
   +5.70100000E-05  +2.98700000E-05  +9.19000000E-06  +1.80400000E-04  -2.37600000E-05
   -1.08190000E-04  -1.98000000E-06  -4.43000000E-06  -5.34400000E-05  +5.37700000E-05
   -4.66590000E-04  -1.97510000E-04  -6.19600000E-05  -1.49700000E-05  +2.16390000E-04
   -1.18990000E-04  -1.48660000E-04  -4.44860000E-04  -2.11300000E-04  -3.02454340E-01
   -9.75311300E-02  +2.12821370E-01  +2.89813590E-01  -2.43340000E-04  -2.35390000E-04
   -9.10700000E-05  +2.16380000E-04  +1.77980000E-04  +1.12490000E-04  -6.12100000E-05
   -3.95200000E-05  +5.12700000E-05  +6.73000000E-06  +2.20300000E-05  +2.41000000E-06
   +3.49100000E-05  +1.43170000E-04  +3.87900000E-05  +2.18100000E-05  +3.25000000E-06
   -5.54200000E-05  -2.62400000E-05  -5.49200000E-05  -7.26000000E-05  +2.61870000E-04
   +6.19800000E-05  -8.48500000E-05  -1.64140000E-04  +1.02100000E-05  +4.49100000E-05
   -1.08130000E-04  -2.43400000E-05  +1.37200000E-05  -6.27490000E-04  -6.54530000E-04
   +3.81300000E-05  +2.80680000E-04  +3.61890000E-04  -2.97190000E-04  -1.43252000E-03
   +2.63420000E-04  +1.00539000E-03  +3.39795000E-03  -5.73794000E-03  +2.24341000E-03
   -3.38472900E-02  -2.27637900E-02  +2.99586800E-02  -5.13660000E-04  +7.94190000E-04
   -2.16940000E-04  +1.32279000E-03  +9.92490000E-04  -1.04791000E-03  +9.67000000E-06
   +5.90100000E-05  +1.14700000E-05  -2.18300000E-05  +6.50000000E-07  -4.00600000E-05
   +2.04500000E-05  +1.29900000E-05  +5.03700000E-05  +3.32600000E-05  -1.57000000E-06
   -1.20900000E-05  -1.90300000E-05  +1.20000000E-07  +4.35000000E-06  -3.62400000E-05
   +6.41900000E-05  -6.04000000E-06  +9.93000000E-06  -3.05100000E-05  -3.33000000E-06
   +2.22000000E-05  +1.66000000E-06  -1.11500000E-05  +4.74500000E-05  -1.35600000E-05
   -6.22000000E-05  +6.29000000E-06  -2.63200000E-05  -2.48800000E-05  -4.86100000E-05
   +6.26400000E-05  +3.03300000E-05  +1.16860000E-04  +7.23800000E-05  -5.37000000E-06
   +5.88000000E-05  -4.07350000E-04  -7.12000000E-06  -1.46399000E-03  -4.22760000E-04
   +5.52600000E-04  -6.37793700E-02  -7.09669100E-02  +6.55946100E-02  +9.72617200E-02
   +1.02511100E-01  -1.88000000E-06  -2.76600000E-05  -2.58200000E-05  +1.98400000E-05
   +2.30000000E-06  +6.50000000E-07  -4.97800000E-05  -1.11230000E-04  -2.60400000E-05
   +5.43500000E-05  +4.71800000E-05  +1.29920000E-04  -1.33700000E-05  -6.68000000E-06
   -5.52200000E-05  -6.57100000E-05  +1.15000000E-05  -2.19100000E-05  +6.59000000E-05
   +8.75000000E-05  -7.30000000E-06  -1.31310000E-04  -2.49810000E-04  +1.92690000E-04
   +8.78900000E-05  -3.62600000E-05  -6.85900000E-05  +3.13100000E-05  -1.75160000E-04
   +1.38500000E-04  +7.98930000E-04  -1.02711000E-03  -2.05483000E-03  +4.78580000E-04
   -1.48260000E-04  -8.42100000E-05  +1.67060000E-04  +1.25451000E-03  +7.88400000E-05
   -8.74080000E-04  +2.89500000E-05  +3.50332000E-03  +1.15679400E-02  +1.75184000E-02
   -1.55188700E-02  -2.32484000E-03  -6.33205000E-03  +3.95180000E-03  -1.69470000E-04
   -5.22900000E-04  +3.07710000E-04  -2.27700000E-05  +1.33700000E-05  +3.46000000E-06
   -3.04300000E-05  +1.15000000E-05  -2.99300000E-05  -1.22800000E-05  +4.10400000E-05
   -5.05300000E-05  +3.57300000E-05  -5.13700000E-05  -2.14200000E-05  +1.80900000E-05
   -4.76000000E-06  +1.12000000E-06  +3.07000000E-05  -2.57000000E-05  +4.11000000E-06
   -1.05600000E-05  +2.21800000E-05  +1.02600000E-05  -1.78200000E-05  +2.31200000E-05
   -4.08100000E-05  +1.95000000E-05  +5.25500000E-05  -8.66000000E-05  -5.84000000E-06
   +2.16300000E-05  +1.28000000E-05  +9.45000000E-06  +3.24100000E-05  -5.88300000E-05
   +3.26640000E-04  +1.60270000E-04  +2.31990000E-04  -1.74350000E-04  -7.33300000E-05
   -2.29160000E-04  +4.84940000E-04  +1.05270000E-04  -1.08572000E-03  +1.95069410E-01
   +8.40532500E-02  -1.63418260E-01  -2.01704770E-01  -9.85693500E-02  +1.77034660E-01
   -4.09410000E-04  -3.00520000E-04  -1.95510000E-04  +5.96770000E-04  +2.69700000E-04
   +7.90300000E-05  -3.16080000E-04  -2.76730000E-04  +1.94600000E-05  +2.08580000E-04
   +4.15220000E-04  +6.10530000E-04  -8.02770000E-04  -2.57000000E-05  -4.62370000E-04
   -3.14860000E-04  +2.90260000E-04  -4.19010000E-04  +3.47270000E-04  +5.33350000E-04
   -5.79700000E-05  -6.76930000E-04  -4.72340000E-04  +2.14600000E-05  +2.43810000E-04
   -2.61600000E-05  -5.66800000E-05  +3.58780000E-04  -3.00550000E-04  +4.29810000E-04
   -4.93680000E-04  -2.75021000E-03  -1.82045000E-03  +1.16109000E-03  +1.15380000E-04
   +1.27530000E-04  -1.04493000E-03  +8.30210000E-04  -2.75340000E-04  -2.06650000E-04
   -9.58290000E-04  +2.23490000E-03  -1.56246000E-03  +1.03032700E-02  -5.22706000E-03
   -1.30547400E-02  -1.88688000E-02  +1.71761400E-02  +5.30000000E-04  -8.35140000E-04
   -6.30300000E-05  +5.99900000E-05  +5.37000000E-05  +6.47600000E-05  -2.48900000E-05
   -2.23500000E-05  -4.42400000E-05  +8.47000000E-06  -7.84000000E-06  -1.15110000E-04
   +1.40470000E-04  -3.28890000E-04  -5.52400000E-05  +7.75700000E-05  -4.40100000E-05
   +2.95700000E-05  +4.17100000E-05  -1.01340000E-04  -4.00000000E-08  +3.65100000E-05
   +1.13810000E-04  +1.74300000E-05  -4.95000000E-05  +7.49000000E-06  -4.73700000E-05
   -3.54950000E-04  -8.66800000E-05  -3.60600000E-04  +5.35100000E-05  +2.86540000E-04
   -5.35600000E-05  +3.84800000E-05  +4.03400000E-05  -1.41720000E-04  +3.62970000E-04
   +1.42110000E-04  +4.62190000E-04  -2.67100000E-05  -1.50910000E-04  -9.19600000E-05
   +7.84390000E-04  +3.38770000E-04  -5.66520000E-04  -1.01113000E-02  -5.11506000E-03
   +1.14955400E-02  +3.70069000E-03  -4.77876000E-03  -7.46491000E-03  +3.95027500E-02
   +1.77900000E-04  +1.53950000E-04  +9.33300000E-05  -3.63650000E-04  -1.10600000E-04
   +1.56020000E-04  +3.50720000E-04  +3.25330000E-04  +7.78900000E-05  -2.40850000E-04
   -1.89770000E-04  -4.69310000E-04  +2.57370000E-04  +2.89100000E-04  +5.91520000E-04
   +4.48580000E-04  -2.74270000E-04  +6.08200000E-05  -3.81820000E-04  -4.64500000E-04
   -4.50900000E-05  +4.48980000E-04  -1.26216000E-03  -8.14880000E-04  -1.95810000E-04
   +1.58620000E-04  +2.52480000E-04  -2.24570000E-04  +8.85540000E-04  -1.01359000E-03
   +1.04787000E-03  -9.39950000E-04  -3.90637000E-03  +1.03460000E-04  +1.18724000E-03
   +1.05809000E-03  -4.28260000E-04  +2.18040000E-04  -4.19910000E-04  +6.78800000E-04
   -1.48310000E-04  +2.17879000E-03  +3.50545000E-03  +9.41750000E-04  -4.25683000E-03
   -5.03071200E-02  -4.94713800E-02  +4.77561800E-02  +4.08700000E-04  +2.20510000E-04
   -3.75450000E-04  -1.41900000E-05  -3.31000000E-05  -2.46400000E-05  +2.73900000E-05
   +1.54000000E-06  +3.31400000E-05  +2.95800000E-05  -1.54000000E-05  +1.28610000E-04
   -2.00400000E-04  +2.93020000E-04  +9.86900000E-05  -5.32800000E-05  +2.30000000E-06
   -2.52200000E-05  -5.45500000E-05  +9.46700000E-05  -3.80500000E-05  -2.23000000E-06
   -8.22800000E-05  -5.58900000E-05  +6.93300000E-05  -6.29500000E-05  +1.14120000E-04
   +1.64720000E-04  -4.04520000E-04  +6.02830000E-04  +5.58000000E-06  -3.04020000E-04
   +1.11630000E-04  -6.08300000E-05  -2.05480000E-04  +2.66110000E-04  +5.41860000E-04
   +9.95300000E-05  +3.67330000E-04  -9.24800000E-05  -5.52500000E-05  -2.46800000E-04
   -3.16230000E-04  +1.16220000E-04  +9.80100000E-05  +2.03363000E-03  +2.91393000E-03
   -2.97186000E-03  -2.02218000E-03  -2.16943000E-03  +1.05618000E-03  +6.13730700E-02
   +1.84018590E-01  +1.71100000E-05  +6.03800000E-05  +3.98100000E-05  +9.17400000E-05
   -3.97100000E-05  -1.12420000E-04  -5.42700000E-05  +3.62400000E-05  +8.87700000E-05
   +1.03070000E-04  -1.14190000E-04  +2.66900000E-05  +1.32300000E-05  -8.62400000E-05
   -3.46000000E-05  -2.05610000E-04  -2.92100000E-05  -1.15350000E-04  +1.20060000E-04
   +1.00020000E-04  +1.21260000E-04  -5.55000000E-05  +4.91770000E-04  -2.46130000E-04
   -7.81400000E-05  +7.82500000E-05  +1.37930000E-04  +1.75200000E-05  +4.20480000E-04
   -3.85380000E-04  -3.49312000E-03  -1.68680000E-03  +7.28620000E-04  +2.04389000E-03
   -6.40420000E-04  -5.68560000E-04  -1.77860000E-04  +6.13160000E-04  -3.57410000E-04
   -3.27970000E-04  +1.51168000E-03  +1.90340000E-04  -4.02393000E-03  -5.30920000E-03
   +2.75395000E-03  +4.95069100E-02  +4.87428700E-02  -4.06017500E-02  -3.06980000E-04
   +1.77960000E-04  +1.04160000E-04  +3.41900000E-05  -1.70900000E-05  +8.69000000E-06
   +2.18200000E-05  -1.24700000E-05  +3.02600000E-05  +2.60000000E-06  +7.56000000E-06
   +1.86700000E-05  -4.49500000E-05  +6.06000000E-05  +3.08900000E-05  -1.84900000E-05
   -5.27000000E-06  -4.27000000E-06  -5.00300000E-05  +2.16800000E-05  -1.26100000E-05
   +6.47000000E-06  -4.48000000E-06  -1.92900000E-05  +1.75500000E-05  -3.68600000E-05
   +5.09200000E-05  +9.63800000E-05  -3.61950000E-04  +1.79990000E-04  +6.76000000E-06
   -7.90000000E-05  +2.46300000E-05  -2.18200000E-05  -6.25100000E-05  +7.96600000E-05
   -1.36890000E-04  +2.53340000E-04  +3.44060000E-04  -1.25040000E-04  +7.39000000E-06
   -1.15820000E-04  -3.98150000E-04  -2.00970000E-04  +2.74480000E-04  +8.21189000E-03
   +8.95740000E-04  -2.96354000E-03  -5.85128000E-03  +1.04945000E-03  -1.40246000E-03
   +6.64429900E-02  +2.17396920E-01  +3.91335480E-01  +1.10630000E-04  +1.00790000E-04
   +7.50100000E-05  -1.50920000E-04  -1.00250000E-04  -6.45000000E-06  +1.21060000E-04
   +1.50110000E-04  +8.47200000E-05  -1.19270000E-04  -7.09200000E-05  -1.14030000E-04
   +8.29100000E-05  +1.25050000E-04  +7.80200000E-05  +2.21200000E-04  -1.44940000E-04
   -8.96500000E-05  -1.17480000E-04  -2.06390000E-04  +4.32900000E-05  +1.78480000E-04
   -2.79400000E-05  +4.73200000E-05  -7.10100000E-05  +4.33500000E-05  +8.63600000E-05
   -3.32060000E-04  +3.57470000E-04  -3.65620000E-04  +4.83440000E-04  -6.39400000E-05
   +4.14880000E-04  -2.31350000E-04  +3.10800000E-05  -1.66370000E-04  +1.24730000E-04
   -5.28700000E-05  +4.86200000E-05  -1.52270000E-04  +9.64800000E-05  -4.42500000E-04
   -2.43960000E-04  -1.21813000E-03  +1.36094000E-03  +1.39040000E-04  +2.28357000E-03
   -5.93200000E-05  -1.51330000E-04  +5.51800000E-05  +5.96200000E-05  -9.00000000E-06
   -2.18700000E-05  -1.30600000E-05  +1.00200000E-05  +2.14000000E-06  +2.37700000E-05
   -7.08000000E-06  -1.55000000E-06  +6.03000000E-05  -1.16280000E-04  +2.50530000E-04
   +6.96500000E-05  -6.07900000E-05  +1.35400000E-05  -2.46100000E-05  -2.00500000E-05
   +3.40000000E-05  -6.20000000E-06  -7.55000000E-06  -3.50800000E-05  -1.36800000E-05
   +2.24000000E-05  -2.41800000E-05  +4.37600000E-05  +4.57440000E-04  +3.66750000E-04
   +1.81260000E-04  -2.99700000E-05  -3.00010000E-04  +1.32870000E-04  -4.89900000E-05
   -2.44900000E-05  +4.19100000E-05  -4.39400000E-05  -3.14500000E-05  -1.26180000E-04
   +8.73000000E-06  +2.75300000E-05  +3.55900000E-05  -2.42000000E-05  -4.27900000E-05
   +9.58200000E-05  -1.80586000E-03  +8.48900000E-05  -5.20510000E-04  +2.12908000E-03
   +1.40323000E-03  +2.26414000E-03  -2.13346100E-02  -5.24764300E-02  -7.89231500E-02
   +2.05486900E-02  -1.57860000E-04  -1.34450000E-04  -6.61100000E-05  +1.80730000E-04
   +9.49600000E-05  -2.05400000E-05  -1.19470000E-04  -8.69600000E-05  -3.64600000E-05
   -3.48000000E-05  +3.32200000E-05  +1.14770000E-04  +9.66500000E-05  -8.63800000E-05
   -1.76890000E-04  -8.52500000E-05  +8.97200000E-05  +1.10710000E-04  +8.97300000E-05
   +5.46100000E-05  -8.21300000E-05  -1.18070000E-04  +6.36030000E-04  +5.21080000E-04
   +8.59700000E-05  -1.75920000E-04  -3.14170000E-04  -7.93300000E-05  -1.04894000E-03
   +9.45210000E-04  -4.20000000E-06  +9.43740000E-04  +1.57300000E-03  -5.23820000E-04
   -4.78260000E-04  -2.44220000E-04  +3.23380000E-04  -3.82890000E-04  +2.82850000E-04
   -2.22310000E-04  +9.68700000E-05  -1.22157000E-03  -1.28900000E-05  -9.07560000E-04
   +1.28903000E-03  +1.99416000E-03  +3.03133000E-03  -1.11260000E-03  -3.45100000E-05
   -8.59500000E-05  +1.45510000E-04  +1.83200000E-05  +2.22500000E-05  +1.46800000E-05
   -1.32000000E-05  -1.34400000E-05  -1.39000000E-05  -1.24200000E-05  -1.32000000E-06
   -3.66100000E-05  +1.41700000E-04  -5.84000000E-05  -6.33400000E-05  -1.26400000E-05
   +1.17200000E-05  +7.67000000E-06  +4.12400000E-05  -4.57600000E-05  +3.68000000E-05
   -6.36000000E-06  +9.75000000E-06  +5.03300000E-05  -3.60100000E-05  +8.34700000E-05
   -1.21760000E-04  +3.52320000E-04  -2.46560000E-04  -4.31210000E-04  -1.98000000E-06
   +2.01340000E-04  -9.72500000E-05  -1.17900000E-05  +3.34530000E-04  -3.05070000E-04
   -2.70030000E-04  -1.33870000E-04  -2.20670000E-04  +7.52900000E-05  +4.19800000E-05
   +1.25090000E-04  +3.46100000E-05  -3.12000000E-05  -3.43100000E-05  +9.31790000E-04
   +3.59400000E-04  +5.91430000E-04  -1.04980000E-03  -4.23890000E-04  -1.29220000E-03
   -5.16354600E-02  -1.61372950E-01  -2.31799000E-01  +5.09338200E-02  +1.59189620E-01
   +2.98350000E-04  +2.54850000E-04  +8.84700000E-05  -2.56020000E-04  -1.77940000E-04
   -5.09400000E-05  +1.29160000E-04  +5.29700000E-05  -6.40300000E-05  +2.79000000E-06
   -9.27800000E-05  -4.90200000E-05  +2.98400000E-05  -2.12100000E-04  -7.59200000E-05
   -7.25300000E-05  +1.29600000E-05  +1.42660000E-04  +2.44600000E-05  +6.23000000E-05
   +5.78600000E-05  -3.53310000E-04  +3.44130000E-04  -2.54340000E-04  +1.29870000E-04
   +5.20000000E-07  -3.57900000E-05  +2.21470000E-04  -1.44610000E-04  -2.70630000E-04
   -1.92484000E-03  -6.19700000E-05  +4.92750000E-04  +7.59940000E-04  -5.58570000E-04
   +1.63760000E-04  -2.07100000E-04  +3.51000000E-06  +3.53100000E-05  +5.19360000E-04
   +4.61560000E-04  -3.11510000E-04  -5.96230000E-04  -2.53788000E-03  +9.00390000E-04
   +4.51527000E-03  +4.03632000E-03  -3.52878000E-03  -7.59410000E-04  +2.46350000E-04
   +3.21980000E-04  -2.26000000E-05  -4.64200000E-05  -1.44400000E-05  +1.62000000E-05
   +8.37000000E-06  +2.77800000E-05  -2.03300000E-05  +5.70000000E-07  -6.74800000E-05
   -5.18200000E-05  -2.49200000E-05  +2.19800000E-05  +5.71000000E-05  -4.00000000E-06
   +5.26000000E-06  +4.40100000E-05  -5.73700000E-05  +3.66000000E-06  -1.64700000E-05
   +2.98400000E-05  +1.28600000E-05  -3.14700000E-05  +1.42000000E-06  +6.89000000E-06
   -8.73100000E-05  +2.46570000E-04  +4.47470000E-04  -1.47300000E-05  -8.36700000E-05
   +9.26000000E-05  +7.14300000E-05  -1.69020000E-04  -4.37000000E-06  -1.91410000E-04
   -5.76000000E-05  +1.79630000E-04  -3.94200000E-05  -3.05400000E-05  -3.96000000E-06
   +1.44860000E-04  -1.44900000E-04  -2.00000000E-06  -3.20090000E-04  +9.28430000E-04
   -6.98500000E-05  -2.17000000E-05  -8.83730000E-04  -7.15180000E-04  -6.88988000E-02
   -2.06880270E-01  -3.70445920E-01  +7.21894000E-02  +2.16625510E-01  +3.80408700E-01
   +7.23330000E-04  +5.84830000E-04  +2.35110000E-04  -7.36060000E-04  -4.18490000E-04
   -8.62100000E-05  +3.51720000E-04  +1.04850000E-04  -2.03870000E-04  -2.38590000E-04
   -3.93900000E-04  -6.64970000E-04  +1.35180000E-04  +1.68810000E-04  +7.85700000E-05
   -5.86290000E-04  -8.46300000E-05  +4.12810000E-04  -6.05000000E-06  +1.18470000E-04
   +1.58630000E-04  -4.62690000E-04  +1.36141000E-03  -5.41780000E-04  -5.64000000E-06
   -6.79800000E-05  -1.29820000E-04  +2.63000000E-06  +3.92000000E-06  +9.64600000E-05
   +1.00096000E-03  +2.11840000E-03  +1.67149000E-03  +2.30353000E-03  -1.29970000E-04
   -4.31390000E-04  -1.03850000E-04  +7.00320000E-04  -3.54190000E-04  -1.22785000E-03
   +3.32898000E-03  -7.95000000E-05  -1.54728900E-02  -1.64674900E-02  +1.63365700E-02
   -4.91652800E-02  -5.55444000E-03  +9.04878000E-03  -1.81149000E-03  +1.10930000E-04
   +7.94870000E-04  -5.04700000E-05  -9.93400000E-05  -5.51100000E-05  +3.95700000E-05
   +2.53100000E-05  +5.94500000E-05  -1.24600000E-05  -1.14700000E-05  -1.73700000E-05
   +2.01700000E-05  -6.42500000E-05  -3.60200000E-05  +1.14980000E-04  -2.54500000E-05
   +8.50000000E-07  +6.04200000E-05  -1.48000000E-05  +9.52000000E-06  -4.52200000E-05
   -4.20100000E-05  +2.88100000E-05  -1.89800000E-05  +1.94300000E-05  -2.72100000E-05
   +1.77960000E-04  +8.16300000E-05  +1.39320000E-04  -1.79000000E-05  -1.17170000E-04
   +1.87900000E-05  +3.82600000E-05  +1.98100000E-05  -1.48170000E-04  -3.67250000E-04
   +1.41950000E-04  -1.03420000E-04  -5.87700000E-05  +1.64800000E-05  +6.94700000E-05
   -3.92100000E-05  -4.99970000E-04  +3.03750000E-04  +3.36197000E-03  +1.04005000E-03
   -3.01813000E-03  -4.36350000E-03  +2.63887000E-03  +1.54374000E-03  +2.53068000E-03
   +3.57618800E-02  -3.24610100E-02  +4.40170000E-04  -8.57530000E-04  -5.26791000E-03
   +6.34888800E-02  +2.64950000E-04  +2.77790000E-04  +3.70700000E-05  -1.01350000E-04
   -1.91970000E-04  -2.36510000E-04  -1.63880000E-04  -2.36840000E-04  -1.43940000E-04
   +2.38800000E-04  +1.75300000E-05  +3.43230000E-04  +5.90920000E-04  -9.02740000E-04
   -3.08670000E-04  -3.51990000E-04  +1.34220000E-04  +2.55160000E-04  +3.33660000E-04
   +4.79780000E-04  +6.61600000E-05  -2.10201000E-03  +1.73240000E-03  +2.20970000E-04
   +3.81550000E-04  -8.12500000E-05  -2.35750000E-04  +5.13200000E-04  -7.29750000E-04
   +3.90670000E-04  -1.71915500E-02  -6.69468000E-03  +1.36993000E-02  +3.18045000E-03
   -4.56810000E-03  +1.11502000E-03  +7.99230000E-04  -7.14210000E-04  -6.81600000E-05
   +2.23224000E-03  +3.01181000E-03  -3.56974000E-03  +5.00870000E-04  -7.52557000E-03
   +7.52841000E-03  +2.62394900E-02  -1.49063000E-03  -2.71733800E-02  -1.85104000E-03
   +4.79120000E-04  +8.52120000E-04  -1.19600000E-05  -6.20400000E-05  +1.77800000E-05
   +9.50000000E-07  -6.80000000E-07  +1.82000000E-05  -7.04900000E-05  +3.83500000E-05
   -2.42430000E-04  +6.90600000E-05  -2.32950000E-04  -6.72100000E-05  +1.42410000E-04
   -4.01000000E-05  +2.36500000E-05  +1.25820000E-04  -1.45450000E-04  +2.09200000E-05
   -2.91300000E-05  +1.83270000E-04  +7.11800000E-05  -1.42890000E-04  +6.66200000E-05
   -1.13350000E-04  +8.48500000E-05  -3.14210000E-04  -6.01900000E-04  +1.54000000E-05
   +2.11870000E-04  +8.26200000E-05  +1.32310000E-04  +1.38130000E-04  -3.83840000E-04
   -1.54356000E-03  -3.87360000E-04  +5.37080000E-04  -8.03400000E-05  +2.96300000E-05
   +2.10920000E-04  +2.39160000E-04  -5.14330000E-04  +1.35060000E-04  +2.44753000E-03
   +2.88407000E-03  -3.54100000E-03  -1.85149000E-03  -1.64261000E-03  +4.11074000E-03
   +1.19725300E-02  +2.56464500E-02  -3.14401200E-02  -1.51630000E-03  +4.80160000E-04
   -1.11479000E-02  -2.34974200E-02  -9.33574000E-03  -3.73470000E-04  -3.69020000E-04
   -1.17220000E-04  +2.61060000E-04  +2.05910000E-04  +6.89800000E-05  -1.78880000E-04
   -2.31600000E-04  +8.98900000E-05  -6.99100000E-05  +3.68850000E-04  +1.28560000E-04
   -4.28910000E-04  +8.55630000E-04  +1.48520000E-04  +2.99710000E-04  -2.28700000E-04
   -2.36980000E-04  -1.41720000E-04  -2.02090000E-04  -8.82500000E-05  +8.08520000E-04
   -2.27974000E-03  -8.32160000E-04  -3.30510000E-04  -9.88000000E-06  -2.29000000E-05
   -3.71180000E-04  -1.99150000E-04  +2.28590000E-04  +1.37837200E-02  +8.68819000E-03
   -5.11361000E-03  -5.80404000E-03  +4.71322000E-03  +3.09204000E-03  +5.36640000E-04
   -2.21669000E-03  +2.33150000E-04  +1.80671000E-03  -3.37846000E-03  +3.37582000E-03
   +1.54788300E-02  +1.41104700E-02  -6.79552000E-03  -3.03026000E-02  -3.50980000E-02
   +3.21860000E-03  +2.17684000E-03  -2.90170000E-04  -1.59974000E-03  -9.40000000E-06
   +7.35800000E-05  +1.35000000E-06  -4.64600000E-05  +5.23000000E-06  -5.78800000E-05
   +8.80300000E-05  +5.01900000E-05  +8.47200000E-05  +7.15300000E-05  +8.49300000E-05
   -1.86200000E-05  -1.20120000E-04  +3.88600000E-05  -2.15700000E-05  -4.04100000E-05
   +1.36560000E-04  -9.80000000E-07  +2.63200000E-05  -1.12050000E-04  -1.93800000E-05
   +6.37500000E-05  +3.15800000E-05  -1.42800000E-05  +1.45730000E-04  -3.09600000E-05
   -4.59850000E-04  +3.52600000E-05  +1.65000000E-06  -6.83100000E-05  -9.03900000E-05
   +2.84260000E-04  +2.74800000E-05  +1.05361000E-03  -6.66000000E-05  -8.61430000E-04
   +2.65520000E-04  +6.07800000E-05  +7.76800000E-05  -7.97600000E-05  +6.48570000E-04
   -1.41150000E-04  -3.86428000E-03  -1.73740000E-04  -9.93290000E-04  +2.09089000E-03
   +6.88920000E-04  -6.00140000E-04  -1.27938500E-02  -5.09545200E-02  +2.08162500E-02
   +3.43410000E-03  +1.52563400E-02  -7.44585000E-03  +1.26191000E-02  +4.95376300E-02
   -6.08253000E-03
end_hess

