# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -1036.20965760   # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -3.36406795E+00  -4.50813475E-01  -2.33757637E+00
   006   -3.13161860E+00  +1.65690772E+00  -7.67120318E-01
   006   -4.99474186E+00  +1.97611739E+00  +1.05324105E+00
   006   -6.98644538E+00  +2.86844137E-01  +1.31814316E+00
   006   -7.17329504E+00  -1.79021514E+00  -2.64866819E-01
   006   -5.33242351E+00  -2.15968927E+00  -2.10608805E+00
   006   -8.60041978E-01  +3.45151192E+00  -1.06380076E+00
   006   -7.72646908E-01  +4.36984895E+00  -3.82329958E+00
   008   -9.07195097E+00  -3.50782538E+00  -1.09992582E-01
   006   +1.58061131E+00  +2.05210770E+00  -3.33165353E-01
   006   +2.89943471E+00  +6.49164112E-01  -2.02327568E+00
   006   +5.04320914E+00  -8.54897821E-01  -1.38945997E+00
   006   +6.20470301E+00  -2.91587167E-01  +9.92062529E-01
   006   +5.01065391E+00  +1.12025496E+00  +2.76289801E+00
   006   +2.45315421E+00  +2.10208793E+00  +2.34081963E+00
   008   +8.55293924E+00  -1.20922563E+00  +1.40654982E+00
   008   +6.72470887E+00  -1.62505970E+00  -3.33236565E+00
   006   -1.19337935E+00  +5.83034218E+00  +5.57810125E-01
   008   +4.87613010E-01  +5.63023877E-01  +3.94987724E+00
   001   -1.02033841E+01  -3.04975551E+00  +1.22434863E+00
   001   -8.39528981E+00  +5.99318348E-01  +2.77223989E+00
   001   -4.91103779E+00  +3.55564286E+00  +2.34197304E+00
   001   -1.94010300E+00  -8.19796289E-01  -3.75652312E+00
   001   -5.47336858E+00  -3.77563974E+00  -3.34968814E+00
   001   -2.49542293E+00  +5.41167818E+00  -4.26695207E+00
   001   +8.43884069E-01  +5.61723264E+00  -4.09994459E+00
   001   -6.26860629E-01  +2.83716823E+00  -5.18585853E+00
   001   -1.36967215E+00  +5.41458925E+00  +2.56456599E+00
   001   +4.35692254E-01  +7.06765161E+00  +3.09512541E-01
   001   -2.87565722E+00  +6.86860389E+00  -2.63707073E-02
   001   +2.21384128E+00  +3.94892054E+00  +3.21306857E+00
   001   +5.96471908E+00  +1.55305086E+00  +4.51965203E+00
   001   +3.57140925E+00  -3.43681251E+00  -7.08123654E-01
   001   +2.32170619E+00  +5.82400049E-01  -3.98702397E+00
   001   +9.08735456E+00  -1.95049062E+00  -1.68979611E-01
   001   +7.40933185E+00  -1.51305848E-01  -4.13609170E+00
   001   +1.29314188E+00  +2.86230167E-01  +5.55151424E+00
   008   -1.00022795E+00  -3.53271981E+00  +2.21088256E+00
   001   -3.88917500E-01  -1.79103197E+00  +2.93395217E+00
   001   -2.38186289E+00  -3.17987553E+00  +1.06842782E+00
   008   +2.50309982E+00  -5.10090089E+00  -2.21619644E-01
   001   +3.61226017E+00  -6.20622273E+00  +6.85056750E-01
   001   +6.42458425E-01  -4.34506629E+00  +1.08304258E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -2.26000000E-06  -3.73000000E-06  +6.90000000E-07
   +1.14700000E-05  -1.08100000E-05  +6.01000000E-06
   -4.27000000E-06  +3.22000000E-06  -3.47000000E-06
   +2.20000000E-07  +2.32000000E-06  +2.54000000E-06
   -3.81000000E-06  -1.10000000E-07  +1.94000000E-06
   +8.30000000E-07  -1.99000000E-06  +1.69000000E-06
   -2.54000000E-06  +2.50000000E-06  -8.95000000E-06
   +2.52000000E-06  +7.33000000E-06  +4.57000000E-06
   +5.97000000E-06  -1.72000000E-06  +5.62000000E-06
   -2.19000000E-06  -5.81000000E-06  +9.40000000E-07
   -7.91000000E-06  -5.78000000E-06  +5.38000000E-06
   +1.52800000E-05  +1.07600000E-05  +7.27000000E-06
   +1.33400000E-05  +2.19500000E-05  -3.53000000E-06
   -4.48000000E-06  -7.48000000E-06  +9.41000000E-06
   +1.23700000E-05  +1.23300000E-05  +2.96000000E-06
   -3.91000000E-06  +3.96000000E-06  +4.02000000E-06
   +3.60000000E-07  -2.02000000E-06  -5.40000000E-06
   -7.25000000E-06  -5.04000000E-06  +4.49000000E-06
   +4.28000000E-06  -1.00500000E-05  -4.08000000E-06
   -3.12000000E-06  +3.84000000E-06  +1.74000000E-06
   +5.60000000E-07  +1.59000000E-06  +1.35000000E-06
   +4.60000000E-07  +5.00000000E-08  +7.10000000E-07
   -9.73000000E-06  +2.00000000E-07  -9.07000000E-06
   -1.74000000E-06  +6.00000000E-08  +1.12000000E-06
   +1.32000000E-06  +2.82000000E-06  +1.04000000E-06
   +2.72000000E-06  -4.98000000E-06  -2.15000000E-06
   -3.69000000E-06  -1.37000000E-06  -2.90000000E-07
   -3.44000000E-06  -1.69000000E-06  +2.70000000E-07
   +2.85000000E-06  -1.50000000E-06  +1.74000000E-06
   +4.28000000E-06  +2.99000000E-06  -4.05000000E-06
   -1.39000000E-06  +2.10000000E-06  -5.00000000E-06
   -5.20000000E-07  -4.57000000E-06  +6.50000000E-07
   +2.82000000E-06  +1.62300000E-05  -2.90400000E-05
   -1.90000000E-06  -1.19000000E-06  +1.70000000E-07
   +1.78000000E-06  -5.05000000E-06  -7.73000000E-06
   +2.16000000E-06  +1.04000000E-06  -2.74000000E-06
   +1.65200000E-05  +1.30800000E-05  -7.77000000E-06
   -1.85000000E-06  +1.41000000E-05  +3.39600000E-05
   -2.61800000E-05  -1.68400000E-05  -3.05700000E-05
   +3.10000000E-06  +5.23000000E-06  -3.35000000E-06
   -3.43100000E-05  -4.46400000E-05  +2.36300000E-05
   +6.57000000E-06  -5.10000000E-06  -8.18000000E-06
   +1.47400000E-05  +1.37900000E-05  +1.14300000E-05
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.72952660E-01  +1.53400130E-01  +5.22108290E-01  -2.17034510E-01  +1.82079470E-01
   +4.79279470E-01  -1.13258670E-01  -5.01686600E-02  -4.34376000E-03  +5.01804100E-01
   -5.97458000E-03  -2.24435850E-01  -1.23707410E-01  +1.09844830E-01  +4.97135830E-01
   +2.90710300E-02  -8.77165100E-02  -1.71105000E-01  -1.72994500E-01  +1.66430440E-01
   +4.69420920E-01  +3.25400600E-02  +6.18512300E-02  +2.86423400E-02  -2.11966840E-01
   -2.36397400E-02  +9.88223200E-02  +5.23594040E-01  +2.71992000E-02  +1.43767200E-02
   -1.82585700E-02  +1.97228600E-02  -1.17938950E-01  -5.88392900E-02  +1.60947400E-01
   +5.66450080E-01  +2.53046000E-03  -4.69980400E-02  -3.17245200E-02  +1.37165280E-01
   -2.11651500E-02  -2.00011880E-01  -1.81150760E-01  +2.22314430E-01  +4.84500850E-01
   -1.76065800E-02  -2.82077900E-02  -1.09179900E-02  -3.83877100E-02  +5.07784000E-03
   +4.17634800E-02  -2.31696330E-01  -1.46928320E-01  +2.03893600E-02  +5.54893290E-01
   -2.65776100E-02  -5.42950000E-02  -1.80963100E-02  -2.88894200E-02  +4.21886600E-02
   +5.42321500E-02  -1.01137780E-01  -1.97461810E-01  -3.12253200E-02  +1.61775600E-01
   +5.27182450E-01  -9.64479000E-03  -1.83906600E-02  -9.15271000E-03  +1.40594200E-02
   +2.48944300E-02  +1.65880400E-02  +5.95184900E-02  +8.93997000E-03  -1.03136460E-01
   -2.24783670E-01  +1.99934100E-01  +4.83024070E-01  -4.25335000E-02  -3.19002600E-02
   +1.15153600E-02  -1.06012000E-02  +2.28249900E-02  +2.28298100E-02  +2.59649700E-02
   -1.36857700E-02  -3.24557200E-02  -1.16659110E-01  -4.78954700E-02  +1.18455000E-03
   +5.59857710E-01  +5.64420000E-03  +4.63704900E-02  +2.97002100E-02  +2.06187100E-02
   -2.65602600E-02  -3.47725000E-02  -5.33544700E-02  -4.14237000E-02  +9.47464000E-03
   +8.09469000E-03  -2.29976490E-01  -1.41949250E-01  +1.59698330E-01  +5.51730150E-01
   +4.16192500E-02  +6.22944800E-02  +1.74582600E-02  +2.11991400E-02  -3.55371500E-02
   -5.28268400E-02  -6.33135600E-02  -2.41808600E-02  +3.59263900E-02  +4.54234000E-02
   -9.66707100E-02  -1.88404720E-01  -1.98998830E-01  +1.92942560E-01  +4.90030000E-01
   -2.38296330E-01  -1.10273280E-01  +5.78651400E-02  +2.13926000E-02  -4.96710200E-02
   -5.18151000E-02  -5.27771800E-02  -1.61068500E-02  +2.87512800E-02  +3.23886500E-02
   +5.57267200E-02  +2.50425700E-02  -1.92022580E-01  -1.50931100E-02  +8.97960200E-02
   +5.33242180E-01  -1.53933620E-01  -2.04073860E-01  +5.63542000E-03  -1.56640600E-02
   -3.62027800E-02  -2.37675400E-02  -1.74445300E-02  -8.84976000E-03  +1.00949500E-02
   +2.39381700E-02  +1.37541000E-02  -1.52021400E-02  +3.44530500E-02  -1.21678610E-01
   -7.27834400E-02  +1.80099760E-01  +5.74142510E-01  +2.23441400E-02  -3.27948800E-02
   -1.03508190E-01  -2.60623900E-02  +6.09414000E-03  +3.39059000E-02  +2.82238900E-02
   +1.04492400E-02  -1.82362700E-02  +3.97200000E-04  -4.25170100E-02  -2.66964500E-02
   +1.33737910E-01  -2.93938700E-02  -2.05721460E-01  -1.85352100E-01  +2.25044320E-01
   +4.74565650E-01  -1.38898000E-03  -8.94620000E-03  -6.57283000E-03  -1.21393630E-01
   -3.65559400E-02  +1.24231500E-02  -1.55967300E-02  -1.15461700E-02  +4.59194000E-03
   +1.93121000E-03  -8.39550000E-04  +3.10686000E-03  -1.62022000E-03  -3.15100000E-05
   +1.12167000E-03  +3.51726000E-03  +1.37589000E-03  +2.47230000E-03  +4.42734640E-01
   -2.05663200E-02  -1.68606100E-02  +1.47871000E-03  -4.68716100E-02  -1.12521040E-01
   -3.18631000E-03  -7.31340000E-04  +6.69109000E-03  +3.53135000E-03  +7.24100000E-05
   +2.40203000E-03  -3.73218000E-03  -3.28510000E-04  -1.18976000E-03  -4.41550000E-04
   -1.77810000E-04  -6.35260000E-04  -4.55961000E-03  -7.47892000E-03  +4.77957360E-01
   -1.63079100E-02  -9.44520000E-03  +5.96423000E-03  +1.36426500E-02  -3.11809000E-03
   -8.10916400E-02  +1.58542600E-02  +1.36267400E-02  +2.80653000E-03  +4.37232000E-03
   -3.70740000E-03  +4.06230000E-04  +1.39500000E-04  -2.15020000E-04  -8.18360000E-04
   +2.07383000E-03  -4.69542000E-03  -9.47580000E-04  -3.52590000E-03  +2.27099100E-02
   +4.82230970E-01  +8.91300000E-05  -1.49476000E-03  +9.83950000E-04  -5.99266000E-03
   -1.05024800E-02  +2.69685900E-02  -1.19922000E-03  -2.60960000E-03  -7.39570000E-04
   -1.67280000E-03  +4.21900000E-05  -6.49090000E-04  +2.20980000E-04  +8.43290000E-04
   +5.74270000E-04  +1.47160000E-04  +5.56020000E-04  +1.89060000E-04  -7.14371100E-02
   -1.21087000E-03  +4.57026000E-03  +5.87279510E-01  -1.01495000E-03  -7.71290000E-04
   +1.06237000E-03  -6.46274000E-03  -9.82023000E-03  +2.23345500E-02  -4.46900000E-05
   -2.01525000E-03  -6.51190000E-04  -9.54060000E-04  +3.44500000E-05  -5.62160000E-04
   +1.87100000E-04  +4.96660000E-04  +4.97060000E-04  +1.72460000E-04  +6.17940000E-04
   +1.24930000E-04  +4.98250000E-04  -8.57778500E-02  +2.94928500E-02  +1.39901000E-03
   +5.68157110E-01  -1.17317000E-03  -5.68930000E-04  +2.77700000E-05  +9.14193000E-03
   +7.96077000E-03  -7.22213000E-03  -1.43914000E-03  +6.62900000E-05  +2.51400000E-05
   +1.44810000E-04  +1.47300000E-05  -3.74400000E-05  +4.24150000E-04  +6.49600000E-05
   +5.84500000E-05  -5.45700000E-05  -4.43860000E-04  -1.88560000E-04  +3.19799000E-03
   +2.46019900E-02  -1.59674010E-01  +8.20820000E-04  +5.04223800E-02  +4.80696050E-01
   +2.79008000E-03  +2.36407000E-03  +3.96036000E-03  -4.82430000E-04  -2.83173000E-03
   -2.22174000E-03  +1.06810000E-03  -1.66339000E-03  +4.30839000E-03  -7.81898000E-03
   -1.56596700E-02  +8.54940000E-04  -2.01739770E-01  -1.39644290E-01  +1.67390600E-02
   -3.96545300E-02  -2.95938500E-02  +1.07826700E-02  +6.00150000E-04  +1.20776000E-03
   -1.30820000E-04  -8.06960000E-04  -4.93040000E-04  -4.80330000E-04  +4.62264960E-01
   -1.11268000E-03  -3.74296000E-03  -5.45593000E-03  -2.18844000E-03  +6.62730000E-04
   +4.06306000E-03  +4.21355000E-03  +2.68389000E-03  -8.01964000E-03  -4.26752500E-02
   -3.22324800E-02  +7.01500000E-05  -1.04753890E-01  -1.86085900E-01  -3.09556400E-02
   -5.32277000E-03  +9.41011000E-03  +3.68886000E-03  +7.41930000E-04  +7.82300000E-04
   +4.77600000E-04  -7.81640000E-04  -4.95000000E-04  -3.75690000E-04  +9.68442400E-02
   +2.80945610E-01  +9.25530000E-04  -8.75091000E-03  -3.07911000E-03  -2.34260000E-03
   +3.77161000E-03  +3.65809000E-03  +8.73883000E-03  -3.01766000E-03  -2.23616000E-03
   -2.06638300E-02  -2.14610300E-02  +9.18014000E-03  +4.45281300E-02  -3.25886000E-03
   -8.32037700E-02  +3.42273900E-02  +2.66092500E-02  +9.89370000E-04  -5.19370000E-04
   +2.00930000E-04  -1.15050000E-04  +8.44600000E-05  +3.77900000E-05  +1.50100000E-05
   -2.83020910E-01  +1.31896280E-01  +3.75012010E-01  -1.34003000E-03  +8.09430000E-04
   +3.82520000E-04  -3.66948600E-02  +4.82616000E-03  -3.88974000E-03  +6.01060000E-04
   -2.88360000E-04  -2.10547000E-03  -2.09320000E-04  -2.16549000E-03  +6.59920000E-04
   -2.72820000E-04  +1.20065000E-03  +1.21375000E-03  +1.16562000E-03  +1.03869000E-03
   -2.03900000E-05  -1.30040800E-01  +4.48174000E-02  -2.26812200E-02  -3.21924000E-03
   +3.05423000E-03  -7.21734000E-03  -5.94230000E-04  -5.76700000E-04  -4.26000000E-05
   +4.74395540E-01  -1.98591000E-03  -1.31260000E-03  -1.41917000E-03  -7.28002000E-03
   +1.11829600E-02  -3.05703000E-03  -5.73780000E-04  -7.47900000E-04  -5.77480000E-04
   -1.37340000E-04  -9.40170000E-04  +2.59800000E-04  +1.41760000E-04  +7.14710000E-04
   +4.92980000E-04  +4.10050000E-04  +3.72640000E-04  +1.41480000E-04  +3.50483600E-02
   -8.93143900E-02  +3.15475000E-03  +9.14909000E-03  -6.30301000E-03  +6.46339000E-03
   -7.07310000E-04  -5.65670000E-04  +2.83800000E-05  -2.15080640E-01  +3.56417040E-01
   -1.32100000E-05  -8.74980000E-04  +3.40100000E-05  +9.91570000E-04  -3.82260000E-03
   +2.74685000E-03  +1.00102000E-03  +8.20360000E-04  -3.82900000E-05  -4.55920000E-04
   +2.65230000E-04  -2.51870000E-04  -9.12550000E-04  -3.62460000E-04  +1.47880000E-04
   +3.26340000E-04  +5.19030000E-04  -4.06970000E-04  -1.95402300E-02  +4.86633000E-03
   -9.24774400E-02  -2.80009100E-02  +1.69615000E-02  -1.11822100E-02  +1.05844000E-03
   +8.31020000E-04  -5.80900000E-05  -4.96776900E-02  +1.35855180E-01  +6.05159600E-01
   -5.69400000E-04  +1.33630000E-04  -6.02110000E-04  +6.84220000E-04  +2.75300000E-05
   +7.50130000E-04  -1.76500000E-05  -4.66700000E-05  +3.17130000E-04  +4.56800000E-05
   +5.72850000E-04  +7.04500000E-05  -2.83050000E-04  -6.23740000E-04  -2.97490000E-04
   -2.35140000E-04  +1.54140000E-04  -1.96200000E-05  -1.97269400E-02  +1.82980000E-02
   +1.62394500E-02  -6.17080000E-04  -2.06220000E-04  -2.76160000E-04  +6.80190000E-04
   +6.57520000E-04  -6.70800000E-05  -1.84978880E-01  +1.05497840E-01  +9.46230200E-02
   +5.10837360E-01  -1.83870000E-03  +2.07600000E-04  +2.38700000E-04  -2.84828000E-03
   +1.14586000E-03  -1.00036000E-03  +3.39130000E-04  +1.93210000E-04  -8.84330000E-04
   -2.48860000E-04  -1.18816000E-03  -1.03930000E-04  +4.31740000E-04  +1.13117000E-03
   +8.09320000E-04  +5.58310000E-04  +3.11740000E-04  -8.09300000E-05  +1.37880300E-02
   -1.26437800E-02  -7.47093000E-03  +1.34196000E-03  +5.96890000E-04  +3.28200000E-04
   -1.15954000E-03  -1.08599000E-03  +1.00380000E-04  +1.22815430E-01  -1.60210660E-01
   -1.06911130E-01  -2.41555160E-01  +3.42410010E-01  -1.06016000E-03  +4.15930000E-04
   +1.12441000E-03  -1.10297000E-03  +2.62350000E-04  -4.61940000E-04  -6.34700000E-05
   -2.27840000E-04  -2.22530000E-04  -3.40000000E-05  -4.78900000E-04  -2.76000000E-06
   +1.11050000E-04  +4.76070000E-04  +3.13520000E-04  +2.67330000E-04  +8.77400000E-05
   -5.45250000E-04  +1.32951000E-03  +3.21905000E-03  +1.09673800E-02  -7.46090000E-04
   +1.20757000E-03  +3.12950000E-04  -3.62300000E-04  -4.18770000E-04  +7.41000000E-06
   +1.15068460E-01  -1.31122700E-01  -2.65012760E-01  +2.08735500E-02  +1.22446750E-01
   +7.29348660E-01  -4.79800000E-05  -1.77960000E-04  +2.47620000E-04  -4.47240000E-04
   +9.86330000E-04  -2.55910000E-04  -1.01860000E-04  -2.62290000E-04  -7.48100000E-05
   -1.13600000E-05  -2.95330000E-04  +1.44660000E-04  +9.97900000E-05  +1.96710000E-04
   +1.76000000E-05  +4.11100000E-05  -5.35100000E-05  -6.00900000E-05  +4.13211000E-03
   +2.24970000E-04  +1.27796000E-03  +1.73780000E-04  +1.83600000E-05  +8.37370000E-04
   -2.39170000E-04  -1.84620000E-04  +3.74500000E-05  -1.64448100E-02  +2.77970400E-02
   +1.05601600E-02  -2.07430360E-01  +1.17253920E-01  -6.07141500E-02  +5.19235520E-01
   +1.26440000E-04  -2.35410000E-04  -6.27500000E-04  +1.04224000E-03  -2.93814000E-03
   +1.16979000E-03  +9.00260000E-04  +4.79150000E-04  +3.90110000E-04  -2.97830000E-04
   +4.90020000E-04  +1.21500000E-05  -7.58880000E-04  -7.16640000E-04  -2.16330000E-04
   -6.80000000E-07  +8.41040000E-04  -5.71290000E-04  -1.34800000E-03  +6.30239000E-03
   -1.86675000E-03  +7.45010000E-04  -5.14740000E-04  -1.10897000E-03  +1.24990000E-03
   +1.19139000E-03  -8.97800000E-05  +2.49671100E-02  -2.92921300E-02  -3.60384100E-02
   +7.50919600E-02  -8.74146400E-02  +4.12208900E-02  -1.73235990E-01  +2.29976990E-01
   -1.47680000E-04  -3.64640000E-04  -2.62580000E-04  -1.22808000E-03  +2.49238000E-03
   -5.88640000E-04  -2.58630000E-04  -4.01570000E-04  -3.48210000E-04  -1.14560000E-04
   -7.49730000E-04  +5.29600000E-05  +7.98120000E-04  +8.93180000E-04  +1.83860000E-04
   -2.41600000E-05  -2.16000000E-05  +4.46520000E-04  +1.92662000E-03  -6.40713000E-03
   -1.71608000E-03  -1.57551000E-03  +4.82540000E-04  +4.16400000E-05  -1.29291000E-03
   -1.06565000E-03  +1.50480000E-04  +8.69149000E-03  +2.78628000E-03  +2.92530000E-02
   -1.82478300E-02  +5.22333000E-03  -1.19586260E-01  +4.11818400E-02  +5.68386800E-02
   +5.52706660E-01  +1.75740000E-04  -2.43900000E-05  +5.32400000E-05  +8.14200000E-05
   -5.81310000E-04  +1.54290000E-04  +6.69900000E-05  +8.84300000E-05  +3.22200000E-05
   +4.37400000E-05  +2.03030000E-04  +1.36100000E-04  -5.79870000E-04  -5.00040000E-04
   +3.34700000E-05  +1.39400000E-04  -9.83500000E-05  -5.11300000E-05  +1.13910000E-04
   +9.66910000E-04  +1.07230000E-04  +2.56160000E-04  -1.48500000E-04  -2.47200000E-04
   +6.71870000E-04  +5.32090000E-04  -6.71900000E-05  +3.01603000E-03  -2.40870000E-04
   +1.04640000E-03  -1.69490900E-02  -9.89894000E-03  -2.51741200E-02  -1.15326800E-01
   +3.90026000E-03  -9.15464700E-02  +6.21873740E-01  +1.93100000E-05  +3.21950000E-04
   +1.90570000E-04  +5.87150000E-04  -9.26410000E-04  -5.88400000E-05  -1.17990000E-04
   +1.52680000E-04  +1.15900000E-04  +1.52090000E-04  +3.19020000E-04  -2.38820000E-04
   +2.23190000E-04  -8.40000000E-07  -1.39510000E-04  -2.12080000E-04  -1.06070000E-04
   +1.09700000E-05  +2.88510000E-04  +9.56610000E-04  -1.33123000E-03  +9.06800000E-05
   +4.50500000E-05  -1.76170000E-04  -6.93400000E-05  -8.07000000E-05  -1.86800000E-05
   +1.74183000E-03  -2.99767000E-03  +2.24546000E-03  +4.09610000E-03  +1.63260000E-04
   +1.63408700E-02  +1.12146600E-02  -5.56242000E-02  -3.84416800E-02  -2.13152150E-01
   +3.60267370E-01  +9.39700000E-05  +4.39040000E-04  +2.23730000E-04  +1.06528000E-03
   -2.38601000E-03  +3.38440000E-04  +1.04310000E-04  +4.42540000E-04  +3.03370000E-04
   +1.78980000E-04  +7.03960000E-04  -2.78060000E-04  -4.22990000E-04  -5.80400000E-04
   -1.37200000E-04  -1.01870000E-04  -1.38770000E-04  -1.62870000E-04  -9.69190000E-04
   +3.10527000E-03  -2.46628000E-03  +3.90760000E-04  -2.43210000E-04  -5.88320000E-04
   +7.98540000E-04  +6.02690000E-04  -1.26860000E-04  +9.82668000E-03  -1.34479000E-02
   -1.32379900E-02  -4.86306700E-02  +1.54248100E-02  -7.07848000E-03  -1.87362600E-02
   -1.39505200E-02  -2.18871250E-01  -8.76966000E-03  +1.93944090E-01  +6.51027790E-01
   +5.91100000E-05  +3.96780000E-04  +1.16830000E-04  +3.38940000E-04  -1.08925000E-03
   +9.59300000E-05  -1.64000000E-05  +2.13010000E-04  +5.89300000E-05  +1.30760000E-04
   +3.86790000E-04  -2.62880000E-04  +2.10130000E-04  -2.70600000E-05  -1.40230000E-04
   -2.07470000E-04  -1.53300000E-05  -3.84800000E-05  +1.04756000E-03  +1.00684000E-03
   -9.28730000E-04  -1.47200000E-04  +3.71800000E-05  -1.88590000E-04  +7.30000000E-06
   +1.30800000E-05  -3.68200000E-05  -8.00577000E-03  -1.62278000E-03  -8.49725000E-03
   -9.00743000E-03  +2.64421000E-03  -2.45720000E-03  +3.25257200E-02  +1.25400500E-02
   +6.18657000E-03  -1.68832470E-01  +7.54413700E-02  +7.28600300E-02  +5.64338620E-01
   +2.14800000E-05  -7.74000000E-05  -1.12510000E-04  -1.61080000E-04  +6.38290000E-04
   -4.16000000E-06  -4.51400000E-05  -1.15460000E-04  -1.73420000E-04  -3.12700000E-05
   -6.15000000E-05  +1.31740000E-04  +8.29000000E-06  -2.04000000E-06  +2.90500000E-05
   +6.61300000E-05  +1.01740000E-04  -8.77000000E-06  +9.95500000E-04  -1.86320000E-04
   -1.03155000E-03  -5.99510000E-04  +3.92220000E-04  +2.28520000E-04  -4.14600000E-05
   +1.70600000E-05  +3.88000000E-06  -5.18908000E-03  +7.62064000E-03  +6.20216000E-03
   +1.12133100E-02  -5.21910000E-03  +7.19510000E-04  -1.49051300E-02  -9.71539000E-03
   -2.79882300E-02  +1.00203410E-01  -1.59863190E-01  -1.29447340E-01  -1.76146400E-01
   +3.06943030E-01  -1.10000000E-06  -4.45030000E-04  -1.96040000E-04  +3.02990000E-04
   +1.22807000E-03  -2.91200000E-05  -1.58000000E-06  -2.56110000E-04  -8.03300000E-05
   -1.49740000E-04  -3.42990000E-04  +2.08840000E-04  -5.09000000E-06  +1.57680000E-04
   +1.09880000E-04  +1.15950000E-04  +2.45200000E-05  +1.21460000E-04  -2.64220000E-04
   -1.80890000E-03  -3.99280000E-03  -1.21478000E-03  +5.47120000E-04  +2.01290000E-04
   -2.12320000E-04  -1.81440000E-04  +6.96000000E-05  -2.89474900E-02  +1.71474100E-02
   +3.34519000E-03  +1.34290900E-02  -1.12308400E-02  -1.91619000E-03  -1.02508200E-02
   -2.43978400E-02  -3.26370000E-02  +1.03550060E-01  -1.45084850E-01  -2.74964040E-01
   +4.26299200E-02  +2.40920400E-01  +6.53382370E-01  -2.16960000E-04  -1.36755000E-03
   -2.09200000E-04  -1.21400000E-05  +3.17792000E-03  -5.76850000E-04  -3.11320000E-04
   -6.82540000E-04  -1.35100000E-05  -3.88270000E-04  -9.31920000E-04  +5.80320000E-04
   -5.64920000E-04  +1.86130000E-04  +5.18260000E-04  +6.52580000E-04  -5.01500000E-05
   +8.05300000E-05  -5.89565000E-03  -4.47640000E-04  -2.46527200E-02  -4.18719000E-03
   +1.63312000E-03  +8.34860000E-04  -5.40600000E-05  -1.24770000E-04  +8.00100000E-05
   -1.05089890E-01  +2.00665700E-02  -4.77168400E-02  +2.31539300E-02  -1.18836100E-02
   +1.42274300E-02  -2.28389400E-02  -1.25458900E-02  -1.57630000E-02  -2.32997700E-02
   +3.45625600E-02  +3.69865000E-02  -1.95790550E-01  +4.48121800E-02  -4.47985400E-02
   +3.95019100E-01  -1.45180000E-04  -6.13550000E-04  -2.45830000E-04  +8.43000000E-05
   -3.43160000E-04  +3.76120000E-04  +1.78680000E-04  +1.91860000E-04  +1.85170000E-04
   -2.20920000E-04  -5.46820000E-04  +1.77840000E-04  -5.31850000E-04  -2.29700000E-05
   +2.94220000E-04  +3.30130000E-04  +2.36500000E-05  -9.32200000E-05  +3.95867000E-03
   +2.45811000E-03  +1.42059400E-02  +3.25573000E-03  -1.75775000E-03  +5.00060000E-04
   +2.41240000E-04  +9.14900000E-05  +2.71900000E-05  +1.12725200E-02  -8.84034700E-02
   -2.10354400E-02  -1.00673400E-02  +9.87018000E-03  -1.96363700E-02  -2.14692000E-03
   -1.44043700E-02  +4.15703000E-03  +1.86092700E-02  -1.40899400E-02  +2.76865000E-03
   +7.50426000E-02  -1.04417600E-01  -2.39732000E-03  -1.42407590E-01  +5.10848490E-01
   +5.51350000E-04  +1.19933000E-03  +6.55560000E-04  +7.65700000E-05  -1.51543000E-03
   -6.62860000E-04  -5.75350000E-04  +2.17550000E-04  +2.54150000E-04  +7.13220000E-04
   +1.20565000E-03  -4.74420000E-04  +5.99550000E-04  -4.03700000E-04  -7.70990000E-04
   -7.78670000E-04  -4.29660000E-04  -7.48000000E-06  -6.74541000E-03  +3.88172000E-03
   -3.27488000E-03  +6.19020000E-04  -7.38140000E-04  +3.87820000E-04  +1.38080000E-04
   +1.92510000E-04  -1.25330000E-04  -4.66931300E-02  -4.72878000E-03  -1.77115310E-01
   +1.54928100E-02  -3.11956300E-02  -3.24825200E-02  -9.22150000E-03  +2.64259400E-02
   -1.55704400E-02  +1.99125500E-02  -1.31906000E-03  +2.20927900E-02  -3.96746200E-02
   -6.13792000E-03  -1.07695670E-01  +1.16599260E-01  +1.40239720E-01  +4.54823040E-01
   -1.84610000E-04  -2.46300000E-05  -6.32600000E-05  -1.01070000E-04  +7.04860000E-04
   -1.48390000E-04  -2.42200000E-05  -7.37300000E-05  -1.04290000E-04  -1.12830000E-04
   -3.25630000E-04  -1.65050000E-04  +6.92910000E-04  +6.58070000E-04  +1.54300000E-05
   -1.64440000E-04  +1.10460000E-04  +1.26460000E-04  +1.17200000E-04  -1.07706000E-03
   +1.21100000E-05  -4.62680000E-04  -3.56000000E-06  +7.19800000E-05  -8.61330000E-04
   -6.99830000E-04  +1.00270000E-04  -1.07577000E-03  -1.00210000E-03  -3.05958000E-03
   +3.73060000E-04  +3.75985000E-03  -5.53267000E-03  -4.45737400E-02  +6.07631000E-03
   -1.03688400E-02  -2.72620640E-01  +7.80857400E-02  -6.62105900E-02  -3.69721300E-02
   +2.33269000E-02  +4.22107000E-03  +1.12880900E-02  +1.27651000E-03  +3.48308000E-03
   +4.16712960E-01  +7.81400000E-05  -4.00700000E-05  -5.44400000E-05  -4.92600000E-05
   -6.28700000E-05  +4.62400000E-05  +1.39000000E-05  -9.93000000E-06  +6.32000000E-06
   +2.62500000E-05  +8.32300000E-05  +1.03920000E-04  -2.53630000E-04  -2.42150000E-04
   -2.89000000E-06  +7.85000000E-05  -9.55000000E-06  -3.67700000E-05  -2.25820000E-04
   +2.44160000E-04  +2.86190000E-04  +9.48200000E-05  -1.13900000E-05  -3.43000000E-06
   +2.95250000E-04  +2.61140000E-04  -3.32800000E-05  +6.40700000E-05  +7.96030000E-04
   +2.44312000E-03  +3.55857000E-03  -1.34140000E-03  -2.30268000E-03  +2.81472000E-03
   +1.48338600E-02  -2.60473000E-03  +9.17259200E-02  -9.29760700E-02  +5.64244000E-03
   +3.75568300E-02  -8.31672000E-03  -4.05170000E-04  -5.43512000E-03  +5.65157000E-03
   -7.03280000E-03  -1.83607730E-01  +1.76748870E-01  +7.18000000E-06  -8.67200000E-05
   -8.93300000E-05  -1.05450000E-04  +3.18480000E-04  -2.66000000E-06  +1.73700000E-05
   -4.41700000E-05  -6.62700000E-05  -6.16400000E-05  -1.35560000E-04  +2.41300000E-05
   +1.34570000E-04  +1.57170000E-04  +3.06700000E-05  -1.23000000E-06  +3.74900000E-05
   +6.75200000E-05  +3.33660000E-04  -1.44020000E-04  +4.22810000E-04  -9.02900000E-05
   -1.38200000E-05  -4.79000000E-06  -2.05250000E-04  -1.65340000E-04  +4.13300000E-05
   -7.35530000E-04  +1.48395000E-03  +7.69400000E-04  +7.12430000E-04  -4.76581000E-03
   -4.37111000E-03  -3.53351400E-02  +1.09754100E-02  -6.53028000E-03  -2.21897600E-02
   -1.81438300E-02  -1.17581270E-01  +3.43352700E-02  -1.27662200E-02  +1.67718700E-02
   -2.25127000E-03  -5.33177000E-03  -4.63963000E-03  -4.79324400E-02  +1.81211470E-01
   +5.09655510E-01  -1.44300000E-05  -6.97800000E-05  -1.02890000E-04  +4.28250000E-04
   +3.23060000E-04  -1.00990000E-04  -3.99000000E-05  -4.41700000E-05  -4.76500000E-05
   -5.83000000E-05  -1.58930000E-04  -6.62000000E-05  +4.19220000E-04  +3.42600000E-04
   -7.80000000E-07  -1.08580000E-04  +3.27200000E-05  +1.34560000E-04  +1.33004000E-03
   +1.90524000E-03  +1.51639000E-03  -3.25110000E-04  -4.56400000E-05  +1.32400000E-05
   -5.23070000E-04  -4.25820000E-04  +7.19800000E-05  -3.78806000E-03  +3.42938000E-03
   -2.37544000E-03  -2.22990300E-02  +6.10938000E-03  +3.47631900E-02  -1.21529800E-01
   +6.00710600E-02  +7.97875400E-02  -9.23020000E-03  +7.75800000E-05  -5.87630000E-03
   -6.92600000E-05  +1.97363000E-03  +1.76585000E-03  +1.34892000E-03  +8.16100000E-04
   -2.78873000E-03  +8.68968000E-03  -3.77167000E-03  -9.56904000E-03  +2.27644090E-01
   +2.90300000E-05  +4.89900000E-05  +5.72800000E-05  -8.48800000E-05  -1.30770000E-04
   -2.00400000E-05  -3.24100000E-05  +3.35600000E-05  -1.65100000E-05  +4.55200000E-05
   +5.68200000E-05  -6.94000000E-06  -6.22700000E-05  -6.74300000E-05  +1.31700000E-05
   +2.61200000E-05  -7.32300000E-05  -1.47900000E-05  +9.67310000E-04  +4.68000000E-05
   -1.23811000E-03  -1.85980000E-04  +1.66680000E-04  +1.26400000E-05  +8.34700000E-05
   +5.95700000E-05  -1.90900000E-05  +3.13027000E-03  +4.20887000E-03  +5.87808000E-03
   +2.00954300E-02  -1.53674600E-02  -2.24001300E-02  +2.13919100E-02  -6.41305700E-02
   -9.06348000E-03  +6.44224000E-03  -1.03444100E-02  -1.89191800E-02  -3.76097000E-03
   +5.82085000E-03  -9.76400000E-05  +2.14218000E-03  +7.29000000E-05  -1.59242000E-03
   +9.29620000E-04  -4.95200000E-05  +2.69599000E-03  +8.87031900E-02  +4.63759870E-01
   +1.82370000E-04  -4.57000000E-05  -4.82900000E-05  -1.73370000E-04  -2.52470000E-04
   +2.71650000E-04  +1.51650000E-04  +7.38200000E-05  -8.78000000E-06  -5.40400000E-05
   +5.64300000E-05  +9.17100000E-05  -2.99060000E-04  -2.08210000E-04  +2.16100000E-05
   +1.02700000E-04  -6.50000000E-06  -4.88500000E-05  -8.57300000E-04  +1.15570000E-04
   -3.54770000E-04  +3.33490000E-04  -1.61080000E-04  -7.90500000E-05  +3.59500000E-04
   +2.92360000E-04  -9.27000000E-06  +1.66951000E-03  -3.13492000E-03  -2.34531000E-03
   -1.98901000E-03  +6.00050000E-03  +1.15826000E-03  +7.76017400E-02  -5.51369400E-02
   -1.56487280E-01  +2.72675600E-02  -9.29430000E-03  -3.66822100E-02  -3.58533000E-03
   -1.79296000E-03  -5.72262000E-03  -3.64090000E-03  -3.74500000E-04  +2.67837000E-03
   +4.93600000E-03  -4.13751000E-03  -3.98823000E-03  -2.01082720E-01  -1.14323980E-01
   +3.12648460E-01  -4.39962000E-03  -2.73563000E-03  +2.06259000E-03  +1.74129000E-03
   -2.32659000E-02  -1.61577900E-02  -1.98866000E-03  -1.87626000E-03  +4.17220000E-04
   +1.84270000E-04  -6.34500000E-04  -7.74600000E-04  +3.18200000E-04  +1.52180000E-04
   +6.44900000E-05  +5.29000000E-05  -1.08562000E-03  -1.05327000E-03  -7.78766300E-02
   +1.06226300E-02  +7.61803000E-03  +1.05300000E-04  +2.17331000E-03  +2.29627000E-03
   -5.19060000E-04  -4.14460000E-04  +3.71900000E-05  -6.43836000E-03  +2.50508600E-02
   +1.67610700E-02  -3.06572000E-03  +2.40494000E-03  -2.77144000E-03  -5.74260000E-04
   +4.14700000E-05  +6.03160000E-04  +1.02910000E-04  +2.05230000E-04  +1.42790000E-04
   +1.14150000E-04  +5.34000000E-04  +5.97820000E-04  -2.07341000E-03  +1.04840000E-04
   -6.85370000E-04  -4.01240000E-04  +7.89100000E-05  -6.32400000E-05  -9.04540000E-04
   +2.12350000E-04  +2.72890000E-04  +5.89771880E-01  -2.62176000E-03  -9.12260000E-04
   +1.34492000E-03  -3.22878000E-03  -2.28874000E-02  -1.28352600E-02  -4.27000000E-05
   -4.78140000E-04  +1.43240000E-04  +4.98950000E-04  -4.23420000E-04  -6.23230000E-04
   -1.11670000E-04  +1.07520000E-04  +8.24900000E-05  +2.78100000E-04  -4.46170000E-04
   -8.75230000E-04  +7.76853000E-03  -1.43975360E-01  -4.72845400E-02  -2.03530000E-04
   +5.61794000E-03  -7.56560000E-04  +2.52300000E-05  -4.62000000E-06  -2.55000000E-05
   +8.63013000E-03  -1.74426300E-02  -7.95705000E-03  +6.17230000E-04  -1.05037000E-03
   +1.27193000E-03  +1.12420000E-04  +5.07490000E-04  -6.24080000E-04  +1.09100000E-05
   +1.07410000E-04  +3.59940000E-04  -4.94200000E-05  -3.10820000E-04  -7.15050000E-04
   +4.18360000E-04  +3.75620000E-04  +1.58420000E-04  +2.40000000E-07  -3.25100000E-05
   -3.17300000E-05  +1.80490000E-04  -1.07200000E-05  -4.60400000E-05  +1.13577600E-02
   +4.96931100E-01  +1.64641000E-03  +4.00540000E-04  -6.44700000E-05  -3.38707000E-03
   +9.18410000E-04  +2.48837000E-03  +1.36400000E-05  +1.25106000E-03  -1.73900000E-04
   +1.37480000E-04  -1.58010000E-04  -3.00320000E-04  -2.65410000E-04  -1.46760000E-04
   +3.12390000E-04  +3.09840000E-04  +2.66680000E-04  +2.37600000E-04  +5.66866000E-03
   -4.49845700E-02  -1.09340100E-01  +4.52767000E-03  -2.84469300E-02  -3.32086700E-02
   +2.77880000E-04  +1.93090000E-04  -1.09230000E-04  +1.74987000E-03  +4.67658000E-03
   +6.28887000E-03  -1.40434000E-03  +3.00920000E-04  -1.02372000E-03  -8.94190000E-04
   +3.50960000E-04  -3.37950000E-04  +1.40250000E-04  +4.64380000E-04  +1.18924000E-03
   +5.70970000E-04  -4.68580000E-04  -7.57630000E-04  -1.77997000E-03  +1.02549000E-03
   +1.24622000E-03  -7.47900000E-05  -8.04800000E-05  -1.81700000E-04  -4.27590000E-04
   +1.36810000E-04  +1.19430000E-04  +6.08391000E-03  -5.37104800E-02  +5.63584840E-01
   +2.33950000E-04  +1.27636000E-03  +5.54990000E-04  -7.65580000E-04  -1.83373000E-03
   -7.07080000E-04  -1.14447000E-03  +4.67350000E-04  -6.94340000E-04  +6.66880000E-04
   +1.31779000E-03  -5.80210000E-04  +8.84120000E-04  -1.41340000E-04  -6.92600000E-04
   -8.22900000E-04  -5.04800000E-05  -1.13590000E-04  -9.57420000E-04  +9.59550000E-04
   +2.43670000E-04  +7.01840000E-04  -2.38800000E-04  -1.58680000E-04  -1.27790000E-04
   -1.38900000E-05  -6.77600000E-05  +9.76033000E-03  +2.73321000E-03  +1.03665700E-02
   -2.86901000E-03  -1.07418000E-03  -2.61149000E-03  +1.17424200E-02  +1.54384500E-02
   +6.55135000E-03  +4.07632000E-03  -2.38705100E-02  -2.32221800E-02  -5.56260100E-02
   -3.97820000E-04  +3.16087000E-02  -2.51719100E-02  +5.23424000E-03  -5.27176200E-02
   -5.50526000E-03  +6.39197000E-03  +1.11984000E-03  -1.82075000E-03  -2.91538000E-03
   +3.23948000E-03  +4.30180000E-04  +6.47600000E-05  +1.15579000E-03  +2.24210110E-01
   -7.86160000E-04  +1.28000000E-06  -1.51260000E-04  -3.46740000E-04  -7.22930000E-04
   +3.18830000E-04  +4.31260000E-04  -2.70900000E-04  -1.17700000E-05  -3.42100000E-05
   +3.05090000E-04  -2.18520000E-04  +4.00090000E-04  +7.81800000E-05  -4.01410000E-04
   -3.03800000E-04  +1.36664000E-03  -7.99730000E-04  -5.56760000E-04  -2.94830000E-04
   -3.11980000E-04  +4.16830000E-04  +1.82110000E-04  +1.41570000E-04  +1.49690000E-04
   +3.50750000E-04  -9.77700000E-05  -4.48350000E-04  +6.63635000E-03  +1.74130600E-02
   +5.24274000E-03  -7.75213000E-03  -1.97808000E-03  +3.41567000E-03  +1.60749200E-02
   +1.15000000E-05  +1.23079000E-03  -6.65820000E-03  -7.86667000E-03  -1.17421500E-02
   +1.88303100E-02  -4.00000000E-05  +1.36400200E-02  -5.32263700E-02  -3.53483000E-02
   -1.48940000E-03  +9.88030000E-04  +6.18710000E-04  -1.85660000E-03  -2.04893000E-03
   +2.15403000E-03  +1.66130000E-04  -7.81020000E-04  -2.03970000E-04  +1.36473200E-02
   +1.36551930E-01  -2.01770000E-04  +3.12450000E-04  -1.77810000E-04  -1.10960000E-03
   +5.90460000E-04  -1.01700000E-03  -4.58960000E-04  -2.74640000E-04  -8.91990000E-04
   +5.40800000E-05  -3.25600000E-05  +4.01740000E-04  +4.43490000E-04  -1.76900000E-04
   -4.08990000E-04  -3.50820000E-04  +3.25140000E-04  +2.52370000E-04  +6.15520000E-04
   -9.46530000E-04  +5.45310000E-04  -3.90450000E-04  +3.39760000E-04  -8.58800000E-05
   -4.25590000E-04  -2.46250000E-04  +2.02150000E-04  +2.07270800E-02  +1.43050700E-02
   -3.93829900E-02  -8.75693000E-03  +1.28538600E-02  +1.66004000E-03  +1.19133000E-03
   -1.10281500E-02  +3.66569000E-03  -3.06480000E-04  +4.26371000E-03  +1.64255000E-03
   +1.63204200E-02  -4.62384000E-03  +3.79875000E-03  -1.81270200E-02  -5.35611000E-03
   -3.60717800E-02  +6.36260000E-04  -4.75910000E-04  +2.98370000E-04  +1.50752000E-03
   +1.59648000E-03  -1.24404000E-03  -1.95800000E-05  +2.28690000E-04  -1.00630000E-03
   +2.07424120E-01  -6.55107300E-02  +4.99625890E-01  +2.24100000E-04  +8.84230000E-04
   +1.85694000E-03  +4.38720000E-04  -2.21790000E-04  -5.65060000E-04  -9.69870000E-04
   +1.45910000E-04  +3.90050000E-04  +3.58936000E-03  +3.06207000E-03  -1.18130000E-03
   -2.82534700E-02  +8.35836000E-03  +2.84543600E-02  -2.15432000E-03  -5.42911000E-03
   -8.57780000E-04  -1.21220000E-04  -1.60120000E-04  -6.33200000E-05  +1.07150000E-04
   +5.13700000E-05  +4.60700000E-05  -2.15829430E-01  +5.37959100E-02  +2.22914350E-01
   +1.27540000E-04  +9.08700000E-05  -1.47730000E-04  -8.15500000E-05  +1.75920000E-04
   +7.83000000E-05  +2.53300000E-05  -1.21620000E-04  +1.75360000E-04  -1.40780000E-04
   +4.71300000E-05  -9.16000000E-05  +5.51700000E-05  +3.28000000E-06  -1.47000000E-05
   -1.27600000E-04  -1.04190000E-04  +9.62300000E-05  +1.68580000E-04  -5.94200000E-05
   +2.69800000E-05  +8.94700000E-05  -1.57400000E-05  -7.20600000E-05  +7.73400000E-05
   +1.41500000E-05  -1.27800000E-05  +1.83120000E-04  +1.58570000E-04  -8.28000000E-06
   +2.42768660E-01  -5.70150000E-04  +1.39848000E-03  +2.78260000E-04  +2.96270000E-04
   -2.47580000E-04  -4.17350000E-04  -9.25300000E-05  -6.10270000E-04  +1.62080000E-04
   -1.23178000E-03  +1.00666000E-03  +2.60363000E-03  -2.37976400E-02  +4.66066000E-03
   +2.60632300E-02  -4.19800000E-03  -3.02407000E-03  -7.46260000E-04  -2.18100000E-05
   -5.86700000E-05  -6.04200000E-05  +4.60200000E-05  +1.74100000E-05  -2.80000000E-06
   +8.84268400E-02  -7.03104100E-02  -1.29876800E-01  -2.47000000E-06  -1.04200000E-05
   -7.45900000E-05  -6.50900000E-05  +8.47700000E-05  +1.69300000E-05  +1.93000000E-06
   -1.24560000E-04  +9.65600000E-05  -5.98500000E-05  +2.48600000E-05  -3.63300000E-05
   +1.48800000E-05  -1.91300000E-05  +8.40000000E-06  -1.67400000E-05  +7.60000000E-07
   +1.35300000E-05  +7.87300000E-05  -3.46000000E-05  +1.84000000E-05  +4.92300000E-05
   -4.56000000E-06  -2.50300000E-05  +2.47900000E-05  +2.39500000E-05  +1.41100000E-05
   +3.89500000E-05  -6.82000000E-05  -3.62000000E-06  -5.94676900E-02  +6.82312900E-02
   +6.45520000E-04  -1.04527000E-03  +3.44850000E-04  -1.07700000E-04  +3.72100000E-05
   +2.60330000E-04  +2.82700000E-04  -4.19600000E-05  -9.21310000E-04  -4.90406000E-03
   -1.06055000E-03  +2.25812000E-03  +1.81757000E-03  -8.89030000E-04  -4.75290000E-03
   -1.67830000E-04  +3.26420000E-04  +2.05317000E-03  +2.61100000E-05  +8.66000000E-05
   -9.38000000E-06  -7.02600000E-05  -7.43200000E-05  -4.13400000E-05  +2.51921530E-01
   -1.00887540E-01  -2.99855840E-01  -2.58600000E-05  -5.28900000E-05  +5.76600000E-05
   +6.14600000E-05  -7.85500000E-05  -2.27700000E-05  -4.07200000E-05  +9.78200000E-05
   -9.89100000E-05  +2.85500000E-05  +2.98300000E-05  +9.39200000E-05  +4.52500000E-05
   -7.17000000E-06  -5.10000000E-05  -1.00400000E-04  -3.42000000E-05  +9.67900000E-05
   -4.24300000E-05  +1.20800000E-05  -2.22700000E-05  -3.00000000E-05  +6.32000000E-06
   +2.86000000E-06  -2.53500000E-05  +6.13000000E-06  +3.43900000E-05  +9.68000000E-05
   +9.41200000E-05  -1.13040000E-04  -2.49829250E-01  +1.03442010E-01  +3.00834600E-01
   -4.23180000E-04  -4.04740000E-04  -9.20840000E-04  -3.60750000E-04  -5.38503000E-03
   +1.55290000E-03  -1.23870200E-02  +5.89656000E-03  +1.75742300E-02  -1.80344490E-01
   +2.25402100E-02  +1.42975310E-01  +1.95779000E-03  -3.76995000E-03  -1.32689000E-03
   +2.95559000E-03  -1.71574000E-03  +9.29180000E-04  +9.72000000E-06  +5.55510000E-04
   +8.12710000E-04  -3.05930000E-04  -1.87760000E-04  -5.19700000E-05  +1.45777000E-03
   +2.12771000E-03  -2.83882000E-03  -1.44400000E-05  -8.05100000E-05  +1.51680000E-04
   +8.66100000E-05  -9.61800000E-05  -5.28200000E-05  -7.63500000E-05  +1.43030000E-04
   -1.64830000E-04  +3.84800000E-05  +6.40500000E-05  +1.70010000E-04  +9.11400000E-05
   -2.62700000E-05  -9.61100000E-05  -2.13850000E-04  -7.93000000E-05  +1.97630000E-04
   -5.78500000E-05  +8.15000000E-06  -3.28900000E-05  -4.89600000E-05  +1.28700000E-05
   +1.37000000E-05  -4.37500000E-05  +9.80700000E-05  -3.13000000E-06  +2.22430000E-04
   +1.34310000E-04  -2.27760000E-04  +7.53200000E-05  +6.78480000E-04  +9.51970000E-04
   +1.88137950E-01  -4.95880000E-04  -1.42416000E-03  +1.91350000E-04  -5.13638000E-03
   -3.02930000E-04  -1.84181000E-03  -1.43106800E-02  +7.14835000E-03  +1.58142100E-02
   +2.27285800E-02  -5.98927200E-02  -4.10606700E-02  +1.77120700E-02  +8.81200000E-04
   -1.76983600E-02  -2.29057000E-03  -2.32452000E-03  -4.84797000E-03  -2.67610000E-04
   +5.13880000E-04  +5.86140000E-04  -1.32210000E-04  -4.55500000E-05  -7.41200000E-05
   +2.59123000E-03  +9.35380000E-04  +1.96416000E-03  -1.49870000E-04  -1.10970000E-04
   +3.05900000E-05  +3.24500000E-05  -8.77400000E-05  -3.98100000E-05  -2.27800000E-05
   +7.88700000E-05  -7.89300000E-05  +3.38200000E-05  +6.63000000E-06  +5.12900000E-05
   +1.46000000E-06  -1.30000000E-05  -1.05100000E-05  -1.63700000E-05  +3.59000000E-05
   +1.56700000E-05  -4.60400000E-05  +1.43400000E-05  -9.28000000E-06  -1.89200000E-05
   +2.60000000E-06  +1.95100000E-05  +4.27100000E-05  +6.09900000E-05  +5.51300000E-05
   -1.48800000E-05  -4.82600000E-05  +1.89200000E-05  -1.28525000E-03  -7.83940000E-04
   -2.76200000E-05  -2.17655500E-02  +5.61618200E-02  -1.12775000E-03  -6.90700000E-05
   -2.12840000E-04  +1.81616000E-03  -1.35601000E-03  +4.26317000E-03  +7.77610000E-04
   -1.26659000E-03  +8.28660000E-04  +1.43140320E-01  -4.12823100E-02  -1.89033370E-01
   +1.65970100E-02  +7.16510000E-04  -9.22450000E-03  +6.80560000E-04  -5.24200000E-03
   +8.16920000E-04  -1.12650000E-04  -2.52600000E-04  -1.27700000E-05  +2.48800000E-05
   -5.18700000E-05  +6.24800000E-05  -2.42257000E-03  +2.37546000E-03  +2.49000000E-06
   +1.35540000E-04  +5.27200000E-05  -3.41500000E-05  -3.31300000E-05  +9.59300000E-05
   +2.87400000E-05  +1.08900000E-05  -6.98500000E-05  +8.03600000E-05  -5.70400000E-05
   +1.62100000E-05  -3.97900000E-05  +2.23600000E-05  +8.10000000E-07  -5.20000000E-06
   -5.03200000E-05  -4.22300000E-05  +3.50900000E-05  +7.09700000E-05  -2.55900000E-05
   +1.17200000E-05  +3.44300000E-05  -4.21000000E-06  -2.68100000E-05  +3.10000000E-05
   +1.04200000E-05  -4.62500000E-05  +8.25100000E-05  +4.13500000E-05  -2.34300000E-05
   -6.86270000E-04  -1.69758000E-03  -3.07690000E-04  -1.57703470E-01  +4.58980600E-02
   +1.94987790E-01  -1.39571000E-03  -1.08042000E-03  +5.82573000E-03  +6.87846000E-03
   +1.69601800E-02  +1.29539600E-02  -5.35224600E-02  -1.45890700E-02  -4.28980000E-04
   +2.21247000E-03  -1.95481000E-02  -1.52767400E-02  -9.31400000E-04  -4.77925000E-03
   +3.27453000E-03  -1.29243000E-03  -4.20700000E-05  +1.11800000E-05  -4.93780000E-04
   +1.61009000E-03  -1.56115000E-03  +4.69560000E-04  +1.19000000E-05  -1.24650000E-04
   -2.85340000E-04  -1.15863000E-03  -7.29300000E-04  -5.25610000E-04  -2.03730000E-04
   +3.76400000E-05  -2.47900000E-05  -5.88200000E-05  -3.20400000E-05  -1.13500000E-04
   -1.81520000E-04  -4.28300000E-05  -7.35300000E-05  +1.90010000E-04  +2.43180000E-04
   +1.74320000E-04  -1.55610000E-04  -1.47510000E-04  -3.76170000E-04  +5.41500000E-05
   +4.54660000E-04  +1.02290000E-04  -6.78000000E-05  -2.84000000E-05  +5.35200000E-05
   +1.90100000E-05  -7.02800000E-05  -1.05651000E-03  -9.80110000E-04  +1.40786000E-03
   +4.49520000E-04  -3.29500000E-04  -1.60060000E-04  +1.51700000E-04  +3.20400000E-05
   -1.32700000E-04  -6.14720000E-04  +1.65237000E-03  -1.67174000E-03  +5.19396800E-02
   -1.15360000E-03  +2.87578000E-03  -2.51633000E-03  -2.33110000E-04  +9.47880000E-04
   -3.17113000E-03  -1.35783100E-02  -2.24479120E-01  -1.47027020E-01  -5.38900000E-05
   -1.18351200E-02  -1.35965200E-02  -5.01025000E-03  +1.68679000E-03  -9.55220000E-04
   +1.47350000E-04  +8.40600000E-05  +9.34910000E-04  +3.35210000E-04  -1.93884000E-03
   +1.12434000E-03  -2.49100000E-04  -2.84810000E-04  +7.65500000E-05  -3.10520000E-04
   -1.09814000E-03  -5.96060000E-04  +4.20970000E-04  +1.12050000E-04  -2.15210000E-04
   -2.07700000E-05  +9.52700000E-05  +1.19560000E-04  +1.33090000E-04  -2.44900000E-05
   +1.41490000E-04  +1.17500000E-05  -1.82540000E-04  -2.57450000E-04  -2.30790000E-04
   +3.01900000E-05  +1.75370000E-04  +5.91810000E-04  +3.37710000E-04  -5.27080000E-04
   -3.57000000E-06  +3.04500000E-05  +3.43800000E-05  +1.47800000E-05  -2.60900000E-05
   +2.15900000E-05  -2.36141000E-03  -9.66420000E-04  +8.74650000E-04  -7.86640000E-04
   -1.69500000E-05  +3.45100000E-04  +1.85850000E-04  +1.86200000E-05  -1.11490000E-04
   +1.40679000E-03  -6.31200000E-04  +1.94688000E-03  +2.25540900E-02  +2.36764170E-01
   +5.75821000E-03  -2.38350000E-03  +1.61750000E-04  -1.99380000E-03  -1.76263200E-02
   -8.50893000E-03  +2.73600000E-05  -1.47263020E-01  -1.66351300E-01  +1.73562000E-03
   +3.54150000E-03  +5.57004000E-03  +3.25544000E-03  -1.10873000E-03  +3.95495000E-03
   +1.17940000E-04  +9.94230000E-04  -4.81710000E-04  -2.35350000E-03  +1.88030000E-04
   -1.70197000E-03  +5.15480000E-04  +2.73560000E-04  +3.20000000E-05  -9.95900000E-05
   +1.51270000E-04  +1.41370000E-04  -3.59410000E-04  +9.60000000E-06  +2.37750000E-04
   +5.53200000E-05  -9.22800000E-05  -1.48890000E-04  -7.36100000E-05  +1.69910000E-04
   -9.92000000E-05  +1.67200000E-05  +4.16500000E-05  +8.43200000E-05  +8.80300000E-05
   +3.66300000E-05  -3.39300000E-05  -2.29280000E-04  -1.93990000E-04  +1.45870000E-04
   -3.44500000E-05  +1.60900000E-05  -9.50000000E-06  -1.67600000E-05  +6.52000000E-06
   +2.35200000E-05  -3.33090000E-04  -4.58930000E-04  +3.03540000E-04  +2.94320000E-04
   +1.01560000E-04  -8.75700000E-05  -5.77000000E-06  +3.42000000E-06  -2.32700000E-05
   -1.88263000E-03  +1.67107000E-03  -1.20543000E-03  -3.04575000E-03  +1.61942750E-01
   +1.68439800E-01  -1.89817020E-01  +2.94413400E-02  +1.42859680E-01  +5.73340000E-03
   +4.70280000E-04  -8.05010000E-04  +2.65515000E-03  -2.24047000E-03  +1.11627000E-03
   -2.58470000E-04  -2.82140000E-04  -8.85590000E-04  +6.21190000E-04  -5.33826000E-03
   +1.72544000E-03  -1.26298600E-02  +5.31065000E-03  +1.76413000E-02  -2.09083000E-03
   +4.71260000E-04  -9.43980000E-04  -4.33330000E-04  -5.52220000E-04  +1.76630000E-04
   -9.66730000E-04  +1.71680000E-04  +1.02790000E-03  +4.03340000E-04  -9.57700000E-04
   -4.50000000E-06  -1.93501000E-03  -1.92710000E-04  -5.33220000E-04  -7.51500000E-05
   +1.68610000E-04  +2.25180000E-04  +1.21800000E-05  -1.61100000E-05  -1.07580000E-04
   -1.00300000E-05  -8.20000000E-06  +2.41200000E-05  -4.52500000E-05  +9.94400000E-05
   -1.85180000E-04  +1.34260000E-04  -4.49500000E-05  +6.73400000E-05  +1.11840000E-04
   -5.69400000E-05  -2.47100000E-05  +1.29890000E-04  +1.57020000E-04  -1.71950000E-04
   -7.47000000E-05  -8.67200000E-05  +1.17340000E-04  -2.77860000E-04  -1.43720000E-04
   -3.16800000E-05  -2.45790000E-04  +2.17600000E-04  -1.91630000E-04  +1.65830000E-04
   -7.66500000E-05  -2.56700000E-04  +2.00506000E-01  +3.10135500E-02  -6.38786900E-02
   -4.34267900E-02  +1.82556600E-02  +1.71635000E-03  -1.67037800E-02  -2.51805000E-03
   -2.34384000E-03  -5.25533000E-03  -3.26170000E-04  -1.01927000E-03  +2.92350000E-04
   -5.21959000E-03  -1.98400000E-04  -2.61860000E-03  -1.60221400E-02  +6.74832000E-03
   +1.52686100E-02  +1.62835000E-03  -1.70010000E-04  +8.21050000E-04  -2.17350000E-04
   -1.16102000E-03  -3.24820000E-04  -7.29190000E-04  +3.59360000E-04  +8.44410000E-04
   -4.40820000E-04  -2.17510000E-04  -1.62410000E-04  -4.28060000E-04  -1.24860000E-04
   -4.72950000E-04  -5.26500000E-05  -2.83970000E-04  +3.81680000E-04  +2.61100000E-05
   -1.26900000E-05  -4.86900000E-05  -3.19400000E-05  -2.92700000E-05  +7.85300000E-05
   +1.79030000E-04  +1.00250000E-04  -2.28820000E-04  +9.14400000E-05  -3.64000000E-05
   +5.10600000E-05  +9.81400000E-05  -2.62200000E-05  -7.15900000E-05  +1.67800000E-05
   -5.55300000E-05  +1.99070000E-04  -1.99440000E-04  -2.30550000E-04  +1.08720000E-04
   -2.24550000E-04  -2.54030000E-04  +1.27990000E-04  +2.61700000E-04  -1.39120000E-04
   +2.54910000E-04  +1.09823000E-03  -1.06780000E-04  -8.63700000E-04  -2.63651200E-02
   +6.24638500E-02  +1.42064590E-01  -4.29014400E-02  -1.87901960E-01  +1.38615500E-02
   -2.17453000E-03  -8.58746000E-03  +1.37470000E-03  -5.59090000E-03  +8.41470000E-04
   -1.09601000E-03  +1.76900000E-05  -1.77240000E-04  +1.99047000E-03  -2.18725000E-03
   +4.92610000E-03  +1.22617000E-03  -1.52841000E-03  +1.48785000E-03  -7.24000000E-05
   +1.64489000E-03  -1.52108000E-03  +3.08330000E-04  +4.65690000E-04  -4.22300000E-05
   +3.19140000E-04  +1.09200000E-05  -1.20960000E-04  +1.70390000E-04  -3.24000000E-06
   +9.69700000E-05  -6.76700000E-05  +1.97080000E-04  +4.18700000E-05  -1.65140000E-04
   +4.29650000E-04  +5.79500000E-05  -9.39400000E-05  -2.31800000E-05  -4.48300000E-05
   +1.92000000E-06  -2.61000000E-06  +7.17300000E-05  +4.92800000E-05  +1.63880000E-04
   -5.13690000E-04  +1.43890000E-04  -4.02900000E-05  +3.55900000E-05  +9.52300000E-05
   -4.76500000E-05  -8.11200000E-05  -1.35210000E-04  +8.30100000E-05  -2.35800000E-05
   -1.66150000E-04  -4.85000000E-06  +2.38420000E-04  -8.38900000E-05  +6.91700000E-05
   -4.10200000E-05  -1.88710000E-04  +2.83340000E-04  -3.39080000E-04  +6.78560000E-04
   +6.28200000E-05  -6.57690000E-04  -1.59114160E-01  +4.81263900E-02  +1.92784110E-01
   +2.64951000E-03  -1.80223600E-02  -1.59864200E-02  -1.08323000E-03  -4.89494000E-03
   +3.17578000E-03  -1.56369000E-03  -2.40820000E-04  +2.44130000E-04  -1.57222000E-03
   -1.00012000E-03  +5.03902000E-03  +6.56070000E-03  +1.80150900E-02  +1.35314200E-02
   -5.39521100E-02  -2.12214500E-02  -2.09353000E-03  +6.87520000E-04  -7.67010000E-04
   -6.06570000E-04  +5.40900000E-05  +4.08200000E-05  -1.48250000E-04  +5.19880000E-04
   +1.09515000E-03  -2.30454000E-03  +4.08600000E-05  +7.46600000E-05  +1.25510000E-04
   +9.75700000E-05  -1.39820000E-04  -8.44800000E-05  +2.00100000E-05  +2.95150000E-04
   -8.93100000E-05  -8.28000000E-06  -3.53000000E-05  -3.43000000E-05  -1.61000000E-06
   +3.26800000E-05  -4.74000000E-06  -5.95600000E-05  -2.79400000E-05  +2.53700000E-05
   -1.06600000E-05  +1.83500000E-05  +3.82000000E-06  -1.84800000E-05  -9.51000000E-06
   +4.27800000E-05  -3.76510000E-04  -1.54320000E-04  +8.68600000E-05  +5.35400000E-05
   +1.95590000E-04  +3.33900000E-05  +5.17200000E-05  +6.52600000E-05  -4.12440000E-04
   +1.08140000E-04  +9.90800000E-04  +7.15500000E-04  -1.54230000E-04  +1.99880000E-04
   -3.07150000E-04  -5.82430000E-04  +1.77603000E-03  -1.83652000E-03  +4.86329200E-02
   +8.76390000E-04  -1.15617400E-02  -1.23662100E-02  -5.22018000E-03  +1.69979000E-03
   -8.15810000E-04  +2.01820000E-04  +1.39530000E-04  +8.04410000E-04  -7.17190000E-04
   +2.50269000E-03  -2.00648000E-03  -2.88813000E-03  -9.47920000E-04  -1.97784000E-03
   -1.98962400E-02  -2.27932330E-01  -1.46491960E-01  +3.63600000E-04  -3.11590000E-04
   -8.10430000E-04  -5.14700000E-05  +1.95300000E-05  -8.33000000E-06  +1.15831000E-03
   -3.74760000E-04  +1.47709000E-03  +1.07950000E-04  -3.35600000E-05  +1.00610000E-04
   +5.29900000E-05  -5.03300000E-05  -4.77700000E-05  -1.86200000E-05  +8.82500000E-05
   -7.10100000E-05  +3.66600000E-05  -9.11000000E-06  +3.79200000E-05  -2.66000000E-06
   -2.37000000E-06  -5.75000000E-06  +4.23000000E-06  +2.55400000E-05  -3.06200000E-05
   -4.40200000E-05  +1.41400000E-05  -3.16000000E-06  -2.56400000E-05  +2.71000000E-06
   +4.18000000E-05  -2.66130000E-04  -9.86800000E-05  +1.35110000E-04  -2.16700000E-05
   -3.39000000E-05  -5.56000000E-06  +1.41170000E-04  -1.19010000E-04  +2.15520000E-04
   -2.35200000E-05  -3.49700000E-05  -1.27100000E-05  +2.19590000E-04  -2.68870000E-04
   +1.94150000E-04  +1.44144000E-03  -7.42010000E-04  +2.10784000E-03  +2.45248200E-02
   +2.38178410E-01  +5.38460000E-04  +4.80569000E-03  +5.71753000E-03  +3.10971000E-03
   -1.25705000E-03  +3.94661000E-03  +3.02700000E-04  +1.01102000E-03  -4.90400000E-04
   +5.25686000E-03  -1.57649000E-03  -1.33980000E-04  -4.25738000E-03  -1.92526100E-02
   -8.58736000E-03  -1.35846000E-03  -1.45857740E-01  -1.57129920E-01  +2.38100000E-04
   +6.35200000E-05  +3.29820000E-04  -1.11900000E-05  -2.29800000E-05  -6.04400000E-05
   -1.97933000E-03  +1.73702000E-03  -1.19040000E-04  -1.40310000E-04  +3.84800000E-05
   +3.47100000E-05  +7.24000000E-05  -1.33430000E-04  -2.01000000E-05  +2.09000000E-05
   +1.96210000E-04  -5.72400000E-05  -1.35100000E-05  -1.02100000E-05  -1.39000000E-05
   +1.04100000E-05  +2.32700000E-05  -2.11600000E-05  -7.28200000E-05  -5.19700000E-05
   +9.39900000E-05  -7.00000000E-06  +1.13700000E-05  -1.02500000E-05  -1.83900000E-05
   -8.92000000E-06  -1.21300000E-05  -1.85100000E-05  +2.07800000E-05  -4.24200000E-05
   +9.72800000E-05  +2.59090000E-04  +4.53700000E-05  -3.53300000E-04  +2.68370000E-04
   +3.59900000E-05  -1.11020000E-04  -8.16610000E-04  -5.76460000E-04  -2.76770000E-04
   +2.23070000E-04  -2.89080000E-04  -2.01237000E-03  +1.69380000E-03  -1.47845000E-03
   +1.01396000E-03  +1.59505710E-01  +1.59114020E-01  +7.86500000E-05  +1.34840000E-04
   +1.41740000E-04  +6.37690000E-04  -6.53610000E-04  +2.06470000E-04  +2.61580000E-04
   +2.32820000E-04  -2.34900000E-05  +2.10000000E-06  -3.81800000E-05  -6.20800000E-05
   -7.33400000E-05  +8.24000000E-06  +1.38300000E-05  +1.17500000E-05  +3.77800000E-05
   -8.55200000E-05  -4.70000000E-07  -1.34994000E-03  +1.19567000E-03  -2.35987680E-01
   +1.12616050E-01  -4.55556900E-02  +8.16800000E-05  +3.19600000E-05  +2.05000000E-06
   +4.11790000E-04  +7.62050000E-04  +3.30200000E-05  +5.72140000E-04  -3.61190000E-04
   -3.12720000E-04  -3.12000000E-05  +2.50860000E-04  -3.84040000E-04  +1.47040000E-04
   +1.23530000E-04  +3.34120000E-04  +1.25300000E-04  -1.15380000E-04  -8.77300000E-05
   +4.94100000E-05  +1.13080000E-04  +6.30450000E-04  -1.87080000E-04  +2.71100000E-05
   -7.40400000E-05  -1.49820000E-04  +1.99700000E-05  +6.00500000E-05  +1.35980000E-04
   -2.36620000E-04  +6.85570000E-04  +2.52550000E-04  +1.33790000E-04  -3.07480000E-04
   -1.13900000E-05  -3.50000000E-07  +8.50000000E-07  +1.71300000E-05  +1.42200000E-05
   -9.66000000E-06  +1.78800000E-05  +3.00000000E-07  -1.96600000E-05  +5.70600000E-05
   -5.60000000E-05  -3.32700000E-05  -5.94000000E-06  +1.27000000E-05  -7.16000000E-06
   +2.53191930E-01  -3.27800000E-05  -3.14150000E-04  -4.87950000E-04  +7.62230000E-04
   +2.70190000E-04  -6.26400000E-05  -3.96070000E-04  -1.34200000E-05  +1.24450000E-04
   +4.09000000E-05  +1.22070000E-04  +9.22300000E-05  -5.03200000E-05  -2.08540000E-04
   -7.63000000E-05  -2.46740000E-04  +2.45200000E-05  +5.02500000E-05  +8.77793000E-03
   -6.63376000E-03  +1.73709000E-03  +1.11805450E-01  -1.15461530E-01  +2.75569900E-02
   +8.26500000E-05  +1.13850000E-04  -8.97000000E-06  -1.67500000E-04  +2.32330000E-04
   +1.59491000E-03  +2.73190000E-04  +5.30000000E-07  +2.70000000E-06  -1.89910000E-04
   -9.35900000E-05  +4.13480000E-04  -5.85500000E-05  -6.03800000E-05  -1.31530000E-04
   -1.04400000E-05  +9.05300000E-05  +2.70670000E-04  +5.45170000E-04  -2.78810000E-04
   -3.65790000E-04  +1.69840000E-04  -2.88700000E-05  +5.94300000E-05  +1.46310000E-04
   -2.10400000E-05  -5.57500000E-05  -4.77770000E-04  +3.07400000E-04  -1.46874000E-03
   -1.84670000E-04  -1.21410000E-04  +8.45900000E-05  -1.43000000E-05  -1.93500000E-05
   +2.41900000E-05  +7.56000000E-06  -7.24000000E-06  +8.15000000E-06  +2.50700000E-05
   +9.45000000E-06  -3.40000000E-07  +1.42070000E-04  +1.43510000E-04  +1.61070000E-04
   +1.37700000E-05  -1.83200000E-05  +1.39600000E-05  -1.24429230E-01  +1.21906170E-01
   +3.35790000E-04  +4.49900000E-05  +1.03680000E-04  -9.80940000E-04  -5.77770000E-04
   +7.00500000E-04  +2.25060000E-04  -8.98200000E-05  +9.38200000E-05  +4.93800000E-05
   -5.19000000E-06  -1.24820000E-04  +1.23910000E-04  +7.11300000E-05  -7.53700000E-05
   -2.31170000E-04  +3.79900000E-05  +8.21700000E-05  -2.56334500E-02  +1.54169200E-02
   -8.22364000E-03  -4.36722600E-02  +2.65345400E-02  -5.65287100E-02  -1.70020000E-04
   -1.57600000E-04  +3.78800000E-05  +9.69670000E-04  +9.80970000E-04  -5.36743000E-03
   +7.15360000E-04  -1.48973000E-03  -7.32570000E-04  -3.15560000E-04  +8.40430000E-04
   -1.66350000E-04  +2.44970000E-04  -5.78100000E-05  +2.41640000E-04  +5.03000000E-06
   -2.54530000E-04  -4.47940000E-04  -1.43229000E-03  +1.27518000E-03  +2.10430000E-04
   -1.24380000E-04  +6.35100000E-05  +1.60300000E-05  -1.05960000E-04  -8.78200000E-05
   +1.48880000E-04  -1.52845000E-03  +1.33794000E-03  +9.32510000E-04  +2.56510000E-04
   +9.03800000E-05  -1.87700000E-04  +2.18300000E-05  +7.04000000E-06  -1.12300000E-05
   -1.33600000E-05  +1.44100000E-05  -2.20000000E-06  +2.56900000E-05  +1.10500000E-05
   -5.01500000E-05  +6.10400000E-05  -8.67000000E-06  +1.00400000E-05  +2.67000000E-06
   -3.98000000E-06  -8.66000000E-06  +4.89173700E-02  -3.06084200E-02  +6.52117200E-02
   +2.13180000E-04  +3.59860000E-04  +2.58530000E-04  +6.87700000E-04  -1.92820000E-04
   +8.87010000E-04  +4.51470000E-04  -1.71400000E-04  -1.93480000E-04  -1.10390000E-04
   -9.56500000E-05  -7.41000000E-05  +2.31470000E-04  +2.16350000E-04  +6.70000000E-07
   -1.05660000E-04  +5.97000000E-06  +2.78200000E-05  -1.81148000E-03  -1.28820000E-04
   -6.89280000E-04  -2.13929250E-01  -1.28153670E-01  +2.63194100E-02  -2.59960000E-04
   -2.24310000E-04  +4.58200000E-05  +7.25520000E-04  +9.28540000E-04  -6.93020000E-04
   +7.49700000E-05  +1.30150000E-04  -2.93390000E-04  +5.17600000E-05  -1.21970000E-04
   +2.05810000E-04  -4.35300000E-05  -3.15300000E-05  -1.56950000E-04  -2.45900000E-05
   +5.36100000E-05  +1.08110000E-04  +2.65300000E-04  -1.55910000E-04  +1.01630000E-04
   +6.45700000E-05  -2.17000000E-06  +2.42700000E-05  +3.71200000E-05  -1.87500000E-05
   -4.41300000E-05  -9.07900000E-05  +7.38200000E-05  -3.94970000E-04  +2.10000000E-05
   +1.33060000E-04  -6.41200000E-05  +3.77300000E-05  +1.38400000E-05  -2.34600000E-05
   -3.54200000E-05  -1.07600000E-05  +4.37000000E-06  -3.42100000E-05  +3.03800000E-05
   +5.07500000E-05  -3.31400000E-05  -2.88100000E-05  -3.03900000E-05  -2.25700000E-05
   -9.72000000E-06  -1.05900000E-05  -1.86285700E-02  -1.67111000E-02  +3.24862000E-03
   +2.29272470E-01  -1.61040000E-04  -1.65010000E-04  +2.78980000E-04  -3.70820000E-04
   -1.25770000E-04  +2.39764000E-03  +2.29150000E-04  -4.39180000E-04  -2.35020000E-04
   -3.95780000E-04  -2.28350000E-04  -1.34200000E-05  +7.07400000E-05  +3.21130000E-04
   +2.73930000E-04  +2.50620000E-04  +6.81100000E-05  +1.46810000E-04  -8.03743000E-03
   -7.40008000E-03  +7.05030000E-04  -1.26858150E-01  -1.45587800E-01  +1.94107100E-02
   -2.73540000E-04  -2.09740000E-04  +1.08900000E-05  -7.07340000E-04  +6.48180000E-04
   -2.70020000E-04  +5.85550000E-04  -1.11800000E-04  -1.53340000E-04  +7.81100000E-05
   +5.59900000E-05  -9.87600000E-05  +1.55000000E-05  +3.90600000E-05  +1.08950000E-04
   +9.64500000E-05  +2.41200000E-05  -5.87700000E-05  -1.46040000E-04  -1.70570000E-04
   +4.72190000E-04  -5.30900000E-05  +2.86000000E-06  -4.78200000E-05  -4.63200000E-05
   +5.14700000E-05  -5.14400000E-05  +4.92940000E-04  +3.31490000E-04  -1.04082000E-03
   +2.92900000E-04  +2.15210000E-04  -2.24720000E-04  +3.34100000E-05  +2.49200000E-05
   -2.62500000E-05  -8.97800000E-05  -1.35600000E-05  -2.04300000E-05  +1.58900000E-05
   +4.57600000E-05  +6.94000000E-05  -1.41820000E-04  +4.17120000E-04  -7.10500000E-05
   -4.43000000E-06  -3.07900000E-05  -3.15000000E-06  +1.37046700E-02  +1.14178000E-02
   -2.66561000E-03  +1.40743390E-01  +1.54876410E-01  +1.94070000E-04  -4.82110000E-04
   -9.96200000E-05  -6.84860000E-04  +6.66690000E-04  -5.60525000E-03  +7.85570000E-04
   +1.04032000E-03  +7.86900000E-05  +3.74380000E-04  -1.81470000E-04  +2.19160000E-04
   -3.23750000E-04  -1.78390000E-04  -2.91500000E-05  +3.21920000E-04  +1.71000000E-05
   +8.44900000E-05  +2.39599100E-02  +1.92953200E-02  -5.79014000E-03  +2.47280800E-02
   +1.81605900E-02  -5.01385500E-02  +3.89080000E-04  +3.77750000E-04  -5.97500000E-05
   +1.05633000E-03  -1.13189000E-03  +1.10312000E-03  -4.47730000E-04  +6.25910000E-04
   +3.78450000E-04  +1.06840000E-04  -2.61300000E-04  +2.55210000E-04  -7.04200000E-05
   +2.26000000E-06  -1.01970000E-04  -8.09800000E-05  -3.71500000E-05  +1.87800000E-05
   +1.90040000E-04  -1.26310000E-04  -2.81480000E-04  +9.88300000E-05  -4.54800000E-05
   +1.54200000E-05  +4.99500000E-05  +3.18000000E-05  -1.05800000E-04  +8.68460000E-04
   +1.22241000E-03  +1.11746000E-03  -2.39170000E-04  -2.01860000E-04  +1.61440000E-04
   -4.81400000E-05  -5.60000000E-06  +3.34000000E-05  +1.17750000E-04  +5.54400000E-05
   -1.21400000E-05  -7.55500000E-05  +1.15640000E-04  -1.62550000E-04  -2.68160000E-04
   +3.01730000E-04  +6.47400000E-05  +3.68200000E-05  +3.12900000E-05  +1.27100000E-05
   -4.59541000E-03  -4.50926000E-03  -1.88960000E-04  -2.83855300E-02  -2.24384900E-02
   +5.66720000E-02  -4.38870000E-04  -2.46540000E-04  +3.83580000E-04  +1.62080000E-04
   +7.23390000E-04  +1.19030000E-04  -2.11120000E-04  -1.07700000E-04  +9.27900000E-05
   +1.96810000E-04  +1.48990000E-04  +1.23900000E-05  +9.56000000E-06  -1.69250000E-04
   -1.19800000E-04  -2.56730000E-04  -7.89500000E-05  -7.18500000E-05  -1.84281000E-03
   +2.93140000E-04  +8.49140000E-04  -4.68403500E-02  +1.39363700E-02  +1.27025200E-02
   +6.84500000E-05  +5.48200000E-05  -1.99000000E-05  +6.44100000E-05  -1.14480000E-04
   +3.11940000E-04  -6.37160000E-04  +6.88700000E-05  -1.11885000E-03  -8.55700000E-05
   +1.02690000E-04  +2.03170000E-04  +5.03000000E-06  -7.51700000E-05  -8.99500000E-05
   -2.01200000E-05  +6.51000000E-06  +8.04500000E-05  +5.29600000E-05  +1.47750000E-04
   -2.29950000E-04  +9.86700000E-05  -9.00000000E-08  +6.95600000E-05  +1.21660000E-04
   -7.13500000E-05  +6.55000000E-05  -2.47310000E-04  -6.71900000E-05  +4.84840000E-04
   -1.65880000E-04  -1.65740000E-04  +1.44180000E-04  -1.02300000E-05  -1.46300000E-05
   +1.03600000E-05  +7.76000000E-06  +4.81000000E-06  -7.67000000E-06  +4.41600000E-05
   +5.96000000E-06  -4.98800000E-05  +2.40380000E-04  -8.47910000E-04  +3.84320000E-04
   +9.97000000E-06  -1.83900000E-05  +1.96400000E-05  -1.52790000E-03  +2.08245300E-02
   +1.83339700E-02  +2.59120000E-03  -1.92298500E-02  -1.73640000E-02  +4.84797100E-02
   -4.99310000E-04  -1.01056000E-03  +1.10058000E-03  -2.25590000E-04  +5.26240000E-04
   -6.67860000E-04  +5.93500000E-05  +7.00800000E-05  -1.03860000E-04  +2.89900000E-05
   +2.09100000E-05  +9.12200000E-05  -1.26990000E-04  +9.23000000E-06  -8.48000000E-05
   +1.33330000E-04  +8.10000000E-06  +2.95300000E-05  -1.27740000E-03  +8.63179000E-03
   +6.78386000E-03  +1.40397400E-02  -2.01721120E-01  -1.34712090E-01  +1.06930000E-04
   +9.30800000E-05  -7.73000000E-06  +4.14390000E-04  +1.81380000E-04  -7.41040000E-04
   +1.04602000E-03  -1.32056000E-03  +2.45270000E-04  -1.68230000E-04  +3.94850000E-04
   +1.58670000E-04  +1.57580000E-04  -1.02590000E-04  -6.39700000E-05  -3.67600000E-05
   +3.01600000E-05  +7.65000000E-06  -8.31100000E-05  +1.52130000E-04  -1.84200000E-05
   -3.49300000E-05  +4.90900000E-05  +5.96700000E-05  -1.70200000E-05  -5.98000000E-05
   +9.86800000E-05  +1.75000000E-06  -3.55400000E-05  +1.27714000E-03  -2.50700000E-05
   +5.35300000E-05  -2.62000000E-06  -1.33400000E-05  -5.44000000E-06  +4.20000000E-06
   +1.99000000E-05  +5.80000000E-06  -3.60000000E-06  -1.28500000E-05  -8.74000000E-06
   +2.04800000E-05  -9.06820000E-04  -1.74169000E-03  +1.15526000E-03  +3.21500000E-05
   -1.77100000E-05  +3.36600000E-05  -3.42000000E-06  -1.23166100E-02  -9.91358000E-03
   +2.92698000E-03  -1.41310300E-02  -1.17230200E-02  -1.68228400E-02  +2.21948320E-01
   +3.53950000E-04  -7.65140000E-04  -2.93870000E-04  -1.56718000E-03  -1.02090000E-03
   +1.09804000E-03  +6.42540000E-04  +3.87600000E-05  -2.27260000E-04  -3.89530000E-04
   -3.39980000E-04  +5.23000000E-06  -2.09030000E-04  +2.50010000E-04  +3.26010000E-04
   +3.15030000E-04  +4.20470000E-04  +3.31310000E-04  +2.65113000E-03  -2.40173600E-02
   -1.71528400E-02  +1.29703700E-02  -1.32361820E-01  -1.62439350E-01  -7.91000000E-05
   -1.52600000E-05  +2.44200000E-05  +1.11560000E-03  -5.34790000E-04  +1.22059000E-03
   +5.25650000E-04  -6.21410000E-04  -3.89780000E-04  -3.14370000E-04  +6.39590000E-04
   +4.82200000E-04  +1.25480000E-04  -2.25140000E-04  -1.22540000E-04  -2.94100000E-05
   +1.01670000E-04  +8.93000000E-05  -3.34300000E-05  -1.86900000E-05  -4.33400000E-04
   +6.30600000E-05  +4.43100000E-05  +1.05340000E-04  +5.80600000E-05  -4.85000000E-05
   +5.37300000E-05  +2.23300000E-04  +3.45401000E-03  -6.25283000E-03  -1.13910000E-04
   +9.14100000E-05  +2.98900000E-04  +9.60000000E-07  +5.36000000E-06  -8.18000000E-06
   -1.84500000E-05  +1.35700000E-05  -2.21900000E-05  -1.70080000E-04  -3.69000000E-05
   +1.06050000E-04  -4.45000000E-05  +1.23797000E-03  +2.75220000E-04  +4.72900000E-05
   +2.40000000E-06  -5.07000000E-06  -1.51930000E-04  +5.61156000E-03  +4.39437000E-03
   -6.89020000E-04  +3.90823000E-03  +2.79360000E-03  -1.46221800E-02  +1.44936380E-01
   +1.75849940E-01  -9.87700000E-05  -2.89300000E-05  +3.60700000E-05  -4.50200000E-05
   +1.83320000E-04  -8.28900000E-05  -6.17030000E-04  -9.44390000E-04  -8.75670000E-04
   -2.82500000E-05  +7.93400000E-05  +1.53040000E-04  -4.49900000E-05  -4.75500000E-05
   +5.43700000E-05  +7.11300000E-05  +1.26920000E-04  -1.44700000E-05  -1.70314000E-03
   -1.40671000E-03  +3.05009000E-03  -4.01610000E-04  +7.10670000E-04  +3.57900000E-05
   +9.20000000E-05  +1.16340000E-04  +7.79000000E-06  +1.71510000E-04  -1.83710000E-04
   +1.76740000E-04  -8.57100000E-05  -4.99700000E-05  -2.06430000E-04  -1.95590000E-04
   -2.86460000E-04  -4.13600000E-05  -1.22170000E-04  +2.38780000E-04  +4.16210000E-04
   +2.34630000E-04  -3.61760000E-04  -2.46610000E-04  -1.78541000E-03  +2.00075000E-03
   +5.26470000E-04  +1.83300000E-04  -1.11530000E-04  -7.07000000E-05  +5.28600000E-05
   +3.88100000E-05  -1.18730000E-04  -4.89701200E-02  -4.33691000E-03  +2.22312600E-02
   -1.20710000E-04  -5.93110000E-04  -2.30770000E-04  -2.38900000E-05  -2.60900000E-05
   +3.23000000E-06  -8.43000000E-06  -2.20000000E-07  -2.65200000E-05  -1.76670000E-03
   -1.18855000E-03  -4.02810000E-04  +6.42000000E-06  +3.76500000E-05  +3.78400000E-05
   +1.24300000E-05  +6.91000000E-06  +1.27100000E-05  +2.99720000E-04  -2.32210000E-04
   +2.85170000E-04  +1.97600000E-04  +2.02470000E-04  -3.35880000E-04  +7.01430000E-04
   -1.70300000E-05  +2.73860000E-04  +5.53574600E-02  +1.92600000E-04  -1.93890000E-04
   -3.52800000E-05  +1.43560000E-04  +1.20881000E-03  +3.90060000E-04  -1.01517000E-03
   -4.23790000E-04  +1.35040000E-04  -5.81800000E-05  -2.44040000E-04  -5.73300000E-05
   -1.56940000E-04  +6.30600000E-05  +2.04830000E-04  +1.72660000E-04  +1.16600000E-04
   -1.86400000E-05  +1.89265000E-03  +8.64338000E-03  -2.58612000E-02  +5.72420000E-04
   -4.60223000E-03  -2.41491000E-03  +5.85200000E-05  +2.36100000E-05  -3.06100000E-05
   -4.92770000E-04  +8.65320000E-04  +3.19290000E-04  -5.63000000E-05  -7.58700000E-05
   -1.32400000E-05  +3.67000000E-05  +1.30490000E-04  +4.03600000E-05  +1.15490000E-04
   -2.17890000E-04  -1.24240000E-04  -2.82120000E-04  -2.43900000E-05  +5.81400000E-05
   +2.75413000E-03  -1.40870000E-04  -3.72300000E-05  -8.24100000E-05  +5.90800000E-05
   +3.75000000E-06  -2.61300000E-05  -1.29500000E-05  +5.97800000E-05  -4.63324000E-03
   -6.10173200E-02  +5.75361200E-02  -6.82880000E-04  -3.50000000E-07  +3.71180000E-04
   -1.21300000E-05  +2.15000000E-06  +2.78000000E-06  -1.97300000E-05  +1.14000000E-05
   -1.53500000E-05  -1.45060000E-03  -4.93400000E-04  -4.02300000E-04  -2.43700000E-05
   +9.40800000E-05  -1.07600000E-05  +2.06000000E-06  +1.56500000E-05  -1.76700000E-05
   -2.74400000E-04  -8.93000000E-05  -2.06900000E-05  +2.99150000E-04  -6.74000000E-06
   -2.76500000E-05  +1.31660000E-04  +5.72900000E-04  -1.80909000E-03  +4.03778000E-03
   +6.51614700E-02  -1.36260000E-04  -3.39910000E-04  +5.91100000E-05  +8.09920000E-04
   +7.95310000E-04  +1.79600000E-04  +1.13373000E-03  -1.18220000E-04  -4.08330000E-04
   -3.22480000E-04  +2.58900000E-04  +5.12390000E-04  +4.48000000E-05  +1.52030000E-04
   -2.12500000E-05  +8.83500000E-05  +1.44200000E-04  +2.08900000E-05  +9.90950000E-04
   +5.38507000E-03  -1.60710400E-02  +3.95840000E-04  -4.73099000E-03  -1.82271000E-03
   -1.68900000E-05  +5.31500000E-05  +6.88500000E-05  -5.81640000E-04  +2.24450000E-04
   -2.08980000E-04  -1.09450000E-04  -6.77400000E-05  +1.64840000E-04  +3.10540000E-04
   +1.18650000E-04  +2.49390000E-04  +3.71700000E-05  -2.43720000E-04  -7.07670000E-04
   -2.44470000E-04  +7.32730000E-04  +6.25380000E-04  -9.38780000E-04  +3.89100000E-05
   -9.19900000E-04  -1.52470000E-04  +1.06200000E-04  +1.50620000E-04  +5.15200000E-05
   -4.08800000E-05  +1.04620000E-04  +2.26552100E-02  +5.47694000E-02  -3.03820390E-01
   -4.37740000E-04  +1.40630000E-04  +1.70930000E-04  -2.43600000E-05  -2.73000000E-05
   -9.99000000E-06  -4.03000000E-06  -4.69400000E-05  +1.11000000E-06  -4.85930000E-04
   +3.45600000E-04  +8.66280000E-04  -1.38000000E-06  +1.51420000E-04  +4.37900000E-05
   -2.45600000E-05  -1.87000000E-06  -8.33000000E-06  +8.55800000E-05  -1.84300000E-05
   +4.17130000E-04  -5.15400000E-05  +4.73500000E-05  +3.50380000E-04  +1.49080000E-04
   +3.32970000E-04  -1.32854000E-03  -2.31410000E-02  -6.16905200E-02  +3.30777800E-01
   +4.56000000E-04  +3.83280000E-04  +2.74580000E-04  +3.46120000E-04  +5.69750000E-04
   +5.41010000E-04  -1.52210000E-04  +6.59300000E-05  +4.83180000E-04  +2.54290000E-04
   -6.89700000E-05  -1.32620000E-04  +1.46870000E-04  +1.90100000E-05  -1.27600000E-04
   -1.72810000E-04  -1.06110000E-04  +5.56400000E-05  +2.56812000E-03  +3.19622000E-03
   -1.49570000E-04  +1.08610000E-04  +4.02090000E-04  +1.00960000E-04  -1.76650000E-04
   -1.54280000E-04  -5.34000000E-06  +4.21480000E-04  +3.17550000E-04  -4.52130000E-04
   +1.60230000E-04  -6.46000000E-06  +1.65120000E-04  +5.66700000E-05  -1.36850000E-04
   +1.15040000E-04  -6.66300000E-05  -4.57800000E-05  -1.42710000E-04  -1.98800000E-05
   +1.48900000E-05  +9.21500000E-05  +1.83710000E-04  +4.64000000E-05  -2.28530000E-04
   +7.08700000E-05  -5.46000000E-06  +2.93700000E-05  +6.22700000E-05  -2.51900000E-05
   -3.65200000E-05  -2.17121830E-01  -1.27546270E-01  +2.69071700E-02  +1.00960000E-04
   +3.04730000E-04  -4.99600000E-05  +4.03400000E-05  +2.53200000E-05  -8.11000000E-06
   -9.19000000E-06  -5.64000000E-06  +2.48700000E-05  +1.33000000E-05  -1.32490000E-04
   -5.24090000E-04  +5.68500000E-05  -5.08100000E-05  -5.47400000E-05  -2.06900000E-05
   +2.25600000E-05  -2.51300000E-05  -9.11200000E-05  -1.23470000E-04  +6.52400000E-05
   +3.15710000E-04  +5.60100000E-05  -3.12520000E-04  +2.15970000E-04  +2.15420000E-04
   -1.17910000E-04  -1.60173000E-03  -6.00200000E-05  -2.45470000E-04  +2.33132400E-01
   -1.49106000E-03  -6.54630000E-04  +6.30370000E-04  +1.90004000E-03  -3.37156000E-03
   -3.68018000E-03  +4.94770000E-04  +1.42810000E-04  -6.52290000E-04  -1.27370000E-04
   -2.68300000E-05  +8.33000000E-06  +2.62310000E-04  +1.58110000E-04  -4.20000000E-07
   +2.58200000E-05  -3.72240000E-04  -3.32740000E-04  -2.20714300E-02  -1.74688000E-02
   +3.71629000E-03  -4.44300000E-04  +5.75920000E-04  +1.50565000E-03  -2.76580000E-04
   -2.18190000E-04  +5.60300000E-05  -7.64180000E-04  +1.30599000E-03  +3.23890000E-04
   +6.79930000E-04  -3.33420000E-04  -2.03630000E-04  -1.31960000E-04  +4.46300000E-04
   -2.52990000E-04  +8.56200000E-05  -8.11400000E-05  +1.01000000E-05  +1.74490000E-04
   +2.94660000E-04  +6.24000000E-05  -4.12090000E-04  -7.61600000E-04  +1.62500000E-04
   -1.41090000E-04  +6.53000000E-05  +4.10000000E-07  -8.36000000E-05  -4.55300000E-05
   +1.13250000E-04  -1.25733880E-01  -1.40289710E-01  +2.06197800E-02  +5.00610000E-04
   +3.75630000E-04  -8.60000000E-05  +3.41800000E-05  +1.61500000E-05  -1.90000000E-05
   -6.30800000E-05  -1.87900000E-05  +7.28000000E-06  +2.59360000E-04  +1.36700000E-04
   +1.63760000E-04  +5.64300000E-05  -1.02000000E-05  -7.05000000E-05  -1.19220000E-04
   -1.09660000E-04  +1.73800000E-05  +1.48890000E-04  +5.75000000E-06  -9.90100000E-05
   +2.97720000E-04  +5.24000000E-04  -6.56740000E-04  +3.89710000E-04  +1.56030000E-04
   +1.67150000E-04  -4.86345000E-03  -4.36948000E-03  +5.07300000E-04  +1.38297240E-01
   +1.53957750E-01  -8.42650000E-04  -6.95170000E-04  +5.45200000E-04  +1.34669000E-03
   -2.71084000E-03  -2.32766000E-03  +8.19540000E-04  -1.07190000E-04  -6.11090000E-04
   -1.28550000E-04  +1.82480000E-04  +3.50490000E-04  +1.51020000E-04  +5.70200000E-05
   -8.57800000E-05  -5.26400000E-05  -1.27610000E-04  -2.24420000E-04  -1.49204500E-02
   -1.09933000E-02  +8.29810000E-04  -1.26031000E-03  -8.06200000E-04  +7.57010000E-04
   -7.32900000E-05  +3.20000000E-06  +5.16700000E-05  -2.39650000E-04  +1.03204000E-03
   +5.75190000E-04  +2.13350000E-04  -8.58100000E-05  -2.43360000E-04  -1.88840000E-04
   +4.05700000E-05  -1.41600000E-04  -2.64300000E-05  +1.04100000E-04  +3.03810000E-04
   +1.00300000E-05  -2.81580000E-04  -1.52460000E-04  +4.63150000E-04  +7.40490000E-04
   +3.33270000E-04  +5.24100000E-05  -5.08000000E-05  -6.71900000E-05  -3.93800000E-05
   -4.03000000E-06  -3.12600000E-05  +2.76106200E-02  +2.16527000E-02  -5.14953500E-02
   -4.21540000E-04  -9.89300000E-05  +2.19000000E-05  -6.59000000E-06  -1.86400000E-05
   -3.50000000E-06  -5.56000000E-06  -2.51700000E-05  +5.94000000E-06  -4.51420000E-04
   +3.50370000E-04  +2.62300000E-04  +4.47000000E-05  -1.04400000E-05  +5.00400000E-05
   -1.02230000E-04  -3.19100000E-05  -2.14000000E-05  -3.89300000E-05  +3.86600000E-05
   -2.70400000E-05  +4.11910000E-04  -2.13420000E-04  -6.82090000E-04  +1.41570000E-04
   +2.74340000E-04  +1.97690000E-04  +2.56967100E-02  +1.83174900E-02  -2.55417000E-03
   -3.03421200E-02  -1.99914200E-02  +5.44859400E-02  +2.41210000E-04  +2.24060000E-04
   +1.18340000E-04  +3.02420000E-04  -5.66740000E-04  +8.00800000E-05  -1.00940000E-04
   -5.01470000E-04  +4.53170000E-04  +1.24610000E-04  +1.99300000E-05  -2.86200000E-05
   -4.88000000E-05  -4.91700000E-05  -8.81100000E-05  -4.93800000E-05  -5.76100000E-05
   +2.55900000E-05  -3.78845000E-03  +1.00200000E-03  -1.09719000E-03  +1.08400000E-05
   -4.05130000E-04  -6.65530000E-04  +6.21200000E-05  +4.34200000E-05  -1.08600000E-05
   +8.18180000E-04  +1.05969000E-03  +8.99880000E-04  +4.89820000E-04  -2.15050000E-04
   -4.47900000E-04  -1.72800000E-04  +4.27620000E-04  -2.60680000E-04  +1.84690000E-04
   -4.73600000E-05  +1.47580000E-04  +9.43700000E-05  +1.28070000E-04  -1.62400000E-05
   -1.07950000E-04  -5.46190000E-04  +1.72830000E-04  -2.36250000E-04  +8.63200000E-05
   -2.33100000E-05  -1.82420000E-04  -1.98800000E-05  +1.44430000E-04  -2.25533830E-01
   +1.08110880E-01  -6.35757300E-02  +2.91440000E-04  +2.70710000E-04  -7.33800000E-05
   -9.65000000E-06  +5.90000000E-06  +1.84000000E-06  +2.82600000E-05  +2.42000000E-06
   +1.19300000E-05  -1.50830000E-04  -5.91510000E-04  +1.61740000E-04  -1.03200000E-05
   -3.95000000E-06  -1.87700000E-05  -4.07000000E-06  +2.77100000E-05  -1.58800000E-05
   +4.65500000E-04  -9.47800000E-05  +5.79950000E-04  -1.36050000E-04  +1.07310000E-04
   -5.19000000E-05  +3.39830000E-04  -2.73630000E-04  +1.06490000E-04  +2.92377000E-03
   -2.66103000E-03  +1.24277000E-03  -1.91455600E-02  +1.32827500E-02  -7.90692000E-03
   +2.43487820E-01  -3.55420000E-04  -2.26420000E-04  -3.86620000E-04  +8.70120000E-04
   +9.43020000E-04  +4.50160000E-04  -1.31110000E-04  -2.55300000E-04  -1.89410000E-04
   -3.36230000E-04  -3.08700000E-05  +9.84700000E-05  -1.79560000E-04  +7.89900000E-05
   +2.36000000E-04  +2.75900000E-04  +2.29320000E-04  -9.36500000E-05  +2.27047100E-02
   -1.39919700E-02  +8.23258000E-03  +2.77680000E-04  +4.94070000E-04  +1.75679000E-03
   +1.35030000E-04  +1.24000000E-04  -8.74000000E-06  -6.35040000E-04  -3.47294000E-03
   -3.94560000E-03  +9.82560000E-04  -5.35990000E-04  +9.15160000E-04  +2.33380000E-04
   -1.67620000E-04  -5.66500000E-05  -1.43550000E-04  -1.11320000E-04  -2.84520000E-04
   -3.15000000E-05  +9.37200000E-05  +1.76230000E-04  -1.33230000E-04  +8.06200000E-05
   -8.28380000E-04  +1.72940000E-04  -3.66500000E-05  +7.25400000E-05  +3.25010000E-04
   -1.08190000E-04  -1.02270000E-04  +1.06561110E-01  -1.11847950E-01  +3.83956600E-02
   -8.88300000E-05  -9.43700000E-05  +6.39500000E-05  -2.61600000E-05  -2.85300000E-05
   +1.24800000E-05  +9.90000000E-06  -2.99300000E-05  +3.29000000E-06  -2.57120000E-04
   -6.94620000E-04  +8.48880000E-04  +3.75200000E-05  +3.77900000E-05  +9.80900000E-05
   +3.44200000E-05  -1.95700000E-05  +3.23500000E-05  -3.54040000E-04  +5.54440000E-04
   -7.26170000E-04  -1.47400000E-04  -2.53000000E-06  -1.05590000E-04  -4.21830000E-04
   +1.01540000E-04  +1.65910000E-04  +5.17265000E-03  -4.00818000E-03  +1.66153000E-03
   -1.57949800E-02  +1.05419200E-02  -6.62152000E-03  -1.18676510E-01  +1.22164420E-01
   +3.64800000E-05  +1.20450000E-04  -2.33400000E-04  -5.78500000E-05  +5.85100000E-04
   +3.18920000E-04  -2.60020000E-04  +2.25870000E-04  +7.58270000E-04  +7.48300000E-05
   -2.11890000E-04  -1.71770000E-04  -1.22710000E-04  +4.34800000E-05  +5.93000000E-05
   +6.81800000E-05  -2.60900000E-05  -1.80700000E-05  +1.55862900E-02  -9.06172000E-03
   +3.61463000E-03  +1.49274000E-03  -1.14541000E-03  +7.94510000E-04  +2.64100000E-05
   -2.47700000E-05  -4.39700000E-05  -2.18690000E-04  -2.85907000E-03  -2.62159000E-03
   +4.15500000E-04  -4.49930000E-04  +5.62310000E-04  +5.25130000E-04  +1.09910000E-04
   +1.28710000E-04  +4.97700000E-05  -2.85500000E-04  -7.16170000E-04  -2.93500000E-04
   +5.83850000E-04  +5.17060000E-04  -6.22300000E-05  -6.39550000E-04  -1.09245000E-03
   -1.30600000E-04  +1.07160000E-04  +1.34670000E-04  +1.59580000E-04  -3.52500000E-05
   +2.63300000E-05  -6.42797300E-02  +3.98614500E-02  -7.00482700E-02  -2.23950000E-04
   +4.24910000E-04  +2.98790000E-04  +6.31000000E-06  +2.04300000E-05  +5.02000000E-06
   +1.59200000E-05  +7.61000000E-06  +1.44400000E-05  +2.15900000E-05  +2.95740000E-04
   -5.83200000E-04  +1.86600000E-05  -4.08700000E-05  -9.45000000E-06  +2.22400000E-05
   -7.21000000E-06  +7.79000000E-06  -2.24620000E-04  -3.44840000E-04  -7.97660000E-04
   +1.18700000E-05  +9.86300000E-05  -5.22200000E-05  -8.81800000E-05  +2.05040000E-04
   +2.32900000E-04  -2.63510300E-02  +1.48085500E-02  -7.68560000E-03  +4.22798000E-03
   -2.82392000E-03  +5.47990000E-04  +6.96825500E-02  -3.99953700E-02  +7.55791200E-02
   -5.39000000E-06  +5.92700000E-05  -2.47800000E-05  -1.68920000E-04  -8.07600000E-05
   +1.61300000E-05  +4.91700000E-05  -3.52700000E-05  -7.49600000E-05  +1.46600000E-05
   +8.54500000E-05  -6.10000000E-07  +4.14000000E-06  -2.87600000E-05  -3.71000000E-05
   -3.94700000E-05  +8.26700000E-05  -1.99600000E-05  -4.47910000E-04  -8.40770000E-04
   +4.18520000E-04  +2.57550000E-04  +1.57540000E-04  +9.07500000E-05  +5.22200000E-05
   +5.96900000E-05  -9.78000000E-06  +4.55431000E-03  -8.07023000E-03  -1.08576000E-03
   -3.93820000E-04  +1.02630000E-04  -2.44421000E-03  +1.59957000E-03  +2.77393000E-03
   +8.02610000E-04  -1.75789000E-03  +2.21436000E-03  -6.36986000E-03  -9.12029000E-03
   +2.86424600E-02  +1.49984100E-02  -4.59673300E-02  +3.75138800E-02  +4.97215000E-03
   -1.58592000E-03  +2.90440000E-04  +1.54375000E-03  -2.74690000E-04  -5.40750000E-04
   +6.45740000E-04  -1.66665000E-03  +1.37598000E-03  -1.62707000E-03  -1.10623400E-02
   -3.02867500E-02  +3.73848000E-03  +2.21000000E-06  -1.03900000E-05  +1.21000000E-05
   +2.40200000E-05  -2.55000000E-06  +3.90000000E-07  -4.98400000E-05  -2.96100000E-05
   +5.06200000E-05  -8.07000000E-06  -7.65000000E-06  +2.65000000E-06  +1.40400000E-05
   +2.69000000E-06  +1.43300000E-05  +4.64100000E-05  -6.57500000E-05  +5.03500000E-05
   +1.67800000E-05  +8.42000000E-06  -4.70300000E-05  -7.84000000E-06  +1.41400000E-05
   +1.17530000E-04  -3.00138000E-03  +1.78738000E-03  -8.37760000E-04  -8.12900000E-05
   +9.59500000E-05  +9.51000000E-06  -2.53700000E-05  -1.94550000E-04  +9.48200000E-05
   +6.89671600E-02  -4.63200000E-05  +2.53300000E-05  -5.58000000E-06  -1.08690000E-04
   +6.40600000E-05  -2.39500000E-05  +1.13100000E-05  -7.81400000E-05  -6.66000000E-05
   -1.07000000E-06  +4.14600000E-05  -1.55300000E-05  +6.69500000E-05  +3.92000000E-05
   -2.43000000E-05  -2.30700000E-05  +8.09000000E-05  -8.67000000E-06  +6.31020000E-04
   -7.46170000E-04  -6.34530000E-04  -1.09480000E-04  +7.57500000E-05  +9.05600000E-05
   -4.84700000E-05  -1.83400000E-05  +3.77000000E-06  +1.21103000E-03  +4.08605000E-03
   -1.73627000E-03  -2.88660000E-04  -3.49400000E-04  -4.37500000E-05  +1.08250000E-04
   +1.54728000E-03  +3.27630000E-04  +1.37399000E-03  -5.77600000E-04  +9.59080000E-04
   +3.27665000E-03  -4.59943000E-03  -6.68045000E-03  +3.75485700E-02  -2.56318310E-01
   -1.07671050E-01  +3.24100000E-04  -3.18400000E-04  -5.25840000E-04  -7.98500000E-05
   -2.63120000E-04  +4.08000000E-05  +3.40746000E-03  -1.08045000E-03  +1.05960000E-03
   -1.48465100E-02  -2.61577300E-02  +5.87029000E-03  +1.90300000E-05  -4.28000000E-06
   +2.55000000E-06  +4.39000000E-06  -1.08500000E-05  +7.22000000E-06  -5.51000000E-05
   -4.31400000E-05  +2.84600000E-05  +1.08000000E-05  -7.48000000E-06  +1.04200000E-05
   +1.21500000E-05  -4.41000000E-06  +1.39500000E-05  -8.73100000E-05  +7.67200000E-05
   -4.71200000E-05  +1.40000000E-05  -8.20000000E-07  +2.46600000E-05  -1.66400000E-05
   +2.40000000E-07  +2.70400000E-05  +1.43132000E-03  -1.03332000E-03  +1.37796000E-03
   +3.07110000E-04  -3.34430000E-04  +2.94500000E-05  +1.20010000E-04  +1.02780000E-04
   +8.71970000E-04  -3.35711400E-02  +2.86981080E-01  +5.69000000E-05  -1.20520000E-04
   -2.03580000E-04  -8.60200000E-05  +1.86640000E-04  +2.96710000E-04  +1.06490000E-04
   +7.09000000E-06  -1.13240000E-04  -1.10330000E-04  -8.61500000E-05  +9.06200000E-05
   -1.10290000E-04  +2.78000000E-06  +1.12390000E-04  +1.12250000E-04  +1.27400000E-04
   +6.40000000E-07  +1.75731000E-03  -5.13990000E-04  -3.84000000E-05  -8.83400000E-05
   +1.02730000E-04  +2.05600000E-05  +6.24400000E-05  +6.32900000E-05  +3.65000000E-06
   +5.42499000E-03  -2.65676600E-02  -1.78735600E-02  -5.59698000E-03  +1.50154000E-03
   -3.00881000E-03  -7.99780000E-04  -4.38389000E-03  +1.25866000E-03  -1.41891000E-03
   +4.86260000E-04  +8.81780000E-04  +1.39442000E-03  +3.45490000E-03  +5.76535000E-03
   +2.42224000E-03  -1.07128850E-01  -9.63921000E-02  -2.48560000E-04  +2.05270000E-04
   +3.94640000E-04  +7.11580000E-04  +4.41420000E-04  -4.46600000E-04  -4.37210000E-04
   -1.49100000E-05  +1.47540000E-04  +1.15440900E-02  +2.45065900E-02  +1.21964000E-03
   -1.82700000E-05  -1.19500000E-05  -1.50000000E-07  -4.06000000E-06  -2.19000000E-06
   -4.80000000E-06  -1.16250000E-04  +8.37000000E-06  +5.93200000E-05  +5.16300000E-05
   +3.86900000E-05  +1.04860000E-04  +1.71000000E-05  +1.59500000E-05  -6.43000000E-06
   -1.32350000E-04  +4.88700000E-05  -1.70300000E-05  -8.53000000E-06  -8.48200000E-05
   -3.92100000E-05  +8.66100000E-05  +6.94800000E-05  +2.17500000E-04  -8.91460000E-04
   +3.77010000E-04  +7.69420000E-04  -6.49100000E-05  +8.22420000E-04  -6.16860000E-04
   +3.85170000E-04  +1.24550000E-04  +4.39500000E-04  -1.64486700E-02  +1.04427640E-01
   +1.09595890E-01  -2.05600000E-05  -5.92500000E-05  +6.52000000E-06  +1.35820000E-04
   +1.71060000E-04  -2.45000000E-06  -1.10000000E-05  -3.15100000E-05  +5.35000000E-06
   -1.74200000E-05  -4.78800000E-05  +7.04000000E-06  +2.98900000E-05  +4.65000000E-05
   +1.32500000E-05  +3.40000000E-06  -2.50000000E-06  +1.16100000E-05  -7.79100000E-05
   -4.13560000E-04  -1.16341000E-03  -3.15140000E-04  +8.28400000E-05  +1.83300000E-05
   -6.14200000E-05  -5.66400000E-05  +1.43600000E-05  -3.29947000E-03  +2.29807000E-03
   +7.71100000E-05  -1.44066000E-03  +1.25826000E-03  +7.34910000E-04  +5.09800000E-05
   +1.17835000E-03  +1.11955000E-03  +9.36902000E-03  +4.25111000E-03  +1.40570900E-02
   -1.10379730E-01  -1.88061400E-02  -1.20571600E-01  -9.13029000E-03  -6.00366000E-03
   -2.40536400E-02  +4.81040000E-04  -2.48001000E-03  +1.39970000E-04  +1.94500000E-05
   +1.03654000E-03  +8.88040000E-04  +4.13900000E-05  -1.03590000E-04  +3.70000000E-07
   +7.02130000E-04  +2.70100000E-05  +4.93420000E-04  +4.49000000E-06  +5.90000000E-06
   -1.01200000E-05  -1.56600000E-05  -2.81000000E-06  +1.44000000E-06  +2.96000000E-06
   +1.87900000E-05  -1.27100000E-05  +4.78000000E-06  +1.64500000E-05  +7.22000000E-06
   -5.54000000E-06  -2.84000000E-06  -4.68000000E-06  -3.24000000E-06  +5.13400000E-05
   -1.06730000E-04  +1.38400000E-05  -3.09000000E-06  +8.58000000E-06  +1.16800000E-05
   -1.36300000E-05  -1.34300000E-05  +1.16500000E-05  +1.66300000E-05  -7.96000000E-06
   +1.58300000E-05  -2.27000000E-06  +1.63800000E-05  -2.12900000E-05  +3.23100000E-05
   -1.77400000E-05  +2.55230000E-04  -1.12100000E-04  +8.82580000E-04  +1.14422920E-01
   +1.90200000E-05  -2.27300000E-05  -4.65000000E-06  -1.64790000E-04  +4.35700000E-05
   -3.14100000E-05  -2.08700000E-05  -3.69000000E-06  +9.79000000E-06  +9.07000000E-06
   -1.67800000E-05  +2.78900000E-05  -3.11500000E-05  -2.29700000E-05  +1.00000000E-08
   +1.78000000E-05  -2.02900000E-05  +7.74000000E-06  -3.12050000E-04  -3.47430000E-04
   +9.24980000E-04  +2.70600000E-04  -1.40100000E-04  -3.73000000E-06  +2.82400000E-05
   +1.93600000E-05  +1.25000000E-06  +3.40498000E-03  +1.19654000E-03  -1.10296000E-03
   +1.34290000E-04  -3.93730000E-04  +9.44550000E-04  +4.66375000E-03  +1.55313000E-03
   -1.52592000E-03  -1.12176200E-02  +1.43811000E-03  -1.53465400E-02  -1.63893800E-02
   -5.01844300E-02  -6.74708000E-02  +5.42689000E-03  +4.68927000E-03  +1.13702800E-02
   -1.67413000E-03  -3.42482000E-03  +2.82631000E-03  +2.31870000E-04  +7.77420000E-04
   -2.28062000E-03  -2.00300000E-05  +6.87800000E-05  +2.86900000E-05  +4.86970000E-04
   -6.14270000E-04  +1.06048000E-03  -1.16600000E-05  +5.00000000E-08  -4.50000000E-06
   -4.46000000E-06  +4.36000000E-06  -4.34000000E-06  -7.68000000E-06  +1.94200000E-05
   -1.11500000E-05  -4.36000000E-06  -3.86000000E-06  -1.75300000E-05  +1.53000000E-06
   +3.49000000E-06  -1.87000000E-06  +2.86000000E-06  -4.82000000E-05  +1.03740000E-04
   -1.20600000E-05  -1.26000000E-05  +1.41800000E-05  -5.70000000E-06  +7.89000000E-06
   -6.20000000E-06  +4.56000000E-06  +5.47600000E-05  -4.12100000E-05  +3.61000000E-06
   -4.40400000E-05  +3.59700000E-05  -4.74000000E-06  -1.51600000E-05  -3.05300000E-05
   -1.63783000E-03  +3.05700000E-04  +9.67170000E-04  +1.82904500E-02  +4.52035500E-02
   -1.59300000E-05  +3.34000000E-06  -1.59900000E-05  +5.71500000E-05  +4.73400000E-05
   +1.03500000E-05  +5.82000000E-06  -8.80000000E-06  -2.72700000E-05  -1.50600000E-05
   -2.51700000E-05  -1.32000000E-05  +7.10000000E-05  +6.02300000E-05  -1.30000000E-07
   -1.88000000E-05  +1.51300000E-05  +1.82000000E-05  +4.93360000E-04  +1.73590000E-04
   -3.48470000E-04  -2.10970000E-04  +7.94500000E-05  +2.30500000E-05  -8.69100000E-05
   -6.80700000E-05  +1.28100000E-05  -1.31693000E-03  -1.49850000E-04  +1.98616000E-03
   +7.71290000E-04  -3.10460000E-04  -5.50300000E-05  +2.15969000E-03  -1.61748000E-03
   +1.03320000E-03  -1.41687600E-02  -4.65238000E-03  -1.86294300E-02  -1.17382330E-01
   -6.49445600E-02  -2.56950420E-01  +2.16227000E-03  -1.02813000E-03  -1.74402000E-03
   +5.93640000E-04  +2.91112000E-03  +9.05760000E-04  +1.15100000E-04  -1.34453000E-03
   -9.97790000E-04  -7.81800000E-05  -3.37800000E-05  -5.21100000E-05  -6.68850000E-04
   -2.42780000E-04  +7.05120000E-04  +1.63400000E-05  +6.59000000E-06  -5.03000000E-06
   -8.09000000E-06  -4.70000000E-06  +6.28000000E-06  +4.75000000E-06  -1.49000000E-06
   +2.96000000E-06  +1.52000000E-05  +1.15600000E-05  +2.01700000E-05  -2.90000000E-07
   -4.46000000E-06  -1.12000000E-06  -2.45000000E-05  +3.62700000E-05  -7.48100000E-05
   +1.12800000E-05  -5.33000000E-06  +7.90000000E-07  +1.94700000E-05  -6.70000000E-07
   +1.17900000E-05  -3.62000000E-06  -2.21900000E-05  +1.59500000E-05  +2.21000000E-06
   +1.25800000E-05  -2.64400000E-05  -1.66700000E-05  +3.61400000E-05  +2.34900000E-05
   +3.40400000E-04  +5.63280000E-04  +1.31140000E-04  +1.27719420E-01  +7.02580100E-02
   +2.74036160E-01  +8.23700000E-05  -7.90500000E-05  +3.41450000E-04  +2.94630000E-04
   +1.44206000E-03  -4.62030000E-04  -4.65300000E-04  -2.40800000E-04  -1.17630000E-04
   +1.22040000E-04  -2.92080000E-04  +2.07000000E-06  +2.24440000E-04  +3.18680000E-04
   +2.08150000E-04  +2.82400000E-05  -6.84040000E-04  +4.95480000E-04  +1.78383000E-03
   -7.17010000E-04  +5.07640000E-04  -6.84940000E-04  +2.72360000E-04  +2.39300000E-04
   -5.88420000E-04  -6.42190000E-04  +6.84000000E-05  -4.05656000E-03  +9.36349000E-03
   +1.26491100E-02  +1.55614800E-02  -1.54203200E-02  -2.35780000E-03  -1.88379000E-03
   +5.07753900E-02  -5.84526000E-03  -1.00692200E-02  -1.42602300E-02  -1.49280800E-02
   -5.29543000E-03  +4.70340000E-03  +3.59345000E-03  +5.60202000E-03  +5.19301000E-03
   -1.08666300E-02  +4.55557000E-03  -1.02691000E-03  +1.06644000E-03  -4.96613000E-03
   -1.03626500E-02  +4.10913000E-03  -5.07860000E-04  -6.58000000E-05  -3.67030000E-04
   -7.41776000E-03  -8.83670000E-03  +4.37305000E-03  +9.95000000E-06  +7.58300000E-05
   -6.57800000E-05  -8.94400000E-05  -3.42500000E-05  +1.89000000E-05  +1.17910000E-04
   +3.45600000E-05  -1.27650000E-04  +2.33300000E-05  +4.40580000E-04  -3.13140000E-04
   -2.42290000E-04  -3.46600000E-05  -1.87400000E-04  -2.05300000E-04  +1.71400000E-04
   -3.38680000E-04  +1.33400000E-05  -1.50880000E-04  +1.81740000E-04  +9.69400000E-05
   -6.42300000E-05  -1.30230000E-04  +1.48250000E-04  -3.07900000E-05  +1.00600000E-05
   +3.46300000E-05  -3.14560000E-04  -3.69100000E-05  -2.79170000E-04  +2.51880000E-04
   +3.95000000E-05  -1.19952000E-03  -6.01420000E-04  +1.85153000E-03  +6.16110000E-04
   +1.05016000E-03  -3.52960000E-04  +8.37824600E-02  +3.00520000E-04  -1.21690000E-04
   +2.00490000E-04  +7.33180000E-04  +1.52754000E-03  -4.66750000E-04  -4.54670000E-04
   -2.27390000E-04  -1.29860000E-04  +3.20200000E-05  -4.54880000E-04  -2.18900000E-05
   +3.28500000E-04  +5.39980000E-04  +3.50310000E-04  +7.25400000E-05  -8.79360000E-04
   +8.06550000E-04  +2.74399000E-03  +1.60940000E-04  +5.17630000E-04  -9.24210000E-04
   +2.28490000E-04  +1.02480000E-04  -8.79180000E-04  -9.85240000E-04  +1.34550000E-04
   -4.15641000E-03  +7.87610000E-03  +1.39371600E-02  +1.87401300E-02  -3.22551200E-02
   -3.61460000E-04  +2.11206200E-02  +5.37224500E-02  +1.00356000E-03  -1.41940800E-02
   -1.72796000E-02  -2.85784100E-02  -9.09607000E-03  +7.49255000E-03  +8.10022000E-03
   +1.03573600E-02  +5.42462000E-03  -1.26794500E-02  +9.12520000E-03  -2.19879000E-03
   +3.11748000E-03  +2.97598000E-03  -5.35726000E-03  -4.94427000E-03  -8.90900000E-04
   +2.95100000E-05  -4.00110000E-04  -1.18657400E-02  -1.22528000E-02  +5.61067000E-03
   +6.08000000E-06  +1.28630000E-04  -9.86100000E-05  -1.27270000E-04  -3.76100000E-05
   +2.12400000E-05  +1.88430000E-04  +3.08100000E-05  -1.53430000E-04  +1.82220000E-04
   +6.09720000E-04  -1.39380000E-04  -3.70760000E-04  -2.72700000E-05  -3.19000000E-04
   -2.81310000E-04  +2.92310000E-04  -3.37220000E-04  +1.94000000E-06  -2.50010000E-04
   +2.13760000E-04  +2.29500000E-04  -2.11200000E-05  -4.87400000E-05  +2.41900000E-04
   -4.47500000E-05  -7.46000000E-06  +1.69900000E-05  -4.15700000E-04  -2.42200000E-05
   -3.82820000E-04  +3.84630000E-04  +2.89500000E-05  -1.75968000E-03  -6.29040000E-04
   +2.27389000E-03  +4.11900000E-04  +1.13762000E-03  -6.70800000E-05  +4.15640000E-03
   +8.20321900E-02  -2.07590000E-04  -8.14000000E-06  +7.62600000E-05  -2.60480000E-04
   -2.17920000E-04  +5.99500000E-05  +1.13200000E-04  +4.87000000E-06  -1.79000000E-06
   -1.04900000E-05  +6.57700000E-05  -1.72200000E-05  -5.52500000E-05  -9.96500000E-05
   -9.28500000E-05  -3.69100000E-05  +2.93090000E-04  -2.79420000E-04  -9.45450000E-04
   -6.01810000E-04  +7.84200000E-05  +2.57640000E-04  -3.71100000E-05  +4.28200000E-05
   +1.84820000E-04  +2.29510000E-04  -4.48400000E-05  +7.45240000E-04  -2.66783000E-03
   -4.15905000E-03  -3.67405000E-03  +1.06964500E-02  -6.29050000E-04  -1.28776100E-02
   -2.55033300E-02  -1.64030900E-02  +7.17200000E-04  +9.31930000E-04  +1.27113100E-02
   +5.10687000E-03  -5.05552000E-03  -5.65482000E-03  -5.78912000E-03  -2.63793000E-03
   +3.77615000E-03  -2.26235000E-03  +1.42676000E-03  -1.46535000E-03  +7.01993000E-03
   +8.77107000E-03  -4.73448000E-03  +2.52420000E-04  -2.75900000E-05  +5.58500000E-05
   +5.11471000E-03  +5.16010000E-03  -1.80953000E-03  +1.49200000E-05  -3.67000000E-05
   +2.64800000E-05  +3.09600000E-05  -2.90000000E-07  -5.50000000E-07  -5.37800000E-05
   -3.70000000E-07  +3.00400000E-05  -7.82500000E-05  -8.00100000E-05  -1.45100000E-05
   +9.00500000E-05  -1.14300000E-05  +1.07800000E-04  +5.35500000E-05  -7.98800000E-05
   +7.67400000E-05  +9.90000000E-06  +5.61700000E-05  -5.28400000E-05  -6.62000000E-05
   +2.53000000E-06  +5.40000000E-07  -8.30800000E-05  +5.63000000E-06  +1.90300000E-05
   +5.94000000E-06  +1.13950000E-04  -2.27000000E-06  +9.14000000E-05  -8.62500000E-05
   +6.85000000E-06  +8.37870000E-04  +3.40490000E-04  -8.51870000E-04  -6.36200000E-05
   -2.75700000E-04  +1.43560000E-04  -5.44943000E-03  -1.36034900E-02  +5.90408800E-02
   -2.92310000E-04  +1.23960000E-04  +1.06040000E-04  -4.55770000E-04  +4.32880000E-04
   -4.39100000E-05  -1.62730000E-04  -1.26030000E-04  +5.60300000E-05  +1.12480000E-04
   +7.88800000E-05  +2.69100000E-05  -4.08600000E-05  -1.27000000E-04  -3.18700000E-05
   +4.80400000E-05  -1.32230000E-04  -5.37500000E-05  -1.98779000E-03  -2.90738000E-03
   +3.50400000E-04  -1.12362000E-03  +1.61969000E-03  +2.98920000E-04  +1.21030000E-04
   +1.04120000E-04  -4.09300000E-05  +9.66512000E-03  -1.94960000E-04  +1.45029100E-02
   -7.28158800E-02  +7.50452000E-03  -7.91741100E-02  -3.27039000E-03  -1.61332000E-03
   -2.42489000E-02  -2.23034000E-03  +4.73266000E-03  -5.35700000E-05  -5.38500000E-05
   -3.09600000E-04  +3.10280000E-04  +1.12264000E-03  +6.50555000E-03  +1.83906000E-03
   -1.43064000E-03  +6.48300000E-05  -1.11863000E-03  +2.55321000E-03  -2.88363000E-03
   +8.72660000E-04  +5.50010000E-04  -1.27390000E-04  +5.26800000E-05  -1.87970000E-04
   +1.32790000E-04  -1.29181000E-03  -2.22300000E-05  -1.11200000E-05  +3.92000000E-06
   +9.33000000E-06  +2.22000000E-06  -8.61000000E-06  +1.11600000E-05  -9.83000000E-06
   -1.75100000E-05  -1.36435000E-03  -5.76000000E-04  +3.08000000E-06  +6.04000000E-06
   +9.54000000E-06  +6.72000000E-06  -1.37610000E-04  -2.75490000E-04  +9.63100000E-05
   +5.92200000E-05  -4.02460000E-04  -1.35350000E-04  -1.10072000E-03  +1.47311000E-03
   -8.10980000E-04  +5.05400000E-05  -5.77900000E-05  -1.06300000E-04  +1.67800000E-05
   +3.28000000E-06  +4.16800000E-05  +5.31800000E-05  -1.25120000E-04  -1.15940000E-04
   +5.45130000E-04  -1.35610000E-04  +1.18411000E-03  -5.15100000E-05  -1.86750000E-04
   +7.25500000E-05  +3.41460000E-04  +5.33960000E-04  -6.53500000E-05  +7.26173600E-02
   +8.22200000E-05  -2.39160000E-04  -6.02100000E-05  -7.67000000E-06  +6.57760000E-04
   -5.65600000E-05  -2.06790000E-04  -1.86460000E-04  +4.09600000E-05  +6.79100000E-05
   +1.20300000E-05  +2.13800000E-05  +4.85200000E-05  -2.30500000E-05  -5.47600000E-05
   -2.39200000E-05  -1.43430000E-04  +1.45980000E-04  -3.39167000E-03  -2.92527000E-03
   +4.61670000E-04  +1.13296000E-03  -1.19082000E-03  -2.81310000E-04  -6.43300000E-05
   -4.43400000E-05  -5.35000000E-06  -4.57696000E-03  +4.44076000E-03  -1.62863300E-02
   +4.28047000E-03  -4.71268400E-02  -9.57815000E-03  +6.66484000E-03  +3.99717000E-03
   +1.83704700E-02  +3.44288000E-03  -9.12650000E-04  -2.24910000E-03  -2.35800000E-04
   -1.60290000E-04  +1.44530000E-04  +5.96571000E-03  +4.55215000E-03  -1.78849000E-03
   +1.20759000E-03  +5.77060000E-04  +9.92100000E-04  -1.81721000E-03  -9.14700000E-04
   -8.25020000E-04  +3.55930000E-04  -3.29530000E-04  +3.77750000E-04  -5.67980000E-04
   +1.95100000E-04  -2.17598000E-03  -5.66000000E-06  +5.96000000E-06  -1.28000000E-05
   -2.08000000E-05  -2.37000000E-06  -5.00000000E-06  +1.08900000E-05  +1.24200000E-05
   -2.14400000E-05  -8.30110000E-04  +1.76640000E-04  -3.53700000E-05  -2.02900000E-05
   -1.10100000E-05  +2.46000000E-06  -2.51660000E-04  +2.84650000E-04  +1.79830000E-04
   +7.50000000E-06  -2.72780000E-04  +2.47100000E-05  +1.50485000E-03  -4.88050000E-04
   +8.38990000E-04  -4.57700000E-05  +1.04240000E-04  +1.02510000E-04  +2.41700000E-05
   +2.12000000E-05  -1.44000000E-05  +7.30500000E-05  -1.05150000E-04  -1.78800000E-04
   -5.39500000E-05  -3.37400000E-04  +4.13940000E-04  -9.82400000E-05  -4.18400000E-05
   +8.83800000E-05  +2.17560000E-04  +1.39283000E-03  +5.08800000E-05  -1.26773600E-02
   +3.94036800E-02  -2.48600000E-05  -2.14780000E-04  -6.64640000E-04  +4.84400000E-05
   -2.38820000E-04  +1.39380000E-04  +1.69940000E-04  +7.26200000E-05  +1.17100000E-05
   -1.13500000E-04  -3.19800000E-05  +2.83500000E-05  +4.87100000E-05  +2.16000000E-06
   +2.75300000E-05  -8.47200000E-05  +1.69080000E-04  +2.46200000E-04  -5.83410000E-04
   +1.46093000E-03  -9.71440000E-04  -1.63559000E-03  +9.60290000E-04  -6.18000000E-05
   -8.80100000E-05  -4.27800000E-05  +5.21900000E-05  -7.69144000E-03  +2.11880000E-04
   -1.66093700E-02  -7.65792800E-02  -1.03506700E-02  -3.09042650E-01  -9.43770000E-04
   -1.71161000E-03  -8.49692000E-03  -6.80190000E-04  +9.44370000E-04  +1.51772000E-03
   +4.09430000E-04  +8.94000000E-06  +4.43970000E-04  +1.49247000E-03  -3.92193000E-03
   -6.81470000E-04  -4.98940000E-04  -9.02600000E-05  -3.36330000E-04  +2.32550000E-04
   -2.39700000E-05  +2.33988000E-03  +2.80300000E-05  +1.21740000E-04  +2.39000000E-05
   +3.20560000E-04  +3.48260000E-04  +1.73730000E-04  +2.67000000E-06  +1.09300000E-05
   -7.13000000E-06  -1.66600000E-05  +8.02000000E-06  -7.20000000E-07  -3.80500000E-05
   +1.01300000E-05  +4.26200000E-05  +2.41850000E-04  +2.41900000E-04  +4.52900000E-04
   +2.26000000E-06  +1.37300000E-05  -2.63100000E-05  -1.45390000E-04  +2.09630000E-04
   +4.58100000E-04  +1.42080000E-04  -1.33020000E-04  -1.22190000E-04  -8.86650000E-04
   +1.22513000E-03  +6.53070000E-04  -6.55000000E-05  +1.32000000E-05  +7.70600000E-05
   -2.86000000E-06  +4.46500000E-05  -3.58100000E-05  +8.81600000E-05  -5.78800000E-05
   +1.06890000E-04  -3.40400000E-04  +9.45200000E-05  -1.09804000E-03  -7.00100000E-05
   -1.15100000E-05  -8.77800000E-05  -8.30920000E-04  -1.24946000E-03  +3.31700000E-05
   +8.81360800E-02  +1.11298700E-02  +3.31751800E-01  +1.34200000E-05  +1.84200000E-05
   +5.99700000E-05  +2.02100000E-05  -1.51560000E-04  +2.21300000E-05  +8.51000000E-06
   +1.76800000E-05  +3.45800000E-05  +2.33900000E-05  +5.85300000E-05  +1.49400000E-05
   -1.54740000E-04  -1.23390000E-04  +8.89000000E-06  +3.86200000E-05  -3.87200000E-05
   -3.52500000E-05  -1.75410000E-04  +7.71800000E-05  -1.37900000E-04  +8.83900000E-05
   -1.04600000E-05  +9.80000000E-07  +1.82360000E-04  +1.36440000E-04  -2.42500000E-05
   +2.68550000E-04  -6.81330000E-04  -8.69850000E-04  -1.06610000E-03  +1.31943000E-03
   +1.06495000E-03  -4.17256000E-03  -4.18950000E-04  +1.27488000E-03  -2.35939200E-02
   +2.56416300E-02  +4.21168000E-02  -5.18340000E-03  +9.91180000E-04  -3.90054000E-03
   +5.57200000E-05  +1.34883000E-03  +1.84648000E-03  -7.47899200E-02  +5.43442800E-02
   +8.20687700E-02  +2.26438000E-03  -9.08190000E-04  +2.86635000E-03  +5.62500000E-05
   +1.25300000E-05  +5.64300000E-05  +5.21150000E-04  +2.97640000E-04  -5.56400000E-04
   -3.60600000E-05  -1.48500000E-05  +9.52000000E-06  +1.58800000E-05  +7.70000000E-06
   -1.40200000E-05  -5.88000000E-06  -5.04000000E-06  -2.40000000E-07  -3.11400000E-05
   -1.46000000E-05  -3.30900000E-05  -8.36000000E-06  +7.60000000E-06  -2.28000000E-06
   +4.87300000E-05  -4.11600000E-05  +1.53900000E-05  -1.91700000E-05  +2.21700000E-05
   -1.35600000E-05  -3.63400000E-05  -1.04000000E-05  -3.85400000E-05  -3.50000000E-07
   +1.08900000E-05  -3.31100000E-05  -2.14000000E-05  +1.57600000E-05  +1.75200000E-05
   +3.43100000E-05  -3.85900000E-05  -2.65700000E-05  -3.66900000E-04  +1.48620000E-04
   -2.90110000E-04  -7.54600000E-05  -5.03120000E-04  +7.03700000E-05  -4.29090000E-04
   -4.37580000E-04  -5.46300000E-05  +1.39750000E-04  -1.68900000E-04  +7.62900000E-05
   +1.05090180E-01  -9.10000000E-06  -1.51200000E-05  +1.30000000E-06  +5.04000000E-06
   +7.82800000E-05  -1.35900000E-05  -4.91000000E-06  -1.14600000E-05  -4.40000000E-06
   -1.40000000E-05  -4.53100000E-05  -1.31700000E-05  +6.16600000E-05  +7.15200000E-05
   +9.61000000E-06  -9.84000000E-06  -4.87000000E-06  +2.85500000E-05  +1.58800000E-05
   -1.05330000E-04  +2.02300000E-05  -1.77100000E-05  +7.88000000E-06  -6.30000000E-07
   -8.84900000E-05  -8.33900000E-05  +1.37600000E-05  -2.32420000E-04  -5.46800000E-05
   -3.79410000E-04  -2.45420000E-04  +1.45390000E-04  -1.96090000E-04  -9.26100000E-04
   -1.58401000E-03  +1.09440000E-04  +1.23676900E-02  -1.18629500E-02  -1.55424100E-02
   +2.59343000E-03  +1.33015000E-03  +1.12770000E-03  +1.13643000E-03  +1.17544000E-03
   -9.12960000E-04  +6.80366800E-02  -9.18665100E-02  -1.59697230E-01  -2.88874000E-03
   -2.63515000E-03  -8.03610000E-04  -3.64000000E-05  +1.02000000E-05  -1.54800000E-05
   +2.72320000E-04  -8.13600000E-05  -1.90580000E-04  +1.16500000E-05  +1.13400000E-05
   -6.99000000E-06  -8.52000000E-06  -3.22000000E-06  +5.14000000E-06  +1.00700000E-05
   +5.68000000E-06  -9.25000000E-06  +1.76800000E-05  +2.41600000E-05  +8.84000000E-06
   -9.56000000E-06  -2.77000000E-06  -8.46000000E-06  -1.83400000E-05  +1.44900000E-05
   -4.99000000E-06  +4.40000000E-07  -1.96500000E-05  +1.26400000E-05  +1.28700000E-05
   -1.79000000E-06  +3.37000000E-06  +1.45100000E-05  -1.11000000E-06  -1.01700000E-05
   -9.00000000E-08  -2.34400000E-05  +5.70000000E-06  -2.41300000E-05  +1.83400000E-05
   -1.14200000E-05  -2.43250000E-04  -1.57900000E-05  +2.22900000E-05  -3.64010000E-04
   -3.30830000E-04  +4.66440000E-04  +4.89500000E-04  +1.69879000E-03  -6.52740000E-04
   -1.25770000E-04  +7.40100000E-05  -1.50900000E-05  -8.09263300E-02  +1.05715270E-01
   -4.28700000E-05  +2.71700000E-05  +3.62000000E-05  -1.83200000E-05  -3.47000000E-05
   -2.17300000E-05  -5.19000000E-06  +4.07000000E-06  +1.22500000E-05  +9.77000000E-06
   +1.43900000E-05  -2.12000000E-05  -1.33700000E-05  -8.50000000E-06  +3.90000000E-07
   -3.71000000E-06  +8.72000000E-06  -2.67000000E-05  -9.38800000E-05  -1.90200000E-04
   -1.58260000E-04  -1.84500000E-05  +1.01600000E-05  +6.82000000E-06  +2.03700000E-05
   +1.79200000E-05  -1.45100000E-05  +1.96640000E-04  -5.88140000E-04  -6.70070000E-04
   +6.18440000E-04  +1.04819000E-03  -2.10485000E-03  -1.02168700E-02  +6.06750000E-04
   +2.22336000E-03  +8.16283000E-03  -4.58400000E-04  +7.68734000E-03  -3.98059000E-03
   +1.57643000E-03  +3.15090000E-04  +8.81730000E-04  -6.99060000E-04  +1.52916000E-03
   +1.23985930E-01  -1.77609330E-01  -3.91463590E-01  +7.01303000E-03  -3.94970000E-04
   +2.91693000E-03  +5.57100000E-05  -6.46000000E-06  +5.40400000E-05  -9.31270000E-04
   +4.69300000E-05  -1.66540000E-04  +2.61000000E-06  -4.56000000E-06  +8.33000000E-06
   +1.04800000E-05  -2.47000000E-06  +1.42000000E-06  +1.06800000E-05  -1.28600000E-05
   -3.90000000E-07  -5.25000000E-06  -5.00000000E-06  +4.17000000E-06  -4.72000000E-06
   -4.73000000E-06  +7.66000000E-06  +1.31500000E-05  -6.62000000E-06  -1.18500000E-05
   +2.90000000E-07  +2.66700000E-05  +1.12600000E-05  -2.92000000E-05  -2.26500000E-05
   -1.87600000E-05  +2.55200000E-05  -9.39000000E-06  -4.20500000E-05  -2.83000000E-06
   -5.30000000E-07  +2.38600000E-05  -1.15000000E-06  -2.30500000E-05  -3.88300000E-05
   -8.63600000E-05  +8.93700000E-05  -1.12760000E-04  +4.36800000E-05  +3.11110000E-04
   -1.22370000E-04  +3.46720000E-04  +1.87810000E-04  +2.33960000E-04  -5.77740000E-04
   +3.08490000E-04  -4.28200000E-05  -1.25468590E-01  +1.74187430E-01  +3.82254180E-01
   -4.75300000E-05  +5.64100000E-05  +8.24200000E-05  +2.42200000E-05  -7.71500000E-05
   -7.05100000E-05  -3.50700000E-05  +4.14000000E-06  +7.14000000E-06  +4.31100000E-05
   +3.82400000E-05  -8.13000000E-06  -4.79700000E-05  -5.09300000E-05  -5.60000000E-07
   +1.02400000E-05  -3.40300000E-05  -3.73200000E-05  +4.79450000E-04  +2.05150000E-04
   -1.63680000E-04  -5.76800000E-05  +7.09400000E-05  +8.10100000E-05  +6.47100000E-05
   +4.51800000E-05  -1.99800000E-05  -1.39840000E-04  +2.18127000E-03  +1.52696000E-03
   +2.29397000E-03  -5.06308000E-03  -5.32000000E-05  -1.53641900E-02  -1.29223800E-02
   +1.76879600E-02  +8.92950000E-04  -1.06017000E-03  -2.52759000E-03  -1.35103000E-03
   +1.00173000E-03  +2.11640000E-04  +9.84730000E-04  +1.10660000E-04  -8.50600000E-04
   -6.59620000E-04  -1.54252000E-03  -2.13820000E-04  -8.00207400E-02  -1.29222620E-01
   +8.74543000E-02  -8.66000000E-06  +3.60100000E-05  -2.15600000E-05  -1.07340000E-03
   -7.86170000E-04  +4.96830000E-04  -1.02400000E-05  -6.59000000E-06  +7.48000000E-06
   +1.10200000E-05  +1.02000000E-06  -3.99000000E-06  +1.26100000E-05  -1.42700000E-05
   -2.85000000E-06  -2.84300000E-05  -2.43000000E-05  -1.09600000E-05  -1.28800000E-05
   -4.83000000E-06  +4.27000000E-06  +4.70900000E-05  -2.87300000E-05  -7.94200000E-05
   -7.75000000E-06  +9.00800000E-05  +2.62900000E-05  -9.80500000E-05  -6.79300000E-05
   -7.91900000E-05  +2.77700000E-05  -1.70400000E-05  -4.09400000E-05  -7.86000000E-06
   -1.98400000E-05  +1.08100000E-05  -2.04000000E-05  -9.15000000E-06  +3.40000000E-06
   -2.49330000E-04  -7.34400000E-05  +1.89570000E-04  +1.55660000E-04  +1.50190000E-04
   -2.44640000E-04  -1.48815000E-03  +6.43920000E-04  +1.84547000E-03  -1.35785000E-03
   -1.17980000E-04  -4.92760000E-04  +1.29504000E-03  +1.86210000E-03  -2.48670000E-04
   +9.50548400E-02  -5.16400000E-05  +1.41300000E-05  +2.82400000E-05  -5.56500000E-05
   +2.09160000E-04  -3.87500000E-05  -2.98700000E-05  -3.36600000E-05  -5.12000000E-05
   -7.35000000E-06  -5.88000000E-05  -8.04000000E-06  +8.53200000E-05  +8.72400000E-05
   +1.69400000E-05  -4.56000000E-06  -1.33100000E-05  +2.39800000E-05  -5.21600000E-05
   -3.75780000E-04  -7.50000000E-06  +9.53000000E-06  +1.01090000E-04  +7.90200000E-05
   -1.21500000E-04  -1.04990000E-04  +1.00400000E-05  +2.00750000E-04  -6.08390000E-04
   +7.45370000E-04  +9.66420000E-04  +1.06934000E-03  -1.77072000E-03  +8.49199000E-03
   +1.53063700E-02  -1.05603700E-02  +1.01775000E-03  +6.18550000E-04  -1.08410000E-03
   -5.95620000E-04  -8.36010000E-04  -2.49110000E-04  +3.02900000E-05  +5.07530000E-04
   -9.39950000E-04  +8.74830000E-04  -6.93300000E-04  -2.17470000E-04  -1.55296030E-01
   -3.79584390E-01  +1.86140620E-01  +2.63400000E-05  -2.27800000E-05  -4.88000000E-05
   -2.42150000E-04  -3.63090000E-04  +3.02090000E-04  +1.89100000E-05  +1.07500000E-05
   -7.39000000E-06  -1.27300000E-05  -8.45000000E-06  +8.37000000E-06  +9.70000000E-06
   +6.79000000E-06  -1.08800000E-05  -1.19000000E-06  +2.28600000E-05  +4.36000000E-06
   -1.35500000E-05  -1.00900000E-05  -3.99000000E-06  -3.64900000E-05  +5.23000000E-06
   -3.18000000E-05  +5.57000000E-06  -5.29200000E-05  +5.90000000E-06  +3.88000000E-06
   -1.58400000E-05  -1.72900000E-05  +6.63000000E-06  -7.13000000E-06  +1.08300000E-05
   +6.46000000E-06  -2.81000000E-05  -5.59000000E-06  -2.57300000E-05  +1.35400000E-05
   -1.56000000E-06  -1.54000000E-06  -5.13700000E-05  +2.37730000E-04  +1.48530000E-04
   -6.92100000E-05  -1.83790000E-04  -2.93080000E-04  -2.27820000E-04  +3.24100000E-05
   -8.07500000E-05  +6.22400000E-05  +2.37860000E-04  -1.03410000E-04  -3.46020000E-04
   +1.42747000E-03  +1.44564760E-01  +3.64544100E-01  -3.73200000E-05  +1.12200000E-05
   -4.17000000E-06  +2.28400000E-05  -6.44600000E-05  -1.69100000E-05  +1.23600000E-05
   +7.13000000E-06  +1.90800000E-05  -2.13000000E-06  +8.08000000E-06  -1.06400000E-05
   -2.52000000E-06  -4.63000000E-06  -4.03000000E-06  -8.52000000E-06  +3.14000000E-05
   -2.68600000E-05  -1.23000000E-05  +5.72500000E-05  +1.07860000E-04  +2.66000000E-05
   +1.09000000E-05  -2.63200000E-05  +1.02900000E-05  +1.48100000E-05  -7.24000000E-06
   -4.66160000E-04  -4.82750000E-04  -1.08366000E-03  -1.22225000E-03  +5.45520000E-04
   +2.66252000E-03  +1.35161000E-02  +1.67933900E-02  -2.05505500E-02  +5.03081000E-03
   +3.08875000E-03  +2.21510000E-04  -2.93200000E-04  -1.29318000E-03  -2.41610000E-04
   +2.87700000E-05  -1.30340000E-04  +5.94120000E-04  -2.41952000E-03  +3.25510000E-04
   +4.42500000E-04  +8.90044900E-02  +1.53233980E-01  -1.09466590E-01  -1.52800000E-05
   +3.83600000E-05  -1.08200000E-05  +3.70430000E-04  +4.62080000E-04  -3.96830000E-04
   +3.51000000E-06  -3.97000000E-06  +5.85000000E-06  +5.57000000E-06  -1.90000000E-07
   +8.90000000E-07  +1.43000000E-06  -2.93000000E-06  +6.40000000E-07  +2.02400000E-05
   -1.65900000E-05  +3.16600000E-05  +5.83000000E-06  -4.48000000E-06  +1.11100000E-05
   +3.95000000E-06  -7.02000000E-06  +7.09000000E-06  +1.13900000E-05  +1.63500000E-05
   +2.60600000E-05  -2.80600000E-05  -2.86500000E-05  +3.94000000E-06  +4.20000000E-06
   -7.64000000E-06  -1.89600000E-05  -4.20000000E-07  -1.94000000E-06  +1.24300000E-05
   -6.08000000E-06  +7.19000000E-06  -3.02000000E-06  +6.84300000E-05  +1.13130000E-04
   -2.00540000E-04  -2.86040000E-04  -4.66260000E-04  +3.11030000E-04  +1.30815000E-03
   -3.47170000E-04  -1.42002000E-03  +5.76200000E-05  +2.65360000E-04  -3.80700000E-05
   -1.30020000E-04  +1.99289000E-03  -2.20589000E-03  -1.04095870E-01  -1.73880790E-01
   +1.30959740E-01  +7.72700000E-05  +3.02350000E-04  +1.25720000E-04  -1.37700000E-04
   +1.16730000E-04  -1.58500000E-04  -8.95100000E-05  -1.24460000E-04  -2.21060000E-04
   +1.29780000E-04  +1.14510000E-04  +7.48900000E-05  +2.07540000E-04  -6.22200000E-05
   -1.74470000E-04  -1.71270000E-04  -1.03330000E-04  +1.32240000E-04  -7.16700000E-05
   -2.93690000E-04  +2.47320000E-04  +3.24000000E-06  +2.42700000E-05  +7.87800000E-05
   -1.66300000E-04  -1.27290000E-04  +6.82400000E-05  -3.61646000E-03  -1.33174000E-03
   +4.56621000E-03  +2.67575000E-03  -2.42355000E-03  +2.48160000E-04  -2.19392000E-03
   +1.14980000E-04  -1.78745000E-03  -1.53902000E-03  +2.80650000E-03  +2.70755000E-03
   +1.85823000E-03  +1.06521000E-03  -2.37116000E-03  +1.22369400E-02  -2.91313000E-03
   +1.83856300E-02  +9.76240000E-04  -7.21370000E-04  -2.30590000E-04  -1.86400000E-05
   -3.90600000E-05  -4.35900000E-04  -6.41000000E-06  +2.05100000E-05  -1.12550000E-04
   -1.37464650E-01  +1.85875400E-02  -2.17780630E-01  -4.93000000E-06  +9.51000000E-06
   -4.50600000E-05  -8.26000000E-05  +6.89000000E-06  -7.89000000E-06  +2.73300000E-05
   +2.87800000E-05  -4.17500000E-05  +6.60000000E-07  -3.60000000E-06  -1.13000000E-06
   -1.11000000E-05  -2.81000000E-06  +2.50000000E-07  +7.10000000E-06  +6.85000000E-06
   -1.12200000E-05  +2.59600000E-05  +5.68000000E-06  -1.23800000E-05  -1.25100000E-05
   +6.91000000E-06  -3.43000000E-06  -2.38700000E-05  -3.08100000E-05  -7.80300000E-05
   +1.59400000E-05  -5.76000000E-06  +7.43000000E-06  -2.51300000E-05  +2.29500000E-05
   +1.62600000E-05  -1.61400000E-04  -5.43360000E-04  +1.06500000E-05  -1.04471000E-03
   -1.29584000E-03  -2.63400000E-04  -3.91500000E-05  +4.25200000E-04  -3.23840000E-04
   +2.48650000E-04  +4.92150000E-04  -3.03300000E-05  +2.60700000E-05  +1.13800000E-04
   +1.91520000E-04  +5.14300000E-05  -6.23400000E-05  +1.19620000E-04  +1.29141700E-01
   +1.33000000E-06  +3.18100000E-05  +3.62400000E-05  -6.49000000E-06  -5.91000000E-05
   -6.03300000E-05  +5.50000000E-05  +1.08100000E-04  +2.32100000E-05  +2.03200000E-05
   -5.91000000E-05  -3.70600000E-05  +4.08700000E-05  +7.27100000E-05  +6.22700000E-05
   +7.68800000E-05  -5.27100000E-05  +9.43000000E-06  -6.50600000E-05  +2.06290000E-04
   -2.28710000E-04  +1.11700000E-05  -5.52900000E-05  -2.16500000E-05  -5.88300000E-05
   -7.54600000E-05  +6.57000000E-06  -2.14012000E-03  -1.15206000E-03  +1.65596000E-03
   +6.05890000E-04  -9.83800000E-04  -1.36000000E-06  -3.75160000E-04  +5.40670000E-04
   -5.23160000E-04  -6.14900000E-05  +2.55820000E-04  +1.22270000E-04  +4.49910000E-04
   -4.26190000E-04  -1.37600000E-05  +6.89876000E-03  -5.35880000E-04  +1.42369000E-02
   +1.48300000E-04  -2.07060000E-04  -2.17800000E-05  -5.33700000E-05  -1.09000000E-04
   +7.77000000E-05  -6.72200000E-05  -2.90800000E-05  +1.62220000E-04  +1.39704100E-02
   -3.44033000E-02  +6.77366200E-02  -4.00000000E-07  +2.16700000E-05  -1.13200000E-05
   -3.70000000E-07  +1.51600000E-05  +7.00000000E-07  +2.65000000E-05  -2.48200000E-05
   +2.55600000E-05  -6.04000000E-06  -7.00000000E-06  -2.08700000E-05  -1.15000000E-05
   -5.60000000E-07  -1.27000000E-05  +2.93200000E-05  -8.63000000E-06  +1.27200000E-05
   +3.31000000E-06  +1.73900000E-05  +8.15000000E-06  -1.13000000E-05  -8.53000000E-06
   -4.60800000E-05  +8.83200000E-05  +7.54700000E-05  +2.76100000E-05  -1.69000000E-06
   -1.80000000E-05  +5.44800000E-05  -6.24000000E-06  -2.60200000E-05  -7.41000000E-05
   -3.04700000E-05  -1.87949000E-03  +2.90330000E-04  -3.71530000E-04  +2.56930000E-04
   -2.03420000E-04  -8.12100000E-05  +3.19600000E-05  -9.54200000E-05  +8.94800000E-05
   +1.92260000E-04  -2.46600000E-05  +4.02200000E-05  +3.04000000E-06  +1.12400000E-05
   -3.88100000E-05  -8.40000000E-07  +8.93000000E-06  -1.63274500E-02  +3.45001400E-02
   +5.91400000E-05  -9.81500000E-05  +7.59000000E-06  +4.51600000E-05  -1.64810000E-04
   +3.03180000E-04  +1.30820000E-04  -1.65500000E-05  +2.77000000E-05  -9.61900000E-05
   -5.46200000E-05  +2.46200000E-05  -2.23260000E-04  -4.15800000E-05  +1.35410000E-04
   +1.61530000E-04  -2.95000000E-05  -3.95900000E-05  +3.68830000E-04  -5.64300000E-05
   +6.38000000E-05  -4.52000000E-06  -2.00700000E-05  -3.89800000E-05  +1.92090000E-04
   +1.47440000E-04  -4.49400000E-05  +4.06443000E-03  +1.48448000E-03  -5.13815000E-03
   -2.47777000E-03  +3.51894000E-03  +9.32240000E-04  +1.59627000E-03  -2.44872000E-03
   +1.76238000E-03  +8.99240000E-04  -1.87286000E-03  -3.06065000E-03  -1.43514000E-03
   -1.83080000E-04  +4.42834000E-03  -6.60823000E-03  +3.10237000E-03  -1.51440800E-02
   -1.38890000E-03  +1.28655000E-03  +1.48870000E-04  +1.59160000E-04  +1.19920000E-04
   +1.69300000E-05  +5.13600000E-05  -1.07750000E-04  +2.00700000E-05  -1.92020350E-01
   +7.10118600E-02  -4.07286740E-01  -2.83000000E-05  -1.42300000E-05  +2.60700000E-05
   +3.55100000E-05  -5.63000000E-06  -1.76000000E-06  -5.32700000E-05  +1.32500000E-05
   +1.32400000E-05  +5.90000000E-06  +1.08000000E-05  +1.10000000E-07  -7.50000000E-06
   +1.38200000E-05  -1.37200000E-05  -3.79200000E-05  -1.21300000E-05  +1.45100000E-05
   -2.62100000E-05  -2.95500000E-05  +2.23000000E-05  +7.90000000E-06  +3.34000000E-06
   +2.50100000E-05  -5.90600000E-05  +1.22770000E-04  +6.19100000E-05  +8.27000000E-06
   +1.20400000E-05  +5.32000000E-06  +3.94000000E-05  -8.55000000E-06  +6.55300000E-05
   -4.42180000E-04  -1.37030000E-04  +1.22950000E-04  +1.58770000E-04  -3.17550000E-04
   -1.81200000E-04  +9.03470000E-04  +8.12410000E-04  -3.20500000E-04  -1.51920000E-04
   -2.34780000E-04  +7.67600000E-05  -5.94300000E-05  -6.23000000E-05  -2.42960000E-04
   +8.53000000E-05  +5.53200000E-05  -6.05000000E-05  +1.99036440E-01  -7.55585400E-02
   +4.26331020E-01  -3.42488000E-03  -3.00300000E-04  -1.19556000E-03  -1.00078000E-03
   -1.37148000E-03  -1.30790000E-04  +1.46780000E-04  -1.77030000E-04  -1.59450000E-04
   -2.85300000E-05  +1.60730000E-04  -1.03524000E-03  +2.08375000E-03  +1.13231000E-03
   -2.20007000E-03  -2.14437000E-03  +4.78859000E-03  -2.83399000E-03  -1.45669000E-03
   -1.41900000E-04  -1.76780000E-04  +6.86790000E-04  +1.13790000E-04  +7.13900000E-05
   -7.83220000E-04  -5.36420000E-04  +2.64360000E-04  +1.53260000E-04  -1.09781000E-03
   -1.65394000E-03  -3.19473000E-03  +3.40195000E-03  +4.42610000E-04  -1.81670000E-03
   -9.57417000E-03  +1.22169000E-03  +1.26093000E-03  +1.33017000E-03  +2.28842000E-03
   +3.29090000E-04  -7.24560000E-04  -1.17860000E-04  +1.60992000E-03  +2.89250000E-04
   -7.33650000E-04  -6.55070000E-04  -9.69900000E-05  -1.13550000E-04  +4.23560000E-04
   +8.86560000E-04  +2.23600000E-05  +5.95430000E-04  +7.76000000E-05  -2.12300000E-05
   +1.65945000E-03  -2.22789900E-02  -1.12629300E-02  +3.89890000E-04  -1.09100000E-05
   +2.49400000E-05  +1.07960000E-04  -4.83700000E-05  +1.26500000E-04  -1.69490000E-04
   +1.94100000E-05  +1.49300000E-04  -4.63700000E-05  -5.59000000E-05  -3.09900000E-04
   +1.76390000E-04  -1.53110000E-04  +3.06010000E-04  +1.31280000E-04  -2.28030000E-04
   +1.91950000E-04  +1.38940000E-04  +2.72540000E-04  -1.92160000E-04  -2.15840000E-04
   -1.50700000E-05  +7.13900000E-05  -2.69260000E-04  +9.07500000E-05  -3.75400000E-05
   +1.14560000E-04  +3.07850000E-04  +7.04000000E-06  +1.74520000E-04  -2.80040000E-04
   +8.59500000E-05  -3.54240000E-04  -3.68370000E-04  +8.88800000E-05  +1.81700000E-05
   -1.08150000E-04  -6.26000000E-06  +7.91329000E-03  +1.63522100E-02  -4.18276000E-03
   -2.12080000E-04  +9.30000000E-05  +2.85780000E-04  +3.30150000E-04  +1.75240000E-04
   -1.05250000E-04  +1.76320000E-04  +1.08260000E-04  -3.48110000E-04  +1.13480000E-04
   -8.70030000E-04  +7.95960000E-04  +4.82680240E-01  +1.25428000E-03  -2.22738000E-03
   +1.12089000E-03  +7.07490000E-04  -5.99100000E-05  +1.52499000E-03  -2.99530000E-04
   +1.66560000E-04  +6.26680000E-04  +8.52000000E-05  +1.70210000E-04  +2.37540000E-04
   -7.15930000E-04  -8.87650000E-04  -6.16640000E-04  -9.82200000E-04  +4.93590000E-04
   -2.55500000E-05  -8.94800000E-05  +4.16420000E-04  -1.72700000E-04  +9.66000000E-05
   +5.66000000E-05  +3.80000000E-06  +8.15110000E-04  +9.59070000E-04  -1.82860000E-04
   -1.92578000E-03  +1.47430000E-03  +5.33224000E-03  +4.76637000E-03  -5.83156000E-03
   -5.12730000E-04  +4.13947000E-03  +1.37008900E-02  -1.34843000E-03  +9.23150000E-04
   -5.80513000E-03  -6.45485000E-03  -5.46503000E-03  +2.92165000E-03  +3.53685000E-03
   +1.45324500E-02  +4.60104000E-03  -1.67113900E-02  -1.73605000E-03  +1.61172000E-03
   +4.03000000E-04  -1.26682000E-03  -1.34545000E-03  +1.39372000E-03  +6.34200000E-05
   -1.66800000E-05  -2.99440000E-04  -3.69782500E-02  -5.55493400E-02  -2.34979900E-02
   -3.90000000E-07  -1.68610000E-04  +7.30900000E-05  +5.41700000E-05  +1.35200000E-05
   -1.86200000E-05  -1.90220000E-04  +1.63780000E-04  -3.52100000E-05  -1.49360000E-04
   -1.33680000E-04  -1.88800000E-05  +4.00330000E-04  -4.08300000E-05  +5.42660000E-04
   +5.98600000E-05  -3.11600000E-05  +2.08100000E-05  -1.44300000E-05  +3.11800000E-05
   -3.33000000E-05  -3.69900000E-05  +4.58400000E-05  +5.05400000E-05  -2.28930000E-04
   +2.87950000E-04  +9.80400000E-05  +1.15400000E-05  +3.16800000E-05  -9.80000000E-06
   +9.50600000E-05  -5.96800000E-05  +2.07440000E-04  -2.56357000E-03  -1.95859000E-03
   +2.61630000E-03  +2.08250000E-04  +4.73810000E-04  -1.92850000E-04  -7.41134000E-03
   -1.88696100E-02  +3.78413000E-03  +8.95200000E-05  +8.43800000E-05  +2.17580000E-04
   -5.17400000E-05  -3.01110000E-04  -1.25050000E-04  -4.36320000E-04  -3.22570000E-04
   +3.37810000E-04  -1.06407000E-03  -7.64059000E-03  +8.03920000E-04  -5.01328900E-02
   +3.31042400E-01  -4.22130000E-03  +1.20150000E-03  -2.36224000E-03  -7.57830000E-04
   -4.10630000E-04  -1.14598000E-03  +6.71130000E-04  +2.31350000E-04  +8.87400000E-05
   -1.94430000E-04  -2.95950000E-04  +9.73190000E-04  +1.72932000E-03  +3.57100000E-05
   -1.74982000E-03  -1.16318000E-03  +3.95253000E-03  -2.39920000E-03  -8.83800000E-05
   -1.28210000E-04  +6.52600000E-05  +1.35290000E-04  +4.58200000E-05  +6.67400000E-05
   -8.20090000E-04  -6.43470000E-04  +4.90050000E-04  +6.19800000E-05  +1.85237000E-03
   +2.28726000E-03  +2.66579000E-03  -2.73977000E-03  +7.82500000E-05  +3.11639000E-03
   +9.62557000E-03  -1.59490000E-04  +3.14310000E-04  -4.46409000E-03  -5.71445000E-03
   -4.25259000E-03  +2.12611000E-03  +3.01959000E-03  +1.04265600E-02  +2.52139000E-03
   -1.27048100E-02  -7.58830000E-04  +1.03069000E-03  +5.23620000E-04  -5.78030000E-04
   -1.07109000E-03  +9.09880000E-04  +1.01080000E-04  +1.04800000E-05  -3.02370000E-04
   -2.14470400E-02  -3.93993900E-02  +1.25724000E-03  -6.34000000E-05  +8.69400000E-05
   -1.72640000E-04  -2.09720000E-04  +1.39430000E-04  -1.14600000E-05  -1.73610000E-04
   +1.81120000E-04  +4.92000000E-05  +1.00150000E-04  -3.12490000E-04  +5.11710000E-04
   +2.47040000E-04  -1.05900000E-04  +2.75950000E-04  -7.48000000E-06  -4.58600000E-05
   +3.93600000E-05  +7.59000000E-05  +5.54200000E-05  -2.69900000E-05  -5.81100000E-05
   +9.25000000E-06  +1.12820000E-04  -1.71760000E-04  +1.90730000E-04  +9.68900000E-05
   +6.04700000E-05  +6.68400000E-05  +6.33000000E-06  +2.59500000E-05  -4.23500000E-05
   +1.40870000E-04  -2.00978000E-03  -1.53975000E-03  +1.85292000E-03  +2.07410000E-04
   +3.81700000E-04  -7.31500000E-05  -6.29503000E-03  -1.32655800E-02  +3.49824000E-03
   -1.46300000E-05  +9.59000000E-06  +2.22380000E-04  -1.71490000E-04  -1.86320000E-04
   -1.65420000E-04  -3.74380000E-04  -1.52130000E-04  +2.32450000E-04  +1.98370000E-04
   -5.05340000E-04  +9.64540000E-04  +2.05496400E-01  +6.01005200E-02  +3.48603280E-01
   +3.74950000E-04  -4.75620000E-04  -1.39300000E-04  +8.72950000E-04  +7.33200000E-04
   +7.75500000E-05  -2.26900000E-05  +2.85070000E-04  +4.68820000E-04  -1.32290000E-04
   -4.13170000E-04  +3.75710000E-04  -5.77160000E-04  -3.31100000E-04  +4.89000000E-05
   +3.21400000E-05  -5.32940000E-04  +2.53680000E-04  +8.44910000E-04  +1.97160000E-04
   +6.38200000E-05  -4.24400000E-04  -9.15300000E-05  -9.04300000E-05  +2.32140000E-04
   +4.50800000E-05  +3.65600000E-05  +1.01446000E-03  -7.17090000E-04  -1.39230000E-03
   -1.43913000E-03  +1.47837000E-03  -1.47550000E-04  -1.97367000E-03  -4.28224000E-03
   +2.57940000E-04  -1.22062000E-03  +2.94050000E-03  +3.46273000E-03  +2.37678000E-03
   -8.46680000E-04  -2.26451000E-03  -9.31782000E-03  -6.30504000E-03  +6.57487000E-03
   +1.30025000E-03  -9.69460000E-04  -2.91820000E-04  +5.37710000E-04  +4.84200000E-04
   -8.93670000E-04  -3.24150000E-04  +9.23000000E-06  +2.05590000E-04  -4.52020000E-03
   +2.16512900E-02  +5.44791000E-03  -1.62700000E-04  +5.07000000E-06  -3.46700000E-05
   -5.71100000E-05  +5.26700000E-05  -4.52200000E-05  +1.59190000E-04  +6.58000000E-06
   -1.06950000E-04  +4.33700000E-05  +1.69860000E-04  +3.15200000E-05  -7.32300000E-05
   +1.12600000E-05  -8.26400000E-05  -8.37200000E-05  +1.27800000E-04  -1.15100000E-04
   -9.10400000E-05  -1.47300000E-04  +1.25420000E-04  +1.17320000E-04  -7.35000000E-06
   -6.40600000E-05  +3.00410000E-04  -2.45850000E-04  -5.83000000E-06  -8.42700000E-05
   -1.69960000E-04  -8.05000000E-06  -1.18430000E-04  +1.65420000E-04  -1.62400000E-04
   +1.29129000E-03  +9.32780000E-04  -1.03427000E-03  -1.24700000E-04  -2.28930000E-04
   +9.19800000E-05  +2.37611000E-03  +5.69583000E-03  -8.64340000E-04  +5.05700000E-05
   -1.01370000E-04  -2.87550000E-04  -3.04800000E-05  +1.53440000E-04  +1.60810000E-04
   +2.04500000E-04  +1.08280000E-04  -5.93500000E-05  -1.18020000E-03  -1.62338000E-03
   -3.03648000E-03  -7.59594200E-02  -2.10769900E-02  -1.80390400E-02  +8.20350000E-02
   +2.01627000E-03  +7.88720000E-04  +7.67880000E-04  +1.10156000E-03  +3.97330000E-04
   -4.80000000E-06  -5.48150000E-04  +8.39900000E-05  +8.37000000E-06  +3.21860000E-04
   +2.26250000E-04  +3.23000000E-05  -4.18240000E-04  -3.85900000E-05  +7.34680000E-04
   +4.07510000E-04  -2.86104000E-03  +1.56374000E-03  +8.63910000E-04  -2.45740000E-04
   +3.05670000E-04  -5.46120000E-04  -1.27940000E-04  -9.92500000E-05  -3.14290000E-04
   -6.00220000E-04  +5.96900000E-05  +9.83320000E-04  -2.44744000E-03  -3.72399000E-03
   -4.17724000E-03  +4.67671000E-03  -1.42120000E-04  -3.99964000E-03  -1.21416100E-02
   +6.59780000E-04  -1.71555000E-03  +7.02454000E-03  +7.38911000E-03  +6.90622000E-03
   -3.14743000E-03  -4.78769000E-03  -2.09934800E-02  -9.61906000E-03  +2.35954000E-02
   +2.63952000E-03  -2.27817000E-03  -5.33570000E-04  +1.19811000E-03  +1.25979000E-03
   -1.70672000E-03  -4.31200000E-04  -1.10900000E-05  +5.21090000E-04  +2.52437900E-02
   +1.50637700E-02  +2.88614000E-03  -1.82390000E-04  +1.14400000E-04  -7.93100000E-05
   -5.20700000E-05  +5.96000000E-06  -1.51300000E-05  +4.20250000E-04  -3.20360000E-04
   -8.65500000E-05  +8.70700000E-05  +3.18790000E-04  -1.86240000E-04  -3.83640000E-04
   +5.88100000E-05  -4.94070000E-04  -1.12480000E-04  +1.81540000E-04  -1.63230000E-04
   -1.10780000E-04  -1.78940000E-04  +1.39080000E-04  +1.69340000E-04  -4.09200000E-05
   -1.57490000E-04  +4.54860000E-04  -4.84440000E-04  -1.85450000E-04  -1.04620000E-04
   -1.95840000E-04  -1.48500000E-05  -1.99440000E-04  +2.39940000E-04  -3.54070000E-04
   +3.43839000E-03  +2.92926000E-03  -3.02416000E-03  -3.05590000E-04  -5.74170000E-04
   +2.38860000E-04  +8.67138000E-03  +1.35103400E-02  -4.88975000E-03  -4.52000000E-06
   -2.57120000E-04  -4.89610000E-04  -4.10000000E-05  +2.76750000E-04  +2.50430000E-04
   +4.80100000E-04  +3.26390000E-04  -2.44600000E-04  +3.41837000E-03  +1.09792000E-02
   -3.10450000E-04  -4.55190400E-02  -1.71333180E-01  -5.06997500E-02  +1.81801200E-02
   +1.52126450E-01  +7.04100000E-04  -1.41830000E-04  +7.41000000E-06  +5.56400000E-04
   +5.52030000E-04  -3.09100000E-05  -7.40220000E-04  -5.50000000E-06  +5.46720000E-04
   +2.15590000E-04  +3.48840000E-04  -2.36700000E-05  -4.77530000E-04  -2.51790000E-04
   +9.29900000E-05  -1.70690000E-04  -1.04413000E-03  +4.88690000E-04  +3.31820000E-04
   +4.91200000E-04  -1.26500000E-04  -2.75570000E-04  -1.04520000E-04  -8.19000000E-05
   +2.85510000E-04  +7.17300000E-05  -4.65400000E-05  -4.24310000E-04  -9.52380000E-04
   -1.49183000E-03  -8.85900000E-04  +1.17398000E-03  -5.04310000E-04  -2.49133000E-03
   -5.83490000E-03  -7.67260000E-04  -7.20300000E-04  +4.32345000E-03  +5.29744000E-03
   +4.51849000E-03  -2.36460000E-03  -3.17934000E-03  -1.24954200E-02  +4.33270000E-04
   +1.78986900E-02  +1.13801000E-03  -1.17274000E-03  -5.08750000E-04  +3.50460000E-04
   +7.16190000E-04  -8.38970000E-04  -1.94100000E-04  +4.62000000E-06  +3.07840000E-04
   +1.62511000E-02  +2.54127500E-02  -2.80585900E-02  -1.08680000E-04  +3.13000000E-06
   +3.42900000E-05  +1.02130000E-04  -1.84700000E-05  -1.04000000E-06  +2.05410000E-04
   -1.89940000E-04  -7.00800000E-05  +1.61200000E-05  +1.51460000E-04  -1.62240000E-04
   -9.71900000E-05  +2.69500000E-05  -1.47790000E-04  -2.38300000E-05  +7.51000000E-05
   -7.10300000E-05  -7.65400000E-05  -9.29400000E-05  +8.60600000E-05  +7.70700000E-05
   -1.11000000E-05  -1.07250000E-04  +2.70970000E-04  -2.38540000E-04  -1.02750000E-04
   -9.30700000E-05  -1.45390000E-04  +7.92000000E-06  -9.01600000E-05  +8.19600000E-05
   -1.98720000E-04  +3.04487000E-03  +2.59990000E-03  -2.47746000E-03  -1.85290000E-04
   -3.50930000E-04  +6.75300000E-05  +4.52613000E-03  +5.90529000E-03  -2.67489000E-03
   +2.36000000E-05  -1.14860000E-04  -2.54690000E-04  +4.15900000E-05  +1.01520000E-04
   +2.04130000E-04  +2.84440000E-04  +1.08900000E-04  -9.95300000E-05  -2.25241000E-03
   -7.28737000E-03  -3.88186000E-03  -2.23789700E-02  -2.74958300E-02  -4.64528300E-02
   +1.93930600E-02  +3.78708900E-02  +8.36615400E-02  +1.68903000E-03  +4.06091000E-03
   -5.02680000E-04  +1.54590000E-04  +2.10040000E-04  -1.74855000E-03  -4.14990000E-04
   -1.08490000E-04  -2.56640000E-04  +8.21900000E-05  +8.70830000E-04  +1.27586000E-03
   -2.87412000E-03  -9.44190000E-04  +1.69504000E-03  +1.02747000E-03  -3.23934000E-03
   +6.41540000E-04  +6.80910000E-04  -2.01770000E-04  +1.38330000E-04  -3.57560000E-04
   -8.22800000E-05  -1.25400000E-05  +7.99950000E-04  +7.63730000E-04  -4.16000000E-04
   +3.65380000E-04  +1.37110000E-04  -8.09000000E-06  +3.32210000E-04  -2.39480000E-04
   +5.10200000E-05  -8.42100000E-05  +1.28809000E-03  -1.77730000E-04  -4.18820000E-04
   +1.35180000E-04  -2.45900000E-05  +3.40380000E-04  +1.45530000E-04  -3.14160000E-04
   -1.37399000E-03  -8.56120000E-04  +1.01252000E-03  +3.11010000E-04  -7.87500000E-05
   -1.79700000E-05  +7.40500000E-05  -8.58100000E-05  -2.08010000E-04  -3.10290000E-04
   -6.22600000E-05  +2.29900000E-05  +1.96615000E-03  +3.44517000E-03  +9.14410000E-04
   -1.79830000E-04  -7.27100000E-05  +1.46550000E-04  +6.08800000E-05  -9.00100000E-05
   -9.16400000E-05  +9.87600000E-05  -1.42270000E-04  +1.62300000E-05  +7.14700000E-05
   -3.65180000E-04  +8.87810000E-04  -4.52900000E-05  +1.05370000E-04  -3.14200000E-05
   -5.67300000E-05  +1.15600000E-04  -8.82600000E-05  -5.98600000E-05  -1.45480000E-04
   +9.57000000E-05  +1.11400000E-04  -9.51000000E-06  -3.92800000E-05  +1.26500000E-04
   -3.43900000E-05  +1.67900000E-05  -7.32000000E-05  -1.41150000E-04  -2.82000000E-06
   -8.63100000E-05  +1.57440000E-04  -5.01600000E-05  +2.08180000E-04  +2.25350000E-04
   -2.67200000E-05  -4.42400000E-05  -4.84700000E-05  +2.83200000E-05  -1.54971000E-03
   -1.88993000E-03  +8.07850000E-04  +4.44200000E-05  -9.54700000E-05  -9.05100000E-05
   -8.68700000E-05  -2.14200000E-05  +5.34200000E-05  +9.05000000E-06  -1.27900000E-05
   +6.64500000E-05  +5.91100000E-05  +1.37500000E-05  -2.07100000E-04  -2.85841660E-01
   +6.76932100E-02  -2.10606350E-01  -9.57537000E-03  -4.14295000E-03  -9.58643000E-03
   +3.09414140E-01  -2.80960000E-04  +7.09390000E-04  +1.14223000E-03  -3.57550000E-04
   -2.17240000E-03  -6.87900000E-04  +4.66800000E-04  -7.78020000E-04  -5.82880000E-04
   +1.21670000E-04  -1.85480000E-04  +3.84300000E-05  +1.62765000E-03  +1.00308000E-03
   +3.64900000E-04  +1.72606000E-03  -2.30620000E-04  +4.59590000E-04  -4.84530000E-04
   -2.30080000E-04  -5.57000000E-06  +2.37200000E-04  +1.04200000E-04  +5.62200000E-05
   -1.14609000E-03  -1.09192000E-03  +2.89820000E-04  +1.48380000E-04  +7.23100000E-05
   -4.19130000E-04  -5.05190000E-04  +6.64530000E-04  +2.03860000E-04  +8.35500000E-05
   -8.15070000E-04  +4.85870000E-04  +2.43300000E-05  -1.41260000E-04  -3.54300000E-04
   -2.52480000E-04  +3.05600000E-05  +2.67490000E-04  +7.73150000E-04  +7.90000000E-05
   -9.80870000E-04  +7.58500000E-05  -2.39800000E-05  +7.83400000E-05  +1.32790000E-04
   +5.43000000E-06  -2.47800000E-05  +1.87540000E-04  +4.41700000E-05  -6.71300000E-05
   -8.77140000E-04  -6.98856000E-03  -4.54110000E-04  +1.57800000E-05  +1.45630000E-04
   -9.51700000E-05  -1.88920000E-04  +6.76900000E-05  -2.51400000E-05  -9.75000000E-05
   +7.75500000E-05  +8.06800000E-05  +5.29100000E-05  +7.35700000E-05  -1.82940000E-04
   -6.02150000E-04  +7.64200000E-05  -8.78080000E-04  +9.68000000E-06  -5.31300000E-05
   +4.71600000E-05  +7.50000000E-05  +8.79200000E-05  -7.37300000E-05  -5.39900000E-05
   -1.78900000E-05  +3.99900000E-05  -6.41400000E-05  +1.19400000E-05  -2.46000000E-06
   +5.06700000E-05  +1.04820000E-04  +1.38900000E-05  +1.17500000E-05  -5.38600000E-05
   +1.61400000E-05  -2.07400000E-04  -1.57250000E-04  +1.38520000E-04  +2.92900000E-05
   -7.00000000E-07  +1.72200000E-05  +6.59310000E-04  +1.11912000E-03  -5.56660000E-04
   -6.65800000E-05  +1.74300000E-05  +6.14900000E-05  -1.43500000E-05  +3.46000000E-05
   -3.01200000E-05  -1.55500000E-05  +4.01900000E-05  -2.77300000E-05  +2.78450000E-04
   +4.64010000E-04  +1.76610000E-04  +8.76509700E-02  -6.05920400E-02  +4.94428600E-02
   -2.34015600E-02  +1.66994900E-02  -1.65767100E-02  -7.16881500E-02  +5.38691000E-02
   +2.83088000E-03  +2.29774000E-03  -4.60620000E-04  +1.18860000E-04  +1.61513000E-03
   +3.44240000E-04  -3.74150000E-04  -7.67090000E-04  -6.48520000E-04  +1.07900000E-04
   -8.96300000E-05  -1.24366000E-03  -3.42557000E-03  -3.65500000E-05  +2.76842000E-03
   -2.29000000E-05  -4.13087000E-03  +1.03555000E-03  +4.78940000E-04  -5.04000000E-05
   -3.03000000E-06  -2.42870000E-04  -2.66100000E-05  -1.31000000E-05  +1.71771000E-03
   +1.36692000E-03  -7.85210000E-04  -6.60900000E-05  +5.56200000E-05  +2.35110000E-04
   +4.79600000E-04  -6.16490000E-04  -1.09510000E-04  -7.79000000E-06  +1.12272000E-03
   -4.12360000E-04  -2.50240000E-04  +2.15250000E-04  +2.66080000E-04  +4.39480000E-04
   +6.71400000E-05  -4.70180000E-04  -1.26336000E-03  -1.09787000E-03  +1.43440000E-03
   +1.01130000E-04  -4.56200000E-05  -9.34600000E-05  -9.94400000E-05  -3.68700000E-05
   -1.41890000E-04  -2.57130000E-04  -6.94700000E-05  +8.48300000E-05  +1.77672000E-03
   +2.48253000E-03  +7.50880000E-04  +7.87300000E-05  -1.51120000E-04  +2.56620000E-04
   +2.20220000E-04  -2.03410000E-04  -2.57700000E-05  +1.55410000E-04  -1.07310000E-04
   -6.44200000E-05  +3.87600000E-05  +1.58910000E-04  -2.21740000E-04  -2.73620000E-04
   +1.28810000E-04  -3.84900000E-04  -2.64200000E-05  +7.65700000E-05  -6.62500000E-05
   -6.81900000E-05  -1.19560000E-04  +4.99700000E-05  +1.02050000E-04  +6.40000000E-07
   -9.06000000E-05  +8.51700000E-05  -4.28100000E-05  -2.60800000E-05  -5.48300000E-05
   -1.22860000E-04  -2.55400000E-05  -4.15100000E-05  +9.66900000E-05  -3.63100000E-05
   +1.51560000E-04  +1.56510000E-04  -6.43000000E-05  -5.39800000E-05  -3.54000000E-05
   +5.50000000E-07  -1.14822000E-03  -2.14910000E-03  +8.46100000E-04  +9.54400000E-05
   +5.56000000E-06  -1.65700000E-04  -2.87500000E-05  -3.87800000E-05  +7.01500000E-05
   +3.65800000E-05  -1.93700000E-05  +5.72900000E-05  +4.42600000E-05  +2.17680000E-04
   -8.60900000E-05  -2.26003510E-01  +3.68472600E-02  -2.13086160E-01  -1.14101500E-02
   +6.53810000E-04  -1.06322600E-02  +2.28265210E-01  -4.00734900E-02  +2.08911800E-01
   -7.92790000E-04  +1.75830000E-04  -1.81900000E-04  -6.42810000E-04  -1.59107000E-03
   +2.93850000E-04  +4.21670000E-04  +1.03150000E-04  -4.28200000E-05  -4.00200000E-05
   +3.24770000E-04  -3.58350000E-04  +5.00440000E-04  +1.04160000E-04  -5.10390000E-04
   -3.58850000E-04  +1.43621000E-03  -8.59630000E-04  -1.84576000E-03  +2.15660000E-04
   -4.17560000E-04  +7.55970000E-04  -1.50770000E-04  -1.21680000E-04  +1.42310000E-04
   +3.50570000E-04  -5.99100000E-05  +3.68542000E-03  -6.66935000E-03  -1.10187900E-02
   -1.37953400E-02  +1.61700500E-02  +1.28263000E-03  -1.18567700E-02  -5.93247800E-02
   +7.82727000E-03  +5.04939000E-03  +7.94834000E-03  +1.56460900E-02  +6.10369000E-03
   -3.73557000E-03  -4.26793000E-03  -8.44995000E-03  -5.33490000E-03  +1.19134000E-02
   -2.22818000E-03  +5.73190000E-04  -1.10778000E-03  +1.44293000E-03  +5.98183000E-03
   -6.10130000E-04  +6.45370000E-04  +6.79000000E-05  +3.60840000E-04  +1.15389000E-02
   +1.39891400E-02  -3.27861000E-03  +1.78050000E-04  -5.29100000E-05  +8.14500000E-05
   +1.19090000E-04  -6.33000000E-06  +3.78500000E-05  -1.04560000E-04  -7.31000000E-05
   +1.60250000E-04  -6.62900000E-05  -4.02330000E-04  +1.70330000E-04  +2.93540000E-04
   -2.45300000E-05  +3.14280000E-04  +1.93710000E-04  -2.21320000E-04  +3.01160000E-04
   +4.65400000E-05  +2.26540000E-04  -1.98730000E-04  -1.68500000E-04  +7.61000000E-06
   +8.03900000E-05  -1.55670000E-04  -4.12500000E-05  -5.43900000E-05  +2.40600000E-05
   +3.51010000E-04  +2.19500000E-05  +2.54250000E-04  -2.96490000E-04  -5.24100000E-05
   +1.41976000E-03  +7.80270000E-04  -1.98822000E-03  -4.03200000E-04  -8.33310000E-04
   +1.80330000E-04  -7.69493100E-02  -1.01695700E-02  -6.46536000E-03  -3.74650000E-04
   -3.21510000E-04  +6.78370000E-04  +4.51250000E-04  -1.72030000E-04  -1.28030000E-04
   +7.57730000E-04  +7.26700000E-04  -9.63180000E-04  -3.18820000E-04  +3.18460000E-04
   -8.65230000E-04  -6.63407100E-02  +4.98237300E-02  +5.13213100E-02  -1.19616400E-02
   -1.91884300E-02  -7.69758000E-03  +2.69144000E-03  -1.58690000E-04  +7.23606000E-03
   +3.77687810E-01  +7.98800000E-05  -1.29700000E-05  -2.42400000E-05  -2.45060000E-04
   -9.12610000E-04  +3.79290000E-04  +2.24350000E-04  +2.30630000E-04  +1.72150000E-04
   +3.24600000E-05  +3.90600000E-04  +2.23310000E-04  -7.81340000E-04  -7.94850000E-04
   -5.01500000E-05  +1.35280000E-04  +7.16100000E-05  -4.67530000E-04  -1.45428000E-03
   +3.50100000E-04  -4.29150000E-04  +5.59300000E-04  -1.85100000E-04  -1.19800000E-04
   +1.01368000E-03  +1.02801000E-03  -1.54060000E-04  +3.37216000E-03  -4.00661000E-03
   -8.93587000E-03  -1.58560300E-02  +1.54082700E-02  +1.29520000E-03  -2.80345400E-02
   -6.82338100E-02  +6.46682000E-03  +8.41018000E-03  +6.39238000E-03  +2.00348500E-02
   +5.32481000E-03  -3.51303000E-03  -4.88179000E-03  -4.80830000E-03  -2.52916000E-03
   +6.57162000E-03  -6.08791000E-03  +2.52133000E-03  -2.10580000E-03  -2.31015000E-03
   +5.04433000E-03  +3.98786000E-03  +5.05580000E-04  -6.73000000E-06  +2.50260000E-04
   +5.55005000E-03  +4.33000000E-03  -3.86547000E-03  -1.14660000E-04  -1.29480000E-04
   +7.42300000E-05  +7.97600000E-05  +4.86300000E-05  -5.12500000E-05  -1.33590000E-04
   -5.00000000E-08  +7.43100000E-05  -1.60560000E-04  -3.38970000E-04  -3.01800000E-05
   +2.46110000E-04  +2.32900000E-05  +2.06280000E-04  +2.09060000E-04  -1.92150000E-04
   +2.24210000E-04  -3.93500000E-05  +1.39100000E-04  -1.25650000E-04  -1.40740000E-04
   +4.50900000E-05  +1.81100000E-05  -1.65570000E-04  +7.39000000E-05  +3.14100000E-05
   -4.47200000E-05  +2.42550000E-04  +1.37400000E-05  +2.65840000E-04  -2.42860000E-04
   +1.17900000E-05  +9.65760000E-04  +1.82490000E-04  -1.41244000E-03  -2.21770000E-04
   -6.29150000E-04  -4.41600000E-05  -4.61688600E-02  -9.88504200E-02  +9.68840000E-03
   -1.96640000E-04  -5.28790000E-04  +7.57250000E-04  +3.02840000E-04  -1.42094000E-03
   -7.94400000E-05  -1.96830000E-04  +6.29850000E-04  -4.14600000E-05  -2.09430000E-04
   -3.28400000E-05  -2.40820000E-04  +2.59797000E-02  +5.81846000E-03  -1.42345600E-02
   -2.27654000E-03  -2.86819000E-03  -9.93580000E-04  +3.19540000E-04  -6.43530000E-04
   -1.92982000E-03  -1.45851630E-01  +3.97391610E-01  +6.69050000E-04  -1.07590000E-04
   -1.31030000E-04  +3.06530000E-04  +6.04170000E-04  +1.07000000E-05  -1.31020000E-04
   +7.31800000E-05  +1.03030000E-04  -1.75900000E-05  -1.31090000E-04  +3.22780000E-04
   -2.60790000E-04  -1.05660000E-04  +2.25810000E-04  +2.24440000E-04  -8.42240000E-04
   +4.71800000E-04  +8.63390000E-04  +2.74540000E-04  +5.00800000E-05  -3.14480000E-04
   +1.05600000E-05  -1.77100000E-05  -1.81800000E-05  -1.06950000E-04  +6.87300000E-05
   -1.26941000E-03  +2.38753000E-03  +4.76911000E-03  +6.46601000E-03  -7.34679000E-03
   -3.55400000E-04  +1.29002400E-02  +3.15742400E-02  +3.70552000E-03  -2.51152000E-03
   -5.52816000E-03  -1.05503800E-02  -4.69973000E-03  +3.29092000E-03  +4.55711000E-03
   +6.02668000E-03  +3.27189000E-03  -6.06706000E-03  +1.59716000E-03  -1.79440000E-04
   +1.12409000E-03  -2.11647000E-03  -3.84318000E-03  +1.55284000E-03  -2.94580000E-04
   -1.54400000E-05  -1.44270000E-04  -6.75841000E-03  -8.41635000E-03  +1.78261000E-03
   -1.15540000E-04  +3.30000000E-05  -5.61100000E-05  -7.03000000E-05  +2.91800000E-05
   -2.42700000E-05  +2.47500000E-05  +4.83200000E-05  -5.84600000E-05  +1.86000000E-05
   -2.85900000E-05  +9.39900000E-05  -2.85000000E-06  +4.08800000E-05  -1.10080000E-04
   -7.30800000E-05  +1.02990000E-04  -1.03200000E-04  -2.83100000E-05  -9.90100000E-05
   +8.15900000E-05  +8.59600000E-05  +9.75000000E-06  +7.22000000E-06  +6.13800000E-05
   +4.58200000E-05  +3.60800000E-05  -1.81300000E-05  -1.47370000E-04  -3.42000000E-06
   -9.38400000E-05  +1.20350000E-04  +2.67600000E-05  -8.99540000E-04  -4.81190000E-04
   +1.07140000E-03  +2.17260000E-04  +5.38400000E-04  -1.19980000E-04  +9.13414000E-03
   +1.39103400E-02  -2.81325400E-02  +1.11660000E-04  -6.30700000E-05  -1.17880000E-04
   -1.80000000E-04  +1.62320000E-04  -2.22880000E-04  -8.68080000E-04  -3.02240000E-04
   +6.03540000E-04  +2.06060000E-04  +1.90300000E-04  +5.50330000E-04  +4.60979100E-02
   -2.83047200E-02  -1.18326100E-02  +5.25639000E-03  +1.10547000E-02  +4.74255000E-03
   +9.34690000E-04  -1.59599000E-03  -7.46962000E-03  +1.07880680E-01  -1.88019210E-01
   +2.19150210E-01  +2.59300000E-05  +7.82000000E-06  -1.63100000E-05  -1.67000000E-06
   +9.52000000E-06  -1.52500000E-05  -9.07000000E-06  -1.46500000E-05  +1.28500000E-05
   -7.70000000E-07  -5.99000000E-06  +1.48800000E-05  +4.31800000E-05  +3.09900000E-05
   -9.97000000E-06  +5.53000000E-06  -7.17000000E-06  +4.12300000E-05  -3.65300000E-05
   -4.35900000E-05  +4.05000000E-06  -1.06000000E-06  -3.10000000E-06  +8.27000000E-06
   -2.31000000E-05  -5.28800000E-05  +2.08900000E-05  -2.30000000E-06  +9.13400000E-05
   -2.18500000E-04  -6.53800000E-04  +5.10720000E-04  +7.08700000E-05  -2.46551000E-03
   -3.55492000E-03  -5.93360000E-04  +1.51477000E-03  -3.71200000E-04  +1.29355000E-03
   +1.87400000E-05  -3.21020000E-04  -1.99790000E-04  -7.04200000E-05  +7.89900000E-05
   -1.29300000E-05  -1.10313000E-03  +1.03381000E-03  -3.65990000E-04  -1.96550000E-04
   +3.97270000E-04  +1.55290000E-04  +3.32000000E-06  -6.64000000E-06  -7.85000000E-06
   +1.12170000E-04  -8.83100000E-05  -9.12300000E-05  -1.29900000E-05  +1.15700000E-05
   -9.00000000E-06  -4.93000000E-06  +3.63000000E-06  -2.46000000E-06  -2.94000000E-06
   +2.88000000E-06  -2.69000000E-06  -5.05000000E-06  -6.25000000E-06  +2.22100000E-05
   -8.00000000E-06  +8.56000000E-06  -1.98500000E-05  -1.60000000E-07  +2.10000000E-07
   -2.61000000E-06  -3.50000000E-06  -4.71000000E-06  +2.66000000E-06  +1.00000000E-07
   +1.23000000E-06  -3.24000000E-06  -3.13000000E-06  +6.02000000E-06  +5.38000000E-06
   -3.00000000E-06  -2.66000000E-06  +5.00000000E-07  +1.66000000E-06  +1.86000000E-06
   +2.64000000E-06  +2.73900000E-05  -8.52000000E-06  -2.47900000E-05  +1.90400000E-05
   +1.30000000E-07  -1.82600000E-05  +1.62779400E-02  -5.13987000E-03  +7.02858000E-03
   -1.13300000E-05  +2.98000000E-06  +5.89000000E-06  -1.68570000E-04  -5.25270000E-04
   +1.70280000E-04  -2.21000000E-05  +9.04000000E-06  +6.26300000E-05  +7.63000000E-06
   +5.71900000E-05  +1.61200000E-05  -2.61623000E-03  +1.08427000E-03  +4.88936000E-03
   -2.85750000E-04  +5.50400000E-05  +1.84550000E-04  +3.66540000E-04  -2.19140000E-04
   -3.31180000E-04  -2.35141410E-01  +1.97026350E-01  -1.53347670E-01  +2.26432720E-01
   +1.32000000E-05  -6.64000000E-06  -8.98400000E-05  -1.22700000E-05  +1.14010000E-04
   -2.73400000E-05  -2.67500000E-05  -2.86100000E-05  -6.70000000E-07  -1.54600000E-05
   -5.20600000E-05  -2.76400000E-05  +2.60430000E-04  +1.88590000E-04  -6.28700000E-05
   -8.13700000E-05  +6.18900000E-05  +5.52300000E-05  +9.88800000E-05  -1.62510000E-04
   +4.07200000E-05  -5.70000000E-05  +2.12800000E-05  +2.90300000E-05  -2.42130000E-04
   -2.16600000E-04  +4.76300000E-05  +1.00400000E-05  +6.81010000E-04  +2.91060000E-04
   -1.47930000E-04  -5.87800000E-05  -1.16810000E-04  -2.65288000E-03  -9.06450000E-04
   -8.20140000E-04  +1.19600000E-05  -3.48100000E-04  +1.11316000E-03  +4.87740000E-04
   +9.31000000E-06  -7.77050000E-04  -2.31410000E-04  -1.19400000E-04  -2.53230000E-04
   -1.23710000E-04  +3.43790000E-04  -2.18920000E-04  -6.35400000E-05  -1.12470000E-04
   +1.28180000E-04  -4.08600000E-05  -1.71000000E-06  -3.90500000E-05  +1.80000000E-07
   +3.17690000E-04  +1.92740000E-04  +3.63300000E-05  +3.09600000E-05  -1.67800000E-05
   -1.74800000E-05  -3.42000000E-06  +1.46400000E-05  +1.17100000E-05  +7.00000000E-07
   -1.28000000E-06  +2.06800000E-05  -2.32900000E-05  +5.68600000E-05  +1.40600000E-05
   +4.50000000E-07  +3.90000000E-07  -3.59100000E-05  +2.20400000E-05  -2.78600000E-05
   +1.30500000E-05  -8.33000000E-06  +1.77000000E-05  +9.81000000E-06  -1.38300000E-05
   +3.78000000E-06  +1.64500000E-05  -1.54600000E-05  -1.20000000E-06  +1.43400000E-05
   -2.30500000E-05  -2.30000000E-06  -3.87600000E-05  +2.82100000E-05  -2.11000000E-06
   +1.17000000E-06  +3.56100000E-05  +4.32600000E-05  -7.00000000E-08  -2.77700000E-05
   +2.04700000E-05  +2.07696000E-02  -1.31219000E-02  +1.32584900E-02  +1.30800000E-05
   -2.87800000E-05  -2.07100000E-05  -2.75200000E-04  -1.18300000E-04  +1.67920000E-04
   -9.45800000E-05  +4.28800000E-05  +8.57900000E-05  +3.18800000E-05  -1.28470000E-04
   -1.19040000E-04  -1.08509000E-03  +1.05574000E-03  +4.77300000E-05  +1.91460000E-04
   -3.34850000E-04  +5.23000000E-06  +2.43220000E-04  +6.10900000E-05  +1.41070000E-04
   +1.74596390E-01  -2.11698090E-01  +1.58411140E-01  -1.95446680E-01  +2.28492320E-01
   +4.43000000E-06  +2.63300000E-05  -2.50000000E-05  -7.07000000E-06  -2.83700000E-05
   -1.29600000E-05  -7.99000000E-06  +1.43300000E-05  -1.19000000E-06  -2.55000000E-06
   +1.25600000E-05  +2.52000000E-06  -3.17400000E-05  -2.53700000E-05  +2.47000000E-05
   +2.91800000E-05  -6.76000000E-06  +1.62300000E-05  -1.24300000E-05  +1.23000000E-05
   -2.13000000E-05  -5.81000000E-06  -2.01000000E-06  -1.08500000E-05  +1.84700000E-05
   +1.78800000E-05  -1.73000000E-05  -4.05400000E-05  -2.26880000E-04  -1.10170000E-04
   +9.01900000E-05  -8.29200000E-05  -3.12500000E-05  +1.16900000E-04  -1.21700000E-05
   +1.10546000E-03  +3.14600000E-05  +2.74470000E-04  +2.95390000E-04  +1.76690000E-04
   +2.51030000E-04  -2.65880000E-04  +2.25200000E-04  -1.51940000E-04  +2.89200000E-04
   +1.31800000E-05  +1.50600000E-05  -2.19100000E-04  +1.78040000E-04  -2.03350000E-04
   -5.17280000E-04  -3.50000000E-07  +1.72000000E-06  +2.02700000E-05  -2.64550000E-04
   -4.00500000E-05  -2.95810000E-04  -1.52000000E-06  -6.67000000E-06  +1.08000000E-05
   +7.02000000E-06  -2.78000000E-06  -6.20000000E-07  +4.63000000E-06  -6.81000000E-06
   +1.40000000E-06  +1.49500000E-05  -1.49700000E-05  +2.64800000E-05  -9.57000000E-06
   +2.58000000E-06  -4.77000000E-06  +3.16000000E-06  +2.88000000E-06  +2.05000000E-06
   -2.24000000E-06  +1.31000000E-06  +1.21000000E-06  +1.31000000E-06  -4.89000000E-06
   +9.00000000E-08  +9.56000000E-06  -4.52000000E-06  -1.10500000E-05  -3.86000000E-06
   -1.64000000E-06  +4.98000000E-06  -4.80000000E-07  -7.80000000E-07  -9.50000000E-06
   -3.39000000E-06  +5.37000000E-06  -3.20200000E-05  -7.03700000E-05  -9.90800000E-05
   -8.30000000E-07  -7.05652000E-03  +3.13478000E-03  -4.83932000E-03  -4.86500000E-05
   -1.12900000E-05  +7.51000000E-06  +7.48100000E-05  +1.98560000E-04  +2.05610000E-04
   +1.11070000E-04  -8.46200000E-05  -5.38900000E-05  +7.84900000E-05  -2.02210000E-04
   -5.59500000E-05  +6.12124000E-03  -2.20789000E-03  -6.43286000E-03  +4.99640000E-04
   +5.56350000E-04  +5.68330000E-04  -2.31600000E-04  +2.17600000E-04  -3.68600000E-05
   -1.52454800E-01  +1.75998160E-01  -1.48845620E-01  +1.55616150E-01  -1.72582860E-01
   +1.46379490E-01  +1.64776000E-03  -3.76110000E-04  -4.79400000E-05  +8.40880000E-04
   +1.31672000E-03  +1.48440000E-04  -2.14100000E-04  +7.81300000E-05  +2.79520000E-04
   -3.73200000E-05  -3.03870000E-04  +6.39530000E-04  -1.36511000E-03  -6.48650000E-04
   +7.05630000E-04  +6.44800000E-04  -2.13288000E-03  +9.78920000E-04  +1.30745000E-03
   +3.57290000E-04  +9.23600000E-05  -5.86240000E-04  -3.46200000E-05  -4.66100000E-05
   +6.02690000E-04  +2.83210000E-04  +5.80000000E-06  -1.98217000E-03  +2.30460000E-03
   +6.00093000E-03  +7.49326000E-03  -8.79385000E-03  -8.90330000E-04  +5.64345000E-03
   +2.10172200E-02  -2.63974000E-03  -9.69110000E-04  -6.08503000E-03  -7.86472000E-03
   -4.43944000E-03  +2.98434000E-03  +2.82680000E-03  +9.29459000E-03  +3.93958000E-03
   -9.89337000E-03  -3.16250000E-04  +1.32633000E-03  +5.29190000E-04  -1.11677000E-03
   -1.77370000E-03  +7.38670000E-04  -5.49880000E-04  -7.18100000E-05  -2.35600000E-04
   -1.38819700E-02  -1.71857500E-02  +8.51780000E-04  -3.55720000E-04  -1.83500000E-05
   -6.28200000E-05  -1.02410000E-04  +5.52500000E-05  -9.17300000E-05  +4.20600000E-05
   +1.06040000E-04  -1.53050000E-04  +5.82400000E-05  +1.08790000E-04  -5.97000000E-06
   -1.45910000E-04  +8.25000000E-05  -3.21580000E-04  -1.09930000E-04  +1.90450000E-04
   -1.72540000E-04  -1.06460000E-04  -2.31210000E-04  +1.64780000E-04  +1.76390000E-04
   +4.68900000E-05  -9.68000000E-06  +1.03540000E-04  +1.25300000E-04  +9.26000000E-05
   -8.32600000E-05  -2.84220000E-04  +7.60000000E-07  -1.29420000E-04  +2.31670000E-04
   +5.37600000E-05  -1.35344000E-03  -8.40010000E-04  +1.60444000E-03  +1.57680000E-04
   +5.26110000E-04  -1.00530000E-04  -2.15997900E-02  -3.25964800E-02  +1.35414400E-02
   +3.18360000E-04  +2.62700000E-05  -1.88250000E-04  -5.20190000E-04  -4.38590000E-04
   +8.70000000E-06  -4.87710000E-04  -3.19840000E-04  +6.34600000E-04  +4.89910000E-04
   -7.37230000E-04  +4.07920000E-04  -5.48838400E-02  -1.40871400E-02  -9.36776000E-03
   +2.55761700E-02  +2.64338500E-02  +8.94409000E-03  -1.76521200E-02  +6.24328000E-03
   +8.89250000E-04  +1.75919400E-02  +4.89580000E-03  -2.49934700E-02  -2.00367000E-03
   +3.82342000E-03  -3.16975000E-03  +5.30030700E-02  -6.62480000E-04  +1.66860000E-04
   -3.18200000E-05  -2.87060000E-04  -6.15650000E-04  -8.35200000E-05  +1.80060000E-04
   -1.18150000E-04  -1.56060000E-04  -1.50170000E-04  -3.32700000E-05  -4.05590000E-04
   +7.24730000E-04  +5.98390000E-04  -2.22280000E-04  -2.48000000E-04  +1.00493000E-03
   -3.05780000E-04  -4.33350000E-04  -2.52430000E-04  -4.82000000E-06  +2.02210000E-04
   +2.05400000E-05  +2.37600000E-05  -4.60630000E-04  -3.86690000E-04  +4.83800000E-05
   +1.49842000E-03  -1.47666000E-03  -3.63668000E-03  -4.11328000E-03  +4.73878000E-03
   +8.07520000E-04  -3.34819000E-03  -1.28985400E-02  +1.52816000E-03  +1.27510000E-04
   +3.23936000E-03  +4.27627000E-03  +2.50917000E-03  -1.47125000E-03  -1.70051000E-03
   -4.66546000E-03  -3.04615000E-03  +4.45662000E-03  +4.57010000E-04  -6.56320000E-04
   -2.05690000E-04  +1.22928000E-03  +1.43032000E-03  -1.01002000E-03  +1.80470000E-04
   +4.10600000E-05  +8.80500000E-05  +4.03082000E-03  +6.86322000E-03  -2.88830000E-04
   +1.80410000E-04  +4.51000000E-05  +1.31300000E-05  +3.66400000E-05  -3.79400000E-05
   +4.62000000E-05  -2.20000000E-07  -4.75200000E-05  +6.88200000E-05  +2.98400000E-05
   -1.00300000E-05  +1.30730000E-04  -3.21700000E-05  -3.45400000E-05  +6.53000000E-06
   +1.22200000E-05  -5.59200000E-05  +6.37100000E-05  +4.77800000E-05  +7.97700000E-05
   -6.00500000E-05  -5.21900000E-05  -2.48700000E-05  +2.02100000E-05  -2.79400000E-05
   -6.93600000E-05  -3.97100000E-05  +4.25900000E-05  +1.11120000E-04  -1.56000000E-06
   +2.73800000E-05  -6.56200000E-05  -3.04900000E-05  +5.90410000E-04  +4.00840000E-04
   -6.70810000E-04  -7.68900000E-05  -2.64990000E-04  +1.10100000E-04  -1.24349000E-03
   +2.51362400E-02  +2.31288000E-03  -1.60740000E-04  +5.86000000E-06  +5.25600000E-05
   +1.59290000E-04  +2.39790000E-04  -1.24500000E-05  +3.83360000E-04  +2.16630000E-04
   -3.99040000E-04  -3.14710000E-04  +1.51190000E-04  -5.51120000E-04  -8.05620000E-03
   -3.24460300E-02  -3.10299000E-03  +1.06194400E-02  -1.71820300E-02  -1.50703600E-02
   +4.86832000E-03  -1.48744000E-03  +4.25398000E-03  -1.96516700E-02  -4.25919200E-02
   +1.94797700E-02  +5.39115000E-03  -3.94864000E-03  -4.73244000E-03  +1.04562900E-02
   +7.47319600E-02  -9.82420000E-04  +1.75140000E-04  +1.89970000E-04  -3.72420000E-04
   -6.63710000E-04  -7.24100000E-05  +1.10670000E-04  -1.56270000E-04  -2.49250000E-04
   +9.93400000E-05  +8.55400000E-05  -6.29390000E-04  +5.97400000E-04  +4.00130000E-04
   -3.31420000E-04  -4.25910000E-04  +1.14196000E-03  -6.44670000E-04  -7.11260000E-04
   -1.84160000E-04  -6.38700000E-05  +2.99700000E-04  +3.57200000E-05  +2.29300000E-05
   -2.19590000E-04  -1.15120000E-04  -5.66800000E-05  +9.20940000E-04  -1.42002000E-03
   -3.47120000E-03  -4.27297000E-03  +4.97955000E-03  +3.60030000E-04  -3.49935000E-03
   -1.28736300E-02  +1.44572000E-03  +2.71390000E-04  +4.03395000E-03  +5.45642000E-03
   +3.09878000E-03  -1.51024000E-03  -2.39557000E-03  -5.67008000E-03  -3.13126000E-03
   +6.29065000E-03  +2.67470000E-04  -8.71760000E-04  -4.39420000E-04  +6.49390000E-04
   +1.18986000E-03  -6.66440000E-04  +2.87830000E-04  +3.43000000E-05  +1.73450000E-04
   +6.78894000E-03  +1.00121500E-02  -5.05270000E-04  +2.01340000E-04  -9.99000000E-06
   +5.51700000E-05  +7.72300000E-05  -4.91500000E-05  +4.78100000E-05  +5.16000000E-06
   -7.09100000E-05  +5.87500000E-05  +3.67900000E-05  +1.42060000E-04  -3.33590000E-04
   -7.80500000E-05  -6.69500000E-05  +3.98600000E-05  +6.38400000E-05  -1.06230000E-04
   +8.59800000E-05  +4.65800000E-05  +1.12120000E-04  -8.73700000E-05  -8.79800000E-05
   -2.41700000E-05  -2.43600000E-05  -3.47600000E-05  -9.07400000E-05  -7.16400000E-05
   +3.67800000E-05  +1.44230000E-04  -3.90000000E-07  +7.16800000E-05  -1.23580000E-04
   -5.04800000E-05  +7.87230000E-04  +5.06000000E-04  -9.59290000E-04  -1.55890000E-04
   -3.71870000E-04  +6.05600000E-05  +1.13032900E-02  +1.90225900E-02  -7.26334000E-03
   -1.38170000E-04  +7.76900000E-05  -2.50500000E-05  +3.26970000E-04  +2.98360000E-04
   +6.81400000E-05  +3.55760000E-04  +2.01990000E-04  -3.64650000E-04  -2.00930000E-04
   -2.72300000E-05  -5.53010000E-04  +1.10394100E-02  -1.16150800E-02  -6.15743000E-02
   -2.25724000E-03  -1.68951100E-02  -1.10191300E-02  -1.23314700E-02  +1.00559800E-02
   +1.97521600E-02  -1.20850800E-02  +1.75716000E-03  -3.07453600E-02  -1.43358800E-02
   +1.03548000E-03  +1.28897000E-02  +2.01155400E-02  -5.06477000E-03  +7.56002800E-02
end_hess

