# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -959.74831920    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -3.55548768E+00  -5.20375781E-01  -1.89741047E+00
   006   -3.26589906E+00  +1.49831339E+00  -2.24922593E-01
   006   -5.19490485E+00  +1.91742206E+00  +1.49526845E+00
   006   -7.33856514E+00  +3.98018136E-01  +1.55381820E+00
   006   -7.58535200E+00  -1.58295731E+00  -1.35673807E-01
   006   -5.66988629E+00  -2.04048803E+00  -1.87541925E+00
   006   -8.83418098E-01  +3.13719230E+00  -3.85406740E-01
   006   -8.73393529E-01  +4.45057387E+00  -2.97388742E+00
   008   -9.63390893E+00  -3.13611816E+00  -1.76473120E-01
   006   +1.46724751E+00  +1.50353184E+00  -7.26168753E-03
   006   +3.34600420E+00  +1.27304820E+00  -1.71705201E+00
   006   +5.54139667E+00  -2.59942255E-01  -1.23372384E+00
   006   +6.14437237E+00  -6.25963461E-01  +1.39668292E+00
   006   +4.31491326E+00  -4.16006557E-01  +3.18824860E+00
   006   +1.74873215E+00  +8.51216657E-02  +2.38067713E+00
   008   +8.52688782E+00  -1.27002922E+00  +1.98788855E+00
   008   +7.65651150E+00  -5.31377229E-02  -2.85312063E+00
   006   -8.61299447E-01  +5.24069744E+00  +1.61865831E+00
   008   +3.12287989E-01  -2.71514028E+00  +1.84395382E+00
   001   -1.08083599E+01  -2.61948467E+00  +1.09716579E+00
   001   -8.81508055E+00  +7.72042660E-01  +2.92461211E+00
   001   -5.06937775E+00  +3.44884563E+00  +2.84121604E+00
   001   -2.05502756E+00  -9.47241310E-01  -3.22209847E+00
   001   -5.85885793E+00  -3.60393617E+00  -3.17763025E+00
   001   -2.57886673E+00  +5.58948868E+00  -3.16632561E+00
   001   +7.56375505E-01  +5.69977066E+00  -3.16662173E+00
   001   -8.47811486E-01  +3.10090797E+00  -4.52832906E+00
   001   -9.23151261E-01  +4.50984204E+00  +3.54320499E+00
   001   +8.66165674E-01  +6.34468912E+00  +1.42446565E+00
   001   -2.46576048E+00  +6.51231694E+00  +1.37353504E+00
   001   +4.94659193E-01  +7.10161873E-01  +3.87593630E+00
   001   +4.73402548E+00  -7.70283618E-01  +5.15496498E+00
   001   +4.20374582E+00  -2.67014935E+00  -1.65349560E+00
   001   +3.22032396E+00  +2.14754013E+00  -3.56198715E+00
   001   +9.47670966E+00  -1.18844121E+00  +4.33310583E-01
   001   +8.14010308E+00  +1.68858375E+00  -2.97672212E+00
   001   +5.85411366E-01  -3.67675379E+00  +3.35754936E+00
   008   +2.75322890E+00  -4.34755307E+00  -1.65098218E+00
   001   +1.50662006E+00  -3.70191755E+00  +8.25412139E-02
   001   +3.64746919E+00  -5.87228136E+00  -1.26624390E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +2.60000000E-07  -1.80000000E-07  -5.40000000E-07
   -3.00000000E-08  -7.00000000E-08  -4.10000000E-07
   -2.60000000E-07  -1.50000000E-07  -7.20000000E-07
   -2.60000000E-07  -2.50000000E-07  -1.10000000E-06
   +5.00000000E-08  -2.60000000E-07  -1.11000000E-06
   +3.40000000E-07  -2.10000000E-07  -8.20000000E-07
   -1.00000000E-08  +0.00000000E+00  -1.50000000E-07
   +3.60000000E-07  -2.00000000E-08  -1.30000000E-07
   +1.70000000E-07  -2.70000000E-07  -1.39000000E-06
   +0.00000000E+00  +5.00000000E-08  +2.30000000E-07
   +2.00000000E-07  +5.00000000E-08  +4.40000000E-07
   +2.20000000E-07  +3.20000000E-07  +8.60000000E-07
   -2.00000000E-07  +1.80000000E-07  +9.90000000E-07
   -3.70000000E-07  +1.90000000E-07  +6.40000000E-07
   -1.50000000E-07  +1.60000000E-07  +3.50000000E-07
   -2.90000000E-07  +3.00000000E-07  +1.29000000E-06
   +5.30000000E-07  +2.80000000E-07  +1.11000000E-06
   -4.20000000E-07  +0.00000000E+00  -1.40000000E-07
   -3.60000000E-07  +6.00000000E-08  -1.00000000E-07
   -6.00000000E-08  -3.50000000E-07  -1.60000000E-06
   -4.50000000E-07  -2.50000000E-07  -1.32000000E-06
   -5.30000000E-07  -1.30000000E-07  -7.50000000E-07
   +6.30000000E-07  -1.20000000E-07  -2.80000000E-07
   +6.20000000E-07  -2.00000000E-07  -8.20000000E-07
   +2.90000000E-07  -9.00000000E-08  -3.70000000E-07
   +3.00000000E-07  +3.00000000E-08  +1.20000000E-07
   +5.70000000E-07  -5.00000000E-08  -1.30000000E-07
   -6.40000000E-07  -2.00000000E-08  -1.00000000E-07
   -4.10000000E-07  +6.00000000E-08  +1.00000000E-07
   -4.10000000E-07  -7.00000000E-08  -3.60000000E-07
   -6.70000000E-07  -2.00000000E-08  +1.30000000E-07
   -7.30000000E-07  +1.60000000E-07  +7.30000000E-07
   +4.40000000E-07  +1.40000000E-07  +7.50000000E-07
   +4.80000000E-07  +8.00000000E-08  +5.10000000E-07
   -2.00000000E-08  +3.00000000E-07  +1.44000000E-06
   +3.90000000E-07  +2.20000000E-07  +1.22000000E-06
   -3.40000000E-07  +0.00000000E+00  +2.30000000E-07
   +1.80000000E-07  -1.20000000E-07  +4.10000000E-07
   +1.60000000E-07  +2.00000000E-08  +1.80000000E-07
   +3.90000000E-07  +1.90000000E-07  +6.10000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.38673360E-01  +1.45307320E-01  +4.87297590E-01  -1.84836340E-01  +2.11362770E-01
   +4.61785950E-01  -1.18527960E-01  -5.11537600E-02  -1.47127900E-02  +5.53445850E-01
   -5.05296000E-03  -2.12043760E-01  -1.27098100E-01  +1.03270760E-01  +4.69635500E-01
   +2.85110100E-02  -9.57191600E-02  -1.77912520E-01  -1.57945160E-01  +1.88251860E-01
   +4.68403670E-01  +3.86187900E-02  +6.13955600E-02  +3.62970500E-02  -2.29457980E-01
   -1.64506700E-02  +9.52714800E-02  +5.70439930E-01  +2.57586400E-02  +8.73743000E-03
   -1.68282500E-02  +2.82357200E-02  -1.13127740E-01  -6.40572400E-02  +1.51014070E-01
   +5.16654640E-01  +3.47697000E-03  -4.18629700E-02  -3.20234400E-02  +1.39224240E-01
   -3.29236600E-02  -1.92722980E-01  -1.56837110E-01  +2.48279130E-01  +4.80483460E-01
   -2.14247500E-02  -3.08610800E-02  -1.54401400E-02  -4.40662400E-02  +9.14732000E-03
   +4.43646000E-02  -2.53799690E-01  -1.41642920E-01  +2.34461000E-03  +6.05728780E-01
   -2.68347700E-02  -4.74551100E-02  -2.21331400E-02  -2.56390100E-02  +3.96600900E-02
   +4.87582800E-02  -9.56706800E-02  -1.72971450E-01  -4.03089800E-02  +1.50817210E-01
   +4.80796230E-01  -1.29683900E-02  -1.96875600E-02  -1.38487600E-02  +1.13382100E-02
   +2.39018700E-02  +2.21274200E-02  +4.50490000E-02  -8.95660000E-03  -9.83550800E-02
   -1.92413140E-01  +2.31282440E-01  +4.73483490E-01  -4.87237500E-02  -3.03822600E-02
   +6.60846000E-03  -9.66551000E-03  +2.24113500E-02  +2.45664200E-02  +2.66727200E-02
   -1.57796200E-02  -3.15962600E-02  -1.22313540E-01  -5.00672200E-02  -9.63254000E-03
   +6.05201720E-01  +9.01278000E-03  +4.38695500E-02  +3.14994400E-02  +2.01053900E-02
   -2.62220800E-02  -3.35768200E-02  -5.56197400E-02  -3.44329800E-02  +4.24318000E-03
   +5.79083000E-03  -2.17908790E-01  -1.44397610E-01  +1.45883460E-01  +5.07670570E-01
   +4.35610100E-02  +5.93198000E-02  +2.72121600E-02  +2.16591700E-02  -3.42832600E-02
   -5.38896400E-02  -6.87527400E-02  -2.30194000E-02  +2.73542800E-02  +4.24873100E-02
   -1.06171830E-01  -1.97619790E-01  -1.68240050E-01  +2.22838800E-01  +4.86478280E-01
   -2.75257240E-01  -1.06982460E-01  +4.44579900E-02  +2.01006600E-02  -5.29327500E-02
   -5.98440000E-02  -6.00016300E-02  -1.43995800E-02  +2.54016000E-02  +3.83557200E-02
   +5.54498000E-02  +3.14061100E-02  -2.03746400E-01  -9.91335000E-03  +8.25312500E-02
   +5.93813960E-01  -1.55685950E-01  -1.87150810E-01  -1.24657200E-02  -1.86360200E-02
   -2.88217400E-02  -2.20179900E-02  -1.44563000E-02  -6.23719000E-03  +7.08215000E-03
   +2.31347800E-02  +1.01423900E-02  -1.45386900E-02  +4.40378900E-02  -1.19989490E-01
   -7.55710300E-02  +1.75128580E-01  +5.34696580E-01  +1.49902000E-03  -4.53062100E-02
   -1.01843730E-01  -2.60555100E-02  +3.06821000E-03  +2.91052700E-02  +2.58841000E-02
   +6.97670000E-03  -1.44800800E-02  +7.87380000E-04  -3.71239200E-02  -2.66249700E-02
   +1.31660600E-01  -3.79463600E-02  -1.96831630E-01  -1.52368380E-01  +2.53975590E-01
   +4.67902520E-01  -3.83718000E-03  -9.70284000E-03  -5.79955000E-03  -1.39059820E-01
   -4.08653400E-02  +1.07330400E-02  -1.76542500E-02  -1.18531800E-02  +2.90514000E-03
   +8.84240000E-04  -9.10510000E-04  +3.55389000E-03  -2.41051000E-03  +3.42630000E-04
   +1.45253000E-03  +4.35542000E-03  +7.92750000E-04  +1.38609000E-03  +4.69669600E-01
   -2.24060300E-02  -1.52529400E-02  +2.69440000E-04  -4.72980800E-02  -1.09687410E-01
   -5.64806000E-03  +4.01190000E-04  +6.93910000E-03  +3.27573000E-03  +4.58040000E-04
   +2.94484000E-03  -4.07662000E-03  -1.84480000E-04  -1.08692000E-03  -5.09480000E-04
   -8.28400000E-05  -2.15530000E-04  -4.70779000E-03  +2.85070000E-04  +4.75234470E-01
   -1.79958700E-02  -9.51782000E-03  +5.16441000E-03  +8.17471000E-03  -6.72314000E-03
   -8.15460600E-02  +1.48255500E-02  +1.20729200E-02  +3.40907000E-03  +4.23970000E-03
   -3.29926000E-03  +1.04787000E-03  +3.51980000E-04  -8.46600000E-04  -1.55245000E-03
   +1.10915000E-03  -5.51812000E-03  -8.40310000E-04  -1.55368000E-03  +2.31151000E-03
   +4.85327130E-01  -5.60310000E-04  -1.12753000E-03  +8.49440000E-04  -5.33650000E-03
   -1.47493600E-02  +2.61822900E-02  -7.58220000E-04  -2.13184000E-03  -8.17600000E-04
   -1.65548000E-03  -8.84000000E-06  -1.16837000E-03  +3.00100000E-04  +9.99030000E-04
   +7.59420000E-04  +2.21250000E-04  +6.86440000E-04  +1.12460000E-04  -7.43890600E-02
   -1.16137000E-03  +2.68557000E-03  +5.86909510E-01  -1.03045000E-03  -7.39410000E-04
   +9.30650000E-04  -7.39335000E-03  -1.34731100E-02  +1.92983300E-02  +1.12471000E-03
   -1.29450000E-03  -6.51730000E-04  -9.09930000E-04  -3.25560000E-04  -9.04800000E-04
   -3.36000000E-06  +7.11390000E-04  +7.48300000E-04  +4.16710000E-04  +7.16020000E-04
   +2.00100000E-05  +2.05439000E-03  -9.48750500E-02  +4.08046000E-02  -6.42350000E-04
   +5.57283970E-01  -1.73230000E-03  -8.50600000E-04  -1.42070000E-04  +8.92527000E-03
   +8.26830000E-03  -4.82369000E-03  -1.17401000E-03  -3.05900000E-05  -3.04500000E-05
   -3.01600000E-05  -2.46230000E-04  -8.68400000E-05  +1.68830000E-04  +2.51000000E-04
   +4.00310000E-04  +3.23760000E-04  -2.42370000E-04  -2.78840000E-04  -2.06369000E-03
   +3.77390600E-02  -1.53387710E-01  -2.12725000E-03  +5.67849600E-02  +4.94345130E-01
   +3.76512000E-03  +4.64229000E-03  +4.71888000E-03  -1.11992000E-03  -4.13077000E-03
   -4.18041000E-03  -7.03300000E-05  -1.69520000E-03  +3.73434000E-03  -1.12892300E-02
   -1.62509000E-02  -7.21110000E-04  -2.21269430E-01  -1.32586100E-01  -1.66941000E-03
   -4.48441100E-02  -2.92129900E-02  +8.73842000E-03  +1.49474000E-03  +9.62950000E-04
   +3.15610000E-04  -1.08688000E-03  -5.19810000E-04  -4.80940000E-04  +5.07810320E-01
   -2.29450000E-04  -1.15694000E-03  -5.50597000E-03  -2.39880000E-03  -4.15720000E-04
   +2.42035000E-03  +3.71075000E-03  +2.79482000E-03  -7.41761000E-03  -4.27930500E-02
   -2.61747200E-02  -4.03810000E-03  -9.79455900E-02  -1.61550150E-01  -4.25350200E-02
   -2.66758000E-03  +9.35483000E-03  +3.99027000E-03  +1.08320000E-03  +4.20710000E-04
   +8.57560000E-04  -8.95990000E-04  -4.70660000E-04  -3.52040000E-04  +7.44955000E-02
   +2.54424240E-01  +3.87080000E-04  -8.94446000E-03  -3.56090000E-03  -2.37416000E-03
   +3.68545000E-03  +3.90910000E-03  +9.01054000E-03  -3.61030000E-03  -1.69222000E-03
   -2.56757100E-02  -2.24527200E-02  +6.42726000E-03  +3.01768100E-02  -1.89345100E-02
   -8.19527800E-02  +3.32665600E-02  +2.22029900E-02  +4.80848000E-03  -4.88680000E-04
   +3.60680000E-04  -7.39000000E-05  +1.05000000E-05  -2.95000000E-05  -5.61800000E-05
   -2.57501500E-01  +1.59456790E-01  +3.49538130E-01  -3.02450000E-04  +4.33250000E-04
   -1.65790000E-04  -3.57969600E-02  +9.91758000E-03  -5.25810000E-04  -8.24920000E-04
   -1.00371000E-03  -1.96589000E-03  -1.72820000E-04  -1.20401000E-03  +8.86100000E-04
   +6.21000000E-05  +4.40890000E-04  +4.40330000E-04  +2.19960000E-04  +6.72590000E-04
   +6.61100000E-04  -1.37224000E-01  +5.10797800E-02  -7.53167000E-03  -1.02997000E-03
   +4.01571000E-03  -5.02711000E-03  -4.41870000E-04  -2.79100000E-04  -4.38300000E-05
   +5.98411510E-01  -2.71488000E-03  -9.10970000E-04  -9.94800000E-04  -8.97861000E-03
   +1.31367200E-02  -5.87700000E-04  -7.94570000E-04  -1.48054000E-03  -1.07388000E-03
   -7.61690000E-04  -1.42924000E-03  +4.30320000E-04  +3.02430000E-04  +1.22480000E-03
   +8.34250000E-04  +5.23090000E-04  +4.12520000E-04  +3.58800000E-05  +4.56000200E-02
   -1.03478910E-01  +1.42097500E-02  +1.38399900E-02  -1.17337200E-02  +5.20745000E-03
   -1.12684000E-03  -8.33860000E-04  -5.02200000E-05  -1.43412150E-01  +3.28671240E-01
   -5.82310000E-04  -5.70700000E-04  +7.57300000E-05  +3.47621000E-03  -3.84104000E-03
   +1.13338000E-03  +8.18050000E-04  +9.46500000E-04  -4.93000000E-05  -1.91900000E-05
   +4.93350000E-04  -2.60590000E-04  -4.40600000E-04  -3.87620000E-04  -1.73160000E-04
   -1.15020000E-04  +2.45860000E-04  -3.35200000E-05  -3.93564000E-03  +1.33815800E-02
   -8.56427800E-02  -2.56605800E-02  +2.00606700E-02  -6.03732000E-03  +6.00430000E-04
   +3.97090000E-04  +1.02740000E-04  -1.86440710E-01  -9.62912000E-02  +5.55870040E-01
   +5.70240000E-04  +2.79970000E-04  +1.80400000E-05  -5.29910000E-04  +8.92500000E-04
   +3.92030000E-04  -5.35220000E-04  -3.93460000E-04  +3.35730000E-04  +2.40040000E-04
   +4.40990000E-04  +2.50050000E-04  -2.44700000E-04  -4.57500000E-04  -3.37020000E-04
   -1.41130000E-04  -2.66210000E-04  +6.00000000E-05  -2.27300300E-02  +5.95163000E-03
   +1.43926400E-02  -1.39259000E-03  -5.65000000E-05  +2.11240000E-04  +5.26680000E-04
   +4.26710000E-04  -1.03200000E-05  -2.90464560E-01  +4.29308000E-02  +1.59329620E-01
   +5.86111070E-01  -7.92480000E-04  +5.30000000E-05  -6.92000000E-06  -4.31010000E-04
   -1.10017000E-03  -5.84090000E-04  +5.73650000E-04  +3.68100000E-04  -3.07150000E-04
   -2.38830000E-04  -3.92110000E-04  -1.92040000E-04  +1.54780000E-04  +3.98810000E-04
   +3.64430000E-04  +2.34580000E-04  +4.09500000E-04  -1.25470000E-04  +1.44528800E-02
   -1.19160000E-04  -1.08328700E-02  +1.08681000E-03  -1.27058000E-03  -4.88980000E-04
   -3.94280000E-04  -3.17130000E-04  +1.22700000E-05  +3.86988400E-02  -8.39672800E-02
   +1.68802600E-02  -1.60622830E-01  +3.11715490E-01  -7.06350000E-04  -1.96080000E-04
   -3.03750000E-04  -2.23720000E-03  +1.24416000E-03  -1.91230000E-04  -9.20800000E-05
   -2.91910000E-04  -5.42400000E-05  -1.87330000E-04  -4.47850000E-04  +9.70500000E-05
   +2.09650000E-04  +3.21060000E-04  +2.43530000E-04  +5.25600000E-05  +3.09650000E-04
   +7.00000000E-06  +1.18154000E-03  -3.25452000E-03  +8.53141000E-03  -7.94380000E-04
   -1.68000000E-06  +3.62210000E-04  -4.76930000E-04  -3.48520000E-04  +1.59500000E-05
   +1.87261170E-01  -2.36550000E-03  -2.60773890E-01  -1.50814370E-01  -1.66907650E-01
   +6.92129540E-01  -4.45600000E-05  -5.37600000E-05  +2.30600000E-05  -1.33460000E-04
   +4.66400000E-04  -7.75200000E-05  -1.82500000E-05  -5.62100000E-05  -2.95000000E-06
   -5.73000000E-05  -1.30350000E-04  +8.78300000E-05  -1.27050000E-04  +2.20700000E-05
   +5.36900000E-05  +7.35500000E-05  -1.00180000E-04  -6.88700000E-05  +2.13377000E-03
   +4.72900000E-04  +3.31152000E-03  +5.24540000E-04  -5.73260000E-04  +6.69940000E-04
   +6.09300000E-05  +1.93400000E-05  +1.25300000E-05  -2.80852600E-02  +1.80272000E-02
   +1.19798900E-02  -2.00659010E-01  +1.14142980E-01  -3.08834800E-02  +5.57942070E-01
   +1.15147000E-03  -2.40140000E-04  -6.93780000E-04  +1.56299000E-03  -2.60273000E-03
   +6.58360000E-04  -1.48300000E-05  +2.83720000E-04  +9.80750000E-04  +3.19010000E-04
   +9.29380000E-04  +2.23160000E-04  -7.47310000E-04  -1.05479000E-03  -5.73600000E-04
   -2.11100000E-04  -1.41650000E-04  +5.10700000E-05  -1.03490000E-03  +6.59244000E-03
   +1.81573000E-03  +8.60540000E-04  -1.79140000E-04  -6.15220000E-04  +1.31085000E-03
   +1.03027000E-03  +6.04300000E-05  +2.79451400E-02  +8.67742000E-03  -4.89953700E-02
   +4.63677800E-02  -9.80769400E-02  +5.79761000E-02  -1.13871830E-01  +2.31779640E-01
   +4.78400000E-05  -2.61190000E-04  -2.65850000E-04  +9.54400000E-05  +3.83990000E-04
   -8.85000000E-06  +1.14010000E-04  -3.54300000E-05  -6.03800000E-05  -2.32570000E-04
   -3.03050000E-04  -6.51000000E-06  +2.99960000E-04  +3.73060000E-04  +9.34000000E-05
   -5.56700000E-05  +9.92400000E-05  +9.08800000E-05  +3.17410000E-03  +5.77110000E-04
   -1.11694000E-03  -9.30140000E-04  +4.27610000E-04  +1.91700000E-05  -5.00570000E-04
   -3.46840000E-04  +5.16400000E-05  +1.30772800E-02  -1.04217900E-02  +1.10820700E-02
   -1.16291900E-02  +4.17926900E-02  -9.86577000E-02  -4.01937100E-02  -1.23283510E-01
   +5.23630180E-01  +2.37100000E-05  -6.17800000E-05  +3.39300000E-05  -1.36360000E-04
   +1.62130000E-04  -2.55900000E-05  -5.14900000E-05  -3.40800000E-05  +1.02690000E-04
   +4.27300000E-05  +5.21900000E-05  +1.60160000E-04  -6.66670000E-04  -3.47940000E-04
   +3.24600000E-05  +1.40280000E-04  -2.01910000E-04  -6.94200000E-05  -7.39510000E-04
   -1.11190000E-04  +1.11642000E-03  +2.80320000E-04  -7.70100000E-05  -1.28100000E-05
   +6.35530000E-04  +3.75900000E-04  +4.20000000E-06  -1.18302000E-03  +1.57891000E-03
   +6.97284000E-03  +8.35970000E-04  -2.80783000E-03  -2.74072800E-02  -1.01103930E-01
   +2.28902600E-02  -5.57206600E-02  +7.46794990E-01  -1.07760000E-04  -2.64600000E-05
   +4.18100000E-05  -1.64750000E-04  +3.42960000E-04  -7.99600000E-05  +2.99800000E-05
   -3.43000000E-05  -9.19400000E-05  -6.98900000E-05  -1.40260000E-04  -3.35700000E-05
   +2.45690000E-04  +2.06930000E-04  +5.39500000E-05  +4.66000000E-06  +9.43500000E-05
   -2.81800000E-05  +2.23320000E-04  -6.96550000E-04  -1.07030000E-04  -6.80700000E-05
   +7.35600000E-05  +7.88100000E-05  -2.83470000E-04  -1.86390000E-04  -7.20000000E-06
   -3.88676000E-03  -1.60540000E-03  +7.74352000E-03  +2.24157600E-02  -1.10917300E-02
   +1.98396700E-02  +6.24826000E-03  -6.08241800E-02  +2.66600900E-02  -1.15637480E-01
   +2.23037070E-01  +6.92100000E-05  +3.90140000E-04  +2.94600000E-04  +8.49190000E-04
   -1.94601000E-03  -2.48400000E-05  +6.70200000E-05  +2.90160000E-04  +1.43200000E-04
   +3.68480000E-04  +5.87640000E-04  -1.78120000E-04  -7.77800000E-05  -4.56800000E-04
   -2.48460000E-04  -6.10600000E-05  +6.92000000E-06  -8.15000000E-05  +2.48270000E-04
   +2.94056000E-03  -1.91002000E-03  +7.84400000E-05  +2.43080000E-04  -4.40330000E-04
   +4.78190000E-04  +3.86130000E-04  -7.11600000E-05  +1.17233800E-02  -2.73836000E-03
   -1.09940300E-02  -4.23349100E-02  +4.93902000E-03  -1.21983500E-02  +1.40133900E-02
   +6.79443600E-02  -2.17802900E-01  -9.90413700E-02  -5.23575400E-02  +6.70023740E-01
   +1.19400000E-05  +3.08050000E-04  +1.48350000E-04  +5.50100000E-05  -1.01957000E-03
   +1.96000000E-06  +1.94620000E-04  +1.72500000E-04  -1.45790000E-04  +1.33190000E-04
   +2.41120000E-04  -1.71000000E-04  +4.92850000E-04  +3.22300000E-05  -1.45140000E-04
   -6.47400000E-05  +2.66710000E-04  -2.84000000E-06  +6.94930000E-04  +2.58870000E-04
   +8.78100000E-05  +2.11420000E-04  +5.42800000E-05  -1.77090000E-04  -2.23070000E-04
   -5.09100000E-05  -3.58700000E-05  +1.82875000E-03  -2.05922000E-03  -1.53370700E-02
   -1.58165200E-02  +4.91452000E-03  -3.47841000E-03  +3.18153400E-02  +1.78304000E-02
   +3.59942300E-02  -2.43575870E-01  +2.07718000E-02  +1.18736560E-01  +6.38177380E-01
   -9.15400000E-05  +1.22100000E-05  -5.21200000E-05  -7.26300000E-04  +4.89500000E-05
   -1.04640000E-04  +1.24260000E-04  +7.90900000E-05  -1.64120000E-04  -4.41700000E-05
   -5.66800000E-05  +5.45900000E-05  -5.76100000E-05  -2.80200000E-05  +5.16400000E-05
   +1.32230000E-04  +1.88400000E-04  -9.93500000E-05  +2.56710000E-04  +3.41290000E-04
   +2.47079000E-03  +4.38930000E-04  -2.63260000E-04  +9.77100000E-05  +9.64900000E-05
   +1.13220000E-04  -1.44200000E-05  +1.02263500E-02  -1.30799000E-03  +1.05467100E-02
   +4.68114000E-03  -5.08040000E-04  +1.23956000E-03  -6.57077000E-03  +7.11250000E-03
   -8.71165000E-03  +1.57058400E-02  -6.79286600E-02  +9.53310000E-03  -8.05885600E-02
   +1.41576410E-01  -9.63000000E-05  -2.88360000E-04  -1.84050000E-04  +4.27610000E-04
   +6.47570000E-04  +8.02500000E-05  +3.31400000E-05  -1.31590000E-04  +3.21700000E-05
   -1.90900000E-04  -2.34200000E-04  +1.15970000E-04  -1.92100000E-04  +7.82000000E-05
   +1.64050000E-04  +2.13470000E-04  +3.78100000E-05  -2.38600000E-05  +9.67030000E-04
   +7.31300000E-04  -3.25516000E-03  -1.12559000E-03  +6.87410000E-04  +2.53220000E-04
   +4.46900000E-05  +1.44700000E-05  +1.46100000E-05  -3.01755500E-02  +8.10440000E-03
   +2.98973000E-03  +1.48191500E-02  -6.84121000E-03  -2.69067000E-03  +6.89219000E-03
   -2.12498000E-03  -3.99195100E-02  +1.61914890E-01  -1.06091200E-02  -2.79839780E-01
   -5.69537800E-02  -6.37566400E-02  +7.52835440E-01  -2.77360000E-04  -6.53250000E-04
   -2.60820000E-04  +1.23588000E-03  +2.49995000E-03  -1.22930000E-03  -8.05880000E-04
   -4.38040000E-04  +4.05130000E-04  -2.08000000E-05  -1.49830000E-04  +3.90080000E-04
   -7.29540000E-04  -2.60720000E-04  -1.04550000E-04  -1.87160000E-04  -5.70590000E-04
   +9.70100000E-05  +9.89770000E-04  +1.24734300E-02  -2.28059400E-02  -4.83510000E-03
   +2.99935000E-03  +1.07558000E-03  +4.10050000E-04  +1.14380000E-04  +8.46100000E-05
   -9.78671500E-02  +3.21243300E-02  -6.07664000E-03  +1.71759100E-02  -1.77488900E-02
   +2.45998600E-02  -1.77008600E-02  -1.47043800E-02  -2.27048700E-02  -5.65205700E-02
   +1.06830800E-02  +3.82020400E-02  -2.18930350E-01  +3.51445000E-02  -5.86206800E-02
   +5.20666840E-01  +1.77730000E-04  -2.34190000E-04  -4.77440000E-04  +1.03467000E-03
   +1.06246000E-03  +2.50250000E-04  -7.74810000E-04  -1.57880000E-04  +4.14600000E-04
   +1.03880000E-04  -1.04770000E-04  +1.59380000E-04  -6.82860000E-04  -1.80130000E-04
   -1.22700000E-05  -4.28480000E-04  -9.48740000E-04  +4.51500000E-04  +6.32000000E-03
   -6.85430000E-03  +1.49126900E-02  +2.20801000E-03  -4.28550000E-04  -6.04190000E-04
   +1.43110000E-04  -1.52350000E-04  +9.73700000E-05  +2.79083300E-02  -1.01733490E-01
   +3.27054500E-02  -2.50495600E-02  +2.06140600E-02  +1.09031700E-02  -1.22216000E-03
   -4.22691800E-02  -6.80147000E-03  +3.43566000E-03  -1.04375000E-03  +1.12333000E-03
   +6.64504200E-02  -7.02225600E-02  +2.38123000E-02  -2.02908490E-01  +2.13685580E-01
   -1.01680000E-04  +5.81780000E-04  +3.50260000E-04  +1.92700000E-05  +4.50170000E-04
   -5.11200000E-04  -4.31180000E-04  +1.60200000E-05  +2.49000000E-05  +4.49770000E-04
   +4.61300000E-04  -1.52080000E-04  +1.32290000E-04  -1.79850000E-04  -2.88470000E-04
   -2.66330000E-04  -3.96280000E-04  -5.12700000E-05  -6.86116000E-03  +4.16257000E-03
   -2.06165000E-03  +4.45850000E-04  -6.53280000E-04  +7.53740000E-04  +5.74300000E-05
   +4.47000000E-06  -3.91100000E-05  -1.30875900E-02  +6.46644900E-02  -1.77203070E-01
   +2.93156800E-02  -7.36240000E-04  -3.63892700E-02  -1.33199000E-02  +1.43288000E-02
   -1.65890000E-02  +5.34088000E-03  -7.58407000E-03  +4.14985500E-02  -2.67733300E-02
   +7.85216000E-03  -1.35337000E-01  -9.54232200E-02  -3.08152500E-02  +5.93562040E-01
   -1.86600000E-05  -1.31300000E-05  -1.42800000E-05  +5.91000000E-06  +4.72890000E-04
   -5.20800000E-05  +4.12600000E-05  -7.40000000E-05  -2.16420000E-04  -1.39860000E-04
   -2.34120000E-04  -1.55400000E-04  +8.21600000E-04  +5.55680000E-04  +1.07500000E-05
   -2.26760000E-04  +1.77700000E-04  +1.49450000E-04  +8.06050000E-04  -7.65390000E-04
   -5.94270000E-04  -5.32030000E-04  +1.51570000E-04  +1.14100000E-04  -9.30240000E-04
   -6.08360000E-04  +2.59200000E-05  +4.62300000E-04  -2.45180000E-04  -6.49234000E-03
   -1.84752000E-03  +5.96338000E-03  -1.86793000E-03  -3.58589700E-02  -2.49675000E-03
   -1.64501600E-02  -2.98044470E-01  +7.14484300E-02  -7.59040300E-02  -5.76263600E-02
   +1.76013500E-02  +1.83380000E-04  +1.28423500E-02  +6.61300000E-04  +1.22168700E-02
   +5.31947860E-01  +1.82000000E-05  +2.72100000E-05  -1.87000000E-05  +1.56700000E-05
   -1.76450000E-04  +6.71700000E-05  -5.55000000E-06  +2.52900000E-05  +6.07400000E-05
   +4.40300000E-05  +9.29600000E-05  +4.02600000E-05  -2.34210000E-04  -1.75370000E-04
   -7.23000000E-06  +6.61100000E-05  -4.72300000E-05  -4.51400000E-05  -3.56210000E-04
   +2.02000000E-04  +1.24000000E-06  +1.49690000E-04  -2.30600000E-05  -4.36700000E-05
   +2.75160000E-04  +1.92890000E-04  -1.07400000E-05  +2.36580000E-04  -9.90910000E-04
   +1.83129000E-03  +2.77819000E-03  +1.55600000E-03  -1.00563000E-03  +1.03316800E-02
   +1.22684800E-02  +5.60971000E-03  +6.23056300E-02  -7.10262900E-02  +3.03957300E-02
   +1.00641100E-02  +6.96954000E-03  -1.48136000E-03  -2.62079000E-03  +6.85907000E-03
   -7.38800000E-04  -8.55050400E-02  +6.50543500E-02  -2.21000000E-05  -9.17300000E-05
   -7.09700000E-05  -9.07800000E-05  +3.74410000E-04  +3.93000000E-06  +1.92100000E-05
   -6.09000000E-05  -5.98700000E-05  -9.84500000E-05  -1.51500000E-04  +5.50000000E-06
   +1.52270000E-04  +1.75580000E-04  +5.06400000E-05  -1.19100000E-05  +4.15700000E-05
   +4.67700000E-05  +1.17040000E-04  -3.24620000E-04  +4.82260000E-04  -9.02400000E-05
   +1.14200000E-05  +4.34900000E-05  -2.40460000E-04  -1.72240000E-04  +2.16600000E-05
   -1.21512000E-03  +1.55520000E-04  +1.12804000E-03  +3.79148000E-03  -1.18915000E-03
   -6.13656000E-03  -4.12834800E-02  +1.31837100E-02  -1.27844400E-02  -2.60295500E-02
   +1.53663900E-02  -1.32563480E-01  +3.31306700E-02  -8.99749000E-03  +2.08602200E-02
   +1.11625000E-03  +9.83930000E-04  -7.44772000E-03  -1.32177010E-01  -5.63516200E-02
   +5.20774820E-01  -4.13600000E-05  -5.11800000E-05  -8.24000000E-05  +1.08230000E-04
   +5.35530000E-04  -4.11400000E-05  -2.38800000E-05  -9.13200000E-05  -1.19060000E-04
   -1.02330000E-04  -1.98380000E-04  -7.27200000E-05  +4.79400000E-04  +3.50240000E-04
   +3.66400000E-05  -1.23880000E-04  +7.48500000E-05  +1.06990000E-04  +6.89700000E-04
   +2.55150000E-04  +2.27142000E-03  -2.29330000E-04  -8.83600000E-05  +1.15700000E-04
   -5.96210000E-04  -3.99200000E-04  +1.46500000E-05  -4.90498000E-03  +4.21291000E-03
   -1.65400000E-03  -3.11935700E-02  -1.06840400E-02  +2.96233400E-02  -1.70704470E-01
   +1.88408300E-02  +9.61111900E-02  -1.60362100E-02  +1.35498000E-03  +2.89792000E-03
   +2.19950000E-04  -6.37850000E-04  +2.90740000E-03  +2.01003000E-03  +3.53246000E-03
   -1.27404000E-03  +9.61643000E-03  +1.45783000E-03  -7.73629000E-03  +2.70047860E-01
   -6.19600000E-05  +5.16800000E-05  +3.32900000E-05  +1.21440000E-04  -2.11660000E-04
   -7.38400000E-05  +6.07700000E-05  +6.47300000E-05  -4.25700000E-05  +8.37000000E-06
   +4.56000000E-06  -5.11600000E-05  +6.55100000E-05  +3.03900000E-05  +1.74000000E-05
   +1.05200000E-05  +4.34100000E-05  -3.33200000E-05  +1.14744000E-03  +8.17270000E-04
   -2.82940000E-04  -2.31720000E-04  +3.19200000E-05  +8.52000000E-06  -5.28500000E-05
   -2.54100000E-05  -1.31800000E-05  -7.26000000E-06  -5.09210000E-04  +7.49262000E-03
   +2.26168500E-02  -2.89513000E-03  -1.82506400E-02  -2.56781100E-02  -6.35843700E-02
   +3.84292700E-02  -4.38878000E-03  -2.64419000E-03  -5.75016000E-03  -4.76061000E-03
   +4.12027000E-03  +3.95666000E-03  +4.20959000E-03  +3.12935000E-03  +2.44520000E-04
   -9.01880000E-04  -1.39090000E-04  +3.33577000E-03  +1.20733710E-01  +5.67476150E-01
   +7.76700000E-05  -5.78200000E-05  -1.24200000E-05  +1.43220000E-04  -2.43250000E-04
   +1.16820000E-04  +3.09400000E-05  +1.77700000E-05  +8.26900000E-05  +1.01200000E-05
   +6.83100000E-05  +5.37800000E-05  -2.19680000E-04  -1.47130000E-04  -2.44900000E-05
   +4.76200000E-05  -4.82600000E-05  -1.19800000E-05  -1.44920000E-04  +6.99260000E-04
   +3.40900000E-05  +2.10620000E-04  -7.60500000E-05  -1.16300000E-04  +2.58880000E-04
   +1.58370000E-04  +1.94300000E-05  +1.49990000E-03  +4.61970000E-04  +2.24680000E-04
   +1.89910000E-04  +3.44150000E-04  +4.85560000E-04  +8.61510800E-02  +6.84460000E-04
   -1.25867260E-01  +3.28528000E-02  +7.34575000E-03  -3.51327100E-02  -2.58393000E-03
   +2.28102000E-03  -5.98971000E-03  -3.30902000E-03  -1.85518000E-03  -4.00510000E-04
   +9.18506000E-03  -1.51720000E-03  -4.52334000E-03  -1.55247450E-01  -3.69939900E-02
   +1.87068950E-01  -4.99698000E-03  -2.34612000E-03  +1.65686000E-03  -1.01130000E-03
   -2.15061900E-02  -2.06374600E-02  -1.39143000E-03  -1.08526000E-03  -4.80930000E-04
   +1.09440000E-04  -5.33320000E-04  -6.76980000E-04  +3.93800000E-04  +2.25180000E-04
   +1.05730000E-04  +2.32110000E-04  -1.11082000E-03  -9.99720000E-04  -7.42490700E-02
   +9.24060000E-04  +1.59808000E-03  +3.86410000E-04  +3.84770000E-04  +2.07030000E-04
   -5.68950000E-04  -3.94800000E-04  +2.41500000E-05  -6.04946000E-03  +2.23564100E-02
   +2.02729000E-02  +2.52710000E-04  +1.41571000E-03  -1.63700000E-03  -1.54720000E-03
   +8.06850000E-04  -1.03676000E-03  -1.84390000E-04  -1.78090000E-04  +1.35591000E-03
   +6.58450000E-04  -3.34580000E-04  -2.69240000E-04  -5.06960000E-04  +1.83600000E-04
   +1.03880000E-04  -3.38260000E-04  +1.19940000E-04  -3.35950000E-04  -9.47280000E-04
   -2.42920000E-04  +6.46700000E-05  +5.87946070E-01  -2.81934000E-03  -4.38570000E-04
   +7.05270000E-04  -5.34042000E-03  -1.76818900E-02  -1.46319200E-02  +1.44540000E-04
   -4.57210000E-04  +6.31630000E-04  +5.60460000E-04  -4.09470000E-04  -5.43200000E-04
   -1.59840000E-04  +5.48500000E-05  -7.12200000E-05  +2.84740000E-04  -4.78740000E-04
   -6.89750000E-04  -3.61439000E-03  -1.25530300E-01  -4.97847000E-02  -7.68400000E-05
   +8.94019000E-03  +5.81985000E-03  +7.08200000E-05  +2.07200000E-05  -1.87800000E-05
   +1.02375200E-02  -2.15110400E-02  -1.48039800E-02  -2.10754000E-03  -7.51440000E-04
   +1.40702000E-03  +9.21440000E-04  -4.24590000E-04  +5.43750000E-04  +1.27990000E-04
   +1.61880000E-04  -4.99140000E-04  -3.21230000E-04  +1.76650000E-04  -1.69840000E-04
   +3.69200000E-04  -1.07500000E-04  -3.07430000E-04  -1.69600000E-05  -2.55800000E-05
   +1.13690000E-04  +3.06170000E-04  +2.23640000E-04  -4.60000000E-07  -8.80320000E-04
   +5.11878000E-01  +1.61253000E-03  +4.53400000E-04  +8.46900000E-05  -3.57603000E-03
   -1.30240000E-04  +1.70612000E-03  +6.61010000E-04  +1.15504000E-03  -1.25590000E-04
   +1.83520000E-04  +7.19400000E-05  -1.55460000E-04  -1.99340000E-04  -1.63070000E-04
   +2.19440000E-04  +3.27820000E-04  +2.55890000E-04  +1.89030000E-04  -2.32289000E-03
   -4.52920400E-02  -1.21977710E-01  +2.08570000E-04  -2.21692000E-02  -3.65269900E-02
   +3.25740000E-04  +2.17490000E-04  -5.51400000E-05  +5.56576000E-03  -2.71193000E-03
   +3.61245000E-03  -4.28860000E-04  -1.28920000E-04  -4.99920000E-04  -7.56290000E-04
   +8.10160000E-04  -6.60910000E-04  -3.82440000E-04  -3.90200000E-05  +1.51191000E-03
   +9.03040000E-04  -1.99830000E-04  -8.69760000E-04  -1.94220000E-03  +7.55190000E-04
   +9.05030000E-04  +4.71000000E-05  +3.07000000E-05  -2.68340000E-04  -3.09350000E-04
   +4.72700000E-05  -1.58300000E-05  -4.61079000E-03  -6.25279200E-02  +5.35656040E-01
   -2.75303000E-03  +2.05489000E-03  -1.40385000E-03  -2.40430000E-03  +4.58720000E-04
   -1.31441000E-03  +7.51280000E-04  +2.41360000E-04  -8.44420000E-04  +1.64390000E-04
   +6.01900000E-05  -3.17550000E-04  +1.04448000E-03  +2.48030000E-04  +1.17200000E-04
   +3.66240000E-04  +1.05964000E-03  -4.72970000E-04  -1.45427000E-03  -2.14650000E-04
   -4.18040000E-04  +3.57120000E-04  +4.47000000E-05  -1.13710000E-04  -4.78960000E-04
   -1.57350000E-04  -1.07560000E-04  +2.60220000E-03  -7.48743000E-03  +8.13437000E-03
   -2.75791000E-03  +9.18770000E-04  -2.28928000E-03  +4.41446000E-03  +2.77845000E-03
   +6.28898000E-03  +1.15502500E-02  -6.83145000E-03  -1.75576600E-02  -4.05106600E-02
   -2.49417200E-02  -4.21110000E-03  -1.63268200E-02  +3.57584200E-02  -1.42970000E-04
   -5.25345000E-03  +2.72099000E-03  +7.72200000E-04  -9.21050000E-04  -1.93964000E-03
   +1.34769000E-03  +6.27130000E-04  -3.04720000E-04  +6.09390000E-04  +1.23232790E-01
   +1.83454000E-03  -8.31330000E-04  +1.63936000E-03  +2.06117000E-03  -2.82329000E-03
   +7.43980000E-04  -4.21570000E-04  -1.17340000E-04  +6.14610000E-04  +3.70490000E-04
   +7.94420000E-04  +6.94100000E-05  +3.93570000E-04  -5.65450000E-04  -8.43440000E-04
   -4.78670000E-04  +4.14830000E-04  -3.08000000E-05  -3.08724000E-03  -4.09710000E-04
   -4.76300000E-05  +6.63120000E-04  -6.49900000E-05  -5.23700000E-05  +3.37000000E-04
   +5.48650000E-04  -2.45100000E-05  -1.39332300E-02  -3.11043000E-02  +2.98079700E-02
   +1.52263900E-02  -1.16525700E-02  -8.67297000E-03  +7.21076000E-03  +3.42882000E-02
   +1.43173200E-02  +1.22823900E-02  -5.54430000E-03  -2.50019900E-02  -4.68245900E-02
   +2.17833000E-03  -1.32992000E-03  +5.75528300E-02  +4.11025500E-02  -1.37694000E-02
   -4.82899000E-03  +1.44530000E-03  +1.11822000E-03  -3.11828000E-03  -5.05457000E-03
   +1.77543000E-03  +3.79850000E-04  -8.39800000E-05  -3.78140000E-04  -6.31965300E-02
   +2.26653090E-01  -2.37263000E-03  +1.00232000E-03  -2.17687000E-03  -1.82138000E-03
   +1.31646000E-03  -4.15220000E-04  +9.56500000E-04  +1.24110000E-04  -1.86660000E-04
   -7.27830000E-04  -6.16880000E-04  +2.97530000E-04  -8.43900000E-05  +2.46350000E-04
   +2.83190000E-04  +5.24330000E-04  +7.11620000E-04  -5.12490000E-04  +5.25440000E-04
   -1.29530000E-04  -5.28500000E-04  -1.51280000E-04  +6.16800000E-05  -1.36420000E-04
   +1.13500000E-05  -1.98000000E-06  +6.91900000E-05  +9.39560000E-03  +2.04596600E-02
   +3.18472000E-03  -1.62446000E-03  +1.67254000E-03  +2.04880000E-04  +8.03545000E-03
   +1.41984900E-02  +1.21388300E-02  +9.44623000E-03  -2.62204000E-03  -1.96482300E-02
   -2.43050800E-02  -7.69830000E-03  +9.51938000E-03  +2.25809500E-02  +2.30282100E-02
   -5.92204100E-02  -3.99934000E-03  +1.62291000E-03  +1.76539000E-03  -7.77850000E-04
   -2.34408000E-03  +9.14240000E-04  +2.45500000E-04  -5.10500000E-05  -6.59540000E-04
   +3.83181300E-02  -2.03675580E-01  +5.08864100E-01  +2.66100000E-05  +9.42970000E-04
   +1.88038000E-03  +5.68450000E-04  -2.58050000E-04  -5.60170000E-04  -1.03549000E-03
   +1.43660000E-04  +4.22080000E-04  +4.14386000E-03  +2.92044000E-03  -7.30180000E-04
   -3.11756800E-02  +1.06289400E-02  +2.94133300E-02  -2.96565000E-03  -5.40149000E-03
   -1.49113000E-03  -1.43120000E-04  -1.30120000E-04  -1.27980000E-04  +1.31440000E-04
   +5.72000000E-05  +4.72200000E-05  -2.33498550E-01  +6.68313700E-02  +2.17677670E-01
   +8.37400000E-05  +1.76780000E-04  -1.09650000E-04  -8.88200000E-05  +7.82800000E-05
   +7.26100000E-05  -2.71800000E-05  -2.13340000E-04  +7.12600000E-05  -1.52580000E-04
   +6.06400000E-05  -2.60600000E-05  +1.06910000E-04  +2.74000000E-06  -2.89300000E-05
   -1.85920000E-04  -1.79740000E-04  +7.11000000E-06  +1.80630000E-04  -4.78800000E-05
   +3.34600000E-05  +1.04750000E-04  +2.13100000E-05  -5.69600000E-05  +7.28000000E-05
   +5.32000000E-06  -2.00900000E-05  +2.28850000E-04  +7.70900000E-05  -3.86800000E-05
   +2.63731280E-01  -4.98630000E-04  +1.54144000E-03  +1.79430000E-04  +2.66840000E-04
   -2.67370000E-04  -5.01840000E-04  -1.17490000E-04  -6.76240000E-04  +1.42270000E-04
   -1.51695000E-03  +7.44140000E-04  +2.57600000E-03  -2.21924900E-02  +5.09846000E-03
   +2.20514900E-02  -4.24318000E-03  -2.21344000E-03  -1.12335000E-03  +9.40000000E-07
   -6.57500000E-05  -5.04500000E-05  +2.58000000E-05  +1.14600000E-05  +1.14000000E-06
   +1.02177580E-01  -7.59162400E-02  -1.35995010E-01  -7.32000000E-06  +3.06600000E-05
   -5.21200000E-05  -4.60200000E-05  +2.07200000E-05  +2.26200000E-05  -1.33000000E-06
   -8.71100000E-05  +3.77800000E-05  -4.04900000E-05  +1.82500000E-05  -4.03200000E-05
   +4.90000000E-07  -2.65300000E-05  -3.70000000E-06  +7.70000000E-07  +5.07200000E-05
   +6.82000000E-06  +6.42200000E-05  -2.28100000E-05  +2.06400000E-05  +4.18800000E-05
   -8.90000000E-07  -8.22000000E-06  +2.74000000E-05  +2.49400000E-05  +8.66000000E-06
   +3.00000000E-06  -9.85400000E-05  +3.24300000E-05  -7.46075900E-02  +7.27480800E-02
   +6.86020000E-04  -6.77340000E-04  +4.66800000E-04  -1.02610000E-04  -1.87670000E-04
   -4.57300000E-05  +9.57800000E-05  -4.01800000E-05  -8.51760000E-04  -4.84483000E-03
   -4.72660000E-04  +2.00558000E-03  -7.49000000E-04  -1.68230000E-04  -2.14587000E-03
   -4.60640000E-04  -3.22530000E-04  +2.20552000E-03  +1.12070000E-04  +4.95600000E-05
   +2.33600000E-05  -8.13800000E-05  -6.61800000E-05  -3.94800000E-05  +2.50105890E-01
   -1.12082640E-01  -2.76903200E-01  -4.91000000E-06  -4.71800000E-05  +6.45000000E-06
   +1.93200000E-05  -6.26000000E-06  -1.61900000E-05  -1.75200000E-05  +4.60300000E-05
   -3.36400000E-05  -7.38000000E-06  -2.95000000E-06  +6.55300000E-05  +3.85200000E-05
   +1.26400000E-05  -1.67300000E-05  -5.36400000E-05  -7.09800000E-05  +2.01900000E-05
   -2.11800000E-05  +9.84000000E-06  -1.86000000E-05  -1.80500000E-05  +8.66000000E-06
   -7.17000000E-06  -2.75300000E-05  +8.07000000E-06  +3.15600000E-05  +6.11300000E-05
   +8.06400000E-05  -4.27500000E-05  -2.45128440E-01  +1.13882010E-01  +2.75690170E-01
   -3.00770000E-04  -3.93940000E-04  -8.61220000E-04  -1.46514000E-03  -5.30360000E-03
   +7.08580000E-04  -1.41997100E-02  +7.42433000E-03  +1.80365300E-02  -1.94203860E-01
   +2.95629000E-02  +1.39905810E-01  +1.75307000E-03  -3.98536000E-03  -2.11333000E-03
   +2.44289000E-03  -1.78331000E-03  +5.89670000E-04  -3.14200000E-05  +5.87620000E-04
   +9.23070000E-04  -2.84680000E-04  -1.28380000E-04  -9.27300000E-05  +2.25040000E-03
   +2.02122000E-03  -2.53959000E-03  -6.86000000E-05  -2.11630000E-04  +1.35760000E-04
   +3.37900000E-05  -1.08500000E-05  -8.49400000E-05  -2.10400000E-05  +1.42790000E-04
   -7.63000000E-05  +3.21700000E-05  -2.65100000E-05  +1.24910000E-04  +3.81200000E-05
   +1.58900000E-05  -3.59800000E-05  -6.95800000E-05  -5.51200000E-05  +5.63700000E-05
   -8.52600000E-05  +2.71900000E-05  -4.00400000E-05  -6.65400000E-05  +7.87000000E-06
   +1.40000000E-05  -5.35100000E-05  +1.07390000E-04  +3.63100000E-05  +4.00300000E-05
   +1.04170000E-04  -7.52200000E-05  -1.21000000E-06  +6.88390000E-04  +1.03636000E-03
   +2.04438050E-01  -5.89220000E-04  -1.36055000E-03  +8.21200000E-05  -4.75478000E-03
   +6.30920000E-04  -2.32262000E-03  -1.32237800E-02  +6.81904000E-03  +1.37869100E-02
   +2.96478100E-02  -5.98154800E-02  -4.66577100E-02  +1.78486900E-02  +6.70180000E-04
   -1.55978200E-02  -2.18261000E-03  -1.46425000E-03  -5.16662000E-03  -4.90420000E-04
   +5.57820000E-04  +3.69460000E-04  -6.81400000E-05  +2.88200000E-05  -7.11100000E-05
   +2.53197000E-03  +2.52560000E-04  +2.40828000E-03  -1.88380000E-04  -2.41810000E-04
   +6.74000000E-05  +1.81900000E-05  -2.14900000E-05  -3.66500000E-05  -2.91000000E-06
   +1.26250000E-04  -1.64300000E-05  +2.01600000E-05  -1.79100000E-05  +3.69400000E-05
   -7.00000000E-08  -3.86000000E-06  -4.74000000E-06  +8.61000000E-06  +1.40900000E-05
   -9.74000000E-06  -3.63400000E-05  +8.53000000E-06  -9.58000000E-06  -2.35000000E-05
   -3.83000000E-06  +1.78600000E-05  +6.03500000E-05  +4.29600000E-05  +6.34900000E-05
   -3.00900000E-05  +9.75000000E-06  +4.91700000E-05  -1.31999000E-03  -6.21950000E-04
   -2.35040000E-04  -2.99942000E-02  +5.56902200E-02  -1.13487000E-03  -1.10480000E-04
   -3.10560000E-04  +1.02388000E-03  -1.85824000E-03  +4.21131000E-03  -1.07123000E-03
   -3.73720000E-04  +2.26395000E-03  +1.39903180E-01  -4.66352400E-02  -1.72462640E-01
   +1.84479800E-02  -5.59620000E-04  -9.13288000E-03  +1.46400000E-05  -5.56766000E-03
   +4.27840000E-04  -9.95000000E-06  -2.72910000E-04  +1.98880000E-04  -5.60000000E-06
   -8.13400000E-05  +2.68100000E-05  -2.01297000E-03  +2.77782000E-03  -1.81520000E-04
   +1.33880000E-04  +1.39510000E-04  -4.90500000E-05  -3.11000000E-05  +3.58200000E-05
   +3.69700000E-05  -6.44000000E-06  -9.60100000E-05  +3.12100000E-05  -5.52200000E-05
   +2.35400000E-05  -2.54100000E-05  +3.11000000E-05  +1.11000000E-06  -1.30300000E-05
   -5.53600000E-05  -4.07400000E-05  +1.97900000E-05  +6.95400000E-05  -1.76700000E-05
   +1.33200000E-05  +3.98100000E-05  +7.77000000E-06  -2.42900000E-05  +1.32600000E-05
   +3.53900000E-05  -5.56900000E-05  +5.54200000E-05  +3.29600000E-05  -3.06500000E-05
   -8.77130000E-04  -1.60562000E-03  -3.40620000E-04  -1.53841040E-01  +5.18418000E-02
   +1.77557860E-01  -2.03964000E-03  -7.55530000E-04  +5.36102000E-03  +7.48112000E-03
   +1.70265400E-02  +1.38295200E-02  -5.66053700E-02  -1.88782100E-02  -4.50867000E-03
   +1.67888000E-03  -2.00817800E-02  -1.77108000E-02  -2.22898000E-03  -4.35092000E-03
   +2.65815000E-03  -1.30050000E-03  +6.92000000E-06  +9.75000000E-05  -1.06120000E-04
   +1.49258000E-03  -1.40582000E-03  +3.97900000E-04  -1.47300000E-05  -9.21400000E-05
   -4.11000000E-04  -1.30274000E-03  -8.87270000E-04  -2.85820000E-04  -2.01480000E-04
   -9.16800000E-05  -7.60200000E-05  +6.95000000E-06  -4.53000000E-05  -2.72300000E-05
   -1.31860000E-04  -5.16000000E-06  -7.90000000E-05  +1.36100000E-05  +8.89200000E-05
   +5.95900000E-05  -8.34700000E-05  -1.09300000E-04  -1.85800000E-05  +1.50560000E-04
   +2.80540000E-04  +8.80600000E-05  -2.20200000E-05  -4.30000000E-06  +5.29700000E-05
   +2.30400000E-05  -3.23400000E-05  -2.76135000E-03  -1.52334000E-03  +1.17716000E-03
   +1.57700000E-05  -1.60750000E-04  -1.14520000E-04  +1.91080000E-04  +3.50100000E-05
   -1.29040000E-04  -1.06200000E-04  +1.58734000E-03  -1.28385000E-03  +5.84425300E-02
   -6.76280000E-04  +3.33298000E-03  -2.85547000E-03  -7.78990000E-04  -2.69720000E-04
   -3.78637000E-03  -1.84970500E-02  -2.09720070E-01  -1.48374610E-01  +3.93480000E-04
   -1.00387500E-02  -1.26450800E-02  -4.61492000E-03  +2.45713000E-03  -1.48919000E-03
   +1.09720000E-04  -1.07730000E-04  +9.46250000E-04  +4.97880000E-04  -2.29575000E-03
   +1.38297000E-03  -3.81760000E-04  -2.22510000E-04  +1.11830000E-04  -4.42090000E-04
   -9.46920000E-04  -6.70170000E-04  +3.88020000E-04  +3.90310000E-04  -3.07380000E-04
   +3.93700000E-05  -3.23100000E-05  +1.40760000E-04  +7.23200000E-05  -5.46400000E-05
   +7.41400000E-05  +6.23300000E-05  +1.53700000E-05  -2.14560000E-04  -1.42330000E-04
   +3.82800000E-05  +1.38350000E-04  +2.11660000E-04  -9.04000000E-06  -2.40880000E-04
   -1.78800000E-05  -4.44000000E-06  +4.30400000E-05  +2.01900000E-05  -2.63800000E-05
   +1.74300000E-05  -2.94436000E-03  -9.36320000E-04  +5.10640000E-04  -1.50340000E-04
   +1.38600000E-05  +1.50320000E-04  +2.02620000E-04  +8.28000000E-06  -8.12800000E-05
   +1.19202000E-03  -9.35540000E-04  +2.11239000E-03  +2.72240900E-02  +2.21108650E-01
   +5.57167000E-03  -2.64580000E-03  +6.41290000E-04  -2.99818000E-03  -1.62024600E-02
   -8.73384000E-03  -4.08367000E-03  -1.47839550E-01  -1.73371170E-01  +1.38126000E-03
   +1.28891000E-03  +3.49596000E-03  +2.29861000E-03  -1.62977000E-03  +4.36729000E-03
   +2.51260000E-04  +1.06628000E-03  -3.82650000E-04  -2.41307000E-03  +6.39600000E-04
   -1.87400000E-03  +6.39910000E-04  +2.18000000E-04  -2.70000000E-07  -9.27800000E-05
   -1.05340000E-04  +5.09800000E-05  -3.33560000E-04  -9.72800000E-05  +3.08390000E-04
   +1.97900000E-05  +3.17600000E-05  -8.51800000E-05  -3.68500000E-05  +1.17610000E-04
   -2.03600000E-05  -3.51300000E-05  -8.21000000E-06  +7.87400000E-05  +1.00680000E-04
   +4.00900000E-05  -1.74500000E-05  -1.83850000E-04  -2.24080000E-04  -1.44000000E-05
   +4.99000000E-06  +7.55000000E-06  -1.42500000E-05  -1.58800000E-05  +9.69000000E-06
   +1.30000000E-07  -1.69770000E-04  -6.50840000E-04  +4.70410000E-04  +1.82780000E-04
   +1.29810000E-04  +4.55500000E-05  +2.38600000E-05  +2.98900000E-05  -3.84000000E-05
   -1.64251000E-03  +1.86575000E-03  -1.21334000E-03  +2.96416000E-03  +1.63484050E-01
   +1.77180190E-01  -2.05121760E-01  +3.76297300E-02  +1.37884330E-01  +5.89499000E-03
   -6.47870000E-04  -1.59259000E-03  +2.01830000E-03  -2.01843000E-03  +6.55030000E-04
   -2.19800000E-04  -3.25410000E-04  -8.50620000E-04  -5.41320000E-04  -5.12122000E-03
   +1.00266000E-03  -1.42457000E-02  +6.44985000E-03  +1.80157800E-02  -1.12325000E-03
   +3.06930000E-04  -8.53100000E-04  -2.02440000E-04  -3.63040000E-04  +2.17470000E-04
   -1.08911000E-03  +2.86970000E-04  +9.95990000E-04  -5.69100000E-05  -4.64230000E-04
   -2.07430000E-04  -4.19570000E-04  +1.42210000E-04  +5.97400000E-05  -2.39300000E-05
   -7.64000000E-05  +1.69300000E-04  -7.64900000E-05  +2.68600000E-05  -1.33680000E-04
   -8.43000000E-06  -2.75800000E-05  +1.63300000E-05  +7.35400000E-05  +2.57530000E-04
   -1.39240000E-04  +1.47870000E-04  -4.67800000E-05  +4.17700000E-05  +7.15600000E-05
   +1.34400000E-05  -4.85500000E-05  +4.49000000E-05  +1.41440000E-04  -1.36160000E-04
   -1.67270000E-04  -1.01480000E-04  -9.86000000E-05  -3.12200000E-04  -1.26900000E-04
   -4.46400000E-05  -1.73470000E-04  +2.03000000E-04  -1.34280000E-04  +2.20720000E-04
   -1.36710000E-04  -2.35130000E-04  +2.15095210E-01  +3.86718200E-02  -6.58798300E-02
   -4.73068900E-02  +1.84403300E-02  +7.73400000E-04  -1.49440900E-02  -2.45033000E-03
   -1.46960000E-03  -5.34500000E-03  -3.78190000E-04  -9.70280000E-04  +2.97690000E-04
   -5.05656000E-03  +1.04324000E-03  -3.26905000E-03  -1.50943600E-02  +7.53198000E-03
   +1.24710600E-02  +1.36998000E-03  -6.06580000E-04  +1.07542000E-03  -1.63940000E-04
   -8.09470000E-04  -3.79430000E-04  -6.53940000E-04  +3.01870000E-04  +7.60980000E-04
   -3.32600000E-05  -4.81500000E-05  -1.44220000E-04  -3.57620000E-04  +8.81700000E-05
   +5.27200000E-05  -8.24400000E-05  -3.93070000E-04  +4.97900000E-05  +3.92700000E-05
   -2.32800000E-05  -4.28500000E-05  -9.90900000E-05  -1.33230000E-04  +5.23400000E-05
   +3.58110000E-04  +6.58150000E-04  -1.99660000E-04  +5.78100000E-05  -3.33000000E-05
   +4.75600000E-05  +8.28500000E-05  -2.19100000E-05  +2.76100000E-05  +9.11800000E-05
   -1.59800000E-05  +1.39700000E-04  -2.16050000E-04  -4.98080000E-04  -2.39370000E-04
   -2.08550000E-04  -2.47700000E-04  +1.38870000E-04  +2.44160000E-04  -2.01180000E-04
   +2.85620000E-04  +9.77120000E-04  -1.24870000E-04  -8.50030000E-04  -3.64585900E-02
   +6.27476900E-02  +1.36952660E-01  -4.59587600E-02  -1.68175550E-01  +1.59184700E-02
   -3.29666000E-03  -8.70590000E-03  +5.99280000E-04  -5.83134000E-03  +5.91350000E-04
   -1.03170000E-03  +2.03940000E-04  -1.91900000E-04  +1.42775000E-03  -3.14880000E-03
   +4.92629000E-03  -5.19410000E-04  -1.49154000E-03  +3.58897000E-03  +1.29880000E-04
   +1.76644000E-03  -1.51121000E-03  +9.17100000E-05  +1.80590000E-04  -7.85500000E-05
   +2.67300000E-04  +1.27560000E-04  -5.58700000E-05  +3.73000000E-05  +1.34410000E-04
   +1.02310000E-04  -3.80780000E-04  +3.81080000E-04  +3.34170000E-04  -2.87100000E-05
   -7.24800000E-05  +2.59360000E-04  -1.84230000E-04  +5.04300000E-05  -1.81290000E-04
   +8.59100000E-05  +7.39900000E-05  +2.34400000E-05  -2.34080000E-04  -2.56730000E-04
   -3.34110000E-04  +2.32480000E-04  -5.76100000E-05  +6.01600000E-05  +1.18750000E-04
   +4.36700000E-05  -8.96300000E-05  -1.83140000E-04  +5.90600000E-05  -2.18300000E-05
   +8.49300000E-05  +2.90200000E-05  +3.77350000E-04  -1.25610000E-04  +8.74300000E-05
   -6.40400000E-05  -1.34010000E-04  +3.15550000E-04  -3.34870000E-04  +8.01290000E-04
   -6.85300000E-05  -6.55610000E-04  -1.52396680E-01  +5.35238500E-02  +1.71704160E-01
   +2.62271000E-03  -1.94590600E-02  -1.75540300E-02  -2.23434000E-03  -4.66573000E-03
   +2.57209000E-03  -1.55444000E-03  -1.32100000E-04  +2.52610000E-04  -2.19974000E-03
   -7.12420000E-04  +4.54938000E-03  +7.02836000E-03  +1.79429800E-02  +1.48846600E-02
   -5.72241900E-02  -2.47759900E-02  -7.95218000E-03  +5.35470000E-04  -7.67600000E-04
   -8.09460000E-04  +4.59000000E-05  +7.01900000E-05  -1.36580000E-04  +8.66100000E-04
   +8.82560000E-04  -2.03911000E-03  +5.23400000E-05  -1.66900000E-05  +6.52600000E-05
   +8.33800000E-05  -4.87300000E-05  -4.17700000E-05  +2.81000000E-06  +2.31310000E-04
   +2.13800000E-05  -3.93900000E-05  +6.39000000E-06  +8.07000000E-06  +6.21700000E-05
   +4.51300000E-05  -7.48000000E-06  -1.40310000E-04  -2.20320000E-04  -1.60900000E-05
   +1.46700000E-05  +3.23000000E-06  -1.49000000E-06  -1.00200000E-05  +4.00000000E-08
   -6.90000000E-07  -3.85070000E-04  -1.17410000E-04  +9.48000000E-05  +9.89300000E-05
   +2.76900000E-04  +1.40040000E-04  +1.36610000E-04  +4.62600000E-05  -4.03630000E-04
   +1.44210000E-04  +9.50950000E-04  +8.31510000E-04  -8.74900000E-05  +1.77480000E-04
   -2.71570000E-04  -8.34800000E-05  +1.75905000E-03  -1.57737000E-03  +5.23437400E-02
   +5.76530000E-04  -9.39614000E-03  -1.17110800E-02  -4.80796000E-03  +2.59706000E-03
   -1.62805000E-03  +2.09590000E-04  +2.48400000E-05  +7.52030000E-04  -3.67440000E-04
   +2.63271000E-03  -2.19659000E-03  -3.76925000E-03  -1.36239000E-03  -3.23527000E-03
   -2.34793800E-02  -2.16073230E-01  -1.49224990E-01  +2.67460000E-04  -2.36620000E-04
   -7.35780000E-04  -6.49500000E-05  -1.32600000E-05  -3.54000000E-06  +1.22323000E-03
   -5.23090000E-04  +1.74927000E-03  +1.30940000E-04  -7.49000000E-05  +8.06000000E-05
   +3.76100000E-05  -1.47800000E-05  -2.58200000E-05  +1.25200000E-05  +1.20530000E-04
   -1.21700000E-05  +4.16800000E-05  -2.33400000E-05  -5.20000000E-07  -2.90400000E-05
   +3.96000000E-06  +7.51000000E-06  +3.53600000E-05  +4.62500000E-05  -1.86400000E-05
   -5.41100000E-05  +1.54400000E-05  -6.90000000E-06  -3.71800000E-05  -9.65000000E-06
   +3.06200000E-05  -2.48410000E-04  -1.25930000E-04  +1.35870000E-04  -8.77300000E-05
   -2.18500000E-05  +1.89600000E-05  +1.06430000E-04  -1.40420000E-04  +2.66430000E-04
   -1.61600000E-05  -8.59000000E-05  -5.66700000E-05  +2.10860000E-04  -3.17180000E-04
   +2.28910000E-04  +1.29383000E-03  -1.19119000E-03  +2.46218000E-03  +2.87840400E-02
   +2.24396150E-01  +1.01963000E-03  +2.27688000E-03  +4.37609000E-03  +2.38618000E-03
   -2.19599000E-03  +4.39486000E-03  +3.16320000E-04  +1.01169000E-03  -2.31530000E-04
   +4.98325000E-03  -1.81220000E-03  +2.51370000E-04  -4.59793000E-03  -1.81926200E-02
   -8.59587000E-03  -7.41319000E-03  -1.48308540E-01  -1.66421160E-01  +2.72080000E-04
   -1.76900000E-05  +2.01110000E-04  -1.17700000E-05  +3.46000000E-06  -7.55500000E-05
   -1.85351000E-03  +1.93300000E-03  -2.99480000E-04  -1.25250000E-04  -1.63400000E-05
   +7.30000000E-06  +6.06300000E-05  -4.73700000E-05  -4.35300000E-05  -1.25200000E-05
   +1.05320000E-04  -1.79400000E-05  -4.04500000E-05  +1.25100000E-05  +7.02500000E-05
   +9.21400000E-05  +4.38500000E-05  -1.93700000E-05  -1.47370000E-04  -2.84430000E-04
   +1.17200000E-05  +9.21000000E-06  +2.53000000E-06  -1.43000000E-05  -8.97000000E-06
   +1.01400000E-05  -1.81500000E-05  -4.01700000E-05  +5.28500000E-05  -2.37500000E-05
   +1.99910000E-04  +3.49600000E-04  +4.98600000E-05  -3.42000000E-04  +3.12840000E-04
   -1.27100000E-05  -1.20470000E-04  -7.21850000E-04  -6.24820000E-04  -2.56460000E-04
   +2.53570000E-04  -3.23370000E-04  -1.76187000E-03  +2.09119000E-03  -1.73632000E-03
   +7.52661000E-03  +1.63186470E-01  +1.69163040E-01  +2.29900000E-04  +1.84570000E-04
   +1.45940000E-04  +8.23730000E-04  -1.11300000E-03  +2.23930000E-04  +2.46860000E-04
   +2.03500000E-04  +6.73100000E-05  +4.33100000E-05  +3.91800000E-05  -7.31800000E-05
   -3.10400000E-05  -4.05500000E-05  -6.76200000E-05  -1.14780000E-04  +3.08700000E-05
   -5.17500000E-05  -7.10250000E-04  -9.67040000E-04  +8.45300000E-04  -2.33939250E-01
   +1.23881750E-01  -1.91065200E-02  +6.65800000E-05  +2.48600000E-05  +1.57500000E-05
   +4.68500000E-04  -4.46000000E-05  +1.16110000E-04  -6.54600000E-05  +7.61100000E-05
   +3.14980000E-04  +2.42070000E-04  +1.03910000E-04  -3.08110000E-04  +2.99200000E-05
   +3.02600000E-05  +2.10180000E-04  +6.38000000E-05  -2.00300000E-05  -7.20500000E-05
   +2.95900000E-05  -3.14310000E-04  +4.83230000E-04  -1.61930000E-04  +2.38800000E-05
   -1.03390000E-04  -1.41890000E-04  +2.86600000E-05  +8.75000000E-06  -1.66500000E-05
   -1.76760000E-04  +4.53930000E-04  +1.42020000E-04  +2.76330000E-04  -7.85400000E-05
   -1.12700000E-05  -3.47000000E-06  +6.80000000E-07  +2.41000000E-05  +1.49700000E-05
   -4.99000000E-06  +2.45400000E-05  -1.20000000E-06  -4.24000000E-06  +3.81100000E-05
   -6.35700000E-05  +1.45300000E-05  -3.01000000E-06  +9.45000000E-06  -2.45000000E-06
   +2.50932510E-01  +3.16200000E-05  -3.61460000E-04  -5.44590000E-04  +1.04023000E-03
   +5.05410000E-04  -2.05260000E-04  -4.22450000E-04  +6.44900000E-05  +6.85900000E-05
   -4.03900000E-05  +6.48400000E-05  +1.10930000E-04  -1.29130000E-04  -1.76470000E-04
   -1.46300000E-05  -1.30790000E-04  +1.33600000E-05  +1.12000000E-06  +1.23396400E-02
   -1.02269100E-02  +1.34270000E-03  +1.22431300E-01  -1.27871910E-01  +1.16608000E-02
   +1.52740000E-04  +1.47260000E-04  -9.15000000E-06  -8.27170000E-04  -6.01970000E-04
   +2.62053000E-03  -4.03140000E-04  +3.11830000E-04  +3.02010000E-04  -1.97700000E-05
   -1.63060000E-04  +1.34500000E-04  -8.51600000E-05  +6.43200000E-05  -6.33000000E-05
   -7.00500000E-05  -1.65530000E-04  +3.06490000E-04  +1.15008000E-03  +8.68000000E-05
   -6.47300000E-05  +1.75140000E-04  -7.53200000E-05  +4.41000000E-05  +1.44780000E-04
   +2.11600000E-05  -5.53600000E-05  -4.52020000E-04  +3.62570000E-04  -1.20528000E-03
   -1.84300000E-04  -1.11650000E-04  -1.48000000E-05  -2.37200000E-05  -2.04200000E-05
   +2.50600000E-05  +7.86000000E-06  -8.41000000E-06  +1.75000000E-06  +2.69300000E-05
   -3.45000000E-06  +2.61600000E-05  +4.86300000E-05  +1.34940000E-04  +1.70680000E-04
   +1.40600000E-05  -1.42400000E-05  +1.65400000E-05  -1.34984080E-01  +1.36935930E-01
   +3.87470000E-04  +5.30800000E-05  -2.27800000E-05  -1.05108000E-03  -4.83810000E-04
   +7.21430000E-04  +6.88800000E-05  -1.59890000E-04  +1.45540000E-04  +1.31530000E-04
   +6.64400000E-05  -8.14700000E-05  +1.72690000E-04  +1.36900000E-05  -1.54910000E-04
   -3.53220000E-04  +4.55800000E-05  +1.00120000E-04  -2.44929600E-02  +1.65466300E-02
   -4.59656000E-03  -1.72479100E-02  +1.06361900E-02  -4.74458700E-02  -2.09770000E-04
   -1.46740000E-04  +2.24600000E-05  +1.48368000E-03  +1.89933000E-03  -5.12971000E-03
   +1.07113000E-03  -3.30520000E-04  -6.59580000E-04  -1.87270000E-04  +3.87620000E-04
   +2.55210000E-04  +1.84270000E-04  -1.19760000E-04  -2.79500000E-05  +7.15000000E-05
   +1.14080000E-04  -3.42930000E-04  -1.58499000E-03  +8.37640000E-04  +1.26310000E-04
   -1.01960000E-04  +3.61200000E-05  +4.78800000E-05  -5.40600000E-05  -4.72600000E-05
   +7.86800000E-05  -1.28537000E-03  +1.12935000E-03  +1.12801000E-03  +6.90500000E-05
   +1.77650000E-04  -2.38400000E-05  +2.50700000E-05  +2.49000000E-06  -5.90000000E-06
   -1.16700000E-05  +1.10500000E-05  +6.54000000E-06  +2.37600000E-05  +2.20000000E-07
   -7.17800000E-05  +3.15600000E-05  -1.47400000E-05  +5.82500000E-05  +1.01400000E-05
   -1.26100000E-05  -2.80000000E-06  +1.95959700E-02  -1.53716600E-02  +5.42594900E-02
   +1.83370000E-04  +3.55000000E-04  +3.73860000E-04  +5.66740000E-04  -5.13360000E-04
   +9.43880000E-04  +5.64000000E-04  -2.35860000E-04  -1.91660000E-04  -1.23940000E-04
   -1.16250000E-04  -1.02730000E-04  +2.77760000E-04  +2.44590000E-04  +2.65000000E-05
   -1.19400000E-04  +3.00200000E-05  +4.15800000E-05  -8.03960000E-04  +4.73750000E-04
   -2.10420000E-04  -2.13803300E-01  -1.26915370E-01  +1.71442900E-02  -3.41460000E-04
   -2.45100000E-04  +1.94800000E-05  +1.74730000E-04  +3.28220000E-04  -3.40310000E-04
   -5.53080000E-04  +1.08582000E-03  +2.99170000E-04  +1.51840000E-04  -7.76200000E-05
   -1.08930000E-04  -8.98200000E-05  +7.43300000E-05  -8.74000000E-06  +4.06600000E-05
   +2.24100000E-05  +6.30700000E-05  +4.26500000E-05  -3.87870000E-04  +1.06120000E-04
   +6.11400000E-05  -4.22100000E-05  -1.19100000E-05  +5.82400000E-05  +1.29300000E-05
   -4.18400000E-05  +1.30510000E-04  +1.86770000E-04  -4.68590000E-04  +1.40020000E-04
   +1.31590000E-04  +5.32000000E-06  +4.65100000E-05  +1.57100000E-05  -2.38300000E-05
   -4.54800000E-05  -7.12000000E-06  +4.16000000E-06  -3.42900000E-05  +5.31500000E-05
   +4.05200000E-05  -1.21900000E-05  -1.32000000E-05  -3.54900000E-05  -2.53600000E-05
   -1.41900000E-05  -1.59900000E-05  -1.93023200E-02  -1.68985700E-02  +1.84870000E-03
   +2.31991120E-01  -3.50520000E-04  -1.81560000E-04  +2.34440000E-04  -6.28000000E-05
   -5.42030000E-04  +3.21081000E-03  +3.99210000E-04  -4.56680000E-04  -2.69270000E-04
   -5.92700000E-04  -3.46260000E-04  -2.03780000E-04  +7.86700000E-05  +4.75360000E-04
   +4.52460000E-04  +3.59600000E-04  +1.27920000E-04  +3.99200000E-05  -1.18117500E-02
   -9.31121000E-03  -1.92880000E-04  -1.25793940E-01  -1.43651670E-01  +1.28472000E-02
   -3.74630000E-04  -2.79320000E-04  -2.38200000E-05  -6.97040000E-04  +5.33440000E-04
   -4.68120000E-04  -1.89300000E-05  -1.39560000E-04  +7.58020000E-04  +2.97070000E-04
   -3.54500000E-05  -4.06960000E-04  -8.68100000E-05  +7.16200000E-05  +1.84380000E-04
   +1.01760000E-04  +5.61700000E-05  -6.02800000E-05  -1.14320000E-04  -5.52530000E-04
   +3.33000000E-04  -9.78500000E-05  +1.07800000E-05  -1.28450000E-04  -8.93000000E-05
   +9.36800000E-05  -7.14700000E-05  +2.91210000E-04  +3.44120000E-04  -1.28596000E-03
   +3.04220000E-04  +4.29240000E-04  -8.66000000E-05  +4.99500000E-05  +2.63800000E-05
   -2.80900000E-05  -1.06750000E-04  +1.20000000E-07  -3.32100000E-05  +3.96700000E-05
   +1.06700000E-05  +1.10520000E-04  -1.11910000E-04  +3.12510000E-04  -1.14310000E-04
   -7.31000000E-06  -3.92900000E-05  -7.21000000E-06  +1.44563600E-02  +1.20983400E-02
   -1.77730000E-03  +1.38956600E-01  +1.53896920E-01  +1.90690000E-04  -4.64490000E-04
   -3.40000000E-07  -9.30500000E-04  +1.64830000E-03  -4.92764000E-03  +5.46260000E-04
   +7.50200000E-04  +1.33860000E-04  +3.25150000E-04  -9.57600000E-05  +3.64430000E-04
   -3.01300000E-04  -2.33730000E-04  -8.76700000E-05  +3.62610000E-04  -7.11200000E-05
   +1.01780000E-04  +2.36149200E-02  +1.69278400E-02  -3.15640000E-03  +1.65343400E-02
   +1.15598700E-02  -4.95531700E-02  +4.72540000E-04  +3.92760000E-04  -2.71500000E-05
   +5.46730000E-04  -7.89900000E-04  +7.64030000E-04  -5.92260000E-04  +1.52470000E-04
   +5.92590000E-04  -1.00700000E-05  -5.08900000E-05  +6.10000000E-07  -6.79900000E-05
   +3.90400000E-05  +3.30800000E-05  -2.28200000E-05  -5.04300000E-05  -2.66300000E-05
   +1.12090000E-04  +9.38000000E-05  -2.88020000E-04  +5.69600000E-05  -3.49400000E-05
   -1.22800000E-05  +1.22100000E-05  +2.43400000E-05  -6.12200000E-05  +1.16057000E-03
   +1.09139000E-03  +1.17391000E-03  -1.52900000E-04  -2.98390000E-04  +6.31100000E-05
   -5.25400000E-05  +2.24000000E-06  +3.38900000E-05  +1.03300000E-04  +3.28700000E-05
   -4.45000000E-06  -6.24000000E-05  +1.19870000E-04  -1.84540000E-04  -2.69310000E-04
   +3.53430000E-04  +1.23000000E-06  +3.43600000E-05  +3.06900000E-05  +1.78700000E-05
   -1.74533000E-03  -1.79772000E-03  -7.87450000E-04  -1.91808800E-02  -1.55332500E-02
   +5.33406000E-02  -2.32260000E-04  -1.97470000E-04  +2.13350000E-04  +1.15590000E-04
   +7.45530000E-04  +3.45170000E-04  -2.23840000E-04  -1.00060000E-04  +8.46200000E-05
   +1.86660000E-04  +1.08740000E-04  +3.89500000E-05  -1.74700000E-05  -1.42200000E-04
   -1.01180000E-04  -2.71220000E-04  -7.08200000E-05  -5.47600000E-05  -1.91663000E-03
   -1.50700000E-04  +1.61180000E-04  -4.69775600E-02  +1.67725000E-03  +2.41505000E-03
   +6.34800000E-05  +4.57600000E-05  -1.20500000E-05  +2.53450000E-04  -3.52820000E-04
   -2.58980000E-04  -2.57240000E-04  +8.25800000E-05  -9.42630000E-04  -1.15990000E-04
   +5.51500000E-05  +2.94350000E-04  +4.35600000E-05  -6.57400000E-05  -1.70330000E-04
   -6.72200000E-05  -1.56100000E-05  +6.98200000E-05  +1.30230000E-04  +2.79430000E-04
   -1.50100000E-05  +9.20300000E-05  -7.53000000E-06  +9.71200000E-05  +1.16340000E-04
   -5.12200000E-05  +5.80500000E-05  -1.88840000E-04  -3.17900000E-05  +4.14600000E-05
   -1.68550000E-04  -1.75500000E-04  +6.62000000E-06  -1.03400000E-05  -1.25600000E-05
   +8.78000000E-06  +3.94000000E-06  +5.83000000E-06  -1.07600000E-05  +2.97100000E-05
   -1.79000000E-06  -5.75000000E-05  +2.30010000E-04  -5.56730000E-04  +2.22980000E-04
   +1.31000000E-05  -2.06200000E-05  +2.10700000E-05  +2.75130000E-04  +1.77841700E-02
   +2.09293700E-02  +9.35620000E-04  -1.65117600E-02  -1.99056400E-02  +4.89702100E-02
   -5.45240000E-04  -5.80280000E-04  +9.26790000E-04  +1.53660000E-04  +7.49760000E-04
   -2.82530000E-04  -4.15100000E-05  +2.93900000E-05  -1.15800000E-04  +5.97700000E-05
   +6.25300000E-05  +9.54700000E-05  -6.68700000E-05  -1.97100000E-05  -1.04450000E-04
   +1.10730000E-04  -9.85100000E-05  -6.10000000E-05  -4.78230000E-04  +1.00036700E-02
   +1.12064900E-02  +1.63349000E-03  -1.66874340E-01  -1.34932310E-01  +1.36060000E-04
   +8.53300000E-05  -6.75000000E-06  +5.22500000E-05  +5.70560000E-04  -3.31960000E-04
   +1.17159000E-03  -7.55200000E-05  -2.79890000E-04  -1.83010000E-04  +1.19410000E-04
   +2.08150000E-04  +1.34850000E-04  -6.67300000E-05  -6.61100000E-05  -4.35000000E-05
   +2.35800000E-05  +9.60000000E-06  -2.55660000E-04  +3.55800000E-05  -7.35600000E-05
   -4.23300000E-05  +1.64600000E-05  +5.15200000E-05  -1.57000000E-06  -3.46200000E-05
   +7.59600000E-05  -2.58500000E-05  -7.73240000E-04  +2.14152000E-03  -3.27500000E-05
   -1.43300000E-05  +2.85800000E-05  -1.30400000E-05  -3.24000000E-06  +2.71000000E-06
   +2.03400000E-05  -2.33000000E-06  +8.50000000E-07  +1.24000000E-05  -8.55000000E-06
   +1.57100000E-05  -5.28810000E-04  -1.43875000E-03  +6.60480000E-04  +1.38200000E-05
   -8.51000000E-06  +2.96900000E-05  -1.11465000E-03  -1.14744200E-02  -1.23757400E-02
   +1.97655000E-03  -1.21499500E-02  -1.32488200E-02  -2.73641000E-03  +1.81289430E-01
   +2.62550000E-04  -8.76210000E-04  -2.00390000E-04  -1.54409000E-03  -8.34460000E-04
   +8.16740000E-04  +7.93940000E-04  +5.02800000E-05  -2.37190000E-04  -4.75270000E-04
   -3.75430000E-04  -3.50000000E-05  -2.09540000E-04  +3.23950000E-04  +3.70010000E-04
   +4.62170000E-04  +3.60860000E-04  +2.54160000E-04  +6.98290000E-04  -2.01235100E-02
   -2.01330200E-02  +3.09102000E-03  -1.32446060E-01  -1.96879060E-01  -6.35100000E-05
   -1.25400000E-05  +4.57000000E-06  +1.07087000E-03  -8.41230000E-04  +1.10580000E-03
   +2.61750000E-04  -1.49500000E-05  -5.33000000E-06  -2.55420000E-04  +3.51620000E-04
   +3.67770000E-04  +7.01600000E-05  -8.64900000E-05  -4.41200000E-05  +5.75900000E-05
   -4.71000000E-06  +1.13560000E-04  +6.95600000E-05  +3.15660000E-04  -2.70800000E-04
   +5.77700000E-05  -1.67500000E-05  +7.25500000E-05  +2.30000000E-05  -2.97500000E-05
   +3.24100000E-05  +1.44620000E-04  +4.25213000E-03  -5.32839000E-03  -3.57500000E-05
   +2.66700000E-05  +1.33500000E-04  +5.45000000E-06  +1.00000000E-05  -5.57000000E-06
   -1.37700000E-05  +1.65900000E-05  -2.17900000E-05  -1.45450000E-04  +2.08500000E-05
   +9.05500000E-05  -2.02590000E-04  +8.74090000E-04  +2.37060000E-04  +4.75900000E-05
   -2.65000000E-06  +1.12000000E-06  +8.22400000E-05  +2.61877000E-03  +2.48613000E-03
   -2.89170000E-04  +3.01611000E-03  +2.76755000E-03  -2.99564000E-03  +1.44944750E-01
   +2.14970940E-01  -6.42500000E-05  -5.54200000E-05  +1.39400000E-05  +2.19620000E-04
   +3.10010000E-04  -2.88570000E-04  -1.34990000E-04  -4.86740000E-04  -7.14230000E-04
   -9.22600000E-05  +1.01210000E-04  +2.33810000E-04  -4.97500000E-05  -2.60300000E-05
   +3.81600000E-05  +9.36300000E-05  +8.17200000E-05  +1.02400000E-05  -1.87639000E-03
   +2.62960000E-04  -4.26400000E-04  -1.38820000E-04  -4.91500000E-05  -1.24160000E-04
   +1.11810000E-04  +1.18040000E-04  +2.72200000E-05  +4.00000000E-05  -4.46870000E-04
   +3.72210000E-04  -1.14200000E-04  +1.34130000E-04  -4.71900000E-05  -9.75300000E-05
   -2.71660000E-04  -1.18070000E-04  -2.62940000E-04  +4.46500000E-05  +3.28350000E-04
   +1.33690000E-04  -2.65820000E-04  -2.71990000E-04  -3.42330000E-04  +7.73360000E-04
   +5.55000000E-04  +1.57860000E-04  -3.35400000E-05  -3.83600000E-05  +5.84700000E-05
   +7.09100000E-05  -8.69100000E-05  -4.68821100E-02  -2.80242000E-03  +7.54173000E-03
   -4.01700000E-05  -1.39500000E-04  -1.66890000E-04  -3.03400000E-05  -2.22500000E-05
   -1.31000000E-06  -5.17000000E-06  +2.21000000E-06  -3.08400000E-05  -1.84020000E-03
   -3.34860000E-04  -3.86320000E-04  -7.12000000E-06  +4.67100000E-05  +4.15900000E-05
   +9.05000000E-06  +9.05000000E-06  +1.09500000E-05  +2.74800000E-04  -2.62350000E-04
   +3.03790000E-04  +2.20550000E-04  +2.80330000E-04  -2.84550000E-04  +7.07470000E-04
   +4.31000000E-05  -1.66600000E-05  +4.82090700E-02  +2.24250000E-04  -1.88870000E-04
   +5.65000000E-06  +2.11100000E-04  +1.05086000E-03  +4.88240000E-04  -7.27880000E-04
   +2.28250000E-04  +2.72550000E-04  -4.65600000E-05  -2.19830000E-04  -1.44310000E-04
   -1.48810000E-04  +3.88300000E-05  +1.99230000E-04  +1.64220000E-04  +8.23700000E-05
   -4.80500000E-05  +8.07770000E-04  +1.04397100E-02  -2.13464300E-02  +7.22800000E-05
   -3.34159000E-03  -2.72208000E-03  +6.91000000E-05  +1.31100000E-05  -3.57200000E-05
   -4.44320000E-04  +9.93580000E-04  +5.66650000E-04  +3.40260000E-04  -1.05360000E-04
   -1.24400000E-05  -4.34500000E-05  +3.45040000E-04  -3.76100000E-05  +5.22800000E-05
   +3.99500000E-05  -2.69500000E-05  -1.95930000E-04  +9.38700000E-05  +2.34730000E-04
   +9.24100000E-04  -1.24294000E-03  -8.97600000E-04  -1.35090000E-04  -1.28000000E-06
   -5.54000000E-06  -8.32200000E-05  -6.07600000E-05  +3.83300000E-05  -2.35574000E-03
   -8.39211300E-02  +9.18657700E-02  -1.06460000E-04  +2.57400000E-05  +1.28990000E-04
   -3.55000000E-06  +7.71000000E-06  +7.46000000E-06  -1.18300000E-05  +2.27100000E-05
   -1.73800000E-05  -7.07720000E-04  -3.12270000E-04  -3.15780000E-04  -1.41900000E-05
   +4.71000000E-05  -2.69800000E-05  +4.31000000E-06  +1.87400000E-05  -1.80700000E-05
   -2.62780000E-04  -3.65600000E-05  -1.11400000E-04  +2.88560000E-04  -1.39000000E-06
   -9.81600000E-05  +1.98000000E-06  +7.38830000E-04  -1.42267000E-03  +2.55111000E-03
   +9.16807400E-02  -1.52880000E-04  -4.42580000E-04  +8.00000000E-06  +9.75900000E-04
   +8.36300000E-04  +5.31940000E-04  +6.36860000E-04  -3.44990000E-04  -8.25200000E-05
   -3.21480000E-04  -5.59800000E-05  +3.41350000E-04  -3.83400000E-05  +2.06860000E-04
   +1.12380000E-04  +1.92530000E-04  +1.28940000E-04  -9.24000000E-06  +7.33200000E-04
   +9.73253000E-03  -1.88657600E-02  +4.00100000E-05  -5.03983000E-03  -2.74830000E-03
   -2.98600000E-05  +1.37300000E-05  +2.97400000E-05  -9.06190000E-04  +7.23140000E-04
   -3.88000000E-06  +2.96750000E-04  -2.36770000E-04  -1.39800000E-05  +1.17330000E-04
   +3.54400000E-04  +2.47390000E-04  +2.33770000E-04  -1.17530000E-04  -5.76700000E-04
   -3.73340000E-04  +1.53090000E-04  +6.08260000E-04  +8.07850000E-04  +6.97150000E-04
   -8.50960000E-04  -1.54000000E-04  +8.87000000E-06  +1.22720000E-04  -2.37000000E-06
   -1.35350000E-04  +1.20880000E-04  +7.52962000E-03  +9.04803600E-02  -2.78055010E-01
   -3.90370000E-04  +1.74490000E-04  +5.01900000E-04  -1.60500000E-05  -1.23800000E-05
   -1.22900000E-05  -2.16800000E-05  -3.63000000E-05  -3.94000000E-06  -5.14240000E-04
   +3.69910000E-04  +3.05670000E-04  -2.24800000E-05  +1.30730000E-04  +3.81300000E-05
   -2.98100000E-05  +1.08000000E-05  -2.58800000E-05  +3.40000000E-05  -4.38900000E-05
   +3.54550000E-04  +1.73700000E-05  -1.70100000E-05  +3.93900000E-04  +3.07800000E-05
   +6.13470000E-04  -1.54840000E-03  -8.30358000E-03  -9.96507800E-02  +3.03186260E-01
   +1.37640000E-04  +1.95970000E-04  +3.23150000E-04  +6.13260000E-04  +1.02280000E-04
   +9.13300000E-05  -1.56350000E-04  +1.24280000E-04  +4.36960000E-04  +2.20350000E-04
   -1.44680000E-04  -1.83050000E-04  +1.38130000E-04  +5.09700000E-05  -6.87500000E-05
   -1.20840000E-04  -9.23900000E-05  -6.59000000E-05  -1.16938000E-03  +8.95290000E-04
   +6.38970000E-04  -5.08700000E-05  +3.15680000E-04  +3.52480000E-04  -2.09700000E-04
   -1.65220000E-04  -2.79500000E-05  +8.03800000E-04  +1.34783000E-03  +1.85860000E-04
   +4.55520000E-04  -1.36320000E-04  +5.84400000E-05  -3.93000000E-05  -8.13000000E-06
   -3.03800000E-05  -7.99700000E-05  +1.58800000E-05  -5.18000000E-06  +5.15900000E-05
   -4.05900000E-05  -1.35700000E-05  -1.11710000E-04  -2.82330000E-04  +4.75900000E-05
   +8.43400000E-05  -9.69000000E-06  +6.10000000E-06  +4.90600000E-05  -1.24900000E-05
   -2.93100000E-05  -2.39000560E-01  -1.21352250E-01  +2.30118000E-02  +1.38000000E-04
   +1.35040000E-04  -1.06200000E-05  +4.66200000E-05  +2.48700000E-05  -3.37000000E-06
   -2.19400000E-05  -6.26000000E-06  +2.67400000E-05  +5.86900000E-05  -1.85360000E-04
   -5.28630000E-04  +8.19600000E-05  -5.99600000E-05  -6.22300000E-05  -3.16500000E-05
   +2.06000000E-06  -2.30800000E-05  -5.77800000E-05  -1.28190000E-04  +6.10400000E-05
   +3.54840000E-04  +1.59360000E-04  -4.75510000E-04  +2.74600000E-04  +2.50650000E-04
   -5.95500000E-05  +1.16210000E-04  +8.68110000E-04  -2.37360000E-04  +2.56646500E-01
   -1.50218000E-03  -3.42860000E-04  +3.33760000E-04  +1.41646000E-03  -2.42421000E-03
   -3.83205000E-03  +5.94770000E-04  +7.68100000E-05  -6.31700000E-04  -1.54390000E-04
   +6.88400000E-05  +2.85700000E-05  +2.61770000E-04  +1.35100000E-04  -2.02700000E-05
   +2.19000000E-05  -3.45600000E-04  -2.48380000E-04  -2.01673500E-02  -1.49468400E-02
   +2.17679000E-03  -1.47100000E-05  +4.31080000E-04  +1.41615000E-03  -2.57760000E-04
   -1.74620000E-04  +4.19400000E-05  -1.56589000E-03  +9.28570000E-04  +7.41010000E-04
   +9.07950000E-04  -5.94700000E-05  -2.10740000E-04  -5.29800000E-05  +3.74730000E-04
   -1.74530000E-04  +9.11200000E-05  -1.29810000E-04  +1.16200000E-04  +2.24140000E-04
   +1.78470000E-04  -3.15000000E-06  -4.72840000E-04  -6.89820000E-04  +3.88790000E-04
   -8.80200000E-05  +5.74000000E-05  -5.84400000E-05  -8.38900000E-05  -3.32400000E-05
   +5.60100000E-05  -1.19289780E-01  -1.21213740E-01  +1.56874700E-02  +3.73560000E-04
   +2.12260000E-04  -4.72700000E-05  +2.70800000E-05  +1.28100000E-05  -1.59500000E-05
   -5.89500000E-05  -1.13700000E-05  +1.06000000E-06  +2.35570000E-04  +6.66400000E-05
   +3.27040000E-04  +2.12000000E-05  +2.30400000E-05  -7.31500000E-05  -9.93500000E-05
   -1.07460000E-04  +2.42000000E-05  +1.44360000E-04  +2.95400000E-05  -6.36700000E-05
   +2.05040000E-04  +6.28560000E-04  -4.12870000E-04  +3.29990000E-04  +4.74900000E-05
   +1.43480000E-04  -9.68668000E-03  -6.61231000E-03  +6.92340000E-04  +1.31743300E-01
   +1.32254160E-01  -1.23518000E-03  -7.67910000E-04  +4.52150000E-04  +1.15997000E-03
   -2.79383000E-03  -3.24241000E-03  +8.39830000E-04  -2.90530000E-04  -5.09800000E-04
   -1.77140000E-04  +2.98100000E-05  +2.85630000E-04  +9.94300000E-05  +1.04980000E-04
   -5.45000000E-06  +7.76100000E-05  -1.89770000E-04  -2.65420000E-04  -1.90982800E-02
   -1.25057100E-02  +4.54560000E-04  -1.36318000E-03  -8.88370000E-04  +9.72820000E-04
   -8.12600000E-05  -7.18000000E-06  +3.19500000E-05  -8.45850000E-04  +7.20300000E-04
   +7.74400000E-04  +3.48270000E-04  +1.33840000E-04  -2.86400000E-05  -8.74700000E-05
   +5.92400000E-05  -2.00950000E-04  -1.19420000E-04  +3.38000000E-05  +2.51330000E-04
   +1.34500000E-05  -1.63060000E-04  -2.97300000E-05  +1.08050000E-04  -1.14520000E-04
   -3.38690000E-04  -6.19300000E-05  +6.63000000E-06  -5.45800000E-05  -5.93500000E-05
   +5.54000000E-06  -2.78700000E-05  +2.44967500E-02  +1.66421600E-02  -4.96423800E-02
   +2.20100000E-05  +2.14800000E-04  +9.06100000E-05  -4.69000000E-06  -1.16900000E-05
   -4.22000000E-06  -1.59200000E-05  -2.76300000E-05  +8.00000000E-06  -1.36300000E-04
   +5.72810000E-04  +1.93010000E-04  +2.11500000E-05  +1.34500000E-05  +2.66600000E-05
   -1.11630000E-04  -3.97300000E-05  -2.56500000E-05  +2.44000000E-05  +3.66900000E-05
   -4.24700000E-05  +3.57140000E-04  +3.89900000E-05  -7.80180000E-04  +1.94620000E-04
   +2.10690000E-04  +2.41010000E-04  +2.61004100E-02  +1.51195000E-02  -2.08753000E-03
   -2.64487600E-02  -1.33933400E-02  +5.38932700E-02  +1.54430000E-04  +1.25710000E-04
   +2.73600000E-05  +1.11490000E-04  -1.73870000E-04  +1.55390000E-04  -5.63230000E-04
   -7.83120000E-04  +6.62150000E-04  +1.42790000E-04  -1.02050000E-04  -1.31590000E-04
   -1.30350000E-04  -2.46300000E-05  -3.86900000E-05  +7.87000000E-06  -7.10000000E-07
   +2.54000000E-06  -2.00150000E-04  -9.96460000E-04  -1.24830000E-04  +1.71260000E-04
   -3.39150000E-04  -3.61040000E-04  +7.65700000E-05  +3.68900000E-05  -2.48100000E-05
   +1.76570000E-04  +8.74790000E-04  +1.18690000E-03  +1.12012000E-03  -7.24800000E-05
   -4.36820000E-04  -1.28430000E-04  +6.12410000E-04  -1.97410000E-04  +1.30300000E-04
   -1.38170000E-04  +2.37930000E-04  +1.44470000E-04  +8.07100000E-05  -1.20700000E-05
   -3.07480000E-04  -5.32120000E-04  +1.80940000E-04  -1.90030000E-04  +6.64600000E-05
   -7.11900000E-05  -1.66430000E-04  -8.51500000E-05  +8.85400000E-05  -2.09489560E-01
   +1.27181350E-01  -2.71908700E-02  +2.22550000E-04  +1.56970000E-04  -2.75800000E-05
   -7.16000000E-06  +5.58000000E-06  +4.06000000E-06  +3.42700000E-05  -7.27000000E-06
   +2.30300000E-05  -7.54260000E-04  -1.49049000E-03  +9.63200000E-05  -1.52400000E-05
   -3.61000000E-06  -9.40000000E-06  +7.58000000E-06  +2.11600000E-05  -7.80000000E-06
   +3.60100000E-04  -6.92500000E-05  +3.91050000E-04  -1.82270000E-04  +1.34520000E-04
   +2.53000000E-06  +2.05960000E-04  -2.48850000E-04  +9.71500000E-05  +1.25197000E-03
   -2.19483000E-03  +5.20540000E-04  -1.91661900E-02  +1.70917900E-02  -4.14476000E-03
   +2.27127820E-01  -2.82620000E-04  -1.73940000E-04  -2.62040000E-04  +7.35680000E-04
   +7.73170000E-04  +4.23830000E-04  +6.41400000E-05  -3.82470000E-04  -6.31280000E-04
   -3.82710000E-04  +1.74910000E-04  +2.58640000E-04  -1.16000000E-04  +3.49100000E-05
   +1.69220000E-04  +2.28520000E-04  +1.70580000E-04  -5.00000000E-06  +1.87056600E-02
   -1.43517000E-02  +3.90070000E-03  +1.34550000E-04  +5.43360000E-04  +1.60588000E-03
   +1.56870000E-04  +1.56460000E-04  +3.41400000E-05  -1.15730000E-04  -2.60609000E-03
   -4.17361000E-03  -3.63930000E-04  -2.46360000E-04  +5.40540000E-04  +4.52390000E-04
   -6.88690000E-04  +3.34610000E-04  -1.75500000E-05  +8.28500000E-05  -5.65710000E-04
   -2.42870000E-04  +4.16800000E-05  +1.32970000E-04  +3.76960000E-04  +3.66250000E-04
   -1.56540000E-04  +2.32960000E-04  -6.41400000E-05  +1.33490000E-04  +3.64680000E-04
   +1.06470000E-04  -5.78500000E-05  +1.25827320E-01  -1.45815400E-01  +2.07001200E-02
   -2.79410000E-04  -1.95810000E-04  -8.58100000E-05  -3.93100000E-05  -3.82400000E-05
   +6.22000000E-06  +4.21000000E-06  -3.31300000E-05  -1.14400000E-05  -1.05963000E-03
   -9.85920000E-04  +1.04540000E-03  +3.16400000E-05  +6.15800000E-05  +1.19960000E-04
   +2.00900000E-05  -1.00000000E-05  +2.83200000E-05  -3.17470000E-04  +5.92680000E-04
   -5.33990000E-04  -1.14680000E-04  -4.32300000E-05  -9.83800000E-05  -3.50720000E-04
   +6.75800000E-05  +1.51120000E-04  +8.71671000E-03  -7.45903000E-03  +9.70550000E-04
   -1.36249700E-02  +1.17040800E-02  -2.77868000E-03  -1.38858810E-01  +1.57858330E-01
   +8.78000000E-06  +2.95600000E-05  -2.73170000E-04  +9.73600000E-05  +6.83800000E-04
   +4.89910000E-04  -3.89370000E-04  +4.00560000E-04  +7.04770000E-04  -2.14500000E-05
   -2.24790000E-04  -2.04050000E-04  -1.54510000E-04  +5.59700000E-05  +1.31990000E-04
   +1.18880000E-04  +3.32600000E-05  -4.06900000E-05  +1.80237400E-02  -1.33275400E-02
   +1.61391000E-03  +1.23199000E-03  -9.08470000E-04  +1.03933000E-03  +4.67000000E-05
   -7.12000000E-06  -4.46200000E-05  -2.04810000E-04  -2.69140000E-03  -3.58819000E-03
   -9.14000000E-05  -3.70210000E-04  +3.99960000E-04  +5.57780000E-04  -1.47500000E-04
   +4.91920000E-04  +2.67800000E-04  -1.10500000E-05  -8.03710000E-04  -4.18970000E-04
   +2.82620000E-04  +4.52360000E-04  +7.29400000E-04  +3.37290000E-04  -4.67600000E-04
   -1.96800000E-05  -3.94200000E-05  +1.57610000E-04  +2.06160000E-04  -5.43000000E-06
   +2.49800000E-05  -2.73612100E-02  +2.19578300E-02  -5.16045000E-02  -3.63770000E-04
   -2.54100000E-05  +2.21190000E-04  +5.13000000E-06  +1.02700000E-05  +9.90000000E-06
   +1.46900000E-05  +3.80000000E-07  +1.65300000E-05  +2.90790000E-04  +3.10930000E-04
   -2.17890000E-04  +3.19200000E-05  -2.64600000E-05  +8.27000000E-06  +2.34100000E-05
   -1.26300000E-05  +1.15100000E-05  -3.98420000E-04  -5.71900000E-05  -7.31600000E-04
   +4.94000000E-05  +8.48300000E-05  -5.76100000E-05  -1.56760000E-04  +2.03330000E-04
   +3.09390000E-04  -2.41427200E-02  +1.77675300E-02  -3.04030000E-03  +3.06222000E-03
   -2.70764000E-03  -4.75760000E-04  +2.91907900E-02  -2.09700000E-02  +5.52274700E-02
   -9.75500000E-05  -1.07740000E-04  -7.08000000E-05  -1.22100000E-05  +7.87100000E-05
   -2.27460000E-04  +2.07400000E-05  -2.69300000E-05  +9.36900000E-05  -7.90100000E-05
   -8.31500000E-05  +4.32400000E-05  -1.76710000E-04  -1.46800000E-05  +7.77700000E-05
   +1.71460000E-04  +7.03300000E-05  -7.84900000E-05  -8.35870000E-04  -1.59030000E-04
   -2.90780000E-04  +1.20550000E-04  -1.38300000E-04  -3.52000000E-05  +1.50160000E-04
   +1.07880000E-04  -1.67800000E-05  +4.32978000E-03  -2.57502000E-03  -1.39726000E-03
   +9.93550000E-04  +1.00790000E-03  -5.37520000E-04  +8.41350000E-04  +9.52660000E-04
   +1.41920000E-04  -2.78829000E-03  +4.13796000E-03  -4.22205000E-03  -1.76287700E-02
   +7.74062000E-03  +2.20978900E-02  -1.55649420E-01  +5.86902300E-02  +1.26998070E-01
   -1.60994000E-03  -4.66690000E-04  +1.34930000E-03  -1.33290000E-04  -2.40840000E-04
   +3.28770000E-04  -3.29740000E-04  +7.93800000E-04  +2.39900000E-05  +4.10460000E-03
   -1.30864900E-02  -1.10029100E-02  -1.62400000E-05  -1.17600000E-05  +1.37400000E-05
   +1.99600000E-05  -1.94000000E-06  -3.90000000E-06  +1.07300000E-05  +1.00190000E-04
   -9.28000000E-06  -7.18000000E-06  -2.68500000E-05  +4.15000000E-05  +1.45300000E-05
   -2.80000000E-07  +1.80500000E-05  +7.86700000E-05  -3.54900000E-05  +4.52700000E-05
   -9.95000000E-06  +9.71000000E-06  +2.18800000E-05  -9.08000000E-06  -1.31600000E-05
   -2.20700000E-05  +2.36850000E-04  +1.01078000E-03  -4.94210000E-04  -1.76400000E-05
   -2.32300000E-05  +3.81400000E-05  +1.42300000E-05  -3.70400000E-05  -2.92850000E-04
   +1.69154580E-01  -5.09300000E-05  -4.14000000E-06  +4.47400000E-05  +1.84480000E-04
   -8.65500000E-05  +5.48000000E-06  +9.18500000E-05  +5.54800000E-05  +1.30130000E-04
   -4.42700000E-05  -7.76900000E-05  -8.89000000E-06  +5.33300000E-05  +7.00000000E-07
   -1.21400000E-05  +2.29100000E-05  +2.09900000E-05  -4.65300000E-05  -5.70610000E-04
   -1.04040000E-04  -4.95290000E-04  -1.15020000E-04  -1.34670000E-04  -1.33190000E-04
   -3.10900000E-05  -1.97200000E-05  +3.69000000E-06  -1.08833900E-02  +7.76293000E-03
   +1.35427200E-02  +2.47014000E-03  -1.20029000E-03  +3.22987000E-03  +9.46200000E-04
   +2.43919000E-03  +9.81060000E-04  +1.75948000E-03  +2.27342000E-03  -4.79210000E-04
   +1.13119000E-03  +3.25141000E-03  -4.14641000E-03  +6.25146100E-02  -6.13022600E-02
   -5.57528200E-02  -1.02270000E-04  -2.10610000E-04  -3.15000000E-04  -3.38510000E-04
   -3.15510000E-04  +5.97900000E-05  +3.82840000E-04  -1.24600000E-03  +1.00392000E-03
   +1.65719000E-03  -2.94106300E-02  -2.25364800E-02  +5.99000000E-06  +6.72000000E-06
   -6.22000000E-06  -1.73100000E-05  +1.08700000E-05  -1.90000000E-06  +4.40400000E-05
   -6.52000000E-06  -3.80300000E-05  -2.47100000E-05  -4.33700000E-05  +1.70100000E-05
   +1.12500000E-05  -5.01000000E-06  +1.85200000E-05  +3.10800000E-05  +3.45700000E-05
   -4.44000000E-06  +1.63000000E-06  +5.82200000E-05  +5.25000000E-06  -5.27600000E-05
   +1.71100000E-05  -1.32850000E-04  +1.12075000E-03  -2.20947000E-03  +2.40800000E-05
   +2.90200000E-05  +4.85300000E-05  +1.94000000E-05  -3.16900000E-05  +2.34700000E-04
   -3.30490000E-04  -5.62076200E-02  +8.49943700E-02  -5.11800000E-05  -4.05700000E-04
   -2.14060000E-04  -3.39330000E-04  +1.42150000E-04  +3.80300000E-05  -4.88000000E-06
   -1.89800000E-05  +7.05800000E-05  -1.62970000E-04  -1.22420000E-04  +9.48200000E-05
   -2.68040000E-04  -1.55600000E-05  +1.45550000E-04  +2.52620000E-04  +1.59170000E-04
   -8.83800000E-05  +1.16918000E-03  -7.79160000E-04  -1.15630000E-04  +1.80000000E-07
   +1.12800000E-05  +1.00390000E-04  +2.37010000E-04  +1.70370000E-04  -1.01500000E-05
   +1.79469900E-02  -7.20442000E-03  -1.71510800E-02  -2.43952000E-03  +2.81004000E-03
   -4.28102000E-03  -4.25590000E-04  -1.86400000E-04  +5.75540000E-04  -1.89145000E-03
   +1.18102000E-03  -9.17000000E-04  -8.13956000E-03  +4.44594000E-03  +1.07191400E-02
   +1.26865240E-01  -5.61061600E-02  -2.03260670E-01  -5.59990000E-04  -2.88450000E-04
   +5.41910000E-04  +2.86690000E-04  -1.69310000E-04  +9.20200000E-05  +1.46760000E-04
   +3.43600000E-05  -4.24090000E-04  -4.63070000E-04  -7.15101000E-03  -2.09118000E-03
   -3.32300000E-05  -1.70100000E-05  +1.38300000E-05  +1.88200000E-05  -6.40000000E-07
   -1.22400000E-05  -1.13600000E-04  +6.56600000E-05  +3.21000000E-06  +2.57400000E-05
   +3.07300000E-05  +8.81800000E-05  +2.12900000E-05  +1.99400000E-05  +7.86000000E-06
   -9.95300000E-05  +4.24900000E-05  +4.62000000E-05  -1.11400000E-05  -1.24500000E-04
   +2.82600000E-05  +5.56000000E-05  +3.16300000E-05  +1.36760000E-04  -1.51040000E-04
   +2.82980000E-04  +1.17213000E-03  -6.78000000E-05  -2.31620000E-04  +1.26060000E-04
   -6.81000000E-05  -1.09670000E-04  +4.42340000E-04  -1.32747940E-01  +6.37994900E-02
   +2.13801500E-01  +6.05000000E-06  -6.70000000E-06  +1.94500000E-05  +2.11370000E-04
   +3.66800000E-05  +1.02000000E-06  -1.00000000E-07  -2.52100000E-05  +1.31000000E-06
   -5.18000000E-06  -1.46700000E-05  +3.20000000E-07  +4.25800000E-05  +2.26000000E-05
   -8.52000000E-06  -2.06600000E-05  -5.62000000E-06  +1.53000000E-05  +3.47360000E-04
   +2.91370000E-04  -1.21654000E-03  -3.65930000E-04  +2.15520000E-04  +6.15000000E-05
   -5.29700000E-05  -4.12400000E-05  +9.00000000E-06  -3.84617000E-03  +8.24170000E-04
   -5.89600000E-05  -1.69939000E-03  +7.89360000E-04  +3.39230000E-04  -2.29811000E-03
   +1.78980000E-04  +9.57750000E-04  +9.16535000E-03  -4.74677000E-03  +2.37698000E-02
   -6.63283200E-02  +1.58985000E-02  -5.50193300E-02  -1.82795000E-03  +5.92486000E-03
   -2.78192700E-02  +1.25416000E-03  -8.34550000E-04  -1.55290000E-03  -6.33550000E-04
   +1.13910000E-04  +1.97015000E-03  +7.48700000E-05  -8.73700000E-05  -2.09000000E-05
   -3.83280000E-04  -4.82490000E-04  -2.97400000E-05  +3.13000000E-06  +5.60000000E-06
   -8.10000000E-06  -1.41700000E-05  +1.94000000E-06  -1.00000000E-06  +3.17000000E-06
   +8.96000000E-06  -2.82000000E-06  +2.21000000E-06  +1.54400000E-05  +1.23000000E-06
   -4.46000000E-06  -3.60000000E-06  -1.82000000E-06  -3.57000000E-06  +8.38800000E-05
   -1.25960000E-04  +1.59200000E-05  +2.27000000E-06  +6.14000000E-06  +5.01000000E-06
   -1.72000000E-05  +5.70000000E-07  +6.60000000E-07  +8.90000000E-07  +2.50700000E-05
   +5.80000000E-06  +6.09000000E-06  +7.48000000E-06  -3.03000000E-06  +7.04000000E-06
   +4.20000000E-07  +7.24240000E-04  -6.53910000E-04  +4.70610000E-04  +6.53729800E-02
   +9.70000000E-06  +3.82500000E-05  +2.60700000E-05  -9.20200000E-05  -7.56900000E-05
   -4.71800000E-05  -4.76000000E-05  +1.85200000E-05  +2.79900000E-05  +4.71900000E-05
   +3.73500000E-05  -4.75000000E-06  -1.63700000E-05  -3.52700000E-05  -2.52400000E-05
   -1.74300000E-05  -4.53200000E-05  +9.38000000E-06  -3.54000000E-04  -2.99830000E-04
   +3.12600000E-05  +1.00020000E-04  -1.47350000E-04  -2.89200000E-05  +3.44800000E-05
   +1.40600000E-05  -7.10000000E-07  +2.71971000E-03  +3.00409000E-03  +3.83010000E-04
   -1.67054000E-03  -1.30200000E-04  +8.78980000E-04  +3.14652000E-03  +3.15683000E-03
   +7.56030000E-04  -5.53600000E-05  +4.05091000E-03  -2.87150000E-03  +1.51675300E-02
   -3.20984700E-02  +5.07072400E-02  +2.39067000E-03  +6.85210000E-04  +7.03521000E-03
   -2.01654000E-03  -4.72960000E-03  -5.80530000E-04  -1.29520000E-04  +1.51678000E-03
   -3.30970000E-04  +1.77390000E-04  -9.50900000E-05  +1.02010000E-04  -5.87360000E-04
   -1.90417000E-03  +7.31900000E-05  -8.92000000E-06  +1.99000000E-06  +2.20000000E-07
   +7.85000000E-06  +5.77000000E-06  -3.13000000E-06  +1.58600000E-05  -1.76000000E-05
   -4.18000000E-06  -1.47300000E-05  -8.92000000E-06  -3.00200000E-05  -3.62000000E-06
   +2.46000000E-06  -3.53000000E-06  +2.53100000E-05  -6.08400000E-05  +3.06300000E-05
   -1.34000000E-05  +1.23700000E-05  +1.27700000E-05  -1.09900000E-05  +2.24000000E-06
   -5.61700000E-05  +8.40400000E-05  +1.05000000E-06  -2.51900000E-05  -1.75300000E-05
   -3.67000000E-05  +5.21300000E-05  -6.00000000E-08  -6.14400000E-05  -6.86100000E-05
   -1.49823000E-03  -1.41447000E-03  -1.82770000E-04  -1.73114800E-02  +2.88321700E-02
   -2.28000000E-06  -6.28000000E-06  -5.40000000E-07  +4.03400000E-05  +6.20800000E-05
   +7.50000000E-06  -5.30000000E-06  -1.54700000E-05  -1.58800000E-05  -1.17800000E-05
   -2.70100000E-05  -1.28000000E-06  +4.98800000E-05  +4.00800000E-05  +1.10000000E-07
   -1.84600000E-05  -2.92000000E-06  +1.76400000E-05  +2.87850000E-04  -6.30700000E-05
   -2.83700000E-04  -1.31650000E-04  +4.97400000E-05  +4.91700000E-05  -6.67700000E-05
   -5.10800000E-05  +7.34000000E-06  -9.69020000E-04  +7.31200000E-05  +1.11113000E-03
   +1.21400000E-05  -2.28700000E-04  +6.01530000E-04  +3.50981000E-03  -2.33560000E-04
   +1.16052000E-03  -8.65357000E-03  +5.01148000E-03  -1.93074000E-02  -5.30524600E-02
   +5.00360600E-02  -3.25025980E-01  +1.92216000E-03  +1.44684000E-03  -2.46617000E-03
   -6.87970000E-04  -7.08680000E-04  +1.68340000E-03  +5.23200000E-04  +2.80790000E-04
   -1.34889000E-03  -4.56300000E-05  +2.36000000E-06  -2.25200000E-05  -1.74780000E-04
   -6.23980000E-04  +3.21900000E-04  +7.32000000E-06  +6.85000000E-06  -6.22000000E-06
   -1.11700000E-05  -1.14000000E-06  +2.76000000E-06  +4.67000000E-06  +4.72000000E-06
   -3.20000000E-06  +7.10000000E-06  +1.33800000E-05  +7.47000000E-06  -3.29000000E-06
   -2.46000000E-06  -4.89000000E-06  -1.12500000E-05  +2.75800000E-05  -3.85800000E-05
   +6.03000000E-06  -1.21000000E-05  +6.70000000E-07  +1.36900000E-05  -2.00000000E-06
   +1.20000000E-07  -9.08000000E-06  -9.41000000E-06  +8.20000000E-07  +6.10000000E-06
   +2.00000000E-08  -1.59000000E-05  -1.19100000E-05  +3.38100000E-05  +1.85600000E-05
   -5.32520000E-04  -1.75530000E-04  +7.60610000E-04  +5.85351100E-02  -5.49199700E-02
   +3.43386060E-01  -8.40190000E-04  +1.06570000E-04  +7.25340000E-04  +1.12560000E-04
   +1.17810000E-03  -4.98300000E-04  -1.28880000E-04  -2.16250000E-04  -4.27840000E-04
   -6.90700000E-05  -4.64800000E-04  -1.93510000E-04  +2.20220000E-04  +4.93860000E-04
   +3.22050000E-04  +1.35920000E-04  -1.18880000E-04  -3.31400000E-05  +1.62895000E-03
   -4.23190000E-04  +1.33529000E-03  -4.99790000E-04  +9.23000000E-05  +3.11760000E-04
   -5.72570000E-04  -5.48490000E-04  -5.27200000E-05  -1.12396700E-02  -1.58039000E-03
   +2.01942000E-02  +2.38295400E-02  -1.51914100E-02  -5.45204000E-03  -2.06884000E-03
   +6.65451500E-02  +2.63059000E-02  -4.96533000E-03  -7.79440000E-03  -3.56185500E-02
   -1.51143400E-02  +2.17788000E-03  +6.03321000E-03  +1.45999900E-02  +2.63860000E-02
   -2.58529000E-03  +6.34323000E-03  -1.45372000E-03  +2.71547000E-03  -4.39842000E-03
   -1.31170800E-02  -2.37215000E-03  -1.26670000E-03  +6.00300000E-04  -6.18100000E-04
   +9.33390000E-04  -2.67548200E-02  -1.72306000E-02  +6.88400000E-05  +5.31800000E-05
   -3.01800000E-05  -6.82300000E-05  -6.21100000E-05  +2.66200000E-05  +1.39880000E-04
   +6.12000000E-06  -1.30990000E-04  -9.74700000E-05  +5.65150000E-04  -2.26840000E-04
   -2.47920000E-04  -7.28000000E-05  -1.16700000E-04  -9.94200000E-05  +1.82940000E-04
   -1.96130000E-04  +1.33000000E-05  -1.07380000E-04  +4.40500000E-05  +3.62600000E-05
   +1.18000000E-06  -1.94000000E-04  +2.04220000E-04  -1.89390000E-04  -1.54660000E-04
   -3.65000000E-05  -3.37540000E-04  -3.80300000E-05  -3.63390000E-04  +5.81620000E-04
   +2.51070000E-04  -9.43840000E-04  -1.93218000E-03  +1.10600000E-05  +1.67020000E-04
   +1.17608000E-03  +4.81230000E-04  +4.27897600E-02  -7.29890000E-04  -1.94100000E-05
   +6.56360000E-04  +5.83620000E-04  +1.10884000E-03  -4.31740000E-04  -1.67760000E-04
   -2.55790000E-04  -4.02490000E-04  -4.36700000E-05  -4.60200000E-04  -2.52100000E-04
   +2.45420000E-04  +5.10810000E-04  +3.18810000E-04  +3.47000000E-05  -1.51530000E-04
   +1.09290000E-04  +2.05913000E-03  +3.72890000E-04  +1.55824000E-03  -6.11140000E-04
   +2.18750000E-04  +1.99840000E-04  -6.53400000E-04  -6.42890000E-04  -4.84700000E-05
   -8.46069000E-03  -4.43010000E-03  +1.70195000E-02  +2.54161400E-02  -3.58029500E-02
   -9.92401000E-03  +2.04603000E-02  +4.32924600E-02  +2.95668800E-02  -2.82683000E-03
   -4.54649000E-03  -4.56691000E-02  -2.08726200E-02  +2.23315000E-03  +9.76193000E-03
   +2.07525700E-02  +2.79498300E-02  -1.54545000E-03  +8.53549000E-03  -2.42707000E-03
   +4.91434000E-03  +4.56669000E-03  -6.01090000E-04  -4.59555000E-03  -1.28451000E-03
   +5.88990000E-04  -4.39800000E-04  +8.27850000E-04  -3.55873300E-02  -2.37190200E-02
   +6.70100000E-05  +6.82800000E-05  -3.58400000E-05  -7.82400000E-05  -5.99200000E-05
   +1.71500000E-05  +1.77350000E-04  -1.28700000E-05  -1.46840000E-04  +2.38700000E-05
   +8.30300000E-04  -2.33100000E-04  -3.41770000E-04  -7.72400000E-05  -1.75270000E-04
   -1.90550000E-04  +2.50080000E-04  -1.41350000E-04  -5.03600000E-05  -2.93820000E-04
   +5.70300000E-05  +1.62510000E-04  +4.98000000E-05  -1.00080000E-04  +2.36580000E-04
   -1.83450000E-04  -1.28910000E-04  -5.64600000E-05  -3.67460000E-04  -3.84600000E-05
   -3.72080000E-04  +6.18470000E-04  +2.27780000E-04  -1.40551000E-03  -2.48972000E-03
   +1.54570000E-04  -2.29910000E-04  +5.59380000E-04  +5.62130000E-04  -5.38622700E-02
   +1.14778600E-02  -1.55370000E-04  +4.95000000E-06  +1.48690000E-04  -9.37500000E-05
   +2.84010000E-04  -6.97300000E-05  -3.19500000E-05  -6.43000000E-05  -7.63100000E-05
   -3.02500000E-05  -8.90700000E-05  -1.89200000E-05  +4.85900000E-05  +1.00040000E-04
   +5.87700000E-05  +2.63300000E-05  -7.57000000E-06  -3.75800000E-05  +2.02100000E-05
   -6.41480000E-04  +4.02600000E-05  -7.07300000E-05  +3.76200000E-05  +1.04930000E-04
   -1.04370000E-04  -9.05300000E-05  -9.69000000E-06  -7.72150000E-04  -2.87720000E-04
   +5.05270000E-04  +2.36959000E-03  +1.15493000E-03  +2.94250000E-04  -3.92399000E-03
   -7.83518000E-03  -2.80190500E-02  -6.57916000E-03  -1.10235800E-02  -1.85959000E-03
   +4.51081000E-03  -1.02472000E-03  -4.16216000E-03  -1.69009000E-03  -1.62371000E-03
   -3.23150000E-03  +1.23787000E-03  +1.90312000E-03  +2.80480000E-04  +7.47291000E-03
   +1.11915300E-02  -3.59450000E-04  -1.07960000E-04  +2.45300000E-05  -1.45750000E-04
   -2.04460000E-04  -9.05400000E-04  +8.66710000E-04  +1.53500000E-05  +6.85000000E-06
   -4.78000000E-06  -1.43300000E-05  -1.30400000E-05  +7.30000000E-06  +1.24800000E-05
   +9.89000000E-06  -2.08500000E-05  -3.91400000E-05  +5.67900000E-05  +1.18500000E-05
   -2.12100000E-05  -1.74100000E-05  -3.57000000E-06  -2.32600000E-05  +1.73700000E-05
   -4.23200000E-05  +9.13000000E-06  -2.36700000E-05  +6.74000000E-06  -1.22300000E-05
   -1.40000000E-06  -3.38600000E-05  -4.29000000E-06  -1.52300000E-05  +2.11100000E-05
   +1.98000000E-06  -3.81500000E-05  -2.06700000E-05  -5.12900000E-05  +6.81200000E-05
   +6.74800000E-05  -1.86910000E-04  -9.86100000E-05  +9.31500000E-05  +7.57700000E-05
   +2.71170000E-04  +2.71640000E-04  -1.42483300E-02  -7.25180000E-04  +6.61780100E-02
   -6.70100000E-05  +1.76140000E-04  +1.62510000E-04  -4.15910000E-04  +2.08840000E-04
   -4.67200000E-05  -4.88800000E-05  -1.57100000E-05  -7.02100000E-05  +4.99400000E-05
   +1.57400000E-05  +2.36900000E-05  -6.60900000E-05  -4.28600000E-05  +1.25400000E-05
   +3.46100000E-05  -3.70900000E-05  -8.59000000E-05  -6.19340000E-04  -2.55288000E-03
   -1.47209000E-03  -2.32093000E-03  +1.93025000E-03  +6.96700000E-04  +9.24700000E-05
   +5.94600000E-05  -1.88800000E-05  +6.53215000E-03  -1.05174800E-02  +2.14960600E-02
   -5.20426100E-02  +1.76024400E-02  -1.58031700E-02  +4.54320000E-04  +1.06308400E-02
   -2.29860400E-02  -3.03943000E-03  +3.59144000E-03  +2.24360000E-03  +6.39560000E-04
   -4.65090000E-04  -5.22650000E-04  -2.99954000E-03  +4.08927000E-03  +4.30586000E-03
   -9.78770000E-04  +1.18150000E-04  -1.28808000E-03  +3.01275000E-03  -2.30303000E-03
   +9.80300000E-05  +6.29560000E-04  -1.05860000E-04  -1.94000000E-05  +2.50860000E-04
   +6.20910000E-04  -5.48650000E-04  -1.01600000E-05  -1.10900000E-05  +6.82000000E-06
   +1.49700000E-05  -8.38000000E-06  +5.60000000E-07  -4.01000000E-06  -1.46700000E-05
   -1.67000000E-06  +2.72400000E-05  -1.37560000E-04  -2.67800000E-05  +3.44000000E-06
   +6.90000000E-07  +9.62000000E-06  +5.20600000E-05  -3.31710000E-04  -9.19100000E-05
   -4.93960000E-04  +7.71440000E-04  -7.71300000E-05  -2.12363000E-03  +6.74540000E-04
   -8.26560000E-04  +2.76500000E-05  -6.15200000E-05  -1.58600000E-04  +2.71400000E-05
   -1.64700000E-05  +3.08400000E-05  -2.23600000E-05  -1.13340000E-04  -1.01730000E-04
   +2.51600000E-04  -8.83470000E-04  +1.22250000E-03  +8.68400000E-05  -1.53790000E-04
   -4.21000000E-06  +1.81020000E-04  +6.16670000E-04  +1.23440000E-04  +5.40871500E-02
   -1.01820000E-04  +9.43400000E-05  +1.89500000E-04  -5.61310000E-04  +6.28470000E-04
   +2.88470000E-04  -1.33800000E-04  -1.46360000E-04  -1.33120000E-04  -5.80000000E-07
   -5.50100000E-05  +9.76000000E-06  +7.10000000E-06  +7.06400000E-05  +3.80200000E-05
   +5.41200000E-05  -5.62500000E-05  -4.67700000E-05  -2.27015000E-03  -4.10666000E-03
   -1.96060000E-03  +2.62874000E-03  -7.77990000E-04  -2.16660000E-04  -4.58100000E-05
   -4.98900000E-05  -1.90800000E-05  -1.30075000E-03  +6.96984000E-03  +1.49035000E-03
   +1.59025700E-02  -9.83912800E-02  +1.12080850E-01  +6.39090000E-04  -3.85140000E-03
   +1.87568700E-02  +2.86894000E-03  -9.03330000E-04  -2.66414000E-03  -3.03640000E-04
   +6.20000000E-06  -5.19740000E-04  +3.38994000E-03  +6.77909000E-03  +2.46979000E-03
   +1.25375000E-03  +6.68090000E-04  +1.43245000E-03  -1.16816000E-03  +2.63540000E-04
   -2.01753000E-03  +1.02316000E-03  -5.79610000E-04  +1.70000000E-04  -1.94170000E-04
   +4.14500000E-04  -1.52238000E-03  +7.30000000E-06  +2.12000000E-06  -3.85000000E-06
   -1.24100000E-05  -1.69100000E-05  +4.46000000E-06  +9.44000000E-06  +7.30000000E-07
   -1.12100000E-05  -9.69900000E-05  -8.25200000E-05  -3.57300000E-05  -1.04900000E-05
   -1.24700000E-05  +6.70000000E-06  -7.87100000E-05  -2.36090000E-04  -3.41060000E-04
   +1.16163000E-03  -1.33526000E-03  +3.74100000E-05  +4.53520000E-04  -2.37720000E-04
   -1.11760000E-04  -1.30300000E-05  +1.01800000E-05  +2.49300000E-05  +8.89000000E-06
   +1.38700000E-05  -9.25000000E-06  -2.00100000E-05  -1.94550000E-04  -2.95810000E-04
   +8.18000000E-06  -7.03220000E-04  +2.33810000E-04  -3.06000000E-06  -4.85600000E-05
   +8.07200000E-05  -2.15180000E-04  +1.48602000E-03  +3.72580000E-04  -2.29015600E-02
   +9.47434800E-02  +3.56000000E-05  -1.31300000E-05  -3.13500000E-05  -2.33300000E-04
   +1.40610000E-04  +1.23510000E-04  -7.70000000E-06  -4.52600000E-05  -2.23800000E-05
   -2.05900000E-05  -3.60500000E-05  +6.51000000E-06  +8.88000000E-06  +3.23300000E-05
   +9.79000000E-06  +5.80000000E-06  -2.11000000E-06  +4.25100000E-05  -2.29198000E-03
   -5.37660000E-04  -1.63867000E-03  -1.32489000E-03  +1.07753000E-03  +3.60140000E-04
   -4.12100000E-05  -3.39400000E-05  +5.03000000E-06  -3.28416000E-03  +1.01854000E-02
   -1.24905400E-02  -1.18324200E-02  +1.14214100E-01  -2.83753630E-01  +2.35151000E-03
   +2.30148000E-03  -3.38093000E-03  +2.43740000E-04  +9.87370000E-04  +9.48500000E-04
   +3.76000000E-04  -5.19260000E-04  +1.46560000E-04  +4.14118000E-03  +1.74750000E-03
   -7.61620000E-04  +2.28700000E-05  +2.52820000E-04  +9.75200000E-05  -2.29720000E-04
   -1.94355000E-03  +1.12393000E-03  +5.56000000E-04  -1.60750000E-04  +7.53400000E-05
   -1.09050000E-04  +3.00570000E-04  -2.41800000E-04  +4.10000000E-07  +5.29000000E-06
   -7.10000000E-06  -1.00700000E-05  -4.90000000E-07  -1.01000000E-06  -8.13000000E-06
   +1.28400000E-05  -3.11000000E-06  +2.41000000E-05  +6.27600000E-05  -2.61400000E-05
   -4.39000000E-06  +4.60000000E-07  -6.63000000E-06  -5.28950000E-04  -1.14660000E-04
   +4.28000000E-04  -3.48850000E-04  -5.44720000E-04  +7.31700000E-05  -5.23500000E-04
   +5.09110000E-04  +3.22320000E-04  -4.50800000E-05  +1.51700000E-05  +7.91100000E-05
   +3.00000000E-07  -3.18000000E-05  -4.11400000E-05  +4.89100000E-05  -1.51760000E-04
   -9.85400000E-05  -1.40790000E-04  +3.86570000E-04  -6.35830000E-04  -6.04500000E-05
   -1.15060000E-04  -5.34700000E-05  -7.73830000E-04  +2.60300000E-05  -1.18180000E-04
   +1.45236700E-02  -1.28309550E-01  +2.99433190E-01  +1.33400000E-05  +1.67400000E-05
   +2.92800000E-05  +4.15900000E-05  -1.49520000E-04  +1.39900000E-05  -1.25100000E-05
   +1.57600000E-05  +4.74200000E-05  +4.30900000E-05  +7.00700000E-05  +2.14500000E-05
   -1.53510000E-04  -1.19770000E-04  -1.61700000E-05  +2.88700000E-05  -3.70300000E-05
   -2.84800000E-05  -1.24550000E-04  +1.54160000E-04  -1.02190000E-04  +7.70100000E-05
   -1.99100000E-05  -1.05700000E-05  +1.89480000E-04  +1.23540000E-04  -6.14000000E-06
   +3.97400000E-04  +7.28500000E-05  -6.05800000E-04  -1.32528000E-03  +1.37590000E-04
   +1.27099000E-03  -2.50859000E-03  -3.22070000E-04  +4.68240000E-04  -4.08509400E-02
   +2.35862000E-03  +4.16343300E-02  -3.61371000E-03  +1.50303000E-03  -4.82903000E-03
   -1.32040000E-03  -2.20930000E-04  +1.76124000E-03  -1.56660000E-01  -3.03810000E-04
   +1.71849940E-01  +9.23840000E-04  -1.13410000E-03  +2.21779000E-03  +1.10080000E-04
   -3.51300000E-05  +5.93700000E-05  +6.50670000E-04  +6.92390000E-04  -3.86400000E-05
   -3.56900000E-05  -1.29800000E-05  +5.43000000E-06  +1.99400000E-05  +7.63000000E-06
   -1.39400000E-05  -1.07400000E-05  -7.68000000E-06  +1.30000000E-06  -2.59000000E-05
   -1.03000000E-05  -4.44700000E-05  -4.53000000E-06  +9.77000000E-06  +2.70000000E-07
   +4.82900000E-05  -3.24000000E-05  -5.30000000E-07  -9.16000000E-06  +4.38300000E-05
   -6.20000000E-06  -3.41200000E-05  -7.55000000E-06  -2.27300000E-05  -1.35200000E-05
   +1.40900000E-05  -8.25000000E-06  -1.00200000E-05  +3.70400000E-05  +1.31000000E-05
   +4.85200000E-05  -5.63300000E-05  -3.14800000E-05  -3.41170000E-04  +1.10650000E-04
   -2.34220000E-04  +1.82650000E-04  -2.51900000E-04  -1.84600000E-04  -7.48460000E-04
   -9.89990000E-04  -3.11600000E-04  +2.61470000E-04  -2.38630000E-04  -3.80000000E-06
   +2.03426560E-01  -7.55000000E-06  -1.32600000E-05  +5.78000000E-06  +2.24600000E-05
   +5.18700000E-05  -1.57000000E-06  -6.62000000E-06  -1.32600000E-05  -7.46000000E-06
   -1.32600000E-05  -3.02700000E-05  -8.89000000E-06  +4.37800000E-05  +4.51400000E-05
   +9.24000000E-06  -1.08600000E-05  -3.23000000E-06  +1.54100000E-05  +2.77100000E-05
   -4.69500000E-05  +7.01600000E-05  -2.58000000E-06  +7.00000000E-06  -2.10000000E-07
   -6.32700000E-05  -5.34000000E-05  +4.24000000E-06  -2.71980000E-04  +2.49260000E-04
   -3.82760000E-04  -7.24420000E-04  -5.23440000E-04  +7.32660000E-04  +3.15637000E-03
   -1.04345000E-03  -1.74660000E-04  +6.84612000E-03  -1.56480000E-04  -1.20646300E-02
   +2.59765000E-03  +1.61254000E-03  +1.59137000E-03  +6.02670000E-04  +1.84495000E-03
   -1.79010000E-04  -7.70086000E-03  -1.62012200E-02  +3.08969600E-02  -4.02577000E-03
   -2.80927000E-03  -3.22959000E-03  -2.72700000E-05  +2.68200000E-05  -4.27300000E-05
   +5.38840000E-04  +1.71780000E-04  +8.43000000E-05  +7.21000000E-06  +8.60000000E-06
   -4.75000000E-06  -8.21000000E-06  -1.21000000E-06  +2.38000000E-06  +7.52000000E-06
   +3.24000000E-06  -8.32000000E-06  +7.43000000E-06  +2.46800000E-05  +2.20000000E-06
   -8.18000000E-06  -2.11000000E-06  -7.94000000E-06  -1.19000000E-05  +1.36800000E-05
   +8.00000000E-07  -2.82000000E-06  -2.44400000E-05  +6.89000000E-06  +8.81000000E-06
   +9.90000000E-07  +2.12000000E-06  +7.40000000E-07  -7.06000000E-06  +1.57100000E-05
   -2.59000000E-06  -2.13500000E-05  -1.30000000E-07  -1.54100000E-05  +2.19500000E-05
   +1.59600000E-05  -1.14260000E-04  -2.01530000E-04  -4.50100000E-05  -2.29990000E-04
   -6.45370000E-04  -3.85700000E-05  +3.39140000E-04  +1.20365000E-03  -4.29770000E-04
   +1.48610000E-04  -1.58780000E-04  +9.70000000E-06  -1.94498000E-03  +1.91782400E-02
   -5.19000000E-06  +2.23200000E-05  +2.74300000E-05  +4.84000000E-06  -5.39800000E-05
   -1.95300000E-05  -8.02000000E-06  +8.00000000E-06  +1.81000000E-06  +1.68100000E-05
   +2.32900000E-05  -1.24900000E-05  +2.74000000E-06  -1.14100000E-05  -8.40000000E-06
   -9.96000000E-06  +3.90000000E-06  -8.15000000E-06  +2.51400000E-05  -7.62800000E-05
   -2.87480000E-04  -3.93100000E-05  +1.77700000E-05  +8.27000000E-06  +9.96000000E-06
   +1.18200000E-05  -8.84000000E-06  +5.57210000E-04  -1.11260000E-04  -1.52424000E-03
   +1.71950000E-04  +1.98472000E-03  -9.26820000E-04  -1.12261700E-02  -2.87349000E-03
   -5.08640000E-04  +5.38061000E-03  -3.05425000E-03  +1.22057300E-02  -5.03595000E-03
   +2.16072000E-03  +7.84200000E-05  +1.36707000E-03  -5.93430000E-04  +2.05957000E-03
   +2.16766560E-01  +2.15778900E-02  -3.83007350E-01  +5.21347000E-03  -1.60351000E-03
   +2.43815000E-03  +9.67000000E-05  -4.41600000E-05  +7.21400000E-05  -5.01660000E-04
   -1.35450000E-04  -6.90040000E-04  +2.85000000E-06  -3.82000000E-06  +6.70000000E-06
   +7.57000000E-06  -1.50000000E-06  +1.46000000E-06  +6.30000000E-06  -1.36800000E-05
   +3.42000000E-06  +8.41000000E-06  -1.15000000E-05  +9.49000000E-06  +1.20000000E-07
   -4.52000000E-06  +7.50000000E-06  +1.80000000E-05  +1.32000000E-06  -1.72100000E-05
   +5.28000000E-06  +3.51700000E-05  +1.61300000E-05  -2.71700000E-05  -2.25300000E-05
   -1.28300000E-05  +2.53300000E-05  +2.34000000E-06  -3.87200000E-05  +4.41000000E-06
   +3.55000000E-06  +2.03700000E-05  +2.62000000E-06  -3.13200000E-05  -3.96200000E-05
   -2.76600000E-04  +1.60000000E-05  -1.02750000E-04  -1.15340000E-04  -1.42060000E-04
   -5.98700000E-05  +6.96310000E-04  +5.13910000E-04  -3.33700000E-05  -4.96160000E-04
   +2.84750000E-04  -8.51000000E-06  -2.13083740E-01  -1.96647100E-02  +3.70645330E-01
   -1.08900000E-05  +3.46300000E-05  +2.34300000E-05  +3.15000000E-05  -1.54900000E-04
   -4.20400000E-05  +1.33400000E-05  +3.59900000E-05  +2.06300000E-05  +3.53700000E-05
   +5.13100000E-05  +2.54000000E-06  -8.55300000E-05  -7.88000000E-05  -5.38000000E-06
   +2.53200000E-05  -5.17000000E-06  -3.84300000E-05  +2.91040000E-04  +3.41900000E-04
   +3.23700000E-05  -2.66100000E-05  -5.27100000E-05  +3.52000000E-05  +1.21690000E-04
   +8.55800000E-05  -1.03500000E-05  -7.23390000E-04  +6.04430000E-04  +2.00304000E-03
   +3.24470000E-03  -3.44051000E-03  -1.41592000E-03  -1.74913700E-02  -3.00680600E-02
   +1.03128800E-02  +2.81770000E-04  -3.87840000E-04  -2.83402000E-03  -1.75014000E-03
   +9.47830000E-04  +5.15320000E-04  +1.16834000E-03  +6.17770000E-04  +4.64400000E-05
   -3.27000000E-05  -1.27377000E-03  -9.81950000E-04  -5.42838300E-02  -9.68219400E-02
   +2.43513500E-02  -5.30600000E-05  +7.17500000E-05  +3.28300000E-05  -5.35010000E-04
   -1.18732000E-03  -5.69640000E-04  -1.77800000E-05  -1.05600000E-05  +7.94000000E-06
   +1.83100000E-05  +4.22000000E-06  -6.87000000E-06  -3.36000000E-06  -1.25700000E-05
   +5.38000000E-06  -1.10600000E-05  -3.54700000E-05  -6.87000000E-06  +1.55000000E-06
   +3.14000000E-06  +8.16000000E-06  +7.82800000E-05  -6.23000000E-06  -3.83300000E-05
   -6.70000000E-07  +1.33320000E-04  +7.05000000E-06  -6.46900000E-05  -3.56400000E-05
   -4.57300000E-05  +1.98400000E-05  -7.12000000E-06  -5.99600000E-05  -1.05600000E-05
   +2.15200000E-05  +2.50400000E-05  +2.87000000E-06  +8.25000000E-06  -7.39000000E-06
   -6.80400000E-05  -4.94700000E-05  -1.11990000E-04  +8.93700000E-05  +3.05430000E-04
   -3.31000000E-05  -1.79170000E-03  +9.86290000E-04  +2.53848000E-03  -1.36334000E-03
   +2.65530000E-04  -9.66870000E-04  +9.87550000E-04  +1.70020000E-03  +6.88570000E-04
   +7.21047400E-02  -5.64800000E-05  +9.82000000E-06  +2.73800000E-05  -3.33200000E-05
   +9.37500000E-05  -1.92200000E-05  +4.16000000E-06  -1.35800000E-05  -4.20200000E-05
   -2.17000000E-05  -4.66100000E-05  -1.15500000E-05  +4.47700000E-05  +5.73600000E-05
   +2.55400000E-05  +6.26000000E-06  +6.70000000E-06  -2.17000000E-06  -1.08700000E-05
   -1.79100000E-04  -5.75200000E-05  +3.81500000E-05  +4.26900000E-05  +1.68100000E-05
   -7.21200000E-05  -5.74600000E-05  -1.10000000E-07  +2.38470000E-04  -7.18840000E-04
   +1.19035000E-03  +1.88248000E-03  +1.79024000E-03  -2.40180000E-03  +7.53390000E-04
   +3.97654000E-03  +1.40015000E-03  -3.73370000E-04  -3.14640000E-04  -1.53101000E-03
   -2.96030000E-04  -1.25400000E-04  -5.27060000E-04  +1.46450000E-04  +1.07805000E-03
   -7.31430000E-04  +1.65391000E-03  -3.61960000E-04  -3.84210000E-04  -1.31411610E-01
   -4.99571420E-01  +3.30341900E-02  -7.67000000E-06  +3.31700000E-05  -8.16700000E-05
   +4.90000000E-06  -7.74040000E-04  -2.00190000E-04  +1.10000000E-05  +6.55000000E-06
   -3.71000000E-06  -8.89000000E-06  -4.96000000E-06  +4.45000000E-06  +8.16000000E-06
   +4.85000000E-06  -7.41000000E-06  +3.56000000E-06  +1.50500000E-05  +1.58300000E-05
   -9.84000000E-06  -6.27000000E-06  -4.68000000E-06  -1.39000000E-05  -4.82000000E-06
   -1.57700000E-05  +9.00000000E-07  -2.37400000E-05  +1.08100000E-05  -2.09700000E-05
   -1.86900000E-05  -1.69900000E-05  -4.32000000E-06  -1.87100000E-05  +5.02000000E-06
   -2.44000000E-06  -2.45500000E-05  -1.08100000E-05  -1.78200000E-05  +2.39000000E-05
   +1.73300000E-05  +5.62000000E-06  -1.48030000E-04  +6.25400000E-05  +2.44140000E-04
   +2.64280000E-04  -1.05070000E-04  -8.56440000E-04  +7.39800000E-05  +6.88690000E-04
   -4.27840000E-04  -1.27640000E-04  +2.50060000E-04  -8.95200000E-05  -1.52071000E-03
   +1.66387000E-03  +1.28278260E-01  +4.95950000E-01  -2.47300000E-05  +1.49600000E-05
   +5.58000000E-06  -1.37700000E-05  +2.87900000E-05  -5.41400000E-05  -5.39000000E-06
   +3.14000000E-06  -8.94000000E-06  +5.20000000E-07  -9.74000000E-06  -1.26700000E-05
   +3.40800000E-05  +2.03400000E-05  +6.45000000E-06  -1.23300000E-05  +8.76000000E-06
   -6.24000000E-06  +8.55200000E-05  -5.17000000E-05  +9.43900000E-05  -2.50100000E-05
   +8.83000000E-06  +2.02900000E-05  -4.04700000E-05  -2.30200000E-05  -6.73000000E-06
   -3.44610000E-04  -7.69000000E-06  -4.17220000E-04  -3.05560000E-04  -1.31264000E-03
   +1.76212000E-03  +9.84864000E-03  +2.51933100E-02  -8.20289000E-03  +4.66195000E-03
   +3.11726000E-03  +5.40050000E-04  -6.43820000E-04  -8.57460000E-04  -7.64100000E-04
   +3.73200000E-04  +4.68820000E-04  +7.47600000E-05  -1.72851000E-03  -7.38880000E-04
   -4.38270000E-04  +2.10950500E-02  +4.12641000E-03  -1.87102900E-02  +1.92000000E-06
   +4.69300000E-05  -2.58600000E-05  -1.75390000E-04  -1.50290000E-04  -6.22400000E-05
   +9.97000000E-06  -1.20000000E-07  +3.61000000E-06  -3.70000000E-07  -3.56000000E-06
   +4.82000000E-06  +8.67000000E-06  -4.48000000E-06  -2.18000000E-06  +1.27100000E-05
   -1.20800000E-05  +2.32900000E-05  +1.60000000E-07  -8.09000000E-06  +5.14000000E-06
   +9.93000000E-06  +1.06600000E-05  -2.66500000E-05  +1.68300000E-05  +4.31400000E-05
   +4.75200000E-05  -4.06700000E-05  -4.66200000E-05  -2.04600000E-05  +1.56800000E-05
   -6.70000000E-06  -3.27600000E-05  +8.62000000E-06  -3.11200000E-05  +2.00500000E-05
   -2.89100000E-05  +1.40300000E-05  +3.37000000E-06  -4.28700000E-05  +2.96200000E-05
   -1.71500000E-05  -4.93300000E-05  -4.31070000E-04  -1.30620000E-04  +6.28630000E-04
   -2.05910000E-04  -8.82150000E-04  -2.69910000E-04  +2.47330000E-04  +9.22100000E-05
   +2.69000000E-06  +2.69588000E-03  -6.47620000E-04  -3.30762600E-02  -3.23473500E-02
   +2.76186200E-02  -2.01860000E-04  +6.42000000E-05  -9.77500000E-05  -2.06870000E-04
   +2.52810000E-04  -1.39110000E-04  +4.67840000E-04  +7.87100000E-05  -1.47410000E-04
   -2.78920000E-04  -3.64970000E-04  +1.52730000E-04  +2.45000000E-05  +1.85580000E-04
   +1.76720000E-04  +2.36610000E-04  +1.10910000E-04  -1.00260000E-04  -1.50120000E-04
   -3.27110000E-04  +1.63290000E-04  -3.82000000E-05  -2.38300000E-05  +9.42000000E-06
   -1.57420000E-04  -1.94130000E-04  +5.96900000E-05  -1.89012000E-03  -3.33606000E-03
   +1.80739000E-03  +2.10327000E-03  -1.44480000E-03  -5.60060000E-04  -1.03091000E-03
   +9.02810000E-04  -9.79320000E-04  -2.19284000E-03  +5.73360000E-04  +2.20337000E-03
   +3.86850000E-04  +2.21854000E-03  -1.55123000E-03  +4.26383000E-03  -3.95473000E-03
   +9.08186000E-03  +1.07116000E-03  -4.02960000E-04  -1.82140000E-04  +4.04300000E-05
   +1.37990000E-04  -3.49220000E-04  -8.77800000E-05  +5.08200000E-05  -9.05800000E-05
   -2.58985100E-02  +4.67958600E-02  -8.07898300E-02  -4.38900000E-05  +4.49700000E-05
   -5.18200000E-05  -6.98400000E-05  +3.61600000E-05  -2.42700000E-05  -5.03000000E-06
   +5.45300000E-05  -1.38600000E-05  -2.67600000E-05  -1.33900000E-05  +1.85600000E-04
   -2.27100000E-05  +8.88000000E-06  -5.44700000E-05  +4.51000000E-06  +3.05700000E-05
   +2.47000000E-06  +2.87000000E-06  -1.37500000E-05  -3.01000000E-06  +1.28400000E-05
   -3.98000000E-06  +9.00000000E-08  +4.01200000E-05  +3.72000000E-06  +1.80000000E-06
   -9.53000000E-06  -3.58300000E-05  +2.30600000E-05  -2.45700000E-05  +4.74400000E-05
   +9.87000000E-06  +1.39370000E-04  +7.50820000E-04  +1.61570000E-04  -2.63640000E-04
   -7.92760000E-04  -5.22800000E-04  +1.06800000E-05  +1.04960000E-04  -2.33820000E-04
   +5.25500000E-05  +1.63490000E-04  +2.39700000E-05  -5.62100000E-05  +1.35000000E-06
   +2.26770000E-04  +2.41700000E-05  -9.20800000E-05  +6.61400000E-05  +2.29579800E-02
   +1.01870000E-04  -2.83500000E-05  -6.01800000E-05  -2.88100000E-05  +9.80500000E-05
   -7.61000000E-06  -7.24900000E-05  +3.96700000E-05  -7.97200000E-05  +3.31800000E-05
   +4.21700000E-05  -4.03000000E-05  +2.42830000E-04  +1.21030000E-04  -1.65600000E-05
   -1.21550000E-04  -5.09000000E-06  +4.48800000E-05  -4.36190000E-04  +1.21100000E-05
   +2.13720000E-04  +5.65000000E-05  -2.38600000E-05  -5.71000000E-06  -1.85810000E-04
   -1.71020000E-04  +2.63700000E-05  -3.73192000E-03  -6.32926000E-03  +1.82980000E-03
   +3.49349000E-03  -2.34004000E-03  -1.51143000E-03  -1.33011000E-03  +2.64465000E-03
   -1.12118000E-03  -2.08695000E-03  +2.74210000E-04  +2.56062000E-03  +1.78107000E-03
   +1.64965000E-03  -2.08627000E-03  +3.67896000E-03  -7.88838000E-03  +1.77875500E-02
   +1.41783000E-03  -6.07890000E-04  -2.62840000E-04  -4.11900000E-05  -7.03100000E-05
   -2.20090000E-04  -9.60600000E-05  +2.27900000E-05  +1.18460000E-04  +3.52111300E-02
   -1.68746170E-01  +2.09214850E-01  +1.96600000E-05  +3.32400000E-05  -1.06000000E-05
   +1.53000000E-06  -5.06000000E-06  +1.70800000E-05  +2.67600000E-05  -4.32200000E-05
   +6.07000000E-06  -7.08000000E-05  -1.93100000E-05  +6.42100000E-05  -1.39000000E-05
   +8.22000000E-06  -4.38400000E-05  +3.79300000E-05  +1.18400000E-05  +1.51100000E-05
   +8.58000000E-06  +4.56700000E-05  -3.89600000E-05  -3.27000000E-06  -9.75000000E-06
   -2.23400000E-05  +4.19700000E-05  -4.89800000E-05  -1.09960000E-04  +2.24800000E-05
   +1.96500000E-05  -5.48000000E-06  -1.18000000E-06  +4.65800000E-05  -4.49700000E-05
   +9.90520000E-04  -9.09170000E-04  -4.45330000E-04  -2.48300000E-04  +4.04300000E-05
   -1.05570000E-04  -1.15241000E-03  -7.65050000E-04  +5.68700000E-05  +1.61170000E-04
   +3.29590000E-04  +3.54700000E-05  +3.60000000E-06  +1.16300000E-05  +2.27930000E-04
   -3.30300000E-05  -1.05490000E-04  +2.23700000E-05  -3.59831400E-02  +1.75693220E-01
   +2.34600000E-05  +9.75000000E-05  -4.37800000E-05  +5.34700000E-05  -1.50810000E-04
   -8.28500000E-05  -5.52800000E-05  -2.80600000E-05  +1.71300000E-05  +1.75400000E-05
   +6.36000000E-05  +1.27500000E-05  -5.41600000E-05  -1.87300000E-05  +1.24000000E-05
   +5.84800000E-05  -5.31000000E-06  +2.04400000E-05  -6.55700000E-05  +3.00800000E-05
   +8.00800000E-05  +8.41300000E-05  -4.31200000E-05  +3.57300000E-05  +5.80900000E-05
   +3.73100000E-05  -1.91900000E-05  -1.88530000E-04  -7.24800000E-04  +1.48290000E-04
   -9.73700000E-05  -2.12390000E-04  +6.12320000E-04  +1.79000000E-05  -3.36720000E-04
   -3.15050000E-04  +4.49750000E-04  +4.43400000E-05  -7.09380000E-04  -1.00168000E-03
   -2.06900000E-04  +5.38330000E-04  +3.40099000E-03  +1.66452000E-03  +6.21561000E-03
   -5.58170000E-04  +2.94560000E-04  -8.00000000E-07  -3.45200000E-05  -5.06900000E-05
   +3.55200000E-05  +2.10300000E-05  -4.20000000E-06  +2.01000000E-05  -6.08333400E-02
   +2.11750080E-01  -3.88975380E-01  -7.30000000E-07  -7.35000000E-06  +2.09600000E-05
   +2.58500000E-05  -6.97000000E-06  -2.42000000E-06  +8.80000000E-07  -3.33600000E-05
   +1.80300000E-05  +9.84000000E-06  -1.84500000E-05  +8.18700000E-05  -1.85600000E-05
   +2.36000000E-06  -2.31900000E-05  +2.17300000E-05  -1.66200000E-05  +2.60200000E-05
   +1.51000000E-05  +2.71000000E-05  -1.22600000E-05  -1.45100000E-05  -6.47000000E-06
   -8.84000000E-06  -1.34100000E-05  +9.84000000E-06  +1.71800000E-05  -8.30000000E-06
   +5.16000000E-06  -6.00000000E-07  -5.07000000E-06  -2.34700000E-05  +8.07000000E-06
   +7.89800000E-05  -1.02531000E-03  -2.42330000E-04  -2.52960000E-04  -3.36170000E-04
   -4.22380000E-04  +3.29540000E-04  +3.30300000E-04  -1.84210000E-04  +5.29100000E-05
   +1.44370000E-04  +1.04940000E-04  +5.04900000E-05  +2.03600000E-05  -5.23200000E-05
   +1.11300000E-05  -5.89000000E-06  +1.24800000E-05  +6.36026500E-02  -2.20634950E-01
   +3.92192380E-01  +6.02190000E-04  +7.24100000E-05  -4.65680000E-04  -3.01670000E-04
   -1.03317000E-03  +3.38330000E-04  +1.67130000E-04  +2.04590000E-04  +2.10180000E-04
   +5.80200000E-05  +3.45620000E-04  +7.90200000E-05  +2.50420000E-04  -1.81760000E-04
   -2.83740000E-04  -1.13410000E-04  +2.41540000E-04  -2.34500000E-05  -1.04985000E-03
   +1.80960000E-04  -1.10960000E-03  +3.73380000E-04  -3.45100000E-05  -1.61460000E-04
   +1.13860000E-04  +2.41850000E-04  +3.05700000E-05  +8.47443000E-03  +3.41448000E-03
   -1.53657200E-02  -1.92416600E-02  +1.65592200E-02  +4.49913000E-03  -1.86598900E-02
   -7.41167400E-02  -2.50339300E-02  -1.09295000E-03  -8.69150000E-04  +2.90826500E-02
   +1.55110300E-02  -5.50030000E-04  -4.97043000E-03  -2.27224900E-02  -3.07763900E-02
   +3.98982000E-03  -2.67079000E-03  +1.37530000E-03  -2.41093000E-03  -1.13373000E-03
   +3.96526000E-03  +2.89181000E-03  +9.58970000E-04  -4.21750000E-04  +5.62570000E-04
   -1.57288600E-02  +5.31240700E-02  +6.45393600E-02  +3.29700000E-05  -2.44600000E-05
   +3.02100000E-05  +4.30700000E-05  +3.83700000E-05  +1.03900000E-05  -8.86300000E-05
   -3.66600000E-05  +1.37470000E-04  -1.08280000E-04  -5.16270000E-04  +3.20720000E-04
   +2.72640000E-04  +2.62800000E-05  +1.63060000E-04  +8.31200000E-05  -1.62320000E-04
   +1.07620000E-04  +4.24000000E-05  +1.58810000E-04  -3.70500000E-05  -8.97800000E-05
   -4.40600000E-05  +1.03720000E-04  -1.33980000E-04  +8.69200000E-05  -2.44700000E-05
   +6.05300000E-05  +2.94420000E-04  +9.85000000E-06  +2.55660000E-04  -4.38870000E-04
   -2.44210000E-04  +1.95602000E-03  +3.47073000E-03  -4.14300000E-05  +1.07580000E-04
   -4.91480000E-04  -4.21560000E-04  -3.19768900E-02  +4.37116300E-02  -3.16981000E-03
   -1.54870000E-04  -1.11210000E-04  +2.99570000E-04  +6.21600000E-04  -3.78510000E-04
   -1.06600000E-04  +1.34150000E-04  +9.56980000E-04  -1.06470000E-04  -2.68992000E-03
   +4.56117000E-03  +2.29763000E-03  +2.57309540E-01  +2.58730000E-04  -7.32000000E-06
   -2.20410000E-04  -2.15390000E-04  -8.89350000E-04  +2.63730000E-04  +6.15900000E-05
   +2.23130000E-04  +3.79960000E-04  +7.52800000E-05  +3.80600000E-04  +2.38970000E-04
   -5.02410000E-04  -5.47910000E-04  -2.52160000E-04  +2.33900000E-05  -5.53700000E-05
   -2.74950000E-04  -1.20924000E-03  +4.12450000E-04  -7.78220000E-04  +4.50440000E-04
   -1.50580000E-04  -1.73630000E-04  +8.04060000E-04  +7.03880000E-04  +2.11000000E-05
   +4.13107000E-03  +1.82841000E-03  -7.72885000E-03  -1.74978300E-02  +9.81946000E-03
   +2.75027000E-03  -3.17128500E-02  -6.78146100E-02  -2.33783500E-02  +1.96372000E-03
   -2.70258000E-03  +2.48705300E-02  +8.47956000E-03  -1.44110000E-04  -4.53860000E-03
   -7.88685000E-03  -8.21663000E-03  +2.81520000E-03  -5.99764000E-03  +2.38198000E-03
   -2.77378000E-03  -5.11984000E-03  -7.95060000E-04  +4.65801000E-03  +7.22930000E-04
   -2.84870000E-04  +3.01270000E-04  +2.17808500E-02  +1.68483100E-02  -2.59149600E-02
   -1.00260000E-04  -7.74300000E-05  +3.08400000E-05  +8.00600000E-05  +5.34900000E-05
   -2.60500000E-05  -1.28460000E-04  +2.21000000E-05  +7.90600000E-05  -1.86500000E-04
   -5.22680000E-04  -9.18300000E-05  +3.01750000E-04  +5.40900000E-05  +1.76110000E-04
   +1.67130000E-04  -1.86010000E-04  +1.12810000E-04  +1.85000000E-06  +2.12400000E-04
   -6.03500000E-05  -1.17140000E-04  +3.97000000E-06  +4.52400000E-05  -1.51870000E-04
   +1.49760000E-04  +8.19800000E-05  +1.56600000E-05  +2.44290000E-04  +5.47600000E-05
   +2.68820000E-04  -3.91080000E-04  -1.48900000E-04  +7.97070000E-04  +1.36909000E-03
   -4.61700000E-05  +1.65820000E-04  -2.74500000E-04  -4.00930000E-04  +6.37631000E-03
   -1.65521900E-02  -6.81574000E-03  -3.18810000E-04  -5.04820000E-04  +1.98090000E-04
   +7.62740000E-04  -1.00321000E-03  -2.73710000E-04  -1.00758000E-03  +3.66330000E-04
   +1.36200000E-04  +2.91727000E-03  -3.75158000E-03  -2.74054000E-03  -2.07987210E-01
   +5.12191410E-01  +4.31230000E-04  -1.29990000E-04  -5.15610000E-04  +3.53700000E-05
   +9.36400000E-05  +1.27190000E-04  -6.56500000E-05  +8.20400000E-05  +3.29720000E-04
   -4.33800000E-05  +4.89000000E-05  +2.29670000E-04  -3.36940000E-04  -2.36610000E-04
   -1.24550000E-04  -5.16000000E-05  -2.01640000E-04  +4.51900000E-05  -3.15270000E-04
   +4.08520000E-04  +2.27080000E-04  +1.09770000E-04  -1.37450000E-04  -1.18630000E-04
   +3.33050000E-04  +2.40660000E-04  +7.16500000E-05  -1.91026000E-03  -2.08990000E-03
   +5.62744000E-03  +4.95939000E-03  -3.89879000E-03  -1.07988000E-03  +3.32876000E-03
   +1.48621200E-02  +1.46144700E-02  +3.78365000E-03  -2.23548000E-03  -1.19148900E-02
   -1.13266500E-02  -3.42080000E-04  +4.03952000E-03  +1.67414200E-02  +2.23016400E-02
   -9.19450000E-04  -1.58411000E-03  +3.89830000E-04  +9.75070000E-04  -2.67798000E-03
   -4.19862000E-03  +9.80760000E-04  -9.18300000E-05  +8.36900000E-05  -1.98970000E-04
   +4.03258300E-02  -5.07487700E-02  -6.10318000E-02  -9.42400000E-05  -1.00500000E-05
   -2.08700000E-05  -2.84000000E-06  +4.04900000E-05  -2.51200000E-05  -6.38800000E-05
   +6.98800000E-05  -2.25000000E-06  -4.49000000E-06  -2.58600000E-04  -4.74500000E-05
   +1.21960000E-04  +6.41200000E-05  -1.81100000E-05  +3.70400000E-05  -4.05000000E-06
   +6.25700000E-05  -2.42700000E-05  +1.66800000E-05  -1.00400000E-05  +1.91700000E-05
   +1.58000000E-05  +5.28200000E-05  -3.02200000E-05  +5.94300000E-05  +1.45520000E-04
   -2.51500000E-05  -3.45100000E-05  +3.77500000E-05  +1.29100000E-05  +5.33000000E-06
   +6.81300000E-05  -1.42556000E-03  -2.39778000E-03  -1.06140000E-04  -3.51400000E-05
   +2.42250000E-04  +1.43680000E-04  -9.07277000E-03  -1.94481800E-02  -2.81934300E-02
   -2.86700000E-05  -2.49430000E-04  +1.53570000E-04  +7.53000000E-05  -4.17900000E-05
   -3.15390000E-04  -1.00669000E-03  -4.79650000E-04  +9.45100000E-05  +1.57421000E-03
   -3.73995000E-03  +1.37210000E-04  +1.31168200E-02  -6.18881300E-02  +1.58203800E-01
   -2.32000000E-06  +4.00600000E-05  -1.23120000E-04  +1.41250000E-04  +5.16330000E-04
   +2.54300000E-05  -1.60670000E-04  -3.66800000E-05  +1.60630000E-04  +6.31300000E-05
   -2.06800000E-05  +9.48400000E-05  -6.56570000E-04  -2.77160000E-04  +7.85500000E-05
   +2.29000000E-05  -4.91970000E-04  +4.25300000E-05  +7.25200000E-05  +2.28800000E-04
   +4.63350000E-04  -4.62000000E-05  -9.83500000E-05  -4.91200000E-05  +4.70350000E-04
   +2.72700000E-04  +1.03400000E-05  -3.03198000E-03  -2.36859000E-03  +6.07309000E-03
   +7.97772000E-03  -6.46435000E-03  -1.87222000E-03  +4.84694000E-03  +1.95225600E-02
   +7.46676000E-03  +3.10620000E-03  -2.47740000E-03  -1.25240500E-02  -1.07829200E-02
   +5.62330000E-04  +2.43660000E-03  +2.47727000E-02  +2.26557400E-02  -7.68567000E-03
   -1.75108000E-03  +8.10440000E-04  +1.03753000E-03  -3.92080000E-04  -1.26127000E-03
   +1.02780000E-04  -2.94840000E-04  +1.27350000E-04  -3.67850000E-04  -3.57014100E-02
   -2.18050800E-02  -1.15533600E-02  -1.24520000E-04  -2.90000000E-05  -1.45600000E-05
   +9.36000000E-06  +8.13000000E-06  -3.40300000E-05  -1.94800000E-05  +5.29700000E-05
   -7.02200000E-05  +1.76740000E-04  -3.30000000E-07  -4.53040000E-04  -1.86400000E-05
   +4.09500000E-05  -9.67900000E-05  -4.34000000E-06  +4.83600000E-05  +2.03200000E-05
   -6.17300000E-05  -7.82200000E-05  +1.90800000E-05  +6.46900000E-05  +3.76400000E-05
   +1.74700000E-05  -8.61000000E-06  +4.23600000E-05  +2.12950000E-04  -5.80800000E-05
   -1.32910000E-04  +2.01500000E-05  -4.77400000E-05  +1.05200000E-04  +1.72220000E-04
   -2.59655000E-03  -4.80535000E-03  -4.28680000E-04  -1.41280000E-04  +1.49410000E-04
   +1.69450000E-04  -3.02395500E-02  -2.94748500E-02  +9.87689000E-03  +4.77800000E-05
   -1.12900000E-05  +1.48770000E-04  -1.70990000E-04  -1.23930000E-04  -2.81980000E-04
   -2.28830000E-04  -4.52000000E-04  -1.34400000E-05  +3.74172000E-03  -7.13038000E-03
   -8.27400000E-03  -8.25499000E-03  +8.62666000E-03  -1.38411100E-02  +5.31185300E-02
   +2.39200000E-05  -5.12200000E-05  +8.69100000E-05  +4.21100000E-05  -1.23090000E-04
   -2.33600000E-05  +1.18860000E-04  -6.72800000E-05  -2.32440000E-04  -6.07100000E-05
   -8.78200000E-05  -1.62310000E-04  +3.53260000E-04  +2.79980000E-04  +1.44650000E-04
   +2.47000000E-05  +2.03380000E-04  +9.65100000E-05  +4.30380000E-04  -2.07250000E-04
   -2.70590000E-04  -1.26720000E-04  +1.17260000E-04  +5.70000000E-05  -3.82790000E-04
   -2.99130000E-04  -1.90100000E-05  +3.07999000E-03  +1.63688000E-03  -4.54793000E-03
   -6.19152000E-03  +4.33295000E-03  +1.63464000E-03  -4.32469000E-03  -1.55922000E-02
   -5.65358000E-03  -3.02327000E-03  +1.19500000E-03  +8.17010000E-03  +6.56619000E-03
   +4.68310000E-04  -1.77937000E-03  -5.80012000E-03  -2.16894400E-02  -8.16384000E-03
   +1.42060000E-03  -5.58540000E-04  -5.33080000E-04  +1.18995000E-03  +1.75286000E-03
   -3.48960000E-04  +5.48900000E-05  -4.15900000E-05  +9.81600000E-05  +1.54567000E-03
   -3.13065500E-02  +1.58423300E-02  +7.81300000E-05  +3.12300000E-05  +4.12000000E-06
   -1.68500000E-05  -2.32800000E-05  +1.65600000E-05  +3.11600000E-05  -4.02900000E-05
   +1.92400000E-05  +4.95000000E-06  +2.31380000E-04  +2.55140000E-04  -1.20980000E-04
   -2.78300000E-05  -6.96600000E-05  -5.06100000E-05  +2.80000000E-05  -4.71900000E-05
   +2.32300000E-05  -2.70300000E-05  +1.94500000E-05  +3.97000000E-06  -1.53700000E-05
   +5.42000000E-06  +1.59000000E-06  -3.43400000E-05  -3.68500000E-05  +1.71700000E-05
   +1.52400000E-05  -2.50500000E-05  -3.36600000E-05  +2.79000000E-06  -2.04400000E-05
   -2.03420000E-04  -3.74590000E-04  -3.52100000E-05  +9.23400000E-05  -9.53700000E-05
   -5.68000000E-06  +6.93175000E-03  +2.62827800E-02  +1.11531400E-02  +2.58900000E-05
   +1.38800000E-04  -1.26690000E-04  +1.76900000E-05  +1.17900000E-04  +1.50830000E-04
   +3.10780000E-04  +3.62870000E-04  -4.31900000E-05  -9.03101000E-03  +1.04879000E-02
   +1.25233300E-02  -2.30992300E-02  -5.46337600E-02  +2.48477500E-02  +2.01859000E-02
   +8.32850600E-02  -6.51960000E-04  +2.29290000E-04  +1.13242000E-03  +1.09200000E-04
   -2.95730000E-04  -1.14490000E-04  +8.11000000E-05  -1.09550000E-04  -5.25750000E-04
   +1.73700000E-04  +1.48800000E-05  -4.17510000E-04  +4.20970000E-04  +2.99840000E-04
   +1.89940000E-04  +9.10300000E-05  +1.44260000E-04  -1.36480000E-04  +4.17640000E-04
   -1.52630000E-04  -5.49930000E-04  -1.69340000E-04  +2.09450000E-04  +1.05760000E-04
   -3.69100000E-04  -2.82710000E-04  -1.26250000E-04  +3.74790000E-03  +3.75454000E-03
   -8.38515000E-03  -9.90453000E-03  +8.19934000E-03  +1.93045000E-03  -7.62398000E-03
   -2.83217600E-02  -1.13350500E-02  -6.67484000E-03  +2.76787000E-03  +1.93661000E-02
   +1.56277400E-02  +8.49300000E-04  -4.91382000E-03  -2.91580300E-02  -3.99843800E-02
   +2.98847000E-03  +3.00622000E-03  -1.16503000E-03  -1.67266000E-03  +1.15207000E-03
   +2.75299000E-03  -7.34650000E-04  +2.16740000E-04  -1.67260000E-04  +5.12180000E-04
   -6.84989000E-03  +5.05282600E-02  +4.20918000E-03  +1.29120000E-04  +6.80000000E-06
   +3.47900000E-05  +2.47800000E-05  -5.90000000E-05  +3.06600000E-05  +1.09320000E-04
   -1.34410000E-04  -5.62000000E-06  -1.46590000E-04  +5.43670000E-04  -4.13560000E-04
   -1.85250000E-04  -8.53600000E-05  -7.11000000E-06  -3.37500000E-05  -1.91600000E-05
   -9.69700000E-05  +1.61000000E-05  -1.59800000E-05  +1.59500000E-05  -3.02100000E-05
   -1.09500000E-05  -1.10130000E-04  +7.05600000E-05  -8.95100000E-05  -3.26300000E-04
   +4.53100000E-05  +8.75200000E-05  -4.28500000E-05  +2.67800000E-05  -4.82700000E-05
   -2.28030000E-04  +2.66612000E-03  +4.79888000E-03  +5.46730000E-04  +1.50040000E-04
   -2.91010000E-04  -2.58210000E-04  +3.12645200E-02  +4.25740300E-02  +2.28030000E-04
   -6.06000000E-06  +1.56410000E-04  -2.80670000E-04  +1.39720000E-04  +1.69390000E-04
   +5.43180000E-04  +5.60990000E-04  +6.03590000E-04  +2.05400000E-05  +5.22711000E-03
   -6.54660000E-04  -8.11811000E-03  -1.89210600E-02  -8.71751000E-03  -3.66092100E-02
   +2.70714700E-02  -3.83950300E-02  +2.89006800E-02  +1.04730000E-04  -1.05000000E-06
   -1.06840000E-04  -2.43000000E-06  +2.97300000E-05  -3.67000000E-06  +7.90000000E-07
   -1.94100000E-05  +4.84000000E-06  -1.01100000E-05  -1.39100000E-05  +5.61000000E-06
   +6.30000000E-06  +1.33200000E-05  +1.36900000E-05  +1.01700000E-05  +7.35000000E-06
   +8.38000000E-05  +1.45300000E-05  -4.12300000E-05  +5.71000000E-06  -8.05000000E-06
   -1.45000000E-05  +6.08000000E-06  -2.43500000E-05  -4.73500000E-05  +1.00500000E-05
   +1.16410000E-04  +5.56770000E-04  -3.03100000E-05  -1.35823000E-03  +2.70140000E-04
   +2.69170000E-04  -2.92531000E-03  -4.17615000E-03  -2.11480000E-03  +8.59430000E-04
   -6.26230000E-04  +1.49935000E-03  +3.09110000E-04  -1.62060000E-04  -3.55950000E-04
   -7.45000000E-06  +2.47870000E-04  -4.01400000E-05  -1.08182000E-03  +6.58500000E-04
   -2.11810000E-04  -4.75690000E-04  -7.66900000E-05  +3.22770000E-04  -2.67500000E-05
   +6.49000000E-06  -1.96900000E-05  -5.92500000E-04  -9.20890000E-04  +3.50747000E-03
   -1.12900000E-05  +8.03000000E-06  -5.15000000E-06  -4.84000000E-06  +9.60000000E-07
   -6.05000000E-06  -2.04000000E-06  +8.80000000E-07  -2.45000000E-06  +5.30000000E-05
   -2.88200000E-05  +8.49900000E-05  -4.25100000E-05  +1.15900000E-05  -4.60900000E-05
   +2.47000000E-06  +5.77000000E-06  -3.19000000E-06  -2.45000000E-06  -2.40000000E-07
   +3.92000000E-06  +2.54000000E-06  -2.74000000E-06  -6.00000000E-08  +1.15000000E-06
   +2.20000000E-06  +7.82000000E-06  -6.01000000E-06  -8.33000000E-06  -1.58000000E-06
   -5.52000000E-06  +1.00200000E-05  +1.02000000E-05  +1.75100000E-05  +4.38000000E-06
   -3.75700000E-05  +2.34700000E-05  -1.56000000E-06  -1.09100000E-05  +1.63624100E-02
   -6.86629000E-03  +3.74063000E-03  -4.62900000E-05  -5.26000000E-05  -2.15500000E-05
   -4.19500000E-05  -3.61410000E-04  -9.17700000E-05  -1.21320000E-04  -2.36000000E-06
   +6.69200000E-05  -2.35630000E-04  +8.75260000E-04  +7.94570000E-04  -1.61216030E-01
   +2.20907170E-01  -4.09471800E-02  -3.83711000E-03  +9.89054000E-03  -1.18216700E-02
   +1.54201660E-01  +5.97800000E-05  +4.29000000E-06  -4.53700000E-05  -9.30000000E-06
   +1.17510000E-04  -1.41900000E-05  -6.17000000E-06  -1.40900000E-05  -3.34200000E-05
   -2.60300000E-05  -5.66400000E-05  -2.12400000E-05  +1.82870000E-04  +1.29750000E-04
   -2.64000000E-06  -3.47900000E-05  +2.05800000E-05  +8.10300000E-05  +1.58440000E-04
   -9.88000000E-05  +6.32200000E-05  -6.70400000E-05  +3.33000000E-06  +2.07200000E-05
   -2.04330000E-04  -1.57830000E-04  +1.25300000E-05  -2.98980000E-04  +6.26730000E-04
   +9.62080000E-04  -4.60960000E-04  -2.52990000E-04  -2.18600000E-04  -1.78905000E-03
   -4.36280000E-04  -3.73440000E-04  -5.33040000E-04  -3.25620000E-04  +3.31010000E-04
   +5.05240000E-04  +4.38190000E-04  -3.76130000E-04  -1.27360000E-04  -1.96200000E-05
   -3.88160000E-04  +1.34710000E-04  +5.03900000E-05  -4.67400000E-05  -2.43800000E-04
   -3.30280000E-04  +2.26300000E-05  -1.10930000E-04  +4.69000000E-05  -4.83800000E-05
   -1.64922000E-03  +1.37016000E-03  +1.43886000E-03  +2.64300000E-05  +2.15200000E-05
   -9.26000000E-06  -1.92700000E-05  -3.75000000E-06  +9.55000000E-06  +1.31600000E-05
   -1.90000000E-07  -1.94000000E-06  +7.01900000E-05  -4.18100000E-05  +4.28800000E-05
   -1.03000000E-05  -1.50000000E-07  -1.87600000E-05  -2.13100000E-05  +2.78800000E-05
   -1.75900000E-05  +9.12000000E-06  -1.00900000E-05  +9.45000000E-06  +1.19500000E-05
   -9.14000000E-06  -2.09000000E-06  +2.06400000E-05  -2.27700000E-05  -1.50500000E-05
   +3.06000000E-06  -2.97800000E-05  -8.40000000E-06  -4.41800000E-05  +5.79500000E-05
   +2.22300000E-05  -2.44700000E-05  +3.88800000E-05  +7.33000000E-06  +1.17200000E-05
   -1.93800000E-05  +7.41000000E-06  +1.26574900E-02  -1.34497600E-02  +4.36927000E-03
   -2.22700000E-05  -4.32000000E-05  -6.48200000E-05  -1.67260000E-04  -1.13910000E-04
   +1.64700000E-05  -1.39420000E-04  +1.05000000E-05  +5.49200000E-05  +4.78790000E-04
   +2.35650000E-04  -4.07550000E-04  +2.08243140E-01  -3.87759490E-01  +8.88986700E-02
   +3.50592000E-03  -5.67460000E-03  +3.09610000E-04  -2.20083190E-01  +4.05669950E-01
   +1.58300000E-05  +1.46000000E-05  -9.27900000E-05  -1.79200000E-05  +3.02100000E-05
   -5.89000000E-06  -2.50000000E-07  -2.30000000E-07  -1.49500000E-05  -1.21800000E-05
   -1.71400000E-05  -1.78000000E-05  +5.36300000E-05  +2.67000000E-05  +6.20000000E-06
   -1.50000000E-05  +4.88800000E-05  +5.60300000E-05  +2.34400000E-05  -5.79900000E-05
   -2.43100000E-05  -3.00100000E-05  +7.99000000E-06  +1.13000000E-06  -7.75900000E-05
   -4.68500000E-05  -7.81000000E-06  +3.32000000E-05  -4.89300000E-05  +4.23200000E-05
   +1.57780000E-04  -1.04170000E-04  +1.47840000E-04  -5.34110000E-04  -2.53860000E-04
   +6.64600000E-04  -2.55260000E-04  -1.79680000E-04  +4.70050000E-04  +1.16520000E-04
   +6.26400000E-04  -1.43220000E-04  +3.94960000E-04  +3.56750000E-04  +2.83790000E-04
   +3.63000000E-06  +1.38010000E-04  -1.47520000E-04  +1.86630000E-04  -7.54000000E-06
   -4.51540000E-04  -2.12900000E-05  +4.94000000E-06  -4.43000000E-06  +2.85893000E-03
   -1.54100000E-05  -7.44825000E-03  +1.48700000E-05  +8.10000000E-07  +5.01000000E-06
   -3.18000000E-06  -5.93000000E-06  +4.34000000E-06  +5.52000000E-06  -3.88000000E-06
   +2.88000000E-06  +8.62300000E-05  -3.10100000E-05  +6.45100000E-05  -1.98500000E-05
   -5.71000000E-06  -9.30000000E-07  -1.05900000E-05  +1.51900000E-05  -4.08000000E-06
   +5.71000000E-06  -3.82000000E-06  +6.16000000E-06  +7.72000000E-06  -1.34100000E-05
   +8.33000000E-06  +1.28900000E-05  -5.58000000E-06  -1.65000000E-05  +5.06000000E-06
   -1.07200000E-05  +3.26000000E-06  -1.43000000E-05  +1.78300000E-05  -3.07000000E-06
   -2.35800000E-05  +2.09200000E-05  +2.48900000E-05  -3.81800000E-05  -1.40800000E-04
   -8.69400000E-05  -1.41154000E-03  -1.61280000E-04  -1.65754000E-03  -5.81800000E-05
   -5.18400000E-05  -2.46100000E-05  -7.97300000E-05  -1.89900000E-05  +1.85070000E-04
   +2.90000000E-05  -2.93100000E-05  +1.93600000E-05  +1.13120000E-03  -9.72860000E-04
   -1.15474000E-03  -4.99229100E-02  +1.10029630E-01  -4.51155400E-02  +1.96205000E-03
   -1.45858300E-02  +1.46534600E-02  +4.54408400E-02  -9.45660900E-02  +3.97732300E-02
end_hess

