# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -883.27935600    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -3.24122888E+00  -1.06227925E+00  -1.80503604E+00
   006   -3.15647301E+00  +1.12446032E+00  -3.33819520E-01
   006   -5.22519721E+00  +1.62835408E+00  +1.19672440E+00
   006   -7.31050327E+00  +3.42885580E-02  +1.25346906E+00
   006   -7.35553259E+00  -2.11705563E+00  -2.37557531E-01
   006   -5.29702419E+00  -2.66507821E+00  -1.77321136E+00
   006   -8.55797228E-01  +2.87217718E+00  -5.15945855E-01
   006   -8.92916266E-01  +4.17361135E+00  -3.10635015E+00
   008   -9.33710830E+00  -3.75162404E+00  -2.64257727E-01
   006   +1.54551958E+00  +1.34144148E+00  -1.61521683E-01
   006   +3.52593085E+00  +1.20198958E+00  -1.74282822E+00
   006   +5.59488683E+00  -4.44745952E-01  -9.89961451E-01
   006   +6.21070586E+00  -4.19296238E-01  +1.68227689E+00
   006   +4.22506898E+00  -2.95242127E-01  +3.31593018E+00
   006   +1.82753185E+00  -2.88673102E-01  +2.06211748E+00
   008   +8.59281278E+00  -8.50768036E-01  +2.38645368E+00
   008   +7.68993145E+00  -7.40195176E-01  -2.59384863E+00
   006   -8.86139892E-01  +4.94041946E+00  +1.52331590E+00
   008   +1.83885004E+00  -3.34126007E+00  +3.18109100E-01
   001   -1.06204069E+01  -3.16734139E+00  +8.67356111E-01
   001   -8.89902771E+00  +4.77988316E-01  +2.46915464E+00
   001   -5.25540353E+00  +3.28770999E+00  +2.38723376E+00
   001   -1.63181862E+00  -1.55016456E+00  -2.96723343E+00
   001   -5.32596454E+00  -4.36118465E+00  -2.91213327E+00
   001   -2.63214855E+00  +5.25835022E+00  -3.30864731E+00
   001   +6.97822796E-01  +5.47148989E+00  -3.30837928E+00
   001   -8.22584219E-01  +2.80264103E+00  -4.64188976E+00
   001   -9.39795399E-01  +4.14425470E+00  +3.42397703E+00
   001   +8.23668908E-01  +6.07727886E+00  +1.36668619E+00
   001   -2.50790652E+00  +6.19314161E+00  +1.29830728E+00
   001   +1.55104239E-01  -5.52643612E-01  +3.21070177E+00
   001   +4.40816472E+00  -6.15150011E-01  +5.32038568E+00
   001   +3.92452810E+00  -2.43030423E+00  -6.58893987E-01
   001   +3.55470416E+00  +2.05609134E+00  -3.60057952E+00
   001   +9.57323830E+00  -9.61909164E-01  +8.51164222E-01
   001   +8.13337520E+00  +8.65928188E-01  -3.30089070E+00
   001   +2.39033285E+00  -4.53573126E+00  +1.56355245E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +8.00000000E-08  +1.20000000E-07  -3.10000000E-07
   -4.00000000E-08  -6.60000000E-07  +2.00000000E-08
   -1.90000000E-07  -8.90000000E-07  +6.00000000E-08
   +3.00000000E-08  -1.18000000E-06  -3.20000000E-07
   +4.00000000E-07  -8.90000000E-07  -8.00000000E-07
   +4.40000000E-07  -3.20000000E-07  -7.40000000E-07
   -4.60000000E-07  -1.00000000E-08  +1.30000000E-07
   -4.00000000E-07  +3.40000000E-07  +5.70000000E-07
   +5.80000000E-07  -1.25000000E-06  -1.04000000E-06
   -2.60000000E-07  +4.00000000E-08  +8.30000000E-07
   +7.00000000E-07  +6.00000000E-07  +0.00000000E+00
   +1.30000000E-06  +2.10000000E-06  -3.80000000E-07
   -2.80000000E-07  +1.50000000E-07  +3.00000000E-08
   +3.90000000E-07  +5.20000000E-07  +1.80000000E-07
   +5.00000000E-08  +4.10000000E-07  +4.10000000E-07
   +1.00000000E-07  +6.80000000E-07  +1.40000000E-07
   +4.60000000E-07  +1.88000000E-06  +2.60000000E-07
   -7.30000000E-07  -3.90000000E-07  +7.80000000E-07
   +5.60000000E-07  -5.30000000E-07  -1.82000000E-06
   +4.20000000E-07  -1.52000000E-06  -1.07000000E-06
   -9.00000000E-08  -1.61000000E-06  -3.20000000E-07
   -4.40000000E-07  -1.07000000E-06  +3.00000000E-07
   +5.70000000E-07  +2.10000000E-07  -4.70000000E-07
   +7.70000000E-07  -1.80000000E-07  -1.06000000E-06
   -4.70000000E-07  +3.30000000E-07  +8.00000000E-07
   -5.20000000E-07  +6.80000000E-07  +8.90000000E-07
   -2.20000000E-07  +7.40000000E-07  +4.00000000E-07
   -6.50000000E-07  -7.10000000E-07  +6.30000000E-07
   -7.70000000E-07  -1.20000000E-07  +1.06000000E-06
   -8.00000000E-07  -5.30000000E-07  +9.10000000E-07
   -2.00000000E-08  -4.30000000E-07  -1.60000000E-07
   -3.00000000E-08  -4.60000000E-07  -2.00000000E-08
   -1.21000000E-06  -3.60000000E-07  -5.00000000E-08
   +0.00000000E+00  +1.19000000E-06  +4.60000000E-07
   +1.80000000E-07  +1.16000000E-06  +4.00000000E-08
   -4.00000000E-08  +1.63000000E-06  +1.70000000E-07
   +5.80000000E-07  +3.70000000E-07  -5.00000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.53594350E-01  +1.14101490E-01  +5.40721300E-01  -1.95231020E-01  +2.05432790E-01
   +3.93231200E-01  -1.19274280E-01  -4.00217800E-02  -2.00224000E-03  +5.65302200E-01
   +1.18842500E-02  -2.38188710E-01  -1.21379640E-01  +7.82249200E-02  +5.16554280E-01
   +3.65933600E-02  -9.31051500E-02  -1.54173700E-01  -1.65582000E-01  +1.83605150E-01
   +4.05532620E-01  +3.28413400E-02  +6.86415700E-02  +3.57902700E-02  -2.43538270E-01
   -9.84709000E-03  +9.43964500E-02  +5.83579940E-01  +2.85954800E-02  +5.15271000E-03
   -1.72870700E-02  +4.19276100E-02  -1.21718580E-01  -6.22384000E-02  +1.19646600E-01
   +5.78440990E-01  +6.80865000E-03  -3.97693900E-02  -2.39138300E-02  +1.30696050E-01
   -3.42999400E-02  -1.64700330E-01  -1.68377510E-01  +2.40816730E-01  +4.06597790E-01
   -1.76210400E-02  -2.95001600E-02  -1.25276000E-02  -4.71821000E-02  +7.77825000E-03
   +3.63022500E-02  -2.50494060E-01  -1.44740710E-01  +6.74456000E-03  +6.27331360E-01
   -2.54553700E-02  -5.27836000E-02  -2.14198100E-02  -3.26443500E-02  +4.58444100E-02
   +4.45084900E-02  -9.20738600E-02  -1.88883030E-01  -3.80585800E-02  +1.18826930E-01
   +5.37399650E-01  -9.87393000E-03  -1.83344900E-02  -1.11906300E-02  +7.98680000E-03
   +2.27382000E-02  +1.81795300E-02  +4.31620700E-02  -9.13264000E-03  -8.99490800E-02
   -2.01869770E-01  +2.24536960E-01  +3.96530570E-01  -5.14509200E-02  -3.75373500E-02
   +2.69380000E-03  -1.52050400E-02  +2.79140200E-02  +2.58079300E-02  +3.66303000E-02
   -1.48197700E-02  -2.96381300E-02  -1.24331310E-01  -3.77014500E-02  +5.29267000E-03
   +6.23484270E-01  +6.89883000E-03  +5.09917500E-02  +3.07719400E-02  +2.61468600E-02
   -3.09067100E-02  -3.21995500E-02  -5.99389300E-02  -3.87050100E-02  +4.77145000E-03
   +2.54189100E-02  -2.42408720E-01  -1.37120330E-01  +1.14513980E-01  +5.62572390E-01
   +3.49672100E-02  +5.51803800E-02  +2.14622400E-02  +2.41030200E-02  -3.32452300E-02
   -4.27329300E-02  -6.18467400E-02  -2.02396600E-02  +2.19714400E-02  +4.96810900E-02
   -1.01032990E-01  -1.68202950E-01  -1.78870510E-01  +2.15687970E-01  +4.14897890E-01
   -2.65060280E-01  -1.01716650E-01  +4.41052300E-02  +2.95373500E-02  -5.64127400E-02
   -5.33397900E-02  -6.28136500E-02  -1.41728200E-02  +2.31814700E-02  +3.26821300E-02
   +6.23387100E-02  +2.98737700E-02  -2.22707730E-01  -1.20767000E-03  +8.47841400E-02
   +6.03951170E-01  -1.55362510E-01  -2.02506850E-01  -1.17900100E-02  -1.73369000E-02
   -3.37458500E-02  -1.92107500E-02  -1.50143000E-02  -5.70517000E-03  +6.22224000E-03
   +2.59334200E-02  +8.26350000E-03  -1.47284000E-02  +5.99283200E-02  -1.30228740E-01
   -7.48289000E-02  +1.39126870E-01  +5.99708900E-01  +6.53952000E-03  -4.19522100E-02
   -9.34160300E-02  -2.40839300E-02  +3.07023000E-03  +2.43037600E-02  +2.33576000E-02
   +5.75618000E-03  -1.17861800E-02  +4.02824000E-03  -3.54648700E-02  -1.88405700E-02
   +1.26250830E-01  -4.00683600E-02  -1.69585610E-01  -1.67591550E-01  +2.45630070E-01
   +3.92005700E-01  -7.74900000E-04  -8.64759000E-03  -4.71941000E-03  -1.36745150E-01
   -4.15156300E-02  +1.15341300E-02  -1.91678600E-02  -1.43543800E-02  +2.66309000E-03
   +3.81400000E-04  +2.49260000E-04  +4.10256000E-03  -2.47478000E-03  +1.22250000E-04
   +9.02830000E-04  +3.80653000E-03  +1.23869000E-03  +1.65390000E-03  +4.77942570E-01
   -2.32366800E-02  -1.77768300E-02  +7.20350000E-04  -4.59959700E-02  -1.15119770E-01
   -4.30046000E-03  +5.17920000E-04  +8.16867000E-03  +3.04309000E-03  +1.20470000E-03
   +2.08852000E-03  -4.06023000E-03  -1.92860000E-04  -1.09017000E-03  -4.04060000E-04
   +7.22230000E-04  -9.56020000E-04  -4.50002000E-03  -4.96299000E-03  +4.81100530E-01
   -1.56993700E-02  -8.89767000E-03  +4.89769000E-03  +9.05421000E-03  -6.18353000E-03
   -7.88552500E-02  +1.17231100E-02  +1.14963900E-02  +2.40525000E-03  +4.22492000E-03
   -2.77033000E-03  +2.41205000E-03  +4.84330000E-04  -1.13658000E-03  -1.54481000E-03
   +1.43479000E-03  -5.67560000E-03  +6.06630000E-04  -9.07860000E-04  -1.62200000E-03
   +4.82305190E-01  -5.65910000E-04  -5.49360000E-04  +8.88850000E-04  -3.95970000E-03
   -1.42923600E-02  +2.50114000E-02  -2.63200000E-04  -1.93794000E-03  -4.60490000E-04
   -1.40854000E-03  -2.52520000E-04  -1.37740000E-03  +3.40700000E-04  +1.06890000E-03
   +6.08330000E-04  -2.84600000E-05  +7.02230000E-04  -7.51400000E-05  -7.50452700E-02
   -5.64850000E-04  +1.13928000E-03  +5.85014150E-01  -8.87510000E-04  -4.67220000E-04
   +9.73090000E-04  -6.88042000E-03  -1.41773000E-02  +1.98759400E-02  +1.44079000E-03
   -1.11074000E-03  -4.45910000E-04  -8.10470000E-04  -5.31370000E-04  -1.00607000E-03
   -3.42100000E-05  +8.48720000E-04  +6.69540000E-04  +2.20380000E-04  +7.55450000E-04
   -2.21220000E-04  +2.80966000E-03  -9.47786600E-02  +4.18558300E-02  -1.31733000E-03
   +5.59505440E-01  -1.60580000E-03  -1.20285000E-03  -2.09410000E-04  +8.49213000E-03
   +8.76782000E-03  -4.90262000E-03  -1.08301000E-03  -1.33910000E-04  -1.81700000E-05
   -5.32200000E-05  -2.92010000E-04  -6.38400000E-05  +7.09200000E-05  +3.24880000E-04
   +3.78630000E-04  +3.30460000E-04  -1.42520000E-04  -2.14660000E-04  -3.86653000E-03
   +3.85650800E-02  -1.55395520E-01  -2.81486000E-03  +5.40968000E-02  +4.92302270E-01
   +3.56402000E-03  +6.40868000E-03  +5.23130000E-03  -8.99060000E-04  -4.61783000E-03
   -4.56145000E-03  -8.84940000E-04  -1.05268000E-03  +4.08908000E-03  -7.26321000E-03
   -1.41711700E-02  -2.69830000E-04  -2.15758860E-01  -1.33733590E-01  +3.18672000E-03
   -4.70810300E-02  -3.25008500E-02  +8.26416000E-03  +1.69587000E-03  +8.34030000E-04
   +3.68720000E-04  -1.14569000E-03  -5.59210000E-04  -4.68010000E-04  +5.41738790E-01
   +7.12090000E-04  -2.05729000E-03  -5.33298000E-03  -3.26871000E-03  +9.33100000E-05
   +2.02651000E-03  +5.20847000E-03  +1.71271000E-03  -7.22569000E-03  -4.41966300E-02
   -3.11855300E-02  -3.72434000E-03  -9.46062100E-02  -1.77608220E-01  -4.02708100E-02
   -2.31030000E-03  +1.05860700E-02  +3.82011000E-03  +1.20625000E-03  +4.80870000E-04
   +9.74830000E-04  -1.00079000E-03  -5.51950000E-04  -3.78290000E-04  +4.87932200E-02
   +2.91374520E-01  +1.25114000E-03  -8.50581000E-03  -1.71266000E-03  -2.61445000E-03
   +3.56812000E-03  +2.77596000E-03  +8.72879000E-03  -3.67874000E-03  +3.29100000E-04
   -2.15105700E-02  -2.09969500E-02  +7.25020000E-03  +3.05496500E-02  -1.80893500E-02
   -7.38401200E-02  +2.89318100E-02  +2.06755400E-02  +5.31885000E-03  -4.47340000E-04
   +3.57500000E-04  -2.03320000E-04  +4.83700000E-05  -6.72000000E-06  -4.45100000E-05
   -2.55405360E-01  +1.57366280E-01  +2.81437020E-01  +1.12630000E-04  +2.92150000E-04
   -3.22000000E-06  -3.60241600E-02  +8.01108000E-03  +1.46050000E-04  -1.45073000E-03
   -1.57842000E-03  -1.61631000E-03  -4.37500000E-05  -5.33810000E-04  +1.00064000E-03
   -1.83200000E-05  +1.20000000E-04  +8.23400000E-05  -1.71820000E-04  +6.23170000E-04
   +7.41540000E-04  -1.50338260E-01  +5.16391000E-02  -9.38976000E-03  -2.18960000E-03
   +4.93167000E-03  -5.45027000E-03  -1.63730000E-04  -8.12200000E-05  -3.05500000E-05
   +6.54956790E-01  -2.67354000E-03  -9.88040000E-04  -6.18640000E-04  -1.18685700E-02
   +1.28793100E-02  -5.82640000E-04  -1.40065000E-03  -2.31188000E-03  -9.13570000E-04
   -6.64880000E-04  -9.55360000E-04  +7.11240000E-04  +2.12090000E-04  +1.04656000E-03
   +3.99340000E-04  +2.06680000E-04  +1.88210000E-04  +1.65970000E-04  +4.89015300E-02
   -1.04803890E-01  +1.66235700E-02  +1.55676700E-02  -1.20889700E-02  +5.37134000E-03
   -9.06660000E-04  -7.38270000E-04  -1.45900000E-05  -1.38744890E-01  +3.50555350E-01
   -9.75370000E-04  -2.44520000E-04  +3.53650000E-04  +3.48098000E-03  -3.64081000E-03
   +1.09760000E-04  +9.01050000E-04  +1.19771000E-03  -2.20660000E-04  +1.53890000E-04
   +2.28010000E-04  -3.26980000E-04  -1.92680000E-04  -2.45210000E-04  -9.77000000E-05
   -2.65700000E-05  +2.25740000E-04  +4.79400000E-05  -2.60467000E-03  +1.61753800E-02
   -8.12987800E-02  -2.68751900E-02  +1.99450400E-02  -6.58335000E-03  +2.56280000E-04
   +2.14500000E-04  +7.27700000E-05  -1.82995320E-01  -1.16824990E-01  +5.12239740E-01
   +2.37320000E-04  +4.06220000E-04  +6.97500000E-05  -1.02149000E-03  +1.39179000E-03
   +2.33960000E-04  -4.42530000E-04  -4.92860000E-04  -7.46900000E-05  +7.21600000E-05
   +2.19480000E-04  +1.92000000E-04  +8.85000000E-06  -1.81160000E-04  -1.37630000E-04
   -2.67300000E-05  -1.78790000E-04  -2.68000000E-05  -2.02244000E-02  +3.90881000E-03
   +1.43368700E-02  -7.10870000E-04  -1.13900000E-04  +8.42130000E-04  +1.73570000E-04
   +1.60620000E-04  -3.35400000E-05  -3.22161270E-01  +3.46293400E-02  +1.59661090E-01
   +5.81398300E-01  -5.02690000E-04  -1.80260000E-04  -1.30370000E-04  +3.70040000E-04
   -1.70608000E-03  -4.96440000E-04  +5.18490000E-04  +3.98550000E-04  +4.84000000E-06
   -1.47370000E-04  -2.35430000E-04  -1.69220000E-04  +2.37900000E-05  +2.37630000E-04
   +1.87930000E-04  +5.87500000E-05  +3.54850000E-04  -3.88100000E-05  +1.38853500E-02
   +3.02160000E-03  -9.09932000E-03  +9.25250000E-04  -1.02171000E-03  -4.84940000E-04
   -2.14410000E-04  -1.82540000E-04  +4.16300000E-05  +3.17335600E-02  -8.11922300E-02
   +1.98231100E-02  -1.32981690E-01  +3.06173820E-01  -2.69220000E-04  -4.56750000E-04
   -4.29230000E-04  -1.90009000E-03  +7.42310000E-04  +1.43940000E-04  -2.50140000E-04
   -3.52230000E-04  +2.24350000E-04  -1.20460000E-04  -1.53780000E-04  +1.68020000E-04
   +9.47300000E-05  +8.20100000E-05  +1.23100000E-05  -1.60170000E-04  +2.25490000E-04
   +1.26760000E-04  -5.63010000E-04  -2.49962000E-03  +8.68294000E-03  -7.27850000E-04
   -2.42670000E-04  +3.13700000E-04  -2.37020000E-04  -1.69730000E-04  +4.55400000E-05
   +1.93756950E-01  +3.90508000E-03  -2.49917600E-01  -1.76853050E-01  -1.85157990E-01
   +6.90889670E-01  +2.18690000E-04  -1.43590000E-04  +9.95700000E-05  +2.53630000E-04
   -7.29200000E-05  -3.57100000E-05  -6.60500000E-05  -3.70500000E-05  +1.94580000E-04
   +5.32900000E-05  +1.30030000E-04  +9.84600000E-05  -1.34910000E-04  -2.07440000E-04
   -1.10900000E-04  -1.13100000E-05  -3.13800000E-05  -5.73500000E-05  +1.17074000E-03
   +1.60528000E-03  +3.23345000E-03  +5.82430000E-04  -5.62400000E-04  +4.95440000E-04
   +2.49450000E-04  +1.98970000E-04  +1.22900000E-05  -2.93269800E-02  +2.08636000E-02
   +3.66656000E-03  -1.74748750E-01  +1.09706810E-01  -4.26175800E-02  +5.41113160E-01
   +5.86950000E-04  -2.14890000E-04  -4.58780000E-04  +1.01751000E-03  -1.62585000E-03
   +2.52590000E-04  +5.47900000E-05  +2.92010000E-04  +4.53160000E-04  +1.83200000E-04
   +5.36850000E-04  +8.31800000E-05  -1.37890000E-04  -6.17310000E-04  -3.16150000E-04
   -1.19060000E-04  +9.64300000E-05  +4.22000000E-06  -6.41500000E-05  +5.71014000E-03
   +2.15970000E-03  +5.23450000E-04  +6.71700000E-05  -2.55190000E-04  +5.64050000E-04
   +5.30750000E-04  +1.53600000E-05  +3.08817000E-02  +1.35217700E-02  -4.83454800E-02
   +4.33523500E-02  -9.39731100E-02  +5.70020400E-02  -1.42911070E-01  +2.24246700E-01
   -3.41300000E-05  -2.44150000E-04  -4.93100000E-05  +4.99460000E-04  +2.63930000E-04
   -3.25050000E-04  +1.41600000E-04  -4.10200000E-05  -5.55500000E-05  -1.65860000E-04
   -3.21380000E-04  -8.15800000E-05  +4.66100000E-04  +4.77140000E-04  +6.06700000E-05
   -1.49480000E-04  +1.53340000E-04  +9.13200000E-05  +4.28126000E-03  +1.98779000E-03
   -5.47720000E-04  -1.09299000E-03  +4.82540000E-04  +8.61500000E-05  -6.63950000E-04
   -5.04210000E-04  +3.84000000E-05  +7.33889000E-03  -1.03971400E-02  +2.51445100E-02
   -8.00622000E-03  +3.96166800E-02  -1.12848340E-01  -5.41761100E-02  -6.53793600E-02
   +5.58984340E-01  -1.74290000E-04  -2.27300000E-05  +1.87060000E-04  -2.72760000E-04
   +2.12820000E-04  -6.92500000E-05  -2.56200000E-05  -2.66900000E-05  +3.59900000E-05
   +6.32100000E-05  +3.83900000E-05  +1.27840000E-04  -7.53710000E-04  -3.74700000E-04
   +8.95700000E-05  +2.78870000E-04  -1.55160000E-04  -1.21470000E-04  -1.57962000E-03
   -6.54750000E-04  +4.91480000E-04  +2.58060000E-04  -4.89200000E-05  +4.30800000E-05
   +7.15410000E-04  +4.61660000E-04  -1.78800000E-05  -4.62062000E-03  +3.68542000E-03
   +1.32043100E-02  +3.97540000E-03  -9.05938000E-03  -2.04444900E-02  -9.77262600E-02
   +1.83335300E-02  -5.96588700E-02  +7.98206380E-01  +2.24700000E-05  +6.77800000E-05
   +3.84900000E-05  -9.92000000E-05  +2.05140000E-04  -3.76700000E-05  -7.37900000E-05
   -4.84600000E-05  -1.51000000E-05  -2.40000000E-07  -1.39800000E-05  -1.33500000E-05
   +1.77490000E-04  +9.71600000E-05  -2.51100000E-05  -5.10400000E-05  -5.90000000E-07
   +1.40000000E-05  -1.30610000E-04  -8.76860000E-04  -3.83260000E-04  -7.68100000E-05
   -1.42900000E-05  +3.71200000E-05  -1.67630000E-04  -1.19270000E-04  -3.79000000E-06
   -2.69553000E-03  -4.56990000E-04  +7.87911000E-03  +1.82688700E-02  -7.53955000E-03
   +2.38587700E-02  +1.03320000E-02  -5.25792800E-02  +4.97613000E-03  -8.43428300E-02
   +2.01420940E-01  +1.71500000E-05  +4.42320000E-04  -1.20300000E-05  +5.40830000E-04
   -1.47928000E-03  +2.16300000E-05  +1.39580000E-04  +3.69070000E-04  +2.64400000E-05
   +2.48130000E-04  +3.75980000E-04  -1.45730000E-04  -1.77240000E-04  -3.79910000E-04
   -7.66900000E-05  +5.43900000E-05  -9.54100000E-05  -7.36400000E-05  +2.60700000E-04
   +2.41881000E-03  -6.11980000E-04  +2.78110000E-04  +7.10500000E-05  -3.87940000E-04
   +4.22900000E-04  +3.48340000E-04  -5.38600000E-05  +1.12321500E-02  -4.86659000E-03
   -1.48012500E-02  -4.23037600E-02  +3.26346000E-03  -1.29349100E-02  +2.66014300E-02
   +4.32013700E-02  -2.16873630E-01  -6.86972900E-02  -1.70294700E-02  +6.32420080E-01
   +2.16210000E-04  +3.87530000E-04  -1.94130000E-04  -1.03550000E-04  -7.27090000E-04
   -4.30200000E-05  +2.94600000E-04  +1.97730000E-04  -1.68800000E-04  +1.54700000E-05
   +9.83700000E-05  -1.27820000E-04  +5.53130000E-04  +1.60490000E-04  -7.91400000E-05
   -1.40040000E-04  +1.69120000E-04  +7.85000000E-05  +9.23280000E-04  -3.00070000E-04
   +8.52170000E-04  +3.93630000E-04  -4.30300000E-05  -1.70380000E-04  -3.96060000E-04
   -2.04750000E-04  +2.30000000E-07  +5.96465000E-03  -5.86566000E-03  -2.79074600E-02
   -2.02024100E-02  +4.39779000E-03  -1.42154000E-03  +4.14800600E-02  +2.31599200E-02
   +3.83940200E-02  -2.52362590E-01  +2.40024800E-02  +1.03814620E-01  +6.19481650E-01
   -2.03700000E-05  +1.21800000E-05  -1.36360000E-04  -6.14500000E-04  -1.85000000E-06
   +5.07400000E-05  +9.61400000E-05  +7.88900000E-05  -1.33840000E-04  -4.88900000E-05
   -1.66000000E-05  +5.02000000E-05  -1.41200000E-05  -1.08100000E-05  +3.48500000E-05
   +7.48600000E-05  +1.41670000E-04  -8.80400000E-05  -3.89200000E-05  -2.36440000E-04
   +2.37668000E-03  +3.64450000E-04  -2.62150000E-04  +7.71900000E-05  +4.16100000E-05
   +7.13100000E-05  -3.79000000E-06  +9.37905000E-03  +1.37570000E-04  +1.71488600E-02
   +7.58103000E-03  -9.64280000E-04  -1.56480000E-04  -5.67636000E-03  +1.25865800E-02
   -9.26629000E-03  +5.56857000E-03  -6.99198600E-02  +1.36773600E-02  -1.29249300E-02
   +1.29014400E-01  +1.23590000E-04  -4.45600000E-04  -8.79500000E-05  +6.95750000E-04
   +4.04980000E-04  +3.47790000E-04  -1.66840000E-04  -1.46130000E-04  +2.76910000E-04
   -1.30800000E-04  -2.81800000E-05  +1.52960000E-04  -2.09860000E-04  -7.25300000E-05
   -1.14200000E-05  +7.44700000E-05  +1.04600000E-05  -5.03500000E-05  +9.27000000E-04
   +7.04690000E-04  -2.56174000E-03  -9.92630000E-04  +5.60880000E-04  +1.56940000E-04
   +1.83090000E-04  +1.35850000E-04  +2.10500000E-05  -2.74959600E-02  +2.70051000E-03
   -1.94052000E-03  +1.22815200E-02  -5.95561000E-03  -1.66363000E-03  +1.28247700E-02
   +2.48410000E-04  -3.30068200E-02  +1.55673120E-01  -1.02733700E-02  -2.56889180E-01
   -4.02340200E-02  -5.31158100E-02  +7.80160340E-01  -4.73150000E-04  -7.37900000E-05
   -7.36800000E-05  +2.61100000E-05  +2.14292000E-03  -2.22176000E-03  -1.29440000E-04
   -1.03480000E-04  +1.50400000E-05  +7.67800000E-05  -1.15230000E-04  +2.45780000E-04
   -4.24870000E-04  -2.76670000E-04  -5.58300000E-05  -2.86600000E-05  -3.36640000E-04
   +8.42400000E-05  -4.83640000E-04  +1.39648400E-02  -2.25497200E-02  -4.85399000E-03
   +2.97319000E-03  +8.06950000E-04  +3.12810000E-04  +1.73100000E-04  +2.10900000E-05
   -1.07084690E-01  +2.15417500E-02  +1.07846000E-02  +2.15601400E-02  -2.17209700E-02
   +2.42063600E-02  -2.11193800E-02  -2.61297000E-03  -1.28424900E-02  -6.52683500E-02
   -2.88899000E-03  +2.49105000E-02  -2.34570520E-01  -2.58305000E-03  -9.05118100E-02
   +6.83795230E-01  -5.92940000E-04  -2.43890000E-04  +5.41920000E-04  +9.02240000E-04
   +8.72360000E-04  -1.85610000E-04  -4.55840000E-04  -2.21900000E-04  -3.96000000E-05
   +1.68660000E-04  -2.66280000E-04  -1.02050000E-04  -5.05190000E-04  +4.02200000E-05
   +1.76640000E-04  -8.97200000E-05  -5.03170000E-04  +2.58300000E-04  +8.90732000E-03
   -4.58539000E-03  +1.45920100E-02  +1.64720000E-03  +1.05920000E-04  -6.25360000E-04
   +6.63900000E-05  -1.53650000E-04  -1.16700000E-05  +2.35793000E-02  -1.07149840E-01
   +4.91195800E-02  -3.47030900E-02  +1.99138800E-02  +1.26516400E-02  -1.96815700E-02
   -6.14100900E-02  -3.41950000E-04  -5.19419000E-03  +6.37370000E-04  +1.59055500E-02
   +2.58471000E-02  -4.94848600E-02  +2.23853500E-02  -2.18395100E-02  +1.46516820E-01
   -7.79760000E-04  +9.35380000E-04  +5.17230000E-04  -2.29330000E-04  +1.11912000E-03
   -8.06360000E-04  -2.69500000E-05  -1.54390000E-04  -4.93270000E-04  +3.74420000E-04
   +1.72120000E-04  -2.89540000E-04  -4.47300000E-05  -1.92100000E-05  +4.37200000E-05
   -1.43900000E-05  -3.70660000E-04  -3.89700000E-05  -7.45482000E-03  +2.98269000E-03
   -3.54112000E-03  +4.93900000E-05  -2.13220000E-04  +7.65880000E-04  +2.80700000E-05
   -8.40600000E-05  -7.02700000E-05  -1.21974900E-02  +9.23313800E-02  -1.65332070E-01
   +3.08512900E-02  +7.43822000E-03  -3.19339100E-02  -1.98189600E-02  -6.73262000E-03
   -2.88429800E-02  -1.62526100E-02  -4.50739000E-03  +6.40753000E-02  -3.34315800E-02
   +5.28387000E-03  -1.57726380E-01  -9.21593700E-02  -1.82716000E-01  +5.03231400E-01
   +8.29800000E-05  +1.01000000E-05  -1.26890000E-04  -9.23600000E-05  +4.66330000E-04
   -2.14860000E-04  +1.37030000E-04  -6.85400000E-05  -2.40220000E-04  -1.65370000E-04
   -2.86990000E-04  -1.17780000E-04  +9.05070000E-04  +6.38160000E-04  -7.23000000E-06
   -2.91810000E-04  +2.15380000E-04  +1.70020000E-04  +1.32637000E-03  -3.05280000E-04
   -2.26010000E-04  -5.30980000E-04  +1.35330000E-04  +1.30490000E-04  -1.01758000E-03
   -7.09820000E-04  +3.93200000E-05  +1.72117000E-03  -1.74240000E-03  -7.42012000E-03
   -1.90315000E-03  +4.18026000E-03  -2.88474000E-03  -3.52265400E-02  -4.47358000E-03
   -1.40487400E-02  -3.17893060E-01  +5.17209500E-02  -9.55808200E-02  -6.15405100E-02
   +1.50404300E-02  -2.63993000E-03  +9.99609000E-03  +1.93692000E-03  +1.65075900E-02
   +5.57177070E-01  -1.09700000E-05  +2.83700000E-05  -1.39300000E-05  +5.49700000E-05
   -2.16180000E-04  +1.03240000E-04  +6.08000000E-06  +2.95300000E-05  +5.89000000E-05
   +2.99100000E-05  +9.18200000E-05  +1.93700000E-05  -1.91820000E-04  -1.59180000E-04
   -1.33000000E-06  +7.96400000E-05  -2.76100000E-05  -4.46600000E-05  -3.61120000E-04
   +2.17090000E-04  -6.73800000E-05  +1.53260000E-04  +1.33100000E-05  -6.93900000E-05
   +2.38570000E-04  +1.84750000E-04  -1.27300000E-05  +4.91390000E-04  -1.59628000E-03
   +1.65049000E-03  +2.79231000E-03  +6.82740000E-04  -3.09756000E-03  +6.27554000E-03
   +1.59747200E-02  -5.11860000E-04  +5.24138700E-02  -5.96903700E-02  +1.93060700E-02
   +3.32611000E-03  +8.38111000E-03  +2.11730000E-03  +8.62440000E-04  +6.81257000E-03
   -3.64030000E-04  -8.38400700E-02  +4.98418600E-02  +8.60000000E-06  -1.20260000E-04
   -4.95600000E-05  -7.64100000E-05  +3.90830000E-04  -1.88300000E-05  +5.41000000E-06
   -8.34400000E-05  -3.73600000E-05  -9.90200000E-05  -1.49210000E-04  +1.00600000E-05
   +2.05080000E-04  +2.10700000E-04  +2.08700000E-05  -5.76000000E-05  +5.61200000E-05
   +5.26800000E-05  +2.20680000E-04  -3.27160000E-04  +3.97750000E-04  -1.60270000E-04
   +1.61600000E-05  +7.19700000E-05  -2.86410000E-04  -2.15000000E-04  +2.58600000E-05
   -1.41065000E-03  +3.71090000E-04  +1.46234000E-03  +3.57314000E-03  -3.16728000E-03
   -4.49727000E-03  -4.17878100E-02  +7.84708000E-03  -1.57945300E-02  -4.22941600E-02
   +6.43490000E-03  -1.40666060E-01  +2.85155400E-02  -4.90393000E-03  +2.42006800E-02
   +2.84459000E-03  +5.22600000E-04  -8.61652000E-03  -1.13093380E-01  +3.11206000E-03
   +5.19358020E-01  -1.46400000E-05  -2.50900000E-05  -6.71100000E-05  -1.66250000E-04
   +6.65820000E-04  -4.68000000E-05  +8.58000000E-06  -1.44790000E-04  -1.68780000E-04
   -1.31660000E-04  -2.33640000E-04  -4.66000000E-05  +5.02990000E-04  +4.18030000E-04
   +3.57500000E-05  -1.39930000E-04  +9.23000000E-05  +1.11800000E-04  +3.28580000E-04
   -6.52040000E-04  +1.82427000E-03  -2.53850000E-04  -8.46600000E-05  +1.55440000E-04
   -6.25960000E-04  -4.53130000E-04  +1.64700000E-05  -5.37157000E-03  +4.70395000E-03
   -1.40328000E-03  -2.79300900E-02  -3.83134000E-03  +2.96389200E-02  -1.77192060E-01
   +4.96303000E-02  +9.30189800E-02  -1.55512500E-02  +4.72479000E-03  +3.25586000E-03
   -9.73000000E-05  -9.18400000E-04  +2.26488000E-03  +1.09294000E-03  +3.67132000E-03
   -5.11780000E-04  +1.01823000E-02  -1.34241000E-03  -7.22609000E-03  +2.69516650E-01
   +3.57100000E-05  +1.81600000E-05  -3.67600000E-05  +2.74270000E-04  -4.70090000E-04
   +7.10000000E-07  +7.95600000E-05  +1.22770000E-04  +4.65900000E-05  +2.80600000E-05
   +7.09900000E-05  -2.63900000E-05  -5.70700000E-05  -8.54400000E-05  -1.44100000E-05
   +2.63000000E-05  +1.51200000E-05  -2.66000000E-05  +8.77450000E-04  +1.34399000E-03
   -3.64620000E-04  -8.59000000E-05  +2.63800000E-05  -8.59800000E-05  +1.08580000E-04
   +9.45300000E-05  -3.06000000E-06  +1.52165000E-03  -2.47887000E-03  +5.61023000E-03
   +2.20912300E-02  -3.45959000E-03  -1.96693000E-02  +4.76088000E-03  -7.42700200E-02
   +1.81139800E-02  +1.43031000E-03  -4.63500000E-04  -8.47353000E-03  -3.65698000E-03
   +3.11811000E-03  +8.61910000E-04  +3.26790000E-04  +1.56370000E-04  +1.55324000E-03
   +7.97300000E-04  -7.28500000E-05  +2.67218000E-03  +5.66569600E-02  +5.11079270E-01
   +7.86600000E-05  -8.04600000E-05  -1.35600000E-05  +1.25820000E-04  -2.16960000E-04
   +1.67190000E-04  -2.22900000E-05  +3.32500000E-05  +1.10010000E-04  +3.20600000E-05
   +1.03250000E-04  +6.49300000E-05  -2.83520000E-04  -2.15840000E-04  -2.85300000E-05
   +7.17800000E-05  -7.46200000E-05  -1.36600000E-05  -5.19200000E-04  +5.21760000E-04
   +9.22400000E-05  +2.53750000E-04  -9.39200000E-05  -1.18070000E-04  +3.32800000E-04
   +2.33120000E-04  +1.94100000E-05  +1.48820000E-03  +1.95206000E-03  -1.94256000E-03
   -4.96394000E-03  +1.69340000E-03  +2.94970000E-03  +9.68642000E-02  -1.90620900E-02
   -1.35931040E-01  +3.37746700E-02  -3.17066000E-03  -3.29946100E-02  +2.94750000E-04
   +9.83690000E-04  -7.45400000E-03  -3.51845000E-03  -4.39923000E-03  -2.06846000E-03
   +8.90095000E-03  -1.83679000E-03  -4.21166000E-03  -1.95787620E-01  -1.64760710E-01
   +2.62912700E-01  -4.88113000E-03  -2.21130000E-03  +1.38087000E-03  +1.45330000E-04
   -2.09036500E-02  -2.00815200E-02  -1.35926000E-03  -1.09003000E-03  -6.93590000E-04
   +1.62570000E-04  -5.29560000E-04  -5.95950000E-04  +3.99780000E-04  +2.82700000E-04
   +8.07200000E-05  +3.98780000E-04  -1.25460000E-03  -6.42770000E-04  -7.48959600E-02
   +2.56560000E-03  +3.13535000E-03  +4.54630000E-04  -1.41700000E-05  -1.88580000E-04
   -5.74970000E-04  -4.33520000E-04  +4.47000000E-05  -6.89634000E-03  +2.32530400E-02
   +2.19665800E-02  +1.63190000E-04  +6.28370000E-04  -1.54633000E-03  -1.10899000E-03
   +1.00595000E-03  -1.69932000E-03  -4.35400000E-05  -3.80000000E-07  +1.06129000E-03
   +4.43810000E-04  -2.07360000E-04  -2.09940000E-04  -7.42440000E-04  -3.64840000E-04
   +3.22000000E-04  -4.69820000E-04  +1.48270000E-04  -4.27930000E-04  -7.44710000E-04
   -1.25150000E-04  +1.50220000E-04  +5.88422510E-01  -3.07255000E-03  -4.89630000E-04
   +4.05480000E-04  -4.97656000E-03  -1.88559800E-02  -1.53939600E-02  -2.88770000E-04
   -3.87330000E-04  +8.14110000E-04  +6.76030000E-04  -5.35370000E-04  -5.43300000E-04
   -1.60280000E-04  +1.78300000E-05  -1.34560000E-04  +3.49520000E-04  -6.61080000E-04
   -5.16200000E-04  -1.67350000E-03  -1.24354490E-01  -5.03869900E-02  -3.15620000E-04
   +9.45256000E-03  +6.65502000E-03  +4.19900000E-05  -1.69700000E-05  -1.53500000E-05
   +1.09738100E-02  -2.10931200E-02  -1.52700100E-02  -2.28828000E-03  -2.92310000E-04
   +1.31273000E-03  +6.57860000E-04  -6.26140000E-04  +9.90190000E-04  +2.06940000E-04
   +1.47950000E-04  -4.43900000E-04  -3.52860000E-04  +1.34970000E-04  -2.08100000E-05
   +4.95160000E-04  +2.05090000E-04  -6.50390000E-04  -3.87900000E-05  -2.46400000E-05
   +1.41640000E-04  +1.90450000E-04  +1.70250000E-04  -5.84100000E-05  +2.09620000E-04
   +5.18547040E-01  +1.44722000E-03  +7.24140000E-04  -5.41100000E-05  -3.62500000E-03
   -2.45650000E-04  +1.55758000E-03  +1.04388000E-03  +8.51960000E-04  -1.18120000E-04
   +1.53010000E-04  +1.17590000E-04  -8.98500000E-05  -1.92650000E-04  -9.37500000E-05
   +2.14510000E-04  +3.29650000E-04  +3.15820000E-04  +1.57250000E-04  -1.09022000E-03
   -4.62604700E-02  -1.24120160E-01  +8.26070000E-04  -2.21372300E-02  -3.55610500E-02
   +3.06970000E-04  +2.20080000E-04  -4.52600000E-05  +6.22400000E-03  -2.92498000E-03
   +3.02989000E-03  -7.29600000E-04  -4.71630000E-04  -7.39500000E-05  -5.49390000E-04
   +6.18100000E-04  -8.82690000E-04  -7.49640000E-04  +2.15200000E-05  +1.49798000E-03
   +1.23939000E-03  -3.81910000E-04  -7.41740000E-04  -2.02965000E-03  +1.01920000E-03
   +3.85000000E-04  +1.24440000E-04  +9.19100000E-05  -2.72730000E-04  -2.34770000E-04
   +1.21290000E-04  -4.16300000E-05  -3.16098000E-03  -6.35430100E-02  +5.29222770E-01
   -8.32680000E-04  +7.90130000E-04  -1.15077000E-03  -3.87750000E-04  -1.19485000E-03
   +4.22100000E-05  +3.46420000E-04  +1.18880000E-04  +7.22700000E-05  -1.00970000E-04
   +2.85120000E-04  +1.23340000E-04  +8.10410000E-04  -4.89000000E-06  -2.99550000E-04
   -7.23200000E-05  +7.30050000E-04  -1.72090000E-04  -2.47800000E-04  +7.99770000E-04
   -1.40620000E-03  +2.63060000E-04  +1.73580000E-04  -8.70900000E-05  -2.57120000E-04
   -2.00500000E-05  +2.02600000E-05  +1.06608600E-02  +8.17707000E-03  -1.32513400E-02
   -1.91153900E-02  +1.97332300E-02  +5.74430000E-04  -4.45784700E-02  -7.21857600E-02
   -9.90830000E-04  +9.72970000E-04  -3.48284000E-03  +2.77732700E-02  +8.62640000E-03
   -1.12787400E-02  -9.40160000E-03  -3.85434000E-02  -3.18575600E-02  -6.75183000E-03
   -5.27201000E-03  +2.29934000E-03  -3.04139000E-03  -4.37250000E-03  -2.21358000E-03
   +3.89960000E-03  +1.28108000E-03  -6.07760000E-04  +6.71300000E-04  +1.29473680E-01
   +7.73090000E-04  +4.53200000E-05  +2.87660000E-04  -6.29950000E-04  -9.05720000E-04
   +1.96330000E-04  +3.16770000E-04  +4.88020000E-04  +5.31900000E-05  +1.38000000E-05
   +2.58040000E-04  +6.06900000E-05  +2.37130000E-04  -1.70740000E-04  -2.56920000E-04
   +2.41750000E-04  +3.35150000E-04  -3.74480000E-04  -4.71269000E-03  -1.98033000E-03
   +3.43500000E-05  +8.94480000E-04  -3.43370000E-04  -3.01520000E-04  +2.05510000E-04
   +3.97770000E-04  -3.32500000E-05  -3.48050000E-03  -4.21917000E-02  +1.90027500E-02
   +7.10827000E-03  -7.40148000E-03  -3.89922000E-03  -1.00472400E-02  +5.96101000E-03
   +5.96021000E-03  +1.17105700E-02  -2.69587000E-03  -1.33509200E-02  -3.72919000E-02
   -1.35772700E-02  -1.79771900E-02  +8.43100000E-03  +5.38827200E-02  +3.28681900E-02
   -6.38213000E-03  +3.22360000E-04  -8.95890000E-04  -6.57950000E-03  -3.96747000E-03
   +5.97293000E-03  +4.16130000E-04  -1.44740000E-04  +2.58810000E-04  -5.87871200E-02
   +2.97783940E-01  +2.96540000E-04  +2.42790000E-04  -1.04658000E-03  -2.60430000E-04
   +1.77040000E-04  +2.06460000E-04  +1.05610000E-04  -8.79000000E-06  +2.22550000E-04
   -1.87640000E-04  -2.28100000E-05  +1.27360000E-04  +1.89320000E-04  +4.34900000E-05
   -5.29000000E-06  -1.48770000E-04  +1.95800000E-05  +1.73740000E-04  -5.46220000E-04
   -6.92560000E-04  -8.11910000E-04  -1.75110000E-04  +2.73500000E-05  -1.44670000E-04
   -1.79330000E-04  -1.00350000E-04  +7.13200000E-05  -1.84977000E-03  -1.44170000E-04
   +1.38752400E-02  +1.23196200E-02  -3.64704000E-03  -1.94996000E-03  +3.33307900E-02
   +5.20946500E-02  +1.31274100E-02  +1.63639800E-02  -5.84933000E-03  -4.18321400E-02
   -4.66711500E-02  -2.19383000E-02  -5.84342000E-03  +1.68214500E-02  +7.48516100E-02
   -6.30615000E-03  -4.38795000E-03  -1.89190000E-04  +3.04291000E-03  +5.95340000E-04
   -1.27526000E-03  +1.38828000E-03  -7.41900000E-05  -1.48500000E-05  -1.54130000E-04
   +1.45158500E-01  -2.70908200E-01  +3.06595750E-01  -2.29400000E-04  +1.05931000E-03
   +1.74173000E-03  +6.60000000E-04  -2.66620000E-04  -4.09090000E-04  -1.08895000E-03
   +1.93250000E-04  +3.69900000E-04  +4.47186000E-03  +3.02726000E-03  -9.37870000E-04
   -3.26886700E-02  +1.17916900E-02  +2.52404600E-02  -2.37927000E-03  -5.51974000E-03
   -1.26277000E-03  -1.64310000E-04  -1.32800000E-04  -1.36280000E-04  +1.45780000E-04
   +7.18200000E-05  +5.06200000E-05  -2.74682130E-01  +8.93455000E-02  +2.15047300E-01
   +4.07800000E-05  +1.47620000E-04  -5.79800000E-05  -2.36100000E-05  +4.16700000E-05
   +2.64100000E-05  -4.68400000E-05  -8.37400000E-05  +1.09330000E-04  -1.54570000E-04
   +3.51900000E-05  -4.85500000E-05  +1.01130000E-04  +5.83000000E-06  -4.16400000E-05
   -1.07510000E-04  -7.69900000E-05  -2.40000000E-06  +1.92690000E-04  -3.82500000E-05
   +4.49800000E-05  +1.11990000E-04  -1.23200000E-05  -7.00400000E-05  +7.27000000E-05
   +7.66000000E-06  -2.35900000E-05  +1.06200000E-04  +5.22800000E-05  +2.65000000E-06
   +3.05656140E-01  -4.81870000E-04  +1.53803000E-03  +1.24410000E-04  +3.15940000E-04
   -3.33100000E-04  -4.96380000E-04  -1.23890000E-04  -6.37230000E-04  +1.31000000E-04
   -2.04566000E-03  +9.79730000E-04  +2.49896000E-03  -2.52826800E-02  +6.68615000E-03
   +2.06921200E-02  -4.22590000E-03  -2.73256000E-03  -1.02205000E-03  +2.11700000E-05
   -8.22300000E-05  -3.24800000E-05  +9.09000000E-06  +3.47000000E-06  -1.71000000E-06
   +1.29279060E-01  -9.24520000E-02  -1.34861060E-01  -1.64600000E-05  +3.21400000E-05
   -4.77000000E-05  -1.78300000E-05  +9.15000000E-06  +1.38700000E-05  -2.07800000E-05
   -4.06000000E-05  +4.92000000E-05  -5.94300000E-05  +1.28200000E-05  -3.13100000E-05
   +2.74600000E-05  -1.80500000E-05  -1.08600000E-05  -2.85500000E-05  +1.15000000E-05
   -8.41000000E-06  +7.74400000E-05  -2.05200000E-05  +2.49900000E-05  +4.78300000E-05
   -9.18000000E-06  -1.76700000E-05  +2.54500000E-05  +3.43000000E-05  +6.55000000E-06
   +2.12300000E-05  -5.11100000E-05  +2.84000000E-05  -9.83347300E-02  +8.81641700E-02
   +7.37040000E-04  -6.45100000E-04  +7.79210000E-04  -1.31320000E-04  -1.52190000E-04
   -4.77200000E-05  +1.31150000E-04  -5.35300000E-05  -8.22190000E-04  -4.48202000E-03
   -3.54460000E-04  +1.36144000E-03  -6.29760000E-04  -1.87960000E-04  -2.30879000E-03
   -4.39080000E-04  -3.18350000E-04  +2.23616000E-03  +1.23420000E-04  +4.31600000E-05
   +2.23400000E-05  -7.66100000E-05  -5.89500000E-05  -3.26500000E-05  +2.42962110E-01
   -1.12391270E-01  -2.19335010E-01  +1.17500000E-05  -3.11800000E-05  -6.78000000E-06
   +9.29000000E-06  -8.50000000E-07  -8.92000000E-06  -1.74000000E-06  +2.70100000E-05
   -2.64400000E-05  -9.10000000E-07  +4.00000000E-07  +4.13100000E-05  +1.21400000E-05
   +9.82000000E-06  -4.29000000E-06  -2.64300000E-05  -3.56600000E-05  +8.20000000E-06
   -2.33600000E-05  +1.00100000E-05  -1.82400000E-05  -1.64300000E-05  +8.28000000E-06
   -8.98000000E-06  -3.36600000E-05  +2.08000000E-06  +2.54000000E-05  +2.77400000E-05
   +5.17100000E-05  -3.03600000E-05  -2.38514160E-01  +1.14072430E-01  +2.18533260E-01
   -1.22250000E-04  -4.01020000E-04  -8.07810000E-04  -1.15903000E-03  -5.20375000E-03
   +9.18750000E-04  -1.51741900E-02  +8.17996000E-03  +1.54670500E-02  -2.17718530E-01
   +4.14147500E-02  +1.34635100E-01  -6.09000000E-06  -3.94188000E-03  -4.87550000E-04
   +2.49111000E-03  -1.11245000E-03  +1.03305000E-03  -1.37200000E-04  +7.00850000E-04
   +8.10510000E-04  -2.42130000E-04  -1.08300000E-04  -9.59700000E-05  +2.39782000E-03
   +1.58845000E-03  -2.56849000E-03  -6.72700000E-05  -2.38820000E-04  +1.29760000E-04
   -7.67000000E-06  +8.01000000E-06  -6.94900000E-05  +1.12100000E-05  +7.71100000E-05
   -8.00700000E-05  +5.28600000E-05  -1.37700000E-05  +9.73000000E-05  -4.11000000E-06
   +1.07200000E-05  -9.04000000E-06  -2.10700000E-05  -2.36000000E-05  +3.02700000E-05
   -1.03220000E-04  +2.64400000E-05  -4.41800000E-05  -7.43900000E-05  +2.24700000E-05
   +2.24300000E-05  -5.19200000E-05  +9.55300000E-05  +4.31200000E-05  +6.43000000E-06
   +7.47400000E-05  -4.73300000E-05  +1.18300000E-05  +9.18060000E-04  +9.70630000E-04
   +2.30027730E-01  -6.69980000E-04  -1.37480000E-03  +9.75000000E-05  -4.49267000E-03
   -1.35460000E-04  -2.23203000E-03  -1.52882700E-02  +7.89288000E-03  +1.28745700E-02
   +4.15566400E-02  -6.66014200E-02  -4.80557000E-02  +2.08252500E-02  -4.13120000E-04
   -1.50163500E-02  -1.61426000E-03  -2.70956000E-03  -4.94686000E-03  -5.96430000E-04
   +5.59800000E-04  +2.90420000E-04  -6.08100000E-05  +1.95000000E-05  -6.77000000E-05
   +2.20854000E-03  +9.78250000E-04  +2.33799000E-03  -1.80730000E-04  -2.55220000E-04
   +7.75000000E-05  -2.10300000E-05  +3.61000000E-06  -1.57600000E-05  +2.00400000E-05
   +7.93200000E-05  -1.82900000E-05  +9.48000000E-06  -9.76000000E-06  +3.76600000E-05
   +1.07700000E-05  -4.40000000E-06  -8.90000000E-07  +1.08100000E-05  -3.47000000E-05
   -2.72800000E-05  -2.75300000E-05  +7.19000000E-06  -1.16500000E-05  -2.86200000E-05
   +1.16500000E-05  +1.82400000E-05  +6.02600000E-05  +5.74300000E-05  +5.55100000E-05
   +4.08400000E-05  +3.18100000E-05  +2.47700000E-05  -1.35922000E-03  -8.36540000E-04
   -2.41280000E-04  -4.29817800E-02  +6.35216600E-02  -1.07182000E-03  -1.02570000E-04
   -4.96170000E-04  +1.10542000E-03  -1.88394000E-03  +4.81949000E-03  -8.80780000E-04
   -3.55570000E-04  +2.17741000E-03  +1.34735170E-01  -4.80867100E-02  -1.42491400E-01
   +1.70660600E-02  -8.13660000E-04  -6.22973000E-03  +5.79280000E-04  -5.32468000E-03
   +1.58805000E-03  +7.65800000E-05  -2.29140000E-04  +3.17580000E-04  -1.59800000E-05
   -8.16400000E-05  +1.83100000E-05  -2.16131000E-03  +2.64683000E-03  -1.00351000E-03
   +1.34310000E-04  +1.45610000E-04  -4.24200000E-05  +7.00000000E-08  +1.93600000E-05
   +1.40600000E-05  -2.58400000E-05  -5.26400000E-05  +2.98000000E-05  -5.42700000E-05
   +1.58300000E-05  -1.87500000E-05  +3.30500000E-05  +9.30000000E-06  -1.16200000E-05
   -4.81800000E-05  -2.61100000E-05  +5.90000000E-07  +6.41700000E-05  -1.25200000E-05
   +1.51300000E-05  +4.07900000E-05  -5.12000000E-06  -2.78500000E-05  -4.30000000E-06
   +4.46500000E-05  -6.39300000E-05  +1.87600000E-05  +4.30200000E-05  -1.07400000E-05
   -6.41530000E-04  -1.52923000E-03  -1.43150000E-04  -1.48106550E-01  +5.33353100E-02
   +1.44344440E-01  -2.88477000E-03  -2.83040000E-04  +5.29549000E-03  +5.93641000E-03
   +1.99038100E-02  +1.31210400E-02  -5.61339500E-02  -9.58590000E-04  +9.57462000E-03
   +3.67487000E-03  -2.13778800E-02  -1.50671500E-02  -2.24529000E-03  -4.16665000E-03
   +2.66327000E-03  -1.30305000E-03  -1.19970000E-04  -2.16200000E-05  +1.46990000E-04
   +1.31624000E-03  -1.35735000E-03  +3.00240000E-04  -2.32700000E-05  -6.34400000E-05
   -2.68980000E-04  -1.31892000E-03  -7.77440000E-04  -1.60000000E-04  -1.61890000E-04
   -1.85410000E-04  -3.70200000E-05  -3.19000000E-06  -2.84200000E-05  -4.64000000E-05
   -1.03210000E-04  +5.00900000E-05  -9.29700000E-05  +2.52700000E-05  +4.80700000E-05
   +3.58300000E-05  -7.00200000E-05  -7.54700000E-05  -4.89500000E-05  +1.26080000E-04
   +1.77820000E-04  +7.92100000E-05  -2.11900000E-05  +7.90000000E-06  +5.29000000E-05
   -1.37000000E-06  -4.54500000E-05  -2.35518000E-03  -1.12651000E-03  +8.01160000E-04
   -9.76700000E-05  -1.30550000E-04  -4.58300000E-05  +1.88210000E-04  +2.61600000E-05
   -1.08740000E-04  -6.20000000E-06  +1.35137000E-03  -1.44907000E-03  +5.72515700E-02
   -1.09970000E-04  +2.80403000E-03  -2.84470000E-03  -3.71650000E-04  -1.57668000E-03
   -3.93512000E-03  -5.75150000E-04  -2.39736430E-01  -1.42405050E-01  +1.90272000E-03
   -1.18088400E-02  -1.17668800E-02  -4.45766000E-03  +1.82539000E-03  -1.55900000E-03
   -1.48200000E-05  +6.60900000E-05  +9.35930000E-04  +2.94630000E-04  -1.93317000E-03
   +1.34257000E-03  -3.11880000E-04  -1.78080000E-04  +7.68000000E-05  -3.63220000E-04
   -1.07825000E-03  -6.09880000E-04  +2.67280000E-04  +3.50210000E-04  -2.74210000E-04
   +5.13600000E-05  -3.91100000E-05  +9.36300000E-05  +3.30900000E-05  -2.58600000E-05
   +3.89300000E-05  +4.41500000E-05  -9.11000000E-06  -1.32400000E-04  -7.92800000E-05
   +1.94400000E-05  +8.41900000E-05  +1.41480000E-04  +2.71400000E-05  -1.44160000E-04
   +4.78000000E-06  -7.48000000E-06  +3.64100000E-05  +2.64200000E-05  -2.12700000E-05
   +1.63300000E-05  -2.82098000E-03  -9.05750000E-04  +4.23540000E-04  -2.07300000E-05
   -4.67000000E-06  +4.83600000E-05  +2.12970000E-04  +1.05300000E-05  -7.55700000E-05
   +9.29510000E-04  -4.77640000E-04  +2.10160000E-03  +7.39311000E-03  +2.54487760E-01
   +5.44271000E-03  -2.56050000E-03  +1.98154000E-03  -1.44653000E-03  -1.54562200E-02
   -5.88493000E-03  +1.01750200E-02  -1.42314910E-01  -1.44406310E-01  +1.20879000E-03
   +1.21807000E-03  +3.65450000E-03  +2.36515000E-03  -1.64967000E-03  +5.09360000E-03
   +1.07010000E-04  +1.03787000E-03  -5.64960000E-04  -2.26890000E-03  +6.32700000E-04
   -2.25963000E-03  +7.13400000E-04  +2.30560000E-04  +1.21000000E-06  -8.67900000E-05
   -6.95500000E-05  +4.05300000E-05  -3.53250000E-04  -1.50020000E-04  +2.77460000E-04
   +7.39000000E-06  +3.24000000E-05  -6.83000000E-05  -4.97000000E-06  +9.42200000E-05
   -3.63600000E-05  -4.89400000E-05  -2.75000000E-06  +7.94100000E-05  +1.06710000E-04
   +3.41000000E-05  -3.45800000E-05  -1.32730000E-04  -2.05990000E-04  -4.83000000E-06
   +2.14900000E-05  +9.30000000E-06  -1.92400000E-05  -1.09300000E-05  +1.91800000E-05
   -5.42000000E-06  -2.04580000E-04  -7.13250000E-04  +5.48090000E-04  +1.51270000E-04
   +1.48670000E-04  +3.10400000E-05  +1.79600000E-05  +2.39500000E-05  -3.81900000E-05
   -1.73230000E-03  +1.86857000E-03  -1.88828000E-03  -1.25820000E-02  +1.57186630E-01
   +1.44513100E-01  -2.30669920E-01  +4.88714900E-02  +1.33659160E-01  +4.37989000E-03
   -5.31900000E-04  -4.58720000E-04  +1.89281000E-03  -1.49235000E-03  +9.38590000E-04
   -2.80800000E-05  -3.25450000E-04  -7.92590000E-04  -3.38070000E-04  -4.70458000E-03
   +1.16630000E-03  -1.48148900E-02  +7.01283000E-03  +1.51236700E-02  -7.66680000E-04
   -1.20200000E-05  -9.25980000E-04  -7.57800000E-05  -6.56500000E-05  +1.87830000E-04
   -1.06769000E-03  +3.51140000E-04  +8.00910000E-04  -3.19540000E-04  -7.31560000E-04
   -3.12290000E-04  -5.26090000E-04  +2.64000000E-06  +9.36000000E-06  -3.23500000E-05
   -6.16500000E-05  +1.22940000E-04  -1.92110000E-04  +4.25300000E-05  -6.23600000E-05
   +1.54230000E-04  +4.36000000E-06  +2.29200000E-05  -2.10660000E-04  -1.40740000E-04
   -3.50160000E-04  +2.26600000E-04  -4.84300000E-05  +5.06600000E-05  +9.36100000E-05
   +7.80000000E-06  -7.07300000E-05  -3.56000000E-05  +1.19940000E-04  -1.10560000E-04
   -1.01810000E-03  +3.74880000E-04  -6.04070000E-04  -2.83880000E-04  -1.33930000E-04
   -6.07600000E-05  -1.47770000E-04  +1.53650000E-04  -1.36450000E-04  +2.03470000E-04
   -1.51380000E-04  -1.56870000E-04  +2.43523480E-01  +4.98348800E-02  -7.22520200E-02
   -4.83499800E-02  +2.11240600E-02  -2.95440000E-04  -1.44506300E-02  -1.73103000E-03
   -2.62633000E-03  -5.12369000E-03  -4.65330000E-04  -1.02376000E-03  +2.97440000E-04
   -4.72967000E-03  -1.18350000E-04  -2.99296000E-03  -1.69447400E-02  +8.46373000E-03
   +1.17789200E-02  +1.23645000E-03  -3.17000000E-04  +1.06268000E-03  -1.25030000E-04
   -6.22650000E-04  -3.33750000E-04  -8.07460000E-04  +3.67820000E-04  +7.32430000E-04
   -2.44320000E-04  -3.27590000E-04  -2.76950000E-04  -4.11010000E-04  +1.67700000E-04
   +1.54200000E-04  -7.57800000E-05  -1.73220000E-04  +2.24950000E-04  +7.38800000E-05
   -7.02700000E-05  -2.23400000E-04  -2.50870000E-04  -2.38440000E-04  +5.20000000E-06
   +1.06120000E-04  +1.13277000E-03  -1.71000000E-05  +4.28400000E-05  -3.83600000E-05
   +6.40400000E-05  +7.80000000E-05  -5.06500000E-05  +1.67900000E-05  +1.00600000E-04
   +7.48400000E-05  +7.19400000E-05  +3.35300000E-05  -1.20922000E-03  +9.46500000E-05
   -2.42270000E-04  -2.36670000E-04  +1.30180000E-04  +1.98070000E-04  -1.19380000E-04
   +2.70510000E-04  +1.10942000E-03  -1.75340000E-04  -8.10150000E-04  -4.94148700E-02
   +7.03634700E-02  +1.31095880E-01  -4.59408800E-02  -1.40103010E-01  +1.48792000E-02
   -3.77605000E-03  -5.70882000E-03  +1.05900000E-03  -5.68739000E-03  +1.91699000E-03
   -1.00231000E-03  +3.49860000E-04  -3.57680000E-04  +1.72745000E-03  -3.04231000E-03
   +5.71117000E-03  -3.66090000E-04  -1.44982000E-03  +3.90856000E-03  +4.73900000E-05
   +1.78103000E-03  -1.88667000E-03  +1.88100000E-05  +1.49350000E-04  +3.80400000E-05
   +2.38050000E-04  +1.32610000E-04  -6.47200000E-05  -2.72880000E-04  -1.44220000E-04
   -4.24600000E-05  -2.94970000E-04  +4.35390000E-04  +2.38870000E-04  -2.09900000E-05
   -8.30000000E-06  +2.99740000E-04  -2.83600000E-04  +4.88800000E-05  -1.36190000E-04
   +2.61400000E-04  +1.78960000E-04  +6.27800000E-05  -3.65080000E-04  -8.98950000E-04
   -7.41860000E-04  +3.36730000E-04  -5.50800000E-05  +8.05100000E-05  +1.49410000E-04
   +3.00600000E-05  -1.76510000E-04  -2.35190000E-04  +1.00100000E-05  -4.40600000E-05
   +2.26090000E-04  +3.94120000E-04  +1.79650000E-04  -1.24430000E-04  +9.69200000E-05
   -1.07410000E-04  -1.50100000E-04  +3.01580000E-04  -4.11880000E-04  +7.62250000E-04
   -8.42900000E-05  -4.95520000E-04  -1.45912560E-01  +5.47668000E-02  +1.39771080E-01
   +4.44582000E-03  -2.09096900E-02  -1.50306900E-02  -2.21874000E-03  -4.42598000E-03
   +2.63002000E-03  -1.55288000E-03  -2.37670000E-04  +1.28780000E-04  -2.87238000E-03
   -3.67270000E-04  +4.43911000E-03  +5.53950000E-03  +2.11639100E-02  +1.41103700E-02
   -5.59016500E-02  -6.35923000E-03  +6.83527000E-03  +5.54850000E-04  -7.91170000E-04
   -7.26250000E-04  +1.57300000E-05  +6.00800000E-05  -1.15090000E-04  +1.07047000E-03
   +5.61410000E-04  -2.07699000E-03  +9.41300000E-05  -4.50000000E-07  +3.69800000E-05
   +2.12200000E-05  -2.43800000E-05  -1.23800000E-05  +2.77800000E-05  +1.15710000E-04
   -2.78500000E-05  -5.98600000E-05  +4.54000000E-06  +3.43900000E-05  +9.54100000E-05
   +5.83700000E-05  +1.56400000E-05  -6.97200000E-05  -2.87790000E-04  -1.18080000E-04
   +3.30300000E-05  +7.04000000E-06  +1.60000000E-07  -6.12000000E-06  +1.76800000E-05
   +5.00000000E-06  -3.51350000E-04  -1.19010000E-04  +9.95900000E-05  +1.91970000E-04
   +4.06810000E-04  +8.41600000E-05  +1.90650000E-04  -9.10000000E-06  -3.99010000E-04
   +4.86600000E-05  +1.10169000E-03  +7.62710000E-04  -6.28800000E-05  +1.42800000E-04
   -2.78110000E-04  +1.05220000E-04  +1.42921000E-03  -1.67724000E-03  +5.09165500E-02
   +2.04435000E-03  -1.10187400E-02  -1.06943100E-02  -4.54357000E-03  +1.76698000E-03
   -1.57529000E-03  +1.10460000E-04  +2.05740000E-04  +7.45590000E-04  +4.17000000E-05
   +2.21820000E-03  -2.20213000E-03  -3.47677000E-03  -2.80003000E-03  -3.40888000E-03
   -5.15587000E-03  -2.48621820E-01  -1.42167430E-01  +3.40490000E-04  -2.88220000E-04
   -6.90060000E-04  -6.13200000E-05  -1.98400000E-05  -3.47000000E-05  +9.52500000E-04
   -8.62100000E-05  +1.71826000E-03  +1.34450000E-04  -6.12500000E-05  +4.57800000E-05
   +9.58000000E-06  -2.37000000E-06  -8.59000000E-06  +2.19600000E-05  +6.40800000E-05
   -4.13500000E-05  +3.01600000E-05  -1.14400000E-05  +1.93100000E-05  -5.71000000E-06
   +1.30500000E-05  +1.71900000E-05  +1.56900000E-05  -5.85900000E-05  -3.85700000E-05
   -4.98000000E-05  +1.36100000E-05  -1.04600000E-05  -3.82200000E-05  +1.02500000E-05
   +3.66800000E-05  -2.66610000E-04  -1.54100000E-04  +1.27960000E-04  +1.89400000E-05
   +6.11100000E-05  +3.89700000E-05  +5.86700000E-05  -7.46300000E-05  +2.59360000E-04
   -7.03000000E-06  -1.24980000E-04  -4.99300000E-05  +1.76150000E-04  -2.55000000E-04
   +2.23050000E-04  +9.57040000E-04  -5.93670000E-04  +2.31355000E-03  +8.71229000E-03
   +2.60011560E-01  +5.41690000E-04  +2.19473000E-03  +4.23883000E-03  +2.43163000E-03
   -2.09621000E-03  +5.16889000E-03  +2.03810000E-04  +9.72690000E-04  -4.28940000E-04
   +4.83712000E-03  -1.91767000E-03  +1.42899000E-03  -2.37528000E-03  -1.73316900E-02
   -5.50733000E-03  +7.31716000E-03  -1.41083400E-01  -1.36088390E-01  +2.65240000E-04
   -2.94700000E-05  +2.17690000E-04  -1.63100000E-05  +8.73000000E-06  -6.25800000E-05
   -1.98492000E-03  +1.85742000E-03  -1.00473000E-03  -1.04230000E-04  -9.70000000E-06
   +1.36000000E-05  +4.00200000E-05  -4.57300000E-05  -3.90600000E-05  +2.68200000E-05
   +8.87400000E-05  -1.78600000E-05  -4.59100000E-05  +1.03400000E-05  +4.51400000E-05
   +7.39300000E-05  +3.82700000E-05  -1.37000000E-06  -5.97100000E-05  -2.11000000E-04
   -5.95900000E-05  +2.28400000E-05  +5.60000000E-06  -1.15300000E-05  -3.16000000E-06
   +1.07800000E-05  -2.61200000E-05  -1.59900000E-05  +7.67900000E-05  -1.59500000E-05
   +1.97360000E-04  +3.51040000E-04  -5.06300000E-05  -3.41620000E-04  +3.07160000E-04
   -1.35690000E-04  -5.10700000E-05  -6.80720000E-04  -5.00060000E-04  -2.64860000E-04
   +2.54550000E-04  -4.14770000E-04  -1.70169000E-03  +1.95046000E-03  -2.44391000E-03
   -8.74832000E-03  +1.55369340E-01  +1.35662570E-01  +2.23600000E-04  +2.72900000E-04
   +1.28870000E-04  +8.63720000E-04  -1.05484000E-03  +1.33890000E-04  +1.73290000E-04
   +1.94870000E-04  +8.34800000E-05  +8.74300000E-05  +8.20900000E-05  -4.84900000E-05
   +8.28000000E-06  -8.89100000E-05  -1.03680000E-04  -1.54760000E-04  -1.84100000E-05
   -3.34300000E-05  -9.95920000E-04  -6.92620000E-04  +8.01970000E-04  -2.41378660E-01
   +1.20456340E-01  -2.05992600E-02  +6.38200000E-05  +3.77100000E-05  +1.68500000E-05
   +5.99610000E-04  -4.95800000E-05  -1.13560000E-04  -9.81300000E-05  +3.57800000E-05
   +1.90340000E-04  +1.95010000E-04  -5.88100000E-05  -2.56640000E-04  +1.03540000E-04
   +7.01100000E-05  +1.73250000E-04  +1.78100000E-05  +4.14000000E-06  -4.49600000E-05
   +1.49560000E-04  -3.73580000E-04  +4.61770000E-04  -1.76890000E-04  +1.61200000E-05
   -8.99900000E-05  -1.29550000E-04  +3.13500000E-05  +1.25000000E-05  +2.78100000E-05
   -1.82530000E-04  +3.83800000E-04  +2.19100000E-05  +3.40070000E-04  -4.41000000E-05
   -1.20800000E-05  -3.60000000E-06  +2.80000000E-07  +2.57300000E-05  +1.55300000E-05
   -1.94000000E-06  +2.51900000E-05  +1.76000000E-05  -1.15100000E-05  +1.88100000E-05
   -5.37200000E-05  +2.33600000E-05  -5.46000000E-06  +9.86000000E-06  -4.74000000E-06
   +2.58984820E-01  +2.07800000E-05  -4.36020000E-04  -4.76550000E-04  +9.73870000E-04
   +5.80910000E-04  -2.76930000E-04  -3.36140000E-04  +1.03930000E-04  +1.12400000E-05
   -1.43950000E-04  -1.23900000E-05  +6.29000000E-05  -1.63660000E-04  -1.05320000E-04
   +6.84700000E-05  +1.72600000E-05  +2.28000000E-05  -2.15800000E-05  +1.25459100E-02
   -9.67873000E-03  +1.31654000E-03  +1.19006310E-01  -1.20280510E-01  +1.17460300E-02
   +1.45660000E-04  +1.41340000E-04  -1.87100000E-05  -7.36820000E-04  -7.86390000E-04
   +2.65781000E-03  -5.24190000E-04  +1.89460000E-04  +2.88720000E-04  -5.08800000E-05
   -6.34200000E-05  +1.41610000E-04  -7.97000000E-05  +6.12100000E-05  -5.54800000E-05
   -5.26200000E-05  -1.57540000E-04  +2.58720000E-04  +1.02956000E-03  +1.00220000E-04
   +1.24390000E-04  +1.76980000E-04  -7.61100000E-05  +6.15800000E-05  +1.44380000E-04
   -2.22100000E-05  -6.13500000E-05  -5.24990000E-04  +3.78570000E-04  -1.06117000E-03
   -1.65110000E-04  -1.48640000E-04  +3.35900000E-05  -2.34800000E-05  -1.79000000E-05
   +2.41700000E-05  +7.60000000E-06  -8.68000000E-06  +3.70000000E-06  +3.22800000E-05
   -4.87000000E-06  +5.46900000E-05  +1.86800000E-05  +1.57220000E-04  +1.22190000E-04
   +1.31300000E-05  -8.29000000E-06  +1.42100000E-05  -1.31149470E-01  +1.28629550E-01
   +4.06050000E-04  +1.42780000E-04  +1.99400000E-05  -9.84150000E-04  -6.41140000E-04
   +7.18920000E-04  -1.50000000E-06  -1.24650000E-04  +2.01000000E-04  +1.81560000E-04
   +1.07760000E-04  -5.84500000E-05  +2.14620000E-04  -3.18300000E-05  -1.95300000E-04
   -3.98710000E-04  +3.00000000E-06  +8.01300000E-05  -2.51741000E-02  +1.57297800E-02
   -4.55557000E-03  -1.87761100E-02  +1.07644200E-02  -4.80570100E-02  -2.03040000E-04
   -1.44280000E-04  +2.13100000E-05  +1.26864000E-03  +2.41887000E-03  -5.26726000E-03
   +9.48970000E-04  -2.57260000E-04  -3.27500000E-04  -7.59100000E-05  +2.59940000E-04
   +9.15800000E-05  +1.11060000E-04  -1.32730000E-04  +4.78100000E-05  +1.24970000E-04
   +8.46500000E-05  -2.87320000E-04  -1.53200000E-03  +5.83640000E-04  +4.52200000E-05
   -1.04340000E-04  +5.52200000E-05  +5.18000000E-06  -8.22900000E-05  +1.69500000E-05
   +1.05960000E-04  -1.22711000E-03  +9.71160000E-04  +1.30265000E-03  +3.43300000E-05
   +2.66640000E-04  -1.38300000E-05  +2.64500000E-05  +3.24000000E-06  -2.96000000E-06
   -8.23000000E-06  +1.11300000E-05  +9.17000000E-06  +2.94300000E-05  -1.65300000E-05
   -9.70200000E-05  -1.77000000E-06  -2.93000000E-06  +4.86800000E-05  +9.62000000E-06
   -1.03900000E-05  +7.00000000E-07  +2.15481700E-02  -1.56211300E-02  +5.42514200E-02
   +1.85700000E-04  +4.68100000E-04  +3.71650000E-04  +5.60560000E-04  -5.26510000E-04
   +7.26520000E-04  +5.17330000E-04  -2.16650000E-04  -1.15230000E-04  -2.55800000E-05
   -6.06200000E-05  -6.66200000E-05  +3.06960000E-04  +1.79070000E-04  -5.78500000E-05
   -2.39390000E-04  -8.34000000E-06  +4.93200000E-05  -1.93020000E-04  +8.39420000E-04
   -1.97320000E-04  -2.05615060E-01  -1.28148600E-01  +1.76575100E-02  -3.19650000E-04
   -2.35210000E-04  +2.45300000E-05  +2.19120000E-04  +2.04060000E-04  -2.79040000E-04
   -6.31660000E-04  +8.19890000E-04  +1.64420000E-04  +8.59700000E-05  -2.34200000E-05
   -6.32800000E-05  -6.74700000E-05  +7.16200000E-05  -5.78000000E-06  +5.02200000E-05
   +1.38500000E-05  +5.62000000E-05  +8.41700000E-05  -2.84990000E-04  +9.72300000E-05
   +8.38400000E-05  -4.09700000E-05  +1.12200000E-05  +8.00300000E-05  -1.79000000E-05
   -5.14000000E-05  +1.29970000E-04  +2.13080000E-04  -3.76920000E-04  +5.91400000E-05
   +1.20620000E-04  +3.00100000E-05  +4.50100000E-05  +1.31100000E-05  -2.07300000E-05
   -3.66100000E-05  -8.31000000E-06  +6.28000000E-06  -4.66100000E-05  +5.32700000E-05
   +4.27000000E-06  +5.61000000E-06  -2.80200000E-05  -9.95000000E-06  -2.63800000E-05
   -1.28800000E-05  -1.66400000E-05  -1.93154500E-02  -1.79722800E-02  +2.07423000E-03
   +2.22862370E-01  -3.61780000E-04  -1.47040000E-04  +2.62930000E-04  +3.26300000E-05
   -4.48930000E-04  +3.26602000E-03  +5.95840000E-04  -3.81740000E-04  -1.93920000E-04
   -5.99320000E-04  -4.75680000E-04  -2.85210000E-04  +2.82100000E-05  +5.96130000E-04
   +4.45740000E-04  +3.77630000E-04  +1.69790000E-04  -1.53100000E-05  -1.14299300E-02
   -9.63700000E-03  +1.40500000E-05  -1.27352550E-01  -1.51218840E-01  +1.39902600E-02
   -3.85640000E-04  -3.31880000E-04  -1.98300000E-05  -7.49860000E-04  +3.91340000E-04
   -5.08740000E-04  -7.80000000E-05  -4.39500000E-05  +5.78690000E-04  +2.46380000E-04
   -1.09560000E-04  -3.69500000E-04  +1.64000000E-06  +1.34500000E-04  +1.87570000E-04
   +7.47800000E-05  +7.61000000E-05  -4.95100000E-05  +9.66800000E-05  -5.33000000E-04
   +2.20940000E-04  -1.05420000E-04  -1.40200000E-05  -1.07520000E-04  -7.12900000E-05
   +4.94400000E-05  -6.45600000E-05  +2.82710000E-04  +4.03260000E-04  -1.20114000E-03
   +1.41080000E-04  +5.13350000E-04  -3.36000000E-05  +5.71600000E-05  +2.41600000E-05
   -2.80400000E-05  -9.70800000E-05  -7.33000000E-06  -3.85600000E-05  +3.40600000E-05
   +2.80000000E-06  +1.22920000E-04  -1.06950000E-04  +2.15830000E-04  -1.60980000E-04
   -8.62000000E-06  -3.82200000E-05  -4.63000000E-06  +1.34671700E-02  +1.19247400E-02
   -1.83708000E-03  +1.40811280E-01  +1.62019010E-01  +2.01040000E-04  -3.11340000E-04
   -2.50000000E-07  -1.02607000E-03  +1.66024000E-03  -4.77639000E-03  +3.71890000E-04
   +6.80530000E-04  +7.67500000E-05  +2.86960000E-04  -1.16900000E-05  +4.05320000E-04
   -3.12220000E-04  -2.63480000E-04  -5.39200000E-05  +4.38740000E-04  -7.06200000E-05
   +1.33660000E-04  +2.33798700E-02  +1.78539200E-02  -3.25578000E-03  +1.70537600E-02
   +1.27569000E-02  -4.99681200E-02  +4.94120000E-04  +4.22930000E-04  -4.13800000E-05
   +6.19440000E-04  -6.69720000E-04  +8.01360000E-04  -6.39840000E-04  +7.39000000E-05
   +5.31960000E-04  -3.72500000E-05  +1.97100000E-05  +2.24800000E-05  -7.59600000E-05
   +4.47200000E-05  +3.74200000E-05  +1.07200000E-05  -7.91700000E-05  -1.96400000E-05
   +2.02400000E-05  +1.45020000E-04  -2.52920000E-04  +6.30800000E-05  -3.81000000E-05
   +2.40000000E-06  +2.75100000E-05  -7.62000000E-06  -6.10200000E-05  +1.02886000E-03
   +9.42410000E-04  +1.33993000E-03  -4.59900000E-05  -3.12530000E-04  +1.22900000E-05
   -5.83900000E-05  +6.89000000E-06  +2.86200000E-05  +9.15700000E-05  +3.19700000E-05
   -3.63000000E-06  -4.17800000E-05  +8.89300000E-05  -1.98940000E-04  -2.22750000E-04
   +2.97680000E-04  -1.02930000E-04  +3.40400000E-05  +3.70000000E-05  +1.53400000E-05
   -1.85048000E-03  -2.00317000E-03  -7.34230000E-04  -1.96980600E-02  -1.71825600E-02
   +5.33997100E-02  -6.97800000E-05  -1.50390000E-04  +4.43700000E-05  +3.16800000E-05
   +7.35630000E-04  +4.42610000E-04  -2.18070000E-04  -6.72100000E-05  +9.14000000E-05
   +1.43070000E-04  +1.00840000E-04  +4.37100000E-05  -8.56000000E-06  -1.44040000E-04
   -6.98600000E-05  -2.60370000E-04  -6.55000000E-05  -5.50800000E-05  -1.89279000E-03
   -3.87300000E-04  -2.77820000E-04  -4.76592800E-02  +5.62628000E-03  +6.80068000E-03
   +5.56900000E-05  +4.78000000E-05  -1.13300000E-05  +3.09610000E-04  -4.46390000E-04
   -3.72350000E-04  -9.03000000E-06  +5.11800000E-05  -6.48360000E-04  -8.30200000E-05
   +9.63800000E-05  +2.42540000E-04  -2.41500000E-05  -1.06780000E-04  -1.41150000E-04
   -3.28700000E-05  -2.29600000E-05  +5.61800000E-05  +2.22200000E-05  +2.22310000E-04
   -3.91600000E-05  +9.98600000E-05  +4.82000000E-06  +8.52600000E-05  +9.46100000E-05
   -2.39100000E-05  +6.59100000E-05  -7.83100000E-05  +1.40200000E-05  -9.78100000E-05
   -8.99500000E-05  -2.10660000E-04  +2.11800000E-05  -9.87000000E-06  -1.08400000E-05
   +1.12500000E-05  +2.81000000E-06  +5.82000000E-06  -9.62000000E-06  +3.65300000E-05
   -2.53000000E-06  -6.43700000E-05  +2.26510000E-04  -1.85750000E-04  +1.08770000E-04
   +1.59600000E-05  -1.55900000E-05  +2.09000000E-05  -2.06100000E-04  +1.82564000E-02
   +2.10892100E-02  +1.57194000E-03  -1.63645300E-02  -1.93728100E-02  +4.83518500E-02
   -4.31930000E-04  -1.64780000E-04  +7.12850000E-04  +9.07700000E-05  +8.17600000E-04
   +6.47300000E-05  -3.06000000E-06  -1.14200000E-05  -1.07960000E-04  +4.56100000E-05
   +7.03000000E-05  +8.57600000E-05  -4.92400000E-05  -4.42500000E-05  -6.61500000E-05
   +1.21270000E-04  -1.08220000E-04  -6.67700000E-05  -8.23930000E-04  +9.71688000E-03
   +1.13728100E-02  +5.80595000E-03  -1.70522760E-01  -1.35126650E-01  +1.39670000E-04
   +8.98800000E-05  -7.96000000E-06  -5.97800000E-05  +7.23520000E-04  -2.43430000E-04
   +7.95410000E-04  -1.15000000E-05  -2.14110000E-04  -1.11640000E-04  +5.77900000E-05
   +1.11300000E-04  +9.09900000E-05  -6.46200000E-05  -4.65500000E-05  -5.26700000E-05
   +3.46600000E-05  +2.81200000E-05  -2.38130000E-04  +2.26300000E-05  -4.98700000E-05
   -5.55500000E-05  +2.95800000E-05  +2.63300000E-05  -1.73900000E-05  +3.02000000E-06
   +8.37700000E-05  +2.40800000E-05  -7.76400000E-04  +2.31073000E-03  -5.33900000E-05
   +5.38000000E-06  +6.71000000E-06  -1.40000000E-05  -2.13000000E-06  -3.00000000E-08
   +1.49400000E-05  +4.20000000E-07  -4.18000000E-06  +2.42000000E-06  -6.73000000E-06
   +2.02600000E-05  -3.40800000E-05  -7.86080000E-04  +3.36670000E-04  +6.71000000E-06
   +1.82000000E-06  +2.20100000E-05  -8.38240000E-04  -1.09444300E-02  -1.15316300E-02
   +2.40819000E-03  -1.25770900E-02  -1.36074600E-02  -6.99800000E-03  +1.83703970E-01
   +2.92830000E-04  -6.60200000E-04  -8.54700000E-05  -1.44965000E-03  -8.96670000E-04
   +8.84540000E-04  +8.51790000E-04  +7.16500000E-05  -2.05770000E-04  -4.69040000E-04
   -4.33280000E-04  -7.24700000E-05  -2.38730000E-04  +4.00350000E-04  +3.57230000E-04
   +5.07180000E-04  +3.73030000E-04  +1.74260000E-04  +1.31504000E-03  -2.02701800E-02
   -2.08095700E-02  +7.28810000E-03  -1.32435070E-01  -1.92484580E-01  -7.11600000E-05
   -4.11000000E-05  -4.41000000E-06  +1.11805000E-03  -8.90220000E-04  +1.08622000E-03
   -5.99500000E-05  -7.53600000E-05  +2.38770000E-04  -1.30590000E-04  +3.43210000E-04
   +2.02090000E-04  +2.88800000E-05  -1.05170000E-04  -5.77000000E-06  +9.87000000E-05
   -2.60700000E-05  +1.23110000E-04  +7.67400000E-05  +2.76080000E-04  -1.72620000E-04
   +6.60800000E-05  -2.40000000E-06  +5.18100000E-05  +1.46700000E-05  +1.87000000E-06
   +4.89500000E-05  +1.48800000E-05  +4.31993000E-03  -5.22703000E-03  +8.46500000E-05
   +3.70000000E-07  +7.05100000E-05  +9.74000000E-06  +1.12400000E-05  -8.78000000E-06
   -1.24700000E-05  +1.10000000E-05  -2.24400000E-05  -1.41140000E-04  +2.74000000E-05
   +7.15700000E-05  -2.47250000E-04  +6.86240000E-04  -1.96000000E-05  +4.15600000E-05
   +5.05000000E-06  -1.89000000E-06  +9.39000000E-06  +2.87191000E-03  +2.65046000E-03
   -4.91900000E-04  +3.21380000E-03  +2.92279000E-03  -7.61846000E-03  +1.44701950E-01
   +2.11135350E-01  -5.81000000E-05  -3.73400000E-05  -1.47300000E-05  +2.39640000E-04
   +3.01990000E-04  -5.14090000E-04  -1.37300000E-05  -4.83920000E-04  -5.14090000E-04
   -1.02090000E-04  +9.35500000E-05  +2.17080000E-04  -5.98200000E-05  -2.48700000E-05
   +9.75000000E-06  +7.95600000E-05  +7.04700000E-05  +1.66200000E-05  -1.87807000E-03
   -2.04840000E-04  +1.62680000E-04  -1.27200000E-05  +4.87000000E-06  -1.10500000E-04
   +1.02690000E-04  +1.21090000E-04  +2.15800000E-05  +8.84000000E-05  -5.10520000E-04
   +4.52810000E-04  -1.16590000E-04  +1.35110000E-04  -7.07700000E-05  -1.79090000E-04
   -2.97290000E-04  -2.32700000E-05  -3.70520000E-04  +5.17100000E-05  +3.35940000E-04
   +1.64870000E-04  -2.70400000E-04  -2.68880000E-04  -6.55600000E-05  +4.97770000E-04
   +3.55190000E-04  +1.90240000E-04  -1.98100000E-05  -1.37300000E-05  +6.89000000E-05
   +2.59700000E-05  -1.23240000E-04  -4.72392200E-02  -2.18829000E-03  +6.58690000E-03
   -1.96840000E-04  -2.68900000E-05  +2.23700000E-05  -2.94800000E-05  -2.16000000E-05
   -2.16000000E-06  +2.90000000E-07  -6.70000000E-07  -2.53000000E-05  -1.20594000E-03
   +8.98100000E-05  -4.92700000E-04  -4.10000000E-06  +4.34800000E-05  +3.28100000E-05
   +9.79000000E-06  +7.87000000E-06  +1.24400000E-05  +2.79460000E-04  -2.26220000E-04
   +3.35010000E-04  +1.85630000E-04  +2.67490000E-04  -2.81920000E-04  +6.74450000E-04
   +4.23700000E-05  +9.79000000E-06  +4.77267600E-02  +2.33570000E-04  -1.75770000E-04
   +3.42000000E-05  +2.48130000E-04  +1.11566000E-03  +3.80780000E-04  -6.47920000E-04
   +2.45950000E-04  +5.75600000E-05  -4.60500000E-05  -1.82830000E-04  -8.96900000E-05
   -1.50400000E-04  +3.74400000E-05  +1.75640000E-04  +1.65480000E-04  +8.64800000E-05
   -5.77200000E-05  +7.85180000E-04  +9.89954000E-03  -2.16791000E-02  +8.68500000E-05
   -3.33928000E-03  -2.87635000E-03  +8.74900000E-05  +3.06400000E-05  -2.75100000E-05
   -5.96560000E-04  +1.16650000E-03  +2.46710000E-04  +2.92270000E-04  -1.70520000E-04
   +4.58900000E-05  -4.14800000E-05  +2.73670000E-04  -1.95530000E-04  -7.92000000E-05
   -1.80600000E-05  +1.29380000E-04  +4.24000000E-06  -1.81710000E-04  +7.84900000E-05
   +7.19980000E-04  -2.52290000E-04  -5.34540000E-04  -6.19200000E-05  +3.44000000E-06
   -2.55000000E-05  -6.71400000E-05  -2.00700000E-05  +3.86700000E-05  -1.84611000E-03
   -9.04229700E-02  +9.84174200E-02  -1.98400000E-05  -6.41700000E-05  -1.38700000E-05
   -6.50000000E-06  +6.41000000E-06  +7.61000000E-06  -1.14800000E-05  +2.31800000E-05
   -2.72500000E-05  -3.62060000E-04  -2.34490000E-04  -2.09670000E-04  -1.39000000E-05
   +3.23900000E-05  -2.95200000E-05  +7.70000000E-06  +2.02100000E-05  -1.70700000E-05
   -2.44970000E-04  -3.35200000E-05  -1.15550000E-04  +2.56950000E-04  -5.40000000E-06
   -7.77600000E-05  -3.50000000E-05  +7.63160000E-04  -1.40336000E-03  +2.80843000E-03
   +9.69803300E-02  -9.32200000E-05  -5.09160000E-04  +4.54000000E-05  +8.94070000E-04
   +1.02998000E-03  +7.33820000E-04  +4.04740000E-04  -2.53640000E-04  +1.18250000E-04
   -3.05610000E-04  -1.58610000E-04  +2.22500000E-04  -1.30660000E-04  +2.16800000E-04
   +1.46060000E-04  +2.38000000E-04  +1.48440000E-04  -3.79100000E-05  +4.79400000E-04
   +1.02166500E-02  -1.96777100E-02  +2.47290000E-04  -5.00228000E-03  -2.70022000E-03
   +4.90000000E-07  +1.81500000E-05  +6.46000000E-06  -1.11714000E-03  +5.94330000E-04
   +6.81530000E-04  +5.78070000E-04  -3.02640000E-04  -5.79400000E-05  +2.14120000E-04
   +7.07630000E-04  +6.61800000E-05  +3.30720000E-04  -1.78550000E-04  -4.90500000E-04
   -4.29090000E-04  +7.80000000E-05  +3.80610000E-04  +8.46620000E-04  +3.53740000E-04
   -3.06530000E-04  -1.40470000E-04  -1.40600000E-05  +5.95200000E-05  -6.89800000E-05
   -1.04740000E-04  +1.82190000E-04  +6.41997000E-03  +9.68958500E-02  -2.71218960E-01
   +3.86000000E-06  -4.43970000E-04  -1.03160000E-04  -1.39300000E-05  -1.03900000E-05
   -9.04000000E-06  -1.73800000E-05  -2.99300000E-05  -3.20000000E-06  -4.97220000E-04
   +2.69570000E-04  -2.22000000E-06  -4.11600000E-05  +1.02530000E-04  +1.88800000E-05
   -2.72700000E-05  +1.49000000E-05  -3.66000000E-05  +3.45500000E-05  -4.91600000E-05
   +3.48210000E-04  +3.63300000E-05  -6.80000000E-07  +3.74280000E-04  +1.13100000E-05
   +6.01830000E-04  -1.54155000E-03  -7.32543000E-03  -1.04835610E-01  +2.96015980E-01
   +1.20910000E-04  +2.16490000E-04  +2.31390000E-04  +5.42390000E-04  +2.83700000E-04
   +3.03870000E-04  -2.60840000E-04  +1.73310000E-04  +3.95890000E-04  +2.11010000E-04
   -1.79560000E-04  -2.04990000E-04  +9.88300000E-05  +6.03200000E-05  -3.39900000E-05
   -7.80900000E-05  -7.14200000E-05  -7.81400000E-05  -5.84230000E-04  +1.38405000E-03
   +7.36130000E-04  -6.67600000E-05  +2.62620000E-04  +2.13150000E-04  -1.72650000E-04
   -1.69060000E-04  -2.52700000E-05  +8.94640000E-04  +1.44711000E-03  -3.88200000E-05
   +3.56870000E-04  -1.01590000E-04  +1.08890000E-04  -3.77700000E-05  -9.45100000E-05
   -4.47900000E-05  -8.14600000E-05  +7.60000000E-06  -1.00100000E-05  +5.69000000E-05
   -3.95900000E-05  -1.80800000E-05  +8.78400000E-05  -3.63840000E-04  +1.14140000E-04
   +7.44400000E-05  -5.94000000E-06  +1.51300000E-05  +7.14800000E-05  -1.74200000E-05
   -3.01500000E-05  -2.35703980E-01  -1.24205690E-01  +1.86491300E-02  -8.05000000E-06
   +2.40200000E-04  +7.61300000E-05  +4.45300000E-05  +2.77300000E-05  -1.49000000E-06
   -2.28000000E-05  -2.29000000E-06  +2.23700000E-05  +1.95900000E-04  -2.33680000E-04
   -4.57230000E-04  +7.77800000E-05  -5.78800000E-05  -4.05500000E-05  -2.03200000E-05
   -2.10000000E-06  -1.74300000E-05  -3.54600000E-05  -1.22240000E-04  +6.33000000E-05
   +3.01970000E-04  +1.24890000E-04  -4.65530000E-04  +2.47510000E-04  +2.25020000E-04
   -7.01400000E-05  +2.17200000E-05  +9.61950000E-04  -3.24910000E-04  +2.52927960E-01
   -1.47529000E-03  -2.66270000E-04  +2.43660000E-04  +1.55238000E-03  -2.41622000E-03
   -3.92425000E-03  +7.02530000E-04  -1.51400000E-05  -5.41130000E-04  -1.41390000E-04
   +1.31470000E-04  +4.40400000E-05  +3.06910000E-04  +1.31810000E-04  -7.48900000E-05
   +5.18000000E-06  -4.05210000E-04  -1.33890000E-04  -1.94290400E-02  -1.50700100E-02
   +1.90462000E-03  +2.60500000E-05  +4.25970000E-04  +1.30690000E-03  -2.73890000E-04
   -1.86240000E-04  +5.07900000E-05  -1.62028000E-03  +6.03920000E-04  +6.36620000E-04
   +7.84500000E-04  +3.39800000E-05  -8.23700000E-05  +1.04730000E-04  +2.01090000E-04
   -2.51900000E-04  +1.43960000E-04  -1.01790000E-04  +3.18900000E-05  +1.65120000E-04
   +2.79280000E-04  +1.18160000E-04  -4.16760000E-04  -7.15060000E-04  +8.50700000E-05
   -1.42410000E-04  +5.41200000E-05  -6.17900000E-05  -7.54900000E-05  +1.87800000E-05
   +8.12600000E-05  -1.21807300E-01  -1.26114990E-01  +1.33536600E-02  +3.45320000E-04
   +4.68100000E-04  +5.51800000E-05  +2.78900000E-05  +1.05100000E-05  -1.80100000E-05
   -5.43900000E-05  -1.48900000E-05  -1.80000000E-07  +1.41400000E-04  +9.00400000E-05
   +3.46910000E-04  -6.52000000E-06  +3.34400000E-05  -8.49400000E-05  -9.39700000E-05
   -1.10310000E-04  +3.65700000E-05  +1.32270000E-04  +3.63900000E-05  -5.36200000E-05
   +1.63850000E-04  +6.06990000E-04  -3.98210000E-04  +3.07630000E-04  +4.70300000E-05
   +1.18760000E-04  -1.01381900E-02  -7.18554000E-03  +4.47000000E-04  +1.34311520E-01
   +1.37725580E-01  -1.24944000E-03  -8.19380000E-04  +3.91860000E-04  +1.26249000E-03
   -2.68905000E-03  -3.15159000E-03  +8.50720000E-04  -3.12290000E-04  -2.86490000E-04
   -1.99480000E-04  -4.38400000E-05  +2.14900000E-04  +4.50700000E-05  +1.40680000E-04
   +1.87100000E-05  +1.69970000E-04  -2.29070000E-04  -2.11490000E-04  -1.92833300E-02
   -1.32156400E-02  +2.61500000E-04  -1.20559000E-03  -7.05290000E-04  +1.10120000E-03
   -8.06000000E-05  -1.71300000E-05  +1.81200000E-05  -9.27400000E-04  +5.20320000E-04
   +5.84990000E-04  +2.06740000E-04  +1.42480000E-04  -5.92000000E-06  -8.18600000E-05
   -9.14100000E-05  -1.84050000E-04  -1.02580000E-04  +3.30800000E-05  +2.53640000E-04
   +2.10100000E-05  -2.08610000E-04  -1.02870000E-04  +4.23280000E-04  -1.07210000E-04
   -9.38900000E-05  -6.31100000E-05  +1.97400000E-05  -6.09700000E-05  -2.97700000E-05
   +9.76000000E-06  -3.90800000E-05  +1.99555500E-02  +1.44314600E-02  -4.88380700E-02
   -1.03220000E-04  +1.63700000E-04  +6.37900000E-05  -2.17000000E-06  -8.97000000E-06
   -3.84000000E-06  -1.58800000E-05  -2.78200000E-05  +1.31900000E-05  -1.21930000E-04
   +5.48250000E-04  +6.88300000E-05  -3.77000000E-06  +3.23700000E-05  +4.79000000E-06
   -1.04780000E-04  -4.93500000E-05  -2.50800000E-05  +3.04800000E-05  +2.04700000E-05
   -4.88800000E-05  +3.59410000E-04  +1.18880000E-04  -6.92050000E-04  +2.25500000E-04
   +2.01780000E-04  +2.39280000E-04  +2.54145300E-02  +1.55199500E-02  -1.45651000E-03
   -2.16639900E-02  -1.09017900E-02  +5.25446500E-02  +1.26950000E-04  +9.75100000E-05
   +1.86000000E-06  -4.09200000E-05  -2.96200000E-05  +2.48940000E-04  -1.00815000E-03
   -9.74290000E-04  +7.06310000E-04  +1.84800000E-04  -1.86440000E-04  -1.94160000E-04
   -1.68310000E-04  -2.70000000E-05  -2.17300000E-05  +2.08000000E-05  +7.26000000E-06
   -1.04300000E-05  -4.63050000E-04  -7.43250000E-04  -2.24590000E-04  +2.58640000E-04
   -3.24810000E-04  -3.16390000E-04  +8.06700000E-05  +2.39800000E-05  -3.20000000E-05
   +5.14400000E-05  +9.54630000E-04  +1.08382000E-03  +9.91640000E-04  -2.17000000E-06
   -2.64000000E-04  +1.99600000E-05  +3.98920000E-04  -3.41010000E-04  +1.65370000E-04
   -1.17090000E-04  +2.00680000E-04  +1.09700000E-04  +9.01600000E-05  +4.93200000E-05
   -1.81680000E-04  -5.58830000E-04  +1.45700000E-04  -2.36800000E-04  +7.04900000E-05
   -9.29200000E-05  -1.69100000E-04  -2.78000000E-06  +1.23380000E-04  -2.13306080E-01
   +1.26427960E-01  -2.53498500E-02  +2.24280000E-04  +4.33230000E-04  +1.73600000E-05
   -5.28000000E-06  +8.36000000E-06  +3.69000000E-06  +3.18500000E-05  -1.95000000E-06
   +2.80300000E-05  -1.29922000E-03  -2.11076000E-03  +1.55450000E-04  -2.40800000E-05
   -4.50000000E-06  -1.42800000E-05  +9.45000000E-06  +1.77400000E-05  -7.49000000E-06
   +3.13510000E-04  -5.48700000E-05  +4.26260000E-04  -1.76080000E-04  +1.27730000E-04
   +1.49500000E-05  +1.93450000E-04  -2.25110000E-04  +8.36900000E-05  +1.25938000E-03
   -2.26124000E-03  +4.90700000E-04  -1.92778500E-02  +1.67546400E-02  -3.81823000E-03
   +2.32633220E-01  -2.42980000E-04  -1.77190000E-04  -1.70540000E-04  +6.33620000E-04
   +8.00150000E-04  +3.77830000E-04  +6.61700000E-05  -5.42900000E-04  -6.12110000E-04
   -3.83450000E-04  +2.16590000E-04  +2.69890000E-04  -9.03900000E-05  +3.00400000E-05
   +1.24550000E-04  +1.70360000E-04  +1.70280000E-04  +1.60600000E-05  +1.86365200E-02
   -1.36018000E-02  +3.75111000E-03  +3.02500000E-05  +6.44690000E-04  +1.61901000E-03
   +1.23120000E-04  +1.62270000E-04  +3.30100000E-05  +3.59300000E-05  -2.53511000E-03
   -4.55652000E-03  -4.21700000E-04  -1.64000000E-06  +4.89640000E-04  +2.67340000E-04
   -7.58960000E-04  +6.19590000E-04  +1.07400000E-05  +5.17000000E-05  -5.29970000E-04
   -2.43930000E-04  +1.22490000E-04  +1.38200000E-04  +2.20190000E-04  +2.91980000E-04
   -1.16900000E-04  +2.35260000E-04  -7.18100000E-05  +1.76690000E-04  +3.37260000E-04
   +3.87600000E-05  -1.05590000E-04  +1.25111000E-01  -1.43245010E-01  +1.88463100E-02
   -5.19300000E-04  -1.72880000E-04  +1.04430000E-04  -3.92200000E-05  -4.10200000E-05
   +4.19000000E-06  +3.76000000E-06  -3.24000000E-05  -1.07000000E-05  -1.60717000E-03
   -1.12036000E-03  +9.37640000E-04  +4.15000000E-05  +8.63800000E-05  +1.14850000E-04
   +1.32400000E-05  -4.90000000E-06  +2.41700000E-05  -3.19830000E-04  +5.36040000E-04
   -5.56810000E-04  -9.89300000E-05  -3.97600000E-05  -9.94400000E-05  -3.25350000E-04
   +3.89500000E-05  +1.55910000E-04  +9.42343000E-03  -7.65476000E-03  +6.66870000E-04
   -1.41339300E-02  +1.18876300E-02  -2.59083000E-03  -1.37609520E-01  +1.54606560E-01
   +4.06200000E-05  -2.24400000E-05  -2.22440000E-04  +5.89600000E-05  +6.00160000E-04
   +4.63120000E-04  -4.82960000E-04  +4.81990000E-04  +5.22350000E-04  -1.86300000E-05
   -2.17220000E-04  -1.68310000E-04  -1.45200000E-04  +4.86400000E-05  +1.22260000E-04
   +1.01910000E-04  +4.66400000E-05  -3.88400000E-05  +1.87204700E-02  -1.31879800E-02
   +1.67940000E-03  +1.21737000E-03  -6.63130000E-04  +1.28001000E-03  +4.38800000E-05
   -8.15000000E-06  -3.66900000E-05  -3.31570000E-04  -2.94727000E-03  -3.15605000E-03
   +2.67740000E-04  -2.38230000E-04  +2.83090000E-04  +5.00370000E-04  +2.29650000E-04
   +5.74670000E-04  +3.60020000E-04  -7.86400000E-05  -7.46130000E-04  -4.57120000E-04
   +2.70340000E-04  +3.53070000E-04  +4.36170000E-04  +4.48210000E-04  -2.37750000E-04
   +1.72000000E-05  -8.04300000E-05  +1.54910000E-04  +1.24720000E-04  -5.28100000E-05
   +5.11200000E-05  -2.54576200E-02  +1.99392800E-02  -5.17087300E-02  -1.87090000E-04
   -4.73300000E-04  -1.43460000E-04  +3.61000000E-06  +9.03000000E-06  +9.74000000E-06
   +8.86000000E-06  +3.20000000E-06  +1.40700000E-05  +3.99810000E-04  +2.86240000E-04
   +2.89900000E-05  +3.51400000E-05  -1.31300000E-05  +1.72900000E-05  +1.94200000E-05
   -8.62000000E-06  +9.97000000E-06  -4.28600000E-04  -1.65000000E-05  -6.30460000E-04
   +5.91100000E-05  +8.72400000E-05  -6.97100000E-05  -1.70930000E-04  +1.80730000E-04
   +3.15700000E-04  -2.40727000E-02  +1.69927500E-02  -2.25347000E-03  +2.58974000E-03
   -2.18417000E-03  -5.80920000E-04  +2.68774500E-02  -1.88119000E-02  +5.40542100E-02
   -2.01830000E-04  -1.11860000E-04  -3.64890000E-04  -2.47410000E-04  +4.95680000E-04
   -6.54610000E-04  -1.94810000E-04  +9.43900000E-05  +1.87500000E-05  -8.48000000E-05
   -6.73000000E-05  +4.56800000E-05  -2.52100000E-04  -1.00120000E-04  +8.00600000E-05
   +1.90080000E-04  +3.85900000E-05  -3.07300000E-05  -2.39520000E-04  +4.39690000E-04
   +9.73900000E-05  +6.65400000E-05  -1.86160000E-04  -3.37400000E-05  +1.88970000E-04
   +1.38020000E-04  -1.54500000E-05  +6.06661000E-03  -2.28020000E-04  -2.77877000E-03
   +5.11000000E-06  +3.30180000E-04  -1.08812000E-03  +3.10100000E-04  +2.34280000E-04
   -3.70440000E-04  -3.38353000E-03  -1.77770000E-04  -3.66614000E-03  -1.59487400E-02
   -2.77512000E-03  +1.65387700E-02  -2.47646620E-01  -3.18616500E-02  +1.33073550E-01
   -8.24480000E-04  +1.70860000E-04  +1.36510000E-03  +3.66700000E-05  -4.62100000E-05
   +1.11200000E-04  -1.14710000E-04  +1.06420000E-04  +2.01410000E-04  +2.49460000E-03
   +4.08010000E-04  -1.91745000E-03  -3.04200000E-05  -1.31000000E-05  +1.09500000E-05
   +1.80000000E-05  +2.27000000E-06  -1.06200000E-05  +5.16100000E-05  +9.38000000E-06
   -1.22000000E-06  +1.13600000E-05  -6.31000000E-06  +6.80000000E-05  +6.50000000E-06
   +8.53000000E-06  +7.48000000E-06  +5.04100000E-05  -1.67000000E-05  +2.82300000E-05
   -2.51400000E-05  -3.00200000E-05  +3.78100000E-05  +2.83000000E-06  -1.04800000E-05
   -3.61200000E-05  +1.58250000E-04  +2.39600000E-05  -1.50620000E-04  -1.62900000E-05
   -1.27700000E-05  -4.34900000E-05  -6.18000000E-06  +1.22800000E-05  -1.17390000E-04
   +2.59538160E-01  +1.56020000E-04  +2.98210000E-04  +5.56000000E-05  +2.32440000E-04
   -7.52000000E-05  +4.53100000E-05  +6.64200000E-05  +4.82400000E-05  -7.33000000E-06
   +8.33400000E-05  +4.10400000E-05  -8.60000000E-07  +1.37260000E-04  -2.94800000E-05
   -1.05890000E-04  -1.87460000E-04  -1.64770000E-04  +1.13610000E-04  -1.16471000E-03
   -2.25920000E-04  -5.00970000E-04  +3.29000000E-05  -5.87000000E-05  -7.31100000E-05
   -1.27890000E-04  -1.03970000E-04  +2.12600000E-05  -1.58184700E-02  +3.90045000E-03
   +9.57256000E-03  +1.78241000E-03  -1.44193000E-03  +5.57529000E-03  +5.45810000E-04
   -1.24858000E-03  -5.77610000E-04  -1.12272000E-03  +4.81432000E-03  +1.66760000E-04
   +2.26340000E-03  +5.35949000E-03  +7.72710000E-04  -3.06801000E-02  -5.00692600E-02
   +2.80338900E-02  +1.47030000E-04  -4.95790000E-04  +1.56230000E-04  -5.78900000E-05
   +3.29870000E-04  -1.27400000E-04  +7.87500000E-05  -2.92740000E-04  +3.85350000E-04
   +1.13280500E-02  -4.63306000E-03  -1.22272000E-02  +2.61000000E-06  +1.26600000E-05
   -1.83200000E-05  -1.79600000E-05  +1.34300000E-05  -5.30000000E-06  +5.36800000E-05
   -7.45400000E-05  +1.05000000E-05  +1.79700000E-05  -4.59700000E-05  -2.13000000E-06
   -2.48000000E-06  -2.14000000E-06  -1.22100000E-05  +3.83200000E-05  -7.53000000E-06
   +1.55700000E-05  +5.31000000E-06  +6.42900000E-05  -5.06000000E-06  -4.32400000E-05
   -3.07000000E-06  -7.57400000E-05  +1.32170000E-04  -7.16730000E-04  -2.46670000E-04
   +4.37700000E-05  +1.11540000E-04  -2.37200000E-05  +4.94900000E-05  +9.04100000E-05
   -2.58770000E-04  +3.28476100E-02  +5.04984200E-02  +2.88300000E-05  -4.48190000E-04
   -2.87410000E-04  -3.11620000E-04  +2.48330000E-04  -1.48600000E-05  -5.14120000E-04
   -1.26450000E-04  +3.21780000E-04  +2.98000000E-05  +2.06670000E-04  +1.13960000E-04
   -3.38750000E-04  -2.57670000E-04  -7.46700000E-05  +4.36300000E-05  -7.79300000E-05
   -2.40400000E-05  +6.92040000E-04  -6.96510000E-04  +1.71750000E-04  +1.92600000E-05
   -1.50140000E-04  -1.94300000E-05  +4.04550000E-04  +3.05230000E-04  -1.12200000E-05
   +2.10646100E-02  +2.58973000E-03  -1.07363800E-02  -1.25211000E-03  +3.72023000E-03
   -2.71083000E-03  -3.32220000E-04  -5.00460000E-04  -6.51800000E-05  -3.75855000E-03
   +2.03811000E-03  -2.01579000E-03  -1.36223800E-02  +4.80000000E-07  +1.30090400E-02
   +1.32910740E-01  +2.71925800E-02  -1.43974430E-01  -6.14770000E-04  -4.43000000E-05
   +1.06737000E-03  +2.55130000E-04  +2.56400000E-05  +1.55780000E-04  -1.45130000E-04
   +1.10250000E-04  -6.59900000E-05  +3.92246000E-03  -2.34340000E-03  -4.29503000E-03
   -5.59100000E-05  -2.04900000E-05  +2.89100000E-05  +4.10800000E-05  -1.70000000E-07
   -9.97000000E-06  -1.02000000E-06  -1.97800000E-05  -1.78200000E-05  +4.91200000E-05
   +4.53800000E-05  +3.16000000E-05  +1.77900000E-05  +2.74600000E-05  +3.26000000E-06
   -7.51900000E-05  +2.66100000E-05  +6.23800000E-05  -2.77000000E-05  -1.29940000E-04
   +6.11200000E-05  +5.49600000E-05  +2.91300000E-05  +4.95300000E-05  +4.97000000E-06
   +6.52100000E-05  +2.95020000E-04  -1.76900000E-05  -1.70300000E-04  +4.39400000E-05
   -3.22500000E-05  +4.75200000E-05  +1.00550000E-04  -1.39845400E-01  -2.93301900E-02
   +1.50107520E-01  +1.32500000E-05  -2.22600000E-05  -1.00000000E-07  +1.81600000E-04
   +5.32300000E-05  +1.98700000E-05  +2.21700000E-05  -1.92800000E-05  +6.08000000E-06
   -2.42100000E-05  -2.71900000E-05  +1.39900000E-05  +2.26800000E-05  +2.15300000E-05
   -1.30000000E-07  -2.77000000E-06  +5.91000000E-06  +4.84000000E-06  +4.16660000E-04
   +4.05510000E-04  -8.26900000E-04  -3.14880000E-04  +2.08220000E-04  +4.86200000E-05
   -3.40200000E-05  -2.77700000E-05  +1.04100000E-05  -3.75599000E-03  -7.63300000E-04
   -3.78450000E-04  -6.80050000E-04  +5.61830000E-04  -1.97120000E-04  -3.45030000E-03
   +3.94540000E-04  +3.66130000E-04  +8.06735000E-03  -5.02371000E-03  +2.66130900E-02
   -5.77329900E-02  +2.67682000E-03  -2.44305100E-02  +1.31916000E-03  +6.53718000E-03
   -2.73202000E-02  +1.73776000E-03  -3.75600000E-05  -1.92154000E-03  -6.41260000E-04
   +2.68740000E-04  +2.11860000E-03  +2.89600000E-05  -2.56600000E-05  -1.05560000E-04
   +1.03340000E-04  -3.04530000E-04  -9.10790000E-04  -3.90000000E-07  +3.52000000E-06
   -8.37000000E-06  -1.31700000E-05  +1.79000000E-06  -3.24000000E-06  -6.89000000E-06
   +1.69200000E-05  -4.89000000E-06  +9.37000000E-06  +4.33000000E-06  +1.58000000E-05
   -8.40000000E-07  -9.90000000E-07  -1.50000000E-06  -1.06900000E-05  +7.62000000E-05
   -1.07820000E-04  +1.52400000E-05  -4.06000000E-06  +5.79000000E-06  +4.76000000E-06
   -1.35900000E-05  +2.06000000E-05  -2.18300000E-05  -1.30000000E-06  +4.69900000E-05
   +1.09000000E-06  +5.07000000E-06  +5.52000000E-06  -4.86000000E-06  +1.02700000E-05
   +3.33500000E-05  +1.13693000E-03  -1.90810000E-04  +6.94250000E-04  +5.39761600E-02
   -6.18000000E-06  +4.63700000E-05  +2.12000000E-05  -2.85700000E-05  -1.09200000E-04
   -7.15800000E-05  -8.14000000E-06  +4.18100000E-05  +1.58100000E-05  +3.35500000E-05
   +1.51200000E-05  -1.86800000E-05  +2.50900000E-05  -6.57000000E-06  -1.41800000E-05
   -1.61100000E-05  -2.56600000E-05  -1.31000000E-06  -7.21800000E-05  +9.61800000E-05
   -3.49100000E-04  -9.10000000E-06  -7.31000000E-05  -6.28000000E-06  -5.96000000E-06
   -1.19500000E-05  -8.70000000E-07  +1.22084000E-03  +2.87095000E-03  +7.40620000E-04
   -2.60705000E-03  +1.18500000E-04  +8.34200000E-04  +3.57712000E-03  +4.30995000E-03
   +9.93650000E-04  +4.35335000E-03  +3.48901000E-03  -4.83217000E-03  -2.76730000E-03
   -2.88187700E-02  +5.45025700E-02  +4.93088000E-03  +3.37649000E-03  +5.53171000E-03
   -3.66363000E-03  -4.44422000E-03  -2.66460000E-04  -4.41640000E-04  +1.10652000E-03
   +2.36660000E-04  +1.43360000E-04  -1.43470000E-04  +1.69580000E-04  +3.63660000E-04
   -3.93620000E-03  -3.32953000E-03  -2.30000000E-07  +4.73000000E-06  -5.00000000E-08
   +5.84000000E-06  +5.97000000E-06  -3.60000000E-07  +2.14700000E-05  -1.60300000E-05
   +1.05000000E-06  -1.41800000E-05  -3.20700000E-05  -1.54900000E-05  +5.20000000E-07
   -7.60000000E-07  +7.00000000E-07  +3.69100000E-05  -3.59400000E-05  -1.24400000E-05
   -7.24000000E-06  +2.87000000E-05  +1.13000000E-05  -1.38800000E-05  -1.40500000E-05
   -6.59700000E-05  +1.44440000E-04  +3.87900000E-05  -5.57700000E-05  -1.11400000E-05
   -3.89400000E-05  +7.95600000E-05  -1.52000000E-06  -6.58900000E-05  -1.13660000E-04
   +2.29300000E-04  -2.18788000E-03  -1.21122000E-03  -4.38071000E-03  +2.59278900E-02
   +2.34000000E-06  +1.61000000E-06  +4.21000000E-06  +3.49300000E-05  +4.76700000E-05
   -8.41000000E-06  +1.15600000E-05  -1.19300000E-05  -1.64200000E-05  -1.26600000E-05
   -2.36100000E-05  +7.00000000E-07  +3.77200000E-05  +3.50700000E-05  +2.15000000E-06
   -1.04200000E-05  +2.42000000E-06  +1.30300000E-05  +2.63980000E-04  +1.17800000E-05
   -3.36900000E-04  -1.35780000E-04  +6.72700000E-05  +4.80100000E-05  -5.02300000E-05
   -4.06800000E-05  +5.70000000E-06  -1.18573000E-03  -3.74650000E-04  +7.08150000E-04
   -2.41250000E-04  -9.67000000E-05  +5.61600000E-04  +3.06484000E-03  +1.94780000E-04
   +1.03633000E-03  -5.55168000E-03  +3.41151000E-03  -1.52324900E-02  -2.33345500E-02
   +4.87639800E-02  -3.41897490E-01  +2.15464000E-03  +2.06517000E-03  -5.23650000E-03
   -8.83200000E-04  -6.99240000E-04  +1.23344000E-03  +3.53500000E-04  +1.27200000E-04
   -8.95760000E-04  -1.84700000E-05  -3.26000000E-06  -2.72800000E-05  -2.90930000E-04
   -4.29900000E-04  -2.93200000E-05  +5.61000000E-06  +4.83000000E-06  -4.55000000E-06
   -8.12000000E-06  -7.20000000E-07  +1.06000000E-06  +2.70000000E-07  +4.41000000E-06
   -9.60000000E-07  +8.48000000E-06  +8.34000000E-06  +7.54000000E-06  -2.15000000E-06
   -1.97000000E-06  -3.60000000E-06  -5.91000000E-06  +2.86400000E-05  -4.18200000E-05
   +8.02000000E-06  -6.45000000E-06  +7.00000000E-08  +9.00000000E-06  -6.03000000E-06
   +4.63000000E-06  -2.24600000E-05  -2.82000000E-06  +7.82000000E-06  +6.10000000E-06
   +2.71000000E-06  -1.16100000E-05  -6.32000000E-06  +2.19300000E-05  +2.25900000E-05
   -2.07100000E-04  -3.61130000E-04  +5.42470000E-04  +2.57900900E-02  -5.25943300E-02
   +3.60012100E-01  -7.51090000E-04  +1.33550000E-04  +6.00460000E-04  +1.21180000E-04
   +1.25549000E-03  -2.86210000E-04  -2.10350000E-04  -2.74890000E-04  -2.51460000E-04
   -2.33200000E-05  -4.06440000E-04  -1.16130000E-04  -2.59700000E-04  +3.48740000E-04
   +3.17200000E-04  +1.73640000E-04  -3.64290000E-04  -3.93800000E-05  +4.29880000E-04
   -1.02738000E-03  +2.01710000E-03  -3.06910000E-04  -2.43620000E-04  +1.65120000E-04
   -1.65670000E-04  -3.11030000E-04  -2.35000000E-05  -1.66461800E-02  -7.85542000E-03
   +2.71758400E-02  +3.06260800E-02  -2.63325400E-02  -1.41832000E-03  +1.90509500E-02
   +7.66245000E-02  +1.12877500E-02  -4.15823000E-03  -1.90555800E-02  -5.91542100E-02
   -3.33276900E-02  -4.47403000E-03  +2.09543000E-03  +8.14760000E-03  +7.30005600E-02
   +2.91199500E-02  +4.87048000E-03  -1.39010000E-03  +4.16424000E-03  -2.04698000E-03
   -5.34997000E-03  +3.16720000E-04  -1.89930000E-03  +8.76560000E-04  -7.58410000E-04
   +2.98932900E-02  -1.48333900E-02  -4.98202900E-02  -9.42000000E-06  +2.60400000E-05
   -3.37800000E-05  -4.51700000E-05  -5.68800000E-05  +9.62000000E-06  +1.54120000E-04
   +1.08400000E-05  -1.48220000E-04  -3.24570000E-04  +5.12800000E-04  -5.05590000E-04
   -2.01300000E-04  -5.52500000E-05  -1.60200000E-04  +2.16000000E-06  +1.77090000E-04
   -9.30100000E-05  +3.66000000E-06  -4.14500000E-05  -8.00000000E-07  +3.95600000E-05
   +4.05900000E-05  -1.98890000E-04  +2.79280000E-04  -1.58350000E-04  -4.12240000E-04
   +5.23100000E-05  -3.14460000E-04  +5.39800000E-05  -3.14610000E-04  +8.16970000E-04
   +1.11290000E-04  -5.67250000E-04  -6.78480000E-04  +2.21900000E-05  -8.58500000E-04
   -8.79860000E-04  +4.22830000E-04  -4.11083300E-02  -1.54060000E-04  -3.13900000E-05
   +3.28660000E-04  +3.06230000E-04  +7.23540000E-04  -1.84300000E-04  -1.99290000E-04
   -1.85320000E-04  -3.83200000E-05  +5.36200000E-05  -1.62820000E-04  -6.61800000E-05
   -1.95230000E-04  +1.02450000E-04  +1.15590000E-04  -3.03900000E-05  -2.92720000E-04
   +8.62100000E-05  +2.43490000E-04  -3.10130000E-04  +9.69400000E-04  -2.54170000E-04
   -1.99300000E-05  +2.85400000E-05  -5.19100000E-05  -1.47390000E-04  -4.12000000E-06
   -3.45076000E-03  -7.73776000E-03  +1.10808900E-02  +1.63455400E-02  -3.54713400E-02
   -5.43350000E-04  +1.44964100E-02  -3.62452000E-03  -6.41290000E-04  -1.91834000E-03
   -1.33885700E-02  -3.63814600E-02  -2.18537000E-02  -5.92340000E-04  +3.33988000E-03
   +1.74801900E-02  +3.75225100E-02  +7.76643000E-03  +2.34887000E-03  -2.12990000E-04
   +3.23301000E-03  +8.16808000E-03  +9.98311000E-03  -1.60459000E-03  -8.14350000E-04
   +3.34140000E-04  -2.59180000E-04  +4.47374700E-02  -3.93269000E-02  -2.89883600E-02
   -2.40000000E-05  +1.12400000E-05  -2.23100000E-05  -2.70200000E-05  -2.30500000E-05
   -8.30000000E-06  +8.47600000E-05  +8.37000000E-06  -9.04500000E-05  -2.34700000E-05
   +3.91980000E-04  -3.31170000E-04  -1.29500000E-04  -2.98100000E-05  -1.03860000E-04
   -5.24700000E-05  +1.39330000E-04  -2.12800000E-05  -2.35400000E-05  -1.61720000E-04
   +2.87900000E-05  +1.03640000E-04  +5.38600000E-05  -2.14400000E-05  +1.39020000E-04
   -2.08100000E-05  -8.13600000E-05  -1.24000000E-06  -2.10090000E-04  +3.41500000E-05
   -1.72440000E-04  +3.73760000E-04  +6.89600000E-05  -7.44370000E-04  -3.17294000E-03
   -5.02920000E-04  -6.34000000E-04  -1.13761000E-03  +1.83930000E-04  -6.93532300E-02
   +6.16211300E-02  -7.25400000E-05  +5.09000000E-06  -4.69700000E-05  -2.60200000E-04
   -2.16870000E-04  -2.83400000E-05  +9.08500000E-05  +2.11100000E-05  -7.41000000E-06
   -5.21500000E-05  +4.57600000E-05  +5.95400000E-05  +1.36430000E-04  -2.39200000E-05
   -5.60300000E-05  +4.48700000E-05  +1.90930000E-04  -1.09550000E-04  +9.17000000E-05
   -1.40310000E-04  -7.67350000E-04  +5.16400000E-05  +1.01900000E-04  +7.97900000E-05
   -8.90000000E-07  +5.03400000E-05  -4.66000000E-06  +4.45540000E-03  +7.45191000E-03
   -9.61759000E-03  -1.32061600E-02  +2.07025700E-02  +1.17386000E-03  -2.19820300E-02
   -4.96811200E-02  -3.31481000E-02  -1.06682900E-02  -9.31832000E-03  +2.32530500E-02
   +2.19230800E-02  +2.70400000E-05  -7.36557000E-03  +1.16456000E-03  -3.70519400E-02
   -2.22690000E-02  -7.93170000E-04  +4.11752000E-03  -2.37920000E-03  +5.13633000E-03
   +1.07237200E-02  -1.74844000E-03  +5.38980000E-04  -2.53490000E-04  -9.24000000E-06
   -4.14100200E-02  +6.75945000E-03  +1.62413000E-03  +1.84900000E-05  -5.29000000E-06
   +1.03700000E-05  +6.06000000E-06  +7.37000000E-06  +4.00000000E-06  -5.30100000E-05
   +1.16700000E-05  +3.41200000E-05  -1.18020000E-04  -1.26700000E-04  +1.97680000E-04
   +6.25100000E-05  +1.17000000E-06  +8.10500000E-05  -5.00000000E-06  -7.13200000E-05
   -2.79000000E-05  +1.09000000E-05  +3.60400000E-05  +1.70000000E-07  -4.76100000E-05
   -2.87800000E-05  +1.60300000E-05  -1.35340000E-04  +3.65100000E-05  +2.38220000E-04
   -2.36800000E-05  +7.35200000E-05  -5.22100000E-05  +4.85900000E-05  -2.42570000E-04
   +1.07290000E-04  -2.75880000E-04  -1.15174000E-03  -7.16100000E-04  +4.73650000E-04
   +1.08457000E-03  +2.68250000E-04  +4.47621200E-02  +4.18246700E-02  +5.68559400E-02
   -1.07230000E-04  +1.72980000E-04  +1.20140000E-04  -3.36880000E-04  +1.71900000E-04
   -1.14400000E-04  -2.89200000E-05  -2.10600000E-05  -7.62500000E-05  +3.15100000E-05
   +3.48000000E-06  +2.32700000E-05  -5.46900000E-05  -2.68000000E-05  +2.03100000E-05
   +4.20700000E-05  -2.60000000E-05  -7.42700000E-05  +7.28900000E-05  -2.40416000E-03
   -1.89282000E-03  -1.58289000E-03  +1.15790000E-03  +6.12920000E-04  +6.78200000E-05
   +4.52500000E-05  -1.60300000E-05  +4.85511000E-03  -1.09116500E-02  +2.44693100E-02
   -4.81674900E-02  +9.18286000E-03  +3.90286000E-03  +1.06977000E-03  +9.51196000E-03
   -2.26257000E-02  -2.88604000E-03  +3.43202000E-03  +3.10447000E-03  +2.04338000E-03
   -8.41820000E-04  -1.06990000E-03  -4.53845000E-03  +3.71232000E-03  +2.52019000E-03
   -3.96750000E-04  -1.87050000E-04  -1.07986000E-03  +2.78775000E-03  -2.12323000E-03
   +4.60000000E-07  +5.66000000E-04  -7.09900000E-05  -6.09600000E-05  +2.20610000E-04
   +3.93480000E-04  +5.02140000E-04  -6.69000000E-06  -9.81000000E-06  +6.78000000E-06
   +1.09100000E-05  -8.16000000E-06  +3.30000000E-06  -5.83000000E-06  -9.10000000E-06
   -1.90000000E-07  +4.61500000E-05  -1.19340000E-04  +1.92300000E-05  +1.51000000E-06
   -1.45000000E-06  +9.13000000E-06  +1.57250000E-04  -2.57860000E-04  -1.30730000E-04
   -6.27350000E-04  +8.58760000E-04  -5.20300000E-05  -1.37207000E-03  +2.19050000E-04
   -6.39720000E-04  +1.67600000E-05  -5.78800000E-05  -1.42920000E-04  +2.40700000E-05
   -2.41800000E-05  +2.53500000E-05  -4.39500000E-05  -7.98800000E-05  -9.39500000E-05
   +2.76300000E-04  -1.04210000E-03  +7.98980000E-04  +1.49690000E-04  -8.30000000E-07
   +5.67900000E-05  -3.05100000E-04  +7.16710000E-04  -2.51580000E-04  +4.95369200E-02
   -1.40280000E-04  +1.45910000E-04  +1.78160000E-04  -5.69670000E-04  +5.92690000E-04
   +2.28500000E-04  -1.02650000E-04  -1.67370000E-04  -1.08620000E-04  -3.16000000E-06
   -4.81600000E-05  +1.72600000E-05  -1.50000000E-07  +6.65500000E-05  +3.18500000E-05
   +5.56800000E-05  -4.77300000E-05  -6.42200000E-05  -1.98476000E-03  -4.14550000E-03
   -2.35920000E-03  +1.68730000E-03  -2.05110000E-04  -1.62010000E-04  -3.03900000E-05
   -4.40800000E-05  -1.74900000E-05  -3.66018000E-03  +7.08782000E-03  +4.67947000E-03
   +9.47850000E-03  -9.41396500E-02  +1.12245910E-01  +2.28450000E-04  -1.38710000E-03
   +1.76546800E-02  +1.21988000E-03  -2.59833000E-03  -3.10335000E-03  +4.77400000E-05
   -3.86940000E-04  -9.03330000E-04  +3.26397000E-03  +8.06157000E-03  +1.10087000E-03
   +1.65071000E-03  +1.02308000E-03  +1.12414000E-03  -1.51370000E-03  +4.61690000E-04
   -1.71069000E-03  +9.89260000E-04  -4.88700000E-04  +1.41500000E-04  +3.98410000E-04
   -7.43200000E-04  -5.52060000E-04  +7.11000000E-06  +6.30000000E-07  -1.59000000E-06
   -1.14600000E-05  -1.62200000E-05  +4.12000000E-06  +9.92000000E-06  +1.69000000E-06
   -1.19900000E-05  -5.02300000E-05  -1.12780000E-04  +5.55000000E-06  -8.06000000E-06
   -1.32500000E-05  +1.16600000E-05  -8.19500000E-05  -2.06520000E-04  -3.29340000E-04
   +1.07058000E-03  -1.03630000E-03  +4.80200000E-05  +5.73200000E-05  -1.22090000E-04
   -1.64280000E-04  -1.92000000E-06  -5.40000000E-06  -2.04900000E-05  +2.05000000E-05
   +2.24000000E-06  +3.76000000E-06  -1.98600000E-05  -1.68290000E-04  -2.99160000E-04
   +8.06400000E-05  -1.25620000E-04  -5.84320000E-04  +7.61000000E-06  +1.60000000E-05
   +9.46900000E-05  -1.80232000E-03  +4.24710000E-04  +2.78650000E-04  -1.07646900E-02
   +8.85538500E-02  +7.59000000E-06  -2.20000000E-06  +2.05100000E-05  -2.40680000E-04
   +1.27390000E-04  +9.46000000E-05  -1.26600000E-05  -4.33900000E-05  -1.23100000E-05
   -1.17300000E-05  -3.18700000E-05  +8.84000000E-06  -1.26200000E-05  +2.33700000E-05
   +9.67000000E-06  +1.05000000E-05  -3.34000000E-06  +1.20900000E-05  -2.10746000E-03
   -8.85910000E-04  -1.53989000E-03  -8.40080000E-04  +8.46940000E-04  +2.97060000E-04
   -1.46500000E-05  -1.88200000E-05  +2.07000000E-06  -3.90117000E-03  +9.38577000E-03
   -8.97101000E-03  +9.98346000E-03  +1.14854250E-01  -2.89446400E-01  +3.36360000E-03
   +2.29837000E-03  -5.16767000E-03  +7.42000000E-06  +8.45570000E-04  +1.29149000E-03
   +1.07404000E-03  -8.61720000E-04  -1.57680000E-04  +4.13741000E-03  +2.87169000E-03
   -1.53606000E-03  +5.64000000E-05  +2.94300000E-04  -1.93900000E-05  -6.82620000E-04
   -1.88045000E-03  +1.71909000E-03  +5.13560000E-04  -1.25120000E-04  +4.46700000E-05
   +3.61860000E-04  -6.10570000E-04  +3.82690000E-04  -1.73000000E-06  +2.28000000E-06
   -5.28000000E-06  -5.39000000E-06  -1.95000000E-06  -1.08000000E-06  -4.40000000E-06
   +8.97000000E-06  -9.78000000E-06  +3.76000000E-06  +3.01800000E-05  -3.47000000E-05
   -2.85000000E-06  -5.40000000E-07  -4.13000000E-06  -3.76600000E-04  -2.12380000E-04
   +3.30850000E-04  -3.12350000E-04  -4.27360000E-04  +5.29400000E-05  -3.46210000E-04
   +2.86620000E-04  +4.25200000E-05  -3.21700000E-05  -1.40900000E-05  +4.62900000E-05
   +8.69000000E-06  -3.48800000E-05  -3.72300000E-05  +3.14100000E-05  -1.22170000E-04
   -1.15700000E-04  -3.52250000E-04  +7.19320000E-04  -8.04690000E-04  -5.07000000E-06
   -1.03340000E-04  -3.24300000E-05  -1.25198000E-03  +3.41660000E-04  -7.46100000E-05
   -7.78393000E-03  -1.28026560E-01  +3.03620230E-01  -7.24000000E-06  +2.65500000E-05
   +3.18900000E-05  +4.06600000E-05  -1.50810000E-04  +1.70900000E-05  -1.22300000E-05
   +2.60500000E-05  +3.81100000E-05  +4.49300000E-05  +7.15100000E-05  +1.46000000E-05
   -1.61500000E-04  -1.31860000E-04  -6.55000000E-06  +4.64100000E-05  -3.74800000E-05
   -3.05800000E-05  -1.45920000E-04  +1.59380000E-04  -8.53100000E-05  +9.27200000E-05
   -1.74100000E-05  -1.73500000E-05  +1.96190000E-04  +1.38430000E-04  -8.14000000E-06
   +3.50680000E-04  +1.36750000E-04  -4.87600000E-04  -1.18662000E-03  +3.83720000E-04
   +9.27340000E-04  -2.39054000E-03  -1.14900000E-05  +1.14840000E-03  -4.37026000E-02
   +6.02354000E-03  +3.99447000E-02  -3.00666000E-03  +1.07311000E-03  -5.24067000E-03
   -1.37544000E-03  -5.01830000E-04  +1.49602000E-03  -1.62699150E-01  +1.94982100E-02
   +1.73390780E-01  +9.30340000E-04  -8.42660000E-04  +2.29374000E-03  +1.32620000E-04
   -3.85200000E-05  +5.80800000E-05  +8.94830000E-04  +1.05558000E-03  -5.14000000E-05
   -3.69200000E-05  -1.53200000E-05  +5.11000000E-06  +2.20100000E-05  +7.06000000E-06
   -1.32000000E-05  -1.35000000E-05  -8.08000000E-06  +1.96000000E-06  -3.29600000E-05
   -1.48500000E-05  -5.53100000E-05  -5.30000000E-06  +8.89000000E-06  -3.80000000E-07
   +4.54000000E-05  -3.33400000E-05  +8.33000000E-06  -1.35200000E-05  +4.14800000E-05
   -1.03100000E-05  -3.27500000E-05  -2.54000000E-06  -1.61500000E-05  -2.24700000E-05
   +1.31200000E-05  +1.30700000E-05  -1.38700000E-05  +3.99700000E-05  +1.05600000E-05
   +5.39500000E-05  -6.67700000E-05  -2.50400000E-05  -3.09620000E-04  -1.06490000E-04
   -3.41800000E-04  +2.63870000E-04  +1.14000000E-05  -1.07380000E-04  -9.49270000E-04
   -6.30090000E-04  +1.18940000E-04  +2.21350000E-04  -2.29590000E-04  +1.51100000E-05
   +2.11822840E-01  -6.68000000E-06  -1.42000000E-05  +1.21800000E-05  +1.38600000E-05
   +4.30300000E-05  -1.46700000E-05  -3.93000000E-06  -1.64700000E-05  -3.33000000E-06
   -1.03200000E-05  -2.71700000E-05  -5.70000000E-06  +3.78300000E-05  +4.19200000E-05
   +4.76000000E-06  -1.39100000E-05  +2.93000000E-06  +1.19200000E-05  +6.04400000E-05
   -5.36200000E-05  +2.51500000E-05  -6.91000000E-06  +7.79000000E-06  +4.88000000E-06
   -5.31300000E-05  -4.86300000E-05  +4.39000000E-06  -1.31480000E-04  +3.65980000E-04
   -8.78210000E-04  -6.98520000E-04  -1.20170000E-04  +7.38580000E-04  +8.16630000E-04
   -1.51438000E-03  +8.59680000E-04  +5.79827000E-03  -1.20986000E-03  -9.40644000E-03
   +2.35430000E-04  +2.72454000E-03  +1.47278000E-03  +9.82890000E-04  +1.63834000E-03
   +2.49720000E-04  +1.94816600E-02  -1.53455100E-02  -1.56332500E-02  -2.54336000E-03
   -3.95185000E-03  -1.81929000E-03  -1.28100000E-05  +1.93200000E-05  -3.06800000E-05
   -4.54240000E-04  -1.20830000E-04  +4.59310000E-04  +6.28000000E-06  +7.41000000E-06
   -3.89000000E-06  -6.96000000E-06  -9.80000000E-07  +1.12000000E-06  +7.77000000E-06
   +2.46000000E-06  -6.57000000E-06  +9.07000000E-06  +2.55200000E-05  +3.97000000E-06
   -7.14000000E-06  -3.33000000E-06  -5.86000000E-06  -8.88000000E-06  +1.30500000E-05
   -2.51000000E-06  -1.35000000E-06  -1.62600000E-05  +1.22800000E-05  +2.72000000E-06
   -5.46000000E-06  +7.20000000E-07  -1.17000000E-06  +6.00000000E-08  +1.84300000E-05
   -3.91000000E-06  -2.19900000E-05  -2.06000000E-06  -1.44000000E-05  +1.19100000E-05
   +1.89400000E-05  +1.27610000E-04  -3.65900000E-04  -4.18300000E-05  +4.48700000E-05
   -4.84180000E-04  -2.33720000E-04  +3.81360000E-04  +3.76750000E-04  -9.46680000E-04
   +7.93200000E-05  -1.27470000E-04  +4.18700000E-05  -2.56928300E-02  +1.83442500E-02
   -9.99000000E-06  +2.71700000E-05  +8.38000000E-06  +1.66000000E-05  -6.55600000E-05
   -3.87500000E-05  +5.30000000E-07  +1.67700000E-05  -4.55000000E-06  +1.56600000E-05
   +1.86600000E-05  -1.36400000E-05  +1.11600000E-05  -9.93000000E-06  -4.78000000E-06
   -9.24000000E-06  +9.37000000E-06  -1.03500000E-05  +1.25590000E-04  +6.24100000E-05
   -1.92220000E-04  -2.26800000E-05  +1.76600000E-05  +8.25000000E-06  +8.10000000E-07
   +5.95000000E-06  -9.20000000E-06  +8.12300000E-04  -3.72830000E-04  -1.51433000E-03
   +3.38120000E-04  +1.54952000E-03  -1.41365000E-03  -1.20346300E-02  -2.58144000E-03
   +5.28760000E-04  +4.74721000E-03  -8.34380000E-04  +1.47593600E-02  -6.63432000E-03
   +1.99666000E-03  -7.31400000E-05  +1.31773000E-03  -6.01220000E-04  +2.53609000E-03
   +2.18003120E-01  -2.28795700E-02  -3.74211890E-01  +6.23723000E-03  -1.30050000E-04
   +3.61923000E-03  +7.87900000E-05  -3.84600000E-05  +8.15300000E-05  -2.08200000E-04
   -1.19870000E-04  -9.61690000E-04  +3.74000000E-06  -2.78000000E-06  +6.98000000E-06
   +6.36000000E-06  -2.10000000E-07  +1.92000000E-06  +5.70000000E-06  -1.10900000E-05
   +6.24000000E-06  +1.43700000E-05  -1.43500000E-05  +2.54300000E-05  +9.10000000E-07
   -4.78000000E-06  +1.02700000E-05  +1.34700000E-05  -8.70000000E-07  -1.33100000E-05
   +4.01000000E-06  +3.02300000E-05  +1.48900000E-05  -2.49100000E-05  -2.33900000E-05
   -1.17200000E-05  +2.72900000E-05  +1.36400000E-05  -2.59500000E-05  -1.56000000E-06
   -6.96000000E-06  +1.83000000E-05  -2.31000000E-06  -3.34300000E-05  -2.88000000E-05
   -1.68290000E-04  -2.82900000E-05  -1.29600000E-04  +2.34300000E-05  -2.61010000E-04
   -1.99000000E-04  +3.75410000E-04  -3.82160000E-04  -1.09410000E-04  -3.39930000E-04
   +4.28160000E-04  -1.73500000E-05  -2.13227670E-01  +2.25969300E-02  +3.58566990E-01
   -2.13000000E-06  +3.74900000E-05  +1.41200000E-05  +6.34300000E-05  -2.06730000E-04
   -2.11100000E-05  +6.08000000E-06  +4.89800000E-05  +3.68500000E-05  +4.26100000E-05
   +6.78000000E-05  +1.80000000E-06  -1.05110000E-04  -1.07400000E-04  -1.00300000E-05
   +3.37300000E-05  -1.38700000E-05  -3.58500000E-05  +1.36830000E-04  +3.28100000E-04
   -5.88600000E-05  +3.55700000E-05  -2.75900000E-05  +1.49800000E-05  +1.49280000E-04
   +1.11770000E-04  -1.04800000E-05  -5.35920000E-04  -1.63060000E-04  +1.34655000E-03
   +3.22462000E-03  -2.49839000E-03  -5.91300000E-04  -1.61232300E-02  -2.88006700E-02
   +1.93262000E-02  -6.81240000E-04  -4.63900000E-04  -2.33703000E-03  -1.56867000E-03
   +6.33830000E-04  +1.97400000E-04  +6.40180000E-04  +2.04580000E-04  +5.63120000E-04
   +2.02080000E-04  -1.44739000E-03  -1.07910000E-03  -4.98968100E-02  -7.48869700E-02
   +5.42619600E-02  +4.22500000E-05  +4.80500000E-05  +7.72000000E-05  -1.86974000E-03
   -1.78900000E-03  -1.74240000E-04  -2.42700000E-05  -1.27700000E-05  +8.08000000E-06
   +2.18500000E-05  +6.99000000E-06  -8.39000000E-06  -6.14000000E-06  -1.36100000E-05
   +7.22000000E-06  -9.65000000E-06  -4.87800000E-05  +4.70000000E-06  +2.52000000E-06
   +5.65000000E-06  +9.47000000E-06  +7.53500000E-05  -2.11900000E-05  -3.05900000E-05
   -2.64000000E-06  +1.15430000E-04  +6.59000000E-06  -7.77400000E-05  -3.66800000E-05
   -4.34100000E-05  +1.25100000E-05  +2.14000000E-06  -6.36400000E-05  -1.19500000E-05
   +2.67400000E-05  +2.95900000E-05  +2.17800000E-05  -2.19900000E-05  -4.35500000E-05
   -1.30600000E-05  +1.70190000E-04  -8.30600000E-05  +4.95000000E-06  +2.41070000E-04
   -5.83000000E-06  +1.80800000E-05  +2.75846000E-03  +2.04365000E-03  -1.55577000E-03
   +7.34800000E-04  -1.18055000E-03  +1.03027000E-03  +1.73709000E-03  +4.27300000E-04
   +6.67124400E-02  -3.82000000E-05  +3.53000000E-06  +2.22900000E-05  +1.13800000E-05
   +5.12200000E-05  -1.19600000E-05  -2.19000000E-06  -1.96200000E-05  -1.48700000E-05
   -1.00100000E-05  -2.93900000E-05  -8.47000000E-06  +2.71200000E-05  +4.13100000E-05
   +1.07200000E-05  -3.72000000E-06  +7.80000000E-07  +1.93000000E-06  +1.66100000E-05
   -1.27060000E-04  -1.14440000E-04  +2.05800000E-05  +4.89200000E-05  +6.59000000E-06
   -4.79800000E-05  -4.26700000E-05  -4.00000000E-08  +2.56790000E-04  -6.14240000E-04
   +1.17017000E-03  +1.66726000E-03  +1.51144000E-03  -3.02141000E-03  +4.17411000E-03
   +8.03718000E-03  -4.79173000E-03  +9.49400000E-04  -3.49660000E-04  -1.62792000E-03
   -1.23050000E-04  -3.63030000E-04  -8.66240000E-04  -7.16900000E-05  +1.24262000E-03
   -3.60330000E-04  +8.90270000E-04  -4.12310000E-04  -5.38880000E-04  -1.10693400E-01
   -4.39109930E-01  +1.88231690E-01  -1.16600000E-05  +3.22800000E-05  -6.67600000E-05
   +4.99370000E-04  -4.11330000E-04  -4.41670000E-04  +7.20000000E-06  +4.59000000E-06
   -2.00000000E-06  -6.17000000E-06  -2.98000000E-06  +1.90000000E-06  +9.03000000E-06
   +1.88000000E-06  -7.07000000E-06  +3.04000000E-06  +1.56600000E-05  +2.05400000E-05
   -8.20000000E-06  -6.45000000E-06  -1.90000000E-06  -1.73300000E-05  -8.35000000E-06
   -6.94000000E-06  -4.78000000E-06  -3.44000000E-05  +6.89000000E-06  -1.17700000E-05
   -8.98000000E-06  -1.12700000E-05  -2.16000000E-06  -1.70900000E-05  -4.57000000E-06
   -1.29000000E-06  -2.06200000E-05  -7.81000000E-06  -1.33200000E-05  +2.24500000E-05
   +6.98000000E-06  +3.55000000E-05  -6.88800000E-05  -1.23400000E-05  +1.97400000E-04
   +1.44330000E-04  -1.03550000E-04  -2.30720000E-04  +2.51450000E-04  +3.53630000E-04
   -5.46000000E-04  -3.05300000E-05  +6.42450000E-04  -8.09200000E-05  -2.63300000E-04
   +1.35935000E-03  +1.03096320E-01  +4.30597210E-01  -3.42100000E-05  +2.01400000E-05
   -3.70000000E-06  -2.97500000E-05  +6.62100000E-05  -5.37600000E-05  -4.68000000E-06
   -9.35000000E-06  -2.21900000E-05  -6.62000000E-06  -2.60900000E-05  -1.34700000E-05
   +5.26400000E-05  +4.46700000E-05  +1.00500000E-05  -1.49600000E-05  +9.63000000E-06
   +4.00000000E-07  +7.59700000E-05  -1.10620000E-04  +1.60890000E-04  -2.09500000E-05
   +2.36300000E-05  +3.56400000E-05  -6.88900000E-05  -4.81500000E-05  -7.02000000E-06
   -6.72790000E-04  -1.37090000E-04  -4.08610000E-04  -6.40670000E-04  -1.65456000E-03
   +3.31989000E-03  +8.28947000E-03  +2.19899200E-02  -1.58629800E-02  +4.38140000E-03
   +2.20149000E-03  -1.47003000E-03  -1.02923000E-03  -5.61100000E-04  -5.28860000E-04
   +3.36580000E-04  +1.13467000E-03  +4.45280000E-04  -1.10015000E-03  -7.94430000E-04
   -2.14140000E-04  +6.31663900E-02  +1.57018170E-01  -8.58231500E-02  -3.16100000E-05
   +4.42800000E-05  -2.88300000E-05  +1.02690000E-04  -5.97390000E-04  -4.40370000E-04
   +1.43000000E-05  +2.70000000E-06  +3.43000000E-06  -4.54000000E-06  -4.89000000E-06
   +6.60000000E-06  +1.23800000E-05  -2.66000000E-06  -1.85000000E-06  +1.73900000E-05
   -6.07000000E-06  +3.99100000E-05  -2.48000000E-06  -1.04700000E-05  +5.96000000E-06
   +1.10000000E-06  +1.25000000E-05  -3.36200000E-05  +1.75900000E-05  +2.94900000E-05
   +3.80000000E-05  -3.85000000E-05  -4.70300000E-05  -2.13900000E-05  +2.07800000E-05
   -7.33000000E-06  -3.72200000E-05  +8.12000000E-06  -3.30400000E-05  +1.45400000E-05
   -3.44900000E-05  +2.82700000E-05  +4.81000000E-06  -1.55000000E-05  +6.21900000E-05
   -2.50000000E-07  +4.79000000E-05  -4.17800000E-04  -1.44810000E-04  -6.35960000E-04
   -1.29606000E-03  -6.36260000E-04  +2.66630000E-04  +3.34220000E-04  +1.04830000E-04
   +1.04520000E-04  +2.40248000E-03  -1.32718000E-03  -7.25900600E-02  -1.79719090E-01
   +1.02914480E-01  +2.43170000E-04  -2.92500000E-05  -3.73550000E-04  -1.09100000E-05
   +8.73000000E-05  +2.40300000E-05  +8.27700000E-05  -3.10300000E-05  +3.89600000E-05
   -1.09450000E-04  -5.14200000E-05  +6.68200000E-05  -3.40000000E-06  +3.48100000E-05
   +6.94800000E-05  -2.42100000E-05  -6.76000000E-06  +1.00250000E-04  +1.04930000E-04
   -7.44700000E-05  -4.03500000E-05  -1.07700000E-05  -3.11000000E-05  +2.10400000E-05
   -4.43500000E-05  -7.78400000E-05  +3.91200000E-05  +3.60530000E-04  +1.29558000E-03
   -1.14130000E-04  -2.84344000E-03  -2.94440000E-04  +7.83010000E-04  -2.26298000E-03
   -4.70783000E-03  +5.68360000E-04  -7.32960000E-04  -4.46700000E-05  +1.02154000E-03
   -1.87670000E-04  +1.02240000E-04  -8.87520000E-04  +6.77360000E-04  -1.26894000E-03
   +1.21588000E-03  -4.77820000E-04  +1.73900000E-05  -2.26030000E-04  -4.04340000E-04
   +7.43700000E-05  -1.13320000E-04  -1.91800000E-05  +2.16000000E-05  -2.07600000E-05
   -6.95907200E-02  +1.10957620E-01  -1.17841070E-01  -2.55800000E-05  +2.02500000E-05
   -2.08800000E-05  -2.02900000E-05  +1.07700000E-05  -1.75500000E-05  -5.63000000E-06
   +1.23600000E-05  +1.40000000E-06  -5.23600000E-05  +3.38800000E-05  +2.56790000E-04
   -4.15100000E-05  +1.01900000E-05  -9.55700000E-05  +5.65000000E-06  +1.36500000E-05
   +2.95000000E-06  +7.17000000E-06  +3.45000000E-06  +5.21000000E-06  -2.10000000E-07
   -3.60000000E-06  +2.41000000E-06  +1.75800000E-05  +1.18600000E-05  +1.16000000E-05
   -1.77900000E-05  -2.13500000E-05  +1.08600000E-05  -2.46300000E-05  +5.17000000E-06
   +5.14000000E-06  -5.02530000E-04  +1.02584000E-03  +3.15270000E-04  +7.86400000E-05
   -4.03340000E-04  -1.50540000E-04  +1.06166700E-02  -7.24495000E-03  +8.17679000E-03
   -1.81730000E-04  -3.33500000E-05  -9.56500000E-05  -7.09700000E-05  -1.51170000E-04
   +7.69200000E-05  +7.70000000E-06  +6.31700000E-05  +6.01900000E-05  +6.54632400E-02
   +3.43500000E-05  +8.17700000E-05  -1.24920000E-04  -1.10670000E-04  +8.83200000E-05
   -5.90800000E-05  +4.63000000E-05  +8.66000000E-06  -6.21200000E-05  -2.10300000E-05
   -3.84700000E-05  -1.57400000E-05  +1.59590000E-04  +9.67100000E-05  +2.32000000E-06
   -7.13600000E-05  +1.51000000E-05  +1.28950000E-04  -4.16080000E-04  -3.74570000E-04
   +1.49950000E-04  +2.31100000E-05  -3.87900000E-05  -1.99900000E-05  -1.67190000E-04
   -1.49820000E-04  +2.07000000E-05  -1.71285000E-03  -5.45857000E-03  +2.22814000E-03
   +2.60195000E-03  -3.22618000E-03  -1.09777000E-03  +6.08540000E-04  +1.71568000E-03
   +1.79030000E-04  -3.64924000E-03  +1.11045000E-03  +2.53752000E-03  +2.22081000E-03
   +2.92950000E-03  -1.08050000E-03  +4.07690000E-03  -6.88913000E-03  +9.31191000E-03
   +1.75683000E-03  -7.85020000E-04  -1.61090000E-04  +2.57270000E-04  +2.23960000E-04
   -7.72720000E-04  -8.57600000E-05  +1.60800000E-05  +7.09000000E-06  +9.18307100E-02
   -2.36353200E-01  +2.22026260E-01  +1.51300000E-05  +2.11400000E-05  -9.82000000E-06
   -1.18600000E-05  -2.61000000E-06  +5.46000000E-06  +1.10900000E-05  -8.13000000E-06
   +5.52000000E-06  +7.53000000E-05  -6.34800000E-05  +1.18660000E-04  -3.31300000E-05
   +1.73000000E-06  -5.48400000E-05  +3.05800000E-05  +2.85400000E-05  +1.53200000E-05
   +8.29000000E-06  +3.76900000E-05  -3.20800000E-05  -1.15000000E-06  -6.40000000E-06
   -1.27100000E-05  +5.50500000E-05  -2.24900000E-05  -7.84400000E-05  +2.75100000E-05
   -6.62000000E-06  +3.09100000E-05  -6.32000000E-06  +5.15900000E-05  -4.34600000E-05
   +5.54750000E-04  +2.82300000E-05  -1.00200000E-05  -2.47700000E-05  -5.48200000E-05
   -8.72200000E-05  +1.28460000E-03  -6.05818000E-03  +5.35390000E-03  -1.23960000E-04
   -7.21000000E-05  -2.14310000E-04  -1.01850000E-04  +8.62700000E-05  +2.70160000E-04
   +1.84550000E-04  -6.60400000E-05  +5.85600000E-05  -9.93260000E-02  +2.53133170E-01
   +7.15700000E-05  +3.19700000E-05  -3.47890000E-04  -1.04490000E-04  -6.27600000E-05
   -9.40000000E-07  +2.37100000E-05  +2.35200000E-05  +6.80000000E-06  -1.24000000E-05
   +2.67500000E-05  -1.02200000E-05  +3.08800000E-05  -2.63900000E-05  +2.34400000E-05
   -3.39000000E-06  +1.18360000E-04  +7.42400000E-05  -6.49790000E-04  -3.76240000E-04
   +1.42720000E-04  +1.48860000E-04  -7.81100000E-05  -1.46500000E-05  -2.02900000E-05
   +5.53000000E-06  -7.12000000E-06  -1.89810000E-04  -4.62393000E-03  +1.73518000E-03
   +2.72293000E-03  -2.10938000E-03  +4.08310000E-04  +1.00108000E-03  +3.23198000E-03
   -6.36550000E-04  -1.06148000E-03  +4.91100000E-05  +6.19260000E-04  -9.73220000E-04
   +6.86370000E-04  -7.83690000E-04  +3.56158000E-03  +4.64370000E-04  +8.89809000E-03
   +1.87330000E-04  -1.42020000E-04  -2.14270000E-04  -3.63900000E-05  -5.43400000E-05
   +4.33500000E-05  +2.45000000E-06  +1.80100000E-05  -3.77000000E-06  -1.04668080E-01
   +2.40454700E-01  -2.77022320E-01  +1.08100000E-05  -3.39000000E-06  +1.38800000E-05
   +1.00500000E-05  -4.09000000E-06  +4.95000000E-06  -1.65700000E-05  -3.60000000E-06
   +1.97100000E-05  +7.99200000E-05  -8.20900000E-05  +2.78760000E-04  -1.85000000E-05
   +7.23000000E-06  -2.24400000E-05  +4.65800000E-05  -4.39000000E-06  +5.08700000E-05
   +2.19900000E-05  +6.03100000E-05  -4.05800000E-05  -1.83900000E-05  -6.08000000E-06
   +9.70000000E-06  +4.94000000E-06  -5.50000000E-07  -2.85300000E-05  +2.62800000E-05
   +1.90000000E-05  +2.65300000E-05  +2.48500000E-05  -8.23000000E-06  -3.17500000E-05
   +4.59830000E-04  -5.66490000E-04  -1.92280000E-04  -1.36810000E-04  -4.81570000E-04
   -3.60510000E-04  -7.70867000E-03  +2.14168000E-03  -4.82957000E-03  -1.71000000E-05
   -1.92470000E-04  -9.30400000E-05  +8.65000000E-05  +9.46200000E-05  +1.17900000E-04
   -9.70000000E-06  -9.38500000E-05  -2.50300000E-05  +1.07122910E-01  -2.38513530E-01
   +2.72191450E-01
end_hess

