# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -882.69669540    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +2.05645620E+00  -1.91772093E+00  +1.38664922E+00
   006   +2.00358886E+00  +5.96803455E-01  +5.05162222E-01
   006   +4.14502926E+00  +1.31514329E+00  -8.16836722E-01
   006   +6.22747996E+00  -1.72048072E-01  -1.28273678E+00
   006   +6.20272045E+00  -2.62817485E+00  -3.61521447E-01
   006   +4.11682924E+00  -3.48723755E+00  +9.62701922E-01
   006   -2.25552441E-01  +2.34923809E+00  +1.10294270E+00
   006   -9.36108320E-02  +3.03031595E+00  +3.92514565E+00
   008   +8.24634650E+00  -4.10293830E+00  -8.19634029E-01
   006   -2.71945526E+00  +1.05721923E+00  +3.80307285E-01
   006   -2.96336390E+00  -4.68174763E-02  -2.00048571E+00
   006   -5.19642771E+00  -1.15357055E+00  -2.77638888E+00
   006   -7.27557612E+00  -1.18671083E+00  -1.16779827E+00
   006   -7.07935637E+00  -1.03925736E-01  +1.20763303E+00
   006   -4.82576692E+00  +1.00428358E+00  +1.95661885E+00
   008   -9.51291383E+00  -2.25258757E+00  -1.82038456E+00
   006   -1.14387271E-01  +4.82833053E+00  -4.01759757E-01
   008   +1.51724996E-01  -2.96928994E+00  +2.73246022E+00
   001   -9.40506718E+00  -2.93211850E+00  -3.49272228E+00
   001   -5.32309471E+00  -2.00313077E+00  -4.63608698E+00
   001   -1.35771295E+00  -5.72741016E-02  -3.26883012E+00
   001   -4.73316411E+00  +1.83026733E+00  +3.82264674E+00
   001   -8.69635687E+00  -1.38205300E-01  +2.45594883E+00
   001   -1.81975245E+00  +5.91748884E+00  -1.44948553E-02
   001   +1.51720923E+00  +5.96478699E+00  +1.19878052E-01
   001   -2.53899027E-02  +4.48638489E+00  -2.43037517E+00
   001   -2.87681979E-01  +1.38109921E+00  +5.14398429E+00
   001   +1.73451219E+00  +3.89153125E+00  +4.31769858E+00
   001   -1.54980393E+00  +4.39847034E+00  +4.43103823E+00
   001   +7.82437618E+00  +5.19160159E-01  -2.34975383E+00
   001   +4.03063934E+00  -5.39965612E+00  +1.68555726E+00
   001   +7.99181158E+00  -5.74032338E+00  -9.51108730E-02
   001   -1.39240780E+00  -2.04213079E+00  +2.47516527E+00
   008   +5.43606250E+00  +5.51227997E+00  -2.38379955E+00
   001   +6.89486682E+00  +5.47561736E+00  -1.29191373E+00
   001   +4.37791792E+00  +3.45890243E+00  -1.69865172E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +1.60000000E-07  +4.00000000E-08  -2.80000000E-07
   -1.00000000E-08  +2.80000000E-07  +0.00000000E+00
   -2.00000000E-07  +6.40000000E-07  +1.50000000E-07
   +5.00000000E-08  +8.60000000E-07  +0.00000000E+00
   +1.80000000E-07  +3.10000000E-07  -2.30000000E-07
   +1.80000000E-07  +1.60000000E-07  -3.70000000E-07
   -1.40000000E-07  -8.00000000E-08  +2.00000000E-07
   -1.20000000E-07  -4.70000000E-07  +2.30000000E-07
   +2.70000000E-07  +6.70000000E-07  -4.20000000E-07
   +1.00000000E-08  -2.70000000E-07  +9.00000000E-08
   +1.20000000E-07  +9.00000000E-08  -5.00000000E-08
   +2.20000000E-07  +9.00000000E-08  -3.40000000E-07
   +5.00000000E-08  -3.00000000E-07  -4.40000000E-07
   +2.00000000E-08  -5.00000000E-07  -2.30000000E-07
   -4.00000000E-08  -4.40000000E-07  -1.40000000E-07
   +1.80000000E-07  -3.00000000E-07  -5.40000000E-07
   -3.70000000E-07  +0.00000000E+00  +5.00000000E-07
   +3.00000000E-08  -2.80000000E-07  -5.30000000E-07
   +3.50000000E-07  -7.00000000E-08  -6.30000000E-07
   +2.50000000E-07  +2.60000000E-07  -4.70000000E-07
   +8.00000000E-08  +3.30000000E-07  -9.00000000E-08
   -1.80000000E-07  -7.00000000E-07  +4.00000000E-08
   -5.00000000E-08  -7.70000000E-07  -2.70000000E-07
   -3.30000000E-07  -1.10000000E-07  +5.50000000E-07
   -3.90000000E-07  +1.10000000E-07  +7.10000000E-07
   -9.00000000E-08  +3.30000000E-07  +5.20000000E-07
   -2.40000000E-07  -6.10000000E-07  +1.40000000E-07
   -3.00000000E-07  -4.50000000E-07  +4.60000000E-07
   -2.80000000E-07  -5.70000000E-07  +4.30000000E-07
   +1.50000000E-07  +8.40000000E-07  +2.60000000E-07
   +3.20000000E-07  +3.00000000E-08  -5.90000000E-07
   +3.10000000E-07  +5.10000000E-07  -5.20000000E-07
   +1.40000000E-07  -4.30000000E-07  -2.70000000E-07
   -7.00000000E-07  -1.19000000E-06  +9.10000000E-07
   -1.90000000E-07  +5.90000000E-07  +7.80000000E-07
   +5.50000000E-07  +1.39000000E-06  +4.40000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.32683800E-01  -8.71990500E-02  +6.11359500E-01  -1.80662660E-01  -1.28313090E-01
   +3.05355850E-01  -1.17376160E-01  +5.69940400E-02  +1.49022000E-03  +5.62561020E-01
   -8.03439000E-03  -2.46136050E-01  +6.72177500E-02  -4.05700600E-02  +5.45212250E-01
   +2.34858000E-02  +3.18413400E-02  -9.79586600E-02  -1.85285370E-01  -1.08027380E-01
   +3.00733210E-01  +2.81211300E-02  -8.73803100E-02  +2.00190800E-02  -2.47158530E-01
   -1.27725700E-02  +1.00528510E-01  +5.80856950E-01  -3.08459700E-02  -1.00508600E-02
   +2.11584100E-02  -5.99085400E-02  -1.13085900E-01  +4.72196000E-02  -9.24342800E-02
   +4.11511830E-01  -5.50800000E-05  +4.73547400E-02  -1.16631700E-02  +1.16179220E-01
   +2.81913900E-02  -1.22541440E-01  -1.91257020E-01  -6.10467800E-02  +2.36872340E-01
   -1.27685100E-02  +3.53748800E-02  -6.24774000E-03  -4.51577900E-02  -1.20438400E-02
   +2.94229400E-02  -2.58997830E-01  +1.42994340E-01  +4.77670200E-02  +6.41914830E-01
   +3.28713200E-02  -6.19097400E-02  +5.04225000E-03  +2.79817500E-02  +5.36644800E-02
   -2.86644700E-02  +9.56050800E-02  -1.70615670E-01  -5.24408000E-03  -6.37697600E-02
   +6.19535770E-01  -5.41454000E-03  +6.07812000E-03  +1.26798000E-03  +1.53010200E-02
   -1.17526600E-02  +2.50210000E-03  +6.47024600E-02  -2.83318000E-02  -7.68621600E-02
   -2.38148550E-01  -1.56020510E-01  +2.92388120E-01  -5.42218000E-02  +3.65362900E-02
   +1.32404100E-02  -1.27864300E-02  -3.00069500E-02  +1.73144200E-02  +3.10991400E-02
   +1.98566800E-02  -2.05606300E-02  -1.16050370E-01  +2.34625800E-02  +1.35834000E-02
   +6.16154840E-01  -1.98396000E-02  +7.59036500E-02  -1.69328900E-02  -3.18411400E-02
   -4.28546800E-02  +3.07338100E-02  +7.74156600E-02  -4.52543400E-02  -1.94379100E-02
   -4.65865500E-02  -2.84400130E-01  +1.02442590E-01  -7.04476700E-02  +6.73849870E-01
   +3.26621700E-02  -4.44648600E-02  -2.18472000E-03  +1.76474500E-02  +2.89722700E-02
   -1.88900700E-02  -4.19407000E-02  +8.87637000E-03  +2.01530000E-02  +3.94269400E-02
   +6.84429300E-02  -1.15346070E-01  -1.96038660E-01  -1.54593240E-01  +3.16513040E-01
   -2.28168030E-01  +7.59966300E-02  +4.67096400E-02  +2.99801000E-02  +5.63319100E-02
   -3.12516600E-02  -5.93798300E-02  +1.06321700E-02  +2.41580500E-02  +2.79005200E-02
   -6.56835900E-02  +1.50667600E-02  -2.40667530E-01  -1.80242400E-02  +9.34868600E-02
   +6.21033160E-01  +1.41876600E-01  -2.08077740E-01  -1.57054700E-02  +1.63438900E-02
   -3.00281600E-02  +4.78054000E-03  +9.77768000E-03  -6.54662000E-03  -2.85416000E-03
   -2.60336200E-02  -4.35033000E-03  +1.79897100E-02  -8.65588300E-02  -1.60958130E-01
   +7.67078900E-02  -6.48753400E-02  +6.87041320E-01  +2.50179100E-02  +1.54499900E-02
   -8.53446700E-02  -1.64397400E-02  -1.38852800E-02  +2.24604600E-02  +2.46687500E-02
   -2.94862000E-03  -1.22910400E-02  -1.57300000E-05  +3.68408100E-02  -3.82628000E-03
   +1.17291130E-01  +4.28906800E-02  -1.38860490E-01  -2.18993090E-01  -1.73057730E-01
   +2.86256230E-01  +5.06199000E-03  +8.75842000E-03  -4.18708000E-03  -1.27270820E-01
   +3.94290700E-02  +1.93535800E-02  -2.29784000E-02  +9.57622000E-03  +8.54279000E-03
   +1.14796000E-03  -1.45298000E-03  +2.87010000E-03  -2.02533000E-03  +3.10040000E-04
   +7.24400000E-05  +2.17734000E-03  -1.38952000E-03  +1.92185000E-03  +4.66592950E-01
   +2.33809400E-02  -1.92947800E-02  -4.40026000E-03  +3.84230500E-02  -1.15756180E-01
   -4.51547000E-03  +2.23560000E-04  +1.23122100E-02  -4.39068000E-03  -3.40940000E-03
   +3.47780000E-04  +3.61267000E-03  +1.25520000E-04  -2.25199000E-03  +3.25120000E-04
   -8.09830000E-04  -2.96662000E-03  +2.72271000E-03  +1.20331000E-03  +4.73814990E-01
   -8.43794000E-03  +4.80106000E-03  +6.84360000E-03  +1.83765300E-02  -4.04382000E-03
   -7.46012700E-02  +1.07606500E-02  -8.24044000E-03  -3.69268000E-03  +2.93768000E-03
   +1.54562000E-03  +3.26149000E-03  -1.00500000E-04  +6.36600000E-04  -1.46110000E-03
   +1.58673000E-03  +4.32255000E-03  +2.04784000E-03  -3.46670000E-04  +2.47990000E-04
   +4.76417490E-01  -1.46019000E-03  -6.38610000E-04  +1.03149000E-03  -3.78671000E-03
   +8.10420000E-03  +2.59356500E-02  +5.66640000E-04  +2.92188000E-03  -5.76900000E-05
   -1.37798000E-03  +5.02490000E-04  -9.20000000E-04  +5.54450000E-04  -9.54110000E-04
   +3.01970000E-04  -2.33270000E-04  -7.04590000E-04  -4.18590000E-04  -7.55840200E-02
   -8.78810000E-04  -1.19900000E-03  +5.86424610E-01  +2.09921000E-03  +2.50340000E-04
   -2.24277000E-03  +5.05247000E-03  -8.53423000E-03  -2.24158200E-02  -1.57716000E-03
   -1.81176000E-03  +4.31370000E-04  +8.09930000E-04  -6.84900000E-04  +6.59810000E-04
   -2.24970000E-04  +9.16630000E-04  -3.40550000E-04  -2.65900000E-05  +7.66560000E-04
   +4.77330000E-04  -2.28387000E-03  -8.03975200E-02  -2.36363400E-02  -7.98710000E-04
   +5.81450580E-01  -2.60379000E-03  +8.38100000E-04  +1.63591000E-03  +8.95969000E-03
   -1.00659600E-02  -1.21656000E-02  -1.00817000E-03  +6.46800000E-05  -2.56070000E-04
   -1.21410000E-04  +3.78030000E-04  +2.02610000E-04  -2.19300000E-04  -5.23530000E-04
   +2.66980000E-04  +8.89640000E-04  +1.77460000E-04  -1.76950000E-04  -6.59920000E-03
   -1.84549000E-02  -1.66601520E-01  -1.00806700E-02  -3.64170100E-02  +4.71238310E-01
   +6.06174000E-03  -8.29514000E-03  +3.79188000E-03  -2.03522000E-03  +5.53302000E-03
   -2.87430000E-03  -1.08714000E-03  -3.39722000E-03  +3.94355000E-03  -4.78000000E-06
   +1.62805000E-02  -1.58785000E-03  -2.34661060E-01  +7.89901500E-02  +6.39052500E-02
   -4.41066300E-02  +3.30912900E-02  +1.48570100E-02  +1.54580000E-03  -1.00764000E-03
   +4.85170000E-04  -1.10615000E-03  +7.61170000E-04  -2.31830000E-04  +3.29062720E-01
   +5.66040000E-04  -4.76826000E-03  +4.14643000E-03  +4.34700000E-03  +1.35791000E-03
   -2.18447000E-03  -6.59359000E-03  +1.75867000E-03  +4.34084000E-03  +4.81730700E-02
   -4.19664300E-02  -5.46583000E-03  +1.25318800E-01  -1.69722930E-01  -1.54135700E-02
   -6.92810000E-04  +9.16583000E-03  +7.17570000E-04  -1.08743000E-03  +1.04849000E-03
   -7.67440000E-04  +9.71970000E-04  -7.22610000E-04  +2.47260000E-04  -7.79567800E-02
   +6.38477970E-01  +5.89230000E-04  +8.37802000E-03  +4.63601000E-03  -1.28090000E-03
   -3.59448000E-03  +6.55180000E-04  +5.39586000E-03  +2.61545000E-03  +1.10150000E-03
   -1.37190400E-02  +1.06104900E-02  +1.07738400E-02  +4.67644400E-02  +7.26329000E-03
   -7.09281400E-02  +2.65453100E-02  -1.57576400E-02  +3.16948000E-03  -4.94300000E-04
   +1.09700000E-05  -1.99470000E-04  +2.21980000E-04  -1.32310000E-04  -5.59000000E-06
   -1.18419680E-01  -1.85847340E-01  +1.54375550E-01  +2.94116000E-03  +1.17595000E-03
   -1.43750000E-03  -3.39257800E-02  -7.48671000E-03  -7.93530000E-04  -9.08750000E-04
   +1.81829000E-03  -2.18901000E-03  -2.89710000E-04  +1.06980000E-04  +9.87230000E-04
   +3.20700000E-05  -2.59490000E-04  -7.05200000E-05  -3.47110000E-04  -7.13290000E-04
   +9.06410000E-04  -1.45822600E-01  -3.58659500E-02  -1.59579500E-02  -1.82423000E-03
   -3.45724000E-03  -6.23421000E-03  -1.41660000E-04  +5.42600000E-05  -3.24300000E-05
   +5.90216830E-01  +2.94160000E-04  -1.08833000E-03  +7.54040000E-04  +1.24678200E-02
   +1.10835900E-02  +3.33017000E-03  +6.34210000E-04  -3.25442000E-03  +9.95430000E-04
   +9.29950000E-04  -3.67900000E-04  -8.59570000E-04  -4.77750000E-04  +1.08156000E-03
   +6.76500000E-05  -7.83500000E-05  -3.78400000E-05  -6.05760000E-04  -3.41962200E-02
   -8.77161100E-02  -1.77042000E-02  -7.53065000E-03  -5.36871000E-03  -3.72924000E-03
   +9.26540000E-04  -7.70680000E-04  -1.49770000E-04  +1.10771520E-01  +2.97713790E-01
   +2.41297000E-03  +2.02385000E-03  -1.73275000E-03  +7.27334000E-03  +4.83308000E-03
   +1.58782000E-03  +7.59880000E-04  -1.72264000E-03  +3.20690000E-04  +4.47490000E-04
   -4.19730000E-04  -4.60670000E-04  +1.27060000E-04  +7.41390000E-04  -2.25090000E-04
   -7.62940000E-04  -1.93260000E-04  +4.65170000E-04  -1.36987100E-02  -1.66989200E-02
   -9.24410900E-02  -3.00133300E-02  -1.67860400E-02  -9.30859000E-03  +1.67800000E-04
   -3.00030000E-04  +1.90000000E-05  -7.84913300E-02  +1.48149910E-01  +5.91976280E-01
   -6.02490000E-04  +3.57200000E-05  -5.81940000E-04  -6.53790000E-04  -1.40783000E-03
   -2.49774000E-03  +5.55460000E-04  -2.54170000E-04  -6.20350000E-04  -1.50670000E-04
   +4.90580000E-04  +1.61610000E-04  -9.91700000E-05  -2.75970000E-04  +1.00760000E-04
   +4.02650000E-04  +1.39700000E-05  +6.29500000E-05  -2.67552000E-03  -1.19459600E-02
   -2.74364400E-02  -5.54781000E-03  -2.82584000E-03  -1.30640000E-04  -1.27580000E-04
   +1.33610000E-04  +1.46400000E-05  -1.23211470E-01  -1.01305100E-02  +2.55700500E-02
   +6.90856370E-01  -1.44078000E-03  -1.12345000E-03  +1.49209000E-03  +5.32040000E-04
   +4.30970000E-04  -5.76910000E-04  -1.97400000E-05  -3.67300000E-05  +1.17050000E-04
   +9.26600000E-05  +8.50500000E-05  -1.64400000E-04  -8.09000000E-05  -1.04300000E-04
   +8.38100000E-05  +2.37800000E-04  +1.98000000E-04  -2.00450000E-04  -4.83576000E-03
   -6.11008000E-03  -1.34865500E-02  -1.98682000E-03  -1.42330000E-04  +3.97350000E-04
   +2.77100000E-05  +6.10600000E-05  -2.07400000E-05  -3.31385200E-02  -1.17081120E-01
   -7.84756000E-02  +1.49872170E-01  +2.73496210E-01  -2.35305000E-03  -1.63822000E-03
   +8.82560000E-04  -1.62400000E-04  -2.59650000E-04  -1.11883000E-03  +5.64130000E-04
   +1.98780000E-04  -4.25020000E-04  +9.80300000E-05  +1.29830000E-04  -2.56130000E-04
   +9.75500000E-05  -2.53700000E-04  +1.73400000E-04  +5.29600000E-04  -7.99600000E-05
   -2.34840000E-04  -8.90660000E-03  -5.87533000E-03  -4.61281000E-03  -2.37200000E-05
   +5.88000000E-06  +2.84020000E-04  -1.09180000E-04  +1.32250000E-04  -4.33100000E-05
   -3.58763900E-02  -9.97234100E-02  -2.70532690E-01  -8.61144300E-02  +1.72186570E-01
   +6.13538600E-01  +4.07700000E-04  +1.17260000E-04  -1.84460000E-04  +1.41130000E-04
   -3.80800000E-05  -1.05160000E-04  +1.28000000E-06  +4.62000000E-04  +1.17800000E-05
   -3.20300000E-05  -1.77550000E-04  +1.64100000E-05  +3.32010000E-04  +1.04100000E-05
   -1.39450000E-04  -4.35940000E-04  +2.91700000E-05  +1.97240000E-04  +3.57746000E-03
   -6.06870000E-04  +1.43237000E-03  +3.07260000E-04  +6.31600000E-05  +5.77280000E-04
   -2.47800000E-04  +1.56640000E-04  +6.50000000E-05  +2.38389800E-02  -2.58147700E-02
   -8.01273400E-02  -2.92496900E-01  -8.96587800E-02  -1.80379700E-02  +6.44170030E-01
   -5.60200000E-05  -5.93900000E-05  +2.77200000E-05  +2.51230000E-04  -1.48780000E-04
   +2.82500000E-04  -2.51490000E-04  +1.04350000E-04  +2.47320000E-04  +3.74200000E-05
   -9.58000000E-05  +3.37200000E-05  -7.72200000E-05  +1.01360000E-04  -4.84000000E-05
   -1.16290000E-04  +7.08200000E-05  +4.42000000E-05  -1.03440000E-04  +3.91694000E-03
   -3.84284000E-03  -8.80390000E-04  -2.88590000E-04  +9.81000000E-06  +8.25100000E-05
   -5.15200000E-05  +4.89000000E-06  -7.58904000E-03  -7.35656000E-03  -3.01705800E-02
   -1.15881270E-01  -1.18078200E-01  -4.13793100E-02  +1.59911400E-01  +2.73528980E-01
   -1.61990000E-04  +2.42510000E-04  +7.92000000E-06  +8.63260000E-04  +6.99900000E-05
   +3.06180000E-04  -2.38510000E-04  -1.97590000E-04  +2.88710000E-04  +1.92300000E-05
   -3.73600000E-05  +2.94000000E-06  -2.54190000E-04  +1.69970000E-04  +3.27700000E-05
   +1.20090000E-04  +2.71600000E-05  -8.70800000E-05  +1.95439000E-03  -2.22131000E-03
   -4.34469000E-03  -1.22582000E-03  -6.97730000E-04  -1.08530000E-04  +2.45500000E-04
   -1.94220000E-04  -4.35300000E-05  -3.06900400E-02  -1.54374000E-02  +9.92930000E-04
   -8.15077100E-02  -6.26312300E-02  -1.41213110E-01  -4.60849100E-02  +2.10697990E-01
   +6.53286170E-01  -1.39363000E-03  -7.05820000E-04  +7.27410000E-04  +1.05510000E-04
   +8.12930000E-04  -6.35100000E-05  -3.76880000E-04  -8.05570000E-04  +3.79470000E-04
   +3.99470000E-04  -1.40660000E-04  -1.09970000E-04  -8.10920000E-04  +5.59360000E-04
   +1.98090000E-04  +5.90880000E-04  +3.46900000E-05  -2.28000000E-04  -2.41534000E-03
   +2.31950000E-04  -2.44810000E-04  +4.35800000E-04  -1.10790000E-04  -3.51800000E-04
   +8.32720000E-04  -6.30080000E-04  -1.83230000E-04  -1.00422800E-02  +1.09453600E-02
   +3.33763400E-02  -5.59016500E-02  -2.43196800E-02  -1.12336100E-02  -2.29229620E-01
   +2.72092000E-03  +1.36056990E-01  +6.54406280E-01  -1.97790000E-04  -6.17000000E-06
   +2.70000000E-07  +2.75610000E-04  +6.50740000E-04  +8.37300000E-05  -2.59880000E-04
   -2.82870000E-04  +3.63680000E-04  +2.26040000E-04  -3.05390000E-04  -6.71600000E-05
   -2.91250000E-04  +4.94040000E-04  +9.77000000E-06  -6.63000000E-06  -1.05100000E-05
   -2.98100000E-05  -1.64380000E-04  -3.03650000E-04  -6.77020000E-04  +2.11100000E-04
   +1.15270000E-04  -3.74900000E-05  +4.38960000E-04  -3.86190000E-04  -8.17200000E-05
   +1.16299800E-02  -9.43824000E-03  -1.59167100E-02  -1.99370000E-03  +1.17355400E-02
   +2.42694300E-02  -2.99248400E-02  -8.52516700E-02  -1.24859100E-02  +1.47636870E-01
   +2.97433370E-01  -7.46100000E-05  +1.00010000E-04  +4.69900000E-05  +5.53820000E-04
   +8.42850000E-04  +7.73600000E-05  -5.27210000E-04  -1.93480000E-04  +4.97080000E-04
   +3.12920000E-04  -4.81590000E-04  -4.46100000E-05  -1.80290000E-04  +6.32440000E-04
   -1.11850000E-04  -2.42280000E-04  +4.56500000E-05  +7.59800000E-05  +7.17200000E-04
   +1.87500000E-05  -1.87044000E-03  +2.10570000E-04  -1.29500000E-04  +2.43330000E-04
   +4.15090000E-04  -3.95190000E-04  -7.48600000E-05  +3.12210000E-02  -1.65946000E-02
   -6.99294900E-02  +4.19829600E-02  +4.12367900E-02  +6.71294600E-02  +6.13018300E-02
   -3.87880000E-02  -2.09063220E-01  -5.53982200E-02  +1.90069300E-01  +6.52939750E-01
   -6.80570000E-04  -7.22740000E-04  +7.14220000E-04  -6.76140000E-04  -5.89010000E-04
   -2.31500000E-04  +2.99130000E-04  +1.98940000E-04  -3.87480000E-04  -1.64640000E-04
   +3.58700000E-04  -8.30000000E-07  +1.81900000E-05  -4.69990000E-04  +1.42570000E-04
   +4.09890000E-04  -1.88200000E-05  -2.38850000E-04  +4.31180000E-04  -4.78600000E-05
   +4.11908000E-03  +1.83330000E-04  +4.54240000E-04  +3.86410000E-04  -2.08040000E-04
   +2.39710000E-04  +1.66800000E-05  -5.20168300E-02  -3.64742000E-03  +3.89089300E-02
   -2.14949500E-02  -1.84415200E-02  -2.99518100E-02  +4.04817200E-02  +1.81868000E-02
   +1.60399600E-02  -1.24254170E-01  +7.97600000E-04  +4.56872300E-02  +6.93466050E-01
   -3.04830000E-04  -4.77770000E-04  +3.59450000E-04  -9.60090000E-04  -9.31090000E-04
   -2.09130000E-04  +2.02050000E-04  +2.71800000E-04  -3.97530000E-04  -1.43250000E-04
   +3.17050000E-04  +6.71400000E-05  +5.97500000E-05  -4.22870000E-04  +6.80300000E-05
   +3.00380000E-04  +3.77100000E-05  +3.69000000E-06  -1.12478000E-03  +4.97925000E-03
   -1.68641000E-03  -2.40450000E-04  -3.06490000E-04  -1.43590000E-04  -2.46900000E-04
   +2.51550000E-04  +1.75500000E-05  -2.30469300E-02  +1.50462700E-02  +3.34549200E-02
   -1.71801500E-02  -1.91560900E-02  -2.53772100E-02  +3.57816900E-02  +1.54657300E-02
   -1.17602800E-02  -2.89623800E-02  -1.15476470E-01  -7.90954000E-02  +1.57715770E-01
   +2.63446220E-01  +3.79500000E-04  -6.25000000E-06  -2.08340000E-04  +5.90130000E-04
   +1.27210000E-04  +7.07900000E-05  +4.29550000E-04  -9.15900000E-05  -2.23460000E-04
   -1.71830000E-04  +2.95640000E-04  -4.68500000E-05  +1.24480000E-04  -3.79890000E-04
   +5.39400000E-05  +1.10530000E-04  +2.24000000E-06  -3.81500000E-05  +3.38661000E-03
   -3.50727000E-03  -8.36800000E-04  -8.22360000E-04  -6.08080000E-04  -4.77410000E-04
   -2.59450000E-04  +2.45990000E-04  +5.41000000E-05  -7.06168000E-03  +2.07944300E-02
   +5.55408300E-02  -2.53578200E-02  -2.35792200E-02  -3.87218700E-02  +5.78148200E-02
   +2.64445000E-03  -3.26956500E-02  -2.45148500E-02  -1.03644730E-01  -2.93050410E-01
   -9.20379400E-02  +1.83296600E-01  +6.33735620E-01  -1.20109000E-03  -2.62280000E-04
   +7.45660000E-04  -1.48303000E-03  -1.42683000E-03  -2.86870000E-04  -6.67540000E-04
   +7.55680000E-04  +1.28130000E-04  +4.42000000E-05  -2.50170000E-04  +2.01420000E-04
   +4.23500000E-05  +2.27700000E-04  -1.24600000E-04  -2.29630000E-04  +6.42900000E-05
   +8.32700000E-05  -2.11432900E-02  -1.86134000E-03  +1.16682400E-02  -1.26092000E-03
   -7.27540000E-04  +8.78370000E-04  +5.24400000E-05  -5.67900000E-05  +1.90400000E-05
   -2.45278880E-01  -3.51073100E-02  +7.07779500E-02  +3.90938700E-02  +3.73358800E-02
   +6.58512600E-02  -6.75802400E-02  -1.75285800E-02  +1.07741100E-02  +2.96519400E-02
   -2.78564100E-02  -8.88108000E-02  -2.86321910E-01  -8.48960700E-02  -1.34785600E-02
   +6.28647130E-01  -1.17400000E-03  -1.12619000E-03  +1.35228000E-03  -4.26730000E-04
   -9.83450000E-04  -2.74920000E-04  -3.78170000E-04  +4.38940000E-04  +2.09300000E-05
   -1.80500000E-05  +4.96200000E-05  +2.83000000E-05  -5.03900000E-05  -1.24320000E-04
   +6.63800000E-05  +2.66230000E-04  +1.42480000E-04  -3.24490000E-04  -1.03675500E-02
   +2.40358000E-03  +9.05827000E-03  -4.28040000E-04  -6.69260000E-04  +3.24760000E-04
   +2.16800000E-05  +5.69700000E-05  -1.20000000E-05  -8.04697000E-03  -8.18798500E-02
   -2.92704800E-02  +1.79931600E-02  +1.43141600E-02  +5.05270000E-04  -1.46967900E-02
   -7.08290000E-03  +3.18429000E-03  -6.44973000E-03  -1.26576700E-02  -2.88233700E-02
   -1.12308030E-01  -1.17379630E-01  -4.01406500E-02  +1.47471560E-01  +2.84018380E-01
   +8.98670000E-04  +9.15590000E-04  -7.86920000E-04  -3.12576000E-03  -2.06710000E-03
   -7.15300000E-05  +6.73100000E-05  +7.25350000E-04  -4.27930000E-04  -3.90440000E-04
   +2.13380000E-04  +3.27580000E-04  +1.69280000E-04  -3.58960000E-04  -3.08900000E-05
   -1.99360000E-04  -9.23900000E-05  +2.42830000E-04  -4.41464000E-03  +3.42910000E-03
   +1.03283500E-02  -1.10981000E-03  +4.73140000E-04  +6.76360000E-04  -3.60790000E-04
   +2.72640000E-04  +8.26800000E-05  +1.28178010E-01  -1.09628600E-02  -1.91766380E-01
   +1.86202800E-02  -1.47145800E-02  -4.16245400E-02  +1.43873900E-02  +3.94651000E-03
   -5.69954000E-03  -3.57354600E-02  -1.22854600E-02  +2.09264000E-03  -7.55790800E-02
   -5.96568700E-02  -1.38314610E-01  -5.10655800E-02  +2.02238360E-01  +6.57951300E-01
   +1.04811000E-03  +3.07250000E-04  -4.11480000E-04  -3.46300000E-04  -1.25878000E-03
   -2.25130000E-04  +6.58250000E-04  +9.27380000E-04  -7.09070000E-04  -5.14100000E-04
   +4.18170000E-04  +1.20970000E-04  +8.65210000E-04  -8.96060000E-04  -1.16170000E-04
   -3.82180000E-04  -1.21000000E-05  +2.19630000E-04  +1.78246000E-03  -4.49780000E-04
   +1.15675000E-03  -6.41140000E-04  -2.36400000E-05  +3.08720000E-04  -1.03981000E-03
   +8.38950000E-04  +2.09300000E-04  -2.59958000E-03  +8.07000000E-05  -5.19381000E-03
   +3.15477000E-03  +1.72754000E-03  +7.76704000E-03  -4.94837400E-02  -2.62209400E-02
   -1.23437800E-02  -2.65194520E-01  -8.29884000E-02  -1.25095500E-02  -7.60052000E-03
   -1.19037800E-02  -1.53834200E-02  +5.32160000E-04  -1.22500000E-05  +3.98485000E-03
   +3.64996170E-01  +3.66510000E-04  +7.70000000E-05  -1.45630000E-04  -2.03910000E-04
   -6.43830000E-04  -2.14270000E-04  +3.51740000E-04  +3.85610000E-04  -3.88670000E-04
   -2.63370000E-04  +3.00960000E-04  +5.51600000E-05  +4.09040000E-04  -5.23160000E-04
   -2.43500000E-05  -1.27800000E-04  +1.12000000E-06  +1.23770000E-04  +9.33090000E-04
   -7.81240000E-04  +9.93710000E-04  -3.15790000E-04  -3.24600000E-05  +1.46220000E-04
   -5.47050000E-04  +4.68600000E-04  +1.09910000E-04  -2.09820000E-03  -1.73700000E-04
   +8.31000000E-04  -1.66722000E-03  +5.18335000E-03  -3.39756000E-03  -1.07723300E-02
   +4.78999000E-03  -3.24199000E-03  -1.02808960E-01  -9.50157100E-02  -3.39570000E-02
   -2.67186500E-02  -8.23397000E-03  -1.54282500E-02  +2.66946000E-03  +4.68192000E-03
   -2.95117000E-03  +1.24217620E-01  +1.74919430E-01  +4.85190000E-04  +1.92330000E-04
   -2.38010000E-04  -1.73350000E-04  -5.87870000E-04  -5.42000000E-06  +2.42680000E-04
   +3.46320000E-04  -2.53990000E-04  -2.20530000E-04  +1.78950000E-04  +7.12900000E-05
   +2.97060000E-04  -3.46310000E-04  -4.35500000E-05  -1.26000000E-04  +6.58000000E-06
   +8.51200000E-05  +3.74430000E-04  -1.31000000E-06  +7.61520000E-04  -2.18910000E-04
   -3.50600000E-05  +4.49300000E-05  -3.75480000E-04  +3.09050000E-04  +8.62900000E-05
   -3.98974000E-03  +2.28900000E-03  +4.88479000E-03  -3.05590000E-04  -6.08072000E-03
   -6.78386000E-03  +2.27901100E-02  +9.17955000E-03  +1.27863200E-02  -5.88095400E-02
   -5.02913700E-02  -1.13449030E-01  -4.99914400E-02  -2.76527100E-02  -1.59814300E-02
   +1.03393600E-02  -1.00941000E-03  -5.00729000E-03  +1.35835900E-02  +2.42347900E-01
   +5.81269370E-01  -5.63740000E-03  +1.51706000E-03  +2.25826000E-03  +4.59560000E-04
   +2.44657800E-02  -1.39466800E-02  -6.61200000E-05  +1.96019000E-03  -6.98380000E-04
   -8.16900000E-05  +4.71640000E-04  -2.92050000E-04  +2.90440000E-04  -4.35790000E-04
   -4.12900000E-05  +6.48950000E-04  +1.29519000E-03  -4.44740000E-04  -7.48579600E-02
   -6.77590000E-03  +4.51063000E-03  +6.94060000E-04  +3.68860000E-04  -5.43310000E-04
   -4.59680000E-04  +3.68600000E-04  +1.21800000E-04  -7.35990000E-03  -2.78738400E-02
   +1.45987000E-02  -6.13710000E-04  -1.35009000E-03  +5.73050000E-04  -1.79590000E-04
   +8.05960000E-04  +4.12640000E-04  +7.24060000E-04  +6.21460000E-04  +9.70670000E-04
   -1.39704000E-03  +7.06050000E-04  -1.54657000E-03  -1.27390000E-04  -1.72970000E-03
   -1.16107000E-03  -1.52387000E-03  -8.46630000E-04  -6.56580000E-04  +5.96125860E-01
   +2.51420000E-03  -4.74100000E-05  -4.10030000E-04  +4.71081000E-03  -2.26025800E-02
   +1.05862400E-02  -3.19160000E-04  +9.85490000E-04  -1.81320000E-04  -6.88110000E-04
   -3.45690000E-04  +2.46080000E-04  +9.37000000E-05  -8.54200000E-05  +4.88500000E-05
   -3.20540000E-04  -7.00420000E-04  +2.00700000E-04  -1.24692000E-03  -1.47068300E-01
   +4.58269100E-02  +3.80780000E-04  +3.84930000E-03  +2.67095000E-03  -1.04420000E-04
   +7.63400000E-05  +3.49700000E-05  -1.38456800E-02  -2.33519800E-02  +7.16784000E-03
   +2.20550000E-04  -3.85610000E-04  +1.26294000E-03  +3.40200000E-05  +6.78870000E-04
   +2.17800000E-04  +4.24800000E-05  +2.84880000E-04  +5.01390000E-04  -5.39170000E-04
   +2.47260000E-04  -7.94310000E-04  +2.02497000E-03  -8.12030000E-04  -6.62160000E-04
   -2.34530000E-04  -1.81980000E-04  -1.41850000E-04  +6.55345000E-03  +4.92491360E-01
   +2.16236000E-03  -9.11290000E-04  -7.83080000E-04  -2.26594000E-03  -5.36138000E-03
   +4.03904000E-03  +6.16820000E-04  -7.80440000E-04  +1.72860000E-04  +1.18640000E-04
   -2.43080000E-04  -6.14100000E-05  -1.73100000E-04  +5.32600000E-05  +1.64620000E-04
   +5.47500000E-05  -5.16880000E-04  +1.67360000E-04  +1.30068000E-03  +4.23051800E-02
   -1.01853540E-01  +2.23097000E-03  +3.12972100E-02  -3.07295700E-02  +2.60320000E-04
   -1.87240000E-04  -6.58200000E-05  +3.23275000E-03  -2.80425000E-03  +5.29613000E-03
   -1.84622000E-03  -1.21677000E-03  -4.28360000E-04  +3.58840000E-04  +3.76030000E-04
   +4.69000000E-06  +2.69690000E-04  +3.20900000E-04  +9.01530000E-04  -5.44510000E-04
   -1.45010000E-04  -9.02570000E-04  -8.14000000E-06  -5.02760000E-04  -4.90410000E-04
   -9.26530000E-04  -5.01730000E-04  -4.77830000E-04  -2.20874000E-03  +5.49973800E-02
   +5.62614670E-01  -2.16107430E-01  -6.81958000E-02  +1.07239900E-01  -2.74996000E-03
   -1.31204300E-02  +1.33723000E-02  +3.31120000E-04  +4.71820000E-03  +1.30357000E-03
   -3.23260000E-03  -6.88092000E-03  +2.94220000E-03  +5.08451000E-03  +8.79647000E-03
   -4.34781000E-03  -5.56763700E-02  -1.31252000E-02  +3.65153800E-02  -5.29889000E-03
   +9.42780000E-04  -1.73349000E-03  +1.98124000E-03  -1.26967000E-03  +9.70230000E-04
   -3.29300000E-03  -2.36430000E-04  +1.75137000E-03  -6.98307000E-03  +6.27997000E-03
   -6.62498000E-03  +5.17010000E-04  +3.37475000E-03  +3.71536000E-03  -1.50939000E-03
   -2.81730000E-04  +3.98860000E-04  +2.48754000E-03  +2.25420000E-04  -3.83560000E-04
   +1.35634000E-03  +4.94600000E-04  -1.41640000E-04  +2.01354000E-03  +2.79426000E-03
   -3.09166000E-03  -1.85195000E-03  -7.71730000E-04  -7.23170000E-04  +1.02958000E-03
   +1.28570000E-04  -6.77600000E-05  +6.39797960E-01  -3.85903000E-02  -1.31787630E-01
   +6.54512000E-02  -3.62367600E-02  -1.76154700E-02  +2.91943500E-02  +8.32157000E-03
   -3.53764000E-03  -7.11200000E-05  -3.38117000E-03  +3.92449000E-03  -3.95720000E-04
   +1.26050000E-04  -7.88737000E-03  +3.60460000E-03  +1.95441800E-02  +1.77164700E-02
   -1.33199200E-02  -1.61128000E-03  +3.66200000E-03  -1.42919000E-03  +1.74140000E-04
   -6.41800000E-05  -1.49871000E-03  +1.39590000E-03  +1.04096000E-03  -9.91390000E-04
   +3.44335000E-03  -4.89720000E-03  +3.76334000E-03  -9.48290000E-04  -1.26090000E-03
   -1.34791000E-03  +1.58569000E-03  +7.98240000E-04  -4.53000000E-04  -9.22850000E-04
   -1.35670000E-04  +6.52590000E-04  -5.55300000E-05  +2.87000000E-04  +1.04100000E-04
   -6.39400000E-04  -4.60770000E-04  +9.80540000E-04  +1.07233000E-03  +6.07920000E-04
   +3.00350000E-04  -3.55000000E-06  +4.90520000E-04  +6.30900000E-05  -1.38988930E-01
   +3.04487090E-01  +7.98390900E-02  +7.40684900E-02  -1.21307630E-01  +1.94187900E-02
   +1.59897900E-02  -6.75374000E-03  +5.44520000E-04  +6.59920000E-04  +4.99192000E-03
   +2.36975000E-03  +2.92196000E-03  -3.52707000E-03  -2.28555000E-03  -2.09350000E-04
   +6.17941000E-03  +2.44821500E-02  +7.86690000E-04  -2.28410000E-03  +7.75900000E-04
   -3.79297000E-03  -2.80393000E-03  -2.52600000E-05  +1.11834000E-03  -2.37114000E-03
   +4.79350000E-04  -1.16530000E-04  -2.87130000E-04  -2.94094000E-03  +3.56659000E-03
   -9.61580000E-04  -7.06380000E-04  +7.51560000E-04  -5.28870000E-04  +6.65220000E-04
   +4.19000000E-04  +4.34740000E-04  -2.11220000E-04  +2.08200000E-04  +5.94870000E-04
   -9.53670000E-04  -1.11663000E-03  -4.26850000E-04  +1.56340000E-03  -3.19250000E-04
   -1.69650000E-04  -3.40760000E-04  -1.95010000E-04  -8.18700000E-05  -3.78580000E-04
   +5.93200000E-05  +3.75120000E-04  -8.06382300E-02  -1.45116210E-01  +1.57262800E-01
   -1.39680000E-04  -5.41700000E-05  +6.20700000E-05  +3.02200000E-05  +9.41000000E-05
   -6.75000000E-06  -8.76200000E-05  -1.20910000E-04  +9.81300000E-05  +5.56600000E-05
   -2.66200000E-05  -6.92000000E-06  -1.38450000E-04  +9.85100000E-05  +2.64800000E-05
   +6.98300000E-05  +1.70300000E-05  -9.14000000E-06  -2.02960000E-04  +6.74000000E-06
   +1.04870000E-04  +8.67700000E-05  +2.02100000E-05  -1.30700000E-05  +1.37910000E-04
   -9.80900000E-05  -2.26500000E-05  -8.27900000E-05  +2.33380000E-04  +6.52820000E-04
   -5.53010000E-04  -7.10000000E-05  -2.46750000E-04  +1.73907000E-03  -1.02810000E-04
   -2.40341000E-03  -2.52658000E-03  -1.83027600E-02  -4.29530100E-02  -6.03395000E-03
   -3.09586000E-03  -4.40210000E-04  +1.48528000E-03  -6.26770000E-04  -1.03575000E-03
   -4.44728700E-02  +1.49453500E-02  +6.80883200E-02  +4.47600000E-05  -3.27000000E-06
   -1.38500000E-05  +2.07050000E-04  +2.36900000E-05  -1.03300000E-05  +5.18088900E-02
   -1.99500000E-05  +3.72100000E-05  -1.18000000E-05  +4.57400000E-05  +7.84900000E-05
   +4.56400000E-05  -5.95200000E-05  -3.70400000E-05  +5.91200000E-05  +3.84600000E-05
   -7.19600000E-05  +2.58000000E-06  -7.63100000E-05  +1.14840000E-04  -4.55000000E-06
   +1.51800000E-05  -2.63000000E-06  -2.43900000E-05  -1.30600000E-04  -2.45600000E-05
   -1.03100000E-05  +5.40500000E-05  -6.22000000E-06  -1.46900000E-05  +1.07650000E-04
   -1.04460000E-04  -2.33800000E-05  +1.47400000E-05  +1.59660000E-04  +4.60650000E-04
   +2.77800000E-05  -7.67170000E-04  -3.27030000E-04  +2.52328000E-03  +5.76030000E-04
   +1.48327000E-03  +3.17730000E-04  -1.13930800E-02  -2.02635100E-02  -3.60045000E-03
   +9.21690000E-04  -2.49500000E-05  +1.23250000E-04  +1.20564000E-03  -1.33779000E-03
   -5.26779000E-03  -7.96921400E-02  -1.72545870E-01  +4.72400000E-05  +3.36000000E-06
   +2.64000000E-05  +7.92800000E-05  -1.39070000E-04  +3.50600000E-05  +6.44740000E-03
   +8.90657000E-02  -1.97580000E-04  -8.99900000E-05  +1.07090000E-04  +3.37200000E-05
   +1.49730000E-04  +2.30000000E-06  -7.94600000E-05  -1.08180000E-04  +7.86600000E-05
   +6.31300000E-05  -3.38000000E-05  -2.53000000E-05  -1.05100000E-04  +8.53900000E-05
   +2.53800000E-05  +6.16200000E-05  -1.44000000E-06  -2.94000000E-05  -1.95380000E-04
   +9.21700000E-05  -1.86810000E-04  +6.01400000E-05  -1.72000000E-06  -2.46700000E-05
   +1.11820000E-04  -8.50300000E-05  -2.91800000E-05  +1.91450000E-04  -3.58700000E-05
   +6.15160000E-04  -3.61900000E-05  -2.22610000E-04  -1.19779000E-03  +3.77153000E-03
   +3.62930000E-03  +4.40033000E-03  +4.50880000E-04  -4.94483000E-03  -1.47629500E-02
   -1.72628000E-03  -5.27900000E-04  +2.38530000E-03  +5.34550000E-04  -7.74130000E-04
   -5.32110000E-04  +2.09599600E-02  -1.89077340E-01  -4.61670330E-01  +1.79600000E-04
   +4.00900000E-05  +1.15640000E-04  +2.93140000E-04  -4.92700000E-05  -5.70000000E-06
   -2.36563000E-02  +1.91864430E-01  +4.71033750E-01  +8.84000000E-06  -3.30200000E-05
   -1.94000000E-06  +8.21400000E-05  -7.04800000E-05  +9.96000000E-06  +5.91800000E-05
   +4.59000000E-05  -4.93800000E-05  -4.82100000E-05  +6.62700000E-05  +2.42100000E-05
   +2.64400000E-05  -7.50000000E-05  +2.45000000E-06  -3.49000000E-06  +2.71300000E-05
   +2.33900000E-05  +6.18520000E-04  -3.21370000E-04  -1.17592000E-03  -4.15970000E-04
   -1.49850000E-04  +4.92800000E-05  -6.27200000E-05  +6.73000000E-05  +2.66700000E-05
   -3.63458000E-03  -4.11879000E-03  -2.98050000E-04  +3.11007000E-03  -1.12411500E-02
   -2.62420100E-02  -5.88267500E-02  -1.25912800E-02  -9.45760000E-03  +5.13468000E-03
   +9.89427000E-03  +2.20662700E-02  -3.26842000E-03  -1.41177000E-03  +3.85165000E-03
   -1.65089000E-03  -2.11790000E-04  +2.80000000E-05  +2.52424000E-03  +2.17769000E-03
   +6.62000000E-06  +1.37300000E-05  +9.64700000E-05  -5.94700000E-05  -5.78400000E-05
   +9.70600000E-05  +2.27100000E-05  -9.75270000E-04  -7.80410000E-04  -5.93430000E-04
   +5.66530000E-02  +1.60160000E-04  +9.90100000E-05  -3.28800000E-05  +1.26010000E-04
   -1.43840000E-04  +5.98000000E-06  +1.45000000E-05  +9.29200000E-05  -1.22800000E-05
   -2.99000000E-05  -2.05900000E-05  +1.97200000E-05  +5.93100000E-05  -7.90000000E-06
   -2.69600000E-05  -4.11100000E-05  +6.50000000E-07  +1.32800000E-05  +1.14310000E-04
   +2.49310000E-04  -6.09590000E-04  -2.31660000E-04  -1.68620000E-04  +1.31200000E-05
   -4.54900000E-05  +2.18800000E-05  +9.69000000E-06  -4.11285000E-03  +5.21989000E-03
   -2.12968000E-03  +6.72150000E-04  -2.35290000E-03  -1.24920800E-02  -1.27302800E-02
   -8.70494800E-02  -1.11986920E-01  -2.82667000E-03  +3.09380000E-03  -2.40170000E-04
   -1.21103000E-03  +4.61833000E-03  -1.07342000E-03  -6.61800000E-05  -6.62790000E-04
   +5.55460000E-04  +1.99088000E-03  -1.97660000E-03  +2.56632000E-03  -5.17100000E-05
   -1.84600000E-05  -9.49000000E-06  -1.62670000E-04  -4.20900000E-05  -2.41600000E-05
   +3.66490000E-04  +3.96320000E-04  -6.49920000E-04  +1.63801900E-02  +8.28304100E-02
   -3.54600000E-05  -8.11500000E-05  +1.53000000E-05  -4.21800000E-05  -6.51400000E-05
   -1.61900000E-05  +8.05700000E-05  +5.93400000E-05  -8.24500000E-05  -4.64100000E-05
   +7.59200000E-05  +5.44000000E-06  +4.55700000E-05  -1.05860000E-04  +1.42600000E-05
   +4.30000000E-06  +1.19100000E-05  +2.09900000E-05  +4.82550000E-04  -1.39320000E-04
   -3.19880000E-04  -1.89290000E-04  -4.19900000E-05  +5.23400000E-05  -8.70100000E-05
   +8.74500000E-05  +2.21800000E-05  -9.69360000E-04  -2.39741000E-03  +2.81331000E-03
   +1.19791000E-03  -2.90599000E-03  -4.91019000E-03  -9.76038000E-03  -1.11924490E-01
   -2.84805170E-01  -6.98080000E-03  -1.04332600E-02  -1.42725000E-02  +4.36954000E-03
   -9.15430000E-04  -1.82860000E-04  +4.48830000E-04  +7.11290000E-04  +4.38470000E-04
   -6.99770000E-04  +2.29625000E-03  +2.07584000E-03  -5.64000000E-05  +3.09600000E-05
   -6.63900000E-05  -4.53000000E-06  +1.19030000E-04  +3.87000000E-06  +2.05301000E-03
   +2.83070000E-04  -4.42480000E-04  +1.12430900E-02  +1.23902370E-01  +3.00542910E-01
   -2.26440000E-04  +2.06750000E-04  -6.00000000E-04  -6.14510000E-04  -3.68560000E-04
   -8.74100000E-04  -1.42370000E-04  -2.04800000E-04  +9.52000000E-06  -8.45900000E-05
   +9.09500000E-05  +4.33700000E-05  -2.10750000E-04  +6.29100000E-05  +1.24740000E-04
   +2.08890000E-04  -7.22400000E-05  -6.00200000E-05  -6.46330000E-04  +4.47530000E-04
   -6.71880000E-04  +1.58800000E-05  +1.42800000E-04  -1.51200000E-05  +1.52040000E-04
   -1.21000000E-04  -4.47600000E-05  +5.56746000E-03  -5.76300000E-05  -1.36222000E-03
   -2.29062270E-01  -4.04232000E-03  +1.38753620E-01  -1.62676100E-02  +7.16920000E-04
   +1.80591900E-02  -1.58803000E-03  -4.13670000E-03  -2.00155000E-03  -7.48300000E-05
   +2.80000000E-05  -8.94040000E-04  +1.60577000E-03  -1.71968000E-03  -3.76920000E-04
   -1.47975000E-03  -1.00340000E-04  +7.19070000E-04  -7.34600000E-05  -1.29820000E-04
   -5.43000000E-06  -1.59720000E-04  -1.07950000E-04  +3.34420000E-04  +1.17250000E-04
   +1.26980000E-04  +2.14880000E-04  +4.30150000E-04  +1.31276000E-03  -7.73090000E-04
   +2.42082920E-01  +1.96680000E-04  +5.09450000E-04  -1.38040000E-04  -5.92300000E-05
   +1.21490000E-04  +2.98500000E-05  -1.97500000E-05  -4.70400000E-05  -1.35060000E-04
   -5.72700000E-05  +8.80000000E-06  +3.40100000E-05  -1.90000000E-06  +6.60000000E-07
   +1.34800000E-05  +9.29600000E-05  -1.90460000E-04  -6.12300000E-05  +1.20385000E-03
   -2.16389000E-03  +1.08660000E-03  +1.92810000E-04  -6.81700000E-05  +1.01310000E-04
   +2.45500000E-05  -6.54200000E-05  -2.03600000E-05  +1.07001300E-02  +4.71221000E-03
   -7.68414000E-03  -3.55088000E-03  -4.50365000E-02  -8.47132000E-03  -1.13509400E-02
   +4.13786000E-03  +8.60798000E-03  -4.00572000E-03  +5.13412000E-03  -3.75813000E-03
   +6.89500000E-05  -1.17419000E-03  +1.48910000E-04  -1.98370000E-03  +3.86608000E-03
   -4.40770000E-03  -7.06220000E-04  -2.01150000E-04  +4.82170000E-04  -1.37650000E-04
   -2.62060000E-04  -5.66440000E-04  -3.85940000E-04  -2.84060000E-04  -1.03800000E-05
   +6.10700000E-05  +4.75200000E-05  +1.00610000E-04  +1.57299000E-03  -3.29916000E-03
   +1.73344000E-03  +7.71884000E-03  +3.53344100E-02  +3.32830000E-04  +5.83000000E-04
   -5.04150000E-04  -2.27080000E-04  -1.55180000E-04  +6.25600000E-05  -7.18640000E-04
   -1.21540000E-04  +5.03670000E-04  +1.14780000E-04  -2.72040000E-04  +6.83000000E-06
   -2.75710000E-04  +3.02660000E-04  -2.61600000E-05  -3.92600000E-05  +9.46200000E-05
   -2.30000000E-07  +8.05260000E-04  +1.51109000E-03  -2.22230000E-04  -1.52670000E-04
   +4.27800000E-05  +1.79000000E-05  +3.57820000E-04  -2.91450000E-04  -6.31300000E-05
   +2.35678500E-02  +7.82260000E-04  -1.23252500E-02  +1.38421320E-01  -7.60686000E-03
   -1.66006520E-01  -9.03332000E-03  -9.23280000E-04  +9.43594000E-03  -1.63598000E-03
   -3.53229000E-03  +1.44074000E-03  -1.07753000E-03  +6.84200000E-05  -3.46910000E-04
   -7.64740000E-04  -4.78085000E-03  -4.07801000E-03  -4.09640000E-04  +8.81500000E-05
   +3.44740000E-04  -2.94400000E-05  -9.93600000E-05  -2.21090000E-04  -4.94290000E-04
   +3.36500000E-05  +3.24360000E-04  +1.65300000E-05  +2.49800000E-05  +3.60500000E-05
   -3.91240000E-04  +1.90783000E-03  +6.54000000E-05  -1.50054260E-01  +1.22473100E-02
   +1.71968200E-01  -3.14900000E-05  -2.94300000E-05  +9.37000000E-05  -4.01300000E-05
   +4.64600000E-05  -2.96870000E-04  -6.36500000E-05  -8.62600000E-05  +1.22500000E-05
   +7.21900000E-05  -5.28800000E-05  +2.63000000E-06  -5.85500000E-05  +9.12700000E-05
   +1.05500000E-05  +2.95600000E-05  -1.93000000E-06  -1.75600000E-05  +5.59680000E-04
   +1.28206000E-03  -3.30310000E-04  -2.32754000E-03  -7.23100000E-04  +2.74180000E-04
   +8.82400000E-05  -8.00200000E-05  -2.84600000E-05  +7.17254000E-03  +1.03909000E-02
   +2.14706400E-02  -3.56263000E-03  -1.73472000E-03  +4.25792000E-03  -1.38908000E-03
   -9.26700000E-05  -3.30100000E-05  -3.30594000E-03  -4.03474000E-03  -1.92650000E-04
   +2.48761000E-03  -1.17581600E-02  -2.57045300E-02  -5.85880700E-02  -9.76722000E-03
   -8.47784000E-03  +6.12100000E-05  -5.52960000E-04  -1.37774000E-03  +1.88390000E-04
   -3.91400000E-05  -8.42200000E-05  -4.54700000E-05  -8.31300000E-05  -2.95190000E-04
   -3.54140000E-04  -1.21660000E-04  -1.84600000E-04  +2.52000000E-06  +2.18060000E-04
   -9.91500000E-05  +2.60280000E-04  +5.38820000E-04  +1.30819000E-03  +6.04882300E-02
   +4.16840000E-04  +3.62280000E-04  -3.21610000E-04  +3.99630000E-04  +3.09340000E-04
   +1.76000000E-06  +3.87800000E-05  -1.06640000E-04  +4.18400000E-05  +4.00000000E-06
   -6.54900000E-05  +2.52000000E-06  +1.07400000E-05  +8.61900000E-05  -4.34600000E-05
   -1.33910000E-04  -2.79200000E-05  +4.85400000E-05  +9.68070000E-04  -2.98930000E-03
   +9.28540000E-04  -1.79854000E-03  +5.64400000E-05  -1.00080000E-04  +3.09500000E-05
   -4.93100000E-05  +1.01000000E-05  +2.43680000E-04  +4.08385000E-03  +2.60180000E-04
   -1.63063000E-03  +5.43551000E-03  -1.60559000E-03  +1.75500000E-05  -8.58320000E-04
   +6.68170000E-04  -4.03095000E-03  +5.68323000E-03  -2.27467000E-03  -1.73300000E-05
   -1.36792000E-03  -1.25340800E-02  -9.99499000E-03  -9.02666800E-02  -1.10747410E-01
   -6.16800000E-05  -2.95680000E-04  -6.99340000E-04  -6.92860000E-04  -1.93930000E-04
   -9.30600000E-05  -5.35230000E-04  -1.02900000E-04  +5.22670000E-04  -7.70300000E-05
   -2.20480000E-04  +1.91200000E-05  +1.94530000E-04  -5.78110000E-04  +2.07910000E-04
   -9.79200000E-05  +1.01080000E-04  +5.75100000E-05  +1.62553300E-02  +8.59414700E-02
   -3.55400000E-05  -3.61300000E-05  -4.86000000E-06  -5.56700000E-05  +3.07200000E-05
   +4.89100000E-05  -2.34100000E-05  -7.20000000E-07  +3.35800000E-05  +1.24900000E-05
   +1.00100000E-05  +3.10000000E-07  +7.78000000E-06  -2.11000000E-06  -1.41000000E-05
   -2.03600000E-05  +1.01000000E-05  +1.10700000E-05  -1.64344000E-03  +3.58950000E-04
   -1.30450000E-03  -1.58353000E-03  -1.05200000E-03  -1.36300000E-05  -1.29600000E-05
   +1.90200000E-05  +9.48000000E-06  -2.24390000E-03  -8.09266000E-03  -1.31488600E-02
   +4.33294000E-03  -1.44942000E-03  -9.16400000E-05  +8.70900000E-05  +7.29930000E-04
   +5.06010000E-04  -2.47840000E-04  -2.34589000E-03  +2.79846000E-03  +1.48485000E-03
   -3.13372000E-03  -4.50222000E-03  -7.95648000E-03  -1.11189040E-01  -2.93354890E-01
   -1.80050000E-04  -3.09770000E-04  -5.52450000E-04  +4.60560000E-04  +4.49300000E-05
   +7.74600000E-05  +1.82680000E-04  -4.65600000E-05  +1.23540000E-04  -8.75000000E-05
   +5.09100000E-05  -1.31900000E-05  -1.40960000E-04  +1.91900000E-04  -1.72760000E-04
   -2.29310000E-04  -4.26200000E-04  -7.41520000E-04  +1.06264300E-02  +1.24522410E-01
   +3.09703300E-01  -5.21200000E-05  -6.55200000E-05  +8.85600000E-05  -1.16290000E-04
   -2.40670000E-04  -3.32800000E-05  +7.90000000E-07  +1.19980000E-04  -5.78000000E-05
   -3.68300000E-05  +3.75700000E-05  +1.95300000E-05  +4.44000000E-05  -7.22500000E-05
   +7.50000000E-07  +3.27000000E-06  +1.30800000E-05  +5.68000000E-06  -1.89320000E-04
   +2.87850000E-04  +9.72530000E-04  -1.45600000E-05  +6.51900000E-05  +9.14000000E-05
   -6.93700000E-05  +6.18900000E-05  +8.88000000E-06  -2.03849000E-03  -4.15831000E-03
   -2.15306000E-03  +4.45500000E-05  +6.12000000E-05  -8.07160000E-04  +1.37238000E-03
   -1.66701000E-03  -2.80620000E-04  +4.20811000E-03  -1.61494000E-03  -2.73277000E-03
   -2.33594870E-01  -8.60527000E-03  +1.42141780E-01  -1.54826800E-02  +1.23719000E-03
   +1.75396800E-02  +4.36870000E-04  +1.29191000E-03  -2.56450000E-04  -1.99740000E-04
   -1.43400000E-05  -1.26040000E-04  +1.56700000E-05  +1.38100000E-04  -1.51420000E-04
   -3.16000000E-05  +1.81010000E-04  -1.82200000E-05  +2.51600000E-04  +4.55500000E-05
   -2.35060000E-04  -9.94200000E-05  +2.10630000E-04  -6.50000000E-07  +3.64040000E-04
   +1.35143000E-03  -8.02020000E-04  +2.45131780E-01  -2.36000000E-06  +1.42500000E-05
   -1.89000000E-05  -3.21990000E-04  -1.92050000E-04  -4.06300000E-05  +2.71300000E-05
   +7.95200000E-05  -7.36600000E-05  -4.40400000E-05  +3.18400000E-05  +2.93800000E-05
   +1.38200000E-05  -5.09800000E-05  +6.01000000E-06  +4.77000000E-06  -1.12300000E-05
   -5.75000000E-06  -3.46750000E-04  +5.13420000E-04  +2.31430000E-04  +4.46700000E-05
   -1.81100000E-05  +6.82700000E-05  -3.49400000E-05  +2.84500000E-05  +9.65000000E-06
   -3.86482000E-03  +4.39075000E-03  -3.03131000E-03  -1.13260000E-04  -1.19042000E-03
   -1.61570000E-04  -1.84772000E-03  +3.34557000E-03  -4.19413000E-03  +1.05726300E-02
   +5.55963000E-03  -8.30637000E-03  -9.33279000E-03  -4.13291600E-02  -5.84534000E-03
   -1.01826800E-02  +2.85172000E-03  +9.27772000E-03  +1.22172000E-03  -2.26429000E-03
   +2.07166000E-03  +4.38000000E-06  +8.38100000E-05  +2.74000000E-06  -2.00400000E-05
   -7.03900000E-05  +7.42000000E-05  +1.37320000E-04  -3.56490000E-04  +3.59810000E-04
   +6.08760000E-04  -1.01620000E-04  -3.59200000E-04  +1.84460000E-04  -5.24920000E-04
   +2.76030000E-04  +1.58410000E-03  -3.20263000E-03  +1.69123000E-03  +1.16753900E-02
   +3.23661400E-02  -3.26500000E-05  -2.72900000E-05  +3.75100000E-05  +1.66700000E-05
   -3.26700000E-05  -6.69000000E-06  -1.94300000E-05  +9.50000000E-07  +1.62300000E-05
   +6.02000000E-06  +7.30000000E-07  +3.21000000E-06  -1.52200000E-05  +5.84000000E-06
   +2.10000000E-06  +1.23600000E-05  +1.07700000E-05  -1.70000000E-06  -2.84470000E-04
   -5.00700000E-05  +4.48020000E-04  +3.15800000E-05  +6.49200000E-05  +1.66200000E-05
   +1.11500000E-05  -5.50000000E-06  -2.63000000E-06  -1.76382000E-03  -3.07240000E-03
   +1.52598000E-03  -1.27978000E-03  -2.49140000E-04  -6.92490000E-04  -7.98690000E-04
   -4.37510000E-03  -3.78256000E-03  +2.59611300E-02  +1.74852000E-03  -1.17662600E-02
   +1.40695730E-01  -6.36402000E-03  -1.66206050E-01  -9.30681000E-03  -8.47700000E-05
   +9.90400000E-03  -5.31000000E-04  +1.97230000E-03  +1.46291000E-03  -5.11300000E-05
   -3.19400000E-05  -5.41300000E-05  +4.85600000E-05  +1.70500000E-05  -6.40300000E-05
   -1.12390000E-04  +3.28540000E-04  +3.09870000E-04  +1.10330000E-03  +1.05720000E-04
   -8.10300000E-04  -2.63500000E-05  +2.65840000E-04  -7.10400000E-05  -2.88650000E-04
   +1.85760000E-03  +1.22740000E-04  -1.53362400E-01  +7.97641000E-03  +1.69617530E-01
   -1.75240000E-04  -3.59620000E-04  +3.27800000E-04  +7.74460000E-04  -5.46450000E-04
   +1.54420000E-04  -1.12550000E-04  -4.39520000E-04  +1.85700000E-04  +1.40120000E-04
   +2.21550000E-04  -1.15100000E-04  +7.56900000E-05  -1.35170000E-04  +2.15200000E-05
   -1.85000000E-05  +7.12300000E-05  -3.63700000E-05  -6.38000000E-05  -1.82562000E-03
   +3.33190000E-04  -1.12990000E-04  -2.03250000E-04  +1.52180000E-04  -1.39780000E-04
   +1.64640000E-04  +1.49000000E-06  +9.15780000E-04  -1.57970000E-03  -4.73500000E-04
   +3.25630000E-04  +1.28680000E-04  +3.15130000E-04  -1.99610000E-04  +2.65000000E-05
   -3.38800000E-05  +1.22200000E-05  -2.83400000E-05  -1.84360000E-04  +1.30500000E-04
   +9.40700000E-05  +2.11100000E-05  +2.23740000E-04  -4.50000000E-07  +2.22450000E-04
   +6.86400000E-05  +1.36600000E-05  +4.19200000E-05  -2.34037770E-01  +1.17675380E-01
   +4.32354700E-02  +4.28400000E-04  +6.83900000E-05  -2.16230000E-04  -1.04300000E-05
   +3.27000000E-06  -6.77000000E-06  -2.06000000E-06  +1.53400000E-05  +3.80000000E-06
   +1.44200000E-05  -6.50400000E-05  -2.51000000E-06  +2.93700000E-05  +4.49100000E-05
   +2.47000000E-06  +2.66300000E-05  +8.77000000E-06  +1.21100000E-05  +2.50920490E-01
   +2.09051000E-03  -1.03490000E-04  -7.26730000E-04  -1.37981000E-03  -4.06794000E-03
   +3.58358000E-03  -9.23270000E-04  -6.92200000E-04  +5.80160000E-04  +2.40060000E-04
   +6.30200000E-05  -4.80600000E-05  -2.49450000E-04  +2.00490000E-04  +8.08700000E-05
   -1.79200000E-04  -4.68130000E-04  +1.24160000E-04  +2.29651200E-02  -1.77303800E-02
   -5.34446000E-03  +1.57630000E-04  +5.32830000E-04  -1.42169000E-03  +2.66650000E-04
   -1.83490000E-04  -7.54600000E-05  +1.52514000E-03  +5.80210000E-04  -1.15360000E-04
   -3.03460000E-04  -6.68400000E-05  -6.14950000E-04  +3.00990000E-04  +2.57900000E-05
   -5.57100000E-05  -3.35280000E-04  -1.26040000E-04  +1.58440000E-04  -2.68520000E-04
   -9.03000000E-05  +1.34500000E-05  -2.59310000E-04  +2.61550000E-04  -2.91300000E-05
   +2.89620000E-04  +1.76330000E-04  +1.02010000E-04  +1.14488640E-01  -1.17666240E-01
   -2.74813000E-02  -5.52410000E-04  -9.33000000E-06  +1.75850000E-04  -1.73200000E-05
   -3.33600000E-05  -3.16100000E-05  +6.88000000E-06  -2.42000000E-06  +1.15900000E-05
   +2.75800000E-05  +6.68900000E-05  +1.36990000E-04  +4.60000000E-06  -6.89800000E-05
   +1.07100000E-04  +2.83000000E-06  -1.04400000E-05  -8.10000000E-06  -1.26784890E-01
   +1.31182790E-01  -6.91320000E-04  +6.37060000E-04  +5.02610000E-04  +6.81270000E-04
   +2.42787000E-03  -1.48473000E-03  +5.24420000E-04  +1.27480000E-04  -1.42150000E-04
   -1.69640000E-04  +3.08500000E-05  +1.14110000E-04  -1.54500000E-05  -8.79600000E-05
   +1.58100000E-05  +1.53470000E-04  +1.68340000E-04  -1.46190000E-04  -1.40216800E-02
   +9.35884000E-03  +1.52188000E-03  -1.15897000E-03  +5.79160000E-04  +9.15130000E-04
   -1.52300000E-05  -1.08200000E-05  +1.27700000E-05  -3.96730000E-04  -1.71160000E-04
   +3.88990000E-04  +3.78000000E-04  -2.35000000E-06  -2.62270000E-04  -3.46240000E-04
   +2.52500000E-05  +4.64200000E-05  +8.63200000E-05  -1.83200000E-05  -1.69440000E-04
   +1.04930000E-04  +6.83300000E-05  +3.20400000E-05  -2.26340000E-04  -1.06700000E-04
   +1.79840000E-04  -9.07800000E-05  -3.63500000E-05  -1.94000000E-05  +4.39814300E-02
   -2.87911000E-02  -5.78045400E-02  -1.25900000E-04  -6.63800000E-05  +9.86000000E-06
   +8.01000000E-06  -9.72000000E-06  +1.16200000E-05  +1.57500000E-05  -2.07400000E-05
   +2.51000000E-06  +4.18200000E-05  -1.37000000E-06  +1.13630000E-04  +3.99600000E-05
   +6.05000000E-06  -7.70500000E-05  +2.20000000E-07  +1.72000000E-06  +9.60000000E-06
   -4.84998700E-02  +2.68073200E-02  +5.99339500E-02  +2.27400000E-05  +1.14600000E-05
   -4.46100000E-05  +4.27510000E-04  -4.60260000E-04  +2.04760000E-04  -4.22930000E-04
   +1.21144000E-03  +4.56300000E-05  +1.84700000E-05  -1.12410000E-04  +6.90600000E-05
   -3.69000000E-05  +9.52900000E-05  -5.09200000E-05  -1.25200000E-05  -3.09700000E-05
   +2.96500000E-05  +4.39400000E-04  +1.05317000E-03  +3.24840000E-04  +2.88980000E-04
   +5.59880000E-04  -1.90140000E-04  +5.60500000E-05  -7.44100000E-05  +1.34000000E-06
   +3.18980000E-04  -7.77930000E-04  -6.38000000E-05  +3.01730000E-04  +1.73450000E-04
   +5.23110000E-04  -2.67120000E-04  +3.28000000E-06  +4.57100000E-05  +2.63010000E-04
   +7.99200000E-05  -5.63500000E-05  +4.72900000E-05  -2.18600000E-05  -3.08000000E-05
   +5.41170000E-04  -1.18260000E-04  -1.37010000E-04  -2.17150000E-04  -1.11460000E-04
   -6.31800000E-05  -2.22195650E-01  -1.19583890E-01  -5.97645700E-02  -6.93000000E-06
   -5.88100000E-05  +1.73510000E-04  +1.66600000E-05  +2.07200000E-05  +2.31400000E-05
   -1.73400000E-05  +5.44000000E-06  -1.39900000E-05  +4.36000000E-06  -4.45300000E-05
   -1.83400000E-05  -5.85400000E-05  +6.30100000E-05  +1.39700000E-05  -3.98000000E-06
   -6.76000000E-06  +4.94000000E-06  -1.85445100E-02  -1.42703200E-02  -7.44488000E-03
   +2.41237550E-01  -2.24950000E-04  -3.85890000E-04  +4.14860000E-04  -5.42140000E-04
   +1.16348000E-03  -3.45080000E-04  +2.67820000E-04  -8.21820000E-04  +8.56400000E-05
   +2.30210000E-04  +1.55220000E-04  -1.59410000E-04  +6.43200000E-05  -4.78700000E-05
   -1.36300000E-05  -4.29400000E-05  +1.20650000E-04  -2.85800000E-05  -2.21693200E-02
   -1.49640700E-02  -7.38966000E-03  -3.27890000E-04  +9.68200000E-04  -1.71226000E-03
   -8.84900000E-05  +1.32250000E-04  +6.84000000E-06  +1.26230000E-04  -3.64354000E-03
   +3.52357000E-03  -4.14650000E-04  -1.16840000E-04  +9.78300000E-05  +8.14800000E-05
   +1.91530000E-04  +4.29000000E-05  +2.38960000E-04  +2.82970000E-04  +5.94800000E-04
   -6.58250000E-04  -4.30600000E-05  -5.85740000E-04  +2.45720000E-04  -4.55070000E-04
   -4.23370000E-04  -5.81020000E-04  -3.17950000E-04  -2.70920000E-04  -1.16689900E-01
   -1.30145180E-01  -3.91317500E-02  +4.99210000E-04  +2.25340000E-04  -2.26390000E-04
   +2.09800000E-05  +1.97300000E-05  +6.72300000E-05  -2.73800000E-05  -3.57800000E-05
   -3.84700000E-05  +5.23100000E-05  +3.52500000E-05  -4.16000000E-05  +2.58400000E-05
   -1.53260000E-04  +1.43830000E-04  -9.29300000E-05  +1.59700000E-05  -4.12300000E-05
   +1.43299200E-02  +1.07974900E-02  +5.59671000E-03  +1.29061290E-01  +1.40599490E-01
   +5.82100000E-05  -1.28820000E-04  -8.78700000E-05  -8.66700000E-05  -2.85380000E-04
   +1.91300000E-04  -5.14840000E-04  -1.50222000E-03  +7.15210000E-04  +1.43000000E-04
   +4.90270000E-04  -2.12440000E-04  -1.34060000E-04  -1.45890000E-04  +1.29770000E-04
   +7.92400000E-05  +1.98400000E-05  -4.39800000E-05  +1.42409000E-02  +9.84302000E-03
   +2.61958000E-03  +1.07491000E-03  +5.52950000E-04  +9.84550000E-04  -9.00000000E-08
   +9.66100000E-05  -4.45200000E-05  -6.36020000E-04  +2.27997000E-03  -1.20604000E-03
   -1.51800000E-04  -3.20320000E-04  -5.84300000E-05  +6.85440000E-04  -1.13260000E-04
   +8.20100000E-05  -3.23040000E-04  +5.11900000E-05  +3.45990000E-04  -1.52270000E-04
   -3.37060000E-04  -1.48900000E-05  +6.77700000E-04  +2.84170000E-04  +1.15980000E-04
   +2.52650000E-04  +1.63020000E-04  +6.42600000E-05  -5.74977700E-02  -3.92155800E-02
   -6.68559000E-02  +1.88610000E-04  +4.75800000E-05  -1.43340000E-04  +9.27000000E-06
   +8.10000000E-07  -3.21800000E-05  +2.27300000E-05  +1.01000000E-06  +1.15800000E-05
   -1.89020000E-04  +4.51920000E-04  +2.99400000E-05  +6.45000000E-06  +1.09390000E-04
   -5.33800000E-05  +2.50200000E-05  +3.17200000E-05  -1.11300000E-05  +5.46431000E-03
   +4.19070000E-03  +1.00608000E-03  +6.25413400E-02  +4.04059000E-02  +7.02329000E-02
   +2.37510000E-04  +2.33630000E-04  -1.58070000E-04  +3.53200000E-04  -3.34170000E-04
   -6.76470000E-04  -3.12400000E-05  +6.74920000E-04  -3.22600000E-04  -1.07820000E-04
   -1.96260000E-04  +1.32260000E-04  -2.51600000E-05  +9.83900000E-05  -4.76400000E-05
   -1.59700000E-05  -6.87100000E-05  +2.86400000E-05  -2.11633000E-03  +1.76330000E-04
   +4.54130000E-04  +4.76200000E-05  +1.17180000E-04  -9.56100000E-05  +7.82200000E-05
   -1.17160000E-04  +9.04000000E-06  +1.30300000E-04  +5.53880000E-04  +7.13550000E-04
   -7.29300000E-05  -1.02620000E-04  +3.57300000E-05  -3.20150000E-04  -1.60800000E-05
   -1.08840000E-04  +8.64000000E-06  -1.06170000E-04  -2.06850000E-04  +2.04300000E-04
   +6.84700000E-05  +1.51230000E-04  -3.09240000E-04  -6.81700000E-05  +5.42700000E-05
   +8.16600000E-05  +4.71300000E-05  +2.70600000E-05  -4.74463700E-02  +1.99475000E-03
   +1.14682600E-02  -3.87640000E-04  -1.11830000E-04  +1.31520000E-04  -1.66600000E-05
   -2.36600000E-05  -3.32000000E-06  +1.32700000E-05  -2.06200000E-05  +1.50200000E-05
   +1.86660000E-04  -3.20510000E-04  -2.27000000E-06  +3.85300000E-05  +3.35100000E-05
   -6.85300000E-05  +2.29000000E-06  +9.11000000E-06  -3.55000000E-06  -6.15700000E-04
   +3.94987000E-03  +2.68929000E-02  +1.61613000E-03  -3.94716000E-03  -2.56507000E-02
   +4.80995200E-02  -3.59180000E-04  -2.74720000E-04  +6.25300000E-05  -5.35110000E-04
   +1.66364000E-03  -1.36890000E-04  +5.23220000E-04  +3.13130000E-04  -2.22920000E-04
   +7.11100000E-05  -2.03850000E-04  +1.43600000E-05  +1.53270000E-04  +1.14150000E-04
   -1.20830000E-04  -1.31350000E-04  +8.53800000E-05  +7.44400000E-05  -1.63021000E-03
   +4.42427000E-03  +2.78800000E-02  -4.85380000E-04  -4.90663000E-03  +2.46153000E-03
   -7.54200000E-05  +2.02300000E-05  +2.09600000E-05  +1.18741000E-03  +1.05531000E-03
   +2.87910000E-04  -3.83170000E-04  -2.14800000E-05  +5.41220000E-04  -2.59000000E-04
   -1.51310000E-04  -2.34390000E-04  +1.11710000E-04  -1.04620000E-04  -3.97390000E-04
   +2.93870000E-04  +1.75450000E-04  +2.85940000E-04  -5.22500000E-04  +1.53300000E-05
   -2.12400000E-05  +1.47410000E-04  +5.33600000E-05  +6.48100000E-05  +2.02975000E-03
   -5.65156600E-02  -4.93335000E-02  +7.61100000E-05  -7.54000000E-06  -1.60610000E-04
   -2.14500000E-05  -4.62000000E-06  -1.83900000E-05  -1.89000000E-05  -3.34000000E-06
   +1.75300000E-05  -5.65800000E-05  -8.29050000E-04  -2.00890000E-04  +6.22100000E-05
   -2.46600000E-05  -7.26000000E-06  +8.12000000E-06  -1.80200000E-05  +9.04000000E-06
   -6.39940000E-04  -3.26989000E-03  -1.64216500E-02  +2.10487000E-03  -3.26419000E-03
   -1.67999200E-02  -2.51544000E-03  +6.12320700E-02  +1.42800000E-04  +5.22370000E-04
   -1.29600000E-05  +5.14320000E-04  -1.00209000E-03  +6.98810000E-04  +2.62050000E-04
   +2.75590000E-04  -2.52400000E-05  -2.86480000E-04  +4.48100000E-05  +1.54070000E-04
   -7.42800000E-05  -1.49840000E-04  +5.68700000E-05  +1.36450000E-04  -1.14070000E-04
   -6.97400000E-05  +4.77230000E-04  -4.03460000E-03  -1.54990000E-02  +4.53250000E-04
   +4.25209000E-03  -1.08831000E-03  +2.71000000E-06  -1.51500000E-05  +1.61600000E-05
   -1.13033000E-03  -4.70060000E-04  +5.02090000E-04  -7.81200000E-05  -6.60850000E-04
   -1.25480000E-04  +5.29540000E-04  +8.95700000E-05  +2.26490000E-04  -2.10200000E-04
   +1.76940000E-04  +4.14990000E-04  -3.78560000E-04  -2.19890000E-04  -1.74620000E-04
   +6.82850000E-04  +9.50100000E-05  -1.70280000E-04  +9.86000000E-06  +1.94900000E-05
   -3.46000000E-06  +1.10982300E-02  -4.69227900E-02  -3.08304360E-01  -1.55470000E-04
   -2.25500000E-05  +3.32540000E-04  +1.81800000E-05  +8.10000000E-06  -3.79000000E-06
   +3.51500000E-05  -5.14000000E-06  +8.75000000E-06  -1.72300000E-04  +1.20330000E-04
   +2.45540000E-04  -1.19660000E-04  -4.58000000E-06  +6.92700000E-05  +5.15000000E-06
   +1.57500000E-05  -1.11200000E-05  -5.18480000E-04  -7.74690000E-04  -4.32584000E-03
   +1.42132000E-03  -9.59680000E-04  -7.23400000E-03  -1.25307300E-02  +4.99836200E-02
   +3.34774390E-01  -1.61910000E-04  +1.47730000E-04  +5.82600000E-04  -4.64200000E-05
   -4.81290000E-04  +1.65150000E-04  -2.03830000E-04  -1.17610000E-04  +8.79900000E-05
   +1.19140000E-04  -2.47700000E-05  -6.13000000E-06  -5.71700000E-05  +6.91300000E-05
   +2.15100000E-05  -9.60300000E-05  +2.02300000E-05  -1.46700000E-05  -1.80812000E-03
   +1.66440000E-03  -1.16193000E-03  -5.02935400E-02  -2.02505000E-02  +1.50462700E-02
   +3.42900000E-05  -2.63600000E-05  -3.24600000E-05  +3.34750000E-04  +6.56850000E-04
   -1.72680000E-04  -4.31000000E-05  -3.36800000E-05  -5.40700000E-05  +1.26650000E-04
   +6.11400000E-05  +4.54500000E-05  -8.70600000E-05  -2.02300000E-05  +2.81000000E-05
   -1.05710000E-04  -4.19500000E-05  +1.93590000E-04  +1.21390000E-04  -1.11460000E-04
   -5.12390000E-04  +1.09340000E-04  +7.57300000E-05  +7.16100000E-05  +4.34400000E-05
   -1.37100000E-04  -4.75290000E-04  -1.45690000E-04  +3.92000000E-05  -3.50930000E-04
   -9.05000000E-06  -6.93000000E-06  -1.00200000E-05  +1.32000000E-05  +5.06000000E-06
   +1.58200000E-05  -9.84000000E-06  +2.49800000E-05  +4.65700000E-05  -9.39960000E-04
   +4.35930000E-04  -1.96710000E-04  -6.35000000E-06  +1.22100000E-05  -1.87000000E-05
   +2.52840000E-04  -3.65220000E-04  +1.86610000E-04  +2.23650000E-04  +3.74630000E-04
   -7.86100000E-05  +6.77510000E-04  +1.03740000E-04  -5.57300000E-05  +5.04761300E-02
   +3.55820000E-04  +4.16800000E-05  -3.90300000E-04  -1.58490000E-04  +5.52010000E-04
   +3.85960000E-04  +1.02820000E-04  -2.00000000E-07  +2.82400000E-05  -1.12980000E-04
   +7.48500000E-05  -1.76600000E-05  +6.16200000E-05  -1.26260000E-04  +2.26000000E-06
   -9.74200000E-05  +6.05300000E-05  +6.19200000E-05  +1.19358000E-03  +7.67738000E-03
   -5.60149000E-03  -2.02586800E-02  -2.24268370E-01  +1.26929210E-01  -1.13350000E-04
   +9.04400000E-05  +7.56000000E-06  -4.74600000E-05  +3.71430000E-04  +2.38260000E-04
   +2.43240000E-04  +1.04500000E-05  +5.20500000E-05  +3.44200000E-05  -1.55000000E-05
   -4.27000000E-05  -7.04300000E-05  -6.49200000E-05  +7.63700000E-05  +1.07530000E-04
   -3.67800000E-05  -2.43330000E-04  -4.93300000E-04  +4.52910000E-04  +3.83550000E-04
   +4.81700000E-05  +7.37000000E-06  -3.15000000E-05  -2.25630000E-04  +2.34720000E-04
   -1.05232000E-03  -1.08720000E-04  -1.92368000E-03  -8.37660000E-04  -7.13000000E-06
   -6.20000000E-06  -4.95000000E-06  +1.49000000E-05  +6.81000000E-06  +2.09000000E-06
   -3.48000000E-06  -2.11000000E-06  -5.39600000E-05  +9.00200000E-05  -2.82460000E-04
   -2.61430000E-04  +6.59000000E-06  +3.65600000E-05  +3.40000000E-06  -2.26570000E-04
   +1.49350000E-04  -2.29310000E-04  +2.42550000E-04  +1.10210000E-04  -2.04070000E-04
   -3.59000000E-05  +5.43270000E-04  -2.14530000E-04  +2.34560600E-02  +2.42816280E-01
   +2.12925000E-03  +6.91440000E-04  -1.63413000E-03  -9.72490000E-04  +3.25880000E-04
   +1.18996000E-03  +5.07930000E-04  +1.35540000E-04  -1.14180000E-04  -2.98160000E-04
   +8.23000000E-05  +4.80300000E-05  +7.01200000E-05  -1.51820000E-04  -6.58000000E-06
   -1.81040000E-04  -2.06600000E-04  +5.33800000E-05  +2.98597000E-03  +2.60005800E-02
   -1.62369400E-02  +1.54917500E-02  +1.24544190E-01  -1.38768650E-01  -9.83700000E-05
   +4.97500000E-05  +5.28400000E-05  +1.06709000E-03  +6.67840000E-04  +1.56254000E-03
   +7.70000000E-07  -4.92390000E-04  -2.19230000E-04  +2.76500000E-04  +1.32190000E-04
   +4.20700000E-05  -1.45730000E-04  +8.64600000E-05  +2.54330000E-04  -3.03850000E-04
   -1.87440000E-04  +1.22500000E-05  -1.83800000E-05  -1.92560000E-04  +3.71900000E-05
   +2.80800000E-05  +5.66000000E-06  +7.53000000E-06  -7.14900000E-05  -3.02678000E-03
   -6.42395000E-03  -1.07128000E-03  +1.97350000E-04  +1.76217000E-03  -9.66000000E-06
   +7.59000000E-06  -9.37000000E-06  -1.16500000E-05  +4.23900000E-05  -2.15500000E-05
   -1.63200000E-05  +8.64500000E-05  +4.18300000E-05  -4.80010000E-04  +1.91280000E-04
   +2.52300000E-05  -2.35700000E-05  +1.13000000E-06  -1.97900000E-05  -1.43220000E-04
   -1.11480000E-04  +1.47280000E-04  +5.00900000E-05  -2.28810000E-04  +2.59100000E-04
   -6.79500000E-05  +1.83033000E-03  -1.14916000E-03  -1.60256600E-02  -1.36265970E-01
   +1.52261090E-01  -1.18090000E-04  -4.38720000E-04  +2.98670000E-04  +9.08920000E-04
   +1.25380000E-03  +7.55560000E-04  +2.81640000E-04  -3.26930000E-04  +2.70600000E-05
   +6.59200000E-05  +4.45400000E-05  -1.06610000E-04  -3.08100000E-05  +3.48100000E-05
   -8.73000000E-06  +7.54000000E-06  -9.37000000E-06  -4.06000000E-06  -1.99426000E-03
   -9.10900000E-05  +8.30400000E-04  -2.63244550E-01  -1.01461200E-01  -4.45041200E-02
   +2.88700000E-05  -9.60000000E-06  -8.20000000E-07  +6.84010000E-04  -9.35000000E-06
   +1.51150000E-04  +2.85700000E-05  +4.45500000E-05  +2.78020000E-04  -6.89900000E-05
   -3.03000000E-05  -1.24720000E-04  +1.17400000E-04  +7.11800000E-05  +3.23100000E-05
   +1.72090000E-04  -7.74600000E-05  -2.89560000E-04  -2.22220000E-04  +4.11400000E-05
   +4.44340000E-04  -1.82840000E-04  -1.17520000E-04  -1.16280000E-04  -1.34400000E-05
   +5.41800000E-05  +5.05620000E-04  +2.91090000E-04  +1.75990000E-04  -1.75850000E-04
   +1.72600000E-05  +1.41600000E-05  +1.84700000E-05  -2.82000000E-05  -3.03000000E-06
   -2.11100000E-05  +7.18800000E-05  -4.06300000E-05  -6.89000000E-05  +2.64320000E-04
   -3.36800000E-05  -4.97480000E-04  -8.17000000E-06  -5.14000000E-06  +1.29400000E-05
   +3.91300000E-05  -1.31420000E-04  +1.00400000E-05  +3.42300000E-04  +4.48800000E-04
   -3.25800000E-04  +3.10000000E-04  +2.02870000E-04  +8.46300000E-05  -1.61779000E-03
   +5.85300000E-05  -1.74290000E-04  +2.82882310E-01  -7.60060000E-04  -5.51580000E-04
   +6.61050000E-04  -7.29870000E-04  +1.87850000E-04  -3.42700000E-05  +2.90440000E-04
   +2.62830000E-04  -1.49290000E-04  +9.37900000E-05  -8.55000000E-06  -1.98300000E-05
   +9.98000000E-05  -1.03570000E-04  -5.85300000E-05  +1.17800000E-04  -4.42800000E-05
   +2.92600000E-05  -6.98766000E-03  -5.12379000E-03  -2.08270000E-03  -1.00699280E-01
   -9.38391600E-02  -1.95207600E-02  -1.03650000E-04  +1.06810000E-04  +4.23700000E-05
   +6.52850000E-04  +1.75410000E-04  -1.77800000E-03  -5.81670000E-04  +1.92680000E-04
   +5.87500000E-05  -9.76700000E-05  -1.63250000E-04  -9.70600000E-05  +2.32770000E-04
   +3.02400000E-05  -4.31300000E-05  -3.43100000E-05  +1.39420000E-04  +7.72900000E-05
   +3.17170000E-04  +2.44890000E-04  -2.30740000E-04  -1.78770000E-04  -8.32800000E-05
   -3.95700000E-05  +8.62010000E-04  +2.35760000E-04  +8.57780000E-04  +6.63130000E-04
   -3.77960000E-04  -7.06000000E-04  +2.32600000E-05  +1.24700000E-05  +2.06800000E-05
   -3.68600000E-05  -7.60800000E-05  -2.70000000E-06  +3.60000000E-07  +4.03800000E-05
   -4.10400000E-05  +3.50000000E-05  -3.10550000E-04  +1.88170000E-04  -2.66500000E-05
   +1.30300000E-05  -1.19700000E-05  +7.88700000E-05  +4.56400000E-05  +5.45600000E-05
   -5.10200000E-05  +2.89410000E-04  +3.68300000E-04  +9.72800000E-05  -7.88600000E-05
   -5.98100000E-05  -2.33935400E-02  -1.00527200E-02  -5.62973000E-03  +1.10147190E-01
   +9.86025000E-02  -5.78800000E-05  -4.48740000E-04  +3.25890000E-04  -1.38891000E-03
   +6.20620000E-04  +9.89820000E-04  +2.86620000E-04  +3.93900000E-05  +9.08400000E-05
   +8.09400000E-05  +6.91400000E-05  -1.12120000E-04  +1.50290000E-04  -1.04870000E-04
   -5.92500000E-05  -1.62550000E-04  -1.75900000E-05  +6.11200000E-05  -2.86801400E-02
   -1.39895900E-02  -8.62167000E-03  -4.15211800E-02  -1.86758700E-02  -5.37760200E-02
   -2.13550000E-04  +1.86240000E-04  +3.10800000E-05  +1.50688000E-03  -7.77360000E-04
   -5.99515000E-03  -1.93690000E-03  -7.28590000E-04  -3.26700000E-05  +8.71300000E-05
   -2.47700000E-04  -3.96860000E-04  +2.20660000E-04  +1.48390000E-04  +4.47800000E-05
   -2.47220000E-04  -2.83300000E-05  +1.89370000E-04  +1.05552000E-03  -2.03000000E-04
   -5.97070000E-04  -2.33310000E-04  -9.46700000E-05  -2.87800000E-05  -1.07972000E-03
   -1.20530000E-03  +1.27964000E-03  +3.49130000E-04  +3.47470000E-04  +1.85300000E-05
   +3.29900000E-05  +2.10500000E-05  +2.45000000E-05  -1.53650000E-04  -7.89500000E-05
   -6.51000000E-05  +3.94000000E-06  +5.04900000E-05  -1.07900000E-05  +1.19500000E-05
   +3.11620000E-04  +4.52920000E-04  -4.05700000E-05  -3.09200000E-05  -8.35000000E-06
   +1.09730000E-04  +3.70600000E-05  -4.95800000E-05  +3.73280000E-04  +7.61710000E-04
   -4.37340000E-04  +3.69600000E-04  -1.80000000E-07  +3.10480000E-04  +1.76566300E-02
   +6.68169000E-03  +3.58389000E-03  +4.69531400E-02  +2.33451100E-02  +6.25155000E-02
   -2.84870000E-04  -6.52010000E-04  +5.72760000E-04  +4.43960000E-04  +4.63910000E-04
   +6.93360000E-04  +7.15260000E-04  +3.65430000E-04  -1.96290000E-04  -8.99300000E-05
   +1.24370000E-04  -3.56200000E-05  +1.98510000E-04  -2.21170000E-04  -5.49200000E-05
   -7.65900000E-05  -2.15500000E-05  +2.22300000E-05  +8.80090000E-04  -1.80720000E-03
   -9.24940000E-04  -1.81429010E-01  +1.25988340E-01  +4.43036300E-02  -2.41130000E-04
   +2.01860000E-04  +5.83900000E-05  -8.10000000E-06  -9.68200000E-05  +3.71370000E-04
   +8.31200000E-05  +5.23100000E-05  +1.62500000E-05  +7.42800000E-05  +3.35300000E-05
   +6.97000000E-06  -1.91850000E-04  +1.03700000E-05  +2.74700000E-05  +9.14300000E-05
   -8.27400000E-05  -2.86790000E-04  -1.05103000E-03  -9.62890000E-04  +5.73900000E-05
   +9.77100000E-05  +2.73900000E-05  -3.77000000E-06  +3.03810000E-04  -1.12480000E-04
   -3.29430000E-04  +3.69620000E-04  -3.95000000E-06  -3.87090000E-04  -1.93100000E-05
   -6.65000000E-06  -1.19100000E-05  +1.64200000E-05  +1.60300000E-05  +6.99000000E-06
   -9.86000000E-06  +5.50000000E-06  -5.90000000E-07  -1.54313000E-03  -1.76932000E-03
   -1.04883000E-03  +2.35300000E-05  -1.67100000E-05  +1.92800000E-05  +2.80130000E-04
   -1.83550000E-04  +2.55570000E-04  -2.46210000E-04  +7.84500000E-05  +1.08870000E-04
   +1.24070000E-04  -2.74590000E-04  -6.98300000E-05  +2.67712000E-03  -3.73893000E-03
   -1.55422000E-03  -1.88871800E-02  +1.99383300E-02  +6.59277000E-03  +1.97763160E-01
   -2.07920000E-04  -8.11100000E-05  +3.27510000E-04  -2.30700000E-04  +7.89840000E-04
   -1.90674000E-03  -5.18970000E-04  -4.44080000E-04  +1.08690000E-04  +4.17350000E-04
   -2.81810000E-04  +5.76500000E-05  -1.44850000E-04  +4.10740000E-04  -9.32500000E-05
   -1.93500000E-05  +9.48900000E-05  +8.70100000E-05  +5.36874000E-03  -5.83145000E-03
   -9.60220000E-04  +1.25223030E-01  -1.65039000E-01  -4.10501700E-02  +2.64830000E-04
   -2.48360000E-04  -6.54000000E-05  +5.31020000E-04  +2.92120000E-04  +1.22610000E-04
   -2.69870000E-04  -4.12300000E-05  -6.42900000E-05  +8.09000000E-05  +7.39900000E-05
   +1.06250000E-04  +3.09700000E-05  -3.88200000E-05  -1.82200000E-05  -3.00930000E-04
   +1.70020000E-04  +5.16690000E-04  +4.81730000E-04  -2.07600000E-04  -1.18069000E-03
   +6.72300000E-05  +7.99300000E-05  +1.19390000E-04  -4.34490000E-04  +3.91650000E-04
   +1.24121000E-03  -1.23410000E-04  -1.49070000E-04  -7.02380000E-04  +1.50000000E-07
   -6.63000000E-06  -2.99000000E-06  -2.11000000E-06  -5.12000000E-06  +1.39900000E-05
   +1.49700000E-05  +2.21300000E-05  +1.23600000E-04  -1.55451000E-03  -7.74230000E-04
   +2.52040000E-04  -2.27300000E-05  -1.56100000E-05  -3.09100000E-05  -5.40300000E-05
   +5.35960000E-04  +1.23440000E-04  -1.21980000E-04  -6.83000000E-06  -1.37020000E-04
   -2.30110000E-04  +1.55900000E-05  -4.64000000E-05  +1.83140400E-02  -1.55425200E-02
   -7.15702000E-03  -1.00170400E-02  +9.87534000E-03  +3.93508000E-03  -1.37248310E-01
   +1.75841500E-01  +1.56504000E-03  +7.04900000E-04  -1.06713000E-03  -3.77310000E-04
   -9.56980000E-04  -5.88898000E-03  -4.94030000E-04  -1.23382000E-03  +2.68510000E-04
   +6.09050000E-04  -3.92690000E-04  +3.03820000E-04  -2.10980000E-04  +5.92520000E-04
   -1.92800000E-04  -3.91200000E-05  +1.68590000E-04  +1.90840000E-04  +2.31884700E-02
   -1.99549200E-02  -7.60315000E-03  +4.33480300E-02  -3.98709100E-02  -6.20004600E-02
   +5.41050000E-04  -4.87250000E-04  -8.86500000E-05  +4.28310000E-04  +3.30800000E-04
   +9.28470000E-04  -9.07700000E-05  +8.21300000E-05  -2.34060000E-04  +1.68580000E-04
   +9.88200000E-05  +5.12400000E-05  -1.47090000E-04  -3.68500000E-05  +1.39230000E-04
   -2.13580000E-04  -8.72000000E-06  +1.57000000E-05  -2.97510000E-04  +8.09000000E-05
   +5.94800000E-05  +1.05480000E-04  +6.57700000E-05  +4.07000000E-05  +9.39470000E-04
   -1.24460000E-03  +1.39889000E-03  -1.17183000E-03  +6.97600000E-05  +9.43970000E-04
   -1.06200000E-05  -1.64900000E-05  -1.20100000E-05  +1.86400000E-05  -1.52400000E-05
   +1.23700000E-05  +4.81700000E-05  -2.15400000E-05  +8.46600000E-05  -6.08900000E-04
   -4.93090000E-04  +3.61920000E-04  +8.20000000E-07  -1.20100000E-05  -2.40000000E-06
   -5.36890000E-04  +6.10500000E-04  -6.05480000E-04  +8.43600000E-05  +1.78840000E-04
   -6.84800000E-05  -2.97200000E-04  +5.14900000E-05  +4.04700000E-04  -1.45156600E-02
   +1.13901200E-02  +4.79518000E-03  -3.92696000E-03  +4.50148000E-03  +6.48920000E-04
   -4.82402100E-02  +4.59072000E-02  +6.75370200E-02  -1.51210000E-04  +1.28140000E-04
   -9.24930000E-04  -8.55140000E-04  +4.05529000E-03  +1.41262000E-03  -1.57873800E-02
   -8.94691000E-03  +1.11979000E-02  -2.26662000E-01  -7.57665200E-02  +1.27729530E-01
   +2.98318000E-03  +2.42367000E-03  +4.07250000E-04  +1.57815000E-03  +8.62870000E-04
   +1.40240000E-03  +3.45000000E-06  -6.29180000E-04  +6.89060000E-04  -2.13950000E-04
   +1.44970000E-04  -4.33800000E-05  -1.55140000E-04  -7.28200000E-04  -1.44317000E-03
   +1.76500000E-05  +1.40260000E-04  +8.44000000E-05  -1.73100000E-05  +6.12000000E-06
   +3.45000000E-06  -2.21800000E-05  -1.58200000E-05  +4.38000000E-06  +3.66900000E-05
   +1.64400000E-05  +1.08100000E-05  -6.62000000E-06  -1.54800000E-05  +1.35000000E-06
   -4.07300000E-05  -2.93900000E-05  -3.84700000E-05  -4.64100000E-05  -2.36500000E-05
   -2.12400000E-05  +1.61700000E-05  -8.43400000E-05  +3.39000000E-06  +2.40320000E-04
   -6.11000000E-05  -3.17400000E-05  +2.27000000E-06  +3.06000000E-06  +6.77000000E-06
   -1.19000000E-05  -5.09000000E-06  -6.15000000E-06  +2.20000000E-07  +1.02600000E-05
   +2.00000000E-05  +1.04900000E-05  +9.20000000E-06  -3.79000000E-06  -7.17000000E-06
   -2.73000000E-06  -1.96000000E-06  +1.48000000E-06  +3.82400000E-05  -9.83000000E-06
   -1.75200000E-05  +7.17000000E-06  +3.63400000E-05  -1.54600000E-05  +6.41000000E-06
   -2.02500000E-05  -3.40000000E-06  -1.87000000E-06  -1.15000000E-06  +1.52300000E-05
   -5.63000000E-06  -4.53000000E-06  -1.35600000E-05  +4.17100000E-05  +9.60000000E-05
   +2.39187960E-01  +6.61100000E-04  -1.90931000E-03  -3.28190000E-04  +3.90956000E-03
   -1.24278000E-03  +2.28350000E-04  +1.43289500E-02  +9.67536000E-03  -1.07562900E-02
   -7.40237600E-02  -8.92767900E-02  +5.94958500E-02  -2.46579900E-02  -3.92486000E-03
   +1.59787300E-02  +1.35550000E-03  -4.55307000E-03  +2.80104000E-03  +5.11570000E-04
   +6.41790000E-04  -1.06900000E-05  +3.79600000E-05  -8.72000000E-06  +6.08300000E-05
   -4.92630000E-04  +1.87651000E-03  -1.83251000E-03  +1.58000000E-04  -2.04940000E-04
   -1.20660000E-04  +1.02100000E-05  +1.03000000E-05  +1.24000000E-06  -2.66000000E-06
   +9.30000000E-07  +1.43000000E-06  -8.22000000E-06  -1.48200000E-05  -2.17200000E-05
   +2.64600000E-05  +2.87900000E-05  -4.10000000E-07  +2.52400000E-05  +2.93100000E-05
   +4.17500000E-05  +2.40900000E-05  +1.23100000E-05  +9.83000000E-06  -2.47400000E-05
   +1.03170000E-04  -2.01600000E-05  -6.81300000E-05  +2.64160000E-04  -9.36000000E-06
   -1.15000000E-06  -1.02000000E-06  -8.40000000E-07  -2.60000000E-07  +1.55000000E-06
   +2.52000000E-06  -2.26000000E-06  +3.27000000E-06  +4.77000000E-06  +1.07000000E-06
   -9.26000000E-06  -2.00000000E-06  +6.33000000E-06  +6.05000000E-06  +4.60000000E-07
   -2.49200000E-05  -3.27200000E-05  +2.14000000E-05  +2.21900000E-05  -4.73800000E-05
   -4.75700000E-05  +2.23100000E-05  +1.12400000E-05  +3.24700000E-05  -6.51000000E-06
   -4.37000000E-06  -2.35000000E-06  -1.34100000E-05  +2.92000000E-06  -1.68000000E-05
   +4.62000000E-06  -1.13100000E-05  -2.80200000E-05  +7.94736900E-02  +8.85183100E-02
   -8.93400000E-04  -7.54030000E-04  -1.20540000E-03  +1.58032000E-03  +9.66140000E-04
   +3.59518000E-03  +1.94071000E-03  +5.93170000E-04  -1.04990000E-03  +1.28206470E-01
   +6.05704200E-02  -1.17106180E-01  +1.04603800E-02  +2.45370000E-03  -6.67570000E-04
   +5.45350000E-04  +2.90664000E-03  +3.49776000E-03  +3.75310000E-04  +3.55950000E-04
   +7.98720000E-04  -1.12420000E-04  +1.28000000E-04  +3.46300000E-05  -1.74954000E-03
   -1.53416000E-03  -2.11773000E-03  +2.30140000E-04  -1.81190000E-04  -1.00420000E-04
   +1.06600000E-05  +7.55000000E-06  -1.44800000E-05  -9.83000000E-06  -9.94000000E-06
   -5.22000000E-06  -1.86100000E-05  -2.56900000E-05  -3.12300000E-05  +3.25000000E-05
   +2.74800000E-05  +9.52000000E-06  -1.23000000E-06  +5.93000000E-06  +5.40800000E-05
   +3.48000000E-05  +1.78200000E-05  +1.15000000E-05  +1.39100000E-05  -2.60000000E-07
   -4.01100000E-05  +1.29060000E-04  -4.50000000E-05  +1.96910000E-04  -5.45000000E-06
   -2.56000000E-06  -1.49000000E-06  -4.94000000E-06  +5.00000000E-08  +9.50000000E-07
   -1.25200000E-05  +9.14000000E-06  +5.80000000E-06  +6.36000000E-06  -2.52000000E-06
   -4.85000000E-06  +4.17000000E-06  +7.87000000E-06  -1.39000000E-06  +4.20000000E-06
   -1.06700000E-05  +1.43400000E-05  +3.10000000E-06  -2.05000000E-06  +2.12000000E-06
   -6.91000000E-06  +1.72300000E-05  -3.18000000E-06  -9.43000000E-06  -4.76000000E-06
   -9.91000000E-06  +1.27000000E-06  -3.30000000E-06  -9.14000000E-06  -9.30000000E-07
   +2.46500000E-05  +4.51600000E-05  -1.39581900E-01  -6.44853700E-02  +1.16609650E-01
   +6.24404000E-03  +2.36458700E-02  -9.11790000E-03  -2.90515000E-03  +3.08911000E-03
   +2.66848000E-03  -1.76798000E-03  +2.79640000E-04  +3.63970000E-04  -2.79447000E-03
   -1.06355000E-03  +4.18470000E-03  +3.69059000E-03  -2.29004000E-02  +8.05488000E-03
   -5.56348100E-02  -8.19592000E-03  +1.45332000E-02  +5.77380000E-04  +9.26410000E-04
   -6.07480000E-04  -9.04000000E-06  -2.72200000E-05  -1.09850000E-04  +1.72102000E-03
   -1.57253000E-03  -2.30816000E-03  +2.31340000E-04  +5.20000000E-05  +9.87100000E-05
   -1.71600000E-05  -5.87300000E-05  -2.81800000E-05  +1.25000000E-06  -2.68600000E-05
   -5.84000000E-06  -2.89000000E-06  +2.08800000E-05  +2.46100000E-05  -3.51100000E-05
   -3.25000000E-05  -9.42000000E-06  -3.18000000E-06  -5.89800000E-05  +1.68000000E-05
   -2.30300000E-05  -2.99800000E-05  -8.75000000E-06  -3.70990000E-04  +1.20290000E-04
   +1.57940000E-04  +7.89020000E-04  -1.07573000E-03  -1.67904000E-03  -7.24000000E-06
   +1.30000000E-05  -4.11000000E-06  -1.31400000E-05  +6.25000000E-06  -1.49500000E-05
   +1.00900000E-05  +2.65300000E-05  +1.22200000E-05  +6.57000000E-06  +1.84700000E-05
   -4.97000000E-06  -9.64000000E-06  +3.06000000E-06  -3.20000000E-06  -7.09000000E-06
   +1.34190000E-04  -8.54000000E-05  -2.86000000E-06  -1.83800000E-05  +1.83400000E-05
   +1.01000000E-05  -8.52000000E-06  -2.37700000E-05  +1.84500000E-05  +3.50000000E-06
   +4.60600000E-05  -8.07000000E-06  -2.26200000E-05  +8.96000000E-06  -2.26400000E-05
   +7.20000000E-06  +3.84400000E-05  +2.15170000E-04  -1.07324000E-03  +4.16130000E-04
   +5.11847100E-02  -3.85891000E-03  -1.51965600E-02  +9.08812000E-03  +3.64508000E-03
   -2.50680000E-04  +5.89000000E-06  +2.34580000E-04  +9.94210000E-04  -7.50610000E-04
   -1.19289000E-03  +1.46191000E-03  +1.84294000E-03  +4.68856000E-03  -7.25758000E-03
   +1.63751000E-03  -6.22815000E-03  -3.01697100E-01  +9.91381800E-02  -4.96260000E-04
   -3.58750000E-04  +5.37650000E-04  +6.22000000E-05  -4.59100000E-05  +8.42400000E-05
   -9.01730000E-04  +2.44167000E-03  -1.95225000E-03  -1.63950000E-04  -4.51000000E-05
   -1.10170000E-04  +6.44000000E-06  +4.57100000E-05  +3.27400000E-05  +8.62000000E-06
   +8.60000000E-07  -1.16400000E-05  -4.09100000E-05  -3.53600000E-05  -3.63900000E-05
   +4.12400000E-05  +3.14900000E-05  +1.92500000E-05  +7.31000000E-06  +5.03200000E-05
   +4.56000000E-06  +6.78900000E-05  +4.02600000E-05  +2.23600000E-05  +2.98470000E-04
   -1.21420000E-04  -1.45870000E-04  -1.73820000E-03  +1.07124000E-03  -9.85810000E-04
   -6.63000000E-06  -9.58000000E-06  -4.36000000E-06  +7.76000000E-06  -2.40000000E-07
   +9.62000000E-06  -1.07200000E-05  -1.32400000E-05  -2.73100000E-05  -4.96000000E-06
   -1.39200000E-05  +1.26000000E-06  +9.72000000E-06  +1.18000000E-06  +1.58000000E-06
   +1.15300000E-05  -1.17750000E-04  +3.30700000E-05  -1.57200000E-05  +1.02900000E-05
   +1.06800000E-05  -1.54600000E-05  +1.84500000E-05  -1.27400000E-05  +1.39900000E-05
   +1.90800000E-05  -3.07500000E-05  -6.82000000E-06  +1.09000000E-06  +1.20400000E-05
   +1.60000000E-05  -1.94200000E-05  -6.08600000E-05  +1.01160000E-04  -2.93000000E-04
   +1.25120000E-04  +7.13404000E-03  +3.19452770E-01  +1.35607000E-03  -3.98150000E-03
   +5.70928000E-03  +2.13002000E-03  +4.86230000E-04  +3.52432000E-03  +1.31320000E-04
   -8.04480000E-04  -5.27980000E-04  +4.45315000E-03  +1.46333000E-03  +2.23981000E-03
   -1.46700000E-03  +1.51287500E-02  -1.34419000E-03  +1.32084100E-02  +1.00009040E-01
   -7.31332400E-02  +1.33960000E-04  -1.01110000E-04  +2.25240000E-04  -2.51000000E-06
   -3.81300000E-05  +2.12700000E-05  -2.66927000E-03  -1.58362000E-03  -2.42041000E-03
   -4.33200000E-05  -5.63000000E-06  -7.87000000E-06  -7.14000000E-06  -1.63000000E-06
   +2.37600000E-05  -1.62400000E-05  -3.25200000E-05  +7.29000000E-06  +5.73000000E-06
   +6.72000000E-06  +7.92000000E-06  +2.01200000E-05  +2.07000000E-06  -9.67000000E-06
   -3.11400000E-05  +3.39500000E-05  -2.41100000E-05  -1.75200000E-05  -2.11500000E-05
   -1.44100000E-05  +3.61400000E-05  -9.10700000E-05  -3.29500000E-05  -1.41623000E-03
   -1.40170000E-03  -2.71971000E-03  -8.64000000E-06  +1.05200000E-05  +2.11000000E-06
   -1.57900000E-05  +8.06000000E-06  -1.53200000E-05  +1.04200000E-05  +3.01100000E-05
   -6.10000000E-06  +9.62000000E-06  -6.93000000E-06  -5.92000000E-06  +1.62000000E-06
   -2.06000000E-06  -4.00000000E-08  -1.92000000E-05  -4.17900000E-05  -2.57800000E-05
   -8.30000000E-06  -2.42900000E-05  +4.88000000E-06  +1.13100000E-05  +2.21000000E-05
   -3.61000000E-05  +2.97400000E-05  +1.78100000E-05  -1.05900000E-05  -1.47800000E-05
   -2.14300000E-05  +2.17000000E-06  -1.14700000E-05  +9.90000000E-06  -5.28000000E-06
   +2.65000000E-06  +7.46520000E-04  +3.53400000E-05  -1.67230100E-02  -1.09378110E-01
   +6.87883100E-02  -1.45823000E-03  +2.29220000E-04  +1.29110000E-04  +3.40500000E-05
   -4.97290000E-04  +8.61900000E-05  +1.08667000E-03  +9.19340000E-04  -1.99700000E-05
   -4.56960000E-03  +2.95013000E-03  +2.36063000E-03  +1.14881000E-03  +3.98957800E-02
   -1.63226100E-02  +1.19582000E-03  +1.51983000E-03  -1.64960000E-03  -1.19650000E-04
   -3.11900000E-05  +1.11820000E-04  +1.40700000E-05  +1.82200000E-05  -6.63000000E-06
   -5.12293200E-02  -9.12963500E-02  +5.64721700E-02  +2.29600000E-05  -6.59900000E-05
   +1.41800000E-05  -1.18900000E-05  -3.73100000E-05  -2.00000000E-07  +4.28500000E-05
   -1.85000000E-05  -3.08200000E-05  -1.33670000E-04  -5.10900000E-05  -3.45800000E-05
   +6.94000000E-06  +5.99000000E-06  +2.56300000E-05  -1.48000000E-05  -2.31000000E-05
   +4.41600000E-05  +1.37020000E-04  +5.63100000E-05  +4.64900000E-05  +6.43900000E-05
   -1.51900000E-05  -2.50200000E-05  +8.32910000E-04  -1.71410000E-04  -2.79770000E-04
   -2.85000000E-05  -5.14000000E-06  -1.73800000E-05  -4.53000000E-06  +1.25700000E-05
   +3.90000000E-07  -1.26200000E-05  +2.20800000E-05  -2.73800000E-05  -8.39000000E-06
   +7.41000000E-06  -3.54000000E-06  +5.02000000E-06  +4.68000000E-06  -3.92000000E-06
   +1.08300000E-05  -3.44400000E-05  +6.85000000E-06  -9.12000000E-06  +3.63000000E-06
   -7.29000000E-06  -3.05000000E-06  +9.83000000E-06  -3.77000000E-06  -9.32000000E-06
   +1.88300000E-05  +2.94300000E-05  -1.08200000E-05  -1.07000000E-06  +1.28800000E-05
   +1.85100000E-05  -2.07700000E-05  -7.40000000E-06  -1.09680000E-04  -6.54800000E-05
   -2.86160000E-04  -9.41490000E-04  -1.42098000E-03  +1.26517000E-03  +5.43303100E-02
   +4.37960000E-04  -1.20469000E-03  -1.95160000E-04  -2.25620000E-04  +7.04270000E-04
   -2.62510000E-04  -2.96120000E-04  -8.65290000E-04  +1.06202000E-03  +4.39877000E-03
   +8.34230000E-04  -1.51816000E-03  -3.07448000E-03  -3.08519100E-02  +1.20573400E-02
   -3.92221000E-03  +5.16397000E-03  -3.42890000E-04  +2.72470000E-04  -1.37030000E-04
   +6.84500000E-05  -1.42210000E-04  +1.01080000E-04  -2.21900000E-05  -4.51801900E-02
   -4.36679620E-01  +1.80707850E-01  -1.55500000E-05  +1.34940000E-04  +1.78500000E-05
   -5.50000000E-06  +6.45000000E-06  -1.27400000E-05  -4.86100000E-05  +7.38000000E-06
   +4.57600000E-05  +1.60270000E-04  +8.17300000E-05  +7.40400000E-05  -3.27200000E-05
   -3.90400000E-05  -4.72700000E-05  +9.81000000E-06  +5.94000000E-06  -5.57200000E-05
   -1.91330000E-04  -1.07160000E-04  -6.90400000E-05  -7.79300000E-05  -9.45000000E-06
   +2.84100000E-05  -8.08470000E-04  +1.14400000E-04  +3.10530000E-04  +2.31200000E-05
   +2.62100000E-05  +1.88400000E-05  -1.19500000E-05  -4.69000000E-06  -1.89300000E-05
   +2.74200000E-05  +5.74000000E-06  +5.52400000E-05  +1.78900000E-05  +2.82000000E-06
   -3.62000000E-06  -1.18200000E-05  -3.60000000E-06  +2.21000000E-06  -2.22300000E-05
   +4.39200000E-05  -2.83000000E-06  +8.00000000E-06  -1.80300000E-05  +4.63000000E-06
   +1.17300000E-05  -1.09300000E-05  -1.72000000E-06  +1.69300000E-05  -1.61600000E-05
   -2.25900000E-05  +1.10000000E-06  -2.87100000E-05  -2.91800000E-05  -4.17700000E-05
   +4.48200000E-05  +6.65200000E-05  -1.51380000E-04  +3.00190000E-04  -3.23870000E-04
   +9.60030000E-04  -4.83900000E-05  -2.14880000E-04  +4.77049100E-02  +4.62615390E-01
   +2.51700000E-05  -1.33010000E-04  -1.08990000E-03  +3.60100000E-05  -5.01000000E-06
   +5.96800000E-05  +5.19100000E-04  +4.71680000E-04  +1.24848000E-03  +1.77194000E-03
   -8.09800000E-04  +1.90489000E-03  -4.43630000E-04  -8.99407000E-03  +1.27435000E-03
   +2.75230000E-04  -2.98019000E-03  -1.84720000E-04  +8.30000000E-07  +7.88900000E-05
   -2.65500000E-05  +4.81800000E-05  -4.67300000E-05  +1.99400000E-05  +3.94958600E-02
   +2.03261040E-01  -9.80453500E-02  +2.41400000E-05  -1.51400000E-05  -2.30900000E-05
   +1.81000000E-06  +3.32000000E-06  +3.33600000E-05  -6.99000000E-06  -1.20100000E-05
   +1.37000000E-06  +8.92000000E-06  +8.30000000E-07  +1.41000000E-06  +1.40600000E-05
   +1.24300000E-05  -5.69000000E-06  -1.29500000E-05  +3.53000000E-06  -5.64000000E-06
   -6.85000000E-06  -8.26000000E-06  -1.07100000E-05  +6.80000000E-07  +7.73000000E-06
   -7.13000000E-06  -9.51000000E-05  +4.20400000E-05  +7.56700000E-05  -4.92000000E-06
   +5.33000000E-06  +5.19000000E-06  -1.19600000E-05  +1.79000000E-06  -6.86000000E-06
   +2.23000000E-06  +1.81700000E-05  -6.10000000E-06  +6.58000000E-06  -8.47000000E-06
   -3.83000000E-06  +2.91000000E-06  -7.50000000E-07  -2.00000000E-08  +1.85000000E-06
   -4.01000000E-06  -1.44000000E-06  -2.98000000E-06  -4.76000000E-06  +1.10000000E-07
   +2.27000000E-06  +3.69000000E-06  -7.50000000E-06  +1.59300000E-05  +8.64000000E-06
   -5.88000000E-06  -4.47000000E-06  -1.08000000E-05  +9.98000000E-06  +2.70000000E-06
   -2.64000000E-06  -3.19400000E-05  -2.59750000E-04  -3.66190000E-04  -4.33590000E-04
   +4.20010000E-04  +9.35100000E-04  +1.80060000E-04  -4.17910400E-02  -1.91337870E-01
   +9.51534200E-02  -3.85357600E-02  +1.34927400E-02  +1.94643000E-03  +2.11328000E-03
   +2.23306000E-03  -2.10826000E-03  -9.34100000E-04  +1.29810000E-04  +5.26970000E-04
   +7.27360000E-04  +3.01940000E-04  -4.90360000E-04  -9.51780000E-04  +1.15915000E-03
   +1.05098000E-03  +1.45630000E-04  -3.31054000E-03  +7.86740000E-04  +2.14884000E-03
   -1.23080000E-03  +5.35810000E-04  -7.55290000E-04  -4.47150000E-04  +3.28280000E-04
   +4.41900000E-04  -4.40530000E-04  -7.48600000E-05  +4.12177000E-03  +3.65940000E-04
   +1.36692000E-03  -1.57420000E-03  -1.11789000E-03  -3.35048000E-03  +2.00113000E-03
   +6.96370000E-04  -6.47200000E-05  -2.08056000E-03  -2.22570000E-04  +9.07890000E-04
   -1.85104000E-03  -1.30549000E-03  -7.70850000E-04  -1.39827000E-03  -2.30600000E-05
   +2.17884000E-03  +1.16827000E-03  +5.55500000E-04  +3.71040000E-04  -8.68570000E-04
   -3.55690000E-04  -1.33760000E-04  -3.59897800E-01  +1.88042580E-01  -3.93318800E-02
   -1.42420000E-04  -1.11640000E-04  -1.44270000E-04  +6.92800000E-05  +2.49500000E-05
   +7.30800000E-05  +9.71000000E-06  +9.05700000E-05  +4.16450000E-04  +1.91110000E-04
   +3.35280000E-04  -1.28750000E-04  +3.73600000E-05  +3.31600000E-05  -3.26400000E-05
   -1.13200000E-04  +3.84870000E-04  -7.64000000E-06  -1.02650000E-04  -2.69100000E-04
   -2.82800000E-05  +1.56040000E-04  +1.21130000E-04  -1.17260000E-04  +3.64850000E-04
   -3.42140000E-04  -9.95550000E-04  -1.29780000E-04  +6.40800000E-05  -1.89610000E-04
   -4.32100000E-05  +6.77350000E-04  +4.20500000E-05  +3.55000000E-06  +1.06800000E-05
   +1.20000000E-07  -1.49780000E-04  -1.96660000E-04  -2.87160000E-04  -1.31650000E-04
   +9.63600000E-05  +4.63800000E-05  +3.95657520E-01  -1.28608500E-02  +1.28887500E-02
   -8.22445000E-03  -1.94754000E-03  -1.62916000E-03  +1.88997000E-03  -2.19290000E-04
   +6.80730000E-04  -7.72300000E-05  -5.49800000E-04  -1.62598000E-03  +6.65070000E-04
   +1.55698000E-03  +1.96755000E-03  -2.59670000E-04  -3.88693000E-03  -2.00400000E-05
   +3.45039000E-03  -3.35863000E-03  -2.88265000E-03  +5.31900000E-04  +5.98700000E-04
   -1.75453000E-03  -1.35630000E-04  -3.39560000E-04  -3.20450000E-04  +6.99100000E-05
   -2.01020000E-04  -3.68100000E-05  -1.07551000E-03  +2.06368000E-03  +1.78266000E-03
   +3.60113000E-03  -3.04838000E-03  -1.19401000E-03  +3.44600000E-04  +2.19523000E-03
   +3.22630000E-04  -1.31926000E-03  +5.94550000E-04  +1.05400000E-04  +2.49500000E-05
   +2.39008000E-03  -3.56420000E-04  -1.04610000E-03  -2.06858000E-03  -1.09395000E-03
   -6.37650000E-04  +3.12300000E-04  -6.26500000E-05  +1.08450000E-04  +2.19530250E-01
   -1.62221620E-01  +5.21187900E-02  +5.49400000E-05  +2.01700000E-04  +1.66090000E-04
   -1.41430000E-04  -4.11500000E-05  -1.26670000E-04  -3.04000000E-06  +6.34400000E-05
   -3.26740000E-04  +4.19800000E-05  -9.08600000E-05  -4.03000000E-06  -1.94280000E-04
   +5.43300000E-05  +5.02000000E-06  +9.37900000E-05  -6.02600000E-05  -7.61500000E-05
   -1.11000000E-06  +2.24030000E-04  +4.09000000E-05  -1.15260000E-04  +8.41700000E-05
   -1.05450000E-04  -5.38140000E-04  -8.96710000E-04  -1.29028000E-03  +1.82750000E-04
   +4.64300000E-04  +1.10240000E-04  +4.74300000E-05  -7.03000000E-06  -2.62010000E-04
   +7.21600000E-05  -2.56700000E-05  -1.62900000E-05  -2.57440000E-04  +1.16670000E-04
   -2.88680000E-04  +1.76500000E-04  -8.67500000E-05  -2.64600000E-05  -2.00130560E-01
   +1.55654340E-01  +2.54889500E-02  -1.46220800E-02  -1.52437000E-03  -2.21500000E-04
   +7.56700000E-05  -1.05810000E-04  -9.22500000E-05  -1.50300000E-05  -5.58460000E-04
   -3.19060000E-04  -6.94300000E-05  +1.67120000E-04  +1.41730000E-03  -7.42770000E-04
   +1.16197000E-03  +3.78774000E-03  +3.44932000E-03  -1.29943000E-03  +1.14478000E-03
   +1.55168000E-03  +1.17725000E-03  -1.56360000E-04  -1.19573000E-03  +1.15817000E-03
   +4.45660000E-04  +3.56600000E-05  -4.91500000E-04  +1.55444000E-03  -2.32950000E-04
   +7.37150000E-04  -1.44220000E-04  -5.30660000E-04  -1.74013000E-03  -6.51100000E-04
   -7.20380000E-04  -6.32200000E-04  -7.56370000E-04  -6.07400000E-04  -1.36921000E-03
   +1.23610000E-03  +1.49350000E-03  +1.20486000E-03  -3.97018000E-03  +4.98400000E-05
   +5.88030000E-04  +1.35558000E-03  +6.57510000E-04  +5.40460000E-04  -2.02640000E-04
   -2.30570000E-04  -4.29370000E-04  -6.77734100E-02  +6.03634200E-02  -2.85353300E-02
   -7.69900000E-05  -9.30300000E-05  -1.42460000E-04  +4.81300000E-05  +4.12400000E-05
   +7.02700000E-05  +5.64100000E-05  +7.60900000E-05  -9.86000000E-06  +4.99100000E-04
   -8.38450000E-04  -2.71830000E-04  +1.60820000E-04  -6.10100000E-05  +4.04900000E-05
   -2.12800000E-05  +5.94400000E-05  +6.25100000E-05  -9.89800000E-05  -1.27730000E-04
   +3.15000000E-05  +6.64000000E-05  +1.21330000E-04  -1.64350000E-04  -4.56110000E-04
   -8.29660000E-04  -1.54870000E-03  -4.93000000E-06  +3.86830000E-04  -3.73210000E-04
   +3.96600000E-05  +4.32380000E-04  -2.17970000E-04  -2.10500000E-05  +1.73000000E-05
   -7.29500000E-05  -3.10600000E-04  -1.11100000E-04  -3.56470000E-04  -5.84000000E-05
   +7.76100000E-05  +3.55400000E-05  +3.80336600E-02  -4.79475200E-02  +3.28714700E-02
   +1.92290000E-04  -9.94060000E-04  +3.27790000E-04  +4.39890000E-04  +2.62662000E-03
   -1.98855000E-03  -7.24253000E-03  -4.71490000E-02  +1.98337300E-02  -4.60660000E-04
   +5.09409000E-03  -1.70230000E-03  -2.36340000E-04  -5.59640000E-04  +1.09808000E-03
   +6.37200000E-05  -7.28200000E-05  -1.08540000E-04  -1.29737000E-03  +4.24030000E-04
   +1.09040000E-04  +2.24140000E-04  -3.09460000E-04  +1.57000000E-06  +9.23600000E-05
   +4.11590000E-04  -2.00280000E-04  +2.97670000E-04  -3.53370000E-04  +2.57380000E-04
   -2.92000000E-06  -7.12900000E-05  +6.00500000E-05  -4.80600000E-05  -1.96500000E-05
   +2.93000000E-05  +1.68960000E-04  +1.12930000E-04  +6.13200000E-05  -3.82300000E-05
   -8.40000000E-06  -8.39200000E-05  +3.74600000E-05  -9.90100000E-05  -1.72000000E-06
   -2.09010000E-04  -1.27490000E-04  -7.71400000E-05  -1.90790000E-03  +1.49032000E-03
   +2.15401000E-03  +7.87950000E-04  +2.95740000E-04  -3.08380000E-04  +1.91100000E-05
   +3.15800000E-05  +1.87500000E-05  -1.85100000E-05  -3.00000000E-08  -2.08300000E-05
   -3.53500000E-05  +7.32300000E-05  -1.76500000E-05  +2.15500000E-05  +1.63500000E-05
   -1.26500000E-05  -1.78100000E-05  +8.36000000E-06  -3.40000000E-06  -9.58410000E-04
   -6.95230000E-04  +2.64900000E-05  -2.60523000E-03  -1.27666000E-03  -3.92660000E-04
   +7.56500000E-05  +2.30400000E-04  +3.89660000E-04  -5.74500000E-05  -4.89900000E-05
   +1.71920000E-04  -4.46900000E-05  +7.95300000E-05  -8.74400000E-05  +6.15200000E-05
   -2.18900000E-05  -1.58470000E-04  +8.29810000E-04  -4.52880000E-04  -7.52800000E-04
   +6.80900000E-05  +4.79700000E-05  -9.21300000E-05  -7.75100000E-05  +2.10000000E-07
   +4.41000000E-06  -2.27480000E-04  +2.49310000E-04  -5.39100000E-05  +3.56164170E-01
   +1.47845000E-03  -2.01954000E-03  -3.61810000E-04  -8.05610000E-04  +4.74830000E-03
   -3.01440000E-04  -1.58788500E-02  -1.00162880E-01  +4.15987900E-02  -2.38040000E-04
   +6.34401000E-03  -2.09852000E-03  -1.64948000E-03  +2.08070000E-04  +1.56980000E-04
   -5.49950000E-04  -1.68410000E-04  +4.36070000E-04  -6.65470000E-04  -6.18220000E-04
   +1.00204000E-03  -4.22400000E-05  +1.20500000E-05  -2.80800000E-05  -9.64000000E-05
   +5.23900000E-04  -1.54600000E-04  -1.17250000E-04  +7.41400000E-05  +2.72100000E-05
   +2.92500000E-05  +2.16800000E-05  -4.86500000E-05  +5.75700000E-05  +5.40000000E-07
   -2.87400000E-05  -1.25470000E-04  -6.92100000E-05  -5.12400000E-05  +1.78000000E-05
   +3.03600000E-05  +6.16800000E-05  -3.00500000E-05  +6.45000000E-06  +3.48600000E-05
   +1.60110000E-04  +8.44400000E-05  +6.41400000E-05  +1.90130000E-04  -1.07570000E-04
   -5.06860000E-04  -3.66860000E-04  +3.88820000E-04  +4.42200000E-05  -1.51700000E-05
   -1.35500000E-05  -2.05200000E-05  +1.63400000E-05  +1.13000000E-05  +1.32300000E-05
   -1.57300000E-05  -2.59300000E-05  -3.82800000E-05  -1.60700000E-05  -3.14000000E-06
   +6.61000000E-06  +8.04000000E-06  +1.67000000E-06  -7.00000000E-07  +7.94500000E-05
   +1.32170000E-04  -1.59680000E-04  +6.68270000E-04  -1.00320000E-04  -5.90000000E-05
   +7.25000000E-05  -2.10200000E-05  -6.52700000E-05  +1.40200000E-05  +3.30100000E-05
   -2.40300000E-05  +2.68900000E-05  -1.60100000E-05  +3.69600000E-05  -1.23900000E-05
   -3.69000000E-06  -6.00000000E-07  -2.14570000E-04  +4.97120000E-04  +1.17650000E-04
   -5.04900000E-05  +7.94200000E-05  +4.08900000E-05  -6.68700000E-05  +3.17900000E-05
   +2.75200000E-05  -1.54320000E-04  -7.63900000E-05  -6.40000000E-06  -4.67150000E-03
   +4.48422900E-02  +7.56200000E-05  +7.73800000E-04  +4.22090000E-04  -2.03930000E-04
   -2.56555000E-03  -1.04213000E-03  +6.57899000E-03  +3.74409200E-02  -1.14379000E-02
   -2.74170000E-04  -2.98982000E-03  +2.48880000E-04  +6.51040000E-04  +6.12090000E-04
   +6.70870000E-04  -1.45520000E-04  -1.00480000E-04  -1.30390000E-04  +5.84350000E-04
   -1.91600000E-05  -3.77300000E-04  -3.08020000E-04  -5.52200000E-05  -7.19100000E-05
   +5.29900000E-05  -2.49570000E-04  +1.96660000E-04  -2.06370000E-04  +3.30340000E-04
   -1.41840000E-04  +9.40900000E-05  +1.91800000E-05  -8.68600000E-05  -1.17000000E-06
   +2.25300000E-05  +3.93100000E-05  -3.69700000E-05  -3.41600000E-05  -3.27800000E-05
   +3.12000000E-06  -1.04100000E-05  +5.41700000E-05  +1.73000000E-06  +6.90800000E-05
   -2.65800000E-05  +5.82600000E-05  +4.33500000E-05  +3.88500000E-05  -4.25820000E-04
   -1.49630000E-03  -1.05526000E-03  -3.42670000E-04  -1.44560000E-04  +5.31740000E-04
   +3.79000000E-06  -8.15000000E-06  -9.99000000E-06  +2.28600000E-05  +9.51000000E-06
   +1.10900000E-05  +2.60600000E-05  -6.34000000E-06  +1.85900000E-05  -3.42300000E-05
   -3.01000000E-06  +1.95800000E-05  +7.47000000E-06  -8.64000000E-06  +4.77000000E-06
   +4.59410000E-04  +4.01490000E-04  +4.26060000E-04  +8.84630000E-04  +8.10890000E-04
   -4.12100000E-05  +2.47080000E-04  +3.22630000E-04  +5.19650000E-04  +9.92400000E-05
   +5.12800000E-05  -3.79900000E-05  +6.80200000E-05  -6.63700000E-05  +1.70580000E-04
   -3.61000000E-05  +3.25500000E-05  +8.67900000E-05  -8.17660000E-04  +1.77500000E-05
   -5.65410000E-04  -9.69400000E-05  -9.23900000E-05  -9.86900000E-05  +7.49000000E-06
   +2.97000000E-06  -2.36200000E-05  +1.85970000E-04  -1.62580000E-04  -5.74000000E-05
   +2.54275390E-01  -2.58852200E-02  +2.08466880E-01  +1.39690000E-04  -5.85360000E-04
   +2.77300000E-05  -6.53040000E-04  +1.51258000E-03  -4.12060000E-04  -3.37090000E-04
   -6.63710000E-03  +2.99664000E-03  +4.79960000E-04  +2.19443000E-03  -1.14092000E-03
   +1.48000000E-06  -5.69000000E-04  +4.81070000E-04  -4.28700000E-05  +2.39280000E-04
   -8.09200000E-05  -4.25090000E-04  +2.64340000E-04  +1.14220000E-04  +1.15000000E-06
   -1.40220000E-04  +9.13000000E-06  -4.88100000E-04  +6.03210000E-04  -4.52000000E-05
   +1.61900000E-05  -1.51460000E-04  -5.74900000E-05  +3.03000000E-05  -1.36900000E-05
   +1.00800000E-05  +5.46600000E-05  -9.66000000E-06  -3.40200000E-05  -1.66610000E-04
   -8.25000000E-05  -7.71300000E-05  +3.80900000E-05  +3.79500000E-05  +5.21800000E-05
   +4.69000000E-06  +7.79000000E-06  +6.77800000E-05  +2.04500000E-04  +9.64200000E-05
   +7.79700000E-05  -3.43900000E-04  -1.49170000E-04  +9.54300000E-05  +4.01960000E-04
   +4.02270000E-04  -1.97830000E-04  -2.98100000E-05  -1.22100000E-05  -2.50100000E-05
   +1.09800000E-05  +1.72100000E-05  +1.39600000E-05  -3.34100000E-05  +5.19000000E-06
   -5.64300000E-05  -2.70500000E-05  -1.48000000E-06  +4.87000000E-06  +1.32500000E-05
   +8.84000000E-06  -2.72000000E-06  +1.82100000E-05  -8.25400000E-05  +1.40060000E-04
   -5.41690000E-04  +1.66000000E-05  -3.03880000E-04  +2.54380000E-04  +2.57580000E-04
   +2.32630000E-04  +3.07800000E-05  +3.87900000E-05  +3.53500000E-05  +4.54000000E-06
   +1.88400000E-05  +1.14300000E-04  +5.51400000E-05  -3.41800000E-05  -6.31900000E-05
   +7.31900000E-05  +3.31630000E-04  +6.40300000E-05  -2.08200000E-05  +4.47800000E-05
   -1.52700000E-05  +2.33200000E-05  -3.75800000E-05  -6.80000000E-06  -1.76370000E-04
   +3.45800000E-05  -3.05700000E-05  -3.39269550E-01  -6.20999000E-03  -2.43160090E-01
   +3.45501500E-01  -3.84630000E-04  -1.86480000E-04  +5.92570000E-04  +8.59700000E-05
   +2.36530000E-04  -9.79220000E-04  -2.24575000E-03  -5.95770000E-04  -6.66590000E-04
   -4.20970000E-04  +3.74420000E-04  -5.19900000E-05  +7.64250000E-04  -6.95120000E-04
   +8.89430000E-04  +1.83250000E-04  +4.92500000E-05  -2.73580000E-04  -3.25490000E-04
   +3.75450000E-04  -2.24990000E-04  +2.02450000E-04  -1.02370000E-04  +3.77800000E-05
   -3.72280000E-04  +4.93260000E-04  +3.76000000E-06  +6.06700000E-05  -1.74070000E-04
   -4.46500000E-05  -7.28000000E-06  -2.35200000E-05  +3.72800000E-05  +3.27000000E-05
   -2.50200000E-05  -3.22300000E-05  -1.08600000E-04  -4.38200000E-05  -4.80300000E-05
   +2.85000000E-05  +1.63400000E-05  +2.08800000E-05  +1.10000000E-07  -8.68000000E-06
   +5.99800000E-05  +1.28180000E-04  +5.09100000E-05  +4.42700000E-05  +1.21100000E-04
   +1.01400000E-04  -9.55600000E-05  +8.36410000E-04  +2.48470000E-04  -3.83340000E-04
   -2.40300000E-05  -2.48000000E-06  -1.59100000E-05  -5.10000000E-07  +1.18900000E-05
   +4.83000000E-06  -2.66400000E-05  +1.68200000E-05  -4.71400000E-05  -8.14000000E-06
   +5.44000000E-06  -6.78000000E-06  +7.69000000E-06  +1.04100000E-05  -3.73000000E-06
   +6.59300000E-05  -6.72700000E-05  +7.90000000E-06  +4.83500000E-05  +1.52000000E-04
   +1.47720000E-04  -1.67410000E-04  -2.66600000E-05  -3.39000000E-06  -3.32500000E-05
   -6.11000000E-06  +3.33200000E-05  -4.34300000E-05  +6.50500000E-05  +1.15300000E-05
   +6.32500000E-05  -4.00200000E-05  -7.78800000E-05  +3.48340000E-04  -7.28440000E-04
   -9.23950000E-04  +3.06800000E-05  +2.86300000E-05  -9.07600000E-05  +2.72300000E-05
   -6.46800000E-05  -7.11000000E-06  -1.54010000E-04  +1.54240000E-04  -1.14700000E-05
   +1.42930100E-02  -2.02496200E-02  +2.36779200E-02  +1.54952000E-03  +2.27268500E-02
   +1.37750000E-04  -3.46000000E-04  -1.20970000E-04  -2.09680000E-04  +1.29456000E-03
   +2.55000000E-05  +8.88090000E-04  -3.96662000E-03  +1.84444000E-03  -2.03880000E-04
   +5.84070000E-04  -1.29160000E-04  +3.91700000E-05  -1.55580000E-04  -3.81500000E-05
   +4.74700000E-05  +1.08990000E-04  -4.29100000E-05  -1.65170000E-04  +3.77800000E-05
   +2.36490000E-04  +2.12400000E-04  +2.72300000E-05  +8.66200000E-05  -4.00800000E-05
   +1.35620000E-04  -7.84300000E-05  +6.10300000E-05  -9.70700000E-05  -1.84400000E-05
   -2.65600000E-05  -1.45400000E-05  +1.24000000E-05  +8.71000000E-06  -1.43900000E-05
   -1.45900000E-05  -2.17000000E-06  +5.08000000E-06  +4.01000000E-06  +5.19000000E-06
   +2.43000000E-06  -1.33100000E-05  -2.96000000E-06  -9.59000000E-06  +3.35300000E-05
   +5.90000000E-07  -5.45000000E-06  -4.54000000E-06  +6.60150000E-04  +4.65000000E-05
   -3.06590000E-04  +2.54700000E-04  +1.89700000E-04  -2.76800000E-04  -2.05000000E-06
   +3.53000000E-06  +1.30000000E-07  -5.18000000E-06  +4.20000000E-07  -3.11000000E-06
   -1.06300000E-05  +1.59800000E-05  -1.92500000E-05  +1.49300000E-05  +1.79000000E-06
   -1.06700000E-05  +5.20000000E-07  +4.77000000E-06  -8.10000000E-07  +7.87800000E-05
   +2.50000000E-06  -7.72900000E-05  +3.33870000E-04  -2.78700000E-05  +1.67580000E-04
   -6.13900000E-05  -9.48200000E-05  -1.42120000E-04  -4.99500000E-05  -1.70400000E-05
   +8.71000000E-06  -3.98800000E-05  -1.32000000E-06  -7.24600000E-05  -7.39000000E-06
   -2.79000000E-05  -4.86000000E-05  +2.39660000E-04  -5.21610000E-04  +9.31300000E-05
   +3.08200000E-05  +3.13300000E-05  -1.00300000E-05  +5.01000000E-06  +4.54000000E-06
   +1.72600000E-05  -9.83200000E-05  +7.09600000E-05  +2.28500000E-05  -2.58023250E-01
   +9.15109000E-03  -1.95035440E-01  +2.50089180E-01  -1.38329700E-02  +1.93282700E-01
   -2.21840000E-03  +1.70264000E-03  +2.13494000E-03  +1.78242000E-03  -1.82971900E-02
   +8.39410000E-03  -2.58783200E-02  +5.11063500E-02  -2.06182900E-02  +5.91010000E-04
   +5.92304000E-03  -4.41760000E-04  +4.26190000E-04  +4.22456000E-03  +5.92300000E-05
   -9.18570000E-04  -8.20900000E-05  +1.86180000E-04  +1.39091000E-03  -1.46815000E-03
   -1.28448000E-03  -1.87120000E-04  +3.72150000E-04  -1.23990000E-04  +5.17790000E-04
   -8.60960000E-04  +3.77900000E-05  -3.44620000E-04  +5.02730000E-04  -1.08370000E-04
   -1.09600000E-05  +1.30140000E-04  +4.86000000E-05  -6.50400000E-05  +4.30700000E-05
   +8.42000000E-06  +1.18280000E-04  +1.42900000E-05  +3.37100000E-05  -4.60000000E-07
   -2.82100000E-05  +1.21200000E-05  -4.20900000E-05  +7.36300000E-05  -1.45740000E-04
   -1.17800000E-04  -2.95300000E-05  -4.76800000E-05  -8.85050000E-04  -2.11960000E-04
   +8.32060000E-04  -1.55907000E-03  -1.89425000E-03  +1.09594000E-03  +2.43300000E-05
   -1.26000000E-05  +2.17700000E-05  +1.58000000E-06  -2.49400000E-05  +1.50000000E-06
   +9.31800000E-05  -1.10700000E-04  +7.86800000E-05  +7.34000000E-06  -2.00400000E-05
   +1.20900000E-05  -3.15000000E-06  -2.46000000E-05  +7.09000000E-06  +4.22920000E-04
   +1.42200000E-04  -2.28240000E-04  -8.57130000E-04  +1.19758000E-03  +8.39480000E-04
   -1.22188000E-03  +2.15700000E-04  -5.50810000E-04  +7.82100000E-05  +1.45000000E-05
   -2.26280000E-04  +7.68700000E-05  -1.02170000E-04  +1.98500000E-05  -1.19790000E-04
   +5.69400000E-05  +1.85740000E-04  -1.07819000E-03  -2.91000000E-06  -6.12920000E-04
   -2.12400000E-05  -1.48370000E-04  +6.06600000E-05  -9.06500000E-05  +1.50670000E-04
   -7.97900000E-05  +7.06300000E-04  -3.33370000E-04  +8.51800000E-05  -4.78935000E-03
   +2.91739600E-02  -1.82979700E-02  -4.80255000E-03  -1.45551900E-02  +5.84053000E-03
   +3.89740800E-02  -3.40497000E-03  +6.32400000E-03  +7.51470000E-04  +1.49163000E-03
   -1.61083500E-02  +6.86032000E-03  +1.37880700E-02  +1.83821500E-02  -1.87710700E-02
   -1.12526000E-03  -3.09765100E-02  +1.35939200E-02  +4.60930000E-03  +2.20589000E-03
   -2.59045000E-03  +9.15780000E-04  +1.44020000E-04  -6.27280000E-04  +3.16667000E-03
   -8.96290000E-04  -1.95098000E-03  -4.97230000E-04  +2.29540000E-04  -1.34900000E-04
   +1.15524000E-03  -3.46003000E-03  +7.77130000E-04  -1.29260000E-04  +7.11950000E-04
   +1.39920000E-04  -4.12300000E-05  +8.59200000E-05  +1.72900000E-05  -2.13690000E-04
   +5.45600000E-05  +1.31470000E-04  +5.63930000E-04  +2.58740000E-04  +2.32930000E-04
   -1.15590000E-04  -1.22300000E-04  -1.44930000E-04  -4.55000000E-06  +3.71200000E-05
   -3.21050000E-04  -6.79590000E-04  -3.02590000E-04  -2.56500000E-04  -1.37830000E-04
   +4.26150000E-04  -7.09100000E-05  -1.69847000E-03  -2.35259000E-03  +1.08084000E-03
   +9.84300000E-05  +2.61500000E-05  +8.81200000E-05  -3.01200000E-05  -6.31100000E-05
   -3.83000000E-05  +1.15880000E-04  -4.02400000E-05  +2.18940000E-04  +5.60900000E-05
   -1.10200000E-05  +1.02100000E-05  -4.05600000E-05  -4.43600000E-05  +1.26600000E-05
   -2.60100000E-04  +7.30300000E-05  +1.37260000E-04  +4.29130000E-04  -9.26430000E-04
   -2.96150000E-04  +3.51720000E-04  -8.79900000E-05  +2.29160000E-04  +8.25200000E-05
   -4.32900000E-05  -9.10900000E-05  +6.36500000E-05  -1.29670000E-04  -4.81900000E-05
   -1.84120000E-04  +1.56410000E-04  +2.74170000E-04  -1.20727000E-03  +3.05170000E-04
   -8.88000000E-06  +1.96000000E-06  -3.41260000E-04  +1.15500000E-04  +2.39670000E-04
   -4.91300000E-05  -1.08420000E-04  +9.96660000E-04  -2.81850000E-04  +1.04540000E-04
   +3.14461000E-02  +6.55839600E-02  -3.07403500E-02  +7.03433000E-03  -2.07727000E-03
   +7.41388000E-03  -5.68369000E-02  -3.66904800E-02  +2.46292000E-03  -2.14260000E-04
   +1.66311000E-03  +8.73090000E-04  +1.20918500E-02  -1.69360000E-04  -4.10637000E-03
   -9.70294000E-03  -2.66225300E-02  +2.25147000E-03  +5.65662000E-03  +2.02196000E-03
   +7.02780000E-04  -1.06844000E-03  +3.54223000E-03  +1.11400000E-04  -1.26760000E-04
   -5.80120000E-04  -2.05210000E-03  +2.85770000E-04  -9.70110000E-04  +6.47240000E-04
   -2.34880000E-04  +4.49900000E-05  -4.65330000E-04  +8.50990000E-04  -2.65410000E-04
   -1.59000000E-06  -2.18480000E-04  +1.67950000E-04  -9.39700000E-05  -4.48800000E-05
   +1.18950000E-04  +7.04400000E-05  -3.90900000E-05  -8.99000000E-05  -1.52600000E-04
   -5.33400000E-05  -5.25500000E-05  +3.51700000E-05  +3.16700000E-05  +2.21400000E-05
   -6.81500000E-05  -9.45800000E-05  +6.60600000E-05  +1.72520000E-04  +6.16300000E-05
   +4.99300000E-05  +5.16460000E-04  +5.53730000E-04  +7.86740000E-04  +7.47970000E-04
   +8.57990000E-04  -9.13550000E-04  -3.81000000E-05  -3.35000000E-06  -2.18700000E-05
   -7.67000000E-06  +1.17500000E-05  +5.31000000E-06  -5.80300000E-05  -1.93000000E-06
   -8.80400000E-05  +2.14000000E-06  +7.36000000E-06  -2.16000000E-05  +3.56000000E-06
   +1.47600000E-05  -8.67000000E-06  -3.41390000E-04  -2.88010000E-04  -2.75880000E-04
   +8.37200000E-04  -9.48260000E-04  -4.49330000E-04  -5.01630000E-04  +9.81900000E-05
   -1.84180000E-04  -9.56700000E-05  -1.77600000E-05  +7.20400000E-05  -6.22700000E-05
   +1.67100000E-05  -1.04470000E-04  +4.46700000E-05  -9.55800000E-05  -2.50180000E-04
   -1.17040000E-04  -8.91480000E-04  -1.56463000E-03  +4.73000000E-05  +1.37130000E-04
   +3.31100000E-05  -4.21200000E-05  -1.23650000E-04  -1.01130000E-04  -4.42960000E-04
   +2.09990000E-04  +3.14000000E-05  -1.47328600E-02  -2.29802900E-02  -1.65385000E-03
   -8.91710000E-03  -7.74789000E-03  +6.28320000E-04  +2.27706400E-02  +2.40096900E-02
   +2.51331300E-02
end_hess

