# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -882.69036410    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +1.85232029E+00  -9.75766808E-02  +2.34316415E+00
   006   +1.59210080E+00  +1.33643188E+00  +1.30254825E-01
   006   +3.63397048E+00  +1.29715343E+00  -1.52969524E+00
   006   +5.77772805E+00  -8.03261206E-02  -1.01978718E+00
   006   +6.02352110E+00  -1.49486458E+00  +1.14793966E+00
   006   +4.02282043E+00  -1.49030429E+00  +2.84604689E+00
   006   -8.17625124E-01  +2.85215641E+00  -3.98323924E-01
   006   -1.03502566E+00  +4.97659042E+00  +1.57189983E+00
   008   +8.18849476E+00  -2.81754577E+00  +1.53178938E+00
   006   -3.10584195E+00  +1.07563531E+00  -3.98132254E-01
   006   -3.00820963E+00  -1.16066202E+00  -1.77532252E+00
   006   -5.05671213E+00  -2.78096325E+00  -1.91471525E+00
   006   -7.28358854E+00  -2.18470736E+00  -6.60689667E-01
   006   -7.42288851E+00  +3.52675215E-02  +7.21502423E-01
   006   -5.35242566E+00  +1.63312009E+00  +8.41123825E-01
   008   -9.35938427E+00  -3.70045225E+00  -7.20234171E-01
   006   -7.34505590E-01  +4.12119132E+00  -3.01139280E+00
   008   -9.18785335E-02  -1.03215599E-01  +4.01496381E+00
   001   -9.02141379E+00  -5.14865155E+00  -1.74819343E+00
   001   -4.91824890E+00  -4.51399011E+00  -2.99930546E+00
   001   -1.28343796E+00  -1.66942086E+00  -2.75338822E+00
   001   -5.51627709E+00  +3.33839860E+00  +1.95300946E+00
   001   -9.15731334E+00  +4.90438166E-01  +1.70186811E+00
   001   -2.51317299E+00  +5.11006811E+00  -3.32632307E+00
   001   +7.90985075E-01  +5.50360024E+00  -3.13496351E+00
   001   -5.10526098E-01  +2.74794323E+00  -4.53030447E+00
   001   -1.28424828E+00  +4.24098383E+00  +3.47439650E+00
   001   +6.83407621E-01  +6.11242692E+00  +1.53421991E+00
   001   -2.61559699E+00  +6.22526814E+00  +1.13446769E+00
   001   +3.55270662E+00  +2.35678796E+00  -3.27214154E+00
   001   +7.56410995E+00  -7.52779403E-02  -2.55828647E+00
   001   +4.15006639E+00  -2.57490352E+00  +4.58327638E+00
   001   +8.10523348E+00  -3.70797862E+00  +3.10267968E+00
   001   +2.49159919E-01  -1.25846247E+00  +5.36198404E+00
   008   +9.53573369E+00  -3.96551031E-01  -3.74174004E+00
   001   +1.03820702E+01  -1.50902486E+00  -2.56875305E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -3.10000000E-07  +4.50000000E-07  +3.20000000E-07
   +1.90000000E-07  -5.00000000E-08  +9.00000000E-08
   +1.00000000E-07  -1.02000000E-06  +2.30000000E-07
   -6.20000000E-07  -7.70000000E-07  +2.01000000E-06
   -1.90000000E-07  -7.30000000E-07  +1.51000000E-06
   -7.70000000E-07  +3.20000000E-07  +1.20000000E-06
   +3.80000000E-07  +1.20000000E-07  -8.40000000E-07
   +1.90000000E-07  +6.60000000E-07  -1.33000000E-06
   -8.10000000E-07  -3.60000000E-07  +1.88000000E-06
   +2.70000000E-07  +1.80000000E-07  -7.00000000E-07
   -5.00000000E-08  -4.00000000E-08  -1.70000000E-07
   -1.30000000E-07  +1.60000000E-07  +8.00000000E-08
   -9.00000000E-08  +8.90000000E-07  -4.50000000E-07
   -1.80000000E-07  +1.20000000E-06  -1.06000000E-06
   +2.00000000E-08  +9.40000000E-07  -1.09000000E-06
   -6.80000000E-07  +1.29000000E-06  -1.90000000E-07
   +9.60000000E-07  -7.60000000E-07  -1.10000000E-06
   -8.50000000E-07  +1.16000000E-06  +1.60000000E-07
   -4.20000000E-07  +4.20000000E-07  -1.20000000E-07
   -2.00000000E-07  -1.30000000E-07  +5.80000000E-07
   +1.20000000E-07  -5.70000000E-07  +4.20000000E-07
   +1.10000000E-07  +1.35000000E-06  -1.62000000E-06
   -3.20000000E-07  +1.70000000E-06  -1.45000000E-06
   +1.15000000E-06  -5.10000000E-07  -1.62000000E-06
   +1.17000000E-06  -9.70000000E-07  -1.22000000E-06
   +9.80000000E-07  -1.13000000E-06  -6.90000000E-07
   -1.50000000E-07  +1.15000000E-06  -1.24000000E-06
   +5.00000000E-07  +2.80000000E-07  -1.31000000E-06
   +5.90000000E-07  +7.10000000E-07  -2.01000000E-06
   +7.60000000E-07  -1.32000000E-06  +6.00000000E-08
   +1.92000000E-06  -1.85000000E-06  -3.00000000E-08
   -1.15000000E-06  +6.80000000E-07  +1.50000000E-06
   -1.14000000E-06  -4.50000000E-07  +2.72000000E-06
   -1.07000000E-06  +1.24000000E-06  +7.60000000E-07
   -6.80000000E-07  -1.98000000E-06  +2.55000000E-06
   +4.30000000E-07  -2.24000000E-06  +2.16000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +6.18358100E-01  -1.71393650E-01  +3.74020280E-01  -9.44301000E-02  -1.97939200E-01
   +5.76567810E-01  -1.20964260E-01  +5.21505600E-02  -4.63474800E-02  +5.71889160E-01
   +1.73069700E-02  -1.46353600E-01  +1.05830660E-01  -1.31341110E-01  +3.39065080E-01
   +1.07705300E-02  +7.76622700E-02  -2.14247250E-01  -1.11831490E-01  -1.64667820E-01
   +5.48610050E-01  +3.71331200E-02  -5.41777600E-02  +6.15353600E-02  -2.31698090E-01
   +3.95824200E-02  +7.80943900E-02  +5.81998020E-01  -2.64483300E-02  +1.88910600E-02
   -4.77066000E-03  +5.16027000E-03  -8.43448300E-02  +3.76043500E-02  -1.77844430E-01
   +3.56734700E-01  +1.60737800E-02  +1.81953200E-02  -4.11603300E-02  +1.36760980E-01
   +8.95884000E-03  -1.91101970E-01  -7.96672400E-02  -2.31782170E-01  +5.94709390E-01
   -2.00949300E-02  +2.57539400E-02  -2.70953700E-02  -5.05098000E-02  +3.47847000E-03
   +4.30324800E-02  -2.58939330E-01  +1.37770250E-01  -5.50124700E-02  +4.65085400E-01
   +2.49026700E-02  -3.32652500E-02  +3.26967200E-02  +3.06364900E-02  +1.82519000E-02
   -4.32446800E-02  +1.11536520E-01  -1.41568140E-01  +6.05076900E-02  -1.95544350E-01
   +3.19276080E-01  -2.60963600E-02  +3.26971500E-02  -3.38154700E-02  -2.35727000E-03
   -2.09476700E-02  +4.52629600E-02  -1.05033100E-02  +3.83815000E-02  -1.05823510E-01
   +9.92510000E-03  -2.23487130E-01  +4.55977340E-01  -5.01997000E-02  +2.61354000E-02
   -4.71310000E-03  -6.56568000E-03  -1.18085000E-02  +2.61174300E-02  +2.30808700E-02
   +7.55566000E-03  -3.38310700E-02  -9.21421900E-02  +3.52707900E-02  -3.16133800E-02
   +6.06349360E-01  -4.33292000E-03  +1.86940100E-02  -3.48016700E-02  -1.25903100E-02
   -8.10973000E-03  +2.49884200E-02  +3.49741000E-02  -2.52006100E-02  +9.56932000E-03
   +6.97570000E-04  -1.41595540E-01  +1.37694580E-01  -1.76986210E-01  +3.71874600E-01
   +4.64509000E-02  -6.07852900E-02  +5.84041300E-02  +2.72367100E-02  +2.45673000E-02
   -6.38628800E-02  -8.06076400E-02  +3.27156000E-02  +1.06485900E-02  +2.70108700E-02
   +1.08336390E-01  -2.63378390E-01  -8.88522600E-02  -2.19920610E-01  +5.97308270E-01
   -2.42589650E-01  +8.70587200E-02  +5.01428000E-03  +2.13776100E-02  +3.08231000E-02
   -6.41010800E-02  -5.85622700E-02  +2.13857000E-02  +1.45808500E-02  +3.26198200E-02
   -4.37945600E-02  +5.43233400E-02  -2.23068180E-01  +3.63364900E-02  +7.67045400E-02
   +6.07690180E-01  +1.25725990E-01  -1.48257120E-01  +3.64813600E-02  +8.45525000E-03
   -1.39033300E-02  +2.93701700E-02  +1.99402700E-02  -6.77026000E-03  -2.34300000E-03
   -1.58537900E-02  +1.70017700E-02  -4.05200000E-05  -4.39213000E-03  -8.68945300E-02
   +4.81142400E-02  -1.84257150E-01  +3.38729590E-01  -5.95665700E-02  +6.86889400E-02
   -1.27698590E-01  -2.65082300E-02  +1.04620500E-02  +1.19630400E-02  +1.77904400E-02
   -3.87982000E-03  -6.57207000E-03  +6.83736000E-03  +2.39218600E-02  -3.71993900E-02
   +1.45919910E-01  +1.35255800E-02  -2.07408550E-01  -1.13103100E-01  -2.30957720E-01
   +5.98006880E-01  +1.53866000E-03  +5.48389000E-03  -9.47703000E-03  -1.38703260E-01
   +3.99413800E-02  -7.42789000E-03  -2.11691400E-02  +1.33558300E-02  -1.02483000E-03
   +2.80770000E-04  +7.29930000E-04  +3.79422000E-03  -1.39576000E-03  +2.12250000E-04
   +2.09200000E-04  +2.06284000E-03  -2.38480000E-04  +2.22850000E-03  +4.70835110E-01
   +1.38938100E-02  -8.58699000E-03  +6.70423000E-03  +4.25083600E-02  -9.77000200E-02
   +1.48379400E-02  +4.03237000E-03  +2.80475000E-03  -2.58600000E-03  +8.18730000E-04
   +4.75252000E-03  +2.04842000E-03  +1.82080000E-04  -8.89040000E-04  +3.65510000E-04
   +2.47410000E-04  +1.99899000E-03  +2.65342000E-03  -3.19144000E-03  +4.77565880E-01
   -2.27621000E-02  +1.40778300E-02  -1.43870000E-03  -1.17803900E-02  +1.73740000E-02
   -8.79353600E-02  +1.31542900E-02  -9.72932000E-03  +8.11263000E-03  +3.33605000E-03
   +1.54556000E-03  +6.52630000E-04  +1.73030000E-04  +7.37170000E-04  -1.90748000E-03
   +9.18980000E-04  +3.89311000E-03  -3.28160000E-03  -1.23178000E-03  +5.86407000E-03
   +4.74387400E-01  -4.65560000E-04  +1.35300000E-04  +4.68830000E-04  -7.26090000E-03
   +2.22774800E-02  +1.86561200E-02  -1.08093000E-03  +1.58067000E-03  -1.03722000E-03
   -8.94590000E-04  -4.28010000E-04  -1.41782000E-03  +3.66280000E-04  -4.86510000E-04
   +6.35400000E-04  -2.11210000E-04  -8.27860000E-04  +1.77650000E-04  -7.64009000E-02
   +7.20230000E-03  +7.65683000E-03  +5.84104310E-01  +1.11520000E-04  -1.73020000E-04
   -6.42790000E-04  +1.01139000E-02  -1.97874500E-02  -1.20626000E-02  -1.04962000E-03
   -7.90050000E-04  +7.48130000E-04  +4.97410000E-04  +2.34360000E-04  +6.88680000E-04
   -1.62660000E-04  +2.38420000E-04  -2.19490000E-04  +3.33940000E-04  +7.08880000E-04
   -2.72860000E-04  +3.68823000E-03  -1.26374610E-01  -5.04725300E-02  +5.83646000E-03
   +5.13642840E-01  -3.12130000E-03  +1.77062000E-03  +1.67593000E-03  +4.49136000E-03
   -2.41060000E-04  +4.87079000E-03  -6.73630000E-04  +2.55930000E-04  -4.10930000E-04
   -3.06340000E-04  +3.60270000E-04  -8.57710000E-04  +7.22000000E-06  -4.79650000E-04
   +8.61760000E-04  +8.91730000E-04  -4.79190000E-04  -1.82800000E-04  +3.41072000E-03
   -4.54339500E-02  -1.20902830E-01  +1.29036000E-03  -6.79769800E-02  +5.44586600E-01
   +3.45916000E-03  -1.17924000E-03  +5.62413000E-03  -2.07975000E-03  +1.80326000E-03
   -2.49035000E-03  +9.09100000E-04  -6.32930000E-04  +2.92884000E-03  -1.09482300E-02
   +1.60650300E-02  -1.19921100E-02  -2.46789510E-01  +9.59074000E-02  +1.23454200E-02
   -4.25182200E-02  +2.96486700E-02  -5.74435000E-03  +1.35400000E-03  -5.26840000E-04
   +8.74550000E-04  -1.05514000E-03  +3.29150000E-04  -7.38130000E-04  +3.37613640E-01
   +2.73555000E-03  +2.95878000E-03  +5.43590000E-03  +1.86127000E-03  -8.71680000E-04
   -2.43665000E-03  -3.80560000E-03  +3.14174000E-03  +3.69478000E-03  +3.34738300E-02
   -1.88369400E-02  +1.44260600E-02  +1.22364050E-01  -1.20536070E-01  +2.72483200E-02
   +1.07987000E-02  +3.12880000E-03  +2.05769000E-03  -7.93680000E-04  +4.55970000E-04
   -8.02130000E-04  +7.13810000E-04  -2.64800000E-04  +4.98360000E-04  -1.49111920E-01
   +2.68030350E-01  -1.12382000E-03  +8.87680000E-03  -6.38845000E-03  -2.52566000E-03
   -2.42545000E-03  +4.82330000E-03  +8.26222000E-03  +9.58300000E-04  -5.25102000E-03
   -4.11709400E-02  +2.90795400E-02  -7.32347000E-03  -3.22070000E-02  +4.98372100E-02
   -9.88551200E-02  +2.63807400E-02  -1.41296300E-02  +1.09970600E-02  +1.52670000E-04
   -2.16360000E-04  +5.70760000E-04  -3.43070000E-04  +9.50000000E-05  -3.09200000E-04
   -1.49100600E-02  -2.82089470E-01  +5.12914660E-01  +1.33900000E-04  -1.88390000E-04
   -2.15070000E-04  -3.46099000E-02  -1.12853700E-02  +1.40976000E-03  -9.82840000E-04
   +3.02400000E-04  -1.92784000E-03  -5.52400000E-05  +1.10345000E-03  +2.98470000E-04
   -2.61800000E-05  -1.89130000E-04  +3.95990000E-04  +2.98760000E-04  -1.95180000E-04
   +8.67390000E-04  -1.38238390E-01  -4.43573500E-02  +4.54533000E-03  +2.70293000E-03
   -3.52809000E-03  -3.54094000E-03  -1.11800000E-04  +7.89400000E-05  -9.50200000E-05
   +5.96980990E-01  +3.02705000E-03  +1.26970000E-04  -1.12346000E-03  +7.73399000E-03
   +1.22996500E-02  -2.07433000E-03  +1.36467000E-03  -1.89780000E-03  +6.67700000E-04
   +1.70320000E-04  -1.23264000E-03  +5.73280000E-04  -1.85850000E-04  +8.51190000E-04
   -9.63390000E-04  -7.40030000E-04  -2.63600000E-05  +1.45180000E-04  -4.05353100E-02
   -1.15742260E-01  -9.90307000E-03  -2.02301600E-02  -1.88796100E-02  -1.07142000E-03
   +9.42910000E-04  -7.65550000E-04  +3.56790000E-04  +5.16353000E-02  +5.40198060E-01
   -9.52740000E-04  +3.39830000E-04  -4.69810000E-04  -2.63057000E-03  -2.18148000E-03
   +3.25000000E-04  -2.71800000E-05  -1.41760000E-04  -2.48380000E-04  +3.03800000E-05
   -2.07600000E-05  -3.23700000E-05  +1.06200000E-04  -7.21900000E-05  -4.44600000E-05
   +8.55000000E-05  +3.36700000E-05  +2.96120000E-04  +6.08766000E-03  -8.14488000E-03
   -7.54607800E-02  -1.92407400E-02  -1.51797000E-02  +3.10650000E-04  -2.21570000E-04
   +1.31170000E-04  -3.34800000E-05  -1.42623410E-01  +1.85225150E-01  +3.54060190E-01
   -3.50040000E-04  -2.99930000E-04  -7.88650000E-04  -4.55390000E-04  -2.63096000E-03
   -1.17832000E-03  +4.96250000E-04  -6.00970000E-04  -3.72900000E-04  -1.29080000E-04
   +4.82960000E-04  -1.05520000E-04  -4.77400000E-05  -8.40400000E-05  +1.96800000E-04
   +2.93100000E-04  -4.67200000E-05  +7.03200000E-05  +1.71102000E-03  -2.37203500E-02
   -1.49757800E-02  -4.94406000E-03  -2.97072000E-03  +1.06246000E-03  -1.69360000E-04
   +1.17700000E-04  -3.88100000E-05  -1.23694350E-01  +2.85444500E-02  +3.84245200E-02
   +6.80167790E-01  -1.40140000E-03  -6.56280000E-04  +1.45691000E-03  +1.84040000E-04
   -8.05500000E-04  -9.86470000E-04  +2.30700000E-04  -7.51200000E-05  -3.55880000E-04
   +1.86980000E-04  -1.65880000E-04  -1.93230000E-04  +1.24860000E-04  -5.44600000E-05
   +4.41600000E-05  +1.24640000E-04  +5.54000000E-05  -1.12130000E-04  -6.94836000E-03
   -1.87245700E-02  -9.03777000E-03  -2.30658000E-03  -4.19170000E-04  +5.28400000E-04
   -1.31410000E-04  +9.42800000E-05  -7.79600000E-05  -3.05371500E-02  -2.52703860E-01
   -9.71798600E-02  +8.25821000E-02  +5.58532250E-01  -8.15260000E-04  -6.65580000E-04
   +4.29400000E-04  -6.96880000E-04  -1.08526000E-03  -1.15250000E-04  +3.97460000E-04
   -3.05810000E-04  -5.25130000E-04  +1.68530000E-04  -6.70800000E-05  -2.02230000E-04
   +1.64750000E-04  -1.58600000E-05  +1.48210000E-04  +1.93300000E-04  -1.99150000E-04
   +3.09300000E-05  -4.63437000E-03  -1.04420000E-03  +2.79915000E-03  +7.95080000E-04
   +1.07480000E-04  +4.64300000E-05  -1.46530000E-04  +4.93300000E-05  -6.98800000E-05
   +3.22157000E-03  -1.19642610E-01  -1.42739590E-01  -1.65151100E-01  +2.12846540E-01
   +3.35375590E-01  +2.21510000E-04  -8.84900000E-05  +1.63110000E-04  +9.24100000E-05
   -1.36610000E-04  -3.32960000E-04  -3.03420000E-04  +2.54500000E-04  -2.19000000E-06
   +2.66250000E-04  -1.59090000E-04  -3.84100000E-05  +2.33670000E-04  -2.37100000E-05
   -1.45180000E-04  -3.42050000E-04  +1.77420000E-04  +1.01240000E-04  +3.17111000E-03
   +1.39218000E-03  +2.06888000E-03  +4.23390000E-04  +4.98540000E-04  +4.09510000E-04
   -2.27620000E-04  +1.38880000E-04  -4.19100000E-05  +3.98442000E-02  -6.00144700E-02
   -4.87721800E-02  -2.60240020E-01  -9.15598100E-02  +2.69687000E-02  +6.30801800E-01
   -2.68500000E-05  +1.70350000E-04  -9.53700000E-05  +7.56260000E-04  +6.68200000E-05
   +3.80460000E-04  -2.82850000E-04  +3.12760000E-04  +2.21220000E-04  -1.52760000E-04
   -2.10700000E-05  +1.67650000E-04  -1.53950000E-04  +5.93500000E-05  -8.88800000E-05
   -6.23200000E-05  +7.87900000E-05  -6.76300000E-05  +1.73539000E-03  -1.15681000E-03
   -5.40461000E-03  -1.25731000E-03  -6.37870000E-04  +2.67400000E-04  +1.87120000E-04
   -9.72200000E-05  +5.75700000E-05  -1.40719900E-02  -3.65518700E-02  -2.03814300E-02
   -1.49218480E-01  -1.98915850E-01  -2.33845200E-02  +9.73914800E-02  +6.04337970E-01
   -3.81500000E-05  +8.22300000E-05  -3.80510000E-04  +5.46690000E-04  +2.73820000E-04
   +7.64800000E-05  +1.13160000E-04  -6.45800000E-05  +5.01100000E-05  -1.45410000E-04
   +3.97600000E-05  +7.18100000E-05  -1.27520000E-04  +5.49900000E-05  -1.34400000E-05
   +1.16470000E-04  -5.09300000E-05  +1.56900000E-05  +2.06083000E-03  -4.13279000E-03
   +1.51716000E-03  -4.10600000E-04  -4.14910000E-04  +1.47760000E-04  +1.36520000E-04
   -1.12080000E-04  +4.30700000E-05  -2.13041900E-02  -2.18036000E-03  +1.51692600E-02
   -7.62913000E-03  -4.66171800E-02  -8.36360800E-02  -1.46070540E-01  +2.45709320E-01
   +3.30063190E-01  -7.80840000E-04  -1.99830000E-04  +4.25410000E-04  -2.11100000E-04
   +4.54340000E-04  -1.09330000E-04  +1.21520000E-04  -1.52500000E-04  -2.06300000E-05
   -2.55890000E-04  -1.41770000E-04  +4.65900000E-04  -4.59290000E-04  +3.40310000E-04
   -1.76860000E-04  +3.19970000E-04  -5.27700000E-05  -1.26840000E-04  -2.35175000E-03
   -2.47870000E-04  -5.94800000E-05  +4.28330000E-04  -2.41940000E-04  -2.36200000E-04
   +6.83070000E-04  -4.49280000E-04  +1.72330000E-04  -2.11701500E-02  +3.29218500E-02
   +2.58285200E-02  -5.49414000E-02  -4.23496000E-02  -2.26334000E-03  -2.51958250E-01
   +6.95940100E-02  +1.15591430E-01  +6.44371380E-01  -6.75600000E-05  -3.62100000E-05
   +1.18700000E-04  +2.17830000E-04  +7.71180000E-04  -3.77080000E-04  -3.30030000E-04
   +2.30180000E-04  +1.31030000E-04  -8.33900000E-05  -4.61950000E-04  +6.71210000E-04
   -2.89540000E-04  +4.57170000E-04  -5.57700000E-04  -1.81640000E-04  +1.25860000E-04
   -8.76000000E-06  +4.05490000E-04  -9.73730000E-04  -1.02283000E-03  +2.86420000E-04
   +9.75500000E-05  +8.62000000E-05  +6.89650000E-04  -5.01140000E-04  +2.18470000E-04
   +3.20494100E-02  -3.66210300E-02  -3.08054800E-02  +7.05747000E-03  +5.66921900E-02
   +2.96608600E-02  -5.82470000E-04  -1.36244670E-01  -3.98817000E-02  +8.52748500E-02
   +5.98126450E-01  +2.73800000E-05  +5.53600000E-05  +1.21470000E-04  +2.41600000E-04
   +2.32050000E-04  -2.34070000E-04  -3.48920000E-04  +1.71350000E-04  +1.01080000E-04
   +7.70800000E-05  -2.01670000E-04  +2.35970000E-04  -2.09000000E-06  +1.48270000E-04
   -2.70110000E-04  -2.08220000E-04  +1.03890000E-04  +5.80000000E-06  +7.75160000E-04
   -3.12050000E-04  -1.04298000E-03  +4.54900000E-05  -2.37000000E-06  +2.70480000E-04
   +1.55040000E-04  -1.22030000E-04  +5.64300000E-05  +2.57430300E-02  -3.15311600E-02
   -3.45337300E-02  +2.73043100E-02  +4.92194200E-02  +2.09399700E-02  +7.39689400E-02
   -6.82847600E-02  -1.39298650E-01  -1.44758770E-01  +2.25870860E-01  +3.55663210E-01
   -5.86430000E-04  -1.00320000E-04  +7.03160000E-04  -4.45430000E-04  -5.08500000E-04
   +1.12970000E-04  +1.88870000E-04  -1.09960000E-04  -1.53000000E-04  +3.35000000E-06
   +2.00300000E-04  -2.61180000E-04  +3.09500000E-05  -1.62910000E-04  +2.94790000E-04
   +3.02230000E-04  -1.78470000E-04  -1.24900000E-04  -6.78210000E-04  +1.96571000E-03
   +3.53118000E-03  +2.15450000E-04  +6.40970000E-04  +5.61900000E-05  -1.80530000E-04
   +1.44590000E-04  -8.58700000E-05  -5.11647500E-02  +5.08387000E-03  +2.62824400E-02
   -1.43056600E-02  -2.58046200E-02  -1.08922900E-02  +2.71238700E-02  +2.77295400E-02
   +8.98745000E-03  -1.27210580E-01  +4.75993500E-02  +5.13238400E-02  +6.89154100E-01
   -3.86290000E-04  -1.78730000E-04  +3.70740000E-04  -4.34890000E-04  -5.21940000E-04
   +2.58470000E-04  +3.38680000E-04  -2.71170000E-04  -2.00060000E-04  -9.13000000E-06
   +3.76240000E-04  -4.54560000E-04  +8.10500000E-05  -3.19110000E-04  +4.60910000E-04
   +3.87490000E-04  -1.26690000E-04  -5.09200000E-05  +8.12600000E-04  +1.41589000E-03
   -2.59857000E-03  -4.77170000E-04  -6.60520000E-04  -5.99400000E-05  -3.86870000E-04
   +2.99030000E-04  -1.50780000E-04  -3.91398200E-02  +5.13664600E-02  +4.13085200E-02
   -2.43751900E-02  -5.60533500E-02  -2.19963300E-02  +6.85666000E-02  +7.00262000E-03
   -2.86014500E-02  -1.87637400E-02  -2.51551930E-01  -1.00073090E-01  +8.73896200E-02
   +5.64638830E-01  +4.44220000E-04  +7.77800000E-05  -4.80240000E-04  +8.78130000E-04
   +6.94960000E-04  -9.83600000E-05  +2.96960000E-04  -1.64780000E-04  +1.03590000E-04
   -1.59500000E-05  -8.98000000E-06  -1.39160000E-04  +2.48600000E-05  -3.93100000E-05
   +8.38900000E-05  -3.18400000E-05  -4.54400000E-05  -2.40000000E-06  +3.83412000E-03
   -3.84788000E-03  +3.33610000E-03  -4.27080000E-04  -4.97620000E-04  -1.18190000E-04
   -6.89500000E-05  +4.92200000E-05  -7.57000000E-06  +2.67240000E-04  +2.42558500E-02
   +2.08752200E-02  -9.96946000E-03  -2.11240900E-02  -1.16830100E-02  +3.32472400E-02
   -1.21246600E-02  -1.21886100E-02  +1.17967100E-02  -1.27258610E-01  -1.51756400E-01
   -1.75032030E-01  +2.25333500E-01  +3.35722740E-01  -5.30780000E-04  +4.94700000E-05
   +3.83150000E-04  -8.29890000E-04  -1.50074000E-03  +3.21190000E-04  -7.08050000E-04
   +5.99550000E-04  -1.23080000E-04  +5.09300000E-05  -3.36100000E-05  +2.77810000E-04
   +5.48700000E-05  +6.16900000E-05  -2.75480000E-04  -3.12360000E-04  +2.28140000E-04
   +6.01100000E-05  -2.06404600E-02  +5.04260000E-04  +9.13183000E-03  -9.19150000E-04
   -3.61100000E-05  +1.10610000E-03  +3.49500000E-05  -1.33600000E-05  +3.74100000E-05
   -2.65372460E-01  -4.15425000E-03  +7.85049200E-02  +2.67526400E-02  +7.54970900E-02
   +3.78631300E-02  -6.83096400E-02  -1.58755300E-02  +1.67094800E-02  +4.56738700E-02
   -6.46603700E-02  -5.63985200E-02  -2.62133800E-01  -8.86342300E-02  +2.87656100E-02
   +6.24485570E-01  -4.30310000E-04  +1.53540000E-04  +6.80830000E-04  -1.70881000E-03
   -2.31881000E-03  +6.33130000E-04  -5.50220000E-04  +5.27380000E-04  -2.00850000E-04
   -5.99000000E-06  +2.48130000E-04  -3.82300000E-05  +8.70900000E-05  -1.30670000E-04
   +1.05200000E-04  -1.33400000E-05  +2.96100000E-05  -9.18800000E-05  -1.61894100E-02
   +8.78522000E-03  +9.45627000E-03  -1.03383000E-03  +6.48400000E-05  +6.19590000E-04
   -2.05430000E-04  +1.69500000E-04  -6.59300000E-05  +5.43560400E-02  -1.26656280E-01
   -5.72196300E-02  +3.06996900E-02  +4.47472000E-03  -1.45062400E-02  -1.34545400E-02
   -6.64349000E-03  +3.66087000E-03  -1.49816600E-02  -3.87542100E-02  -1.83116800E-02
   -1.46877810E-01  -1.96965730E-01  -2.21815100E-02  +8.87826700E-02  +6.03803450E-01
   +1.15820000E-04  +6.70100000E-05  -6.52860000E-04  -1.73630000E-03  -1.10940000E-03
   +2.55660000E-04  +4.55200000E-05  -5.58800000E-05  +2.00400000E-05  -1.54100000E-05
   +3.98260000E-04  -2.17520000E-04  +1.69800000E-05  -1.86260000E-04  +2.83350000E-04
   +1.66510000E-04  -9.66000000E-06  +1.42520000E-04  +3.07070000E-04  +2.98194000E-03
   +3.71212000E-03  -8.55890000E-04  +8.59270000E-04  -8.19500000E-05  -2.66590000E-04
   +1.93160000E-04  -8.35400000E-05  +1.13616450E-01  -3.41986700E-02  -1.33350200E-01
   +1.16526800E-02  -3.29670700E-02  -1.59195200E-02  +1.79699000E-02  +4.94025000E-03
   -7.83970000E-03  -2.66292800E-02  +1.84086000E-03  +1.41033800E-02  -6.30266000E-03
   -4.65964700E-02  -8.56540800E-02  -1.41944600E-01  +2.43233480E-01  +3.49443100E-01
   +3.99040000E-04  +3.46100000E-05  -2.15600000E-05  +2.61000000E-05  -9.31470000E-04
   +1.59850000E-04  +1.24090000E-04  -4.04500000E-05  -1.52460000E-04  +2.86470000E-04
   +3.72960000E-04  -7.65620000E-04  +5.22840000E-04  -5.21790000E-04  +4.69530000E-04
   -9.81300000E-05  +9.53000000E-06  +9.18200000E-05  +1.44877000E-03  +6.35040000E-04
   +7.84280000E-04  -6.03830000E-04  +8.03400000E-05  +2.10720000E-04  -9.40700000E-04
   +6.45880000E-04  -2.71060000E-04  -6.45250000E-04  -3.65456000E-03  -2.70155000E-03
   +1.59501000E-03  +5.59618000E-03  +5.71527000E-03  -4.55855600E-02  -3.57963900E-02
   +1.03505000E-03  -2.37276130E-01  -8.42524700E-02  +2.92131700E-02  +2.01807000E-03
   -1.22215900E-02  -5.14159000E-03  -2.27731000E-03  +1.94135000E-03  +3.93909000E-03
   +3.43853980E-01  +2.47120000E-04  +1.65500000E-05  -5.37400000E-05  -1.55000000E-06
   -8.44590000E-04  +1.52830000E-04  +1.36850000E-04  -6.46300000E-05  -1.31570000E-04
   +1.83790000E-04  +3.74640000E-04  -6.43400000E-04  +4.03190000E-04  -4.56810000E-04
   +4.39960000E-04  -2.43000000E-05  +2.00100000E-05  +7.63600000E-05  +9.82270000E-04
   +4.77520000E-04  +1.30968000E-03  -4.50170000E-04  +1.52200000E-05  +1.40820000E-04
   -7.80840000E-04  +5.60650000E-04  -2.28540000E-04  -4.11331000E-03  +1.90253000E-03
   +3.26702000E-03  -1.40493000E-03  -3.14345000E-03  -5.69063000E-03  -2.26624000E-03
   +6.05682000E-03  -1.14151000E-03  -1.26745330E-01  -1.60735650E-01  -1.86008100E-02
   -4.49196400E-02  -3.69855700E-02  -8.24371000E-03  +7.47394000E-03  +1.17764000E-03
   -5.56724000E-03  +7.34275700E-02  +5.33902460E-01  +1.79430000E-04  +5.56600000E-05
   -1.73920000E-04  -1.32500000E-05  -8.55900000E-05  +1.56300000E-04  +2.09400000E-05
   +2.72900000E-05  +1.95100000E-05  -2.31000000E-06  +4.38000000E-05  -5.34300000E-05
   +1.81900000E-05  -3.95300000E-05  +3.01200000E-05  -1.49900000E-05  -6.00000000E-06
   +6.50000000E-06  -1.89410000E-04  +4.06540000E-04  -1.66570000E-04  -2.89400000E-05
   -2.66100000E-05  -1.88300000E-05  -5.26900000E-05  +3.44500000E-05  -6.05000000E-06
   -2.76056000E-03  +3.27772000E-03  +1.71245000E-03  +1.57772000E-03  -8.36703000E-03
   +1.69328000E-03  +2.07411200E-02  +1.24341800E-02  +8.41993000E-03  +3.11773000E-03
   -3.66477500E-02  -6.66545000E-02  -2.46783900E-02  -2.15082300E-02  +4.66705000E-03
   +7.38007000E-03  -3.23048000E-03  +1.47300000E-04  -8.69551100E-02  +2.79651990E-01
   +2.33734450E-01  -5.73787000E-03  +2.39415000E-03  +1.14823000E-03  -1.12596000E-03
   +1.42079200E-02  -2.73149500E-02  -2.17790000E-03  +1.25647000E-03  -1.26010000E-03
   +4.27830000E-04  +3.65710000E-04  -1.20600000E-03  +1.48340000E-04  -1.74030000E-04
   +2.87260000E-04  +4.97360000E-04  +7.06710000E-04  -1.34055000E-03  -7.46546700E-02
   -2.50685000E-03  +6.17888000E-03  +3.45980000E-04  -1.00305000E-03  +3.53419000E-03
   -5.33350000E-04  +3.79330000E-04  -1.53540000E-04  -5.85626000E-03  -1.47307200E-02
   +2.46844600E-02  -4.96070000E-04  -6.06000000E-04  +1.01041000E-03  -3.01360000E-04
   +7.16400000E-04  -8.45100000E-05  +5.18240000E-04  +7.58420000E-04  +3.13780000E-04
   -9.53720000E-04  -1.17830000E-04  -1.40781000E-03  -3.83160000E-04  -1.73612000E-03
   -3.71640000E-04  -1.13853000E-03  -1.00717000E-03  -1.05230000E-04  +5.88447590E-01
   +2.76168000E-03  -3.31390000E-04  -6.07720000E-04  +3.95455000E-03  -1.05085600E-02
   +1.82954800E-02  +5.69160000E-04  -1.40587000E-03  +1.26710000E-04  -6.76890000E-04
   -1.03820000E-04  +4.99540000E-04  +1.31200000E-04  +7.53000000E-05  +1.45160000E-04
   -1.80780000E-04  -3.43940000E-04  +7.21250000E-04  +9.45140000E-04  -9.25042000E-02
   +3.96714000E-02  +1.75672000E-03  +8.85403000E-03  -2.31849200E-02  -1.04000000E-06
   -4.23200000E-05  +9.62000000E-06  -9.24976000E-03  -1.55188700E-02  +2.08088100E-02
   -9.23340000E-04  -4.73300000E-04  +1.17064000E-03  -2.63100000E-05  +7.69190000E-04
   -2.57720000E-04  +1.35910000E-04  +7.05550000E-04  +4.26750000E-04  -5.21320000E-04
   -4.15740000E-04  -1.06146000E-03  +1.33583000E-03  -1.12772000E-03  -2.75860000E-04
   -6.54480000E-04  -6.50200000E-04  -1.00690000E-04  -1.08553000E-03  +5.60572520E-01
   +6.06450000E-04  -4.87740000E-04  +1.98130000E-04  -5.63183000E-03  +5.53903000E-03
   -7.10547000E-03  +3.74690000E-04  -4.50410000E-04  +1.56400000E-05  +5.80630000E-04
   -1.73670000E-04  -2.53240000E-04  -1.91040000E-04  +1.29740000E-04  +9.57600000E-05
   +1.92670000E-04  +8.31600000E-05  -7.48700000E-05  +6.24140000E-04  +3.55982800E-02
   -1.52493200E-01  +2.71574000E-03  +5.17794000E-03  -3.64006800E-02  +2.72850000E-04
   -1.59110000E-04  +1.56400000E-05  +8.98712000E-03  +8.93331000E-03  -3.56996000E-03
   -1.43421000E-03  -1.38771000E-03  -4.40990000E-04  +1.80550000E-04  -1.02050000E-04
   -7.30900000E-05  +1.90790000E-04  +2.41100000E-04  +2.28500000E-04  -3.22400000E-05
   -2.04590000E-04  -5.76400000E-05  -1.23341000E-03  -2.33410000E-04  -2.01960000E-04
   -5.49720000E-04  -4.74570000E-04  -9.84600000E-05  -2.04294000E-03  +5.56340600E-02
   +4.88937990E-01  -2.20288090E-01  +3.75271500E-02  +9.36790700E-02  +2.11946000E-03
   -5.18492000E-03  +1.26720800E-02  +8.01900000E-05  +3.12213000E-03  -2.25200000E-03
   -1.09630000E-03  -2.04016000E-03  +3.26285000E-03  +2.21630000E-03  +6.28455000E-03
   -5.84001000E-03  -4.62658800E-02  +6.07172000E-03  +3.86235800E-02  -2.74726000E-03
   +1.29980000E-04  -1.86713000E-03  +1.20274000E-03  +3.60410000E-04  +1.50547000E-03
   -2.55712000E-03  +3.32800000E-04  +1.50686000E-03  -1.80681000E-03  -1.35581000E-03
   -2.38799000E-03  -3.29590000E-04  +1.88999000E-03  +2.54950000E-04  -2.00300000E-04
   -2.82500000E-05  +4.58700000E-05  +8.87890000E-04  +6.91000000E-06  -1.59400000E-05
   +8.71830000E-04  +6.92830000E-04  -3.12060000E-04  -2.54020000E-04  +5.12850000E-04
   -1.49291000E-03  -3.97610000E-04  -2.53730000E-04  -1.73990000E-04  +5.87180000E-04
   -1.30120000E-04  -1.77770000E-04  +3.23263040E-01  +9.22451000E-03  -7.35414200E-02
   +3.54119800E-02  -2.11240100E-02  +5.72645000E-03  +2.12683200E-02  +6.08501000E-03
   -1.15049000E-03  +3.89793000E-03  -1.92206000E-03  +1.51912000E-03  -3.08638000E-03
   +2.02205000E-03  +1.36620000E-03  +8.62300000E-03  +2.34519900E-02  +7.47615000E-03
   -1.48072400E-02  -1.81304000E-03  -1.67408000E-03  -1.94714000E-03  +1.97020000E-03
   -2.73005000E-03  -1.19772000E-03  +1.00348000E-03  +9.31500000E-05  -1.24652000E-03
   -7.43130000E-04  +3.58190000E-04  -2.12240000E-04  -4.05510000E-04  -2.74100000E-05
   -1.38000000E-06  +4.62290000E-04  +3.65490000E-04  -1.82600000E-04  -6.69000000E-05
   +2.02520000E-04  +1.75370000E-04  -4.02600000E-05  -1.06020000E-04  +8.56000000E-06
   +5.36420000E-04  -1.45040000E-04  +4.42200000E-05  +8.83600000E-05  +9.90700000E-05
   -3.68300000E-05  -1.66990000E-04  +3.62380000E-04  -5.81000000E-05  -1.11015450E-01
   +2.96122580E-01  +1.30940650E-01  +1.11093400E-02  -1.73780800E-01  +3.86792800E-02
   +8.27216000E-03  -3.96779400E-02  -6.97838000E-03  +5.77885000E-03  +3.51200000E-05
   +3.44955000E-03  -2.93963000E-03  +1.00245000E-03  +1.11316000E-03  +5.37118000E-03
   -2.02288000E-03  +9.36216000E-03  -7.44100000E-04  +2.77399000E-03  +2.62442000E-03
   -3.69963000E-03  +1.52544000E-03  -5.90310000E-04  +1.37488000E-03  -1.06356000E-03
   +1.82880000E-04  -5.86630000E-04  +7.05900000E-04  -1.54892000E-03  +1.11616000E-03
   -1.59431000E-03  +4.97000000E-05  +3.39240000E-04  -6.33430000E-04  -3.23340000E-04
   +1.17040000E-04  +5.04990000E-04  +2.66900000E-04  -6.14600000E-05  -1.62740000E-04
   -2.27900000E-04  -2.56630000E-04  +3.67070000E-04  -2.94160000E-04  -3.18320000E-04
   -7.47050000E-04  -5.10890000E-04  -3.59210000E-04  +8.83100000E-05  -2.44110000E-04
   +5.79000000E-06  +4.89570000E-04  -8.64577000E-02  -2.86984080E-01  +5.11399710E-01
   -7.57500000E-05  -5.98000000E-06  +2.92500000E-05  +4.71000000E-06  +3.01300000E-05
   -1.59700000E-05  -2.04100000E-05  +1.95400000E-05  +1.76100000E-05  -5.84700000E-05
   -1.44800000E-05  +9.13400000E-05  -7.89000000E-05  +4.97000000E-05  -3.52200000E-05
   +3.61700000E-05  +2.05200000E-05  -1.52200000E-05  -1.65800000E-04  +5.89700000E-05
   +8.87300000E-05  +6.99900000E-05  +1.97500000E-05  -1.70800000E-05  +1.12170000E-04
   -6.16700000E-05  +3.08800000E-05  -2.37360000E-04  +5.23170000E-04  +4.34750000E-04
   -6.29250000E-04  -2.20060000E-04  -1.35820000E-04  +1.57176000E-03  -1.86356000E-03
   -2.07909000E-03  +3.03561000E-03  -3.52442100E-02  -2.39124000E-02  -5.18700000E-03
   -3.52098000E-03  +8.36120000E-04  +1.50855000E-03  -7.88080000E-04  -4.00180000E-04
   -6.22909900E-02  +9.79588400E-02  +8.45791600E-02  +1.70200000E-05  -2.30500000E-05
   -1.57300000E-05  +8.92800000E-05  +3.85600000E-05  -1.21000000E-06  +6.36295200E-02
   -5.60100000E-05  +6.51000000E-06  -3.43000000E-06  +4.84000000E-06  +1.32950000E-04
   -1.21900000E-05  -2.63300000E-05  +1.54100000E-05  +2.49100000E-05  -4.44000000E-05
   -6.29800000E-05  +1.26970000E-04  -9.40400000E-05  +9.48000000E-05  -8.43200000E-05
   +1.48500000E-05  -1.03100000E-05  -1.67900000E-05  -2.09350000E-04  -7.16900000E-05
   -8.01100000E-05  +8.51600000E-05  -1.01000000E-05  -1.35600000E-05  +1.60890000E-04
   -1.20580000E-04  +4.64900000E-05  -9.81800000E-05  +6.03700000E-04  +3.72280000E-04
   +1.42980000E-04  -1.08506000E-03  -2.71950000E-04  +3.65769000E-03  +4.39118000E-03
   +1.66050000E-03  +4.70935000E-03  -2.81714700E-02  -1.74635000E-02  -4.92330000E-03
   -3.89300000E-05  +7.36430000E-04  +8.46130000E-04  -3.45810000E-04  -1.54819000E-03
   +5.48636500E-02  -3.43233980E-01  -2.31071320E-01  +1.13540000E-04  +6.30700000E-05
   +5.18200000E-05  +5.78400000E-05  -1.90100000E-05  +6.32000000E-05  -5.82350400E-02
   +3.67639390E-01  -1.14050000E-04  -2.48700000E-05  +1.12430000E-04  -6.60000000E-06
   +3.54600000E-05  -3.69200000E-05  -1.55500000E-05  +4.70000000E-07  -4.52000000E-06
   -2.03500000E-05  -1.19600000E-05  +2.74200000E-05  -2.02400000E-05  +1.07400000E-05
   +2.52000000E-06  +2.68000000E-05  +3.61000000E-06  -1.12700000E-05  -8.01800000E-05
   -3.36200000E-05  -1.37310000E-04  +2.24600000E-05  +5.10000000E-07  -1.08300000E-05
   +3.24200000E-05  -1.32600000E-05  +8.10000000E-07  +5.32200000E-05  +1.03330000E-04
   +1.84750000E-04  +7.02400000E-05  -1.97790000E-04  -7.96880000E-04  +1.26449000E-03
   +3.93234000E-03  +9.87510000E-04  +6.73970000E-04  -6.25010000E-04  -3.29799000E-03
   +4.68200000E-05  +1.77850000E-04  +2.09905000E-03  +6.21530000E-04  -8.48650000E-04
   +9.60270000E-04  +5.80326400E-02  -2.49268730E-01  -1.80266880E-01  +9.55200000E-05
   +7.24900000E-05  +4.29300000E-05  +1.27500000E-04  +4.49000000E-05  -5.76300000E-05
   -6.05899200E-02  +2.46934750E-01  +1.80576450E-01  -7.84000000E-06  -1.79800000E-05
   +1.81900000E-05  +1.17220000E-04  -2.95100000E-05  +3.03000000E-05  +1.51200000E-05
   -2.71000000E-06  -1.20500000E-05  -1.38100000E-05  +5.56700000E-05  -3.91500000E-05
   +1.21600000E-05  -4.17000000E-05  +3.71000000E-05  +8.97000000E-06  +3.22700000E-05
   -4.52000000E-06  +6.33980000E-04  -8.16680000E-04  -6.44570000E-04  -3.51090000E-04
   -1.25450000E-04  +8.42100000E-05  -5.29900000E-05  +5.53600000E-05  -1.10200000E-05
   -2.72540000E-03  -4.08669000E-03  +1.75064000E-03  +6.33005000E-03  -2.15366000E-02
   -1.44093100E-02  -5.92453500E-02  +1.41162400E-02  +1.88508500E-02  +2.65394000E-03
   +2.22827500E-02  +1.37653100E-02  -3.88055000E-03  +3.32480000E-04  +3.98804000E-03
   -1.64311000E-03  -4.60980000E-04  +2.83400000E-05  +2.31270000E-03  +1.91127000E-03
   -1.36295000E-03  +1.12600000E-05  +4.89800000E-05  -9.99700000E-05  -3.34000000E-06
   +4.49000000E-05  -1.91400000E-05  -1.06232000E-03  -1.12916000E-03  -5.05600000E-05
   +5.64908800E-02  +7.68900000E-05  +1.16800000E-05  -2.24800000E-05  +1.47200000E-04
   -1.07970000E-04  +6.37600000E-05  +1.54500000E-05  +1.27100000E-05  -1.42400000E-05
   +3.11200000E-05  +4.54600000E-05  -8.14800000E-05  +5.55400000E-05  -5.39700000E-05
   +4.11900000E-05  -1.73200000E-05  +1.39900000E-05  +1.29900000E-05  +4.91140000E-04
   -3.55200000E-04  -7.21900000E-04  -3.36680000E-04  -1.61520000E-04  +1.15110000E-04
   -1.07340000E-04  +7.63100000E-05  -2.48800000E-05  -4.55038000E-03  +1.37118000E-03
   -1.64199000E-03  +3.97964000E-03  -1.29194200E-02  -1.06778400E-02  +1.39435700E-02
   -2.48503970E-01  -1.33601810E-01  -4.85996000E-03  -5.52421000E-03  -3.71635000E-03
   +9.30210000E-04  +2.52611000E-03  -2.12852000E-03  -1.19890000E-04  +2.19610000E-04
   +7.12250000E-04  +1.29088000E-03  +1.85740000E-03  +2.92314000E-03  -6.23100000E-05
   -1.71200000E-05  -5.89600000E-05  -5.83900000E-05  -1.00100000E-05  -1.43600000E-05
   +1.36858000E-03  +1.34800000E-05  -8.81240000E-04  -1.28919500E-02  +2.62558610E-01
   -8.72000000E-05  -6.48500000E-05  +9.43100000E-05  -8.51400000E-05  -1.53800000E-05
   -1.99100000E-05  +3.59000000E-05  -3.57500000E-05  -4.08600000E-05  -1.01900000E-05
   +5.19200000E-05  -5.97000000E-05  +1.62300000E-05  -5.12800000E-05  +7.34400000E-05
   +3.01900000E-05  +2.37400000E-05  -6.11000000E-06  +3.83320000E-04  -1.67770000E-04
   +2.04600000E-04  -5.70100000E-05  +5.15000000E-05  +3.99000000E-06  -5.98800000E-05
   +6.17300000E-05  -2.35000000E-05  +1.28574000E-03  -2.14176000E-03  +5.61625000E-03
   +7.37500000E-04  -2.07900000E-04  +1.88080000E-03  +1.87435700E-02  -1.33658660E-01
   -1.19812980E-01  -2.32351000E-03  -1.46346900E-02  -3.72863000E-03  +4.31161000E-03
   -1.91630000E-03  +2.59106000E-03  +2.06300000E-04  +8.48560000E-04  -4.94600000E-04
   -1.78515000E-03  +2.67748000E-03  -1.62308000E-03  -2.65100000E-05  +0.00000000E+00
   -6.59800000E-05  +6.57600000E-05  +8.90000000E-05  -5.58100000E-05  +1.45227000E-03
   +9.61400000E-05  +5.43800000E-05  -2.10215600E-02  +1.47421960E-01  +1.19002060E-01
   -2.01050000E-04  -3.07510000E-04  -2.44850000E-04  -5.42860000E-04  -1.00568000E-03
   -6.90770000E-04  -3.09500000E-04  -2.86130000E-04  -2.22070000E-04  -1.34100000E-04
   +7.73600000E-05  +9.34500000E-05  -1.14090000E-04  +1.07530000E-04  +2.06100000E-05
   +1.70910000E-04  -2.73100000E-05  +3.59700000E-05  -8.51950000E-04  -3.55200000E-05
   -9.08280000E-04  +2.50800000E-05  +1.09260000E-04  -1.22430000E-04  +1.08290000E-04
   -9.39200000E-05  +1.85300000E-05  +1.65241000E-03  +1.07940000E-04  +9.63640000E-04
   -2.53510890E-01  +5.55409900E-02  +1.17866450E-01  -1.63601600E-02  +7.80296000E-03
   +1.26785000E-02  -5.59320000E-04  -4.61087000E-03  +5.36070000E-04  +1.66600000E-04
   -3.44150000E-04  -7.60000000E-04  +1.93870000E-03  -6.36530000E-04  +1.31980000E-03
   -1.50463000E-03  +4.00400000E-05  +5.79140000E-04  -2.14800000E-05  +7.66000000E-06
   +1.74730000E-04  -2.30500000E-05  +9.21900000E-05  +1.86990000E-04  +8.71700000E-05
   +2.36090000E-04  +1.05940000E-04  +3.63980000E-04  +5.93980000E-04  -1.46963000E-03
   +2.69286810E-01  +1.61530000E-04  +3.44130000E-04  -7.70210000E-04  -2.48710000E-04
   -1.67780000E-04  -4.43500000E-05  -3.36250000E-04  -4.82000000E-06  +1.43000000E-06
   -1.88250000E-04  +1.50000000E-06  +1.62130000E-04  -1.62350000E-04  +7.11900000E-05
   +7.87000000E-06  +1.31830000E-04  -1.48770000E-04  +1.95100000E-05  +1.34411000E-03
   -2.04560000E-04  +1.23029000E-03  +5.27600000E-05  +6.68800000E-05  +8.11200000E-05
   +2.37870000E-04  -1.86330000E-04  +6.73100000E-05  +2.34923600E-02  -6.14120000E-04
   -1.22948100E-02  +5.58092700E-02  -7.33641300E-02  -4.20861800E-02  -1.77919000E-02
   +8.21154000E-03  +9.74675000E-03  -4.19569000E-03  -3.97780000E-04  -3.17586000E-03
   -4.86650000E-04  -1.05718000E-03  +2.85140000E-04  -1.20959000E-03  -3.10404000E-03
   -5.27125000E-03  -1.06634000E-03  +1.51580000E-04  +5.16210000E-04  -1.10650000E-04
   -5.53140000E-04  -3.29130000E-04  -3.90640000E-04  -1.53350000E-04  +3.65250000E-04
   +5.21000000E-05  +1.28310000E-04  +8.43200000E-05  +1.09351000E-03  -3.30670000E-04
   +1.97719000E-03  -5.73717000E-02  +7.17180200E-02  +1.90050000E-04  +1.23500000E-04
   -4.99660000E-04  -8.05900000E-05  -3.42700000E-04  +1.61020000E-04  -4.68930000E-04
   +3.19660000E-04  +2.66430000E-04  -1.60520000E-04  -1.04300000E-04  +2.46360000E-04
   -2.24830000E-04  +8.05800000E-05  -1.11830000E-04  -3.62200000E-05  +1.79370000E-04
   -9.78700000E-05  -7.01500000E-05  +1.67186000E-03  -2.13808000E-03  -2.60140000E-04
   +2.08000000E-06  -8.13600000E-05  +3.07310000E-04  -1.69380000E-04  +8.01200000E-05
   +1.45541100E-02  -3.20898000E-03  -3.18350000E-03  +1.17266340E-01  -4.14658800E-02
   -1.09633600E-01  -2.10944000E-03  -5.52560000E-04  +4.19075000E-03  +8.09180000E-04
   -2.88681000E-03  +5.86511000E-03  -9.37280000E-04  +1.56960000E-04  -7.63370000E-04
   +1.36867000E-03  -5.59301000E-03  +2.76613000E-03  +5.91400000E-05  +9.97900000E-05
   +4.81300000E-05  +4.56000000E-06  +1.42320000E-04  +5.87300000E-05  -2.14430000E-04
   +9.38700000E-05  +1.93150000E-04  -2.97900000E-05  -9.77000000E-06  -3.49300000E-05
   -1.27807000E-03  +2.19673000E-03  -2.64427000E-03  -1.29569660E-01  +4.88196200E-02
   +1.06509370E-01  -1.35200000E-04  +7.53000000E-06  +2.38670000E-04  -7.85100000E-05
   -1.28080000E-04  -2.32700000E-04  -1.65900000E-05  -2.50400000E-05  -1.98300000E-05
   +1.48200000E-05  -3.17700000E-05  +7.36600000E-05  -3.19600000E-05  +5.07400000E-05
   -3.35200000E-05  +4.61200000E-05  -1.77200000E-05  -3.56200000E-05  +4.30340000E-04
   +1.17918000E-03  -9.67890000E-04  -2.48407000E-03  -1.07777000E-03  +4.76530000E-04
   +8.01300000E-05  -6.00100000E-05  +1.46000000E-05  +4.12268000E-03  +2.21963800E-02
   +1.37751000E-02  -4.03951000E-03  +3.00510000E-04  +4.46057000E-03  -1.33427000E-03
   -3.41770000E-04  -1.10330000E-04  -2.51482000E-03  -3.96616000E-03  +1.96261000E-03
   +5.44157000E-03  -2.20570100E-02  -1.40120000E-02  -6.01602100E-02  +1.60629900E-02
   +1.83226700E-02  +2.51250000E-04  -1.08571000E-03  -7.35170000E-04  +1.82640000E-04
   -3.58500000E-05  -4.25000000E-05  +1.58910000E-04  -1.77190000E-04  -1.10870000E-04
   -2.94490000E-04  -2.45970000E-04  -9.51900000E-05  -1.65000000E-06  +1.41550000E-04
   -2.04450000E-04  +2.91600000E-05  +1.29039000E-03  +7.65180000E-04  +6.18772800E-02
   +2.95260000E-04  +7.39500000E-05  -4.04520000E-04  +2.68650000E-04  +2.73560000E-04
   -1.14010000E-04  +6.36900000E-05  -4.60700000E-05  +5.36800000E-05  -7.52000000E-06
   -3.64000000E-05  +4.44300000E-05  -1.10000000E-05  +3.25900000E-05  -6.25600000E-05
   -1.05260000E-04  +2.53000000E-05  +6.15800000E-05  +3.32600000E-05  -1.77166000E-03
   +1.21143000E-03  -2.69343000E-03  -1.05933000E-03  +2.50700000E-04  +3.69600000E-05
   -2.93500000E-05  +2.84800000E-05  -3.46800000E-05  -2.23182000E-03  -4.22091000E-03
   +4.36690000E-04  +2.44215000E-03  -2.78773000E-03  -1.46640000E-04  +2.32780000E-04
   +8.46940000E-04  -4.15995000E-03  +1.84953000E-03  -2.13710000E-03  +3.22540000E-03
   -1.24273900E-02  -1.12251600E-02  +1.65237700E-02  -2.51156350E-01  -1.36531150E-01
   -3.61900000E-05  -1.04965000E-03  -6.67490000E-04  -2.72330000E-04  -1.65060000E-04
   +5.53200000E-05  -3.93100000E-04  +2.54600000E-05  +3.20730000E-04  -1.52750000E-04
   -1.75440000E-04  +7.13800000E-05  +1.09090000E-04  -2.49790000E-04  +2.51000000E-04
   -1.05310000E-04  -2.49100000E-04  -6.45800000E-05  -1.13008300E-02  +2.67143540E-01
   -2.08450000E-04  -7.21400000E-05  +2.15330000E-04  -2.74570000E-04  -1.28370000E-04
   +1.17290000E-04  -6.49000000E-05  +6.10400000E-05  -3.59800000E-05  +2.58000000E-06
   +2.87400000E-05  -2.14700000E-05  +2.47000000E-06  -2.58900000E-05  +2.30700000E-05
   +4.07200000E-05  -5.17000000E-06  -2.67200000E-05  -1.81246000E-03  +5.50030000E-04
   -2.61604000E-03  -3.82980000E-04  -8.35110000E-04  +6.16960000E-04  -2.83400000E-05
   +3.38300000E-05  -1.49600000E-05  -6.99500000E-05  -1.30197800E-02  -3.51060000E-03
   +4.47135000E-03  -2.42282000E-03  +3.29331000E-03  -5.64100000E-05  +8.43580000E-04
   -5.32480000E-04  +1.90795000E-03  -2.18898000E-03  +5.89740000E-03  +1.44137000E-03
   -6.33520000E-04  +3.03096000E-03  +1.86579800E-02  -1.37151410E-01  -1.30972740E-01
   -1.03050000E-04  -1.87940000E-04  -1.84900000E-05  +7.36980000E-04  +2.54880000E-04
   +4.64100000E-05  +3.33250000E-04  +3.51800000E-05  -9.29900000E-05  -3.53500000E-05
   +1.11370000E-04  -1.06890000E-04  -2.30910000E-04  +2.25150000E-04  -4.92170000E-04
   -3.25900000E-05  -6.41270000E-04  -3.73260000E-04  -2.16451400E-02  +1.51978310E-01
   +1.28536390E-01  -8.15400000E-05  -7.67000000E-06  +1.55780000E-04  -4.96800000E-05
   -2.12910000E-04  +6.29500000E-05  -4.01000000E-05  +3.70100000E-05  -3.66700000E-05
   +1.85800000E-05  +4.19100000E-05  -5.64700000E-05  +3.80600000E-05  -4.74300000E-05
   +4.33500000E-05  +1.43700000E-05  +5.10000000E-06  -1.06500000E-05  -3.03090000E-04
   +6.66190000E-04  +5.86300000E-04  -3.60100000E-05  +9.06100000E-05  +3.30600000E-05
   -7.72000000E-05  +5.48300000E-05  -2.81900000E-05  -1.08664000E-03  -4.66416000E-03
   +7.10180000E-04  +1.78820000E-04  -3.77310000E-04  -7.50010000E-04  +1.79114000E-03
   -6.40300000E-04  +1.18793000E-03  +3.74960000E-04  -2.23853000E-03  +6.11880000E-04
   -2.59354040E-01  +5.24456600E-02  +1.22898210E-01  -1.51607000E-02  +7.86243000E-03
   +1.19322100E-02  +4.88430000E-04  +8.47440000E-04  -1.13837000E-03  -1.65350000E-04
   -8.02700000E-05  -9.39000000E-05  +1.04110000E-04  +1.60800000E-05  -1.81630000E-04
   -3.37600000E-05  +8.85300000E-05  -1.64300000E-04  +9.38100000E-05  -3.30100000E-05
   -7.01900000E-05  -1.28380000E-04  +1.60040000E-04  -1.34910000E-04  +2.81680000E-04
   +6.69570000E-04  -1.55749000E-03  +2.73208090E-01  -3.55800000E-05  +1.86000000E-06
   -8.00000000E-07  -1.85960000E-04  -2.10200000E-04  +4.73000000E-05  -4.05000000E-06
   +1.32500000E-05  -1.62500000E-05  -6.91000000E-06  +4.87800000E-05  -2.86600000E-05
   +3.98000000E-06  -2.45600000E-05  +3.83200000E-05  +1.80700000E-05  -9.24000000E-06
   -2.83000000E-06  -5.92500000E-04  +5.08070000E-04  +2.58240000E-04  +4.56000000E-05
   +7.00100000E-05  +4.77200000E-05  -3.37000000E-05  +2.68200000E-05  -9.43000000E-06
   -4.23054000E-03  -2.83840000E-04  -2.75526000E-03  -6.44790000E-04  -1.32790000E-03
   +1.22290000E-04  -1.20215000E-03  -3.14039000E-03  -4.73146000E-03  +2.43401600E-02
   -1.93420000E-04  -1.31983800E-02  +5.10796200E-02  -6.94730200E-02  -4.14389100E-02
   -1.70330300E-02  +8.49729000E-03  +1.05487200E-02  +5.56610000E-04  +8.97260000E-04
   +2.45260000E-03  -5.32200000E-05  +1.38200000E-05  -6.43700000E-05  +9.66000000E-06
   -1.30900000E-05  +1.35500000E-05  +8.83000000E-06  +1.94100000E-04  +4.45600000E-04
   +1.19281000E-03  -2.96100000E-04  -6.31790000E-04  +1.22830000E-04  -9.23900000E-05
   +2.99030000E-04  +1.17486000E-03  -3.77870000E-04  +2.02221000E-03  -5.45503800E-02
   +6.52260900E-02  -2.74400000E-05  -1.71000000E-06  +8.24200000E-05  +1.40890000E-04
   +7.24500000E-05  -1.12600000E-05  -2.74900000E-05  +2.02600000E-05  +1.16600000E-05
   -1.20000000E-06  -2.88300000E-05  +3.32300000E-05  -1.16800000E-05  +1.83300000E-05
   -3.15400000E-05  -3.00000000E-07  +1.63600000E-05  -1.03600000E-05  -7.50200000E-05
   -6.53100000E-05  +3.11350000E-04  +6.60000000E-07  +3.93100000E-05  -5.56500000E-05
   +3.29200000E-05  -2.13400000E-05  +7.05000000E-06  +6.18630000E-04  -2.59813000E-03
   +5.46980000E-03  -9.83790000E-04  -7.45500000E-05  -7.35170000E-04  +9.18440000E-04
   -4.95760000E-03  +2.25972000E-03  +1.65260000E-02  -2.18462000E-03  -2.83197000E-03
   +1.22019360E-01  -4.21451700E-02  -1.10313280E-01  -2.82261000E-03  +3.28850000E-04
   +3.87805000E-03  -1.32297000E-03  +2.30195000E-03  -1.64047000E-03  -1.36200000E-05
   -6.97400000E-05  +3.27000000E-06  +6.36400000E-05  +3.54000000E-06  -8.05700000E-05
   -2.17570000E-04  +4.07750000E-04  -2.23810000E-04  +6.65740000E-04  -1.43520000E-04
   -3.82120000E-04  -1.36740000E-04  +2.88630000E-04  -4.66380000E-04  -1.26013000E-03
   +2.30797000E-03  -2.64207000E-03  -1.34086730E-01  +4.65761500E-02  +1.07366060E-01
   -1.04030000E-04  -4.82700000E-05  +4.76840000E-04  +6.17930000E-04  -2.82630000E-04
   +4.82330000E-04  -3.38670000E-04  +2.77200000E-05  +4.61040000E-04  +3.77000000E-04
   +8.65000000E-05  -3.80480000E-04  +1.72200000E-05  -3.87700000E-05  +5.14200000E-05
   -3.99600000E-05  +2.84800000E-05  -7.03200000E-05  -2.20890000E-04  -9.67120000E-04
   +1.05214000E-03  +3.48500000E-05  -2.09480000E-04  +4.84330000E-04  -1.51140000E-04
   +1.26310000E-04  -9.19500000E-05  +9.04490000E-04  -1.35097000E-03  +3.71570000E-04
   +2.51600000E-04  +3.38560000E-04  +2.34690000E-04  -2.00550000E-04  -2.77400000E-05
   -5.01600000E-05  +5.95600000E-05  -1.11840000E-04  -1.32290000E-04  +1.04540000E-04
   +1.09440000E-04  -3.02800000E-05  +1.64960000E-04  +1.13980000E-04  +1.42110000E-04
   +4.36800000E-05  +2.62600000E-05  +2.98800000E-05  -2.51289510E-01  +1.12733250E-01
   -3.44219700E-02  +2.75660000E-04  -2.15000000E-06  -2.42130000E-04  -8.65000000E-06
   +1.26000000E-06  -7.31000000E-06  -6.26000000E-06  +1.31000000E-05  -6.06000000E-06
   +2.54800000E-05  -5.78400000E-05  +2.83900000E-05  +2.66400000E-05  +3.94300000E-05
   -8.02000000E-06  +2.12800000E-05  +1.34500000E-05  +6.12000000E-06  +2.69867170E-01
   +1.20428000E-03  +3.41800000E-05  -3.16500000E-04  -7.44910000E-04  -6.94230000E-04
   +2.86468000E-03  -3.52090000E-04  +3.34350000E-04  +2.76600000E-04  +1.19700000E-05
   +5.92700000E-05  +1.51930000E-04  -1.40810000E-04  +8.91500000E-05  -4.07400000E-05
   -6.82700000E-05  -1.78200000E-04  +2.19740000E-04  +1.23908900E-02  -9.01193000E-03
   +2.51699000E-03  -4.91590000E-04  +2.40030000E-04  -1.21901000E-03  +1.91090000E-04
   -1.35270000E-04  +3.65200000E-05  +1.08628000E-03  +4.84650000E-04  +8.28000000E-06
   +3.08000000E-06  -4.65000000E-04  -5.08360000E-04  +1.12380000E-04  +5.27200000E-05
   -4.24300000E-05  -2.46000000E-04  -5.57700000E-05  +1.14290000E-04  -2.11620000E-04
   -8.07500000E-05  +3.80000000E-07  -2.60910000E-04  +1.49250000E-04  -8.85000000E-06
   +1.73560000E-04  +1.64340000E-04  -2.70000000E-07  +1.11044140E-01  -1.07889500E-01
   +1.77989500E-02  -2.75940000E-04  -5.84000000E-06  +1.74730000E-04  -4.89000000E-06
   -3.73400000E-05  +9.30000000E-07  +1.37800000E-05  -6.70000000E-07  +1.71200000E-05
   -6.33000000E-06  +1.57640000E-04  +1.24600000E-04  +2.97500000E-05  -1.17100000E-05
   +6.84100000E-05  +6.26000000E-06  -8.91000000E-06  +4.79000000E-06  -1.22263500E-01
   +1.15231550E-01  -1.74183000E-03  +7.86290000E-04  +4.24760000E-04  +1.38045000E-03
   +2.03762000E-03  -5.26426000E-03  +1.18879000E-03  -2.88600000E-05  -5.01770000E-04
   -2.71450000E-04  +1.11590000E-04  +1.51640000E-04  +1.55620000E-04  -1.50150000E-04
   +6.83500000E-05  +1.84500000E-04  +1.75170000E-04  -4.24800000E-04  -2.51946000E-02
   +1.46719100E-02  -6.63910000E-03  -1.37696000E-03  +1.04610000E-03  +1.13483000E-03
   -1.69370000E-04  +8.33200000E-05  +5.49000000E-06  -1.02467000E-03  -5.65690000E-04
   +4.55310000E-04  +4.72290000E-04  +2.11060000E-04  +9.54300000E-05  -5.06350000E-04
   -4.28700000E-05  +3.67100000E-05  +2.97840000E-04  -1.05310000E-04  -2.43600000E-04
   +2.52900000E-04  +1.82460000E-04  -1.10400000E-05  -1.19930000E-04  -8.57200000E-05
   +2.47180000E-04  -2.06270000E-04  -1.56630000E-04  +3.70000000E-06  -3.22672000E-02
   +1.68042800E-02  -5.09196300E-02  +1.61970000E-04  -7.48800000E-05  -6.28100000E-05
   +1.35400000E-05  +2.30200000E-05  +1.56300000E-05  +7.82000000E-06  -1.48700000E-05
   +2.96000000E-06  +1.31200000E-05  -2.07200000E-05  +4.84900000E-05  +3.95500000E-05
   -2.63200000E-05  -1.18340000E-04  -7.40000000E-07  +1.37200000E-05  +1.20000000E-05
   +3.56832700E-02  -2.22533200E-02  +5.84100300E-02  +1.12080000E-04  -1.91130000E-04
   +2.89600000E-05  +9.79100000E-05  +1.50090000E-04  +1.20440000E-04  -8.18400000E-04
   +1.23982000E-03  +1.92800000E-04  +1.88960000E-04  +1.82900000E-05  -1.11040000E-04
   -1.09270000E-04  +1.64300000E-05  -5.40300000E-05  -1.33400000E-05  +2.49000000E-05
   +2.09300000E-05  -1.00357000E-03  +3.89540000E-04  -4.07610000E-04  +2.22880000E-04
   +1.52820000E-04  -3.99690000E-04  +7.46100000E-05  -3.61600000E-05  -5.83000000E-06
   +5.50850000E-04  -8.17480000E-04  +9.23590000E-04  +2.40780000E-04  +5.65270000E-04
   +4.39480000E-04  -4.18410000E-04  -3.03500000E-05  +2.35300000E-05  +4.15430000E-04
   +8.41100000E-05  -1.32560000E-04  +7.22800000E-05  +3.94200000E-05  -4.71400000E-05
   +4.33420000E-04  -2.65730000E-04  -5.13400000E-05  -3.49740000E-04  -2.75650000E-04
   -4.50000000E-06  -1.93698400E-01  -1.31398980E-01  +9.29764000E-03  +7.82700000E-05
   +9.19400000E-05  +3.11500000E-05  +2.11200000E-05  +5.21700000E-05  +1.53200000E-05
   -3.06900000E-05  -2.30400000E-05  -2.55800000E-05  +3.15300000E-05  -7.48900000E-05
   +1.48800000E-05  -5.30200000E-05  +5.53200000E-05  -5.53000000E-06  -2.47600000E-05
   -6.87000000E-06  +7.07000000E-06  -1.88694600E-02  -1.93725700E-02  +1.18651000E-03
   +2.10597340E-01  -1.15030000E-04  -9.22800000E-05  +4.91240000E-04  -6.37180000E-04
   +4.22070000E-04  -4.22040000E-04  -2.15190000E-04  -1.45810000E-04  +7.24030000E-04
   +4.70160000E-04  +9.05500000E-05  -4.16610000E-04  -6.29900000E-05  -2.44900000E-05
   -1.01000000E-05  -4.90600000E-05  +7.54400000E-05  -9.41400000E-05  -1.03481600E-02
   -9.72101000E-03  -5.48640000E-04  +3.46040000E-04  +4.35510000E-04  -1.37054000E-03
   -6.48000000E-05  +9.94400000E-05  -8.70200000E-05  -3.25840000E-04  -4.87250000E-04
   +3.23423000E-03  -4.17190000E-04  -1.63180000E-04  +2.90300000E-04  +3.67180000E-04
   +1.98460000E-04  +3.39300000E-05  +1.72300000E-05  +6.33410000E-04  +4.11720000E-04
   -5.40550000E-04  -5.35960000E-04  -3.61050000E-04  +6.96540000E-04  -3.07950000E-04
   -1.76450000E-04  -4.18080000E-04  -3.80700000E-04  -8.08000000E-05  -1.30351170E-01
   -1.65660870E-01  +8.21626000E-03  +3.39400000E-04  +8.13500000E-05  -3.24740000E-04
   +2.16500000E-05  +5.09500000E-05  +2.80700000E-05  -1.25800000E-05  -5.08700000E-05
   -1.36600000E-05  -7.03200000E-05  +1.79150000E-04  -1.74480000E-04  +1.84200000E-05
   +2.30000000E-06  +1.33820000E-04  -7.18100000E-05  -6.91000000E-06  -4.71000000E-05
   +1.18929000E-02  +1.15533500E-02  -1.10755000E-03  +1.43429280E-01  +1.77972260E-01
   +9.25500000E-05  -5.11400000E-05  -4.10200000E-04  +4.26310000E-04  -6.77410000E-04
   +8.36560000E-04  -4.71710000E-04  +3.23000000E-05  +3.77230000E-04  -1.08210000E-04
   +5.31100000E-05  -7.20800000E-05  -1.15500000E-04  -6.56000000E-06  +1.34840000E-04
   +1.30960000E-04  -5.89600000E-05  +2.06100000E-05  +2.23799900E-02  +1.88241000E-02
   -2.10432000E-03  +8.50870000E-04  +1.05925000E-03  +1.49410000E-03  +7.34500000E-05
   -4.41000000E-05  -6.27000000E-06  -7.82690000E-04  +1.61200000E-03  -4.73509000E-03
   +1.49440000E-04  -2.30890000E-04  +6.92900000E-05  +5.76820000E-04  -5.53900000E-05
   +1.65130000E-04  -4.23380000E-04  -9.72300000E-05  +6.98200000E-05  +1.50500000E-04
   -1.10430000E-04  +3.62840000E-04  +5.07190000E-04  +6.07770000E-04  +1.13990000E-04
   +4.84770000E-04  +4.26630000E-04  +1.07400000E-05  +8.96550000E-03  +7.00191000E-03
   -4.89811400E-02  -1.03200000E-04  -7.70700000E-05  +1.00590000E-04  +2.10000000E-07
   -4.59700000E-05  -4.23800000E-05  +3.31800000E-05  +4.36900000E-05  +1.83100000E-05
   -2.26520000E-04  +2.90120000E-04  -1.54040000E-04  -1.39800000E-05  +7.47000000E-05
   -2.06980000E-04  +6.91800000E-05  +2.97100000E-05  -1.97000000E-06  -2.92737000E-03
   -3.33154000E-03  -6.99040000E-04  -1.05140200E-02  -1.07072400E-02  +5.20486700E-02
   +1.93060000E-04  +5.45300000E-05  -1.76510000E-04  +2.46500000E-04  -4.64850000E-04
   -1.99270000E-04  -3.41050000E-04  +1.29760000E-04  -8.05310000E-04  -1.58020000E-04
   -2.59000000E-05  +2.61320000E-04  +1.82000000E-06  +3.75800000E-05  -4.67200000E-05
   -7.06000000E-06  -3.93900000E-05  +5.28300000E-05  -1.97526000E-03  +3.02200000E-04
   +1.43180000E-04  -5.38000000E-05  -9.72100000E-05  +1.44330000E-04  +9.00900000E-05
   -8.43100000E-05  +6.23600000E-05  +1.12630000E-04  +7.80910000E-04  +4.46190000E-04
   -5.32000000E-06  -1.05110000E-04  -4.44700000E-05  -3.23580000E-04  -1.06200000E-04
   -9.51300000E-05  +3.61300000E-05  -1.96300000E-04  -9.96500000E-05  +1.52480000E-04
   +1.52310000E-04  +7.11600000E-05  -3.17740000E-04  -5.86200000E-05  +1.10270000E-04
   +6.44000000E-05  +5.92600000E-05  -1.99000000E-06  -5.01307300E-02  +1.91357700E-02
   +2.15208400E-02  -2.07990000E-04  -8.70400000E-05  +1.75940000E-04  -1.19200000E-05
   -2.28900000E-05  +1.07900000E-05  +1.36100000E-05  -9.09000000E-06  +2.43900000E-05
   +1.99350000E-04  -1.49000000E-04  +1.31140000E-04  +5.50800000E-05  -9.10000000E-06
   -7.49300000E-05  +1.82000000E-06  +5.16000000E-06  -7.39000000E-06  -2.37730000E-03
   +1.86566000E-02  +2.12116800E-02  +3.07203000E-03  -1.56507200E-02  -1.83912000E-02
   +5.22899200E-02  -2.21610000E-04  -3.24700000E-05  -3.13400000E-05  +6.73300000E-05
   +5.87480000E-04  -4.39130000E-04  +1.12756000E-03  +2.27150000E-04  -9.03600000E-05
   -1.86650000E-04  -2.09800000E-05  +2.47180000E-04  +1.09250000E-04  -6.34400000E-05
   -9.79700000E-05  -3.90800000E-05  +2.09300000E-05  +3.09600000E-05  -2.25243000E-03
   +9.42313000E-03  +1.07568000E-02  -5.73400000E-05  -6.35080000E-04  +2.07589000E-03
   -6.68000000E-05  +1.15200000E-05  +3.35300000E-05  +1.53320000E-04  +9.46800000E-04
   +2.36890000E-04  -4.44480000E-04  -1.23940000E-04  +5.72890000E-04  +1.05680000E-04
   -1.08330000E-04  -4.16800000E-05  -3.99500000E-05  -5.04600000E-05  -6.12200000E-05
   +2.02900000E-05  +7.54700000E-05  +9.09500000E-05  +1.98700000E-05  -3.19700000E-05
   -9.01400000E-05  +1.43280000E-04  +1.02380000E-04  +1.17000000E-05  +1.91688300E-02
   -1.70822530E-01  -1.33250370E-01  -5.00200000E-05  +4.84200000E-05  +2.15900000E-05
   -1.22900000E-05  -1.46400000E-05  -1.40900000E-05  +4.16000000E-06  +1.08700000E-05
   +2.09800000E-05  +5.40000000E-07  -5.49820000E-04  +2.72700000E-04  -8.98000000E-06
   -4.48000000E-06  +2.46200000E-05  +8.45000000E-06  +9.50000000E-07  -5.34000000E-06
   +2.78730000E-04  -1.01706000E-02  -1.04667200E-02  +4.15791000E-03  -1.32693100E-02
   -1.43033000E-02  -2.22011600E-02  +1.83700170E-01  +2.24450000E-04  +4.15270000E-04
   -4.76740000E-04  +9.67100000E-04  -9.59280000E-04  +1.22560000E-03  +3.32580000E-04
   +1.94880000E-04  +1.70800000E-05  -4.00170000E-04  +2.09970000E-04  +2.23480000E-04
   -5.36100000E-05  -1.34060000E-04  +1.77160000E-04  +1.74520000E-04  -1.40010000E-04
   +4.48100000E-05  +3.44780000E-03  -2.02910100E-02  -1.98669000E-02  +4.32460000E-04
   +4.20130000E-03  -5.56240000E-03  +1.20100000E-05  -2.54900000E-05  +2.83300000E-05
   -1.74432000E-03  -9.02350000E-04  +7.69340000E-04  +1.86250000E-04  -6.56660000E-04
   +3.73100000E-05  +5.76580000E-04  +4.06310000E-04  +1.91900000E-04  -3.28710000E-04
   +4.85760000E-04  +3.79640000E-04  -4.42380000E-04  -5.01640000E-04  -1.52720000E-04
   +9.41550000E-04  +7.80900000E-05  -1.56430000E-04  -8.46900000E-05  -6.07500000E-05
   -3.21900000E-05  +2.17888000E-02  -1.30883120E-01  -1.89208240E-01  -1.88450000E-04
   +1.13970000E-04  +3.35230000E-04  +2.26700000E-05  +1.50100000E-05  +3.64000000E-06
   +4.14300000E-05  +6.10000000E-07  -1.20000000E-07  -2.24230000E-04  +5.95450000E-04
   -5.74200000E-05  -1.37800000E-04  +3.07800000E-05  +5.79600000E-05  -5.08000000E-06
   +1.09600000E-05  -2.53800000E-05  -4.74450000E-04  +3.92288000E-03  +3.92850000E-03
   -5.40060000E-04  +2.34555000E-03  +1.86761000E-03  -2.37124400E-02  +1.43098260E-01
   +2.07074670E-01  -9.45910000E-04  +5.40030000E-04  +1.00240000E-03  +1.96260000E-04
   -4.19870000E-04  +2.08570000E-04  -2.66500000E-04  +5.22300000E-05  +1.12200000E-05
   +1.29940000E-04  -7.93800000E-05  +8.74500000E-05  -3.85600000E-05  +8.80600000E-05
   -8.31000000E-05  -9.58000000E-06  +6.68000000E-06  -5.81800000E-05  -1.90922000E-03
   -1.14380000E-03  +1.71238000E-03  -5.27096500E-02  -1.16902400E-02  +3.05549200E-02
   +6.54000000E-05  -5.27600000E-05  -3.19000000E-06  +1.85920000E-04  +2.59150000E-04
   -5.39360000E-04  -7.89800000E-05  -2.80400000E-05  -6.15500000E-05  +1.06050000E-04
   +9.56300000E-05  +1.77900000E-05  -8.01800000E-05  -2.16800000E-05  +1.41700000E-05
   -1.16850000E-04  +7.62600000E-05  +1.94040000E-04  +1.94880000E-04  -4.64990000E-04
   -4.79840000E-04  +9.54100000E-05  +1.20060000E-04  +2.51000000E-05  -7.13900000E-05
   +3.13360000E-04  +6.00000000E-06  +2.35300000E-04  -1.26600000E-05  -6.66910000E-04
   -7.54000000E-06  -1.18500000E-05  -2.68000000E-06  +1.28600000E-05  +1.22100000E-05
   +2.00600000E-05  -1.61500000E-05  +4.40900000E-05  +3.50000000E-05  -9.56170000E-04
   +1.63020000E-04  -4.94740000E-04  -3.77000000E-06  -2.83000000E-06  -2.20000000E-05
   +3.08600000E-04  -2.10810000E-04  +3.40440000E-04  +1.60100000E-04  +2.89530000E-04
   -2.86820000E-04  +6.89930000E-04  -3.47000000E-06  +1.28480000E-04  +5.31587300E-02
   +2.01625000E-03  -3.92000000E-05  -1.76829000E-03  -8.66750000E-04  +8.82590000E-04
   +6.64270000E-04  +3.19960000E-04  -3.04600000E-05  -1.08200000E-05  -1.55940000E-04
   +9.24200000E-05  -8.81800000E-05  +3.78600000E-05  -1.14280000E-04  +9.68600000E-05
   -3.06620000E-04  -4.56000000E-06  +2.17670000E-04  +2.82097000E-03  +1.01018600E-02
   -2.26199600E-02  -1.19302100E-02  -8.46214900E-02  +9.60119300E-02  -1.48320000E-04
   +7.16000000E-05  -1.14700000E-05  +2.38230000E-04  +1.16617000E-03  +3.55360000E-04
   +1.98260000E-04  -2.20050000E-04  +6.85800000E-05  +1.85380000E-04  +7.02400000E-05
   -2.99200000E-05  -1.73940000E-04  +8.98800000E-05  +1.58020000E-04  -5.59800000E-05
   -2.63840000E-04  -5.21700000E-05  -4.66720000E-04  +2.73680000E-04  -4.47000000E-06
   +6.42600000E-05  +1.00600000E-05  -1.68700000E-05  +3.55340000E-04  -3.69462000E-03
   -3.03425000E-03  -4.67800000E-05  -3.18151000E-03  +1.46615000E-03  -1.34400000E-05
   -7.50000000E-06  -1.04900000E-05  +4.85000000E-06  +1.84500000E-05  -2.02600000E-05
   -1.91500000E-05  +3.26000000E-05  -4.39200000E-05  -2.68090000E-04  -1.37930000E-04
   -2.40680000E-04  -1.25800000E-05  +2.13400000E-05  -2.97200000E-05  -2.21730000E-04
   -7.04400000E-05  -5.13900000E-05  +2.58420000E-04  -1.77800000E-05  -4.18000000E-06
   +4.17600000E-05  +7.10530000E-04  -1.59713000E-03  +1.27780900E-02  +9.21621000E-02
   +1.19712000E-03  -2.94670000E-04  -9.36430000E-04  -5.11770000E-04  +2.71710000E-04
   +3.97820000E-04  +3.10320000E-04  -1.04700000E-05  -7.23100000E-05  -1.36080000E-04
   +6.01600000E-05  +1.17400000E-05  -5.52000000E-06  -1.99200000E-05  +4.67900000E-05
   -8.01500000E-05  -1.32530000E-04  +1.18250000E-04  +1.87976000E-03  +8.73356000E-03
   -1.89092000E-02  +3.08550800E-02  +9.14668700E-02  -2.81514030E-01  +8.00000000E-06
   +1.32000000E-06  +3.39900000E-05  +6.53970000E-04  +1.10745000E-03  +7.23650000E-04
   -6.31600000E-05  -4.03010000E-04  +3.66700000E-05  +1.84830000E-04  +1.68570000E-04
   +9.23000000E-06  -8.68800000E-05  +1.53070000E-04  +6.18500000E-05  -2.84890000E-04
   -1.94800000E-05  +2.03380000E-04  +3.01740000E-04  -4.04170000E-04  -6.63200000E-05
   -5.66000000E-06  +2.13000000E-05  +2.09800000E-05  +6.14900000E-04  -4.63648000E-03
   -2.54613000E-03  -1.04200000E-03  +2.81808000E-03  -3.49340000E-04  -3.30000000E-06
   +5.05000000E-06  -7.72000000E-06  -1.32900000E-05  +1.52700000E-05  -2.71000000E-05
   -2.57400000E-05  +9.13700000E-05  +2.05200000E-05  -6.07160000E-04  +2.25570000E-04
   -7.34500000E-05  -1.70700000E-05  -2.87200000E-05  -5.08000000E-06  +3.55300000E-05
   -5.81800000E-05  +3.17960000E-04  +1.76700000E-05  +1.14000000E-05  +3.19460000E-04
   +1.00680000E-04  +5.72450000E-04  -1.37986000E-03  -3.35605000E-02  -1.00936180E-01
   +3.06477480E-01  -4.28900000E-05  -8.53400000E-05  +3.27570000E-04  +8.53430000E-04
   +1.31162000E-03  +3.95000000E-06  +3.57220000E-04  -1.97970000E-04  +3.58200000E-05
   -3.99200000E-05  -3.31000000E-05  -3.54600000E-05  -4.26700000E-05  +1.54400000E-05
   -1.05700000E-05  +3.90100000E-05  -1.86100000E-05  -1.05900000E-05  +1.41612000E-03
   +2.76178000E-03  +8.30430000E-04  -2.36396790E-01  -1.23872560E-01  +5.30593000E-03
   +6.83800000E-05  -3.17400000E-05  +1.70400000E-05  +3.70530000E-04  +5.71260000E-04
   +6.67930000E-04  +2.32810000E-04  +3.17740000E-04  +1.80900000E-04  -9.03300000E-05
   -6.54700000E-05  -7.00300000E-05  +8.91500000E-05  +6.14200000E-05  -1.41800000E-05
   +2.47950000E-04  -1.99810000E-04  -2.14310000E-04  -4.19150000E-04  +3.14470000E-04
   +4.39510000E-04  -1.36780000E-04  -1.70310000E-04  -4.14500000E-05  -4.21000000E-05
   +2.96540000E-04  +1.13480000E-04  +8.15200000E-05  -6.01400000E-05  -1.60460000E-04
   +1.20800000E-05  +1.88000000E-05  +6.42000000E-06  -1.01000000E-05  -4.33000000E-06
   -1.98000000E-05  +8.87500000E-05  -7.06200000E-05  -2.36600000E-05  +2.65620000E-04
   -3.72880000E-04  -4.57260000E-04  -6.12000000E-06  +5.80000000E-06  +1.64200000E-05
   +1.19400000E-05  -1.13820000E-04  +8.76400000E-05  +2.95950000E-04  +1.42090000E-04
   -4.25020000E-04  +2.46140000E-04  +2.10620000E-04  -8.51800000E-05  -2.33690000E-03
   -5.00100000E-04  -2.92580000E-04  +2.54365960E-01  -4.59240000E-04  -1.54080000E-04
   +7.89410000E-04  -1.38048000E-03  +6.79660000E-04  +1.81940000E-04  +4.28710000E-04
   +6.84400000E-05  -4.41900000E-05  +1.51590000E-04  +1.20500000E-05  -2.38300000E-04
   +1.01630000E-04  -1.45720000E-04  +5.17300000E-05  +7.72200000E-05  -5.61900000E-05
   +8.29100000E-05  -2.02299600E-02  -1.55620400E-02  +3.56890000E-04  -1.21818620E-01
   -1.24820300E-01  +4.57986000E-03  -2.07710000E-04  +1.72420000E-04  -6.02700000E-05
   +2.05248000E-03  -2.54548000E-03  -3.75266000E-03  -1.49900000E-03  -3.52400000E-04
   +1.15870000E-04  +4.01000000E-06  -4.05040000E-04  -8.98700000E-05  +3.28390000E-04
   +1.12530000E-04  -6.35100000E-05  -1.35720000E-04  +1.44390000E-04  +5.03500000E-05
   +7.50440000E-04  -6.14100000E-05  -4.25370000E-04  -2.95380000E-04  -1.94420000E-04
   +8.16000000E-06  -4.49700000E-05  +3.58560000E-04  +1.38196000E-03  +4.99790000E-04
   -2.16300000E-04  -2.15560000E-04  +3.47300000E-05  +4.29400000E-05  +1.56500000E-05
   -1.04580000E-04  -1.29840000E-04  +1.60300000E-05  +2.29300000E-05  +1.97600000E-05
   -8.64800000E-05  +9.75200000E-05  +1.40280000E-04  +3.44750000E-04  -4.60900000E-05
   -1.57900000E-05  -7.39000000E-06  +1.30900000E-04  +5.28800000E-05  -2.83600000E-05
   +1.76080000E-04  +6.24990000E-04  -3.65010000E-04  +3.11480000E-04  +6.21500000E-05
   +1.18660000E-04  -9.38632000E-03  -6.33888000E-03  -6.66940000E-04  +1.33636770E-01
   +1.37009000E-01  +1.91710000E-04  +4.44500000E-05  +9.25400000E-05  -7.79920000E-04
   +7.81930000E-04  +5.89600000E-04  +7.47100000E-05  +1.09260000E-04  +5.57300000E-05
   +6.06400000E-05  -1.64900000E-05  -9.40900000E-05  +3.59700000E-05  -3.16500000E-05
   -2.61000000E-06  -1.72160000E-04  +1.34800000E-05  +5.07900000E-05  -1.87937800E-02
   -1.26187000E-02  -1.25931000E-03  +7.32338000E-03  +5.49132000E-03  -4.75768700E-02
   -1.17940000E-04  +5.99200000E-05  -4.33300000E-05  +1.44630000E-03  -2.55146000E-03
   -2.94458000E-03  -1.21107000E-03  -7.40510000E-04  +2.71150000E-04  +1.65190000E-04
   -2.26040000E-04  -1.41080000E-04  +5.75100000E-05  +1.29630000E-04  -9.44000000E-06
   -1.68460000E-04  -3.95300000E-05  +1.37360000E-04  +7.36950000E-04  -2.90510000E-04
   -1.51650000E-04  -1.12720000E-04  -5.62600000E-05  +9.10000000E-06  -1.30348000E-03
   -7.24820000E-04  +1.02866000E-03  -1.68660000E-04  +2.89690000E-04  -2.57380000E-04
   +1.42100000E-05  +1.76400000E-05  +3.61000000E-06  -9.71400000E-05  -6.49200000E-05
   -3.41100000E-05  +1.15500000E-05  +2.08300000E-05  -1.03900000E-05  -1.24130000E-04
   +4.28410000E-04  -2.89200000E-05  -1.81600000E-05  -2.80800000E-05  +1.71500000E-05
   +3.86800000E-05  -2.98700000E-05  -5.22300000E-05  +3.92770000E-04  +1.34440000E-04
   -7.38060000E-04  +2.47840000E-04  +2.42930000E-04  +2.40720000E-04  +2.61260200E-02
   +1.50602800E-02  +1.46727000E-03  -7.44238000E-03  -1.10263000E-03  +5.00646500E-02
   -3.35400000E-04  -1.75180000E-04  +7.65350000E-04  +3.64190000E-04  +1.18148000E-03
   +9.62790000E-04  +6.71680000E-04  +1.34820000E-04  -2.31880000E-04  -5.08700000E-05
   +1.29840000E-04  -3.51810000E-04  +1.60220000E-04  -2.24330000E-04  +2.04290000E-04
   +1.05200000E-05  -9.28500000E-05  +2.47400000E-05  -2.18677000E-03  +6.49340000E-04
   -4.85750000E-04  -2.04252210E-01  +1.23083370E-01  -4.55536300E-02  -3.28950000E-04
   +2.35480000E-04  -9.30400000E-05  -1.30690000E-04  -4.05800000E-05  +2.36560000E-04
   +9.61700000E-05  +7.84800000E-05  +2.70700000E-05  +5.79900000E-05  +1.53300000E-05
   -1.32800000E-05  -1.78850000E-04  +1.17000000E-05  -1.94000000E-06  +1.49870000E-04
   -2.23390000E-04  -1.97940000E-04  -8.85750000E-04  -7.52670000E-04  +6.37320000E-04
   +8.50800000E-05  +1.75100000E-05  -1.55400000E-05  +2.56270000E-04  -3.24400000E-04
   -5.58850000E-04  +3.76690000E-04  -2.36990000E-04  -2.36390000E-04  -1.62900000E-05
   -1.15400000E-05  -6.79000000E-06  +1.10600000E-05  +2.04900000E-05  -6.69000000E-06
   -1.38800000E-05  -5.83000000E-06  -1.94900000E-05  -1.23391000E-03  -2.17578000E-03
   -4.60000000E-06  +2.35500000E-05  +1.53000000E-06  +2.63300000E-05  +3.95740000E-04
   -6.36300000E-05  +4.60610000E-04  -2.33050000E-04  +1.12080000E-04  +4.45300000E-05
   +2.41120000E-04  -2.85320000E-04  +5.32100000E-05  +3.79679000E-03  -3.79772000E-03
   +9.60580000E-04  -1.95352300E-02  +1.68315300E-02  -6.43679000E-03  +2.22824410E-01
   +3.74410000E-04  +1.37800000E-04  -1.09530000E-04  -4.11900000E-04  -2.33475000E-03
   -3.99854000E-03  +3.09600000E-05  -4.28700000E-04  +3.46250000E-04  +3.49610000E-04
   -1.22160000E-04  +5.42200000E-04  -1.69640000E-04  +2.95650000E-04  -4.22130000E-04
   -2.67900000E-05  +2.06670000E-04  +2.89600000E-05  +1.90215900E-02  -1.43198300E-02
   +5.72784000E-03  +1.21807500E-01  -1.42085910E-01  +3.51490500E-02  +4.79630000E-04
   -3.35060000E-04  +1.56510000E-04  +6.28260000E-04  +7.51770000E-04  +5.08120000E-04
   -2.77200000E-04  -2.02940000E-04  -2.00540000E-04  +1.96270000E-04  +2.07560000E-04
   +2.90900000E-05  -1.05480000E-04  +1.56600000E-05  +1.01360000E-04  -4.16780000E-04
   +2.49500000E-04  +2.60810000E-04  +2.71230000E-04  -7.18860000E-04  -6.73760000E-04
   +1.03880000E-04  +1.65280000E-04  +4.42300000E-05  +1.18190000E-04  +6.29650000E-04
   +1.72569000E-03  -3.97110000E-04  -4.57370000E-04  +2.26750000E-04  -5.79000000E-06
   -1.76900000E-05  +2.00000000E-07  +8.65000000E-06  +3.64000000E-06  +2.41300000E-05
   +1.09100000E-05  +9.65400000E-05  +1.20990000E-04  -1.77226000E-03  -1.00546000E-03
   +8.41300000E-04  -1.02400000E-05  -3.66400000E-05  -8.72000000E-06  -3.49940000E-04
   +5.47730000E-04  -6.22480000E-04  -1.11610000E-04  -1.24700000E-05  -1.46780000E-04
   -3.83060000E-04  +8.22100000E-05  +1.50750000E-04  +8.60656000E-03  -6.85169000E-03
   +1.40268000E-03  -1.38275800E-02  +1.16608400E-02  -4.41570000E-03  -1.33997120E-01
   +1.54026780E-01  +1.46952000E-03  -1.79550000E-04  -1.32611000E-03  -7.20500000E-05
   -3.03099000E-03  -2.60487000E-03  +3.79560000E-04  -3.04250000E-04  +2.28410000E-04
   +1.93850000E-04  +5.44300000E-05  +4.01420000E-04  -4.12500000E-05  +1.36030000E-04
   -2.25940000E-04  -1.70660000E-04  +1.43560000E-04  +6.51900000E-05  +1.78309800E-02
   -1.28487300E-02  +3.26045000E-03  -4.64435500E-02  +3.66977100E-02  -6.12280400E-02
   +2.85730000E-04  -1.88840000E-04  +1.18190000E-04  -8.09200000E-05  +5.19930000E-04
   +4.82390000E-04  +9.73800000E-05  +9.33000000E-06  -1.82300000E-04  +9.11500000E-05
   +3.23500000E-05  -3.18100000E-05  -1.58710000E-04  +4.98900000E-05  +1.00920000E-04
   +3.52500000E-05  -2.53630000E-04  -1.79730000E-04  -5.94330000E-04  +4.78500000E-04
   +5.00580000E-04  +5.60600000E-05  -3.21000000E-06  -3.12500000E-05  +1.22499000E-03
   -9.13770000E-04  +9.75910000E-04  -8.96880000E-04  +8.65720000E-04  +6.73410000E-04
   -7.76000000E-06  -1.44600000E-05  -2.77000000E-06  +1.81200000E-05  -3.34000000E-06
   +7.68000000E-06  +3.27000000E-05  -1.86300000E-05  +1.78400000E-05  +2.86710000E-04
   +3.92500000E-05  +5.01300000E-05  +1.34700000E-05  +8.51000000E-06  +1.50100000E-05
   -3.01010000E-04  -2.24170000E-04  -7.41210000E-04  +6.17500000E-05  +1.44590000E-04
   -4.92000000E-05  -1.28200000E-04  +1.83680000E-04  +3.30680000E-04  -2.40909500E-02
   +1.61764700E-02  -4.51379000E-03  +1.30454000E-03  -9.26310000E-04  -7.30250000E-04
   +4.96762300E-02  -3.64876000E-02  +6.47104900E-02  -2.18537000E-03  +2.21012000E-03
   +3.72695000E-03  +6.37085000E-03  -1.18879300E-02  +1.98186300E-02  -5.40082200E-02
   +1.17473400E-02  -7.01963000E-03  +1.39268000E-03  +1.33576500E-02  -2.18530600E-02
   -2.74310000E-03  +4.50560000E-03  -9.25400000E-05  -1.38475000E-03  -1.45650000E-04
   +3.80670000E-04  +3.02730000E-04  -1.74277000E-03  -9.01470000E-04  +3.57820000E-04
   +7.69100000E-05  -1.07020000E-04  +1.25400000E-05  +6.29300000E-04  -1.09360000E-03
   -2.39910000E-04  +5.40100000E-05  -1.66770000E-04  -4.79000000E-05  +1.37290000E-04
   +4.35500000E-05  +2.94000000E-05  -1.35800000E-05  -7.27900000E-05  -8.79200000E-05
   -9.52900000E-05  -2.20000000E-06  +3.00700000E-05  +5.02400000E-05  +3.36600000E-05
   -2.47600000E-05  -7.30000000E-07  -1.96100000E-05  +1.34040000E-04  +1.08030000E-04
   +1.77000000E-06  -2.09485000E-03  +1.12438000E-03  +6.41600000E-04  -4.41000000E-06
   -8.95830000E-04  +1.32688000E-03  -1.47500000E-05  -2.50700000E-05  +5.20000000E-07
   +9.33000000E-06  +1.11300000E-05  +1.55800000E-05  +7.37600000E-05  -8.95400000E-05
   +4.22000000E-05  -9.94000000E-06  -1.05300000E-05  +6.27000000E-06  +1.31500000E-05
   -4.51000000E-06  +3.46000000E-06  +2.00670000E-04  -2.29530000E-04  -8.38200000E-05
   -1.04113000E-03  +1.30760000E-03  -1.82640000E-04  -1.86866000E-03  +2.58450000E-04
   -8.65840000E-04  +4.58700000E-05  -9.46400000E-05  -1.42830000E-04  +2.45100000E-05
   -1.58900000E-05  +4.82100000E-05  -4.02500000E-05  -4.16000000E-05  -2.38500000E-05
   +5.67329100E-02  +2.08370000E-03  +4.58006000E-03  +1.88677000E-03  +3.85540000E-04
   +5.25466000E-03  +3.83030000E-04  +9.80189000E-03  -1.21889970E-01  +1.34692010E-01
   +1.64855000E-03  -6.37796000E-03  +1.33810200E-02  +4.06388000E-03  +2.91510000E-03
   +2.04711000E-03  -1.25460000E-04  -6.18270000E-04  -9.36300000E-04  -1.12724000E-03
   -3.06823000E-03  -1.20165000E-03  +6.55150000E-04  -2.97950000E-04  +1.12380000E-04
   +3.93700000E-05  -4.34600000E-04  +6.67140000E-04  -3.59150000E-04  +4.86280000E-04
   +2.17780000E-04  -1.46510000E-04  +1.37140000E-04  +1.58350000E-04  +1.01600000E-05
   -5.39200000E-05  -5.21500000E-05  +3.58000000E-05  +5.66500000E-05  +9.75000000E-06
   -9.78000000E-06  -1.78500000E-05  +5.15000000E-06  -1.08790000E-04  -1.73280000E-04
   -8.81400000E-05  -4.62400000E-05  -6.32400000E-05  -1.64500000E-05  +2.28845000E-03
   +4.90100000E-05  +1.29000000E-06  +2.91600000E-05  -2.70400000E-05  -1.76640000E-04
   -8.16000000E-06  +5.78000000E-06  +7.14000000E-06  -1.38300000E-05  -1.72600000E-05
   +6.34000000E-06  +1.28100000E-05  -8.74000000E-05  +2.95500000E-05  +1.62700000E-05
   -1.79000000E-06  -1.24500000E-05  -1.22800000E-05  -1.54800000E-05  +2.36000000E-06
   +8.18000000E-06  -2.70650000E-04  -4.02330000E-04  +1.72415000E-03  -1.49227000E-03
   +1.89480000E-04  +1.63600000E-05  -1.39260000E-04  -1.88740000E-04  -2.51100000E-05
   -8.78000000E-06  +8.36000000E-06  -1.33900000E-05  -1.18900000E-05  -1.55900000E-05
   -1.60300000E-05  -1.02420000E-04  -1.83920000E-04  -1.97994600E-02  +1.22915990E-01
   +4.01278000E-03  +1.52179000E-03  +6.72100000E-04  -1.29386000E-03  +1.11899600E-02
   -1.23827300E-02  -3.98622000E-03  +1.33299720E-01  -2.62786170E-01  -1.68869000E-03
   +3.19954000E-03  -1.60264000E-03  +8.27980000E-04  +1.73851000E-03  +2.39799000E-03
   +1.08730000E-04  -8.35560000E-04  +1.17370000E-04  -1.99663000E-03  -6.88490000E-04
   -1.47959000E-03  +4.96140000E-04  -6.60200000E-05  +7.58300000E-05  -1.22340000E-04
   +1.62470000E-04  -1.94700000E-04  -2.65210000E-04  +1.47740000E-04  +5.18400000E-05
   +9.78000000E-06  +3.17500000E-05  +5.65600000E-05  -2.51500000E-05  -1.47400000E-05
   +1.56100000E-05  +2.85700000E-05  +2.31000000E-05  -6.48000000E-06  -2.14000000E-06
   -1.57900000E-05  +1.05600000E-05  -3.98100000E-05  -6.95600000E-05  -2.54500000E-05
   -4.08700000E-05  -3.79700000E-05  -5.29000000E-06  -1.47811000E-03  +1.00124000E-03
   +3.84460000E-04  -1.08720000E-04  +6.58430000E-04  -1.03433000E-03  -8.30000000E-07
   +6.42000000E-06  +1.21000000E-06  -4.92000000E-06  -6.07000000E-06  -2.56000000E-06
   +2.93100000E-05  +2.47500000E-05  -2.81200000E-05  +1.29000000E-06  +5.92000000E-06
   -1.34200000E-05  -6.73000000E-06  -3.51000000E-06  -3.50000000E-07  -5.29420000E-04
   -1.95200000E-04  +3.43090000E-04  -4.56050000E-04  -3.05680000E-04  +1.76040000E-04
   -8.81200000E-04  +3.90540000E-04  +6.10300000E-05  -4.58600000E-05  -2.54000000E-06
   +2.48200000E-05  +1.78800000E-05  -5.24100000E-05  -4.48500000E-05  +3.80700000E-05
   -1.15240000E-04  -8.93300000E-05  +7.36679000E-03  -1.50116940E-01  +2.75874200E-01
   +8.19520000E-04  +1.05533000E-03  -2.77732000E-03  -5.48150000E-04  +2.69006000E-03
   -2.46063000E-03  -2.00363700E-02  +1.13501000E-03  +1.86993200E-02  +3.07591600E-02
   -5.82370000E-04  -4.29072400E-02  -1.48831500E-02  +7.03250000E-03  +4.54943000E-03
   +4.17308000E-03  -2.69805000E-03  +2.25233000E-03  +3.38840000E-04  -1.16458000E-03
   +1.51781000E-03  -5.34800000E-04  +6.68100000E-05  -3.28250000E-04  +2.33776000E-03
   -7.17350000E-04  -1.77279000E-03  -1.55060000E-04  +8.04900000E-04  -3.34000000E-06
   -6.79300000E-05  -1.77900000E-05  -7.53600000E-05  -1.79880000E-04  +9.17500000E-05
   +8.81700000E-05  +4.86240000E-04  +4.34800000E-04  +8.53700000E-05  -1.06730000E-04
   -2.11210000E-04  -4.55900000E-05  -3.38000000E-05  -1.93750000E-04  -2.09300000E-04
   -6.27600000E-04  -4.98610000E-04  -6.43900000E-05  -2.92500000E-04  +2.73800000E-05
   +5.41200000E-05  -1.51702000E-03  -1.49940000E-04  +1.63518000E-03  +8.10700000E-05
   +9.61700000E-05  +4.52200000E-05  -3.15400000E-05  -8.26600000E-05  -1.68500000E-05
   +7.81000000E-05  +1.23370000E-04  +1.55430000E-04  +6.23000000E-05  +1.93800000E-05
   -8.85000000E-06  -4.88100000E-05  -2.93000000E-05  +2.78700000E-05  -1.69580000E-04
   +1.21880000E-04  -5.10200000E-05  +3.24800000E-05  -1.13140000E-04  +2.07300000E-05
   +8.28100000E-05  +3.36200000E-05  +3.01300000E-05  +6.21000000E-05  -9.73800000E-05
   +4.92000000E-06  +6.79400000E-05  -9.36000000E-05  -3.18400000E-05  -1.67520000E-04
   +2.70190000E-04  +9.66600000E-05  +9.70680000E-04  -1.53148000E-03  +1.00624000E-03
   -4.30684400E-02  +8.20200000E-05  -9.48540000E-04  +7.86070000E-04  +2.17592000E-03
   +4.33850000E-04  +8.47900000E-04  +9.75272000E-03  +2.94976000E-03  -6.44868000E-03
   -1.14946400E-02  -2.53253600E-02  +1.87682200E-02  -4.15773000E-03  +2.20356000E-03
   +6.59283000E-03  -9.40200000E-05  +6.23640000E-04  +1.57078000E-03  -6.58900000E-05
   -4.94300000E-05  -5.83370000E-04  +2.42060000E-04  -3.20800000E-05  +1.23460000E-04
   -8.57430000E-04  -3.33670000E-04  -6.44690000E-04  +1.93100000E-05  -1.25480000E-04
   +2.80300000E-05  -2.14100000E-05  +2.87900000E-05  +5.33400000E-05  +3.04700000E-05
   -2.37200000E-05  -1.72800000E-05  -8.16500000E-05  -6.42000000E-05  -1.40100000E-05
   +2.15400000E-05  +3.10400000E-05  +4.59000000E-06  -2.10000000E-06  +2.24900000E-05
   +7.20000000E-06  +1.02430000E-04  +7.26300000E-05  +8.68000000E-06  +4.64900000E-05
   +3.27200000E-05  -3.14200000E-05  +2.95390000E-04  +1.43770000E-04  -3.74160000E-04
   -1.81200000E-05  -1.33200000E-05  -6.74000000E-06  -2.82000000E-06  +9.53000000E-06
   +8.40000000E-07  -8.37000000E-06  -6.65000000E-06  -3.39600000E-05  -6.71000000E-06
   -5.03000000E-06  -1.68000000E-06  +8.79000000E-06  +2.62000000E-06  -4.55000000E-06
   +1.91900000E-05  -2.67300000E-05  +2.17600000E-05  +4.93000000E-06  -1.69600000E-05
   +4.09000000E-06  -1.54000000E-05  +1.74500000E-05  +3.06000000E-06  -1.67400000E-05
   +2.03200000E-05  -1.02000000E-06  -1.95800000E-05  +6.54000000E-06  +1.22000000E-06
   +3.52800000E-05  -8.11500000E-05  -5.21700000E-05  -1.69670000E-04  -5.17760000E-04
   -7.43050000E-04  -4.90712000E-03  +3.36785000E-02  -1.21637000E-03  -9.32000000E-06
   +5.74040000E-04  -1.52775000E-03  +3.36150000E-04  +2.79975000E-03  +4.39627000E-03
   +9.16230000E-04  -1.27466000E-03  -2.58546800E-02  +9.44905000E-03  -1.36460500E-02
   +2.34031600E-02  -2.95391000E-03  -1.10678600E-02  -2.18248000E-03  +3.85176000E-03
   -3.09927000E-03  -5.28630000E-04  +3.48690000E-04  -6.91280000E-04  +3.59450000E-04
   -3.19100000E-05  +1.72970000E-04  -1.51361000E-03  -7.81550000E-04  +1.45800000E-03
   +4.25200000E-05  -3.52330000E-04  -9.47000000E-06  -1.33700000E-05  +4.24000000E-05
   +6.35700000E-05  +1.11740000E-04  -6.52100000E-05  -6.24700000E-05  -2.90430000E-04
   -2.44140000E-04  -4.26600000E-05  +6.08800000E-05  +1.10930000E-04  +3.16800000E-05
   -5.67000000E-06  +8.21400000E-05  +9.44500000E-05  +3.63470000E-04  +2.82070000E-04
   +3.04100000E-05  +1.68550000E-04  -2.22600000E-05  +5.15000000E-06  +8.47050000E-04
   +4.07800000E-05  -7.14280000E-04  -5.20900000E-05  -5.70300000E-05  -2.17900000E-05
   +9.77000000E-06  +4.00100000E-05  +1.13300000E-05  -3.85400000E-05  -7.10600000E-05
   -7.78700000E-05  -3.21900000E-05  -1.04600000E-05  +8.80000000E-07  +2.69300000E-05
   +1.21600000E-05  -1.45600000E-05  +1.12240000E-04  -6.28600000E-05  +2.66000000E-06
   -3.51000000E-06  +9.90900000E-05  +3.80000000E-06  -8.92300000E-05  -3.07800000E-05
   -4.65300000E-05  -3.10000000E-05  +4.93600000E-05  -1.79300000E-05  -3.42200000E-05
   +4.95100000E-05  +2.78900000E-05  +8.06100000E-05  -1.39250000E-04  -6.59300000E-05
   -1.45033000E-03  +4.63750000E-04  -6.19940000E-04  +5.92445400E-02  -2.75883200E-02
   +9.78610000E-03  +2.71891000E-03  +1.31631900E-02  -2.15166800E-02  -3.35149000E-03
   +3.76431000E-03  +3.24920000E-04  -1.55323000E-03  +1.56250000E-04  +2.15200000E-05
   -1.56987000E-03  +1.03676000E-03  +3.59418000E-03  +4.76893000E-03  -1.23099600E-02
   +2.01767800E-02  -5.62140700E-02  +1.88319000E-02  -7.89871000E-03  +6.68380000E-04
   +4.40520000E-04  -1.03778000E-03  +2.22200000E-05  -9.88500000E-05  -7.00000000E-05
   +2.03527000E-03  -2.65150000E-03  -9.06280000E-04  +1.80020000E-04  +1.07500000E-04
   +1.52200000E-05  -8.25000000E-06  -3.63600000E-05  +1.46800000E-05  -1.81000000E-05
   -2.16400000E-05  +1.50900000E-05  +2.59200000E-05  +3.22300000E-05  +3.75000000E-06
   -1.49200000E-05  -2.32000000E-05  +4.13000000E-06  -1.27000000E-05  -3.50700000E-05
   +7.61000000E-06  -4.79600000E-05  -4.97500000E-05  +3.40000000E-06  -4.13930000E-04
   +1.51670000E-04  +5.83400000E-05  +1.51961000E-03  -1.45148000E-03  -2.44065000E-03
   -2.45000000E-06  +1.06400000E-05  -5.75000000E-06  -1.22000000E-05  -8.33000000E-06
   -1.42800000E-05  +2.16000000E-06  +2.87000000E-05  -6.40000000E-07  +6.32000000E-06
   +8.48000000E-06  -8.47000000E-06  -9.32000000E-06  -1.45000000E-06  -2.56000000E-06
   -1.03900000E-05  +5.97300000E-05  -1.53330000E-04  +8.81000000E-06  -3.55000000E-06
   +2.24500000E-05  +1.49000000E-05  -2.20400000E-05  -2.08000000E-05  +3.05000000E-06
   +3.02300000E-05  +2.31500000E-05  -3.81000000E-06  -7.43000000E-06  +1.54600000E-05
   -2.63400000E-05  +2.44200000E-05  +2.96200000E-05  +4.54400000E-05  +5.39300000E-05
   +4.11000000E-06  -9.71980000E-04  -1.76400000E-04  +1.11796000E-03  +5.38047700E-02
   -2.10045000E-03  -4.86268000E-03  +1.60793000E-02  +4.38615000E-03  +1.72072000E-03
   +9.91820000E-04  +1.04440000E-04  -6.37940000E-04  -9.40760000E-04  +7.64550000E-04
   +3.59285000E-03  +1.12995000E-03  +2.81263000E-03  +2.16145000E-03  +4.53420000E-04
   +1.93837600E-02  -1.15173450E-01  +1.32126990E-01  -3.72380000E-04  +1.42160000E-04
   +7.98900000E-04  +2.95700000E-05  +1.70100000E-05  +9.95400000E-05  -2.21539000E-03
   -1.45391000E-03  -2.78529000E-03  -1.09370000E-04  -1.41950000E-04  -2.10000000E-06
   +3.93000000E-06  +2.45900000E-05  +2.02800000E-05  +7.47000000E-06  -2.05500000E-05
   -3.57000000E-06  -4.47700000E-05  -4.27700000E-05  -3.10000000E-06  +3.27300000E-05
   +3.10300000E-05  -1.05800000E-05  -5.32000000E-06  +3.66700000E-05  -2.67000000E-06
   +6.22400000E-05  +4.26800000E-05  +8.90000000E-07  +2.96510000E-04  -1.73350000E-04
   -5.23400000E-05  -2.47865000E-03  -1.66397000E-03  -2.59377000E-03  -1.19500000E-05
   -6.47000000E-06  -3.12000000E-06  -2.44000000E-06  +4.94000000E-06  -4.18000000E-06
   -2.63000000E-06  -7.22000000E-06  -3.04000000E-05  +4.83000000E-06  -1.54200000E-05
   +4.44000000E-06  +1.10600000E-05  +1.70000000E-06  +8.10000000E-07  -1.09800000E-05
   -1.03410000E-04  +8.05300000E-05  -2.80900000E-05  -1.06800000E-05  +1.74400000E-05
   -1.80000000E-06  +8.72000000E-06  -3.76900000E-05  +2.77900000E-05  +1.06000000E-05
   -4.60800000E-05  -1.83500000E-05  -1.06500000E-05  +1.75400000E-05  +1.60700000E-05
   -3.34100000E-05  -3.90800000E-05  +5.13700000E-05  +8.65900000E-05  +1.16790000E-04
   +1.64670000E-04  -5.04900000E-05  -1.09580000E-04  -2.19767300E-02  +1.15704910E-01
   +3.92936000E-03  +3.01694000E-03  -4.91198000E-03  -5.84650000E-04  +1.57356000E-03
   +2.37925000E-03  +2.34480000E-04  -9.89670000E-04  +3.34590000E-04  +3.85822000E-03
   +1.01385000E-03  -3.72240000E-04  -5.76585000E-03  +1.33676000E-02  -1.39284000E-02
   -8.52115000E-03  +1.32717550E-01  -2.46391230E-01  +5.16610000E-04  +7.60700000E-05
   -1.26940000E-04  -5.35900000E-05  -1.23600000E-05  -5.82600000E-05  -1.48078000E-03
   -2.49751000E-03  +1.33503000E-03  +3.02500000E-05  +8.43200000E-05  +2.27700000E-05
   +9.09000000E-06  -3.95600000E-05  +1.02000000E-05  -2.20700000E-05  -1.58700000E-05
   +2.82100000E-05  +2.80700000E-05  +4.77400000E-05  +1.35900000E-05  -1.61000000E-05
   -3.83400000E-05  +3.40000000E-07  -1.45600000E-05  -2.20500000E-05  -1.96500000E-05
   -6.07300000E-05  -6.61300000E-05  +5.27000000E-06  -1.80990000E-04  +2.74200000E-05
   +3.55400000E-05  -8.01230000E-04  -3.20953000E-03  +1.56383000E-03  -4.47000000E-06
   +1.61800000E-05  -9.67000000E-06  -1.40200000E-05  -6.72000000E-06  -2.34100000E-05
   +1.11400000E-05  +3.75600000E-05  -2.14000000E-06  +7.08000000E-06  +6.51000000E-06
   -9.02000000E-06  -8.49000000E-06  -2.12000000E-06  -1.20000000E-06  -2.90200000E-05
   +1.04600000E-05  -5.71000000E-05  -1.60000000E-06  -3.06200000E-05  +1.78300000E-05
   +2.63800000E-05  -9.80000000E-07  -1.40800000E-05  +2.61000000E-06  +2.79200000E-05
   +1.82500000E-05  -6.03000000E-06  -2.72500000E-05  +7.03000000E-06  -2.73300000E-05
   +4.14100000E-05  +3.09500000E-05  +2.24200000E-05  +9.98200000E-05  -2.73700000E-05
   +4.70810000E-04  +1.92200000E-04  -7.67760000E-04  +7.79470000E-03  -1.46106160E-01
   +2.60842890E-01  -1.30519000E-03  +4.06700000E-04  -1.56310000E-04  +1.25020000E-04
   -2.64860000E-04  +4.50880000E-04  +1.13681000E-03  +9.01440000E-04  -9.19350000E-04
   -5.17749000E-03  +3.06058000E-03  +7.33860000E-04  -2.72418000E-03  +2.29685100E-02
   -3.88707900E-02  +1.77845000E-03  -3.86810000E-04  -1.68724000E-03  -1.86440000E-04
   -1.63400000E-05  +7.58800000E-05  +3.64100000E-05  +3.73000000E-06  -4.70000000E-06
   -4.07950100E-02  -1.62757600E-02  +6.02330200E-02  -1.80900000E-05  -3.30500000E-05
   -2.14000000E-06  -3.46000000E-06  -5.25000000E-06  +3.11000000E-05  +3.77300000E-05
   -3.33100000E-05  -9.92000000E-06  -1.16890000E-04  -8.19700000E-05  -1.08400000E-05
   +1.14800000E-05  +2.55100000E-05  +1.86500000E-05  -1.45800000E-05  +5.98000000E-06
   +2.28500000E-05  +1.27020000E-04  +8.93900000E-05  +1.27500000E-05  +6.97900000E-05
   -1.94800000E-05  -1.01500000E-05  +6.90450000E-04  -2.61340000E-04  -2.31600000E-04
   -2.61500000E-05  -1.72900000E-05  -1.13600000E-05  -5.29000000E-06  +1.16000000E-05
   -5.57000000E-06  -9.29000000E-06  -3.95000000E-06  -3.80300000E-05  -1.01000000E-05
   +2.05000000E-06  -6.72000000E-06  +6.37000000E-06  +1.85000000E-06  -6.40000000E-06
   +1.36900000E-05  -2.54200000E-05  +2.60500000E-05  -1.45500000E-05  +1.69000000E-06
   -7.03000000E-06  -8.53000000E-06  +8.19000000E-06  -6.08000000E-06  -1.92000000E-05
   +4.04600000E-05  +5.86000000E-06  -1.23800000E-05  +6.71000000E-06  +1.04000000E-05
   +2.31500000E-05  -2.68200000E-05  +5.14000000E-06  -3.25170000E-04  +1.05190000E-04
   -5.17900000E-05  -1.85370000E-04  -1.46300000E-05  -1.26160000E-04  -8.65840000E-04
   -2.40570000E-04  +1.83334000E-03  +4.75181900E-02  +2.64100000E-04  -8.63500000E-04
   +9.59000000E-05  -5.78400000E-05  +2.81710000E-04  -2.84710000E-04  +8.20300000E-05
   +8.69340000E-04  +1.51763000E-03  +3.70731000E-03  +1.32130000E-04  -4.35580000E-04
   -5.19530000E-04  -1.63339300E-02  +2.29622900E-02  -2.90721000E-03  +1.50387000E-03
   -1.62853000E-03  +1.32840000E-04  -1.17010000E-04  +2.26000000E-06  -5.34500000E-05
   +1.64000000E-05  -4.20000000E-05  +8.80656000E-03  -1.33384900E-01  +2.13341500E-01
   +8.50000000E-06  +9.99200000E-05  -1.64300000E-05  -9.86000000E-06  -6.32000000E-06
   +1.10000000E-06  -3.64200000E-05  +1.18800000E-05  +3.08300000E-05  +1.00260000E-04
   +9.75100000E-05  +1.92500000E-05  -1.43800000E-05  -4.65000000E-05  -1.52700000E-05
   -5.21000000E-06  -2.71100000E-05  -2.78400000E-05  -1.30210000E-04  -1.20440000E-04
   -5.10000000E-06  -6.33600000E-05  +4.40000000E-07  +9.79000000E-06  -5.90250000E-04
   +1.06130000E-04  +1.68010000E-04  +8.81000000E-06  +2.96600000E-05  -7.80000000E-07
   -1.48100000E-05  -1.59300000E-05  -1.85400000E-05  +1.98200000E-05  +3.83000000E-05
   +2.45200000E-05  +1.67100000E-05  -1.30000000E-06  -5.14000000E-06  -8.66000000E-06
   -2.99000000E-06  +3.08000000E-06  -1.79200000E-05  +2.14300000E-05  -2.33000000E-05
   +3.38000000E-06  -1.46700000E-05  +1.66700000E-05  +9.42000000E-06  -9.03000000E-06
   -6.35000000E-06  +2.46400000E-05  -1.76800000E-05  -6.93000000E-06  +2.20000000E-06
   -3.49800000E-05  +2.02000000E-06  -3.68500000E-05  +3.87900000E-05  -1.00000000E-07
   +1.47350000E-04  -2.05450000E-04  -7.86700000E-05  +7.29900000E-05  -1.92360000E-04
   -3.61390000E-04  +9.70390000E-04  +4.23870000E-04  -2.90150000E-04  -9.82367000E-03
   +1.47644510E-01  +9.39000000E-05  -4.80000000E-05  -6.83690000E-04  +5.83500000E-05
   -7.63300000E-05  +1.69130000E-04  +4.25660000E-04  +8.38900000E-04  +7.80100000E-05
   -3.04440000E-04  +8.68800000E-05  +1.84460000E-03  +7.12920000E-04  +2.97357000E-03
   -8.56329000E-03  +2.55043000E-03  -3.77135000E-03  +3.30757000E-03  -1.30110000E-04
   +2.65900000E-05  -1.61420000E-04  +1.18960000E-04  -4.92000000E-05  +8.55100000E-05
   +1.79557200E-02  +2.34718750E-01  -4.12913730E-01  +3.04800000E-05  -8.87500000E-05
   +1.91500000E-05  +5.40000000E-06  +2.14700000E-05  +3.38200000E-05  +1.81600000E-05
   -2.38300000E-05  -9.94000000E-06  -6.69100000E-05  -6.73300000E-05  -1.38200000E-05
   +2.60300000E-05  +4.15000000E-05  +4.30000000E-07  -1.60800000E-05  +1.21000000E-05
   +2.28000000E-05  +9.01600000E-05  +6.93600000E-05  +0.00000000E+00  +3.84900000E-05
   -2.41000000E-06  -2.08500000E-05  +3.21120000E-04  -8.55400000E-05  -2.14340000E-04
   -1.50800000E-05  -1.27700000E-05  -5.00000000E-08  -3.98000000E-06  +5.91000000E-06
   +1.48000000E-06  -6.55000000E-06  -1.01200000E-05  -3.81100000E-05  -2.61000000E-06
   -8.85000000E-06  +2.78000000E-06  +9.65000000E-06  +1.57000000E-06  -2.34000000E-06
   +1.55000000E-05  -1.91000000E-05  +1.24200000E-05  -9.49000000E-06  +4.43000000E-06
   -6.71000000E-06  -7.36000000E-06  +5.40000000E-06  -9.21000000E-06  +1.56000000E-06
   +1.41200000E-05  -4.70000000E-06  -6.98000000E-06  +1.96900000E-05  +1.65300000E-05
   +3.33500000E-05  -4.97000000E-05  -3.80800000E-05  -1.15630000E-04  -4.81300000E-05
   +4.00000000E-07  -2.77530000E-04  -2.84820000E-04  +3.46180000E-04  -2.48010000E-04
   +7.49450000E-04  -3.49830000E-04  -2.12366100E-02  -2.34925920E-01  +4.16985600E-01
   +3.38553000E-03  -2.51976600E-02  +3.09365900E-02  -4.48192000E-03  +1.11918000E-03
   +3.69020000E-03  +1.26504000E-03  -1.92750000E-04  +7.51870000E-04  -4.81410000E-04
   +4.93600000E-04  -3.52670000E-04  -1.05497000E-03  -1.45400000E-04  +5.43370000E-04
   +1.02436000E-03  -2.04662000E-03  +1.76736000E-03  -1.79770000E-04  -4.71900000E-05
   +1.25730000E-04  -1.01950000E-04  +1.03910000E-04  +2.50300000E-05  +5.02530000E-04
   -1.26570000E-04  -2.60190000E-04  +2.07800000E-04  +9.57700000E-05  -7.87500000E-05
   +1.02530000E-04  +2.71870000E-04  -1.02500000E-05  -2.05590000E-04  -1.16080000E-04
   +1.35680000E-04  +1.73780000E-04  -5.07700000E-05  -8.83600000E-05  -1.31400000E-05
   -6.76200000E-05  +9.21100000E-05  +4.12900000E-05  +2.86000000E-05  -1.08820000E-04
   -2.21270000E-04  -1.96120000E-04  +4.29100000E-05  -7.69400000E-05  -4.55000000E-05
   -1.76600000E-05  -5.77924500E-02  +9.54952800E-02  -8.78789300E-02  -1.90200000E-05
   +2.93000000E-05  -3.89700000E-05  -2.08400000E-05  -7.16000000E-06  -3.68400000E-05
   +9.03000000E-06  +3.59400000E-05  +8.32000000E-06  +4.88200000E-05  +4.33200000E-05
   -3.21500000E-05  -6.84100000E-05  +2.37600000E-05  -3.47300000E-05  -6.73000000E-06
   +2.55400000E-05  -2.59400000E-05  -2.17200000E-05  -2.62200000E-05  +1.66600000E-05
   +7.20000000E-06  +1.11200000E-05  -3.50300000E-05  +1.50350000E-04  -2.59180000E-04
   -2.79610000E-04  +5.21000000E-06  +3.47800000E-05  -2.76400000E-05  -4.50000000E-06
   +1.33290000E-04  -1.41910000E-04  -2.50790000E-04  -5.67500000E-05  +1.45370000E-04
   +2.01080000E-04  +1.58500000E-05  -1.88060000E-04  -1.18018000E-03  +1.53449000E-03
   -1.05042000E-03  -2.63990000E-04  +1.50510000E-04  +7.37600000E-05  +5.94441000E-02
   +8.72880000E-04  -2.06024000E-03  -1.25352000E-03  +6.49530000E-04  +2.19976000E-03
   -8.03640000E-04  +6.16650000E-04  +7.62700000E-04  +5.13930000E-04  +6.79500000E-05
   +2.59100000E-04  -1.43730000E-04  +1.21600000E-04  -8.29870000E-04  +1.93160000E-04
   +1.44035000E-03  +7.28490000E-04  -4.31598000E-03  +1.80030000E-04  -8.17000000E-06
   -4.15280000E-04  +2.33700000E-05  -2.96950000E-04  -3.22790000E-04  +1.70610000E-04
   -1.53730000E-04  -9.19700000E-05  +7.53200000E-05  -2.33200000E-05  +1.55530000E-04
   +6.33000000E-05  -1.66000000E-05  -5.58000000E-05  +1.25300000E-05  -9.26700000E-05
   +6.72100000E-05  -1.69700000E-05  +7.01400000E-05  +4.64800000E-05  -3.19500000E-05
   -4.12000000E-05  -1.68700000E-05  -6.65300000E-05  +3.75000000E-05  -6.04000000E-06
   -5.04700000E-05  -9.13400000E-05  +1.54700000E-05  -3.86800000E-05  -4.09000000E-05
   -1.34100000E-05  +6.68788500E-02  -2.28883870E-01  +2.63083280E-01  -2.50800000E-05
   +2.05900000E-05  -3.46100000E-05  -2.10900000E-05  -3.62000000E-06  -5.27100000E-05
   +1.54400000E-05  +5.64400000E-05  -1.91700000E-05  +1.39100000E-05  -3.47400000E-05
   +6.56000000E-06  -1.23000000E-06  +5.72000000E-06  -2.95000000E-06  -1.20100000E-05
   +1.74700000E-05  -1.42400000E-05  -9.82000000E-06  -2.56600000E-05  +1.90400000E-05
   +8.87000000E-06  +8.09000000E-06  -2.13300000E-05  +5.55700000E-05  -9.13200000E-05
   +5.36420000E-04  -6.46000000E-06  -1.03050000E-04  +1.10380000E-04  -6.30200000E-05
   -2.96200000E-05  +1.00910000E-04  -7.81400000E-05  -1.31770000E-04  -1.33310000E-04
   +3.78400000E-05  -1.63100000E-05  -3.13000000E-06  +1.58290000E-04  +2.77980000E-04
   +8.52340000E-04  +7.02000000E-05  +9.42600000E-05  -1.93600000E-05  -7.10875200E-02
   +2.28460770E-01  -4.79944000E-03  +2.10443300E-02  -2.97008400E-02  +4.70962000E-03
   -1.07104000E-03  +4.47190000E-04  -3.85360000E-04  +1.41906000E-03  -7.42210000E-04
   -1.50700000E-05  -2.11120000E-04  +5.27430000E-04  +8.66000000E-06  -1.34080000E-04
   -1.07781000E-03  -3.68605000E-03  -1.29016000E-03  +3.87915000E-03  -7.14400000E-05
   -2.41140000E-04  +1.02460000E-04  +1.62650000E-04  -3.61500000E-04  +1.38160000E-04
   -6.56830000E-04  +2.09340000E-04  +1.43210000E-04  -9.23300000E-05  -7.99700000E-05
   -1.00460000E-04  +8.41200000E-05  +1.17980000E-04  +2.13400000E-05  +6.28000000E-06
   -1.46430000E-04  +3.42500000E-05  -2.00760000E-04  -1.31850000E-04  +7.17000000E-06
   +2.05400000E-05  +4.86300000E-05  -1.22900000E-05  -1.96000000E-06  +5.52600000E-05
   -3.89400000E-05  +1.77780000E-04  +1.25630000E-04  -1.07700000E-05  +3.90800000E-05
   -4.37800000E-05  -4.01500000E-05  -4.89261000E-02  +2.38786600E-01  -2.99159000E-01
   -4.06900000E-05  -2.62600000E-05  -4.30000000E-06  -1.11900000E-05  +1.38200000E-05
   -1.94700000E-05  -1.01000000E-06  -9.50000000E-07  -8.29800000E-05  -7.71000000E-06
   -3.71700000E-05  +1.88200000E-05  +3.23800000E-05  -6.33000000E-06  +6.63000000E-06
   +2.23600000E-05  -2.09800000E-05  +1.23500000E-05  -1.10900000E-05  +3.01000000E-06
   +8.64000000E-06  -1.42600000E-05  +9.19000000E-06  -1.94000000E-05  -6.34200000E-05
   +2.11200000E-04  +1.01580000E-04  -1.34600000E-05  -2.55000000E-06  +5.12700000E-05
   +2.81900000E-05  -8.30400000E-05  +4.28000000E-05  +2.54600000E-04  -1.18880000E-04
   -1.99000000E-04  -2.34660000E-04  +3.96600000E-05  +1.52140000E-04  +1.11165000E-03
   -9.57000000E-06  +4.19850000E-04  +1.68490000E-04  -6.76900000E-05  +1.05140000E-04
   +5.23029200E-02  -2.57939780E-01  +3.25007810E-01  -8.93000000E-05  -2.30430000E-04
   +3.06330000E-04  -4.44380000E-04  -2.67570000E-04  +1.35910000E-03  +5.91998000E-03
   -1.60840000E-03  -4.08372000E-03  -8.54530800E-02  +2.34280000E-03  +7.43149800E-02
   +4.72026000E-03  -1.35164000E-03  -3.67636000E-03  -9.20350000E-04  +1.35069000E-03
   -6.70570000E-04  -7.24100000E-05  +3.87070000E-04  -2.99690000E-04  +7.98700000E-05
   -1.08600000E-05  +6.32800000E-05  +4.27400000E-04  -7.83550000E-04  +1.27775000E-03
   +5.14100000E-05  -1.76790000E-04  +1.07400000E-05  +4.75700000E-05  -1.21100000E-05
   -1.24800000E-05  +1.91600000E-05  -2.36000000E-06  -5.04000000E-06  -4.21100000E-05
   -4.81100000E-05  -1.34800000E-05  +1.08400000E-05  +2.92200000E-05  +1.70000000E-06
   +2.48000000E-05  +4.66200000E-05  +4.67000000E-05  +6.59500000E-05  +5.97100000E-05
   +1.27700000E-05  +4.58400000E-05  -3.30100000E-05  -3.36700000E-05  +7.00000000E-08
   +1.84600000E-05  -7.70400000E-05  -1.95000000E-06  -1.05400000E-05  -8.92000000E-06
   +1.45200000E-05  +1.72800000E-05  +1.39000000E-06  -1.27700000E-05  -2.36500000E-05
   -2.55400000E-05  -1.15600000E-05  -1.72000000E-06  +5.05000000E-06  +5.94000000E-06
   +7.32000000E-06  -3.59000000E-06  +2.35800000E-05  -1.52200000E-05  +1.35000000E-05
   +3.21000000E-06  +1.27400000E-05  -3.88000000E-06  +3.70000000E-07  +4.66000000E-06
   +7.07000000E-06  -7.64000000E-06  +6.33000000E-06  +1.96000000E-06  -6.79000000E-06
   +1.58000000E-05  -3.29000000E-06  +2.24300000E-05  -3.72600000E-05  -1.89500000E-05
   -4.63530000E-04  +5.55570000E-04  -1.07752000E-03  +5.09636900E-02  -3.71094000E-03
   -4.21176600E-02  +2.77540000E-04  -8.18200000E-05  -6.46000000E-06  -1.84490000E-04
   -1.51900000E-05  +1.36650000E-04  -5.22300000E-05  -1.00100000E-05  -1.25200000E-05
   +1.53370700E-01  -5.55400000E-05  -4.69200000E-05  -1.51550000E-04  +1.54800000E-05
   +3.98570000E-04  +3.52530000E-04  -1.45665000E-03  -8.50590000E-04  -7.06620000E-04
   +1.25120300E-02  +3.82856000E-03  -7.88362000E-03  -2.45820000E-04  -1.99148000E-03
   -2.48900000E-05  +3.95120000E-04  +5.06490000E-04  +3.85400000E-04  +1.29290000E-04
   +2.33520000E-04  +1.26260000E-04  -1.08300000E-04  +1.98200000E-05  -4.49300000E-05
   -1.01964000E-03  +6.57040000E-04  +4.26700000E-04  +1.02000000E-05  -5.43800000E-05
   -2.21000000E-06  +3.14400000E-05  -1.24500000E-05  -4.02800000E-05  +4.31000000E-06
   +7.05000000E-06  -7.45000000E-06  -1.27400000E-05  -2.39100000E-05  -5.75000000E-06
   -2.49000000E-06  +1.61600000E-05  +5.88000000E-06  +1.38900000E-05  +2.39300000E-05
   +1.88200000E-05  +2.46300000E-05  +3.52500000E-05  +4.55000000E-06  -4.32500000E-05
   -5.56000000E-05  -6.98000000E-06  -1.00200000E-05  -2.12700000E-05  -8.47400000E-05
   +6.60000000E-06  -1.01600000E-05  -1.23000000E-06  +1.63100000E-05  +9.57000000E-06
   +6.85000000E-06  -5.67000000E-06  -2.49100000E-05  +7.23000000E-06  -7.97000000E-06
   +1.54000000E-06  +7.62000000E-06  +1.43000000E-06  +2.58000000E-06  +6.10000000E-07
   +1.19000000E-05  +8.49000000E-06  -3.95000000E-06  +1.00200000E-05  +4.50900000E-05
   +3.36000000E-06  -1.05800000E-05  -2.85000000E-06  +2.95000000E-06  +4.50000000E-06
   -7.32000000E-06  -5.89000000E-06  +1.20200000E-05  +1.31000000E-05  -1.40000000E-07
   -6.62000000E-06  +2.47000000E-05  +2.41500000E-05  -4.22530000E-04  -3.32720000E-04
   -2.58600000E-05  +1.65650000E-03  -1.20324000E-02  +8.97810000E-03  -5.26000000E-06
   +9.38900000E-05  -1.20200000E-05  -2.03250000E-04  +5.96500000E-05  -2.20500000E-05
   +3.43000000E-06  -5.43400000E-05  -2.07800000E-05  -1.50439810E-01  +2.05117050E-01
   -1.76500000E-05  +5.66000000E-06  -1.62880000E-04  +8.37160000E-04  +6.35720000E-04
   -1.15802000E-03  -4.44919000E-03  -5.90750000E-04  +2.85861000E-03  +5.84958700E-02
   +8.20020000E-04  -4.62520100E-02  -5.61738000E-03  +9.01390000E-04  +1.17535000E-03
   +1.03008000E-03  -4.84390000E-04  +8.63010000E-04  +1.36310000E-04  -8.02200000E-05
   +3.73070000E-04  -1.39680000E-04  -1.20000000E-07  -5.34300000E-05  +1.66838000E-03
   +2.33160000E-04  -1.43484000E-03  -1.88000000E-05  +9.58800000E-05  +3.45500000E-05
   +3.63100000E-05  -2.54000000E-05  -1.90100000E-05  -3.03300000E-05  +8.64000000E-06
   +2.61200000E-05  +7.11200000E-05  +5.14500000E-05  +2.03000000E-06  -1.79100000E-05
   -2.09000000E-05  +1.80000000E-06  +8.00000000E-07  -2.16000000E-05  -2.00800000E-05
   -8.22900000E-05  -6.17500000E-05  +9.80000000E-07  -1.74900000E-05  -3.98700000E-05
   -2.31400000E-05  -1.61200000E-05  -1.09580000E-04  +1.17740000E-04  +1.33800000E-05
   +1.40100000E-05  -2.39000000E-06  +2.97000000E-06  -1.67000000E-06  -7.49000000E-06
   -2.62000000E-06  +1.60600000E-05  -6.60000000E-06  +3.07000000E-06  +7.99000000E-06
   -3.30000000E-07  -8.91000000E-06  -1.01000000E-06  +1.10000000E-06  -3.27500000E-05
   +1.59200000E-05  +1.37000000E-05  +4.61000000E-06  -3.41600000E-05  -1.61500000E-05
   +3.88900000E-05  +3.47800000E-05  +1.91200000E-05  -5.09000000E-06  -1.80000000E-06
   +1.81800000E-05  +1.24300000E-05  +2.10000000E-06  -1.49900000E-05  -8.48000000E-06
   +4.11700000E-05  +2.74900000E-05  +6.38260000E-04  -8.87000000E-04  +4.17290000E-04
   -5.28902100E-02  +1.39515500E-02  +1.57908500E-02  -1.70350000E-04  +6.38000000E-05
   +1.17760000E-04  +4.50810000E-04  -1.81390000E-04  -1.36710000E-04  -1.74800000E-05
   -2.21300000E-05  -1.17800000E-05  +1.29274060E-01  -2.11717020E-01  +2.56627010E-01
   -3.74980000E-04  -2.65850000E-04  +8.02450000E-04  +4.57620000E-04  +1.69860000E-04
   -4.76160000E-04  -1.26900000E-04  +2.18210000E-04  -3.48110000E-04  -3.69934000E-03
   +5.40780000E-04  +8.46460000E-04  -2.07060000E-04  +2.43600000E-05  +9.36540000E-04
   -2.06780000E-04  +2.51300000E-04  -3.26980000E-04  -1.57720000E-04  +1.37660000E-04
   -1.57020000E-04  +1.18130000E-04  -2.34300000E-05  +7.17000000E-05  -4.51870000E-04
   +2.62550000E-04  -9.33570000E-04  +2.80000000E-05  -1.54510000E-04  +7.60000000E-06
   -1.87000000E-06  +1.63000000E-05  +4.73600000E-05  +5.30000000E-05  -4.30600000E-05
   -2.46700000E-05  -1.59530000E-04  -1.39600000E-04  -2.75900000E-05  +3.59400000E-05
   +6.47000000E-05  +2.11000000E-05  -1.58600000E-05  +2.98300000E-05  +4.49400000E-05
   +1.99680000E-04  +1.50810000E-04  +1.71400000E-05  +1.00660000E-04  -1.90800000E-05
   -4.80000000E-06  +6.52750000E-04  -9.62000000E-06  -6.02190000E-04  -3.29900000E-05
   -2.89500000E-05  -1.31300000E-05  -1.10000000E-06  +2.02700000E-05  +2.31000000E-06
   -2.37300000E-05  -2.38200000E-05  -5.75800000E-05  -1.54000000E-05  -4.34000000E-06
   -2.11000000E-06  +1.35200000E-05  +5.86000000E-06  -9.59000000E-06  +4.68400000E-05
   -3.33300000E-05  +1.53800000E-05  -1.05100000E-05  +2.90600000E-05  -1.21200000E-05
   -2.44200000E-05  -2.40000000E-07  -1.77700000E-05  -2.33400000E-05  +3.86000000E-05
   +2.17000000E-06  -1.82700000E-05  +3.15000000E-05  +1.20600000E-05  +5.35400000E-05
   -6.73900000E-05  -1.84200000E-05  +8.89700000E-05  -1.34430000E-04  +9.03000000E-06
   -7.89062000E-03  +1.29889500E-02  -1.30491800E-02  +1.84790000E-04  +7.41000000E-06
   -1.25010000E-04  +6.97130000E-04  -2.23000000E-04  -2.68910000E-04  -7.08500000E-05
   -1.41500000E-05  +1.16020000E-04  -1.28332520E-01  +1.39197040E-01  -1.29171800E-01
   +1.39115100E-01  +1.62580000E-04  +2.58220000E-04  -4.49940000E-04  -9.90100000E-05
   +1.36290000E-04  +1.19170000E-04  -7.03740000E-04  -3.22340000E-04  +1.00232000E-03
   +3.58654000E-03  -1.00037000E-03  -4.19482000E-03  -2.12102000E-03  +2.28859000E-03
   -3.72460000E-04  +5.83840000E-04  -5.37420000E-04  +2.33710000E-04  +7.11200000E-05
   -7.84100000E-05  +1.73880000E-04  -5.93400000E-05  +1.60500000E-05  -3.66800000E-05
   +9.78020000E-04  -1.56425000E-03  +5.21900000E-05  +1.70200000E-05  +9.02800000E-05
   -4.89000000E-06  -1.13600000E-05  -3.92000000E-06  -4.50000000E-06  -3.01600000E-05
   +1.38800000E-05  +1.92400000E-05  +7.78100000E-05  +7.05500000E-05  +1.42100000E-05
   -1.07700000E-05  -3.36400000E-05  -1.30000000E-05  -4.64000000E-06  -2.57200000E-05
   -2.46000000E-05  -1.01120000E-04  -8.72900000E-05  -1.02200000E-05  -4.23900000E-05
   +1.23900000E-05  -5.10000000E-06  -3.42080000E-04  -6.92900000E-05  +3.45760000E-04
   +9.11000000E-06  +1.96500000E-05  +6.45000000E-06  -1.15300000E-05  -1.54000000E-05
   -7.01000000E-06  +1.58100000E-05  +3.05800000E-05  +2.14300000E-05  +1.33500000E-05
   +1.50000000E-07  -3.47000000E-06  -6.53000000E-06  -3.50000000E-06  +3.10000000E-06
   -2.66500000E-05  +1.84600000E-05  -3.17000000E-06  -1.94000000E-06  -2.72400000E-05
   +7.86000000E-06  +1.57500000E-05  +4.79000000E-06  +5.13000000E-06  +1.30900000E-05
   -1.51400000E-05  +0.00000000E+00  +3.59000000E-06  -2.20700000E-05  -2.47000000E-06
   -2.44800000E-05  +3.53700000E-05  +7.73000000E-06  -1.38700000E-05  -1.30050000E-04
   -1.20500000E-05  -2.84682000E-03  -4.15560000E-04  +7.74230000E-03  -1.50160000E-04
   +2.59600000E-05  +1.57640000E-04  +2.39800000E-05  -7.57000000E-05  +2.38700000E-05
   +1.95500000E-05  +3.02700000E-05  -3.86500000E-05  +1.54016730E-01  -1.95580740E-01
   +1.97381470E-01  -1.53000260E-01  +1.96956550E-01  +1.08210000E-04  -9.03000000E-05
   +1.30620000E-04  -7.83800000E-05  -9.41900000E-05  +3.89740000E-04  +1.21200000E-03
   +2.00010000E-04  -1.49162000E-03  -4.32394000E-03  -1.55279000E-03  +4.74568000E-03
   +4.56857000E-03  -2.22062000E-03  +8.09020000E-04  -8.99600000E-04  +5.19260000E-04
   -2.17400000E-04  +5.48200000E-05  +8.95800000E-05  -1.06310000E-04  +1.96000000E-06
   +1.73400000E-05  -5.23000000E-06  -2.11575000E-03  +6.67290000E-04  -3.77930000E-04
   +2.72800000E-05  -2.41200000E-05  -1.79100000E-05  -1.87300000E-05  +2.71000000E-06
   -3.20000000E-07  +4.00000000E-08  +6.24000000E-06  -3.75000000E-06  +4.06000000E-06
   +7.41000000E-06  +3.95000000E-06  +2.33000000E-06  -4.13000000E-06  -7.01000000E-06
   +6.80000000E-07  +4.23000000E-06  +3.31000000E-06  -8.84000000E-06  -8.57000000E-06
   -4.30000000E-06  -1.57800000E-05  +4.86000000E-06  +1.25400000E-05  -2.77100000E-05
   +4.77000000E-05  -1.15290000E-04  +6.50000000E-07  +1.70000000E-06  +4.33000000E-06
   -3.73000000E-06  -4.43000000E-06  +1.34000000E-06  +4.58000000E-06  +5.64000000E-06
   +1.36600000E-05  +3.63000000E-06  -3.05000000E-06  -3.50000000E-07  +1.23000000E-06
   -4.60000000E-07  +1.02000000E-06  +6.53000000E-06  +3.20000000E-06  -8.25000000E-06
   +1.58000000E-06  +6.52000000E-06  +7.51000000E-06  -4.93000000E-06  -1.05000000E-05
   -6.21000000E-06  +6.98000000E-06  -3.49000000E-06  -6.48000000E-06  -4.29000000E-06
   -1.04000000E-05  +3.09000000E-06  -9.60000000E-06  +3.53000000E-06  +6.90000000E-07
   -1.78360000E-04  +7.67100000E-05  -1.38070000E-04  +1.41708800E-02  -6.17556000E-03
   +8.88480000E-04  +1.35550000E-04  +2.81300000E-05  -1.12880000E-04  -6.80300000E-04
   +2.26990000E-04  +1.35260000E-04  +4.65600000E-05  +1.03000000E-06  -7.99000000E-06
   -1.54682640E-01  +2.10416970E-01  -2.29165890E-01  +1.42694450E-01  -2.02134420E-01
   +2.24642940E-01
end_hess

