# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  2
   energy       -882.69651770    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   +2.52916529E+00  -2.26087024E-01  +1.04317810E+00
   006   +1.64476985E+00  +1.92647254E+00  -2.30665868E-01
   006   +3.23363403E+00  +2.91551905E+00  -2.07537804E+00
   006   +5.56957053E+00  +1.89934687E+00  -2.70115638E+00
   006   +6.41898822E+00  -2.33739753E-01  -1.44248726E+00
   006   +4.82342470E+00  -1.27031577E+00  +3.45127255E-01
   006   -9.19619962E-01  +3.08791381E+00  +4.44189393E-01
   006   -7.82166455E-01  +4.13992105E+00  +3.14877818E+00
   008   +8.70129407E+00  -1.22407546E+00  -2.02816223E+00
   006   -3.00284992E+00  +1.10180054E+00  +1.16989233E-01
   006   -3.08798286E+00  -3.35253035E-01  -2.08183099E+00
   006   -4.98393646E+00  -2.08532910E+00  -2.50897280E+00
   006   -6.86703219E+00  -2.43717691E+00  -7.15336830E-01
   006   -6.82020218E+00  -1.02381497E+00  +1.48875095E+00
   006   -4.90624435E+00  +7.17770615E-01  +1.88443855E+00
   008   -8.77637629E+00  -4.13099758E+00  -1.02094630E+00
   006   -1.58299956E+00  +5.31035738E+00  -1.30659107E+00
   008   +1.14261546E+00  -1.28436011E+00  +2.89809892E+00
   001   -8.58337625E+00  -4.98071101E+00  -2.60490043E+00
   001   -4.99159369E+00  -3.18420284E+00  -4.23842030E+00
   001   -1.62544973E+00  -1.04854579E-01  -3.49536915E+00
   001   -4.91223963E+00  +1.77042404E+00  +3.63440120E+00
   001   -8.28309461E+00  -1.31051637E+00  +2.88660220E+00
   001   -3.44937010E+00  +6.01950354E+00  -8.01666842E-01
   001   -2.38221490E-01  +6.86135778E+00  -1.10646951E+00
   001   -1.64849055E+00  +4.73954004E+00  -3.28481390E+00
   001   -4.90325718E-01  +2.65154936E+00  +4.53577200E+00
   001   +7.86351304E-01  +5.46954169E+00  +3.27992222E+00
   001   -2.50648629E+00  +5.16178774E+00  +3.62977061E+00
   001   +2.63660250E+00  +4.57540330E+00  -3.10222825E+00
   001   +6.73390951E+00  +2.73470347E+00  -4.15682061E+00
   001   +5.38129266E+00  -3.24222816E+00  +1.46648431E+00
   001   +8.97423420E+00  -2.74025503E+00  -1.07710912E+00
   001   +2.02396750E+00  -2.74854637E+00  +3.52940300E+00
   008   +5.70790318E+00  -4.62393278E+00  +3.37117975E+00
   001   +6.64929443E+00  -3.50674276E+00  +4.46288494E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +1.70000000E-07  +0.00000000E+00  -1.20000000E-07
   +0.00000000E+00  +2.00000000E-08  +3.00000000E-08
   +2.00000000E-08  +5.00000000E-08  -2.00000000E-08
   +2.00000000E-08  +7.00000000E-08  +1.10000000E-07
   -1.40000000E-07  +8.00000000E-08  +1.70000000E-07
   +2.60000000E-07  +2.80000000E-07  +1.70000000E-07
   -1.00000000E-07  +3.00000000E-08  -9.00000000E-08
   -1.90000000E-07  +1.40000000E-07  -1.40000000E-07
   +9.00000000E-08  +2.10000000E-07  +2.00000000E-07
   +0.00000000E+00  -1.00000000E-07  -7.00000000E-08
   +6.00000000E-08  -1.20000000E-07  -7.00000000E-08
   +1.40000000E-07  -2.30000000E-07  +0.00000000E+00
   +6.00000000E-08  -2.80000000E-07  +2.00000000E-08
   +0.00000000E+00  -1.70000000E-07  -5.00000000E-08
   -7.00000000E-08  -1.40000000E-07  -6.00000000E-08
   +1.50000000E-07  -2.40000000E-07  -5.00000000E-08
   -1.50000000E-07  -1.10000000E-07  -2.10000000E-07
   -6.00000000E-08  +6.00000000E-08  +1.30000000E-07
   +2.60000000E-07  -3.80000000E-07  +6.00000000E-08
   +2.00000000E-07  -3.00000000E-07  +1.00000000E-08
   +9.00000000E-08  -1.70000000E-07  +0.00000000E+00
   -1.00000000E-07  -2.00000000E-08  -1.10000000E-07
   +3.00000000E-08  -1.60000000E-07  -1.10000000E-07
   -1.70000000E-07  -1.30000000E-07  -2.30000000E-07
   -1.70000000E-07  -3.00000000E-08  -2.00000000E-07
   -7.00000000E-08  -1.50000000E-07  -1.70000000E-07
   -1.60000000E-07  +1.10000000E-07  -5.00000000E-08
   -1.80000000E-07  +1.20000000E-07  -1.30000000E-07
   -2.10000000E-07  +6.00000000E-08  -2.00000000E-07
   -8.00000000E-08  +0.00000000E+00  -9.00000000E-08
   +0.00000000E+00  +1.00000000E-07  +1.00000000E-07
   -3.00000000E-08  +4.50000000E-07  +1.00000000E-08
   +1.30000000E-07  +2.30000000E-07  +2.60000000E-07
   +3.00000000E-08  +1.80000000E-07  +1.60000000E-07
   +8.00000000E-08  +1.20000000E-07  +5.00000000E-07
   +6.00000000E-08  +4.30000000E-07  +2.40000000E-07
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.89007900E-01  -1.34758820E-01  +5.04020220E-01  -1.68742510E-01  -2.02427950E-01
   +4.47688620E-01  -1.40782350E-01  +9.49804400E-02  -3.63890500E-02  +5.41642010E-01
   +4.06791900E-02  -2.04472090E-01  +8.90745900E-02  -9.31828100E-02  +4.76616940E-01
   +4.97993000E-03  +4.93683200E-02  -1.24369370E-01  -1.55809870E-01  -1.92507100E-01
   +4.37467480E-01  +5.50616100E-02  -5.71477100E-02  +1.07721500E-02  -1.93443970E-01
   -3.23065000E-03  +8.35929200E-02  +5.90660780E-01  -1.66497800E-02  -1.58741600E-02
   +2.67004400E-02  -4.90819400E-02  -1.36481470E-01  +9.35139400E-02  -1.55107930E-01
   +5.41305120E-01  -1.80137500E-02  +5.24582200E-02  -2.71299900E-02  +1.24881760E-01
   +6.45633100E-02  -1.95002920E-01  -1.49727920E-01  -2.35096550E-01  +4.40840640E-01
   -3.40967900E-02  +4.15359400E-02  -1.26551900E-02  -2.94687200E-02  -3.32595700E-02
   +5.37020800E-02  -2.85765870E-01  +1.13561750E-01  +4.56410100E-02  +6.03454890E-01
   +3.77738100E-02  -3.97018500E-02  +7.96489000E-03  -1.33972000E-03  +4.59859800E-02
   -3.31260000E-02  +6.60658700E-02  -1.36766710E-01  +2.25455400E-02  -1.26013410E-01
   +5.00769300E-01  -1.16892900E-02  +9.96081000E-03  +1.78649000E-03  +2.51537000E-02
   -1.30848100E-02  +3.83149000E-03  +8.92578100E-02  -8.77160000E-03  -1.10932890E-01
   -2.03351260E-01  -2.40130730E-01  +4.51808500E-01  -3.06914700E-02  -6.32750000E-03
   +1.82591500E-02  +4.38196000E-03  -9.29764000E-03  +6.13968000E-03  -5.63617000E-03
   +2.89815800E-02  -2.04946600E-02  -1.24835120E-01  +8.42194400E-02  -3.36334300E-02
   +6.09481450E-01  -3.96889600E-02  +5.33383600E-02  -2.57668600E-02  -7.10088000E-03
   -4.09023000E-02  +4.23312600E-02  +7.28537800E-02  -1.83628400E-02  -3.00339200E-02
   +1.91710600E-02  -2.34923680E-01  +1.26823950E-01  -1.43551900E-01  +5.22101970E-01
   +5.70719200E-02  -4.64726000E-02  +1.64847000E-03  +6.26581000E-03  +3.80605500E-02
   -3.62938600E-02  -5.15981700E-02  -1.83124000E-03  +3.63690300E-02  +1.40909000E-02
   +9.02393400E-02  -1.57224310E-01  -1.65911950E-01  -2.16229620E-01  +4.32340370E-01
   -2.62897830E-01  +7.14709300E-02  +7.85191800E-02  -5.77653000E-03  +6.09457400E-02
   -3.94118500E-02  -5.07494300E-02  +2.78778000E-03  +2.87935900E-02  +4.50616200E-02
   -4.45448000E-02  +1.43880700E-02  -1.77808490E-01  -2.12090100E-02  +8.88590800E-02
   +5.53561560E-01  +1.14847610E-01  -1.22786250E-01  -1.98283500E-02  +1.93792100E-02
   -1.36498000E-02  +3.89221000E-03  -6.63800000E-04  -5.53574000E-03  +3.92908000E-03
   -1.20384000E-03  -1.76699800E-02  +2.23559700E-02  -6.24079500E-02  -1.21963470E-01
   +9.88749800E-02  -8.04807200E-02  +3.26587520E-01  +4.07761000E-02  +6.84001000E-03
   -9.10163800E-02  -9.69960000E-03  -2.06900300E-02  +3.07603000E-02  +3.06381500E-02
   +1.70478000E-03  -2.18509500E-02  -1.75630700E-02  +4.93335500E-02  -1.79181500E-02
   +1.27822500E-01  +7.00964500E-02  -1.87421770E-01  -2.34031970E-01  -1.39176700E-01
   +3.47543980E-01  -8.69133000E-03  +1.16414900E-02  -1.97496000E-03  -1.45670430E-01
   +3.26962300E-02  +2.28037900E-02  -1.69756600E-02  +4.64678000E-03  +8.64240000E-03
   +2.84857000E-03  -1.14310000E-04  +1.75128000E-03  -1.43930000E-03  +4.55700000E-04
   -2.57560000E-04  +1.70068000E-03  +2.17593000E-03  -3.94400000E-05  +4.70591300E-01
   +2.48256200E-02  -1.08317200E-02  -4.39270000E-03  +3.68240100E-02  -9.51411500E-02
   -3.73950000E-04  -7.25655000E-03  +1.01454800E-02  -2.12200000E-03  -9.82400000E-04
   +1.61806000E-03  +4.63528000E-03  +2.54550000E-04  -1.73651000E-03  +4.46700000E-05
   +1.28479000E-03  -6.75340000E-04  +3.50536000E-03  -2.00422000E-03  +4.72053150E-01
   -1.28890100E-02  +4.92828000E-03  +8.45006000E-03  +1.93381900E-02  +2.24561000E-03
   -8.21352300E-02  +1.82533000E-02  -9.74074000E-03  -2.17239000E-03  +3.07321000E-03
   +3.57616000E-03  +7.85680000E-04  +4.20100000E-04  +1.07628000E-03  -2.27025000E-03
   -8.76370000E-04  +3.28158000E-03  +1.94796000E-03  -1.17136000E-03  +5.32722000E-03
   +4.79489730E-01  -1.04765000E-03  -2.48840000E-04  +1.05915000E-03  -3.13257000E-03
   +1.11097800E-02  +2.90273400E-02  -1.34721000E-03  +2.38971000E-03  -1.47890000E-04
   -1.59883000E-03  -1.75100000E-04  -7.71870000E-04  +6.05230000E-04  -8.02580000E-04
   +5.78840000E-04  +2.68030000E-04  -1.22589000E-03  -2.62210000E-04  -7.59054000E-02
   -7.16190000E-04  -9.69890000E-04  +5.83174530E-01  +1.08413000E-03  +1.16220000E-04
   -1.61178000E-03  +4.42660000E-03  -7.49963000E-03  -1.54514900E-02  -5.70710000E-04
   -1.09502000E-03  +4.42200000E-04  +5.25280000E-04  -1.59890000E-04  +3.30020000E-04
   -1.81230000E-04  +4.09690000E-04  -3.59990000E-04  -3.29020000E-04  +7.15740000E-04
   +2.35400000E-04  -2.88911000E-03  -8.78128900E-02  -3.37838200E-02  -4.39432000E-03
   +5.73120850E-01  -2.28260000E-03  +4.97030000E-04  +2.07297000E-03  +9.25499000E-03
   -8.40853000E-03  -1.17937000E-02  -7.36020000E-04  -5.38650000E-04  +8.89000000E-06
   -2.06400000E-05  +4.47340000E-04  +1.29680000E-04  +4.02000000E-06  -3.90950000E-04
   +3.38210000E-04  +8.17230000E-04  +1.18200000E-04  -2.48810000E-04  -6.92725000E-03
   -2.99461500E-02  -1.60468770E-01  -6.53632000E-03  -5.41588500E-02  +4.85507450E-01
   +2.89097000E-03  +1.42627000E-03  +3.70201000E-03  -3.25041000E-03  +8.47950000E-04
   +2.19990000E-04  +4.14486000E-03  -3.36010000E-04  +1.16731000E-03  -2.25596900E-02
   +2.18626000E-02  +6.37000000E-06  -2.67412180E-01  +6.95155400E-02  +7.89006500E-02
   -4.08926100E-02  +1.29638700E-02  +1.74145500E-02  +1.42030000E-03  -1.14814000E-03
   +1.36880000E-04  -1.27704000E-03  +4.16050000E-04  -3.50560000E-04  +3.74281390E-01
   +5.50160000E-03  -5.79644000E-03  +4.97026000E-03  +1.55405000E-03  +3.14861000E-03
   -4.83647000E-03  -5.74607000E-03  -9.79110000E-04  +8.43127000E-03  +4.99395800E-02
   -1.91497500E-02  -6.90511000E-03  +1.05614820E-01  -1.21028290E-01  -3.96466000E-03
   -9.67292000E-03  +1.30807300E-02  +3.60774000E-03  -6.56280000E-04  +7.07140000E-04
   -3.54580000E-04  +7.03660000E-04  -2.41090000E-04  +1.95960000E-04  -1.84875670E-01
   +5.02021500E-01  -1.41717000E-03  +8.47716000E-03  -4.01540000E-04  -2.86200000E-05
   -3.67361000E-03  +1.79022000E-03  +4.69143000E-03  +5.08831000E-03  -2.50862000E-03
   -2.23416300E-02  +9.51207000E-03  +1.49567600E-02  +5.48028000E-02  +1.58722300E-02
   -8.72886200E-02  +3.58605100E-02  -1.09443100E-02  -4.05822000E-03  -3.63840000E-04
   -2.45300000E-05  +1.48400000E-04  +2.03100000E-04  -4.26400000E-05  -1.35000000E-06
   -6.49108300E-02  -2.42446510E-01  +2.43558240E-01  -1.72450000E-04  -1.16000000E-04
   +3.56900000E-05  -3.21647200E-02  -1.76730200E-02  +2.79267000E-03  -1.60829000E-03
   +1.02789000E-03  -1.78928000E-03  -1.52190000E-04  +8.28640000E-04  +8.30080000E-04
   +1.43950000E-04  -5.19750000E-04  +1.33830000E-04  +4.99270000E-04  -3.12910000E-04
   +6.02350000E-04  -1.25575940E-01  -4.92028400E-02  -2.76380000E-03  -1.20016000E-03
   -4.17447000E-03  -5.33163000E-03  -3.76450000E-04  +1.90290000E-04  -1.65300000E-05
   +5.00100330E-01  +2.70301000E-03  +7.45330000E-04  -1.16769000E-03  +1.01513000E-03
   +1.02569600E-02  +2.24275000E-03  +1.17865000E-03  -1.62686000E-03  -1.09830000E-04
   +6.18850000E-04  -7.88140000E-04  -4.89730000E-04  -4.23200000E-04  +9.87890000E-04
   -2.41690000E-04  -5.91450000E-04  +9.52000000E-05  -1.14480000E-04  -4.72161400E-02
   -1.17263390E-01  -1.49284700E-02  -9.04668000E-03  -1.11075700E-02  -4.62046000E-03
   +1.06984000E-03  -6.01600000E-04  -1.38500000E-04  +1.67678820E-01  +4.13001030E-01
   +8.47200000E-05  +8.19750000E-04  -5.32550000E-04  +7.06746000E-03  +6.95879000E-03
   +1.14400000E-05  +9.12430000E-04  -1.10331000E-03  +1.11990000E-04  +3.66380000E-04
   -5.69070000E-04  -4.72880000E-04  -6.97800000E-05  +5.90060000E-04  -2.28260000E-04
   -3.15730000E-04  +1.60900000E-05  -5.03700000E-05  -3.39430000E-04  -1.22875400E-02
   -8.70285200E-02  -2.37739800E-02  -2.34631900E-02  -3.68660000E-03  +3.19380000E-04
   -2.19360000E-04  +5.23000000E-06  -1.35074230E-01  +1.40864390E-01  +5.79748240E-01
   -6.46750000E-04  -1.00290000E-04  -7.67860000E-04  -7.46340000E-04  -2.22284000E-03
   -2.04395000E-03  +5.36890000E-04  -2.55090000E-04  -8.30010000E-04  -2.27410000E-04
   +4.25170000E-04  +1.51400000E-04  +6.16100000E-05  -1.79950000E-04  +1.64590000E-04
   +3.52570000E-04  -5.34100000E-05  -3.09100000E-05  -7.20350000E-04  -1.41172200E-02
   -2.11773900E-02  -3.82797000E-03  -3.70134000E-03  +4.83440000E-04  -1.96930000E-04
   +9.55400000E-05  +3.41400000E-05  -1.11530570E-01  -8.84067000E-03  +3.73665200E-02
   +5.60149550E-01  -6.46350000E-04  -8.66930000E-04  +8.77820000E-04  +1.18100000E-04
   -1.47490000E-04  -1.31676000E-03  +9.97200000E-05  +1.96700000E-05  -2.00010000E-04
   +6.79100000E-05  +4.26300000E-05  -1.15150000E-04  +3.77500000E-05  -3.84300000E-05
   -2.85000000E-06  +2.22000000E-06  +5.93100000E-05  -4.45100000E-05  -5.39574000E-03
   -1.42853300E-02  -1.84981900E-02  -2.88160000E-03  -1.66002000E-03  +7.87460000E-04
   -9.96800000E-05  +8.10000000E-05  +9.84000000E-06  -4.12384500E-02  -1.55690000E-01
   -8.61142700E-02  +2.23894660E-01  +4.19349610E-01  -9.07950000E-04  -1.48900000E-03
   +8.02210000E-04  -4.90650000E-04  -6.14410000E-04  -5.64390000E-04  +2.94970000E-04
   +1.63980000E-04  -6.11670000E-04  +9.74200000E-05  -8.77300000E-05  -3.07360000E-04
   +1.71640000E-04  -6.56200000E-05  +5.90500000E-05  +2.39570000E-04  -1.45600000E-04
   -2.82600000E-05  -6.48150000E-03  -5.83495000E-03  +7.98560000E-04  +6.04790000E-04
   +5.10210000E-04  +1.37310000E-04  -1.62320000E-04  +6.31200000E-05  -2.44500000E-05
   -1.43877700E-02  -1.24841550E-01  -2.52263160E-01  -1.59043320E-01  +1.60965020E-01
   +5.93888320E-01  +2.62000000E-04  -5.98000000E-05  -8.04800000E-05  +7.24700000E-05
   +6.24800000E-05  -3.21390000E-04  -2.21450000E-04  +1.93580000E-04  +7.51400000E-05
   +1.05770000E-04  -1.16660000E-04  -1.53000000E-06  +2.01240000E-04  +5.22200000E-05
   -1.85380000E-04  -2.77510000E-04  -3.75100000E-05  +2.78680000E-04  +3.97694000E-03
   -1.45230000E-04  +1.92591000E-03  +4.65690000E-04  +2.86070000E-04  +4.65380000E-04
   -2.21110000E-04  +8.85500000E-05  +5.59200000E-05  +2.67542400E-02  -2.73186400E-02
   -6.75827200E-02  -2.26210740E-01  -1.21214190E-01  +1.59827800E-02  +5.19371780E-01
   +5.66300000E-05  +2.74600000E-05  +5.80100000E-05  +5.27040000E-04  -9.32500000E-05
   +1.18050000E-04  -3.25670000E-04  +2.16700000E-04  +3.88150000E-04  +3.35200000E-05
   -1.21850000E-04  +5.78800000E-05  -9.04200000E-05  +5.65700000E-05  -6.57700000E-05
   -1.69320000E-04  +1.08430000E-04  +8.15200000E-05  -9.33200000E-05  +3.09118000E-03
   -4.40385000E-03  -7.80330000E-04  -5.51980000E-04  +2.51640000E-04  +8.54800000E-05
   -2.29600000E-05  +1.95000000E-06  -2.32684000E-03  -2.40561500E-02  -4.76493900E-02
   -1.52623800E-01  -1.95012040E-01  -2.67715200E-02  +2.27508300E-01  +4.32778530E-01
   -2.44180000E-04  +3.31440000E-04  -1.58660000E-04  +8.40850000E-04  +2.82970000E-04
   +2.05100000E-04  +1.33000000E-05  -6.25700000E-05  +1.87790000E-04  -6.66200000E-05
   -1.43600000E-05  +7.12200000E-05  -1.99610000E-04  +1.02140000E-04  +9.61000000E-05
   +9.78400000E-05  +4.83700000E-05  -2.15290000E-04  +1.82013000E-03  -3.10813000E-03
   -3.48856000E-03  -8.51510000E-04  -8.96290000E-04  +1.40600000E-05  +2.69030000E-04
   -1.35740000E-04  -4.77200000E-05  -2.72949600E-02  -1.66589500E-02  +1.58518800E-02
   -3.43119400E-02  -6.58451600E-02  -1.21300080E-01  -1.29715470E-01  +2.05356200E-01
   +6.12447150E-01  -7.16660000E-04  -5.17750000E-04  +6.38250000E-04  -1.96130000E-04
   +4.94130000E-04  -3.51800000E-05  -3.54800000E-05  -2.13830000E-04  +1.12920000E-04
   +2.56450000E-04  -2.21780000E-04  -5.46000000E-06  -4.78880000E-04  +3.98870000E-04
   +1.39650000E-04  +1.99350000E-04  +2.65890000E-04  -4.15020000E-04  -2.11087000E-03
   -5.49590000E-04  +1.49630000E-04  +3.49800000E-04  -9.19300000E-05  -3.33610000E-04
   +7.05430000E-04  -3.36310000E-04  -1.36970000E-04  -1.31135000E-02  +1.36038900E-02
   +3.10105300E-02  -4.25731400E-02  -3.77999400E-02  -4.34337000E-03  -2.01821870E-01
   -1.63524900E-02  +1.40095240E-01  +5.36926740E-01  -2.85700000E-04  -2.12450000E-04
   +3.36300000E-04  -2.21000000E-05  +7.94760000E-04  -1.12720000E-04  -2.12900000E-04
   -4.43800000E-05  +3.35820000E-04  +3.54900000E-04  -4.66160000E-04  +2.15800000E-05
   -4.17780000E-04  +6.04010000E-04  -1.75100000E-05  -8.78000000E-05  +2.47950000E-04
   -2.95770000E-04  -4.46700000E-04  -6.49350000E-04  -6.72050000E-04  +2.76300000E-04
   +1.16200000E-04  -1.06010000E-04  +7.47020000E-04  -3.94370000E-04  -1.27650000E-04
   +1.30011400E-02  -6.79619000E-03  -1.73089300E-02  -1.08894100E-02  +1.17913900E-02
   +2.86628000E-02  -5.48253500E-02  -1.03388440E-01  +1.35688400E-02  +2.11758080E-01
   +4.43506640E-01  +9.80100000E-05  +2.94500000E-05  +1.05180000E-04  +2.40800000E-04
   +6.38130000E-04  -2.29810000E-04  -4.82270000E-04  +8.77900000E-05  +4.33330000E-04
   +3.34040000E-04  -4.24330000E-04  +4.22200000E-05  -1.37860000E-04  +4.63170000E-04
   -2.34880000E-04  -3.21480000E-04  +1.30820000E-04  +7.08400000E-05  +9.78300000E-04
   +1.49820000E-04  -1.72138000E-03  +1.57290000E-04  -3.25600000E-05  +3.00980000E-04
   +3.38000000E-04  -2.01010000E-04  -4.34300000E-05  +3.06723700E-02  -1.82549100E-02
   -7.23245100E-02  +3.88755400E-02  +6.19619400E-02  +5.34504800E-02  +7.93462200E-02
   -3.43392800E-02  -2.22331430E-01  -1.31847150E-01  +1.83000260E-01  +6.19055280E-01
   -2.21160000E-04  -3.24030000E-04  +4.65590000E-04  -1.65440000E-04  -3.30000000E-04
   -9.45000000E-06  +2.22140000E-04  -1.93300000E-05  -2.48190000E-04  -1.43030000E-04
   +2.23050000E-04  -5.84200000E-05  +8.58500000E-05  -2.60140000E-04  +1.53580000E-04
   +2.33300000E-04  -1.27530000E-04  -1.43370000E-04  +1.27984000E-03  -9.73320000E-04
   +4.20119000E-03  +1.16210000E-04  +5.18250000E-04  +2.43780000E-04  -1.91760000E-04
   +1.16730000E-04  +1.18500000E-05  -3.85719000E-02  -1.26176400E-02  +3.64339300E-02
   -1.50860700E-02  -2.11936900E-02  -1.89373800E-02  +2.87843700E-02  +2.28124200E-02
   +1.10338900E-02  -1.12225860E-01  +1.24235000E-03  +5.41126500E-02  +5.61925590E-01
   -3.31110000E-04  -5.35040000E-04  +4.69510000E-04  -7.07180000E-04  -1.04521000E-03
   +1.25570000E-04  +1.96310000E-04  +4.40000000E-06  -4.51550000E-04  -2.46700000E-04
   +4.43570000E-04  -2.52800000E-05  +1.42200000E-04  -4.81500000E-04  +1.88810000E-04
   +4.08080000E-04  -1.39000000E-04  -1.37000000E-05  -1.84663000E-03  +4.00068000E-03
   -1.15064000E-03  -2.08660000E-04  -3.11130000E-04  -8.46600000E-05  -4.01820000E-04
   +2.40720000E-04  +3.52200000E-05  -3.70367600E-02  +1.24541000E-02  +5.37354600E-02
   -2.04167900E-02  -3.81780900E-02  -3.09948600E-02  +4.50602200E-02  +3.12365200E-02
   -2.01911000E-02  -3.45685400E-02  -1.49340240E-01  -8.11323800E-02  +2.36442250E-01
   +4.19041630E-01  +2.49720000E-04  +2.49670000E-04  -4.53670000E-04  +6.19550000E-04
   +5.34700000E-04  +1.53370000E-04  +4.29530000E-04  -1.65550000E-04  -1.86570000E-04
   -2.04610000E-04  +1.91420000E-04  -8.69600000E-05  +1.13820000E-04  -2.56270000E-04
   +8.70500000E-05  +8.01900000E-05  -6.26000000E-05  +5.50000000E-06  +4.22192000E-03
   -2.59441000E-03  -1.13618000E-03  -6.44130000E-04  -8.84170000E-04  -3.95670000E-04
   -2.11380000E-04  +1.23520000E-04  +4.61300000E-05  -1.89433000E-03  +2.44547000E-02
   +4.70649600E-02  -1.76804100E-02  -2.95312500E-02  -2.87392700E-02  +4.65607300E-02
   +7.48635000E-03  -3.77575100E-02  -3.41660000E-03  -1.26912800E-01  -2.69549760E-01
   -1.66273360E-01  +1.67071110E-01  +6.09144780E-01  -4.10300000E-04  -1.49990000E-04
   +2.72370000E-04  -9.17010000E-04  -1.77253000E-03  -1.44890000E-04  -7.07050000E-04
   +4.72570000E-04  +2.14460000E-04  +9.74400000E-05  -9.02200000E-05  +2.40210000E-04
   +4.28400000E-05  +1.36030000E-04  -1.81520000E-04  -2.46830000E-04  +1.27040000E-04
   +2.26880000E-04  -1.59567100E-02  -6.34124000E-03  +1.18378500E-02  -1.08576000E-03
   -7.47710000E-04  +1.12975000E-03  -2.45900000E-05  +8.26000000E-06  +2.92600000E-05
   -2.12319970E-01  -6.14405400E-02  +8.47864500E-02  +2.94302000E-02  +4.88255700E-02
   +5.24539400E-02  -5.40657200E-02  -2.82843500E-02  +1.79195400E-02  +2.92117300E-02
   -2.65314300E-02  -7.67878600E-02  -2.27890620E-01  -1.19821710E-01  +1.85111400E-02
   +5.17662020E-01  -2.53030000E-04  -3.18950000E-04  +9.09770000E-04  -6.99220000E-04
   -2.11403000E-03  -1.57950000E-04  -7.20920000E-04  +5.59880000E-04  +1.45880000E-04
   +3.96800000E-05  -3.79100000E-05  +1.92610000E-04  +6.35000000E-05  +2.70200000E-05
   -8.54700000E-05  -1.77480000E-04  +1.98600000E-05  +9.75000000E-06  -1.59524800E-02
   -5.40920000E-04  +1.40011400E-02  -6.67380000E-04  -8.72160000E-04  +6.61600000E-04
   -8.54800000E-05  +5.73300000E-05  +2.27000000E-05  -2.96795000E-02  -1.04142650E-01
   -2.13977200E-02  +2.41739400E-02  +3.18994900E-02  +7.75516000E-03  -2.67756100E-02
   -1.85770700E-02  +9.55960000E-03  +3.57760000E-04  -2.81650500E-02  -4.91194500E-02
   -1.51054110E-01  -1.93655530E-01  -2.39548700E-02  +2.15632380E-01  +4.32971860E-01
   +8.77000000E-06  +2.36320000E-04  -3.15290000E-04  -1.85728000E-03  -2.15713000E-03
   +1.36340000E-04  -5.19100000E-05  +1.44110000E-04  -1.87350000E-04  -2.85380000E-04
   +4.38970000E-04  +1.87540000E-04  +1.29980000E-04  -4.06750000E-04  +1.27540000E-04
   +2.38780000E-04  -7.88300000E-05  +1.51150000E-04  -1.69760000E-03  +3.01382000E-03
   +8.16734000E-03  -1.00502000E-03  +5.70380000E-04  +5.79660000E-04  -3.87740000E-04
   +2.09180000E-04  +5.12800000E-05  +1.36020890E-01  +1.76689900E-02  -2.08923940E-01
   +1.37894900E-02  -2.32660300E-02  -4.57750600E-02  +2.00199600E-02  +1.17634400E-02
   -9.84081000E-03  -3.34171200E-02  -1.53206600E-02  +1.98425900E-02  -3.23635900E-02
   -6.44226100E-02  -1.23325610E-01  -1.24175940E-01  +1.98459160E-01  +6.26393880E-01
   +5.35350000E-04  +1.78550000E-04  -3.71620000E-04  +8.28700000E-05  -9.26920000E-04
   -3.48100000E-05  +2.04300000E-04  +1.86710000E-04  -3.91900000E-04  -3.83260000E-04
   +4.69600000E-04  -2.84900000E-05  +5.86470000E-04  -6.61110000E-04  -4.44300000E-05
   -2.55100000E-05  -2.83540000E-04  +4.32620000E-04  +1.39139000E-03  +6.78690000E-04
   +5.24700000E-04  -4.94120000E-04  -1.11320000E-04  +3.03860000E-04  -9.52850000E-04
   +4.81180000E-04  +1.67780000E-04  -1.48071000E-03  -1.79361000E-03  -3.14603000E-03
   +3.30121000E-03  +1.00335000E-03  +6.69219000E-03  -3.42650000E-02  -3.66647300E-02
   -3.39858000E-03  -2.03098380E-01  -1.12907930E-01  +2.00119700E-02  -5.28300000E-04
   -1.20537800E-02  -8.95023000E-03  +2.38670000E-04  -9.11900000E-04  +4.36825000E-03
   +2.77553810E-01  +3.78290000E-04  +6.80700000E-05  -3.09160000E-04  +4.87500000E-05
   -9.09390000E-04  -1.05910000E-04  +2.15360000E-04  +1.35820000E-04  -4.21320000E-04
   -3.74520000E-04  +5.18150000E-04  -3.18900000E-05  +5.14570000E-04  -6.85220000E-04
   -1.15000000E-06  +4.41800000E-05  -2.74390000E-04  +4.41470000E-04  +1.51656000E-03
   +8.04000000E-05  +1.06445000E-03  -4.43170000E-04  -1.27000000E-04  +2.58140000E-04
   -9.19620000E-04  +4.86860000E-04  +1.60610000E-04  -2.17966000E-03  -1.42647000E-03
   +1.92987000E-03  -2.83667000E-03  +3.09835000E-03  -3.22599000E-03  -1.82754300E-02
   -6.65617000E-03  -2.66110000E-03  -1.36667910E-01  -1.62958320E-01  -1.93638700E-02
   -2.96619100E-02  -2.51948800E-02  -1.45759800E-02  +1.98265000E-03  +4.72884000E-03
   -3.38025000E-03  +1.59124900E-01  +3.17952890E-01  +1.64630000E-04  +1.59260000E-04
   -2.07250000E-04  +3.40000000E-05  -3.36810000E-04  +9.08500000E-05  +7.92800000E-05
   +5.36300000E-05  -8.13700000E-05  -1.43160000E-04  +1.43780000E-04  +2.17800000E-05
   +1.40180000E-04  -1.87300000E-04  +5.79000000E-06  +1.20000000E-07  -4.18500000E-05
   +7.78200000E-05  +1.97900000E-05  +3.18520000E-04  +4.14940000E-04  -1.01440000E-04
   -5.67000000E-05  +7.77000000E-06  -2.25090000E-04  +1.20550000E-04  +4.97300000E-05
   -3.44595000E-03  +1.85564000E-03  +5.75300000E-03  +6.61860000E-04  -7.91714000E-03
   -6.16310000E-03  +2.54413100E-02  +2.01622500E-02  +9.74289000E-03  -1.72696100E-02
   -4.87209800E-02  -9.90454500E-02  -3.73152000E-02  -3.70742600E-02  -4.74011000E-03
   +9.30467000E-03  +5.73000000E-04  -5.80534000E-03  -6.01949600E-02  +2.62756070E-01
   +5.17221100E-01  -5.14921000E-03  +1.11348000E-03  +2.51844000E-03  -1.10305700E-02
   +2.54967400E-02  -1.79691800E-02  -2.21759000E-03  +9.75870000E-04  -6.08100000E-05
   -1.71150000E-04  +8.72240000E-04  -8.23530000E-04  +2.31670000E-04  -3.08790000E-04
   +8.93500000E-05  +9.12000000E-05  +5.11150000E-04  -2.47800000E-04  -7.90797900E-02
   +1.40653200E-02  -1.13051700E-02  -1.48690000E-04  +1.55681000E-03  -3.83676000E-03
   -4.74570000E-04  +2.99380000E-04  +9.30600000E-05  +3.51110000E-03  -1.89939100E-02
   +1.45874500E-02  -4.93440000E-04  -1.19578000E-03  +4.74020000E-04  -3.32910000E-04
   +5.25580000E-04  +2.40950000E-04  +5.68610000E-04  +6.33800000E-04  +4.82060000E-04
   -1.15622000E-03  +2.46090000E-04  -1.01043000E-03  -7.21810000E-04  -1.46723000E-03
   -9.31980000E-04  -1.11748000E-03  -1.10154000E-03  -3.25920000E-04  +5.78564210E-01
   +1.12711000E-03  +7.16030000E-04  -5.18770000E-04  +9.74521000E-03  -1.34779900E-02
   +7.94259000E-03  -1.12180000E-04  -3.49410000E-04  -6.83270000E-04  -4.42280000E-04
   -4.32210000E-04  +4.49170000E-04  +2.50370000E-04  -3.43700000E-05  +3.03400000E-05
   -4.37100000E-05  -3.89660000E-04  +3.01980000E-04  +1.99813300E-02  -1.30379550E-01
   +4.64466100E-02  -1.20243000E-03  +7.28623000E-03  -2.25066000E-03  -2.06400000E-04
   +6.73100000E-05  +7.13500000E-05  -4.93489000E-03  -3.00973900E-02  +1.50110700E-02
   +2.48900000E-05  -5.35730000E-04  +1.32758000E-03  -2.90670000E-04  +8.15250000E-04
   +2.05180000E-04  +1.80750000E-04  +4.84370000E-04  +5.46630000E-04  -8.49430000E-04
   +8.10300000E-05  -1.04071000E-03  +1.61847000E-03  -6.87260000E-04  -1.04967000E-03
   -5.24150000E-04  -5.76390000E-04  -1.95380000E-04  +2.56086900E-02  +5.08038970E-01
   +2.83012000E-03  -7.30960000E-04  -9.48940000E-04  -8.17710000E-04  -5.40662000E-03
   +5.42589000E-03  +1.32806000E-03  -1.02001000E-03  -5.84510000E-04  +1.17320000E-04
   -2.09730000E-04  -1.14600000E-05  -1.72560000E-04  +5.97900000E-05  +1.94600000E-04
   +6.05700000E-05  +1.29980000E-04  -3.43100000E-05  -1.39328100E-02  +4.27421700E-02
   -1.09769380E-01  -8.34762000E-03  +2.58879500E-02  -3.41152000E-02  +3.46060000E-04
   -1.64980000E-04  -9.51700000E-05  +4.75821000E-03  +3.86637000E-03  +1.74072000E-03
   -1.43451000E-03  -1.38092000E-03  -3.43000000E-04  +1.52430000E-04  +2.00210000E-04
   -1.42450000E-04  +1.54900000E-04  +2.08070000E-04  +4.14440000E-04  -9.63000000E-05
   -2.17490000E-04  -3.27240000E-04  -4.18770000E-04  -2.83300000E-04  -2.69060000E-04
   -4.95790000E-04  -4.74270000E-04  -2.03170000E-04  -2.05741400E-02  +5.83321700E-02
   +5.49838990E-01  -1.64232130E-01  -1.57497000E-02  +9.49512800E-02  +1.56348300E-02
   -2.92280000E-04  -3.57955000E-03  -2.13056000E-03  +5.33556000E-03  -7.71690000E-04
   -1.01533000E-03  -3.64862000E-03  +2.77282000E-03  -8.80980000E-04  +6.83446000E-03
   -3.66334000E-03  -3.38554900E-02  -1.42900500E-02  +4.39430200E-02  -1.91531000E-03
   -1.27626000E-03  -7.76730000E-04  +1.22225000E-03  +2.14090000E-04  +1.27142000E-03
   -1.35301000E-03  -1.14533000E-03  +1.57069000E-03  -2.90042000E-03  +2.80610000E-04
   -2.54307000E-03  -3.38050000E-04  +1.50881000E-03  +9.51520000E-04  -2.50560000E-04
   -1.48550000E-04  +2.04990000E-04  +8.97920000E-04  +2.31950000E-04  -2.09360000E-04
   +6.01100000E-04  +6.83560000E-04  -9.17600000E-05  -6.18450000E-04  +8.59450000E-04
   -1.07030000E-03  -5.54410000E-04  -3.96820000E-04  -1.81570000E-04  +5.09950000E-04
   -5.94900000E-05  -3.00530000E-04  +3.47027500E-01  -4.55551900E-02  -1.23364460E-01
   +9.44731700E-02  -2.23665800E-02  -2.05549400E-02  +4.25391900E-02  +1.12231600E-02
   -1.70098000E-03  -2.26549000E-03  -6.45196000E-03  +2.90029000E-03  +4.08060000E-04
   +1.72988000E-03  -5.93448000E-03  +5.20646000E-03  +4.00846000E-03  +1.26799800E-02
   -1.61224000E-03  -3.96709000E-03  +1.05588000E-03  -2.57518000E-03  +2.04204000E-03
   -1.66292000E-03  -1.89416000E-03  +7.17500000E-05  +9.30350000E-04  -1.05397000E-03
   +1.21690000E-04  -7.37140000E-04  +2.82560000E-04  -3.47670000E-04  -8.90100000E-05
   +3.84120000E-04  +3.88260000E-04  +4.77640000E-04  -2.86250000E-04  -4.52000000E-06
   +9.17100000E-05  +2.90280000E-04  +1.15420000E-04  +1.86810000E-04  -1.62290000E-04
   +5.38400000E-04  +1.26140000E-04  +1.93500000E-05  +1.86020000E-04  +2.57410000E-04
   -4.21600000E-05  -1.79560000E-04  +3.94090000E-04  -4.60000000E-05  -1.59290180E-01
   +4.65916590E-01  +1.17060340E-01  +7.36539100E-02  -1.89109180E-01  +1.49423000E-02
   +2.43348200E-02  -2.52483100E-02  -3.82767000E-03  +1.82417000E-03  +5.56310000E-03
   +3.83192000E-03  -1.13180000E-04  -3.93811000E-03  +2.89622000E-03  +4.25595000E-03
   +4.97989000E-03  +2.91773100E-02  +8.89381000E-03  -2.03643900E-02  +2.38565000E-03
   -3.87658000E-03  -1.00296000E-03  -2.52700000E-04  +6.48890000E-04  -1.61388000E-03
   +1.01626000E-03  +2.68000000E-06  -2.94290000E-04  -1.83883000E-03  +1.61665000E-03
   -2.37140000E-04  -1.27880000E-04  +1.60620000E-04  -4.84050000E-04  -8.45000000E-06
   +5.60400000E-05  +4.18580000E-04  +9.83000000E-06  +3.53800000E-05  -9.07700000E-05
   -2.11400000E-04  -5.02430000E-04  +2.60470000E-04  -8.76500000E-05  -2.70280000E-04
   -4.74440000E-04  -2.47520000E-04  -2.51500000E-04  +5.63500000E-05  -1.95060000E-04
   -6.96400000E-05  +5.11730000E-04  -8.07882200E-02  -2.54261040E-01  +3.06868370E-01
   -8.79800000E-05  -6.02900000E-05  +7.72900000E-05  -5.06000000E-06  +4.43600000E-05
   -2.22400000E-05  -3.41700000E-05  -1.16400000E-05  +5.09700000E-05  +3.49400000E-05
   -2.72100000E-05  +1.25500000E-05  -9.86400000E-05  +4.99500000E-05  +2.57400000E-05
   +2.94400000E-05  +5.14200000E-05  -3.91800000E-05  -1.49740000E-04  -8.88000000E-06
   +1.07380000E-04  +5.68600000E-05  +3.57200000E-05  -2.08400000E-05  +1.16590000E-04
   -4.42700000E-05  -1.80200000E-05  -1.13640000E-04  +2.18900000E-04  +6.27860000E-04
   -6.59600000E-04  -1.16360000E-04  -2.24270000E-04  +1.09782000E-03  -4.03200000E-05
   -2.48343000E-03  -4.14590000E-04  -1.98181600E-02  -3.41930700E-02  -3.92774000E-03
   -4.34903000E-03  +5.96170000E-04  +1.52711000E-03  -5.77270000E-04  -7.70210000E-04
   -4.03557200E-02  +2.51789600E-02  +8.56617000E-02  +3.21600000E-05  +2.71000000E-06
   -1.59800000E-05  +1.01460000E-04  +6.83700000E-05  -1.53400000E-05  +4.39239600E-02
   -6.07800000E-05  +2.25100000E-05  +2.94100000E-05  +7.56000000E-06  +1.07750000E-04
   +1.61800000E-05  -3.54500000E-05  -1.68700000E-05  +7.11400000E-05  +5.31600000E-05
   -8.56100000E-05  +1.83000000E-05  -8.80800000E-05  +1.24620000E-04  +9.10000000E-07
   -9.43000000E-06  +5.37800000E-05  -8.67700000E-05  -1.79430000E-04  -8.36800000E-05
   +3.38000000E-05  +7.35400000E-05  +1.22100000E-05  -2.69500000E-05  +1.62320000E-04
   -9.06400000E-05  -2.80300000E-05  -1.15490000E-04  +3.68740000E-04  +6.00380000E-04
   +5.39600000E-05  -8.52190000E-04  -3.93290000E-04  +2.99919000E-03  +2.11031000E-03
   +9.51050000E-04  +2.41734000E-03  -1.99283000E-02  -3.03278700E-02  -5.07621000E-03
   -1.52372000E-03  +6.82450000E-04  +3.00820000E-04  +8.26210000E-04  -1.80572000E-03
   +1.19677000E-03  -1.26498850E-01  -1.95998810E-01  +6.97400000E-05  +2.02500000E-05
   +1.49400000E-05  +5.13200000E-05  -5.66200000E-05  +4.60900000E-05  -9.77240000E-04
   +1.45629720E-01  -8.60900000E-05  -7.72900000E-05  +9.97500000E-05  -1.66600000E-05
   +9.96100000E-05  -8.94000000E-06  -3.22700000E-05  -1.72700000E-05  +3.23100000E-05
   +4.45700000E-05  -3.85200000E-05  -1.12200000E-05  -7.17300000E-05  +5.15800000E-05
   +1.50200000E-05  +2.37800000E-05  +6.51000000E-06  -2.96300000E-05  -1.62000000E-04
   -2.90900000E-05  -1.51130000E-04  +3.83800000E-05  +5.04000000E-06  -2.28700000E-05
   +8.59300000E-05  -4.23200000E-05  -2.34000000E-05  +1.10340000E-04  +1.46260000E-04
   +2.96800000E-04  +6.06900000E-05  -1.54630000E-04  -1.00171000E-03  +2.36015000E-03
   +4.75716000E-03  +3.72617000E-03  +8.90180000E-04  -2.73764000E-03  -8.13671000E-03
   -6.11920000E-04  -2.74820000E-04  +2.35561000E-03  +6.94140000E-04  -6.98840000E-04
   -2.26720000E-04  +4.77742900E-02  -2.25757280E-01  -4.19662450E-01  +1.34840000E-04
   +8.31300000E-05  +7.08100000E-05  +1.05460000E-04  +4.97100000E-05  -3.16300000E-05
   -5.09665400E-02  +2.24966540E-01  +4.23043410E-01  -1.02300000E-05  -5.73200000E-05
   +6.60000000E-06  +7.89500000E-05  -2.35300000E-05  +2.18000000E-06  +2.77700000E-05
   +1.46600000E-05  -3.85100000E-05  -4.87300000E-05  +6.61900000E-05  +1.64700000E-05
   +1.91200000E-05  -7.38800000E-05  +1.98000000E-05  +1.26300000E-05  +2.65000000E-05
   +2.65200000E-05  +5.82450000E-04  -3.94730000E-04  -9.41040000E-04  -2.89010000E-04
   -1.72360000E-04  +8.70100000E-05  -6.14000000E-05  +4.98400000E-05  +2.13800000E-05
   -7.96240000E-04  -5.73522000E-03  +1.22201000E-03  +4.10657000E-03  -1.17954400E-02
   -2.09138100E-02  -5.20504300E-02  -9.65791000E-03  +8.43632000E-03  +4.08602000E-03
   +1.18060900E-02  +1.85721000E-02  -1.47085000E-03  -2.65688000E-03  +4.46485000E-03
   -1.48838000E-03  -4.23830000E-04  +6.57700000E-05  +9.57700000E-04  +3.17575000E-03
   -1.03167000E-03  -2.62400000E-05  +8.68400000E-05  -7.31600000E-05  -6.00000000E-08
   +7.93800000E-05  -2.70000000E-07  -6.33360000E-04  -1.10685000E-03  -2.59440000E-04
   +4.77573000E-02  +9.00300000E-05  +7.66800000E-05  -6.45300000E-05  +2.03750000E-04
   -9.35400000E-05  +1.16000000E-06  +1.06700000E-05  +3.77000000E-05  -1.53900000E-05
   -3.64000000E-05  +3.28700000E-05  +2.08600000E-05  +6.68000000E-05  -3.89300000E-05
   -2.47700000E-05  -2.54500000E-05  -1.25500000E-05  +3.70200000E-05  +1.97130000E-04
   +6.60900000E-05  -9.90670000E-04  -2.85180000E-04  -2.74870000E-04  +8.42500000E-05
   -8.95800000E-05  +4.20100000E-05  +2.38600000E-05  -5.82735000E-03  +1.77672000E-03
   -1.44430000E-03  +2.17301000E-03  -7.76685000E-03  -1.86759200E-02  -9.76396000E-03
   -1.23948120E-01  -1.31879230E-01  -3.14323000E-03  +3.53666000E-03  +3.09210000E-03
   -2.29723000E-03  +3.43395000E-03  -3.40820000E-04  -2.35550000E-04  -6.17620000E-04
   +7.36520000E-04  +2.89823000E-03  +3.51200000E-05  +2.67476000E-03  -5.28800000E-05
   +4.23000000E-06  -3.38200000E-05  -7.48800000E-05  -4.44700000E-05  +4.73000000E-06
   +2.63780000E-04  +1.92970000E-04  -9.24280000E-04  +1.36472900E-02  +1.25731780E-01
   -1.79000000E-06  -8.37800000E-05  +8.95000000E-06  -3.39100000E-05  -6.14400000E-05
   +5.31000000E-06  +3.97800000E-05  +1.32100000E-05  -7.35000000E-05  -4.84000000E-05
   +7.31300000E-05  -8.64000000E-06  +3.85700000E-05  -9.85000000E-05  +2.45400000E-05
   +2.34500000E-05  -5.20000000E-06  +4.87300000E-05  +4.28030000E-04  -4.57400000E-05
   -1.57050000E-04  -1.12710000E-04  -3.74800000E-05  +5.73300000E-05  -9.57000000E-05
   +6.17900000E-05  +1.83900000E-05  +7.02280000E-04  -2.09533000E-03  +3.27611000E-03
   +1.19599000E-03  -1.17877000E-03  -1.06738000E-03  +8.21465000E-03  -1.31868160E-01
   -2.51730360E-01  -4.89233000E-03  -1.53835400E-02  -1.42096500E-02  +4.97875000E-03
   +8.57000000E-06  -7.36190000E-04  +3.40650000E-04  +9.66770000E-04  +1.97860000E-04
   -1.61389000E-03  +2.19581000E-03  +1.53924000E-03  -6.82500000E-05  +6.60000000E-07
   -5.07000000E-05  +5.97000000E-06  +8.77600000E-05  -1.81900000E-05  +1.90024000E-03
   +7.90870000E-04  -5.43810000E-04  -9.16272000E-03  +1.45581870E-01  +2.64718760E-01
   -2.57280000E-04  -1.65210000E-04  -3.40220000E-04  -6.40830000E-04  -7.88450000E-04
   -9.13690000E-04  -3.92230000E-04  -1.82800000E-04  -1.19390000E-04  -3.20200000E-05
   -2.15300000E-05  +8.65800000E-05  -1.58470000E-04  +1.21090000E-04  +1.00310000E-04
   +1.39770000E-04  +4.87900000E-05  -7.01200000E-05  -1.30290000E-03  +8.06930000E-04
   -9.53020000E-04  -8.58000000E-05  +1.43920000E-04  -7.36100000E-05  +1.78780000E-04
   -9.07900000E-05  -4.55600000E-05  +3.63020000E-03  -3.95760000E-04  -7.93000000E-06
   -1.93991680E-01  -2.98175700E-02  +1.42699030E-01  -1.19148800E-02  -1.50582000E-03
   +1.69415700E-02  +8.71290000E-04  -5.50103000E-03  -2.81090000E-04  -2.54440000E-04
   +1.68900000E-04  -9.15650000E-04  +2.91973000E-03  -2.11449000E-03  +8.38020000E-04
   -1.19223000E-03  -4.04770000E-04  +7.54670000E-04  +4.43300000E-05  +3.57000000E-06
   +2.27340000E-04  +2.47300000E-05  +2.59100000E-05  +2.35880000E-04  +7.41900000E-05
   +1.75600000E-04  +1.57090000E-04  -6.67400000E-04  +1.90231000E-03  -1.45163000E-03
   +2.02843880E-01  -1.36520000E-04  +4.49660000E-04  -3.19090000E-04  -3.13410000E-04
   -1.20610000E-04  -2.25470000E-04  -2.05290000E-04  -1.36710000E-04  -1.58620000E-04
   -5.76400000E-05  +5.72000000E-06  +5.50700000E-05  -5.45600000E-05  +3.89800000E-05
   +8.07000000E-05  +1.93680000E-04  -1.68610000E-04  -1.20000000E-04  +1.55324000E-03
   -1.35170000E-03  +1.02070000E-03  +1.71400000E-04  +6.99000000E-05  +7.62000000E-05
   +1.19920000E-04  -9.42900000E-05  -3.71800000E-05  +1.25723900E-02  +7.21091000E-03
   -1.10578200E-02  -2.93653500E-02  -5.31501700E-02  +1.37378500E-02  -1.56951000E-02
   +1.25051000E-03  +1.54586400E-02  -5.33824000E-03  +1.36009000E-03  -3.70046000E-03
   +1.53870000E-04  -1.14114000E-03  -7.87600000E-05  -2.61137000E-03  +1.47012000E-03
   -4.96705000E-03  -1.06740000E-03  -3.40380000E-04  +7.69340000E-04  -1.24740000E-04
   -3.65840000E-04  -4.67010000E-04  -1.63780000E-04  -3.03700000E-04  +2.23070000E-04
   +8.51200000E-05  +1.15420000E-04  +1.45240000E-04  +2.22938000E-03  -1.74721000E-03
   +1.52644000E-03  +3.70760900E-02  +4.76709900E-02  +2.78200000E-05  +6.47110000E-04
   -4.94110000E-04  +2.84500000E-05  -2.85550000E-04  +1.87050000E-04  -5.04380000E-04
   +6.32000000E-05  +5.38090000E-04  +3.29500000E-05  -2.06030000E-04  +6.94000000E-05
   -2.61000000E-04  +1.16570000E-04  +1.44200000E-05  -6.02500000E-05  +2.02880000E-04
   -1.31840000E-04  +2.77050000E-04  +1.84769000E-03  -5.72790000E-04  -2.06560000E-04
   -2.49900000E-05  +3.36100000E-05  +3.82180000E-04  -1.71260000E-04  -6.06600000E-05
   +2.01391900E-02  +4.44529000E-03  -1.30008900E-02  +1.42044390E-01  +1.44483000E-02
   -1.88943900E-01  -4.89178000E-03  -1.89610000E-03  +6.66710000E-03  +1.02840000E-04
   -3.29857000E-03  +2.66854000E-03  -1.10810000E-03  -2.43860000E-04  -2.55630000E-04
   +6.96040000E-04  -5.45392000E-03  -2.82486000E-03  -7.21900000E-05  +5.86000000E-05
   +2.14810000E-04  -6.18900000E-05  -6.45300000E-05  -1.45510000E-04  -2.52900000E-04
   -1.87660000E-04  +3.17380000E-04  -2.66300000E-05  +1.59000000E-06  -8.22000000E-06
   -1.11930000E-03  +1.87053000E-03  -1.89540000E-04  -1.56109880E-01  -1.24207800E-02
   +1.96563080E-01  -1.25670000E-04  -1.70030000E-04  +3.30520000E-04  -2.04290000E-04
   -8.80300000E-05  -2.58000000E-04  -5.95500000E-05  -2.53400000E-05  -6.08000000E-06
   +8.17400000E-05  -2.29700000E-05  -1.65000000E-06  -4.62300000E-05  +5.84300000E-05
   +1.76900000E-05  +4.88000000E-05  +1.42000000E-05  -7.20200000E-05  -4.16280000E-04
   +1.97957000E-03  -9.12350000E-04  -1.38960000E-03  -1.15491000E-03  +5.58830000E-04
   +7.28700000E-05  -3.83600000E-05  -2.69600000E-05  +5.74785000E-03  +1.20196400E-02
   +1.82692400E-02  -1.38839000E-03  -3.07585000E-03  +5.00057000E-03  -1.30425000E-03
   -2.22220000E-04  -6.61700000E-05  -3.74490000E-04  -5.74159000E-03  +1.44505000E-03
   +3.67239000E-03  -1.26779100E-02  -2.03506400E-02  -5.32341600E-02  -7.37628000E-03
   +6.06455000E-03  +1.32710000E-04  -6.01850000E-04  -1.05429000E-03  +3.53970000E-04
   +1.06530000E-04  -1.05180000E-04  +2.34240000E-04  -6.33200000E-05  -2.51760000E-04
   -2.92660000E-04  -1.70740000E-04  -1.42450000E-04  -1.65040000E-04  +3.12710000E-04
   -1.93920000E-04  +1.09120000E-04  +7.30830000E-04  +1.05616000E-03  +5.08608600E-02
   +1.84910000E-04  +3.03910000E-04  -3.36320000E-04  +2.67560000E-04  +3.94370000E-04
   -1.38530000E-04  +9.57200000E-05  -8.92000000E-05  +2.61400000E-05  +1.98300000E-05
   -6.24400000E-05  +5.58000000E-06  -1.71800000E-05  +7.56800000E-05  -3.68300000E-05
   -9.24800000E-05  +2.25200000E-05  +3.25400000E-05  +1.50135000E-03  -2.09109000E-03
   +8.41640000E-04  -2.20416000E-03  -9.16810000E-04  +2.46030000E-04  +7.18000000E-05
   -4.91300000E-05  +4.60000000E-07  +2.25730000E-04  +6.46811000E-03  +2.84404000E-03
   -3.02972000E-03  +3.79583000E-03  -8.92430000E-04  -8.29100000E-05  -6.25320000E-04
   +8.31980000E-04  -5.88770000E-03  +2.42800000E-03  -1.77710000E-03  +7.57290000E-04
   -7.05040000E-03  -1.90028400E-02  -6.94375000E-03  -1.23681280E-01  -1.30586470E-01
   -3.87800000E-05  -6.41620000E-04  -1.07277000E-03  -4.62150000E-04  -3.28620000E-04
   -9.48000000E-06  -3.42900000E-04  -2.01910000E-04  +3.17870000E-04  -1.25910000E-04
   -2.82230000E-04  +5.01000000E-06  +3.00950000E-04  -3.85940000E-04  +1.81950000E-04
   -4.46200000E-05  +1.33320000E-04  +3.18670000E-04  +1.49751300E-02  +1.26502540E-01
   -3.21900000E-05  -2.63500000E-05  -4.62100000E-05  -8.70300000E-05  -2.49500000E-05
   +1.27100000E-04  -2.18500000E-05  +3.41200000E-05  +1.48600000E-05  -1.17700000E-05
   +2.03700000E-05  +4.76000000E-06  +1.08000000E-06  -2.11100000E-05  -8.07000000E-06
   -1.65400000E-05  -1.76000000E-06  +1.99000000E-05  -1.93347000E-03  -8.29200000E-05
   -1.29724000E-03  -8.32430000E-04  -1.35136000E-03  +1.87160000E-04  -2.49500000E-05
   +2.23200000E-05  +1.23200000E-05  -1.62190000E-03  -1.21164400E-02  -1.36084400E-02
   +5.01696000E-03  -4.94080000E-04  -7.00900000E-04  +5.19400000E-05  +8.72910000E-04
   +2.96400000E-04  +1.33665000E-03  -1.82119000E-03  +3.18860000E-03  +1.81174000E-03
   -1.43935000E-03  -6.04980000E-04  +6.73865000E-03  -1.31158400E-01  -2.64616460E-01
   -1.62300000E-04  -3.32630000E-04  -2.94640000E-04  +4.83930000E-04  +1.95280000E-04
   +3.27800000E-05  +8.84000000E-05  +5.50700000E-05  +8.10200000E-05  -5.77200000E-05
   +7.46100000E-05  -2.16000000E-06  -2.24510000E-04  +1.43010000E-04  -1.92750000E-04
   -1.28790000E-04  -6.41450000E-04  -8.28170000E-04  -7.52257000E-03  +1.45958340E-01
   +2.77434520E-01  -1.19100000E-05  -8.51800000E-05  +1.23110000E-04  +1.63700000E-05
   -1.86140000E-04  -1.31300000E-05  -4.83300000E-05  +5.40800000E-05  -1.78700000E-05
   -1.40200000E-05  +3.62200000E-05  +2.86000000E-06  +2.56900000E-05  -4.83900000E-05
   -8.40000000E-07  +1.71000000E-05  -2.50100000E-05  +3.50800000E-05  -1.42130000E-04
   +2.37290000E-04  +8.54340000E-04  -3.71000000E-05  +7.17800000E-05  +6.14200000E-05
   -6.92500000E-05  +3.73900000E-05  +5.37000000E-06  +3.57680000E-04  -5.63536000E-03
   -1.38760000E-04  -2.15530000E-04  +1.11600000E-04  -9.19580000E-04  +2.58865000E-03
   -1.93464000E-03  +7.25630000E-04  +3.02176000E-03  -2.30349000E-03  -9.16760000E-04
   -1.95681490E-01  -3.59606300E-02  +1.46000000E-01  -1.12103600E-02  -8.46840000E-04
   +1.61248800E-02  -4.42220000E-04  +1.87064000E-03  -9.40770000E-04  -1.70090000E-04
   -7.61100000E-05  -8.39600000E-05  +4.86700000E-05  +1.15380000E-04  -1.73780000E-04
   -1.53960000E-04  +2.45640000E-04  -1.23010000E-04  +1.35830000E-04  +3.83100000E-05
   -1.56490000E-04  -2.45020000E-04  +2.90890000E-04  -1.03040000E-04  -7.95390000E-04
   +2.04327000E-03  -1.45811000E-03  +2.03041290E-01  -3.07800000E-05  -2.89000000E-06
   -5.37000000E-06  -1.99470000E-04  -3.02250000E-04  -2.87000000E-06  -3.61000000E-06
   +3.11900000E-05  -4.67300000E-05  -4.75200000E-05  +5.97100000E-05  +2.36200000E-05
   +3.77000000E-05  -6.23900000E-05  +1.80300000E-05  +1.91600000E-05  -1.15400000E-05
   +7.00000000E-06  -5.25930000E-04  +3.70730000E-04  +5.43020000E-04  +5.00900000E-05
   +3.76500000E-05  +8.54700000E-05  -6.70500000E-05  +3.56100000E-05  +1.22600000E-05
   -5.21954000E-03  +1.11173000E-03  -3.18487000E-03  +1.50000000E-07  -1.23942000E-03
   -2.63850000E-04  -2.25631000E-03  +9.55870000E-04  -4.54870000E-03  +1.20660400E-02
   +7.23781000E-03  -1.21620400E-02  -3.67236100E-02  -5.24767400E-02  +1.87744600E-02
   -1.43176800E-02  +1.04307000E-03  +1.58286000E-02  +1.75256000E-03  -8.47110000E-04
   +2.13523000E-03  -8.83800000E-05  +4.22000000E-05  -3.95900000E-05  +2.57000000E-06
   -1.41600000E-05  +4.98000000E-06  +1.94690000E-04  -1.58790000E-04  +3.98590000E-04
   +7.04150000E-04  +1.14400000E-04  -6.23800000E-04  +2.57790000E-04  -3.06010000E-04
   +2.82120000E-04  +2.28431000E-03  -1.82616000E-03  +1.49334000E-03  +4.20886300E-02
   +4.62297800E-02  -1.40200000E-05  -2.00200000E-05  +4.57100000E-05  +4.85600000E-05
   +2.22900000E-05  -1.16000000E-05  -1.97700000E-05  +4.07000000E-06  +2.92200000E-05
   +1.82000000E-05  -1.66500000E-05  +2.67000000E-06  -2.44700000E-05  +2.36500000E-05
   -1.77000000E-06  +8.00000000E-07  +1.45000000E-05  -1.13100000E-05  -1.89950000E-04
   -1.28060000E-04  +3.07350000E-04  +1.56300000E-05  +6.31900000E-05  -1.39400000E-05
   +3.27900000E-05  -1.45000000E-05  -5.69000000E-06  -6.81000000E-05  -2.93520000E-03
   +2.60312000E-03  -1.20116000E-03  -5.34010000E-04  -4.14600000E-04  +2.74050000E-04
   -4.90931000E-03  -2.64838000E-03  +2.21736800E-02  +6.26136000E-03  -1.28695200E-02
   +1.44884560E-01  +1.76764900E-02  -1.90943910E-01  -5.46647000E-03  -1.31577000E-03
   +7.38782000E-03  -1.19285000E-03  +1.90662000E-03  +1.02046000E-03  -1.95000000E-06
   -3.13400000E-05  -2.36400000E-05  +3.06900000E-05  +1.35200000E-05  -3.39800000E-05
   -1.96700000E-04  +3.40820000E-04  +2.46740000E-04  +9.16260000E-04  +2.01580000E-04
   -8.40810000E-04  -1.15630000E-04  +2.61390000E-04  -1.37900000E-04  -1.04892000E-03
   +1.90362000E-03  -1.19250000E-04  -1.58873410E-01  -1.87147100E-02  +1.96474680E-01
   -4.08550000E-04  -2.13300000E-04  +5.79390000E-04  +6.75080000E-04  +8.37080000E-04
   -9.49440000E-04  +1.19200000E-04  -1.78600000E-04  +2.61120000E-04  +2.88400000E-05
   +2.72440000E-04  -1.64340000E-04  +6.93400000E-05  -1.57970000E-04  -8.37000000E-06
   -5.73800000E-05  +9.09100000E-05  -9.70000000E-07  -7.61593000E-03  +2.17010000E-03
   +2.17048000E-03  -5.79200000E-05  -3.60890000E-04  +7.92690000E-04  -2.30430000E-04
   +1.37540000E-04  +1.12300000E-05  +7.63040000E-04  -1.43653000E-03  -3.33570000E-04
   +3.86480000E-04  +3.15940000E-04  +3.59580000E-04  -3.23510000E-04  -8.10300000E-05
   +1.44300000E-05  +1.06590000E-04  -1.22500000E-05  -2.59230000E-04  +1.52970000E-04
   +1.85030000E-04  +5.03000000E-06  +1.86770000E-04  +1.28900000E-05  +1.81340000E-04
   -1.21700000E-05  -3.91100000E-05  +1.97700000E-05  -2.69954250E-01  +8.29768500E-02
   +6.21057800E-02  +2.28620000E-04  +1.34860000E-04  -2.91860000E-04  -6.18000000E-06
   +9.45000000E-06  +1.80000000E-06  -7.51000000E-06  +1.01400000E-05  -1.21000000E-06
   +3.96300000E-05  -7.17400000E-05  -9.65000000E-06  +1.94700000E-05  +5.08900000E-05
   -2.87400000E-05  +1.99300000E-05  +1.54700000E-05  +1.11000000E-05  +2.90542850E-01
   +1.63885000E-03  -1.61700000E-05  -6.41250000E-04  +2.31980000E-04  -3.38648000E-03
   +3.64073000E-03  -6.75310000E-04  -2.16350000E-04  +8.45370000E-04  +1.85130000E-04
   +1.64960000E-04  -1.05890000E-04  -2.42430000E-04  +7.84000000E-05  +7.45600000E-05
   -2.34100000E-05  -9.86500000E-05  +1.67200000E-05  +2.29733100E-02  -1.12831200E-02
   -5.83571000E-03  -2.33220000E-04  +4.13070000E-04  -1.40091000E-03  +2.20550000E-04
   -9.62700000E-05  -8.59600000E-05  +1.40933000E-03  +7.10590000E-04  -2.15270000E-04
   -2.24240000E-04  -2.44770000E-04  -5.63200000E-04  +2.52960000E-04  +1.29440000E-04
   -8.19500000E-05  -2.79330000E-04  -1.56440000E-04  +2.14570000E-04  -2.59710000E-04
   -1.61580000E-04  -4.92000000E-06  -1.86680000E-04  +1.77110000E-04  +3.90000000E-05
   +2.28530000E-04  +2.38430000E-04  +4.89900000E-05  +8.07767100E-02  -7.60571900E-02
   -2.35173600E-02  -2.33780000E-04  -4.60500000E-05  +1.61580000E-04  -1.01800000E-05
   -3.80300000E-05  -2.22700000E-05  +1.08100000E-05  +3.84000000E-06  +1.38500000E-05
   +6.00000000E-06  +8.53300000E-05  +1.45050000E-04  +4.26600000E-05  -3.79700000E-05
   +1.02780000E-04  +1.08700000E-05  -8.61000000E-06  -6.28000000E-06  -9.09350000E-02
   +8.39238400E-02  -9.76300000E-04  +5.61910000E-04  +5.08680000E-04  -2.31440000E-04
   +2.83115000E-03  -2.37500000E-03  +7.15270000E-04  +5.24130000E-04  -4.66320000E-04
   -1.58760000E-04  -1.13880000E-04  +3.05500000E-04  +8.15200000E-05  -8.18100000E-05
   -1.87600000E-05  +6.58100000E-05  +2.30000000E-05  -1.10350000E-04  -1.79023400E-02
   +7.37620000E-03  +2.85471000E-03  -1.35113000E-03  +5.35300000E-04  +1.07159000E-03
   -9.63000000E-06  -3.41200000E-05  +2.86100000E-05  -4.88070000E-04  -2.51340000E-04
   +4.02950000E-04  +3.07650000E-04  +5.93800000E-05  -2.65850000E-04  -3.33760000E-04
   -7.89100000E-05  +8.40400000E-05  +1.13040000E-04  -5.50000000E-07  -1.87000000E-04
   +9.56900000E-05  +1.10500000E-04  +1.84300000E-05  -1.94830000E-04  -1.46610000E-04
   +1.98180000E-04  -1.09350000E-04  -8.62800000E-05  -1.23300000E-05  +6.34139100E-02
   -2.46948300E-02  -6.40816100E-02  +1.17100000E-05  -1.31380000E-04  +5.90400000E-05
   +1.49200000E-05  +9.00000000E-08  +1.31100000E-05  +1.68300000E-05  -1.66000000E-05
   -3.00000000E-07  +1.97700000E-05  +2.00300000E-05  +1.05450000E-04  +2.66400000E-05
   +5.65000000E-06  -9.24200000E-05  -1.30000000E-07  -1.50000000E-07  +1.28800000E-05
   -6.77582500E-02  +2.22251400E-02  +6.90823300E-02  +1.06730000E-04  -1.20560000E-04
   -1.75300000E-04  +2.70820000E-04  -1.03140000E-04  +2.30520000E-04  -7.46030000E-04
   +7.11010000E-04  +8.94930000E-04  +6.63200000E-05  +1.10960000E-04  -1.26550000E-04
   -1.38490000E-04  +7.84000000E-06  +9.82000000E-06  +2.89600000E-05  +2.59600000E-05
   -2.77500000E-05  +4.54592000E-03  +6.39393000E-03  +7.15910000E-04  +3.81420000E-04
   +3.75190000E-04  +1.66250000E-04  +9.79400000E-05  -3.13100000E-05  -3.45500000E-05
   +2.52260000E-04  -7.07400000E-05  -6.71500000E-04  +3.57180000E-04  +3.30650000E-04
   +5.35360000E-04  -2.59930000E-04  -1.27040000E-04  +8.66400000E-05  +2.52340000E-04
   +1.21930000E-04  -1.73390000E-04  +1.52610000E-04  +3.77300000E-05  +5.13600000E-05
   +4.88610000E-04  +1.57600000E-05  -1.43010000E-04  -1.75720000E-04  -1.56800000E-04
   -1.94200000E-05  -1.62170920E-01  -1.30065180E-01  -1.88813500E-02  +4.14000000E-05
   +2.38200000E-05  +8.86400000E-05  +1.67800000E-05  +3.41900000E-05  +1.42400000E-05
   -2.40800000E-05  -3.09000000E-06  -1.65300000E-05  -2.12900000E-05  -9.80000000E-06
   -1.18700000E-05  -7.87300000E-05  +7.99900000E-05  -1.59700000E-05  +5.00000000E-07
   -3.37000000E-06  +9.47000000E-06  -1.74000700E-02  -2.20861400E-02  -4.16577000E-03
   +1.75501560E-01  +8.99700000E-05  -4.38990000E-04  +4.41720000E-04  -8.88040000E-04
   +8.17410000E-04  -1.92580000E-04  +2.81000000E-05  -4.40890000E-04  +7.15320000E-04
   +2.25030000E-04  +4.08780000E-04  -3.36450000E-04  -1.04690000E-04  -8.46500000E-05
   -5.64500000E-05  -1.03610000E-04  +1.21660000E-04  +4.53200000E-05  -1.68319600E-02
   -1.79101600E-02  -3.35239000E-03  -4.82200000E-04  +7.60630000E-04  -1.67198000E-03
   -9.54400000E-05  +1.06600000E-04  -2.83200000E-05  +1.48169000E-03  -3.12847000E-03
   +3.82975000E-03  -3.10070000E-04  -1.42230000E-04  +3.82240000E-04  -1.24900000E-05
   +1.90040000E-04  +5.11700000E-05  +2.95570000E-04  +4.85610000E-04  +4.95210000E-04
   -6.02980000E-04  -2.86520000E-04  -5.06930000E-04  +4.76080000E-04  -3.41000000E-04
   -5.40740000E-04  -6.02820000E-04  -5.92520000E-04  -1.92240000E-04  -1.28770930E-01
   -1.93685820E-01  -2.07366300E-02  +2.30640000E-04  +2.94290000E-04  -2.91000000E-04
   +2.95600000E-05  +5.22000000E-05  +6.83100000E-05  -3.16800000E-05  -5.66200000E-05
   -4.58600000E-05  +1.20200000E-05  +6.78500000E-05  -7.83800000E-05  +6.05600000E-05
   -9.82100000E-05  +1.69320000E-04  -1.03290000E-04  -1.82700000E-05  -2.48600000E-05
   +7.51321000E-03  +9.12725000E-03  +1.56150000E-03  +1.41847650E-01  +2.10836180E-01
   -1.65500000E-05  +3.43800000E-05  -1.45680000E-04  +1.88070000E-04  -5.91170000E-04
   +2.74380000E-04  -1.03180000E-04  -6.62020000E-04  +4.99680000E-04  -4.84200000E-05
   +2.10130000E-04  -1.48500000E-04  -7.46500000E-05  -6.96200000E-05  +1.02390000E-04
   +9.86100000E-05  -1.29000000E-05  -4.02000000E-05  +1.34374400E-02  +1.43124600E-02
   +6.28880000E-04  +9.52940000E-04  +7.93670000E-04  +1.01229000E-03  -3.09000000E-06
   +3.49200000E-05  -2.98100000E-05  -1.71379000E-03  +2.26207000E-03  -1.76549000E-03
   -3.81400000E-05  -4.00630000E-04  -5.88800000E-05  +7.59650000E-04  +1.08170000E-04
   +1.01400000E-05  -3.76200000E-04  -2.71500000E-05  +3.99610000E-04  -5.01000000E-05
   -3.88790000E-04  +2.21800000E-05  +6.08110000E-04  +4.98290000E-04  +1.00780000E-04
   +2.75300000E-04  +2.95510000E-04  +3.06900000E-05  -1.85159600E-02  -2.17246900E-02
   -5.17164900E-02  +2.95000000E-05  -1.76000000E-05  -8.81800000E-05  -4.70000000E-07
   -1.23100000E-05  -3.79500000E-05  +3.12200000E-05  +1.76400000E-05  +1.67400000E-05
   -3.01800000E-04  +3.57730000E-04  +2.93000000E-06  -2.40200000E-05  +1.00640000E-04
   -8.45200000E-05  +2.53100000E-05  +3.69100000E-05  -1.67400000E-05  +5.33624000E-03
   +6.95529000E-03  +1.83150000E-04  +2.02078100E-02  +2.08691900E-02  +5.29008600E-02
   +1.41030000E-04  +3.13520000E-04  -1.80430000E-04  +5.31450000E-04  -6.34050000E-04
   -2.92110000E-04  -6.13620000E-04  +5.21740000E-04  -5.46330000E-04  -5.22700000E-05
   -1.33490000E-04  +2.38990000E-04  -6.88000000E-06  +2.94200000E-05  +1.57900000E-05
   +3.79000000E-05  -2.93700000E-05  -4.94300000E-05  -1.87722000E-03  -2.74135000E-03
   -7.13965000E-03  -3.45350000E-04  +1.48166000E-03  -8.06110000E-04  +1.16920000E-04
   -8.78400000E-05  +6.50000000E-06  -2.12080000E-04  +1.06000000E-04  +7.95490000E-04
   +7.09300000E-05  -1.83090000E-04  -1.93470000E-04  -1.77490000E-04  -6.19000000E-06
   -8.10000000E-07  -3.75500000E-05  -6.61600000E-05  -1.44400000E-05  +3.75100000E-05
   +1.01600000E-05  +1.96500000E-05  -4.90400000E-05  -7.27100000E-05  +6.60900000E-05
   +2.44000000E-05  +4.06300000E-05  -9.80000000E-07  -4.71114300E-02  -2.53223000E-03
   -7.04252000E-03  -1.58110000E-04  -1.93810000E-04  +2.35470000E-04  -2.70000000E-07
   -2.12600000E-05  +4.51000000E-06  +2.84900000E-05  -1.31700000E-05  +1.08600000E-05
   +1.53600000E-04  +2.71200000E-05  +7.36500000E-05  +3.60000000E-06  +2.58800000E-05
   -5.73300000E-05  -3.73000000E-06  +1.20400000E-05  -8.01000000E-06  +1.80286000E-03
   +8.14454000E-03  +2.85833100E-02  -6.55680000E-04  -5.05029000E-03  -2.07252500E-02
   +4.94312900E-02  -2.24880000E-04  -2.66390000E-04  +9.07200000E-05  -5.37260000E-04
   +1.08146000E-03  -4.19600000E-04  +6.28380000E-04  +4.17710000E-04  -2.67000000E-04
   +8.87100000E-05  -1.97970000E-04  +9.13100000E-05  +8.82800000E-05  +9.28400000E-05
   -1.51400000E-04  -1.01150000E-04  +4.64000000E-06  +7.04800000E-05  -3.57010000E-04
   +7.11457000E-03  +2.37279600E-02  +9.59810000E-04  -3.81576000E-03  +2.66357000E-03
   -3.79300000E-05  -1.28800000E-05  +3.06100000E-05  +7.28710000E-04  +1.34635000E-03
   +4.29500000E-04  -3.40590000E-04  -1.45650000E-04  +5.71310000E-04  -2.00250000E-04
   -2.30670000E-04  -1.96990000E-04  +6.22900000E-05  -1.39700000E-04  -3.35450000E-04
   +2.32050000E-04  +2.41640000E-04  +2.20810000E-04  -4.02960000E-04  -1.36530000E-04
   +5.08400000E-05  +1.64680000E-04  +1.33770000E-04  +4.17700000E-05  -3.08075000E-03
   -7.05991500E-02  -7.58324700E-02  -2.66000000E-06  +2.88400000E-05  -8.63500000E-05
   -2.26900000E-05  -1.95400000E-05  -1.65000000E-05  -5.34000000E-06  -3.65000000E-06
   +2.54900000E-05  +2.51330000E-04  -7.25200000E-04  -1.06560000E-04  +5.67200000E-05
   +1.41000000E-06  -3.06300000E-05  +1.06200000E-05  -2.37000000E-06  +5.10000000E-07
   -1.25590000E-03  -3.72730000E-03  -9.69877000E-03  +1.22256000E-03  -6.31899000E-03
   -2.23579600E-02  +1.33937000E-03  +7.53028100E-02  -7.25500000E-05  +5.21790000E-04
   -2.30000000E-04  +1.05186000E-03  -7.13860000E-04  +5.23420000E-04  +7.55320000E-04
   +4.64280000E-04  -3.80000000E-06  -2.57620000E-04  -7.74400000E-05  +3.51020000E-04
   +4.99100000E-05  -1.88090000E-04  +3.72000000E-05  +1.32330000E-04  -1.15830000E-04
   -5.33700000E-05  +1.22950000E-04  -6.73680000E-03  -1.77438300E-02  -8.92850000E-04
   +4.80169000E-03  -2.05706000E-03  -2.39300000E-05  -1.50300000E-05  +3.13400000E-05
   -1.22233000E-03  -1.02322000E-03  +6.53280000E-04  +9.05400000E-05  -6.54590000E-04
   +9.34000000E-06  +6.14260000E-04  +3.35880000E-04  +1.68570000E-04  -2.52060000E-04
   +2.11520000E-04  +5.40000000E-04  -3.90130000E-04  -4.18080000E-04  -2.07320000E-04
   +8.15480000E-04  +3.00640000E-04  -3.18990000E-04  -2.61400000E-05  -1.21300000E-05
   -2.41400000E-05  -7.20204000E-03  -7.34692100E-02  -2.92649870E-01  -9.20600000E-05
   -3.54000000E-06  +3.28920000E-04  +1.35400000E-05  +1.49700000E-05  -3.08000000E-06
   +3.45300000E-05  +1.24200000E-05  +0.00000000E+00  -2.35300000E-04  +2.21520000E-04
   +1.91700000E-04  -1.21100000E-04  -3.44400000E-05  +1.04680000E-04  -6.53000000E-06
   +1.65200000E-05  -1.56600000E-05  -8.09470000E-04  -1.96462000E-03  -6.72150000E-03
   +5.05760000E-04  -5.42400000E-05  -1.37164000E-03  +7.76725000E-03  +7.97137500E-02
   +3.18761630E-01  -6.33470000E-04  -6.30400000E-05  +1.21947000E-03  +1.59810000E-04
   -4.50580000E-04  +5.86000000E-06  -2.34110000E-04  -1.90000000E-07  +1.02780000E-04
   +2.00820000E-04  -6.32600000E-05  -2.52100000E-05  -6.04700000E-05  +1.50180000E-04
   +2.12800000E-05  +1.17700000E-05  -1.93100000E-05  -8.60000000E-05  -1.88616000E-03
   +6.78710000E-04  -8.06090000E-04  -5.44253600E-02  +2.87561600E-02  -2.58907000E-02
   +7.61700000E-05  -4.16300000E-05  -3.22600000E-05  +2.05210000E-04  +6.02910000E-04
   -2.11990000E-04  -1.07670000E-04  -9.99300000E-05  -7.71400000E-05  +1.25070000E-04
   +1.27510000E-04  +4.90900000E-05  -7.97700000E-05  -1.31700000E-05  +3.16100000E-05
   -1.18020000E-04  -4.96000000E-05  +2.93700000E-04  +2.37880000E-04  -2.32290000E-04
   -7.12180000E-04  +8.30700000E-05  +1.13350000E-04  +6.37200000E-05  +8.39000000E-06
   -3.55310000E-04  -6.33270000E-04  -4.16840000E-04  +1.38948000E-03  -5.82490000E-04
   -6.77000000E-06  -8.61000000E-06  -6.16000000E-06  +1.03800000E-05  +8.63000000E-06
   +1.68900000E-05  -1.53300000E-05  +3.67900000E-05  +6.90100000E-05  -1.22909000E-03
   +1.68810000E-04  -1.01550000E-04  -1.10100000E-05  -4.08000000E-06  -2.15000000E-05
   +4.27660000E-04  -3.03550000E-04  +2.09060000E-04  +6.76300000E-05  +3.57800000E-04
   -7.63500000E-05  +6.28990000E-04  +2.42930000E-04  -1.89610000E-04  +5.54365300E-02
   +9.67330000E-04  +7.47240000E-04  -1.21829000E-03  -3.49820000E-04  +3.09870000E-04
   +6.46900000E-04  +1.44050000E-04  +3.61000000E-06  -4.08400000E-05  -1.45960000E-04
   +3.33400000E-05  +3.65500000E-05  +2.82700000E-05  -9.93300000E-05  -3.05900000E-05
   -2.02730000E-04  -7.12800000E-05  +2.50900000E-04  -2.11704000E-03  +9.99852000E-03
   -8.79619000E-03  +2.94562300E-02  -1.95263410E-01  +1.36398450E-01  -1.22120000E-04
   +3.42400000E-05  +2.26100000E-05  -7.39900000E-05  +6.12780000E-04  +1.90980000E-04
   +1.88060000E-04  -1.06200000E-05  -1.83600000E-05  +9.35500000E-05  +3.74000000E-05
   -4.05800000E-05  -9.63800000E-05  -5.78400000E-05  +1.32140000E-04  +3.33200000E-05
   -1.40310000E-04  -1.85030000E-04  -5.02370000E-04  +2.57670000E-04  +1.96440000E-04
   +6.50700000E-05  +3.67400000E-05  -2.18500000E-05  -2.89460000E-04  -5.22470000E-04
   -2.09733000E-03  +9.93690000E-04  -3.87514000E-03  -1.03460000E-04  -1.21500000E-05
   -8.39000000E-06  -8.18000000E-06  +9.72000000E-06  +1.37600000E-05  +0.00000000E+00
   -1.91900000E-05  +1.50400000E-05  -3.45300000E-05  -2.14430000E-04  -1.34380000E-04
   -2.93010000E-04  -1.47200000E-05  +3.79900000E-05  -1.09900000E-05  -1.80410000E-04
   -4.39800000E-05  -1.05720000E-04  +1.96690000E-04  +1.43940000E-04  -1.93660000E-04
   -1.30080000E-04  +7.26670000E-04  -5.93180000E-04  -3.22440400E-02  +2.11292810E-01
   +1.63803000E-03  +6.97720000E-04  -2.14189000E-03  -7.45470000E-04  +2.23470000E-04
   +1.17140000E-03  +4.88480000E-04  +1.13050000E-04  -2.13690000E-04  -2.99770000E-04
   +7.38000000E-05  +8.00400000E-05  +5.47300000E-05  -1.61650000E-04  +1.61800000E-05
   -1.29600000E-04  -1.48870000E-04  +1.22110000E-04  -4.48908000E-03  +2.25430800E-02
   -1.87642300E-02  -2.51218400E-02  +1.32245840E-01  -1.69534350E-01  -7.02200000E-05
   +2.40600000E-05  +5.34800000E-05  +7.17290000E-04  +1.00384000E-03  +1.23228000E-03
   +9.51400000E-05  -4.30390000E-04  -1.37580000E-04  +2.07350000E-04  +1.88620000E-04
   +1.25500000E-05  -1.19480000E-04  +8.52100000E-05  +2.15030000E-04  -2.00250000E-04
   -2.26920000E-04  +8.46300000E-05  +2.94200000E-05  -1.24220000E-04  -3.32500000E-05
   +1.03800000E-05  +2.67000000E-06  +3.93000000E-06  +2.08320000E-04  -3.54436000E-03
   -5.79826000E-03  -9.86690000E-04  +6.61900000E-04  +1.24711000E-03  -1.00100000E-05
   +5.38000000E-06  -6.90000000E-06  -2.22500000E-05  +3.04200000E-05  -2.16500000E-05
   -3.55600000E-05  +7.25300000E-05  +3.27500000E-05  -4.35410000E-04  +5.37400000E-05
   +1.02430000E-04  -2.05700000E-05  -1.15400000E-05  -1.44500000E-05  -6.86500000E-05
   -1.41690000E-04  +1.75790000E-04  +1.83690000E-04  -1.59470000E-04  +2.47210000E-04
   -5.69220000E-04  +1.51334000E-03  -1.34182000E-03  +2.84931300E-02  -1.45291700E-01
   +1.85165970E-01  +9.86100000E-05  -1.86860000E-04  +2.33080000E-04  +6.39370000E-04
   +1.37405000E-03  +5.83140000E-04  +3.40650000E-04  -1.38190000E-04  -4.06400000E-05
   +3.07000000E-06  +5.02000000E-06  -9.53100000E-05  -5.18600000E-05  +3.05200000E-05
   +1.74100000E-05  -5.89000000E-06  +1.06000000E-06  -3.40700000E-05  -1.89027000E-03
   -6.51900000E-05  +1.08410000E-03  -2.03781420E-01  -1.32326510E-01  -1.18874000E-02
   +6.14400000E-05  -2.44500000E-05  -1.35600000E-05  +5.89130000E-04  +1.24720000E-04
   +7.69100000E-05  +6.06800000E-05  +3.60400000E-05  +2.66220000E-04  -5.93200000E-05
   -5.12600000E-05  -1.21140000E-04  +6.64500000E-05  +9.73000000E-05  +1.62100000E-05
   +1.69840000E-04  -8.69100000E-05  -3.02250000E-04  -2.06330000E-04  -2.95500000E-05
   +5.06790000E-04  -1.37160000E-04  -1.63150000E-04  -8.07100000E-05  -2.88720000E-04
   -1.07580000E-04  +3.34740000E-04  -5.14500000E-05  +1.21230000E-04  -1.68920000E-04
   +1.28600000E-05  +1.78700000E-05  +1.16000000E-05  -3.26500000E-05  -5.02000000E-06
   -2.55300000E-05  +8.53100000E-05  -3.54300000E-05  -6.40700000E-05  +2.16040000E-04
   +5.02200000E-05  -5.72270000E-04  -2.24000000E-06  -9.64000000E-06  +1.97600000E-05
   +3.80000000E-05  -1.36850000E-04  +1.23700000E-05  +2.05710000E-04  +4.17520000E-04
   -5.18690000E-04  +2.41460000E-04  +2.93780000E-04  +3.12100000E-05  +4.58871000E-03
   +4.12147000E-03  +8.12280000E-04  +2.18607880E-01  -2.55480000E-04  -5.77380000E-04
   +6.23570000E-04  -7.88390000E-04  +3.99930000E-04  +3.13350000E-04  +3.92100000E-04
   +8.62100000E-05  -1.46290000E-04  +2.45500000E-05  +9.83600000E-05  -1.08630000E-04
   +6.86100000E-05  -1.40050000E-04  -4.04800000E-05  +1.41110000E-04  -5.04400000E-05
   +2.67400000E-05  -8.93835000E-03  -9.54157000E-03  -7.36300000E-04  -1.31548450E-01
   -1.57732720E-01  -8.14660000E-03  -1.30570000E-04  +9.51400000E-05  +3.84900000E-05
   +8.33890000E-04  +6.29900000E-05  -2.54785000E-03  -7.77720000E-04  -9.34300000E-05
   +1.99670000E-04  -7.13900000E-05  -2.59550000E-04  -1.32620000E-04  +2.65630000E-04
   +1.27740000E-04  -8.63800000E-05  -2.79900000E-05  +1.23660000E-04  +1.31500000E-05
   +2.26970000E-04  +2.61590000E-04  -2.22520000E-04  -2.26820000E-04  -2.06440000E-04
   -3.47400000E-05  +6.25290000E-04  +3.36580000E-04  +9.00110000E-04  +5.14080000E-04
   -1.64860000E-04  -3.20290000E-04  +2.77700000E-05  +3.08600000E-05  +2.21400000E-05
   -4.08300000E-05  -1.01570000E-04  -6.17000000E-06  +1.24200000E-05  +3.46500000E-05
   -7.67200000E-05  +1.93480000E-04  -2.05330000E-04  +1.23910000E-04  -3.65800000E-05
   -3.38000000E-06  -3.36000000E-06  +1.00480000E-04  +4.78900000E-05  +9.00000000E-06
   -1.29000000E-05  +5.19200000E-04  +1.34780000E-04  +2.09750000E-04  +3.93000000E-05
   -5.70200000E-05  -1.83835100E-02  -1.35613900E-02  -2.60231000E-03  +1.44577920E-01
   +1.69068120E-01  +7.69200000E-05  -2.06340000E-04  +2.73180000E-04  -1.30931000E-03
   +1.92780000E-04  +1.11180000E-03  +1.96570000E-04  +1.83750000E-04  +5.76300000E-05
   +2.08600000E-05  +8.12500000E-05  -1.15510000E-04  +7.70100000E-05  -9.99900000E-05
   -3.97500000E-05  -7.37900000E-05  -8.36500000E-05  +1.26890000E-04  -2.37085900E-02
   -2.05110100E-02  -4.01172000E-03  -9.39307000E-03  -6.61754000E-03  -4.68550500E-02
   -2.21030000E-04  +1.11800000E-04  +2.93500000E-05  +1.16709000E-03  -9.51380000E-04
   -5.73616000E-03  -1.58169000E-03  -1.17508000E-03  +1.86600000E-04  +1.50510000E-04
   -2.39510000E-04  -3.16810000E-04  +1.51130000E-04  +1.80860000E-04  +2.50000000E-07
   -2.05510000E-04  -5.83800000E-05  +2.43660000E-04  +9.41980000E-04  +1.89300000E-05
   -7.23290000E-04  -1.83610000E-04  -1.33020000E-04  +1.23700000E-05  -7.02760000E-04
   -1.27732000E-03  +1.28559000E-03  -5.32300000E-05  +2.95140000E-04  -1.82910000E-04
   +2.44600000E-05  +2.82700000E-05  +1.62900000E-05  -1.20410000E-04  -1.15980000E-04
   -4.00400000E-05  -1.11300000E-05  +5.67000000E-05  -2.03200000E-05  -8.98400000E-05
   +3.71220000E-04  +4.58600000E-04  -2.91500000E-05  -3.94200000E-05  +2.90000000E-07
   +6.42800000E-05  +6.29800000E-05  -7.33600000E-05  +1.52580000E-04  +6.92800000E-04
   -5.34680000E-04  +3.50520000E-04  +1.15850000E-04  +2.71070000E-04  +1.79997600E-02
   +1.21841500E-02  +1.76827000E-03  +1.14318700E-02  +1.17596900E-02  +5.33044600E-02
   +1.89330000E-04  -3.65310000E-04  +1.72380000E-04  +4.45700000E-04  +3.06850000E-04
   +7.26330000E-04  +7.11990000E-04  +3.27200000E-04  -3.26580000E-04  -2.11860000E-04
   +1.97100000E-04  -4.39900000E-05  +2.06880000E-04  -2.62430000E-04  -6.27000000E-06
   -2.49900000E-05  -1.35570000E-04  +9.69300000E-05  +1.12108000E-03  -1.21761000E-03
   -9.56400000E-04  -2.35235410E-01  +1.11080790E-01  +4.96248200E-02  -3.07040000E-04
   +1.65290000E-04  +6.78100000E-05  -1.07240000E-04  -1.05510000E-04  +3.80180000E-04
   +1.22920000E-04  +1.03260000E-04  +1.22000000E-05  +5.83300000E-05  +3.01200000E-05
   -3.03800000E-05  -1.96620000E-04  -2.48200000E-05  +6.70500000E-05  +1.32840000E-04
   -1.31750000E-04  -3.93020000E-04  -8.11310000E-04  -1.02125000E-03  +5.82560000E-04
   +7.94800000E-05  +2.80700000E-05  -3.84400000E-05  +4.70020000E-04  -2.61570000E-04
   -7.01580000E-04  +1.02820000E-04  +9.24900000E-05  -7.74200000E-05  -1.81000000E-05
   -1.19200000E-05  -9.28000000E-06  +1.10100000E-05  +2.21400000E-05  -6.20000000E-07
   -1.00200000E-05  -6.66000000E-06  -2.69000000E-05  -4.66780000E-04  -1.59748000E-03
   -5.96380000E-04  +3.18600000E-05  -1.00000000E-08  +2.36200000E-05  +3.98950000E-04
   -2.09040000E-04  +1.45820000E-04  -1.92820000E-04  +7.92500000E-05  +1.37610000E-04
   +2.62930000E-04  -2.18730000E-04  -3.75700000E-05  -3.02851000E-03  +4.05930000E-04
   +7.43340000E-04  -1.95628800E-02  +1.30217800E-02  +4.85115000E-03  +2.55880670E-01
   -2.27950000E-04  -1.48390000E-04  +7.43100000E-04  -7.93340000E-04  +3.85720000E-04
   -2.38759000E-03  -2.71000000E-05  -3.86200000E-04  +1.20830000E-04  +4.08180000E-04
   -9.68700000E-05  +2.31000000E-06  -1.76180000E-04  +2.76540000E-04  -1.03490000E-04
   +4.37000000E-05  +1.64970000E-04  -2.15500000E-05  +1.04101300E-02  -6.48959000E-03
   -1.79239000E-03  +1.10025360E-01  -1.11922970E-01  -2.89019400E-02  +2.79580000E-04
   -1.60650000E-04  -6.10400000E-05  +6.31140000E-04  +3.87850000E-04  +2.95410000E-04
   -2.72990000E-04  -1.61340000E-04  -1.03440000E-04  +1.36820000E-04  +1.64650000E-04
   +8.27300000E-05  -4.13700000E-05  -3.53300000E-05  +4.73600000E-05  -3.05170000E-04
   +9.26300000E-05  +4.51720000E-04  +2.01180000E-04  -5.27380000E-04  -1.13672000E-03
   +8.29000000E-05  +1.33790000E-04  +9.52400000E-05  -1.52930000E-04  +2.99650000E-04
   +1.35624000E-03  +1.30320000E-04  -6.21080000E-04  -4.83210000E-04  -3.27000000E-06
   -1.18500000E-05  -3.48000000E-06  +5.08000000E-06  +1.26000000E-06  +1.83400000E-05
   +1.07100000E-05  +4.48900000E-05  +1.29470000E-04  -1.23963000E-03  -1.37283000E-03
   +5.99320000E-04  -1.09300000E-05  -3.06000000E-05  -2.24600000E-05  -1.93950000E-04
   +5.64750000E-04  +1.05280000E-04  -1.79130000E-04  -3.33100000E-05  -8.16300000E-05
   -2.28320000E-04  -9.07400000E-05  +2.93100000E-05  +1.94742900E-02  -1.02418000E-02
   -6.72137000E-03  -1.78875200E-02  +1.14017300E-02  +5.10413000E-03  -1.20201170E-01
   +1.18418760E-01  +1.12319000E-03  +8.06090000E-04  -1.40351000E-03  -9.93740000E-04
   -1.81437000E-03  -5.43043000E-03  +3.04080000E-04  -7.85500000E-04  +1.39400000E-04
   +5.70090000E-04  -9.81400000E-05  +2.67580000E-04  -2.57590000E-04  +3.98960000E-04
   -2.58850000E-04  -2.06160000E-04  +3.48750000E-04  +9.75600000E-05  +2.62000000E-02
   -1.38350700E-02  -7.72231000E-03  +4.81583300E-02  -2.78696200E-02  -6.02683400E-02
   +5.64910000E-04  -3.12080000E-04  -7.37400000E-05  +3.40660000E-04  +5.17180000E-04
   +7.99190000E-04  -1.04290000E-04  +4.82000000E-06  -2.49270000E-04  +1.36850000E-04
   +1.36330000E-04  +1.06100000E-05  -1.13400000E-04  -3.84200000E-05  +1.67820000E-04
   -1.73170000E-04  -8.89100000E-05  +2.16000000E-06  -2.38660000E-04  +1.88200000E-04
   +1.77700000E-04  +6.92000000E-05  +7.60200000E-05  +9.10000000E-06  +1.49227000E-03
   -9.19670000E-04  +1.14508000E-03  -8.80260000E-04  +1.19400000E-05  +1.12187000E-03
   -4.57000000E-06  -1.72200000E-05  -7.03000000E-06  +2.16400000E-05  -9.08000000E-06
   +1.07000000E-05  +5.11100000E-05  +2.25000000E-06  +6.85500000E-05  -9.44100000E-05
   -1.36820000E-04  +4.55790000E-04  +4.24000000E-06  -9.14000000E-06  -1.15000000E-06
   -7.37040000E-04  +3.76140000E-04  -7.42570000E-04  +1.30800000E-05  +1.43300000E-04
   -6.91600000E-05  -2.53570000E-04  +2.59800000E-05  +4.78690000E-04  -1.91335200E-02
   +8.96698000E-03  +5.73528000E-03  -1.50068000E-03  +1.27044000E-03  -4.96660000E-04
   -5.44005300E-02  +3.28175600E-02  +6.61402900E-02  -7.40930000E-04  +1.54460000E-04
   +4.43570000E-03  +1.00954900E-02  -1.41424800E-02  +8.58451000E-03  -7.87488200E-02
   +7.21909500E-02  -3.66810000E-02  -4.11763000E-03  +2.34341500E-02  -1.41028300E-02
   -2.96638000E-03  +3.74508000E-03  +3.19651000E-03  -1.09058000E-03  -5.21230000E-04
   +6.84470000E-04  -2.22450000E-04  -9.54380000E-04  -1.64459000E-03  +3.39140000E-04
   +1.68420000E-04  -1.38310000E-04  -3.28630000E-04  +1.12977000E-03  -7.70640000E-04
   -2.79020000E-04  +7.52100000E-05  -5.55500000E-05  -2.66900000E-05  +8.19300000E-05
   +8.61900000E-05  +2.55000000E-06  +1.43700000E-05  -5.37000000E-05  -5.75400000E-05
   -7.64800000E-05  -2.23200000E-05  +2.87300000E-05  +2.32800000E-05  +4.07000000E-05
   -2.80600000E-05  -4.56000000E-06  -1.47800000E-05  +9.02500000E-05  +8.80900000E-05
   +1.68000000E-05  -2.33233000E-03  +4.70960000E-04  +1.59206000E-03  +4.26200000E-04
   -1.18320000E-03  +6.98840000E-04  -9.48000000E-06  -1.84900000E-05  -5.91000000E-06
   +8.92000000E-06  +4.52000000E-06  +1.18600000E-05  +8.64900000E-05  -5.32200000E-05
   -1.25000000E-05  -7.22000000E-06  -9.35000000E-06  +8.10000000E-07  +9.72000000E-06
   -2.84000000E-06  -1.13000000E-06  +8.65100000E-05  -2.04700000E-04  -6.65700000E-05
   -9.80950000E-04  +8.38460000E-04  +4.80720000E-04  -2.18141000E-03  +3.78800000E-04
   -1.02010000E-04  +6.41000000E-06  -2.01200000E-05  -1.48490000E-04  +3.83200000E-05
   -3.52000000E-05  +7.18000000E-06  -3.12700000E-05  -4.29700000E-05  -4.22500000E-05
   +8.36954200E-02  -6.85300000E-05  +2.47169000E-03  +3.50699000E-03  +4.21599000E-03
   -5.97295000E-03  +6.60498000E-03  +7.12176700E-02  -2.41603320E-01  +1.25250220E-01
   +2.86475000E-03  -6.20922000E-03  +7.42271000E-03  +3.11106000E-03  +3.06093000E-03
   +1.17673000E-03  -5.16970000E-04  +6.06510000E-04  -5.85180000E-04  +9.81100000E-05
   -2.32330000E-03  -1.56749000E-03  +3.61380000E-04  -9.50300000E-05  -1.67200000E-04
   +3.11980000E-04  -7.53610000E-04  +3.13750000E-04  -2.70320000E-04  +2.52150000E-04
   +3.30970000E-04  -1.19980000E-04  +4.97500000E-05  +1.72230000E-04  +3.56000000E-06
   -7.34000000E-06  -7.36500000E-05  +1.36400000E-05  +2.35400000E-05  +2.17300000E-05
   -4.20000000E-06  -1.13900000E-05  +6.99000000E-06  -9.39500000E-05  -9.63100000E-05
   -1.03450000E-04  -1.42400000E-05  -2.29200000E-05  -2.17500000E-05  +2.41058000E-03
   +1.88600000E-05  -6.39890000E-04  +2.37190000E-04  -8.58230000E-04  +3.96100000E-04
   -4.82000000E-06  -4.99000000E-06  +7.40000000E-06  -5.01000000E-06  -1.63000000E-05
   +4.04000000E-06  +4.45600000E-05  -1.11000000E-04  +6.38000000E-06  +1.26800000E-05
   -1.26000000E-06  -7.01000000E-06  -4.86000000E-06  -1.53900000E-05  -1.02000000E-06
   +2.02710000E-04  +1.16440000E-04  -6.19510000E-04  +1.44848000E-03  -3.61490000E-04
   -5.12760000E-04  -7.58800000E-05  -1.36780000E-04  -4.88250000E-04  +6.28000000E-06
   -1.18700000E-05  -5.21800000E-05  -5.57000000E-06  -9.43000000E-06  +1.92500000E-05
   -7.35900000E-05  +1.13200000E-05  -9.05000000E-05  -8.39838100E-02  +2.53004600E-01
   +4.65728000E-03  +3.57169000E-03  +5.74350000E-04  -6.93218000E-03  +1.81881700E-02
   -5.92290000E-03  -3.61918400E-02  +1.24971460E-01  -1.22975580E-01  +3.83506000E-03
   -6.13334000E-03  +7.41451000E-03  +3.43591000E-03  +1.27686000E-03  +3.45882000E-03
   +4.76330000E-04  -4.58640000E-04  -4.37590000E-04  -2.46118000E-03  -9.12830000E-04
   -1.81597000E-03  +6.84620000E-04  -1.48060000E-04  -9.27500000E-05  -1.78000000E-05
   -3.74230000E-04  +2.17300000E-04  -2.72760000E-04  +1.24360000E-04  +3.54350000E-04
   -1.91900000E-05  -1.74000000E-06  +1.25060000E-04  -1.81400000E-05  -3.87400000E-05
   -1.73000000E-06  +5.14100000E-05  +7.10100000E-05  +1.32200000E-05  -6.48000000E-06
   -3.18000000E-05  -8.50000000E-06  -7.31900000E-05  -1.10040000E-04  -8.33700000E-05
   -7.83500000E-05  -8.69800000E-05  -2.88300000E-05  -6.48400000E-05  +6.65050000E-04
   +5.48560000E-04  -5.30190000E-04  +9.44700000E-04  -6.89520000E-04  -1.53000000E-06
   +1.19100000E-05  +8.17000000E-06  -1.19500000E-05  -1.22500000E-05  -8.16000000E-06
   +1.06500000E-05  +1.89000000E-05  -2.19700000E-05  +5.93000000E-06  +1.51800000E-05
   -1.64300000E-05  -1.38100000E-05  -8.32000000E-06  -1.49000000E-06  -4.75050000E-04
   -3.97560000E-04  +1.19550000E-04  +5.65590000E-04  -1.15244000E-03  -3.44990000E-04
   -2.77760000E-04  +7.36400000E-05  +3.13480000E-04  -4.83600000E-05  -1.88900000E-05
   +7.54400000E-05  -1.36800000E-05  -2.15800000E-05  -7.56700000E-05  +8.03000000E-06
   -5.93300000E-05  -2.09470000E-04  +3.53310900E-02  -1.38034970E-01  +1.21621670E-01
   -1.48145000E-03  +7.68960000E-04  -5.40740000E-04  -2.67573000E-03  +4.17542000E-03
   +1.25790000E-03  -1.11646700E-02  -1.31975700E-02  +1.94468700E-02  -1.42944140E-01
   -6.09979400E-02  +1.24082970E-01  +8.39910000E-03  +7.07487000E-03  -7.13071000E-03
   +1.63031000E-03  +1.32005000E-03  +1.60720000E-04  +2.20470000E-04  -5.47000000E-04
   +1.00060000E-03  -3.30580000E-04  +1.11520000E-04  -5.14600000E-05  +2.03740000E-04
   -2.04632000E-03  -8.96830000E-04  +1.03000000E-05  +1.96870000E-04  +8.43500000E-05
   -3.19500000E-05  -6.04000000E-06  +1.17400000E-05  -2.33900000E-05  -1.99500000E-05
   +4.40000000E-06  +3.81900000E-05  +3.06400000E-05  +5.55000000E-06  -3.99000000E-06
   -1.92700000E-05  +5.77000000E-06  -4.83400000E-05  -6.28600000E-05  -3.58600000E-05
   -5.13500000E-05  -5.03300000E-05  -1.69400000E-05  +3.54100000E-05  -1.19800000E-04
   +1.20300000E-05  +4.50410000E-04  +1.24600000E-04  -2.20360000E-04  +1.69000000E-06
   +5.80000000E-06  +7.14000000E-06  -1.27800000E-05  -1.29900000E-05  -6.67000000E-06
   +4.57000000E-06  +1.72700000E-05  +2.11600000E-05  +8.07000000E-06  +1.48100000E-05
   -6.50000000E-06  -9.36000000E-06  -6.05000000E-06  -7.70000000E-07  -1.08700000E-05
   +4.31700000E-05  -4.62000000E-06  +2.95200000E-05  +2.85300000E-05  +8.37000000E-06
   -1.98500000E-05  +1.41100000E-05  -1.54200000E-05  -5.74000000E-06  +4.70000000E-07
   +5.90000000E-06  +1.70300000E-05  +2.80000000E-06  -9.93000000E-06  -2.29900000E-05
   +6.36100000E-05  +1.23330000E-04  -1.76210000E-04  -1.21493000E-03  -1.68384000E-03
   +1.47947900E-01  +1.79130000E-04  -1.62449000E-03  -2.19110000E-04  +3.27953000E-03
   +1.89259000E-03  +5.20440000E-04  +6.92380000E-03  +8.50911000E-03  -1.02964100E-02
   -5.96567700E-02  -9.91378100E-02  +9.67087400E-02  -1.57065700E-02  -6.06661000E-03
   +2.06233300E-02  +3.21398000E-03  -1.37474000E-03  +2.63658000E-03  +4.53230000E-04
   +7.36960000E-04  +5.99100000E-05  -4.52300000E-05  +6.49000000E-05  +5.07300000E-05
   -1.36154000E-03  +5.12900000E-04  -2.94347000E-03  +2.20950000E-04  -1.52520000E-04
   -1.17040000E-04  -6.83000000E-06  +8.10000000E-07  +2.36300000E-05  +1.30000000E-07
   +1.66000000E-06  -1.62800000E-05  -3.28100000E-05  -4.61700000E-05  -2.68600000E-05
   +2.12000000E-05  +4.25900000E-05  +2.68000000E-06  +9.34000000E-06  +1.90300000E-05
   +4.36900000E-05  +5.14200000E-05  +4.95000000E-05  +9.37000000E-06  -6.26600000E-05
   +2.45500000E-05  -3.18300000E-05  +2.04070000E-04  +7.99230000E-04  -6.39800000E-04
   -5.31000000E-06  -8.94000000E-06  -1.60000000E-07  -3.26000000E-06  -7.70000000E-07
   +5.38000000E-06  -3.76000000E-06  +7.02000000E-06  +3.58000000E-06  +3.13000000E-06
   -8.37000000E-06  -2.89000000E-06  +6.85000000E-06  +6.94000000E-06  -2.76000000E-06
   +1.30200000E-05  -9.85000000E-06  +2.00900000E-05  +1.39900000E-05  -1.61000000E-05
   -2.38000000E-06  -7.77000000E-06  +2.01000000E-05  +3.15000000E-05  -6.59000000E-06
   +2.34000000E-06  -9.40000000E-07  -1.53700000E-05  -5.00000000E-08  -8.75000000E-06
   +8.58000000E-06  -4.98000000E-06  +3.76000000E-06  -1.55863000E-03  -8.46790000E-04
   -1.91910000E-03  +6.40628600E-02  +9.75386600E-02  -1.65113000E-03  -4.23920000E-04
   -9.86800000E-05  +1.29234000E-03  +1.29356000E-03  +2.90427000E-03  +4.53460000E-04
   +2.72603000E-03  -8.77370000E-04  +1.24133430E-01  +9.61439800E-02  -1.91613860E-01
   +1.15491400E-02  +5.92065000E-03  -5.84350000E-03  +8.76750000E-04  +3.22285000E-03
   +6.18720000E-04  +1.79280000E-04  +6.06320000E-04  +4.29830000E-04  -6.34700000E-05
   +9.35700000E-05  +3.11500000E-05  -1.17625000E-03  -2.32723000E-03  -1.18335000E-03
   +2.14120000E-04  -1.22710000E-04  -9.96200000E-05  +1.94000000E-06  +1.56000000E-06
   +7.17000000E-06  +6.37000000E-06  -3.48000000E-06  -2.13000000E-05  -4.75200000E-05
   -5.86400000E-05  -2.97200000E-05  +2.02900000E-05  +3.93400000E-05  +1.14800000E-05
   +6.53000000E-06  +8.42000000E-06  +5.44800000E-05  +6.68500000E-05  +6.19700000E-05
   +1.50200000E-05  +1.32600000E-05  -8.63000000E-06  -6.97200000E-05  +4.15390000E-04
   +4.25490000E-04  -3.79180000E-04  -8.55000000E-06  -1.07300000E-05  -4.13000000E-06
   -1.06000000E-06  +2.54000000E-06  +5.30000000E-06  -1.02300000E-05  +1.56000000E-06
   -7.22000000E-06  -6.00000000E-07  -3.70000000E-06  -2.44000000E-06  +4.76000000E-06
   +8.27000000E-06  -3.68000000E-06  +2.50500000E-05  -3.19000000E-06  +1.65100000E-05
   +2.57000000E-05  +1.17600000E-05  +9.64000000E-06  -2.70800000E-05  +1.59800000E-05
   +1.46300000E-05  -1.25600000E-05  +4.39000000E-06  +4.60000000E-07  -1.18300000E-05
   +1.57000000E-06  -2.67000000E-06  +4.19000000E-06  +5.34000000E-06  +1.96700000E-05
   -1.36641000E-03  -2.15079000E-03  -1.60233000E-03  -1.35025680E-01  -1.05094420E-01
   +1.97913600E-01  -4.37373000E-03  +2.03759600E-02  -6.76081000E-03  -3.43269000E-03
   +9.35410000E-04  +1.92970000E-03  -1.20959000E-03  -5.15270000E-04  +9.55830000E-04
   +2.11415000E-03  -1.75869000E-03  +1.44416000E-03  +4.51303000E-03  -4.45658000E-03
   +2.57931000E-03  -3.07497100E-02  -4.62318000E-03  +8.24018000E-03  +8.38600000E-05
   +5.83500000E-04  -7.49220000E-04  +1.56600000E-05  -3.97900000E-05  -1.30000000E-04
   -1.35519000E-03  -2.49510000E-04  -2.53190000E-04  +1.22950000E-04  +1.10250000E-04
   +3.04500000E-05  +9.12000000E-06  -4.45600000E-05  +6.30000000E-07  +7.27000000E-06
   -3.74200000E-05  -1.29100000E-05  -4.53500000E-05  -2.61800000E-05  -9.10000000E-06
   -1.99000000E-06  -1.28700000E-05  +1.96400000E-05  -2.50800000E-05  -3.74900000E-05
   +1.19400000E-05  +3.42200000E-05  +1.50800000E-05  +9.62000000E-06  -2.88890000E-04
   +4.02100000E-05  +1.55650000E-04  +8.15100000E-04  -5.18520000E-04  -2.30323000E-03
   -1.57600000E-05  -1.29000000E-06  -8.19000000E-06  -1.06600000E-05  +4.61000000E-06
   -7.98000000E-06  -1.01800000E-05  +2.00700000E-05  -1.17100000E-05  -5.53000000E-06
   +1.41400000E-05  -4.65000000E-06  -5.58000000E-06  +7.60000000E-07  -3.70000000E-06
   -1.93500000E-05  +9.78900000E-05  -7.40000000E-05  +3.85000000E-06  +1.02800000E-05
   +5.58000000E-06  +5.59000000E-06  -1.06800000E-05  -2.03600000E-05  -1.40600000E-05
   +4.02000000E-05  +5.74800000E-05  -2.17000000E-06  -1.17900000E-05  +1.67900000E-05
   -1.78000000E-06  -1.11100000E-05  +3.87100000E-05  +1.02000000E-05  +1.29960000E-04
   +9.56000000E-05  -1.53890000E-04  -1.85260000E-04  +1.46300000E-04  +4.64398500E-02
   +1.30011000E-03  -1.42701100E-02  +1.70839500E-02  +2.91027000E-03  +9.18360000E-04
   -3.31126000E-03  -2.29190000E-04  +4.79640000E-04  +1.54700000E-05  -3.32989000E-03
   +2.31260000E-04  +1.53169000E-03  +1.15718700E-02  -7.51196000E-03  +5.77834000E-03
   -3.97770000E-04  -2.41274700E-02  -1.15489000E-02  -1.26444000E-03  -6.31980000E-04
   +1.06837000E-03  +2.78060000E-04  -9.17000000E-05  +1.67860000E-04  -7.79650000E-04
   +1.40560000E-03  -1.45655000E-03  -1.47680000E-04  -3.91860000E-04  -1.85490000E-04
   +3.66000000E-06  +6.15400000E-05  +1.33600000E-04  +9.01400000E-05  -2.16100000E-05
   -1.24730000E-04  -3.24390000E-04  -3.30390000E-04  -1.13240000E-04  +9.50200000E-05
   +1.84380000E-04  +6.00600000E-05  -4.48400000E-05  +6.05900000E-05  +1.14320000E-04
   +4.05820000E-04  +4.17030000E-04  +6.43400000E-05  +6.43510000E-04  -3.29200000E-05
   -3.71670000E-04  -1.43720000E-03  +3.23527000E-03  -2.70181000E-03  -4.23800000E-05
   -8.46700000E-05  -1.05000000E-05  +1.31500000E-05  +2.12300000E-05  +4.07400000E-05
   -6.38600000E-05  -4.10300000E-05  -1.44170000E-04  -1.46600000E-05  -5.42900000E-05
   +4.66000000E-06  +5.56400000E-05  +9.49000000E-06  -8.26000000E-06  +1.44080000E-04
   -1.97150000E-04  +9.31800000E-05  -4.76100000E-05  +9.55100000E-05  +2.11400000E-05
   -8.52900000E-05  +3.54000000E-06  -2.98600000E-05  -2.34900000E-05  +7.74000000E-05
   -2.95700000E-05  -1.98600000E-05  +3.93700000E-05  +7.26300000E-05  +1.03500000E-04
   -8.51600000E-05  -1.83060000E-04  +1.26240000E-04  +6.46600000E-05  +2.53000000E-04
   +5.40700000E-04  -9.29660000E-04  -2.12030000E-04  +2.26939000E-03  +1.68433900E-02
   -1.64491000E-03  +1.02856600E-02  -4.59171000E-03  -2.34559000E-03  -9.78700000E-04
   +5.71081000E-03  -1.43120000E-04  -1.09637000E-03  +2.37790000E-04  +7.82016000E-03
   -1.56920000E-04  -2.00476000E-03  -7.68694000E-03  +2.19619700E-02  -7.40915000E-03
   +2.12795300E-02  -5.84440100E-02  +1.27527700E-02  +1.27516000E-03  +6.48430000E-04
   -1.16751000E-03  -1.81060000E-04  +7.99000000E-06  -1.25850000E-04  -3.39351000E-03
   -1.22163000E-03  -1.23210000E-04  +1.18810000E-04  +2.54130000E-04  +1.17980000E-04
   -2.15600000E-05  -3.29900000E-05  -2.48500000E-05  -7.44300000E-05  -3.12500000E-05
   +7.98300000E-05  +2.27420000E-04  +2.32150000E-04  +7.62500000E-05  -4.73700000E-05
   -1.15970000E-04  -5.57400000E-05  -4.61000000E-06  -3.80800000E-05  -9.65900000E-05
   -2.84720000E-04  -3.07500000E-04  -5.54500000E-05  -6.10940000E-04  -5.61000000E-05
   +4.08720000E-04  +1.02276000E-03  -1.63360000E-03  -2.56530000E-03  +1.69500000E-05
   +6.32600000E-05  +9.81000000E-06  -2.74500000E-05  -1.56200000E-05  -4.12400000E-05
   +2.60500000E-05  +4.36500000E-05  +6.98800000E-05  +2.52800000E-05  +2.89000000E-05
   -1.10400000E-05  -3.44000000E-05  -9.68000000E-06  +5.51000000E-06  -8.93100000E-05
   +1.79240000E-04  -1.40430000E-04  +2.93700000E-05  -3.32500000E-05  -6.57000000E-06
   +4.96200000E-05  +5.80000000E-07  -4.36100000E-05  +3.48100000E-05  -1.91200000E-05
   +3.53000000E-06  +1.03400000E-05  -3.51900000E-05  -2.16700000E-05  -7.69600000E-05
   +7.07300000E-05  +1.18230000E-04  -4.34800000E-05  +1.63880000E-04  -2.61700000E-05
   -1.06802000E-03  +1.18439000E-03  -3.11360000E-04  -1.88783000E-02  +5.38265100E-02
   -2.07479800E-02  -1.18015000E-03  +4.29350000E-04  -1.49220000E-04  +7.79700000E-05
   -3.51030000E-04  +1.64440000E-04  +6.39150000E-04  +1.50116000E-03  -6.41640000E-04
   -5.14470000E-03  +1.14708000E-03  +3.71346000E-03  -1.35122000E-02  +4.13309300E-02
   -2.39794400E-02  +2.25058000E-03  -1.52261000E-03  -1.08590000E-03  -1.69000000E-04
   -2.58500000E-05  +7.62900000E-05  +5.91500000E-05  +1.23000000E-06  -3.29000000E-06
   -4.43896900E-02  +3.99284200E-02  -5.78854000E-03  +6.75000000E-06  -5.08600000E-05
   -1.49200000E-05  +7.68000000E-06  -1.63600000E-05  +2.95600000E-05  +3.97800000E-05
   -2.12100000E-05  -3.46800000E-05  -1.21110000E-04  -1.02950000E-04  -2.99900000E-05
   +1.84500000E-05  +2.51100000E-05  +2.99500000E-05  -1.03400000E-05  -6.01000000E-06
   +3.15000000E-05  +1.35470000E-04  +1.12240000E-04  +2.93800000E-05  +6.30800000E-05
   +1.10300000E-05  -2.99300000E-05  +6.79030000E-04  +2.03300000E-05  -4.63730000E-04
   -2.90900000E-05  -1.82200000E-05  -1.38400000E-05  -7.00000000E-06  +1.29200000E-05
   +2.76000000E-06  -2.15700000E-05  +1.05500000E-05  -4.06800000E-05  -1.27800000E-05
   +1.55000000E-06  -2.62000000E-06  +4.96000000E-06  +6.82000000E-06  -6.87000000E-06
   +2.31200000E-05  -3.26700000E-05  +8.58000000E-06  -1.85500000E-05  -1.30000000E-07
   -4.82000000E-06  -8.94000000E-06  +9.04000000E-06  +2.69000000E-06  -2.20600000E-05
   +3.15200000E-05  +2.93400000E-05  -1.10600000E-05  +3.66000000E-06  +1.83000000E-05
   +3.24700000E-05  -2.77800000E-05  -2.24600000E-05  -3.81150000E-04  +8.96800000E-05
   +9.76400000E-05  -5.75400000E-05  -2.58030000E-04  -2.16120000E-04  -1.45331000E-03
   +4.92440000E-04  +4.28680000E-04  +6.22197300E-02  -3.35000000E-06  -7.28790000E-04
   +5.53400000E-04  -1.91840000E-04  +2.68680000E-04  -2.85760000E-04  +2.38570000E-04
   +9.25200000E-05  +1.40608000E-03  +2.48459000E-03  +1.64614000E-03  -1.39695000E-03
   +3.18605000E-03  -1.84051700E-02  +1.02558500E-02  -3.61574000E-03  +3.06974000E-03
   -1.35434000E-03  +1.41260000E-04  -1.52820000E-04  +2.71000000E-06  -1.07510000E-04
   +4.73100000E-05  -3.14500000E-05  +8.03637500E-02  -3.73337840E-01  +2.23689030E-01
   -3.04400000E-05  +1.13770000E-04  +3.39100000E-05  -1.12800000E-05  -1.26800000E-05
   -1.15100000E-05  -2.57100000E-05  -2.62000000E-06  +3.76800000E-05  +8.60900000E-05
   +9.34200000E-05  +4.03400000E-05  -1.88000000E-05  -4.64800000E-05  -2.65400000E-05
   -7.48000000E-06  -1.30400000E-05  -3.82100000E-05  -1.12930000E-04  -1.22150000E-04
   -2.75100000E-05  -3.92400000E-05  -1.75200000E-05  +1.91900000E-05  -3.65190000E-04
   -5.01200000E-05  +3.13010000E-04  +6.58000000E-06  +2.65600000E-05  +8.30000000E-06
   -1.44400000E-05  -7.89000000E-06  -1.84600000E-05  +2.25500000E-05  +2.36000000E-05
   +3.95500000E-05  +1.14200000E-05  +8.07000000E-06  -6.99000000E-06  -8.69000000E-06
   -5.67000000E-06  +2.94000000E-06  -2.41800000E-05  +2.30100000E-05  -4.40000000E-07
   +8.04000000E-06  -1.62100000E-05  +4.99000000E-06  +9.86000000E-06  -4.87000000E-06
   -6.67000000E-06  +1.43800000E-05  -7.20000000E-06  -1.11000000E-05  +4.27000000E-06
   -3.01800000E-05  -1.99200000E-05  -3.86500000E-05  +2.93000000E-05  +4.54500000E-05
   +9.63000000E-05  -7.04000000E-05  -1.52550000E-04  -3.11530000E-04  +6.53500000E-05
   -4.52240000E-04  -8.12100000E-05  +5.05900000E-05  +1.96520000E-04  -8.23342300E-02
   +3.87397650E-01  +3.11910000E-04  -8.26620000E-04  -1.00543000E-03  +1.24770000E-04
   +3.47540000E-04  -2.97800000E-04  -7.09600000E-05  +7.80290000E-04  +1.26113000E-03
   +2.81681000E-03  -5.94070000E-04  +1.44765000E-03  +1.94674000E-03  -1.07630400E-02
   +3.78391000E-03  +1.54041000E-03  -2.66245000E-03  +6.51730000E-04  +9.67000000E-06
   +1.27780000E-04  -7.76500000E-05  +7.43400000E-05  -3.38100000E-05  +3.01400000E-05
   -3.42752600E-02  +2.45790940E-01  -1.64722400E-01  +5.88000000E-05  -3.16500000E-05
   -1.73300000E-05  +4.46000000E-06  +7.81000000E-06  +2.76000000E-05  -5.41000000E-06
   -1.25300000E-05  +3.89000000E-06  +8.84000000E-06  +4.70000000E-07  -4.04000000E-06
   +1.16900000E-05  +2.05100000E-05  -7.74000000E-06  -1.11300000E-05  -6.70000000E-06
   +8.09000000E-06  -3.70000000E-06  -6.11000000E-06  -8.29000000E-06  -8.27000000E-06
   +7.05000000E-06  -1.09000000E-06  -1.71520000E-04  +1.41780000E-04  -1.24870000E-04
   -3.56000000E-06  +2.91000000E-06  +5.42000000E-06  -1.03700000E-05  -3.52000000E-06
   -5.17000000E-06  +6.40000000E-07  +1.65100000E-05  -9.73000000E-06  +8.49000000E-06
   -8.25000000E-06  -3.99000000E-06  +3.95000000E-06  +1.90000000E-07  -3.10000000E-07
   -7.00000000E-08  -3.42000000E-06  -6.79000000E-06  -3.22000000E-06  -8.21000000E-06
   +3.10000000E-06  -1.48000000E-06  +3.75000000E-06  -8.74000000E-06  +1.35800000E-05
   +2.04000000E-06  -1.18300000E-05  -5.50000000E-07  -5.64000000E-06  +1.13400000E-05
   +2.24000000E-06  -4.03000000E-06  -4.00300000E-05  -3.03400000E-05  -1.46860000E-04
   -1.15560000E-04  -1.45150000E-04  -4.49820000E-04  -1.84160000E-04  +1.43116000E-03
   +7.83410000E-04  +4.27230000E-04  +2.73225700E-02  -2.32045600E-01  +1.59320840E-01
   +1.43595400E-02  -2.16851000E-02  +6.29072000E-03  -2.42731000E-03  -2.19741000E-03
   +6.46026000E-03  +1.94487000E-03  -5.31800000E-05  -4.76470000E-04  -8.10140000E-04
   +9.59920000E-04  +1.48440000E-04  -2.33896000E-03  -1.59283000E-03  -8.10800000E-05
   -7.84460000E-04  -4.24270000E-03  +4.98674000E-03  -1.24770000E-04  +7.33600000E-05
   -1.52440000E-04  -1.20300000E-05  +1.08100000E-05  -2.31600000E-05  +6.47200000E-05
   +4.46200000E-05  -3.50420000E-04  -1.09400000E-05  +1.74010000E-04  -1.06440000E-04
   +8.68100000E-05  +2.11590000E-04  +5.95500000E-05  -9.18500000E-05  -1.70790000E-04
   +7.07300000E-05  +2.61600000E-05  -4.91300000E-05  -1.05000000E-04  +4.70000000E-07
   -8.78100000E-05  +6.21400000E-05  +3.41800000E-05  +7.09900000E-05  -8.46300000E-05
   -6.80600000E-05  -1.11470000E-04  +1.61000000E-05  -1.41900000E-04  -2.83500000E-05
   +1.81300000E-05  -1.55199120E-01  +2.10189900E-01  -7.66748500E-02  -3.99800000E-05
   +1.79800000E-05  -2.44900000E-05  -2.41200000E-05  +1.51300000E-05  -2.40800000E-05
   +3.31000000E-06  +3.19300000E-05  +3.48000000E-06  +1.18300000E-05  +5.56900000E-05
   -1.03500000E-05  -5.89900000E-05  +2.07500000E-05  -9.82000000E-06  -1.79500000E-05
   +3.35400000E-05  -2.57800000E-05  -1.39900000E-05  -4.89500000E-05  +7.18000000E-06
   +6.40000000E-07  +2.53200000E-05  -5.63000000E-06  +2.24900000E-05  +3.00300000E-05
   -1.82020000E-04  -3.51000000E-06  -1.17700000E-05  +1.59400000E-05  -2.42200000E-05
   +8.99300000E-05  -2.27800000E-05  -2.38980000E-04  -2.78690000E-04  +3.24200000E-05
   +1.47400000E-05  +4.14960000E-04  +1.60190000E-04  -2.33194000E-03  +3.16959000E-03
   +1.88158000E-03  -2.01120000E-04  -2.67900000E-05  +3.35090000E-04  +1.44937660E-01
   +4.34867000E-03  -2.19961700E-02  +1.50960500E-02  -1.63826000E-03  +2.67089000E-03
   -4.74900000E-05  +4.13260000E-04  -1.34060000E-04  +1.28674000E-03  +2.67520000E-04
   +4.30200000E-05  -5.12170000E-04  +1.25357000E-03  -4.70890000E-04  +4.84820000E-04
   +1.30052000E-03  +3.72746000E-03  -5.81870000E-03  +1.64860000E-04  +7.80000000E-07
   -1.05680000E-04  -1.61940000E-04  -1.83200000E-05  -1.85560000E-04  +5.86150000E-04
   -2.18100000E-05  -1.67610000E-04  +1.24360000E-04  -3.76000000E-06  +5.51700000E-05
   +2.06300000E-05  +1.20730000E-04  +1.73600000E-05  -6.08900000E-05  -1.04290000E-04
   +7.82300000E-05  +2.06350000E-04  +1.66490000E-04  +4.46600000E-05  -1.02900000E-05
   -5.31800000E-05  -4.38000000E-05  -4.53500000E-05  +3.61700000E-05  -5.77600000E-05
   -2.40760000E-04  -2.87830000E-04  -4.58900000E-05  -2.31600000E-05  -6.92100000E-05
   -1.00000000E-05  +1.78277260E-01  -3.25488570E-01  +1.44303370E-01  -1.09200000E-05
   +6.02900000E-05  -5.79000000E-06  -3.63000000E-05  -3.84000000E-06  -5.07900000E-05
   +1.76500000E-05  +5.00200000E-05  +3.82300000E-05  +4.89900000E-05  -1.07500000E-05
   -1.87700000E-05  -3.59200000E-05  +8.05000000E-06  +3.17000000E-06  -2.30300000E-05
   +2.91300000E-05  +2.32000000E-06  +4.98000000E-06  -1.52400000E-05  +6.77000000E-06
   +3.09000000E-06  +1.20400000E-05  -3.79000000E-05  +2.40620000E-04  -3.61320000E-04
   +6.77100000E-05  +2.42300000E-05  -5.40100000E-05  +7.69000000E-06  -7.28000000E-05
   +5.61000000E-05  +2.84900000E-05  -1.24820000E-04  -1.69600000E-05  -1.04400000E-05
   -4.82300000E-05  -2.45070000E-04  -1.42720000E-04  +8.33020000E-04  -1.31781000E-03
   +6.34740000E-04  +4.13000000E-06  +1.92220000E-04  -1.24100000E-04  -1.81134980E-01
   +3.43784770E-01  -1.34796400E-02  +3.41463600E-02  -2.13123700E-02  +4.54008000E-03
   +7.91320000E-04  -8.09290000E-04  -1.74350000E-04  +1.51569000E-03  +1.15800000E-04
   -7.77600000E-05  -1.36880000E-04  +2.72820000E-04  -5.38080000E-04  -6.84500000E-05
   -1.22796000E-03  -1.77912000E-03  -1.98205000E-03  +2.09644000E-03  +1.00100000E-05
   -1.07340000E-04  -3.06360000E-04  +1.75250000E-04  -3.54310000E-04  -2.78070000E-04
   -6.16740000E-04  -2.88000000E-06  +2.65720000E-04  -1.22650000E-04  -7.83100000E-05
   -8.35000000E-06  +5.81300000E-05  +7.48000000E-06  -2.76900000E-05  +9.40000000E-05
   -8.99700000E-05  -4.98500000E-05  -2.08130000E-04  -1.18840000E-04  +6.81600000E-05
   -2.93200000E-05  +1.97200000E-05  -1.44000000E-05  -1.80400000E-05  +3.30300000E-05
   +2.66100000E-05  +1.70580000E-04  +1.42630000E-04  +8.56000000E-06  +3.86000000E-06
   -1.62000000E-05  -5.68300000E-05  -4.96330300E-02  +1.20538290E-01  -7.76708100E-02
   -4.01000000E-05  -2.14800000E-05  -1.18100000E-05  -1.89500000E-05  +2.13900000E-05
   -1.71000000E-05  -1.22500000E-05  +4.70800000E-05  -5.29800000E-05  -1.15000000E-05
   -4.75700000E-05  +3.33000000E-06  +3.92000000E-05  -4.12000000E-06  -2.54000000E-06
   +1.12100000E-05  -1.34200000E-05  -9.20000000E-07  -4.69000000E-06  -2.12200000E-05
   +1.05200000E-05  -9.00000000E-06  +1.36400000E-05  -9.70000000E-07  +4.82400000E-05
   +5.04100000E-05  +4.60150000E-04  +1.25000000E-05  -1.13800000E-04  +7.04100000E-05
   +3.24900000E-05  -1.50860000E-04  +5.73100000E-05  +1.57570000E-04  -2.59000000E-06
   -3.15880000E-04  +5.67800000E-05  +2.98900000E-05  +9.97200000E-05  +2.59832000E-03
   +1.47961000E-03  -1.50568000E-03  +1.73380000E-04  -5.83800000E-05  +7.09500000E-05
   +5.92269100E-02  -1.54090340E-01  +1.01911650E-01  -3.69484000E-03  -5.83376000E-03
   +4.91337000E-03  +1.35728000E-03  +1.23563000E-03  -1.30816000E-03  -7.10900000E-04
   +1.79560000E-04  +1.15730000E-04  +2.65100000E-05  +3.51120000E-04  +4.42150000E-04
   -3.08272000E-03  -2.62070000E-04  +7.82530000E-04  +7.19650000E-04  +1.76136900E-02
   -1.10508500E-02  +2.75370000E-04  -1.47660000E-04  +2.41620000E-04  -5.75100000E-05
   -5.88700000E-05  +1.47160000E-04  +2.87579000E-03  -1.48267000E-03  -1.30860000E-04
   +6.86000000E-06  -5.33000000E-06  -2.73200000E-05  -2.75500000E-05  +9.64400000E-05
   +5.78200000E-05  -8.68600000E-05  +2.67000000E-06  +5.98100000E-05  +2.46010000E-04
   +1.83050000E-04  +4.53300000E-05  +1.33900000E-05  +1.72700000E-05  -7.96300000E-05
   -4.44000000E-06  +3.33200000E-05  -7.97400000E-05  -2.49180000E-04  -2.11020000E-04
   -6.95200000E-05  +1.86000000E-06  -4.17100000E-05  -5.95000000E-06  -3.30610000E-03
   +6.93323000E-03  -5.17757000E-03  +4.54100000E-05  +3.55300000E-05  +3.33100000E-05
   -4.35000000E-06  -2.82200000E-05  -1.30000000E-05  +2.40000000E-05  +1.65000000E-06
   +3.01800000E-05  +4.89800000E-05  -3.51100000E-05  -1.55000000E-06  +3.34000000E-06
   -1.41100000E-05  +1.29200000E-05  -2.11400000E-05  -1.14000000E-06  +4.51000000E-06
   +2.08300000E-05  +3.00000000E-06  +3.02000000E-06  +4.85000000E-06  +2.91000000E-06
   -2.31900000E-05  +5.29600000E-05  -1.01630000E-04  -1.54850000E-04  +1.62000000E-05
   +4.19300000E-05  -3.60200000E-05  -4.51100000E-05  +7.08600000E-05  -3.05100000E-05
   +2.65200000E-05  -4.92200000E-05  -1.52040000E-04  +1.49460000E-04  -2.82000000E-05
   -1.35400000E-05  -8.37570000E-03  -1.07786900E-02  +3.77020000E-04  +2.24600000E-05
   +6.50510000E-04  -1.90149000E-03  +5.25562000E-03  -2.91677000E-03  +1.19257000E-03
   +1.51288440E-01  +2.17026000E-03  +1.37602000E-03  -7.91961000E-03  +1.02457000E-03
   +8.63870000E-04  +1.90807000E-03  +4.71790000E-04  -2.06920000E-04  -1.09126000E-03
   -4.34810000E-04  +1.91621000E-03  +1.52307000E-03  -4.04460000E-03  -4.04510000E-03
   -1.92214000E-03  +1.56954900E-02  -5.33244100E-02  +4.29503200E-02  +3.65240000E-04
   +2.21490000E-04  +4.19000000E-06  -7.05600000E-05  +8.18400000E-05  -7.46400000E-05
   +7.48300000E-05  -6.57380000E-04  -3.88450000E-04  +6.43000000E-06  +6.43100000E-05
   +8.17000000E-05  +5.84000000E-06  -5.71100000E-05  -9.78500000E-05  +1.58200000E-05
   +3.39300000E-05  +2.06700000E-05  -7.58000000E-06  +1.65000000E-05  +1.95200000E-05
   -3.88300000E-05  -4.70700000E-05  +1.01400000E-05  +2.70500000E-05  -2.72600000E-05
   -6.23000000E-06  -1.66400000E-05  -1.08400000E-05  +8.00000000E-06  -8.36300000E-05
   +5.20000000E-06  +3.57500000E-05  +1.69998000E-03  -4.08575000E-03  +3.63346000E-03
   +7.59000000E-06  +2.42000000E-06  -3.35000000E-06  +6.35000000E-06  +1.69000000E-06
   +2.13000000E-06  +2.03200000E-05  +9.71000000E-06  +4.03700000E-05  -2.16000000E-05
   +2.58200000E-05  +5.06000000E-06  -1.13100000E-05  -1.87000000E-06  -9.70000000E-07
   -5.11800000E-05  -5.37000000E-06  -1.48400000E-05  +1.06700000E-05  -6.17300000E-05
   -4.31000000E-06  +2.97000000E-05  +1.28200000E-05  +3.30800000E-05  -4.05400000E-05
   +5.20000000E-06  +6.27300000E-05  -1.67000000E-06  -1.65500000E-05  -2.67900000E-05
   -9.34000000E-06  -1.16800000E-05  +7.33700000E-05  -1.49330000E-04  -2.40090000E-04
   -2.26760000E-04  +1.86040000E-04  +3.70010000E-04  +6.53790000E-04  -1.83545200E-02
   +2.48141600E-02  -3.63249900E-02  -3.41340000E-04  -2.82480000E-04  -3.82120000E-04
   -4.52872000E-03  -8.87290000E-04  -1.81292000E-03  +1.65795270E-01  +2.47835710E-01
   +4.07589000E-03  -4.41434000E-03  +6.20640000E-04  +1.10207000E-03  +2.02440000E-04
   -1.00248000E-03  +4.80970000E-04  +3.50950000E-04  -5.43100000E-04  -2.47001000E-03
   +9.57320000E-04  +3.12430000E-04  +1.13612000E-03  -4.91807000E-03  +2.37445000E-03
   -2.30467700E-02  +8.26054700E-02  -4.99083000E-02  -2.80540000E-04  -2.40380000E-04
   +2.86260000E-04  -1.02200000E-05  +5.60700000E-05  +5.07000000E-06  +9.06490000E-04
   +2.47260000E-04  -4.81500000E-04  -6.70300000E-05  -1.91500000E-05  +2.63100000E-05
   +5.67000000E-06  -1.28500000E-05  -3.17800000E-05  +9.56000000E-06  +3.25400000E-05
   +4.05000000E-06  -1.53900000E-05  -1.64600000E-05  -7.83000000E-06  -1.13600000E-05
   -1.35100000E-05  +9.97000000E-06  +2.66600000E-05  -2.72000000E-06  -4.43000000E-06
   +1.61600000E-05  +2.93600000E-05  +1.37700000E-05  +1.18040000E-04  +1.71400000E-05
   -8.37200000E-05  -1.38881000E-03  -4.81410000E-04  +3.79590000E-03  +7.56000000E-06
   -9.26000000E-06  -2.99000000E-06  +1.34400000E-05  +2.28000000E-06  +1.31500000E-05
   +6.36000000E-06  -1.08500000E-05  +1.37100000E-05  -1.43000000E-05  +1.40800000E-05
   +5.09000000E-06  -6.77000000E-06  +1.33000000E-06  -1.52000000E-06  -1.10300000E-05
   -3.88000000E-05  +3.98500000E-05  -2.36000000E-06  -1.79900000E-05  -6.83000000E-06
   +5.55000000E-06  +2.01000000E-06  +3.32300000E-05  -2.16200000E-05  -4.84000000E-06
   -7.15000000E-06  +3.07000000E-06  +1.59000000E-06  -1.50700000E-05  +3.75000000E-06
   -3.33000000E-06  +4.45000000E-06  -3.08000000E-06  -6.95200000E-05  -3.41000000E-05
   +4.10610000E-04  -5.54500000E-05  +4.94900000E-05  +1.67438200E-02  -4.78346700E-02
   +2.65310000E-02  +1.05650000E-04  -4.94390000E-04  +4.92590000E-04  -1.01327000E-03
   -9.43280000E-04  -2.72899000E-03  +1.67991800E-01  +1.66641220E-01  +2.19623430E-01
   +1.09190000E-04  +1.17050000E-04  -4.46480000E-04  -3.13300000E-05  -8.79200000E-05
   -8.64100000E-05  +1.86540000E-04  -9.34500000E-05  +1.38100000E-05  -5.88240000E-04
   -3.09200000E-05  +1.82800000E-04  +2.58843000E-03  -8.78760000E-04  -1.85340000E-04
   -1.65127000E-03  +2.74283000E-03  -1.41584000E-03  -2.00260000E-04  -4.05000000E-05
   +7.28500000E-05  +5.85100000E-05  +4.00100000E-05  -3.17600000E-05  -1.38310000E-03
   +4.83220000E-04  -5.58400000E-05  -1.47300000E-05  -5.95400000E-05  -8.79000000E-06
   +6.42000000E-06  -2.49200000E-05  +1.23000000E-06  +4.48200000E-05  +1.19900000E-05
   -3.83000000E-05  -1.33030000E-04  -1.22040000E-04  -3.98000000E-05  +1.12800000E-05
   +2.61300000E-05  +4.28900000E-05  +3.45000000E-06  -9.91000000E-06  +3.46900000E-05
   +1.52450000E-04  +1.47660000E-04  +3.80300000E-05  +9.22300000E-05  +1.79300000E-05
   -2.98200000E-05  +1.30150000E-04  +3.77540000E-04  +1.40828000E-03  -1.87900000E-05
   -2.82700000E-05  -1.24500000E-05  +7.37000000E-06  +1.20700000E-05  +1.66400000E-05
   -1.93800000E-05  -1.19400000E-05  -2.92800000E-05  -2.64300000E-05  +8.67000000E-06
   +3.86000000E-06  +4.33000000E-06  +6.29000000E-06  -6.88000000E-06  +2.72800000E-05
   -2.94400000E-05  +4.32000000E-06  -1.16500000E-05  +1.46300000E-05  -1.20000000E-06
   -1.35100000E-05  -1.63000000E-06  +1.02900000E-05  -5.55000000E-05  +3.10500000E-05
   +3.51000000E-05  -9.86000000E-06  +1.35100000E-05  +1.41600000E-05  +3.96700000E-05
   -4.09900000E-05  -2.10000000E-06  -5.12000000E-06  +4.31000000E-06  +5.65800000E-05
   +6.39300000E-05  -1.35560000E-04  +3.67100000E-05  -2.92700000E-04  -5.18231000E-03
   +2.03314000E-03  +4.71490000E-04  +4.49800000E-05  +6.16290000E-04  -1.79870000E-03
   -1.55542000E-03  -1.82773000E-03  -1.42815390E-01  -1.59407050E-01  -1.64806680E-01
   +1.45071440E-01  -7.69040000E-04  +3.50700000E-04  +2.74318000E-03  -5.59490000E-04
   -5.49590000E-04  -7.26180000E-04  -1.25930000E-04  +2.43000000E-06  +4.69680000E-04
   +2.13740000E-04  -9.10310000E-04  -6.60750000E-04  +1.91103000E-03  +1.74265000E-03
   +5.00300000E-04  +8.35150000E-04  +9.57260000E-04  -7.48790000E-04  -1.75710000E-04
   -8.59300000E-05  +3.47100000E-05  +3.42700000E-05  -1.95500000E-05  +1.63900000E-05
   -4.40540000E-04  +4.34470000E-04  +2.65810000E-04  -3.21000000E-06  -1.73500000E-05
   -3.43800000E-05  -1.56100000E-05  +9.40000000E-06  +2.11900000E-05  -3.76000000E-06
   -2.66000000E-06  -1.25300000E-05  +3.29000000E-06  -3.78000000E-06  -8.73000000E-06
   +1.29700000E-05  +1.08300000E-05  -3.40000000E-06  -1.11200000E-05  +9.96000000E-06
   +1.36700000E-05  +4.40000000E-06  +7.72000000E-06  -1.59000000E-06  +4.67300000E-05
   +3.88000000E-06  -3.15800000E-05  +6.28080000E-04  +4.80070000E-04  -9.16610000E-04
   +2.80000000E-06  -2.93000000E-06  +1.71000000E-06  +2.69000000E-06  -2.23000000E-06
   +4.21000000E-06  -8.84000000E-06  -1.01600000E-05  -1.15900000E-05  +8.72000000E-06
   -4.05000000E-06  -3.13000000E-06  +2.98000000E-06  +1.40000000E-06  +7.90000000E-07
   +2.19700000E-05  -2.11000000E-06  +1.19000000E-05  -5.23000000E-06  +2.02600000E-05
   +4.89000000E-06  -1.21200000E-05  -6.35000000E-06  -1.48800000E-05  +3.39000000E-05
   +2.41700000E-05  -1.08200000E-05  -6.80000000E-07  -2.50000000E-05  +2.42100000E-05
   -7.12000000E-06  -1.15000000E-06  -3.44200000E-05  +6.48000000E-05  +1.15910000E-04
   +1.24650000E-04  -1.22270000E-04  -1.91330000E-04  -2.34530000E-04  +5.49518000E-03
   +1.10677000E-03  +1.07682300E-02  -5.99200000E-05  +1.66210000E-04  +8.55800000E-05
   +6.08610000E-04  +6.02240000E-04  +4.55380000E-04  -1.71251480E-01  -2.13688000E-01
   -1.91559780E-01  +1.63640730E-01  +2.09476140E-01  -1.07369000E-03  -2.08320000E-03
   +1.42716000E-03  +7.72480000E-04  +4.63300000E-04  -3.91970000E-04  -1.16100000E-05
   -1.34040000E-04  -3.81000000E-05  -5.42340000E-04  +2.93960000E-04  +6.44860000E-04
   +2.63500000E-04  -1.61392000E-03  -3.03280000E-04  -1.38022000E-03  +6.09853000E-03
   -3.16294000E-03  -2.49920000E-04  -8.61000000E-06  +2.71700000E-04  +9.99200000E-05
   -4.87400000E-05  +4.69400000E-05  +3.67220000E-04  -2.73660000E-04  +2.04670000E-04
   -7.60000000E-07  -1.31640000E-04  -6.56100000E-05  +5.67000000E-06  +9.94000000E-06
   +3.65500000E-05  +3.51400000E-05  -1.55400000E-05  -4.71900000E-05  -1.21520000E-04
   -1.15540000E-04  -3.69300000E-05  +3.12200000E-05  +6.05100000E-05  +2.26000000E-05
   -2.06500000E-05  +1.96900000E-05  +5.60200000E-05  +1.47320000E-04  +1.44530000E-04
   +2.19400000E-05  +1.63950000E-04  -1.80300000E-05  -9.65800000E-05  +5.89190000E-04
   -1.74500000E-04  -9.67650000E-04  -1.83800000E-05  -2.74400000E-05  -4.94000000E-06
   +1.93000000E-06  +7.85000000E-06  +1.11500000E-05  -2.26000000E-05  -8.58000000E-06
   -5.22000000E-05  -4.81000000E-06  -1.97300000E-05  +7.60000000E-07  +2.07200000E-05
   +4.99000000E-06  -2.61000000E-06  +4.57400000E-05  -5.83200000E-05  +1.51700000E-05
   -1.35100000E-05  +2.47200000E-05  +1.11400000E-05  -2.82700000E-05  +6.29000000E-06
   -1.68000000E-05  -3.47000000E-06  +4.33900000E-05  +2.10400000E-05  -1.23000000E-05
   +6.29000000E-06  +3.32800000E-05  +3.97900000E-05  -3.65300000E-05  -5.45200000E-05
   -1.91300000E-05  -6.97700000E-05  -1.55300000E-05  +1.53300000E-04  -1.30200000E-04
   +1.33170000E-04  -7.28352000E-03  -1.43271100E-02  -5.47344000E-03  +2.64520000E-04
   -2.09970000E-04  -8.92660000E-04  -4.02910000E-04  +2.63260000E-04  +8.60700000E-04
   -1.56195060E-01  -1.67409410E-01  -1.99395030E-01  +1.64403030E-01  +1.79467220E-01
   +2.07199160E-01
end_hess

