# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -1036.19491700   # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -4.47910685E+00  +8.11670615E-01  +2.05529382E+00
   006   -2.99482379E+00  +1.89003516E+00  +1.72517944E-01
   006   -3.58679715E+00  +1.26888701E+00  -2.31474929E+00
   006   -5.56285435E+00  -3.46839675E-01  -2.90831229E+00
   006   -7.02344671E+00  -1.39257435E+00  -9.88533680E-01
   006   -6.45997002E+00  -8.11021337E-01  +1.50396962E+00
   006   -7.75957235E-01  +3.67383792E+00  +7.03129277E-01
   006   -1.21981158E+00  +6.11248570E+00  -8.21780921E-01
   008   -8.98998457E+00  -2.97814321E+00  -1.44331250E+00
   006   +1.71797399E+00  +2.36034909E+00  -2.94768079E-02
   006   +2.34649206E+00  -9.53139531E-02  +9.91852464E-01
   006   +4.91553120E+00  -1.16561754E+00  +7.07260580E-01
   006   +6.45480062E+00  +1.27045943E-01  -1.23399389E+00
   006   +5.66110269E+00  +2.23112994E+00  -2.39769296E+00
   006   +3.28256517E+00  +3.38290922E+00  -1.79430392E+00
   008   +1.31240301E+00  -7.64283505E-01  +3.44323497E+00
   008   +4.93586337E+00  -3.98763263E+00  +8.66721189E-02
   008   +8.83874823E+00  -8.02554777E-01  -1.58913019E+00
   006   -6.79784442E-01  +4.53536858E+00  +3.47997949E+00
   001   -9.22339472E+00  -3.16983902E+00  -3.22624962E+00
   001   -5.96957060E+00  -7.86107289E-01  -4.86789425E+00
   001   -2.44170826E+00  +2.00835136E+00  -3.83917373E+00
   001   -4.09069708E+00  +1.21650081E+00  +4.01740251E+00
   001   -7.59260568E+00  -1.62844324E+00  +2.99563896E+00
   001   -3.02927640E+00  +6.92768378E+00  -2.67711065E-01
   001   +2.53443370E-01  +7.49733109E+00  -4.29703683E-01
   001   -1.27133556E+00  +5.79477552E+00  -2.85221138E+00
   001   -5.50694493E-01  +2.97999369E+00  +4.81037739E+00
   001   +9.62970603E-01  +5.74985434E+00  +3.74649985E+00
   001   -2.36336600E+00  +5.63029410E+00  +3.95173237E+00
   001   +2.76926865E+00  +5.06574586E+00  -2.82008671E+00
   001   +6.90287264E+00  +3.12232923E+00  -3.75764157E+00
   001   +5.96107618E+00  -1.27770658E+00  +2.51064085E+00
   001   +4.26526438E-01  -2.08671941E+00  -7.77474425E-01
   001   +8.83119526E+00  -2.54047084E+00  -1.07465803E+00
   001   +2.25427867E+00  +8.11625044E-02  +4.74621040E+00
   001   +4.28233325E+00  -4.11374984E+00  -1.60766890E+00
   008   -5.94046176E-01  -3.71167984E+00  -1.28491022E+00
   001   -2.31366697E+00  -3.18490454E+00  -1.56278540E+00
   001   -6.82213759E-02  -4.96073260E+00  +8.33885366E-01
   008   +9.67328641E-01  -5.51946768E+00  +2.57600226E+00
   001   +9.32258930E-01  -3.84471309E+00  +3.46093591E+00
   001   +2.71580492E+00  -5.44112927E+00  +1.85448876E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   -1.00000000E-08  -1.40000000E-07  -3.30000000E-07
   -1.80000000E-07  +7.50000000E-07  -1.50000000E-07
   +2.50000000E-07  +9.60000000E-07  -1.30000000E-07
   +2.10000000E-07  +9.50000000E-07  -7.00000000E-07
   -1.80000000E-07  +8.90000000E-07  -9.10000000E-07
   -2.60000000E-07  +5.60000000E-07  -7.00000000E-07
   +5.50000000E-07  -1.30000000E-07  +6.10000000E-07
   +8.70000000E-07  +2.60000000E-07  +6.80000000E-07
   -2.40000000E-07  +1.17000000E-06  -1.40000000E-06
   -3.00000000E-08  -4.70000000E-07  +2.70000000E-07
   +4.20000000E-07  -1.80000000E-07  +5.00000000E-08
   -8.10000000E-07  -7.20000000E-07  +2.40000000E-07
   +1.10000000E-07  -3.30000000E-07  +8.70000000E-07
   +4.50000000E-07  -1.70000000E-07  +8.50000000E-07
   +3.30000000E-07  -2.60000000E-07  +6.50000000E-07
   -8.70000000E-07  -1.60000000E-07  -1.40000000E-07
   -7.60000000E-07  -3.20000000E-07  +5.50000000E-07
   +0.00000000E+00  -7.30000000E-07  +5.50000000E-07
   -8.00000000E-08  -3.40000000E-07  +5.50000000E-07
   -1.00000000E-08  +1.38000000E-06  -1.38000000E-06
   +4.00000000E-07  +1.27000000E-06  -7.50000000E-07
   +5.80000000E-07  +7.60000000E-07  -1.00000000E-08
   -3.50000000E-07  -1.00000000E-07  -2.90000000E-07
   -5.10000000E-07  +3.70000000E-07  -1.04000000E-06
   +6.70000000E-07  +3.10000000E-07  +5.80000000E-07
   +7.10000000E-07  +5.00000000E-08  +1.12000000E-06
   +9.30000000E-07  +5.70000000E-07  +6.20000000E-07
   -7.00000000E-08  -6.30000000E-07  +3.00000000E-07
   +8.00000000E-08  -5.40000000E-07  +8.40000000E-07
   +1.10000000E-07  -4.50000000E-07  +5.60000000E-07
   +8.20000000E-07  +2.30000000E-07  +1.03000000E-06
   +6.40000000E-07  -1.90000000E-07  +1.01000000E-06
   -3.00000000E-07  -7.50000000E-07  +3.10000000E-07
   +8.00000000E-08  -2.60000000E-07  -3.70000000E-07
   -1.60000000E-07  -7.00000000E-07  +4.30000000E-07
   -5.20000000E-07  -1.18000000E-06  +2.60000000E-07
   -8.00000000E-08  -3.60000000E-07  -8.00000000E-08
   +9.00000000E-08  -4.00000000E-08  +3.00000000E-07
   -1.30000000E-07  +7.40000000E-07  -6.30000000E-07
   +3.30000000E-07  -9.40000000E-07  -1.89000000E-06
   -7.70000000E-07  -7.00000000E-07  -6.40000000E-07
   -2.10000000E-07  +8.60000000E-07  +7.50000000E-07
   -2.12000000E-06  -1.30000000E-06  -2.43000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +4.77687660E-01  +2.65269390E-01  +3.59163340E-01  +4.53875000E-03  +3.64683300E-02
   +7.41919640E-01  -1.67901090E-01  -7.44666100E-02  +1.06006350E-01  +4.57954420E-01
   -7.65325200E-02  -1.24799710E-01  +7.47885900E-02  +2.15099410E-01  +3.61218180E-01
   +5.11492500E-02  +3.10522400E-02  -2.31377700E-01  -2.94869000E-02  +5.90306000E-03
   +6.65036330E-01  +3.99382900E-02  +2.59198900E-02  +4.56457000E-03  -1.15475830E-01
   -3.56164700E-02  -9.33509000E-03  +5.07716360E-01  +2.93735400E-02  +3.16169900E-02
   -8.93650000E-04  -4.04677500E-02  -1.03179690E-01  -2.08707000E-02  +2.75839840E-01
   +3.67831520E-01  +4.49391600E-02  +3.26570200E-02  -5.59205700E-02  -6.31269000E-02
   -6.36469300E-02  -2.98351580E-01  -4.57193100E-02  +4.37405000E-03  +7.00376880E-01
   -4.27298600E-02  -3.08817200E-02  +1.74539400E-02  +4.31122000E-03  -6.76660000E-03
   -6.89297700E-02  -2.28893650E-01  -1.34776490E-01  -9.33720000E-03  +4.78832980E-01
   -3.20569500E-02  -2.88219900E-02  +1.32689000E-02  -3.34418000E-03  +1.59486000E-03
   -5.81375200E-02  -1.38026760E-01  -1.67927500E-01  -9.67784000E-03  +2.76909590E-01
   +3.48045350E-01  +1.55552600E-02  +1.23384500E-02  -9.18645000E-03  -2.89562100E-02
   -2.25787200E-02  +1.15874700E-02  -6.17276100E-02  -5.41962600E-02  -1.39936970E-01
   +4.02610000E-03  +3.75184800E-02  +7.31900310E-01  +4.32858000E-03  +6.59010000E-04
   -3.28557700E-02  -2.66250000E-03  +4.00485000E-03  +1.68892100E-02  -3.05649900E-02
   -2.57710400E-02  +7.92471000E-03  -1.56353760E-01  -6.61129300E-02  +1.07655090E-01
   +4.97642040E-01  -3.47991000E-03  -2.47823000E-03  -2.44905800E-02  +3.61587000E-03
   -2.76200000E-03  +7.95138000E-03  -2.34944800E-02  -1.47517600E-02  +9.91395000E-03
   -6.76256600E-02  -1.18296140E-01  +7.57165200E-02  +2.65108190E-01  +3.72881450E-01
   -7.85275600E-02  -6.28353400E-02  +1.77120600E-02  +1.56862400E-02  +7.79270000E-03
   -8.50318600E-02  +5.22904800E-02  +4.74397800E-02  +6.77656500E-02  +4.34012000E-02
   +2.33261000E-02  -2.48702510E-01  -4.78828000E-03  +2.39382500E-02  +7.25567000E-01
   -2.29783210E-01  -1.39155890E-01  -6.01252400E-02  -2.68194300E-02  -2.40803600E-02
   +4.71285900E-02  -2.35063400E-02  -1.85495300E-02  -2.77986100E-02  +3.75469500E-02
   +2.35594100E-02  +3.22678000E-03  -1.10667440E-01  -2.99978100E-02  +5.38543000E-03
   +5.03845690E-01  -1.35791940E-01  -1.71827970E-01  -5.38931300E-02  -2.64954500E-02
   -1.18837200E-02  +4.18483100E-02  -1.84758800E-02  -1.99639500E-02  -2.41886500E-02
   +2.63324900E-02  +2.94333400E-02  -1.81309000E-03  -3.63526300E-02  -9.81151200E-02
   -8.57931000E-03  +2.96184030E-01  +3.64918110E-01  -4.53499000E-03  -8.17864000E-03
   -1.43017540E-01  +7.66448000E-03  +8.84460000E-03  +6.08215900E-02  -2.73374700E-02
   -2.50843700E-02  -3.74883100E-02  +3.99171200E-02  +3.01750300E-02  -4.74969700E-02
   -5.73407200E-02  -5.76967100E-02  -3.19325930E-01  -4.06395500E-02  +8.18430000E-04
   +7.18724150E-01  -1.14651600E-02  -1.12717900E-02  -4.85620000E-04  -1.28760900E-01
   -4.53013000E-02  -9.42838000E-03  -6.53742000E-03  -6.78805000E-03  -9.00771000E-03
   +4.40627000E-03  -8.37090000E-04  +7.55370000E-04  -1.41168000E-03  -5.47900000E-04
   +1.05285000E-03  +3.00922000E-03  -3.12836000E-03  +1.03639000E-03  +4.55473810E-01
   -1.17400900E-02  -5.56173000E-03  +1.70760000E-04  -5.06791800E-02  -1.08131260E-01
   -9.64225000E-03  -7.33277000E-03  -5.09625000E-03  -6.98306000E-03  -1.30562000E-03
   +4.24974000E-03  -2.27030000E-04  -5.89800000E-04  -7.45720000E-04  +2.00750000E-04
   -2.65946000E-03  +4.53624000E-03  +8.32090000E-04  +6.84832000E-03  +4.71470220E-01
   +1.53231400E-02  +1.20239900E-02  +1.07916100E-02  -1.45138300E-02  -1.20018700E-02
   -9.21754700E-02  -2.46348600E-02  -1.94614600E-02  -1.75043000E-03  -3.66600000E-04
   -6.00230000E-04  -5.63089000E-03  -2.02620000E-04  -3.49400000E-05  -1.42878000E-03
   +2.52745000E-03  +1.16318000E-03  -3.27097000E-03  +2.12761000E-03  +4.18090000E-04
   +4.76874050E-01  -1.71505000E-03  -1.72194000E-03  -1.95504000E-03  +8.52390000E-04
   -2.29382300E-02  +1.46367400E-02  -1.60510000E-04  -2.32931000E-03  -6.48750000E-04
   +1.91800000E-04  +2.34950000E-04  +4.99140000E-04  +4.61510000E-04  +2.95270000E-04
   +8.48800000E-04  -1.68368000E-03  +2.80830000E-04  -1.33850000E-04  -7.64797400E-02
   +9.56790000E-03  -7.12442000E-03  +5.84235810E-01  +9.39110000E-04  -8.20820000E-04
   -1.64442000E-03  -6.04499000E-03  -2.76890200E-02  +1.11252200E-02  -1.41600000E-05
   -1.55969000E-03  +1.23120000E-04  +2.98200000E-04  +4.95420000E-04  +7.55460000E-04
   +2.02500000E-05  +1.22320000E-04  +6.92760000E-04  -1.16213000E-03  +2.26330000E-04
   -3.87750000E-04  +1.27798000E-02  -1.39966470E-01  +4.26913300E-02  +2.26824100E-02
   +4.89645290E-01  -8.78100000E-04  -5.72430000E-04  -5.97590000E-04  +4.74516000E-03
   -5.96860000E-04  +3.61872000E-03  -1.60719000E-03  -1.24564000E-03  +1.99390000E-04
   +2.31320000E-04  +8.69500000E-05  -1.71430000E-04  +4.83710000E-04  +4.16600000E-05
   +3.18370000E-04  -3.26410000E-04  +1.29030000E-04  -2.03400000E-04  -7.87484000E-03
   +4.03217000E-02  -1.01387230E-01  -1.22209900E-02  +5.30911700E-02  +5.71491270E-01
   +2.94678000E-03  -1.51262000E-03  +1.85112000E-03  -1.69084000E-03  -8.91350000E-04
   -9.13780000E-04  +3.50733000E-03  -3.16929000E-03  +2.98217000E-03  -2.90416100E-02
   -2.80968300E-02  -6.33607000E-03  -2.05484500E-01  -1.31253940E-01  -3.81905000E-03
   -1.26818900E-02  -1.54517000E-02  -1.41948700E-02  +5.62840000E-04  +9.88780000E-04
   +7.18130000E-04  -9.65460000E-04  -2.91870000E-04  -5.93480000E-04  +2.79424550E-01
   -9.43010000E-04  +4.51431000E-03  +7.92560000E-04  -5.62910000E-04  -2.09498000E-03
   +5.59000000E-05  -3.23361000E-03  +4.55372000E-03  +1.18398000E-03  -2.84652100E-02
   -1.18864000E-02  -4.68951000E-03  -1.29442360E-01  -1.47289730E-01  -3.64974000E-03
   -1.84081800E-02  -6.87364000E-03  -1.28701600E-02  +9.63170000E-04  +1.80400000E-04
   +6.00900000E-04  -7.43140000E-04  -2.40490000E-04  -4.25810000E-04  +2.01812000E-01
   +1.87630240E-01  +7.40064000E-03  +5.30877000E-03  -8.16884000E-03  -1.68193000E-03
   -9.34270000E-04  +7.60531000E-03  -3.05201000E-03  -3.85868000E-03  -9.81277000E-03
   +2.57958300E-02  +2.15903600E-02  +1.12991600E-02  -4.44207400E-02  -3.75783000E-02
   -1.15884940E-01  -4.61354000E-02  -3.71917700E-02  -1.09193700E-02  +4.50000000E-05
   +1.62160000E-04  +5.97200000E-04  -3.97020000E-04  -1.62120000E-04  -2.77780000E-04
   +9.37639500E-02  +7.86266400E-02  +6.48475990E-01  +9.16000000E-06  +5.96560000E-04
   -1.09333000E-03  -3.42132300E-02  +1.72950000E-03  +5.91517000E-03  -4.25360000E-04
   +4.51810000E-04  +8.30400000E-05  +8.40190000E-04  +2.32580000E-04  +5.75900000E-04
   -3.99280000E-04  -3.29650000E-04  +6.77200000E-04  -3.10000000E-05  -1.24084000E-03
   -3.17100000E-04  -1.33437990E-01  +3.71022000E-02  +1.87877200E-02  -6.92723000E-03
   +9.20885000E-03  -1.41189000E-03  +2.95550000E-04  +2.55180000E-04  +4.65100000E-05
   +5.16726910E-01  -1.48805000E-03  -1.81032000E-03  -1.08349000E-03  -1.45906800E-02
   +1.10503600E-02  +6.53608000E-03  -6.24060000E-04  -4.27840000E-04  -1.03958000E-03
   +3.86580000E-04  -1.41078000E-03  +2.30190000E-04  -2.06300000E-04  +9.66000000E-05
   +4.01990000E-04  +7.63800000E-05  -1.59491000E-03  +1.61270000E-04  +2.97399400E-02
   -9.76618200E-02  +3.94443000E-03  +2.64904800E-02  -1.52451500E-02  -7.34034000E-03
   -4.92470000E-04  -5.63390000E-04  -1.97860000E-04  -4.44446900E-02  +4.71759580E-01
   -1.22470000E-04  +6.81570000E-04  -7.55120000E-04  -2.75650000E-04  +3.19263000E-03
   +2.14422000E-03  -2.51598000E-03  -9.27100000E-04  -3.18070000E-04  +2.28850000E-04
   +8.22650000E-04  +3.31300000E-05  +4.63600000E-04  +3.07320000E-04  +5.70060000E-04
   -3.33300000E-04  -2.50790000E-04  -4.11480000E-04  +2.22413800E-02  -5.54077000E-03
   -8.28876100E-02  -1.49206000E-02  +6.52141000E-03  +5.55768000E-03  -6.29830000E-04
   -4.86580000E-04  -2.50270000E-04  -2.01653860E-01  -1.76577200E-01  +4.55339270E-01
   +1.59070000E-04  +5.68480000E-04  -5.61880000E-04  +1.52490000E-04  +1.33919000E-03
   -1.10690000E-04  -1.26639000E-03  +1.21820000E-04  -1.54250000E-04  +3.77580000E-04
   +1.12617000E-03  +3.48730000E-04  +7.94560000E-04  +2.63040000E-04  +4.94180000E-04
   -3.12410000E-04  -2.78500000E-04  -4.34440000E-04  -5.26628000E-03  +2.29437400E-02
   -1.21123000E-02  -4.24211000E-03  +1.44224000E-03  +2.61532000E-03  -7.19860000E-04
   -3.81180000E-04  -1.72650000E-04  -8.74232900E-02  +7.34082900E-02  +1.56940000E-03
   +3.86035350E-01  +2.00730000E-04  +2.77900000E-05  -2.91820000E-04  -5.01250000E-04
   -6.91800000E-04  +7.83600000E-05  -9.23780000E-04  -2.12180000E-04  +3.38660000E-04
   -3.65470000E-04  +1.42949000E-03  +2.53750000E-04  +7.06880000E-04  +5.26630000E-04
   -5.81400000E-05  +5.55000000E-06  +2.36240000E-04  -2.11430000E-04  +6.79515000E-03
   -1.33707800E-02  +3.51600000E-05  +9.38460000E-04  -1.34080000E-04  +3.90900000E-05
   -4.08620000E-04  -1.08410000E-04  -8.63200000E-05  +6.62051200E-02  -1.81092170E-01
   +3.82688800E-02  -1.49239740E-01  +4.04588150E-01  -1.75840000E-04  +2.36910000E-04
   +5.20600000E-04  -1.50565000E-03  -1.45986000E-03  -9.30290000E-04  +3.21040000E-04
   +4.38510000E-04  +1.08429000E-03  -6.21560000E-04  +6.16800000E-05  -1.13410000E-04
   +2.81310000E-04  +3.14310000E-04  -5.26000000E-04  +4.34150000E-04  +9.74580000E-04
   +5.80300000E-05  -1.61244000E-03  -7.48229000E-03  +6.13777000E-03  +3.10589000E-03
   -7.60040000E-04  -1.04444000E-03  +1.19900000E-04  +1.83880000E-04  +3.66000000E-06
   +2.13203000E-03  +9.73092500E-02  -9.90119200E-02  -6.86804800E-02  -1.36923690E-01
   +3.60343960E-01  -1.09460000E-04  -2.00890000E-04  +1.43590000E-04  +9.87100000E-05
   +1.14210000E-04  -3.05800000E-05  +3.63500000E-04  -1.27730000E-04  +2.06530000E-04
   -1.80400000E-05  -3.55010000E-04  -2.04140000E-04  -3.16300000E-04  -1.03550000E-04
   -5.23900000E-05  +6.60500000E-05  +1.17700000E-05  +1.14510000E-04  +1.18492000E-03
   -1.08072000E-03  +4.97920000E-04  +3.98360000E-04  -1.88400000E-04  +1.85080000E-04
   +2.76910000E-04  +1.48370000E-04  +4.70200000E-05  -5.50139000E-03  +1.52403100E-02
   -1.92239000E-02  -1.85673610E-01  +5.23877200E-02  +2.78375000E-02  +5.35661070E-01
   +2.79630000E-04  +2.32230000E-04  -2.03370000E-04  +1.73790000E-04  +2.69480000E-04
   +2.49380000E-04  -1.80920000E-04  +1.83530000E-04  +5.39000000E-06  +1.19000000E-05
   -9.60000000E-05  +2.24230000E-04  +8.92450000E-04  +4.88370000E-04  +4.40860000E-04
   -2.09200000E-04  -3.18910000E-04  -3.72870000E-04  +1.35004000E-03  -2.03718000E-03
   +3.89237000E-03  +5.61470000E-04  -9.97100000E-05  -4.12460000E-04  -1.00912000E-03
   -8.98660000E-04  -3.29500000E-04  +3.24340600E-02  -1.01165300E-02  +2.50777000E-03
   +1.72119300E-02  -1.02229750E-01  -1.37629200E-02  -6.91352000E-03  +2.85110510E-01
   +1.92310000E-04  +6.67000000E-06  -7.06300000E-05  +9.00650000E-04  +3.55530000E-04
   -1.47430000E-04  -8.49000000E-06  +3.37600000E-05  +1.18620000E-04  +1.19120000E-04
   -3.83500000E-05  -8.14500000E-05  -8.01400000E-05  -1.36060000E-04  +1.80700000E-05
   -3.09200000E-05  -5.96700000E-05  +7.50000000E-06  -7.22400000E-05  +3.37442000E-03
   +5.60150000E-04  -6.74130000E-04  +3.45520000E-04  +3.68530000E-04  +8.24700000E-05
   +5.75100000E-05  +1.36400000E-05  -1.25164600E-02  -1.73315400E-02  +1.37808200E-02
   -8.16192000E-03  +2.01512200E-02  -7.87489300E-02  +3.30945000E-03  -7.50239500E-02
   +5.62577950E-01  +2.79600000E-05  +8.34000000E-06  +3.09590000E-04  +1.81500000E-05
   -5.49570000E-04  -4.25580000E-04  +1.98560000E-04  -6.76000000E-06  +2.30300000E-05
   +1.44770000E-04  +8.30000000E-06  -2.58130000E-04  -7.87870000E-04  -6.15130000E-04
   -3.52810000E-04  +2.06300000E-04  +2.07300000E-04  +2.76510000E-04  -1.59663000E-03
   +1.04073000E-03  +7.98370000E-04  +2.07260000E-04  +1.86090000E-04  -2.28970000E-04
   +9.29590000E-04  +7.70180000E-04  +2.93350000E-04  -7.59440000E-04  -1.20721400E-02
   +4.99277000E-03  -1.03611700E-02  +5.37997000E-03  +2.51244600E-02  -1.24708080E-01
   -3.68336600E-02  +5.57141200E-02  +5.53167030E-01  +4.86100000E-05  -9.47900000E-05
   -1.30800000E-05  -4.36690000E-04  +6.34910000E-04  +2.76960000E-04  -1.96300000E-05
   -1.41060000E-04  -1.35970000E-04  +7.60600000E-05  +2.88900000E-05  -2.05500000E-05
   -3.72200000E-05  +4.07800000E-05  +1.36150000E-04  -8.26500000E-05  -1.57900000E-04
   -8.47200000E-05  -5.65350000E-04  -1.17202000E-03  +8.88300000E-05  +2.97400000E-05
   -1.96120000E-04  +7.93100000E-05  -3.98300000E-05  -3.48100000E-05  -1.90800000E-05
   -1.18819200E-02  -1.02924800E-02  +1.26852600E-02  +4.60376000E-03  +2.18625600E-02
   -6.75200000E-03  -2.49061900E-02  -9.28657200E-02  +4.58871100E-02  -1.82889320E-01
   +6.52581690E-01  -1.25800000E-05  +4.48700000E-05  -1.11000000E-05  +2.60920000E-04
   -2.77210000E-04  -1.62090000E-04  -1.12800000E-05  +9.19800000E-05  +6.51800000E-05
   -1.11180000E-04  +6.61500000E-05  +6.56800000E-05  +1.87240000E-04  +9.69300000E-05
   -7.27100000E-05  +2.52800000E-05  +1.19340000E-04  +2.35000000E-06  +1.52030000E-04
   +7.63090000E-04  +2.96640000E-04  +1.45100000E-05  +1.35230000E-04  -1.55700000E-05
   -1.24490000E-04  -7.15100000E-05  -2.32900000E-05  +8.58218000E-03  +3.66737000E-03
   -2.86359000E-03  -2.56421000E-03  -1.33181000E-02  -8.18722000E-03  +4.80968500E-02
   +4.48601200E-02  -1.57126700E-01  -6.80870800E-02  -2.75083390E-01  +4.01355750E-01
   +3.50700000E-05  -3.22900000E-05  +2.37430000E-04  +1.52100000E-04  +3.27740000E-04
   -1.18080000E-04  +7.15800000E-05  -3.20100000E-05  -8.85800000E-05  +1.37190000E-04
   -7.66800000E-05  -1.76790000E-04  -2.91640000E-04  -2.38580000E-04  -6.83300000E-05
   +8.37700000E-05  -3.42000000E-06  +3.32700000E-05  +1.92590000E-03  +1.79700000E-04
   +4.10190000E-03  +1.86860000E-04  -5.45270000E-04  -1.12400000E-05  +2.98370000E-04
   +2.58380000E-04  +8.31700000E-05  -3.94700800E-02  -1.60251200E-02  +3.25283900E-02
   +6.67316000E-03  +2.56557500E-02  +2.37194000E-03  +2.32706900E-02  -2.94513000E-03
   -2.34184000E-03  -1.44129780E-01  +7.32929800E-02  -2.04475000E-02  +5.72866690E-01
   -7.54600000E-05  +2.42300000E-05  +1.44620000E-04  +1.15989000E-03  -7.01380000E-04
   -6.06000000E-04  +5.39800000E-05  +3.09910000E-04  -2.53500000E-05  -1.75120000E-04
   +1.20000000E-07  +9.60100000E-05  +1.57520000E-04  -1.55200000E-05  -2.82740000E-04
   +1.38490000E-04  +2.81120000E-04  +1.41970000E-04  +7.43060000E-04  +1.72390000E-03
   +5.48933000E-03  +7.03090000E-04  -2.71640000E-04  -2.70260000E-04  -6.08000000E-06
   +5.61700000E-05  +4.41600000E-05  +5.52047000E-03  +2.26046700E-02  -1.19321200E-02
   -1.20416100E-02  -2.04080800E-02  -3.80213000E-03  -3.16362000E-03  -1.71357600E-02
   +1.83475200E-02  +1.12528650E-01  -3.50727360E-01  +1.72684380E-01  -1.34962190E-01
   +6.01968430E-01  +1.73210000E-04  +1.52020000E-04  +1.28560000E-04  +1.01489000E-03
   -7.24010000E-04  -6.03200000E-04  +6.57500000E-05  +1.01510000E-04  -2.64630000E-04
   +1.01900000E-05  +2.85800000E-05  +6.34200000E-05  +4.25200000E-05  +2.28900000E-05
   +4.64500000E-05  -8.06100000E-05  +4.09300000E-05  -2.93900000E-05  +4.73080000E-03
   +4.81872000E-03  +1.56211000E-03  -9.63150000E-04  +3.97700000E-04  -1.67200000E-05
   -3.87000000E-05  -3.27000000E-05  +1.01800000E-05  +2.56687300E-02  -5.38645000E-03
   -5.08847000E-03  +1.14192000E-03  -3.28831000E-03  -2.34852000E-03  -6.22998000E-03
   +2.36662300E-02  -9.90885000E-03  -3.50568700E-02  +1.77018710E-01  -1.71714440E-01
   -1.55464000E-01  -2.85755850E-01  +4.31443930E-01  -5.62150000E-04  -4.06690000E-04
   -4.09720000E-04  -8.64790000E-04  +1.29367000E-03  +9.74400000E-04  -5.10100000E-05
   +1.87860000E-04  +3.65400000E-04  -3.18370000E-04  -1.59560000E-04  +2.48140000E-04
   +6.73360000E-04  +4.53970000E-04  -1.48780000E-04  +1.33550000E-04  -1.14400000E-05
   +7.77300000E-05  -1.90848000E-02  -6.35738000E-03  +1.93604500E-02  -2.84432000E-03
   -1.05720000E-04  +1.11450000E-03  -6.72410000E-04  -4.86690000E-04  -1.79540000E-04
   -2.08058850E-01  -4.06986300E-02  +1.33617860E-01  -1.17842000E-03  -3.92667600E-02
   -3.18609000E-03  -1.07633900E-02  -8.73216000E-03  +1.08178200E-02  -3.14872000E-03
   +4.50073200E-02  -1.50661000E-02  -2.26261900E-01  +5.92819900E-02  +5.86605500E-02
   +5.47705380E-01  +4.01630000E-04  +5.48500000E-04  +1.64580000E-04  +9.32280000E-04
   -1.79886000E-03  -1.12348000E-03  -7.55200000E-05  +1.59510000E-04  +9.43900000E-05
   +2.41400000E-05  +3.75510000E-04  +3.47500000E-05  -6.30300000E-05  +4.83000000E-06
   +9.79300000E-05  -1.06200000E-04  +2.65280000E-04  -1.05290000E-04  +7.95246000E-03
   +9.97318000E-03  -1.04586100E-02  +1.29937000E-03  -1.17980000E-03  -1.15110000E-03
   +1.47260000E-04  +1.32600000E-04  +4.70300000E-05  -7.04484300E-02  -1.41384140E-01
   +1.09173150E-01  -1.37903500E-02  -2.95832600E-02  +2.44299800E-02  -6.42081000E-03
   +5.48373000E-03  -1.01264000E-03  +3.14077200E-02  -2.03905700E-02  -1.33667000E-03
   +8.96981800E-02  -1.22357650E-01  -9.30500000E-04  -1.07715800E-01  +5.46694020E-01
   +5.62840000E-04  +1.71960000E-04  +2.92920000E-04  -1.11727000E-03  -5.81380000E-04
   -3.28060000E-04  -4.60860000E-04  +8.11300000E-05  -8.29810000E-04  +4.70770000E-04
   +1.61040000E-04  +2.08820000E-04  -4.49090000E-04  -3.72940000E-04  +3.98150000E-04
   -2.07290000E-04  -3.76400000E-04  -1.20320000E-04  +9.31200000E-03  +1.28267000E-03
   +1.16300000E-05  +8.30560000E-04  -2.58220000E-04  -1.18901000E-03  +2.49310000E-04
   +8.77000000E-05  +9.62100000E-05  +1.46305730E-01  +9.09092300E-02  -2.36269430E-01
   +1.63894900E-02  +4.69439300E-02  +1.07739000E-03  +1.06885200E-02  -6.44140000E-04
   -1.05351100E-02  -2.15621700E-02  -7.52139000E-03  +1.46694700E-02  +3.61870600E-02
   +1.60206300E-02  -8.79916100E-02  -1.87151590E-01  -2.69115410E-01  +4.36361600E-01
   -2.10231000E-03  +4.69240000E-04  +1.98860000E-04  -9.61190000E-04  -1.64600000E-05
   -1.24782000E-03  +7.00720000E-04  +5.49950000E-04  +9.50780000E-04  -6.92750000E-04
   -8.88970000E-04  -1.51560000E-04  +4.65600000E-04  +1.79660000E-04  -7.14480000E-04
   +5.63950000E-04  +9.75970000E-04  +2.82210000E-04  -9.97830000E-04  -5.93080000E-04
   +4.95580000E-04  +3.71180000E-04  -1.65770000E-04  -4.59080000E-04  -2.36120000E-04
   -2.34840000E-04  -7.81700000E-05  -1.38269000E-03  -1.04500500E-02  +1.99369000E-03
   -7.52908800E-02  -3.87999000E-03  +1.87945900E-02  -2.43552400E-02  -1.07495600E-02
   +4.11323300E-02  -5.57711000E-03  +6.98675000E-03  +6.56020000E-04  -3.81919000E-03
   +1.73729000E-03  +3.38210000E-04  +6.14661000E-03  +2.42650000E-03  -2.29175000E-03
   +2.67797830E-01  +1.67100000E-04  +1.73840000E-04  -2.94600000E-04  -1.00966000E-03
   -2.65920000E-04  +1.12900000E-05  -1.38500000E-05  +1.67400000E-05  -1.93690000E-04
   +2.46990000E-04  +3.58150000E-04  -2.33000000E-06  -4.89300000E-04  -3.02190000E-04
   +7.82000000E-05  -6.00900000E-05  +1.09450000E-04  +2.04350000E-04  -2.07751000E-03
   +1.67427000E-03  -3.41532000E-03  -1.02140000E-04  +4.58990000E-04  +2.83740000E-04
   +5.86310000E-04  +5.87300000E-04  +1.93980000E-04  -2.16030500E-02  -1.09171100E-02
   +3.51518200E-02  -5.87119000E-03  -6.12802800E-02  +6.23884000E-03  +1.50054000E-03
   +7.75700000E-05  -5.07320000E-03  +7.74120000E-04  +5.78220000E-04  +1.68624000E-03
   -1.17666000E-03  +1.83443000E-03  -9.38110000E-04  +9.31759000E-03  -3.12379000E-03
   +7.57650000E-04  +1.62252910E-01  +2.49870610E-01  -3.02680000E-04  -3.25050000E-04
   -1.03957000E-03  -2.28000000E-06  +8.31550000E-04  +5.27680000E-04  -1.45180000E-04
   -9.84600000E-05  -3.44160000E-04  +2.43700000E-05  +1.51160000E-04  +2.49060000E-04
   +1.03700000E-05  -1.10400000E-05  -9.33400000E-05  -1.45900000E-04  -3.10530000E-04
   +3.07220000E-04  +1.59410000E-03  -1.45227000E-03  +2.48210000E-04  -3.81270000E-04
   +1.53640000E-04  +3.88420000E-04  -9.43100000E-05  -1.05170000E-04  +8.31700000E-05
   +1.00976600E-02  -4.89748000E-03  -2.18375400E-02  +6.28789700E-02  +4.54773700E-02
   -1.45106720E-01  +7.90082000E-03  +1.24147300E-02  -3.47805500E-02  -1.93354000E-03
   -5.92392000E-03  +5.49234000E-03  -4.42436000E-03  +3.63577000E-03  +5.02800000E-05
   +2.51779000E-03  +6.70356000E-03  -4.36598000E-03  +1.02354130E-01  +1.20686170E-01
   +4.66848730E-01  -5.03800000E-05  +7.99400000E-05  -1.05000000E-05  +1.45500000E-05
   -1.64070000E-04  -1.02950000E-04  -1.47750000E-04  +5.24100000E-05  +4.76000000E-06
   -1.58430000E-04  +2.17420000E-04  +1.33560000E-04  +2.83630000E-04  +2.26240000E-04
   +1.80300000E-05  -2.41000000E-05  +1.72410000E-04  -1.02900000E-04  +3.68000000E-06
   +8.72350000E-04  -3.55290000E-04  -2.61470000E-04  +9.15400000E-05  +2.75100000E-05
   -2.29770000E-04  -1.04880000E-04  -7.23800000E-05  -1.90321000E-03  -5.33789000E-03
   +7.53907000E-03  -3.58658000E-03  +3.88503900E-02  +4.66585000E-03  -5.13546000E-02
   -7.20999000E-03  -1.13650500E-02  -8.42993000E-03  -1.46293200E-02  +1.28528000E-03
   -4.99709000E-03  +9.74740000E-04  +2.39877000E-03  +3.24980000E-03  +2.00439000E-03
   -5.04845000E-03  +1.67530000E-03  +1.52412000E-03  -4.64220000E-04  +1.55589280E-01
   -7.41700000E-05  -8.18800000E-05  +2.66950000E-04  -4.55290000E-04  -4.04370000E-04
   -3.73320000E-04  +1.25890000E-04  -6.18300000E-05  +6.08700000E-05  +4.08900000E-05
   +1.69640000E-04  -2.45770000E-04  -8.29160000E-04  -5.04750000E-04  -3.26610000E-04
   +1.76460000E-04  +3.14890000E-04  +2.75720000E-04  -1.69749000E-03  -5.33560000E-04
   +1.01661000E-03  +8.12130000E-04  -7.54800000E-05  -1.91360000E-04  +9.60300000E-04
   +8.92350000E-04  +2.99160000E-04  -5.43733000E-03  -7.50130000E-03  -6.28558000E-03
   +4.12898800E-02  -1.63191700E-02  +1.41828500E-02  -1.12447400E-02  -3.35885500E-02
   +1.68588700E-02  -6.62437000E-03  -5.53744600E-02  +1.14749400E-02  -1.41351100E-02
   +8.61618000E-03  -2.31836000E-03  +9.04493000E-03  -4.70750000E-03  -4.72218000E-03
   -2.52750000E-04  +5.28142000E-03  -5.31874000E-03  +1.12857500E-02  +1.81355830E-01
   +6.00200000E-05  -2.75300000E-05  -6.45600000E-05  -2.67000000E-05  +9.63100000E-05
   +1.70040000E-04  +1.36200000E-05  -6.11300000E-05  -8.39300000E-05  +2.99100000E-05
   -3.54300000E-05  +1.29200000E-05  -6.06800000E-05  -6.25000000E-06  +4.98000000E-06
   -3.14100000E-05  -1.50760000E-04  +7.86000000E-06  +2.10580000E-04  -5.47910000E-04
   -1.63580000E-04  +3.32900000E-05  -3.51000000E-06  +1.94300000E-05  +7.52000000E-06
   -2.66400000E-05  +2.18500000E-05  +4.87740000E-04  +4.25617000E-03  -3.91078000E-03
   +6.04671000E-03  -6.65951000E-03  +5.49635000E-03  -1.08086600E-02  -1.15336500E-02
   -7.66576000E-02  +7.26392000E-03  +2.47926400E-02  +7.29368000E-03  +5.15508000E-03
   -2.41267000E-03  -3.88050000E-04  -3.30881000E-03  -4.49090000E-04  +2.75436000E-03
   -3.72000000E-05  -1.13858000E-03  +4.18095000E-03  +1.65742540E-01  +2.65799300E-02
   +5.34314080E-01  -3.86300000E-05  +2.79600000E-05  -3.64890000E-04  -1.91780000E-04
   +9.28470000E-04  +6.02920000E-04  -2.38780000E-04  -9.75600000E-05  -1.32800000E-05
   -1.48080000E-04  -4.05100000E-05  +2.71180000E-04  +9.14440000E-04  +7.20130000E-04
   +4.85200000E-04  -2.59270000E-04  -3.10030000E-04  -3.82740000E-04  +1.62128000E-03
   -1.54497000E-03  -8.50150000E-04  -4.28270000E-04  -1.73920000E-04  +3.56750000E-04
   -1.12834000E-03  -9.40830000E-04  -3.72590000E-04  +4.18460000E-04  +1.30465900E-02
   -6.00566000E-03  +3.79446000E-03  -1.41037100E-02  -4.66290000E-04  -4.72552700E-02
   +1.73922400E-02  +8.72935000E-03  -2.64999850E-01  +5.29429900E-02  +5.13073900E-02
   -1.68926900E-02  +1.54799400E-02  -4.09734000E-03  -3.51035000E-03  -3.24310000E-04
   +9.59097000E-03  -2.05005000E-03  -1.49487000E-03  +3.84623000E-03  +6.14541000E-03
   -1.17599000E-03  -1.89262000E-03  +3.65158220E-01  -2.18000000E-06  +2.53400000E-05
   +1.50190000E-04  +1.00280000E-04  -5.40180000E-04  -3.16940000E-04  +7.69200000E-05
   +8.80200000E-05  +6.58300000E-05  +1.16300000E-05  +6.32300000E-05  -9.66100000E-05
   -3.28520000E-04  -2.71340000E-04  -2.43040000E-04  +1.35250000E-04  +2.03830000E-04
   +1.66330000E-04  -7.03390000E-04  +8.15070000E-04  +1.26700000E-05  +2.33910000E-04
   +1.09560000E-04  -1.39530000E-04  +4.44530000E-04  +3.96800000E-04  +1.51760000E-04
   +9.35190000E-04  -5.42788000E-03  +1.61400000E-03  -1.31970000E-03  +3.58378000E-03
   +4.00894000E-03  -4.24294000E-03  -1.32886000E-03  +1.71211000E-03  +9.51431400E-02
   -1.15505070E-01  +7.17694000E-03  +4.96417600E-02  -1.60532700E-02  -3.76020000E-03
   -6.51150000E-04  +1.16059000E-03  +4.02302000E-03  -1.76900000E-03  +4.75420000E-04
   -1.10005000E-03  -9.63666000E-03  +4.57611000E-03  +3.53751000E-03  -9.54647700E-02
   +6.11397310E-01  -1.74300000E-05  -4.80400000E-05  -8.12600000E-05  -1.89000000E-04
   +3.85400000E-05  +1.36040000E-04  +2.54100000E-05  -4.47800000E-05  -2.73100000E-05
   +1.13100000E-05  -1.71000000E-06  +1.15500000E-05  -5.26000000E-05  -5.22000000E-06
   -1.55000000E-06  -1.44800000E-05  -4.96200000E-05  +3.10900000E-05  -1.78370000E-04
   -6.87780000E-04  -7.13540000E-04  +4.95500000E-05  -1.55000000E-05  +3.48700000E-05
   +3.31200000E-05  +1.48900000E-05  +1.99300000E-05  +3.88870000E-04  +5.62799000E-03
   -3.66480000E-03  +1.66315000E-03  +4.44540000E-04  -8.15460000E-04  +2.92997600E-02
   -7.61196000E-03  -2.01740000E-04  +3.58268100E-02  +2.66028800E-02  -6.61377500E-02
   -1.72806700E-02  +3.24884000E-03  +1.14430800E-02  -1.05912000E-03  +3.98401000E-03
   +4.90836000E-03  +2.89281000E-03  -5.06410000E-04  -1.66350000E-03  +9.17500000E-04
   +3.50400000E-05  +1.34328000E-03  -7.16812500E-02  -1.61923410E-01  +1.05097680E-01
   -8.79440000E-04  -1.24030000E-03  -3.28830000E-04  -2.56939000E-03  -7.79164000E-03
   -2.68484400E-02  -3.63187000E-03  -3.64375000E-03  +5.35330000E-04  -1.87120000E-04
   -1.59760000E-04  -1.38164000E-03  +3.33150000E-04  +9.26200000E-05  +7.03100000E-05
   +9.57900000E-05  +2.31900000E-05  -9.40030000E-04  -7.44360300E-02  -9.50100000E-05
   +9.26730000E-04  +3.71990000E-04  +3.70000000E-06  -5.13573000E-03  -4.74780000E-04
   -3.63050000E-04  -1.55500000E-04  -1.35055000E-03  +7.26829000E-03  +2.92014100E-02
   +7.40050000E-04  +3.58960000E-04  -1.25080000E-04  -7.66090000E-04  -9.77020000E-04
   -1.12110000E-04  +7.80030000E-04  -4.24730000E-04  +1.52820000E-04  -1.27876000E-03
   -7.32270000E-04  -1.11160000E-03  -1.98761000E-03  +2.10954000E-03  -1.58220000E-04
   +1.35260000E-04  +3.65130000E-03  +3.88380000E-04  +2.68700000E-04  +2.61620000E-04
   -1.58710000E-04  -1.11975000E-03  +6.73640000E-04  +6.19700000E-05  +5.81411310E-01
   +5.05510000E-04  -5.02450000E-04  -4.79590000E-04  -2.97703000E-03  -7.20550000E-03
   -2.19895900E-02  -3.12771000E-03  -2.06917000E-03  +6.34490000E-04  -1.33150000E-04
   +2.21820000E-04  -9.97130000E-04  +5.35600000E-05  +1.91250000E-04  +7.34100000E-05
   +1.99220000E-04  +4.78900000E-05  -4.38880000E-04  -2.76712000E-03  -8.38483400E-02
   -2.80028200E-02  +1.54119000E-03  +3.91813000E-03  +2.94382300E-02  -1.31190000E-04
   -1.35000000E-04  -2.10800000E-05  +3.10622000E-03  -4.96795000E-03  -1.72312500E-02
   +1.97050000E-04  -4.43400000E-04  -6.18410000E-04  +3.81930000E-04  +5.73470000E-04
   +1.76100000E-04  -3.24660000E-04  +3.53580000E-04  -1.11510000E-04  +6.12010000E-04
   +1.33300000E-04  +5.33600000E-04  -3.71380000E-04  -1.45362000E-03  +3.91440000E-04
   +7.20770000E-04  -2.05484000E-03  +5.34890000E-04  -1.93190000E-04  -6.42000000E-06
   +9.98700000E-05  +4.34440000E-04  -3.06750000E-04  -3.37700000E-05  +9.23700000E-04
   +5.75048380E-01  +5.01170000E-04  +9.40960000E-04  +5.79230000E-04  -5.71172000E-03
   -5.17851000E-03  -6.89178000E-03  +5.41820000E-04  -4.77000000E-05  +3.47320000E-04
   +4.29740000E-04  +2.27360000E-04  -1.36590000E-04  -3.10920000E-04  -2.51420000E-04
   +3.03910000E-04  +2.34090000E-04  +8.48400000E-05  -5.82420000E-04  -6.57401000E-03
   -2.38587800E-02  -1.62098360E-01  -3.36332000E-03  +2.70093000E-03  -3.42376000E-02
   +3.27060000E-04  +2.77590000E-04  +3.13300000E-05  +9.28677000E-03  -6.68666000E-03
   -1.21174300E-02  -1.10778000E-03  +6.55980000E-04  +2.36215000E-03  +4.90080000E-04
   +1.33110000E-04  -4.74720000E-04  +7.39200000E-05  -8.63600000E-05  +1.52600000E-05
   +3.26210000E-04  +1.95030000E-04  +4.34860000E-04  -1.22547000E-03  -6.04220000E-04
   +3.85210000E-04  +1.66008000E-03  -4.62166000E-03  -2.38686000E-03  -7.29500000E-05
   +2.45640000E-04  -5.51300000E-05  -1.47570000E-04  +7.06100000E-05  -5.09800000E-05
   -3.54413000E-03  -5.54743800E-02  +4.83283080E-01  +1.47469000E-03  -3.27300000E-04
   -1.33622000E-03  +5.72000000E-05  +2.20800000E-05  +7.61430000E-04  -6.32300000E-04
   -1.46760000E-04  -4.15300000E-04  +1.42047000E-03  +1.70353000E-03  -1.27001000E-03
   -9.31129000E-03  -5.43013000E-03  -3.95606100E-02  -3.74358000E-03  -4.49013000E-03
   +4.86320000E-04  -1.78420000E-04  -2.38700000E-05  +9.66300000E-05  +6.34400000E-05
   +1.95600000E-05  -1.12800000E-05  -3.43971100E-02  -2.48020300E-02  -3.14718200E-02
   -5.94600000E-05  -1.56720000E-04  +9.26000000E-05  +2.02240000E-04  +2.74990000E-04
   +1.21650000E-04  -7.61700000E-05  +8.86800000E-05  -4.68300000E-05  -1.46240000E-04
   +4.28000000E-06  +4.16700000E-05  -5.97500000E-05  +3.79300000E-05  +2.76000000E-05
   +1.08590000E-04  +4.12600000E-05  -6.51100000E-05  +3.10700000E-05  -2.07900000E-05
   -3.78000000E-06  +8.64600000E-05  -7.22500000E-05  -1.51800000E-05  +1.61960000E-04
   -4.63500000E-05  -5.21000000E-06  +5.92200000E-05  +3.27100000E-05  -2.63200000E-05
   +4.61268300E-02  -3.00740000E-04  +1.39702000E-03  -1.31563000E-03  -2.73800000E-05
   +1.54010000E-04  +5.42580000E-04  +4.20000000E-05  -8.16960000E-04  -2.20740000E-04
   +1.77399000E-03  +5.66480000E-04  -8.25740000E-04  -5.79434000E-03  -7.86754000E-03
   -3.24091500E-02  -4.75196000E-03  -1.67325000E-03  +4.58020000E-04  -8.39000000E-05
   -9.43100000E-05  +6.07100000E-05  +1.31700000E-05  -1.13900000E-05  -1.03000000E-06
   -2.43545400E-02  -2.29917700E-02  -2.59791000E-02  -2.67700000E-05  +9.34500000E-05
   +1.31700000E-05  +2.39000000E-05  -5.77800000E-05  -5.15200000E-05  -1.23900000E-05
   +1.79680000E-04  -5.90000000E-07  -1.23700000E-04  -3.07000000E-06  +1.01500000E-05
   -4.47200000E-05  -2.97000000E-06  +1.71000000E-05  +5.78800000E-05  -2.63800000E-05
   +1.20100000E-05  +5.10600000E-05  -1.09420000E-04  +2.32700000E-05  +1.50000000E-06
   -1.79780000E-04  +1.92000000E-06  +1.45240000E-04  -6.86000000E-05  -3.30000000E-06
   +6.61200000E-05  +2.19600000E-05  -1.48400000E-05  +3.37304800E-02  +3.15374100E-02
   +1.90750000E-04  +5.21300000E-05  -7.45720000E-04  +5.30500000E-05  +1.03760000E-04
   +2.49990000E-04  +1.26060000E-04  +4.39100000E-05  -9.80200000E-04  +3.94030000E-03
   +3.12249000E-03  +4.99233000E-03  -8.98630000E-04  -8.88310000E-04  -1.13884900E-02
   -7.88980000E-04  -6.64000000E-04  +2.46735000E-03  -8.06700000E-05  -7.16300000E-05
   -1.39520000E-04  +1.08720000E-04  +4.72900000E-05  +8.75000000E-05  -7.32145300E-02
   -5.98808200E-02  -5.28022840E-01  -3.66000000E-05  +1.78300000E-05  +9.43400000E-05
   +9.76400000E-05  +9.83200000E-05  +2.43200000E-05  -3.27100000E-05  +1.00010000E-04
   -6.89000000E-06  -1.04920000E-04  -1.11000000E-06  +1.67300000E-05  -3.85200000E-05
   +1.74000000E-06  -2.81000000E-06  +8.09200000E-05  -7.03000000E-06  -5.22600000E-05
   +2.57000000E-05  -4.31100000E-05  -1.06500000E-05  +4.69200000E-05  -8.84500000E-05
   -1.78700000E-05  +1.28250000E-04  -4.73500000E-05  -9.82000000E-06  +3.26600000E-05
   +2.03200000E-05  -3.51100000E-05  +7.10180700E-02  +5.82234800E-02  +5.33751940E-01
   -1.56781000E-03  -4.24810000E-04  +3.81710000E-04  -4.28550000E-04  -6.19202000E-03
   -3.69700000E-04  -5.59310000E-04  -3.38799000E-03  -2.38789700E-02  -6.00934200E-02
   -2.41511300E-02  -4.91262700E-02  +6.19253000E-03  +2.97526000E-03  +1.60327200E-02
   +5.34580000E-04  -3.79822000E-03  +3.30634000E-03  +5.34270000E-04  -1.04640000E-04
   -1.08916000E-03  +2.56400000E-05  +1.41740000E-04  -1.01260000E-04  +7.83110000E-04
   +3.65484000E-03  +5.88290000E-04  +1.09580000E-04  -1.23820000E-04  +3.12800000E-05
   +6.54500000E-05  +1.47020000E-04  +8.41200000E-05  -4.73300000E-05  -9.41200000E-05
   -2.86900000E-05  +5.31600000E-05  +1.75900000E-05  +1.52300000E-05  +1.25600000E-05
   +2.02000000E-05  +5.26000000E-06  -2.68200000E-05  +5.39500000E-05  +2.47000000E-06
   -5.36900000E-05  +9.03700000E-05  +1.73700000E-05  +2.87900000E-05  +9.30100000E-05
   +7.30000000E-07  -7.68000000E-05  +4.44200000E-05  +6.19000000E-06  -4.11250000E-04
   -2.09080000E-04  +3.86400000E-05  -3.90980000E-04  -6.97210000E-04  -6.66190000E-04
   +5.63687800E-02  -6.70900000E-05  -1.01361000E-03  +2.94570000E-04  -6.30261000E-03
   +2.34829000E-03  -1.73400000E-05  -2.72755000E-03  -9.59420000E-04  -2.02339500E-02
   -2.35422400E-02  -5.51492500E-02  -5.54476600E-02  +1.52602000E-03  +5.28754000E-03
   +1.16925900E-02  -3.92437000E-03  +2.55757000E-03  +1.85586000E-03  +3.07000000E-05
   +3.32030000E-04  -9.40310000E-04  -2.83500000E-05  +4.61000000E-06  +3.79200000E-05
   +3.38391000E-03  -1.09167000E-03  +6.12710000E-04  +2.13150000E-04  +1.03280000E-04
   -1.18340000E-04  -1.29630000E-04  -2.10000000E-04  -8.01500000E-05  +3.87600000E-05
   -1.67700000E-05  +1.16400000E-05  +4.99500000E-05  +6.89000000E-06  -2.66600000E-05
   +3.49600000E-05  -2.38500000E-05  +8.78000000E-06  -8.37000000E-05  -6.49000000E-06
   +1.29820000E-04  +6.10000000E-06  +1.81200000E-05  +4.27000000E-06  -4.34000000E-05
   +1.11400000E-05  +1.06500000E-05  -5.97200000E-05  +9.59000000E-06  +4.15000000E-06
   -2.04910000E-04  -1.76070000E-04  +8.25500000E-05  -5.74000000E-04  +1.14470000E-04
   -4.94040000E-04  +2.92425100E-02  +5.03687300E-02  +6.07220000E-04  +6.08350000E-04
   +5.36320000E-04  -6.75940000E-04  -7.71670000E-04  +2.29498000E-03  +1.03130000E-04
   -1.86310000E-04  -3.09241000E-03  -4.93685400E-02  -5.55302900E-02  -3.13215540E-01
   -9.92019000E-03  -8.91781000E-03  -1.82172200E-02  +3.64673000E-03  +2.44631000E-03
   -1.80086000E-03  +2.90770000E-04  +1.30960000E-04  -3.03740000E-04  -6.64000000E-05
   +5.77000000E-06  -1.92700000E-05  -5.64300000E-05  +2.86370000E-04  +2.92703000E-03
   +4.03000000E-05  -1.01910000E-04  -2.35000000E-06  +1.82500000E-05  +8.30700000E-05
   +5.30200000E-05  -9.90000000E-06  -9.79200000E-05  -3.12000000E-06  +7.45900000E-05
   +1.33000000E-06  +2.47000000E-06  +2.17400000E-05  +1.31700000E-05  -4.85000000E-06
   -3.15500000E-05  +2.74400000E-05  -2.12400000E-05  -3.14400000E-05  +6.56500000E-05
   +7.43000000E-06  +1.14000000E-06  +9.34700000E-05  +3.70000000E-07  -9.70700000E-05
   +4.52600000E-05  +3.26000000E-06  -1.62390000E-04  -6.89900000E-05  +4.88800000E-05
   +1.77757000E-03  +1.27523000E-03  -7.49230000E-04  +5.44912200E-02  +6.13451700E-02
   +3.32171390E-01  +2.76339000E-03  -3.18589000E-03  -1.64695000E-03  +8.29007000E-03
   +2.34834000E-03  -4.54725000E-03  -1.39425510E-01  -6.61661300E-02  +1.17937950E-01
   -9.00346000E-03  -8.47156000E-03  +1.87117600E-02  +6.72940000E-04  -5.59392000E-03
   -2.17197000E-03  -5.21260000E-04  +4.28750000E-04  -6.80360000E-04  -1.68648000E-03
   +1.20855000E-03  -2.84570000E-04  -4.03320000E-04  -7.81260000E-04  -3.08680000E-04
   -9.23760000E-04  -7.52950000E-04  +8.55430000E-04  +5.02500000E-05  +1.25400000E-05
   -4.95770000E-04  +3.79100000E-05  -2.52800000E-04  -1.24400000E-04  -4.10900000E-05
   +2.73940000E-04  -9.04600000E-05  -2.34630000E-04  -6.73100000E-05  +2.84000000E-05
   -2.39790000E-04  +6.93300000E-05  +1.12680000E-04  +7.53500000E-05  +1.77550000E-04
   +5.83460000E-04  -3.66200000E-05  -2.51500000E-05  +1.73990000E-04  +1.64000000E-06
   -2.43640000E-04  +4.29800000E-05  +2.64630000E-04  -1.03850000E-04  +1.82800000E-05
   +5.72600000E-05  +2.00540000E-04  -3.23400000E-05  +9.88700000E-05  +1.07570000E-04
   +1.86510000E-04  -1.08793000E-03  +2.54898000E-03  -3.04440000E-04  +1.40703770E-01
   -3.30418000E-03  +4.12751000E-03  -1.96947000E-03  +4.02199000E-03  +7.50276000E-03
   -4.41623000E-03  -6.51951100E-02  -8.36768000E-02  +7.42948200E-02  -1.10959100E-02
   -3.62414000E-03  +1.52933000E-02  -5.75320000E-03  +3.05013000E-03  -2.33573000E-03
   +4.41540000E-04  -8.75990000E-04  -4.44630000E-04  +1.42883000E-03  -2.00084000E-03
   +1.59670000E-04  -5.61300000E-04  -1.01558000E-03  -9.79650000E-04  -8.88250000E-04
   -5.71920000E-04  +7.43700000E-04  -2.73100000E-05  +5.35100000E-04  -3.39590000E-04
   -1.36820000E-04  -4.44560000E-04  -1.67450000E-04  +7.23800000E-05  +5.95300000E-05
   +4.12600000E-05  +1.18200000E-05  -5.64400000E-05  -3.99000000E-06  +1.87000000E-05
   -1.73000000E-05  +6.09000000E-06  +5.07100000E-05  -1.22410000E-04  -1.21490000E-04
   +3.54100000E-05  -6.17900000E-05  -3.20600000E-05  -3.60200000E-05  -6.89100000E-05
   +2.84000000E-06  +2.00400000E-05  -3.25300000E-05  +3.79000000E-06  +1.11970000E-04
   -1.98470000E-04  +7.31700000E-05  +1.28120000E-04  +4.72600000E-05  +1.62560000E-04
   +2.62181000E-03  -2.38379000E-03  +3.52300000E-05  +7.83250500E-02  +8.17126600E-02
   -1.76506000E-03  -2.31808000E-03  -5.35346000E-03  +1.80756400E-02  +1.22586800E-02
   -1.67444000E-02  +1.17594330E-01  +7.48405700E-02  -2.17518130E-01  -5.75377000E-03
   -4.08068000E-03  +8.74366000E-03  -1.65598000E-03  -1.88996000E-03  +9.87670000E-04
   -9.25170000E-04  -6.56410000E-04  -1.22140000E-04  +9.50940000E-04  +1.26030000E-03
   +8.74100000E-05  +1.89390000E-04  +6.50200000E-05  -4.47360000E-04  -1.90610000E-04
   -1.79570000E-04  +3.45390000E-04  -2.25400000E-04  +7.90000000E-06  -1.45810000E-04
   +8.59500000E-05  +4.82100000E-05  -2.83360000E-04  -2.72200000E-05  +2.02200000E-04
   -5.51600000E-05  -1.92190000E-04  -3.68000000E-05  +5.41000000E-06  -1.40860000E-04
   +2.59300000E-05  +1.35940000E-04  +1.29000000E-06  +3.42700000E-05  +2.24420000E-04
   -1.32400000E-04  -6.11000000E-05  +2.45110000E-04  -1.20500000E-05  -2.08870000E-04
   +4.33900000E-05  +2.42610000E-04  -1.12440000E-04  +1.39500000E-05  -6.88900000E-05
   -6.80700000E-05  +1.17660000E-04  +9.25000000E-06  +1.18100000E-05  +2.11000000E-05
   -2.18700000E-05  +4.70230000E-04  +8.40210000E-04  -1.27035310E-01  -8.00276200E-02
   +2.28403960E-01  -6.17364700E-02  -2.04013800E-02  -5.15254700E-02  +8.62867000E-03
   +3.82937000E-03  +1.59198600E-02  +6.40960000E-04  -4.51957000E-03  +3.37112000E-03
   -1.18486000E-03  -3.95200000E-05  +2.62590000E-04  +1.89030000E-04  -6.40091000E-03
   -9.04100000E-05  -8.87200000E-04  -5.11370000E-03  -2.38172000E-02  -1.08533000E-03
   +2.23771000E-03  -2.86690000E-04  +4.95700000E-04  +1.72390000E-04  -1.54680000E-04
   -1.70060000E-04  -2.05530000E-04  -1.23896000E-03  -4.07520000E-04  -4.49140000E-04
   +4.08000000E-05  -1.73370000E-04  -5.16100000E-05  +5.44730000E-04  +4.67400000E-05
   +1.14660000E-04  -8.00300000E-05  -6.55800000E-05  -7.13200000E-05  +3.51800000E-05
   -2.93300000E-05  +5.95400000E-05  +3.33300000E-05  +4.10000000E-06  +9.40200000E-05
   -1.71950000E-04  +2.86540000E-04  -3.76580000E-04  -4.15910000E-04  +2.57500000E-05
   -8.60300000E-05  -2.92000000E-05  +9.17200000E-05  -8.22000000E-06  -2.73500000E-05
   -1.44134000E-03  -2.12181000E-03  +4.99720000E-04  -3.13490000E-04  -1.15440000E-04
   -1.14070000E-04  -2.42580000E-04  +3.75260000E-04  -4.64300000E-05  +2.08890000E-04
   +3.56620000E-04  +9.54710000E-04  +6.16909600E-02  -1.99943700E-02  -5.90634700E-02
   -5.43128200E-02  +2.79562000E-03  +7.55155000E-03  +1.14746100E-02  -4.65476000E-03
   +3.22600000E-03  +2.03331000E-03  +9.67000000E-06  -1.08740000E-03  +3.69060000E-04
   -6.45303000E-03  +2.99544000E-03  -2.30290000E-04  -4.10085000E-03  -1.20560000E-04
   -1.98005000E-02  +2.15321000E-03  -1.86047000E-03  -2.95000000E-06  -4.02670000E-04
   -3.70400000E-04  -1.34470000E-04  -2.01180000E-04  -1.58430000E-04  -1.13514000E-03
   +3.16030000E-04  +6.57650000E-04  -2.12310000E-04  +1.30200000E-05  -6.00000000E-05
   -4.88580000E-04  +4.66000000E-06  +8.35400000E-05  +8.57500000E-05  -5.66500000E-05
   +8.07300000E-05  -4.29600000E-05  +2.92100000E-05  -8.49100000E-05  -1.52600000E-05
   +4.59800000E-05  -1.96240000E-04  +8.61900000E-05  -4.30230000E-04  -2.66130000E-04
   +3.29410000E-04  -8.32300000E-05  -9.91700000E-05  +6.04000000E-05  +7.54200000E-05
   -7.45300000E-05  +2.03400000E-05  -1.78049000E-03  -1.27202000E-03  +3.56040000E-04
   -1.16670000E-04  -3.18080000E-04  -7.58200000E-05  +3.78630000E-04  -4.21180000E-04
   -5.57000000E-06  +2.64720000E-04  +1.05280000E-04  +7.40960000E-04  +3.10796100E-02
   +5.44439800E-02  -5.06530600E-02  -5.45885800E-02  -3.24607520E-01  -5.56286000E-03
   -5.44390000E-03  -1.74111600E-02  +3.33195000E-03  +2.09281000E-03  -2.27496000E-03
   +4.51180000E-04  +4.75600000E-04  +6.64250000E-04  -1.36080000E-04  -3.69820000E-04
   +2.08623000E-03  +4.55260000E-04  +2.42900000E-05  -2.62328000E-03  -1.42597000E-03
   -9.95270000E-04  -6.99400000E-04  +1.64480000E-04  -2.67300000E-05  +5.00700000E-05
   -2.46970000E-04  -2.08290000E-04  -4.11400000E-04  -5.91000000E-06  +1.50140000E-04
   +1.02890000E-04  +1.72790000E-04  +5.97100000E-05  -3.73870000E-04  -6.67800000E-05
   -4.30700000E-05  +4.47100000E-05  +5.35000000E-06  +2.19200000E-05  -6.74000000E-06
   -1.34800000E-05  -7.77000000E-06  -2.22000000E-06  +3.71300000E-05  -6.66000000E-06
   +8.59800000E-05  -6.17590000E-04  +1.87610000E-04  +2.71460000E-04  -1.27900000E-05
   +8.74000000E-06  +3.00400000E-05  -2.57100000E-05  +3.03000000E-06  +2.63600000E-05
   -1.34397000E-03  -1.02732000E-03  +1.81830000E-04  -1.46800000E-05  -5.38000000E-06
   +4.10500000E-05  -8.60600000E-05  -4.00800000E-05  -6.82700000E-05  -3.99070000E-04
   -3.43130000E-04  -9.67560000E-04  +5.74762600E-02  +6.09180500E-02  +3.43967870E-01
   -8.24677000E-03  -7.56979000E-03  +1.82959700E-02  +2.55710000E-04  -5.72193000E-03
   -1.70629000E-03  -7.57560000E-04  +2.50970000E-04  -8.52560000E-04  +2.41844000E-03
   -2.64529000E-03  -1.61488000E-03  +7.04678000E-03  +1.32556000E-03  -5.60819000E-03
   -1.35817980E-01  -7.34169000E-02  +1.16347260E-01  +7.09300000E-05  -1.25160000E-04
   +8.94680000E-04  -2.68540000E-04  -1.36110000E-04  -1.12090000E-04  -6.63680000E-04
   +2.27194000E-03  +3.45200000E-04  +8.24300000E-05  -2.29210000E-04  +5.86000000E-06
   -4.38100000E-05  +7.66700000E-05  +1.73720000E-04  +1.17100000E-05  -1.08680000E-04
   -2.19800000E-05  +5.01000000E-05  -3.51000000E-06  +4.82000000E-06  +1.50600000E-05
   +1.01000000E-05  +2.99000000E-06  -5.38700000E-05  +8.54400000E-05  -1.43000000E-06
   +5.36900000E-05  +1.42570000E-04  -1.31310000E-04  +6.53400000E-05  +1.33650000E-04
   -5.20300000E-05  -5.86200000E-05  +3.80100000E-05  -1.28700000E-05  -1.88200000E-05
   +8.52500000E-05  +7.20100000E-05  -2.02940000E-04  +2.85330000E-04  +8.43700000E-05
   +3.08410000E-04  +1.79890000E-04  -3.72090000E-04  -2.86010000E-04  +3.52300000E-04
   +4.77800000E-05  -1.17605000E-03  +2.62601000E-03  -3.05400000E-04  +1.37374680E-01
   -9.27199000E-03  -3.88998000E-03  +1.53216500E-02  -5.77353000E-03  +2.64097000E-03
   -2.08199000E-03  +4.02180000E-04  -8.79630000E-04  -5.59790000E-04  -2.79101000E-03
   +3.40650000E-03  -1.75254000E-03  +2.69729000E-03  +6.70766000E-03  -6.00933000E-03
   -7.31645400E-02  -8.89863000E-02  +8.25079800E-02  -1.28600000E-04  +9.97200000E-05
   +7.31310000E-04  -1.41120000E-04  +5.61500000E-05  -5.38700000E-05  +2.17711000E-03
   -1.74695000E-03  +5.75080000E-04  -9.28700000E-05  -1.31330000E-04  -1.14600000E-04
   -2.69200000E-05  -6.58700000E-05  +9.10000000E-06  +2.50000000E-06  -1.41600000E-05
   +1.49100000E-05  +6.50700000E-05  -1.70400000E-05  +3.10000000E-07  +2.45200000E-05
   +2.88500000E-05  +1.35400000E-05  -5.69900000E-05  -1.95000000E-06  +3.22800000E-05
   +2.18800000E-05  -2.29300000E-05  -3.34000000E-05  -3.14000000E-05  +8.22000000E-06
   +1.10200000E-05  -8.22400000E-05  +3.10600000E-05  -3.50000000E-06  +3.00300000E-05
   +5.86000000E-06  +7.01800000E-05  +2.99460000E-04  -2.87680000E-04  +1.34170000E-04
   +2.55750000E-04  +2.14710000E-04  -3.48000000E-04  +3.38570000E-04  -4.39710000E-04
   +1.02670000E-04  +2.63807000E-03  -2.40768000E-03  -8.67000000E-06  +8.25873200E-02
   +8.56144500E-02  -5.48128000E-03  -3.90299000E-03  +9.61786000E-03  -1.63732000E-03
   -1.65671000E-03  +1.19815000E-03  -1.07163000E-03  -8.43360000E-04  -2.96660000E-04
   -2.08669000E-03  -2.22003000E-03  -4.85977000E-03  +1.99282500E-02  +1.45400300E-02
   -1.66620200E-02  +1.15015860E-01  +8.12209900E-02  -2.15071650E-01  -2.00860000E-04
   -1.47130000E-04  +3.05360000E-04  -3.54400000E-05  -3.26500000E-05  -2.42900000E-05
   +7.73600000E-05  +3.77560000E-04  +2.20733000E-03  -7.25000000E-06  -2.21100000E-05
   -1.37200000E-05  +4.73000000E-06  +3.25000000E-06  +1.47000000E-05  -6.73000000E-06
   +3.31900000E-05  -3.98000000E-06  -1.94000000E-05  -2.10000000E-06  +5.17000000E-06
   -5.89000000E-06  +7.93000000E-06  +6.34000000E-06  +1.05000000E-05  +1.53000000E-06
   +8.44000000E-06  +3.15500000E-05  -3.31800000E-05  -1.99400000E-05  -2.63000000E-06
   -3.52800000E-05  +5.16000000E-06  +2.16300000E-05  -8.04000000E-06  -1.59000000E-06
   +5.28600000E-05  +2.40700000E-05  +1.38000000E-05  +4.65000000E-06  +6.46800000E-05
   +4.33350000E-04  +8.36670000E-04  +5.90520000E-04  -9.89880000E-04  +2.95300000E-05
   +7.00700000E-05  +1.59700000E-05  +1.25480000E-04  +4.21080000E-04  +8.59090000E-04
   -1.25510690E-01  -8.85534400E-02  +2.23313730E-01  +4.03920000E-04  +2.55360000E-04
   +7.25300000E-05  +6.32950000E-04  -1.23105000E-03  -2.64040000E-04  +2.39140000E-04
   -4.99100000E-05  +2.15330000E-04  -2.66200000E-05  +1.21280000E-04  -1.04600000E-05
   -3.79500000E-05  +1.20300000E-05  +5.85200000E-05  -5.05000000E-05  +2.59400000E-05
   -1.31620000E-04  -5.06177000E-03  +9.01210000E-04  +1.82785000E-03  -2.55079090E-01
   +9.17399900E-02  +6.48250200E-02  +3.97700000E-05  -1.93400000E-05  -7.69000000E-06
   +5.19720000E-04  +2.63510000E-04  -4.82390000E-04  -2.28980000E-04  +2.63650000E-04
   +6.72140000E-04  +1.85470000E-04  -2.09700000E-04  +7.36300000E-05  +1.45440000E-04
   +4.53300000E-05  -1.45200000E-05  +2.14990000E-04  +2.00520000E-04  -1.52510000E-04
   +1.65200000E-05  -3.18000000E-05  +3.15590000E-04  +1.62770000E-04  -6.85800000E-05
   -3.47960000E-04  -5.97800000E-05  +3.30220000E-04  -3.44700000E-05  -2.72890000E-04
   +1.27500000E-04  -2.88000000E-05  -1.30900000E-04  -4.15310000E-04  +7.63290000E-04
   -1.40800000E-05  +4.77000000E-06  +4.20000000E-07  -1.71000000E-06  +1.59000000E-05
   +3.47000000E-06  +3.81400000E-05  -1.49900000E-05  -7.08800000E-05  +1.97500000E-05
   +7.18000000E-06  -1.72700000E-05  +1.11600000E-05  +2.12600000E-05  +3.12000000E-06
   +2.74729470E-01  -3.99540000E-04  -1.15800000E-05  +1.75330000E-04  +1.47679000E-03
   +6.67270000E-04  -2.70620000E-04  -2.35570000E-04  +7.40200000E-05  -4.31650000E-04
   -1.09300000E-04  +1.59000000E-06  -3.49300000E-05  -1.57960000E-04  -1.70000000E-04
   -1.52700000E-04  +5.41900000E-05  +1.89000000E-06  +1.80070000E-04  +2.44321700E-02
   -1.34194000E-02  -7.02739000E-03  +8.96454600E-02  -8.53112500E-02  -2.89626000E-02
   +2.15440000E-04  +2.06050000E-04  +9.73600000E-05  -7.38600000E-04  -4.29944000E-03
   +3.50140000E-03  +1.51909000E-03  +1.59200000E-05  -9.16920000E-04  +2.56200000E-05
   -1.73840000E-04  +3.18840000E-04  -2.62280000E-04  +2.58600000E-05  +3.69200000E-05
   +7.06900000E-05  +2.08010000E-04  -9.20000000E-07  -4.49370000E-04  -9.80300000E-05
   +5.65570000E-04  -2.06430000E-04  -2.84300000E-05  +1.96420000E-04  +2.37300000E-05
   -2.41400000E-04  +1.07600000E-05  +2.29930000E-04  -9.97700000E-05  -3.04600000E-05
   +1.29010000E-04  +3.89820000E-04  -1.61078000E-03  -9.54000000E-06  -2.81500000E-05
   -2.99700000E-05  +1.40700000E-05  -1.55800000E-05  +1.03000000E-05  +1.17030000E-04
   +2.06000000E-05  +1.22600000E-04  +1.64300000E-05  -1.62200000E-05  +1.33600000E-05
   +1.44800000E-05  -1.21100000E-05  -5.40000000E-06  -1.00417530E-01  +9.47896200E-02
   -1.33120000E-04  -2.52390000E-04  +4.53100000E-05  -2.67550000E-04  -3.39320000E-04
   +5.12760000E-04  +1.46730000E-04  +6.23300000E-05  -3.57630000E-04  -3.38760000E-04
   -6.03800000E-05  +1.52260000E-04  +4.63700000E-05  +3.51000000E-06  -1.65030000E-04
   +8.08300000E-05  +9.59800000E-05  +4.28500000E-05  -1.48412400E-02  +6.79504000E-03
   +2.50586000E-03  +6.62671100E-02  -3.00402600E-02  -6.80085100E-02  -7.42000000E-05
   -6.25900000E-05  -6.00000000E-06  +2.51520000E-04  +3.17558000E-03  -2.22606000E-03
   -7.41310000E-04  -1.74040000E-04  +5.36620000E-04  +8.28200000E-05  +2.53560000E-04
   -1.21550000E-04  +5.90500000E-05  -1.23800000E-05  -3.40200000E-05  -4.60800000E-05
   -1.51640000E-04  +3.70960000E-04  +6.05470000E-04  +3.35020000E-04  -2.23450000E-04
   +1.81100000E-05  -9.81200000E-05  +3.84400000E-05  -7.32700000E-05  +3.68600000E-05
   +3.73700000E-05  +2.82500000E-05  -8.02600000E-05  +1.73100000E-05  -1.53144000E-03
   +9.82820000E-04  +6.57630000E-04  +1.10600000E-05  -8.83000000E-06  +9.55000000E-06
   +1.22300000E-05  -1.53900000E-05  -1.07700000E-05  +1.92910000E-04  +3.96100000E-05
   +1.02560000E-04  +1.71800000E-05  +3.77700000E-05  -2.90400000E-05  -8.05000000E-06
   +1.73000000E-06  +4.90000000E-06  -7.18583000E-02  +2.83811700E-02  +7.28920400E-02
   +5.44720000E-04  +2.14020000E-04  -2.76210000E-04  +1.84810000E-04  -1.32610000E-04
   -2.16350000E-04  +2.28640000E-04  +3.51100000E-05  +3.42120000E-04  +3.37400000E-05
   +2.21100000E-05  +4.56300000E-05  +1.83930000E-04  +1.28580000E-04  +1.17280000E-04
   -6.27900000E-05  -9.00200000E-05  -1.09500000E-04  +3.32606000E-03  +3.84282000E-03
   +1.08512000E-03  -1.86278860E-01  -1.29910160E-01  -3.87322700E-02  -1.97380000E-04
   -1.60600000E-04  -6.30800000E-05  +4.19900000E-05  +4.05100000E-05  +8.65500000E-05
   +1.70670000E-04  +9.71700000E-05  -2.41100000E-05  +1.42200000E-05  +1.30800000E-05
   +4.20900000E-05  -1.28110000E-04  +3.96300000E-05  +2.40900000E-05  +7.37200000E-05
   +1.74000000E-04  -2.57500000E-05  -8.08650000E-04  +7.35240000E-04  +7.27200000E-04
   -4.34900000E-05  +2.08800000E-05  +2.26500000E-05  +1.47300000E-05  -4.04500000E-05
   -8.69000000E-06  +9.66900000E-05  -4.68400000E-05  -1.89600000E-05  +3.29000000E-04
   +4.98000000E-04  -1.09160000E-04  +2.10800000E-05  +2.51500000E-05  +2.37500000E-05
   -2.05300000E-05  -4.42000000E-06  -1.34200000E-05  -8.30600000E-05  +2.58000000E-05
   +3.26000000E-06  -3.44600000E-05  +1.85800000E-05  +5.51300000E-05  -1.08900000E-05
   +1.57000000E-06  +4.70000000E-07  -1.84880900E-02  -1.88287300E-02  -6.45314000E-03
   +2.01775090E-01  -2.73220000E-04  -6.28000000E-04  -7.83600000E-04  +1.45078000E-03
   -3.62396000E-03  +3.64917000E-03  -1.92700000E-04  -7.06600000E-05  +3.33250000E-04
   +1.93800000E-05  -4.61000000E-06  +9.97800000E-05  +3.56950000E-04  +1.54400000E-04
   +3.48660000E-04  -5.61240000E-04  -2.26500000E-05  -6.78200000E-05  -2.01004000E-02
   -1.78359900E-02  -5.61189000E-03  -1.27726840E-01  -1.65395450E-01  -3.51212700E-02
   -5.06320000E-04  -3.85010000E-04  -1.89970000E-04  -1.16436000E-03  -5.39900000E-05
   +2.63250000E-04  +2.68100000E-04  +7.26640000E-04  +4.21050000E-04  +8.40400000E-05
   -2.98880000E-04  +9.67700000E-05  +3.72900000E-05  +9.34500000E-05  -3.11000000E-05
   +2.87930000E-04  +2.64580000E-04  -2.10410000E-04  +4.96320000E-04  +7.34100000E-05
   +2.16110000E-04  +5.08300000E-05  +5.42400000E-05  -2.60790000E-04  +2.20500000E-05
   +2.98670000E-04  -4.90600000E-05  -1.77740000E-04  +1.05570000E-04  -4.00200000E-05
   -5.75190000E-04  +6.35080000E-04  -1.77412000E-03  +3.59500000E-05  +2.28800000E-05
   +5.62200000E-05  -4.09800000E-05  -3.11000000E-05  -4.51600000E-05  +2.14500000E-05
   +1.86850000E-04  +1.75200000E-05  +7.46800000E-05  -1.07230000E-04  +9.10800000E-05
   -1.32840000E-04  -2.37700000E-05  -2.06500000E-05  +9.59010000E-03  +9.36787000E-03
   +3.23423000E-03  +1.40550090E-01  +1.80109440E-01  +6.34270000E-04  +5.24900000E-04
   +1.91910000E-04  -1.43129000E-03  +2.11193000E-03  -1.82461000E-03  -1.05000000E-05
   -4.56290000E-04  -3.45550000E-04  +4.11680000E-04  -5.51500000E-05  +1.07180000E-04
   -2.14840000E-04  -9.71800000E-05  +1.91020000E-04  +9.29400000E-05  -3.09330000E-04
   -4.44000000E-05  +1.24611900E-02  +1.15431700E-02  +1.64827000E-03  -3.84325400E-02
   -3.65081500E-02  -5.85746700E-02  +1.49200000E-04  +1.95040000E-04  +8.03200000E-05
   +1.16800000E-04  -6.70330000E-04  +2.41870000E-04  +5.94700000E-05  +1.91790000E-04
   -2.54800000E-05  +3.56000000E-05  -4.83500000E-05  -1.86300000E-05  -5.97200000E-05
   -3.56100000E-05  +4.17200000E-05  -4.40200000E-05  +2.39990000E-04  -1.38750000E-04
   +9.02500000E-05  -6.41690000E-04  +5.63740000E-04  +4.90900000E-05  -4.95400000E-05
   -1.53440000E-04  +2.51000000E-06  +1.23100000E-05  -1.46100000E-05  +6.23000000E-06
   +3.92200000E-05  -1.89300000E-05  +1.02190000E-03  +1.13459000E-03  +6.45410000E-04
   +9.96000000E-06  +9.64000000E-06  -2.77500000E-05  +2.60900000E-05  -3.40000000E-07
   +1.54000000E-06  -2.93200000E-04  +3.69290000E-04  +4.12050000E-04  -5.82400000E-05
   +1.31690000E-04  +1.57000000E-05  +3.33400000E-05  +4.40700000E-05  +2.61000000E-06
   +6.74165000E-03  +7.07911000E-03  +1.15966000E-03  +4.19293100E-02  +3.66348900E-02
   +6.20537600E-02  -1.17930000E-04  -1.47180000E-04  -2.53000000E-06  -9.78200000E-05
   +2.63830000E-04  +5.38020000E-04  -2.88700000E-04  -4.82800000E-04  +1.89420000E-04
   -2.12860000E-04  -1.41600000E-05  -2.88700000E-05  -3.29900000E-05  -4.41100000E-05
   -1.40020000E-04  +1.41960000E-04  +8.61700000E-05  +5.49000000E-05  -1.83030000E-03
   -1.59896000E-03  -4.71434000E-03  -4.61053100E-02  -1.18804000E-03  -6.06413000E-03
   +6.05700000E-05  +5.27500000E-05  +9.90000000E-06  +5.48250000E-04  -3.49400000E-05
   -4.09300000E-04  -9.43800000E-05  -2.99370000E-04  -2.29590000E-04  -5.55200000E-05
   +1.43520000E-04  -6.60200000E-05  -3.90900000E-05  -1.72700000E-05  -2.17400000E-05
   -4.02100000E-05  -1.95820000E-04  +2.19840000E-04  -7.26970000E-04  +7.88320000E-04
   -2.33000000E-04  -9.45700000E-05  -6.70500000E-05  +2.18140000E-04  -4.81000000E-06
   -1.62820000E-04  +3.97100000E-05  +1.40310000E-04  -1.00700000E-04  +2.84400000E-05
   -3.25850000E-04  +1.08173000E-03  -4.14780000E-04  -1.24500000E-05  -2.51600000E-05
   -1.30000000E-06  +1.93900000E-05  -2.26400000E-05  +5.31000000E-06  +4.41320000E-04
   -7.69460000E-04  -1.33570000E-04  +1.91000000E-06  +1.86300000E-05  -3.57700000E-05
   -9.20000000E-07  +9.07000000E-06  -5.06000000E-06  +1.51170000E-03  +4.51558000E-03
   +2.85274700E-02  -1.34670000E-04  -3.13400000E-03  -2.32996700E-02  +4.80254300E-02
   -4.37280000E-04  -5.86600000E-05  +1.05290000E-04  +6.99320000E-04  +1.46049000E-03
   -1.54500000E-04  -4.70580000E-04  -1.01257000E-03  +6.68490000E-04  -1.71260000E-04
   -1.07650000E-04  -3.03900000E-04  -2.47200000E-05  +7.21500000E-05  -3.45490000E-04
   +2.86760000E-04  +1.79210000E-04  +1.79040000E-04  -5.82500000E-05  +5.87789000E-03
   +2.61604900E-02  -1.80068000E-03  -5.53006600E-02  -4.63455200E-02  +1.50270000E-04
   +8.59000000E-05  +2.70200000E-05  -6.04020000E-04  +1.07977000E-03  -1.75300000E-04
   -2.88670000E-04  -6.59400000E-05  +7.40200000E-05  -1.58200000E-05  -1.47100000E-05
   +2.85300000E-05  +8.27200000E-05  +6.86100000E-05  -3.52800000E-05  +1.09940000E-04
   -1.65900000E-04  -1.96400000E-05  +5.65130000E-04  +2.91070000E-04  -5.00800000E-04
   +6.62700000E-05  -8.84200000E-05  -8.57900000E-05  -3.20000000E-07  +2.64600000E-05
   -2.31300000E-05  -8.22200000E-05  +7.80000000E-06  -9.74000000E-06  +6.10480000E-04
   -4.56972000E-03  +2.43958000E-03  -2.95000000E-05  -1.35500000E-05  -1.52900000E-05
   -5.40000000E-07  -3.00600000E-05  +1.83000000E-05  -6.82210000E-04  -2.10681000E-03
   -5.85670000E-04  +9.08800000E-05  +5.42200000E-05  -4.94200000E-05  +2.78700000E-05
   -2.09700000E-05  +3.45000000E-06  -1.33987000E-03  -2.81118000E-03  -1.16466200E-02
   +1.20388000E-03  -3.57746000E-03  -2.09132100E-02  +1.19598000E-03  +6.01626100E-02
   +4.92010000E-04  +3.17300000E-04  -2.13990000E-04  -1.16983000E-03  -6.98770000E-04
   +8.49800000E-05  -3.45900000E-05  -1.31323000E-03  -5.72010000E-04  +3.88940000E-04
   +9.07500000E-05  +3.86870000E-04  -2.07600000E-04  +6.77000000E-06  +3.62070000E-04
   -2.82900000E-04  -2.72510000E-04  -9.98700000E-05  +1.52400000E-04  -4.46414000E-03
   -1.49429400E-02  -6.43013000E-03  -4.36404500E-02  -3.11611280E-01  -1.68700000E-05
   +2.70000000E-05  +3.84800000E-05  +1.20651000E-03  +9.15800000E-05  -1.55750000E-04
   -4.93900000E-05  -3.92650000E-04  -1.10240000E-04  -4.57600000E-05  +1.26180000E-04
   -3.90200000E-05  +8.51700000E-05  -8.94600000E-05  -1.67000000E-06  -1.24160000E-04
   -1.55970000E-04  +4.99210000E-04  +8.66160000E-04  +2.22100000E-04  +2.04400000E-04
   -1.39060000E-04  +2.70640000E-04  +3.43710000E-04  -1.44000000E-05  -4.67000000E-05
   +5.45000000E-05  -1.04300000E-05  -6.89400000E-05  +2.68800000E-05  -4.50480000E-04
   +4.56151000E-03  -1.69250000E-03  +2.44200000E-05  +1.54600000E-05  -7.02000000E-06
   +5.08800000E-05  -1.11800000E-05  -7.24000000E-06  -5.10520000E-04  -5.50600000E-04
   +9.07690000E-04  -1.12520000E-04  -9.60100000E-05  +7.53900000E-05  +2.34000000E-06
   +2.06600000E-05  -3.18000000E-06  -7.85790000E-04  -1.31785000E-03  -7.28762000E-03
   +6.22970000E-04  -6.18420000E-04  -4.89879000E-03  +6.43723000E-03  +4.94247600E-02
   +3.38613380E-01  -6.81820000E-04  -2.30570000E-04  -1.20493000E-03  +8.72800000E-05
   +3.63600000E-04  +2.27400000E-04  -1.04220000E-04  -1.02770000E-04  -2.43000000E-05
   +1.01960000E-04  +1.35260000E-04  +8.66500000E-05  -3.16700000E-05  -6.08900000E-05
   +2.07300000E-05  -4.53900000E-05  -4.61400000E-05  +2.45550000E-04  -1.88062000E-03
   +8.77060000E-04  -5.33110000E-04  -1.30560000E-04  -2.72280000E-04  -6.41970000E-04
   +8.64100000E-05  +8.10000000E-05  +7.54100000E-05  +1.50480000E-04  -8.20440000E-04
   +7.60000000E-05  -4.36430000E-04  +1.46480000E-04  +4.29780000E-04  +3.56700000E-05
   +1.34410000E-04  +4.56900000E-05  -9.20700000E-05  -1.69900000E-05  +4.30800000E-05
   +2.38000000E-06  +1.70500000E-05  +9.08000000E-06  +3.12000000E-06  +2.27510000E-04
   -1.53430000E-04  -6.42560000E-04  +1.83163000E-03  +3.19130000E-04  +5.30000000E-06
   -1.49960000E-04  -4.28400000E-05  +9.40800000E-05  -2.14100000E-05  -4.26600000E-05
   -4.93024800E-02  +1.25791400E-02  -1.10952300E-02  -6.78000000E-06  -8.03000000E-06
   -5.25000000E-06  +1.56000000E-05  +2.56000000E-06  +1.56400000E-05  +5.89000000E-06
   +2.35200000E-05  +7.68700000E-05  -2.83747000E-03  -1.64634000E-03  -6.95700000E-04
   -1.90000000E-05  +3.22000000E-06  -1.89000000E-05  +4.37710000E-04  -4.02880000E-04
   +1.38040000E-04  +1.46600000E-04  +4.19190000E-04  -2.94400000E-05  +7.28520000E-04
   +2.07930000E-04  -1.67870000E-04  +5.36905000E-02  -1.27511000E-03  -6.26010000E-04
   +6.88300000E-05  -4.00160000E-04  +8.59300000E-05  +5.54710000E-04  +1.58760000E-04
   +6.33300000E-05  -6.08600000E-05  +1.04080000E-04  +4.33100000E-05  -3.42200000E-05
   -1.39280000E-04  -1.28400000E-04  +1.37740000E-04  +8.17400000E-05  -6.21300000E-05
   -4.11350000E-04  -3.62230000E-04  +8.71744000E-03  -6.33407000E-03  -3.28740000E-04
   +1.00000000E-06  -1.28465000E-03  +6.61800000E-05  +6.10700000E-05  -4.59600000E-05
   -2.28000000E-04  +6.97500000E-04  +9.52680000E-04  +2.23900000E-04  +7.53400000E-05
   -4.49320000E-04  +1.00720000E-04  -2.13860000E-04  +1.64640000E-04  +1.46390000E-04
   +4.99200000E-05  -5.75300000E-05  +8.03900000E-05  -6.25200000E-05  -4.05200000E-05
   -8.93800000E-05  -6.93000000E-05  +2.05420000E-04  +2.68056000E-03  -6.46731000E-03
   -9.17760000E-04  -4.57600000E-05  +1.81210000E-04  -3.97600000E-05  -1.87600000E-04
   +5.77700000E-05  +1.73000000E-06  +1.37127100E-02  -2.09777380E-01  +1.38507770E-01
   -2.10200000E-05  -1.15800000E-05  -1.08100000E-05  +1.34500000E-05  +1.48200000E-05
   +1.37000000E-06  -9.12000000E-06  +1.26300000E-05  -3.04100000E-05  -1.90990000E-03
   -4.64010000E-04  -8.68930000E-04  -5.63000000E-06  +2.42000000E-05  +1.41900000E-05
   -2.46620000E-04  +5.75200000E-05  -1.67210000E-04  +2.15180000E-04  +1.64490000E-04
   -2.16510000E-04  -1.20340000E-04  +6.07210000E-04  -3.38570000E-04  -1.59123400E-02
   +2.33231640E-01  +2.22360000E-04  -4.89800000E-05  -2.50310000E-04  +8.07300000E-04
   +8.76700000E-04  +1.13606000E-03  -1.51000000E-06  -2.58900000E-04  -2.07830000E-04
   +1.61490000E-04  +1.05890000E-04  +1.02230000E-04  -4.36000000E-06  +7.03100000E-05
   +1.45890000E-04  -2.11880000E-04  -1.88790000E-04  +3.21720000E-04  -2.18942000E-03
   +2.49786100E-02  -1.63326300E-02  +1.10230000E-04  -3.19629000E-03  -6.51120000E-03
   -2.21700000E-05  -3.11200000E-05  +3.99300000E-05  -8.06720000E-04  +8.38170000E-04
   +8.08870000E-04  +1.18741000E-03  -3.31920000E-04  -2.23189000E-03  -1.59600000E-04
   -1.40710000E-04  +2.07640000E-04  -5.16800000E-05  +5.71800000E-05  -4.07400000E-05
   -1.15010000E-04  -4.12800000E-05  +5.28800000E-05  +2.10260000E-04  -1.67660000E-04
   +4.55900000E-05  -1.42857000E-03  +3.30524000E-03  +2.23742000E-03  -6.96400000E-05
   -1.01460000E-04  +1.06890000E-04  +1.95500000E-05  -6.85300000E-05  +1.08020000E-04
   -1.11907700E-02  +1.34017370E-01  -1.60198540E-01  +9.00000000E-07  +1.27300000E-05
   +7.80000000E-07  -1.87200000E-05  +1.02200000E-05  -8.51000000E-06  -4.57000000E-06
   +1.32350000E-04  +1.27360000E-04  -9.81340000E-04  -3.96800000E-04  +4.81320000E-04
   -2.70000000E-05  -2.41800000E-05  -1.80100000E-05  -1.08810000E-04  -1.79860000E-04
   +1.83250000E-04  +1.90820000E-04  -1.94280000E-04  +2.44160000E-04  -3.87770000E-04
   +1.81372000E-03  -1.31201000E-03  +1.31289100E-02  -1.49294490E-01  +1.72461160E-01
   +9.57300000E-05  -1.04720000E-04  +2.44590000E-04  +7.01090000E-04  +5.38700000E-05
   -1.78850000E-04  +2.75560000E-04  -3.85100000E-05  +4.09410000E-04  -1.74910000E-04
   -1.10680000E-04  -6.13900000E-05  +1.59840000E-04  +1.24910000E-04  -1.05830000E-04
   +1.91460000E-04  +2.78600000E-05  -6.15900000E-05  -1.42085000E-03  -4.18400000E-05
   +7.59260000E-04  -2.45820000E-04  -1.05400000E-04  +4.08430000E-04  -1.76100000E-04
   -1.34810000E-04  -6.78400000E-05  +4.47820000E-04  +9.50140000E-04  +5.48140000E-04
   +1.05590000E-04  -9.24300000E-05  +5.62300000E-05  -2.56100000E-05  +3.02300000E-05
   +1.22800000E-05  -4.85300000E-05  +1.41700000E-05  +1.73200000E-05  -5.29400000E-05
   +4.51000000E-06  -1.24870000E-04  +3.79880000E-04  -1.11010000E-04  -5.92500000E-05
   -9.58000000E-06  -9.26800000E-05  -1.13040000E-04  +3.87500000E-05  -2.06000000E-05
   -5.74000000E-06  +5.96000000E-05  -1.79200000E-05  -7.54000000E-06  -2.19332700E-01
   -1.26748400E-01  -2.67251100E-02  +1.81600000E-05  +2.11200000E-05  +1.87900000E-05
   -4.94000000E-05  +1.34200000E-05  -1.34500000E-05  +6.48400000E-05  +4.63000000E-06
   -7.82200000E-05  -1.40940000E-04  +2.12750000E-04  -3.10260000E-04  +1.63000000E-06
   -1.75000000E-05  +8.80000000E-06  +4.01000000E-06  -1.54620000E-04  -1.24500000E-05
   +3.33160000E-04  +4.17130000E-04  -4.24700000E-04  +2.61050000E-04  +2.94080000E-04
   +8.48800000E-05  +3.09235000E-03  +2.75144000E-03  +8.79070000E-04  +2.34921430E-01
   -5.83000000E-05  +1.77520000E-04  -9.07000000E-06  +3.99140000E-04  +1.19750000E-04
   -1.82312000E-03  -5.64760000E-04  -2.72980000E-04  +1.73500000E-04  -6.68000000E-06
   -7.49600000E-05  -2.31120000E-04  +1.38290000E-04  +4.98700000E-05  +6.93200000E-05
   -4.34700000E-05  +7.09000000E-06  -2.17480000E-04  -8.09018000E-03  -7.48655000E-03
   -1.23308000E-03  +7.11690000E-04  +3.13470000E-04  +1.09352000E-03  -1.86790000E-04
   -1.52470000E-04  -8.48400000E-05  -7.61670000E-04  -1.08190000E-04  +4.45740000E-04
   +1.71570000E-04  +4.64500000E-05  +3.81020000E-04  -9.60400000E-05  -1.72810000E-04
   -1.07160000E-04  +1.18500000E-04  -8.26600000E-05  -8.24000000E-06  +5.21600000E-05
   +3.85000000E-05  -1.28150000E-04  +4.84730000E-04  +2.24310000E-04  +7.11000000E-05
   +6.86640000E-04  -4.14920000E-04  -4.33690000E-04  +8.40700000E-05  +1.51300000E-04
   +3.02000000E-06  -1.44390000E-04  +9.81900000E-05  +7.06000000E-06  -1.26448870E-01
   -1.40099690E-01  -1.80604200E-02  +1.79000000E-05  +1.81300000E-05  +1.84400000E-05
   -4.67500000E-05  -6.51900000E-05  -2.94300000E-05  +2.36000000E-06  +4.66300000E-05
   -6.64800000E-05  +3.70090000E-04  +4.07000000E-06  -1.51430000E-04  -3.51200000E-05
   -2.33000000E-06  +5.42000000E-06  +1.05270000E-04  +3.96100000E-05  -1.30700000E-05
   +1.07900000E-05  +4.66820000E-04  +4.07870000E-04  +1.94490000E-04  -1.18300000E-05
   -5.50200000E-05  -2.02685400E-02  -1.33508800E-02  -3.99365000E-03  +1.39004850E-01
   +1.49524520E-01  +6.20320000E-04  +5.92760000E-04  -8.40720000E-04  +1.17634000E-03
   -4.11530000E-04  -6.10221000E-03  -1.47731000E-03  -1.37923000E-03  +1.56590000E-04
   -9.82300000E-05  +3.90000000E-06  -4.50690000E-04  +2.37070000E-04  +1.25980000E-04
   -1.81100000E-05  -1.45500000E-04  -8.33900000E-05  +3.15140000E-04  -2.51640000E-02
   -1.87918300E-02  -6.14907000E-03  -9.39910000E-04  -1.44001000E-03  +9.99060000E-04
   -1.85230000E-04  -1.55440000E-04  +1.02500000E-05  -1.29891000E-03  -1.91470000E-04
   +1.50552000E-03  +2.28260000E-04  +2.81070000E-04  +1.67040000E-04  -3.59000000E-05
   -2.48230000E-04  +1.60810000E-04  +1.79010000E-04  -7.00000000E-07  -1.72100000E-05
   +1.36340000E-04  -1.65900000E-05  -1.72640000E-04  +3.07420000E-04  +4.52260000E-04
   +1.70360000E-04  -2.21730000E-04  +1.08420000E-04  +1.02520000E-04  +3.87700000E-05
   +1.56170000E-04  -6.38800000E-05  -2.85210000E-04  +1.30820000E-04  -3.53500000E-05
   -2.43977700E-02  -1.64712600E-02  -4.92093000E-02  +2.80600000E-05  +2.92800000E-05
   +2.08300000E-05  -1.56280000E-04  -8.61100000E-05  -5.41400000E-05  +3.42400000E-05
   -1.36300000E-05  +3.61000000E-06  +1.13000000E-05  +8.39000000E-05  +5.23180000E-04
   -4.22300000E-05  -2.18800000E-05  -9.30000000E-06  +9.68500000E-05  +7.58500000E-05
   -6.26100000E-05  +1.43270000E-04  +7.94070000E-04  -6.56080000E-04  +3.50310000E-04
   +8.71300000E-05  +3.06020000E-04  +1.78973000E-02  +1.06481500E-02  +2.79174000E-03
   +2.80686700E-02  +2.11629700E-02  +5.68833700E-02  +4.63900000E-05  -3.88850000E-04
   +2.39860000E-04  +3.86360000E-04  -2.36120000E-04  -3.18200000E-05  +1.59980000E-04
   +1.32700000E-04  +6.27300000E-05  +3.30600000E-05  -6.78000000E-06  -2.08100000E-05
   -1.00040000E-04  -1.21100000E-05  +1.44700000E-05  +5.02800000E-05  +1.90700000E-05
   -6.46000000E-05  +3.78120000E-04  -1.15530000E-03  -1.08950000E-03  +3.00490000E-04
   -1.79570000E-04  -9.13530000E-04  +8.68100000E-05  +5.66900000E-05  +9.72000000E-06
   +5.66830000E-04  +2.31230000E-04  +7.05110000E-04  +1.10820000E-04  -3.13000000E-04
   +8.06100000E-05  -5.93300000E-05  -2.48180000E-04  +3.62400000E-05  +3.05080000E-04
   -1.04500000E-04  +8.67000000E-06  -6.57000000E-06  +5.64900000E-05  -1.01240000E-04
   +5.74460000E-04  +3.19770000E-04  -4.55000000E-06  +1.16030000E-04  +1.41530000E-04
   -1.25500000E-04  +2.24000000E-05  +2.32780000E-04  -1.26500000E-05  -3.61300000E-04
   +1.64260000E-04  -3.12000000E-06  -2.25047250E-01  +1.14908130E-01  +4.70054400E-02
   -1.41700000E-05  -3.30000000E-07  -8.58000000E-06  +6.61000000E-06  +2.43700000E-05
   +8.04000000E-06  -2.04100000E-05  +3.43000000E-06  -4.13000000E-06  -1.60560000E-04
   -3.37100000E-04  -2.02910000E-04  +2.75100000E-05  -1.55000000E-06  +5.24000000E-06
   +4.99110000E-04  -2.39250000E-04  +7.67300000E-05  -2.63600000E-04  +1.03580000E-04
   +1.22820000E-04  +2.90010000E-04  -2.80320000E-04  -9.88200000E-05  -1.04964000E-03
   -3.46730000E-04  -3.18900000E-05  -1.94224400E-02  +1.47212000E-02  +4.96920000E-03
   +2.42630920E-01  -7.49500000E-05  +1.76820000E-04  -5.66290000E-04  +7.50710000E-04
   +2.28270000E-04  +2.69770000E-04  -3.25490000E-04  -1.19480000E-04  -2.38750000E-04
   +1.63680000E-04  +2.05810000E-04  +5.73000000E-05  -4.54700000E-05  -8.31800000E-05
   +1.20890000E-04  -2.64150000E-04  -4.60300000E-05  +2.04380000E-04  +8.60474000E-03
   -6.33944000E-03  -1.92262000E-03  -2.89450000E-04  +2.49650000E-04  +1.70729000E-03
   +8.76400000E-05  +7.79600000E-05  +6.92400000E-05  -8.82180000E-04  +3.35450000E-04
   -1.87360000E-03  -2.89790000E-04  -3.04600000E-05  +6.38690000E-04  +1.03400000E-04
   +2.59920000E-04  -5.14800000E-05  -1.96590000E-04  +4.49500000E-05  -1.24800000E-05
   +1.99810000E-04  +4.60700000E-05  +3.63000000E-06  +1.80890000E-04  -2.07600000E-04
   +4.42900000E-05  +6.05170000E-04  -1.91035000E-03  -7.36910000E-04  +7.82000000E-06
   -1.46820000E-04  -2.88000000E-06  +2.45050000E-04  -1.11310000E-04  -5.29300000E-05
   +1.14609310E-01  -1.21451880E-01  -3.00130100E-02  -2.02000000E-06  -1.58300000E-05
   -8.53000000E-06  +2.02500000E-05  -1.67500000E-05  +1.02300000E-05  +3.02200000E-05
   -1.20700000E-05  +8.62400000E-05  +3.36200000E-05  -9.54360000E-04  +3.13980000E-04
   -1.06200000E-05  -2.07900000E-05  -1.75300000E-05  -1.70580000E-04  +5.86650000E-04
   +3.94440000E-04  -1.60090000E-04  -2.84200000E-05  -1.10740000E-04  -2.78060000E-04
   -8.34900000E-05  +2.32200000E-05  +2.05897000E-02  -1.20598900E-02  -6.16314000E-03
   -1.61421600E-02  +1.13985200E-02  +4.59033000E-03  -1.26729730E-01  +1.29240010E-01
   -1.15400000E-04  -1.40160000E-04  +3.28700000E-04  +4.65800000E-04  +5.71820000E-04
   +1.08300000E-03  -3.04480000E-04  +1.63660000E-04  -3.11200000E-04  +1.88660000E-04
   +1.65840000E-04  -1.36600000E-05  -1.36170000E-04  -5.93500000E-05  +2.23700000E-04
   -1.80170000E-04  -1.04980000E-04  -1.16270000E-04  +2.58410600E-02  -1.57364400E-02
   -8.14763000E-03  +1.55667000E-03  -1.34002000E-03  +6.75080000E-04  +7.86800000E-05
   +6.87000000E-05  -1.40000000E-06  -1.66282000E-03  -8.06010000E-04  -5.70342000E-03
   +3.25450000E-04  +1.10440000E-04  -1.23901000E-03  +7.63100000E-05  +2.70790000E-04
   +9.30900000E-05  -3.72640000E-04  +2.30550000E-04  -1.13770000E-04  +4.44760000E-04
   +1.69660000E-04  +3.65020000E-04  +6.93760000E-04  -7.64220000E-04  +2.52500000E-05
   -7.25090000E-04  +1.22326000E-03  +1.05916000E-03  -8.09800000E-05  -2.14660000E-04
   +1.09920000E-04  +5.13800000E-04  -3.06910000E-04  +2.42100000E-05  +4.54205000E-02
   -2.88848700E-02  -5.90212700E-02  -6.17000000E-06  -1.97500000E-05  -1.11300000E-05
   +4.16400000E-05  -2.83000000E-05  +3.71000000E-06  +5.06900000E-05  -4.39800000E-05
   +1.91700000E-05  -1.42650000E-04  -1.50140000E-04  -3.54100000E-05  +1.53500000E-05
   -2.39900000E-05  -2.41000000E-06  -6.98260000E-04  +6.01610000E-04  -9.24120000E-04
   -3.06000000E-06  +1.41740000E-04  -2.03300000E-05  -2.62190000E-04  +1.84000000E-06
   +4.85710000E-04  -1.78992500E-02  +9.54953000E-03  +4.74768000E-03  -3.15082000E-03
   +2.63326000E-03  -1.00450000E-04  -5.08422300E-02  +3.34256800E-02  +6.66559400E-02
   -3.85100000E-05  -1.17400000E-05  -4.19300000E-05  -3.18130000E-04  +1.99100000E-04
   +1.21780000E-04  -2.45200000E-05  +2.40000000E-06  +2.36720000E-04  -1.49000000E-06
   +2.13700000E-05  -8.61500000E-05  -2.06200000E-05  +1.02000000E-06  -1.34000000E-06
   +3.83400000E-05  -7.22000000E-06  -4.90000000E-06  -8.58280000E-04  -1.37684000E-03
   -2.28130000E-03  -3.10021000E-03  +1.29379000E-03  +2.18487000E-03  +3.62800000E-05
   +2.67000000E-05  -6.94000000E-06  +7.96165000E-03  -1.71554300E-02  +9.25282000E-03
   -1.45890000E-03  +2.46988000E-03  +3.31354000E-03  -2.48760000E-04  -7.13010000E-04
   -6.02900000E-05  -3.17120000E-03  +9.24150000E-04  +2.34227000E-03  -4.97036000E-03
   +2.28444700E-02  -1.49758700E-02  -6.77615900E-02  +6.88195100E-02  -2.85635300E-02
   +3.21290000E-04  -1.55844000E-03  +1.96594000E-03  +2.27580000E-04  +4.53140000E-04
   -1.09290000E-04  -3.66240000E-04  +1.68847000E-03  -4.30270000E-04  +5.07190000E-04
   +8.78600000E-05  -1.97740000E-04  -1.06200000E-05  -1.06200000E-05  -1.22000000E-06
   +9.90000000E-07  -3.99000000E-06  +5.70000000E-06  -1.42300000E-05  -5.84800000E-05
   -1.04330000E-04  +5.50000000E-06  -3.27000000E-06  -1.54500000E-05  +6.21000000E-06
   -7.24000000E-06  -3.40000000E-06  -1.12700000E-04  -3.20090000E-04  -1.55790000E-04
   -9.34540000E-04  +6.11730000E-04  +3.98810000E-04  -2.14854000E-03  +7.75090000E-04
   +9.74000000E-06  +8.54000000E-06  -2.19600000E-05  -1.46420000E-04  +5.44300000E-05
   -2.73800000E-05  -1.79700000E-05  -2.58700000E-05  -4.33200000E-05  -9.27300000E-05
   +7.64214700E-02  -1.31200000E-04  -8.13000000E-05  -1.12140000E-04  -3.10670000E-04
   +3.73420000E-04  +4.45510000E-04  -8.09700000E-05  -1.40090000E-04  +2.63630000E-04
   +1.01400000E-05  -3.25000000E-06  -1.08330000E-04  +2.01100000E-05  +4.12200000E-05
   +4.16600000E-05  +1.37800000E-05  -4.17800000E-05  -2.82500000E-05  -6.10890000E-04
   -2.68621000E-03  -2.17485000E-03  +3.44836000E-03  -5.22710000E-04  -9.32010000E-04
   -3.50400000E-05  -3.08200000E-05  -4.20500000E-05  +2.12603000E-03  -9.41628000E-03
   +6.87931000E-03  -3.69840000E-04  +5.30804000E-03  +3.00860000E-03  +4.64810000E-04
   -6.14490000E-04  -7.94690000E-04  +2.03790000E-03  +1.73072000E-03  -1.10234000E-03
   +1.11355000E-03  -8.49762000E-03  +6.22200000E-03  +6.79802600E-02  -2.46098090E-01
   +1.32908440E-01  +1.99020000E-04  -1.10024000E-03  +1.35030000E-03  -2.22780000E-04
   +3.93980000E-04  +1.17050000E-04  +6.89060000E-04  -7.50280000E-04  +6.54530000E-04
   +4.62190000E-04  -1.74380000E-04  -2.85200000E-04  -9.50000000E-06  -6.49000000E-06
   +1.02200000E-05  -1.36100000E-05  -1.62600000E-05  -1.66000000E-06  -1.84350000E-04
   -7.48600000E-05  -6.76900000E-05  +1.39100000E-05  +1.71800000E-05  -2.29400000E-05
   -5.46000000E-06  -1.67100000E-05  -5.20000000E-06  +3.03870000E-04  +1.66410000E-04
   -7.45830000E-04  +1.47164000E-03  -4.89780000E-04  -6.05920000E-04  +2.48900000E-04
   -3.22200000E-05  -8.22840000E-04  +7.91000000E-06  -1.85500000E-05  -4.03400000E-05
   +3.28700000E-05  +2.57000000E-06  -1.12100000E-05  -8.15400000E-05  +3.37900000E-05
   -1.31830000E-04  -7.83574700E-02  +2.62113270E-01  -1.00340000E-04  -1.35770000E-04
   -1.31730000E-04  -3.26620000E-04  +2.74230000E-04  +5.24330000E-04  +5.59600000E-05
   -1.29490000E-04  +7.91900000E-05  +1.69600000E-05  -8.01200000E-05  -2.06600000E-05
   +3.01000000E-05  +7.00500000E-05  +4.88600000E-05  -2.47900000E-05  -7.46500000E-05
   -2.00100000E-05  -3.34375000E-03  -1.09976000E-03  -2.74645000E-03  +3.88040000E-04
   +3.95750000E-04  +4.97000000E-04  -8.27000000E-05  -8.47100000E-05  -4.41600000E-05
   -8.00414000E-03  +1.74740200E-02  -6.68686000E-03  +3.36609000E-03  +2.91693000E-03
   +1.17271000E-03  +8.45780000E-04  -1.59964000E-03  -1.11657000E-03  +2.19187000E-03
   +3.48880000E-04  +2.20430000E-04  +2.96715000E-03  -8.55780000E-03  +4.97097000E-03
   -2.61262900E-02  +1.33357190E-01  -1.14470970E-01  +1.10368000E-03  +1.39246000E-03
   -7.54000000E-06  -3.05530000E-04  +8.31600000E-04  +2.64070000E-04  +4.90010000E-04
   -2.50360000E-04  +7.30500000E-04  +8.33210000E-04  -2.62460000E-04  -1.96120000E-04
   -9.16000000E-06  +1.17100000E-05  +1.17800000E-05  -2.18300000E-05  -3.36000000E-06
   -9.80000000E-06  -1.18800000E-04  +5.40900000E-05  -1.40000000E-06  -7.56000000E-06
   +3.67600000E-05  -3.02000000E-06  -2.28900000E-05  -1.11200000E-05  -3.35000000E-06
   -5.70660000E-04  -3.78760000E-04  +1.37790000E-04  +6.12180000E-04  -1.22856000E-03
   -7.60620000E-04  -2.87750000E-04  +1.73780000E-04  +5.20750000E-04  -5.58100000E-05
   -3.00200000E-05  +1.18260000E-04  +2.70000000E-05  +1.23700000E-05  -9.68200000E-05
   +2.93500000E-05  -6.59200000E-05  -2.71770000E-04  +2.76531100E-02  -1.42876050E-01
   +1.17312420E-01  -4.37200000E-05  -4.18000000E-05  -4.39100000E-05  -9.85000000E-06
   +2.34620000E-04  +1.10690000E-04  -2.25800000E-05  -2.82000000E-05  +3.31400000E-05
   -2.13200000E-05  -3.51200000E-05  +8.09000000E-06  +6.92500000E-05  +4.70400000E-05
   +2.42900000E-05  -7.29000000E-06  -2.97400000E-05  -2.08000000E-05  -7.38500000E-05
   -7.07990000E-04  +8.77730000E-04  +2.63100000E-05  -1.21870000E-04  +2.88900000E-05
   -9.08100000E-05  -7.49100000E-05  -3.53000000E-05  -3.39329000E-03  +3.85916000E-03
   +7.52700000E-04  +7.21260000E-04  +5.78100000E-04  -2.22810000E-04  +6.65420000E-04
   +3.26618000E-03  +2.42803000E-03  +8.17043000E-03  +5.71478000E-03  -5.53148000E-03
   -1.56671280E-01  -7.06230400E-02  +1.20065860E-01  -1.04270400E-02  -1.41830700E-02
   +1.68649000E-02  -1.40000000E-04  -2.72700000E-04  -5.34800000E-05  +6.31960000E-04
   +1.11671000E-03  -7.22750000E-04  +1.88660000E-04  -1.94379000E-03  -1.81260000E-03
   -3.05410000E-04  +1.16420000E-04  -2.78800000E-05  +6.13000000E-06  +8.94000000E-06
   +1.31400000E-05  -1.76000000E-05  -9.43000000E-06  -9.82000000E-06  +9.58000000E-06
   +1.83900000E-05  +2.31700000E-05  +6.07000000E-06  +1.78300000E-05  -4.21000000E-06
   -8.54000000E-06  -7.80000000E-06  +3.30000000E-07  -1.55900000E-05  +4.99400000E-05
   -1.50200000E-05  +2.40200000E-05  +1.40200000E-05  +1.98500000E-05  -1.49800000E-05
   +9.90000000E-07  -3.11000000E-05  +4.13000000E-06  -7.53000000E-06  +3.15000000E-06
   +1.99700000E-05  -7.76000000E-06  -1.02300000E-05  -3.73100000E-05  +6.79200000E-05
   +1.24180000E-04  +5.16280000E-04  -2.92870000E-04  -9.85390000E-04  +1.60494940E-01
   +1.50700000E-05  +2.39200000E-05  -7.05000000E-06  +4.77200000E-05  -1.20170000E-04
   -4.54900000E-05  +3.76000000E-06  -1.58000000E-06  +3.19300000E-05  -9.69000000E-06
   +1.13000000E-05  -4.31000000E-06  +3.61000000E-06  +5.48000000E-06  +2.93000000E-06
   -8.10000000E-06  +2.15100000E-05  -3.55000000E-06  +3.61380000E-04  +3.26390000E-04
   -3.34220000E-04  -5.94800000E-05  +5.55400000E-05  -1.62000000E-06  +5.87000000E-06
   +1.70000000E-06  -1.50000000E-06  +3.37327000E-03  -2.05070000E-04  +2.57210000E-04
   +5.16420000E-04  -4.93470000E-04  -2.68430000E-04  +4.70035000E-03  -7.00020000E-04
   +5.66769000E-03  -1.91326000E-02  -7.19464000E-03  +2.03509800E-02  -6.88196100E-02
   -1.07156930E-01  +9.07756500E-02  +8.37857000E-03  +8.96937000E-03  -1.02111600E-02
   -4.06360000E-04  +9.94300000E-05  -3.53600000E-05  +1.13780000E-04  +5.54940000E-04
   -5.08520000E-04  -1.43206000E-03  +4.40500000E-05  -3.51987000E-03  +7.49600000E-05
   -7.17000000E-06  +3.78500000E-05  +5.20000000E-07  +1.15000000E-06  +1.78000000E-06
   -2.65000000E-06  -1.74000000E-06  -1.40000000E-07  +6.78000000E-06  +4.58000000E-06
   +7.29000000E-06  +1.10200000E-05  -8.78000000E-06  -5.41000000E-06  +4.23000000E-06
   -1.90000000E-07  -4.50000000E-07  -7.21000000E-06  -1.44100000E-05  +1.20200000E-05
   -3.02000000E-06  -2.76800000E-05  -1.31100000E-05  +9.02000000E-06  +8.83000000E-06
   +2.22100000E-05  +7.10000000E-06  -3.35000000E-06  -1.57600000E-05  -1.03300000E-05
   -5.08000000E-06  -4.69000000E-06  -2.73000000E-06  -2.61000000E-06  -3.40900000E-05
   -8.85830000E-04  +1.64600000E-04  -5.84850000E-04  +7.39746000E-02  +1.06441190E-01
   +1.21000000E-05  -2.01000000E-06  +9.05000000E-06  +5.19800000E-05  -8.99500000E-05
   -3.79600000E-05  +2.14600000E-05  -1.41200000E-05  +1.86500000E-05  +5.25000000E-06
   -3.42000000E-06  -2.48000000E-05  -5.87400000E-05  -3.87000000E-05  -1.78700000E-05
   +4.07000000E-06  +1.50300000E-05  +2.05900000E-05  +5.31900000E-05  +1.85080000E-04
   +5.72200000E-05  +3.38000000E-05  +1.22600000E-05  -3.82300000E-05  +6.99700000E-05
   +4.80800000E-05  +1.90200000E-05  +1.34806000E-03  +2.19570000E-04  +1.99103000E-03
   +2.93980000E-04  +2.48110000E-04  +5.63680000E-04  +1.23102000E-03  +4.04245000E-03
   +5.61626000E-03  +1.20316700E-02  +6.48689000E-03  -5.41518000E-03  +1.17234010E-01
   +9.20585600E-02  -1.72060850E-01  +1.50250000E-03  +2.63560000E-03  -1.41711000E-03
   -1.73000000E-04  -1.08300000E-04  -3.97180000E-04  +6.17360000E-04  +2.15893000E-03
   -1.09035000E-03  -1.32477000E-03  -3.38013000E-03  -2.27403000E-03  +5.64800000E-05
   +2.98000000E-05  +3.38600000E-05  -1.34200000E-05  -5.10000000E-06  -7.12000000E-06
   -1.02000000E-06  +3.90000000E-06  +3.69000000E-06  -7.50000000E-06  +3.42000000E-06
   -4.09000000E-06  -1.40000000E-06  +6.00000000E-08  -8.20000000E-07  +1.85000000E-06
   +4.69000000E-06  -1.64000000E-06  +1.85700000E-05  -1.63600000E-05  +2.60000000E-07
   +7.96000000E-06  -1.14000000E-06  +1.80000000E-06  -1.44900000E-05  +1.19700000E-05
   -3.74000000E-06  -9.89000000E-06  +9.64000000E-06  -4.46000000E-06  -1.13900000E-05
   -2.14000000E-06  +5.67000000E-06  +2.68000000E-06  +8.90000000E-07  -1.40600000E-05
   -4.82870000E-04  -1.05082000E-03  -4.92180000E-04  -1.31846410E-01  -1.02073400E-01
   +1.75168060E-01  +6.02700000E-05  +3.07000000E-05  -1.03880000E-04  +2.00280000E-04
   +1.31610000E-04  +5.05000000E-05  -4.08100000E-05  +3.84900000E-05  +5.86000000E-06
   +9.07000000E-06  +3.69100000E-05  +4.75700000E-05  +9.41200000E-05  +4.15800000E-05
   +3.62800000E-05  -3.63000000E-05  -3.18900000E-05  -2.44500000E-05  -1.12060000E-04
   +5.74640000E-04  -4.42750000E-04  -2.45950000E-04  +1.59220000E-04  +1.35000000E-04
   -1.05250000E-04  -7.48800000E-05  -2.33100000E-05  -2.64678000E-03  -4.34411000E-03
   +1.55495000E-03  -1.79224800E-02  +8.68142000E-03  -2.27840600E-02  -1.08596340E-01
   +7.55682000E-03  -9.22938400E-02  +1.00647900E-02  +4.56080000E-04  +1.38713000E-02
   -1.43132000E-03  -1.68546000E-03  +1.60831000E-03  +3.20800000E-04  +2.04039000E-03
   -6.35130000E-04  +3.99706000E-03  +2.06560000E-04  -7.13690000E-04  +1.15200000E-04
   -4.73339000E-03  -6.01875000E-03  +3.67656000E-03  -8.02310000E-04  -1.54300000E-04
   +3.09700000E-05  -2.67300000E-05  -2.01790000E-04  +1.70300000E-05  +9.46000000E-06
   +9.88000000E-06  +2.80000000E-07  -8.15000000E-06  -4.88000000E-06  +2.45400000E-05
   -8.00000000E-08  +2.05300000E-05  -1.91200000E-05  +1.40200000E-05  +2.44600000E-05
   -1.46600000E-05  -5.67000000E-06  +8.30000000E-07  -1.96700000E-05  +1.15780000E-04
   -1.11300000E-05  +1.93400000E-05  +1.98000000E-06  -2.39100000E-05  +1.17600000E-05
   -2.46900000E-05  +4.35700000E-05  -3.40000000E-05  -5.01400000E-05  +1.06130000E-04
   +2.66600000E-05  +5.30400000E-05  -6.77000000E-06  +2.58900000E-05  -1.63800000E-05
   +5.91000000E-05  -3.99400000E-05  -1.99320000E-04  -2.40140000E-04  -2.83930000E-04
   -9.97710000E-04  -6.48050000E-04  +1.14334260E-01  -2.61400000E-05  -2.51200000E-05
   +8.63600000E-05  -8.85700000E-05  -2.97700000E-05  -4.88900000E-05  +2.16300000E-05
   -4.09100000E-05  -3.73300000E-05  +2.42000000E-05  -1.89700000E-05  -6.12000000E-05
   -1.65360000E-04  -1.02610000E-04  -4.90400000E-05  +3.61200000E-05  +1.63500000E-05
   +4.47800000E-05  +8.28000000E-06  +1.17320000E-04  +3.60600000E-04  +9.90800000E-05
   -8.40900000E-05  -3.36000000E-05  +1.72180000E-04  +1.36930000E-04  +5.02500000E-05
   -1.39847000E-03  -3.88620000E-04  +3.96460000E-04  +1.65835300E-02  +4.98363000E-03
   +1.41043500E-02  +8.11803000E-03  -3.22876900E-02  +1.97684500E-02  +6.55548000E-03
   -5.45351000E-03  +2.08764700E-02  -4.51067000E-03  +4.42516000E-03  +8.54770000E-04
   +3.07918000E-03  -1.82637000E-03  -1.76856000E-03  -3.60437000E-03  -8.30560000E-04
   -1.43090000E-04  -1.60757900E-02  -2.40452000E-02  -3.67161500E-02  +2.72000000E-04
   +2.83730000E-04  -2.62931000E-03  +3.83700000E-05  +4.06900000E-05  +7.15200000E-05
   -2.69600000E-05  -2.26600000E-05  -1.99000000E-05  +7.48000000E-06  +1.10000000E-05
   +1.14300000E-05  -4.55800000E-05  -7.91000000E-06  -2.84000000E-05  -7.41000000E-06
   -1.57000000E-06  -6.00000000E-06  +1.16500000E-05  +8.62000000E-06  -4.02000000E-06
   +2.34500000E-05  -5.60500000E-05  -1.99400000E-05  -2.30500000E-05  +2.00300000E-05
   +1.03400000E-05  -8.25000000E-06  +1.82000000E-05  -4.20800000E-05  -2.08300000E-05
   +6.62000000E-05  -4.28200000E-05  -2.12400000E-05  -2.41100000E-05  +2.98400000E-05
   +1.43100000E-05  -1.46800000E-05  -2.61900000E-05  +2.03370000E-04  +1.99390000E-04
   +2.98220000E-04  -5.03450000E-04  -7.42480000E-04  -6.53550000E-04  -7.88451000E-03
   +6.42982200E-02  +3.08700000E-05  -7.10000000E-07  -7.80100000E-05  +1.94300000E-05
   +9.66000000E-06  +1.15140000E-04  -5.14100000E-05  -1.73300000E-05  -5.78900000E-05
   -2.86800000E-05  +7.45500000E-05  +7.95100000E-05  +1.32040000E-04  +1.17380000E-04
   +5.49800000E-05  -5.03600000E-05  -4.93000000E-05  -4.85900000E-05  +2.03160000E-04
   -3.16720000E-04  -5.63750000E-04  -9.37100000E-05  +3.75000000E-05  +5.74300000E-05
   -1.53140000E-04  -1.15780000E-04  -3.55800000E-05  +4.05120000E-04  +1.98523000E-03
   -1.97671000E-03  -4.29410000E-04  -4.62390000E-04  -6.07690000E-04  -9.13817400E-02
   +1.36740900E-02  -2.11646120E-01  -9.96086000E-03  +1.10457300E-02  -2.14025200E-02
   +5.29476000E-03  -3.70341000E-03  -2.14436000E-03  -3.55759000E-03  +6.89160000E-04
   +1.59566000E-03  +3.88913000E-03  +7.47130000E-04  +8.55676000E-03  -6.76324000E-03
   -1.24798000E-02  -1.38864900E-02  +4.02720000E-04  -5.67670000E-04  +3.11708000E-03
   -4.48700000E-05  -1.21500000E-05  -3.12200000E-05  +3.60100000E-05  +1.43500000E-05
   +1.50900000E-05  +8.39000000E-06  -1.57200000E-05  -4.92000000E-06  +5.84000000E-05
   -6.28000000E-06  +4.57600000E-05  -6.37000000E-06  +1.07800000E-05  +1.72900000E-05
   -1.22600000E-05  -1.10800000E-05  +2.13000000E-06  -5.54200000E-05  +3.92400000E-05
   +2.64700000E-05  +1.68300000E-05  -3.70900000E-05  -1.71600000E-05  +3.77900000E-05
   -2.84000000E-05  +5.85000000E-05  -3.35600000E-05  -7.13900000E-05  +5.92500000E-05
   +1.42900000E-05  +4.04300000E-05  -5.51000000E-05  -1.26500000E-05  +1.74800000E-05
   +6.17400000E-05  -1.09850000E-04  -2.30600000E-05  -1.13000000E-05  +3.30930000E-04
   +1.13824000E-03  +5.10600000E-04  +1.05232510E-01  -8.01515000E-03  +2.39296410E-01
   -5.88520000E-04  -3.01490000E-04  +6.39200000E-04  +1.43418000E-03  +1.83493000E-03
   +8.86880000E-04  +3.93410000E-04  +2.74020000E-04  -9.29260000E-04  +1.51990000E-04
   -1.67646000E-03  -3.71690000E-04  -8.95750000E-04  -6.01300000E-04  +9.61600000E-05
   -1.40000000E-06  -4.34840000E-04  +7.78100000E-05  +1.16509000E-03  +1.29946000E-03
   +8.50610000E-04  -9.79930000E-04  +1.06230000E-04  -3.37100000E-05  +3.56460000E-04
   -8.85000000E-06  +1.58000000E-06  -1.05132000E-03  -2.07706500E-02  +9.43632000E-03
   +1.38189800E-02  +3.72837300E-02  +1.40499300E-02  -1.18318100E-02  +9.18317000E-03
   -4.57000000E-03  -5.49212000E-03  -3.01707000E-03  +3.33014000E-03  -5.57588000E-03
   +4.90433000E-03  +5.07950000E-04  +8.16312000E-03  +4.55131000E-03  -9.25534000E-03
   -3.03317000E-03  -4.39057000E-03  +2.81966000E-03  -2.02367000E-03  -1.16519200E-02
   -2.97550000E-04  +3.97354000E-03  -1.27577000E-03  +2.80720000E-04  -8.25330000E-04
   +1.10730000E-04  -2.25320000E-04  -3.27920000E-04  +6.41000000E-05  -8.50800000E-05
   -1.86280000E-04  +1.91420000E-04  -1.08710000E-04  +1.78500000E-04  +4.07460000E-04
   +1.14000000E-04  +1.34200000E-04  +1.56130000E-04  -1.70910000E-04  -7.59800000E-05
   +2.32800000E-05  -8.33000000E-06  -2.70020000E-04  +3.54790000E-04  +7.35100000E-05
   -1.05730000E-04  -4.66250000E-04  -7.48300000E-05  +2.57220000E-04  +8.27400000E-05
   +2.12400000E-05  +2.96580000E-04  -1.23000000E-04  +3.32200000E-05  -6.74300000E-05
   -3.02890000E-04  -2.42410000E-04  -1.54170000E-04  +3.08610000E-04  +2.99250000E-04
   +5.85400000E-05  -2.54550000E-04  -7.18460000E-04  -1.57700000E-05  +1.71270000E-04
   -2.32920000E-04  -1.82730000E-04  -2.08930000E-03  +1.94255000E-03  +8.88972400E-02
   +9.25900000E-05  +1.19740000E-04  +1.12390000E-04  +2.19815000E-03  +4.05010000E-04
   +3.17000000E-06  +1.34996000E-03  -3.00000000E-08  +1.15310000E-04  +9.01820000E-04
   -1.79654000E-03  -5.56650000E-04  -2.71020000E-04  -7.23080000E-04  +6.70640000E-04
   -9.64500000E-05  -7.80050000E-04  +1.04010000E-04  +1.13444000E-03  +7.45200000E-04
   +5.41730000E-04  -9.08200000E-04  +8.88700000E-05  +1.47990000E-04  -3.38990000E-04
   -5.73310000E-04  -2.23530000E-04  -5.33071000E-03  -2.72892000E-02  +6.48761000E-03
   +3.62428700E-02  +2.47956800E-02  +1.38261400E-02  -8.36845000E-03  +1.99732700E-02
   +2.96104000E-03  -5.85443000E-03  -4.50359000E-03  +3.41803000E-03  -6.26155000E-03
   +5.62568000E-03  -3.39320000E-04  +8.82565000E-03  +3.33295000E-03  -8.63592000E-03
   -4.58969000E-03  -5.64505000E-03  +2.37035000E-03  -1.82514000E-03  -1.63306500E-02
   -7.56400000E-05  +4.05986000E-03  -1.04768000E-03  +8.08400000E-05  -7.50010000E-04
   +1.62500000E-04  -2.60250000E-04  -3.56330000E-04  +1.96890000E-04  -4.38900000E-05
   -3.88910000E-04  +2.70100000E-04  -2.40030000E-04  +1.75610000E-04  +1.71660000E-04
   +2.80960000E-04  +1.16010000E-04  +1.22680000E-04  -1.02890000E-04  -1.72600000E-04
   +5.09000000E-05  +9.80000000E-07  -2.52960000E-04  +3.75620000E-04  +3.69000000E-05
   -4.71000000E-05  -3.45410000E-04  -7.83200000E-05  +2.23660000E-04  +4.69800000E-05
   -8.84000000E-06  +2.79080000E-04  -1.38430000E-04  +1.91800000E-05  -4.22700000E-05
   -2.44930000E-04  -1.77500000E-04  -1.96060000E-04  +2.92970000E-04  +3.09890000E-04
   +4.36200000E-04  +2.32810000E-04  -2.07520000E-04  -1.24000000E-05  +1.72280000E-04
   -2.49060000E-04  +2.13530000E-03  -4.05516000E-03  +1.88922000E-03  +3.28460900E-02
   +1.53762530E-01  -3.04940000E-04  +2.03600000E-05  +9.44400000E-05  +7.94560000E-04
   +5.95370000E-04  +3.93510000E-04  +4.59410000E-04  +1.05060000E-04  +2.36740000E-04
   +1.83200000E-05  -1.18349000E-03  -3.70090000E-04  -2.30590000E-04  -3.53350000E-04
   +2.02000000E-05  +2.81560000E-04  +2.77000000E-06  +4.12600000E-05  +3.98020000E-04
   +4.90170000E-04  +6.10510000E-04  -4.77150000E-04  +1.21780000E-04  -1.80000000E-07
   -1.26900000E-05  -1.57470000E-04  -9.62600000E-05  -1.68326000E-03  -1.49350000E-02
   +6.19580000E-03  +2.38245800E-02  +2.78562900E-02  -2.75870000E-04  -4.82871000E-03
   +9.94428000E-03  +3.35230000E-04  -4.66417000E-03  -3.59310000E-03  +2.42545000E-03
   -5.69925000E-03  +5.14452000E-03  -1.18560000E-04  +8.22945000E-03  +4.32632000E-03
   -7.31711000E-03  -6.42615000E-03  -7.32245000E-03  -1.06973700E-02  -9.32190000E-04
   -8.47841000E-03  +3.50930000E-04  +2.57055000E-03  -7.61900000E-04  +2.78990000E-04
   -3.64130000E-04  +4.43500000E-05  -7.14600000E-05  -2.01850000E-04  +4.79400000E-05
   -2.38500000E-05  -1.91230000E-04  +1.20410000E-04  -9.29800000E-05  +6.62300000E-05
   +5.16820000E-04  -1.65600000E-04  +9.23000000E-05  +4.38500000E-05  -1.30570000E-04
   -5.51300000E-05  +6.22000000E-06  -5.21000000E-06  -1.62540000E-04  +1.49330000E-04
   +4.06900000E-05  -5.45800000E-05  -2.73680000E-04  -6.68700000E-05  +1.51760000E-04
   +7.04700000E-05  +1.38900000E-05  +9.31900000E-05  -4.42700000E-05  -4.59100000E-05
   -2.12000000E-05  -1.40920000E-04  -1.35590000E-04  -7.34100000E-05  +1.62100000E-04
   +1.33750000E-04  +1.44720000E-04  -1.24300000E-04  -2.36980000E-04  -7.59200000E-05
   +1.01260000E-04  -2.24280000E-04  +8.01120000E-04  -2.66633000E-03  +1.36688000E-03
   +4.09841000E-03  -1.40247000E-03  +4.77633500E-02  +3.37000000E-06  -2.61100000E-05
   +2.11200000E-05  -2.02700000E-05  -8.19000000E-06  -2.58000000E-06  +4.58000000E-05
   -2.60300000E-05  -8.96000000E-06  +5.36800000E-05  -4.45300000E-05  -4.87200000E-05
   -1.51730000E-04  -1.10330000E-04  -3.03100000E-05  +1.93700000E-05  -2.22900000E-05
   +4.75600000E-05  -1.10590000E-04  -7.37000000E-05  +5.96300000E-05  +4.54000000E-05
   -1.28500000E-05  -1.85600000E-05  +1.51280000E-04  +1.01050000E-04  +4.38500000E-05
   -7.45000000E-06  +4.54060000E-04  -5.23090000E-04  +8.01290000E-04  -4.67540000E-04
   -1.82310000E-04  -2.05458000E-03  +6.40173000E-03  +2.26985000E-03  -8.15368000E-03
   +4.62434100E-02  -1.43956400E-02  -7.00655000E-03  +1.93391000E-03  +2.98469000E-03
   +4.37060000E-04  +6.06480000E-04  -1.06349000E-03  +5.59460000E-04  -1.83680000E-04
   -1.05770000E-04  +4.98826000E-03  -1.68131000E-03  -3.09579000E-03  -4.11771500E-02
   -3.45298000E-02  +2.15164500E-02  +2.25500000E-05  +7.54000000E-06  -7.60000000E-07
   -3.93600000E-05  -1.08600000E-05  -1.89900000E-05  -6.94000000E-06  +1.76100000E-05
   +5.42000000E-06  -2.25300000E-05  +1.84500000E-05  -1.40000000E-05  -2.30100000E-05
   +1.61600000E-05  +7.52000000E-06  -6.75000000E-06  +1.15300000E-05  -3.38000000E-06
   +1.92300000E-05  -2.52800000E-05  +1.30500000E-05  -1.58200000E-05  -2.70000000E-06
   -8.84000000E-06  +5.60000000E-07  +1.11800000E-05  +1.45000000E-05  -2.45700000E-05
   +2.70600000E-05  +3.60600000E-05  -1.39500000E-05  -6.50000000E-07  +1.10000000E-05
   +2.72800000E-05  -2.57300000E-05  -2.79000000E-06  -3.86300000E-04  +1.61350000E-04
   +1.42420000E-04  +1.42660000E-04  -6.38800000E-05  +1.75770000E-04  -1.91250000E-04
   -4.76790000E-04  +1.80100000E-05  -3.32400000E-04  -1.33090000E-04  -1.34960000E-04
   +5.48147400E-02  -3.22000000E-06  -1.29000000E-06  -3.01500000E-05  -3.50000000E-07
   +9.86900000E-05  +6.54800000E-05  -1.05600000E-05  -8.87000000E-06  -5.50000000E-07
   -7.31000000E-06  -3.01100000E-05  +2.24000000E-05  +9.92000000E-05  +7.28100000E-05
   +5.39700000E-05  -2.33700000E-05  -4.33100000E-05  -3.83300000E-05  +1.38300000E-04
   -1.75440000E-04  -1.44020000E-04  -3.71300000E-05  -9.32000000E-06  +2.82100000E-05
   -1.21620000E-04  -1.14330000E-04  -4.24200000E-05  +1.43130000E-04  +1.38180000E-03
   -7.81800000E-04  +2.32070000E-04  -2.58382000E-03  -4.65630000E-04  -3.67740000E-03
   +4.53161000E-03  +1.64441000E-03  +5.27877000E-03  -2.00301700E-02  +5.48535000E-03
   +1.89382000E-03  +7.31420000E-04  -1.61110000E-03  -6.47190000E-04  +3.49180000E-04
   +1.97758000E-03  -5.01560000E-04  -2.82450000E-04  +6.49440000E-04  +2.22063000E-03
   -2.06460000E-03  -1.24529000E-03  +1.33937800E-02  -4.82023680E-01  +1.36998950E-01
   -7.84400000E-05  +3.78400000E-05  -8.04000000E-06  +9.60000000E-06  +2.31600000E-05
   +1.25900000E-05  -1.40200000E-05  -6.50000000E-07  -1.35600000E-05  +2.78800000E-05
   +8.64000000E-06  +2.53200000E-05  +1.20200000E-05  +1.29300000E-05  -5.49000000E-06
   -1.15500000E-05  -4.86000000E-06  +3.40000000E-06  -2.73600000E-05  +2.44800000E-05
   +4.37000000E-06  +6.24000000E-06  -2.51600000E-05  +1.90000000E-07  +1.41000000E-05
   -5.55000000E-06  -3.87000000E-06  +1.53600000E-05  -1.47300000E-05  +7.60000000E-07
   +2.83000000E-06  -2.69800000E-05  -2.61100000E-05  -4.01500000E-05  +2.53300000E-05
   +3.55700000E-05  +3.79200000E-05  +3.74600000E-05  -4.66800000E-05  -2.36940000E-04
   -9.01200000E-05  -4.86410000E-04  +2.47220000E-04  +8.61200000E-05  -8.00220000E-04
   +5.48080000E-04  +8.49650000E-04  +4.41520000E-04  -1.72530500E-02  +4.99631330E-01
   -7.31000000E-06  +6.16000000E-06  +4.40800000E-05  +6.75100000E-05  -8.20200000E-05
   -7.31000000E-05  +1.07200000E-05  +2.77300000E-05  +2.31000000E-05  -7.46000000E-06
   +1.95000000E-06  -1.06300000E-05  -1.75800000E-05  -2.48700000E-05  -3.52400000E-05
   +2.60800000E-05  +4.97700000E-05  +1.42800000E-05  -2.79970000E-04  +2.35610000E-04
   +6.04400000E-05  +1.24800000E-05  +4.16500000E-05  -2.93900000E-05  +4.11100000E-05
   +4.01100000E-05  +8.29000000E-06  -1.15950000E-04  -2.80073000E-03  +1.20350000E-03
   -1.06246000E-03  +1.68901000E-03  -3.11400000E-05  +3.96780000E-03  -3.33907000E-03
   +1.70443000E-03  -2.52640000E-03  -6.61427000E-03  -7.77930000E-04  +2.43150000E-04
   +4.06200000E-05  +1.55072000E-03  +1.68593000E-03  +1.64024000E-03  -4.27110000E-04
   -4.98720000E-04  +3.69690000E-04  -1.02020000E-04  -1.31452000E-03  +5.15620000E-04
   -2.26374000E-03  +9.05971000E-03  +1.50496570E-01  -5.15239800E-02  +1.64600000E-04
   -8.31500000E-05  +1.25000000E-05  -5.06000000E-06  -4.92000000E-06  +5.60000000E-07
   +4.00000000E-08  +2.40000000E-07  +3.20000000E-06  -2.18000000E-05  +2.12000000E-06
   -2.12800000E-05  +8.39000000E-06  -1.87600000E-05  -9.22000000E-06  +1.08100000E-05
   +5.11000000E-06  -5.90000000E-07  +1.06300000E-05  -2.18800000E-05  -8.10000000E-06
   -1.57000000E-05  +5.44000000E-06  -5.49000000E-06  -8.48000000E-06  +1.07200000E-05
   -1.27100000E-05  +1.46400000E-05  +1.31600000E-05  -3.71600000E-05  +3.23000000E-06
   +1.23900000E-05  +3.81300000E-05  +3.15600000E-05  -7.76000000E-06  -8.68000000E-05
   +3.97000000E-05  +1.22200000E-05  +3.54100000E-05  -1.34460000E-04  -4.90220000E-04
   -3.45700000E-04  -2.56750000E-04  -1.11830000E-04  -1.36995000E-03  -2.40980000E-04
   -8.55600000E-05  -8.56900000E-05  -8.07902000E-03  -1.41503610E-01  +5.21342000E-02
   +2.70300000E-05  -3.26200000E-05  -4.46630000E-04  -2.03160000E-04  -8.57100000E-05
   +1.25030000E-04  +4.07000000E-05  +3.73200000E-05  +3.43400000E-05  -3.88600000E-05
   +1.02250000E-04  +7.17500000E-05  -3.27100000E-05  +5.10000000E-06  -8.33000000E-05
   +2.13900000E-05  +6.12700000E-05  +1.97940000E-04  +1.11240000E-04  -4.58280000E-04
   -6.14600000E-04  -1.48700000E-05  +2.61140000E-04  +4.48080000E-04  +8.69700000E-05
   +8.60800000E-05  +6.93000000E-05  -3.42820000E-04  +3.81010000E-04  -1.01659000E-03
   +7.86120000E-03  +8.16200000E-03  +1.23767400E-02  +4.87654000E-03  +6.93600000E-05
   +8.03202000E-03  -4.69700000E-05  +3.23610000E-04  -9.27950000E-04  +7.37180000E-04
   -8.83830000E-04  -2.47860000E-04  -1.23720000E-03  +1.11650000E-04  +4.48840000E-04
   -1.61640630E-01  -1.45414010E-01  -1.85677700E-01  -1.11888000E-03  -2.80870000E-04
   -1.80697000E-03  -9.06600000E-05  +3.58250000E-04  -1.32100000E-05  +5.73950000E-04
   +1.12451000E-03  -1.31859000E-03  +6.06000000E-06  -1.66500000E-05  -8.52000000E-06
   +3.15700000E-05  -2.72000000E-06  +2.18200000E-05  +3.30800000E-05  -2.75100000E-05
   +3.03900000E-05  -2.66130000E-04  -2.94800000E-05  +4.47700000E-05  -1.55000000E-06
   -1.60400000E-05  -1.66000000E-05  -7.92300000E-05  +4.57000000E-05  -2.91300000E-05
   +2.36600000E-05  -5.85000000E-06  -6.19800000E-05  +4.26400000E-05  -1.15440000E-04
   +2.17090000E-04  -1.62738000E-03  +1.35478000E-03  +9.22520000E-04  -4.21400000E-05
   -3.09350000E-04  +9.89900000E-05  +6.32900000E-05  -6.21280000E-04  +5.78660000E-04
   -1.97300000E-05  +1.35800000E-05  +8.46800000E-05  +1.93700000E-05  +1.11420000E-04
   +4.04400000E-05  -1.42093000E-03  -1.09660000E-04  -3.37066000E-03  +5.42650000E-04
   +4.15360000E-04  +8.15550000E-04  -1.78800000E-04  +7.23000000E-05  +1.90610000E-04
   +1.54149670E-01  -2.53000000E-06  -6.85600000E-05  +1.19170000E-04  +2.10560000E-04
   +2.83200000E-05  -8.16300000E-05  -9.44600000E-05  -9.80200000E-05  -3.94700000E-05
   +4.88000000E-06  -5.63600000E-05  -1.61000000E-05  +7.04100000E-05  +5.15800000E-05
   +5.43100000E-05  +1.26000000E-06  -3.05700000E-05  -1.10340000E-04  +1.84800000E-04
   +3.51290000E-04  +7.37260000E-04  +2.05300000E-05  -1.43300000E-04  -2.87480000E-04
   -1.16440000E-04  -1.10100000E-04  -4.65300000E-05  +4.30950000E-04  +2.31052000E-03
   +1.82579000E-03  +8.13458000E-03  +6.65516000E-03  +7.83093000E-03  -7.44080000E-04
   +6.13200000E-05  +2.45130000E-04  -2.95260000E-04  +9.68750000E-04  +3.62720000E-04
   -2.72870000E-04  -2.85790000E-04  +4.72560000E-04  -9.78320000E-04  -7.23120000E-04
   -4.85140000E-04  -1.42284300E-01  -1.36460070E-01  -1.63985890E-01  +3.30790000E-04
   -6.75100000E-04  +4.81900000E-05  +2.81820000E-04  -4.98490000E-04  +2.63080000E-04
   -2.35330000E-04  -1.01649000E-03  +1.24169000E-03  +6.13000000E-06  +2.00800000E-05
   +9.08000000E-06  -2.34300000E-05  -6.17000000E-06  -1.65300000E-05  -6.10000000E-07
   +3.59800000E-05  +4.90000000E-06  +1.15060000E-04  +1.28590000E-04  -4.80000000E-05
   -2.93700000E-05  +1.27000000E-06  +1.84000000E-06  +3.46000000E-05  -5.98300000E-05
   +3.16700000E-05  -2.62000000E-05  -4.81800000E-05  +5.57100000E-05  +9.69000000E-06
   +5.60100000E-05  -1.66040000E-04  +1.99425000E-03  -5.58200000E-04  -9.52180000E-04
   -2.80500000E-05  -3.71600000E-04  +6.06000000E-05  -2.33920000E-04  +4.23430000E-04
   -6.10090000E-04  -1.72260000E-04  -1.87440000E-04  -9.03000000E-05  +2.07900000E-05
   -8.29000000E-05  -3.34900000E-05  +1.14137000E-03  -5.53800000E-04  -4.00890000E-04
   -9.01500000E-05  -6.44800000E-05  +8.58300000E-05  +8.48000000E-05  -3.55000000E-06
   -1.89950000E-04  +1.34806900E-01  +1.31458590E-01  +1.11220000E-04  +3.04900000E-05
   +2.42200000E-05  -4.91000000E-06  -5.97000000E-05  +1.21080000E-04  -3.71900000E-05
   -7.95200000E-05  -2.25080000E-04  +1.42480000E-04  +1.16540000E-04  -3.50000000E-07
   -1.83630000E-04  -1.07430000E-04  +5.96800000E-05  -5.38200000E-05  -1.36320000E-04
   +2.23000000E-06  -3.83530000E-04  +2.84940000E-04  -6.36880000E-04  +3.13200000E-05
   +8.70000000E-05  +5.41700000E-05  +1.56710000E-04  +1.14840000E-04  +4.69500000E-05
   -2.05406000E-03  -4.27377000E-03  +5.84930000E-04  -8.09669000E-03  -6.24516000E-03
   -3.44118100E-02  -6.96760000E-04  +1.17535000E-03  +2.53364000E-03  -1.62213000E-03
   +6.75870000E-04  +1.21269000E-03  -2.13146000E-03  +9.95970000E-04  +1.30410000E-04
   +2.58131000E-03  +1.63202000E-03  -1.76688000E-03  -1.62692730E-01  -1.46335060E-01
   -2.61145770E-01  -2.48060000E-04  -2.13220000E-03  +3.00760000E-04  +3.79420000E-04
   -5.55180000E-04  +4.62460000E-04  +2.61540000E-04  -2.59700000E-04  -9.46100000E-05
   -2.84500000E-05  -1.19700000E-05  -1.95400000E-05  +1.56500000E-05  +1.26100000E-05
   +8.58000000E-06  +3.56800000E-05  -2.61000000E-06  +1.97300000E-05  -5.67100000E-05
   +9.27000000E-06  +9.35900000E-05  +2.61000000E-06  +1.58600000E-05  +3.09000000E-06
   -3.91100000E-05  -3.74100000E-05  +3.17200000E-05  -8.73000000E-06  -5.92100000E-05
   -2.79600000E-05  +7.17300000E-05  -4.09200000E-05  +6.70100000E-05  -1.95540000E-04
   -8.64500000E-05  +7.17350000E-04  -3.22500000E-05  +9.48500000E-05  -3.53900000E-05
   +1.44880000E-04  -1.89570000E-04  +1.78320000E-04  +1.19050000E-04  +4.04500000E-05
   +4.57660000E-04  -7.42000000E-05  -7.49500000E-05  -1.27500000E-04  +1.94334000E-03
   -2.36816000E-03  -3.54720000E-04  +1.59062000E-03  +1.33654000E-03  -2.16598000E-03
   +7.54100000E-05  +3.08700000E-05  -1.28470000E-04  +1.71370080E-01  +1.58299880E-01
   +2.92410110E-01  -2.99900000E-05  -3.37600000E-05  +2.25700000E-05  +4.25700000E-05
   +8.08900000E-05  +4.85900000E-05  +1.15580000E-04  -1.94500000E-05  +8.22000000E-06
   +1.02720000E-04  -1.93360000E-04  -9.19800000E-05  -1.66070000E-04  -1.55070000E-04
   +2.47800000E-05  +1.51600000E-05  -5.57800000E-05  +5.17100000E-05  +1.73220000E-04
   -1.13320000E-04  -7.01500000E-05  -2.31000000E-05  -4.92600000E-05  +1.21300000E-05
   +1.18200000E-04  +6.02300000E-05  +2.16500000E-05  +1.71460000E-04  +3.25326000E-03
   -1.26977000E-03  -4.92840000E-04  -3.12858000E-03  -4.49070000E-04  +6.13410000E-04
   -2.07800000E-03  -4.09190000E-04  +3.00969000E-03  -1.01511000E-03  -6.61330000E-04
   +1.13428000E-03  -3.77200000E-04  -4.04160000E-04  -1.25521000E-03  -7.28300000E-04
   +1.59066000E-03  -3.71540000E-04  -8.39700000E-05  +3.43340000E-04  -7.61519200E-02
   -1.14684000E-02  -1.70673870E-01  -2.92013000E-03  +1.80443000E-03  +7.50530000E-04
   -8.74300000E-05  +2.86800000E-05  +1.76500000E-05  -5.51900000E-05  -1.70000000E-07
   -1.91100000E-05  -3.24300000E-05  +3.11300000E-05  -1.14700000E-05  +9.50000000E-07
   +4.83400000E-05  -1.70000000E-06  -2.15000000E-06  +1.80800000E-05  -9.62000000E-06
   -1.12400000E-05  +6.03000000E-06  -5.04000000E-06  -4.47000000E-06  +1.17800000E-05
   -2.31000000E-06  -1.04400000E-05  -2.97500000E-05  +2.92000000E-06  +1.18400000E-05
   +1.02600000E-05  -1.15600000E-05  -7.00000000E-07  +1.13600000E-05  +1.73700000E-05
   -2.01300000E-05  -2.56300000E-05  -1.99700000E-05  -1.26400000E-05  +8.67000000E-06
   +3.54600000E-05  -5.42000000E-05  +1.01750000E-04  +1.02370000E-04  -8.88600000E-05
   -3.10500000E-05  -6.25200000E-05  +9.75020000E-04  -5.90480000E-04  -2.10640000E-04
   -2.26660000E-04  +4.17156000E-03  +2.26867000E-03  -1.92447000E-03  -1.07725000E-03
   -1.50811000E-03  -7.08300000E-05  -2.34200000E-05  -8.89200000E-05  +7.76739900E-02
   +6.05000000E-06  +8.81000000E-06  -3.68000000E-05  +3.90800000E-05  +1.12140000E-04
   +7.67200000E-05  +9.84000000E-06  +1.75300000E-05  -3.44900000E-05  -9.51000000E-06
   -6.67900000E-05  +4.73400000E-05  +1.52890000E-04  +1.14840000E-04  +8.60900000E-05
   -4.20600000E-05  -5.71400000E-05  -5.19500000E-05  +2.16210000E-04  -6.86200000E-05
   -7.85500000E-05  -9.47600000E-05  +2.79000000E-06  +3.12700000E-05  -1.79720000E-04
   -1.83740000E-04  -6.58500000E-05  -1.09250000E-04  +5.28840000E-04  -3.97870000E-04
   +1.13894000E-03  +1.03379000E-03  +8.00740000E-04  -1.59963900E-02  -3.98835000E-03
   -3.68696400E-02  -3.29280000E-04  +2.99519000E-03  +7.81390000E-04  +1.49185000E-03
   -9.42380000E-04  +4.78230000E-04  -7.73060000E-04  -1.21310000E-04  +3.12760000E-04
   -1.90500000E-05  -8.88300000E-05  +1.37130000E-03  -1.60570000E-04  -4.59701300E-02
   -9.10600000E-04  -4.12740000E-04  -3.23830000E-04  -1.29940000E-04  -1.17820000E-04
   +3.22800000E-05  -2.79900000E-05  +5.54000000E-06  +4.39400000E-05  +1.87900000E-05
   -2.10700000E-05  +7.07000000E-06  -2.39100000E-05  +4.59300000E-05  -6.09000000E-06
   +4.54900000E-05  +1.45600000E-05  +1.03900000E-05  -5.02000000E-06  -1.37100000E-05
   -4.67000000E-06  +5.54000000E-06  -4.57200000E-05  +4.00800000E-05  +8.89000000E-06
   +5.01000000E-06  -3.77300000E-05  -6.83000000E-06  +3.12800000E-05  -8.97000000E-06
   +9.14000000E-06  +1.72400000E-05  -3.21900000E-05  +8.77000000E-06  +4.53000000E-06
   -1.34800000E-05  -3.53000000E-05  -3.70700000E-05  +3.54100000E-05  +5.81700000E-05
   -3.14300000E-05  +6.47300000E-05  +1.91900000E-05  -5.44400000E-05  +6.19000000E-06
   -1.17830000E-04  -1.00719000E-03  -7.58010000E-03  -2.84530000E-03  +1.84818000E-03
   +5.58530000E-04  -7.87300000E-05  -5.47350000E-04  +9.22100000E-05  -4.70600000E-05
   -4.75740000E-04  -1.48100000E-05  +1.95090000E-04  +1.35223700E-02  +5.25080200E-02
   -1.67900000E-05  +9.25000000E-06  -3.19000000E-06  +1.38400000E-05  +2.20700000E-05
   -2.57500000E-05  -4.11800000E-05  -7.63000000E-06  +2.54400000E-05  -3.44000000E-05
   +4.31400000E-05  +2.44700000E-05  +5.65000000E-05  +4.82500000E-05  +1.02600000E-05
   -5.14000000E-06  +3.36400000E-05  -3.45400000E-05  +1.05900000E-05  +1.85540000E-04
   +3.98100000E-05  -5.50200000E-05  +1.10100000E-05  +1.88000000E-05  -4.98300000E-05
   -3.53700000E-05  -2.60600000E-05  -6.39520000E-04  -1.27053000E-03  +1.47422000E-03
   +1.78262000E-03  +3.64956000E-03  +1.00979000E-03  -4.29316000E-03  -3.50902000E-03
   -9.46191000E-03  -1.32720000E-04  -1.19692000E-03  +2.86379000E-03  -1.14061000E-03
   +1.71791000E-03  -4.89090000E-04  +1.27482000E-03  +1.57230000E-04  -9.02270000E-04
   -5.81950000E-04  +2.84800000E-05  -1.01960000E-04  -1.63670740E-01  -3.19165100E-02
   -4.46647370E-01  +4.74030000E-04  +4.08000000E-04  -6.13290000E-04  +9.58000000E-06
   -1.11000000E-05  -7.68000000E-06  +7.84000000E-06  +5.65000000E-06  +1.58800000E-05
   -1.28700000E-05  -6.21000000E-06  -6.61000000E-06  -1.55000000E-06  +2.13600000E-05
   -2.72000000E-06  +1.04700000E-05  -1.22500000E-05  -8.73000000E-06  +1.15400000E-05
   -6.21000000E-06  -1.51000000E-06  -1.07300000E-05  +8.97000000E-06  -1.56000000E-05
   +3.05000000E-06  +7.50000000E-07  -9.80000000E-07  -4.00000000E-07  +5.07000000E-06
   -1.46100000E-05  +6.66000000E-06  -4.11000000E-06  -2.62800000E-05  +5.94000000E-06
   +5.51000000E-06  +5.11000000E-06  -2.91000000E-06  +1.17800000E-05  -4.55000000E-06
   +5.07600000E-05  +1.69000000E-05  -1.57000000E-05  -1.58980000E-04  -8.54000000E-05
   -2.99860000E-04  -4.52700000E-05  -2.32568000E-03  +9.23070000E-04  +3.56890000E-04
   -1.62829000E-03  -4.11390000E-04  -5.49050000E-04  -2.96880000E-04  +6.45990000E-04
   -2.02940000E-04  -1.29000000E-06  -3.26680000E-04  +1.67695460E-01  +3.46710400E-02
   +4.56642960E-01  +2.02900000E-04  +3.25380000E-04  -3.80390000E-04  -1.74579000E-03
   -1.14321000E-03  -1.24870000E-04  -2.85319000E-03  -3.67300000E-04  -4.73980000E-04
   -2.96612000E-03  +4.93950000E-03  +1.43969000E-03  +1.69548000E-03  +3.00999000E-03
   -1.12147000E-03  -3.96820000E-04  +7.76890000E-04  -8.00160000E-04  -1.29410000E-03
   -8.81500000E-04  -5.75690000E-04  +9.72100000E-04  +2.22200000E-05  +6.04500000E-05
   -8.81240000E-04  -7.96730000E-04  -1.38380000E-04  +4.25200000E-05  +1.51420500E-02
   -7.23330000E-03  -2.32650500E-02  -3.83225900E-02  -1.64455800E-02  +5.43095000E-03
   -7.09609000E-03  +6.95480000E-04  +3.52634000E-03  +1.89127000E-03  -2.44460000E-03
   +3.62053000E-03  -3.37525000E-03  -1.40380000E-04  -5.31886000E-03  -3.43328000E-03
   +6.98146000E-03  +3.45874000E-03  +1.80927000E-03  -2.27390000E-04  -2.12088000E-03
   +5.89607000E-03  +8.77080000E-04  -2.39183000E-03  +4.29450000E-04  -1.09650000E-04
   +8.02310000E-04  +7.69000000E-06  +7.42700000E-05  +4.71250000E-04  -3.83000000E-06
   +2.03030000E-04  +3.45030000E-04  -3.70280000E-04  +1.18180000E-04  -1.51820000E-04
   -1.72380000E-04  -2.13050000E-04  -1.40290000E-04  -7.30900000E-05  +2.01370000E-04
   +1.04620000E-04  -5.16200000E-05  +5.95700000E-05  +2.32430000E-04  -3.63090000E-04
   -6.57600000E-05  +1.10340000E-04  +4.71210000E-04  +6.22100000E-05  -2.57460000E-04
   -9.50500000E-05  +3.76700000E-05  -3.06310000E-04  +9.53100000E-05  +5.42100000E-05
   +1.03500000E-04  +3.02790000E-04  +2.32540000E-04  +1.63760000E-04  -3.41510000E-04
   -2.46120000E-04  -7.64800000E-05  +1.29660000E-04  +5.98120000E-04  +5.42900000E-05
   -1.37840000E-04  +2.11180000E-04  -1.63480000E-04  +1.68154000E-03  -1.34633000E-03
   -7.49341700E-02  -6.72004900E-02  -2.29261500E-02  +5.44270000E-04  -1.99710000E-04
   -5.13000000E-06  -5.34550000E-04  +2.88760000E-04  -2.74710000E-04  -1.98680000E-04
   +7.40340000E-04  -5.73100000E-04  +5.88481290E-01  -7.07300000E-05  -2.58620000E-04
   +2.21550000E-04  +3.70810000E-04  -1.46553000E-03  +9.52220000E-04  +3.14920000E-03
   -2.71258000E-03  -4.63100000E-05  +3.76100000E-04  -1.82061000E-03  -1.69530000E-04
   -1.76690000E-03  -7.61620000E-04  +5.01850000E-04  -3.04050000E-04  +6.66610000E-04
   -5.18660000E-04  -4.91780000E-04  -8.39530000E-04  -5.31190000E-04  +4.81500000E-04
   -1.84350000E-04  -1.18120000E-04  +1.24149000E-03  +1.51896000E-03  +3.10690000E-04
   +2.24267000E-03  +2.01536100E-02  -8.67043000E-03  -4.40134900E-02  -4.07492900E-02
   -1.91665400E-02  +7.41917000E-03  -1.92052300E-02  -2.61122000E-03  +5.86298000E-03
   +3.85161000E-03  -3.39283000E-03  +6.06022000E-03  -4.98887000E-03  -7.80200000E-05
   -7.99294000E-03  -3.10318000E-03  +8.96802000E-03  +4.74869000E-03  +8.76191000E-03
   -1.17819000E-03  +4.11838000E-03  +1.63725800E-02  -8.67110000E-04  -4.14749000E-03
   +1.30777000E-03  -3.09360000E-04  +3.19800000E-04  -1.47980000E-04  +3.58180000E-04
   +2.00820000E-04  -4.38580000E-04  -1.78800000E-05  +2.29520000E-04  -1.20950000E-04
   +2.41770000E-04  -1.96590000E-04  +2.15280000E-04  -2.66310000E-04  -3.65100000E-05
   -1.02600000E-04  -3.08900000E-05  +2.56680000E-04  -1.22390000E-04  -9.74800000E-05
   +2.08960000E-04  -1.63930000E-04  -3.54600000E-05  -1.81600000E-05  +1.97510000E-04
   +7.89600000E-05  -1.39140000E-04  +3.63600000E-05  -7.08500000E-05  -1.42840000E-04
   +1.19540000E-04  -8.14100000E-05  -2.74200000E-05  +1.55740000E-04  +1.07960000E-04
   +1.64710000E-04  -1.42710000E-04  -2.06570000E-04  -1.99170000E-04  +4.51900000E-05
   +3.16290000E-04  +1.29200000E-05  -1.41860000E-04  +2.27890000E-04  -1.71215000E-03
   +3.75066000E-03  -1.69142000E-03  -2.40217500E-02  -1.55050740E-01  -1.85418300E-02
   +7.45400000E-05  -8.54020000E-04  +2.28660000E-04  -1.12990000E-04  +2.10030000E-04
   -2.95160000E-04  -1.67811000E-03  -5.76790000E-04  +1.38248000E-03  -6.31920400E-02
   +2.85326000E-01  +9.75210000E-04  -1.03540000E-04  +2.46250000E-04  -4.50500000E-04
   -8.33750000E-04  -3.95860000E-04  -2.64768000E-03  +2.00210000E-04  -5.48540000E-04
   -1.58611000E-03  +3.67229000E-03  +1.16263000E-03  +9.84570000E-04  +1.25240000E-03
   -1.51049000E-03  -2.12340000E-04  -7.93490000E-04  +1.96970000E-04  -6.07650000E-04
   -4.69020000E-04  -4.12480000E-04  +3.98220000E-04  -3.67800000E-05  +1.25500000E-05
   -4.77870000E-04  -2.65820000E-04  +1.84480000E-04  +7.16000000E-06  +6.30905000E-03
   -2.59960000E-03  -1.47176700E-02  -1.86928700E-02  -5.64372000E-03  +1.12644000E-03
   -2.19490000E-03  -1.96260000E-04  +1.60761000E-03  +1.39076000E-03  -9.99640000E-04
   +2.00395000E-03  -1.97542000E-03  +2.92460000E-04  -2.89358000E-03  -2.28395000E-03
   +3.49936000E-03  +1.81880000E-03  -2.65853000E-03  +4.48929000E-03  -2.80337000E-03
   -8.77500000E-05  +2.85407000E-03  -9.29950000E-04  -2.82600000E-05  +1.74880000E-04
   +3.75070000E-04  +1.24040000E-04  -1.32400000E-04  +3.94370000E-04  -3.64400000E-05
   +1.75300000E-05  +6.21900000E-04  -4.71520000E-04  +3.32410000E-04  -1.36600000E-05
   -7.70140000E-04  +1.92230000E-04  -1.82600000E-04  +1.27120000E-04  +2.33940000E-04
   -1.35190000E-04  +8.77800000E-05  +1.02610000E-04  +1.00850000E-04  -1.39660000E-04
   -2.04000000E-05  +7.84200000E-05  +2.28170000E-04  +4.30400000E-05  -1.20220000E-04
   -1.04160000E-04  +7.01800000E-05  -1.42470000E-04  +4.07600000E-05  +1.90890000E-04
   +4.70700000E-05  +1.23670000E-04  +1.27340000E-04  +7.44900000E-05  -1.88100000E-04
   -4.43900000E-05  -1.06730000E-04  -4.54500000E-05  +2.02300000E-04  -2.33000000E-06
   -1.28870000E-04  +1.04040000E-04  -6.41600000E-05  +1.05400000E-03  -2.78180000E-04
   -2.40539300E-02  -3.51778900E-02  -4.00276600E-02  +3.40230000E-04  -4.41300000E-05
   -2.33850000E-04  -3.54500000E-04  +2.02310000E-04  +1.38312000E-03  -1.38611000E-03
   -1.58310000E-04  -6.29350000E-04  +1.26913250E-01  +1.17316000E-03  +1.28487040E-01
   -7.18640000E-04  -2.66660000E-04  -1.42300000E-04  -5.26000000E-05  +7.74650000E-04
   -1.80607000E-03  +1.15608000E-03  +3.74950000E-03  +1.74289000E-03  +1.08448000E-03
   -1.79393000E-03  -2.00912000E-03  -2.26108000E-03  -2.28443000E-03  +8.99080000E-04
   +7.14700000E-04  +2.10430000E-04  +1.69315000E-03  +5.15830000E-04  +5.04600000E-05
   +7.65600000E-05  -2.90770000E-04  -6.99500000E-05  -2.57300000E-05  +7.80100000E-04
   +8.10930000E-04  +2.03290000E-04  -1.76390000E-04  -1.90992000E-03  +4.95190000E-04
   +1.85477000E-03  +1.25064000E-03  +1.03434000E-03  -3.72550000E-04  -5.13090000E-04
   -2.84460000E-04  -6.50900000E-05  -1.15450000E-04  +2.75490000E-04  -1.75110000E-04
   +3.75370000E-04  -9.00300000E-05  +4.27270000E-04  +2.33970000E-04  -5.03610000E-04
   -4.94300000E-04  +7.17750000E-04  -3.28290000E-04  +1.04044000E-03  +6.42330000E-04
   +2.05670000E-04  -1.61700000E-05  +1.89600000E-04  -7.48600000E-05  -2.79330000E-04
   -4.93000000E-05  +2.78600000E-05  -3.06800000E-04  -5.21400000E-05  -2.08840000E-04
   -8.46600000E-05  +1.48440000E-04  +5.48600000E-05  +9.77900000E-05  -5.64450000E-04
   +2.65100000E-04  +5.77300000E-05  -1.36960000E-04  -9.09500000E-05  +3.35500000E-05
   -3.21400000E-05  -1.30490000E-04  -4.09400000E-05  +1.16880000E-04  +1.18900000E-05
   -3.81000000E-05  -1.43810000E-04  -1.36300000E-05  +7.44200000E-05  +1.73100000E-05
   -4.29900000E-05  +1.04410000E-04  -3.09300000E-05  -4.31600000E-05  -6.59500000E-05
   -9.01800000E-05  -6.51400000E-05  -6.27600000E-05  +1.33180000E-04  +6.97900000E-05
   +5.38400000E-05  +4.32900000E-05  -6.95900000E-05  -3.74000000E-05  +1.53600000E-05
   -3.36900000E-05  +5.98000000E-05  -8.30800000E-05  +7.63500000E-05  -2.00545400E-02
   +4.07275000E-03  -3.32861000E-03  -1.67260000E-04  -5.18500000E-05  +5.07300000E-05
   +2.25710000E-04  -3.83200000E-05  -1.68540000E-04  -7.35420000E-04  -2.11800000E-05
   -1.42290000E-04  -4.57499280E-01  +1.17810170E-01  -7.31008200E-02  +4.76063040E-01
   +5.45320000E-04  -4.06000000E-05  -2.61460000E-04  -6.43760000E-04  -1.32158000E-03
   -1.24887000E-03  -1.26892000E-03  -1.96706000E-03  +3.06280000E-04  +8.74750000E-04
   +1.49841000E-03  +1.12053000E-03  +3.06086000E-03  +1.60785000E-03  -9.69490000E-04
   +3.08770000E-04  -5.17800000E-04  +2.47820000E-04  -5.20600000E-04  -1.77340000E-04
   -1.01470000E-04  +3.30160000E-04  +8.14800000E-05  +5.17300000E-05  -1.82035000E-03
   -1.82408000E-03  -4.03360000E-04  -2.12400000E-04  +2.73984000E-03  -1.35585000E-03
   -2.84573000E-03  -6.55247000E-03  -2.61774000E-03  +1.08159000E-03  -7.53600000E-04
   +4.23200000E-04  +4.21670000E-04  +3.15540000E-04  -4.27870000E-04  +5.72690000E-04
   -6.34400000E-04  -2.35400000E-05  -8.71330000E-04  -6.45600000E-04  +1.26347000E-03
   +5.79880000E-04  +2.25250000E-04  +1.91720000E-04  +2.24880000E-04  +8.57220000E-04
   +3.93170000E-04  -1.49100000E-04  -6.98000000E-06  -5.53800000E-05  +2.94560000E-04
   +6.51000000E-05  -2.99100000E-05  -8.25300000E-05  +4.20660000E-04  +9.38700000E-05
   -2.82310000E-04  +1.21740000E-04  -3.11820000E-04  -4.30900000E-05  +7.51000000E-06
   -4.44700000E-05  -1.07110000E-04  +2.15300000E-05  +1.52890000E-04  -2.06540000E-04
   +1.59910000E-04  +1.42310000E-04  +4.46000000E-05  -1.12280000E-04  -1.66400000E-05
   +6.07200000E-05  +1.69320000E-04  +1.66400000E-05  -8.45600000E-05  -5.96600000E-05
   +4.56300000E-05  -7.79800000E-05  +6.70000000E-06  +2.24800000E-05  +5.94700000E-05
   +1.01510000E-04  +9.52100000E-05  +2.31100000E-05  -9.03100000E-05  -6.78400000E-05
   -2.15900000E-05  +3.08800000E-05  +1.36190000E-04  +3.14400000E-05  -1.76700000E-05
   +2.46500000E-05  +7.40600000E-05  +2.12890000E-04  -2.33260000E-04  -2.39499200E-02
   +1.80897900E-02  -1.36200000E-03  +4.59300000E-05  +3.00000000E-06  +1.78300000E-05
   -1.63100000E-04  +6.00500000E-05  -8.79000000E-06  -1.18640000E-04  -5.30700000E-05
   -1.46900000E-05  +1.42718110E-01  -8.40405000E-02  +2.78097800E-02  -1.24456810E-01
   +7.29451400E-02  -8.14370000E-04  -7.00760000E-04  -9.65930000E-04  -7.53000000E-06
   -2.47010000E-04  -6.16810000E-04  +1.63928000E-03  +1.37294000E-03  +1.28553000E-03
   +4.53090000E-04  -2.51204000E-03  -9.29030000E-04  -4.83840000E-04  -6.11380000E-04
   +1.99839000E-03  +6.38600000E-05  +9.20710000E-04  -6.94900000E-04  -9.03000000E-06
   -2.23500000E-05  -5.98300000E-05  +1.03700000E-05  +3.27100000E-05  +6.61700000E-05
   +3.56720000E-04  +1.61450000E-04  -1.81250000E-04  -1.95860000E-04  -6.79730000E-04
   +2.02940000E-04  +1.32800000E-04  -1.93670000E-04  +4.97430000E-04  -7.39400000E-05
   -3.62160000E-04  -5.66000000E-05  -3.18000000E-06  -3.41000000E-05  +8.45500000E-05
   +3.99400000E-05  +1.91300000E-05  -7.65000000E-05  +4.98700000E-05  +5.85100000E-05
   -2.87840000E-04  +3.85000000E-05  +5.92000000E-06  -2.15600000E-05  +7.10540000E-04
   +2.33570000E-04  +3.44510000E-04  +5.48100000E-05  +6.83700000E-05  -7.62400000E-05
   -2.74300000E-05  -2.30400000E-05  +6.53000000E-06  -2.41240000E-04  +6.91200000E-05
   +2.26300000E-05  -6.95660000E-04  +5.97710000E-04  -4.82300000E-04  +2.72600000E-05
   +3.45010000E-04  -1.29420000E-04  +4.02700000E-05  -1.29900000E-05  -2.02300000E-05
   +6.43400000E-05  -5.76100000E-05  -8.75600000E-05  -4.74000000E-06  +1.08200000E-05
   -1.98000000E-06  +4.94000000E-06  +7.48000000E-06  -2.72600000E-05  +1.39900000E-05
   +1.39200000E-05  -3.99400000E-05  +1.14500000E-05  -1.82600000E-05  -4.52100000E-05
   +9.20000000E-07  +2.10000000E-06  -1.21300000E-05  -1.97800000E-05  +2.07200000E-05
   +5.70000000E-06  +2.57700000E-05  +5.52500000E-05  +1.39000000E-06  +1.06500000E-05
   +1.98900000E-05  -9.26000000E-06  +5.13000000E-05  +2.36900000E-05  +3.20800000E-05
   -8.63369000E-03  +1.46711000E-03  -1.90035000E-03  -9.10300000E-05  -1.78400000E-05
   +4.99000000E-05  +1.46130000E-04  +1.40000000E-06  -4.01300000E-05  -9.23650000E-04
   +6.32000000E-06  +1.34840000E-04  -5.97569100E-02  +2.09170400E-02  -2.43204700E-02
   +7.86387900E-02  -2.13974800E-02  +2.71027000E-02  +1.05150000E-04  +2.12400000E-05
   +2.94050000E-04  +4.53900000E-04  +3.13880000E-04  +7.20100000E-05  +2.81650000E-04
   +5.25600000E-05  -6.64000000E-06  +2.05240000E-04  -5.73780000E-04  -3.59410000E-04
   -4.58200000E-04  -4.50520000E-04  -1.40870000E-04  +1.30290000E-04  -3.99220000E-04
   +1.77330000E-04  +4.39560000E-04  +1.47310000E-04  +9.83500000E-05  -2.22440000E-04
   -7.53900000E-05  -5.63300000E-05  +2.72460000E-04  +7.13500000E-05  +3.43600000E-05
   +7.97650000E-04  +2.34246000E-03  -1.02644000E-03  -6.17618000E-03  -4.75024000E-03
   -9.28160000E-04  +1.33083000E-03  -6.78509000E-03  -8.86290000E-04  +1.25334000E-03
   +7.59480000E-04  -5.05170000E-04  +1.25774000E-03  -7.52540000E-04  -2.37430000E-04
   -1.42669000E-03  +2.07930000E-04  +8.98610000E-04  +6.99070000E-04  +5.66460000E-03
   -1.23902000E-03  +5.57670000E-03  +7.02699000E-03  -1.67361000E-03  -8.28010000E-04
   +6.70190000E-04  -3.58860000E-04  -2.30080000E-04  -1.01220000E-04  +1.75220000E-04
   -2.07040000E-04  +1.48900000E-05  -6.42800000E-05  -1.30320000E-04  +1.02750000E-04
   -5.19800000E-05  +2.41400000E-05  +1.77080000E-04  -1.63300000E-05  +7.36600000E-05
   -1.21300000E-05  -9.41000000E-05  -5.97300000E-05  +5.94600000E-05  +2.10300000E-05
   -2.19700000E-05  +7.97900000E-05  -8.60000000E-07  -5.15400000E-05  -1.20900000E-04
   +9.32000000E-06  +4.39800000E-05  +5.82300000E-05  -5.97700000E-05  +1.18180000E-04
   +3.40000000E-06  -1.40760000E-04  -5.24600000E-05  -6.94700000E-05  -4.82400000E-05
   -3.22500000E-05  +1.30550000E-04  -1.86000000E-05  +9.80000000E-07  +6.64600000E-05
   -7.74300000E-05  -6.13000000E-06  +4.60100000E-05  -1.23300000E-05  -3.61990000E-04
   +7.92970000E-04  -2.76220000E-04  +1.29598500E-02  +6.48328000E-03  +1.21061700E-02
   -4.39400000E-04  -3.38390000E-04  +3.06350000E-04  +5.13000000E-05  +2.68500000E-05
   -3.56060000E-04  -1.99600000E-04  -5.26970000E-04  +1.71957000E-03  -3.11067000E-02
   -2.89295100E-02  +2.60273000E-02  -3.27760000E-03  +6.74845000E-03  -9.04608000E-03
   +1.02944920E-01  +8.23100000E-05  +1.45670000E-04  -2.39150000E-04  -3.85550000E-04
   -1.76370000E-04  +3.62400000E-05  -5.28460000E-04  -9.17900000E-05  -2.55900000E-05
   -4.98360000E-04  +8.42440000E-04  +4.79640000E-04  +1.03974000E-03  +9.25390000E-04
   -7.87900000E-05  -7.34000000E-06  +6.09900000E-05  -1.98500000E-04  -2.38980000E-04
   -1.12040000E-04  -1.64700000E-05  +6.51400000E-05  +8.05700000E-05  +5.00800000E-05
   -7.14070000E-04  -6.97110000E-04  -1.53370000E-04  -6.52710000E-04  -3.84285000E-03
   +1.99911000E-03  +5.94487000E-03  +6.38030000E-03  +1.10074000E-03  -2.45932000E-03
   +5.01376000E-03  -4.61700000E-05  -1.73115000E-03  -8.94330000E-04  +8.40040000E-04
   -1.61032000E-03  +1.19765000E-03  +2.37520000E-04  +2.12138000E-03  +4.93300000E-04
   -1.70949000E-03  -7.03670000E-04  -6.79801000E-03  +8.91030000E-04  -2.58558000E-03
   -6.39119000E-03  +2.40346000E-03  +1.30000000E-03  -6.34560000E-04  +2.17560000E-04
   +8.91400000E-05  +1.05000000E-04  -1.48560000E-04  +1.61940000E-04  +1.18360000E-04
   +5.71400000E-05  +1.34440000E-04  -1.20150000E-04  +3.61800000E-05  +2.04900000E-05
   -1.73040000E-04  +4.96200000E-05  -1.60700000E-05  +3.22000000E-05  +6.52500000E-05
   -9.40200000E-05  +2.97900000E-05  +6.02500000E-05  -3.28800000E-05  -2.29600000E-05
   +1.12400000E-05  +4.94100000E-05  +5.03300000E-05  -1.63300000E-05  -3.81000000E-06
   -4.96000000E-05  +5.71100000E-05  -4.52300000E-05  -4.43400000E-05  +7.22400000E-05
   +5.07500000E-05  +2.91600000E-05  +1.40400000E-05  -1.98600000E-05  -4.32400000E-05
   +3.96900000E-05  -7.45000000E-06  -8.52700000E-05  -4.94500000E-05  +2.87000000E-06
   -7.86000000E-06  -4.95700000E-05  +3.54860000E-04  -7.78900000E-04  +5.62310000E-04
   -9.50171000E-03  -2.13093100E-02  +7.74700000E-03  +9.21400000E-05  +2.95180000E-04
   -2.15520000E-04  +1.48170000E-04  +4.96930000E-04  -1.53350000E-04  -9.99420000E-04
   +5.00450000E-04  -4.36300000E-04  -7.07334000E-03  -7.20678000E-03  -1.58390400E-02
   +4.85862000E-03  -7.00190000E-04  -3.07927000E-03  +8.14560000E-03  +6.59161800E-02
   -5.47450000E-04  -1.35100000E-04  +4.18890000E-04  +7.31680000E-04  +2.51360000E-04
   +1.17940000E-04  +1.78038000E-03  +6.49000000E-06  +2.12240000E-04  +8.32040000E-04
   -2.39880000E-03  -9.69360000E-04  -1.27968000E-03  -1.20223000E-03  +5.64520000E-04
   +1.57570000E-04  +2.63400000E-04  +2.25800000E-04  +5.67270000E-04  +2.25930000E-04
   +1.91880000E-04  -2.14850000E-04  -1.48400000E-04  -1.16640000E-04  +7.71860000E-04
   +5.41950000E-04  -4.42000000E-06  +1.36040000E-03  +5.50696000E-03  -3.08696000E-03
   -1.20991600E-02  -1.16958600E-02  -3.91400000E-04  +3.44849000E-03  -8.31857000E-03
   -4.98810000E-04  +2.36486000E-03  +1.07269000E-03  -1.10171000E-03  +2.25188000E-03
   -1.55537000E-03  -4.37380000E-04  -2.96742000E-03  -1.60280000E-04  +2.14590000E-03
   +2.51288000E-03  +1.17512000E-02  -1.71762000E-03  +5.97301000E-03  +1.03964700E-02
   -6.58057000E-03  -1.60643000E-03  +9.68740000E-04  -5.75630000E-04  -2.82910000E-04
   -2.58110000E-04  +4.05410000E-04  -3.82190000E-04  -2.86600000E-05  -7.95400000E-05
   -3.25130000E-04  +2.90850000E-04  -1.57040000E-04  -3.50300000E-05  +4.26770000E-04
   -1.26080000E-04  +1.66200000E-04  -2.21260000E-04  -2.66090000E-04  +2.14490000E-04
   -6.22900000E-05  -8.59700000E-05  +1.83500000E-05  +7.86200000E-05  -7.58000000E-06
   -9.11100000E-05  -1.35280000E-04  +2.27600000E-05  +3.67200000E-05  +1.11380000E-04
   -1.39130000E-04  +1.60070000E-04  +1.02800000E-05  -3.12330000E-04  -8.22900000E-05
   -5.85800000E-05  -6.28100000E-05  -1.45200000E-05  +1.83880000E-04  -1.01890000E-04
   +4.94800000E-05  +1.69950000E-04  -1.48100000E-05  +1.87800000E-05  +6.34100000E-05
   +4.80400000E-05  -8.36210000E-04  +1.05660000E-03  -1.02034000E-03  +2.10081600E-02
   +2.33987200E-02  +1.29788300E-02  -3.17380000E-04  -4.17430000E-04  +4.69760000E-04
   +1.85590000E-04  +2.93400000E-04  -8.87550000E-04  +2.99669000E-03  +6.90020000E-04
   +4.56330000E-04  +9.79710000E-03  -3.01135600E-02  +3.33350000E-04  -1.01841500E-02
   -5.38117000E-03  +7.33765000E-03  +6.46511000E-03  +2.58136700E-02  +6.54711000E-02
   -6.61500000E-05  +1.18400000E-05  -9.35800000E-05  -5.50390000E-04  -4.22000000E-04
   -2.52810000E-04  -3.74220000E-04  +3.54700000E-05  +4.54200000E-05  -3.18580000E-04
   +7.31460000E-04  +2.81930000E-04  +4.62250000E-04  +4.48150000E-04  -4.47700000E-05
   -1.91700000E-05  +3.84820000E-04  -6.58200000E-05  -6.66110000E-04  -8.75600000E-05
   +1.55320000E-04  +3.34460000E-04  +4.98100000E-05  -1.50900000E-05  -1.94580000E-04
   -2.43200000E-05  -3.91600000E-05  -7.83570000E-04  -3.88247000E-03  +9.66000000E-04
   +7.52107000E-03  +5.82006000E-03  +3.82062000E-03  -3.29569000E-03  +1.63007800E-02
   +3.58158000E-03  -2.78547000E-03  -3.43994000E-03  +8.03530000E-04  -3.12387000E-03
   +1.87937000E-03  +3.88530000E-04  +2.83081000E-03  -1.62990000E-04  -2.14823000E-03
   +6.23007000E-03  -4.58479000E-03  -6.50340000E-04  -2.63153100E-02  -2.61835600E-02
   +2.38329800E-02  +1.88651000E-03  -1.65670000E-03  +5.41920000E-04  +3.25670000E-04
   -2.69500000E-05  -6.72900000E-05  +1.74000000E-04  -1.64600000E-05  +5.95600000E-05
   +1.31950000E-04  -1.04560000E-04  +5.17100000E-05  -5.85700000E-05  -1.62850000E-04
   -4.69400000E-05  -4.11000000E-05  -1.49610000E-04  +2.52400000E-05  +1.63000000E-04
   -6.85000000E-05  -1.71200000E-05  +7.39200000E-05  -1.30280000E-04  -5.50000000E-07
   +4.30600000E-05  +1.65740000E-04  +3.70000000E-07  -7.59100000E-05  -3.81100000E-05
   +2.57000000E-05  -1.19720000E-04  -2.47900000E-05  +5.72000000E-05  +5.45800000E-05
   +1.13120000E-04  +7.40700000E-05  +7.01800000E-05  -1.41100000E-04  -6.62400000E-05
   +1.08530000E-04  -6.35100000E-05  +8.97500000E-05  +9.54200000E-05  -2.80600000E-05
   +1.63500000E-04  +7.28800000E-05  -1.62871000E-03  +8.21000000E-05  -1.08973800E-02
   -1.12813100E-02  -6.21351000E-03  +1.59860000E-03  +9.61370000E-04  -5.74490000E-04
   +3.10690000E-04  +1.21628000E-03  -4.70980000E-04  -3.86025000E-03  -2.15687000E-03
   -9.18880000E-04  -1.33201000E-03  +3.32865000E-02  -4.50467400E-02  +4.34567000E-03
   +2.26670000E-04  -1.54837000E-03  -5.52347700E-02  +1.13841400E-02  -5.93916000E-03
   +4.38062930E-01  -4.34000000E-05  -8.38800000E-05  -8.40600000E-05  -1.93840000E-04
   -1.13000000E-04  -2.75000000E-06  +1.29680000E-04  -2.83200000E-05  -1.01620000E-04
   +3.04380000E-04  -5.04600000E-05  -1.94230000E-04  -7.52800000E-04  -5.64060000E-04
   +2.98800000E-05  -5.25600000E-05  +7.70600000E-05  +1.83010000E-04  -3.72510000E-04
   +1.04080000E-04  -4.95290000E-04  +1.38920000E-04  +5.63300000E-05  +6.89100000E-05
   +6.64040000E-04  +6.73510000E-04  +1.90540000E-04  -9.77790000E-04  +2.52600000E-03
   +9.06920000E-04  +1.58121000E-03  -2.48056000E-03  -8.27549000E-03  +1.41551000E-03
   -4.14298000E-03  -6.12400000E-05  +1.39944000E-03  +1.32080000E-03  -4.66180000E-04
   +1.09195000E-03  -6.74330000E-04  -2.09660000E-04  -6.56820000E-04  -1.02816000E-03
   +1.45555000E-03  -8.84262000E-03  -3.90278700E-02  -6.61591000E-03  -6.55848000E-03
   +8.05164000E-03  +5.64532000E-03  -1.61837000E-03  +4.90820000E-04  +1.41090000E-04
   +3.72010000E-04  +1.01840000E-04  -4.45970000E-04  -6.77300000E-05  -1.32190000E-04
   -4.61600000E-05  +1.57000000E-06  +4.21600000E-05  +3.10800000E-05  -5.35600000E-05
   +4.15400000E-05  -6.25600000E-05  -1.87570000E-04  -1.08300000E-05  +8.80700000E-05
   +9.70400000E-05  -3.41400000E-05  -4.97300000E-05  +5.95300000E-05  -5.07200000E-05
   -1.95700000E-05  -1.68600000E-05  +4.41000000E-05  -3.86000000E-06  -3.44800000E-05
   -2.26400000E-05  +6.34800000E-05  -2.70920000E-04  +2.30500000E-05  +5.29820000E-04
   -3.41700000E-05  +1.01000000E-05  +3.06300000E-05  +1.24280000E-04  -3.09970000E-04
   +1.69170000E-04  -2.16470000E-04  -1.53830000E-04  +1.53700000E-04  -8.32900000E-05
   -5.57100000E-05  +1.18300000E-05  +1.32680000E-04  +3.81000000E-04  -2.14280000E-04
   +9.02860000E-04  +1.72854000E-03  -9.89980000E-04  +2.05090000E-04  -3.08300000E-04
   +9.27700000E-05  +1.12813000E-03  -5.40941000E-03  +3.91171000E-03  -6.75440000E-04
   -9.89150000E-04  +5.05050000E-04  +1.30438200E-02  -2.18897000E-03  +2.66619400E-02
   -1.87010000E-03  -2.24930000E-04  +3.08730000E-03  +1.10749900E-02  -5.20868900E-02
   +4.56750000E-03  -3.81343000E-03  +4.11278430E-01  +3.50870000E-04  +4.33500000E-05
   -3.58630000E-04  -4.33840000E-04  -1.48580000E-04  +1.04800000E-05  -1.11532000E-03
   -6.68200000E-05  -1.98670000E-04  -5.26740000E-04  +1.55726000E-03  +6.64890000E-04
   +7.54140000E-04  +7.24060000E-04  -4.07840000E-04  -9.56500000E-05  -2.22130000E-04
   -9.98000000E-05  -2.84650000E-04  -8.44700000E-05  -4.30740000E-04  +7.43600000E-05
   +1.43630000E-04  +1.41090000E-04  -4.47590000E-04  -3.09410000E-04  +3.26300000E-05
   -1.35416000E-03  -2.10007000E-03  +2.94477000E-03  +6.87165000E-03  +5.35418000E-03
   -4.52328000E-03  -1.05896000E-03  -3.98007000E-03  -2.39680000E-03  -1.87180000E-04
   +1.34155000E-03  +4.71530000E-04  -1.75800000E-05  +2.17670000E-04  +1.21300000E-04
   +1.03734000E-03  -4.72400000E-05  -3.49900000E-04  -4.12223000E-03  -2.10355700E-02
   +7.61255000E-03  +1.80512400E-02  +1.09546900E-02  -4.22790000E-03  -7.76000000E-06
   +3.33090000E-04  +2.48240000E-04  +1.87100000E-04  +2.83460000E-04  -4.62740000E-04
   +2.27850000E-04  +8.44000000E-06  +3.97100000E-05  +2.19630000E-04  -1.85030000E-04
   +1.09320000E-04  +4.02000000E-05  -2.76280000E-04  +1.04200000E-04  -1.64080000E-04
   +1.87670000E-04  +2.02480000E-04  -1.51680000E-04  +3.30900000E-05  +4.25900000E-05
   -4.31600000E-05  -2.36000000E-05  +1.10000000E-06  +5.49300000E-05  +5.43000000E-05
   -2.44500000E-05  -3.32000000E-06  -8.95700000E-05  +1.34350000E-04  -1.69580000E-04
   -1.80300000E-05  +4.02480000E-04  +4.66100000E-05  -3.10000000E-07  +2.34300000E-05
   +1.21700000E-05  -1.88700000E-04  +1.73570000E-04  -2.04200000E-04  -1.91680000E-04
   +2.00400000E-05  -1.07910000E-04  -5.90300000E-05  -1.58720000E-04  +8.93160000E-04
   +1.73920000E-04  +1.05889000E-03  -1.14090500E-02  -1.29167100E-02  -6.49123000E-03
   -7.85060000E-04  -3.46430000E-04  -6.61100000E-05  +2.12600000E-04  -5.02990000E-04
   +1.72664000E-03  -1.24582000E-03  -3.80210000E-04  +1.01434000E-03  -3.46368500E-02
   +4.96723200E-02  -6.26806700E-02  +7.75058000E-03  +3.73521000E-03  -8.20853000E-03
   -5.25210000E-03  +4.38642000E-03  -7.10984700E-02  -7.20364600E-02  +9.40281800E-02
   +3.39543510E-01  +1.81320000E-04  -7.15200000E-05  +3.67000000E-06  +3.61060000E-04
   +2.23890000E-04  +6.06100000E-05  -1.40300000E-04  -4.02800000E-05  -6.16300000E-05
   +1.51500000E-05  +5.23200000E-05  +7.49300000E-05  -1.42160000E-04  -1.43240000E-04
   -2.06520000E-04  -1.84900000E-05  -3.69570000E-04  +5.21700000E-05  +3.20150000E-04
   -4.85000000E-06  +1.02790000E-04  -1.58630000E-04  -2.85600000E-05  -1.28200000E-05
   +6.32500000E-05  +3.47800000E-05  +6.91100000E-05  +2.12420000E-04  +6.61100000E-05
   -2.04070000E-04  -2.03426000E-03  -2.94023000E-03  +2.17656000E-03  -4.54700000E-04
   -1.75980000E-03  +1.54433000E-03  -1.79800000E-05  -2.32600000E-05  -1.92910000E-04
   +2.68040000E-04  -1.78850000E-04  -9.10100000E-05  -3.08590000E-04  +2.86950000E-04
   -1.23800000E-05  -7.62359000E-03  +6.93532000E-03  -2.37911000E-03  -6.65190000E-04
   -1.37104000E-03  -1.04200000E-03  +5.44700000E-05  +8.54300000E-05  -1.84100000E-04
   -2.32680000E-04  +6.70300000E-05  +1.23890000E-04  -2.41000000E-05  -9.77000000E-06
   -1.91800000E-05  -5.09000000E-06  -4.92000000E-06  +1.42300000E-05  +2.98600000E-05
   +3.44000000E-06  +6.11800000E-05  -8.05000000E-06  +2.36310000E-04  +7.45300000E-05
   -1.47740000E-04  +4.42200000E-05  +1.58100000E-05  -3.23600000E-05  +5.90000000E-05
   +3.00000000E-07  -1.56100000E-05  -7.02100000E-05  +3.95000000E-06  +3.16200000E-05
   +1.53100000E-05  -1.41200000E-05  +1.27670000E-04  +7.71300000E-05  -1.67500000E-04
   -1.78900000E-05  -4.69100000E-05  -1.98200000E-05  -4.47500000E-05  +1.46420000E-04
   -2.61200000E-05  +3.32900000E-05  +4.94100000E-05  -5.23800000E-05  +2.92500000E-05
   +6.40900000E-05  +2.08900000E-05  -4.30110000E-04  +2.25500000E-05  -4.16850000E-04
   +1.68185000E-03  +1.70526000E-03  -1.66640000E-04  -1.25830000E-04  +1.10000000E-07
   +1.14180000E-04  -1.19895000E-03  -3.00782000E-03  +6.11000000E-05  +4.74560000E-04
   +3.27590000E-04  -1.22590000E-04  -1.45235000E-03  +5.75430000E-04  +6.26260000E-04
   -1.18740000E-04  +1.15810000E-04  -6.23820000E-04  +2.61772000E-03  -1.59693700E-02
   -1.06280600E-02  -5.79327800E-02  -1.26782000E-03  -4.96561000E-03  +6.91104700E-02
   -4.63100000E-05  +1.22490000E-04  +3.33130000E-04  +5.00230000E-04  +2.89690000E-04
   +4.69000000E-06  +2.73950000E-04  +1.41540000E-04  +2.76870000E-04  -1.36940000E-04
   -6.84340000E-04  -1.12500000E-04  +5.67650000E-04  +2.96990000E-04  +6.88400000E-05
   +1.59870000E-04  -5.56300000E-05  -1.89020000E-04  +6.44580000E-04  -1.11770000E-04
   +8.74600000E-04  -2.51810000E-04  -1.49540000E-04  -1.60470000E-04  -6.46780000E-04
   -7.08090000E-04  -2.38050000E-04  +2.03983000E-03  -2.24388000E-03  -2.39686000E-03
   -5.34112000E-03  -1.69676000E-03  +1.45014100E-02  -1.27000000E-04  +8.85745000E-03
   -7.43400000E-04  -1.89809000E-03  -2.28074000E-03  +7.25440000E-04  -1.47436000E-03
   +1.13569000E-03  +1.12860000E-04  +7.52880000E-04  +1.40900000E-03  -1.96580000E-03
   +6.71303000E-03  +8.42993000E-03  -4.43372000E-03  -6.20064000E-03  -9.91387000E-03
   +3.69960000E-03  +2.27646000E-03  -9.07580000E-04  -3.58170000E-04  -5.32860000E-04
   -2.47670000E-04  +7.30900000E-04  -2.33000000E-05  +1.49100000E-04  +3.21800000E-05
   -1.24870000E-04  +3.50600000E-05  -9.16900000E-05  +6.05500000E-05  +7.85200000E-05
   +3.57800000E-05  +3.72260000E-04  -6.78700000E-05  -2.52440000E-04  -1.42120000E-04
   +5.93600000E-05  +5.27500000E-05  -6.56800000E-05  +9.70800000E-05  +2.16200000E-05
   -5.05000000E-06  -9.03700000E-05  +1.27700000E-05  +4.99300000E-05  +8.06300000E-05
   -1.53910000E-04  +5.02190000E-04  -2.27510000E-04  -8.80760000E-04  +1.58900000E-05
   -5.91000000E-06  -6.09800000E-05  -1.94690000E-04  +5.12260000E-04  -2.81940000E-04
   +3.62690000E-04  +2.80120000E-04  -3.18250000E-04  +1.20150000E-04  +9.51600000E-05
   -1.11500000E-05  -5.33700000E-04  -4.86460000E-04  -4.60900000E-05  +5.05897000E-03
   +6.93497000E-03  +3.03084000E-03  +2.52290000E-04  +6.68380000E-04  -1.16870000E-04
   -6.86200000E-05  +4.58099000E-03  -5.45330000E-03  +4.01830000E-04  +5.79900000E-04
   -7.59740000E-04  +1.86102000E-03  -1.26252100E-02  +1.03816400E-02  -1.46501000E-03
   +3.34100000E-05  +6.03040000E-04  -1.24578300E-02  +1.56599300E-02  -2.07354400E-02
   +1.45511600E-02  -2.72926620E-01  -1.29404190E-01  -2.01813000E-02  +2.53414660E-01
   -2.89500000E-05  +5.71200000E-05  +2.53050000E-04  +1.23370000E-04  +2.30200000E-05
   -9.22900000E-05  +1.54280000E-04  +3.85500000E-05  +3.11700000E-05  +6.08400000E-05
   -2.60940000E-04  -1.43770000E-04  -4.29800000E-05  -6.53700000E-05  +3.85400000E-05
   +1.96900000E-05  -4.54900000E-05  -1.30000000E-06  +1.30500000E-04  -1.64700000E-05
   +2.22720000E-04  -8.03000000E-06  -7.06900000E-05  -6.71800000E-05  +1.66900000E-05
   -4.19100000E-05  -3.90500000E-05  +1.34815000E-03  +9.09300000E-04  -2.14511000E-03
   -2.07350000E-03  +3.63821000E-03  +1.95368000E-03  +1.68132000E-03  +3.21192000E-03
   +2.26910000E-04  -4.80900000E-05  -3.90780000E-04  -1.92460000E-04  +2.38900000E-05
   -1.18760000E-04  -4.92000000E-06  -6.84750000E-04  +1.18120000E-04  +8.91400000E-05
   +1.27518000E-03  +4.67901000E-03  -1.56316700E-02  -2.51189000E-03  -2.10682000E-03
   +1.46232000E-03  +1.41310000E-04  -1.88590000E-04  -6.47300000E-05  +7.19000000E-06
   -1.84920000E-04  +1.77560000E-04  -4.97500000E-05  +2.65500000E-05  -6.05000000E-06
   -4.59800000E-05  +3.29400000E-05  -2.85900000E-05  -8.97000000E-06  +4.21900000E-05
   -2.13400000E-05  +8.32300000E-05  -1.13480000E-04  -7.27400000E-05  +3.62900000E-05
   +1.83900000E-05  +1.71600000E-05  +1.69100000E-05  +5.00000000E-06  +3.19000000E-06
   -1.24800000E-05  -7.34000000E-06  +1.29500000E-05  -3.64000000E-06  +3.19000000E-05
   -5.69400000E-05  +4.34200000E-05  -3.44100000E-05  -1.35870000E-04  -1.67600000E-05
   +2.59300000E-05  -1.54800000E-05  -7.31000000E-06  +5.86400000E-05  -5.82600000E-05
   +1.53460000E-04  +1.28310000E-04  -5.50500000E-05  +4.19600000E-05  +1.00700000E-05
   +4.68100000E-05  -2.73850000E-04  -6.07100000E-05  -3.65940000E-04  +2.13383000E-03
   +4.19050000E-03  -9.73230000E-04  +2.64700000E-04  +1.79450000E-04  -3.00000000E-06
   -3.93730000E-04  -3.91057000E-03  +3.54230000E-04  +1.83770000E-04  -5.54000000E-06
   -3.16570000E-04  -4.51470000E-04  -2.33894000E-03  +3.60224000E-03  -9.59510000E-04
   +4.06890000E-04  -6.88400000E-05  -4.61290000E-03  -2.12616200E-02  -2.36407300E-02
   +3.54361000E-03  -1.15072930E-01  -1.01139450E-01  -7.07205000E-03  +1.43307870E-01
   +1.46492330E-01  +1.31640000E-04  -4.20000000E-07  -8.37300000E-05  +2.67350000E-04
   +3.09730000E-04  +2.59640000E-04  +4.92800000E-05  -5.07900000E-05  -1.03360000E-04
   +1.65200000E-04  -2.42880000E-04  -3.39400000E-05  -8.08100000E-05  -1.00660000E-04
   +4.30700000E-05  -3.18600000E-05  -3.63330000E-04  -6.00000000E-07  +5.10830000E-04
   +4.89800000E-05  -4.07590000E-04  -2.85460000E-04  +4.66000000E-06  +8.78200000E-05
   -3.80500000E-05  -1.50780000E-04  +7.85000000E-06  +1.58890000E-04  +3.65403000E-03
   -7.88100000E-05  -4.35029000E-03  -3.42880000E-03  -6.35984000E-03  +3.44977000E-03
   -1.85180100E-02  -5.55748000E-03  +2.72731000E-03  +4.38261000E-03  -4.41960000E-04
   +3.48621000E-03  -1.83791000E-03  -5.78280000E-04  -2.59120000E-03  -1.89830000E-04
   +2.31670000E-03  -2.12312000E-03  -6.54414000E-03  +2.91298000E-03  -4.95910000E-04
   +2.01498900E-02  -8.08392000E-03  -1.92006000E-03  +1.67569000E-03  -5.55500000E-04
   -1.92160000E-04  +1.12660000E-04  -1.68780000E-04  -7.45400000E-05  +4.04000000E-05
   -3.23100000E-05  -4.68700000E-05  +4.08700000E-05  -2.04900000E-05  +6.69200000E-05
   +4.04700000E-05  +8.35700000E-05  -2.14300000E-05  +1.54650000E-04  +3.61000000E-05
   -1.49300000E-04  +4.98900000E-05  +1.98800000E-05  -8.80400000E-05  +1.16980000E-04
   -1.18000000E-06  -1.29000000E-05  -1.25180000E-04  -1.03700000E-05  +6.77500000E-05
   -3.05000000E-06  +2.72300000E-05  +3.00500000E-05  -1.82500000E-05  +1.61130000E-04
   -3.13200000E-05  -1.10900000E-04  -6.05900000E-05  -6.66200000E-05  +2.32900000E-05
   +1.55410000E-04  -1.99010000E-04  +1.37400000E-05  -7.58000000E-05  -1.62850000E-04
   +2.20300000E-05  -2.75340000E-04  +1.62490000E-04  +1.62328000E-03  +1.34410000E-04
   +5.66670000E-03  +6.81266000E-03  +2.01438000E-03  -1.69422000E-03  -9.96310000E-04
   +6.20380000E-04  +3.71100000E-04  -7.18930000E-04  +9.05030000E-04  +4.37394000E-03
   +3.56553000E-03  -8.75600000E-05  +1.02483000E-03  -1.00174800E-02  +7.51500000E-03
   -1.29813000E-03  -5.17120000E-04  +6.14560000E-04  -3.11152400E-02  +9.83267000E-03
   -1.60359300E-02  -2.96850650E-01  -5.20610000E-03  +1.04042090E-01  -2.26125000E-03
   +1.43806800E-02  +7.82298000E-03  +3.23471020E-01  +3.80000000E-05  +2.45000000E-05
   -3.83200000E-05  +1.15690000E-04  +1.64430000E-04  +8.81700000E-05  -4.79800000E-05
   +6.33000000E-06  -2.69800000E-05  -3.22900000E-05  -2.71500000E-05  +6.27700000E-05
   +2.10650000E-04  +1.47400000E-04  +5.66800000E-05  -4.28100000E-05  -1.11710000E-04
   -7.36000000E-05  +2.34110000E-04  +3.86900000E-05  -7.96200000E-05  -1.59920000E-04
   +9.99000000E-06  +3.43600000E-05  -2.38290000E-04  -2.40660000E-04  -6.99500000E-05
   -6.97700000E-05  -2.61390000E-04  +8.12840000E-04  -7.45380000E-04  -9.11250000E-04
   -5.67380000E-04  -2.97138000E-03  -8.12594000E-03  +1.18240000E-03  +2.73140000E-04
   -1.65080000E-04  +5.04700000E-05  +3.67660000E-04  -4.56300000E-05  -1.72580000E-04
   -4.44300000E-05  +3.13090000E-04  -8.85900000E-05  -2.15484000E-03  -1.53835000E-03
   +4.68880000E-04  +7.64578000E-03  -2.82770000E-03  -8.27903000E-03  +2.03730000E-04
   +6.81780000E-04  -3.19670000E-04  -1.35740000E-04  +4.66200000E-05  -1.26600000E-05
   +1.40000000E-05  +5.19300000E-05  +1.58000000E-05  -1.57000000E-05  -2.21000000E-06
   -2.10600000E-05  +4.68200000E-05  +1.31000000E-06  +4.71600000E-05  +2.75300000E-05
   +4.61900000E-05  -2.99000000E-06  -4.67900000E-05  +5.93000000E-06  +1.24600000E-05
   -5.89400000E-05  +6.05900000E-05  +3.59000000E-06  +8.13000000E-06  -5.42000000E-05
   -7.32000000E-06  +3.64700000E-05  -2.18000000E-06  +3.40000000E-06  +5.50000000E-05
   -3.12600000E-05  -3.64300000E-05  +5.32000000E-06  -3.62800000E-05  -3.42900000E-05
   -5.62200000E-05  +6.83900000E-05  +4.14900000E-05  -4.81700000E-05  +3.15000000E-06
   -1.07810000E-04  +4.33000000E-06  +7.38900000E-05  -5.26400000E-05  -9.57400000E-05
   +4.01150000E-04  +7.24200000E-05  +2.41652000E-03  +7.91840000E-04  +1.23483000E-03
   -1.04058000E-03  -2.59910000E-04  +2.02670000E-04  +4.98700000E-05  -3.72550000E-04
   -9.42200000E-05  +1.17828000E-03  +1.83503000E-03  +5.75500000E-04  -8.92110000E-04
   -2.67595000E-03  +2.68871000E-03  -1.81950000E-04  -3.46000000E-05  -1.51590000E-04
   +5.05441000E-03  +3.89319000E-03  -5.11383000E-03  -2.72873000E-02  -4.38530700E-02
   -6.55350000E-04  +3.62954000E-02  +1.48752000E-03  -1.48436100E-02  -1.79145000E-02
   +5.14241100E-02  -1.03210000E-04  -2.98100000E-05  +8.54000000E-05  -9.69600000E-05
   -1.79550000E-04  -1.66210000E-04  +1.01750000E-04  +2.72000000E-05  +8.93000000E-05
   -2.53400000E-05  -3.82200000E-05  -4.67800000E-05  -7.43400000E-05  -5.27300000E-05
   -6.80000000E-06  +3.96000000E-05  +2.12960000E-04  +3.57300000E-05  -2.72870000E-04
   -2.24100000E-05  +2.63080000E-04  +1.72030000E-04  -2.28700000E-05  -6.66600000E-05
   +1.22380000E-04  +1.43500000E-04  +7.95000000E-06  -3.60800000E-05  -1.33705000E-03
   -6.47010000E-04  +1.73067000E-03  +1.10790000E-04  +3.90449000E-03  -2.04565000E-03
   +1.23483200E-02  +5.98711000E-03  -1.44560000E-03  -2.59342000E-03  -1.88240000E-04
   -1.74773000E-03  +6.70050000E-04  +3.27720000E-04  +9.77390000E-04  -5.06700000E-05
   -9.56900000E-04  +2.58770000E-04  +4.50189000E-03  -1.71497000E-03  -1.17643900E-02
   -1.90161500E-02  -5.46768000E-03  +8.38880000E-04  -1.17869000E-03  +2.93460000E-04
   +1.05440000E-04  -9.07800000E-05  +1.41400000E-04  +1.75000000E-06  -2.22900000E-05
   +9.12000000E-06  +2.22000000E-06  +1.37000000E-06  +3.09000000E-06  -4.94200000E-05
   +5.05000000E-06  -5.63000000E-05  +1.86800000E-05  -8.57200000E-05  -3.25000000E-05
   +8.86100000E-05  -2.43400000E-05  -1.73400000E-05  +6.53600000E-05  -6.89200000E-05
   -4.80000000E-07  -3.73000000E-06  +6.69400000E-05  +1.13200000E-05  -4.27200000E-05
   +1.15000000E-05  -3.17900000E-05  -2.93000000E-06  +2.92700000E-05  -1.19930000E-04
   +3.93000000E-06  +5.78900000E-05  +3.93500000E-05  +4.64600000E-05  -4.15000000E-06
   -1.09250000E-04  +1.32290000E-04  +2.23500000E-05  +8.79900000E-05  +1.46500000E-04
   +1.10700000E-05  +2.48680000E-04  -6.88630000E-04  -1.39410000E-03  -1.09418000E-03
   -2.98649000E-03  -1.35900000E-03  -1.15018000E-03  +1.43325000E-03  +7.16140000E-04
   -3.10110000E-04  -1.72490000E-04  -2.72530000E-04  -5.89090000E-04  +3.34151000E-03
   +2.58542000E-03  -4.91087000E-03  +2.09458000E-03  +5.78621000E-03  -7.86123000E-03
   +2.75220000E-04  -3.64430000E-04  +1.87170000E-04  -2.08585300E-02  -3.51101000E-03
   +2.20804500E-02  +9.76658800E-02  -9.14194000E-03  -9.35201600E-02  +2.34808100E-02
   -9.64209000E-03  -9.64346000E-03  -9.07268600E-02  +2.31949500E-02  +9.49053000E-02
end_hess

