# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -959.73924710    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -4.88234120E+00  +1.46534447E+00  +1.86464493E+00
   006   -3.02558522E+00  +1.58444945E+00  +1.02854750E-02
   006   -3.20393710E+00  -1.04605203E-01  -1.99411079E+00
   006   -5.14805510E+00  -1.84643709E+00  -2.15308306E+00
   006   -6.98957755E+00  -1.92439626E+00  -2.85164796E-01
   006   -6.84610114E+00  -2.58080397E-01  +1.73228859E+00
   006   -8.86423098E-01  +3.53489034E+00  +2.80620928E-02
   006   -1.34221096E+00  +5.34316141E+00  -2.20330837E+00
   008   -8.94713527E+00  -3.58530513E+00  -3.34664267E-01
   006   +1.67465142E+00  +2.21642141E+00  -1.85328107E-01
   006   +2.28052480E+00  +4.94453257E-02  +1.49798062E+00
   006   +4.82696870E+00  -8.98059164E-01  +1.50324030E+00
   006   +6.45093803E+00  -3.57101786E-01  -5.45040315E-01
   006   +5.76522748E+00  +1.50606366E+00  -2.18486381E+00
   006   +3.41638811E+00  +2.79990341E+00  -1.96906470E+00
   008   +9.93251582E-01  -1.93185978E-01  +3.79966353E+00
   008   +5.15084694E+00  -4.97529579E+00  +5.31233106E-01
   008   +8.57402588E+00  -1.71004108E+00  -7.62174869E-01
   006   -8.78708224E-01  +5.17505216E+00  +2.42995598E+00
   001   -8.84367657E+00  -4.60274189E+00  -1.82583715E+00
   001   -5.22015548E+00  -3.14887346E+00  -3.73291786E+00
   001   -1.76821278E+00  -1.13739684E-01  -3.45043789E+00
   001   -4.81808250E+00  +2.72321105E+00  +3.47176381E+00
   001   -8.27636445E+00  -3.32844046E-01  +3.18960723E+00
   001   -3.21664068E+00  +6.17237723E+00  -2.00934329E+00
   001   +3.06217208E-02  +6.88147640E+00  -2.22631311E+00
   001   -1.27264012E+00  +4.36764992E+00  -4.01430563E+00
   001   -8.01213061E-01  +4.05388342E+00  +4.14897208E+00
   001   +7.45808093E-01  +6.44183430E+00  +2.39304244E+00
   001   -2.57848788E+00  +6.33807357E+00  +2.50733900E+00
   001   +3.02524903E+00  +4.24939834E+00  -3.34980907E+00
   001   +7.04434272E+00  +1.98666769E+00  -3.70654518E+00
   001   +5.59580847E+00  -1.68031075E+00  +3.21929255E+00
   001   +1.43931011E+00  -1.58780006E+00  +1.72652999E-01
   001   +7.98810848E+00  -3.40951292E+00  -2.42789907E-01
   001   +1.76220948E+00  +9.01353914E-01  +5.01617482E+00
   001   +5.09465146E+00  -5.94218981E+00  +2.05901142E+00
   008   +9.41125420E-01  -4.10625021E+00  -1.41238544E+00
   001   -4.20880053E-01  -4.98479854E+00  -6.10743204E-01
   001   +2.60422686E+00  -4.80435250E+00  -7.06588023E-01
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +5.10000000E-07  +2.11000000E-06  +2.80000000E-07
   +2.10000000E-07  +5.10000000E-07  -1.50000000E-07
   -5.40000000E-07  -6.90000000E-07  +9.60000000E-07
   -9.20000000E-07  -4.60000000E-07  +2.49000000E-06
   -4.60000000E-07  +1.10000000E-06  +2.90000000E-06
   +2.20000000E-07  +2.37000000E-06  +1.79000000E-06
   +4.80000000E-07  +1.80000000E-07  -1.93000000E-06
   +4.20000000E-07  -1.20000000E-06  -2.93000000E-06
   -7.90000000E-07  +1.38000000E-06  +4.39000000E-06
   +2.30000000E-07  -5.00000000E-07  -1.33000000E-06
   +2.60000000E-07  +7.60000000E-07  -3.50000000E-07
   +1.90000000E-07  -4.00000000E-08  +8.00000000E-08
   -2.50000000E-07  -2.08000000E-06  -6.00000000E-07
   -4.10000000E-07  -2.48000000E-06  -1.99000000E-06
   +2.60000000E-07  -1.90000000E-06  -2.35000000E-06
   +5.70000000E-07  +2.26000000E-06  +2.40000000E-07
   -9.30000000E-07  -6.80000000E-07  +2.27000000E-06
   -5.30000000E-07  -2.04000000E-06  -3.60000000E-07
   +1.38000000E-06  +1.69000000E-06  -2.93000000E-06
   -1.30000000E-06  +4.30000000E-07  +5.02000000E-06
   -1.36000000E-06  -1.53000000E-06  +3.38000000E-06
   -7.60000000E-07  -1.95000000E-06  +6.70000000E-07
   +1.15000000E-06  +3.11000000E-06  -5.00000000E-07
   +5.10000000E-07  +3.57000000E-06  +2.13000000E-06
   +6.30000000E-07  -7.30000000E-07  -3.10000000E-06
   +7.60000000E-07  -1.44000000E-06  -4.22000000E-06
   -9.00000000E-08  -2.41000000E-06  -2.36000000E-06
   +1.47000000E-06  +2.81000000E-06  -2.19000000E-06
   +1.62000000E-06  +1.41000000E-06  -4.06000000E-06
   +1.58000000E-06  +2.10000000E-06  -3.35000000E-06
   +1.00000000E-08  -2.71000000E-06  -3.18000000E-06
   -4.20000000E-07  -3.66000000E-06  -2.44000000E-06
   +3.10000000E-07  +1.11000000E-06  +3.30000000E-07
   -2.20000000E-07  -8.00000000E-08  +9.20000000E-07
   -8.60000000E-07  -1.40000000E-06  +8.60000000E-07
   +1.09000000E-06  +2.91000000E-06  -6.90000000E-07
   -7.10000000E-07  +6.10000000E-07  +3.04000000E-06
   -1.38000000E-06  -1.08000000E-06  +2.63000000E-06
   -1.08000000E-06  -4.30000000E-07  +3.62000000E-06
   -8.50000000E-07  -9.80000000E-07  +3.01000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +5.20985680E-01  +2.04116670E-01  +4.74157180E-01  -1.41696280E-01  +2.14910270E-01
   +5.83711090E-01  -2.06981960E-01  -1.10162800E-02  +1.38785060E-01  +4.99600820E-01
   -4.77966700E-02  -1.03571690E-01  +3.24480000E-03  +1.54070860E-01  +4.39697140E-01
   +9.09706800E-02  -3.57348900E-02  -2.12298820E-01  -1.50041660E-01  +1.57317440E-01
   +5.51026920E-01  +3.32911500E-02  +2.60345300E-02  +7.97395000E-03  -1.12335720E-01
   -9.04254000E-03  +3.37141700E-02  +5.67231290E-01  +5.43189200E-02  +2.64388600E-02
   -3.45320500E-02  -4.64822500E-02  -1.81298760E-01  -9.48771200E-02  +1.99658140E-01
   +4.54363840E-01  +4.46875600E-02  -3.62475000E-03  -4.50238600E-02  -1.56743700E-02
   -1.33520640E-01  -2.27541660E-01  -1.83294360E-01  +1.78323970E-01  +5.63611160E-01
   -5.34251000E-02  -2.28866300E-02  +2.43332500E-02  +2.23234800E-02  -3.69812200E-02
   -6.37594800E-02  -2.32691280E-01  -1.18738540E-01  +3.31425000E-02  +5.24990220E-01
   -2.51751800E-02  -1.47847700E-02  +1.27978200E-02  -8.25755000E-03  -3.02162800E-02
   -4.04329900E-02  -1.54946450E-01  -1.98134520E-01  -1.25981700E-02  +2.13642640E-01
   +4.74908190E-01  +2.22729500E-02  +1.02223400E-02  -1.35099800E-02  -2.67560100E-02
   -9.34204000E-03  +2.53937200E-02  -1.39991200E-02  -5.24173600E-02  -1.11867220E-01
   -1.50759390E-01  +2.21030360E-01  +5.67365010E-01  +2.50424100E-02  -6.33138000E-03
   -3.35616600E-02  -1.04331800E-02  +1.65807900E-02  +2.69150000E-02  -4.30571800E-02
   -3.45851900E-02  +2.81043000E-03  -1.97822660E-01  +1.80281000E-03  +1.40585480E-01
   +5.42255760E-01  -3.77374700E-02  -3.43816500E-02  -6.33973000E-03  +1.61586900E-02
   -1.27001700E-02  -2.58928000E-02  -4.05061000E-03  +2.44697400E-02  +3.27200800E-02
   -4.17203000E-02  -1.06973820E-01  -3.87879000E-03  +1.98432160E-01  +4.78090650E-01
   -7.36024700E-02  -4.00702400E-02  +2.95950400E-02  +2.62388300E-02  -2.64342000E-02
   -6.77456000E-02  +4.35909400E-02  +6.59121000E-02  +4.08575100E-02  +8.47711300E-02
   -5.15394900E-02  -2.24064020E-01  -1.49484430E-01  +1.96550500E-01  +5.80876720E-01
   -2.36048430E-01  -1.54076200E-01  -1.23970500E-02  -3.83184700E-02  -5.92939000E-03
   +4.09715500E-02  -1.71527100E-02  -2.52123700E-02  -1.73406900E-02  +3.15124500E-02
   +2.43567400E-02  +6.12117000E-03  -1.11561920E-01  +2.87444000E-03  +4.71653700E-02
   +5.65957980E-01  -1.17724410E-01  -1.96690730E-01  -5.14923900E-02  -3.38277900E-02
   +2.32963400E-02  +5.62105300E-02  -2.39104300E-02  -4.42331100E-02  -2.82523300E-02
   +4.90916200E-02  +2.71130400E-02  -2.95493400E-02  -3.85284000E-02  -1.73481040E-01
   -9.20872700E-02  +2.17275060E-01  +4.49468720E-01  +3.53119800E-02  -1.11054500E-02
   -1.14348390E-01  +5.31958000E-03  +2.69204000E-02  +3.54738100E-02  -1.59022100E-02
   -2.63096200E-02  -2.06925500E-02  +3.83613700E-02  -2.13441000E-03  -3.61734600E-02
   -6.08654000E-03  -1.36788710E-01  -2.43433680E-01  -1.88710060E-01  +1.83930500E-01
   +5.75149800E-01  -1.64703600E-02  -1.54971400E-02  +2.48470000E-04  -1.28564360E-01
   -4.55951700E-02  +7.09636000E-03  -2.53578000E-03  -7.37626000E-03  -5.21458000E-03
   +4.41535000E-03  -9.35200000E-05  +1.44756000E-03  -1.95055000E-03  -1.07540000E-04
   +1.12090000E-03  +1.43148000E-03  -1.42298000E-03  +4.49881000E-03  +4.68904820E-01
   -4.38986000E-03  +1.68267000E-03  +3.59529000E-03  -5.12220600E-02  -1.17975200E-01
   -6.34810000E-03  -1.75144900E-02  -1.69530400E-02  -3.09093000E-03  +1.93600000E-05
   +2.06528000E-03  -4.03844000E-03  -5.73930000E-04  -7.16880000E-04  +1.05160000E-04
   -6.07340000E-04  +3.45245000E-03  -2.91007000E-03  +2.22497000E-03  +4.72512690E-01
   +1.32727800E-02  +1.46913700E-02  +5.62370000E-03  +4.58486000E-03  -9.13798000E-03
   -8.28067600E-02  -1.97119200E-02  -1.53605000E-02  +4.01361000E-03  +1.43347000E-03
   -4.91067000E-03  -2.63602000E-03  +1.54760000E-04  -8.04600000E-04  -1.72588000E-03
   +4.28727000E-03  -1.88624000E-03  -7.00220000E-04  -1.75253000E-03  +3.10006000E-03
   +4.71273540E-01  -6.36150000E-04  -1.77624000E-03  -9.62030000E-04  +8.43590000E-04
   -1.65545400E-02  +1.94906000E-02  -3.29230000E-04  -1.30338000E-03  +6.04580000E-04
   -9.17500000E-05  +5.25920000E-04  +2.54440000E-04  +4.60970000E-04  +7.28520000E-04
   +5.88620000E-04  -1.40637000E-03  +4.07200000E-05  -9.34270000E-04  -7.65458200E-02
   +6.96431000E-03  -9.47883000E-03  +5.83706030E-01  +1.47832000E-03  -1.12378000E-03
   -1.08408000E-03  -5.60156000E-03  -2.34085400E-02  +1.99170500E-02  -3.14930000E-04
   -9.90710000E-04  +1.23866000E-03  +5.23900000E-05  +8.44120000E-04  +2.28340000E-04
   +1.46200000E-04  +6.03540000E-04  +6.74520000E-04  -1.02818000E-03  -1.68380000E-04
   -1.02166000E-03  +1.11039600E-02  -1.10422770E-01  +4.66846600E-02  +1.45184800E-02
   +5.34811170E-01  -7.67830000E-04  -2.49300000E-04  -2.08690000E-04  +6.07600000E-03
   +8.11940000E-03  -1.80666000E-03  -1.67365000E-03  -1.20912000E-03  -9.42900000E-05
   +2.85740000E-04  -2.06900000E-05  -2.15200000E-04  +2.02780000E-04  +1.81820000E-04
   +3.47440000E-04  -5.38200000E-05  -2.52480000E-04  -1.52930000E-04  -1.26784800E-02
   +4.35851000E-02  -1.31336970E-01  -2.01750200E-02  +6.55930900E-02  +5.23578040E-01
   +9.83920000E-04  -1.43470000E-04  +3.97818000E-03  -1.99169000E-03  -2.26956000E-03
   -2.80465000E-03  +3.64048000E-03  +1.92260000E-03  +6.58518000E-03  -3.53226900E-02
   -3.56275000E-02  +2.13075000E-03  -2.10689500E-01  -1.11372090E-01  +3.60118100E-02
   -3.29144000E-03  -1.49764800E-02  -7.93842000E-03  +1.18941000E-03  +8.77750000E-04
   +4.84680000E-04  -1.04523000E-03  -5.94320000E-04  -4.41830000E-04  +2.83381190E-01
   +3.48618000E-03  +4.44537000E-03  -5.00156000E-03  -2.83589000E-03  -9.59540000E-04
   +2.84879000E-03  -2.68350000E-03  +1.97477000E-03  -4.18137000E-03  -1.47766000E-02
   -2.57833000E-03  -5.04970000E-04  -1.37239220E-01  -1.63707890E-01  -7.74898000E-03
   -3.53620500E-02  -3.00287400E-02  -1.07392800E-02  +1.31057000E-03  +3.47950000E-04
   +1.08054000E-03  -1.01393000E-03  -6.21710000E-04  -4.02930000E-04  +1.66338690E-01
   +3.67456670E-01  +8.81346000E-03  -9.48500000E-04  -5.72805000E-03  -2.87950000E-03
   +2.78917000E-03  +5.25752000E-03  +7.01850000E-04  -8.95873000E-03  -4.78332000E-03
   +2.90667800E-02  +2.20382700E-02  +6.83146000E-03  +5.31790000E-04  -3.73465900E-02
   -9.40316500E-02  -3.44685200E-02  -3.26428900E-02  +2.26748000E-03  -2.39510000E-04
   +3.41760000E-04  +2.50530000E-04  -1.78930000E-04  -1.49780000E-04  -1.23070000E-04
   -6.11082300E-02  +2.73782130E-01  +4.64444290E-01  -6.80680000E-04  -3.29500000E-04
   -1.11525000E-03  -3.30511900E-02  +1.52454000E-03  +4.46454000E-03  +3.64240000E-04
   +3.90020000E-04  -2.85880000E-04  +1.74180000E-04  +4.78160000E-04  +6.62590000E-04
   -5.76880000E-04  -5.28490000E-04  -3.75600000E-05  +2.40560000E-04  -3.45720000E-04
   +5.87640000E-04  -1.48558340E-01  +4.05238500E-02  +2.77434000E-03  -8.57672000E-03
   +9.34831000E-03  -4.79485000E-03  +6.95770000E-04  +6.92880000E-04  +5.35600000E-05
   +5.71859000E-01  -2.20194000E-03  -2.38605000E-03  -1.44541000E-03  -1.71658600E-02
   +1.21554700E-02  +3.11017000E-03  -2.12027000E-03  -5.69290000E-04  -6.69000000E-06
   +4.79500000E-05  -4.34120000E-04  +2.83810000E-04  +5.75900000E-05  +3.64760000E-04
   +1.75800000E-04  -9.76500000E-05  -8.80320000E-04  +8.63390000E-04  +3.70314400E-02
   -9.62301300E-02  +8.68199000E-03  +2.19245400E-02  -1.31009900E-02  +6.36600000E-05
   -4.79230000E-04  -5.10070000E-04  -1.10530000E-04  -6.64047500E-02  +3.78649210E-01
   +5.04130000E-04  +5.49350000E-04  -3.69630000E-04  +3.94527000E-03  +6.33750000E-04
   -9.76800000E-04  -1.94087000E-03  -9.12100000E-04  +3.82110000E-04  +1.06200000E-05
   +3.17850000E-04  -1.29970000E-04  +2.82340000E-04  +4.29380000E-04  +1.34740000E-04
   -1.93080000E-04  -2.07040000E-04  -3.00410000E-04  +1.05177100E-02  +1.63879000E-03
   -7.67899300E-02  -2.35377100E-02  +1.26752700E-02  +1.96385000E-03  -4.40100000E-04
   -4.77780000E-04  -2.06000000E-06  -1.88395280E-01  -1.52134290E-01  +4.83948230E-01
   +4.35710000E-04  -9.67700000E-05  -4.29600000E-05  -1.20920000E-04  +1.24249000E-03
   -3.45640000E-04  -8.46690000E-04  -6.02620000E-04  -6.81360000E-04  +4.89650000E-04
   +7.54730000E-04  -2.57630000E-04  +1.06190000E-04  +4.18060000E-04  +3.63680000E-04
   -5.07980000E-04  -4.51110000E-04  +8.62000000E-06  -1.76783000E-03  +1.99062200E-02
   -2.15822700E-02  -5.36772000E-03  +2.19651000E-03  +2.28579000E-03  -1.71140000E-04
   -1.01080000E-04  +2.74800000E-05  -8.58049400E-02  +5.19400100E-02  -7.50430000E-03
   +5.03191560E-01  +1.15570000E-04  -1.87780000E-04  +1.17360000E-04  -3.94400000E-05
   -2.97100000E-05  +8.26300000E-05  +1.44610000E-04  -4.76000000E-05  -2.22090000E-04
   -2.50010000E-04  +2.48100000E-04  +1.19160000E-04  +5.85760000E-04  +2.80760000E-04
   -2.17280000E-04  -1.25800000E-05  +3.68000000E-05  +6.09400000E-05  +5.15123000E-03
   -1.39366100E-02  +6.07898000E-03  +1.40483000E-03  +4.84960000E-04  -1.00653000E-03
   -4.60090000E-04  -2.98250000E-04  +3.41000000E-06  +5.41550600E-02  -1.14055420E-01
   +3.32752500E-02  -1.14990950E-01  +3.69951270E-01  -1.86480000E-04  +2.58480000E-04
   +1.28440000E-04  -3.19140000E-04  -1.45372000E-03  -3.62920000E-04  +3.72800000E-05
   +1.10059000E-03  +7.16570000E-04  -3.71990000E-04  -3.29950000E-04  -2.05500000E-05
   +6.29890000E-04  +1.01260000E-04  -3.85860000E-04  +5.53510000E-04  +8.39900000E-04
   -2.55400000E-04  -2.88822000E-03  +2.29600000E-05  +3.76751000E-03  +2.20071000E-03
   -5.42120000E-04  -9.61300000E-05  -2.36590000E-04  -1.44480000E-04  -9.85900000E-05
   -3.58452000E-03  +7.98453800E-02  -1.21106810E-01  -7.63687000E-02  -6.66203500E-02
   +5.09239850E-01  -5.54400000E-04  -3.39930000E-04  -8.68000000E-06  +2.92950000E-04
   +1.36883000E-03  -1.04140000E-04  +6.05600000E-05  -2.61120000E-04  +9.30700000E-05
   -1.64100000E-04  -4.01130000E-04  +1.25430000E-04  -6.34500000E-05  +2.03300000E-05
   -7.44000000E-06  +5.72500000E-05  -8.98000000E-05  +1.18380000E-04  +6.53560000E-04
   -2.43712000E-03  +4.26573000E-03  +5.37340000E-04  -3.38510000E-04  +1.80880000E-04
   -8.66400000E-05  -1.96800000E-04  +3.99000000E-06  -6.69246000E-03  +1.50656800E-02
   -3.11525600E-02  -2.23922590E-01  +9.24284300E-02  +3.22416600E-02  +5.85640680E-01
   +2.10070000E-04  -3.54600000E-05  -3.46540000E-04  -1.87270000E-04  +7.22180000E-04
   +2.56900000E-05  -5.33500000E-05  -8.11100000E-05  +4.13000000E-05  -7.52400000E-05
   -4.52100000E-05  +2.25690000E-04  +6.76350000E-04  +8.05900000E-04  +3.62320000E-04
   -2.58680000E-04  -5.12330000E-04  -2.32580000E-04  +1.30488000E-03  -1.33764000E-03
   +5.46930000E-03  +7.50700000E-04  -4.80750000E-04  -1.49990000E-04  -9.15810000E-04
   -9.69290000E-04  -7.25800000E-05  +3.71796600E-02  -2.78853000E-03  +2.22329000E-03
   +6.08037200E-02  -1.17724930E-01  -2.52777000E-03  -1.23431910E-01  +2.27954770E-01
   +2.94330000E-04  +5.95200000E-05  +1.16310000E-04  +7.17570000E-04  -2.23060000E-04
   -3.13900000E-05  +1.35000000E-05  +1.82800000E-05  +3.47300000E-05  +1.73580000E-04
   +1.58520000E-04  -1.76450000E-04  -2.42830000E-04  -2.34230000E-04  -4.19000000E-06
   -4.57900000E-05  +5.60700000E-05  +2.59300000E-05  -6.12300000E-05  +3.11615000E-03
   -4.08187000E-03  -1.11478000E-03  +6.57270000E-04  +2.75480000E-04  +3.33980000E-04
   +3.60810000E-04  +1.48900000E-05  -2.15704800E-02  -7.78042000E-03  +1.65728100E-02
   -1.75831900E-02  +2.59034400E-02  -9.53547600E-02  -3.42149300E-02  -1.75268540E-01
   +6.53352740E-01  +5.45800000E-05  +1.87590000E-04  +3.09020000E-04  +5.33700000E-05
   -1.16698000E-03  -1.62100000E-05  +9.90100000E-05  +1.66390000E-04  +8.06900000E-05
   +2.15810000E-04  +1.75800000E-05  -2.63250000E-04  -6.74900000E-04  -6.96840000E-04
   -1.91440000E-04  +2.02510000E-04  +4.09390000E-04  +1.18050000E-04  -1.66474000E-03
   +1.11617000E-03  -1.02974000E-03  +2.59290000E-04  +2.66490000E-04  -2.53620000E-04
   +9.04920000E-04  +8.76850000E-04  +6.39200000E-05  -1.02488000E-03  -8.05417000E-03
   +6.82331000E-03  -2.00649000E-02  +4.97261000E-03  +2.35035300E-02  -1.68838510E-01
   -2.12837500E-02  +1.05326120E-01  +5.87838040E-01  +1.63830000E-04  +1.11130000E-04
   -1.35850000E-04  -5.19370000E-04  +2.94380000E-04  +1.52570000E-04  -1.72460000E-04
   +1.44200000E-05  -1.07700000E-04  +2.89300000E-05  +1.41730000E-04  +7.35000000E-06
   +1.95540000E-04  +2.47710000E-04  +1.36580000E-04  -9.70800000E-05  -1.87980000E-04
   -1.23250000E-04  -3.90550000E-04  -1.06269000E-03  -1.34604000E-03  -3.80650000E-04
   +3.29200000E-05  +5.09800000E-05  -2.67530000E-04  -2.17100000E-04  -4.44900000E-05
   -1.49152300E-02  -1.16386000E-02  +1.83471500E-02  -9.75720000E-04  +2.00888200E-02
   -1.50446600E-02  -9.64990000E-04  -5.54503100E-02  +3.81377700E-02  -2.09294740E-01
   +5.39718210E-01  -3.01570000E-04  -2.98750000E-04  -2.47110000E-04  +3.48640000E-04
   +1.12948000E-03  -1.24070000E-04  -1.75000000E-06  -1.64290000E-04  +4.11200000E-05
   -2.13650000E-04  -2.35800000E-04  +2.65700000E-04  +4.60140000E-04  +5.12250000E-04
   +8.40900000E-05  -1.22950000E-04  -3.26960000E-04  +3.42000000E-06  +1.51591000E-03
   -6.37580000E-04  +3.30854000E-03  +1.43120000E-04  -2.47150000E-04  +2.99970000E-04
   -6.70750000E-04  -7.02700000E-04  -2.98900000E-05  +1.75844000E-02  +2.44350100E-02
   -3.21894800E-02  +1.31909800E-02  -2.58112400E-02  +7.26714000E-03  +6.96225600E-02
   +2.53017600E-02  -2.25815460E-01  -1.00949600E-01  -2.33663970E-01  +5.10114120E-01
   +2.07460000E-04  +2.34390000E-04  +2.22540000E-04  -1.49970000E-04  -7.13360000E-04
   +1.48610000E-04  -2.32400000E-05  +1.38840000E-04  -4.77700000E-05  +2.13410000E-04
   +1.02580000E-04  -2.55140000E-04  -3.74300000E-04  -4.19120000E-04  -4.42900000E-05
   +1.09650000E-04  +2.49420000E-04  -1.80100000E-05  +1.37863000E-03  +1.28401000E-03
   +1.59943000E-03  +2.13830000E-04  -2.50360000E-04  -3.06600000E-05  +5.45200000E-04
   +5.60250000E-04  +1.39700000E-05  -4.73602300E-02  -1.14135000E-02  +3.99391500E-02
   -2.24017000E-03  +2.16178500E-02  -2.50287000E-03  +3.64828100E-02  +2.16041000E-03
   -1.79596000E-03  -1.34087140E-01  +4.12596300E-02  +8.14556000E-03  +5.68401310E-01
   -9.26100000E-05  -1.14990000E-04  +1.88750000E-04  +1.14571000E-03  -1.83130000E-04
   -4.41410000E-04  +2.30970000E-04  -4.41500000E-05  -9.62600000E-05  -1.42600000E-04
   -1.21100000E-04  +8.87500000E-05  +1.15870000E-04  -2.82100000E-05  -1.08780000E-04
   +2.34200000E-05  +1.07980000E-04  +4.51200000E-05  +1.25264000E-03  +3.74039000E-03
   +6.76378000E-03  +6.40520000E-04  -5.70150000E-04  +3.20000000E-07  -6.66400000E-05
   -5.39100000E-05  +2.32000000E-05  +1.71898100E-02  +2.58267600E-02  -2.73742700E-02
   -5.29365000E-03  -2.66230800E-02  -3.16767000E-03  -1.65348100E-02  -1.88647400E-02
   +2.06365300E-02  +7.03805700E-02  -2.41065790E-01  +1.47446840E-01  -1.53285050E-01
   +4.66038160E-01  +3.10480000E-04  +2.68640000E-04  +1.91230000E-04  +1.04077000E-03
   -9.91500000E-04  -3.43120000E-04  +1.16100000E-05  -6.84200000E-05  -2.03410000E-04
   +4.08900000E-05  +1.08680000E-04  -2.55700000E-05  -4.19100000E-05  -4.60700000E-05
   +4.93300000E-05  -2.03600000E-05  +7.17900000E-05  -1.34860000E-04  +3.28371000E-03
   +5.83940000E-03  -9.18800000E-05  -1.06257000E-03  +5.99200000E-04  -7.30300000E-05
   +5.76800000E-05  +6.22800000E-05  +6.82000000E-06  +1.78867300E-02  -1.96486400E-02
   +1.23485300E-02  +1.17205000E-03  +7.68312000E-03  -1.32372000E-03  +6.81600000E-03
   +3.09591100E-02  -2.97476800E-02  -4.02490200E-02  +1.67920510E-01  -2.20394690E-01
   -1.52468490E-01  -2.60107670E-01  +5.46702560E-01  -6.32660000E-04  -7.85690000E-04
   -4.85440000E-04  -1.10568000E-03  +2.53673000E-03  +1.71420000E-04  +1.20950000E-04
   +2.16910000E-04  +4.48040000E-04  -3.14560000E-04  -3.22000000E-04  +2.18690000E-04
   +7.02840000E-04  +6.28980000E-04  -4.36400000E-05  -7.23600000E-05  -3.67150000E-04
   +1.67620000E-04  -1.81374700E-02  -1.94435000E-03  +2.24100500E-02  -2.43830000E-03
   -1.66610000E-04  +1.68253000E-03  -8.41870000E-04  -8.01610000E-04  -7.02600000E-05
   -2.40246260E-01  -1.63461100E-02  +1.41680030E-01  -2.65281000E-03  -4.24252300E-02
   -5.08634000E-03  -1.78023100E-02  -1.06530200E-02  +1.18763200E-02  -8.47740000E-04
   +4.07309000E-02  -4.95682100E-02  -2.31606450E-01  +7.33476900E-02  +4.90563400E-02
   +5.85277700E-01  +6.36830000E-04  +7.13940000E-04  +2.61770000E-04  +1.28825000E-03
   -2.47670000E-03  -9.88730000E-04  -1.35610000E-04  -2.42800000E-05  -1.98170000E-04
   +1.19750000E-04  +2.83840000E-04  -1.89400000E-05  -2.34300000E-04  -8.15400000E-05
   +8.44800000E-05  -1.45200000E-05  +6.85400000E-05  -2.12920000E-04  +9.71867000E-03
   +1.02999600E-02  -9.05563000E-03  +1.22702000E-03  -1.13813000E-03  -9.67930000E-04
   +2.11280000E-04  +1.60300000E-04  +4.93500000E-05  -5.03183900E-02  -1.14964880E-01
   +8.25342000E-02  -5.63803000E-03  +1.34584000E-03  +2.91182400E-02  -5.84260000E-03
   +1.73156000E-03  -2.95870000E-04  +2.61541200E-02  -2.26597200E-02  +5.32655000E-03
   +1.03148750E-01  -1.28331260E-01  +8.16605000E-03  -1.22320180E-01  +4.47894170E-01
   +2.10610000E-04  +2.28060000E-04  +3.60280000E-04  -1.75771000E-03  -1.13081000E-03
   +1.71740000E-04  -2.66890000E-04  -2.83220000E-04  -7.61820000E-04  +1.26790000E-04
   +3.88650000E-04  +6.81300000E-05  -4.25000000E-04  -3.33130000E-04  +3.22500000E-05
   +9.30000000E-06  +8.57000000E-06  +5.14600000E-05  +6.17399000E-03  -8.83010000E-04
   +1.94909000E-03  -2.97780000E-04  -3.81820000E-04  -6.54980000E-04  +3.92120000E-04
   +3.69780000E-04  +7.91000000E-05  +1.62304330E-01  +6.65383800E-02  -2.50379980E-01
   +1.63125700E-02  +3.27374200E-02  -1.44353500E-02  +1.64333400E-02  +6.16412000E-03
   -1.06188100E-02  -2.70111800E-02  -2.33224000E-03  +3.20439600E-02  +2.41859000E-03
   +3.20157200E-02  -1.03788530E-01  -1.60710910E-01  -2.70964100E-01  +5.37845620E-01
   -1.40298000E-03  +4.15200000E-04  -8.37970000E-04  -1.55019000E-03  -1.09820000E-04
   -2.09957000E-03  +4.16820000E-04  +1.47857000E-03  +8.82490000E-04  -8.51560000E-04
   -7.93990000E-04  +3.65400000E-04  +7.96170000E-04  -4.26900000E-05  -7.18420000E-04
   +7.34360000E-04  +9.46470000E-04  -2.93900000E-05  -1.00414000E-03  -4.01210000E-04
   +6.93330000E-04  +4.95380000E-04  -3.29960000E-04  -2.64170000E-04  -4.81600000E-04
   -4.29210000E-04  -4.02300000E-05  +6.42200000E-05  -7.43272000E-03  +4.30628000E-03
   -1.13927950E-01  -1.32690500E-02  +5.75467600E-02  -2.81590700E-02  -2.44367000E-03
   +4.76821600E-02  -3.50555000E-03  +6.16497000E-03  -1.77950000E-04  -2.85872000E-03
   +1.55093000E-03  -1.09577000E-03  +4.92943000E-03  +3.32870000E-04  -1.58165000E-03
   +2.63171300E-01  +2.18200000E-04  +7.10000000E-06  -2.08420000E-04  -2.65610000E-04
   -1.82260000E-04  +4.63150000E-04  +3.26000000E-06  -1.48810000E-04  -1.93230000E-04
   +3.30450000E-04  +2.96460000E-04  -4.30800000E-05  -3.47840000E-04  -1.42460000E-04
   +2.36230000E-04  -1.08940000E-04  -4.67500000E-05  +8.87100000E-05  -9.25850000E-04
   +7.31000000E-04  -2.92738000E-03  -3.87480000E-04  +4.46750000E-04  +2.38370000E-04
   +3.32060000E-04  +3.61930000E-04  +9.10000000E-06  -1.76587400E-02  -1.05766000E-03
   +2.66135500E-02  -4.75186000E-03  -6.48448800E-02  -5.40406000E-03  +2.18252000E-03
   +3.84081000E-03  -8.75680000E-03  +1.83342000E-03  +1.37362000E-03  +7.53270000E-04
   -3.46320000E-04  +1.65354000E-03  -1.19654000E-03  +7.10612000E-03  -3.38076000E-03
   +2.87808000E-03  +1.66730440E-01  +2.72144750E-01  -3.81350000E-04  -2.74570000E-04
   -7.45690000E-04  -9.63010000E-04  +1.06807000E-03  -7.22890000E-04  +2.81880000E-04
   +2.25640000E-04  -1.50810000E-04  -3.24000000E-04  +9.40000000E-07  +4.51290000E-04
   +3.18820000E-04  +2.70000000E-07  -3.29940000E-04  -5.08600000E-05  -1.04270000E-04
   +3.21360000E-04  +1.70420000E-03  -1.73806000E-03  +6.63730000E-04  -4.03530000E-04
   +1.53890000E-04  +3.63670000E-04  -3.55900000E-04  -2.75450000E-04  +9.15700000E-05
   +1.60634800E-02  -2.27096000E-03  -2.56105100E-02  +9.97124400E-02  +2.70851700E-02
   -2.07661500E-01  +8.95617000E-03  +4.72057000E-03  -1.93183400E-02  -1.53685000E-03
   -9.02610000E-04  +5.09666000E-03  -2.40021000E-03  +2.01718000E-03  -7.84780000E-04
   -3.45430000E-04  +4.35596000E-03  -5.09388000E-03  +2.00115600E-02  +1.95197940E-01
   +5.29869770E-01  +1.49520000E-04  +6.07000000E-05  +8.25500000E-05  -2.91600000E-04
   -3.86150000E-04  -9.19100000E-05  -1.34770000E-04  +1.47150000E-04  -3.33790000E-04
   -2.59910000E-04  +5.59460000E-04  +1.75500000E-05  +6.59660000E-04  +3.14310000E-04
   -2.85120000E-04  -5.34600000E-05  +6.36500000E-05  +6.82900000E-05  -1.19130000E-04
   +3.99480000E-04  -7.36100000E-05  +1.37660000E-04  +4.42100000E-05  +6.94000000E-06
   -4.11700000E-04  -1.77040000E-04  +2.78000000E-06  +5.57890000E-04  -2.36936000E-03
   +2.48795000E-03  +2.34009000E-03  +8.40536000E-03  +3.36386000E-03  -7.78413000E-03
   -6.43852000E-03  -2.29773000E-03  -1.61677300E-02  +8.92370000E-03  +4.84670000E-04
   +1.34642000E-03  -3.17475000E-03  +1.22797000E-03  +5.13410000E-04  +6.86440000E-04
   -9.17030000E-04  +2.76080000E-04  -7.32300000E-05  -6.94310000E-04  +6.93509600E-02
   +4.22000000E-06  +1.76750000E-04  +2.96660000E-04  -1.92200000E-04  -8.58090000E-04
   -1.66500000E-05  -2.12100000E-05  +6.09300000E-05  -7.14900000E-05  +2.04760000E-04
   +1.38180000E-04  -3.22410000E-04  -7.57750000E-04  -8.04500000E-04  -2.02240000E-04
   +1.77420000E-04  +4.02440000E-04  +1.71580000E-04  -1.76164000E-03  +4.48850000E-04
   -7.06000000E-04  +4.34300000E-04  +6.72200000E-05  -2.44780000E-04  +9.65660000E-04
   +1.03715000E-03  +6.18100000E-05  -8.42004000E-03  -1.14888500E-02  +8.36679000E-03
   +1.57372500E-02  +1.58660000E-02  +1.41991700E-02  -2.12875000E-03  +2.71117000E-02
   -1.20752600E-02  -9.90000000E-03  -2.95524400E-02  +2.26585600E-02  -1.33437600E-02
   +1.27750200E-02  -7.91593000E-03  +1.47829800E-02  -4.29979000E-03  -7.89939000E-03
   -1.16934000E-03  -3.56930000E-04  -4.25201000E-03  +1.72014200E-02  +2.00388760E-01
   +6.30300000E-05  +3.56400000E-05  +5.34600000E-05  -1.85690000E-04  -1.20780000E-04
   -4.78000000E-06  -8.92400000E-05  -1.59000000E-06  -1.79890000E-04  -7.23000000E-05
   +2.40960000E-04  -2.42600000E-05  +1.58840000E-04  +4.59600000E-05  -1.44040000E-04
   -3.01900000E-05  -7.68000000E-06  +1.00510000E-04  -1.44600000E-04  +9.18100000E-05
   +1.23480000E-04  +9.76300000E-05  +6.14000000E-06  +1.26000000E-06  -4.81400000E-05
   +6.64000000E-06  +4.10600000E-05  -2.00269000E-03  -2.14318000E-03  +1.72796000E-03
   +5.20694000E-03  +6.34815000E-03  +4.27118000E-03  -2.29155000E-03  +4.76852000E-03
   -2.33064800E-02  +5.70505000E-03  +2.49860000E-03  +6.99990000E-03  -1.15340000E-03
   +3.54653000E-03  -1.48214000E-03  +3.26857000E-03  -1.41511000E-03  -8.49930000E-04
   -3.36780000E-04  -1.25763000E-03  +5.42450000E-04  -2.82407000E-03  -2.50481790E-01
   +4.31450600E-01  +2.70400000E-05  -8.13000000E-05  -3.64450000E-04  -2.56830000E-04
   +1.01833000E-03  +5.30600000E-05  -1.91950000E-04  -6.42400000E-05  -3.73500000E-05
   -2.00200000E-04  +5.30300000E-05  +2.14900000E-04  +7.01210000E-04  +7.20560000E-04
   +2.10580000E-04  -1.87780000E-04  -3.96380000E-04  -1.76560000E-04  +1.04379000E-03
   -1.11189000E-03  +3.64530000E-04  -4.58660000E-04  -1.04430000E-04  +2.81080000E-04
   -9.13010000E-04  -8.52750000E-04  -8.54300000E-05  -2.17792000E-03  +1.45013000E-03
   -1.73945000E-03  +6.33013000E-03  -6.18930000E-04  +4.45186000E-03  -4.90359000E-02
   +2.33799700E-02  +1.66224400E-02  -2.70679510E-01  +9.23543800E-02  +3.51864000E-02
   -1.14400300E-02  +2.60140700E-02  -5.26267000E-03  +4.76719000E-03  +4.08600000E-05
   +4.48986000E-03  -2.99081000E-03  -3.56920000E-04  +2.52882000E-03  -2.32743000E-03
   -1.08715400E-02  +3.65580000E-03  +4.12805030E-01  -3.77500000E-05  +4.86300000E-05
   +2.59280000E-04  +1.45890000E-04  -8.32840000E-04  -7.12400000E-05  +1.60510000E-04
   +9.24500000E-05  +1.68200000E-05  +5.69200000E-05  +4.82500000E-05  -1.48730000E-04
   -3.60580000E-04  -4.72550000E-04  -2.29860000E-04  +1.48170000E-04  +3.43520000E-04
   +1.43470000E-04  -5.83570000E-04  +6.28860000E-04  -6.64060000E-04  +4.55400000E-04
   +4.16400000E-05  -1.89930000E-04  +5.60620000E-04  +5.91830000E-04  +5.50900000E-05
   +3.75224000E-03  +1.52671000E-03  -2.39687000E-03  -3.20319000E-03  -1.02598000E-03
   +1.71084000E-03  +1.08036100E-02  -1.32220500E-02  -1.42182000E-03  +1.37144920E-01
   -1.51316980E-01  -6.14341000E-03  +4.79802400E-02  -2.89588600E-02  +2.97547000E-03
   -6.14137000E-03  +4.37574000E-03  +7.34212000E-03  +3.96630000E-04  +7.74570000E-04
   -1.16016000E-03  -3.24894800E-02  -5.61454000E-03  +1.23041500E-02  -4.54045800E-02
   +5.14563030E-01  -3.07000000E-06  -2.58700000E-05  -3.40700000E-05  -2.03630000E-04
   +1.67050000E-04  +6.86600000E-05  +3.82000000E-06  -5.57800000E-05  -2.74500000E-05
   +1.44900000E-05  -8.32000000E-06  +1.51900000E-05  -3.50100000E-05  +2.42000000E-06
   +1.42400000E-05  -1.50300000E-05  -5.07700000E-05  +2.08200000E-05  -3.28410000E-04
   -7.98710000E-04  -4.93030000E-04  -4.04500000E-05  +1.11500000E-05  -2.81000000E-06
   +5.41000000E-06  -1.12500000E-05  +1.10800000E-05  -2.45651000E-03  -5.03380000E-04
   +9.58760000E-04  +2.27045000E-03  +5.61242000E-03  -1.98546000E-03  +3.74919800E-02
   -8.89512000E-03  +2.93550000E-03  +3.50362800E-02  +3.54648000E-03  -7.41915500E-02
   -2.98506000E-02  +1.92929300E-02  +8.58679000E-03  +6.22799000E-03  +3.28848000E-03
   -1.65963000E-03  +2.35079000E-03  -8.27170000E-04  -9.34700000E-04  +1.11590000E-02
   +1.54543000E-03  +1.40724000E-03  -9.97952800E-02  -1.03572320E-01  +1.16860460E-01
   -1.08447000E-03  -8.93240000E-04  -4.41000000E-04  +8.34200000E-05  -1.48057100E-02
   -2.22936900E-02  -4.06035000E-03  -2.93489000E-03  +1.25773000E-03  +2.95150000E-04
   -8.77280000E-04  -9.55480000E-04  +3.66180000E-04  +2.40390000E-04  +1.24930000E-04
   +1.51780000E-04  -3.81580000E-04  -7.49220000E-04  -7.46115700E-02  +2.71639000E-03
   +4.33401000E-03  +5.49810000E-04  -1.86275000E-03  -4.24863000E-03  -5.12590000E-04
   -4.61360000E-04  -5.03200000E-05  -2.86034000E-03  +1.72100300E-02  +2.54258100E-02
   +1.42864000E-03  +7.12800000E-04  +1.09000000E-05  -2.68447000E-03  -1.76518000E-03
   +1.05632000E-03  +1.45889000E-03  +1.42180000E-04  -2.28852000E-03  +2.33290000E-04
   -1.94870000E-03  -7.57150000E-04  -3.85254000E-03  +1.25512000E-03  +1.92500000E-04
   +8.19100000E-05  +2.41888000E-03  -8.39600000E-05  +2.30370000E-04  +1.08937000E-03
   +3.54800000E-05  -1.15643000E-03  +9.34240000E-04  +1.03270000E-04  +5.82839130E-01
   +3.13020000E-04  -4.57810000E-04  +4.89460000E-04  -3.75561000E-03  -1.57376400E-02
   -2.02764300E-02  -3.40715000E-03  -1.49710000E-03  +8.25360000E-04  +3.40820000E-04
   -3.80320000E-04  -9.08970000E-04  -1.70300000E-04  +1.38670000E-04  +3.40600000E-05
   +4.22220000E-04  -3.19860000E-04  -6.73600000E-04  -2.69235000E-03  -1.05135060E-01
   -4.59269300E-02  -3.69540000E-04  +1.00506100E-02  +1.55403700E-02  +5.95000000E-06
   -1.20800000E-05  -5.47000000E-06  +6.87323000E-03  -1.30387500E-02  -1.63163700E-02
   -2.52670000E-04  -5.27210000E-04  +2.01000000E-05  +1.24249000E-03  +9.58930000E-04
   -4.90850000E-04  -5.58470000E-04  -5.96400000E-05  +8.91870000E-04  -3.32100000E-05
   +7.15810000E-04  +4.38810000E-04  -1.59540000E-04  -9.51080000E-04  +4.89960000E-04
   +8.41080000E-04  -2.37532000E-03  +3.06420000E-04  -2.74100000E-05  -3.72080000E-04
   +4.37100000E-05  +3.25670000E-04  -2.81130000E-04  -6.71400000E-05  +1.78897000E-03
   +5.40419350E-01  +7.39640000E-04  +1.10471000E-03  +2.99600000E-04  -4.29279000E-03
   -2.66799000E-03  -8.98000000E-06  +1.05998000E-03  +6.93200000E-04  -9.10000000E-07
   +4.63870000E-04  +2.34000000E-04  +7.87800000E-05  -2.65880000E-04  -1.09650000E-04
   +3.40480000E-04  +1.89190000E-04  -7.74100000E-05  -3.18310000E-04  -3.76847000E-03
   -4.10382200E-02  -1.39951640E-01  -1.88754000E-03  -1.20858700E-02  -3.82442200E-02
   +2.81600000E-04  +2.30300000E-04  -4.06700000E-05  +1.04369800E-02  -7.22585000E-03
   -5.07309000E-03  -7.23020000E-04  +1.24198000E-03  +2.57923000E-03  -8.64770000E-04
   -3.58550000E-04  -4.13600000E-05  +6.23650000E-04  +1.57000000E-05  -9.66760000E-04
   +8.61750000E-04  -3.21650000E-04  +3.18200000E-04  -2.30816000E-03  -2.56580000E-04
   +9.99170000E-04  +1.45919000E-03  -3.47631000E-03  -1.45311000E-03  +5.30800000E-05
   +3.68510000E-04  -8.62500000E-05  -5.06930000E-04  +4.08540000E-04  -6.81200000E-05
   -2.82581000E-03  -6.93465200E-02  +5.14676590E-01  +1.55025000E-03  -7.06400000E-04
   -7.57230000E-04  -1.16910000E-04  +3.14700000E-04  +6.23810000E-04  -6.13430000E-04
   -1.59130000E-04  -2.35750000E-04  +1.16014000E-03  -9.37500000E-05  -2.34681000E-03
   -2.14243000E-03  -2.39050800E-02  -3.28043000E-02  -4.09747000E-03  -4.15726000E-03
   +1.31290000E-03  -1.34890000E-04  +2.17700000E-05  +1.06850000E-04  +3.32000000E-05
   -2.47000000E-06  -1.82400000E-05  -3.53791900E-02  +1.99114000E-02  +6.23364300E-02
   -6.54500000E-05  -6.36000000E-05  +4.29500000E-05  +1.29000000E-04  +1.56900000E-04
   +9.69200000E-05  -7.16700000E-05  +4.83800000E-05  -1.35400000E-05  -9.19400000E-05
   +5.78200000E-05  +2.80000000E-05  -3.50500000E-05  +5.02000000E-06  +9.90000000E-06
   +6.27600000E-05  -7.80000000E-07  -1.77600000E-05  +3.28200000E-05  -1.02400000E-05
   +2.49200000E-05  +2.16660000E-04  -3.97600000E-05  +5.82900000E-05  +1.14600000E-04
   -2.55500000E-05  -1.02800000E-05  +5.39300000E-05  +3.01100000E-05  -2.55000000E-05
   +4.07623000E-02  +2.13090000E-04  +4.49850000E-04  -1.86753000E-03  -2.07700000E-05
   +4.55570000E-04  +5.24570000E-04  +6.13100000E-05  -9.48120000E-04  -3.49590000E-04
   +3.32734000E-03  +2.64940000E-03  +1.08013000E-03  +5.45080000E-04  -2.29995700E-02
   -2.78586600E-02  -5.00671000E-03  -1.02144000E-03  +1.24377000E-03  -1.72100000E-04
   -8.36700000E-05  +4.95000000E-06  +7.82900000E-05  +3.38500000E-05  +2.53300000E-05
   -6.47717000E-03  -1.74335010E-01  -2.23594020E-01  -1.22580000E-04  +4.86800000E-05
   +7.02100000E-05  +1.78700000E-05  +5.14600000E-05  +1.94400000E-05  +5.10300000E-05
   +2.12940000E-04  -7.73400000E-05  -1.76320000E-04  +2.60400000E-05  +1.52610000E-04
   -1.21130000E-04  +2.81700000E-05  -7.96000000E-06  +1.48680000E-04  -2.20700000E-05
   -6.95300000E-05  +7.88400000E-05  -6.97000000E-05  +4.67900000E-05  +2.43200000E-05
   -2.39990000E-04  -4.40000000E-06  +1.56980000E-04  -1.19400000E-04  +2.46000000E-06
   +8.51700000E-05  +4.25000000E-06  -2.29300000E-05  +8.07931000E-03  +1.95703890E-01
   +5.48900000E-04  -7.81320000E-04  +1.29170000E-04  +1.77060000E-04  +1.45140000E-04
   +2.17520000E-04  +3.36500000E-05  -2.22930000E-04  -9.79330000E-04  +2.21651000E-03
   +4.84520000E-03  +2.99434000E-03  +5.43390000E-04  -1.08990000E-04  -3.33610000E-03
   +2.79900000E-04  +3.27240000E-04  +2.25283000E-03  -1.34760000E-04  -6.12800000E-05
   -1.45920000E-04  +1.15280000E-04  +8.92700000E-05  +5.56100000E-05  +2.63131500E-02
   -2.53561220E-01  -3.76057030E-01  -3.63400000E-05  +3.00400000E-05  +3.26200000E-05
   +3.27000000E-06  +3.92900000E-05  +6.91300000E-05  -2.51500000E-05  +1.60600000E-05
   -3.82000000E-06  -3.99800000E-05  +3.42000000E-05  +6.61000000E-06  -9.80000000E-06
   -1.42800000E-05  +3.70000000E-07  +3.48800000E-05  -1.48300000E-05  -2.57000000E-05
   +4.62600000E-05  +3.20000000E-06  -8.03000000E-06  +5.92800000E-05  -1.50600000E-05
   -9.20000000E-06  +5.86500000E-05  -2.14900000E-05  -1.02500000E-05  +1.92900000E-05
   -5.70000000E-07  -2.16600000E-05  -2.98052300E-02  +2.49642560E-01  +3.75336610E-01
   -1.59214000E-03  -3.52180000E-04  +1.67420000E-04  -8.81350000E-04  -5.49102000E-03
   +1.92430000E-03  +3.27010000E-03  -1.46316500E-02  -1.97339000E-02  -5.21898200E-02
   -1.42719400E-02  +2.58752000E-03  +4.49363000E-03  +1.35103500E-02  +1.65127600E-02
   -1.25811000E-03  -1.97543000E-03  +4.79046000E-03  +4.84440000E-04  -5.51670000E-04
   -8.51500000E-04  -3.31000000E-06  +8.81900000E-05  -1.05080000E-04  +1.07520000E-03
   +3.06241000E-03  -1.32963000E-03  +2.10700000E-04  -7.50000000E-05  +1.17500000E-05
   +1.62380000E-04  +1.48360000E-04  +4.57300000E-05  -1.57150000E-04  -1.22320000E-04
   +6.46800000E-05  +8.38200000E-05  +2.49000000E-05  -1.36980000E-04  +9.12000000E-05
   -2.40400000E-05  +1.50700000E-05  -1.07610000E-04  +1.84500000E-05  +6.00000000E-05
   -7.57700000E-05  +4.13900000E-05  +4.65000000E-06  +2.67780000E-04  +1.33700000E-04
   +1.18890000E-04  -5.52700000E-05  +9.30000000E-05  -3.23000000E-06  -3.59610000E-04
   -1.59060000E-04  +7.80400000E-05  -6.67590000E-04  -1.07333000E-03  -1.65180000E-04
   +4.79298700E-02  -4.16200000E-05  -3.75630000E-04  +7.86310000E-04  -5.65460000E-03
   +1.71500000E-03  -1.07560000E-03  +1.30167000E-03  -9.97970000E-03  -1.71654300E-02
   -1.43020900E-02  -1.57664270E-01  -1.43752050E-01  -3.65331000E-03  +1.71577000E-03
   +1.08880000E-03  -1.69380000E-03  +3.36143000E-03  -1.00022000E-03  +1.71480000E-04
   -7.89900000E-05  -9.76360000E-04  -4.85700000E-05  +7.80000000E-07  -1.65100000E-05
   +2.70215000E-03  +4.07640000E-04  +2.68408000E-03  +2.42260000E-04  -6.49900000E-05
   -8.48900000E-05  -2.92000000E-05  -7.35600000E-05  -4.47500000E-05  +5.36000000E-06
   -6.40200000E-05  +1.78600000E-05  +7.89300000E-05  -1.92100000E-05  -5.49400000E-05
   +5.49100000E-05  -1.11400000E-05  +1.03500000E-05  -1.00860000E-04  +4.66700000E-05
   +7.44700000E-05  -3.65200000E-05  +3.70700000E-05  +4.53000000E-06  -6.80700000E-05
   +6.37900000E-05  -4.93000000E-06  -8.71500000E-05  +3.98300000E-05  +9.09000000E-06
   -2.86560000E-04  -2.05960000E-04  +1.21600000E-04  +5.01850000E-04  +2.06290000E-04
   -9.97310000E-04  +1.88180200E-02  +1.62898650E-01  +3.43580000E-04  +1.03841000E-03
   -5.22200000E-05  +1.60847000E-03  -1.74532000E-03  +3.53738000E-03  +8.00100000E-04
   +2.28400000E-04  +1.86444000E-03  +1.99979000E-03  -1.43932260E-01  -2.18281210E-01
   -5.24963000E-03  -1.72096700E-02  -1.26964700E-02  +5.21620000E-03  -6.10760000E-04
   -7.35310000E-04  +3.46430000E-04  -6.93300000E-05  +3.22900000E-05  -5.23700000E-05
   +1.42000000E-06  -4.99700000E-05  -1.88400000E-03  +2.30798000E-03  +1.03014000E-03
   +3.37900000E-05  -5.19200000E-05  +3.40600000E-05  +1.24600000E-04  +1.18150000E-04
   +5.79700000E-05  -1.23680000E-04  -1.29710000E-04  +6.87800000E-05  +8.93700000E-05
   +9.65000000E-06  -1.12190000E-04  +7.44500000E-05  -1.58700000E-05  +2.18000000E-06
   -6.07900000E-05  -4.37000000E-06  +6.68000000E-06  -5.03400000E-05  +3.13500000E-05
   -3.04000000E-06  +2.12980000E-04  +1.40040000E-04  +8.36700000E-05  -6.21600000E-05
   +9.05600000E-05  -1.14300000E-05  -1.01190000E-04  +9.92000000E-06  +1.78600000E-05
   +1.85985000E-03  +6.28800000E-04  -5.58650000E-04  -2.91049000E-03  +1.58119490E-01
   +2.27766240E-01  +2.57904000E-03  -2.38355000E-03  +7.18830000E-04  +5.29955000E-03
   -6.73260000E-04  -1.77616000E-03  -1.92389630E-01  -6.73878000E-03  +1.46952180E-01
   -1.22954600E-02  +9.16840000E-04  +1.78745200E-02  +5.81240000E-04  -5.47319000E-03
   +2.33290000E-04  -2.34990000E-04  +1.09460000E-04  -7.93240000E-04  -9.85520000E-04
   +6.65710000E-04  -9.54500000E-04  -9.09400000E-05  -2.17370000E-04  +1.80370000E-04
   -1.15405000E-03  -2.04590000E-04  +8.42330000E-04  -2.42120000E-04  -3.94320000E-04
   -3.20180000E-04  +1.62500000E-04  +3.47100000E-05  +2.32300000E-05  -3.17300000E-05
   +2.09590000E-04  -1.30860000E-04  -1.83080000E-04  +1.79900000E-05  +1.70560000E-04
   -2.59730000E-04  +6.12000000E-05  -1.59700000E-05  -1.05210000E-04  +3.52400000E-05
   +7.88000000E-05  -2.70700000E-05  +3.01300000E-05  +7.69400000E-05  -2.45000000E-05
   -2.34470000E-04  -4.77600000E-05  +1.37530000E-04  -6.62200000E-05  +4.93000000E-06
   -4.34200000E-05  +1.43120000E-04  -9.91000000E-05  +9.38600000E-05  +1.78930000E-04
   +1.32820000E-04  -5.98240000E-04  +1.73649000E-03  -1.50560000E-03  +2.00744580E-01
   -2.52815000E-03  +4.02070000E-04  -5.27069000E-03  +1.44595000E-02  +5.48540000E-03
   -1.33146300E-02  -5.24685000E-03  -5.13121600E-02  -1.03655400E-02  -1.56281500E-02
   +3.61040000E-03  +1.59004200E-02  -5.41635000E-03  +6.37320000E-04  -3.17495000E-03
   -4.17300000E-05  -1.24863000E-03  -1.19300000E-05  +1.51138000E-03  -9.60110000E-04
   +1.05235000E-03  -4.98800000E-05  -6.33760000E-04  -4.68300000E-04  -1.06092000E-03
   -2.57500000E-04  +8.82810000E-04  -2.44810000E-04  +1.91770000E-04  -3.34650000E-04
   -3.45800000E-04  -1.96550000E-04  -3.14870000E-04  +3.90120000E-04  +2.29500000E-04
   -1.64070000E-04  -2.20090000E-04  -1.12170000E-04  +3.72280000E-04  -2.80230000E-04
   +1.37740000E-04  +1.06000000E-06  +6.15300000E-05  -4.56300000E-05  -7.19700000E-05
   +3.74000000E-06  -5.74900000E-05  +9.71600000E-05  -4.47850000E-04  -2.98950000E-04
   -1.88810000E-04  +1.25950000E-04  -1.73170000E-04  +1.82000000E-05  +1.55260000E-04
   +7.92000000E-06  +1.04300000E-04  +9.47400000E-05  +1.37610000E-04  +1.23480000E-04
   +1.95194000E-03  -1.39069000E-03  +1.62074000E-03  +1.08461200E-02  +4.74316800E-02
   +6.48250000E-04  -5.84388000E-03  -1.30096000E-03  +1.80532600E-02  +1.24055000E-03
   -1.23156000E-02  +1.45261570E-01  -7.94554000E-03  -1.98003380E-01  -2.50881000E-03
   -1.44712000E-03  +4.90834000E-03  +9.07810000E-04  -3.06337000E-03  +3.38625000E-03
   -1.06712000E-03  +4.30800000E-05  -7.29000000E-05  -1.64880000E-04  +2.02053000E-03
   -9.26530000E-04  +4.97100000E-05  +6.21700000E-05  -1.42090000E-04  +2.58200000E-05
   +1.40630000E-04  +7.73600000E-05  -4.39810000E-04  -6.17800000E-04  +9.63200000E-05
   +3.67330000E-04  +3.54330000E-04  -2.72710000E-04  -1.60000000E-06  +2.43060000E-04
   -1.01570000E-04  -2.71310000E-04  +5.72400000E-05  +2.15760000E-04  -2.57480000E-04
   +4.02900000E-05  +6.03600000E-05  +3.23500000E-05  +2.35920000E-04  +1.71760000E-04
   -1.92930000E-04  +4.70900000E-05  +2.50620000E-04  +2.81640000E-04  -2.01690000E-04
   +8.96800000E-05  +2.72180000E-04  -1.35450000E-04  -9.63000000E-06  -1.84610000E-04
   +3.26600000E-05  -1.03500000E-05  -2.58800000E-05  -1.48500000E-05  -2.20200000E-05
   -1.44346000E-03  +1.96039000E-03  -6.30820000E-04  -1.59955150E-01  +1.23677400E-02
   +2.05653530E-01  -5.40208300E-02  -1.30363100E-02  -9.77900000E-04  +6.42148000E-03
   +1.37976300E-02  +1.62274000E-02  -1.27841000E-03  -2.32852000E-03  +5.25506000E-03
   -1.27746000E-03  -1.44810000E-04  -1.92000000E-06  -6.01150000E-04  -5.52988000E-03
   +2.24447000E-03  +2.94503000E-03  -1.55498300E-02  -1.92614500E-02  -6.25710000E-04
   +1.75709000E-03  -1.15840000E-03  +4.13390000E-04  +8.73600000E-05  -1.33420000E-04
   +7.32000000E-05  -7.41110000E-04  -1.03065000E-03  -2.36630000E-04  -2.38400000E-04
   -6.17600000E-05  -1.40380000E-04  -1.33600000E-05  +3.84930000E-04  +3.23200000E-05
   +1.00980000E-04  -8.34200000E-05  -5.71900000E-05  +1.95500000E-05  +3.97700000E-05
   -5.41000000E-06  +1.09300000E-05  +3.53200000E-05  +1.15500000E-05  +3.02600000E-05
   -8.10300000E-05  +4.08070000E-04  -3.39680000E-04  -2.64790000E-04  -3.21100000E-05
   -9.64500000E-05  -4.47000000E-05  +7.97400000E-05  -5.29400000E-05  -1.83300000E-05
   -1.86960000E-03  -1.79134000E-03  +8.57200000E-04  -3.04010000E-04  -1.83280000E-04
   -1.11180000E-04  -1.57230000E-04  +2.83630000E-04  -2.22290000E-04  +1.82400000E-04
   +7.70470000E-04  +8.99190000E-04  +5.35119500E-02  -1.25782600E-02  -1.57338000E-01
   -1.43819570E-01  -1.28930000E-04  +4.45990000E-03  +1.54900000E-04  -2.28635000E-03
   +3.69613000E-03  -1.36934000E-03  -3.45900000E-05  -4.72210000E-04  +9.27690000E-04
   -5.67020000E-03  +2.32328000E-03  -1.61688000E-03  +1.70330000E-04  -8.94705000E-03
   -1.75848700E-02  +1.26231000E-03  -1.99141000E-03  +9.17990000E-04  -3.52790000E-04
   -3.01180000E-04  +5.92100000E-05  -9.83200000E-05  -8.02980000E-04  -9.88320000E-04
   +1.52780000E-04  +4.29240000E-04  -1.49570000E-04  +8.57000000E-05  +4.20500000E-05
   -4.48470000E-04  +9.80100000E-05  +4.99300000E-05  +1.80700000E-05  -9.22300000E-05
   +7.60000000E-06  +1.14980000E-04  -7.79500000E-05  +2.06300000E-05  -4.28400000E-05
   +1.87840000E-04  -1.14440000E-04  -8.07000000E-06  -4.18580000E-04  +2.21500000E-05
   +3.46680000E-04  -1.05100000E-05  -5.16500000E-05  +3.10900000E-05  +5.15500000E-05
   -5.78900000E-05  +2.63700000E-05  -2.64836000E-03  -1.26995000E-03  +4.32100000E-04
   -1.21170000E-04  -2.72720000E-04  +5.79800000E-05  +2.62920000E-04  -3.49720000E-04
   +1.95100000E-04  -5.38500000E-05  +1.06730000E-04  +1.65350000E-04  +2.21437600E-02
   +1.64054940E-01  -3.95750000E-04  -1.44142870E-01  -2.31150170E-01  -2.50600000E-03
   -1.46392800E-02  -1.26269300E-02  +5.40529000E-03  -1.06080000E-03  -8.05320000E-04
   +8.82500000E-05  +9.86330000E-04  +7.52500000E-05  +2.12540000E-03  -1.63752000E-03
   +3.54579000E-03  +1.66806000E-03  -1.44910000E-04  +2.18586000E-03  -2.13132000E-03
   -2.39000000E-05  -1.29372000E-03  +4.75980000E-04  +2.32220000E-04  +2.14300000E-05
   -1.77690000E-04  -2.41190000E-04  -1.08360000E-04  -1.26180000E-04  -1.49440000E-04
   +1.53300000E-04  +1.05070000E-04  +3.36800000E-05  -9.71000000E-06  -1.32120000E-04
   -7.22000000E-05  +5.74400000E-05  +5.21300000E-05  +4.42000000E-06  -9.25100000E-05
   +5.05100000E-05  -2.15900000E-05  +7.18000000E-06  -8.71100000E-05  +7.34300000E-05
   +5.45600000E-05  -1.49100000E-05  +1.39210000E-04  +7.28100000E-05  +9.06500000E-05
   +6.73500000E-05  +3.52400000E-05  -4.02300000E-05  +5.52000000E-05  -1.70000000E-07
   -6.92850000E-04  -8.38360000E-04  +3.79910000E-04  -3.51100000E-05  +1.17290000E-04
   -1.55600000E-05  -2.54330000E-04  +1.57150000E-04  -2.22200000E-04  -2.31170000E-04
   -7.54560000E-04  -7.61970000E-04  -3.11530000E-04  +1.59708560E-01  +2.40308760E-01
   -1.12811300E-02  +1.46389000E-03  +1.69181800E-02  +1.56450000E-04  -5.55117000E-03
   +5.04410000E-04  -2.93770000E-04  -2.06000000E-05  -9.34350000E-04  +2.46481000E-03
   -2.06623000E-03  +6.91850000E-04  +3.91658000E-03  -2.12798000E-03  -1.48757000E-03
   -1.89737310E-01  -1.42714500E-02  +1.49559230E-01  -1.58210000E-04  +2.85680000E-04
   +8.57770000E-04  -2.00340000E-04  -1.20160000E-04  -7.89800000E-05  -4.15600000E-04
   +1.77390000E-03  -1.05193000E-03  +9.76700000E-05  -1.87390000E-04  +8.22000000E-06
   -4.73400000E-05  -2.91100000E-05  +1.08150000E-04  -3.83700000E-05  -8.48100000E-05
   +2.07800000E-05  +8.12000000E-05  +3.10000000E-07  -8.90000000E-05  +6.73400000E-05
   -2.38800000E-05  +2.52500000E-05  -1.26430000E-04  +6.73200000E-05  +3.53600000E-05
   +3.40500000E-05  +5.39200000E-05  -1.42630000E-04  +5.80000000E-06  +9.33100000E-05
   -1.30400000E-05  -6.04700000E-05  +4.79400000E-05  -1.11800000E-05  -4.44500000E-05
   +1.07900000E-04  +3.69600000E-05  -1.57830000E-04  +2.37740000E-04  -1.32710000E-04
   +1.84060000E-04  +2.09700000E-05  -2.03310000E-04  -2.17240000E-04  +2.70590000E-04
   -1.32660000E-04  -7.84500000E-04  +1.88654000E-03  -1.65245000E-03  +1.96563850E-01
   -1.42435800E-02  +3.17009000E-03  +1.62864800E-02  -5.20805000E-03  +7.09820000E-04
   -2.81242000E-03  -1.75720000E-04  -1.28967000E-03  -9.10900000E-05  -2.39126000E-03
   -1.35230000E-04  -4.78162000E-03  +1.44106700E-02  +5.82369000E-03  -1.48834700E-02
   -1.49962000E-02  -4.91011400E-02  -2.10295000E-03  -6.14240000E-04  +3.94680000E-04
   +4.97830000E-04  -8.70800000E-05  +3.19600000E-05  -5.65400000E-05  +1.63294000E-03
   -4.29200000E-04  +2.29047000E-03  -7.93000000E-05  -2.65190000E-04  -2.92300000E-05
   +1.60900000E-05  +6.93000000E-06  +1.98900000E-05  -4.65700000E-05  -2.58300000E-05
   +2.58000000E-05  +4.89100000E-05  -1.61900000E-05  -4.50700000E-05  +3.43400000E-05
   +1.34700000E-05  +2.81400000E-05  -7.77000000E-05  +5.06000000E-05  +4.09300000E-05
   +4.09000000E-06  -2.28100000E-05  -1.05000000E-05  +1.20000000E-05  +2.43700000E-05
   +1.67900000E-05  -5.22000000E-05  +3.35000000E-05  -9.50000000E-07  +6.91400000E-05
   +3.79100000E-05  +8.01500000E-05  +1.86280000E-04  -6.76900000E-05  +4.33080000E-04
   +7.76420000E-04  +3.11000000E-05  -7.26780000E-04  +2.49890000E-04  -2.47390000E-04
   +2.94290000E-04  +2.17416000E-03  -1.51893000E-03  +1.67397000E-03  +1.83738000E-02
   +4.28545700E-02  -3.34270000E-03  -6.76300000E-04  +5.24691000E-03  +5.72050000E-04
   -2.51029000E-03  +3.28791000E-03  -1.21024000E-03  -4.14080000E-04  -3.12900000E-04
   +2.67690000E-04  -5.17308000E-03  -1.49081000E-03  +2.02126700E-02  +3.42648000E-03
   -1.23382700E-02  +1.48534320E-01  -3.24254000E-03  -2.00975510E-01  -9.38400000E-05
   -1.60030000E-04  +2.64630000E-04  -9.36000000E-06  -5.92000000E-05  -8.99000000E-06
   -1.29461000E-03  +2.06558000E-03  +5.87660000E-04  +4.49000000E-05  +3.25700000E-05
   +2.06000000E-05  -3.35000000E-06  +2.29800000E-05  +3.27500000E-05  +2.26000000E-06
   +1.95600000E-05  -1.61700000E-05  -3.04700000E-05  +1.76900000E-05  +1.39800000E-05
   -1.12600000E-05  -5.98000000E-06  -2.01000000E-06  +2.02700000E-05  +3.60000000E-07
   -4.17000000E-06  +3.48100000E-05  -4.76000000E-06  -1.06300000E-05  +3.54000000E-05
   -1.84900000E-05  +7.69000000E-06  +3.66500000E-05  -1.66400000E-05  -2.35000000E-06
   +1.15800000E-05  +4.92500000E-05  -3.51100000E-05  -2.03730000E-04  +3.69900000E-04
   +1.59440000E-04  +7.99120000E-04  +9.38700000E-05  -7.67820000E-04  -1.28340000E-04
   +2.62810000E-04  -1.98800000E-04  -1.27468000E-03  +2.05809000E-03  -4.99090000E-04
   -1.62940690E-01  +3.90836000E-03  +2.07080170E-01  +3.14530000E-04  +1.82840000E-04
   +1.02000000E-04  +7.82580000E-04  -1.47168000E-03  +1.15860000E-04  +3.29840000E-04
   +2.36940000E-04  +2.97840000E-04  -1.81480000E-04  +1.82900000E-05  -8.94000000E-06
   +2.58300000E-05  +6.87000000E-06  -1.14400000E-04  +5.22700000E-05  +6.93700000E-05
   -9.99400000E-05  -5.27028000E-03  +1.53396000E-03  +1.12589000E-03  -2.73512220E-01
   +9.90936000E-02  +2.51552800E-02  -2.63000000E-06  -4.23100000E-05  +1.52300000E-05
   +6.02710000E-04  +2.66610000E-04  -6.19800000E-04  -3.47090000E-04  +2.56800000E-05
   +4.69510000E-04  -5.07000000E-06  -1.68370000E-04  +6.60800000E-05  +1.62330000E-04
   -9.01000000E-06  -1.93960000E-04  +2.35180000E-04  +7.28700000E-05  -2.09850000E-04
   -1.43850000E-04  -5.41700000E-05  +4.15960000E-04  +1.88160000E-04  -8.72700000E-05
   -2.87760000E-04  +1.53500000E-05  +2.53140000E-04  +1.64900000E-05  -1.92850000E-04
   +1.67330000E-04  -2.38000000E-05  -7.40500000E-05  -1.88620000E-04  +7.23470000E-04
   -9.68000000E-06  +7.46000000E-06  +8.10000000E-07  -6.88000000E-06  +1.04200000E-05
   -4.69000000E-06  +3.63600000E-05  -7.64100000E-05  -6.65000000E-06  +2.32500000E-05
   +1.34500000E-05  -1.32500000E-05  +1.77800000E-05  +1.43600000E-05  +5.36000000E-06
   +2.93998110E-01  -3.23200000E-04  +9.64800000E-05  +1.18050000E-04  +1.33585000E-03
   +5.86080000E-04  -1.86770000E-04  -6.23900000E-05  -2.54880000E-04  -5.94730000E-04
   -4.93000000E-06  +4.38700000E-05  -5.86000000E-05  -1.99400000E-04  -1.92300000E-04
   +4.26800000E-05  -1.05570000E-04  -1.09100000E-05  +9.01600000E-05  +1.86672900E-02
   -1.07316200E-02  -1.41461000E-03  +9.69672000E-02  -8.83343200E-02  -1.19108600E-02
   +2.07820000E-04  +2.23590000E-04  +2.49400000E-05  -2.58360000E-04  -2.38297000E-03
   +3.50199000E-03  +1.35436000E-03  +1.59500000E-05  -4.29660000E-04  +1.12460000E-04
   -1.37620000E-04  +2.59560000E-04  -2.72550000E-04  +1.01160000E-04  +1.98670000E-04
   -4.78600000E-05  +2.17120000E-04  -8.47100000E-05  -4.02820000E-04  -4.01300000E-05
   +5.41380000E-04  -1.70790000E-04  +4.10500000E-05  +1.67010000E-04  -7.03400000E-05
   -1.84260000E-04  -3.71500000E-05  +1.93520000E-04  -1.55350000E-04  -1.02300000E-05
   -4.03870000E-04  +1.95660000E-04  -1.24244000E-03  -6.32000000E-06  -4.17000000E-05
   -1.37300000E-05  +1.89900000E-05  -3.97000000E-06  +1.74000000E-05  +4.18500000E-05
   +7.57800000E-05  +1.59010000E-04  +3.43000000E-05  -1.54300000E-05  +4.09200000E-05
   +9.99000000E-06  -6.23000000E-06  -2.07000000E-06  -1.07723240E-01  +9.58650200E-02
   -6.55700000E-05  -1.94190000E-04  +1.40340000E-04  -8.27340000E-04  -3.80480000E-04
   +5.99200000E-04  +3.68890000E-04  +7.10800000E-05  -1.79360000E-04  -3.79230000E-04
   -4.97800000E-05  +1.23070000E-04  +1.48530000E-04  +1.76400000E-05  -1.91420000E-04
   +1.35160000E-04  +1.07730000E-04  -1.64900000E-05  -2.27451000E-02  +1.06843500E-02
   +1.40150000E-04  +2.71219300E-02  -1.29483700E-02  -4.93627400E-02  -1.60890000E-04
   -1.44740000E-04  -1.81000000E-06  +3.04390000E-04  +3.03225000E-03  -3.93198000E-03
   -1.35546000E-03  +4.40720000E-04  +5.12170000E-04  +1.69570000E-04  +2.76940000E-04
   -3.45140000E-04  +7.98300000E-05  -1.54290000E-04  +4.91500000E-05  -1.29630000E-04
   +3.15000000E-06  +2.38830000E-04  +7.30080000E-04  +3.82120000E-04  -2.58170000E-04
   +6.03800000E-05  -1.37750000E-04  -3.33200000E-05  +1.66200000E-05  +6.57000000E-06
   +8.19000000E-06  -6.72900000E-05  +2.19000000E-05  +1.92900000E-05  -1.36264000E-03
   +7.84120000E-04  +1.03849000E-03  +1.43300000E-05  +1.09600000E-05  +1.86300000E-05
   +1.39100000E-05  -1.78500000E-05  -2.53000000E-06  +3.93800000E-05  +4.32000000E-06
   +8.92000000E-05  +1.43800000E-05  +1.21600000E-05  -8.35100000E-05  -6.50000000E-06
   +6.72000000E-06  +7.30000000E-06  -2.80312600E-02  +9.29489000E-03  +5.47383700E-02
   +5.69260000E-04  +1.83000000E-05  -2.12550000E-04  +3.45270000E-04  -4.20160000E-04
   -2.09350000E-04  +2.68560000E-04  +3.27470000E-04  +4.60460000E-04  -1.63140000E-04
   -2.97700000E-05  +7.23300000E-05  +2.27910000E-04  +1.67450000E-04  -6.31100000E-05
   +2.96900000E-05  -4.91500000E-05  -5.14400000E-05  +3.13295000E-03  +4.66241000E-03
   +5.75800000E-05  -1.66952840E-01  -1.32103010E-01  -1.58400000E-04  -2.16770000E-04
   -2.01960000E-04  -9.18000000E-06  +3.46100000E-05  -7.76200000E-05  +2.05430000E-04
   +2.22880000E-04  -1.21700000E-05  -6.52900000E-05  -6.46000000E-06  +2.14000000E-05
   +2.43400000E-05  -1.45240000E-04  +2.22700000E-05  +1.04260000E-04  -5.85000000E-06
   +2.15510000E-04  -1.88970000E-04  -9.85860000E-04  +9.95600000E-04  +5.14390000E-04
   -1.78200000E-05  +4.34100000E-05  +5.65600000E-05  +6.29400000E-05  -6.69600000E-05
   +6.45000000E-06  +7.31600000E-05  -2.16100000E-05  -2.24500000E-05  +3.65880000E-04
   +3.36060000E-04  -6.48700000E-05  +1.77200000E-05  +3.73800000E-05  +1.52100000E-05
   -2.38200000E-05  -8.81000000E-06  -1.60500000E-05  -1.62300000E-05  -2.57400000E-05
   -2.02600000E-05  -5.73700000E-05  +5.34900000E-05  +1.66200000E-05  -6.51000000E-06
   -3.27000000E-06  +6.11000000E-06  -1.79314500E-02  -2.24616400E-02  -7.31070000E-04
   +1.81622230E-01  +5.20110000E-04  -4.41530000E-04  -4.86650000E-04  +6.63770000E-04
   -1.78247000E-03  +3.74547000E-03  -3.01050000E-04  -1.09840000E-04  +3.51400000E-04
   +1.89670000E-04  +1.60200000E-04  +6.56600000E-05  +2.09620000E-04  +4.75310000E-04
   +5.07940000E-04  -6.11080000E-04  -3.73530000E-04  -3.42840000E-04  -1.36150100E-02
   -1.43275700E-02  -1.14532000E-03  -1.30693160E-01  -1.93016160E-01  +1.38480000E-04
   -4.99610000E-04  -4.61060000E-04  -1.02290000E-04  -1.01296000E-03  +1.87760000E-04
   -8.51500000E-05  +9.70200000E-05  +1.68930000E-04  +3.28770000E-04  -9.40900000E-05
   -2.78090000E-04  +1.40830000E-04  +5.68000000E-05  +9.85300000E-05  -2.22050000E-04
   +3.23330000E-04  +1.85280000E-04  -3.69410000E-04  +8.58700000E-05  -2.67210000E-04
   +7.02530000E-04  +1.46110000E-04  +2.65700000E-05  -2.44430000E-04  +1.23130000E-04
   +2.80840000E-04  +5.54400000E-05  -9.91100000E-05  +1.49110000E-04  -4.29100000E-05
   -1.35170000E-04  +5.46610000E-04  -1.62205000E-03  +2.94900000E-05  +5.15400000E-05
   +4.63800000E-05  -2.75400000E-05  -4.95000000E-05  -3.30900000E-05  -9.23300000E-05
   +2.20040000E-04  -6.70500000E-05  +4.79900000E-05  -2.81900000E-05  +1.37110000E-04
   -1.02670000E-04  -6.14000000E-06  -3.40800000E-05  +8.94229000E-03  +1.07092800E-02
   -6.42000000E-06  +1.43876670E-01  +2.08792150E-01  +4.43320000E-04  +6.36760000E-04
   +1.85220000E-04  -1.57365000E-03  +2.26192000E-03  -3.43951000E-03  +8.44400000E-05
   -4.57800000E-04  -1.06570000E-04  +5.83860000E-04  +5.29000000E-06  +3.07800000E-05
   -3.62100000E-04  -1.23320000E-04  +1.63330000E-04  +1.79800000E-04  -2.17480000E-04
   +2.19250000E-04  +1.73987400E-02  +1.76801300E-02  -1.19119000E-03  -2.34470000E-04
   -1.10346000E-03  -4.87728300E-02  +3.72170000E-04  +3.98510000E-04  +2.43500000E-05
   +4.13990000E-04  -4.58700000E-04  +4.12700000E-04  +4.10100000E-05  -5.30000000E-05
   -1.36840000E-04  +5.03800000E-05  +6.49600000E-05  -6.00800000E-05  -5.49400000E-05
   -2.30900000E-05  +1.64860000E-04  -1.60920000E-04  +1.32520000E-04  -8.15700000E-05
   -1.40090000E-04  -4.39810000E-04  +4.01240000E-04  +1.57700000E-05  -5.76500000E-05
   -5.27200000E-05  -2.69600000E-05  -8.03800000E-05  -2.34400000E-05  +2.94600000E-05
   -2.56000000E-06  -2.36300000E-05  +1.01294000E-03  +1.03778000E-03  +1.14243000E-03
   -7.20000000E-07  -2.51600000E-05  -4.72900000E-05  +3.39300000E-05  +2.60400000E-05
   +1.78100000E-05  -3.24270000E-04  +3.78960000E-04  +2.84600000E-05  -5.76400000E-05
   +1.18180000E-04  -1.24210000E-04  +5.86500000E-05  +3.69900000E-05  -6.82000000E-06
   +2.36345000E-03  +2.85318000E-03  -9.35830000E-04  -1.79020000E-04  -2.03658000E-03
   +5.09329300E-02  -1.19060000E-04  -1.31360000E-04  +8.80300000E-05  -1.50210000E-04
   +4.49090000E-04  +5.76300000E-04  -7.46100000E-05  -2.28370000E-04  +6.92000000E-06
   -2.50860000E-04  -4.18000000E-05  -2.33000000E-05  -1.17400000E-05  -1.02480000E-04
   -7.90100000E-05  +1.15130000E-04  +7.12600000E-05  +4.11000000E-05  -1.75839000E-03
   -2.75600000E-03  -4.68979000E-03  -4.70784000E-02  +4.32412000E-03  +8.96209000E-03
   +3.60700000E-05  +4.24800000E-05  -4.11000000E-06  +5.69060000E-04  -5.88030000E-04
   -4.46820000E-04  +6.06200000E-05  +1.70900000E-05  -1.89620000E-04  +1.23210000E-04
   +1.23570000E-04  -8.99700000E-05  -1.05350000E-04  -4.60300000E-05  +1.53390000E-04
   -1.30930000E-04  -1.75900000E-05  +1.97820000E-04  -3.53230000E-04  +3.71770000E-04
   -5.61820000E-04  -1.13300000E-04  -2.28800000E-05  +1.85070000E-04  -4.09400000E-05
   -1.67460000E-04  -1.14400000E-05  +1.11680000E-04  -1.19910000E-04  +2.94100000E-05
   -2.08960000E-04  +8.87080000E-04  -8.09290000E-04  -6.10000000E-06  -2.30000000E-05
   +8.71000000E-06  +2.48400000E-05  -1.69300000E-05  +1.64400000E-05  +3.12050000E-04
   -1.89530000E-04  +8.02300000E-05  +5.52000000E-06  +1.18400000E-05  -5.58600000E-05
   -5.06000000E-06  +1.04800000E-05  -1.03700000E-05  -3.56100000E-05  +1.39913700E-02
   +2.63475100E-02  +8.84670000E-04  -9.70326000E-03  -1.97113400E-02  +4.88341200E-02
   -2.68620000E-04  -3.61600000E-05  -7.13000000E-06  +4.88260000E-04  +1.18635000E-03
   -4.49500000E-05  -4.41960000E-04  -5.97990000E-04  +8.12450000E-04  -3.65500000E-05
   -1.73330000E-04  -1.49990000E-04  -1.48600000E-05  -7.92400000E-05  -2.11050000E-04
   +1.61700000E-04  +1.57490000E-04  +1.33530000E-04  -1.29431000E-03  +9.50956000E-03
   +1.79673700E-02  +3.99892000E-03  -1.11984340E-01  -1.16350480E-01  +1.47420000E-04
   +1.11850000E-04  +1.20600000E-05  -2.40950000E-04  +1.01705000E-03  -3.59100000E-04
   -2.66820000E-04  -1.98080000E-04  -6.13000000E-06  -7.86700000E-05  +6.07200000E-05
   -1.72000000E-06  +4.58000000E-05  -3.02300000E-05  -1.11340000E-04  +5.80400000E-05
   -1.22340000E-04  +1.40480000E-04  +6.60720000E-04  +3.96320000E-04  -1.39890000E-04
   +6.56000000E-06  -1.53300000E-05  +2.05600000E-05  -4.88100000E-05  -6.19000000E-06
   -1.74100000E-05  -4.10600000E-05  -1.18000000E-05  +2.06800000E-05  +4.80900000E-04
   -2.18406000E-03  +2.69997000E-03  -2.03000000E-05  -1.71800000E-05  -1.33700000E-05
   +5.21000000E-06  -5.97000000E-06  +2.79900000E-05  -4.70500000E-05  -1.37918000E-03
   +2.64290000E-04  +4.46900000E-05  -7.73000000E-06  -1.27700000E-05  +1.44100000E-05
   -5.03000000E-06  +3.19000000E-06  -7.42310000E-04  -6.35574000E-03  -1.01247400E-02
   +2.81290000E-03  -1.06525100E-02  -1.99178300E-02  -5.81784000E-03  +1.20746700E-01
   +7.49260000E-04  +1.90310000E-04  -3.18510000E-04  -1.33448000E-03  -1.04359000E-03
   +6.49780000E-04  +2.06080000E-04  -7.84680000E-04  -1.59950000E-04  +5.16500000E-04
   +3.33450000E-04  +2.35610000E-04  -2.27040000E-04  +2.51810000E-04  +4.72520000E-04
   -3.95250000E-04  -4.06930000E-04  -1.11720000E-04  +1.41033000E-03  -1.26505500E-02
   -2.03350700E-02  +8.84657000E-03  -1.13450170E-01  -2.53691150E-01  -6.52000000E-05
   -2.09100000E-05  -1.41600000E-05  +1.37629000E-03  -7.25070000E-04  +5.08650000E-04
   +2.02010000E-04  +2.22040000E-04  -1.62090000E-04  +4.67500000E-05  +3.21600000E-05
   -2.57700000E-05  -1.66700000E-05  -1.32510000E-04  +1.32160000E-04  -2.28950000E-04
   +9.59600000E-05  +2.61320000E-04  +2.56010000E-04  +1.56380000E-04  +3.81090000E-04
   -1.87470000E-04  +2.18650000E-04  +2.80670000E-04  +3.21100000E-05  -8.02600000E-05
   +1.58200000E-05  -1.70000000E-06  -2.29700000E-05  +1.58300000E-05  -6.76170000E-04
   +4.66908000E-03  -3.81918000E-03  +2.39800000E-05  +1.62400000E-05  -1.65000000E-06
   +3.67000000E-05  +4.30000000E-07  -5.12000000E-06  -3.21180000E-04  +4.73120000E-04
   +3.79740000E-04  -1.29780000E-04  -1.21200000E-05  +1.02080000E-04  -8.47000000E-06
   +1.74600000E-05  -1.72800000E-05  -2.67950000E-04  -7.88400000E-04  -1.89210000E-03
   +3.51700000E-05  +1.19080000E-03  +1.58792000E-03  -9.31253000E-03  +1.23714000E-01
   +2.76242210E-01  -1.10390000E-04  -4.43570000E-04  -9.73350000E-04  +1.32940000E-04
   +4.38970000E-04  -2.47960000E-04  -1.03820000E-04  -7.68300000E-05  -1.28000000E-05
   +9.69400000E-05  +1.17220000E-04  +4.11700000E-05  -4.20300000E-05  -3.70600000E-05
   +1.92000000E-05  -9.23300000E-05  +4.50200000E-05  +2.97820000E-04  -1.76626000E-03
   -7.08000000E-06  +4.64300000E-05  +2.35400000E-05  -3.50300000E-04  -4.54770000E-04
   +8.13400000E-05  +1.17810000E-04  +4.99600000E-05  +1.88810000E-04  -6.68870000E-04
   +1.52650000E-04  -5.28370000E-04  +1.42060000E-04  +7.18600000E-04  -7.54900000E-05
   +1.03560000E-04  +1.33000000E-05  -4.33900000E-05  +1.02510000E-04  -5.44400000E-05
   +8.10700000E-05  -6.38600000E-05  +5.00800000E-05  -1.05160000E-04  +1.22310000E-04
   -5.08500000E-05  +1.34840000E-04  +3.29400000E-04  -2.16330000E-04  -2.55500000E-05
   -9.02200000E-05  -5.68600000E-05  +8.16000000E-05  -5.74900000E-05  -2.80700000E-05
   -4.84305100E-02  +5.06277000E-03  -8.26162000E-03  -5.74000000E-06  -9.06000000E-06
   -3.26000000E-06  +1.47100000E-05  +7.84000000E-06  +1.85200000E-05  -9.55000000E-06
   +4.13500000E-05  +5.63400000E-05  -2.04752000E-03  -5.40090000E-04  -3.78740000E-04
   -1.57600000E-05  -2.48000000E-06  -2.46300000E-05  +4.11950000E-04  -2.45410000E-04
   +3.08770000E-04  +6.91300000E-05  +3.39870000E-04  -1.45500000E-04  +6.60950000E-04
   +1.30630000E-04  -1.80630000E-04  +5.02918300E-02  -8.77110000E-04  +6.36500000E-05
   +1.71610000E-04  -5.16600000E-05  +7.42950000E-04  +5.12500000E-04  +1.86390000E-04
   -1.07360000E-04  -8.15600000E-05  +1.61660000E-04  +8.78700000E-05  -4.19600000E-05
   -1.54850000E-04  -2.56000000E-05  +2.10910000E-04  +1.06000000E-05  -2.44430000E-04
   -2.04220000E-04  -9.27220000E-04  +1.15397800E-02  -1.53817900E-02  -1.61680000E-04
   -1.89406000E-03  -2.79450000E-03  +7.58000000E-05  +3.75700000E-05  -3.75200000E-05
   -3.84250000E-04  +9.94230000E-04  +6.67690000E-04  +6.48870000E-04  -4.49200000E-05
   -1.09806000E-03  +6.00000000E-06  -1.73040000E-04  +1.97340000E-04  +7.26500000E-05
   -4.49400000E-05  -5.21600000E-05  +1.90000000E-07  -1.06400000E-05  -4.14800000E-05
   +3.22200000E-05  -8.06500000E-05  +1.45270000E-04  +2.73010000E-04  -2.15793000E-03
   +6.52590000E-04  -4.74300000E-05  +1.21630000E-04  +2.97200000E-05  -1.47230000E-04
   +6.27700000E-05  +3.21200000E-05  +6.33297000E-03  -1.31463400E-01  +1.29278940E-01
   -1.77800000E-05  -1.14500000E-05  -8.84000000E-06  +7.53000000E-06  +1.86900000E-05
   -7.65000000E-06  -1.54400000E-05  +3.57600000E-05  -2.62600000E-05  -8.60840000E-04
   -3.16450000E-04  -4.94040000E-04  -1.78200000E-05  +3.39400000E-05  -1.51300000E-05
   -2.18110000E-04  -4.93700000E-05  -9.97900000E-05  +2.54220000E-04  +7.23900000E-05
   -1.50640000E-04  -2.08610000E-04  +8.17360000E-04  -9.95260000E-04  -7.14933000E-03
   +1.42611790E-01  +3.90880000E-04  -2.62820000E-04  -2.08480000E-04  +7.80100000E-04
   +1.13088000E-03  +8.41680000E-04  +1.41600000E-05  -3.77490000E-04  -3.72900000E-05
   +1.45770000E-04  +1.50990000E-04  +4.27100000E-05  -4.04100000E-05  +1.31990000E-04
   +9.34100000E-05  -2.47670000E-04  -7.89700000E-05  +3.06250000E-04  -1.72074000E-03
   +1.58655000E-02  -2.00991500E-02  +5.82240000E-04  -4.63216000E-03  -4.43853000E-03
   -2.32400000E-05  -5.81000000E-06  +3.55900000E-05  -9.07850000E-04  +5.56240000E-04
   +5.38390000E-04  +1.24369000E-03  -4.30920000E-04  -1.90594000E-03  +1.01450000E-04
   -1.03360000E-04  +1.44530000E-04  -1.34950000E-04  -1.37850000E-04  +2.60180000E-04
   -2.78490000E-04  +1.53980000E-04  -4.39600000E-05  +5.07960000E-04  -9.20800000E-05
   -1.67200000E-04  -1.66370000E-03  +3.59080000E-03  +1.22173000E-03  -4.71000000E-05
   -7.92100000E-05  +5.25800000E-05  +1.36000000E-05  -3.19100000E-05  +7.22900000E-05
   -9.09870000E-03  +1.25390250E-01  -2.36658440E-01  -2.24000000E-06  +1.17300000E-05
   -5.15000000E-06  -2.49900000E-05  +1.58900000E-05  -2.07500000E-05  -3.43800000E-05
   +1.14700000E-04  +5.13800000E-05  -6.11190000E-04  +1.36960000E-04  +4.27440000E-04
   -1.91700000E-05  -3.06500000E-05  -8.75000000E-06  +1.88000000E-06  -9.62600000E-05
   +2.69210000E-04  +1.08210000E-04  -1.04810000E-04  +3.47200000E-04  -3.29010000E-04
   +1.08685000E-03  -1.51225000E-03  +1.06508900E-02  -1.39297880E-01  +2.57215900E-01
   -1.50930000E-04  +3.79200000E-05  +5.19690000E-04  +5.50260000E-04  +2.21970000E-04
   +3.19580000E-04  +2.15760000E-04  +1.39420000E-04  +2.83330000E-04  -1.09720000E-04
   -6.94400000E-05  -6.85000000E-05  +9.88700000E-05  +8.16000000E-05  -3.35000000E-05
   +1.96500000E-04  -9.92400000E-05  -2.11610000E-04  -2.33720000E-04  +1.35486000E-03
   +9.09660000E-04  -2.57850000E-04  +8.84000000E-06  +2.15600000E-04  -1.43640000E-04
   -1.55190000E-04  -5.15100000E-05  +4.42390000E-04  +1.27411000E-03  +3.58810000E-04
   +2.48200000E-05  -1.26380000E-04  +6.76700000E-05  +6.89000000E-06  +1.58900000E-05
   -2.20000000E-07  -4.03200000E-05  +6.28200000E-05  +8.88000000E-06  -1.27900000E-05
   -2.61500000E-05  -9.50900000E-05  +3.96540000E-04  -5.43300000E-05  -6.84000000E-06
   +2.05000000E-05  -4.85700000E-05  -5.46500000E-05  +5.50800000E-05  -1.17600000E-05
   +1.34600000E-05  +6.28400000E-05  -3.62500000E-05  -1.30000000E-06  -2.15920930E-01
   -1.30387960E-01  +4.87725000E-03  +1.25200000E-05  +2.12700000E-05  +8.58000000E-06
   -2.98100000E-05  +4.60000000E-06  -2.33900000E-05  +6.89100000E-05  -3.41300000E-05
   -5.42500000E-05  +3.34800000E-05  -5.54900000E-05  -5.74560000E-04  +3.20000000E-07
   -6.02000000E-06  +1.84800000E-05  +4.74700000E-05  -1.33060000E-04  +5.44300000E-05
   +2.47010000E-04  +2.69640000E-04  -5.13360000E-04  +2.28000000E-04  +2.71810000E-04
   -4.02600000E-05  +2.30265000E-03  +2.55943000E-03  +1.84480000E-04  +2.31615940E-01
   +3.34540000E-04  +2.53100000E-04  -3.86020000E-04  +1.18691000E-03  -1.00069000E-03
   -3.44774000E-03  -1.11694000E-03  -3.76180000E-04  +2.82600000E-04  -3.60000000E-06
   -2.75200000E-04  -2.14920000E-04  +2.38980000E-04  +1.36650000E-04  -2.02600000E-05
   -8.85000000E-05  +2.79800000E-05  -3.77100000E-05  -1.43107900E-02  -1.32106500E-02
   +4.53690000E-04  +4.37610000E-04  +2.79870000E-04  +1.14743000E-03  -2.42610000E-04
   -2.18970000E-04  -8.04000000E-06  -1.25580000E-03  +6.83000000E-05  +3.21400000E-04
   +1.21750000E-04  -1.39430000E-04  +4.67090000E-04  -3.75650000E-04  -3.81410000E-04
   +1.72520000E-04  +2.91550000E-04  +1.81000000E-05  -4.52860000E-04  +4.14320000E-04
   -1.90740000E-04  -6.11600000E-05  +1.67160000E-04  +3.04530000E-04  +2.19190000E-04
   +5.66000000E-04  -4.18520000E-04  -1.86380000E-04  +1.08190000E-04  +2.92150000E-04
   +4.35600000E-05  -1.92550000E-04  +1.64520000E-04  -3.18000000E-06  -1.29447130E-01
   -1.45878760E-01  +5.51010000E-03  +2.76100000E-05  +3.69600000E-05  +1.69300000E-05
   -7.88300000E-05  -1.13880000E-04  -4.41000000E-06  +2.50000000E-06  +3.82700000E-05
   -6.47300000E-05  +2.64280000E-04  -8.94000000E-05  +1.51840000E-04  -4.47900000E-05
   -5.96000000E-06  -3.81000000E-06  +1.14040000E-04  +7.08600000E-05  -1.16000000E-06
   +1.44400000E-05  +6.36460000E-04  -9.14100000E-05  +2.55730000E-04  +3.06100000E-05
   +1.29800000E-05  -1.38526600E-02  -1.01610700E-02  -7.64960000E-04  +1.42039980E-01
   +1.58004900E-01  +8.70910000E-04  -5.85800000E-05  -7.56380000E-04  +1.42471000E-03
   -1.96565000E-03  -4.73025000E-03  -1.36161000E-03  -1.07436000E-03  +4.05940000E-04
   +8.18900000E-05  -1.94270000E-04  -2.96800000E-04  +1.44400000E-04  +1.32650000E-04
   -2.55700000E-05  -1.89350000E-04  +4.97000000E-06  +3.03550000E-04  -2.14597500E-02
   -1.68509900E-02  -1.05188000E-03  -9.61290000E-04  -1.10672000E-03  +1.27569000E-03
   -1.37240000E-04  -8.17300000E-05  +4.21100000E-05  -1.08841000E-03  +1.20320000E-04
   +8.75700000E-04  +1.84510000E-04  +4.32000000E-06  +3.04600000E-05  -3.08030000E-04
   -2.31780000E-04  +2.55270000E-04  +1.97610000E-04  +8.69000000E-05  -3.76610000E-04
   +3.14960000E-04  -1.71570000E-04  -4.58800000E-05  -1.42090000E-04  +1.98120000E-04
   +2.60200000E-04  -3.59510000E-04  +3.25170000E-04  +5.80600000E-05  +2.75900000E-05
   +2.06810000E-04  +1.75800000E-05  -1.82990000E-04  +1.06210000E-04  -1.10600000E-05
   +6.79204000E-03  +6.94951000E-03  -4.76987600E-02  +2.01700000E-05  +2.63800000E-05
   +6.98000000E-06  -1.25870000E-04  -8.17700000E-05  -3.14400000E-05  +1.18000000E-06
   +3.72200000E-05  +1.21100000E-05  -1.44440000E-04  +4.63880000E-04  +3.96720000E-04
   -2.32200000E-05  -3.38800000E-05  +2.75000000E-06  +5.62800000E-05  +1.53500000E-05
   -8.31400000E-05  +2.08270000E-04  +4.39050000E-04  -7.10840000E-04  +2.99870000E-04
   +1.89790000E-04  +2.24740000E-04  +2.26477500E-02  +1.46451500E-02  +7.28450000E-04
   -7.03807000E-03  -2.51118000E-03  +5.19388300E-02  -4.27800000E-04  -7.23000000E-04
   +6.48140000E-04  +1.16230000E-04  -9.89800000E-05  +1.53750000E-04  +1.16640000E-04
   +7.21100000E-05  -1.22200000E-05  +4.92000000E-05  +1.86800000E-05  -2.40300000E-05
   -1.53690000E-04  +2.93000000E-06  +3.86600000E-05  +8.00700000E-05  -1.06670000E-04
   -2.33490000E-04  -7.39000000E-06  -7.66370000E-04  -4.42410000E-04  +4.10850000E-04
   -3.91800000E-04  -7.46240000E-04  +7.15800000E-05  +3.11100000E-05  -2.32200000E-05
   +2.43220000E-04  +5.14350000E-04  +8.03290000E-04  +4.32400000E-05  -3.87830000E-04
   +8.72600000E-05  -2.19190000E-04  -2.95510000E-04  +1.79800000E-04  +3.25700000E-04
   -8.56300000E-05  -3.01270000E-04  +1.70480000E-04  -3.81700000E-05  -3.02200000E-05
   +4.02630000E-04  +3.41430000E-04  -5.45000000E-06  +1.13400000E-04  -5.21800000E-05
   -1.12730000E-04  +1.60200000E-05  +2.78550000E-04  +2.15100000E-05  -2.74020000E-04
   +1.75930000E-04  -7.85000000E-06  -2.30626420E-01  +1.24730750E-01  +5.91032000E-03
   -1.42600000E-05  -7.59000000E-06  -6.90000000E-06  +4.30000000E-06  +2.39300000E-05
   -7.06000000E-06  -1.77300000E-05  +4.41000000E-06  -5.11000000E-06  -4.83410000E-04
   -1.34830000E-03  -2.04710000E-04  +3.46700000E-05  -8.58000000E-06  +2.26900000E-05
   +4.21450000E-04  -1.55650000E-04  +2.04690000E-04  -2.53730000E-04  +8.65000000E-05
   +1.28940000E-04  +2.64640000E-04  -2.58450000E-04  -1.69700000E-05  -3.06500000E-04
   -8.57120000E-04  +1.43810000E-04  -1.96972100E-02  +1.49002300E-02  -2.61600000E-05
   +2.49666230E-01  +2.05600000E-05  -4.44420000E-04  -7.92740000E-04  +6.31390000E-04
   +5.90740000E-04  +4.89100000E-04  -2.71010000E-04  -1.59010000E-04  -1.95400000E-04
   +1.63830000E-04  +1.99020000E-04  +3.86700000E-05  -8.19900000E-05  -4.64000000E-05
   +1.00690000E-04  -3.21150000E-04  +1.15570000E-04  +3.21330000E-04  +1.59220000E-02
   -1.10804400E-02  -6.11020000E-04  +1.09020000E-04  +4.95420000E-04  +1.66063000E-03
   +1.15880000E-04  +1.54820000E-04  +6.29200000E-05  -1.27958000E-03  -1.12690000E-03
   -3.18518000E-03  -3.49950000E-04  +5.31300000E-05  +2.71200000E-04  +4.95120000E-04
   +3.77890000E-04  -2.49950000E-04  -3.80130000E-04  +1.27340000E-04  +3.64250000E-04
   +1.09650000E-04  +1.91800000E-04  +1.11120000E-04  +5.44140000E-04  -1.62780000E-04
   +3.45900000E-05  +3.37690000E-04  -1.07681000E-03  -1.14010000E-04  -7.44800000E-05
   -2.89920000E-04  -2.90500000E-05  +3.55240000E-04  -2.93860000E-04  -1.32100000E-05
   +1.23618640E-01  -1.30440160E-01  -3.72672000E-03  -3.99000000E-06  -2.15400000E-05
   -3.32000000E-06  +2.37000000E-05  -3.31000000E-06  +2.55100000E-05  +2.28100000E-05
   +3.43600000E-05  +1.16360000E-04  -8.97700000E-04  -1.31445000E-03  +8.62380000E-04
   -4.52000000E-06  -3.18800000E-05  -1.22800000E-05  -3.44090000E-04  +6.25340000E-04
   -2.19440000E-04  -1.61530000E-04  -1.95500000E-05  -1.14380000E-04  -3.05910000E-04
   -4.91500000E-05  +1.79080000E-04  +1.45896300E-02  -9.51880000E-03  -1.36484000E-03
   -1.70547500E-02  +1.23723500E-02  +3.67000000E-04  -1.35320810E-01  +1.40379590E-01
   -2.88470000E-04  +2.28190000E-04  +5.40360000E-04  +6.71500000E-05  +7.18030000E-04
   +7.77440000E-04  -6.28200000E-05  +3.06100000E-05  -2.90870000E-04  +1.25630000E-04
   +1.03860000E-04  -3.86700000E-05  -1.50920000E-04  +2.17000000E-06  +1.64400000E-04
   -9.04700000E-05  -1.53540000E-04  -1.50350000E-04  +2.27802900E-02  -1.51135100E-02
   -2.89545000E-03  +1.46090000E-03  -9.37120000E-04  +7.97410000E-04  +7.12900000E-05
   +4.96800000E-05  -2.66400000E-05  -1.45488000E-03  -2.54641000E-03  -4.05618000E-03
   +3.08970000E-04  -1.87440000E-04  -1.51920000E-03  +8.81140000E-04  +4.28640000E-04
   -2.69760000E-04  -5.79700000E-04  -9.08500000E-05  +8.60710000E-04  -2.68730000E-04
   +6.10490000E-04  +1.46580000E-04  +1.36182000E-03  -3.89690000E-04  -1.97830000E-04
   -8.46400000E-04  +1.46943000E-03  +8.03580000E-04  -8.11300000E-05  -3.78490000E-04
   +3.68200000E-05  +4.21480000E-04  -3.35260000E-04  +2.32700000E-05  +4.85778000E-03
   -2.59689000E-03  -4.68463300E-02  -5.35000000E-06  -2.04800000E-05  -4.16000000E-06
   +3.23800000E-05  -1.12700000E-05  +1.47700000E-05  +3.89100000E-05  -2.49400000E-05
   +3.03500000E-05  +5.09900000E-05  +1.60550000E-04  +3.35000000E-06  +1.54600000E-05
   -6.37000000E-06  +1.14500000E-05  -5.73000000E-04  +1.36500000E-05  -9.17440000E-04
   +5.25200000E-05  +1.50310000E-04  -5.02600000E-05  -1.73280000E-04  +1.35900000E-04
   +4.27470000E-04  -2.32501900E-02  +1.37771800E-02  +1.52579000E-03  +9.87640000E-04
   -5.27920000E-04  -9.44700000E-04  -6.38224000E-03  +6.00860000E-03  +5.19962600E-02
   -3.90700000E-05  -9.21000000E-06  -4.51800000E-05  -2.84840000E-04  +2.01250000E-04
   -9.34900000E-05  -4.17200000E-05  +9.27400000E-05  +1.16000000E-04  -1.83000000E-06
   -2.34000000E-06  -5.36100000E-05  -2.46300000E-05  -3.15100000E-05  -9.90000000E-07
   +3.16800000E-05  +4.23000000E-06  +2.42600000E-05  -2.31760000E-04  -1.85003000E-03
   -1.53957000E-03  -2.27537000E-03  +7.11120000E-04  +1.12497000E-03  +4.22300000E-05
   +3.57600000E-05  -4.50000000E-06  +8.63953000E-03  -1.59070300E-02  +1.45844500E-02
   -1.82086000E-03  +2.92633000E-03  +3.90739000E-03  -7.47930000E-04  -5.63250000E-04
   +2.88080000E-04  -2.67083000E-03  +2.76166000E-03  +2.05615000E-03  -3.12264000E-03
   +2.00590500E-02  -1.97776100E-02  -6.46326900E-02  +4.45127900E-02  -3.30162800E-02
   +1.25880000E-04  -1.36018000E-03  +1.84981000E-03  +2.16160000E-04  +5.01290000E-04
   +5.38000000E-05  -2.49950000E-04  +1.27201000E-03  -8.16660000E-04  +3.20070000E-04
   +8.31900000E-05  -2.04620000E-04  -6.90000000E-06  -1.09200000E-05  +7.10000000E-07
   +3.60000000E-06  -1.32000000E-06  +7.13000000E-06  +7.67300000E-05  -7.45200000E-05
   -4.45000000E-06  +0.00000000E+00  -8.19000000E-06  -3.48000000E-06  +8.22000000E-06
   -8.71000000E-06  +2.17000000E-06  +1.82770000E-04  -1.48460000E-04  -4.90800000E-05
   -1.36122000E-03  +1.17953000E-03  +2.76480000E-04  -1.86079000E-03  +2.46880000E-04
   -4.28400000E-04  +2.30200000E-05  -5.87200000E-05  -1.50660000E-04  +4.89300000E-05
   -4.24300000E-05  +1.11000000E-06  -4.83600000E-05  -3.54700000E-05  -1.55100000E-05
   +6.99965900E-02  -1.19120000E-04  -1.47590000E-04  -1.35010000E-04  -3.97930000E-04
   +4.89700000E-04  +3.61100000E-04  -1.13450000E-04  +6.27300000E-05  +2.18110000E-04
   +6.07000000E-06  -3.12800000E-05  -6.07300000E-05  +4.88700000E-05  +7.44200000E-05
   +3.39700000E-05  -1.46700000E-05  -4.37900000E-05  +3.92000000E-06  -6.72360000E-04
   -3.52550000E-03  -2.34883000E-03  +2.39616000E-03  +6.27100000E-05  -2.99920000E-04
   -6.78500000E-05  -7.91600000E-05  -2.66000000E-05  +9.19040000E-04  -2.19589000E-03
   +7.00384000E-03  -5.76600000E-04  +6.02775000E-03  +2.75288000E-03  +8.21550000E-04
   -5.26770000E-04  -8.89290000E-04  +3.44979000E-03  +1.84820000E-03  -6.44490000E-04
   +2.50543000E-03  -7.65867000E-03  +1.01635100E-02  +4.38442900E-02  -1.93289120E-01
   +1.47828170E-01  +3.13840000E-04  -8.67610000E-04  +9.38470000E-04  -1.05800000E-04
   +5.13250000E-04  +1.60640000E-04  +1.58260000E-04  -7.08730000E-04  +5.55050000E-04
   +7.22130000E-04  -2.86860000E-04  -1.42200000E-04  -3.10000000E-06  +6.08000000E-06
   +1.14800000E-05  -1.29800000E-05  -1.96200000E-05  +1.73000000E-06  -2.22200000E-05
   -9.34200000E-05  +1.12200000E-05  +1.37900000E-05  +2.55000000E-06  -1.33500000E-05
   -1.13100000E-05  -1.99000000E-05  +1.35000000E-06  +1.28520000E-04  -1.02710000E-04
   -5.84990000E-04  +1.84145000E-03  -8.32720000E-04  -3.21440000E-04  -1.35570000E-04
   -2.04750000E-04  -3.67450000E-04  -7.06000000E-06  -3.01200000E-05  -1.50700000E-05
   -6.91000000E-06  -1.19900000E-05  +3.22000000E-06  -6.28900000E-05  -7.08100000E-05
   -1.75850000E-04  -5.39248500E-02  +2.01116570E-01  -7.22400000E-05  -1.25860000E-04
   -8.85400000E-05  -3.26840000E-04  +2.85890000E-04  +2.61150000E-04  -1.99400000E-05
   -7.36000000E-06  +1.06560000E-04  -1.54900000E-05  -3.51100000E-05  +2.46400000E-05
   +6.49600000E-05  +9.19900000E-05  +2.16900000E-05  -2.19000000E-05  -6.67200000E-05
   -4.46000000E-06  -2.52869000E-03  -1.53385000E-03  -2.37430000E-03  -7.30220000E-04
   +8.63950000E-04  +6.80510000E-04  -1.09270000E-04  -1.16640000E-04  -1.67400000E-05
   -4.71229000E-03  +1.71508300E-02  -1.05353800E-02  +2.62973000E-03  +2.87306000E-03
   +9.55260000E-04  +1.22372000E-03  -1.04336000E-03  -4.93850000E-04  +2.40089000E-03
   +5.88570000E-04  +1.67858000E-03  +2.72480000E-03  -3.53086000E-03  +4.71869000E-03
   -3.20627200E-02  +1.48107610E-01  -1.82215670E-01  +6.19580000E-04  +5.20550000E-04
   -7.66820000E-04  -3.08000000E-06  +5.09350000E-04  +1.54390000E-04  -1.62420000E-04
   -1.14110000E-04  +1.33420000E-04  +7.83960000E-04  -1.90240000E-04  -9.31200000E-05
   -4.70000000E-07  +1.95300000E-05  +7.28000000E-06  -1.91300000E-05  -1.26400000E-05
   -1.19900000E-05  -6.62000000E-06  +3.60300000E-05  -2.12000000E-06  +6.40000000E-07
   +2.12800000E-05  -1.81900000E-05  -1.74000000E-05  -1.09300000E-05  +3.00000000E-07
   -4.88260000E-04  -3.98670000E-04  +1.89390000E-04  +1.35750000E-04  -9.08500000E-04
   +1.08920000E-04  -5.17610000E-04  +1.48820000E-04  +1.28660000E-04  -6.65500000E-05
   -5.23000000E-06  +9.25800000E-05  +3.28000000E-06  -6.46800000E-05  -1.03510000E-04
   -6.45000000E-06  -1.28440000E-04  -1.75710000E-04  +3.26340900E-02  -1.62548050E-01
   +1.87653530E-01  -6.32800000E-05  -7.41500000E-05  -6.01200000E-05  -1.08730000E-04
   +2.95820000E-04  +8.55700000E-05  -3.09800000E-05  +2.57000000E-06  +4.72100000E-05
   -2.08900000E-05  -3.09900000E-05  +1.22900000E-05  +4.18800000E-05  +4.51500000E-05
   +8.10000000E-06  -6.23000000E-06  -3.41800000E-05  +1.00400000E-05  -2.59530000E-04
   -9.16380000E-04  +6.14690000E-04  +2.97100000E-05  -8.13700000E-05  +5.50300000E-05
   -6.24700000E-05  -6.34700000E-05  -1.14100000E-05  -2.41665000E-03  +4.16754000E-03
   -7.50100000E-05  +1.04644000E-03  +1.06538000E-03  +3.81480000E-04  +4.98430000E-04
   +2.38534000E-03  +2.17024000E-03  +8.92465000E-03  +6.45067000E-03  -6.68096000E-03
   -1.64253110E-01  -3.92421400E-02  +1.37114780E-01  -1.16680000E-02  -7.00715000E-03
   +1.98487400E-02  -8.21600000E-05  -3.08260000E-04  -1.39240000E-04  -8.58100000E-05
   +4.25290000E-04  -5.71440000E-04  -4.25730000E-04  -2.56818000E-03  -1.04893000E-03
   -1.06490000E-04  +9.37000000E-06  -6.56200000E-05  -3.00000000E-08  +9.51000000E-06
   +6.17000000E-06  -1.61600000E-05  -1.19500000E-05  -7.09000000E-06  +6.25000000E-06
   +2.58200000E-05  +9.59000000E-06  +4.32000000E-06  +1.42600000E-05  -9.48000000E-06
   -9.69000000E-06  -9.44000000E-06  +9.70000000E-07  -1.11100000E-05  +3.56700000E-05
   -1.68800000E-05  +2.06100000E-05  +1.61400000E-05  +9.60000000E-07  -1.35900000E-05
   +9.15000000E-06  -1.48900000E-05  -9.80000000E-07  +2.20000000E-06  +8.55000000E-06
   +1.94500000E-05  -1.58000000E-06  -2.60000000E-07  -2.54000000E-05  +5.57000000E-05
   +4.64100000E-05  +2.39890000E-04  -7.65000000E-04  -9.53760000E-04  +1.68693010E-01
   -6.06000000E-06  -2.36000000E-06  +2.61000000E-06  +1.53780000E-04  -7.69600000E-05
   -5.24000000E-06  -3.30000000E-07  +5.10000000E-07  +3.26700000E-05  -1.27000000E-06
   -1.19600000E-05  -4.76000000E-06  -1.32600000E-05  -1.02000000E-05  -7.13000000E-06
   +4.96000000E-06  +2.02500000E-05  -2.90000000E-07  +8.75800000E-05  +1.82970000E-04
   -4.15250000E-04  -2.11100000E-05  +5.51100000E-05  -3.11500000E-05  +1.89600000E-05
   +8.01000000E-06  +2.28000000E-06  +5.17783000E-03  +7.69950000E-04  +3.72300000E-04
   +9.05480000E-04  -6.13510000E-04  +4.34180000E-04  +3.60906000E-03  -1.29646000E-03
   +8.14191000E-03  -1.66767100E-02  +4.69782000E-03  +1.68551400E-02  -3.44877500E-02
   -7.06644600E-02  +5.90747200E-02  +8.25287000E-03  +8.47507000E-03  -1.17596700E-02
   -2.34270000E-04  -1.79900000E-05  -2.44480000E-04  +1.21560000E-04  +1.01280000E-03
   -6.91350000E-04  -1.33954000E-03  -1.02535000E-03  -3.53905000E-03  +1.23260000E-04
   -6.23000000E-06  +3.33500000E-05  -5.93000000E-06  +1.48000000E-06  -1.84000000E-06
   -7.29000000E-06  -3.90000000E-07  -1.97000000E-06  +5.22000000E-06  +1.83300000E-05
   +4.51000000E-06  +3.67000000E-06  -4.01000000E-06  -3.23000000E-06  +1.79000000E-06
   +1.89000000E-06  -2.07000000E-06  -4.06000000E-06  -1.81700000E-05  +3.36000000E-05
   -4.57000000E-06  -4.36000000E-05  -1.14400000E-05  +8.77000000E-06  +2.93800000E-05
   +2.44100000E-05  -2.68000000E-06  -1.24000000E-06  -1.04000000E-06  -1.46100000E-05
   -1.17600000E-05  -1.11100000E-05  +1.16000000E-06  -2.44900000E-05  -3.33100000E-05
   -1.08531000E-03  -5.27550000E-04  -1.03674000E-03  +3.64784400E-02  +5.97547400E-02
   -1.98200000E-05  -1.95100000E-05  +7.63000000E-06  +3.38500000E-05  +1.15600000E-05
   +2.76200000E-05  -3.27000000E-06  -2.00000000E-08  +1.69300000E-05  +7.01000000E-06
   -1.19900000E-05  -1.08300000E-05  -3.48100000E-05  -2.95900000E-05  -1.04200000E-05
   +9.23000000E-06  +1.67200000E-05  +1.47100000E-05  -3.64660000E-04  -2.08570000E-04
   -1.54750000E-04  +4.48300000E-05  +3.62000000E-06  -3.35500000E-05  +4.09800000E-05
   +3.25700000E-05  +3.34000000E-06  +1.12799000E-03  +1.22349000E-03  +1.94175000E-03
   -7.14600000E-05  +5.76450000E-04  +7.34080000E-04  +6.08640000E-04  +4.44374000E-03
   +2.05567000E-03  +1.63009400E-02  +7.21842000E-03  -1.06659300E-02  +1.36226750E-01
   +5.71155600E-02  -2.12113940E-01  -1.97446000E-03  +2.49659000E-03  +2.80555000E-03
   +2.36900000E-05  -2.43390000E-04  -3.59550000E-04  -3.37910000E-04  +3.94280000E-04
   -5.55750000E-04  -1.53622000E-03  -3.51127000E-03  -3.16180000E-04  +1.78440000E-04
   -3.88400000E-05  +2.09200000E-05  -8.13000000E-06  -5.41000000E-06  -2.76000000E-06
   -2.32000000E-06  +2.00000000E-06  +6.70000000E-07  -2.00000000E-08  +1.53000000E-06
   -1.20000000E-05  -4.25000000E-06  +1.36000000E-06  -1.53000000E-06  +9.10000000E-07
   +1.10000000E-06  -2.64000000E-06  +1.08700000E-05  -8.69000000E-06  +1.50700000E-05
   +7.75000000E-06  -6.50000000E-07  -4.91000000E-06  -1.41600000E-05  +1.79400000E-05
   +1.11000000E-06  -9.60000000E-06  +1.12500000E-05  -3.00000000E-07  -3.37000000E-06
   +5.56000000E-06  +9.69000000E-06  +5.42000000E-06  -2.35900000E-05  -4.26600000E-05
   -4.83760000E-04  -1.30527000E-03  -2.94680000E-04  -1.50080570E-01  -6.77740000E-02
   +2.17701410E-01  +4.47200000E-05  -2.24000000E-06  -8.00000000E-08  +1.92420000E-04
   +5.70000000E-05  +2.47600000E-05  -2.07000000E-05  -2.35500000E-05  -1.07300000E-05
   +3.21000000E-05  +2.15300000E-05  -2.39700000E-05  -4.67200000E-05  -3.14900000E-05
   +4.37000000E-06  -1.64900000E-05  -1.80600000E-05  +1.62300000E-05  +2.46100000E-04
   +8.59860000E-04  -1.19441000E-03  -3.99040000E-04  +1.75320000E-04  +1.66520000E-04
   +4.54000000E-05  +4.33000000E-05  +6.74000000E-06  -5.90545000E-03  -2.57001000E-03
   +3.19433000E-03  -2.99321000E-03  +1.73427100E-02  -2.16463100E-02  -1.00129240E-01
   +5.33314700E-02  -9.63366200E-02  +1.21569100E-02  -7.95654000E-03  +2.20206600E-02
   -4.04231000E-03  +1.85278000E-03  +2.14468000E-03  +1.95891000E-03  +1.95320000E-04
   -9.07420000E-04  +2.83934000E-03  -1.48882000E-03  -2.21060000E-04  -2.20000000E-06
   -4.12457000E-03  -1.28356000E-03  +1.00150000E-03  +8.94300000E-05  -2.68546000E-03
   +1.62760000E-04  -1.11800000E-04  -9.47400000E-05  -6.07000000E-06  -1.05600000E-05
   -3.52000000E-06  +4.33000000E-06  +3.08000000E-06  +5.52000000E-06  -2.57500000E-05
   -1.75200000E-05  -6.37000000E-06  -1.93400000E-05  +1.58400000E-05  +8.41000000E-06
   -4.58000000E-06  +2.85000000E-06  -3.75000000E-06  -4.21000000E-06  +1.02980000E-04
   -1.25660000E-04  +8.70000000E-06  +3.24300000E-05  -1.27800000E-05  -4.32000000E-06
   -1.32600000E-05  -7.85000000E-06  -2.82400000E-05  +3.54800000E-05  +7.47500000E-05
   +3.96000000E-06  +4.49300000E-05  +3.59200000E-05  +3.19700000E-05  -3.10100000E-05
   +1.12900000E-05  +1.13250000E-04  +5.64500000E-05  -1.77300000E-05  -4.78560000E-04
   -1.56927000E-03  -4.03590000E-04  +9.52623700E-02  -1.20100000E-05  +3.64900000E-05
   +7.21500000E-05  +3.55700000E-05  -1.92880000E-04  -2.30000000E-05  -4.44000000E-06
   +1.88400000E-05  -2.48000000E-06  +1.05800000E-05  -4.91000000E-06  -5.14300000E-05
   -9.74900000E-05  -1.21480000E-04  -4.19400000E-05  +4.29800000E-05  +8.17700000E-05
   +1.57000000E-05  +1.36270000E-04  +8.41550000E-04  +3.92770000E-04  +1.09050000E-04
   -4.32400000E-05  -7.00000000E-08  +1.41860000E-04  +1.39640000E-04  +9.76000000E-06
   -1.19788000E-03  -2.43363000E-03  +3.72234000E-03  +4.89591000E-03  +7.58871000E-03
   +1.08979800E-02  +4.97838100E-02  -6.90364700E-02  +1.04261860E-01  +2.56413000E-03
   -3.81894000E-03  +1.56635200E-02  -3.16941000E-03  +6.12373000E-03  -3.41700000E-05
   +3.67643000E-03  -1.22666000E-03  -2.29315000E-03  -3.38075000E-03  -8.47710000E-04
   -1.43776000E-03  -3.50310000E-04  -1.69838500E-02  -1.07529600E-02  -5.23030000E-04
   +1.69660000E-04  -2.98732000E-03  +9.96500000E-05  +1.96400000E-05  +1.05810000E-04
   -1.18700000E-05  -2.94000000E-05  -5.25000000E-06  +1.47000000E-05  +1.13400000E-05
   +1.56500000E-05  -4.86200000E-05  -4.45200000E-05  -4.81200000E-05  -2.94000000E-06
   -1.43800000E-05  +3.99000000E-06  +1.58900000E-05  +6.57000000E-06  -2.32000000E-06
   +3.23900000E-05  -6.88400000E-05  -1.55500000E-05  -1.88900000E-05  +3.66500000E-05
   -3.48000000E-06  -2.45800000E-05  +8.16000000E-06  -5.76000000E-05  +9.57000000E-06
   +3.18800000E-05  -4.75900000E-05  -1.97500000E-05  +3.27700000E-05  +5.18000000E-05
   +3.49100000E-05  -4.16600000E-05  -5.69600000E-05  +1.06610000E-04  +5.74600000E-05
   +1.00500000E-05  -5.95830000E-04  -7.15900000E-04  -6.53460000E-04  -5.53931100E-02
   +8.64287300E-02  -2.25000000E-05  +1.14300000E-05  +2.84000000E-05  +1.91600000E-05
   -7.24200000E-05  +2.16200000E-05  +9.20000000E-06  -1.63400000E-05  -1.14800000E-05
   +3.96000000E-06  -1.18000000E-06  -1.34800000E-05  -4.73600000E-05  -4.96900000E-05
   -1.63500000E-05  +1.54800000E-05  +2.64900000E-05  +1.05100000E-05  +1.95880000E-04
   +2.00090000E-04  -5.99900000E-05  -2.58700000E-05  -1.44500000E-05  +4.36700000E-05
   +5.82300000E-05  +5.77900000E-05  +4.09000000E-06  -1.06903000E-03  -1.77932000E-03
   +2.02822000E-03  +5.46116000E-03  +3.96381000E-03  +4.15084000E-03  -9.39918000E-02
   +1.10785320E-01  -2.67826980E-01  -1.21189600E-02  +8.57024000E-03  -7.80146000E-03
   +2.02596000E-03  +2.18874000E-03  -3.31765000E-03  +1.98831000E-03  -1.24458000E-03
   -8.94090000E-04  -4.30720000E-04  -6.23940000E-04  +1.60818000E-03  +6.68770000E-04
   -6.33132000E-03  -7.32660000E-04  -5.43460000E-04  -8.87300000E-05  +1.46284000E-03
   +5.74900000E-05  -2.31200000E-05  +3.85300000E-05  -5.46000000E-06  -1.21500000E-05
   -1.58000000E-06  +4.95000000E-06  +5.42000000E-06  +4.91000000E-06  -1.53900000E-05
   -1.21900000E-05  -1.65300000E-05  -6.62000000E-06  -3.32000000E-06  +3.31000000E-06
   +6.96000000E-06  +1.19000000E-06  -6.00000000E-07  +2.56000000E-06  -1.32900000E-05
   -1.35700000E-05  -5.23000000E-06  +9.02000000E-06  -8.67000000E-06  +1.23000000E-06
   +4.61000000E-06  -1.49000000E-05  -1.51300000E-05  +1.54800000E-05  +9.93000000E-06
   -8.07000000E-06  +2.75100000E-05  +1.01400000E-05  +2.05900000E-05  -8.77000000E-06
   -3.72000000E-06  +2.85600000E-05  +9.14400000E-05  +3.08000000E-05  -3.29610000E-04
   +9.51990000E-04  -4.17040000E-04  +9.71108000E-02  -1.13007980E-01  +2.73829300E-01
   -4.77870000E-04  -1.57630000E-04  +1.22850000E-04  +7.99800000E-05  +1.10938000E-03
   +1.36280000E-04  +1.07300000E-05  +1.03790000E-04  +1.61240000E-04  -2.05780000E-04
   -7.02190000E-04  +1.26430000E-04  -3.59630000E-04  -2.99670000E-04  -1.38400000E-04
   +2.25160000E-04  +1.23420000E-04  -2.71100000E-05  +2.98610000E-04  +4.34510000E-04
   +4.42340000E-04  -4.89080000E-04  -7.27000000E-05  -1.14060000E-04  +2.46860000E-04
   +1.20310000E-04  -7.67000000E-06  +1.50785000E-03  -1.48549000E-03  +4.84845000E-03
   -4.62171600E-02  -3.81783200E-02  -2.87680600E-02  -1.82405600E-02  -1.05990100E-02
   -1.49410200E-02  -3.70504000E-03  -1.27562000E-03  +5.95293000E-03  -2.67856000E-03
   +2.41040000E-03  -1.36211000E-03  +2.89688000E-03  -4.74020000E-04  -3.14348000E-03
   +3.40645000E-03  +9.96866000E-03  +1.60053300E-02  -4.55962000E-03  -2.34839000E-03
   -2.33885000E-03  +1.12103000E-03  -9.31940000E-04  -4.79910000E-04  -3.97790000E-04
   -3.60600000E-05  -1.64660000E-04  -1.33770000E-04  -2.35500000E-05  -2.81800000E-05
   -1.21620000E-04  +3.82900000E-05  -9.06000000E-05  +6.06000000E-06  +4.37660000E-04
   -4.32030000E-04  +8.68500000E-05  +5.40000000E-07  -1.37600000E-04  +1.67500000E-05
   -3.05600000E-05  -2.60000000E-06  -9.06300000E-05  +1.36680000E-04  -5.25400000E-05
   -6.13900000E-05  -2.18580000E-04  +6.92500000E-05  +7.99700000E-05  +7.40400000E-05
   -4.72400000E-05  +1.81590000E-04  -1.11300000E-04  -5.32000000E-06  -2.02900000E-05
   -1.50370000E-04  -7.02800000E-05  -2.61300000E-05  +1.73000000E-04  +7.51500000E-05
   -1.00900000E-04  -3.53570000E-04  -4.39550000E-04  +1.17100000E-04  +3.47490000E-04
   +2.52300000E-05  -2.40490000E-04  +2.30211000E-03  +1.20858000E-03  +7.55914700E-02
   -7.73900000E-05  -6.48100000E-05  -4.54050000E-04  +1.50513000E-03  +1.38771000E-03
   +5.95900000E-05  -4.18800000E-04  +2.15180000E-04  +1.87880000E-04  +2.54460000E-04
   -7.41400000E-04  +2.16300000E-04  -4.13670000E-04  +2.04290000E-04  +6.94790000E-04
   -1.28540000E-04  -4.89520000E-04  -2.99980000E-04  +1.82391000E-03  +1.78113000E-03
   +1.10294000E-03  -8.75680000E-04  +1.65490000E-04  +5.95970000E-04  -2.30420000E-04
   -5.57440000E-04  -1.06080000E-04  -1.13670800E-02  -4.07129500E-02  +5.19998000E-03
   +8.24800000E-05  -4.79953900E-02  -3.50519000E-02  -2.93437600E-02  +1.80972700E-02
   +3.22352000E-03  -2.11353000E-03  +3.55200000E-03  -2.90319000E-03  -8.83660000E-04
   +1.09888000E-03  -1.34154000E-03  +6.44655000E-03  -1.83712000E-03  -2.02753000E-03
   -3.12670000E-03  +5.60160000E-04  +1.76474000E-03  -1.08521700E-02  -1.43909900E-02
   -7.40420000E-03  +1.75303000E-03  -2.38415000E-03  +6.87600000E-05  -1.47536000E-03
   +5.37550000E-04  -5.80030000E-04  -2.60390000E-04  +1.23070000E-04  -3.06800000E-05
   -5.08160000E-04  +1.66200000E-05  -4.19180000E-04  +5.90200000E-05  +8.57120000E-04
   -8.99400000E-05  +1.37390000E-04  +2.51300000E-05  -1.62870000E-04  -5.92200000E-05
   -6.04800000E-05  -3.16200000E-05  -1.85650000E-04  +3.66050000E-04  -2.10340000E-04
   -2.94400000E-05  -2.07940000E-04  +5.49000000E-06  +1.60360000E-04  +2.59500000E-05
   -1.11350000E-04  +1.76910000E-04  -7.25300000E-05  +6.19900000E-05  -1.71900000E-05
   -2.58360000E-04  -1.19480000E-04  -1.97550000E-04  +4.01150000E-04  +4.64600000E-04
   +8.22980000E-04  +1.12057000E-03  +5.59060000E-04  -2.16060000E-04  -9.20500000E-05
   -2.43460000E-04  -1.32249000E-03  -3.33196000E-03  -1.12148000E-03  +2.77826800E-02
   +7.26975200E-02  -3.27550000E-04  -1.31250000E-04  -1.52630000E-04  +3.64120000E-04
   +8.99930000E-04  -1.08500000E-05  -5.19870000E-04  +1.42110000E-04  +9.03410000E-04
   +5.13500000E-05  -6.23160000E-04  -9.47600000E-05  -4.59910000E-04  -2.08100000E-04
   +1.86380000E-04  +1.73030000E-04  +2.00000000E-07  -1.87680000E-04  -5.03110000E-04
   +3.28990000E-04  +9.56880000E-04  -3.99340000E-04  +4.57700000E-05  -9.96100000E-05
   +2.54690000E-04  +2.92200000E-05  -6.45600000E-05  -3.37876000E-03  -1.32542200E-02
   +1.27614600E-02  +1.21315200E-02  -8.81593000E-03  -4.27035000E-02  -2.60746100E-02
   +1.28408700E-02  -2.93563000E-03  -2.99984000E-03  +5.83980000E-04  +4.15844000E-03
   -6.82443000E-03  +8.47508000E-03  -3.76222000E-03  +1.65608000E-02  -1.75679000E-03
   -9.50640000E-03  -8.75014000E-03  -1.94225000E-02  -2.77931600E-02  -7.44970000E-03
   -1.17613600E-02  -5.43166000E-03  +5.45790000E-04  +2.85100000E-05  -4.94790000E-04
   -4.27690000E-04  +3.77500000E-05  -3.12170000E-04  -2.14160000E-04  -7.07000000E-06
   -2.63200000E-05  -2.49870000E-04  +1.45500000E-05  -1.83930000E-04  -2.71550000E-04
   +7.57840000E-04  -8.44530000E-04  +1.00940000E-04  -1.41000000E-06  -1.55510000E-04
   +1.15700000E-05  -4.56000000E-05  -1.92900000E-05  -1.13470000E-04  +9.00600000E-05
   -1.75600000E-05  -9.19600000E-05  -2.68580000E-04  +1.97900000E-05  +9.74900000E-05
   +1.11900000E-04  -6.04300000E-05  +6.50600000E-05  +1.60500000E-05  -8.13700000E-05
   +7.91000000E-06  -1.90420000E-04  -5.05800000E-05  +6.20000000E-07  +1.94400000E-04
   +9.92100000E-05  +1.96400000E-05  -1.08650000E-04  +6.08100000E-05  -5.03070000E-04
   -2.74200000E-05  -4.00470000E-04  -1.66462000E-03  -2.68314000E-03  -1.02730000E-03
   +1.09516600E-02  +1.63453500E-02  +7.40244600E-02  -1.81800000E-05  +7.18000000E-06
   +1.07200000E-05  +2.42000000E-06  +3.41300000E-05  +1.71900000E-05  -5.14000000E-06
   -2.11000000E-05  +3.91100000E-05  +7.50300000E-05  -8.62600000E-05  -2.09700000E-05
   -1.79060000E-04  -1.06230000E-04  +3.65000000E-05  +1.90700000E-05  -4.34000000E-06
   +1.08900000E-05  -2.23080000E-04  -6.49800000E-05  +8.17000000E-06  -1.46000000E-05
   +5.89000000E-06  -2.32100000E-05  +1.54830000E-04  +8.78900000E-05  +1.26800000E-05
   -1.84241000E-03  -1.75833000E-03  +1.39463000E-03  +2.04331000E-03  +2.16261000E-03
   +1.47867000E-03  -3.53344000E-03  +1.39967500E-02  +4.22650000E-04  +9.14748000E-03
   +3.53726900E-02  -8.28626000E-03  -1.02986000E-02  +7.24335000E-03  -2.50430000E-04
   +3.00483000E-03  -8.71390000E-04  -3.02509000E-03  -2.53210000E-04  -3.69520000E-04
   -2.14300000E-04  +7.69743000E-03  +2.17510000E-04  -5.36588000E-03  -8.11328100E-02
   -1.09563010E-01  +4.35032200E-02  +4.47700000E-05  -2.08600000E-05  -5.41000000E-06
   -5.83100000E-05  -1.01000000E-05  -2.15300000E-05  -4.20600000E-05  +2.34900000E-05
   -3.42700000E-05  -3.56700000E-05  +5.89400000E-05  -6.24300000E-05  -6.76000000E-06
   +7.26000000E-06  -1.61300000E-05  +1.35000000E-06  +4.51000000E-06  -1.01600000E-05
   +9.69000000E-06  -4.49000000E-06  +4.90000000E-06  -2.91800000E-05  -1.94700000E-05
   -1.02200000E-05  +3.80000000E-06  +1.84200000E-05  -8.69000000E-06  -8.76000000E-06
   +3.32500000E-05  +1.44000000E-05  -1.35700000E-05  +2.21000000E-06  +1.93400000E-05
   +2.77800000E-05  -3.71000000E-06  -6.91000000E-06  -3.21450000E-04  +2.82820000E-04
   +1.14040000E-04  +4.54470000E-04  +2.60910000E-04  +6.05270000E-04  -5.40990000E-04
   -6.73400000E-04  -2.26300000E-05  +3.77880000E-04  +4.07200000E-04  -6.42710000E-04
   +7.24112600E-02  -1.28200000E-05  -1.44600000E-05  -7.16800000E-05  -2.23300000E-05
   +2.49070000E-04  +2.94600000E-05  -3.61700000E-05  -2.31700000E-05  +2.25500000E-05
   +1.22800000E-05  -7.87400000E-05  +4.63600000E-05  +3.70300000E-05  +9.92800000E-05
   +8.35600000E-05  -2.70500000E-05  -9.71600000E-05  -3.79400000E-05  +7.57200000E-05
   -2.83990000E-04  +3.41400000E-05  -1.12350000E-04  -9.81000000E-06  +3.30600000E-05
   -1.07180000E-04  -1.57520000E-04  -9.57000000E-06  -1.86731000E-03  -7.32110000E-04
   +2.93740000E-04  +3.28134000E-03  +1.10309000E-03  +2.24276000E-03  -5.12895000E-03
   +1.30355700E-02  +2.16920000E-04  +2.17678600E-02  -5.12366400E-02  +1.06722400E-02
   -3.57255000E-03  +5.60912000E-03  -3.26438000E-03  +2.55180000E-03  -9.52870000E-04
   -1.97430000E-04  -1.23071000E-03  -2.85460000E-04  +6.45230000E-04  +1.69459400E-02
   -9.46902000E-03  -2.94791000E-03  -8.49904300E-02  -3.17104000E-01  +8.64345700E-02
   -1.83420000E-04  +5.25800000E-05  -9.03800000E-05  -2.37100000E-05  +3.97200000E-05
   -6.65000000E-06  -5.51800000E-05  +9.80000000E-07  -5.27000000E-05  +4.00000000E-06
   +9.00700000E-05  +4.36000000E-06  +1.89400000E-05  +1.57100000E-05  -2.63700000E-05
   -1.48700000E-05  -6.38000000E-06  +0.00000000E+00  -3.83900000E-05  +4.50000000E-05
   -1.16900000E-05  -8.19000000E-06  -4.93600000E-05  +1.09000000E-06  +3.22000000E-05
   +8.17000000E-06  -8.75000000E-06  +1.98800000E-05  -6.61000000E-06  +1.13200000E-05
   -2.12000000E-06  -5.24800000E-05  -2.21000000E-05  -4.28600000E-05  +7.12300000E-05
   +7.03700000E-05  -5.50200000E-05  +1.69060000E-04  -2.00000000E-06  +1.20270000E-04
   -1.02080000E-04  +1.62030000E-04  -2.31300000E-04  -1.34533000E-03  -1.27628000E-03
   +1.11987000E-03  +1.07395000E-03  -1.80000000E-05  +5.23225100E-02  +3.61997410E-01
   -1.10800000E-05  +9.40000000E-07  +5.75700000E-05  +8.25700000E-05  -2.00730000E-04
   -2.24300000E-05  +3.14900000E-05  +4.02300000E-05  +1.82300000E-05  -1.43100000E-05
   +3.02100000E-05  -2.41100000E-05  -1.18600000E-05  -6.05800000E-05  -5.93900000E-05
   +3.15000000E-05  +8.32300000E-05  +1.69800000E-05  -1.09140000E-04  +2.45870000E-04
   -1.64730000E-04  +6.58100000E-05  +3.89800000E-05  -2.95800000E-05  +6.34600000E-05
   +8.62400000E-05  -3.00000000E-08  +1.61050000E-03  +5.43910000E-04  -6.48040000E-04
   -1.98323000E-03  -1.64520000E-03  -8.51360000E-04  +4.20401000E-03  -8.59552000E-03
   +3.18170000E-04  -1.24321000E-02  +9.20100000E-03  +1.73797000E-03  +3.15930000E-03
   -3.84701000E-03  +3.04418000E-03  -2.36372000E-03  +2.44634000E-03  +7.98780000E-04
   -7.18200000E-05  +4.82750000E-04  -9.14800000E-05  -1.36915000E-02  +6.61440000E-04
   -7.88928000E-03  +4.29710400E-02  +9.09509900E-02  -5.24339600E-02  +2.28350000E-04
   -7.56700000E-05  +1.20490000E-04  +8.78000000E-06  -1.79500000E-05  +7.44000000E-06
   +2.22500000E-05  -3.05000000E-06  +2.79800000E-05  -1.07700000E-05  -3.75400000E-05
   -1.08400000E-05  -1.11000000E-06  -2.18200000E-05  +1.22500000E-05  +1.25700000E-05
   +5.34000000E-06  -7.90000000E-07  +1.92000000E-05  -3.63900000E-05  +1.11600000E-05
   -4.27000000E-06  +1.10300000E-05  -2.49000000E-06  -1.67600000E-05  +2.26000000E-06
   +1.84000000E-06  +2.38000000E-06  +1.01000000E-06  -2.86500000E-05  -2.94000000E-06
   +3.50300000E-05  +2.62000000E-05  +3.52600000E-05  -6.46200000E-05  -1.01410000E-04
   -1.16600000E-04  -4.94000000E-05  -3.67400000E-05  -1.32500000E-05  -4.23990000E-04
   -2.21690000E-04  +1.28743000E-03  -4.42100000E-04  -1.06931000E-03  -2.37730000E-04
   -2.10370000E-04  +5.68750000E-04  -2.66824000E-02  -8.99985300E-02  +5.65877400E-02
   +9.90800000E-05  -1.67040000E-04  -3.57700000E-04  -2.91760000E-04  +1.04000000E-06
   -7.36200000E-05  +8.21300000E-05  +1.56230000E-04  +7.40300000E-05  -4.88000000E-06
   +8.34100000E-05  +8.89700000E-05  +1.74200000E-05  -7.03600000E-05  -4.16000000E-05
   -5.82000000E-06  +7.73900000E-05  +1.22240000E-04  +1.67790000E-04  -4.27810000E-04
   -2.02570000E-04  -2.42600000E-05  +2.83580000E-04  +2.77500000E-04  +2.99500000E-05
   +7.29700000E-05  +2.60700000E-05  +3.61070000E-04  +4.13180000E-04  -6.59200000E-04
   +3.88544000E-03  +1.40873900E-02  +2.27518700E-02  +1.85828000E-03  +9.36700000E-05
   +4.08679000E-03  -8.99100000E-05  -5.35930000E-04  -1.58322000E-03  +8.50140000E-04
   -8.16660000E-04  +3.75610000E-04  -1.16829000E-03  +7.74600000E-05  +7.36740000E-04
   -1.21957370E-01  -1.62368720E-01  -1.58067200E-01  -2.48680000E-04  +3.18140000E-04
   -4.52100000E-04  -1.30000000E-07  +1.11290000E-04  -9.14600000E-05  +2.39240000E-04
   +5.52690000E-04  -1.42135000E-03  +3.06000000E-06  -1.41900000E-05  +3.66000000E-06
   +1.45400000E-05  +1.11400000E-05  +1.61400000E-05  +5.21000000E-06  +1.36000000E-06
   +2.70500000E-05  -2.03120000E-04  +1.11450000E-04  +6.28400000E-05  -1.58300000E-05
   -1.35700000E-05  -7.42000000E-06  -4.27300000E-05  +1.19400000E-05  -4.03600000E-05
   +1.91900000E-05  -5.51000000E-06  -4.45800000E-05  +1.84800000E-05  -3.48400000E-05
   +1.69220000E-04  -9.91990000E-04  +1.53656000E-03  +3.18840000E-04  -4.68000000E-05
   -3.23050000E-04  +2.92590000E-04  -1.26100000E-05  -3.45420000E-04  +5.51820000E-04
   -2.91500000E-05  -2.05900000E-05  +1.57100000E-05  +1.42300000E-05  +7.87800000E-05
   +4.05200000E-05  -6.89510000E-04  +9.70200000E-04  -5.62670000E-04  -1.27980000E-03
   -1.05700000E-04  +2.78612000E-03  -9.58000000E-06  +4.25700000E-05  +9.35300000E-05
   +1.19288270E-01  +1.73600000E-05  +4.13900000E-05  +1.80190000E-04  +1.40470000E-04
   -1.30300000E-05  -6.89200000E-05  -1.04280000E-04  -8.88700000E-05  +5.49200000E-05
   -1.29100000E-05  -6.32900000E-05  -4.16200000E-05  +6.07900000E-05  +8.18300000E-05
   +1.26300000E-05  +3.72900000E-05  -6.25600000E-05  -8.72600000E-05  -1.40700000E-04
   +5.01710000E-04  +4.73460000E-04  +8.62200000E-05  -2.56130000E-04  -2.84640000E-04
   -7.72700000E-05  -1.06270000E-04  -1.21900000E-05  -1.08123000E-03  +1.41112000E-03
   +1.74921000E-03  +2.18509000E-03  +2.08399000E-03  +9.26310000E-03  -8.04160000E-04
   +9.16990000E-04  -5.08800000E-05  -2.08090000E-04  +6.15060000E-04  +1.11742000E-03
   -7.32860000E-04  +4.60560000E-04  -1.31370000E-04  +5.68840000E-04  -1.02552000E-03
   -4.65540000E-04  -1.48334390E-01  -2.06321960E-01  -2.24554130E-01  +7.75800000E-05
   -5.31980000E-04  +3.55650000E-04  -1.07150000E-04  -1.32780000E-04  +2.23650000E-04
   -2.43510000E-04  -7.10690000E-04  +1.41686000E-03  +8.90000000E-07  +2.10300000E-05
   -3.28000000E-06  -1.97200000E-05  -1.34900000E-05  -1.46500000E-05  -9.43000000E-06
   +1.18000000E-05  -3.71800000E-05  +1.32700000E-04  +2.57600000E-05  -8.19400000E-05
   -2.04400000E-05  +1.18600000E-05  -2.29000000E-06  +6.03900000E-05  -4.25100000E-05
   +5.40600000E-05  -2.86800000E-05  -8.13000000E-06  +6.55600000E-05  -1.63000000E-05
   +2.17100000E-05  -1.73190000E-04  +1.82612000E-03  -9.05480000E-04  -4.42420000E-04
   -2.11900000E-05  -1.52250000E-04  +7.41600000E-05  -1.12120000E-04  +2.13240000E-04
   -6.67160000E-04  -1.55360000E-04  -1.04220000E-04  +7.74000000E-05  -1.49900000E-05
   -7.07800000E-05  -2.39500000E-05  +7.71180000E-04  -7.33870000E-04  -5.93320000E-04
   +3.37100000E-04  +5.59400000E-05  -6.89380000E-04  -9.56000000E-06  -8.05800000E-05
   -1.07500000E-04  +1.45748300E-01  +2.04651010E-01  -6.02000000E-06  +7.87600000E-05
   +3.14900000E-05  -1.19160000E-04  -1.12260000E-04  +4.01200000E-05  +7.32800000E-05
   -4.14800000E-05  -5.11600000E-05  +1.03320000E-04  +2.64900000E-05  -5.49700000E-05
   -2.14590000E-04  -1.37400000E-04  +3.31200000E-05  -8.07000000E-06  +3.55400000E-05
   +4.08500000E-05  -4.52820000E-04  +5.49300000E-05  -6.56730000E-04  +9.08500000E-05
   +7.11000000E-05  +3.91600000E-05  +2.26070000E-04  +2.02030000E-04  +5.45000000E-06
   -1.57861000E-03  -2.02247000E-03  +3.04030000E-04  -1.22899200E-02  -2.06170800E-02
   -3.15843500E-02  -1.27130000E-03  -3.36270000E-04  +2.79332000E-03  +2.21970000E-04
   +5.16630000E-04  +3.82860000E-04  -7.38940000E-04  +6.23940000E-04  -4.22160000E-04
   +1.82838000E-03  +2.48700000E-05  -1.68190000E-04  -1.18576010E-01  -1.91492980E-01
   -2.50370610E-01  -2.40980000E-04  -3.32820000E-04  -3.09990000E-04  -7.00290000E-04
   +4.66130000E-04  +5.19100000E-05  +4.33820000E-04  -1.90520000E-04  -5.03030000E-04
   -2.97700000E-05  -3.45200000E-05  -9.41000000E-06  +7.56000000E-06  +2.31700000E-05
   +4.84000000E-06  -2.76000000E-06  -1.23800000E-05  -1.93500000E-05  -5.46600000E-05
   -4.70000000E-05  +5.74600000E-05  +4.16400000E-05  +5.37000000E-06  +6.70000000E-07
   +2.20100000E-05  -3.01800000E-05  +9.25000000E-06  -6.04000000E-06  +1.31200000E-05
   -1.53700000E-05  -4.39000000E-06  -8.14000000E-06  +5.31700000E-05  -6.30950000E-04
   +4.16040000E-04  +8.99370000E-04  -4.07400000E-05  +8.02000000E-05  +3.10000000E-06
   +1.31820000E-04  -2.33590000E-04  +3.54440000E-04  +6.95000000E-06  +5.80000000E-05
   +2.22860000E-04  -9.29600000E-05  -5.08000000E-05  -5.34800000E-05  +2.15710000E-04
   -8.38580000E-04  -2.23780000E-04  +2.79666000E-03  +7.85500000E-04  -4.09953000E-03
   -9.35300000E-05  -2.59570000E-04  +1.53180000E-04  +1.30719080E-01  +2.13186460E-01
   +2.82502920E-01  +3.78000000E-06  -4.06000000E-06  +9.60000000E-06  +2.40200000E-05
   +1.65000000E-05  -1.05300000E-05  +2.15000000E-06  -5.06000000E-06  +3.26000000E-06
   -1.50000000E-07  -1.42200000E-05  +9.49000000E-06  +2.12000000E-06  +9.13000000E-06
   -1.24100000E-05  -6.49000000E-06  -2.22200000E-05  +2.47600000E-05  +8.36300000E-05
   +5.73100000E-05  +6.06000000E-06  -1.84000000E-05  +1.48000000E-06  +7.99000000E-06
   +4.59000000E-06  -3.30500000E-05  +1.47800000E-05  +4.87900000E-05  +4.63830000E-04
   -1.89940000E-04  -5.19470000E-04  +2.00380000E-04  -1.26737000E-03  -9.04120000E-04
   -1.17387000E-03  -1.00820000E-04  -1.00037000E-03  +1.58329000E-03  -3.10840000E-04
   +6.00950000E-04  -3.41260000E-04  +2.84690000E-04  -4.85140000E-04  +1.02000000E-05
   +2.49710000E-04  +6.09700000E-05  -3.66480000E-04  +3.47380000E-04  -1.46703300E-02
   -1.12295000E-02  +1.44711500E-02  -3.13814000E-03  -5.18924000E-03  +7.91900000E-05
   -2.41700000E-05  +1.39200000E-05  -2.57000000E-05  -2.11500000E-05  +1.35100000E-05
   -1.64300000E-05  -6.41000000E-06  +6.58000000E-06  -1.11500000E-05  -8.59000000E-06
   +1.14900000E-05  +3.07000000E-06  -4.29000000E-06  +9.38000000E-06  -4.19000000E-06
   -1.10300000E-05  +7.94000000E-06  -3.24000000E-06  -3.54000000E-06  +7.32000000E-06
   -5.58000000E-06  -4.83000000E-06  -1.17800000E-05  +4.08000000E-06  +3.92000000E-06
   +1.59000000E-06  +1.63000000E-06  -4.00000000E-06  +1.43000000E-05  +2.22400000E-05
   -7.70000000E-06  -1.29000000E-05  +6.70000000E-07  -1.90000000E-06  +1.72000000E-06
   +2.00600000E-05  -1.36300000E-05  -1.84800000E-05  -5.90000000E-06  +7.77000000E-06
   -1.71600000E-05  -8.14000000E-06  +6.40520000E-04  -6.55270000E-04  -1.76970000E-04
   +1.62930000E-04  +7.00240000E-04  +2.68500000E-04  +5.01012000E-03  +1.48704000E-03
   +2.79534000E-03  -2.94700000E-05  +3.65500000E-05  +6.07600000E-05  +1.34389100E-02
   +1.06300000E-05  +1.30500000E-05  +3.38000000E-06  -1.01100000E-05  -2.46800000E-05
   -1.94600000E-05  +9.40000000E-07  +3.04100000E-05  -1.70000000E-07  -2.84100000E-05
   +1.30800000E-05  +1.07400000E-05  +7.90400000E-05  +5.69900000E-05  -4.50000000E-06
   +5.05000000E-06  +8.07000000E-06  -1.85500000E-05  -8.69600000E-05  +4.15200000E-05
   -1.04130000E-04  -2.04900000E-05  +8.85000000E-06  -1.08100000E-05  -5.92000000E-05
   -6.08200000E-05  -5.61000000E-06  -6.26830000E-04  -1.10020000E-03  +7.72790000E-04
   +1.48453000E-03  +7.91240000E-04  +8.75830000E-04  +1.74490000E-04  +3.66993000E-03
   +6.73761000E-03  -2.70088000E-03  -4.59172000E-03  +7.01270000E-04  -1.71653000E-03
   +9.39780000E-04  -9.24800000E-04  +1.12365000E-03  -2.75150000E-04  -8.63210000E-04
   -3.58430000E-04  +5.02650000E-04  -6.99720000E-04  -9.72663000E-03  -1.62135740E-01
   +2.37726300E-01  +6.63830000E-04  -4.91170000E-04  +8.02000000E-05  +5.74600000E-05
   -3.52200000E-05  +5.16300000E-05  +8.93000000E-06  +1.84900000E-05  +2.38000000E-06
   +6.84000000E-06  -3.52000000E-06  +1.17000000E-06  -7.50000000E-07  -2.17700000E-05
   +2.76000000E-06  +1.00400000E-05  -1.23100000E-05  +1.21000000E-06  +4.35000000E-06
   +1.28000000E-06  +3.44000000E-06  +6.24000000E-06  +3.71000000E-06  -3.23000000E-06
   +2.32000000E-06  +1.20400000E-05  -3.06000000E-06  -5.09000000E-06  -1.02000000E-06
   -9.59000000E-06  +2.27200000E-05  -1.53200000E-05  -3.96500000E-05  +4.29000000E-06
   +1.15300000E-05  +1.18500000E-05  +3.66000000E-06  -3.40000000E-07  -4.46700000E-05
   +3.92800000E-05  +2.00300000E-05  -8.75000000E-06  +2.26880000E-04  +3.65840000E-04
   +2.21850000E-04  -7.58250000E-04  -1.82751000E-03  -1.31757000E-03  +6.32000000E-06
   -8.28620000E-04  -7.12860000E-04  +9.37660000E-04  -8.81550000E-04  +1.32087000E-03
   +2.30080000E-04  -2.72040000E-04  -6.04500000E-05  +1.03294500E-02  +1.65713730E-01
   -2.70000000E-06  +2.15900000E-05  +2.83600000E-05  -3.22100000E-05  -7.67700000E-05
   -1.48100000E-05  +2.06000000E-06  +1.67200000E-05  -1.34500000E-05  +8.70000000E-07
   +2.05500000E-05  -1.39600000E-05  -2.09600000E-05  -3.56700000E-05  -2.18400000E-05
   +1.51700000E-05  +3.52400000E-05  +1.09900000E-05  -2.21050000E-04  -1.89800000E-05
   -7.18900000E-05  +4.32300000E-05  +2.71000000E-06  -3.34200000E-05  +4.95400000E-05
   +4.77300000E-05  +3.49000000E-06  -7.84070000E-04  -1.29453000E-03  +5.84710000E-04
   +2.34034000E-03  +1.56170000E-03  +1.81783000E-03  -8.25980000E-04  +5.72093000E-03
   +2.91412000E-03  +1.03180000E-04  -4.28332000E-03  +1.27704000E-03  -1.88958000E-03
   +1.08219000E-03  -4.12410000E-04  +1.41416000E-03  -4.07000000E-04  -9.05760000E-04
   -1.98690000E-04  +1.25280000E-04  -6.27320000E-04  +1.10188200E-02  +2.40863590E-01
   -3.97196140E-01  -5.20960000E-04  +1.11159000E-03  +4.78450000E-04  +1.09170000E-04
   -4.66600000E-05  +4.38700000E-05  -3.07000000E-06  -5.33000000E-06  -1.57000000E-06
   +1.35400000E-05  +5.58000000E-06  +8.50000000E-06  -2.07700000E-05  -3.66700000E-05
   -1.14300000E-05  -5.36000000E-06  -9.47000000E-06  +6.17000000E-06  +1.08200000E-05
   +2.18000000E-06  +7.00000000E-07  +2.33500000E-05  -1.56800000E-05  +5.91000000E-06
   -6.63000000E-06  +2.41300000E-05  -7.40000000E-06  -1.34300000E-05  -1.06000000E-06
   -6.44000000E-06  -2.47000000E-06  +8.90000000E-06  -1.51600000E-05  +5.00000000E-07
   +2.60200000E-05  +1.91400000E-05  +2.60200000E-05  -2.56000000E-05  -4.35100000E-05
   +3.95900000E-05  +4.98200000E-05  +5.04200000E-05  +1.50130000E-04  +2.10460000E-04
   +1.83750000E-04  -5.12240000E-04  -1.23482000E-03  -5.19750000E-04  +1.26730000E-04
   -1.57272000E-03  -1.46348000E-03  -1.52209000E-03  -4.94480000E-04  -9.73890000E-04
   +7.73700000E-05  -1.93750000E-04  -2.57900000E-05  -1.12438900E-02  -2.43983300E-01
   +3.96933450E-01  +2.35240000E-04  +2.00000000E-07  +3.89820000E-04  -1.20264000E-03
   -1.12466000E-03  -7.18420000E-04  -2.12807000E-03  +1.80988000E-03  -1.00180000E-03
   -1.26601000E-03  +2.36854000E-03  -2.45480000E-04  +1.77479000E-03  +6.14990000E-04
   -1.15164000E-03  -7.18500000E-05  +2.93010000E-04  +6.10110000E-04  -1.46634000E-03
   -1.19840000E-04  -4.75740000E-04  +6.98820000E-04  +1.31110000E-04  -5.98300000E-05
   -7.03300000E-04  -3.19100000E-04  +1.12290000E-04  -2.56259000E-03  -1.97984000E-03
   +9.94800000E-04  +2.51030000E-03  -9.14090000E-04  +3.33370000E-04  -6.22760000E-04
   +9.56231000E-03  -3.17811000E-03  -2.85742000E-03  -1.44853000E-03  +3.76862000E-03
   -3.16772000E-03  +2.14139000E-03  -6.99240000E-04  +3.41822000E-03  -4.78940000E-04
   -1.98745000E-03  +9.80700000E-04  -1.18742000E-03  -2.89035000E-03  -4.99878700E-02
   +7.78760000E-04  -3.02975200E-02  +3.26410000E-04  -3.61516000E-03  +1.02993000E-03
   +8.77240000E-04  -1.10480000E-04  +1.18270000E-04  +4.08070000E-04  +8.91200000E-05
   +6.42600000E-05  +7.43730000E-04  -1.82680000E-04  +6.29210000E-04  -1.65250000E-03
   -7.76000000E-05  +6.05650000E-04  -1.61350000E-04  +2.15500000E-05  +2.34050000E-04
   +1.48000000E-06  +8.29100000E-05  +6.68300000E-05  +1.63690000E-04  -2.55260000E-04
   +9.77100000E-05  +1.04430000E-04  +3.69110000E-04  -1.21000000E-04  -1.66910000E-04
   -1.07230000E-04  +7.44600000E-05  -1.87120000E-04  +5.66500000E-05  +1.24700000E-05
   +9.32500000E-05  +3.09020000E-04  +1.40790000E-04  +1.37320000E-04  -3.04990000E-04
   -2.06730000E-04  +9.31800000E-05  +9.40500000E-05  +2.95650000E-04  +1.31040000E-04
   +1.84200000E-04  +6.34900000E-05  -1.01789000E-03  -1.62959000E-03  -5.30100000E-04
   -1.45589700E-02  -1.78480000E-03  +8.23600000E-04  +2.73174000E-03  +3.43690000E-03
   -2.34768000E-03  +1.54400000E-05  +2.16030000E-04  -3.17540000E-04  -6.41304000E-03
   -1.86271000E-03  -2.78000000E-03  +5.92805170E-01  -1.10900000E-05  +2.30260000E-04
   +9.33400000E-05  -1.87020000E-04  -2.93300000E-04  +5.05800000E-04  +1.59406000E-03
   -1.81559000E-03  +8.35630000E-04  +1.97730000E-04  -4.04550000E-04  -4.20770000E-04
   -6.79590000E-04  -4.96230000E-04  -6.18800000E-05  +1.16780000E-04  +1.39260000E-04
   -6.54400000E-05  -2.09590000E-04  -5.90310000E-04  -2.91020000E-04  +3.29550000E-04
   -8.86100000E-05  -1.29290000E-04  +6.41470000E-04  +8.03910000E-04  +2.32100000E-05
   +2.34678000E-03  +1.30456000E-02  -8.75546000E-03  -3.38713600E-02  -4.09682100E-02
   -2.38108100E-02  +1.44096100E-02  -1.99282600E-02  -1.08131000E-03  +4.65981000E-03
   +2.14680000E-04  -3.86882000E-03  +4.13614000E-03  -3.60261000E-03  +1.82856000E-03
   -7.12232000E-03  +1.83035000E-03  +4.86658000E-03  +3.22093000E-03  +2.24495000E-03
   -9.29810000E-04  +2.47728600E-02  +1.76581000E-02  +1.03942400E-02  -1.77542000E-03
   +3.34499000E-03  -2.29410000E-04  +3.64920000E-04  -5.11400000E-05  +2.59050000E-04
   +7.55300000E-05  -2.44540000E-04  +1.52000000E-06  +2.66550000E-04  -3.37000000E-06
   +2.67350000E-04  +1.22476000E-03  -1.01665000E-03  -3.16270000E-04  -5.98700000E-05
   +5.08000000E-06  +1.73400000E-05  +4.93300000E-05  -4.68000000E-06  +7.92000000E-06
   +9.41900000E-05  -1.11930000E-04  +4.61800000E-05  -1.63000000E-05  +6.46700000E-05
   +2.03800000E-05  -6.53200000E-05  +1.51300000E-05  +2.44400000E-05  -1.33330000E-04
   +1.06970000E-04  +7.51800000E-05  -3.95700000E-05  +9.92800000E-05  +3.17900000E-05
   +9.66400000E-05  -1.59420000E-04  -7.55500000E-05  -2.92510000E-04  -2.50850000E-04
   -7.01000000E-06  +9.08900000E-05  -1.46000000E-04  +1.82410000E-04  +1.13088000E-03
   +2.46382000E-03  +9.24230000E-04  +1.03957200E-02  +2.55929500E-02  +2.02039000E-02
   -1.49173000E-03  -2.44006000E-03  +1.20256000E-03  +1.52630000E-04  +4.65920000E-04
   +5.14010000E-04  -6.00860000E-04  +1.20445000E-03  +5.34810000E-04  +1.03365120E-01
   +2.28891740E-01  +1.75730000E-04  +1.84020000E-04  +3.74250000E-04  -7.49540000E-04
   -6.05170000E-04  +1.34720000E-04  -2.08400000E-05  +5.10910000E-04  -8.42140000E-04
   -4.34210000E-04  +4.77440000E-04  -1.04360000E-04  +3.94150000E-04  +7.13900000E-05
   -4.71940000E-04  -9.50200000E-05  +1.07290000E-04  +3.73590000E-04  -7.13320000E-04
   -3.18160000E-04  -4.03610000E-04  +4.59360000E-04  -4.85800000E-05  -1.29360000E-04
   -5.82500000E-05  +1.62210000E-04  +1.40500000E-04  +2.87100000E-04  +5.83076000E-03
   -3.64869000E-03  -1.63864700E-02  -2.16968600E-02  -8.52649000E-03  +7.28822000E-03
   -2.86679000E-03  -1.63055000E-03  -2.01700000E-04  -1.16747000E-03  +6.85840000E-04
   +4.83520000E-04  -1.26680000E-03  +7.09810000E-04  -2.85455000E-03  +2.33910000E-04
   +2.26329000E-03  +2.08315000E-03  +1.48414000E-03  +9.16090000E-04  -2.43159100E-02
   +1.37074000E-03  -4.70380000E-04  -8.21050000E-04  -1.27938000E-03  +9.40690000E-04
   +5.45070000E-04  -4.39000000E-05  +1.20070000E-04  +2.23010000E-04  -3.92600000E-05
   -4.23800000E-05  +5.65460000E-04  +7.21000000E-06  +3.54160000E-04  -6.18830000E-04
   -3.83840000E-04  +2.71610000E-04  -1.44210000E-04  +4.70700000E-05  +1.39140000E-04
   -1.14400000E-05  +6.59500000E-05  +3.41700000E-05  +1.14590000E-04  -1.47710000E-04
   +7.76000000E-05  +4.54800000E-05  +2.05200000E-04  -2.77600000E-05  -9.15300000E-05
   -7.44000000E-05  +8.45500000E-05  -1.55000000E-04  +9.55000000E-05  +1.07370000E-04
   +1.45300000E-05  +1.75970000E-04  +7.74000000E-05  +9.62400000E-05  -2.16520000E-04
   -8.90800000E-05  -1.10140000E-04  -1.31430000E-04  +1.25110000E-04  +9.82000000E-05
   +8.87000000E-06  +1.40000000E-04  +1.10920000E-04  +5.21760000E-04  +3.09570000E-04
   +6.32014000E-03  +1.56180000E-02  -4.21505000E-03  +1.53249000E-03  +1.74139000E-03
   -1.51468000E-03  -2.84230000E-04  +3.66820000E-04  +4.58500000E-04  +2.69800000E-04
   -5.38110000E-04  +6.67460000E-04  -6.78435400E-02  -1.75848930E-01  +2.04267860E-01
   -7.69300000E-05  -1.38920000E-04  -1.44870000E-04  +2.15780000E-04  +2.28790000E-04
   -6.97900000E-05  +7.48800000E-04  +5.94670000E-04  -1.12480000E-04  +3.04480000E-04
   -1.03591000E-03  +1.11250000E-04  -7.33000000E-04  -2.73770000E-04  +6.12510000E-04
   -6.05200000E-05  -5.20000000E-05  +5.00700000E-05  +3.88100000E-04  +7.31700000E-05
   +9.20500000E-05  -1.98670000E-04  -4.68300000E-05  +1.01200000E-05  +2.83320000E-04
   +7.43600000E-05  +5.74000000E-06  +2.97770000E-04  -6.15130000E-04  +4.06320000E-04
   +1.90120000E-03  +1.69752000E-03  +8.69850000E-04  -8.80310000E-04  +1.77250000E-04
   +5.35800000E-04  +1.08200000E-05  +1.97500000E-04  -2.74690000E-04  +1.12930000E-04
   +4.05300000E-05  -1.05560000E-04  +4.28600000E-05  -2.13600000E-05  +3.92800000E-05
   -4.63670000E-04  +8.69400000E-05  +6.94100000E-05  -2.38200000E-05  +2.63024000E-03
   -3.07569000E-03  +1.07110000E-04  +2.52100000E-04  -1.09450000E-04  -2.37390000E-04
   +9.16000000E-06  -2.30300000E-05  -2.24120000E-04  +7.00000000E-06  -1.00530000E-04
   -2.67580000E-04  +1.29910000E-04  -4.55940000E-04  +1.24270000E-04  -1.16900000E-05
   +5.46300000E-05  +3.82200000E-05  -2.68700000E-05  -4.55100000E-05  -6.61000000E-06
   -1.76000000E-05  -4.37100000E-05  -4.09700000E-05  +7.84200000E-05  -2.42200000E-05
   -3.00900000E-05  -1.01260000E-04  +3.06900000E-05  +4.90700000E-05  +1.82300000E-05
   -2.02400000E-05  +6.27200000E-05  -2.00500000E-05  -1.21400000E-05  -3.35500000E-05
   -8.28000000E-05  -3.48700000E-05  -4.15000000E-05  +9.54300000E-05  +4.30500000E-05
   +2.79500000E-05  -1.60000000E-07  -5.23800000E-05  -3.72500000E-05  -1.88800000E-05
   -2.24200000E-05  -3.57000000E-05  +2.79700000E-05  -6.25000000E-06  -1.37247000E-03
   -4.48827000E-03  -2.57331000E-03  -2.91980000E-04  -2.09860000E-04  +1.19540000E-04
   +8.28400000E-05  -4.38300000E-05  -7.38300000E-05  -1.48993000E-03  -8.27500000E-05
   -6.13970000E-04  -3.21891770E-01  -1.68001860E-01  +1.56157280E-01  +3.41729040E-01
   +5.64200000E-05  -2.85000000E-05  -1.89000000E-06  -3.26490000E-04  -3.74160000E-04
   -4.65120000E-04  -3.73750000E-04  -1.84270000E-04  +3.08490000E-04  -1.27290000E-04
   +7.51650000E-04  +2.61070000E-04  +1.02240000E-03  +6.31910000E-04  -3.99040000E-04
   -3.98000000E-06  +5.72000000E-06  +6.92700000E-05  -2.16490000E-04  -1.16630000E-04
   -4.89600000E-05  +1.20720000E-04  +5.45900000E-05  +2.33100000E-05  -6.07610000E-04
   -6.86430000E-04  +2.85200000E-05  -3.41800000E-04  -4.52000000E-05  -6.57900000E-05
   -6.89080000E-04  -1.11636000E-03  -9.24800000E-04  +1.42130000E-04  -1.86260000E-04
   -3.54310000E-04  +1.07000000E-06  +1.73290000E-04  -6.88200000E-05  -1.35030000E-04
   +3.11610000E-04  +2.87000000E-05  +5.38010000E-04  +1.16810000E-04  -2.64030000E-04
   +2.31830000E-04  -2.18620000E-04  -6.59010000E-04  +1.85608000E-03  -1.02657000E-03
   +2.01622000E-03  +1.49800000E-04  -1.17630000E-04  -5.33000000E-06  +1.19650000E-04
   +3.03000000E-06  +1.01600000E-05  +1.78000000E-05  +2.06300000E-04  +3.90000000E-07
   +4.09200000E-05  -5.06900000E-05  +1.76900000E-05  -7.35400000E-05  -1.17760000E-04
   +1.19880000E-04  -2.40700000E-05  +6.11000000E-06  +4.80100000E-05  -2.14400000E-05
   +2.74800000E-05  +2.26300000E-05  +1.24600000E-05  -4.63900000E-05  +1.71300000E-05
   +3.61200000E-05  +6.91500000E-05  -2.88600000E-05  -2.58800000E-05  -2.02700000E-05
   +1.46500000E-05  -2.22600000E-05  -1.72100000E-05  -2.21900000E-05  +3.32500000E-05
   +5.38100000E-05  +2.03800000E-05  +4.03000000E-06  -3.54200000E-05  -3.24500000E-05
   -7.90000000E-07  +1.81400000E-05  +2.78100000E-05  +4.62000000E-06  -4.56000000E-06
   -3.34000000E-06  -4.01000000E-06  -1.21900000E-04  -3.23100000E-05  -5.03321000E-03
   -1.54873000E-03  +5.05006000E-03  +4.40000000E-06  -1.55400000E-05  +1.63100000E-05
   +1.46110000E-04  +1.11550000E-04  -1.69050000E-04  +5.65940000E-04  +8.20000000E-07
   +3.55710000E-04  -1.97244260E-01  -1.47610290E-01  +1.23613300E-01  +1.91260250E-01
   +1.43207580E-01  +1.08400000E-05  -9.35900000E-05  -2.23010000E-04  +3.86200000E-05
   -1.98800000E-05  +3.71300000E-05  +9.07800000E-05  +2.22540000E-04  -4.95900000E-05
   +2.25660000E-04  -4.64200000E-05  +2.78080000E-04  -2.74980000E-04  -1.49040000E-04
   +3.34480000E-04  +4.91000000E-06  -1.38700000E-05  -2.49390000E-04  +7.25300000E-05
   -3.76600000E-05  -3.08800000E-05  -2.98400000E-05  -3.70000000E-07  +3.85000000E-06
   +1.23250000E-04  +6.75300000E-05  -8.11700000E-05  +1.17940000E-04  +1.40020000E-04
   -4.87620000E-04  -1.83744000E-03  -2.22726000E-03  -8.65370000E-04  +3.37500000E-05
   -9.96130000E-04  -5.14440000E-04  +2.27770000E-04  +1.30290000E-04  -4.14150000E-04
   +1.07310000E-04  +5.62400000E-05  +2.40520000E-04  -7.18000000E-05  +1.69190000E-04
   +3.90500000E-05  +2.51590000E-04  +4.21280000E-04  -3.82480000E-04  -9.13620000E-04
   +1.13956000E-03  -1.83097000E-03  +1.75000000E-05  +1.18100000E-04  -1.69800000E-05
   -3.33000000E-05  -2.81100000E-05  +4.84000000E-05  -1.02030000E-04  +8.18000000E-06
   +5.46900000E-05  -3.84460000E-04  +3.85200000E-05  -3.87280000E-04  +1.64990000E-04
   +1.42750000E-04  -2.17200000E-05  +2.67300000E-05  -2.92500000E-05  -1.69100000E-05
   +2.83700000E-05  -4.25700000E-05  -2.64400000E-05  -6.05000000E-06  +1.33000000E-05
   -1.47000000E-06  -5.94000000E-06  -1.89500000E-05  +1.70000000E-06  +1.61800000E-05
   +6.48000000E-06  -1.48500000E-05  +2.05400000E-05  -2.29100000E-05  -3.56900000E-05
   -4.49000000E-06  -6.94000000E-06  -1.05600000E-05  -5.13000000E-06  +2.28700000E-05
   -1.79800000E-05  +1.60300000E-05  +8.70000000E-07  -1.75800000E-05  +3.40000000E-07
   -5.54000000E-06  +1.09100000E-05  -5.70200000E-05  -2.98200000E-05  -8.38000000E-06
   -2.25009000E-03  +1.25690000E-03  +3.90915000E-03  -1.70540000E-04  -1.11430000E-04
   +1.88700000E-05  +1.23440000E-04  +6.23000000E-05  -5.80300000E-05  -8.48030000E-04
   +1.54400000E-04  -1.87870000E-04  +1.86369520E-01  +1.27153380E-01  -1.19290510E-01
   -1.72345510E-01  -1.19615340E-01  +1.14451850E-01  -2.78520000E-04  -1.76020000E-04
   -1.86530000E-04  +6.71200000E-04  +6.73200000E-04  +5.10800000E-05  +6.99500000E-05
   -1.78900000E-04  +6.75310000E-04  +2.98900000E-04  -7.53910000E-04  +3.08200000E-05
   -7.73060000E-04  -3.11070000E-04  +4.45090000E-04  +9.59500000E-05  -1.07430000E-04
   -2.07520000E-04  +1.23251000E-03  -7.64400000E-05  +2.11070000E-04  -4.02130000E-04
   -8.78600000E-05  +1.17560000E-04  +3.51320000E-04  +5.26800000E-05  -5.70900000E-05
   +3.68209000E-03  +8.86763000E-03  -5.65261000E-03  -1.65045800E-02  -1.79736900E-02
   -1.27831000E-02  +5.20725000E-03  -2.61223600E-02  +1.83266000E-03  +6.56634000E-03
   +2.69753000E-03  -8.77902000E-03  +6.81164000E-03  -4.87266000E-03  +2.53556000E-03
   -8.07422000E-03  +1.86767000E-03  +4.72862000E-03  +4.12080000E-04  +1.52385000E-03
   +1.95301000E-03  +1.31360200E-02  +1.07484600E-02  +1.97860900E-02  -1.34577000E-03
   +5.71959000E-03  -1.22379000E-03  -6.15910000E-04  +1.12840000E-04  -6.15500000E-05
   -2.86900000E-04  -6.87000000E-06  -4.97200000E-05  -4.45690000E-04  +4.70200000E-05
   -3.26450000E-04  +2.32440000E-04  +7.95550000E-04  -3.98410000E-04  +1.03000000E-04
   -9.77000000E-06  -1.50980000E-04  -1.43300000E-05  -3.96600000E-05  -4.52000000E-05
   -1.14960000E-04  +1.47580000E-04  -5.90900000E-05  -5.70000000E-05  -2.61420000E-04
   +8.12400000E-05  +1.02580000E-04  +7.76300000E-05  -4.50500000E-05  +8.98300000E-05
   -1.34300000E-05  +3.15600000E-05  -7.34900000E-05  -2.19030000E-04  -1.09140000E-04
   -1.10370000E-04  +1.87020000E-04  +1.74630000E-04  -3.03170000E-04  -1.90040000E-04
   -2.89870000E-04  -6.64200000E-05  -3.15710000E-04  +2.11100000E-05  +1.90576000E-03
   +2.79858000E-03  +1.04598000E-03  +8.92339000E-03  +2.83693300E-02  +1.92253200E-02
   -4.35845000E-03  -5.30338000E-03  +3.27795000E-03  +8.98800000E-05  -4.74000000E-06
   +5.64010000E-04  +8.69111000E-03  +2.60533000E-03  +5.65555000E-03  -1.96164140E-01
   +4.08248100E-02  -6.13546600E-02  -1.80894700E-02  +8.90694000E-03  -8.74831000E-03
   +1.89405340E-01  +2.03900000E-05  +9.01000000E-05  +3.42000000E-06  -3.34100000E-05
   -3.50300000E-05  +3.37200000E-05  -4.99000000E-05  -1.69550000E-04  +1.06230000E-04
   -1.17050000E-04  +1.22180000E-04  -1.32000000E-06  +2.78340000E-04  +1.99280000E-04
   -1.29600000E-04  +1.67800000E-05  -1.79700000E-05  -5.60400000E-05  -4.99800000E-05
   +4.78900000E-05  +1.51600000E-05  -3.94600000E-05  +1.59900000E-05  -9.82000000E-06
   -1.98030000E-04  -1.53730000E-04  -4.54000000E-06  -6.64880000E-04  -2.48290000E-03
   +1.58764000E-03  +4.31098000E-03  +4.41169000E-03  +2.57417000E-03  -4.37132000E-03
   +3.76997000E-03  -3.10244000E-03  -2.76794000E-03  -4.21470000E-04  +1.98758000E-03
   -1.34307000E-03  +1.02444000E-03  -2.01130000E-04  +1.89564000E-03  -4.46730000E-04
   -1.24622000E-03  -3.26990000E-04  -1.51350000E-04  +2.42500000E-04  -1.39091900E-02
   -1.94836100E-02  -3.26055000E-03  +2.52690000E-04  -2.49941000E-03  +7.09910000E-04
   +1.65700000E-05  -1.09900000E-05  -9.59000000E-06  +7.00400000E-05  +3.25400000E-05
   +2.04300000E-05  +1.22850000E-04  -2.60300000E-05  +1.15150000E-04  +1.53390000E-04
   -1.52200000E-04  -6.84800000E-05  +7.72000000E-06  -2.44000000E-06  +9.57000000E-06
   +2.70000000E-07  +2.40000000E-07  +2.10300000E-05  -1.00300000E-05  +5.36000000E-06
   -3.79000000E-06  +1.05700000E-05  +1.16000000E-05  -2.21000000E-06  +2.53000000E-06
   -4.87000000E-06  +3.90000000E-06  +1.35100000E-05  -2.66000000E-05  -2.53000000E-05
   +1.83700000E-05  +1.47000000E-05  +3.17000000E-06  -3.30000000E-06  +8.55000000E-06
   -1.61200000E-05  +6.94100000E-05  +4.04000000E-05  +3.96000000E-06  +4.44000000E-06
   +9.38500000E-05  -3.50400000E-05  -4.87000000E-04  -1.11236000E-03  -1.91050000E-04
   +5.06022000E-03  -1.43812500E-02  -5.47068000E-03  +1.58692000E-03  +1.76490000E-03
   -1.56858000E-03  -1.20200000E-04  -6.03000000E-06  -1.54750000E-04  +4.14629000E-03
   -8.48790000E-04  +1.90834000E-03  +8.88223100E-02  -7.81955000E-02  +5.37734600E-02
   -2.23896600E-02  +7.93986000E-03  -7.82958000E-03  -5.99988400E-02  +1.01035280E-01
   -1.39890000E-04  -5.63100000E-05  -8.36500000E-05  +2.65010000E-04  +3.11070000E-04
   +1.09190000E-04  +3.08660000E-04  +1.64100000E-05  +1.97650000E-04  +2.10330000E-04
   -5.71040000E-04  +8.45600000E-05  -3.53770000E-04  -8.28200000E-05  +2.99430000E-04
   +3.09000000E-06  -3.23000000E-05  -1.35940000E-04  +6.07390000E-04  +1.30200000E-05
   +1.02310000E-04  -2.20180000E-04  -3.73800000E-05  +5.37500000E-05  +9.49800000E-05
   -2.59800000E-05  -4.20700000E-05  +1.68377000E-03  +3.51118000E-03  -2.09295000E-03
   -6.67782000E-03  -7.00877000E-03  -4.70578000E-03  +4.39290000E-04  -1.29071200E-02
   +7.84830000E-04  +3.11822000E-03  +1.85728000E-03  -3.72692000E-03  +2.84847000E-03
   -2.15211000E-03  +9.61700000E-04  -3.56691000E-03  +1.01319000E-03  +1.80308000E-03
   +9.14000000E-05  +9.36270000E-04  +6.93070000E-04  +2.32269800E-02  +1.04387900E-02
   -6.69350000E-03  +1.81200000E-04  +3.39318000E-03  -1.34949000E-03  -2.99960000E-04
   +4.47300000E-05  -1.14500000E-05  -1.20330000E-04  +1.22900000E-05  -1.37500000E-05
   -1.70610000E-04  +3.27800000E-05  -1.70960000E-04  +5.13000000E-05  +1.92750000E-04
   -6.49700000E-05  +5.96500000E-05  -2.32600000E-05  -5.99000000E-05  +3.59000000E-06
   -2.78600000E-05  -1.38400000E-05  -6.09600000E-05  +7.86000000E-05  -3.23900000E-05
   -2.07900000E-05  -1.20850000E-04  +4.13400000E-05  +4.76600000E-05  +3.04100000E-05
   -2.43200000E-05  +6.02700000E-05  -2.83800000E-05  -1.69000000E-05  -2.70400000E-05
   -9.97300000E-05  -5.28300000E-05  -5.89700000E-05  +1.01950000E-04  +6.82400000E-05
   -1.22770000E-04  -8.07700000E-05  -1.56160000E-04  +5.06000000E-06  -1.00140000E-04
   -1.57300000E-05  +7.80490000E-04  +1.00590000E-03  +4.04390000E-04  +5.90987000E-03
   +6.28065000E-03  +8.54624000E-03  -2.72909000E-03  -3.83728000E-03  +2.64711000E-03
   +5.15600000E-05  -7.27000000E-06  +1.83870000E-04  -4.71306000E-03  +6.92510000E-04
   -2.46706000E-03  -7.99827400E-02  +4.58779700E-02  -7.23664000E-02  +2.11328000E-02
   -8.90904000E-03  +5.81267000E-03  +3.80838500E-02  -3.97325000E-02  +7.15035400E-02
end_hess

