# level: HF
# Charge, multiplicity, energy [hartree],
# point group and rotational symmetry number
start_basic
   charge        0
   multiplicity  1
   energy       -883.26796950    # Total energy in hartree
   pointgroup    C1              # Point group
   rotsigma      1               # Rotational sigma
end_basic

# Atomic number and non-scaled cartesian coordinates [bohr]
start_cc
   006   -2.50205337E-01  +2.64450037E+00  -4.57149714E+00
   006   -2.07554298E-02  +2.37784705E+00  -1.96991892E+00
   006   +2.40920684E+00  +2.23213128E+00  -9.76938332E-01
   006   +4.52646563E+00  +2.33195921E+00  -2.50720646E+00
   006   +4.25175873E+00  +2.59642747E+00  -5.10366031E+00
   006   +1.84847565E+00  +2.75634989E+00  -6.13175600E+00
   006   -2.29180404E+00  +2.35933377E+00  -1.76289891E-01
   006   -2.36104484E+00  +4.94959329E+00  +1.14319318E+00
   008   +6.25711329E+00  +2.70073240E+00  -6.70700972E+00
   006   -2.00707722E+00  +2.02110473E-01  +1.72769300E+00
   006   -1.34968950E+00  -2.31868988E+00  +8.37100865E-01
   006   -1.07733152E+00  -4.37224549E+00  +2.63473600E+00
   006   -1.34747041E+00  -3.85385500E+00  +5.25926305E+00
   006   -1.88950922E+00  -1.47210574E+00  +6.01784409E+00
   006   -2.18191145E+00  +5.48952220E-01  +4.26495094E+00
   008   -1.92987675E+00  -3.05954067E+00  -1.63709108E+00
   008   +2.52851061E+00  -4.39933084E+00  +2.20801106E+00
   008   -1.14682403E+00  -5.78368460E+00  +6.95500806E+00
   006   -4.82566019E+00  +2.06406831E+00  -1.57181375E+00
   001   +7.79322797E+00  +2.55717524E+00  -5.76448748E+00
   001   +6.39364599E+00  +2.19119121E+00  -1.67614586E+00
   001   +2.66747189E+00  +2.00783707E+00  +1.04173327E+00
   001   -2.09631960E+00  +2.75498716E+00  -5.43843997E+00
   001   +1.64203350E+00  +2.95341657E+00  -8.15519210E+00
   001   -2.44589127E+00  +6.42408714E+00  -2.91850414E-01
   001   -4.02183721E+00  +5.14402487E+00  +2.34995753E+00
   001   -6.74423887E-01  +5.27338489E+00  +2.27859531E+00
   001   -4.84138209E+00  +4.42832844E-01  -2.83476070E+00
   001   -6.34719144E+00  +1.85277783E+00  -1.98697636E-01
   001   -5.23252520E+00  +3.74153123E+00  -2.69828419E+00
   001   -2.51091641E+00  +2.40832729E+00  +5.03416873E+00
   001   -2.08354369E+00  -1.10504435E+00  +8.02033666E+00
   001   -1.37586407E+00  -6.28565162E+00  +1.97753125E+00
   001   +1.07213999E+00  -2.53854152E+00  +9.98097666E-01
   001   +2.25146276E-01  -6.84766884E+00  +6.43749516E+00
   001   -3.71431494E+00  -3.32632711E+00  -1.75930299E+00
   001   +3.13263045E+00  -5.68297409E+00  +1.06926511E+00
end_cc

# Non-scaled cartesian gradient [hartree/bohr]
start_grad
   +1.18000000E-06  -4.20000000E-07  -2.30000000E-07
   +4.80000000E-07  -1.60000000E-07  -4.00000000E-08
   +7.00000000E-08  +9.00000000E-08  +6.00000000E-07
   +5.90000000E-07  +7.00000000E-08  +1.14000000E-06
   +1.32000000E-06  -2.00000000E-07  +1.17000000E-06
   +1.52000000E-06  -4.30000000E-07  +4.00000000E-07
   -7.00000000E-08  -1.50000000E-07  -7.30000000E-07
   -5.90000000E-07  -1.00000000E-08  -9.70000000E-07
   +1.74000000E-06  -2.10000000E-07  +1.60000000E-06
   -4.90000000E-07  +6.00000000E-08  -4.30000000E-07
   -1.60000000E-07  -3.00000000E-08  +2.00000000E-08
   -5.90000000E-07  +2.60000000E-07  +2.10000000E-07
   -1.19000000E-06  +4.40000000E-07  +2.00000000E-08
   -1.59000000E-06  +5.60000000E-07  -2.20000000E-07
   -1.20000000E-06  +2.40000000E-07  -5.20000000E-07
   +7.30000000E-07  -2.60000000E-07  -1.00000000E-07
   -2.10000000E-07  +4.50000000E-07  +1.20000000E-06
   -1.59000000E-06  +5.80000000E-07  +3.90000000E-07
   +3.60000000E-07  -4.20000000E-07  -1.42000000E-06
   +1.50000000E-06  -4.00000000E-08  +2.09000000E-06
   +3.70000000E-07  +2.60000000E-07  +1.73000000E-06
   -3.90000000E-07  +2.90000000E-07  +6.80000000E-07
   +1.36000000E-06  -6.10000000E-07  -6.90000000E-07
   +2.12000000E-06  -6.30000000E-07  +3.20000000E-07
   -2.90000000E-07  -1.60000000E-07  -1.14000000E-06
   -9.40000000E-07  +0.00000000E+00  -1.47000000E-06
   -9.40000000E-07  +1.80000000E-07  -5.50000000E-07
   +8.10000000E-07  -5.80000000E-07  -1.23000000E-06
   -3.00000000E-08  -3.70000000E-07  -1.82000000E-06
   +5.50000000E-07  -5.50000000E-07  -1.69000000E-06
   -1.53000000E-06  +3.10000000E-07  -7.90000000E-07
   -2.15000000E-06  +6.30000000E-07  -3.60000000E-07
   -1.20000000E-07  +1.20000000E-07  +3.30000000E-07
   -5.00000000E-08  +8.00000000E-08  +7.10000000E-07
   -1.34000000E-06  +6.10000000E-07  +8.30000000E-07
   +6.80000000E-07  -2.90000000E-07  -6.00000000E-07
   +9.00000000E-08  +3.00000000E-07  +1.53000000E-06
end_grad

# Low triangular part of force constant (hessian) matrix [hartree/bohr^2]
# i.e.: F_11, F_21, F_22, F_13, F_23, F_33...
start_hess
   +7.43206920E-01  -1.20926800E-02  +1.48294560E-01  +1.96615300E-02  -5.28411700E-02
   +6.85415200E-01  -1.33590060E-01  -5.04440000E-04  +1.74403900E-02  +6.34059470E-01
   +7.29728000E-03  -6.92384800E-02  +2.51251800E-02  -1.72961300E-02  +1.90948250E-01
   -5.38726200E-02  +2.61347000E-02  -3.22151580E-01  +2.06899900E-02  -4.50057000E-02
   +6.68374800E-01  +2.39920700E-02  +8.80292000E-03  -9.08537700E-02  -2.89545060E-01
   +7.53690000E-03  -3.19121900E-02  +6.84014860E-01  +3.58426000E-03  +8.22585000E-03
   +4.38525000E-03  +1.54544300E-02  -7.09143900E-02  +9.66053000E-03  -1.20089400E-02
   +1.51155330E-01  -3.56657200E-02  +2.73922000E-03  -1.70519800E-02  -1.04014200E-01
   +1.02963900E-02  -1.57691060E-01  -1.00083700E-02  -6.15956300E-02  +7.40124310E-01
   -1.42636400E-02  -2.35321000E-03  +2.81442500E-02  -5.76899400E-02  +2.86929000E-03
   -1.23569400E-02  -2.77120280E-01  -8.62242000E-03  +1.43237570E-01  +7.48918720E-01
   -2.25573000E-03  -4.20417000E-03  +5.28063000E-03  -2.91307000E-03  +8.42627000E-03
   -5.73894000E-03  -1.38167000E-03  -5.99780300E-02  +1.09042800E-02  -1.83435400E-02
   +1.31625580E-01  +2.46750800E-02  +5.83683000E-03  -6.43111500E-02  +4.36115000E-02
   -6.30479000E-03  +6.76998600E-02  +7.22878400E-02  +1.22975600E-02  -2.06597770E-01
   +9.32317000E-03  -5.67905700E-02  +6.86916040E-01  -6.01798900E-02  -3.45322000E-03
   +4.84716700E-02  -3.04352500E-02  +5.39189000E-03  -4.51283900E-02  +5.89750900E-02
   -3.40498000E-03  +2.31851200E-02  -1.41868200E-01  +1.09333000E-03  +8.40309000E-03
   +7.29348800E-01  +2.66019000E-03  +2.99758000E-03  -8.42030000E-03  +5.32326000E-03
   -6.44459000E-03  +5.69343000E-03  -9.78147000E-03  +2.32845000E-03  +3.40906000E-03
   +9.61440000E-03  -7.17148100E-02  +2.39188000E-02  -1.57824900E-02  +1.68553160E-01
   -1.23500300E-02  -7.32957000E-03  +7.81998400E-02  -4.61954900E-02  +5.73953000E-03
   -5.49282500E-02  +8.34990200E-02  +2.60048000E-03  -3.84403100E-02  -7.73717000E-02
   +2.65703400E-02  -3.14262440E-01  +9.04581000E-03  -5.35181200E-02  +7.01950540E-01
   -2.73407360E-01  -2.84030000E-03  +6.98922400E-02  +5.10623400E-02  -9.06230000E-03
   +7.45442500E-02  -7.59695600E-02  +7.61520000E-04  +5.30192000E-03  +2.53718200E-02
   +7.60006000E-03  -8.12768200E-02  -2.83062760E-01  +9.93808000E-03  -4.32792900E-02
   +6.98864840E-01  -9.29521000E-03  -6.15541900E-02  +1.31824500E-02  -3.11117000E-03
   +7.03271000E-03  +2.67580000E-03  +9.41560000E-04  -3.21873000E-03  -8.76200000E-05
   +2.62966000E-03  +8.23658000E-03  +3.82300000E-03  +1.72155700E-02  -7.28281300E-02
   +1.12098900E-02  -1.20724900E-02  +1.35847340E-01  +1.41819290E-01  +1.17004400E-02
   -2.10116380E-01  +2.08604800E-02  +3.74453000E-03  -3.74009500E-02  +7.96277000E-03
   -3.23980000E-04  -2.86537000E-03  -3.18049400E-02  +2.82184000E-03  -1.09557300E-02
   -1.24579240E-01  +1.32146500E-02  -1.74853790E-01  -7.28597000E-03  -6.06513500E-02
   +7.55860840E-01  +5.25313000E-03  -1.00986000E-03  +5.16801000E-03  -1.40479090E-01
   +1.35630000E-04  +4.26680900E-02  -2.77233500E-02  +1.02150000E-04  +1.92994000E-02
   -2.12627000E-03  +8.20720000E-04  -3.99101000E-03  -1.50853000E-03  -1.21480000E-04
   +4.36140000E-04  +1.30906000E-03  +3.98800000E-04  -2.60702000E-03  +4.77127540E-01
   -3.86141000E-03  +2.20254000E-03  +2.01084000E-03  +2.96270000E-04  -6.90692500E-02
   +2.88265000E-03  +9.62540000E-04  +1.20377000E-03  -7.25520000E-04  -1.19310000E-04
   +5.42274000E-03  +1.32920000E-04  -4.60740000E-04  -5.24260000E-04  +3.92010000E-04
   +9.95140000E-04  +6.33863000E-03  +1.82119000E-03  -4.33098000E-03  +4.68450790E-01
   +2.52504000E-02  +3.71600000E-04  -1.66756900E-02  +3.77523700E-02  +3.74028000E-03
   -1.21363450E-01  -2.12912000E-03  -6.34490000E-04  +1.21303500E-02  -4.60186000E-03
   +6.54090000E-04  +2.15530000E-04  -5.91760000E-04  +3.30900000E-04  -2.24467000E-03
   -1.76172000E-03  +6.26870000E-04  -3.42426000E-03  +2.33580000E-03  -3.05959000E-03
   +4.73220360E-01  -1.40392000E-03  +7.42190000E-04  -8.57770000E-04  -4.48235000E-03
   +2.32211800E-02  +1.65007200E-02  -9.10400000E-04  +9.53130000E-04  +1.70593000E-03
   +5.61250000E-04  -6.65070000E-04  +6.34500000E-05  +1.14090000E-03  +6.57400000E-05
   +3.74000000E-06  -1.22011000E-03  -1.09356000E-03  -9.88400000E-05  -7.39175800E-02
   +4.29353000E-03  +2.02710000E-03  +5.90235690E-01  -9.25130000E-04  -6.60850000E-04
   +1.34887000E-03  +9.16690000E-03  -3.32412000E-03  -8.29289000E-03  -1.38994000E-03
   -2.30050000E-04  +3.77200000E-04  -9.72400000E-05  +1.64300000E-04  -7.96200000E-05
   +2.75270000E-04  +9.37400000E-05  -1.14730000E-04  -1.25810000E-04  -1.06320000E-04
   +1.37790000E-04  -1.15070000E-03  -1.49269090E-01  -3.69493700E-02  +5.00369000E-03
   +4.79349010E-01  +1.09229000E-03  -5.73460000E-04  +3.71280000E-04  +7.90649000E-03
   -2.01014400E-02  -1.66890700E-02  -7.98250000E-04  -7.58080000E-04  -7.56100000E-05
   -3.43870000E-04  +4.63580000E-04  -4.36200000E-04  -5.17410000E-04  +1.93800000E-05
   +2.38290000E-04  +6.07910000E-04  +1.09804000E-03  -6.84200000E-05  +1.70350000E-04
   -4.08126200E-02  -9.47479500E-02  +6.68498000E-03  -4.91064600E-02  +5.68909690E-01
   +1.90425000E-03  +8.49450000E-04  -9.16550000E-03  +6.30090000E-04  -1.04183000E-03
   +5.58586000E-03  -4.05532000E-03  +4.38370000E-04  -1.64194000E-03  -3.43314000E-03
   -3.57780000E-04  +9.09310000E-03  -2.29145420E-01  -7.41693000E-03  +1.25611510E-01
   -5.66805500E-02  -1.33730000E-03  +3.31485600E-02  +1.62973000E-03  +9.43210000E-04
   -3.42000000E-04  -1.37832000E-03  -5.51380000E-04  +7.03510000E-04  +6.75088740E-01
   +3.17730000E-04  +4.95178000E-03  +1.43538000E-03  -6.19440000E-04  -1.24190000E-03
   -4.75130000E-04  +1.32773000E-03  +7.23987000E-03  +9.71190000E-04  -4.49403000E-03
   +9.29306000E-03  +4.48671000E-03  -1.79875000E-03  -4.47270100E-02  +1.12746300E-02
   +2.21813000E-03  +7.62685000E-03  -2.00908000E-03  +6.57900000E-05  -5.61200000E-04
   -1.62670000E-04  -3.92700000E-05  -4.63600000E-05  -9.66000000E-06  -2.84805000E-02
   +3.20530700E-02  -2.20890000E-03  +1.39385000E-03  -7.55106000E-03  +5.38248000E-03
   -3.00310000E-04  +3.26973000E-03  -1.02946900E-02  +1.19879000E-03  -2.53207000E-03
   +4.98667500E-02  +3.15460000E-03  -3.72994600E-02  +7.29369100E-02  +1.30276200E-02
   -1.92416210E-01  -6.88767000E-03  -1.05511000E-03  +1.84350700E-02  -9.04530000E-04
   -7.42970000E-04  +7.11450000E-04  +8.22370000E-04  +3.63780000E-04  -4.83560000E-04
   +8.66320100E-02  -4.13693100E-02  +4.06234600E-01  -3.34954000E-03  -6.15180000E-04
   +7.78180000E-04  +2.35459000E-03  -1.76167400E-02  +1.80697200E-02  -1.98355000E-03
   -1.03233000E-03  +2.31162000E-03  +1.29360000E-04  +7.33300000E-05  +4.58470000E-04
   +1.81440000E-04  -1.46630000E-04  -9.94900000E-05  +5.11200000E-05  +8.02050000E-04
   +7.61810000E-04  -7.10779200E-02  +1.08364100E-02  -3.73867000E-03  +1.40300000E-05
   +7.61560000E-04  -1.48256000E-03  -4.26480000E-04  +4.14100000E-05  +2.68760000E-04
   +2.09398580E-01  +1.46904000E-03  -3.58310000E-04  -1.16259000E-03  -6.46877000E-03
   +1.55860000E-04  +5.64205000E-03  -6.45000000E-06  -2.82060000E-04  -2.66000000E-05
   +7.28160000E-04  -3.61850000E-04  -1.81900000E-04  -2.05830000E-04  +1.04960000E-04
   +2.60810000E-04  -3.34800000E-05  -2.00770000E-04  -2.36620000E-04  +4.40286000E-03
   -1.35788480E-01  +3.53572300E-02  +4.22753000E-03  -3.09446400E-02  +2.05483500E-02
   +4.77560000E-04  +2.17000000E-05  -2.70390000E-04  -6.70110000E-02  +5.31200280E-01
   +1.84511000E-03  +6.19220000E-04  -2.04450000E-04  +5.93816000E-03  +1.64022200E-02
   -2.47579800E-02  -3.61130000E-04  +1.98950000E-04  +9.31990000E-04  -5.44570000E-04
   -3.16610000E-04  -2.08000000E-04  +5.45150000E-04  +7.28500000E-05  -5.72880000E-04
   -2.12550000E-04  -5.92680000E-04  -5.02590000E-04  -5.42724000E-03  +4.46237600E-02
   -1.19852740E-01  +5.49070000E-04  -5.99237000E-03  +1.20325200E-02  -7.62510000E-04
   +1.69000000E-05  +5.65050000E-04  -1.62183100E-02  +1.43123700E-02  +7.28016840E-01
   +6.67900000E-05  +2.27630000E-04  -5.00150000E-04  -4.61560000E-04  -7.13410000E-04
   +2.66500000E-04  -3.26150000E-04  -1.73208000E-03  +5.21000000E-04  +5.03270000E-04
   -2.65290000E-04  -4.72920000E-04  +7.43210000E-04  +1.86990000E-04  -8.43700000E-05
   -1.77640000E-04  -1.14990000E-04  -3.59900000E-05  -3.01917000E-03  +4.10009000E-03
   -1.01487000E-03  +8.54540000E-04  -1.37020000E-04  -4.23280000E-04  -4.68190000E-04
   -5.88400000E-05  +2.80030000E-04  -4.76110200E-02  +8.07338000E-03  -3.18277700E-02
   +2.03814100E-01  +3.07490000E-04  -1.20670000E-04  -6.77020000E-04  -4.22410000E-04
   -1.28444000E-03  +3.25350000E-04  -4.39480000E-04  -1.16565000E-03  +8.26670000E-04
   +2.59850000E-04  -6.83600000E-05  -7.18750000E-04  +4.21120000E-04  -4.16800000E-05
   +4.63150000E-04  -3.57940000E-04  -9.89000000E-05  -3.93100000E-05  +8.70860000E-03
   -2.24363200E-02  -2.95577000E-03  +3.34530000E-04  -7.95670000E-04  +2.18596000E-03
   +1.40000000E-06  +4.70900000E-05  -1.16970000E-04  +4.45012700E-02  -2.18424730E-01
   -2.31303800E-02  -8.25363900E-02  +5.63041580E-01  +2.41900000E-05  -4.33500000E-04
   +5.97650000E-04  -1.48975000E-03  +1.85675000E-03  -1.75440000E-04  +1.92539000E-03
   +8.09950000E-04  -1.23670000E-04  -7.74910000E-04  +2.40920000E-04  +8.90510000E-04
   -6.85260000E-04  +1.05500000E-04  -7.77920000E-04  +1.06815000E-03  -1.77990000E-04
   -9.18110000E-04  -3.03748000E-03  +1.79594700E-02  +1.39734600E-02  -5.72660000E-04
   +3.28937000E-03  -4.85952000E-03  +1.13530000E-04  -9.10600000E-05  -1.17330000E-04
   +4.78131000E-03  -3.79576400E-02  -1.03542780E-01  +1.06565420E-01  +1.31657800E-02
   +5.50565990E-01  -3.52330000E-04  +1.05730000E-04  -4.45760000E-04  +1.00388000E-03
   -3.48070000E-04  -4.43890000E-04  -1.16240000E-04  +6.74100000E-05  +2.98280000E-04
   +9.12900000E-05  +1.90010000E-04  +1.64930000E-04  +1.00233000E-03  -3.23300000E-05
   -1.40000000E-05  -6.79020000E-04  +6.91700000E-05  +1.72100000E-04  +2.46250000E-03
   +2.99974000E-03  +2.14360000E-04  -1.44140000E-04  +1.38890000E-04  +1.24110000E-04
   -1.06866000E-03  +1.35830000E-04  +6.31350000E-04  +1.43046700E-02  -1.27962000E-03
   -2.56966800E-02  -1.13552830E-01  -5.11610000E-03  +9.50927000E-03  +6.01448300E-02
   -1.10730000E-04  +3.34300000E-05  +5.61910000E-04  +5.33570000E-04  +3.42170000E-04
   -8.28370000E-04  +1.83450000E-04  +3.77090000E-04  -9.30200000E-05  -3.18020000E-04
   +2.54300000E-05  +1.41970000E-04  -6.34310000E-04  -2.01800000E-05  -1.04960000E-04
   +4.63350000E-04  -1.36000000E-06  -7.11800000E-05  +1.67570000E-04  -2.52841000E-03
   -2.68961000E-03  +3.11510000E-04  -6.13630000E-04  +1.07598000E-03  +4.91840000E-04
   -3.86400000E-05  -2.94040000E-04  -8.51681000E-03  -2.73949300E-02  +2.01334700E-02
   +6.73716600E-02  -1.88499140E-01  +7.11245600E-02  +6.81456900E-02  +6.66137190E-01
   +6.25160000E-04  +7.89000000E-05  -7.29270000E-04  -6.82840000E-04  +6.10290000E-04
   +2.99210000E-04  -2.56600000E-04  -7.43320000E-04  +1.06000000E-04  +3.79000000E-04
   -1.94480000E-04  -7.36350000E-04  +2.37600000E-05  +4.16000000E-05  +5.23570000E-04
   -3.35170000E-04  -8.04500000E-05  +1.10740000E-04  +1.75112000E-03  -4.89475000E-03
   -1.64633000E-03  +1.58730000E-04  -7.52700000E-04  +4.15160000E-04  +4.24990000E-04
   -4.60800000E-05  -3.19850000E-04  -7.62856000E-03  +2.54118600E-02  +4.25639800E-02
   -3.09102700E-02  +5.42251100E-02  -1.53001480E-01  +3.64830900E-02  +4.85281700E-02
   +6.06878440E-01  -5.14600000E-05  +1.31200000E-05  +1.87600000E-05  +2.13670000E-04
   -3.86350000E-04  +1.17420000E-04  -2.60900000E-05  +1.89100000E-05  -2.41000000E-05
   +6.66000000E-06  +1.68500000E-05  +9.37000000E-06  +8.75700000E-05  -4.37000000E-06
   -7.07100000E-05  -5.97400000E-05  +3.52500000E-05  +3.88400000E-05  -4.36690000E-04
   +3.79320000E-04  +3.09760000E-04  +6.10600000E-05  +3.45400000E-05  +8.41900000E-05
   -9.45200000E-05  -1.79400000E-05  +7.49300000E-05  -8.56750000E-04  +1.37029000E-03
   +5.07302000E-03  +3.37081000E-03  -6.92439000E-03  -2.80241000E-03  -6.14240600E-02
   +1.64842000E-03  +1.94227300E-02  +2.07375920E-01  -8.40700000E-05  +3.03100000E-05
   +2.36510000E-04  -1.53840000E-04  +3.21260000E-04  -4.75810000E-04  +2.49260000E-04
   +2.72720000E-04  +7.19900000E-05  -1.62760000E-04  +1.10350000E-04  +2.76300000E-05
   -4.34430000E-04  -2.75900000E-05  +1.21730000E-04  +2.83810000E-04  -1.57900000E-05
   -5.79700000E-05  +1.29330000E-04  -3.89080000E-04  +7.83900000E-05  +7.45600000E-05
   -1.84000000E-06  -1.08710000E-04  +3.67060000E-04  +4.07700000E-05  -2.69330000E-04
   +8.19511000E-03  -1.35877900E-02  -2.97545600E-02  -1.06590100E-02  +2.29313400E-02
   +2.20741100E-02  -3.24631700E-02  -1.13441590E-01  -7.96645000E-03  -1.44040850E-01
   +7.70000460E-01  -5.53700000E-04  +6.05800000E-05  +1.36330000E-04  +9.25570000E-04
   -6.80250000E-04  -5.30570000E-04  +1.08300000E-05  +3.55610000E-04  -3.66300000E-05
   +1.36900000E-05  +3.39000000E-06  +5.77730000E-04  +7.94440000E-04  +1.92300000E-05
   -6.65520000E-04  -2.22310000E-04  +7.68900000E-05  +1.02150000E-04  -6.86150000E-04
   +2.01890000E-03  -1.30224000E-03  -1.48010000E-04  +4.79100000E-05  +5.91840000E-04
   -1.10484000E-03  +1.08300000E-05  +7.97910000E-04  +1.42063300E-02  -2.54558100E-02
   -3.51836000E-02  -3.05445500E-02  +1.99646000E-02  -1.53223000E-02  -2.28044500E-02
   -5.25079200E-02  -2.59337160E-01  -5.61403100E-02  +6.82482000E-03  +6.23165990E-01
   +3.80560000E-04  +5.29200000E-05  -2.02600000E-05  -5.00760000E-04  +1.13875000E-03
   -1.12847000E-03  -7.85600000E-05  +3.00000000E-05  -2.25760000E-04  +5.37000000E-06
   -2.43000000E-06  -3.01500000E-05  -1.15170000E-04  +3.63700000E-05  +4.48500000E-05
   +4.51700000E-05  -9.13800000E-05  -9.55400000E-05  +8.85778000E-03  +1.21044000E-03
   +8.00180000E-04  -2.47410000E-04  +1.06150000E-04  -1.99800000E-05  +1.42390000E-04
   -8.37000000E-06  -8.67300000E-05  +7.13744000E-03  -3.21793000E-03  -7.11136000E-03
   -1.13437300E-02  +1.88967000E-03  +1.77182000E-03  +5.91060000E-04  +5.19060000E-03
   +6.07094000E-03  -8.21254700E-02  +7.65406700E-02  +2.64909500E-02  +1.65770510E-01
   +4.27450000E-04  -7.32400000E-05  -2.40340000E-04  -4.38280000E-04  +5.01640000E-04
   +3.67550000E-04  -2.09540000E-04  -3.84690000E-04  +3.97800000E-05  +5.33100000E-05
   -3.51400000E-05  -3.66240000E-04  -1.56510000E-04  +2.84000000E-06  +3.31280000E-04
   -8.43800000E-05  -4.95100000E-05  -6.40500000E-05  +2.37271000E-03  -5.15430000E-04
   -2.20056000E-03  +2.03350000E-04  -5.05940000E-04  +2.24610000E-04  +3.61970000E-04
   -1.33600000E-05  -2.75160000E-04  -1.59368000E-02  +3.32532000E-02  +5.47773500E-02
   +3.66962900E-02  -2.19863100E-02  -9.02328000E-03  +3.73590800E-02  -8.38547000E-03
   -5.85027400E-02  +7.55007300E-02  -3.70715690E-01  -5.50845200E-02  -1.24587850E-01
   +7.14302210E-01  +2.86100000E-05  +4.64000000E-05  +3.66700000E-05  -1.34450000E-04
   +3.65930000E-04  -7.54670000E-04  -8.51500000E-05  +2.10120000E-04  -1.15870000E-04
   +3.88800000E-05  -1.66800000E-05  +2.67240000E-04  +1.64690000E-04  -2.00200000E-05
   -1.98570000E-04  -4.84300000E-05  -6.58000000E-06  -4.06000000E-06  +8.15190000E-04
   -2.38350000E-03  -2.92291000E-03  +1.66250000E-04  -9.95760000E-04  +6.13260000E-04
   -2.89540000E-04  +1.97500000E-05  +2.33390000E-04  +2.12652000E-03  +1.75408400E-02
   -4.54365000E-02  -7.64754000E-03  +8.91336000E-03  +7.22380000E-04  +2.26730000E-03
   -3.55481900E-02  -2.76110000E-04  +3.28298200E-02  -1.24097550E-01  -1.68287160E-01
   -4.48993700E-02  +4.70717200E-02  +7.19052410E-01  +5.91930000E-04  +3.47600000E-05
   -2.77270000E-04  -1.78113000E-03  +5.54570000E-04  +1.10000000E-05  -4.41610000E-04
   -1.63400000E-04  +1.95000000E-05  +3.86250000E-04  -8.60700000E-05  -4.13000000E-06
   +4.48000000E-06  -8.77900000E-05  +1.73740000E-04  -1.72740000E-04  -2.52500000E-05
   -2.70000000E-07  +6.98425000E-03  -1.34979000E-03  -3.86807000E-03  -1.05959000E-03
   +2.80810000E-04  +1.09120000E-04  +6.13000000E-05  +3.70400000E-05  +1.25500000E-05
   -6.95368400E-02  +1.17638200E-02  +2.79681900E-02  +1.10387400E-02  +5.20179000E-03
   +8.01060000E-03  -3.80900000E-05  -1.77273000E-03  -1.26440000E-03  +2.16222000E-03
   +8.71460000E-03  -2.19777000E-03  -6.21452000E-02  +2.18792100E-02  -1.21665900E-02
   +1.46052280E-01  -9.95020000E-04  +1.89300000E-05  +4.21080000E-04  +1.37607000E-03
   -2.60436000E-03  +2.23491000E-03  -5.92500000E-05  +8.30600000E-05  -1.07540000E-04
   -4.21000000E-05  +8.61400000E-05  +2.90780000E-04  +2.58540000E-04  -7.50000000E-06
   -2.59610000E-04  -4.05000000E-05  +2.20610000E-04  +2.55180000E-04  -1.49166000E-03
   +7.78165000E-03  +2.32605600E-02  -2.64000000E-05  -1.15760000E-03  +2.62426000E-03
   -4.37330000E-04  -8.71000000E-06  +3.14080000E-04  +1.71906500E-02  -1.29018700E-01
   -6.64981600E-02  -1.39816800E-02  -1.24285000E-03  -2.70887400E-02  -1.33676200E-02
   +3.32094000E-03  +8.83458000E-03  +1.14769700E-02  -4.97563100E-02  +3.24984000E-03
   +2.21685700E-02  -2.10328070E-01  +1.08119920E-01  -9.49275300E-02  +6.82285530E-01
   +1.06309000E-03  -8.20000000E-07  -2.36720000E-04  -1.78805000E-03  +1.31607000E-03
   +5.58610000E-04  -1.17097000E-03  -5.49110000E-04  -2.08520000E-04  +3.76630000E-04
   -8.49400000E-05  -3.29780000E-04  -5.49520000E-04  -3.97000000E-06  +7.33180000E-04
   -6.91700000E-05  -1.20430000E-04  -8.24600000E-05  +1.32543000E-03  +3.36250000E-03
   -2.02877400E-02  -3.37110000E-04  +2.85380000E-04  -2.37221000E-03  +8.05990000E-04
   +3.54400000E-05  -5.29140000E-04  +8.32018000E-03  -2.06155300E-02  -3.99210770E-01
   +5.24817900E-02  -3.86894300E-02  -2.47849200E-02  +2.49795300E-02  +6.01250000E-04
   -4.13331200E-02  -5.84169000E-03  +3.80789200E-02  +6.06851700E-02  -6.14097000E-03
   +4.64285000E-02  -1.86570060E-01  -3.97347000E-02  +5.33271000E-02  +7.28358710E-01
   -4.15350000E-04  -5.22150000E-04  -1.43970000E-04  -5.08260000E-04  -1.06962000E-03
   +4.10760000E-04  +3.43180000E-04  -2.72800000E-05  -4.69020000E-04  +1.16030000E-04
   +7.62200000E-05  +3.56560000E-04  -1.77910000E-04  +7.52200000E-05  -1.72070000E-04
   +2.42440000E-04  +5.86800000E-05  +3.53500000E-05  -1.29464000E-03  -7.24560000E-04
   -9.83060000E-04  +1.77950000E-04  -2.37970000E-04  +3.60260000E-04  +2.84100000E-05
   -3.42500000E-05  +5.92100000E-05  -1.87323000E-03  +6.53282000E-03  +1.30139400E-02
   -6.79173400E-02  -1.71818600E-02  -7.11505700E-02  +9.46395000E-03  -9.91405000E-03
   -4.21972000E-03  +3.07726000E-03  +1.40704000E-03  +5.96058000E-03  +5.52570000E-04
   -6.27256000E-03  +7.82220000E-04  +2.50200000E-03  +4.18614000E-03  -8.12452000E-03
   +6.08516510E-01  -5.86220000E-04  -9.07190000E-04  +1.66320000E-04  -7.21970000E-04
   -1.84875000E-03  -3.47570000E-04  +1.16760000E-03  -1.68060000E-04  -2.47320000E-04
   -5.01360000E-04  +1.18600000E-04  +1.10497000E-03  +6.91800000E-05  +1.68300000E-04
   -1.12248000E-03  +5.12930000E-04  +2.81600000E-05  -3.32080000E-04  +1.90190000E-04
   +2.77664000E-03  +9.09020000E-04  -2.50700000E-04  +3.63620000E-04  -1.81220000E-04
   -7.99680000E-04  -6.68000000E-06  +6.44820000E-04  -1.05938500E-02  -1.59225000E-03
   -3.37247100E-02  -2.66580000E-04  -7.92930700E-02  -5.35869400E-02  +8.17903000E-03
   +7.29830000E-03  +2.10179400E-02  +2.66631000E-03  -1.89614000E-03  +3.88694000E-03
   -4.55990000E-04  -1.89145000E-03  +1.51810000E-03  +9.34520000E-04  -6.66008000E-03
   -1.85854000E-03  +8.59533400E-02  +9.62203100E-02  +5.78700000E-05  +8.04110000E-04
   -7.01400000E-05  +1.40944000E-03  +6.21770000E-04  +1.77090000E-04  -1.16760000E-03
   +2.99500000E-04  -6.02570000E-04  +4.59600000E-04  -9.72100000E-05  -2.33800000E-04
   -2.24000000E-06  -9.98600000E-05  +4.22430000E-04  -5.87170000E-04  +1.80830000E-04
   +7.17900000E-04  +5.79190000E-04  +1.95589000E-03  -1.16594000E-03  +2.04390000E-04
   -2.30270000E-04  +5.86530000E-04  +2.06210000E-04  +4.77500000E-05  -3.83700000E-05
   -5.91539000E-03  -7.46715000E-03  -2.39367800E-02  -1.83548000E-02  -4.52225300E-02
   -2.31835370E-01  -9.96961000E-03  -1.11744600E-02  -4.98248300E-02  -4.97859000E-03
   +5.79326000E-03  +2.65505000E-03  +6.87990000E-04  -5.45710000E-04  -4.89720000E-04
   -3.78460000E-04  -5.03699000E-03  +8.38970000E-04  +7.99718900E-02  +7.90467900E-02
   +3.48133210E-01  +5.15260000E-04  +5.04200000E-05  +4.05990000E-04  -1.28211000E-03
   +5.37340000E-04  +4.77670000E-04  +1.61800000E-05  -2.55340000E-04  -2.63950000E-04
   -1.70800000E-05  -4.09650000E-04  -4.00760000E-04  -1.08334000E-03  +2.79300000E-05
   -5.52800000E-05  +7.32500000E-04  -8.90800000E-05  +3.76000000E-06  -3.76810000E-04
   -1.37750000E-03  +1.57026000E-03  +3.12990000E-04  +4.37550000E-04  -8.32460000E-04
   +1.32795000E-03  -1.90850000E-04  -7.37000000E-04  -1.07488700E-02  -1.85992000E-03
   +7.31912000E-03  -1.15292100E-02  +3.72418200E-02  -1.34977200E-02  +3.26194800E-02
   -3.72630500E-02  -1.90055300E-02  -1.51592800E-02  +2.35303200E-02  +2.43332500E-02
   +2.36921000E-03  -1.65821400E-02  +4.78470000E-04  -2.68961000E-03  +9.11042000E-03
   -9.21358000E-03  -5.23572000E-03  -3.82746000E-03  -4.25864000E-03  +1.23704540E-01
   -4.54500000E-05  -7.39000000E-06  -9.29600000E-05  +3.98970000E-04  -1.70360000E-04
   -1.28060000E-04  -3.79500000E-05  -1.91690000E-04  -1.90940000E-04  +1.08170000E-04
   -1.54800000E-05  +2.20090000E-04  +5.59180000E-04  +9.14000000E-06  -3.96370000E-04
   -2.16340000E-04  +5.56100000E-05  +5.41500000E-05  +9.96690000E-04  +1.37900000E-04
   +3.12680000E-04  -8.27100000E-05  -2.11820000E-04  +2.32350000E-04  -6.50160000E-04
   +3.27200000E-05  +4.73070000E-04  -6.52363000E-03  +1.76618000E-02  +1.43526000E-02
   +7.87567300E-02  -1.33833100E-02  -4.05707000E-03  +2.26019900E-02  -4.27098100E-02
   -1.82370800E-02  +9.09359000E-03  +2.66837000E-03  +1.33560800E-02  +3.28805000E-03
   -1.20901700E-02  +1.88665000E-03  -1.72675000E-03  +4.19876000E-03  -1.60196500E-02
   -1.55080000E-03  +1.79723000E-03  +4.25735000E-03  -1.39478770E-01  +3.02007470E-01
   -6.82000000E-05  +6.49500000E-05  +3.45100000E-05  +1.92540000E-04  -1.71140000E-04
   +8.80900000E-05  +4.07500000E-05  +1.65150000E-04  -3.46300000E-04  -1.23750000E-04
   +1.78780000E-04  +8.34700000E-05  -7.04000000E-05  -2.99700000E-05  +2.10940000E-04
   -2.50400000E-05  +2.88300000E-05  +8.85400000E-05  -5.87230000E-04  +6.65560000E-04
   -4.53800000E-04  -4.37900000E-05  +1.46210000E-04  +6.53000000E-06  +4.27700000E-05
   +6.62000000E-05  -2.82800000E-05  +7.33705000E-03  -1.54937700E-02  -1.54768500E-02
   -6.05556600E-02  +1.01404000E-02  +2.13693300E-02  -4.51941600E-02  +1.62415900E-02
   -4.12497000E-03  +1.64254300E-02  -9.56513000E-03  -2.66031400E-02  -1.83511000E-03
   +2.03109200E-02  -4.30650000E-03  +1.67270000E-03  -5.84705000E-03  +2.00819100E-02
   +8.95233000E-03  +1.87721000E-03  +1.08894000E-03  -8.55642900E-02  +2.38133860E-01
   +2.32049410E-01  +1.58300000E-05  +3.98000000E-06  +1.89700000E-05  -9.91100000E-05
   +3.09700000E-05  +7.48300000E-05  +4.26800000E-05  +1.17800000E-05  -3.07200000E-05
   -6.65000000E-06  -1.41200000E-05  -1.78800000E-05  -8.87300000E-05  +3.00000000E-07
   +1.29900000E-05  +6.55600000E-05  -5.06000000E-06  -5.67000000E-06  -7.60410000E-04
   -3.08490000E-04  -1.96020000E-04  +1.88400000E-05  +4.40100000E-05  -9.83200000E-05
   +1.00840000E-04  -4.50000000E-06  -5.99700000E-05  -4.57000000E-04  -1.22840000E-03
   -7.93530000E-04  +4.17950000E-03  +2.98834000E-03  -1.02088000E-03  +6.34561000E-03
   -1.19551000E-03  +2.06606000E-03  -6.38484100E-02  +4.66359200E-02  -1.11141800E-02
   +6.07955000E-03  +1.28552000E-02  -1.06169700E-02  +6.96766000E-03  +1.80964000E-03
   +3.30627000E-03  -4.94280000E-04  -3.50840000E-04  +7.12110000E-04  +1.30172000E-03
   -2.16766000E-03  +1.98172000E-03  +3.57547880E-01  -3.41720000E-04  -3.75100000E-05
   -1.02990000E-04  +7.73110000E-04  -7.84160000E-04  +1.04880000E-04  -1.93570000E-04
   +2.81700000E-05  -1.00000000E-06  +9.12000000E-05  -6.03800000E-05  +3.56270000E-04
   +8.23260000E-04  +1.20700000E-05  -4.94540000E-04  -3.69600000E-04  +8.94500000E-05
   +1.07450000E-04  -6.70510000E-04  +1.57600000E-03  -5.15430000E-04  -5.75600000E-05
   -6.70200000E-05  +5.78380000E-04  -9.79990000E-04  -9.87000000E-06  +7.04710000E-04
   +1.68913000E-03  -6.13299000E-03  -2.50415000E-03  -2.05970000E-03  +4.52887000E-03
   -3.73294000E-03  +9.02902000E-03  -6.81465000E-03  +1.13601400E-02  +1.58199000E-02
   -2.09383360E-01  +1.25498120E-01  +8.17648000E-03  -4.41537200E-02  +3.48947100E-02
   +3.65912000E-03  +9.45920000E-04  -4.49480000E-04  +4.79310000E-04  +1.42037000E-03
   +1.52286000E-03  -8.22569000E-03  +5.12230000E-03  -3.37578000E-03  -2.72414690E-01
   +4.40061480E-01  +1.87910000E-04  +3.50100000E-05  +1.09850000E-04  -4.42510000E-04
   +3.53450000E-04  +7.89200000E-05  +8.38800000E-05  +4.85300000E-05  -1.95700000E-05
   -7.25900000E-05  +6.81900000E-05  -2.35920000E-04  -6.14830000E-04  -3.48600000E-05
   +3.70920000E-04  +2.52540000E-04  -1.94700000E-05  -3.68100000E-05  -2.55970000E-04
   -8.61300000E-04  +5.67940000E-04  +5.53200000E-05  +5.53000000E-05  -4.04290000E-04
   +7.14870000E-04  +2.74200000E-05  -5.02640000E-04  -1.19516000E-03  +3.00298000E-03
   +2.60499000E-03  +2.69998000E-03  -7.13298000E-03  -7.48790000E-04  -1.82907000E-03
   +4.53242800E-02  -4.43815500E-02  +2.00359000E-02  +9.91144700E-02  -1.84357000E-01
   -2.13898000E-03  -8.86670000E-04  +1.34571700E-02  -3.08770000E-04  -1.42263000E-03
   -5.16713000E-03  -5.74760000E-04  +8.46230000E-04  -4.47903000E-03  +2.21824000E-03
   -3.09371000E-03  +3.09090000E-03  -1.23978850E-01  -7.76496800E-02  +2.94447640E-01
   +2.53100000E-04  +3.32890000E-04  +1.71240000E-04  -2.88794100E-02  -4.10909000E-03
   -9.28370000E-03  -1.92318000E-03  -7.94710000E-04  +3.36824000E-03  -6.56050000E-04
   +4.30930000E-04  -9.41840000E-04  +1.65030000E-04  -8.69400000E-05  +2.22010000E-04
   -6.77720000E-04  +1.67670000E-04  -9.55230000E-04  -1.47006760E-01  -1.19916600E-02
   -3.79329600E-02  -4.48176000E-03  -6.06931000E-03  -5.54841000E-03  -8.95700000E-05
   -3.58000000E-06  +5.95000000E-06  -6.56271000E-03  +6.81275000E-03  -1.01347200E-02
   +9.34460000E-04  +1.73080000E-04  +8.55740000E-04  -1.13440000E-04  -2.43870000E-04
   -1.75500000E-05  -8.31300000E-05  -3.62800000E-05  -3.79330000E-04  +1.15300000E-04
   +4.08140000E-04  -4.11100000E-05  -7.73790000E-04  -7.49510000E-04  +2.37711000E-03
   -1.65462000E-03  +1.71633000E-03  -1.01165000E-03  +3.91330000E-04  -2.46600000E-04
   +2.84200000E-05  +3.49100000E-05  -3.49440000E-04  +1.96690000E-04  +4.83091050E-01
   -1.90190000E-04  -5.88020000E-04  -4.16610000E-04  +2.59500000E-05  -9.53400000E-05
   -1.56490000E-04  -1.13140000E-04  +4.54400000E-04  -9.93000000E-06  +7.07800000E-05
   +2.30240000E-04  -1.31730000E-04  +2.58010000E-04  +1.56820000E-04  +5.34200000E-05
   -1.28280000E-04  -1.26740000E-04  -1.32000000E-06  -4.69286000E-03  -7.58653400E-02
   -1.70411000E-03  -2.78330500E-02  -9.48631000E-03  -1.94572500E-02  -1.80250000E-04
   -1.64700000E-05  +9.85900000E-05  +2.21387500E-02  +4.03162000E-03  +1.34844900E-02
   +1.54719000E-03  -5.79370000E-04  +7.03900000E-04  -1.63290000E-03  -2.51160000E-04
   +1.52798000E-03  -4.34450000E-04  +2.00380000E-04  -1.26047000E-03  -1.34384000E-03
   +1.16200000E-05  -2.71220000E-04  +2.64650000E-04  -2.13156000E-03  +1.27142000E-03
   +3.60260000E-04  -9.28920000E-04  -1.26997000E-03  +6.88840000E-04  -4.31430000E-04
   -1.73600000E-04  +3.14180000E-04  -1.08091000E-03  +6.98790000E-04  -7.83414000E-03
   +5.86369870E-01  +1.79708000E-03  +3.96650000E-04  -8.34870000E-04  +1.73104000E-02
   +1.78264000E-03  +1.29881800E-02  +3.06785000E-03  +1.46250000E-04  -3.98109000E-03
   +1.11123000E-03  -3.22350000E-04  +3.83780000E-04  -2.73120000E-04  +1.70000000E-07
   +4.68790000E-04  +3.84760000E-04  +1.94000000E-06  +3.12190000E-04  -4.23374400E-02
   -6.84142000E-03  -9.79861800E-02  -1.90938500E-02  -8.81116000E-03  -1.36785500E-02
   +6.05900000E-04  +1.71200000E-05  -4.82580000E-04  -2.02995000E-02  +2.62516000E-03
   -1.73091700E-02  +8.42110000E-04  +1.60390000E-04  +1.97166000E-03  +8.79930000E-04
   -1.49750000E-04  -1.17038000E-03  +9.33800000E-05  -2.03600000E-05  +6.31100000E-04
   +1.36491000E-03  +2.28780000E-04  -2.89600000E-05  -2.18220000E-04  +1.54932000E-03
   -2.14610000E-04  -3.08231000E-03  +2.30344000E-03  -8.46490000E-04  -3.96110000E-04
   -1.91000000E-06  +1.61690000E-04  -1.66440000E-04  +4.56600000E-04  -3.86160000E-04
   -5.16980500E-02  +4.77997000E-03  +5.65733340E-01  -7.21390000E-04  +2.46530000E-04
   -1.84584000E-03  +8.09510000E-04  -6.00000000E-06  +4.46770000E-04  -1.19986000E-03
   +1.48900000E-05  -3.55670000E-04  +5.83486000E-03  +5.10800000E-05  -2.57588000E-03
   -3.87663700E-02  +3.10971000E-03  -2.00124200E-02  -2.18998000E-03  -4.58500000E-04
   +5.81428000E-03  -1.66700000E-04  -1.22910000E-04  +1.74350000E-04  +1.36320000E-04
   +5.75900000E-05  -8.58600000E-05  -3.87857430E-01  +3.20180700E-02  -1.97645540E-01
   +1.75100000E-05  -3.25100000E-05  +1.36470000E-04  +1.21870000E-04  -2.10000000E-06
   -1.24600000E-05  +1.37680000E-04  -7.87100000E-05  -5.99700000E-05  +2.00600000E-05
   -8.48100000E-05  +2.01640000E-04  -1.78400000E-05  -6.22000000E-05  +5.67800000E-05
   +6.43000000E-06  +6.15900000E-05  -1.30950000E-04  +2.35000000E-06  +1.19850000E-04
   -4.72100000E-05  -1.57820000E-04  +1.21380000E-04  -4.70900000E-05  -1.74100000E-05
   +1.82530000E-04  -1.41060000E-04  +2.33200000E-05  +2.84200000E-05  -9.85900000E-05
   +4.23723170E-01  +2.62900000E-05  +1.68506000E-03  +1.02330000E-04  +2.24700000E-05
   +1.11650000E-04  +2.91200000E-05  +1.49500000E-05  -6.75710000E-04  +1.97500000E-05
   -6.34690000E-04  -8.06190000E-04  -2.26310000E-04  -2.03467000E-03  -2.50063000E-03
   -9.01470000E-04  -3.32140000E-04  +2.06211000E-03  +3.45870000E-04  +1.29600000E-05
   -5.12900000E-05  +1.27000000E-06  +1.94400000E-05  +1.66000000E-06  -1.40800000E-05
   +3.76037300E-02  -7.27634000E-03  +2.52261300E-02  -3.26800000E-05  +3.23900000E-05
   -6.64000000E-06  +4.70500000E-05  -1.48700000E-05  +5.20600000E-05  -2.04560000E-04
   +6.19000000E-05  +7.34900000E-05  +1.40700000E-05  -3.86500000E-05  -6.97200000E-05
   +2.51000000E-06  +4.64700000E-05  -2.59300000E-05  +2.79000000E-06  -3.10200000E-05
   +2.91600000E-05  +2.18000000E-05  -4.83600000E-05  -2.47200000E-05  +2.94140000E-04
   -6.14100000E-05  -7.63100000E-05  +9.94000000E-06  -2.30900000E-05  +5.90000000E-07
   +6.60000000E-06  -1.42300000E-05  -9.30000000E-07  -3.48004100E-02  +7.75961000E-03
   +1.37720000E-04  +9.18200000E-05  +1.15812000E-03  -2.86190000E-04  +8.40900000E-05
   -3.51430000E-04  +1.54400000E-05  +1.32400000E-05  -6.52900000E-04  +4.30005000E-03
   -4.18230000E-04  +1.88196000E-03  +2.94919600E-02  -2.47578000E-03  +1.27719400E-02
   +4.17726000E-03  +3.63450000E-04  -2.91776000E-03  -1.13250000E-04  -5.04100000E-05
   -1.40240000E-04  +8.49700000E-05  +1.57600000E-05  -1.38800000E-05  -2.51146600E-01
   +2.68879500E-02  -1.90847510E-01  +3.52500000E-05  -2.19600000E-05  -3.12300000E-05
   -4.27000000E-05  +1.49300000E-05  +5.87200000E-05  +2.49500000E-05  +8.44000000E-06
   +2.40000000E-06  -1.41400000E-05  +4.59900000E-05  -5.90900000E-05  -3.45000000E-06
   +1.19500000E-05  -2.27400000E-05  -2.54800000E-05  -1.35500000E-05  +1.81100000E-05
   -5.48000000E-06  -3.18100000E-05  -3.15900000E-05  -8.93000000E-05  -4.76900000E-05
   +1.50400000E-05  -1.33000000E-06  -6.66400000E-05  +4.54400000E-05  -2.42700000E-05
   +1.31000000E-06  +3.42500000E-05  +2.14567020E-01  -2.46637300E-02  +1.80580210E-01
   +2.95900000E-04  -1.09180000E-04  +7.08030000E-04  -1.68711000E-03  -5.16600000E-05
   +4.22007000E-03  -1.89602800E-02  +1.96246000E-03  -1.32185800E-02  -2.86241610E-01
   +1.81277600E-02  -1.03532490E-01  -3.93806000E-03  -1.01820000E-04  +3.27387000E-03
   +1.86810000E-03  +1.80410000E-04  -5.89540000E-04  -5.97460000E-04  +4.57100000E-05
   -1.05930000E-03  -5.83300000E-05  -1.06060000E-04  -2.98000000E-06  +3.71460000E-03
   -2.31520000E-04  +3.64800000E-05  +3.27500000E-05  +1.49970000E-04  -2.26380000E-04
   -5.78300000E-05  -1.30400000E-05  +1.08900000E-05  -3.50090000E-04  +1.15010000E-04
   +1.35840000E-04  +1.14200000E-05  -2.02300000E-05  -2.09600000E-04  +1.61200000E-05
   +1.11550000E-04  -6.15700000E-05  +2.60300000E-05  -8.86300000E-05  +1.57840000E-04
   +4.09300000E-05  -9.00400000E-05  +5.62200000E-05  +5.15650000E-04  -5.42100000E-05
   -6.15300000E-05  +2.51100000E-05  -1.24040000E-04  +9.28000000E-05  -2.26910000E-04
   -1.73000000E-05  +4.06290000E-04  -9.57300000E-05  +1.73670000E-04  -1.60608000E-03
   +3.05360320E-01  -1.41620000E-04  -8.96950000E-04  -3.49000000E-06  -2.93560000E-04
   +7.27733000E-03  +8.31460000E-04  -1.23560000E-03  +2.49873000E-03  -4.71280000E-04
   +1.84944700E-02  -3.47743700E-02  +1.07836500E-02  +3.24916000E-03  +3.90916000E-03
   +8.77760000E-04  +3.17500000E-05  +5.34338000E-03  +1.12294000E-03  -6.90300000E-05
   +4.69020000E-04  -1.32200000E-04  +6.36000000E-06  -5.23200000E-05  -3.43400000E-05
   -2.44960000E-04  -3.84364000E-03  -6.18670000E-04  +3.17200000E-05  -2.98600000E-05
   +5.32700000E-05  +2.21600000E-05  -4.41400000E-05  +3.74700000E-05  -2.99130000E-04
   +9.81500000E-05  +8.77500000E-05  +1.91000000E-05  -4.84200000E-05  -6.01200000E-05
   +7.21000000E-06  +2.92300000E-05  -2.27900000E-05  -5.14000000E-06  -2.25300000E-05
   -1.79900000E-05  +1.29400000E-05  -4.35400000E-05  +6.80000000E-07  +5.08620000E-04
   -8.04000000E-06  -1.24110000E-04  +1.66200000E-05  -1.38300000E-05  -2.30000000E-06
   +5.04900000E-05  -5.38900000E-05  +2.26800000E-05  -1.12010000E-04  +5.35710000E-04
   +2.70230000E-04  -1.98377400E-02  +2.48219200E-02  +1.13222000E-03  +4.96000000E-06
   -1.31748000E-03  +3.49567000E-03  +7.56340000E-04  -1.31540000E-03  +1.80494500E-02
   -1.46866000E-03  +1.18292200E-02  -1.03885330E-01  +1.06856600E-02  -1.07746700E-01
   -2.98611600E-02  +1.94288000E-03  -6.29744000E-03  +5.74200000E-05  +1.14027000E-03
   -5.99914000E-03  +6.35290000E-04  +4.35700000E-05  +6.01390000E-04  -2.59300000E-05
   +4.48200000E-05  +4.33100000E-05  -7.70780000E-04  -6.59970000E-04  +2.65971000E-03
   -4.07800000E-05  -7.47900000E-05  +1.31530000E-04  +1.45200000E-05  -1.99000000E-06
   +3.21400000E-05  +5.66800000E-05  -5.80000000E-06  -2.61900000E-05  -3.47000000E-06
   +2.20400000E-05  +2.85300000E-05  -7.12000000E-06  -2.70700000E-05  +5.08000000E-06
   -2.78800000E-05  +1.02900000E-05  -6.93900000E-05  -1.36800000E-05  +1.18500000E-05
   -3.10400000E-05  -9.10900000E-05  -2.53100000E-05  -3.19500000E-05  -6.51000000E-06
   +4.44000000E-06  -1.09000000E-05  +1.62390000E-04  -1.95000000E-06  -2.24450000E-04
   +1.44958000E-03  +1.63570000E-04  -1.43806000E-03  +1.11390200E-01  -1.19738800E-02
   +1.08690360E-01  -5.46363000E-03  +4.61200000E-04  -2.06854000E-03  +2.53072000E-03
   +3.05067000E-03  -2.85344200E-02  -6.52083700E-02  +4.24948000E-03  -3.58950100E-02
   +6.66241000E-03  -2.77605000E-03  +2.65010800E-02  -3.82779000E-03  +7.69000000E-05
   +2.58965000E-03  -1.16167000E-03  -5.41300000E-05  +3.88770000E-04  +7.02440000E-04
   -2.23400000E-05  -6.88310000E-04  -4.53200000E-04  +5.25100000E-05  -8.20000000E-05
   -2.74500000E-05  -1.71840000E-04  +1.53279000E-03  -1.27046000E-03  -3.09840000E-04
   +3.14480000E-04  -6.49800000E-05  -3.22680000E-04  -4.06490000E-04  +7.51770000E-04
   -2.86680000E-04  -4.61670000E-04  -1.78900000E-05  +7.16200000E-05  +6.93610000E-04
   +1.31500000E-05  -4.29620000E-04  +3.56100000E-04  +1.32750000E-04  +2.54700000E-05
   +2.95500000E-05  +6.95600000E-05  +5.78700000E-05  +2.93620000E-04  -9.37930000E-04
   +1.05460000E-04  +1.49600000E-04  -4.07200000E-05  +3.74950000E-04  -2.55930000E-04
   +7.17600000E-05  -9.60200000E-05  +4.15500000E-05  +2.15870000E-04  -2.58000000E-06
   +7.08000000E-06  +8.80340000E-04  -1.17850000E-04  -2.75240000E-04  +6.61894800E-02
   +4.38800000E-04  +6.41895000E-03  +4.44690000E-04  -2.83180000E-04  +3.96242000E-03
   +2.24235000E-03  +4.92741000E-03  -4.25924700E-02  +3.30235800E-02  +3.74810000E-04
   +3.71106000E-03  +9.40670000E-04  +9.09300000E-05  +7.72954000E-03  +7.05020000E-04
   -7.25900000E-05  -1.17910000E-03  -1.28700000E-04  -1.60210000E-04  -3.08584000E-03
   -3.23390000E-04  +4.44200000E-04  +7.87000000E-06  +1.25490000E-04  +1.06600000E-05
   -5.28000000E-05  +1.40400000E-05  -8.99950000E-04  +3.34920000E-04  +3.31870000E-04
   +2.55470000E-04  -4.43600000E-05  -3.02680000E-04  -3.72890000E-04  -1.22170000E-04
   +2.76950000E-04  +6.95300000E-05  -2.27990000E-04  -3.10800000E-05  -5.64700000E-05
   +6.40100000E-05  +3.43800000E-05  +1.72530000E-04  -1.38960000E-04  +6.34400000E-05
   +1.60400000E-05  -1.25140000E-04  +6.30000000E-05  +4.25840000E-04  +1.75780000E-04
   +5.49300000E-05  +2.28000000E-05  +9.59600000E-05  -8.86700000E-05  -1.26370000E-04
   -2.14600000E-04  +1.02420000E-04  +6.71000000E-06  -2.95000000E-05  +1.95000000E-06
   -1.80540000E-04  -4.33524000E-03  -5.29860000E-04  -4.22179000E-03  +3.15707400E-02
   -2.61136000E-03  +8.04300000E-04  +6.50180000E-04  -1.02300000E-05  +1.52685000E-03
   -8.71521000E-03  -3.56548900E-02  +3.17396500E-02  -3.29116830E-01  -4.63363000E-03
   +1.93810000E-03  -1.41871100E-02  +3.11807000E-03  +7.26260000E-04  +9.05440000E-04
   +1.69630000E-04  -2.09240000E-04  +7.27170000E-04  +8.90160000E-04  -3.94560000E-04
   -5.95680000E-04  -1.76900000E-05  -1.36440000E-04  -1.00650000E-04  +2.46980000E-04
   +1.51870000E-04  -1.23918000E-03  +3.98030000E-04  +6.88760000E-04  +3.65980000E-04
   +6.25060000E-04  -3.59100000E-05  -4.85610000E-04  -1.39720000E-04  -3.91200000E-05
   +2.91400000E-04  -1.33100000E-05  -1.11470000E-04  -1.25340000E-04  -3.33800000E-05
   +1.96480000E-04  -6.11200000E-05  +1.71220000E-04  -7.76800000E-05  +1.19090000E-04
   +4.21000000E-05  -2.95700000E-05  +2.75800000E-04  +3.52920000E-04  +1.13210000E-04
   -1.48640000E-04  -1.13200000E-05  +4.51200000E-05  -5.58000000E-05  -1.01940000E-04
   +4.23000000E-06  +1.47780000E-04  -2.31930000E-04  -6.42000000E-06  +6.38000000E-06
   +2.03460000E-04  -6.27130000E-04  +8.09760000E-04  +3.71744600E-02  -3.58923600E-02
   +3.50734640E-01  -2.89893860E-01  +1.41547300E-02  -1.09016740E-01  +1.59180000E-04
   +1.13960000E-04  -1.28103000E-03  +1.55087000E-03  +2.11300000E-05  -3.98510000E-04
   +3.29030000E-04  -9.51400000E-05  +8.01700000E-04  -1.26705000E-03  -2.47010000E-04
   +3.65820000E-03  -1.91665200E-02  +1.65774000E-03  -1.28079700E-02  -1.04760000E-03
   -3.35600000E-05  +1.42680000E-04  +3.36200000E-05  +1.17620000E-04  -1.09750000E-04
   -1.48111000E-03  +9.09300000E-05  -5.50900000E-04  +7.73700000E-05  -1.44630000E-04
   -7.22500000E-05  -2.19700000E-05  -6.28500000E-05  -1.57520000E-04  +2.63600000E-05
   -7.70000000E-07  +1.56800000E-05  +1.44500000E-05  -3.39300000E-05  +4.66200000E-05
   -4.30000000E-06  -8.27000000E-06  +1.90000000E-07  +1.18000000E-06  +6.81600000E-05
   -4.94300000E-05  +3.41200000E-05  +3.55400000E-05  +1.98520000E-04  +1.50000000E-07
   +2.71800000E-05  +4.15000000E-06  -2.97000000E-06  +5.37600000E-05  -2.67200000E-05
   -2.37240000E-03  -3.24570000E-04  +3.09260000E-03  -2.44850000E-04  -1.96600000E-05
   +1.83640000E-04  -8.59900000E-05  -6.50000000E-07  -3.19000000E-05  -5.52700000E-05
   +2.32500000E-05  +9.44500000E-05  +3.14064890E-01  +1.34940300E-02  -3.99331700E-02
   +8.36533000E-03  +2.90854000E-03  +4.26675000E-03  +1.14341000E-03  +2.60730000E-04
   +6.41647000E-03  +1.43187000E-03  -1.97720000E-04  -1.08007000E-03  +1.81100000E-05
   -1.70870000E-04  +7.99230000E-03  +7.69940000E-04  -1.17548000E-03  +4.03333000E-03
   -4.62710000E-04  -7.79600000E-05  -3.70464000E-03  -3.56510000E-04  +4.51830000E-04
   +1.76370000E-04  -6.19930000E-04  -2.80900000E-05  +5.62600000E-05  -3.55700000E-05
   -4.02730000E-04  +1.61260000E-04  +3.52440000E-04  +1.81670000E-04  +1.71450000E-04
   +3.32290000E-04  -1.06200000E-05  -5.83600000E-05  -6.80000000E-07  -2.65900000E-05
   +2.76000000E-06  -2.23100000E-05  +4.32000000E-05  +2.04900000E-05  -5.98000000E-06
   +1.55900000E-05  -1.41410000E-04  +2.81400000E-05  -1.17690000E-04  +1.51490000E-04
   -4.90560000E-04  -3.33400000E-05  -5.04000000E-06  -2.27800000E-05  +5.11000000E-06
   -2.82400000E-05  -1.66700000E-05  -2.62230000E-04  +7.46850000E-04  +3.24220000E-04
   -2.72100000E-05  -1.86980000E-04  -1.18100000E-05  -1.18000000E-05  -7.12160000E-04
   -7.59000000E-05  +1.88680000E-04  +3.60900000E-05  +1.53700000E-05  -1.48528600E-02
   +2.74857800E-02  -1.08838040E-01  +8.67107000E-03  -1.11758650E-01  -2.85795000E-02
   +1.37964000E-03  -6.36506000E-03  -7.70700000E-05  +1.28342000E-03  -6.24569000E-03
   +9.49700000E-04  -3.54100000E-05  -9.03400000E-04  +3.44993000E-03  +8.15710000E-04
   -1.49634000E-03  +1.85520700E-02  -9.80870000E-04  +1.10174600E-02  -1.30731000E-03
   -4.17840000E-04  +9.14990000E-04  +2.29120000E-04  +5.20300000E-05  -1.13020000E-04
   +7.39250000E-04  -7.98900000E-05  +5.83350000E-04  +7.75100000E-05  +1.64960000E-04
   +1.38960000E-04  +3.25000000E-06  -4.75900000E-05  -1.62950000E-04  -1.56770000E-04
   +2.59700000E-05  +1.49310000E-04  -5.84000000E-06  -6.13000000E-06  -1.10560000E-04
   -1.46300000E-05  +2.98800000E-05  -2.98000000E-05  +7.53000000E-05  -5.21500000E-05
   +1.15040000E-04  +2.14120000E-04  -1.81140000E-04  +1.75040000E-04  +2.32720000E-04
   -4.63200000E-05  +9.60000000E-07  +2.05500000E-05  -8.06900000E-05  +6.27500000E-05
   +8.17650000E-04  +2.33500000E-04  -1.25527000E-03  +2.97220000E-04  -1.38100000E-05
   -1.45690000E-04  -8.27800000E-05  -7.64900000E-05  +5.81300000E-05  -1.58065000E-03
   +7.18800000E-05  -5.02940000E-04  +1.13502080E-01  -1.02620200E-02  +1.15465430E-01
   +7.42208000E-03  -2.58521000E-03  +2.60625300E-02  -3.60196000E-03  +1.48800000E-05
   +2.92195000E-03  -1.56713000E-03  -3.92000000E-05  +4.07480000E-04  -5.29496000E-03
   +4.55240000E-04  -1.77422000E-03  +2.74737000E-03  +2.86849000E-03  -2.99167800E-02
   -6.36393400E-02  +3.56029000E-03  -3.09603500E-02  +5.09680000E-04  -2.07330000E-04
   +9.08630000E-04  -1.06250000E-04  -8.90800000E-05  +4.06000000E-05  +2.13241000E-03
   -1.95790000E-04  +6.35440000E-04  -2.15730000E-04  +1.33410000E-04  +5.96400000E-05
   +1.37600000E-05  +2.32000000E-05  +6.14900000E-05  -7.05900000E-05  +8.80000000E-06
   +3.91500000E-05  -7.87000000E-06  +2.08000000E-06  -5.99900000E-05  +2.84900000E-05
   +3.39900000E-05  -4.45000000E-06  +3.70900000E-05  -7.59700000E-05  +8.00300000E-05
   -1.70900000E-05  -1.58600000E-05  -5.85700000E-05  +9.22900000E-05  -1.04800000E-05
   -1.60400000E-05  +5.00000000E-06  -4.48500000E-05  +2.52000000E-05  +1.18630000E-04
   -1.06700000E-05  -6.75000000E-06  +3.68880000E-04  -4.20200000E-05  +2.31870000E-04
   -1.11570000E-04  +1.50960000E-04  -1.50985000E-03  +9.11400000E-05  -2.21000000E-05
   +9.95000000E-06  +9.59530000E-04  -7.54800000E-05  -3.33730000E-04  +6.02475900E-02
   +2.41560000E-04  +2.41889000E-03  +8.57300000E-04  -1.37300000E-04  +7.14282000E-03
   +7.41660000E-04  -1.17200000E-05  -1.04924000E-03  -1.86900000E-04  +5.30180000E-04
   +5.50646000E-03  +5.13410000E-04  -1.22030000E-04  +5.08282000E-03  +2.24884000E-03
   +3.66280000E-03  -3.80679600E-02  +2.93104400E-02  +1.37780000E-04  +3.59260000E-04
   +8.47400000E-05  -9.58100000E-05  +1.49000000E-05  +3.04000000E-05  -2.20550000E-04
   -3.50976000E-03  -4.36270000E-04  +1.10770000E-04  +5.75800000E-05  -1.23960000E-04
   -1.50000000E-05  +2.45200000E-05  +6.72900000E-05  -5.46600000E-05  +8.86000000E-06
   +1.64700000E-05  +5.00000000E-08  -2.29400000E-05  -3.89800000E-05  -1.14400000E-05
   +3.87100000E-05  -2.02600000E-05  +1.34900000E-05  -1.69600000E-05  +3.28900000E-05
   +9.20000000E-07  -5.01200000E-05  -8.99100000E-05  +3.96300000E-05  -1.09000000E-05
   -3.95300000E-05  -2.29000000E-06  -3.17000000E-06  -8.33000000E-06  -1.01000000E-05
   -7.74900000E-05  +8.60000000E-07  -2.76600000E-05  -5.53900000E-04  -7.12500000E-05
   +7.60000000E-06  -5.91200000E-05  +7.05600000E-05  -1.45700000E-05  -6.83830000E-04
   -7.74500000E-05  -8.38900000E-05  -4.48752000E-03  -4.83230000E-04  -3.92317000E-03
   +2.78415000E-02  -4.54504000E-03  +1.53647000E-03  -1.26677900E-02  +3.28400000E-03
   +5.09510000E-04  +5.28450000E-04  -6.37000000E-06  -1.69370000E-04  +7.56880000E-04
   -2.43621000E-03  +5.24200000E-04  +6.48090000E-04  +2.80110000E-03  +1.42018000E-03
   -1.03578900E-02  -3.26389400E-02  +2.95127800E-02  -3.37873660E-01  -5.18570000E-04
   +1.47530000E-04  -3.72050000E-04  +1.02020000E-04  +9.08700000E-05  -6.70000000E-05
   +2.66580000E-04  -4.50940000E-04  +1.11037000E-03  +1.75940000E-04  -1.22550000E-04
   -3.29100000E-05  -7.73000000E-06  -4.16200000E-05  -5.67400000E-05  +6.24400000E-05
   -1.32900000E-05  -4.73400000E-05  +1.42300000E-05  -2.78100000E-05  +9.18800000E-05
   -2.31500000E-05  -3.66900000E-05  +1.71900000E-05  -1.78300000E-05  +8.42100000E-05
   -8.09200000E-05  +1.96400000E-05  +7.37100000E-05  +5.56400000E-05  -6.30000000E-05
   +4.33300000E-05  +5.25000000E-06  -6.01000000E-06  +8.26200000E-05  -5.14100000E-05
   -5.84500000E-05  +1.98000000E-06  -5.94500000E-05  +1.28420000E-04  -6.38000000E-05
   +1.15750000E-04  -1.03800000E-05  +3.67600000E-05  -4.17820000E-04  -1.98300000E-05
   -6.04600000E-05  -9.14100000E-05  +3.04590000E-04  -5.14600000E-04  +7.85430000E-04
   +3.31406100E-02  -3.24496800E-02  +3.58104330E-01  +9.96100000E-05  -4.32400000E-05
   +2.69600000E-04  +1.77250000E-04  +7.90270000E-04  -5.28080000E-04  -1.87120000E-04
   -4.01600000E-05  -4.20210000E-04  -6.21300000E-05  -1.15090000E-04  +1.31260000E-04
   -1.58310000E-04  +5.26000000E-06  +2.46800000E-05  +2.06400000E-05  -5.21800000E-05
   +2.35600000E-05  -1.78955000E-03  +1.39731000E-03  -6.38970000E-04  -4.75703700E-02
   +7.00724000E-03  -7.78375000E-03  +1.06740000E-04  -2.24000000E-06  -5.71100000E-05
   +1.70010000E-04  +4.18090000E-04  +2.22280000E-04  +3.49000000E-04  +4.50600000E-05
   -1.12710000E-04  +1.17310000E-04  +1.23980000E-04  -1.65350000E-04  -1.46500000E-05
   +3.83400000E-05  +2.07280000E-04  +1.83290000E-04  -2.06020000E-04  +9.86000000E-06
   +3.44420000E-04  +2.13660000E-04  +1.70810000E-04  -6.48500000E-05  +2.20000000E-05
   +4.72300000E-05  -6.54200000E-05  -1.67100000E-05  +5.92000000E-05  -1.92200000E-05
   +5.34100000E-05  -4.69800000E-05  -5.61200000E-05  -1.05143000E-03  +7.05190000E-04
   -1.86100000E-05  +1.41500000E-05  +2.91000000E-06  +8.59000000E-06  +1.69200000E-05
   -4.39000000E-06  +1.32660000E-04  +5.66200000E-05  +7.42200000E-05  +8.16000000E-06
   +3.24200000E-05  -3.80300000E-05  +1.05200000E-05  +1.06600000E-05  -4.84000000E-06
   +4.76126500E-02  +6.56500000E-05  +2.93100000E-04  -2.28300000E-05  -1.17195000E-03
   +6.34960000E-04  +1.04087000E-03  +7.67060000E-04  +2.19400000E-04  -8.89200000E-05
   -1.99140000E-04  -1.45640000E-04  +4.28580000E-04  -4.35200000E-05  -2.69900000E-05
   -4.54860000E-04  +2.55890000E-04  +8.85000000E-06  -2.80740000E-04  +1.65006000E-03
   -2.26938800E-02  +1.97516500E-02  +7.36045000E-03  -1.80652780E-01  +1.34555140E-01
   -2.50940000E-04  +1.88400000E-05  +1.91390000E-04  +2.31300000E-04  -4.27827000E-03
   -4.09944000E-03  +4.41100000E-05  -4.47410000E-04  +1.85218000E-03  -1.42620000E-04
   -3.85900000E-04  -1.03040000E-04  -5.46300000E-05  +8.11400000E-05  -3.95980000E-04
   -2.07400000E-05  +2.05860000E-04  -2.00500000E-05  +1.97710000E-04  +6.04900000E-05
   -5.57430000E-04  -1.63600000E-04  +3.90600000E-05  -3.37660000E-04  +4.22870000E-04
   -1.39230000E-04  -4.11000000E-06  +3.07800000E-05  -2.68120000E-04  +2.07280000E-04
   +9.76620000E-04  +4.91340000E-04  +1.50427000E-03  +3.93200000E-05  -1.08100000E-05
   +1.26000000E-06  -1.15100000E-05  -7.18000000E-06  -1.90000000E-06  -9.54500000E-05
   +5.27500000E-05  -4.00400000E-05  -4.50500000E-05  -9.20300000E-05  -9.08700000E-05
   +2.11600000E-05  -1.52000000E-06  +3.06000000E-06  -8.58633000E-03  +1.99645000E-01
   -1.97140000E-04  -2.32500000E-05  +2.07570000E-04  +3.85030000E-04  -1.10428000E-03
   +1.05456000E-03  -2.64050000E-04  -3.41200000E-05  -1.66090000E-04  -2.32000000E-06
   +5.51000000E-06  +1.04520000E-04  +6.15200000E-05  +1.14000000E-05  -7.39200000E-05
   +1.46900000E-05  +3.63300000E-05  -5.65000000E-06  +4.81400000E-04  -1.20182300E-02
   +8.46748000E-03  -8.31367000E-03  +1.37610130E-01  -1.81829140E-01  -1.30710000E-04
   -2.42400000E-05  +9.17300000E-05  +1.92980000E-04  -2.90879000E-03  -1.83032000E-03
   -1.32250000E-04  -3.55130000E-04  +5.74240000E-04  +2.25600000E-04  -2.88960000E-04
   -2.33020000E-04  -2.47900000E-05  +6.59400000E-05  +7.17500000E-05  +2.21200000E-05
   +1.72540000E-04  +3.98870000E-04  +1.99390000E-04  -1.42860000E-04  -7.77500000E-04
   +5.74400000E-05  +6.02800000E-05  +1.90270000E-04  -1.99170000E-04  +7.08400000E-05
   +1.80800000E-05  -4.12000000E-05  +1.40960000E-04  -4.02000000E-05  +3.90090000E-04
   -7.06680000E-04  +7.71810000E-04  +1.81400000E-05  +1.30400000E-05  -4.54000000E-06
   -8.74000000E-06  +2.20900000E-05  -6.08000000E-06  +5.35000000E-05  -2.02800000E-05
   +2.31000000E-05  -6.43500000E-05  -1.57400000E-05  -3.72500000E-05  -1.07000000E-05
   -5.65000000E-06  +1.58400000E-05  +8.69180000E-03  -1.44825100E-01  +1.96438250E-01
   +1.74560000E-04  +3.58100000E-04  -8.78460000E-04  +3.20970000E-04  +7.22290000E-04
   +9.40280000E-04  +7.43400000E-05  +2.16100000E-04  +3.90720000E-04  +2.88410000E-04
   +1.78030000E-04  -2.75880000E-04  +5.85990000E-04  -2.57500000E-05  +2.36930000E-04
   -6.18450000E-04  -4.18500000E-05  +1.86280000E-04  -1.02375000E-03  -8.77410000E-04
   -7.28000000E-04  -2.21619910E-01  +1.78656900E-02  +1.23886980E-01  -3.29800000E-04
   -3.75200000E-05  +1.81040000E-04  -2.04160000E-04  +3.57000000E-06  +6.88180000E-04
   +3.23120000E-04  +3.43600000E-05  -7.03900000E-05  -1.99540000E-04  +9.72000000E-05
   +8.80500000E-05  +1.10000000E-06  -6.31400000E-05  +4.24600000E-05  +1.09940000E-04
   -4.03150000E-04  -4.29990000E-04  +2.41920000E-04  +4.42210000E-04  +9.47770000E-04
   -7.58200000E-05  -3.91100000E-05  -2.19820000E-04  +2.95500000E-04  -8.39800000E-05
   +3.96000000E-06  +4.33900000E-05  -1.11600000E-04  -5.23000000E-06  +6.91180000E-04
   -6.44930000E-04  -9.36210000E-04  +4.96600000E-05  -2.74000000E-06  -1.12200000E-05
   -3.61900000E-05  +1.17000000E-06  -2.25000000E-06  +7.96900000E-05  -3.43810000E-04
   +3.45100000E-05  +5.18300000E-05  -7.58000000E-06  +2.63600000E-05  -2.62900000E-05
   -4.65900000E-05  +1.55600000E-05  +1.71480000E-03  -5.63130000E-04  -2.04781000E-03
   +2.37801630E-01  +5.54610000E-04  -6.44900000E-05  -3.15900000E-05  -1.06649000E-03
   -4.30211000E-03  -2.14728000E-03  +2.41650000E-04  +1.27020000E-04  -2.77860000E-04
   -4.02000000E-05  +1.98970000E-04  -4.93400000E-05  -4.46730000E-04  -3.56200000E-05
   +1.56400000E-05  +4.88750000E-04  +3.80500000E-04  -1.05440000E-04  +2.34249800E-02
   -1.92695000E-03  -1.71716700E-02  +1.62453800E-02  -4.88754900E-02  -1.29499200E-02
   +5.16400000E-04  +6.40000000E-06  -3.17910000E-04  +1.92730000E-04  +9.14660000E-04
   -3.28180000E-04  -3.60700000E-04  +2.25500000E-05  -2.54840000E-04  +3.40420000E-04
   -9.15500000E-05  -1.99520000E-04  +4.89000000E-06  +1.11570000E-04  +2.86150000E-04
   -1.25800000E-05  -8.41700000E-05  +3.07190000E-04  +1.05670000E-04  -4.07270000E-04
   +2.32840000E-04  +6.43000000E-05  +4.73500000E-05  +1.83630000E-04  -4.11780000E-04
   +6.41500000E-05  +6.07300000E-05  -3.80600000E-05  +1.71270000E-04  -9.66400000E-05
   +1.35922000E-03  +1.12789000E-03  +4.27640000E-04  -5.20900000E-05  -1.00700000E-05
   -2.30400000E-05  +5.35200000E-05  -4.93000000E-06  -7.60000000E-06  +3.47200000E-05
   -1.03330000E-04  +8.96500000E-05  -4.51800000E-05  -2.18930000E-04  -7.34400000E-05
   +5.54600000E-05  +3.98900000E-05  -5.08900000E-05  -1.93083700E-02  +2.42033000E-03
   +1.21009700E-02  -1.87797700E-02  +5.21763500E-02  +4.43960000E-04  -2.41540000E-04
   +2.01260000E-04  -1.50620000E-04  -3.40076000E-03  -7.85090000E-04  -6.93040000E-04
   +3.53600000E-05  -1.24780000E-04  +2.49160000E-04  +3.19490000E-04  -5.15510000E-04
   -2.10310000E-04  -4.89400000E-05  +5.38910000E-04  +1.11200000E-05  +2.06230000E-04
   +1.04000000E-04  +1.09749400E-02  -4.67680000E-04  -9.41865000E-03  +1.23954960E-01
   -1.32645200E-02  -1.36854780E-01  +5.41010000E-04  -6.00000000E-06  -3.98460000E-04
   -1.31300000E-05  +3.74470000E-04  -2.12780000E-04  -1.49180000E-04  -4.85400000E-05
   +7.16500000E-05  +3.84700000E-05  -3.97500000E-05  -7.10100000E-05  +9.56000000E-06
   +7.61500000E-05  -2.70500000E-05  -6.27000000E-05  +2.99600000E-05  +1.47150000E-04
   -6.03790000E-04  +6.29200000E-04  -1.75810000E-04  -6.26100000E-05  +1.16700000E-05
   -3.42700000E-05  -8.72200000E-05  -4.46000000E-06  +1.71100000E-05  +4.80000000E-06
   -2.10100000E-05  +2.18000000E-05  +8.54020000E-04  +5.18310000E-04  +3.89030000E-04
   -7.29500000E-05  +3.40000000E-07  -1.04200000E-05  +5.70600000E-05  +1.92300000E-05
   -1.71900000E-05  +1.00360000E-04  -2.61520000E-04  +9.93600000E-05  -3.54200000E-05
   -4.95300000E-05  -8.37200000E-05  +3.13700000E-05  +4.51000000E-06  -4.67600000E-05
   +1.82910900E-02  -2.98348000E-03  -1.23287300E-02  -1.37387050E-01  +1.55591700E-02
   +1.48313690E-01  +1.93200000E-05  +3.19800000E-05  -2.45460000E-04  +6.51410000E-04
   -1.14870000E-04  +7.28290000E-04  -2.21200000E-04  +4.16230000E-04  +4.34920000E-04
   +7.74100000E-05  +6.43200000E-05  -1.52460000E-04  +2.90400000E-05  -4.95100000E-05
   +1.45390000E-04  -6.20300000E-05  +3.33200000E-05  +8.92300000E-05  +1.92150000E-04
   +5.27200000E-04  +1.70869000E-03  -2.31325410E-01  -3.28972300E-02  -1.22197410E-01
   +1.03670000E-04  -2.10000000E-07  -8.49200000E-05  +3.46110000E-04  +1.45010000E-04
   -6.87640000E-04  -2.07060000E-04  -5.06000000E-05  -5.60000000E-06  +1.66690000E-04
   -7.32600000E-05  -8.42700000E-05  -6.00500000E-05  +8.68800000E-05  +5.61800000E-05
   +1.08640000E-04  +1.54590000E-04  +3.28830000E-04  +5.91730000E-04  -1.31170000E-04
   -5.45040000E-04  +1.49640000E-04  -1.19300000E-05  +2.40640000E-04  -1.77210000E-04
   +2.93000000E-05  +2.56100000E-05  -4.26000000E-05  +6.70900000E-05  +9.07000000E-06
   +8.35270000E-04  -7.38590000E-04  -2.82660000E-04  -1.66600000E-05  +4.20000000E-07
   +5.40000000E-07  +2.23400000E-05  +2.38900000E-05  -5.20000000E-06  -1.50310000E-04
   +3.28560000E-04  +1.34970000E-04  -3.00000000E-06  -7.95000000E-06  +4.40600000E-05
   +1.01000000E-06  -1.08600000E-05  -1.19000000E-05  -3.64980000E-04  +1.06960000E-04
   +8.50780000E-04  -1.89084200E-02  -3.32152000E-03  -1.47870800E-02  +2.48357800E-01
   +2.07290000E-04  +1.94790000E-04  -4.58870000E-04  -8.96900000E-04  +3.25510000E-04
   +1.34691000E-03  -3.73570000E-04  +1.79570000E-04  -4.97650000E-04  +3.80320000E-04
   +2.81600000E-05  -8.69000000E-05  +2.81360000E-04  -3.56500000E-05  +3.22060000E-04
   -4.14970000E-04  -2.67200000E-05  +1.34320000E-04  -2.38737700E-02  -4.16604000E-03
   -1.52569000E-02  -3.06325800E-02  -5.23677800E-02  -2.12823200E-02  -1.05780000E-04
   -3.04300000E-05  +6.99800000E-05  -5.22900000E-04  +1.44562000E-03  -7.06530000E-04
   +1.36930000E-04  -6.19000000E-05  -3.43010000E-04  +1.04650000E-04  +5.01900000E-05
   -1.83740000E-04  -2.52000000E-06  +9.85600000E-05  +2.25960000E-04  +1.00050000E-04
   -1.03990000E-04  +2.68600000E-04  -6.10500000E-05  -3.93450000E-04  +4.27550000E-04
   +1.42610000E-04  -4.75700000E-05  +2.68420000E-04  -9.80000000E-05  +2.11900000E-05
   +5.44700000E-05  -2.11600000E-05  +1.32950000E-04  -6.69200000E-05  +9.75340000E-04
   -5.35317000E-03  -2.72099000E-03  +1.96500000E-05  +1.36800000E-05  -7.60000000E-06
   +3.43000000E-06  +1.88900000E-05  -2.88300000E-05  +4.90370000E-04  -4.16150000E-04
   +6.64200000E-05  -8.24000000E-06  -4.75100000E-05  +6.52500000E-05  -1.31000000E-06
   -2.31100000E-05  -2.93000000E-06  +1.96177100E-02  +3.86117000E-03  +1.17958900E-02
   +2.07185000E-03  -6.78750000E-04  +2.08503000E-03  +3.48413400E-02  +5.78238800E-02
   +2.49390000E-04  +1.12190000E-04  -7.12740000E-04  -1.15803000E-03  +2.26660000E-04
   +7.38630000E-04  -1.66910000E-04  +2.50700000E-04  -5.17800000E-05  +4.99140000E-04
   +2.19230000E-04  -3.57310000E-04  +3.79140000E-04  -8.46600000E-05  +3.40750000E-04
   -4.83320000E-04  -5.01300000E-05  +2.01340000E-04  -1.11598000E-02  -5.88620000E-04
   -8.72942000E-03  -1.21026840E-01  -2.23147700E-02  -1.28491070E-01  -9.00000000E-05
   -8.49000000E-06  +5.74700000E-05  +4.10340000E-04  +8.07050000E-04  +1.16810000E-04
   +1.78100000E-04  -1.12000000E-05  -4.49500000E-05  -4.42700000E-05  +2.61200000E-05
   +5.90000000E-07  -3.16700000E-05  +9.08600000E-05  +1.68700000E-05  +7.51200000E-05
   -1.26770000E-04  +7.15200000E-05  +2.94970000E-04  +8.02940000E-04  +6.12900000E-05
   +1.20700000E-04  -1.02580000E-04  +3.78500000E-05  +1.47170000E-04  -6.85100000E-05
   +2.69300000E-05  +1.10100000E-05  -7.48600000E-05  +4.09700000E-05  +7.29230000E-04
   -2.95058000E-03  -1.48549000E-03  +2.47100000E-05  -1.16900000E-05  -1.96000000E-05
   +2.98000000E-06  -1.68600000E-05  -1.72200000E-05  +1.92740000E-04  -4.08380000E-04
   +2.32390000E-04  +2.24400000E-05  +9.75000000E-06  +1.50220000E-04  -2.35000000E-06
   -5.34000000E-06  -8.60000000E-07  -1.83397900E-02  -4.27206000E-03  -1.18390000E-02
   +1.62390700E-02  +3.36086000E-03  +1.14769900E-02  +1.33569380E-01  +2.49194400E-02
   +1.38238090E-01  -2.84870000E-04  -2.28170000E-04  +8.09800000E-05  +1.64036000E-03
   -3.05910000E-04  -8.40500000E-05  -2.57910000E-04  +2.27620000E-04  -1.10720000E-04
   +2.43190000E-04  +2.10600000E-05  -2.39780000E-04  +1.08030000E-04  -3.02600000E-05
   +3.01410000E-04  -2.06240000E-04  +1.10100000E-04  +2.29400000E-04  +1.02579000E-03
   -2.34266500E-02  -1.58896500E-02  -5.44724000E-03  +2.30000000E-05  -2.79647000E-03
   +9.46900000E-05  +3.87000000E-06  -7.57800000E-05  +7.52680000E-04  -4.92480000E-04
   +8.60730000E-04  -6.33500000E-04  -1.31720000E-04  -1.53782000E-03  +8.29000000E-06
   +2.07060000E-04  +1.35100000E-04  +1.35000000E-06  +4.65300000E-05  +2.97500000E-05
   -6.29000000E-06  -7.09600000E-05  +6.39900000E-05  +5.19000000E-05  +1.69100000E-04
   -1.42390000E-04  +2.11330000E-04  +5.15820000E-04  +9.68410000E-04  +5.69200000E-05
   -5.96800000E-05  +7.50700000E-05  +7.00000000E-08  -1.56100000E-05  +7.92700000E-05
   -4.63770000E-02  +2.23238000E-03  +2.09707000E-03  -1.97500000E-05  -1.12100000E-05
   +6.46000000E-06  +1.68000000E-05  -2.20900000E-05  -1.18300000E-05  +6.11500000E-05
   -6.44800000E-05  +2.32600000E-05  -5.08350000E-04  -7.00030000E-04  +6.17970000E-04
   -1.66100000E-05  -3.77600000E-05  -1.87000000E-06  -4.69100000E-05  +1.59920000E-04
   +1.45200000E-04  +1.80290000E-04  +9.74600000E-05  -1.87010000E-04  +5.80300000E-05
   -1.71760000E-03  -1.10256000E-03  +4.92699500E-02  -4.80590000E-04  +4.09560000E-04
   -7.86310000E-04  +5.47530000E-04  +1.15450000E-04  -4.52540000E-04  -2.41850000E-04
   +2.31100000E-05  +1.59020000E-04  +1.41500000E-04  -1.82000000E-06  -2.63800000E-05
   +4.54000000E-05  -5.97300000E-05  -4.18900000E-05  +1.91800000E-04  +2.73200000E-05
   +3.95890000E-04  -2.65200000E-05  -2.45994000E-03  -1.02110000E-04  -1.66606000E-03
   +6.65060000E-04  -8.57620000E-04  +5.14700000E-05  -5.09000000E-06  +4.57200000E-05
   -5.90820000E-04  +3.00900000E-04  +1.86920000E-04  -9.25300000E-05  +1.28500000E-05
   -1.41000000E-04  +1.66130000E-04  -3.91500000E-05  -6.35600000E-05  +3.77100000E-05
   -6.72000000E-06  +2.17940000E-04  +2.58400000E-05  -9.46500000E-05  +8.81000000E-05
   +1.72800000E-05  -1.04400000E-05  -2.82790000E-04  +2.74645000E-03  -3.27971000E-03
   +7.16050000E-04  -2.68510000E-04  +1.11140000E-04  +5.42300000E-05  -1.46500000E-05
   +1.45990000E-04  -9.20900000E-05  -8.25500000E-04  -2.18496750E-01  -1.31694280E-01
   +6.64000000E-06  -3.39000000E-06  -3.93000000E-06  -2.02000000E-06  -1.04700000E-05
   +8.45000000E-06  +7.92200000E-05  -1.20700000E-05  +5.15300000E-05  -4.90600000E-05
   -5.70300000E-04  +6.85430000E-04  -3.60900000E-05  +1.60200000E-05  +8.72000000E-06
   +2.14450000E-04  +5.29560000E-04  -1.97000000E-06  +1.50090000E-04  +3.02800000E-05
   +1.90140000E-04  +2.39700000E-05  -1.18630000E-04  -4.97330000E-04  -1.39571000E-03
   +2.39420170E-01  +4.06440000E-04  +2.81560000E-04  +2.19490000E-04  +8.98680000E-04
   +4.73550000E-04  +2.27800000E-04  -1.43880000E-04  +2.09480000E-04  +1.91000000E-06
   +1.07900000E-05  -9.09000000E-06  -2.10100000E-05  +1.11620000E-04  -4.13600000E-05
   +4.37000000E-06  -1.13570000E-04  -9.79000000E-06  +3.81000000E-05  +1.51040000E-03
   -1.15187600E-02  -9.04674000E-03  -2.96823000E-03  +6.69540000E-04  -1.39760000E-03
   -1.12440000E-04  +8.94000000E-06  +6.29900000E-05  +4.11410000E-04  -7.77480000E-04
   +3.89880000E-04  -7.89580000E-04  -6.07300000E-05  -1.85305000E-03  +2.32900000E-05
   +2.02120000E-04  +2.83000000E-06  +3.81000000E-06  +1.08880000E-04  +1.45980000E-04
   +7.92000000E-06  -1.88810000E-04  +1.41750000E-04  -3.92700000E-05  +2.70720000E-04
   -2.65080000E-04  +1.69567000E-03  -1.36121000E-03  +1.29006000E-03  +1.23940000E-04
   -9.62600000E-05  +1.22480000E-04  +8.20000000E-06  +5.16700000E-05  +6.33000000E-05
   -1.12400000E-05  -1.32029280E-01  -1.49589660E-01  +1.13600000E-05  -9.13000000E-06
   -4.78000000E-06  -2.33500000E-05  -3.73200000E-05  -1.19000000E-06  +1.10000000E-05
   -2.77500000E-05  -7.39000000E-06  +5.70970000E-04  +5.11310000E-04  -2.77140000E-04
   -8.03000000E-06  +1.52900000E-05  +1.33400000E-05  -3.11300000E-05  -2.50140000E-04
   +1.64660000E-04  -4.25200000E-05  +3.84200000E-04  +2.57200000E-04  -2.19850000E-04
   -1.08429000E-03  -5.34800000E-05  +3.87690000E-04  +1.44273370E-01  +1.59438130E-01
   +7.73000000E-05  +1.44640000E-04  -8.37440000E-04  -3.36774000E-03  -6.31230000E-04
   -4.50949000E-03  -8.50080000E-04  -2.27750000E-04  +1.53268000E-03  -4.41190000E-04
   +1.41770000E-04  -1.56160000E-04  +2.36790000E-04  -6.40000000E-07  -2.97040000E-04
   +6.40000000E-07  -4.81800000E-05  +9.85900000E-05  -2.21940800E-02  -2.26212000E-03
   +1.89963400E-02  +4.35110000E-04  +8.93030000E-04  +1.14376000E-03  -3.30110000E-04
   -1.33200000E-05  +2.69820000E-04  +4.77650000E-04  -5.24300000E-04  +1.64332000E-03
   +2.17160000E-04  +2.76130000E-04  +9.12900000E-05  -4.57910000E-04  +8.97100000E-05
   +5.15270000E-04  -6.56700000E-05  -1.07650000E-04  -4.90820000E-04  -1.01240000E-04
   +2.88260000E-04  -3.77770000E-04  +5.36080000E-04  +7.36100000E-05  -1.09780000E-04
   -1.10320000E-04  +2.05490000E-04  -2.60990000E-04  +4.28790000E-04  -6.56300000E-05
   -1.10560000E-04  +4.26300000E-05  -2.67610000E-04  +1.59380000E-04  -1.88780470E-01
   -2.09174800E-02  +1.32148940E-01  +6.31600000E-05  +1.00000000E-06  -1.88900000E-05
   -1.63060000E-04  +7.10000000E-06  +9.83100000E-05  -1.23000000E-05  -5.39600000E-05
   -8.18900000E-05  +2.43490000E-04  +6.70800000E-05  -1.67000000E-05  -3.28800000E-05
   -3.11000000E-06  +4.18800000E-05  +5.14800000E-05  +7.26100000E-05  -1.18820000E-04
   +3.83490000E-04  -6.79290000E-04  -5.81000000E-04  +3.39190000E-04  +1.47380000E-04
   -2.82010000E-04  +5.94460000E-04  +5.58560000E-04  -1.24085000E-03  +2.08172150E-01
   +8.83600000E-05  +2.69970000E-04  +8.22500000E-05  -3.91000000E-05  +2.71690000E-04
   -2.50820000E-04  -1.19040000E-04  +2.93640000E-04  +1.20950000E-04  +1.23100000E-05
   -4.61200000E-05  -1.14590000E-04  +4.45700000E-05  -4.91100000E-05  +7.87000000E-05
   -1.20710000E-04  +1.06660000E-04  -2.66600000E-05  -1.13287000E-03  -1.73082000E-03
   +2.06876000E-03  -7.48570000E-04  -4.22600000E-05  +8.74270000E-04  -1.13500000E-05
   -2.48000000E-06  -1.18800000E-05  +1.02350000E-03  +1.05650000E-04  -6.77400000E-05
   -1.10130000E-04  -6.01000000E-05  -1.35180000E-04  +1.10220000E-04  -4.63000000E-06
   -5.16000000E-06  +3.59100000E-05  -6.02900000E-05  +6.33700000E-05  -3.87600000E-05
   -4.08500000E-05  +1.61000000E-05  -6.09900000E-05  +8.05700000E-05  +9.53000000E-06
   +9.66100000E-05  -3.60000000E-04  +3.60500000E-04  -1.08410000E-04  +7.43000000E-05
   -3.02400000E-05  -2.38500000E-05  +5.39600000E-05  -4.23500000E-05  -2.09689300E-02
   -5.08676900E-02  +1.74404200E-02  -9.50000000E-07  -2.36000000E-06  -1.20000000E-06
   -8.69000000E-06  -4.92100000E-05  -8.70000000E-07  +4.16000000E-06  +4.04800000E-05
   -1.44200000E-05  -1.19100000E-05  -3.69440000E-04  -1.44270000E-04  +1.57000000E-06
   +2.64400000E-05  +4.09000000E-06  -1.01390000E-04  +8.27800000E-05  -2.14100000E-05
   -1.82590000E-04  -2.10240000E-04  -5.64080000E-04  +2.87600000E-04  -1.42000000E-06
   -1.11980000E-04  +1.97987800E-02  +4.43444000E-03  -1.70478500E-02  +2.24939200E-02
   +5.01535700E-02  -2.80790000E-04  +1.98700000E-04  -9.66690000E-04  -2.43645000E-03
   -5.15100000E-04  -2.02912000E-03  -8.90220000E-04  -1.05400000E-05  +7.63230000E-04
   -3.80200000E-05  +9.77700000E-05  -1.66910000E-04  +1.89300000E-05  -1.92900000E-05
   +1.97100000E-05  +1.30110000E-04  -1.27200000E-05  +4.07060000E-04  -1.32434500E-02
   -1.92300000E-03  +9.43580000E-03  -3.25120000E-04  +5.05650000E-04  +7.85150000E-04
   +1.08810000E-04  -8.69000000E-06  +1.53000000E-06  -9.36280000E-04  +2.10690000E-04
   +1.02604000E-03  +1.09870000E-04  -1.02600000E-04  -8.90000000E-05  -8.03800000E-05
   +2.41000000E-05  +1.75660000E-04  -2.56500000E-05  -1.19800000E-05  -1.69730000E-04
   +4.02700000E-05  +1.27090000E-04  -5.82700000E-05  +4.13700000E-05  -2.48380000E-04
   +3.26470000E-04  +1.30820000E-04  -2.96240000E-04  +2.53190000E-04  +9.36800000E-05
   -5.75400000E-05  +1.70000000E-06  +3.14000000E-06  -1.42840000E-04  +9.20000000E-05
   +1.34630950E-01  +1.78627800E-02  -1.70002000E-01  -3.50000000E-06  +2.40000000E-07
   -1.36000000E-06  -5.24700000E-05  -5.80000000E-06  +3.84600000E-05  +3.77600000E-05
   -5.27600000E-05  +6.42000000E-05  +5.68410000E-04  -1.05630000E-04  +4.83920000E-04
   -2.25000000E-05  +7.55000000E-06  +2.63000000E-06  -1.87000000E-06  -1.07970000E-04
   -5.99800000E-05  +1.45600000E-05  -5.93600000E-05  -1.71400000E-05  +6.05300000E-05
   +1.42330000E-04  +1.02410000E-04  +1.27796900E-02  +4.03568000E-03  -1.21365400E-02
   -1.42565730E-01  -1.99867300E-02  +1.83226400E-01  -5.04900000E-04  +4.71800000E-05
   +9.63900000E-05  +1.07023000E-03  +2.35070000E-04  +1.98400000E-05  -2.71990000E-04
   -1.77680000E-04  +6.10000000E-07  +2.20650000E-04  -5.67000000E-06  -1.56980000E-04
   +6.89000000E-06  -2.87000000E-06  +2.34750000E-04  -3.94000000E-05  -7.95900000E-05
   +2.77840000E-04  -5.82891000E-03  +2.34238400E-02  -1.68273000E-02  +1.01608000E-03
   +1.59385000E-03  +2.56520000E-04  +1.71110000E-04  -4.90000000E-06  -9.15300000E-05
   -4.31441000E-03  -2.28950000E-03  -1.40999000E-03  -3.69270000E-04  -2.54300000E-05
   -3.91700000E-04  +4.19340000E-04  +1.16780000E-04  -4.17210000E-04  +1.06030000E-04
   -1.26430000E-04  +3.70010000E-04  +4.14840000E-04  +8.24100000E-05  -5.23600000E-05
   +1.34640000E-04  +7.46680000E-04  -6.33170000E-04  -7.00000000E-06  +1.82530000E-04
   +3.46530000E-04  -3.00990000E-04  +1.65150000E-04  +3.10600000E-05  -9.91300000E-05
   +3.80870000E-04  -2.43790000E-04  -5.55567500E-02  +3.97153700E-02  -2.64009600E-02
   -2.56800000E-05  +7.19000000E-06  +5.92000000E-06  +1.98200000E-05  +2.29100000E-05
   -3.50000000E-06  +1.01900000E-04  +4.79700000E-05  +4.67100000E-05  -1.38150000E-03
   +5.76990000E-04  +1.41336000E-03  -1.76700000E-05  +2.04000000E-05  -2.16000000E-06
   -1.70670000E-04  -8.55940000E-04  -9.42400000E-05  -1.15500000E-05  -2.02480000E-04
   +6.70800000E-05  +7.78100000E-05  +9.08900000E-05  +4.21300000E-04  -8.72050000E-04
   +1.52470000E-04  +1.57100000E-04  +4.93103000E-03  -2.05475100E-02  +1.19964600E-02
   +6.11904800E-02  +4.29470000E-04  +1.51580000E-04  +1.20238000E-03  -2.80400000E-05
   -4.32200000E-05  +4.00560000E-04  +1.61310000E-04  +7.62000000E-06  -1.94040000E-04
   -6.99800000E-05  +1.67000000E-06  -3.24800000E-05  -3.94000000E-06  -5.75100000E-05
   +1.35890000E-04  -3.55930000E-04  +6.70100000E-05  -4.23210000E-04  -1.35043000E-03
   +1.92647000E-03  -2.56211000E-03  -1.10535000E-03  +7.11690000E-04  -1.39876000E-03
   -6.93800000E-05  +1.38700000E-05  -5.29700000E-05  -2.01300000E-04  +4.76310000E-04
   -1.03810000E-04  -5.30470000E-04  -2.32500000E-05  -7.87230000E-04  -1.57450000E-04
   +1.59300000E-04  +1.37220000E-04  -2.33100000E-05  +1.43060000E-04  -1.10900000E-04
   +8.98700000E-05  -9.06200000E-05  +5.73300000E-05  +2.34040000E-04  +2.05750000E-04
   -4.51990000E-04  +1.02738000E-03  -9.30290000E-04  +5.67630000E-04  +2.70860000E-04
   -9.52000000E-05  +3.32800000E-05  +1.69200000E-05  -1.36010000E-04  +1.35310000E-04
   +4.14263600E-02  -2.26812890E-01  +1.18810030E-01  -1.09300000E-05  -6.28000000E-06
   +5.19000000E-06  +2.86000000E-06  -4.12000000E-06  -1.40000000E-05  -6.24100000E-05
   -6.42000000E-06  -4.03100000E-05  -2.64280000E-04  +4.21300000E-05  -6.33750000E-04
   +3.70000000E-05  +1.47400000E-05  -5.34000000E-06  -4.14360000E-04  +2.97390000E-04
   -1.54670000E-04  +1.76410000E-04  -2.24400000E-05  +1.03560000E-04  +8.84800000E-05
   +2.20940000E-04  -1.24940000E-04  +3.82597000E-03  -1.95561200E-02  +1.47481800E-02
   +3.08200000E-04  -2.10720000E-03  +3.48330000E-04  -4.32046000E-02  +2.44415510E-01
   +5.57800000E-04  -4.05840000E-04  -2.34010000E-04  +3.60190000E-04  -1.25010000E-04
   +9.14100000E-05  -1.23400000E-04  -7.56700000E-05  -4.78600000E-05  +1.13700000E-05
   -1.02500000E-05  -1.34200000E-05  +5.03600000E-05  +5.17700000E-05  +6.50000000E-07
   -2.61000000E-06  -1.08000000E-05  +1.13020000E-04  -2.80523000E-03  +1.19733200E-02
   -9.75534000E-03  +3.16710000E-04  +1.13239000E-03  +2.10220000E-04  -2.40400000E-05
   -1.02500000E-05  +2.20800000E-05  -3.44042000E-03  -1.16050000E-03  -1.03255000E-03
   -3.89280000E-04  -4.18540000E-04  -9.87630000E-04  +5.15050000E-04  +7.61700000E-05
   -4.95460000E-04  +1.28890000E-04  -7.78200000E-05  +6.03980000E-04  +2.85590000E-04
   -1.45890000E-04  +1.93210000E-04  -3.40570000E-04  +5.02580000E-04  -1.71670000E-04
   +9.39300000E-04  -7.23630000E-04  +8.63680000E-04  -3.57500000E-04  +1.10540000E-04
   +1.29390000E-04  -7.60000000E-05  +4.68990000E-04  -2.74430000E-04  -2.68386000E-02
   +1.18076000E-01  -1.24750540E-01  +3.81000000E-06  +6.85000000E-06  -4.88000000E-06
   -8.73000000E-06  +1.97900000E-05  +1.74000000E-06  +1.82300000E-05  +3.74100000E-05
   -1.15700000E-05  +1.46951000E-03  -3.80340000E-04  -5.43890000E-04  -6.88000000E-06
   -1.76200000E-05  +5.06000000E-06  -5.61550000E-04  -7.75690000E-04  +3.55200000E-05
   +6.72000000E-05  +6.09600000E-05  -2.96840000E-04  +2.97100000E-04  -1.73930000E-04
   +3.38180000E-04  +3.75482000E-03  -1.67670800E-02  +1.18703200E-02  -4.84422000E-03
   +1.78345300E-02  -1.12412700E-02  +3.10956100E-02  -1.29497840E-01  +1.35848980E-01
   -2.98910000E-04  -6.34000000E-06  +7.34400000E-05  +4.67680000E-04  -4.84130000E-04
   +5.44770000E-04  +1.76340000E-04  +1.16300000E-05  +2.13870000E-04  -8.23200000E-05
   -2.98300000E-05  +4.72000000E-06  +6.75200000E-05  -8.60000000E-07  -5.53200000E-05
   +7.48000000E-06  +3.53700000E-05  +2.36200000E-05  -5.73026000E-03  -5.65960000E-04
   -4.45110000E-04  +1.09317000E-03  +2.80140000E-04  -3.47460000E-04  -1.04080000E-04
   +2.38000000E-06  +4.62800000E-05  +3.48507000E-03  +1.92750000E-03  +1.04080000E-03
   +7.33568000E-03  -7.73540000E-04  +1.67208000E-03  -2.36473000E-03  +4.97550000E-04
   -1.08880000E-04  +3.60484000E-03  -9.57200000E-05  -2.21487000E-03  +9.43050000E-04
   +4.42863000E-03  +6.70320000E-04  -4.21272700E-02  +4.52231600E-02  +2.03379200E-02
   +4.04850000E-04  +1.37536000E-03  +4.21500000E-04  +1.42875000E-03  +2.05670000E-04
   -4.78170000E-04  +3.13810000E-04  +3.75560000E-04  +7.67900000E-05  +3.36100000E-05
   +6.90660000E-04  -8.96420000E-04  +9.43000000E-06  -2.55000000E-06  +1.11200000E-05
   -2.46400000E-05  +3.13000000E-06  +1.45500000E-05  -2.13300000E-05  +8.91400000E-05
   -1.39700000E-05  -3.44000000E-06  -4.69000000E-06  -2.19200000E-05  -2.12700000E-05
   +6.20000000E-07  +1.39900000E-05  -4.90020000E-04  -4.59100000E-05  -1.93880000E-04
   -1.23190000E-04  +8.46320000E-04  -6.54450000E-04  -6.22580000E-04  -7.70610000E-04
   +5.47010000E-04  -6.47000000E-05  -6.03000000E-06  +1.70300000E-05  -7.25000000E-05
   +1.31300000E-05  -4.32900000E-05  -2.52420000E-04  -8.08700000E-05  -9.55500000E-05
   +3.38891000E-02  +1.01000000E-05  +1.17500000E-05  +1.61500000E-05  -1.20970000E-04
   -9.03500000E-05  -4.74700000E-05  +3.21800000E-05  +4.14100000E-05  -3.27000000E-05
   -3.46000000E-06  +7.00000000E-08  +3.10600000E-05  -3.31800000E-05  -3.80000000E-07
   -8.17000000E-06  +2.63000000E-05  +1.75600000E-05  -6.99000000E-06  -6.93510000E-04
   -1.38099000E-03  +1.81660000E-04  +9.57000000E-05  -2.01103000E-03  +3.40269000E-03
   +1.78000000E-05  +3.26000000E-06  -7.54000000E-06  +1.10342000E-03  -8.08580000E-04
   -2.54160000E-03  +2.24840000E-04  +1.36131000E-03  +2.37300000E-04  -6.48120000E-04
   +4.21550000E-04  +6.37360000E-04  +4.95380000E-04  -4.63270000E-04  +3.15657000E-03
   +3.55281000E-03  -1.77627700E-02  -1.02324100E-02  +4.62900700E-02  -2.96752100E-01
   -1.00034230E-01  +2.59730000E-04  +1.43790000E-04  -1.01730000E-04  +2.47270000E-04
   +1.44600000E-04  -2.50750000E-04  +6.07330000E-04  -1.28942000E-03  -1.86100000E-04
   +1.22140000E-04  +6.45500000E-05  -2.09090000E-04  -2.92000000E-06  -4.04000000E-06
   -1.50000000E-07  +1.58000000E-06  -4.96000000E-06  -2.05000000E-06  +3.98300000E-05
   -1.87300000E-05  -4.33100000E-05  -3.91000000E-06  -1.05200000E-05  -8.00000000E-07
   +2.54000000E-06  -2.36000000E-06  -2.40000000E-06  -1.13230000E-04  +2.50760000E-04
   +5.93740000E-04  -3.90000000E-05  -8.36140000E-04  +1.26370000E-03  -1.25000000E-06
   -6.68980000E-04  +8.06690000E-04  -3.02900000E-05  -1.24500000E-05  +1.06700000E-05
   -6.00100000E-05  +9.51000000E-06  -6.07300000E-05  -5.57600000E-05  +3.44400000E-05
   -2.40100000E-05  -5.12319700E-02  +3.19247020E-01  -5.22700000E-05  +2.73200000E-05
   +2.48300000E-05  +1.09850000E-04  +1.33430000E-04  +1.21640000E-04  -2.87400000E-05
   +6.20100000E-05  +3.40000000E-06  -3.72000000E-06  +3.31900000E-05  +4.58500000E-05
   +7.17500000E-05  -1.73100000E-05  -5.23300000E-05  -4.13900000E-05  -4.00000000E-08
   +5.40000000E-07  -8.36800000E-05  -1.34796000E-03  +9.93090000E-04  +2.76320000E-04
   +8.21450000E-04  -1.55508000E-03  -1.02910000E-04  +4.00000000E-06  +7.12600000E-05
   +5.97451000E-03  -3.03089800E-02  -7.60655000E-03  -7.30380000E-04  +1.57638000E-03
   -4.17523000E-03  -1.22300000E-05  +3.80220000E-04  -1.00103000E-03  -1.81120000E-04
   +2.50447000E-03  -2.50375000E-03  -3.72812000E-03  +2.15326500E-02  +9.78787000E-03
   +1.96593100E-02  -9.91730900E-02  -9.83439500E-02  +2.97380000E-04  -1.86001000E-03
   -1.58565000E-03  +2.81560000E-04  -3.62070000E-04  +3.31560000E-04  -5.00520000E-04
   +1.09259000E-03  +2.90470000E-04  -7.03000000E-06  +2.49620000E-04  -8.40600000E-05
   +1.58700000E-05  -8.79000000E-06  -3.03000000E-06  -1.53000000E-05  -9.09000000E-06
   +2.05000000E-06  +5.72000000E-06  -8.19900000E-05  +1.56800000E-05  +4.66000000E-06
   -1.50400000E-05  -1.41700000E-05  -5.11000000E-06  -1.03700000E-05  +8.91000000E-06
   -1.30830000E-04  -5.54700000E-05  +5.04020000E-04  -8.91630000E-04  +1.09493000E-03
   -2.49920000E-04  +5.77530000E-04  +7.85570000E-04  -3.98810000E-04  +8.63900000E-05
   +4.10400000E-05  +1.51500000E-04  -4.75200000E-05  -5.40900000E-05  -2.56800000E-05
   -7.31700000E-05  +8.52000000E-06  -8.29200000E-05  -2.04777300E-02  +1.02846570E-01
   +1.04529660E-01  -4.43900000E-05  +1.20900000E-05  +3.74400000E-05  +7.90800000E-05
   +4.27400000E-05  -7.82900000E-05  +2.66100000E-05  +2.62200000E-05  +2.97000000E-05
   -2.91500000E-05  +1.13000000E-06  +1.87700000E-05  -3.14800000E-05  +1.67000000E-06
   -1.18400000E-05  +3.62100000E-05  -4.85000000E-06  -8.21000000E-06  -2.18890000E-04
   +3.87400000E-05  -3.82000000E-06  -4.37000000E-06  -4.26700000E-05  -8.48000000E-06
   +1.12900000E-05  +3.71000000E-06  -1.21600000E-05  +4.01637000E-03  +7.52590000E-04
   -9.24250000E-04  +6.66590000E-04  +4.93920000E-04  -1.99520000E-04  +7.02864000E-03
   +4.67295000E-03  +7.70570000E-04  +7.66772000E-03  +2.28900000E-04  +8.67282000E-03
   -4.46608400E-02  +9.75182000E-03  +2.74161600E-02  +3.64127000E-03  -1.48534000E-03
   -3.45756000E-03  -4.49690000E-04  -3.04020000E-04  -9.68300000E-05  +5.60890000E-04
   -9.44750000E-04  -9.49610000E-04  -5.04303000E-03  -2.08939000E-03  -1.02049000E-03
   +3.77900000E-05  +4.67500000E-05  -5.37300000E-05  -2.47000000E-06  -2.68000000E-06
   +5.72000000E-06  -7.65000000E-06  -3.78000000E-06  +7.26000000E-06  +7.02000000E-06
   -1.22200000E-05  -5.13000000E-06  -1.94000000E-06  -8.40000000E-07  -6.75000000E-06
   -1.77000000E-06  -3.33000000E-06  -1.55000000E-06  +7.29000000E-06  +1.00700000E-05
   +1.12300000E-05  -1.69500000E-05  +1.58600000E-05  -9.97000000E-06  +2.34000000E-05
   -2.14100000E-05  +9.19000000E-06  -2.11000000E-06  -8.61000000E-06  -2.20000000E-07
   -1.58000000E-06  -1.63000000E-06  +2.73000000E-06  -6.70000000E-06  -1.62600000E-05
   -9.48000000E-06  -2.06707000E-03  -4.75310000E-04  -3.62100000E-05  +2.99765900E-02
   -7.21300000E-05  -5.47000000E-06  +2.86600000E-05  +1.54990000E-04  -1.56460000E-04
   +9.39200000E-05  -5.57000000E-06  -8.10000000E-07  +1.11600000E-05  -1.87600000E-05
   +6.15000000E-06  +1.65000000E-05  +8.30000000E-06  -3.10000000E-07  -1.14300000E-05
   -2.20000000E-07  +1.65100000E-05  +1.36700000E-05  -1.75940000E-04  +5.96100000E-04
   +7.77660000E-04  -3.26000000E-05  +1.04330000E-04  -1.51700000E-05  -2.29000000E-05
   -1.80000000E-06  +1.33400000E-05  +1.10308000E-03  -3.48300000E-03  +3.19950000E-03
   +1.20521000E-03  -7.10410000E-04  +8.41700000E-05  +2.99383000E-03  -5.08123000E-03
   -1.76239000E-03  +4.28986000E-03  +6.97360000E-04  -2.97175400E-02  +8.08794000E-03
   -6.97087600E-02  -5.09709600E-02  -2.27269000E-03  +8.58640000E-03  +2.32390900E-02
   -3.36590000E-04  +1.42210000E-04  -1.39280000E-04  -2.14920000E-04  -5.02800000E-04
   +3.29240000E-04  -1.61020000E-03  +1.92620000E-03  +4.42440000E-04  -5.40000000E-05
   -1.16350000E-04  +4.74200000E-05  +1.47000000E-06  +3.00000000E-08  +2.08000000E-06
   -6.58000000E-06  -1.09000000E-06  +2.72000000E-06  -1.90000000E-06  -5.29000000E-06
   -2.37000000E-06  +5.50000000E-06  -8.49000000E-06  -4.93000000E-06  -6.15000000E-06
   +1.00000000E-07  +5.60000000E-06  +9.72000000E-06  -2.69600000E-05  -1.89600000E-05
   +4.14500000E-05  -1.51300000E-05  -1.10000000E-05  -2.56300000E-05  -2.13000000E-05
   -2.98000000E-06  +7.27000000E-06  -3.14000000E-06  +5.74000000E-06  +1.67700000E-05
   +1.20100000E-05  -9.19000000E-06  +5.74800000E-05  -1.32300000E-05  +3.61900000E-05
   -5.85860000E-04  +7.83000000E-04  -4.21910000E-04  -1.14145600E-02  +6.65311300E-02
   +7.29300000E-05  +1.17900000E-05  -1.34000000E-06  -1.49780000E-04  +1.48590000E-04
   -6.88200000E-05  +5.73000000E-06  +6.72000000E-06  -1.89100000E-05  +4.08000000E-06
   +2.76000000E-06  -3.15400000E-05  -7.03700000E-05  -3.26000000E-06  +4.47500000E-05
   +2.83200000E-05  -1.27100000E-05  -1.33000000E-05  +2.58700000E-05  -6.20360000E-04
   -3.66550000E-04  +1.58100000E-05  -6.69800000E-05  -6.22600000E-05  +8.91600000E-05
   +5.42000000E-06  -5.98200000E-05  -1.44230000E-04  +3.37044000E-03  -4.46590000E-04
   -2.68680000E-04  -2.66700000E-05  +8.10920000E-04  +6.36580000E-04  -1.35311000E-03
   -1.28580000E-04  +7.66000000E-04  +1.76612000E-03  -7.49855000E-03  +2.80050800E-02
   -5.39194400E-02  -3.30062990E-01  +2.25573000E-03  -6.23171000E-03  -1.33535100E-02
   -2.93800000E-05  -8.39500000E-05  -1.53140000E-04  +1.81550000E-04  -6.15000000E-05
   +1.15440000E-04  -4.41960000E-04  +4.24550000E-04  +1.06316000E-03  +7.61900000E-05
   +1.78010000E-04  -1.11990000E-04  -1.53700000E-05  -9.00000000E-07  +2.59000000E-06
   +1.45800000E-05  -8.30000000E-07  -4.61000000E-06  -2.93800000E-05  -7.17000000E-06
   -4.31000000E-06  -6.91000000E-06  +3.25000000E-06  +9.99000000E-06  +7.20000000E-06
   -1.70000000E-06  -9.14000000E-06  -7.02000000E-06  +4.32700000E-05  +3.32000000E-06
   -1.32600000E-05  +5.30000000E-07  +5.17000000E-06  +1.07700000E-05  -7.00000000E-08
   +7.79000000E-06  -4.50000000E-07  -1.27100000E-05  -1.10000000E-07  +4.92000000E-06
   -9.39000000E-06  +1.73300000E-05  -7.06400000E-05  +1.45300000E-05  -5.53200000E-05
   -2.62390000E-04  +2.19260000E-04  +7.72180000E-04  -3.05733800E-02  +5.61403500E-02
   +3.49724230E-01  +6.68500000E-05  -1.39500000E-05  +6.86700000E-05  -1.68190000E-04
   +1.00360000E-04  +5.59600000E-05  -6.04000000E-06  -9.62000000E-06  -5.18200000E-05
   -2.09200000E-05  -2.11800000E-05  -1.54900000E-05  -1.18240000E-04  +3.04000000E-06
   -9.27000000E-06  +7.86900000E-05  -9.08000000E-06  -1.56700000E-05  +6.95390000E-04
   +2.70700000E-05  +2.46850000E-04  -1.05000000E-06  +1.34590000E-04  -1.37620000E-04
   +1.26120000E-04  -9.95000000E-06  -7.11500000E-05  +1.94790000E-04  +2.94456000E-03
   +2.66788000E-03  +1.31909900E-02  +3.77229000E-03  +5.45430000E-04  -3.07626300E-02
   -4.18622800E-02  -1.96748700E-02  +6.14825000E-03  +9.35792000E-03  +8.57485000E-03
   +3.18207000E-03  -4.61635000E-03  +1.51278000E-03  -6.13030000E-04  +1.87410000E-03
   -3.77991000E-03  -2.85890000E-03  -1.28998000E-03  +1.45682000E-03  -2.26622200E-02
   -1.49698100E-02  +3.48474000E-03  -1.95559000E-03  -9.13550000E-04  -9.64900000E-04
   +6.60400000E-05  +1.68900000E-05  -5.46000000E-06  -1.66400000E-05  +1.91000000E-05
   -6.02000000E-06  +4.68600000E-05  +3.85800000E-05  -1.25300000E-05  -1.09020000E-04
   +4.72900000E-05  +3.42000000E-05  -3.08000000E-06  -1.59000000E-06  +1.62100000E-05
   +1.09500000E-05  +6.88000000E-06  -7.26000000E-06  -5.68900000E-05  +6.82700000E-05
   +2.05000000E-06  +1.35900000E-05  -3.34400000E-05  +8.55000000E-06  -2.44700000E-05
   -3.23400000E-05  -1.76900000E-05  +8.23000000E-06  -4.15900000E-05  -6.27000000E-06
   +2.93800000E-05  -3.90000000E-06  +2.61600000E-05  -1.72100000E-05  +2.90100000E-05
   -2.18400000E-05  +1.17400000E-04  +4.94200000E-05  -3.62600000E-05  -1.07783000E-03
   -2.40740000E-04  +9.51700000E-05  +4.48063800E-02  -2.22600000E-05  +1.85200000E-05
   -2.62800000E-05  +1.76540000E-04  +1.05300000E-05  -9.34800000E-05  -3.48800000E-05
   +1.45900000E-05  -4.97000000E-06  +1.21200000E-05  -9.49000000E-06  +4.56000000E-06
   +5.45700000E-05  -2.25000000E-06  -1.51000000E-05  -4.33500000E-05  +1.09100000E-05
   +3.29300000E-05  -1.37820000E-04  -5.13190000E-04  -8.03350000E-04  +5.13300000E-05
   -1.93840000E-04  +3.23080000E-04  -5.55700000E-05  +2.88000000E-06  +4.24400000E-05
   -1.95391000E-03  -6.20740000E-04  +3.60554000E-03  -1.10017000E-03  -1.53257300E-02
   -1.03812000E-02  -3.65846000E-02  -3.10632010E-01  -8.80624300E-02  +1.40822000E-03
   -2.99267000E-03  +1.58387000E-03  -1.15633000E-03  +1.06684000E-03  -7.86910000E-04
   +2.06570000E-04  +1.62220000E-04  +1.76680000E-04  +1.58001000E-03  +3.33546000E-03
   -1.38798000E-03  -1.75519000E-03  +2.21009000E-03  +4.77010000E-04  +5.85210000E-04
   +2.27023000E-03  -5.58000000E-06  -9.47800000E-05  -4.87000000E-06  -8.41400000E-05
   +8.26000000E-06  -4.10000000E-06  -4.11000000E-06  -8.23000000E-06  -2.43000000E-06
   +5.70000000E-07  +2.42200000E-05  -4.58000000E-06  +1.35300000E-05  +9.51000000E-06
   -1.42000000E-05  +3.53000000E-06  -5.35000000E-06  -5.26000000E-06  +7.13000000E-06
   +2.99700000E-05  -1.20130000E-04  -4.38200000E-05  +7.70000000E-07  +6.41000000E-06
   -1.82600000E-05  +6.46000000E-06  +2.39400000E-05  +2.71000000E-06  +3.87500000E-05
   +2.79100000E-05  +6.62500000E-05  +1.34800000E-05  -1.40000000E-06  -1.10100000E-05
   +3.10400000E-05  +1.92500000E-05  +3.09500000E-05  +3.68200000E-05  -2.17900000E-05
   -3.18400000E-05  -1.35700000E-04  -1.58410000E-04  -2.07000000E-05  +3.96495400E-02
   +3.21860000E-01  -1.43700000E-05  -2.51800000E-05  +4.89200000E-05  -1.07240000E-04
   -7.56000000E-06  +9.16000000E-05  +2.68500000E-05  +3.24500000E-05  -7.75000000E-06
   -1.46100000E-05  +6.29000000E-06  +3.48900000E-05  -2.04700000E-05  +1.80000000E-07
   -1.31200000E-05  +3.58200000E-05  -8.60000000E-06  -3.14600000E-05  -1.75180000E-04
   +7.04640000E-04  +5.64290000E-04  -5.22900000E-05  +1.69240000E-04  -2.31600000E-04
   +3.85000000E-06  -3.46000000E-06  -6.35000000E-06  +1.19408000E-03  +6.81930000E-04
   -3.86968000E-03  +5.82480000E-04  +1.85711200E-02  +8.93723000E-03  -1.48898000E-02
   -8.66496200E-02  -8.59372600E-02  -4.24242000E-03  -3.03851500E-02  -3.97761000E-03
   -8.18700000E-05  +8.67160000E-04  -6.24800000E-03  -6.25110000E-04  +5.19510000E-04
   +6.17250000E-04  +2.44520000E-04  -1.05822000E-03  +1.98956000E-03  +2.93976000E-03
   +3.02939000E-03  +8.55400000E-05  +3.86130000E-04  +7.37700000E-04  +3.28600000E-03
   +7.52600000E-05  -8.22000000E-06  +1.05720000E-04  +1.30000000E-06  +1.79000000E-06
   +2.48000000E-06  -1.97000000E-06  -3.67000000E-06  +1.75000000E-06  +1.71300000E-05
   -2.33000000E-06  -2.94300000E-05  -7.80000000E-06  +1.26600000E-05  -7.03000000E-06
   +2.21000000E-06  +5.82000000E-06  -3.37000000E-06  -1.42200000E-05  +9.32200000E-05
   +5.47400000E-05  -1.52800000E-05  +7.87000000E-06  +1.05700000E-05  +9.18000000E-06
   -5.49000000E-06  -4.60000000E-06  -3.73600000E-05  -1.07100000E-05  -4.51500000E-05
   -2.54000000E-05  -3.36000000E-06  -4.00000000E-06  -2.48000000E-06  -2.90700000E-05
   -1.10200000E-05  +2.71900000E-05  -4.41300000E-05  +7.81300000E-05  +1.41794000E-03
   -1.06273000E-03  -1.98380000E-04  +1.34714100E-02  +9.45789800E-02  +8.46446100E-02
   -1.26030000E-04  -3.28700000E-04  -4.79690000E-04  +1.42378000E-03  -5.56770000E-04
   -8.09700000E-05  -3.09660000E-04  -2.30100000E-05  +6.28330000E-04  -4.13340000E-04
   +2.96040000E-04  +6.38600000E-05  +3.20680000E-04  -7.29000000E-05  +4.80170000E-04
   -5.80660000E-04  +8.86100000E-05  -4.45700000E-05  +1.62382000E-03  +1.53440000E-04
   +8.89360000E-04  -2.24750000E-04  -4.42700000E-04  +5.16460000E-04  -3.64890000E-04
   +1.14340000E-04  +9.56900000E-05  -2.15918100E-02  +3.22325500E-02  +2.87198500E-02
   +1.12269500E-02  +1.55886000E-03  -3.28013500E-02  +5.49734900E-02  -5.23564600E-02
   +7.28497000E-03  -1.61164000E-03  +1.00550300E-02  +2.87265600E-02  +3.90221000E-03
   -2.66942500E-02  +5.11837000E-03  -2.03539000E-03  +9.61999000E-03  -3.16051400E-02
   -1.43141800E-02  -2.19131000E-03  +1.25870000E-04  -2.11008900E-02  -5.46711800E-02
   +4.53968900E-02  -1.64722000E-03  +4.39311000E-03  -4.28208000E-03  -4.40690000E-04
   -8.15540000E-04  +8.43000000E-05  -1.37600000E-05  -1.36270000E-04  +8.24800000E-05
   -2.13830000E-04  -2.53790000E-04  +3.28900000E-05  +1.43630000E-04  -1.05703000E-03
   -2.78140000E-04  -1.45000000E-05  -1.95300000E-05  -1.89170000E-04  -5.08000000E-05
   +4.75700000E-05  +1.99500000E-05  +2.53700000E-05  -2.76000000E-04  +5.26900000E-05
   -2.18990000E-04  +1.48040000E-04  +7.11700000E-05  +6.77900000E-05  -3.40700000E-05
   -1.73130000E-04  -2.62000000E-06  +1.13670000E-04  -1.20370000E-04  -1.65410000E-04
   +1.17340000E-04  -5.39400000E-05  +3.28340000E-04  -1.06500000E-04  +1.68220000E-04
   +8.91910000E-04  +3.66620000E-04  -4.29610000E-04  +3.44600000E-05  -6.93980000E-04
   -7.97500000E-05  -6.44758000E-03  +3.52670000E-04  +1.32199000E-03  +3.40511000E-03
   -7.59800000E-05  +4.09300000E-05  +1.43490000E-04  -2.66680000E-04  -4.04200000E-04
   +5.66300000E-04  -4.14600000E-05  -4.46680000E-04  +8.59710000E-04  -2.14800000E-04
   -4.99500000E-05  -1.35130000E-04  -4.17730000E-04  -3.57700000E-05  +7.61100000E-05
   +2.32490000E-04  -4.11200000E-05  -1.06280000E-04  -1.86464000E-03  +1.14590000E-04
   -6.91180000E-04  -2.28690000E-04  +4.28300000E-05  -1.51330000E-04  +4.59420000E-04
   -3.67700000E-05  -3.40260000E-04  +2.71556000E-02  -2.13347900E-02  -1.89211600E-02
   -8.19915200E-02  -2.05041100E-02  +1.80501600E-02  -7.34960900E-02  +2.31097700E-02
   +6.01672000E-03  +3.96656000E-03  -5.02297000E-03  -1.38535300E-02  -1.36614000E-03
   +1.42559600E-02  -2.73055000E-03  +2.30114000E-03  -6.67762000E-03  +1.58761400E-02
   +2.57930000E-04  -3.23660000E-04  -5.71210000E-03  +2.94697400E-02  +1.55756200E-02
   -3.24265600E-02  +1.51550000E-04  -1.78156000E-03  +1.26631000E-03  +1.49310000E-04
   +7.40820000E-04  -1.34810000E-04  -7.69100000E-05  +6.24300000E-05  +2.48200000E-05
   +1.06070000E-04  +1.09070000E-04  +1.12200000E-05  -3.42040000E-04  -7.99960000E-04
   -4.04010000E-04  -2.77100000E-05  +9.61000000E-06  -1.75000000E-06  +1.17200000E-05
   +1.04900000E-05  -2.97400000E-05  -2.52000000E-05  +1.05720000E-04  +2.41900000E-05
   -7.49000000E-06  +9.59000000E-05  +4.50600000E-05  +5.16800000E-05  -1.78800000E-05
   +4.10200000E-05  +8.46000000E-06  -7.77300000E-05  +5.94000000E-05  -6.07000000E-06
   -5.86500000E-05  +2.70200000E-05  -1.99770000E-04  +1.88100000E-05  -1.44110000E-04
   -1.62263000E-03  -2.98080000E-04  +3.14710000E-04  -9.53000000E-06  +2.54040000E-04
   -8.84000000E-06  +6.31623000E-03  +6.65500000E-05  -9.55240000E-04  +8.81296300E-02
   +3.01570000E-03  -3.47600000E-05  -7.48300000E-05  +1.41000000E-06  -1.88360000E-04
   +3.60920000E-04  -3.25730000E-04  +1.65650000E-04  +3.64970000E-04  +4.48110000E-04
   +5.40300000E-05  -6.23200000E-05  -1.66810000E-04  +6.53500000E-05  +6.85000000E-06
   -5.18700000E-05  -1.60000000E-07  -5.78000000E-06  -5.82100000E-05  +3.40640000E-04
   -2.69800000E-04  +6.95180000E-04  +8.22600000E-05  -1.12220000E-04  -8.84800000E-05
   -3.21300000E-05  -6.70000000E-07  -3.86000000E-06  -5.83073000E-03  +1.33231800E-02
   +1.17594800E-02  +6.92528300E-02  -3.39980000E-03  -4.00903100E-02  +4.97184900E-02
   -1.11698700E-02  -3.73466000E-03  -4.75240000E-04  +4.00301000E-03  +1.11061700E-02
   +2.20805000E-03  -1.39599500E-02  +2.93238000E-03  -3.13730000E-04  +4.42015000E-03
   -1.74585400E-02  -3.25468600E-02  -5.82173000E-03  -7.93914000E-03  -1.80356700E-02
   -5.92907000E-03  -1.19930900E-02  -2.16550000E-04  +7.53330000E-04  -1.54240000E-04
   -2.02700000E-05  -3.31400000E-05  -1.39530000E-04  +7.79000000E-06  +2.29000000E-06
   +1.00600000E-05  -1.68600000E-05  +3.01000000E-06  +2.47300000E-05  -1.59350000E-04
   -3.68730000E-04  +1.33600000E-05  -3.02000000E-06  -5.81000000E-06  -1.60700000E-05
   +1.58000000E-06  +1.35700000E-05  -2.69000000E-06  -4.20300000E-05  +1.95200000E-05
   +4.33400000E-05  -7.22800000E-05  -6.36000000E-06  +9.75000000E-06  +3.25900000E-05
   -1.14300000E-05  -1.60500000E-05  -1.71000000E-05  -1.14010000E-04  -1.02900000E-05
   +1.62900000E-05  +4.59900000E-05  -1.72100000E-05  +1.69700000E-05  +3.70000000E-06
   -5.28800000E-05  +3.72890000E-04  +2.66780000E-04  -3.89000000E-05  -3.35910000E-04
   -3.65920000E-04  +4.17600000E-05  -5.63773000E-03  +2.08120000E-04  +7.75410000E-04
   -5.38769100E-02  +3.26295200E-02  +5.01316000E-02  -1.25600000E-05  -2.27000000E-06
   +7.30000000E-07  +6.46000000E-06  +1.20500000E-05  -1.27900000E-05  +2.00700000E-05
   -2.50000000E-07  +2.71900000E-05  -2.31000000E-06  +6.87000000E-06  +6.53000000E-06
   +1.70600000E-05  +3.55000000E-06  -2.60000000E-06  -2.54000000E-06  -5.66000000E-06
   -1.27100000E-05  -1.98500000E-04  -1.17120000E-04  -9.35800000E-05  +7.44000000E-06
   -3.84600000E-05  +2.30600000E-05  -2.69200000E-05  +3.01000000E-06  +7.94000000E-06
   -6.90000000E-06  -4.58690000E-04  -5.05930000E-04  -7.16320000E-04  +1.21126000E-03
   +1.68900000E-04  +2.38021000E-03  -2.13689000E-03  +2.29083000E-03  -2.76215000E-03
   -4.50480000E-04  +2.24675000E-03  +3.69530000E-04  -5.95630000E-04  +6.33250000E-04
   +1.32219000E-03  -1.02420000E-03  +5.99030000E-04  +1.48680000E-04  -3.36310000E-04
   +5.32640000E-04  -2.17216000E-03  +2.01464000E-03  -2.10167000E-03  -3.08709490E-01
   +2.43413180E-01  +1.11530770E-01  +1.80200000E-05  +1.05620000E-04  -3.06500000E-05
   +5.84000000E-06  -6.53000000E-06  +6.36000000E-06  -1.36100000E-05  -9.63000000E-06
   +6.12000000E-06  +1.30300000E-05  -2.01800000E-05  -2.25000000E-06  -4.69000000E-06
   +8.12000000E-06  -7.65000000E-06  -3.00000000E-07  +1.48000000E-06  -1.63000000E-06
   +1.50000000E-07  -8.58000000E-06  +3.54000000E-06  -1.42300000E-05  +8.91000000E-06
   +5.40000000E-06  +3.23000000E-06  -1.18000000E-06  -2.79000000E-06  -4.66000000E-06
   -1.42000000E-06  -2.12400000E-05  +2.11000000E-06  +4.97000000E-06  +7.16000000E-06
   -2.95500000E-05  -1.63800000E-05  -2.92900000E-05  +4.89000000E-06  -1.33940000E-04
   +6.31600000E-05  -3.82040000E-04  -8.44700000E-05  -1.40730000E-04  -3.66440000E-04
   -1.89540000E-04  -8.67380000E-04  +1.88880000E-03  -7.39670000E-04  +1.69710000E-04
   +3.09072910E-01  +5.05200000E-05  +5.21000000E-06  +3.07500000E-05  -1.21410000E-04
   +1.36370000E-04  -2.54700000E-05  +3.34700000E-05  +8.85000000E-06  +3.21100000E-05
   -2.86300000E-05  +2.29700000E-05  -8.11400000E-05  -1.97920000E-04  -7.84000000E-06
   +1.35720000E-04  +7.64400000E-05  -1.40900000E-05  -2.46000000E-05  +1.77210000E-04
   -2.59040000E-04  +2.00700000E-04  +2.24800000E-05  +1.18700000E-05  -9.98800000E-05
   +2.24920000E-04  +3.95000000E-06  -1.69280000E-04  -5.18510000E-04  +1.39435000E-03
   +8.60620000E-04  -1.20030000E-04  -1.45351000E-03  +5.46690000E-04  +1.10470000E-04
   +3.37949000E-03  -2.31291000E-03  +2.72172800E-02  -3.23946900E-02  -4.81182000E-03
   +8.42340000E-04  -2.33304000E-03  +5.64709000E-03  -6.61620000E-04  -1.08373000E-03
   -2.33087000E-03  -9.51100000E-05  -1.45860000E-04  -7.10390000E-04  +2.18460000E-04
   -3.18670000E-04  -4.27560000E-04  +2.12986860E-01  -1.85931720E-01  -5.99214100E-02
   +5.36100000E-05  +1.70770000E-04  -7.41500000E-05  -4.46600000E-05  +3.53000000E-06
   +2.28900000E-05  +1.82100000E-05  -4.97000000E-06  +6.40000000E-06  -6.55700000E-05
   -4.41400000E-05  -1.48800000E-05  -1.22500000E-05  +1.67000000E-06  +1.23100000E-05
   +6.76000000E-06  +2.12000000E-06  -1.83900000E-05  -1.71700000E-05  +5.94400000E-05
   -1.02900000E-05  -7.33000000E-06  -2.64500000E-05  +8.24000000E-06  +8.60000000E-07
   -2.36000000E-05  +7.22000000E-06  +1.24600000E-05  -3.01600000E-05  +5.30000000E-07
   +4.99200000E-05  -1.19000000E-05  +2.73900000E-05  -5.91000000E-05  +3.44800000E-05
   -8.36600000E-05  +1.50700000E-05  -2.03200000E-04  +2.59690000E-04  +4.95870000E-04
   +3.74820000E-04  +6.94100000E-05  +3.77600000E-05  +8.48400000E-05  -4.92500000E-05
   -2.80920000E-04  -4.04400000E-05  -8.51700000E-05  -2.40393220E-01  +2.18438460E-01
   +2.12500000E-05  +3.64000000E-06  -2.24700000E-05  -3.97700000E-05  +6.43400000E-05
   -1.90200000E-05  +1.91400000E-05  -4.01900000E-05  -1.28000000E-05  +2.20100000E-05
   -3.01500000E-05  +9.20000000E-07  +5.10300000E-05  +1.33200000E-05  -4.92000000E-05
   -4.21000000E-06  -1.73400000E-05  -1.09700000E-05  +4.50700000E-05  -1.87500000E-04
   -5.97100000E-05  +1.51800000E-05  -2.75900000E-05  -7.23000000E-06  -4.51500000E-05
   -1.84600000E-05  +3.22900000E-05  -4.32690000E-04  +1.11234000E-03  +6.68630000E-04
   +8.91010000E-04  -6.32430000E-04  -1.33940000E-04  -3.46790000E-03  +3.51808000E-03
   +2.13990000E-04  -2.44191400E-02  +2.27810900E-02  +4.82178000E-03  -4.57740000E-04
   +2.46709000E-03  -2.14482000E-03  +8.98460000E-04  -1.06320000E-04  -1.20790000E-04
   +8.79700000E-05  -4.10970000E-04  +4.57320000E-04  +2.07260000E-03  -2.92565000E-03
   +1.43478000E-03  +1.41087040E-01  -9.00582400E-02  -7.89430700E-02  +2.49200000E-05
   +1.16530000E-04  -3.64800000E-05  +1.67600000E-05  +1.58400000E-05  -6.56000000E-06
   +4.96000000E-06  +1.95300000E-05  +1.28000000E-06  -1.08600000E-05  +3.92600000E-05
   +1.54600000E-05  -1.21000000E-06  +1.56900000E-05  +2.33000000E-06  +3.45000000E-06
   +4.36000000E-06  -2.70000000E-07  -8.03000000E-06  +2.80000000E-07  -2.89000000E-06
   +5.47000000E-06  -3.95000000E-06  -3.99000000E-06  -8.42000000E-06  -5.84000000E-06
   -1.21000000E-06  -2.33600000E-05  -1.65000000E-06  -3.66200000E-05  +2.36200000E-05
   +2.05000000E-06  +1.82000000E-06  -3.72900000E-05  -1.78400000E-05  -4.29600000E-05
   +3.56100000E-05  +1.15640000E-04  -1.28440000E-04  -2.93770000E-04  +8.26400000E-05
   +1.59800000E-05  -5.36360000E-04  -4.68670000E-04  -1.11666000E-03  -1.58322000E-03
   +7.30150000E-04  -1.67240000E-04  -1.14417100E-01  +6.35415900E-02  +7.57487100E-02
   +5.14600000E-05  +4.21200000E-05  +3.29800000E-05  -1.06670000E-04  -7.17000000E-06
   -3.42500000E-05  +2.70000000E-07  +7.90100000E-05  +3.69600000E-05  -7.28000000E-06
   +2.00500000E-05  -4.79500000E-05  -5.84200000E-05  -1.06700000E-05  +5.20400000E-05
   +4.11000000E-06  +1.18000000E-05  -1.08100000E-05  +7.26700000E-05  -3.90540000E-04
   +1.22960000E-04  -4.84100000E-05  +2.43100000E-05  -1.19180000E-04  +8.17900000E-05
   +8.50000000E-06  -6.37100000E-05  +4.61200000E-04  -1.41000000E-05  +2.18607000E-03
   -3.48592000E-03  +5.20940000E-04  -5.25870000E-04  +2.35106000E-03  +3.72370000E-04
   +1.73829000E-03  +7.78420000E-04  -7.82000000E-06  +7.69090000E-04  -2.63900000E-05
   -9.80990000E-04  +4.83900000E-04  -3.93370000E-04  +8.23580000E-04  -1.13758000E-03
   -5.26521960E-01  -7.98041800E-02  -4.07453400E-02  -6.20480000E-04  -4.02200000E-04
   +1.30233000E-03  -1.18810000E-04  -9.30700000E-05  +3.89880000E-04  -1.67880000E-04
   +5.32320000E-04  +1.98810000E-04  -1.57400000E-05  -3.60000000E-06  +5.58000000E-06
   +6.21000000E-06  -2.51000000E-06  +1.24000000E-06  -1.87600000E-05  -1.44400000E-05
   -3.63600000E-05  +1.63000000E-05  -2.82200000E-05  -1.76300000E-05  +3.73000000E-06
   -4.89000000E-06  -5.10000000E-06  -6.83000000E-06  +6.41500000E-05  -3.36000000E-06
   -2.92000000E-06  +1.32000000E-05  +3.55100000E-05  -2.08300000E-05  -1.69300000E-05
   -2.71500000E-05  +3.81000000E-04  +4.97930000E-04  -4.39920000E-04  -1.19390000E-04
   +2.04660000E-04  +1.95340000E-04  -1.46860000E-04  -3.64300000E-05  -6.21100000E-05
   +2.35700000E-05  +8.05100000E-05  +2.28340000E-04  -5.91400000E-05  -2.31400000E-05
   +1.65000000E-05  -7.78750000E-04  +1.65320000E-04  -6.51400000E-04  -6.98890000E-04
   +3.51320000E-04  -2.48783000E-03  -4.04200000E-05  +4.60600000E-05  -6.76100000E-05
   +5.29644060E-01  -1.19160000E-04  -9.12000000E-06  -1.70280000E-04  -1.36720000E-04
   -4.09600000E-05  +3.21560000E-04  +1.78000000E-05  +5.18600000E-05  -2.41430000E-04
   +1.67060000E-04  -1.03500000E-05  -7.54500000E-05  -1.97410000E-04  +1.50500000E-05
   +2.01610000E-04  +8.35900000E-05  -1.85800000E-05  +1.40390000E-04  -9.24810000E-04
   -2.93010000E-04  -4.53720000E-04  +4.55950000E-04  -4.70600000E-05  +1.80570000E-04
   +3.05890000E-04  -1.78600000E-05  -1.92790000E-04  -2.62963000E-03  +9.96680000E-04
   -3.19500000E-05  -1.10118900E-02  -4.62477000E-03  -2.35123000E-03  +1.34523000E-03
   +2.03169000E-03  +1.11158000E-03  -9.21550000E-04  -1.06290000E-04  -8.90100000E-05
   +1.56700000E-05  -3.91370000E-04  -2.81060000E-04  +9.16700000E-04  +4.59070000E-04
   -6.70900000E-04  -6.69156600E-02  -1.35275900E-02  -1.72081500E-02  +2.61610000E-04
   -8.60820000E-04  +8.78600000E-05  +1.86100000E-04  -4.93860000E-04  +9.67400000E-05
   -2.98240000E-04  -1.28889000E-03  -2.02191000E-03  -4.48800000E-05  +1.83500000E-05
   +1.64200000E-05  +5.02600000E-05  +6.04000000E-06  -1.01300000E-05  +2.17700000E-05
   +7.22000000E-06  +3.99100000E-05  +6.89000000E-06  -1.02000000E-04  +2.21620000E-04
   +1.25000000E-06  +2.02600000E-05  -2.14800000E-05  -2.84200000E-05  -5.91200000E-05
   +1.07800000E-05  -3.52800000E-05  -2.37000000E-05  -6.90000000E-05  +1.15130000E-04
   +1.70380000E-04  +1.53070000E-04  +1.21956000E-03  -1.42184000E-03  +2.20331000E-03
   +1.24300000E-05  +6.02600000E-05  +1.17120000E-04  +1.55470000E-04  +9.35090000E-04
   +6.46280000E-04  +1.80610000E-04  +5.81500000E-05  +1.92000000E-05  -3.01000000E-06
   -6.86600000E-05  +4.09600000E-05  +2.32810000E-04  -4.98350000E-04  +3.84750000E-04
   -9.58470000E-04  -6.57800000E-05  -1.06014000E-03  +1.34250000E-04  +7.13400000E-05
   +1.60880000E-04  +7.82477400E-02  +1.88523700E-02  +1.46660000E-04  -7.00200000E-05
   +2.14040000E-04  +9.55000000E-06  +8.45500000E-05  -1.73600000E-05  -4.89200000E-05
   +5.42300000E-05  -4.20600000E-05  -1.17640000E-04  +2.87400000E-05  -3.16500000E-05
   -9.70000000E-05  -3.96200000E-05  +8.06100000E-05  +4.13000000E-05  -2.64100000E-05
   -6.25900000E-05  -9.60800000E-05  -6.27990000E-04  +8.18700000E-05  -1.61570000E-04
   +5.35400000E-05  -1.40140000E-04  +9.90900000E-05  +1.27000000E-05  -1.00720000E-04
   -1.33978000E-03  +7.90750000E-04  +1.95009000E-03  -4.22035800E-02  -8.49890000E-03
   -1.72470500E-02  +3.01890000E-04  -2.83868000E-03  +3.90480000E-04  +1.30897000E-03
   +6.14420000E-04  +1.00475000E-03  +8.34300000E-05  -1.46307000E-03  +3.48690000E-04
   +5.93670000E-04  +8.31750000E-04  -1.96719000E-03  +7.41701000E-03  -9.94577000E-03
   -3.62249500E-02  -1.38084000E-03  +4.79890000E-04  +1.59690000E-03  -1.70670000E-04
   -1.37310000E-04  +2.48370000E-04  -8.28000000E-06  +6.76270000E-04  +5.35010000E-04
   -2.04800000E-05  -5.12000000E-06  +9.82000000E-06  +2.73000000E-06  -8.88000000E-06
   -3.54000000E-06  -3.22900000E-05  +3.50000000E-07  -1.94800000E-05  -6.00500000E-05
   +1.25890000E-04  -5.30600000E-05  +2.37800000E-05  +2.47700000E-05  -2.41200000E-05
   +7.86000000E-06  +5.83400000E-05  -3.66000000E-06  +1.53200000E-05  -8.14000000E-06
   +2.10000000E-05  -3.23900000E-05  -6.00300000E-05  -4.27500000E-05  -4.46760000E-04
   +8.03730000E-04  +1.45550000E-04  +1.72830000E-04  -3.49370000E-04  -2.31740000E-04
   +7.02400000E-05  -7.29500000E-05  -2.11120000E-04  +1.40000000E-04  +7.26500000E-05
   +9.22200000E-05  -1.03620000E-04  -3.78300000E-05  +8.76000000E-06  -7.75690000E-04
   +8.97340000E-04  -1.04780000E-04  -1.29481000E-03  -4.21520000E-04  -4.81354000E-03
   -5.48300000E-05  +6.76600000E-05  -6.74600000E-05  +3.86897400E-02  +1.88001900E-02
   +5.47290200E-02  -2.28200000E-05  -6.47000000E-06  +3.45700000E-05  +5.08000000E-06
   +5.19000000E-06  -2.51800000E-05  +2.64100000E-05  -8.75700000E-05  -1.56720000E-04
   +3.04500000E-05  +7.26100000E-05  +8.83200000E-05  +6.27000000E-05  +5.65000000E-06
   -4.92000000E-05  +1.33000000E-05  -6.56000000E-06  -1.59700000E-05  +7.69800000E-05
   -7.96400000E-05  +8.40600000E-05  +5.91000000E-06  +1.77000000E-06  +2.49300000E-05
   -9.41500000E-05  +2.91400000E-05  +5.35300000E-05  -1.51536000E-03  +1.01198000E-03
   +2.12533000E-03  +3.01312000E-03  +4.39553000E-03  -5.92246000E-03  +1.53039000E-02
   +5.95506000E-03  +4.87352000E-03  -6.00330000E-03  +3.00965000E-03  +5.49763000E-03
   +5.49500000E-05  -4.63318000E-03  +5.06820000E-04  -1.10800000E-05  +2.00558000E-03
   -2.79773000E-03  -2.09056000E-03  -1.46650000E-03  -9.23760000E-04  -7.03529500E-02
   +1.05533290E-01  +1.10625970E-01  +3.20220000E-04  -5.12790000E-04  -4.09800000E-04
   -4.80000000E-07  -3.73900000E-05  +4.42000000E-05  +1.87800000E-05  -4.52700000E-05
   +1.01100000E-05  -3.79600000E-05  -6.61800000E-05  -1.33900000E-05  -9.39000000E-06
   +1.13650000E-04  +3.27900000E-05  -6.15000000E-06  +7.10000000E-06  -4.24000000E-06
   -8.00000000E-08  +4.36000000E-06  -3.12000000E-06  +2.70000000E-06  -9.92000000E-06
   -1.20100000E-05  +4.76000000E-06  -1.38200000E-05  -2.08000000E-06  -1.48700000E-05
   -4.29000000E-06  -1.48100000E-05  -1.36600000E-05  -2.05800000E-05  -3.53700000E-05
   +3.84000000E-06  +3.68000000E-06  +2.92000000E-06  +1.54400000E-05  -1.55400000E-05
   -2.46000000E-06  +1.72580000E-04  +2.12600000E-05  -3.68800000E-05  +2.87870000E-04
   -8.33500000E-05  -8.51000000E-06  -7.17250000E-04  -1.16369000E-03  +8.95400000E-05
   -7.66882000E-03  +3.90188000E-03  -2.16163000E-03  +1.85200000E-04  -7.35600000E-05
   +5.28260000E-04  -4.11740000E-04  +9.13300000E-05  -6.78810000E-04  +6.93664500E-02
   +2.51500000E-05  -1.40600000E-05  +2.58700000E-05  +5.31800000E-05  +7.37800000E-05
   -1.39300000E-05  +5.65700000E-05  +4.72600000E-05  -2.13060000E-04  -7.62100000E-05
   +1.47420000E-04  +2.72300000E-05  -1.40390000E-04  -8.37000000E-06  +1.88760000E-04
   +2.40200000E-05  -2.09000000E-06  -1.40000000E-06  +6.15200000E-05  -1.43580000E-04
   +1.66700000E-05  -2.60600000E-05  -4.34200000E-05  -1.02600000E-05  +1.21530000E-04
   +3.48100000E-05  -1.00220000E-04  -1.43635000E-03  +1.99301000E-03  +1.86029000E-03
   +8.78004000E-03  +5.93500000E-04  -1.74441000E-03  +1.20180200E-02  +2.58510000E-04
   +4.11738000E-03  -2.79581000E-03  +2.88969000E-03  +3.28238000E-03  -2.25870000E-04
   -2.06064000E-03  +1.43011000E-03  -5.97670000E-04  +9.51800000E-05  -2.08395000E-03
   -1.92010000E-04  +2.35400000E-05  +6.56560000E-04  +1.08665910E-01  -2.80854600E-01
   -2.21113000E-01  +8.59600000E-05  -8.75900000E-05  -9.49300000E-05  -6.23000000E-06
   +8.52400000E-05  -4.11500000E-05  -4.53100000E-05  -4.13400000E-05  +2.91300000E-05
   -3.52200000E-05  -8.92200000E-05  -2.00400000E-05  -1.57400000E-05  +3.48700000E-05
   -1.45600000E-05  -1.05200000E-05  -5.00000000E-08  -2.81000000E-06  -2.68000000E-06
   -1.20000000E-06  -1.07600000E-05  +4.29000000E-06  -1.96000000E-06  -1.02300000E-05
   -1.55500000E-05  -3.74000000E-06  +2.02700000E-05  +3.31000000E-06  -5.38000000E-06
   -3.78000000E-06  +1.54300000E-05  +5.60000000E-07  -5.47000000E-06  +7.23000000E-06
   +2.40000000E-07  +1.56400000E-05  -1.53200000E-05  +7.70000000E-06  -3.62500000E-05
   +6.90600000E-05  +4.74300000E-05  -2.95000000E-05  +3.84860000E-04  +5.87200000E-05
   -3.97000000E-06  -6.56370000E-04  -6.57200000E-05  -9.26900000E-05  -5.81812000E-03
   +3.88880000E-04  -1.35681600E-02  -1.57210000E-04  +1.22550000E-04  +1.48450000E-04
   -2.65010000E-04  +2.16190000E-04  +1.33860000E-04  -1.17842410E-01  +2.76303860E-01
   -3.05000000E-06  -7.12000000E-06  -1.27000000E-05  -1.09310000E-04  +1.28700000E-05
   +4.66800000E-05  -2.52600000E-05  -2.57500000E-05  +8.04600000E-05  +7.54600000E-05
   -7.43500000E-05  -2.40000000E-06  +3.00800000E-05  +1.55600000E-05  -7.29600000E-05
   +6.01000000E-06  -2.74700000E-05  -3.44700000E-05  -1.15870000E-04  +5.96200000E-05
   -1.49000000E-05  +2.39800000E-05  +3.06000000E-05  -3.64900000E-05  -2.24600000E-05
   -4.61700000E-05  +1.64800000E-05  +4.65660000E-04  -1.98317000E-03  -2.00508000E-03
   -8.22843000E-03  +1.83160000E-03  +9.58200000E-04  -2.13900000E-03  -2.13466000E-03
   -3.56784000E-03  +2.52958000E-03  -1.56459000E-03  -1.13796000E-03  +1.85630000E-04
   +1.84168000E-03  -4.07390000E-04  +2.45520000E-04  -2.46520000E-04  +1.59774000E-03
   +4.08240000E-04  -1.71590000E-04  -6.85710000E-04  +1.11296410E-01  -2.25283930E-01
   -2.18741910E-01  -1.22350000E-04  +2.14800000E-05  +3.06340000E-04  +2.85300000E-05
   +4.54700000E-05  +2.36400000E-05  +3.05200000E-05  +4.57600000E-05  -5.98000000E-06
   +1.43300000E-05  +3.89200000E-05  +1.66500000E-05  -8.80000000E-06  +1.44400000E-05
   +5.10000000E-07  +3.90000000E-07  +1.04400000E-05  +8.37000000E-06  +2.16000000E-06
   +1.57300000E-05  -1.42000000E-06  -1.92000000E-06  +1.74500000E-05  +4.29000000E-06
   +1.65800000E-05  -9.96000000E-06  -1.17100000E-05  -3.96000000E-06  +6.06000000E-06
   +9.27000000E-06  -1.76900000E-05  -1.20100000E-05  -5.84000000E-06  +1.58400000E-05
   -7.87000000E-06  -8.07000000E-06  -1.58200000E-05  -3.43000000E-06  -9.88000000E-06
   +3.90000000E-06  -2.21400000E-05  +2.46300000E-05  -1.98750000E-04  -1.74800000E-05
   +6.37000000E-06  -4.83890000E-04  +1.94620000E-04  +5.18550000E-04  +7.49280000E-03
   +4.06060000E-04  +9.34659000E-03  -2.42800000E-05  -2.25880000E-04  -2.80480000E-04
   -2.40000000E-06  -6.17000000E-06  -4.82300000E-05  -1.11348350E-01  +2.27261920E-01
   +2.14126670E-01
end_hess

